// var formatCurrency = new Intl.NumberFormat('en-US', {
//     style: 'currency',
//     currency: 'USD',
//     minimumFractionDigits: 0,
//     maximumFractionDigits: 0
// }).format;

//console.log("La resolución de tu pantalla es: " + screen.width + " x " + screen.height);

if (screen.width > 1366) {
    var list_h = parseFloat(screen.height) - parseInt(415);
    var cone_h = parseFloat(screen.height) - parseInt(550);
    var text_h = 100;
}else if(screen.width > 992 && screen.width <= 1366){
    var list_h = parseFloat(screen.height) - parseInt(320);
    var cone_h = parseFloat(screen.height) - parseInt(450);
    var text_h = 100;
}else if(screen.width > 768 && screen.width <= 992){
    var list_h = parseFloat(screen.height) - parseInt(350);
}else if(screen.width > 576 && screen.width <= 768){
    var list_h = 300;
}else if(screen.width <= 576){
    var list_h = 300;
}

$("#divListAccounts").dxList({
    height: list_h,
    searchEnabled: true,
    searchExpr: "busqueda",
    itemTemplate: function(itemData, itemIndex, itemElement){
        itemElement.append('<p><strong>Cuenta: ' + itemData.idaccount + '</strong> <span style="float:right; color:#02779E; font-size:12px;">' + itemData.server_name + '</span></p>');
        itemElement.append('<p>' + itemData.descrip + ' <span style="float:right; color:red; font-size:11px;">' + itemData.ncomercial + '</span></p>');
    },
    nextButtonText: "Mostrar Más",
    searchEditorOptions: {
        placeholder: "Buscar"
    },
    onItemClick: function(e){
        popupDetailAccount(e.itemData);
    }
});

$("#btnRefresh").dxButton({
    icon: "refresh",
    type: "default",
    stylingMode: "contained",
    onClick: function(e){
        $.ajax({
            type:"POST",
            url: "getListadoCuentas",
            dataType: "json",
            success: function(data){
                $(".v-title").text(data.totalDay);
                $("#totalActive").text(data.totalAcc);
                $("#totalConect").text(data.totalCon);
                
                $("#dataGridConnections").dxDataGrid("instance").option('dataSource', data.dataHour);
            }
        });
    }
});

$("#btnCerrar").dxButton({
    icon: "fa fa-lock",
    type: "danger",
    stylingMode: "contained",
    onClick: function(e){
        window.location.href = "http://www.goxpos.com/sAdminLogout";
    }
});

$("#toolTipbtnRefresh").dxTooltip({
    target: "#btnRefresh",
    showEvent: "mouseenter",
    hideEvent: "mouseleave",
    position: "top"
});

$("#toolTipbtnCerrar").dxTooltip({
    target: "#btnCerrar",
    showEvent: "mouseenter",
    hideEvent: "mouseleave",
    position: "top"
});

$.ajax({
    type:"POST",
    url: "getListadoCuentas",
    dataType: "json",
    success: function(data){
        $(".v-title").text(data.totalDay);
        $("#totalActive").text(data.totalAcc);
        $("#totalConect").text(data.totalCon);

        $("#divListAccounts").dxList("instance").option('dataSource', data.listAcco);
        $("#dataGridConnections").dxDataGrid("instance").option('dataSource', data.dataHour);
    }
});

$("#dataGridConnections").dxDataGrid({
    showColumnLines: true,
    showRowLines: false,
    hoverStateEnabled: false,
    rowAlternationEnabled: true,
    allowColumnReordering: false,
    width: "100%",
    height: cone_h,
    noDataText: "No se han encontrado datos",
    showBorders: false,
    selection: {
        mode: "single"
    },
    loadPanel:{
        enabled: true,
        text: "Procesando"
    },
    scrolling: {
        mode: 'infinite'
    },
    columnHidingEnabled: false,
    sorting:{
        ascendingText: "Ascendente",
        clearText: "Reiniciar",
        descendingText: "Descendente"
    },
    columns:[{
        caption:   "Hora",
        dataField: "hora",
        alignment: "center"
    },{
        caption:   "Conexiones",
        dataField: "conexiones",
        alignment: "center"
    },{
        caption:   "%",
        dataField: "porcentaje",
        alignment: "right"
    }],
    summary: {
        totalItems: [{
            column: "conexiones",
            displayFormat: "{0}",
            summaryType: "sum",
            valueFormat: {type: "#,##0", precision: 0},
        }],
        groupItems: [{
            column: "conexiones",
            displayFormat: "{0}",
            summaryType: "sum",
            valueFormat: {type: "#,##0", precision: 0},
            showInGroupFooter: true
        }]
    },
    onCellClick: function(e){
        
    }
});

function popupDetailAccount(itemData){
    $("#popupDetailAccount").remove();
    $(".containerList").append('<div id="popupDetailAccount"></div>');
    
    $("#popupDetailAccount").dxPopup({
        fullScreen: false,
        shading: true,
        showCloseButton: true,
        title: itemData.descrip,
        width: 500,
        height: "auto",
        contentTemplate: function (contentElement){
            contentElement.attr('style', 'padding:0px;');
            
            var contentString = '<div class="v-card"><div class="v-card__title"><div class="col-md-12 col-12 p-t-10 p-b-10 fs-16 text-center"><span>Conexiones Del Día</span></div></div><div class="v-title txt-number">0</div><div class="v-subtitle m-b-13">TOTAL</div><div class="v-card_total"><div class="col-md-6 col-6 p-t-0 p-b-0 text-center"><span>Conexiones Totales: <strong id="totalAccConect">0</strong></span></div></div></div>';
            
            contentElement.append(contentString);
            contentElement.append('<div id="divListConexiones"></div>');
            contentElement.append('<div class="col-sm-12 col-12 p-l-5 p-r-5 p-b-5 m-t-5"><p class="p-motivo">Motivo de conexión:</p><div id="inputTextConnect"></div><div id="btnConnect" class="m-t-5"></div></div>');
            contentElement.append('<input type="hidden" id="idcuenta_sys" value="' + itemData.idaccount + '">');
            
            $("#divListConexiones").dxList({
                height: 200,
                noDataText: "No se han encontrado datos",
                itemTemplate: function(itemData, itemIndex, itemElement){
                    itemElement.append('<p class="fs-11 float-r text-red"><strong>' + itemData.time + '</strong></p>');
                    itemElement.append('<p class="fs-11 text-red"><strong>' + itemData.date + '</strong></p>');
                    itemElement.append('<p class="fs-12"><strong>Usuario:</strong> ' + itemData.descrip + '</p>');
                    itemElement.append('<p class="fs-12"><strong>&nbsp;&nbsp;Motivo:</strong> ' + itemData.notas + '</p>');
                },
                nextButtonText: "Mostrar Más",
                searchEditorOptions: {
                    placeholder: "Buscar"
                },
                onItemClick: function(e){
                }
            });

            $("#inputTextConnect").dxTextArea({
                name: "inputTextConnect",
                stylingMode: "filled",
                height: text_h,
                value: ""
            }).dxValidator({
                validationRules: [{
                    type: "required",
                    message: "Motivo de Conexión es requerido"
                }],
                validationGroup: 'validationGroup'
            });

            $("#btnConnect").dxButton({
                icon: "key",
                text: "Ingresar",
                type: "success",
                width: "100%",
                useSubmitBehavior: true,
                stylingMode: "contained",
                onClick: function(e){ 
                    var result = e.validationGroup.validate();
                    if(result.isValid){
                        $("#btnConnect").dxButton("instance").option('disabled', true);
                        
                        $.ajax({
                            type:"POST",
                            url: "validateLoginSadmin",
                            dataType: "json",
                            data: { idaccount: $("#idcuenta_sys").val(), notas: $("textarea[name='inputTextConnect']").val() },
                            success: function(data){
                                $("#popupDetailAccount").dxPopup("instance").hide();
                                window.open('http://www.goxpos.com/Bienvenidos', '_blank');
                            }
                        });
                    }else{
                        $("#inputTextConnect").dxTextArea("instance").focus();
                        DevExpress.ui.notify('¡Campos incompletos! Por favor ingresar motivo de conexión', 'error', 2000);
                    }
                },
                validationGroup: 'validationGroup'
            });

            $.ajax({
                type:"POST",
                url: "getDetalleConexionesCuenta",
                dataType: "json",
                data: { idaccount: itemData.idaccount },
                success: function(data){
                    $(".txt-number").text(data.totalDay);
                    $("#totalAccConect").text(data.totalGlo);
                    $("#divListConexiones").dxList("instance").option("dataSource", data.connections);
                }
            });
        }
    });
    
    $("#popupDetailAccount").dxPopup("instance").show();
}