/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 21.2.3
 * Build date: Thu Oct 28 2021
 *
 * Copyright (c) 2012 - 2021 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var e = {
            23908:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/easing.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.convertTransitionTimingFuncToEasing = void 0, t.getEasing = function(e) {
                        return s[e]
                    }, t.setEasing = function(e) {
                        s = e
                    };
                    var i = n( /*! ../core/utils/type */ 35922),
                        o = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,
                        a = {
                            linear: "cubic-bezier(0, 0, 1, 1)",
                            swing: "cubic-bezier(0.445, 0.05, 0.55, 0.95)",
                            ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
                            "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
                            "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
                            "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
                        },
                        s = {};
                    t.convertTransitionTimingFuncToEasing = function(e) {
                        var t, n = (e = a[e] || e).match(o);
                        n || (n = a[t = "linear"].match(o)), n = n.slice(1, 5);
                        for (var l = 0; l < n.length; l++) {
                            n[l] = parseFloat(n[l])
                        }
                        var u = t || "cubicbezier_" + n.join("_").replace(/\./g, "p");
                        return (0, i.isFunction)(s[u]) || (s[u] = function(e, t, i, o, a) {
                            return o * function(e, t, n, i) {
                                var o = 3 * e,
                                    a = 3 * (n - e) - o,
                                    r = 1 - o - a,
                                    s = 3 * t,
                                    l = 3 * (i - t) - s,
                                    u = 1 - s - l,
                                    d = function(e) {
                                        return e * (o + e * (a + e * r))
                                    },
                                    c = function(e) {
                                        return o + e * (2 * a + 3 * e * r)
                                    };
                                return function(e) {
                                    return function(e) {
                                        return e * (s + e * (l + e * u))
                                    }(function(e) {
                                        for (var t, n = e, i = 0; i < 14 && (t = d(n) - e, !(Math.abs(t) < .001));) {
                                            n -= t / c(n), i++
                                        }
                                        return n
                                    }(e))
                                }
                            }(n[0], n[1], n[2], n[3])(t / a) + i
                        }), u
                    }
                },
            90057:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/frame.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.cancelAnimationFrame = function() {
                        u(), l.apply(r, arguments)
                    }, t.requestAnimationFrame = function() {
                        return u(), s.apply(r, arguments)
                    };
                    var i, o = n( /*! ../core/utils/window */ 58201),
                        a = (i = n( /*! ../core/utils/call_once */ 39618)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = (0, o.hasWindow)() ? (0, o.getWindow)() : {},
                        s = function(e) {
                            return setTimeout(e, 16.666666666666668)
                        },
                        l = function(e) {
                            clearTimeout(e)
                        },
                        u = (0, a.default)((function() {
                            var e = r.requestAnimationFrame || r.webkitRequestAnimationFrame || r.mozRequestAnimationFrame || r.oRequestAnimationFrame || r.msRequestAnimationFrame,
                                t = r.cancelAnimationFrame || r.webkitCancelAnimationFrame || r.mozCancelAnimationFrame || r.oCancelAnimationFrame || r.msCancelAnimationFrame;
                            if (e && t && (s = e, l = t), e && !t) {
                                var n = {};
                                s = function(t) {
                                    var i = e.call(r, (function() {
                                        try {
                                            if (i in n) {
                                                return
                                            }
                                            t.apply(this, arguments)
                                        } finally {
                                            delete n[i]
                                        }
                                    }));
                                    return i
                                }, l = function(e) {
                                    n[e] = !0
                                }
                            }
                        }))
                },
            87209:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/fx.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = b(n( /*! ../core/renderer */ 68374)),
                        o = n( /*! ../core/utils/window */ 58201),
                        a = b(n( /*! ../events/core/events_engine */ 55994)),
                        r = b(n( /*! ../core/errors */ 17381)),
                        s = n( /*! ../core/element */ 6415),
                        l = n( /*! ../core/utils/extend */ 13306),
                        u = n( /*! ../core/utils/type */ 35922),
                        d = n( /*! ../core/utils/iterator */ 95479),
                        c = n( /*! ./translator */ 31648),
                        h = n( /*! ./easing */ 23908),
                        f = n( /*! ./frame */ 90057),
                        p = n( /*! ../core/utils/support */ 60137),
                        g = b(n( /*! ./position */ 49387)),
                        m = n( /*! ../core/remove_event */ 37819),
                        _ = n( /*! ../events/utils/index */ 39611),
                        v = n( /*! ../core/utils/deferred */ 62754),
                        y = n( /*! ../core/utils/common */ 20576);

                    function b(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function x(e) {
                        return x = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, x(e)
                    }
                    var w = (0, o.getWindow)(),
                        C = (0, _.addNamespace)(m.removeEvent, "dxFX"),
                        S = /^([+-])=(.*)/i,
                        k = "dxAnimData",
                        I = "dxAnimQueue",
                        D = {
                            initAnimation: function(e, t) {
                                e.css({
                                    transitionProperty: "none"
                                }), "string" == typeof t.from ? e.addClass(t.from) : U(e, t.from);
                                var n = this,
                                    i = new v.Deferred,
                                    o = t.cleanupWhen;
                                t.transitionAnimation = {
                                    deferred: i,
                                    finish: function() {
                                        n._finishTransition(e), o ? (0, v.when)(i, o).always((function() {
                                            n._cleanup(e, t)
                                        })) : n._cleanup(e, t), i.resolveWith(e, [t, e])
                                    }
                                }, this._completeAnimationCallback(e, t).done((function() {
                                    t.transitionAnimation.finish()
                                })).fail((function() {
                                    i.rejectWith(e, [t, e])
                                })), t.duration || t.transitionAnimation.finish(), e.css("transform")
                            },
                            animate: function(e, t) {
                                return this._startAnimation(e, t), t.transitionAnimation.deferred.promise()
                            },
                            _completeAnimationCallback: function(e, t) {
                                var n, i = this,
                                    o = Date.now() + t.delay,
                                    r = new v.Deferred,
                                    s = new v.Deferred,
                                    l = new v.Deferred,
                                    u = (0, p.transitionEndEventName)() + ".dxFX";
                                t.transitionAnimation.cleanup = function() {
                                    clearTimeout(n), clearTimeout(d), a.default.off(e, u), a.default.off(e, C)
                                }, a.default.one(e, u, (function() {
                                    Date.now() - o >= t.duration && s.reject()
                                })), a.default.off(e, C), a.default.on(e, C, (function() {
                                    i.stop(e, t), r.reject()
                                }));
                                var d = setTimeout((function() {
                                    n = setTimeout((function() {
                                        l.reject()
                                    }), t.duration + t.delay + Y._simulatedTransitionEndDelay), (0, v.when)(s, l).fail(function() {
                                        r.resolve()
                                    }.bind(this))
                                }));
                                return r.promise()
                            },
                            _startAnimation: function(e, t) {
                                e.css({
                                    transitionProperty: "all",
                                    transitionDelay: t.delay + "ms",
                                    transitionDuration: t.duration + "ms",
                                    transitionTimingFunction: t.easing
                                }), "string" == typeof t.to ? e[0].className += " " + t.to : t.to && U(e, t.to)
                            },
                            _finishTransition: function(e) {
                                e.css("transition", "none")
                            },
                            _cleanup: function(e, t) {
                                t.transitionAnimation.cleanup(), "string" == typeof t.from && (e.removeClass(t.from), e.removeClass(t.to))
                            },
                            stop: function(e, t, n) {
                                t && (n ? t.transitionAnimation.finish() : ((0, u.isPlainObject)(t.to) && (0, d.each)(t.to, (function(t) {
                                    e.css(t, e.css(t))
                                })), this._finishTransition(e), this._cleanup(e, t)))
                            }
                        },
                        T = {
                            initAnimation: function(e, t) {
                                U(e, t.from)
                            },
                            animate: function(e, t) {
                                var n = new v.Deferred,
                                    i = this;
                                return t ? ((0, d.each)(t.to, (function(n) {
                                    void 0 === t.from[n] && (t.from[n] = i._normalizeValue(e.css(n)))
                                })), t.to.transform && (t.from.transform = i._parseTransform(t.from.transform), t.to.transform = i._parseTransform(t.to.transform)), t.frameAnimation = {
                                    to: t.to,
                                    from: t.from,
                                    currentValue: t.from,
                                    easing: (0, h.convertTransitionTimingFuncToEasing)(t.easing),
                                    duration: t.duration,
                                    startTime: (new Date).valueOf(),
                                    finish: function() {
                                        this.currentValue = this.to, this.draw(), (0, f.cancelAnimationFrame)(t.frameAnimation.animationFrameId), n.resolve()
                                    },
                                    draw: function() {
                                        if (t.draw) {
                                            t.draw(this.currentValue)
                                        } else {
                                            var n = (0, l.extend)({}, this.currentValue);
                                            n.transform && (n.transform = (0, d.map)(n.transform, (function(e, t) {
                                                return "translate" === t ? (0, c.getTranslateCss)(e) : "scale" === t ? "scale(" + e + ")" : "rotate" === t.substr(0, t.length - 1) ? t + "(" + e + "deg)" : void 0
                                            })).join(" ")), e.css(n)
                                        }
                                    }
                                }, t.delay ? (t.frameAnimation.startTime += t.delay, t.frameAnimation.delayTimeout = setTimeout((function() {
                                    i._startAnimation(e, t)
                                }), t.delay)) : i._startAnimation(e, t), n.promise()) : n.reject().promise()
                            },
                            _startAnimation: function(e, t) {
                                a.default.off(e, C), a.default.on(e, C, (function() {
                                    t.frameAnimation && (0, f.cancelAnimationFrame)(t.frameAnimation.animationFrameId)
                                })), this._animationStep(e, t)
                            },
                            _parseTransform: function(e) {
                                var t = {};
                                return (0, d.each)(e.match(/\w+\d*\w*\([^)]*\)\s*/g), (function(e, n) {
                                    var i = (0, c.parseTranslate)(n),
                                        o = n.match(/scale\((.+?)\)/),
                                        a = n.match(/(rotate.)\((.+)deg\)/);
                                    i && (t.translate = i), o && o[1] && (t.scale = parseFloat(o[1])), a && a[1] && (t[a[1]] = parseFloat(a[2]))
                                })), t
                            },
                            stop: function(e, t, n) {
                                var i = t && t.frameAnimation;
                                i && ((0, f.cancelAnimationFrame)(i.animationFrameId), clearTimeout(i.delayTimeout), n && i.finish(), delete t.frameAnimation)
                            },
                            _animationStep: function(e, t) {
                                var n = t && t.frameAnimation;
                                if (n) {
                                    var i = (new Date).valueOf();
                                    if (i >= n.startTime + n.duration) {
                                        n.finish()
                                    } else {
                                        n.currentValue = this._calcStepValue(n, i - n.startTime), n.draw();
                                        var o = this;
                                        n.animationFrameId = (0, f.requestAnimationFrame)((function() {
                                            o._animationStep(e, t)
                                        }))
                                    }
                                }
                            },
                            _calcStepValue: function(e, t) {
                                return function n(i, o) {
                                    var a = Array.isArray(o) ? [] : {};
                                    return (0, d.each)(o, (function(r, s) {
                                        if ("string" == typeof s && !1 === parseFloat(s, 10)) {
                                            return !0
                                        }
                                        a[r] = "object" === x(s) ? n(i[r], s) : function(n) {
                                            var a = t / e.duration,
                                                r = t,
                                                s = 1 * i[n],
                                                l = o[n] - i[n],
                                                u = e.duration;
                                            return (0, h.getEasing)(e.easing)(a, r, s, l, u)
                                        }(r)
                                    })), a
                                }(e.from, e.to)
                            },
                            _normalizeValue: function(e) {
                                var t = parseFloat(e, 10);
                                return !1 === t ? e : t
                            }
                        },
                        E = {
                            initAnimation: function() {},
                            animate: function() {
                                return (new v.Deferred).resolve().promise()
                            },
                            stop: y.noop,
                            isSynchronous: !0
                        },
                        A = function(e, t, n, i) {
                            (0, d.each)(["from", "to"], (function() {
                                if (!n(e[this])) {
                                    throw r.default.Error("E0010", t, this, i)
                                }
                            }))
                        },
                        O = function(e, t) {
                            return A(e, t, (function(e) {
                                return (0, u.isPlainObject)(e)
                            }), "a plain object")
                        },
                        P = {
                            top: {
                                my: "bottom center",
                                at: "top center"
                            },
                            bottom: {
                                my: "top center",
                                at: "bottom center"
                            },
                            right: {
                                my: "left center",
                                at: "right center"
                            },
                            left: {
                                my: "right center",
                                at: "left center"
                            }
                        },
                        M = {
                            validateConfig: function(e) {
                                O(e, "slide")
                            },
                            setup: function(e, t) {
                                var n = (0, c.locate)(e);
                                if ("slide" !== t.type) {
                                    var i = "slideIn" === t.type ? t.from : t.to;
                                    i.position = (0, l.extend)({
                                        of: w
                                    }, P[t.direction]), K(e, i)
                                }
                                this._setUpConfig(n, t.from), this._setUpConfig(n, t.to), (0, c.clearCache)(e)
                            },
                            _setUpConfig: function(e, t) {
                                t.left = "left" in t ? t.left : "+=0", t.top = "top" in t ? t.top : "+=0", this._initNewPosition(e, t)
                            },
                            _initNewPosition: function(e, t) {
                                var n = {
                                    left: t.left,
                                    top: t.top
                                };
                                delete t.left, delete t.top;
                                var i = this._getRelativeValue(n.left);
                                void 0 !== i ? n.left = i + e.left : t.left = 0, void 0 !== (i = this._getRelativeValue(n.top)) ? n.top = i + e.top : t.top = 0, t.transform = (0, c.getTranslateCss)({
                                    x: n.left,
                                    y: n.top
                                })
                            },
                            _getRelativeValue: function(e) {
                                var t;
                                if ("string" == typeof e && (t = S.exec(e))) {
                                    return parseInt(t[1] + "1") * t[2]
                                }
                            }
                        },
                        R = {
                            setup: function(e, t) {
                                var n, i, o = t.from,
                                    a = t.to,
                                    r = "fadeOut" === t.type ? 1 : 0,
                                    s = "fadeOut" === t.type ? 0 : 1,
                                    l = (0, u.isPlainObject)(o) ? String(null !== (n = o.opacity) && void 0 !== n ? n : r) : String(o),
                                    d = (0, u.isPlainObject)(a) ? String(null !== (i = a.opacity) && void 0 !== i ? i : s) : String(a);
                                switch (t.skipElementInitialStyles || (l = e.css("opacity")), t.type) {
                                    case "fadeIn":
                                        d = 1;
                                        break;
                                    case "fadeOut":
                                        d = 0
                                }
                                t.from = {
                                    visibility: "visible",
                                    opacity: l
                                }, t.to = {
                                    opacity: d
                                }
                            }
                        },
                        B = {
                            custom: {
                                setup: function() {}
                            },
                            slide: M,
                            slideIn: M,
                            slideOut: M,
                            fade: R,
                            fadeIn: R,
                            fadeOut: R,
                            pop: {
                                validateConfig: function(e) {
                                    O(e, "pop")
                                },
                                setup: function(e, t) {
                                    var n = t.from,
                                        i = t.to,
                                        o = "opacity" in n ? n.opacity : e.css("opacity"),
                                        a = "opacity" in i ? i.opacity : 1,
                                        r = "scale" in n ? n.scale : 0,
                                        s = "scale" in i ? i.scale : 1;
                                    t.from = {
                                        opacity: o
                                    };
                                    var l = (0, c.getTranslate)(e);
                                    t.from.transform = this._getCssTransform(l, r), t.to = {
                                        opacity: a
                                    }, t.to.transform = this._getCssTransform(l, s)
                                },
                                _getCssTransform: function(e, t) {
                                    return (0, c.getTranslateCss)(e) + "scale(" + t + ")"
                                }
                            },
                            css: {
                                validateConfig: function(e) {
                                    ! function(e, t) {
                                        A(e, "css", (function(e) {
                                            return "string" == typeof e
                                        }), "a string")
                                    }(e)
                                },
                                setup: function() {}
                            }
                        },
                        F = {
                            type: "custom",
                            from: {},
                            to: {},
                            duration: 400,
                            start: y.noop,
                            complete: y.noop,
                            easing: "ease",
                            delay: 0
                        },
                        V = {
                            duration: 400,
                            easing: "ease",
                            delay: 0
                        };

                    function H() {
                        var e = this,
                            t = e.element,
                            n = e.config;
                        if (K(t, n.from), K(t, n.to), e.configurator.setup(t, n), t.data(k, e), Y.off && (n.duration = 0, n.delay = 0), e.strategy.initAnimation(t, n), n.start) {
                            var i = (0, s.getPublicElement)(t);
                            n.start.apply(this, [i, n])
                        }
                    }
                    var L = function() {
                            var e = this,
                                t = e.element,
                                n = e.config;
                            return e.isStarted = !0, e.strategy.animate(t, n).done((function() {
                                ! function(e) {
                                    var t = e.element,
                                        n = e.config;
                                    if (t.removeData(k), n.complete) {
                                        var i = (0, s.getPublicElement)(t);
                                        n.complete.apply(this, [i, n])
                                    }
                                    e.deferred.resolveWith(this, [t, n])
                                }(e)
                            })).fail((function() {
                                e.deferred.rejectWith(this, [t, n])
                            }))
                        },
                        N = function(e) {
                            var t = this,
                                n = t.element,
                                i = t.config;
                            clearTimeout(t.startTimeout), t.isStarted || t.start(), t.strategy.stop(n, i, e)
                        },
                        z = (0, _.addNamespace)(m.removeEvent, "dxFXStartAnimation"),
                        W = function(e, t) {
                            var n = "css" === t.type ? V : F,
                                o = (0, l.extend)(!0, {}, n, t),
                                s = function(e) {
                                    var t = B[e.type];
                                    if (!t) {
                                        throw r.default.Error("E0011", e.type)
                                    }
                                    return t
                                }(o),
                                d = function(e) {
                                    e = e || {};
                                    var t = {
                                            transition: (0, p.transition)() ? D : T,
                                            frame: T,
                                            noAnimation: E
                                        },
                                        n = e.strategy || "transition";
                                    return "css" !== e.type || (0, p.transition)() || (n = "noAnimation"), t[n]
                                }(o),
                                c = {
                                    element: (0, i.default)(e),
                                    config: o,
                                    configurator: s,
                                    strategy: d,
                                    isSynchronous: d.isSynchronous,
                                    setup: H,
                                    start: L,
                                    stop: N,
                                    deferred: new v.Deferred
                                };
                            return (0, u.isFunction)(s.validateConfig) && s.validateConfig(o),
                                function(e) {
                                    a.default.off(e.element, z), a.default.on(e.element, z, (function() {
                                        Y.stop(e.element)
                                    })), e.deferred.always((function() {
                                        a.default.off(e.element, z)
                                    }))
                                }(c), c
                        };

                    function q(e) {
                        return e.data(I) || []
                    }
                    var $ = function(e) {
                        e.removeData(I)
                    };

                    function G(e) {
                        return !!e.data(k)
                    }

                    function j(e, t) {
                        if ((t = q(e)).length) {
                            var n = t.shift();
                            0 === t.length && $(e),
                                function(e) {
                                    e.setup(), Y.off || e.isSynchronous ? e.start() : e.startTimeout = setTimeout((function() {
                                        e.start()
                                    }));
                                    return e.deferred.promise()
                                }(n).done((function() {
                                    G(e) || j(e)
                                }))
                        }
                    }

                    function K(e, t) {
                        if (t && t.position) {
                            var n = (0, i.default)(w),
                                o = 0,
                                a = 0,
                                r = g.default.calculate(e, t.position),
                                s = e.offset(),
                                u = e.position();
                            u.top > s.top && (a = n.scrollTop()), u.left > s.left && (o = n.scrollLeft()), (0, l.extend)(t, {
                                left: r.h.location - s.left + u.left - o,
                                top: r.v.location - s.top + u.top - a
                            }), delete t.position
                        }
                    }

                    function U(e, t) {
                        (0, d.each)(t, (function(t, n) {
                            try {
                                e.css(t, (0, u.isFunction)(n) ? n() : n)
                            } catch (e) {}
                        }))
                    }
                    var Y = {
                            off: !1,
                            animationTypes: B,
                            animate: function(e, t) {
                                var n = (0, i.default)(e);
                                if (!n.length) {
                                    return (new v.Deferred).resolve().promise()
                                }
                                var o = W(n, t);
                                return function(e, t) {
                                    var n = q(e);
                                    (function(e, t) {
                                        e.data(I, t)
                                    })(e, n), n.push(t), G(e) || j(e, n)
                                }(n, o), o.deferred.promise()
                            },
                            createAnimation: W,
                            isAnimating: G,
                            stop: function(e, t) {
                                var n = (0, i.default)(e),
                                    o = q(n);
                                (0, d.each)(o, (function(e, t) {
                                    t.config.delay = 0, t.config.duration = 0, t.isSynchronous = !0
                                })), G(n) || j(n, o);
                                var a = n.data(k);
                                a && a.stop(t), n.removeData(k), $(n)
                            },
                            _simulatedTransitionEndDelay: 100
                        },
                        Z = Y;
                    t.default = Z, e.exports = t.default, e.exports.default = t.default
                },
            49387:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/position.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/size */ 58664),
                        o = m(n( /*! ../core/renderer */ 68374)),
                        a = n( /*! ../core/utils/common */ 20576),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = n( /*! ../core/utils/window */ 58201),
                        l = m(n( /*! ../core/dom_adapter */ 73349)),
                        u = n( /*! ../core/utils/type */ 35922),
                        d = n( /*! ../core/utils/extend */ 13306),
                        c = n( /*! ../core/utils/position */ 37518),
                        h = m(n( /*! ../core/utils/browser */ 47810)),
                        f = n( /*! ./translator */ 31648),
                        p = n( /*! ../core/utils/support */ 60137),
                        g = m(n( /*! ../core/devices */ 20530));

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var _, v = (0, s.getWindow)(),
                        y = /left|right/,
                        b = /top|bottom/,
                        x = /fit|flip|none/,
                        w = /scale\(.+?\)/,
                        C = h.default.safari,
                        S = function(e) {
                            var t = {
                                    h: "center",
                                    v: "center"
                                },
                                n = (0, a.splitPair)(e);
                            return n && (0, r.each)(n, (function() {
                                var e = String(this).toLowerCase();
                                y.test(e) ? t.h = e : b.test(e) && (t.v = e)
                            })), t
                        },
                        k = function(e) {
                            return (0, a.pairToObject)(e)
                        },
                        I = function(e) {
                            switch (e) {
                                case "center":
                                    return .5;
                                case "right":
                                case "bottom":
                                    return 1;
                                default:
                                    return 0
                            }
                        },
                        D = function(e) {
                            switch (e) {
                                case "left":
                                    return "right";
                                case "right":
                                    return "left";
                                case "top":
                                    return "bottom";
                                case "bottom":
                                    return "top";
                                default:
                                    return e
                            }
                        },
                        T = function(e, t) {
                            var n = 0;
                            return e.myLocation < t.min && (n += t.min - e.myLocation), e.myLocation > t.max && (n += e.myLocation - t.max), n
                        },
                        E = function(e, t, n) {
                            return t.myLocation < n.min ? "h" === e ? "left" : "top" : t.myLocation > n.max ? "h" === e ? "right" : "bottom" : "none"
                        },
                        A = function(e) {
                            e.myLocation = e.atLocation + I(e.atAlign) * e.atSize - I(e.myAlign) * e.mySize + e.offset
                        },
                        O = {
                            fit: function(e, t) {
                                var n = !1;
                                e.myLocation > t.max && (e.myLocation = t.max, n = !0), e.myLocation < t.min && (e.myLocation = t.min, n = !0), e.fit = n
                            },
                            flip: function(e, t) {
                                if (e.flip = !1, ("center" !== e.myAlign || "center" !== e.atAlign) && (e.myLocation < t.min || e.myLocation > t.max)) {
                                    var n = (0, d.extend)({}, e, {
                                        myAlign: D(e.myAlign),
                                        atAlign: D(e.atAlign),
                                        offset: -e.offset
                                    });
                                    A(n), n.oversize = T(n, t), (n.myLocation >= t.min && n.myLocation <= t.max || e.oversize > n.oversize) && (e.myLocation = n.myLocation, e.oversize = n.oversize, e.flip = !0)
                                }
                            },
                            flipfit: function(e, t) {
                                this.flip(e, t), this.fit(e, t)
                            },
                            none: function(e) {
                                e.oversize = 0
                            }
                        },
                        P = function() {
                            var e = (0, o.default)("<div>").css({
                                    width: 100,
                                    height: 100,
                                    overflow: "scroll",
                                    position: "absolute",
                                    top: -9999
                                }).appendTo((0, o.default)("body")),
                                t = e.get(0).offsetWidth - e.get(0).clientWidth;
                            e.remove(), _ = t
                        },
                        M = {
                            h: {
                                location: 0,
                                flip: !1,
                                fit: !1,
                                oversize: 0
                            },
                            v: {
                                location: 0,
                                flip: !1,
                                fit: !1,
                                oversize: 0
                            }
                        },
                        R = function(e, t) {
                            var n = (0, o.default)(e),
                                r = n.offset(),
                                s = (0, d.extend)(!0, {}, M, {
                                    h: {
                                        location: r.left
                                    },
                                    v: {
                                        location: r.top
                                    }
                                });
                            if (!t) {
                                return s
                            }
                            var h = S(t.my),
                                f = S(t.at),
                                m = (0, o.default)(t.of).length && t.of || v,
                                y = k(t.offset),
                                b = function(e) {
                                    var t = (0, a.splitPair)(e),
                                        n = String(t && t[0]).toLowerCase(),
                                        i = String(t && t[1]).toLowerCase();
                                    return x.test(n) || (n = "none"), x.test(i) || (i = n), {
                                        h: n,
                                        v: i
                                    }
                                }(t.collision),
                                w = t.boundary,
                                I = k(t.boundaryOffset),
                                D = {
                                    mySize: (0, i.getOuterWidth)(n),
                                    myAlign: h.h,
                                    atAlign: f.h,
                                    offset: y.h,
                                    collision: b.h,
                                    boundaryOffset: I.h
                                },
                                R = {
                                    mySize: (0, i.getOuterHeight)(n),
                                    myAlign: h.v,
                                    atAlign: f.v,
                                    offset: y.v,
                                    collision: b.v,
                                    boundaryOffset: I.v
                                };
                            if (m.preventDefault) {
                                D.atLocation = m.pageX, R.atLocation = m.pageY, D.atSize = 0, R.atSize = 0
                            } else if (m = (0, o.default)(m), (0, u.isWindow)(m[0])) {
                                D.atLocation = m.scrollLeft(), R.atLocation = m.scrollTop(), "phone" === g.default.real().deviceType && m[0].visualViewport ? (D.atLocation = Math.max(D.atLocation, m[0].visualViewport.offsetLeft), R.atLocation = Math.max(R.atLocation, m[0].visualViewport.offsetTop), D.atSize = m[0].visualViewport.width, R.atSize = m[0].visualViewport.height) : (D.atSize = m[0].innerWidth > m[0].outerWidth ? m[0].innerWidth : (0, i.getWidth)(m), R.atSize = m[0].innerHeight > m[0].outerHeight || C ? m[0].innerHeight : (0, i.getHeight)(m))
                            } else if (9 === m[0].nodeType) {
                                D.atLocation = 0, R.atLocation = 0, D.atSize = (0, i.getWidth)(m), R.atSize = (0, i.getHeight)(m)
                            } else {
                                var B = (0, c.getBoundingRect)(m.get(0)),
                                    V = F(m);
                                D.atLocation = V.left, R.atLocation = V.top, D.atSize = Math.max(B.width, (0, i.getOuterWidth)(m)), R.atSize = Math.max(B.height, (0, i.getOuterHeight)(m))
                            }
                            A(D), A(R);
                            var H = function() {
                                var e = (0, o.default)(v),
                                    t = (0, i.getWidth)(e),
                                    n = (0, i.getHeight)(e),
                                    a = e.scrollLeft(),
                                    r = e.scrollTop(),
                                    s = l.default.getDocumentElement(),
                                    u = p.touch ? s.clientWidth / t : 1,
                                    d = p.touch ? s.clientHeight / n : 1;
                                void 0 === _ && P();
                                var c = t,
                                    h = n;
                                if (w) {
                                    var f = (0, o.default)(w),
                                        g = f.offset();
                                    a = g.left, r = g.top, c = (0, i.getWidth)(f), h = (0, i.getHeight)(f)
                                }
                                return {
                                    h: {
                                        min: a + D.boundaryOffset,
                                        max: a + c / u - D.mySize - D.boundaryOffset
                                    },
                                    v: {
                                        min: r + R.boundaryOffset,
                                        max: r + h / d - R.mySize - R.boundaryOffset
                                    }
                                }
                            }();
                            D.oversize = T(D, H.h), R.oversize = T(R, H.v), D.collisionSide = E("h", D, H.h), R.collisionSide = E("v", R, H.v), O[D.collision] && O[D.collision](D, H.h), O[R.collision] && O[R.collision](R, H.v);
                            var L = function(e) {
                                return t.precise ? e : Math.round(e)
                            };
                            return (0, d.extend)(!0, s, {
                                h: {
                                    location: L(D.myLocation),
                                    oversize: L(D.oversize),
                                    fit: D.fit,
                                    flip: D.flip,
                                    collisionSide: D.collisionSide
                                },
                                v: {
                                    location: L(R.myLocation),
                                    oversize: L(R.oversize),
                                    fit: R.fit,
                                    flip: R.flip,
                                    collisionSide: R.collisionSide
                                },
                                precise: t.precise
                            }), s
                        },
                        B = function(e, t, n, i, o) {
                            (0, u.isDefined)(e.style) && !l.default.isNode(e.style) ? e.style.transform = o ? n.replace(t, "") : n : e.setAttribute("style", o ? i.replace(t, "") : i)
                        },
                        F = function e(t) {
                            var n, i, o, a = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : t,
                                r = a.get(0);
                            if (!r) {
                                return t.offset()
                            }
                            var s, l = (null === (n = r.getAttribute) || void 0 === n ? void 0 : n.call(r, "style")) || "",
                                u = null === (i = r.style) || void 0 === i ? void 0 : i.transform,
                                d = null === (o = l.match(w)) || void 0 === o ? void 0 : o[0];
                            return d ? (B(r, d, u, l, !0), s = e(t, a.parent()), B(r, d, u, l, !1)) : s = e(t, a.parent()), s
                        },
                        V = function(e, t) {
                            var n = (0, o.default)(e);
                            if (!t) {
                                return n.offset()
                            }(0, f.resetPosition)(n, !0);
                            var i = F(n),
                                a = t.h && t.v ? t : R(n, t),
                                r = function(e) {
                                    return t.precise ? e : Math.round(e)
                                };
                            return (0, f.move)(n, {
                                left: a.h.location - r(i.left),
                                top: a.v.location - r(i.top)
                            }), a
                        };
                    V.inverseAlign || (V.inverseAlign = D), V.normalizeAlign || (V.normalizeAlign = S);
                    var H = {
                        calculateScrollbarWidth: P,
                        calculate: R,
                        setup: V,
                        offset: function(e) {
                            return e = (0, o.default)(e).get(0), (0, u.isWindow)(e) ? null : e && "pageY" in e && "pageX" in e ? {
                                top: e.pageY,
                                left: e.pageX
                            } : (0, o.default)(e).offset()
                        }
                    };
                    t.default = H, e.exports = t.default, e.exports.default = t.default
                },
            42814:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/presets/presets.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.presets = t.PresetCollection = void 0;
                    var i = n( /*! ../../core/utils/size */ 58664),
                        o = n( /*! ../../core/component */ 44297),
                        a = n( /*! ../../core/utils/iterator */ 95479),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = u(n( /*! ../../core/devices */ 20530)),
                        l = u(n( /*! ../fx */ 87209));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = {
                            forward: " dx-forward",
                            backward: " dx-backward",
                            none: " dx-no-direction",
                            undefined: " dx-no-direction"
                        },
                        c = o.Component.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._registeredPresets = [], this.resetToDefaults()
                            },
                            _getDefaultOptions: function() {
                                return (0, r.extend)(this.callBase(), {
                                    defaultAnimationDuration: 400,
                                    defaultAnimationDelay: 0,
                                    defaultStaggerAnimationDuration: 300,
                                    defaultStaggerAnimationDelay: 40,
                                    defaultStaggerAnimationStartDelay: 500
                                })
                            },
                            _defaultOptionsRules: function() {
                                return this.callBase().concat([{
                                    device: function(e) {
                                        return e.phone
                                    },
                                    options: {
                                        defaultStaggerAnimationDuration: 350,
                                        defaultStaggerAnimationDelay: 50,
                                        defaultStaggerAnimationStartDelay: 0
                                    }
                                }, {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    options: {
                                        defaultAnimationDelay: 100
                                    }
                                }])
                            },
                            _getPresetOptionName: function(e) {
                                return "preset_" + e
                            },
                            _createAndroidSlideAnimationConfig: function(e, t) {
                                var n = this,
                                    o = function(e) {
                                        return {
                                            type: "slide",
                                            delay: void 0 === e.delay ? n.option("defaultAnimationDelay") : e.delay,
                                            duration: void 0 === e.duration ? n.option("defaultAnimationDuration") : e.duration
                                        }
                                    };
                                return {
                                    enter: function(n, a) {
                                        var r = (0, i.getWidth)(n.parent()) * t,
                                            s = a.direction,
                                            u = o(a);
                                        return u.to = {
                                            left: 0,
                                            opacity: 1
                                        }, u.from = "forward" === s ? {
                                            left: r,
                                            opacity: e
                                        } : "backward" === s ? {
                                            left: -r,
                                            opacity: e
                                        } : {
                                            left: 0,
                                            opacity: 0
                                        }, l.default.createAnimation(n, u)
                                    },
                                    leave: function(n, a) {
                                        var r = (0, i.getWidth)(n.parent()) * t,
                                            s = a.direction,
                                            u = o(a);
                                        return u.from = {
                                            left: 0,
                                            opacity: 1
                                        }, u.to = "forward" === s ? {
                                            left: -r,
                                            opacity: e
                                        } : "backward" === s ? {
                                            left: r,
                                            opacity: e
                                        } : {
                                            left: 0,
                                            opacity: 0
                                        }, l.default.createAnimation(n, u)
                                    }
                                }
                            },
                            _createOpenDoorConfig: function() {
                                var e = this,
                                    t = function(t) {
                                        return {
                                            type: "css",
                                            extraCssClasses: "dx-opendoor-animation",
                                            delay: void 0 === t.delay ? e.option("defaultAnimationDelay") : t.delay,
                                            duration: void 0 === t.duration ? e.option("defaultAnimationDuration") : t.duration
                                        }
                                    };
                                return {
                                    enter: function(e, n) {
                                        var i = n.direction,
                                            o = t(n);
                                        return o.delay = "none" === i ? o.delay : o.duration, o.from = "dx-enter dx-opendoor-animation" + d[i], o.to = "dx-enter-active", l.default.createAnimation(e, o)
                                    },
                                    leave: function(e, n) {
                                        var i = n.direction,
                                            o = t(n);
                                        return o.from = "dx-leave dx-opendoor-animation" + d[i], o.to = "dx-leave-active", l.default.createAnimation(e, o)
                                    }
                                }
                            },
                            _createWinPopConfig: function() {
                                var e = this,
                                    t = {
                                        type: "css",
                                        extraCssClasses: "dx-win-pop-animation",
                                        duration: e.option("defaultAnimationDuration")
                                    };
                                return {
                                    enter: function(n, i) {
                                        var o = t,
                                            a = i.direction;
                                        return o.delay = "none" === a ? e.option("defaultAnimationDelay") : e.option("defaultAnimationDuration") / 2, o.from = "dx-enter dx-win-pop-animation" + d[a], o.to = "dx-enter-active", l.default.createAnimation(n, o)
                                    },
                                    leave: function(n, i) {
                                        var o = t,
                                            a = i.direction;
                                        return o.delay = e.option("defaultAnimationDelay"), o.from = "dx-leave dx-win-pop-animation" + d[a], o.to = "dx-leave-active", l.default.createAnimation(n, o)
                                    }
                                }
                            },
                            resetToDefaults: function() {
                                this.clear(), this.registerDefaultPresets(), this.applyChanges()
                            },
                            clear: function(e) {
                                var t = this,
                                    n = [];
                                (0, a.each)(this._registeredPresets, (function(i, o) {
                                    e && e !== o.name ? n.push(o) : t.option(t._getPresetOptionName(o.name), void 0)
                                })), this._registeredPresets = n, this.applyChanges()
                            },
                            registerPreset: function(e, t) {
                                this._registeredPresets.push({
                                    name: e,
                                    config: t
                                })
                            },
                            applyChanges: function() {
                                var e = this,
                                    t = [];
                                (0, a.each)(this._registeredPresets, (function(n, i) {
                                    var o = {
                                        device: i.config.device,
                                        options: {}
                                    };
                                    o.options[e._getPresetOptionName(i.name)] = i.config.animation, t.push(o)
                                })), this._setOptionsByDevice(t)
                            },
                            getPreset: function(e) {
                                for (var t = e;
                                    "string" == typeof t;) {
                                    t = this.option(this._getPresetOptionName(t))
                                }
                                return t
                            },
                            registerDefaultPresets: function() {
                                this.registerPreset("pop", {
                                    animation: {
                                        extraCssClasses: "dx-android-pop-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("openDoor", {
                                    animation: this._createOpenDoorConfig()
                                }), this.registerPreset("win-pop", {
                                    animation: this._createWinPopConfig()
                                }), this.registerPreset("fade", {
                                    animation: {
                                        extraCssClasses: "dx-fade-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("slide", {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    animation: this._createAndroidSlideAnimationConfig(1, 1)
                                }), this.registerPreset("slide", {
                                    device: function() {
                                        return !s.default.current().android && !s.default.real.android
                                    },
                                    animation: {
                                        extraCssClasses: "dx-slide-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-slide", {
                                    animation: {
                                        extraCssClasses: "dx-ios7-slide-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("overflow", {
                                    animation: {
                                        extraCssClasses: "dx-overflow-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-toolbar", {
                                    device: function() {
                                        return !s.default.current().android && !s.default.real.android
                                    },
                                    animation: {
                                        extraCssClasses: "dx-ios7-toolbar-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-toolbar", {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    animation: this._createAndroidSlideAnimationConfig(0, .4)
                                }), this.registerPreset("stagger-fade", {
                                    animation: {
                                        extraCssClasses: "dx-fade-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-slide", {
                                    animation: {
                                        extraCssClasses: "dx-slide-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-slide", {
                                    animation: {
                                        extraCssClasses: "dx-fade-slide-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-drop", {
                                    animation: {
                                        extraCssClasses: "dx-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-drop", {
                                    animation: {
                                        extraCssClasses: "dx-fade-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-rise", {
                                    animation: {
                                        extraCssClasses: "dx-fade-rise-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-3d-drop", {
                                    animation: {
                                        extraCssClasses: "dx-3d-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-zoom", {
                                    animation: {
                                        extraCssClasses: "dx-fade-zoom-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                })
                            }
                        });
                    t.PresetCollection = c;
                    var h = new c;
                    t.presets = h
                },
            52431:
                /*!**************************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/transition_executor/transition_executor.js ***!
                  \**************************************************************************************************/
                function(e, t, n) {
                    t.TransitionExecutor = void 0;
                    var i = h(n( /*! ../../core/renderer */ 68374)),
                        o = h(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        r = n( /*! ../../core/utils/common */ 20576),
                        s = n( /*! ../../core/utils/type */ 35922),
                        l = n( /*! ../../core/utils/iterator */ 95479),
                        u = h(n( /*! ../fx */ 87209)),
                        d = n( /*! ../presets/presets */ 42814),
                        c = n( /*! ../../core/utils/deferred */ 62754);

                    function h(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f = {
                            forward: " dx-forward",
                            backward: " dx-backward",
                            none: " dx-no-direction",
                            undefined: " dx-no-direction"
                        },
                        p = "dx-animating",
                        g = o.default.inherit({
                            ctor: function() {
                                this._accumulatedDelays = {
                                    enter: 0,
                                    leave: 0
                                }, this._animations = [], this.reset()
                            },
                            _createAnimations: function(e, t, n, o) {
                                var a = this,
                                    r = [];
                                n = n || {};
                                var s = this._prepareElementAnimationConfig(t, n, o);
                                return s && e.each((function() {
                                    var e = a._createAnimation((0, i.default)(this), s, n);
                                    e && (e.element.addClass(p), e.setup(), r.push(e))
                                })), r
                            },
                            _prepareElementAnimationConfig: function(e, t, n) {
                                var i;
                                if ("string" == typeof e) {
                                    var o = e;
                                    e = d.presets.getPreset(o)
                                }
                                if (e) {
                                    if ((0, s.isFunction)(e[n])) {
                                        i = e[n]
                                    } else {
                                        if (!(i = (0, a.extend)({
                                                skipElementInitialStyles: !0,
                                                cleanupWhen: this._completePromise
                                            }, e, t)).type || "css" === i.type) {
                                            var r = "dx-" + n,
                                                l = (i.extraCssClasses ? " " + i.extraCssClasses : "") + f[i.direction];
                                            i.type = "css", i.from = (i.from || r) + l, i.to = i.to || r + "-active"
                                        }
                                        i.staggerDelay = i.staggerDelay || 0, i.delay = i.delay || 0, i.staggerDelay && (i.delay += this._accumulatedDelays[n], this._accumulatedDelays[n] += i.staggerDelay)
                                    }
                                } else {
                                    i = void 0
                                }
                                return i
                            },
                            _createAnimation: function(e, t, n) {
                                var i;
                                return (0, s.isPlainObject)(t) ? i = u.default.createAnimation(e, t) : (0, s.isFunction)(t) && (i = t(e, n)), i
                            },
                            _startAnimations: function() {
                                for (var e = this._animations, t = 0; t < e.length; t++) {
                                    e[t].start()
                                }
                            },
                            _stopAnimations: function(e) {
                                for (var t = this._animations, n = 0; n < t.length; n++) {
                                    t[n].stop(e)
                                }
                            },
                            _clearAnimations: function() {
                                for (var e = this._animations, t = 0; t < e.length; t++) {
                                    e[t].element.removeClass(p)
                                }
                                this._animations.length = 0
                            },
                            reset: function() {
                                this._accumulatedDelays.enter = 0, this._accumulatedDelays.leave = 0, this._clearAnimations(), this._completeDeferred = new c.Deferred, this._completePromise = this._completeDeferred.promise()
                            },
                            enter: function(e, t, n) {
                                var i = this._createAnimations(e, t, n, "enter");
                                this._animations.push.apply(this._animations, i)
                            },
                            leave: function(e, t, n) {
                                var i = this._createAnimations(e, t, n, "leave");
                                this._animations.push.apply(this._animations, i)
                            },
                            start: function() {
                                var e, t = this;
                                if (this._animations.length) {
                                    var n = (0, l.map)(this._animations, (function(e) {
                                        var t = new c.Deferred;
                                        return e.deferred.always((function() {
                                            t.resolve()
                                        })), t.promise()
                                    }));
                                    e = c.when.apply(i.default, n).always((function() {
                                        t._completeDeferred.resolve(), t.reset()
                                    })), (0, r.executeAsync)((function() {
                                        t._startAnimations()
                                    }))
                                } else {
                                    t.reset(), e = (new c.Deferred).resolve().promise()
                                }
                                return e
                            },
                            stop: function(e) {
                                this._stopAnimations(e)
                            }
                        });
                    t.TransitionExecutor = g
                },
            31648:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/translator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.resetPosition = t.parseTranslate = t.move = t.locate = t.getTranslateCss = t.getTranslate = t.clearCache = void 0;
                    var i, o = (i = n( /*! ../core/renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ../core/element_data */ 97906),
                        r = n( /*! ../core/utils/type */ 35922);
                    var s = "dxTranslator",
                        l = /matrix(3d)?\((.+?)\)/,
                        u = /translate(?:3d)?\((.+?)\)/;

                    function d(e) {
                        return "string" === (0, r.type)(e) && "%" === e[e.length - 1]
                    }

                    function c(e, t) {
                        e.length && (0, a.data)(e.get(0), s, t)
                    }
                    t.locate = function(e) {
                        e = (0, o.default)(e);
                        var t = p(e);
                        return {
                            left: t.x,
                            top: t.y
                        }
                    };
                    var h = function(e) {
                        e.length && (0, a.removeData)(e.get(0), s)
                    };
                    t.clearCache = h;
                    var f = function(e) {
                        return e.x = e.x || 0, e.y = e.y || 0, "translate(" + (d(e.x) ? e.x : e.x + "px") + ", " + (d(e.y) ? e.y : e.y + "px") + ")"
                    };
                    t.getTranslateCss = f;
                    var p = function(e) {
                        var t = e.length ? (0, a.data)(e.get(0), s) : null;
                        if (!t) {
                            var n = (e.css("transform") || f({
                                    x: 0,
                                    y: 0
                                })).match(l),
                                i = n && n[1];
                            n ? (n = n[2].split(","), "3d" === i ? n = n.slice(12, 15) : (n.push(0), n = n.slice(4, 7))) : n = [0, 0, 0], c(e, t = {
                                x: parseFloat(n[0]),
                                y: parseFloat(n[1]),
                                z: parseFloat(n[2])
                            })
                        }
                        return t
                    };
                    t.getTranslate = p;
                    t.move = function(e, t) {
                        e = (0, o.default)(e);
                        var n, i = t.left,
                            a = t.top;
                        void 0 === i ? (n = p(e)).y = a || 0 : void 0 === a ? (n = p(e)).x = i || 0 : c(e, n = {
                            x: i || 0,
                            y: a || 0,
                            z: 0
                        }), e.css({
                            transform: f(n)
                        }), (d(i) || d(a)) && h(e)
                    };
                    t.resetPosition = function(e, t) {
                        var n;
                        e = (0, o.default)(e);
                        var i = {
                            left: 0,
                            top: 0,
                            transform: "none"
                        };
                        t && (n = e.css("transition"), i.transition = "none"), e.css(i), h(e), t && (e.get(0).offsetHeight, e.css("transition", n))
                    };
                    t.parseTranslate = function(e) {
                        var t = e.match(u);
                        if (t && t[1]) {
                            return t = t[1].split(","), {
                                x: parseFloat(t[0]),
                                y: parseFloat(t[1]),
                                z: parseFloat(t[2])
                            }
                        }
                    }
                },
            36991:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/core.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../../core/utils/window */ 58201).getWindow(),
                        o = i.DevExpress = i.DevExpress || {},
                        a = o.errors = n( /*! ../../core/errors */ 17381);
                    if (o._DEVEXTREME_BUNDLE_INITIALIZED) {
                        throw a.Error("E0024")
                    }
                    o._DEVEXTREME_BUNDLE_INITIALIZED = !0, o.clientExporter = n( /*! ../../exporter */ 78292), o.excelExporter = n( /*! ../../excel_exporter */ 2994), o.pdfExporter = n( /*! ../../pdf_exporter */ 44194), o.VERSION = n( /*! ../../core/version */ 36739).version, o.Class = n( /*! ../../core/class */ 38377), o.DOMComponent = n( /*! ../../core/dom_component */ 13046), o.Component = n( /*! ../../core/component */ 44297).Component, o.registerComponent = n( /*! ../../core/component_registrator */ 99393), o.devices = n( /*! ../../core/devices */ 20530), o.Color = n( /*! ../../color */ 52752);
                    var r = n( /*! ../../animation/frame */ 90057);
                    o.utils = {}, o.utils.requestAnimationFrame = r.requestAnimationFrame, o.utils.cancelAnimationFrame = r.cancelAnimationFrame, o.utils.initMobileViewport = n( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 88185).p, o.utils.getTimeZones = n( /*! ../../time_zone_utils */ 88673).Z, o.utils.extendFromObject = n( /*! ../../core/utils/extend */ 13306).extendFromObject, o.utils.triggerShownEvent = n( /*! ../../events/visibility_change */ 80506).triggerShownEvent, o.utils.triggerHidingEvent = n( /*! ../../events/visibility_change */ 80506).triggerHidingEvent, o.utils.resetActiveElement = n( /*! ../../core/utils/dom */ 3532).resetActiveElement, o.utils.findBestMatches = n( /*! ../../core/utils/common */ 20576).findBestMatches, o.createQueue = n( /*! ../../core/utils/queue */ 59504).create, o.utils.dom = n( /*! ../../core/utils/dom */ 3532), o.utils.common = n( /*! ../../core/utils/common */ 20576), o.utils.date = n( /*! ../../core/utils/date */ 91198), o.utils.browser = n( /*! ../../core/utils/browser */ 47810), o.utils.inflector = n( /*! ../../core/utils/inflector */ 78008), o.utils.iterator = n( /*! ../../core/utils/iterator */ 95479), o.utils.readyCallbacks = n( /*! ../../core/utils/ready_callbacks */ 24311), o.utils.resizeCallbacks = n( /*! ../../core/utils/resize_callbacks */ 55814), o.utils.console = n( /*! ../../core/utils/console */ 30869), o.utils.string = n( /*! ../../core/utils/string */ 68752), o.utils.support = n( /*! ../../core/utils/support */ 60137), o.utils.ajax = n( /*! ../../core/utils/ajax */ 37208), o.viewPort = n( /*! ../../core/utils/view_port */ 77695).value, o.hideTopOverlay = n( /*! ../../mobile/hide_top_overlay */ 60628), o.formatHelper = n( /*! ../../format_helper */ 30343), o.config = n( /*! ../../core/config */ 80209), o.animationPresets = n( /*! ../../animation/presets/presets */ 42814).presets, o.fx = n( /*! ../../animation/fx */ 87209), o.TransitionExecutor = n( /*! ../../animation/transition_executor/transition_executor */ 52431).TransitionExecutor, o.AnimationPresetCollection = n( /*! ../../animation/presets/presets */ 42814).PresetCollection, o.events = n( /*! ../../events */ 66365), o.events.click = n( /*! ../../events/click */ 95429), o.events.utils = n( /*! ../../events/utils */ 39611), o.events.GestureEmitter = n( /*! ../../events/gesture/emitter.gesture */ 98621), o.localization = n( /*! ../../localization */ 94484), o.templateRendered = n( /*! ../../core/templates/template_base */ 81033).renderedCallbacks, o.setTemplateEngine = n( /*! ../../core/templates/template_engine_registry */ 72987).setTemplateEngine, e.exports = o
                },
            86635:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 36991),
                        o = n( /*! ../../core/errors */ 17381);
                    e.exports = i.data = i.data || {}, Object.defineProperty(i.data, "errorHandler", {
                        get: function() {
                            return n( /*! ../../data/errors */ 18438).errorHandler
                        },
                        set: function(e) {
                            o.log("W0003", "DevExpress.data", "errorHandler", "21.1", "Use the 'setErrorHandler' method instead"), n( /*! ../../data/errors */ 18438).setErrorHandler(e)
                        }
                    }), Object.defineProperty(i.data, "_errorHandler", {
                        get: function() {
                            return n( /*! ../../data/errors */ 18438).handleError
                        },
                        set: function(e) {
                            o.log("W0003", "DevExpress.data", "_errorHandler", "21.1", "Use the 'setErrorHandler' method instead"), n( /*! ../../data/errors */ 18438).setErrorHandler(e)
                        }
                    }), i.data.setErrorHandler = n( /*! ../../data/errors */ 18438).setErrorHandler, i.data.DataSource = n( /*! ../../data/data_source */ 33546), i.data.query = n( /*! ../../data/query */ 96687), i.data.Store = n( /*! ../../data/abstract_store */ 67403), i.data.ArrayStore = n( /*! ../../data/array_store */ 26562), i.data.CustomStore = n( /*! ../../data/custom_store */ 88036), i.data.LocalStore = n( /*! ../../data/local_store */ 82837), i.data.base64_encode = n( /*! ../../data/utils */ 16454).base64_encode, i.data.applyChanges = n( /*! ../../data/apply_changes */ 36893), i.data.Guid = n( /*! ../../core/guid */ 73176), i.data.utils = {}, i.data.utils.compileGetter = n( /*! ../../core/utils/data */ 47617).compileGetter, i.data.utils.compileSetter = n( /*! ../../core/utils/data */ 47617).compileSetter, i.EndpointSelector = n( /*! ../../data/endpoint_selector */ 8162), i.data.queryImpl = n( /*! ../../data/query_implementation */ 77549).queryImpl, i.data.queryAdapters = n( /*! ../../data/query_adapters */ 16135);
                    var a = n( /*! ../../data/utils */ 16454);
                    i.data.utils.normalizeBinaryCriterion = a.normalizeBinaryCriterion, i.data.utils.normalizeSortingInfo = a.normalizeSortingInfo, i.data.utils.errorMessageFromXhr = a.errorMessageFromXhr, i.data.utils.aggregators = a.aggregators, i.data.utils.keysEqual = a.keysEqual, i.data.utils.isDisjunctiveOperator = a.isDisjunctiveOperator, i.data.utils.isConjunctiveOperator = a.isConjunctiveOperator, i.data.utils.processRequestResultLock = a.processRequestResultLock, i.data.utils.toComparable = n( /*! ../../core/utils/data */ 47617).toComparable, i.data.utils.multiLevelGroup = n( /*! ../../data/store_helper */ 99236).multiLevelGroup, i.data.utils.arrangeSortingInfo = n( /*! ../../data/store_helper */ 99236).arrangeSortingInfo, i.data.utils.normalizeDataSourceOptions = n( /*! ../../data/data_source/utils */ 9234).normalizeDataSourceOptions
                },
            72343:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.odata.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    n( /*! ./data */ 86635), DevExpress.data.ODataStore = n( /*! ../../data/odata/store */ 341), DevExpress.data.ODataContext = n( /*! ../../data/odata/context */ 47256), DevExpress.data.utils = DevExpress.data.utils || {}, DevExpress.data.utils.odata = {}, DevExpress.data.utils.odata.keyConverters = n( /*! ../../data/odata/utils */ 77869).keyConverters, DevExpress.data.EdmLiteral = n( /*! ../../data/odata/utils */ 77869).EdmLiteral;
                    var i = n( /*! ../../data/odata/utils */ 77869);
                    DevExpress.data.utils.odata.serializePropName = i.serializePropName, DevExpress.data.utils.odata.serializeValue = i.serializeValue, DevExpress.data.utils.odata.serializeKey = i.serializeKey, DevExpress.data.utils.odata.sendRequest = i.sendRequest, DevExpress.data.queryAdapters = DevExpress.data.queryAdapters || {}, DevExpress.data.queryAdapters.odata = n( /*! ../../data/odata/query_adapter */ 54263).odata
                },
            56208:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/file_management.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    var i = u(n( /*! ./core */ 36991)),
                        o = u(n( /*! ../../file_management/error */ 49816)),
                        a = u(n( /*! ../../file_management/file_system_item */ 45765)),
                        r = u(n( /*! ../../file_management/object_provider */ 4323)),
                        s = u(n( /*! ../../file_management/remote_provider */ 41332)),
                        l = u(n( /*! ../../file_management/custom_provider */ 98831));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    e.exports = i.default.fileManagement = i.default.fileManagement || {}, i.default.fileManagement.FileSystemError = o.default, i.default.fileManagement.FileSystemItem = a.default, i.default.fileManagement.ObjectFileSystemProvider = r.default, i.default.fileManagement.RemoteFileSystemProvider = s.default, i.default.fileManagement.CustomFileSystemProvider = l.default
                },
            85357:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/core.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../../../bundles/modules/core */ 36991);
                    n( /*! ../../../integration/jquery */ 78475), n( /*! ../../../integration/angular */ 71582), n( /*! ../../../integration/knockout */ 49281), n( /*! ../../../localization/globalize/core */ 74872), n( /*! ../../../localization/globalize/message */ 46949), n( /*! ../../../localization/globalize/number */ 908), n( /*! ../../../localization/globalize/date */ 60316), n( /*! ../../../localization/globalize/currency */ 7239), n( /*! ../../../events/click */ 95429), n( /*! ../../../events/contextmenu */ 49166), n( /*! ../../../events/double_click */ 85272), n( /*! ../../../events/drag */ 23174), n( /*! ../../../events/hold */ 11699), n( /*! ../../../events/hover */ 24028), n( /*! ../../../events/pointer */ 93786), n( /*! ../../../events/swipe */ 34309), n( /*! ../../../events/transform */ 91093), e.exports = i
                },
            94620:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/data.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 85357).data = n( /*! ../../../bundles/modules/data */ 86635);
                    i.odata = n( /*! ../../../bundles/modules/data.odata */ 72343), e.exports = i
                },
            70527:
                /*!**************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/file_management.js ***!
                  \**************************************************************************************/
                function(e, t, n) {
                    var i, o = (i = n( /*! ./core */ 85357)) && i.__esModule ? i : {
                        default: i
                    };
                    var a = n( /*! ../../../bundles/modules/file_management */ 56208);
                    o.default.fileManagement = a, e.exports = a
                },
            50779:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-base.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 85357);
                    n( /*! ./data */ 94620), n( /*! ./file_management */ 70527);
                    var o = i.ui = n( /*! ../../../bundles/modules/ui */ 26864);
                    o.themes = n( /*! ../../../ui/themes */ 75811), o.setTemplateEngine = n( /*! ../../../core/templates/template_engine_registry */ 72987).setTemplateEngine, o.dialog = n( /*! ../../../ui/dialog */ 15029), o.notify = n( /*! ../../../ui/notify */ 59958), o.repaintFloatingActionButton = n( /*! ../../../ui/speed_dial_action/repaint_floating_action_button */ 81374), o.dxActionSheet = n( /*! ../../../ui/action_sheet */ 81476), o.dxAutocomplete = n( /*! ../../../ui/autocomplete */ 65418), o.dxBox = n( /*! ../../../ui/box */ 55551), o.dxButton = n( /*! ../../../ui/button */ 63008), o.dxDropDownButton = n( /*! ../../../ui/drop_down_button */ 45231), o.dxButtonGroup = n( /*! ../../../ui/button_group */ 28236), o.dxCalendar = n( /*! ../../../ui/calendar */ 26559), o.dxCheckBox = n( /*! ../../../ui/check_box */ 18859), o.dxColorBox = n( /*! ../../../ui/color_box */ 4278), o.dxDateBox = n( /*! ../../../ui/date_box */ 29589), o.dxDrawer = n( /*! ../../../ui/drawer */ 45065), o.dxDeferRendering = n( /*! ../../../ui/defer_rendering */ 28414), o.dxDropDownBox = n( /*! ../../../ui/drop_down_box */ 36646), o.dxDropDownMenu = n( /*! ../../../ui/drop_down_menu */ 79561), o.dxFileUploader = n( /*! ../../../ui/file_uploader */ 53749), o.dxForm = n( /*! ../../../ui/form */ 17737), o.dxGallery = n( /*! ../../../ui/gallery */ 49433), o.dxHtmlEditor = n( /*! ../../../ui/html_editor */ 9619), o.dxList = n( /*! ../../../ui/list */ 86e3), o.dxLoadIndicator = n( /*! ../../../ui/load_indicator */ 2492), o.dxLoadPanel = n( /*! ../../../ui/load_panel */ 97218), o.dxLookup = n( /*! ../../../ui/lookup */ 55935), o.dxMap = n( /*! ../../../ui/map */ 64304), o.dxMultiView = n( /*! ../../../ui/multi_view */ 86478), o.dxNavBar = n( /*! ../../../ui/nav_bar */ 65089), o.dxNumberBox = n( /*! ../../../ui/number_box */ 34171), o.dxOverlay = n( /*! ../../../ui/overlay/ui.overlay */ 89799), o.dxPopover = n( /*! ../../../ui/popover */ 22348), o.dxPopup = n( /*! ../../../ui/popup */ 39114), o.dxProgressBar = n( /*! ../../../ui/progress_bar */ 28080), o.dxRadioGroup = n( /*! ../../../ui/radio_group */ 14305), o.dxRangeSlider = n( /*! ../../../ui/range_slider */ 36992), o.dxResizable = n( /*! ../../../ui/resizable */ 46743), o.dxResponsiveBox = n( /*! ../../../ui/responsive_box */ 21643), o.dxScrollView = n( /*! ../../../ui/scroll_view */ 4741), o.dxSelectBox = n( /*! ../../../ui/select_box */ 78665), o.dxSlider = n( /*! ../../../ui/slider */ 97834), o.dxSpeedDialAction = n( /*! ../../../ui/speed_dial_action */ 17017), o.dxSwitch = n( /*! ../../../ui/switch */ 31609), o.dxTabPanel = n( /*! ../../../ui/tab_panel */ 21807), o.dxTabs = n( /*! ../../../ui/tabs */ 13453), o.dxTagBox = n( /*! ../../../ui/tag_box */ 31362), o.dxTextArea = n( /*! ../../../ui/text_area */ 51237), o.dxTextBox = n( /*! ../../../ui/text_box */ 29837), o.dxTileView = n( /*! ../../../ui/tile_view */ 93094), o.dxToast = n( /*! ../../../ui/toast */ 37748), o.dxToolbar = n( /*! ../../../ui/toolbar */ 71042), o.dxTooltip = n( /*! ../../../ui/tooltip */ 94920), o.dxTrackBar = n( /*! ../../../ui/track_bar */ 39661), o.dxDraggable = n( /*! ../../../ui/draggable */ 42160), o.dxSortable = n( /*! ../../../ui/sortable */ 66843), i.validationEngine = n( /*! ../../../ui/validation_engine */ 90964), o.dxValidationSummary = n( /*! ../../../ui/validation_summary */ 97289), o.dxValidationGroup = n( /*! ../../../ui/validation_group */ 4401), o.dxValidator = n( /*! ../../../ui/validator */ 39562), n( /*! ../../../ui/html_editor/converters/markdown */ 52935), o.CollectionWidget = n( /*! ../../../ui/collection/ui.collection_widget.edit */ 11050), o.dxDropDownEditor = n( /*! ../../../ui/drop_down_editor/ui.drop_down_editor */ 44687), e.exports = o
                },
            2025:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-web.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./data */ 94620),
                        o = n( /*! ./widgets-base */ 50779);
                    o.dxAccordion = n( /*! ../../../ui/accordion */ 76219), o.dxContextMenu = n( /*! ../../../ui/context_menu */ 10042), o.dxDataGrid = n( /*! ../../../ui/data_grid */ 1186), o.dxTreeList = n( /*! ../../../ui/tree_list */ 82655), o.dxMenu = n( /*! ../../../ui/menu */ 76995), o.dxPivotGrid = n( /*! ../../../ui/pivot_grid */ 96089), o.dxPivotGridFieldChooser = n( /*! ../../../ui/pivot_grid_field_chooser */ 32014), i.PivotGridDataSource = n( /*! ../../../ui/pivot_grid/data_source */ 98713), i.XmlaStore = n( /*! ../../../ui/pivot_grid/xmla_store */ 9170), o.dxScheduler = n( /*! ../../../ui/scheduler */ 9508), o.dxTreeView = n( /*! ../../../ui/tree_view */ 30254), o.dxFilterBuilder = n( /*! ../../../ui/filter_builder */ 20301), o.dxFileManager = n( /*! ../../../ui/file_manager */ 87446), o.dxDiagram = n( /*! ../../../ui/diagram */ 52311), o.dxGantt = n( /*! ../../../ui/gantt */ 33465)
                },
            26864:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/ui.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    n( /*! ./core */ 36991), e.exports = DevExpress.ui = {}
                },
            52752:
                /*!******************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/color.js ***!
                  \******************************************************/
                function(e, t) {
                    t.default = void 0;
                    var n = {
                            aliceblue: "f0f8ff",
                            antiquewhite: "faebd7",
                            aqua: "00ffff",
                            aquamarine: "7fffd4",
                            azure: "f0ffff",
                            beige: "f5f5dc",
                            bisque: "ffe4c4",
                            black: "000000",
                            blanchedalmond: "ffebcd",
                            blue: "0000ff",
                            blueviolet: "8a2be2",
                            brown: "a52a2a",
                            burlywood: "deb887",
                            cadetblue: "5f9ea0",
                            chartreuse: "7fff00",
                            chocolate: "d2691e",
                            coral: "ff7f50",
                            cornflowerblue: "6495ed",
                            cornsilk: "fff8dc",
                            crimson: "dc143c",
                            cyan: "00ffff",
                            darkblue: "00008b",
                            darkcyan: "008b8b",
                            darkgoldenrod: "b8860b",
                            darkgray: "a9a9a9",
                            darkgreen: "006400",
                            darkkhaki: "bdb76b",
                            darkmagenta: "8b008b",
                            darkolivegreen: "556b2f",
                            darkorange: "ff8c00",
                            darkorchid: "9932cc",
                            darkred: "8b0000",
                            darksalmon: "e9967a",
                            darkseagreen: "8fbc8f",
                            darkslateblue: "483d8b",
                            darkslategray: "2f4f4f",
                            darkturquoise: "00ced1",
                            darkviolet: "9400d3",
                            deeppink: "ff1493",
                            deepskyblue: "00bfff",
                            dimgray: "696969",
                            dodgerblue: "1e90ff",
                            feldspar: "d19275",
                            firebrick: "b22222",
                            floralwhite: "fffaf0",
                            forestgreen: "228b22",
                            fuchsia: "ff00ff",
                            gainsboro: "dcdcdc",
                            ghostwhite: "f8f8ff",
                            gold: "ffd700",
                            goldenrod: "daa520",
                            gray: "808080",
                            green: "008000",
                            greenyellow: "adff2f",
                            honeydew: "f0fff0",
                            hotpink: "ff69b4",
                            indianred: "cd5c5c",
                            indigo: "4b0082",
                            ivory: "fffff0",
                            khaki: "f0e68c",
                            lavender: "e6e6fa",
                            lavenderblush: "fff0f5",
                            lawngreen: "7cfc00",
                            lemonchiffon: "fffacd",
                            lightblue: "add8e6",
                            lightcoral: "f08080",
                            lightcyan: "e0ffff",
                            lightgoldenrodyellow: "fafad2",
                            lightgrey: "d3d3d3",
                            lightgreen: "90ee90",
                            lightpink: "ffb6c1",
                            lightsalmon: "ffa07a",
                            lightseagreen: "20b2aa",
                            lightskyblue: "87cefa",
                            lightslateblue: "8470ff",
                            lightslategray: "778899",
                            lightsteelblue: "b0c4de",
                            lightyellow: "ffffe0",
                            lime: "00ff00",
                            limegreen: "32cd32",
                            linen: "faf0e6",
                            magenta: "ff00ff",
                            maroon: "800000",
                            mediumaquamarine: "66cdaa",
                            mediumblue: "0000cd",
                            mediumorchid: "ba55d3",
                            mediumpurple: "9370d8",
                            mediumseagreen: "3cb371",
                            mediumslateblue: "7b68ee",
                            mediumspringgreen: "00fa9a",
                            mediumturquoise: "48d1cc",
                            mediumvioletred: "c71585",
                            midnightblue: "191970",
                            mintcream: "f5fffa",
                            mistyrose: "ffe4e1",
                            moccasin: "ffe4b5",
                            navajowhite: "ffdead",
                            navy: "000080",
                            oldlace: "fdf5e6",
                            olive: "808000",
                            olivedrab: "6b8e23",
                            orange: "ffa500",
                            orangered: "ff4500",
                            orchid: "da70d6",
                            palegoldenrod: "eee8aa",
                            palegreen: "98fb98",
                            paleturquoise: "afeeee",
                            palevioletred: "d87093",
                            papayawhip: "ffefd5",
                            peachpuff: "ffdab9",
                            peru: "cd853f",
                            pink: "ffc0cb",
                            plum: "dda0dd",
                            powderblue: "b0e0e6",
                            purple: "800080",
                            rebeccapurple: "663399",
                            red: "ff0000",
                            rosybrown: "bc8f8f",
                            royalblue: "4169e1",
                            saddlebrown: "8b4513",
                            salmon: "fa8072",
                            sandybrown: "f4a460",
                            seagreen: "2e8b57",
                            seashell: "fff5ee",
                            sienna: "a0522d",
                            silver: "c0c0c0",
                            skyblue: "87ceeb",
                            slateblue: "6a5acd",
                            slategray: "708090",
                            snow: "fffafa",
                            springgreen: "00ff7f",
                            steelblue: "4682b4",
                            tan: "d2b48c",
                            teal: "008080",
                            thistle: "d8bfd8",
                            tomato: "ff6347",
                            turquoise: "40e0d0",
                            violet: "ee82ee",
                            violetred: "d02090",
                            wheat: "f5deb3",
                            white: "ffffff",
                            whitesmoke: "f5f5f5",
                            yellow: "ffff00",
                            yellowgreen: "9acd32"
                        },
                        i = [{
                            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                return [parseInt(e[1], 10), parseInt(e[2], 10), parseInt(e[3], 10)]
                            }
                        }, {
                            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
                            process: function(e) {
                                return [parseInt(e[1], 10), parseInt(e[2], 10), parseInt(e[3], 10), parseFloat(e[4])]
                            }
                        }, {
                            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
                            process: function(e) {
                                return [parseInt(e[1], 16), parseInt(e[2], 16), parseInt(e[3], 16)]
                            }
                        }, {
                            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
                            process: function(e) {
                                return [parseInt(e[1] + e[1], 16), parseInt(e[2] + e[2], 16), parseInt(e[3] + e[3], 16)]
                            }
                        }, {
                            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                var t = parseInt(e[1], 10),
                                    n = parseInt(e[2], 10),
                                    i = parseInt(e[3], 10),
                                    o = s(t, n, i);
                                return [o[0], o[1], o[2], 1, [t, n, i]]
                            }
                        }, {
                            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                var t = parseInt(e[1], 10),
                                    n = parseInt(e[2], 10),
                                    i = parseInt(e[3], 10),
                                    o = d(t, n, i);
                                return [o[0], o[1], o[2], 1, null, [t, n, i]]
                            }
                        }],
                        o = Math.round;

                    function a(e) {
                        var t;
                        this.baseColor = e, e && (t = String(e).toLowerCase().replace(/ /g, ""), t = function(e) {
                            if ("transparent" === e) {
                                return [0, 0, 0, 0]
                            }
                            for (var t, n = 0, o = i.length; n < o; ++n) {
                                if (t = i[n].re.exec(e)) {
                                    return i[n].process(t)
                                }
                            }
                            return null
                        }(t = n[t] ? "#" + n[t] : t)), t || (this.colorIsInvalid = !0), t = t || {}, this.r = r(t[0]), this.g = r(t[1]), this.b = r(t[2]), this.a = r(t[3], 1, 1), t[4] ? this.hsv = {
                            h: t[4][0],
                            s: t[4][1],
                            v: t[4][2]
                        } : this.hsv = function(e, t, n) {
                            var i, o, a = Math.max(e, t, n),
                                r = Math.min(e, t, n),
                                s = a - r,
                                l = a;
                            if (o = 0 === a ? 0 : 1 - r / a, a === r) {
                                i = 0
                            } else {
                                switch (a) {
                                    case e:
                                        i = (t - n) / s * 60, t < n && (i += 360);
                                        break;
                                    case t:
                                        i = (n - e) / s * 60 + 120;
                                        break;
                                    case n:
                                        i = (e - t) / s * 60 + 240
                                }
                            }
                            return o *= 100, l *= 100 / 255, {
                                h: Math.round(i),
                                s: Math.round(o),
                                v: Math.round(l)
                            }
                        }(this.r, this.g, this.b), t[5] ? this.hsl = {
                            h: t[5][0],
                            s: t[5][1],
                            l: t[5][2]
                        } : this.hsl = function(e, t, n) {
                            e = c(e, 255), t = c(t, 255), n = c(n, 255);
                            var i, a, r = Math.max(e, t, n),
                                s = Math.min(e, t, n),
                                l = r + s,
                                u = l / 2;
                            if (r === s) {
                                i = a = 0
                            } else {
                                var d = r - s;
                                a = u > .5 ? d / (2 - l) : d / l, i = function(e, t, n, i) {
                                    switch (Math.max(e, t, n)) {
                                        case e:
                                            return (t - n) / i + (t < n ? 6 : 0);
                                        case t:
                                            return (n - e) / i + 2;
                                        case n:
                                            return (e - t) / i + 4
                                    }
                                }(e, t, n, d), i /= 6
                            }
                            return {
                                h: o(360 * i),
                                s: o(100 * a),
                                l: o(100 * u)
                            }
                        }(this.r, this.g, this.b)
                    }

                    function r(e, t, n) {
                        return t = t || 0, n = n || 255, e < 0 || isNaN(e) ? t : e > n ? n : e
                    }

                    function s(e, t, n) {
                        var i, o, a, r = (100 - t) * n / 100,
                            s = e % 60 / 60 * (n - r),
                            l = r + s,
                            u = n - s;
                        switch (Math.floor(e % 360 / 60)) {
                            case 0:
                                i = n, o = l, a = r;
                                break;
                            case 1:
                                i = u, o = n, a = r;
                                break;
                            case 2:
                                i = r, o = n, a = l;
                                break;
                            case 3:
                                i = r, o = u, a = n;
                                break;
                            case 4:
                                i = l, o = r, a = n;
                                break;
                            case 5:
                                i = n, o = r, a = u
                        }
                        return [Math.round(2.55 * i), Math.round(2.55 * o), Math.round(2.55 * a)]
                    }

                    function l(e, t) {
                        var n = t;
                        return "r" === e && (n = t + 1 / 3), "b" === e && (n = t - 1 / 3), n
                    }

                    function u(e, t, n) {
                        return (n = function(e) {
                            return e < 0 && (e += 1), e > 1 && (e -= 1), e
                        }(n)) < 1 / 6 ? e + 6 * (t - e) * n : n < .5 ? t : n < 2 / 3 ? e + (t - e) * (2 / 3 - n) * 6 : e
                    }

                    function d(e, t, n) {
                        var i, a, r;
                        if (e = c(e, 360), t = c(t, 100), n = c(n, 100), 0 === t) {
                            i = a = r = n
                        } else {
                            var s = n < .5 ? n * (1 + t) : n + t - n * t,
                                d = 2 * n - s;
                            i = u(d, s, l("r", e)), a = u(d, s, l("g", e)), r = u(d, s, l("b", e))
                        }
                        return [o(255 * i), o(255 * a), o(255 * r)]
                    }

                    function c(e, t) {
                        return e = Math.min(t, Math.max(0, parseFloat(e))), Math.abs(e - t) < 1e-6 ? 1 : e % t / parseFloat(t)
                    }

                    function h(e, t, n) {
                        return t = t || 0, n = n || 255, !(e % 1 != 0 || e < t || e > n || "number" != typeof e || isNaN(e))
                    }
                    a.prototype = {
                        constructor: a,
                        highlight: function(e) {
                            return e = e || 10, this.alter(e).toHex()
                        },
                        darken: function(e) {
                            return e = e || 10, this.alter(-e).toHex()
                        },
                        alter: function(e) {
                            var t = new a;
                            return t.r = r(this.r + e), t.g = r(this.g + e), t.b = r(this.b + e), t
                        },
                        blend: function(e, t) {
                            var n = e instanceof a ? e : new a(e),
                                i = new a;
                            return i.r = r(o(this.r * (1 - t) + n.r * t)), i.g = r(o(this.g * (1 - t) + n.g * t)), i.b = r(o(this.b * (1 - t) + n.b * t)), i
                        },
                        toHex: function() {
                            return e = this.r, t = this.g, n = this.b, "#" + (16777216 | e << 16 | t << 8 | n).toString(16).slice(1);
                            var e, t, n
                        },
                        getPureColor: function() {
                            return new a("rgb(" + s(this.hsv.h, 100, 100).join(",") + ")")
                        },
                        isValidHex: function(e) {
                            return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)
                        },
                        isValidRGB: function(e, t, n) {
                            return !!(h(e) && h(t) && h(n))
                        },
                        isValidAlpha: function(e) {
                            return !(isNaN(e) || e < 0 || e > 1 || "number" != typeof e)
                        },
                        colorIsInvalid: !1,
                        fromHSL: function(e) {
                            var t = new a,
                                n = d(e.h, e.s, e.l);
                            return t.r = n[0], t.g = n[1], t.b = n[2], t
                        }
                    };
                    var f = a;
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            62414:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/action.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ./renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./utils/window */ 58201),
                        r = n( /*! ./utils/type */ 35922),
                        s = n( /*! ./utils/iterator */ 95479);
                    var l = function() {
                        function e(e, t) {
                            t = t || {}, this._action = e, this._context = t.context || (0, a.getWindow)(), this._beforeExecute = t.beforeExecute, this._afterExecute = t.afterExecute, this._component = t.component, this._validatingTargetName = t.validatingTargetName;
                            var n = this._excludeValidators = {};
                            if (t.excludeValidators) {
                                for (var i = 0; i < t.excludeValidators.length; i++) {
                                    n[t.excludeValidators[i]] = !0
                                }
                            }
                        }
                        var t = e.prototype;
                        return t.execute = function() {
                            var e = {
                                    action: this._action,
                                    args: Array.prototype.slice.call(arguments),
                                    context: this._context,
                                    component: this._component,
                                    validatingTargetName: this._validatingTargetName,
                                    cancel: !1,
                                    handled: !1
                                },
                                t = this._beforeExecute,
                                n = this._afterExecute,
                                i = e.args[0] || {};
                            if (this._validateAction(e) && (null == t || t.call(this._context, e), !e.cancel)) {
                                var o = this._executeAction(e);
                                if (!i.cancel) {
                                    return null == n || n.call(this._context, e), o
                                }
                            }
                        }, t._validateAction = function(t) {
                            var n = this._excludeValidators,
                                i = e.executors;
                            for (var o in i) {
                                if (!n[o]) {
                                    var a, r = i[o];
                                    if (null === (a = r.validate) || void 0 === a || a.call(r, t), t.cancel) {
                                        return !1
                                    }
                                }
                            }
                            return !0
                        }, t._executeAction = function(t) {
                            var n, i = e.executors;
                            for (var o in i) {
                                var a, r = i[o];
                                if (null === (a = r.execute) || void 0 === a || a.call(r, t), t.handled) {
                                    n = t.result;
                                    break
                                }
                            }
                            return n
                        }, e.registerExecutor = function(t, n) {
                            (0, r.isPlainObject)(t) ? (0, s.each)(t, e.registerExecutor) : e.executors[t] = n
                        }, e.unregisterExecutor = function() {
                            for (var t = arguments.length, n = new Array(t), i = 0; i < t; i++) {
                                n[i] = arguments[i]
                            }(0, s.each)(n, (function() {
                                delete e.executors[this]
                            }))
                        }, e
                    }();
                    t.default = l, l.executors = {};
                    var u = function(e) {
                        return function(t) {
                            if (t.args.length) {
                                var n = t.args[0],
                                    i = n[t.validatingTargetName] || n.element;
                                i && e((0, o.default)(i)) && (t.cancel = !0)
                            }
                        }
                    };
                    l.registerExecutor({
                        disabled: {
                            validate: u((function(e) {
                                return e.is(".dx-state-disabled, .dx-state-disabled *")
                            }))
                        },
                        readOnly: {
                            validate: u((function(e) {
                                return e.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                            }))
                        },
                        undefined: {
                            execute: function(e) {
                                e.action || (e.result = void 0, e.handled = !0)
                            }
                        },
                        func: {
                            execute: function(e) {
                                (0, r.isFunction)(e.action) && (e.result = e.action.call(e.context, e.args[0]), e.handled = !0)
                            }
                        }
                    }), e.exports = t.default, e.exports.default = t.default
                },
            38377:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/class.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ./errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./utils/type */ 35922);
                    var r, s = function(e, t, n) {
                            return function() {
                                var i = this.callBase;
                                this.callBase = e[t];
                                try {
                                    return n.apply(this, arguments)
                                } finally {
                                    this.callBase = i
                                }
                            }
                        },
                        l = function(e) {
                            var t, n, i, o = this;
                            if (!e) {
                                return o
                            }
                            for (n in e) {
                                i = e[n], t = "function" == typeof o.prototype[n] && "function" == typeof i, o.prototype[n] = t ? s(o.parent.prototype, n, i) : i
                            }
                            return o
                        },
                        u = function() {
                            var e, t, n, i = this,
                                o = Object.prototype.hasOwnProperty.bind(i),
                                a = !o("_includedCtors") && !o("_includedPostCtors");
                            for (a && (i._includedCtors = i._includedCtors.slice(0), i._includedPostCtors = i._includedPostCtors.slice(0)), n = 0; n < arguments.length; n++) {
                                for (t in (e = arguments[n]).ctor && i._includedCtors.push(e.ctor), e.postCtor && i._includedPostCtors.push(e.postCtor), e) {
                                    "ctor" !== t && "postCtor" !== t && "default" !== t && (i.prototype[t] = e[t])
                                }
                            }
                            return i
                        },
                        d = function(e) {
                            if (!Object.prototype.hasOwnProperty.bind(this)("parent") && this.parent) {
                                var t = Object.getPrototypeOf(this);
                                return t === e || t.subclassOf(e)
                            }
                            return this.parent === e || !(!this.parent || !this.parent.subclassOf) && this.parent.subclassOf(e)
                        },
                        c = function() {
                            throw o.default.Error("E0001")
                        },
                        h = (r = Object.prototype.hasOwnProperty, function(e, t) {
                            for (var n in e) {
                                if (!r.call(e, n)) {
                                    return
                                }
                                t[n] = e[n]
                            }
                        }),
                        f = function() {};
                    f.inherit = function(e) {
                        var t = function() {
                            if (!this || (0, a.isWindow)(this) || "function" != typeof this.constructor) {
                                throw o.default.Error("E0003")
                            }
                            var e, t = this,
                                n = t.ctor,
                                i = t.constructor._includedCtors,
                                r = t.constructor._includedPostCtors;
                            for (e = 0; e < i.length; e++) {
                                i[e].call(t)
                            }
                            for (n && n.apply(t, arguments), e = 0; e < r.length; e++) {
                                r[e].call(t)
                            }
                        };
                        return t.prototype = function(e) {
                            var t = function() {};
                            return t.prototype = e.prototype, new t
                        }(this), h(this, t), t.inherit = this.inherit, t.abstract = c, t.redefine = l, t.include = u, t.subclassOf = d, t.parent = this, t._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [], t._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [], t.prototype.constructor = t, t.redefine(e), t
                    }, f.abstract = c;
                    var p = f;
                    t.default = p, e.exports = t.default, e.exports.default = t.default
                },
            44297:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.Component = void 0;
                    var i = _(n( /*! ./config */ 80209)),
                        o = n( /*! ./utils/extend */ 13306),
                        a = n( /*! ./options/index */ 95683),
                        r = n( /*! ./options/utils */ 45434),
                        s = _(n( /*! ./class */ 38377)),
                        l = _(n( /*! ./action */ 62414)),
                        u = _(n( /*! ./errors */ 17381)),
                        d = _(n( /*! ./utils/callbacks */ 44504)),
                        c = n( /*! ./events_strategy */ 80566),
                        h = n( /*! ./utils/public_component */ 9321),
                        f = n( /*! ./postponed_operations */ 90889),
                        p = n( /*! ./utils/type */ 35922),
                        g = n( /*! ./utils/common */ 20576),
                        m = n( /*! ./utils/data */ 47617);

                    function _(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var v = function(e) {
                            return e.charAt(2).toLowerCase() + e.substr(3)
                        },
                        y = s.default.inherit({
                            _setDeprecatedOptions: function() {
                                this._deprecatedOptions = {}
                            },
                            _getDeprecatedOptions: function() {
                                return this._deprecatedOptions
                            },
                            _getDefaultOptions: function() {
                                return {
                                    onInitialized: null,
                                    onOptionChanged: null,
                                    onDisposing: null,
                                    defaultOptionsRules: null
                                }
                            },
                            _defaultOptionsRules: function() {
                                return []
                            },
                            _setOptionsByDevice: function(e) {
                                this._options.applyRules(e)
                            },
                            _convertRulesToOptions: function(e) {
                                return (0, r.convertRulesToOptions)(e)
                            },
                            _isInitialOptionValue: function(e) {
                                return this._options.isInitial(e)
                            },
                            _setOptionsByReference: function() {
                                this._optionsByReference = {}
                            },
                            _getOptionsByReference: function() {
                                return this._optionsByReference
                            },
                            ctor: function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                                    t = e._optionChangedCallbacks,
                                    n = e._disposingCallbacks;
                                this.NAME = (0, h.name)(this.constructor), this._eventsStrategy = c.EventsStrategy.create(this, e.eventsStrategy), this._updateLockCount = 0, this._optionChangedCallbacks = t || (0, d.default)(), this._disposingCallbacks = n || (0, d.default)(), this.postponedOperations = new f.PostponedOperations, this._createOptions(e)
                            },
                            _createOptions: function(e) {
                                var t = this;
                                this.beginUpdate();
                                try {
                                    this._setOptionsByReference(), this._setDeprecatedOptions(), this._options = new a.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions()), this._options.onChanging((function(e, n, i) {
                                        return t._initialized && t._optionChanging(e, n, i)
                                    })), this._options.onDeprecated((function(e, n) {
                                        return t._logDeprecatedOptionWarning(e, n)
                                    })), this._options.onChanged((function(e, n, i) {
                                        return t._notifyOptionChanged(e, n, i)
                                    })), this._options.onStartChange((function() {
                                        return t.beginUpdate()
                                    })), this._options.onEndChange((function() {
                                        return t.endUpdate()
                                    })), this._options.addRules(this._defaultOptionsRules()), e && e.onInitializing && e.onInitializing.apply(this, [e]), this._setOptionsByDevice(e.defaultOptionsRules), this._initOptions(e)
                                } finally {
                                    this.endUpdate()
                                }
                            },
                            _initOptions: function(e) {
                                this.option(e)
                            },
                            _init: function() {
                                var e = this;
                                this._createOptionChangedAction(), this.on("disposing", (function(t) {
                                    e._disposingCallbacks.fireWith(e, [t])
                                }))
                            },
                            _logDeprecatedOptionWarning: function(e, t) {
                                var n = t.message || "Use the '".concat(t.alias, "' option instead");
                                u.default.log("W0001", this.NAME, e, t.since, n)
                            },
                            _logDeprecatedComponentWarning: function(e, t) {
                                u.default.log("W0000", this.NAME, e, "Use the '".concat(t, "' widget instead"))
                            },
                            _createOptionChangedAction: function() {
                                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                                    excludeValidators: ["disabled", "readOnly"]
                                })
                            },
                            _createDisposingAction: function() {
                                this._disposingAction = this._createActionByOption("onDisposing", {
                                    excludeValidators: ["disabled", "readOnly"]
                                })
                            },
                            _optionChanged: function(e) {
                                switch (e.name) {
                                    case "onDisposing":
                                    case "onInitialized":
                                    case "defaultOptionsRules":
                                        break;
                                    case "onOptionChanged":
                                        this._createOptionChangedAction()
                                }
                            },
                            _dispose: function() {
                                this._optionChangedCallbacks.empty(), this._createDisposingAction(), this._disposingAction(), this._eventsStrategy.dispose(), this._options.dispose(), this._disposed = !0
                            },
                            _lockUpdate: function() {
                                this._updateLockCount++
                            },
                            _unlockUpdate: function() {
                                this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
                            },
                            _isUpdateAllowed: function() {
                                return 0 === this._updateLockCount
                            },
                            _isInitializingRequired: function() {
                                return !this._initializing && !this._initialized
                            },
                            _commitUpdate: function() {
                                this.postponedOperations.callPostponedOperations(), this._isInitializingRequired() && this._initializeComponent()
                            },
                            _initializeComponent: function() {
                                this._initializing = !0;
                                try {
                                    this._init()
                                } finally {
                                    this._initializing = !1, this._lockUpdate(), this._createActionByOption("onInitialized", {
                                        excludeValidators: ["disabled", "readOnly"]
                                    })(), this._unlockUpdate(), this._initialized = !0
                                }
                            },
                            instance: function() {
                                return this
                            },
                            beginUpdate: function() {
                                this._lockUpdate()
                            },
                            endUpdate: function() {
                                this._unlockUpdate(), this._isUpdateAllowed() && this._commitUpdate()
                            },
                            _optionChanging: g.noop,
                            _notifyOptionChanged: function(e, t, n) {
                                if (this._initialized) {
                                    for (var i = [e].concat(this._options.getAliasesByName(e)), a = 0; a < i.length; a++) {
                                        var r = i[a],
                                            s = {
                                                name: (0, m.getPathParts)(r)[0],
                                                fullName: r,
                                                value: t,
                                                previousValue: n
                                            };
                                        0 !== r.indexOf("_", 0) && (this._optionChangedCallbacks.fireWith(this, [(0, o.extend)(this._defaultActionArgs(), s)]), this._optionChangedAction((0, o.extend)({}, s))), this._disposed || this._cancelOptionChange === r || this._optionChanged(s)
                                    }
                                }
                            },
                            initialOption: function(e) {
                                return this._options.initial(e)
                            },
                            _defaultActionConfig: function() {
                                return {
                                    context: this,
                                    component: this
                                }
                            },
                            _defaultActionArgs: function() {
                                return {
                                    component: this
                                }
                            },
                            _createAction: function(e, t) {
                                var n, i = this;
                                return function(a) {
                                    return (0, p.isDefined)(a) || (a = {}), (0, p.isPlainObject)(a) || (a = {
                                        actionValue: a
                                    }), (n = n || new l.default(e, (0, o.extend)(t, i._defaultActionConfig()))).execute.call(n, (0, o.extend)(a, i._defaultActionArgs()))
                                }
                            },
                            _createActionByOption: function(e, t) {
                                var n, o, a, r = this,
                                    s = function() {
                                        if (!o) {
                                            if (t = t || {}, "string" != typeof e) {
                                                throw u.default.Error("E0008")
                                            }
                                            0 === e.indexOf("on") && (o = v(e)), a = r.option()[e]
                                        }
                                        if (n || a || t.beforeExecute || t.afterExecute || r._eventsStrategy.hasEvent(o)) {
                                            if (!n) {
                                                var s = t.beforeExecute;
                                                t.beforeExecute = function() {
                                                    for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                                        t[n] = arguments[n]
                                                    }
                                                    s && s.apply(r, t), r._eventsStrategy.fireEvent(o, t[0].args)
                                                }, n = r._createAction(a, t)
                                            }
                                            for (var l = arguments.length, d = new Array(l), c = 0; c < l; c++) {
                                                d[c] = arguments[c]
                                            }
                                            if ((0, i.default)().wrapActionsBeforeExecute) {
                                                var h = r.option("beforeActionExecute") || g.noop,
                                                    f = h(r, n, t) || n;
                                                return f.apply(r, d)
                                            }
                                            return n.apply(r, d)
                                        }
                                    };
                                return (0, i.default)().wrapActionsBeforeExecute ? s : (this.option("onActionCreated") || g.noop)(this, s, t) || s
                            },
                            on: function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            },
                            off: function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            },
                            hasActionSubscription: function(e) {
                                return !!this._options.silent(e) || this._eventsStrategy.hasEvent(v(e))
                            },
                            isOptionDeprecated: function(e) {
                                return this._options.isDeprecated(e)
                            },
                            _setOptionWithoutOptionChange: function(e, t) {
                                this._cancelOptionChange = e, this.option(e, t), this._cancelOptionChange = !1
                            },
                            _getOptionValue: function(e, t) {
                                var n = this.option(e);
                                return (0, p.isFunction)(n) ? n.bind(t)() : n
                            },
                            option: function() {
                                var e;
                                return (e = this._options).option.apply(e, arguments)
                            },
                            resetOption: function(e) {
                                this.beginUpdate(), this._options.reset(e), this.endUpdate()
                            }
                        });
                    t.Component = y
                },
            99393:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component_registrator.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ./renderer */ 68374)),
                        o = s(n( /*! ./component_registrator_callbacks */ 5554)),
                        a = s(n( /*! ./errors */ 17381)),
                        r = n( /*! ./utils/public_component */ 9321);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    o.default.add((function(e, t) {
                        i.default.fn[e] = function(n) {
                            var i, o = "string" == typeof n;
                            if (o) {
                                var r = n,
                                    s = [].slice.call(arguments).slice(1);
                                this.each((function() {
                                    var n = t.getInstance(this);
                                    if (!n) {
                                        throw a.default.Error("E0009", e)
                                    }
                                    var o = n[r].apply(n, s);
                                    void 0 === i && (i = o)
                                }))
                            } else {
                                this.each((function() {
                                    var e = t.getInstance(this);
                                    e ? e.option(n) : new t(this, n)
                                })), i = this
                            }
                            return i
                        }
                    }));
                    t.default = function(e, t, n) {
                        n ? t[e] = n : n = t, (0, r.name)(n, e), o.default.fire(e, n)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            5554:
                /*!*************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component_registrator_callbacks.js ***!
                  \*************************************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var o = new(((i = n( /*! ./memorized_callbacks */ 83358)) && i.__esModule ? i : {
                        default: i
                    }).default);
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            80209:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/config.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ./utils/extend */ 13306),
                        a = (i = n( /*! ./errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            rtlEnabled: !1,
                            defaultCurrency: "USD",
                            oDataFilterToLower: !0,
                            serverDecimalSeparator: ".",
                            decimalSeparator: ".",
                            thousandsSeparator: ",",
                            forceIsoDateParsing: !0,
                            wrapActionsBeforeExecute: !0,
                            useLegacyStoreResult: !1,
                            useJQuery: void 0,
                            editorStylingMode: void 0,
                            useLegacyVisibleIndex: !1,
                            floatingActionButtonConfig: {
                                icon: "add",
                                closeIcon: "close",
                                label: "",
                                position: {
                                    at: "right bottom",
                                    my: "right bottom",
                                    offset: {
                                        x: -16,
                                        y: -16
                                    }
                                },
                                maxSpeedDialActionCount: 5,
                                shading: !1,
                                direction: "auto"
                            },
                            optionsParser: function(e) {
                                "{" !== e.trim().charAt(0) && (e = "{" + e + "}");
                                try {
                                    return new Function("return " + e)()
                                } catch (t) {
                                    throw a.default.Error("E3018", t, e)
                                }
                            }
                        },
                        s = ["decimalSeparator", "thousandsSeparator"],
                        l = function() {
                            if (!arguments.length) {
                                return r
                            }
                            var e = arguments.length <= 0 ? void 0 : arguments[0];
                            s.forEach((function(t) {
                                if (e[t]) {
                                    var n = "Now, the ".concat(t, " is selected based on the specified locale.");
                                    a.default.log("W0003", "config", t, "19.2", n)
                                }
                            })), (0, o.extend)(r, e)
                        };
                    "undefined" != typeof DevExpress && DevExpress.config && l(DevExpress.config);
                    var u = l;
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            20530:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/devices.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/size */ 58664),
                        o = _(n( /*! ../core/renderer */ 68374)),
                        a = n( /*! ./utils/window */ 58201),
                        r = n( /*! ./utils/extend */ 13306),
                        s = n( /*! ./utils/type */ 35922),
                        l = n( /*! ./utils/iterator */ 95479),
                        u = _(n( /*! ./errors */ 17381)),
                        d = _(n( /*! ./utils/callbacks */ 44504)),
                        c = _(n( /*! ./utils/ready_callbacks */ 24311)),
                        h = _(n( /*! ./utils/resize_callbacks */ 55814)),
                        f = n( /*! ./events_strategy */ 80566),
                        p = n( /*! ./utils/storage */ 36613),
                        g = n( /*! ./utils/view_port */ 77695),
                        m = _(n( /*! ./config */ 80209));

                    function _(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var v = (0, a.getNavigator)(),
                        y = (0, a.getWindow)(),
                        b = {
                            iPhone: "iPhone",
                            iPhone5: "iPhone",
                            iPhone6: "iPhone",
                            iPhone6plus: "iPhone",
                            iPad: "iPad",
                            iPadMini: "iPad Mini",
                            androidPhone: "Android Mobile",
                            androidTablet: "Android",
                            msSurface: "Windows ARM Tablet PC",
                            desktop: "desktop"
                        },
                        x = {
                            deviceType: "desktop",
                            platform: "generic",
                            version: [],
                            phone: !1,
                            tablet: !1,
                            android: !1,
                            ios: !1,
                            generic: !0,
                            grade: "A",
                            mac: !1
                        },
                        w = {
                            generic: function(e) {
                                var t = /windows phone/i.test(e) || e.match(/WPDesktop/),
                                    n = !t && /Windows(.*)arm(.*)Tablet PC/i.test(e),
                                    i = !t && !n && /msapphost/i.test(e),
                                    o = /((intel|ppc) mac os x)/.test(e.toLowerCase());
                                if (t || n || i || o) {
                                    return {
                                        deviceType: t ? "phone" : n ? "tablet" : "desktop",
                                        platform: "generic",
                                        version: [],
                                        grade: "A",
                                        mac: o
                                    }
                                }
                            },
                            ios: function(e) {
                                if (/ip(hone|od|ad)/i.test(e)) {
                                    var t = /ip(hone|od)/i.test(e),
                                        n = e.match(/os (\d+)_(\d+)_?(\d+)?/i);
                                    return {
                                        deviceType: t ? "phone" : "tablet",
                                        platform: "ios",
                                        version: n ? [parseInt(n[1], 10), parseInt(n[2], 10), parseInt(n[3] || 0, 10)] : [],
                                        grade: 480 === y.screen.height ? "B" : "A"
                                    }
                                }
                            },
                            android: function(e) {
                                if (/android|htc_|silk/i.test(e)) {
                                    var t = /mobile/i.test(e),
                                        n = e.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),
                                        i = n ? [parseInt(n[1], 10), parseInt(n[2] || 0, 10), parseInt(n[3] || 0, 10)] : [];
                                    return {
                                        deviceType: t ? "phone" : "tablet",
                                        platform: "android",
                                        version: i,
                                        grade: i.length > 1 && (i[0] < 4 || 4 === i[0] && i[1] < 4) ? "B" : "A"
                                    }
                                }
                            }
                        },
                        C = new(function() {
                            function e(e) {
                                this._window = (null == e ? void 0 : e.window) || y, this._realDevice = this._getDevice(), this._currentDevice = void 0, this._currentOrientation = void 0, this._eventsStrategy = new f.EventsStrategy(this), this.changed = (0, d.default)(), (0, a.hasWindow)() && (c.default.add(this._recalculateOrientation.bind(this)), h.default.add(this._recalculateOrientation.bind(this)))
                            }
                            var t = e.prototype;
                            return t.current = function(e) {
                                if (e) {
                                    return this._currentDevice = this._getDevice(e), this._forced = !0, void this.changed.fire()
                                }
                                if (!this._currentDevice) {
                                    e = void 0;
                                    try {
                                        e = this._getDeviceOrNameFromWindowScope()
                                    } catch (t) {
                                        e = this._getDeviceNameFromSessionStorage()
                                    } finally {
                                        e || (e = this._getDeviceNameFromSessionStorage()), e && (this._forced = !0)
                                    }
                                    this._currentDevice = this._getDevice(e)
                                }
                                return this._currentDevice
                            }, t.real = function(e) {
                                return (0, r.extend)({}, this._realDevice)
                            }, t.orientation = function() {
                                return this._currentOrientation
                            }, t.isForced = function() {
                                return this._forced
                            }, t.isRippleEmulator = function() {
                                return !!this._window.tinyHippos
                            }, t._getCssClasses = function(e) {
                                var t = [],
                                    n = this._realDevice;
                                return (e = e || this.current()).deviceType && (t.push("dx-device-".concat(e.deviceType)), "desktop" !== e.deviceType && t.push("dx-device-mobile")), t.push("dx-device-".concat(n.platform)), n.version && n.version.length && t.push("dx-device-".concat(n.platform, "-").concat(n.version[0])), this.isSimulator() && t.push("dx-simulator"), (0, m.default)().rtlEnabled && t.push("dx-rtl"), t
                            }, t.attachCssClasses = function(e, t) {
                                this._deviceClasses = this._getCssClasses(t).join(" "), (0, o.default)(e).addClass(this._deviceClasses)
                            }, t.detachCssClasses = function(e) {
                                (0, o.default)(e).removeClass(this._deviceClasses)
                            }, t.isSimulator = function() {
                                try {
                                    return this._isSimulator || (0, a.hasWindow)() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                                } catch (e) {
                                    return !1
                                }
                            }, t.forceSimulator = function() {
                                this._isSimulator = !0
                            }, t._getDevice = function(e) {
                                if ("genericPhone" === e && (e = {
                                        deviceType: "phone",
                                        platform: "generic",
                                        generic: !0
                                    }), (0, s.isPlainObject)(e)) {
                                    return this._fromConfig(e)
                                }
                                var t;
                                if (e) {
                                    if (!(t = b[e])) {
                                        throw u.default.Error("E0005")
                                    }
                                } else {
                                    t = v.userAgent
                                }
                                return this._fromUA(t)
                            }, t._getDeviceOrNameFromWindowScope = function() {
                                var e;
                                return (0, a.hasWindow)() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]) && (e = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]), e
                            }, t._getDeviceNameFromSessionStorage = function() {
                                var e = (0, p.sessionStorage)();
                                if (e) {
                                    var t = e.getItem("dx-force-device");
                                    try {
                                        return JSON.parse(t)
                                    } catch (e) {
                                        return t
                                    }
                                }
                            }, t._fromConfig = function(e) {
                                var t = (0, r.extend)({}, x, this._currentDevice, e),
                                    n = {
                                        phone: "phone" === t.deviceType,
                                        tablet: "tablet" === t.deviceType,
                                        android: "android" === t.platform,
                                        ios: "ios" === t.platform,
                                        generic: "generic" === t.platform
                                    };
                                return (0, r.extend)(t, n)
                            }, t._fromUA = function(e) {
                                var t;
                                return (0, l.each)(w, (function(n, i) {
                                    return !(t = i(e))
                                })), t ? this._fromConfig(t) : x
                            }, t._changeOrientation = function() {
                                var e = (0, o.default)(this._window),
                                    t = (0, i.getHeight)(e) > (0, i.getWidth)(e) ? "portrait" : "landscape";
                                this._currentOrientation !== t && (this._currentOrientation = t, this._eventsStrategy.fireEvent("orientationChanged", [{
                                    orientation: t
                                }]))
                            }, t._recalculateOrientation = function() {
                                var e = (0, i.getWidth)(this._window);
                                this._currentWidth !== e && (this._currentWidth = e, this._changeOrientation())
                            }, t.on = function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            }, t.off = function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            }, e
                        }()),
                        S = (0, g.value)();
                    S && C.attachCssClasses(S), g.changeCallback.add((function(e, t) {
                        C.detachCssClasses(t), C.attachCssClasses(e)
                    }));
                    var k = C;
                    t.default = k, e.exports = t.default, e.exports.default = t.default
                },
            73349:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/dom_adapter.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ./utils/dependency_injector */ 20476)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./utils/common */ 20576);

                    function r(e) {
                        return r = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, r(e)
                    }
                    var s = {
                            querySelectorAll: function(e, t) {
                                return e.querySelectorAll(t)
                            },
                            elementMatches: function(e, t) {
                                var n = this,
                                    i = e.matches || e.matchesSelector || e.mozMatchesSelector || e.msMatchesSelector || e.oMatchesSelector || e.webkitMatchesSelector || function(t) {
                                        var i = e.document || e.ownerDocument;
                                        if (!i) {
                                            return !1
                                        }
                                        for (var o = n.querySelectorAll(i, t), a = 0; a < o.length; a++) {
                                            if (o[a] === e) {
                                                return !0
                                            }
                                        }
                                    };
                                return i.call(e, t)
                            },
                            createElement: function(e, t) {
                                return (t = t || this._document).createElement(e)
                            },
                            createElementNS: function(e, t, n) {
                                return (n = n || this._document).createElementNS(e, t)
                            },
                            createTextNode: function(e, t) {
                                return (t = t || this._document).createTextNode(e)
                            },
                            isNode: function(e) {
                                return e && "object" === r(e) && "nodeType" in e && "nodeName" in e
                            },
                            isElementNode: function(e) {
                                return e && 1 === e.nodeType
                            },
                            isTextNode: function(e) {
                                return e && 3 === e.nodeType
                            },
                            isDocument: function(e) {
                                return e && 9 === e.nodeType
                            },
                            removeElement: function(e) {
                                var t = e && e.parentNode;
                                t && t.removeChild(e)
                            },
                            insertElement: function(e, t, n) {
                                e && t && e !== t && (n ? e.insertBefore(t, n) : e.appendChild(t))
                            },
                            getAttribute: function(e, t) {
                                return e.getAttribute(t)
                            },
                            setAttribute: function(e, t, n) {
                                e.setAttribute(t, n)
                            },
                            removeAttribute: function(e, t) {
                                e.removeAttribute(t)
                            },
                            setProperty: function(e, t, n) {
                                e[t] = n
                            },
                            setText: function(e, t) {
                                e && (e.textContent = t)
                            },
                            setClass: function(e, t, n) {
                                1 === e.nodeType && t && (n ? e.classList.add(t) : e.classList.remove(t))
                            },
                            setStyle: function(e, t, n) {
                                e.style[t] = n || ""
                            },
                            _document: "undefined" == typeof document ? void 0 : document,
                            getDocument: function() {
                                return this._document
                            },
                            getActiveElement: function() {
                                return this._document.activeElement
                            },
                            getBody: function() {
                                return this._document.body
                            },
                            createDocumentFragment: function() {
                                return this._document.createDocumentFragment()
                            },
                            getDocumentElement: function() {
                                return this._document.documentElement
                            },
                            getLocation: function() {
                                return this._document.location
                            },
                            getSelection: function() {
                                return this._document.selection
                            },
                            getReadyState: function() {
                                return this._document.readyState
                            },
                            getHead: function() {
                                return this._document.head
                            },
                            hasDocumentProperty: function(e) {
                                return e in this._document
                            },
                            listen: function(e, t, n, i) {
                                return e && "addEventListener" in e ? (e.addEventListener(t, n, i), function() {
                                    e.removeEventListener(t, n)
                                }) : a.noop
                            },
                            elementsFromPoint: function(e, t) {
                                return this._document.elementsFromPoint(e, t)
                            }
                        },
                        l = (0, o.default)(s);
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            13046:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/dom_component.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = y(n( /*! ../core/renderer */ 68374)),
                        o = y(n( /*! ./config */ 80209)),
                        a = y(n( /*! ./errors */ 17381)),
                        r = y(n( /*! ../core/utils/resize_callbacks */ 55814)),
                        s = n( /*! ./component */ 44297),
                        l = n( /*! ./template_manager */ 14192),
                        u = n( /*! ./utils/public_component */ 9321),
                        d = n( /*! ./element_data */ 97906),
                        c = n( /*! ./utils/iterator */ 95479),
                        h = n( /*! ./utils/extend */ 13306),
                        f = n( /*! ../core/element */ 6415),
                        p = n( /*! ./utils/common */ 20576),
                        g = n( /*! ./utils/array */ 89386),
                        m = n( /*! ./utils/type */ 35922),
                        _ = n( /*! ../core/utils/window */ 58201),
                        v = n( /*! ../events/short */ 72918);

                    function y(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var b = s.Component.abstract,
                        x = s.Component.inherit({
                            _getDefaultOptions: function() {
                                return (0, h.extend)(this.callBase(), {
                                    width: void 0,
                                    height: void 0,
                                    rtlEnabled: (0, o.default)().rtlEnabled,
                                    elementAttr: {},
                                    disabled: !1,
                                    integrationOptions: {}
                                }, this._useTemplates() ? l.TemplateManager.createDefaultOptions() : {})
                            },
                            ctor: function(e, t) {
                                this._customClass = null, this._createElement(e), (0, u.attachInstanceToElement)(this._$element, this, this._dispose), this.callBase(t)
                            },
                            _createElement: function(e) {
                                this._$element = (0, i.default)(e)
                            },
                            _getSynchronizableOptionsForCreateComponent: function() {
                                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
                            },
                            _checkFunctionValueDeprecation: function(e) {
                                var t = this;
                                this.option("_ignoreFunctionValueDeprecation") || e.forEach((function(e) {
                                    (0, m.isFunction)(t.option(e)) && a.default.log("W0017", e)
                                }))
                            },
                            _visibilityChanged: b,
                            _dimensionChanged: b,
                            _init: function() {
                                this.callBase(), this._checkFunctionValueDeprecation(["width", "height", "maxHeight", "maxWidth", "minHeight", "minWidth", "popupHeight", "popupWidth"]), this._attachWindowResizeCallback(), this._initTemplateManager()
                            },
                            _setOptionsByDevice: function(e) {
                                this.callBase([].concat(this.constructor._classCustomRules || [], e || []))
                            },
                            _isInitialOptionValue: function(e) {
                                return !(this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), e)) && this.callBase(e)
                            },
                            _attachWindowResizeCallback: function() {
                                if (this._isDimensionChangeSupported()) {
                                    var e = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                                    r.default.add(e)
                                }
                            },
                            _isDimensionChangeSupported: function() {
                                return this._dimensionChanged !== b
                            },
                            _renderComponent: function() {
                                this._initMarkup(), (0, _.hasWindow)() && this._render()
                            },
                            _initMarkup: function() {
                                var e = (this.option() || {}).rtlEnabled;
                                this._renderElementAttributes(), this._toggleRTLDirection(e), this._renderVisibilityChange(), this._renderDimensions()
                            },
                            _render: function() {
                                this._attachVisibilityChangeHandlers()
                            },
                            _renderElementAttributes: function() {
                                var e = (this.option() || {}).elementAttr,
                                    t = (0, h.extend)({}, e),
                                    n = t.class;
                                delete t.class, this.$element().attr(t).removeClass(this._customClass).addClass(n), this._customClass = n
                            },
                            _renderVisibilityChange: function() {
                                (this._isDimensionChangeSupported() && this._attachDimensionChangeHandlers(), this._isVisibilityChangeSupported()) && this.$element().addClass("dx-visibility-change-handler")
                            },
                            _renderDimensions: function() {
                                var e = this.$element(),
                                    t = e.get(0),
                                    n = this._getOptionValue("width", t),
                                    i = this._getOptionValue("height", t);
                                this._isCssUpdateRequired(t, i, n) && e.css({
                                    width: null === n ? "" : n,
                                    height: null === i ? "" : i
                                })
                            },
                            _isCssUpdateRequired: function(e, t, n) {
                                return !!((0, m.isDefined)(n) || (0, m.isDefined)(t) || e.style.width || e.style.height)
                            },
                            _attachDimensionChangeHandlers: function() {
                                var e = this,
                                    t = this.$element(),
                                    n = "".concat(this.NAME, "VisibilityChange");
                                v.resize.off(t, {
                                    namespace: n
                                }), v.resize.on(t, (function() {
                                    return e._dimensionChanged()
                                }), {
                                    namespace: n
                                })
                            },
                            _attachVisibilityChangeHandlers: function() {
                                var e = this;
                                if (this._isVisibilityChangeSupported()) {
                                    var t = this.$element(),
                                        n = "".concat(this.NAME, "VisibilityChange");
                                    this._isHidden = !this._isVisible(), v.visibility.off(t, {
                                        namespace: n
                                    }), v.visibility.on(t, (function() {
                                        return e._checkVisibilityChanged("shown")
                                    }), (function() {
                                        return e._checkVisibilityChanged("hiding")
                                    }), {
                                        namespace: n
                                    })
                                }
                            },
                            _isVisible: function() {
                                return this.$element().is(":visible")
                            },
                            _checkVisibilityChanged: function(e) {
                                this._isVisible() && ("hiding" !== e || this._isHidden ? "shown" === e && this._isHidden && (this._isHidden = !1, this._visibilityChanged(!0)) : (this._visibilityChanged(!1), this._isHidden = !0))
                            },
                            _isVisibilityChangeSupported: function() {
                                return this._visibilityChanged !== b && (0, _.hasWindow)()
                            },
                            _clean: p.noop,
                            _modelByElement: function() {
                                var e = this.option().modelByElement,
                                    t = this.$element();
                                return e ? e(t) : void 0
                            },
                            _invalidate: function() {
                                if (this._isUpdateAllowed()) {
                                    throw a.default.Error("E0007")
                                }
                                this._requireRefresh = !0
                            },
                            _refresh: function() {
                                this._clean(), this._renderComponent()
                            },
                            _dispose: function() {
                                this._templateManager && this._templateManager.dispose(), this.callBase(), this._clean(), this._detachWindowResizeCallback()
                            },
                            _detachWindowResizeCallback: function() {
                                this._isDimensionChangeSupported() && r.default.remove(this._windowResizeCallBack)
                            },
                            _toggleRTLDirection: function(e) {
                                this.$element().toggleClass("dx-rtl", e)
                            },
                            _createComponent: function(e, t) {
                                var n = this,
                                    o = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                    a = (0, p.grep)(this._getSynchronizableOptionsForCreateComponent(), (function(e) {
                                        return !(e in o)
                                    })),
                                    r = this.option(),
                                    s = r.integrationOptions,
                                    l = this.option(),
                                    u = l.nestedComponentOptions;
                                u = u || p.noop;
                                var d = (0, h.extend)({
                                    integrationOptions: s
                                }, u(this));
                                a.forEach((function(e) {
                                    return d[e] = n.option(e)
                                })), this._extendConfig(o, d);
                                var c = void 0;
                                if ((0, m.isString)(t)) {
                                    var f = (0, i.default)(e)[t](o);
                                    c = f[t]("instance")
                                } else {
                                    e && ((c = t.getInstance(e)) ? c.option(o) : c = new t(e, o))
                                }
                                if (c) {
                                    var _ = function(e) {
                                        var t = e.name,
                                            n = e.value;
                                        (0, g.inArray)(t, a) >= 0 && c.option(t, n)
                                    };
                                    this.on("optionChanged", _), c.on("disposing", (function() {
                                        return n.off("optionChanged", _)
                                    }))
                                }
                                return c
                            },
                            _extendConfig: function(e, t) {
                                (0, c.each)(t, (function(t, n) {
                                    !Object.prototype.hasOwnProperty.call(e, t) && (e[t] = n)
                                }))
                            },
                            _defaultActionConfig: function() {
                                var e = this.$element(),
                                    t = this._modelByElement(e);
                                return (0, h.extend)(this.callBase(), {
                                    context: t
                                })
                            },
                            _defaultActionArgs: function() {
                                var e = this.$element(),
                                    t = this._modelByElement(e),
                                    n = this.element();
                                return (0, h.extend)(this.callBase(), {
                                    element: n,
                                    model: t
                                })
                            },
                            _optionChanged: function(e) {
                                switch (e.name) {
                                    case "width":
                                    case "height":
                                        this._renderDimensions();
                                        break;
                                    case "rtlEnabled":
                                        this._invalidate();
                                        break;
                                    case "elementAttr":
                                        this._renderElementAttributes();
                                        break;
                                    case "disabled":
                                    case "integrationOptions":
                                        break;
                                    default:
                                        this.callBase(e)
                                }
                            },
                            _removeAttributes: function(e) {
                                for (var t = e.attributes, n = t.length - 1; n >= 0; n--) {
                                    var i = t[n];
                                    if (i) {
                                        var o = i.name;
                                        o.indexOf("aria-") && -1 === o.indexOf("dx-") && "role" !== o && "style" !== o && "tabindex" !== o || e.removeAttribute(o)
                                    }
                                }
                            },
                            _removeClasses: function(e) {
                                e.className = e.className.split(" ").filter((function(e) {
                                    return 0 !== e.lastIndexOf("dx-", 0)
                                })).join(" ")
                            },
                            _updateDOMComponent: function(e) {
                                e ? this._renderComponent() : this._requireRefresh && (this._requireRefresh = !1, this._refresh())
                            },
                            endUpdate: function() {
                                var e = this._isInitializingRequired();
                                this.callBase(), this._isUpdateAllowed() && this._updateDOMComponent(e)
                            },
                            $element: function() {
                                return this._$element
                            },
                            element: function() {
                                var e = this.$element();
                                return (0, f.getPublicElement)(e)
                            },
                            dispose: function() {
                                var e = this.$element().get(0);
                                (0, d.cleanDataRecursive)(e, !0), e.textContent = "", this._removeAttributes(e), this._removeClasses(e)
                            },
                            resetOption: function(e) {
                                if (this.callBase(e), "width" === e || "height" === e) {
                                    var t = this.initialOption(e);
                                    !(0, m.isDefined)(t) && this.$element().css(e, "")
                                }
                            },
                            _getAnonymousTemplateName: function() {},
                            _initTemplateManager: function() {
                                if (!this._templateManager && this._useTemplates()) {
                                    var e = this.option().integrationOptions,
                                        t = (void 0 === e ? {} : e).createTemplate;
                                    this._templateManager = new l.TemplateManager(t, this._getAnonymousTemplateName()), this._initTemplates()
                                }
                            },
                            _initTemplates: function() {
                                var e = this,
                                    t = this._templateManager.extractTemplates(this.$element()),
                                    n = t.templates,
                                    i = t.anonymousTemplateMeta,
                                    o = this.option("integrationOptions.templates.".concat(i.name));
                                n.forEach((function(t) {
                                    var n = t.name,
                                        i = t.template;
                                    e._options.silent("integrationOptions.templates.".concat(n), i)
                                })), i.name && !o && (this._options.silent("integrationOptions.templates.".concat(i.name), i.template), this._options.silent("_hasAnonymousTemplateContent", !0))
                            },
                            _getTemplateByOption: function(e) {
                                return this._getTemplate(this.option(e))
                            },
                            _getTemplate: function(e) {
                                var t = this.option("integrationOptions.templates"),
                                    n = this.option("templatesRenderAsynchronously"),
                                    i = this.option("integrationOptions.skipTemplates");
                                return this._templateManager.getTemplate(e, t, {
                                    isAsyncTemplate: n,
                                    skipTemplates: i
                                }, this)
                            },
                            _saveTemplate: function(e, t) {
                                this._setOptionWithoutOptionChange("integrationOptions.templates." + e, this._templateManager._createTemplate(t))
                            },
                            _useTemplates: function() {
                                return !0
                            }
                        });
                    x.getInstance = function(e) {
                        return (0, u.getInstanceByElement)((0, i.default)(e), this)
                    }, x.defaultOptions = function(e) {
                        this._classCustomRules = this._classCustomRules || [], this._classCustomRules.push(e)
                    };
                    var w = x;
                    t.default = w, e.exports = t.default, e.exports.default = t.default
                },
            6415:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/element.js ***!
                  \*************************************************************/
                function(e, t) {
                    t.getPublicElement = function(e) {
                        return n(e)
                    }, t.setPublicElementWrapper = function(e) {
                        n = e
                    };
                    var n = function(e) {
                        return e && e.get(0)
                    }
                },
            97906:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/element_data.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.afterCleanData = function(e) {
                        h = e
                    }, t.beforeCleanData = function(e) {
                        c = e
                    }, t.cleanData = function(e) {
                        return l.cleanData.call(this, e)
                    }, t.cleanDataRecursive = function(e, t) {
                        if (!o.default.isElementNode(e)) {
                            return
                        }
                        var n = e.getElementsByTagName("*");
                        l.cleanData(n), t && l.cleanData([e])
                    }, t.data = function() {
                        return l.data.apply(this, arguments)
                    }, t.getDataStrategy = function() {
                        return l
                    }, t.removeData = function(e, t) {
                        return l.removeData.call(this, e, t)
                    }, t.strategyChanging = t.setDataStrategy = void 0;
                    var i = s(n( /*! ./polyfills/weak_map */ 10126)),
                        o = s(n( /*! ./dom_adapter */ 73349)),
                        a = s(n( /*! ../events/core/events_engine */ 55994)),
                        r = s(n( /*! ./memorized_callbacks */ 83358));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l, u = new i.default,
                        d = new r.default;
                    t.strategyChanging = d;
                    var c = function() {},
                        h = function() {},
                        f = function(e) {
                            d.fire(e);
                            var t = (l = e).cleanData;
                            l.cleanData = function(e) {
                                c(e);
                                var n = t.call(this, e);
                                return h(e), n
                            }
                        };
                    t.setDataStrategy = f, f({
                        data: function() {
                            var e = arguments[0],
                                t = arguments[1],
                                n = arguments[2];
                            if (e) {
                                var i = u.get(e);
                                return i || (i = {}, u.set(e, i)), void 0 === t ? i : 2 === arguments.length ? i[t] : (i[t] = n, n)
                            }
                        },
                        removeData: function(e, t) {
                            if (e) {
                                if (void 0 === t) {
                                    u.delete(e)
                                } else {
                                    var n = u.get(e);
                                    n && delete n[t]
                                }
                            }
                        },
                        cleanData: function(e) {
                            for (var t = 0; t < e.length; t++) {
                                a.default.off(e[t]), u.delete(e[t])
                            }
                        }
                    })
                },
            17381:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/errors.js ***!
                  \************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var o = (0, ((i = n( /*! ./utils/error */ 95640)) && i.__esModule ? i : {
                        default: i
                    }).default)({
                        E0001: "Method is not implemented",
                        E0002: "Member name collision: {0}",
                        E0003: "A class must be instantiated using the 'new' keyword",
                        E0004: "The NAME property of the component is not specified",
                        E0005: "Unknown device",
                        E0006: "Unknown endpoint key is requested",
                        E0007: "'Invalidate' method is called outside the update transaction",
                        E0008: "Type of the option name is not appropriate to create an action",
                        E0009: "Component '{0}' has not been initialized for an element",
                        E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
                        E0011: "Unknown animation type '{0}'",
                        E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
                        E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
                        E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
                        E0015: "Queued task returned an unexpected result",
                        E0017: "Event namespace is not defined",
                        E0018: "DevExpress.ui.DevExpressPopup widget is required",
                        E0020: "Template engine '{0}' is not supported",
                        E0021: "Unknown theme is set: {0}",
                        E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
                        E0023: "Template name is not specified",
                        E0024: "DevExtreme bundle already included",
                        E0025: "Unexpected argument type",
                        E0100: "Unknown validation type is detected",
                        E0101: "Misconfigured range validation rule is detected",
                        E0102: "Misconfigured comparison validation rule is detected",
                        E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
                        E0110: "Unknown validation group is detected",
                        E0120: "Adapter for a DevExpressValidator component cannot be configured",
                        E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
                        W0000: "'{0}' is deprecated in {1}. {2}",
                        W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
                        W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
                        W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
                        W0004: "Timeout for theme loading is over: {0}",
                        W0005: "'{0}' event is deprecated in {1}. {2}",
                        W0006: "Invalid recurrence rule: '{0}'",
                        W0007: "'{0}' Globalize culture is not defined",
                        W0008: "Invalid view name: '{0}'",
                        W0009: "Invalid time zone name: '{0}'",
                        W0010: "{0} is deprecated in {1}. {2}",
                        W0011: "Number parsing is invoked while the parser is not defined",
                        W0012: "Date parsing is invoked while the parser is not defined",
                        W0013: "'{0}' file is deprecated in {1}. {2}",
                        W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
                        W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
                        W0016: 'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',
                        W0017: 'Setting the "{0}" property with a function is deprecated since v21.2',
                        W0018: 'Setting the "position" property with a function is deprecated since v21.2'
                    });
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            80566:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/events_strategy.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.EventsStrategy = void 0;
                    var i, o = (i = n( /*! ./utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./utils/iterator */ 95479),
                        r = n( /*! ./utils/type */ 35922);
                    var s = function() {
                        function e(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                            this._events = {}, this._owner = e, this._options = t
                        }
                        e.create = function(t, n) {
                            return n ? (0, r.isFunction)(n) ? n(t) : n : new e(t)
                        };
                        var t = e.prototype;
                        return t.hasEvent = function(e) {
                            var t = this._events[e];
                            return !!t && t.has()
                        }, t.fireEvent = function(e, t) {
                            var n = this._events[e];
                            return n && n.fireWith(this._owner, t), this._owner
                        }, t.on = function(e, t) {
                            var n = this;
                            if ((0, r.isPlainObject)(e)) {
                                (0, a.each)(e, (function(e, t) {
                                    n.on(e, t)
                                }))
                            } else {
                                var i = this._events[e];
                                i || (i = (0, o.default)({
                                    syncStrategy: this._options.syncStrategy
                                }), this._events[e] = i), (i.originalAdd || i.add).call(i, t)
                            }
                        }, t.off = function(e, t) {
                            var n = this._events[e];
                            n && ((0, r.isFunction)(t) ? n.remove(t) : n.empty())
                        }, t.dispose = function() {
                            (0, a.each)(this._events, (function(e, t) {
                                t.empty()
                            }))
                        }, e
                    }();
                    t.EventsStrategy = s
                },
            73176:
                /*!**********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/guid.js ***!
                  \**********************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var o = ((i = n( /*! ./class */ 38377)) && i.__esModule ? i : {
                        default: i
                    }).default.inherit({
                        ctor: function(e) {
                            e && (e = String(e)), this._value = this._normalize(e || this._generate())
                        },
                        _normalize: function(e) {
                            for (e = e.replace(/[^a-f0-9]/gi, "").toLowerCase(); e.length < 32;) {
                                e += "0"
                            }
                            return [e.substr(0, 8), e.substr(8, 4), e.substr(12, 4), e.substr(16, 4), e.substr(20, 12)].join("-")
                        },
                        _generate: function() {
                            for (var e = "", t = 0; t < 32; t++) {
                                e += Math.round(15 * Math.random()).toString(16)
                            }
                            return e
                        },
                        toString: function() {
                            return this._value
                        },
                        valueOf: function() {
                            return this._value
                        },
                        toJSON: function() {
                            return this._value
                        }
                    });
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            83448:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/http_request.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ./utils/window */ 58201),
                        a = (i = n( /*! ./utils/dependency_injector */ 20476)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = (0, o.getWindow)(),
                        s = {
                            getXhr: function() {
                                return new r.XMLHttpRequest
                            }
                        },
                        l = (0, a.default)(s);
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            15334:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/inferno_renderer.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! inferno */ 55285),
                        o = n( /*! @devextreme/runtime/inferno */ 44105),
                        a = n( /*! inferno-create-element */ 87456),
                        r = u(n( /*! ./dom_adapter */ 73349)),
                        s = n( /*! ./element_data */ 97906),
                        l = u(n( /*! ./utils/dependency_injector */ 20476));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = function(e) {
                            var t = e.parentNode;
                            t && ((0, s.cleanDataRecursive)(e), t.$V = e.$V, (0, i.render)(null, t), t.appendChild(e), e.innerHTML = "", delete t.$V), delete e.$V
                        },
                        c = (0, l.default)({
                            createElement: function(e, t) {
                                return (0, a.createElement)(e, t)
                            },
                            remove: d,
                            onAfterRender: function() {
                                o.InfernoEffectHost.callEffects()
                            },
                            onPreRender: function() {
                                o.InfernoEffectHost.lock()
                            },
                            render: function(e, t, n, s) {
                                if (s) {
                                    (0, i.render)((0, a.createElement)(e, t), n)
                                } else {
                                    var l = n.parentNode,
                                        u = null == n ? void 0 : n.nextSibling,
                                        c = r.default.createElement("div");
                                    c.appendChild(n);
                                    var h = r.default.createDocumentFragment().appendChild(c);
                                    !!n.$V && d(n), (0, o.hydrate)((0, a.createElement)(e, t), h), n.$V = h.$V, l && l.insertBefore(n, u)
                                }
                            }
                        });
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            83358:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/memorized_callbacks.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../core/utils/iterator */ 95479),
                        a = (i = n( /*! ./utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function() {
                        function e() {
                            this.memory = [], this.callbacks = (0, a.default)()
                        }
                        var t = e.prototype;
                        return t.add = function(e) {
                            (0, o.each)(this.memory, (function(t, n) {
                                return e.apply(e, n)
                            })), this.callbacks.add(e)
                        }, t.remove = function(e) {
                            this.callbacks.remove(e)
                        }, t.fire = function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            this.memory.push(t), this.callbacks.fire.apply(this.callbacks, t)
                        }, e
                    }();
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            95683:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/index.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.Options = void 0;
                    var i = n( /*! ../utils/type */ 35922),
                        o = n( /*! ../utils/common */ 20576),
                        a = n( /*! ./option_manager */ 9030),
                        r = n( /*! ../utils/data */ 47617),
                        s = n( /*! ./utils */ 45434),
                        l = n( /*! ../utils/extend */ 13306);

                    function u() {
                        return u = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, u.apply(this, arguments)
                    }

                    function d(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    var c = function() {
                        function e(e, t, n, i) {
                            var o = this;
                            this._deprecatedCallback, this._startChangeCallback, this._endChangeCallback, this._default = t, this._deprecated = i, this._deprecatedNames = [], this._initDeprecatedNames(), this._optionManager = new a.OptionManager(e, n), this._optionManager.onRelevantNamesPrepared((function(e, t, n, i) {
                                return o._setRelevantNames(e, t, n, i)
                            })), this._cachedOptions = {}, this._rules = []
                        }
                        var t, n, c, h = e.prototype;
                        return h._initDeprecatedNames = function() {
                            for (var e in this._deprecated) {
                                this._deprecatedNames.push(e)
                            }
                        }, h._getByRules = function(e) {
                            return e = Array.isArray(e) ? this._rules.concat(e) : this._rules, (0, s.convertRulesToOptions)(e)
                        }, h._notifyDeprecated = function(e) {
                            var t = this._deprecated[e];
                            t && this._deprecatedCallback(e, t)
                        }, h._setRelevantNames = function(e, t, n, i) {
                            if (t) {
                                var o = this._normalizeName(t, i);
                                o && o !== t && (this._setField(e, o, n), this._clearField(e, t))
                            }
                        }, h._setField = function(e, t, n) {
                            var i = "",
                                o = null;
                            do {
                                i = i ? ".".concat(i) : "", i = (0, s.getFieldName)(t) + i, o = (t = (0, s.getParentName)(t)) ? this._optionManager.get(e, t, !1) : e
                            } while (!o);
                            o[i] = n
                        }, h._clearField = function(e, t) {
                            delete e[t];
                            var n = (0, s.getParentName)(t),
                                i = n ? this._optionManager.get(e, n, !1) : e;
                            i && delete i[(0, s.getFieldName)(t)]
                        }, h._normalizeName = function(e, t) {
                            if (this._deprecatedNames.length && e) {
                                for (var n = 0; n < this._deprecatedNames.length; n++) {
                                    if (this._deprecatedNames[n] === e) {
                                        var i = this._deprecated[e];
                                        if (i) {
                                            return !t && this._notifyDeprecated(e), i.alias || e
                                        }
                                    }
                                }
                            }
                            return e
                        }, h.addRules = function(e) {
                            this._rules = e.concat(this._rules)
                        }, h.applyRules = function(e) {
                            var t = this._getByRules(e);
                            this.silent(t)
                        }, h.dispose = function() {
                            this._deprecatedCallback = o.noop, this._startChangeCallback = o.noop, this._endChangeCallback = o.noop, this._optionManager.dispose()
                        }, h.onChanging = function(e) {
                            this._optionManager.onChanging(e)
                        }, h.onChanged = function(e) {
                            this._optionManager.onChanged(e)
                        }, h.onDeprecated = function(e) {
                            this._deprecatedCallback = e
                        }, h.onStartChange = function(e) {
                            this._startChangeCallback = e
                        }, h.onEndChange = function(e) {
                            this._endChangeCallback = e
                        }, h.isInitial = function(e) {
                            var t = this.silent(e),
                                n = this.initial(e);
                            return (0, i.isFunction)(t) && (0, i.isFunction)(n) ? t.toString() === n.toString() : (0, o.equalByValue)(t, n)
                        }, h.initial = function(e) {
                            return (0, s.getNestedOptionValue)(this._initial, e)
                        }, h.option = function(e, t) {
                            var n = arguments.length < 2 && "object" !== (0, i.type)(e);
                            if (n) {
                                return this._optionManager.get(void 0, this._normalizeName(e))
                            }
                            this._startChangeCallback();
                            try {
                                this._optionManager.set(e, t)
                            } finally {
                                this._endChangeCallback()
                            }
                        }, h.silent = function(e, t) {
                            var n = arguments.length < 2 && "object" !== (0, i.type)(e);
                            if (n) {
                                return this._optionManager.get(void 0, e, void 0, !0)
                            }
                            this._optionManager.set(e, t, void 0, !0)
                        }, h.reset = function(e) {
                            var t = this;
                            if (e) {
                                var n = (0, r.getPathParts)(e).reduce((function(e, n) {
                                        return e ? e[n] : t.initial(n)
                                    }), null),
                                    o = (0, i.isObject)(n) ? u({}, n) : n;
                                this._optionManager.set(e, o, !1)
                            }
                        }, h.getAliasesByName = function(e) {
                            var t = this;
                            return Object.keys(this._deprecated).filter((function(n) {
                                return e === t._deprecated[n].alias
                            }))
                        }, h.isDeprecated = function(e) {
                            return Object.prototype.hasOwnProperty.call(this._deprecated, e)
                        }, h.cache = function(e, t) {
                            var n = arguments.length < 2;
                            if (n) {
                                return this._cachedOptions[e]
                            }
                            this._cachedOptions[e] = (0, l.extend)(this._cachedOptions[e], t)
                        }, t = e, (n = [{
                            key: "_initial",
                            get: function() {
                                if (!this._initialOptions) {
                                    var e = this._getByRules(this.silent("defaultOptionsRules"));
                                    this._initialOptions = this._default, this._optionManager._setByReference(this._initialOptions, e)
                                }
                                return this._initialOptions
                            },
                            set: function(e) {
                                this._initialOptions = e
                            }
                        }]) && d(t.prototype, n), c, e
                    }();
                    t.Options = c
                },
            9030:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/option_manager.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.OptionManager = void 0;
                    var i = n( /*! ../utils/data */ 47617),
                        o = n( /*! ../utils/common */ 20576),
                        a = n( /*! ../utils/comparator */ 49036),
                        r = n( /*! ../utils/extend */ 13306),
                        s = n( /*! ../utils/type */ 35922),
                        l = n( /*! ./utils */ 45434),
                        u = {},
                        d = {},
                        c = function() {
                            function e(e, t) {
                                this._options = e, this._optionsByReference = t, this._changingCallback, this._changedCallback, this._namePreparedCallbacks
                            }
                            var t = e.prototype;
                            return t._setByReference = function(e, t) {
                                for (var n in (0, r.extend)(!0, e, t), this._optionsByReference) {
                                    Object.prototype.hasOwnProperty.call(t, n) && (e[n] = t[n])
                                }
                            }, t._setPreparedValue = function(e, t, n, o) {
                                var r = this.get(this._options, e, !1);
                                if (!(0, a.equals)(r, t)) {
                                    var l = (0, i.getPathParts)(e);
                                    !o && this._changingCallback(e, r, t), d[e] = d[e] || (0, i.compileSetter)(e), d[e](this._options, t, {
                                        functionsAsIs: !0,
                                        merge: (0, s.isDefined)(n) ? n : !this._optionsByReference[e],
                                        unwrapObservables: l.length > 1 && !!this._optionsByReference[l[0]]
                                    }), !o && this._changedCallback(e, t, r)
                                }
                            }, t._prepareRelevantNames = function(e, t, n, i) {
                                if ((0, s.isPlainObject)(n)) {
                                    for (var o in n) {
                                        this._prepareRelevantNames(e, "".concat(t, ".").concat(o), n[o])
                                    }
                                }
                                this._namePreparedCallbacks(e, t, n, i)
                            }, t.get = function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this._options,
                                    t = arguments.length > 1 ? arguments[1] : void 0,
                                    n = arguments.length > 2 ? arguments[2] : void 0;
                                return u[t] = u[t] || (0, i.compileGetter)(t), u[t](e, {
                                    functionsAsIs: !0,
                                    unwrapObservables: n
                                })
                            }, t.set = function(e, t, n, i) {
                                for (var o in e = (0, l.normalizeOptions)(e, t)) {
                                    this._prepareRelevantNames(e, o, e[o], i)
                                }
                                for (var a in e) {
                                    this._setPreparedValue(a, e[a], n, i)
                                }
                            }, t.onRelevantNamesPrepared = function(e) {
                                this._namePreparedCallbacks = e
                            }, t.onChanging = function(e) {
                                this._changingCallback = e
                            }, t.onChanged = function(e) {
                                this._changedCallback = e
                            }, t.dispose = function() {
                                this._changingCallback = o.noop, this._changedCallback = o.noop
                            }, e
                        }();
                    t.OptionManager = c
                },
            45434:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/utils.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.normalizeOptions = t.getParentName = t.getNestedOptionValue = t.getFieldName = t.deviceMatch = t.createDefaultOptionRules = t.convertRulesToOptions = void 0;
                    var i, o = (i = n( /*! ../devices */ 20530)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ../utils/type */ 35922),
                        r = n( /*! ../utils/common */ 20576),
                        s = n( /*! ../utils/extend */ 13306),
                        l = n( /*! ../utils/data */ 47617);
                    var u = {};
                    t.convertRulesToOptions = function(e) {
                        var t = o.default.current();
                        return e.reduce((function(e, n) {
                            var i = n.device,
                                o = n.options,
                                r = i || {};
                            return ((0, a.isFunction)(r) ? r(t) : d(t, r)) && (0, s.extend)(!0, e, o), e
                        }), {})
                    };
                    t.normalizeOptions = function(e, t) {
                        return "string" != typeof e ? e : function(e, t, n) {
                            return t in e ? Object.defineProperty(e, t, {
                                value: n,
                                enumerable: !0,
                                configurable: !0,
                                writable: !0
                            }) : e[t] = n, e
                        }({}, e, t)
                    };
                    var d = function(e, t) {
                        return (0, a.isEmptyObject)(t) || (0, r.findBestMatches)(e, [t]).length > 0
                    };
                    t.deviceMatch = d;
                    t.getFieldName = function(e) {
                        return e.substr(e.lastIndexOf(".") + 1)
                    };
                    t.getParentName = function(e) {
                        return e.substr(0, e.lastIndexOf("."))
                    };
                    t.getNestedOptionValue = function(e, t) {
                        return u[t] = u[t] || (0, l.compileGetter)(t), u[t](e, {
                            functionsAsIs: !0
                        })
                    };
                    t.createDefaultOptionRules = function() {
                        var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                        return e
                    }
                },
            27050:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/number.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/window */ 58201),
                        o = (0, i.hasWindow)() ? (0, i.getWindow)().Number : Number;
                    o.isFinite = o.isFinite || function(e) {
                        return "number" == typeof e && isFinite(e)
                    };
                    var a = o;
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            48136:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/promise.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/deferred */ 62754),
                        o = n( /*! ../../core/utils/window */ 58201),
                        a = (0, o.hasWindow)() ? (0, o.getWindow)().Promise : Promise;
                    a || ((a = function(e) {
                        var t = new i.Deferred;
                        return e(t.resolve.bind(this), t.reject.bind(this)), t.promise()
                    }).resolve = function(e) {
                        return (new i.Deferred).resolve(e).promise()
                    }, a.reject = function(e) {
                        return (new i.Deferred).reject(e).promise()
                    }, a.all = function(e) {
                        return i.when.apply(this, e).then((function() {
                            return [].slice.call(arguments)
                        }))
                    });
                    var r = a;
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            10126:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/weak_map.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../utils/array */ 89386),
                        o = n( /*! ../utils/window */ 58201),
                        a = (0, o.hasWindow)() ? (0, o.getWindow)().WeakMap : WeakMap;
                    a || (a = function() {
                        var e = [],
                            t = [];
                        this.set = function(n, o) {
                            var a = (0, i.inArray)(n, e); - 1 === a ? (e.push(n), t.push(o)) : t[a] = o
                        }, this.get = function(n) {
                            var o = (0, i.inArray)(n, e);
                            if (-1 !== o) {
                                return t[o]
                            }
                        }, this.has = function(t) {
                            return -1 !== (0, i.inArray)(t, e)
                        }, this.delete = function(n) {
                            var o = (0, i.inArray)(n, e); - 1 !== o && (e.splice(o, 1), t.splice(o, 1))
                        }
                    });
                    var r = a;
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            90889:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/postponed_operations.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.PostponedOperations = void 0;
                    var i = n( /*! ./utils/deferred */ 62754),
                        o = n( /*! ./utils/type */ 35922);

                    function a(e) {
                        return function(e) {
                            if (Array.isArray(e)) {
                                return r(e)
                            }
                        }(e) || function(e) {
                            if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                return Array.from(e)
                            }
                        }(e) || function(e, t) {
                            if (!e) {
                                return
                            }
                            if ("string" == typeof e) {
                                return r(e, t)
                            }
                            var n = Object.prototype.toString.call(e).slice(8, -1);
                            "Object" === n && e.constructor && (n = e.constructor.name);
                            if ("Map" === n || "Set" === n) {
                                return Array.from(e)
                            }
                            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                return r(e, t)
                            }
                        }(e) || function() {
                            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                        }()
                    }

                    function r(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var s = function() {
                        function e() {
                            this._postponedOperations = {}
                        }
                        var t = e.prototype;
                        return t.add = function(e, t, n) {
                            if (e in this._postponedOperations) {
                                n && this._postponedOperations[e].promises.push(n)
                            } else {
                                var o = new i.Deferred;
                                this._postponedOperations[e] = {
                                    fn: t,
                                    completePromise: o,
                                    promises: n ? [n] : []
                                }
                            }
                            return this._postponedOperations[e].completePromise.promise()
                        }, t.callPostponedOperations = function() {
                            for (var e in this._postponedOperations) {
                                var t = this._postponedOperations[e];
                                (0, o.isDefined)(t) && (t.promises && t.promises.length ? i.when.apply(void 0, a(t.promises)).done(t.fn).then(t.completePromise.resolve) : t.fn().done(t.completePromise.resolve))
                            }
                            this._postponedOperations = {}
                        }, e
                    }();
                    t.PostponedOperations = s
                },
            37819:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/remove_event.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.removeEvent = void 0;
                    var i = s(n( /*! ./renderer */ 68374)),
                        o = n( /*! ./element_data */ 97906),
                        a = s(n( /*! ../events/core/events_engine */ 55994)),
                        r = s(n( /*! ../events/core/event_registrator */ 85788));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = "dxremove";
                    t.removeEvent = l;
                    var u = "dxRemoveEvent";
                    (0, o.beforeCleanData)((function(e) {
                        e = [].slice.call(e);
                        for (var t = 0; t < e.length; t++) {
                            var n = (0, i.default)(e[t]);
                            n.prop(u) && (n[0].dxRemoveEvent = null, a.default.triggerHandler(n, l))
                        }
                    })), (0, r.default)(l, {
                        noBubble: !0,
                        setup: function(e) {
                            (0, i.default)(e).prop(u, !0)
                        }
                    })
                },
            68374:
                /*!**************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/renderer.js ***!
                  \**************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var o = ((i = n( /*! ./renderer_base */ 82981)) && i.__esModule ? i : {
                        default: i
                    }).default.get();
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            82981:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/renderer_base.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ./element_data */ 97906),
                        a = (i = n( /*! ./dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        r = n( /*! ./utils/window */ 58201),
                        s = n( /*! ./utils/type */ 35922),
                        l = n( /*! ./utils/style */ 80968),
                        u = n( /*! ./utils/size */ 58664),
                        d = n( /*! ./utils/html_parser */ 61371);
                    var c, h = (0, r.getWindow)(),
                        f = function(e, t) {
                            return e ? "string" == typeof e ? "body" === e ? (this[0] = t ? t.body : a.default.getBody(), this.length = 1, this) : (t = t || a.default.getDocument(), "<" === e[0] ? (this[0] = a.default.createElement(e.slice(1, -1), t), this.length = 1, this) : ([].push.apply(this, a.default.querySelectorAll(t, e)), this)) : a.default.isNode(e) || (0, s.isWindow)(e) ? (this[0] = e, this.length = 1, this) : Array.isArray(e) ? ([].push.apply(this, e), this) : c(e.toArray ? e.toArray() : [e]) : (this.length = 0, this)
                        };
                    (c = function(e, t) {
                        return new f(e, t)
                    }).fn = {
                        dxRenderer: !0
                    }, f.prototype = c.fn;
                    var p = function(e, t) {
                            for (var n = 0; n < this.length; n++) {
                                var i = c(this[n]);
                                i[e].apply(i, t)
                            }
                            return this
                        },
                        g = function(e, t, n) {
                            null != n ? a.default.setAttribute(e, t, n) : a.default.removeAttribute(e, t)
                        };
                    f.prototype.show = function() {
                        return this.toggle(!0)
                    }, f.prototype.hide = function() {
                        return this.toggle(!1)
                    }, f.prototype.toggle = function(e) {
                        return this[0] && this.toggleClass("dx-state-invisible", !e), this
                    }, f.prototype.attr = function(e, t) {
                        if (this.length > 1 && arguments.length > 1) {
                            return p.call(this, "attr", arguments)
                        }
                        if (!this[0]) {
                            return (0, s.isObject)(e) || void 0 !== t ? this : void 0
                        }
                        if (!this[0].getAttribute) {
                            return this.prop(e, t)
                        }
                        if ("string" == typeof e && 1 === arguments.length) {
                            var n = this[0].getAttribute(e);
                            return null == n ? void 0 : n
                        }
                        if ((0, s.isPlainObject)(e)) {
                            for (var i in e) {
                                this.attr(i, e[i])
                            }
                        } else {
                            g(this[0], e, t)
                        }
                        return this
                    }, f.prototype.removeAttr = function(e) {
                        return this[0] && a.default.removeAttribute(this[0], e), this
                    }, f.prototype.prop = function(e, t) {
                        if (!this[0]) {
                            return this
                        }
                        if ("string" == typeof e && 1 === arguments.length) {
                            return this[0][e]
                        }
                        if ((0, s.isPlainObject)(e)) {
                            for (var n in e) {
                                this.prop(n, e[n])
                            }
                        } else {
                            a.default.setProperty(this[0], e, t)
                        }
                        return this
                    }, f.prototype.addClass = function(e) {
                        return this.toggleClass(e, !0)
                    }, f.prototype.removeClass = function(e) {
                        return this.toggleClass(e, !1)
                    }, f.prototype.hasClass = function(e) {
                        if (!this[0] || void 0 === this[0].className) {
                            return !1
                        }
                        for (var t = e.split(" "), n = 0; n < t.length; n++) {
                            if (this[0].classList) {
                                if (this[0].classList.contains(t[n])) {
                                    return !0
                                }
                            } else if ((((0, s.isString)(this[0].className) ? this[0].className : a.default.getAttribute(this[0], "class")) || "").split(" ").indexOf(t[n]) >= 0) {
                                return !0
                            }
                        }
                        return !1
                    }, f.prototype.toggleClass = function(e, t) {
                        if (this.length > 1) {
                            return p.call(this, "toggleClass", arguments)
                        }
                        if (!this[0] || !e) {
                            return this
                        }
                        t = void 0 === t ? !this.hasClass(e) : t;
                        for (var n = e.split(" "), i = 0; i < n.length; i++) {
                            a.default.setClass(this[0], n[i], t)
                        }
                        return this
                    }, f.prototype.html = function(e) {
                        return arguments.length ? (this.empty(), "string" == typeof e && !(0, d.isTablePart)(e) || "number" == typeof e ? (this[0].innerHTML = e, this) : this.append((0, d.parseHTML)(e))) : this[0].innerHTML
                    };
                    var m = function(e, t) {
                            if (this[0] && e) {
                                "string" == typeof e ? e = (0, d.parseHTML)(e) : e.nodeType ? e = [e] : (0, s.isNumeric)(e) && (e = [a.default.createTextNode(e)]);
                                for (var n = 0; n < e.length; n++) {
                                    var i = e[n],
                                        o = this[0];
                                    "TABLE" === o.tagName && "TR" === i.tagName && o.tBodies && o.tBodies.length && (o = o.tBodies[0]), a.default.insertElement(o, i.nodeType ? i : i[0], t)
                                }
                            }
                        },
                        _ = function(e, t) {
                            if (this[0] && this[0].style && !(null === t || "number" == typeof t && isNaN(t))) {
                                e = (0, l.styleProp)(e);
                                for (var n = 0; n < this.length; n++) {
                                    this[n].style[e] = (0, l.normalizeStyleProp)(e, t)
                                }
                            }
                        };
                    f.prototype.css = function(e, t) {
                        if ((0, s.isString)(e)) {
                            if (2 !== arguments.length) {
                                if (!this[0]) {
                                    return
                                }
                                e = (0, l.styleProp)(e);
                                var n = h.getComputedStyle(this[0])[e] || this[0].style[e];
                                return (0, s.isNumeric)(n) ? n.toString() : n
                            }
                            _.call(this, e, t)
                        } else if ((0, s.isPlainObject)(e)) {
                            for (var i in e) {
                                _.call(this, i, e[i])
                            }
                        }
                        return this
                    }, f.prototype.prepend = function(e) {
                        if (arguments.length > 1) {
                            for (var t = 0; t < arguments.length; t++) {
                                this.prepend(arguments[t])
                            }
                            return this
                        }
                        return m.apply(this, [e, this[0].firstChild]), this
                    }, f.prototype.append = function(e) {
                        if (arguments.length > 1) {
                            for (var t = 0; t < arguments.length; t++) {
                                this.append(arguments[t])
                            }
                            return this
                        }
                        return m.apply(this, [e]), this
                    }, f.prototype.prependTo = function(e) {
                        if (this.length > 1) {
                            for (var t = this.length - 1; t >= 0; t--) {
                                c(this[t]).prependTo(e)
                            }
                            return this
                        }
                        return (e = c(e))[0] && a.default.insertElement(e[0], this[0], e[0].firstChild), this
                    }, f.prototype.appendTo = function(e) {
                        return this.length > 1 ? p.call(this, "appendTo", arguments) : (a.default.insertElement(c(e)[0], this[0]), this)
                    }, f.prototype.insertBefore = function(e) {
                        return e && e[0] && a.default.insertElement(e[0].parentNode, this[0], e[0]), this
                    }, f.prototype.insertAfter = function(e) {
                        return e && e[0] && a.default.insertElement(e[0].parentNode, this[0], e[0].nextSibling), this
                    }, f.prototype.before = function(e) {
                        return this[0] && a.default.insertElement(this[0].parentNode, e[0], this[0]), this
                    }, f.prototype.after = function(e) {
                        return this[0] && a.default.insertElement(this[0].parentNode, e[0], this[0].nextSibling), this
                    }, f.prototype.wrap = function(e) {
                        if (this[0]) {
                            var t = c(e);
                            t.insertBefore(this), t.append(this)
                        }
                        return this
                    }, f.prototype.wrapInner = function(e) {
                        var t = this.contents();
                        return t.length ? t.wrap(e) : this.append(e), this
                    }, f.prototype.replaceWith = function(e) {
                        if (e && e[0]) {
                            return e.is(this) ? this : (e.insertBefore(this), this.remove(), e)
                        }
                    }, f.prototype.remove = function() {
                        return this.length > 1 ? p.call(this, "remove", arguments) : ((0, o.cleanDataRecursive)(this[0], !0), a.default.removeElement(this[0]), this)
                    }, f.prototype.detach = function() {
                        return this.length > 1 ? p.call(this, "detach", arguments) : (a.default.removeElement(this[0]), this)
                    }, f.prototype.empty = function() {
                        return this.length > 1 ? p.call(this, "empty", arguments) : ((0, o.cleanDataRecursive)(this[0]), a.default.setText(this[0], ""), this)
                    }, f.prototype.clone = function() {
                        for (var e = [], t = 0; t < this.length; t++) {
                            e.push(this[t].cloneNode(!0))
                        }
                        return c(e)
                    }, f.prototype.text = function(e) {
                        if (!arguments.length) {
                            for (var t = "", n = 0; n < this.length; n++) {
                                t += this[n] && this[n].textContent || ""
                            }
                            return t
                        }
                        var i = (0, s.isFunction)(e) ? e() : e;
                        return (0, o.cleanDataRecursive)(this[0], !1), a.default.setText(this[0], (0, s.isDefined)(i) ? i : ""), this
                    }, f.prototype.val = function(e) {
                        return 1 === arguments.length ? this.prop("value", (0, s.isDefined)(e) ? e : "") : this.prop("value")
                    }, f.prototype.contents = function() {
                        if (!this[0]) {
                            return c()
                        }
                        var e = [];
                        return e.push.apply(e, this[0].childNodes), c(e)
                    }, f.prototype.find = function(e) {
                        var t = c();
                        if (!e) {
                            return t
                        }
                        var n, i = [];
                        if ("string" == typeof e) {
                            for (e = e.trim(), n = 0; n < this.length; n++) {
                                var o = this[n];
                                if (a.default.isElementNode(o)) {
                                    var r = o.getAttribute("id"),
                                        s = r || "dx-query-children";
                                    r || g(o, "id", s);
                                    var l = (s = "[id='" + s + "'] ") + e.replace(/([^\\])(,)/g, "$1, " + s);
                                    i.push.apply(i, a.default.querySelectorAll(o, l)), g(o, "id", r)
                                } else {
                                    a.default.isDocument(o) && i.push.apply(i, a.default.querySelectorAll(o, e))
                                }
                            }
                        } else {
                            for (n = 0; n < this.length; n++) {
                                e = a.default.isNode(e) ? e : e[0], this[n] !== e && this[n].contains(e) && i.push(e)
                            }
                        }
                        return t.add(i)
                    };
                    var v = function(e, t) {
                        return !t.nodeType || !!(t.offsetWidth || t.offsetHeight || t.getClientRects().length)
                    };
                    f.prototype.filter = function(e) {
                        if (!e) {
                            return c()
                        }
                        if (":visible" === e) {
                            return this.filter(v)
                        }
                        if (":hidden" === e) {
                            return this.filter((function(e, t) {
                                return !v(0, t)
                            }))
                        }
                        for (var t = [], n = 0; n < this.length; n++) {
                            var i = this[n];
                            if (a.default.isElementNode(i) && "string" === (0, s.type)(e)) {
                                a.default.elementMatches(i, e) && t.push(i)
                            } else if (a.default.isNode(e) || (0, s.isWindow)(e)) {
                                e === i && t.push(i)
                            } else if ((0, s.isFunction)(e)) {
                                e.call(i, n, i) && t.push(i)
                            } else {
                                for (var o = 0; o < e.length; o++) {
                                    e[o] === i && t.push(i)
                                }
                            }
                        }
                        return c(t)
                    }, f.prototype.not = function(e) {
                        for (var t = [], n = this.filter(e).toArray(), i = 0; i < this.length; i++) {
                            -1 === n.indexOf(this[i]) && t.push(this[i])
                        }
                        return c(t)
                    }, f.prototype.is = function(e) {
                        return !!this.filter(e).length
                    }, f.prototype.children = function(e) {
                        for (var t = [], n = 0; n < this.length; n++) {
                            for (var i = this[n] ? this[n].childNodes : [], o = 0; o < i.length; o++) {
                                a.default.isElementNode(i[o]) && t.push(i[o])
                            }
                        }
                        return t = c(t), e ? t.filter(e) : t
                    }, f.prototype.siblings = function() {
                        var e = this[0];
                        if (!e || !e.parentNode) {
                            return c()
                        }
                        for (var t = [], n = e.parentNode.childNodes || [], i = 0; i < n.length; i++) {
                            var o = n[i];
                            a.default.isElementNode(o) && o !== e && t.push(o)
                        }
                        return c(t)
                    }, f.prototype.each = function(e) {
                        for (var t = 0; t < this.length && !1 !== e.call(this[t], t, this[t]); t++) {}
                    }, f.prototype.index = function(e) {
                        return e ? (e = c(e), this.toArray().indexOf(e[0])) : this.parent().children().index(this)
                    }, f.prototype.get = function(e) {
                        return this[e < 0 ? this.length + e : e]
                    }, f.prototype.eq = function(e) {
                        return e = e < 0 ? this.length + e : e, c(this[e])
                    }, f.prototype.first = function() {
                        return this.eq(0)
                    }, f.prototype.last = function() {
                        return this.eq(-1)
                    }, f.prototype.parent = function(e) {
                        if (!this[0]) {
                            return c()
                        }
                        var t = c(this[0].parentNode);
                        return !e || t.is(e) ? t : c()
                    }, f.prototype.parents = function(e) {
                        for (var t = [], n = this.parent(); n && n[0] && !a.default.isDocument(n[0]);) {
                            a.default.isElementNode(n[0]) && (e && !n.is(e) || t.push(n.get(0))), n = n.parent()
                        }
                        return c(t)
                    }, f.prototype.closest = function(e) {
                        if (this.is(e)) {
                            return this
                        }
                        for (var t = this.parent(); t && t.length;) {
                            if (t.is(e)) {
                                return t
                            }
                            t = t.parent()
                        }
                        return c()
                    }, f.prototype.next = function(e) {
                        if (!this[0]) {
                            return c()
                        }
                        var t = c(this[0].nextSibling);
                        if (!arguments.length) {
                            return t
                        }
                        for (; t && t.length;) {
                            if (t.is(e)) {
                                return t
                            }
                            t = t.next()
                        }
                        return c()
                    }, f.prototype.prev = function() {
                        return this[0] ? c(this[0].previousSibling) : c()
                    }, f.prototype.add = function(e) {
                        for (var t = c(e), n = this.toArray(), i = 0; i < t.length; i++) {
                            var o = t[i]; - 1 === n.indexOf(o) && n.push(o)
                        }
                        return c(n)
                    };
                    var y = [];
                    f.prototype.splice = function() {
                        return c(y.splice.apply(this, arguments))
                    }, f.prototype.slice = function() {
                        return c(y.slice.apply(this, arguments))
                    }, f.prototype.toArray = function() {
                        return y.slice.call(this)
                    }, f.prototype.offset = function() {
                        if (this[0]) {
                            return (0, u.getOffset)(this[0])
                        }
                    }, f.prototype.offsetParent = function() {
                        if (!this[0]) {
                            return c()
                        }
                        for (var e = c(this[0].offsetParent); e[0] && "static" === e.css("position");) {
                            e = c(e[0].offsetParent)
                        }
                        return e[0] ? e : c(a.default.getDocumentElement())
                    }, f.prototype.position = function() {
                        if (this[0]) {
                            var e, t = parseFloat(this.css("marginTop")),
                                n = parseFloat(this.css("marginLeft"));
                            if ("fixed" === this.css("position")) {
                                return {
                                    top: (e = this[0].getBoundingClientRect()).top - t,
                                    left: e.left - n
                                }
                            }
                            e = this.offset();
                            var i = this.offsetParent(),
                                o = {
                                    top: 0,
                                    left: 0
                                };
                            return "HTML" !== i[0].nodeName && (o = i.offset()), o = {
                                top: o.top + parseFloat(i.css("borderTopWidth")),
                                left: o.left + parseFloat(i.css("borderLeftWidth"))
                            }, {
                                top: e.top - o.top - t,
                                left: e.left - o.left - n
                            }
                        }
                    }, [{
                        name: "scrollLeft",
                        offsetProp: "pageXOffset",
                        scrollWindow: function(e, t) {
                            e.scrollTo(t, e.pageYOffset)
                        }
                    }, {
                        name: "scrollTop",
                        offsetProp: "pageYOffset",
                        scrollWindow: function(e, t) {
                            e.scrollTo(e.pageXOffset, t)
                        }
                    }].forEach((function(e) {
                        var t = e.name;
                        f.prototype[t] = function(n) {
                            if (this[0]) {
                                var i = (0, u.getWindowByElement)(this[0]);
                                return void 0 === n ? i ? i[e.offsetProp] : this[0][t] : (i ? e.scrollWindow(i, n) : this[0][t] = n, this)
                            }
                        }
                    })), f.prototype.data = function(e, t) {
                        if (this[0]) {
                            return arguments.length < 2 ? o.data.call(c, this[0], e) : (o.data.call(c, this[0], e, t), this)
                        }
                    }, f.prototype.removeData = function(e) {
                        return this[0] && (0, o.removeData)(this[0], e), this
                    };
                    var b = function() {
                        return c.apply(this, arguments)
                    };
                    Object.defineProperty(b, "fn", {
                        enumerable: !0,
                        configurable: !0,
                        get: function() {
                            return c.fn
                        },
                        set: function(e) {
                            c.fn = e
                        }
                    });
                    var x = {
                        set: function(e) {
                            c = e
                        },
                        get: function() {
                            return b
                        }
                    };
                    t.default = x, e.exports = t.default, e.exports.default = t.default
                },
            91784:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/resize_observer.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/common */ 20576),
                        o = n( /*! ./utils/window */ 58201),
                        a = (0, o.getWindow)(),
                        r = {
                            observe: i.noop,
                            unobserve: i.noop,
                            disconnect: i.noop
                        },
                        s = new(function() {
                            function e() {
                                var e = this;
                                if (!(0, o.hasWindow)() || !a.ResizeObserver) {
                                    return r
                                }
                                this._callbacksMap = new Map, this._observer = new a.ResizeObserver((function(t) {
                                    t.forEach((function(t) {
                                        var n;
                                        null === (n = e._callbacksMap.get(t.target)) || void 0 === n || n(t)
                                    }))
                                }))
                            }
                            var t = e.prototype;
                            return t.observe = function(e, t) {
                                this._callbacksMap.set(e, t), this._observer.observe(e)
                            }, t.unobserve = function(e) {
                                this._callbacksMap.delete(e), this._observer.unobserve(e)
                            }, t.disconnect = function() {
                                this._callbacksMap.clear(), this._observer.disconnect()
                            }, e
                        }());
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            14192:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/template_manager.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.TemplateManager = void 0;
                    var i, o = (i = n( /*! ./renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./utils/type */ 35922),
                        r = n( /*! ./utils/common */ 20576),
                        s = n( /*! ./utils/extend */ 13306),
                        l = n( /*! ./templates/function_template */ 68494),
                        u = n( /*! ./templates/empty_template */ 10688),
                        d = n( /*! ./utils/template_manager */ 69697);

                    function c(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    var h = new l.FunctionTemplate((function(e) {
                            var t = e.model,
                                n = e.parent,
                                i = t.widget;
                            if (!i) {
                                return (0, o.default)()
                            }
                            var a = (0, o.default)("<div>"),
                                r = t.options || {};
                            return n ? n._createComponent(a, i, r) : a[i](r), a
                        })),
                        f = function() {
                            function e(e, t) {
                                this._tempTemplates = [], this._defaultTemplates = {}, this._anonymousTemplateName = t || "template", this._createElement = e || d.defaultCreateElement, this._createTemplateIfNeeded = this._createTemplateIfNeeded.bind(this)
                            }
                            e.createDefaultOptions = function() {
                                return {
                                    integrationOptions: {
                                        watchMethod: function(e, t) {
                                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                                            return n.skipImmediate || t(e()), r.noop
                                        },
                                        templates: {
                                            "dx-polymorph-widget": h
                                        },
                                        useDeferUpdateForTemplates: !0
                                    }
                                }
                            };
                            var t, n, i, f = e.prototype;
                            return f.addDefaultTemplates = function(e) {
                                this._defaultTemplates = (0, s.extend)({}, this._defaultTemplates, e)
                            }, f.dispose = function() {
                                this._tempTemplates.forEach((function(e) {
                                    e.template.dispose && e.template.dispose()
                                })), this._tempTemplates = []
                            }, f.extractTemplates = function(e) {
                                return {
                                    templates: this._extractTemplates(e),
                                    anonymousTemplateMeta: this._extractAnonymousTemplate(e)
                                }
                            }, f._extractTemplates = function(e) {
                                var t = this,
                                    n = (0, d.findTemplates)(e, "dxTemplate"),
                                    i = (0, d.suitableTemplatesByName)(n);
                                return n.forEach((function(e) {
                                    var t = e.element,
                                        n = e.options.name;
                                    t === i[n] ? (0, o.default)(t).addClass("dx-template-wrapper").detach() : (0, o.default)(t).remove()
                                })), Object.keys(i).map((function(e) {
                                    return {
                                        name: e,
                                        template: t._createTemplate(i[e])
                                    }
                                }))
                            }, f._extractAnonymousTemplate = function(e) {
                                var t = e.contents().detach();
                                return t.filter((function(e, t) {
                                    var n = 3 === t.nodeType,
                                        i = (0, o.default)(t).text().trim().length < 1;
                                    return !(n && i)
                                })).length > 0 ? {
                                    template: this._createTemplate(t),
                                    name: this._anonymousTemplateName
                                } : {}
                            }, f._createTemplateIfNeeded = function(e) {
                                var t = this._tempTemplates.filter((function(t) {
                                    return t.source === (0, d.templateKey)(e)
                                }))[0];
                                if (t) {
                                    return t.template
                                }
                                var n = this._createTemplate(e);
                                return this._tempTemplates.push({
                                    template: n,
                                    source: (0, d.templateKey)(e)
                                }), n
                            }, f._createTemplate = function(e) {
                                return this._createElement((0, d.validateTemplateSource)(e))
                            }, f.getTemplate = function(e, t, n, i) {
                                var r = this,
                                    s = n.isAsyncTemplate,
                                    c = n.skipTemplates;
                                return (0, a.isFunction)(e) ? new l.FunctionTemplate((function(n) {
                                    var h = e.apply(i, (0, d.getNormalizedTemplateArgs)(n));
                                    if (!(0, a.isDefined)(h)) {
                                        return new u.EmptyTemplate
                                    }
                                    var f = !1,
                                        p = (0, d.acquireTemplate)(h, (function(e) {
                                            return e.nodeType || (0, a.isRenderer)(e) && !(0, o.default)(e).is("script") ? new l.FunctionTemplate((function() {
                                                return e
                                            })) : (f = !0, r._createTemplate(e))
                                        }), t, s, c, r._defaultTemplates),
                                        g = p.render(n);
                                    return f && p.dispose && p.dispose(), g
                                })) : (0, d.acquireTemplate)(e, this._createTemplateIfNeeded, t, s, c, this._defaultTemplates)
                            }, t = e, (n = [{
                                key: "anonymousTemplateName",
                                get: function() {
                                    return this._anonymousTemplateName
                                }
                            }]) && c(t.prototype, n), i, e
                        }();
                    t.TemplateManager = f
                },
            93280:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/bindable_template.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.BindableTemplate = void 0;
                    var i = l(n( /*! ../renderer */ 68374)),
                        o = n( /*! ./template_base */ 81033),
                        a = l(n( /*! ../../events/core/events_engine */ 55994)),
                        r = n( /*! ../remove_event */ 37819),
                        s = n( /*! ../utils/type */ 35922);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function u(e, t) {
                        return u = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, u(e, t)
                    }
                    var c = function(e) {
                        var t, n;

                        function o(t, n, i, o) {
                            var a;
                            return (a = e.call(this) || this)._render = t, a._fields = n, a._fieldsMap = o || {}, a._watchMethod = i, a
                        }
                        return n = e, (t = o).prototype = Object.create(n.prototype), t.prototype.constructor = t, u(t, n), o.prototype._renderCore = function(e) {
                            var t = this,
                                n = (0, i.default)(e.container),
                                o = function(e, t, n, i, o) {
                                    var a, r = function(e, t, n) {
                                        return t((function() {
                                            return e
                                        }), n)
                                    }(e, t, (function(e) {
                                        a && a(), (0, s.isPrimitive)(e) ? o(e) : a = function(e, t, n, i, o) {
                                            var a = {},
                                                r = n.slice(),
                                                s = n.map((function(n) {
                                                    var s = i[n];
                                                    return t(s ? function() {
                                                        return s(e)
                                                    } : function() {
                                                        return e[n]
                                                    }, (function(e) {
                                                        if (a[n] = e, r.length) {
                                                            var t = r.indexOf(n);
                                                            t >= 0 && r.splice(t, 1)
                                                        }
                                                        r.length || o(a)
                                                    }))
                                                }));
                                            return function() {
                                                s.forEach((function(e) {
                                                    return e()
                                                }))
                                            }
                                        }(e, t, n, i, o)
                                    }));
                                    return function() {
                                        a && a(), r && r()
                                    }
                                }(e.model, this._watchMethod, this._fields, this._fieldsMap, (function(i) {
                                    n.empty(), t._render(n, i, e.model)
                                }));
                            return a.default.on(n, r.removeEvent, o), n.contents()
                        }, o
                    }(o.TemplateBase);
                    t.BindableTemplate = c
                },
            91627:
                /*!**************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/child_default_template.js ***!
                  \**************************************************************************************/
                function(e, t, n) {
                    function i(e, t) {
                        return i = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, i(e, t)
                    }
                    t.ChildDefaultTemplate = void 0;
                    var o = function(e) {
                        var t, n;

                        function o(t) {
                            var n;
                            return (n = e.call(this) || this).name = t, n
                        }
                        return n = e, (t = o).prototype = Object.create(n.prototype), t.prototype.constructor = t, i(t, n), o
                    }(n( /*! ./template_base */ 81033).TemplateBase);
                    t.ChildDefaultTemplate = o
                },
            10688:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/empty_template.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.EmptyTemplate = void 0;
                    var i, o = (i = n( /*! ../renderer */ 68374)) && i.__esModule ? i : {
                        default: i
                    };

                    function a(e, t) {
                        return a = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, a(e, t)
                    }
                    var r = function(e) {
                        var t, n;

                        function i() {
                            return e.apply(this, arguments) || this
                        }
                        return n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, a(t, n), i.prototype._renderCore = function() {
                            return (0, o.default)()
                        }, i
                    }(n( /*! ./template_base */ 81033).TemplateBase);
                    t.EmptyTemplate = r
                },
            68494:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/function_template.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.FunctionTemplate = void 0;
                    var i = n( /*! ./template_base */ 81033),
                        o = n( /*! ../utils/dom */ 3532);

                    function a(e, t) {
                        return a = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, a(e, t)
                    }
                    var r = function(e) {
                        var t, n;

                        function i(t) {
                            var n;
                            return (n = e.call(this) || this)._render = t, n
                        }
                        return n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, a(t, n), i.prototype._renderCore = function(e) {
                            return (0, o.normalizeTemplateElement)(this._render(e))
                        }, i
                    }(i.TemplateBase);
                    t.FunctionTemplate = r
                },
            9545:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.Template = void 0;
                    var i, o = (i = n( /*! ../renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./template_base */ 81033),
                        r = n( /*! ../utils/dom */ 3532),
                        s = n( /*! ./template_engine_registry */ 72987);

                    function l(e, t) {
                        return l = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, l(e, t)
                    }
                    n( /*! ./template_engines */ 32468), (0, s.registerTemplateEngine)("default", {
                        compile: function(e) {
                            return (0, r.normalizeTemplateElement)(e)
                        },
                        render: function(e, t, n) {
                            return e.clone()
                        }
                    }), (0, s.setTemplateEngine)("default");
                    var u = function(e) {
                        var t, n;

                        function i(t) {
                            var n;
                            return (n = e.call(this) || this)._element = t, n
                        }
                        n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, l(t, n);
                        var a = i.prototype;
                        return a._renderCore = function(e) {
                            var t = e.transclude;
                            return t || this._compiledTemplate || (this._compiledTemplate = (0, s.getCurrentTemplateEngine)().compile(this._element)), (0, o.default)("<div>").append(t ? this._element : (0, s.getCurrentTemplateEngine)().render(this._compiledTemplate, e.model, e.index)).contents()
                        }, a.source = function() {
                            return (0, o.default)(this._element).clone()
                        }, i
                    }(a.TemplateBase);
                    t.Template = u
                },
            81033:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_base.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.renderedCallbacks = t.TemplateBase = void 0;
                    var i = u(n( /*! ../renderer */ 68374)),
                        o = u(n( /*! ../dom_adapter */ 73349)),
                        a = u(n( /*! ../utils/callbacks */ 44504)),
                        r = n( /*! ../utils/dom */ 3532),
                        s = n( /*! ../../events/visibility_change */ 80506),
                        l = u(n( /*! ../errors */ 17381));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = (0, a.default)({
                        syncStrategy: !0
                    });
                    t.renderedCallbacks = d;
                    var c = function() {
                        function e() {}
                        var t = e.prototype;
                        return t.render = function(e) {
                            var t = (e = e || {}).onRendered;
                            delete e.onRendered;
                            var n = this._renderCore(e);
                            return this._ensureResultInContainer(n, e.container), d.fire(n, e.container), t && t(), n
                        }, t._ensureResultInContainer = function(e, t) {
                            if (t) {
                                var n = (0, i.default)(t),
                                    a = (0, r.contains)(n.get(0), e.get(0));
                                if (n.append(e), !a) {
                                    o.default.getBody().contains(n.get(0)) && (0, s.triggerShownEvent)(e)
                                }
                            }
                        }, t._renderCore = function() {
                            throw l.default.Error("E0001")
                        }, e
                    }();
                    t.TemplateBase = c
                },
            72987:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engine_registry.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    t.getCurrentTemplateEngine = function() {
                        return r
                    }, t.registerTemplateEngine = function(e, t) {
                        s[e] = t
                    }, t.setTemplateEngine = function(e) {
                        if ((0, o.isString)(e)) {
                            if (!(r = s[e])) {
                                throw a.default.Error("E0020", e)
                            }
                        } else {
                            r = e
                        }
                    };
                    var i, o = n( /*! ../utils/type */ 35922),
                        a = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var r, s = {}
                },
            32468:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engines.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../utils/dom */ 3532),
                        o = n( /*! ./template_engine_registry */ 72987);
                    (0, o.registerTemplateEngine)("jquery-tmpl", {
                        compile: function(e) {
                            return (0, i.extractTemplateMarkup)(e)
                        },
                        render: function(e, t) {
                            return jQuery.tmpl(e, t)
                        }
                    }), (0, o.registerTemplateEngine)("jsrender", {
                        compile: function(e) {
                            return (jQuery || jsrender).templates((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e.render(t)
                        }
                    }), (0, o.registerTemplateEngine)("mustache", {
                        compile: function(e) {
                            return (0, i.extractTemplateMarkup)(e)
                        },
                        render: function(e, t) {
                            return Mustache.render(e, t)
                        }
                    }), (0, o.registerTemplateEngine)("hogan", {
                        compile: function(e) {
                            return Hogan.compile((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e.render(t)
                        }
                    }), (0, o.registerTemplateEngine)("underscore", {
                        compile: function(e) {
                            return _.template((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    }), (0, o.registerTemplateEngine)("handlebars", {
                        compile: function(e) {
                            return Handlebars.compile((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    }), (0, o.registerTemplateEngine)("doT", {
                        compile: function(e) {
                            return doT.template((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    })
                },
            37208:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/ajax.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./deferred */ 62754),
                        o = c(n( /*! ../../core/dom_adapter */ 73349)),
                        a = c(n( /*! ../../core/http_request */ 83448)),
                        r = n( /*! ../../core/utils/window */ 58201),
                        s = n( /*! ./extend */ 13306),
                        l = n( /*! ./type */ 35922),
                        u = c(n( /*! ../polyfills/promise */ 48136)),
                        d = c(n( /*! ./dependency_injector */ 20476));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = (0, r.getWindow)(),
                        f = "success",
                        p = "error",
                        g = function(e) {
                            var t = o.default.createElement("script");
                            for (var n in e) {
                                t[n] = e[n]
                            }
                            return t
                        },
                        m = function(e) {
                            e.parentNode.removeChild(e)
                        },
                        _ = function(e) {
                            return o.default.getHead().appendChild(e)
                        },
                        v = function(e) {
                            var t = g({
                                text: e
                            });
                            _(t), m(t)
                        };

                    function b(e) {
                        return (e.method || "GET").toUpperCase()
                    }
                    var x = function(e) {
                            var t = e.headers || {};
                            return t["Content-Type"] = t["Content-Type"] || function(e) {
                                var t;
                                return e.data && !e.upload && "GET" !== b(e) && (t = "application/x-www-form-urlencoded;charset=utf-8"), e.contentType || t
                            }(e), t.Accept = t.Accept || function(e) {
                                var t = e.dataType || "*",
                                    n = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",
                                    i = {
                                        "*": "*/*",
                                        text: "text/plain",
                                        html: "text/html",
                                        xml: "application/xml, text/xml",
                                        json: "application/json, text/javascript",
                                        jsonp: n,
                                        script: n
                                    };
                                return (0, s.extendFromObject)(i, e.accepts, !0), i[t] ? i[t] + ("*" !== t ? ", */*; q=0.01" : "") : i["*"]
                            }(e), e.crossDomain || t["X-Requested-With"] || (t["X-Requested-With"] = "XMLHttpRequest"), t
                        },
                        w = (0, d.default)({
                            sendRequest: function(e) {
                                var t, n = a.default.getXhr(),
                                    s = new i.Deferred,
                                    d = s.promise(),
                                    c = !(0, l.isDefined)(e.async) || e.async,
                                    w = e.dataType,
                                    C = e.timeout || 0;
                                e.crossDomain = function(e) {
                                    if (!(0, r.hasWindow)()) {
                                        return !0
                                    }
                                    var t = !1,
                                        n = o.default.createElement("a"),
                                        i = o.default.createElement("a");
                                    n.href = h.location.href;
                                    try {
                                        i.href = e, i.href = i.href, t = n.protocol + "//" + n.host != i.protocol + "//" + i.host
                                    } catch (e) {
                                        t = !0
                                    }
                                    return t
                                }(e.url);
                                var S = "jsonp" === w || "script" === w;
                                void 0 === e.cache && (e.cache = !S);
                                var k = function(e) {
                                        if ("jsonp" === e.dataType) {
                                            var t = Math.random().toString().replace(/\D/g, ""),
                                                n = e.jsonpCallback || "dxCallback" + Date.now() + "_" + t,
                                                i = e.jsonp || "callback";
                                            return e.data = e.data || {}, e.data[i] = n, n
                                        }
                                    }(e),
                                    I = x(e),
                                    D = function(e, t) {
                                        var n = e.data,
                                            i = "string" == typeof n,
                                            o = e.url || h.location.href;
                                        return i || e.cache || ((n = n || {})._ = Date.now()), n && !e.upload && (i || (n = function(e) {
                                            var t = [];
                                            for (var n in e) {
                                                var i = e[n];
                                                void 0 !== i && (null === i && (i = ""), "function" == typeof i && (i = i()), t.push(encodeURIComponent(n) + "=" + encodeURIComponent(i)))
                                            }
                                            return t.join("&")
                                        }(n)), "GET" === b(e) ? ("" !== n && (o += (o.indexOf("?") > -1 ? "&" : "?") + n), n = null) : t["Content-Type"] && t["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1 && (n = n.replace(/%20/g, "+"))), {
                                            url: o,
                                            parameters: n
                                        }
                                    }(e, I),
                                    T = D.url,
                                    E = D.parameters;
                                if (k && (h[k] = function(e) {
                                        s.resolve(e, f, n)
                                    }), e.crossDomain && S) {
                                    return function(e) {
                                        var t = g({
                                            src: e
                                        });
                                        return new u.default((function(e, n) {
                                            var i = {
                                                    load: e,
                                                    error: n
                                                },
                                                a = function(e) {
                                                    i[e.type](), m(t)
                                                };
                                            for (var r in i) {
                                                o.default.listen(t, r, a)
                                            }
                                            _(t)
                                        }))
                                    }(T).then((function() {
                                        "jsonp" !== w && s.resolve(null, f, n)
                                    }), (function() {
                                        s.reject(n, p)
                                    })), d
                                }
                                if (e.crossDomain && !("withCredentials" in n)) {
                                    return s.reject(n, p), d
                                }
                                if (n.open(b(e), T, c, e.username, e.password), c && (n.timeout = C, t = function(e, t) {
                                        return e && setTimeout((function() {
                                            t.customStatus = "timeout", t.abort()
                                        }), e)
                                    }(C, n)), n.onreadystatechange = function(e) {
                                        var i;
                                        4 === n.readyState && (clearTimeout(t), 200 <= (i = n.status) && i < 300 ? function(e) {
                                            return 204 !== e
                                        }(n.status) ? function(e, t, n) {
                                            var i = function(e) {
                                                return e.responseType && "text" !== e.responseType || "string" != typeof e.responseText ? e.response : e.responseText
                                            }(t);
                                            switch (n) {
                                                case "jsonp":
                                                    v(i);
                                                    break;
                                                case "script":
                                                    v(i), e.resolve(i, f, t);
                                                    break;
                                                case "json":
                                                    try {
                                                        e.resolve(JSON.parse(i), f, t)
                                                    } catch (n) {
                                                        e.reject(t, "parsererror", n)
                                                    }
                                                    break;
                                                default:
                                                    e.resolve(i, f, t)
                                            }
                                        }(s, n, w) : s.resolve(null, "nocontent", n) : s.reject(n, n.customStatus || p))
                                    }, e.upload && (n.upload.onprogress = e.upload.onprogress, n.upload.onloadstart = e.upload.onloadstart, n.upload.onabort = e.upload.onabort), e.xhrFields) {
                                    for (var A in e.xhrFields) {
                                        n[A] = e.xhrFields[A]
                                    }
                                }
                                for (var O in "arraybuffer" === e.responseType && (n.responseType = e.responseType), I) {
                                    Object.prototype.hasOwnProperty.call(I, O) && (0, l.isDefined)(I[O]) && n.setRequestHeader(O, I[O])
                                }
                                return e.beforeSend && e.beforeSend(n), n.send(E), d.abort = function() {
                                    n.abort()
                                }, d
                            }
                        });
                    t.default = w, e.exports = t.default, e.exports.default = t.default
                },
            89386:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/array.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.wrapToArray = t.uniqueValues = t.removeDuplicates = t.normalizeIndexes = t.merge = t.isEmpty = t.intersection = t.inArray = t.groupBy = t.find = void 0;
                    var i, o = n( /*! ./type */ 35922),
                        a = n( /*! ./iterator */ 95479),
                        r = n( /*! ./object */ 48013),
                        s = (i = n( /*! ../config */ 80209)) && i.__esModule ? i : {
                            default: i
                        };

                    function l() {
                        return l = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, l.apply(this, arguments)
                    }

                    function u(e) {
                        return function(e) {
                            if (Array.isArray(e)) {
                                return d(e)
                            }
                        }(e) || function(e) {
                            if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                return Array.from(e)
                            }
                        }(e) || function(e, t) {
                            if (!e) {
                                return
                            }
                            if ("string" == typeof e) {
                                return d(e, t)
                            }
                            var n = Object.prototype.toString.call(e).slice(8, -1);
                            "Object" === n && e.constructor && (n = e.constructor.name);
                            if ("Map" === n || "Set" === n) {
                                return Array.from(e)
                            }
                            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                return d(e, t)
                            }
                        }(e) || function() {
                            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                        }()
                    }

                    function d(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    t.isEmpty = function(e) {
                        return Array.isArray(e) && !e.length
                    };
                    t.wrapToArray = function(e) {
                        return Array.isArray(e) ? e : [e]
                    };
                    var c = function(e, t) {
                        return t ? (Array.isArray(t) ? t : t.toArray()).indexOf(e) : -1
                    };
                    t.inArray = c;
                    t.intersection = function(e, t) {
                        if (!Array.isArray(e) || 0 === e.length || !Array.isArray(t) || 0 === t.length) {
                            return []
                        }
                        var n = [];
                        return (0, a.each)(e, (function(e, i) {
                            -1 !== c(i, t) && n.push(i)
                        })), n
                    };
                    t.uniqueValues = function(e) {
                        return u(new Set(e))
                    };
                    t.removeDuplicates = function(e, t) {
                        if (!Array.isArray(e) || 0 === e.length) {
                            return []
                        }
                        var n = e.slice();
                        return Array.isArray(t) && 0 !== t.length ? ((0, a.each)(t, (function(e, t) {
                            var i = c(t, n);
                            n.splice(i, 1)
                        })), n) : n
                    };
                    t.normalizeIndexes = function(e, t, n, i) {
                        var l = {},
                            u = 0,
                            d = (0, s.default)().useLegacyVisibleIndex;
                        return (0, a.each)(e, (function(e, i) {
                            (e = i[t]) >= 0 ? (l[e] = l[e] || [], i === n ? l[e].unshift(i) : l[e].push(i)) : i[t] = void 0
                        })), d || (0, a.each)(e, (function() {
                            if (!(0, o.isDefined)(this[t]) && (!i || i(this))) {
                                for (; l[u];) {
                                    u++
                                }
                                l[u] = [this], u++
                            }
                        })), u = 0, (0, r.orderEach)(l, (function(e, n) {
                            (0, a.each)(n, (function() {
                                e >= 0 && (this[t] = u++)
                            }))
                        })), d && (0, a.each)(e, (function() {
                            (0, o.isDefined)(this[t]) || i && !i(this) || (this[t] = u++)
                        })), u
                    };
                    t.merge = function(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            e[e.length] = t[n]
                        }
                        return e
                    };
                    t.find = function(e, t) {
                        for (var n = 0; n < e.length; n++) {
                            if (t(e[n])) {
                                return e[n]
                            }
                        }
                    };
                    t.groupBy = function(e, t) {
                        return e.reduce((function(e, n) {
                            return l({}, e, function(e, t, n) {
                                return t in e ? Object.defineProperty(e, t, {
                                    value: n,
                                    enumerable: !0,
                                    configurable: !0,
                                    writable: !0
                                }) : e[t] = n, e
                            }({}, t(n), [].concat(u(e[t(n)] || []), [n])))
                        }), {})
                    }
                },
            34671:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/array_compare.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.isKeysEqual = t.findChanges = void 0;
                    var i = n( /*! ./type */ 35922),
                        o = function(e, t) {
                            var n = t(e);
                            if ((0, i.isObject)(n)) {
                                try {
                                    return JSON.stringify(n)
                                } catch (e) {
                                    return n
                                }
                            }
                            return n
                        },
                        a = function(e, t, n, i) {
                            return t[n[o(e, i)]]
                        };
                    t.isKeysEqual = function(e, t) {
                        if (e.length !== t.length) {
                            return !1
                        }
                        for (var n = 0; n < t.length; n++) {
                            if (e[n] !== t[n]) {
                                return !1
                            }
                        }
                        return !0
                    };
                    t.findChanges = function(e, t, n, i) {
                        var r = {},
                            s = {},
                            l = 0,
                            u = 0,
                            d = [];
                        e.forEach((function(e, t) {
                            var i = o(e, n);
                            r[i] = t
                        })), t.forEach((function(e, t) {
                            var i = o(e, n);
                            s[i] = t
                        }));
                        for (var c = Math.max(e.length, t.length), h = 0; h < c + l; h++) {
                            var f = t[h],
                                p = h - l + u,
                                g = e[p];
                            if (!f || g && !a(g, t, s, n)) {
                                g && (d.push({
                                    type: "remove",
                                    key: n(g),
                                    index: h,
                                    oldItem: g
                                }), u++, h--)
                            } else {
                                var m = o(f, n),
                                    _ = r[m],
                                    v = e[_];
                                if (v) {
                                    if (_ !== p) {
                                        return
                                    }
                                    i(v, f) || d.push({
                                        type: "update",
                                        data: f,
                                        key: n(f),
                                        index: h,
                                        oldItem: v
                                    })
                                } else {
                                    l++, d.push({
                                        type: "insert",
                                        data: f,
                                        index: h
                                    })
                                }
                            }
                        }
                        return d
                    }
                },
            47810:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/browser.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./extend */ 13306),
                        o = (0, n( /*! ./window */ 58201).getNavigator)(),
                        a = /(webkit)[ /]([\w.]+)/,
                        r = /(mozilla)(?:.*? rv:([\w.]+))/,
                        s = function(e) {
                            e = e.toLowerCase();
                            var t = {},
                                n = a.exec(e) || e.indexOf("compatible") < 0 && r.exec(e) || [],
                                i = n[1],
                                o = n[2];
                            return "webkit" === i && (t.webkit = !0, e.indexOf("chrome") >= 0 || e.indexOf("crios") >= 0 ? (i = "chrome", o = (o = /(?:chrome|crios)\/(\d+\.\d+)/.exec(e)) && o[1]) : e.indexOf("fxios") >= 0 ? (i = "mozilla", o = (o = /fxios\/(\d+\.\d+)/.exec(e)) && o[1]) : e.indexOf("safari") >= 0 && /version|phantomjs/.test(e) ? (i = "safari", o = (o = /(?:version|phantomjs)\/([0-9.]+)/.exec(e)) && o[1]) : (i = "unknown", o = (o = /applewebkit\/([0-9.]+)/.exec(e)) && o[1])), i && (t[i] = !0, t.version = o), t
                        },
                        l = (0, i.extend)({
                            _fromUA: s
                        }, s(o.userAgent));
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            39618:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/call_once.js ***!
                  \*********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = function(e) {
                        var t, n = function() {
                            return t = e.apply(this, arguments), n = function() {
                                return t
                            }, t
                        };
                        return function() {
                            return n.apply(this, arguments)
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            44504:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/callbacks.js ***!
                  \*********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    var n = function(e) {
                        this._options = e || {}, this._list = [], this._queue = [], this._firing = !1, this._fired = !1, this._firingIndexes = []
                    };
                    n.prototype._fireCore = function(e, t) {
                        var n = this._firingIndexes,
                            i = this._list,
                            o = this._options.stopOnFalse,
                            a = n.length;
                        for (n[a] = 0; n[a] < i.length; n[a]++) {
                            if (!1 === i[n[a]].apply(e, t) && o) {
                                break
                            }
                        }
                        n.pop()
                    }, n.prototype.add = function(e) {
                        return "function" != typeof e || this._options.unique && this.has(e) || this._list.push(e), this
                    }, n.prototype.remove = function(e) {
                        var t = this._list,
                            n = this._firingIndexes,
                            i = t.indexOf(e);
                        if (i > -1 && (t.splice(i, 1), this._firing && n.length)) {
                            for (var o = 0; o < n.length; o++) {
                                i <= n[o] && n[o]--
                            }
                        }
                        return this
                    }, n.prototype.has = function(e) {
                        var t = this._list;
                        return e ? t.indexOf(e) > -1 : !!t.length
                    }, n.prototype.empty = function(e) {
                        return this._list = [], this
                    }, n.prototype.fireWith = function(e, t) {
                        var n = this._queue;
                        if (t = (t = t || []).slice ? t.slice() : t, this._options.syncStrategy) {
                            this._firing = !0, this._fireCore(e, t)
                        } else {
                            if (n.push([e, t]), this._firing) {
                                return
                            }
                            for (this._firing = !0; n.length;) {
                                var i = n.shift();
                                this._fireCore(i[0], i[1])
                            }
                        }
                        return this._firing = !1, this._fired = !0, this
                    }, n.prototype.fire = function() {
                        this.fireWith(this, arguments)
                    }, n.prototype.fired = function() {
                        return this._fired
                    };
                    t.default = function(e) {
                        return new n(e)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            20576:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/common.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.splitPair = t.pairToObject = t.normalizeKey = t.noop = t.grep = t.getKeyHash = t.findBestMatches = t.executeAsync = t.escapeRegExp = t.equalByValue = t.ensureDefined = t.denormalizeKey = t.deferUpdater = t.deferUpdate = t.deferRenderer = t.deferRender = t.asyncNoop = t.applyServerDecimalSeparator = void 0;
                    var i = u(n( /*! ../config */ 80209)),
                        o = u(n( /*! ../guid */ 73176)),
                        a = n( /*! ../utils/deferred */ 62754),
                        r = n( /*! ./data */ 47617),
                        s = n( /*! ./iterator */ 95479),
                        l = n( /*! ./type */ 35922);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.ensureDefined = function(e, t) {
                        return (0, l.isDefined)(e) ? e : t
                    };
                    t.executeAsync = function(e, t) {
                        var n = new a.Deferred,
                            i = t || this,
                            o = {
                                promise: n.promise(),
                                abort: function() {
                                    clearTimeout(s), n.rejectWith(i)
                                }
                            },
                            r = function() {
                                var t = e.call(i);
                                t && t.done && (0, l.isFunction)(t.done) ? t.done((function() {
                                    n.resolveWith(i)
                                })) : n.resolveWith(i)
                            },
                            s = (arguments[2] || setTimeout)(r, "number" == typeof t ? t : 0);
                        return o
                    };
                    var d, c = [],
                        h = [],
                        f = [],
                        p = function(e, t, n) {
                            if (d && d !== e) {
                                return c.push(t), h.push(e), n = n || new a.Deferred, f.push(n), n
                            }
                            var i = d,
                                o = f.length;
                            d = e;
                            var r = t();
                            return r || (f.length > o ? r = a.when.apply(this, f.slice(o)) : n && n.resolve()), d = i, n && r && r.done && r.done(n.resolve).fail(n.reject), !d && c.length && ("render" === h.shift() ? g : m)(c.shift(), f.shift()), r || (0, a.when)()
                        },
                        g = function(e, t) {
                            return p("render", e, t)
                        };
                    t.deferRender = g;
                    var m = function(e, t) {
                        return p("update", e, t)
                    };
                    t.deferUpdate = m;
                    t.deferRenderer = function(e) {
                        return function() {
                            var t = this;
                            return p("render", (function() {
                                return e.call(t)
                            }))
                        }
                    };
                    t.deferUpdater = function(e) {
                        return function() {
                            var t = this;
                            return p("update", (function() {
                                return e.call(t)
                            }))
                        }
                    };
                    t.findBestMatches = function(e, t, n) {
                        var i = [],
                            o = 0;
                        return (0, s.each)(t, (function(t, a) {
                            var r = 0,
                                l = n ? n(a) : a;
                            (0, s.each)(e, (function(e, t) {
                                var n = l[e];
                                if (void 0 !== n) {
                                    if (!_(n, t)) {
                                        return r = -1, !1
                                    }
                                    r++
                                }
                            })), r < o || (r > o && (i.length = 0, o = r), i.push(a))
                        })), i
                    };
                    var _ = function(e, t) {
                            if (Array.isArray(e) && Array.isArray(t)) {
                                var n = !1;
                                return (0, s.each)(e, (function(e, i) {
                                    if (i !== t[e]) {
                                        return n = !0, !1
                                    }
                                })), !n
                            }
                            return e === t
                        },
                        v = function(e) {
                            var t, n;
                            switch ((0, l.type)(e)) {
                                case "string":
                                    return e.split(/\s+/, 2);
                                case "object":
                                    return [null !== (t = e.x) && void 0 !== t ? t : e.h, null !== (n = e.y) && void 0 !== n ? n : e.v];
                                case "number":
                                    return [e];
                                case "array":
                                    return e;
                                default:
                                    return null
                            }
                        };
                    t.splitPair = v;
                    t.normalizeKey = function(e) {
                        var t = (0, l.isString)(e) ? e : e.toString(),
                            n = t.match(/[^a-zA-Z0-9_]/g);
                        return n && (0, s.each)(n, (function(e, n) {
                            t = t.replace(n, "__" + n.charCodeAt() + "__")
                        })), t
                    };
                    t.denormalizeKey = function(e) {
                        var t = e.match(/__\d+__/g);
                        return t && t.forEach((function(t) {
                            var n = parseInt(t.replace("__", ""));
                            e = e.replace(t, String.fromCharCode(n))
                        })), e
                    };
                    t.pairToObject = function(e, t) {
                        var n = v(e),
                            i = t ? parseFloat(n && n[0]) : parseInt(n && n[0], 10),
                            o = t ? parseFloat(n && n[1]) : parseInt(n && n[1], 10);
                        return isFinite(i) || (i = 0), isFinite(o) || (o = i), {
                            h: i,
                            v: o
                        }
                    };
                    t.getKeyHash = function(e) {
                        if (e instanceof o.default) {
                            return e.toString()
                        }
                        if ((0, l.isObject)(e) || Array.isArray(e)) {
                            try {
                                var t = JSON.stringify(e);
                                return "{}" === t ? e : t
                            } catch (t) {
                                return e
                            }
                        }
                        return e
                    };
                    t.escapeRegExp = function(e) {
                        return e.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
                    };
                    t.applyServerDecimalSeparator = function(e) {
                        var t = (0, i.default)().serverDecimalSeparator;
                        return (0, l.isDefined)(e) && (e = e.toString().replace(".", t)), e
                    };
                    t.noop = function() {};
                    t.asyncNoop = function() {
                        return (new a.Deferred).resolve().promise()
                    };
                    t.grep = function(e, t, n) {
                        for (var i = [], o = !n, a = 0; a < e.length; a++) {
                            !!t(e[a], a) === o && i.push(e[a])
                        }
                        return i
                    };
                    var y = function(e, t, n) {
                            if (e.length !== t.length) {
                                return !1
                            }
                            for (var i = 0; i < e.length; i++) {
                                if (!x(e[i], t[i], n + 1)) {
                                    return !1
                                }
                            }
                            return !0
                        },
                        b = function(e, t, n, i) {
                            for (var o in e) {
                                if (Object.prototype.hasOwnProperty.call(e, o) && !x(e[o], t[o], n + 1, i)) {
                                    return !1
                                }
                            }
                            for (var a in t) {
                                if (!(a in e)) {
                                    return !1
                                }
                            }
                            return !0
                        },
                        x = function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0,
                                i = !(arguments.length > 3 && void 0 !== arguments[3]) || arguments[3];
                            e = (0, r.toComparable)(e, !0), t = (0, r.toComparable)(t, !0);
                            var o = i ? e === t : e == t;
                            return !!(o || n >= 3) || ((0, l.isObject)(e) && (0, l.isObject)(t) ? b(e, t, n, i) : !(!Array.isArray(e) || !Array.isArray(t)) && y(e, t, n))
                        };
                    t.equalByValue = x
                },
            49036:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/comparator.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.equals = void 0;
                    var i, o = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ./data */ 47617),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return s = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, s(e)
                    }
                    t.equals = function(e, t) {
                        return e = (0, a.toComparable)(e, !0), t = (0, a.toComparable)(t, !0), e && t && (0, r.isRenderer)(e) && (0, r.isRenderer)(t) ? t.is(e) : !(e == e || t == t) || (0 === e && 0 === t ? function(e, t) {
                            return 1 / e == 1 / t
                        }(e, t) : !(null !== e && "object" === s(e) && !o.default.isElementNode(e)) && e === t)
                    }
                },
            30869:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/console.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.logger = t.debug = void 0;
                    var i = n( /*! ./type */ 35922),
                        o = function() {},
                        a = function(e) {
                            return "undefined" != typeof console && (0, i.isFunction)(console[e]) ? console[e].bind(console) : o
                        },
                        r = {
                            info: a("info"),
                            warn: a("warn"),
                            error: a("error")
                        };
                    t.logger = r;
                    var s = function() {
                        function e(e, t) {
                            if (!e) {
                                throw new Error(t)
                            }
                        }
                        return {
                            assert: e,
                            assertParam: function(t, n) {
                                e(null != t, n)
                            }
                        }
                    }();
                    t.debug = s
                },
            47617:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/data.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.toComparable = t.getPathParts = t.compileSetter = t.compileGetter = void 0;
                    var i = u(n( /*! ../errors */ 17381)),
                        o = u(n( /*! ../class */ 38377)),
                        a = n( /*! ./object */ 48013),
                        r = n( /*! ./type */ 35922),
                        s = n( /*! ./iterator */ 95479),
                        l = u(n( /*! ./variable_wrapper */ 26974));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = l.default.unwrap,
                        c = l.default.isWrapped,
                        h = l.default.assign,
                        f = function(e) {
                            return (t = e, t.replace(/\[/g, ".").replace(/\]/g, "")).split(".");
                            var t
                        };
                    t.getPathParts = f;
                    var p = function(e, t, n, o) {
                            if ("this" === t) {
                                throw new i.default.Error("E4016")
                            }
                            var a = e[t];
                            o.unwrapObservables && c(a) ? h(a, n) : e[t] = n
                        },
                        g = function(e) {
                            return (e = e || {}).unwrapObservables = void 0 === e.unwrapObservables || e.unwrapObservables, e
                        };

                    function m(e, t) {
                        return t.unwrapObservables ? d(e) : e
                    }
                    var _ = function(e) {
                        if (arguments.length > 1 && (e = [].slice.call(arguments)), !e || "this" === e) {
                            return function(e) {
                                return e
                            }
                        }
                        if ("string" == typeof e) {
                            var t = f(e);
                            return function(e, n) {
                                for (var i = (n = g(n)).functionsAsIs, o = ("defaultValue" in n), a = m(e, n), s = 0; s < t.length; s++) {
                                    if (!a) {
                                        if (null == a && o) {
                                            return n.defaultValue
                                        }
                                        break
                                    }
                                    var l = t[s];
                                    if (o && (0, r.isObject)(a) && !(l in a)) {
                                        return n.defaultValue
                                    }
                                    var u = m(a[l], n);
                                    !i && (0, r.isFunction)(u) && (u = u.call(a)), a = u
                                }
                                return a
                            }
                        }
                        return Array.isArray(e) ? v(e) : (0, r.isFunction)(e) ? e : void 0
                    };

                    function v(e) {
                        for (var t = {}, n = 0, i = e.length; n < i; n++) {
                            var o = e[n];
                            t[o] = _(o)
                        }
                        return function(e, n) {
                            var i;
                            return (0, s.each)(t, (function(t) {
                                var o = this(e, n);
                                if (void 0 !== o) {
                                    for (var a = i || (i = {}), r = t.split("."), s = r.length - 1, l = 0; l < s; l++) {
                                        var u = r[l];
                                        u in a || (a[u] = {}), a = a[u]
                                    }
                                    a[r[s]] = o
                                }
                            })), i
                        }
                    }
                    t.compileGetter = _;
                    var y = function(e, t, n, i) {
                        if ((0, r.isDefined)(n)) {
                            return n
                        }
                        var o = {};
                        return p(e, t, o, i), o
                    };
                    t.compileSetter = function(e) {
                        var t = (e = f(e || "this")).length - 1;
                        return function(n, i, o) {
                            var s = m(n, o = g(o));
                            e.forEach((function(e, n) {
                                var l = function(e, t, n) {
                                        return n = n || {}, m("this" === t ? e : e[t], n)
                                    }(s, e, o),
                                    u = !o.functionsAsIs && (0, r.isFunction)(l) && !c(l);
                                n === t ? o.merge && (0, r.isPlainObject)(i) && (!(0, r.isDefined)(l) || (0, r.isPlainObject)(l)) ? (l = y(s, e, l, o), (0, a.deepExtendArraySafe)(l, i, !1, !0)) : u ? s[e](i) : p(s, e, i, o) : (l = y(s, e, l, o), u && (l = l.call(s)), s = l)
                            }))
                        }
                    };
                    t.toComparable = function(e, t) {
                        return e instanceof Date ? e.getTime() : e && e instanceof o.default && e.valueOf ? e.valueOf() : t || "string" != typeof e ? e : e.toLowerCase()
                    }
                },
            91198:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/date.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./type */ 35922),
                        o = n( /*! ./math */ 60810),
                        a = n( /*! ./iterator */ 95479),
                        r = n( /*! ./inflector */ 78008);

                    function s(e, t, n) {
                        return s = l() ? Reflect.construct : function(e, t, n) {
                            var i = [null];
                            i.push.apply(i, t);
                            var o = new(Function.bind.apply(e, i));
                            return n && u(o, n.prototype), o
                        }, s.apply(null, arguments)
                    }

                    function l() {
                        if ("undefined" == typeof Reflect || !Reflect.construct) {
                            return !1
                        }
                        if (Reflect.construct.sham) {
                            return !1
                        }
                        if ("function" == typeof Proxy) {
                            return !0
                        }
                        try {
                            return Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], (function() {}))), !0
                        } catch (e) {
                            return !1
                        }
                    }

                    function u(e, t) {
                        return u = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, u(e, t)
                    }
                    var d = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"],
                        c = function e(t) {
                            switch (t) {
                                case "millisecond":
                                    return 1;
                                case "second":
                                    return 1e3 * e("millisecond");
                                case "minute":
                                    return 60 * e("second");
                                case "hour":
                                    return 60 * e("minute");
                                case "day":
                                    return 24 * e("hour");
                                case "week":
                                    return 7 * e("day");
                                case "month":
                                    return 30 * e("day");
                                case "quarter":
                                    return 3 * e("month");
                                case "year":
                                    return 365 * e("day");
                                default:
                                    return 0
                            }
                        },
                        h = function(e) {
                            var t, n, i, o = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                                a = {};
                            for (t = o.length - 1; t >= 0; t--) {
                                i = o[t], (n = Math.floor(e / c(i))) > 0 && (a[i + "s"] = n, e -= f(i, n))
                            }
                            return a
                        };

                    function f(e, t) {
                        return c(e) * t
                    }

                    function p(e) {
                        var t, n = -1;
                        return (0, i.isString)(e) ? e : (0, i.isObject)(e) ? ((0, a.each)(e, (function(e, i) {
                            for (t = 0; t < d.length; t++) {
                                i && (e === d[t] + "s" || e === d[t]) && n < t && (n = t)
                            }
                        })), d[n]) : ""
                    }
                    var g = {
                        millisecond: "millisecond",
                        second: "longtime",
                        minute: "shorttime",
                        hour: "shorttime",
                        day: "day",
                        week: "day",
                        month: "month",
                        quarter: "quarter",
                        year: "year"
                    };
                    var m = function(e) {
                            return Math.floor(e / 3)
                        },
                        _ = function(e) {
                            return 3 * m(e)
                        };

                    function v(e, t, n, i) {
                        e = new Date(e.getTime());
                        var o, a, r = new Date(e.getTime()),
                            s = p(t);
                        switch (s) {
                            case "second":
                                e = new Date(1e3 * Math.floor(r.getTime() / 1e3));
                                break;
                            case "minute":
                                e = new Date(6e4 * Math.floor(r.getTime() / 6e4));
                                break;
                            case "hour":
                                e = new Date(36e5 * Math.floor(r.getTime() / 36e5));
                                break;
                            case "year":
                                e.setMonth(0);
                            case "month":
                                e.setDate(1);
                            case "day":
                                e.setHours(0, 0, 0, 0);
                                break;
                            case "week":
                                (e = T(e, i || 0)).setHours(0, 0, 0, 0);
                                break;
                            case "quarter":
                                o = _(e.getMonth()), a = e.getMonth(), e.setDate(1), e.setHours(0, 0, 0, 0), a !== o && e.setMonth(o)
                        }
                        return n && "hour" !== s && "minute" !== s && "second" !== s && A(r, e), e
                    }

                    function y(e) {
                        return v(e, "day")
                    }

                    function b(e, t, n) {
                        var o = new Date(e.getTime()),
                            a = (0, i.isString)(t) ? C(t.toLowerCase()) : (0, i.isNumeric)(t) ? h(t) : t;
                        return a.years && o.setFullYear(o.getFullYear() + a.years * n), a.quarters && o.setMonth(o.getMonth() + 3 * a.quarters * n), a.months && o.setMonth(o.getMonth() + a.months * n), a.weeks && o.setDate(o.getDate() + 7 * a.weeks * n), a.days && o.setDate(o.getDate() + a.days * n), a.hours && o.setTime(o.getTime() + 36e5 * a.hours * n), a.minutes && o.setTime(o.getTime() + 6e4 * a.minutes * n), a.seconds && o.setTime(o.getTime() + 1e3 * a.seconds * n), a.milliseconds && o.setTime(o.getTime() + a.milliseconds * n), o
                    }
                    var x = function(e, t, n) {
                        var a = n ? -1 : 1;
                        return (0, i.isDate)(e) ? b(e, t, a) : (0, o.adjust)(e + t * a, t)
                    };

                    function w(e) {
                        return P(e.getFullYear(), e.getMonth() + 1, 0).getDate()
                    }

                    function C(e) {
                        var t = {};
                        switch (e) {
                            case "year":
                                t.years = 1;
                                break;
                            case "month":
                                t.months = 1;
                                break;
                            case "quarter":
                                t.months = 3;
                                break;
                            case "week":
                                t.weeks = 1;
                                break;
                            case "day":
                                t.days = 1;
                                break;
                            case "hour":
                                t.hours = 1;
                                break;
                            case "minute":
                                t.minutes = 1;
                                break;
                            case "second":
                                t.seconds = 1;
                                break;
                            case "millisecond":
                                t.milliseconds = 1
                        }
                        return t
                    }

                    function S(e, t) {
                        return k(e, t) && e.getMonth() === t.getMonth()
                    }

                    function k(e, t) {
                        return e && t && e.getFullYear() === t.getFullYear()
                    }

                    function I(e) {
                        return e && e.getFullYear() - e.getFullYear() % 100
                    }

                    function D(e) {
                        return e && e.getFullYear() - e.getFullYear() % 10
                    }

                    function T(e, t) {
                        var n = (e.getDay() - t + 7) % 7,
                            i = new Date(e);
                        return i.setDate(e.getDate() - n), i
                    }

                    function E(e, t, n) {
                        var o = e;
                        return (0, i.isDefined)(e) ? ((0, i.isDefined)(t) && e < t && (o = t), (0, i.isDefined)(n) && e > n && (o = n), o) : e
                    }

                    function A(e, t) {
                        if ((0, i.isDefined)(e)) {
                            var n = t.getHours() - e.getHours();
                            if (0 !== n) {
                                var o = 1 === n || -23 === n ? -1 : 1,
                                    a = new Date(t.getTime() + 36e5 * o);
                                (o > 0 || a.getDate() === t.getDate()) && t.setTime(a.getTime())
                            }
                        }
                    }

                    function O(e, t) {
                        return 60 * (t.getTimezoneOffset() - e.getTimezoneOffset()) * 1e3
                    }
                    var P = function(e) {
                            var t = s(Date, Array.prototype.slice.call(arguments));
                            return t.setFullYear(e), t
                        },
                        M = {
                            dateUnitIntervals: d,
                            convertMillisecondsToDateUnits: h,
                            dateToMilliseconds: function(e) {
                                var t = 0;
                                return (0, i.isObject)(e) && (0, a.each)(e, (function(e, n) {
                                    t += f(e.substr(0, e.length - 1), n)
                                })), (0, i.isString)(e) && (t = f(e, 1)), t
                            },
                            getNextDateUnit: function(e, t) {
                                switch (p(e)) {
                                    case "millisecond":
                                        return "second";
                                    case "second":
                                        return "minute";
                                    case "minute":
                                        return "hour";
                                    case "hour":
                                        return "day";
                                    case "day":
                                        return t ? "week" : "month";
                                    case "week":
                                        return "month";
                                    case "month":
                                        return "quarter";
                                    case "quarter":
                                    case "year":
                                        return "year";
                                    default:
                                        return 0
                                }
                            },
                            convertDateUnitToMilliseconds: f,
                            getDateUnitInterval: p,
                            getDateFormatByTickInterval: function(e) {
                                return g[p(e)] || ""
                            },
                            getDatesDifferences: function(e, t) {
                                var n = 0,
                                    i = {
                                        year: e.getFullYear() !== t.getFullYear(),
                                        month: e.getMonth() !== t.getMonth(),
                                        day: e.getDate() !== t.getDate(),
                                        hour: e.getHours() !== t.getHours(),
                                        minute: e.getMinutes() !== t.getMinutes(),
                                        second: e.getSeconds() !== t.getSeconds(),
                                        millisecond: e.getMilliseconds() !== t.getMilliseconds()
                                    };
                                return (0, a.each)(i, (function(e, t) {
                                    t && n++
                                })), 0 === n && 0 !== O(e, t) && (i.hour = !0, n++), i.count = n, i
                            },
                            correctDateWithUnitBeginning: v,
                            trimTime: y,
                            setToDayEnd: function(e) {
                                var t = y(e);
                                return t.setDate(t.getDate() + 1), new Date(t.getTime() - 1)
                            },
                            roundDateByStartDayHour: function(e, t) {
                                var n = this.dateTimeFromDecimal(t),
                                    i = new Date(e);
                                return (e.getHours() === n.hours && e.getMinutes() < n.minutes || e.getHours() < n.hours) && i.setHours(n.hours, n.minutes, 0, 0), i
                            },
                            dateTimeFromDecimal: function(e) {
                                return {
                                    hours: Math.floor(e),
                                    minutes: e % 1 * 60
                                }
                            },
                            addDateInterval: b,
                            addInterval: x,
                            getSequenceByInterval: function(e, t, n) {
                                var o, a = [];
                                for (a.push((0, i.isDate)(e) ? new Date(e.getTime()) : e), o = e; o < t;) {
                                    o = x(o, n), a.push(o)
                                }
                                return a
                            },
                            getDateIntervalByString: C,
                            sameDate: function(e, t) {
                                return S(e, t) && e.getDate() === t.getDate()
                            },
                            sameMonthAndYear: S,
                            sameMonth: S,
                            sameYear: k,
                            sameDecade: function(e, t) {
                                if ((0, i.isDefined)(e) && (0, i.isDefined)(t)) {
                                    var n = e.getFullYear() - e.getFullYear() % 10,
                                        o = t.getFullYear() - t.getFullYear() % 10;
                                    return e && t && n === o
                                }
                            },
                            sameCentury: function(e, t) {
                                if ((0, i.isDefined)(e) && (0, i.isDefined)(t)) {
                                    var n = e.getFullYear() - e.getFullYear() % 100,
                                        o = t.getFullYear() - t.getFullYear() % 100;
                                    return e && t && n === o
                                }
                            },
                            getDifferenceInMonth: function(e) {
                                var t = 1;
                                return "year" === e && (t = 12), "decade" === e && (t = 120), "century" === e && (t = 1200), t
                            },
                            getDifferenceInMonthForCells: function(e) {
                                var t = 1;
                                return "decade" === e && (t = 12), "century" === e && (t = 120), t
                            },
                            getFirstYearInDecade: D,
                            getFirstDecadeInCentury: I,
                            getShortDateFormat: function() {
                                return "yyyy/MM/dd"
                            },
                            getViewFirstCellDate: function(e, t) {
                                return "month" === e ? P(t.getFullYear(), t.getMonth(), 1) : "year" === e ? P(t.getFullYear(), 0, t.getDate()) : "decade" === e ? P(D(t), t.getMonth(), t.getDate()) : "century" === e ? P(I(t), t.getMonth(), t.getDate()) : void 0
                            },
                            getViewLastCellDate: function(e, t) {
                                return "month" === e ? P(t.getFullYear(), t.getMonth(), w(t)) : "year" === e ? P(t.getFullYear(), 11, t.getDate()) : "decade" === e ? P(D(t) + 9, t.getMonth(), t.getDate()) : "century" === e ? P(I(t) + 90, t.getMonth(), t.getDate()) : void 0
                            },
                            getViewDown: function(e) {
                                switch (e) {
                                    case "century":
                                        return "decade";
                                    case "decade":
                                        return "year";
                                    case "year":
                                        return "month"
                                }
                            },
                            getViewUp: function(e) {
                                switch (e) {
                                    case "month":
                                        return "year";
                                    case "year":
                                        return "decade";
                                    case "decade":
                                        return "century"
                                }
                            },
                            getLastMonthDay: w,
                            getLastMonthDate: function(e) {
                                if ((0, i.isDefined)(e)) {
                                    return P(e.getFullYear(), e.getMonth() + 1, 0)
                                }
                            },
                            getFirstMonthDate: function(e) {
                                if ((0, i.isDefined)(e)) {
                                    return P(e.getFullYear(), e.getMonth(), 1)
                                }
                            },
                            getFirstWeekDate: T,
                            normalizeDateByWeek: function(e, t) {
                                var n = M.getDatesInterval(e, t, "day"),
                                    i = new Date(e);
                                return n >= 6 && (i = new Date(i.setDate(i.getDate() + 7))), i
                            },
                            getQuarter: m,
                            getFirstQuarterMonth: _,
                            dateInRange: function(e, t, n, i) {
                                return "date" === i && (t = t && M.correctDateWithUnitBeginning(t, "day"), n = n && M.correctDateWithUnitBeginning(n, "day"), e = e && M.correctDateWithUnitBeginning(e, "day")), E(e, t, n) === e
                            },
                            intervalsOverlap: function(e) {
                                var t = e.firstMin,
                                    n = e.firstMax,
                                    i = e.secondMin,
                                    o = e.secondMax;
                                return t <= i && i <= n || t > i && t < o || t < o && n > o
                            },
                            roundToHour: function(e) {
                                var t = new Date(e.getTime());
                                return t.setHours(t.getHours() + 1), t.setMinutes(0), t
                            },
                            normalizeDate: E,
                            getViewMinBoundaryDate: function(e, t) {
                                var n = P(t.getFullYear(), t.getMonth(), 1);
                                return "month" === e ? n : (n.setMonth(0), "year" === e || ("decade" === e && n.setFullYear(D(t)), "century" === e && n.setFullYear(I(t))), n)
                            },
                            getViewMaxBoundaryDate: function(e, t) {
                                var n = new Date(t);
                                return n.setDate(w(t)), "month" === e ? n : (n.setMonth(11), n.setDate(w(n)), "year" === e || ("decade" === e && n.setFullYear(D(t) + 9), "century" === e && n.setFullYear(I(t) + 99)), n)
                            },
                            fixTimezoneGap: A,
                            getTimezonesDifference: O,
                            makeDate: function(e) {
                                return new Date(e)
                            },
                            getDatesInterval: function(e, t, n) {
                                var i = t.getTime() - e.getTime(),
                                    o = c(n) || 1;
                                return Math.floor(i / o)
                            },
                            getDatesOfInterval: function(e, t, n) {
                                for (var i = [], o = new Date(e.getTime()); o < t;) {
                                    i.push(new Date(o.getTime())), o = this.addInterval(o, n)
                                }
                                return i
                            },
                            createDateWithFullYear: P,
                            sameView: function(e, t, n) {
                                return M[(0, r.camelize)("same " + e)](t, n)
                            }
                        },
                        R = M;
                    t.default = R, e.exports = t.default, e.exports.default = t.default
                },
            69434:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/date_serialization.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../config */ 80209)),
                        o = n( /*! ../../localization/ldml/date.formatter */ 40594),
                        a = s(n( /*! ../../localization/default_date_names */ 15564)),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = "number",
                        u = "yyyy/MM/dd",
                        d = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,
                        c = /^(\d{2}):(\d{2})(:(\d{2}))?$/,
                        h = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"],
                        f = /^(\d{4})\/(\d{2})\/(\d{2})$/,
                        p = function(e, t) {
                            var n;
                            return (0, r.isString)(e) && !t && (n = function(e) {
                                var t = e.match(d);
                                if (!t) {
                                    return (t = e.match(c)) ? new Date(0, 0, 0, g(t[1]), g(t[2]), g(t[4])) : void 0
                                }
                                var n = g(t[1]),
                                    i = --t[3],
                                    o = t[5],
                                    a = 0,
                                    r = 0,
                                    s = function(e) {
                                        return n < 100 && e.setFullYear(n), e
                                    };
                                a = g(t[14]), r = g(t[16]), "-" === t[13] && (a = -a, r = -r);
                                var l = g(t[6]) - a,
                                    u = g(t[8]) - r,
                                    h = g(t[10]),
                                    f = (p = t[11], g(p = p || "") * Math.pow(10, 3 - p.length));
                                var p;
                                if (t[12]) {
                                    return s(new Date(Date.UTC(n, i, o, l, u, h, f)))
                                }
                                return s(new Date(n, i, o, l, u, h, f))
                            }(e)), n || function(e) {
                                var t = m(e) === u,
                                    n = !(0, r.isDate)(e) && Date.parse(e);
                                if (!n && t) {
                                    var i = e.match(f);
                                    if (i) {
                                        var o = new Date(g(i[1]), g(i[2]), g(i[3]));
                                        return o.setFullYear(g(i[1])), o.setMonth(g(i[2]) - 1), o.setDate(g(i[3])), o
                                    }
                                }
                                return (0, r.isNumeric)(n) ? new Date(n) : e
                            }(e)
                        };

                    function g(e) {
                        return +e || 0
                    }
                    var m = function(e) {
                            return "number" == typeof e ? l : (0, r.isString)(e) ? ((0, i.default)().forceIsoDateParsing && (t = function(e, t) {
                                var n = e.match(d),
                                    i = "";
                                if (!n) {
                                    return (n = e.match(c)) ? n[3] ? "HH:mm:ss" : "HH:mm" : void 0
                                }
                                for (var o = 1; o < h.length; o++) {
                                    n[o] && (i += h[o] || n[o])
                                }
                                return "Z" === n[12] && (i += "'Z'"), n[14] && (n[15] ? i += "xxx" : n[16] ? i += "xx" : i += "x"), i
                            }(e)), t || (e.indexOf(":") >= 0 ? "yyyy/MM/dd HH:mm:ss" : u)) : e ? null : void 0;
                            var t
                        },
                        _ = {
                            dateParser: p,
                            deserializeDate: function(e) {
                                return "number" == typeof e ? new Date(e) : p(e, !(0, i.default)().forceIsoDateParsing)
                            },
                            serializeDate: function(e, t) {
                                return t ? (0, r.isDate)(e) ? t === l ? e && e.valueOf ? e.valueOf() : null : (0, o.getFormatter)(t, a.default)(e) : null : e
                            },
                            getDateSerializationFormat: m
                        };
                    t.default = _, e.exports = t.default, e.exports.default = t.default
                },
            62754:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/deferred.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.Deferred = function() {
                        return new l
                    }, t.fromPromise = u, t.setStrategy = function(e) {
                        l = e.Deferred, d = e.when
                    }, t.when = function() {
                        return d.apply(this, arguments)
                    };
                    var i, o = n( /*! ../utils/type */ 35922),
                        a = n( /*! ../utils/extend */ 13306),
                        r = (i = n( /*! ../utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        };
                    var s = [{
                            method: "resolve",
                            handler: "done",
                            state: "resolved"
                        }, {
                            method: "reject",
                            handler: "fail",
                            state: "rejected"
                        }, {
                            method: "notify",
                            handler: "progress"
                        }],
                        l = function() {
                            var e = this;
                            this._state = "pending", this._promise = {}, s.forEach(function(t) {
                                var n = t.method;
                                this[n + "Callbacks"] = new r.default, this[n] = function() {
                                    return this[n + "With"](this._promise, arguments)
                                }.bind(this), this._promise[t.handler] = function(t) {
                                    if (!t) {
                                        return this
                                    }
                                    var i = e[n + "Callbacks"];
                                    return i.fired() ? t.apply(e[n + "Context"], e[n + "Args"]) : i.add(function(e, n) {
                                        t.apply(e, n)
                                    }.bind(this)), this
                                }
                            }.bind(this)), this._promise.always = function(e) {
                                return this.done(e).fail(e)
                            }, this._promise.catch = function(e) {
                                return this.then(null, e)
                            }, this._promise.then = function(e, t) {
                                var n = new l;
                                return ["done", "fail"].forEach(function(i) {
                                    var a = "done" === i ? e : t;
                                    this[i]((function() {
                                        if (a) {
                                            var e = a && a.apply(this, arguments);
                                            (0, o.isDeferred)(e) ? e.done(n.resolve).fail(n.reject): (0, o.isPromise)(e) ? e.then(n.resolve, n.reject) : n.resolve.apply(this, (0, o.isDefined)(e) ? [e] : arguments)
                                        } else {
                                            n["done" === i ? "resolve" : "reject"].apply(this, arguments)
                                        }
                                    }))
                                }.bind(this)), n.promise()
                            }, this._promise.state = function() {
                                return e._state
                            }, this._promise.promise = function(t) {
                                return t ? (0, a.extend)(t, e._promise) : e._promise
                            }, this._promise.promise(this)
                        };

                    function u(e, t) {
                        if ((0, o.isDeferred)(e)) {
                            return e
                        }
                        if ((0, o.isPromise)(e)) {
                            var n = new l;
                            return e.then((function() {
                                n.resolveWith.apply(n, [t].concat([
                                    [].slice.call(arguments)
                                ]))
                            }), (function() {
                                n.rejectWith.apply(n, [t].concat([
                                    [].slice.call(arguments)
                                ]))
                            })), n
                        }
                        return (new l).resolveWith(t, [e])
                    }
                    s.forEach((function(e) {
                        var t = e.method,
                            n = e.state;
                        l.prototype[t + "With"] = function(e, i) {
                            var o = this[t + "Callbacks"];
                            return "pending" === this.state() && (this[t + "Args"] = i, this[t + "Context"] = e, n && (this._state = n), o.fire(e, i)), this
                        }
                    }));
                    var d = function() {
                        if (1 === arguments.length) {
                            return u(arguments[0])
                        }
                        for (var e = [].slice.call(arguments), t = [], n = 0, i = new l, a = function(o) {
                                return function(a) {
                                    t[o] = this, e[o] = arguments.length > 1 ? [].slice.call(arguments) : a, ++n === e.length && i.resolveWith(t, e)
                                }
                            }, r = 0; r < e.length; r++) {
                            (0, o.isDeferred)(e[r]) ? e[r].promise().done(a(r)).fail(i.reject): n++
                        }
                        return n === e.length && i.resolveWith(t, e), i.promise()
                    }
                },
            20476:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/dependency_injector.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = function(e) {
                        var t = s.default.inherit(e),
                            n = t,
                            i = new n(e),
                            l = {},
                            u = function(t, n) {
                                (0, r.each)(t, (function(t) {
                                    (0, a.isFunction)(i[t]) ? !n && e[t] || (e[t] = function() {
                                        return i[t].apply(e, arguments)
                                    }): (n && (l[t] = e[t]), e[t] = i[t])
                                }))
                            };
                        return u(e, !0), e.inject = function(e) {
                            n = n.inherit(e), i = new n, u(e)
                        }, e.resetInjection = function() {
                            (0, o.extend)(e, l), n = t, i = new t
                        }, e
                    };
                    var i, o = n( /*! ./extend */ 13306),
                        a = n( /*! ./type */ 35922),
                        r = n( /*! ./iterator */ 95479),
                        s = (i = n( /*! ../class */ 38377)) && i.__esModule ? i : {
                            default: i
                        };
                    e.exports = t.default, e.exports.default = t.default
                },
            3532:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/dom.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.resetActiveElement = t.replaceWith = t.normalizeTemplateElement = t.insertBefore = t.extractTemplateMarkup = t.createTextElementHiddenCopy = t.contains = t.closestCommonParent = t.clipboardText = t.clearSelection = void 0;
                    var i = s(n( /*! ../../core/dom_adapter */ 73349)),
                        o = s(n( /*! ../../core/renderer */ 68374)),
                        a = n( /*! ./iterator */ 95479),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = (0, n( /*! ./window */ 58201).getWindow)();
                    t.resetActiveElement = function() {
                        var e, t = i.default.getActiveElement();
                        t && t !== i.default.getBody() && (null === (e = t.blur) || void 0 === e || e.call(t))
                    };
                    t.clearSelection = function() {
                        var e = l.getSelection();
                        if (e && "Caret" !== e.type) {
                            if (e.empty) {
                                e.empty()
                            } else if (e.removeAllRanges) {
                                try {
                                    e.removeAllRanges()
                                } catch (e) {}
                            }
                        }
                    };
                    t.closestCommonParent = function(e, t) {
                        var n = (0, o.default)(e),
                            i = (0, o.default)(t);
                        if (n[0] === i[0]) {
                            return n[0]
                        }
                        for (var a = n.parents(), r = i.parents(), s = -Math.min(a.length, r.length); s < 0; s++) {
                            if (a.get(s) === r.get(s)) {
                                return a.get(s)
                            }
                        }
                    };
                    t.extractTemplateMarkup = function(e) {
                        var t = (e = (0, o.default)(e)).length && e.filter((function() {
                            var e = (0, o.default)(this);
                            return e.is("script[type]") && e.attr("type").indexOf("script") < 0
                        }));
                        return t.length ? t.eq(0).html() : (e = (0, o.default)("<div>").append(e)).html()
                    };
                    t.normalizeTemplateElement = function e(t) {
                        var n = (0, r.isDefined)(t) && (t.nodeType || (0, r.isRenderer)(t)) ? (0, o.default)(t) : (0, o.default)("<div>").html(t).contents();
                        return 1 === n.length && (n.is("script") ? n = e(n.html().trim()) : n.is("table") && (n = n.children("tbody").contents())), n
                    };
                    t.clipboardText = function(e, t) {
                        var n = e.originalEvent && e.originalEvent.clipboardData || l.clipboardData;
                        if (!t) {
                            return n && n.getData("Text")
                        }
                        n && n.setData("Text", t)
                    };
                    t.contains = function e(t, n) {
                        return !!n && (i.default.isTextNode(n) && (n = n.parentNode), i.default.isDocument(t) ? t.documentElement.contains(n) : (0, r.isWindow)(t) ? e(t.document, n) : t.contains ? t.contains(n) : !!(n.compareDocumentPosition(t) & n.DOCUMENT_POSITION_CONTAINS))
                    };
                    t.createTextElementHiddenCopy = function(e, t, n) {
                        var i = l.getComputedStyle((0, o.default)(e).get(0)),
                            a = n && n.includePaddings;
                        return (0, o.default)("<div>").text(t).css({
                            fontStyle: i.fontStyle,
                            fontVariant: i.fontVariant,
                            fontWeight: i.fontWeight,
                            fontSize: i.fontSize,
                            fontFamily: i.fontFamily,
                            letterSpacing: i.letterSpacing,
                            border: i.border,
                            paddingTop: a ? i.paddingTop : "",
                            paddingRight: a ? i.paddingRight : "",
                            paddingBottom: a ? i.paddingBottom : "",
                            paddingLeft: a ? i.paddingLeft : "",
                            visibility: "hidden",
                            whiteSpace: "pre",
                            position: "absolute",
                            float: "left"
                        })
                    };
                    var u = function(e, t) {
                        return t && i.default.insertElement(e.parentNode, t, e), e
                    };
                    t.insertBefore = u;
                    t.replaceWith = function(e, t) {
                        if (t && t[0]) {
                            return t.is(e) ? e : ((0, a.each)(t, (function(t, n) {
                                u(e[0], n)
                            })), e.remove(), t)
                        }
                    }
                },
            95640:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/error.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = function(e, t) {
                        var n = {
                            ERROR_MESSAGES: (0, i.extend)(t, e),
                            Error: function() {
                                return d([].slice.call(arguments))
                            },
                            log: function(e) {
                                var t = "log";
                                /^E\d+$/.test(e) ? t = "error" : /^W\d+$/.test(e) && (t = "warn"), o.logger[t]("log" === t ? e : s([].slice.call(arguments)))
                            }
                        };

                        function s(e) {
                            var t = e[0];
                            return u(t, l(t, e = e.slice(1)))
                        }

                        function l(e, t) {
                            return t = [n.ERROR_MESSAGES[e]].concat(t), a.format.apply(this, t).replace(/\.*\s*?$/, "")
                        }

                        function u(e, t) {
                            return a.format.apply(this, ["{0} - {1}. See:\n{2}", e, t, c(e)])
                        }

                        function d(e) {
                            var t = e[0],
                                n = l(t, e = e.slice(1)),
                                o = c(t),
                                a = u(t, n);
                            return (0, i.extend)(new Error(a), {
                                __id: t,
                                __details: n,
                                url: o
                            })
                        }

                        function c(e) {
                            return r + e
                        }
                        return n
                    };
                    var i = n( /*! ./extend */ 13306),
                        o = n( /*! ./console */ 30869),
                        a = n( /*! ./string */ 68752),
                        r = "http://js.devexpress.com/error/" + n( /*! ../version */ 36739).version.split(".").slice(0, 2).join("_") + "/";
                    e.exports = t.default, e.exports.default = t.default
                },
            13306:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/extend.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.extendFromObject = t.extend = void 0;
                    var i = n( /*! ./type */ 35922);
                    t.extendFromObject = function(e, t, n) {
                        for (var i in e = e || {}, t) {
                            if (Object.prototype.hasOwnProperty.call(t, i)) {
                                var o = t[i];
                                i in e && !n || (e[i] = o)
                            }
                        }
                        return e
                    };
                    t.extend = function e(t) {
                        var n = 1,
                            o = !1;
                        for ("boolean" == typeof(t = t || {}) && (o = t, t = arguments[1] || {}, n++); n < arguments.length; n++) {
                            var a = arguments[n];
                            if (null != a) {
                                for (var r in a) {
                                    var s = t[r],
                                        l = a[r],
                                        u = !1,
                                        d = void 0;
                                    "__proto__" !== r && "constructor" !== r && t !== l && (o && l && ((0, i.isPlainObject)(l) || (u = Array.isArray(l))) ? (d = u ? s && Array.isArray(s) ? s : [] : s && (0, i.isPlainObject)(s) ? s : {}, t[r] = e(o, d, l)) : void 0 !== l && (t[r] = l))
                                }
                            }
                        }
                        return t
                    }
                },
            61371:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/html_parser.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.parseHTML = t.isTablePart = void 0;
                    var i, o = n( /*! ./array */ 89386),
                        a = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = /<([a-z][^/\0>\x20\t\r\n\f]+)/i,
                        s = {
                            default: {
                                tagsCount: 0,
                                startTags: "",
                                endTags: ""
                            },
                            thead: {
                                tagsCount: 1,
                                startTags: "<table>",
                                endTags: "</table>"
                            },
                            td: {
                                tagsCount: 3,
                                startTags: "<table><tbody><tr>",
                                endTags: "</tr></tbody></table>"
                            },
                            col: {
                                tagsCount: 2,
                                startTags: "<table><colgroup>",
                                endTags: "</colgroup></table>"
                            },
                            tr: {
                                tagsCount: 2,
                                startTags: "<table><tbody>",
                                endTags: "</tbody></table>"
                            }
                        };
                    s.tbody = s.colgroup = s.caption = s.tfoot = s.thead, s.th = s.td;
                    t.parseHTML = function(e) {
                        if ("string" != typeof e) {
                            return null
                        }
                        var t = a.default.createDocumentFragment().appendChild(a.default.createElement("div")),
                            n = r.exec(e),
                            i = n && n[1].toLowerCase(),
                            l = s[i] || s.default;
                        t.innerHTML = l.startTags + e + l.endTags;
                        for (var u = 0; u < l.tagsCount; u++) {
                            t = t.lastChild
                        }
                        return (0, o.merge)([], t.childNodes)
                    };
                    t.isTablePart = function(e) {
                        var t = r.exec(e);
                        return t && t[1] in s
                    }
                },
            44899:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/icon.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.getImageSourceType = t.getImageContainer = void 0;
                    var i, o = (i = n( /*! ../../core/renderer */ 68374)) && i.__esModule ? i : {
                        default: i
                    };
                    var a = "dx-icon",
                        r = function(e) {
                            return !(!e || "string" != typeof e) && (/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(e) ? "svg" : /data:.*base64|\.|[^<\s]\//.test(e) ? "image" : /^[\w-_]+$/.test(e) ? "dxIcon" : !!/^\s?([\w-_]\s?)+$/.test(e) && "fontIcon")
                        };
                    t.getImageSourceType = r;
                    t.getImageContainer = function(e) {
                        switch (r(e)) {
                            case "image":
                                return (0, o.default)("<img>").attr("src", e).addClass(a);
                            case "fontIcon":
                                return (0, o.default)("<i>").addClass("".concat(a, " ").concat(e));
                            case "dxIcon":
                                return (0, o.default)("<i>").addClass("".concat(a, " ").concat(a, "-").concat(e));
                            case "svg":
                                return (0, o.default)("<i>").addClass("".concat(a, " ").concat("dx-svg-icon")).append(e);
                            default:
                                return null
                        }
                    }
                },
            78008:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/inflector.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.underscore = t.titleize = t.humanize = t.dasherize = t.captionize = t.camelize = void 0;
                    var i = n( /*! ./iterator */ 95479),
                        o = function(e) {
                            return null == e ? "" : String(e)
                        },
                        a = function(e) {
                            return o(e).charAt(0).toUpperCase() + e.substr(1)
                        },
                        r = function(e) {
                            return o(e).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
                        },
                        s = function(e) {
                            return (0, i.map)(r(e), (function(e) {
                                return e.toLowerCase()
                            })).join("-")
                        };
                    t.dasherize = s;
                    t.underscore = function(e) {
                        return s(e).replace(/-/g, "_")
                    };
                    t.camelize = function(e, t) {
                        return (0, i.map)(r(e), (function(e, n) {
                            return e = e.toLowerCase(), (t || n > 0) && (e = a(e)), e
                        })).join("")
                    };
                    t.humanize = function(e) {
                        return a(s(e).replace(/-/g, " "))
                    };
                    t.titleize = function(e) {
                        return (0, i.map)(r(e), (function(e) {
                            return a(e.toLowerCase())
                        })).join(" ")
                    };
                    var l = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
                    t.captionize = function(e) {
                        var t, n, i = [],
                            o = !1,
                            a = !1;
                        for (t = 0; t < e.length; t++) {
                            a = (n = e.charAt(t)) === n.toUpperCase() && "-" !== n && ")" !== n && "/" !== n || n in l, "_" === n || "." === n ? (n = " ", a = !0) : 0 === t ? (n = n.toUpperCase(), a = !0) : !o && a && i.length > 0 && i.push(" "), i.push(n), o = a
                        }
                        return i.join("")
                    }
                },
            95479:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/iterator.js ***!
                  \********************************************************************/
                function(e, t) {
                    t.reverseEach = t.map = t.each = void 0;
                    t.map = function(e, t) {
                        if (Array.isArray(e)) {
                            return e.map(t)
                        }
                        var n = [];
                        for (var i in e) {
                            n.push(t(e[i], i))
                        }
                        return n
                    };
                    t.each = function(e, t) {
                        if (e) {
                            if ("length" in e) {
                                for (var n = 0; n < e.length && !1 !== t.call(e[n], n, e[n]); n++) {}
                            } else {
                                for (var i in e) {
                                    if (!1 === t.call(e[i], i, e[i])) {
                                        break
                                    }
                                }
                            }
                            return e
                        }
                    };
                    t.reverseEach = function(e, t) {
                        if (e && "length" in e && 0 !== e.length) {
                            for (var n = e.length - 1; n >= 0 && !1 !== t.call(e[n], n, e[n]); n--) {}
                        }
                    }
                },
            88933:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/locker.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    t.default = function() {
                        var e = {},
                            t = function(t) {
                                return e[t] || 0
                            };
                        return {
                            obtain: function(n) {
                                e[n] = t(n) + 1
                            },
                            release: function(n) {
                                var i = t(n);
                                if (i < 1) {
                                    throw o.default.Error("E0014")
                                }
                                1 === i ? delete e[n] : e[n] = i - 1
                            },
                            locked: function(e) {
                                return t(e) > 0
                            }
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            60810:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/math.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.adjust = function(e, t) {
                        var n, r = a(t || 0) + 2,
                            s = e.toString().split("."),
                            l = e,
                            u = Math.abs(e),
                            d = (0, i.isExponential)(e),
                            c = u > 1 ? 10 : 0;
                        if (1 === s.length) {
                            return e
                        }
                        d || ((0, i.isExponential)(t) && (r = s[0].length + o(t)), e = (e = u) - Math.floor(e) + c);
                        if (r = "0.000300" !== 3e-4.toPrecision(3) && o(e) > 6 || r > 7 ? 15 : 7, !d && (n = parseFloat(e.toPrecision(r)).toString().split("."))[0] === c.toString()) {
                            return parseFloat(s[0] + "." + n[1])
                        }
                        return parseFloat(l.toPrecision(r))
                    }, t.fitIntoRange = void 0, t.getExponent = o, t.getExponentLength = function(e) {
                        var t, n = e.toString();
                        return (null === (t = n.split(".")[1]) || void 0 === t ? void 0 : t.length) || parseInt(n.split("e-")[1]) || 0
                    }, t.getPrecision = a, t.getRemainderByDivision = function(e, t, n) {
                        if (t === parseInt(t)) {
                            return e % t
                        }
                        var i = s(e / t, n);
                        return (i - parseInt(i)) * t
                    }, t.getRoot = r, t.inRange = void 0, t.roundFloatPart = s, t.sign = void 0, t.solveCubicEquation = function(e, t, n, i) {
                        var o = 1e-8;
                        if (Math.abs(e) < o) {
                            if (e = t, t = n, n = i, Math.abs(e) < o) {
                                return e = t, t = n, Math.abs(e) < o ? [] : [-t / e]
                            }
                            var a = t * t - 4 * e * n;
                            return Math.abs(a) < o ? [-t / (2 * e)] : a > 0 ? [(-t + Math.sqrt(a)) / (2 * e), (-t - Math.sqrt(a)) / (2 * e)] : []
                        }
                        var s, l, u = (3 * e * n - t * t) / (3 * e * e),
                            d = (2 * t * t * t - 9 * e * t * n + 27 * e * e * i) / (27 * e * e * e);
                        if (Math.abs(u) < o) {
                            s = [r(-d, 3)]
                        } else if (Math.abs(d) < o) {
                            s = [0].concat(u < 0 ? [Math.sqrt(-u), -Math.sqrt(-u)] : [])
                        } else {
                            var c = d * d / 4 + u * u * u / 27;
                            if (Math.abs(c) < o) {
                                s = [-1.5 * d / u, 3 * d / u]
                            } else if (c > 0) {
                                l = r(-d / 2 - Math.sqrt(c), 3), s = [l - u / (3 * l)]
                            } else {
                                l = 2 * Math.sqrt(-u / 3);
                                var h = Math.acos(3 * d / u / l) / 3,
                                    f = 2 * Math.PI / 3;
                                s = [l * Math.cos(h), l * Math.cos(h - f), l * Math.cos(h - 2 * f)]
                            }
                        }
                        for (var p = 0; p < s.length; p++) {
                            s[p] -= t / (3 * e)
                        }
                        return s
                    }, t.trunc = function(e) {
                        return Math.trunc ? Math.trunc(e) : e > 0 ? Math.floor(e) : Math.ceil(e)
                    };
                    var i = n( /*! ./type */ 35922);
                    t.sign = function(e) {
                        return 0 === e ? 0 : e / Math.abs(e)
                    };
                    t.fitIntoRange = function(e, t, n) {
                        var i = !t && 0 !== t,
                            o = !n && 0 !== n;
                        return i && (t = o ? e : Math.min(e, n)), o && (n = i ? e : Math.max(e, t)), Math.min(Math.max(e, t), n)
                    };

                    function o(e) {
                        return Math.abs(parseInt(e.toExponential().split("e")[1]))
                    }

                    function a(e) {
                        var t = e.toString();
                        if (t.indexOf(".") < 0) {
                            return 0
                        }
                        var n = t.split("."),
                            i = n[1].indexOf("e");
                        return i >= 0 ? i : n[1].length
                    }

                    function r(e, t) {
                        if (e < 0 && t % 2 != 1) {
                            return NaN
                        }
                        var n = Math.pow(Math.abs(e), 1 / t);
                        return t % 2 == 1 && e < 0 ? -n : n
                    }

                    function s(e) {
                        var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                        return parseFloat(e.toFixed(t))
                    }
                    t.inRange = function(e, t, n) {
                        return e >= t && e <= n
                    }
                },
            48013:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/object.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.orderEach = t.deepExtendArraySafe = t.clone = void 0;
                    var i, o = n( /*! ./type */ 35922),
                        a = (i = n( /*! ./variable_wrapper */ 26974)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function() {
                        function e() {}
                        return function(t) {
                            return e.prototype = t, new e
                        }
                    }();
                    t.clone = r;
                    t.orderEach = function(e, t) {
                        var n, i, a = [];
                        for (n in e) {
                            Object.prototype.hasOwnProperty.call(e, n) && a.push(n)
                        }
                        for (a.sort((function(e, t) {
                                var n = (0, o.isNumeric)(e),
                                    i = (0, o.isNumeric)(t);
                                return n && i ? e - t : n && !i ? -1 : !n && i ? 1 : e < t ? -1 : e > t ? 1 : 0
                            })), i = 0; i < a.length; i++) {
                            t(n = a[i], e[n])
                        }
                    };
                    var s = function(e, t, n, i) {
                        !i && a.default.isWrapped(e[t]) ? a.default.assign(e[t], n) : e[t] = n
                    };
                    t.deepExtendArraySafe = function e(t, n, i, a) {
                        var r, l;
                        for (var u in n) {
                            if (r = t[u], l = n[u], "__proto__" !== u && "constructor" !== u && t !== l) {
                                if ((0, o.isPlainObject)(l)) {
                                    l = e((i ? (0, o.isObject)(r) : (0, o.isPlainObject)(r)) ? r : {}, l, i, a)
                                }
                                void 0 !== l && r !== l && s(t, u, l, a)
                            }
                        }
                        return t
                    }
                },
            37518:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/position.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.getDefaultAlignment = t.getBoundingRect = void 0;
                    var i, o = (i = n( /*! ../config */ 80209)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ../utils/type */ 35922);
                    t.getDefaultAlignment = function(e) {
                        return (null != e ? e : (0, o.default)().rtlEnabled) ? "right" : "left"
                    };
                    t.getBoundingRect = function(e) {
                        return (0, a.isWindow)(e) ? {
                            width: e.outerWidth,
                            height: e.outerHeight
                        } : e.getBoundingClientRect()
                    }
                },
            9321:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/public_component.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.attachInstanceToElement = function(e, t, n) {
                        var a = (0, i.data)(e.get(0)),
                            r = c(t.constructor);
                        a[r] = t, n && o.default.one(e, s.removeEvent, (function() {
                            n.call(t)
                        }));
                        a.dxComponents || (a.dxComponents = []);
                        a.dxComponents.push(r)
                    }, t.getInstanceByElement = function(e, t) {
                        var n = c(t);
                        return (0, i.data)(e.get(0), n)
                    }, t.name = void 0;
                    var i = n( /*! ../../core/element_data */ 97906),
                        o = l(n( /*! ../../events/core/events_engine */ 55994)),
                        a = l(n( /*! ../polyfills/weak_map */ 10126)),
                        r = n( /*! ./type */ 35922),
                        s = n( /*! ../remove_event */ 37819);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = new a.default,
                        d = 0,
                        c = function(e, t) {
                            if (!(0, r.isDefined)(t)) {
                                if (!u.has(e)) {
                                    var n = "dxPrivateComponent" + d++;
                                    return u.set(e, n), n
                                }
                                return u.get(e)
                            }
                            u.set(e, t)
                        };
                    t.name = c
                },
            59504:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/queue.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.create = r, t.enqueue = void 0;
                    var i, o = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ../../core/utils/deferred */ 62754);

                    function r(e) {
                        var t = [],
                            n = !1;

                        function i() {
                            for (; t.length;) {
                                n = !0;
                                var e = t.shift()();
                                if (void 0 !== e) {
                                    if (e.then) {
                                        return void(0, a.when)(e).always(i)
                                    }
                                    throw o.default.Error("E0015")
                                }
                            }
                            n = !1
                        }
                        return {
                            add: function(o, a) {
                                e ? (t[0] && a && a(t[0]), t = [o]) : t.push(o), n || i()
                            },
                            busy: function() {
                                return n
                            }
                        }
                    }
                    var s = r().add;
                    t.enqueue = s
                },
            24311:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/ready_callbacks.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../dom_adapter */ 73349)),
                        o = s(n( /*! ./dependency_injector */ 20476)),
                        a = n( /*! ./window */ 58201),
                        r = s(n( /*! ./call_once */ 39618));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = [],
                        u = (0, r.default)((function() {
                            var e = i.default.listen(i.default.getDocument(), "DOMContentLoaded", (function() {
                                d.fire(), e()
                            }))
                        })),
                        d = {
                            add: function(e) {
                                var t = (0, a.hasWindow)();
                                t && "loading" !== i.default.getReadyState() ? e() : (l.push(e), t && u())
                            },
                            fire: function() {
                                l.forEach((function(e) {
                                    return e()
                                })), l = []
                            }
                        },
                        c = (0, o.default)(d);
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            55814:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/resize_callbacks.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./window */ 58201),
                        o = l(n( /*! ../dom_adapter */ 73349)),
                        a = l(n( /*! ./callbacks */ 44504)),
                        r = l(n( /*! ./ready_callbacks */ 24311)),
                        s = l(n( /*! ./call_once */ 39618));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = function() {
                            var e, t = (0, a.default)(),
                                n = t.add,
                                l = t.remove;
                            if (!(0, i.hasWindow)()) {
                                return t
                            }
                            var u, d = function() {
                                    var e = (0, i.getWindow)();
                                    return {
                                        width: e.innerWidth,
                                        height: e.innerHeight
                                    }
                                },
                                c = function() {
                                    var n, i = d();
                                    i.width === e.width && i.height === e.height || (i.width === e.width && (n = "height"), i.height === e.height && (n = "width"), e = i, t.fire(n))
                                },
                                h = (0, s.default)((function() {
                                    e = d()
                                }));
                            return t.add = function() {
                                var e = n.apply(t, arguments);
                                return h(), r.default.add((function() {
                                    !u && t.has() && (u = o.default.listen((0, i.getWindow)(), "resize", c))
                                })), e
                            }, t.remove = function() {
                                var e = l.apply(t, arguments);
                                return !t.has() && u && (u(), u = void 0), e
                            }, t
                        }(),
                        d = u;
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            11071:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/scroll_rtl_behavior.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = o(n( /*! ../dom_adapter */ 73349));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var a = (0, o(n( /*! ./call_once */ 39618)).default)((function() {
                        var e = i.default.getDocument();
                        e.body.insertAdjacentHTML("beforeend", "<div style='direction: rtl;\n       position: absolute; left: 0; top: -1; overflow: hidden; width: 1px;\n       height: 1px;'><div style='width: 2px; height: 1px;'></div></div>");
                        var t = e.body.lastElementChild,
                            n = t.scrollLeft > 0;
                        t.scrollLeft = -1;
                        var o = t.scrollLeft < 0,
                            a = {
                                decreasing: o || n,
                                positive: !o
                            };
                        return e.body.removeChild(t), a
                    }));
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            49601:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/selection_filter.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.SelectionFilterCreator = void 0;
                    var i = n( /*! ./common */ 20576),
                        o = n( /*! ./type */ 35922);
                    t.SelectionFilterCreator = function(e, t) {
                        var n;
                        this.getLocalFilter = function(e, t, n, o) {
                            return t = void 0 === t ? i.equalByValue : t, a.bind(this, t, e, n, o)
                        }, this.getExpr = function(n) {
                            var i;
                            if (n) {
                                return e.forEach((function(e, a) {
                                    var s;
                                    i = i || [], a > 0 && i.push(t ? "and" : "or"), s = (0, o.isString)(n) ? r(n, e) : function(e, n) {
                                        for (var i = [], o = 0, a = e.length; o < a; o++) {
                                            var s = e[o],
                                                l = r(s, n && n[s]);
                                            if (!l) {
                                                break
                                            }
                                            o > 0 && i.push(t ? "or" : "and"), i.push(l)
                                        }
                                        return i
                                    }(n, e), i.push(s)
                                })), i && 1 === i.length && (i = i[0]), i
                            }
                        }, this.getCombinedFilter = function(e, n) {
                            var i = this.getExpr(e),
                                o = i;
                            return t && n && (i ? ((o = []).push(i), o.push(n)) : o = n), o
                        };

                        function a(a, r, s, l, u) {
                            var d, c, h = r(u);
                            if (!s && (d = (0, i.getKeyHash)(h), !(0, o.isObject)(d))) {
                                var f = function(e) {
                                    if (!n) {
                                        n = {};
                                        for (var t = 0; t < e.length; t++) {
                                            n[(0, i.getKeyHash)(e[t])] = !0
                                        }
                                    }
                                    return n
                                }(function(e, t, n) {
                                    return Array.isArray(n) ? e.map((function(e) {
                                        return t(e)
                                    })) : e
                                }(e, r, l));
                                return f[d] ? !t : !!t
                            }
                            for (c = 0; c < e.length; c++) {
                                if (a(e[c], h)) {
                                    return !t
                                }
                            }
                            return !!t
                        }

                        function r(e, n) {
                            if (void 0 !== n) {
                                return [e, t ? "<>" : "=", n]
                            }
                        }
                    }
                },
            58664:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/size.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.setWidth = t.setOuterWidth = t.setOuterHeight = t.setInnerWidth = t.setInnerHeight = t.setHeight = t.parseHeight = t.implementationsMap = t.getWindowByElement = t.getWidth = t.getVisibleHeight = t.getVerticalOffsets = t.getSize = t.getOuterWidth = t.getOuterHeight = t.getOffset = t.getInnerWidth = t.getInnerHeight = t.getHeight = t.getElementBoxParams = t.addOffsetToMinHeight = t.addOffsetToMaxHeight = void 0;
                    var i, o = n( /*! ../../core/utils/window */ 58201),
                        a = (i = n( /*! ../../core/dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        r = n( /*! ../utils/type */ 35922);
                    var s = (0, o.getWindow)(),
                        l = ["auto", "none", "inherit", "initial"],
                        u = function(e, t) {
                            var n = 0;
                            return t.forEach((function(t) {
                                n += parseFloat(e[t]) || 0
                            })), n
                        },
                        d = function(e, t) {
                            var n = "width" === e ? "Left" : "Top",
                                i = "width" === e ? "Right" : "Bottom";
                            return {
                                padding: u(t, ["padding" + n, "padding" + i]),
                                border: u(t, ["border" + n + "Width", "border" + i + "Width"]),
                                margin: u(t, ["margin" + n, "margin" + i])
                            }
                        };
                    t.getElementBoxParams = d;
                    var c = function(e) {
                            var t, n = (null == e || null === (t = e.ownerDocument) || void 0 === t ? void 0 : t.defaultView) || s;
                            return n.getComputedStyle && n.getComputedStyle(e)
                        },
                        h = function(e, t, n, i) {
                            var o;
                            return (null == t ? void 0 : t[n]) || (null === (o = e.style) || void 0 === o ? void 0 : o[n]) || i
                        },
                        f = {
                            content: 0,
                            padding: 1,
                            border: 2,
                            margin: 3,
                            "content-box": 0,
                            "border-box": 2
                        },
                        p = {
                            width: ["left", "right"],
                            height: ["top", "bottom"]
                        };

                    function g(e, t, n, i) {
                        var o = function(e, t, n) {
                                return parseFloat(h(e, t, n, "0")) || 0
                            },
                            a = "border" === n ? "-width" : "";
                        return o(e, i, "".concat(n, "-").concat(p[t][0]).concat(a)) + o(e, i, "".concat(n, "-").concat(p[t][1]).concat(a))
                    }
                    var m = function(e, t, n) {
                        var i = "width" === t ? "offsetWidth" : "offsetHeight",
                            o = c(e),
                            a = h(e, o, t);
                        "" !== a && "auto" !== a || (a = e[i]), a = parseFloat(a) || 0;
                        var r = h(e, o, "boxSizing", "content-box"),
                            s = f[n || r],
                            l = f[r];
                        if (void 0 === s || void 0 === l) {
                            throw new Error
                        }
                        if (l === s) {
                            return a
                        }
                        var u = Math.sign(s - l),
                            d = !1,
                            p = !1,
                            m = !1,
                            _ = !1;
                        1 === u && (s += 1, l += 1);
                        for (var v = l; v !== s; v += u) {
                            switch (v) {
                                case f.content:
                                    break;
                                case f.padding:
                                    d = u * g(e, t, "padding", o);
                                    break;
                                case f.border:
                                    p = u * g(e, t, "border", o);
                                    break;
                                case f.margin:
                                    m = u * g(e, t, "margin", o)
                            }
                        }
                        if (d || p) {
                            var y = (!1 === d ? u * g(e, t, "padding", o) : d) + (!1 === p ? u * g(e, t, "border", o) : p);
                            _ = u * Math.max(0, Math.floor(e[i] - a - u * y)) || 0
                        }
                        return a + m + d + p + _
                    };
                    t.getSize = m;
                    var _ = function(e, t) {
                        return e.indexOf("px") > 0 ? e = parseInt(e.replace("px", "")) : e.indexOf("%") > 0 ? e = parseInt(e.replace("%", "")) * function(e) {
                            return (0, r.isWindow)(e) ? e.innerHeight : e.offsetHeight
                        }(t) / 100 : isNaN(e) || (e = parseInt(e)), e
                    };
                    t.parseHeight = _;
                    var v = function(e, t, n) {
                        return e ? l.indexOf(e) > -1 ? t ? null : e : ((0, r.isString)(e) && (e = _(e, n)), (0, r.isNumeric)(e) ? Math.max(0, e + t) : "calc(" + e + (t < 0 ? " - " : " ") + Math.abs(t) + "px)") : null
                    };
                    t.addOffsetToMaxHeight = function(e, t, n) {
                        var i = v(e, t, n);
                        return null !== i ? i : "none"
                    };
                    t.addOffsetToMinHeight = function(e, t, n) {
                        var i = v(e, t, n);
                        return null !== i ? i : 0
                    };
                    t.getVerticalOffsets = function(e, t) {
                        if (!e) {
                            return 0
                        }
                        var n = d("height", s.getComputedStyle(e));
                        return n.padding + n.border + (t ? n.margin : 0)
                    };
                    t.getVisibleHeight = function(e) {
                        if (e) {
                            var t = e.getBoundingClientRect();
                            if (t.height) {
                                return t.height
                            }
                        }
                        return 0
                    };
                    var y = {
                        getWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["width"].concat(t))
                        },
                        setWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["width"].concat(t))
                        },
                        getHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["height"].concat(t))
                        },
                        setHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["height"].concat(t))
                        },
                        getOuterWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["outerWidth"].concat(t))
                        },
                        setOuterWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["outerWidth"].concat(t))
                        },
                        getOuterHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["outerHeight"].concat(t))
                        },
                        setOuterHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["outerHeight"].concat(t))
                        },
                        getInnerWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["innerWidth"].concat(t))
                        },
                        setInnerWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["innerWidth"].concat(t))
                        },
                        getInnerHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["innerHeight"].concat(t))
                        },
                        setInnerHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return b.apply(void 0, ["innerHeight"].concat(t))
                        }
                    };

                    function b(e, t, n) {
                        return 2 === arguments.length ? x(t, e) : x(t, e, n)
                    }
                    t.implementationsMap = y;
                    t.getWidth = function(e) {
                        return y.getWidth(e)
                    };
                    t.setWidth = function(e, t) {
                        return y.setWidth(e, t)
                    };
                    t.getHeight = function(e) {
                        return y.getHeight(e)
                    };
                    t.setHeight = function(e, t) {
                        return y.setHeight(e, t)
                    };
                    t.getOuterWidth = function(e, t) {
                        return y.getOuterWidth(e, t || !1)
                    };
                    t.setOuterWidth = function(e, t) {
                        return y.setOuterWidth(e, t)
                    };
                    t.getOuterHeight = function(e, t) {
                        return y.getOuterHeight(e, t || !1)
                    };
                    t.setOuterHeight = function(e, t) {
                        return y.setOuterHeight(e, t)
                    };
                    t.getInnerWidth = function(e) {
                        return y.getInnerWidth(e)
                    };
                    t.setInnerWidth = function(e, t) {
                        return y.setInnerWidth(e, t)
                    };
                    t.getInnerHeight = function(e) {
                        return y.getInnerHeight(e)
                    };
                    t.setInnerHeight = function(e, t) {
                        return y.setInnerHeight(e, t)
                    };
                    var x = function e(t, n, i) {
                            var o = n.toLowerCase().indexOf("width") >= 0 ? "Width" : "Height",
                                s = o.toLowerCase(),
                                l = 0 === n.indexOf("outer"),
                                u = 0 === n.indexOf("inner"),
                                h = 2 === arguments.length || "boolean" == typeof i;
                            if ((0, r.isRenderer)(t)) {
                                if (t.length > 1 && !h) {
                                    for (var f = 0; f < t.length; f++) {
                                        e(t[f], n, i)
                                    }
                                    return
                                }
                                t = t[0]
                            }
                            if (t) {
                                if ((0, r.isWindow)(t)) {
                                    return l ? t["inner" + o] : a.default.getDocumentElement()["client" + o]
                                }
                                if (a.default.isDocument(t)) {
                                    var p = a.default.getDocumentElement(),
                                        g = a.default.getBody();
                                    return Math.max(g["scroll" + o], g["offset" + o], p["scroll" + o], p["offset" + o], p["client" + o])
                                }
                                if (h) {
                                    var _ = "content";
                                    return l && (_ = i ? "margin" : "border"), u && (_ = "padding"), m(t, s, _)
                                }
                                if ((0, r.isNumeric)(i)) {
                                    var v = c(t),
                                        y = d(s, v),
                                        b = "border-box" === v.boxSizing;
                                    i = Number(i), l ? i -= b ? 0 : y.border + y.padding : u ? i += b ? y.border : -y.padding : b && (i += y.border + y.padding)
                                }
                                return i += (0, r.isNumeric)(i) ? "px" : "", a.default.setStyle(t, s, i), null
                            }
                        },
                        w = function(e) {
                            return (0, r.isWindow)(e) ? e : e.defaultView
                        };
                    t.getWindowByElement = w;
                    t.getOffset = function(e) {
                        if (!e.getClientRects().length) {
                            return {
                                top: 0,
                                left: 0
                            }
                        }
                        var t = e.getBoundingClientRect(),
                            n = w(e.ownerDocument),
                            i = e.ownerDocument.documentElement;
                        return {
                            top: t.top + n.pageYOffset - i.clientTop,
                            left: t.left + n.pageXOffset - i.clientLeft
                        }
                    }
                },
            36613:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/storage.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.sessionStorage = void 0;
                    var i = (0, n( /*! ../../core/utils/window */ 58201).getWindow)();
                    t.sessionStorage = function() {
                        var e;
                        try {
                            e = i.sessionStorage
                        } catch (e) {}
                        return e
                    }
                },
            68752:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/string.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.encodeHtml = void 0, t.format = function(e) {
                        for (var t = arguments.length, n = new Array(t > 1 ? t - 1 : 0), o = 1; o < t; o++) {
                            n[o - 1] = arguments[o]
                        }
                        if ((0, i.isFunction)(e)) {
                            return e.apply(void 0, n)
                        }
                        return n.forEach((function(t, n) {
                            (0, i.isString)(t) && (t = t.replace(/\$/g, "$$$$"));
                            var o = new RegExp("\\{" + n + "\\}", "gm");
                            e = e.replace(o, t)
                        })), e
                    }, t.replaceAll = t.quadToObject = t.isEmpty = void 0;
                    var i = n( /*! ./type */ 35922);

                    function o(e) {
                        return o = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, o(e)
                    }
                    var a, r = (a = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")], function(e) {
                        return String(e).replace(a[0], "&amp;").replace(a[1], "&quot;").replace(a[2], "&#39;").replace(a[3], "&lt;").replace(a[4], "&gt;")
                    });
                    t.encodeHtml = r;
                    t.quadToObject = function(e) {
                        var t = function(e) {
                                switch (o(e)) {
                                    case "string":
                                        return e.split(/\s+/, 4);
                                    case "object":
                                        return [e.x || e.h || e.left, e.y || e.v || e.top, e.x || e.h || e.right, e.y || e.v || e.bottom];
                                    case "number":
                                        return [e];
                                    default:
                                        return e
                                }
                            }(e),
                            n = parseInt(t && t[0], 10),
                            i = parseInt(t && t[1], 10),
                            a = parseInt(t && t[2], 10),
                            r = parseInt(t && t[3], 10);
                        return isFinite(n) || (n = 0), isFinite(i) || (i = n), isFinite(a) || (a = n), isFinite(r) || (r = i), {
                            top: i,
                            right: a,
                            bottom: r,
                            left: n
                        }
                    };
                    t.replaceAll = function(e, t, n) {
                        return e.replace(new RegExp("(" + (t + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1") + ")", "gi"), n)
                    };
                    var l, u = (l = /\s/g, function(e) {
                        return !e || !e.replace(l, "")
                    });
                    t.isEmpty = u
                },
            2146:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/stubs.js ***!
                  \*****************************************************************/
                function(e, t) {
                    t.stubComponent = function(e) {
                        return function() {
                            function t() {
                                throw new Error("Module '".concat(e, "' not found"))
                            }
                            return t.getInstance = function() {}, t
                        }()
                    }
                },
            80968:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/style.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.stylePropPrefix = t.styleProp = t.setWidth = t.setHeight = t.parsePixelValue = t.normalizeStyleProp = void 0;
                    var i = n( /*! ./inflector */ 78008),
                        o = s(n( /*! ./call_once */ 39618)),
                        a = n( /*! ./type */ 35922),
                        r = s(n( /*! ../dom_adapter */ 73349));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = ["", "Webkit", "Moz", "O", "Ms"],
                        u = {
                            "": "",
                            Webkit: "-webkit-",
                            Moz: "-moz-",
                            O: "-o-",
                            ms: "-ms-"
                        },
                        d = (0, o.default)((function() {
                            return r.default.createElement("dx").style
                        }));
                    t.styleProp = function(e) {
                        if (e in d()) {
                            return e
                        }
                        var t = e;
                        e = e.charAt(0).toUpperCase() + e.substr(1);
                        for (var n = 1; n < l.length; n++) {
                            var i = l[n].toLowerCase() + e;
                            if (i in d()) {
                                return i
                            }
                        }
                        return t
                    };
                    t.stylePropPrefix = function(e) {
                        return function(e, t) {
                            var n;
                            e = (0, i.camelize)(e, !0);
                            for (var o = 0, a = l.length; o < a; o++) {
                                var r = l[o],
                                    s = r + e;
                                if (void 0 === (n = t((0, i.camelize)(s), r)) && (n = t(s, r)), void 0 !== n) {
                                    break
                                }
                            }
                            return n || ""
                        }(e, (function(e, t) {
                            if (e in d()) {
                                return u[t]
                            }
                        }))
                    };
                    var c = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
                    t.parsePixelValue = function(e) {
                        return (0, a.isNumeric)(e) ? e : (0, a.isString)(e) ? Number(e.replace("px", "")) : NaN
                    };
                    t.normalizeStyleProp = function(e, t) {
                        return (0, a.isNumeric)(t) && -1 === c.indexOf(e) && (t += "px"), t
                    };
                    var h = function(e, t, n) {
                        if (e) {
                            n = (0, a.isNumeric)(n) ? n += "px" : n;
                            for (var i = 0; i < e.length; ++i) {
                                e[i].style[t] = n
                            }
                        }
                    };
                    t.setWidth = function(e, t) {
                        h(e, "width", t)
                    };
                    t.setHeight = function(e, t) {
                        h(e, "height", t)
                    }
                },
            60137:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/support.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.pointerEvents = t.nativeScrolling = t.inputType = t.animation = void 0, Object.defineProperty(t, "styleProp", {
                        enumerable: !0,
                        get: function() {
                            return l.styleProp
                        }
                    }), Object.defineProperty(t, "stylePropPrefix", {
                        enumerable: !0,
                        get: function() {
                            return l.stylePropPrefix
                        }
                    }), t.transitionEndEventName = t.transition = t.touchEvents = t.touch = t.supportProp = void 0;
                    var i = n( /*! ./array */ 89386),
                        o = u(n( /*! ../dom_adapter */ 73349)),
                        a = u(n( /*! ./call_once */ 39618)),
                        r = n( /*! ./window */ 58201),
                        s = u(n( /*! ../devices */ 20530)),
                        l = n( /*! ./style */ 80968);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = (0, r.getNavigator)().maxTouchPoints,
                        c = {
                            webkitTransition: "webkitTransitionEnd",
                            MozTransition: "transitionend",
                            OTransition: "oTransitionEnd",
                            transition: "transitionend"
                        },
                        h = function(e) {
                            return !!(0, l.styleProp)(e)
                        };
                    t.supportProp = h;
                    t.inputType = function(e) {
                        if ("text" === e) {
                            return !0
                        }
                        var t = o.default.createElement("input");
                        try {
                            return t.setAttribute("type", e), t.value = "wrongValue", !t.value
                        } catch (e) {
                            return !1
                        }
                    };
                    var f = function(e, t) {
                        return (e("ontouchstart") || !!t) && !e("callPhantom")
                    }(r.hasProperty, d);
                    t.touchEvents = f;
                    var p = (0, r.hasProperty)("PointerEvent");
                    t.pointerEvents = p;
                    var g = f || p && !!d;
                    t.touch = g;
                    var m = (0, a.default)((function() {
                        return h("transition")
                    }));
                    t.transition = m;
                    var _ = (0, a.default)((function() {
                        return c[(0, l.styleProp)("transition")]
                    }));
                    t.transitionEndEventName = _;
                    var v = (0, a.default)((function() {
                        return h("animation")
                    }));
                    t.animation = v;
                    var y, b, x, w, C = (y = s.default.real(), b = y.platform, x = y.version, w = y.mac, !(x && x[0] < 4 && "android" === b) && (0, i.inArray)(b, ["ios", "android"]) > -1 || w);
                    t.nativeScrolling = C
                },
            19155:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/svg.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.HIDDEN_FOR_EXPORT = void 0, t.getSvgElement = function(e) {
                        return i.default.isNode(e) ? e : (new s.DOMParser).parseFromString(e, "image/svg+xml").childNodes[0]
                    }, t.getSvgMarkup = function(e, t) {
                        return function(e) {
                            var t = !0; - 1 === e.indexOf("xmlns:xlink") && (e = e.replace("<svg", '<svg xmlns:xlink="http://www.w3.org/1999/xlink"'));
                            return (e = e.replace(/xmlns="[\s\S]*?"/gi, (function(e) {
                                return t ? (t = !1, e) : ""
                            }))).replace(/xmlns:NS1="[\s\S]*?"/gi, "").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi, 'xmlns:xlink="$1"')
                        }((n = function(e, t) {
                            var n = i.default.createElement("div"),
                                o = e.cloneNode(!0);
                            return t && (0, a.default)(o).css("backgroundColor", t), n.appendChild(o), n.innerHTML
                        }(e, t), n.replace(/&quot;/gi, "&#34;").replace(/&amp;/gi, "&#38;").replace(/&apos;/gi, "&#39;").replace(/&lt;/gi, "&#60;").replace(/&gt;/gi, "&#62;").replace(/&nbsp;/gi, "&#160;").replace(/&shy;/gi, "&#173;")));
                        var n
                    };
                    var i = r(n( /*! ../../core/dom_adapter */ 73349)),
                        o = n( /*! ./window */ 58201),
                        a = r(n( /*! ../../core/renderer */ 68374));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = (0, o.getWindow)();
                    t.HIDDEN_FOR_EXPORT = "hidden-for-export"
                },
            69697:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/template_manager.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.validateTemplateSource = t.templateKey = t.suitableTemplatesByName = t.getNormalizedTemplateArgs = t.findTemplates = t.defaultCreateElement = t.addOneRenderedCall = t.acquireTemplate = t.acquireIntegrationTemplate = void 0;
                    var i = m(n( /*! ../config */ 80209)),
                        o = m(n( /*! ../devices */ 20530)),
                        a = m(n( /*! ../errors */ 17381)),
                        r = m(n( /*! ../renderer */ 68374)),
                        s = n( /*! ../templates/child_default_template */ 91627),
                        l = n( /*! ../templates/empty_template */ 10688),
                        u = n( /*! ../templates/template */ 9545),
                        d = n( /*! ../templates/template_base */ 81033),
                        c = n( /*! ./array */ 89386),
                        h = n( /*! ./common */ 20576),
                        f = n( /*! ./dom */ 3532),
                        p = n( /*! ./extend */ 13306),
                        g = n( /*! ./type */ 35922);

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.findTemplates = function(e, t) {
                        var n = "data-options",
                            o = (0, r.default)(e).contents().filter("[".concat(n, '*="').concat(t, '"]'));
                        return [].slice.call(o).map((function(e) {
                            var o = (0, r.default)(e).attr(n) || "";
                            return {
                                element: e,
                                options: (0, i.default)().optionsParser(o)[t]
                            }
                        })).filter((function(e) {
                            return !!e.options
                        }))
                    };
                    t.suitableTemplatesByName = function(e) {
                        var t = (0, c.groupBy)(e, (function(e) {
                            return e.options.name
                        }));
                        if (t[void 0]) {
                            throw a.default.Error("E0023")
                        }
                        var n = {};
                        return Object.keys(t).forEach((function(e) {
                            var i, a = null === (i = (0, h.findBestMatches)(o.default.current(), t[e], (function(e) {
                                return e.options
                            }))[0]) || void 0 === i ? void 0 : i.element;
                            a && (n[e] = a)
                        })), n
                    };
                    var _ = function(e) {
                        var t = e.render.bind(e);
                        return (0, p.extend)({}, e, {
                            render: function(e) {
                                var n = t(e);
                                return e && e.onRendered && e.onRendered(), n
                            }
                        })
                    };
                    t.addOneRenderedCall = _;
                    t.getNormalizedTemplateArgs = function(e) {
                        var t = [];
                        return "model" in e && t.push(e.model), "index" in e && t.push(e.index), t.push(e.container), t
                    };
                    t.validateTemplateSource = function(e) {
                        return "string" == typeof e ? (0, f.normalizeTemplateElement)(e) : e
                    };
                    t.templateKey = function(e) {
                        return (0, g.isRenderer)(e) && e[0] || e
                    };
                    t.defaultCreateElement = function(e) {
                        return new u.Template(e)
                    };
                    var v = function(e, t, n, i) {
                        var o = null;
                        return i && -1 !== i.indexOf(e) || !(o = t[e]) || o instanceof d.TemplateBase || n || (o = _(o)), o
                    };
                    t.acquireIntegrationTemplate = v;
                    t.acquireTemplate = function(e, t, n, i, o, a) {
                        return null == e ? new l.EmptyTemplate : e instanceof s.ChildDefaultTemplate ? a[e.name] : e instanceof d.TemplateBase ? e : (0, g.isFunction)(e.render) && !(0, g.isRenderer)(e) ? i ? e : _(e) : e.nodeType || (0, g.isRenderer)(e) ? t((0, r.default)(e)) : v(e, n, i, o) || a[e] || t(e)
                    }
                },
            35922:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/type.js ***!
                  \****************************************************************/
                function(e, t) {
                    function n(e) {
                        return n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, n(e)
                    }
                    t.type = t.isWindow = t.isString = t.isRenderer = t.isPromise = t.isPrimitive = t.isPlainObject = t.isObject = t.isNumeric = t.isFunction = t.isExponential = t.isEvent = t.isEmptyObject = t.isDefined = t.isDeferred = t.isDate = t.isBoolean = void 0;
                    var i = {
                            "[object Array]": "array",
                            "[object Date]": "date",
                            "[object Object]": "object",
                            "[object String]": "string",
                            "[object Null]": "null"
                        },
                        o = function(e) {
                            var t = Object.prototype.toString.call(e);
                            return "object" === n(e) ? i[t] || "object" : n(e)
                        };
                    t.type = o;
                    t.isBoolean = function(e) {
                        return "boolean" == typeof e
                    };
                    t.isExponential = function(e) {
                        return r(e) && -1 !== e.toString().indexOf("e")
                    };
                    t.isDate = function(e) {
                        return "date" === o(e)
                    };
                    t.isDefined = function(e) {
                        return null != e
                    };
                    var a = function(e) {
                        return "function" == typeof e
                    };
                    t.isFunction = a;
                    t.isString = function(e) {
                        return "string" == typeof e
                    };
                    var r = function(e) {
                        return "number" == typeof e && isFinite(e) || !isNaN(e - parseFloat(e))
                    };
                    t.isNumeric = r;
                    t.isObject = function(e) {
                        return "object" === o(e)
                    };
                    t.isEmptyObject = function(e) {
                        var t;
                        for (t in e) {
                            return !1
                        }
                        return !0
                    };
                    t.isPlainObject = function(e) {
                        if (!e || "[object Object]" !== Object.prototype.toString.call(e)) {
                            return !1
                        }
                        var t = Object.getPrototypeOf(e),
                            n = Object.hasOwnProperty.call(t, "constructor") && t.constructor;
                        return "function" == typeof n && Object.toString.call(n) === Object.toString.call(Object)
                    };
                    t.isPrimitive = function(e) {
                        return -1 === ["object", "array", "function"].indexOf(o(e))
                    };
                    t.isWindow = function(e) {
                        return null != e && e === e.window
                    };
                    t.isRenderer = function(e) {
                        return !(!e || !e.jquery && !e.dxRenderer)
                    };
                    t.isPromise = function(e) {
                        return !!e && a(e.then)
                    };
                    t.isDeferred = function(e) {
                        return !!e && a(e.done) && a(e.fail)
                    };
                    t.isEvent = function(e) {
                        return !(!e || !e.preventDefault)
                    }
                },
            26974:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/variable_wrapper.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ./console */ 30869);
                    var a = (0, ((i = n( /*! ./dependency_injector */ 20476)) && i.__esModule ? i : {
                        default: i
                    }).default)({
                        isWrapped: function() {
                            return !1
                        },
                        isWritableWrapped: function() {
                            return !1
                        },
                        wrap: function(e) {
                            return e
                        },
                        unwrap: function(e) {
                            return e
                        },
                        assign: function() {
                            o.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
                        }
                    });
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            58020:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/version.js ***!
                  \*******************************************************************/
                function(e, t) {
                    t.compare = function(e, t, n) {
                        function i(e) {
                            return "string" == typeof e ? e.split(".") : "number" == typeof e ? [e] : e
                        }
                        e = i(e), t = i(t);
                        var o = Math.max(e.length, t.length);
                        isFinite(n) && (o = Math.min(o, n));
                        for (var a = 0; a < o; a++) {
                            var r = parseInt(e[a] || 0, 10),
                                s = parseInt(t[a] || 0, 10);
                            if (r < s) {
                                return -1
                            }
                            if (r > s) {
                                return 1
                            }
                        }
                        return 0
                    }
                },
            77695:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/view_port.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.changeCallback = void 0, t.originalViewPort = function() {
                        return d
                    }, t.value = void 0;
                    var i = r(n( /*! ../renderer */ 68374)),
                        o = r(n( /*! ./ready_callbacks */ 24311)),
                        a = r(n( /*! ./callbacks */ 44504));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = o.default.add,
                        l = (0, a.default)();
                    t.changeCallback = l;
                    var u, d = (0, i.default)(),
                        c = function(e) {
                            if (!arguments.length) {
                                return u
                            }
                            var t = (0, i.default)(e);
                            d = t;
                            var n = !!t.length,
                                o = c();
                            u = n ? t : (0, i.default)("body"), l.fire(n ? c() : (0, i.default)(), o)
                        };
                    t.value = c, s((function() {
                        c(".dx-viewport")
                    }))
                },
            58201:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/window.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.setWindow = t.hasWindow = t.hasProperty = t.getWindow = t.getNavigator = t.getCurrentScreenFactor = t.defaultScreenFactorFunc = void 0;
                    var i, o = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                        default: i
                    };
                    var a = "undefined" != typeof window,
                        r = function() {
                            return a
                        };
                    t.hasWindow = r;
                    var s = r() ? window : void 0;
                    s || ((s = {}).window = s);
                    t.getWindow = function() {
                        return s
                    };
                    t.setWindow = function(e, t) {
                        a = void 0 === t ? "undefined" != typeof window && window === e : t, s = e
                    };
                    t.hasProperty = function(e) {
                        return r() && e in s
                    };
                    var l = function(e) {
                        return e < 768 ? "xs" : e < 992 ? "sm" : e < 1200 ? "md" : "lg"
                    };
                    t.defaultScreenFactorFunc = l;
                    t.getCurrentScreenFactor = function(e) {
                        return (e || l)(o.default.getDocumentElement().clientWidth)
                    };
                    t.getNavigator = function() {
                        return r() ? s.navigator : {
                            userAgent: ""
                        }
                    }
                },
            36739:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/version.js ***!
                  \*************************************************************/
                function(e, t) {
                    t.version = void 0;
                    t.version = "21.2.3"
                },
            67403:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/abstract_store.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = h(n( /*! ../core/class */ 38377)),
                        o = n( /*! ../core/events_strategy */ 80566),
                        a = n( /*! ../core/utils/iterator */ 95479),
                        r = n( /*! ./errors */ 18438),
                        s = n( /*! ./utils */ 16454),
                        l = n( /*! ../core/utils/data */ 47617),
                        u = h(n( /*! ./store_helper */ 99236)),
                        d = n( /*! ../core/utils/deferred */ 62754),
                        c = n( /*! ../core/utils/common */ 20576);

                    function h(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function p(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var g, m = i.default.abstract,
                        _ = u.default.queryByOptions,
                        v = {},
                        y = i.default.inherit({
                            ctor: function(e) {
                                var t = this;
                                e = e || {}, this._eventsStrategy = new o.EventsStrategy(this), (0, a.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], (function(n, i) {
                                    i in e && t.on(i.slice(2).toLowerCase(), e[i])
                                })), this._key = e.key, this._errorHandler = e.errorHandler, this._useDefaultSearch = !0
                            },
                            _customLoadOptions: function() {
                                return null
                            },
                            key: function() {
                                return this._key
                            },
                            keyOf: function(e) {
                                return this._keyGetter || (this._keyGetter = (0, l.compileGetter)(this.key())), this._keyGetter(e)
                            },
                            _requireKey: function() {
                                if (!this.key()) {
                                    throw r.errors.Error("E4005")
                                }
                            },
                            load: function(e) {
                                var t = this;
                                return e = e || {}, this._eventsStrategy.fireEvent("loading", [e]), this._withLock(this._loadImpl(e)).done((function(n) {
                                    t._eventsStrategy.fireEvent("loaded", [n, e])
                                }))
                            },
                            _loadImpl: function(e) {
                                return _(this.createQuery(e), e).enumerate()
                            },
                            _withLock: function(e) {
                                var t = new d.Deferred;
                                return e.done((function() {
                                    var e = this,
                                        n = arguments;
                                    s.processRequestResultLock.promise().done((function() {
                                        t.resolveWith(e, n)
                                    }))
                                })).fail((function() {
                                    t.rejectWith(this, arguments)
                                })), t
                            },
                            createQuery: m,
                            totalCount: function(e) {
                                return this._totalCountImpl(e)
                            },
                            _totalCountImpl: function(e) {
                                return _(this.createQuery(e), e, !0).count()
                            },
                            byKey: function(e, t) {
                                return this._addFailHandlers(this._withLock(this._byKeyImpl(e, t)))
                            },
                            _byKeyImpl: m,
                            insert: function(e) {
                                var t = this;
                                return t._eventsStrategy.fireEvent("modifying"), t._eventsStrategy.fireEvent("inserting", [e]), t._addFailHandlers(t._insertImpl(e).done((function(e, n) {
                                    t._eventsStrategy.fireEvent("inserted", [e, n]), t._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _insertImpl: m,
                            update: function(e, t) {
                                var n = this;
                                return n._eventsStrategy.fireEvent("modifying"), n._eventsStrategy.fireEvent("updating", [e, t]), n._addFailHandlers(n._updateImpl(e, t).done((function() {
                                    n._eventsStrategy.fireEvent("updated", [e, t]), n._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _updateImpl: m,
                            push: function(e) {
                                var t = this,
                                    n = {
                                        changes: e,
                                        waitFor: []
                                    };
                                this._eventsStrategy.fireEvent("beforePush", [n]), d.when.apply(void 0, function(e) {
                                    return function(e) {
                                        if (Array.isArray(e)) {
                                            return p(e)
                                        }
                                    }(e) || function(e) {
                                        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                            return Array.from(e)
                                        }
                                    }(e) || function(e, t) {
                                        if (!e) {
                                            return
                                        }
                                        if ("string" == typeof e) {
                                            return p(e, t)
                                        }
                                        var n = Object.prototype.toString.call(e).slice(8, -1);
                                        "Object" === n && e.constructor && (n = e.constructor.name);
                                        if ("Map" === n || "Set" === n) {
                                            return Array.from(e)
                                        }
                                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                            return p(e, t)
                                        }
                                    }(e) || function() {
                                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                    }()
                                }(n.waitFor)).done((function() {
                                    t._pushImpl(e), t._eventsStrategy.fireEvent("push", [e])
                                }))
                            },
                            _pushImpl: c.noop,
                            remove: function(e) {
                                var t = this;
                                return t._eventsStrategy.fireEvent("modifying"), t._eventsStrategy.fireEvent("removing", [e]), t._addFailHandlers(t._removeImpl(e).done((function(e) {
                                    t._eventsStrategy.fireEvent("removed", [e]), t._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _removeImpl: m,
                            _addFailHandlers: function(e) {
                                return e.fail(this._errorHandler).fail(r.handleError)
                            },
                            on: function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            },
                            off: function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            }
                        });
                    y.create = function(e, t) {
                        if (!(e in v)) {
                            throw r.errors.Error("E4020", e)
                        }
                        return new v[e](t)
                    }, y.registerClass = function(e, t) {
                        return t && (v[t] = e), e
                    }, y.inherit = (g = y.inherit, function(e, t) {
                        var n = g.apply(this, [e]);
                        return y.registerClass(n, t), n
                    });
                    var b = y;
                    t.default = b, e.exports = t.default, e.exports.default = t.default
                },
            36893:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/apply_changes.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./array_utils */ 60637).applyChanges;
                    t.default = i, e.exports = t.default, e.exports.default = t.default
                },
            35042:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_query.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ../core/class */ 38377)) && i.__esModule ? i : {
                            default: i
                        },
                        a = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = n( /*! ../core/utils/data */ 47617),
                        l = n( /*! ../core/utils/deferred */ 62754),
                        u = n( /*! ./errors */ 18438),
                        d = n( /*! ./utils */ 16454);
                    var c = o.default.inherit({
                            toArray: function() {
                                var e = [];
                                for (this.reset(); this.next();) {
                                    e.push(this.current())
                                }
                                return e
                            },
                            countable: function() {
                                return !1
                            }
                        }),
                        h = c.inherit({
                            ctor: function(e) {
                                this.array = e, this.index = -1
                            },
                            next: function() {
                                return this.index + 1 < this.array.length && (this.index++, !0)
                            },
                            current: function() {
                                return this.array[this.index]
                            },
                            reset: function() {
                                this.index = -1
                            },
                            toArray: function() {
                                return this.array.slice(0)
                            },
                            countable: function() {
                                return !0
                            },
                            count: function() {
                                return this.array.length
                            }
                        }),
                        f = c.inherit({
                            ctor: function(e) {
                                this.iter = e
                            },
                            next: function() {
                                return this.iter.next()
                            },
                            current: function() {
                                return this.iter.current()
                            },
                            reset: function() {
                                return this.iter.reset()
                            }
                        }),
                        p = f.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.index = -1, this.mapper = t
                            },
                            current: function() {
                                return this.mapper(this.callBase(), this.index)
                            },
                            next: function() {
                                var e = this.callBase();
                                return e && this.index++, e
                            }
                        }),
                        g = function(e, t) {
                            return e = (0, s.toComparable)(e), t = (0, s.toComparable)(t), null === e && null !== t ? -1 : null !== e && null === t || void 0 === e && void 0 !== t ? 1 : void 0 !== e && void 0 === t || e < t ? -1 : e > t ? 1 : 0
                        },
                        m = c.inherit({
                            ctor: function(e, t, n, i) {
                                e instanceof p || (e = new p(e, this._wrap)), this.iter = e, this.rules = [{
                                    getter: t,
                                    desc: n,
                                    compare: i
                                }]
                            },
                            thenBy: function(e, t, n) {
                                var i = new m(this.sortedIter || this.iter, e, t, n);
                                return this.sortedIter || (i.rules = this.rules.concat(i.rules)), i
                            },
                            next: function() {
                                return this._ensureSorted(), this.sortedIter.next()
                            },
                            current: function() {
                                return this._ensureSorted(), this.sortedIter.current()
                            },
                            reset: function() {
                                delete this.sortedIter
                            },
                            countable: function() {
                                return this.sortedIter || this.iter.countable()
                            },
                            count: function() {
                                return this.sortedIter ? this.sortedIter.count() : this.iter.count()
                            },
                            _ensureSorted: function() {
                                var e = this;
                                e.sortedIter || ((0, r.each)(e.rules, (function() {
                                    this.getter = (0, s.compileGetter)(this.getter)
                                })), e.sortedIter = new p(new h(this.iter.toArray().sort((function(t, n) {
                                    return e._compare(t, n)
                                }))), e._unwrap))
                            },
                            _wrap: function(e, t) {
                                return {
                                    index: t,
                                    value: e
                                }
                            },
                            _unwrap: function(e) {
                                return e.value
                            },
                            _compare: function(e, t) {
                                var n = e.index,
                                    i = t.index;
                                if ((e = e.value) === (t = t.value)) {
                                    return n - i
                                }
                                for (var o = 0, a = this.rules.length; o < a; o++) {
                                    var r = this.rules[o],
                                        s = r.getter(e),
                                        l = r.getter(t),
                                        u = (r.compare || g)(s, l);
                                    if (u) {
                                        return r.desc ? -u : u
                                    }
                                }
                                return n - i
                            }
                        }),
                        _ = function() {
                            var e = function(e) {
                                return (0, a.isDefined)(e) ? e.toString() : ""
                            };

                            function t(e, t, n) {
                                return function(i) {
                                    i = (0, s.toComparable)(e(i));
                                    var o = function(e) {
                                        return "" === e || 0 === e || !1 === e
                                    }(t) ? i === t : i == t;
                                    return n && (o = !o), o
                                }
                            }
                            return function(n) {
                                return (0, a.isFunction)(n) ? n : (0, d.isGroupCriterion)(n) ? function(e) {
                                    var t = [],
                                        n = !1,
                                        i = !1;
                                    return (0, r.each)(e, (function() {
                                            if (Array.isArray(this) || (0, a.isFunction)(this)) {
                                                if (t.length > 1 && n !== i) {
                                                    throw new u.errors.Error("E4019")
                                                }
                                                t.push(_(this)), n = i, i = !0
                                            } else {
                                                i = (0, d.isConjunctiveOperator)(this)
                                            }
                                        })),
                                        function(e) {
                                            for (var i = n, o = 0; o < t.length; o++) {
                                                if (t[o](e) !== n) {
                                                    i = !n;
                                                    break
                                                }
                                            }
                                            return i
                                        }
                                }(n) : (0, d.isUnaryOperation)(n) ? function(e) {
                                    var t = e[0],
                                        n = _(e[1]);
                                    if ("!" === t) {
                                        return function(e) {
                                            return !n(e)
                                        }
                                    }
                                    throw u.errors.Error("E4003", t)
                                }(n) : function(n) {
                                    n = (0, d.normalizeBinaryCriterion)(n);
                                    var i = (0, s.compileGetter)(n[0]),
                                        o = n[1],
                                        a = n[2];
                                    switch (a = (0, s.toComparable)(a), o.toLowerCase()) {
                                        case "=":
                                            return t(i, a);
                                        case "<>":
                                            return t(i, a, !0);
                                        case ">":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) > a
                                            };
                                        case "<":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) < a
                                            };
                                        case ">=":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) >= a
                                            };
                                        case "<=":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) <= a
                                            };
                                        case "startswith":
                                            return function(t) {
                                                return 0 === (0, s.toComparable)(e(i(t))).indexOf(a)
                                            };
                                        case "endswith":
                                            return function(t) {
                                                var n = (0, s.toComparable)(e(i(t))),
                                                    o = e(a);
                                                if (n.length < o.length) {
                                                    return !1
                                                }
                                                var r = n.lastIndexOf(a);
                                                return -1 !== r && r === n.length - a.length
                                            };
                                        case "contains":
                                            return function(t) {
                                                return (0, s.toComparable)(e(i(t))).indexOf(a) > -1
                                            };
                                        case "notcontains":
                                            return function(t) {
                                                return -1 === (0, s.toComparable)(e(i(t))).indexOf(a)
                                            }
                                    }
                                    throw u.errors.Error("E4003", o)
                                }(n)
                            }
                        }(),
                        v = f.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.criteria = _(t)
                            },
                            next: function() {
                                for (; this.iter.next();) {
                                    if (this.criteria(this.current())) {
                                        return !0
                                    }
                                }
                                return !1
                            }
                        }),
                        y = c.inherit({
                            ctor: function(e, t) {
                                this.iter = e, this.getter = t
                            },
                            next: function() {
                                return this._ensureGrouped(), this.groupedIter.next()
                            },
                            current: function() {
                                return this._ensureGrouped(), this.groupedIter.current()
                            },
                            reset: function() {
                                delete this.groupedIter
                            },
                            countable: function() {
                                return !!this.groupedIter
                            },
                            count: function() {
                                return this.groupedIter.count()
                            },
                            _ensureGrouped: function() {
                                if (!this.groupedIter) {
                                    var e = {},
                                        t = [],
                                        n = this.iter,
                                        i = (0, s.compileGetter)(this.getter);
                                    for (n.reset(); n.next();) {
                                        var o = n.current(),
                                            a = i(o);
                                        a in e ? e[a].push(o) : (e[a] = [o], t.push(a))
                                    }
                                    this.groupedIter = new h((0, r.map)(t, (function(t) {
                                        return {
                                            key: t,
                                            items: e[t]
                                        }
                                    })))
                                }
                            }
                        }),
                        b = f.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.getter = (0, s.compileGetter)(t)
                            },
                            current: function() {
                                return this.getter(this.callBase())
                            },
                            countable: function() {
                                return this.iter.countable()
                            },
                            count: function() {
                                return this.iter.count()
                            }
                        }),
                        x = f.inherit({
                            ctor: function(e, t, n) {
                                this.callBase(e), this.skip = Math.max(0, t), this.take = Math.max(0, n), this.pos = 0
                            },
                            next: function() {
                                if (this.pos >= this.skip + this.take) {
                                    return !1
                                }
                                for (; this.pos < this.skip && this.iter.next();) {
                                    this.pos++
                                }
                                return this.pos++, this.iter.next()
                            },
                            reset: function() {
                                this.callBase(), this.pos = 0
                            },
                            countable: function() {
                                return this.iter.countable()
                            },
                            count: function() {
                                return Math.min(this.iter.count() - this.skip, this.take)
                            }
                        });
                    t.default = function e(t, n) {
                        n = n || {}, t instanceof c || (t = new h(t));
                        var i = function(e) {
                                var t = n.errorHandler;
                                t && t(e), (0, u.handleError)(e)
                            },
                            o = function(e) {
                                var n = (new l.Deferred).fail(i),
                                    o = e.step,
                                    a = e.finalize;
                                try {
                                    t.reset();
                                    for (var r = ("seed" in e ? e.seed : t.next() ? t.current() : NaN); t.next();) {
                                        r = o(r, t.current())
                                    }
                                    n.resolve(a ? a(r) : r)
                                } catch (e) {
                                    n.reject(e)
                                }
                                return n.promise()
                            },
                            r = function(e) {
                                return o(d.aggregators[e])
                            },
                            f = function(e) {
                                return (0, a.isFunction)(e) || Array.isArray(e) || (e = [].slice.call(arguments)), g(new b(t, e))
                            },
                            p = function(e) {
                                return f((0, s.compileGetter)(e))
                            };

                        function g(t) {
                            return e(t, n)
                        }
                        return {
                            toArray: function() {
                                return t.toArray()
                            },
                            enumerate: function() {
                                var e = (new l.Deferred).fail(i);
                                try {
                                    e.resolve(t.toArray())
                                } catch (t) {
                                    e.reject(t)
                                }
                                return e.promise()
                            },
                            sortBy: function(e, n, i) {
                                return g(new m(t, e, n, i))
                            },
                            thenBy: function(e, n, i) {
                                if (t instanceof m) {
                                    return g(t.thenBy(e, n, i))
                                }
                                throw u.errors.Error("E4004")
                            },
                            filter: function(e) {
                                return Array.isArray(e) || (e = [].slice.call(arguments)), g(new v(t, e))
                            },
                            slice: function(e, n) {
                                return void 0 === n && (n = Number.MAX_VALUE), g(new x(t, e, n))
                            },
                            select: f,
                            groupBy: function(e) {
                                return g(new y(t, e))
                            },
                            aggregate: function(e, t, n) {
                                return o(arguments.length < 2 ? {
                                    step: arguments[0]
                                } : {
                                    seed: e,
                                    step: t,
                                    finalize: n
                                })
                            },
                            count: function() {
                                if (t.countable()) {
                                    var e = (new l.Deferred).fail(i);
                                    try {
                                        e.resolve(t.count())
                                    } catch (t) {
                                        e.reject(t)
                                    }
                                    return e.promise()
                                }
                                return r("count")
                            },
                            sum: function(e) {
                                return e ? p(e).sum() : r("sum")
                            },
                            min: function(e) {
                                return e ? p(e).min() : r("min")
                            },
                            max: function(e) {
                                return e ? p(e).max() : r("max")
                            },
                            avg: function(e) {
                                return e ? p(e).avg() : r("avg")
                            }
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            26562:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 16454),
                        o = l(n( /*! ./query */ 96687)),
                        a = n( /*! ./errors */ 18438),
                        r = l(n( /*! ./abstract_store */ 67403)),
                        s = n( /*! ./array_utils */ 60637);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = r.default.inherit({
                        ctor: function(e) {
                            e = Array.isArray(e) ? {
                                data: e
                            } : e || {}, this.callBase(e);
                            var t = e.data;
                            if (t && !Array.isArray(t)) {
                                throw a.errors.Error("E4006")
                            }
                            this._array = t || []
                        },
                        createQuery: function() {
                            return (0, o.default)(this._array, {
                                errorHandler: this._errorHandler
                            })
                        },
                        _byKeyImpl: function(e) {
                            var t = (0, s.indexByKey)(this, this._array, e);
                            return -1 === t ? (0, i.rejectedPromise)(a.errors.Error("E4009")) : (0, i.trivialPromise)(this._array[t])
                        },
                        _insertImpl: function(e) {
                            return (0, s.insert)(this, this._array, e)
                        },
                        _pushImpl: function(e) {
                            (0, s.applyBatch)({
                                keyInfo: this,
                                data: this._array,
                                changes: e
                            })
                        },
                        _updateImpl: function(e, t) {
                            return (0, s.update)(this, this._array, e, t)
                        },
                        _removeImpl: function(e) {
                            return (0, s.remove)(this, this._array, e)
                        },
                        clear: function() {
                            this._eventsStrategy.fireEvent("modifying"), this._array = [], this._eventsStrategy.fireEvent("modified")
                        }
                    }, "array");
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            60637:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_utils.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.applyBatch = b, t.applyChanges = function(e, t) {
                        var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            i = n.keyExpr,
                            o = void 0 === i ? "id" : i,
                            a = n.immutable,
                            r = void 0 === a || a,
                            s = (0, u.compileGetter)(o),
                            l = {
                                key: function() {
                                    return o
                                },
                                keyOf: function(e) {
                                    return s(e)
                                }
                            };
                        return b({
                            keyInfo: l,
                            data: e,
                            changes: t,
                            immutable: r,
                            disableCache: !0,
                            logError: !0
                        })
                    }, t.createObjectWithChanges = y, t.indexByKey = k, t.insert = C, t.remove = S, t.update = w;
                    var i = n( /*! ../core/utils/type */ 35922),
                        o = c(n( /*! ../core/config */ 80209)),
                        a = c(n( /*! ../core/guid */ 73176)),
                        r = n( /*! ../core/utils/extend */ 13306),
                        s = n( /*! ./errors */ 18438),
                        l = n( /*! ../core/utils/object */ 48013),
                        u = n( /*! ../core/utils/data */ 47617),
                        d = n( /*! ./utils */ 16454);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function h(e) {
                        return h = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, h(e)
                    }

                    function p(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }

                    function m(e, t, n, i) {
                        return i ? function g(e, t, n, i) {
                            var o;
                            if (i) {
                                for (var a = 0; a < t.length; a++) {
                                    if (o = g(e, t[a].items || t[a].collapsedItems || [] || [], n, i - 1)) {
                                        return o
                                    }
                                }
                            } else if (k(e, t, n) >= 0) {
                                return t
                            }
                        }(e, t, n, i) || [] : t
                    }

                    function _(e, t, n) {
                        e._dataByKeyMap && (e._dataByKeyMap[JSON.stringify(t)] = n, e._dataByKeyMapLength += n ? 1 : -1)
                    }

                    function y(e, t) {
                        var n = function v(e) {
                            var t = e ? Object.create(Object.getPrototypeOf(e)) : {},
                                n = (0, r.extendFromObject)({}, e);
                            for (var o in n) {
                                var a = n[o];
                                (0, i.isObject)(a) && !(0, i.isPlainObject)(a) && (n[o] = v(a))
                            }
                            return (0, l.deepExtendArraySafe)(t, n, !0, !0), t
                        }(e);
                        return (0, l.deepExtendArraySafe)(n, t, !0, !0)
                    }

                    function b(e) {
                        var t = e.keyInfo,
                            n = e.data,
                            o = e.changes,
                            a = e.groupCount,
                            r = e.useInsertIndex,
                            s = e.immutable,
                            l = e.disableCache,
                            u = e.logError,
                            d = !0 === s ? function(e) {
                                return function(e) {
                                    if (Array.isArray(e)) {
                                        return p(e)
                                    }
                                }(e) || function(e) {
                                    if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                        return Array.from(e)
                                    }
                                }(e) || function(e, t) {
                                    if (!e) {
                                        return
                                    }
                                    if ("string" == typeof e) {
                                        return p(e, t)
                                    }
                                    var n = Object.prototype.toString.call(e).slice(8, -1);
                                    "Object" === n && e.constructor && (n = e.constructor.name);
                                    if ("Map" === n || "Set" === n) {
                                        return Array.from(e)
                                    }
                                    if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                        return p(e, t)
                                    }
                                }(e) || function() {
                                    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                }()
                            }(n) : n;
                        return o.forEach((function(e) {
                            var n = "insert" === e.type ? d : m(t, d, e.key, a);
                            switch (!l && function(e, t) {
                                    if (e.key() && (!t._dataByKeyMap || t._dataByKeyMapLength !== t.length)) {
                                        for (var n = {}, i = t.length, o = 0; o < i; o++) {
                                            n[JSON.stringify(e.keyOf(t[o]))] = t[o]
                                        }
                                        t._dataByKeyMap = n, t._dataByKeyMapLength = i
                                    }
                                }(t, n), e.type) {
                                case "update":
                                    w(t, n, e.key, e.data, !0, s, u);
                                    break;
                                case "insert":
                                    C(t, n, e.data, r && (0, i.isDefined)(e.index) ? e.index : -1, !0, u);
                                    break;
                                case "remove":
                                    S(t, n, e.key, !0, u)
                            }
                        })), d
                    }

                    function x(e, t, n) {
                        return e ? t && s.errors.log(n) : (0, d.rejectedPromise)(s.errors.Error(n))
                    }

                    function w(e, t, n, a, r, s, u) {
                        var c, h = e.key();
                        if (h) {
                            if (function(e, t) {
                                    for (var n = "string" == typeof t ? t.split() : t.slice(); n.length;) {
                                        if (n.shift() in e) {
                                            return !0
                                        }
                                    }
                                    return !1
                                }(a, h) && !(0, d.keysEqual)(h, n, e.keyOf(a))) {
                                return x(r, u, "E4017")
                            }
                            if (c = function(e, t) {
                                    if (e._dataByKeyMap) {
                                        return e._dataByKeyMap[JSON.stringify(t)]
                                    }
                                }(t, n), !c) {
                                var f = k(e, t, n);
                                if (f < 0) {
                                    return x(r, u, "E4009")
                                }
                                if (c = t[f], !0 === s && (0, i.isDefined)(c)) {
                                    var p = y(c, a);
                                    return t[f] = p, !r && (0, d.trivialPromise)(p, n)
                                }
                            }
                        } else {
                            c = n
                        }
                        if ((0, l.deepExtendArraySafe)(c, a, !0), !r) {
                            return (0, o.default)().useLegacyStoreResult ? (0, d.trivialPromise)(n, a) : (0, d.trivialPromise)(c, n)
                        }
                    }

                    function C(e, t, n, l, u, c) {
                        var f, p = e.key(),
                            g = (0, i.isPlainObject)(n) ? (0, r.extend)({}, n) : n;
                        if (p) {
                            if (void 0 === (f = e.keyOf(g)) || "object" === h(f) && (0, i.isEmptyObject)(f)) {
                                if (Array.isArray(p)) {
                                    throw s.errors.Error("E4007")
                                }
                                f = g[p] = String(new a.default)
                            } else if (void 0 !== t[k(e, t, f)]) {
                                return x(u, c, "E4008")
                            }
                        } else {
                            f = g
                        }
                        if (l >= 0 ? t.splice(l, 0, g) : t.push(g), _(t, f, g), !u) {
                            return (0, d.trivialPromise)((0, o.default)().useLegacyStoreResult ? n : g, f)
                        }
                    }

                    function S(e, t, n, i, o) {
                        var a = k(e, t, n);
                        return a > -1 && (t.splice(a, 1), _(t, n, null)), i ? a < 0 ? x(i, o, "E4009") : void 0 : (0, d.trivialPromise)(n)
                    }

                    function k(e, t, n) {
                        var i = e.key();
                        if (! function(e, t) {
                                return !e._dataByKeyMap || e._dataByKeyMap[JSON.stringify(t)]
                            }(t, n)) {
                            return -1
                        }
                        for (var o = 0, a = t.length; o < a; o++) {
                            if ((0, d.keysEqual)(i, e.keyOf(t[o]), n)) {
                                return o
                            }
                        }
                        return -1
                    }
                },
            88036:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/custom_store.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = f(n( /*! ../core/renderer */ 68374)),
                        o = n( /*! ./utils */ 16454),
                        a = n( /*! ./array_utils */ 60637),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = f(n( /*! ../core/config */ 80209)),
                        l = n( /*! ./errors */ 18438),
                        u = f(n( /*! ./abstract_store */ 67403)),
                        d = f(n( /*! ./array_query */ 35042)),
                        c = f(n( /*! ./store_helper */ 99236)),
                        h = n( /*! ../core/utils/deferred */ 62754);

                    function f(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var g = "load";

                    function b(e) {
                        return e && (0, r.isFunction)(e.then)
                    }

                    function x(e) {
                        return (new h.Deferred).resolve(e).promise()
                    }

                    function w(e, t) {
                        if (!(0, r.isFunction)(t)) {
                            throw l.errors.Error("E4011", e)
                        }
                    }

                    function C(e) {
                        throw l.errors.Error("E4012", e)
                    }

                    function S(e) {
                        function t(e) {
                            var t = e[0],
                                n = e[1];
                            return t && t.getResponseHeader ? (0, o.errorMessageFromXhr)(t, n) : null
                        }
                        return function(n) {
                            var i;
                            (i = n instanceof Error ? n : new Error(t(arguments) || n && String(n) || "Unknown error")).message !== o.XHR_ERROR_UNLOAD && e.reject(i)
                        }
                    }

                    function k(e, t) {
                        var n, i = e._loadFunc;
                        return w(g, i), n = i.apply(e, [t]), Array.isArray(n) ? n = x(n) : null == n ? n = x([]) : b(n) || C(g), (0, h.fromPromise)(n)
                    }

                    function I(e, t, n, i) {
                        if (t.__rawData) {
                            i(t.__rawData)
                        } else {
                            var o = t.__rawDataPromise || k(t, n);
                            t._cacheRawData && (t.__rawDataPromise = o), o.always((function() {
                                delete t.__rawDataPromise
                            })).done((function(e) {
                                t._cacheRawData && (t.__rawData = e), i(e)
                            })).fail(S(e))
                        }
                    }

                    function D(e, t, n, o) {
                        var a = {};
                        "userData" in (n = n || {}) && (a.userData = n.userData), I(e, t, a, (function(a) {
                            var r, s, l, u, f = (0, d.default)(a, {
                                    errorHandler: t._errorHandler
                                }),
                                p = [];
                            o || ((r = c.default.queryByOptions(f, n)) === f ? l = a.slice(0) : p.push(r.enumerate().done((function(e) {
                                l = e
                            })))), (n.requireTotalCount || o) && ((s = c.default.queryByOptions(f, n, !0)) === f ? u = a.length : p.push(s.count().done((function(e) {
                                u = e
                            })))), h.when.apply(i.default, p).done((function() {
                                o ? e.resolve(u) : n.requireTotalCount ? e.resolve(l, {
                                    totalCount: u
                                }) : e.resolve(l)
                            })).fail((function(t) {
                                e.reject(t)
                            }))
                        }))
                    }
                    var T = u.default.inherit({
                        ctor: function(e) {
                            e = e || {}, this.callBase(e), this._useDefaultSearch = !!e.useDefaultSearch || "raw" === e.loadMode, this._loadMode = e.loadMode, this._cacheRawData = !1 !== e.cacheRawData, this._loadFunc = e.load, this._totalCountFunc = e.totalCount, this._byKeyFunc = e.byKey, this._insertFunc = e.insert, this._updateFunc = e.update, this._removeFunc = e.remove
                        },
                        createQuery: function() {
                            throw l.errors.Error("E4010")
                        },
                        clearRawDataCache: function() {
                            delete this.__rawData
                        },
                        _totalCountImpl: function(e) {
                            var t = new h.Deferred;
                            return "raw" !== this._loadMode || this._totalCountFunc ? (function(e, t) {
                                var n, i = e._totalCountFunc;
                                if (!(0, r.isFunction)(i)) {
                                    throw l.errors.Error("E4021")
                                }
                                return b(n = i.apply(e, [t])) || (n = Number(n), isFinite(n) || C("totalCount"), n = x(n)), (0, h.fromPromise)(n)
                            }(this, e).done((function(e) {
                                t.resolve(Number(e))
                            })).fail(S(t)), t = this._addFailHandlers(t)) : D(t, this, e, !0), t.promise()
                        },
                        _pushImpl: function(e) {
                            this.__rawData && (0, a.applyBatch)({
                                keyInfo: this,
                                data: this.__rawData,
                                changes: e
                            })
                        },
                        _loadImpl: function(e) {
                            var t = new h.Deferred;
                            return "raw" === this._loadMode ? D(t, this, e, !1) : (k(this, e).done((function(e, n) {
                                t.resolve(e, n)
                            })).fail(S(t)), t = this._addFailHandlers(t)), t.promise()
                        },
                        _byKeyImpl: function(e, t) {
                            var n = new h.Deferred;
                            return this._byKeyViaLoad() ? (this._requireKey(), function(e, t, n) {
                                I(e, t, {}, (function(i) {
                                    for (var a, r = t.key(), s = 0, u = i.length; s < u; s++) {
                                        if (a = i[s], (0, o.keysEqual)(r, t.keyOf(i[s]), n)) {
                                            return void e.resolve(a)
                                        }
                                    }
                                    e.reject(l.errors.Error("E4009"))
                                }))
                            }(n, this, e)) : function(e, t, n) {
                                var i, o = e._byKeyFunc;
                                return w("byKey", o), b(i = o.apply(e, [t, n])) || (i = x(i)), (0, h.fromPromise)(i)
                            }(this, e, t).done((function(e) {
                                n.resolve(e)
                            })).fail(S(n)), n.promise()
                        },
                        _byKeyViaLoad: function() {
                            return "raw" === this._loadMode && !this._byKeyFunc
                        },
                        _insertImpl: function(e) {
                            var t, n = this,
                                i = n._insertFunc,
                                o = new h.Deferred;
                            return w("insert", i), b(t = i.apply(n, [e])) || (t = x(t)), (0, h.fromPromise)(t).done((function(t) {
                                (0, s.default)().useLegacyStoreResult ? o.resolve(e, t) : o.resolve(t || e, n.keyOf(t))
                            })).fail(S(o)), o.promise()
                        },
                        _updateImpl: function(e, t) {
                            var n, i = this._updateFunc,
                                o = new h.Deferred;
                            return w("update", i), b(n = i.apply(this, [e, t])) || (n = x(n)), (0, h.fromPromise)(n).done((function(n) {
                                (0, s.default)().useLegacyStoreResult ? o.resolve(e, t) : o.resolve(n || t, e)
                            })).fail(S(o)), o.promise()
                        },
                        _removeImpl: function(e) {
                            var t, n = this._removeFunc,
                                i = new h.Deferred;
                            return w("remove", n), b(t = n.apply(this, [e])) || (t = x()), (0, h.fromPromise)(t).done((function() {
                                i.resolve(e)
                            })).fail(S(i)), i.promise()
                        }
                    });
                    t.default = T, e.exports = t.default, e.exports.default = t.default
                },
            33546:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./data_source/data_source */ 85273).DataSource;
                    t.default = i, e.exports = t.default, e.exports.default = t.default
                },
            85273:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/data_source.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.DataSource = void 0;
                    var i = v(n( /*! ../../core/class */ 38377)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = n( /*! ../../core/utils/common */ 20576),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../../core/utils/type */ 35922),
                        l = n( /*! ../utils */ 16454),
                        u = n( /*! ../array_utils */ 60637),
                        d = v(n( /*! ../custom_store */ 88036)),
                        c = n( /*! ../../core/events_strategy */ 80566),
                        h = n( /*! ../errors */ 18438),
                        f = n( /*! ../../core/utils/array */ 89386),
                        p = n( /*! ../../core/utils/queue */ 59504),
                        g = n( /*! ../../core/utils/deferred */ 62754),
                        m = v(n( /*! ./operation_manager */ 88665)),
                        _ = n( /*! ./utils */ 9234);

                    function v(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function b(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var x = i.default.inherit({
                        ctor: function(e) {
                            var t, n = this;
                            if (e = (0, _.normalizeDataSourceOptions)(e), this._eventsStrategy = new c.EventsStrategy(this, {
                                    syncStrategy: !0
                                }), this._store = e.store, this._changedTime = 0, 0 !== e.pushAggregationTimeout) {
                                var i, o, a = void 0 === e.pushAggregationTimeout ? function() {
                                        return 5 * n._changedTime
                                    } : e.pushAggregationTimeout,
                                    s = (0, l.throttleChanges)((function(e) {
                                        i.resolve(), g.when.apply(void 0, function(e) {
                                            return function(e) {
                                                if (Array.isArray(e)) {
                                                    return b(e)
                                                }
                                            }(e) || function(e) {
                                                if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                                    return Array.from(e)
                                                }
                                            }(e) || function(e, t) {
                                                if (!e) {
                                                    return
                                                }
                                                if ("string" == typeof e) {
                                                    return b(e, t)
                                                }
                                                var n = Object.prototype.toString.call(e).slice(8, -1);
                                                "Object" === n && e.constructor && (n = e.constructor.name);
                                                if ("Map" === n || "Set" === n) {
                                                    return Array.from(e)
                                                }
                                                if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                                    return b(e, t)
                                                }
                                            }(e) || function() {
                                                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                            }()
                                        }(o)).done((function() {
                                            return n._onPush(e)
                                        })), o = void 0, i = void 0
                                    }), a);
                                this._onPushHandler = function(e) {
                                    n._aggregationTimeoutId = s(e.changes), i || (i = new g.Deferred), o = e.waitFor, e.waitFor.push(i.promise())
                                }, this._store.on("beforePush", this._onPushHandler)
                            } else {
                                this._onPushHandler = function(e) {
                                    return n._onPush(e)
                                }, this._store.on("push", this._onPushHandler)
                            }
                            this._storeLoadOptions = this._extractLoadOptions(e), this._mapFunc = e.map, this._postProcessFunc = e.postProcess, this._pageIndex = void 0 !== e.pageIndex ? e.pageIndex : 0, this._pageSize = void 0 !== e.pageSize ? e.pageSize : 20, this._loadingCount = 0, this._loadQueue = this._createLoadQueue(), this._searchValue = "searchValue" in e ? e.searchValue : null, this._searchOperation = e.searchOperation || "contains", this._searchExpr = e.searchExpr, this._paginate = e.paginate, this._reshapeOnPush = null !== (t = e.reshapeOnPush) && void 0 !== t && t, (0, r.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], (function(t, i) {
                                i in e && n.on(i.substr(2, 1).toLowerCase() + i.substr(3), e[i])
                            })), this._operationManager = new m.default, this._init()
                        },
                        _init: function() {
                            this._items = [], this._userData = {}, this._totalCount = -1, this._isLoaded = !1, (0, s.isDefined)(this._paginate) || (this._paginate = !this.group()), this._isLastPage = !this._paginate
                        },
                        dispose: function() {
                            var e;
                            this._store.off("beforePush", this._onPushHandler), this._store.off("push", this._onPushHandler), this._eventsStrategy.dispose(), clearTimeout(this._aggregationTimeoutId), delete this._store, null === (e = this._delayedLoadTask) || void 0 === e || e.abort(), this._operationManager.cancelAll(), this._disposed = !0
                        },
                        _extractLoadOptions: function(e) {
                            var t = {},
                                n = ["sort", "filter", "select", "group", "requireTotalCount"],
                                i = this._store._customLoadOptions();
                            return i && (n = n.concat(i)), (0, r.each)(n, (function() {
                                t[this] = e[this]
                            })), t
                        },
                        loadOptions: function() {
                            return this._storeLoadOptions
                        },
                        items: function() {
                            return this._items
                        },
                        pageIndex: function(e) {
                            if (!(0, s.isNumeric)(e)) {
                                return this._pageIndex
                            }
                            this._pageIndex = e, this._isLastPage = !this._paginate
                        },
                        paginate: function(e) {
                            if (!(0, s.isBoolean)(e)) {
                                return this._paginate
                            }
                            this._paginate !== e && (this._paginate = e, this.pageIndex(0))
                        },
                        pageSize: function(e) {
                            if (!(0, s.isNumeric)(e)) {
                                return this._pageSize
                            }
                            this._pageSize = e
                        },
                        isLastPage: function() {
                            return this._isLastPage
                        },
                        generateStoreLoadOptionAccessor: function(e) {
                            var t = this;
                            return function(n) {
                                var i = (0, _.normalizeStoreLoadOptionAccessorArguments)(n);
                                if (void 0 === i) {
                                    return t._storeLoadOptions[e]
                                }
                                t._storeLoadOptions[e] = i
                            }
                        },
                        sort: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("sort")(t)
                        },
                        filter: function() {
                            var e = (0, _.normalizeStoreLoadOptionAccessorArguments)(arguments);
                            if (void 0 === e) {
                                return this._storeLoadOptions.filter
                            }
                            this._storeLoadOptions.filter = e, this.pageIndex(0)
                        },
                        group: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("group")(t)
                        },
                        select: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("select")(t)
                        },
                        requireTotalCount: function(e) {
                            if (!(0, s.isBoolean)(e)) {
                                return this._storeLoadOptions.requireTotalCount
                            }
                            this._storeLoadOptions.requireTotalCount = e
                        },
                        searchValue: function(e) {
                            if (arguments.length < 1) {
                                return this._searchValue
                            }
                            this._searchValue = e, this.pageIndex(0)
                        },
                        searchOperation: function(e) {
                            if (!(0, s.isString)(e)) {
                                return this._searchOperation
                            }
                            this._searchOperation = e, this.pageIndex(0)
                        },
                        searchExpr: function(e) {
                            var t = arguments.length;
                            if (0 === t) {
                                return this._searchExpr
                            }
                            t > 1 && (e = [].slice.call(arguments)), this._searchExpr = e, this.pageIndex(0)
                        },
                        store: function() {
                            return this._store
                        },
                        key: function() {
                            var e;
                            return null === (e = this._store) || void 0 === e ? void 0 : e.key()
                        },
                        totalCount: function() {
                            return this._totalCount
                        },
                        isLoaded: function() {
                            return this._isLoaded
                        },
                        isLoading: function() {
                            return this._loadingCount > 0
                        },
                        beginLoading: function() {
                            this._changeLoadingCount(1)
                        },
                        endLoading: function() {
                            this._changeLoadingCount(-1)
                        },
                        _createLoadQueue: function() {
                            return (0, p.create)()
                        },
                        _changeLoadingCount: function(e) {
                            var t = this.isLoading();
                            this._loadingCount += e;
                            var n = this.isLoading();
                            t ^ n && this._eventsStrategy.fireEvent("loadingChanged", [n])
                        },
                        _scheduleLoadCallbacks: function(e) {
                            var t = this;
                            this.beginLoading(), e.always((function() {
                                t.endLoading()
                            }))
                        },
                        _scheduleFailCallbacks: function(e) {
                            var t = this;
                            e.fail((function() {
                                for (var e = arguments.length, n = new Array(e), i = 0; i < e; i++) {
                                    n[i] = arguments[i]
                                }
                                n[0] !== _.CANCELED_TOKEN && t._eventsStrategy.fireEvent("loadError", n)
                            }))
                        },
                        _fireChanged: function(e) {
                            var t = new Date;
                            this._eventsStrategy.fireEvent("changed", e), this._changedTime = new Date - t
                        },
                        _scheduleChangedCallbacks: function(e) {
                            var t = this;
                            e.done((function() {
                                return t._fireChanged()
                            }))
                        },
                        loadSingle: function(e, t) {
                            var n = this,
                                i = new g.Deferred,
                                o = this.key(),
                                a = this._store,
                                r = this._createStoreLoadOptions(),
                                l = function(e) {
                                    !(0, s.isDefined)(e) || (0, f.isEmpty)(e) ? i.reject(new h.errors.Error("E4009")): (Array.isArray(e) || (e = [e]), i.resolve(n._applyMapFunction(e)[0]))
                                };
                            this._scheduleFailCallbacks(i), arguments.length < 2 && (t = e, e = o), delete r.skip, delete r.group, delete r.refresh, delete r.pageIndex, delete r.searchString;
                            var u = function() {
                                return a instanceof d.default && !a._byKeyViaLoad()
                            };
                            return (e === o || u() ? a.byKey(t, r) : (r.take = 1, r.filter = r.filter ? [r.filter, [e, t]] : [e, t], a.load(r))).fail(i.reject).done(l), i.promise()
                        },
                        load: function() {
                            var e = this,
                                t = new g.Deferred,
                                n = function() {
                                    if (!e._disposed && (0, _.isPending)(t)) {
                                        return e._loadFromStore(i, t)
                                    }
                                };
                            this._scheduleLoadCallbacks(t), this._scheduleFailCallbacks(t), this._scheduleChangedCallbacks(t);
                            var i = this._createLoadOperation(t);
                            return this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [i]), this._loadQueue.add((function() {
                                return "number" == typeof i.delay ? e._delayedLoadTask = (0, a.executeAsync)(n, i.delay) : n(), t.promise()
                            })), t.promise({
                                operationId: i.operationId
                            })
                        },
                        _onPush: function(e) {
                            var t = this;
                            if (this._reshapeOnPush) {
                                this.load()
                            } else {
                                this._eventsStrategy.fireEvent("changing", [{
                                    changes: e
                                }]);
                                var n = this.group(),
                                    i = this.items(),
                                    o = 0,
                                    a = this.paginate() || n ? e.filter((function(e) {
                                        return "update" === e.type
                                    })) : e;
                                n && (o = Array.isArray(n) ? n.length : 1), this._mapFunc && a.forEach((function(e) {
                                    "insert" === e.type && (e.data = t._mapFunc(e.data))
                                })), (0, u.applyBatch)({
                                    keyInfo: this.store(),
                                    data: i,
                                    changes: a,
                                    groupCount: o,
                                    useInsertIndex: !0
                                }), this._fireChanged([{
                                    changes: e
                                }])
                            }
                        },
                        _createLoadOperation: function(e) {
                            var t = this,
                                n = this._operationManager.add(e),
                                i = this._createStoreLoadOptions();
                            return e.always((function() {
                                return t._operationManager.remove(n)
                            })), {
                                operationId: n,
                                storeLoadOptions: i
                            }
                        },
                        reload: function() {
                            var e = this.store();
                            return e instanceof d.default && e.clearRawDataCache(), this._init(), this.load()
                        },
                        cancel: function(e) {
                            return this._operationManager.cancel(e)
                        },
                        cancelAll: function() {
                            return this._operationManager.cancelAll()
                        },
                        _addSearchOptions: function(e) {
                            this._disposed || (this.store()._useDefaultSearch ? this._addSearchFilter(e) : (e.searchOperation = this._searchOperation, e.searchValue = this._searchValue, e.searchExpr = this._searchExpr))
                        },
                        _createStoreLoadOptions: function() {
                            var e = (0, o.extend)({}, this._storeLoadOptions);
                            return this._addSearchOptions(e), this._paginate && this._pageSize && (e.skip = this._pageIndex * this._pageSize, e.take = this._pageSize), e.userData = this._userData, e
                        },
                        _addSearchFilter: function(e) {
                            var t = this._searchValue,
                                n = this._searchOperation,
                                i = this._searchExpr,
                                o = [];
                            t && (i || (i = "this"), Array.isArray(i) || (i = [i]), (0, r.each)(i, (function(e, i) {
                                o.length && o.push("or"), o.push([i, n, t])
                            })), e.filter ? e.filter = [o, e.filter] : e.filter = o)
                        },
                        _loadFromStore: function(e, t) {
                            var n = this,
                                i = function(i, a) {
                                    if (!n._disposed && (0, _.isPending)(t)) {
                                        var r = (0, o.extend)((0, _.normalizeLoadResult)(i, a), e);
                                        n._eventsStrategy.fireEvent("customizeLoadResult", [r]), (0, g.when)(r.data).done((function(e) {
                                            r.data = e, n._processStoreLoadResult(r, t)
                                        })).fail(t.reject)
                                    }
                                };
                            return e.data ? (new g.Deferred).resolve(e.data).done(i) : this.store().load(e.storeLoadOptions).done(i).fail(t.reject)
                        },
                        _processStoreLoadResult: function(e, t) {
                            var n = this,
                                i = e.data,
                                o = e.extra,
                                a = e.storeLoadOptions,
                                r = function() {
                                    return n._isLoaded = !0, n._totalCount = isFinite(o.totalCount) ? o.totalCount : -1, t.resolve(i, o)
                                };
                            this._disposed || (i = this._applyPostProcessFunction(this._applyMapFunction(i)), (0, s.isPlainObject)(o) || (o = {}), this._items = i, (!i.length || !this._paginate || this._pageSize && i.length < this._pageSize) && (this._isLastPage = !0), a.requireTotalCount && !isFinite(o.totalCount) ? n.store().totalCount(a).done((function(e) {
                                o.totalCount = e, r()
                            })).fail(t.reject) : r())
                        },
                        _applyMapFunction: function(e) {
                            return this._mapFunc ? (0, _.mapDataRespectingGrouping)(e, this._mapFunc, this.group()) : e
                        },
                        _applyPostProcessFunction: function(e) {
                            return this._postProcessFunc ? this._postProcessFunc(e) : e
                        },
                        on: function(e, t) {
                            return this._eventsStrategy.on(e, t), this
                        },
                        off: function(e, t) {
                            return this._eventsStrategy.off(e, t), this
                        }
                    });
                    t.DataSource = x
                },
            88665:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/operation_manager.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 9234),
                        o = function() {
                            function e() {
                                this._counter = -1, this._deferreds = {}
                            }
                            var t = e.prototype;
                            return t.add = function(e) {
                                return this._counter++, this._deferreds[this._counter] = e, this._counter
                            }, t.remove = function(e) {
                                return delete this._deferreds[e]
                            }, t.cancel = function(e) {
                                return e in this._deferreds && (this._deferreds[e].reject(i.CANCELED_TOKEN), !0)
                            }, t.cancelAll = function() {
                                for (; this._counter > -1;) {
                                    this.cancel(this._counter), this._counter--
                                }
                            }, e
                        }();
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            9234:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/utils.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.normalizeStoreLoadOptionAccessorArguments = t.normalizeLoadResult = t.normalizeDataSourceOptions = t.mapDataRespectingGrouping = t.isPending = t.CANCELED_TOKEN = void 0;
                    var i = h(n( /*! ../../core/utils/ajax */ 37208)),
                        o = h(n( /*! ../abstract_store */ 67403)),
                        a = h(n( /*! ../array_store */ 26562)),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = h(n( /*! ../custom_store */ 88036)),
                        l = n( /*! ../../core/utils/extend */ 13306),
                        u = n( /*! ../../core/utils/type */ 35922),
                        d = n( /*! ../utils */ 16454),
                        c = ["items"];

                    function h(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function f() {
                        return f = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, f.apply(this, arguments)
                    }
                    t.CANCELED_TOKEN = "canceled";
                    t.isPending = function(e) {
                        return "pending" === e.state()
                    };
                    t.normalizeStoreLoadOptionAccessorArguments = function(e) {
                        switch (e.length) {
                            case 0:
                                return;
                            case 1:
                                return e[0]
                        }
                        return [].slice.call(e)
                    };
                    var g = function(e, t, n) {
                            return (0, r.map)(e, (function(e) {
                                e.items;
                                return f({}, function(e, t) {
                                    if (null == e) {
                                        return {}
                                    }
                                    var n, i, o = function(e, t) {
                                        if (null == e) {
                                            return {}
                                        }
                                        var n, i, o = {},
                                            a = Object.keys(e);
                                        for (i = 0; i < a.length; i++) {
                                            n = a[i], t.indexOf(n) >= 0 || (o[n] = e[n])
                                        }
                                        return o
                                    }(e, t);
                                    if (Object.getOwnPropertySymbols) {
                                        var a = Object.getOwnPropertySymbols(e);
                                        for (i = 0; i < a.length; i++) {
                                            n = a[i], t.indexOf(n) >= 0 || Object.prototype.propertyIsEnumerable.call(e, n) && (o[n] = e[n])
                                        }
                                    }
                                    return o
                                }(e, c), {
                                    items: m(e.items, t - 1, n)
                                })
                            }))
                        },
                        m = function(e, t, n) {
                            return Array.isArray(e) ? t ? g(e, t, n) : (0, r.map)(e, n) : e
                        };
                    t.mapDataRespectingGrouping = function(e, t, n) {
                        var i = n ? (0, d.normalizeSortingInfo)(n).length : 0;
                        return m(e, i, t)
                    };
                    t.normalizeLoadResult = function(e, t) {
                        var n;
                        return null !== (n = e) && void 0 !== n && n.data && (t = e, e = e.data), Array.isArray(e) || (e = [e]), {
                            data: e,
                            extra: t
                        }
                    };
                    var _ = function(e, t) {
                        return new s.default({
                            load: function() {
                                return i.default.sendRequest({
                                    url: e,
                                    dataType: "json"
                                })
                            },
                            loadMode: null == t ? void 0 : t.fromUrlLoadMode
                        })
                    };
                    t.normalizeDataSourceOptions = function(e, t) {
                        var n, i, d;
                        return "string" == typeof e && (e = {
                            paginate: !1,
                            store: _(e, t)
                        }), void 0 === e && (e = []), void 0 === (e = Array.isArray(e) || e instanceof o.default ? {
                            store: e
                        } : (0, l.extend)({}, e)).store && (e.store = []), n = e.store, "load" in e ? n = function(e) {
                            var t = {};
                            return (0, r.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], (function() {
                                t[this] = e[this], delete e[this]
                            })), new s.default(t)
                        }(e) : Array.isArray(n) ? n = new a.default(n) : (0, u.isPlainObject)(n) && (i = (0, l.extend)({}, n), d = i.type, delete i.type, n = o.default.create(d, i)), e.store = n, e
                    }
                },
            8162:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/endpoint_selector.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ../core/errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    var a, r, s = (0, n( /*! ../core/utils/window */ 58201).getWindow)();
                    var l = function(e) {
                        var t;
                        this.config = e, a = "ms-appx:" === s.location.protocol, t = s.location.hostname, r = /^(localhost$|127\.)/i.test(t)
                    };
                    l.prototype = {
                        urlFor: function(e) {
                            var t = this.config[e];
                            if (!t) {
                                throw o.default.Error("E0006")
                            }
                            return t.production && (a && !Debug.debuggerEnabled || !a && !r) ? t.production : t.local
                        }
                    };
                    var u = l;
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            18438:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/errors.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.setErrorHandler = t.handleError = t.errors = t.errorHandler = void 0;
                    var i = a(n( /*! ../core/utils/error */ 95640)),
                        o = a(n( /*! ../core/errors */ 17381));

                    function a(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = (0, i.default)(o.default.ERROR_MESSAGES, {
                        E4000: "[DevExpress.data]: {0}",
                        E4001: "Unknown aggregating function is detected: '{0}'",
                        E4002: "Unsupported OData protocol version is used",
                        E4003: "Unknown filter operation is used: {0}",
                        E4004: "The thenby() method is called before the sortby() method",
                        E4005: "Store requires a key expression for this operation",
                        E4006: "ArrayStore 'data' option must be an array",
                        E4007: "Compound keys cannot be auto-generated",
                        E4008: "Attempt to insert an item with a duplicated key",
                        E4009: "Data item cannot be found",
                        E4010: "CustomStore does not support creating queries",
                        E4011: "Custom Store method is not implemented or is not a function: {0}",
                        E4012: "Custom Store method returns an invalid value: {0}",
                        E4013: "Local Store requires the 'name' configuration option is specified",
                        E4014: "Unknown data type is specified for ODataStore: {0}",
                        E4015: "Unknown entity name or alias is used: {0}",
                        E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
                        E4017: "Keys cannot be modified",
                        E4018: "The server has returned a non-numeric value in a response to an item count request",
                        E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
                        E4020: "Unknown store type is detected: {0}",
                        E4021: "The server response does not provide the totalCount value",
                        E4022: "The server response does not provide the groupCount value",
                        E4023: "Could not parse the following XML: {0}",
                        E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
                        W4000: "Data returned from the server has an incorrect structure",
                        W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
                        W4002: "Data loading has failed for some cells due to the following error: {0}"
                    });
                    t.errors = r;
                    var s = null;
                    t.errorHandler = s;
                    t.handleError = function(e) {
                        var t;
                        null === (t = s) || void 0 === t || t(e)
                    };
                    t.setErrorHandler = function(e) {
                        return t.errorHandler = s = e
                    }
                },
            82837:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/local_store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = u(n( /*! ../events/core/events_engine */ 55994)),
                        o = u(n( /*! ../core/dom_adapter */ 73349)),
                        a = n( /*! ../core/utils/window */ 58201),
                        r = u(n( /*! ../core/class */ 38377)),
                        s = n( /*! ./errors */ 18438),
                        l = u(n( /*! ./array_store */ 26562));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = (0, a.getWindow)(),
                        c = r.default.abstract,
                        h = {
                            dom: r.default.inherit({
                                ctor: function(e, t) {
                                    this._store = e, this._dirty = !!t.data, this.save();
                                    var n = this._immediate = t.immediate,
                                        a = Math.max(100, t.flushInterval || 1e4);
                                    if (!n) {
                                        var r = this.save.bind(this);
                                        setInterval(r, a), i.default.on(d, "beforeunload", r), d.cordova && o.default.listen(o.default.getDocument(), "pause", r, !1)
                                    }
                                },
                                notifyChanged: function() {
                                    this._dirty = !0, this._immediate && this.save()
                                },
                                load: function() {
                                    this._store._array = this._loadImpl(), this._dirty = !1
                                },
                                save: function() {
                                    this._dirty && (this._saveImpl(this._store._array), this._dirty = !1)
                                },
                                _loadImpl: c,
                                _saveImpl: c
                            }).inherit({
                                ctor: function(e, t) {
                                    var n = t.name;
                                    if (!n) {
                                        throw s.errors.Error("E4013")
                                    }
                                    this._key = "dx-data-localStore-" + n, this.callBase(e, t)
                                },
                                _loadImpl: function() {
                                    var e = d.localStorage.getItem(this._key);
                                    return e ? JSON.parse(e) : []
                                },
                                _saveImpl: function(e) {
                                    e.length ? d.localStorage.setItem(this._key, JSON.stringify(e)) : d.localStorage.removeItem(this._key)
                                }
                            })
                        },
                        f = l.default.inherit({
                            ctor: function(e) {
                                e = "string" == typeof e ? {
                                    name: e
                                } : e || {}, this.callBase(e), this._backend = new h[e.backend || "dom"](this, e), this._backend.load()
                            },
                            clear: function() {
                                this.callBase(), this._backend.notifyChanged()
                            },
                            _insertImpl: function(e) {
                                var t = this._backend;
                                return this.callBase(e).done(t.notifyChanged.bind(t))
                            },
                            _updateImpl: function(e, t) {
                                var n = this._backend;
                                return this.callBase(e, t).done(n.notifyChanged.bind(n))
                            },
                            _removeImpl: function(e) {
                                var t = this._backend;
                                return this.callBase(e).done(t.notifyChanged.bind(t))
                            }
                        }, "local");
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            47256:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/context.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = h(n( /*! ../../core/class */ 38377)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = n( /*! ../../core/utils/type */ 35922),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../errors */ 18438),
                        l = h(n( /*! ./store */ 341)),
                        u = h(n( /*! ./request_dispatcher */ 63081)),
                        d = n( /*! ./utils */ 77869),
                        c = n( /*! ../../core/utils/deferred */ 62754);

                    function h(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var f = i.default.inherit({
                            ctor: function(e) {
                                var t = this;
                                this._requestDispatcher = new u.default(e), this._errorHandler = e.errorHandler, (0, r.each)(e.entities || [], (function(n, i) {
                                    t[n] = new l.default((0, o.extend)({}, e, {
                                        url: "".concat(t._requestDispatcher.url, "/").concat(encodeURIComponent(i.name || n))
                                    }, i))
                                }))
                            },
                            get: function(e, t) {
                                return this.invoke(e, t, "GET")
                            },
                            invoke: function(e) {
                                var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                    n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : "POST";
                                n = n.toLowerCase();
                                var i, o = new c.Deferred,
                                    r = "".concat(this._requestDispatcher.url, "/").concat(encodeURIComponent(e));
                                return 4 === this.version() && ("get" === n ? (r = (0, d.formatFunctionInvocationUrl)(r, (0, d.escapeServiceOperationParams)(t, this.version())), t = null) : "post" === n && (i = t, t = null)), (0, c.when)(this._requestDispatcher.sendRequest(r, n, (0, d.escapeServiceOperationParams)(t, this.version()), i)).done((function(t) {
                                    (0, a.isPlainObject)(t) && e in t && (t = t[e]), o.resolve(t)
                                })).fail(this._errorHandler).fail(s.handleError).fail(o.reject), o.promise()
                            },
                            objectLink: function(e, t) {
                                var n = this[e];
                                if (!n) {
                                    throw s.errors.Error("E4015", e)
                                }
                                return (0, a.isDefined)(t) ? {
                                    __metadata: {
                                        uri: n._byKeyUrl(t)
                                    }
                                } : null
                            },
                            version: function() {
                                return this._requestDispatcher.version
                            }
                        }),
                        p = f;
                    t.default = p, e.exports = t.default, e.exports.default = t.default
                },
            54263:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/query_adapter.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.odata = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ../../core/utils/iterator */ 95479),
                        a = c(n( /*! ../../core/config */ 80209)),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = c(n( /*! ../query_adapters */ 16135)),
                        l = n( /*! ./utils */ 77869),
                        u = n( /*! ../errors */ 18438),
                        d = n( /*! ../utils */ 16454);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h, f, p, g, m, _, v, y, b, x, w, C, S = ["contains", "notcontains", "startswith", "endswith"],
                        k = (m = function(e, t) {
                            return function(n, i) {
                                var o = [e, "("];
                                return f && (n = -1 === n.indexOf("tolower(") ? "tolower(".concat(n, ")") : n, i = i.toLowerCase()), t ? o.push(i, ",", n) : o.push(n, ",", i), o.push(")"), o.join("")
                            }
                        }, _ = {
                            "=": (g = function(e) {
                                return function(t, n) {
                                    return "".concat(t, " ").concat(e, " ").concat(n)
                                }
                            })("eq"),
                            "<>": g("ne"),
                            ">": g("gt"),
                            ">=": g("ge"),
                            "<": g("lt"),
                            "<=": g("le"),
                            startswith: m("startswith"),
                            endswith: m("endswith")
                        }, v = (0, r.extend)({}, _, {
                            contains: m("substringof", !0),
                            notcontains: m("not substringof", !0)
                        }), y = (0, r.extend)({}, _, {
                            contains: m("contains"),
                            notcontains: m("not contains")
                        }), b = function(e) {
                            var t, n, i = (e = (0, d.normalizeBinaryCriterion)(e))[1],
                                o = e[0],
                                a = p && p[o];
                            if (a && (n = i, S.some((function(e) {
                                    return e === n
                                }))) && "String" !== a) {
                                throw new u.errors.Error("E4024", i, o, a)
                            }
                            var r = (4 === h ? y : v)[i.toLowerCase()];
                            if (!r) {
                                throw u.errors.Error("E4003", i)
                            }
                            var s = e[2];
                            return null !== (t = p) && void 0 !== t && t[o] && (s = (0, l.convertPrimitiveValue)(p[o], s)), r((0, l.serializePropName)(o), (0, l.serializeValue)(s, h))
                        }, x = function(e) {
                            var t = e[0],
                                n = C(e[1]);
                            if ("!" === t) {
                                return "not (".concat(n, ")")
                            }
                            throw u.errors.Error("E4003", t)
                        }, w = function(e) {
                            var t, n, i = [];
                            return (0, o.each)(e, (function(e, o) {
                                if (Array.isArray(o)) {
                                    if (i.length > 1 && t !== n) {
                                        throw new u.errors.Error("E4019")
                                    }
                                    i.push("(".concat(C(o), ")")), t = n, n = "and"
                                } else {
                                    n = (0, d.isConjunctiveOperator)(this) ? "and" : "or"
                                }
                            })), i.join(" ".concat(t, " "))
                        }, C = function(e) {
                            return Array.isArray(e[0]) ? w(e) : (0, d.isUnaryOperation)(e) ? x(e) : b(e)
                        }, function(e, t, n, i) {
                            return p = n, f = null != i ? i : (0, a.default)().oDataFilterToLower, h = t, C(e)
                        }),
                        I = function(e) {
                            var t, n, o, a, s = [],
                                u = [],
                                d = e.expand,
                                c = e.version || 2,
                                h = function() {
                                    return n || void 0 !== o
                                },
                                f = function e(t) {
                                    for (var n = 0; n < t.length; n++) {
                                        if ((0, i.isFunction)(t[n])) {
                                            return !0
                                        }
                                        if (Array.isArray(t[n]) && e(t[n])) {
                                            return !0
                                        }
                                    }
                                    return !1
                                },
                                p = function() {
                                    var i = {};
                                    if (a || (s.length && (i.$orderby = s.join(",")), n && (i.$skip = n), void 0 !== o && (i.$top = o), i.$select = (0, l.generateSelect)(c, t) || void 0, i.$expand = (0, l.generateExpand)(c, d, t) || void 0), u.length) {
                                        var r = u.length < 2 ? u[0] : u,
                                            h = null == e ? void 0 : e.fieldTypes,
                                            f = null == e ? void 0 : e.filterToLower;
                                        i.$filter = k(r, c, h, f)
                                    }
                                    return a && (i.$top = 0), (e.requireTotalCount || a) && (4 !== c ? i.$inlinecount = "allpages" : i.$count = "true"), i
                                };
                            return {
                                optimize: function(e) {
                                    for (var t = -1, n = 0; n < e.length; n++) {
                                        if ("select" === e[n].name) {
                                            t = n;
                                            break
                                        }
                                    }
                                    if (!(t < 0) && (0, i.isFunction)(e[t].args[0])) {
                                        var o = e[1 + t];
                                        o && "slice" === o.name && (e[1 + t] = e[t], e[t] = o)
                                    }
                                },
                                exec: function(t) {
                                    return (0, l.sendRequest)(c, {
                                        url: t,
                                        params: (0, r.extend)(p(), null == e ? void 0 : e.params)
                                    }, {
                                        beforeSend: e.beforeSend,
                                        jsonp: e.jsonp,
                                        withCredentials: e.withCredentials,
                                        countOnly: a,
                                        deserializeDates: e.deserializeDates,
                                        fieldTypes: e.fieldTypes,
                                        isPaged: isFinite(o)
                                    })
                                },
                                multiSort: function(e) {
                                    var t;
                                    if (h()) {
                                        return !1
                                    }
                                    for (var n = 0; n < e.length; n++) {
                                        var i = e[n][0],
                                            o = !!e[n][1],
                                            a = void 0;
                                        if ("string" != typeof i) {
                                            return !1
                                        }
                                        a = (0, l.serializePropName)(i), o && (a += " desc"), (t = t || []).push(a)
                                    }
                                    s = t
                                },
                                slice: function(e, t) {
                                    if (h()) {
                                        return !1
                                    }
                                    n = e, o = t
                                },
                                filter: function(e) {
                                    return !h() && (Array.isArray(e) || (e = [].slice.call(arguments)), !f(e) && (u.length && u.push("and"), void u.push(e)))
                                },
                                select: function(e) {
                                    if (t || (0, i.isFunction)(e)) {
                                        return !1
                                    }
                                    Array.isArray(e) || (e = [].slice.call(arguments)), t = e
                                },
                                count: function() {
                                    return a = !0
                                }
                            }
                        };
                    s.default.odata = I;
                    var D = I;
                    t.odata = D
                },
            63081:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/request_dispatcher.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 77869);

                    function o(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var a = function() {
                        function e(e) {
                            e = e || {}, this._url = String(e.url).replace(/\/+$/, ""), this._beforeSend = e.beforeSend, this._jsonp = e.jsonp, this._version = e.version || 2, this._withCredentials = e.withCredentials, this._deserializeDates = e.deserializeDates, this._filterToLower = e.filterToLower
                        }
                        var t, n, a;
                        return e.prototype.sendRequest = function(e, t, n, o) {
                            return (0, i.sendRequest)(this.version, {
                                url: e,
                                method: t,
                                params: n || {},
                                payload: o
                            }, {
                                beforeSend: this._beforeSend,
                                jsonp: this._jsonp,
                                withCredentials: this._withCredentials,
                                deserializeDates: this._deserializeDates
                            })
                        }, t = e, (n = [{
                            key: "version",
                            get: function() {
                                return this._version
                            }
                        }, {
                            key: "beforeSend",
                            get: function() {
                                return this._beforeSend
                            }
                        }, {
                            key: "url",
                            get: function() {
                                return this._url
                            }
                        }, {
                            key: "jsonp",
                            get: function() {
                                return this._jsonp
                            }
                        }, {
                            key: "filterToLower",
                            get: function() {
                                return this._filterToLower
                            }
                        }]) && o(t.prototype, n), a, e
                    }();
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            341:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = c(n( /*! ../../core/config */ 80209)),
                        a = n( /*! ./utils */ 77869),
                        r = n( /*! ../errors */ 18438),
                        s = c(n( /*! ../query */ 96687)),
                        l = c(n( /*! ../abstract_store */ 67403)),
                        u = c(n( /*! ./request_dispatcher */ 63081)),
                        d = n( /*! ../../core/utils/deferred */ 62754);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var f = l.default.inherit({
                        ctor: function(e) {
                            this.callBase(e), this._requestDispatcher = new u.default(e);
                            var t = this.key(),
                                n = e.fieldTypes,
                                i = e.keyType;
                            if (i) {
                                var o = "string" == typeof i;
                                t || (t = o ? "5d46402c-7899-4ea9-bd81-8b73c47c7683" : Object.keys(i), this._legacyAnonymousKey = t), o && (i = function(e, t) {
                                    return function(e, t, n) {
                                        return t in e ? Object.defineProperty(e, t, {
                                            value: n,
                                            enumerable: !0,
                                            configurable: !0,
                                            writable: !0
                                        }) : e[t] = n, e
                                    }({}, e, t)
                                }(t, i)), n = function(e, t) {
                                    var n = {};
                                    for (var i in e) {
                                        n[i] = e[i]
                                    }
                                    for (var o in t) {
                                        o in n ? n[o] !== t[o] && r.errors.log("W4001", o) : n[o] = t[o]
                                    }
                                    return n
                                }(n, i)
                            }
                            this._fieldTypes = n || {}, 2 === this.version() ? this._updateMethod = "MERGE" : this._updateMethod = "PATCH"
                        },
                        _customLoadOptions: function() {
                            return ["expand", "customQueryParams"]
                        },
                        _byKeyImpl: function(e, t) {
                            var n = {};
                            return t && (n.$expand = (0, a.generateExpand)(this.version(), t.expand, t.select) || void 0, n.$select = (0, a.generateSelect)(this.version(), t.select) || void 0), this._requestDispatcher.sendRequest(this._byKeyUrl(e), "GET", n)
                        },
                        createQuery: function(e) {
                            var t, n, o = {
                                adapter: "odata",
                                beforeSend: this._requestDispatcher.beforeSend,
                                errorHandler: this._errorHandler,
                                jsonp: this._requestDispatcher.jsonp,
                                version: this._requestDispatcher.version,
                                withCredentials: this._requestDispatcher._withCredentials,
                                expand: null == e ? void 0 : e.expand,
                                requireTotalCount: null == e ? void 0 : e.requireTotalCount,
                                deserializeDates: this._requestDispatcher._deserializeDates,
                                fieldTypes: this._fieldTypes
                            };
                            if (n = null !== (t = null == e ? void 0 : e.urlOverride) && void 0 !== t ? t : this._requestDispatcher.url, (0, i.isDefined)(this._requestDispatcher.filterToLower) && (o.filterToLower = this._requestDispatcher.filterToLower), null != e && e.customQueryParams) {
                                var r = (0, a.escapeServiceOperationParams)(null == e ? void 0 : e.customQueryParams, this.version());
                                4 === this.version() ? n = (0, a.formatFunctionInvocationUrl)(n, r) : o.params = r
                            }
                            return (0, s.default)(n, o)
                        },
                        _insertImpl: function(e) {
                            var t = this;
                            this._requireKey();
                            var n = new d.Deferred;
                            return (0, d.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url, "POST", null, e)).done((function(i) {
                                return n.resolve(i && !(0, o.default)().useLegacyStoreResult ? i : e, t.keyOf(i))
                            })).fail(n.reject), n.promise()
                        },
                        _updateImpl: function(e, t) {
                            var n = new d.Deferred;
                            return (0, d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e), this._updateMethod, null, t)).done((function(i) {
                                return (0, o.default)().useLegacyStoreResult ? n.resolve(e, t) : n.resolve(i || t, e)
                            })).fail(n.reject), n.promise()
                        },
                        _removeImpl: function(e) {
                            var t = new d.Deferred;
                            return (0, d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e), "DELETE")).done((function() {
                                return t.resolve(e)
                            })).fail(t.reject), t.promise()
                        },
                        _convertKey: function(e) {
                            var t = e,
                                n = this._fieldTypes,
                                i = this.key() || this._legacyAnonymousKey;
                            if (Array.isArray(i)) {
                                t = {};
                                for (var o = 0; o < i.length; o++) {
                                    var r = i[o];
                                    t[r] = (0, a.convertPrimitiveValue)(n[r], e[r])
                                }
                            } else {
                                n[i] && (t = (0, a.convertPrimitiveValue)(n[i], e))
                            }
                            return t
                        },
                        _byKeyUrl: function(e) {
                            var t = this._requestDispatcher.url,
                                n = this._convertKey(e);
                            return "".concat(t, "(").concat(encodeURIComponent((0, a.serializeKey)(n, this.version())), ")")
                        },
                        version: function() {
                            return this._requestDispatcher.version
                        }
                    }, "odata");
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            77869:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/utils.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.serializeValue = t.serializePropName = t.serializeKey = t.sendRequest = t.keyConverters = t.generateSelect = t.generateExpand = t.formatFunctionInvocationUrl = t.escapeServiceOperationParams = t.convertPrimitiveValue = t.EdmLiteral = void 0;
                    var i = p(n( /*! ../../core/class */ 38377)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = n( /*! ../../core/utils/type */ 35922),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = p(n( /*! ../../core/utils/ajax */ 37208)),
                        l = p(n( /*! ../../core/guid */ 73176)),
                        u = n( /*! ../../core/utils/common */ 20576),
                        d = n( /*! ../../core/utils/deferred */ 62754),
                        c = n( /*! ../errors */ 18438),
                        h = n( /*! ../utils */ 16454),
                        f = n( /*! ../../core/utils/string */ 68752);

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function g(e) {
                        return g = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, g(e)
                    }
                    var m = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,
                        _ = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,
                        v = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,
                        y = "application/json;odata=verbose",
                        b = function(e) {
                            return "string" === (0, a.type)(e) ? e.split() : e
                        },
                        x = function(e) {
                            return /\./.test(e)
                        },
                        w = function(e, t, n) {
                            for (e = String(e); e.length < t;) {
                                e = n ? "".concat(e, "0") : "0".concat(e)
                            }
                            return e
                        },
                        C = function(e, t, n) {
                            var i = [],
                                o = function(e) {
                                    return w(e, 2)
                                };
                            return i.push(e.getFullYear()), i.push("-"), i.push(o(e.getMonth() + 1)), i.push("-"), i.push(o(e.getDate())), t && e.getHours() + e.getMinutes() + e.getSeconds() + e.getMilliseconds() < 1 || (i.push("T"), i.push(o(e.getHours())), i.push(":"), i.push(o(e.getMinutes())), i.push(":"), i.push(o(e.getSeconds())), e.getMilliseconds() && (i.push("."), i.push(w(e.getMilliseconds(), 3))), n || i.push("Z")), i.join("")
                        },
                        S = function(e) {
                            var t = new Date(60 * new Date(0).getTimezoneOffset() * 1e3),
                                n = e.replace("Z", "").split("T"),
                                i = /(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),
                                o = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);
                            if (t.setFullYear(Number(i[1])), t.setMonth(Number(i[2]) - 1), t.setDate(Number(i[3])), Array.isArray(o) && o.length) {
                                t.setHours(Number(o[1])), t.setMinutes(Number(o[2])), t.setSeconds(Number(o[3]));
                                var a = (o[4] || "").slice(0, 3);
                                a = w(a, 3, !0), t.setMilliseconds(Number(a))
                            }
                            return t
                        },
                        k = function(e) {
                            var t = [];
                            for (var n in e) {
                                t.push(n + "=" + e[n])
                            }
                            return t.join("&")
                        };
                    t.sendRequest = function e(t, n, i) {
                        var a = i.deserializeDates,
                            r = i.fieldTypes,
                            l = i.countOnly,
                            u = i.isPaged,
                            f = new d.Deferred,
                            p = function(e, t) {
                                var n, i = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                    a = function(t) {
                                        return JSON.stringify(t, (function(t, n) {
                                            if (!(this[t] instanceof Date)) {
                                                return n
                                            }
                                            switch (n = C(this[t]), e) {
                                                case 2:
                                                    return n.substr(0, n.length - 1);
                                                case 3:
                                                case 4:
                                                    return n;
                                                default:
                                                    throw c.errors.Error("E4002")
                                            }
                                        }))
                                    };
                                t = (0, o.extend)({
                                    async: !0,
                                    method: "get",
                                    url: "",
                                    params: {},
                                    payload: null,
                                    headers: {},
                                    timeout: 3e4
                                }, t), null === (n = i.beforeSend) || void 0 === n || n.call(i, t);
                                var r = t,
                                    s = r.async,
                                    l = r.timeout,
                                    u = r.headers,
                                    d = t,
                                    h = d.url,
                                    f = d.method,
                                    p = i.jsonp,
                                    g = i.withCredentials,
                                    m = "get" === (f = (f || "get").toLowerCase()),
                                    _ = m && p,
                                    v = (0, o.extend)({}, t.params),
                                    b = m ? v : a(t.payload),
                                    x = !m && k(v),
                                    w = !m && y;
                                return x && (h += (h.indexOf("?") > -1 ? "&" : "?") + x), _ && (b.$format = "json"), {
                                    url: h,
                                    data: b,
                                    dataType: _ ? "jsonp" : "json",
                                    jsonp: _ && "$callback",
                                    method: f,
                                    async: s,
                                    timeout: l,
                                    headers: u,
                                    contentType: w,
                                    accepts: {
                                        json: [y, "text/plain"].join()
                                    },
                                    xhrFields: {
                                        withCredentials: g
                                    }
                                }
                            }(t, n, i);
                        return s.default.sendRequest(p).always((function(n, o) {
                            var s = I(n, o, {
                                    deserializeDates: a,
                                    fieldTypes: r
                                }, p),
                                d = s.error,
                                g = s.data,
                                m = s.count,
                                _ = s.nextUrl;
                            if (d) {
                                d.message !== h.XHR_ERROR_UNLOAD && f.reject(d)
                            } else if (l) {
                                isFinite(m) ? f.resolve(m) : f.reject(new c.errors.Error("E4018"))
                            } else if (_ && !u) {
                                /^(?:[a-z]+:)?\/\//i.test(_) || (_ = function(e, t) {
                                    var n, i, o, a = (i = e, o = i.indexOf("?"), o > -1 ? i.substr(0, o) : i).split("/"),
                                        r = t.split("/");
                                    for (a.pop(); r.length;) {
                                        ".." === (n = r.shift()) ? a.pop(): a.push(n)
                                    }
                                    return a.join("/")
                                }(p.url, _)), e(t, {
                                    url: _
                                }, i).fail(f.reject).done((function(e) {
                                    return f.resolve(g.concat(e))
                                }))
                            } else {
                                var v = isFinite(m) ? {
                                    totalCount: m
                                } : void 0;
                                f.resolve(g, v)
                            }
                        })), f.promise()
                    };
                    var I = function(e, t, n, i) {
                            var r = function(e, t, n) {
                                var i, a, r, s;
                                if ("nocontent" === t) {
                                    return null
                                }
                                var l = "Unknown error",
                                    u = e,
                                    d = 200,
                                    c = {
                                        requestOptions: n
                                    };
                                if ("success" !== t) {
                                    var f = e.status,
                                        p = e.responseText;
                                    d = f, l = (0, h.errorMessageFromXhr)(e, t);
                                    try {
                                        u = JSON.parse(p)
                                    } catch (e) {}
                                }
                                var g = (null === (i = u) || void 0 === i ? void 0 : i.then) || (null === (a = u) || void 0 === a ? void 0 : a.error) || (null === (r = u) || void 0 === r ? void 0 : r["odata.error"]) || (null === (s = u) || void 0 === s ? void 0 : s["@odata.error"]);
                                if (g) {
                                    l = function(e) {
                                        var t, n, i = e;
                                        "message" in e && (t = (null === (n = e.message) || void 0 === n ? void 0 : n.value) || e.message);
                                        for (;
                                            (i = i.innererror || i.internalexception) && (t = i.message, !i.internalexception || -1 !== t.indexOf("inner exception"));) {}
                                        return t
                                    }(g) || l, c.errorDetails = g, 200 === d && (d = 500);
                                    var m = Number(g.code);
                                    isFinite(m) && m >= 400 && (d = m)
                                }
                                return d >= 400 || 0 === d ? (c.httpStatus = d, (0, o.extend)(Error(l), c)) : null
                            }(e, t, i);
                            if (r) {
                                return {
                                    error: r
                                }
                            }
                            if (!(0, a.isPlainObject)(e)) {
                                return {
                                    data: e
                                }
                            }
                            var s = "d" in e && (Array.isArray(e.d) || (0, a.isObject)(e.d)) ? D(e, t) : T(e, t);
                            return A(s, n), s
                        },
                        D = function(e) {
                            var t, n = e.d;
                            return (0, a.isDefined)(n) ? {
                                data: null !== (t = n.results) && void 0 !== t ? t : n,
                                nextUrl: n.__next,
                                count: parseInt(n.__count, 10)
                            } : {
                                error: Error("Malformed or unsupported JSON response received")
                            }
                        },
                        T = function(e) {
                            var t;
                            return {
                                data: null !== (t = e.value) && void 0 !== t ? t : e,
                                nextUrl: e["@odata.nextLink"],
                                count: parseInt(e["@odata.count"], 10)
                            }
                        },
                        E = i.default.inherit({
                            ctor: function(e) {
                                this._value = e
                            },
                            valueOf: function() {
                                return this._value
                            }
                        });
                    t.EdmLiteral = E;
                    var A = function e(t) {
                            var n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                            (0, r.each)(t, (function(i, o) {
                                if (null !== o && "object" === g(o)) {
                                    "results" in o && (t[i] = o.results), e(t[i], n)
                                } else if ("string" == typeof o) {
                                    var a = n.fieldTypes,
                                        r = n.deserializeDates;
                                    if ((!a || "String" !== a[i]) && m.test(o) && (t[i] = new l.default(o)), !1 !== r) {
                                        if (o.match(_)) {
                                            var s = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                            t[i] = new Date(s.valueOf() + 60 * s.getTimezoneOffset() * 1e3)
                                        } else {
                                            v.test(o) && (t[i] = new Date(S(t[i]).valueOf()))
                                        }
                                    }
                                }
                            }))
                        },
                        O = function(e) {
                            return e instanceof E ? e.valueOf() : e.replace(/\./g, "/")
                        };
                    t.serializePropName = O;
                    var M = function(e) {
                            return e instanceof Date ? "datetime'".concat(C(e, !0, !0), "'") : e instanceof l.default ? "guid'".concat(e, "'") : e instanceof E ? e.valueOf() : "string" == typeof e ? function(e) {
                                return "'".concat(e.replace(/'/g, "''"), "'")
                            }(e) : String(e)
                        },
                        R = function(e, t) {
                            switch (t) {
                                case 2:
                                case 3:
                                    return M(e);
                                case 4:
                                    return function e(t) {
                                        return t instanceof Date ? C(t, !1, !1) : t instanceof l.default ? t.valueOf() : Array.isArray(t) ? "[".concat(t.map((function(t) {
                                            return e(t)
                                        })).join(","), "]") : M(t)
                                    }(e);
                                default:
                                    throw c.errors.Error("E4002")
                            }
                        };
                    t.serializeValue = R;
                    t.serializeKey = function(e, t) {
                        if ((0, a.isPlainObject)(e)) {
                            var n = [];
                            return (0, r.each)(e, (function(e, i) {
                                return n.push("".concat(O(e), "=").concat(R(i, t)))
                            })), n.join()
                        }
                        return R(e, t)
                    };
                    var B = {
                        String: function(e) {
                            return "".concat(e)
                        },
                        Int32: function(e) {
                            return Math.floor(e)
                        },
                        Int64: function(e) {
                            return e instanceof E ? e : new E("".concat(e, "L"))
                        },
                        Guid: function(e) {
                            return e instanceof l.default ? e : new l.default(e)
                        },
                        Boolean: function(e) {
                            return !!e
                        },
                        Single: function(e) {
                            return e instanceof E ? e : new E(e + "f")
                        },
                        Decimal: function(e) {
                            return e instanceof E ? e : new E(e + "m")
                        }
                    };
                    t.keyConverters = B;
                    t.convertPrimitiveValue = function(e, t) {
                        if (null === t) {
                            return null
                        }
                        var n = B[e];
                        if (!n) {
                            throw c.errors.Error("E4014", e)
                        }
                        return n(t)
                    };
                    t.generateSelect = function(e, t) {
                        if (t) {
                            return e < 4 ? O(t.join()) : (0, u.grep)(t, x, !0).join()
                        }
                    };
                    var V = function(e) {
                            var t = [];
                            return (0, r.each)(e, (function(e, n) {
                                return t.push("".concat(e).concat(function e(t) {
                                    var n = "",
                                        i = [],
                                        o = [];
                                    return (0, r.each)(t, (function(t, n) {
                                        Array.isArray(n) && [].push.apply(i, n), (0, a.isPlainObject)(n) && o.push("".concat(t).concat(e(n)))
                                    })), (i.length || o.length) && (n += "(", i.length && (n += "$select=".concat((0, r.map)(i, O).join())), o.length && (i.length && (n += ";"), n += "$expand=".concat((0, r.map)(o, O).join())), n += ")"), n
                                }(n)))
                            })), t.join()
                        },
                        L = function(e, t, n) {
                            return (0, r.each)(e, (function(e, i) {
                                return function e(t, n, i) {
                                    var o = i(n, t.shift(), t);
                                    !1 !== o && e(t, o, i)
                                }(i.split("."), t, n)
                            }))
                        };
                    t.generateExpand = function(e, t, n) {
                        return e < 4 ? function(e, t) {
                            var n = {};
                            return e && (0, r.each)(b(e), (function() {
                                n[O(this)] = 1
                            })), t && (0, r.each)(b(t), (function() {
                                var e = this.split(".");
                                e.length < 2 || (e.pop(), n[O(e.join("."))] = 1)
                            })), (0, r.map)(n, (function(e, t) {
                                return t
                            })).join()
                        }(t, n) : function(e, t) {
                            var n = {};
                            if (e || t) {
                                return e && L(b(e), n, (function(e, t, n) {
                                    return e[t] = e[t] || {}, !!n.length && e[t]
                                })), t && L((0, u.grep)(b(t), x), n, (function(e, t, n) {
                                    return n.length ? e[t] = e[t] || {} : (e[t] = e[t] || [], e[t].push(t), !1)
                                })), V(n)
                            }
                        }(t, n)
                    };
                    t.formatFunctionInvocationUrl = function(e, t) {
                        return (0, f.format)("{0}({1})", e, (0, r.map)(t || {}, (function(e, t) {
                            return (0, f.format)("{0}={1}", t, e)
                        })).join(","))
                    };
                    t.escapeServiceOperationParams = function(e, t) {
                        if (!e) {
                            return e
                        }
                        var n = {};
                        return (0, r.each)(e, (function(e, i) {
                            n[e] = R(i, t)
                        })), n
                    }
                },
            96687:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./query_implementation */ 77549);
                    t.default = function() {
                        var e = Array.isArray(arguments[0]) ? "array" : "remote";
                        return i.queryImpl[e].apply(this, arguments)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            16135:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query_adapters.js ***!
                  \********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = {}, e.exports = t.default, e.exports.default = t.default
                },
            77549:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query_implementation.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.queryImpl = void 0;
                    var i = a(n( /*! ./array_query */ 35042)),
                        o = a(n( /*! ./remote_query */ 41428));

                    function a(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = {
                        array: i.default,
                        remote: o.default
                    };
                    t.queryImpl = r
                },
            41428:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/remote_query.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = u(n( /*! ./query_adapters */ 16135)),
                        o = n( /*! ./errors */ 18438),
                        a = n( /*! ../core/utils/iterator */ 95479),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/deferred */ 62754),
                        l = u(n( /*! ./array_query */ 35042));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.default = function e(t, n, u) {
                        u = u || [], n = n || {};
                        var d = function(e, t) {
                                return {
                                    name: e,
                                    args: t
                                }
                            },
                            c = function(e) {
                                var c, h, f, p, g, m, _, v = new s.Deferred,
                                    y = function(e) {
                                        var t = n.errorHandler;
                                        t && t(e), (0, o.handleError)(e), v.reject(e)
                                    };

                                function b(e) {
                                    switch (e.name) {
                                        case "sortBy":
                                            return g = [e.args], !0;
                                        case "thenBy":
                                            if (!g) {
                                                throw o.errors.Error("E4004")
                                            }
                                            return g.push(e.args), !0
                                    }
                                    return !1
                                }
                                try {
                                    c = n.adapter, (0, r.isFunction)(c) || (c = i.default[c]), h = c(n), f = [].concat(u).concat(e);
                                    var x = h.optimize;
                                    for (x && x(f); f.length;) {
                                        if (!b(p = f[0])) {
                                            if (g) {
                                                f.unshift(d("multiSort", [g])), g = null;
                                                continue
                                            }
                                            if ("enumerate" !== String(p.name) && (!h[p.name] || !1 === h[p.name].apply(h, p.args))) {
                                                break
                                            }
                                        }
                                        f.shift()
                                    }
                                    m = f[0], _ = [], m && "multiSort" === m.name && (f.shift(), (0, a.each)(m.args[0], (function() {
                                        _.push(d(_.length ? "thenBy" : "sortBy", this))
                                    }))), f = _.concat(f), h.exec(t).done((function(e, t) {
                                        if (f.length) {
                                            var i = (0, l.default)(e, {
                                                errorHandler: n.errorHandler
                                            });
                                            (0, a.each)(f, (function() {
                                                i = i[this.name].apply(i, this.args)
                                            })), i.done(v.resolve).fail(v.reject)
                                        } else {
                                            v.resolve(e, t)
                                        }
                                    })).fail(y)
                                } catch (e) {
                                    y(e)
                                }
                                return v.promise()
                            },
                            h = {};
                        return (0, a.each)(["sortBy", "thenBy", "filter", "slice", "select", "groupBy"], (function() {
                            var i = String(this);
                            h[i] = function() {
                                return e(t, n, u.concat(d(i, arguments)))
                            }
                        })), (0, a.each)(["count", "min", "max", "sum", "avg", "aggregate", "enumerate"], (function() {
                            var e = String(this);
                            h[e] = function() {
                                return c.call(this, d(e, arguments))
                            }
                        })), h
                    }, e.exports = t.default, e.exports.default = t.default
                },
            99236:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/store_helper.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../core/utils/common */ 20576),
                        a = n( /*! ../core/utils/extend */ 13306),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = (i = n( /*! ./array_query */ 35042)) && i.__esModule ? i : {
                            default: i
                        },
                        l = n( /*! ./utils */ 16454);

                    function u(e, t) {
                        return e = e.groupBy(t[0].selector), t.length > 1 && (e = e.select((function(e) {
                            return (0, a.extend)({}, e, {
                                items: u((0, s.default)(e.items), t.slice(1)).toArray()
                            })
                        }))), e
                    }

                    function d(e, t) {
                        var n = [];
                        return (0, r.each)(e, (function(e, i) {
                            (0, o.grep)(t, (function(e) {
                                return i.selector === e.selector
                            })).length < 1 && n.push(i)
                        })), n.concat(t)
                    }
                    var c = {
                        multiLevelGroup: u,
                        arrangeSortingInfo: d,
                        queryByOptions: function(e, t, n) {
                            var i = (t = t || {}).filter;
                            if (i && (e = e.filter(i)), n) {
                                return e
                            }
                            var o = t.sort,
                                a = t.select,
                                s = t.group,
                                c = t.skip,
                                h = t.take;
                            return s && ((s = (0, l.normalizeSortingInfo)(s)).keepInitialKeyOrder = !!t.group.keepInitialKeyOrder), (o || s) && (o = (0, l.normalizeSortingInfo)(o || []), s && !s.keepInitialKeyOrder && (o = d(s, o)), (0, r.each)(o, (function(t) {
                                e = e[t ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                            }))), a && (e = e.select(a)), s && (e = u(e, s)), (h || c) && (e = e.slice(c || 0, h)), e
                        }
                    };
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            16454:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/utils.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.errorMessageFromXhr = t.base64_encode = t.aggregators = t.XHR_ERROR_UNLOAD = void 0, t.isConjunctiveOperator = function(e) {
                        return /^(and|&&|&)$/i.test(e)
                    }, t.isDisjunctiveOperator = function(e) {
                        return /^(or|\|\||\|)$/i.test(e)
                    }, t.rejectedPromise = t.processRequestResultLock = t.normalizeSortingInfo = t.normalizeBinaryCriterion = t.keysEqual = t.isUnaryOperation = t.isGroupCriterion = void 0, t.throttleChanges = function(e, t) {
                        var n = [],
                            o = function(e, t) {
                                var n, o;
                                return function() {
                                    var a = this;
                                    return o = arguments, n || (n = setTimeout((function() {
                                        n = void 0, o && e.call(a, o)
                                    }), (0, i.isFunction)(t) ? t() : t)), n
                                }
                            }((function() {
                                e.call(this, n), n = []
                            }), t);
                        return function(e) {
                            var t, i;
                            Array.isArray(e) && (t = n).push.apply(t, function(e) {
                                if (Array.isArray(e)) {
                                    return c(e)
                                }
                            }(i = e) || function(e) {
                                if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                    return Array.from(e)
                                }
                            }(i) || function(e, t) {
                                if (e) {
                                    if ("string" == typeof e) {
                                        return c(e, t)
                                    }
                                    var n = Object.prototype.toString.call(e).slice(8, -1);
                                    return "Object" === n && e.constructor && (n = e.constructor.name), "Map" === n || "Set" === n ? Array.from(e) : "Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n) ? c(e, t) : void 0
                                }
                            }(i) || function() {
                                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                            }());
                            return o.call(this, n)
                        }
                    }, t.trivialPromise = void 0;
                    var i = n( /*! ../core/utils/type */ 35922),
                        o = d(n( /*! ../core/dom_adapter */ 73349)),
                        a = d(n( /*! ../core/utils/ready_callbacks */ 24311)),
                        r = n( /*! ../core/utils/window */ 58201),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        l = n( /*! ../core/utils/deferred */ 62754),
                        u = n( /*! ../core/utils/common */ 20576);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function c(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var h = a.default.add,
                        f = "DEVEXTREME_XHR_ERROR_UNLOAD";
                    t.XHR_ERROR_UNLOAD = f;
                    t.normalizeBinaryCriterion = function(e) {
                        return [e[0], e.length < 3 ? "=" : String(e[1]).toLowerCase(), e.length < 2 || e[e.length - 1]]
                    };
                    t.normalizeSortingInfo = function(e) {
                        return Array.isArray(e) || (e = [e]), (0, s.map)(e, (function(e) {
                            var t = {
                                selector: (0, i.isFunction)(e) || "string" == typeof e ? e : e.getter || e.field || e.selector,
                                desc: !(!e.desc && "d" !== String(e.dir).charAt(0).toLowerCase())
                            };
                            return e.compare && (t.compare = e.compare), t
                        }))
                    };
                    var p, g, m = (g = {
                        timeout: "Network connection timeout",
                        error: "Unspecified network error",
                        parsererror: "Unexpected server response"
                    }, h((function() {
                        var e = (0, r.getWindow)();
                        o.default.listen(e, "beforeunload", (function() {
                            p = !0
                        }))
                    })), function(e, t) {
                        return p ? f : e.status < 400 ? function(e) {
                            return g[e] || e
                        }(t) : e.statusText
                    });
                    t.errorMessageFromXhr = m;
                    var _ = {
                        count: {
                            seed: 0,
                            step: function(e) {
                                return 1 + e
                            }
                        },
                        sum: {
                            seed: 0,
                            step: function(e, t) {
                                return e + t
                            }
                        },
                        min: {
                            step: function(e, t) {
                                return t < e ? t : e
                            }
                        },
                        max: {
                            step: function(e, t) {
                                return t > e ? t : e
                            }
                        },
                        avg: {
                            seed: [0, 0],
                            step: function(e, t) {
                                return [e[0] + t, e[1] + 1]
                            },
                            finalize: function(e) {
                                return e[1] ? e[0] / e[1] : NaN
                            }
                        }
                    };
                    t.aggregators = _;
                    var v, y, b = (y = 0, {
                        obtain: function() {
                            0 === y && (v = new l.Deferred), y++
                        },
                        release: function() {
                            --y < 1 && v.resolve()
                        },
                        promise: function() {
                            return (0 === y ? (new l.Deferred).resolve() : v).promise()
                        },
                        reset: function() {
                            y = 0, v && v.resolve()
                        }
                    });
                    t.processRequestResultLock = b;
                    t.keysEqual = function(e, t, n) {
                        if (Array.isArray(e)) {
                            for (var i, o = (0, s.map)(t, (function(e, t) {
                                    return t
                                })), a = 0; a < o.length; a++) {
                                if (i = o[a], !(0, u.equalByValue)(t[i], n[i], 0, !1)) {
                                    return !1
                                }
                            }
                            return !0
                        }
                        return (0, u.equalByValue)(t, n, 0, !1)
                    };
                    t.base64_encode = function(e) {
                        Array.isArray(e) || (e = function(e) {
                            var t, n, i = [];
                            for (n = 0; n < e.length; n++) {
                                (t = e.charCodeAt(n)) < 128 ? i.push(t) : t < 2048 ? i.push(192 + (t >> 6), 128 + (63 & t)) : t < 65536 ? i.push(224 + (t >> 12), 128 + (t >> 6 & 63), 128 + (63 & t)) : t < 2097152 && i.push(240 + (t >> 18), 128 + (t >> 12 & 63), 128 + (t >> 6 & 63), 128 + (63 & t))
                            }
                            return i
                        }(String(e)));
                        var t = "";

                        function n(e) {
                            return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)
                        }
                        for (var i = 0; i < e.length; i += 3) {
                            var o = e[i],
                                a = e[i + 1],
                                r = e[i + 2];
                            t += (0, s.map)([o >> 2, (3 & o) << 4 | a >> 4, isNaN(a) ? 64 : (15 & a) << 2 | r >> 6, isNaN(r) ? 64 : 63 & r], n).join("")
                        }
                        return t
                    };
                    t.isUnaryOperation = function(e) {
                        return "!" === e[0] && Array.isArray(e[1])
                    };
                    t.isGroupCriterion = function(e) {
                        var t, n = e[0],
                            o = e[1];
                        return !!Array.isArray(n) || !(!(0, i.isFunction)(n) || !Array.isArray(o) && !(0, i.isFunction)(o) && "and" !== (t = o) && "or" !== t)
                    };
                    t.trivialPromise = function() {
                        var e = new l.Deferred;
                        return e.resolve.apply(e, arguments).promise()
                    };
                    t.rejectedPromise = function() {
                        var e = new l.Deferred;
                        return e.reject.apply(e, arguments).promise()
                    }
                },
            53305:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data_helper.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./data/data_source/data_source */ 85273),
                        o = n( /*! ./core/utils/extend */ 13306),
                        a = n( /*! ./data/data_source/utils */ 9234),
                        f = {
                            postCtor: function() {
                                this.on("disposing", function() {
                                    this._disposeDataSource()
                                }.bind(this))
                            },
                            _refreshDataSource: function() {
                                this._initDataSource(), this._loadDataSource()
                            },
                            _initDataSource: function() {
                                var e, t, n = "_getSpecificDataSourceOption" in this ? this._getSpecificDataSourceOption() : this.option("dataSource");
                                this._disposeDataSource(), n && (n instanceof i.DataSource ? (this._isSharedDataSource = !0, this._dataSource = n) : (e = "_dataSourceOptions" in this ? this._dataSourceOptions() : {}, t = this._dataSourceType ? this._dataSourceType() : i.DataSource, n = (0, a.normalizeDataSourceOptions)(n, {
                                    fromUrlLoadMode: "_dataSourceFromUrlLoadMode" in this && this._dataSourceFromUrlLoadMode()
                                }), this._dataSource = new t((0, o.extend)(!0, {}, e, n))), "_normalizeDataSource" in this && (this._dataSource = this._normalizeDataSource(this._dataSource)), this._addDataSourceHandlers())
                            },
                            _addDataSourceHandlers: function() {
                                "_dataSourceChangedHandler" in this && this._addDataSourceChangeHandler(), "_dataSourceLoadErrorHandler" in this && this._addDataSourceLoadErrorHandler(), "_dataSourceLoadingChangedHandler" in this && this._addDataSourceLoadingChangedHandler(), this._addReadyWatcher()
                            },
                            _addReadyWatcher: function() {
                                this._dataSource.on("loadingChanged", function(e) {
                                    this._ready && this._ready(!e)
                                }.bind(this))
                            },
                            _addDataSourceChangeHandler: function() {
                                var e = this._dataSource;
                                this._proxiedDataSourceChangedHandler = function(t) {
                                    this._dataSourceChangedHandler(e.items(), t)
                                }.bind(this), e.on("changed", this._proxiedDataSourceChangedHandler)
                            },
                            _addDataSourceLoadErrorHandler: function() {
                                this._proxiedDataSourceLoadErrorHandler = this._dataSourceLoadErrorHandler.bind(this), this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
                            },
                            _addDataSourceLoadingChangedHandler: function() {
                                this._proxiedDataSourceLoadingChangedHandler = this._dataSourceLoadingChangedHandler.bind(this), this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                            },
                            _loadDataSource: function() {
                                if (this._dataSource) {
                                    var e = this._dataSource;
                                    e.isLoaded() ? this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler() : e.load()
                                }
                            },
                            _loadSingle: function(e, t) {
                                return e = "this" === e ? this._dataSource.key() || "this" : e, this._dataSource.loadSingle(e, t)
                            },
                            _isLastPage: function() {
                                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
                            },
                            _isDataSourceLoading: function() {
                                return this._dataSource && this._dataSource.isLoading()
                            },
                            _disposeDataSource: function() {
                                this._dataSource && (this._isSharedDataSource ? (delete this._isSharedDataSource, this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler), this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler), this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)) : this._dataSource.dispose(), delete this._dataSource, delete this._proxiedDataSourceChangedHandler, delete this._proxiedDataSourceLoadErrorHandler, delete this._proxiedDataSourceLoadingChangedHandler)
                            },
                            getDataSource: function() {
                                return this._dataSource || null
                            }
                        };
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            95429:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/click.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = g(n( /*! ../core/renderer */ 68374)),
                        o = g(n( /*! ../events/core/events_engine */ 55994)),
                        a = g(n( /*! ../core/devices */ 20530)),
                        r = g(n( /*! ../core/dom_adapter */ 73349)),
                        s = n( /*! ../core/utils/dom */ 3532),
                        l = n( /*! ../animation/frame */ 90057),
                        u = n( /*! ./utils/index */ 39611),
                        d = n( /*! ./utils/event_nodes_disposing */ 27575),
                        c = g(n( /*! ./pointer */ 93786)),
                        h = g(n( /*! ./core/emitter */ 31391)),
                        f = g(n( /*! ./core/emitter_registrator */ 82495)),
                        p = n( /*! ../core/utils/version */ 58020);

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var m = "dxclick";
                    t.name = m;
                    var _ = Math.abs,
                        v = function(e) {
                            return (0, i.default)(e).is("input, textarea, select, button ,:focus, :focus *")
                        },
                        y = {
                            requestAnimationFrame: l.requestAnimationFrame,
                            cancelAnimationFrame: l.cancelAnimationFrame
                        },
                        b = h.default.inherit({
                            ctor: function(e) {
                                this.callBase(e), this._makeElementClickable((0, i.default)(e))
                            },
                            _makeElementClickable: function(e) {
                                e.attr("onclick") || e.attr("onclick", "void(0)")
                            },
                            start: function(e) {
                                this._blurPrevented = e.isDefaultPrevented(), this._startTarget = e.target, this._startEventData = (0, u.eventData)(e)
                            },
                            end: function(e) {
                                this._eventOutOfElement(e, this.getElement().get(0)) || e.type === c.default.cancel ? this._cancel(e) : (v(e.target) || this._blurPrevented || (0, s.resetActiveElement)(), this._accept(e), this._clickAnimationFrame = y.requestAnimationFrame(function() {
                                    this._fireClickEvent(e)
                                }.bind(this)))
                            },
                            _eventOutOfElement: function(e, t) {
                                var n = e.target,
                                    i = !(0, s.contains)(t, n) && t !== n,
                                    o = (0, u.eventDelta)((0, u.eventData)(e), this._startEventData),
                                    a = _(o.x) > 10 || _(o.y) > 10;
                                return i || a
                            },
                            _fireClickEvent: function(e) {
                                this._fireEvent(m, e, {
                                    target: (0, s.closestCommonParent)(this._startTarget, e.target)
                                })
                            },
                            dispose: function() {
                                y.cancelAnimationFrame(this._clickAnimationFrame)
                            }
                        }),
                        x = a.default.real(),
                        w = x.generic || x.ios && (0, p.compare)(x.version, [9, 3]) >= 0 || x.android && (0, p.compare)(x.version, [5]) >= 0;
                    ! function() {
                        var t = function(e) {
                                return w || (0, i.default)(e).closest(".dx-native-click").length
                            },
                            n = null,
                            a = null;

                        function r() {
                            a = null
                        }
                        var s = function(e) {
                            var i = e.originalEvent,
                                o = a === i || i && i.DXCLICK_FIRED;
                            (!e.which || 1 === e.which) && !n && t(e.target) && !o && (i && (i.DXCLICK_FIRED = !0), (0, d.unsubscribeNodesDisposing)(a, r), a = i, (0, d.subscribeNodesDisposing)(a, r), (0, u.fireEvent)({
                                type: m,
                                originalEvent: e
                            }))
                        };
                        b = b.inherit({
                            _makeElementClickable: function(e) {
                                t(e) || this.callBase(e), o.default.on(e, "click", s)
                            },
                            configure: function(t) {
                                this.callBase(t), t.useNative && this.getElement().addClass("dx-native-click")
                            },
                            start: function(e) {
                                n = null, t(e.target) || this.callBase(e)
                            },
                            end: function(e) {
                                t(e.target) || this.callBase(e)
                            },
                            cancel: function() {
                                n = !0
                            },
                            dispose: function() {
                                this.callBase(), o.default.off(this.getElement(), "click", s)
                            }
                        })
                    }(),
                    function() {
                        if (!a.default.real().generic) {
                            var e = null,
                                t = !1,
                                n = "NATIVE_CLICK_FIXER",
                                l = r.default.getDocument();
                            o.default.subscribeGlobal(l, (0, u.addNamespace)(c.default.down, n), (function(n) {
                                e = n.target, t = n.isDefaultPrevented()
                            })), o.default.subscribeGlobal(l, (0, u.addNamespace)("click", n), (function(n) {
                                var o = (0, i.default)(n.target);
                                t || !e || o.is(e) || (0, i.default)(e).is("label") || !v(o) || (0, s.resetActiveElement)(), e = null, t = !1
                            }))
                        }
                    }(), (0, f.default)({
                        emitter: b,
                        bubble: !0,
                        events: [m]
                    })
                },
            49166:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/contextmenu.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = c(n( /*! ../core/renderer */ 68374)),
                        o = c(n( /*! ../events/core/events_engine */ 55994)),
                        a = n( /*! ../core/utils/support */ 60137),
                        r = c(n( /*! ../core/devices */ 20530)),
                        s = c(n( /*! ../core/class */ 38377)),
                        l = c(n( /*! ./core/event_registrator */ 85788)),
                        u = n( /*! ./utils/index */ 39611),
                        d = c(n( /*! ./hold */ 11699));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = "dxContexMenu",
                        f = (0, u.addNamespace)("contextmenu", h),
                        p = (0, u.addNamespace)(d.default.name, h),
                        g = "dxcontextmenu",
                        m = s.default.inherit({
                            setup: function(e) {
                                var t = (0, i.default)(e);
                                o.default.on(t, f, this._contextMenuHandler.bind(this)), (a.touch || r.default.isSimulator()) && o.default.on(t, p, this._holdHandler.bind(this))
                            },
                            _holdHandler: function(e) {
                                (0, u.isMouseEvent)(e) && !r.default.isSimulator() || this._fireContextMenu(e)
                            },
                            _contextMenuHandler: function(e) {
                                this._fireContextMenu(e)
                            },
                            _fireContextMenu: function(e) {
                                return (0, u.fireEvent)({
                                    type: g,
                                    originalEvent: e
                                })
                            },
                            teardown: function(e) {
                                o.default.off(e, ".dxContexMenu")
                            }
                        });
                    (0, l.default)(g, new m);
                    t.name = "dxcontextmenu"
                },
            91633:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.feedback.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.lock = t.inactive = t.active = void 0;
                    var i = c(n( /*! ../../core/class */ 38377)),
                        o = n( /*! ../../core/utils/common */ 20576),
                        a = n( /*! ../../core/utils/dom */ 3532),
                        r = c(n( /*! ../../core/devices */ 20530)),
                        s = n( /*! ../utils/index */ 39611),
                        l = c(n( /*! ../pointer */ 93786)),
                        u = c(n( /*! ./emitter */ 31391)),
                        d = c(n( /*! ./emitter_registrator */ 82495));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = "dxactive";
                    t.active = h;
                    var f = "dxinactive";
                    t.inactive = f;
                    var p, g = i.default.inherit({
                            ctor: function(e, t) {
                                this._timeout = e, this._fire = t
                            },
                            start: function() {
                                var e = this;
                                this._schedule((function() {
                                    e.force()
                                }))
                            },
                            _schedule: function(e) {
                                this.stop(), this._timer = setTimeout(e, this._timeout)
                            },
                            stop: function() {
                                clearTimeout(this._timer)
                            },
                            force: function() {
                                this._fired || (this.stop(), this._fire(), this._fired = !0)
                            },
                            fired: function() {
                                return this._fired
                            }
                        }),
                        m = u.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._active = new g(0, o.noop), this._inactive = new g(0, o.noop)
                            },
                            configure: function(e, t) {
                                switch (t) {
                                    case h:
                                        e.activeTimeout = e.timeout;
                                        break;
                                    case f:
                                        e.inactiveTimeout = e.timeout
                                }
                                this.callBase(e)
                            },
                            start: function(e) {
                                if (p) {
                                    var t = (0, a.contains)(this.getElement().get(0), p.getElement().get(0)),
                                        n = !p._active.fired();
                                    if (t && n) {
                                        return void this._cancel()
                                    }
                                    p._inactive.force()
                                }
                                p = this, this._initEvents(e), this._active.start()
                            },
                            _initEvents: function(e) {
                                var t = this,
                                    n = this._getEmitterTarget(e),
                                    i = (0, s.isMouseEvent)(e),
                                    a = r.default.isSimulator() || !i,
                                    l = (0, o.ensureDefined)(this.activeTimeout, 30),
                                    u = (0, o.ensureDefined)(this.inactiveTimeout, 400);
                                this._active = new g(a ? l : 0, (function() {
                                    t._fireEvent(h, e, {
                                        target: n
                                    })
                                })), this._inactive = new g(a ? u : 0, (function() {
                                    t._fireEvent(f, e, {
                                        target: n
                                    }), p = null
                                }))
                            },
                            cancel: function(e) {
                                this.end(e)
                            },
                            end: function(e) {
                                var t = e.type !== l.default.up;
                                t ? this._active.stop() : this._active.force(), this._inactive.start(), t && this._inactive.force()
                            },
                            dispose: function() {
                                this._active.stop(), this._inactive.stop(), p === this && (p = null), this.callBase()
                            },
                            lockInactive: function() {
                                return this._active.force(), this._inactive.stop(), p = null, this._cancel(), this._inactive.force.bind(this._inactive)
                            }
                        });
                    m.lock = function(e) {
                        var t = p ? p.lockInactive() : o.noop;
                        e.done(t)
                    }, (0, d.default)({
                        emitter: m,
                        events: [h, f]
                    });
                    var _ = m.lock;
                    t.lock = _
                },
            31391:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = u(n( /*! ../../core/renderer */ 68374)),
                        o = n( /*! ../../core/utils/common */ 20576),
                        a = u(n( /*! ../../core/class */ 38377)),
                        r = u(n( /*! ../../core/utils/callbacks */ 44504)),
                        s = n( /*! ../../core/utils/extend */ 13306),
                        l = n( /*! ../utils/index */ 39611);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = a.default.inherit({
                        ctor: function(e) {
                            this._$element = (0, i.default)(e), this._cancelCallback = (0, r.default)(), this._acceptCallback = (0, r.default)()
                        },
                        getElement: function() {
                            return this._$element
                        },
                        validate: function(e) {
                            return !(0, l.isDxMouseWheelEvent)(e)
                        },
                        validatePointers: function(e) {
                            return 1 === (0, l.hasTouches)(e)
                        },
                        allowInterruptionByMouseWheel: function() {
                            return !0
                        },
                        configure: function(e) {
                            (0, s.extend)(this, e)
                        },
                        addCancelCallback: function(e) {
                            this._cancelCallback.add(e)
                        },
                        removeCancelCallback: function() {
                            this._cancelCallback.empty()
                        },
                        _cancel: function(e) {
                            this._cancelCallback.fire(this, e)
                        },
                        addAcceptCallback: function(e) {
                            this._acceptCallback.add(e)
                        },
                        removeAcceptCallback: function() {
                            this._acceptCallback.empty()
                        },
                        _accept: function(e) {
                            this._acceptCallback.fire(this, e)
                        },
                        _requestAccept: function(e) {
                            this._acceptRequestEvent = e
                        },
                        _forgetAccept: function() {
                            this._accept(this._acceptRequestEvent), this._acceptRequestEvent = null
                        },
                        start: o.noop,
                        move: o.noop,
                        end: o.noop,
                        cancel: o.noop,
                        reset: function() {
                            this._acceptRequestEvent && this._accept(this._acceptRequestEvent)
                        },
                        _fireEvent: function(e, t, n) {
                            var i = (0, s.extend)({
                                type: e,
                                originalEvent: t,
                                target: this._getEmitterTarget(t),
                                delegateTarget: this.getElement().get(0)
                            }, n);
                            return (t = (0, l.fireEvent)(i)).cancel && this._cancel(t), t
                        },
                        _getEmitterTarget: function(e) {
                            return (this.delegateSelector ? (0, i.default)(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
                        },
                        dispose: o.noop
                    });
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            82495:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter_registrator.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = m(n( /*! ../../core/renderer */ 68374)),
                        o = m(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        a = m(n( /*! ../../core/dom_adapter */ 73349)),
                        r = m(n( /*! ../../events/core/events_engine */ 55994)),
                        s = n( /*! ../../core/element_data */ 97906),
                        l = m(n( /*! ../../core/class */ 38377)),
                        u = n( /*! ../../core/utils/extend */ 13306),
                        d = n( /*! ../../core/utils/array */ 89386),
                        c = n( /*! ../../core/utils/iterator */ 95479),
                        h = m(n( /*! ./event_registrator */ 85788)),
                        f = n( /*! ../utils/index */ 39611),
                        p = m(n( /*! ../pointer */ 93786)),
                        g = n( /*! ./wheel */ 765);

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var _ = "dxEventManager",
                        v = "dxEmitter",
                        y = new(l.default.inherit({
                            ctor: function() {
                                this._attachHandlers(), this.reset(), this._proxiedCancelHandler = this._cancelHandler.bind(this), this._proxiedAcceptHandler = this._acceptHandler.bind(this)
                            },
                            _attachHandlers: function() {
                                o.default.add(function() {
                                    var e = a.default.getDocument();
                                    r.default.subscribeGlobal(e, (0, f.addNamespace)(p.default.down, _), this._pointerDownHandler.bind(this)), r.default.subscribeGlobal(e, (0, f.addNamespace)(p.default.move, _), this._pointerMoveHandler.bind(this)), r.default.subscribeGlobal(e, (0, f.addNamespace)([p.default.up, p.default.cancel].join(" "), _), this._pointerUpHandler.bind(this)), r.default.subscribeGlobal(e, (0, f.addNamespace)(g.name, _), this._mouseWheelHandler.bind(this))
                                }.bind(this))
                            },
                            _eachEmitter: function(e) {
                                for (var t = this._activeEmitters || [], n = 0; t.length > n;) {
                                    var i = t[n];
                                    if (!1 === e(i)) {
                                        break
                                    }
                                    t[n] === i && n++
                                }
                            },
                            _applyToEmitters: function(e, t) {
                                this._eachEmitter((function(n) {
                                    n[e].call(n, t)
                                }))
                            },
                            reset: function() {
                                this._eachEmitter(this._proxiedCancelHandler), this._activeEmitters = []
                            },
                            resetEmitter: function(e) {
                                this._proxiedCancelHandler(e)
                            },
                            _pointerDownHandler: function(e) {
                                (0, f.isMouseEvent)(e) && e.which > 1 || this._updateEmitters(e)
                            },
                            _updateEmitters: function(e) {
                                this._isSetChanged(e) && (this._cleanEmitters(e), this._fetchEmitters(e))
                            },
                            _isSetChanged: function(e) {
                                var t = this._closestEmitter(e),
                                    n = this._emittersSet || [],
                                    i = t.length !== n.length;
                                return (0, c.each)(t, (function(e, t) {
                                    return !(i = i || n[e] !== t)
                                })), this._emittersSet = t, i
                            },
                            _closestEmitter: function(e) {
                                var t = this,
                                    n = [],
                                    o = (0, i.default)(e.target);

                                function a(i, o) {
                                    o && o.validatePointers(e) && o.validate(e) && (o.addCancelCallback(t._proxiedCancelHandler), o.addAcceptCallback(t._proxiedAcceptHandler), n.push(o))
                                }
                                for (; o.length;) {
                                    var r = (0, s.data)(o.get(0), v) || [];
                                    (0, c.each)(r, a), o = o.parent()
                                }
                                return n
                            },
                            _acceptHandler: function(e, t) {
                                var n = this;
                                this._eachEmitter((function(i) {
                                    i !== e && n._cancelEmitter(i, t)
                                }))
                            },
                            _cancelHandler: function(e, t) {
                                this._cancelEmitter(e, t)
                            },
                            _cancelEmitter: function(e, t) {
                                var n = this._activeEmitters;
                                t ? e.cancel(t) : e.reset(), e.removeCancelCallback(), e.removeAcceptCallback();
                                var i = (0, d.inArray)(e, n);
                                i > -1 && n.splice(i, 1)
                            },
                            _cleanEmitters: function(e) {
                                this._applyToEmitters("end", e), this.reset(e)
                            },
                            _fetchEmitters: function(e) {
                                this._activeEmitters = this._emittersSet.slice(), this._applyToEmitters("start", e)
                            },
                            _pointerMoveHandler: function(e) {
                                this._applyToEmitters("move", e)
                            },
                            _pointerUpHandler: function(e) {
                                this._updateEmitters(e)
                            },
                            _mouseWheelHandler: function(e) {
                                this._allowInterruptionByMouseWheel() && (e.pointers = [null], this._pointerDownHandler(e), this._adjustWheelEvent(e), this._pointerMoveHandler(e), e.pointers = [], this._pointerUpHandler(e))
                            },
                            _allowInterruptionByMouseWheel: function() {
                                var e = !0;
                                return this._eachEmitter((function(t) {
                                    return e = t.allowInterruptionByMouseWheel() && e
                                })), e
                            },
                            _adjustWheelEvent: function(e) {
                                var t = null;
                                if (this._eachEmitter((function(n) {
                                        if (n.gesture) {
                                            var i = n.getDirection(e);
                                            return "horizontal" !== i && !e.shiftKey || "vertical" !== i && e.shiftKey ? (t = n, !1) : void 0
                                        }
                                    })), t) {
                                    var n = t.getDirection(e),
                                        i = "both" === n && !e.shiftKey || "vertical" === n;
                                    e[i ? "pageY" : "pageX"] += e.delta
                                }
                            },
                            isActive: function(e) {
                                var t = !1;
                                return this._eachEmitter((function(n) {
                                    t = t || n.getElement().is(e)
                                })), t
                            }
                        })),
                        b = "dxEmitterSubscription";
                    t.default = function(e) {
                        var t = e.emitter,
                            n = e.events[0],
                            i = e.events;
                        (0, c.each)(i, (function(o, a) {
                            (0, h.default)(a, {
                                noBubble: !e.bubble,
                                setup: function(e) {
                                    var i = (0, s.data)(e, b) || {},
                                        o = (0, s.data)(e, v) || {},
                                        r = o[n] || new t(e);
                                    i[a] = !0, o[n] = r, (0, s.data)(e, v, o), (0, s.data)(e, b, i)
                                },
                                add: function(e, t) {
                                    (0, s.data)(e, v)[n].configure((0, u.extend)({
                                        delegateSelector: t.selector
                                    }, t.data), t.type)
                                },
                                teardown: function(e) {
                                    var t = (0, s.data)(e, b),
                                        o = (0, s.data)(e, v),
                                        r = o[n];
                                    delete t[a];
                                    var l = !0;
                                    (0, c.each)(i, (function(e, n) {
                                        return l = l && !t[n]
                                    })), l && (y.isActive(e) && y.resetEmitter(r), r && r.dispose(), delete o[n])
                                }
                            })
                        }))
                    }, e.exports = t.default, e.exports.default = t.default
                },
            85788:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../../core/utils/iterator */ 95479),
                        a = (i = n( /*! ./event_registrator_callbacks */ 94553)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function(e, t) {
                        var n = {};
                        "noBubble" in t && (n.noBubble = t.noBubble), "bindType" in t && (n.bindType = t.bindType), "delegateType" in t && (n.delegateType = t.delegateType), (0, o.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], (function(e, i) {
                            t[i] && (n[i] = function() {
                                var e = [].slice.call(arguments);
                                return e.unshift(this), t[i].apply(t, e)
                            })
                        })), a.default.fire(e, n)
                    };
                    r.callbacks = a.default;
                    var s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            94553:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator_callbacks.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var o = new(((i = n( /*! ../../core/memorized_callbacks */ 83358)) && i.__esModule ? i : {
                        default: i
                    }).default);
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            55994:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/events_engine.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = p(n( /*! ./event_registrator_callbacks */ 94553)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = p(n( /*! ../../core/dom_adapter */ 73349)),
                        r = n( /*! ../../core/utils/window */ 58201),
                        s = p(n( /*! ../../core/utils/dependency_injector */ 20476)),
                        l = n( /*! ../../core/utils/type */ 35922),
                        u = p(n( /*! ../../core/utils/callbacks */ 44504)),
                        d = p(n( /*! ../../core/errors */ 17381)),
                        c = p(n( /*! ../../core/polyfills/weak_map */ 10126)),
                        h = p(n( /*! ../../events/core/hook_touch_props */ 2418)),
                        f = p(n( /*! ../../core/utils/call_once */ 39618));

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function g(e) {
                        return g = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, g(e)
                    }

                    function m() {
                        return m = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, m.apply(this, arguments)
                    }
                    var _ = (0, r.getWindow)(),
                        v = "dxEmptyEventType",
                        y = {
                            mouseenter: "mouseover",
                            mouseleave: "mouseout",
                            pointerenter: "pointerover",
                            pointerleave: "pointerout"
                        },
                        b = {
                            focusin: "focus",
                            focusout: "blur"
                        },
                        x = ["blur", "focus", "load"],
                        w = ["touchmove", "wheel", "mousewheel", "touchstart"];

                    function C(e, t) {
                        return !(0, l.isWindow)(e) && "#document" !== e.nodeName && a.default.elementMatches(e, t)
                    }
                    var S, k, I, D = new c.default,
                        T = 0,
                        E = (k = {}, i.default.add((function(e, t) {
                            k[e] = t
                        })), {
                            getField: function(e, t) {
                                return k[e] && k[e][t]
                            },
                            callMethod: function(e, t, n, i) {
                                return k[e] && k[e][t] && k[e][t].apply(n, i)
                            }
                        }),
                        A = (0, s.default)({
                            on: P(V(L((function(e, t, n, i, o) {
                                B(e, t).addHandler(o, n, i)
                            })))),
                            one: P(V((function(e, t, n, i, o) {
                                A.on(e, t, n, i, (function i() {
                                    A.off(e, t, n, i), o.apply(this, arguments)
                                }))
                            }))),
                            off: P((I = L((function(e, t, n, i) {
                                B(e, t).removeHandler(i, n)
                            })), function(e, t, n, i) {
                                "function" == typeof n && (i = n, n = void 0), I(e, t, n, i)
                            })),
                            trigger: P(H((function(e, t, n) {
                                var i = t.type,
                                    a = B(e, t.type);
                                if (E.callMethod(i, "trigger", e, [t, n]), a.callHandlers(t, n), !(E.getField(i, "noBubble") || t.isPropagationStopped() || -1 !== x.indexOf(i))) {
                                    var r = [];
                                    ! function e(t) {
                                        var n = t.parentNode;
                                        n && (r.push(n), e(n))
                                    }(e), r.push(_);
                                    for (var s = 0; r[s] && !t.isPropagationStopped();) {
                                        B(r[s], t.type).callHandlers((0, o.extend)(t, {
                                            currentTarget: r[s]
                                        }), n), s++
                                    }
                                }(e.nodeType || (0, l.isWindow)(e)) && (E.callMethod(i, "_default", e, [t, n]), function(e, t) {
                                    var n = b[e] || e;
                                    if (function(e, t) {
                                            return "click" === e && "a" === t.localName
                                        }(e, t)) {
                                        return
                                    }(0, l.isFunction)(t[n]) && (S = e, t[n](), S = void 0)
                                }(i, e))
                            }))),
                            triggerHandler: P(H((function(e, t, n) {
                                B(e, t.type).callHandlers(t, n)
                            })))
                        });

                    function O(e, t) {
                        var n = e[0];
                        if (n) {
                            if (a.default.isNode(n) || (0, l.isWindow)(n)) {
                                t.apply(A, e)
                            } else {
                                if ((0, l.isString)(n) || !("length" in n)) {
                                    throw d.default.Error("E0025")
                                }
                                var i = Array.prototype.slice.call(e, 0);
                                Array.prototype.forEach.call(n, (function(e) {
                                    i[0] = e, O(i, t)
                                }))
                            }
                        }
                    }

                    function P(e) {
                        return function() {
                            O(arguments, e)
                        }
                    }
                    var M = (0, f.default)((function() {
                            var e = !1;
                            try {
                                var t = Object.defineProperty({}, "passive", {
                                    get: function() {
                                        return e = !0, !0
                                    }
                                });
                                _.addEventListener("test", null, t)
                            } catch (e) {}
                            return e
                        })),
                        R = function e(t, n) {
                            return (0, l.isWindow)(t) ? e(t.document, n) : t.contains ? t.contains(n) : !!(n.compareDocumentPosition(t) & n.DOCUMENT_POSITION_CONTAINS)
                        };

                    function B(e, t) {
                        var n = D.get(e),
                            i = (t = t || "").split("."),
                            o = i.slice(1),
                            r = !!i[0];
                        t = i[0] || v, n || (n = {}, D.set(e, n)), n[t] || (n[t] = {
                            handleObjects: [],
                            nativeHandler: null
                        });
                        var s = n[t];
                        return {
                            addHandler: function(n, i, l) {
                                var u = function(i, o) {
                                        var a, r, s = [i],
                                            u = i.currentTarget,
                                            d = i.relatedTarget;
                                        t in y && (a = d && u && (d === u || R(u, d))), void 0 !== o && s.push(o), E.callMethod(t, "handle", e, [i, l]), a || (r = n.apply(u, s)), !1 === r && (i.preventDefault(), i.stopPropagation())
                                    },
                                    d = {
                                        handler: n,
                                        wrappedHandler: function(t, n) {
                                            if (!S || t.type !== S) {
                                                if (t.data = l, t.delegateTarget = e, i) {
                                                    for (var o = t.target; o && o !== e;) {
                                                        C(o, i) && (t.currentTarget = o, u(t, n)), o = o.parentNode
                                                    }
                                                } else {
                                                    t.currentTarget = t.delegateTarget || t.target, u(t, n)
                                                }
                                            }
                                        },
                                        selector: i,
                                        type: t,
                                        data: l,
                                        namespace: o.join("."),
                                        namespaces: o,
                                        guid: ++T
                                    };
                                s.handleObjects.push(d);
                                var c, h, f = 1 === s.handleObjects.length && r;
                                f && (f = !E.callMethod(t, "setup", e, [l, o, n])), f && (s.nativeHandler = (h = t, function(e, t) {
                                    var n = B(this, h);
                                    e = A.Event(e), n.callHandlers(e, t)
                                }), M() && w.indexOf(t) > -1 && (c = {
                                    passive: !1
                                }), s.removeListener = a.default.listen(e, y[t] || t, s.nativeHandler, c)), E.callMethod(t, "add", e, [d])
                            },
                            removeHandler: function(i, a) {
                                var s = function(t) {
                                    var r, s = n[t];
                                    s.handleObjects.length ? (s.handleObjects = s.handleObjects.filter((function(n) {
                                        var s = o.length && !F(n.namespaces, o) || i && n.handler !== i || a && n.selector !== a;
                                        return s || (r = n.handler, E.callMethod(t, "remove", e, [n])), s
                                    })), !s.handleObjects.length && t !== v && (E.callMethod(t, "teardown", e, [o, r]), s.nativeHandler && s.removeListener(), delete n[t])) : delete n[t]
                                };
                                if (r) {
                                    s(t)
                                } else {
                                    for (var l in n) {
                                        s(l)
                                    }
                                }
                                0 === Object.keys(n).length && D.delete(e)
                            },
                            callHandlers: function(e, t) {
                                var i = !1,
                                    a = function(n) {
                                        i || o.length && !F(n.namespaces, o) || (n.wrappedHandler(e, t), i = e.isImmediatePropagationStopped())
                                    };
                                s.handleObjects.forEach(a), o.length && n.dxEmptyEventType && n.dxEmptyEventType.handleObjects.forEach(a)
                            }
                        }
                    }

                    function F(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            if (e.indexOf(t[n]) < 0) {
                                return !1
                            }
                        }
                        return !0
                    }

                    function V(e) {
                        return function(t, n, i, o, a) {
                            a || (a = o, o = void 0), "string" != typeof i && (o = i, i = void 0), a || "string" != typeof n || (a = o || i, i = void 0, o = void 0), e(t, n, i, o, a)
                        }
                    }

                    function H(e) {
                        return function(t, n, i) {
                            "string" == typeof n && (n = {
                                type: n
                            }), n.target || (n.target = t), n.currentTarget = t, n.delegateTarget || (n.delegateTarget = t), !n.type && n.originalEvent && (n.type = n.originalEvent.type), e(t, n instanceof A.Event ? n : A.Event(n), i)
                        }
                    }

                    function L(e) {
                        var t = function(t, n) {
                            if (n && n.indexOf(" ") > -1) {
                                var i = Array.prototype.slice.call(arguments, 0);
                                n.split(" ").forEach((function(t) {
                                    i[1] = t, e.apply(this, i)
                                }))
                            } else {
                                e.apply(this, arguments)
                            }
                        };
                        return function(e, n) {
                            if ("object" === g(n)) {
                                var i = Array.prototype.slice.call(arguments, 0);
                                for (var o in n) {
                                    i[1] = o, i[i.length - 1] = n[o], t.apply(this, i)
                                }
                            } else {
                                t.apply(this, arguments)
                            }
                        }
                    }

                    function N(e) {
                        if (function(e) {
                                return null == e.which && 0 === e.type.indexOf("key")
                            }(e)) {
                            return null != e.charCode ? e.charCode : e.keyCode
                        }
                        if (function(e) {
                                return !e.which && void 0 !== e.button && /^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(e.type)
                            }(e)) {
                            return {
                                1: 1,
                                2: 3,
                                3: 1,
                                4: 2
                            } [e.button]
                        }
                        return e.which
                    }

                    function z(e) {
                        e && (A.Event = e, A.Event.prototype = e.prototype)
                    }

                    function W(e, t, n) {
                        Object.defineProperty(n || A.Event.prototype, e, {
                            enumerable: !0,
                            configurable: !0,
                            get: function() {
                                return this.originalEvent && t(this.originalEvent)
                            },
                            set: function(t) {
                                Object.defineProperty(this, e, {
                                    enumerable: !0,
                                    configurable: !0,
                                    writable: !0,
                                    value: t
                                })
                            }
                        })
                    }
                    z(function(e) {
                        return A.Event = function(t, n) {
                            if (!(this instanceof A.Event)) {
                                return new A.Event(t, n)
                            }
                            t || (t = {}), "string" == typeof t && (t = {
                                type: t
                            }), n || (n = {}), e.call(this, t, n)
                        }, m(A.Event.prototype, {
                            _propagationStopped: !1,
                            _immediatePropagationStopped: !1,
                            _defaultPrevented: !1,
                            isPropagationStopped: function() {
                                return !!(this._propagationStopped || this.originalEvent && this.originalEvent.propagationStopped)
                            },
                            stopPropagation: function() {
                                this._propagationStopped = !0, this.originalEvent && this.originalEvent.stopPropagation()
                            },
                            isImmediatePropagationStopped: function() {
                                return this._immediatePropagationStopped
                            },
                            stopImmediatePropagation: function() {
                                this.stopPropagation(), this._immediatePropagationStopped = !0, this.originalEvent && this.originalEvent.stopImmediatePropagation()
                            },
                            isDefaultPrevented: function() {
                                return !!(this._defaultPrevented || this.originalEvent && this.originalEvent.defaultPrevented)
                            },
                            preventDefault: function() {
                                this._defaultPrevented = !0, this.originalEvent && this.originalEvent.preventDefault()
                            }
                        }), A.Event
                    }((function(e, t) {
                        var n, i = this;
                        e instanceof A.Event || (0, r.hasWindow)() && e instanceof _.Event || (null === (n = e.view) || void 0 === n ? void 0 : n.Event) && e instanceof e.view.Event ? (i.originalEvent = e, i.type = e.type, i.currentTarget = void 0, i.timeStamp = e.timeStamp || Date.now()) : m(i, e), W("which", N, i), 0 === e.type.indexOf("touch") && (delete t.pageX, delete t.pageY), m(i, t), i.guid = ++T
                    }))), ["target", "relatedTarget", "delegateTarget", "altKey", "bubbles", "cancelable", "changedTouches", "ctrlKey", "detail", "eventPhase", "metaKey", "shiftKey", "view", "char", "code", "charCode", "key", "keyCode", "button", "buttons", "offsetX", "offsetY", "pointerId", "pointerType", "targetTouches", "toElement", "touches"].forEach((function(e) {
                        return W(e, (function(t) {
                            return t[e]
                        }))
                    })), (0, h.default)(W);
                    var q = (0, u.default)(),
                        $ = (0, u.default)();
                    A.set = function(e) {
                        q.fire(), A.inject(e), z(e.Event), $.fire()
                    }, A.subscribeGlobal = function() {
                        O(arguments, V((function() {
                            var e = arguments;
                            A.on.apply(this, e), q.add((function() {
                                var t = Array.prototype.slice.call(e, 0);
                                t.splice(3, 1), A.off.apply(this, t)
                            })), $.add((function() {
                                A.on.apply(this, e)
                            }))
                        })))
                    }, A.forcePassiveFalseEventNames = w, A.passiveEventHandlersSupported = M;
                    var G = A;
                    t.default = G, e.exports = t.default, e.exports.default = t.default
                },
            2418:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/hook_touch_props.js ***!
                  \*****************************************************************************/
                function(e, t) {
                    t.default = function(e) {
                        n.forEach((function(t) {
                            e(t, (function(e) {
                                return function(e, t) {
                                    if (t[e] && !t.touches || !t.touches) {
                                        return t[e]
                                    }
                                    var n = t.touches.length ? t.touches : t.changedTouches;
                                    if (!n.length) {
                                        return
                                    }
                                    return n[0][e]
                                }(t, e)
                            }))
                        }), this)
                    };
                    var n = ["pageX", "pageY", "screenX", "screenY", "clientX", "clientY"];
                    e.exports = t.default, e.exports.default = t.default
                },
            51661:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/keyboard_processor.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = l(n( /*! ../../core/renderer */ 68374)),
                        o = l(n( /*! ../../events/core/events_engine */ 55994)),
                        a = l(n( /*! ../../core/class */ 38377)),
                        r = n( /*! ../../core/utils/array */ 89386),
                        s = n( /*! ../../events/utils/index */ 39611);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = "compositionstart",
                        d = "KeyboardProcessor",
                        c = function(e) {
                            return {
                                keyName: (0, s.normalizeKeyName)(e),
                                key: e.key,
                                code: e.code,
                                ctrl: e.ctrlKey,
                                location: e.location,
                                metaKey: e.metaKey,
                                shift: e.shiftKey,
                                alt: e.altKey,
                                which: e.which,
                                originalEvent: e
                            }
                        },
                        h = a.default.inherit({
                            _keydown: (0, s.addNamespace)("keydown", d),
                            _compositionStart: (0, s.addNamespace)(u, d),
                            _compositionEnd: (0, s.addNamespace)("compositionend", d),
                            ctor: function(e) {
                                var t = this;
                                (e = e || {}).element && (this._element = (0, i.default)(e.element)), e.focusTarget && (this._focusTarget = e.focusTarget), this._handler = e.handler, this._element && (this._processFunction = function(e) {
                                    var n = t._focusTarget && t._focusTarget !== e.target && (0, r.inArray)(e.target, (0, i.default)(t._focusTarget)) < 0,
                                        o = t._isComposingJustFinished && 229 === e.which || t._isComposing || n;
                                    t._isComposingJustFinished = !1, o || t.process(e)
                                }, this._toggleProcessingWithContext = this.toggleProcessing.bind(this), o.default.on(this._element, this._keydown, this._processFunction), o.default.on(this._element, this._compositionStart, this._toggleProcessingWithContext), o.default.on(this._element, this._compositionEnd, this._toggleProcessingWithContext))
                            },
                            dispose: function() {
                                this._element && (o.default.off(this._element, this._keydown, this._processFunction), o.default.off(this._element, this._compositionStart, this._toggleProcessingWithContext), o.default.off(this._element, this._compositionEnd, this._toggleProcessingWithContext)), this._element = void 0, this._handler = void 0
                            },
                            process: function(e) {
                                this._handler(c(e))
                            },
                            toggleProcessing: function(e) {
                                var t = e.type;
                                this._isComposing = t === u, this._isComposingJustFinished = !this._isComposing
                            }
                        });
                    h.createKeyDownOptions = c;
                    var f = h;
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            765:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/wheel.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = s(n( /*! ../../core/renderer */ 68374)),
                        o = s(n( /*! ../../events/core/events_engine */ 55994)),
                        a = s(n( /*! ./event_registrator */ 85788)),
                        r = n( /*! ../utils/index */ 39611);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = "dxmousewheel";
                    t.name = l;
                    var u = "dxWheel",
                        d = {
                            setup: function(e) {
                                var t = (0, i.default)(e);
                                o.default.on(t, (0, r.addNamespace)("wheel", u), d._wheelHandler.bind(d))
                            },
                            teardown: function(e) {
                                o.default.off(e, ".".concat(u))
                            },
                            _wheelHandler: function(e) {
                                var t = e.originalEvent,
                                    n = t.deltaMode,
                                    i = t.deltaY,
                                    o = t.deltaX,
                                    a = t.deltaZ;
                                (0, r.fireEvent)({
                                    type: l,
                                    originalEvent: e,
                                    delta: this._normalizeDelta(i, n),
                                    deltaX: o,
                                    deltaY: i,
                                    deltaZ: a,
                                    deltaMode: n,
                                    pointerType: "mouse"
                                }), e.stopPropagation()
                            },
                            _normalizeDelta: function(e) {
                                var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                                return 0 === t ? -e : -30 * e
                            }
                        };
                    (0, a.default)(l, d)
                },
            85272:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/double_click.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = d(n( /*! ../events/core/events_engine */ 55994)),
                        o = n( /*! ../core/utils/dom */ 3532),
                        a = d(n( /*! ../core/dom_adapter */ 73349)),
                        r = d(n( /*! ../core/class */ 38377)),
                        s = d(n( /*! ./core/event_registrator */ 85788)),
                        l = n( /*! ./click */ 95429),
                        u = n( /*! ./utils/index */ 39611);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dxdblclick";
                    t.name = c;
                    var h = (0, u.addNamespace)(l.name, "dxDblClick"),
                        f = r.default.inherit({
                            ctor: function() {
                                this._handlerCount = 0, this._forgetLastClick()
                            },
                            _forgetLastClick: function() {
                                this._firstClickTarget = null, this._lastClickTimeStamp = -300
                            },
                            add: function() {
                                this._handlerCount <= 0 && i.default.on(a.default.getDocument(), h, this._clickHandler.bind(this)), this._handlerCount++
                            },
                            _clickHandler: function(e) {
                                var t = e.timeStamp || Date.now(),
                                    n = t - this._lastClickTimeStamp;
                                !(n < 0) && n < 300 ? ((0, u.fireEvent)({
                                    type: c,
                                    target: (0, o.closestCommonParent)(this._firstClickTarget, e.target),
                                    originalEvent: e
                                }), this._forgetLastClick()) : (this._firstClickTarget = e.target, this._lastClickTimeStamp = t)
                            },
                            remove: function() {
                                this._handlerCount--, this._handlerCount <= 0 && (this._forgetLastClick(), i.default.off(a.default.getDocument(), h))
                            }
                        });
                    (0, s.default)(c, new f)
                },
            23174:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/drag.js ***!
                  \************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.start = t.move = t.leave = t.enter = t.end = t.drop = void 0;
                    var o = p(n( /*! ../core/renderer */ 68374)),
                        a = n( /*! ../core/element_data */ 97906),
                        r = n( /*! ../core/utils/array */ 89386),
                        s = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var o = {},
                                a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = a ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(o, r, s) : o[r] = e[r]
                                }
                            }
                            o.default = e, n && n.set(e, o);
                            return o
                        }(n( /*! ../core/utils/iterator */ 95479)),
                        l = n( /*! ../core/utils/dom */ 3532),
                        u = p(n( /*! ./core/event_registrator */ 85788)),
                        d = n( /*! ./utils/index */ 39611),
                        c = p(n( /*! ./gesture/emitter.gesture */ 98621)),
                        h = p(n( /*! ./core/emitter_registrator */ 82495));

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var g = "dxdragstart";
                    t.start = g;
                    var m = "dxdrag";
                    t.move = m;
                    var _ = "dxdragend";
                    t.end = _;
                    var v = "dxdragenter";
                    t.enter = v;
                    var y = "dxdragleave";
                    t.leave = y;
                    var b = "dxdrop";
                    t.drop = b;
                    var x = "dxDragEventsCount",
                        w = [],
                        C = [],
                        S = [],
                        k = {
                            setup: function(e, t) {
                                -1 !== (0, r.inArray)(e, w) || (w.push(e), C.push([]), S.push(t || {}))
                            },
                            add: function(e, t) {
                                var n = (0, r.inArray)(e, w);
                                this.updateEventsCounter(e, t.type, 1);
                                var i = t.selector; - 1 === (0, r.inArray)(i, C[n]) && C[n].push(i)
                            },
                            updateEventsCounter: function(e, t, n) {
                                if ([v, y, b].indexOf(t) > -1) {
                                    var i = (0, a.data)(e, x) || 0;
                                    (0, a.data)(e, x, Math.max(0, i + n))
                                }
                            },
                            remove: function(e, t) {
                                this.updateEventsCounter(e, t.type, -1)
                            },
                            teardown: function(e) {
                                if (!(0, a.data)(e, x)) {
                                    var t = (0, r.inArray)(e, w);
                                    w.splice(t, 1), C.splice(t, 1), S.splice(t, 1), (0, a.removeData)(e, x)
                                }
                            }
                        };
                    (0, u.default)(v, k), (0, u.default)(y, k), (0, u.default)(b, k);
                    var I = c.default.inherit({
                        ctor: function(e) {
                            this.callBase(e), this.direction = "both"
                        },
                        _init: function(e) {
                            this._initEvent = e
                        },
                        _start: function(e) {
                            e = this._fireEvent(g, this._initEvent), this._maxLeftOffset = e.maxLeftOffset, this._maxRightOffset = e.maxRightOffset, this._maxTopOffset = e.maxTopOffset, this._maxBottomOffset = e.maxBottomOffset;
                            var t = (0, r.wrapToArray)(e.targetElements || (null === e.targetElements ? [] : w));
                            this._dropTargets = s.map(t, (function(e) {
                                return (0, o.default)(e).get(0)
                            }))
                        },
                        _move: function(e) {
                            var t = (0, d.eventData)(e),
                                n = this._calculateOffset(t);
                            e = this._fireEvent(m, e, {
                                offset: n
                            }), this._processDropTargets(e), e._cancelPreventDefault || e.preventDefault()
                        },
                        _calculateOffset: function(e) {
                            return {
                                x: this._calculateXOffset(e),
                                y: this._calculateYOffset(e)
                            }
                        },
                        _calculateXOffset: function(e) {
                            if ("vertical" !== this.direction) {
                                var t = e.x - this._startEventData.x;
                                return this._fitOffset(t, this._maxLeftOffset, this._maxRightOffset)
                            }
                            return 0
                        },
                        _calculateYOffset: function(e) {
                            if ("horizontal" !== this.direction) {
                                var t = e.y - this._startEventData.y;
                                return this._fitOffset(t, this._maxTopOffset, this._maxBottomOffset)
                            }
                            return 0
                        },
                        _fitOffset: function(e, t, n) {
                            return null != t && (e = Math.max(e, -t)), null != n && (e = Math.min(e, n)), e
                        },
                        _processDropTargets: function(e) {
                            var t = this._findDropTarget(e);
                            t === this._currentDropTarget || (this._fireDropTargetEvent(e, y), this._currentDropTarget = t, this._fireDropTargetEvent(e, v))
                        },
                        _fireDropTargetEvent: function(e, t) {
                            if (this._currentDropTarget) {
                                var n = {
                                    type: t,
                                    originalEvent: e,
                                    draggingElement: this._$element.get(0),
                                    target: this._currentDropTarget
                                };
                                (0, d.fireEvent)(n)
                            }
                        },
                        _findDropTarget: function(e) {
                            var t, n = this;
                            return s.each(w, (function(i, a) {
                                if (n._checkDropTargetActive(a)) {
                                    var l, u, d, c, h = (0, o.default)(a);
                                    s.each((l = h, u = (0, r.inArray)(l.get(0), w), d = C[u].filter((function(e) {
                                        return e
                                    })), c = l.find(d.join(", ")), -1 !== (0, r.inArray)(void 0, C[u]) && (c = c.add(l)), c), (function(i, a) {
                                        var s = (0, o.default)(a);
                                        n._checkDropTarget(function(e) {
                                            var t = (0, r.inArray)(e.get(0), w);
                                            return S[t]
                                        }(h), s, (0, o.default)(t), e) && (t = a)
                                    }))
                                }
                            })), t
                        },
                        _checkDropTargetActive: function(e) {
                            var t = !1;
                            return s.each(this._dropTargets, (function(n, i) {
                                return !(t = t || i === e || (0, l.contains)(i, e))
                            })), t
                        },
                        _checkDropTarget: function(e, t, n, i) {
                            if (t.get(0) === (0, o.default)(i.target).get(0)) {
                                return !1
                            }
                            var a, r, s = (r = t, (a = e).itemPositionFunc ? a.itemPositionFunc(r) : r.offset());
                            if (i.pageX < s.left) {
                                return !1
                            }
                            if (i.pageY < s.top) {
                                return !1
                            }
                            var l = function(e, t) {
                                return e.itemSizeFunc ? e.itemSizeFunc(t) : {
                                    width: t.get(0).getBoundingClientRect().width,
                                    height: t.get(0).getBoundingClientRect().height
                                }
                            }(e, t);
                            return !(i.pageX > s.left + l.width) && !(i.pageY > s.top + l.height) && (!n.length || !n.closest(t).length) && !(e.checkDropTarget && !e.checkDropTarget(t, i)) && t
                        },
                        _end: function(e) {
                            var t = (0, d.eventData)(e);
                            this._fireEvent(_, e, {
                                offset: this._calculateOffset(t)
                            }), this._fireDropTargetEvent(e, b), delete this._currentDropTarget
                        }
                    });
                    (0, h.default)({
                        emitter: I,
                        events: [g, m, _]
                    })
                },
            98621:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/gesture/emitter.gesture.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = g(n( /*! ../../core/renderer */ 68374)),
                        o = g(n( /*! ../../events/core/events_engine */ 55994)),
                        a = g(n( /*! ../../core/devices */ 20530)),
                        r = n( /*! ../../core/utils/style */ 80968),
                        s = g(n( /*! ../../core/utils/call_once */ 39618)),
                        l = n( /*! ../../core/utils/dom */ 3532),
                        u = g(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        d = n( /*! ../../core/utils/math */ 60810),
                        c = n( /*! ../../core/utils/common */ 20576),
                        h = n( /*! ../../core/utils/type */ 35922),
                        f = n( /*! ../utils/index */ 39611),
                        p = g(n( /*! ../core/emitter */ 31391));

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var m = u.default.add,
                        _ = Math.abs,
                        v = 10,
                        y = (0, s.default)((function() {
                            var e = "desktop" === a.default.real().deviceType;
                            if (!(0, r.styleProp)("pointer-events") || !e) {
                                return c.noop
                            }
                            var t = (0, i.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents", "none");
                            return o.default.subscribeGlobal(t, "dxmousewheel", (function(e) {
                                    e.preventDefault()
                                })), m((function() {
                                    t.appendTo("body")
                                })),
                                function(e, n) {
                                    t.css("pointerEvents", e ? "all" : "none"), e && t.css("cursor", n)
                                }
                        })),
                        b = p.default.inherit({
                            gesture: !0,
                            configure: function(e) {
                                this.getElement().css("msTouchAction", e.immediate ? "pinch-zoom" : ""), this.callBase(e)
                            },
                            allowInterruptionByMouseWheel: function() {
                                return 2 !== this._stage
                            },
                            getDirection: function() {
                                return this.direction
                            },
                            _cancel: function() {
                                this.callBase.apply(this, arguments), this._toggleGestureCover(!1), this._stage = 0
                            },
                            start: function(e) {
                                e._needSkipEvent || (0, f.needSkipEvent)(e) ? this._cancel(e) : (this._startEvent = (0, f.createEvent)(e), this._startEventData = (0, f.eventData)(e), this._stage = 1, this._init(e), this._setupImmediateTimer())
                            },
                            _setupImmediateTimer: function() {
                                clearTimeout(this._immediateTimer), this._immediateAccepted = !1, this.immediate && (this._immediateTimer = setTimeout(function() {
                                    this._immediateAccepted = !0
                                }.bind(this), 180))
                            },
                            move: function(e) {
                                if (1 === this._stage && this._directionConfirmed(e)) {
                                    if (this._stage = 2, this._resetActiveElement(), this._toggleGestureCover(!0), this._clearSelection(e), this._adjustStartEvent(e), this._start(this._startEvent), 0 === this._stage) {
                                        return
                                    }
                                    this._requestAccept(e), this._move(e), this._forgetAccept()
                                } else {
                                    2 === this._stage && (this._clearSelection(e), this._move(e))
                                }
                            },
                            _directionConfirmed: function(e) {
                                var t = this._getTouchBoundary(e),
                                    n = (0, f.eventDelta)(this._startEventData, (0, f.eventData)(e)),
                                    i = _(n.x),
                                    o = _(n.y),
                                    a = this._validateMove(t, i, o),
                                    r = this._validateMove(t, o, i),
                                    s = this.getDirection(e);
                                return "both" === s && (a || r) || "horizontal" === s && a || "vertical" === s && r || this._immediateAccepted
                            },
                            _validateMove: function(e, t, n) {
                                return t && t >= e && (!this.immediate || t >= n)
                            },
                            _getTouchBoundary: function(e) {
                                return this.immediate || (0, f.isDxMouseWheelEvent)(e) ? 0 : v
                            },
                            _adjustStartEvent: function(e) {
                                var t = this._getTouchBoundary(e),
                                    n = (0, f.eventDelta)(this._startEventData, (0, f.eventData)(e));
                                this._startEvent.pageX += (0, d.sign)(n.x) * t, this._startEvent.pageY += (0, d.sign)(n.y) * t
                            },
                            _resetActiveElement: function() {
                                "ios" === a.default.real().platform && this.getElement().find(":focus").length && (0, l.resetActiveElement)()
                            },
                            _toggleGestureCover: function(e) {
                                this._toggleGestureCoverImpl(e)
                            },
                            _toggleGestureCoverImpl: function(e) {
                                2 === this._stage && function(e, t) {
                                    y()(e, t)
                                }(e, this.getElement().css("cursor"))
                            },
                            _clearSelection: function(e) {
                                (0, f.isDxMouseWheelEvent)(e) || (0, f.isTouchEvent)(e) || (0, l.clearSelection)()
                            },
                            end: function(e) {
                                this._toggleGestureCover(!1), 2 === this._stage ? this._end(e) : 1 === this._stage && this._stop(e), this._stage = 0
                            },
                            dispose: function() {
                                clearTimeout(this._immediateTimer), this.callBase.apply(this, arguments), this._toggleGestureCover(!1)
                            },
                            _init: c.noop,
                            _start: c.noop,
                            _move: c.noop,
                            _stop: c.noop,
                            _end: c.noop
                        });
                    b.initialTouchBoundary = v, b.touchBoundary = function(e) {
                        if (!(0, h.isDefined)(e)) {
                            return v
                        }
                        v = e
                    };
                    var x = b;
                    t.default = x, e.exports = t.default, e.exports.default = t.default
                },
            37334:
                /*!**************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/gesture/emitter.gesture.scroll.js ***!
                  \**************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = c(n( /*! ../../events/core/events_engine */ 55994)),
                        o = c(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../events/utils/index */ 39611),
                        r = c(n( /*! ../../events/gesture/emitter.gesture */ 98621)),
                        s = c(n( /*! ../../events/core/emitter_registrator */ 82495)),
                        l = n( /*! ../../animation/frame */ 90057),
                        u = c(n( /*! ../../core/devices */ 20530)),
                        d = n( /*! ../../core/utils/version */ 58020);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h, f, p, g = o.default.abstract,
                        m = u.default.real(),
                        _ = "scroll",
                        v = "dxscrollinit",
                        y = "dxscrollstart",
                        b = "dxscroll",
                        x = "dxscrollend",
                        w = "dxscrollstop",
                        C = "dxscrollcancel",
                        S = o.default.inherit((h = (0, a.addNamespace)(_, "dxScrollEmitter"), {
                            ctor: function(e) {
                                var t = this;
                                this._element = e, this._locked = !1, this._proxiedScroll = function(e) {
                                    t._disposed || t._scroll(e)
                                }, i.default.on(this._element, h, this._proxiedScroll)
                            },
                            _scroll: g,
                            check: function(e, t) {
                                this._locked && t()
                            },
                            dispose: function() {
                                this._disposed = !0, i.default.off(this._element, h, this._proxiedScroll)
                            }
                        })),
                        k = S.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this._timeout = t
                            },
                            _scroll: function() {
                                this._prepare(), this._forget()
                            },
                            _prepare: function() {
                                this._timer && this._clearTimer(), this._locked = !0
                            },
                            _clearTimer: function() {
                                clearTimeout(this._timer), this._locked = !1, this._timer = null
                            },
                            _forget: function() {
                                var e = this;
                                this._timer = setTimeout((function() {
                                    e._clearTimer()
                                }), this._timeout)
                            },
                            dispose: function() {
                                this.callBase(), this._clearTimer()
                            }
                        }),
                        I = k.inherit({
                            ctor: function(e) {
                                this.callBase(e, 400), this._lastWheelDirection = null
                            },
                            check: function(e, t) {
                                this._checkDirectionChanged(e), this.callBase(e, t)
                            },
                            _checkDirectionChanged: function(e) {
                                if ((0, a.isDxMouseWheelEvent)(e)) {
                                    var t = e.shiftKey || !1,
                                        n = null !== this._lastWheelDirection && t !== this._lastWheelDirection;
                                    this._lastWheelDirection = t, this._locked = this._locked && !n
                                } else {
                                    this._lastWheelDirection = null
                                }
                            }
                        }),
                        D = k.inherit({
                            ctor: function(e) {
                                this.callBase(e, 400)
                            }
                        });
                    f = m.ios && (0, d.compare)(m.version, [8]) >= 0, p = m.android && (0, d.compare)(m.version, [5]) >= 0, (f || p) && (D = S.inherit({
                        _scroll: function() {
                            this._locked = !0;
                            var e = this;
                            (0, l.cancelAnimationFrame)(this._scrollFrame), this._scrollFrame = (0, l.requestAnimationFrame)((function() {
                                e._locked = !1
                            }))
                        },
                        check: function(e, t) {
                            (0, l.cancelAnimationFrame)(this._scrollFrame), (0, l.cancelAnimationFrame)(this._checkFrame);
                            var n = this,
                                i = this.callBase;
                            this._checkFrame = (0, l.requestAnimationFrame)((function() {
                                i.call(n, e, t), n._locked = !1
                            }))
                        },
                        dispose: function() {
                            this.callBase(), (0, l.cancelAnimationFrame)(this._scrollFrame), (0, l.cancelAnimationFrame)(this._checkFrame)
                        }
                    }));
                    var T, E = r.default.inherit((T = Math.round(1e3 / 60), {
                        ctor: function(e) {
                            this.callBase.apply(this, arguments), this.direction = "both", this._pointerLocker = new D(e), this._wheelLocker = new I(e)
                        },
                        validate: function() {
                            return !0
                        },
                        configure: function(e) {
                            e.scrollTarget && (this._pointerLocker.dispose(), this._wheelLocker.dispose(), this._pointerLocker = new D(e.scrollTarget), this._wheelLocker = new I(e.scrollTarget)), this.callBase(e)
                        },
                        _init: function(e) {
                            this._wheelLocker.check(e, function() {
                                (0, a.isDxMouseWheelEvent)(e) && this._accept(e)
                            }.bind(this)), this._pointerLocker.check(e, function() {
                                var t = this.isNative && (0, a.isMouseEvent)(e);
                                (0, a.isDxMouseWheelEvent)(e) || t || this._accept(e)
                            }.bind(this)), this._fireEvent(v, e), this._prevEventData = (0, a.eventData)(e)
                        },
                        move: function(e) {
                            this.callBase.apply(this, arguments), e.isScrollingEvent = this.isNative || e.isScrollingEvent
                        },
                        _start: function(e) {
                            this._savedEventData = (0, a.eventData)(e), this._fireEvent(y, e), this._prevEventData = (0, a.eventData)(e)
                        },
                        _move: function(e) {
                            var t = (0, a.eventData)(e);
                            this._fireEvent(b, e, {
                                delta: (0, a.eventDelta)(this._prevEventData, t)
                            }), (0, a.eventDelta)(this._savedEventData, t).time > 200 && (this._savedEventData = this._prevEventData), this._prevEventData = (0, a.eventData)(e)
                        },
                        _end: function(e) {
                            var t = (0, a.eventDelta)(this._prevEventData, (0, a.eventData)(e)),
                                n = {
                                    x: 0,
                                    y: 0
                                };
                            if (!(0, a.isDxMouseWheelEvent)(e) && t.time < 100) {
                                var i = (0, a.eventDelta)(this._savedEventData, this._prevEventData),
                                    o = T / i.time;
                                n = {
                                    x: i.x * o,
                                    y: i.y * o
                                }
                            }
                            this._fireEvent(x, e, {
                                velocity: n
                            })
                        },
                        _stop: function(e) {
                            this._fireEvent(w, e)
                        },
                        cancel: function(e) {
                            this.callBase.apply(this, arguments), this._fireEvent(C, e)
                        },
                        dispose: function() {
                            this.callBase.apply(this, arguments), this._pointerLocker.dispose(), this._wheelLocker.dispose()
                        },
                        _clearSelection: function() {
                            if (!this.isNative) {
                                return this.callBase.apply(this, arguments)
                            }
                        },
                        _toggleGestureCover: function() {
                            if (!this.isNative) {
                                return this.callBase.apply(this, arguments)
                            }
                        }
                    }));
                    (0, s.default)({
                        emitter: E,
                        events: [v, y, b, x, w, C]
                    });
                    var A = {
                        init: v,
                        start: y,
                        move: b,
                        end: x,
                        stop: w,
                        cancel: C,
                        scroll: _
                    };
                    t.default = A, e.exports = t.default, e.exports.default = t.default
                },
            66894:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/gesture/swipeable.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../swipe */ 34309),
                        o = d(n( /*! ../../events/core/events_engine */ 55994)),
                        a = d(n( /*! ../../core/dom_component */ 13046)),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../utils/index */ 39611),
                        l = n( /*! ../../core/utils/extend */ 13306),
                        u = n( /*! ../../core/utils/public_component */ 9321);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = {
                            onStart: i.start,
                            onUpdated: i.swipe,
                            onEnd: i.end,
                            onCancel: "dxswipecancel"
                        },
                        f = a.default.inherit({
                            _getDefaultOptions: function() {
                                return (0, l.extend)(this.callBase(), {
                                    elastic: !0,
                                    immediate: !1,
                                    direction: "horizontal",
                                    itemSizeFunc: null,
                                    onStart: null,
                                    onUpdated: null,
                                    onEnd: null,
                                    onCancel: null
                                })
                            },
                            _render: function() {
                                this.callBase(), this.$element().addClass("dx-swipeable"), this._attachEventHandlers()
                            },
                            _attachEventHandlers: function() {
                                if (this._detachEventHandlers(), !this.option("disabled")) {
                                    var e = this.NAME;
                                    this._createEventData(), (0, r.each)(h, function(t, n) {
                                        var i = this._createActionByOption(t, {
                                            context: this
                                        });
                                        n = (0, s.addNamespace)(n, e), o.default.on(this.$element(), n, this._eventData, (function(e) {
                                            return i({
                                                event: e
                                            })
                                        }))
                                    }.bind(this))
                                }
                            },
                            _createEventData: function() {
                                this._eventData = {
                                    elastic: this.option("elastic"),
                                    itemSizeFunc: this.option("itemSizeFunc"),
                                    direction: this.option("direction"),
                                    immediate: this.option("immediate")
                                }
                            },
                            _detachEventHandlers: function() {
                                o.default.off(this.$element(), ".dxSwipeable")
                            },
                            _optionChanged: function(e) {
                                switch (e.name) {
                                    case "disabled":
                                    case "onStart":
                                    case "onUpdated":
                                    case "onEnd":
                                    case "onCancel":
                                    case "elastic":
                                    case "immediate":
                                    case "itemSizeFunc":
                                    case "direction":
                                        this._detachEventHandlers(), this._attachEventHandlers();
                                        break;
                                    case "rtlEnabled":
                                        break;
                                    default:
                                        this.callBase(e)
                                }
                            },
                            _useTemplates: function() {
                                return !1
                            }
                        });
                    (0, u.name)(f, "dxSwipeable");
                    var p = f;
                    t.default = p, e.exports = t.default, e.exports.default = t.default
                },
            11699:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/hold.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/index */ 39611),
                        o = r(n( /*! ./core/emitter */ 31391)),
                        a = r(n( /*! ./core/emitter_registrator */ 82495));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = Math.abs,
                        l = "dxhold",
                        u = o.default.inherit({
                            start: function(e) {
                                this._startEventData = (0, i.eventData)(e), this._startTimer(e)
                            },
                            _startTimer: function(e) {
                                var t = "timeout" in this ? this.timeout : 750;
                                this._holdTimer = setTimeout(function() {
                                    this._requestAccept(e), this._fireEvent(l, e, {
                                        target: e.target
                                    }), this._forgetAccept()
                                }.bind(this), t)
                            },
                            move: function(e) {
                                this._touchWasMoved(e) && this._cancel(e)
                            },
                            _touchWasMoved: function(e) {
                                var t = (0, i.eventDelta)(this._startEventData, (0, i.eventData)(e));
                                return s(t.x) > 5 || s(t.y) > 5
                            },
                            end: function() {
                                this._stopTimer()
                            },
                            _stopTimer: function() {
                                clearTimeout(this._holdTimer)
                            },
                            cancel: function() {
                                this._stopTimer()
                            },
                            dispose: function() {
                                this._stopTimer()
                            }
                        });
                    (0, a.default)({
                        emitter: u,
                        bubble: !0,
                        events: [l]
                    });
                    var d = {
                        name: l
                    };
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            24028:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/hover.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.start = t.end = void 0;
                    var i = d(n( /*! ../events/core/events_engine */ 55994)),
                        o = n( /*! ../core/element_data */ 97906),
                        a = d(n( /*! ../core/class */ 38377)),
                        r = d(n( /*! ../core/devices */ 20530)),
                        s = d(n( /*! ./core/event_registrator */ 85788)),
                        l = n( /*! ./utils/index */ 39611),
                        u = d(n( /*! ./pointer */ 93786));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dxHoverStart",
                        h = "dxhoverstart";
                    t.start = h;
                    var f = (0, l.addNamespace)(u.default.enter, c),
                        p = "dxHoverEnd",
                        g = "dxhoverend";
                    t.end = g;
                    var m = (0, l.addNamespace)(u.default.leave, p),
                        _ = a.default.inherit({
                            noBubble: !0,
                            ctor: function() {
                                this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
                            },
                            setup: function(e) {
                                (0, o.data)(e, this._handlerArrayKeyPath, {})
                            },
                            add: function(e, t) {
                                var n = this,
                                    a = function(e) {
                                        n._handler(e)
                                    };
                                i.default.on(e, this._originalEventName, t.selector, a), (0, o.data)(e, this._handlerArrayKeyPath)[t.guid] = a
                            },
                            _handler: function(e) {
                                (0, l.isTouchEvent)(e) || r.default.isSimulator() || (0, l.fireEvent)({
                                    type: this._eventName,
                                    originalEvent: e,
                                    delegateTarget: e.delegateTarget
                                })
                            },
                            remove: function(e, t) {
                                var n = (0, o.data)(e, this._handlerArrayKeyPath)[t.guid];
                                i.default.off(e, this._originalEventName, t.selector, n)
                            },
                            teardown: function(e) {
                                (0, o.removeData)(e, this._handlerArrayKeyPath)
                            }
                        }),
                        v = _.inherit({
                            ctor: function() {
                                this._eventNamespace = c, this._eventName = h, this._originalEventName = f, this.callBase()
                            },
                            _handler: function(e) {
                                (e.pointers || []).length || this.callBase(e)
                            }
                        }),
                        y = _.inherit({
                            ctor: function() {
                                this._eventNamespace = p, this._eventName = g, this._originalEventName = m, this.callBase()
                            }
                        });
                    (0, s.default)(h, new v), (0, s.default)(g, new y)
                },
            66365:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/index.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.triggerHandler = t.trigger = t.one = t.on = t.off = t.Event = void 0;
                    var i, o = (i = n( /*! ./core/events_engine */ 55994)) && i.__esModule ? i : {
                        default: i
                    };
                    var a = o.default.on;
                    t.on = a;
                    var r = o.default.one;
                    t.one = r;
                    var s = o.default.off;
                    t.off = s;
                    var l = o.default.trigger;
                    t.trigger = l;
                    var u = o.default.triggerHandler;
                    t.triggerHandler = u;
                    var d = o.default.Event;
                    t.Event = d
                },
            93786:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.default = void 0;
                    var o = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var o = {},
                                a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = a ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(o, r, s) : o[r] = e[r]
                                }
                            }
                            o.default = e, n && n.set(e, o);
                            return o
                        }(n( /*! ../core/utils/support */ 60137)),
                        a = n( /*! ../core/utils/iterator */ 95479),
                        r = c(n( /*! ../core/devices */ 20530)),
                        s = c(n( /*! ./core/event_registrator */ 85788)),
                        l = c(n( /*! ./pointer/touch */ 69120)),
                        u = c(n( /*! ./pointer/mouse */ 66509)),
                        d = c(n( /*! ./pointer/mouse_and_touch */ 87720));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f = function(e, t) {
                        var n = t.tablet,
                            i = t.phone;
                        return !e.touch || n || i ? e.touch ? l.default : u.default : d.default
                    }(o, r.default.real());
                    (0, a.each)(f.map, (function(e, t) {
                        (0, s.default)(e, new f(e, t))
                    }));
                    t.default = {
                        down: "dxpointerdown",
                        up: "dxpointerup",
                        move: "dxpointermove",
                        cancel: "dxpointercancel",
                        enter: "dxpointerenter",
                        leave: "dxpointerleave",
                        over: "dxpointerover",
                        out: "dxpointerout"
                    }, e.exports = t.default, e.exports.default = t.default
                },
            88136:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/base.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = l(n( /*! ../../events/core/events_engine */ 55994)),
                        o = l(n( /*! ../../core/utils/browser */ 47810)),
                        a = l(n( /*! ../../core/dom_adapter */ 73349)),
                        r = l(n( /*! ../../core/class */ 38377)),
                        s = n( /*! ../utils/index */ 39611);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = r.default.inherit({
                        ctor: function(e, t) {
                            this._eventName = e, this._originalEvents = (0, s.addNamespace)(t, "dxPointerEvents"), this._handlerCount = 0, this.noBubble = this._isNoBubble()
                        },
                        _isNoBubble: function() {
                            var e = this._eventName;
                            return "dxpointerenter" === e || "dxpointerleave" === e
                        },
                        _handler: function(e) {
                            var t = this._getDelegateTarget(e);
                            return this._fireEvent({
                                type: this._eventName,
                                pointerType: e.pointerType || (0, s.eventSource)(e),
                                originalEvent: e,
                                delegateTarget: t,
                                timeStamp: o.default.mozilla ? (new Date).getTime() : e.timeStamp
                            })
                        },
                        _getDelegateTarget: function(e) {
                            var t;
                            return this.noBubble && (t = e.delegateTarget), t
                        },
                        _fireEvent: function(e) {
                            return (0, s.fireEvent)(e)
                        },
                        _setSelector: function(e) {
                            this._selector = this.noBubble && e ? e.selector : null
                        },
                        _getSelector: function() {
                            return this._selector
                        },
                        setup: function() {
                            return !0
                        },
                        add: function(e, t) {
                            if (this._handlerCount <= 0 || this.noBubble) {
                                e = this.noBubble ? e : a.default.getDocument(), this._setSelector(t);
                                var n = this;
                                i.default.on(e, this._originalEvents, this._getSelector(), (function(e) {
                                    n._handler(e)
                                }))
                            }
                            this.noBubble || this._handlerCount++
                        },
                        remove: function(e) {
                            this._setSelector(e), this.noBubble || this._handlerCount--
                        },
                        teardown: function(e) {
                            this._handlerCount && !this.noBubble || (e = this.noBubble ? e : a.default.getDocument(), ".dxPointerEvents" !== this._originalEvents && i.default.off(e, this._originalEvents, this._getSelector()))
                        },
                        dispose: function(e) {
                            e = this.noBubble ? e : a.default.getDocument(), i.default.off(e, this._originalEvents)
                        }
                    });
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            66509:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/extend */ 13306),
                        o = r(n( /*! ./base */ 88136)),
                        a = r(n( /*! ./observer */ 25544));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s, l = {
                            dxpointerdown: "mousedown",
                            dxpointermove: "mousemove",
                            dxpointerup: "mouseup",
                            dxpointercancel: "",
                            dxpointerover: "mouseover",
                            dxpointerout: "mouseout",
                            dxpointerenter: "mouseenter",
                            dxpointerleave: "mouseleave"
                        },
                        u = function(e) {
                            return e.pointerId = 1, {
                                pointers: s.pointers(),
                                pointerId: 1
                            }
                        },
                        d = !1,
                        c = function() {
                            d || (s = new a.default(l, (function() {
                                return !0
                            })), d = !0)
                        },
                        h = o.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), c()
                            },
                            _fireEvent: function(e) {
                                return this.callBase((0, i.extend)(u(e.originalEvent), e))
                            }
                        });
                    h.map = l, h.normalize = u, h.activate = c, h.resetObserver = function() {
                        s.reset()
                    };
                    var f = h;
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            87720:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse_and_touch.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/extend */ 13306),
                        o = l(n( /*! ./base */ 88136)),
                        a = l(n( /*! ./mouse */ 66509)),
                        r = l(n( /*! ./touch */ 69120)),
                        s = n( /*! ../utils/index */ 39611);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = !1,
                        d = function() {
                            u || (a.default.activate(), u = !0)
                        },
                        c = o.default.inherit({
                            EVENT_LOCK_TIMEOUT: 100,
                            ctor: function() {
                                this.callBase.apply(this, arguments), d()
                            },
                            _handler: function(e) {
                                var t = (0, s.isMouseEvent)(e);
                                if (t || (this._skipNextEvents = !0), !t || !this._mouseLocked) {
                                    if (!t || !this._skipNextEvents) {
                                        return this.callBase(e)
                                    }
                                    this._skipNextEvents = !1, this._mouseLocked = !0, clearTimeout(this._unlockMouseTimer);
                                    var n = this;
                                    this._unlockMouseTimer = setTimeout((function() {
                                        n._mouseLocked = !1
                                    }), this.EVENT_LOCK_TIMEOUT)
                                }
                            },
                            _fireEvent: function(e) {
                                var t = (0, s.isMouseEvent)(e.originalEvent) ? a.default.normalize : r.default.normalize;
                                return this.callBase((0, i.extend)(t(e.originalEvent), e))
                            },
                            dispose: function() {
                                this.callBase(), this._skipNextEvents = !1, this._mouseLocked = !1, clearTimeout(this._unlockMouseTimer)
                            }
                        });
                    c.map = {
                        dxpointerdown: "touchstart mousedown",
                        dxpointermove: "touchmove mousemove",
                        dxpointerup: "touchend mouseup",
                        dxpointercancel: "touchcancel",
                        dxpointerover: "mouseover",
                        dxpointerout: "mouseout",
                        dxpointerenter: "mouseenter",
                        dxpointerleave: "mouseleave"
                    }, c.resetObserver = a.default.resetObserver;
                    var h = c;
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            25544:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/observer.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/iterator */ 95479),
                        o = r(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        a = r(n( /*! ../../core/dom_adapter */ 73349));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = function(e, t) {
                        o.default.add((function() {
                            e.split(" ").forEach((function(e) {
                                a.default.listen(a.default.getDocument(), e, t, !0)
                            }))
                        }))
                    };
                    t.default = function(e, t, n) {
                        n = n || function() {};
                        var o = [],
                            a = function(e) {
                                var n = -1;
                                return (0, i.each)(o, (function(i, o) {
                                    return !t(e, o) || (n = i, !1)
                                })), n
                            },
                            r = function(e) {
                                var t = a(e);
                                t > -1 && o.splice(t, 1)
                            };
                        s(e.dxpointerdown, (function(e) {
                            -1 === a(e) && (n(e), o.push(e))
                        })), s(e.dxpointermove, (function(e) {
                            o[a(e)] = e
                        })), s(e.dxpointerup, r), s(e.dxpointercancel, r), this.pointers = function() {
                            return o
                        }, this.reset = function() {
                            o = []
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            69120:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/touch.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../../core/devices */ 20530)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = n( /*! ../../core/utils/iterator */ 95479),
                        r = s(n( /*! ./base */ 88136));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = function(e) {
                            var t = [];
                            return (0, a.each)(e.touches, (function(e, n) {
                                t.push((0, o.extend)({
                                    pointerId: n.identifier
                                }, n))
                            })), {
                                pointers: t,
                                pointerId: e.changedTouches[0].identifier
                            }
                        },
                        u = function(e) {
                            return "ios" === i.default.real().platform && ("dxpointerdown" === e || "dxpointerup" === e)
                        },
                        d = r.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._pointerId = 0
                            },
                            _handler: function(e) {
                                if (u(this._eventName)) {
                                    var t = e.changedTouches[0];
                                    if (this._pointerId === t.identifier && 0 !== this._pointerId) {
                                        return
                                    }
                                    this._pointerId = t.identifier
                                }
                                return this.callBase.apply(this, arguments)
                            },
                            _fireEvent: function(e) {
                                return this.callBase((0, o.extend)(l(e.originalEvent), e))
                            }
                        });
                    d.map = {
                        dxpointerdown: "touchstart",
                        dxpointermove: "touchmove",
                        dxpointerup: "touchend",
                        dxpointercancel: "touchcancel",
                        dxpointerover: "",
                        dxpointerout: "",
                        dxpointerenter: "",
                        dxpointerleave: ""
                    }, d.normalize = l;
                    var c = d;
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            72918:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/short.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.visibility = t.resize = t.keyboard = t.hover = t.focus = t.dxClick = t.click = t.active = void 0;
                    var i = s(n( /*! ../core/dom_adapter */ 73349)),
                        o = s(n( /*! ./core/events_engine */ 55994)),
                        a = s(n( /*! ./core/keyboard_processor */ 51661)),
                        r = n( /*! ./utils/index */ 39611);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function l(e, t) {
                        return t ? (0, r.addNamespace)(e, t) : e
                    }

                    function u(e, t) {
                        return "function" == typeof e ? e(t) : e.execute(t)
                    }
                    var d = {
                        on: function(e, t, n, i) {
                            var a = i.selector,
                                r = i.showTimeout,
                                s = i.hideTimeout,
                                d = i.namespace;
                            o.default.on(e, l("dxactive", d), a, {
                                timeout: r
                            }, (function(e) {
                                return u(t, {
                                    event: e,
                                    element: e.currentTarget
                                })
                            })), o.default.on(e, l("dxinactive", d), a, {
                                timeout: s
                            }, (function(e) {
                                return u(n, {
                                    event: e,
                                    element: e.currentTarget
                                })
                            }))
                        },
                        off: function(e, t) {
                            var n = t.namespace,
                                i = t.selector;
                            o.default.off(e, l("dxactive", n), i), o.default.off(e, l("dxinactive", n), i)
                        }
                    };
                    t.active = d;
                    var c = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            o.default.on(e, l("dxresize", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            o.default.off(e, l("dxresize", n))
                        }
                    };
                    t.resize = c;
                    var h = {
                        on: function(e, t, n, i) {
                            var a = i.selector,
                                r = i.namespace;
                            o.default.on(e, l("dxhoverend", r), a, (function(e) {
                                return n(e)
                            })), o.default.on(e, l("dxhoverstart", r), a, (function(e) {
                                return u(t, {
                                    element: e.target,
                                    event: e
                                })
                            }))
                        },
                        off: function(e, t) {
                            var n = t.selector,
                                i = t.namespace;
                            o.default.off(e, l("dxhoverstart", i), n), o.default.off(e, l("dxhoverend", i), n)
                        }
                    };
                    t.hover = h;
                    var f = {
                        on: function(e, t, n, i) {
                            var a = i.namespace;
                            o.default.on(e, l("dxhiding", a), n), o.default.on(e, l("dxshown", a), t)
                        },
                        off: function(e, t) {
                            var n = t.namespace;
                            o.default.off(e, l("dxhiding", n)), o.default.off(e, l("dxshown", n))
                        }
                    };
                    t.visibility = f;
                    var p = {
                        on: function(e, t, n, a) {
                            var r = a.namespace,
                                s = a.isFocusable;
                            o.default.on(e, l("focusin", r), t), o.default.on(e, l("focusout", r), n), i.default.hasDocumentProperty("onbeforeactivate") && o.default.on(e, l("beforeactivate", r), (function(e) {
                                return s(null, e.target) || e.preventDefault()
                            }))
                        },
                        off: function(e, t) {
                            var n = t.namespace;
                            o.default.off(e, l("focusin", n)), o.default.off(e, l("focusout", n)), i.default.hasDocumentProperty("onbeforeactivate") && o.default.off(e, l("beforeactivate", n))
                        },
                        trigger: function(e) {
                            return o.default.trigger(e, "focus")
                        }
                    };
                    t.focus = p;
                    var g = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            o.default.on(e, l("dxclick", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            o.default.off(e, l("dxclick", n))
                        }
                    };
                    t.dxClick = g;
                    var m = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            o.default.on(e, l("click", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            o.default.off(e, l("click", n))
                        }
                    };
                    t.click = m;
                    var _ = 0,
                        v = {},
                        y = {
                            on: function(e, t, n) {
                                var i = "keyboardProcessorId".concat(_++);
                                return v[i] = new a.default({
                                    element: e,
                                    focusTarget: t,
                                    handler: n
                                }), i
                            },
                            off: function(e) {
                                e && v[e] && (v[e].dispose(), delete v[e])
                            },
                            _getProcessor: function(e) {
                                return v[e]
                            }
                        };
                    t.keyboard = y
                },
            34309:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/swipe.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.swipe = t.start = t.end = void 0;
                    var i = n( /*! ../core/utils/size */ 58664),
                        o = n( /*! ./utils/index */ 39611),
                        a = s(n( /*! ./gesture/emitter.gesture */ 98621)),
                        r = s(n( /*! ./core/emitter_registrator */ 82495));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = "dxswipestart";
                    t.start = l;
                    var u = "dxswipe";
                    t.swipe = u;
                    var d = "dxswipeend";
                    t.end = d;
                    var c = {
                            horizontal: {
                                defaultItemSizeFunc: function() {
                                    return (0, i.getWidth)(this.getElement())
                                },
                                getBounds: function() {
                                    return [this._maxLeftOffset, this._maxRightOffset]
                                },
                                calcOffsetRatio: function(e) {
                                    return ((0, o.eventData)(e).x - (this._savedEventData && this._savedEventData.x || 0)) / this._itemSizeFunc().call(this, e)
                                },
                                isFastSwipe: function(e) {
                                    var t = (0, o.eventData)(e);
                                    return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(t.x - this._tickData.x) >= t.time - this._tickData.time
                                }
                            },
                            vertical: {
                                defaultItemSizeFunc: function() {
                                    return (0, i.getHeight)(this.getElement())
                                },
                                getBounds: function() {
                                    return [this._maxTopOffset, this._maxBottomOffset]
                                },
                                calcOffsetRatio: function(e) {
                                    return ((0, o.eventData)(e).y - (this._savedEventData && this._savedEventData.y || 0)) / this._itemSizeFunc().call(this, e)
                                },
                                isFastSwipe: function(e) {
                                    var t = (0, o.eventData)(e);
                                    return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(t.y - this._tickData.y) >= t.time - this._tickData.time
                                }
                            }
                        },
                        h = a.default.inherit({
                            TICK_INTERVAL: 300,
                            FAST_SWIPE_SPEED_LIMIT: 10,
                            ctor: function(e) {
                                this.callBase(e), this.direction = "horizontal", this.elastic = !0
                            },
                            _getStrategy: function() {
                                return c[this.direction]
                            },
                            _defaultItemSizeFunc: function() {
                                return this._getStrategy().defaultItemSizeFunc.call(this)
                            },
                            _itemSizeFunc: function() {
                                return this.itemSizeFunc || this._defaultItemSizeFunc
                            },
                            _init: function(e) {
                                this._tickData = (0, o.eventData)(e)
                            },
                            _start: function(e) {
                                this._savedEventData = (0, o.eventData)(e), (e = this._fireEvent(l, e)).cancel || (this._maxLeftOffset = e.maxLeftOffset, this._maxRightOffset = e.maxRightOffset, this._maxTopOffset = e.maxTopOffset, this._maxBottomOffset = e.maxBottomOffset)
                            },
                            _move: function(e) {
                                var t = this._getStrategy(),
                                    n = (0, o.eventData)(e),
                                    i = t.calcOffsetRatio.call(this, e);
                                i = this._fitOffset(i, this.elastic), n.time - this._tickData.time > this.TICK_INTERVAL && (this._tickData = n), this._fireEvent(u, e, {
                                    offset: i
                                }), e.preventDefault()
                            },
                            _end: function(e) {
                                var t = this._getStrategy(),
                                    n = t.calcOffsetRatio.call(this, e),
                                    i = t.isFastSwipe.call(this, e),
                                    o = n,
                                    a = this._calcTargetOffset(n, i);
                                o = this._fitOffset(o, this.elastic), a = this._fitOffset(a, !1), this._fireEvent(d, e, {
                                    offset: o,
                                    targetOffset: a
                                })
                            },
                            _fitOffset: function(e, t) {
                                var n = this._getStrategy().getBounds.call(this);
                                return e < -n[0] ? t ? (-2 * n[0] + e) / 3 : -n[0] : e > n[1] ? t ? (2 * n[1] + e) / 3 : n[1] : e
                            },
                            _calcTargetOffset: function(e, t) {
                                var n;
                                return t ? (n = Math.ceil(Math.abs(e)), e < 0 && (n = -n)) : n = Math.round(e), n
                            }
                        });
                    (0, r.default)({
                        emitter: h,
                        events: [l, u, d]
                    })
                },
            91093:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/transform.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.zoomstart = t.zoomend = t.zoom = t.translatestart = t.translateend = t.translate = t.transformstart = t.transformend = t.transform = t.rotatestart = t.rotateend = t.rotate = t.pinchstart = t.pinchend = t.pinch = void 0;
                    var o = n( /*! ../core/utils/math */ 60810),
                        a = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var o = {},
                                a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = a ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(o, r, s) : o[r] = e[r]
                                }
                            }
                            o.default = e, n && n.set(e, o);
                            return o
                        }(n( /*! ../core/utils/iterator */ 95479)),
                        r = n( /*! ./utils/index */ 39611),
                        s = u(n( /*! ./core/emitter */ 31391)),
                        l = u(n( /*! ./core/emitter_registrator */ 82495));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dx",
                        h = "start",
                        f = "",
                        p = "end",
                        g = [],
                        m = function(e, t) {
                            g.push({
                                name: e,
                                args: t
                            })
                        };
                    m("transform", {
                        scale: !0,
                        deltaScale: !0,
                        rotation: !0,
                        deltaRotation: !0,
                        translation: !0,
                        deltaTranslation: !0
                    }), m("translate", {
                        translation: !0,
                        deltaTranslation: !0
                    }), m("pinch", {
                        scale: !0,
                        deltaScale: !0
                    }), m("rotate", {
                        rotation: !0,
                        deltaRotation: !0
                    });
                    var _ = function(e) {
                            var t, n, i = e.pointers;
                            return t = i[0], {
                                x: (n = i[1]).pageX - t.pageX,
                                y: -n.pageY + t.pageY,
                                centerX: .5 * (n.pageX + t.pageX),
                                centerY: .5 * (n.pageY + t.pageY)
                            }
                        },
                        v = function(e) {
                            return Math.sqrt(e.x * e.x + e.y * e.y)
                        },
                        y = function(e, t) {
                            return v(e) / v(t)
                        },
                        b = function(e, t) {
                            var n = e.x * t.x + e.y * t.y,
                                i = v(e) * v(t);
                            return 0 === i ? 0 : (0, o.sign)(e.x * t.y - t.x * e.y) * Math.acos((0, o.fitIntoRange)(n / i, -1, 1))
                        },
                        x = function(e, t) {
                            return {
                                x: e.centerX - t.centerX,
                                y: e.centerY - t.centerY
                            }
                        },
                        w = s.default.inherit({
                            validatePointers: function(e) {
                                return (0, r.hasTouches)(e) > 1
                            },
                            start: function(e) {
                                this._accept(e);
                                var t = _(e);
                                this._startVector = t, this._prevVector = t, this._fireEventAliases(h, e)
                            },
                            move: function(e) {
                                var t = _(e),
                                    n = this._getEventArgs(t);
                                this._fireEventAliases(f, e, n), this._prevVector = t
                            },
                            end: function(e) {
                                var t = this._getEventArgs(this._prevVector);
                                this._fireEventAliases(p, e, t)
                            },
                            _getEventArgs: function(e) {
                                return {
                                    scale: y(e, this._startVector),
                                    deltaScale: y(e, this._prevVector),
                                    rotation: b(e, this._startVector),
                                    deltaRotation: b(e, this._prevVector),
                                    translation: x(e, this._startVector),
                                    deltaTranslation: x(e, this._prevVector)
                                }
                            },
                            _fireEventAliases: function(e, t, n) {
                                n = n || {}, a.each(g, function(i, o) {
                                    var r = {};
                                    a.each(o.args, (function(e) {
                                        e in n && (r[e] = n[e])
                                    })), this._fireEvent(c + o.name + e, t, r)
                                }.bind(this))
                            }
                        }),
                        C = g.reduce((function(e, t) {
                            return [h, f, p].forEach((function(n) {
                                e.push(c + t.name + n)
                            })), e
                        }), []);
                    (0, l.default)({
                        emitter: w,
                        events: C
                    });
                    var S = {};
                    a.each(C, (function(e, t) {
                        S[t.substring(c.length)] = t
                    }));
                    var k = S.transformstart,
                        I = S.transform,
                        D = S.transformend,
                        T = S.translatestart,
                        E = S.translate,
                        A = S.translateend,
                        O = S.zoomstart,
                        P = S.zoom,
                        M = S.zoomend,
                        R = S.pinchstart,
                        B = S.pinch,
                        F = S.pinchend,
                        V = S.rotatestart,
                        H = S.rotate,
                        L = S.rotateend;
                    t.rotateend = L, t.rotate = H, t.rotatestart = V, t.pinchend = F, t.pinch = B, t.pinchstart = R, t.zoomend = M, t.zoom = P, t.zoomstart = O, t.translateend = A, t.translate = E, t.translatestart = T, t.transformend = D, t.transform = I, t.transformstart = k
                },
            19141:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/add_namespace.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = (i = n( /*! ../../core/errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    t.default = function e(t, n) {
                        if (!n) {
                            throw o.default.Error("E0017")
                        }
                        return Array.isArray(t) ? t.map((function(t) {
                            return e(t, n)
                        })).join(" ") : -1 !== t.indexOf(" ") ? e(t.split(/\s+/g), n) : "".concat(t, ".").concat(n)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            27575:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/event_nodes_disposing.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.unsubscribeNodesDisposing = t.subscribeNodesDisposing = void 0;
                    var i, o = (i = n( /*! ../core/events_engine */ 55994)) && i.__esModule ? i : {
                        default: i
                    };
                    var a = "dxremove";

                    function r(e) {
                        return e && [e.target, e.delegateTarget, e.relatedTarget, e.currentTarget].filter((function(e) {
                            return !!e
                        }))
                    }
                    t.subscribeNodesDisposing = function(e, t) {
                        o.default.one(r(e), a, t)
                    };
                    t.unsubscribeNodesDisposing = function(e, t) {
                        o.default.off(r(e), a, t)
                    }
                },
            39611:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/index.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.stopEventsSkipping = t.setEventFixMethod = t.normalizeKeyName = t.needSkipEvent = t.isTouchEvent = t.isPointerEvent = t.isMouseEvent = t.isKeyboardEvent = t.isFakeClickEvent = t.isDxMouseWheelEvent = t.isCommandKeyPressed = t.hasTouches = t.getChar = t.forceSkipEvents = t.fireEvent = t.eventSource = t.eventDelta = t.eventData = t.createEvent = t.addNamespace = void 0;
                    var i = u(n( /*! ../../core/renderer */ 68374)),
                        o = u(n( /*! ./add_namespace */ 19141)),
                        a = u(n( /*! ../core/events_engine */ 55994)),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../../core/utils/extend */ 13306),
                        l = n( /*! ../../ui/widget/selectors */ 31421);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = {
                            backspace: "backspace",
                            tab: "tab",
                            enter: "enter",
                            escape: "escape",
                            pageup: "pageUp",
                            pagedown: "pageDown",
                            end: "end",
                            home: "home",
                            arrowleft: "leftArrow",
                            arrowup: "upArrow",
                            arrowright: "rightArrow",
                            arrowdown: "downArrow",
                            delete: "del",
                            " ": "space",
                            f: "F",
                            a: "A",
                            "*": "asterisk",
                            "-": "minus",
                            alt: "alt",
                            control: "control",
                            shift: "shift"
                        },
                        c = {
                            8: "backspace",
                            9: "tab",
                            13: "enter",
                            27: "escape",
                            33: "pageUp",
                            34: "pageDown",
                            35: "end",
                            36: "home",
                            37: "leftArrow",
                            38: "upArrow",
                            39: "rightArrow",
                            40: "downArrow",
                            46: "del",
                            32: "space",
                            70: "F",
                            65: "A",
                            106: "asterisk",
                            109: "minus",
                            189: "minus",
                            173: "minus",
                            16: "shift",
                            17: "control",
                            18: "alt"
                        },
                        h = {
                            dx: /^dx/i,
                            mouse: /(mouse|wheel)/i,
                            touch: /^touch/i,
                            keyboard: /^key/i,
                            pointer: /^(ms)?pointer/i
                        },
                        f = function(e) {
                            return e
                        },
                        p = function(e) {
                            return "dx" === m(e)
                        },
                        g = function(e) {
                            return "touch" === m(e)
                        },
                        m = function(e) {
                            var t = e.type,
                                n = "other";
                            return (0, r.each)(h, (function(e) {
                                if (this.test(t)) {
                                    return n = e, !1
                                }
                            })), n
                        };
                    t.eventSource = m;
                    var _ = function(e) {
                        return "pointer" === m(e)
                    };
                    t.isPointerEvent = _;
                    var v = function(e) {
                        return function(e) {
                            return "mouse" === m(e)
                        }(e) || (_(e) || p(e)) && "mouse" === e.pointerType
                    };
                    t.isMouseEvent = v;
                    var y = function(e) {
                        return e && "dxmousewheel" === e.type
                    };
                    t.isDxMouseWheelEvent = y;
                    var b = function(e) {
                        return g(e) || (_(e) || p(e)) && "touch" === e.pointerType
                    };
                    t.isTouchEvent = b;
                    t.isKeyboardEvent = function(e) {
                        return "keyboard" === m(e)
                    };
                    t.isFakeClickEvent = function(e) {
                        var t = e.screenX,
                            n = e.offsetX,
                            i = e.pageX;
                        return 0 === t && !n && 0 === i
                    };
                    t.eventData = function(e) {
                        return {
                            x: e.pageX,
                            y: e.pageY,
                            time: e.timeStamp
                        }
                    };
                    t.eventDelta = function(e, t) {
                        return {
                            x: t.x - e.x,
                            y: t.y - e.y,
                            time: t.time - e.time || 1
                        }
                    };
                    t.hasTouches = function(e) {
                        var t = e.originalEvent,
                            n = e.pointers;
                        return g(e) ? (t.touches || []).length : p(e) ? (n || []).length : 0
                    };
                    var x = !1;
                    t.forceSkipEvents = function() {
                        return x = !0
                    };
                    t.stopEventsSkipping = function() {
                        return x = !1
                    };
                    t.needSkipEvent = function(e) {
                        if (x) {
                            return !0
                        }
                        var t = e.target,
                            n = (0, i.default)(t),
                            o = n.is(".dx-dropdownlist-popup-wrapper *, .dx-dropdownlist-popup-wrapper"),
                            a = (null == t ? void 0 : t.isContentEditable) || (null == t ? void 0 : t.hasAttribute("contenteditable")),
                            r = n.is("input, textarea, select") || a;
                        return !(!n.is(".dx-skip-gesture-event *, .dx-skip-gesture-event") || o) || (y(e) ? !(n.is("textarea") && n.hasClass("dx-texteditor-input") || a) && n.is("input[type='number'], textarea, select") && n.is(":focus") : v(e) ? r || e.which > 1 : b(e) ? r && (0, l.focused)(n) : void 0)
                    };
                    t.setEventFixMethod = function(e) {
                        return f = e
                    };
                    var w = function(e, t) {
                        var n = function(e) {
                            return f(a.default.Event(e, e), e)
                        }(e);
                        return t && (0, s.extend)(n, t), n
                    };
                    t.createEvent = w;
                    t.fireEvent = function(e) {
                        var t = e.originalEvent,
                            n = e.delegateTarget,
                            i = w(t, e);
                        return a.default.trigger(n || i.target, i), i
                    };
                    t.normalizeKeyName = function(e) {
                        var t = e.key,
                            n = e.which,
                            i = !!t;
                        if (t = i ? t : n) {
                            return i ? d[t.toLowerCase()] || t : c[t] || String.fromCharCode(t)
                        }
                    };
                    t.getChar = function(e) {
                        var t = e.key,
                            n = e.which;
                        return t || String.fromCharCode(n)
                    };
                    var C = o.default;
                    t.addNamespace = C;
                    t.isCommandKeyPressed = function(e) {
                        var t = e.ctrlKey,
                            n = e.metaKey;
                        return t || n
                    }
                },
            80506:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/visibility_change.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.triggerShownEvent = t.triggerResizeEvent = t.triggerHidingEvent = void 0;
                    var i = a(n( /*! ../core/renderer */ 68374)),
                        o = a(n( /*! ./core/events_engine */ 55994));

                    function a(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = function(e) {
                            var t = ".dx-visibility-change-handler";
                            return function(n) {
                                for (var a = (0, i.default)(n || "body"), r = a.filter(t).add(a.find(t)), s = 0; s < r.length; s++) {
                                    o.default.triggerHandler(r[s], e)
                                }
                            }
                        },
                        s = r("dxshown");
                    t.triggerShownEvent = s;
                    var l = r("dxhiding");
                    t.triggerHidingEvent = l;
                    var u = r("dxresize");
                    t.triggerResizeEvent = u
                },
            2994:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/excel_exporter.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    Object.defineProperty(t, "exportDataGrid", {
                        enumerable: !0,
                        get: function() {
                            return i.exportDataGrid
                        }
                    }), Object.defineProperty(t, "exportPivotGrid", {
                        enumerable: !0,
                        get: function() {
                            return o.exportPivotGrid
                        }
                    });
                    var i = n( /*! ./exporter/exceljs/export_data_grid */ 8572),
                        o = n( /*! ./exporter/exceljs/export_pivot_grid */ 77328)
                },
            78292:
                /*!*********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter.js ***!
                  \*********************************************************/
                function(e, t, n) {
                    t.excel = void 0, t.export = function(e, t, n) {
                        if (!e) {
                            return (new u.Deferred).resolve()
                        }
                        var i = t.exportingAction,
                            a = t.exportedAction,
                            r = t.fileSavingAction,
                            s = {
                                fileName: t.fileName,
                                format: t.format,
                                cancel: !1
                            };
                        if ((0, l.isFunction)(i) && i(s), !s.cancel) {
                            return n(e, t).then((function(e) {
                                (0, l.isFunction)(a) && a(), (0, l.isFunction)(r) && (s.data = e, r(s)), s.cancel || o.fileSaver.saveAs(s.fileName, t.format, e, t.proxyUrl, t.forceProxy)
                            }))
                        }
                        return (new u.Deferred).resolve()
                    }, Object.defineProperty(t, "fileSaver", {
                        enumerable: !0,
                        get: function() {
                            return o.fileSaver
                        }
                    }), t.svg = t.pdf = t.image = void 0;
                    var i, o = n( /*! ./exporter/file_saver */ 48351),
                        a = n( /*! ./exporter/excel_creator */ 13571),
                        r = n( /*! ./exporter/image_creator */ 12173),
                        s = n( /*! ./exporter/svg_creator */ 37596),
                        l = n( /*! ./core/utils/type */ 35922),
                        u = n( /*! ./core/utils/deferred */ 62754),
                        d = (i = n( /*! ./exporter/excel_format_converter */ 45401)) && i.__esModule ? i : {
                            default: i
                        },
                        c = n( /*! ./exporter/pdf_creator */ 30855);
                    var h = {
                        creator: a.ExcelCreator,
                        getData: a.getData,
                        formatConverter: d.default
                    };
                    t.excel = h;
                    var f = {
                        creator: r.imageCreator,
                        getData: r.getData,
                        testFormats: r.testFormats
                    };
                    t.image = f;
                    var p = {
                        getData: c.getData
                    };
                    t.pdf = p;
                    var g = {
                        creator: s.svgCreator,
                        getData: s.getData
                    };
                    t.svg = g
                },
            5332:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/common/export_load_panel.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.ExportLoadPanel = void 0;
                    var i = u(n( /*! ../../core/renderer */ 68374)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = u(n( /*! ../../localization/message */ 28109)),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = u(n( /*! ../../ui/load_panel */ 97218)),
                        l = u(n( /*! ../../ui/grid_core/ui.grid_core.utils */ 13615));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = function() {
                        function e(e, t, n, o) {
                            this._$targetElement = t, this._$container = n, this._loadPanel = e._createComponent((0, i.default)("<div>").addClass("dx-export-loadpanel").appendTo(this._$container), s.default, this.getOptions(o))
                        }
                        var t = e.prototype;
                        return t.getDefaultOptions = function() {
                            return {
                                animation: null,
                                shading: !1,
                                height: 90,
                                width: 200,
                                container: this._$container
                            }
                        }, t.getOptions = function(e) {
                            return (0, r.isDefined)(e.text) ? e.message = e.text : e.message = a.default.format("dxDataGrid-exporting"), (0, o.extend)(this.getDefaultOptions(), e)
                        }, t.show = function() {
                            this._loadPanel.option("position", l.default.calculateLoadPanelPosition(this._$targetElement)), this._loadPanel.show()
                        }, t.dispose = function() {
                            (0, i.default)(this._loadPanel.element()).remove(), delete this._loadPanel
                        }, e
                    }();
                    t.ExportLoadPanel = d
                },
            56985:
                /*!*******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.cell_alignment_helper.js ***!
                  \*******************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../../core/utils/type */ 35922),
                        a = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, o.isDefined)(e) && (t = {
                                    vertical: e.vertical,
                                    wrapText: e.wrapText,
                                    horizontal: e.horizontal
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, o.isDefined)(e) && (t = {}, void 0 !== e.horizontal && (t.horizontal = e.horizontal), void 0 !== e.vertical && (t.vertical = e.vertical), void 0 !== e.wrapText && (t.wrapText = e.wrapText)), t
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, o.isDefined)(e) && (0, o.isDefined)(t) && e.vertical === t.vertical && e.wrapText === t.wrapText && e.horizontal === t.horizontal
                            },
                            isEmpty: function(e) {
                                return !(0, o.isDefined)(e) || !(0, o.isDefined)(e.vertical) && !(0, o.isDefined)(e.wrapText) && !(0, o.isDefined)(e.horizontal)
                            },
                            toXml: function(e) {
                                return a.default.toXml("alignment", {
                                    vertical: e.vertical,
                                    wrapText: (0, o.isDefined)(e.wrapText) ? Number(e.wrapText) : void 0,
                                    horizontal: e.horizontal
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            2159:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.cell_format_helper.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = l(n( /*! ./excel.tag_helper */ 95320)),
                        a = l(n( /*! ./excel.cell_alignment_helper */ 56985)),
                        r = l(n( /*! ./excel.fill_helper */ 8808)),
                        s = l(n( /*! ./excel.font_helper */ 50394));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = {
                            tryCreateTag: function(e, t) {
                                var n = null;
                                if ((0, i.isDefined)(e)) {
                                    var o;
                                    o = "number" == typeof e.numberFormat ? e.numberFormat : t.registerNumberFormat(e.numberFormat);
                                    var s = e.fill;
                                    (0, i.isDefined)(s) || (s = r.default.tryCreateFillFromSimpleFormat(e)), n = {
                                        numberFormatId: o,
                                        alignment: a.default.tryCreateTag(e.alignment),
                                        fontId: t.registerFont(e.font),
                                        fillId: t.registerFill(s)
                                    }, u.isEmpty(n) && (n = null)
                                }
                                return n
                            },
                            copy: function(e) {
                                var t;
                                return null === e ? t = null : (0, i.isDefined)(e) && (t = {}, void 0 !== e.numberFormat && (t.numberFormat = e.numberFormat), void 0 !== e.fill ? t.fill = r.default.copy(e.fill) : r.default.copySimpleFormat(e, t), void 0 !== e.alignment && (t.alignment = a.default.copy(e.alignment)), void 0 !== e.font && (t.font = s.default.copy(e.font))), t
                            },
                            areEqual: function(e, t) {
                                return u.isEmpty(e) && u.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.fontId === t.fontId && e.numberFormatId === t.numberFormatId && e.fillId === t.fillId && a.default.areEqual(e.alignment, t.alignment)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.fontId) && !(0, i.isDefined)(e.numberFormatId) && !(0, i.isDefined)(e.fillId) && a.default.isEmpty(e.alignment)
                            },
                            toXml: function(e) {
                                var t, n = a.default.isEmpty(e.alignment);
                                return (0, i.isDefined)(e.numberFormatId) && (t = e.numberFormatId > 0 ? 1 : 0), o.default.toXml("xf", {
                                    xfId: 0,
                                    applyAlignment: n ? null : 1,
                                    fontId: e.fontId,
                                    applyNumberFormat: t,
                                    fillId: e.fillId,
                                    numFmtId: e.numberFormatId
                                }, n ? null : a.default.toXml(e.alignment))
                            }
                        },
                        d = u;
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            21879:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.color_helper.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../../core/utils/type */ 35922),
                        a = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            _tryConvertColor: function(e) {
                                if ("string" != typeof e) {
                                    return e
                                }
                                var t;
                                if (e.length > 0 && "#" === e[0]) {
                                    var n = e.substr(1, e.length);
                                    t = 6 === n.length ? "FF" + n : 8 === n.length ? n[6] + n[7] + n.substr(0, 6) : n
                                } else {
                                    t = e
                                }
                                return t
                            },
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, o.isDefined)(e) && (t = "string" == typeof e ? {
                                    rgb: this._tryConvertColor(e)
                                } : {
                                    rgb: this._tryConvertColor(e.rgb),
                                    theme: e.theme
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, o.isDefined)(e) && ("string" == typeof e ? t = e : (t = {}, void 0 !== e.rgb && (t.rgb = e.rgb), void 0 !== e.theme && (t.theme = e.theme))), t
                            },
                            isEmpty: function(e) {
                                return !(0, o.isDefined)(e) || !(0, o.isDefined)(e.rgb) && !(0, o.isDefined)(e.theme)
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, o.isDefined)(e) && (0, o.isDefined)(t) && e.rgb === t.rgb && e.theme === t.theme
                            },
                            toXml: function(e, t) {
                                return a.default.toXml(e, {
                                    rgb: t.rgb,
                                    theme: t.theme
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            50587:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.file.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = u(n( /*! ./excel.tag_helper */ 95320)),
                        a = u(n( /*! ./excel.cell_format_helper */ 2159)),
                        r = u(n( /*! ./excel.fill_helper */ 8808)),
                        s = u(n( /*! ./excel.font_helper */ 50394)),
                        l = u(n( /*! ./excel.number_format_helper */ 10794));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = function() {
                        function e() {
                            this._cellFormatTags = [], this._fillTags = [], this._fontTags = [], this._numberFormatTags = [], this._fillTags.push(r.default.tryCreateTag({
                                patternFill: {
                                    patternType: "none"
                                }
                            }))
                        }
                        var t = e.prototype;
                        return t.registerCellFormat = function(e) {
                            var t, n = a.default.tryCreateTag(e, {
                                registerFill: this.registerFill.bind(this),
                                registerFont: this.registerFont.bind(this),
                                registerNumberFormat: this.registerNumberFormat.bind(this)
                            });
                            if ((0, i.isDefined)(n)) {
                                for (var o = 0; o < this._cellFormatTags.length; o++) {
                                    if (a.default.areEqual(this._cellFormatTags[o], n)) {
                                        t = o;
                                        break
                                    }
                                }
                                void 0 === t && (t = this._cellFormatTags.push(n) - 1)
                            }
                            return t
                        }, e.copyCellFormat = function(e) {
                            return a.default.copy(e)
                        }, t.generateCellFormatsXml = function() {
                            var e = this._cellFormatTags.map((function(e) {
                                return a.default.toXml(e)
                            }));
                            return o.default.toXml("cellXfs", {
                                count: e.length
                            }, e.join(""))
                        }, t.registerFill = function(e) {
                            var t, n = r.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var o = 0; o < this._fillTags.length; o++) {
                                    if (r.default.areEqual(this._fillTags[o], n)) {
                                        t = o;
                                        break
                                    }
                                }
                                void 0 === t && (this._fillTags.length < 2 && this._fillTags.push(r.default.tryCreateTag({
                                    patternFill: {
                                        patternType: "Gray125"
                                    }
                                })), t = this._fillTags.push(n) - 1)
                            }
                            return t
                        }, t.generateFillsXml = function() {
                            var e = this._fillTags.map((function(e) {
                                return r.default.toXml(e)
                            }));
                            return o.default.toXml("fills", {
                                count: e.length
                            }, e.join(""))
                        }, t.registerFont = function(e) {
                            var t, n = s.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var o = 0; o < this._fontTags.length; o++) {
                                    if (s.default.areEqual(this._fontTags[o], n)) {
                                        t = o;
                                        break
                                    }
                                }
                                void 0 === t && (t = this._fontTags.push(n) - 1)
                            }
                            return t
                        }, t.generateFontsXml = function() {
                            var e = this._fontTags.map((function(e) {
                                return s.default.toXml(e)
                            }));
                            return o.default.toXml("fonts", {
                                count: e.length
                            }, e.join(""))
                        }, t._convertNumberFormatIndexToId = function(e) {
                            return 165 + e
                        }, t.registerNumberFormat = function(e) {
                            var t, n = l.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var o = 0; o < this._numberFormatTags.length; o++) {
                                    if (l.default.areEqual(this._numberFormatTags[o], n)) {
                                        t = this._numberFormatTags[o][l.default.ID_PROPERTY_NAME];
                                        break
                                    }
                                }
                                void 0 === t && (n[l.default.ID_PROPERTY_NAME] = this._convertNumberFormatIndexToId(this._numberFormatTags.length), t = n[l.default.ID_PROPERTY_NAME], this._numberFormatTags.push(n))
                            }
                            return t
                        }, t.generateNumberFormatsXml = function() {
                            if (this._numberFormatTags.length > 0) {
                                var e = this._numberFormatTags.map((function(e) {
                                    return l.default.toXml(e)
                                }));
                                return o.default.toXml("numFmts", {
                                    count: e.length
                                }, e.join(""))
                            }
                            return ""
                        }, e
                    }();
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            8808:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.fill_helper.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = r(n( /*! ./excel.tag_helper */ 95320)),
                        a = r(n( /*! ./excel.pattern_fill_helper */ 40027));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    patternFill: a.default.tryCreateTag(e.patternFill)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            tryCreateFillFromSimpleFormat: function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                                    t = e.backgroundColor,
                                    n = e.fillPatternType,
                                    o = e.fillPatternColor;
                                return !(0, i.isDefined)(t) || (0, i.isDefined)(n) && (0, i.isDefined)(o) ? (0, i.isDefined)(n) && (0, i.isDefined)(o) ? {
                                    patternFill: {
                                        patternType: n,
                                        foregroundColor: {
                                            rgb: o
                                        },
                                        backgroundColor: {
                                            rgb: t
                                        }
                                    }
                                } : void 0 : {
                                    patternFill: {
                                        patternType: "solid",
                                        foregroundColor: {
                                            rgb: t
                                        }
                                    }
                                }
                            },
                            copySimpleFormat: function(e, t) {
                                void 0 !== e.backgroundColor && (t.backgroundColor = e.backgroundColor), void 0 !== e.fillPatternType && (t.fillPatternType = e.fillPatternType), void 0 !== e.fillPatternColor && (t.fillPatternColor = e.fillPatternColor)
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.patternFill && (t.patternFill = a.default.copy(e.patternFill))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && a.default.areEqual(e.patternFill, t.patternFill)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || a.default.isEmpty(e.patternFill)
                            },
                            toXml: function(e) {
                                return o.default.toXml("fill", {}, a.default.toXml(e.patternFill))
                            }
                        },
                        l = s;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            50394:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.font_helper.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = r(n( /*! ./excel.tag_helper */ 95320)),
                        a = r(n( /*! ./excel.color_helper */ 21879));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    size: e.size,
                                    name: e.name,
                                    family: e.family,
                                    scheme: e.scheme,
                                    bold: e.bold,
                                    italic: e.italic,
                                    underline: e.underline,
                                    color: a.default.tryCreateTag(e.color)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.size && (t.size = e.size), void 0 !== e.name && (t.name = e.name), void 0 !== e.family && (t.family = e.family), void 0 !== e.scheme && (t.scheme = e.scheme), void 0 !== e.bold && (t.bold = e.bold), void 0 !== e.italic && (t.italic = e.italic), void 0 !== e.underline && (t.underline = e.underline), void 0 !== e.color && (t.color = a.default.copy(e.color))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.size === t.size && e.name === t.name && e.family === t.family && e.scheme === t.scheme && (e.bold === t.bold || !e.bold == !t.bold) && (e.italic === t.italic || !e.italic == !t.italic) && e.underline === t.underline && a.default.areEqual(e.color, t.color)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.size) && !(0, i.isDefined)(e.name) && !(0, i.isDefined)(e.family) && !(0, i.isDefined)(e.scheme) && (!(0, i.isDefined)(e.bold) || !e.bold) && (!(0, i.isDefined)(e.italic) || !e.italic) && !(0, i.isDefined)(e.underline) && a.default.isEmpty(e.color)
                            },
                            toXml: function(e) {
                                var t = [(0, i.isDefined)(e.bold) && e.bold ? o.default.toXml("b", {}) : "", (0, i.isDefined)(e.size) ? o.default.toXml("sz", {
                                    val: e.size
                                }) : "", (0, i.isDefined)(e.color) ? a.default.toXml("color", e.color) : "", (0, i.isDefined)(e.name) ? o.default.toXml("name", {
                                    val: e.name
                                }) : "", (0, i.isDefined)(e.family) ? o.default.toXml("family", {
                                    val: e.family
                                }) : "", (0, i.isDefined)(e.scheme) ? o.default.toXml("scheme", {
                                    val: e.scheme
                                }) : "", (0, i.isDefined)(e.italic) && e.italic ? o.default.toXml("i", {}) : "", (0, i.isDefined)(e.underline) ? o.default.toXml("u", {
                                    val: e.underline
                                }) : ""].join("");
                                return o.default.toXml("font", {}, t)
                            }
                        },
                        l = s;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            10794:
                /*!******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.number_format_helper.js ***!
                  \******************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../../core/utils/type */ 35922),
                        a = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            ID_PROPERTY_NAME: "id",
                            tryCreateTag: function(e) {
                                var t = null;
                                return "string" == typeof e && (t = {
                                    formatCode: e
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, o.isDefined)(e) && (0, o.isDefined)(t) && e.formatCode === t.formatCode
                            },
                            isEmpty: function(e) {
                                return !(0, o.isDefined)(e) || !(0, o.isDefined)(e.formatCode) || "" === e.formatCode
                            },
                            toXml: function(e) {
                                return a.default.toXml("numFmt", {
                                    numFmtId: e[r.ID_PROPERTY_NAME],
                                    formatCode: e.formatCode
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            40027:
                /*!*****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.pattern_fill_helper.js ***!
                  \*****************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = r(n( /*! ./excel.tag_helper */ 95320)),
                        a = r(n( /*! ./excel.color_helper */ 21879));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    patternType: e.patternType,
                                    backgroundColor: a.default.tryCreateTag(e.backgroundColor),
                                    foregroundColor: a.default.tryCreateTag(e.foregroundColor)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.patternType && (t.patternType = e.patternType), void 0 !== e.backgroundColor && (t.backgroundColor = a.default.copy(e.backgroundColor)), void 0 !== e.foregroundColor && (t.foregroundColor = a.default.copy(e.foregroundColor))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.patternType === t.patternType && a.default.areEqual(e.backgroundColor, t.backgroundColor) && a.default.areEqual(e.foregroundColor, t.foregroundColor)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.patternType)
                            },
                            toXml: function(e) {
                                var t = [(0, i.isDefined)(e.foregroundColor) ? a.default.toXml("fgColor", e.foregroundColor) : "", (0, i.isDefined)(e.backgroundColor) ? a.default.toXml("bgColor", e.backgroundColor) : ""].join("");
                                return o.default.toXml("patternFill", {
                                    patternType: e.patternType
                                }, t)
                            }
                        },
                        l = s;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            95320:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.tag_helper.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = {
                            toXml: function(e, t, n) {
                                var o = ["<", e];
                                for (var a in t) {
                                    var r = t[a];
                                    (0, i.isDefined)(r) && o.push(" ", a, '="', r, '"')
                                }
                                return (0, i.isDefined)(n) && "" !== n ? o.push(">", n, "</", e, ">") : o.push(" />"), o.join("")
                            }
                        };
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            13571:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel_creator.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.ExcelCreator = void 0, t.getData = function(e, t) {
                        var n = new I(e, t);
                        return n._checkZipState(), n.ready().then((function() {
                            return n.getData((0, a.isFunction)((0, o.getWindow)().Blob))
                        }))
                    };
                    var i = p(n( /*! ../core/class */ 38377)),
                        o = n( /*! ../core/utils/window */ 58201),
                        a = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/extend */ 13306),
                        s = p(n( /*! ../ui/widget/ui.errors */ 96688)),
                        l = n( /*! ../core/utils/string */ 68752),
                        u = p(n( /*! jszip */ 97405)),
                        d = n( /*! ./file_saver */ 48351),
                        c = p(n( /*! ./excel_format_converter */ 45401)),
                        h = p(n( /*! ./excel/excel.file */ 50587)),
                        f = n( /*! ../core/utils/deferred */ 62754);

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function g(e) {
                        return g = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, g(e)
                    }
                    var m = '<?xml version="1.0" encoding="utf-8"?>',
                        _ = "http://schemas.openxmlformats.org",
                        v = "xl",
                        b = "sharedStrings.xml",
                        x = "styles.xml",
                        C = {
                            boolean: "b",
                            date: "d",
                            number: "n",
                            string: "s"
                        },
                        S = Date.UTC(1899, 11, 30),
                        k = {
                            quarter: "shortDate",
                            quarterAndYear: "shortDate",
                            minute: "longTime",
                            millisecond: "longTime"
                        },
                        I = i.default.inherit({
                            _getXMLTag: function(e, t, n) {
                                var i, o, r = "<" + e,
                                    s = t.length;
                                for (i = 0; i < s; i++) {
                                    void 0 !== (o = t[i]).value && (r = r + " " + o.name + '="' + o.value + '"')
                                }
                                return (0, a.isDefined)(n) ? r + ">" + n + "</" + e + ">" : r + " />"
                            },
                            _convertToExcelCellRef: function(e, t) {
                                for (var n, i, o = ""; !i;) {
                                    n = 65 + (t >= 26 ? t % 26 : Math.ceil(t)), o = String.fromCharCode(n) + o, t >= 26 ? t = Math.floor(t / 26) - 1 : i = !0
                                }
                                return o + (e + 1)
                            },
                            _convertToExcelCellRefAndTrackMaxIndex: function(e, t) {
                                return this._maxRowIndex < Number(e) && (this._maxRowIndex = Number(e)), this._maxColumnIndex < Number(t) && (this._maxColumnIndex = Number(t)), this._convertToExcelCellRef(e, t)
                            },
                            _getDataType: function(e) {
                                return C[e] || C.string
                            },
                            _tryGetExcelCellDataType: function(e) {
                                if ((0, a.isDefined)(e)) {
                                    if ("number" == typeof e) {
                                        return isFinite(e) ? C.number : C.string
                                    }
                                    if ((0, a.isString)(e)) {
                                        return C.string
                                    }
                                    if ((0, a.isDate)(e)) {
                                        return C.number
                                    }
                                    if ((0, a.isBoolean)(e)) {
                                        return C.boolean
                                    }
                                }
                            },
                            _formatObjectConverter: function(e, t) {
                                var n = {
                                    format: e,
                                    precision: e && e.precision,
                                    dataType: t
                                };
                                return (0, a.isObject)(e) ? (0, r.extend)(n, e, {
                                    format: e.formatter || e.type,
                                    currency: e.currency
                                }) : n
                            },
                            _tryConvertToExcelNumberFormat: function(e, t) {
                                var n = this._formatObjectConverter(e, t);
                                e = n.format;
                                var i = n.currency;
                                return t = n.dataType, (0, a.isDefined)(e) && "date" === t && (e = k[e && e.type || e] || e), c.default.convertFormat(e, n.precision, t, i)
                            },
                            _appendString: function(e) {
                                if ((0, a.isDefined)(e) && (e = String(e)).length) {
                                    return e = (0, l.encodeHtml)(e), void 0 === this._stringHash[e] && (this._stringHash[e] = this._stringArray.length, this._stringArray.push(e)), this._stringHash[e]
                                }
                            },
                            _tryGetExcelDateValue: function(e) {
                                var t;
                                if ((0, a.isDate)(e)) {
                                    return (t = Math.floor((Date.UTC(e.getFullYear(), e.getMonth(), e.getDate()) - S) / 864e5)) < 60 && t--, t + (3600 * e.getHours() + 60 * e.getMinutes() + e.getSeconds()) / 86400
                                }
                            },
                            _prepareValue: function(e, t) {
                                var n, i = this._dataProvider,
                                    o = (i.getCellData(e, t) || {}).cellSourceData,
                                    r = (i.getCellData(e, t) || {}).value,
                                    s = this._getDataType(i.getCellType(e, t));
                                switch (s !== C.date || (0, a.isDate)(r) || (s = C.string), s) {
                                    case C.string:
                                        n = r, r = this._appendString(r);
                                        break;
                                    case C.date:
                                        n = r, r = this._tryGetExcelDateValue(r), s = C.number
                                }
                                return {
                                    value: r,
                                    type: s,
                                    sourceValue: n,
                                    cellSourceData: o
                                }
                            },
                            _callCustomizeExcelCell: function(e) {
                                var t = e.dataProvider,
                                    n = e.value,
                                    i = e.style,
                                    o = e.sourceData,
                                    r = h.default.copyCellFormat(i),
                                    s = {
                                        value: n,
                                        numberFormat: r.numberFormat,
                                        clearStyle: function() {
                                            this.horizontalAlignment = null, this.verticalAlignment = null, this.wrapTextEnabled = null, this.font = null, this.numberFormat = null
                                        }
                                    };
                                (0, a.isDefined)(r) && ((0, a.isDefined)(r.alignment) && (s.horizontalAlignment = r.alignment.horizontal, s.verticalAlignment = r.alignment.vertical, s.wrapTextEnabled = r.alignment.wrapText), s.backgroundColor = r.backgroundColor, s.fillPatternType = r.fillPatternType, s.fillPatternColor = r.fillPatternColor, s.font = r.font), t.customizeExcelCell(s, o);
                                var l = r || {};
                                return l.font = s.font, l.alignment = l.alignment || {}, l.alignment.horizontal = s.horizontalAlignment, l.alignment.vertical = s.verticalAlignment, l.alignment.wrapText = s.wrapTextEnabled, l.backgroundColor = s.backgroundColor, l.fillPatternType = s.fillPatternType, l.fillPatternColor = s.fillPatternColor, l.numberFormat = s.numberFormat, {
                                    value: s.value,
                                    style: l
                                }
                            },
                            _getDataArray: function() {
                                var e, t, n, i, o, r = this,
                                    s = [],
                                    l = r._dataProvider,
                                    u = l.getRowsCount(),
                                    d = l.getColumns();
                                for (e = 0; e < u; e++) {
                                    for (n = [], o = d.length, t = 0; t !== o; t++) {
                                        i = r._prepareValue(e, t);
                                        var c = l.getStyleId(e, t),
                                            h = this._styleArrayIndexToCellStyleIdMap[c];
                                        if (l.hasCustomizeExcelCell && l.hasCustomizeExcelCell()) {
                                            var f = i.sourceValue || i.value,
                                                p = this._callCustomizeExcelCell({
                                                    dataProvider: l,
                                                    value: f,
                                                    style: r._styleArray[c],
                                                    sourceData: i.cellSourceData
                                                });
                                            if (p.value !== f) {
                                                if (g(p.value) !== g(f) || "number" == typeof p.value && !isFinite(p.value)) {
                                                    var m = this._tryGetExcelCellDataType(p.value);
                                                    (0, a.isDefined)(m) && (i.type = m)
                                                }
                                                switch (i.type) {
                                                    case C.string:
                                                        i.value = this._appendString(p.value);
                                                        break;
                                                    default:
                                                        i.value = p.value;
                                                        break;
                                                    case C.number:
                                                        var _ = p.value,
                                                            v = this._tryGetExcelDateValue(_);
                                                        (0, a.isDefined)(v) && (_ = v), i.value = _
                                                }
                                            }
                                            h = this._excelFile.registerCellFormat(p.style)
                                        }
                                        n.push({
                                            style: h,
                                            value: i.value,
                                            type: i.type
                                        })
                                    }!r._needSheetPr && l.getGroupLevel(e) > 0 && (r._needSheetPr = !0), s.push(n)
                                }
                                return s
                            },
                            _calculateWidth: function(e) {
                                return (!(e = parseInt(e, 10)) || e < 5) && (e = 100), Math.min(255, Math.floor((e - 5) / 7 * 100 + .5) / 100)
                            },
                            _prepareStyleData: function() {
                                var e = this,
                                    t = this,
                                    n = t._dataProvider.getStyles();
                                t._dataProvider.getColumns().forEach((function(e) {
                                    t._colsArray.push(t._calculateWidth(e.width))
                                }));
                                var i = [{
                                    size: 11,
                                    color: {
                                        theme: 1
                                    },
                                    name: "Calibri",
                                    family: 2,
                                    scheme: "minor",
                                    bold: !1
                                }, {
                                    size: 11,
                                    color: {
                                        theme: 1
                                    },
                                    name: "Calibri",
                                    family: 2,
                                    scheme: "minor",
                                    bold: !0
                                }];
                                this._excelFile.registerFont(i[0]), this._excelFile.registerFont(i[1]), n.forEach((function(e) {
                                    var n = t._tryConvertToExcelNumberFormat(e.format, e.dataType);
                                    (0, a.isDefined)(n) || (n = 0), t._styleArray.push({
                                        font: i[Number(!!e.bold)],
                                        numberFormat: n,
                                        alignment: {
                                            vertical: "top",
                                            wrapText: !!e.wrapText,
                                            horizontal: e.alignment || "left"
                                        }
                                    })
                                })), t._styleArrayIndexToCellStyleIdMap = t._styleArray.map((function(t) {
                                    return e._excelFile.registerCellFormat(t)
                                }))
                            },
                            _prepareCellData: function() {
                                this._cellsArray = this._getDataArray()
                            },
                            _createXMLRelationships: function(e) {
                                return this._getXMLTag("Relationships", [{
                                    name: "xmlns",
                                    value: _ + "/package/2006/relationships"
                                }], e)
                            },
                            _createXMLRelationship: function(e, t, n) {
                                return this._getXMLTag("Relationship", [{
                                    name: "Id",
                                    value: "rId" + e
                                }, {
                                    name: "Type",
                                    value: _ + "/officeDocument/2006/relationships/" + t
                                }, {
                                    name: "Target",
                                    value: n
                                }])
                            },
                            _getWorkbookContent: function() {
                                return m + this._getXMLTag("workbook", [{
                                    name: "xmlns:r",
                                    value: _ + "/officeDocument/2006/relationships"
                                }, {
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }], '<bookViews><workbookView xWindow="0" yWindow="0" windowWidth="0" windowHeight="0"/></bookViews><sheets><sheet name="Sheet" sheetId="1" r:id="rId1" /></sheets><definedNames><definedName name="_xlnm.Print_Titles" localSheetId="0">Sheet!$1:$1</definedName><definedName name="_xlnm._FilterDatabase" hidden="0" localSheetId="0">Sheet!$A$1:$F$6332</definedName></definedNames>')
                            },
                            _getContentTypesContent: function() {
                                return m + '<Types xmlns="' + _ + '/package/2006/content-types"><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" /><Default Extension="xml" ContentType="application/xml" /><Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" /><Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" /><Override PartName="/xl/sharedStrings.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml" /><Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" /></Types>'
                            },
                            _generateStylesXML: function() {
                                var e = this,
                                    t = e._zip.folder(v),
                                    n = "";
                                n += this._excelFile.generateNumberFormatsXml(), n += this._excelFile.generateFontsXml(), n += this._excelFile.generateFillsXml(), n += '<borders count="1"><border><left style="thin"><color rgb="FFD3D3D3"/></left><right style="thin"><color rgb="FFD3D3D3"/></right><top style="thin"><color rgb="FFD3D3D3"/></top><bottom style="thin"><color rgb="FFD3D3D3"/></bottom></border></borders><cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>', n += this._excelFile.generateCellFormatsXml(), n += e._getXMLTag("cellStyles", [{
                                    name: "count",
                                    value: 1
                                }], e._getXMLTag("cellStyle", [{
                                    name: "name",
                                    value: "Normal"
                                }, {
                                    name: "xfId",
                                    value: 0
                                }, {
                                    name: "builtinId",
                                    value: 0
                                }])), n = m + e._getXMLTag("styleSheet", [{
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }], n), t.file(x, n), e._styleArray = []
                            },
                            _generateStringsXML: function() {
                                var e, t = this._zip.folder(v),
                                    n = this._stringArray.length,
                                    i = m;
                                for (e = 0; e < n; e++) {
                                    this._stringArray[e] = this._getXMLTag("si", [], this._getXMLTag("t", [], this._stringArray[e]))
                                }
                                i += this._getXMLTag("sst", [{
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }, {
                                    name: "count",
                                    value: this._stringArray.length
                                }, {
                                    name: "uniqueCount",
                                    value: this._stringArray.length
                                }], this._stringArray.join("")), t.file(b, i), this._stringArray = []
                            },
                            _getPaneXML: function() {
                                var e = [{
                                        name: "activePane",
                                        value: "bottomLeft"
                                    }, {
                                        name: "state",
                                        value: "frozen"
                                    }],
                                    t = this._dataProvider.getFrozenArea();
                                return t.x || t.y ? (t.x && e.push({
                                    name: "xSplit",
                                    value: t.x
                                }), t.y && e.push({
                                    name: "ySplit",
                                    value: t.y
                                }), e.push({
                                    name: "topLeftCell",
                                    value: this._convertToExcelCellRefAndTrackMaxIndex(t.y, t.x)
                                }), this._getXMLTag("pane", e)) : ""
                            },
                            _getAutoFilterXML: function(e) {
                                return this._options.autoFilterEnabled ? '<autoFilter ref="A' + this._dataProvider.getHeaderRowCount() + ":" + e + '" />' : ""
                            },
                            _getIgnoredErrorsXML: function(e) {
                                return this._options.ignoreErrors ? '<ignoredErrors><ignoredError sqref="A1:' + e + '" numberStoredAsText="1" /></ignoredErrors>' : ""
                            },
                            _generateWorksheetXML: function() {
                                var e, t, n, i, o, r = [],
                                    s = this._cellsArray.length,
                                    l = this._colsArray.length,
                                    u = "1:" + l,
                                    d = this._dataProvider.getHeaderRowCount ? this._dataProvider.getHeaderRowCount() : 1,
                                    c = ['<?xml version="1.0" encoding="UTF-8" standalone="yes"?><worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">'];
                                for (c.push(this._needSheetPr ? '<sheetPr><outlinePr summaryBelow="0"/></sheetPr>' : "<sheetPr/>"), c.push('<dimension ref="A1:C1"/>'), c.push("<sheetViews><sheetView "), c.push(this._rtlEnabled ? 'rightToLeft="1" ' : ""), c.push('tabSelected="1" workbookViewId="0">'), c.push(this._getPaneXML()), c.push("</sheetView></sheetViews>"), c.push('<sheetFormatPr defaultRowHeight="15"'), c.push(' outlineLevelRow="' + (this._dataProvider.getRowsCount() > 0 ? this._dataProvider.getGroupLevel(0) : 0) + '"'), c.push(' x14ac:dyDescent="0.25"/>'), e = 0; e < l; e++) {
                                    this._colsArray[e] = this._getXMLTag("col", [{
                                        name: "width",
                                        value: this._colsArray[e]
                                    }, {
                                        name: "min",
                                        value: Number(e) + 1
                                    }, {
                                        name: "max",
                                        value: Number(e) + 1
                                    }, {
                                        name: "customWidth",
                                        value: 1
                                    }])
                                }
                                for (c.push(this._getXMLTag("cols", [], this._colsArray.join("")) + "<sheetData>"), t = 0; t < s; t++) {
                                    for (i = [], o = this._cellsArray[t].length, e = 0; e < o; e++) {
                                        t = Number(t), n = this._cellsArray[t][e], i.push(this._getXMLTag("c", [{
                                            name: "r",
                                            value: this._convertToExcelCellRefAndTrackMaxIndex(t, e)
                                        }, {
                                            name: "s",
                                            value: n.style
                                        }, {
                                            name: "t",
                                            value: n.type
                                        }], (0, a.isDefined)(n.value) ? this._getXMLTag("v", [], n.value) : null))
                                    }
                                    r.push(this._getXMLTag("row", [{
                                        name: "r",
                                        value: Number(t) + 1
                                    }, {
                                        name: "spans",
                                        value: u
                                    }, {
                                        name: "outlineLevel",
                                        value: t >= d ? this._dataProvider.getGroupLevel(t) : 0
                                    }, {
                                        name: "x14ac:dyDescent",
                                        value: "0.25"
                                    }], i.join(""))), this._cellsArray[t] = null, r.length > 1e4 && (c.push(r.join("")), r = [])
                                }
                                c.push(r.join("")), r = [];
                                var h = this._convertToExcelCellRef(this._maxRowIndex, this._maxColumnIndex);
                                c.push("</sheetData>" + this._getAutoFilterXML(h) + this._generateMergingXML() + this._getIgnoredErrorsXML(h) + "</worksheet>"), this._zip.folder(v).folder("worksheets").file("sheet1.xml", c.join("")), this._colsArray = [], this._cellsArray = [], c = []
                            },
                            _generateMergingXML: function() {
                                var e, t, n, i, o, r = (0, a.isDefined)(this._dataProvider.getHeaderRowCount) ? this._dataProvider.getHeaderRowCount() : this._dataProvider.getRowsCount(),
                                    s = this._dataProvider.getColumns().length,
                                    l = [],
                                    u = [],
                                    d = "";
                                for (i = 0; i < r; i++) {
                                    for (n = 0; n !== s; n++) {
                                        if (!(0, a.isDefined)(l[i]) || !(0, a.isDefined)(l[i][n])) {
                                            var c = this._dataProvider.getCellMerging(i, n);
                                            if (c.colspan || c.rowspan) {
                                                for (u.push({
                                                        start: this._convertToExcelCellRefAndTrackMaxIndex(i, n),
                                                        end: this._convertToExcelCellRefAndTrackMaxIndex(i + (c.rowspan || 0), n + (c.colspan || 0))
                                                    }), e = i; e <= i + c.rowspan; e++) {
                                                    for (t = n; t <= n + c.colspan; t++) {
                                                        (0, a.isDefined)(l[e]) || (l[e] = []), l[e][t] = !0
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                var h = u.length;
                                for (o = 0; o < h; o++) {
                                    d += this._getXMLTag("mergeCell", [{
                                        name: "ref",
                                        value: u[o].start + ":" + u[o].end
                                    }])
                                }
                                return d.length ? this._getXMLTag("mergeCells", [{
                                    name: "count",
                                    value: h
                                }], d) : ""
                            },
                            _generateCommonXML: function() {
                                var e = m + this._createXMLRelationships(this._createXMLRelationship(1, "officeDocument", "xl/workbook.xml")),
                                    t = this._zip.folder(v),
                                    n = m;
                                this._zip.folder("_rels").file(".rels", e);
                                var i = this._createXMLRelationship(1, "worksheet", "worksheets/sheet1.xml") + this._createXMLRelationship(2, "styles", x) + this._createXMLRelationship(3, "sharedStrings", b);
                                n += this._createXMLRelationships(i), t.folder("_rels").file("workbook.xml.rels", n), t.file("workbook.xml", this._getWorkbookContent()), this._zip.file("[Content_Types].xml", this._getContentTypesContent())
                            },
                            _generateContent: function() {
                                this._prepareStyleData(), this._prepareCellData(), this._generateWorkXML(), this._generateCommonXML()
                            },
                            _generateWorkXML: function() {
                                this._generateStylesXML(), this._generateStringsXML(), this._generateWorksheetXML()
                            },
                            ctor: function(e, t) {
                                this._rtlEnabled = t && !!t.rtlEnabled, this._options = t, this._maxRowIndex = 0, this._maxColumnIndex = 0, this._stringArray = [], this._stringHash = {}, this._styleArray = [], this._colsArray = [], this._cellsArray = [], this._needSheetPr = !1, this._dataProvider = e, this._excelFile = new h.default, (0, a.isDefined)(I.JSZip) ? this._zip = new I.JSZip : this._zip = null
                            },
                            _checkZipState: function() {
                                if (!this._zip) {
                                    throw s.default.Error("E1041", "JSZip")
                                }
                            },
                            ready: function() {
                                return this._dataProvider.ready()
                            },
                            getData: function(e) {
                                var t = {
                                        type: e ? "blob" : "base64",
                                        compression: "DEFLATE",
                                        mimeType: d.MIME_TYPES.EXCEL
                                    },
                                    n = new f.Deferred;
                                return this._checkZipState(), this._generateContent(), this._zip.generateAsync ? this._zip.generateAsync(t).then(n.resolve) : n.resolve(this._zip.generate(t)), n
                            }
                        });
                    t.ExcelCreator = I, I.JSZip = u.default
                },
            45401:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel_format_converter.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/string */ 68752),
                        o = u(n( /*! ../localization/number */ 18016)),
                        a = u(n( /*! ../localization/date */ 91500)),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../localization/ldml/date.format */ 59937),
                        l = n( /*! ../localization/language_codes */ 9821);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ../localization/currency */ 89740);
                    var d = {
                            thousands: "#,##0{0},&quot;K&quot;",
                            millions: "#,##0{0},,&quot;M&quot;",
                            billions: "#,##0{0},,,&quot;B&quot;",
                            trillions: "#,##0{0},,,,&quot;T&quot;",
                            percent: "0{0}%",
                            decimal: "#{0}",
                            fixedpoint: "#,##0{0}",
                            exponential: "0{0}E+00",
                            currency: " "
                        },
                        c = /a+/g,
                        h = /E/g,
                        f = /dE+/g,
                        p = /L/g,
                        g = /h/g,
                        m = /./g,
                        _ = {
                            _applyPrecision: function(e, t) {
                                var n, i;
                                if (t > 0) {
                                    for (n = "decimal" !== e ? "." : "", i = 0; i < t; i++) {
                                        n += "0"
                                    }
                                    return n
                                }
                                return ""
                            },
                            _hasArabicDigits: function(e) {
                                for (var t, n = 0; n < e.length; n++) {
                                    if ((t = e.charCodeAt(n)) >= 1632 && t < 1642) {
                                        return !0
                                    }
                                }
                                return !1
                            },
                            _convertDateFormatToOpenXml: function(e) {
                                return e.split("/").join("\\/").split("'").map((function(e, t) {
                                    return t % 2 == 0 ? e.replace(c, "AM/PM").replace(f, "d").replace(h, "d").replace(p, "M").replace(g, "H").split("[").join("\\[").split("]").join("\\]") : e ? e.replace(m, "\\$&") : "'"
                                })).join("")
                            },
                            _convertDateFormat: function(e) {
                                var t = (a.default.format(new Date(2009, 8, 8, 6, 5, 4), e) || "").toString(),
                                    n = (0, s.getFormat)((function(t) {
                                        return a.default.format(t, e)
                                    }));
                                return n && (n = this._convertDateFormatToOpenXml(n), n = this._getLanguageInfo(t) + n), n
                            },
                            _getLanguageInfo: function(e) {
                                var t = (0, l.getLanguageId)(),
                                    n = t ? t.toString(16) : "",
                                    i = "";
                                if (this._hasArabicDigits(e)) {
                                    for (; n.length < 3;) {
                                        n = "0" + n
                                    }
                                    i = "[$-2010" + n + "]"
                                } else {
                                    n && (i = "[$-" + n + "]")
                                }
                                return i
                            },
                            _convertNumberFormat: function(e, t, n) {
                                var a, r;
                                return (r = "currency" === e ? o.default.getOpenXmlCurrencyFormat(n) : d[e.toLowerCase()]) && (a = (0, i.format)(r, this._applyPrecision(e, t))), a
                            },
                            convertFormat: function(e, t, n, i) {
                                if ((0, r.isDefined)(e)) {
                                    if ("date" === n) {
                                        return _._convertDateFormat(e)
                                    }
                                    if ((0, r.isString)(e) && d[e.toLowerCase()]) {
                                        return _._convertNumberFormat(e, t, i)
                                    }
                                }
                            }
                        },
                        v = _;
                    t.default = v, e.exports = t.default, e.exports.default = t.default
                },
            11385:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.Export = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ./export_format */ 38526),
                        a = n( /*! ./export_merged_ranges_manager */ 31980),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = n( /*! ../common/export_load_panel */ 5332),
                        l = n( /*! ../../core/utils/window */ 58201),
                        u = {
                            getFullOptions: function(e) {
                                var t = (0, r.extend)({}, e);
                                if (!(0, i.isDefined)(t.worksheet) || !(0, i.isObject)(t.worksheet)) {
                                    throw Error('The "worksheet" field must contain an object.')
                                }
                                if ((0, i.isDefined)(t.topLeftCell)) {
                                    if ((0, i.isString)(t.topLeftCell)) {
                                        var n = t.worksheet.getCell(t.topLeftCell),
                                            o = n.row,
                                            a = n.col;
                                        t.topLeftCell = {
                                            row: o,
                                            column: a
                                        }
                                    }
                                } else {
                                    t.topLeftCell = {
                                        row: 1,
                                        column: 1
                                    }
                                }
                                return (0, i.isDefined)(t.keepColumnWidths) || (t.keepColumnWidths = !0), (0, i.isDefined)(t.loadPanel) || (t.loadPanel = {}), (0, i.isDefined)(t.loadPanel.enabled) || (t.loadPanel.enabled = !0), t
                            },
                            convertDateForExcelJS: function(e) {
                                return new Date(Date.UTC(e.getFullYear(), e.getMonth(), e.getDate(), e.getHours(), e.getMinutes(), e.getSeconds(), e.getMilliseconds()))
                            },
                            setNumberFormat: function(e, t) {
                                e.numFmt = t
                            },
                            getCellStyles: function(e) {
                                var t = this,
                                    n = e.getStyles();
                                return n.forEach((function(e) {
                                    var n = t.tryConvertToExcelNumberFormat(e.format, e.dataType);
                                    (0, i.isDefined)(n) && (n = n.replace(/&quot;/g, '"')), e.numberFormat = n
                                })), n
                            },
                            tryConvertToExcelNumberFormat: function(e, t) {
                                var n = o.ExportFormat.formatObjectConverter(e, t),
                                    i = n.currency;
                                return e = n.format, t = n.dataType, o.ExportFormat.convertFormat(e, n.precision, t, i)
                            },
                            setAlignment: function(e, t, n) {
                                e.alignment = e.alignment || {}, (0, i.isDefined)(t) && (e.alignment.wrapText = t), (0, i.isDefined)(n) && (e.alignment.horizontal = n), e.alignment.vertical = "top"
                            },
                            setColumnsWidth: function(e, t, n) {
                                if ((0, i.isDefined)(t)) {
                                    for (var o = 0; o < t.length; o++) {
                                        var a = t[o];
                                        "number" == typeof a && isFinite(a) && (e.getColumn(n + o).width = Math.min(255, Math.floor(a / 7 * 100) / 100))
                                    }
                                }
                            },
                            export: function(e, t) {
                                var n, i = this,
                                    o = e.customizeCell,
                                    u = e.component,
                                    d = e.worksheet,
                                    c = e.topLeftCell,
                                    h = e.autoFilterEnabled,
                                    f = e.keepColumnWidths,
                                    p = e.selectedRowsOnly,
                                    g = e.loadPanel,
                                    m = e.mergeRowFieldValues,
                                    _ = e.mergeColumnFieldValues,
                                    v = ((null === (n = u._getInternalInstance) || void 0 === n ? void 0 : n.call(u)) || u).option("loadPanel").enabled;
                                if (u.option("loadPanel.enabled", !1), g.enabled && (0, l.hasWindow)()) {
                                    var y = t._getLoadPanelTargetElement(u),
                                        b = t._getLoadPanelContainer(u);
                                    this._loadPanel = new s.ExportLoadPanel(u, y, b, g), this._loadPanel.show()
                                }
                                var x = !!u.option("wordWrapEnabled");
                                d.properties.outlineProperties = {
                                    summaryBelow: !1,
                                    summaryRight: !1
                                };
                                var w = {
                                        from: {
                                            row: c.row,
                                            column: c.column
                                        },
                                        to: {
                                            row: c.row,
                                            column: c.column
                                        }
                                    },
                                    C = u.getDataProvider(p);
                                return new Promise((function(e) {
                                    C.ready().done((function() {
                                        var n = C.getColumns(),
                                            s = C.getRowsCount();
                                        f && i.setColumnsWidth(d, C.getColumnsWidths(), w.from.column);
                                        for (var l = new a.MergedRangesManager(C, t, m, _), c = i.getCellStyles(C), p = 0; p < s; p++) {
                                            var g = d.getRow(w.from.row + p);
                                            t._trySetOutlineLevel(C, g, p), i.exportRow(C, t, l, p, n.length, g, w.from.column, o, x, c), p >= 1 && w.to.row++
                                        }
                                        l.applyMergedRages(d), w.to.column += n.length > 0 ? n.length - 1 : 0;
                                        var v = d.views[0] || {};
                                        u.option("rtlEnabled") && (v.rightToLeft = !0), t._isFrozenZone(C) && (-1 === Object.keys(v).indexOf("state") && (0, r.extend)(v, t._getWorksheetFrozenState(C, w)), t._trySetAutoFilter(C, d, w, h)), Object.keys(v).length > 0 && (d.views = [v]), e(w)
                                    })).always((function() {
                                        u.option("loadPanel.enabled", v), g.enabled && (0, l.hasWindow)() && i._loadPanel.dispose()
                                    }))
                                }))
                            },
                            exportRow: function(e, t, n, o, a, r, s, l, u, d) {
                                for (var c = 0; c < a; c++) {
                                    var h = e.getCellData(o, c, !0),
                                        f = r.getCell(s + c);
                                    n.updateMergedRanges(f, o, c);
                                    var p = n.findMergedCellInfo(o, c);
                                    if ((0, i.isDefined)(p) && f !== p.masterCell) {
                                        f.style = p.masterCell.style, f.value = p.masterCell.value
                                    } else if ((0, i.isDate)(h.value) ? f.value = this.convertDateForExcelJS(h.value) : f.value = h.value, (0, i.isDefined)(f.value)) {
                                        var g = d[e.getStyleId(o, c)],
                                            m = g.bold,
                                            _ = g.alignment,
                                            v = g.numberFormat;
                                        (0, i.isDefined)(v) ? this.setNumberFormat(f, v): (0, i.isString)(f.value) && /^[@=+-]/.test(f.value) && this.setNumberFormat(f, "@"), t._trySetFont(f, m), this.setAlignment(f, u, _)
                                    }(0, i.isFunction)(l) && l(t._getCustomizeCellOptions(f, h.cellSourceData))
                                }
                            }
                        };
                    t.Export = u
                },
            8572:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_data_grid.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.exportDataGrid = function(e) {
                        return a.Export.export(function(e) {
                            if (!(0, o.isDefined)(e) || !(0, o.isObject)(e)) {
                                throw Error('The "exportDataGrid" method requires a configuration object.')
                            }
                            if (!(0, o.isDefined)(e.component) || !(0, o.isObject)(e.component) || "dxDataGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a DataGrid instance.')
                            }(0, o.isDefined)(e.selectedRowsOnly) || (e.selectedRowsOnly = !1);
                            (0, o.isDefined)(e.autoFilterEnabled) || (e.autoFilterEnabled = !1);
                            return a.Export.getFullOptions(e)
                        }(e), s)
                    };
                    var i, o = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ./export */ 11385),
                        r = (i = n( /*! ../../core/errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var s = {
                        _trySetAutoFilter: function(e, t, n, i) {
                            if (i && !(0, o.isDefined)(t.autoFilter) && e.getRowsCount() > 0) {
                                var a = {
                                    from: {
                                        row: n.from.row + e.getHeaderRowCount() - 1,
                                        column: n.from.column
                                    },
                                    to: n.to
                                };
                                t.autoFilter = a
                            }
                        },
                        _trySetFont: function(e, t) {
                            (0, o.isDefined)(t) && (e.font = e.font || {}, e.font.bold = t)
                        },
                        _getWorksheetFrozenState: function(e, t) {
                            return {
                                state: "frozen",
                                ySplit: t.from.row + e.getFrozenArea().y - 1
                            }
                        },
                        _trySetOutlineLevel: function(e, t, n) {
                            n >= e.getHeaderRowCount() && (t.outlineLevel = e.getGroupLevel(n))
                        },
                        _getCustomizeCellOptions: function(e, t) {
                            var n = {
                                excelCell: e,
                                gridCell: t
                            };
                            return Object.defineProperty(n, "cell", {
                                get: function() {
                                    return r.default.log("W0003", "CustomizeCell handler argument", "cell", "20.1", "Use the 'excelCell' field instead"), e
                                }
                            }), n
                        },
                        _isFrozenZone: function(e) {
                            return e.getHeaderRowCount() > 0
                        },
                        _isHeaderCell: function(e, t) {
                            return t < e.getHeaderRowCount()
                        },
                        _allowToMergeRange: function() {
                            return !0
                        },
                        _getLoadPanelTargetElement: function(e) {
                            return e.getView("rowsView").element()
                        },
                        _getLoadPanelContainer: function(e) {
                            return e.getView("rowsView").element().parent()
                        }
                    }
                },
            38526:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_format.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.ExportFormat = void 0;
                    var i = n( /*! ../../core/utils/string */ 68752),
                        o = d(n( /*! ../../localization/number */ 18016)),
                        a = d(n( /*! ../../localization/date */ 91500)),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = n( /*! ../../localization/ldml/date.format */ 59937),
                        l = n( /*! ../../localization/language_codes */ 9821),
                        u = n( /*! ../../core/utils/extend */ 13306);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ../../localization/currency */ 89740);
                    var c = {
                            thousands: "#,##0{0},&quot;K&quot;",
                            millions: "#,##0{0},,&quot;M&quot;",
                            billions: "#,##0{0},,,&quot;B&quot;",
                            trillions: "#,##0{0},,,,&quot;T&quot;",
                            percent: "0{0}%",
                            decimal: "#{0}",
                            fixedpoint: "#,##0{0}",
                            exponential: "0{0}E+00",
                            currency: " "
                        },
                        h = /a+/g,
                        f = /E/g,
                        p = /dE+/g,
                        g = /L/g,
                        m = /h/g,
                        _ = /./g;

                    function v(e) {
                        var t = (a.default.format(new Date(2009, 8, 8, 6, 5, 4), e) || "").toString(),
                            n = (0, s.getFormat)((function(t) {
                                return a.default.format(t, e)
                            }));
                        return n && (n = function(e) {
                            return e.split("/").join("\\/").split("'").map((function(e, t) {
                                return t % 2 == 0 ? e.replace(h, "AM/PM").replace(p, "d").replace(f, "d").replace(g, "M").replace(m, "H").split("[").join("\\[").split("]").join("\\]") : e ? e.replace(_, "\\$&") : "'"
                            })).join("")
                        }(n), n = function(e) {
                            var t = (0, l.getLanguageId)(),
                                n = t ? t.toString(16) : "",
                                i = "";
                            if (function(e) {
                                    for (var t, n = 0; n < e.length; n++) {
                                        if ((t = e.charCodeAt(n)) >= 1632 && t < 1642) {
                                            return !0
                                        }
                                    }
                                    return !1
                                }(e)) {
                                for (; n.length < 3;) {
                                    n = "0" + n
                                }
                                i = "[$-2010" + n + "]"
                            } else {
                                n && (i = "[$-" + n + "]")
                            }
                            return i
                        }(t) + n), n
                    }
                    var y = {
                        formatObjectConverter: function(e, t) {
                            var n = {
                                format: e,
                                precision: e && e.precision,
                                dataType: t
                            };
                            return (0, r.isObject)(e) ? (0, u.extend)(n, e, {
                                format: e.formatter || e.type,
                                currency: e.currency
                            }) : n
                        },
                        convertFormat: function(e, t, n, a) {
                            if ((0, r.isDefined)(e)) {
                                if ("date" === n) {
                                    return v(e)
                                }
                                if ((0, r.isString)(e) && c[e.toLowerCase()]) {
                                    return function(e, t, n) {
                                        var a, r;
                                        return (r = "currency" === e ? o.default.getOpenXmlCurrencyFormat(n) : c[e.toLowerCase()]) && (a = (0, i.format)(r, function(e, t) {
                                            var n, i;
                                            if (t > 0) {
                                                for (n = "decimal" !== e ? "." : "", i = 0; i < t; i++) {
                                                    n += "0"
                                                }
                                                return n
                                            }
                                            return ""
                                        }(e, t))), a
                                    }(e, t, a)
                                }
                            }
                        }
                    };
                    t.ExportFormat = y
                },
            31980:
                /*!**********************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_merged_ranges_manager.js ***!
                  \**********************************************************************************************/
                function(e, t) {
                    function n() {
                        return n = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, n.apply(this, arguments)
                    }
                    t.MergedRangesManager = void 0;
                    var i = function() {
                        function e(e, t, n, i) {
                            this.mergedCells = [], this.mergedRanges = [], this.dataProvider = e, this.helpers = t, this.mergeRowFieldValues = n, this.mergeColumnFieldValues = i
                        }
                        var t = e.prototype;
                        return t.updateMergedRanges = function(e, t, i) {
                            if (this.helpers._isHeaderCell(this.dataProvider, t, i) && !this.isCellInMergedRanges(t, i)) {
                                var o = this.dataProvider.getCellMerging(t, i),
                                    a = o.rowspan,
                                    r = o.colspan;
                                if (r || a) {
                                    var s = this.helpers._allowToMergeRange(this.dataProvider, t, i, a, r, this.mergeRowFieldValues, this.mergeColumnFieldValues);
                                    this.updateMergedCells(e, t, i, a, r, s), s && this.mergedRanges.push(n({
                                        masterCell: e
                                    }, {
                                        rowspan: a,
                                        colspan: r
                                    }))
                                }
                            }
                        }, t.isCellInMergedRanges = function(e, t) {
                            return this.mergedCells[e] && this.mergedCells[e][t]
                        }, t.findMergedCellInfo = function(e, t) {
                            if (this.helpers._isHeaderCell(this.dataProvider, e, t) && this.isCellInMergedRanges(e, t)) {
                                return this.mergedCells[e][t]
                            }
                        }, t.updateMergedCells = function(e, t, n, i, o, a) {
                            for (var r = t; r <= t + i; r++) {
                                for (var s = n; s <= n + o; s++) {
                                    this.mergedCells[r] || (this.mergedCells[r] = []), this.mergedCells[r][s] = {
                                        masterCell: e,
                                        unmerged: !a
                                    }
                                }
                            }
                        }, t.applyMergedRages = function(e) {
                            this.mergedRanges.forEach((function(t) {
                                var n = t.masterCell.fullAddress.row,
                                    i = t.masterCell.fullAddress.col,
                                    o = n + t.rowspan,
                                    a = i + t.colspan;
                                e.mergeCells(n, i, o, a)
                            }))
                        }, e
                    }();
                    t.MergedRangesManager = i
                },
            77328:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_pivot_grid.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.exportPivotGrid = function(e) {
                        return o.Export.export(function(e) {
                            if (!(0, i.isDefined)(e) || !(0, i.isObject)(e)) {
                                throw Error('The "exportPivotGrid" method requires a configuration object.')
                            }
                            if (!(0, i.isDefined)(e.component) || !(0, i.isObject)(e.component) || "dxPivotGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a PivotGrid instance.')
                            }(0, i.isDefined)(e.mergeRowFieldValues) || (e.mergeRowFieldValues = !0);
                            (0, i.isDefined)(e.mergeColumnFieldValues) || (e.mergeColumnFieldValues = !0);
                            return o.Export.getFullOptions(e)
                        }(e), r)
                    };
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ./export */ 11385),
                        a = n( /*! ../../core/utils/common */ 20576),
                        r = {
                            _getWorksheetFrozenState: function(e, t) {
                                return {
                                    state: "frozen",
                                    xSplit: t.from.column + e.getFrozenArea().x - 1,
                                    ySplit: t.from.row + e.getFrozenArea().y - 1
                                }
                            },
                            _getCustomizeCellOptions: function(e, t) {
                                return {
                                    excelCell: e,
                                    pivotCell: t
                                }
                            },
                            _isFrozenZone: function() {
                                return !0
                            },
                            _isHeaderCell: function(e, t, n) {
                                return t < e.getColumnAreaRowCount() || n < e.getRowAreaColCount()
                            },
                            _allowToMergeRange: function(e, t, n, i, o, a, r) {
                                return !(e.isColumnAreaCell(t, n) && !r && o || e.isRowAreaCell(t, n) && !a && i)
                            },
                            _getLoadPanelTargetElement: function(e) {
                                return e._dataArea.groupElement()
                            },
                            _getLoadPanelContainer: function(e) {
                                return e.$element()
                            },
                            _trySetAutoFilter: a.noop,
                            _trySetFont: a.noop,
                            _trySetOutlineLevel: a.noop
                        }
                },
            48351:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/file_saver.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.fileSaver = t.MIME_TYPES = void 0;
                    var i = d(n( /*! ../core/renderer */ 68374)),
                        o = d(n( /*! ../core/dom_adapter */ 73349)),
                        a = n( /*! ../core/utils/window */ 58201),
                        r = d(n( /*! ../events/core/events_engine */ 55994)),
                        s = d(n( /*! ../ui/widget/ui.errors */ 96688)),
                        l = n( /*! ../core/utils/type */ 35922),
                        u = n( /*! ../core/utils/console */ 30869);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = (0, a.getWindow)(),
                        h = (0, a.getNavigator)(),
                        f = {
                            EXCEL: "xlsx",
                            CSS: "css",
                            PNG: "png",
                            JPEG: "jpeg",
                            GIF: "gif",
                            SVG: "svg",
                            PDF: "pdf"
                        },
                        p = {
                            CSS: "text/css",
                            EXCEL: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
                            PNG: "image/png",
                            JPEG: "image/jpeg",
                            GIF: "image/gif",
                            SVG: "image/svg+xml",
                            PDF: "application/pdf"
                        };
                    t.MIME_TYPES = p;
                    var g = {
                        _revokeObjectURLTimeout: 3e4,
                        _getDataUri: function(e, t) {
                            var n = this._getMimeType(e);
                            return "data:".concat(n, ";base64,").concat(t)
                        },
                        _getMimeType: function(e) {
                            return p[e] || "application/octet-stream"
                        },
                        _linkDownloader: function(e, t) {
                            var n = o.default.createElement("a");
                            return n.download = e, n.href = t, n.target = "_blank", n
                        },
                        _formDownloader: function(e, t, n, a) {
                            var s = {
                                    method: "post",
                                    action: e,
                                    enctype: "multipart/form-data"
                                },
                                l = (0, i.default)("<form>").css({
                                    display: "none"
                                }).attr(s);

                            function u(e, t) {
                                for (var n in t) {
                                    e.setAttribute(n, t[n])
                                }
                                return e
                            }
                            l.append(u(o.default.createElement("input"), {
                                type: "hidden",
                                name: "fileName",
                                value: t
                            })), l.append(u(o.default.createElement("input"), {
                                type: "hidden",
                                name: "contentType",
                                value: n
                            })), l.append(u(o.default.createElement("input"), {
                                type: "hidden",
                                name: "data",
                                value: a
                            })), l.appendTo("body"), r.default.trigger(l, "submit"), r.default.trigger(l, "submit") && l.remove()
                        },
                        _saveByProxy: function(e, t, n, i) {
                            var o = this._getMimeType(n);
                            return this._formDownloader(e, t, o, i)
                        },
                        _winJSBlobSave: function(e, t, n) {
                            var i = new Windows.Storage.Pickers.FileSavePicker;
                            i.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                            var o = f[n];
                            if (o) {
                                var a = this._getMimeType(n);
                                i.fileTypeChoices.insert(a, ["." + o])
                            }
                            i.suggestedFileName = t, i.pickSaveFileAsync().then((function(t) {
                                t && t.openAsync(Windows.Storage.FileAccessMode.readWrite).then((function(t) {
                                    var n = e.msDetachStream();
                                    Windows.Storage.Streams.RandomAccessStream.copyAsync(n, t).then((function() {
                                        t.flushAsync().done((function() {
                                            n.close(), t.close()
                                        }))
                                    }))
                                }))
                            }))
                        },
                        _click: function(e) {
                            try {
                                e.dispatchEvent(new MouseEvent("click", {
                                    cancelable: !0
                                }))
                            } catch (n) {
                                var t = o.default.getDocument().createEvent("MouseEvents");
                                t.initMouseEvent("click", !0, !0, c, 0, 0, 0, 80, 20, !1, !1, !1, !1, 0, null), e.dispatchEvent(t)
                            }
                        },
                        _saveBlobAs: function(e, t, n) {
                            var i = this;
                            if (this._blobSaved = !1, (0, l.isDefined)(h.msSaveOrOpenBlob)) {
                                h.msSaveOrOpenBlob(n, e), this._blobSaved = !0
                            } else if ((0, l.isDefined)(c.WinJS)) {
                                this._winJSBlobSave(n, e, t), this._blobSaved = !0
                            } else {
                                var o = c.URL || c.webkitURL || c.mozURL || c.msURL || c.oURL;
                                if ((0, l.isDefined)(o)) {
                                    var a = o.createObjectURL(n),
                                        r = this._linkDownloader(e, a);
                                    setTimeout((function() {
                                        o.revokeObjectURL(a), i._objectUrlRevoked = !0
                                    }), this._revokeObjectURLTimeout), this._click(r)
                                } else {
                                    u.logger.warn("window.URL || window.webkitURL || window.mozURL || window.msURL || window.oURL is not defined")
                                }
                            }
                        },
                        saveAs: function(e, t, n, i, o) {
                            var a = f[t];
                            if (a && (e += "." + a), (0, l.isDefined)(i) && s.default.log("W0001", "Export", "proxyURL", "19.2", "This option is no longer required"), o) {
                                this._saveByProxy(i, e, t, n)
                            } else if ((0, l.isFunction)(c.Blob)) {
                                this._saveBlobAs(e, t, n)
                            } else if ((0, l.isDefined)(i) && !(0, l.isDefined)(h.userAgent.match(/iPad/i))) {
                                this._saveByProxy(i, e, t, n)
                            } else {
                                (0, l.isDefined)(h.userAgent.match(/iPad/i)) || s.default.log("E1034");
                                var r = this._linkDownloader(e, this._getDataUri(t, n));
                                this._click(r)
                            }
                        }
                    };
                    t.fileSaver = g
                },
            12173:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/image_creator.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return K.getData(e, t)
                    }, t.imageCreator = void 0, t.testFormats = function(e) {
                        var t = T(100, 100, 0);
                        return e.reduce((function(e, n) {
                            var i = ("image/" + n).toLowerCase();
                            return -1 !== t.toDataURL(i).indexOf(i) ? e.supported.push(n) : e.unsupported.push(n), e
                        }), {
                            supported: [],
                            unsupported: []
                        })
                    };
                    var i = p(n( /*! ../core/renderer */ 68374)),
                        o = p(n( /*! ../color */ 52752)),
                        a = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/svg */ 19155),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        l = n( /*! ../core/utils/extend */ 13306),
                        u = p(n( /*! ../core/dom_adapter */ 73349)),
                        d = n( /*! ../core/utils/dom */ 3532),
                        c = n( /*! ../core/utils/window */ 58201),
                        h = n( /*! ../core/utils/inflector */ 78008),
                        f = n( /*! ../core/utils/deferred */ 62754);

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var g, m = (0, c.getWindow)(),
                        _ = Math,
                        v = _.PI,
                        y = _.min,
                        b = _.abs,
                        x = _.sqrt,
                        w = _.pow,
                        C = _.atan2,
                        S = _.cos,
                        k = _.sin,
                        I = Number;

                    function T(e, t, n) {
                        var o = (0, i.default)("<canvas>")[0];
                        return o.width = e + 2 * n, o.height = t + 2 * n, o.hidden = !0, o
                    }

                    function E(e, t, n, i, o, a, r, s) {
                        var l = (e + n) / 2,
                            u = (t + i) / 2,
                            d = C(t - i, e - n),
                            c = a ? 1 : -1;
                        d += v / 180 * 90 * (r ? 1 : -1);
                        var h = x(w(n - e, 2) + w(i - t, 2)) / 2,
                            f = x(b(w(o, 2) - w(h, 2))),
                            p = l + c * (f * S(d)),
                            g = u + c * (f * k(d)),
                            m = C(t - g, e - p),
                            _ = C(i - g, n - p);
                        s.arc(p, g, o, m, _, !r)
                    }

                    function A(e, t) {
                        var n, i = g(e.attributes || {}),
                            o = (0, l.extend)({}, i, {
                                text: e.textContent.replace(/\s+/g, " "),
                                textAlign: "middle" === i["text-anchor"] ? "center" : i["text-anchor"]
                            }),
                            r = i.transform;
                        return r && ((n = r.match(/translate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), o.translateX = I(n[0]), o.translateY = n[1] ? I(n[1]) : 0), (n = r.match(/rotate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), o.rotationAngle = I(n[0]), o.rotationX = n[1] && I(n[1]), o.rotationY = n[2] && I(n[2])), (n = r.match(/scale\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), o.scaleX = I(n[0]), n.length > 1 ? o.scaleY = I(n[1]) : o.scaleY = o.scaleX)),
                            function(e, t, n) {
                                var i, o = e.style || {};
                                for (i in o) {
                                    "" !== o[i] && (t[(0, h.camelize)(i)] = o[i])
                                }
                                n && u.default.isElementNode(e) && (o = m.getComputedStyle(e), ["fill", "stroke", "stroke-width", "font-family", "font-size", "font-style", "font-weight"].forEach((function(e) {
                                    e in o && "" !== o[e] && (t[(0, h.camelize)(e)] = o[e])
                                })), ["opacity", "fill-opacity", "stroke-opacity"].forEach((function(e) {
                                    e in o && "" !== o[e] && "1" !== o[e] && (t[e] = I(o[e]))
                                })));
                                t.textDecoration = t.textDecoration || t.textDecorationLine, t.globalAlpha = (0, a.isDefined)(t.opacity) ? t.opacity : t.globalAlpha
                            }(e, o, t), o
                    }

                    function O(e) {
                        var t = e && e.match(/url\(.*#(.*?)["']?\)/i);
                        return t && t[1]
                    }

                    function P(e, t) {
                        var n = [];
                        t.fontSize = t.fontSize || "10px", t.fontFamily = t.fontFamily || "sans-serif", t.fill = t.fill || "#000", t.fontStyle && n.push(t.fontStyle), t.fontWeight && n.push(t.fontWeight), n.push(t.fontSize), n.push(t.fontFamily), e.font = n.join(" "), e.textAlign = t.textAlign, e.fillStyle = t.fill, e.globalAlpha = t.globalAlpha
                    }

                    function R(e) {
                        for (var t = e.childNodes, n = 0; n < t.length; n++) {
                            if ("tspan" === t[n].tagName) {
                                return !0
                            }
                        }
                        return !1
                    }

                    function F(e, t, n, i) {
                        var o = e.tagName,
                            a = "text" === o || "tspan" === o || void 0 === o,
                            s = "image" === o,
                            u = (0, l.extend)({}, n, A(e, i.rootAppended));
                        if ("hidden" !== u.visibility && !u[r.HIDDEN_FOR_EXPORT]) {
                            var d;
                            switch (t.save(), !s && H(t, u), L(t, u, i), function(e) {
                                    e.strokeOpacity = void 0 !== e["stroke-opacity"] ? e["stroke-opacity"] : 1, e.fillOpacity = void 0 !== e["fill-opacity"] ? e["fill-opacity"] : 1, void 0 !== e.opacity && (e.strokeOpacity *= e.opacity, e.fillOpacity *= e.opacity)
                                }(u), t.beginPath(), e.tagName) {
                                case void 0:
                                    ! function(e, t, n) {
                                        P(e, t), V(e, t, n), t.text && e.fillText(t.text, t.x || 0, t.y || 0), q(e, t, !0),
                                            function(e, t, n) {
                                                if (!t.textDecoration || "none" === t.textDecoration) {
                                                    return
                                                }
                                                var i = t.x,
                                                    o = e.measureText(t.text).width,
                                                    a = parseInt(t.fontSize, 10),
                                                    r = .05 * a < 1 ? 1 : .05 * a,
                                                    s = t.y;
                                                switch (t.textDecoration) {
                                                    case "line-through":
                                                        s -= a / 3 + r / 2;
                                                        break;
                                                    case "overline":
                                                        s -= a - r;
                                                        break;
                                                    case "underline":
                                                        s += r
                                                }
                                                e.rect(i, s, o, r), $(e, t, n), q(e, t)
                                            }(e, t, n)
                                    }(t, u, i);
                                    break;
                                case "text":
                                case "tspan":
                                    ! function B(e, t, n, i) {
                                        for (var o, a = [], r = 0, s = 0; s < e.length; s++) {
                                            var u = e[s];
                                            if (void 0 === u.tagName) {
                                                F(u, t, n, i)
                                            } else if ("tspan" === u.tagName || "text" === u.tagName) {
                                                var d = A(u, i.rootAppended),
                                                    c = (0, l.extend)({}, n, d);
                                                if ("tspan" === u.tagName && R(u)) {
                                                    B(u.childNodes, t, c, i);
                                                    continue
                                                }
                                                c.textAlign = "start", o && void 0 === d.x || (o = {
                                                    elements: [],
                                                    options: [],
                                                    widths: [],
                                                    offsets: []
                                                }, a.push(o)), void 0 !== d.y && (r = 0), void 0 !== d.dy && (r += parseFloat(d.dy)), o.elements.push(u), o.options.push(c), o.offsets.push(r), P(t, c), o.widths.push(t.measureText(c.text).width)
                                            }
                                        }
                                        a.forEach((function(e) {
                                            var o = e.widths.reduce((function(e, t) {
                                                    return e + t
                                                }), 0),
                                                a = 0,
                                                r = 0;
                                            "center" === n.textAlign && (a = o / 2), "end" === n.textAlign && (a = o), e.options.forEach((function(t, n) {
                                                var i = e.widths[n];
                                                t.x = t.x - a + r, t.y += e.offsets[n], r += i
                                            })), e.elements.forEach((function(n, o) {
                                                B(n.childNodes, t, e.options[o], i)
                                            }))
                                        }))
                                    }(e.childNodes, t, u, i);
                                    break;
                                case "image":
                                    d = function(e, t, n) {
                                        var i = new f.Deferred,
                                            o = new m.Image;
                                        return o.onload = function() {
                                            e.save(), e.globalAlpha = t.globalAlpha, H(e, t), L(e, t, n), e.drawImage(o, t.x, t.y, t.width, t.height), e.restore(), i.resolve()
                                        }, o.onerror = function() {
                                            i.resolve()
                                        }, o.setAttribute("crossOrigin", "anonymous"), o.src = t.href || t["xlink:href"], i
                                    }(t, u, i);
                                    break;
                                case "path":
                                    ! function(e, t) {
                                        var n, i, o, a = t.replace(/,/g, " ").split(/([A-Z])/i).filter((function(e) {
                                                return "" !== e.trim()
                                            })),
                                            r = 0;
                                        do {
                                            switch (n = (a[r + 1] || "").trim().split(" "), a[r]) {
                                                case "M":
                                                    e.moveTo(I(n[0]), I(n[1])), r += 2;
                                                    break;
                                                case "L":
                                                    for (var s = 0; s < n.length / 2; s++) {
                                                        e.lineTo(I(n[2 * s]), I(n[2 * s + 1]))
                                                    }
                                                    r += 2;
                                                    break;
                                                case "C":
                                                    e.bezierCurveTo(I(n[0]), I(n[1]), I(n[2]), I(n[3]), I(n[4]), I(n[5])), r += 2;
                                                    break;
                                                case "a":
                                                    o = (i = a[r - 1].trim().split(" ")).length - 1, E(I(i[o - 1]), I(i[o]), I(i[o - 1]) + I(n[5]), I(i[o]) + I(n[6]), I(n[0]), I(n[3]), I(n[4]), e), r += 2;
                                                    break;
                                                case "A":
                                                    o = (i = a[r - 1].trim().split(" ")).length - 1, E(I(i[o - 1]), I(i[o]), I(n[5]), I(n[6]), I(n[0]), I(n[3]), I(n[4]), e), r += 2;
                                                    break;
                                                case "Z":
                                                    e.closePath(), r += 1;
                                                    break;
                                                default:
                                                    r++
                                            }
                                        } while (r < a.length)
                                    }(t, u.d);
                                    break;
                                case "rect":
                                    ! function(e, t) {
                                        var n = t.x,
                                            i = t.y,
                                            o = t.width,
                                            a = t.height,
                                            r = t.rx;
                                        r ? (r = y(r, o / 2, a / 2), e.save(), e.translate(n, i), e.moveTo(o / 2, 0), e.arcTo(o, 0, o, a, r), e.arcTo(o, a, 0, a, r), e.arcTo(0, a, 0, 0, r), e.arcTo(0, 0, r, 0, r), e.lineTo(o / 2, 0), e.restore()) : e.rect(n, i, o, a)
                                    }(t, u), t.closePath();
                                    break;
                                case "circle":
                                    t.arc(u.cx, u.cy, u.r, 0, 2 * v, 1)
                            }
                            return a || (V(t, u, i), $(t, u, i), q(t, u)),
                                function(e, t, n, i) {
                                    var o = n.gradients;
                                    if (0 === o.length) {
                                        return
                                    }
                                    var a = O(t.fill);
                                    if (a && o[a]) {
                                        var r = i.getBBox(),
                                            s = e.createLinearGradient(r.x, 0, r.x + r.width, 0);
                                        o[a].forEach((function(e) {
                                            var t = parseInt(e.offset.replace(/%/, ""));
                                            s.addColorStop(t / 100, e.stopColor)
                                        })), e.globalAlpha = t.opacity, e.fillStyle = s, e.fill()
                                    }
                                }(t, u, i, e), t.restore(), d
                        }
                    }

                    function V(e, t, n) {
                        var i, o = O(t.filter);
                        o && ((i = n.filters[o]) || (i = {
                            offsetX: 0,
                            offsetY: 0,
                            blur: 0,
                            color: "#000"
                        }), e.shadowOffsetX = i.offsetX, e.shadowOffsetY = i.offsetY, e.shadowColor = i.color, e.shadowBlur = i.blur)
                    }

                    function H(e, t) {
                        e.translate(t.translateX || 0, t.translateY || 0), t.translateX = void 0, t.translateY = void 0, t.rotationAngle && (e.translate(t.rotationX || 0, t.rotationY || 0), e.rotate(t.rotationAngle * v / 180), e.translate(-(t.rotationX || 0), -(t.rotationY || 0)), t.rotationAngle = void 0, t.rotationX = void 0, t.rotationY = void 0), isFinite(t.scaleX) && (e.scale(t.scaleX, t.scaleY), t.scaleX = void 0, t.scaleY = void 0)
                    }

                    function L(e, t, n) {
                        t["clip-path"] && (F(n.clipPaths[O(t["clip-path"])], e, {}, n), e.clip(), t["clip-path"] = void 0)
                    }

                    function N(e) {
                        var t, n, i = {};
                        return (0, s.each)(e.childNodes, (function(e, a) {
                            var r = a.attributes;
                            if (r.result) {
                                switch (r.result.value) {
                                    case "gaussianBlurResult":
                                        i.blur = I(r.stdDeviation.value);
                                        break;
                                    case "offsetResult":
                                        i.offsetX = I(r.dx.value), i.offsetY = I(r.dy.value);
                                        break;
                                    case "floodResult":
                                        t = r["flood-color"] ? r["flood-color"].value : "#000", n = r["flood-opacity"] ? r["flood-opacity"].value : 1, i.color = function(e, t) {
                                            var n = new o.default(e);
                                            return "rgba(" + n.r + "," + n.g + "," + n.b + "," + t + ")"
                                        }(t, n)
                                }
                            }
                        })), i
                    }

                    function W(e, t, n, i) {
                        return function z(e, t) {
                            for (var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : new f.Deferred, i = 0; i < e.length; i++) {
                                var o = t(e[i]);
                                if ((0, a.isPromise)(o)) {
                                    o.then((function() {
                                        z(Array.prototype.slice.call(e, i + 1), t, n)
                                    }));
                                    break
                                }
                            }
                            return i === e.length && n.resolve(), n
                        }(e, (function(e) {
                            switch (e.tagName && e.tagName.toLowerCase()) {
                                case "g":
                                case "svg":
                                    var o = (0, l.extend)({}, n, A(e, i.rootAppended));
                                    t.save(), H(t, o), L(t, o, i);
                                    var r = function() {
                                            t.restore()
                                        },
                                        u = W(e.childNodes, t, o, i);
                                    return (0, a.isPromise)(u) ? u.then(r) : r(), u;
                                case "defs":
                                    return W(e.childNodes, t, {}, i);
                                case "clippath":
                                    i.clipPaths[e.attributes.id.textContent] = e.childNodes[0];
                                    break;
                                case "pattern":
                                    i.patterns[e.attributes.id.textContent] = e;
                                    break;
                                case "filter":
                                    i.filters[e.id] = N(e);
                                    break;
                                case "lineargradient":
                                    i.gradients[e.attributes.id.textContent] = function(e) {
                                        var t = [];
                                        return (0, s.each)(e.childNodes, (function(e, n) {
                                            var i = n.attributes;
                                            t.push({
                                                offset: i.offset.value,
                                                stopColor: i["stop-color"].value
                                            })
                                        })), t
                                    }(e);
                                    break;
                                default:
                                    return F(e, t, n, i)
                            }
                        }))
                    }

                    function q(e, t, n) {
                        var i = t.stroke;
                        i && "none" !== i && 0 !== t["stroke-width"] && (! function(e, t) {
                            var n = t["stroke-dasharray"] && t["stroke-dasharray"].match(/(\d+)/g);
                            n && n.length && (n = (0, s.map)(n, (function(e) {
                                return I(e)
                            })), e.setLineDash(n))
                        }(e, t), e.lineJoin = t["stroke-linejoin"], e.lineWidth = t["stroke-width"], e.globalAlpha = t.strokeOpacity, e.strokeStyle = i, n ? e.strokeText(t.text, t.x, t.y) : e.stroke(), e.globalAlpha = 1)
                    }

                    function $(e, t, n) {
                        var i = t.fill;
                        if (i && "none" !== i) {
                            if (-1 === i.search(/url/)) {
                                e.fillStyle = i
                            } else {
                                var o = n.patterns[O(i)];
                                if (!o) {
                                    return
                                }
                                e.fillStyle = function(e, t, n) {
                                    var i = A(t, n.rootAppended),
                                        o = T(i.width, i.height, 0),
                                        a = o.getContext("2d");
                                    return W(t.childNodes, a, i, n), e.createPattern(o, "repeat")
                                }(e, o, n)
                            }
                            e.globalAlpha = t.fillOpacity, e.fill(), e.globalAlpha = 1
                        }
                    }

                    function G(e, t, n) {
                        return W(e.childNodes, t.getContext("2d"), {}, {
                            clipPaths: {},
                            patterns: {},
                            filters: {},
                            gradients: {},
                            rootAppended: n
                        })
                    }
                    g = function(e) {
                        var t, n = {};
                        return (0, s.each)(e, (function(e, i) {
                            t = i.textContent, isFinite(t) && (t = I(t)), n[i.name.toLowerCase()] = t
                        })), n
                    };
                    var K = {
                        getImageData: function(e, t) {
                            var n = "image/" + t.format;
                            return (0, a.isFunction)(t.__parseAttributesFn) && (g = t.__parseAttributesFn),
                                function(e, t) {
                                    var n = t.width,
                                        i = t.height,
                                        o = t.backgroundColor,
                                        a = t.margin,
                                        s = t.pixelRatio,
                                        l = t.svgToCanvas,
                                        c = void 0 === l ? G : l,
                                        h = T(n, i, a),
                                        p = h.getContext("2d");
                                    p.setTransform(s, 0, 0, s, 0, 0);
                                    var g, m = (0, r.getSvgElement)(e),
                                        _ = u.default.isElementNode(e);
                                    return p.translate(a, a), u.default.getBody().appendChild(h), _ || ((g = function() {
                                            var e = u.default.createElement("div");
                                            return e.style.left = "-9999px", e.style.position = "absolute", e
                                        }()).appendChild(m), u.default.getBody().appendChild(g)), m.attributes.direction && (h.dir = m.attributes.direction.textContent),
                                        function(e, t, n, i, o) {
                                            e.fillStyle = i || "#ffffff", e.fillRect(-o, -o, t + 2 * o, n + 2 * o)
                                        }(p, n, i, o, a), (0, f.fromPromise)(c(m, h, _ && (0, d.contains)(u.default.getBody(), e))).then((function() {
                                            return h
                                        })).always((function() {
                                            g && u.default.getBody().removeChild(g), u.default.getBody().removeChild(h)
                                        }))
                                }(e, t).then((function(e) {
                                    return function(e, t) {
                                        var n = e.toDataURL(t, 1);
                                        return m.atob(n.substring(("data:" + t + ";base64,").length))
                                    }(e, n)
                                }))
                        },
                        getData: function(e, t) {
                            var n = this;
                            return K.getImageData(e, t).then((function(e) {
                                var i = "image/" + t.format;
                                return (0, a.isFunction)(m.Blob) && !t.forceProxy ? n._getBlob(e, i) : n._getBase64(e)
                            }))
                        },
                        _getBlob: function(e, t) {
                            var n, i = new Uint8Array(e.length);
                            for (n = 0; n < e.length; n++) {
                                i[n] = e.charCodeAt(n)
                            }
                            return new m.Blob([i.buffer], {
                                type: t
                            })
                        },
                        _getBase64: function(e) {
                            return m.btoa(e)
                        }
                    };
                    t.imageCreator = K
                },
            39458:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.Export = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        a = d(n( /*! ../../localization/date */ 91500)),
                        r = d(n( /*! ../../localization/number */ 18016)),
                        s = d(n( /*! ../../localization/message */ 28109)),
                        l = n( /*! ../common/export_load_panel */ 5332),
                        u = n( /*! ../../core/utils/window */ 58201);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = {
                        getFullOptions: function(e) {
                            var t = (0, o.extend)({}, e);
                            if (!(0, i.isDefined)(t.jsPDFDocument) || !(0, i.isObject)(t.jsPDFDocument)) {
                                throw Error('The "jsPDFDocument" field must contain a jsPDF instance.')
                            }
                            if (!(0, i.isDefined)(t.jsPDFDocument.autoTable) || !(0, i.isFunction)(t.jsPDFDocument.autoTable)) {
                                throw Error('The "exportDataGrid" method requires a autoTable plugin for jsPDF object.')
                            }
                            if ((0, i.isDefined)(t.keepColumnWidths) || (t.keepColumnWidths = !0), (0, i.isDefined)(t.autoTableOptions)) {
                                if (!(0, i.isObject)(t.autoTableOptions)) {
                                    throw Error('The "autoTableOptions" option must be of object type.')
                                }
                                t.autoTableOptions = (0, o.extend)(!0, {}, this._getDefaultAutoTableOptions(), t.autoTableOptions)
                            } else {
                                t.autoTableOptions = this._getDefaultAutoTableOptions()
                            }
                            return (0, i.isDefined)(t.loadPanel) || (t.loadPanel = {}), (0, i.isDefined)(t.loadPanel.enabled) || (t.loadPanel.enabled = !0), (0, i.isDefined)(t.loadPanel.text) || (t.loadPanel.text = s.default.format("dxDataGrid-exporting")), t
                        },
                        _getDefaultAutoTableOptions: function() {
                            return {
                                theme: "plain",
                                tableLineColor: 149,
                                tableLineWidth: .1,
                                styles: {
                                    textColor: 51,
                                    lineColor: 149,
                                    lineWidth: 0
                                },
                                columnStyles: {},
                                headStyles: {
                                    fontStyle: "normal",
                                    textColor: 149,
                                    lineWidth: .1
                                },
                                bodyStyles: {
                                    lineWidth: .1
                                },
                                head: [],
                                body: []
                            }
                        },
                        export: function(e) {
                            var t, n = this,
                                o = e.jsPDFDocument,
                                a = e.autoTableOptions,
                                r = e.component,
                                s = e.customizeCell,
                                d = e.keepColumnWidths,
                                c = e.selectedRowsOnly,
                                h = e.loadPanel,
                                f = ((null === (t = r._getInternalInstance) || void 0 === t ? void 0 : t.call(r)) || r).option("loadPanel").enabled;
                            if (r.option("loadPanel.enabled", !1), h.enabled && (0, u.hasWindow)()) {
                                var p = r.getView("rowsView");
                                this._loadPanel = new l.ExportLoadPanel(r, p.element(), p.element().parent(), h), this._loadPanel.show()
                            }
                            var g = r.getDataProvider(c),
                                m = !!r.option("wordWrapEnabled");
                            return new Promise((function(e) {
                                g.ready().done((function() {
                                    var t = g.getColumns(),
                                        r = g.getStyles(),
                                        l = g.getRowsCount(),
                                        u = g.getHeaderRowCount(),
                                        c = [];
                                    if (d) {
                                        var h = n._tryGetPdfColumnWidths(a.tableWidth, g.getColumnsWidths());
                                        (0, i.isDefined)(h) && (0, i.isDefined)(a.columnStyles) && n._setColumnWidths(a.columnStyles, h)
                                    }
                                    for (var f = 0; f < l; f++) {
                                        for (var p = [], _ = 0; _ < t.length; _++) {
                                            var v = g.getCellData(f, _, !0),
                                                y = v.value,
                                                b = v.cellSourceData,
                                                x = r[g.getStyleId(f, _)],
                                                w = {
                                                    content: n._getFormattedValue(y, x.format),
                                                    styles: n._getPDFCellStyles(b.rowType, t[_].alignment, x, m)
                                                };
                                            if ("header" === b.rowType) {
                                                var C = n._tryGetMergeRange(f, _, c, g);
                                                C && C.rowSpan > 0 && (w.rowSpan = C.rowSpan + 1), C && C.colSpan > 0 && (w.colSpan = C.colSpan + 1), (!(c[f] && c[f][_]) || w.rowSpan > 1 || w.colSpan > 1) && ((0, i.isFunction)(s) && s({
                                                    gridCell: b,
                                                    pdfCell: w
                                                }), p.push(w))
                                            } else if ("group" !== b.rowType || (0, i.isDefined)(w.content) || 1 !== p.length) {
                                                var S;
                                                w.content = null !== (S = w.content) && void 0 !== S ? S : "", (0, i.isFunction)(s) && s({
                                                    gridCell: b,
                                                    pdfCell: w
                                                }), p.push(w)
                                            } else {
                                                var k;
                                                p[0].colSpan = null !== (k = p[0].colSpan) && void 0 !== k ? k : 1, p[0].colSpan++
                                            }
                                        }
                                        f < u ? a.head.push(p) : a.body.push(p)
                                    }
                                    o.autoTable(a), e()
                                })).always((function() {
                                    r.option("loadPanel.enabled", f), h.enabled && (0, u.hasWindow)() && n._loadPanel.dispose()
                                }))
                            }))
                        },
                        _getFormattedValue: function(e, t) {
                            if ((0, i.isDefined)(t)) {
                                if ((0, i.isDate)(e)) {
                                    return a.default.format(e, t)
                                }
                                if ((0, i.isNumeric)(e)) {
                                    return r.default.format(e, t)
                                }
                            }
                            return e
                        },
                        _getPDFCellStyles: function(e, t, n, i) {
                            var o = n.alignment,
                                a = n.bold,
                                r = "header" === e ? t : o,
                                s = {};
                            return r && (s.halign = r), a && "header" !== e && (s.fontStyle = "bold"), i && (s.cellWidth = "wrap"), s
                        },
                        _tryGetMergeRange: function(e, t, n, i) {
                            if (!n[e] || !n[e][t]) {
                                var o = i.getCellMerging(e, t),
                                    a = o.colspan,
                                    r = o.rowspan;
                                if (a || r) {
                                    for (var s = e; s <= e + r; s++) {
                                        for (var l = t; l <= t + a; l++) {
                                            n[s] || (n[s] = []), n[s][l] = !0
                                        }
                                    }
                                    return {
                                        rowSpan: r,
                                        colSpan: a
                                    }
                                }
                            }
                        },
                        _tryGetPdfColumnWidths: function(e, t) {
                            if ((0, i.isNumeric)(e) && (0, i.isDefined)(t)) {
                                var n = t.reduce((function(e, t) {
                                    return e + t
                                }), 0);
                                return t.map((function(t) {
                                    return e * t / n
                                }))
                            }
                        },
                        _setColumnWidths: function(e, t) {
                            t.forEach((function(t, n) {
                                e[n] = e[n] || {}, e[n].cellWidth = t
                            }))
                        }
                    };
                    t.Export = c
                },
            654:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export_data_grid.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.exportDataGrid = function(e) {
                        return o.Export.export(function(e) {
                            if (!(0, i.isDefined)(e) || !(0, i.isObject)(e)) {
                                throw Error('The "exportDataGrid" method requires a configuration object.')
                            }
                            if (!(0, i.isDefined)(e.component) || !(0, i.isObject)(e.component) || "dxDataGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a DataGrid instance.')
                            }(0, i.isDefined)(e.selectedRowsOnly) || (e.selectedRowsOnly = !1);
                            return o.Export.getFullOptions(e)
                        }(e))
                    };
                    var i = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ./export */ 39458)
                },
            29982:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export_gantt.js ***!
                  \****************************************************************************/
                function(e, t) {
                    t.exportGantt = function(e) {
                        var t = e.component;
                        return null == t ? void 0 : t.exportToPdf(e)
                    }
                },
            30855:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/pdf_creator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return a.imageCreator.getImageData(e, (0, s.extend)({}, t, {
                            format: "JPEG"
                        })).then((function(e) {
                            var n = function(e, t, n) {
                                    var o = 2 * (t.margin || 0),
                                        a = t.width + o,
                                        r = t.height + o,
                                        s = (.75 * a).toFixed(2),
                                        l = (.75 * r).toFixed(2),
                                        _ = u.replace("_width_", s).replace("_height_", l),
                                        v = d.replace("_width_", s).replace("_height_", l),
                                        y = c.replace("_date_", n).replace("_version_", i.version),
                                        b = h.replace("_width_", a).replace("_height_", r).replace("_length_", e.length) + e + f,
                                        x = (S = _.length, k = v.length, I = y.length, g.replace("_main_", m(S + "", 10)).replace("_info_", m(S + k + "", 10)).replace("_image_", m(S + k + I + "", 10))),
                                        w = _ + v + y + b,
                                        C = p.replace("_length_", w.length);
                                    var S, k, I;
                                    return w + x + C
                                }(e, t, new Date),
                                o = (0, r.isFunction)(l.Blob) ? function(e) {
                                    for (var t = 0, n = new Uint8Array(e.length); t < e.length; t++) {
                                        n[t] = e.charCodeAt(t)
                                    }
                                    return new l.Blob([n.buffer], {
                                        type: "application/pdf"
                                    })
                                }(n) : function(e) {
                                    return l.btoa(e)
                                }(n);
                            return o
                        }))
                    };
                    var i = n( /*! ../core/version */ 36739),
                        o = n( /*! ../core/utils/window */ 58201),
                        a = n( /*! ./image_creator */ 12173),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/extend */ 13306),
                        l = (0, o.getWindow)(),
                        u = "%PDF-1.3\r\n2 0 obj\r\n<</ProcSet[/PDF/ImageB/ImageC/ImageI]/XObject<</I0 5 0 R>>>>\r\nendobj\r\n4 0 obj\r\n<</Type/Pages/Kids[1 0 R]/Count 1>>\r\nendobj\r\n7 0 obj\r\n<</OpenAction[1 0 R /FitH null]/Type/Catalog/Pages 4 0 R/PageLayout/OneColumn>>\r\nendobj\r\n1 0 obj\r\n<</Type/Page/Resources 2 0 R/MediaBox[0 0 _width_ _height_]/Contents 3 0 R/Parent 4 0 R>>\r\nendobj\r\n",
                        d = "3 0 obj\r\n<</Length 52>>stream\r\n0.20 w\n0 G\nq _width_ 0 0 _height_ 0.00 0.00 cm /I0 Do Q\r\nendstream\r\nendobj\r\n",
                        c = "6 0 obj\r\n<</CreationDate _date_/Producer(DevExtreme _version_)>>\r\nendobj\r\n",
                        h = "5 0 obj\r\n<</Type/XObject/Subtype/Image/Width _width_/Height _height_/ColorSpace/DeviceRGB/BitsPerComponent 8/Filter/DCTDecode/Length _length_>>stream\r\n",
                        f = "\r\nendstream\r\nendobj\r\n",
                        p = "trailer\r\n<<\r\n/Size 8\r\n/Root 7 0 R\r\n/Info 6 0 R\r\n>>\r\nstartxref\r\n_length_\r\n%%EOF",
                        g = "xref\r\n0 8\r\n0000000000 65535 f\r\n0000000241 00000 n\r\n0000000010 00000 n\r\n_main_ 00000 n\r\n0000000089 00000 n\r\n_image_ 00000 n\r\n_info_ 00000 n\r\n0000000143 00000 n\r\n",
                        m = function e(t, n) {
                            return t.length < n ? e("0" + t, n) : t
                        }
                },
            37596:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/svg_creator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return h.getData(e, t)
                    }, t.svgCreator = void 0;
                    var i = d(n( /*! ../core/renderer */ 68374)),
                        o = d(n( /*! ../core/utils/ajax */ 37208)),
                        a = n( /*! ../core/utils/window */ 58201),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        l = n( /*! ../core/utils/svg */ 19155),
                        u = n( /*! ../core/utils/deferred */ 62754);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = (0, a.getWindow)(),
                        h = {
                            _markup: "",
                            _imageArray: {},
                            _imageDeferreds: [],
                            _getBinaryFile: function(e, t) {
                                o.default.sendRequest({
                                    url: e,
                                    method: "GET",
                                    responseType: "arraybuffer"
                                }).done(t).fail((function() {
                                    t(!1)
                                }))
                            },
                            _loadImages: function() {
                                var e = this;
                                (0, s.each)(e._imageArray, (function(t) {
                                    var n = new u.Deferred;
                                    e._imageDeferreds.push(n), e._getBinaryFile(t, (function(i) {
                                        if (!i) {
                                            return delete e._imageArray[t], void n.resolve()
                                        }
                                        var o, a = "",
                                            r = new Uint8Array(i),
                                            s = r.byteLength;
                                        for (o = 0; o < s; o++) {
                                            a += String.fromCharCode(r[o])
                                        }
                                        e._imageArray[t] = "data:image/png;base64," + c.btoa(a), n.resolve()
                                    }))
                                }))
                            },
                            _parseImages: function(e) {
                                var t, n = this;
                                "image" === e.tagName && (t = (0, i.default)(e).attr("href") || (0, i.default)(e).attr("xlink:href"), n._imageArray[t] || (n._imageArray[t] = "")), (0, s.each)(e.childNodes, (function(e, t) {
                                    n._parseImages(t)
                                }))
                            },
                            _prepareImages: function(e) {
                                return this._parseImages(e), this._loadImages(), u.when.apply(i.default, this._imageDeferreds)
                            },
                            getData: function(e, t) {
                                var n, o = this,
                                    a = (0, l.getSvgElement)(e),
                                    u = (0, i.default)(a);
                                return u.find("[".concat(l.HIDDEN_FOR_EXPORT, "]")).remove(), n = '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>' + (0, l.getSvgMarkup)(u.get(0), t.backgroundColor), o._prepareImages(a).then((function() {
                                    return (0, s.each)(o._imageArray, (function(e, t) {
                                        var i = "href=['|\"]".concat(e, "['|\"]");
                                        n = n.replace(new RegExp(i, "gi"), 'href="'.concat(t, '"'))
                                    })), (0, r.isFunction)(c.Blob) ? o._getBlob(n) : o._getBase64(n)
                                }))
                            },
                            _getBlob: function(e) {
                                return new c.Blob([e], {
                                    type: "image/svg+xml"
                                })
                            },
                            _getBase64: function(e) {
                                return c.btoa(e)
                            }
                        };
                    t.svgCreator = h
                },
            98831:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/custom_provider.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, o = n( /*! ../core/utils/common */ 20576),
                        a = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/data */ 47617);

                    function s(e, t) {
                        return s = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, s(e, t)
                    }
                    var l = function(e) {
                        var t, n;

                        function i(t) {
                            var n;
                            return t = (0, o.ensureDefined)(t, {}), (n = e.call(this, t) || this)._hasSubDirsGetter = (0, r.compileGetter)(t.hasSubDirectoriesExpr || "hasSubDirectories"), n._getItemsFunction = n._ensureFunction(t.getItems, (function() {
                                return []
                            })), n._renameItemFunction = n._ensureFunction(t.renameItem), n._createDirectoryFunction = n._ensureFunction(t.createDirectory), n._deleteItemFunction = n._ensureFunction(t.deleteItem), n._moveItemFunction = n._ensureFunction(t.moveItem), n._copyItemFunction = n._ensureFunction(t.copyItem), n._uploadFileChunkFunction = n._ensureFunction(t.uploadFileChunk), n._abortFileUploadFunction = n._ensureFunction(t.abortFileUpload), n._downloadItemsFunction = n._ensureFunction(t.downloadItems), n._getItemsContentFunction = n._ensureFunction(t.getItemsContent), n
                        }
                        n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, s(t, n);
                        var l = i.prototype;
                        return l.getItems = function(e) {
                            var t = this,
                                n = e.getFullPathInfo();
                            return this._executeActionAsDeferred((function() {
                                return t._getItemsFunction(e)
                            }), !0).then((function(e) {
                                return t._convertDataObjectsToFileItems(e, n)
                            }))
                        }, l.renameItem = function(e, t) {
                            var n = this;
                            return this._executeActionAsDeferred((function() {
                                return n._renameItemFunction(e, t)
                            }))
                        }, l.createDirectory = function(e, t) {
                            var n = this;
                            return this._executeActionAsDeferred((function() {
                                return n._createDirectoryFunction(e, t)
                            }))
                        }, l.deleteItems = function(e) {
                            var t = this;
                            return e.map((function(e) {
                                return t._executeActionAsDeferred((function() {
                                    return t._deleteItemFunction(e)
                                }))
                            }))
                        }, l.moveItems = function(e, t) {
                            var n = this;
                            return e.map((function(e) {
                                return n._executeActionAsDeferred((function() {
                                    return n._moveItemFunction(e, t)
                                }))
                            }))
                        }, l.copyItems = function(e, t) {
                            var n = this;
                            return e.map((function(e) {
                                return n._executeActionAsDeferred((function() {
                                    return n._copyItemFunction(e, t)
                                }))
                            }))
                        }, l.uploadFileChunk = function(e, t, n) {
                            var i = this;
                            return this._executeActionAsDeferred((function() {
                                return i._uploadFileChunkFunction(e, t, n)
                            }))
                        }, l.abortFileUpload = function(e, t, n) {
                            var i = this;
                            return this._executeActionAsDeferred((function() {
                                return i._abortFileUploadFunction(e, t, n)
                            }))
                        }, l.downloadItems = function(e) {
                            return this._downloadItemsFunction(e)
                        }, l.getItemsContent = function(e) {
                            var t = this;
                            return this._executeActionAsDeferred((function() {
                                return t._getItemsContentFunction(e)
                            }))
                        }, l._hasSubDirs = function(e) {
                            var t = this._hasSubDirsGetter(e);
                            return "boolean" != typeof t || t
                        }, l._getKeyExpr = function(e) {
                            return e.keyExpr || "key"
                        }, l._ensureFunction = function(e, t) {
                            return t = t || o.noop, (0, a.isFunction)(e) ? e : t
                        }, i
                    }(((i = n( /*! ./provider_base */ 19073)) && i.__esModule ? i : {
                        default: i
                    }).default);
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            49816:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/error.js ***!
                  \**********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = function(e, t, n) {
                        this.errorCode = e, this.fileSystemItem = t, this.errorText = n
                    }, e.exports = t.default, e.exports.default = t.default
                },
            41011:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/error_codes.js ***!
                  \****************************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = {
                        NoAccess: 0,
                        FileExists: 1,
                        FileNotFound: 2,
                        DirectoryExists: 3,
                        DirectoryNotFound: 4,
                        WrongFileExtension: 5,
                        MaxFileSizeExceeded: 6,
                        InvalidSymbols: 7,
                        Other: 32767
                    }, e.exports = t.default, e.exports.default = t.default
                },
            45765:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/file_system_item.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/type */ 35922),
                        o = n( /*! ./utils */ 73173);

                    function a(e) {
                        return function(e) {
                            if (Array.isArray(e)) {
                                return r(e)
                            }
                        }(e) || function(e) {
                            if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                return Array.from(e)
                            }
                        }(e) || function(e, t) {
                            if (!e) {
                                return
                            }
                            if ("string" == typeof e) {
                                return r(e, t)
                            }
                            var n = Object.prototype.toString.call(e).slice(8, -1);
                            "Object" === n && e.constructor && (n = e.constructor.name);
                            if ("Map" === n || "Set" === n) {
                                return Array.from(e)
                            }
                            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                return r(e, t)
                            }
                        }(e) || function() {
                            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                        }()
                    }

                    function r(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var s = function() {
                            function e() {
                                var e = (0, i.isString)(arguments[0]) ? this._publicCtor : this._internalCtor;
                                e.apply(this, arguments)
                            }
                            var t = e.prototype;
                            return t._internalCtor = function(e, t, n, i) {
                                this.name = t || "", this.pathInfo = e && a(e) || [], this.parentPath = this._getPathByPathInfo(this.pathInfo), this.relativeName = (0, o.pathCombine)(this.parentPath, t), this.key = i || this._getPathByPathInfo(this.getFullPathInfo(), !0), this.path = (0, o.pathCombine)(this.parentPath, t), this.pathKeys = this.pathInfo.map((function(e) {
                                    return e.key
                                })), this.isRoot() || this.pathKeys.push(this.key), this._initialize(n)
                            }, t._publicCtor = function(e, t, n) {
                                this.path = e || "", this.pathKeys = n || [];
                                for (var i = [], a = (0, o.getPathParts)(e, !0), r = 0; r < a.length - 1; r++) {
                                    var s = a[r],
                                        l = {
                                            key: this.pathKeys[r] || s,
                                            name: (0, o.getName)(s)
                                        };
                                    i.push(l)
                                }
                                this.pathInfo = i, this.relativeName = e, this.name = (0, o.getName)(e), this.key = this.pathKeys.length ? this.pathKeys[this.pathKeys.length - 1] : e, this.parentPath = a.length > 1 ? a[a.length - 2] : "", this._initialize(t)
                            }, t._initialize = function(e) {
                                this.isDirectory = !!e, this.size = 0, this.dateModified = new Date, this.thumbnail = "", this.tooltipText = ""
                            }, t.getFullPathInfo = function() {
                                var e = a(this.pathInfo);
                                return this.isRoot() || e.push({
                                    key: this.key,
                                    name: this.name
                                }), e
                            }, t.isRoot = function() {
                                return "" === this.path
                            }, t.getFileExtension = function() {
                                return this.isDirectory ? "" : (0, o.getFileExtension)(this.name)
                            }, t.equals = function(e) {
                                return e && this.key === e.key
                            }, t.createClone = function() {
                                var t = new e(this.pathInfo, this.name, this.isDirectory, this.key);
                                return t.key = this.key, t.size = this.size, t.dateModified = this.dateModified, t.thumbnail = this.thumbnail, t.tooltipText = this.tooltipText, t.hasSubDirectories = this.hasSubDirectories, t.dataItem = this.dataItem, t
                            }, t._getPathByPathInfo = function(e, t) {
                                return e.map((function(e) {
                                    return t ? (0, o.getEscapedFileName)(e.name) : e.name
                                })).join(o.PATH_SEPARATOR)
                            }, e
                        }(),
                        l = s;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            4323:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/object_provider.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/array */ 89386),
                        o = n( /*! ../core/utils/common */ 20576),
                        a = n( /*! ../core/utils/data */ 47617),
                        r = v(n( /*! ../core/guid */ 73176)),
                        s = n( /*! ../core/utils/type */ 35922),
                        l = n( /*! ../data/errors */ 18438),
                        u = n( /*! ../core/utils/deferred */ 62754),
                        d = n( /*! ../core/utils/window */ 58201),
                        c = n( /*! ../exporter/file_saver */ 48351),
                        h = v(n( /*! ../ui/widget/ui.errors */ 96688)),
                        f = v(n( /*! jszip */ 97405)),
                        p = v(n( /*! ./provider_base */ 19073)),
                        g = v(n( /*! ./error */ 49816)),
                        m = v(n( /*! ./error_codes */ 41011)),
                        _ = n( /*! ./utils */ 73173);

                    function v(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function y(e, t) {
                        return y = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, y(e, t)
                    }
                    var b = (0, d.getWindow)();
                    var x = function(e) {
                        var t, n;

                        function d(t) {
                            var n;
                            t = (0, o.ensureDefined)(t, {}), n = e.call(this, t) || this;
                            var i = t.data;
                            if (i && !Array.isArray(i)) {
                                throw l.errors.Error("E4006")
                            }
                            var r = t.itemsExpr || "items";
                            n._subFileItemsGetter = (0, a.compileGetter)(r), n._subFileItemsSetter = n._getSetter(r);
                            var s = t.contentExpr || "content";
                            n._contentGetter = (0, a.compileGetter)(s), n._contentSetter = n._getSetter(s);
                            var u = n._getNameExpr(t);
                            n._nameSetter = n._getSetter(u);
                            var d = n._getIsDirExpr(t);
                            n._getIsDirSetter = n._getSetter(d);
                            var c = n._getKeyExpr(t);
                            n._keySetter = n._getSetter(c);
                            var h = n._getSizeExpr(t);
                            n._sizeSetter = n._getSetter(h);
                            var f = n._getDateModifiedExpr(t);
                            return n._dateModifiedSetter = n._getSetter(f), n._data = i || [], n
                        }
                        n = e, (t = d).prototype = Object.create(n.prototype), t.prototype.constructor = t, y(t, n);
                        var p = d.prototype;
                        return p.getItems = function(e) {
                            var t = this;
                            return this._executeActionAsDeferred((function() {
                                return t._getItems(e)
                            }), !0)
                        }, p.renameItem = function(e, t) {
                            var n = this;
                            return this._executeActionAsDeferred((function() {
                                return n._renameItemCore(e, t)
                            }))
                        }, p._renameItemCore = function(e, t) {
                            if (e) {
                                var n = this._findDataObject(e);
                                this._nameSetter(n, t), e.name = t, e.key = this._ensureDataObjectKey(n)
                            }
                        }, p.createDirectory = function(e, t) {
                            var n = this;
                            return this._executeActionAsDeferred((function() {
                                n._validateDirectoryExists(e), n._createDataObject(e, t, !0)
                            }))
                        }, p.deleteItems = function(e) {
                            var t = this;
                            return e.map((function(e) {
                                return t._executeActionAsDeferred((function() {
                                    return t._deleteItem(e)
                                }))
                            }))
                        }, p.moveItems = function(e, t) {
                            var n = this,
                                i = this._findDataObject(t),
                                o = this._getDirectoryDataItems(i);
                            return e.map((function(e) {
                                return n._executeActionAsDeferred((function() {
                                    n._checkAbilityToMoveOrCopyItem(e, t);
                                    var i = n._findDataObject(e);
                                    n._deleteItem(e), o.push(i)
                                }))
                            }))
                        }, p.copyItems = function(e, t) {
                            var n = this,
                                i = this._findDataObject(t),
                                o = this._getDirectoryDataItems(i);
                            return e.map((function(e) {
                                return n._executeActionAsDeferred((function() {
                                    n._checkAbilityToMoveOrCopyItem(e, t);
                                    var i = n._findDataObject(e),
                                        a = n._createCopy(i);
                                    o.push(a)
                                }))
                            }))
                        }, p.uploadFileChunk = function(e, t, n) {
                            var i = this;
                            if (t.chunkIndex > 0) {
                                return t.customData.deferred
                            }
                            this._validateDirectoryExists(n);
                            var o = t.customData.deferred = new u.Deferred,
                                a = this._createFileReader();
                            return a.readAsDataURL(e), a.onload = function() {
                                var t = a.result.split(",")[1],
                                    r = i._createDataObject(n, e.name, !1);
                                i._sizeSetter(r, e.size), i._dateModifiedSetter(r, e.lastModifiedDate), i._contentSetter(r, t), o.resolve()
                            }, a.onerror = function(e) {
                                return o.reject(e)
                            }, o
                        }, p.downloadItems = function(e) {
                            1 === e.length ? this._downloadSingleFile(e[0]) : this._downloadMultipleFiles(e)
                        }, p._downloadSingleFile = function(e) {
                            for (var t = this._getFileContent(e), n = b.atob(t), i = new ArrayBuffer(n.length), o = new Uint8Array(i), a = 0; a < n.length; a++) {
                                o[a] = n.charCodeAt(a)
                            }
                            var r = new b.Blob([i], {
                                type: "application/octet-stream"
                            });
                            c.fileSaver.saveAs(e.name, null, r)
                        }, p._downloadMultipleFiles = function(e) {
                            var t = this,
                                n = new(function() {
                                    if (!f.default) {
                                        throw h.default.Error("E1041", "JSZip")
                                    }
                                    return f.default
                                }());
                            e.forEach((function(e) {
                                return n.file(e.name, t._getFileContent(e), {
                                    base64: !0
                                })
                            }));
                            var i = {
                                    type: "blob",
                                    compression: "DEFLATE",
                                    mimeType: "application/zip"
                                },
                                o = new u.Deferred;
                            n.generateAsync ? n.generateAsync(i).then(o.resolve) : o.resolve(n.generate(i)), o.done((function(e) {
                                return c.fileSaver.saveAs("files.zip", null, e)
                            }))
                        }, p._getFileContent = function(e) {
                            var t = this._findDataObject(e);
                            return this._contentGetter(t) || ""
                        }, p._validateDirectoryExists = function(e) {
                            if (!this._isFileItemExists(e) || this._isDirGetter(e.fileItem)) {
                                throw new g.default(m.default.DirectoryNotFound, e)
                            }
                        }, p._checkAbilityToMoveOrCopyItem = function(e, t) {
                            var n = this,
                                i = this._findDataObject(e),
                                o = this._getKeyFromDataObject(i, e.parentPath),
                                a = t.getFullPathInfo(),
                                r = "";
                            a.forEach((function(t) {
                                if (r = (0, _.pathCombine)(r, t.name), n._getDataObjectKey(t.key, r) === o) {
                                    throw new g.default(m.default.Other, e)
                                }
                            }))
                        }, p._createDataObject = function(e, t, n) {
                            var i = {};
                            this._nameSetter(i, t), this._getIsDirSetter(i, n), this._keySetter(i, String(new r.default));
                            var o = this._findDataObject(e);
                            return this._getDirectoryDataItems(o).push(i), i
                        }, p._createCopy = function(e) {
                            var t = this,
                                n = {};
                            this._nameSetter(n, this._nameGetter(e)), this._getIsDirSetter(n, this._isDirGetter(e));
                            var i = this._subFileItemsGetter(e);
                            if (Array.isArray(i)) {
                                var o = [];
                                i.forEach((function(e) {
                                    var n = t._createCopy(e);
                                    o.push(n)
                                })), this._subFileItemsSetter(n, o)
                            }
                            return n
                        }, p._deleteItem = function(e) {
                            var t = this._findDataObject(e),
                                n = this._findFileItemObj(e.pathInfo),
                                i = this._getDirectoryDataItems(n),
                                o = i.indexOf(t);
                            i.splice(o, 1)
                        }, p._getDirectoryDataItems = function(e) {
                            if (!e) {
                                return this._data
                            }
                            var t = this._subFileItemsGetter(e);
                            return Array.isArray(t) || (t = [], this._subFileItemsSetter(e, t)), t
                        }, p._getItems = function(e) {
                            this._validateDirectoryExists(e);
                            var t = e.getFullPathInfo(),
                                n = t && t.length > 0 ? t[t.length - 1].key : null,
                                i = this._data;
                            if (n) {
                                var o = this._findFileItemObj(t);
                                i = o && this._subFileItemsGetter(o) || []
                            }
                            return this._ensureKeysForDuplicateNameItems(i), this._convertDataObjectsToFileItems(i, t)
                        }, p._ensureKeysForDuplicateNameItems = function(e) {
                            var t = this,
                                n = {};
                            e.forEach((function(e) {
                                var i = t._nameGetter(e);
                                n[i] ? t._ensureDataObjectKey(e) : n[i] = !0
                            }))
                        }, p._findDataObject = function(e) {
                            if (e.isRoot()) {
                                return null
                            }
                            var t = this._findFileItemObj(e.getFullPathInfo());
                            if (!t) {
                                var n = e.isDirectory ? m.default.DirectoryNotFound : m.default.FileNotFound;
                                throw new g.default(n, e)
                            }
                            return t
                        }, p._findFileItemObj = function(e) {
                            var t = this;
                            Array.isArray(e) || (e = []);
                            for (var n = "", o = null, a = this._data, r = function(r) {
                                    (o = (0, i.find)(a, (function(i) {
                                        var o = t._isDirGetter(i) || r === e.length - 1;
                                        return t._getKeyFromDataObject(i, n) === e[r].key && t._nameGetter(i) === e[r].name && o
                                    }))) && (n = (0, _.pathCombine)(n, t._nameGetter(o)), a = t._subFileItemsGetter(o))
                                }, s = 0; s < e.length && (0 === s || o); s++) {
                                r(s)
                            }
                            return o
                        }, p._getKeyFromDataObject = function(e, t) {
                            var n = this._keyGetter(e),
                                i = (0, _.pathCombine)(t, this._nameGetter(e));
                            return this._getDataObjectKey(n, i)
                        }, p._getDataObjectKey = function(e, t) {
                            return e || t
                        }, p._ensureDataObjectKey = function(e) {
                            var t = this._keyGetter(e);
                            return t || (t = String(new r.default), this._keySetter(e, t)), t
                        }, p._hasSubDirs = function(e) {
                            var t = (0, o.ensureDefined)(this._subFileItemsGetter(e), []);
                            if (!Array.isArray(t)) {
                                return !0
                            }
                            for (var n = 0; n < t.length; n++) {
                                if (!0 === this._isDirGetter(t[n])) {
                                    return !0
                                }
                            }
                            return !1
                        }, p._getSetter = function(e) {
                            return (0, s.isFunction)(e) ? e : (0, a.compileSetter)(e)
                        }, p._isFileItemExists = function(e) {
                            return e.isDirectory && e.isRoot() || !!this._findFileItemObj(e.getFullPathInfo())
                        }, p._createFileReader = function() {
                            return new b.FileReader
                        }, d
                    }(p.default);
                    t.default = x, e.exports = t.default, e.exports.default = t.default
                },
            19073:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/provider_base.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/data */ 47617),
                        o = n( /*! ../core/utils/common */ 20576),
                        a = d(n( /*! ../core/utils/date_serialization */ 69434)),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = n( /*! ../core/utils/type */ 35922),
                        l = n( /*! ../core/utils/deferred */ 62754),
                        u = d(n( /*! ./file_system_item */ 45765));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = function() {
                            function e(e) {
                                e = (0, o.ensureDefined)(e, {}), this._keyGetter = (0, i.compileGetter)(this._getKeyExpr(e)), this._nameGetter = (0, i.compileGetter)(this._getNameExpr(e)), this._isDirGetter = (0, i.compileGetter)(this._getIsDirExpr(e)), this._sizeGetter = (0, i.compileGetter)(this._getSizeExpr(e)), this._dateModifiedGetter = (0, i.compileGetter)(this._getDateModifiedExpr(e)), this._thumbnailGetter = (0, i.compileGetter)(e.thumbnailExpr || "thumbnail")
                            }
                            var t = e.prototype;
                            return t.getItems = function(e) {
                                return []
                            }, t.renameItem = function(e, t) {}, t.createDirectory = function(e, t) {}, t.deleteItems = function(e) {}, t.moveItems = function(e, t) {}, t.copyItems = function(e, t) {}, t.uploadFileChunk = function(e, t, n) {}, t.abortFileUpload = function(e, t, n) {}, t.downloadItems = function(e) {}, t.getItemsContent = function(e) {}, t.getFileUploadChunkSize = function() {
                                return 2e5
                            }, t._convertDataObjectsToFileItems = function(e, t) {
                                var n = this,
                                    i = [];
                                return (0, r.each)(e, (function(e, o) {
                                    var a = n._createFileItem(o, t);
                                    i.push(a)
                                })), i
                            }, t._createFileItem = function(e, t) {
                                var n = this._keyGetter(e),
                                    i = new u.default(t, this._nameGetter(e), !!this._isDirGetter(e), n);
                                return i.size = this._sizeGetter(e), void 0 === i.size && (i.size = 0), i.dateModified = a.default.deserializeDate(this._dateModifiedGetter(e)), void 0 === i.dateModified && (i.dateModified = new Date), i.isDirectory && (i.hasSubDirectories = this._hasSubDirs(e)), n || (i.key = i.relativeName), i.thumbnail = this._thumbnailGetter(e) || "", i.dataItem = e, i
                            }, t._hasSubDirs = function(e) {
                                return !0
                            }, t._getKeyExpr = function(e) {
                                return e.keyExpr || this._defaultKeyExpr
                            }, t._defaultKeyExpr = function(e) {
                                if (2 !== arguments.length) {
                                    return Object.prototype.hasOwnProperty.call(e, "__KEY__") ? e.__KEY__ : null
                                }
                                e.__KEY__ = arguments[1]
                            }, t._getNameExpr = function(e) {
                                return e.nameExpr || "name"
                            }, t._getIsDirExpr = function(e) {
                                return e.isDirectoryExpr || "isDirectory"
                            }, t._getSizeExpr = function(e) {
                                return e.sizeExpr || "size"
                            }, t._getDateModifiedExpr = function(e) {
                                return e.dateModifiedExpr || "dateModified"
                            }, t._executeActionAsDeferred = function(e, t) {
                                var n = new l.Deferred;
                                try {
                                    var i = e();
                                    (0, s.isPromise)(i) ? (0, l.fromPromise)(i).done((function(e) {
                                        return n.resolve(t && e || void 0)
                                    })).fail((function(e) {
                                        return n.reject(e)
                                    })): n.resolve(t && i || void 0)
                                } catch (e) {
                                    return n.reject(e)
                                }
                                return n.promise()
                            }, e
                        }(),
                        h = c;
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            41332:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/file_management/remote_provider.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = p(n( /*! ../core/renderer */ 68374)),
                        o = p(n( /*! ../core/utils/ajax */ 37208)),
                        a = n( /*! ../core/utils/common */ 20576),
                        r = p(n( /*! ../core/guid */ 73176)),
                        s = n( /*! ../core/utils/window */ 58201),
                        l = n( /*! ../core/utils/iterator */ 95479),
                        u = n( /*! ../core/utils/deferred */ 62754),
                        d = p(n( /*! ../events/core/events_engine */ 55994)),
                        c = p(n( /*! ./provider_base */ 19073)),
                        h = n( /*! ../core/utils/data */ 47617),
                        f = n( /*! ../core/utils/type */ 35922);

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function g(e, t, n) {
                        return t in e ? Object.defineProperty(e, t, {
                            value: n,
                            enumerable: !0,
                            configurable: !0,
                            writable: !0
                        }) : e[t] = n, e
                    }

                    function m(e, t) {
                        return m = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, m(e, t)
                    }
                    var _ = (0, s.getWindow)(),
                        v = "GetDirContents",
                        T = "POST",
                        E = function(e) {
                            var t, n;

                            function s(t) {
                                var n;
                                return t = (0, a.ensureDefined)(t, {}), (n = e.call(this, t) || this)._endpointUrl = t.endpointUrl, n._beforeAjaxSend = t.beforeAjaxSend, n._beforeSubmit = t.beforeSubmit, n._requestHeaders = t.requestHeaders, n._hasSubDirsGetter = (0, h.compileGetter)(t.hasSubDirectoriesExpr || "hasSubDirectories"), n
                            }
                            n = e, (t = s).prototype = Object.create(n.prototype), t.prototype.constructor = t, m(t, n);
                            var c = s.prototype;
                            return c.getItems = function(e) {
                                var t = this,
                                    n = e.getFullPathInfo();
                                return this._executeRequest(v, {
                                    pathInfo: n
                                }).then((function(e) {
                                    return t._convertDataObjectsToFileItems(e.result, n)
                                }))
                            }, c.renameItem = function(e, t) {
                                return this._executeRequest("Rename", {
                                    pathInfo: e.getFullPathInfo(),
                                    isDirectory: e.isDirectory,
                                    name: t
                                })
                            }, c.createDirectory = function(e, t) {
                                return this._executeRequest("CreateDir", {
                                    pathInfo: e.getFullPathInfo(),
                                    name: t
                                })
                            }, c.deleteItems = function(e) {
                                var t = this;
                                return e.map((function(e) {
                                    return t._executeRequest("Remove", {
                                        pathInfo: e.getFullPathInfo(),
                                        isDirectory: e.isDirectory
                                    })
                                }))
                            }, c.moveItems = function(e, t) {
                                var n = this;
                                return e.map((function(e) {
                                    return n._executeRequest("Move", {
                                        sourcePathInfo: e.getFullPathInfo(),
                                        sourceIsDirectory: e.isDirectory,
                                        destinationPathInfo: t.getFullPathInfo()
                                    })
                                }))
                            }, c.copyItems = function(e, t) {
                                var n = this;
                                return e.map((function(e) {
                                    return n._executeRequest("Copy", {
                                        sourcePathInfo: e.getFullPathInfo(),
                                        sourceIsDirectory: e.isDirectory,
                                        destinationPathInfo: t.getFullPathInfo()
                                    })
                                }))
                            }, c.uploadFileChunk = function(e, t, n) {
                                var i;
                                0 === t.chunkIndex && (t.customData.uploadId = new r.default);
                                var s = {
                                        destinationPathInfo: n.getFullPathInfo(),
                                        chunkMetadata: JSON.stringify({
                                            UploadId: t.customData.uploadId,
                                            FileName: e.name,
                                            Index: t.chunkIndex,
                                            TotalCount: t.chunkCount,
                                            FileSize: e.size
                                        })
                                    },
                                    l = {
                                        url: this._endpointUrl,
                                        headers: this._requestHeaders || {},
                                        method: T,
                                        dataType: "json",
                                        data: (i = {}, g(i, "chunk", t.chunkBlob), g(i, "arguments", JSON.stringify(s)), g(i, "command", "UploadChunk"), i),
                                        upload: {
                                            onprogress: a.noop,
                                            onloadstart: