/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 21.2.3
 * Build date: Thu Oct 28 2021
 *
 * Copyright (c) 2012 - 2021 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var e = {
            23908:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/easing.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.convertTransitionTimingFuncToEasing = void 0, t.getEasing = function(e) {
                        return s[e]
                    }, t.setEasing = function(e) {
                        s = e
                    };
                    var i = n( /*! ../core/utils/type */ 35922),
                        a = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,
                        o = {
                            linear: "cubic-bezier(0, 0, 1, 1)",
                            swing: "cubic-bezier(0.445, 0.05, 0.55, 0.95)",
                            ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
                            "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
                            "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
                            "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
                        },
                        s = {};
                    t.convertTransitionTimingFuncToEasing = function(e) {
                        var t, n = (e = o[e] || e).match(a);
                        n || (n = o[t = "linear"].match(a)), n = n.slice(1, 5);
                        for (var c = 0; c < n.length; c++) {
                            n[c] = parseFloat(n[c])
                        }
                        var l = t || "cubicbezier_" + n.join("_").replace(/\./g, "p");
                        return (0, i.isFunction)(s[l]) || (s[l] = function(e, t, i, a, o) {
                            return a * function(e, t, n, i) {
                                var a = 3 * e,
                                    o = 3 * (n - e) - a,
                                    r = 1 - a - o,
                                    s = 3 * t,
                                    c = 3 * (i - t) - s,
                                    l = 1 - s - c,
                                    u = function(e) {
                                        return e * (a + e * (o + e * r))
                                    },
                                    d = function(e) {
                                        return a + e * (2 * o + 3 * e * r)
                                    };
                                return function(e) {
                                    return function(e) {
                                        return e * (s + e * (c + e * l))
                                    }(function(e) {
                                        for (var t, n = e, i = 0; i < 14 && (t = u(n) - e, !(Math.abs(t) < .001));) {
                                            n -= t / d(n), i++
                                        }
                                        return n
                                    }(e))
                                }
                            }(n[0], n[1], n[2], n[3])(t / o) + i
                        }), l
                    }
                },
            90057:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/frame.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.cancelAnimationFrame = function() {
                        l(), c.apply(r, arguments)
                    }, t.requestAnimationFrame = function() {
                        return l(), s.apply(r, arguments)
                    };
                    var i, a = n( /*! ../core/utils/window */ 58201),
                        o = (i = n( /*! ../core/utils/call_once */ 39618)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = (0, a.hasWindow)() ? (0, a.getWindow)() : {},
                        s = function(e) {
                            return setTimeout(e, 16.666666666666668)
                        },
                        c = function(e) {
                            clearTimeout(e)
                        },
                        l = (0, o.default)((function() {
                            var e = r.requestAnimationFrame || r.webkitRequestAnimationFrame || r.mozRequestAnimationFrame || r.oRequestAnimationFrame || r.msRequestAnimationFrame,
                                t = r.cancelAnimationFrame || r.webkitCancelAnimationFrame || r.mozCancelAnimationFrame || r.oCancelAnimationFrame || r.msCancelAnimationFrame;
                            if (e && t && (s = e, c = t), e && !t) {
                                var n = {};
                                s = function(t) {
                                    var i = e.call(r, (function() {
                                        try {
                                            if (i in n) {
                                                return
                                            }
                                            t.apply(this, arguments)
                                        } finally {
                                            delete n[i]
                                        }
                                    }));
                                    return i
                                }, c = function(e) {
                                    n[e] = !0
                                }
                            }
                        }))
                },
            87209:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/fx.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = y(n( /*! ../core/renderer */ 68374)),
                        a = n( /*! ../core/utils/window */ 58201),
                        o = y(n( /*! ../events/core/events_engine */ 55994)),
                        r = y(n( /*! ../core/errors */ 17381)),
                        s = n( /*! ../core/element */ 6415),
                        c = n( /*! ../core/utils/extend */ 13306),
                        l = n( /*! ../core/utils/type */ 35922),
                        u = n( /*! ../core/utils/iterator */ 95479),
                        d = n( /*! ./translator */ 31648),
                        f = n( /*! ./easing */ 23908),
                        h = n( /*! ./frame */ 90057),
                        g = n( /*! ../core/utils/support */ 60137),
                        p = y(n( /*! ./position */ 49387)),
                        m = n( /*! ../core/remove_event */ 37819),
                        _ = n( /*! ../events/utils/index */ 39611),
                        v = n( /*! ../core/utils/deferred */ 62754),
                        x = n( /*! ../core/utils/common */ 20576);

                    function y(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function b(e) {
                        return b = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, b(e)
                    }
                    var w = (0, a.getWindow)(),
                        k = (0, _.addNamespace)(m.removeEvent, "dxFX"),
                        S = /^([+-])=(.*)/i,
                        C = "dxAnimData",
                        A = "dxAnimQueue",
                        I = {
                            initAnimation: function(e, t) {
                                e.css({
                                    transitionProperty: "none"
                                }), "string" == typeof t.from ? e.addClass(t.from) : Y(e, t.from);
                                var n = this,
                                    i = new v.Deferred,
                                    a = t.cleanupWhen;
                                t.transitionAnimation = {
                                    deferred: i,
                                    finish: function() {
                                        n._finishTransition(e), a ? (0, v.when)(i, a).always((function() {
                                            n._cleanup(e, t)
                                        })) : n._cleanup(e, t), i.resolveWith(e, [t, e])
                                    }
                                }, this._completeAnimationCallback(e, t).done((function() {
                                    t.transitionAnimation.finish()
                                })).fail((function() {
                                    i.rejectWith(e, [t, e])
                                })), t.duration || t.transitionAnimation.finish(), e.css("transform")
                            },
                            animate: function(e, t) {
                                return this._startAnimation(e, t), t.transitionAnimation.deferred.promise()
                            },
                            _completeAnimationCallback: function(e, t) {
                                var n, i = this,
                                    a = Date.now() + t.delay,
                                    r = new v.Deferred,
                                    s = new v.Deferred,
                                    c = new v.Deferred,
                                    l = (0, g.transitionEndEventName)() + ".dxFX";
                                t.transitionAnimation.cleanup = function() {
                                    clearTimeout(n), clearTimeout(u), o.default.off(e, l), o.default.off(e, k)
                                }, o.default.one(e, l, (function() {
                                    Date.now() - a >= t.duration && s.reject()
                                })), o.default.off(e, k), o.default.on(e, k, (function() {
                                    i.stop(e, t), r.reject()
                                }));
                                var u = setTimeout((function() {
                                    n = setTimeout((function() {
                                        c.reject()
                                    }), t.duration + t.delay + K._simulatedTransitionEndDelay), (0, v.when)(s, c).fail(function() {
                                        r.resolve()
                                    }.bind(this))
                                }));
                                return r.promise()
                            },
                            _startAnimation: function(e, t) {
                                e.css({
                                    transitionProperty: "all",
                                    transitionDelay: t.delay + "ms",
                                    transitionDuration: t.duration + "ms",
                                    transitionTimingFunction: t.easing
                                }), "string" == typeof t.to ? e[0].className += " " + t.to : t.to && Y(e, t.to)
                            },
                            _finishTransition: function(e) {
                                e.css("transition", "none")
                            },
                            _cleanup: function(e, t) {
                                t.transitionAnimation.cleanup(), "string" == typeof t.from && (e.removeClass(t.from), e.removeClass(t.to))
                            },
                            stop: function(e, t, n) {
                                t && (n ? t.transitionAnimation.finish() : ((0, l.isPlainObject)(t.to) && (0, u.each)(t.to, (function(t) {
                                    e.css(t, e.css(t))
                                })), this._finishTransition(e), this._cleanup(e, t)))
                            }
                        },
                        T = {
                            initAnimation: function(e, t) {
                                Y(e, t.from)
                            },
                            animate: function(e, t) {
                                var n = new v.Deferred,
                                    i = this;
                                return t ? ((0, u.each)(t.to, (function(n) {
                                    void 0 === t.from[n] && (t.from[n] = i._normalizeValue(e.css(n)))
                                })), t.to.transform && (t.from.transform = i._parseTransform(t.from.transform), t.to.transform = i._parseTransform(t.to.transform)), t.frameAnimation = {
                                    to: t.to,
                                    from: t.from,
                                    currentValue: t.from,
                                    easing: (0, f.convertTransitionTimingFuncToEasing)(t.easing),
                                    duration: t.duration,
                                    startTime: (new Date).valueOf(),
                                    finish: function() {
                                        this.currentValue = this.to, this.draw(), (0, h.cancelAnimationFrame)(t.frameAnimation.animationFrameId), n.resolve()
                                    },
                                    draw: function() {
                                        if (t.draw) {
                                            t.draw(this.currentValue)
                                        } else {
                                            var n = (0, c.extend)({}, this.currentValue);
                                            n.transform && (n.transform = (0, u.map)(n.transform, (function(e, t) {
                                                return "translate" === t ? (0, d.getTranslateCss)(e) : "scale" === t ? "scale(" + e + ")" : "rotate" === t.substr(0, t.length - 1) ? t + "(" + e + "deg)" : void 0
                                            })).join(" ")), e.css(n)
                                        }
                                    }
                                }, t.delay ? (t.frameAnimation.startTime += t.delay, t.frameAnimation.delayTimeout = setTimeout((function() {
                                    i._startAnimation(e, t)
                                }), t.delay)) : i._startAnimation(e, t), n.promise()) : n.reject().promise()
                            },
                            _startAnimation: function(e, t) {
                                o.default.off(e, k), o.default.on(e, k, (function() {
                                    t.frameAnimation && (0, h.cancelAnimationFrame)(t.frameAnimation.animationFrameId)
                                })), this._animationStep(e, t)
                            },
                            _parseTransform: function(e) {
                                var t = {};
                                return (0, u.each)(e.match(/\w+\d*\w*\([^)]*\)\s*/g), (function(e, n) {
                                    var i = (0, d.parseTranslate)(n),
                                        a = n.match(/scale\((.+?)\)/),
                                        o = n.match(/(rotate.)\((.+)deg\)/);
                                    i && (t.translate = i), a && a[1] && (t.scale = parseFloat(a[1])), o && o[1] && (t[o[1]] = parseFloat(o[2]))
                                })), t
                            },
                            stop: function(e, t, n) {
                                var i = t && t.frameAnimation;
                                i && ((0, h.cancelAnimationFrame)(i.animationFrameId), clearTimeout(i.delayTimeout), n && i.finish(), delete t.frameAnimation)
                            },
                            _animationStep: function(e, t) {
                                var n = t && t.frameAnimation;
                                if (n) {
                                    var i = (new Date).valueOf();
                                    if (i >= n.startTime + n.duration) {
                                        n.finish()
                                    } else {
                                        n.currentValue = this._calcStepValue(n, i - n.startTime), n.draw();
                                        var a = this;
                                        n.animationFrameId = (0, h.requestAnimationFrame)((function() {
                                            a._animationStep(e, t)
                                        }))
                                    }
                                }
                            },
                            _calcStepValue: function(e, t) {
                                return function n(i, a) {
                                    var o = Array.isArray(a) ? [] : {};
                                    return (0, u.each)(a, (function(r, s) {
                                        if ("string" == typeof s && !1 === parseFloat(s, 10)) {
                                            return !0
                                        }
                                        o[r] = "object" === b(s) ? n(i[r], s) : function(n) {
                                            var o = t / e.duration,
                                                r = t,
                                                s = 1 * i[n],
                                                c = a[n] - i[n],
                                                l = e.duration;
                                            return (0, f.getEasing)(e.easing)(o, r, s, c, l)
                                        }(r)
                                    })), o
                                }(e.from, e.to)
                            },
                            _normalizeValue: function(e) {
                                var t = parseFloat(e, 10);
                                return !1 === t ? e : t
                            }
                        },
                        E = {
                            initAnimation: function() {},
                            animate: function() {
                                return (new v.Deferred).resolve().promise()
                            },
                            stop: x.noop,
                            isSynchronous: !0
                        },
                        O = function(e, t, n, i) {
                            (0, u.each)(["from", "to"], (function() {
                                if (!n(e[this])) {
                                    throw r.default.Error("E0010", t, this, i)
                                }
                            }))
                        },
                        D = function(e, t) {
                            return O(e, t, (function(e) {
                                return (0, l.isPlainObject)(e)
                            }), "a plain object")
                        },
                        M = {
                            top: {
                                my: "bottom center",
                                at: "top center"
                            },
                            bottom: {
                                my: "top center",
                                at: "bottom center"
                            },
                            right: {
                                my: "left center",
                                at: "right center"
                            },
                            left: {
                                my: "right center",
                                at: "left center"
                            }
                        },
                        P = {
                            validateConfig: function(e) {
                                D(e, "slide")
                            },
                            setup: function(e, t) {
                                var n = (0, d.locate)(e);
                                if ("slide" !== t.type) {
                                    var i = "slideIn" === t.type ? t.from : t.to;
                                    i.position = (0, c.extend)({
                                        of: w
                                    }, M[t.direction]), $(e, i)
                                }
                                this._setUpConfig(n, t.from), this._setUpConfig(n, t.to), (0, d.clearCache)(e)
                            },
                            _setUpConfig: function(e, t) {
                                t.left = "left" in t ? t.left : "+=0", t.top = "top" in t ? t.top : "+=0", this._initNewPosition(e, t)
                            },
                            _initNewPosition: function(e, t) {
                                var n = {
                                    left: t.left,
                                    top: t.top
                                };
                                delete t.left, delete t.top;
                                var i = this._getRelativeValue(n.left);
                                void 0 !== i ? n.left = i + e.left : t.left = 0, void 0 !== (i = this._getRelativeValue(n.top)) ? n.top = i + e.top : t.top = 0, t.transform = (0, d.getTranslateCss)({
                                    x: n.left,
                                    y: n.top
                                })
                            },
                            _getRelativeValue: function(e) {
                                var t;
                                if ("string" == typeof e && (t = S.exec(e))) {
                                    return parseInt(t[1] + "1") * t[2]
                                }
                            }
                        },
                        R = {
                            setup: function(e, t) {
                                var n, i, a = t.from,
                                    o = t.to,
                                    r = "fadeOut" === t.type ? 1 : 0,
                                    s = "fadeOut" === t.type ? 0 : 1,
                                    c = (0, l.isPlainObject)(a) ? String(null !== (n = a.opacity) && void 0 !== n ? n : r) : String(a),
                                    u = (0, l.isPlainObject)(o) ? String(null !== (i = o.opacity) && void 0 !== i ? i : s) : String(o);
                                switch (t.skipElementInitialStyles || (c = e.css("opacity")), t.type) {
                                    case "fadeIn":
                                        u = 1;
                                        break;
                                    case "fadeOut":
                                        u = 0
                                }
                                t.from = {
                                    visibility: "visible",
                                    opacity: c
                                }, t.to = {
                                    opacity: u
                                }
                            }
                        },
                        q = {
                            custom: {
                                setup: function() {}
                            },
                            slide: P,
                            slideIn: P,
                            slideOut: P,
                            fade: R,
                            fadeIn: R,
                            fadeOut: R,
                            pop: {
                                validateConfig: function(e) {
                                    D(e, "pop")
                                },
                                setup: function(e, t) {
                                    var n = t.from,
                                        i = t.to,
                                        a = "opacity" in n ? n.opacity : e.css("opacity"),
                                        o = "opacity" in i ? i.opacity : 1,
                                        r = "scale" in n ? n.scale : 0,
                                        s = "scale" in i ? i.scale : 1;
                                    t.from = {
                                        opacity: a
                                    };
                                    var c = (0, d.getTranslate)(e);
                                    t.from.transform = this._getCssTransform(c, r), t.to = {
                                        opacity: o
                                    }, t.to.transform = this._getCssTransform(c, s)
                                },
                                _getCssTransform: function(e, t) {
                                    return (0, d.getTranslateCss)(e) + "scale(" + t + ")"
                                }
                            },
                            css: {
                                validateConfig: function(e) {
                                    ! function(e, t) {
                                        O(e, "css", (function(e) {
                                            return "string" == typeof e
                                        }), "a string")
                                    }(e)
                                },
                                setup: function() {}
                            }
                        },
                        z = {
                            type: "custom",
                            from: {},
                            to: {},
                            duration: 400,
                            start: x.noop,
                            complete: x.noop,
                            easing: "ease",
                            delay: 0
                        },
                        L = {
                            duration: 400,
                            easing: "ease",
                            delay: 0
                        };

                    function B() {
                        var e = this,
                            t = e.element,
                            n = e.config;
                        if ($(t, n.from), $(t, n.to), e.configurator.setup(t, n), t.data(C, e), K.off && (n.duration = 0, n.delay = 0), e.strategy.initAnimation(t, n), n.start) {
                            var i = (0, s.getPublicElement)(t);
                            n.start.apply(this, [i, n])
                        }
                    }
                    var V = function() {
                            var e = this,
                                t = e.element,
                                n = e.config;
                            return e.isStarted = !0, e.strategy.animate(t, n).done((function() {
                                ! function(e) {
                                    var t = e.element,
                                        n = e.config;
                                    if (t.removeData(C), n.complete) {
                                        var i = (0, s.getPublicElement)(t);
                                        n.complete.apply(this, [i, n])
                                    }
                                    e.deferred.resolveWith(this, [t, n])
                                }(e)
                            })).fail((function() {
                                e.deferred.rejectWith(this, [t, n])
                            }))
                        },
                        F = function(e) {
                            var t = this,
                                n = t.element,
                                i = t.config;
                            clearTimeout(t.startTimeout), t.isStarted || t.start(), t.strategy.stop(n, i, e)
                        },
                        N = (0, _.addNamespace)(m.removeEvent, "dxFXStartAnimation"),
                        H = function(e, t) {
                            var n = "css" === t.type ? L : z,
                                a = (0, c.extend)(!0, {}, n, t),
                                s = function(e) {
                                    var t = q[e.type];
                                    if (!t) {
                                        throw r.default.Error("E0011", e.type)
                                    }
                                    return t
                                }(a),
                                u = function(e) {
                                    e = e || {};
                                    var t = {
                                            transition: (0, g.transition)() ? I : T,
                                            frame: T,
                                            noAnimation: E
                                        },
                                        n = e.strategy || "transition";
                                    return "css" !== e.type || (0, g.transition)() || (n = "noAnimation"), t[n]
                                }(a),
                                d = {
                                    element: (0, i.default)(e),
                                    config: a,
                                    configurator: s,
                                    strategy: u,
                                    isSynchronous: u.isSynchronous,
                                    setup: B,
                                    start: V,
                                    stop: F,
                                    deferred: new v.Deferred
                                };
                            return (0, l.isFunction)(s.validateConfig) && s.validateConfig(a),
                                function(e) {
                                    o.default.off(e.element, N), o.default.on(e.element, N, (function() {
                                        K.stop(e.element)
                                    })), e.deferred.always((function() {
                                        o.default.off(e.element, N)
                                    }))
                                }(d), d
                        };

                    function j(e) {
                        return e.data(A) || []
                    }
                    var G = function(e) {
                        e.removeData(A)
                    };

                    function W(e) {
                        return !!e.data(C)
                    }

                    function U(e, t) {
                        if ((t = j(e)).length) {
                            var n = t.shift();
                            0 === t.length && G(e),
                                function(e) {
                                    e.setup(), K.off || e.isSynchronous ? e.start() : e.startTimeout = setTimeout((function() {
                                        e.start()
                                    }));
                                    return e.deferred.promise()
                                }(n).done((function() {
                                    W(e) || U(e)
                                }))
                        }
                    }

                    function $(e, t) {
                        if (t && t.position) {
                            var n = (0, i.default)(w),
                                a = 0,
                                o = 0,
                                r = p.default.calculate(e, t.position),
                                s = e.offset(),
                                l = e.position();
                            l.top > s.top && (o = n.scrollTop()), l.left > s.left && (a = n.scrollLeft()), (0, c.extend)(t, {
                                left: r.h.location - s.left + l.left - a,
                                top: r.v.location - s.top + l.top - o
                            }), delete t.position
                        }
                    }

                    function Y(e, t) {
                        (0, u.each)(t, (function(t, n) {
                            try {
                                e.css(t, (0, l.isFunction)(n) ? n() : n)
                            } catch (e) {}
                        }))
                    }
                    var K = {
                            off: !1,
                            animationTypes: q,
                            animate: function(e, t) {
                                var n = (0, i.default)(e);
                                if (!n.length) {
                                    return (new v.Deferred).resolve().promise()
                                }
                                var a = H(n, t);
                                return function(e, t) {
                                    var n = j(e);
                                    (function(e, t) {
                                        e.data(A, t)
                                    })(e, n), n.push(t), W(e) || U(e, n)
                                }(n, a), a.deferred.promise()
                            },
                            createAnimation: H,
                            isAnimating: W,
                            stop: function(e, t) {
                                var n = (0, i.default)(e),
                                    a = j(n);
                                (0, u.each)(a, (function(e, t) {
                                    t.config.delay = 0, t.config.duration = 0, t.isSynchronous = !0
                                })), W(n) || U(n, a);
                                var o = n.data(C);
                                o && o.stop(t), n.removeData(C), G(n)
                            },
                            _simulatedTransitionEndDelay: 100
                        },
                        X = K;
                    t.default = X, e.exports = t.default, e.exports.default = t.default
                },
            49387:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/position.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/size */ 58664),
                        a = m(n( /*! ../core/renderer */ 68374)),
                        o = n( /*! ../core/utils/common */ 20576),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = n( /*! ../core/utils/window */ 58201),
                        c = m(n( /*! ../core/dom_adapter */ 73349)),
                        l = n( /*! ../core/utils/type */ 35922),
                        u = n( /*! ../core/utils/extend */ 13306),
                        d = n( /*! ../core/utils/position */ 37518),
                        f = m(n( /*! ../core/utils/browser */ 47810)),
                        h = n( /*! ./translator */ 31648),
                        g = n( /*! ../core/utils/support */ 60137),
                        p = m(n( /*! ../core/devices */ 20530));

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var _, v = (0, s.getWindow)(),
                        x = /left|right/,
                        y = /top|bottom/,
                        b = /fit|flip|none/,
                        w = /scale\(.+?\)/,
                        k = f.default.safari,
                        S = function(e) {
                            var t = {
                                    h: "center",
                                    v: "center"
                                },
                                n = (0, o.splitPair)(e);
                            return n && (0, r.each)(n, (function() {
                                var e = String(this).toLowerCase();
                                x.test(e) ? t.h = e : y.test(e) && (t.v = e)
                            })), t
                        },
                        C = function(e) {
                            return (0, o.pairToObject)(e)
                        },
                        A = function(e) {
                            switch (e) {
                                case "center":
                                    return .5;
                                case "right":
                                case "bottom":
                                    return 1;
                                default:
                                    return 0
                            }
                        },
                        I = function(e) {
                            switch (e) {
                                case "left":
                                    return "right";
                                case "right":
                                    return "left";
                                case "top":
                                    return "bottom";
                                case "bottom":
                                    return "top";
                                default:
                                    return e
                            }
                        },
                        T = function(e, t) {
                            var n = 0;
                            return e.myLocation < t.min && (n += t.min - e.myLocation), e.myLocation > t.max && (n += e.myLocation - t.max), n
                        },
                        E = function(e, t, n) {
                            return t.myLocation < n.min ? "h" === e ? "left" : "top" : t.myLocation > n.max ? "h" === e ? "right" : "bottom" : "none"
                        },
                        O = function(e) {
                            e.myLocation = e.atLocation + A(e.atAlign) * e.atSize - A(e.myAlign) * e.mySize + e.offset
                        },
                        D = {
                            fit: function(e, t) {
                                var n = !1;
                                e.myLocation > t.max && (e.myLocation = t.max, n = !0), e.myLocation < t.min && (e.myLocation = t.min, n = !0), e.fit = n
                            },
                            flip: function(e, t) {
                                if (e.flip = !1, ("center" !== e.myAlign || "center" !== e.atAlign) && (e.myLocation < t.min || e.myLocation > t.max)) {
                                    var n = (0, u.extend)({}, e, {
                                        myAlign: I(e.myAlign),
                                        atAlign: I(e.atAlign),
                                        offset: -e.offset
                                    });
                                    O(n), n.oversize = T(n, t), (n.myLocation >= t.min && n.myLocation <= t.max || e.oversize > n.oversize) && (e.myLocation = n.myLocation, e.oversize = n.oversize, e.flip = !0)
                                }
                            },
                            flipfit: function(e, t) {
                                this.flip(e, t), this.fit(e, t)
                            },
                            none: function(e) {
                                e.oversize = 0
                            }
                        },
                        M = function() {
                            var e = (0, a.default)("<div>").css({
                                    width: 100,
                                    height: 100,
                                    overflow: "scroll",
                                    position: "absolute",
                                    top: -9999
                                }).appendTo((0, a.default)("body")),
                                t = e.get(0).offsetWidth - e.get(0).clientWidth;
                            e.remove(), _ = t
                        },
                        P = {
                            h: {
                                location: 0,
                                flip: !1,
                                fit: !1,
                                oversize: 0
                            },
                            v: {
                                location: 0,
                                flip: !1,
                                fit: !1,
                                oversize: 0
                            }
                        },
                        R = function(e, t) {
                            var n = (0, a.default)(e),
                                r = n.offset(),
                                s = (0, u.extend)(!0, {}, P, {
                                    h: {
                                        location: r.left
                                    },
                                    v: {
                                        location: r.top
                                    }
                                });
                            if (!t) {
                                return s
                            }
                            var f = S(t.my),
                                h = S(t.at),
                                m = (0, a.default)(t.of).length && t.of || v,
                                x = C(t.offset),
                                y = function(e) {
                                    var t = (0, o.splitPair)(e),
                                        n = String(t && t[0]).toLowerCase(),
                                        i = String(t && t[1]).toLowerCase();
                                    return b.test(n) || (n = "none"), b.test(i) || (i = n), {
                                        h: n,
                                        v: i
                                    }
                                }(t.collision),
                                w = t.boundary,
                                A = C(t.boundaryOffset),
                                I = {
                                    mySize: (0, i.getOuterWidth)(n),
                                    myAlign: f.h,
                                    atAlign: h.h,
                                    offset: x.h,
                                    collision: y.h,
                                    boundaryOffset: A.h
                                },
                                R = {
                                    mySize: (0, i.getOuterHeight)(n),
                                    myAlign: f.v,
                                    atAlign: h.v,
                                    offset: x.v,
                                    collision: y.v,
                                    boundaryOffset: A.v
                                };
                            if (m.preventDefault) {
                                I.atLocation = m.pageX, R.atLocation = m.pageY, I.atSize = 0, R.atSize = 0
                            } else if (m = (0, a.default)(m), (0, l.isWindow)(m[0])) {
                                I.atLocation = m.scrollLeft(), R.atLocation = m.scrollTop(), "phone" === p.default.real().deviceType && m[0].visualViewport ? (I.atLocation = Math.max(I.atLocation, m[0].visualViewport.offsetLeft), R.atLocation = Math.max(R.atLocation, m[0].visualViewport.offsetTop), I.atSize = m[0].visualViewport.width, R.atSize = m[0].visualViewport.height) : (I.atSize = m[0].innerWidth > m[0].outerWidth ? m[0].innerWidth : (0, i.getWidth)(m), R.atSize = m[0].innerHeight > m[0].outerHeight || k ? m[0].innerHeight : (0, i.getHeight)(m))
                            } else if (9 === m[0].nodeType) {
                                I.atLocation = 0, R.atLocation = 0, I.atSize = (0, i.getWidth)(m), R.atSize = (0, i.getHeight)(m)
                            } else {
                                var q = (0, d.getBoundingRect)(m.get(0)),
                                    L = z(m);
                                I.atLocation = L.left, R.atLocation = L.top, I.atSize = Math.max(q.width, (0, i.getOuterWidth)(m)), R.atSize = Math.max(q.height, (0, i.getOuterHeight)(m))
                            }
                            O(I), O(R);
                            var B = function() {
                                var e = (0, a.default)(v),
                                    t = (0, i.getWidth)(e),
                                    n = (0, i.getHeight)(e),
                                    o = e.scrollLeft(),
                                    r = e.scrollTop(),
                                    s = c.default.getDocumentElement(),
                                    l = g.touch ? s.clientWidth / t : 1,
                                    u = g.touch ? s.clientHeight / n : 1;
                                void 0 === _ && M();
                                var d = t,
                                    f = n;
                                if (w) {
                                    var h = (0, a.default)(w),
                                        p = h.offset();
                                    o = p.left, r = p.top, d = (0, i.getWidth)(h), f = (0, i.getHeight)(h)
                                }
                                return {
                                    h: {
                                        min: o + I.boundaryOffset,
                                        max: o + d / l - I.mySize - I.boundaryOffset
                                    },
                                    v: {
                                        min: r + R.boundaryOffset,
                                        max: r + f / u - R.mySize - R.boundaryOffset
                                    }
                                }
                            }();
                            I.oversize = T(I, B.h), R.oversize = T(R, B.v), I.collisionSide = E("h", I, B.h), R.collisionSide = E("v", R, B.v), D[I.collision] && D[I.collision](I, B.h), D[R.collision] && D[R.collision](R, B.v);
                            var V = function(e) {
                                return t.precise ? e : Math.round(e)
                            };
                            return (0, u.extend)(!0, s, {
                                h: {
                                    location: V(I.myLocation),
                                    oversize: V(I.oversize),
                                    fit: I.fit,
                                    flip: I.flip,
                                    collisionSide: I.collisionSide
                                },
                                v: {
                                    location: V(R.myLocation),
                                    oversize: V(R.oversize),
                                    fit: R.fit,
                                    flip: R.flip,
                                    collisionSide: R.collisionSide
                                },
                                precise: t.precise
                            }), s
                        },
                        q = function(e, t, n, i, a) {
                            (0, l.isDefined)(e.style) && !c.default.isNode(e.style) ? e.style.transform = a ? n.replace(t, "") : n : e.setAttribute("style", a ? i.replace(t, "") : i)
                        },
                        z = function e(t) {
                            var n, i, a, o = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : t,
                                r = o.get(0);
                            if (!r) {
                                return t.offset()
                            }
                            var s, c = (null === (n = r.getAttribute) || void 0 === n ? void 0 : n.call(r, "style")) || "",
                                l = null === (i = r.style) || void 0 === i ? void 0 : i.transform,
                                u = null === (a = c.match(w)) || void 0 === a ? void 0 : a[0];
                            return u ? (q(r, u, l, c, !0), s = e(t, o.parent()), q(r, u, l, c, !1)) : s = e(t, o.parent()), s
                        },
                        L = function(e, t) {
                            var n = (0, a.default)(e);
                            if (!t) {
                                return n.offset()
                            }(0, h.resetPosition)(n, !0);
                            var i = z(n),
                                o = t.h && t.v ? t : R(n, t),
                                r = function(e) {
                                    return t.precise ? e : Math.round(e)
                                };
                            return (0, h.move)(n, {
                                left: o.h.location - r(i.left),
                                top: o.v.location - r(i.top)
                            }), o
                        };
                    L.inverseAlign || (L.inverseAlign = I), L.normalizeAlign || (L.normalizeAlign = S);
                    var B = {
                        calculateScrollbarWidth: M,
                        calculate: R,
                        setup: L,
                        offset: function(e) {
                            return e = (0, a.default)(e).get(0), (0, l.isWindow)(e) ? null : e && "pageY" in e && "pageX" in e ? {
                                top: e.pageY,
                                left: e.pageX
                            } : (0, a.default)(e).offset()
                        }
                    };
                    t.default = B, e.exports = t.default, e.exports.default = t.default
                },
            42814:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/presets/presets.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.presets = t.PresetCollection = void 0;
                    var i = n( /*! ../../core/utils/size */ 58664),
                        a = n( /*! ../../core/component */ 44297),
                        o = n( /*! ../../core/utils/iterator */ 95479),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = l(n( /*! ../../core/devices */ 20530)),
                        c = l(n( /*! ../fx */ 87209));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = {
                            forward: " dx-forward",
                            backward: " dx-backward",
                            none: " dx-no-direction",
                            undefined: " dx-no-direction"
                        },
                        d = a.Component.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._registeredPresets = [], this.resetToDefaults()
                            },
                            _getDefaultOptions: function() {
                                return (0, r.extend)(this.callBase(), {
                                    defaultAnimationDuration: 400,
                                    defaultAnimationDelay: 0,
                                    defaultStaggerAnimationDuration: 300,
                                    defaultStaggerAnimationDelay: 40,
                                    defaultStaggerAnimationStartDelay: 500
                                })
                            },
                            _defaultOptionsRules: function() {
                                return this.callBase().concat([{
                                    device: function(e) {
                                        return e.phone
                                    },
                                    options: {
                                        defaultStaggerAnimationDuration: 350,
                                        defaultStaggerAnimationDelay: 50,
                                        defaultStaggerAnimationStartDelay: 0
                                    }
                                }, {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    options: {
                                        defaultAnimationDelay: 100
                                    }
                                }])
                            },
                            _getPresetOptionName: function(e) {
                                return "preset_" + e
                            },
                            _createAndroidSlideAnimationConfig: function(e, t) {
                                var n = this,
                                    a = function(e) {
                                        return {
                                            type: "slide",
                                            delay: void 0 === e.delay ? n.option("defaultAnimationDelay") : e.delay,
                                            duration: void 0 === e.duration ? n.option("defaultAnimationDuration") : e.duration
                                        }
                                    };
                                return {
                                    enter: function(n, o) {
                                        var r = (0, i.getWidth)(n.parent()) * t,
                                            s = o.direction,
                                            l = a(o);
                                        return l.to = {
                                            left: 0,
                                            opacity: 1
                                        }, l.from = "forward" === s ? {
                                            left: r,
                                            opacity: e
                                        } : "backward" === s ? {
                                            left: -r,
                                            opacity: e
                                        } : {
                                            left: 0,
                                            opacity: 0
                                        }, c.default.createAnimation(n, l)
                                    },
                                    leave: function(n, o) {
                                        var r = (0, i.getWidth)(n.parent()) * t,
                                            s = o.direction,
                                            l = a(o);
                                        return l.from = {
                                            left: 0,
                                            opacity: 1
                                        }, l.to = "forward" === s ? {
                                            left: -r,
                                            opacity: e
                                        } : "backward" === s ? {
                                            left: r,
                                            opacity: e
                                        } : {
                                            left: 0,
                                            opacity: 0
                                        }, c.default.createAnimation(n, l)
                                    }
                                }
                            },
                            _createOpenDoorConfig: function() {
                                var e = this,
                                    t = function(t) {
                                        return {
                                            type: "css",
                                            extraCssClasses: "dx-opendoor-animation",
                                            delay: void 0 === t.delay ? e.option("defaultAnimationDelay") : t.delay,
                                            duration: void 0 === t.duration ? e.option("defaultAnimationDuration") : t.duration
                                        }
                                    };
                                return {
                                    enter: function(e, n) {
                                        var i = n.direction,
                                            a = t(n);
                                        return a.delay = "none" === i ? a.delay : a.duration, a.from = "dx-enter dx-opendoor-animation" + u[i], a.to = "dx-enter-active", c.default.createAnimation(e, a)
                                    },
                                    leave: function(e, n) {
                                        var i = n.direction,
                                            a = t(n);
                                        return a.from = "dx-leave dx-opendoor-animation" + u[i], a.to = "dx-leave-active", c.default.createAnimation(e, a)
                                    }
                                }
                            },
                            _createWinPopConfig: function() {
                                var e = this,
                                    t = {
                                        type: "css",
                                        extraCssClasses: "dx-win-pop-animation",
                                        duration: e.option("defaultAnimationDuration")
                                    };
                                return {
                                    enter: function(n, i) {
                                        var a = t,
                                            o = i.direction;
                                        return a.delay = "none" === o ? e.option("defaultAnimationDelay") : e.option("defaultAnimationDuration") / 2, a.from = "dx-enter dx-win-pop-animation" + u[o], a.to = "dx-enter-active", c.default.createAnimation(n, a)
                                    },
                                    leave: function(n, i) {
                                        var a = t,
                                            o = i.direction;
                                        return a.delay = e.option("defaultAnimationDelay"), a.from = "dx-leave dx-win-pop-animation" + u[o], a.to = "dx-leave-active", c.default.createAnimation(n, a)
                                    }
                                }
                            },
                            resetToDefaults: function() {
                                this.clear(), this.registerDefaultPresets(), this.applyChanges()
                            },
                            clear: function(e) {
                                var t = this,
                                    n = [];
                                (0, o.each)(this._registeredPresets, (function(i, a) {
                                    e && e !== a.name ? n.push(a) : t.option(t._getPresetOptionName(a.name), void 0)
                                })), this._registeredPresets = n, this.applyChanges()
                            },
                            registerPreset: function(e, t) {
                                this._registeredPresets.push({
                                    name: e,
                                    config: t
                                })
                            },
                            applyChanges: function() {
                                var e = this,
                                    t = [];
                                (0, o.each)(this._registeredPresets, (function(n, i) {
                                    var a = {
                                        device: i.config.device,
                                        options: {}
                                    };
                                    a.options[e._getPresetOptionName(i.name)] = i.config.animation, t.push(a)
                                })), this._setOptionsByDevice(t)
                            },
                            getPreset: function(e) {
                                for (var t = e;
                                    "string" == typeof t;) {
                                    t = this.option(this._getPresetOptionName(t))
                                }
                                return t
                            },
                            registerDefaultPresets: function() {
                                this.registerPreset("pop", {
                                    animation: {
                                        extraCssClasses: "dx-android-pop-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("openDoor", {
                                    animation: this._createOpenDoorConfig()
                                }), this.registerPreset("win-pop", {
                                    animation: this._createWinPopConfig()
                                }), this.registerPreset("fade", {
                                    animation: {
                                        extraCssClasses: "dx-fade-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("slide", {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    animation: this._createAndroidSlideAnimationConfig(1, 1)
                                }), this.registerPreset("slide", {
                                    device: function() {
                                        return !s.default.current().android && !s.default.real.android
                                    },
                                    animation: {
                                        extraCssClasses: "dx-slide-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-slide", {
                                    animation: {
                                        extraCssClasses: "dx-ios7-slide-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("overflow", {
                                    animation: {
                                        extraCssClasses: "dx-overflow-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-toolbar", {
                                    device: function() {
                                        return !s.default.current().android && !s.default.real.android
                                    },
                                    animation: {
                                        extraCssClasses: "dx-ios7-toolbar-animation",
                                        delay: this.option("defaultAnimationDelay"),
                                        duration: this.option("defaultAnimationDuration")
                                    }
                                }), this.registerPreset("ios7-toolbar", {
                                    device: function() {
                                        return s.default.current().android || s.default.real.android
                                    },
                                    animation: this._createAndroidSlideAnimationConfig(0, .4)
                                }), this.registerPreset("stagger-fade", {
                                    animation: {
                                        extraCssClasses: "dx-fade-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-slide", {
                                    animation: {
                                        extraCssClasses: "dx-slide-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-slide", {
                                    animation: {
                                        extraCssClasses: "dx-fade-slide-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-drop", {
                                    animation: {
                                        extraCssClasses: "dx-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-drop", {
                                    animation: {
                                        extraCssClasses: "dx-fade-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-rise", {
                                    animation: {
                                        extraCssClasses: "dx-fade-rise-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-3d-drop", {
                                    animation: {
                                        extraCssClasses: "dx-3d-drop-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                }), this.registerPreset("stagger-fade-zoom", {
                                    animation: {
                                        extraCssClasses: "dx-fade-zoom-animation",
                                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                        duration: this.option("defaultStaggerAnimationDuration"),
                                        delay: this.option("defaultStaggerAnimationStartDelay")
                                    }
                                })
                            }
                        });
                    t.PresetCollection = d;
                    var f = new d;
                    t.presets = f
                },
            52431:
                /*!**************************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/transition_executor/transition_executor.js ***!
                  \**************************************************************************************************/
                function(e, t, n) {
                    t.TransitionExecutor = void 0;
                    var i = f(n( /*! ../../core/renderer */ 68374)),
                        a = f(n( /*! ../../core/class */ 38377)),
                        o = n( /*! ../../core/utils/extend */ 13306),
                        r = n( /*! ../../core/utils/common */ 20576),
                        s = n( /*! ../../core/utils/type */ 35922),
                        c = n( /*! ../../core/utils/iterator */ 95479),
                        l = f(n( /*! ../fx */ 87209)),
                        u = n( /*! ../presets/presets */ 42814),
                        d = n( /*! ../../core/utils/deferred */ 62754);

                    function f(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = {
                            forward: " dx-forward",
                            backward: " dx-backward",
                            none: " dx-no-direction",
                            undefined: " dx-no-direction"
                        },
                        g = "dx-animating",
                        p = a.default.inherit({
                            ctor: function() {
                                this._accumulatedDelays = {
                                    enter: 0,
                                    leave: 0
                                }, this._animations = [], this.reset()
                            },
                            _createAnimations: function(e, t, n, a) {
                                var o = this,
                                    r = [];
                                n = n || {};
                                var s = this._prepareElementAnimationConfig(t, n, a);
                                return s && e.each((function() {
                                    var e = o._createAnimation((0, i.default)(this), s, n);
                                    e && (e.element.addClass(g), e.setup(), r.push(e))
                                })), r
                            },
                            _prepareElementAnimationConfig: function(e, t, n) {
                                var i;
                                if ("string" == typeof e) {
                                    var a = e;
                                    e = u.presets.getPreset(a)
                                }
                                if (e) {
                                    if ((0, s.isFunction)(e[n])) {
                                        i = e[n]
                                    } else {
                                        if (!(i = (0, o.extend)({
                                                skipElementInitialStyles: !0,
                                                cleanupWhen: this._completePromise
                                            }, e, t)).type || "css" === i.type) {
                                            var r = "dx-" + n,
                                                c = (i.extraCssClasses ? " " + i.extraCssClasses : "") + h[i.direction];
                                            i.type = "css", i.from = (i.from || r) + c, i.to = i.to || r + "-active"
                                        }
                                        i.staggerDelay = i.staggerDelay || 0, i.delay = i.delay || 0, i.staggerDelay && (i.delay += this._accumulatedDelays[n], this._accumulatedDelays[n] += i.staggerDelay)
                                    }
                                } else {
                                    i = void 0
                                }
                                return i
                            },
                            _createAnimation: function(e, t, n) {
                                var i;
                                return (0, s.isPlainObject)(t) ? i = l.default.createAnimation(e, t) : (0, s.isFunction)(t) && (i = t(e, n)), i
                            },
                            _startAnimations: function() {
                                for (var e = this._animations, t = 0; t < e.length; t++) {
                                    e[t].start()
                                }
                            },
                            _stopAnimations: function(e) {
                                for (var t = this._animations, n = 0; n < t.length; n++) {
                                    t[n].stop(e)
                                }
                            },
                            _clearAnimations: function() {
                                for (var e = this._animations, t = 0; t < e.length; t++) {
                                    e[t].element.removeClass(g)
                                }
                                this._animations.length = 0
                            },
                            reset: function() {
                                this._accumulatedDelays.enter = 0, this._accumulatedDelays.leave = 0, this._clearAnimations(), this._completeDeferred = new d.Deferred, this._completePromise = this._completeDeferred.promise()
                            },
                            enter: function(e, t, n) {
                                var i = this._createAnimations(e, t, n, "enter");
                                this._animations.push.apply(this._animations, i)
                            },
                            leave: function(e, t, n) {
                                var i = this._createAnimations(e, t, n, "leave");
                                this._animations.push.apply(this._animations, i)
                            },
                            start: function() {
                                var e, t = this;
                                if (this._animations.length) {
                                    var n = (0, c.map)(this._animations, (function(e) {
                                        var t = new d.Deferred;
                                        return e.deferred.always((function() {
                                            t.resolve()
                                        })), t.promise()
                                    }));
                                    e = d.when.apply(i.default, n).always((function() {
                                        t._completeDeferred.resolve(), t.reset()
                                    })), (0, r.executeAsync)((function() {
                                        t._startAnimations()
                                    }))
                                } else {
                                    t.reset(), e = (new d.Deferred).resolve().promise()
                                }
                                return e
                            },
                            stop: function(e) {
                                this._stopAnimations(e)
                            }
                        });
                    t.TransitionExecutor = p
                },
            31648:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/animation/translator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.resetPosition = t.parseTranslate = t.move = t.locate = t.getTranslateCss = t.getTranslate = t.clearCache = void 0;
                    var i, a = (i = n( /*! ../core/renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../core/element_data */ 97906),
                        r = n( /*! ../core/utils/type */ 35922);
                    var s = "dxTranslator",
                        c = /matrix(3d)?\((.+?)\)/,
                        l = /translate(?:3d)?\((.+?)\)/;

                    function u(e) {
                        return "string" === (0, r.type)(e) && "%" === e[e.length - 1]
                    }

                    function d(e, t) {
                        e.length && (0, o.data)(e.get(0), s, t)
                    }
                    t.locate = function(e) {
                        e = (0, a.default)(e);
                        var t = g(e);
                        return {
                            left: t.x,
                            top: t.y
                        }
                    };
                    var f = function(e) {
                        e.length && (0, o.removeData)(e.get(0), s)
                    };
                    t.clearCache = f;
                    var h = function(e) {
                        return e.x = e.x || 0, e.y = e.y || 0, "translate(" + (u(e.x) ? e.x : e.x + "px") + ", " + (u(e.y) ? e.y : e.y + "px") + ")"
                    };
                    t.getTranslateCss = h;
                    var g = function(e) {
                        var t = e.length ? (0, o.data)(e.get(0), s) : null;
                        if (!t) {
                            var n = (e.css("transform") || h({
                                    x: 0,
                                    y: 0
                                })).match(c),
                                i = n && n[1];
                            n ? (n = n[2].split(","), "3d" === i ? n = n.slice(12, 15) : (n.push(0), n = n.slice(4, 7))) : n = [0, 0, 0], d(e, t = {
                                x: parseFloat(n[0]),
                                y: parseFloat(n[1]),
                                z: parseFloat(n[2])
                            })
                        }
                        return t
                    };
                    t.getTranslate = g;
                    t.move = function(e, t) {
                        e = (0, a.default)(e);
                        var n, i = t.left,
                            o = t.top;
                        void 0 === i ? (n = g(e)).y = o || 0 : void 0 === o ? (n = g(e)).x = i || 0 : d(e, n = {
                            x: i || 0,
                            y: o || 0,
                            z: 0
                        }), e.css({
                            transform: h(n)
                        }), (u(i) || u(o)) && f(e)
                    };
                    t.resetPosition = function(e, t) {
                        var n;
                        e = (0, a.default)(e);
                        var i = {
                            left: 0,
                            top: 0,
                            transform: "none"
                        };
                        t && (n = e.css("transition"), i.transition = "none"), e.css(i), f(e), t && (e.get(0).offsetHeight, e.css("transition", n))
                    };
                    t.parseTranslate = function(e) {
                        var t = e.match(l);
                        if (t && t[1]) {
                            return t = t[1].split(","), {
                                x: parseFloat(t[0]),
                                y: parseFloat(t[1]),
                                z: parseFloat(t[2])
                            }
                        }
                    }
                },
            36991:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/core.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../../core/utils/window */ 58201).getWindow(),
                        a = i.DevExpress = i.DevExpress || {},
                        o = a.errors = n( /*! ../../core/errors */ 17381);
                    if (a._DEVEXTREME_BUNDLE_INITIALIZED) {
                        throw o.Error("E0024")
                    }
                    a._DEVEXTREME_BUNDLE_INITIALIZED = !0, a.clientExporter = n( /*! ../../exporter */ 78292), a.excelExporter = n( /*! ../../excel_exporter */ 2994), a.pdfExporter = n( /*! ../../pdf_exporter */ 44194), a.VERSION = n( /*! ../../core/version */ 36739).version, a.Class = n( /*! ../../core/class */ 38377), a.DOMComponent = n( /*! ../../core/dom_component */ 13046), a.Component = n( /*! ../../core/component */ 44297).Component, a.registerComponent = n( /*! ../../core/component_registrator */ 99393), a.devices = n( /*! ../../core/devices */ 20530), a.Color = n( /*! ../../color */ 52752);
                    var r = n( /*! ../../animation/frame */ 90057);
                    a.utils = {}, a.utils.requestAnimationFrame = r.requestAnimationFrame, a.utils.cancelAnimationFrame = r.cancelAnimationFrame, a.utils.initMobileViewport = n( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 88185).p, a.utils.getTimeZones = n( /*! ../../time_zone_utils */ 88673).Z, a.utils.extendFromObject = n( /*! ../../core/utils/extend */ 13306).extendFromObject, a.utils.triggerShownEvent = n( /*! ../../events/visibility_change */ 80506).triggerShownEvent, a.utils.triggerHidingEvent = n( /*! ../../events/visibility_change */ 80506).triggerHidingEvent, a.utils.resetActiveElement = n( /*! ../../core/utils/dom */ 3532).resetActiveElement, a.utils.findBestMatches = n( /*! ../../core/utils/common */ 20576).findBestMatches, a.createQueue = n( /*! ../../core/utils/queue */ 59504).create, a.utils.dom = n( /*! ../../core/utils/dom */ 3532), a.utils.common = n( /*! ../../core/utils/common */ 20576), a.utils.date = n( /*! ../../core/utils/date */ 91198), a.utils.browser = n( /*! ../../core/utils/browser */ 47810), a.utils.inflector = n( /*! ../../core/utils/inflector */ 78008), a.utils.iterator = n( /*! ../../core/utils/iterator */ 95479), a.utils.readyCallbacks = n( /*! ../../core/utils/ready_callbacks */ 24311), a.utils.resizeCallbacks = n( /*! ../../core/utils/resize_callbacks */ 55814), a.utils.console = n( /*! ../../core/utils/console */ 30869), a.utils.string = n( /*! ../../core/utils/string */ 68752), a.utils.support = n( /*! ../../core/utils/support */ 60137), a.utils.ajax = n( /*! ../../core/utils/ajax */ 37208), a.viewPort = n( /*! ../../core/utils/view_port */ 77695).value, a.hideTopOverlay = n( /*! ../../mobile/hide_top_overlay */ 60628), a.formatHelper = n( /*! ../../format_helper */ 30343), a.config = n( /*! ../../core/config */ 80209), a.animationPresets = n( /*! ../../animation/presets/presets */ 42814).presets, a.fx = n( /*! ../../animation/fx */ 87209), a.TransitionExecutor = n( /*! ../../animation/transition_executor/transition_executor */ 52431).TransitionExecutor, a.AnimationPresetCollection = n( /*! ../../animation/presets/presets */ 42814).PresetCollection, a.events = n( /*! ../../events */ 66365), a.events.click = n( /*! ../../events/click */ 95429), a.events.utils = n( /*! ../../events/utils */ 39611), a.events.GestureEmitter = n( /*! ../../events/gesture/emitter.gesture */ 98621), a.localization = n( /*! ../../localization */ 94484), a.templateRendered = n( /*! ../../core/templates/template_base */ 81033).renderedCallbacks, a.setTemplateEngine = n( /*! ../../core/templates/template_engine_registry */ 72987).setTemplateEngine, e.exports = a
                },
            86635:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 36991),
                        a = n( /*! ../../core/errors */ 17381);
                    e.exports = i.data = i.data || {}, Object.defineProperty(i.data, "errorHandler", {
                        get: function() {
                            return n( /*! ../../data/errors */ 18438).errorHandler
                        },
                        set: function(e) {
                            a.log("W0003", "DevExpress.data", "errorHandler", "21.1", "Use the 'setErrorHandler' method instead"), n( /*! ../../data/errors */ 18438).setErrorHandler(e)
                        }
                    }), Object.defineProperty(i.data, "_errorHandler", {
                        get: function() {
                            return n( /*! ../../data/errors */ 18438).handleError
                        },
                        set: function(e) {
                            a.log("W0003", "DevExpress.data", "_errorHandler", "21.1", "Use the 'setErrorHandler' method instead"), n( /*! ../../data/errors */ 18438).setErrorHandler(e)
                        }
                    }), i.data.setErrorHandler = n( /*! ../../data/errors */ 18438).setErrorHandler, i.data.DataSource = n( /*! ../../data/data_source */ 33546), i.data.query = n( /*! ../../data/query */ 96687), i.data.Store = n( /*! ../../data/abstract_store */ 67403), i.data.ArrayStore = n( /*! ../../data/array_store */ 26562), i.data.CustomStore = n( /*! ../../data/custom_store */ 88036), i.data.LocalStore = n( /*! ../../data/local_store */ 82837), i.data.base64_encode = n( /*! ../../data/utils */ 16454).base64_encode, i.data.applyChanges = n( /*! ../../data/apply_changes */ 36893), i.data.Guid = n( /*! ../../core/guid */ 73176), i.data.utils = {}, i.data.utils.compileGetter = n( /*! ../../core/utils/data */ 47617).compileGetter, i.data.utils.compileSetter = n( /*! ../../core/utils/data */ 47617).compileSetter, i.EndpointSelector = n( /*! ../../data/endpoint_selector */ 8162), i.data.queryImpl = n( /*! ../../data/query_implementation */ 77549).queryImpl, i.data.queryAdapters = n( /*! ../../data/query_adapters */ 16135);
                    var o = n( /*! ../../data/utils */ 16454);
                    i.data.utils.normalizeBinaryCriterion = o.normalizeBinaryCriterion, i.data.utils.normalizeSortingInfo = o.normalizeSortingInfo, i.data.utils.errorMessageFromXhr = o.errorMessageFromXhr, i.data.utils.aggregators = o.aggregators, i.data.utils.keysEqual = o.keysEqual, i.data.utils.isDisjunctiveOperator = o.isDisjunctiveOperator, i.data.utils.isConjunctiveOperator = o.isConjunctiveOperator, i.data.utils.processRequestResultLock = o.processRequestResultLock, i.data.utils.toComparable = n( /*! ../../core/utils/data */ 47617).toComparable, i.data.utils.multiLevelGroup = n( /*! ../../data/store_helper */ 99236).multiLevelGroup, i.data.utils.arrangeSortingInfo = n( /*! ../../data/store_helper */ 99236).arrangeSortingInfo, i.data.utils.normalizeDataSourceOptions = n( /*! ../../data/data_source/utils */ 9234).normalizeDataSourceOptions
                },
            72343:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.odata.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    n( /*! ./data */ 86635), DevExpress.data.ODataStore = n( /*! ../../data/odata/store */ 341), DevExpress.data.ODataContext = n( /*! ../../data/odata/context */ 47256), DevExpress.data.utils = DevExpress.data.utils || {}, DevExpress.data.utils.odata = {}, DevExpress.data.utils.odata.keyConverters = n( /*! ../../data/odata/utils */ 77869).keyConverters, DevExpress.data.EdmLiteral = n( /*! ../../data/odata/utils */ 77869).EdmLiteral;
                    var i = n( /*! ../../data/odata/utils */ 77869);
                    DevExpress.data.utils.odata.serializePropName = i.serializePropName, DevExpress.data.utils.odata.serializeValue = i.serializeValue, DevExpress.data.utils.odata.serializeKey = i.serializeKey, DevExpress.data.utils.odata.sendRequest = i.sendRequest, DevExpress.data.queryAdapters = DevExpress.data.queryAdapters || {}, DevExpress.data.queryAdapters.odata = n( /*! ../../data/odata/query_adapter */ 54263).odata
                },
            85357:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/core.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../../../bundles/modules/core */ 36991);
                    n( /*! ../../../integration/jquery */ 78475), n( /*! ../../../integration/angular */ 71582), n( /*! ../../../integration/knockout */ 49281), n( /*! ../../../localization/globalize/core */ 74872), n( /*! ../../../localization/globalize/message */ 46949), n( /*! ../../../localization/globalize/number */ 908), n( /*! ../../../localization/globalize/date */ 60316), n( /*! ../../../localization/globalize/currency */ 7239), n( /*! ../../../events/click */ 95429), n( /*! ../../../events/contextmenu */ 49166), n( /*! ../../../events/double_click */ 85272), n( /*! ../../../events/drag */ 23174), n( /*! ../../../events/hold */ 11699), n( /*! ../../../events/hover */ 24028), n( /*! ../../../events/pointer */ 93786), n( /*! ../../../events/swipe */ 34309), n( /*! ../../../events/transform */ 91093), e.exports = i
                },
            94620:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/data.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 85357).data = n( /*! ../../../bundles/modules/data */ 86635);
                    i.odata = n( /*! ../../../bundles/modules/data.odata */ 72343), e.exports = i
                },
            66312:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/viz.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ./core */ 85357);
                    n( /*! ./data */ 94620);
                    var a = i.viz = n( /*! ../../../bundles/modules/viz */ 20802);
                    a.currentTheme = n( /*! ../../../viz/themes */ 86231).currentTheme, a.registerTheme = n( /*! ../../../viz/themes */ 86231).registerTheme, a.exportFromMarkup = n( /*! ../../../viz/export */ 5259).exportFromMarkup, a.getMarkup = n( /*! ../../../viz/export */ 5259).getMarkup, a.exportWidgets = n( /*! ../../../viz/export */ 5259).exportWidgets, a.currentPalette = n( /*! ../../../viz/palette */ 23696).currentPalette, a.getPalette = n( /*! ../../../viz/palette */ 23696).getPalette, a.generateColors = n( /*! ../../../viz/palette */ 23696).generateColors, a.registerPalette = n( /*! ../../../viz/palette */ 23696).registerPalette, a.refreshTheme = n( /*! ../../../viz/themes */ 86231).refreshTheme, a.dxChart = n( /*! ../../../viz/chart */ 99511), a.dxPieChart = n( /*! ../../../viz/pie_chart */ 72111), a.dxPolarChart = n( /*! ../../../viz/polar_chart */ 80919), a.dxLinearGauge = n( /*! ../../../viz/linear_gauge */ 99630), a.dxCircularGauge = n( /*! ../../../viz/circular_gauge */ 39847), a.dxBarGauge = n( /*! ../../../viz/bar_gauge */ 45888), a.dxRangeSelector = n( /*! ../../../viz/range_selector */ 82879), a.dxVectorMap = n( /*! ../../../viz/vector_map */ 81849), a.map = {}, a.map.sources = {}, a.map.projection = n( /*! ../../../viz/vector_map/projection */ 102).projection, a.dxSparkline = n( /*! ../../../viz/sparkline */ 43759), a.dxBullet = n( /*! ../../../viz/bullet */ 88950), a.dxTreeMap = n( /*! ../../../viz/tree_map */ 15584), a.dxFunnel = n( /*! ../../../viz/funnel */ 30187), a.dxSankey = n( /*! ../../../viz/sankey */ 34377), a.BaseWidget = n( /*! ../../../viz/core/base_widget */ 59063), a.getTheme = n( /*! ../../../viz/themes */ 86231).getTheme, a.findTheme = n( /*! ../../../viz/themes */ 86231).getTheme, a.refreshAll = n( /*! ../../../viz/themes */ 86231).refreshTheme, a.refreshPaths = n( /*! ../../../viz/utils */ 34434).refreshPaths, a.gauges = {
                        __internals: {}
                    }, a._dashboard = {}, a._dashboard.Renderer = n( /*! ../../../viz/core/renderers/renderer */ 56453).Renderer, a._dashboard.SvgElement = n( /*! ../../../viz/core/renderers/renderer */ 56453).SvgElement, a._dashboard.patchFontOptions = n( /*! ../../../viz/core/utils */ 19157).patchFontOptions, e.exports = a
                },
            20802:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/bundles/modules/viz.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    n( /*! ./core */ 36991), e.exports = DevExpress.viz = DevExpress.viz || {}
                },
            52752:
                /*!******************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/color.js ***!
                  \******************************************************/
                function(e, t) {
                    t.default = void 0;
                    var n = {
                            aliceblue: "f0f8ff",
                            antiquewhite: "faebd7",
                            aqua: "00ffff",
                            aquamarine: "7fffd4",
                            azure: "f0ffff",
                            beige: "f5f5dc",
                            bisque: "ffe4c4",
                            black: "000000",
                            blanchedalmond: "ffebcd",
                            blue: "0000ff",
                            blueviolet: "8a2be2",
                            brown: "a52a2a",
                            burlywood: "deb887",
                            cadetblue: "5f9ea0",
                            chartreuse: "7fff00",
                            chocolate: "d2691e",
                            coral: "ff7f50",
                            cornflowerblue: "6495ed",
                            cornsilk: "fff8dc",
                            crimson: "dc143c",
                            cyan: "00ffff",
                            darkblue: "00008b",
                            darkcyan: "008b8b",
                            darkgoldenrod: "b8860b",
                            darkgray: "a9a9a9",
                            darkgreen: "006400",
                            darkkhaki: "bdb76b",
                            darkmagenta: "8b008b",
                            darkolivegreen: "556b2f",
                            darkorange: "ff8c00",
                            darkorchid: "9932cc",
                            darkred: "8b0000",
                            darksalmon: "e9967a",
                            darkseagreen: "8fbc8f",
                            darkslateblue: "483d8b",
                            darkslategray: "2f4f4f",
                            darkturquoise: "00ced1",
                            darkviolet: "9400d3",
                            deeppink: "ff1493",
                            deepskyblue: "00bfff",
                            dimgray: "696969",
                            dodgerblue: "1e90ff",
                            feldspar: "d19275",
                            firebrick: "b22222",
                            floralwhite: "fffaf0",
                            forestgreen: "228b22",
                            fuchsia: "ff00ff",
                            gainsboro: "dcdcdc",
                            ghostwhite: "f8f8ff",
                            gold: "ffd700",
                            goldenrod: "daa520",
                            gray: "808080",
                            green: "008000",
                            greenyellow: "adff2f",
                            honeydew: "f0fff0",
                            hotpink: "ff69b4",
                            indianred: "cd5c5c",
                            indigo: "4b0082",
                            ivory: "fffff0",
                            khaki: "f0e68c",
                            lavender: "e6e6fa",
                            lavenderblush: "fff0f5",
                            lawngreen: "7cfc00",
                            lemonchiffon: "fffacd",
                            lightblue: "add8e6",
                            lightcoral: "f08080",
                            lightcyan: "e0ffff",
                            lightgoldenrodyellow: "fafad2",
                            lightgrey: "d3d3d3",
                            lightgreen: "90ee90",
                            lightpink: "ffb6c1",
                            lightsalmon: "ffa07a",
                            lightseagreen: "20b2aa",
                            lightskyblue: "87cefa",
                            lightslateblue: "8470ff",
                            lightslategray: "778899",
                            lightsteelblue: "b0c4de",
                            lightyellow: "ffffe0",
                            lime: "00ff00",
                            limegreen: "32cd32",
                            linen: "faf0e6",
                            magenta: "ff00ff",
                            maroon: "800000",
                            mediumaquamarine: "66cdaa",
                            mediumblue: "0000cd",
                            mediumorchid: "ba55d3",
                            mediumpurple: "9370d8",
                            mediumseagreen: "3cb371",
                            mediumslateblue: "7b68ee",
                            mediumspringgreen: "00fa9a",
                            mediumturquoise: "48d1cc",
                            mediumvioletred: "c71585",
                            midnightblue: "191970",
                            mintcream: "f5fffa",
                            mistyrose: "ffe4e1",
                            moccasin: "ffe4b5",
                            navajowhite: "ffdead",
                            navy: "000080",
                            oldlace: "fdf5e6",
                            olive: "808000",
                            olivedrab: "6b8e23",
                            orange: "ffa500",
                            orangered: "ff4500",
                            orchid: "da70d6",
                            palegoldenrod: "eee8aa",
                            palegreen: "98fb98",
                            paleturquoise: "afeeee",
                            palevioletred: "d87093",
                            papayawhip: "ffefd5",
                            peachpuff: "ffdab9",
                            peru: "cd853f",
                            pink: "ffc0cb",
                            plum: "dda0dd",
                            powderblue: "b0e0e6",
                            purple: "800080",
                            rebeccapurple: "663399",
                            red: "ff0000",
                            rosybrown: "bc8f8f",
                            royalblue: "4169e1",
                            saddlebrown: "8b4513",
                            salmon: "fa8072",
                            sandybrown: "f4a460",
                            seagreen: "2e8b57",
                            seashell: "fff5ee",
                            sienna: "a0522d",
                            silver: "c0c0c0",
                            skyblue: "87ceeb",
                            slateblue: "6a5acd",
                            slategray: "708090",
                            snow: "fffafa",
                            springgreen: "00ff7f",
                            steelblue: "4682b4",
                            tan: "d2b48c",
                            teal: "008080",
                            thistle: "d8bfd8",
                            tomato: "ff6347",
                            turquoise: "40e0d0",
                            violet: "ee82ee",
                            violetred: "d02090",
                            wheat: "f5deb3",
                            white: "ffffff",
                            whitesmoke: "f5f5f5",
                            yellow: "ffff00",
                            yellowgreen: "9acd32"
                        },
                        i = [{
                            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                return [parseInt(e[1], 10), parseInt(e[2], 10), parseInt(e[3], 10)]
                            }
                        }, {
                            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
                            process: function(e) {
                                return [parseInt(e[1], 10), parseInt(e[2], 10), parseInt(e[3], 10), parseFloat(e[4])]
                            }
                        }, {
                            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
                            process: function(e) {
                                return [parseInt(e[1], 16), parseInt(e[2], 16), parseInt(e[3], 16)]
                            }
                        }, {
                            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
                            process: function(e) {
                                return [parseInt(e[1] + e[1], 16), parseInt(e[2] + e[2], 16), parseInt(e[3] + e[3], 16)]
                            }
                        }, {
                            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                var t = parseInt(e[1], 10),
                                    n = parseInt(e[2], 10),
                                    i = parseInt(e[3], 10),
                                    a = s(t, n, i);
                                return [a[0], a[1], a[2], 1, [t, n, i]]
                            }
                        }, {
                            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                            process: function(e) {
                                var t = parseInt(e[1], 10),
                                    n = parseInt(e[2], 10),
                                    i = parseInt(e[3], 10),
                                    a = u(t, n, i);
                                return [a[0], a[1], a[2], 1, null, [t, n, i]]
                            }
                        }],
                        a = Math.round;

                    function o(e) {
                        var t;
                        this.baseColor = e, e && (t = String(e).toLowerCase().replace(/ /g, ""), t = function(e) {
                            if ("transparent" === e) {
                                return [0, 0, 0, 0]
                            }
                            for (var t, n = 0, a = i.length; n < a; ++n) {
                                if (t = i[n].re.exec(e)) {
                                    return i[n].process(t)
                                }
                            }
                            return null
                        }(t = n[t] ? "#" + n[t] : t)), t || (this.colorIsInvalid = !0), t = t || {}, this.r = r(t[0]), this.g = r(t[1]), this.b = r(t[2]), this.a = r(t[3], 1, 1), t[4] ? this.hsv = {
                            h: t[4][0],
                            s: t[4][1],
                            v: t[4][2]
                        } : this.hsv = function(e, t, n) {
                            var i, a, o = Math.max(e, t, n),
                                r = Math.min(e, t, n),
                                s = o - r,
                                c = o;
                            if (a = 0 === o ? 0 : 1 - r / o, o === r) {
                                i = 0
                            } else {
                                switch (o) {
                                    case e:
                                        i = (t - n) / s * 60, t < n && (i += 360);
                                        break;
                                    case t:
                                        i = (n - e) / s * 60 + 120;
                                        break;
                                    case n:
                                        i = (e - t) / s * 60 + 240
                                }
                            }
                            return a *= 100, c *= 100 / 255, {
                                h: Math.round(i),
                                s: Math.round(a),
                                v: Math.round(c)
                            }
                        }(this.r, this.g, this.b), t[5] ? this.hsl = {
                            h: t[5][0],
                            s: t[5][1],
                            l: t[5][2]
                        } : this.hsl = function(e, t, n) {
                            e = d(e, 255), t = d(t, 255), n = d(n, 255);
                            var i, o, r = Math.max(e, t, n),
                                s = Math.min(e, t, n),
                                c = r + s,
                                l = c / 2;
                            if (r === s) {
                                i = o = 0
                            } else {
                                var u = r - s;
                                o = l > .5 ? u / (2 - c) : u / c, i = function(e, t, n, i) {
                                    switch (Math.max(e, t, n)) {
                                        case e:
                                            return (t - n) / i + (t < n ? 6 : 0);
                                        case t:
                                            return (n - e) / i + 2;
                                        case n:
                                            return (e - t) / i + 4
                                    }
                                }(e, t, n, u), i /= 6
                            }
                            return {
                                h: a(360 * i),
                                s: a(100 * o),
                                l: a(100 * l)
                            }
                        }(this.r, this.g, this.b)
                    }

                    function r(e, t, n) {
                        return t = t || 0, n = n || 255, e < 0 || isNaN(e) ? t : e > n ? n : e
                    }

                    function s(e, t, n) {
                        var i, a, o, r = (100 - t) * n / 100,
                            s = e % 60 / 60 * (n - r),
                            c = r + s,
                            l = n - s;
                        switch (Math.floor(e % 360 / 60)) {
                            case 0:
                                i = n, a = c, o = r;
                                break;
                            case 1:
                                i = l, a = n, o = r;
                                break;
                            case 2:
                                i = r, a = n, o = c;
                                break;
                            case 3:
                                i = r, a = l, o = n;
                                break;
                            case 4:
                                i = c, a = r, o = n;
                                break;
                            case 5:
                                i = n, a = r, o = l
                        }
                        return [Math.round(2.55 * i), Math.round(2.55 * a), Math.round(2.55 * o)]
                    }

                    function c(e, t) {
                        var n = t;
                        return "r" === e && (n = t + 1 / 3), "b" === e && (n = t - 1 / 3), n
                    }

                    function l(e, t, n) {
                        return (n = function(e) {
                            return e < 0 && (e += 1), e > 1 && (e -= 1), e
                        }(n)) < 1 / 6 ? e + 6 * (t - e) * n : n < .5 ? t : n < 2 / 3 ? e + (t - e) * (2 / 3 - n) * 6 : e
                    }

                    function u(e, t, n) {
                        var i, o, r;
                        if (e = d(e, 360), t = d(t, 100), n = d(n, 100), 0 === t) {
                            i = o = r = n
                        } else {
                            var s = n < .5 ? n * (1 + t) : n + t - n * t,
                                u = 2 * n - s;
                            i = l(u, s, c("r", e)), o = l(u, s, c("g", e)), r = l(u, s, c("b", e))
                        }
                        return [a(255 * i), a(255 * o), a(255 * r)]
                    }

                    function d(e, t) {
                        return e = Math.min(t, Math.max(0, parseFloat(e))), Math.abs(e - t) < 1e-6 ? 1 : e % t / parseFloat(t)
                    }

                    function f(e, t, n) {
                        return t = t || 0, n = n || 255, !(e % 1 != 0 || e < t || e > n || "number" != typeof e || isNaN(e))
                    }
                    o.prototype = {
                        constructor: o,
                        highlight: function(e) {
                            return e = e || 10, this.alter(e).toHex()
                        },
                        darken: function(e) {
                            return e = e || 10, this.alter(-e).toHex()
                        },
                        alter: function(e) {
                            var t = new o;
                            return t.r = r(this.r + e), t.g = r(this.g + e), t.b = r(this.b + e), t
                        },
                        blend: function(e, t) {
                            var n = e instanceof o ? e : new o(e),
                                i = new o;
                            return i.r = r(a(this.r * (1 - t) + n.r * t)), i.g = r(a(this.g * (1 - t) + n.g * t)), i.b = r(a(this.b * (1 - t) + n.b * t)), i
                        },
                        toHex: function() {
                            return e = this.r, t = this.g, n = this.b, "#" + (16777216 | e << 16 | t << 8 | n).toString(16).slice(1);
                            var e, t, n
                        },
                        getPureColor: function() {
                            return new o("rgb(" + s(this.hsv.h, 100, 100).join(",") + ")")
                        },
                        isValidHex: function(e) {
                            return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)
                        },
                        isValidRGB: function(e, t, n) {
                            return !!(f(e) && f(t) && f(n))
                        },
                        isValidAlpha: function(e) {
                            return !(isNaN(e) || e < 0 || e > 1 || "number" != typeof e)
                        },
                        colorIsInvalid: !1,
                        fromHSL: function(e) {
                            var t = new o,
                                n = u(e.h, e.s, e.l);
                            return t.r = n[0], t.g = n[1], t.b = n[2], t
                        }
                    };
                    var h = o;
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            62414:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/action.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ./renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./utils/window */ 58201),
                        r = n( /*! ./utils/type */ 35922),
                        s = n( /*! ./utils/iterator */ 95479);
                    var c = function() {
                        function e(e, t) {
                            t = t || {}, this._action = e, this._context = t.context || (0, o.getWindow)(), this._beforeExecute = t.beforeExecute, this._afterExecute = t.afterExecute, this._component = t.component, this._validatingTargetName = t.validatingTargetName;
                            var n = this._excludeValidators = {};
                            if (t.excludeValidators) {
                                for (var i = 0; i < t.excludeValidators.length; i++) {
                                    n[t.excludeValidators[i]] = !0
                                }
                            }
                        }
                        var t = e.prototype;
                        return t.execute = function() {
                            var e = {
                                    action: this._action,
                                    args: Array.prototype.slice.call(arguments),
                                    context: this._context,
                                    component: this._component,
                                    validatingTargetName: this._validatingTargetName,
                                    cancel: !1,
                                    handled: !1
                                },
                                t = this._beforeExecute,
                                n = this._afterExecute,
                                i = e.args[0] || {};
                            if (this._validateAction(e) && (null == t || t.call(this._context, e), !e.cancel)) {
                                var a = this._executeAction(e);
                                if (!i.cancel) {
                                    return null == n || n.call(this._context, e), a
                                }
                            }
                        }, t._validateAction = function(t) {
                            var n = this._excludeValidators,
                                i = e.executors;
                            for (var a in i) {
                                if (!n[a]) {
                                    var o, r = i[a];
                                    if (null === (o = r.validate) || void 0 === o || o.call(r, t), t.cancel) {
                                        return !1
                                    }
                                }
                            }
                            return !0
                        }, t._executeAction = function(t) {
                            var n, i = e.executors;
                            for (var a in i) {
                                var o, r = i[a];
                                if (null === (o = r.execute) || void 0 === o || o.call(r, t), t.handled) {
                                    n = t.result;
                                    break
                                }
                            }
                            return n
                        }, e.registerExecutor = function(t, n) {
                            (0, r.isPlainObject)(t) ? (0, s.each)(t, e.registerExecutor) : e.executors[t] = n
                        }, e.unregisterExecutor = function() {
                            for (var t = arguments.length, n = new Array(t), i = 0; i < t; i++) {
                                n[i] = arguments[i]
                            }(0, s.each)(n, (function() {
                                delete e.executors[this]
                            }))
                        }, e
                    }();
                    t.default = c, c.executors = {};
                    var l = function(e) {
                        return function(t) {
                            if (t.args.length) {
                                var n = t.args[0],
                                    i = n[t.validatingTargetName] || n.element;
                                i && e((0, a.default)(i)) && (t.cancel = !0)
                            }
                        }
                    };
                    c.registerExecutor({
                        disabled: {
                            validate: l((function(e) {
                                return e.is(".dx-state-disabled, .dx-state-disabled *")
                            }))
                        },
                        readOnly: {
                            validate: l((function(e) {
                                return e.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                            }))
                        },
                        undefined: {
                            execute: function(e) {
                                e.action || (e.result = void 0, e.handled = !0)
                            }
                        },
                        func: {
                            execute: function(e) {
                                (0, r.isFunction)(e.action) && (e.result = e.action.call(e.context, e.args[0]), e.handled = !0)
                            }
                        }
                    }), e.exports = t.default, e.exports.default = t.default
                },
            38377:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/class.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ./errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./utils/type */ 35922);
                    var r, s = function(e, t, n) {
                            return function() {
                                var i = this.callBase;
                                this.callBase = e[t];
                                try {
                                    return n.apply(this, arguments)
                                } finally {
                                    this.callBase = i
                                }
                            }
                        },
                        c = function(e) {
                            var t, n, i, a = this;
                            if (!e) {
                                return a
                            }
                            for (n in e) {
                                i = e[n], t = "function" == typeof a.prototype[n] && "function" == typeof i, a.prototype[n] = t ? s(a.parent.prototype, n, i) : i
                            }
                            return a
                        },
                        l = function() {
                            var e, t, n, i = this,
                                a = Object.prototype.hasOwnProperty.bind(i),
                                o = !a("_includedCtors") && !a("_includedPostCtors");
                            for (o && (i._includedCtors = i._includedCtors.slice(0), i._includedPostCtors = i._includedPostCtors.slice(0)), n = 0; n < arguments.length; n++) {
                                for (t in (e = arguments[n]).ctor && i._includedCtors.push(e.ctor), e.postCtor && i._includedPostCtors.push(e.postCtor), e) {
                                    "ctor" !== t && "postCtor" !== t && "default" !== t && (i.prototype[t] = e[t])
                                }
                            }
                            return i
                        },
                        u = function(e) {
                            if (!Object.prototype.hasOwnProperty.bind(this)("parent") && this.parent) {
                                var t = Object.getPrototypeOf(this);
                                return t === e || t.subclassOf(e)
                            }
                            return this.parent === e || !(!this.parent || !this.parent.subclassOf) && this.parent.subclassOf(e)
                        },
                        d = function() {
                            throw a.default.Error("E0001")
                        },
                        f = (r = Object.prototype.hasOwnProperty, function(e, t) {
                            for (var n in e) {
                                if (!r.call(e, n)) {
                                    return
                                }
                                t[n] = e[n]
                            }
                        }),
                        h = function() {};
                    h.inherit = function(e) {
                        var t = function() {
                            if (!this || (0, o.isWindow)(this) || "function" != typeof this.constructor) {
                                throw a.default.Error("E0003")
                            }
                            var e, t = this,
                                n = t.ctor,
                                i = t.constructor._includedCtors,
                                r = t.constructor._includedPostCtors;
                            for (e = 0; e < i.length; e++) {
                                i[e].call(t)
                            }
                            for (n && n.apply(t, arguments), e = 0; e < r.length; e++) {
                                r[e].call(t)
                            }
                        };
                        return t.prototype = function(e) {
                            var t = function() {};
                            return t.prototype = e.prototype, new t
                        }(this), f(this, t), t.inherit = this.inherit, t.abstract = d, t.redefine = c, t.include = l, t.subclassOf = u, t.parent = this, t._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [], t._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [], t.prototype.constructor = t, t.redefine(e), t
                    }, h.abstract = d;
                    var g = h;
                    t.default = g, e.exports = t.default, e.exports.default = t.default
                },
            44297:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.Component = void 0;
                    var i = _(n( /*! ./config */ 80209)),
                        a = n( /*! ./utils/extend */ 13306),
                        o = n( /*! ./options/index */ 95683),
                        r = n( /*! ./options/utils */ 45434),
                        s = _(n( /*! ./class */ 38377)),
                        c = _(n( /*! ./action */ 62414)),
                        l = _(n( /*! ./errors */ 17381)),
                        u = _(n( /*! ./utils/callbacks */ 44504)),
                        d = n( /*! ./events_strategy */ 80566),
                        f = n( /*! ./utils/public_component */ 9321),
                        h = n( /*! ./postponed_operations */ 90889),
                        g = n( /*! ./utils/type */ 35922),
                        p = n( /*! ./utils/common */ 20576),
                        m = n( /*! ./utils/data */ 47617);

                    function _(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var v = function(e) {
                            return e.charAt(2).toLowerCase() + e.substr(3)
                        },
                        x = s.default.inherit({
                            _setDeprecatedOptions: function() {
                                this._deprecatedOptions = {}
                            },
                            _getDeprecatedOptions: function() {
                                return this._deprecatedOptions
                            },
                            _getDefaultOptions: function() {
                                return {
                                    onInitialized: null,
                                    onOptionChanged: null,
                                    onDisposing: null,
                                    defaultOptionsRules: null
                                }
                            },
                            _defaultOptionsRules: function() {
                                return []
                            },
                            _setOptionsByDevice: function(e) {
                                this._options.applyRules(e)
                            },
                            _convertRulesToOptions: function(e) {
                                return (0, r.convertRulesToOptions)(e)
                            },
                            _isInitialOptionValue: function(e) {
                                return this._options.isInitial(e)
                            },
                            _setOptionsByReference: function() {
                                this._optionsByReference = {}
                            },
                            _getOptionsByReference: function() {
                                return this._optionsByReference
                            },
                            ctor: function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                                    t = e._optionChangedCallbacks,
                                    n = e._disposingCallbacks;
                                this.NAME = (0, f.name)(this.constructor), this._eventsStrategy = d.EventsStrategy.create(this, e.eventsStrategy), this._updateLockCount = 0, this._optionChangedCallbacks = t || (0, u.default)(), this._disposingCallbacks = n || (0, u.default)(), this.postponedOperations = new h.PostponedOperations, this._createOptions(e)
                            },
                            _createOptions: function(e) {
                                var t = this;
                                this.beginUpdate();
                                try {
                                    this._setOptionsByReference(), this._setDeprecatedOptions(), this._options = new o.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions()), this._options.onChanging((function(e, n, i) {
                                        return t._initialized && t._optionChanging(e, n, i)
                                    })), this._options.onDeprecated((function(e, n) {
                                        return t._logDeprecatedOptionWarning(e, n)
                                    })), this._options.onChanged((function(e, n, i) {
                                        return t._notifyOptionChanged(e, n, i)
                                    })), this._options.onStartChange((function() {
                                        return t.beginUpdate()
                                    })), this._options.onEndChange((function() {
                                        return t.endUpdate()
                                    })), this._options.addRules(this._defaultOptionsRules()), e && e.onInitializing && e.onInitializing.apply(this, [e]), this._setOptionsByDevice(e.defaultOptionsRules), this._initOptions(e)
                                } finally {
                                    this.endUpdate()
                                }
                            },
                            _initOptions: function(e) {
                                this.option(e)
                            },
                            _init: function() {
                                var e = this;
                                this._createOptionChangedAction(), this.on("disposing", (function(t) {
                                    e._disposingCallbacks.fireWith(e, [t])
                                }))
                            },
                            _logDeprecatedOptionWarning: function(e, t) {
                                var n = t.message || "Use the '".concat(t.alias, "' option instead");
                                l.default.log("W0001", this.NAME, e, t.since, n)
                            },
                            _logDeprecatedComponentWarning: function(e, t) {
                                l.default.log("W0000", this.NAME, e, "Use the '".concat(t, "' widget instead"))
                            },
                            _createOptionChangedAction: function() {
                                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                                    excludeValidators: ["disabled", "readOnly"]
                                })
                            },
                            _createDisposingAction: function() {
                                this._disposingAction = this._createActionByOption("onDisposing", {
                                    excludeValidators: ["disabled", "readOnly"]
                                })
                            },
                            _optionChanged: function(e) {
                                switch (e.name) {
                                    case "onDisposing":
                                    case "onInitialized":
                                    case "defaultOptionsRules":
                                        break;
                                    case "onOptionChanged":
                                        this._createOptionChangedAction()
                                }
                            },
                            _dispose: function() {
                                this._optionChangedCallbacks.empty(), this._createDisposingAction(), this._disposingAction(), this._eventsStrategy.dispose(), this._options.dispose(), this._disposed = !0
                            },
                            _lockUpdate: function() {
                                this._updateLockCount++
                            },
                            _unlockUpdate: function() {
                                this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
                            },
                            _isUpdateAllowed: function() {
                                return 0 === this._updateLockCount
                            },
                            _isInitializingRequired: function() {
                                return !this._initializing && !this._initialized
                            },
                            _commitUpdate: function() {
                                this.postponedOperations.callPostponedOperations(), this._isInitializingRequired() && this._initializeComponent()
                            },
                            _initializeComponent: function() {
                                this._initializing = !0;
                                try {
                                    this._init()
                                } finally {
                                    this._initializing = !1, this._lockUpdate(), this._createActionByOption("onInitialized", {
                                        excludeValidators: ["disabled", "readOnly"]
                                    })(), this._unlockUpdate(), this._initialized = !0
                                }
                            },
                            instance: function() {
                                return this
                            },
                            beginUpdate: function() {
                                this._lockUpdate()
                            },
                            endUpdate: function() {
                                this._unlockUpdate(), this._isUpdateAllowed() && this._commitUpdate()
                            },
                            _optionChanging: p.noop,
                            _notifyOptionChanged: function(e, t, n) {
                                if (this._initialized) {
                                    for (var i = [e].concat(this._options.getAliasesByName(e)), o = 0; o < i.length; o++) {
                                        var r = i[o],
                                            s = {
                                                name: (0, m.getPathParts)(r)[0],
                                                fullName: r,
                                                value: t,
                                                previousValue: n
                                            };
                                        0 !== r.indexOf("_", 0) && (this._optionChangedCallbacks.fireWith(this, [(0, a.extend)(this._defaultActionArgs(), s)]), this._optionChangedAction((0, a.extend)({}, s))), this._disposed || this._cancelOptionChange === r || this._optionChanged(s)
                                    }
                                }
                            },
                            initialOption: function(e) {
                                return this._options.initial(e)
                            },
                            _defaultActionConfig: function() {
                                return {
                                    context: this,
                                    component: this
                                }
                            },
                            _defaultActionArgs: function() {
                                return {
                                    component: this
                                }
                            },
                            _createAction: function(e, t) {
                                var n, i = this;
                                return function(o) {
                                    return (0, g.isDefined)(o) || (o = {}), (0, g.isPlainObject)(o) || (o = {
                                        actionValue: o
                                    }), (n = n || new c.default(e, (0, a.extend)(t, i._defaultActionConfig()))).execute.call(n, (0, a.extend)(o, i._defaultActionArgs()))
                                }
                            },
                            _createActionByOption: function(e, t) {
                                var n, a, o, r = this,
                                    s = function() {
                                        if (!a) {
                                            if (t = t || {}, "string" != typeof e) {
                                                throw l.default.Error("E0008")
                                            }
                                            0 === e.indexOf("on") && (a = v(e)), o = r.option()[e]
                                        }
                                        if (n || o || t.beforeExecute || t.afterExecute || r._eventsStrategy.hasEvent(a)) {
                                            if (!n) {
                                                var s = t.beforeExecute;
                                                t.beforeExecute = function() {
                                                    for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                                        t[n] = arguments[n]
                                                    }
                                                    s && s.apply(r, t), r._eventsStrategy.fireEvent(a, t[0].args)
                                                }, n = r._createAction(o, t)
                                            }
                                            for (var c = arguments.length, u = new Array(c), d = 0; d < c; d++) {
                                                u[d] = arguments[d]
                                            }
                                            if ((0, i.default)().wrapActionsBeforeExecute) {
                                                var f = r.option("beforeActionExecute") || p.noop,
                                                    h = f(r, n, t) || n;
                                                return h.apply(r, u)
                                            }
                                            return n.apply(r, u)
                                        }
                                    };
                                return (0, i.default)().wrapActionsBeforeExecute ? s : (this.option("onActionCreated") || p.noop)(this, s, t) || s
                            },
                            on: function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            },
                            off: function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            },
                            hasActionSubscription: function(e) {
                                return !!this._options.silent(e) || this._eventsStrategy.hasEvent(v(e))
                            },
                            isOptionDeprecated: function(e) {
                                return this._options.isDeprecated(e)
                            },
                            _setOptionWithoutOptionChange: function(e, t) {
                                this._cancelOptionChange = e, this.option(e, t), this._cancelOptionChange = !1
                            },
                            _getOptionValue: function(e, t) {
                                var n = this.option(e);
                                return (0, g.isFunction)(n) ? n.bind(t)() : n
                            },
                            option: function() {
                                var e;
                                return (e = this._options).option.apply(e, arguments)
                            },
                            resetOption: function(e) {
                                this.beginUpdate(), this._options.reset(e), this.endUpdate()
                            }
                        });
                    t.Component = x
                },
            99393:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component_registrator.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ./renderer */ 68374)),
                        a = s(n( /*! ./component_registrator_callbacks */ 5554)),
                        o = s(n( /*! ./errors */ 17381)),
                        r = n( /*! ./utils/public_component */ 9321);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    a.default.add((function(e, t) {
                        i.default.fn[e] = function(n) {
                            var i, a = "string" == typeof n;
                            if (a) {
                                var r = n,
                                    s = [].slice.call(arguments).slice(1);
                                this.each((function() {
                                    var n = t.getInstance(this);
                                    if (!n) {
                                        throw o.default.Error("E0009", e)
                                    }
                                    var a = n[r].apply(n, s);
                                    void 0 === i && (i = a)
                                }))
                            } else {
                                this.each((function() {
                                    var e = t.getInstance(this);
                                    e ? e.option(n) : new t(this, n)
                                })), i = this
                            }
                            return i
                        }
                    }));
                    t.default = function(e, t, n) {
                        n ? t[e] = n : n = t, (0, r.name)(n, e), a.default.fire(e, n)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            5554:
                /*!*************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/component_registrator_callbacks.js ***!
                  \*************************************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var a = new(((i = n( /*! ./memorized_callbacks */ 83358)) && i.__esModule ? i : {
                        default: i
                    }).default);
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            80209:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/config.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ./utils/extend */ 13306),
                        o = (i = n( /*! ./errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            rtlEnabled: !1,
                            defaultCurrency: "USD",
                            oDataFilterToLower: !0,
                            serverDecimalSeparator: ".",
                            decimalSeparator: ".",
                            thousandsSeparator: ",",
                            forceIsoDateParsing: !0,
                            wrapActionsBeforeExecute: !0,
                            useLegacyStoreResult: !1,
                            useJQuery: void 0,
                            editorStylingMode: void 0,
                            useLegacyVisibleIndex: !1,
                            floatingActionButtonConfig: {
                                icon: "add",
                                closeIcon: "close",
                                label: "",
                                position: {
                                    at: "right bottom",
                                    my: "right bottom",
                                    offset: {
                                        x: -16,
                                        y: -16
                                    }
                                },
                                maxSpeedDialActionCount: 5,
                                shading: !1,
                                direction: "auto"
                            },
                            optionsParser: function(e) {
                                "{" !== e.trim().charAt(0) && (e = "{" + e + "}");
                                try {
                                    return new Function("return " + e)()
                                } catch (t) {
                                    throw o.default.Error("E3018", t, e)
                                }
                            }
                        },
                        s = ["decimalSeparator", "thousandsSeparator"],
                        c = function() {
                            if (!arguments.length) {
                                return r
                            }
                            var e = arguments.length <= 0 ? void 0 : arguments[0];
                            s.forEach((function(t) {
                                if (e[t]) {
                                    var n = "Now, the ".concat(t, " is selected based on the specified locale.");
                                    o.default.log("W0003", "config", t, "19.2", n)
                                }
                            })), (0, a.extend)(r, e)
                        };
                    "undefined" != typeof DevExpress && DevExpress.config && c(DevExpress.config);
                    var l = c;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            20530:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/devices.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/size */ 58664),
                        a = _(n( /*! ../core/renderer */ 68374)),
                        o = n( /*! ./utils/window */ 58201),
                        r = n( /*! ./utils/extend */ 13306),
                        s = n( /*! ./utils/type */ 35922),
                        c = n( /*! ./utils/iterator */ 95479),
                        l = _(n( /*! ./errors */ 17381)),
                        u = _(n( /*! ./utils/callbacks */ 44504)),
                        d = _(n( /*! ./utils/ready_callbacks */ 24311)),
                        f = _(n( /*! ./utils/resize_callbacks */ 55814)),
                        h = n( /*! ./events_strategy */ 80566),
                        g = n( /*! ./utils/storage */ 36613),
                        p = n( /*! ./utils/view_port */ 77695),
                        m = _(n( /*! ./config */ 80209));

                    function _(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var v = (0, o.getNavigator)(),
                        x = (0, o.getWindow)(),
                        y = {
                            iPhone: "iPhone",
                            iPhone5: "iPhone",
                            iPhone6: "iPhone",
                            iPhone6plus: "iPhone",
                            iPad: "iPad",
                            iPadMini: "iPad Mini",
                            androidPhone: "Android Mobile",
                            androidTablet: "Android",
                            msSurface: "Windows ARM Tablet PC",
                            desktop: "desktop"
                        },
                        b = {
                            deviceType: "desktop",
                            platform: "generic",
                            version: [],
                            phone: !1,
                            tablet: !1,
                            android: !1,
                            ios: !1,
                            generic: !0,
                            grade: "A",
                            mac: !1
                        },
                        w = {
                            generic: function(e) {
                                var t = /windows phone/i.test(e) || e.match(/WPDesktop/),
                                    n = !t && /Windows(.*)arm(.*)Tablet PC/i.test(e),
                                    i = !t && !n && /msapphost/i.test(e),
                                    a = /((intel|ppc) mac os x)/.test(e.toLowerCase());
                                if (t || n || i || a) {
                                    return {
                                        deviceType: t ? "phone" : n ? "tablet" : "desktop",
                                        platform: "generic",
                                        version: [],
                                        grade: "A",
                                        mac: a
                                    }
                                }
                            },
                            ios: function(e) {
                                if (/ip(hone|od|ad)/i.test(e)) {
                                    var t = /ip(hone|od)/i.test(e),
                                        n = e.match(/os (\d+)_(\d+)_?(\d+)?/i);
                                    return {
                                        deviceType: t ? "phone" : "tablet",
                                        platform: "ios",
                                        version: n ? [parseInt(n[1], 10), parseInt(n[2], 10), parseInt(n[3] || 0, 10)] : [],
                                        grade: 480 === x.screen.height ? "B" : "A"
                                    }
                                }
                            },
                            android: function(e) {
                                if (/android|htc_|silk/i.test(e)) {
                                    var t = /mobile/i.test(e),
                                        n = e.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),
                                        i = n ? [parseInt(n[1], 10), parseInt(n[2] || 0, 10), parseInt(n[3] || 0, 10)] : [];
                                    return {
                                        deviceType: t ? "phone" : "tablet",
                                        platform: "android",
                                        version: i,
                                        grade: i.length > 1 && (i[0] < 4 || 4 === i[0] && i[1] < 4) ? "B" : "A"
                                    }
                                }
                            }
                        },
                        k = new(function() {
                            function e(e) {
                                this._window = (null == e ? void 0 : e.window) || x, this._realDevice = this._getDevice(), this._currentDevice = void 0, this._currentOrientation = void 0, this._eventsStrategy = new h.EventsStrategy(this), this.changed = (0, u.default)(), (0, o.hasWindow)() && (d.default.add(this._recalculateOrientation.bind(this)), f.default.add(this._recalculateOrientation.bind(this)))
                            }
                            var t = e.prototype;
                            return t.current = function(e) {
                                if (e) {
                                    return this._currentDevice = this._getDevice(e), this._forced = !0, void this.changed.fire()
                                }
                                if (!this._currentDevice) {
                                    e = void 0;
                                    try {
                                        e = this._getDeviceOrNameFromWindowScope()
                                    } catch (t) {
                                        e = this._getDeviceNameFromSessionStorage()
                                    } finally {
                                        e || (e = this._getDeviceNameFromSessionStorage()), e && (this._forced = !0)
                                    }
                                    this._currentDevice = this._getDevice(e)
                                }
                                return this._currentDevice
                            }, t.real = function(e) {
                                return (0, r.extend)({}, this._realDevice)
                            }, t.orientation = function() {
                                return this._currentOrientation
                            }, t.isForced = function() {
                                return this._forced
                            }, t.isRippleEmulator = function() {
                                return !!this._window.tinyHippos
                            }, t._getCssClasses = function(e) {
                                var t = [],
                                    n = this._realDevice;
                                return (e = e || this.current()).deviceType && (t.push("dx-device-".concat(e.deviceType)), "desktop" !== e.deviceType && t.push("dx-device-mobile")), t.push("dx-device-".concat(n.platform)), n.version && n.version.length && t.push("dx-device-".concat(n.platform, "-").concat(n.version[0])), this.isSimulator() && t.push("dx-simulator"), (0, m.default)().rtlEnabled && t.push("dx-rtl"), t
                            }, t.attachCssClasses = function(e, t) {
                                this._deviceClasses = this._getCssClasses(t).join(" "), (0, a.default)(e).addClass(this._deviceClasses)
                            }, t.detachCssClasses = function(e) {
                                (0, a.default)(e).removeClass(this._deviceClasses)
                            }, t.isSimulator = function() {
                                try {
                                    return this._isSimulator || (0, o.hasWindow)() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                                } catch (e) {
                                    return !1
                                }
                            }, t.forceSimulator = function() {
                                this._isSimulator = !0
                            }, t._getDevice = function(e) {
                                if ("genericPhone" === e && (e = {
                                        deviceType: "phone",
                                        platform: "generic",
                                        generic: !0
                                    }), (0, s.isPlainObject)(e)) {
                                    return this._fromConfig(e)
                                }
                                var t;
                                if (e) {
                                    if (!(t = y[e])) {
                                        throw l.default.Error("E0005")
                                    }
                                } else {
                                    t = v.userAgent
                                }
                                return this._fromUA(t)
                            }, t._getDeviceOrNameFromWindowScope = function() {
                                var e;
                                return (0, o.hasWindow)() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]) && (e = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]), e
                            }, t._getDeviceNameFromSessionStorage = function() {
                                var e = (0, g.sessionStorage)();
                                if (e) {
                                    var t = e.getItem("dx-force-device");
                                    try {
                                        return JSON.parse(t)
                                    } catch (e) {
                                        return t
                                    }
                                }
                            }, t._fromConfig = function(e) {
                                var t = (0, r.extend)({}, b, this._currentDevice, e),
                                    n = {
                                        phone: "phone" === t.deviceType,
                                        tablet: "tablet" === t.deviceType,
                                        android: "android" === t.platform,
                                        ios: "ios" === t.platform,
                                        generic: "generic" === t.platform
                                    };
                                return (0, r.extend)(t, n)
                            }, t._fromUA = function(e) {
                                var t;
                                return (0, c.each)(w, (function(n, i) {
                                    return !(t = i(e))
                                })), t ? this._fromConfig(t) : b
                            }, t._changeOrientation = function() {
                                var e = (0, a.default)(this._window),
                                    t = (0, i.getHeight)(e) > (0, i.getWidth)(e) ? "portrait" : "landscape";
                                this._currentOrientation !== t && (this._currentOrientation = t, this._eventsStrategy.fireEvent("orientationChanged", [{
                                    orientation: t
                                }]))
                            }, t._recalculateOrientation = function() {
                                var e = (0, i.getWidth)(this._window);
                                this._currentWidth !== e && (this._currentWidth = e, this._changeOrientation())
                            }, t.on = function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            }, t.off = function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            }, e
                        }()),
                        S = (0, p.value)();
                    S && k.attachCssClasses(S), p.changeCallback.add((function(e, t) {
                        k.detachCssClasses(t), k.attachCssClasses(e)
                    }));
                    var C = k;
                    t.default = C, e.exports = t.default, e.exports.default = t.default
                },
            73349:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/dom_adapter.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ./utils/dependency_injector */ 20476)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./utils/common */ 20576);

                    function r(e) {
                        return r = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, r(e)
                    }
                    var s = {
                            querySelectorAll: function(e, t) {
                                return e.querySelectorAll(t)
                            },
                            elementMatches: function(e, t) {
                                var n = this,
                                    i = e.matches || e.matchesSelector || e.mozMatchesSelector || e.msMatchesSelector || e.oMatchesSelector || e.webkitMatchesSelector || function(t) {
                                        var i = e.document || e.ownerDocument;
                                        if (!i) {
                                            return !1
                                        }
                                        for (var a = n.querySelectorAll(i, t), o = 0; o < a.length; o++) {
                                            if (a[o] === e) {
                                                return !0
                                            }
                                        }
                                    };
                                return i.call(e, t)
                            },
                            createElement: function(e, t) {
                                return (t = t || this._document).createElement(e)
                            },
                            createElementNS: function(e, t, n) {
                                return (n = n || this._document).createElementNS(e, t)
                            },
                            createTextNode: function(e, t) {
                                return (t = t || this._document).createTextNode(e)
                            },
                            isNode: function(e) {
                                return e && "object" === r(e) && "nodeType" in e && "nodeName" in e
                            },
                            isElementNode: function(e) {
                                return e && 1 === e.nodeType
                            },
                            isTextNode: function(e) {
                                return e && 3 === e.nodeType
                            },
                            isDocument: function(e) {
                                return e && 9 === e.nodeType
                            },
                            removeElement: function(e) {
                                var t = e && e.parentNode;
                                t && t.removeChild(e)
                            },
                            insertElement: function(e, t, n) {
                                e && t && e !== t && (n ? e.insertBefore(t, n) : e.appendChild(t))
                            },
                            getAttribute: function(e, t) {
                                return e.getAttribute(t)
                            },
                            setAttribute: function(e, t, n) {
                                e.setAttribute(t, n)
                            },
                            removeAttribute: function(e, t) {
                                e.removeAttribute(t)
                            },
                            setProperty: function(e, t, n) {
                                e[t] = n
                            },
                            setText: function(e, t) {
                                e && (e.textContent = t)
                            },
                            setClass: function(e, t, n) {
                                1 === e.nodeType && t && (n ? e.classList.add(t) : e.classList.remove(t))
                            },
                            setStyle: function(e, t, n) {
                                e.style[t] = n || ""
                            },
                            _document: "undefined" == typeof document ? void 0 : document,
                            getDocument: function() {
                                return this._document
                            },
                            getActiveElement: function() {
                                return this._document.activeElement
                            },
                            getBody: function() {
                                return this._document.body
                            },
                            createDocumentFragment: function() {
                                return this._document.createDocumentFragment()
                            },
                            getDocumentElement: function() {
                                return this._document.documentElement
                            },
                            getLocation: function() {
                                return this._document.location
                            },
                            getSelection: function() {
                                return this._document.selection
                            },
                            getReadyState: function() {
                                return this._document.readyState
                            },
                            getHead: function() {
                                return this._document.head
                            },
                            hasDocumentProperty: function(e) {
                                return e in this._document
                            },
                            listen: function(e, t, n, i) {
                                return e && "addEventListener" in e ? (e.addEventListener(t, n, i), function() {
                                    e.removeEventListener(t, n)
                                }) : o.noop
                            },
                            elementsFromPoint: function(e, t) {
                                return this._document.elementsFromPoint(e, t)
                            }
                        },
                        c = (0, a.default)(s);
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            13046:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/dom_component.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = x(n( /*! ../core/renderer */ 68374)),
                        a = x(n( /*! ./config */ 80209)),
                        o = x(n( /*! ./errors */ 17381)),
                        r = x(n( /*! ../core/utils/resize_callbacks */ 55814)),
                        s = n( /*! ./component */ 44297),
                        c = n( /*! ./template_manager */ 14192),
                        l = n( /*! ./utils/public_component */ 9321),
                        u = n( /*! ./element_data */ 97906),
                        d = n( /*! ./utils/iterator */ 95479),
                        f = n( /*! ./utils/extend */ 13306),
                        h = n( /*! ../core/element */ 6415),
                        g = n( /*! ./utils/common */ 20576),
                        p = n( /*! ./utils/array */ 89386),
                        m = n( /*! ./utils/type */ 35922),
                        _ = n( /*! ../core/utils/window */ 58201),
                        v = n( /*! ../events/short */ 72918);

                    function x(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var y = s.Component.abstract,
                        b = s.Component.inherit({
                            _getDefaultOptions: function() {
                                return (0, f.extend)(this.callBase(), {
                                    width: void 0,
                                    height: void 0,
                                    rtlEnabled: (0, a.default)().rtlEnabled,
                                    elementAttr: {},
                                    disabled: !1,
                                    integrationOptions: {}
                                }, this._useTemplates() ? c.TemplateManager.createDefaultOptions() : {})
                            },
                            ctor: function(e, t) {
                                this._customClass = null, this._createElement(e), (0, l.attachInstanceToElement)(this._$element, this, this._dispose), this.callBase(t)
                            },
                            _createElement: function(e) {
                                this._$element = (0, i.default)(e)
                            },
                            _getSynchronizableOptionsForCreateComponent: function() {
                                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
                            },
                            _checkFunctionValueDeprecation: function(e) {
                                var t = this;
                                this.option("_ignoreFunctionValueDeprecation") || e.forEach((function(e) {
                                    (0, m.isFunction)(t.option(e)) && o.default.log("W0017", e)
                                }))
                            },
                            _visibilityChanged: y,
                            _dimensionChanged: y,
                            _init: function() {
                                this.callBase(), this._checkFunctionValueDeprecation(["width", "height", "maxHeight", "maxWidth", "minHeight", "minWidth", "popupHeight", "popupWidth"]), this._attachWindowResizeCallback(), this._initTemplateManager()
                            },
                            _setOptionsByDevice: function(e) {
                                this.callBase([].concat(this.constructor._classCustomRules || [], e || []))
                            },
                            _isInitialOptionValue: function(e) {
                                return !(this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), e)) && this.callBase(e)
                            },
                            _attachWindowResizeCallback: function() {
                                if (this._isDimensionChangeSupported()) {
                                    var e = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                                    r.default.add(e)
                                }
                            },
                            _isDimensionChangeSupported: function() {
                                return this._dimensionChanged !== y
                            },
                            _renderComponent: function() {
                                this._initMarkup(), (0, _.hasWindow)() && this._render()
                            },
                            _initMarkup: function() {
                                var e = (this.option() || {}).rtlEnabled;
                                this._renderElementAttributes(), this._toggleRTLDirection(e), this._renderVisibilityChange(), this._renderDimensions()
                            },
                            _render: function() {
                                this._attachVisibilityChangeHandlers()
                            },
                            _renderElementAttributes: function() {
                                var e = (this.option() || {}).elementAttr,
                                    t = (0, f.extend)({}, e),
                                    n = t.class;
                                delete t.class, this.$element().attr(t).removeClass(this._customClass).addClass(n), this._customClass = n
                            },
                            _renderVisibilityChange: function() {
                                (this._isDimensionChangeSupported() && this._attachDimensionChangeHandlers(), this._isVisibilityChangeSupported()) && this.$element().addClass("dx-visibility-change-handler")
                            },
                            _renderDimensions: function() {
                                var e = this.$element(),
                                    t = e.get(0),
                                    n = this._getOptionValue("width", t),
                                    i = this._getOptionValue("height", t);
                                this._isCssUpdateRequired(t, i, n) && e.css({
                                    width: null === n ? "" : n,
                                    height: null === i ? "" : i
                                })
                            },
                            _isCssUpdateRequired: function(e, t, n) {
                                return !!((0, m.isDefined)(n) || (0, m.isDefined)(t) || e.style.width || e.style.height)
                            },
                            _attachDimensionChangeHandlers: function() {
                                var e = this,
                                    t = this.$element(),
                                    n = "".concat(this.NAME, "VisibilityChange");
                                v.resize.off(t, {
                                    namespace: n
                                }), v.resize.on(t, (function() {
                                    return e._dimensionChanged()
                                }), {
                                    namespace: n
                                })
                            },
                            _attachVisibilityChangeHandlers: function() {
                                var e = this;
                                if (this._isVisibilityChangeSupported()) {
                                    var t = this.$element(),
                                        n = "".concat(this.NAME, "VisibilityChange");
                                    this._isHidden = !this._isVisible(), v.visibility.off(t, {
                                        namespace: n
                                    }), v.visibility.on(t, (function() {
                                        return e._checkVisibilityChanged("shown")
                                    }), (function() {
                                        return e._checkVisibilityChanged("hiding")
                                    }), {
                                        namespace: n
                                    })
                                }
                            },
                            _isVisible: function() {
                                return this.$element().is(":visible")
                            },
                            _checkVisibilityChanged: function(e) {
                                this._isVisible() && ("hiding" !== e || this._isHidden ? "shown" === e && this._isHidden && (this._isHidden = !1, this._visibilityChanged(!0)) : (this._visibilityChanged(!1), this._isHidden = !0))
                            },
                            _isVisibilityChangeSupported: function() {
                                return this._visibilityChanged !== y && (0, _.hasWindow)()
                            },
                            _clean: g.noop,
                            _modelByElement: function() {
                                var e = this.option().modelByElement,
                                    t = this.$element();
                                return e ? e(t) : void 0
                            },
                            _invalidate: function() {
                                if (this._isUpdateAllowed()) {
                                    throw o.default.Error("E0007")
                                }
                                this._requireRefresh = !0
                            },
                            _refresh: function() {
                                this._clean(), this._renderComponent()
                            },
                            _dispose: function() {
                                this._templateManager && this._templateManager.dispose(), this.callBase(), this._clean(), this._detachWindowResizeCallback()
                            },
                            _detachWindowResizeCallback: function() {
                                this._isDimensionChangeSupported() && r.default.remove(this._windowResizeCallBack)
                            },
                            _toggleRTLDirection: function(e) {
                                this.$element().toggleClass("dx-rtl", e)
                            },
                            _createComponent: function(e, t) {
                                var n = this,
                                    a = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                    o = (0, g.grep)(this._getSynchronizableOptionsForCreateComponent(), (function(e) {
                                        return !(e in a)
                                    })),
                                    r = this.option(),
                                    s = r.integrationOptions,
                                    c = this.option(),
                                    l = c.nestedComponentOptions;
                                l = l || g.noop;
                                var u = (0, f.extend)({
                                    integrationOptions: s
                                }, l(this));
                                o.forEach((function(e) {
                                    return u[e] = n.option(e)
                                })), this._extendConfig(a, u);
                                var d = void 0;
                                if ((0, m.isString)(t)) {
                                    var h = (0, i.default)(e)[t](a);
                                    d = h[t]("instance")
                                } else {
                                    e && ((d = t.getInstance(e)) ? d.option(a) : d = new t(e, a))
                                }
                                if (d) {
                                    var _ = function(e) {
                                        var t = e.name,
                                            n = e.value;
                                        (0, p.inArray)(t, o) >= 0 && d.option(t, n)
                                    };
                                    this.on("optionChanged", _), d.on("disposing", (function() {
                                        return n.off("optionChanged", _)
                                    }))
                                }
                                return d
                            },
                            _extendConfig: function(e, t) {
                                (0, d.each)(t, (function(t, n) {
                                    !Object.prototype.hasOwnProperty.call(e, t) && (e[t] = n)
                                }))
                            },
                            _defaultActionConfig: function() {
                                var e = this.$element(),
                                    t = this._modelByElement(e);
                                return (0, f.extend)(this.callBase(), {
                                    context: t
                                })
                            },
                            _defaultActionArgs: function() {
                                var e = this.$element(),
                                    t = this._modelByElement(e),
                                    n = this.element();
                                return (0, f.extend)(this.callBase(), {
                                    element: n,
                                    model: t
                                })
                            },
                            _optionChanged: function(e) {
                                switch (e.name) {
                                    case "width":
                                    case "height":
                                        this._renderDimensions();
                                        break;
                                    case "rtlEnabled":
                                        this._invalidate();
                                        break;
                                    case "elementAttr":
                                        this._renderElementAttributes();
                                        break;
                                    case "disabled":
                                    case "integrationOptions":
                                        break;
                                    default:
                                        this.callBase(e)
                                }
                            },
                            _removeAttributes: function(e) {
                                for (var t = e.attributes, n = t.length - 1; n >= 0; n--) {
                                    var i = t[n];
                                    if (i) {
                                        var a = i.name;
                                        a.indexOf("aria-") && -1 === a.indexOf("dx-") && "role" !== a && "style" !== a && "tabindex" !== a || e.removeAttribute(a)
                                    }
                                }
                            },
                            _removeClasses: function(e) {
                                e.className = e.className.split(" ").filter((function(e) {
                                    return 0 !== e.lastIndexOf("dx-", 0)
                                })).join(" ")
                            },
                            _updateDOMComponent: function(e) {
                                e ? this._renderComponent() : this._requireRefresh && (this._requireRefresh = !1, this._refresh())
                            },
                            endUpdate: function() {
                                var e = this._isInitializingRequired();
                                this.callBase(), this._isUpdateAllowed() && this._updateDOMComponent(e)
                            },
                            $element: function() {
                                return this._$element
                            },
                            element: function() {
                                var e = this.$element();
                                return (0, h.getPublicElement)(e)
                            },
                            dispose: function() {
                                var e = this.$element().get(0);
                                (0, u.cleanDataRecursive)(e, !0), e.textContent = "", this._removeAttributes(e), this._removeClasses(e)
                            },
                            resetOption: function(e) {
                                if (this.callBase(e), "width" === e || "height" === e) {
                                    var t = this.initialOption(e);
                                    !(0, m.isDefined)(t) && this.$element().css(e, "")
                                }
                            },
                            _getAnonymousTemplateName: function() {},
                            _initTemplateManager: function() {
                                if (!this._templateManager && this._useTemplates()) {
                                    var e = this.option().integrationOptions,
                                        t = (void 0 === e ? {} : e).createTemplate;
                                    this._templateManager = new c.TemplateManager(t, this._getAnonymousTemplateName()), this._initTemplates()
                                }
                            },
                            _initTemplates: function() {
                                var e = this,
                                    t = this._templateManager.extractTemplates(this.$element()),
                                    n = t.templates,
                                    i = t.anonymousTemplateMeta,
                                    a = this.option("integrationOptions.templates.".concat(i.name));
                                n.forEach((function(t) {
                                    var n = t.name,
                                        i = t.template;
                                    e._options.silent("integrationOptions.templates.".concat(n), i)
                                })), i.name && !a && (this._options.silent("integrationOptions.templates.".concat(i.name), i.template), this._options.silent("_hasAnonymousTemplateContent", !0))
                            },
                            _getTemplateByOption: function(e) {
                                return this._getTemplate(this.option(e))
                            },
                            _getTemplate: function(e) {
                                var t = this.option("integrationOptions.templates"),
                                    n = this.option("templatesRenderAsynchronously"),
                                    i = this.option("integrationOptions.skipTemplates");
                                return this._templateManager.getTemplate(e, t, {
                                    isAsyncTemplate: n,
                                    skipTemplates: i
                                }, this)
                            },
                            _saveTemplate: function(e, t) {
                                this._setOptionWithoutOptionChange("integrationOptions.templates." + e, this._templateManager._createTemplate(t))
                            },
                            _useTemplates: function() {
                                return !0
                            }
                        });
                    b.getInstance = function(e) {
                        return (0, l.getInstanceByElement)((0, i.default)(e), this)
                    }, b.defaultOptions = function(e) {
                        this._classCustomRules = this._classCustomRules || [], this._classCustomRules.push(e)
                    };
                    var w = b;
                    t.default = w, e.exports = t.default, e.exports.default = t.default
                },
            6415:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/element.js ***!
                  \*************************************************************/
                function(e, t) {
                    t.getPublicElement = function(e) {
                        return n(e)
                    }, t.setPublicElementWrapper = function(e) {
                        n = e
                    };
                    var n = function(e) {
                        return e && e.get(0)
                    }
                },
            97906:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/element_data.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.afterCleanData = function(e) {
                        f = e
                    }, t.beforeCleanData = function(e) {
                        d = e
                    }, t.cleanData = function(e) {
                        return c.cleanData.call(this, e)
                    }, t.cleanDataRecursive = function(e, t) {
                        if (!a.default.isElementNode(e)) {
                            return
                        }
                        var n = e.getElementsByTagName("*");
                        c.cleanData(n), t && c.cleanData([e])
                    }, t.data = function() {
                        return c.data.apply(this, arguments)
                    }, t.getDataStrategy = function() {
                        return c
                    }, t.removeData = function(e, t) {
                        return c.removeData.call(this, e, t)
                    }, t.strategyChanging = t.setDataStrategy = void 0;
                    var i = s(n( /*! ./polyfills/weak_map */ 10126)),
                        a = s(n( /*! ./dom_adapter */ 73349)),
                        o = s(n( /*! ../events/core/events_engine */ 55994)),
                        r = s(n( /*! ./memorized_callbacks */ 83358));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c, l = new i.default,
                        u = new r.default;
                    t.strategyChanging = u;
                    var d = function() {},
                        f = function() {},
                        h = function(e) {
                            u.fire(e);
                            var t = (c = e).cleanData;
                            c.cleanData = function(e) {
                                d(e);
                                var n = t.call(this, e);
                                return f(e), n
                            }
                        };
                    t.setDataStrategy = h, h({
                        data: function() {
                            var e = arguments[0],
                                t = arguments[1],
                                n = arguments[2];
                            if (e) {
                                var i = l.get(e);
                                return i || (i = {}, l.set(e, i)), void 0 === t ? i : 2 === arguments.length ? i[t] : (i[t] = n, n)
                            }
                        },
                        removeData: function(e, t) {
                            if (e) {
                                if (void 0 === t) {
                                    l.delete(e)
                                } else {
                                    var n = l.get(e);
                                    n && delete n[t]
                                }
                            }
                        },
                        cleanData: function(e) {
                            for (var t = 0; t < e.length; t++) {
                                o.default.off(e[t]), l.delete(e[t])
                            }
                        }
                    })
                },
            17381:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/errors.js ***!
                  \************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var a = (0, ((i = n( /*! ./utils/error */ 95640)) && i.__esModule ? i : {
                        default: i
                    }).default)({
                        E0001: "Method is not implemented",
                        E0002: "Member name collision: {0}",
                        E0003: "A class must be instantiated using the 'new' keyword",
                        E0004: "The NAME property of the component is not specified",
                        E0005: "Unknown device",
                        E0006: "Unknown endpoint key is requested",
                        E0007: "'Invalidate' method is called outside the update transaction",
                        E0008: "Type of the option name is not appropriate to create an action",
                        E0009: "Component '{0}' has not been initialized for an element",
                        E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
                        E0011: "Unknown animation type '{0}'",
                        E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
                        E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
                        E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
                        E0015: "Queued task returned an unexpected result",
                        E0017: "Event namespace is not defined",
                        E0018: "DevExpress.ui.DevExpressPopup widget is required",
                        E0020: "Template engine '{0}' is not supported",
                        E0021: "Unknown theme is set: {0}",
                        E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
                        E0023: "Template name is not specified",
                        E0024: "DevExtreme bundle already included",
                        E0025: "Unexpected argument type",
                        E0100: "Unknown validation type is detected",
                        E0101: "Misconfigured range validation rule is detected",
                        E0102: "Misconfigured comparison validation rule is detected",
                        E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
                        E0110: "Unknown validation group is detected",
                        E0120: "Adapter for a DevExpressValidator component cannot be configured",
                        E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
                        W0000: "'{0}' is deprecated in {1}. {2}",
                        W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
                        W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
                        W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
                        W0004: "Timeout for theme loading is over: {0}",
                        W0005: "'{0}' event is deprecated in {1}. {2}",
                        W0006: "Invalid recurrence rule: '{0}'",
                        W0007: "'{0}' Globalize culture is not defined",
                        W0008: "Invalid view name: '{0}'",
                        W0009: "Invalid time zone name: '{0}'",
                        W0010: "{0} is deprecated in {1}. {2}",
                        W0011: "Number parsing is invoked while the parser is not defined",
                        W0012: "Date parsing is invoked while the parser is not defined",
                        W0013: "'{0}' file is deprecated in {1}. {2}",
                        W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
                        W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
                        W0016: 'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',
                        W0017: 'Setting the "{0}" property with a function is deprecated since v21.2',
                        W0018: 'Setting the "position" property with a function is deprecated since v21.2'
                    });
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            80566:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/events_strategy.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.EventsStrategy = void 0;
                    var i, a = (i = n( /*! ./utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./utils/iterator */ 95479),
                        r = n( /*! ./utils/type */ 35922);
                    var s = function() {
                        function e(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                            this._events = {}, this._owner = e, this._options = t
                        }
                        e.create = function(t, n) {
                            return n ? (0, r.isFunction)(n) ? n(t) : n : new e(t)
                        };
                        var t = e.prototype;
                        return t.hasEvent = function(e) {
                            var t = this._events[e];
                            return !!t && t.has()
                        }, t.fireEvent = function(e, t) {
                            var n = this._events[e];
                            return n && n.fireWith(this._owner, t), this._owner
                        }, t.on = function(e, t) {
                            var n = this;
                            if ((0, r.isPlainObject)(e)) {
                                (0, o.each)(e, (function(e, t) {
                                    n.on(e, t)
                                }))
                            } else {
                                var i = this._events[e];
                                i || (i = (0, a.default)({
                                    syncStrategy: this._options.syncStrategy
                                }), this._events[e] = i), (i.originalAdd || i.add).call(i, t)
                            }
                        }, t.off = function(e, t) {
                            var n = this._events[e];
                            n && ((0, r.isFunction)(t) ? n.remove(t) : n.empty())
                        }, t.dispose = function() {
                            (0, o.each)(this._events, (function(e, t) {
                                t.empty()
                            }))
                        }, e
                    }();
                    t.EventsStrategy = s
                },
            73176:
                /*!**********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/guid.js ***!
                  \**********************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var a = ((i = n( /*! ./class */ 38377)) && i.__esModule ? i : {
                        default: i
                    }).default.inherit({
                        ctor: function(e) {
                            e && (e = String(e)), this._value = this._normalize(e || this._generate())
                        },
                        _normalize: function(e) {
                            for (e = e.replace(/[^a-f0-9]/gi, "").toLowerCase(); e.length < 32;) {
                                e += "0"
                            }
                            return [e.substr(0, 8), e.substr(8, 4), e.substr(12, 4), e.substr(16, 4), e.substr(20, 12)].join("-")
                        },
                        _generate: function() {
                            for (var e = "", t = 0; t < 32; t++) {
                                e += Math.round(15 * Math.random()).toString(16)
                            }
                            return e
                        },
                        toString: function() {
                            return this._value
                        },
                        valueOf: function() {
                            return this._value
                        },
                        toJSON: function() {
                            return this._value
                        }
                    });
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            83448:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/http_request.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ./utils/window */ 58201),
                        o = (i = n( /*! ./utils/dependency_injector */ 20476)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = (0, a.getWindow)(),
                        s = {
                            getXhr: function() {
                                return new r.XMLHttpRequest
                            }
                        },
                        c = (0, o.default)(s);
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            15334:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/inferno_renderer.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! inferno */ 55285),
                        a = n( /*! @devextreme/runtime/inferno */ 44105),
                        o = n( /*! inferno-create-element */ 87456),
                        r = l(n( /*! ./dom_adapter */ 73349)),
                        s = n( /*! ./element_data */ 97906),
                        c = l(n( /*! ./utils/dependency_injector */ 20476));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = function(e) {
                            var t = e.parentNode;
                            t && ((0, s.cleanDataRecursive)(e), t.$V = e.$V, (0, i.render)(null, t), t.appendChild(e), e.innerHTML = "", delete t.$V), delete e.$V
                        },
                        d = (0, c.default)({
                            createElement: function(e, t) {
                                return (0, o.createElement)(e, t)
                            },
                            remove: u,
                            onAfterRender: function() {
                                a.InfernoEffectHost.callEffects()
                            },
                            onPreRender: function() {
                                a.InfernoEffectHost.lock()
                            },
                            render: function(e, t, n, s) {
                                if (s) {
                                    (0, i.render)((0, o.createElement)(e, t), n)
                                } else {
                                    var c = n.parentNode,
                                        l = null == n ? void 0 : n.nextSibling,
                                        d = r.default.createElement("div");
                                    d.appendChild(n);
                                    var f = r.default.createDocumentFragment().appendChild(d);
                                    !!n.$V && u(n), (0, a.hydrate)((0, o.createElement)(e, t), f), n.$V = f.$V, c && c.insertBefore(n, l)
                                }
                            }
                        });
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            83358:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/memorized_callbacks.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../core/utils/iterator */ 95479),
                        o = (i = n( /*! ./utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function() {
                        function e() {
                            this.memory = [], this.callbacks = (0, o.default)()
                        }
                        var t = e.prototype;
                        return t.add = function(e) {
                            (0, a.each)(this.memory, (function(t, n) {
                                return e.apply(e, n)
                            })), this.callbacks.add(e)
                        }, t.remove = function(e) {
                            this.callbacks.remove(e)
                        }, t.fire = function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            this.memory.push(t), this.callbacks.fire.apply(this.callbacks, t)
                        }, e
                    }();
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            95683:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/index.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.Options = void 0;
                    var i = n( /*! ../utils/type */ 35922),
                        a = n( /*! ../utils/common */ 20576),
                        o = n( /*! ./option_manager */ 9030),
                        r = n( /*! ../utils/data */ 47617),
                        s = n( /*! ./utils */ 45434),
                        c = n( /*! ../utils/extend */ 13306);

                    function l() {
                        return l = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, l.apply(this, arguments)
                    }

                    function u(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    var d = function() {
                        function e(e, t, n, i) {
                            var a = this;
                            this._deprecatedCallback, this._startChangeCallback, this._endChangeCallback, this._default = t, this._deprecated = i, this._deprecatedNames = [], this._initDeprecatedNames(), this._optionManager = new o.OptionManager(e, n), this._optionManager.onRelevantNamesPrepared((function(e, t, n, i) {
                                return a._setRelevantNames(e, t, n, i)
                            })), this._cachedOptions = {}, this._rules = []
                        }
                        var t, n, d, f = e.prototype;
                        return f._initDeprecatedNames = function() {
                            for (var e in this._deprecated) {
                                this._deprecatedNames.push(e)
                            }
                        }, f._getByRules = function(e) {
                            return e = Array.isArray(e) ? this._rules.concat(e) : this._rules, (0, s.convertRulesToOptions)(e)
                        }, f._notifyDeprecated = function(e) {
                            var t = this._deprecated[e];
                            t && this._deprecatedCallback(e, t)
                        }, f._setRelevantNames = function(e, t, n, i) {
                            if (t) {
                                var a = this._normalizeName(t, i);
                                a && a !== t && (this._setField(e, a, n), this._clearField(e, t))
                            }
                        }, f._setField = function(e, t, n) {
                            var i = "",
                                a = null;
                            do {
                                i = i ? ".".concat(i) : "", i = (0, s.getFieldName)(t) + i, a = (t = (0, s.getParentName)(t)) ? this._optionManager.get(e, t, !1) : e
                            } while (!a);
                            a[i] = n
                        }, f._clearField = function(e, t) {
                            delete e[t];
                            var n = (0, s.getParentName)(t),
                                i = n ? this._optionManager.get(e, n, !1) : e;
                            i && delete i[(0, s.getFieldName)(t)]
                        }, f._normalizeName = function(e, t) {
                            if (this._deprecatedNames.length && e) {
                                for (var n = 0; n < this._deprecatedNames.length; n++) {
                                    if (this._deprecatedNames[n] === e) {
                                        var i = this._deprecated[e];
                                        if (i) {
                                            return !t && this._notifyDeprecated(e), i.alias || e
                                        }
                                    }
                                }
                            }
                            return e
                        }, f.addRules = function(e) {
                            this._rules = e.concat(this._rules)
                        }, f.applyRules = function(e) {
                            var t = this._getByRules(e);
                            this.silent(t)
                        }, f.dispose = function() {
                            this._deprecatedCallback = a.noop, this._startChangeCallback = a.noop, this._endChangeCallback = a.noop, this._optionManager.dispose()
                        }, f.onChanging = function(e) {
                            this._optionManager.onChanging(e)
                        }, f.onChanged = function(e) {
                            this._optionManager.onChanged(e)
                        }, f.onDeprecated = function(e) {
                            this._deprecatedCallback = e
                        }, f.onStartChange = function(e) {
                            this._startChangeCallback = e
                        }, f.onEndChange = function(e) {
                            this._endChangeCallback = e
                        }, f.isInitial = function(e) {
                            var t = this.silent(e),
                                n = this.initial(e);
                            return (0, i.isFunction)(t) && (0, i.isFunction)(n) ? t.toString() === n.toString() : (0, a.equalByValue)(t, n)
                        }, f.initial = function(e) {
                            return (0, s.getNestedOptionValue)(this._initial, e)
                        }, f.option = function(e, t) {
                            var n = arguments.length < 2 && "object" !== (0, i.type)(e);
                            if (n) {
                                return this._optionManager.get(void 0, this._normalizeName(e))
                            }
                            this._startChangeCallback();
                            try {
                                this._optionManager.set(e, t)
                            } finally {
                                this._endChangeCallback()
                            }
                        }, f.silent = function(e, t) {
                            var n = arguments.length < 2 && "object" !== (0, i.type)(e);
                            if (n) {
                                return this._optionManager.get(void 0, e, void 0, !0)
                            }
                            this._optionManager.set(e, t, void 0, !0)
                        }, f.reset = function(e) {
                            var t = this;
                            if (e) {
                                var n = (0, r.getPathParts)(e).reduce((function(e, n) {
                                        return e ? e[n] : t.initial(n)
                                    }), null),
                                    a = (0, i.isObject)(n) ? l({}, n) : n;
                                this._optionManager.set(e, a, !1)
                            }
                        }, f.getAliasesByName = function(e) {
                            var t = this;
                            return Object.keys(this._deprecated).filter((function(n) {
                                return e === t._deprecated[n].alias
                            }))
                        }, f.isDeprecated = function(e) {
                            return Object.prototype.hasOwnProperty.call(this._deprecated, e)
                        }, f.cache = function(e, t) {
                            var n = arguments.length < 2;
                            if (n) {
                                return this._cachedOptions[e]
                            }
                            this._cachedOptions[e] = (0, c.extend)(this._cachedOptions[e], t)
                        }, t = e, (n = [{
                            key: "_initial",
                            get: function() {
                                if (!this._initialOptions) {
                                    var e = this._getByRules(this.silent("defaultOptionsRules"));
                                    this._initialOptions = this._default, this._optionManager._setByReference(this._initialOptions, e)
                                }
                                return this._initialOptions
                            },
                            set: function(e) {
                                this._initialOptions = e
                            }
                        }]) && u(t.prototype, n), d, e
                    }();
                    t.Options = d
                },
            9030:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/option_manager.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.OptionManager = void 0;
                    var i = n( /*! ../utils/data */ 47617),
                        a = n( /*! ../utils/common */ 20576),
                        o = n( /*! ../utils/comparator */ 49036),
                        r = n( /*! ../utils/extend */ 13306),
                        s = n( /*! ../utils/type */ 35922),
                        c = n( /*! ./utils */ 45434),
                        l = {},
                        u = {},
                        d = function() {
                            function e(e, t) {
                                this._options = e, this._optionsByReference = t, this._changingCallback, this._changedCallback, this._namePreparedCallbacks
                            }
                            var t = e.prototype;
                            return t._setByReference = function(e, t) {
                                for (var n in (0, r.extend)(!0, e, t), this._optionsByReference) {
                                    Object.prototype.hasOwnProperty.call(t, n) && (e[n] = t[n])
                                }
                            }, t._setPreparedValue = function(e, t, n, a) {
                                var r = this.get(this._options, e, !1);
                                if (!(0, o.equals)(r, t)) {
                                    var c = (0, i.getPathParts)(e);
                                    !a && this._changingCallback(e, r, t), u[e] = u[e] || (0, i.compileSetter)(e), u[e](this._options, t, {
                                        functionsAsIs: !0,
                                        merge: (0, s.isDefined)(n) ? n : !this._optionsByReference[e],
                                        unwrapObservables: c.length > 1 && !!this._optionsByReference[c[0]]
                                    }), !a && this._changedCallback(e, t, r)
                                }
                            }, t._prepareRelevantNames = function(e, t, n, i) {
                                if ((0, s.isPlainObject)(n)) {
                                    for (var a in n) {
                                        this._prepareRelevantNames(e, "".concat(t, ".").concat(a), n[a])
                                    }
                                }
                                this._namePreparedCallbacks(e, t, n, i)
                            }, t.get = function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this._options,
                                    t = arguments.length > 1 ? arguments[1] : void 0,
                                    n = arguments.length > 2 ? arguments[2] : void 0;
                                return l[t] = l[t] || (0, i.compileGetter)(t), l[t](e, {
                                    functionsAsIs: !0,
                                    unwrapObservables: n
                                })
                            }, t.set = function(e, t, n, i) {
                                for (var a in e = (0, c.normalizeOptions)(e, t)) {
                                    this._prepareRelevantNames(e, a, e[a], i)
                                }
                                for (var o in e) {
                                    this._setPreparedValue(o, e[o], n, i)
                                }
                            }, t.onRelevantNamesPrepared = function(e) {
                                this._namePreparedCallbacks = e
                            }, t.onChanging = function(e) {
                                this._changingCallback = e
                            }, t.onChanged = function(e) {
                                this._changedCallback = e
                            }, t.dispose = function() {
                                this._changingCallback = a.noop, this._changedCallback = a.noop
                            }, e
                        }();
                    t.OptionManager = d
                },
            45434:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/options/utils.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.normalizeOptions = t.getParentName = t.getNestedOptionValue = t.getFieldName = t.deviceMatch = t.createDefaultOptionRules = t.convertRulesToOptions = void 0;
                    var i, a = (i = n( /*! ../devices */ 20530)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../utils/type */ 35922),
                        r = n( /*! ../utils/common */ 20576),
                        s = n( /*! ../utils/extend */ 13306),
                        c = n( /*! ../utils/data */ 47617);
                    var l = {};
                    t.convertRulesToOptions = function(e) {
                        var t = a.default.current();
                        return e.reduce((function(e, n) {
                            var i = n.device,
                                a = n.options,
                                r = i || {};
                            return ((0, o.isFunction)(r) ? r(t) : u(t, r)) && (0, s.extend)(!0, e, a), e
                        }), {})
                    };
                    t.normalizeOptions = function(e, t) {
                        return "string" != typeof e ? e : function(e, t, n) {
                            return t in e ? Object.defineProperty(e, t, {
                                value: n,
                                enumerable: !0,
                                configurable: !0,
                                writable: !0
                            }) : e[t] = n, e
                        }({}, e, t)
                    };
                    var u = function(e, t) {
                        return (0, o.isEmptyObject)(t) || (0, r.findBestMatches)(e, [t]).length > 0
                    };
                    t.deviceMatch = u;
                    t.getFieldName = function(e) {
                        return e.substr(e.lastIndexOf(".") + 1)
                    };
                    t.getParentName = function(e) {
                        return e.substr(0, e.lastIndexOf("."))
                    };
                    t.getNestedOptionValue = function(e, t) {
                        return l[t] = l[t] || (0, c.compileGetter)(t), l[t](e, {
                            functionsAsIs: !0
                        })
                    };
                    t.createDefaultOptionRules = function() {
                        var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                        return e
                    }
                },
            27050:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/number.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/window */ 58201),
                        a = (0, i.hasWindow)() ? (0, i.getWindow)().Number : Number;
                    a.isFinite = a.isFinite || function(e) {
                        return "number" == typeof e && isFinite(e)
                    };
                    var o = a;
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            48136:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/promise.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/deferred */ 62754),
                        a = n( /*! ../../core/utils/window */ 58201),
                        o = (0, a.hasWindow)() ? (0, a.getWindow)().Promise : Promise;
                    o || ((o = function(e) {
                        var t = new i.Deferred;
                        return e(t.resolve.bind(this), t.reject.bind(this)), t.promise()
                    }).resolve = function(e) {
                        return (new i.Deferred).resolve(e).promise()
                    }, o.reject = function(e) {
                        return (new i.Deferred).reject(e).promise()
                    }, o.all = function(e) {
                        return i.when.apply(this, e).then((function() {
                            return [].slice.call(arguments)
                        }))
                    });
                    var r = o;
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            10126:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/polyfills/weak_map.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../utils/array */ 89386),
                        a = n( /*! ../utils/window */ 58201),
                        o = (0, a.hasWindow)() ? (0, a.getWindow)().WeakMap : WeakMap;
                    o || (o = function() {
                        var e = [],
                            t = [];
                        this.set = function(n, a) {
                            var o = (0, i.inArray)(n, e); - 1 === o ? (e.push(n), t.push(a)) : t[o] = a
                        }, this.get = function(n) {
                            var a = (0, i.inArray)(n, e);
                            if (-1 !== a) {
                                return t[a]
                            }
                        }, this.has = function(t) {
                            return -1 !== (0, i.inArray)(t, e)
                        }, this.delete = function(n) {
                            var a = (0, i.inArray)(n, e); - 1 !== a && (e.splice(a, 1), t.splice(a, 1))
                        }
                    });
                    var r = o;
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            90889:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/postponed_operations.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.PostponedOperations = void 0;
                    var i = n( /*! ./utils/deferred */ 62754),
                        a = n( /*! ./utils/type */ 35922);

                    function o(e) {
                        return function(e) {
                            if (Array.isArray(e)) {
                                return r(e)
                            }
                        }(e) || function(e) {
                            if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                return Array.from(e)
                            }
                        }(e) || function(e, t) {
                            if (!e) {
                                return
                            }
                            if ("string" == typeof e) {
                                return r(e, t)
                            }
                            var n = Object.prototype.toString.call(e).slice(8, -1);
                            "Object" === n && e.constructor && (n = e.constructor.name);
                            if ("Map" === n || "Set" === n) {
                                return Array.from(e)
                            }
                            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                return r(e, t)
                            }
                        }(e) || function() {
                            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                        }()
                    }

                    function r(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var s = function() {
                        function e() {
                            this._postponedOperations = {}
                        }
                        var t = e.prototype;
                        return t.add = function(e, t, n) {
                            if (e in this._postponedOperations) {
                                n && this._postponedOperations[e].promises.push(n)
                            } else {
                                var a = new i.Deferred;
                                this._postponedOperations[e] = {
                                    fn: t,
                                    completePromise: a,
                                    promises: n ? [n] : []
                                }
                            }
                            return this._postponedOperations[e].completePromise.promise()
                        }, t.callPostponedOperations = function() {
                            for (var e in this._postponedOperations) {
                                var t = this._postponedOperations[e];
                                (0, a.isDefined)(t) && (t.promises && t.promises.length ? i.when.apply(void 0, o(t.promises)).done(t.fn).then(t.completePromise.resolve) : t.fn().done(t.completePromise.resolve))
                            }
                            this._postponedOperations = {}
                        }, e
                    }();
                    t.PostponedOperations = s
                },
            37819:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/remove_event.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.removeEvent = void 0;
                    var i = s(n( /*! ./renderer */ 68374)),
                        a = n( /*! ./element_data */ 97906),
                        o = s(n( /*! ../events/core/events_engine */ 55994)),
                        r = s(n( /*! ../events/core/event_registrator */ 85788));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dxremove";
                    t.removeEvent = c;
                    var l = "dxRemoveEvent";
                    (0, a.beforeCleanData)((function(e) {
                        e = [].slice.call(e);
                        for (var t = 0; t < e.length; t++) {
                            var n = (0, i.default)(e[t]);
                            n.prop(l) && (n[0].dxRemoveEvent = null, o.default.triggerHandler(n, c))
                        }
                    })), (0, r.default)(c, {
                        noBubble: !0,
                        setup: function(e) {
                            (0, i.default)(e).prop(l, !0)
                        }
                    })
                },
            68374:
                /*!**************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/renderer.js ***!
                  \**************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var a = ((i = n( /*! ./renderer_base */ 82981)) && i.__esModule ? i : {
                        default: i
                    }).default.get();
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            82981:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/renderer_base.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ./element_data */ 97906),
                        o = (i = n( /*! ./dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        r = n( /*! ./utils/window */ 58201),
                        s = n( /*! ./utils/type */ 35922),
                        c = n( /*! ./utils/style */ 80968),
                        l = n( /*! ./utils/size */ 58664),
                        u = n( /*! ./utils/html_parser */ 61371);
                    var d, f = (0, r.getWindow)(),
                        h = function(e, t) {
                            return e ? "string" == typeof e ? "body" === e ? (this[0] = t ? t.body : o.default.getBody(), this.length = 1, this) : (t = t || o.default.getDocument(), "<" === e[0] ? (this[0] = o.default.createElement(e.slice(1, -1), t), this.length = 1, this) : ([].push.apply(this, o.default.querySelectorAll(t, e)), this)) : o.default.isNode(e) || (0, s.isWindow)(e) ? (this[0] = e, this.length = 1, this) : Array.isArray(e) ? ([].push.apply(this, e), this) : d(e.toArray ? e.toArray() : [e]) : (this.length = 0, this)
                        };
                    (d = function(e, t) {
                        return new h(e, t)
                    }).fn = {
                        dxRenderer: !0
                    }, h.prototype = d.fn;
                    var g = function(e, t) {
                            for (var n = 0; n < this.length; n++) {
                                var i = d(this[n]);
                                i[e].apply(i, t)
                            }
                            return this
                        },
                        p = function(e, t, n) {
                            null != n ? o.default.setAttribute(e, t, n) : o.default.removeAttribute(e, t)
                        };
                    h.prototype.show = function() {
                        return this.toggle(!0)
                    }, h.prototype.hide = function() {
                        return this.toggle(!1)
                    }, h.prototype.toggle = function(e) {
                        return this[0] && this.toggleClass("dx-state-invisible", !e), this
                    }, h.prototype.attr = function(e, t) {
                        if (this.length > 1 && arguments.length > 1) {
                            return g.call(this, "attr", arguments)
                        }
                        if (!this[0]) {
                            return (0, s.isObject)(e) || void 0 !== t ? this : void 0
                        }
                        if (!this[0].getAttribute) {
                            return this.prop(e, t)
                        }
                        if ("string" == typeof e && 1 === arguments.length) {
                            var n = this[0].getAttribute(e);
                            return null == n ? void 0 : n
                        }
                        if ((0, s.isPlainObject)(e)) {
                            for (var i in e) {
                                this.attr(i, e[i])
                            }
                        } else {
                            p(this[0], e, t)
                        }
                        return this
                    }, h.prototype.removeAttr = function(e) {
                        return this[0] && o.default.removeAttribute(this[0], e), this
                    }, h.prototype.prop = function(e, t) {
                        if (!this[0]) {
                            return this
                        }
                        if ("string" == typeof e && 1 === arguments.length) {
                            return this[0][e]
                        }
                        if ((0, s.isPlainObject)(e)) {
                            for (var n in e) {
                                this.prop(n, e[n])
                            }
                        } else {
                            o.default.setProperty(this[0], e, t)
                        }
                        return this
                    }, h.prototype.addClass = function(e) {
                        return this.toggleClass(e, !0)
                    }, h.prototype.removeClass = function(e) {
                        return this.toggleClass(e, !1)
                    }, h.prototype.hasClass = function(e) {
                        if (!this[0] || void 0 === this[0].className) {
                            return !1
                        }
                        for (var t = e.split(" "), n = 0; n < t.length; n++) {
                            if (this[0].classList) {
                                if (this[0].classList.contains(t[n])) {
                                    return !0
                                }
                            } else if ((((0, s.isString)(this[0].className) ? this[0].className : o.default.getAttribute(this[0], "class")) || "").split(" ").indexOf(t[n]) >= 0) {
                                return !0
                            }
                        }
                        return !1
                    }, h.prototype.toggleClass = function(e, t) {
                        if (this.length > 1) {
                            return g.call(this, "toggleClass", arguments)
                        }
                        if (!this[0] || !e) {
                            return this
                        }
                        t = void 0 === t ? !this.hasClass(e) : t;
                        for (var n = e.split(" "), i = 0; i < n.length; i++) {
                            o.default.setClass(this[0], n[i], t)
                        }
                        return this
                    }, h.prototype.html = function(e) {
                        return arguments.length ? (this.empty(), "string" == typeof e && !(0, u.isTablePart)(e) || "number" == typeof e ? (this[0].innerHTML = e, this) : this.append((0, u.parseHTML)(e))) : this[0].innerHTML
                    };
                    var m = function(e, t) {
                            if (this[0] && e) {
                                "string" == typeof e ? e = (0, u.parseHTML)(e) : e.nodeType ? e = [e] : (0, s.isNumeric)(e) && (e = [o.default.createTextNode(e)]);
                                for (var n = 0; n < e.length; n++) {
                                    var i = e[n],
                                        a = this[0];
                                    "TABLE" === a.tagName && "TR" === i.tagName && a.tBodies && a.tBodies.length && (a = a.tBodies[0]), o.default.insertElement(a, i.nodeType ? i : i[0], t)
                                }
                            }
                        },
                        _ = function(e, t) {
                            if (this[0] && this[0].style && !(null === t || "number" == typeof t && isNaN(t))) {
                                e = (0, c.styleProp)(e);
                                for (var n = 0; n < this.length; n++) {
                                    this[n].style[e] = (0, c.normalizeStyleProp)(e, t)
                                }
                            }
                        };
                    h.prototype.css = function(e, t) {
                        if ((0, s.isString)(e)) {
                            if (2 !== arguments.length) {
                                if (!this[0]) {
                                    return
                                }
                                e = (0, c.styleProp)(e);
                                var n = f.getComputedStyle(this[0])[e] || this[0].style[e];
                                return (0, s.isNumeric)(n) ? n.toString() : n
                            }
                            _.call(this, e, t)
                        } else if ((0, s.isPlainObject)(e)) {
                            for (var i in e) {
                                _.call(this, i, e[i])
                            }
                        }
                        return this
                    }, h.prototype.prepend = function(e) {
                        if (arguments.length > 1) {
                            for (var t = 0; t < arguments.length; t++) {
                                this.prepend(arguments[t])
                            }
                            return this
                        }
                        return m.apply(this, [e, this[0].firstChild]), this
                    }, h.prototype.append = function(e) {
                        if (arguments.length > 1) {
                            for (var t = 0; t < arguments.length; t++) {
                                this.append(arguments[t])
                            }
                            return this
                        }
                        return m.apply(this, [e]), this
                    }, h.prototype.prependTo = function(e) {
                        if (this.length > 1) {
                            for (var t = this.length - 1; t >= 0; t--) {
                                d(this[t]).prependTo(e)
                            }
                            return this
                        }
                        return (e = d(e))[0] && o.default.insertElement(e[0], this[0], e[0].firstChild), this
                    }, h.prototype.appendTo = function(e) {
                        return this.length > 1 ? g.call(this, "appendTo", arguments) : (o.default.insertElement(d(e)[0], this[0]), this)
                    }, h.prototype.insertBefore = function(e) {
                        return e && e[0] && o.default.insertElement(e[0].parentNode, this[0], e[0]), this
                    }, h.prototype.insertAfter = function(e) {
                        return e && e[0] && o.default.insertElement(e[0].parentNode, this[0], e[0].nextSibling), this
                    }, h.prototype.before = function(e) {
                        return this[0] && o.default.insertElement(this[0].parentNode, e[0], this[0]), this
                    }, h.prototype.after = function(e) {
                        return this[0] && o.default.insertElement(this[0].parentNode, e[0], this[0].nextSibling), this
                    }, h.prototype.wrap = function(e) {
                        if (this[0]) {
                            var t = d(e);
                            t.insertBefore(this), t.append(this)
                        }
                        return this
                    }, h.prototype.wrapInner = function(e) {
                        var t = this.contents();
                        return t.length ? t.wrap(e) : this.append(e), this
                    }, h.prototype.replaceWith = function(e) {
                        if (e && e[0]) {
                            return e.is(this) ? this : (e.insertBefore(this), this.remove(), e)
                        }
                    }, h.prototype.remove = function() {
                        return this.length > 1 ? g.call(this, "remove", arguments) : ((0, a.cleanDataRecursive)(this[0], !0), o.default.removeElement(this[0]), this)
                    }, h.prototype.detach = function() {
                        return this.length > 1 ? g.call(this, "detach", arguments) : (o.default.removeElement(this[0]), this)
                    }, h.prototype.empty = function() {
                        return this.length > 1 ? g.call(this, "empty", arguments) : ((0, a.cleanDataRecursive)(this[0]), o.default.setText(this[0], ""), this)
                    }, h.prototype.clone = function() {
                        for (var e = [], t = 0; t < this.length; t++) {
                            e.push(this[t].cloneNode(!0))
                        }
                        return d(e)
                    }, h.prototype.text = function(e) {
                        if (!arguments.length) {
                            for (var t = "", n = 0; n < this.length; n++) {
                                t += this[n] && this[n].textContent || ""
                            }
                            return t
                        }
                        var i = (0, s.isFunction)(e) ? e() : e;
                        return (0, a.cleanDataRecursive)(this[0], !1), o.default.setText(this[0], (0, s.isDefined)(i) ? i : ""), this
                    }, h.prototype.val = function(e) {
                        return 1 === arguments.length ? this.prop("value", (0, s.isDefined)(e) ? e : "") : this.prop("value")
                    }, h.prototype.contents = function() {
                        if (!this[0]) {
                            return d()
                        }
                        var e = [];
                        return e.push.apply(e, this[0].childNodes), d(e)
                    }, h.prototype.find = function(e) {
                        var t = d();
                        if (!e) {
                            return t
                        }
                        var n, i = [];
                        if ("string" == typeof e) {
                            for (e = e.trim(), n = 0; n < this.length; n++) {
                                var a = this[n];
                                if (o.default.isElementNode(a)) {
                                    var r = a.getAttribute("id"),
                                        s = r || "dx-query-children";
                                    r || p(a, "id", s);
                                    var c = (s = "[id='" + s + "'] ") + e.replace(/([^\\])(,)/g, "$1, " + s);
                                    i.push.apply(i, o.default.querySelectorAll(a, c)), p(a, "id", r)
                                } else {
                                    o.default.isDocument(a) && i.push.apply(i, o.default.querySelectorAll(a, e))
                                }
                            }
                        } else {
                            for (n = 0; n < this.length; n++) {
                                e = o.default.isNode(e) ? e : e[0], this[n] !== e && this[n].contains(e) && i.push(e)
                            }
                        }
                        return t.add(i)
                    };
                    var v = function(e, t) {
                        return !t.nodeType || !!(t.offsetWidth || t.offsetHeight || t.getClientRects().length)
                    };
                    h.prototype.filter = function(e) {
                        if (!e) {
                            return d()
                        }
                        if (":visible" === e) {
                            return this.filter(v)
                        }
                        if (":hidden" === e) {
                            return this.filter((function(e, t) {
                                return !v(0, t)
                            }))
                        }
                        for (var t = [], n = 0; n < this.length; n++) {
                            var i = this[n];
                            if (o.default.isElementNode(i) && "string" === (0, s.type)(e)) {
                                o.default.elementMatches(i, e) && t.push(i)
                            } else if (o.default.isNode(e) || (0, s.isWindow)(e)) {
                                e === i && t.push(i)
                            } else if ((0, s.isFunction)(e)) {
                                e.call(i, n, i) && t.push(i)
                            } else {
                                for (var a = 0; a < e.length; a++) {
                                    e[a] === i && t.push(i)
                                }
                            }
                        }
                        return d(t)
                    }, h.prototype.not = function(e) {
                        for (var t = [], n = this.filter(e).toArray(), i = 0; i < this.length; i++) {
                            -1 === n.indexOf(this[i]) && t.push(this[i])
                        }
                        return d(t)
                    }, h.prototype.is = function(e) {
                        return !!this.filter(e).length
                    }, h.prototype.children = function(e) {
                        for (var t = [], n = 0; n < this.length; n++) {
                            for (var i = this[n] ? this[n].childNodes : [], a = 0; a < i.length; a++) {
                                o.default.isElementNode(i[a]) && t.push(i[a])
                            }
                        }
                        return t = d(t), e ? t.filter(e) : t
                    }, h.prototype.siblings = function() {
                        var e = this[0];
                        if (!e || !e.parentNode) {
                            return d()
                        }
                        for (var t = [], n = e.parentNode.childNodes || [], i = 0; i < n.length; i++) {
                            var a = n[i];
                            o.default.isElementNode(a) && a !== e && t.push(a)
                        }
                        return d(t)
                    }, h.prototype.each = function(e) {
                        for (var t = 0; t < this.length && !1 !== e.call(this[t], t, this[t]); t++) {}
                    }, h.prototype.index = function(e) {
                        return e ? (e = d(e), this.toArray().indexOf(e[0])) : this.parent().children().index(this)
                    }, h.prototype.get = function(e) {
                        return this[e < 0 ? this.length + e : e]
                    }, h.prototype.eq = function(e) {
                        return e = e < 0 ? this.length + e : e, d(this[e])
                    }, h.prototype.first = function() {
                        return this.eq(0)
                    }, h.prototype.last = function() {
                        return this.eq(-1)
                    }, h.prototype.parent = function(e) {
                        if (!this[0]) {
                            return d()
                        }
                        var t = d(this[0].parentNode);
                        return !e || t.is(e) ? t : d()
                    }, h.prototype.parents = function(e) {
                        for (var t = [], n = this.parent(); n && n[0] && !o.default.isDocument(n[0]);) {
                            o.default.isElementNode(n[0]) && (e && !n.is(e) || t.push(n.get(0))), n = n.parent()
                        }
                        return d(t)
                    }, h.prototype.closest = function(e) {
                        if (this.is(e)) {
                            return this
                        }
                        for (var t = this.parent(); t && t.length;) {
                            if (t.is(e)) {
                                return t
                            }
                            t = t.parent()
                        }
                        return d()
                    }, h.prototype.next = function(e) {
                        if (!this[0]) {
                            return d()
                        }
                        var t = d(this[0].nextSibling);
                        if (!arguments.length) {
                            return t
                        }
                        for (; t && t.length;) {
                            if (t.is(e)) {
                                return t
                            }
                            t = t.next()
                        }
                        return d()
                    }, h.prototype.prev = function() {
                        return this[0] ? d(this[0].previousSibling) : d()
                    }, h.prototype.add = function(e) {
                        for (var t = d(e), n = this.toArray(), i = 0; i < t.length; i++) {
                            var a = t[i]; - 1 === n.indexOf(a) && n.push(a)
                        }
                        return d(n)
                    };
                    var x = [];
                    h.prototype.splice = function() {
                        return d(x.splice.apply(this, arguments))
                    }, h.prototype.slice = function() {
                        return d(x.slice.apply(this, arguments))
                    }, h.prototype.toArray = function() {
                        return x.slice.call(this)
                    }, h.prototype.offset = function() {
                        if (this[0]) {
                            return (0, l.getOffset)(this[0])
                        }
                    }, h.prototype.offsetParent = function() {
                        if (!this[0]) {
                            return d()
                        }
                        for (var e = d(this[0].offsetParent); e[0] && "static" === e.css("position");) {
                            e = d(e[0].offsetParent)
                        }
                        return e[0] ? e : d(o.default.getDocumentElement())
                    }, h.prototype.position = function() {
                        if (this[0]) {
                            var e, t = parseFloat(this.css("marginTop")),
                                n = parseFloat(this.css("marginLeft"));
                            if ("fixed" === this.css("position")) {
                                return {
                                    top: (e = this[0].getBoundingClientRect()).top - t,
                                    left: e.left - n
                                }
                            }
                            e = this.offset();
                            var i = this.offsetParent(),
                                a = {
                                    top: 0,
                                    left: 0
                                };
                            return "HTML" !== i[0].nodeName && (a = i.offset()), a = {
                                top: a.top + parseFloat(i.css("borderTopWidth")),
                                left: a.left + parseFloat(i.css("borderLeftWidth"))
                            }, {
                                top: e.top - a.top - t,
                                left: e.left - a.left - n
                            }
                        }
                    }, [{
                        name: "scrollLeft",
                        offsetProp: "pageXOffset",
                        scrollWindow: function(e, t) {
                            e.scrollTo(t, e.pageYOffset)
                        }
                    }, {
                        name: "scrollTop",
                        offsetProp: "pageYOffset",
                        scrollWindow: function(e, t) {
                            e.scrollTo(e.pageXOffset, t)
                        }
                    }].forEach((function(e) {
                        var t = e.name;
                        h.prototype[t] = function(n) {
                            if (this[0]) {
                                var i = (0, l.getWindowByElement)(this[0]);
                                return void 0 === n ? i ? i[e.offsetProp] : this[0][t] : (i ? e.scrollWindow(i, n) : this[0][t] = n, this)
                            }
                        }
                    })), h.prototype.data = function(e, t) {
                        if (this[0]) {
                            return arguments.length < 2 ? a.data.call(d, this[0], e) : (a.data.call(d, this[0], e, t), this)
                        }
                    }, h.prototype.removeData = function(e) {
                        return this[0] && (0, a.removeData)(this[0], e), this
                    };
                    var y = function() {
                        return d.apply(this, arguments)
                    };
                    Object.defineProperty(y, "fn", {
                        enumerable: !0,
                        configurable: !0,
                        get: function() {
                            return d.fn
                        },
                        set: function(e) {
                            d.fn = e
                        }
                    });
                    var b = {
                        set: function(e) {
                            d = e
                        },
                        get: function() {
                            return y
                        }
                    };
                    t.default = b, e.exports = t.default, e.exports.default = t.default
                },
            91784:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/resize_observer.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/common */ 20576),
                        a = n( /*! ./utils/window */ 58201),
                        o = (0, a.getWindow)(),
                        r = {
                            observe: i.noop,
                            unobserve: i.noop,
                            disconnect: i.noop
                        },
                        s = new(function() {
                            function e() {
                                var e = this;
                                if (!(0, a.hasWindow)() || !o.ResizeObserver) {
                                    return r
                                }
                                this._callbacksMap = new Map, this._observer = new o.ResizeObserver((function(t) {
                                    t.forEach((function(t) {
                                        var n;
                                        null === (n = e._callbacksMap.get(t.target)) || void 0 === n || n(t)
                                    }))
                                }))
                            }
                            var t = e.prototype;
                            return t.observe = function(e, t) {
                                this._callbacksMap.set(e, t), this._observer.observe(e)
                            }, t.unobserve = function(e) {
                                this._callbacksMap.delete(e), this._observer.unobserve(e)
                            }, t.disconnect = function() {
                                this._callbacksMap.clear(), this._observer.disconnect()
                            }, e
                        }());
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            14192:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/template_manager.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.TemplateManager = void 0;
                    var i, a = (i = n( /*! ./renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./utils/type */ 35922),
                        r = n( /*! ./utils/common */ 20576),
                        s = n( /*! ./utils/extend */ 13306),
                        c = n( /*! ./templates/function_template */ 68494),
                        l = n( /*! ./templates/empty_template */ 10688),
                        u = n( /*! ./utils/template_manager */ 69697);

                    function d(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    var f = new c.FunctionTemplate((function(e) {
                            var t = e.model,
                                n = e.parent,
                                i = t.widget;
                            if (!i) {
                                return (0, a.default)()
                            }
                            var o = (0, a.default)("<div>"),
                                r = t.options || {};
                            return n ? n._createComponent(o, i, r) : o[i](r), o
                        })),
                        h = function() {
                            function e(e, t) {
                                this._tempTemplates = [], this._defaultTemplates = {}, this._anonymousTemplateName = t || "template", this._createElement = e || u.defaultCreateElement, this._createTemplateIfNeeded = this._createTemplateIfNeeded.bind(this)
                            }
                            e.createDefaultOptions = function() {
                                return {
                                    integrationOptions: {
                                        watchMethod: function(e, t) {
                                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                                            return n.skipImmediate || t(e()), r.noop
                                        },
                                        templates: {
                                            "dx-polymorph-widget": f
                                        },
                                        useDeferUpdateForTemplates: !0
                                    }
                                }
                            };
                            var t, n, i, h = e.prototype;
                            return h.addDefaultTemplates = function(e) {
                                this._defaultTemplates = (0, s.extend)({}, this._defaultTemplates, e)
                            }, h.dispose = function() {
                                this._tempTemplates.forEach((function(e) {
                                    e.template.dispose && e.template.dispose()
                                })), this._tempTemplates = []
                            }, h.extractTemplates = function(e) {
                                return {
                                    templates: this._extractTemplates(e),
                                    anonymousTemplateMeta: this._extractAnonymousTemplate(e)
                                }
                            }, h._extractTemplates = function(e) {
                                var t = this,
                                    n = (0, u.findTemplates)(e, "dxTemplate"),
                                    i = (0, u.suitableTemplatesByName)(n);
                                return n.forEach((function(e) {
                                    var t = e.element,
                                        n = e.options.name;
                                    t === i[n] ? (0, a.default)(t).addClass("dx-template-wrapper").detach() : (0, a.default)(t).remove()
                                })), Object.keys(i).map((function(e) {
                                    return {
                                        name: e,
                                        template: t._createTemplate(i[e])
                                    }
                                }))
                            }, h._extractAnonymousTemplate = function(e) {
                                var t = e.contents().detach();
                                return t.filter((function(e, t) {
                                    var n = 3 === t.nodeType,
                                        i = (0, a.default)(t).text().trim().length < 1;
                                    return !(n && i)
                                })).length > 0 ? {
                                    template: this._createTemplate(t),
                                    name: this._anonymousTemplateName
                                } : {}
                            }, h._createTemplateIfNeeded = function(e) {
                                var t = this._tempTemplates.filter((function(t) {
                                    return t.source === (0, u.templateKey)(e)
                                }))[0];
                                if (t) {
                                    return t.template
                                }
                                var n = this._createTemplate(e);
                                return this._tempTemplates.push({
                                    template: n,
                                    source: (0, u.templateKey)(e)
                                }), n
                            }, h._createTemplate = function(e) {
                                return this._createElement((0, u.validateTemplateSource)(e))
                            }, h.getTemplate = function(e, t, n, i) {
                                var r = this,
                                    s = n.isAsyncTemplate,
                                    d = n.skipTemplates;
                                return (0, o.isFunction)(e) ? new c.FunctionTemplate((function(n) {
                                    var f = e.apply(i, (0, u.getNormalizedTemplateArgs)(n));
                                    if (!(0, o.isDefined)(f)) {
                                        return new l.EmptyTemplate
                                    }
                                    var h = !1,
                                        g = (0, u.acquireTemplate)(f, (function(e) {
                                            return e.nodeType || (0, o.isRenderer)(e) && !(0, a.default)(e).is("script") ? new c.FunctionTemplate((function() {
                                                return e
                                            })) : (h = !0, r._createTemplate(e))
                                        }), t, s, d, r._defaultTemplates),
                                        p = g.render(n);
                                    return h && g.dispose && g.dispose(), p
                                })) : (0, u.acquireTemplate)(e, this._createTemplateIfNeeded, t, s, d, this._defaultTemplates)
                            }, t = e, (n = [{
                                key: "anonymousTemplateName",
                                get: function() {
                                    return this._anonymousTemplateName
                                }
                            }]) && d(t.prototype, n), i, e
                        }();
                    t.TemplateManager = h
                },
            93280:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/bindable_template.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.BindableTemplate = void 0;
                    var i = c(n( /*! ../renderer */ 68374)),
                        a = n( /*! ./template_base */ 81033),
                        o = c(n( /*! ../../events/core/events_engine */ 55994)),
                        r = n( /*! ../remove_event */ 37819),
                        s = n( /*! ../utils/type */ 35922);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function l(e, t) {
                        return l = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, l(e, t)
                    }
                    var d = function(e) {
                        var t, n;

                        function a(t, n, i, a) {
                            var o;
                            return (o = e.call(this) || this)._render = t, o._fields = n, o._fieldsMap = a || {}, o._watchMethod = i, o
                        }
                        return n = e, (t = a).prototype = Object.create(n.prototype), t.prototype.constructor = t, l(t, n), a.prototype._renderCore = function(e) {
                            var t = this,
                                n = (0, i.default)(e.container),
                                a = function(e, t, n, i, a) {
                                    var o, r = function(e, t, n) {
                                        return t((function() {
                                            return e
                                        }), n)
                                    }(e, t, (function(e) {
                                        o && o(), (0, s.isPrimitive)(e) ? a(e) : o = function(e, t, n, i, a) {
                                            var o = {},
                                                r = n.slice(),
                                                s = n.map((function(n) {
                                                    var s = i[n];
                                                    return t(s ? function() {
                                                        return s(e)
                                                    } : function() {
                                                        return e[n]
                                                    }, (function(e) {
                                                        if (o[n] = e, r.length) {
                                                            var t = r.indexOf(n);
                                                            t >= 0 && r.splice(t, 1)
                                                        }
                                                        r.length || a(o)
                                                    }))
                                                }));
                                            return function() {
                                                s.forEach((function(e) {
                                                    return e()
                                                }))
                                            }
                                        }(e, t, n, i, a)
                                    }));
                                    return function() {
                                        o && o(), r && r()
                                    }
                                }(e.model, this._watchMethod, this._fields, this._fieldsMap, (function(i) {
                                    n.empty(), t._render(n, i, e.model)
                                }));
                            return o.default.on(n, r.removeEvent, a), n.contents()
                        }, a
                    }(a.TemplateBase);
                    t.BindableTemplate = d
                },
            91627:
                /*!**************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/child_default_template.js ***!
                  \**************************************************************************************/
                function(e, t, n) {
                    function i(e, t) {
                        return i = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, i(e, t)
                    }
                    t.ChildDefaultTemplate = void 0;
                    var a = function(e) {
                        var t, n;

                        function a(t) {
                            var n;
                            return (n = e.call(this) || this).name = t, n
                        }
                        return n = e, (t = a).prototype = Object.create(n.prototype), t.prototype.constructor = t, i(t, n), a
                    }(n( /*! ./template_base */ 81033).TemplateBase);
                    t.ChildDefaultTemplate = a
                },
            10688:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/empty_template.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.EmptyTemplate = void 0;
                    var i, a = (i = n( /*! ../renderer */ 68374)) && i.__esModule ? i : {
                        default: i
                    };

                    function o(e, t) {
                        return o = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, o(e, t)
                    }
                    var r = function(e) {
                        var t, n;

                        function i() {
                            return e.apply(this, arguments) || this
                        }
                        return n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, o(t, n), i.prototype._renderCore = function() {
                            return (0, a.default)()
                        }, i
                    }(n( /*! ./template_base */ 81033).TemplateBase);
                    t.EmptyTemplate = r
                },
            68494:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/function_template.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.FunctionTemplate = void 0;
                    var i = n( /*! ./template_base */ 81033),
                        a = n( /*! ../utils/dom */ 3532);

                    function o(e, t) {
                        return o = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, o(e, t)
                    }
                    var r = function(e) {
                        var t, n;

                        function i(t) {
                            var n;
                            return (n = e.call(this) || this)._render = t, n
                        }
                        return n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, o(t, n), i.prototype._renderCore = function(e) {
                            return (0, a.normalizeTemplateElement)(this._render(e))
                        }, i
                    }(i.TemplateBase);
                    t.FunctionTemplate = r
                },
            9545:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.Template = void 0;
                    var i, a = (i = n( /*! ../renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./template_base */ 81033),
                        r = n( /*! ../utils/dom */ 3532),
                        s = n( /*! ./template_engine_registry */ 72987);

                    function c(e, t) {
                        return c = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, c(e, t)
                    }
                    n( /*! ./template_engines */ 32468), (0, s.registerTemplateEngine)("default", {
                        compile: function(e) {
                            return (0, r.normalizeTemplateElement)(e)
                        },
                        render: function(e, t, n) {
                            return e.clone()
                        }
                    }), (0, s.setTemplateEngine)("default");
                    var l = function(e) {
                        var t, n;

                        function i(t) {
                            var n;
                            return (n = e.call(this) || this)._element = t, n
                        }
                        n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, c(t, n);
                        var o = i.prototype;
                        return o._renderCore = function(e) {
                            var t = e.transclude;
                            return t || this._compiledTemplate || (this._compiledTemplate = (0, s.getCurrentTemplateEngine)().compile(this._element)), (0, a.default)("<div>").append(t ? this._element : (0, s.getCurrentTemplateEngine)().render(this._compiledTemplate, e.model, e.index)).contents()
                        }, o.source = function() {
                            return (0, a.default)(this._element).clone()
                        }, i
                    }(o.TemplateBase);
                    t.Template = l
                },
            81033:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_base.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.renderedCallbacks = t.TemplateBase = void 0;
                    var i = l(n( /*! ../renderer */ 68374)),
                        a = l(n( /*! ../dom_adapter */ 73349)),
                        o = l(n( /*! ../utils/callbacks */ 44504)),
                        r = n( /*! ../utils/dom */ 3532),
                        s = n( /*! ../../events/visibility_change */ 80506),
                        c = l(n( /*! ../errors */ 17381));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = (0, o.default)({
                        syncStrategy: !0
                    });
                    t.renderedCallbacks = u;
                    var d = function() {
                        function e() {}
                        var t = e.prototype;
                        return t.render = function(e) {
                            var t = (e = e || {}).onRendered;
                            delete e.onRendered;
                            var n = this._renderCore(e);
                            return this._ensureResultInContainer(n, e.container), u.fire(n, e.container), t && t(), n
                        }, t._ensureResultInContainer = function(e, t) {
                            if (t) {
                                var n = (0, i.default)(t),
                                    o = (0, r.contains)(n.get(0), e.get(0));
                                if (n.append(e), !o) {
                                    a.default.getBody().contains(n.get(0)) && (0, s.triggerShownEvent)(e)
                                }
                            }
                        }, t._renderCore = function() {
                            throw c.default.Error("E0001")
                        }, e
                    }();
                    t.TemplateBase = d
                },
            72987:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engine_registry.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    t.getCurrentTemplateEngine = function() {
                        return r
                    }, t.registerTemplateEngine = function(e, t) {
                        s[e] = t
                    }, t.setTemplateEngine = function(e) {
                        if ((0, a.isString)(e)) {
                            if (!(r = s[e])) {
                                throw o.default.Error("E0020", e)
                            }
                        } else {
                            r = e
                        }
                    };
                    var i, a = n( /*! ../utils/type */ 35922),
                        o = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var r, s = {}
                },
            32468:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engines.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    var i = n( /*! ../utils/dom */ 3532),
                        a = n( /*! ./template_engine_registry */ 72987);
                    (0, a.registerTemplateEngine)("jquery-tmpl", {
                        compile: function(e) {
                            return (0, i.extractTemplateMarkup)(e)
                        },
                        render: function(e, t) {
                            return jQuery.tmpl(e, t)
                        }
                    }), (0, a.registerTemplateEngine)("jsrender", {
                        compile: function(e) {
                            return (jQuery || jsrender).templates((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e.render(t)
                        }
                    }), (0, a.registerTemplateEngine)("mustache", {
                        compile: function(e) {
                            return (0, i.extractTemplateMarkup)(e)
                        },
                        render: function(e, t) {
                            return Mustache.render(e, t)
                        }
                    }), (0, a.registerTemplateEngine)("hogan", {
                        compile: function(e) {
                            return Hogan.compile((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e.render(t)
                        }
                    }), (0, a.registerTemplateEngine)("underscore", {
                        compile: function(e) {
                            return _.template((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    }), (0, a.registerTemplateEngine)("handlebars", {
                        compile: function(e) {
                            return Handlebars.compile((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    }), (0, a.registerTemplateEngine)("doT", {
                        compile: function(e) {
                            return doT.template((0, i.extractTemplateMarkup)(e))
                        },
                        render: function(e, t) {
                            return e(t)
                        }
                    })
                },
            37208:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/ajax.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./deferred */ 62754),
                        a = d(n( /*! ../../core/dom_adapter */ 73349)),
                        o = d(n( /*! ../../core/http_request */ 83448)),
                        r = n( /*! ../../core/utils/window */ 58201),
                        s = n( /*! ./extend */ 13306),
                        c = n( /*! ./type */ 35922),
                        l = d(n( /*! ../polyfills/promise */ 48136)),
                        u = d(n( /*! ./dependency_injector */ 20476));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f = (0, r.getWindow)(),
                        h = "success",
                        g = "error",
                        p = function(e) {
                            var t = a.default.createElement("script");
                            for (var n in e) {
                                t[n] = e[n]
                            }
                            return t
                        },
                        m = function(e) {
                            e.parentNode.removeChild(e)
                        },
                        _ = function(e) {
                            return a.default.getHead().appendChild(e)
                        },
                        v = function(e) {
                            var t = p({
                                text: e
                            });
                            _(t), m(t)
                        };

                    function y(e) {
                        return (e.method || "GET").toUpperCase()
                    }
                    var b = function(e) {
                            var t = e.headers || {};
                            return t["Content-Type"] = t["Content-Type"] || function(e) {
                                var t;
                                return e.data && !e.upload && "GET" !== y(e) && (t = "application/x-www-form-urlencoded;charset=utf-8"), e.contentType || t
                            }(e), t.Accept = t.Accept || function(e) {
                                var t = e.dataType || "*",
                                    n = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",
                                    i = {
                                        "*": "*/*",
                                        text: "text/plain",
                                        html: "text/html",
                                        xml: "application/xml, text/xml",
                                        json: "application/json, text/javascript",
                                        jsonp: n,
                                        script: n
                                    };
                                return (0, s.extendFromObject)(i, e.accepts, !0), i[t] ? i[t] + ("*" !== t ? ", */*; q=0.01" : "") : i["*"]
                            }(e), e.crossDomain || t["X-Requested-With"] || (t["X-Requested-With"] = "XMLHttpRequest"), t
                        },
                        w = (0, u.default)({
                            sendRequest: function(e) {
                                var t, n = o.default.getXhr(),
                                    s = new i.Deferred,
                                    u = s.promise(),
                                    d = !(0, c.isDefined)(e.async) || e.async,
                                    w = e.dataType,
                                    k = e.timeout || 0;
                                e.crossDomain = function(e) {
                                    if (!(0, r.hasWindow)()) {
                                        return !0
                                    }
                                    var t = !1,
                                        n = a.default.createElement("a"),
                                        i = a.default.createElement("a");
                                    n.href = f.location.href;
                                    try {
                                        i.href = e, i.href = i.href, t = n.protocol + "//" + n.host != i.protocol + "//" + i.host
                                    } catch (e) {
                                        t = !0
                                    }
                                    return t
                                }(e.url);
                                var S = "jsonp" === w || "script" === w;
                                void 0 === e.cache && (e.cache = !S);
                                var C = function(e) {
                                        if ("jsonp" === e.dataType) {
                                            var t = Math.random().toString().replace(/\D/g, ""),
                                                n = e.jsonpCallback || "dxCallback" + Date.now() + "_" + t,
                                                i = e.jsonp || "callback";
                                            return e.data = e.data || {}, e.data[i] = n, n
                                        }
                                    }(e),
                                    A = b(e),
                                    I = function(e, t) {
                                        var n = e.data,
                                            i = "string" == typeof n,
                                            a = e.url || f.location.href;
                                        return i || e.cache || ((n = n || {})._ = Date.now()), n && !e.upload && (i || (n = function(e) {
                                            var t = [];
                                            for (var n in e) {
                                                var i = e[n];
                                                void 0 !== i && (null === i && (i = ""), "function" == typeof i && (i = i()), t.push(encodeURIComponent(n) + "=" + encodeURIComponent(i)))
                                            }
                                            return t.join("&")
                                        }(n)), "GET" === y(e) ? ("" !== n && (a += (a.indexOf("?") > -1 ? "&" : "?") + n), n = null) : t["Content-Type"] && t["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1 && (n = n.replace(/%20/g, "+"))), {
                                            url: a,
                                            parameters: n
                                        }
                                    }(e, A),
                                    T = I.url,
                                    E = I.parameters;
                                if (C && (f[C] = function(e) {
                                        s.resolve(e, h, n)
                                    }), e.crossDomain && S) {
                                    return function(e) {
                                        var t = p({
                                            src: e
                                        });
                                        return new l.default((function(e, n) {
                                            var i = {
                                                    load: e,
                                                    error: n
                                                },
                                                o = function(e) {
                                                    i[e.type](), m(t)
                                                };
                                            for (var r in i) {
                                                a.default.listen(t, r, o)
                                            }
                                            _(t)
                                        }))
                                    }(T).then((function() {
                                        "jsonp" !== w && s.resolve(null, h, n)
                                    }), (function() {
                                        s.reject(n, g)
                                    })), u
                                }
                                if (e.crossDomain && !("withCredentials" in n)) {
                                    return s.reject(n, g), u
                                }
                                if (n.open(y(e), T, d, e.username, e.password), d && (n.timeout = k, t = function(e, t) {
                                        return e && setTimeout((function() {
                                            t.customStatus = "timeout", t.abort()
                                        }), e)
                                    }(k, n)), n.onreadystatechange = function(e) {
                                        var i;
                                        4 === n.readyState && (clearTimeout(t), 200 <= (i = n.status) && i < 300 ? function(e) {
                                            return 204 !== e
                                        }(n.status) ? function(e, t, n) {
                                            var i = function(e) {
                                                return e.responseType && "text" !== e.responseType || "string" != typeof e.responseText ? e.response : e.responseText
                                            }(t);
                                            switch (n) {
                                                case "jsonp":
                                                    v(i);
                                                    break;
                                                case "script":
                                                    v(i), e.resolve(i, h, t);
                                                    break;
                                                case "json":
                                                    try {
                                                        e.resolve(JSON.parse(i), h, t)
                                                    } catch (n) {
                                                        e.reject(t, "parsererror", n)
                                                    }
                                                    break;
                                                default:
                                                    e.resolve(i, h, t)
                                            }
                                        }(s, n, w) : s.resolve(null, "nocontent", n) : s.reject(n, n.customStatus || g))
                                    }, e.upload && (n.upload.onprogress = e.upload.onprogress, n.upload.onloadstart = e.upload.onloadstart, n.upload.onabort = e.upload.onabort), e.xhrFields) {
                                    for (var O in e.xhrFields) {
                                        n[O] = e.xhrFields[O]
                                    }
                                }
                                for (var D in "arraybuffer" === e.responseType && (n.responseType = e.responseType), A) {
                                    Object.prototype.hasOwnProperty.call(A, D) && (0, c.isDefined)(A[D]) && n.setRequestHeader(D, A[D])
                                }
                                return e.beforeSend && e.beforeSend(n), n.send(E), u.abort = function() {
                                    n.abort()
                                }, u
                            }
                        });
                    t.default = w, e.exports = t.default, e.exports.default = t.default
                },
            89386:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/array.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.wrapToArray = t.uniqueValues = t.removeDuplicates = t.normalizeIndexes = t.merge = t.isEmpty = t.intersection = t.inArray = t.groupBy = t.find = void 0;
                    var i, a = n( /*! ./type */ 35922),
                        o = n( /*! ./iterator */ 95479),
                        r = n( /*! ./object */ 48013),
                        s = (i = n( /*! ../config */ 80209)) && i.__esModule ? i : {
                            default: i
                        };

                    function c() {
                        return c = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, c.apply(this, arguments)
                    }

                    function l(e) {
                        return function(e) {
                            if (Array.isArray(e)) {
                                return u(e)
                            }
                        }(e) || function(e) {
                            if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                return Array.from(e)
                            }
                        }(e) || function(e, t) {
                            if (!e) {
                                return
                            }
                            if ("string" == typeof e) {
                                return u(e, t)
                            }
                            var n = Object.prototype.toString.call(e).slice(8, -1);
                            "Object" === n && e.constructor && (n = e.constructor.name);
                            if ("Map" === n || "Set" === n) {
                                return Array.from(e)
                            }
                            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                return u(e, t)
                            }
                        }(e) || function() {
                            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                        }()
                    }

                    function u(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    t.isEmpty = function(e) {
                        return Array.isArray(e) && !e.length
                    };
                    t.wrapToArray = function(e) {
                        return Array.isArray(e) ? e : [e]
                    };
                    var d = function(e, t) {
                        return t ? (Array.isArray(t) ? t : t.toArray()).indexOf(e) : -1
                    };
                    t.inArray = d;
                    t.intersection = function(e, t) {
                        if (!Array.isArray(e) || 0 === e.length || !Array.isArray(t) || 0 === t.length) {
                            return []
                        }
                        var n = [];
                        return (0, o.each)(e, (function(e, i) {
                            -1 !== d(i, t) && n.push(i)
                        })), n
                    };
                    t.uniqueValues = function(e) {
                        return l(new Set(e))
                    };
                    t.removeDuplicates = function(e, t) {
                        if (!Array.isArray(e) || 0 === e.length) {
                            return []
                        }
                        var n = e.slice();
                        return Array.isArray(t) && 0 !== t.length ? ((0, o.each)(t, (function(e, t) {
                            var i = d(t, n);
                            n.splice(i, 1)
                        })), n) : n
                    };
                    t.normalizeIndexes = function(e, t, n, i) {
                        var c = {},
                            l = 0,
                            u = (0, s.default)().useLegacyVisibleIndex;
                        return (0, o.each)(e, (function(e, i) {
                            (e = i[t]) >= 0 ? (c[e] = c[e] || [], i === n ? c[e].unshift(i) : c[e].push(i)) : i[t] = void 0
                        })), u || (0, o.each)(e, (function() {
                            if (!(0, a.isDefined)(this[t]) && (!i || i(this))) {
                                for (; c[l];) {
                                    l++
                                }
                                c[l] = [this], l++
                            }
                        })), l = 0, (0, r.orderEach)(c, (function(e, n) {
                            (0, o.each)(n, (function() {
                                e >= 0 && (this[t] = l++)
                            }))
                        })), u && (0, o.each)(e, (function() {
                            (0, a.isDefined)(this[t]) || i && !i(this) || (this[t] = l++)
                        })), l
                    };
                    t.merge = function(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            e[e.length] = t[n]
                        }
                        return e
                    };
                    t.find = function(e, t) {
                        for (var n = 0; n < e.length; n++) {
                            if (t(e[n])) {
                                return e[n]
                            }
                        }
                    };
                    t.groupBy = function(e, t) {
                        return e.reduce((function(e, n) {
                            return c({}, e, function(e, t, n) {
                                return t in e ? Object.defineProperty(e, t, {
                                    value: n,
                                    enumerable: !0,
                                    configurable: !0,
                                    writable: !0
                                }) : e[t] = n, e
                            }({}, t(n), [].concat(l(e[t(n)] || []), [n])))
                        }), {})
                    }
                },
            34671:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/array_compare.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.isKeysEqual = t.findChanges = void 0;
                    var i = n( /*! ./type */ 35922),
                        a = function(e, t) {
                            var n = t(e);
                            if ((0, i.isObject)(n)) {
                                try {
                                    return JSON.stringify(n)
                                } catch (e) {
                                    return n
                                }
                            }
                            return n
                        },
                        o = function(e, t, n, i) {
                            return t[n[a(e, i)]]
                        };
                    t.isKeysEqual = function(e, t) {
                        if (e.length !== t.length) {
                            return !1
                        }
                        for (var n = 0; n < t.length; n++) {
                            if (e[n] !== t[n]) {
                                return !1
                            }
                        }
                        return !0
                    };
                    t.findChanges = function(e, t, n, i) {
                        var r = {},
                            s = {},
                            c = 0,
                            l = 0,
                            u = [];
                        e.forEach((function(e, t) {
                            var i = a(e, n);
                            r[i] = t
                        })), t.forEach((function(e, t) {
                            var i = a(e, n);
                            s[i] = t
                        }));
                        for (var d = Math.max(e.length, t.length), f = 0; f < d + c; f++) {
                            var h = t[f],
                                g = f - c + l,
                                p = e[g];
                            if (!h || p && !o(p, t, s, n)) {
                                p && (u.push({
                                    type: "remove",
                                    key: n(p),
                                    index: f,
                                    oldItem: p
                                }), l++, f--)
                            } else {
                                var m = a(h, n),
                                    _ = r[m],
                                    v = e[_];
                                if (v) {
                                    if (_ !== g) {
                                        return
                                    }
                                    i(v, h) || u.push({
                                        type: "update",
                                        data: h,
                                        key: n(h),
                                        index: f,
                                        oldItem: v
                                    })
                                } else {
                                    c++, u.push({
                                        type: "insert",
                                        data: h,
                                        index: f
                                    })
                                }
                            }
                        }
                        return u
                    }
                },
            47810:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/browser.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./extend */ 13306),
                        a = (0, n( /*! ./window */ 58201).getNavigator)(),
                        o = /(webkit)[ /]([\w.]+)/,
                        r = /(mozilla)(?:.*? rv:([\w.]+))/,
                        s = function(e) {
                            e = e.toLowerCase();
                            var t = {},
                                n = o.exec(e) || e.indexOf("compatible") < 0 && r.exec(e) || [],
                                i = n[1],
                                a = n[2];
                            return "webkit" === i && (t.webkit = !0, e.indexOf("chrome") >= 0 || e.indexOf("crios") >= 0 ? (i = "chrome", a = (a = /(?:chrome|crios)\/(\d+\.\d+)/.exec(e)) && a[1]) : e.indexOf("fxios") >= 0 ? (i = "mozilla", a = (a = /fxios\/(\d+\.\d+)/.exec(e)) && a[1]) : e.indexOf("safari") >= 0 && /version|phantomjs/.test(e) ? (i = "safari", a = (a = /(?:version|phantomjs)\/([0-9.]+)/.exec(e)) && a[1]) : (i = "unknown", a = (a = /applewebkit\/([0-9.]+)/.exec(e)) && a[1])), i && (t[i] = !0, t.version = a), t
                        },
                        c = (0, i.extend)({
                            _fromUA: s
                        }, s(a.userAgent));
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            39618:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/call_once.js ***!
                  \*********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = function(e) {
                        var t, n = function() {
                            return t = e.apply(this, arguments), n = function() {
                                return t
                            }, t
                        };
                        return function() {
                            return n.apply(this, arguments)
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            44504:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/callbacks.js ***!
                  \*********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    var n = function(e) {
                        this._options = e || {}, this._list = [], this._queue = [], this._firing = !1, this._fired = !1, this._firingIndexes = []
                    };
                    n.prototype._fireCore = function(e, t) {
                        var n = this._firingIndexes,
                            i = this._list,
                            a = this._options.stopOnFalse,
                            o = n.length;
                        for (n[o] = 0; n[o] < i.length; n[o]++) {
                            if (!1 === i[n[o]].apply(e, t) && a) {
                                break
                            }
                        }
                        n.pop()
                    }, n.prototype.add = function(e) {
                        return "function" != typeof e || this._options.unique && this.has(e) || this._list.push(e), this
                    }, n.prototype.remove = function(e) {
                        var t = this._list,
                            n = this._firingIndexes,
                            i = t.indexOf(e);
                        if (i > -1 && (t.splice(i, 1), this._firing && n.length)) {
                            for (var a = 0; a < n.length; a++) {
                                i <= n[a] && n[a]--
                            }
                        }
                        return this
                    }, n.prototype.has = function(e) {
                        var t = this._list;
                        return e ? t.indexOf(e) > -1 : !!t.length
                    }, n.prototype.empty = function(e) {
                        return this._list = [], this
                    }, n.prototype.fireWith = function(e, t) {
                        var n = this._queue;
                        if (t = (t = t || []).slice ? t.slice() : t, this._options.syncStrategy) {
                            this._firing = !0, this._fireCore(e, t)
                        } else {
                            if (n.push([e, t]), this._firing) {
                                return
                            }
                            for (this._firing = !0; n.length;) {
                                var i = n.shift();
                                this._fireCore(i[0], i[1])
                            }
                        }
                        return this._firing = !1, this._fired = !0, this
                    }, n.prototype.fire = function() {
                        this.fireWith(this, arguments)
                    }, n.prototype.fired = function() {
                        return this._fired
                    };
                    t.default = function(e) {
                        return new n(e)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            20576:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/common.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.splitPair = t.pairToObject = t.normalizeKey = t.noop = t.grep = t.getKeyHash = t.findBestMatches = t.executeAsync = t.escapeRegExp = t.equalByValue = t.ensureDefined = t.denormalizeKey = t.deferUpdater = t.deferUpdate = t.deferRenderer = t.deferRender = t.asyncNoop = t.applyServerDecimalSeparator = void 0;
                    var i = l(n( /*! ../config */ 80209)),
                        a = l(n( /*! ../guid */ 73176)),
                        o = n( /*! ../utils/deferred */ 62754),
                        r = n( /*! ./data */ 47617),
                        s = n( /*! ./iterator */ 95479),
                        c = n( /*! ./type */ 35922);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.ensureDefined = function(e, t) {
                        return (0, c.isDefined)(e) ? e : t
                    };
                    t.executeAsync = function(e, t) {
                        var n = new o.Deferred,
                            i = t || this,
                            a = {
                                promise: n.promise(),
                                abort: function() {
                                    clearTimeout(s), n.rejectWith(i)
                                }
                            },
                            r = function() {
                                var t = e.call(i);
                                t && t.done && (0, c.isFunction)(t.done) ? t.done((function() {
                                    n.resolveWith(i)
                                })) : n.resolveWith(i)
                            },
                            s = (arguments[2] || setTimeout)(r, "number" == typeof t ? t : 0);
                        return a
                    };
                    var u, d = [],
                        f = [],
                        h = [],
                        g = function(e, t, n) {
                            if (u && u !== e) {
                                return d.push(t), f.push(e), n = n || new o.Deferred, h.push(n), n
                            }
                            var i = u,
                                a = h.length;
                            u = e;
                            var r = t();
                            return r || (h.length > a ? r = o.when.apply(this, h.slice(a)) : n && n.resolve()), u = i, n && r && r.done && r.done(n.resolve).fail(n.reject), !u && d.length && ("render" === f.shift() ? p : m)(d.shift(), h.shift()), r || (0, o.when)()
                        },
                        p = function(e, t) {
                            return g("render", e, t)
                        };
                    t.deferRender = p;
                    var m = function(e, t) {
                        return g("update", e, t)
                    };
                    t.deferUpdate = m;
                    t.deferRenderer = function(e) {
                        return function() {
                            var t = this;
                            return g("render", (function() {
                                return e.call(t)
                            }))
                        }
                    };
                    t.deferUpdater = function(e) {
                        return function() {
                            var t = this;
                            return g("update", (function() {
                                return e.call(t)
                            }))
                        }
                    };
                    t.findBestMatches = function(e, t, n) {
                        var i = [],
                            a = 0;
                        return (0, s.each)(t, (function(t, o) {
                            var r = 0,
                                c = n ? n(o) : o;
                            (0, s.each)(e, (function(e, t) {
                                var n = c[e];
                                if (void 0 !== n) {
                                    if (!_(n, t)) {
                                        return r = -1, !1
                                    }
                                    r++
                                }
                            })), r < a || (r > a && (i.length = 0, a = r), i.push(o))
                        })), i
                    };
                    var _ = function(e, t) {
                            if (Array.isArray(e) && Array.isArray(t)) {
                                var n = !1;
                                return (0, s.each)(e, (function(e, i) {
                                    if (i !== t[e]) {
                                        return n = !0, !1
                                    }
                                })), !n
                            }
                            return e === t
                        },
                        v = function(e) {
                            var t, n;
                            switch ((0, c.type)(e)) {
                                case "string":
                                    return e.split(/\s+/, 2);
                                case "object":
                                    return [null !== (t = e.x) && void 0 !== t ? t : e.h, null !== (n = e.y) && void 0 !== n ? n : e.v];
                                case "number":
                                    return [e];
                                case "array":
                                    return e;
                                default:
                                    return null
                            }
                        };
                    t.splitPair = v;
                    t.normalizeKey = function(e) {
                        var t = (0, c.isString)(e) ? e : e.toString(),
                            n = t.match(/[^a-zA-Z0-9_]/g);
                        return n && (0, s.each)(n, (function(e, n) {
                            t = t.replace(n, "__" + n.charCodeAt() + "__")
                        })), t
                    };
                    t.denormalizeKey = function(e) {
                        var t = e.match(/__\d+__/g);
                        return t && t.forEach((function(t) {
                            var n = parseInt(t.replace("__", ""));
                            e = e.replace(t, String.fromCharCode(n))
                        })), e
                    };
                    t.pairToObject = function(e, t) {
                        var n = v(e),
                            i = t ? parseFloat(n && n[0]) : parseInt(n && n[0], 10),
                            a = t ? parseFloat(n && n[1]) : parseInt(n && n[1], 10);
                        return isFinite(i) || (i = 0), isFinite(a) || (a = i), {
                            h: i,
                            v: a
                        }
                    };
                    t.getKeyHash = function(e) {
                        if (e instanceof a.default) {
                            return e.toString()
                        }
                        if ((0, c.isObject)(e) || Array.isArray(e)) {
                            try {
                                var t = JSON.stringify(e);
                                return "{}" === t ? e : t
                            } catch (t) {
                                return e
                            }
                        }
                        return e
                    };
                    t.escapeRegExp = function(e) {
                        return e.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
                    };
                    t.applyServerDecimalSeparator = function(e) {
                        var t = (0, i.default)().serverDecimalSeparator;
                        return (0, c.isDefined)(e) && (e = e.toString().replace(".", t)), e
                    };
                    t.noop = function() {};
                    t.asyncNoop = function() {
                        return (new o.Deferred).resolve().promise()
                    };
                    t.grep = function(e, t, n) {
                        for (var i = [], a = !n, o = 0; o < e.length; o++) {
                            !!t(e[o], o) === a && i.push(e[o])
                        }
                        return i
                    };
                    var x = function(e, t, n) {
                            if (e.length !== t.length) {
                                return !1
                            }
                            for (var i = 0; i < e.length; i++) {
                                if (!b(e[i], t[i], n + 1)) {
                                    return !1
                                }
                            }
                            return !0
                        },
                        y = function(e, t, n, i) {
                            for (var a in e) {
                                if (Object.prototype.hasOwnProperty.call(e, a) && !b(e[a], t[a], n + 1, i)) {
                                    return !1
                                }
                            }
                            for (var o in t) {
                                if (!(o in e)) {
                                    return !1
                                }
                            }
                            return !0
                        },
                        b = function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0,
                                i = !(arguments.length > 3 && void 0 !== arguments[3]) || arguments[3];
                            e = (0, r.toComparable)(e, !0), t = (0, r.toComparable)(t, !0);
                            var a = i ? e === t : e == t;
                            return !!(a || n >= 3) || ((0, c.isObject)(e) && (0, c.isObject)(t) ? y(e, t, n, i) : !(!Array.isArray(e) || !Array.isArray(t)) && x(e, t, n))
                        };
                    t.equalByValue = b
                },
            49036:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/comparator.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.equals = void 0;
                    var i, a = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ./data */ 47617),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return s = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, s(e)
                    }
                    t.equals = function(e, t) {
                        return e = (0, o.toComparable)(e, !0), t = (0, o.toComparable)(t, !0), e && t && (0, r.isRenderer)(e) && (0, r.isRenderer)(t) ? t.is(e) : !(e == e || t == t) || (0 === e && 0 === t ? function(e, t) {
                            return 1 / e == 1 / t
                        }(e, t) : !(null !== e && "object" === s(e) && !a.default.isElementNode(e)) && e === t)
                    }
                },
            30869:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/console.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.logger = t.debug = void 0;
                    var i = n( /*! ./type */ 35922),
                        a = function() {},
                        o = function(e) {
                            return "undefined" != typeof console && (0, i.isFunction)(console[e]) ? console[e].bind(console) : a
                        },
                        r = {
                            info: o("info"),
                            warn: o("warn"),
                            error: o("error")
                        };
                    t.logger = r;
                    var s = function() {
                        function e(e, t) {
                            if (!e) {
                                throw new Error(t)
                            }
                        }
                        return {
                            assert: e,
                            assertParam: function(t, n) {
                                e(null != t, n)
                            }
                        }
                    }();
                    t.debug = s
                },
            47617:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/data.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.toComparable = t.getPathParts = t.compileSetter = t.compileGetter = void 0;
                    var i = l(n( /*! ../errors */ 17381)),
                        a = l(n( /*! ../class */ 38377)),
                        o = n( /*! ./object */ 48013),
                        r = n( /*! ./type */ 35922),
                        s = n( /*! ./iterator */ 95479),
                        c = l(n( /*! ./variable_wrapper */ 26974));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = c.default.unwrap,
                        d = c.default.isWrapped,
                        f = c.default.assign,
                        h = function(e) {
                            return (t = e, t.replace(/\[/g, ".").replace(/\]/g, "")).split(".");
                            var t
                        };
                    t.getPathParts = h;
                    var g = function(e, t, n, a) {
                            if ("this" === t) {
                                throw new i.default.Error("E4016")
                            }
                            var o = e[t];
                            a.unwrapObservables && d(o) ? f(o, n) : e[t] = n
                        },
                        p = function(e) {
                            return (e = e || {}).unwrapObservables = void 0 === e.unwrapObservables || e.unwrapObservables, e
                        };

                    function m(e, t) {
                        return t.unwrapObservables ? u(e) : e
                    }
                    var _ = function(e) {
                        if (arguments.length > 1 && (e = [].slice.call(arguments)), !e || "this" === e) {
                            return function(e) {
                                return e
                            }
                        }
                        if ("string" == typeof e) {
                            var t = h(e);
                            return function(e, n) {
                                for (var i = (n = p(n)).functionsAsIs, a = ("defaultValue" in n), o = m(e, n), s = 0; s < t.length; s++) {
                                    if (!o) {
                                        if (null == o && a) {
                                            return n.defaultValue
                                        }
                                        break
                                    }
                                    var c = t[s];
                                    if (a && (0, r.isObject)(o) && !(c in o)) {
                                        return n.defaultValue
                                    }
                                    var l = m(o[c], n);
                                    !i && (0, r.isFunction)(l) && (l = l.call(o)), o = l
                                }
                                return o
                            }
                        }
                        return Array.isArray(e) ? v(e) : (0, r.isFunction)(e) ? e : void 0
                    };

                    function v(e) {
                        for (var t = {}, n = 0, i = e.length; n < i; n++) {
                            var a = e[n];
                            t[a] = _(a)
                        }
                        return function(e, n) {
                            var i;
                            return (0, s.each)(t, (function(t) {
                                var a = this(e, n);
                                if (void 0 !== a) {
                                    for (var o = i || (i = {}), r = t.split("."), s = r.length - 1, c = 0; c < s; c++) {
                                        var l = r[c];
                                        l in o || (o[l] = {}), o = o[l]
                                    }
                                    o[r[s]] = a
                                }
                            })), i
                        }
                    }
                    t.compileGetter = _;
                    var x = function(e, t, n, i) {
                        if ((0, r.isDefined)(n)) {
                            return n
                        }
                        var a = {};
                        return g(e, t, a, i), a
                    };
                    t.compileSetter = function(e) {
                        var t = (e = h(e || "this")).length - 1;
                        return function(n, i, a) {
                            var s = m(n, a = p(a));
                            e.forEach((function(e, n) {
                                var c = function(e, t, n) {
                                        return n = n || {}, m("this" === t ? e : e[t], n)
                                    }(s, e, a),
                                    l = !a.functionsAsIs && (0, r.isFunction)(c) && !d(c);
                                n === t ? a.merge && (0, r.isPlainObject)(i) && (!(0, r.isDefined)(c) || (0, r.isPlainObject)(c)) ? (c = x(s, e, c, a), (0, o.deepExtendArraySafe)(c, i, !1, !0)) : l ? s[e](i) : g(s, e, i, a) : (c = x(s, e, c, a), l && (c = c.call(s)), s = c)
                            }))
                        }
                    };
                    t.toComparable = function(e, t) {
                        return e instanceof Date ? e.getTime() : e && e instanceof a.default && e.valueOf ? e.valueOf() : t || "string" != typeof e ? e : e.toLowerCase()
                    }
                },
            91198:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/date.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./type */ 35922),
                        a = n( /*! ./math */ 60810),
                        o = n( /*! ./iterator */ 95479),
                        r = n( /*! ./inflector */ 78008);

                    function s(e, t, n) {
                        return s = c() ? Reflect.construct : function(e, t, n) {
                            var i = [null];
                            i.push.apply(i, t);
                            var a = new(Function.bind.apply(e, i));
                            return n && l(a, n.prototype), a
                        }, s.apply(null, arguments)
                    }

                    function c() {
                        if ("undefined" == typeof Reflect || !Reflect.construct) {
                            return !1
                        }
                        if (Reflect.construct.sham) {
                            return !1
                        }
                        if ("function" == typeof Proxy) {
                            return !0
                        }
                        try {
                            return Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], (function() {}))), !0
                        } catch (e) {
                            return !1
                        }
                    }

                    function l(e, t) {
                        return l = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, l(e, t)
                    }
                    var u = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"],
                        d = function e(t) {
                            switch (t) {
                                case "millisecond":
                                    return 1;
                                case "second":
                                    return 1e3 * e("millisecond");
                                case "minute":
                                    return 60 * e("second");
                                case "hour":
                                    return 60 * e("minute");
                                case "day":
                                    return 24 * e("hour");
                                case "week":
                                    return 7 * e("day");
                                case "month":
                                    return 30 * e("day");
                                case "quarter":
                                    return 3 * e("month");
                                case "year":
                                    return 365 * e("day");
                                default:
                                    return 0
                            }
                        },
                        f = function(e) {
                            var t, n, i, a = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                                o = {};
                            for (t = a.length - 1; t >= 0; t--) {
                                i = a[t], (n = Math.floor(e / d(i))) > 0 && (o[i + "s"] = n, e -= h(i, n))
                            }
                            return o
                        };

                    function h(e, t) {
                        return d(e) * t
                    }

                    function g(e) {
                        var t, n = -1;
                        return (0, i.isString)(e) ? e : (0, i.isObject)(e) ? ((0, o.each)(e, (function(e, i) {
                            for (t = 0; t < u.length; t++) {
                                i && (e === u[t] + "s" || e === u[t]) && n < t && (n = t)
                            }
                        })), u[n]) : ""
                    }
                    var p = {
                        millisecond: "millisecond",
                        second: "longtime",
                        minute: "shorttime",
                        hour: "shorttime",
                        day: "day",
                        week: "day",
                        month: "month",
                        quarter: "quarter",
                        year: "year"
                    };
                    var m = function(e) {
                            return Math.floor(e / 3)
                        },
                        _ = function(e) {
                            return 3 * m(e)
                        };

                    function v(e, t, n, i) {
                        e = new Date(e.getTime());
                        var a, o, r = new Date(e.getTime()),
                            s = g(t);
                        switch (s) {
                            case "second":
                                e = new Date(1e3 * Math.floor(r.getTime() / 1e3));
                                break;
                            case "minute":
                                e = new Date(6e4 * Math.floor(r.getTime() / 6e4));
                                break;
                            case "hour":
                                e = new Date(36e5 * Math.floor(r.getTime() / 36e5));
                                break;
                            case "year":
                                e.setMonth(0);
                            case "month":
                                e.setDate(1);
                            case "day":
                                e.setHours(0, 0, 0, 0);
                                break;
                            case "week":
                                (e = T(e, i || 0)).setHours(0, 0, 0, 0);
                                break;
                            case "quarter":
                                a = _(e.getMonth()), o = e.getMonth(), e.setDate(1), e.setHours(0, 0, 0, 0), o !== a && e.setMonth(a)
                        }
                        return n && "hour" !== s && "minute" !== s && "second" !== s && O(r, e), e
                    }

                    function x(e) {
                        return v(e, "day")
                    }

                    function y(e, t, n) {
                        var a = new Date(e.getTime()),
                            o = (0, i.isString)(t) ? k(t.toLowerCase()) : (0, i.isNumeric)(t) ? f(t) : t;
                        return o.years && a.setFullYear(a.getFullYear() + o.years * n), o.quarters && a.setMonth(a.getMonth() + 3 * o.quarters * n), o.months && a.setMonth(a.getMonth() + o.months * n), o.weeks && a.setDate(a.getDate() + 7 * o.weeks * n), o.days && a.setDate(a.getDate() + o.days * n), o.hours && a.setTime(a.getTime() + 36e5 * o.hours * n), o.minutes && a.setTime(a.getTime() + 6e4 * o.minutes * n), o.seconds && a.setTime(a.getTime() + 1e3 * o.seconds * n), o.milliseconds && a.setTime(a.getTime() + o.milliseconds * n), a
                    }
                    var b = function(e, t, n) {
                        var o = n ? -1 : 1;
                        return (0, i.isDate)(e) ? y(e, t, o) : (0, a.adjust)(e + t * o, t)
                    };

                    function w(e) {
                        return M(e.getFullYear(), e.getMonth() + 1, 0).getDate()
                    }

                    function k(e) {
                        var t = {};
                        switch (e) {
                            case "year":
                                t.years = 1;
                                break;
                            case "month":
                                t.months = 1;
                                break;
                            case "quarter":
                                t.months = 3;
                                break;
                            case "week":
                                t.weeks = 1;
                                break;
                            case "day":
                                t.days = 1;
                                break;
                            case "hour":
                                t.hours = 1;
                                break;
                            case "minute":
                                t.minutes = 1;
                                break;
                            case "second":
                                t.seconds = 1;
                                break;
                            case "millisecond":
                                t.milliseconds = 1
                        }
                        return t
                    }

                    function S(e, t) {
                        return C(e, t) && e.getMonth() === t.getMonth()
                    }

                    function C(e, t) {
                        return e && t && e.getFullYear() === t.getFullYear()
                    }

                    function A(e) {
                        return e && e.getFullYear() - e.getFullYear() % 100
                    }

                    function I(e) {
                        return e && e.getFullYear() - e.getFullYear() % 10
                    }

                    function T(e, t) {
                        var n = (e.getDay() - t + 7) % 7,
                            i = new Date(e);
                        return i.setDate(e.getDate() - n), i
                    }

                    function E(e, t, n) {
                        var a = e;
                        return (0, i.isDefined)(e) ? ((0, i.isDefined)(t) && e < t && (a = t), (0, i.isDefined)(n) && e > n && (a = n), a) : e
                    }

                    function O(e, t) {
                        if ((0, i.isDefined)(e)) {
                            var n = t.getHours() - e.getHours();
                            if (0 !== n) {
                                var a = 1 === n || -23 === n ? -1 : 1,
                                    o = new Date(t.getTime() + 36e5 * a);
                                (a > 0 || o.getDate() === t.getDate()) && t.setTime(o.getTime())
                            }
                        }
                    }

                    function D(e, t) {
                        return 60 * (t.getTimezoneOffset() - e.getTimezoneOffset()) * 1e3
                    }
                    var M = function(e) {
                            var t = s(Date, Array.prototype.slice.call(arguments));
                            return t.setFullYear(e), t
                        },
                        P = {
                            dateUnitIntervals: u,
                            convertMillisecondsToDateUnits: f,
                            dateToMilliseconds: function(e) {
                                var t = 0;
                                return (0, i.isObject)(e) && (0, o.each)(e, (function(e, n) {
                                    t += h(e.substr(0, e.length - 1), n)
                                })), (0, i.isString)(e) && (t = h(e, 1)), t
                            },
                            getNextDateUnit: function(e, t) {
                                switch (g(e)) {
                                    case "millisecond":
                                        return "second";
                                    case "second":
                                        return "minute";
                                    case "minute":
                                        return "hour";
                                    case "hour":
                                        return "day";
                                    case "day":
                                        return t ? "week" : "month";
                                    case "week":
                                        return "month";
                                    case "month":
                                        return "quarter";
                                    case "quarter":
                                    case "year":
                                        return "year";
                                    default:
                                        return 0
                                }
                            },
                            convertDateUnitToMilliseconds: h,
                            getDateUnitInterval: g,
                            getDateFormatByTickInterval: function(e) {
                                return p[g(e)] || ""
                            },
                            getDatesDifferences: function(e, t) {
                                var n = 0,
                                    i = {
                                        year: e.getFullYear() !== t.getFullYear(),
                                        month: e.getMonth() !== t.getMonth(),
                                        day: e.getDate() !== t.getDate(),
                                        hour: e.getHours() !== t.getHours(),
                                        minute: e.getMinutes() !== t.getMinutes(),
                                        second: e.getSeconds() !== t.getSeconds(),
                                        millisecond: e.getMilliseconds() !== t.getMilliseconds()
                                    };
                                return (0, o.each)(i, (function(e, t) {
                                    t && n++
                                })), 0 === n && 0 !== D(e, t) && (i.hour = !0, n++), i.count = n, i
                            },
                            correctDateWithUnitBeginning: v,
                            trimTime: x,
                            setToDayEnd: function(e) {
                                var t = x(e);
                                return t.setDate(t.getDate() + 1), new Date(t.getTime() - 1)
                            },
                            roundDateByStartDayHour: function(e, t) {
                                var n = this.dateTimeFromDecimal(t),
                                    i = new Date(e);
                                return (e.getHours() === n.hours && e.getMinutes() < n.minutes || e.getHours() < n.hours) && i.setHours(n.hours, n.minutes, 0, 0), i
                            },
                            dateTimeFromDecimal: function(e) {
                                return {
                                    hours: Math.floor(e),
                                    minutes: e % 1 * 60
                                }
                            },
                            addDateInterval: y,
                            addInterval: b,
                            getSequenceByInterval: function(e, t, n) {
                                var a, o = [];
                                for (o.push((0, i.isDate)(e) ? new Date(e.getTime()) : e), a = e; a < t;) {
                                    a = b(a, n), o.push(a)
                                }
                                return o
                            },
                            getDateIntervalByString: k,
                            sameDate: function(e, t) {
                                return S(e, t) && e.getDate() === t.getDate()
                            },
                            sameMonthAndYear: S,
                            sameMonth: S,
                            sameYear: C,
                            sameDecade: function(e, t) {
                                if ((0, i.isDefined)(e) && (0, i.isDefined)(t)) {
                                    var n = e.getFullYear() - e.getFullYear() % 10,
                                        a = t.getFullYear() - t.getFullYear() % 10;
                                    return e && t && n === a
                                }
                            },
                            sameCentury: function(e, t) {
                                if ((0, i.isDefined)(e) && (0, i.isDefined)(t)) {
                                    var n = e.getFullYear() - e.getFullYear() % 100,
                                        a = t.getFullYear() - t.getFullYear() % 100;
                                    return e && t && n === a
                                }
                            },
                            getDifferenceInMonth: function(e) {
                                var t = 1;
                                return "year" === e && (t = 12), "decade" === e && (t = 120), "century" === e && (t = 1200), t
                            },
                            getDifferenceInMonthForCells: function(e) {
                                var t = 1;
                                return "decade" === e && (t = 12), "century" === e && (t = 120), t
                            },
                            getFirstYearInDecade: I,
                            getFirstDecadeInCentury: A,
                            getShortDateFormat: function() {
                                return "yyyy/MM/dd"
                            },
                            getViewFirstCellDate: function(e, t) {
                                return "month" === e ? M(t.getFullYear(), t.getMonth(), 1) : "year" === e ? M(t.getFullYear(), 0, t.getDate()) : "decade" === e ? M(I(t), t.getMonth(), t.getDate()) : "century" === e ? M(A(t), t.getMonth(), t.getDate()) : void 0
                            },
                            getViewLastCellDate: function(e, t) {
                                return "month" === e ? M(t.getFullYear(), t.getMonth(), w(t)) : "year" === e ? M(t.getFullYear(), 11, t.getDate()) : "decade" === e ? M(I(t) + 9, t.getMonth(), t.getDate()) : "century" === e ? M(A(t) + 90, t.getMonth(), t.getDate()) : void 0
                            },
                            getViewDown: function(e) {
                                switch (e) {
                                    case "century":
                                        return "decade";
                                    case "decade":
                                        return "year";
                                    case "year":
                                        return "month"
                                }
                            },
                            getViewUp: function(e) {
                                switch (e) {
                                    case "month":
                                        return "year";
                                    case "year":
                                        return "decade";
                                    case "decade":
                                        return "century"
                                }
                            },
                            getLastMonthDay: w,
                            getLastMonthDate: function(e) {
                                if ((0, i.isDefined)(e)) {
                                    return M(e.getFullYear(), e.getMonth() + 1, 0)
                                }
                            },
                            getFirstMonthDate: function(e) {
                                if ((0, i.isDefined)(e)) {
                                    return M(e.getFullYear(), e.getMonth(), 1)
                                }
                            },
                            getFirstWeekDate: T,
                            normalizeDateByWeek: function(e, t) {
                                var n = P.getDatesInterval(e, t, "day"),
                                    i = new Date(e);
                                return n >= 6 && (i = new Date(i.setDate(i.getDate() + 7))), i
                            },
                            getQuarter: m,
                            getFirstQuarterMonth: _,
                            dateInRange: function(e, t, n, i) {
                                return "date" === i && (t = t && P.correctDateWithUnitBeginning(t, "day"), n = n && P.correctDateWithUnitBeginning(n, "day"), e = e && P.correctDateWithUnitBeginning(e, "day")), E(e, t, n) === e
                            },
                            intervalsOverlap: function(e) {
                                var t = e.firstMin,
                                    n = e.firstMax,
                                    i = e.secondMin,
                                    a = e.secondMax;
                                return t <= i && i <= n || t > i && t < a || t < a && n > a
                            },
                            roundToHour: function(e) {
                                var t = new Date(e.getTime());
                                return t.setHours(t.getHours() + 1), t.setMinutes(0), t
                            },
                            normalizeDate: E,
                            getViewMinBoundaryDate: function(e, t) {
                                var n = M(t.getFullYear(), t.getMonth(), 1);
                                return "month" === e ? n : (n.setMonth(0), "year" === e || ("decade" === e && n.setFullYear(I(t)), "century" === e && n.setFullYear(A(t))), n)
                            },
                            getViewMaxBoundaryDate: function(e, t) {
                                var n = new Date(t);
                                return n.setDate(w(t)), "month" === e ? n : (n.setMonth(11), n.setDate(w(n)), "year" === e || ("decade" === e && n.setFullYear(I(t) + 9), "century" === e && n.setFullYear(A(t) + 99)), n)
                            },
                            fixTimezoneGap: O,
                            getTimezonesDifference: D,
                            makeDate: function(e) {
                                return new Date(e)
                            },
                            getDatesInterval: function(e, t, n) {
                                var i = t.getTime() - e.getTime(),
                                    a = d(n) || 1;
                                return Math.floor(i / a)
                            },
                            getDatesOfInterval: function(e, t, n) {
                                for (var i = [], a = new Date(e.getTime()); a < t;) {
                                    i.push(new Date(a.getTime())), a = this.addInterval(a, n)
                                }
                                return i
                            },
                            createDateWithFullYear: M,
                            sameView: function(e, t, n) {
                                return P[(0, r.camelize)("same " + e)](t, n)
                            }
                        },
                        R = P;
                    t.default = R, e.exports = t.default, e.exports.default = t.default
                },
            69434:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/date_serialization.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../config */ 80209)),
                        a = n( /*! ../../localization/ldml/date.formatter */ 40594),
                        o = s(n( /*! ../../localization/default_date_names */ 15564)),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "number",
                        l = "yyyy/MM/dd",
                        u = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,
                        d = /^(\d{2}):(\d{2})(:(\d{2}))?$/,
                        f = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"],
                        h = /^(\d{4})\/(\d{2})\/(\d{2})$/,
                        g = function(e, t) {
                            var n;
                            return (0, r.isString)(e) && !t && (n = function(e) {
                                var t = e.match(u);
                                if (!t) {
                                    return (t = e.match(d)) ? new Date(0, 0, 0, p(t[1]), p(t[2]), p(t[4])) : void 0
                                }
                                var n = p(t[1]),
                                    i = --t[3],
                                    a = t[5],
                                    o = 0,
                                    r = 0,
                                    s = function(e) {
                                        return n < 100 && e.setFullYear(n), e
                                    };
                                o = p(t[14]), r = p(t[16]), "-" === t[13] && (o = -o, r = -r);
                                var c = p(t[6]) - o,
                                    l = p(t[8]) - r,
                                    f = p(t[10]),
                                    h = (g = t[11], p(g = g || "") * Math.pow(10, 3 - g.length));
                                var g;
                                if (t[12]) {
                                    return s(new Date(Date.UTC(n, i, a, c, l, f, h)))
                                }
                                return s(new Date(n, i, a, c, l, f, h))
                            }(e)), n || function(e) {
                                var t = m(e) === l,
                                    n = !(0, r.isDate)(e) && Date.parse(e);
                                if (!n && t) {
                                    var i = e.match(h);
                                    if (i) {
                                        var a = new Date(p(i[1]), p(i[2]), p(i[3]));
                                        return a.setFullYear(p(i[1])), a.setMonth(p(i[2]) - 1), a.setDate(p(i[3])), a
                                    }
                                }
                                return (0, r.isNumeric)(n) ? new Date(n) : e
                            }(e)
                        };

                    function p(e) {
                        return +e || 0
                    }
                    var m = function(e) {
                            return "number" == typeof e ? c : (0, r.isString)(e) ? ((0, i.default)().forceIsoDateParsing && (t = function(e, t) {
                                var n = e.match(u),
                                    i = "";
                                if (!n) {
                                    return (n = e.match(d)) ? n[3] ? "HH:mm:ss" : "HH:mm" : void 0
                                }
                                for (var a = 1; a < f.length; a++) {
                                    n[a] && (i += f[a] || n[a])
                                }
                                return "Z" === n[12] && (i += "'Z'"), n[14] && (n[15] ? i += "xxx" : n[16] ? i += "xx" : i += "x"), i
                            }(e)), t || (e.indexOf(":") >= 0 ? "yyyy/MM/dd HH:mm:ss" : l)) : e ? null : void 0;
                            var t
                        },
                        _ = {
                            dateParser: g,
                            deserializeDate: function(e) {
                                return "number" == typeof e ? new Date(e) : g(e, !(0, i.default)().forceIsoDateParsing)
                            },
                            serializeDate: function(e, t) {
                                return t ? (0, r.isDate)(e) ? t === c ? e && e.valueOf ? e.valueOf() : null : (0, a.getFormatter)(t, o.default)(e) : null : e
                            },
                            getDateSerializationFormat: m
                        };
                    t.default = _, e.exports = t.default, e.exports.default = t.default
                },
            62754:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/deferred.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.Deferred = function() {
                        return new c
                    }, t.fromPromise = l, t.setStrategy = function(e) {
                        c = e.Deferred, u = e.when
                    }, t.when = function() {
                        return u.apply(this, arguments)
                    };
                    var i, a = n( /*! ../utils/type */ 35922),
                        o = n( /*! ../utils/extend */ 13306),
                        r = (i = n( /*! ../utils/callbacks */ 44504)) && i.__esModule ? i : {
                            default: i
                        };
                    var s = [{
                            method: "resolve",
                            handler: "done",
                            state: "resolved"
                        }, {
                            method: "reject",
                            handler: "fail",
                            state: "rejected"
                        }, {
                            method: "notify",
                            handler: "progress"
                        }],
                        c = function() {
                            var e = this;
                            this._state = "pending", this._promise = {}, s.forEach(function(t) {
                                var n = t.method;
                                this[n + "Callbacks"] = new r.default, this[n] = function() {
                                    return this[n + "With"](this._promise, arguments)
                                }.bind(this), this._promise[t.handler] = function(t) {
                                    if (!t) {
                                        return this
                                    }
                                    var i = e[n + "Callbacks"];
                                    return i.fired() ? t.apply(e[n + "Context"], e[n + "Args"]) : i.add(function(e, n) {
                                        t.apply(e, n)
                                    }.bind(this)), this
                                }
                            }.bind(this)), this._promise.always = function(e) {
                                return this.done(e).fail(e)
                            }, this._promise.catch = function(e) {
                                return this.then(null, e)
                            }, this._promise.then = function(e, t) {
                                var n = new c;
                                return ["done", "fail"].forEach(function(i) {
                                    var o = "done" === i ? e : t;
                                    this[i]((function() {
                                        if (o) {
                                            var e = o && o.apply(this, arguments);
                                            (0, a.isDeferred)(e) ? e.done(n.resolve).fail(n.reject): (0, a.isPromise)(e) ? e.then(n.resolve, n.reject) : n.resolve.apply(this, (0, a.isDefined)(e) ? [e] : arguments)
                                        } else {
                                            n["done" === i ? "resolve" : "reject"].apply(this, arguments)
                                        }
                                    }))
                                }.bind(this)), n.promise()
                            }, this._promise.state = function() {
                                return e._state
                            }, this._promise.promise = function(t) {
                                return t ? (0, o.extend)(t, e._promise) : e._promise
                            }, this._promise.promise(this)
                        };

                    function l(e, t) {
                        if ((0, a.isDeferred)(e)) {
                            return e
                        }
                        if ((0, a.isPromise)(e)) {
                            var n = new c;
                            return e.then((function() {
                                n.resolveWith.apply(n, [t].concat([
                                    [].slice.call(arguments)
                                ]))
                            }), (function() {
                                n.rejectWith.apply(n, [t].concat([
                                    [].slice.call(arguments)
                                ]))
                            })), n
                        }
                        return (new c).resolveWith(t, [e])
                    }
                    s.forEach((function(e) {
                        var t = e.method,
                            n = e.state;
                        c.prototype[t + "With"] = function(e, i) {
                            var a = this[t + "Callbacks"];
                            return "pending" === this.state() && (this[t + "Args"] = i, this[t + "Context"] = e, n && (this._state = n), a.fire(e, i)), this
                        }
                    }));
                    var u = function() {
                        if (1 === arguments.length) {
                            return l(arguments[0])
                        }
                        for (var e = [].slice.call(arguments), t = [], n = 0, i = new c, o = function(a) {
                                return function(o) {
                                    t[a] = this, e[a] = arguments.length > 1 ? [].slice.call(arguments) : o, ++n === e.length && i.resolveWith(t, e)
                                }
                            }, r = 0; r < e.length; r++) {
                            (0, a.isDeferred)(e[r]) ? e[r].promise().done(o(r)).fail(i.reject): n++
                        }
                        return n === e.length && i.resolveWith(t, e), i.promise()
                    }
                },
            20476:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/dependency_injector.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = function(e) {
                        var t = s.default.inherit(e),
                            n = t,
                            i = new n(e),
                            c = {},
                            l = function(t, n) {
                                (0, r.each)(t, (function(t) {
                                    (0, o.isFunction)(i[t]) ? !n && e[t] || (e[t] = function() {
                                        return i[t].apply(e, arguments)
                                    }): (n && (c[t] = e[t]), e[t] = i[t])
                                }))
                            };
                        return l(e, !0), e.inject = function(e) {
                            n = n.inherit(e), i = new n, l(e)
                        }, e.resetInjection = function() {
                            (0, a.extend)(e, c), n = t, i = new t
                        }, e
                    };
                    var i, a = n( /*! ./extend */ 13306),
                        o = n( /*! ./type */ 35922),
                        r = n( /*! ./iterator */ 95479),
                        s = (i = n( /*! ../class */ 38377)) && i.__esModule ? i : {
                            default: i
                        };
                    e.exports = t.default, e.exports.default = t.default
                },
            3532:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/dom.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.resetActiveElement = t.replaceWith = t.normalizeTemplateElement = t.insertBefore = t.extractTemplateMarkup = t.createTextElementHiddenCopy = t.contains = t.closestCommonParent = t.clipboardText = t.clearSelection = void 0;
                    var i = s(n( /*! ../../core/dom_adapter */ 73349)),
                        a = s(n( /*! ../../core/renderer */ 68374)),
                        o = n( /*! ./iterator */ 95479),
                        r = n( /*! ./type */ 35922);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = (0, n( /*! ./window */ 58201).getWindow)();
                    t.resetActiveElement = function() {
                        var e, t = i.default.getActiveElement();
                        t && t !== i.default.getBody() && (null === (e = t.blur) || void 0 === e || e.call(t))
                    };
                    t.clearSelection = function() {
                        var e = c.getSelection();
                        if (e && "Caret" !== e.type) {
                            if (e.empty) {
                                e.empty()
                            } else if (e.removeAllRanges) {
                                try {
                                    e.removeAllRanges()
                                } catch (e) {}
                            }
                        }
                    };
                    t.closestCommonParent = function(e, t) {
                        var n = (0, a.default)(e),
                            i = (0, a.default)(t);
                        if (n[0] === i[0]) {
                            return n[0]
                        }
                        for (var o = n.parents(), r = i.parents(), s = -Math.min(o.length, r.length); s < 0; s++) {
                            if (o.get(s) === r.get(s)) {
                                return o.get(s)
                            }
                        }
                    };
                    t.extractTemplateMarkup = function(e) {
                        var t = (e = (0, a.default)(e)).length && e.filter((function() {
                            var e = (0, a.default)(this);
                            return e.is("script[type]") && e.attr("type").indexOf("script") < 0
                        }));
                        return t.length ? t.eq(0).html() : (e = (0, a.default)("<div>").append(e)).html()
                    };
                    t.normalizeTemplateElement = function e(t) {
                        var n = (0, r.isDefined)(t) && (t.nodeType || (0, r.isRenderer)(t)) ? (0, a.default)(t) : (0, a.default)("<div>").html(t).contents();
                        return 1 === n.length && (n.is("script") ? n = e(n.html().trim()) : n.is("table") && (n = n.children("tbody").contents())), n
                    };
                    t.clipboardText = function(e, t) {
                        var n = e.originalEvent && e.originalEvent.clipboardData || c.clipboardData;
                        if (!t) {
                            return n && n.getData("Text")
                        }
                        n && n.setData("Text", t)
                    };
                    t.contains = function e(t, n) {
                        return !!n && (i.default.isTextNode(n) && (n = n.parentNode), i.default.isDocument(t) ? t.documentElement.contains(n) : (0, r.isWindow)(t) ? e(t.document, n) : t.contains ? t.contains(n) : !!(n.compareDocumentPosition(t) & n.DOCUMENT_POSITION_CONTAINS))
                    };
                    t.createTextElementHiddenCopy = function(e, t, n) {
                        var i = c.getComputedStyle((0, a.default)(e).get(0)),
                            o = n && n.includePaddings;
                        return (0, a.default)("<div>").text(t).css({
                            fontStyle: i.fontStyle,
                            fontVariant: i.fontVariant,
                            fontWeight: i.fontWeight,
                            fontSize: i.fontSize,
                            fontFamily: i.fontFamily,
                            letterSpacing: i.letterSpacing,
                            border: i.border,
                            paddingTop: o ? i.paddingTop : "",
                            paddingRight: o ? i.paddingRight : "",
                            paddingBottom: o ? i.paddingBottom : "",
                            paddingLeft: o ? i.paddingLeft : "",
                            visibility: "hidden",
                            whiteSpace: "pre",
                            position: "absolute",
                            float: "left"
                        })
                    };
                    var l = function(e, t) {
                        return t && i.default.insertElement(e.parentNode, t, e), e
                    };
                    t.insertBefore = l;
                    t.replaceWith = function(e, t) {
                        if (t && t[0]) {
                            return t.is(e) ? e : ((0, o.each)(t, (function(t, n) {
                                l(e[0], n)
                            })), e.remove(), t)
                        }
                    }
                },
            95640:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/error.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = function(e, t) {
                        var n = {
                            ERROR_MESSAGES: (0, i.extend)(t, e),
                            Error: function() {
                                return u([].slice.call(arguments))
                            },
                            log: function(e) {
                                var t = "log";
                                /^E\d+$/.test(e) ? t = "error" : /^W\d+$/.test(e) && (t = "warn"), a.logger[t]("log" === t ? e : s([].slice.call(arguments)))
                            }
                        };

                        function s(e) {
                            var t = e[0];
                            return l(t, c(t, e = e.slice(1)))
                        }

                        function c(e, t) {
                            return t = [n.ERROR_MESSAGES[e]].concat(t), o.format.apply(this, t).replace(/\.*\s*?$/, "")
                        }

                        function l(e, t) {
                            return o.format.apply(this, ["{0} - {1}. See:\n{2}", e, t, d(e)])
                        }

                        function u(e) {
                            var t = e[0],
                                n = c(t, e = e.slice(1)),
                                a = d(t),
                                o = l(t, n);
                            return (0, i.extend)(new Error(o), {
                                __id: t,
                                __details: n,
                                url: a
                            })
                        }

                        function d(e) {
                            return r + e
                        }
                        return n
                    };
                    var i = n( /*! ./extend */ 13306),
                        a = n( /*! ./console */ 30869),
                        o = n( /*! ./string */ 68752),
                        r = "http://js.devexpress.com/error/" + n( /*! ../version */ 36739).version.split(".").slice(0, 2).join("_") + "/";
                    e.exports = t.default, e.exports.default = t.default
                },
            13306:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/extend.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.extendFromObject = t.extend = void 0;
                    var i = n( /*! ./type */ 35922);
                    t.extendFromObject = function(e, t, n) {
                        for (var i in e = e || {}, t) {
                            if (Object.prototype.hasOwnProperty.call(t, i)) {
                                var a = t[i];
                                i in e && !n || (e[i] = a)
                            }
                        }
                        return e
                    };
                    t.extend = function e(t) {
                        var n = 1,
                            a = !1;
                        for ("boolean" == typeof(t = t || {}) && (a = t, t = arguments[1] || {}, n++); n < arguments.length; n++) {
                            var o = arguments[n];
                            if (null != o) {
                                for (var r in o) {
                                    var s = t[r],
                                        c = o[r],
                                        l = !1,
                                        u = void 0;
                                    "__proto__" !== r && "constructor" !== r && t !== c && (a && c && ((0, i.isPlainObject)(c) || (l = Array.isArray(c))) ? (u = l ? s && Array.isArray(s) ? s : [] : s && (0, i.isPlainObject)(s) ? s : {}, t[r] = e(a, u, c)) : void 0 !== c && (t[r] = c))
                                }
                            }
                        }
                        return t
                    }
                },
            61371:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/html_parser.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.parseHTML = t.isTablePart = void 0;
                    var i, a = n( /*! ./array */ 89386),
                        o = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = /<([a-z][^/\0>\x20\t\r\n\f]+)/i,
                        s = {
                            default: {
                                tagsCount: 0,
                                startTags: "",
                                endTags: ""
                            },
                            thead: {
                                tagsCount: 1,
                                startTags: "<table>",
                                endTags: "</table>"
                            },
                            td: {
                                tagsCount: 3,
                                startTags: "<table><tbody><tr>",
                                endTags: "</tr></tbody></table>"
                            },
                            col: {
                                tagsCount: 2,
                                startTags: "<table><colgroup>",
                                endTags: "</colgroup></table>"
                            },
                            tr: {
                                tagsCount: 2,
                                startTags: "<table><tbody>",
                                endTags: "</tbody></table>"
                            }
                        };
                    s.tbody = s.colgroup = s.caption = s.tfoot = s.thead, s.th = s.td;
                    t.parseHTML = function(e) {
                        if ("string" != typeof e) {
                            return null
                        }
                        var t = o.default.createDocumentFragment().appendChild(o.default.createElement("div")),
                            n = r.exec(e),
                            i = n && n[1].toLowerCase(),
                            c = s[i] || s.default;
                        t.innerHTML = c.startTags + e + c.endTags;
                        for (var l = 0; l < c.tagsCount; l++) {
                            t = t.lastChild
                        }
                        return (0, a.merge)([], t.childNodes)
                    };
                    t.isTablePart = function(e) {
                        var t = r.exec(e);
                        return t && t[1] in s
                    }
                },
            44899:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/icon.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.getImageSourceType = t.getImageContainer = void 0;
                    var i, a = (i = n( /*! ../../core/renderer */ 68374)) && i.__esModule ? i : {
                        default: i
                    };
                    var o = "dx-icon",
                        r = function(e) {
                            return !(!e || "string" != typeof e) && (/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(e) ? "svg" : /data:.*base64|\.|[^<\s]\//.test(e) ? "image" : /^[\w-_]+$/.test(e) ? "dxIcon" : !!/^\s?([\w-_]\s?)+$/.test(e) && "fontIcon")
                        };
                    t.getImageSourceType = r;
                    t.getImageContainer = function(e) {
                        switch (r(e)) {
                            case "image":
                                return (0, a.default)("<img>").attr("src", e).addClass(o);
                            case "fontIcon":
                                return (0, a.default)("<i>").addClass("".concat(o, " ").concat(e));
                            case "dxIcon":
                                return (0, a.default)("<i>").addClass("".concat(o, " ").concat(o, "-").concat(e));
                            case "svg":
                                return (0, a.default)("<i>").addClass("".concat(o, " ").concat("dx-svg-icon")).append(e);
                            default:
                                return null
                        }
                    }
                },
            78008:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/inflector.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.underscore = t.titleize = t.humanize = t.dasherize = t.captionize = t.camelize = void 0;
                    var i = n( /*! ./iterator */ 95479),
                        a = function(e) {
                            return null == e ? "" : String(e)
                        },
                        o = function(e) {
                            return a(e).charAt(0).toUpperCase() + e.substr(1)
                        },
                        r = function(e) {
                            return a(e).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
                        },
                        s = function(e) {
                            return (0, i.map)(r(e), (function(e) {
                                return e.toLowerCase()
                            })).join("-")
                        };
                    t.dasherize = s;
                    t.underscore = function(e) {
                        return s(e).replace(/-/g, "_")
                    };
                    t.camelize = function(e, t) {
                        return (0, i.map)(r(e), (function(e, n) {
                            return e = e.toLowerCase(), (t || n > 0) && (e = o(e)), e
                        })).join("")
                    };
                    t.humanize = function(e) {
                        return o(s(e).replace(/-/g, " "))
                    };
                    t.titleize = function(e) {
                        return (0, i.map)(r(e), (function(e) {
                            return o(e.toLowerCase())
                        })).join(" ")
                    };
                    var c = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
                    t.captionize = function(e) {
                        var t, n, i = [],
                            a = !1,
                            o = !1;
                        for (t = 0; t < e.length; t++) {
                            o = (n = e.charAt(t)) === n.toUpperCase() && "-" !== n && ")" !== n && "/" !== n || n in c, "_" === n || "." === n ? (n = " ", o = !0) : 0 === t ? (n = n.toUpperCase(), o = !0) : !a && o && i.length > 0 && i.push(" "), i.push(n), a = o
                        }
                        return i.join("")
                    }
                },
            95479:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/iterator.js ***!
                  \********************************************************************/
                function(e, t) {
                    t.reverseEach = t.map = t.each = void 0;
                    t.map = function(e, t) {
                        if (Array.isArray(e)) {
                            return e.map(t)
                        }
                        var n = [];
                        for (var i in e) {
                            n.push(t(e[i], i))
                        }
                        return n
                    };
                    t.each = function(e, t) {
                        if (e) {
                            if ("length" in e) {
                                for (var n = 0; n < e.length && !1 !== t.call(e[n], n, e[n]); n++) {}
                            } else {
                                for (var i in e) {
                                    if (!1 === t.call(e[i], i, e[i])) {
                                        break
                                    }
                                }
                            }
                            return e
                        }
                    };
                    t.reverseEach = function(e, t) {
                        if (e && "length" in e && 0 !== e.length) {
                            for (var n = e.length - 1; n >= 0 && !1 !== t.call(e[n], n, e[n]); n--) {}
                        }
                    }
                },
            88933:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/locker.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    t.default = function() {
                        var e = {},
                            t = function(t) {
                                return e[t] || 0
                            };
                        return {
                            obtain: function(n) {
                                e[n] = t(n) + 1
                            },
                            release: function(n) {
                                var i = t(n);
                                if (i < 1) {
                                    throw a.default.Error("E0014")
                                }
                                1 === i ? delete e[n] : e[n] = i - 1
                            },
                            locked: function(e) {
                                return t(e) > 0
                            }
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            60810:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/math.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.adjust = function(e, t) {
                        var n, r = o(t || 0) + 2,
                            s = e.toString().split("."),
                            c = e,
                            l = Math.abs(e),
                            u = (0, i.isExponential)(e),
                            d = l > 1 ? 10 : 0;
                        if (1 === s.length) {
                            return e
                        }
                        u || ((0, i.isExponential)(t) && (r = s[0].length + a(t)), e = (e = l) - Math.floor(e) + d);
                        if (r = "0.000300" !== 3e-4.toPrecision(3) && a(e) > 6 || r > 7 ? 15 : 7, !u && (n = parseFloat(e.toPrecision(r)).toString().split("."))[0] === d.toString()) {
                            return parseFloat(s[0] + "." + n[1])
                        }
                        return parseFloat(c.toPrecision(r))
                    }, t.fitIntoRange = void 0, t.getExponent = a, t.getExponentLength = function(e) {
                        var t, n = e.toString();
                        return (null === (t = n.split(".")[1]) || void 0 === t ? void 0 : t.length) || parseInt(n.split("e-")[1]) || 0
                    }, t.getPrecision = o, t.getRemainderByDivision = function(e, t, n) {
                        if (t === parseInt(t)) {
                            return e % t
                        }
                        var i = s(e / t, n);
                        return (i - parseInt(i)) * t
                    }, t.getRoot = r, t.inRange = void 0, t.roundFloatPart = s, t.sign = void 0, t.solveCubicEquation = function(e, t, n, i) {
                        var a = 1e-8;
                        if (Math.abs(e) < a) {
                            if (e = t, t = n, n = i, Math.abs(e) < a) {
                                return e = t, t = n, Math.abs(e) < a ? [] : [-t / e]
                            }
                            var o = t * t - 4 * e * n;
                            return Math.abs(o) < a ? [-t / (2 * e)] : o > 0 ? [(-t + Math.sqrt(o)) / (2 * e), (-t - Math.sqrt(o)) / (2 * e)] : []
                        }
                        var s, c, l = (3 * e * n - t * t) / (3 * e * e),
                            u = (2 * t * t * t - 9 * e * t * n + 27 * e * e * i) / (27 * e * e * e);
                        if (Math.abs(l) < a) {
                            s = [r(-u, 3)]
                        } else if (Math.abs(u) < a) {
                            s = [0].concat(l < 0 ? [Math.sqrt(-l), -Math.sqrt(-l)] : [])
                        } else {
                            var d = u * u / 4 + l * l * l / 27;
                            if (Math.abs(d) < a) {
                                s = [-1.5 * u / l, 3 * u / l]
                            } else if (d > 0) {
                                c = r(-u / 2 - Math.sqrt(d), 3), s = [c - l / (3 * c)]
                            } else {
                                c = 2 * Math.sqrt(-l / 3);
                                var f = Math.acos(3 * u / l / c) / 3,
                                    h = 2 * Math.PI / 3;
                                s = [c * Math.cos(f), c * Math.cos(f - h), c * Math.cos(f - 2 * h)]
                            }
                        }
                        for (var g = 0; g < s.length; g++) {
                            s[g] -= t / (3 * e)
                        }
                        return s
                    }, t.trunc = function(e) {
                        return Math.trunc ? Math.trunc(e) : e > 0 ? Math.floor(e) : Math.ceil(e)
                    };
                    var i = n( /*! ./type */ 35922);
                    t.sign = function(e) {
                        return 0 === e ? 0 : e / Math.abs(e)
                    };
                    t.fitIntoRange = function(e, t, n) {
                        var i = !t && 0 !== t,
                            a = !n && 0 !== n;
                        return i && (t = a ? e : Math.min(e, n)), a && (n = i ? e : Math.max(e, t)), Math.min(Math.max(e, t), n)
                    };

                    function a(e) {
                        return Math.abs(parseInt(e.toExponential().split("e")[1]))
                    }

                    function o(e) {
                        var t = e.toString();
                        if (t.indexOf(".") < 0) {
                            return 0
                        }
                        var n = t.split("."),
                            i = n[1].indexOf("e");
                        return i >= 0 ? i : n[1].length
                    }

                    function r(e, t) {
                        if (e < 0 && t % 2 != 1) {
                            return NaN
                        }
                        var n = Math.pow(Math.abs(e), 1 / t);
                        return t % 2 == 1 && e < 0 ? -n : n
                    }

                    function s(e) {
                        var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                        return parseFloat(e.toFixed(t))
                    }
                    t.inRange = function(e, t, n) {
                        return e >= t && e <= n
                    }
                },
            48013:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/object.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.orderEach = t.deepExtendArraySafe = t.clone = void 0;
                    var i, a = n( /*! ./type */ 35922),
                        o = (i = n( /*! ./variable_wrapper */ 26974)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function() {
                        function e() {}
                        return function(t) {
                            return e.prototype = t, new e
                        }
                    }();
                    t.clone = r;
                    t.orderEach = function(e, t) {
                        var n, i, o = [];
                        for (n in e) {
                            Object.prototype.hasOwnProperty.call(e, n) && o.push(n)
                        }
                        for (o.sort((function(e, t) {
                                var n = (0, a.isNumeric)(e),
                                    i = (0, a.isNumeric)(t);
                                return n && i ? e - t : n && !i ? -1 : !n && i ? 1 : e < t ? -1 : e > t ? 1 : 0
                            })), i = 0; i < o.length; i++) {
                            t(n = o[i], e[n])
                        }
                    };
                    var s = function(e, t, n, i) {
                        !i && o.default.isWrapped(e[t]) ? o.default.assign(e[t], n) : e[t] = n
                    };
                    t.deepExtendArraySafe = function e(t, n, i, o) {
                        var r, c;
                        for (var l in n) {
                            if (r = t[l], c = n[l], "__proto__" !== l && "constructor" !== l && t !== c) {
                                if ((0, a.isPlainObject)(c)) {
                                    c = e((i ? (0, a.isObject)(r) : (0, a.isPlainObject)(r)) ? r : {}, c, i, o)
                                }
                                void 0 !== c && r !== c && s(t, l, c, o)
                            }
                        }
                        return t
                    }
                },
            37518:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/position.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.getDefaultAlignment = t.getBoundingRect = void 0;
                    var i, a = (i = n( /*! ../config */ 80209)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../utils/type */ 35922);
                    t.getDefaultAlignment = function(e) {
                        return (null != e ? e : (0, a.default)().rtlEnabled) ? "right" : "left"
                    };
                    t.getBoundingRect = function(e) {
                        return (0, o.isWindow)(e) ? {
                            width: e.outerWidth,
                            height: e.outerHeight
                        } : e.getBoundingClientRect()
                    }
                },
            9321:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/public_component.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.attachInstanceToElement = function(e, t, n) {
                        var o = (0, i.data)(e.get(0)),
                            r = d(t.constructor);
                        o[r] = t, n && a.default.one(e, s.removeEvent, (function() {
                            n.call(t)
                        }));
                        o.dxComponents || (o.dxComponents = []);
                        o.dxComponents.push(r)
                    }, t.getInstanceByElement = function(e, t) {
                        var n = d(t);
                        return (0, i.data)(e.get(0), n)
                    }, t.name = void 0;
                    var i = n( /*! ../../core/element_data */ 97906),
                        a = c(n( /*! ../../events/core/events_engine */ 55994)),
                        o = c(n( /*! ../polyfills/weak_map */ 10126)),
                        r = n( /*! ./type */ 35922),
                        s = n( /*! ../remove_event */ 37819);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = new o.default,
                        u = 0,
                        d = function(e, t) {
                            if (!(0, r.isDefined)(t)) {
                                if (!l.has(e)) {
                                    var n = "dxPrivateComponent" + u++;
                                    return l.set(e, n), n
                                }
                                return l.get(e)
                            }
                            l.set(e, t)
                        };
                    t.name = d
                },
            59504:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/queue.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.create = r, t.enqueue = void 0;
                    var i, a = (i = n( /*! ../errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../../core/utils/deferred */ 62754);

                    function r(e) {
                        var t = [],
                            n = !1;

                        function i() {
                            for (; t.length;) {
                                n = !0;
                                var e = t.shift()();
                                if (void 0 !== e) {
                                    if (e.then) {
                                        return void(0, o.when)(e).always(i)
                                    }
                                    throw a.default.Error("E0015")
                                }
                            }
                            n = !1
                        }
                        return {
                            add: function(a, o) {
                                e ? (t[0] && o && o(t[0]), t = [a]) : t.push(a), n || i()
                            },
                            busy: function() {
                                return n
                            }
                        }
                    }
                    var s = r().add;
                    t.enqueue = s
                },
            24311:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/ready_callbacks.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../dom_adapter */ 73349)),
                        a = s(n( /*! ./dependency_injector */ 20476)),
                        o = n( /*! ./window */ 58201),
                        r = s(n( /*! ./call_once */ 39618));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = [],
                        l = (0, r.default)((function() {
                            var e = i.default.listen(i.default.getDocument(), "DOMContentLoaded", (function() {
                                u.fire(), e()
                            }))
                        })),
                        u = {
                            add: function(e) {
                                var t = (0, o.hasWindow)();
                                t && "loading" !== i.default.getReadyState() ? e() : (c.push(e), t && l())
                            },
                            fire: function() {
                                c.forEach((function(e) {
                                    return e()
                                })), c = []
                            }
                        },
                        d = (0, a.default)(u);
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            55814:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/resize_callbacks.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./window */ 58201),
                        a = c(n( /*! ../dom_adapter */ 73349)),
                        o = c(n( /*! ./callbacks */ 44504)),
                        r = c(n( /*! ./ready_callbacks */ 24311)),
                        s = c(n( /*! ./call_once */ 39618));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = function() {
                            var e, t = (0, o.default)(),
                                n = t.add,
                                c = t.remove;
                            if (!(0, i.hasWindow)()) {
                                return t
                            }
                            var l, u = function() {
                                    var e = (0, i.getWindow)();
                                    return {
                                        width: e.innerWidth,
                                        height: e.innerHeight
                                    }
                                },
                                d = function() {
                                    var n, i = u();
                                    i.width === e.width && i.height === e.height || (i.width === e.width && (n = "height"), i.height === e.height && (n = "width"), e = i, t.fire(n))
                                },
                                f = (0, s.default)((function() {
                                    e = u()
                                }));
                            return t.add = function() {
                                var e = n.apply(t, arguments);
                                return f(), r.default.add((function() {
                                    !l && t.has() && (l = a.default.listen((0, i.getWindow)(), "resize", d))
                                })), e
                            }, t.remove = function() {
                                var e = c.apply(t, arguments);
                                return !t.has() && l && (l(), l = void 0), e
                            }, t
                        }(),
                        u = l;
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            49601:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/selection_filter.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.SelectionFilterCreator = void 0;
                    var i = n( /*! ./common */ 20576),
                        a = n( /*! ./type */ 35922);
                    t.SelectionFilterCreator = function(e, t) {
                        var n;
                        this.getLocalFilter = function(e, t, n, a) {
                            return t = void 0 === t ? i.equalByValue : t, o.bind(this, t, e, n, a)
                        }, this.getExpr = function(n) {
                            var i;
                            if (n) {
                                return e.forEach((function(e, o) {
                                    var s;
                                    i = i || [], o > 0 && i.push(t ? "and" : "or"), s = (0, a.isString)(n) ? r(n, e) : function(e, n) {
                                        for (var i = [], a = 0, o = e.length; a < o; a++) {
                                            var s = e[a],
                                                c = r(s, n && n[s]);
                                            if (!c) {
                                                break
                                            }
                                            a > 0 && i.push(t ? "or" : "and"), i.push(c)
                                        }
                                        return i
                                    }(n, e), i.push(s)
                                })), i && 1 === i.length && (i = i[0]), i
                            }
                        }, this.getCombinedFilter = function(e, n) {
                            var i = this.getExpr(e),
                                a = i;
                            return t && n && (i ? ((a = []).push(i), a.push(n)) : a = n), a
                        };

                        function o(o, r, s, c, l) {
                            var u, d, f = r(l);
                            if (!s && (u = (0, i.getKeyHash)(f), !(0, a.isObject)(u))) {
                                var h = function(e) {
                                    if (!n) {
                                        n = {};
                                        for (var t = 0; t < e.length; t++) {
                                            n[(0, i.getKeyHash)(e[t])] = !0
                                        }
                                    }
                                    return n
                                }(function(e, t, n) {
                                    return Array.isArray(n) ? e.map((function(e) {
                                        return t(e)
                                    })) : e
                                }(e, r, c));
                                return h[u] ? !t : !!t
                            }
                            for (d = 0; d < e.length; d++) {
                                if (o(e[d], f)) {
                                    return !t
                                }
                            }
                            return !!t
                        }

                        function r(e, n) {
                            if (void 0 !== n) {
                                return [e, t ? "<>" : "=", n]
                            }
                        }
                    }
                },
            58664:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/size.js ***!
                  \****************************************************************/
                function(e, t, n) {
                    t.setWidth = t.setOuterWidth = t.setOuterHeight = t.setInnerWidth = t.setInnerHeight = t.setHeight = t.parseHeight = t.implementationsMap = t.getWindowByElement = t.getWidth = t.getVisibleHeight = t.getVerticalOffsets = t.getSize = t.getOuterWidth = t.getOuterHeight = t.getOffset = t.getInnerWidth = t.getInnerHeight = t.getHeight = t.getElementBoxParams = t.addOffsetToMinHeight = t.addOffsetToMaxHeight = void 0;
                    var i, a = n( /*! ../../core/utils/window */ 58201),
                        o = (i = n( /*! ../../core/dom_adapter */ 73349)) && i.__esModule ? i : {
                            default: i
                        },
                        r = n( /*! ../utils/type */ 35922);
                    var s = (0, a.getWindow)(),
                        c = ["auto", "none", "inherit", "initial"],
                        l = function(e, t) {
                            var n = 0;
                            return t.forEach((function(t) {
                                n += parseFloat(e[t]) || 0
                            })), n
                        },
                        u = function(e, t) {
                            var n = "width" === e ? "Left" : "Top",
                                i = "width" === e ? "Right" : "Bottom";
                            return {
                                padding: l(t, ["padding" + n, "padding" + i]),
                                border: l(t, ["border" + n + "Width", "border" + i + "Width"]),
                                margin: l(t, ["margin" + n, "margin" + i])
                            }
                        };
                    t.getElementBoxParams = u;
                    var d = function(e) {
                            var t, n = (null == e || null === (t = e.ownerDocument) || void 0 === t ? void 0 : t.defaultView) || s;
                            return n.getComputedStyle && n.getComputedStyle(e)
                        },
                        f = function(e, t, n, i) {
                            var a;
                            return (null == t ? void 0 : t[n]) || (null === (a = e.style) || void 0 === a ? void 0 : a[n]) || i
                        },
                        h = {
                            content: 0,
                            padding: 1,
                            border: 2,
                            margin: 3,
                            "content-box": 0,
                            "border-box": 2
                        },
                        g = {
                            width: ["left", "right"],
                            height: ["top", "bottom"]
                        };

                    function p(e, t, n, i) {
                        var a = function(e, t, n) {
                                return parseFloat(f(e, t, n, "0")) || 0
                            },
                            o = "border" === n ? "-width" : "";
                        return a(e, i, "".concat(n, "-").concat(g[t][0]).concat(o)) + a(e, i, "".concat(n, "-").concat(g[t][1]).concat(o))
                    }
                    var m = function(e, t, n) {
                        var i = "width" === t ? "offsetWidth" : "offsetHeight",
                            a = d(e),
                            o = f(e, a, t);
                        "" !== o && "auto" !== o || (o = e[i]), o = parseFloat(o) || 0;
                        var r = f(e, a, "boxSizing", "content-box"),
                            s = h[n || r],
                            c = h[r];
                        if (void 0 === s || void 0 === c) {
                            throw new Error
                        }
                        if (c === s) {
                            return o
                        }
                        var l = Math.sign(s - c),
                            u = !1,
                            g = !1,
                            m = !1,
                            _ = !1;
                        1 === l && (s += 1, c += 1);
                        for (var v = c; v !== s; v += l) {
                            switch (v) {
                                case h.content:
                                    break;
                                case h.padding:
                                    u = l * p(e, t, "padding", a);
                                    break;
                                case h.border:
                                    g = l * p(e, t, "border", a);
                                    break;
                                case h.margin:
                                    m = l * p(e, t, "margin", a)
                            }
                        }
                        if (u || g) {
                            var x = (!1 === u ? l * p(e, t, "padding", a) : u) + (!1 === g ? l * p(e, t, "border", a) : g);
                            _ = l * Math.max(0, Math.floor(e[i] - o - l * x)) || 0
                        }
                        return o + m + u + g + _
                    };
                    t.getSize = m;
                    var _ = function(e, t) {
                        return e.indexOf("px") > 0 ? e = parseInt(e.replace("px", "")) : e.indexOf("%") > 0 ? e = parseInt(e.replace("%", "")) * function(e) {
                            return (0, r.isWindow)(e) ? e.innerHeight : e.offsetHeight
                        }(t) / 100 : isNaN(e) || (e = parseInt(e)), e
                    };
                    t.parseHeight = _;
                    var v = function(e, t, n) {
                        return e ? c.indexOf(e) > -1 ? t ? null : e : ((0, r.isString)(e) && (e = _(e, n)), (0, r.isNumeric)(e) ? Math.max(0, e + t) : "calc(" + e + (t < 0 ? " - " : " ") + Math.abs(t) + "px)") : null
                    };
                    t.addOffsetToMaxHeight = function(e, t, n) {
                        var i = v(e, t, n);
                        return null !== i ? i : "none"
                    };
                    t.addOffsetToMinHeight = function(e, t, n) {
                        var i = v(e, t, n);
                        return null !== i ? i : 0
                    };
                    t.getVerticalOffsets = function(e, t) {
                        if (!e) {
                            return 0
                        }
                        var n = u("height", s.getComputedStyle(e));
                        return n.padding + n.border + (t ? n.margin : 0)
                    };
                    t.getVisibleHeight = function(e) {
                        if (e) {
                            var t = e.getBoundingClientRect();
                            if (t.height) {
                                return t.height
                            }
                        }
                        return 0
                    };
                    var x = {
                        getWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["width"].concat(t))
                        },
                        setWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["width"].concat(t))
                        },
                        getHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["height"].concat(t))
                        },
                        setHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["height"].concat(t))
                        },
                        getOuterWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["outerWidth"].concat(t))
                        },
                        setOuterWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["outerWidth"].concat(t))
                        },
                        getOuterHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["outerHeight"].concat(t))
                        },
                        setOuterHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["outerHeight"].concat(t))
                        },
                        getInnerWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["innerWidth"].concat(t))
                        },
                        setInnerWidth: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["innerWidth"].concat(t))
                        },
                        getInnerHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["innerHeight"].concat(t))
                        },
                        setInnerHeight: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return y.apply(void 0, ["innerHeight"].concat(t))
                        }
                    };

                    function y(e, t, n) {
                        return 2 === arguments.length ? b(t, e) : b(t, e, n)
                    }
                    t.implementationsMap = x;
                    t.getWidth = function(e) {
                        return x.getWidth(e)
                    };
                    t.setWidth = function(e, t) {
                        return x.setWidth(e, t)
                    };
                    t.getHeight = function(e) {
                        return x.getHeight(e)
                    };
                    t.setHeight = function(e, t) {
                        return x.setHeight(e, t)
                    };
                    t.getOuterWidth = function(e, t) {
                        return x.getOuterWidth(e, t || !1)
                    };
                    t.setOuterWidth = function(e, t) {
                        return x.setOuterWidth(e, t)
                    };
                    t.getOuterHeight = function(e, t) {
                        return x.getOuterHeight(e, t || !1)
                    };
                    t.setOuterHeight = function(e, t) {
                        return x.setOuterHeight(e, t)
                    };
                    t.getInnerWidth = function(e) {
                        return x.getInnerWidth(e)
                    };
                    t.setInnerWidth = function(e, t) {
                        return x.setInnerWidth(e, t)
                    };
                    t.getInnerHeight = function(e) {
                        return x.getInnerHeight(e)
                    };
                    t.setInnerHeight = function(e, t) {
                        return x.setInnerHeight(e, t)
                    };
                    var b = function e(t, n, i) {
                            var a = n.toLowerCase().indexOf("width") >= 0 ? "Width" : "Height",
                                s = a.toLowerCase(),
                                c = 0 === n.indexOf("outer"),
                                l = 0 === n.indexOf("inner"),
                                f = 2 === arguments.length || "boolean" == typeof i;
                            if ((0, r.isRenderer)(t)) {
                                if (t.length > 1 && !f) {
                                    for (var h = 0; h < t.length; h++) {
                                        e(t[h], n, i)
                                    }
                                    return
                                }
                                t = t[0]
                            }
                            if (t) {
                                if ((0, r.isWindow)(t)) {
                                    return c ? t["inner" + a] : o.default.getDocumentElement()["client" + a]
                                }
                                if (o.default.isDocument(t)) {
                                    var g = o.default.getDocumentElement(),
                                        p = o.default.getBody();
                                    return Math.max(p["scroll" + a], p["offset" + a], g["scroll" + a], g["offset" + a], g["client" + a])
                                }
                                if (f) {
                                    var _ = "content";
                                    return c && (_ = i ? "margin" : "border"), l && (_ = "padding"), m(t, s, _)
                                }
                                if ((0, r.isNumeric)(i)) {
                                    var v = d(t),
                                        x = u(s, v),
                                        y = "border-box" === v.boxSizing;
                                    i = Number(i), c ? i -= y ? 0 : x.border + x.padding : l ? i += y ? x.border : -x.padding : y && (i += x.border + x.padding)
                                }
                                return i += (0, r.isNumeric)(i) ? "px" : "", o.default.setStyle(t, s, i), null
                            }
                        },
                        w = function(e) {
                            return (0, r.isWindow)(e) ? e : e.defaultView
                        };
                    t.getWindowByElement = w;
                    t.getOffset = function(e) {
                        if (!e.getClientRects().length) {
                            return {
                                top: 0,
                                left: 0
                            }
                        }
                        var t = e.getBoundingClientRect(),
                            n = w(e.ownerDocument),
                            i = e.ownerDocument.documentElement;
                        return {
                            top: t.top + n.pageYOffset - i.clientTop,
                            left: t.left + n.pageXOffset - i.clientLeft
                        }
                    }
                },
            36613:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/storage.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.sessionStorage = void 0;
                    var i = (0, n( /*! ../../core/utils/window */ 58201).getWindow)();
                    t.sessionStorage = function() {
                        var e;
                        try {
                            e = i.sessionStorage
                        } catch (e) {}
                        return e
                    }
                },
            68752:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/string.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.encodeHtml = void 0, t.format = function(e) {
                        for (var t = arguments.length, n = new Array(t > 1 ? t - 1 : 0), a = 1; a < t; a++) {
                            n[a - 1] = arguments[a]
                        }
                        if ((0, i.isFunction)(e)) {
                            return e.apply(void 0, n)
                        }
                        return n.forEach((function(t, n) {
                            (0, i.isString)(t) && (t = t.replace(/\$/g, "$$$$"));
                            var a = new RegExp("\\{" + n + "\\}", "gm");
                            e = e.replace(a, t)
                        })), e
                    }, t.replaceAll = t.quadToObject = t.isEmpty = void 0;
                    var i = n( /*! ./type */ 35922);

                    function a(e) {
                        return a = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, a(e)
                    }
                    var o, r = (o = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")], function(e) {
                        return String(e).replace(o[0], "&amp;").replace(o[1], "&quot;").replace(o[2], "&#39;").replace(o[3], "&lt;").replace(o[4], "&gt;")
                    });
                    t.encodeHtml = r;
                    t.quadToObject = function(e) {
                        var t = function(e) {
                                switch (a(e)) {
                                    case "string":
                                        return e.split(/\s+/, 4);
                                    case "object":
                                        return [e.x || e.h || e.left, e.y || e.v || e.top, e.x || e.h || e.right, e.y || e.v || e.bottom];
                                    case "number":
                                        return [e];
                                    default:
                                        return e
                                }
                            }(e),
                            n = parseInt(t && t[0], 10),
                            i = parseInt(t && t[1], 10),
                            o = parseInt(t && t[2], 10),
                            r = parseInt(t && t[3], 10);
                        return isFinite(n) || (n = 0), isFinite(i) || (i = n), isFinite(o) || (o = n), isFinite(r) || (r = i), {
                            top: i,
                            right: o,
                            bottom: r,
                            left: n
                        }
                    };
                    t.replaceAll = function(e, t, n) {
                        return e.replace(new RegExp("(" + (t + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1") + ")", "gi"), n)
                    };
                    var c, l = (c = /\s/g, function(e) {
                        return !e || !e.replace(c, "")
                    });
                    t.isEmpty = l
                },
            80968:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/style.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.stylePropPrefix = t.styleProp = t.setWidth = t.setHeight = t.parsePixelValue = t.normalizeStyleProp = void 0;
                    var i = n( /*! ./inflector */ 78008),
                        a = s(n( /*! ./call_once */ 39618)),
                        o = n( /*! ./type */ 35922),
                        r = s(n( /*! ../dom_adapter */ 73349));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = ["", "Webkit", "Moz", "O", "Ms"],
                        l = {
                            "": "",
                            Webkit: "-webkit-",
                            Moz: "-moz-",
                            O: "-o-",
                            ms: "-ms-"
                        },
                        u = (0, a.default)((function() {
                            return r.default.createElement("dx").style
                        }));
                    t.styleProp = function(e) {
                        if (e in u()) {
                            return e
                        }
                        var t = e;
                        e = e.charAt(0).toUpperCase() + e.substr(1);
                        for (var n = 1; n < c.length; n++) {
                            var i = c[n].toLowerCase() + e;
                            if (i in u()) {
                                return i
                            }
                        }
                        return t
                    };
                    t.stylePropPrefix = function(e) {
                        return function(e, t) {
                            var n;
                            e = (0, i.camelize)(e, !0);
                            for (var a = 0, o = c.length; a < o; a++) {
                                var r = c[a],
                                    s = r + e;
                                if (void 0 === (n = t((0, i.camelize)(s), r)) && (n = t(s, r)), void 0 !== n) {
                                    break
                                }
                            }
                            return n || ""
                        }(e, (function(e, t) {
                            if (e in u()) {
                                return l[t]
                            }
                        }))
                    };
                    var d = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
                    t.parsePixelValue = function(e) {
                        return (0, o.isNumeric)(e) ? e : (0, o.isString)(e) ? Number(e.replace("px", "")) : NaN
                    };
                    t.normalizeStyleProp = function(e, t) {
                        return (0, o.isNumeric)(t) && -1 === d.indexOf(e) && (t += "px"), t
                    };
                    var f = function(e, t, n) {
                        if (e) {
                            n = (0, o.isNumeric)(n) ? n += "px" : n;
                            for (var i = 0; i < e.length; ++i) {
                                e[i].style[t] = n
                            }
                        }
                    };
                    t.setWidth = function(e, t) {
                        f(e, "width", t)
                    };
                    t.setHeight = function(e, t) {
                        f(e, "height", t)
                    }
                },
            60137:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/support.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.pointerEvents = t.nativeScrolling = t.inputType = t.animation = void 0, Object.defineProperty(t, "styleProp", {
                        enumerable: !0,
                        get: function() {
                            return c.styleProp
                        }
                    }), Object.defineProperty(t, "stylePropPrefix", {
                        enumerable: !0,
                        get: function() {
                            return c.stylePropPrefix
                        }
                    }), t.transitionEndEventName = t.transition = t.touchEvents = t.touch = t.supportProp = void 0;
                    var i = n( /*! ./array */ 89386),
                        a = l(n( /*! ../dom_adapter */ 73349)),
                        o = l(n( /*! ./call_once */ 39618)),
                        r = n( /*! ./window */ 58201),
                        s = l(n( /*! ../devices */ 20530)),
                        c = n( /*! ./style */ 80968);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = (0, r.getNavigator)().maxTouchPoints,
                        d = {
                            webkitTransition: "webkitTransitionEnd",
                            MozTransition: "transitionend",
                            OTransition: "oTransitionEnd",
                            transition: "transitionend"
                        },
                        f = function(e) {
                            return !!(0, c.styleProp)(e)
                        };
                    t.supportProp = f;
                    t.inputType = function(e) {
                        if ("text" === e) {
                            return !0
                        }
                        var t = a.default.createElement("input");
                        try {
                            return t.setAttribute("type", e), t.value = "wrongValue", !t.value
                        } catch (e) {
                            return !1
                        }
                    };
                    var h = function(e, t) {
                        return (e("ontouchstart") || !!t) && !e("callPhantom")
                    }(r.hasProperty, u);
                    t.touchEvents = h;
                    var g = (0, r.hasProperty)("PointerEvent");
                    t.pointerEvents = g;
                    var p = h || g && !!u;
                    t.touch = p;
                    var m = (0, o.default)((function() {
                        return f("transition")
                    }));
                    t.transition = m;
                    var _ = (0, o.default)((function() {
                        return d[(0, c.styleProp)("transition")]
                    }));
                    t.transitionEndEventName = _;
                    var v = (0, o.default)((function() {
                        return f("animation")
                    }));
                    t.animation = v;
                    var x, y, b, w, k = (x = s.default.real(), y = x.platform, b = x.version, w = x.mac, !(b && b[0] < 4 && "android" === y) && (0, i.inArray)(y, ["ios", "android"]) > -1 || w);
                    t.nativeScrolling = k
                },
            19155:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/svg.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    t.HIDDEN_FOR_EXPORT = void 0, t.getSvgElement = function(e) {
                        return i.default.isNode(e) ? e : (new s.DOMParser).parseFromString(e, "image/svg+xml").childNodes[0]
                    }, t.getSvgMarkup = function(e, t) {
                        return function(e) {
                            var t = !0; - 1 === e.indexOf("xmlns:xlink") && (e = e.replace("<svg", '<svg xmlns:xlink="http://www.w3.org/1999/xlink"'));
                            return (e = e.replace(/xmlns="[\s\S]*?"/gi, (function(e) {
                                return t ? (t = !1, e) : ""
                            }))).replace(/xmlns:NS1="[\s\S]*?"/gi, "").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi, 'xmlns:xlink="$1"')
                        }((n = function(e, t) {
                            var n = i.default.createElement("div"),
                                a = e.cloneNode(!0);
                            return t && (0, o.default)(a).css("backgroundColor", t), n.appendChild(a), n.innerHTML
                        }(e, t), n.replace(/&quot;/gi, "&#34;").replace(/&amp;/gi, "&#38;").replace(/&apos;/gi, "&#39;").replace(/&lt;/gi, "&#60;").replace(/&gt;/gi, "&#62;").replace(/&nbsp;/gi, "&#160;").replace(/&shy;/gi, "&#173;")));
                        var n
                    };
                    var i = r(n( /*! ../../core/dom_adapter */ 73349)),
                        a = n( /*! ./window */ 58201),
                        o = r(n( /*! ../../core/renderer */ 68374));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = (0, a.getWindow)();
                    t.HIDDEN_FOR_EXPORT = "hidden-for-export"
                },
            69697:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/template_manager.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.validateTemplateSource = t.templateKey = t.suitableTemplatesByName = t.getNormalizedTemplateArgs = t.findTemplates = t.defaultCreateElement = t.addOneRenderedCall = t.acquireTemplate = t.acquireIntegrationTemplate = void 0;
                    var i = m(n( /*! ../config */ 80209)),
                        a = m(n( /*! ../devices */ 20530)),
                        o = m(n( /*! ../errors */ 17381)),
                        r = m(n( /*! ../renderer */ 68374)),
                        s = n( /*! ../templates/child_default_template */ 91627),
                        c = n( /*! ../templates/empty_template */ 10688),
                        l = n( /*! ../templates/template */ 9545),
                        u = n( /*! ../templates/template_base */ 81033),
                        d = n( /*! ./array */ 89386),
                        f = n( /*! ./common */ 20576),
                        h = n( /*! ./dom */ 3532),
                        g = n( /*! ./extend */ 13306),
                        p = n( /*! ./type */ 35922);

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.findTemplates = function(e, t) {
                        var n = "data-options",
                            a = (0, r.default)(e).contents().filter("[".concat(n, '*="').concat(t, '"]'));
                        return [].slice.call(a).map((function(e) {
                            var a = (0, r.default)(e).attr(n) || "";
                            return {
                                element: e,
                                options: (0, i.default)().optionsParser(a)[t]
                            }
                        })).filter((function(e) {
                            return !!e.options
                        }))
                    };
                    t.suitableTemplatesByName = function(e) {
                        var t = (0, d.groupBy)(e, (function(e) {
                            return e.options.name
                        }));
                        if (t[void 0]) {
                            throw o.default.Error("E0023")
                        }
                        var n = {};
                        return Object.keys(t).forEach((function(e) {
                            var i, o = null === (i = (0, f.findBestMatches)(a.default.current(), t[e], (function(e) {
                                return e.options
                            }))[0]) || void 0 === i ? void 0 : i.element;
                            o && (n[e] = o)
                        })), n
                    };
                    var _ = function(e) {
                        var t = e.render.bind(e);
                        return (0, g.extend)({}, e, {
                            render: function(e) {
                                var n = t(e);
                                return e && e.onRendered && e.onRendered(), n
                            }
                        })
                    };
                    t.addOneRenderedCall = _;
                    t.getNormalizedTemplateArgs = function(e) {
                        var t = [];
                        return "model" in e && t.push(e.model), "index" in e && t.push(e.index), t.push(e.container), t
                    };
                    t.validateTemplateSource = function(e) {
                        return "string" == typeof e ? (0, h.normalizeTemplateElement)(e) : e
                    };
                    t.templateKey = function(e) {
                        return (0, p.isRenderer)(e) && e[0] || e
                    };
                    t.defaultCreateElement = function(e) {
                        return new l.Template(e)
                    };
                    var v = function(e, t, n, i) {
                        var a = null;
                        return i && -1 !== i.indexOf(e) || !(a = t[e]) || a instanceof u.TemplateBase || n || (a = _(a)), a
                    };
                    t.acquireIntegrationTemplate = v;
                    t.acquireTemplate = function(e, t, n, i, a, o) {
                        return null == e ? new c.EmptyTemplate : e instanceof s.ChildDefaultTemplate ? o[e.name] : e instanceof u.TemplateBase ? e : (0, p.isFunction)(e.render) && !(0, p.isRenderer)(e) ? i ? e : _(e) : e.nodeType || (0, p.isRenderer)(e) ? t((0, r.default)(e)) : v(e, n, i, a) || o[e] || t(e)
                    }
                },
            35922:
                /*!****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/type.js ***!
                  \****************************************************************/
                function(e, t) {
                    function n(e) {
                        return n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, n(e)
                    }
                    t.type = t.isWindow = t.isString = t.isRenderer = t.isPromise = t.isPrimitive = t.isPlainObject = t.isObject = t.isNumeric = t.isFunction = t.isExponential = t.isEvent = t.isEmptyObject = t.isDefined = t.isDeferred = t.isDate = t.isBoolean = void 0;
                    var i = {
                            "[object Array]": "array",
                            "[object Date]": "date",
                            "[object Object]": "object",
                            "[object String]": "string",
                            "[object Null]": "null"
                        },
                        a = function(e) {
                            var t = Object.prototype.toString.call(e);
                            return "object" === n(e) ? i[t] || "object" : n(e)
                        };
                    t.type = a;
                    t.isBoolean = function(e) {
                        return "boolean" == typeof e
                    };
                    t.isExponential = function(e) {
                        return r(e) && -1 !== e.toString().indexOf("e")
                    };
                    t.isDate = function(e) {
                        return "date" === a(e)
                    };
                    t.isDefined = function(e) {
                        return null != e
                    };
                    var o = function(e) {
                        return "function" == typeof e
                    };
                    t.isFunction = o;
                    t.isString = function(e) {
                        return "string" == typeof e
                    };
                    var r = function(e) {
                        return "number" == typeof e && isFinite(e) || !isNaN(e - parseFloat(e))
                    };
                    t.isNumeric = r;
                    t.isObject = function(e) {
                        return "object" === a(e)
                    };
                    t.isEmptyObject = function(e) {
                        var t;
                        for (t in e) {
                            return !1
                        }
                        return !0
                    };
                    t.isPlainObject = function(e) {
                        if (!e || "[object Object]" !== Object.prototype.toString.call(e)) {
                            return !1
                        }
                        var t = Object.getPrototypeOf(e),
                            n = Object.hasOwnProperty.call(t, "constructor") && t.constructor;
                        return "function" == typeof n && Object.toString.call(n) === Object.toString.call(Object)
                    };
                    t.isPrimitive = function(e) {
                        return -1 === ["object", "array", "function"].indexOf(a(e))
                    };
                    t.isWindow = function(e) {
                        return null != e && e === e.window
                    };
                    t.isRenderer = function(e) {
                        return !(!e || !e.jquery && !e.dxRenderer)
                    };
                    t.isPromise = function(e) {
                        return !!e && o(e.then)
                    };
                    t.isDeferred = function(e) {
                        return !!e && o(e.done) && o(e.fail)
                    };
                    t.isEvent = function(e) {
                        return !(!e || !e.preventDefault)
                    }
                },
            26974:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/variable_wrapper.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ./console */ 30869);
                    var o = (0, ((i = n( /*! ./dependency_injector */ 20476)) && i.__esModule ? i : {
                        default: i
                    }).default)({
                        isWrapped: function() {
                            return !1
                        },
                        isWritableWrapped: function() {
                            return !1
                        },
                        wrap: function(e) {
                            return e
                        },
                        unwrap: function(e) {
                            return e
                        },
                        assign: function() {
                            a.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
                        }
                    });
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            58020:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/version.js ***!
                  \*******************************************************************/
                function(e, t) {
                    t.compare = function(e, t, n) {
                        function i(e) {
                            return "string" == typeof e ? e.split(".") : "number" == typeof e ? [e] : e
                        }
                        e = i(e), t = i(t);
                        var a = Math.max(e.length, t.length);
                        isFinite(n) && (a = Math.min(a, n));
                        for (var o = 0; o < a; o++) {
                            var r = parseInt(e[o] || 0, 10),
                                s = parseInt(t[o] || 0, 10);
                            if (r < s) {
                                return -1
                            }
                            if (r > s) {
                                return 1
                            }
                        }
                        return 0
                    }
                },
            77695:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/view_port.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.changeCallback = void 0, t.originalViewPort = function() {
                        return u
                    }, t.value = void 0;
                    var i = r(n( /*! ../renderer */ 68374)),
                        a = r(n( /*! ./ready_callbacks */ 24311)),
                        o = r(n( /*! ./callbacks */ 44504));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = a.default.add,
                        c = (0, o.default)();
                    t.changeCallback = c;
                    var l, u = (0, i.default)(),
                        d = function(e) {
                            if (!arguments.length) {
                                return l
                            }
                            var t = (0, i.default)(e);
                            u = t;
                            var n = !!t.length,
                                a = d();
                            l = n ? t : (0, i.default)("body"), c.fire(n ? d() : (0, i.default)(), a)
                        };
                    t.value = d, s((function() {
                        d(".dx-viewport")
                    }))
                },
            58201:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/utils/window.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.setWindow = t.hasWindow = t.hasProperty = t.getWindow = t.getNavigator = t.getCurrentScreenFactor = t.defaultScreenFactorFunc = void 0;
                    var i, a = (i = n( /*! ../dom_adapter */ 73349)) && i.__esModule ? i : {
                        default: i
                    };
                    var o = "undefined" != typeof window,
                        r = function() {
                            return o
                        };
                    t.hasWindow = r;
                    var s = r() ? window : void 0;
                    s || ((s = {}).window = s);
                    t.getWindow = function() {
                        return s
                    };
                    t.setWindow = function(e, t) {
                        o = void 0 === t ? "undefined" != typeof window && window === e : t, s = e
                    };
                    t.hasProperty = function(e) {
                        return r() && e in s
                    };
                    var c = function(e) {
                        return e < 768 ? "xs" : e < 992 ? "sm" : e < 1200 ? "md" : "lg"
                    };
                    t.defaultScreenFactorFunc = c;
                    t.getCurrentScreenFactor = function(e) {
                        return (e || c)(a.default.getDocumentElement().clientWidth)
                    };
                    t.getNavigator = function() {
                        return r() ? s.navigator : {
                            userAgent: ""
                        }
                    }
                },
            36739:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/core/version.js ***!
                  \*************************************************************/
                function(e, t) {
                    t.version = void 0;
                    t.version = "21.2.3"
                },
            67403:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/abstract_store.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = f(n( /*! ../core/class */ 38377)),
                        a = n( /*! ../core/events_strategy */ 80566),
                        o = n( /*! ../core/utils/iterator */ 95479),
                        r = n( /*! ./errors */ 18438),
                        s = n( /*! ./utils */ 16454),
                        c = n( /*! ../core/utils/data */ 47617),
                        l = f(n( /*! ./store_helper */ 99236)),
                        u = n( /*! ../core/utils/deferred */ 62754),
                        d = n( /*! ../core/utils/common */ 20576);

                    function f(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function g(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var p, m = i.default.abstract,
                        _ = l.default.queryByOptions,
                        v = {},
                        x = i.default.inherit({
                            ctor: function(e) {
                                var t = this;
                                e = e || {}, this._eventsStrategy = new a.EventsStrategy(this), (0, o.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], (function(n, i) {
                                    i in e && t.on(i.slice(2).toLowerCase(), e[i])
                                })), this._key = e.key, this._errorHandler = e.errorHandler, this._useDefaultSearch = !0
                            },
                            _customLoadOptions: function() {
                                return null
                            },
                            key: function() {
                                return this._key
                            },
                            keyOf: function(e) {
                                return this._keyGetter || (this._keyGetter = (0, c.compileGetter)(this.key())), this._keyGetter(e)
                            },
                            _requireKey: function() {
                                if (!this.key()) {
                                    throw r.errors.Error("E4005")
                                }
                            },
                            load: function(e) {
                                var t = this;
                                return e = e || {}, this._eventsStrategy.fireEvent("loading", [e]), this._withLock(this._loadImpl(e)).done((function(n) {
                                    t._eventsStrategy.fireEvent("loaded", [n, e])
                                }))
                            },
                            _loadImpl: function(e) {
                                return _(this.createQuery(e), e).enumerate()
                            },
                            _withLock: function(e) {
                                var t = new u.Deferred;
                                return e.done((function() {
                                    var e = this,
                                        n = arguments;
                                    s.processRequestResultLock.promise().done((function() {
                                        t.resolveWith(e, n)
                                    }))
                                })).fail((function() {
                                    t.rejectWith(this, arguments)
                                })), t
                            },
                            createQuery: m,
                            totalCount: function(e) {
                                return this._totalCountImpl(e)
                            },
                            _totalCountImpl: function(e) {
                                return _(this.createQuery(e), e, !0).count()
                            },
                            byKey: function(e, t) {
                                return this._addFailHandlers(this._withLock(this._byKeyImpl(e, t)))
                            },
                            _byKeyImpl: m,
                            insert: function(e) {
                                var t = this;
                                return t._eventsStrategy.fireEvent("modifying"), t._eventsStrategy.fireEvent("inserting", [e]), t._addFailHandlers(t._insertImpl(e).done((function(e, n) {
                                    t._eventsStrategy.fireEvent("inserted", [e, n]), t._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _insertImpl: m,
                            update: function(e, t) {
                                var n = this;
                                return n._eventsStrategy.fireEvent("modifying"), n._eventsStrategy.fireEvent("updating", [e, t]), n._addFailHandlers(n._updateImpl(e, t).done((function() {
                                    n._eventsStrategy.fireEvent("updated", [e, t]), n._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _updateImpl: m,
                            push: function(e) {
                                var t = this,
                                    n = {
                                        changes: e,
                                        waitFor: []
                                    };
                                this._eventsStrategy.fireEvent("beforePush", [n]), u.when.apply(void 0, function(e) {
                                    return function(e) {
                                        if (Array.isArray(e)) {
                                            return g(e)
                                        }
                                    }(e) || function(e) {
                                        if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                            return Array.from(e)
                                        }
                                    }(e) || function(e, t) {
                                        if (!e) {
                                            return
                                        }
                                        if ("string" == typeof e) {
                                            return g(e, t)
                                        }
                                        var n = Object.prototype.toString.call(e).slice(8, -1);
                                        "Object" === n && e.constructor && (n = e.constructor.name);
                                        if ("Map" === n || "Set" === n) {
                                            return Array.from(e)
                                        }
                                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                            return g(e, t)
                                        }
                                    }(e) || function() {
                                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                    }()
                                }(n.waitFor)).done((function() {
                                    t._pushImpl(e), t._eventsStrategy.fireEvent("push", [e])
                                }))
                            },
                            _pushImpl: d.noop,
                            remove: function(e) {
                                var t = this;
                                return t._eventsStrategy.fireEvent("modifying"), t._eventsStrategy.fireEvent("removing", [e]), t._addFailHandlers(t._removeImpl(e).done((function(e) {
                                    t._eventsStrategy.fireEvent("removed", [e]), t._eventsStrategy.fireEvent("modified")
                                })))
                            },
                            _removeImpl: m,
                            _addFailHandlers: function(e) {
                                return e.fail(this._errorHandler).fail(r.handleError)
                            },
                            on: function(e, t) {
                                return this._eventsStrategy.on(e, t), this
                            },
                            off: function(e, t) {
                                return this._eventsStrategy.off(e, t), this
                            }
                        });
                    x.create = function(e, t) {
                        if (!(e in v)) {
                            throw r.errors.Error("E4020", e)
                        }
                        return new v[e](t)
                    }, x.registerClass = function(e, t) {
                        return t && (v[t] = e), e
                    }, x.inherit = (p = x.inherit, function(e, t) {
                        var n = p.apply(this, [e]);
                        return x.registerClass(n, t), n
                    });
                    var y = x;
                    t.default = y, e.exports = t.default, e.exports.default = t.default
                },
            36893:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/apply_changes.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./array_utils */ 60637).applyChanges;
                    t.default = i, e.exports = t.default, e.exports.default = t.default
                },
            35042:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_query.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ../core/class */ 38377)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = n( /*! ../core/utils/data */ 47617),
                        c = n( /*! ../core/utils/deferred */ 62754),
                        l = n( /*! ./errors */ 18438),
                        u = n( /*! ./utils */ 16454);
                    var d = a.default.inherit({
                            toArray: function() {
                                var e = [];
                                for (this.reset(); this.next();) {
                                    e.push(this.current())
                                }
                                return e
                            },
                            countable: function() {
                                return !1
                            }
                        }),
                        f = d.inherit({
                            ctor: function(e) {
                                this.array = e, this.index = -1
                            },
                            next: function() {
                                return this.index + 1 < this.array.length && (this.index++, !0)
                            },
                            current: function() {
                                return this.array[this.index]
                            },
                            reset: function() {
                                this.index = -1
                            },
                            toArray: function() {
                                return this.array.slice(0)
                            },
                            countable: function() {
                                return !0
                            },
                            count: function() {
                                return this.array.length
                            }
                        }),
                        h = d.inherit({
                            ctor: function(e) {
                                this.iter = e
                            },
                            next: function() {
                                return this.iter.next()
                            },
                            current: function() {
                                return this.iter.current()
                            },
                            reset: function() {
                                return this.iter.reset()
                            }
                        }),
                        g = h.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.index = -1, this.mapper = t
                            },
                            current: function() {
                                return this.mapper(this.callBase(), this.index)
                            },
                            next: function() {
                                var e = this.callBase();
                                return e && this.index++, e
                            }
                        }),
                        p = function(e, t) {
                            return e = (0, s.toComparable)(e), t = (0, s.toComparable)(t), null === e && null !== t ? -1 : null !== e && null === t || void 0 === e && void 0 !== t ? 1 : void 0 !== e && void 0 === t || e < t ? -1 : e > t ? 1 : 0
                        },
                        m = d.inherit({
                            ctor: function(e, t, n, i) {
                                e instanceof g || (e = new g(e, this._wrap)), this.iter = e, this.rules = [{
                                    getter: t,
                                    desc: n,
                                    compare: i
                                }]
                            },
                            thenBy: function(e, t, n) {
                                var i = new m(this.sortedIter || this.iter, e, t, n);
                                return this.sortedIter || (i.rules = this.rules.concat(i.rules)), i
                            },
                            next: function() {
                                return this._ensureSorted(), this.sortedIter.next()
                            },
                            current: function() {
                                return this._ensureSorted(), this.sortedIter.current()
                            },
                            reset: function() {
                                delete this.sortedIter
                            },
                            countable: function() {
                                return this.sortedIter || this.iter.countable()
                            },
                            count: function() {
                                return this.sortedIter ? this.sortedIter.count() : this.iter.count()
                            },
                            _ensureSorted: function() {
                                var e = this;
                                e.sortedIter || ((0, r.each)(e.rules, (function() {
                                    this.getter = (0, s.compileGetter)(this.getter)
                                })), e.sortedIter = new g(new f(this.iter.toArray().sort((function(t, n) {
                                    return e._compare(t, n)
                                }))), e._unwrap))
                            },
                            _wrap: function(e, t) {
                                return {
                                    index: t,
                                    value: e
                                }
                            },
                            _unwrap: function(e) {
                                return e.value
                            },
                            _compare: function(e, t) {
                                var n = e.index,
                                    i = t.index;
                                if ((e = e.value) === (t = t.value)) {
                                    return n - i
                                }
                                for (var a = 0, o = this.rules.length; a < o; a++) {
                                    var r = this.rules[a],
                                        s = r.getter(e),
                                        c = r.getter(t),
                                        l = (r.compare || p)(s, c);
                                    if (l) {
                                        return r.desc ? -l : l
                                    }
                                }
                                return n - i
                            }
                        }),
                        _ = function() {
                            var e = function(e) {
                                return (0, o.isDefined)(e) ? e.toString() : ""
                            };

                            function t(e, t, n) {
                                return function(i) {
                                    i = (0, s.toComparable)(e(i));
                                    var a = function(e) {
                                        return "" === e || 0 === e || !1 === e
                                    }(t) ? i === t : i == t;
                                    return n && (a = !a), a
                                }
                            }
                            return function(n) {
                                return (0, o.isFunction)(n) ? n : (0, u.isGroupCriterion)(n) ? function(e) {
                                    var t = [],
                                        n = !1,
                                        i = !1;
                                    return (0, r.each)(e, (function() {
                                            if (Array.isArray(this) || (0, o.isFunction)(this)) {
                                                if (t.length > 1 && n !== i) {
                                                    throw new l.errors.Error("E4019")
                                                }
                                                t.push(_(this)), n = i, i = !0
                                            } else {
                                                i = (0, u.isConjunctiveOperator)(this)
                                            }
                                        })),
                                        function(e) {
                                            for (var i = n, a = 0; a < t.length; a++) {
                                                if (t[a](e) !== n) {
                                                    i = !n;
                                                    break
                                                }
                                            }
                                            return i
                                        }
                                }(n) : (0, u.isUnaryOperation)(n) ? function(e) {
                                    var t = e[0],
                                        n = _(e[1]);
                                    if ("!" === t) {
                                        return function(e) {
                                            return !n(e)
                                        }
                                    }
                                    throw l.errors.Error("E4003", t)
                                }(n) : function(n) {
                                    n = (0, u.normalizeBinaryCriterion)(n);
                                    var i = (0, s.compileGetter)(n[0]),
                                        a = n[1],
                                        o = n[2];
                                    switch (o = (0, s.toComparable)(o), a.toLowerCase()) {
                                        case "=":
                                            return t(i, o);
                                        case "<>":
                                            return t(i, o, !0);
                                        case ">":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) > o
                                            };
                                        case "<":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) < o
                                            };
                                        case ">=":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) >= o
                                            };
                                        case "<=":
                                            return function(e) {
                                                return (0, s.toComparable)(i(e)) <= o
                                            };
                                        case "startswith":
                                            return function(t) {
                                                return 0 === (0, s.toComparable)(e(i(t))).indexOf(o)
                                            };
                                        case "endswith":
                                            return function(t) {
                                                var n = (0, s.toComparable)(e(i(t))),
                                                    a = e(o);
                                                if (n.length < a.length) {
                                                    return !1
                                                }
                                                var r = n.lastIndexOf(o);
                                                return -1 !== r && r === n.length - o.length
                                            };
                                        case "contains":
                                            return function(t) {
                                                return (0, s.toComparable)(e(i(t))).indexOf(o) > -1
                                            };
                                        case "notcontains":
                                            return function(t) {
                                                return -1 === (0, s.toComparable)(e(i(t))).indexOf(o)
                                            }
                                    }
                                    throw l.errors.Error("E4003", a)
                                }(n)
                            }
                        }(),
                        v = h.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.criteria = _(t)
                            },
                            next: function() {
                                for (; this.iter.next();) {
                                    if (this.criteria(this.current())) {
                                        return !0
                                    }
                                }
                                return !1
                            }
                        }),
                        x = d.inherit({
                            ctor: function(e, t) {
                                this.iter = e, this.getter = t
                            },
                            next: function() {
                                return this._ensureGrouped(), this.groupedIter.next()
                            },
                            current: function() {
                                return this._ensureGrouped(), this.groupedIter.current()
                            },
                            reset: function() {
                                delete this.groupedIter
                            },
                            countable: function() {
                                return !!this.groupedIter
                            },
                            count: function() {
                                return this.groupedIter.count()
                            },
                            _ensureGrouped: function() {
                                if (!this.groupedIter) {
                                    var e = {},
                                        t = [],
                                        n = this.iter,
                                        i = (0, s.compileGetter)(this.getter);
                                    for (n.reset(); n.next();) {
                                        var a = n.current(),
                                            o = i(a);
                                        o in e ? e[o].push(a) : (e[o] = [a], t.push(o))
                                    }
                                    this.groupedIter = new f((0, r.map)(t, (function(t) {
                                        return {
                                            key: t,
                                            items: e[t]
                                        }
                                    })))
                                }
                            }
                        }),
                        y = h.inherit({
                            ctor: function(e, t) {
                                this.callBase(e), this.getter = (0, s.compileGetter)(t)
                            },
                            current: function() {
                                return this.getter(this.callBase())
                            },
                            countable: function() {
                                return this.iter.countable()
                            },
                            count: function() {
                                return this.iter.count()
                            }
                        }),
                        b = h.inherit({
                            ctor: function(e, t, n) {
                                this.callBase(e), this.skip = Math.max(0, t), this.take = Math.max(0, n), this.pos = 0
                            },
                            next: function() {
                                if (this.pos >= this.skip + this.take) {
                                    return !1
                                }
                                for (; this.pos < this.skip && this.iter.next();) {
                                    this.pos++
                                }
                                return this.pos++, this.iter.next()
                            },
                            reset: function() {
                                this.callBase(), this.pos = 0
                            },
                            countable: function() {
                                return this.iter.countable()
                            },
                            count: function() {
                                return Math.min(this.iter.count() - this.skip, this.take)
                            }
                        });
                    t.default = function e(t, n) {
                        n = n || {}, t instanceof d || (t = new f(t));
                        var i = function(e) {
                                var t = n.errorHandler;
                                t && t(e), (0, l.handleError)(e)
                            },
                            a = function(e) {
                                var n = (new c.Deferred).fail(i),
                                    a = e.step,
                                    o = e.finalize;
                                try {
                                    t.reset();
                                    for (var r = ("seed" in e ? e.seed : t.next() ? t.current() : NaN); t.next();) {
                                        r = a(r, t.current())
                                    }
                                    n.resolve(o ? o(r) : r)
                                } catch (e) {
                                    n.reject(e)
                                }
                                return n.promise()
                            },
                            r = function(e) {
                                return a(u.aggregators[e])
                            },
                            h = function(e) {
                                return (0, o.isFunction)(e) || Array.isArray(e) || (e = [].slice.call(arguments)), p(new y(t, e))
                            },
                            g = function(e) {
                                return h((0, s.compileGetter)(e))
                            };

                        function p(t) {
                            return e(t, n)
                        }
                        return {
                            toArray: function() {
                                return t.toArray()
                            },
                            enumerate: function() {
                                var e = (new c.Deferred).fail(i);
                                try {
                                    e.resolve(t.toArray())
                                } catch (t) {
                                    e.reject(t)
                                }
                                return e.promise()
                            },
                            sortBy: function(e, n, i) {
                                return p(new m(t, e, n, i))
                            },
                            thenBy: function(e, n, i) {
                                if (t instanceof m) {
                                    return p(t.thenBy(e, n, i))
                                }
                                throw l.errors.Error("E4004")
                            },
                            filter: function(e) {
                                return Array.isArray(e) || (e = [].slice.call(arguments)), p(new v(t, e))
                            },
                            slice: function(e, n) {
                                return void 0 === n && (n = Number.MAX_VALUE), p(new b(t, e, n))
                            },
                            select: h,
                            groupBy: function(e) {
                                return p(new x(t, e))
                            },
                            aggregate: function(e, t, n) {
                                return a(arguments.length < 2 ? {
                                    step: arguments[0]
                                } : {
                                    seed: e,
                                    step: t,
                                    finalize: n
                                })
                            },
                            count: function() {
                                if (t.countable()) {
                                    var e = (new c.Deferred).fail(i);
                                    try {
                                        e.resolve(t.count())
                                    } catch (t) {
                                        e.reject(t)
                                    }
                                    return e.promise()
                                }
                                return r("count")
                            },
                            sum: function(e) {
                                return e ? g(e).sum() : r("sum")
                            },
                            min: function(e) {
                                return e ? g(e).min() : r("min")
                            },
                            max: function(e) {
                                return e ? g(e).max() : r("max")
                            },
                            avg: function(e) {
                                return e ? g(e).avg() : r("avg")
                            }
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            26562:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 16454),
                        a = c(n( /*! ./query */ 96687)),
                        o = n( /*! ./errors */ 18438),
                        r = c(n( /*! ./abstract_store */ 67403)),
                        s = n( /*! ./array_utils */ 60637);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = r.default.inherit({
                        ctor: function(e) {
                            e = Array.isArray(e) ? {
                                data: e
                            } : e || {}, this.callBase(e);
                            var t = e.data;
                            if (t && !Array.isArray(t)) {
                                throw o.errors.Error("E4006")
                            }
                            this._array = t || []
                        },
                        createQuery: function() {
                            return (0, a.default)(this._array, {
                                errorHandler: this._errorHandler
                            })
                        },
                        _byKeyImpl: function(e) {
                            var t = (0, s.indexByKey)(this, this._array, e);
                            return -1 === t ? (0, i.rejectedPromise)(o.errors.Error("E4009")) : (0, i.trivialPromise)(this._array[t])
                        },
                        _insertImpl: function(e) {
                            return (0, s.insert)(this, this._array, e)
                        },
                        _pushImpl: function(e) {
                            (0, s.applyBatch)({
                                keyInfo: this,
                                data: this._array,
                                changes: e
                            })
                        },
                        _updateImpl: function(e, t) {
                            return (0, s.update)(this, this._array, e, t)
                        },
                        _removeImpl: function(e) {
                            return (0, s.remove)(this, this._array, e)
                        },
                        clear: function() {
                            this._eventsStrategy.fireEvent("modifying"), this._array = [], this._eventsStrategy.fireEvent("modified")
                        }
                    }, "array");
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            60637:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/array_utils.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.applyBatch = y, t.applyChanges = function(e, t) {
                        var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            i = n.keyExpr,
                            a = void 0 === i ? "id" : i,
                            o = n.immutable,
                            r = void 0 === o || o,
                            s = (0, l.compileGetter)(a),
                            c = {
                                key: function() {
                                    return a
                                },
                                keyOf: function(e) {
                                    return s(e)
                                }
                            };
                        return y({
                            keyInfo: c,
                            data: e,
                            changes: t,
                            immutable: r,
                            disableCache: !0,
                            logError: !0
                        })
                    }, t.createObjectWithChanges = x, t.indexByKey = C, t.insert = k, t.remove = S, t.update = w;
                    var i = n( /*! ../core/utils/type */ 35922),
                        a = d(n( /*! ../core/config */ 80209)),
                        o = d(n( /*! ../core/guid */ 73176)),
                        r = n( /*! ../core/utils/extend */ 13306),
                        s = n( /*! ./errors */ 18438),
                        c = n( /*! ../core/utils/object */ 48013),
                        l = n( /*! ../core/utils/data */ 47617),
                        u = n( /*! ./utils */ 16454);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function f(e) {
                        return f = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, f(e)
                    }

                    function g(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }

                    function m(e, t, n, i) {
                        return i ? function p(e, t, n, i) {
                            var a;
                            if (i) {
                                for (var o = 0; o < t.length; o++) {
                                    if (a = p(e, t[o].items || t[o].collapsedItems || [] || [], n, i - 1)) {
                                        return a
                                    }
                                }
                            } else if (C(e, t, n) >= 0) {
                                return t
                            }
                        }(e, t, n, i) || [] : t
                    }

                    function _(e, t, n) {
                        e._dataByKeyMap && (e._dataByKeyMap[JSON.stringify(t)] = n, e._dataByKeyMapLength += n ? 1 : -1)
                    }

                    function x(e, t) {
                        var n = function v(e) {
                            var t = e ? Object.create(Object.getPrototypeOf(e)) : {},
                                n = (0, r.extendFromObject)({}, e);
                            for (var a in n) {
                                var o = n[a];
                                (0, i.isObject)(o) && !(0, i.isPlainObject)(o) && (n[a] = v(o))
                            }
                            return (0, c.deepExtendArraySafe)(t, n, !0, !0), t
                        }(e);
                        return (0, c.deepExtendArraySafe)(n, t, !0, !0)
                    }

                    function y(e) {
                        var t = e.keyInfo,
                            n = e.data,
                            a = e.changes,
                            o = e.groupCount,
                            r = e.useInsertIndex,
                            s = e.immutable,
                            c = e.disableCache,
                            l = e.logError,
                            u = !0 === s ? function(e) {
                                return function(e) {
                                    if (Array.isArray(e)) {
                                        return g(e)
                                    }
                                }(e) || function(e) {
                                    if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                        return Array.from(e)
                                    }
                                }(e) || function(e, t) {
                                    if (!e) {
                                        return
                                    }
                                    if ("string" == typeof e) {
                                        return g(e, t)
                                    }
                                    var n = Object.prototype.toString.call(e).slice(8, -1);
                                    "Object" === n && e.constructor && (n = e.constructor.name);
                                    if ("Map" === n || "Set" === n) {
                                        return Array.from(e)
                                    }
                                    if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                        return g(e, t)
                                    }
                                }(e) || function() {
                                    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                }()
                            }(n) : n;
                        return a.forEach((function(e) {
                            var n = "insert" === e.type ? u : m(t, u, e.key, o);
                            switch (!c && function(e, t) {
                                    if (e.key() && (!t._dataByKeyMap || t._dataByKeyMapLength !== t.length)) {
                                        for (var n = {}, i = t.length, a = 0; a < i; a++) {
                                            n[JSON.stringify(e.keyOf(t[a]))] = t[a]
                                        }
                                        t._dataByKeyMap = n, t._dataByKeyMapLength = i
                                    }
                                }(t, n), e.type) {
                                case "update":
                                    w(t, n, e.key, e.data, !0, s, l);
                                    break;
                                case "insert":
                                    k(t, n, e.data, r && (0, i.isDefined)(e.index) ? e.index : -1, !0, l);
                                    break;
                                case "remove":
                                    S(t, n, e.key, !0, l)
                            }
                        })), u
                    }

                    function b(e, t, n) {
                        return e ? t && s.errors.log(n) : (0, u.rejectedPromise)(s.errors.Error(n))
                    }

                    function w(e, t, n, o, r, s, l) {
                        var d, f = e.key();
                        if (f) {
                            if (function(e, t) {
                                    for (var n = "string" == typeof t ? t.split() : t.slice(); n.length;) {
                                        if (n.shift() in e) {
                                            return !0
                                        }
                                    }
                                    return !1
                                }(o, f) && !(0, u.keysEqual)(f, n, e.keyOf(o))) {
                                return b(r, l, "E4017")
                            }
                            if (d = function(e, t) {
                                    if (e._dataByKeyMap) {
                                        return e._dataByKeyMap[JSON.stringify(t)]
                                    }
                                }(t, n), !d) {
                                var h = C(e, t, n);
                                if (h < 0) {
                                    return b(r, l, "E4009")
                                }
                                if (d = t[h], !0 === s && (0, i.isDefined)(d)) {
                                    var g = x(d, o);
                                    return t[h] = g, !r && (0, u.trivialPromise)(g, n)
                                }
                            }
                        } else {
                            d = n
                        }
                        if ((0, c.deepExtendArraySafe)(d, o, !0), !r) {
                            return (0, a.default)().useLegacyStoreResult ? (0, u.trivialPromise)(n, o) : (0, u.trivialPromise)(d, n)
                        }
                    }

                    function k(e, t, n, c, l, d) {
                        var h, g = e.key(),
                            p = (0, i.isPlainObject)(n) ? (0, r.extend)({}, n) : n;
                        if (g) {
                            if (void 0 === (h = e.keyOf(p)) || "object" === f(h) && (0, i.isEmptyObject)(h)) {
                                if (Array.isArray(g)) {
                                    throw s.errors.Error("E4007")
                                }
                                h = p[g] = String(new o.default)
                            } else if (void 0 !== t[C(e, t, h)]) {
                                return b(l, d, "E4008")
                            }
                        } else {
                            h = p
                        }
                        if (c >= 0 ? t.splice(c, 0, p) : t.push(p), _(t, h, p), !l) {
                            return (0, u.trivialPromise)((0, a.default)().useLegacyStoreResult ? n : p, h)
                        }
                    }

                    function S(e, t, n, i, a) {
                        var o = C(e, t, n);
                        return o > -1 && (t.splice(o, 1), _(t, n, null)), i ? o < 0 ? b(i, a, "E4009") : void 0 : (0, u.trivialPromise)(n)
                    }

                    function C(e, t, n) {
                        var i = e.key();
                        if (! function(e, t) {
                                return !e._dataByKeyMap || e._dataByKeyMap[JSON.stringify(t)]
                            }(t, n)) {
                            return -1
                        }
                        for (var a = 0, o = t.length; a < o; a++) {
                            if ((0, u.keysEqual)(i, e.keyOf(t[a]), n)) {
                                return a
                            }
                        }
                        return -1
                    }
                },
            88036:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/custom_store.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = h(n( /*! ../core/renderer */ 68374)),
                        a = n( /*! ./utils */ 16454),
                        o = n( /*! ./array_utils */ 60637),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = h(n( /*! ../core/config */ 80209)),
                        c = n( /*! ./errors */ 18438),
                        l = h(n( /*! ./abstract_store */ 67403)),
                        u = h(n( /*! ./array_query */ 35042)),
                        d = h(n( /*! ./store_helper */ 99236)),
                        f = n( /*! ../core/utils/deferred */ 62754);

                    function h(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var p = "load";

                    function y(e) {
                        return e && (0, r.isFunction)(e.then)
                    }

                    function b(e) {
                        return (new f.Deferred).resolve(e).promise()
                    }

                    function w(e, t) {
                        if (!(0, r.isFunction)(t)) {
                            throw c.errors.Error("E4011", e)
                        }
                    }

                    function k(e) {
                        throw c.errors.Error("E4012", e)
                    }

                    function S(e) {
                        function t(e) {
                            var t = e[0],
                                n = e[1];
                            return t && t.getResponseHeader ? (0, a.errorMessageFromXhr)(t, n) : null
                        }
                        return function(n) {
                            var i;
                            (i = n instanceof Error ? n : new Error(t(arguments) || n && String(n) || "Unknown error")).message !== a.XHR_ERROR_UNLOAD && e.reject(i)
                        }
                    }

                    function C(e, t) {
                        var n, i = e._loadFunc;
                        return w(p, i), n = i.apply(e, [t]), Array.isArray(n) ? n = b(n) : null == n ? n = b([]) : y(n) || k(p), (0, f.fromPromise)(n)
                    }

                    function A(e, t, n, i) {
                        if (t.__rawData) {
                            i(t.__rawData)
                        } else {
                            var a = t.__rawDataPromise || C(t, n);
                            t._cacheRawData && (t.__rawDataPromise = a), a.always((function() {
                                delete t.__rawDataPromise
                            })).done((function(e) {
                                t._cacheRawData && (t.__rawData = e), i(e)
                            })).fail(S(e))
                        }
                    }

                    function I(e, t, n, a) {
                        var o = {};
                        "userData" in (n = n || {}) && (o.userData = n.userData), A(e, t, o, (function(o) {
                            var r, s, c, l, h = (0, u.default)(o, {
                                    errorHandler: t._errorHandler
                                }),
                                g = [];
                            a || ((r = d.default.queryByOptions(h, n)) === h ? c = o.slice(0) : g.push(r.enumerate().done((function(e) {
                                c = e
                            })))), (n.requireTotalCount || a) && ((s = d.default.queryByOptions(h, n, !0)) === h ? l = o.length : g.push(s.count().done((function(e) {
                                l = e
                            })))), f.when.apply(i.default, g).done((function() {
                                a ? e.resolve(l) : n.requireTotalCount ? e.resolve(c, {
                                    totalCount: l
                                }) : e.resolve(c)
                            })).fail((function(t) {
                                e.reject(t)
                            }))
                        }))
                    }
                    var T = l.default.inherit({
                        ctor: function(e) {
                            e = e || {}, this.callBase(e), this._useDefaultSearch = !!e.useDefaultSearch || "raw" === e.loadMode, this._loadMode = e.loadMode, this._cacheRawData = !1 !== e.cacheRawData, this._loadFunc = e.load, this._totalCountFunc = e.totalCount, this._byKeyFunc = e.byKey, this._insertFunc = e.insert, this._updateFunc = e.update, this._removeFunc = e.remove
                        },
                        createQuery: function() {
                            throw c.errors.Error("E4010")
                        },
                        clearRawDataCache: function() {
                            delete this.__rawData
                        },
                        _totalCountImpl: function(e) {
                            var t = new f.Deferred;
                            return "raw" !== this._loadMode || this._totalCountFunc ? (function(e, t) {
                                var n, i = e._totalCountFunc;
                                if (!(0, r.isFunction)(i)) {
                                    throw c.errors.Error("E4021")
                                }
                                return y(n = i.apply(e, [t])) || (n = Number(n), isFinite(n) || k("totalCount"), n = b(n)), (0, f.fromPromise)(n)
                            }(this, e).done((function(e) {
                                t.resolve(Number(e))
                            })).fail(S(t)), t = this._addFailHandlers(t)) : I(t, this, e, !0), t.promise()
                        },
                        _pushImpl: function(e) {
                            this.__rawData && (0, o.applyBatch)({
                                keyInfo: this,
                                data: this.__rawData,
                                changes: e
                            })
                        },
                        _loadImpl: function(e) {
                            var t = new f.Deferred;
                            return "raw" === this._loadMode ? I(t, this, e, !1) : (C(this, e).done((function(e, n) {
                                t.resolve(e, n)
                            })).fail(S(t)), t = this._addFailHandlers(t)), t.promise()
                        },
                        _byKeyImpl: function(e, t) {
                            var n = new f.Deferred;
                            return this._byKeyViaLoad() ? (this._requireKey(), function(e, t, n) {
                                A(e, t, {}, (function(i) {
                                    for (var o, r = t.key(), s = 0, l = i.length; s < l; s++) {
                                        if (o = i[s], (0, a.keysEqual)(r, t.keyOf(i[s]), n)) {
                                            return void e.resolve(o)
                                        }
                                    }
                                    e.reject(c.errors.Error("E4009"))
                                }))
                            }(n, this, e)) : function(e, t, n) {
                                var i, a = e._byKeyFunc;
                                return w("byKey", a), y(i = a.apply(e, [t, n])) || (i = b(i)), (0, f.fromPromise)(i)
                            }(this, e, t).done((function(e) {
                                n.resolve(e)
                            })).fail(S(n)), n.promise()
                        },
                        _byKeyViaLoad: function() {
                            return "raw" === this._loadMode && !this._byKeyFunc
                        },
                        _insertImpl: function(e) {
                            var t, n = this,
                                i = n._insertFunc,
                                a = new f.Deferred;
                            return w("insert", i), y(t = i.apply(n, [e])) || (t = b(t)), (0, f.fromPromise)(t).done((function(t) {
                                (0, s.default)().useLegacyStoreResult ? a.resolve(e, t) : a.resolve(t || e, n.keyOf(t))
                            })).fail(S(a)), a.promise()
                        },
                        _updateImpl: function(e, t) {
                            var n, i = this._updateFunc,
                                a = new f.Deferred;
                            return w("update", i), y(n = i.apply(this, [e, t])) || (n = b(n)), (0, f.fromPromise)(n).done((function(n) {
                                (0, s.default)().useLegacyStoreResult ? a.resolve(e, t) : a.resolve(n || t, e)
                            })).fail(S(a)), a.promise()
                        },
                        _removeImpl: function(e) {
                            var t, n = this._removeFunc,
                                i = new f.Deferred;
                            return w("remove", n), y(t = n.apply(this, [e])) || (t = b()), (0, f.fromPromise)(t).done((function() {
                                i.resolve(e)
                            })).fail(S(i)), i.promise()
                        }
                    });
                    t.default = T, e.exports = t.default, e.exports.default = t.default
                },
            33546:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./data_source/data_source */ 85273).DataSource;
                    t.default = i, e.exports = t.default, e.exports.default = t.default
                },
            85273:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/data_source.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.DataSource = void 0;
                    var i = v(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = n( /*! ../../core/utils/common */ 20576),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../../core/utils/type */ 35922),
                        c = n( /*! ../utils */ 16454),
                        l = n( /*! ../array_utils */ 60637),
                        u = v(n( /*! ../custom_store */ 88036)),
                        d = n( /*! ../../core/events_strategy */ 80566),
                        f = n( /*! ../errors */ 18438),
                        h = n( /*! ../../core/utils/array */ 89386),
                        g = n( /*! ../../core/utils/queue */ 59504),
                        p = n( /*! ../../core/utils/deferred */ 62754),
                        m = v(n( /*! ./operation_manager */ 88665)),
                        _ = n( /*! ./utils */ 9234);

                    function v(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function y(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var b = i.default.inherit({
                        ctor: function(e) {
                            var t, n = this;
                            if (e = (0, _.normalizeDataSourceOptions)(e), this._eventsStrategy = new d.EventsStrategy(this, {
                                    syncStrategy: !0
                                }), this._store = e.store, this._changedTime = 0, 0 !== e.pushAggregationTimeout) {
                                var i, a, o = void 0 === e.pushAggregationTimeout ? function() {
                                        return 5 * n._changedTime
                                    } : e.pushAggregationTimeout,
                                    s = (0, c.throttleChanges)((function(e) {
                                        i.resolve(), p.when.apply(void 0, function(e) {
                                            return function(e) {
                                                if (Array.isArray(e)) {
                                                    return y(e)
                                                }
                                            }(e) || function(e) {
                                                if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                                    return Array.from(e)
                                                }
                                            }(e) || function(e, t) {
                                                if (!e) {
                                                    return
                                                }
                                                if ("string" == typeof e) {
                                                    return y(e, t)
                                                }
                                                var n = Object.prototype.toString.call(e).slice(8, -1);
                                                "Object" === n && e.constructor && (n = e.constructor.name);
                                                if ("Map" === n || "Set" === n) {
                                                    return Array.from(e)
                                                }
                                                if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                                    return y(e, t)
                                                }
                                            }(e) || function() {
                                                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                                            }()
                                        }(a)).done((function() {
                                            return n._onPush(e)
                                        })), a = void 0, i = void 0
                                    }), o);
                                this._onPushHandler = function(e) {
                                    n._aggregationTimeoutId = s(e.changes), i || (i = new p.Deferred), a = e.waitFor, e.waitFor.push(i.promise())
                                }, this._store.on("beforePush", this._onPushHandler)
                            } else {
                                this._onPushHandler = function(e) {
                                    return n._onPush(e)
                                }, this._store.on("push", this._onPushHandler)
                            }
                            this._storeLoadOptions = this._extractLoadOptions(e), this._mapFunc = e.map, this._postProcessFunc = e.postProcess, this._pageIndex = void 0 !== e.pageIndex ? e.pageIndex : 0, this._pageSize = void 0 !== e.pageSize ? e.pageSize : 20, this._loadingCount = 0, this._loadQueue = this._createLoadQueue(), this._searchValue = "searchValue" in e ? e.searchValue : null, this._searchOperation = e.searchOperation || "contains", this._searchExpr = e.searchExpr, this._paginate = e.paginate, this._reshapeOnPush = null !== (t = e.reshapeOnPush) && void 0 !== t && t, (0, r.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], (function(t, i) {
                                i in e && n.on(i.substr(2, 1).toLowerCase() + i.substr(3), e[i])
                            })), this._operationManager = new m.default, this._init()
                        },
                        _init: function() {
                            this._items = [], this._userData = {}, this._totalCount = -1, this._isLoaded = !1, (0, s.isDefined)(this._paginate) || (this._paginate = !this.group()), this._isLastPage = !this._paginate
                        },
                        dispose: function() {
                            var e;
                            this._store.off("beforePush", this._onPushHandler), this._store.off("push", this._onPushHandler), this._eventsStrategy.dispose(), clearTimeout(this._aggregationTimeoutId), delete this._store, null === (e = this._delayedLoadTask) || void 0 === e || e.abort(), this._operationManager.cancelAll(), this._disposed = !0
                        },
                        _extractLoadOptions: function(e) {
                            var t = {},
                                n = ["sort", "filter", "select", "group", "requireTotalCount"],
                                i = this._store._customLoadOptions();
                            return i && (n = n.concat(i)), (0, r.each)(n, (function() {
                                t[this] = e[this]
                            })), t
                        },
                        loadOptions: function() {
                            return this._storeLoadOptions
                        },
                        items: function() {
                            return this._items
                        },
                        pageIndex: function(e) {
                            if (!(0, s.isNumeric)(e)) {
                                return this._pageIndex
                            }
                            this._pageIndex = e, this._isLastPage = !this._paginate
                        },
                        paginate: function(e) {
                            if (!(0, s.isBoolean)(e)) {
                                return this._paginate
                            }
                            this._paginate !== e && (this._paginate = e, this.pageIndex(0))
                        },
                        pageSize: function(e) {
                            if (!(0, s.isNumeric)(e)) {
                                return this._pageSize
                            }
                            this._pageSize = e
                        },
                        isLastPage: function() {
                            return this._isLastPage
                        },
                        generateStoreLoadOptionAccessor: function(e) {
                            var t = this;
                            return function(n) {
                                var i = (0, _.normalizeStoreLoadOptionAccessorArguments)(n);
                                if (void 0 === i) {
                                    return t._storeLoadOptions[e]
                                }
                                t._storeLoadOptions[e] = i
                            }
                        },
                        sort: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("sort")(t)
                        },
                        filter: function() {
                            var e = (0, _.normalizeStoreLoadOptionAccessorArguments)(arguments);
                            if (void 0 === e) {
                                return this._storeLoadOptions.filter
                            }
                            this._storeLoadOptions.filter = e, this.pageIndex(0)
                        },
                        group: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("group")(t)
                        },
                        select: function() {
                            for (var e = arguments.length, t = new Array(e), n = 0; n < e; n++) {
                                t[n] = arguments[n]
                            }
                            return this.generateStoreLoadOptionAccessor("select")(t)
                        },
                        requireTotalCount: function(e) {
                            if (!(0, s.isBoolean)(e)) {
                                return this._storeLoadOptions.requireTotalCount
                            }
                            this._storeLoadOptions.requireTotalCount = e
                        },
                        searchValue: function(e) {
                            if (arguments.length < 1) {
                                return this._searchValue
                            }
                            this._searchValue = e, this.pageIndex(0)
                        },
                        searchOperation: function(e) {
                            if (!(0, s.isString)(e)) {
                                return this._searchOperation
                            }
                            this._searchOperation = e, this.pageIndex(0)
                        },
                        searchExpr: function(e) {
                            var t = arguments.length;
                            if (0 === t) {
                                return this._searchExpr
                            }
                            t > 1 && (e = [].slice.call(arguments)), this._searchExpr = e, this.pageIndex(0)
                        },
                        store: function() {
                            return this._store
                        },
                        key: function() {
                            var e;
                            return null === (e = this._store) || void 0 === e ? void 0 : e.key()
                        },
                        totalCount: function() {
                            return this._totalCount
                        },
                        isLoaded: function() {
                            return this._isLoaded
                        },
                        isLoading: function() {
                            return this._loadingCount > 0
                        },
                        beginLoading: function() {
                            this._changeLoadingCount(1)
                        },
                        endLoading: function() {
                            this._changeLoadingCount(-1)
                        },
                        _createLoadQueue: function() {
                            return (0, g.create)()
                        },
                        _changeLoadingCount: function(e) {
                            var t = this.isLoading();
                            this._loadingCount += e;
                            var n = this.isLoading();
                            t ^ n && this._eventsStrategy.fireEvent("loadingChanged", [n])
                        },
                        _scheduleLoadCallbacks: function(e) {
                            var t = this;
                            this.beginLoading(), e.always((function() {
                                t.endLoading()
                            }))
                        },
                        _scheduleFailCallbacks: function(e) {
                            var t = this;
                            e.fail((function() {
                                for (var e = arguments.length, n = new Array(e), i = 0; i < e; i++) {
                                    n[i] = arguments[i]
                                }
                                n[0] !== _.CANCELED_TOKEN && t._eventsStrategy.fireEvent("loadError", n)
                            }))
                        },
                        _fireChanged: function(e) {
                            var t = new Date;
                            this._eventsStrategy.fireEvent("changed", e), this._changedTime = new Date - t
                        },
                        _scheduleChangedCallbacks: function(e) {
                            var t = this;
                            e.done((function() {
                                return t._fireChanged()
                            }))
                        },
                        loadSingle: function(e, t) {
                            var n = this,
                                i = new p.Deferred,
                                a = this.key(),
                                o = this._store,
                                r = this._createStoreLoadOptions(),
                                c = function(e) {
                                    !(0, s.isDefined)(e) || (0, h.isEmpty)(e) ? i.reject(new f.errors.Error("E4009")): (Array.isArray(e) || (e = [e]), i.resolve(n._applyMapFunction(e)[0]))
                                };
                            this._scheduleFailCallbacks(i), arguments.length < 2 && (t = e, e = a), delete r.skip, delete r.group, delete r.refresh, delete r.pageIndex, delete r.searchString;
                            var l = function() {
                                return o instanceof u.default && !o._byKeyViaLoad()
                            };
                            return (e === a || l() ? o.byKey(t, r) : (r.take = 1, r.filter = r.filter ? [r.filter, [e, t]] : [e, t], o.load(r))).fail(i.reject).done(c), i.promise()
                        },
                        load: function() {
                            var e = this,
                                t = new p.Deferred,
                                n = function() {
                                    if (!e._disposed && (0, _.isPending)(t)) {
                                        return e._loadFromStore(i, t)
                                    }
                                };
                            this._scheduleLoadCallbacks(t), this._scheduleFailCallbacks(t), this._scheduleChangedCallbacks(t);
                            var i = this._createLoadOperation(t);
                            return this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [i]), this._loadQueue.add((function() {
                                return "number" == typeof i.delay ? e._delayedLoadTask = (0, o.executeAsync)(n, i.delay) : n(), t.promise()
                            })), t.promise({
                                operationId: i.operationId
                            })
                        },
                        _onPush: function(e) {
                            var t = this;
                            if (this._reshapeOnPush) {
                                this.load()
                            } else {
                                this._eventsStrategy.fireEvent("changing", [{
                                    changes: e
                                }]);
                                var n = this.group(),
                                    i = this.items(),
                                    a = 0,
                                    o = this.paginate() || n ? e.filter((function(e) {
                                        return "update" === e.type
                                    })) : e;
                                n && (a = Array.isArray(n) ? n.length : 1), this._mapFunc && o.forEach((function(e) {
                                    "insert" === e.type && (e.data = t._mapFunc(e.data))
                                })), (0, l.applyBatch)({
                                    keyInfo: this.store(),
                                    data: i,
                                    changes: o,
                                    groupCount: a,
                                    useInsertIndex: !0
                                }), this._fireChanged([{
                                    changes: e
                                }])
                            }
                        },
                        _createLoadOperation: function(e) {
                            var t = this,
                                n = this._operationManager.add(e),
                                i = this._createStoreLoadOptions();
                            return e.always((function() {
                                return t._operationManager.remove(n)
                            })), {
                                operationId: n,
                                storeLoadOptions: i
                            }
                        },
                        reload: function() {
                            var e = this.store();
                            return e instanceof u.default && e.clearRawDataCache(), this._init(), this.load()
                        },
                        cancel: function(e) {
                            return this._operationManager.cancel(e)
                        },
                        cancelAll: function() {
                            return this._operationManager.cancelAll()
                        },
                        _addSearchOptions: function(e) {
                            this._disposed || (this.store()._useDefaultSearch ? this._addSearchFilter(e) : (e.searchOperation = this._searchOperation, e.searchValue = this._searchValue, e.searchExpr = this._searchExpr))
                        },
                        _createStoreLoadOptions: function() {
                            var e = (0, a.extend)({}, this._storeLoadOptions);
                            return this._addSearchOptions(e), this._paginate && this._pageSize && (e.skip = this._pageIndex * this._pageSize, e.take = this._pageSize), e.userData = this._userData, e
                        },
                        _addSearchFilter: function(e) {
                            var t = this._searchValue,
                                n = this._searchOperation,
                                i = this._searchExpr,
                                a = [];
                            t && (i || (i = "this"), Array.isArray(i) || (i = [i]), (0, r.each)(i, (function(e, i) {
                                a.length && a.push("or"), a.push([i, n, t])
                            })), e.filter ? e.filter = [a, e.filter] : e.filter = a)
                        },
                        _loadFromStore: function(e, t) {
                            var n = this,
                                i = function(i, o) {
                                    if (!n._disposed && (0, _.isPending)(t)) {
                                        var r = (0, a.extend)((0, _.normalizeLoadResult)(i, o), e);
                                        n._eventsStrategy.fireEvent("customizeLoadResult", [r]), (0, p.when)(r.data).done((function(e) {
                                            r.data = e, n._processStoreLoadResult(r, t)
                                        })).fail(t.reject)
                                    }
                                };
                            return e.data ? (new p.Deferred).resolve(e.data).done(i) : this.store().load(e.storeLoadOptions).done(i).fail(t.reject)
                        },
                        _processStoreLoadResult: function(e, t) {
                            var n = this,
                                i = e.data,
                                a = e.extra,
                                o = e.storeLoadOptions,
                                r = function() {
                                    return n._isLoaded = !0, n._totalCount = isFinite(a.totalCount) ? a.totalCount : -1, t.resolve(i, a)
                                };
                            this._disposed || (i = this._applyPostProcessFunction(this._applyMapFunction(i)), (0, s.isPlainObject)(a) || (a = {}), this._items = i, (!i.length || !this._paginate || this._pageSize && i.length < this._pageSize) && (this._isLastPage = !0), o.requireTotalCount && !isFinite(a.totalCount) ? n.store().totalCount(o).done((function(e) {
                                a.totalCount = e, r()
                            })).fail(t.reject) : r())
                        },
                        _applyMapFunction: function(e) {
                            return this._mapFunc ? (0, _.mapDataRespectingGrouping)(e, this._mapFunc, this.group()) : e
                        },
                        _applyPostProcessFunction: function(e) {
                            return this._postProcessFunc ? this._postProcessFunc(e) : e
                        },
                        on: function(e, t) {
                            return this._eventsStrategy.on(e, t), this
                        },
                        off: function(e, t) {
                            return this._eventsStrategy.off(e, t), this
                        }
                    });
                    t.DataSource = b
                },
            88665:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/operation_manager.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 9234),
                        a = function() {
                            function e() {
                                this._counter = -1, this._deferreds = {}
                            }
                            var t = e.prototype;
                            return t.add = function(e) {
                                return this._counter++, this._deferreds[this._counter] = e, this._counter
                            }, t.remove = function(e) {
                                return delete this._deferreds[e]
                            }, t.cancel = function(e) {
                                return e in this._deferreds && (this._deferreds[e].reject(i.CANCELED_TOKEN), !0)
                            }, t.cancelAll = function() {
                                for (; this._counter > -1;) {
                                    this.cancel(this._counter), this._counter--
                                }
                            }, e
                        }();
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            9234:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/data_source/utils.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.normalizeStoreLoadOptionAccessorArguments = t.normalizeLoadResult = t.normalizeDataSourceOptions = t.mapDataRespectingGrouping = t.isPending = t.CANCELED_TOKEN = void 0;
                    var i = f(n( /*! ../../core/utils/ajax */ 37208)),
                        a = f(n( /*! ../abstract_store */ 67403)),
                        o = f(n( /*! ../array_store */ 26562)),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = f(n( /*! ../custom_store */ 88036)),
                        c = n( /*! ../../core/utils/extend */ 13306),
                        l = n( /*! ../../core/utils/type */ 35922),
                        u = n( /*! ../utils */ 16454),
                        d = ["items"];

                    function f(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function h() {
                        return h = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, h.apply(this, arguments)
                    }
                    t.CANCELED_TOKEN = "canceled";
                    t.isPending = function(e) {
                        return "pending" === e.state()
                    };
                    t.normalizeStoreLoadOptionAccessorArguments = function(e) {
                        switch (e.length) {
                            case 0:
                                return;
                            case 1:
                                return e[0]
                        }
                        return [].slice.call(e)
                    };
                    var p = function(e, t, n) {
                            return (0, r.map)(e, (function(e) {
                                e.items;
                                return h({}, function(e, t) {
                                    if (null == e) {
                                        return {}
                                    }
                                    var n, i, a = function(e, t) {
                                        if (null == e) {
                                            return {}
                                        }
                                        var n, i, a = {},
                                            o = Object.keys(e);
                                        for (i = 0; i < o.length; i++) {
                                            n = o[i], t.indexOf(n) >= 0 || (a[n] = e[n])
                                        }
                                        return a
                                    }(e, t);
                                    if (Object.getOwnPropertySymbols) {
                                        var o = Object.getOwnPropertySymbols(e);
                                        for (i = 0; i < o.length; i++) {
                                            n = o[i], t.indexOf(n) >= 0 || Object.prototype.propertyIsEnumerable.call(e, n) && (a[n] = e[n])
                                        }
                                    }
                                    return a
                                }(e, d), {
                                    items: m(e.items, t - 1, n)
                                })
                            }))
                        },
                        m = function(e, t, n) {
                            return Array.isArray(e) ? t ? p(e, t, n) : (0, r.map)(e, n) : e
                        };
                    t.mapDataRespectingGrouping = function(e, t, n) {
                        var i = n ? (0, u.normalizeSortingInfo)(n).length : 0;
                        return m(e, i, t)
                    };
                    t.normalizeLoadResult = function(e, t) {
                        var n;
                        return null !== (n = e) && void 0 !== n && n.data && (t = e, e = e.data), Array.isArray(e) || (e = [e]), {
                            data: e,
                            extra: t
                        }
                    };
                    var _ = function(e, t) {
                        return new s.default({
                            load: function() {
                                return i.default.sendRequest({
                                    url: e,
                                    dataType: "json"
                                })
                            },
                            loadMode: null == t ? void 0 : t.fromUrlLoadMode
                        })
                    };
                    t.normalizeDataSourceOptions = function(e, t) {
                        var n, i, u;
                        return "string" == typeof e && (e = {
                            paginate: !1,
                            store: _(e, t)
                        }), void 0 === e && (e = []), void 0 === (e = Array.isArray(e) || e instanceof a.default ? {
                            store: e
                        } : (0, c.extend)({}, e)).store && (e.store = []), n = e.store, "load" in e ? n = function(e) {
                            var t = {};
                            return (0, r.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], (function() {
                                t[this] = e[this], delete e[this]
                            })), new s.default(t)
                        }(e) : Array.isArray(n) ? n = new o.default(n) : (0, l.isPlainObject)(n) && (i = (0, c.extend)({}, n), u = i.type, delete i.type, n = a.default.create(u, i)), e.store = n, e
                    }
                },
            8162:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/endpoint_selector.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ../core/errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    var o, r, s = (0, n( /*! ../core/utils/window */ 58201).getWindow)();
                    var c = function(e) {
                        var t;
                        this.config = e, o = "ms-appx:" === s.location.protocol, t = s.location.hostname, r = /^(localhost$|127\.)/i.test(t)
                    };
                    c.prototype = {
                        urlFor: function(e) {
                            var t = this.config[e];
                            if (!t) {
                                throw a.default.Error("E0006")
                            }
                            return t.production && (o && !Debug.debuggerEnabled || !o && !r) ? t.production : t.local
                        }
                    };
                    var l = c;
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            18438:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/errors.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.setErrorHandler = t.handleError = t.errors = t.errorHandler = void 0;
                    var i = o(n( /*! ../core/utils/error */ 95640)),
                        a = o(n( /*! ../core/errors */ 17381));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = (0, i.default)(a.default.ERROR_MESSAGES, {
                        E4000: "[DevExpress.data]: {0}",
                        E4001: "Unknown aggregating function is detected: '{0}'",
                        E4002: "Unsupported OData protocol version is used",
                        E4003: "Unknown filter operation is used: {0}",
                        E4004: "The thenby() method is called before the sortby() method",
                        E4005: "Store requires a key expression for this operation",
                        E4006: "ArrayStore 'data' option must be an array",
                        E4007: "Compound keys cannot be auto-generated",
                        E4008: "Attempt to insert an item with a duplicated key",
                        E4009: "Data item cannot be found",
                        E4010: "CustomStore does not support creating queries",
                        E4011: "Custom Store method is not implemented or is not a function: {0}",
                        E4012: "Custom Store method returns an invalid value: {0}",
                        E4013: "Local Store requires the 'name' configuration option is specified",
                        E4014: "Unknown data type is specified for ODataStore: {0}",
                        E4015: "Unknown entity name or alias is used: {0}",
                        E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
                        E4017: "Keys cannot be modified",
                        E4018: "The server has returned a non-numeric value in a response to an item count request",
                        E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
                        E4020: "Unknown store type is detected: {0}",
                        E4021: "The server response does not provide the totalCount value",
                        E4022: "The server response does not provide the groupCount value",
                        E4023: "Could not parse the following XML: {0}",
                        E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
                        W4000: "Data returned from the server has an incorrect structure",
                        W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
                        W4002: "Data loading has failed for some cells due to the following error: {0}"
                    });
                    t.errors = r;
                    var s = null;
                    t.errorHandler = s;
                    t.handleError = function(e) {
                        var t;
                        null === (t = s) || void 0 === t || t(e)
                    };
                    t.setErrorHandler = function(e) {
                        return t.errorHandler = s = e
                    }
                },
            82837:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/local_store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = l(n( /*! ../events/core/events_engine */ 55994)),
                        a = l(n( /*! ../core/dom_adapter */ 73349)),
                        o = n( /*! ../core/utils/window */ 58201),
                        r = l(n( /*! ../core/class */ 38377)),
                        s = n( /*! ./errors */ 18438),
                        c = l(n( /*! ./array_store */ 26562));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = (0, o.getWindow)(),
                        d = r.default.abstract,
                        f = {
                            dom: r.default.inherit({
                                ctor: function(e, t) {
                                    this._store = e, this._dirty = !!t.data, this.save();
                                    var n = this._immediate = t.immediate,
                                        o = Math.max(100, t.flushInterval || 1e4);
                                    if (!n) {
                                        var r = this.save.bind(this);
                                        setInterval(r, o), i.default.on(u, "beforeunload", r), u.cordova && a.default.listen(a.default.getDocument(), "pause", r, !1)
                                    }
                                },
                                notifyChanged: function() {
                                    this._dirty = !0, this._immediate && this.save()
                                },
                                load: function() {
                                    this._store._array = this._loadImpl(), this._dirty = !1
                                },
                                save: function() {
                                    this._dirty && (this._saveImpl(this._store._array), this._dirty = !1)
                                },
                                _loadImpl: d,
                                _saveImpl: d
                            }).inherit({
                                ctor: function(e, t) {
                                    var n = t.name;
                                    if (!n) {
                                        throw s.errors.Error("E4013")
                                    }
                                    this._key = "dx-data-localStore-" + n, this.callBase(e, t)
                                },
                                _loadImpl: function() {
                                    var e = u.localStorage.getItem(this._key);
                                    return e ? JSON.parse(e) : []
                                },
                                _saveImpl: function(e) {
                                    e.length ? u.localStorage.setItem(this._key, JSON.stringify(e)) : u.localStorage.removeItem(this._key)
                                }
                            })
                        },
                        h = c.default.inherit({
                            ctor: function(e) {
                                e = "string" == typeof e ? {
                                    name: e
                                } : e || {}, this.callBase(e), this._backend = new f[e.backend || "dom"](this, e), this._backend.load()
                            },
                            clear: function() {
                                this.callBase(), this._backend.notifyChanged()
                            },
                            _insertImpl: function(e) {
                                var t = this._backend;
                                return this.callBase(e).done(t.notifyChanged.bind(t))
                            },
                            _updateImpl: function(e, t) {
                                var n = this._backend;
                                return this.callBase(e, t).done(n.notifyChanged.bind(n))
                            },
                            _removeImpl: function(e) {
                                var t = this._backend;
                                return this.callBase(e).done(t.notifyChanged.bind(t))
                            }
                        }, "local");
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            47256:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/context.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = f(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = n( /*! ../../core/utils/type */ 35922),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../errors */ 18438),
                        c = f(n( /*! ./store */ 341)),
                        l = f(n( /*! ./request_dispatcher */ 63081)),
                        u = n( /*! ./utils */ 77869),
                        d = n( /*! ../../core/utils/deferred */ 62754);

                    function f(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var h = i.default.inherit({
                            ctor: function(e) {
                                var t = this;
                                this._requestDispatcher = new l.default(e), this._errorHandler = e.errorHandler, (0, r.each)(e.entities || [], (function(n, i) {
                                    t[n] = new c.default((0, a.extend)({}, e, {
                                        url: "".concat(t._requestDispatcher.url, "/").concat(encodeURIComponent(i.name || n))
                                    }, i))
                                }))
                            },
                            get: function(e, t) {
                                return this.invoke(e, t, "GET")
                            },
                            invoke: function(e) {
                                var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                    n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : "POST";
                                n = n.toLowerCase();
                                var i, a = new d.Deferred,
                                    r = "".concat(this._requestDispatcher.url, "/").concat(encodeURIComponent(e));
                                return 4 === this.version() && ("get" === n ? (r = (0, u.formatFunctionInvocationUrl)(r, (0, u.escapeServiceOperationParams)(t, this.version())), t = null) : "post" === n && (i = t, t = null)), (0, d.when)(this._requestDispatcher.sendRequest(r, n, (0, u.escapeServiceOperationParams)(t, this.version()), i)).done((function(t) {
                                    (0, o.isPlainObject)(t) && e in t && (t = t[e]), a.resolve(t)
                                })).fail(this._errorHandler).fail(s.handleError).fail(a.reject), a.promise()
                            },
                            objectLink: function(e, t) {
                                var n = this[e];
                                if (!n) {
                                    throw s.errors.Error("E4015", e)
                                }
                                return (0, o.isDefined)(t) ? {
                                    __metadata: {
                                        uri: n._byKeyUrl(t)
                                    }
                                } : null
                            },
                            version: function() {
                                return this._requestDispatcher.version
                            }
                        }),
                        g = h;
                    t.default = g, e.exports = t.default, e.exports.default = t.default
                },
            54263:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/query_adapter.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.odata = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ../../core/utils/iterator */ 95479),
                        o = d(n( /*! ../../core/config */ 80209)),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = d(n( /*! ../query_adapters */ 16135)),
                        c = n( /*! ./utils */ 77869),
                        l = n( /*! ../errors */ 18438),
                        u = n( /*! ../utils */ 16454);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f, h, g, p, m, _, v, x, y, b, w, k, S = ["contains", "notcontains", "startswith", "endswith"],
                        C = (m = function(e, t) {
                            return function(n, i) {
                                var a = [e, "("];
                                return h && (n = -1 === n.indexOf("tolower(") ? "tolower(".concat(n, ")") : n, i = i.toLowerCase()), t ? a.push(i, ",", n) : a.push(n, ",", i), a.push(")"), a.join("")
                            }
                        }, _ = {
                            "=": (p = function(e) {
                                return function(t, n) {
                                    return "".concat(t, " ").concat(e, " ").concat(n)
                                }
                            })("eq"),
                            "<>": p("ne"),
                            ">": p("gt"),
                            ">=": p("ge"),
                            "<": p("lt"),
                            "<=": p("le"),
                            startswith: m("startswith"),
                            endswith: m("endswith")
                        }, v = (0, r.extend)({}, _, {
                            contains: m("substringof", !0),
                            notcontains: m("not substringof", !0)
                        }), x = (0, r.extend)({}, _, {
                            contains: m("contains"),
                            notcontains: m("not contains")
                        }), y = function(e) {
                            var t, n, i = (e = (0, u.normalizeBinaryCriterion)(e))[1],
                                a = e[0],
                                o = g && g[a];
                            if (o && (n = i, S.some((function(e) {
                                    return e === n
                                }))) && "String" !== o) {
                                throw new l.errors.Error("E4024", i, a, o)
                            }
                            var r = (4 === f ? x : v)[i.toLowerCase()];
                            if (!r) {
                                throw l.errors.Error("E4003", i)
                            }
                            var s = e[2];
                            return null !== (t = g) && void 0 !== t && t[a] && (s = (0, c.convertPrimitiveValue)(g[a], s)), r((0, c.serializePropName)(a), (0, c.serializeValue)(s, f))
                        }, b = function(e) {
                            var t = e[0],
                                n = k(e[1]);
                            if ("!" === t) {
                                return "not (".concat(n, ")")
                            }
                            throw l.errors.Error("E4003", t)
                        }, w = function(e) {
                            var t, n, i = [];
                            return (0, a.each)(e, (function(e, a) {
                                if (Array.isArray(a)) {
                                    if (i.length > 1 && t !== n) {
                                        throw new l.errors.Error("E4019")
                                    }
                                    i.push("(".concat(k(a), ")")), t = n, n = "and"
                                } else {
                                    n = (0, u.isConjunctiveOperator)(this) ? "and" : "or"
                                }
                            })), i.join(" ".concat(t, " "))
                        }, k = function(e) {
                            return Array.isArray(e[0]) ? w(e) : (0, u.isUnaryOperation)(e) ? b(e) : y(e)
                        }, function(e, t, n, i) {
                            return g = n, h = null != i ? i : (0, o.default)().oDataFilterToLower, f = t, k(e)
                        }),
                        A = function(e) {
                            var t, n, a, o, s = [],
                                l = [],
                                u = e.expand,
                                d = e.version || 2,
                                f = function() {
                                    return n || void 0 !== a
                                },
                                h = function e(t) {
                                    for (var n = 0; n < t.length; n++) {
                                        if ((0, i.isFunction)(t[n])) {
                                            return !0
                                        }
                                        if (Array.isArray(t[n]) && e(t[n])) {
                                            return !0
                                        }
                                    }
                                    return !1
                                },
                                g = function() {
                                    var i = {};
                                    if (o || (s.length && (i.$orderby = s.join(",")), n && (i.$skip = n), void 0 !== a && (i.$top = a), i.$select = (0, c.generateSelect)(d, t) || void 0, i.$expand = (0, c.generateExpand)(d, u, t) || void 0), l.length) {
                                        var r = l.length < 2 ? l[0] : l,
                                            f = null == e ? void 0 : e.fieldTypes,
                                            h = null == e ? void 0 : e.filterToLower;
                                        i.$filter = C(r, d, f, h)
                                    }
                                    return o && (i.$top = 0), (e.requireTotalCount || o) && (4 !== d ? i.$inlinecount = "allpages" : i.$count = "true"), i
                                };
                            return {
                                optimize: function(e) {
                                    for (var t = -1, n = 0; n < e.length; n++) {
                                        if ("select" === e[n].name) {
                                            t = n;
                                            break
                                        }
                                    }
                                    if (!(t < 0) && (0, i.isFunction)(e[t].args[0])) {
                                        var a = e[1 + t];
                                        a && "slice" === a.name && (e[1 + t] = e[t], e[t] = a)
                                    }
                                },
                                exec: function(t) {
                                    return (0, c.sendRequest)(d, {
                                        url: t,
                                        params: (0, r.extend)(g(), null == e ? void 0 : e.params)
                                    }, {
                                        beforeSend: e.beforeSend,
                                        jsonp: e.jsonp,
                                        withCredentials: e.withCredentials,
                                        countOnly: o,
                                        deserializeDates: e.deserializeDates,
                                        fieldTypes: e.fieldTypes,
                                        isPaged: isFinite(a)
                                    })
                                },
                                multiSort: function(e) {
                                    var t;
                                    if (f()) {
                                        return !1
                                    }
                                    for (var n = 0; n < e.length; n++) {
                                        var i = e[n][0],
                                            a = !!e[n][1],
                                            o = void 0;
                                        if ("string" != typeof i) {
                                            return !1
                                        }
                                        o = (0, c.serializePropName)(i), a && (o += " desc"), (t = t || []).push(o)
                                    }
                                    s = t
                                },
                                slice: function(e, t) {
                                    if (f()) {
                                        return !1
                                    }
                                    n = e, a = t
                                },
                                filter: function(e) {
                                    return !f() && (Array.isArray(e) || (e = [].slice.call(arguments)), !h(e) && (l.length && l.push("and"), void l.push(e)))
                                },
                                select: function(e) {
                                    if (t || (0, i.isFunction)(e)) {
                                        return !1
                                    }
                                    Array.isArray(e) || (e = [].slice.call(arguments)), t = e
                                },
                                count: function() {
                                    return o = !0
                                }
                            }
                        };
                    s.default.odata = A;
                    var I = A;
                    t.odata = I
                },
            63081:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/request_dispatcher.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils */ 77869);

                    function a(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            var i = t[n];
                            i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var o = function() {
                        function e(e) {
                            e = e || {}, this._url = String(e.url).replace(/\/+$/, ""), this._beforeSend = e.beforeSend, this._jsonp = e.jsonp, this._version = e.version || 2, this._withCredentials = e.withCredentials, this._deserializeDates = e.deserializeDates, this._filterToLower = e.filterToLower
                        }
                        var t, n, o;
                        return e.prototype.sendRequest = function(e, t, n, a) {
                            return (0, i.sendRequest)(this.version, {
                                url: e,
                                method: t,
                                params: n || {},
                                payload: a
                            }, {
                                beforeSend: this._beforeSend,
                                jsonp: this._jsonp,
                                withCredentials: this._withCredentials,
                                deserializeDates: this._deserializeDates
                            })
                        }, t = e, (n = [{
                            key: "version",
                            get: function() {
                                return this._version
                            }
                        }, {
                            key: "beforeSend",
                            get: function() {
                                return this._beforeSend
                            }
                        }, {
                            key: "url",
                            get: function() {
                                return this._url
                            }
                        }, {
                            key: "jsonp",
                            get: function() {
                                return this._jsonp
                            }
                        }, {
                            key: "filterToLower",
                            get: function() {
                                return this._filterToLower
                            }
                        }]) && a(t.prototype, n), o, e
                    }();
                    t.default = o, e.exports = t.default, e.exports.default = t.default
                },
            341:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/store.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = d(n( /*! ../../core/config */ 80209)),
                        o = n( /*! ./utils */ 77869),
                        r = n( /*! ../errors */ 18438),
                        s = d(n( /*! ../query */ 96687)),
                        c = d(n( /*! ../abstract_store */ 67403)),
                        l = d(n( /*! ./request_dispatcher */ 63081)),
                        u = n( /*! ../../core/utils/deferred */ 62754);

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ./query_adapter */ 54263);
                    var h = c.default.inherit({
                        ctor: function(e) {
                            this.callBase(e), this._requestDispatcher = new l.default(e);
                            var t = this.key(),
                                n = e.fieldTypes,
                                i = e.keyType;
                            if (i) {
                                var a = "string" == typeof i;
                                t || (t = a ? "5d46402c-7899-4ea9-bd81-8b73c47c7683" : Object.keys(i), this._legacyAnonymousKey = t), a && (i = function(e, t) {
                                    return function(e, t, n) {
                                        return t in e ? Object.defineProperty(e, t, {
                                            value: n,
                                            enumerable: !0,
                                            configurable: !0,
                                            writable: !0
                                        }) : e[t] = n, e
                                    }({}, e, t)
                                }(t, i)), n = function(e, t) {
                                    var n = {};
                                    for (var i in e) {
                                        n[i] = e[i]
                                    }
                                    for (var a in t) {
                                        a in n ? n[a] !== t[a] && r.errors.log("W4001", a) : n[a] = t[a]
                                    }
                                    return n
                                }(n, i)
                            }
                            this._fieldTypes = n || {}, 2 === this.version() ? this._updateMethod = "MERGE" : this._updateMethod = "PATCH"
                        },
                        _customLoadOptions: function() {
                            return ["expand", "customQueryParams"]
                        },
                        _byKeyImpl: function(e, t) {
                            var n = {};
                            return t && (n.$expand = (0, o.generateExpand)(this.version(), t.expand, t.select) || void 0, n.$select = (0, o.generateSelect)(this.version(), t.select) || void 0), this._requestDispatcher.sendRequest(this._byKeyUrl(e), "GET", n)
                        },
                        createQuery: function(e) {
                            var t, n, a = {
                                adapter: "odata",
                                beforeSend: this._requestDispatcher.beforeSend,
                                errorHandler: this._errorHandler,
                                jsonp: this._requestDispatcher.jsonp,
                                version: this._requestDispatcher.version,
                                withCredentials: this._requestDispatcher._withCredentials,
                                expand: null == e ? void 0 : e.expand,
                                requireTotalCount: null == e ? void 0 : e.requireTotalCount,
                                deserializeDates: this._requestDispatcher._deserializeDates,
                                fieldTypes: this._fieldTypes
                            };
                            if (n = null !== (t = null == e ? void 0 : e.urlOverride) && void 0 !== t ? t : this._requestDispatcher.url, (0, i.isDefined)(this._requestDispatcher.filterToLower) && (a.filterToLower = this._requestDispatcher.filterToLower), null != e && e.customQueryParams) {
                                var r = (0, o.escapeServiceOperationParams)(null == e ? void 0 : e.customQueryParams, this.version());
                                4 === this.version() ? n = (0, o.formatFunctionInvocationUrl)(n, r) : a.params = r
                            }
                            return (0, s.default)(n, a)
                        },
                        _insertImpl: function(e) {
                            var t = this;
                            this._requireKey();
                            var n = new u.Deferred;
                            return (0, u.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url, "POST", null, e)).done((function(i) {
                                return n.resolve(i && !(0, a.default)().useLegacyStoreResult ? i : e, t.keyOf(i))
                            })).fail(n.reject), n.promise()
                        },
                        _updateImpl: function(e, t) {
                            var n = new u.Deferred;
                            return (0, u.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e), this._updateMethod, null, t)).done((function(i) {
                                return (0, a.default)().useLegacyStoreResult ? n.resolve(e, t) : n.resolve(i || t, e)
                            })).fail(n.reject), n.promise()
                        },
                        _removeImpl: function(e) {
                            var t = new u.Deferred;
                            return (0, u.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e), "DELETE")).done((function() {
                                return t.resolve(e)
                            })).fail(t.reject), t.promise()
                        },
                        _convertKey: function(e) {
                            var t = e,
                                n = this._fieldTypes,
                                i = this.key() || this._legacyAnonymousKey;
                            if (Array.isArray(i)) {
                                t = {};
                                for (var a = 0; a < i.length; a++) {
                                    var r = i[a];
                                    t[r] = (0, o.convertPrimitiveValue)(n[r], e[r])
                                }
                            } else {
                                n[i] && (t = (0, o.convertPrimitiveValue)(n[i], e))
                            }
                            return t
                        },
                        _byKeyUrl: function(e) {
                            var t = this._requestDispatcher.url,
                                n = this._convertKey(e);
                            return "".concat(t, "(").concat(encodeURIComponent((0, o.serializeKey)(n, this.version())), ")")
                        },
                        version: function() {
                            return this._requestDispatcher.version
                        }
                    }, "odata");
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            77869:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/odata/utils.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    t.serializeValue = t.serializePropName = t.serializeKey = t.sendRequest = t.keyConverters = t.generateSelect = t.generateExpand = t.formatFunctionInvocationUrl = t.escapeServiceOperationParams = t.convertPrimitiveValue = t.EdmLiteral = void 0;
                    var i = g(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = n( /*! ../../core/utils/type */ 35922),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = g(n( /*! ../../core/utils/ajax */ 37208)),
                        c = g(n( /*! ../../core/guid */ 73176)),
                        l = n( /*! ../../core/utils/common */ 20576),
                        u = n( /*! ../../core/utils/deferred */ 62754),
                        d = n( /*! ../errors */ 18438),
                        f = n( /*! ../utils */ 16454),
                        h = n( /*! ../../core/utils/string */ 68752);

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function p(e) {
                        return p = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, p(e)
                    }
                    var m = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,
                        _ = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,
                        v = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,
                        x = "application/json;odata=verbose",
                        y = function(e) {
                            return "string" === (0, o.type)(e) ? e.split() : e
                        },
                        b = function(e) {
                            return /\./.test(e)
                        },
                        w = function(e, t, n) {
                            for (e = String(e); e.length < t;) {
                                e = n ? "".concat(e, "0") : "0".concat(e)
                            }
                            return e
                        },
                        k = function(e, t, n) {
                            var i = [],
                                a = function(e) {
                                    return w(e, 2)
                                };
                            return i.push(e.getFullYear()), i.push("-"), i.push(a(e.getMonth() + 1)), i.push("-"), i.push(a(e.getDate())), t && e.getHours() + e.getMinutes() + e.getSeconds() + e.getMilliseconds() < 1 || (i.push("T"), i.push(a(e.getHours())), i.push(":"), i.push(a(e.getMinutes())), i.push(":"), i.push(a(e.getSeconds())), e.getMilliseconds() && (i.push("."), i.push(w(e.getMilliseconds(), 3))), n || i.push("Z")), i.join("")
                        },
                        S = function(e) {
                            var t = new Date(60 * new Date(0).getTimezoneOffset() * 1e3),
                                n = e.replace("Z", "").split("T"),
                                i = /(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),
                                a = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);
                            if (t.setFullYear(Number(i[1])), t.setMonth(Number(i[2]) - 1), t.setDate(Number(i[3])), Array.isArray(a) && a.length) {
                                t.setHours(Number(a[1])), t.setMinutes(Number(a[2])), t.setSeconds(Number(a[3]));
                                var o = (a[4] || "").slice(0, 3);
                                o = w(o, 3, !0), t.setMilliseconds(Number(o))
                            }
                            return t
                        },
                        C = function(e) {
                            var t = [];
                            for (var n in e) {
                                t.push(n + "=" + e[n])
                            }
                            return t.join("&")
                        };
                    t.sendRequest = function e(t, n, i) {
                        var o = i.deserializeDates,
                            r = i.fieldTypes,
                            c = i.countOnly,
                            l = i.isPaged,
                            h = new u.Deferred,
                            g = function(e, t) {
                                var n, i = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                    o = function(t) {
                                        return JSON.stringify(t, (function(t, n) {
                                            if (!(this[t] instanceof Date)) {
                                                return n
                                            }
                                            switch (n = k(this[t]), e) {
                                                case 2:
                                                    return n.substr(0, n.length - 1);
                                                case 3:
                                                case 4:
                                                    return n;
                                                default:
                                                    throw d.errors.Error("E4002")
                                            }
                                        }))
                                    };
                                t = (0, a.extend)({
                                    async: !0,
                                    method: "get",
                                    url: "",
                                    params: {},
                                    payload: null,
                                    headers: {},
                                    timeout: 3e4
                                }, t), null === (n = i.beforeSend) || void 0 === n || n.call(i, t);
                                var r = t,
                                    s = r.async,
                                    c = r.timeout,
                                    l = r.headers,
                                    u = t,
                                    f = u.url,
                                    h = u.method,
                                    g = i.jsonp,
                                    p = i.withCredentials,
                                    m = "get" === (h = (h || "get").toLowerCase()),
                                    _ = m && g,
                                    v = (0, a.extend)({}, t.params),
                                    y = m ? v : o(t.payload),
                                    b = !m && C(v),
                                    w = !m && x;
                                return b && (f += (f.indexOf("?") > -1 ? "&" : "?") + b), _ && (y.$format = "json"), {
                                    url: f,
                                    data: y,
                                    dataType: _ ? "jsonp" : "json",
                                    jsonp: _ && "$callback",
                                    method: h,
                                    async: s,
                                    timeout: c,
                                    headers: l,
                                    contentType: w,
                                    accepts: {
                                        json: [x, "text/plain"].join()
                                    },
                                    xhrFields: {
                                        withCredentials: p
                                    }
                                }
                            }(t, n, i);
                        return s.default.sendRequest(g).always((function(n, a) {
                            var s = A(n, a, {
                                    deserializeDates: o,
                                    fieldTypes: r
                                }, g),
                                u = s.error,
                                p = s.data,
                                m = s.count,
                                _ = s.nextUrl;
                            if (u) {
                                u.message !== f.XHR_ERROR_UNLOAD && h.reject(u)
                            } else if (c) {
                                isFinite(m) ? h.resolve(m) : h.reject(new d.errors.Error("E4018"))
                            } else if (_ && !l) {
                                /^(?:[a-z]+:)?\/\//i.test(_) || (_ = function(e, t) {
                                    var n, i, a, o = (i = e, a = i.indexOf("?"), a > -1 ? i.substr(0, a) : i).split("/"),
                                        r = t.split("/");
                                    for (o.pop(); r.length;) {
                                        ".." === (n = r.shift()) ? o.pop(): o.push(n)
                                    }
                                    return o.join("/")
                                }(g.url, _)), e(t, {
                                    url: _
                                }, i).fail(h.reject).done((function(e) {
                                    return h.resolve(p.concat(e))
                                }))
                            } else {
                                var v = isFinite(m) ? {
                                    totalCount: m
                                } : void 0;
                                h.resolve(p, v)
                            }
                        })), h.promise()
                    };
                    var A = function(e, t, n, i) {
                            var r = function(e, t, n) {
                                var i, o, r, s;
                                if ("nocontent" === t) {
                                    return null
                                }
                                var c = "Unknown error",
                                    l = e,
                                    u = 200,
                                    d = {
                                        requestOptions: n
                                    };
                                if ("success" !== t) {
                                    var h = e.status,
                                        g = e.responseText;
                                    u = h, c = (0, f.errorMessageFromXhr)(e, t);
                                    try {
                                        l = JSON.parse(g)
                                    } catch (e) {}
                                }
                                var p = (null === (i = l) || void 0 === i ? void 0 : i.then) || (null === (o = l) || void 0 === o ? void 0 : o.error) || (null === (r = l) || void 0 === r ? void 0 : r["odata.error"]) || (null === (s = l) || void 0 === s ? void 0 : s["@odata.error"]);
                                if (p) {
                                    c = function(e) {
                                        var t, n, i = e;
                                        "message" in e && (t = (null === (n = e.message) || void 0 === n ? void 0 : n.value) || e.message);
                                        for (;
                                            (i = i.innererror || i.internalexception) && (t = i.message, !i.internalexception || -1 !== t.indexOf("inner exception"));) {}
                                        return t
                                    }(p) || c, d.errorDetails = p, 200 === u && (u = 500);
                                    var m = Number(p.code);
                                    isFinite(m) && m >= 400 && (u = m)
                                }
                                return u >= 400 || 0 === u ? (d.httpStatus = u, (0, a.extend)(Error(c), d)) : null
                            }(e, t, i);
                            if (r) {
                                return {
                                    error: r
                                }
                            }
                            if (!(0, o.isPlainObject)(e)) {
                                return {
                                    data: e
                                }
                            }
                            var s = "d" in e && (Array.isArray(e.d) || (0, o.isObject)(e.d)) ? I(e, t) : T(e, t);
                            return O(s, n), s
                        },
                        I = function(e) {
                            var t, n = e.d;
                            return (0, o.isDefined)(n) ? {
                                data: null !== (t = n.results) && void 0 !== t ? t : n,
                                nextUrl: n.__next,
                                count: parseInt(n.__count, 10)
                            } : {
                                error: Error("Malformed or unsupported JSON response received")
                            }
                        },
                        T = function(e) {
                            var t;
                            return {
                                data: null !== (t = e.value) && void 0 !== t ? t : e,
                                nextUrl: e["@odata.nextLink"],
                                count: parseInt(e["@odata.count"], 10)
                            }
                        },
                        E = i.default.inherit({
                            ctor: function(e) {
                                this._value = e
                            },
                            valueOf: function() {
                                return this._value
                            }
                        });
                    t.EdmLiteral = E;
                    var O = function e(t) {
                            var n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                            (0, r.each)(t, (function(i, a) {
                                if (null !== a && "object" === p(a)) {
                                    "results" in a && (t[i] = a.results), e(t[i], n)
                                } else if ("string" == typeof a) {
                                    var o = n.fieldTypes,
                                        r = n.deserializeDates;
                                    if ((!o || "String" !== o[i]) && m.test(a) && (t[i] = new c.default(a)), !1 !== r) {
                                        if (a.match(_)) {
                                            var s = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                            t[i] = new Date(s.valueOf() + 60 * s.getTimezoneOffset() * 1e3)
                                        } else {
                                            v.test(a) && (t[i] = new Date(S(t[i]).valueOf()))
                                        }
                                    }
                                }
                            }))
                        },
                        D = function(e) {
                            return e instanceof E ? e.valueOf() : e.replace(/\./g, "/")
                        };
                    t.serializePropName = D;
                    var P = function(e) {
                            return e instanceof Date ? "datetime'".concat(k(e, !0, !0), "'") : e instanceof c.default ? "guid'".concat(e, "'") : e instanceof E ? e.valueOf() : "string" == typeof e ? function(e) {
                                return "'".concat(e.replace(/'/g, "''"), "'")
                            }(e) : String(e)
                        },
                        R = function(e, t) {
                            switch (t) {
                                case 2:
                                case 3:
                                    return P(e);
                                case 4:
                                    return function e(t) {
                                        return t instanceof Date ? k(t, !1, !1) : t instanceof c.default ? t.valueOf() : Array.isArray(t) ? "[".concat(t.map((function(t) {
                                            return e(t)
                                        })).join(","), "]") : P(t)
                                    }(e);
                                default:
                                    throw d.errors.Error("E4002")
                            }
                        };
                    t.serializeValue = R;
                    t.serializeKey = function(e, t) {
                        if ((0, o.isPlainObject)(e)) {
                            var n = [];
                            return (0, r.each)(e, (function(e, i) {
                                return n.push("".concat(D(e), "=").concat(R(i, t)))
                            })), n.join()
                        }
                        return R(e, t)
                    };
                    var q = {
                        String: function(e) {
                            return "".concat(e)
                        },
                        Int32: function(e) {
                            return Math.floor(e)
                        },
                        Int64: function(e) {
                            return e instanceof E ? e : new E("".concat(e, "L"))
                        },
                        Guid: function(e) {
                            return e instanceof c.default ? e : new c.default(e)
                        },
                        Boolean: function(e) {
                            return !!e
                        },
                        Single: function(e) {
                            return e instanceof E ? e : new E(e + "f")
                        },
                        Decimal: function(e) {
                            return e instanceof E ? e : new E(e + "m")
                        }
                    };
                    t.keyConverters = q;
                    t.convertPrimitiveValue = function(e, t) {
                        if (null === t) {
                            return null
                        }
                        var n = q[e];
                        if (!n) {
                            throw d.errors.Error("E4014", e)
                        }
                        return n(t)
                    };
                    t.generateSelect = function(e, t) {
                        if (t) {
                            return e < 4 ? D(t.join()) : (0, l.grep)(t, b, !0).join()
                        }
                    };
                    var L = function(e) {
                            var t = [];
                            return (0, r.each)(e, (function(e, n) {
                                return t.push("".concat(e).concat(function e(t) {
                                    var n = "",
                                        i = [],
                                        a = [];
                                    return (0, r.each)(t, (function(t, n) {
                                        Array.isArray(n) && [].push.apply(i, n), (0, o.isPlainObject)(n) && a.push("".concat(t).concat(e(n)))
                                    })), (i.length || a.length) && (n += "(", i.length && (n += "$select=".concat((0, r.map)(i, D).join())), a.length && (i.length && (n += ";"), n += "$expand=".concat((0, r.map)(a, D).join())), n += ")"), n
                                }(n)))
                            })), t.join()
                        },
                        V = function(e, t, n) {
                            return (0, r.each)(e, (function(e, i) {
                                return function e(t, n, i) {
                                    var a = i(n, t.shift(), t);
                                    !1 !== a && e(t, a, i)
                                }(i.split("."), t, n)
                            }))
                        };
                    t.generateExpand = function(e, t, n) {
                        return e < 4 ? function(e, t) {
                            var n = {};
                            return e && (0, r.each)(y(e), (function() {
                                n[D(this)] = 1
                            })), t && (0, r.each)(y(t), (function() {
                                var e = this.split(".");
                                e.length < 2 || (e.pop(), n[D(e.join("."))] = 1)
                            })), (0, r.map)(n, (function(e, t) {
                                return t
                            })).join()
                        }(t, n) : function(e, t) {
                            var n = {};
                            if (e || t) {
                                return e && V(y(e), n, (function(e, t, n) {
                                    return e[t] = e[t] || {}, !!n.length && e[t]
                                })), t && V((0, l.grep)(y(t), b), n, (function(e, t, n) {
                                    return n.length ? e[t] = e[t] || {} : (e[t] = e[t] || [], e[t].push(t), !1)
                                })), L(n)
                            }
                        }(t, n)
                    };
                    t.formatFunctionInvocationUrl = function(e, t) {
                        return (0, h.format)("{0}({1})", e, (0, r.map)(t || {}, (function(e, t) {
                            return (0, h.format)("{0}={1}", t, e)
                        })).join(","))
                    };
                    t.escapeServiceOperationParams = function(e, t) {
                        if (!e) {
                            return e
                        }
                        var n = {};
                        return (0, r.each)(e, (function(e, i) {
                            n[e] = R(i, t)
                        })), n
                    }
                },
            96687:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./query_implementation */ 77549);
                    t.default = function() {
                        var e = Array.isArray(arguments[0]) ? "array" : "remote";
                        return i.queryImpl[e].apply(this, arguments)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            16135:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query_adapters.js ***!
                  \********************************************************************/
                function(e, t) {
                    t.default = void 0;
                    t.default = {}, e.exports = t.default, e.exports.default = t.default
                },
            77549:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/query_implementation.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.queryImpl = void 0;
                    var i = o(n( /*! ./array_query */ 35042)),
                        a = o(n( /*! ./remote_query */ 41428));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = {
                        array: i.default,
                        remote: a.default
                    };
                    t.queryImpl = r
                },
            41428:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/remote_query.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = l(n( /*! ./query_adapters */ 16135)),
                        a = n( /*! ./errors */ 18438),
                        o = n( /*! ../core/utils/iterator */ 95479),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/deferred */ 62754),
                        c = l(n( /*! ./array_query */ 35042));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    t.default = function e(t, n, l) {
                        l = l || [], n = n || {};
                        var u = function(e, t) {
                                return {
                                    name: e,
                                    args: t
                                }
                            },
                            d = function(e) {
                                var d, f, h, g, p, m, _, v = new s.Deferred,
                                    x = function(e) {
                                        var t = n.errorHandler;
                                        t && t(e), (0, a.handleError)(e), v.reject(e)
                                    };

                                function y(e) {
                                    switch (e.name) {
                                        case "sortBy":
                                            return p = [e.args], !0;
                                        case "thenBy":
                                            if (!p) {
                                                throw a.errors.Error("E4004")
                                            }
                                            return p.push(e.args), !0
                                    }
                                    return !1
                                }
                                try {
                                    d = n.adapter, (0, r.isFunction)(d) || (d = i.default[d]), f = d(n), h = [].concat(l).concat(e);
                                    var b = f.optimize;
                                    for (b && b(h); h.length;) {
                                        if (!y(g = h[0])) {
                                            if (p) {
                                                h.unshift(u("multiSort", [p])), p = null;
                                                continue
                                            }
                                            if ("enumerate" !== String(g.name) && (!f[g.name] || !1 === f[g.name].apply(f, g.args))) {
                                                break
                                            }
                                        }
                                        h.shift()
                                    }
                                    m = h[0], _ = [], m && "multiSort" === m.name && (h.shift(), (0, o.each)(m.args[0], (function() {
                                        _.push(u(_.length ? "thenBy" : "sortBy", this))
                                    }))), h = _.concat(h), f.exec(t).done((function(e, t) {
                                        if (h.length) {
                                            var i = (0, c.default)(e, {
                                                errorHandler: n.errorHandler
                                            });
                                            (0, o.each)(h, (function() {
                                                i = i[this.name].apply(i, this.args)
                                            })), i.done(v.resolve).fail(v.reject)
                                        } else {
                                            v.resolve(e, t)
                                        }
                                    })).fail(x)
                                } catch (e) {
                                    x(e)
                                }
                                return v.promise()
                            },
                            f = {};
                        return (0, o.each)(["sortBy", "thenBy", "filter", "slice", "select", "groupBy"], (function() {
                            var i = String(this);
                            f[i] = function() {
                                return e(t, n, l.concat(u(i, arguments)))
                            }
                        })), (0, o.each)(["count", "min", "max", "sum", "avg", "aggregate", "enumerate"], (function() {
                            var e = String(this);
                            f[e] = function() {
                                return d.call(this, u(e, arguments))
                            }
                        })), f
                    }, e.exports = t.default, e.exports.default = t.default
                },
            99236:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/store_helper.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../core/utils/common */ 20576),
                        o = n( /*! ../core/utils/extend */ 13306),
                        r = n( /*! ../core/utils/iterator */ 95479),
                        s = (i = n( /*! ./array_query */ 35042)) && i.__esModule ? i : {
                            default: i
                        },
                        c = n( /*! ./utils */ 16454);

                    function l(e, t) {
                        return e = e.groupBy(t[0].selector), t.length > 1 && (e = e.select((function(e) {
                            return (0, o.extend)({}, e, {
                                items: l((0, s.default)(e.items), t.slice(1)).toArray()
                            })
                        }))), e
                    }

                    function u(e, t) {
                        var n = [];
                        return (0, r.each)(e, (function(e, i) {
                            (0, a.grep)(t, (function(e) {
                                return i.selector === e.selector
                            })).length < 1 && n.push(i)
                        })), n.concat(t)
                    }
                    var d = {
                        multiLevelGroup: l,
                        arrangeSortingInfo: u,
                        queryByOptions: function(e, t, n) {
                            var i = (t = t || {}).filter;
                            if (i && (e = e.filter(i)), n) {
                                return e
                            }
                            var a = t.sort,
                                o = t.select,
                                s = t.group,
                                d = t.skip,
                                f = t.take;
                            return s && ((s = (0, c.normalizeSortingInfo)(s)).keepInitialKeyOrder = !!t.group.keepInitialKeyOrder), (a || s) && (a = (0, c.normalizeSortingInfo)(a || []), s && !s.keepInitialKeyOrder && (a = u(s, a)), (0, r.each)(a, (function(t) {
                                e = e[t ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                            }))), o && (e = e.select(o)), s && (e = l(e, s)), (f || d) && (e = e.slice(d || 0, f)), e
                        }
                    };
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            16454:
                /*!***********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data/utils.js ***!
                  \***********************************************************/
                function(e, t, n) {
                    t.errorMessageFromXhr = t.base64_encode = t.aggregators = t.XHR_ERROR_UNLOAD = void 0, t.isConjunctiveOperator = function(e) {
                        return /^(and|&&|&)$/i.test(e)
                    }, t.isDisjunctiveOperator = function(e) {
                        return /^(or|\|\||\|)$/i.test(e)
                    }, t.rejectedPromise = t.processRequestResultLock = t.normalizeSortingInfo = t.normalizeBinaryCriterion = t.keysEqual = t.isUnaryOperation = t.isGroupCriterion = void 0, t.throttleChanges = function(e, t) {
                        var n = [],
                            a = function(e, t) {
                                var n, a;
                                return function() {
                                    var o = this;
                                    return a = arguments, n || (n = setTimeout((function() {
                                        n = void 0, a && e.call(o, a)
                                    }), (0, i.isFunction)(t) ? t() : t)), n
                                }
                            }((function() {
                                e.call(this, n), n = []
                            }), t);
                        return function(e) {
                            var t, i;
                            Array.isArray(e) && (t = n).push.apply(t, function(e) {
                                if (Array.isArray(e)) {
                                    return d(e)
                                }
                            }(i = e) || function(e) {
                                if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) {
                                    return Array.from(e)
                                }
                            }(i) || function(e, t) {
                                if (e) {
                                    if ("string" == typeof e) {
                                        return d(e, t)
                                    }
                                    var n = Object.prototype.toString.call(e).slice(8, -1);
                                    return "Object" === n && e.constructor && (n = e.constructor.name), "Map" === n || "Set" === n ? Array.from(e) : "Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n) ? d(e, t) : void 0
                                }
                            }(i) || function() {
                                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                            }());
                            return a.call(this, n)
                        }
                    }, t.trivialPromise = void 0;
                    var i = n( /*! ../core/utils/type */ 35922),
                        a = u(n( /*! ../core/dom_adapter */ 73349)),
                        o = u(n( /*! ../core/utils/ready_callbacks */ 24311)),
                        r = n( /*! ../core/utils/window */ 58201),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        c = n( /*! ../core/utils/deferred */ 62754),
                        l = n( /*! ../core/utils/common */ 20576);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function d(e, t) {
                        (null == t || t > e.length) && (t = e.length);
                        for (var n = 0, i = new Array(t); n < t; n++) {
                            i[n] = e[n]
                        }
                        return i
                    }
                    var f = o.default.add,
                        h = "DEVEXTREME_XHR_ERROR_UNLOAD";
                    t.XHR_ERROR_UNLOAD = h;
                    t.normalizeBinaryCriterion = function(e) {
                        return [e[0], e.length < 3 ? "=" : String(e[1]).toLowerCase(), e.length < 2 || e[e.length - 1]]
                    };
                    t.normalizeSortingInfo = function(e) {
                        return Array.isArray(e) || (e = [e]), (0, s.map)(e, (function(e) {
                            var t = {
                                selector: (0, i.isFunction)(e) || "string" == typeof e ? e : e.getter || e.field || e.selector,
                                desc: !(!e.desc && "d" !== String(e.dir).charAt(0).toLowerCase())
                            };
                            return e.compare && (t.compare = e.compare), t
                        }))
                    };
                    var g, p, m = (p = {
                        timeout: "Network connection timeout",
                        error: "Unspecified network error",
                        parsererror: "Unexpected server response"
                    }, f((function() {
                        var e = (0, r.getWindow)();
                        a.default.listen(e, "beforeunload", (function() {
                            g = !0
                        }))
                    })), function(e, t) {
                        return g ? h : e.status < 400 ? function(e) {
                            return p[e] || e
                        }(t) : e.statusText
                    });
                    t.errorMessageFromXhr = m;
                    var _ = {
                        count: {
                            seed: 0,
                            step: function(e) {
                                return 1 + e
                            }
                        },
                        sum: {
                            seed: 0,
                            step: function(e, t) {
                                return e + t
                            }
                        },
                        min: {
                            step: function(e, t) {
                                return t < e ? t : e
                            }
                        },
                        max: {
                            step: function(e, t) {
                                return t > e ? t : e
                            }
                        },
                        avg: {
                            seed: [0, 0],
                            step: function(e, t) {
                                return [e[0] + t, e[1] + 1]
                            },
                            finalize: function(e) {
                                return e[1] ? e[0] / e[1] : NaN
                            }
                        }
                    };
                    t.aggregators = _;
                    var v, x, y = (x = 0, {
                        obtain: function() {
                            0 === x && (v = new c.Deferred), x++
                        },
                        release: function() {
                            --x < 1 && v.resolve()
                        },
                        promise: function() {
                            return (0 === x ? (new c.Deferred).resolve() : v).promise()
                        },
                        reset: function() {
                            x = 0, v && v.resolve()
                        }
                    });
                    t.processRequestResultLock = y;
                    t.keysEqual = function(e, t, n) {
                        if (Array.isArray(e)) {
                            for (var i, a = (0, s.map)(t, (function(e, t) {
                                    return t
                                })), o = 0; o < a.length; o++) {
                                if (i = a[o], !(0, l.equalByValue)(t[i], n[i], 0, !1)) {
                                    return !1
                                }
                            }
                            return !0
                        }
                        return (0, l.equalByValue)(t, n, 0, !1)
                    };
                    t.base64_encode = function(e) {
                        Array.isArray(e) || (e = function(e) {
                            var t, n, i = [];
                            for (n = 0; n < e.length; n++) {
                                (t = e.charCodeAt(n)) < 128 ? i.push(t) : t < 2048 ? i.push(192 + (t >> 6), 128 + (63 & t)) : t < 65536 ? i.push(224 + (t >> 12), 128 + (t >> 6 & 63), 128 + (63 & t)) : t < 2097152 && i.push(240 + (t >> 18), 128 + (t >> 12 & 63), 128 + (t >> 6 & 63), 128 + (63 & t))
                            }
                            return i
                        }(String(e)));
                        var t = "";

                        function n(e) {
                            return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)
                        }
                        for (var i = 0; i < e.length; i += 3) {
                            var a = e[i],
                                o = e[i + 1],
                                r = e[i + 2];
                            t += (0, s.map)([a >> 2, (3 & a) << 4 | o >> 4, isNaN(o) ? 64 : (15 & o) << 2 | r >> 6, isNaN(r) ? 64 : 63 & r], n).join("")
                        }
                        return t
                    };
                    t.isUnaryOperation = function(e) {
                        return "!" === e[0] && Array.isArray(e[1])
                    };
                    t.isGroupCriterion = function(e) {
                        var t, n = e[0],
                            a = e[1];
                        return !!Array.isArray(n) || !(!(0, i.isFunction)(n) || !Array.isArray(a) && !(0, i.isFunction)(a) && "and" !== (t = a) && "or" !== t)
                    };
                    t.trivialPromise = function() {
                        var e = new c.Deferred;
                        return e.resolve.apply(e, arguments).promise()
                    };
                    t.rejectedPromise = function() {
                        var e = new c.Deferred;
                        return e.reject.apply(e, arguments).promise()
                    }
                },
            53305:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/data_helper.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./data/data_source/data_source */ 85273),
                        a = n( /*! ./core/utils/extend */ 13306),
                        o = n( /*! ./data/data_source/utils */ 9234),
                        h = {
                            postCtor: function() {
                                this.on("disposing", function() {
                                    this._disposeDataSource()
                                }.bind(this))
                            },
                            _refreshDataSource: function() {
                                this._initDataSource(), this._loadDataSource()
                            },
                            _initDataSource: function() {
                                var e, t, n = "_getSpecificDataSourceOption" in this ? this._getSpecificDataSourceOption() : this.option("dataSource");
                                this._disposeDataSource(), n && (n instanceof i.DataSource ? (this._isSharedDataSource = !0, this._dataSource = n) : (e = "_dataSourceOptions" in this ? this._dataSourceOptions() : {}, t = this._dataSourceType ? this._dataSourceType() : i.DataSource, n = (0, o.normalizeDataSourceOptions)(n, {
                                    fromUrlLoadMode: "_dataSourceFromUrlLoadMode" in this && this._dataSourceFromUrlLoadMode()
                                }), this._dataSource = new t((0, a.extend)(!0, {}, e, n))), "_normalizeDataSource" in this && (this._dataSource = this._normalizeDataSource(this._dataSource)), this._addDataSourceHandlers())
                            },
                            _addDataSourceHandlers: function() {
                                "_dataSourceChangedHandler" in this && this._addDataSourceChangeHandler(), "_dataSourceLoadErrorHandler" in this && this._addDataSourceLoadErrorHandler(), "_dataSourceLoadingChangedHandler" in this && this._addDataSourceLoadingChangedHandler(), this._addReadyWatcher()
                            },
                            _addReadyWatcher: function() {
                                this._dataSource.on("loadingChanged", function(e) {
                                    this._ready && this._ready(!e)
                                }.bind(this))
                            },
                            _addDataSourceChangeHandler: function() {
                                var e = this._dataSource;
                                this._proxiedDataSourceChangedHandler = function(t) {
                                    this._dataSourceChangedHandler(e.items(), t)
                                }.bind(this), e.on("changed", this._proxiedDataSourceChangedHandler)
                            },
                            _addDataSourceLoadErrorHandler: function() {
                                this._proxiedDataSourceLoadErrorHandler = this._dataSourceLoadErrorHandler.bind(this), this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
                            },
                            _addDataSourceLoadingChangedHandler: function() {
                                this._proxiedDataSourceLoadingChangedHandler = this._dataSourceLoadingChangedHandler.bind(this), this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                            },
                            _loadDataSource: function() {
                                if (this._dataSource) {
                                    var e = this._dataSource;
                                    e.isLoaded() ? this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler() : e.load()
                                }
                            },
                            _loadSingle: function(e, t) {
                                return e = "this" === e ? this._dataSource.key() || "this" : e, this._dataSource.loadSingle(e, t)
                            },
                            _isLastPage: function() {
                                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
                            },
                            _isDataSourceLoading: function() {
                                return this._dataSource && this._dataSource.isLoading()
                            },
                            _disposeDataSource: function() {
                                this._dataSource && (this._isSharedDataSource ? (delete this._isSharedDataSource, this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler), this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler), this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)) : this._dataSource.dispose(), delete this._dataSource, delete this._proxiedDataSourceChangedHandler, delete this._proxiedDataSourceLoadErrorHandler, delete this._proxiedDataSourceLoadingChangedHandler)
                            },
                            getDataSource: function() {
                                return this._dataSource || null
                            }
                        };
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            95429:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/click.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = p(n( /*! ../core/renderer */ 68374)),
                        a = p(n( /*! ../events/core/events_engine */ 55994)),
                        o = p(n( /*! ../core/devices */ 20530)),
                        r = p(n( /*! ../core/dom_adapter */ 73349)),
                        s = n( /*! ../core/utils/dom */ 3532),
                        c = n( /*! ../animation/frame */ 90057),
                        l = n( /*! ./utils/index */ 39611),
                        u = n( /*! ./utils/event_nodes_disposing */ 27575),
                        d = p(n( /*! ./pointer */ 93786)),
                        f = p(n( /*! ./core/emitter */ 31391)),
                        h = p(n( /*! ./core/emitter_registrator */ 82495)),
                        g = n( /*! ../core/utils/version */ 58020);

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var m = "dxclick";
                    t.name = m;
                    var _ = Math.abs,
                        v = function(e) {
                            return (0, i.default)(e).is("input, textarea, select, button ,:focus, :focus *")
                        },
                        x = {
                            requestAnimationFrame: c.requestAnimationFrame,
                            cancelAnimationFrame: c.cancelAnimationFrame
                        },
                        y = f.default.inherit({
                            ctor: function(e) {
                                this.callBase(e), this._makeElementClickable((0, i.default)(e))
                            },
                            _makeElementClickable: function(e) {
                                e.attr("onclick") || e.attr("onclick", "void(0)")
                            },
                            start: function(e) {
                                this._blurPrevented = e.isDefaultPrevented(), this._startTarget = e.target, this._startEventData = (0, l.eventData)(e)
                            },
                            end: function(e) {
                                this._eventOutOfElement(e, this.getElement().get(0)) || e.type === d.default.cancel ? this._cancel(e) : (v(e.target) || this._blurPrevented || (0, s.resetActiveElement)(), this._accept(e), this._clickAnimationFrame = x.requestAnimationFrame(function() {
                                    this._fireClickEvent(e)
                                }.bind(this)))
                            },
                            _eventOutOfElement: function(e, t) {
                                var n = e.target,
                                    i = !(0, s.contains)(t, n) && t !== n,
                                    a = (0, l.eventDelta)((0, l.eventData)(e), this._startEventData),
                                    o = _(a.x) > 10 || _(a.y) > 10;
                                return i || o
                            },
                            _fireClickEvent: function(e) {
                                this._fireEvent(m, e, {
                                    target: (0, s.closestCommonParent)(this._startTarget, e.target)
                                })
                            },
                            dispose: function() {
                                x.cancelAnimationFrame(this._clickAnimationFrame)
                            }
                        }),
                        b = o.default.real(),
                        w = b.generic || b.ios && (0, g.compare)(b.version, [9, 3]) >= 0 || b.android && (0, g.compare)(b.version, [5]) >= 0;
                    ! function() {
                        var t = function(e) {
                                return w || (0, i.default)(e).closest(".dx-native-click").length
                            },
                            n = null,
                            o = null;

                        function r() {
                            o = null
                        }
                        var s = function(e) {
                            var i = e.originalEvent,
                                a = o === i || i && i.DXCLICK_FIRED;
                            (!e.which || 1 === e.which) && !n && t(e.target) && !a && (i && (i.DXCLICK_FIRED = !0), (0, u.unsubscribeNodesDisposing)(o, r), o = i, (0, u.subscribeNodesDisposing)(o, r), (0, l.fireEvent)({
                                type: m,
                                originalEvent: e
                            }))
                        };
                        y = y.inherit({
                            _makeElementClickable: function(e) {
                                t(e) || this.callBase(e), a.default.on(e, "click", s)
                            },
                            configure: function(t) {
                                this.callBase(t), t.useNative && this.getElement().addClass("dx-native-click")
                            },
                            start: function(e) {
                                n = null, t(e.target) || this.callBase(e)
                            },
                            end: function(e) {
                                t(e.target) || this.callBase(e)
                            },
                            cancel: function() {
                                n = !0
                            },
                            dispose: function() {
                                this.callBase(), a.default.off(this.getElement(), "click", s)
                            }
                        })
                    }(),
                    function() {
                        if (!o.default.real().generic) {
                            var e = null,
                                t = !1,
                                n = "NATIVE_CLICK_FIXER",
                                c = r.default.getDocument();
                            a.default.subscribeGlobal(c, (0, l.addNamespace)(d.default.down, n), (function(n) {
                                e = n.target, t = n.isDefaultPrevented()
                            })), a.default.subscribeGlobal(c, (0, l.addNamespace)("click", n), (function(n) {
                                var a = (0, i.default)(n.target);
                                t || !e || a.is(e) || (0, i.default)(e).is("label") || !v(a) || (0, s.resetActiveElement)(), e = null, t = !1
                            }))
                        }
                    }(), (0, h.default)({
                        emitter: y,
                        bubble: !0,
                        events: [m]
                    })
                },
            49166:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/contextmenu.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = d(n( /*! ../core/renderer */ 68374)),
                        a = d(n( /*! ../events/core/events_engine */ 55994)),
                        o = n( /*! ../core/utils/support */ 60137),
                        r = d(n( /*! ../core/devices */ 20530)),
                        s = d(n( /*! ../core/class */ 38377)),
                        c = d(n( /*! ./core/event_registrator */ 85788)),
                        l = n( /*! ./utils/index */ 39611),
                        u = d(n( /*! ./hold */ 11699));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f = "dxContexMenu",
                        h = (0, l.addNamespace)("contextmenu", f),
                        g = (0, l.addNamespace)(u.default.name, f),
                        p = "dxcontextmenu",
                        m = s.default.inherit({
                            setup: function(e) {
                                var t = (0, i.default)(e);
                                a.default.on(t, h, this._contextMenuHandler.bind(this)), (o.touch || r.default.isSimulator()) && a.default.on(t, g, this._holdHandler.bind(this))
                            },
                            _holdHandler: function(e) {
                                (0, l.isMouseEvent)(e) && !r.default.isSimulator() || this._fireContextMenu(e)
                            },
                            _contextMenuHandler: function(e) {
                                this._fireContextMenu(e)
                            },
                            _fireContextMenu: function(e) {
                                return (0, l.fireEvent)({
                                    type: p,
                                    originalEvent: e
                                })
                            },
                            teardown: function(e) {
                                a.default.off(e, ".dxContexMenu")
                            }
                        });
                    (0, c.default)(p, new m);
                    t.name = "dxcontextmenu"
                },
            91633:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.feedback.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.lock = t.inactive = t.active = void 0;
                    var i = d(n( /*! ../../core/class */ 38377)),
                        a = n( /*! ../../core/utils/common */ 20576),
                        o = n( /*! ../../core/utils/dom */ 3532),
                        r = d(n( /*! ../../core/devices */ 20530)),
                        s = n( /*! ../utils/index */ 39611),
                        c = d(n( /*! ../pointer */ 93786)),
                        l = d(n( /*! ./emitter */ 31391)),
                        u = d(n( /*! ./emitter_registrator */ 82495));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var f = "dxactive";
                    t.active = f;
                    var h = "dxinactive";
                    t.inactive = h;
                    var g, p = i.default.inherit({
                            ctor: function(e, t) {
                                this._timeout = e, this._fire = t
                            },
                            start: function() {
                                var e = this;
                                this._schedule((function() {
                                    e.force()
                                }))
                            },
                            _schedule: function(e) {
                                this.stop(), this._timer = setTimeout(e, this._timeout)
                            },
                            stop: function() {
                                clearTimeout(this._timer)
                            },
                            force: function() {
                                this._fired || (this.stop(), this._fire(), this._fired = !0)
                            },
                            fired: function() {
                                return this._fired
                            }
                        }),
                        m = l.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._active = new p(0, a.noop), this._inactive = new p(0, a.noop)
                            },
                            configure: function(e, t) {
                                switch (t) {
                                    case f:
                                        e.activeTimeout = e.timeout;
                                        break;
                                    case h:
                                        e.inactiveTimeout = e.timeout
                                }
                                this.callBase(e)
                            },
                            start: function(e) {
                                if (g) {
                                    var t = (0, o.contains)(this.getElement().get(0), g.getElement().get(0)),
                                        n = !g._active.fired();
                                    if (t && n) {
                                        return void this._cancel()
                                    }
                                    g._inactive.force()
                                }
                                g = this, this._initEvents(e), this._active.start()
                            },
                            _initEvents: function(e) {
                                var t = this,
                                    n = this._getEmitterTarget(e),
                                    i = (0, s.isMouseEvent)(e),
                                    o = r.default.isSimulator() || !i,
                                    c = (0, a.ensureDefined)(this.activeTimeout, 30),
                                    l = (0, a.ensureDefined)(this.inactiveTimeout, 400);
                                this._active = new p(o ? c : 0, (function() {
                                    t._fireEvent(f, e, {
                                        target: n
                                    })
                                })), this._inactive = new p(o ? l : 0, (function() {
                                    t._fireEvent(h, e, {
                                        target: n
                                    }), g = null
                                }))
                            },
                            cancel: function(e) {
                                this.end(e)
                            },
                            end: function(e) {
                                var t = e.type !== c.default.up;
                                t ? this._active.stop() : this._active.force(), this._inactive.start(), t && this._inactive.force()
                            },
                            dispose: function() {
                                this._active.stop(), this._inactive.stop(), g === this && (g = null), this.callBase()
                            },
                            lockInactive: function() {
                                return this._active.force(), this._inactive.stop(), g = null, this._cancel(), this._inactive.force.bind(this._inactive)
                            }
                        });
                    m.lock = function(e) {
                        var t = g ? g.lockInactive() : a.noop;
                        e.done(t)
                    }, (0, u.default)({
                        emitter: m,
                        events: [f, h]
                    });
                    var _ = m.lock;
                    t.lock = _
                },
            31391:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = l(n( /*! ../../core/renderer */ 68374)),
                        a = n( /*! ../../core/utils/common */ 20576),
                        o = l(n( /*! ../../core/class */ 38377)),
                        r = l(n( /*! ../../core/utils/callbacks */ 44504)),
                        s = n( /*! ../../core/utils/extend */ 13306),
                        c = n( /*! ../utils/index */ 39611);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = o.default.inherit({
                        ctor: function(e) {
                            this._$element = (0, i.default)(e), this._cancelCallback = (0, r.default)(), this._acceptCallback = (0, r.default)()
                        },
                        getElement: function() {
                            return this._$element
                        },
                        validate: function(e) {
                            return !(0, c.isDxMouseWheelEvent)(e)
                        },
                        validatePointers: function(e) {
                            return 1 === (0, c.hasTouches)(e)
                        },
                        allowInterruptionByMouseWheel: function() {
                            return !0
                        },
                        configure: function(e) {
                            (0, s.extend)(this, e)
                        },
                        addCancelCallback: function(e) {
                            this._cancelCallback.add(e)
                        },
                        removeCancelCallback: function() {
                            this._cancelCallback.empty()
                        },
                        _cancel: function(e) {
                            this._cancelCallback.fire(this, e)
                        },
                        addAcceptCallback: function(e) {
                            this._acceptCallback.add(e)
                        },
                        removeAcceptCallback: function() {
                            this._acceptCallback.empty()
                        },
                        _accept: function(e) {
                            this._acceptCallback.fire(this, e)
                        },
                        _requestAccept: function(e) {
                            this._acceptRequestEvent = e
                        },
                        _forgetAccept: function() {
                            this._accept(this._acceptRequestEvent), this._acceptRequestEvent = null
                        },
                        start: a.noop,
                        move: a.noop,
                        end: a.noop,
                        cancel: a.noop,
                        reset: function() {
                            this._acceptRequestEvent && this._accept(this._acceptRequestEvent)
                        },
                        _fireEvent: function(e, t, n) {
                            var i = (0, s.extend)({
                                type: e,
                                originalEvent: t,
                                target: this._getEmitterTarget(t),
                                delegateTarget: this.getElement().get(0)
                            }, n);
                            return (t = (0, c.fireEvent)(i)).cancel && this._cancel(t), t
                        },
                        _getEmitterTarget: function(e) {
                            return (this.delegateSelector ? (0, i.default)(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
                        },
                        dispose: a.noop
                    });
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            82495:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/emitter_registrator.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = m(n( /*! ../../core/renderer */ 68374)),
                        a = m(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        o = m(n( /*! ../../core/dom_adapter */ 73349)),
                        r = m(n( /*! ../../events/core/events_engine */ 55994)),
                        s = n( /*! ../../core/element_data */ 97906),
                        c = m(n( /*! ../../core/class */ 38377)),
                        l = n( /*! ../../core/utils/extend */ 13306),
                        u = n( /*! ../../core/utils/array */ 89386),
                        d = n( /*! ../../core/utils/iterator */ 95479),
                        f = m(n( /*! ./event_registrator */ 85788)),
                        h = n( /*! ../utils/index */ 39611),
                        g = m(n( /*! ../pointer */ 93786)),
                        p = n( /*! ./wheel */ 765);

                    function m(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var _ = "dxEventManager",
                        v = "dxEmitter",
                        x = new(c.default.inherit({
                            ctor: function() {
                                this._attachHandlers(), this.reset(), this._proxiedCancelHandler = this._cancelHandler.bind(this), this._proxiedAcceptHandler = this._acceptHandler.bind(this)
                            },
                            _attachHandlers: function() {
                                a.default.add(function() {
                                    var e = o.default.getDocument();
                                    r.default.subscribeGlobal(e, (0, h.addNamespace)(g.default.down, _), this._pointerDownHandler.bind(this)), r.default.subscribeGlobal(e, (0, h.addNamespace)(g.default.move, _), this._pointerMoveHandler.bind(this)), r.default.subscribeGlobal(e, (0, h.addNamespace)([g.default.up, g.default.cancel].join(" "), _), this._pointerUpHandler.bind(this)), r.default.subscribeGlobal(e, (0, h.addNamespace)(p.name, _), this._mouseWheelHandler.bind(this))
                                }.bind(this))
                            },
                            _eachEmitter: function(e) {
                                for (var t = this._activeEmitters || [], n = 0; t.length > n;) {
                                    var i = t[n];
                                    if (!1 === e(i)) {
                                        break
                                    }
                                    t[n] === i && n++
                                }
                            },
                            _applyToEmitters: function(e, t) {
                                this._eachEmitter((function(n) {
                                    n[e].call(n, t)
                                }))
                            },
                            reset: function() {
                                this._eachEmitter(this._proxiedCancelHandler), this._activeEmitters = []
                            },
                            resetEmitter: function(e) {
                                this._proxiedCancelHandler(e)
                            },
                            _pointerDownHandler: function(e) {
                                (0, h.isMouseEvent)(e) && e.which > 1 || this._updateEmitters(e)
                            },
                            _updateEmitters: function(e) {
                                this._isSetChanged(e) && (this._cleanEmitters(e), this._fetchEmitters(e))
                            },
                            _isSetChanged: function(e) {
                                var t = this._closestEmitter(e),
                                    n = this._emittersSet || [],
                                    i = t.length !== n.length;
                                return (0, d.each)(t, (function(e, t) {
                                    return !(i = i || n[e] !== t)
                                })), this._emittersSet = t, i
                            },
                            _closestEmitter: function(e) {
                                var t = this,
                                    n = [],
                                    a = (0, i.default)(e.target);

                                function o(i, a) {
                                    a && a.validatePointers(e) && a.validate(e) && (a.addCancelCallback(t._proxiedCancelHandler), a.addAcceptCallback(t._proxiedAcceptHandler), n.push(a))
                                }
                                for (; a.length;) {
                                    var r = (0, s.data)(a.get(0), v) || [];
                                    (0, d.each)(r, o), a = a.parent()
                                }
                                return n
                            },
                            _acceptHandler: function(e, t) {
                                var n = this;
                                this._eachEmitter((function(i) {
                                    i !== e && n._cancelEmitter(i, t)
                                }))
                            },
                            _cancelHandler: function(e, t) {
                                this._cancelEmitter(e, t)
                            },
                            _cancelEmitter: function(e, t) {
                                var n = this._activeEmitters;
                                t ? e.cancel(t) : e.reset(), e.removeCancelCallback(), e.removeAcceptCallback();
                                var i = (0, u.inArray)(e, n);
                                i > -1 && n.splice(i, 1)
                            },
                            _cleanEmitters: function(e) {
                                this._applyToEmitters("end", e), this.reset(e)
                            },
                            _fetchEmitters: function(e) {
                                this._activeEmitters = this._emittersSet.slice(), this._applyToEmitters("start", e)
                            },
                            _pointerMoveHandler: function(e) {
                                this._applyToEmitters("move", e)
                            },
                            _pointerUpHandler: function(e) {
                                this._updateEmitters(e)
                            },
                            _mouseWheelHandler: function(e) {
                                this._allowInterruptionByMouseWheel() && (e.pointers = [null], this._pointerDownHandler(e), this._adjustWheelEvent(e), this._pointerMoveHandler(e), e.pointers = [], this._pointerUpHandler(e))
                            },
                            _allowInterruptionByMouseWheel: function() {
                                var e = !0;
                                return this._eachEmitter((function(t) {
                                    return e = t.allowInterruptionByMouseWheel() && e
                                })), e
                            },
                            _adjustWheelEvent: function(e) {
                                var t = null;
                                if (this._eachEmitter((function(n) {
                                        if (n.gesture) {
                                            var i = n.getDirection(e);
                                            return "horizontal" !== i && !e.shiftKey || "vertical" !== i && e.shiftKey ? (t = n, !1) : void 0
                                        }
                                    })), t) {
                                    var n = t.getDirection(e),
                                        i = "both" === n && !e.shiftKey || "vertical" === n;
                                    e[i ? "pageY" : "pageX"] += e.delta
                                }
                            },
                            isActive: function(e) {
                                var t = !1;
                                return this._eachEmitter((function(n) {
                                    t = t || n.getElement().is(e)
                                })), t
                            }
                        })),
                        y = "dxEmitterSubscription";
                    t.default = function(e) {
                        var t = e.emitter,
                            n = e.events[0],
                            i = e.events;
                        (0, d.each)(i, (function(a, o) {
                            (0, f.default)(o, {
                                noBubble: !e.bubble,
                                setup: function(e) {
                                    var i = (0, s.data)(e, y) || {},
                                        a = (0, s.data)(e, v) || {},
                                        r = a[n] || new t(e);
                                    i[o] = !0, a[n] = r, (0, s.data)(e, v, a), (0, s.data)(e, y, i)
                                },
                                add: function(e, t) {
                                    (0, s.data)(e, v)[n].configure((0, l.extend)({
                                        delegateSelector: t.selector
                                    }, t.data), t.type)
                                },
                                teardown: function(e) {
                                    var t = (0, s.data)(e, y),
                                        a = (0, s.data)(e, v),
                                        r = a[n];
                                    delete t[o];
                                    var c = !0;
                                    (0, d.each)(i, (function(e, n) {
                                        return c = c && !t[n]
                                    })), c && (x.isActive(e) && x.resetEmitter(r), r && r.dispose(), delete a[n])
                                }
                            })
                        }))
                    }, e.exports = t.default, e.exports.default = t.default
                },
            85788:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../../core/utils/iterator */ 95479),
                        o = (i = n( /*! ./event_registrator_callbacks */ 94553)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = function(e, t) {
                        var n = {};
                        "noBubble" in t && (n.noBubble = t.noBubble), "bindType" in t && (n.bindType = t.bindType), "delegateType" in t && (n.delegateType = t.delegateType), (0, a.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], (function(e, i) {
                            t[i] && (n[i] = function() {
                                var e = [].slice.call(arguments);
                                return e.unshift(this), t[i].apply(t, e)
                            })
                        })), o.default.fire(e, n)
                    };
                    r.callbacks = o.default;
                    var s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            94553:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator_callbacks.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    var i;
                    t.default = void 0;
                    var a = new(((i = n( /*! ../../core/memorized_callbacks */ 83358)) && i.__esModule ? i : {
                        default: i
                    }).default);
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            55994:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/events_engine.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = g(n( /*! ./event_registrator_callbacks */ 94553)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = g(n( /*! ../../core/dom_adapter */ 73349)),
                        r = n( /*! ../../core/utils/window */ 58201),
                        s = g(n( /*! ../../core/utils/dependency_injector */ 20476)),
                        c = n( /*! ../../core/utils/type */ 35922),
                        l = g(n( /*! ../../core/utils/callbacks */ 44504)),
                        u = g(n( /*! ../../core/errors */ 17381)),
                        d = g(n( /*! ../../core/polyfills/weak_map */ 10126)),
                        f = g(n( /*! ../../events/core/hook_touch_props */ 2418)),
                        h = g(n( /*! ../../core/utils/call_once */ 39618));

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function p(e) {
                        return p = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, p(e)
                    }

                    function m() {
                        return m = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, m.apply(this, arguments)
                    }
                    var _ = (0, r.getWindow)(),
                        v = "dxEmptyEventType",
                        x = {
                            mouseenter: "mouseover",
                            mouseleave: "mouseout",
                            pointerenter: "pointerover",
                            pointerleave: "pointerout"
                        },
                        y = {
                            focusin: "focus",
                            focusout: "blur"
                        },
                        b = ["blur", "focus", "load"],
                        w = ["touchmove", "wheel", "mousewheel", "touchstart"];

                    function k(e, t) {
                        return !(0, c.isWindow)(e) && "#document" !== e.nodeName && o.default.elementMatches(e, t)
                    }
                    var S, C, A, I = new d.default,
                        T = 0,
                        E = (C = {}, i.default.add((function(e, t) {
                            C[e] = t
                        })), {
                            getField: function(e, t) {
                                return C[e] && C[e][t]
                            },
                            callMethod: function(e, t, n, i) {
                                return C[e] && C[e][t] && C[e][t].apply(n, i)
                            }
                        }),
                        O = (0, s.default)({
                            on: M(L(V((function(e, t, n, i, a) {
                                q(e, t).addHandler(a, n, i)
                            })))),
                            one: M(L((function(e, t, n, i, a) {
                                O.on(e, t, n, i, (function i() {
                                    O.off(e, t, n, i), a.apply(this, arguments)
                                }))
                            }))),
                            off: M((A = V((function(e, t, n, i) {
                                q(e, t).removeHandler(i, n)
                            })), function(e, t, n, i) {
                                "function" == typeof n && (i = n, n = void 0), A(e, t, n, i)
                            })),
                            trigger: M(B((function(e, t, n) {
                                var i = t.type,
                                    o = q(e, t.type);
                                if (E.callMethod(i, "trigger", e, [t, n]), o.callHandlers(t, n), !(E.getField(i, "noBubble") || t.isPropagationStopped() || -1 !== b.indexOf(i))) {
                                    var r = [];
                                    ! function e(t) {
                                        var n = t.parentNode;
                                        n && (r.push(n), e(n))
                                    }(e), r.push(_);
                                    for (var s = 0; r[s] && !t.isPropagationStopped();) {
                                        q(r[s], t.type).callHandlers((0, a.extend)(t, {
                                            currentTarget: r[s]
                                        }), n), s++
                                    }
                                }(e.nodeType || (0, c.isWindow)(e)) && (E.callMethod(i, "_default", e, [t, n]), function(e, t) {
                                    var n = y[e] || e;
                                    if (function(e, t) {
                                            return "click" === e && "a" === t.localName
                                        }(e, t)) {
                                        return
                                    }(0, c.isFunction)(t[n]) && (S = e, t[n](), S = void 0)
                                }(i, e))
                            }))),
                            triggerHandler: M(B((function(e, t, n) {
                                q(e, t.type).callHandlers(t, n)
                            })))
                        });

                    function D(e, t) {
                        var n = e[0];
                        if (n) {
                            if (o.default.isNode(n) || (0, c.isWindow)(n)) {
                                t.apply(O, e)
                            } else {
                                if ((0, c.isString)(n) || !("length" in n)) {
                                    throw u.default.Error("E0025")
                                }
                                var i = Array.prototype.slice.call(e, 0);
                                Array.prototype.forEach.call(n, (function(e) {
                                    i[0] = e, D(i, t)
                                }))
                            }
                        }
                    }

                    function M(e) {
                        return function() {
                            D(arguments, e)
                        }
                    }
                    var P = (0, h.default)((function() {
                            var e = !1;
                            try {
                                var t = Object.defineProperty({}, "passive", {
                                    get: function() {
                                        return e = !0, !0
                                    }
                                });
                                _.addEventListener("test", null, t)
                            } catch (e) {}
                            return e
                        })),
                        R = function e(t, n) {
                            return (0, c.isWindow)(t) ? e(t.document, n) : t.contains ? t.contains(n) : !!(n.compareDocumentPosition(t) & n.DOCUMENT_POSITION_CONTAINS)
                        };

                    function q(e, t) {
                        var n = I.get(e),
                            i = (t = t || "").split("."),
                            a = i.slice(1),
                            r = !!i[0];
                        t = i[0] || v, n || (n = {}, I.set(e, n)), n[t] || (n[t] = {
                            handleObjects: [],
                            nativeHandler: null
                        });
                        var s = n[t];
                        return {
                            addHandler: function(n, i, c) {
                                var l = function(i, a) {
                                        var o, r, s = [i],
                                            l = i.currentTarget,
                                            u = i.relatedTarget;
                                        t in x && (o = u && l && (u === l || R(l, u))), void 0 !== a && s.push(a), E.callMethod(t, "handle", e, [i, c]), o || (r = n.apply(l, s)), !1 === r && (i.preventDefault(), i.stopPropagation())
                                    },
                                    u = {
                                        handler: n,
                                        wrappedHandler: function(t, n) {
                                            if (!S || t.type !== S) {
                                                if (t.data = c, t.delegateTarget = e, i) {
                                                    for (var a = t.target; a && a !== e;) {
                                                        k(a, i) && (t.currentTarget = a, l(t, n)), a = a.parentNode
                                                    }
                                                } else {
                                                    t.currentTarget = t.delegateTarget || t.target, l(t, n)
                                                }
                                            }
                                        },
                                        selector: i,
                                        type: t,
                                        data: c,
                                        namespace: a.join("."),
                                        namespaces: a,
                                        guid: ++T
                                    };
                                s.handleObjects.push(u);
                                var d, f, h = 1 === s.handleObjects.length && r;
                                h && (h = !E.callMethod(t, "setup", e, [c, a, n])), h && (s.nativeHandler = (f = t, function(e, t) {
                                    var n = q(this, f);
                                    e = O.Event(e), n.callHandlers(e, t)
                                }), P() && w.indexOf(t) > -1 && (d = {
                                    passive: !1
                                }), s.removeListener = o.default.listen(e, x[t] || t, s.nativeHandler, d)), E.callMethod(t, "add", e, [u])
                            },
                            removeHandler: function(i, o) {
                                var s = function(t) {
                                    var r, s = n[t];
                                    s.handleObjects.length ? (s.handleObjects = s.handleObjects.filter((function(n) {
                                        var s = a.length && !z(n.namespaces, a) || i && n.handler !== i || o && n.selector !== o;
                                        return s || (r = n.handler, E.callMethod(t, "remove", e, [n])), s
                                    })), !s.handleObjects.length && t !== v && (E.callMethod(t, "teardown", e, [a, r]), s.nativeHandler && s.removeListener(), delete n[t])) : delete n[t]
                                };
                                if (r) {
                                    s(t)
                                } else {
                                    for (var c in n) {
                                        s(c)
                                    }
                                }
                                0 === Object.keys(n).length && I.delete(e)
                            },
                            callHandlers: function(e, t) {
                                var i = !1,
                                    o = function(n) {
                                        i || a.length && !z(n.namespaces, a) || (n.wrappedHandler(e, t), i = e.isImmediatePropagationStopped())
                                    };
                                s.handleObjects.forEach(o), a.length && n.dxEmptyEventType && n.dxEmptyEventType.handleObjects.forEach(o)
                            }
                        }
                    }

                    function z(e, t) {
                        for (var n = 0; n < t.length; n++) {
                            if (e.indexOf(t[n]) < 0) {
                                return !1
                            }
                        }
                        return !0
                    }

                    function L(e) {
                        return function(t, n, i, a, o) {
                            o || (o = a, a = void 0), "string" != typeof i && (a = i, i = void 0), o || "string" != typeof n || (o = a || i, i = void 0, a = void 0), e(t, n, i, a, o)
                        }
                    }

                    function B(e) {
                        return function(t, n, i) {
                            "string" == typeof n && (n = {
                                type: n
                            }), n.target || (n.target = t), n.currentTarget = t, n.delegateTarget || (n.delegateTarget = t), !n.type && n.originalEvent && (n.type = n.originalEvent.type), e(t, n instanceof O.Event ? n : O.Event(n), i)
                        }
                    }

                    function V(e) {
                        var t = function(t, n) {
                            if (n && n.indexOf(" ") > -1) {
                                var i = Array.prototype.slice.call(arguments, 0);
                                n.split(" ").forEach((function(t) {
                                    i[1] = t, e.apply(this, i)
                                }))
                            } else {
                                e.apply(this, arguments)
                            }
                        };
                        return function(e, n) {
                            if ("object" === p(n)) {
                                var i = Array.prototype.slice.call(arguments, 0);
                                for (var a in n) {
                                    i[1] = a, i[i.length - 1] = n[a], t.apply(this, i)
                                }
                            } else {
                                t.apply(this, arguments)
                            }
                        }
                    }

                    function F(e) {
                        if (function(e) {
                                return null == e.which && 0 === e.type.indexOf("key")
                            }(e)) {
                            return null != e.charCode ? e.charCode : e.keyCode
                        }
                        if (function(e) {
                                return !e.which && void 0 !== e.button && /^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(e.type)
                            }(e)) {
                            return {
                                1: 1,
                                2: 3,
                                3: 1,
                                4: 2
                            } [e.button]
                        }
                        return e.which
                    }

                    function N(e) {
                        e && (O.Event = e, O.Event.prototype = e.prototype)
                    }

                    function H(e, t, n) {
                        Object.defineProperty(n || O.Event.prototype, e, {
                            enumerable: !0,
                            configurable: !0,
                            get: function() {
                                return this.originalEvent && t(this.originalEvent)
                            },
                            set: function(t) {
                                Object.defineProperty(this, e, {
                                    enumerable: !0,
                                    configurable: !0,
                                    writable: !0,
                                    value: t
                                })
                            }
                        })
                    }
                    N(function(e) {
                        return O.Event = function(t, n) {
                            if (!(this instanceof O.Event)) {
                                return new O.Event(t, n)
                            }
                            t || (t = {}), "string" == typeof t && (t = {
                                type: t
                            }), n || (n = {}), e.call(this, t, n)
                        }, m(O.Event.prototype, {
                            _propagationStopped: !1,
                            _immediatePropagationStopped: !1,
                            _defaultPrevented: !1,
                            isPropagationStopped: function() {
                                return !!(this._propagationStopped || this.originalEvent && this.originalEvent.propagationStopped)
                            },
                            stopPropagation: function() {
                                this._propagationStopped = !0, this.originalEvent && this.originalEvent.stopPropagation()
                            },
                            isImmediatePropagationStopped: function() {
                                return this._immediatePropagationStopped
                            },
                            stopImmediatePropagation: function() {
                                this.stopPropagation(), this._immediatePropagationStopped = !0, this.originalEvent && this.originalEvent.stopImmediatePropagation()
                            },
                            isDefaultPrevented: function() {
                                return !!(this._defaultPrevented || this.originalEvent && this.originalEvent.defaultPrevented)
                            },
                            preventDefault: function() {
                                this._defaultPrevented = !0, this.originalEvent && this.originalEvent.preventDefault()
                            }
                        }), O.Event
                    }((function(e, t) {
                        var n, i = this;
                        e instanceof O.Event || (0, r.hasWindow)() && e instanceof _.Event || (null === (n = e.view) || void 0 === n ? void 0 : n.Event) && e instanceof e.view.Event ? (i.originalEvent = e, i.type = e.type, i.currentTarget = void 0, i.timeStamp = e.timeStamp || Date.now()) : m(i, e), H("which", F, i), 0 === e.type.indexOf("touch") && (delete t.pageX, delete t.pageY), m(i, t), i.guid = ++T
                    }))), ["target", "relatedTarget", "delegateTarget", "altKey", "bubbles", "cancelable", "changedTouches", "ctrlKey", "detail", "eventPhase", "metaKey", "shiftKey", "view", "char", "code", "charCode", "key", "keyCode", "button", "buttons", "offsetX", "offsetY", "pointerId", "pointerType", "targetTouches", "toElement", "touches"].forEach((function(e) {
                        return H(e, (function(t) {
                            return t[e]
                        }))
                    })), (0, f.default)(H);
                    var j = (0, l.default)(),
                        G = (0, l.default)();
                    O.set = function(e) {
                        j.fire(), O.inject(e), N(e.Event), G.fire()
                    }, O.subscribeGlobal = function() {
                        D(arguments, L((function() {
                            var e = arguments;
                            O.on.apply(this, e), j.add((function() {
                                var t = Array.prototype.slice.call(e, 0);
                                t.splice(3, 1), O.off.apply(this, t)
                            })), G.add((function() {
                                O.on.apply(this, e)
                            }))
                        })))
                    }, O.forcePassiveFalseEventNames = w, O.passiveEventHandlersSupported = P;
                    var W = O;
                    t.default = W, e.exports = t.default, e.exports.default = t.default
                },
            2418:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/hook_touch_props.js ***!
                  \*****************************************************************************/
                function(e, t) {
                    t.default = function(e) {
                        n.forEach((function(t) {
                            e(t, (function(e) {
                                return function(e, t) {
                                    if (t[e] && !t.touches || !t.touches) {
                                        return t[e]
                                    }
                                    var n = t.touches.length ? t.touches : t.changedTouches;
                                    if (!n.length) {
                                        return
                                    }
                                    return n[0][e]
                                }(t, e)
                            }))
                        }), this)
                    };
                    var n = ["pageX", "pageY", "screenX", "screenY", "clientX", "clientY"];
                    e.exports = t.default, e.exports.default = t.default
                },
            51661:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/keyboard_processor.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = c(n( /*! ../../core/renderer */ 68374)),
                        a = c(n( /*! ../../events/core/events_engine */ 55994)),
                        o = c(n( /*! ../../core/class */ 38377)),
                        r = n( /*! ../../core/utils/array */ 89386),
                        s = n( /*! ../../events/utils/index */ 39611);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = "compositionstart",
                        u = "KeyboardProcessor",
                        d = function(e) {
                            return {
                                keyName: (0, s.normalizeKeyName)(e),
                                key: e.key,
                                code: e.code,
                                ctrl: e.ctrlKey,
                                location: e.location,
                                metaKey: e.metaKey,
                                shift: e.shiftKey,
                                alt: e.altKey,
                                which: e.which,
                                originalEvent: e
                            }
                        },
                        f = o.default.inherit({
                            _keydown: (0, s.addNamespace)("keydown", u),
                            _compositionStart: (0, s.addNamespace)(l, u),
                            _compositionEnd: (0, s.addNamespace)("compositionend", u),
                            ctor: function(e) {
                                var t = this;
                                (e = e || {}).element && (this._element = (0, i.default)(e.element)), e.focusTarget && (this._focusTarget = e.focusTarget), this._handler = e.handler, this._element && (this._processFunction = function(e) {
                                    var n = t._focusTarget && t._focusTarget !== e.target && (0, r.inArray)(e.target, (0, i.default)(t._focusTarget)) < 0,
                                        a = t._isComposingJustFinished && 229 === e.which || t._isComposing || n;
                                    t._isComposingJustFinished = !1, a || t.process(e)
                                }, this._toggleProcessingWithContext = this.toggleProcessing.bind(this), a.default.on(this._element, this._keydown, this._processFunction), a.default.on(this._element, this._compositionStart, this._toggleProcessingWithContext), a.default.on(this._element, this._compositionEnd, this._toggleProcessingWithContext))
                            },
                            dispose: function() {
                                this._element && (a.default.off(this._element, this._keydown, this._processFunction), a.default.off(this._element, this._compositionStart, this._toggleProcessingWithContext), a.default.off(this._element, this._compositionEnd, this._toggleProcessingWithContext)), this._element = void 0, this._handler = void 0
                            },
                            process: function(e) {
                                this._handler(d(e))
                            },
                            toggleProcessing: function(e) {
                                var t = e.type;
                                this._isComposing = t === l, this._isComposingJustFinished = !this._isComposing
                            }
                        });
                    f.createKeyDownOptions = d;
                    var h = f;
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            765:
                /*!******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/core/wheel.js ***!
                  \******************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = s(n( /*! ../../core/renderer */ 68374)),
                        a = s(n( /*! ../../events/core/events_engine */ 55994)),
                        o = s(n( /*! ./event_registrator */ 85788)),
                        r = n( /*! ../utils/index */ 39611);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dxmousewheel";
                    t.name = c;
                    var l = "dxWheel",
                        u = {
                            setup: function(e) {
                                var t = (0, i.default)(e);
                                a.default.on(t, (0, r.addNamespace)("wheel", l), u._wheelHandler.bind(u))
                            },
                            teardown: function(e) {
                                a.default.off(e, ".".concat(l))
                            },
                            _wheelHandler: function(e) {
                                var t = e.originalEvent,
                                    n = t.deltaMode,
                                    i = t.deltaY,
                                    a = t.deltaX,
                                    o = t.deltaZ;
                                (0, r.fireEvent)({
                                    type: c,
                                    originalEvent: e,
                                    delta: this._normalizeDelta(i, n),
                                    deltaX: a,
                                    deltaY: i,
                                    deltaZ: o,
                                    deltaMode: n,
                                    pointerType: "mouse"
                                }), e.stopPropagation()
                            },
                            _normalizeDelta: function(e) {
                                var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                                return 0 === t ? -e : -30 * e
                            }
                        };
                    (0, o.default)(c, u)
                },
            85272:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/double_click.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.name = void 0;
                    var i = u(n( /*! ../events/core/events_engine */ 55994)),
                        a = n( /*! ../core/utils/dom */ 3532),
                        o = u(n( /*! ../core/dom_adapter */ 73349)),
                        r = u(n( /*! ../core/class */ 38377)),
                        s = u(n( /*! ./core/event_registrator */ 85788)),
                        c = n( /*! ./click */ 95429),
                        l = n( /*! ./utils/index */ 39611);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = "dxdblclick";
                    t.name = d;
                    var f = (0, l.addNamespace)(c.name, "dxDblClick"),
                        h = r.default.inherit({
                            ctor: function() {
                                this._handlerCount = 0, this._forgetLastClick()
                            },
                            _forgetLastClick: function() {
                                this._firstClickTarget = null, this._lastClickTimeStamp = -300
                            },
                            add: function() {
                                this._handlerCount <= 0 && i.default.on(o.default.getDocument(), f, this._clickHandler.bind(this)), this._handlerCount++
                            },
                            _clickHandler: function(e) {
                                var t = e.timeStamp || Date.now(),
                                    n = t - this._lastClickTimeStamp;
                                !(n < 0) && n < 300 ? ((0, l.fireEvent)({
                                    type: d,
                                    target: (0, a.closestCommonParent)(this._firstClickTarget, e.target),
                                    originalEvent: e
                                }), this._forgetLastClick()) : (this._firstClickTarget = e.target, this._lastClickTimeStamp = t)
                            },
                            remove: function() {
                                this._handlerCount--, this._handlerCount <= 0 && (this._forgetLastClick(), i.default.off(o.default.getDocument(), f))
                            }
                        });
                    (0, s.default)(d, new h)
                },
            23174:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/drag.js ***!
                  \************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.start = t.move = t.leave = t.enter = t.end = t.drop = void 0;
                    var a = g(n( /*! ../core/renderer */ 68374)),
                        o = n( /*! ../core/element_data */ 97906),
                        r = n( /*! ../core/utils/array */ 89386),
                        s = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var a = {},
                                o = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = o ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(a, r, s) : a[r] = e[r]
                                }
                            }
                            a.default = e, n && n.set(e, a);
                            return a
                        }(n( /*! ../core/utils/iterator */ 95479)),
                        c = n( /*! ../core/utils/dom */ 3532),
                        l = g(n( /*! ./core/event_registrator */ 85788)),
                        u = n( /*! ./utils/index */ 39611),
                        d = g(n( /*! ./gesture/emitter.gesture */ 98621)),
                        f = g(n( /*! ./core/emitter_registrator */ 82495));

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var p = "dxdragstart";
                    t.start = p;
                    var m = "dxdrag";
                    t.move = m;
                    var _ = "dxdragend";
                    t.end = _;
                    var v = "dxdragenter";
                    t.enter = v;
                    var x = "dxdragleave";
                    t.leave = x;
                    var y = "dxdrop";
                    t.drop = y;
                    var b = "dxDragEventsCount",
                        w = [],
                        k = [],
                        S = [],
                        C = {
                            setup: function(e, t) {
                                -1 !== (0, r.inArray)(e, w) || (w.push(e), k.push([]), S.push(t || {}))
                            },
                            add: function(e, t) {
                                var n = (0, r.inArray)(e, w);
                                this.updateEventsCounter(e, t.type, 1);
                                var i = t.selector; - 1 === (0, r.inArray)(i, k[n]) && k[n].push(i)
                            },
                            updateEventsCounter: function(e, t, n) {
                                if ([v, x, y].indexOf(t) > -1) {
                                    var i = (0, o.data)(e, b) || 0;
                                    (0, o.data)(e, b, Math.max(0, i + n))
                                }
                            },
                            remove: function(e, t) {
                                this.updateEventsCounter(e, t.type, -1)
                            },
                            teardown: function(e) {
                                if (!(0, o.data)(e, b)) {
                                    var t = (0, r.inArray)(e, w);
                                    w.splice(t, 1), k.splice(t, 1), S.splice(t, 1), (0, o.removeData)(e, b)
                                }
                            }
                        };
                    (0, l.default)(v, C), (0, l.default)(x, C), (0, l.default)(y, C);
                    var A = d.default.inherit({
                        ctor: function(e) {
                            this.callBase(e), this.direction = "both"
                        },
                        _init: function(e) {
                            this._initEvent = e
                        },
                        _start: function(e) {
                            e = this._fireEvent(p, this._initEvent), this._maxLeftOffset = e.maxLeftOffset, this._maxRightOffset = e.maxRightOffset, this._maxTopOffset = e.maxTopOffset, this._maxBottomOffset = e.maxBottomOffset;
                            var t = (0, r.wrapToArray)(e.targetElements || (null === e.targetElements ? [] : w));
                            this._dropTargets = s.map(t, (function(e) {
                                return (0, a.default)(e).get(0)
                            }))
                        },
                        _move: function(e) {
                            var t = (0, u.eventData)(e),
                                n = this._calculateOffset(t);
                            e = this._fireEvent(m, e, {
                                offset: n
                            }), this._processDropTargets(e), e._cancelPreventDefault || e.preventDefault()
                        },
                        _calculateOffset: function(e) {
                            return {
                                x: this._calculateXOffset(e),
                                y: this._calculateYOffset(e)
                            }
                        },
                        _calculateXOffset: function(e) {
                            if ("vertical" !== this.direction) {
                                var t = e.x - this._startEventData.x;
                                return this._fitOffset(t, this._maxLeftOffset, this._maxRightOffset)
                            }
                            return 0
                        },
                        _calculateYOffset: function(e) {
                            if ("horizontal" !== this.direction) {
                                var t = e.y - this._startEventData.y;
                                return this._fitOffset(t, this._maxTopOffset, this._maxBottomOffset)
                            }
                            return 0
                        },
                        _fitOffset: function(e, t, n) {
                            return null != t && (e = Math.max(e, -t)), null != n && (e = Math.min(e, n)), e
                        },
                        _processDropTargets: function(e) {
                            var t = this._findDropTarget(e);
                            t === this._currentDropTarget || (this._fireDropTargetEvent(e, x), this._currentDropTarget = t, this._fireDropTargetEvent(e, v))
                        },
                        _fireDropTargetEvent: function(e, t) {
                            if (this._currentDropTarget) {
                                var n = {
                                    type: t,
                                    originalEvent: e,
                                    draggingElement: this._$element.get(0),
                                    target: this._currentDropTarget
                                };
                                (0, u.fireEvent)(n)
                            }
                        },
                        _findDropTarget: function(e) {
                            var t, n = this;
                            return s.each(w, (function(i, o) {
                                if (n._checkDropTargetActive(o)) {
                                    var c, l, u, d, f = (0, a.default)(o);
                                    s.each((c = f, l = (0, r.inArray)(c.get(0), w), u = k[l].filter((function(e) {
                                        return e
                                    })), d = c.find(u.join(", ")), -1 !== (0, r.inArray)(void 0, k[l]) && (d = d.add(c)), d), (function(i, o) {
                                        var s = (0, a.default)(o);
                                        n._checkDropTarget(function(e) {
                                            var t = (0, r.inArray)(e.get(0), w);
                                            return S[t]
                                        }(f), s, (0, a.default)(t), e) && (t = o)
                                    }))
                                }
                            })), t
                        },
                        _checkDropTargetActive: function(e) {
                            var t = !1;
                            return s.each(this._dropTargets, (function(n, i) {
                                return !(t = t || i === e || (0, c.contains)(i, e))
                            })), t
                        },
                        _checkDropTarget: function(e, t, n, i) {
                            if (t.get(0) === (0, a.default)(i.target).get(0)) {
                                return !1
                            }
                            var o, r, s = (r = t, (o = e).itemPositionFunc ? o.itemPositionFunc(r) : r.offset());
                            if (i.pageX < s.left) {
                                return !1
                            }
                            if (i.pageY < s.top) {
                                return !1
                            }
                            var c = function(e, t) {
                                return e.itemSizeFunc ? e.itemSizeFunc(t) : {
                                    width: t.get(0).getBoundingClientRect().width,
                                    height: t.get(0).getBoundingClientRect().height
                                }
                            }(e, t);
                            return !(i.pageX > s.left + c.width) && !(i.pageY > s.top + c.height) && (!n.length || !n.closest(t).length) && !(e.checkDropTarget && !e.checkDropTarget(t, i)) && t
                        },
                        _end: function(e) {
                            var t = (0, u.eventData)(e);
                            this._fireEvent(_, e, {
                                offset: this._calculateOffset(t)
                            }), this._fireDropTargetEvent(e, y), delete this._currentDropTarget
                        }
                    });
                    (0, f.default)({
                        emitter: A,
                        events: [p, m, _]
                    })
                },
            98621:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/gesture/emitter.gesture.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = p(n( /*! ../../core/renderer */ 68374)),
                        a = p(n( /*! ../../events/core/events_engine */ 55994)),
                        o = p(n( /*! ../../core/devices */ 20530)),
                        r = n( /*! ../../core/utils/style */ 80968),
                        s = p(n( /*! ../../core/utils/call_once */ 39618)),
                        c = n( /*! ../../core/utils/dom */ 3532),
                        l = p(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        u = n( /*! ../../core/utils/math */ 60810),
                        d = n( /*! ../../core/utils/common */ 20576),
                        f = n( /*! ../../core/utils/type */ 35922),
                        h = n( /*! ../utils/index */ 39611),
                        g = p(n( /*! ../core/emitter */ 31391));

                    function p(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var m = l.default.add,
                        _ = Math.abs,
                        v = 10,
                        x = (0, s.default)((function() {
                            var e = "desktop" === o.default.real().deviceType;
                            if (!(0, r.styleProp)("pointer-events") || !e) {
                                return d.noop
                            }
                            var t = (0, i.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents", "none");
                            return a.default.subscribeGlobal(t, "dxmousewheel", (function(e) {
                                    e.preventDefault()
                                })), m((function() {
                                    t.appendTo("body")
                                })),
                                function(e, n) {
                                    t.css("pointerEvents", e ? "all" : "none"), e && t.css("cursor", n)
                                }
                        })),
                        y = g.default.inherit({
                            gesture: !0,
                            configure: function(e) {
                                this.getElement().css("msTouchAction", e.immediate ? "pinch-zoom" : ""), this.callBase(e)
                            },
                            allowInterruptionByMouseWheel: function() {
                                return 2 !== this._stage
                            },
                            getDirection: function() {
                                return this.direction
                            },
                            _cancel: function() {
                                this.callBase.apply(this, arguments), this._toggleGestureCover(!1), this._stage = 0
                            },
                            start: function(e) {
                                e._needSkipEvent || (0, h.needSkipEvent)(e) ? this._cancel(e) : (this._startEvent = (0, h.createEvent)(e), this._startEventData = (0, h.eventData)(e), this._stage = 1, this._init(e), this._setupImmediateTimer())
                            },
                            _setupImmediateTimer: function() {
                                clearTimeout(this._immediateTimer), this._immediateAccepted = !1, this.immediate && (this._immediateTimer = setTimeout(function() {
                                    this._immediateAccepted = !0
                                }.bind(this), 180))
                            },
                            move: function(e) {
                                if (1 === this._stage && this._directionConfirmed(e)) {
                                    if (this._stage = 2, this._resetActiveElement(), this._toggleGestureCover(!0), this._clearSelection(e), this._adjustStartEvent(e), this._start(this._startEvent), 0 === this._stage) {
                                        return
                                    }
                                    this._requestAccept(e), this._move(e), this._forgetAccept()
                                } else {
                                    2 === this._stage && (this._clearSelection(e), this._move(e))
                                }
                            },
                            _directionConfirmed: function(e) {
                                var t = this._getTouchBoundary(e),
                                    n = (0, h.eventDelta)(this._startEventData, (0, h.eventData)(e)),
                                    i = _(n.x),
                                    a = _(n.y),
                                    o = this._validateMove(t, i, a),
                                    r = this._validateMove(t, a, i),
                                    s = this.getDirection(e);
                                return "both" === s && (o || r) || "horizontal" === s && o || "vertical" === s && r || this._immediateAccepted
                            },
                            _validateMove: function(e, t, n) {
                                return t && t >= e && (!this.immediate || t >= n)
                            },
                            _getTouchBoundary: function(e) {
                                return this.immediate || (0, h.isDxMouseWheelEvent)(e) ? 0 : v
                            },
                            _adjustStartEvent: function(e) {
                                var t = this._getTouchBoundary(e),
                                    n = (0, h.eventDelta)(this._startEventData, (0, h.eventData)(e));
                                this._startEvent.pageX += (0, u.sign)(n.x) * t, this._startEvent.pageY += (0, u.sign)(n.y) * t
                            },
                            _resetActiveElement: function() {
                                "ios" === o.default.real().platform && this.getElement().find(":focus").length && (0, c.resetActiveElement)()
                            },
                            _toggleGestureCover: function(e) {
                                this._toggleGestureCoverImpl(e)
                            },
                            _toggleGestureCoverImpl: function(e) {
                                2 === this._stage && function(e, t) {
                                    x()(e, t)
                                }(e, this.getElement().css("cursor"))
                            },
                            _clearSelection: function(e) {
                                (0, h.isDxMouseWheelEvent)(e) || (0, h.isTouchEvent)(e) || (0, c.clearSelection)()
                            },
                            end: function(e) {
                                this._toggleGestureCover(!1), 2 === this._stage ? this._end(e) : 1 === this._stage && this._stop(e), this._stage = 0
                            },
                            dispose: function() {
                                clearTimeout(this._immediateTimer), this.callBase.apply(this, arguments), this._toggleGestureCover(!1)
                            },
                            _init: d.noop,
                            _start: d.noop,
                            _move: d.noop,
                            _stop: d.noop,
                            _end: d.noop
                        });
                    y.initialTouchBoundary = v, y.touchBoundary = function(e) {
                        if (!(0, f.isDefined)(e)) {
                            return v
                        }
                        v = e
                    };
                    var b = y;
                    t.default = b, e.exports = t.default, e.exports.default = t.default
                },
            11699:
                /*!************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/hold.js ***!
                  \************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./utils/index */ 39611),
                        a = r(n( /*! ./core/emitter */ 31391)),
                        o = r(n( /*! ./core/emitter_registrator */ 82495));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = Math.abs,
                        c = "dxhold",
                        l = a.default.inherit({
                            start: function(e) {
                                this._startEventData = (0, i.eventData)(e), this._startTimer(e)
                            },
                            _startTimer: function(e) {
                                var t = "timeout" in this ? this.timeout : 750;
                                this._holdTimer = setTimeout(function() {
                                    this._requestAccept(e), this._fireEvent(c, e, {
                                        target: e.target
                                    }), this._forgetAccept()
                                }.bind(this), t)
                            },
                            move: function(e) {
                                this._touchWasMoved(e) && this._cancel(e)
                            },
                            _touchWasMoved: function(e) {
                                var t = (0, i.eventDelta)(this._startEventData, (0, i.eventData)(e));
                                return s(t.x) > 5 || s(t.y) > 5
                            },
                            end: function() {
                                this._stopTimer()
                            },
                            _stopTimer: function() {
                                clearTimeout(this._holdTimer)
                            },
                            cancel: function() {
                                this._stopTimer()
                            },
                            dispose: function() {
                                this._stopTimer()
                            }
                        });
                    (0, o.default)({
                        emitter: l,
                        bubble: !0,
                        events: [c]
                    });
                    var u = {
                        name: c
                    };
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            24028:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/hover.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.start = t.end = void 0;
                    var i = u(n( /*! ../events/core/events_engine */ 55994)),
                        a = n( /*! ../core/element_data */ 97906),
                        o = u(n( /*! ../core/class */ 38377)),
                        r = u(n( /*! ../core/devices */ 20530)),
                        s = u(n( /*! ./core/event_registrator */ 85788)),
                        c = n( /*! ./utils/index */ 39611),
                        l = u(n( /*! ./pointer */ 93786));

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = "dxHoverStart",
                        f = "dxhoverstart";
                    t.start = f;
                    var h = (0, c.addNamespace)(l.default.enter, d),
                        g = "dxHoverEnd",
                        p = "dxhoverend";
                    t.end = p;
                    var m = (0, c.addNamespace)(l.default.leave, g),
                        _ = o.default.inherit({
                            noBubble: !0,
                            ctor: function() {
                                this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
                            },
                            setup: function(e) {
                                (0, a.data)(e, this._handlerArrayKeyPath, {})
                            },
                            add: function(e, t) {
                                var n = this,
                                    o = function(e) {
                                        n._handler(e)
                                    };
                                i.default.on(e, this._originalEventName, t.selector, o), (0, a.data)(e, this._handlerArrayKeyPath)[t.guid] = o
                            },
                            _handler: function(e) {
                                (0, c.isTouchEvent)(e) || r.default.isSimulator() || (0, c.fireEvent)({
                                    type: this._eventName,
                                    originalEvent: e,
                                    delegateTarget: e.delegateTarget
                                })
                            },
                            remove: function(e, t) {
                                var n = (0, a.data)(e, this._handlerArrayKeyPath)[t.guid];
                                i.default.off(e, this._originalEventName, t.selector, n)
                            },
                            teardown: function(e) {
                                (0, a.removeData)(e, this._handlerArrayKeyPath)
                            }
                        }),
                        v = _.inherit({
                            ctor: function() {
                                this._eventNamespace = d, this._eventName = f, this._originalEventName = h, this.callBase()
                            },
                            _handler: function(e) {
                                (e.pointers || []).length || this.callBase(e)
                            }
                        }),
                        x = _.inherit({
                            ctor: function() {
                                this._eventNamespace = g, this._eventName = p, this._originalEventName = m, this.callBase()
                            }
                        });
                    (0, s.default)(f, new v), (0, s.default)(p, new x)
                },
            66365:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/index.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.triggerHandler = t.trigger = t.one = t.on = t.off = t.Event = void 0;
                    var i, a = (i = n( /*! ./core/events_engine */ 55994)) && i.__esModule ? i : {
                        default: i
                    };
                    var o = a.default.on;
                    t.on = o;
                    var r = a.default.one;
                    t.one = r;
                    var s = a.default.off;
                    t.off = s;
                    var c = a.default.trigger;
                    t.trigger = c;
                    var l = a.default.triggerHandler;
                    t.triggerHandler = l;
                    var u = a.default.Event;
                    t.Event = u
                },
            93786:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.default = void 0;
                    var a = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var a = {},
                                o = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = o ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(a, r, s) : a[r] = e[r]
                                }
                            }
                            a.default = e, n && n.set(e, a);
                            return a
                        }(n( /*! ../core/utils/support */ 60137)),
                        o = n( /*! ../core/utils/iterator */ 95479),
                        r = d(n( /*! ../core/devices */ 20530)),
                        s = d(n( /*! ./core/event_registrator */ 85788)),
                        c = d(n( /*! ./pointer/touch */ 69120)),
                        l = d(n( /*! ./pointer/mouse */ 66509)),
                        u = d(n( /*! ./pointer/mouse_and_touch */ 87720));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var h = function(e, t) {
                        var n = t.tablet,
                            i = t.phone;
                        return !e.touch || n || i ? e.touch ? c.default : l.default : u.default
                    }(a, r.default.real());
                    (0, o.each)(h.map, (function(e, t) {
                        (0, s.default)(e, new h(e, t))
                    }));
                    t.default = {
                        down: "dxpointerdown",
                        up: "dxpointerup",
                        move: "dxpointermove",
                        cancel: "dxpointercancel",
                        enter: "dxpointerenter",
                        leave: "dxpointerleave",
                        over: "dxpointerover",
                        out: "dxpointerout"
                    }, e.exports = t.default, e.exports.default = t.default
                },
            88136:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/base.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = c(n( /*! ../../events/core/events_engine */ 55994)),
                        a = c(n( /*! ../../core/utils/browser */ 47810)),
                        o = c(n( /*! ../../core/dom_adapter */ 73349)),
                        r = c(n( /*! ../../core/class */ 38377)),
                        s = n( /*! ../utils/index */ 39611);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = r.default.inherit({
                        ctor: function(e, t) {
                            this._eventName = e, this._originalEvents = (0, s.addNamespace)(t, "dxPointerEvents"), this._handlerCount = 0, this.noBubble = this._isNoBubble()
                        },
                        _isNoBubble: function() {
                            var e = this._eventName;
                            return "dxpointerenter" === e || "dxpointerleave" === e
                        },
                        _handler: function(e) {
                            var t = this._getDelegateTarget(e);
                            return this._fireEvent({
                                type: this._eventName,
                                pointerType: e.pointerType || (0, s.eventSource)(e),
                                originalEvent: e,
                                delegateTarget: t,
                                timeStamp: a.default.mozilla ? (new Date).getTime() : e.timeStamp
                            })
                        },
                        _getDelegateTarget: function(e) {
                            var t;
                            return this.noBubble && (t = e.delegateTarget), t
                        },
                        _fireEvent: function(e) {
                            return (0, s.fireEvent)(e)
                        },
                        _setSelector: function(e) {
                            this._selector = this.noBubble && e ? e.selector : null
                        },
                        _getSelector: function() {
                            return this._selector
                        },
                        setup: function() {
                            return !0
                        },
                        add: function(e, t) {
                            if (this._handlerCount <= 0 || this.noBubble) {
                                e = this.noBubble ? e : o.default.getDocument(), this._setSelector(t);
                                var n = this;
                                i.default.on(e, this._originalEvents, this._getSelector(), (function(e) {
                                    n._handler(e)
                                }))
                            }
                            this.noBubble || this._handlerCount++
                        },
                        remove: function(e) {
                            this._setSelector(e), this.noBubble || this._handlerCount--
                        },
                        teardown: function(e) {
                            this._handlerCount && !this.noBubble || (e = this.noBubble ? e : o.default.getDocument(), ".dxPointerEvents" !== this._originalEvents && i.default.off(e, this._originalEvents, this._getSelector()))
                        },
                        dispose: function(e) {
                            e = this.noBubble ? e : o.default.getDocument(), i.default.off(e, this._originalEvents)
                        }
                    });
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            66509:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/extend */ 13306),
                        a = r(n( /*! ./base */ 88136)),
                        o = r(n( /*! ./observer */ 25544));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s, c = {
                            dxpointerdown: "mousedown",
                            dxpointermove: "mousemove",
                            dxpointerup: "mouseup",
                            dxpointercancel: "",
                            dxpointerover: "mouseover",
                            dxpointerout: "mouseout",
                            dxpointerenter: "mouseenter",
                            dxpointerleave: "mouseleave"
                        },
                        l = function(e) {
                            return e.pointerId = 1, {
                                pointers: s.pointers(),
                                pointerId: 1
                            }
                        },
                        u = !1,
                        d = function() {
                            u || (s = new o.default(c, (function() {
                                return !0
                            })), u = !0)
                        },
                        f = a.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), d()
                            },
                            _fireEvent: function(e) {
                                return this.callBase((0, i.extend)(l(e.originalEvent), e))
                            }
                        });
                    f.map = c, f.normalize = l, f.activate = d, f.resetObserver = function() {
                        s.reset()
                    };
                    var h = f;
                    t.default = h, e.exports = t.default, e.exports.default = t.default
                },
            87720:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse_and_touch.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/extend */ 13306),
                        a = c(n( /*! ./base */ 88136)),
                        o = c(n( /*! ./mouse */ 66509)),
                        r = c(n( /*! ./touch */ 69120)),
                        s = n( /*! ../utils/index */ 39611);

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = !1,
                        u = function() {
                            l || (o.default.activate(), l = !0)
                        },
                        d = a.default.inherit({
                            EVENT_LOCK_TIMEOUT: 100,
                            ctor: function() {
                                this.callBase.apply(this, arguments), u()
                            },
                            _handler: function(e) {
                                var t = (0, s.isMouseEvent)(e);
                                if (t || (this._skipNextEvents = !0), !t || !this._mouseLocked) {
                                    if (!t || !this._skipNextEvents) {
                                        return this.callBase(e)
                                    }
                                    this._skipNextEvents = !1, this._mouseLocked = !0, clearTimeout(this._unlockMouseTimer);
                                    var n = this;
                                    this._unlockMouseTimer = setTimeout((function() {
                                        n._mouseLocked = !1
                                    }), this.EVENT_LOCK_TIMEOUT)
                                }
                            },
                            _fireEvent: function(e) {
                                var t = (0, s.isMouseEvent)(e.originalEvent) ? o.default.normalize : r.default.normalize;
                                return this.callBase((0, i.extend)(t(e.originalEvent), e))
                            },
                            dispose: function() {
                                this.callBase(), this._skipNextEvents = !1, this._mouseLocked = !1, clearTimeout(this._unlockMouseTimer)
                            }
                        });
                    d.map = {
                        dxpointerdown: "touchstart mousedown",
                        dxpointermove: "touchmove mousemove",
                        dxpointerup: "touchend mouseup",
                        dxpointercancel: "touchcancel",
                        dxpointerover: "mouseover",
                        dxpointerout: "mouseout",
                        dxpointerenter: "mouseenter",
                        dxpointerleave: "mouseleave"
                    }, d.resetObserver = o.default.resetObserver;
                    var f = d;
                    t.default = f, e.exports = t.default, e.exports.default = t.default
                },
            25544:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/observer.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/iterator */ 95479),
                        a = r(n( /*! ../../core/utils/ready_callbacks */ 24311)),
                        o = r(n( /*! ../../core/dom_adapter */ 73349));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = function(e, t) {
                        a.default.add((function() {
                            e.split(" ").forEach((function(e) {
                                o.default.listen(o.default.getDocument(), e, t, !0)
                            }))
                        }))
                    };
                    t.default = function(e, t, n) {
                        n = n || function() {};
                        var a = [],
                            o = function(e) {
                                var n = -1;
                                return (0, i.each)(a, (function(i, a) {
                                    return !t(e, a) || (n = i, !1)
                                })), n
                            },
                            r = function(e) {
                                var t = o(e);
                                t > -1 && a.splice(t, 1)
                            };
                        s(e.dxpointerdown, (function(e) {
                            -1 === o(e) && (n(e), a.push(e))
                        })), s(e.dxpointermove, (function(e) {
                            a[o(e)] = e
                        })), s(e.dxpointerup, r), s(e.dxpointercancel, r), this.pointers = function() {
                            return a
                        }, this.reset = function() {
                            a = []
                        }
                    }, e.exports = t.default, e.exports.default = t.default
                },
            69120:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/pointer/touch.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = s(n( /*! ../../core/devices */ 20530)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = n( /*! ../../core/utils/iterator */ 95479),
                        r = s(n( /*! ./base */ 88136));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = function(e) {
                            var t = [];
                            return (0, o.each)(e.touches, (function(e, n) {
                                t.push((0, a.extend)({
                                    pointerId: n.identifier
                                }, n))
                            })), {
                                pointers: t,
                                pointerId: e.changedTouches[0].identifier
                            }
                        },
                        l = function(e) {
                            return "ios" === i.default.real().platform && ("dxpointerdown" === e || "dxpointerup" === e)
                        },
                        u = r.default.inherit({
                            ctor: function() {
                                this.callBase.apply(this, arguments), this._pointerId = 0
                            },
                            _handler: function(e) {
                                if (l(this._eventName)) {
                                    var t = e.changedTouches[0];
                                    if (this._pointerId === t.identifier && 0 !== this._pointerId) {
                                        return
                                    }
                                    this._pointerId = t.identifier
                                }
                                return this.callBase.apply(this, arguments)
                            },
                            _fireEvent: function(e) {
                                return this.callBase((0, a.extend)(c(e.originalEvent), e))
                            }
                        });
                    u.map = {
                        dxpointerdown: "touchstart",
                        dxpointermove: "touchmove",
                        dxpointerup: "touchend",
                        dxpointercancel: "touchcancel",
                        dxpointerover: "",
                        dxpointerout: "",
                        dxpointerenter: "",
                        dxpointerleave: ""
                    }, u.normalize = c;
                    var d = u;
                    t.default = d, e.exports = t.default, e.exports.default = t.default
                },
            72918:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/short.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.visibility = t.resize = t.keyboard = t.hover = t.focus = t.dxClick = t.click = t.active = void 0;
                    var i = s(n( /*! ../core/dom_adapter */ 73349)),
                        a = s(n( /*! ./core/events_engine */ 55994)),
                        o = s(n( /*! ./core/keyboard_processor */ 51661)),
                        r = n( /*! ./utils/index */ 39611);

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function c(e, t) {
                        return t ? (0, r.addNamespace)(e, t) : e
                    }

                    function l(e, t) {
                        return "function" == typeof e ? e(t) : e.execute(t)
                    }
                    var u = {
                        on: function(e, t, n, i) {
                            var o = i.selector,
                                r = i.showTimeout,
                                s = i.hideTimeout,
                                u = i.namespace;
                            a.default.on(e, c("dxactive", u), o, {
                                timeout: r
                            }, (function(e) {
                                return l(t, {
                                    event: e,
                                    element: e.currentTarget
                                })
                            })), a.default.on(e, c("dxinactive", u), o, {
                                timeout: s
                            }, (function(e) {
                                return l(n, {
                                    event: e,
                                    element: e.currentTarget
                                })
                            }))
                        },
                        off: function(e, t) {
                            var n = t.namespace,
                                i = t.selector;
                            a.default.off(e, c("dxactive", n), i), a.default.off(e, c("dxinactive", n), i)
                        }
                    };
                    t.active = u;
                    var d = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            a.default.on(e, c("dxresize", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            a.default.off(e, c("dxresize", n))
                        }
                    };
                    t.resize = d;
                    var f = {
                        on: function(e, t, n, i) {
                            var o = i.selector,
                                r = i.namespace;
                            a.default.on(e, c("dxhoverend", r), o, (function(e) {
                                return n(e)
                            })), a.default.on(e, c("dxhoverstart", r), o, (function(e) {
                                return l(t, {
                                    element: e.target,
                                    event: e
                                })
                            }))
                        },
                        off: function(e, t) {
                            var n = t.selector,
                                i = t.namespace;
                            a.default.off(e, c("dxhoverstart", i), n), a.default.off(e, c("dxhoverend", i), n)
                        }
                    };
                    t.hover = f;
                    var h = {
                        on: function(e, t, n, i) {
                            var o = i.namespace;
                            a.default.on(e, c("dxhiding", o), n), a.default.on(e, c("dxshown", o), t)
                        },
                        off: function(e, t) {
                            var n = t.namespace;
                            a.default.off(e, c("dxhiding", n)), a.default.off(e, c("dxshown", n))
                        }
                    };
                    t.visibility = h;
                    var g = {
                        on: function(e, t, n, o) {
                            var r = o.namespace,
                                s = o.isFocusable;
                            a.default.on(e, c("focusin", r), t), a.default.on(e, c("focusout", r), n), i.default.hasDocumentProperty("onbeforeactivate") && a.default.on(e, c("beforeactivate", r), (function(e) {
                                return s(null, e.target) || e.preventDefault()
                            }))
                        },
                        off: function(e, t) {
                            var n = t.namespace;
                            a.default.off(e, c("focusin", n)), a.default.off(e, c("focusout", n)), i.default.hasDocumentProperty("onbeforeactivate") && a.default.off(e, c("beforeactivate", n))
                        },
                        trigger: function(e) {
                            return a.default.trigger(e, "focus")
                        }
                    };
                    t.focus = g;
                    var p = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            a.default.on(e, c("dxclick", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            a.default.off(e, c("dxclick", n))
                        }
                    };
                    t.dxClick = p;
                    var m = {
                        on: function(e, t) {
                            var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                                i = n.namespace;
                            a.default.on(e, c("click", i), t)
                        },
                        off: function(e) {
                            var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                                n = t.namespace;
                            a.default.off(e, c("click", n))
                        }
                    };
                    t.click = m;
                    var _ = 0,
                        v = {},
                        x = {
                            on: function(e, t, n) {
                                var i = "keyboardProcessorId".concat(_++);
                                return v[i] = new o.default({
                                    element: e,
                                    focusTarget: t,
                                    handler: n
                                }), i
                            },
                            off: function(e) {
                                e && v[e] && (v[e].dispose(), delete v[e])
                            },
                            _getProcessor: function(e) {
                                return v[e]
                            }
                        };
                    t.keyboard = x
                },
            34309:
                /*!*************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/swipe.js ***!
                  \*************************************************************/
                function(e, t, n) {
                    t.swipe = t.start = t.end = void 0;
                    var i = n( /*! ../core/utils/size */ 58664),
                        a = n( /*! ./utils/index */ 39611),
                        o = s(n( /*! ./gesture/emitter.gesture */ 98621)),
                        r = s(n( /*! ./core/emitter_registrator */ 82495));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var c = "dxswipestart";
                    t.start = c;
                    var l = "dxswipe";
                    t.swipe = l;
                    var u = "dxswipeend";
                    t.end = u;
                    var d = {
                            horizontal: {
                                defaultItemSizeFunc: function() {
                                    return (0, i.getWidth)(this.getElement())
                                },
                                getBounds: function() {
                                    return [this._maxLeftOffset, this._maxRightOffset]
                                },
                                calcOffsetRatio: function(e) {
                                    return ((0, a.eventData)(e).x - (this._savedEventData && this._savedEventData.x || 0)) / this._itemSizeFunc().call(this, e)
                                },
                                isFastSwipe: function(e) {
                                    var t = (0, a.eventData)(e);
                                    return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(t.x - this._tickData.x) >= t.time - this._tickData.time
                                }
                            },
                            vertical: {
                                defaultItemSizeFunc: function() {
                                    return (0, i.getHeight)(this.getElement())
                                },
                                getBounds: function() {
                                    return [this._maxTopOffset, this._maxBottomOffset]
                                },
                                calcOffsetRatio: function(e) {
                                    return ((0, a.eventData)(e).y - (this._savedEventData && this._savedEventData.y || 0)) / this._itemSizeFunc().call(this, e)
                                },
                                isFastSwipe: function(e) {
                                    var t = (0, a.eventData)(e);
                                    return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(t.y - this._tickData.y) >= t.time - this._tickData.time
                                }
                            }
                        },
                        f = o.default.inherit({
                            TICK_INTERVAL: 300,
                            FAST_SWIPE_SPEED_LIMIT: 10,
                            ctor: function(e) {
                                this.callBase(e), this.direction = "horizontal", this.elastic = !0
                            },
                            _getStrategy: function() {
                                return d[this.direction]
                            },
                            _defaultItemSizeFunc: function() {
                                return this._getStrategy().defaultItemSizeFunc.call(this)
                            },
                            _itemSizeFunc: function() {
                                return this.itemSizeFunc || this._defaultItemSizeFunc
                            },
                            _init: function(e) {
                                this._tickData = (0, a.eventData)(e)
                            },
                            _start: function(e) {
                                this._savedEventData = (0, a.eventData)(e), (e = this._fireEvent(c, e)).cancel || (this._maxLeftOffset = e.maxLeftOffset, this._maxRightOffset = e.maxRightOffset, this._maxTopOffset = e.maxTopOffset, this._maxBottomOffset = e.maxBottomOffset)
                            },
                            _move: function(e) {
                                var t = this._getStrategy(),
                                    n = (0, a.eventData)(e),
                                    i = t.calcOffsetRatio.call(this, e);
                                i = this._fitOffset(i, this.elastic), n.time - this._tickData.time > this.TICK_INTERVAL && (this._tickData = n), this._fireEvent(l, e, {
                                    offset: i
                                }), e.preventDefault()
                            },
                            _end: function(e) {
                                var t = this._getStrategy(),
                                    n = t.calcOffsetRatio.call(this, e),
                                    i = t.isFastSwipe.call(this, e),
                                    a = n,
                                    o = this._calcTargetOffset(n, i);
                                a = this._fitOffset(a, this.elastic), o = this._fitOffset(o, !1), this._fireEvent(u, e, {
                                    offset: a,
                                    targetOffset: o
                                })
                            },
                            _fitOffset: function(e, t) {
                                var n = this._getStrategy().getBounds.call(this);
                                return e < -n[0] ? t ? (-2 * n[0] + e) / 3 : -n[0] : e > n[1] ? t ? (2 * n[1] + e) / 3 : n[1] : e
                            },
                            _calcTargetOffset: function(e, t) {
                                var n;
                                return t ? (n = Math.ceil(Math.abs(e)), e < 0 && (n = -n)) : n = Math.round(e), n
                            }
                        });
                    (0, r.default)({
                        emitter: f,
                        events: [c, l, u]
                    })
                },
            91093:
                /*!*****************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/transform.js ***!
                  \*****************************************************************/
                function(e, t, n) {
                    function i(e) {
                        return i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, i(e)
                    }
                    t.zoomstart = t.zoomend = t.zoom = t.translatestart = t.translateend = t.translate = t.transformstart = t.transformend = t.transform = t.rotatestart = t.rotateend = t.rotate = t.pinchstart = t.pinchend = t.pinch = void 0;
                    var a = n( /*! ../core/utils/math */ 60810),
                        o = function(e, t) {
                            if ((!t, e) && e.__esModule) {
                                return e
                            }
                            if (null === e || "object" !== i(e) && "function" != typeof e) {
                                return {
                                    default: e
                                }
                            }
                            var n = function(e) {
                                if ("function" != typeof WeakMap) {
                                    return null
                                }
                                var t = new WeakMap,
                                    n = new WeakMap;
                                return function(e) {
                                    return e ? n : t
                                }(e)
                            }(t);
                            if (n && n.has(e)) {
                                return n.get(e)
                            }
                            var a = {},
                                o = Object.defineProperty && Object.getOwnPropertyDescriptor;
                            for (var r in e) {
                                if ("default" !== r && Object.prototype.hasOwnProperty.call(e, r)) {
                                    var s = o ? Object.getOwnPropertyDescriptor(e, r) : null;
                                    s && (s.get || s.set) ? Object.defineProperty(a, r, s) : a[r] = e[r]
                                }
                            }
                            a.default = e, n && n.set(e, a);
                            return a
                        }(n( /*! ../core/utils/iterator */ 95479)),
                        r = n( /*! ./utils/index */ 39611),
                        s = l(n( /*! ./core/emitter */ 31391)),
                        c = l(n( /*! ./core/emitter_registrator */ 82495));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = "dx",
                        f = "start",
                        h = "",
                        g = "end",
                        p = [],
                        m = function(e, t) {
                            p.push({
                                name: e,
                                args: t
                            })
                        };
                    m("transform", {
                        scale: !0,
                        deltaScale: !0,
                        rotation: !0,
                        deltaRotation: !0,
                        translation: !0,
                        deltaTranslation: !0
                    }), m("translate", {
                        translation: !0,
                        deltaTranslation: !0
                    }), m("pinch", {
                        scale: !0,
                        deltaScale: !0
                    }), m("rotate", {
                        rotation: !0,
                        deltaRotation: !0
                    });
                    var _ = function(e) {
                            var t, n, i = e.pointers;
                            return t = i[0], {
                                x: (n = i[1]).pageX - t.pageX,
                                y: -n.pageY + t.pageY,
                                centerX: .5 * (n.pageX + t.pageX),
                                centerY: .5 * (n.pageY + t.pageY)
                            }
                        },
                        v = function(e) {
                            return Math.sqrt(e.x * e.x + e.y * e.y)
                        },
                        x = function(e, t) {
                            return v(e) / v(t)
                        },
                        y = function(e, t) {
                            var n = e.x * t.x + e.y * t.y,
                                i = v(e) * v(t);
                            return 0 === i ? 0 : (0, a.sign)(e.x * t.y - t.x * e.y) * Math.acos((0, a.fitIntoRange)(n / i, -1, 1))
                        },
                        b = function(e, t) {
                            return {
                                x: e.centerX - t.centerX,
                                y: e.centerY - t.centerY
                            }
                        },
                        w = s.default.inherit({
                            validatePointers: function(e) {
                                return (0, r.hasTouches)(e) > 1
                            },
                            start: function(e) {
                                this._accept(e);
                                var t = _(e);
                                this._startVector = t, this._prevVector = t, this._fireEventAliases(f, e)
                            },
                            move: function(e) {
                                var t = _(e),
                                    n = this._getEventArgs(t);
                                this._fireEventAliases(h, e, n), this._prevVector = t
                            },
                            end: function(e) {
                                var t = this._getEventArgs(this._prevVector);
                                this._fireEventAliases(g, e, t)
                            },
                            _getEventArgs: function(e) {
                                return {
                                    scale: x(e, this._startVector),
                                    deltaScale: x(e, this._prevVector),
                                    rotation: y(e, this._startVector),
                                    deltaRotation: y(e, this._prevVector),
                                    translation: b(e, this._startVector),
                                    deltaTranslation: b(e, this._prevVector)
                                }
                            },
                            _fireEventAliases: function(e, t, n) {
                                n = n || {}, o.each(p, function(i, a) {
                                    var r = {};
                                    o.each(a.args, (function(e) {
                                        e in n && (r[e] = n[e])
                                    })), this._fireEvent(d + a.name + e, t, r)
                                }.bind(this))
                            }
                        }),
                        k = p.reduce((function(e, t) {
                            return [f, h, g].forEach((function(n) {
                                e.push(d + t.name + n)
                            })), e
                        }), []);
                    (0, c.default)({
                        emitter: w,
                        events: k
                    });
                    var S = {};
                    o.each(k, (function(e, t) {
                        S[t.substring(d.length)] = t
                    }));
                    var C = S.transformstart,
                        A = S.transform,
                        I = S.transformend,
                        T = S.translatestart,
                        E = S.translate,
                        O = S.translateend,
                        D = S.zoomstart,
                        M = S.zoom,
                        P = S.zoomend,
                        R = S.pinchstart,
                        q = S.pinch,
                        z = S.pinchend,
                        L = S.rotatestart,
                        B = S.rotate,
                        V = S.rotateend;
                    t.rotateend = V, t.rotate = B, t.rotatestart = L, t.pinchend = z, t.pinch = q, t.pinchstart = R, t.zoomend = P, t.zoom = M, t.zoomstart = D, t.translateend = O, t.translate = E, t.translatestart = T, t.transformend = I, t.transform = A, t.transformstart = C
                },
            19141:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/add_namespace.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! ../../core/errors */ 17381)) && i.__esModule ? i : {
                        default: i
                    };
                    t.default = function e(t, n) {
                        if (!n) {
                            throw a.default.Error("E0017")
                        }
                        return Array.isArray(t) ? t.map((function(t) {
                            return e(t, n)
                        })).join(" ") : -1 !== t.indexOf(" ") ? e(t.split(/\s+/g), n) : "".concat(t, ".").concat(n)
                    }, e.exports = t.default, e.exports.default = t.default
                },
            27575:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/event_nodes_disposing.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.unsubscribeNodesDisposing = t.subscribeNodesDisposing = void 0;
                    var i, a = (i = n( /*! ../core/events_engine */ 55994)) && i.__esModule ? i : {
                        default: i
                    };
                    var o = "dxremove";

                    function r(e) {
                        return e && [e.target, e.delegateTarget, e.relatedTarget, e.currentTarget].filter((function(e) {
                            return !!e
                        }))
                    }
                    t.subscribeNodesDisposing = function(e, t) {
                        a.default.one(r(e), o, t)
                    };
                    t.unsubscribeNodesDisposing = function(e, t) {
                        a.default.off(r(e), o, t)
                    }
                },
            39611:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/utils/index.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    t.stopEventsSkipping = t.setEventFixMethod = t.normalizeKeyName = t.needSkipEvent = t.isTouchEvent = t.isPointerEvent = t.isMouseEvent = t.isKeyboardEvent = t.isFakeClickEvent = t.isDxMouseWheelEvent = t.isCommandKeyPressed = t.hasTouches = t.getChar = t.forceSkipEvents = t.fireEvent = t.eventSource = t.eventDelta = t.eventData = t.createEvent = t.addNamespace = void 0;
                    var i = l(n( /*! ../../core/renderer */ 68374)),
                        a = l(n( /*! ./add_namespace */ 19141)),
                        o = l(n( /*! ../core/events_engine */ 55994)),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../../core/utils/extend */ 13306),
                        c = n( /*! ../../ui/widget/selectors */ 31421);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = {
                            backspace: "backspace",
                            tab: "tab",
                            enter: "enter",
                            escape: "escape",
                            pageup: "pageUp",
                            pagedown: "pageDown",
                            end: "end",
                            home: "home",
                            arrowleft: "leftArrow",
                            arrowup: "upArrow",
                            arrowright: "rightArrow",
                            arrowdown: "downArrow",
                            delete: "del",
                            " ": "space",
                            f: "F",
                            a: "A",
                            "*": "asterisk",
                            "-": "minus",
                            alt: "alt",
                            control: "control",
                            shift: "shift"
                        },
                        d = {
                            8: "backspace",
                            9: "tab",
                            13: "enter",
                            27: "escape",
                            33: "pageUp",
                            34: "pageDown",
                            35: "end",
                            36: "home",
                            37: "leftArrow",
                            38: "upArrow",
                            39: "rightArrow",
                            40: "downArrow",
                            46: "del",
                            32: "space",
                            70: "F",
                            65: "A",
                            106: "asterisk",
                            109: "minus",
                            189: "minus",
                            173: "minus",
                            16: "shift",
                            17: "control",
                            18: "alt"
                        },
                        f = {
                            dx: /^dx/i,
                            mouse: /(mouse|wheel)/i,
                            touch: /^touch/i,
                            keyboard: /^key/i,
                            pointer: /^(ms)?pointer/i
                        },
                        h = function(e) {
                            return e
                        },
                        g = function(e) {
                            return "dx" === m(e)
                        },
                        p = function(e) {
                            return "touch" === m(e)
                        },
                        m = function(e) {
                            var t = e.type,
                                n = "other";
                            return (0, r.each)(f, (function(e) {
                                if (this.test(t)) {
                                    return n = e, !1
                                }
                            })), n
                        };
                    t.eventSource = m;
                    var _ = function(e) {
                        return "pointer" === m(e)
                    };
                    t.isPointerEvent = _;
                    var v = function(e) {
                        return function(e) {
                            return "mouse" === m(e)
                        }(e) || (_(e) || g(e)) && "mouse" === e.pointerType
                    };
                    t.isMouseEvent = v;
                    var x = function(e) {
                        return e && "dxmousewheel" === e.type
                    };
                    t.isDxMouseWheelEvent = x;
                    var y = function(e) {
                        return p(e) || (_(e) || g(e)) && "touch" === e.pointerType
                    };
                    t.isTouchEvent = y;
                    t.isKeyboardEvent = function(e) {
                        return "keyboard" === m(e)
                    };
                    t.isFakeClickEvent = function(e) {
                        var t = e.screenX,
                            n = e.offsetX,
                            i = e.pageX;
                        return 0 === t && !n && 0 === i
                    };
                    t.eventData = function(e) {
                        return {
                            x: e.pageX,
                            y: e.pageY,
                            time: e.timeStamp
                        }
                    };
                    t.eventDelta = function(e, t) {
                        return {
                            x: t.x - e.x,
                            y: t.y - e.y,
                            time: t.time - e.time || 1
                        }
                    };
                    t.hasTouches = function(e) {
                        var t = e.originalEvent,
                            n = e.pointers;
                        return p(e) ? (t.touches || []).length : g(e) ? (n || []).length : 0
                    };
                    var b = !1;
                    t.forceSkipEvents = function() {
                        return b = !0
                    };
                    t.stopEventsSkipping = function() {
                        return b = !1
                    };
                    t.needSkipEvent = function(e) {
                        if (b) {
                            return !0
                        }
                        var t = e.target,
                            n = (0, i.default)(t),
                            a = n.is(".dx-dropdownlist-popup-wrapper *, .dx-dropdownlist-popup-wrapper"),
                            o = (null == t ? void 0 : t.isContentEditable) || (null == t ? void 0 : t.hasAttribute("contenteditable")),
                            r = n.is("input, textarea, select") || o;
                        return !(!n.is(".dx-skip-gesture-event *, .dx-skip-gesture-event") || a) || (x(e) ? !(n.is("textarea") && n.hasClass("dx-texteditor-input") || o) && n.is("input[type='number'], textarea, select") && n.is(":focus") : v(e) ? r || e.which > 1 : y(e) ? r && (0, c.focused)(n) : void 0)
                    };
                    t.setEventFixMethod = function(e) {
                        return h = e
                    };
                    var w = function(e, t) {
                        var n = function(e) {
                            return h(o.default.Event(e, e), e)
                        }(e);
                        return t && (0, s.extend)(n, t), n
                    };
                    t.createEvent = w;
                    t.fireEvent = function(e) {
                        var t = e.originalEvent,
                            n = e.delegateTarget,
                            i = w(t, e);
                        return o.default.trigger(n || i.target, i), i
                    };
                    t.normalizeKeyName = function(e) {
                        var t = e.key,
                            n = e.which,
                            i = !!t;
                        if (t = i ? t : n) {
                            return i ? u[t.toLowerCase()] || t : d[t] || String.fromCharCode(t)
                        }
                    };
                    t.getChar = function(e) {
                        var t = e.key,
                            n = e.which;
                        return t || String.fromCharCode(n)
                    };
                    var k = a.default;
                    t.addNamespace = k;
                    t.isCommandKeyPressed = function(e) {
                        var t = e.ctrlKey,
                            n = e.metaKey;
                        return t || n
                    }
                },
            80506:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/events/visibility_change.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    t.triggerShownEvent = t.triggerResizeEvent = t.triggerHidingEvent = void 0;
                    var i = o(n( /*! ../core/renderer */ 68374)),
                        a = o(n( /*! ./core/events_engine */ 55994));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = function(e) {
                            var t = ".dx-visibility-change-handler";
                            return function(n) {
                                for (var o = (0, i.default)(n || "body"), r = o.filter(t).add(o.find(t)), s = 0; s < r.length; s++) {
                                    a.default.triggerHandler(r[s], e)
                                }
                            }
                        },
                        s = r("dxshown");
                    t.triggerShownEvent = s;
                    var c = r("dxhiding");
                    t.triggerHidingEvent = c;
                    var l = r("dxresize");
                    t.triggerResizeEvent = l
                },
            2994:
                /*!***************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/excel_exporter.js ***!
                  \***************************************************************/
                function(e, t, n) {
                    Object.defineProperty(t, "exportDataGrid", {
                        enumerable: !0,
                        get: function() {
                            return i.exportDataGrid
                        }
                    }), Object.defineProperty(t, "exportPivotGrid", {
                        enumerable: !0,
                        get: function() {
                            return a.exportPivotGrid
                        }
                    });
                    var i = n( /*! ./exporter/exceljs/export_data_grid */ 8572),
                        a = n( /*! ./exporter/exceljs/export_pivot_grid */ 77328)
                },
            78292:
                /*!*********************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter.js ***!
                  \*********************************************************/
                function(e, t, n) {
                    t.excel = void 0, t.export = function(e, t, n) {
                        if (!e) {
                            return (new l.Deferred).resolve()
                        }
                        var i = t.exportingAction,
                            o = t.exportedAction,
                            r = t.fileSavingAction,
                            s = {
                                fileName: t.fileName,
                                format: t.format,
                                cancel: !1
                            };
                        if ((0, c.isFunction)(i) && i(s), !s.cancel) {
                            return n(e, t).then((function(e) {
                                (0, c.isFunction)(o) && o(), (0, c.isFunction)(r) && (s.data = e, r(s)), s.cancel || a.fileSaver.saveAs(s.fileName, t.format, e, t.proxyUrl, t.forceProxy)
                            }))
                        }
                        return (new l.Deferred).resolve()
                    }, Object.defineProperty(t, "fileSaver", {
                        enumerable: !0,
                        get: function() {
                            return a.fileSaver
                        }
                    }), t.svg = t.pdf = t.image = void 0;
                    var i, a = n( /*! ./exporter/file_saver */ 48351),
                        o = n( /*! ./exporter/excel_creator */ 13571),
                        r = n( /*! ./exporter/image_creator */ 12173),
                        s = n( /*! ./exporter/svg_creator */ 37596),
                        c = n( /*! ./core/utils/type */ 35922),
                        l = n( /*! ./core/utils/deferred */ 62754),
                        u = (i = n( /*! ./exporter/excel_format_converter */ 45401)) && i.__esModule ? i : {
                            default: i
                        },
                        d = n( /*! ./exporter/pdf_creator */ 30855);
                    var f = {
                        creator: o.ExcelCreator,
                        getData: o.getData,
                        formatConverter: u.default
                    };
                    t.excel = f;
                    var h = {
                        creator: r.imageCreator,
                        getData: r.getData,
                        testFormats: r.testFormats
                    };
                    t.image = h;
                    var g = {
                        getData: d.getData
                    };
                    t.pdf = g;
                    var p = {
                        creator: s.svgCreator,
                        getData: s.getData
                    };
                    t.svg = p
                },
            5332:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/common/export_load_panel.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.ExportLoadPanel = void 0;
                    var i = l(n( /*! ../../core/renderer */ 68374)),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = l(n( /*! ../../localization/message */ 28109)),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = l(n( /*! ../../ui/load_panel */ 97218)),
                        c = l(n( /*! ../../ui/grid_core/ui.grid_core.utils */ 13615));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = function() {
                        function e(e, t, n, a) {
                            this._$targetElement = t, this._$container = n, this._loadPanel = e._createComponent((0, i.default)("<div>").addClass("dx-export-loadpanel").appendTo(this._$container), s.default, this.getOptions(a))
                        }
                        var t = e.prototype;
                        return t.getDefaultOptions = function() {
                            return {
                                animation: null,
                                shading: !1,
                                height: 90,
                                width: 200,
                                container: this._$container
                            }
                        }, t.getOptions = function(e) {
                            return (0, r.isDefined)(e.text) ? e.message = e.text : e.message = o.default.format("dxDataGrid-exporting"), (0, a.extend)(this.getDefaultOptions(), e)
                        }, t.show = function() {
                            this._loadPanel.option("position", c.default.calculateLoadPanelPosition(this._$targetElement)), this._loadPanel.show()
                        }, t.dispose = function() {
                            (0, i.default)(this._loadPanel.element()).remove(), delete this._loadPanel
                        }, e
                    }();
                    t.ExportLoadPanel = u
                },
            56985:
                /*!*******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.cell_alignment_helper.js ***!
                  \*******************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../../core/utils/type */ 35922),
                        o = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, a.isDefined)(e) && (t = {
                                    vertical: e.vertical,
                                    wrapText: e.wrapText,
                                    horizontal: e.horizontal
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, a.isDefined)(e) && (t = {}, void 0 !== e.horizontal && (t.horizontal = e.horizontal), void 0 !== e.vertical && (t.vertical = e.vertical), void 0 !== e.wrapText && (t.wrapText = e.wrapText)), t
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, a.isDefined)(e) && (0, a.isDefined)(t) && e.vertical === t.vertical && e.wrapText === t.wrapText && e.horizontal === t.horizontal
                            },
                            isEmpty: function(e) {
                                return !(0, a.isDefined)(e) || !(0, a.isDefined)(e.vertical) && !(0, a.isDefined)(e.wrapText) && !(0, a.isDefined)(e.horizontal)
                            },
                            toXml: function(e) {
                                return o.default.toXml("alignment", {
                                    vertical: e.vertical,
                                    wrapText: (0, a.isDefined)(e.wrapText) ? Number(e.wrapText) : void 0,
                                    horizontal: e.horizontal
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            2159:
                /*!****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.cell_format_helper.js ***!
                  \****************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = c(n( /*! ./excel.tag_helper */ 95320)),
                        o = c(n( /*! ./excel.cell_alignment_helper */ 56985)),
                        r = c(n( /*! ./excel.fill_helper */ 8808)),
                        s = c(n( /*! ./excel.font_helper */ 50394));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var l = {
                            tryCreateTag: function(e, t) {
                                var n = null;
                                if ((0, i.isDefined)(e)) {
                                    var a;
                                    a = "number" == typeof e.numberFormat ? e.numberFormat : t.registerNumberFormat(e.numberFormat);
                                    var s = e.fill;
                                    (0, i.isDefined)(s) || (s = r.default.tryCreateFillFromSimpleFormat(e)), n = {
                                        numberFormatId: a,
                                        alignment: o.default.tryCreateTag(e.alignment),
                                        fontId: t.registerFont(e.font),
                                        fillId: t.registerFill(s)
                                    }, l.isEmpty(n) && (n = null)
                                }
                                return n
                            },
                            copy: function(e) {
                                var t;
                                return null === e ? t = null : (0, i.isDefined)(e) && (t = {}, void 0 !== e.numberFormat && (t.numberFormat = e.numberFormat), void 0 !== e.fill ? t.fill = r.default.copy(e.fill) : r.default.copySimpleFormat(e, t), void 0 !== e.alignment && (t.alignment = o.default.copy(e.alignment)), void 0 !== e.font && (t.font = s.default.copy(e.font))), t
                            },
                            areEqual: function(e, t) {
                                return l.isEmpty(e) && l.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.fontId === t.fontId && e.numberFormatId === t.numberFormatId && e.fillId === t.fillId && o.default.areEqual(e.alignment, t.alignment)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.fontId) && !(0, i.isDefined)(e.numberFormatId) && !(0, i.isDefined)(e.fillId) && o.default.isEmpty(e.alignment)
                            },
                            toXml: function(e) {
                                var t, n = o.default.isEmpty(e.alignment);
                                return (0, i.isDefined)(e.numberFormatId) && (t = e.numberFormatId > 0 ? 1 : 0), a.default.toXml("xf", {
                                    xfId: 0,
                                    applyAlignment: n ? null : 1,
                                    fontId: e.fontId,
                                    applyNumberFormat: t,
                                    fillId: e.fillId,
                                    numFmtId: e.numberFormatId
                                }, n ? null : o.default.toXml(e.alignment))
                            }
                        },
                        u = l;
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            21879:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.color_helper.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../../core/utils/type */ 35922),
                        o = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            _tryConvertColor: function(e) {
                                if ("string" != typeof e) {
                                    return e
                                }
                                var t;
                                if (e.length > 0 && "#" === e[0]) {
                                    var n = e.substr(1, e.length);
                                    t = 6 === n.length ? "FF" + n : 8 === n.length ? n[6] + n[7] + n.substr(0, 6) : n
                                } else {
                                    t = e
                                }
                                return t
                            },
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, a.isDefined)(e) && (t = "string" == typeof e ? {
                                    rgb: this._tryConvertColor(e)
                                } : {
                                    rgb: this._tryConvertColor(e.rgb),
                                    theme: e.theme
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, a.isDefined)(e) && ("string" == typeof e ? t = e : (t = {}, void 0 !== e.rgb && (t.rgb = e.rgb), void 0 !== e.theme && (t.theme = e.theme))), t
                            },
                            isEmpty: function(e) {
                                return !(0, a.isDefined)(e) || !(0, a.isDefined)(e.rgb) && !(0, a.isDefined)(e.theme)
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, a.isDefined)(e) && (0, a.isDefined)(t) && e.rgb === t.rgb && e.theme === t.theme
                            },
                            toXml: function(e, t) {
                                return o.default.toXml(e, {
                                    rgb: t.rgb,
                                    theme: t.theme
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            50587:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.file.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = l(n( /*! ./excel.tag_helper */ 95320)),
                        o = l(n( /*! ./excel.cell_format_helper */ 2159)),
                        r = l(n( /*! ./excel.fill_helper */ 8808)),
                        s = l(n( /*! ./excel.font_helper */ 50394)),
                        c = l(n( /*! ./excel.number_format_helper */ 10794));

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var u = function() {
                        function e() {
                            this._cellFormatTags = [], this._fillTags = [], this._fontTags = [], this._numberFormatTags = [], this._fillTags.push(r.default.tryCreateTag({
                                patternFill: {
                                    patternType: "none"
                                }
                            }))
                        }
                        var t = e.prototype;
                        return t.registerCellFormat = function(e) {
                            var t, n = o.default.tryCreateTag(e, {
                                registerFill: this.registerFill.bind(this),
                                registerFont: this.registerFont.bind(this),
                                registerNumberFormat: this.registerNumberFormat.bind(this)
                            });
                            if ((0, i.isDefined)(n)) {
                                for (var a = 0; a < this._cellFormatTags.length; a++) {
                                    if (o.default.areEqual(this._cellFormatTags[a], n)) {
                                        t = a;
                                        break
                                    }
                                }
                                void 0 === t && (t = this._cellFormatTags.push(n) - 1)
                            }
                            return t
                        }, e.copyCellFormat = function(e) {
                            return o.default.copy(e)
                        }, t.generateCellFormatsXml = function() {
                            var e = this._cellFormatTags.map((function(e) {
                                return o.default.toXml(e)
                            }));
                            return a.default.toXml("cellXfs", {
                                count: e.length
                            }, e.join(""))
                        }, t.registerFill = function(e) {
                            var t, n = r.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var a = 0; a < this._fillTags.length; a++) {
                                    if (r.default.areEqual(this._fillTags[a], n)) {
                                        t = a;
                                        break
                                    }
                                }
                                void 0 === t && (this._fillTags.length < 2 && this._fillTags.push(r.default.tryCreateTag({
                                    patternFill: {
                                        patternType: "Gray125"
                                    }
                                })), t = this._fillTags.push(n) - 1)
                            }
                            return t
                        }, t.generateFillsXml = function() {
                            var e = this._fillTags.map((function(e) {
                                return r.default.toXml(e)
                            }));
                            return a.default.toXml("fills", {
                                count: e.length
                            }, e.join(""))
                        }, t.registerFont = function(e) {
                            var t, n = s.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var a = 0; a < this._fontTags.length; a++) {
                                    if (s.default.areEqual(this._fontTags[a], n)) {
                                        t = a;
                                        break
                                    }
                                }
                                void 0 === t && (t = this._fontTags.push(n) - 1)
                            }
                            return t
                        }, t.generateFontsXml = function() {
                            var e = this._fontTags.map((function(e) {
                                return s.default.toXml(e)
                            }));
                            return a.default.toXml("fonts", {
                                count: e.length
                            }, e.join(""))
                        }, t._convertNumberFormatIndexToId = function(e) {
                            return 165 + e
                        }, t.registerNumberFormat = function(e) {
                            var t, n = c.default.tryCreateTag(e);
                            if ((0, i.isDefined)(n)) {
                                for (var a = 0; a < this._numberFormatTags.length; a++) {
                                    if (c.default.areEqual(this._numberFormatTags[a], n)) {
                                        t = this._numberFormatTags[a][c.default.ID_PROPERTY_NAME];
                                        break
                                    }
                                }
                                void 0 === t && (n[c.default.ID_PROPERTY_NAME] = this._convertNumberFormatIndexToId(this._numberFormatTags.length), t = n[c.default.ID_PROPERTY_NAME], this._numberFormatTags.push(n))
                            }
                            return t
                        }, t.generateNumberFormatsXml = function() {
                            if (this._numberFormatTags.length > 0) {
                                var e = this._numberFormatTags.map((function(e) {
                                    return c.default.toXml(e)
                                }));
                                return a.default.toXml("numFmts", {
                                    count: e.length
                                }, e.join(""))
                            }
                            return ""
                        }, e
                    }();
                    t.default = u, e.exports = t.default, e.exports.default = t.default
                },
            8808:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.fill_helper.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = r(n( /*! ./excel.tag_helper */ 95320)),
                        o = r(n( /*! ./excel.pattern_fill_helper */ 40027));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    patternFill: o.default.tryCreateTag(e.patternFill)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            tryCreateFillFromSimpleFormat: function() {
                                var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                                    t = e.backgroundColor,
                                    n = e.fillPatternType,
                                    a = e.fillPatternColor;
                                return !(0, i.isDefined)(t) || (0, i.isDefined)(n) && (0, i.isDefined)(a) ? (0, i.isDefined)(n) && (0, i.isDefined)(a) ? {
                                    patternFill: {
                                        patternType: n,
                                        foregroundColor: {
                                            rgb: a
                                        },
                                        backgroundColor: {
                                            rgb: t
                                        }
                                    }
                                } : void 0 : {
                                    patternFill: {
                                        patternType: "solid",
                                        foregroundColor: {
                                            rgb: t
                                        }
                                    }
                                }
                            },
                            copySimpleFormat: function(e, t) {
                                void 0 !== e.backgroundColor && (t.backgroundColor = e.backgroundColor), void 0 !== e.fillPatternType && (t.fillPatternType = e.fillPatternType), void 0 !== e.fillPatternColor && (t.fillPatternColor = e.fillPatternColor)
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.patternFill && (t.patternFill = o.default.copy(e.patternFill))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && o.default.areEqual(e.patternFill, t.patternFill)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || o.default.isEmpty(e.patternFill)
                            },
                            toXml: function(e) {
                                return a.default.toXml("fill", {}, o.default.toXml(e.patternFill))
                            }
                        },
                        c = s;
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            50394:
                /*!*********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.font_helper.js ***!
                  \*********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = r(n( /*! ./excel.tag_helper */ 95320)),
                        o = r(n( /*! ./excel.color_helper */ 21879));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    size: e.size,
                                    name: e.name,
                                    family: e.family,
                                    scheme: e.scheme,
                                    bold: e.bold,
                                    italic: e.italic,
                                    underline: e.underline,
                                    color: o.default.tryCreateTag(e.color)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.size && (t.size = e.size), void 0 !== e.name && (t.name = e.name), void 0 !== e.family && (t.family = e.family), void 0 !== e.scheme && (t.scheme = e.scheme), void 0 !== e.bold && (t.bold = e.bold), void 0 !== e.italic && (t.italic = e.italic), void 0 !== e.underline && (t.underline = e.underline), void 0 !== e.color && (t.color = o.default.copy(e.color))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.size === t.size && e.name === t.name && e.family === t.family && e.scheme === t.scheme && (e.bold === t.bold || !e.bold == !t.bold) && (e.italic === t.italic || !e.italic == !t.italic) && e.underline === t.underline && o.default.areEqual(e.color, t.color)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.size) && !(0, i.isDefined)(e.name) && !(0, i.isDefined)(e.family) && !(0, i.isDefined)(e.scheme) && (!(0, i.isDefined)(e.bold) || !e.bold) && (!(0, i.isDefined)(e.italic) || !e.italic) && !(0, i.isDefined)(e.underline) && o.default.isEmpty(e.color)
                            },
                            toXml: function(e) {
                                var t = [(0, i.isDefined)(e.bold) && e.bold ? a.default.toXml("b", {}) : "", (0, i.isDefined)(e.size) ? a.default.toXml("sz", {
                                    val: e.size
                                }) : "", (0, i.isDefined)(e.color) ? o.default.toXml("color", e.color) : "", (0, i.isDefined)(e.name) ? a.default.toXml("name", {
                                    val: e.name
                                }) : "", (0, i.isDefined)(e.family) ? a.default.toXml("family", {
                                    val: e.family
                                }) : "", (0, i.isDefined)(e.scheme) ? a.default.toXml("scheme", {
                                    val: e.scheme
                                }) : "", (0, i.isDefined)(e.italic) && e.italic ? a.default.toXml("i", {}) : "", (0, i.isDefined)(e.underline) ? a.default.toXml("u", {
                                    val: e.underline
                                }) : ""].join("");
                                return a.default.toXml("font", {}, t)
                            }
                        },
                        c = s;
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            10794:
                /*!******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.number_format_helper.js ***!
                  \******************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = n( /*! ../../core/utils/type */ 35922),
                        o = (i = n( /*! ./excel.tag_helper */ 95320)) && i.__esModule ? i : {
                            default: i
                        };
                    var r = {
                            ID_PROPERTY_NAME: "id",
                            tryCreateTag: function(e) {
                                var t = null;
                                return "string" == typeof e && (t = {
                                    formatCode: e
                                }, r.isEmpty(t) && (t = null)), t
                            },
                            areEqual: function(e, t) {
                                return r.isEmpty(e) && r.isEmpty(t) || (0, a.isDefined)(e) && (0, a.isDefined)(t) && e.formatCode === t.formatCode
                            },
                            isEmpty: function(e) {
                                return !(0, a.isDefined)(e) || !(0, a.isDefined)(e.formatCode) || "" === e.formatCode
                            },
                            toXml: function(e) {
                                return o.default.toXml("numFmt", {
                                    numFmtId: e[r.ID_PROPERTY_NAME],
                                    formatCode: e.formatCode
                                })
                            }
                        },
                        s = r;
                    t.default = s, e.exports = t.default, e.exports.default = t.default
                },
            40027:
                /*!*****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.pattern_fill_helper.js ***!
                  \*****************************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = r(n( /*! ./excel.tag_helper */ 95320)),
                        o = r(n( /*! ./excel.color_helper */ 21879));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var s = {
                            tryCreateTag: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {
                                    patternType: e.patternType,
                                    backgroundColor: o.default.tryCreateTag(e.backgroundColor),
                                    foregroundColor: o.default.tryCreateTag(e.foregroundColor)
                                }, s.isEmpty(t) && (t = null)), t
                            },
                            copy: function(e) {
                                var t = null;
                                return (0, i.isDefined)(e) && (t = {}, void 0 !== e.patternType && (t.patternType = e.patternType), void 0 !== e.backgroundColor && (t.backgroundColor = o.default.copy(e.backgroundColor)), void 0 !== e.foregroundColor && (t.foregroundColor = o.default.copy(e.foregroundColor))), t
                            },
                            areEqual: function(e, t) {
                                return s.isEmpty(e) && s.isEmpty(t) || (0, i.isDefined)(e) && (0, i.isDefined)(t) && e.patternType === t.patternType && o.default.areEqual(e.backgroundColor, t.backgroundColor) && o.default.areEqual(e.foregroundColor, t.foregroundColor)
                            },
                            isEmpty: function(e) {
                                return !(0, i.isDefined)(e) || !(0, i.isDefined)(e.patternType)
                            },
                            toXml: function(e) {
                                var t = [(0, i.isDefined)(e.foregroundColor) ? o.default.toXml("fgColor", e.foregroundColor) : "", (0, i.isDefined)(e.backgroundColor) ? o.default.toXml("bgColor", e.backgroundColor) : ""].join("");
                                return a.default.toXml("patternFill", {
                                    patternType: e.patternType
                                }, t)
                            }
                        },
                        c = s;
                    t.default = c, e.exports = t.default, e.exports.default = t.default
                },
            95320:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel/excel.tag_helper.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = {
                            toXml: function(e, t, n) {
                                var a = ["<", e];
                                for (var o in t) {
                                    var r = t[o];
                                    (0, i.isDefined)(r) && a.push(" ", o, '="', r, '"')
                                }
                                return (0, i.isDefined)(n) && "" !== n ? a.push(">", n, "</", e, ">") : a.push(" />"), a.join("")
                            }
                        };
                    t.default = a, e.exports = t.default, e.exports.default = t.default
                },
            13571:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel_creator.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.ExcelCreator = void 0, t.getData = function(e, t) {
                        var n = new A(e, t);
                        return n._checkZipState(), n.ready().then((function() {
                            return n.getData((0, o.isFunction)((0, a.getWindow)().Blob))
                        }))
                    };
                    var i = g(n( /*! ../core/class */ 38377)),
                        a = n( /*! ../core/utils/window */ 58201),
                        o = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/extend */ 13306),
                        s = g(n( /*! ../ui/widget/ui.errors */ 96688)),
                        c = n( /*! ../core/utils/string */ 68752),
                        l = g(n( /*! jszip */ 97405)),
                        u = n( /*! ./file_saver */ 48351),
                        d = g(n( /*! ./excel_format_converter */ 45401)),
                        f = g(n( /*! ./excel/excel.file */ 50587)),
                        h = n( /*! ../core/utils/deferred */ 62754);

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function p(e) {
                        return p = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, p(e)
                    }
                    var m = '<?xml version="1.0" encoding="utf-8"?>',
                        _ = "http://schemas.openxmlformats.org",
                        v = "xl",
                        y = "sharedStrings.xml",
                        b = "styles.xml",
                        k = {
                            boolean: "b",
                            date: "d",
                            number: "n",
                            string: "s"
                        },
                        S = Date.UTC(1899, 11, 30),
                        C = {
                            quarter: "shortDate",
                            quarterAndYear: "shortDate",
                            minute: "longTime",
                            millisecond: "longTime"
                        },
                        A = i.default.inherit({
                            _getXMLTag: function(e, t, n) {
                                var i, a, r = "<" + e,
                                    s = t.length;
                                for (i = 0; i < s; i++) {
                                    void 0 !== (a = t[i]).value && (r = r + " " + a.name + '="' + a.value + '"')
                                }
                                return (0, o.isDefined)(n) ? r + ">" + n + "</" + e + ">" : r + " />"
                            },
                            _convertToExcelCellRef: function(e, t) {
                                for (var n, i, a = ""; !i;) {
                                    n = 65 + (t >= 26 ? t % 26 : Math.ceil(t)), a = String.fromCharCode(n) + a, t >= 26 ? t = Math.floor(t / 26) - 1 : i = !0
                                }
                                return a + (e + 1)
                            },
                            _convertToExcelCellRefAndTrackMaxIndex: function(e, t) {
                                return this._maxRowIndex < Number(e) && (this._maxRowIndex = Number(e)), this._maxColumnIndex < Number(t) && (this._maxColumnIndex = Number(t)), this._convertToExcelCellRef(e, t)
                            },
                            _getDataType: function(e) {
                                return k[e] || k.string
                            },
                            _tryGetExcelCellDataType: function(e) {
                                if ((0, o.isDefined)(e)) {
                                    if ("number" == typeof e) {
                                        return isFinite(e) ? k.number : k.string
                                    }
                                    if ((0, o.isString)(e)) {
                                        return k.string
                                    }
                                    if ((0, o.isDate)(e)) {
                                        return k.number
                                    }
                                    if ((0, o.isBoolean)(e)) {
                                        return k.boolean
                                    }
                                }
                            },
                            _formatObjectConverter: function(e, t) {
                                var n = {
                                    format: e,
                                    precision: e && e.precision,
                                    dataType: t
                                };
                                return (0, o.isObject)(e) ? (0, r.extend)(n, e, {
                                    format: e.formatter || e.type,
                                    currency: e.currency
                                }) : n
                            },
                            _tryConvertToExcelNumberFormat: function(e, t) {
                                var n = this._formatObjectConverter(e, t);
                                e = n.format;
                                var i = n.currency;
                                return t = n.dataType, (0, o.isDefined)(e) && "date" === t && (e = C[e && e.type || e] || e), d.default.convertFormat(e, n.precision, t, i)
                            },
                            _appendString: function(e) {
                                if ((0, o.isDefined)(e) && (e = String(e)).length) {
                                    return e = (0, c.encodeHtml)(e), void 0 === this._stringHash[e] && (this._stringHash[e] = this._stringArray.length, this._stringArray.push(e)), this._stringHash[e]
                                }
                            },
                            _tryGetExcelDateValue: function(e) {
                                var t;
                                if ((0, o.isDate)(e)) {
                                    return (t = Math.floor((Date.UTC(e.getFullYear(), e.getMonth(), e.getDate()) - S) / 864e5)) < 60 && t--, t + (3600 * e.getHours() + 60 * e.getMinutes() + e.getSeconds()) / 86400
                                }
                            },
                            _prepareValue: function(e, t) {
                                var n, i = this._dataProvider,
                                    a = (i.getCellData(e, t) || {}).cellSourceData,
                                    r = (i.getCellData(e, t) || {}).value,
                                    s = this._getDataType(i.getCellType(e, t));
                                switch (s !== k.date || (0, o.isDate)(r) || (s = k.string), s) {
                                    case k.string:
                                        n = r, r = this._appendString(r);
                                        break;
                                    case k.date:
                                        n = r, r = this._tryGetExcelDateValue(r), s = k.number
                                }
                                return {
                                    value: r,
                                    type: s,
                                    sourceValue: n,
                                    cellSourceData: a
                                }
                            },
                            _callCustomizeExcelCell: function(e) {
                                var t = e.dataProvider,
                                    n = e.value,
                                    i = e.style,
                                    a = e.sourceData,
                                    r = f.default.copyCellFormat(i),
                                    s = {
                                        value: n,
                                        numberFormat: r.numberFormat,
                                        clearStyle: function() {
                                            this.horizontalAlignment = null, this.verticalAlignment = null, this.wrapTextEnabled = null, this.font = null, this.numberFormat = null
                                        }
                                    };
                                (0, o.isDefined)(r) && ((0, o.isDefined)(r.alignment) && (s.horizontalAlignment = r.alignment.horizontal, s.verticalAlignment = r.alignment.vertical, s.wrapTextEnabled = r.alignment.wrapText), s.backgroundColor = r.backgroundColor, s.fillPatternType = r.fillPatternType, s.fillPatternColor = r.fillPatternColor, s.font = r.font), t.customizeExcelCell(s, a);
                                var c = r || {};
                                return c.font = s.font, c.alignment = c.alignment || {}, c.alignment.horizontal = s.horizontalAlignment, c.alignment.vertical = s.verticalAlignment, c.alignment.wrapText = s.wrapTextEnabled, c.backgroundColor = s.backgroundColor, c.fillPatternType = s.fillPatternType, c.fillPatternColor = s.fillPatternColor, c.numberFormat = s.numberFormat, {
                                    value: s.value,
                                    style: c
                                }
                            },
                            _getDataArray: function() {
                                var e, t, n, i, a, r = this,
                                    s = [],
                                    c = r._dataProvider,
                                    l = c.getRowsCount(),
                                    u = c.getColumns();
                                for (e = 0; e < l; e++) {
                                    for (n = [], a = u.length, t = 0; t !== a; t++) {
                                        i = r._prepareValue(e, t);
                                        var d = c.getStyleId(e, t),
                                            f = this._styleArrayIndexToCellStyleIdMap[d];
                                        if (c.hasCustomizeExcelCell && c.hasCustomizeExcelCell()) {
                                            var h = i.sourceValue || i.value,
                                                g = this._callCustomizeExcelCell({
                                                    dataProvider: c,
                                                    value: h,
                                                    style: r._styleArray[d],
                                                    sourceData: i.cellSourceData
                                                });
                                            if (g.value !== h) {
                                                if (p(g.value) !== p(h) || "number" == typeof g.value && !isFinite(g.value)) {
                                                    var m = this._tryGetExcelCellDataType(g.value);
                                                    (0, o.isDefined)(m) && (i.type = m)
                                                }
                                                switch (i.type) {
                                                    case k.string:
                                                        i.value = this._appendString(g.value);
                                                        break;
                                                    default:
                                                        i.value = g.value;
                                                        break;
                                                    case k.number:
                                                        var _ = g.value,
                                                            v = this._tryGetExcelDateValue(_);
                                                        (0, o.isDefined)(v) && (_ = v), i.value = _
                                                }
                                            }
                                            f = this._excelFile.registerCellFormat(g.style)
                                        }
                                        n.push({
                                            style: f,
                                            value: i.value,
                                            type: i.type
                                        })
                                    }!r._needSheetPr && c.getGroupLevel(e) > 0 && (r._needSheetPr = !0), s.push(n)
                                }
                                return s
                            },
                            _calculateWidth: function(e) {
                                return (!(e = parseInt(e, 10)) || e < 5) && (e = 100), Math.min(255, Math.floor((e - 5) / 7 * 100 + .5) / 100)
                            },
                            _prepareStyleData: function() {
                                var e = this,
                                    t = this,
                                    n = t._dataProvider.getStyles();
                                t._dataProvider.getColumns().forEach((function(e) {
                                    t._colsArray.push(t._calculateWidth(e.width))
                                }));
                                var i = [{
                                    size: 11,
                                    color: {
                                        theme: 1
                                    },
                                    name: "Calibri",
                                    family: 2,
                                    scheme: "minor",
                                    bold: !1
                                }, {
                                    size: 11,
                                    color: {
                                        theme: 1
                                    },
                                    name: "Calibri",
                                    family: 2,
                                    scheme: "minor",
                                    bold: !0
                                }];
                                this._excelFile.registerFont(i[0]), this._excelFile.registerFont(i[1]), n.forEach((function(e) {
                                    var n = t._tryConvertToExcelNumberFormat(e.format, e.dataType);
                                    (0, o.isDefined)(n) || (n = 0), t._styleArray.push({
                                        font: i[Number(!!e.bold)],
                                        numberFormat: n,
                                        alignment: {
                                            vertical: "top",
                                            wrapText: !!e.wrapText,
                                            horizontal: e.alignment || "left"
                                        }
                                    })
                                })), t._styleArrayIndexToCellStyleIdMap = t._styleArray.map((function(t) {
                                    return e._excelFile.registerCellFormat(t)
                                }))
                            },
                            _prepareCellData: function() {
                                this._cellsArray = this._getDataArray()
                            },
                            _createXMLRelationships: function(e) {
                                return this._getXMLTag("Relationships", [{
                                    name: "xmlns",
                                    value: _ + "/package/2006/relationships"
                                }], e)
                            },
                            _createXMLRelationship: function(e, t, n) {
                                return this._getXMLTag("Relationship", [{
                                    name: "Id",
                                    value: "rId" + e
                                }, {
                                    name: "Type",
                                    value: _ + "/officeDocument/2006/relationships/" + t
                                }, {
                                    name: "Target",
                                    value: n
                                }])
                            },
                            _getWorkbookContent: function() {
                                return m + this._getXMLTag("workbook", [{
                                    name: "xmlns:r",
                                    value: _ + "/officeDocument/2006/relationships"
                                }, {
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }], '<bookViews><workbookView xWindow="0" yWindow="0" windowWidth="0" windowHeight="0"/></bookViews><sheets><sheet name="Sheet" sheetId="1" r:id="rId1" /></sheets><definedNames><definedName name="_xlnm.Print_Titles" localSheetId="0">Sheet!$1:$1</definedName><definedName name="_xlnm._FilterDatabase" hidden="0" localSheetId="0">Sheet!$A$1:$F$6332</definedName></definedNames>')
                            },
                            _getContentTypesContent: function() {
                                return m + '<Types xmlns="' + _ + '/package/2006/content-types"><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" /><Default Extension="xml" ContentType="application/xml" /><Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" /><Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" /><Override PartName="/xl/sharedStrings.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml" /><Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" /></Types>'
                            },
                            _generateStylesXML: function() {
                                var e = this,
                                    t = e._zip.folder(v),
                                    n = "";
                                n += this._excelFile.generateNumberFormatsXml(), n += this._excelFile.generateFontsXml(), n += this._excelFile.generateFillsXml(), n += '<borders count="1"><border><left style="thin"><color rgb="FFD3D3D3"/></left><right style="thin"><color rgb="FFD3D3D3"/></right><top style="thin"><color rgb="FFD3D3D3"/></top><bottom style="thin"><color rgb="FFD3D3D3"/></bottom></border></borders><cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>', n += this._excelFile.generateCellFormatsXml(), n += e._getXMLTag("cellStyles", [{
                                    name: "count",
                                    value: 1
                                }], e._getXMLTag("cellStyle", [{
                                    name: "name",
                                    value: "Normal"
                                }, {
                                    name: "xfId",
                                    value: 0
                                }, {
                                    name: "builtinId",
                                    value: 0
                                }])), n = m + e._getXMLTag("styleSheet", [{
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }], n), t.file(b, n), e._styleArray = []
                            },
                            _generateStringsXML: function() {
                                var e, t = this._zip.folder(v),
                                    n = this._stringArray.length,
                                    i = m;
                                for (e = 0; e < n; e++) {
                                    this._stringArray[e] = this._getXMLTag("si", [], this._getXMLTag("t", [], this._stringArray[e]))
                                }
                                i += this._getXMLTag("sst", [{
                                    name: "xmlns",
                                    value: _ + "/spreadsheetml/2006/main"
                                }, {
                                    name: "count",
                                    value: this._stringArray.length
                                }, {
                                    name: "uniqueCount",
                                    value: this._stringArray.length
                                }], this._stringArray.join("")), t.file(y, i), this._stringArray = []
                            },
                            _getPaneXML: function() {
                                var e = [{
                                        name: "activePane",
                                        value: "bottomLeft"
                                    }, {
                                        name: "state",
                                        value: "frozen"
                                    }],
                                    t = this._dataProvider.getFrozenArea();
                                return t.x || t.y ? (t.x && e.push({
                                    name: "xSplit",
                                    value: t.x
                                }), t.y && e.push({
                                    name: "ySplit",
                                    value: t.y
                                }), e.push({
                                    name: "topLeftCell",
                                    value: this._convertToExcelCellRefAndTrackMaxIndex(t.y, t.x)
                                }), this._getXMLTag("pane", e)) : ""
                            },
                            _getAutoFilterXML: function(e) {
                                return this._options.autoFilterEnabled ? '<autoFilter ref="A' + this._dataProvider.getHeaderRowCount() + ":" + e + '" />' : ""
                            },
                            _getIgnoredErrorsXML: function(e) {
                                return this._options.ignoreErrors ? '<ignoredErrors><ignoredError sqref="A1:' + e + '" numberStoredAsText="1" /></ignoredErrors>' : ""
                            },
                            _generateWorksheetXML: function() {
                                var e, t, n, i, a, r = [],
                                    s = this._cellsArray.length,
                                    c = this._colsArray.length,
                                    l = "1:" + c,
                                    u = this._dataProvider.getHeaderRowCount ? this._dataProvider.getHeaderRowCount() : 1,
                                    d = ['<?xml version="1.0" encoding="UTF-8" standalone="yes"?><worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">'];
                                for (d.push(this._needSheetPr ? '<sheetPr><outlinePr summaryBelow="0"/></sheetPr>' : "<sheetPr/>"), d.push('<dimension ref="A1:C1"/>'), d.push("<sheetViews><sheetView "), d.push(this._rtlEnabled ? 'rightToLeft="1" ' : ""), d.push('tabSelected="1" workbookViewId="0">'), d.push(this._getPaneXML()), d.push("</sheetView></sheetViews>"), d.push('<sheetFormatPr defaultRowHeight="15"'), d.push(' outlineLevelRow="' + (this._dataProvider.getRowsCount() > 0 ? this._dataProvider.getGroupLevel(0) : 0) + '"'), d.push(' x14ac:dyDescent="0.25"/>'), e = 0; e < c; e++) {
                                    this._colsArray[e] = this._getXMLTag("col", [{
                                        name: "width",
                                        value: this._colsArray[e]
                                    }, {
                                        name: "min",
                                        value: Number(e) + 1
                                    }, {
                                        name: "max",
                                        value: Number(e) + 1
                                    }, {
                                        name: "customWidth",
                                        value: 1
                                    }])
                                }
                                for (d.push(this._getXMLTag("cols", [], this._colsArray.join("")) + "<sheetData>"), t = 0; t < s; t++) {
                                    for (i = [], a = this._cellsArray[t].length, e = 0; e < a; e++) {
                                        t = Number(t), n = this._cellsArray[t][e], i.push(this._getXMLTag("c", [{
                                            name: "r",
                                            value: this._convertToExcelCellRefAndTrackMaxIndex(t, e)
                                        }, {
                                            name: "s",
                                            value: n.style
                                        }, {
                                            name: "t",
                                            value: n.type
                                        }], (0, o.isDefined)(n.value) ? this._getXMLTag("v", [], n.value) : null))
                                    }
                                    r.push(this._getXMLTag("row", [{
                                        name: "r",
                                        value: Number(t) + 1
                                    }, {
                                        name: "spans",
                                        value: l
                                    }, {
                                        name: "outlineLevel",
                                        value: t >= u ? this._dataProvider.getGroupLevel(t) : 0
                                    }, {
                                        name: "x14ac:dyDescent",
                                        value: "0.25"
                                    }], i.join(""))), this._cellsArray[t] = null, r.length > 1e4 && (d.push(r.join("")), r = [])
                                }
                                d.push(r.join("")), r = [];
                                var f = this._convertToExcelCellRef(this._maxRowIndex, this._maxColumnIndex);
                                d.push("</sheetData>" + this._getAutoFilterXML(f) + this._generateMergingXML() + this._getIgnoredErrorsXML(f) + "</worksheet>"), this._zip.folder(v).folder("worksheets").file("sheet1.xml", d.join("")), this._colsArray = [], this._cellsArray = [], d = []
                            },
                            _generateMergingXML: function() {
                                var e, t, n, i, a, r = (0, o.isDefined)(this._dataProvider.getHeaderRowCount) ? this._dataProvider.getHeaderRowCount() : this._dataProvider.getRowsCount(),
                                    s = this._dataProvider.getColumns().length,
                                    c = [],
                                    l = [],
                                    u = "";
                                for (i = 0; i < r; i++) {
                                    for (n = 0; n !== s; n++) {
                                        if (!(0, o.isDefined)(c[i]) || !(0, o.isDefined)(c[i][n])) {
                                            var d = this._dataProvider.getCellMerging(i, n);
                                            if (d.colspan || d.rowspan) {
                                                for (l.push({
                                                        start: this._convertToExcelCellRefAndTrackMaxIndex(i, n),
                                                        end: this._convertToExcelCellRefAndTrackMaxIndex(i + (d.rowspan || 0), n + (d.colspan || 0))
                                                    }), e = i; e <= i + d.rowspan; e++) {
                                                    for (t = n; t <= n + d.colspan; t++) {
                                                        (0, o.isDefined)(c[e]) || (c[e] = []), c[e][t] = !0
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                var f = l.length;
                                for (a = 0; a < f; a++) {
                                    u += this._getXMLTag("mergeCell", [{
                                        name: "ref",
                                        value: l[a].start + ":" + l[a].end
                                    }])
                                }
                                return u.length ? this._getXMLTag("mergeCells", [{
                                    name: "count",
                                    value: f
                                }], u) : ""
                            },
                            _generateCommonXML: function() {
                                var e = m + this._createXMLRelationships(this._createXMLRelationship(1, "officeDocument", "xl/workbook.xml")),
                                    t = this._zip.folder(v),
                                    n = m;
                                this._zip.folder("_rels").file(".rels", e);
                                var i = this._createXMLRelationship(1, "worksheet", "worksheets/sheet1.xml") + this._createXMLRelationship(2, "styles", b) + this._createXMLRelationship(3, "sharedStrings", y);
                                n += this._createXMLRelationships(i), t.folder("_rels").file("workbook.xml.rels", n), t.file("workbook.xml", this._getWorkbookContent()), this._zip.file("[Content_Types].xml", this._getContentTypesContent())
                            },
                            _generateContent: function() {
                                this._prepareStyleData(), this._prepareCellData(), this._generateWorkXML(), this._generateCommonXML()
                            },
                            _generateWorkXML: function() {
                                this._generateStylesXML(), this._generateStringsXML(), this._generateWorksheetXML()
                            },
                            ctor: function(e, t) {
                                this._rtlEnabled = t && !!t.rtlEnabled, this._options = t, this._maxRowIndex = 0, this._maxColumnIndex = 0, this._stringArray = [], this._stringHash = {}, this._styleArray = [], this._colsArray = [], this._cellsArray = [], this._needSheetPr = !1, this._dataProvider = e, this._excelFile = new f.default, (0, o.isDefined)(A.JSZip) ? this._zip = new A.JSZip : this._zip = null
                            },
                            _checkZipState: function() {
                                if (!this._zip) {
                                    throw s.default.Error("E1041", "JSZip")
                                }
                            },
                            ready: function() {
                                return this._dataProvider.ready()
                            },
                            getData: function(e) {
                                var t = {
                                        type: e ? "blob" : "base64",
                                        compression: "DEFLATE",
                                        mimeType: u.MIME_TYPES.EXCEL
                                    },
                                    n = new h.Deferred;
                                return this._checkZipState(), this._generateContent(), this._zip.generateAsync ? this._zip.generateAsync(t).then(n.resolve) : n.resolve(this._zip.generate(t)), n
                            }
                        });
                    t.ExcelCreator = A, A.JSZip = l.default
                },
            45401:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/excel_format_converter.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ../core/utils/string */ 68752),
                        a = l(n( /*! ../localization/number */ 18016)),
                        o = l(n( /*! ../localization/date */ 91500)),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../localization/ldml/date.format */ 59937),
                        c = n( /*! ../localization/language_codes */ 9821);

                    function l(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ../localization/currency */ 89740);
                    var u = {
                            thousands: "#,##0{0},&quot;K&quot;",
                            millions: "#,##0{0},,&quot;M&quot;",
                            billions: "#,##0{0},,,&quot;B&quot;",
                            trillions: "#,##0{0},,,,&quot;T&quot;",
                            percent: "0{0}%",
                            decimal: "#{0}",
                            fixedpoint: "#,##0{0}",
                            exponential: "0{0}E+00",
                            currency: " "
                        },
                        d = /a+/g,
                        f = /E/g,
                        h = /dE+/g,
                        g = /L/g,
                        p = /h/g,
                        m = /./g,
                        _ = {
                            _applyPrecision: function(e, t) {
                                var n, i;
                                if (t > 0) {
                                    for (n = "decimal" !== e ? "." : "", i = 0; i < t; i++) {
                                        n += "0"
                                    }
                                    return n
                                }
                                return ""
                            },
                            _hasArabicDigits: function(e) {
                                for (var t, n = 0; n < e.length; n++) {
                                    if ((t = e.charCodeAt(n)) >= 1632 && t < 1642) {
                                        return !0
                                    }
                                }
                                return !1
                            },
                            _convertDateFormatToOpenXml: function(e) {
                                return e.split("/").join("\\/").split("'").map((function(e, t) {
                                    return t % 2 == 0 ? e.replace(d, "AM/PM").replace(h, "d").replace(f, "d").replace(g, "M").replace(p, "H").split("[").join("\\[").split("]").join("\\]") : e ? e.replace(m, "\\$&") : "'"
                                })).join("")
                            },
                            _convertDateFormat: function(e) {
                                var t = (o.default.format(new Date(2009, 8, 8, 6, 5, 4), e) || "").toString(),
                                    n = (0, s.getFormat)((function(t) {
                                        return o.default.format(t, e)
                                    }));
                                return n && (n = this._convertDateFormatToOpenXml(n), n = this._getLanguageInfo(t) + n), n
                            },
                            _getLanguageInfo: function(e) {
                                var t = (0, c.getLanguageId)(),
                                    n = t ? t.toString(16) : "",
                                    i = "";
                                if (this._hasArabicDigits(e)) {
                                    for (; n.length < 3;) {
                                        n = "0" + n
                                    }
                                    i = "[$-2010" + n + "]"
                                } else {
                                    n && (i = "[$-" + n + "]")
                                }
                                return i
                            },
                            _convertNumberFormat: function(e, t, n) {
                                var o, r;
                                return (r = "currency" === e ? a.default.getOpenXmlCurrencyFormat(n) : u[e.toLowerCase()]) && (o = (0, i.format)(r, this._applyPrecision(e, t))), o
                            },
                            convertFormat: function(e, t, n, i) {
                                if ((0, r.isDefined)(e)) {
                                    if ("date" === n) {
                                        return _._convertDateFormat(e)
                                    }
                                    if ((0, r.isString)(e) && u[e.toLowerCase()]) {
                                        return _._convertNumberFormat(e, t, i)
                                    }
                                }
                            }
                        },
                        v = _;
                    t.default = v, e.exports = t.default, e.exports.default = t.default
                },
            11385:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    t.Export = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ./export_format */ 38526),
                        o = n( /*! ./export_merged_ranges_manager */ 31980),
                        r = n( /*! ../../core/utils/extend */ 13306),
                        s = n( /*! ../common/export_load_panel */ 5332),
                        c = n( /*! ../../core/utils/window */ 58201),
                        l = {
                            getFullOptions: function(e) {
                                var t = (0, r.extend)({}, e);
                                if (!(0, i.isDefined)(t.worksheet) || !(0, i.isObject)(t.worksheet)) {
                                    throw Error('The "worksheet" field must contain an object.')
                                }
                                if ((0, i.isDefined)(t.topLeftCell)) {
                                    if ((0, i.isString)(t.topLeftCell)) {
                                        var n = t.worksheet.getCell(t.topLeftCell),
                                            a = n.row,
                                            o = n.col;
                                        t.topLeftCell = {
                                            row: a,
                                            column: o
                                        }
                                    }
                                } else {
                                    t.topLeftCell = {
                                        row: 1,
                                        column: 1
                                    }
                                }
                                return (0, i.isDefined)(t.keepColumnWidths) || (t.keepColumnWidths = !0), (0, i.isDefined)(t.loadPanel) || (t.loadPanel = {}), (0, i.isDefined)(t.loadPanel.enabled) || (t.loadPanel.enabled = !0), t
                            },
                            convertDateForExcelJS: function(e) {
                                return new Date(Date.UTC(e.getFullYear(), e.getMonth(), e.getDate(), e.getHours(), e.getMinutes(), e.getSeconds(), e.getMilliseconds()))
                            },
                            setNumberFormat: function(e, t) {
                                e.numFmt = t
                            },
                            getCellStyles: function(e) {
                                var t = this,
                                    n = e.getStyles();
                                return n.forEach((function(e) {
                                    var n = t.tryConvertToExcelNumberFormat(e.format, e.dataType);
                                    (0, i.isDefined)(n) && (n = n.replace(/&quot;/g, '"')), e.numberFormat = n
                                })), n
                            },
                            tryConvertToExcelNumberFormat: function(e, t) {
                                var n = a.ExportFormat.formatObjectConverter(e, t),
                                    i = n.currency;
                                return e = n.format, t = n.dataType, a.ExportFormat.convertFormat(e, n.precision, t, i)
                            },
                            setAlignment: function(e, t, n) {
                                e.alignment = e.alignment || {}, (0, i.isDefined)(t) && (e.alignment.wrapText = t), (0, i.isDefined)(n) && (e.alignment.horizontal = n), e.alignment.vertical = "top"
                            },
                            setColumnsWidth: function(e, t, n) {
                                if ((0, i.isDefined)(t)) {
                                    for (var a = 0; a < t.length; a++) {
                                        var o = t[a];
                                        "number" == typeof o && isFinite(o) && (e.getColumn(n + a).width = Math.min(255, Math.floor(o / 7 * 100) / 100))
                                    }
                                }
                            },
                            export: function(e, t) {
                                var n, i = this,
                                    a = e.customizeCell,
                                    l = e.component,
                                    u = e.worksheet,
                                    d = e.topLeftCell,
                                    f = e.autoFilterEnabled,
                                    h = e.keepColumnWidths,
                                    g = e.selectedRowsOnly,
                                    p = e.loadPanel,
                                    m = e.mergeRowFieldValues,
                                    _ = e.mergeColumnFieldValues,
                                    v = ((null === (n = l._getInternalInstance) || void 0 === n ? void 0 : n.call(l)) || l).option("loadPanel").enabled;
                                if (l.option("loadPanel.enabled", !1), p.enabled && (0, c.hasWindow)()) {
                                    var x = t._getLoadPanelTargetElement(l),
                                        y = t._getLoadPanelContainer(l);
                                    this._loadPanel = new s.ExportLoadPanel(l, x, y, p), this._loadPanel.show()
                                }
                                var b = !!l.option("wordWrapEnabled");
                                u.properties.outlineProperties = {
                                    summaryBelow: !1,
                                    summaryRight: !1
                                };
                                var w = {
                                        from: {
                                            row: d.row,
                                            column: d.column
                                        },
                                        to: {
                                            row: d.row,
                                            column: d.column
                                        }
                                    },
                                    k = l.getDataProvider(g);
                                return new Promise((function(e) {
                                    k.ready().done((function() {
                                        var n = k.getColumns(),
                                            s = k.getRowsCount();
                                        h && i.setColumnsWidth(u, k.getColumnsWidths(), w.from.column);
                                        for (var c = new o.MergedRangesManager(k, t, m, _), d = i.getCellStyles(k), g = 0; g < s; g++) {
                                            var p = u.getRow(w.from.row + g);
                                            t._trySetOutlineLevel(k, p, g), i.exportRow(k, t, c, g, n.length, p, w.from.column, a, b, d), g >= 1 && w.to.row++
                                        }
                                        c.applyMergedRages(u), w.to.column += n.length > 0 ? n.length - 1 : 0;
                                        var v = u.views[0] || {};
                                        l.option("rtlEnabled") && (v.rightToLeft = !0), t._isFrozenZone(k) && (-1 === Object.keys(v).indexOf("state") && (0, r.extend)(v, t._getWorksheetFrozenState(k, w)), t._trySetAutoFilter(k, u, w, f)), Object.keys(v).length > 0 && (u.views = [v]), e(w)
                                    })).always((function() {
                                        l.option("loadPanel.enabled", v), p.enabled && (0, c.hasWindow)() && i._loadPanel.dispose()
                                    }))
                                }))
                            },
                            exportRow: function(e, t, n, a, o, r, s, c, l, u) {
                                for (var d = 0; d < o; d++) {
                                    var f = e.getCellData(a, d, !0),
                                        h = r.getCell(s + d);
                                    n.updateMergedRanges(h, a, d);
                                    var g = n.findMergedCellInfo(a, d);
                                    if ((0, i.isDefined)(g) && h !== g.masterCell) {
                                        h.style = g.masterCell.style, h.value = g.masterCell.value
                                    } else if ((0, i.isDate)(f.value) ? h.value = this.convertDateForExcelJS(f.value) : h.value = f.value, (0, i.isDefined)(h.value)) {
                                        var p = u[e.getStyleId(a, d)],
                                            m = p.bold,
                                            _ = p.alignment,
                                            v = p.numberFormat;
                                        (0, i.isDefined)(v) ? this.setNumberFormat(h, v): (0, i.isString)(h.value) && /^[@=+-]/.test(h.value) && this.setNumberFormat(h, "@"), t._trySetFont(h, m), this.setAlignment(h, l, _)
                                    }(0, i.isFunction)(c) && c(t._getCustomizeCellOptions(h, f.cellSourceData))
                                }
                            }
                        };
                    t.Export = l
                },
            8572:
                /*!**********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_data_grid.js ***!
                  \**********************************************************************************/
                function(e, t, n) {
                    t.exportDataGrid = function(e) {
                        return o.Export.export(function(e) {
                            if (!(0, a.isDefined)(e) || !(0, a.isObject)(e)) {
                                throw Error('The "exportDataGrid" method requires a configuration object.')
                            }
                            if (!(0, a.isDefined)(e.component) || !(0, a.isObject)(e.component) || "dxDataGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a DataGrid instance.')
                            }(0, a.isDefined)(e.selectedRowsOnly) || (e.selectedRowsOnly = !1);
                            (0, a.isDefined)(e.autoFilterEnabled) || (e.autoFilterEnabled = !1);
                            return o.Export.getFullOptions(e)
                        }(e), s)
                    };
                    var i, a = n( /*! ../../core/utils/type */ 35922),
                        o = n( /*! ./export */ 11385),
                        r = (i = n( /*! ../../core/errors */ 17381)) && i.__esModule ? i : {
                            default: i
                        };
                    var s = {
                        _trySetAutoFilter: function(e, t, n, i) {
                            if (i && !(0, a.isDefined)(t.autoFilter) && e.getRowsCount() > 0) {
                                var o = {
                                    from: {
                                        row: n.from.row + e.getHeaderRowCount() - 1,
                                        column: n.from.column
                                    },
                                    to: n.to
                                };
                                t.autoFilter = o
                            }
                        },
                        _trySetFont: function(e, t) {
                            (0, a.isDefined)(t) && (e.font = e.font || {}, e.font.bold = t)
                        },
                        _getWorksheetFrozenState: function(e, t) {
                            return {
                                state: "frozen",
                                ySplit: t.from.row + e.getFrozenArea().y - 1
                            }
                        },
                        _trySetOutlineLevel: function(e, t, n) {
                            n >= e.getHeaderRowCount() && (t.outlineLevel = e.getGroupLevel(n))
                        },
                        _getCustomizeCellOptions: function(e, t) {
                            var n = {
                                excelCell: e,
                                gridCell: t
                            };
                            return Object.defineProperty(n, "cell", {
                                get: function() {
                                    return r.default.log("W0003", "CustomizeCell handler argument", "cell", "20.1", "Use the 'excelCell' field instead"), e
                                }
                            }), n
                        },
                        _isFrozenZone: function(e) {
                            return e.getHeaderRowCount() > 0
                        },
                        _isHeaderCell: function(e, t) {
                            return t < e.getHeaderRowCount()
                        },
                        _allowToMergeRange: function() {
                            return !0
                        },
                        _getLoadPanelTargetElement: function(e) {
                            return e.getView("rowsView").element()
                        },
                        _getLoadPanelContainer: function(e) {
                            return e.getView("rowsView").element().parent()
                        }
                    }
                },
            38526:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_format.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    t.ExportFormat = void 0;
                    var i = n( /*! ../../core/utils/string */ 68752),
                        a = u(n( /*! ../../localization/number */ 18016)),
                        o = u(n( /*! ../../localization/date */ 91500)),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = n( /*! ../../localization/ldml/date.format */ 59937),
                        c = n( /*! ../../localization/language_codes */ 9821),
                        l = n( /*! ../../core/utils/extend */ 13306);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ../../localization/currency */ 89740);
                    var d = {
                            thousands: "#,##0{0},&quot;K&quot;",
                            millions: "#,##0{0},,&quot;M&quot;",
                            billions: "#,##0{0},,,&quot;B&quot;",
                            trillions: "#,##0{0},,,,&quot;T&quot;",
                            percent: "0{0}%",
                            decimal: "#{0}",
                            fixedpoint: "#,##0{0}",
                            exponential: "0{0}E+00",
                            currency: " "
                        },
                        f = /a+/g,
                        h = /E/g,
                        g = /dE+/g,
                        p = /L/g,
                        m = /h/g,
                        _ = /./g;

                    function v(e) {
                        var t = (o.default.format(new Date(2009, 8, 8, 6, 5, 4), e) || "").toString(),
                            n = (0, s.getFormat)((function(t) {
                                return o.default.format(t, e)
                            }));
                        return n && (n = function(e) {
                            return e.split("/").join("\\/").split("'").map((function(e, t) {
                                return t % 2 == 0 ? e.replace(f, "AM/PM").replace(g, "d").replace(h, "d").replace(p, "M").replace(m, "H").split("[").join("\\[").split("]").join("\\]") : e ? e.replace(_, "\\$&") : "'"
                            })).join("")
                        }(n), n = function(e) {
                            var t = (0, c.getLanguageId)(),
                                n = t ? t.toString(16) : "",
                                i = "";
                            if (function(e) {
                                    for (var t, n = 0; n < e.length; n++) {
                                        if ((t = e.charCodeAt(n)) >= 1632 && t < 1642) {
                                            return !0
                                        }
                                    }
                                    return !1
                                }(e)) {
                                for (; n.length < 3;) {
                                    n = "0" + n
                                }
                                i = "[$-2010" + n + "]"
                            } else {
                                n && (i = "[$-" + n + "]")
                            }
                            return i
                        }(t) + n), n
                    }
                    var x = {
                        formatObjectConverter: function(e, t) {
                            var n = {
                                format: e,
                                precision: e && e.precision,
                                dataType: t
                            };
                            return (0, r.isObject)(e) ? (0, l.extend)(n, e, {
                                format: e.formatter || e.type,
                                currency: e.currency
                            }) : n
                        },
                        convertFormat: function(e, t, n, o) {
                            if ((0, r.isDefined)(e)) {
                                if ("date" === n) {
                                    return v(e)
                                }
                                if ((0, r.isString)(e) && d[e.toLowerCase()]) {
                                    return function(e, t, n) {
                                        var o, r;
                                        return (r = "currency" === e ? a.default.getOpenXmlCurrencyFormat(n) : d[e.toLowerCase()]) && (o = (0, i.format)(r, function(e, t) {
                                            var n, i;
                                            if (t > 0) {
                                                for (n = "decimal" !== e ? "." : "", i = 0; i < t; i++) {
                                                    n += "0"
                                                }
                                                return n
                                            }
                                            return ""
                                        }(e, t))), o
                                    }(e, t, o)
                                }
                            }
                        }
                    };
                    t.ExportFormat = x
                },
            31980:
                /*!**********************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_merged_ranges_manager.js ***!
                  \**********************************************************************************************/
                function(e, t) {
                    function n() {
                        return n = Object.assign || function(e) {
                            for (var t = 1; t < arguments.length; t++) {
                                var n = arguments[t];
                                for (var i in n) {
                                    Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                                }
                            }
                            return e
                        }, n.apply(this, arguments)
                    }
                    t.MergedRangesManager = void 0;
                    var i = function() {
                        function e(e, t, n, i) {
                            this.mergedCells = [], this.mergedRanges = [], this.dataProvider = e, this.helpers = t, this.mergeRowFieldValues = n, this.mergeColumnFieldValues = i
                        }
                        var t = e.prototype;
                        return t.updateMergedRanges = function(e, t, i) {
                            if (this.helpers._isHeaderCell(this.dataProvider, t, i) && !this.isCellInMergedRanges(t, i)) {
                                var a = this.dataProvider.getCellMerging(t, i),
                                    o = a.rowspan,
                                    r = a.colspan;
                                if (r || o) {
                                    var s = this.helpers._allowToMergeRange(this.dataProvider, t, i, o, r, this.mergeRowFieldValues, this.mergeColumnFieldValues);
                                    this.updateMergedCells(e, t, i, o, r, s), s && this.mergedRanges.push(n({
                                        masterCell: e
                                    }, {
                                        rowspan: o,
                                        colspan: r
                                    }))
                                }
                            }
                        }, t.isCellInMergedRanges = function(e, t) {
                            return this.mergedCells[e] && this.mergedCells[e][t]
                        }, t.findMergedCellInfo = function(e, t) {
                            if (this.helpers._isHeaderCell(this.dataProvider, e, t) && this.isCellInMergedRanges(e, t)) {
                                return this.mergedCells[e][t]
                            }
                        }, t.updateMergedCells = function(e, t, n, i, a, o) {
                            for (var r = t; r <= t + i; r++) {
                                for (var s = n; s <= n + a; s++) {
                                    this.mergedCells[r] || (this.mergedCells[r] = []), this.mergedCells[r][s] = {
                                        masterCell: e,
                                        unmerged: !o
                                    }
                                }
                            }
                        }, t.applyMergedRages = function(e) {
                            this.mergedRanges.forEach((function(t) {
                                var n = t.masterCell.fullAddress.row,
                                    i = t.masterCell.fullAddress.col,
                                    a = n + t.rowspan,
                                    o = i + t.colspan;
                                e.mergeCells(n, i, a, o)
                            }))
                        }, e
                    }();
                    t.MergedRangesManager = i
                },
            77328:
                /*!***********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/exceljs/export_pivot_grid.js ***!
                  \***********************************************************************************/
                function(e, t, n) {
                    t.exportPivotGrid = function(e) {
                        return a.Export.export(function(e) {
                            if (!(0, i.isDefined)(e) || !(0, i.isObject)(e)) {
                                throw Error('The "exportPivotGrid" method requires a configuration object.')
                            }
                            if (!(0, i.isDefined)(e.component) || !(0, i.isObject)(e.component) || "dxPivotGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a PivotGrid instance.')
                            }(0, i.isDefined)(e.mergeRowFieldValues) || (e.mergeRowFieldValues = !0);
                            (0, i.isDefined)(e.mergeColumnFieldValues) || (e.mergeColumnFieldValues = !0);
                            return a.Export.getFullOptions(e)
                        }(e), r)
                    };
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ./export */ 11385),
                        o = n( /*! ../../core/utils/common */ 20576),
                        r = {
                            _getWorksheetFrozenState: function(e, t) {
                                return {
                                    state: "frozen",
                                    xSplit: t.from.column + e.getFrozenArea().x - 1,
                                    ySplit: t.from.row + e.getFrozenArea().y - 1
                                }
                            },
                            _getCustomizeCellOptions: function(e, t) {
                                return {
                                    excelCell: e,
                                    pivotCell: t
                                }
                            },
                            _isFrozenZone: function() {
                                return !0
                            },
                            _isHeaderCell: function(e, t, n) {
                                return t < e.getColumnAreaRowCount() || n < e.getRowAreaColCount()
                            },
                            _allowToMergeRange: function(e, t, n, i, a, o, r) {
                                return !(e.isColumnAreaCell(t, n) && !r && a || e.isRowAreaCell(t, n) && !o && i)
                            },
                            _getLoadPanelTargetElement: function(e) {
                                return e._dataArea.groupElement()
                            },
                            _getLoadPanelContainer: function(e) {
                                return e.$element()
                            },
                            _trySetAutoFilter: o.noop,
                            _trySetFont: o.noop,
                            _trySetOutlineLevel: o.noop
                        }
                },
            48351:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/file_saver.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    t.fileSaver = t.MIME_TYPES = void 0;
                    var i = u(n( /*! ../core/renderer */ 68374)),
                        a = u(n( /*! ../core/dom_adapter */ 73349)),
                        o = n( /*! ../core/utils/window */ 58201),
                        r = u(n( /*! ../events/core/events_engine */ 55994)),
                        s = u(n( /*! ../ui/widget/ui.errors */ 96688)),
                        c = n( /*! ../core/utils/type */ 35922),
                        l = n( /*! ../core/utils/console */ 30869);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = (0, o.getWindow)(),
                        f = (0, o.getNavigator)(),
                        h = {
                            EXCEL: "xlsx",
                            CSS: "css",
                            PNG: "png",
                            JPEG: "jpeg",
                            GIF: "gif",
                            SVG: "svg",
                            PDF: "pdf"
                        },
                        g = {
                            CSS: "text/css",
                            EXCEL: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
                            PNG: "image/png",
                            JPEG: "image/jpeg",
                            GIF: "image/gif",
                            SVG: "image/svg+xml",
                            PDF: "application/pdf"
                        };
                    t.MIME_TYPES = g;
                    var p = {
                        _revokeObjectURLTimeout: 3e4,
                        _getDataUri: function(e, t) {
                            var n = this._getMimeType(e);
                            return "data:".concat(n, ";base64,").concat(t)
                        },
                        _getMimeType: function(e) {
                            return g[e] || "application/octet-stream"
                        },
                        _linkDownloader: function(e, t) {
                            var n = a.default.createElement("a");
                            return n.download = e, n.href = t, n.target = "_blank", n
                        },
                        _formDownloader: function(e, t, n, o) {
                            var s = {
                                    method: "post",
                                    action: e,
                                    enctype: "multipart/form-data"
                                },
                                c = (0, i.default)("<form>").css({
                                    display: "none"
                                }).attr(s);

                            function l(e, t) {
                                for (var n in t) {
                                    e.setAttribute(n, t[n])
                                }
                                return e
                            }
                            c.append(l(a.default.createElement("input"), {
                                type: "hidden",
                                name: "fileName",
                                value: t
                            })), c.append(l(a.default.createElement("input"), {
                                type: "hidden",
                                name: "contentType",
                                value: n
                            })), c.append(l(a.default.createElement("input"), {
                                type: "hidden",
                                name: "data",
                                value: o
                            })), c.appendTo("body"), r.default.trigger(c, "submit"), r.default.trigger(c, "submit") && c.remove()
                        },
                        _saveByProxy: function(e, t, n, i) {
                            var a = this._getMimeType(n);
                            return this._formDownloader(e, t, a, i)
                        },
                        _winJSBlobSave: function(e, t, n) {
                            var i = new Windows.Storage.Pickers.FileSavePicker;
                            i.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                            var a = h[n];
                            if (a) {
                                var o = this._getMimeType(n);
                                i.fileTypeChoices.insert(o, ["." + a])
                            }
                            i.suggestedFileName = t, i.pickSaveFileAsync().then((function(t) {
                                t && t.openAsync(Windows.Storage.FileAccessMode.readWrite).then((function(t) {
                                    var n = e.msDetachStream();
                                    Windows.Storage.Streams.RandomAccessStream.copyAsync(n, t).then((function() {
                                        t.flushAsync().done((function() {
                                            n.close(), t.close()
                                        }))
                                    }))
                                }))
                            }))
                        },
                        _click: function(e) {
                            try {
                                e.dispatchEvent(new MouseEvent("click", {
                                    cancelable: !0
                                }))
                            } catch (n) {
                                var t = a.default.getDocument().createEvent("MouseEvents");
                                t.initMouseEvent("click", !0, !0, d, 0, 0, 0, 80, 20, !1, !1, !1, !1, 0, null), e.dispatchEvent(t)
                            }
                        },
                        _saveBlobAs: function(e, t, n) {
                            var i = this;
                            if (this._blobSaved = !1, (0, c.isDefined)(f.msSaveOrOpenBlob)) {
                                f.msSaveOrOpenBlob(n, e), this._blobSaved = !0
                            } else if ((0, c.isDefined)(d.WinJS)) {
                                this._winJSBlobSave(n, e, t), this._blobSaved = !0
                            } else {
                                var a = d.URL || d.webkitURL || d.mozURL || d.msURL || d.oURL;
                                if ((0, c.isDefined)(a)) {
                                    var o = a.createObjectURL(n),
                                        r = this._linkDownloader(e, o);
                                    setTimeout((function() {
                                        a.revokeObjectURL(o), i._objectUrlRevoked = !0
                                    }), this._revokeObjectURLTimeout), this._click(r)
                                } else {
                                    l.logger.warn("window.URL || window.webkitURL || window.mozURL || window.msURL || window.oURL is not defined")
                                }
                            }
                        },
                        saveAs: function(e, t, n, i, a) {
                            var o = h[t];
                            if (o && (e += "." + o), (0, c.isDefined)(i) && s.default.log("W0001", "Export", "proxyURL", "19.2", "This option is no longer required"), a) {
                                this._saveByProxy(i, e, t, n)
                            } else if ((0, c.isFunction)(d.Blob)) {
                                this._saveBlobAs(e, t, n)
                            } else if ((0, c.isDefined)(i) && !(0, c.isDefined)(f.userAgent.match(/iPad/i))) {
                                this._saveByProxy(i, e, t, n)
                            } else {
                                (0, c.isDefined)(f.userAgent.match(/iPad/i)) || s.default.log("E1034");
                                var r = this._linkDownloader(e, this._getDataUri(t, n));
                                this._click(r)
                            }
                        }
                    };
                    t.fileSaver = p
                },
            12173:
                /*!***********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/image_creator.js ***!
                  \***********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return $.getData(e, t)
                    }, t.imageCreator = void 0, t.testFormats = function(e) {
                        var t = T(100, 100, 0);
                        return e.reduce((function(e, n) {
                            var i = ("image/" + n).toLowerCase();
                            return -1 !== t.toDataURL(i).indexOf(i) ? e.supported.push(n) : e.unsupported.push(n), e
                        }), {
                            supported: [],
                            unsupported: []
                        })
                    };
                    var i = g(n( /*! ../core/renderer */ 68374)),
                        a = g(n( /*! ../color */ 52752)),
                        o = n( /*! ../core/utils/type */ 35922),
                        r = n( /*! ../core/utils/svg */ 19155),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        c = n( /*! ../core/utils/extend */ 13306),
                        l = g(n( /*! ../core/dom_adapter */ 73349)),
                        u = n( /*! ../core/utils/dom */ 3532),
                        d = n( /*! ../core/utils/window */ 58201),
                        f = n( /*! ../core/utils/inflector */ 78008),
                        h = n( /*! ../core/utils/deferred */ 62754);

                    function g(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var p, m = (0, d.getWindow)(),
                        _ = Math,
                        v = _.PI,
                        x = _.min,
                        y = _.abs,
                        b = _.sqrt,
                        w = _.pow,
                        k = _.atan2,
                        S = _.cos,
                        C = _.sin,
                        A = Number;

                    function T(e, t, n) {
                        var a = (0, i.default)("<canvas>")[0];
                        return a.width = e + 2 * n, a.height = t + 2 * n, a.hidden = !0, a
                    }

                    function E(e, t, n, i, a, o, r, s) {
                        var c = (e + n) / 2,
                            l = (t + i) / 2,
                            u = k(t - i, e - n),
                            d = o ? 1 : -1;
                        u += v / 180 * 90 * (r ? 1 : -1);
                        var f = b(w(n - e, 2) + w(i - t, 2)) / 2,
                            h = b(y(w(a, 2) - w(f, 2))),
                            g = c + d * (h * S(u)),
                            p = l + d * (h * C(u)),
                            m = k(t - p, e - g),
                            _ = k(i - p, n - g);
                        s.arc(g, p, a, m, _, !r)
                    }

                    function O(e, t) {
                        var n, i = p(e.attributes || {}),
                            a = (0, c.extend)({}, i, {
                                text: e.textContent.replace(/\s+/g, " "),
                                textAlign: "middle" === i["text-anchor"] ? "center" : i["text-anchor"]
                            }),
                            r = i.transform;
                        return r && ((n = r.match(/translate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), a.translateX = A(n[0]), a.translateY = n[1] ? A(n[1]) : 0), (n = r.match(/rotate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), a.rotationAngle = A(n[0]), a.rotationX = n[1] && A(n[1]), a.rotationY = n[2] && A(n[2])), (n = r.match(/scale\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/)) && (n = n[0].match(/-*\d+([.]\d+)*/g), a.scaleX = A(n[0]), n.length > 1 ? a.scaleY = A(n[1]) : a.scaleY = a.scaleX)),
                            function(e, t, n) {
                                var i, a = e.style || {};
                                for (i in a) {
                                    "" !== a[i] && (t[(0, f.camelize)(i)] = a[i])
                                }
                                n && l.default.isElementNode(e) && (a = m.getComputedStyle(e), ["fill", "stroke", "stroke-width", "font-family", "font-size", "font-style", "font-weight"].forEach((function(e) {
                                    e in a && "" !== a[e] && (t[(0, f.camelize)(e)] = a[e])
                                })), ["opacity", "fill-opacity", "stroke-opacity"].forEach((function(e) {
                                    e in a && "" !== a[e] && "1" !== a[e] && (t[e] = A(a[e]))
                                })));
                                t.textDecoration = t.textDecoration || t.textDecorationLine, t.globalAlpha = (0, o.isDefined)(t.opacity) ? t.opacity : t.globalAlpha
                            }(e, a, t), a
                    }

                    function D(e) {
                        var t = e && e.match(/url\(.*#(.*?)["']?\)/i);
                        return t && t[1]
                    }

                    function M(e, t) {
                        var n = [];
                        t.fontSize = t.fontSize || "10px", t.fontFamily = t.fontFamily || "sans-serif", t.fill = t.fill || "#000", t.fontStyle && n.push(t.fontStyle), t.fontWeight && n.push(t.fontWeight), n.push(t.fontSize), n.push(t.fontFamily), e.font = n.join(" "), e.textAlign = t.textAlign, e.fillStyle = t.fill, e.globalAlpha = t.globalAlpha
                    }

                    function R(e) {
                        for (var t = e.childNodes, n = 0; n < t.length; n++) {
                            if ("tspan" === t[n].tagName) {
                                return !0
                            }
                        }
                        return !1
                    }

                    function z(e, t, n, i) {
                        var a = e.tagName,
                            o = "text" === a || "tspan" === a || void 0 === a,
                            s = "image" === a,
                            l = (0, c.extend)({}, n, O(e, i.rootAppended));
                        if ("hidden" !== l.visibility && !l[r.HIDDEN_FOR_EXPORT]) {
                            var u;
                            switch (t.save(), !s && B(t, l), V(t, l, i), function(e) {
                                    e.strokeOpacity = void 0 !== e["stroke-opacity"] ? e["stroke-opacity"] : 1, e.fillOpacity = void 0 !== e["fill-opacity"] ? e["fill-opacity"] : 1, void 0 !== e.opacity && (e.strokeOpacity *= e.opacity, e.fillOpacity *= e.opacity)
                                }(l), t.beginPath(), e.tagName) {
                                case void 0:
                                    ! function(e, t, n) {
                                        M(e, t), L(e, t, n), t.text && e.fillText(t.text, t.x || 0, t.y || 0), j(e, t, !0),
                                            function(e, t, n) {
                                                if (!t.textDecoration || "none" === t.textDecoration) {
                                                    return
                                                }
                                                var i = t.x,
                                                    a = e.measureText(t.text).width,
                                                    o = parseInt(t.fontSize, 10),
                                                    r = .05 * o < 1 ? 1 : .05 * o,
                                                    s = t.y;
                                                switch (t.textDecoration) {
                                                    case "line-through":
                                                        s -= o / 3 + r / 2;
                                                        break;
                                                    case "overline":
                                                        s -= o - r;
                                                        break;
                                                    case "underline":
                                                        s += r
                                                }
                                                e.rect(i, s, a, r), G(e, t, n), j(e, t)
                                            }(e, t, n)
                                    }(t, l, i);
                                    break;
                                case "text":
                                case "tspan":
                                    ! function q(e, t, n, i) {
                                        for (var a, o = [], r = 0, s = 0; s < e.length; s++) {
                                            var l = e[s];
                                            if (void 0 === l.tagName) {
                                                z(l, t, n, i)
                                            } else if ("tspan" === l.tagName || "text" === l.tagName) {
                                                var u = O(l, i.rootAppended),
                                                    d = (0, c.extend)({}, n, u);
                                                if ("tspan" === l.tagName && R(l)) {
                                                    q(l.childNodes, t, d, i);
                                                    continue
                                                }
                                                d.textAlign = "start", a && void 0 === u.x || (a = {
                                                    elements: [],
                                                    options: [],
                                                    widths: [],
                                                    offsets: []
                                                }, o.push(a)), void 0 !== u.y && (r = 0), void 0 !== u.dy && (r += parseFloat(u.dy)), a.elements.push(l), a.options.push(d), a.offsets.push(r), M(t, d), a.widths.push(t.measureText(d.text).width)
                                            }
                                        }
                                        o.forEach((function(e) {
                                            var a = e.widths.reduce((function(e, t) {
                                                    return e + t
                                                }), 0),
                                                o = 0,
                                                r = 0;
                                            "center" === n.textAlign && (o = a / 2), "end" === n.textAlign && (o = a), e.options.forEach((function(t, n) {
                                                var i = e.widths[n];
                                                t.x = t.x - o + r, t.y += e.offsets[n], r += i
                                            })), e.elements.forEach((function(n, a) {
                                                q(n.childNodes, t, e.options[a], i)
                                            }))
                                        }))
                                    }(e.childNodes, t, l, i);
                                    break;
                                case "image":
                                    u = function(e, t, n) {
                                        var i = new h.Deferred,
                                            a = new m.Image;
                                        return a.onload = function() {
                                            e.save(), e.globalAlpha = t.globalAlpha, B(e, t), V(e, t, n), e.drawImage(a, t.x, t.y, t.width, t.height), e.restore(), i.resolve()
                                        }, a.onerror = function() {
                                            i.resolve()
                                        }, a.setAttribute("crossOrigin", "anonymous"), a.src = t.href || t["xlink:href"], i
                                    }(t, l, i);
                                    break;
                                case "path":
                                    ! function(e, t) {
                                        var n, i, a, o = t.replace(/,/g, " ").split(/([A-Z])/i).filter((function(e) {
                                                return "" !== e.trim()
                                            })),
                                            r = 0;
                                        do {
                                            switch (n = (o[r + 1] || "").trim().split(" "), o[r]) {
                                                case "M":
                                                    e.moveTo(A(n[0]), A(n[1])), r += 2;
                                                    break;
                                                case "L":
                                                    for (var s = 0; s < n.length / 2; s++) {
                                                        e.lineTo(A(n[2 * s]), A(n[2 * s + 1]))
                                                    }
                                                    r += 2;
                                                    break;
                                                case "C":
                                                    e.bezierCurveTo(A(n[0]), A(n[1]), A(n[2]), A(n[3]), A(n[4]), A(n[5])), r += 2;
                                                    break;
                                                case "a":
                                                    a = (i = o[r - 1].trim().split(" ")).length - 1, E(A(i[a - 1]), A(i[a]), A(i[a - 1]) + A(n[5]), A(i[a]) + A(n[6]), A(n[0]), A(n[3]), A(n[4]), e), r += 2;
                                                    break;
                                                case "A":
                                                    a = (i = o[r - 1].trim().split(" ")).length - 1, E(A(i[a - 1]), A(i[a]), A(n[5]), A(n[6]), A(n[0]), A(n[3]), A(n[4]), e), r += 2;
                                                    break;
                                                case "Z":
                                                    e.closePath(), r += 1;
                                                    break;
                                                default:
                                                    r++
                                            }
                                        } while (r < o.length)
                                    }(t, l.d);
                                    break;
                                case "rect":
                                    ! function(e, t) {
                                        var n = t.x,
                                            i = t.y,
                                            a = t.width,
                                            o = t.height,
                                            r = t.rx;
                                        r ? (r = x(r, a / 2, o / 2), e.save(), e.translate(n, i), e.moveTo(a / 2, 0), e.arcTo(a, 0, a, o, r), e.arcTo(a, o, 0, o, r), e.arcTo(0, o, 0, 0, r), e.arcTo(0, 0, r, 0, r), e.lineTo(a / 2, 0), e.restore()) : e.rect(n, i, a, o)
                                    }(t, l), t.closePath();
                                    break;
                                case "circle":
                                    t.arc(l.cx, l.cy, l.r, 0, 2 * v, 1)
                            }
                            return o || (L(t, l, i), G(t, l, i), j(t, l)),
                                function(e, t, n, i) {
                                    var a = n.gradients;
                                    if (0 === a.length) {
                                        return
                                    }
                                    var o = D(t.fill);
                                    if (o && a[o]) {
                                        var r = i.getBBox(),
                                            s = e.createLinearGradient(r.x, 0, r.x + r.width, 0);
                                        a[o].forEach((function(e) {
                                            var t = parseInt(e.offset.replace(/%/, ""));
                                            s.addColorStop(t / 100, e.stopColor)
                                        })), e.globalAlpha = t.opacity, e.fillStyle = s, e.fill()
                                    }
                                }(t, l, i, e), t.restore(), u
                        }
                    }

                    function L(e, t, n) {
                        var i, a = D(t.filter);
                        a && ((i = n.filters[a]) || (i = {
                            offsetX: 0,
                            offsetY: 0,
                            blur: 0,
                            color: "#000"
                        }), e.shadowOffsetX = i.offsetX, e.shadowOffsetY = i.offsetY, e.shadowColor = i.color, e.shadowBlur = i.blur)
                    }

                    function B(e, t) {
                        e.translate(t.translateX || 0, t.translateY || 0), t.translateX = void 0, t.translateY = void 0, t.rotationAngle && (e.translate(t.rotationX || 0, t.rotationY || 0), e.rotate(t.rotationAngle * v / 180), e.translate(-(t.rotationX || 0), -(t.rotationY || 0)), t.rotationAngle = void 0, t.rotationX = void 0, t.rotationY = void 0), isFinite(t.scaleX) && (e.scale(t.scaleX, t.scaleY), t.scaleX = void 0, t.scaleY = void 0)
                    }

                    function V(e, t, n) {
                        t["clip-path"] && (z(n.clipPaths[D(t["clip-path"])], e, {}, n), e.clip(), t["clip-path"] = void 0)
                    }

                    function F(e) {
                        var t, n, i = {};
                        return (0, s.each)(e.childNodes, (function(e, o) {
                            var r = o.attributes;
                            if (r.result) {
                                switch (r.result.value) {
                                    case "gaussianBlurResult":
                                        i.blur = A(r.stdDeviation.value);
                                        break;
                                    case "offsetResult":
                                        i.offsetX = A(r.dx.value), i.offsetY = A(r.dy.value);
                                        break;
                                    case "floodResult":
                                        t = r["flood-color"] ? r["flood-color"].value : "#000", n = r["flood-opacity"] ? r["flood-opacity"].value : 1, i.color = function(e, t) {
                                            var n = new a.default(e);
                                            return "rgba(" + n.r + "," + n.g + "," + n.b + "," + t + ")"
                                        }(t, n)
                                }
                            }
                        })), i
                    }

                    function H(e, t, n, i) {
                        return function N(e, t) {
                            for (var n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : new h.Deferred, i = 0; i < e.length; i++) {
                                var a = t(e[i]);
                                if ((0, o.isPromise)(a)) {
                                    a.then((function() {
                                        N(Array.prototype.slice.call(e, i + 1), t, n)
                                    }));
                                    break
                                }
                            }
                            return i === e.length && n.resolve(), n
                        }(e, (function(e) {
                            switch (e.tagName && e.tagName.toLowerCase()) {
                                case "g":
                                case "svg":
                                    var a = (0, c.extend)({}, n, O(e, i.rootAppended));
                                    t.save(), B(t, a), V(t, a, i);
                                    var r = function() {
                                            t.restore()
                                        },
                                        l = H(e.childNodes, t, a, i);
                                    return (0, o.isPromise)(l) ? l.then(r) : r(), l;
                                case "defs":
                                    return H(e.childNodes, t, {}, i);
                                case "clippath":
                                    i.clipPaths[e.attributes.id.textContent] = e.childNodes[0];
                                    break;
                                case "pattern":
                                    i.patterns[e.attributes.id.textContent] = e;
                                    break;
                                case "filter":
                                    i.filters[e.id] = F(e);
                                    break;
                                case "lineargradient":
                                    i.gradients[e.attributes.id.textContent] = function(e) {
                                        var t = [];
                                        return (0, s.each)(e.childNodes, (function(e, n) {
                                            var i = n.attributes;
                                            t.push({
                                                offset: i.offset.value,
                                                stopColor: i["stop-color"].value
                                            })
                                        })), t
                                    }(e);
                                    break;
                                default:
                                    return z(e, t, n, i)
                            }
                        }))
                    }

                    function j(e, t, n) {
                        var i = t.stroke;
                        i && "none" !== i && 0 !== t["stroke-width"] && (! function(e, t) {
                            var n = t["stroke-dasharray"] && t["stroke-dasharray"].match(/(\d+)/g);
                            n && n.length && (n = (0, s.map)(n, (function(e) {
                                return A(e)
                            })), e.setLineDash(n))
                        }(e, t), e.lineJoin = t["stroke-linejoin"], e.lineWidth = t["stroke-width"], e.globalAlpha = t.strokeOpacity, e.strokeStyle = i, n ? e.strokeText(t.text, t.x, t.y) : e.stroke(), e.globalAlpha = 1)
                    }

                    function G(e, t, n) {
                        var i = t.fill;
                        if (i && "none" !== i) {
                            if (-1 === i.search(/url/)) {
                                e.fillStyle = i
                            } else {
                                var a = n.patterns[D(i)];
                                if (!a) {
                                    return
                                }
                                e.fillStyle = function(e, t, n) {
                                    var i = O(t, n.rootAppended),
                                        a = T(i.width, i.height, 0),
                                        o = a.getContext("2d");
                                    return H(t.childNodes, o, i, n), e.createPattern(a, "repeat")
                                }(e, a, n)
                            }
                            e.globalAlpha = t.fillOpacity, e.fill(), e.globalAlpha = 1
                        }
                    }

                    function W(e, t, n) {
                        return H(e.childNodes, t.getContext("2d"), {}, {
                            clipPaths: {},
                            patterns: {},
                            filters: {},
                            gradients: {},
                            rootAppended: n
                        })
                    }
                    p = function(e) {
                        var t, n = {};
                        return (0, s.each)(e, (function(e, i) {
                            t = i.textContent, isFinite(t) && (t = A(t)), n[i.name.toLowerCase()] = t
                        })), n
                    };
                    var $ = {
                        getImageData: function(e, t) {
                            var n = "image/" + t.format;
                            return (0, o.isFunction)(t.__parseAttributesFn) && (p = t.__parseAttributesFn),
                                function(e, t) {
                                    var n = t.width,
                                        i = t.height,
                                        a = t.backgroundColor,
                                        o = t.margin,
                                        s = t.pixelRatio,
                                        c = t.svgToCanvas,
                                        d = void 0 === c ? W : c,
                                        f = T(n, i, o),
                                        g = f.getContext("2d");
                                    g.setTransform(s, 0, 0, s, 0, 0);
                                    var p, m = (0, r.getSvgElement)(e),
                                        _ = l.default.isElementNode(e);
                                    return g.translate(o, o), l.default.getBody().appendChild(f), _ || ((p = function() {
                                            var e = l.default.createElement("div");
                                            return e.style.left = "-9999px", e.style.position = "absolute", e
                                        }()).appendChild(m), l.default.getBody().appendChild(p)), m.attributes.direction && (f.dir = m.attributes.direction.textContent),
                                        function(e, t, n, i, a) {
                                            e.fillStyle = i || "#ffffff", e.fillRect(-a, -a, t + 2 * a, n + 2 * a)
                                        }(g, n, i, a, o), (0, h.fromPromise)(d(m, f, _ && (0, u.contains)(l.default.getBody(), e))).then((function() {
                                            return f
                                        })).always((function() {
                                            p && l.default.getBody().removeChild(p), l.default.getBody().removeChild(f)
                                        }))
                                }(e, t).then((function(e) {
                                    return function(e, t) {
                                        var n = e.toDataURL(t, 1);
                                        return m.atob(n.substring(("data:" + t + ";base64,").length))
                                    }(e, n)
                                }))
                        },
                        getData: function(e, t) {
                            var n = this;
                            return $.getImageData(e, t).then((function(e) {
                                var i = "image/" + t.format;
                                return (0, o.isFunction)(m.Blob) && !t.forceProxy ? n._getBlob(e, i) : n._getBase64(e)
                            }))
                        },
                        _getBlob: function(e, t) {
                            var n, i = new Uint8Array(e.length);
                            for (n = 0; n < e.length; n++) {
                                i[n] = e.charCodeAt(n)
                            }
                            return new m.Blob([i.buffer], {
                                type: t
                            })
                        },
                        _getBase64: function(e) {
                            return m.btoa(e)
                        }
                    };
                    t.imageCreator = $
                },
            39458:
                /*!**********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export.js ***!
                  \**********************************************************************/
                function(e, t, n) {
                    t.Export = void 0;
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ../../core/utils/extend */ 13306),
                        o = u(n( /*! ../../localization/date */ 91500)),
                        r = u(n( /*! ../../localization/number */ 18016)),
                        s = u(n( /*! ../../localization/message */ 28109)),
                        c = n( /*! ../common/export_load_panel */ 5332),
                        l = n( /*! ../../core/utils/window */ 58201);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = {
                        getFullOptions: function(e) {
                            var t = (0, a.extend)({}, e);
                            if (!(0, i.isDefined)(t.jsPDFDocument) || !(0, i.isObject)(t.jsPDFDocument)) {
                                throw Error('The "jsPDFDocument" field must contain a jsPDF instance.')
                            }
                            if (!(0, i.isDefined)(t.jsPDFDocument.autoTable) || !(0, i.isFunction)(t.jsPDFDocument.autoTable)) {
                                throw Error('The "exportDataGrid" method requires a autoTable plugin for jsPDF object.')
                            }
                            if ((0, i.isDefined)(t.keepColumnWidths) || (t.keepColumnWidths = !0), (0, i.isDefined)(t.autoTableOptions)) {
                                if (!(0, i.isObject)(t.autoTableOptions)) {
                                    throw Error('The "autoTableOptions" option must be of object type.')
                                }
                                t.autoTableOptions = (0, a.extend)(!0, {}, this._getDefaultAutoTableOptions(), t.autoTableOptions)
                            } else {
                                t.autoTableOptions = this._getDefaultAutoTableOptions()
                            }
                            return (0, i.isDefined)(t.loadPanel) || (t.loadPanel = {}), (0, i.isDefined)(t.loadPanel.enabled) || (t.loadPanel.enabled = !0), (0, i.isDefined)(t.loadPanel.text) || (t.loadPanel.text = s.default.format("dxDataGrid-exporting")), t
                        },
                        _getDefaultAutoTableOptions: function() {
                            return {
                                theme: "plain",
                                tableLineColor: 149,
                                tableLineWidth: .1,
                                styles: {
                                    textColor: 51,
                                    lineColor: 149,
                                    lineWidth: 0
                                },
                                columnStyles: {},
                                headStyles: {
                                    fontStyle: "normal",
                                    textColor: 149,
                                    lineWidth: .1
                                },
                                bodyStyles: {
                                    lineWidth: .1
                                },
                                head: [],
                                body: []
                            }
                        },
                        export: function(e) {
                            var t, n = this,
                                a = e.jsPDFDocument,
                                o = e.autoTableOptions,
                                r = e.component,
                                s = e.customizeCell,
                                u = e.keepColumnWidths,
                                d = e.selectedRowsOnly,
                                f = e.loadPanel,
                                h = ((null === (t = r._getInternalInstance) || void 0 === t ? void 0 : t.call(r)) || r).option("loadPanel").enabled;
                            if (r.option("loadPanel.enabled", !1), f.enabled && (0, l.hasWindow)()) {
                                var g = r.getView("rowsView");
                                this._loadPanel = new c.ExportLoadPanel(r, g.element(), g.element().parent(), f), this._loadPanel.show()
                            }
                            var p = r.getDataProvider(d),
                                m = !!r.option("wordWrapEnabled");
                            return new Promise((function(e) {
                                p.ready().done((function() {
                                    var t = p.getColumns(),
                                        r = p.getStyles(),
                                        c = p.getRowsCount(),
                                        l = p.getHeaderRowCount(),
                                        d = [];
                                    if (u) {
                                        var f = n._tryGetPdfColumnWidths(o.tableWidth, p.getColumnsWidths());
                                        (0, i.isDefined)(f) && (0, i.isDefined)(o.columnStyles) && n._setColumnWidths(o.columnStyles, f)
                                    }
                                    for (var h = 0; h < c; h++) {
                                        for (var g = [], _ = 0; _ < t.length; _++) {
                                            var v = p.getCellData(h, _, !0),
                                                x = v.value,
                                                y = v.cellSourceData,
                                                b = r[p.getStyleId(h, _)],
                                                w = {
                                                    content: n._getFormattedValue(x, b.format),
                                                    styles: n._getPDFCellStyles(y.rowType, t[_].alignment, b, m)
                                                };
                                            if ("header" === y.rowType) {
                                                var k = n._tryGetMergeRange(h, _, d, p);
                                                k && k.rowSpan > 0 && (w.rowSpan = k.rowSpan + 1), k && k.colSpan > 0 && (w.colSpan = k.colSpan + 1), (!(d[h] && d[h][_]) || w.rowSpan > 1 || w.colSpan > 1) && ((0, i.isFunction)(s) && s({
                                                    gridCell: y,
                                                    pdfCell: w
                                                }), g.push(w))
                                            } else if ("group" !== y.rowType || (0, i.isDefined)(w.content) || 1 !== g.length) {
                                                var S;
                                                w.content = null !== (S = w.content) && void 0 !== S ? S : "", (0, i.isFunction)(s) && s({
                                                    gridCell: y,
                                                    pdfCell: w
                                                }), g.push(w)
                                            } else {
                                                var C;
                                                g[0].colSpan = null !== (C = g[0].colSpan) && void 0 !== C ? C : 1, g[0].colSpan++
                                            }
                                        }
                                        h < l ? o.head.push(g) : o.body.push(g)
                                    }
                                    a.autoTable(o), e()
                                })).always((function() {
                                    r.option("loadPanel.enabled", h), f.enabled && (0, l.hasWindow)() && n._loadPanel.dispose()
                                }))
                            }))
                        },
                        _getFormattedValue: function(e, t) {
                            if ((0, i.isDefined)(t)) {
                                if ((0, i.isDate)(e)) {
                                    return o.default.format(e, t)
                                }
                                if ((0, i.isNumeric)(e)) {
                                    return r.default.format(e, t)
                                }
                            }
                            return e
                        },
                        _getPDFCellStyles: function(e, t, n, i) {
                            var a = n.alignment,
                                o = n.bold,
                                r = "header" === e ? t : a,
                                s = {};
                            return r && (s.halign = r), o && "header" !== e && (s.fontStyle = "bold"), i && (s.cellWidth = "wrap"), s
                        },
                        _tryGetMergeRange: function(e, t, n, i) {
                            if (!n[e] || !n[e][t]) {
                                var a = i.getCellMerging(e, t),
                                    o = a.colspan,
                                    r = a.rowspan;
                                if (o || r) {
                                    for (var s = e; s <= e + r; s++) {
                                        for (var c = t; c <= t + o; c++) {
                                            n[s] || (n[s] = []), n[s][c] = !0
                                        }
                                    }
                                    return {
                                        rowSpan: r,
                                        colSpan: o
                                    }
                                }
                            }
                        },
                        _tryGetPdfColumnWidths: function(e, t) {
                            if ((0, i.isNumeric)(e) && (0, i.isDefined)(t)) {
                                var n = t.reduce((function(e, t) {
                                    return e + t
                                }), 0);
                                return t.map((function(t) {
                                    return e * t / n
                                }))
                            }
                        },
                        _setColumnWidths: function(e, t) {
                            t.forEach((function(t, n) {
                                e[n] = e[n] || {}, e[n].cellWidth = t
                            }))
                        }
                    };
                    t.Export = d
                },
            654:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export_data_grid.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    t.exportDataGrid = function(e) {
                        return a.Export.export(function(e) {
                            if (!(0, i.isDefined)(e) || !(0, i.isObject)(e)) {
                                throw Error('The "exportDataGrid" method requires a configuration object.')
                            }
                            if (!(0, i.isDefined)(e.component) || !(0, i.isObject)(e.component) || "dxDataGrid" !== e.component.NAME) {
                                throw Error('The "component" field must contain a DataGrid instance.')
                            }(0, i.isDefined)(e.selectedRowsOnly) || (e.selectedRowsOnly = !1);
                            return a.Export.getFullOptions(e)
                        }(e))
                    };
                    var i = n( /*! ../../core/utils/type */ 35922),
                        a = n( /*! ./export */ 39458)
                },
            29982:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/jspdf/export_gantt.js ***!
                  \****************************************************************************/
                function(e, t) {
                    t.exportGantt = function(e) {
                        var t = e.component;
                        return null == t ? void 0 : t.exportToPdf(e)
                    }
                },
            30855:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/pdf_creator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return o.imageCreator.getImageData(e, (0, s.extend)({}, t, {
                            format: "JPEG"
                        })).then((function(e) {
                            var n = function(e, t, n) {
                                    var a = 2 * (t.margin || 0),
                                        o = t.width + a,
                                        r = t.height + a,
                                        s = (.75 * o).toFixed(2),
                                        c = (.75 * r).toFixed(2),
                                        _ = l.replace("_width_", s).replace("_height_", c),
                                        v = u.replace("_width_", s).replace("_height_", c),
                                        x = d.replace("_date_", n).replace("_version_", i.version),
                                        y = f.replace("_width_", o).replace("_height_", r).replace("_length_", e.length) + e + h,
                                        b = (S = _.length, C = v.length, A = x.length, p.replace("_main_", m(S + "", 10)).replace("_info_", m(S + C + "", 10)).replace("_image_", m(S + C + A + "", 10))),
                                        w = _ + v + x + y,
                                        k = g.replace("_length_", w.length);
                                    var S, C, A;
                                    return w + b + k
                                }(e, t, new Date),
                                a = (0, r.isFunction)(c.Blob) ? function(e) {
                                    for (var t = 0, n = new Uint8Array(e.length); t < e.length; t++) {
                                        n[t] = e.charCodeAt(t)
                                    }
                                    return new c.Blob([n.buffer], {
                                        type: "application/pdf"
                                    })
                                }(n) : function(e) {
                                    return c.btoa(e)
                                }(n);
                            return a
                        }))
                    };
                    var i = n( /*! ../core/version */ 36739),
                        a = n( /*! ../core/utils/window */ 58201),
                        o = n( /*! ./image_creator */ 12173),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/extend */ 13306),
                        c = (0, a.getWindow)(),
                        l = "%PDF-1.3\r\n2 0 obj\r\n<</ProcSet[/PDF/ImageB/ImageC/ImageI]/XObject<</I0 5 0 R>>>>\r\nendobj\r\n4 0 obj\r\n<</Type/Pages/Kids[1 0 R]/Count 1>>\r\nendobj\r\n7 0 obj\r\n<</OpenAction[1 0 R /FitH null]/Type/Catalog/Pages 4 0 R/PageLayout/OneColumn>>\r\nendobj\r\n1 0 obj\r\n<</Type/Page/Resources 2 0 R/MediaBox[0 0 _width_ _height_]/Contents 3 0 R/Parent 4 0 R>>\r\nendobj\r\n",
                        u = "3 0 obj\r\n<</Length 52>>stream\r\n0.20 w\n0 G\nq _width_ 0 0 _height_ 0.00 0.00 cm /I0 Do Q\r\nendstream\r\nendobj\r\n",
                        d = "6 0 obj\r\n<</CreationDate _date_/Producer(DevExtreme _version_)>>\r\nendobj\r\n",
                        f = "5 0 obj\r\n<</Type/XObject/Subtype/Image/Width _width_/Height _height_/ColorSpace/DeviceRGB/BitsPerComponent 8/Filter/DCTDecode/Length _length_>>stream\r\n",
                        h = "\r\nendstream\r\nendobj\r\n",
                        g = "trailer\r\n<<\r\n/Size 8\r\n/Root 7 0 R\r\n/Info 6 0 R\r\n>>\r\nstartxref\r\n_length_\r\n%%EOF",
                        p = "xref\r\n0 8\r\n0000000000 65535 f\r\n0000000241 00000 n\r\n0000000010 00000 n\r\n_main_ 00000 n\r\n0000000089 00000 n\r\n_image_ 00000 n\r\n_info_ 00000 n\r\n0000000143 00000 n\r\n",
                        m = function e(t, n) {
                            return t.length < n ? e("0" + t, n) : t
                        }
                },
            37596:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/exporter/svg_creator.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    t.getData = function(e, t) {
                        return f.getData(e, t)
                    }, t.svgCreator = void 0;
                    var i = u(n( /*! ../core/renderer */ 68374)),
                        a = u(n( /*! ../core/utils/ajax */ 37208)),
                        o = n( /*! ../core/utils/window */ 58201),
                        r = n( /*! ../core/utils/type */ 35922),
                        s = n( /*! ../core/utils/iterator */ 95479),
                        c = n( /*! ../core/utils/svg */ 19155),
                        l = n( /*! ../core/utils/deferred */ 62754);

                    function u(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var d = (0, o.getWindow)(),
                        f = {
                            _markup: "",
                            _imageArray: {},
                            _imageDeferreds: [],
                            _getBinaryFile: function(e, t) {
                                a.default.sendRequest({
                                    url: e,
                                    method: "GET",
                                    responseType: "arraybuffer"
                                }).done(t).fail((function() {
                                    t(!1)
                                }))
                            },
                            _loadImages: function() {
                                var e = this;
                                (0, s.each)(e._imageArray, (function(t) {
                                    var n = new l.Deferred;
                                    e._imageDeferreds.push(n), e._getBinaryFile(t, (function(i) {
                                        if (!i) {
                                            return delete e._imageArray[t], void n.resolve()
                                        }
                                        var a, o = "",
                                            r = new Uint8Array(i),
                                            s = r.byteLength;
                                        for (a = 0; a < s; a++) {
                                            o += String.fromCharCode(r[a])
                                        }
                                        e._imageArray[t] = "data:image/png;base64," + d.btoa(o), n.resolve()
                                    }))
                                }))
                            },
                            _parseImages: function(e) {
                                var t, n = this;
                                "image" === e.tagName && (t = (0, i.default)(e).attr("href") || (0, i.default)(e).attr("xlink:href"), n._imageArray[t] || (n._imageArray[t] = "")), (0, s.each)(e.childNodes, (function(e, t) {
                                    n._parseImages(t)
                                }))
                            },
                            _prepareImages: function(e) {
                                return this._parseImages(e), this._loadImages(), l.when.apply(i.default, this._imageDeferreds)
                            },
                            getData: function(e, t) {
                                var n, a = this,
                                    o = (0, c.getSvgElement)(e),
                                    l = (0, i.default)(o);
                                return l.find("[".concat(c.HIDDEN_FOR_EXPORT, "]")).remove(), n = '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>' + (0, c.getSvgMarkup)(l.get(0), t.backgroundColor), a._prepareImages(o).then((function() {
                                    return (0, s.each)(a._imageArray, (function(e, t) {
                                        var i = "href=['|\"]".concat(e, "['|\"]");
                                        n = n.replace(new RegExp(i, "gi"), 'href="'.concat(t, '"'))
                                    })), (0, r.isFunction)(d.Blob) ? a._getBlob(n) : a._getBase64(n)
                                }))
                            },
                            _getBlob: function(e) {
                                return new d.Blob([e], {
                                    type: "image/svg+xml"
                                })
                            },
                            _getBase64: function(e) {
                                return d.btoa(e)
                            }
                        };
                    t.svgCreator = f
                },
            30343:
                /*!**************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/format_helper.js ***!
                  \**************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i = n( /*! ./core/utils/type */ 35922),
                        a = c(n( /*! ./core/utils/date */ 91198)),
                        o = c(n( /*! ./localization/number */ 18016)),
                        r = c(n( /*! ./localization/date */ 91500)),
                        s = c(n( /*! ./core/utils/dependency_injector */ 20476));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    n( /*! ./localization/currency */ 89740);
                    var l = (0, s.default)({
                        format: function(e, t) {
                            var n = (0, i.isString)(t) && "" !== t || (0, i.isPlainObject)(t) || (0, i.isFunction)(t),
                                a = (0, i.isNumeric)(e) || (0, i.isDate)(e);
                            return n && a ? (0, i.isFunction)(t) ? t(e) : ((0, i.isString)(t) && (t = {
                                type: t
                            }), (0, i.isNumeric)(e) ? o.default.format(e, t) : (0, i.isDate)(e) ? r.default.format(e, t) : void 0) : (0, i.isDefined)(e) ? e.toString() : ""
                        },
                        getTimeFormat: function(e) {
                            return e ? "longtime" : "shorttime"
                        },
                        _normalizeFormat: function(e) {
                            return Array.isArray(e) ? 1 === e.length ? e[0] : function(t) {
                                return e.map((function(e) {
                                    return r.default.format(t, e)
                                })).join(" ")
                            } : e
                        },
                        getDateFormatByDifferences: function(e, t) {
                            var n = [],
                                i = t && e.millisecond && !(e.year || e.month || e.day);
                            if (i) {
                                n.push((function(e) {
                                    return e.getSeconds() + e.getMilliseconds() / 1e3 + "s"
                                }))
                            } else {
                                e.millisecond && n.push("millisecond")
                            }
                            if ((e.hour || e.minute || !i && e.second) && n.unshift(this.getTimeFormat(e.second)), e.year && e.month && e.day) {
                                return t && "month" === t ? "monthandyear" : (n.unshift("shortdate"), this._normalizeFormat(n))
                            }
                            if (e.year && e.month) {
                                return "monthandyear"
                            }
                            if (e.year && e.quarter) {
                                return "quarterandyear"
                            }
                            if (e.year) {
                                return "year"
                            }
                            if (e.quarter) {
                                return "quarter"
                            }
                            if (e.month && e.day) {
                                if (t) {
                                    n.unshift((function(e) {
                                        return r.default.getMonthNames("abbreviated")[e.getMonth()] + " " + r.default.format(e, "day")
                                    }))
                                } else {
                                    n.unshift("monthandday")
                                }
                                return this._normalizeFormat(n)
                            }
                            if (e.month) {
                                return "month"
                            }
                            if (e.day) {
                                if (t) {
                                    n.unshift("day")
                                } else {
                                    n.unshift((function(e) {
                                        return r.default.format(e, "dayofweek") + ", " + r.default.format(e, "day")
                                    }))
                                }
                                return this._normalizeFormat(n)
                            }
                            return this._normalizeFormat(n)
                        },
                        getDateFormatByTicks: function(e) {
                            var t, n, i;
                            if (e.length > 1) {
                                for (t = a.default.getDatesDifferences(e[0], e[1]), i = 1; i < e.length - 1; i++) {
                                    n = a.default.getDatesDifferences(e[i], e[i + 1]), t.count < n.count && (t = n)
                                }
                            } else {
                                t = {
                                    year: !0,
                                    month: !0,
                                    day: !0,
                                    hour: e[0].getHours() > 0,
                                    minute: e[0].getMinutes() > 0,
                                    second: e[0].getSeconds() > 0,
                                    millisecond: e[0].getMilliseconds() > 0
                                }
                            }
                            return this.getDateFormatByDifferences(t)
                        },
                        getDateFormatByTickInterval: function(e, t, n) {
                            var o, r = function(e, t, n) {
                                switch (t) {
                                    case "year":
                                    case "quarter":
                                        e.month = n;
                                    case "month":
                                        e.day = n;
                                    case "week":
                                    case "day":
                                        e.hour = n;
                                    case "hour":
                                        e.minute = n;
                                    case "minute":
                                        e.second = n;
                                    case "second":
                                        e.millisecond = n
                                }
                            };
                            n = (0, i.isString)(n) ? n.toLowerCase() : n;
                            var s, c, l, u = a.default.getDatesDifferences(e, t);
                            return e !== t && (s = u, c = e > t ? t : e, !(l = e > t ? e : t).getMilliseconds() && l.getSeconds() ? l.getSeconds() - c.getSeconds() == 1 && (s.millisecond = !0, s.second = !1) : !l.getSeconds() && l.getMinutes() ? l.getMinutes() - c.getMinutes() == 1 && (s.second = !0, s.minute = !1) : !l.getMinutes() && l.getHours() ? l.getHours() - c.getHours() == 1 && (s.minute = !0, s.hour = !1) : !l.getHours() && l.getDate() > 1 ? l.getDate() - c.getDate() == 1 && (s.hour = !0, s.day = !1) : 1 === l.getDate() && l.getMonth() ? l.getMonth() - c.getMonth() == 1 && (s.day = !0, s.month = !1) : !l.getMonth() && l.getFullYear() && l.getFullYear() - c.getFullYear() == 1 && (s.month = !0, s.year = !1)), r(u, a.default.getDateUnitInterval(u), !0), r(u, o = a.default.getDateUnitInterval(n || "second"), !1), u[{
                                week: "day"
                            } [o] || o] = !0, this.getDateFormatByDifferences(u)
                        }
                    });
                    t.default = l, e.exports = t.default, e.exports.default = t.default
                },
            71582:
                /*!********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular.js ***!
                  \********************************************************************/
                function(e, t, n) {
                    n( /*! ./jquery */ 78475), n( /*! ./angular/component_registrator */ 38971), n( /*! ./angular/event_registrator */ 12993), n( /*! ./angular/components */ 11579), n( /*! ./angular/action_executors */ 21298)
                },
            21298:
                /*!*************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/action_executors.js ***!
                  \*************************************************************************************/
                function(e, t, n) {
                    var i = a(n( /*! ../../core/action */ 62414));

                    function a(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    a(n( /*! angular */ 62387)).default && i.default.registerExecutor({
                        ngExpression: {
                            execute: function(e) {
                                "string" == typeof e.action && e.context.$eval(e.action)
                            }
                        }
                    })
                },
            38971:
                /*!******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/component_registrator.js ***!
                  \******************************************************************************************/
                function(e, t, n) {
                    var i = w(n( /*! ../../core/renderer */ 68374)),
                        a = w(n( /*! angular */ 62387)),
                        o = w(n( /*! ../../events/core/events_engine */ 55994)),
                        r = w(n( /*! ../../core/config */ 80209)),
                        s = w(n( /*! ../../core/component_registrator_callbacks */ 5554)),
                        c = w(n( /*! ../../core/class */ 38377)),
                        l = w(n( /*! ../../core/utils/callbacks */ 44504)),
                        u = n( /*! ../../core/utils/type */ 35922),
                        d = n( /*! ../../core/utils/iterator */ 95479),
                        f = n( /*! ../../core/utils/array */ 89386),
                        h = w(n( /*! ../../core/utils/locker */ 88933)),
                        g = w(n( /*! ../../ui/editor/editor */ 96452)),
                        p = n( /*! ./template */ 76165),
                        m = w(n( /*! ./module */ 69155)),
                        _ = w(n( /*! ../../ui/collection/ui.collection_widget.edit */ 11050)),
                        v = n( /*! ../../core/utils/data */ 47617),
                        x = n( /*! ../../core/utils/extend */ 13306),
                        y = n( /*! ../../core/utils/comparator */ 49036),
                        b = n( /*! ../../core/utils/inflector */ 78008);

                    function w(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }

                    function k(e) {
                        return k = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
                            return typeof e
                        } : function(e) {
                            return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                        }, k(e)
                    }
                    var S = ["rendering"],
                        C = "value";
                    if (a.default) {
                        var A = function(e, t) {
                                return t.$root.$$phase ? e(t) : t.$apply((function() {
                                    return e(t)
                                }))
                            },
                            T = c.default.inherit({
                                ctor: function(e) {
                                    this._componentDisposing = (0, l.default)(), this._optionChangedCallbacks = (0, l.default)(), this._ngLocker = new h.default, this._scope = e.scope, this._$element = e.$element, this._$templates = e.$templates, this._componentClass = e.componentClass, this._parse = e.parse, this._compile = e.compile, this._itemAlias = e.itemAlias, this._transcludeFn = e.transcludeFn, this._digestCallbacks = e.dxDigestCallbacks, this._normalizeOptions(e.ngOptions), this._initComponentBindings(), this._initComponent(this._scope), e.ngOptions || this._addOptionsStringWatcher(e.ngOptionsString)
                                },
                                _addOptionsStringWatcher: function(e) {
                                    var t = this,
                                        n = this._scope.$watch(e, (function(e) {
                                            e && (n(), t._normalizeOptions(e), t._initComponentBindings(), t._component.option(t._evalOptions(t._scope)))
                                        }));
                                    this._componentDisposing.add(n)
                                },
                                _normalizeOptions: function(e) {
                                    var t = this;
                                    this._ngOptions = (0, x.extendFromObject)({}, e), e && (!Object.prototype.hasOwnProperty.call(e, "bindingOptions") && e.bindingOptions && (this._ngOptions.bindingOptions = e.bindingOptions), e.bindingOptions && (0, d.each)(e.bindingOptions, (function(e, n) {
                                        "string" === (0, u.type)(n) && (t._ngOptions.bindingOptions[e] = {
                                            dataPath: n
                                        })
                                    })))
                                },
                                _initComponent: function(e) {
                                    this._component = new this._componentClass(this._$element, this._evalOptions(e)), this._component._isHidden = !0, this._handleDigestPhase()
                                },
                                _handleDigestPhase: function() {
                                    var e = this,
                                        t = function() {
                                            e._component.beginUpdate()
                                        },
                                        n = function() {
                                            e._component.endUpdate()
                                        };
                                    this._digestCallbacks.begin.add(t), this._digestCallbacks.end.add(n), this._componentDisposing.add((function() {
                                        e._digestCallbacks.begin.remove(t), e._digestCallbacks.end.remove(n)
                                    }))
                                },
                                _initComponentBindings: function() {
                                    var e = this,
                                        t = {};
                                    this._ngOptions.bindingOptions && ((0, d.each)(this._ngOptions.bindingOptions, (function(n, i) {
                                        var a, o, r = n.search(/\[|\./),
                                            s = r > -1 ? n.substring(0, r) : n,
                                            c = i.dataPath,
                                            l = !0,
                                            u = !1;
                                        void 0 !== i.deep && (u = l = !!i.deep), t[s] || (t[s] = {}), t[s][n] = c;
                                        ! function t() {
                                            var i = Array.isArray(e._scope.$eval(c)) && !u ? "$watchCollection" : "$watch";
                                            a !== i && (o && o(), o = e._scope[i](c, (function(i, a) {
                                                e._ngLocker.locked(n) || (e._ngLocker.obtain(n), e._component.option(n, i), t(), (0, y.equals)(a, i) && e._ngLocker.locked(n) && e._ngLocker.release(n))
                                            }), l), a = i)
                                        }(), e._componentDisposing.add(o)
                                    })), this._optionChangedCallbacks.add((function(n) {
                                        var i = n.name,
                                            a = n.fullName,
                                            o = n.component;
                                        if (e._ngLocker.locked(a)) {
                                            e._ngLocker.release(a)
                                        } else if (t && t[i]) {
                                            var r = e._scope.$root.$$phase,
                                                s = function() {
                                                    e._ngLocker.obtain(a)
                                                };
                                            r ? e._digestCallbacks.begin.add(s) : s(), A((function() {
                                                (0, d.each)(t[i], (function(t, i) {
                                                    if (e._optionsAreLinked(a, t)) {
                                                        var r = o.option(t);
                                                        e._parse(i).assign(e._scope, r);
                                                        var s = e._parse(i)(e._scope);
                                                        s !== r && n.component.option(t, s)
                                                    }
                                                }))
                                            }), e._scope);
                                            var c = function t() {
                                                e._ngLocker.locked(a) && e._ngLocker.release(a), e._digestCallbacks.begin.remove(s), e._digestCallbacks.end.remove(t)
                                            };
                                            r ? e._digestCallbacks.end.addPrioritized(c) : c()
                                        }
                                    })))
                                },
                                _optionsAreNested: function(e, t) {
                                    var n = e[t.length];
                                    return 0 === e.indexOf(t) && ("." === n || "[" === n)
                                },
                                _optionsAreLinked: function(e, t) {
                                    return e === t || (e.length > t.length ? this._optionsAreNested(e, t) : this._optionsAreNested(t, e))
                                },
                                _compilerByTemplate: function(e) {
                                    var t = this,
                                        n = this._getScopeItemsPath();
                                    return function(a) {
                                        var r = (0, i.default)(e).clone(),
                                            s = a.model && a.model.constructor === t._scope.$root.constructor ? a.model : a.noModel ? t._scope : t._createScopeWithData(a);
                                        n && t._synchronizeScopes(s, n, a.index), r.appendTo(a.container), a.noModel || o.default.on(r, "$destroy", (function() {
                                            !s.$parent || s.$destroy()
                                        }));
                                        var c = t._compile(r, t._transcludeFn);
                                        return t._applyAsync((function(e) {
                                            c(e, null, {
                                                parentBoundTranscludeFn: t._transcludeFn
                                            })
                                        }), s), r
                                    }
                                },
                                _applyAsync: function(e, t) {
                                    var n = this;
                                    if (e(t), !t.$root.$$phase && !this._renderingTimer) {
                                        var i = function() {
                                            clearTimeout(n._renderingTimer)
                                        };
                                        this._renderingTimer = setTimeout((function() {
                                            t.$apply(), n._renderingTimer = null, n._componentDisposing.remove(i)
                                        })), this._componentDisposing.add(i)
                                    }
                                },
                                _getScopeItemsPath: function() {
                                    if (this._componentClass.subclassOf(_.default) && this._ngOptions.bindingOptions && this._ngOptions.bindingOptions.items) {
                                        return this._ngOptions.bindingOptions.items.dataPath
                                    }
                                },
                                _createScopeWithData: function(e) {
                                    var t = this._scope.$new();
                                    return this._itemAlias && (t[this._itemAlias] = e.model), (0, u.isDefined)(e.index) && (t.$index = e.index), t
                                },
                                _synchronizeScopes: function(e, t, n) {
                                    this._itemAlias && "object" !== k(e[this._itemAlias]) && this._synchronizeScopeField({
                                        parentScope: this._scope,
                                        childScope: e,
                                        fieldPath: this._itemAlias,
                                        parentPrefix: t,
                                        itemIndex: n
                                    })
                                },
                                _synchronizeScopeField: function(e) {
                                    var t = e.parentScope,
                                        n = e.childScope,
                                        i = e.fieldPath,
                                        a = e.parentPrefix,
                                        o = e.itemIndex,
                                        r = i === this._itemAlias ? "" : "." + i,
                                        s = void 0 !== o,
                                        c = [a];
                                    if (s) {
                                        if (!(0, u.isNumeric)(o)) {
                                            return
                                        }
                                        c.push("[", o, "]")
                                    }
                                    c.push(r);
                                    var l = c.join(""),
                                        d = t.$watch(l, (function(e, t) {
                                            e !== t && (0, v.compileSetter)(i)(n, e)
                                        })),
                                        f = n.$watch(i, (function(e, n) {
                                            if (e !== n) {
                                                if (s && !(0, v.compileGetter)(a)(t)[o]) {
                                                    return void f()
                                                }(0, v.compileSetter)(l)(t, e)
                                            }
                                        }));
                                    this._componentDisposing.add([d, f])
                                },
                                _evalOptions: function(e) {
                                    var t = this,
                                        n = (0, x.extendFromObject)({}, this._ngOptions);
                                    return delete n.bindingOptions, this._ngOptions.bindingOptions && (0, d.each)(this._ngOptions.bindingOptions, (function(t, i) {
                                        n[t] = e.$eval(i.dataPath)
                                    })), n._optionChangedCallbacks = this._optionChangedCallbacks, n._disposingCallbacks = this._componentDisposing, n.onActionCreated = function(t, n, i) {
                                        if (i && (0, f.inArray)(i.category, S) > -1) {
                                            return n
                                        }
                                        return function() {
                                            var t = this,
                                                i = arguments;
                                            return e && e.$root && !e.$root.$$phase ? A((function() {
                                                return n.apply(t, i)
                                            }), e) : n.apply(this, i)
                                        }
                                    }, n.beforeActionExecute = n.onActionCreated, n.nestedComponentOptions = function(e) {
                                        return {
                                            templatesRenderAsynchronously: e.option("templatesRenderAsynchronously"),
                                            forceApplyBindings: e.option("forceApplyBindings"),
                                            modelByElement: e.option("modelByElement"),
                                            onActionCreated: e.option("onActionCreated"),
                                            beforeActionExecute: e.option("beforeActionExecute"),
                                            nestedComponentOptions: e.option("nestedComponentOptions")
                                        }
                                    }, n.templatesRenderAsynchronously = !0, (0, r.default)().wrapActionsBeforeExecute && (n.forceApplyBindings = function() {
                                        A((function() {}), e)
                                    }), n.integrationOptions = {
                                        createTemplate: function(e) {
                                            return new p.NgTemplate(e, t._compilerByTemplate.bind(t))
                                        },
                                        watchMethod: function(n, i, a) {
                                            var o, s = (a = a || {}).skipImmediate,
                                                c = e.$watch((function() {
                                                    var e = n();
                                                    return e instanceof Date && (e = e.valueOf()), e
                                                }), (function(e) {
                                                    var t = o === e;
                                                    !s && (!t || t && a.deep) && i(e), s = !1
                                                }), a.deep);
                                            return s || (o = n(), i(o)), (0, r.default)().wrapActionsBeforeExecute && t._applyAsync((function() {}), e), c
                                        },
                                        templates: {
                                            "dx-polymorph-widget": {
                                                render: function(e) {
                                                    var n = e.model.widget;
                                                    if (n) {
                                                        var a = (0, i.default)("<div>").attr((0, b.dasherize)(n), "options").get(0),
                                                            o = t._scope.$new();
                                                        o.options = e.model.options, e.container.append(a), t._compile(a)(o)
                                                    }
                                                }
                                            }
                                        }
                                    }, n.modelByElement = function() {
                                        return e
                                    }, n
                                }
                            });
                        T = T.inherit({
                            ctor: function(e) {
                                this._componentName = e.componentName, this._ngModel = e.ngModel, this._ngModelController = e.ngModelController, this.callBase.apply(this, arguments)
                            },
                            _isNgModelRequired: function() {
                                return g.default.isEditor(this._componentClass.prototype) && this._ngModel
                            },
                            _initComponentBindings: function() {
                                this.callBase.apply(this, arguments), this._initNgModelBinding()
                            },
                            _initNgModelBinding: function() {
                                var e = this;
                                if (this._isNgModelRequired()) {
                                    var t = this._scope.$watch(this._ngModel, (function(t, n) {
                                        e._ngLocker.locked(C) || t !== n && e._component.option(C, t)
                                    }));
                                    this._optionChangedCallbacks.add((function(t) {
                                        e._ngLocker.obtain(C);
                                        try {
                                            if (t.name !== C) {
                                                return
                                            }
                                            e._ngModelController.$setViewValue(t.value)
                                        } finally {
                                            e._ngLocker.locked(C) && e._ngLocker.release(C)
                                        }
                                    })), this._componentDisposing.add(t)
                                }
                            },
                            _evalOptions: function() {
                                if (!this._isNgModelRequired()) {
                                    return this.callBase.apply(this, arguments)
                                }
                                var e = this.callBase.apply(this, arguments);
                                return e.value = this._parse(this._ngModel)(this._scope), e
                            }
                        });
                        var E = {},
                            O = function(e) {
                                var t = "dxValidator" !== e ? 1 : 10;
                                m.default.directive(e, ["$compile", "$parse", "dxDigestCallbacks", function(n, i, a) {
                                    return {
                                        restrict: "A",
                                        require: "^?ngModel",
                                        priority: t,
                                        compile: function(t) {
                                            var o = E[e],
                                                r = (o.prototype._useTemplates ? o.prototype._useTemplates() : function e(t, n) {
                                                    if (!Object.prototype.hasOwnProperty.bind(t)("parent") && t.parent) {
                                                        var i = Object.getPrototypeOf(t);
                                                        return i.prototype[n] ? function() {
                                                            return i.prototype[n]()
                                                        } : e(i, n)
                                                    }
                                                    var a = t.parent.prototype[n];
                                                    return a ? function() {
                                                        return a()
                                                    } : a && t.parent.subclassOf ? e(t.parent, n) : function() {}
                                                }(o, "_useTemplates")()) ? t.contents().detach() : null;
                                            return function(t, s, c, l, u) {
                                                s.append(r), A((function() {
                                                    new T({
                                                        componentClass: o,
                                                        componentName: e,
                                                        compile: n,
                                                        parse: i,
                                                        $element: s,
                                                        scope: t,
                                                        ngOptionsString: c[e],
                                                        ngOptions: c[e] ? t.$eval(c[e]) : {},
                                                        ngModel: c.ngModel,
                                                        ngModelController: l,
                                                        transcludeFn: u,
                                                        itemAlias: c.dxItemAlias,
                                                        dxDigestCallbacks: a
                                                    })
                                                }), t)
                                            }
                                        }
                                    }
                                }])
                            };
                        s.default.add((function(e, t) {
                            E[e] || O(e), E[e] = t
                        }))
                    }
                },
            11579:
                /*!*******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/components.js ***!
                  \*******************************************************************************/
                function(e, t, n) {
                    var i = o(n( /*! ../../core/utils/callbacks */ 44504)),
                        a = o(n( /*! ./module */ 69155));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    o(n( /*! angular */ 62387)).default && a.default.service("dxDigestCallbacks", ["$rootScope", function(e) {
                        var t = (0, i.default)(),
                            n = (0, i.default)(),
                            a = (0, i.default)(),
                            o = !1;
                        return e.$watch((function() {
                            o || (o = !0, t.fire(), e.$$postDigest((function() {
                                o = !1, n.fire(), a.fire()
                            })))
                        })), {
                            begin: {
                                add: function(e) {
                                    o && e(), t.add(e)
                                },
                                remove: t.remove.bind(t)
                            },
                            end: {
                                add: a.add.bind(a),
                                addPrioritized: n.add.bind(n),
                                remove: a.remove.bind(a)
                            }
                        }
                    }])
                },
            12993:
                /*!**************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/event_registrator.js ***!
                  \**************************************************************************************/
                function(e, t, n) {
                    var i = r(n( /*! ../../events/core/event_registrator_callbacks */ 94553)),
                        a = r(n( /*! ../../events/core/events_engine */ 55994)),
                        o = r(n( /*! ./module */ 69155));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    r(n( /*! angular */ 62387)).default && i.default.add((function(e) {
                        var t = e.slice(0, 2) + e.charAt(2).toUpperCase() + e.slice(3);
                        o.default.directive(t, ["$parse", function(n) {
                            return function(i, o, r) {
                                var s, c = r[t].trim(),
                                    l = {};
                                "{" === c.charAt(0) ? (l = i.$eval(c), s = n(l.execute)) : s = n(r[t]), a.default.on(o, e, l, (function(e) {
                                    i.$apply((function() {
                                        s(i, {
                                            $event: e
                                        })
                                    }))
                                }))
                            }
                        }])
                    }))
                },
            69155:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/module.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    t.default = void 0;
                    var i, a = (i = n( /*! angular */ 62387)) && i.__esModule ? i : {
                        default: i
                    };
                    var o = {};
                    a.default && (o = a.default.module("dx", []));
                    var r = o;
                    t.default = r, e.exports = t.default, e.exports.default = t.default
                },
            76165:
                /*!*****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/angular/template.js ***!
                  \*****************************************************************************/
                function(e, t, n) {
                    t.NgTemplate = void 0;
                    var i, a = (i = n( /*! ../../core/renderer */ 68374)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../../core/templates/template_base */ 81033),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = n( /*! ../../core/utils/dom */ 3532);

                    function c(e, t) {
                        return c = Object.setPrototypeOf || function(e, t) {
                            return e.__proto__ = t, e
                        }, c(e, t)
                    }
                    var l = function(e) {
                        var t, n;

                        function i(t, n) {
                            var i;
                            return (i = e.call(this) || this)._element = t, i._compiledTemplate = n((0, s.normalizeTemplateElement)(i._element)), i
                        }
                        n = e, (t = i).prototype = Object.create(n.prototype), t.prototype.constructor = t, c(t, n);
                        var o = i.prototype;
                        return o._renderCore = function(e) {
                            var t = this._compiledTemplate;
                            return (0, r.isFunction)(t) ? t(e) : t
                        }, o.source = function() {
                            return (0, a.default)(this._element).clone()
                        }, i
                    }(o.TemplateBase);
                    t.NgTemplate = l
                },
            78475:
                /*!*******************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery.js ***!
                  \*******************************************************************/
                function(e, t, n) {
                    var i = s(n( /*! jquery */ 96073)),
                        a = n( /*! ../core/utils/version */ 58020),
                        o = s(n( /*! ../core/utils/error */ 95640)),
                        r = s(n( /*! ./jquery/use_jquery */ 72722));

                    function s(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if (n( /*! ./jquery/renderer */ 17394), n( /*! ./jquery/hooks */ 59228), n( /*! ./jquery/deferred */ 66809), n( /*! ./jquery/hold_ready */ 32185), n( /*! ./jquery/events */ 711), n( /*! ./jquery/easing */ 27387), n( /*! ./jquery/element_data */ 95063), n( /*! ./jquery/element */ 63200), n( /*! ./jquery/component_registrator */ 87481), n( /*! ./jquery/ajax */ 30829), (0, r.default)() && (0, a.compare)(i.default.fn.jquery, [1, 10]) < 0) {
                        throw o.default.Error("E0012")
                    }
                },
            30829:
                /*!************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/ajax.js ***!
                  \************************************************************************/
                function(e, t, n) {
                    var i = o(n( /*! jquery */ 96073)),
                        a = o(n( /*! ../../core/utils/ajax */ 37208));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }(0, o(n( /*! ./use_jquery */ 72722)).default)() && a.default.inject({
                        sendRequest: function(e) {
                            return e.responseType || e.upload ? this.callBase.apply(this, [e]) : i.default.ajax(e)
                        }
                    })
                },
            87481:
                /*!*****************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/component_registrator.js ***!
                  \*****************************************************************************************/
                function(e, t, n) {
                    var i = r(n( /*! jquery */ 96073)),
                        a = r(n( /*! ../../core/component_registrator_callbacks */ 5554)),
                        o = r(n( /*! ../../core/errors */ 17381));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if (i.default) {
                        a.default.add((function(e, t) {
                            i.default.fn[e] = function(n) {
                                var i, a = "string" == typeof n;
                                if (a) {
                                    var r = n,
                                        s = [].slice.call(arguments).slice(1);
                                    this.each((function() {
                                        var n = t.getInstance(this);
                                        if (!n) {
                                            throw o.default.Error("E0009", e)
                                        }
                                        var a = n[r].apply(n, s);
                                        void 0 === i && (i = a)
                                    }))
                                } else {
                                    this.each((function() {
                                        var e = t.getInstance(this);
                                        e ? e.option(n) : new t(this, n)
                                    })), i = this
                                }
                                return i
                            }
                        }))
                    }
                },
            66809:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/deferred.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    var i = r(n( /*! jquery */ 96073)),
                        a = n( /*! ../../core/utils/deferred */ 62754),
                        o = n( /*! ../../core/utils/version */ 58020);

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if ((0, r(n( /*! ./use_jquery */ 72722)).default)()) {
                        var s = i.default.Deferred,
                            c = {
                                Deferred: s
                            };
                        c.when = (0, o.compare)(i.default.fn.jquery, [3]) < 0 ? i.default.when : function(e) {
                            return 0 === arguments.length ? (new s).resolve() : 1 === arguments.length ? e && e.then ? e : (new s).resolve(e) : i.default.when.apply(i.default, arguments)
                        }, (0, a.setStrategy)(c)
                    }
                },
            27387:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/easing.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    var i, a = (i = n( /*! jquery */ 96073)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../../animation/easing */ 23908);
                    a.default && (0, o.setEasing)(a.default.easing)
                },
            63200:
                /*!***************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/element.js ***!
                  \***************************************************************************/
                function(e, t, n) {
                    var i, a = n( /*! ../../core/element */ 6415);
                    (0, ((i = n( /*! ./use_jquery */ 72722)) && i.__esModule ? i : {
                        default: i
                    }).default)() && (0, a.setPublicElementWrapper)((function(e) {
                        return e
                    }))
                },
            95063:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/element_data.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    var i = o(n( /*! jquery */ 96073)),
                        a = n( /*! ../../core/element_data */ 97906);

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }(0, o(n( /*! ./use_jquery */ 72722)).default)() && (0, a.setDataStrategy)(i.default)
                },
            711:
                /*!**************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/events.js ***!
                  \**************************************************************************/
                function(e, t, n) {
                    var i = c(n( /*! jquery */ 96073)),
                        a = c(n( /*! ../../events/core/events_engine */ 55994)),
                        o = c(n( /*! ./use_jquery */ 72722)),
                        r = c(n( /*! ../../events/core/event_registrator_callbacks */ 94553)),
                        s = c(n( /*! ../../core/dom_adapter */ 73349));

                    function c(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }(0, o.default)() && (r.default.add((function(e, t) {
                        i.default.event.special[e] = t
                    })), a.default.passiveEventHandlersSupported() && a.default.forcePassiveFalseEventNames.forEach((function(e) {
                        i.default.event.special[e] = {
                            setup: function(t, n, i) {
                                s.default.listen(this, e, i, {
                                    passive: !1
                                })
                            }
                        }
                    })), a.default.set({
                        on: function(e) {
                            (0, i.default)(e).on.apply((0, i.default)(e), Array.prototype.slice.call(arguments, 1))
                        },
                        one: function(e) {
                            (0, i.default)(e).one.apply((0, i.default)(e), Array.prototype.slice.call(arguments, 1))
                        },
                        off: function(e) {
                            (0, i.default)(e).off.apply((0, i.default)(e), Array.prototype.slice.call(arguments, 1))
                        },
                        trigger: function(e) {
                            (0, i.default)(e).trigger.apply((0, i.default)(e), Array.prototype.slice.call(arguments, 1))
                        },
                        triggerHandler: function(e) {
                            (0, i.default)(e).triggerHandler.apply((0, i.default)(e), Array.prototype.slice.call(arguments, 1))
                        },
                        Event: i.default.Event
                    }))
                },
            32185:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/hold_ready.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    var i = r(n( /*! jquery */ 96073)),
                        a = n( /*! ../../ui/themes_callback */ 89729),
                        o = r(n( /*! ../../core/utils/ready_callbacks */ 24311));

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if (i.default && !a.themeReadyCallback.fired()) {
                        var s = i.default.holdReady || i.default.fn.holdReady;
                        s(!0), a.themeReadyCallback.add((function() {
                            o.default.add((function() {
                                s(!1)
                            }))
                        }))
                    }
                },
            59228:
                /*!*************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/hooks.js ***!
                  \*************************************************************************/
                function(e, t, n) {
                    var i = d(n( /*! jquery */ 96073)),
                        a = d(n( /*! ./use_jquery */ 72722)),
                        o = n( /*! ../../core/utils/version */ 58020),
                        r = n( /*! ../../core/utils/iterator */ 95479),
                        s = n( /*! ../../core/utils/type */ 35922),
                        c = n( /*! ../../events/utils/index */ 39611),
                        l = d(n( /*! ../../events/core/event_registrator */ 85788)),
                        u = d(n( /*! ../../events/core/hook_touch_props */ 2418));

                    function d(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if ((0, a.default)()) {
                        if ((0, o.compare)(i.default.fn.jquery, [3]) < 0) {
                            var f = {
                                2: "touch",
                                3: "pen",
                                4: "mouse"
                            };
                            (0, r.each)(["MSPointerDown", "MSPointerMove", "MSPointerUp", "MSPointerCancel", "MSPointerOver", "MSPointerOut", "mouseenter", "mouseleave", "pointerdown", "pointermove", "pointerup", "pointercancel", "pointerover", "pointerout", "pointerenter", "pointerleave"], (function() {
                                i.default.event.fixHooks[this] = {
                                    filter: function(e, t) {
                                        var n = t.pointerType;
                                        return (0, s.isNumeric)(n) && (e.pointerType = f[n]), e
                                    },
                                    props: i.default.event.mouseHooks.props.concat(["pointerId", "pointerType", "originalTarget", "width", "height", "pressure", "result", "tiltX", "charCode", "tiltY", "detail", "isPrimary", "prevValue"])
                                }
                            })), (0, r.each)(["touchstart", "touchmove", "touchend", "touchcancel"], (function() {
                                i.default.event.fixHooks[this] = {
                                    filter: function(e, t) {
                                        return (0, u.default)((function(n, i) {
                                            e[n] = i(t)
                                        })), e
                                    },
                                    props: i.default.event.mouseHooks.props.concat(["touches", "changedTouches", "targetTouches", "detail", "result", "originalTarget", "charCode", "prevValue"])
                                }
                            })), i.default.event.fixHooks.wheel = i.default.event.mouseHooks;
                            var h = {
                                props: i.default.event.mouseHooks.props.concat(["pointerType", "pointerId", "pointers"])
                            };
                            l.default.callbacks.add((function(e) {
                                i.default.event.fixHooks[e] = h
                            }));
                            (0, c.setEventFixMethod)((function(e, t) {
                                for (var n = i.default.event.fixHooks[t.type] || i.default.event.mouseHooks, a = n.props ? i.default.event.props.concat(n.props) : i.default.event.props, o = a.length; o--;) {
                                    var r = a[o];
                                    e[r] = t[r]
                                }
                                return n.filter ? n.filter(e, t) : e
                            }))
                        } else {
                            (0, u.default)((function(e, t) {
                                i.default.event.addProp(e, t)
                            }))
                        }
                    }
                },
            17394:
                /*!****************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/renderer.js ***!
                  \****************************************************************************/
                function(e, t, n) {
                    var i = o(n( /*! jquery */ 96073)),
                        a = o(n( /*! ../../core/renderer_base */ 82981));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }(0, o(n( /*! ./use_jquery */ 72722)).default)() && a.default.set(i.default)
                },
            72722:
                /*!******************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/jquery/use_jquery.js ***!
                  \******************************************************************************/
                function(e, t, n) {
                    t.default = function() {
                        return i.default && (0, a.default)().useJQuery
                    };
                    var i = o(n( /*! jquery */ 96073)),
                        a = o(n( /*! ../../core/config */ 80209));

                    function o(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    var r = (0, a.default)().useJQuery;
                    i.default && !1 !== r && (0, a.default)({
                        useJQuery: !0
                    }), e.exports = t.default, e.exports.default = t.default
                },
            49281:
                /*!*********************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/knockout.js ***!
                  \*********************************************************************/
                function(e, t, n) {
                    var i = r(n( /*! knockout */ 76130)),
                        a = r(n( /*! ../core/errors */ 17381)),
                        o = n( /*! ../core/utils/version */ 58020);

                    function r(e) {
                        return e && e.__esModule ? e : {
                            default: e
                        }
                    }
                    if (n( /*! ./knockout/component_registrator */ 89135), n( /*! ./knockout/event_registrator */ 70883), n( /*! ./knockout/components */ 89620), n( /*! ./knockout/validation */ 24935), n( /*! ./knockout/variable_wrapper_utils */ 74942), n( /*! ./knockout/clean_node */ 27521), n( /*! ./knockout/clean_node_old */ 61823), i.default && (0, o.compare)(i.default.version, [2, 3]) < 0) {
                        throw a.default.Error("E0013")
                    }
                },
            27521:
                /*!********************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/knockout/clean_node.js ***!
                  \********************************************************************************/
                function(e, t, n) {
                    var i, a = n( /*! ../../core/element_data */ 97906),
                        o = (i = n( /*! knockout */ 76130)) && i.__esModule ? i : {
                            default: i
                        },
                        r = n( /*! ../../core/utils/version */ 58020);
                    if (o.default) {
                        var s = o.default.utils.domNodeDisposal.cleanExternalData;
                        (0, a.afterCleanData)((function(e) {
                            var t;
                            for (t = 0; t < e.length; t++) {
                                e[t].cleanedByJquery = !0
                            }
                            for (t = 0; t < e.length; t++) {
                                e[t].cleanedByKo || o.default.cleanNode(e[t]), delete e[t].cleanedByKo
                            }
                            for (t = 0; t < e.length; t++) {
                                delete e[t].cleanedByJquery
                            }
                        })), o.default.utils.domNodeDisposal.cleanExternalData = function(e) {
                            e.cleanedByKo = !0, e.cleanedByJquery || (0, a.cleanData)([e])
                        }, a.strategyChanging.add((function(e) {
                            !!e.fn && (0, r.compare)(e.fn.jquery, [2, 0]) < 0 && ((0, a.afterCleanData)((function() {})), o.default.utils.domNodeDisposal.cleanExternalData = s)
                        }))
                    }
                },
            61823:
                /*!************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/knockout/clean_node_old.js ***!
                  \************************************************************************************/
                function(e, t, n) {
                    var i, a = (i = n( /*! knockout */ 76130)) && i.__esModule ? i : {
                            default: i
                        },
                        o = n( /*! ../../core/utils/version */ 58020),
                        r = n( /*! ../../core/element_data */ 97906);
                    if (a.default) {
                        r.strategyChanging.add((function(e) {
                            !!e.fn && (0, o.compare)(e.fn.jquery, [2, 0]) < 0 && function(e) {
                                var t = function(e, t) {
                                        var n = function() {
                                            a.default.cleanNode(this)
                                        };
                                        t ? e.each(n) : e.find("*").each(n)
                                    },
                                    n = e.fn.empty;
                                e.fn.empty = function() {
                                    return t(this, !1), n.apply(this, arguments)
                                };
                                var i = e.fn.remove;
                                e.fn.remove = function(e, n) {
                                    if (!n) {
                                        var a = this;
                                        e && (a = a.filter(e)), t(a, !0)
                                    }
                                    return i.call(this, e, n)
                                };
                                var o = e.fn.html;
                                e.fn.html = function(e) {
                                    return "string" == typeof e && t(this, !1), o.apply(this, arguments)
                                };
                                var r = e.fn.replaceWith;
                                e.fn.replaceWith = function() {
                                    var e = r.apply(this, arguments);
                                    return this.parent().length || t(this, !0), e
                                }
                            }(e)
                        }))
                    }
                },
            89135:
                /*!*******************************************************************************************!*\
                  !*** ./artifacts/transpiled-renovation-npm/integration/knockout/component_registrator.js ***!
                  \*******************************************************************************************/
                function(e, t, n) {
                    var i = _(n( /*! ../../core/renderer */ 68374)),
                        a = _(n( /*! knockout */ 76130)),
                        o = _(n( /*! ../../core/utils/callbacks */ 44504)),
                        r = n( /*! ../../core/utils/type */ 35922),
                        s = _(n( /*! ../../core/component_registrator_callbacks */ 5554)),
                        c = _(n( /*! ../../ui/widget/ui.widget */ 14390)),
                        l = _(n( /*! ../../viz/core/base_widget */ 59063)),
                       