/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 20.2.3
 * Build date: Tue Oct 20 2020
 *
 * Copyright (c) 2012 - 2020 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 1006)
}([
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/extend.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.extend = exports.extendFromObject = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (Object.prototype.hasOwnProperty.call(source, prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        exports.extendFromObject = extendFromObject;
        var extend = function extend(target) {
            target = target || {};
            var i = 1;
            var deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var targetValue = target[key];
                    var sourceValue = source[key];
                    var sourceValueIsArray = false;
                    var clone = void 0;
                    if ("__proto__" === key || target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && ((0, _type.isPlainObject)(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && (0, _type.isPlainObject)(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/type.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.type = exports.isDeferred = exports.isPromise = exports.isRenderer = exports.isWindow = exports.isPrimitive = exports.isPlainObject = exports.isEmptyObject = exports.isObject = exports.isNumeric = exports.isString = exports.isFunction = exports.isDefined = exports.isDate = exports.isExponential = exports.isBoolean = void 0;

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === _typeof(object) ? types[typeOfObject] || "object" : _typeof(object)
        };
        exports.type = type;
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        exports.isBoolean = isBoolean;
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        exports.isExponential = isExponential;
        var isDate = function(object) {
            return "date" === type(object)
        };
        exports.isDate = isDate;
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        exports.isDefined = isDefined;
        var isFunction = function(object) {
            return "function" === typeof object
        };
        exports.isFunction = isFunction;
        var isString = function(object) {
            return "string" === typeof object
        };
        exports.isString = isString;
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        exports.isNumeric = isNumeric;
        var isObject = function(object) {
            return "object" === type(object)
        };
        exports.isObject = isObject;
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        exports.isEmptyObject = isEmptyObject;
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object);
            var ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        exports.isPlainObject = isPlainObject;
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        exports.isPrimitive = isPrimitive;
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        exports.isWindow = isWindow;
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        exports.isRenderer = isRenderer;
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        exports.isPromise = isPromise;
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isDeferred = isDeferred
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/core/renderer.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer_base = _interopRequireDefault(__webpack_require__( /*! ./renderer_base */ 236));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _renderer_base.default.get();
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/iterator.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.reverseEach = exports.each = exports.map = void 0;
        var map = function(values, callback) {
            if (Array.isArray(values)) {
                return values.map(callback)
            }
            var result = [];
            for (var key in values) {
                result.push(callback(values[key], key))
            }
            return result
        };
        exports.map = map;
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        exports.each = each;
        var reverseEach = function(array, callback) {
            if (!array || !("length" in array) || 0 === array.length) {
                return
            }
            for (var i = array.length - 1; i >= 0; i--) {
                if (false === callback.call(array[i], i, array[i])) {
                    break
                }
            }
        };
        exports.reverseEach = reverseEach
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/common.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.equalByValue = exports.grep = exports.asyncNoop = exports.noop = exports.applyServerDecimalSeparator = exports.escapeRegExp = exports.getKeyHash = exports.pairToObject = exports.denormalizeKey = exports.normalizeKey = exports.splitPair = exports.findBestMatches = exports.deferUpdater = exports.deferRenderer = exports.deferUpdate = exports.deferRender = exports.executeAsync = exports.ensureDefined = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../guid */ 36));
        var _deferred = __webpack_require__( /*! ../utils/deferred */ 6);
        var _data = __webpack_require__( /*! ./data */ 20);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _type = __webpack_require__( /*! ./type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ensureDefined = function(value, defaultValue) {
            return (0, _type.isDefined)(value) ? value : defaultValue
        };
        exports.ensureDefined = ensureDefined;
        var executeAsync = function(action, context) {
            var deferred = new _deferred.Deferred;
            var normalizedContext = context || this;
            var task = {
                promise: deferred.promise(),
                abort: function() {
                    clearTimeout(timerId);
                    deferred.rejectWith(normalizedContext)
                }
            };
            var callback = function() {
                var result = action.call(normalizedContext);
                if (result && result.done && (0, _type.isFunction)(result.done)) {
                    result.done(function() {
                        deferred.resolveWith(normalizedContext)
                    })
                } else {
                    deferred.resolveWith(normalizedContext)
                }
            };
            var timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        exports.executeAsync = executeAsync;
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new _deferred.Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName;
                var currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result || (0, _deferred.when)()
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        exports.deferRender = deferRender;
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        exports.deferUpdate = deferUpdate;
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        exports.deferRenderer = deferRenderer;
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        exports.deferUpdater = deferUpdater;
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [];
            var maxMatchCount = 0;
            (0, _iterator.each)(items, function(index, itemSrc) {
                var matchCount = 0;
                var item = mapFn ? mapFn(itemSrc) : itemSrc;
                (0, _iterator.each)(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        exports.findBestMatches = findBestMatches;
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                (0, _iterator.each)(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            var _raw$x, _raw$y;
            switch ((0, _type.type)(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [null !== (_raw$x = raw.x) && void 0 !== _raw$x ? _raw$x : raw.h, null !== (_raw$y = raw.y) && void 0 !== _raw$y ? _raw$y : raw.v];
                case "number":
                    return [raw];
                case "array":
                    return raw;
                default:
                    return null
            }
        };
        exports.splitPair = splitPair;
        var normalizeKey = function(id) {
            var key = (0, _type.isString)(id) ? id : id.toString();
            var arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && (0, _iterator.each)(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        exports.normalizeKey = normalizeKey;
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        exports.denormalizeKey = denormalizeKey;
        var pairToObject = function(raw, preventRound) {
            var pair = splitPair(raw);
            var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
            var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        exports.pairToObject = pairToObject;
        var getKeyHash = function(key) {
            if (key instanceof _guid.default) {
                return key.toString()
            } else {
                if ((0, _type.isObject)(key) || Array.isArray(key)) {
                    try {
                        var keyHash = JSON.stringify(key);
                        return "{}" === keyHash ? key : keyHash
                    } catch (e) {
                        return key
                    }
                }
            }
            return key
        };
        exports.getKeyHash = getKeyHash;
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        exports.escapeRegExp = escapeRegExp;
        var applyServerDecimalSeparator = function(value) {
            var separator = (0, _config.default)().serverDecimalSeparator;
            if ((0, _type.isDefined)(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        var noop = function() {};
        exports.noop = noop;
        var asyncNoop = function() {
            return (new _deferred.Deferred).resolve().promise()
        };
        exports.asyncNoop = asyncNoop;
        var grep = function(elements, checkFunction, invert) {
            var result = [];
            var check;
            var expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        exports.grep = grep;
        var arraysEqualByValue = function(array1, array2, depth) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], depth + 1)) {
                    return false
                }
            }
            return true
        };
        var objectsEqualByValue = function(object1, object2, depth, strict) {
            for (var propertyName in object1) {
                if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], depth + 1, strict)) {
                    return false
                }
            }
            for (var _propertyName in object2) {
                if (!(_propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var maxEqualityDepth = 3;
        var equalByValue = function(object1, object2) {
            var depth = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0;
            var strict = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : true;
            object1 = (0, _data.toComparable)(object1, true);
            object2 = (0, _data.toComparable)(object2, true);
            var comparisonResult = strict ? object1 === object2 : object1 == object2;
            if (comparisonResult || depth >= maxEqualityDepth) {
                return true
            }
            if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                return objectsEqualByValue(object1, object2, depth, strict)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return arraysEqualByValue(object1, object2, depth)
                }
            }
            return false
        };
        exports.equalByValue = equalByValue
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/events_engine.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _event_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./event_registrator_callbacks */ 131));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/dependency_injector */ 59));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 25));
        var _weak_map = _interopRequireDefault(__webpack_require__( /*! ../../core/polyfills/weak_map */ 198));
        var _hook_touch_props = _interopRequireDefault(__webpack_require__( /*! ../../events/core/hook_touch_props */ 237));
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var window = (0, _window.getWindow)();
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focus", "load"];
        var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel", "touchstart"];

        function matchesSafe(target, selector) {
            return !(0, _type.isWindow)(target) && "#document" !== target.nodeName && _dom_adapter.default.elementMatches(target, selector)
        }
        var elementDataMap = new _weak_map.default;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            _event_registrator_callbacks.default.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var eventsEngine = (0, _dependency_injector.default)({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers((0, _extend.extend)(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || (0, _type.isWindow)(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });

        function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (_dom_adapter.default.isNode(element) || (0, _type.isWindow)(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!(0, _type.isString)(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw _errors.default.Error("E0025")
                }
            }
        }

        function getHandler(method) {
            return function() {
                applyForEach(arguments, method)
            }
        }

        function detectPassiveEventHandlersSupport() {
            var isSupported = false;
            try {
                var options = Object.defineProperty({}, "passive", {
                    get: function() {
                        isSupported = true;
                        return true
                    }
                });
                window.addEventListener("test", null, options)
            } catch (e) {}
            return isSupported
        }
        var passiveEventHandlersSupported = (0, _call_once.default)(detectPassiveEventHandlersSupport);
        var contains = function contains(container, element) {
            if ((0, _type.isWindow)(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };

        function getHandlersController(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var handlerArgs = [e];
                        var target = e.currentTarget;
                        var relatedTarget = e.relatedTarget;
                        var secondaryTargetIsInside;
                        var result;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || contains(target, relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            e.currentTarget = e.delegateTarget || e.target;
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = _dom_adapter.default.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        }

        function getNativeHandler(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        }

        function isSubset(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        }

        function normalizeOnArguments(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        }

        function normalizeOffArguments(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        }

        function normalizeTriggerArguments(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        }

        function normalizeEventArguments(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        }

        function iterate(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === _typeof(eventName)) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        }

        function callNativeMethod(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if ((0, _type.isFunction)(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        }

        function calculateWhich(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        }

        function initEvent(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        }
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            (0, _extend.extend)(that, src);
            if (src instanceof eventsEngine.Event || (0, _window.hasWindow)() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                (0, _extend.extend)(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }(0, _extend.extend)(that, config);
            that.guid = ++guid
        }));

        function addProperty(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        }(0, _hook_touch_props.default)(addProperty);
        var beforeSetStrategy = (0, _callbacks.default)();
        var afterSetStrategy = (0, _callbacks.default)();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
        eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
        var _default = eventsEngine;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/deferred.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.fromPromise = fromPromise;
        exports.setStrategy = setStrategy;
        exports.Deferred = Deferred;
        exports.when = when;
        var _type = __webpack_require__( /*! ../utils/type */ 1);
        var _extend = __webpack_require__( /*! ../utils/extend */ 0);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../utils/callbacks */ 27));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _DeferredObj = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new _callbacks.default;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _DeferredObj;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if ((0, _type.isDeferred)(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if ((0, _type.isPromise)(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, (0, _type.isDefined)(callbackResult) ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? (0, _extend.extend)(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _DeferredObj.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });

        function fromPromise(promise, context) {
            if ((0, _type.isDeferred)(promise)) {
                return promise
            } else {
                if ((0, _type.isPromise)(promise)) {
                    var d = new _DeferredObj;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _DeferredObj).resolveWith(context, [promise])
        }
        var whenFunc = function() {
            if (1 === arguments.length) {
                return fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments);
            var contexts = [];
            var resolvedCount = 0;
            var deferred = new _DeferredObj;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if ((0, _type.isDeferred)(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };

        function setStrategy(value) {
            _DeferredObj = value.Deferred;
            whenFunc = value.when
        }

        function Deferred() {
            return new _DeferredObj
        }

        function when() {
            return whenFunc.apply(this, arguments)
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/window.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getNavigator = exports.getCurrentScreenFactor = exports.defaultScreenFactorFunc = exports.hasProperty = exports.getWindow = exports.hasWindow = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var hasWindow = function() {
            return "undefined" !== typeof window
        };
        exports.hasWindow = hasWindow;
        var windowObject = hasWindow() && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        var getWindow = function() {
            return windowObject
        };
        exports.getWindow = getWindow;
        var hasProperty = function(prop) {
            return hasWindow() && prop in windowObject
        };
        exports.hasProperty = hasProperty;
        var defaultScreenFactorFunc = function(width) {
            if (width < 768) {
                return "xs"
            } else {
                if (width < 992) {
                    return "sm"
                } else {
                    if (width < 1200) {
                        return "md"
                    } else {
                        return "lg"
                    }
                }
            }
        };
        exports.defaultScreenFactorFunc = defaultScreenFactorFunc;
        var getCurrentScreenFactor = function(screenFactorCallback) {
            var screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
            var windowWidth = _dom_adapter.default.getDocumentElement().clientWidth;
            return screenFactorFunc(windowWidth)
        };
        exports.getCurrentScreenFactor = getCurrentScreenFactor;
        var getNavigator = function() {
            return hasWindow() ? windowObject.navigator : {
                userAgent: ""
            }
        };
        exports.getNavigator = getNavigator
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/events/utils/index.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.addNamespace = exports.getChar = exports.normalizeKeyName = exports.fireEvent = exports.createEvent = exports.setEventFixMethod = exports.needSkipEvent = exports.stopEventsSkipping = exports.forceSkipEvents = exports.hasTouches = exports.eventDelta = exports.eventData = exports.isFakeClickEvent = exports.isKeyboardEvent = exports.isTouchEvent = exports.isDxMouseWheelEvent = exports.isMouseEvent = exports.isPointerEvent = exports.eventSource = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _add_namespace = _interopRequireDefault(__webpack_require__( /*! ./add_namespace */ 520));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../core/events_engine */ 5));
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ../../ui/widget/selectors */ 71);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var KEY_MAP = {
            backspace: "backspace",
            tab: "tab",
            enter: "enter",
            escape: "escape",
            pageup: "pageUp",
            pagedown: "pageDown",
            end: "end",
            home: "home",
            arrowleft: "leftArrow",
            arrowup: "upArrow",
            arrowright: "rightArrow",
            arrowdown: "downArrow",
            "delete": "del",
            " ": "space",
            f: "F",
            a: "A",
            "*": "asterisk",
            "-": "minus",
            alt: "alt",
            control: "control",
            shift: "shift",
            left: "leftArrow",
            up: "upArrow",
            right: "rightArrow",
            down: "downArrow",
            multiply: "asterisk",
            spacebar: "space",
            del: "del",
            subtract: "minus",
            esc: "escape"
        };
        var LEGACY_KEY_CODES = {
            8: "backspace",
            9: "tab",
            13: "enter",
            27: "escape",
            33: "pageUp",
            34: "pageDown",
            35: "end",
            36: "home",
            37: "leftArrow",
            38: "upArrow",
            39: "rightArrow",
            40: "downArrow",
            46: "del",
            32: "space",
            70: "F",
            65: "A",
            106: "asterisk",
            109: "minus",
            189: "minus",
            173: "minus",
            16: "shift",
            17: "control",
            18: "alt"
        };
        var EVENT_SOURCES_REGEX = {
            dx: /^dx/i,
            mouse: /(mouse|wheel)/i,
            touch: /^touch/i,
            keyboard: /^key/i,
            pointer: /^(ms)?pointer/i
        };
        var fixMethod = function(e) {
            return e
        };
        var copyEvent = function(originalEvent) {
            return fixMethod(_events_engine.default.Event(originalEvent, originalEvent), originalEvent)
        };
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var eventSource = function(_ref) {
            var type = _ref.type;
            var result = "other";
            (0, _iterator.each)(EVENT_SOURCES_REGEX, function(key) {
                if (this.test(type)) {
                    result = key;
                    return false
                }
            });
            return result
        };
        exports.eventSource = eventSource;
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        exports.isPointerEvent = isPointerEvent;
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        exports.isMouseEvent = isMouseEvent;
        var isDxMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        exports.isDxMouseWheelEvent = isDxMouseWheelEvent;
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        exports.isTouchEvent = isTouchEvent;
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        exports.isKeyboardEvent = isKeyboardEvent;
        var isFakeClickEvent = function(_ref2) {
            var screenX = _ref2.screenX,
                offsetX = _ref2.offsetX,
                pageX = _ref2.pageX;
            return 0 === screenX && !offsetX && 0 === pageX
        };
        exports.isFakeClickEvent = isFakeClickEvent;
        var eventData = function(_ref3) {
            var pageX = _ref3.pageX,
                pageY = _ref3.pageY,
                timeStamp = _ref3.timeStamp;
            return {
                x: pageX,
                y: pageY,
                time: timeStamp
            }
        };
        exports.eventData = eventData;
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        exports.eventDelta = eventDelta;
        var hasTouches = function(e) {
            var originalEvent = e.originalEvent,
                pointers = e.pointers;
            if (isNativeTouchEvent(e)) {
                return (originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (pointers || []).length
            }
            return 0
        };
        exports.hasTouches = hasTouches;
        var skipEvents = false;
        var forceSkipEvents = function() {
            return skipEvents = true
        };
        exports.forceSkipEvents = forceSkipEvents;
        var stopEventsSkipping = function() {
            return skipEvents = false
        };
        exports.stopEventsSkipping = stopEventsSkipping;
        var needSkipEvent = function(e) {
            if (skipEvents) {
                return true
            }
            var target = e.target;
            var $target = (0, _renderer.default)(target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if (isDxMouseWheelEvent(e)) {
                var isTextArea = $target.is("textarea") && $target.hasClass("dx-texteditor-input");
                if (isTextArea) {
                    return false
                }
                var isContentEditable = target.isContentEditable || target.hasAttribute("contenteditable");
                if (isContentEditable) {
                    return false
                }
                var isInputFocused = $target.is("input[type='number'], textarea, select") && $target.is(":focus");
                return isInputFocused
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && (0, _selectors.focused)($target)
            }
        };
        exports.needSkipEvent = needSkipEvent;
        var setEventFixMethod = function(func) {
            return fixMethod = func
        };
        exports.setEventFixMethod = setEventFixMethod;
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            args && (0, _extend.extend)(event, args);
            return event
        };
        exports.createEvent = createEvent;
        var fireEvent = function(props) {
            var originalEvent = props.originalEvent,
                delegateTarget = props.delegateTarget;
            var event = createEvent(originalEvent, props);
            _events_engine.default.trigger(delegateTarget || event.target, event);
            return event
        };
        exports.fireEvent = fireEvent;
        var normalizeKeyName = function(_ref4) {
            var key = _ref4.key,
                which = _ref4.which;
            var isKeySupported = !!key;
            key = isKeySupported ? key : which;
            if (key) {
                if (isKeySupported) {
                    key = KEY_MAP[key.toLowerCase()] || key
                } else {
                    key = LEGACY_KEY_CODES[key] || String.fromCharCode(key)
                }
                return key
            }
        };
        exports.normalizeKeyName = normalizeKeyName;
        var getChar = function(_ref5) {
            var key = _ref5.key,
                which = _ref5.which;
            return key || String.fromCharCode(which)
        };
        exports.getChar = getChar;
        var addNamespace = _add_namespace.default;
        exports.addNamespace = addNamespace
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/component_registrator.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 2));
        var _component_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./component_registrator_callbacks */ 166));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }(0, _public_component.name)(componentClass, name);
            _component_registrator_callbacks.default.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            _renderer.default.fn[name] = function(options) {
                var isMemberInvoke = "string" === typeof options;
                var result;
                if (isMemberInvoke) {
                    var memberName = options;
                    var memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw _errors.default.Error("E0009", name)
                        }
                        var member = instance[memberName];
                        var memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        _component_registrator_callbacks.default.add(registerRendererComponent);
        var _default = registerComponent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/message.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _string = __webpack_require__( /*! ../core/utils/string */ 43);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 39);
        var _core = _interopRequireDefault(__webpack_require__( /*! ./core */ 86));
        var _default_messages = _interopRequireDefault(__webpack_require__( /*! ./default_messages */ 508));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var baseDictionary = (0, _extend.extend)(true, {}, _default_messages.default);
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var newMessages = {};
        var messageLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            _dictionary: baseDictionary,
            load: function(messages) {
                (0, _extend.extend)(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this;
                var regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g");
                var escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var defaultResult = that._localizablePrefix + localizationKey;
                    var result;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = (0, _inflector.humanize)(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            localizeNode: function(node) {
                var that = this;
                (0, _renderer.default)(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!(0, _renderer.default)(nodeItem).is("iframe")) {
                            (0, _iterator.each)(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            (0, _renderer.default)(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return (0, _extend.extend)({}, newMessages, this.getMessagesByLocales()[_core.default.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var _this = this;
                var message = _core.default.getValueByClosestLocale(function(locale) {
                    return getDataByLocale(_this._dictionary, locale)[key]
                });
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return _string.format.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        var _default = messageLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/dom_adapter.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./utils/dependency_injector */ 59));
        var _common = __webpack_require__( /*! ./utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var ELEMENT_NODE = 1;
        var TEXT_NODE = 3;
        var DOCUMENT_NODE = 9;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var _this = this;
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = _this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                };
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === _typeof(element) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            getAttribute: function(element, name) {
                return element.getAttribute(name)
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNameSupported = "string" === typeof element.className;
                        var elementClass = classNameSupported ? element.className : this.getAttribute(element, "class") || "";
                        var classNames = elementClass.split(" ");
                        var classIndex = classNames.indexOf(className);
                        var resultClassName;
                        if (isAdd && classIndex < 0) {
                            resultClassName = elementClass ? elementClass + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            resultClassName = classNames.join(" ")
                        }
                        if (void 0 !== resultClassName) {
                            if (classNameSupported) {
                                element.className = resultClassName
                            } else {
                                this.setAttribute(element, "class", resultClassName)
                            }
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return _common.noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        var _default = (0, _dependency_injector.default)(nativeDOMAdapterStrategy);
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/array.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.groupBy = exports.find = exports.merge = exports.normalizeIndexes = exports.removeDuplicates = exports.intersection = exports.inArray = exports.wrapToArray = exports.isEmpty = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _object = __webpack_require__( /*! ./object */ 50);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function ownKeys(object, enumerableOnly) {
            var keys = Object.keys(object);
            if (Object.getOwnPropertySymbols) {
                var symbols = Object.getOwnPropertySymbols(object);
                if (enumerableOnly) {
                    symbols = symbols.filter(function(sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable
                    })
                }
                keys.push.apply(keys, symbols)
            }
            return keys
        }

        function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = null != arguments[i] ? arguments[i] : {};
                if (i % 2) {
                    ownKeys(Object(source), true).forEach(function(key) {
                        _defineProperty(target, key, source[key])
                    })
                } else {
                    if (Object.getOwnPropertyDescriptors) {
                        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                    } else {
                        ownKeys(Object(source)).forEach(function(key) {
                            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key))
                        })
                    }
                }
            }
            return target
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        exports.isEmpty = isEmpty;
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        exports.wrapToArray = wrapToArray;
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        exports.inArray = inArray;
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            (0, _iterator.each)(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        exports.intersection = intersection;
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            (0, _iterator.each)(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        exports.removeDuplicates = removeDuplicates;
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {};
            var parameterIndex = 0;
            var useLegacyVisibleIndex = (0, _config.default)().useLegacyVisibleIndex;
            (0, _iterator.each)(items, function(index, item) {
                index = item[indexParameterName];
                if (index >= 0) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                } else {
                    item[indexParameterName] = void 0
                }
            });
            if (!useLegacyVisibleIndex) {
                (0, _iterator.each)(items, function() {
                    if (!(0, _type.isDefined)(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        while (indexedItems[parameterIndex]) {
                            parameterIndex++
                        }
                        indexedItems[parameterIndex] = [this];
                        parameterIndex++
                    }
                })
            }
            parameterIndex = 0;
            (0, _object.orderEach)(indexedItems, function(index, items) {
                (0, _iterator.each)(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            if (useLegacyVisibleIndex) {
                (0, _iterator.each)(items, function() {
                    if (!(0, _type.isDefined)(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            }
            return parameterIndex
        };
        exports.normalizeIndexes = normalizeIndexes;
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        exports.merge = merge;
        var find = function(array, condition) {
            for (var i = 0; i < array.length; i++) {
                if (condition(array[i])) {
                    return array[i]
                }
            }
        };
        exports.find = find;
        var groupBy = function(array, cb) {
            return array.reduce(function(result, item) {
                return _objectSpread(_objectSpread({}, result), {}, _defineProperty({}, cb(item), [].concat(_toConsumableArray(result[cb(item)] || []), [item])))
            }, {})
        };
        exports.groupBy = groupBy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/core/devices.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/ready_callbacks */ 49));
        var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/resize_callbacks */ 125));
        var _events_strategy = __webpack_require__( /*! ./events_strategy */ 98);
        var _storage = __webpack_require__( /*! ./utils/storage */ 323);
        var _view_port = __webpack_require__( /*! ./utils/view_port */ 81);
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var navigator = (0, _window.getNavigator)();
        var window = (0, _window.getWindow)();
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            generic: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/);
                var isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent);
                var isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                var isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                if (!(isPhone || isTablet || isDesktop || isMac)) {
                    return
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "generic",
                    version: [],
                    grade: "A",
                    mac: isMac
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent);
                var matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [];
                var isIPhone4 = 480 === window.screen.height;
                var grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent);
                var matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [];
                var worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4);
                var grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = function() {
            function Devices(options) {
                _classCallCheck(this, Devices);
                this._window = (null === options || void 0 === options ? void 0 : options.window) || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                this.changed = (0, _callbacks.default)();
                if ((0, _window.hasWindow)()) {
                    _ready_callbacks.default.add(this._recalculateOrientation.bind(this));
                    _resize_callbacks.default.add(this._recalculateOrientation.bind(this))
                }
            }
            _createClass(Devices, [{
                key: "current",
                value: function(deviceOrName) {
                    if (deviceOrName) {
                        this._currentDevice = this._getDevice(deviceOrName);
                        this._forced = true;
                        this.changed.fire();
                        return
                    }
                    if (!this._currentDevice) {
                        deviceOrName = void 0;
                        try {
                            deviceOrName = this._getDeviceOrNameFromWindowScope()
                        } catch (e) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        } finally {
                            if (!deviceOrName) {
                                deviceOrName = this._getDeviceNameFromSessionStorage()
                            }
                            if (deviceOrName) {
                                this._forced = true
                            }
                        }
                        this._currentDevice = this._getDevice(deviceOrName)
                    }
                    return this._currentDevice
                }
            }, {
                key: "real",
                value: function(forceDevice) {
                    return (0, _extend.extend)({}, this._realDevice)
                }
            }, {
                key: "orientation",
                value: function() {
                    return this._currentOrientation
                }
            }, {
                key: "isForced",
                value: function() {
                    return this._forced
                }
            }, {
                key: "isRippleEmulator",
                value: function() {
                    return !!this._window.tinyHippos
                }
            }, {
                key: "_getCssClasses",
                value: function(device) {
                    var result = [];
                    var realDevice = this._realDevice;
                    device = device || this.current();
                    if (device.deviceType) {
                        result.push("dx-device-".concat(device.deviceType));
                        if ("desktop" !== device.deviceType) {
                            result.push("dx-device-mobile")
                        }
                    }
                    result.push("dx-device-".concat(realDevice.platform));
                    if (realDevice.version && realDevice.version.length) {
                        result.push("dx-device-".concat(realDevice.platform, "-").concat(realDevice.version[0]))
                    }
                    if (this.isSimulator()) {
                        result.push("dx-simulator")
                    }
                    if ((0, _config.default)().rtlEnabled) {
                        result.push("dx-rtl")
                    }
                    return result
                }
            }, {
                key: "attachCssClasses",
                value: function(element, device) {
                    this._deviceClasses = this._getCssClasses(device).join(" ");
                    (0, _renderer.default)(element).addClass(this._deviceClasses)
                }
            }, {
                key: "detachCssClasses",
                value: function(element) {
                    (0, _renderer.default)(element).removeClass(this._deviceClasses)
                }
            }, {
                key: "isSimulator",
                value: function() {
                    try {
                        return this._isSimulator || (0, _window.hasWindow)() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                    } catch (e) {
                        return false
                    }
                }
            }, {
                key: "forceSimulator",
                value: function() {
                    this._isSimulator = true
                }
            }, {
                key: "_getDevice",
                value: function(deviceName) {
                    if ("genericPhone" === deviceName) {
                        deviceName = {
                            deviceType: "phone",
                            platform: "generic",
                            generic: true
                        }
                    }
                    if ((0, _type.isPlainObject)(deviceName)) {
                        return this._fromConfig(deviceName)
                    } else {
                        var ua;
                        if (deviceName) {
                            ua = KNOWN_UA_TABLE[deviceName];
                            if (!ua) {
                                throw _errors.default.Error("E0005")
                            }
                        } else {
                            ua = navigator.userAgent
                        }
                        return this._fromUA(ua)
                    }
                }
            }, {
                key: "_getDeviceOrNameFromWindowScope",
                value: function() {
                    var result;
                    if ((0, _window.hasWindow)() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                        result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                    }
                    return result
                }
            }, {
                key: "_getDeviceNameFromSessionStorage",
                value: function() {
                    var sessionStorage = (0, _storage.sessionStorage)();
                    if (!sessionStorage) {
                        return
                    }
                    var deviceOrName = sessionStorage.getItem("dx-force-device");
                    try {
                        return JSON.parse(deviceOrName)
                    } catch (ex) {
                        return deviceOrName
                    }
                }
            }, {
                key: "_fromConfig",
                value: function(config) {
                    var result = (0, _extend.extend)({}, DEFAULT_DEVICE, this._currentDevice, config);
                    var shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        generic: "generic" === result.platform
                    };
                    return (0, _extend.extend)(result, shortcuts)
                }
            }, {
                key: "_fromUA",
                value: function(ua) {
                    var config;
                    (0, _iterator.each)(uaParsers, function(platform, parser) {
                        config = parser(ua);
                        return !config
                    });
                    if (config) {
                        return this._fromConfig(config)
                    }
                    return DEFAULT_DEVICE
                }
            }, {
                key: "_changeOrientation",
                value: function() {
                    var $window = (0, _renderer.default)(this._window);
                    var orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                    if (this._currentOrientation === orientation) {
                        return
                    }
                    this._currentOrientation = orientation;
                    this._eventsStrategy.fireEvent("orientationChanged", [{
                        orientation: orientation
                    }])
                }
            }, {
                key: "_recalculateOrientation",
                value: function() {
                    var windowWidth = (0, _renderer.default)(this._window).width();
                    if (this._currentWidth === windowWidth) {
                        return
                    }
                    this._currentWidth = windowWidth;
                    this._changeOrientation()
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.on(eventName, eventHandler);
                    return this
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.off(eventName, eventHandler);
                    return this
                }
            }]);
            return Devices
        }();
        var devices = new Devices;
        _view_port.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        var _default = devices;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/core/class.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _type = __webpack_require__( /*! ./utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var that = this;
            var overridden;
            var memberName;
            var member;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var classObj = this;
            var argument;
            var name;
            var i;
            var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
            var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
            if (isES6Class) {
                classObj._includedCtors = classObj._includedCtors.slice(0);
                classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
            }
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            var hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
            var isES6Class = !hasParentProperty && this.parent;
            if (isES6Class) {
                var baseClass = Object.getPrototypeOf(this);
                return baseClass === parentClass || baseClass.subclassOf(parentClass)
            } else {
                if (this.parent === parentClass) {
                    return true
                }
                if (!this.parent || !this.parent.subclassOf) {
                    return false
                }
                return this.parent.subclassOf(parentClass)
            }
        };
        var abstract = function() {
            throw _errors.default.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || (0, _type.isWindow)(this) || "function" !== typeof this.constructor) {
                    throw _errors.default.Error("E0003")
                }
                var instance = this;
                var ctor = instance.ctor;
                var includedCtors = instance.constructor._includedCtors;
                var includedPostCtors = instance.constructor._includedPostCtors;
                var i;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        var _default = classImpl;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/ui.widget.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _action = _interopRequireDefault(__webpack_require__( /*! ../../core/action */ 110));
        var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_component */ 68));
        var _short = __webpack_require__( /*! ../../events/short */ 128);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ./selectors */ 71);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        __webpack_require__( /*! ../../events/click */ 21);
        __webpack_require__( /*! ../../events/core/emitter.feedback */ 147);
        __webpack_require__( /*! ../../events/hover */ 153);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }

        function setAttribute(name, value, target) {
            name = "role" === name || "id" === name ? name : "aria-".concat(name);
            value = (0, _type.isDefined)(value) ? value.toString() : null;
            target.attr(name, value)
        }
        var Widget = _dom_component.default.inherit({
            _feedbackHideTimeout: 400,
            _feedbackShowTimeout: 30,
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return (0, _extend2.extend)(this.callBase(), {
                    hoveredElement: null,
                    isActive: false,
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    onKeyboardHandled: null,
                    ignoreParentReadOnly: false
                })
            },
            _init: function() {
                this.callBase();
                this._initContentReadyAction()
            },
            _innerWidgetOptionChanged: function(innerWidget, args) {
                var options = Widget.getOptionsFromContainer(args);
                innerWidget && innerWidget.option(options);
                this._options.cache(args.name, options)
            },
            _bindInnerWidgetOptions: function(innerWidget, optionsContainer) {
                var _this = this;
                var syncOptions = function() {
                    return _this._options.silent(optionsContainer, (0, _extend2.extend)({}, innerWidget.option()))
                };
                syncOptions();
                innerWidget.on("optionChanged", syncOptions)
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                var _this$option = this.option(),
                    disabled = _this$option.disabled,
                    visible = _this$option.visible;
                this.$element().addClass("dx-widget");
                this._toggleDisabledState(disabled);
                this._toggleVisibility(visible);
                this._renderHint();
                this._isFocusable() && this._renderFocusTarget();
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents();
                this._toggleIndependentState()
            },
            _renderHint: function() {
                var _this$option2 = this.option(),
                    hint = _this$option2.hint;
                this.$element().attr("title", hint || null)
            },
            _renderContent: function() {
                var _this2 = this;
                (0, _common.deferRender)(function() {
                    return !_this2._disposed ? _this2._renderContentImpl() : void 0
                }).done(function() {
                    return !_this2._disposed ? _this2._fireContentReadyAction() : void 0
                })
            },
            _renderContentImpl: _common.noop,
            _fireContentReadyAction: (0, _common.deferRenderer)(function() {
                return this._contentReadyAction()
            }),
            _dispose: function() {
                this._contentReadyAction = null;
                this._detachKeyboardEvents();
                this.callBase()
            },
            _resetActiveState: function() {
                this._toggleActiveState(this._eventBindingTarget(), false)
            },
            _clean: function() {
                this._cleanFocusState();
                this._resetActiveState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass("dx-state-invisible", !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (this._isFocusable()) {
                    this._renderFocusTarget();
                    this._attachFocusEvents();
                    this._renderAccessKey()
                }
            },
            _renderAccessKey: function() {
                var _this3 = this;
                var $el = this._focusTarget();
                var _this$option3 = this.option(),
                    accessKey = _this$option3.accessKey;
                var namespace = "UIFeedback";
                $el.attr("accesskey", accessKey);
                _short.dxClick.off($el, {
                    namespace: namespace
                });
                accessKey && _short.dxClick.on($el, function(e) {
                    if ((0, _index.isFakeClickEvent)(e)) {
                        e.stopImmediatePropagation();
                        _this3.focus()
                    }
                }, {
                    namespace: namespace
                })
            },
            _isFocusable: function() {
                var _this$option4 = this.option(),
                    focusStateEnabled = _this$option4.focusStateEnabled,
                    disabled = _this$option4.disabled;
                return focusStateEnabled && !disabled
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    return activeElement.find(this._activeStateUnit).not(".dx-state-disabled")
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                var _this$option5 = this.option(),
                    tabIndex = _this$option5.tabIndex;
                this._focusTarget().attr("tabIndex", tabIndex)
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusEventTarget: function() {
                return this._focusTarget()
            },
            _focusInHandler: function(event) {
                var _this4 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusIn", {
                        beforeExecute: function() {
                            return _this4._updateFocusState(event, true)
                        },
                        excludeValidators: ["readOnly"]
                    })({
                        event: event
                    })
                }
            },
            _focusOutHandler: function(event) {
                var _this5 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusOut", {
                        beforeExecute: function() {
                            return _this5._updateFocusState(event, false)
                        },
                        excludeValidators: ["readOnly", "disabled"]
                    })({
                        event: event
                    })
                }
            },
            _updateFocusState: function(_ref, isFocused) {
                var target = _ref.target;
                if ((0, _array.inArray)(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, (0, _renderer.default)(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass("dx-state-focused", isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = (0, _renderer.default)(element || this._focusTarget());
                return $focusTarget.hasClass("dx-state-focused")
            },
            _isFocused: function() {
                return this._hasFocusClass()
            },
            _getKeyboardListeners: function() {
                return []
            },
            _attachKeyboardEvents: function() {
                var _this6 = this;
                this._detachKeyboardEvents();
                var _this$option6 = this.option(),
                    focusStateEnabled = _this$option6.focusStateEnabled,
                    onKeyboardHandled = _this$option6.onKeyboardHandled;
                var hasChildListeners = this._getKeyboardListeners().length;
                var hasKeyboardEventHandler = !!onKeyboardHandled;
                var shouldAttach = focusStateEnabled || hasChildListeners || hasKeyboardEventHandler;
                if (shouldAttach) {
                    this._keyboardListenerId = _short.keyboard.on(this._keyboardEventBindingTarget(), this._focusTarget(), function(opts) {
                        return _this6._keyboardHandler(opts)
                    })
                }
            },
            _keyboardHandler: function(options, onlyChildProcessing) {
                if (!onlyChildProcessing) {
                    var originalEvent = options.originalEvent,
                        keyName = options.keyName,
                        which = options.which;
                    var keys = this._supportedKeys(originalEvent);
                    var func = keys[keyName] || keys[which];
                    if (void 0 !== func) {
                        var handler = func.bind(this);
                        var result = handler(originalEvent, options);
                        if (!result) {
                            return false
                        }
                    }
                }
                var keyboardListeners = this._getKeyboardListeners();
                var _this$option7 = this.option(),
                    onKeyboardHandled = _this$option7.onKeyboardHandled;
                keyboardListeners.forEach(function(listener) {
                    return listener && listener._keyboardHandler(options)
                });
                onKeyboardHandled && onKeyboardHandled(options);
                return true
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                $element.removeAttr("tabIndex");
                this._toggleFocusClass(false);
                this._detachFocusEvents();
                this._detachKeyboardEvents()
            },
            _detachKeyboardEvents: function() {
                _short.keyboard.off(this._keyboardListenerId);
                this._keyboardListenerId = null
            },
            _attachHoverEvents: function() {
                var _this7 = this;
                var _this$option8 = this.option(),
                    hoverStateEnabled = _this$option8.hoverStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.hover.off($el, {
                    selector: selector,
                    namespace: namespace
                });
                if (hoverStateEnabled) {
                    _short.hover.on($el, new _action.default(function(_ref2) {
                        var event = _ref2.event,
                            element = _ref2.element;
                        _this7._hoverStartHandler(event);
                        _this7.option("hoveredElement", (0, _renderer.default)(element))
                    }, {
                        excludeValidators: ["readOnly"]
                    }), function(event) {
                        _this7.option("hoveredElement", null);
                        _this7._hoverEndHandler(event)
                    }, {
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _attachFeedbackEvents: function() {
                var _this8 = this;
                var _this$option9 = this.option(),
                    activeStateEnabled = _this$option9.activeStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.active.off($el, {
                    namespace: namespace,
                    selector: selector
                });
                if (activeStateEnabled) {
                    _short.active.on($el, new _action.default(function(_ref3) {
                        var event = _ref3.event,
                            element = _ref3.element;
                        return _this8._toggleActiveState((0, _renderer.default)(element), true, event)
                    }), new _action.default(function(_ref4) {
                        var event = _ref4.event,
                            element = _ref4.element;
                        return _this8._toggleActiveState((0, _renderer.default)(element), false, event)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    }), {
                        showTimeout: this._feedbackShowTimeout,
                        hideTimeout: this._feedbackHideTimeout,
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _detachFocusEvents: function() {
                var $el = this._focusEventTarget();
                _short.focus.off($el, {
                    namespace: "".concat(this.NAME, "Focus")
                })
            },
            _attachFocusEvents: function() {
                var _this9 = this;
                var $el = this._focusEventTarget();
                _short.focus.on($el, function(e) {
                    return _this9._focusInHandler(e)
                }, function(e) {
                    return _this9._focusOutHandler(e)
                }, {
                    namespace: "".concat(this.NAME, "Focus"),
                    isFocusable: function(index, el) {
                        return (0, _renderer.default)(el).is(_selectors.focusable)
                    }
                })
            },
            _hoverStartHandler: _common.noop,
            _hoverEndHandler: _common.noop,
            _toggleActiveState: function($element, value) {
                this.option("isActive", value);
                $element.toggleClass("dx-state-active", value)
            },
            _updatedHover: function() {
                var hoveredElement = this._options.silent("hoveredElement");
                this._hover(hoveredElement, hoveredElement)
            },
            _findHoverTarget: function($el) {
                return $el && $el.closest(this._activeStateUnit || this._eventBindingTarget())
            },
            _hover: function($el, $previous) {
                var _this$option10 = this.option(),
                    hoverStateEnabled = _this$option10.hoverStateEnabled,
                    disabled = _this$option10.disabled,
                    isActive = _this$option10.isActive;
                $previous = this._findHoverTarget($previous);
                $previous && $previous.toggleClass("dx-state-hover", false);
                if ($el && hoverStateEnabled && !disabled && !isActive) {
                    var newHoveredElement = this._findHoverTarget($el);
                    newHoveredElement && newHoveredElement.toggleClass("dx-state-hover", true)
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass("dx-state-disabled", Boolean(value));
                this.setAria("disabled", value || void 0)
            },
            _toggleIndependentState: function() {
                this.$element().toggleClass("dx-state-independent", this.option("ignoreParentReadOnly"))
            },
            _setWidgetOption: function(widgetName, args) {
                var _this10 = this;
                if (!this[widgetName]) {
                    return
                }
                if ((0, _type.isPlainObject)(args[0])) {
                    (0, _iterator.each)(args[0], function(option, value) {
                        return _this10._setWidgetOption(widgetName, [option, value])
                    });
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this["".concat(widgetName, "OptionMap")];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                var name = args.name,
                    value = args.value,
                    previousValue = args.previousValue;
                switch (name) {
                    case "disabled":
                        this._toggleDisabledState(value);
                        this._updatedHover();
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "ignoreParentReadOnly":
                        this._toggleIndependentState();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        this._updatedHover();
                        break;
                    case "tabIndex":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "hoveredElement":
                        this._hover(value, previousValue);
                        break;
                    case "isActive":
                        this._updatedHover();
                        break;
                    case "visible":
                        this._toggleVisibility(value);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(value ? "shown" : "hiding")
                        }
                        break;
                    case "onKeyboardHandled":
                        this._attachKeyboardEvents();
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                var _this$option11 = this.option(),
                    visible = _this$option11.visible;
                return this.callBase() && visible
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                if (!(0, _type.isPlainObject)(arguments.length <= 0 ? void 0 : arguments[0])) {
                    setAttribute(arguments.length <= 0 ? void 0 : arguments[0], arguments.length <= 1 ? void 0 : arguments[1], (arguments.length <= 2 ? void 0 : arguments[2]) || this._getAriaTarget())
                } else {
                    var target = (arguments.length <= 1 ? void 0 : arguments[1]) || this._getAriaTarget();
                    (0, _iterator.each)(arguments.length <= 0 ? void 0 : arguments[0], function(name, value) {
                        return setAttribute(name, value, target)
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                _short.focus.trigger(this._focusTarget())
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys();
                this._supportedKeys = function() {
                    return (0, _extend2.extend)(currentKeys, _defineProperty({}, key, handler))
                }
            }
        });
        Widget.getOptionsFromContainer = function(_ref5) {
            var name = _ref5.name,
                fullName = _ref5.fullName,
                value = _ref5.value;
            var options = {};
            if (name === fullName) {
                options = value
            } else {
                var option = fullName.split(".").pop();
                options[option] = value
            }
            return options
        };
        var _default = Widget;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/ui.errors.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/error */ 144));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: "{0} requires the key field to be specified",
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            E1050: "The validationRules option does not apply to third-party editors defined in the editCellTemplate",
            E1051: 'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',
            E1052: '{0} should have the "dataSource" option specified',
            E1053: 'The "buttons" option accepts an array that contains only objects or string values',
            E1054: "All text editor buttons must have names",
            E1055: 'One or several text editor buttons have invalid or non-unique "name" values',
            E1056: 'The {0} widget does not support buttons of the "{1}" type',
            E1058: 'The "startDayHour" must be earlier than the "endDayHour"',
            E1059: "All column names must be different",
            E1060: "All editable columns must have names",
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the following error: '{0}'",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects",
            W1013: 'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',
            W1014: "The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config.",
            W1015: 'The "cellDuration" should divide the range from the "startDayHour" to the "endDayHour" into even intervals'
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/core/element.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getPublicElement = getPublicElement;
        exports.setPublicElementWrapper = setPublicElementWrapper;
        var strategy = function(element) {
            return element && element.get(0)
        };

        function getPublicElement(element) {
            return strategy(element)
        }

        function setPublicElementWrapper(newStrategy) {
            strategy = newStrategy
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/date.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _math = __webpack_require__( /*! ./math */ 29);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _inflector = __webpack_require__( /*! ./inflector */ 39);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ./browser */ 22));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _construct(Parent, args, Class) {
            if (_isNativeReflectConstruct()) {
                _construct = Reflect.construct
            } else {
                _construct = function(Parent, args, Class) {
                    var a = [null];
                    a.push.apply(a, args);
                    var Constructor = Function.bind.apply(Parent, a);
                    var instance = new Constructor;
                    if (Class) {
                        _setPrototypeOf(instance, Class.prototype)
                    }
                    return instance
                }
            }
            return _construct.apply(null, arguments)
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }
        var isIE11 = _browser.default.msie && parseInt(_browser.default.version) <= 11;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime();
            var millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i;
            var dateUnitCount;
            var dateUnitInterval;
            var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"];
            var result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if ((0, _type.isObject)(tickInterval)) {
                (0, _iterator.each)(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if ((0, _type.isString)(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };

        function convertDateUnitToMilliseconds(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        }

        function getDateUnitInterval(tickInterval) {
            var maxInterval = -1;
            var i;
            if ((0, _type.isString)(tickInterval)) {
                return tickInterval
            }
            if ((0, _type.isObject)(tickInterval)) {
                (0, _iterator.each)(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        }
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };

        function correctDateWithUnitBeginning(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var oldDate = new Date(date.getTime());
            var firstQuarterMonth;
            var month;
            var dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    month = date.getMonth();
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0);
                    if (month !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        }

        function trimTime(date) {
            return correctDateWithUnitBeginning(date, "day")
        }
        var setToDayEnd = function(date) {
            var result = trimTime(date);
            result.setDate(result.getDate() + 1);
            return new Date(result.getTime() - 1)
        };
        var getDatesDifferences = function(date1, date2) {
            var counter = 0;
            var differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            (0, _iterator.each)(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime());
            var intervalObject = (0, _type.isString)(interval) ? getDateIntervalByString(interval.toLowerCase()) : (0, _type.isNumeric)(interval) ? convertMillisecondsToDateUnits(interval) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return (0, _type.isDate)(value) ? addDateInterval(value, interval, dir) : (0, _math.adjust)(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var intervals = [];
            var cur;
            intervals.push((0, _type.isDate)(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return createDateWithFullYear(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return createDateWithFullYear(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return createDateWithFullYear(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return createDateWithFullYear(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return createDateWithFullYear(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return createDateWithFullYear(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return createDateWithFullYear(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date);
            resultDate.setDate(getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };

        function getLastMonthDay(date) {
            var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        }
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };

        function getDateIntervalByString(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        }

        function sameDate(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        }

        function sameMonthAndYear(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        }

        function sameYear(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        }
        var sameDecade = function(date1, date2) {
            if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10;
            var startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100;
            var startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };

        function getFirstDecadeInCentury(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        }

        function getFirstYearInDecade(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        }
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!(0, _type.isDefined)(date)) {
                return
            }
            return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
        };
        var getLastMonthDate = function(date) {
            if (!(0, _type.isDefined)(date)) {
                return
            }
            return createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0)
        };

        function getFirstWeekDate(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        }
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day");
            var resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var dateTimeFromDecimal = function(number) {
            var hours = Math.floor(number);
            var minutes = number % 1 * 60;
            return {
                hours: hours,
                minutes: minutes
            }
        };
        var roundDateByStartDayHour = function(date, startDayHour) {
            var startTime = this.dateTimeFromDecimal(startDayHour);
            var result = new Date(date);
            if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                result.setHours(startTime.hours, startTime.minutes, 0, 0)
            }
            return result
        };

        function normalizeDate(date, min, max) {
            var normalizedDate = date;
            if (!(0, _type.isDefined)(date)) {
                return date
            }
            if ((0, _type.isDefined)(min) && date < min) {
                normalizedDate = min
            }
            if ((0, _type.isDefined)(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        }

        function fixTimezoneGap(oldDate, newDate) {
            if (!(0, _type.isDefined)(oldDate)) {
                return
            }
            var diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            var sign = 1 === diff || diff === -23 ? -1 : 1;
            var trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        }
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };

        function getTimezonesDifference(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        }
        var makeDate = function(date) {
            return new Date(date)
        };
        var getDatesOfInterval = function(startDate, endDate, step) {
            var result = [];
            var currentDate = new Date(startDate.getTime());
            while (currentDate < endDate) {
                result.push(new Date(currentDate.getTime()));
                currentDate = this.addInterval(currentDate, step)
            }
            return result
        };
        var createDate = function(date) {
            return new Date(isIE11 && (0, _type.isDate)(date) ? date.getTime() : date)
        };
        var createDateWithFullYear = function(year) {
            var result = _construct(Date, Array.prototype.slice.call(arguments));
            result.setFullYear(year);
            return result
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            setToDayEnd: setToDayEnd,
            roundDateByStartDayHour: roundDateByStartDayHour,
            dateTimeFromDecimal: dateTimeFromDecimal,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval,
            getDatesOfInterval: getDatesOfInterval,
            createDate: createDate,
            createDateWithFullYear: createDateWithFullYear
        };
        dateUtils.sameView = function(view, date1, date2) {
            return dateUtils[(0, _inflector.camelize)("same " + view)](date1, date2)
        };
        var _default = dateUtils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/data.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.toComparable = exports.compileSetter = exports.compileGetter = void 0;
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 25));
        var _class = _interopRequireDefault(__webpack_require__( /*! ../class */ 15));
        var _object = __webpack_require__( /*! ./object */ 50);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ./variable_wrapper */ 101));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var unwrapVariable = _variable_wrapper.default.unwrap;
        var isWrapped = _variable_wrapper.default.isWrapped;
        var assign = _variable_wrapper.default.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new _errors.default.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };

        function unwrap(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        }
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs;
                    var hasDefaultValue = "defaultValue" in options;
                    var current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            if (null == current && hasDefaultValue) {
                                return options.defaultValue
                            }
                            break
                        }
                        var pathPart = path[i];
                        if (hasDefaultValue && (0, _type.isObject)(current) && !(pathPart in current)) {
                            return options.defaultValue
                        }
                        var next = unwrap(current[pathPart], options);
                        if (!functionAsIs && (0, _type.isFunction)(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if ((0, _type.isFunction)(expr)) {
                return expr
            }
        };
        exports.compileGetter = compileGetter;

        function combineGetters(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                (0, _iterator.each)(compiledGetters, function(name) {
                    var value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    var current = result || (result = {});
                    var path = name.split(".");
                    var last = path.length - 1;
                    for (var _i = 0; _i < last; _i++) {
                        var pathItem = path[_i];
                        if (!(pathItem in current)) {
                            current[pathItem] = {}
                        }
                        current = current[pathItem]
                    }
                    current[path[last]] = value
                });
                return result
            }
        }
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if ((0, _type.isDefined)(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options);
                    var isPropertyFunc = !options.functionsAsIs && (0, _type.isFunction)(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && (0, _type.isPlainObject)(value) && (!(0, _type.isDefined)(propertyValue) || (0, _type.isPlainObject)(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            (0, _object.deepExtendArraySafe)(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        exports.compileSetter = compileSetter;
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof _class.default && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.toComparable = toComparable
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/events/click.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.name = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 33);
        var _frame = __webpack_require__( /*! ../animation/frame */ 129);
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _pointer = _interopRequireDefault(__webpack_require__( /*! ./pointer */ 24));
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 132));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));
        var _version = __webpack_require__( /*! ../core/utils/version */ 62);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var CLICK_EVENT_NAME = "dxclick";
        exports.name = CLICK_EVENT_NAME;
        var TOUCH_BOUNDARY = 10;
        var abs = Math.abs;
        var isInput = function(element) {
            return (0, _renderer.default)(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: _frame.requestAnimationFrame,
            cancelAnimationFrame: _frame.cancelAnimationFrame
        };
        var ClickEmitter = _emitter.default.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable((0, _renderer.default)(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = (0, _index.eventData)(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === _pointer.default.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    (0, _dom.resetActiveElement)()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target;
                var targetChanged = !(0, _dom.contains)(element, target) && element !== target;
                var gestureDelta = (0, _index.eventDelta)((0, _index.eventData)(e), this._startEventData);
                var boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: (0, _dom.closestCommonParent)(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        var realDevice = _devices.default.real();
        var useNativeClick = realDevice.generic || realDevice.ios && (0, _version.compare)(realDevice.version, [9, 3]) >= 0 || realDevice.android && (0, _version.compare)(realDevice.version, [5]) >= 0;
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var isNativeClickEvent = function(target) {
                return useNativeClick || (0, _renderer.default)(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null;
            var lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent;
                var eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED;
                var leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && !eventAlreadyFired) {
                    if (originalEvent) {
                        originalEvent.DXCLICK_FIRED = true
                    }
                    lastFiredEvent = originalEvent;
                    (0, _index.fireEvent)({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    _events_engine.default.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    _events_engine.default.off(this.getElement(), "click", clickHandler)
                }
            })
        }();
        ! function() {
            var desktopDevice = _devices.default.real().generic;
            if (!desktopDevice) {
                var startTarget = null;
                var blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = (0, _renderer.default)(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !(0, _renderer.default)(startTarget).is("label") && isInput($target)) {
                        (0, _dom.resetActiveElement)()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER";
                var document = _dom_adapter.default.getDocument();
                _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        (0, _emitter_registrator.default)({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        })
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/browser.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _window = __webpack_require__( /*! ./window */ 7);
        var navigator = (0, _window.getNavigator)();
        var webkitRegExp = /(webkit)[ /]([\w.]+)/;
        var ieRegExp = /(msie) (\d{1,2}\.\d)/;
        var ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/;
        var msEdge = /(edge)\/((\d+)?[\w.]+)/;
        var mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {};
            var matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [];
            var browserName = matches[1];
            var browserVersion = matches[2];
            if ("webkit" === browserName) {
                result.webkit = true;
                if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                    browserName = "chrome";
                    browserVersion = /(?:chrome|crios)\/(\d+\.\d+)/.exec(ua);
                    browserVersion = browserVersion && browserVersion[1]
                } else {
                    if (ua.indexOf("fxios") >= 0) {
                        browserName = "mozilla";
                        browserVersion = /fxios\/(\d+\.\d+)/.exec(ua);
                        browserVersion = browserVersion && browserVersion[1]
                    } else {
                        if (ua.indexOf("safari") >= 0 && /version|phantomjs/.test(ua)) {
                            browserName = "safari";
                            browserVersion = /(?:version|phantomjs)\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else {
                            browserName = "unknown";
                            browserVersion = /applewebkit\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                }
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        var _default = (0, _extend.extend)({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent));
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/position.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getDefaultAlignment = exports.getBoundingRect = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = null !== isRtlEnabled && void 0 !== isRtlEnabled ? isRtlEnabled : (0, _config.default)().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment;
        var getBoundingRect = function(element) {
            if ((0, _type.isWindow)(element)) {
                return {
                    width: element.outerWidth,
                    height: element.outerHeight
                }
            }
            var rect;
            try {
                rect = element.getBoundingClientRect()
            } catch (e) {
                rect = {
                    width: 0,
                    height: 0,
                    bottom: 0,
                    top: 0,
                    left: 0,
                    right: 0
                }
            }
            return rect
        };
        exports.getBoundingRect = getBoundingRect
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/events/pointer.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        exports.default = void 0;
        var support = _interopRequireWildcard(__webpack_require__( /*! ../core/utils/support */ 45));
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 22));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 74));
        var _touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/touch */ 254));
        var _mspointer = _interopRequireDefault(__webpack_require__( /*! ./pointer/mspointer */ 527));
        var _mouse = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse */ 256));
        var _mouse_and_touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse_and_touch */ 528));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }
        var getStrategy = function(support, device, browser) {
            if (support.pointerEvents && browser.msie) {
                return _mspointer.default
            }
            var tablet = device.tablet,
                phone = device.phone;
            if (support.touch && !(tablet || phone)) {
                return _mouse_and_touch.default
            }
            if (support.touch) {
                return _touch.default
            }
            return _mouse.default
        };
        var EventStrategy = getStrategy(support, _devices.default.real(), _browser.default);
        (0, _iterator.each)(EventStrategy.map, function(pointerEvent, originalEvents) {
            (0, _event_registrator.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        var pointer = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        };
        var _default = pointer;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/errors.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ./utils/error */ 144));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _error.default)({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/data_grid/ui.data_grid.core.js ***!
      \********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _uiGrid_core = _interopRequireDefault(__webpack_require__( /*! ../grid_core/ui.grid_core.utils */ 35));
        var _uiGrid_core2 = _interopRequireDefault(__webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 44));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function ownKeys(object, enumerableOnly) {
            var keys = Object.keys(object);
            if (Object.getOwnPropertySymbols) {
                var symbols = Object.getOwnPropertySymbols(object);
                if (enumerableOnly) {
                    symbols = symbols.filter(function(sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable
                    })
                }
                keys.push.apply(keys, symbols)
            }
            return keys
        }

        function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = null != arguments[i] ? arguments[i] : {};
                if (i % 2) {
                    ownKeys(Object(source), true).forEach(function(key) {
                        _defineProperty(target, key, source[key])
                    })
                } else {
                    if (Object.getOwnPropertyDescriptors) {
                        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                    } else {
                        ownKeys(Object(source)).forEach(function(key) {
                            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key))
                        })
                    }
                }
            }
            return target
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }
        var _default = _objectSpread(_objectSpread(_objectSpread({}, _uiGrid_core2.default), _uiGrid_core.default), {}, {
            modules: []
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/callbacks.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes;
            var list = this._list;
            var stopOnFalse = this._options.stopOnFalse;
            var step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list;
            var firingIndexes = this._firingIndexes;
            var index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        var _default = Callbacks;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/translator.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.parseTranslate = exports.resetPosition = exports.move = exports.getTranslate = exports.getTranslateCss = exports.clearCache = exports.locate = void 0;
        var _element_data = __webpack_require__( /*! ../core/element_data */ 40);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var TRANSLATOR_DATA_KEY = "dxTranslator";
        var TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/;
        var TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        exports.locate = locate;

        function isPercentValue(value) {
            return "string" === (0, _type.type)(value) && "%" === value[value.length - 1]
        }

        function cacheTranslate($element, translate) {
            if ($element.length) {
                (0, _element_data.data)($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        }
        var clearCache = function($element) {
            if ($element.length) {
                (0, _element_data.removeData)($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        exports.clearCache = clearCache;
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.getTranslateCss = getTranslateCss;
        var getTranslate = function($element) {
            var result = $element.length ? (0, _element_data.data)($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                    x: 0,
                    y: 0
                });
                var matrix = transformValue.match(TRANSFORM_MATRIX_REGEX);
                var is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        exports.getTranslate = getTranslate;
        var move = function($element, position) {
            var left = position.left;
            var top = position.top;
            var translate;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        exports.move = move;
        var resetPosition = function($element, finishTransition) {
            var originalTransition;
            var stylesConfig = {
                left: 0,
                top: 0,
                transform: "none"
            };
            if (finishTransition) {
                originalTransition = $element.css("transition");
                stylesConfig.transition = "none"
            }
            $element.css(stylesConfig);
            clearCache($element);
            if (finishTransition) {
                $element.get(0).offsetHeight;
                $element.css("transition", originalTransition)
            }
        };
        exports.resetPosition = resetPosition;
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        exports.parseTranslate = parseTranslate
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/math.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent;
        exports.getRoot = getRoot;
        exports.solveCubicEquation = solveCubicEquation;
        exports.trunc = trunc;
        exports.inRange = exports.fitIntoRange = exports.sign = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        exports.sign = sign;
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue;
            var isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        exports.fitIntoRange = fitIntoRange;
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };
        exports.inRange = inRange;

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4;
            var correctValue = "0.000300";
            var precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var precision = getPrecision(interval || 0) + 2;
            var separatedValue = value.toString().split(".");
            var sourceValue = value;
            var absValue = Math.abs(value);
            var separatedAdjustedValue;
            var isExponentValue = (0, _type.isExponential)(value);
            var integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if ((0, _type.isExponential)(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            var mantissa = str.split(".");
            var positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }

        function getRoot(x, n) {
            if (x < 0 && n % 2 !== 1) {
                return NaN
            }
            var y = Math.pow(Math.abs(x), 1 / n);
            return n % 2 === 1 && x < 0 ? -y : y
        }

        function solveCubicEquation(a, b, c, d) {
            var min = 1e-8;
            if (Math.abs(a) < min) {
                a = b;
                b = c;
                c = d;
                if (Math.abs(a) < min) {
                    a = b;
                    b = c;
                    if (Math.abs(a) < min) {
                        return []
                    }
                    return [-b / a]
                }
                var D2 = b * b - 4 * a * c;
                if (Math.abs(D2) < min) {
                    return [-b / (2 * a)]
                } else {
                    if (D2 > 0) {
                        return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                    }
                }
                return []
            }
            var p = (3 * a * c - b * b) / (3 * a * a);
            var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
            var roots;
            var u;
            if (Math.abs(p) < min) {
                roots = [getRoot(-q, 3)]
            } else {
                if (Math.abs(q) < min) {
                    roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                } else {
                    var D3 = q * q / 4 + p * p * p / 27;
                    if (Math.abs(D3) < min) {
                        roots = [-1.5 * q / p, 3 * q / p]
                    } else {
                        if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                }
            }
            for (var i = 0; i < roots.length; i++) {
                roots[i] -= b / (3 * a)
            }
            return roots
        }

        function trunc(value) {
            return Math.trunc ? Math.trunc(value) : value > 0 ? Math.floor(value) : Math.ceil(value)
        }
    },
    /*!********************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/tree_list/ui.tree_list.core.js ***!
      \********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _uiGrid_core = _interopRequireDefault(__webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 44));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _extend.extend)({}, _uiGrid_core.default, {
            modules: [],
            foreachNodes: function(nodes, callBack) {
                for (var i = 0; i < nodes.length; i++) {
                    if (false !== callBack(nodes[i]) && nodes[i].hasChildren && nodes[i].children.length) {
                        this.foreachNodes(nodes[i].children, callBack)
                    }
                }
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/config.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            oDataFilterToLower: true,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useLegacyStoreResult: false,
            useJQuery: void 0,
            editorStylingMode: void 0,
            useLegacyVisibleIndex: false,
            floatingActionButtonConfig: {
                icon: "add",
                closeIcon: "close",
                label: "",
                position: {
                    at: "right bottom",
                    my: "right bottom",
                    offset: {
                        x: -16,
                        y: -16
                    }
                },
                maxSpeedDialActionCount: 5,
                shading: false,
                direction: "auto"
            },
            optionsParser: function(optionsString) {
                if ("{" !== optionsString.trim().charAt(0)) {
                    optionsString = "{" + optionsString + "}"
                }
                try {
                    return new Function("return " + optionsString)()
                } catch (ex) {
                    throw _errors.default.Error("E3018", ex, optionsString)
                }
            }
        };
        var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
            deprecatedFields.forEach(function(deprecatedField) {
                if (newConfig[deprecatedField]) {
                    var message = "Now, the ".concat(deprecatedField, " is selected based on the specified locale.");
                    _errors.default.log("W0003", "config", deprecatedField, "19.2", message)
                }
            });
            (0, _extend.extend)(config, newConfig)
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        var _default = configMethod;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/date.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _date = __webpack_require__( /*! ./ldml/date.formatter */ 242);
        var _date2 = __webpack_require__( /*! ./ldml/date.format */ 173);
        var _date3 = __webpack_require__( /*! ./ldml/date.parser */ 232);
        var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ./default_date_names */ 243));
        var _first_day_of_week_data = _interopRequireDefault(__webpack_require__( /*! ./cldr-data/first_day_of_week_data */ 496));
        var _core = _interopRequireDefault(__webpack_require__( /*! ./core */ 86));
        var _number = _interopRequireDefault(__webpack_require__( /*! ./number */ 47));
        var _date4 = _interopRequireDefault(__webpack_require__( /*! ./intl/date */ 497));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_DAY_OF_WEEK_INDEX = 0;
        var hasIntl = "undefined" !== typeof Intl;
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format;
                var result = [];
                (0, _iterator.each)(pattern.split(/\W+/), function(_, formatPart) {
                    (0, _iterator.each)(possiblePartPatterns, function(partName, possiblePatterns) {
                        if ((0, _array.inArray)(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return _default_date_names.default.getMonthNames(format)
            },
            getDayNames: function(format) {
                return _default_date_names.default.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return _default_date_names.default.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return _default_date_names.default.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0);
                var pmTime = new Date(2017, 0, 20, 23, 0, 0, 0);
                var amTimeFormatted = this.format(amTime, format);
                var pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if ((0, _type.isString)(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return _number.default.convertDigits((0, _date.getFormatter)(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var that = this;
                var ldmlFormat;
                var formatter;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return _number.default.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = (0, _date2.getFormat)(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = _number.default.convertDigits(text, true);
                    return (0, _date3.getParser)(ldmlFormat, this)(text)
                }
                _errors.default.log("W0012");
                var result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                var index = _core.default.getValueByClosestLocale(function(locale) {
                    return _first_day_of_week_data.default[locale]
                });
                return void 0 === index ? DEFAULT_DAY_OF_WEEK_INDEX : index
            }
        });
        if (hasIntl) {
            dateLocalization.inject(_date4.default)
        }
        var _default = dateLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/dom.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.createTextElementHiddenCopy = exports.contains = exports.clipboardText = exports.normalizeTemplateElement = exports.extractTemplateMarkup = exports.closestCommonParent = exports.clearSelection = exports.resetActiveElement = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _window = __webpack_require__( /*! ./window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var resetActiveElement = function() {
            var activeElement = _dom_adapter.default.getActiveElement();
            var body = _dom_adapter.default.getBody();
            if (activeElement && activeElement !== body && activeElement.blur) {
                try {
                    activeElement.blur()
                } catch (e) {
                    body.blur()
                }
            }
        };
        exports.resetActiveElement = resetActiveElement;
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        exports.clearSelection = clearSelection;
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = (0, _renderer.default)(startTarget);
            var $endTarget = (0, _renderer.default)(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents();
            var $endParents = $endTarget.parents();
            var startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        exports.closestCommonParent = closestCommonParent;
        var extractTemplateMarkup = function(element) {
            element = (0, _renderer.default)(element);
            var templateTag = element.length && element.filter(function() {
                var $node = (0, _renderer.default)(this);
                return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
            });
            if (templateTag.length) {
                return templateTag.eq(0).html()
            } else {
                element = (0, _renderer.default)("<div>").append(element);
                return element.html()
            }
        };
        exports.extractTemplateMarkup = extractTemplateMarkup;
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = (0, _type.isDefined)(element) && (element.nodeType || (0, _type.isRenderer)(element)) ? (0, _renderer.default)(element) : (0, _renderer.default)("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        exports.normalizeTemplateElement = normalizeTemplateElement;
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        exports.clipboardText = clipboardText;
        var contains = function contains(container, element) {
            if (!element) {
                return false
            }
            if (_dom_adapter.default.isTextNode(element)) {
                element = element.parentNode
            }
            if (_dom_adapter.default.isDocument(container)) {
                return container.documentElement.contains(element)
            }
            if ((0, _type.isWindow)(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };
        exports.contains = contains;
        var createTextElementHiddenCopy = function(element, text, options) {
            var elementStyles = window.getComputedStyle((0, _renderer.default)(element).get(0));
            var includePaddings = options && options.includePaddings;
            return (0, _renderer.default)("<div>").text(text).css({
                fontStyle: elementStyles.fontStyle,
                fontVariant: elementStyles.fontVariant,
                fontWeight: elementStyles.fontWeight,
                fontSize: elementStyles.fontSize,
                fontFamily: elementStyles.fontFamily,
                letterSpacing: elementStyles.letterSpacing,
                border: elementStyles.border,
                paddingTop: includePaddings ? elementStyles.paddingTop : "",
                paddingRight: includePaddings ? elementStyles.paddingRight : "",
                paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                visibility: "hidden",
                whiteSpace: "pre",
                position: "absolute",
                "float": "left"
            })
        };
        exports.createTextElementHiddenCopy = createTextElementHiddenCopy
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled-npm/ui/themes.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.init = init;
        exports.current = current;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.isMaterial = isMaterial;
        exports.isGeneric = isGeneric;
        exports.isDark = isDark;
        exports.isWebFontLoaded = isWebFontLoaded;
        exports.waitWebFont = waitWebFont;
        exports.ready = themeReady;
        exports.resetTheme = resetTheme;
        exports.initialized = initialized;
        exports.setDefaultTimeout = setDefaultTimeout;
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../core/polyfills/promise */ 73));
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _html_parser = __webpack_require__( /*! ../core/utils/html_parser */ 238);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/ready_callbacks */ 49));
        var _view_port = __webpack_require__( /*! ../core/utils/view_port */ 81);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _themes_callback = __webpack_require__( /*! ./themes_callback */ 258);
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./widget/ui.errors */ 17));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var ready = _ready_callbacks.default.add;
        var viewPort = _view_port.value;
        var viewPortChanged = _view_port.changeCallback;
        var initDeferred = new _deferred.Deferred;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]";
        var THEME_ATTR = "data-theme";
        var ACTIVE_ATTR = "data-active";
        var DX_HAIRLINES_CLASS = "dx-hairlines";
        var ANY_THEME = "any";
        var context;
        var $activeThemeLink;
        var knownThemes;
        var currentThemeName;
        var pendingThemeName;
        var defaultTimeout = 15e3;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!(0, _window.hasWindow)()) {
                return null
            }
            var element = (0, _renderer.default)("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            var result;
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            var timerId;
            var intervalCleared = true;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                clearInterval(timerId);
                intervalCleared = true;
                _themes_callback.themeReadyCallback.fire();
                _themes_callback.themeReadyCallback.empty();
                initDeferred.resolve()
            }
            if (isPendingThemeLoaded() || !defaultTimeout) {
                handleLoaded()
            } else {
                if (!intervalCleared) {
                    if (pendingThemeName) {
                        pendingThemeName = themeName
                    }
                    return
                }
                waitStartTime = Date.now();
                intervalCleared = false;
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded();
                    var isTimeout = !isLoaded && Date.now() - waitStartTime > defaultTimeout;
                    if (isTimeout) {
                        _ui.default.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            if (!pendingThemeName) {
                return true
            }
            var anyThemePending = pendingThemeName === ANY_THEME;
            if ("resolved" === initDeferred.state() && anyThemePending) {
                return true
            }
            var themeMarker = readThemeMarker();
            if (themeMarker && anyThemePending) {
                return true
            }
            return themeMarker === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = (0, _renderer.default)(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = (0, _renderer.default)((0, _html_parser.parseHTML)("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = (0, _renderer.default)(this, context);
                var fullThemeName = link.attr(THEME_ATTR);
                var url = link.attr("href");
                var isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName ? desiredThemeName.split(".") : [];
            var result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }(0, _iterator.each)(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (desiredThemeParts[0] && knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || _dom_adapter.default.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var isAutoInit = options._autoInit;
            var loadCallback = options.loadCallback;
            var currentThemeData;
            currentThemeName = resolveFullThemeName(options.theme || currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                _themes_callback.themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if (_themes_callback.themeReadyCallback.has() || "resolved" !== initDeferred.state() || options._forceTimeout) {
                    waitForThemeLoad(currentThemeName)
                }
            } else {
                if (isAutoInit) {
                    waitForThemeLoad(ANY_THEME);
                    _themes_callback.themeReadyCallback.fire();
                    _themes_callback.themeReadyCallback.empty()
                } else {
                    throw _ui.default.Error("E0021", currentThemeName)
                }
            }
            initDeferred.done(function() {
                return attachCssClasses((0, _view_port.originalViewPort)(), currentThemeName)
            })
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [];
            var themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial(themeName) ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            (0, _renderer.default)(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = (0, _window.hasWindow)() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = (0, _renderer.default)("<div>");
                $tester.css("border", ".5px solid transparent");
                (0, _renderer.default)("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    (0, _renderer.default)(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            (0, _renderer.default)(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            _themes_callback.themeReadyCallback.add(callback)
        }

        function isTheme(themeRegExp, themeName) {
            if (!themeName) {
                themeName = currentThemeName || readThemeMarker()
            }
            return new RegExp(themeRegExp).test(themeName)
        }

        function isMaterial(themeName) {
            return isTheme("material", themeName)
        }

        function isGeneric(themeName) {
            return isTheme("generic", themeName)
        }

        function isDark(themeName) {
            return isTheme("dark", themeName)
        }

        function isWebFontLoaded(text, fontWeight) {
            var testedFont = "Roboto, RobotoFallback, Arial";
            var etalonFont = "Arial";
            var document = _dom_adapter.default.getDocument();
            var testElement = document.createElement("span");
            testElement.style.position = "absolute";
            testElement.style.top = "-9999px";
            testElement.style.left = "-9999px";
            testElement.style.visibility = "hidden";
            testElement.style.fontFamily = etalonFont;
            testElement.style.fontSize = "250px";
            testElement.style.fontWeight = fontWeight;
            testElement.innerHTML = text;
            document.body.appendChild(testElement);
            var etalonFontWidth = testElement.offsetWidth;
            testElement.style.fontFamily = testedFont;
            var testedFontWidth = testElement.offsetWidth;
            testElement.parentNode.removeChild(testElement);
            return etalonFontWidth !== testedFontWidth
        }

        function waitWebFont(text, fontWeight) {
            var interval = 15;
            var timeout = 2e3;
            return new _promise.default(function(resolve) {
                var check = function() {
                    if (isWebFontLoaded(text, fontWeight)) {
                        clear()
                    }
                };
                var clear = function() {
                    clearInterval(intervalId);
                    clearTimeout(timeoutId);
                    resolve()
                };
                var intervalId = setInterval(check, interval);
                var timeoutId = setTimeout(clear, timeout)
            })
        }

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ((0, _renderer.default)(DX_LINK_SELECTOR, context).length) {
                throw _ui.default.Error("E0022")
            }
        }
        if ((0, _window.hasWindow)()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        _devices.default.changed.add(function() {
            init({
                _autoInit: true
            })
        });

        function resetTheme() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null;
            initDeferred = new _deferred.Deferred
        }

        function initialized(callback) {
            initDeferred.done(callback)
        }

        function setDefaultTimeout(timeout) {
            defaultTimeout = timeout
        }
    },
    /*!*********************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/grid_core/ui.grid_core.utils.js ***!
      \*********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _filtering = _interopRequireDefault(__webpack_require__( /*! ../shared/filtering */ 182));
        var _string = __webpack_require__( /*! ../../core/utils/string */ 43);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _position = __webpack_require__( /*! ../../core/utils/position */ 23);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _load_panel = _interopRequireDefault(__webpack_require__( /*! ../load_panel */ 179));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../../data/utils */ 41));
        var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../format_helper */ 72));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DATAGRID_SELECTION_DISABLED_CLASS = "dx-selection-disabled";
        var DATAGRID_GROUP_OPENED_CLASS = "dx-datagrid-group-opened";
        var DATAGRID_GROUP_CLOSED_CLASS = "dx-datagrid-group-closed";
        var DATAGRID_EXPAND_CLASS = "dx-datagrid-expand";
        var NO_DATA_CLASS = "nodata";
        var DATE_INTERVAL_SELECTORS = {
            year: function(value) {
                return value && value.getFullYear()
            },
            month: function(value) {
                return value && value.getMonth() + 1
            },
            day: function(value) {
                return value && value.getDate()
            },
            quarter: function(value) {
                return value && Math.floor(value.getMonth() / 3) + 1
            },
            hour: function(value) {
                return value && value.getHours()
            },
            minute: function(value) {
                return value && value.getMinutes()
            },
            second: function(value) {
                return value && value.getSeconds()
            }
        };
        var getIntervalSelector = function() {
            var data = arguments[1];
            var value = this.calculateCellValue(data);
            if (!(0, _type.isDefined)(value)) {
                return null
            } else {
                if (isDateType(this.dataType)) {
                    var nameIntervalSelector = arguments[0];
                    return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                } else {
                    if ("number" === this.dataType) {
                        var groupInterval = arguments[0];
                        return Math.floor(Number(value) / groupInterval) * groupInterval
                    }
                }
            }
        };
        var equalSelectors = function(selector1, selector2) {
            if ((0, _type.isFunction)(selector1) && (0, _type.isFunction)(selector2)) {
                if (selector1.originalCallback && selector2.originalCallback) {
                    return selector1.originalCallback === selector2.originalCallback && selector1.columnIndex === selector2.columnIndex
                }
            }
            return selector1 === selector2
        };

        function isDateType(dataType) {
            return "date" === dataType || "datetime" === dataType
        }
        var setEmptyText = function($container) {
            $container.get(0).textContent = "\xa0"
        };
        var normalizeSortingInfo = function(sort) {
            sort = sort || [];
            var result = _utils.default.normalizeSortingInfo(sort);
            for (var i = 0; i < sort.length; i++) {
                if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                    result[i].isExpanded = sort[i].isExpanded
                }
                if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                    result[i].groupInterval = sort[i].groupInterval
                }
            }
            return result
        };
        var formatValue = function(value, options) {
            var valueText = _format_helper.default.format(value, options.format) || value && value.toString() || "";
            var formatObject = {
                value: value,
                valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                target: options.target || "row",
                groupInterval: options.groupInterval
            };
            return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
        };
        var getSummaryText = function(summaryItem, summaryTexts) {
            var displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts[summaryItem.summaryType + "OtherColumn"] || summaryTexts[summaryItem.summaryType];
            return formatValue(summaryItem.value, {
                format: summaryItem.valueFormat,
                getDisplayFormat: function(valueText) {
                    return displayFormat ? (0, _string.format)(displayFormat, valueText, summaryItem.columnCaption) : valueText
                },
                customizeText: summaryItem.customizeText
            })
        };
        var getWidgetInstance = function($element) {
            var editorData = $element.data && $element.data();
            var dxComponents = editorData && editorData.dxComponents;
            var widgetName = dxComponents && dxComponents[0];
            return widgetName && editorData[widgetName]
        };
        var equalFilterParameters = function equalFilterParameters(filter1, filter2) {
            if (Array.isArray(filter1) && Array.isArray(filter2)) {
                if (filter1.length !== filter2.length) {
                    return false
                } else {
                    for (var i = 0; i < filter1.length; i++) {
                        if (!equalFilterParameters(filter1[i], filter2[i])) {
                            return false
                        }
                    }
                }
                return true
            } else {
                if ((0, _type.isFunction)(filter1) && filter1.columnIndex >= 0 && (0, _type.isFunction)(filter2) && filter2.columnIndex >= 0) {
                    return filter1.columnIndex === filter2.columnIndex && (0, _data.toComparable)(filter1.filterValue) === (0, _data.toComparable)(filter2.filterValue)
                } else {
                    return (0, _data.toComparable)(filter1) == (0, _data.toComparable)(filter2)
                }
            }
        };
        var _default = {
            renderNoDataText: function($element) {
                var that = this;
                $element = $element || this.element();
                if (!$element) {
                    return
                }
                var noDataClass = that.addWidgetPrefix(NO_DATA_CLASS);
                var noDataElement = $element.find("." + noDataClass).last();
                var isVisible = this._dataController.isEmpty();
                var isLoading = this._dataController.isLoading();
                if (!noDataElement.length) {
                    noDataElement = (0, _renderer.default)("<span>").addClass(noDataClass).appendTo($element)
                }
                if (isVisible && !isLoading) {
                    noDataElement.removeClass("dx-hidden").text(that._getNoDataText())
                } else {
                    noDataElement.addClass("dx-hidden")
                }
            },
            renderLoadPanel: function($element, $container, isLocalStore) {
                var that = this;
                var loadPanelOptions;
                that._loadPanel && that._loadPanel.$element().remove();
                loadPanelOptions = that.option("loadPanel");
                if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                    loadPanelOptions = (0, _extend.extend)({
                        shading: false,
                        message: loadPanelOptions.text,
                        position: function() {
                            var $window = (0, _renderer.default)((0, _window.getWindow)());
                            if ($element.height() > $window.height()) {
                                return {
                                    of: $window,
                                    boundary: $element,
                                    collision: "fit"
                                }
                            }
                            return {
                                of: $element
                            }
                        },
                        container: $container
                    }, loadPanelOptions);
                    that._loadPanel = that._createComponent((0, _renderer.default)("<div>").appendTo($container), _load_panel.default, loadPanelOptions)
                } else {
                    that._loadPanel = null
                }
            },
            getIndexByKey: function(key, items, keyName) {
                var index = -1;
                if (void 0 !== key && Array.isArray(items)) {
                    keyName = arguments.length <= 2 ? "key" : keyName;
                    for (var i = 0; i < items.length; i++) {
                        var item = (0, _type.isDefined)(keyName) ? items[i][keyName] : items[i];
                        if ((0, _common.equalByValue)(key, item)) {
                            index = i;
                            break
                        }
                    }
                }
                return index
            },
            combineFilters: function(filters, operation) {
                var resultFilter = [];
                operation = operation || "and";
                for (var i = 0; i < filters.length; i++) {
                    if (!filters[i]) {
                        continue
                    }
                    if (resultFilter.length) {
                        resultFilter.push(operation)
                    }
                    resultFilter.push(filters[i])
                }
                if (1 === resultFilter.length) {
                    resultFilter = resultFilter[0]
                }
                if (resultFilter.length) {
                    return resultFilter
                }
            },
            checkChanges: function(changes, changeNames) {
                var changesWithChangeNamesCount = 0;
                for (var i = 0; i < changeNames.length; i++) {
                    if (changes[changeNames[i]]) {
                        changesWithChangeNamesCount++
                    }
                }
                return changes.length && changes.length === changesWithChangeNamesCount
            },
            equalFilterParameters: equalFilterParameters,
            proxyMethod: function(instance, methodName, defaultResult) {
                if (!instance[methodName]) {
                    instance[methodName] = function() {
                        var dataSource = this._dataSource;
                        return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                    }
                }
            },
            formatValue: formatValue,
            getFormatOptionsByColumn: function(column, target) {
                return {
                    format: column.format,
                    getDisplayFormat: column.getDisplayFormat,
                    customizeText: column.customizeText,
                    target: target,
                    trueText: column.trueText,
                    falseText: column.falseText
                }
            },
            getDisplayValue: function(column, value, data, rowType) {
                if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                    return column.displayValueMap[value]
                } else {
                    if (column.calculateDisplayValue && data && "group" !== rowType) {
                        return column.calculateDisplayValue(data)
                    } else {
                        if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                            return column.lookup.calculateCellValue(value)
                        }
                    }
                }
                return value
            },
            getGroupRowSummaryText: function(summaryItems, summaryTexts) {
                var result = "(";
                for (var i = 0; i < summaryItems.length; i++) {
                    var summaryItem = summaryItems[i];
                    result += (i > 0 ? ", " : "") + getSummaryText(summaryItem, summaryTexts)
                }
                return result += ")"
            },
            getSummaryText: getSummaryText,
            normalizeSortingInfo: normalizeSortingInfo,
            getFormatByDataType: function(dataType) {
                switch (dataType) {
                    case "date":
                        return "shortDate";
                    case "datetime":
                        return "shortDateShortTime"
                }
            },
            getHeaderFilterGroupParameters: function(column, remoteGrouping) {
                var result = [];
                var dataField = column.dataField || column.name;
                var groupInterval = _filtering.default.getGroupInterval(column);
                if (groupInterval) {
                    (0, _iterator.each)(groupInterval, function(index, interval) {
                        result.push(remoteGrouping ? {
                            selector: dataField,
                            groupInterval: interval,
                            isExpanded: index < groupInterval.length - 1
                        } : getIntervalSelector.bind(column, interval))
                    });
                    return result
                }
                if (remoteGrouping) {
                    result = [{
                        selector: dataField,
                        isExpanded: false
                    }]
                } else {
                    result = function result(data) {
                        var result = column.calculateCellValue(data);
                        if (void 0 === result || "" === result) {
                            result = null
                        }
                        return result
                    };
                    if (column.sortingMethod) {
                        result = [{
                            selector: result,
                            compare: column.sortingMethod.bind(column)
                        }]
                    }
                }
                return result
            },
            equalSortParameters: function(sortParameters1, sortParameters2, ignoreIsExpanded) {
                sortParameters1 = normalizeSortingInfo(sortParameters1);
                sortParameters2 = normalizeSortingInfo(sortParameters2);
                if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                    if (sortParameters1.length !== sortParameters2.length) {
                        return false
                    } else {
                        for (var i = 0; i < sortParameters1.length; i++) {
                            if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                return false
                            }
                        }
                    }
                    return true
                } else {
                    return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                }
            },
            getPointsByColumns: function(items, pointCreated, isVertical, startColumnIndex) {
                var cellsLength = items.length;
                var notCreatePoint = false;
                var item;
                var offset;
                var columnIndex = startColumnIndex || 0;
                var result = [];
                var rtlEnabled;
                for (var i = 0; i <= cellsLength; i++) {
                    if (i < cellsLength) {
                        item = items.eq(i);
                        offset = item.offset();
                        rtlEnabled = "rtl" === item.css("direction")
                    }
                    var point = {
                        index: columnIndex,
                        x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? (0, _position.getBoundingRect)(item[0]).width : 0) : 0,
                        y: offset ? offset.top + (isVertical && i === cellsLength ? (0, _position.getBoundingRect)(item[0]).height : 0) : 0,
                        columnIndex: columnIndex
                    };
                    if (!isVertical && i > 0) {
                        var prevItemOffset = items.eq(i - 1).offset();
                        if (prevItemOffset.top < point.y) {
                            point.y = prevItemOffset.top
                        }
                    }
                    if (pointCreated) {
                        notCreatePoint = pointCreated(point)
                    }
                    if (!notCreatePoint) {
                        result.push(point)
                    }
                    columnIndex++
                }
                return result
            },
            getExpandCellTemplate: function() {
                return {
                    allowRenderToDetachedContainer: true,
                    render: function(container, options) {
                        var $container = (0, _renderer.default)(container);
                        if ((0, _type.isDefined)(options.value) && !(options.data && options.data.isContinuation) && !options.row.isNewRow) {
                            var rowsView = options.component.getView("rowsView");
                            $container.addClass(DATAGRID_EXPAND_CLASS).addClass(DATAGRID_SELECTION_DISABLED_CLASS);
                            (0, _renderer.default)("<div>").addClass(options.value ? DATAGRID_GROUP_OPENED_CLASS : DATAGRID_GROUP_CLOSED_CLASS).appendTo($container);
                            rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                        } else {
                            setEmptyText($container)
                        }
                    }
                }
            },
            setEmptyText: setEmptyText,
            isDateType: isDateType,
            getSelectionRange: function(focusedElement) {
                try {
                    if (focusedElement) {
                        return {
                            selectionStart: focusedElement.selectionStart,
                            selectionEnd: focusedElement.selectionEnd
                        }
                    }
                } catch (e) {}
                return {}
            },
            setSelectionRange: function(focusedElement, selectionRange) {
                try {
                    if (focusedElement && focusedElement.setSelectionRange) {
                        focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                    }
                } catch (e) {}
            },
            focusAndSelectElement: function(component, $element) {
                _events_engine.default.trigger($element, "focus");
                var isSelectTextOnEditingStart = component.option("editing.selectTextOnEditStart");
                var keyboardController = component.getController("keyboardNavigation");
                var isEditingNavigationMode = keyboardController && keyboardController._isFastEditingStarted();
                var element = $element.get(0);
                if (isSelectTextOnEditingStart && !isEditingNavigationMode && $element.is(".dx-texteditor-input") && !$element.is("[readonly]")) {
                    var editor = getWidgetInstance($element.closest(".dx-texteditor"));
                    (0, _deferred.when)(editor && editor._loadItemDeferred).done(function() {
                        element.select()
                    })
                }
            },
            getWidgetInstance: getWidgetInstance,
            getLastResizableColumnIndex: function(columns, resultWidths) {
                var hasResizableColumns = columns.some(function(column) {
                    return column && !column.command && !column.fixed && false !== column.allowResizing
                });
                var lastColumnIndex;
                for (lastColumnIndex = columns.length - 1; columns[lastColumnIndex]; lastColumnIndex--) {
                    var column = columns[lastColumnIndex];
                    var width = resultWidths && resultWidths[lastColumnIndex];
                    var allowResizing = !hasResizableColumns || false !== column.allowResizing;
                    if (!column.command && !column.fixed && "adaptiveHidden" !== width && allowResizing) {
                        break
                    }
                }
                return lastColumnIndex
            },
            isElementInCurrentGrid: function(controller, $element) {
                if ($element && $element.length) {
                    var $grid = $element.closest("." + controller.getWidgetContainerClass()).parent();
                    return $grid.is(controller.component.$element())
                }
                return false
            }
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled-npm/core/guid.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 15));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var Guid = _class.default.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        var _default = Guid;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled-npm/ui/button.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _utils = __webpack_require__( /*! ./widget/utils.ink_ripple */ 83);
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 9));
        var themes = _interopRequireWildcard(__webpack_require__( /*! ./themes */ 34));
        var _action = _interopRequireDefault(__webpack_require__( /*! ../core/action */ 110));
        var _validation_engine = _interopRequireDefault(__webpack_require__( /*! ./validation_engine */ 94));
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./widget/ui.widget */ 16));
        var _short = __webpack_require__( /*! ../events/short */ 128);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _function_template = __webpack_require__( /*! ../core/templates/function_template */ 126);
        var _icon = __webpack_require__( /*! ../core/utils/icon */ 57);
        var _element = __webpack_require__( /*! ../core/element */ 18);

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _get(target, property, receiver) {
            if ("undefined" !== typeof Reflect && Reflect.get) {
                _get = Reflect.get
            } else {
                _get = function(target, property, receiver) {
                    var base = _superPropBase(target, property);
                    if (!base) {
                        return
                    }
                    var desc = Object.getOwnPropertyDescriptor(base, property);
                    if (desc.get) {
                        return desc.get.call(receiver)
                    }
                    return desc.value
                }
            }
            return _get(target, property, receiver || target)
        }

        function _superPropBase(object, property) {
            while (!Object.prototype.hasOwnProperty.call(object, property)) {
                object = _getPrototypeOf(object);
                if (null === object) {
                    break
                }
            }
            return object
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var ANONYMOUS_TEMPLATE_NAME = "content";
        var Button = function(_Widget) {
            _inherits(Button, _Widget);
            var _super = _createSuper(Button);

            function Button() {
                var _this;
                _classCallCheck(this, Button);
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key]
                }
                _this = _super.call.apply(_super, [this].concat(args));
                _this._feedbackHideTimeout = 100;
                return _this
            }
            _createClass(Button, [{
                key: "_$content",
                value: function() {
                    return this.$element().find(".dx-button-content")
                }
            }, {
                key: "_$submitInput",
                value: function() {
                    return this.$element().find(".dx-button-submit-input")
                }
            }, {
                key: "_attachActiveEvents",
                value: function(active, inactive) {
                    var $el = this._eventBindingTarget();
                    var namespace = "inkRipple";
                    var selector = this._activeStateUnit;
                    _short.active.off($el, {
                        namespace: namespace,
                        selector: selector
                    });
                    _short.active.on($el, new _action.default(active), new _action.default(inactive, {
                        excludeValidators: ["disabled", "readOnly"]
                    }), {
                        showTimeout: this._feedbackShowTimeout,
                        hideTimeout: this._feedbackHideTimeout,
                        selector: selector,
                        namespace: namespace
                    })
                }
            }, {
                key: "_defaultOptionsRules",
                value: function() {
                    return _get(_getPrototypeOf(Button.prototype), "_defaultOptionsRules", this).call(this).concat([{
                        device: function() {
                            return "desktop" === _devices.default.real().deviceType && !_devices.default.isSimulator()
                        },
                        options: {
                            focusStateEnabled: true
                        }
                    }, {
                        device: function() {
                            return themes.isMaterial(themes.current())
                        },
                        options: {
                            useInkRipple: true
                        }
                    }])
                }
            }, {
                key: "_executeClickAction",
                value: function(event) {
                    this._clickAction({
                        validationGroup: this._validationGroupConfig,
                        event: event
                    })
                }
            }, {
                key: "_findGroup",
                value: function() {
                    var $element = this.$element();
                    var model = this._modelByElement($element);
                    var _this$option = this.option(),
                        validationGroup = _this$option.validationGroup;
                    return validationGroup || _validation_engine.default.findGroup($element, model)
                }
            }, {
                key: "_getContentData",
                value: function() {
                    var _this$option2 = this.option(),
                        icon = _this$option2.icon,
                        text = _this$option2.text,
                        type = _this$option2.type,
                        _templateData = _this$option2._templateData;
                    return (0, _extend.extend)({
                        icon: "back" === type && !icon ? "back" : icon,
                        text: text
                    }, _templateData)
                }
            }, {
                key: "_getDefaultOptions",
                value: function() {
                    return (0, _extend.extend)(_get(_getPrototypeOf(Button.prototype), "_getDefaultOptions", this).call(this), {
                        hoverStateEnabled: true,
                        onClick: null,
                        type: "normal",
                        text: "",
                        icon: "",
                        iconPosition: "left",
                        validationGroup: void 0,
                        activeStateEnabled: true,
                        template: "content",
                        useSubmitBehavior: false,
                        useInkRipple: false,
                        _templateData: {},
                        stylingMode: "contained"
                    })
                }
            }, {
                key: "_getSubmitAction",
                value: function() {
                    var _this2 = this;
                    var needValidate = true;
                    var validationStatus = "valid";
                    return this._createAction(function(_ref) {
                        var event = _ref.event;
                        if (needValidate) {
                            var validationGroup = _this2._validationGroupConfig;
                            if (validationGroup) {
                                var _validationGroup$vali = validationGroup.validate(),
                                    status = _validationGroup$vali.status,
                                    complete = _validationGroup$vali.complete;
                                validationStatus = status;
                                if ("pending" === status) {
                                    needValidate = false;
                                    _this2.option("disabled", true);
                                    complete.then(function(_ref2) {
                                        var status = _ref2.status;
                                        _this2.option("disabled", false);
                                        validationStatus = status;
                                        "valid" === validationStatus && _this2._submitInput().click();
                                        needValidate = true
                                    })
                                }
                            }
                        }
                        "valid" !== validationStatus && event.preventDefault();
                        event.stopPropagation()
                    })
                }
            }, {
                key: "_initMarkup",
                value: function() {
                    this.$element().addClass("dx-button");
                    this._renderType();
                    this._renderStylingMode();
                    this._renderInkRipple();
                    this._renderClick();
                    this._updateAriaLabel();
                    _get(_getPrototypeOf(Button.prototype), "_initMarkup", this).call(this);
                    this._updateContent();
                    this.setAria("role", "button")
                }
            }, {
                key: "_getAnonymousTemplateName",
                value: function() {
                    return ANONYMOUS_TEMPLATE_NAME
                }
            }, {
                key: "_initTemplates",
                value: function() {
                    var _this3 = this;
                    this._templateManager.addDefaultTemplates({
                        content: new _function_template.FunctionTemplate(function(_ref3) {
                            var _ref3$model = _ref3.model,
                                model = void 0 === _ref3$model ? {} : _ref3$model,
                                container = _ref3.container;
                            var text = model.text,
                                icon = model.icon;
                            var _this3$option = _this3.option(),
                                iconPosition = _this3$option.iconPosition;
                            var $icon = (0, _icon.getImageContainer)(icon);
                            var $textContainer = text && (0, _renderer.default)("<span>").text(text).addClass("dx-button-text");
                            var $container = (0, _renderer.default)(container);
                            $container.append($textContainer);
                            if ("left" === iconPosition) {
                                $container.prepend($icon)
                            } else {
                                $icon.addClass("dx-icon-right");
                                $container.append($icon)
                            }
                        })
                    });
                    _get(_getPrototypeOf(Button.prototype), "_initTemplates", this).call(this)
                }
            }, {
                key: "_optionChanged",
                value: function(args) {
                    var name = args.name,
                        previousValue = args.previousValue;
                    switch (name) {
                        case "onClick":
                            this._updateClick();
                            break;
                        case "icon":
                        case "text":
                            this._updateContent();
                            this._updateAriaLabel();
                            break;
                        case "type":
                            this._updateType(previousValue);
                            this._updateContent();
                            break;
                        case "_templateData":
                            break;
                        case "template":
                        case "iconPosition":
                            this._updateContent();
                            break;
                        case "stylingMode":
                            this._updateStylingMode();
                            break;
                        case "useSubmitBehavior":
                            this._updateSubmitInput();
                            break;
                        case "useInkRipple":
                            this._invalidate();
                            break;
                        default:
                            _get(_getPrototypeOf(Button.prototype), "_optionChanged", this).call(this, args)
                    }
                }
            }, {
                key: "_renderClick",
                value: function() {
                    var _this4 = this;
                    var $el = this.$element();
                    _short.dxClick.off($el, {
                        namespace: this.NAME
                    });
                    _short.dxClick.on($el, function(event) {
                        return _this4._executeClickAction(event)
                    }, {
                        namespace: this.NAME
                    });
                    this._updateClick()
                }
            }, {
                key: "_renderInkRipple",
                value: function() {
                    var _this5 = this;
                    var _this$option3 = this.option(),
                        text = _this$option3.text,
                        icon = _this$option3.icon,
                        type = _this$option3.type,
                        useInkRipple = _this$option3.useInkRipple;
                    if (useInkRipple) {
                        var isOnlyIconButton = !text && icon || "back" === type;
                        var _inkRipple = (0, _utils.render)(isOnlyIconButton ? {
                            waveSizeCoefficient: 1,
                            useHoldAnimation: false,
                            isCentered: true
                        } : {});
                        var changeWaveVisibility = function(event, visible) {
                            var _this5$option = _this5.option(),
                                activeStateEnabled = _this5$option.activeStateEnabled,
                                useInkRipple = _this5$option.useInkRipple;
                            if (useInkRipple && activeStateEnabled && !_this5._disposed) {
                                var config = {
                                    element: _this5._$content(),
                                    event: event
                                };
                                visible ? _inkRipple.showWave(config) : _inkRipple.hideWave(config)
                            }
                        };
                        this._attachActiveEvents(function(_ref4) {
                            var event = _ref4.event;
                            return changeWaveVisibility(event, true)
                        }, function(_ref5) {
                            var event = _ref5.event;
                            return changeWaveVisibility(event)
                        })
                    }
                }
            }, {
                key: "_renderStylingMode",
                value: function() {
                    var $element = this.$element();
                    var _this$option4 = this.option(),
                        stylingMode = _this$option4.stylingMode;
                    if (["contained", "text", "outlined"].indexOf(stylingMode) === -1) {
                        stylingMode = this._getDefaultOptions().stylingMode
                    }
                    $element.addClass("dx-button-mode-".concat(stylingMode))
                }
            }, {
                key: "_renderSubmitInput",
                value: function() {
                    var _this$option5 = this.option(),
                        useSubmitBehavior = _this$option5.useSubmitBehavior;
                    if (useSubmitBehavior) {
                        var submitAction = this._getSubmitAction();
                        var $content = this._$content();
                        (0, _renderer.default)("<input>").attr("type", "submit").attr("tabindex", -1).addClass("dx-button-submit-input").appendTo($content);
                        _short.click.on(this._$submitInput(), function(event) {
                            return submitAction({
                                event: event
                            })
                        })
                    }
                }
            }, {
                key: "_renderType",
                value: function() {
                    var _this$option6 = this.option(),
                        type = _this$option6.type;
                    var $element = this.$element();
                    type && $element.addClass("dx-button-".concat(type))
                }
            }, {
                key: "_submitInput",
                value: function() {
                    return this._$submitInput().get(0)
                }
            }, {
                key: "_supportedKeys",
                value: function() {
                    var _this6 = this;
                    var click = function(e) {
                        e.preventDefault();
                        _this6._executeClickAction(e)
                    };
                    return (0, _extend.extend)(_get(_getPrototypeOf(Button.prototype), "_supportedKeys", this).call(this), {
                        space: click,
                        enter: click
                    })
                }
            }, {
                key: "_updateAriaLabel",
                value: function() {
                    var ariaTarget = this._getAriaTarget();
                    var _this$option7 = this.option(),
                        icon = _this$option7.icon,
                        text = _this$option7.text;
                    if (!text) {
                        if ("image" === (0, _icon.getImageSourceType)(icon)) {
                            icon = icon.indexOf("base64") === -1 ? icon.replace(/.+\/([^.]+)\..+$/, "$1") : "Base64"
                        }
                        text = icon || ""
                    }
                    ariaTarget.attr("aria-label", text || null)
                }
            }, {
                key: "_updateClick",
                value: function() {
                    var _this7 = this;
                    this._clickAction = this._createActionByOption("onClick", {
                        excludeValidators: ["readOnly"],
                        afterExecute: function() {
                            var _this7$option = _this7.option(),
                                useSubmitBehavior = _this7$option.useSubmitBehavior;
                            useSubmitBehavior && setTimeout(function() {
                                return _this7._submitInput().click()
                            })
                        }
                    })
                }
            }, {
                key: "_updateContent",
                value: function() {
                    var $element = this.$element();
                    var $content = this._$content();
                    var data = this._getContentData();
                    var _this$option8 = this.option(),
                        template = _this$option8.template,
                        iconPosition = _this$option8.iconPosition;
                    var icon = data.icon,
                        text = data.text;
                    $content.length ? $content.empty() : $content = (0, _renderer.default)("<div>").addClass("dx-button-content").appendTo($element);
                    $element.toggleClass("dx-button-has-icon", !!icon).toggleClass("dx-button-icon-right", !!icon && "left" !== iconPosition).toggleClass("dx-button-has-text", !!text);
                    var $template = (0, _renderer.default)(this._getTemplateByOption("template").render({
                        model: data,
                        container: (0, _element.getPublicElement)($content),
                        transclude: this._templateManager.anonymousTemplateName === template
                    }));
                    if ($template.hasClass("dx-template-wrapper")) {
                        $template.addClass("dx-button-content");
                        $content.replaceWith($template)
                    }
                    this._updateSubmitInput()
                }
            }, {
                key: "_updateSubmitInput",
                value: function() {
                    var _this$option9 = this.option(),
                        useSubmitBehavior = _this$option9.useSubmitBehavior;
                    var $submitInput = this._$submitInput();
                    if (!useSubmitBehavior && $submitInput.length) {
                        $submitInput.remove()
                    } else {
                        if (useSubmitBehavior && !$submitInput.length) {
                            this._renderSubmitInput()
                        }
                    }
                }
            }, {
                key: "_updateStylingMode",
                value: function() {
                    var $element = this.$element();
                    ["contained", "text", "outlined"].map(function(mode) {
                        return "dx-button-mode-".concat(mode)
                    }).forEach($element.removeClass.bind($element));
                    this._renderStylingMode()
                }
            }, {
                key: "_updateType",
                value: function(previous) {
                    var $element = this.$element();
                    [previous, "back", "danger", "default", "normal", "success"].map(function(type) {
                        return "dx-button-".concat(type)
                    }).forEach($element.removeClass.bind($element));
                    this._renderType()
                }
            }, {
                key: "_validationGroupConfig",
                get: function() {
                    return _validation_engine.default.getGroupConfig(this._findGroup())
                }
            }]);
            return Button
        }(_ui.default);
        (0, _component_registrator.default)("dxButton", Button);
        var _default = Button;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/data/errors.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ../core/utils/error */ 144));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var handlers = {};
        var errors = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });
        var errorHandler = null;
        var _errorHandler = function(error) {
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        var _default = handlers;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/inflector.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.captionize = exports.titleize = exports.humanize = exports.camelize = exports.underscore = exports.dasherize = void 0;
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return (0, _iterator.map)(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        exports.dasherize = dasherize;
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        exports.underscore = underscore;
        var camelize = function(text, upperFirst) {
            return (0, _iterator.map)(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        exports.camelize = camelize;
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        exports.humanize = humanize;
        var titleize = function(text) {
            return (0, _iterator.map)(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        exports.titleize = titleize;
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var captionList = [];
            var i;
            var char;
            var isPrevCharNewWord = false;
            var isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.captionize = captionize
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/element_data.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getDataStrategy = getDataStrategy;
        exports.data = data;
        exports.beforeCleanData = beforeCleanData;
        exports.afterCleanData = afterCleanData;
        exports.cleanData = cleanData;
        exports.removeData = removeData;
        exports.cleanDataRecursive = cleanDataRecursive;
        exports.setDataStrategy = exports.strategyChanging = void 0;
        var _weak_map = _interopRequireDefault(__webpack_require__( /*! ./polyfills/weak_map */ 198));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ./dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _memorized_callbacks = _interopRequireDefault(__webpack_require__( /*! ./memorized_callbacks */ 199));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var dataMap = new _weak_map.default;
        var strategy;
        var strategyChanging = new _memorized_callbacks.default;
        exports.strategyChanging = strategyChanging;
        var beforeCleanDataFunc = function() {};
        var afterCleanDataFunc = function() {};
        var setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanDataFunc(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanDataFunc(nodes);
                return result
            }
        };
        exports.setDataStrategy = setDataStrategy;
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    _events_engine.default.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });

        function getDataStrategy() {
            return strategy
        }

        function data() {
            return strategy.data.apply(this, arguments)
        }

        function beforeCleanData(callback) {
            beforeCleanDataFunc = callback
        }

        function afterCleanData(callback) {
            afterCleanDataFunc = callback
        }

        function cleanData(nodes) {
            return strategy.cleanData.call(this, nodes)
        }

        function removeData(element, key) {
            return strategy.removeData.call(this, element, key)
        }

        function cleanDataRecursive(element, cleanSelf) {
            if (!_dom_adapter.default.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/data/utils.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/ready_callbacks */ 49));
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var ready = _ready_callbacks.default.add;
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return (0, _iterator.map)(info, function(i) {
                var result = {
                    selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                return result
            };
            var unloading;
            ready(function() {
                var window = (0, _window.getWindow)();
                _dom_adapter.default.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockCount = 0;
            var lockDeferred;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new _deferred.Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|&&|&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var names = (0, _iterator.map)(key1, function(v, k) {
                    return k
                });
                var name;
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if (!(0, _common.equalByValue)(key1[name], key2[name], 0, false)) {
                        return false
                    }
                }
                return true
            }
            return (0, _common.equalByValue)(key1, key2, 0, false)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i];
                var octet2 = input[i + 1];
                var octet3 = input[i + 2];
                result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };

        function stringToByteArray(str) {
            var bytes = [];
            var code;
            var i;
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        }
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var isGroupOperator = function(value) {
            return "and" === value || "or" === value
        };
        var isGroupCriterion = function(crit) {
            var first = crit[0];
            var second = crit[1];
            if (Array.isArray(first)) {
                return true
            }
            if ((0, _type.isFunction)(first)) {
                if (Array.isArray(second) || (0, _type.isFunction)(second) || isGroupOperator(second)) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new _deferred.Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new _deferred.Deferred;
            return d.reject.apply(d, arguments).promise()
        };

        function throttle(func, timeout) {
            var timeoutId;
            var lastArgs;
            return function() {
                var _this = this;
                lastArgs = arguments;
                if (!timeoutId) {
                    timeoutId = setTimeout(function() {
                        timeoutId = void 0;
                        if (lastArgs) {
                            func.call(_this, lastArgs)
                        }
                    }, (0, _type.isFunction)(timeout) ? timeout() : timeout)
                }
                return timeoutId
            }
        }

        function throttleChanges(func, timeout) {
            var cache = [];
            var throttled = throttle(function() {
                func.call(this, cache);
                cache = []
            }, timeout);
            return function(changes) {
                if (Array.isArray(changes)) {
                    var _cache;
                    (_cache = cache).push.apply(_cache, _toConsumableArray(changes))
                }
                return throttled.call(this, cache)
            }
        }
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            throttleChanges: throttleChanges,
            trivialPromise: trivialPromise,
            rejectedPromise: rejectedPromise,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            isGroupCriterion: isGroupCriterion,
            base64_encode: base64_encode
        };
        var _default = utils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/fx.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _translator = __webpack_require__( /*! ./translator */ 28);
        var _easing = __webpack_require__( /*! ./easing */ 253);
        var _frame = __webpack_require__( /*! ./frame */ 129);
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _position = _interopRequireDefault(__webpack_require__( /*! ./position */ 82));
        var _remove_event = _interopRequireDefault(__webpack_require__( /*! ../core/remove_event */ 150));
        var _index = __webpack_require__( /*! ../events/utils/index */ 8);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var window = (0, _window.getWindow)();
        var removeEventName = (0, _index.addNamespace)(_remove_event.default, "dxFX");
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
        var ANIM_DATA_KEY = "dxAnimData";
        var ANIM_QUEUE_KEY = "dxAnimQueue";
        var TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this;
                var deferred = new _deferred.Deferred;
                var cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            (0, _deferred.when)(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var that = this;
                var startTime = Date.now() + config.delay;
                var deferred = new _deferred.Deferred;
                var transitionEndFired = new _deferred.Deferred;
                var simulatedTransitionEndFired = new _deferred.Deferred;
                var simulatedEndEventTimer;
                var transitionEndEventFullName = (0, _support.transitionEndEventName)() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    _events_engine.default.off($element, transitionEndEventFullName);
                    _events_engine.default.off($element, removeEventName)
                };
                _events_engine.default.one($element, transitionEndEventFullName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                _events_engine.default.off($element, removeEventName);
                _events_engine.default.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                var waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    (0, _deferred.when)(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if ((0, _type.isPlainObject)(config.to)) {
                        (0, _iterator.each)(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new _deferred.Deferred;
                var that = this;
                if (!config) {
                    return deferred.reject().promise()
                }(0, _iterator.each)(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: (0, _easing.convertTransitionTimingFuncToEasing)(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = (0, _extend.extend)({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = (0, _iterator.map)(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return (0, _translator.getTranslateCss)(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                _events_engine.default.off($element, removeEventName);
                _events_engine.default.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                (0, _iterator.each)(transformString.match(/(\w|\d)+\([^)]*\)\s*/g), function(i, part) {
                    var translateData = (0, _translator.parseTranslate)(part);
                    var scaleData = part.match(/scale\((.+?)\)/);
                    var rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }(0, _frame.cancelAnimationFrame)(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = (0, _frame.requestAnimationFrame)(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration;
                        var t = currentDuration;
                        var b = 1 * from[propName];
                        var c = to[propName] - from[propName];
                        var d = frameAnimation.duration;
                        return (0, _easing.getEasing)(frameAnimation.easing)(x, t, b, c, d)
                    };
                    (0, _iterator.each)(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === _typeof(endPropValue) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new _deferred.Deferred).resolve().promise()
            },
            stop: _common.noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: (0, _support.transition)() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !(0, _support.transition)()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            (0, _iterator.each)(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw _errors.default.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return (0, _type.isPlainObject)(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = (0, _translator.locate)($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = (0, _extend.extend)({
                        of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                (0, _translator.clearCache)($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = (0, _translator.getTranslateCss)({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var from = config.from;
                var fromOpacity = (0, _type.isPlainObject)(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                var toOpacity;
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from;
                var to = config.to;
                var fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                var toOpacity = "opacity" in to ? to.opacity : 1;
                var fromScale = "scale" in from ? from.scale : 0;
                var toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = (0, _translator.getTranslate)($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return (0, _translator.getTranslateCss)(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw _errors.default.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
            type: "custom",
            from: {},
            to: {},
            duration: 400,
            start: _common.noop,
            complete: _common.noop,
            easing: "ease",
            delay: 0
        };
        var defaultCssConfig = {
            duration: 400,
            easing: "ease",
            delay: 0
        };

        function setupAnimationOnElement() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = (0, _element.getPublicElement)($element);
                config.start.apply(this, [element, config])
            }
        }
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element;
            var config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = (0, _element.getPublicElement)($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = (0, _index.addNamespace)(_remove_event.default, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            _events_engine.default.off(animation.element, scopedRemoveEvent);
            _events_engine.default.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                _events_engine.default.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
            var config = (0, _extend.extend)(true, {}, defaultConfig, initialConfig);
            var configurator = getAnimationConfigurator(config);
            var strategy = getAnimationStrategy(config);
            var animation = {
                element: (0, _renderer.default)(element),
                config: config,
                configurator: configurator,
                strategy: strategy,
                isSynchronous: strategy.isSynchronous,
                setup: setupAnimationOnElement,
                start: startAnimationOnElement,
                stop: stopAnimationOnElement,
                deferred: new _deferred.Deferred
            };
            if ((0, _type.isFunction)(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = (0, _renderer.default)(element);
            if (!$element.length) {
                return (new _deferred.Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };

        function pushInAnimationQueue($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        }

        function getAnimQueueData($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        }

        function writeAnimQueueData($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        }
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };

        function isAnimating($element) {
            return !!$element.data(ANIM_DATA_KEY)
        }

        function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        }

        function executeAnimation(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        }

        function setupPosition($element, config) {
            if (!config || !config.position) {
                return
            }
            var win = (0, _renderer.default)(window);
            var left = 0;
            var top = 0;
            var position = _position.default.calculate($element, config.position);
            var offset = $element.offset();
            var currentPosition = $element.position();
            if (currentPosition.top > offset.top) {
                top = win.scrollTop()
            }
            if (currentPosition.left > offset.left) {
                left = win.scrollLeft()
            }(0, _extend.extend)(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        }

        function setProps($element, props) {
            (0, _iterator.each)(props, function(key, value) {
                try {
                    $element.css(key, (0, _type.isFunction)(value) ? value() : value)
                } catch (e) {}
            })
        }
        var stop = function(element, jumpToEnd) {
            var $element = (0, _renderer.default)(element);
            var queueData = getAnimQueueData($element);
            (0, _iterator.each)(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        var _default = fx;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/string.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.isEmpty = exports.replaceAll = exports.format = exports.quadToObject = exports.encodeHtml = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        exports.encodeHtml = encodeHtml;
        var splitQuad = function(raw) {
            switch (_typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var quadToObject = function(raw) {
            var quad = splitQuad(raw);
            var left = parseInt(quad && quad[0], 10);
            var top = parseInt(quad && quad[1], 10);
            var right = parseInt(quad && quad[2], 10);
            var bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        exports.quadToObject = quadToObject;
        var format = function() {
            var s = arguments[0];
            var values = [].slice.call(arguments).slice(1);
            var replaceDollarCount;
            var reg;
            var value;
            if ((0, _type.isFunction)(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === (0, _type.type)(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        exports.format = format;
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        exports.replaceAll = replaceAll;
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.isEmpty = isEmpty
    },
    /*!***********************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/grid_core/ui.grid_core.modules.js ***!
      \***********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.errors */ 17));
        var _message = _interopRequireDefault(__webpack_require__( /*! ../../localization/message */ 10));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var WIDGET_WITH_LEGACY_CONTAINER_NAME = "dxDataGrid";
        var ModuleItem = _class.default.inherit({
            _endUpdateCore: function() {},
            ctor: function(component) {
                var that = this;
                that._updateLockCount = 0;
                that.component = component;
                that._actions = {};
                that._actionConfigs = {};
                (0, _iterator.each)(this.callbackNames() || [], function(index, name) {
                    var flags = that.callbackFlags(name) || {};
                    flags.unique = true, flags.syncStrategy = true;
                    that[this] = (0, _callbacks.default)(flags)
                })
            },
            init: function() {},
            callbackNames: function() {},
            callbackFlags: function() {},
            publicMethods: function() {},
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                if (this._updateLockCount > 0) {
                    this._updateLockCount--;
                    if (!this._updateLockCount) {
                        this._endUpdateCore()
                    }
                }
            },
            option: function(name) {
                var component = this.component;
                var optionCache = component._optionCache;
                if (1 === arguments.length && optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = component.option(name)
                    }
                    return optionCache[name]
                }
                return component.option.apply(component, arguments)
            },
            _silentOption: function(name, value) {
                var component = this.component;
                var optionCache = component._optionCache;
                if (optionCache) {
                    optionCache[name] = value
                }
                return component._setOptionWithoutOptionChange(name, value)
            },
            localize: function(name) {
                var optionCache = this.component._optionCache;
                if (optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = _message.default.format(name)
                    }
                    return optionCache[name]
                }
                return _message.default.format(name)
            },
            on: function() {
                return this.component.on.apply(this.component, arguments)
            },
            off: function() {
                return this.component.off.apply(this.component, arguments)
            },
            optionChanged: function(args) {
                if (args.name in this._actions) {
                    this.createAction(args.name, this._actionConfigs[args.name]);
                    args.handled = true
                }
            },
            getAction: function(actionName) {
                return this._actions[actionName]
            },
            setAria: function(name, value, $target) {
                var target = $target.get(0);
                var prefix = "role" !== name && "id" !== name ? "aria-" : "";
                if (target.setAttribute) {
                    target.setAttribute(prefix + name, value)
                } else {
                    $target.attr(prefix + name, value)
                }
            },
            _createComponent: function() {
                return this.component._createComponent.apply(this.component, arguments)
            },
            getController: function(name) {
                return this.component._controllers[name]
            },
            createAction: function(actionName, config) {
                if ((0, _type.isFunction)(actionName)) {
                    var action = this.component._createAction(actionName.bind(this), config);
                    return function(e) {
                        action({
                            event: e
                        })
                    }
                } else {
                    this._actions[actionName] = this.component._createActionByOption(actionName, config);
                    this._actionConfigs[actionName] = config
                }
            },
            executeAction: function(actionName, options) {
                var action = this._actions[actionName];
                return action && action(options)
            },
            dispose: function() {
                var that = this;
                (0, _iterator.each)(that.callbackNames() || [], function() {
                    that[this].empty()
                })
            },
            addWidgetPrefix: function(className) {
                var componentName = this.component.NAME;
                return "dx-" + componentName.slice(2).toLowerCase() + (className ? "-" + className : "")
            },
            getWidgetContainerClass: function() {
                var containerName = this.component.NAME === WIDGET_WITH_LEGACY_CONTAINER_NAME ? null : "container";
                return this.addWidgetPrefix(containerName)
            }
        });
        var Controller = ModuleItem;
        var ViewController = Controller.inherit({
            getView: function(name) {
                return this.component._views[name]
            },
            getViews: function() {
                return this.component._views
            }
        });
        var View = ModuleItem.inherit({
            _isReady: function() {
                return this.component.isReady()
            },
            _endUpdateCore: function() {
                this.callBase();
                if (!this._isReady() && this._requireReady) {
                    this._requireRender = false;
                    this.component._requireResize = false
                }
                if (this._requireRender) {
                    this._requireRender = false;
                    this.render(this._$parent)
                }
            },
            _invalidate: function(requireResize, requireReady) {
                this._requireRender = true;
                this.component._requireResize = (0, _window.hasWindow)() && (this.component._requireResize || requireResize);
                this._requireReady = this._requireReady || requireReady
            },
            _renderCore: function() {},
            _resizeCore: function() {},
            _afterRender: function() {},
            _parentElement: function() {
                return this._$parent
            },
            ctor: function(component) {
                this.callBase(component);
                this.renderCompleted = (0, _callbacks.default)();
                this.resizeCompleted = (0, _callbacks.default)()
            },
            element: function() {
                return this._$element
            },
            getElementHeight: function() {
                var $element = this.element();
                if (!$element) {
                    return 0
                }
                var marginTop = parseFloat($element.css("marginTop")) || 0;
                var marginBottom = parseFloat($element.css("marginBottom")) || 0;
                var offsetHeight = $element.get(0).offsetHeight;
                return offsetHeight + marginTop + marginBottom
            },
            isVisible: function() {
                return true
            },
            getTemplate: function(name) {
                return this.component._getTemplate(name)
            },
            render: function($parent, options) {
                var $element = this._$element;
                var isVisible = this.isVisible();
                if (!$element && !$parent) {
                    return
                }
                this._requireReady = false;
                if (!$element) {
                    $element = this._$element = (0, _renderer.default)("<div>").appendTo($parent);
                    this._$parent = $parent
                }
                $element.toggleClass("dx-hidden", !isVisible);
                if (isVisible) {
                    this.component._optionCache = {};
                    this._renderCore(options);
                    this.component._optionCache = void 0;
                    this._afterRender($parent);
                    this.renderCompleted.fire(options)
                }
            },
            resize: function() {
                this.isResizing = true;
                this._resizeCore();
                this.resizeCompleted.fire();
                this.isResizing = false
            },
            focus: function() {
                _events_engine.default.trigger(this.element(), "focus")
            }
        });
        var MODULES_ORDER_MAX_INDEX = 1e6;
        var processModules = function(that, componentClass) {
            var modules = componentClass.modules;
            var modulesOrder = componentClass.modulesOrder;
            var controllerTypes = componentClass.controllerTypes || {};
            var viewTypes = componentClass.viewTypes || {};
            if (!componentClass.controllerTypes) {
                if (modulesOrder) {
                    modules.sort(function(module1, module2) {
                        var orderIndex1 = (0, _array.inArray)(module1.name, modulesOrder);
                        var orderIndex2 = (0, _array.inArray)(module2.name, modulesOrder);
                        if (orderIndex1 < 0) {
                            orderIndex1 = MODULES_ORDER_MAX_INDEX
                        }
                        if (orderIndex2 < 0) {
                            orderIndex2 = MODULES_ORDER_MAX_INDEX
                        }
                        return orderIndex1 - orderIndex2
                    })
                }(0, _iterator.each)(modules, function() {
                    var controllers = this.controllers;
                    var moduleName = this.name;
                    var views = this.views;
                    controllers && (0, _iterator.each)(controllers, function(name, type) {
                        if (controllerTypes[name]) {
                            throw _ui.default.Error("E1001", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(Controller))) {
                                type.subclassOf(Controller);
                                throw _ui.default.Error("E1002", moduleName, name)
                            }
                        }
                        controllerTypes[name] = type
                    });
                    views && (0, _iterator.each)(views, function(name, type) {
                        if (viewTypes[name]) {
                            throw _ui.default.Error("E1003", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(View))) {
                                throw _ui.default.Error("E1004", moduleName, name)
                            }
                        }
                        viewTypes[name] = type
                    })
                });
                (0, _iterator.each)(modules, function() {
                    var extenders = this.extenders;
                    if (extenders) {
                        extenders.controllers && (0, _iterator.each)(extenders.controllers, function(name, extender) {
                            if (controllerTypes[name]) {
                                controllerTypes[name] = controllerTypes[name].inherit(extender)
                            }
                        });
                        extenders.views && (0, _iterator.each)(extenders.views, function(name, extender) {
                            if (viewTypes[name]) {
                                viewTypes[name] = viewTypes[name].inherit(extender)
                            }
                        })
                    }
                });
                componentClass.controllerTypes = controllerTypes;
                componentClass.viewTypes = viewTypes
            }
            var registerPublicMethods = function(that, name, moduleItem) {
                var publicMethods = moduleItem.publicMethods();
                if (publicMethods) {
                    (0, _iterator.each)(publicMethods, function(index, methodName) {
                        if (moduleItem[methodName]) {
                            if (!that[methodName]) {
                                that[methodName] = function() {
                                    return moduleItem[methodName].apply(moduleItem, arguments)
                                }
                            } else {
                                throw _ui.default.Error("E1005", methodName)
                            }
                        } else {
                            throw _ui.default.Error("E1006", name, methodName)
                        }
                    })
                }
            };
            var createModuleItems = function(moduleTypes) {
                var moduleItems = {};
                (0, _iterator.each)(moduleTypes, function(name, moduleType) {
                    var moduleItem = new moduleType(that);
                    moduleItem.name = name;
                    registerPublicMethods(that, name, moduleItem);
                    moduleItems[name] = moduleItem
                });
                return moduleItems
            };
            that._controllers = createModuleItems(controllerTypes);
            that._views = createModuleItems(viewTypes)
        };
        var callModuleItemsMethod = function(that, methodName, args) {
            args = args || [];
            if (that._controllers) {
                (0, _iterator.each)(that._controllers, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
            if (that._views) {
                (0, _iterator.each)(that._views, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
        };
        var _default = {
            modules: [],
            View: View,
            ViewController: ViewController,
            Controller: Controller,
            registerModule: function(name, module) {
                var modules = this.modules;
                for (var i = 0; i < modules.length; i++) {
                    if (modules[i].name === name) {
                        return
                    }
                }
                module.name = name;
                modules.push(module);
                delete this.controllerTypes;
                delete this.viewTypes
            },
            registerModulesOrder: function(moduleNames) {
                this.modulesOrder = moduleNames
            },
            unregisterModule: function(name) {
                this.modules = (0, _common.grep)(this.modules, function(module) {
                    return module.name !== name
                });
                delete this.controllerTypes;
                delete this.viewTypes
            },
            processModules: processModules,
            callModuleItemsMethod: callModuleItemsMethod
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/support.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "stylePropPrefix", {
            enumerable: true,
            get: function() {
                return _style.stylePropPrefix
            }
        });
        Object.defineProperty(exports, "styleProp", {
            enumerable: true,
            get: function() {
                return _style.styleProp
            }
        });
        exports.nativeScrolling = exports.animation = exports.transitionEndEventName = exports.transition = exports.touch = exports.inputType = exports.supportProp = exports.pointerEvents = exports.touchEvents = void 0;
        var _array = __webpack_require__( /*! ./array */ 13);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _common = __webpack_require__( /*! ./common */ 4);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));
        var _window = __webpack_require__( /*! ./window */ 7);
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../devices */ 14));
        var _style = __webpack_require__( /*! ./style */ 97);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _getNavigator = (0, _window.getNavigator)(),
            maxTouchPoints = _getNavigator.maxTouchPoints,
            msMaxTouchPoints = _getNavigator.msMaxTouchPoints,
            pointerEnabled = _getNavigator.pointerEnabled;
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!(0, _style.styleProp)(prop)
        };
        exports.supportProp = supportProp;
        var isNativeScrollingSupported = function() {
            var _devices$real = _devices.default.real(),
                platform = _devices$real.platform,
                version = _devices$real.version,
                isMac = _devices$real.mac;
            var isObsoleteAndroid = version && version[0] < 4 && "android" === platform;
            var isNativeScrollDevice = !isObsoleteAndroid && (0, _array.inArray)(platform, ["ios", "android"]) > -1 || isMac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = _dom_adapter.default.createElement("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        exports.inputType = inputType;
        var detectTouchEvents = function(hasWindowProperty, maxTouchPoints) {
            return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
        };
        var detectPointerEvent = function(hasWindowProperty, pointerEnabled) {
            var isPointerEnabled = (0, _common.ensureDefined)(pointerEnabled, true);
            var canUsePointerEvent = (0, _common.ensureDefined)(pointerEnabled, false);
            return hasWindowProperty("PointerEvent") && isPointerEnabled || canUsePointerEvent
        };
        var touchEvents = detectTouchEvents(_window.hasProperty, maxTouchPoints);
        exports.touchEvents = touchEvents;
        var pointerEvents = detectPointerEvent(_window.hasProperty, pointerEnabled);
        exports.pointerEvents = pointerEvents;
        var touchPointersPresent = !!maxTouchPoints || !!msMaxTouchPoints;
        var touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.touch = touch;
        var transition = (0, _call_once.default)(function() {
            return supportProp("transition")
        });
        exports.transition = transition;
        var transitionEndEventName = (0, _call_once.default)(function() {
            return transitionEndEventNames[(0, _style.styleProp)("transition")]
        });
        exports.transitionEndEventName = transitionEndEventName;
        var animation = (0, _call_once.default)(function() {
            return supportProp("animation")
        });
        exports.animation = animation;
        var nativeScrolling = isNativeScrollingSupported();
        exports.nativeScrolling = nativeScrolling
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled-npm/ui/popup.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _translator = __webpack_require__( /*! ../animation/translator */ 28);
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 9));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _empty_template = __webpack_require__( /*! ../core/templates/empty_template */ 89);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 22));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 39);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _size = __webpack_require__( /*! ../core/utils/size */ 194);
        var _position = __webpack_require__( /*! ../core/utils/position */ 23);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _version = __webpack_require__( /*! ../core/utils/version */ 62);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _visibility_change = __webpack_require__( /*! ../events/visibility_change */ 53);
        var _message = _interopRequireDefault(__webpack_require__( /*! ../localization/message */ 10));
        var _button = _interopRequireDefault(__webpack_require__( /*! ./button */ 37));
        var _overlay = _interopRequireDefault(__webpack_require__( /*! ./overlay */ 65));
        var _themes = __webpack_require__( /*! ./themes */ 34);
        __webpack_require__( /*! ./toolbar/ui.toolbar.base */ 336);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var POPUP_CLASS = "dx-popup";
        var POPUP_WRAPPER_CLASS = "dx-popup-wrapper";
        var POPUP_FULL_SCREEN_CLASS = "dx-popup-fullscreen";
        var POPUP_FULL_SCREEN_WIDTH_CLASS = "dx-popup-fullscreen-width";
        var POPUP_NORMAL_CLASS = "dx-popup-normal";
        var POPUP_CONTENT_CLASS = "dx-popup-content";
        var POPUP_DRAGGABLE_CLASS = "dx-popup-draggable";
        var POPUP_TITLE_CLASS = "dx-popup-title";
        var POPUP_TITLE_CLOSEBUTTON_CLASS = "dx-closebutton";
        var POPUP_BOTTOM_CLASS = "dx-popup-bottom";
        var TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper";
        var POPUP_CONTENT_FLEX_HEIGHT_CLASS = "dx-popup-flex-height";
        var POPUP_CONTENT_INHERIT_HEIGHT_CLASS = "dx-popup-inherit-height";
        var ALLOWED_TOOLBAR_ITEM_ALIASES = ["cancel", "clear", "done"];
        var BUTTON_DEFAULT_TYPE = "default";
        var BUTTON_NORMAL_TYPE = "normal";
        var BUTTON_TEXT_MODE = "text";
        var BUTTON_CONTAINED_MODE = "contained";
        var IS_IE11 = _browser.default.msie && 11 === parseInt(_browser.default.version);
        var IS_OLD_SAFARI = _browser.default.safari && (0, _version.compare)(_browser.default.version, [11]) < 0;
        var HEIGHT_STRATEGIES = {
            "static": "",
            inherit: POPUP_CONTENT_INHERIT_HEIGHT_CLASS,
            flex: POPUP_CONTENT_FLEX_HEIGHT_CLASS
        };
        var getButtonPlace = function(name) {
            var device = _devices.default.current();
            var platform = device.platform;
            var toolbar = "bottom";
            var location = "before";
            if ("ios" === platform) {
                switch (name) {
                    case "cancel":
                        toolbar = "top";
                        break;
                    case "clear":
                        toolbar = "top";
                        location = "after";
                        break;
                    case "done":
                        location = "after"
                }
            } else {
                if ("android" === platform && device.version && parseInt(device.version[0]) > 4) {
                    switch (name) {
                        case "cancel":
                            location = "after";
                            break;
                        case "done":
                            location = "after"
                    }
                } else {
                    if ("android" === platform) {
                        location = "center"
                    }
                }
            }
            return {
                toolbar: toolbar,
                location: location
            }
        };
        var Popup = _overlay.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    fullScreen: false,
                    title: "",
                    showTitle: true,
                    titleTemplate: "title",
                    onTitleRendered: null,
                    dragEnabled: false,
                    toolbarItems: [],
                    showCloseButton: false,
                    bottomTemplate: "bottom",
                    useDefaultToolbarButtons: false,
                    useFlatToolbarButtons: false,
                    autoResizeEnabled: true
                })
            },
            _defaultOptionsRules: function() {
                var themeName = (0, _themes.current)();
                return this.callBase().concat([{
                    device: {
                        platform: "ios"
                    },
                    options: {
                        animation: this._iosAnimation
                    }
                }, {
                    device: {
                        platform: "android"
                    },
                    options: {
                        animation: this._androidAnimation
                    }
                }, {
                    device: {
                        platform: "generic"
                    },
                    options: {
                        showCloseButton: true
                    }
                }, {
                    device: function(_device) {
                        return "desktop" === _devices.default.real().deviceType && "generic" === _device.platform
                    },
                    options: {
                        dragEnabled: true
                    }
                }, {
                    device: function() {
                        return "desktop" === _devices.default.real().deviceType && !_devices.default.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return (0, _themes.isMaterial)(themeName)
                    },
                    options: {
                        useDefaultToolbarButtons: true,
                        useFlatToolbarButtons: true
                    }
                }])
            },
            _iosAnimation: {
                show: {
                    type: "slide",
                    duration: 400,
                    from: {
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    },
                    to: {
                        position: {
                            my: "center",
                            at: "center"
                        }
                    }
                },
                hide: {
                    type: "slide",
                    duration: 400,
                    from: {
                        opacity: 1,
                        position: {
                            my: "center",
                            at: "center"
                        }
                    },
                    to: {
                        opacity: 1,
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    }
                }
            },
            _androidAnimation: function() {
                var fullScreenConfig = {
                    show: {
                        type: "slide",
                        duration: 300,
                        from: {
                            top: "30%",
                            opacity: 0
                        },
                        to: {
                            top: 0,
                            opacity: 1
                        }
                    },
                    hide: {
                        type: "slide",
                        duration: 300,
                        from: {
                            top: 0,
                            opacity: 1
                        },
                        to: {
                            top: "30%",
                            opacity: 0
                        }
                    }
                };
                var defaultConfig = {
                    show: {
                        type: "fade",
                        duration: 400,
                        from: 0,
                        to: 1
                    },
                    hide: {
                        type: "fade",
                        duration: 400,
                        from: 1,
                        to: 0
                    }
                };
                return this.option("fullScreen") ? fullScreenConfig : defaultConfig
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(POPUP_CLASS);
                this._wrapper().addClass(POPUP_WRAPPER_CLASS);
                this._$popupContent = this._$content.wrapInner((0, _renderer.default)("<div>").addClass(POPUP_CONTENT_CLASS)).children().eq(0)
            },
            _render: function() {
                var isFullscreen = this.option("fullScreen");
                this._toggleFullScreenClass(isFullscreen);
                this.callBase()
            },
            _toggleFullScreenClass: function(value) {
                this._$content.toggleClass(POPUP_FULL_SCREEN_CLASS, value).toggleClass(POPUP_NORMAL_CLASS, !value)
            },
            _initTemplates: function() {
                this.callBase();
                this._templateManager.addDefaultTemplates({
                    title: new _empty_template.EmptyTemplate,
                    bottom: new _empty_template.EmptyTemplate
                })
            },
            _renderContentImpl: function() {
                this._renderTitle();
                this.callBase();
                this._renderBottom()
            },
            _renderTitle: function() {
                var items = this._getToolbarItems("top");
                var titleText = this.option("title");
                var showTitle = this.option("showTitle");
                if (showTitle && !!titleText) {
                    items.unshift({
                        location: _devices.default.current().ios ? "center" : "before",
                        text: titleText
                    })
                }
                if (showTitle || items.length > 0) {
                    this._$title && this._$title.remove();
                    var $title = (0, _renderer.default)("<div>").addClass(POPUP_TITLE_CLASS).insertBefore(this.$content());
                    this._$title = this._renderTemplateByType("titleTemplate", items, $title).addClass(POPUP_TITLE_CLASS);
                    this._renderDrag();
                    this._executeTitleRenderAction(this._$title)
                } else {
                    if (this._$title) {
                        this._$title.detach()
                    }
                }
            },
            _renderTemplateByType: function(optionName, data, $container, additionalToolbarOptions) {
                var template = this._getTemplateByOption(optionName);
                var toolbarTemplate = template instanceof _empty_template.EmptyTemplate;
                if (toolbarTemplate) {
                    var integrationOptions = (0, _extend.extend)({}, this.option("integrationOptions"), {
                        skipTemplates: ["content", "title"]
                    });
                    var toolbarOptions = (0, _extend.extend)(additionalToolbarOptions, {
                        items: data,
                        rtlEnabled: this.option("rtlEnabled"),
                        useDefaultButtons: this.option("useDefaultToolbarButtons"),
                        useFlatButtons: this.option("useFlatToolbarButtons"),
                        integrationOptions: integrationOptions
                    });
                    this._getTemplate("dx-polymorph-widget").render({
                        container: $container,
                        model: {
                            widget: "dxToolbarBase",
                            options: toolbarOptions
                        }
                    });
                    var $toolbar = $container.children("div");
                    $container.replaceWith($toolbar);
                    return $toolbar
                } else {
                    var $result = (0, _renderer.default)(template.render({
                        container: (0, _element.getPublicElement)($container)
                    }));
                    if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                        $container.replaceWith($result);
                        $container = $result
                    }
                    return $container
                }
            },
            _executeTitleRenderAction: function($titleElement) {
                this._getTitleRenderAction()({
                    titleElement: (0, _element.getPublicElement)($titleElement)
                })
            },
            _getTitleRenderAction: function() {
                return this._titleRenderAction || this._createTitleRenderAction()
            },
            _createTitleRenderAction: function() {
                return this._titleRenderAction = this._createActionByOption("onTitleRendered", {
                    element: this.element(),
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _getCloseButton: function() {
                return {
                    toolbar: "top",
                    location: "after",
                    template: this._getCloseButtonRenderer()
                }
            },
            _getCloseButtonRenderer: function() {
                var _this = this;
                return function(_, __, container) {
                    var $button = (0, _renderer.default)("<div>").addClass(POPUP_TITLE_CLOSEBUTTON_CLASS);
                    _this._createComponent($button, _button.default, {
                        icon: "close",
                        onClick: _this._createToolbarItemAction(void 0),
                        integrationOptions: {}
                    });
                    (0, _renderer.default)(container).append($button)
                }
            },
            _getToolbarItems: function(toolbar) {
                var _this2 = this;
                var toolbarItems = this.option("toolbarItems");
                var toolbarsItems = [];
                this._toolbarItemClasses = [];
                var currentPlatform = _devices.default.current().platform;
                var index = 0;
                (0, _iterator.each)(toolbarItems, function(_, data) {
                    var isShortcut = (0, _type.isDefined)(data.shortcut);
                    var item = isShortcut ? getButtonPlace(data.shortcut) : data;
                    if (isShortcut && "ios" === currentPlatform && index < 2) {
                        item.toolbar = "top";
                        index++
                    }
                    item.toolbar = data.toolbar || item.toolbar || "top";
                    if (item && item.toolbar === toolbar) {
                        if (isShortcut) {
                            (0, _extend.extend)(item, {
                                location: data.location
                            }, _this2._getToolbarItemByAlias(data))
                        }
                        var isLTROrder = "generic" === currentPlatform;
                        if ("done" === data.shortcut && isLTROrder || "cancel" === data.shortcut && !isLTROrder) {
                            toolbarsItems.unshift(item)
                        } else {
                            toolbarsItems.push(item)
                        }
                    }
                });
                if ("top" === toolbar && this.option("showCloseButton") && this.option("showTitle")) {
                    toolbarsItems.push(this._getCloseButton())
                }
                return toolbarsItems
            },
            _getLocalizationKey: function(itemType) {
                return "done" === itemType.toLowerCase() ? "OK" : (0, _inflector.camelize)(itemType, true)
            },
            _getToolbarItemByAlias: function(data) {
                var that = this;
                var itemType = data.shortcut;
                if ((0, _array.inArray)(itemType, ALLOWED_TOOLBAR_ITEM_ALIASES) < 0) {
                    return false
                }
                var itemConfig = (0, _extend.extend)({
                    text: _message.default.format(this._getLocalizationKey(itemType)),
                    onClick: this._createToolbarItemAction(data.onClick),
                    integrationOptions: {},
                    type: that.option("useDefaultToolbarButtons") ? BUTTON_DEFAULT_TYPE : BUTTON_NORMAL_TYPE,
                    stylingMode: that.option("useFlatToolbarButtons") ? BUTTON_TEXT_MODE : BUTTON_CONTAINED_MODE
                }, data.options || {});
                var itemClass = POPUP_CLASS + "-" + itemType;
                this._toolbarItemClasses.push(itemClass);
                return {
                    template: function(_, __, container) {
                        var $toolbarItem = (0, _renderer.default)("<div>").addClass(itemClass).appendTo(container);
                        that._createComponent($toolbarItem, _button.default, itemConfig)
                    }
                }
            },
            _createToolbarItemAction: function(clickAction) {
                return this._createAction(clickAction, {
                    afterExecute: function(e) {
                        e.component.hide()
                    }
                })
            },
            _renderBottom: function() {
                var items = this._getToolbarItems("bottom");
                if (items.length) {
                    this._$bottom && this._$bottom.remove();
                    var $bottom = (0, _renderer.default)("<div>").addClass(POPUP_BOTTOM_CLASS).insertAfter(this.$content());
                    this._$bottom = this._renderTemplateByType("bottomTemplate", items, $bottom, {
                        compactMode: true
                    }).addClass(POPUP_BOTTOM_CLASS);
                    this._toggleClasses()
                } else {
                    this._$bottom && this._$bottom.detach()
                }
            },
            _toggleClasses: function() {
                var _this3 = this;
                var aliases = ALLOWED_TOOLBAR_ITEM_ALIASES;
                (0, _iterator.each)(aliases, function(_, alias) {
                    var className = POPUP_CLASS + "-" + alias;
                    if ((0, _array.inArray)(className, _this3._toolbarItemClasses) >= 0) {
                        _this3._wrapper().addClass(className + "-visible");
                        _this3._$bottom.addClass(className)
                    } else {
                        _this3._wrapper().removeClass(className + "-visible");
                        _this3._$bottom.removeClass(className)
                    }
                })
            },
            _getContainer: function() {
                if (this.option("fullScreen")) {
                    return (0, _renderer.default)(window)
                }
                return this.callBase()
            },
            _getDragTarget: function() {
                return this.topToolbar()
            },
            _renderGeometryImpl: function(isDimensionChanged) {
                if (!isDimensionChanged) {
                    this._resetContentHeight()
                }
                this.callBase.apply(this, arguments);
                this._setContentHeight()
            },
            _resetContentHeight: function() {
                this._$popupContent.css({
                    height: "auto",
                    maxHeight: "none"
                })
            },
            _renderDrag: function() {
                this.callBase();
                this._$content.toggleClass(POPUP_DRAGGABLE_CLASS, this.option("dragEnabled"))
            },
            _renderResize: function() {
                this.callBase();
                this._resizable.option("onResize", function() {
                    this._setContentHeight();
                    this._actions.onResize(arguments)
                }.bind(this))
            },
            _setContentHeight: function() {
                (this.option("forceApplyBindings") || _common.noop)();
                var overlayContent = this.overlayContent().get(0);
                var currentHeightStrategyClass = this._chooseHeightStrategy(overlayContent);
                this.$content().css(this._getHeightCssStyles(currentHeightStrategyClass, overlayContent));
                this._setHeightClasses(this.overlayContent(), currentHeightStrategyClass)
            },
            _heightStrategyChangeOffset: function(currentHeightStrategyClass, popupVerticalPaddings) {
                return currentHeightStrategyClass === HEIGHT_STRATEGIES.flex ? -popupVerticalPaddings : 0
            },
            _chooseHeightStrategy: function(overlayContent) {
                var isAutoWidth = "auto" === overlayContent.style.width || "" === overlayContent.style.width;
                var currentHeightStrategyClass = HEIGHT_STRATEGIES.static;
                if (this._isAutoHeight() && this.option("autoResizeEnabled")) {
                    if (isAutoWidth || IS_OLD_SAFARI) {
                        if (!IS_IE11) {
                            currentHeightStrategyClass = HEIGHT_STRATEGIES.inherit
                        }
                    } else {
                        currentHeightStrategyClass = HEIGHT_STRATEGIES.flex
                    }
                }
                return currentHeightStrategyClass
            },
            _getHeightCssStyles: function(currentHeightStrategyClass, overlayContent) {
                var cssStyles = {};
                var contentMaxHeight = this._getOptionValue("maxHeight", overlayContent);
                var contentMinHeight = this._getOptionValue("minHeight", overlayContent);
                var popupHeightParts = this._splitPopupHeight();
                var toolbarsAndVerticalOffsetsHeight = popupHeightParts.header + popupHeightParts.footer + popupHeightParts.contentVerticalOffsets + popupHeightParts.popupVerticalOffsets + this._heightStrategyChangeOffset(currentHeightStrategyClass, popupHeightParts.popupVerticalPaddings);
                if (currentHeightStrategyClass === HEIGHT_STRATEGIES.static) {
                    if (!this._isAutoHeight() || contentMaxHeight || contentMinHeight) {
                        var overlayHeight = this.option("fullScreen") ? Math.min((0, _position.getBoundingRect)(overlayContent).height, (0, _window.getWindow)().innerHeight) : (0, _position.getBoundingRect)(overlayContent).height;
                        var contentHeight = overlayHeight - toolbarsAndVerticalOffsetsHeight;
                        cssStyles = {
                            height: Math.max(0, contentHeight),
                            minHeight: "auto",
                            maxHeight: "auto"
                        }
                    }
                } else {
                    var container = (0, _renderer.default)(this._getContainer()).get(0);
                    var maxHeightValue = (0, _size.addOffsetToMaxHeight)(contentMaxHeight, -toolbarsAndVerticalOffsetsHeight, container);
                    var minHeightValue = (0, _size.addOffsetToMinHeight)(contentMinHeight, -toolbarsAndVerticalOffsetsHeight, container);
                    cssStyles = {
                        height: "auto",
                        minHeight: minHeightValue,
                        maxHeight: maxHeightValue
                    }
                }
                return cssStyles
            },
            _setHeightClasses: function($container, currentClass) {
                var excessClasses = "";
                for (var name in HEIGHT_STRATEGIES) {
                    if (HEIGHT_STRATEGIES[name] !== currentClass) {
                        excessClasses += " " + HEIGHT_STRATEGIES[name]
                    }
                }
                $container.removeClass(excessClasses).addClass(currentClass)
            },
            _isAutoHeight: function() {
                return "auto" === this.overlayContent().get(0).style.height
            },
            _splitPopupHeight: function() {
                var topToolbar = this.topToolbar();
                var bottomToolbar = this.bottomToolbar();
                return {
                    header: (0, _size.getVisibleHeight)(topToolbar && topToolbar.get(0)),
                    footer: (0, _size.getVisibleHeight)(bottomToolbar && bottomToolbar.get(0)),
                    contentVerticalOffsets: (0, _size.getVerticalOffsets)(this.overlayContent().get(0), true),
                    popupVerticalOffsets: (0, _size.getVerticalOffsets)(this.$content().get(0), true),
                    popupVerticalPaddings: (0, _size.getVerticalOffsets)(this.$content().get(0), false)
                }
            },
            _useFixedPosition: function() {
                return this.callBase() || this.option("fullScreen")
            },
            _toggleSafariFullScreen: function(value) {
                var toggleFullScreenBeforeShown = this._useFixedPosition() && value && !this._isShown;
                if (toggleFullScreenBeforeShown) {
                    this._bodyScrollTop = value ? window.pageYOffset : void 0
                } else {
                    this._toggleSafariScrolling(!value)
                }
            },
            _renderDimensions: function() {
                if (this.option("fullScreen")) {
                    this._$content.css({
                        width: "100%",
                        height: "100%",
                        minWidth: "",
                        maxWidth: "",
                        minHeight: "",
                        maxHeight: ""
                    })
                } else {
                    this.callBase.apply(this, arguments)
                }
                if ((0, _window.hasWindow)()) {
                    this._renderFullscreenWidthClass()
                }
            },
            _renderFullscreenWidthClass: function() {
                this.overlayContent().toggleClass(POPUP_FULL_SCREEN_WIDTH_CLASS, this.overlayContent().outerWidth() === (0, _renderer.default)(window).width())
            },
            refreshPosition: function() {
                this._renderPosition()
            },
            _renderPosition: function() {
                if (this.option("fullScreen")) {
                    (0, _translator.move)(this._$content, {
                        top: 0,
                        left: 0
                    })
                } else {
                    (this.option("forceApplyBindings") || _common.noop)();
                    return this.callBase.apply(this, arguments)
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "showTitle":
                    case "title":
                    case "titleTemplate":
                        this._renderTitle();
                        this._renderGeometry();
                        (0, _visibility_change.triggerResizeEvent)(this._$content);
                        break;
                    case "bottomTemplate":
                        this._renderBottom();
                        this._renderGeometry();
                        (0, _visibility_change.triggerResizeEvent)(this._$content);
                        break;
                    case "onTitleRendered":
                        this._createTitleRenderAction(args.value);
                        break;
                    case "toolbarItems":
                    case "useDefaultToolbarButtons":
                    case "useFlatToolbarButtons":
                        var shouldRenderGeometry = !args.fullName.match(/^toolbarItems((\[\d+\])(\.(options|visible).*)?)?$/);
                        this._renderTitle();
                        this._renderBottom();
                        if (shouldRenderGeometry) {
                            this._renderGeometry();
                            (0, _visibility_change.triggerResizeEvent)(this._$content)
                        }
                        break;
                    case "dragEnabled":
                        this._renderDrag();
                        break;
                    case "autoResizeEnabled":
                        this._renderGeometry();
                        (0, _visibility_change.triggerResizeEvent)(this._$content);
                        break;
                    case "fullScreen":
                        this._toggleFullScreenClass(args.value);
                        this._toggleSafariFullScreen(args.value);
                        this._renderGeometry();
                        (0, _visibility_change.triggerResizeEvent)(this._$content);
                        break;
                    case "showCloseButton":
                        this._renderTitle();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            bottomToolbar: function() {
                return this._$bottom
            },
            topToolbar: function() {
                return this._$title
            },
            $content: function() {
                return this._$popupContent
            },
            content: function() {
                return (0, _element.getPublicElement)(this._$popupContent)
            },
            overlayContent: function() {
                return this._$content
            }
        });
        (0, _component_registrator.default)("dxPopup", Popup);
        var _default = Popup;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/number.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = __webpack_require__( /*! ./ldml/number */ 322);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 31));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _utils = __webpack_require__( /*! ./utils */ 240);
        var _currency = _interopRequireDefault(__webpack_require__( /*! ./currency */ 113));
        var _number2 = _interopRequireDefault(__webpack_require__( /*! ./intl/number */ 492));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _slicedToArray(arr, i) {
            return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest()
        }

        function _nonIterableRest() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function _iterableToArrayLimit(arr, i) {
            if ("undefined" === typeof Symbol || !(Symbol.iterator in Object(arr))) {
                return
            }
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) {
                        break
                    }
                }
            } catch (err) {
                _d = true;
                _e = err
            } finally {
                try {
                    if (!_n && null != _i.return) {
                        _i.return()
                    }
                } finally {
                    if (_d) {
                        throw _e
                    }
                }
            }
            return _arr
        }

        function _arrayWithHoles(arr) {
            if (Array.isArray(arr)) {
                return arr
            }
        }
        var hasIntl = "undefined" !== typeof Intl;
        var MAX_LARGE_NUMBER_POWER = 4;
        var DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                var formatList = formatType.toLowerCase().split(" ");
                (0, _iterator.each)(formatList, function(index, value) {
                    if ((0, _array.inArray)(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value);
                var power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                var powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                var result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var power = this._calculateNumberPower(value, DECIMAL_BASE);
                var number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                var powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, (0, _config.default)().thousandsSeparator) + (parts[1] ? (0, _config.default)().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : (0, _utils.toFixed)(value, formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", (0, _config.default)().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!(0, _type.isPlainObject)(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e4, "fixedPoint")[2]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0";
                var toFirstDigit = toStandard ? "0" : digits[1];
                var fromLastDigit = toStandard ? digits[0] : "9";
                var regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getNegativeEtalonRegExp: function(format) {
                var separators = this._getSeparators();
                var digitalRegExp = new RegExp("[0-9" + (0, _common.escapeRegExp)(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g");
                var specialCharacters = ["\\", "(", ")", "[", "]", "*", "+", "$", "^", "?", "|", "{", "}"];
                var negativeEtalon = this.format(-1, format).replace(digitalRegExp, "1");
                specialCharacters.forEach(function(char) {
                    negativeEtalon = negativeEtalon.replace(char, "\\".concat(char))
                });
                negativeEtalon = negativeEtalon.replace(" ", "\\s");
                negativeEtalon = negativeEtalon.replace("1", ".+");
                return new RegExp(negativeEtalon, "g")
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var negativeEtalon = this.getNegativeEtalonRegExp(format);
                return text.match(negativeEtalon) ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    var formatterConfig = this._getSeparators();
                    formatterConfig.unlimitedIntegerDigits = _format.unlimitedIntegerDigits;
                    return this.convertDigits((0, _number.getFormatter)(_format.type, formatterConfig)(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    _errors.default.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator();
                var regExp = new RegExp("[^0-9" + (0, _common.escapeRegExp)(decimalSeparator) + "]", "g");
                var cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, "");
                if ("." === cleanedText || "" === cleanedText) {
                    return null
                }
                if (this._calcSignificantDigits(cleanedText) > 15) {
                    return NaN
                }
                var parsed = +cleanedText * this.getSign(text, format);
                format = this._normalizeFormat(format);
                var formatConfig = this._parseNumberFormatString(format.type);
                var power = null === formatConfig || void 0 === formatConfig ? void 0 : formatConfig.power;
                if (power) {
                    if ("auto" === power) {
                        var match = text.match(/\d(K|M|B|T)/);
                        if (match) {
                            power = (0, _array.find)(Object.keys(LargeNumberFormatPostfixes), function(power) {
                                return LargeNumberFormatPostfixes[power] === match[1]
                            })
                        }
                    }
                    parsed *= Math.pow(10, 3 * power)
                }
                if ("percent" === (null === formatConfig || void 0 === formatConfig ? void 0 : formatConfig.formatType)) {
                    parsed /= 100
                }
                return parsed
            },
            _calcSignificantDigits: function(text) {
                var _text$split = text.split("."),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    integer = _text$split2[0],
                    fractional = _text$split2[1];
                var calcDigitsAfterLeadingZeros = function(digits) {
                    var index = -1;
                    for (var i = 0; i < digits.length; i++) {
                        if ("0" !== digits[i]) {
                            index = i;
                            break
                        }
                    }
                    return index > -1 ? digits.length - index : 0
                };
                var result = 0;
                if (integer) {
                    result += calcDigitsAfterLeadingZeros(integer.split(""))
                }
                if (fractional) {
                    result += calcDigitsAfterLeadingZeros(fractional.split("").reverse())
                }
                return result
            }
        });
        numberLocalization.inject(_currency.default);
        if (hasIntl) {
            numberLocalization.inject(_number2.default)
        }
        var _default = numberLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/data/query.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _query_implementation = __webpack_require__( /*! ./query_implementation */ 251);
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return _query_implementation.queryImpl[impl].apply(this, arguments)
        };
        var _default = query;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/ready_callbacks.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));
        var _window = __webpack_require__( /*! ./window */ 7);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var callbacks = [];
        var isReady = function() {
            return "complete" === _dom_adapter.default.getReadyState() || "loading" !== _dom_adapter.default.getReadyState() && !_dom_adapter.default.getDocumentElement().doScroll
        };
        var subscribeReady = (0, _call_once.default)(function() {
            var removeListener = _dom_adapter.default.listen(_dom_adapter.default.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var windowExists = (0, _window.hasWindow)();
                if (windowExists && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    windowExists && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    return callback()
                });
                callbacks = []
            }
        };
        var _default = (0, _dependency_injector.default)(readyCallbacks);
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/object.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.deepExtendArraySafe = exports.orderEach = exports.clone = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ./variable_wrapper */ 101));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        exports.clone = clone;
        var orderEach = function(map, func) {
            var keys = [];
            var key;
            var i;
            for (key in map) {
                if (Object.prototype.hasOwnProperty.call(map, key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = (0, _type.isNumeric)(x);
                var isNumberY = (0, _type.isNumeric)(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        exports.orderEach = orderEach;
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && _variable_wrapper.default.isWrapped(target[property])) {
                _variable_wrapper.default.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue;
            var newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if ("__proto__" === name || target === newValue) {
                    continue
                }
                if ((0, _type.isPlainObject)(newValue)) {
                    var goDeeper = extendComplexObject ? (0, _type.isObject)(prevValue) : (0, _type.isPlainObject)(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/editor/editor.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 40);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.widget */ 16));
        var _validation_engine = _interopRequireDefault(__webpack_require__( /*! ../validation_engine */ 94));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _validation_message = _interopRequireDefault(__webpack_require__( /*! ../validation_message */ 542));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 36));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var INVALID_MESSAGE_AUTO = "dx-invalid-message-auto";
        var READONLY_STATE_CLASS = "dx-state-readonly";
        var INVALID_CLASS = "dx-invalid";
        var DX_INVALID_BADGE_CLASS = "dx-show-invalid-badge";
        var VALIDATION_TARGET = "dx-validation-target";
        var VALIDATION_STATUS_VALID = "valid";
        var VALIDATION_STATUS_INVALID = "invalid";
        var READONLY_NAMESPACE = "editorReadOnly";
        var VALIDATION_MESSAGE_KEYS_MAP = {
            validationMessageMode: "mode",
            validationMessageOffset: "offset",
            validationBoundary: "boundary"
        };
        var Editor = _ui.default.inherit({
            ctor: function() {
                this.showValidationMessageTimeout = null;
                this.validationRequest = (0, _callbacks.default)();
                this.callBase.apply(this, arguments)
            },
            _createElement: function(element) {
                this.callBase(element);
                var $element = this.$element();
                if ($element) {
                    (0, _element_data.data)($element[0], VALIDATION_TARGET, this)
                }
            },
            _initOptions: function(options) {
                this.callBase.apply(this, arguments);
                this.option(_validation_engine.default.initValidationOptions(options))
            },
            _init: function() {
                this.callBase();
                this._options.cache("validationTooltipOptions", this.option("validationTooltipOptions"));
                var $element = this.$element();
                $element.addClass(DX_INVALID_BADGE_CLASS)
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationErrors: null,
                    validationStatus: VALIDATION_STATUS_VALID,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    },
                    validationTooltipOptions: {}
                })
            },
            _attachKeyboardEvents: function() {
                if (!this.option("readOnly")) {
                    this.callBase()
                }
            },
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _focusInHandler: function(e) {
                var _this = this;
                var isValidationMessageShownOnFocus = "auto" === this.option("validationMessageMode");
                if (this._canValueBeChangedByClick() && isValidationMessageShownOnFocus) {
                    var _this$_$validationMes;
                    null === (_this$_$validationMes = this._$validationMessage) || void 0 === _this$_$validationMes ? void 0 : _this$_$validationMes.removeClass(INVALID_MESSAGE_AUTO);
                    clearTimeout(this.showValidationMessageTimeout);
                    this.showValidationMessageTimeout = setTimeout(function() {
                        var _this$_$validationMes2;
                        return null === (_this$_$validationMes2 = _this._$validationMessage) || void 0 === _this$_$validationMes2 ? void 0 : _this$_$validationMes2.addClass(INVALID_MESSAGE_AUTO)
                    }, 150)
                }
                return this.callBase(e)
            },
            _canValueBeChangedByClick: function() {
                return false
            },
            _getValidationErrors: function() {
                var validationErrors = this.option("validationErrors");
                if (!validationErrors && this.option("validationError")) {
                    validationErrors = [this.option("validationError")]
                }
                return validationErrors
            },
            _disposeValidationMessage: function() {
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this.setAria("describedby", null);
                    this._$validationMessage = null
                }
            },
            _toggleValidationClasses: function(isInvalid) {
                this.$element().toggleClass(INVALID_CLASS, isInvalid);
                this.setAria(VALIDATION_STATUS_INVALID, isInvalid || void 0)
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid") && this.option("validationStatus") !== VALIDATION_STATUS_INVALID;
                var validationErrors = this._getValidationErrors();
                var $element = this.$element();
                this._toggleValidationClasses(!isValid);
                if (!(0, _window.hasWindow)()) {
                    return
                }
                this._disposeValidationMessage();
                if (!isValid && validationErrors) {
                    this._$validationMessage = (0, _renderer.default)("<div>").appendTo($element);
                    this.setAria("describedby", "dx-" + new _guid.default);
                    this._validationMessage = new _validation_message.default(this._$validationMessage, (0, _extend.extend)({
                        validationErrors: validationErrors,
                        target: this._getValidationMessageTarget(),
                        container: $element,
                        mode: this.option("validationMessageMode"),
                        positionRequest: "below",
                        offset: this.option("validationMessageOffset"),
                        boundary: this.option("validationBoundary"),
                        rtlEnabled: this.option("rtlEnabled")
                    }, this._options.cache("validationTooltipOptions")));
                    this._bindInnerWidgetOptions(this._validationMessage, "validationTooltipOptions")
                }
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _toggleReadOnlyState: function() {
                var readOnly = this.option("readOnly");
                this._toggleBackspaceHandler(readOnly);
                this.$element().toggleClass(READONLY_STATE_CLASS, !!readOnly);
                this.setAria("readonly", readOnly || void 0)
            },
            _toggleBackspaceHandler: function(isReadOnly) {
                var $eventTarget = this._keyboardEventBindingTarget();
                var eventName = (0, _index.addNamespace)("keydown", READONLY_NAMESPACE);
                _events_engine.default.off($eventTarget, eventName);
                if (isReadOnly) {
                    _events_engine.default.on($eventTarget, eventName, function(e) {
                        if ("backspace" === (0, _index.normalizeKeyName)(e)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _dispose: function() {
                var element = this.$element()[0];
                (0, _element_data.data)(element, VALIDATION_TARGET, null);
                clearTimeout(this.showValidationMessageTimeout);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _setValidationMessageOption: function(_ref) {
                var _this$_validationMess;
                var name = _ref.name,
                    value = _ref.value;
                var optionKey = VALIDATION_MESSAGE_KEYS_MAP[name] ? VALIDATION_MESSAGE_KEYS_MAP[name] : name;
                null === (_this$_validationMess = this._validationMessage) || void 0 === _this$_validationMess ? void 0 : _this$_validationMess.option(optionKey, value)
            },
            _optionChanged: function(args) {
                var _this$_validationMess2;
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        null === (_this$_validationMess2 = this._validationMessage) || void 0 === _this$_validationMess2 ? void 0 : _this$_validationMess2.updateMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    case "isValid":
                    case "validationError":
                    case "validationErrors":
                    case "validationStatus":
                        this.option(_validation_engine.default.synchronizeValidationOptions(args, this.option()));
                        this._renderValidationState();
                        break;
                    case "validationBoundary":
                    case "validationMessageMode":
                    case "validationMessageOffset":
                        this._setValidationMessageOption(args);
                        break;
                    case "rtlEnabled":
                        this._setValidationMessageOption(args);
                        this.callBase(args);
                        break;
                    case "validationTooltipOptions":
                        this._innerWidgetOptionChanged(this._validationMessage, args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        });
        var _default = Editor;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***************************************************!*\
      !*** ./node_modules/preact/dist/preact.module.js ***!
      \***************************************************/
    /*! exports provided: render, hydrate, createElement, h, Fragment, createRef, isValidElement, Component, cloneElement, createContext, toChildArray, __u, options */
    /*! all exports used */
    function(module, __webpack_exports__, __webpack_require__) {
        Object.defineProperty(__webpack_exports__, "__esModule", {
            value: true
        });
        __webpack_require__.d(__webpack_exports__, "render", function() {
            return O
        });
        __webpack_require__.d(__webpack_exports__, "hydrate", function() {
            return S
        });
        __webpack_require__.d(__webpack_exports__, "createElement", function() {
            return h
        });
        __webpack_require__.d(__webpack_exports__, "h", function() {
            return h
        });
        __webpack_require__.d(__webpack_exports__, "Fragment", function() {
            return p
        });
        __webpack_require__.d(__webpack_exports__, "createRef", function() {
            return y
        });
        __webpack_require__.d(__webpack_exports__, "isValidElement", function() {
            return l
        });
        __webpack_require__.d(__webpack_exports__, "Component", function() {
            return d
        });
        __webpack_require__.d(__webpack_exports__, "cloneElement", function() {
            return q
        });
        __webpack_require__.d(__webpack_exports__, "createContext", function() {
            return B
        });
        __webpack_require__.d(__webpack_exports__, "toChildArray", function() {
            return b
        });
        __webpack_require__.d(__webpack_exports__, "__u", function() {
            return L
        });
        __webpack_require__.d(__webpack_exports__, "options", function() {
            return n
        });
        var n, l, u, i, t, o, r, f = {},
            e = [],
            c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;

        function s(n, l) {
            for (var u in l) {
                n[u] = l[u]
            }
            return n
        }

        function a(n) {
            var l = n.parentNode;
            l && l.removeChild(n)
        }

        function h(n, l, u) {
            var i, t, o, r = arguments,
                f = {};
            for (o in l) {
                "key" == o ? i = l[o] : "ref" == o ? t = l[o] : f[o] = l[o]
            }
            if (arguments.length > 3) {
                for (u = [u], o = 3; o < arguments.length; o++) {
                    u.push(r[o])
                }
            }
            if (null != u && (f.children = u), "function" == typeof n && null != n.defaultProps) {
                for (o in n.defaultProps) {
                    void 0 === f[o] && (f[o] = n.defaultProps[o])
                }
            }
            return v(n, f, i, t, null)
        }

        function v(l, u, i, t, o) {
            var r = {
                type: l,
                props: u,
                key: i,
                ref: t,
                __k: null,
                __: null,
                __b: 0,
                __e: null,
                __d: void 0,
                __c: null,
                __h: null,
                constructor: void 0,
                __v: o
            };
            return null == o && (r.__v = r), null != n.vnode && n.vnode(r), r
        }

        function y() {
            return {
                current: null
            }
        }

        function p(n) {
            return n.children
        }

        function d(n, l) {
            this.props = n, this.context = l
        }

        function _(n, l) {
            if (null == l) {
                return n.__ ? _(n.__, n.__.__k.indexOf(n) + 1) : null
            }
            for (var u; l < n.__k.length; l++) {
                if (null != (u = n.__k[l]) && null != u.__e) {
                    return u.__e
                }
            }
            return "function" == typeof n.type ? _(n) : null
        }

        function w(n) {
            var l, u;
            if (null != (n = n.__) && null != n.__c) {
                for (n.__e = n.__c.base = null, l = 0; l < n.__k.length; l++) {
                    if (null != (u = n.__k[l]) && null != u.__e) {
                        n.__e = n.__c.base = u.__e;
                        break
                    }
                }
                return w(n)
            }
        }

        function k(l) {
            (!l.__d && (l.__d = !0) && u.push(l) && !g.__r++ || t !== n.debounceRendering) && ((t = n.debounceRendering) || i)(g)
        }

        function g() {
            for (var n; g.__r = u.length;) {
                n = u.sort(function(n, l) {
                    return n.__v.__b - l.__v.__b
                }), u = [], n.some(function(n) {
                    var l, u, i, t, o, r, f;
                    n.__d && (r = (o = (l = n).__v).__e, (f = l.__P) && (u = [], (i = s({}, o)).__v = i, t = $(f, o, i, l.__n, void 0 !== f.ownerSVGElement, null != o.__h ? [r] : null, u, null == r ? _(o) : r, o.__h), j(u, o), t != r && w(o)))
                })
            }
        }

        function m(n, l, u, i, t, o, r, c, s, h) {
            var y, d, w, k, g, m, b, A = i && i.__k || e,
                P = A.length;
            for (s == f && (s = null != r ? r[0] : P ? _(i, 0) : null), u.__k = [], y = 0; y < l.length; y++) {
                if (null != (k = u.__k[y] = null == (k = l[y]) || "boolean" == typeof k ? null : "string" == typeof k || "number" == typeof k ? v(null, k, null, null, k) : Array.isArray(k) ? v(p, {
                        children: k
                    }, null, null, null) : null != k.__e || null != k.__c ? v(k.type, k.props, k.key, null, k.__v) : k)) {
                    if (k.__ = u, k.__b = u.__b + 1, null === (w = A[y]) || w && k.key == w.key && k.type === w.type) {
                        A[y] = void 0
                    } else {
                        for (d = 0; d < P; d++) {
                            if ((w = A[d]) && k.key == w.key && k.type === w.type) {
                                A[d] = void 0;
                                break
                            }
                            w = null
                        }
                    }
                    g = $(n, k, w = w || f, t, o, r, c, s, h), (d = k.ref) && w.ref != d && (b || (b = []), w.ref && b.push(w.ref, null, k), b.push(d, k.__c || g, k)), null != g ? (null == m && (m = g), s = x(n, k, w, A, r, g, s), h || "option" != u.type ? "function" == typeof u.type && (u.__d = s) : n.value = "") : s && w.__e == s && s.parentNode != n && (s = _(w))
                }
            }
            if (u.__e = m, null != r && "function" != typeof u.type) {
                for (y = r.length; y--;) {
                    null != r[y] && a(r[y])
                }
            }
            for (y = P; y--;) {
                null != A[y] && L(A[y], A[y])
            }
            if (b) {
                for (y = 0; y < b.length; y++) {
                    I(b[y], b[++y], b[++y])
                }
            }
        }

        function b(n, l) {
            return l = l || [], null == n || "boolean" == typeof n || (Array.isArray(n) ? n.some(function(n) {
                b(n, l)
            }) : l.push(n)), l
        }

        function x(n, l, u, i, t, o, r) {
            var f, e, c;
            if (void 0 !== l.__d) {
                f = l.__d, l.__d = void 0
            } else {
                if (t == u || o != r || null == o.parentNode) {
                    n: if (null == r || r.parentNode !== n) {
                        n.appendChild(o), f = null
                    } else {
                        for (e = r, c = 0;
                            (e = e.nextSibling) && c < i.length; c += 2) {
                            if (e == o) {
                                break n
                            }
                        }
                        n.insertBefore(o, r), f = r
                    }
                }
            }
            return void 0 !== f ? f : o.nextSibling
        }

        function A(n, l, u, i, t) {
            var o;
            for (o in u) {
                "children" === o || "key" === o || o in l || C(n, o, null, u[o], i)
            }
            for (o in l) {
                t && "function" != typeof l[o] || "children" === o || "key" === o || "value" === o || "checked" === o || u[o] === l[o] || C(n, o, l[o], u[o], i)
            }
        }

        function P(n, l, u) {
            "-" === l[0] ? n.setProperty(l, u) : n[l] = null == u ? "" : "number" != typeof u || c.test(l) ? u : u + "px"
        }

        function C(n, l, u, i, t) {
            var o, r, f;
            if (t && "className" == l && (l = "class"), "style" === l) {
                if ("string" == typeof u) {
                    n.style.cssText = u
                } else {
                    if ("string" == typeof i && (n.style.cssText = i = ""), i) {
                        for (l in i) {
                            u && l in u || P(n.style, l, "")
                        }
                    }
                    if (u) {
                        for (l in u) {
                            i && u[l] === i[l] || P(n.style, l, u[l])
                        }
                    }
                }
            } else {
                "o" === l[0] && "n" === l[1] ? (o = l !== (l = l.replace(/Capture$/, "")), (r = l.toLowerCase()) in n && (l = r), l = l.slice(2), n.l || (n.l = {}), n.l[l + o] = u, f = o ? N : z, u ? i || n.addEventListener(l, f, o) : n.removeEventListener(l, f, o)) : "list" !== l && "tagName" !== l && "form" !== l && "type" !== l && "size" !== l && "download" !== l && "href" !== l && !t && l in n ? n[l] = null == u ? "" : u : "function" != typeof u && "dangerouslySetInnerHTML" !== l && (l !== (l = l.replace(/xlink:?/, "")) ? null == u || !1 === u ? n.removeAttributeNS("http://www.w3.org/1999/xlink", l.toLowerCase()) : n.setAttributeNS("http://www.w3.org/1999/xlink", l.toLowerCase(), u) : null == u || !1 === u && !/^ar/.test(l) ? n.removeAttribute(l) : n.setAttribute(l, u))
            }
        }

        function z(l) {
            this.l[l.type + !1](n.event ? n.event(l) : l)
        }

        function N(l) {
            this.l[l.type + !0](n.event ? n.event(l) : l)
        }

        function T(n, l, u) {
            var i, t;
            for (i = 0; i < n.__k.length; i++) {
                (t = n.__k[i]) && (t.__ = n, t.__e && ("function" == typeof t.type && t.__k.length > 1 && T(t, l, u), l = x(u, t, t, n.__k, null, t.__e, l), "function" == typeof n.type && (n.__d = l)))
            }
        }

        function $(l, u, i, t, o, r, f, e, c) {
            var a, h, v, y, _, w, k, g, b, x, A, P = u.type;
            if (void 0 !== u.constructor) {
                return null
            }
            null != i.__h && (c = i.__h, e = u.__e = i.__e, u.__h = null, r = [e]), (a = n.__b) && a(u);
            try {
                n: if ("function" == typeof P) {
                    if (g = u.props, b = (a = P.contextType) && t[a.__c], x = a ? b ? b.props.value : a.__ : t, i.__c ? k = (h = u.__c = i.__c).__ = h.__E : ("prototype" in P && P.prototype.render ? u.__c = h = new P(g, x) : (u.__c = h = new d(g, x), h.constructor = P, h.render = M), b && b.sub(h), h.props = g, h.state || (h.state = {}), h.context = x, h.__n = t, v = h.__d = !0, h.__h = []), null == h.__s && (h.__s = h.state), null != P.getDerivedStateFromProps && (h.__s == h.state && (h.__s = s({}, h.__s)), s(h.__s, P.getDerivedStateFromProps(g, h.__s))), y = h.props, _ = h.state, v) {
                        null == P.getDerivedStateFromProps && null != h.componentWillMount && h.componentWillMount(), null != h.componentDidMount && h.__h.push(h.componentDidMount)
                    } else {
                        if (null == P.getDerivedStateFromProps && g !== y && null != h.componentWillReceiveProps && h.componentWillReceiveProps(g, x), !h.__e && null != h.shouldComponentUpdate && !1 === h.shouldComponentUpdate(g, h.__s, x) || u.__v === i.__v) {
                            h.props = g, h.state = h.__s, u.__v !== i.__v && (h.__d = !1), h.__v = u, u.__e = i.__e, u.__k = i.__k, h.__h.length && f.push(h), T(u, e, l);
                            break n
                        }
                        null != h.componentWillUpdate && h.componentWillUpdate(g, h.__s, x), null != h.componentDidUpdate && h.__h.push(function() {
                            h.componentDidUpdate(y, _, w)
                        })
                    }
                    h.context = x, h.props = g, h.state = h.__s, (a = n.__r) && a(u), h.__d = !1, h.__v = u, h.__P = l, a = h.render(h.props, h.state, h.context), h.state = h.__s, null != h.getChildContext && (t = s(s({}, t), h.getChildContext())), v || null == h.getSnapshotBeforeUpdate || (w = h.getSnapshotBeforeUpdate(y, _)), A = null != a && a.type == p && null == a.key ? a.props.children : a, m(l, Array.isArray(A) ? A : [A], u, i, t, o, r, f, e, c), h.base = u.__e, u.__h = null, h.__h.length && f.push(h), k && (h.__E = h.__ = null), h.__e = !1
                } else {
                    null == r && u.__v === i.__v ? (u.__k = i.__k, u.__e = i.__e) : u.__e = H(i.__e, u, i, t, o, r, f, c)
                }(a = n.diffed) && a(u)
            }
            catch (l) {
                u.__v = null, (c || null != r) && (u.__e = e, u.__h = !!c, r[r.indexOf(e)] = null), n.__e(l, u, i)
            }
            return u.__e
        }

        function j(l, u) {
            n.__c && n.__c(u, l), l.some(function(u) {
                try {
                    l = u.__h, u.__h = [], l.some(function(n) {
                        n.call(u)
                    })
                } catch (l) {
                    n.__e(l, u.__v)
                }
            })
        }

        function H(n, l, u, i, t, o, r, c) {
            var s, a, h, v, y, p = u.props,
                d = l.props;
            if (t = "svg" === l.type || t, null != o) {
                for (s = 0; s < o.length; s++) {
                    if (null != (a = o[s]) && ((null === l.type ? 3 === a.nodeType : a.localName === l.type) || n == a)) {
                        n = a, o[s] = null;
                        break
                    }
                }
            }
            if (null == n) {
                if (null === l.type) {
                    return document.createTextNode(d)
                }
                n = t ? document.createElementNS("http://www.w3.org/2000/svg", l.type) : document.createElement(l.type, d.is && {
                    is: d.is
                }), o = null, c = !1
            }
            if (null === l.type) {
                p === d || c && n.data === d || (n.data = d)
            } else {
                if (null != o && (o = e.slice.call(n.childNodes)), h = (p = u.props || f).dangerouslySetInnerHTML, v = d.dangerouslySetInnerHTML, !c) {
                    if (null != o) {
                        for (p = {}, y = 0; y < n.attributes.length; y++) {
                            p[n.attributes[y].name] = n.attributes[y].value
                        }
                    }(v || h) && (v && (h && v.__html == h.__html || v.__html === n.innerHTML) || (n.innerHTML = v && v.__html || ""))
                }
                A(n, d, p, t, c), v ? l.__k = [] : (s = l.props.children, m(n, Array.isArray(s) ? s : [s], l, u, i, "foreignObject" !== l.type && t, o, r, f, c)), c || ("value" in d && void 0 !== (s = d.value) && (s !== n.value || "progress" === l.type && !s) && C(n, "value", s, p.value, !1), "checked" in d && void 0 !== (s = d.checked) && s !== n.checked && C(n, "checked", s, p.checked, !1))
            }
            return n
        }

        function I(l, u, i) {
            try {
                "function" == typeof l ? l(u) : l.current = u
            } catch (l) {
                n.__e(l, i)
            }
        }

        function L(l, u, i) {
            var t, o, r;
            if (n.unmount && n.unmount(l), (t = l.ref) && (t.current && t.current !== l.__e || I(t, null, u)), i || "function" == typeof l.type || (i = null != (o = l.__e)), l.__e = l.__d = void 0, null != (t = l.__c)) {
                if (t.componentWillUnmount) {
                    try {
                        t.componentWillUnmount()
                    } catch (l) {
                        n.__e(l, u)
                    }
                }
                t.base = t.__P = null
            }
            if (t = l.__k) {
                for (r = 0; r < t.length; r++) {
                    t[r] && L(t[r], u, i)
                }
            }
            null != o && a(o)
        }

        function M(n, l, u) {
            return this.constructor(n, u)
        }

        function O(l, u, i) {
            var t, r, c;
            n.__ && n.__(l, u), r = (t = i === o) ? null : i && i.__k || u.__k, l = h(p, null, [l]), c = [], $(u, (t ? u : i || u).__k = l, r || f, f, void 0 !== u.ownerSVGElement, i && !t ? [i] : r ? null : u.childNodes.length ? e.slice.call(u.childNodes) : null, c, i || f, t), j(c, l)
        }

        function S(n, l) {
            O(n, l, o)
        }

        function q(n, l, u) {
            var i, t, o, r = arguments,
                f = s({}, n.props);
            for (o in l) {
                "key" == o ? i = l[o] : "ref" == o ? t = l[o] : f[o] = l[o]
            }
            if (arguments.length > 3) {
                for (u = [u], o = 3; o < arguments.length; o++) {
                    u.push(r[o])
                }
            }
            return null != u && (f.children = u), v(n.type, f, i || n.key, t || n.ref, null)
        }

        function B(n, l) {
            var u = {
                __c: l = "__cC" + r++,
                __: n,
                Consumer: function(n, l) {
                    return n.children(l)
                },
                Provider: function(n, u, i) {
                    return this.getChildContext || (u = [], (i = {})[l] = this, this.getChildContext = function() {
                        return i
                    }, this.shouldComponentUpdate = function(n) {
                        this.props.value !== n.value && u.some(k)
                    }, this.sub = function(n) {
                        u.push(n);
                        var l = n.componentWillUnmount;
                        n.componentWillUnmount = function() {
                            u.splice(u.indexOf(n), 1), l && l.call(n)
                        }
                    }), n.children
                }
            };
            return u.Provider.__ = u.Consumer.contextType = u
        }
        n = {
            __e: function(n, l) {
                for (var u, i, t, o = l.__h; l = l.__;) {
                    if ((u = l.__c) && !u.__) {
                        try {
                            if ((i = u.constructor) && null != i.getDerivedStateFromError && (u.setState(i.getDerivedStateFromError(n)), t = u.__d), null != u.componentDidCatch && (u.componentDidCatch(n), t = u.__d), t) {
                                return l.__h = o, u.__E = u
                            }
                        } catch (l) {
                            n = l
                        }
                    }
                }
                throw n
            }
        }, l = function(n) {
            return null != n && void 0 === n.constructor
        }, d.prototype.setState = function(n, l) {
            var u;
            u = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n && (n = n(s({}, u), this.props)), n && s(u, n), null != n && this.__v && (l && this.__h.push(l), k(this))
        }, d.prototype.forceUpdate = function(n) {
            this.__v && (this.__e = !0, n && this.__h.push(n), k(this))
        }, d.prototype.render = p, u = [], i = "function" == typeof Promise ? Promise.prototype.then.bind(Promise.resolve()) : setTimeout, g.__r = 0, o = f, r = 0
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/visibility_change.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.triggerResizeEvent = exports.triggerHidingEvent = exports.triggerShownEvent = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 5));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = (0, _renderer.default)(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    _events_engine.default.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerShownEvent = triggerShownEvent;
        var triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerHidingEvent = triggerHidingEvent;
        var triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.triggerResizeEvent = triggerResizeEvent
    },
    /*!*****************************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/collection/ui.collection_widget.edit.js ***!
      \*****************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _uiCollection_widget = _interopRequireDefault(__webpack_require__( /*! ./ui.collection_widget.base */ 544));
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.errors */ 17));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _uiCollection_widgetEditStrategy = _interopRequireDefault(__webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 204));
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 69);
        var _utils = __webpack_require__( /*! ../../data/data_source/utils */ 70);
        var _selection = _interopRequireDefault(__webpack_require__( /*! ../selection/selection */ 234));
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting";
        var NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = _uiCollection_widget.default.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule()
            },
            _initKeyGetter: function() {
                this._keyGetter = (0, _data.compileGetter)(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            key: function() {
                if (this.option("keyExpr")) {
                    return this.option("keyExpr")
                }
                return this._dataSource && this._dataSource.key()
            },
            keyOf: function(item) {
                var key = item;
                var store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _nullValueSelectionSupported: function() {
                return false
            },
            _initSelectionModule: function() {
                var that = this;
                var itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new _selection.default({
                    allowNullValue: this._nullValueSelectionSupported(),
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: that.key.bind(that),
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        if (store) {
                            return store.load(options).done(function(loadResult) {
                                if (that._disposed) {
                                    return
                                }
                                var items = (0, _utils.normalizeLoadResult)(loadResult).data;
                                that._dataSource._applyMapFunction(items)
                            })
                        } else {
                            return (new _deferred.Deferred).resolve(this.plainItems())
                        }
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = _uiCollection_widgetEditStrategy.default;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this;
                var indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                (0, _iterator.each)(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                var _this = this;
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions().done(function() {
                        return _this._normalizeSelectedItems()
                    })
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem;
                var selectedIndex;
                var selectedItemKeys;
                var selectedItems;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedItem", selectedItem);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = selectedItems.length ? this._editStrategy.getIndexByItemData(selectedItems[0]) : NOT_EXISTING_INDEX;
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        this._setOptionWithoutOptionChange("selectedItem", selectedItems[0]);
                        this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                        this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired")) {
                            var selectedItemIndex = this._getIndexByKey(selectedItemKeys[0]);
                            if (!indexExists(selectedItemIndex)) {
                                return this._syncSelectionOptions("selectedIndex")
                            }
                        }
                        return this._selection.setSelection(selectedItemKeys)
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName);
                    var length = (0, _type.isDefined)(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionWithoutOptionChange("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionWithoutOptionChange("selectedItems", [normalizedSelection]);
                            return this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: (0, _renderer.default)(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" !== this.option("selectionMode")) {
                    var $itemElement = (0, _renderer.default)(args.itemElement);
                    var normalizedItemIndex = this._editStrategy.getNormalizedIndex($itemElement);
                    var isItemSelected = this._isItemSelected(normalizedItemIndex);
                    this._processSelectableItem($itemElement, isItemSelected)
                }
            },
            _processSelectableItem: function($itemElement, isSelected) {
                $itemElement.toggleClass(this._selectedItemClass(), isSelected);
                this._setAriaSelected($itemElement, String(isSelected))
            },
            _updateSelectedItems: function(args) {
                var that = this;
                var addedItemKeys = args.addedItemKeys;
                var removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var addedSelection = [];
                        var normalizedIndex;
                        var removedSelection = [];
                        that._editStrategy.beginCache();
                        for (var i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (var _i = 0; _i < removedItemKeys.length; _i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[_i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }(0, _deferred.when)(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: _common.noop,
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, false);
                    _events_engine.default.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, true);
                    _events_engine.default.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                var _this2 = this;
                switch (args.name) {
                    case "selectionMode":
                        this._invalidate();
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name).done(function() {
                            return _this2._normalizeSelectedItems()
                        });
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionWithoutOptionChange("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new _deferred.Deferred;
                var deletingActionArgs = {
                    cancel: false
                };
                var deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                    excludeValidators: ["disabled", "readOnly"]
                });
                (0, _deferred.when)(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise;
                    var deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state();
                    var argumentsSpecified = !!arguments.length;
                    var shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    (0, _deferred.when)((0, _deferred.fromPromise)(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                var deferred = new _deferred.Deferred;
                var disabledState = this.option("disabled");
                var dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw _ui.default.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new _deferred.Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    (0, _renderer.default)(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof _data_source.DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys") || [];
                    this._selection.setSelection([].concat(_toConsumableArray(selectedItemKeys), [key]))
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            _deleteItemElementByIndex: function(index) {
                this._updateSelectionAfterDelete(index);
                this._updateIndicesAfterIndex(index);
                this._editStrategy.deleteItemAtIndex(index)
            },
            _afterItemElementDeleted: function($item, deletedActionArgs) {
                var changingOption = this._dataSource ? "dataSource" : "items";
                this._simulateOptionChange(changingOption);
                this._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                    beforeExecute: function() {
                        $item.remove()
                    },
                    excludeValidators: ["disabled", "readOnly"]
                });
                this._renderEmptyMessage()
            },
            deleteItem: function(itemElement) {
                var that = this;
                var deferred = new _deferred.Deferred;
                var $item = this._editStrategy.getItemElement(itemElement);
                var index = this._editStrategy.getNormalizedIndex(itemElement);
                var itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._deleteItemElementByIndex(index);
                            that._afterItemElementDeleted($item, deletedActionArgs);
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new _deferred.Deferred;
                var that = this;
                var strategy = this._editStrategy;
                var $movingItem = strategy.getItemElement(itemElement);
                var $destinationItem = strategy.getItemElement(toItemElement);
                var movingIndex = strategy.getNormalizedIndex(itemElement);
                var destinationIndex = strategy.getNormalizedIndex(toItemElement);
                var changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        var _default = CollectionWidget;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************!*\
      !*** ./node_modules/preact/hooks/dist/hooks.module.js ***!
      \********************************************************/
    /*! exports provided: useState, useReducer, useEffect, useLayoutEffect, useRef, useImperativeHandle, useMemo, useCallback, useContext, useDebugValue, useErrorBoundary */
    /*! all exports used */
    function(module, __webpack_exports__, __webpack_require__) {
        Object.defineProperty(__webpack_exports__, "__esModule", {
            value: true
        });
        __webpack_require__.d(__webpack_exports__, "useState", function() {
            return m
        });
        __webpack_require__.d(__webpack_exports__, "useReducer", function() {
            return p
        });
        __webpack_require__.d(__webpack_exports__, "useEffect", function() {
            return y
        });
        __webpack_require__.d(__webpack_exports__, "useLayoutEffect", function() {
            return l
        });
        __webpack_require__.d(__webpack_exports__, "useRef", function() {
            return h
        });
        __webpack_require__.d(__webpack_exports__, "useImperativeHandle", function() {
            return s
        });
        __webpack_require__.d(__webpack_exports__, "useMemo", function() {
            return _
        });
        __webpack_require__.d(__webpack_exports__, "useCallback", function() {
            return A
        });
        __webpack_require__.d(__webpack_exports__, "useContext", function() {
            return F
        });
        __webpack_require__.d(__webpack_exports__, "useDebugValue", function() {
            return T
        });
        __webpack_require__.d(__webpack_exports__, "useErrorBoundary", function() {
            return d
        });
        var __WEBPACK_IMPORTED_MODULE_0_preact__ = __webpack_require__( /*! preact */ 52);
        var t, u, r, o = 0,
            i = [],
            c = __WEBPACK_IMPORTED_MODULE_0_preact__.options.__r,
            f = __WEBPACK_IMPORTED_MODULE_0_preact__.options.diffed,
            e = __WEBPACK_IMPORTED_MODULE_0_preact__.options.__c,
            a = __WEBPACK_IMPORTED_MODULE_0_preact__.options.unmount;

        function v(t, r) {
            __WEBPACK_IMPORTED_MODULE_0_preact__.options.__h && __WEBPACK_IMPORTED_MODULE_0_preact__.options.__h(u, t, o || r), o = 0;
            var i = u.__H || (u.__H = {
                __: [],
                __h: []
            });
            return t >= i.__.length && i.__.push({}), i.__[t]
        }

        function m(n) {
            return o = 1, p(k, n)
        }

        function p(n, r, o) {
            var i = v(t++, 2);
            return i.t = n, i.__c || (i.__ = [o ? o(r) : k(void 0, r), function(n) {
                var t = i.t(i.__[0], n);
                i.__[0] !== t && (i.__ = [t, i.__[1]], i.__c.setState({}))
            }], i.__c = u), i.__
        }

        function y(r, o) {
            var i = v(t++, 3);
            !__WEBPACK_IMPORTED_MODULE_0_preact__.options.__s && j(i.__H, o) && (i.__ = r, i.__H = o, u.__H.__h.push(i))
        }

        function l(r, o) {
            var i = v(t++, 4);
            !__WEBPACK_IMPORTED_MODULE_0_preact__.options.__s && j(i.__H, o) && (i.__ = r, i.__H = o, u.__h.push(i))
        }

        function h(n) {
            return o = 5, _(function() {
                return {
                    current: n
                }
            }, [])
        }

        function s(n, t, u) {
            o = 6, l(function() {
                "function" == typeof n ? n(t()) : n && (n.current = t())
            }, null == u ? u : u.concat(n))
        }

        function _(n, u) {
            var r = v(t++, 7);
            return j(r.__H, u) && (r.__ = n(), r.__H = u, r.__h = n), r.__
        }

        function A(n, t) {
            return o = 8, _(function() {
                return n
            }, t)
        }

        function F(n) {
            var r = u.context[n.__c],
                o = v(t++, 9);
            return o.__c = n, r ? (null == o.__ && (o.__ = !0, r.sub(u)), r.props.value) : n.__
        }

        function T(t, u) {
            __WEBPACK_IMPORTED_MODULE_0_preact__.options.useDebugValue && __WEBPACK_IMPORTED_MODULE_0_preact__.options.useDebugValue(u ? u(t) : t)
        }

        function d(n) {
            var r = v(t++, 10),
                o = m();
            return r.__ = n, u.componentDidCatch || (u.componentDidCatch = function(n) {
                r.__ && r.__(n), o[1](n)
            }), [o[0], function() {
                o[1](void 0)
            }]
        }

        function q() {
            i.forEach(function(t) {
                if (t.__P) {
                    try {
                        t.__H.__h.forEach(b), t.__H.__h.forEach(g), t.__H.__h = []
                    } catch (u) {
                        t.__H.__h = [], __WEBPACK_IMPORTED_MODULE_0_preact__.options.__e(u, t.__v)
                    }
                }
            }), i = []
        }
        __WEBPACK_IMPORTED_MODULE_0_preact__.options.__r = function(n) {
            c && c(n), t = 0;
            var r = (u = n.__c).__H;
            r && (r.__h.forEach(b), r.__h.forEach(g), r.__h = [])
        }, __WEBPACK_IMPORTED_MODULE_0_preact__.options.diffed = function(t) {
            f && f(t);
            var u = t.__c;
            u && u.__H && u.__H.__h.length && (1 !== i.push(u) && r === __WEBPACK_IMPORTED_MODULE_0_preact__.options.requestAnimationFrame || ((r = __WEBPACK_IMPORTED_MODULE_0_preact__.options.requestAnimationFrame) || function(n) {
                var t, u = function() {
                        clearTimeout(r), x && cancelAnimationFrame(t), setTimeout(n)
                    },
                    r = setTimeout(u, 100);
                x && (t = requestAnimationFrame(u))
            })(q))
        }, __WEBPACK_IMPORTED_MODULE_0_preact__.options.__c = function(t, u) {
            u.some(function(t) {
                try {
                    t.__h.forEach(b), t.__h = t.__h.filter(function(n) {
                        return !n.__ || g(n)
                    })
                } catch (r) {
                    u.some(function(n) {
                        n.__h && (n.__h = [])
                    }), u = [], __WEBPACK_IMPORTED_MODULE_0_preact__.options.__e(r, t.__v)
                }
            }), e && e(t, u)
        }, __WEBPACK_IMPORTED_MODULE_0_preact__.options.unmount = function(t) {
            a && a(t);
            var u = t.__c;
            if (u && u.__H) {
                try {
                    u.__H.__.forEach(b)
                } catch (t) {
                    __WEBPACK_IMPORTED_MODULE_0_preact__.options.__e(t, u.__v)
                }
            }
        };
        var x = "function" == typeof requestAnimationFrame;

        function b(n) {
            "function" == typeof n.__c && n.__c()
        }

        function g(n) {
            n.__c = n.__()
        }

        function j(n, t) {
            return !n || n.length !== t.length || t.some(function(t, u) {
                return t !== n[u]
            })
        }

        function k(n, t) {
            return "function" == typeof t ? t(n) : t
        }
    }, ,
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/icon.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getImageContainer = exports.getImageSourceType = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ICON_CLASS = "dx-icon";
        var SVG_ICON_CLASS = "dx-svg-icon";
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(source)) {
                return "svg"
            }
            if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            if (/^\s?([\w-_]\s?)+$/.test(source)) {
                return "fontIcon"
            }
            return false
        };
        exports.getImageSourceType = getImageSourceType;
        var getImageContainer = function(source) {
            switch (getImageSourceType(source)) {
                case "image":
                    return (0, _renderer.default)("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(source));
                case "dxIcon":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(ICON_CLASS, "-").concat(source));
                case "svg":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(SVG_ICON_CLASS)).append(source);
                default:
                    return null
            }
        };
        exports.getImageContainer = getImageContainer
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/date_serialization.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _date = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 242);
        var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ../../localization/default_date_names */ 243));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ./browser */ 22));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var NUMBER_SERIALIZATION_FORMAT = "number";
        var DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd";
        var DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var DATE_SERIALIZATION_PATTERN = /^(\d{4})\/(\d{2})\/(\d{2})$/;
        var MILLISECOND_LENGHT = 3;
        var isIE11 = _browser.default.msie && parseInt(_browser.default.version) <= 11;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            if ((0, _type.isString)(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            return result || parseDate(text)
        };

        function getTimePart(part) {
            return +part || 0
        }

        function parseDate(text) {
            var isDefaultSerializationFormat = getDateSerializationFormat(text) === DATE_SERIALIZATION_FORMAT;
            var parsedValue = !(0, _type.isDate)(text) && Date.parse(text);
            if ((!parsedValue || isIE11) && isDefaultSerializationFormat) {
                var parts = text.match(DATE_SERIALIZATION_PATTERN);
                if (parts) {
                    var newDate = new Date(getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[3]));
                    newDate.setFullYear(getTimePart(parts[1]));
                    newDate.setMonth(getTimePart(parts[2]) - 1);
                    newDate.setDate(getTimePart(parts[3]));
                    return newDate
                }
            }
            return (0, _type.isNumeric)(parsedValue) ? new Date(parsedValue) : text
        }

        function parseISO8601String(text) {
            var parts = text.match(ISO8601_PATTERN);
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[4]))
                }
                return
            }
            var year = parts[1];
            var month = --parts[3];
            var day = parts[5];
            var timeZoneHour = 0;
            var timeZoneMinute = 0;
            timeZoneHour = getTimePart(parts[14]);
            timeZoneMinute = getTimePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = getTimePart(parts[6]) - timeZoneHour;
            var minute = getTimePart(parts[8]) - timeZoneMinute;
            var second = getTimePart(parts[10]);
            var parseMilliseconds = function(part) {
                part = part || "";
                return getTimePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
            };
            var millisecond = parseMilliseconds(parts[11]);
            if (parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        }
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN);
            var result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !(0, _config.default)().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!(0, _type.isDate)(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return (0, _date.getFormatter)(serializationFormat, _default_date_names.default)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if ((0, _type.isString)(value)) {
                    var format;
                    if ((0, _config.default)().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        var _default = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/dependency_injector.js ***!
      \********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = _default;
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _class = _interopRequireDefault(__webpack_require__( /*! ../class */ 15));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _default(object) {
            var BaseClass = _class.default.inherit(object);
            var InjectedClass = BaseClass;
            var instance = new InjectedClass(object);
            var initialFields = {};
            var injectFields = function(injectionObject, initial) {
                (0, _iterator.each)(injectionObject, function(key) {
                    if ((0, _type.isFunction)(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                (0, _extend.extend)(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
        module.exports = exports.default
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    },
    /*!******************************************!*\
      !*** external "window.DevExpress.Quill" ***!
      \******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.DevExpress.Quill
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/version.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = compare;

        function compare(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10);
                var yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!*****************************************************!*\
      !*** ./node_modules/rrule/dist/esm/src/dateutil.js ***!
      \*****************************************************/
    /*! exports provided: dateutil, default */
    /*! exports used: dateutil, default */
    function(module, __webpack_exports__, __webpack_require__) {
        __webpack_require__.d(__webpack_exports__, "a", function() {
            return dateutil
        });
        var __WEBPACK_IMPORTED_MODULE_0__helpers__ = __webpack_require__( /*! ./helpers */ 64);
        var dateutil;
        ! function(dateutil) {
            dateutil.MONTH_DAYS = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            dateutil.ONE_DAY = 864e5;
            dateutil.MAXYEAR = 9999;
            dateutil.ORDINAL_BASE = new Date(Date.UTC(1970, 0, 1));
            dateutil.PY_WEEKDAYS = [6, 0, 1, 2, 3, 4, 5];
            dateutil.getYearDay = function(date) {
                var dateNoTime = new Date(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
                return Math.ceil((dateNoTime.valueOf() - new Date(date.getUTCFullYear(), 0, 1).valueOf()) / dateutil.ONE_DAY) + 1
            };
            dateutil.isLeapYear = function(year) {
                return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0
            };
            dateutil.isDate = function(value) {
                return value instanceof Date
            };
            dateutil.isValidDate = function(value) {
                return dateutil.isDate(value) && !isNaN(value.getTime())
            };
            dateutil.tzOffset = function(date) {
                return 60 * date.getTimezoneOffset() * 1e3
            };
            dateutil.daysBetween = function(date1, date2) {
                var date1ms = date1.getTime() - dateutil.tzOffset(date1);
                var date2ms = date2.getTime() - dateutil.tzOffset(date2);
                var differencems = date1ms - date2ms;
                return Math.round(differencems / dateutil.ONE_DAY)
            };
            dateutil.toOrdinal = function(date) {
                return dateutil.daysBetween(date, dateutil.ORDINAL_BASE)
            };
            dateutil.fromOrdinal = function(ordinal) {
                return new Date(dateutil.ORDINAL_BASE.getTime() + ordinal * dateutil.ONE_DAY)
            };
            dateutil.getMonthDays = function(date) {
                var month = date.getUTCMonth();
                return 1 === month && dateutil.isLeapYear(date.getUTCFullYear()) ? 29 : dateutil.MONTH_DAYS[month]
            };
            dateutil.getWeekday = function(date) {
                return dateutil.PY_WEEKDAYS[date.getUTCDay()]
            };
            dateutil.monthRange = function(year, month) {
                var date = new Date(Date.UTC(year, month, 1));
                return [dateutil.getWeekday(date), dateutil.getMonthDays(date)]
            };
            dateutil.combine = function(date, time) {
                time = time || date;
                return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()))
            };
            dateutil.clone = function(date) {
                var dolly = new Date(date.getTime());
                return dolly
            };
            dateutil.cloneDates = function(dates) {
                var clones = [];
                for (var i = 0; i < dates.length; i++) {
                    clones.push(dateutil.clone(dates[i]))
                }
                return clones
            };
            dateutil.sort = function(dates) {
                dates.sort(function(a, b) {
                    return a.getTime() - b.getTime()
                })
            };
            dateutil.timeToUntilString = function(time, utc) {
                if (void 0 === utc) {
                    utc = true
                }
                var date = new Date(time);
                return [Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCFullYear().toString(), 4, "0"), Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCMonth() + 1, 2, "0"), Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCDate(), 2, "0"), "T", Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCHours(), 2, "0"), Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCMinutes(), 2, "0"), Object(__WEBPACK_IMPORTED_MODULE_0__helpers__.i)(date.getUTCSeconds(), 2, "0"), utc ? "Z" : ""].join("")
            };
            dateutil.untilStringToDate = function(until) {
                var re = /^(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2})Z?)?$/;
                var bits = re.exec(until);
                if (!bits) {
                    throw new Error("Invalid UNTIL value: " + until)
                }
                return new Date(Date.UTC(parseInt(bits[1], 10), parseInt(bits[2], 10) - 1, parseInt(bits[3], 10), parseInt(bits[5], 10) || 0, parseInt(bits[6], 10) || 0, parseInt(bits[7], 10) || 0))
            }
        }(dateutil || (dateutil = {}));
        __webpack_exports__.b = dateutil
    },
    /*!****************************************************!*\
      !*** ./node_modules/rrule/dist/esm/src/helpers.js ***!
      \****************************************************/
    /*! exports provided: isPresent, isNumber, isWeekdayStr, isArray, range, clone, repeat, toArray, padStart, split, pymod, divmod, empty, notEmpty, includes */
    /*! exports used: divmod, empty, includes, isArray, isNumber, isPresent, isWeekdayStr, notEmpty, padStart, pymod, range, repeat, split, toArray */
    function(module, __webpack_exports__, __webpack_require__) {
        __webpack_require__.d(__webpack_exports__, "f", function() {
            return isPresent
        });
        __webpack_require__.d(__webpack_exports__, "e", function() {
            return isNumber
        });
        __webpack_require__.d(__webpack_exports__, "g", function() {
            return isWeekdayStr
        });
        __webpack_require__.d(__webpack_exports__, "d", function() {
            return isArray
        });
        __webpack_require__.d(__webpack_exports__, "k", function() {
            return range
        });
        __webpack_require__.d(__webpack_exports__, "l", function() {
            return repeat
        });
        __webpack_require__.d(__webpack_exports__, "n", function() {
            return toArray
        });
        __webpack_exports__.i = padStart;
        __webpack_require__.d(__webpack_exports__, "m", function() {
            return split
        });
        __webpack_require__.d(__webpack_exports__, "j", function() {
            return pymod
        });
        __webpack_require__.d(__webpack_exports__, "a", function() {
            return divmod
        });
        __webpack_require__.d(__webpack_exports__, "b", function() {
            return empty
        });
        __webpack_require__.d(__webpack_exports__, "h", function() {
            return notEmpty
        });
        __webpack_require__.d(__webpack_exports__, "c", function() {
            return includes
        });
        var __WEBPACK_IMPORTED_MODULE_0__weekday__ = __webpack_require__( /*! ./weekday */ 158);
        var isPresent = function(value) {
            return null !== value && void 0 !== value
        };
        var isNumber = function(value) {
            return "number" === typeof value
        };
        var isWeekdayStr = function(value) {
            return __WEBPACK_IMPORTED_MODULE_0__weekday__.a.indexOf(value) >= 0
        };
        var isArray = Array.isArray;
        var range = function(start, end) {
            if (void 0 === end) {
                end = start
            }
            if (1 === arguments.length) {
                end = start;
                start = 0
            }
            var rang = [];
            for (var i = start; i < end; i++) {
                rang.push(i)
            }
            return rang
        };
        var repeat = function(value, times) {
            var i = 0;
            var array = [];
            if (isArray(value)) {
                for (; i < times; i++) {
                    array[i] = [].concat(value)
                }
            } else {
                for (; i < times; i++) {
                    array[i] = value
                }
            }
            return array
        };
        var toArray = function(item) {
            if (isArray(item)) {
                return item
            }
            return [item]
        };

        function padStart(item, targetLength, padString) {
            if (void 0 === padString) {
                padString = " "
            }
            var str = String(item);
            targetLength >>= 0;
            if (str.length > targetLength) {
                return String(str)
            }
            targetLength -= str.length;
            if (targetLength > padString.length) {
                padString += repeat(padString, targetLength / padString.length)
            }
            return padString.slice(0, targetLength) + String(str)
        }
        var split = function(str, sep, num) {
            var splits = str.split(sep);
            return num ? splits.slice(0, num).concat([splits.slice(num).join(sep)]) : splits
        };
        var pymod = function(a, b) {
            var r = a % b;
            return r * b < 0 ? r + b : r
        };
        var divmod = function(a, b) {
            return {
                div: Math.floor(a / b),
                mod: pymod(a, b)
            }
        };
        var empty = function(obj) {
            return !isPresent(obj) || 0 === obj.length
        };
        var notEmpty = function(obj) {
            return !empty(obj)
        };
        var includes = function(arr, val) {
            return notEmpty(arr) && arr.indexOf(val) !== -1
        }
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/overlay.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./overlay/ui.overlay */ 327));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _ui.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/bindable_template.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.BindableTemplate = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _template_base = __webpack_require__( /*! ./template_base */ 75);
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _remove_event = _interopRequireDefault(__webpack_require__( /*! ../remove_event */ 150));
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var watchChanges = function() {
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {};
                var missedFields = fields.slice();
                var watchHandlers = fields.map(function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    watchHandlers.forEach(function(dispose) {
                        return dispose()
                    })
                }
            };
            return function(rawData, watchMethod, fields, fieldsMap, callback) {
                var fieldsDispose;
                var globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if ((0, _type.isPrimitive)(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            }
        }();
        var BindableTemplate = function(_TemplateBase) {
            _inherits(BindableTemplate, _TemplateBase);
            var _super = _createSuper(BindableTemplate);

            function BindableTemplate(render, fields, watchMethod, fieldsMap) {
                var _this;
                _classCallCheck(this, BindableTemplate);
                _this = _super.call(this);
                _this._render = render;
                _this._fields = fields;
                _this._fieldsMap = fieldsMap || {};
                _this._watchMethod = watchMethod;
                return _this
            }
            _createClass(BindableTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    var _this2 = this;
                    var $container = (0, _renderer.default)(options.container);
                    var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                        $container.empty();
                        _this2._render($container, data, options.model)
                    });
                    _events_engine.default.on($container, _remove_event.default, dispose);
                    return $container.contents()
                }
            }]);
            return BindableTemplate
        }(_template_base.TemplateBase);
        exports.BindableTemplate = BindableTemplate
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/dom_component.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/resize_callbacks */ 125));
        var _component = _interopRequireDefault(__webpack_require__( /*! ./component */ 127));
        var _template_manager = __webpack_require__( /*! ./template_manager */ 516);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);
        var _element_data = __webpack_require__( /*! ./element_data */ 40);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _common = __webpack_require__( /*! ./utils/common */ 4);
        var _array = __webpack_require__( /*! ./utils/array */ 13);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _short = __webpack_require__( /*! ../events/short */ 128);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _component.default.abstract;
        var DOMComponent = _component.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: (0, _config.default)().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                }, this._useTemplates() ? _template_manager.TemplateManager.createDefaultOptions() : {})
            },
            ctor: function(element, options) {
                this._createElement(element);
                (0, _public_component.attachInstanceToElement)(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _createElement: function(element) {
                this._$element = (0, _renderer.default)(element)
            },
            _getSynchronizableOptionsForCreateComponent: function() {
                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback();
                this._initTemplateManager()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    _resize_callbacks.default.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                (0, _window.hasWindow)() && this._render()
            },
            _initMarkup: function() {
                var _ref = this.option() || {},
                    rtlEnabled = _ref.rtlEnabled;
                this._renderElementAttributes();
                this._toggleRTLDirection(rtlEnabled);
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var _ref2 = this.option() || {},
                    elementAttr = _ref2.elementAttr;
                var attributes = (0, _extend.extend)({}, elementAttr);
                var classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (this._isVisibilityChangeSupported()) {
                    var $element = this.$element();
                    $element.addClass("dx-visibility-change-handler")
                }
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: null === width ? "" : width,
                        height: null === height ? "" : height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!((0, _type.isDefined)(width) || (0, _type.isDefined)(height) || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var _this = this;
                var $el = this.$element();
                var namespace = "".concat(this.NAME, "VisibilityChange");
                _short.resize.off($el, {
                    namespace: namespace
                });
                _short.resize.on($el, function() {
                    return _this._dimensionChanged()
                }, {
                    namespace: namespace
                })
            },
            _attachVisibilityChangeHandlers: function() {
                var _this2 = this;
                if (this._isVisibilityChangeSupported()) {
                    var $el = this.$element();
                    var namespace = "".concat(this.NAME, "VisibilityChange");
                    this._isHidden = !this._isVisible();
                    _short.visibility.off($el, {
                        namespace: namespace
                    });
                    _short.visibility.on($el, function() {
                        return _this2._checkVisibilityChanged("shown")
                    }, function() {
                        return _this2._checkVisibilityChanged("hiding")
                    }, {
                        namespace: namespace
                    })
                }
            },
            _isVisible: function() {
                var $element = this.$element();
                return $element.is(":visible")
            },
            _checkVisibilityChanged: function(action) {
                var isVisible = this._isVisible();
                if (isVisible) {
                    if ("hiding" === action && !this._isHidden) {
                        this._visibilityChanged(false);
                        this._isHidden = true
                    } else {
                        if ("shown" === action && this._isHidden) {
                            this._isHidden = false;
                            this._visibilityChanged(true)
                        }
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && (0, _window.hasWindow)()
            },
            _clean: _common.noop,
            _modelByElement: function() {
                var _this$option = this.option(),
                    modelByElement = _this$option.modelByElement;
                var $element = this.$element();
                return modelByElement ? modelByElement($element) : void 0
            },
            _invalidate: function() {
                if (this._isUpdateAllowed()) {
                    throw _errors.default.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this._templateManager && this._templateManager.dispose();
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    _resize_callbacks.default.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                var $element = this.$element();
                $element.toggleClass("dx-rtl", rtl)
            },
            _createComponent: function(element, component) {
                var _this3 = this;
                var config = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                var synchronizableOptions = (0, _common.grep)(this._getSynchronizableOptionsForCreateComponent(), function(value) {
                    return !(value in config)
                });
                var _this$option2 = this.option(),
                    integrationOptions = _this$option2.integrationOptions;
                var _this$option3 = this.option(),
                    nestedComponentOptions = _this$option3.nestedComponentOptions;
                nestedComponentOptions = nestedComponentOptions || _common.noop;
                var nestedComponentConfig = (0, _extend.extend)({
                    integrationOptions: integrationOptions
                }, nestedComponentOptions(this));
                synchronizableOptions.forEach(function(optionName) {
                    return nestedComponentConfig[optionName] = _this3.option(optionName)
                });
                this._extendConfig(config, nestedComponentConfig);
                var instance = void 0;
                if ((0, _type.isString)(component)) {
                    var $element = (0, _renderer.default)(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(_ref3) {
                        var name = _ref3.name,
                            value = _ref3.value;
                        if ((0, _array.inArray)(name, synchronizableOptions) >= 0) {
                            instance.option(name, value)
                        }
                    };
                    this.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        return _this3.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                (0, _iterator.each)(extendConfig, function(key, value) {
                    !Object.prototype.hasOwnProperty.call(config, key) && (config[key] = value)
                })
            },
            _defaultActionConfig: function() {
                var $element = this.$element();
                var context = this._modelByElement($element);
                return (0, _extend.extend)(this.callBase(), {
                    context: context
                })
            },
            _defaultActionArgs: function() {
                var $element = this.$element();
                var model = this._modelByElement($element);
                var element = this.element();
                return (0, _extend.extend)(this.callBase(), {
                    element: element,
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                        this._invalidate();
                        break;
                    case "elementAttr":
                        this._renderElementAttributes();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var attrs = element.attributes;
                for (var i = attrs.length - 1; i >= 0; i--) {
                    var attr = attrs[i];
                    if (attr) {
                        var name = attr.name;
                        if (!name.indexOf("aria-") || name.indexOf("dx-") !== -1 || "role" === name || "style" === name || "tabindex" === name) {
                            element.removeAttribute(name)
                        }
                    }
                }
            },
            _removeClasses: function(element) {
                element.className = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                }).join(" ")
            },
            _updateDOMComponent: function(renderRequired) {
                if (renderRequired) {
                    this._renderComponent()
                } else {
                    if (this._requireRefresh) {
                        this._requireRefresh = false;
                        this._refresh()
                    }
                }
            },
            endUpdate: function() {
                var renderRequired = this._isInitializingRequired();
                this.callBase();
                this._isUpdateAllowed() && this._updateDOMComponent(renderRequired)
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                var $element = this.$element();
                return (0, _element.getPublicElement)($element)
            },
            dispose: function() {
                var element = this.$element().get(0);
                (0, _element_data.cleanDataRecursive)(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            },
            resetOption: function(optionName) {
                this.callBase(optionName);
                if ("width" === optionName || "height" === optionName) {
                    var initialOption = this.initialOption(optionName);
                    !(0, _type.isDefined)(initialOption) && this.$element().css(optionName, "")
                }
            },
            _getAnonymousTemplateName: function() {
                return
            },
            _initTemplateManager: function() {
                if (this._templateManager || !this._useTemplates()) {
                    return
                }
                var _this$option4 = this.option(),
                    _this$option4$integra = _this$option4.integrationOptions,
                    integrationOptions = void 0 === _this$option4$integra ? {} : _this$option4$integra;
                var createTemplate = integrationOptions.createTemplate;
                this._templateManager = new _template_manager.TemplateManager(createTemplate, this._getAnonymousTemplateName());
                this._initTemplates()
            },
            _initTemplates: function() {
                var _this4 = this;
                var _this$_templateManage = this._templateManager.extractTemplates(this.$element()),
                    templates = _this$_templateManage.templates,
                    anonymousTemplateMeta = _this$_templateManage.anonymousTemplateMeta;
                var anonymousTemplate = this.option("integrationOptions.templates.".concat(anonymousTemplateMeta.name));
                templates.forEach(function(_ref4) {
                    var name = _ref4.name,
                        template = _ref4.template;
                    _this4._options.silent("integrationOptions.templates.".concat(name), template)
                });
                if (anonymousTemplateMeta.name && !anonymousTemplate) {
                    this._options.silent("integrationOptions.templates.".concat(anonymousTemplateMeta.name), anonymousTemplateMeta.template);
                    this._options.silent("_hasAnonymousTemplateContent", true)
                }
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                var templates = this.option("integrationOptions.templates");
                var isAsyncTemplate = this.option("templatesRenderAsynchronously");
                var skipTemplates = this.option("integrationOptions.skipTemplates");
                return this._templateManager.getTemplate(templateSource, templates, {
                    isAsyncTemplate: isAsyncTemplate,
                    skipTemplates: skipTemplates
                }, this)
            },
            _saveTemplate: function(name, template) {
                this._setOptionWithoutOptionChange("integrationOptions.templates." + name, this._templateManager._createTemplate(template))
            },
            _useTemplates: function() {
                return true
            }
        });
        DOMComponent.getInstance = function(element) {
            return (0, _public_component.getInstanceByElement)((0, _renderer.default)(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        var _default = DOMComponent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled-npm/data/data_source/data_source.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.DataSource = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));
        var _array_utils = __webpack_require__( /*! ../array_utils */ 91);
        var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 130));
        var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 98);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 38));
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _queue = __webpack_require__( /*! ../../core/utils/queue */ 252);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _operation_manager = _interopRequireDefault(__webpack_require__( /*! ./operation_manager */ 545));
        var _utils2 = __webpack_require__( /*! ./utils */ 70);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DataSource = _class.default.inherit({
            ctor: function(options) {
                var _options$reshapeOnPus, _this = this;
                options = (0, _utils2.normalizeDataSourceOptions)(options);
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                var onPushHandler = 0 !== options.pushAggregationTimeout ? _utils.default.throttleChanges(this._onPush, function() {
                    return void 0 === options.pushAggregationTimeout ? 5 * _this._changedTime : options.pushAggregationTimeout
                }) : this._onPush;
                this._changedTime = 0;
                this._onPushHandler = function(changes) {
                    _this._aggregationTimeoutId = onPushHandler.call(_this, changes)
                };
                this._store = options.store;
                this._store.on("push", this._onPushHandler);
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                this._reshapeOnPush = null !== (_options$reshapeOnPus = options.reshapeOnPush) && void 0 !== _options$reshapeOnPus ? _options$reshapeOnPus : false;
                (0, _iterator.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        _this.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new _operation_manager.default;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!(0, _type.isDefined)(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                var _this$_delayedLoadTas;
                this._store.off("push", this._onPushHandler);
                this._eventsStrategy.dispose();
                clearTimeout(this._aggregationTimeoutId);
                delete this._store;
                null === (_this$_delayedLoadTas = this._delayedLoadTask) || void 0 === _this$_delayedLoadTas ? void 0 : _this$_delayedLoadTas.abort();
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {};
                var names = ["sort", "filter", "select", "group", "requireTotalCount"];
                var customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }(0, _iterator.each)(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!(0, _type.isNumeric)(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!(0, _type.isNumeric)(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            generateStoreLoadOptionAccessor: function(optionName) {
                var _this2 = this;
                return function(args) {
                    var normalizedArgs = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(args);
                    if (void 0 === normalizedArgs) {
                        return _this2._storeLoadOptions[optionName]
                    }
                    _this2._storeLoadOptions[optionName] = normalizedArgs
                }
            },
            sort: function() {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key]
                }
                return this.generateStoreLoadOptionAccessor("sort")(args)
            },
            filter: function() {
                var newFilter = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: function() {
                for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                    args[_key2] = arguments[_key2]
                }
                return this.generateStoreLoadOptionAccessor("group")(args)
            },
            select: function() {
                for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                    args[_key3] = arguments[_key3]
                }
                return this.generateStoreLoadOptionAccessor("select")(args)
            },
            requireTotalCount: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!(0, _type.isString)(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                var _this$_store;
                return null === (_this$_store = this._store) || void 0 === _this$_store ? void 0 : _this$_store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return (0, _queue.create)()
            },
            _changeLoadingCount: function(increment) {
                var oldLoading = this.isLoading();
                this._loadingCount += increment;
                var newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this._eventsStrategy.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var _this3 = this;
                this.beginLoading();
                deferred.always(function() {
                    _this3.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var _this4 = this;
                deferred.fail(function() {
                    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                        args[_key4] = arguments[_key4]
                    }
                    if (args[0] === _utils2.CANCELED_TOKEN) {
                        return
                    }
                    _this4._eventsStrategy.fireEvent("loadError", args)
                })
            },
            _fireChanged: function(args) {
                var date = new Date;
                this._eventsStrategy.fireEvent("changed", args);
                this._changedTime = new Date - date
            },
            _scheduleChangedCallbacks: function(deferred) {
                var _this5 = this;
                deferred.done(function() {
                    return _this5._fireChanged()
                })
            },
            loadSingle: function(propName, propValue) {
                var _this6 = this;
                var d = new _deferred.Deferred;
                var key = this.key();
                var store = this._store;
                var options = this._createStoreLoadOptions();
                var handleDone = function(data) {
                    if (!(0, _type.isDefined)(data) || (0, _array.isEmpty)(data)) {
                        d.reject(new _errors.default.errors.Error("E4009"))
                    } else {
                        if (!Array.isArray(data)) {
                            data = [data]
                        }
                        d.resolve(_this6._applyMapFunction(data)[0])
                    }
                };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;
                var shouldForceByKey = function() {
                    return store instanceof _custom_store.default && !store._byKeyViaLoad()
                };
                (function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var _this7 = this;
                var d = new _deferred.Deferred;
                var loadTask = function() {
                    if (_this7._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(d)) {
                        return
                    }
                    return _this7._loadFromStore(loadOperation, d)
                };
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                var loadOperation = this._createLoadOperation(d);
                this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        _this7._delayedLoadTask = (0, _common.executeAsync)(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _onPush: function(changes) {
                var _this8 = this;
                if (this._reshapeOnPush) {
                    this.load()
                } else {
                    this._eventsStrategy.fireEvent("changing", [{
                        changes: changes
                    }]);
                    var group = this.group();
                    var items = this.items();
                    var groupLevel = 0;
                    var dataSourceChanges = this.paginate() || group ? changes.filter(function(item) {
                        return "update" === item.type
                    }) : changes;
                    if (group) {
                        groupLevel = Array.isArray(group) ? group.length : 1
                    }
                    if (this._mapFunc) {
                        dataSourceChanges.forEach(function(item) {
                            if ("insert" === item.type) {
                                item.data = _this8._mapFunc(item.data)
                            }
                        })
                    }(0, _array_utils.applyBatch)({
                        keyInfo: this.store(),
                        data: items,
                        changes: dataSourceChanges,
                        groupCount: groupLevel,
                        useInsertIndex: true
                    });
                    this._fireChanged([{
                        changes: changes
                    }])
                }
            },
            _createLoadOperation: function(deferred) {
                var _this9 = this;
                var operationId = this._operationManager.add(deferred);
                var storeLoadOptions = this._createStoreLoadOptions();
                deferred.always(function() {
                    return _this9._operationManager.remove(operationId)
                });
                return {
                    operationId: operationId,
                    storeLoadOptions: storeLoadOptions
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof _custom_store.default) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            cancelAll: function() {
                return this._operationManager.cancelAll()
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = (0, _extend.extend)({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue;
                var op = this._searchOperation;
                var selector = this._searchExpr;
                var searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }(0, _iterator.each)(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var _this10 = this;
                var handleSuccess = function(data, extra) {
                    if (_this10._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(pendingDeferred)) {
                        return
                    }
                    var loadResult = (0, _extend.extend)((0, _utils2.normalizeLoadResult)(data, extra), loadOptions);
                    _this10._eventsStrategy.fireEvent("customizeLoadResult", [loadResult]);
                    (0, _deferred.when)(loadResult.data).done(function(data) {
                        loadResult.data = data;
                        _this10._processStoreLoadResult(loadResult, pendingDeferred)
                    }).fail(pendingDeferred.reject)
                };
                if (loadOptions.data) {
                    return (new _deferred.Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var _this11 = this;
                var data = loadResult.data;
                var extra = loadResult.extra;
                var storeLoadOptions = loadResult.storeLoadOptions;
                var resolvePendingDeferred = function() {
                    _this11._isLoaded = true;
                    _this11._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                };
                var proceedLoadingTotalCount = function() {
                    _this11.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                };
                if (this._disposed) {
                    return
                }
                data = this._applyPostProcessFunction(this._applyMapFunction(data));
                if (!(0, _type.isPlainObject)(extra)) {
                    extra = {}
                }
                this._items = data;
                if (!data.length || !this._paginate || this._pageSize && data.length < this._pageSize) {
                    this._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return (0, _utils2.mapDataRespectingGrouping)(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        exports.DataSource = DataSource
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled-npm/data/data_source/utils.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.normalizeDataSourceOptions = exports.normalizeLoadResult = exports.mapDataRespectingGrouping = exports.normalizeStoreLoadOptionAccessorArguments = exports.isPending = exports.CANCELED_TOKEN = void 0;
        var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 80));
        var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../abstract_store */ 104));
        var _array_store = _interopRequireDefault(__webpack_require__( /*! ../array_store */ 77));
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 130));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function ownKeys(object, enumerableOnly) {
            var keys = Object.keys(object);
            if (Object.getOwnPropertySymbols) {
                var symbols = Object.getOwnPropertySymbols(object);
                if (enumerableOnly) {
                    symbols = symbols.filter(function(sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable
                    })
                }
                keys.push.apply(keys, symbols)
            }
            return keys
        }

        function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = null != arguments[i] ? arguments[i] : {};
                if (i % 2) {
                    ownKeys(Object(source), true).forEach(function(key) {
                        _defineProperty(target, key, source[key])
                    })
                } else {
                    if (Object.getOwnPropertyDescriptors) {
                        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                    } else {
                        ownKeys(Object(source)).forEach(function(key) {
                            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key))
                        })
                    }
                }
            }
            return target
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }

        function _objectWithoutProperties(source, excluded) {
            if (null == source) {
                return {}
            }
            var target = _objectWithoutPropertiesLoose(source, excluded);
            var key, i;
            if (Object.getOwnPropertySymbols) {
                var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
                for (i = 0; i < sourceSymbolKeys.length; i++) {
                    key = sourceSymbolKeys[i];
                    if (excluded.indexOf(key) >= 0) {
                        continue
                    }
                    if (!Object.prototype.propertyIsEnumerable.call(source, key)) {
                        continue
                    }
                    target[key] = source[key]
                }
            }
            return target
        }

        function _objectWithoutPropertiesLoose(source, excluded) {
            if (null == source) {
                return {}
            }
            var target = {};
            var sourceKeys = Object.keys(source);
            var key, i;
            for (i = 0; i < sourceKeys.length; i++) {
                key = sourceKeys[i];
                if (excluded.indexOf(key) >= 0) {
                    continue
                }
                target[key] = source[key]
            }
            return target
        }
        var CANCELED_TOKEN = "canceled";
        exports.CANCELED_TOKEN = CANCELED_TOKEN;
        var isPending = function(deferred) {
            return "pending" === deferred.state()
        };
        exports.isPending = isPending;
        var normalizeStoreLoadOptionAccessorArguments = function(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        };
        exports.normalizeStoreLoadOptionAccessorArguments = normalizeStoreLoadOptionAccessorArguments;
        var mapGroup = function(group, level, mapper) {
            return (0, _iterator.map)(group, function(item) {
                var restItem = (item.items, _objectWithoutProperties(item, ["items"]));
                return _objectSpread(_objectSpread({}, restItem), {}, {
                    items: mapRecursive(item.items, level - 1, mapper)
                })
            })
        };
        var mapRecursive = function(items, level, mapper) {
            if (!Array.isArray(items)) {
                return items
            }
            return level ? mapGroup(items, level, mapper) : (0, _iterator.map)(items, mapper)
        };
        var mapDataRespectingGrouping = function(items, mapper, groupInfo) {
            var level = groupInfo ? _utils.default.normalizeSortingInfo(groupInfo).length : 0;
            return mapRecursive(items, level, mapper)
        };
        exports.mapDataRespectingGrouping = mapDataRespectingGrouping;
        var normalizeLoadResult = function(data, extra) {
            var _data;
            if (null === (_data = data) || void 0 === _data ? void 0 : _data.data) {
                extra = data;
                data = data.data
            }
            if (!Array.isArray(data)) {
                data = [data]
            }
            return {
                data: data,
                extra: extra
            }
        };
        exports.normalizeLoadResult = normalizeLoadResult;
        var createCustomStoreFromLoadFunc = function(options) {
            var storeConfig = {};
            (0, _iterator.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                storeConfig[this] = options[this];
                delete options[this]
            });
            return new _custom_store.default(storeConfig)
        };
        var createStoreFromConfig = function(storeConfig) {
            var alias = storeConfig.type;
            delete storeConfig.type;
            return _abstract_store.default.create(alias, storeConfig)
        };
        var createCustomStoreFromUrl = function(url, normalizationOptions) {
            return new _custom_store.default({
                load: function() {
                    return _ajax.default.sendRequest({
                        url: url,
                        dataType: "json"
                    })
                },
                loadMode: null === normalizationOptions || void 0 === normalizationOptions ? void 0 : normalizationOptions.fromUrlLoadMode
            })
        };
        var normalizeDataSourceOptions = function(options, normalizationOptions) {
            var store;
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options, normalizationOptions)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof _abstract_store.default) {
                options = {
                    store: options
                }
            } else {
                options = (0, _extend.extend)({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc(options)
            } else {
                if (Array.isArray(store)) {
                    store = new _array_store.default(store)
                } else {
                    if ((0, _type.isPlainObject)(store)) {
                        store = createStoreFromConfig((0, _extend.extend)({}, store))
                    }
                }
            }
            options.store = store;
            return options
        };
        exports.normalizeDataSourceOptions = normalizeDataSourceOptions
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/selectors.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.focused = exports.tabbable = exports.focusable = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var focusableFn = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase();
            var isTabIndexNotNaN = !isNaN(tabIndex);
            var isDisabled = element.disabled;
            var isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName);
            var isHyperlink = "a" === nodeName;
            var isFocusable = true;
            var isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };

        function visible(element) {
            var $element = (0, _renderer.default)(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        }
        var focusable = function(index, element) {
            return focusableFn(element, (0, _renderer.default)(element).attr("tabIndex"))
        };
        exports.focusable = focusable;
        var tabbable = function(index, element) {
            var tabIndex = (0, _renderer.default)(element).attr("tabIndex");
            return (isNaN(tabIndex) || tabIndex >= 0) && focusableFn(element, tabIndex)
        };
        exports.tabbable = tabbable;
        var focused = function($element) {
            var element = (0, _renderer.default)($element).get(0);
            return _dom_adapter.default.getActiveElement() === element
        };
        exports.focused = focused
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/format_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ./core/utils/type */ 1);
        var _date = _interopRequireDefault(__webpack_require__( /*! ./core/utils/date */ 19));
        var _number = _interopRequireDefault(__webpack_require__( /*! ./localization/number */ 47));
        var _date2 = _interopRequireDefault(__webpack_require__( /*! ./localization/date */ 32));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./core/utils/dependency_injector */ 59));
        __webpack_require__( /*! ./localization/currency */ 113);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _dependency_injector.default)({
            format: function(value, _format) {
                var formatIsValid = (0, _type.isString)(_format) && "" !== _format || (0, _type.isPlainObject)(_format) || (0, _type.isFunction)(_format);
                var valueIsValid = (0, _type.isNumeric)(value) || (0, _type.isDate)(value);
                if (!formatIsValid || !valueIsValid) {
                    return (0, _type.isDefined)(value) ? value.toString() : ""
                }
                if ((0, _type.isFunction)(_format)) {
                    return _format(value)
                }
                if ((0, _type.isString)(_format)) {
                    _format = {
                        type: _format
                    }
                }
                if ((0, _type.isNumeric)(value)) {
                    return _number.default.format(value, _format)
                }
                if ((0, _type.isDate)(value)) {
                    return _date2.default.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return _date2.default.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [];
                var needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return _date2.default.getMonthNames("abbreviated")[date.getMonth()] + " " + _date2.default.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return _date2.default.format(date, "dayofweek") + ", " + _date2.default.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var maxDiff;
                var currentDiff;
                var i;
                if (ticks.length > 1) {
                    maxDiff = _date.default.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = _date.default.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                var resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var dateUnitInterval;
                var dateDifferencesConverter = {
                    week: "day"
                };
                var correctDateDifferences = function(dateDifferences, tickInterval, value) {
                    switch (tickInterval) {
                        case "year":
                        case "quarter":
                            dateDifferences.month = value;
                        case "month":
                            dateDifferences.day = value;
                        case "week":
                        case "day":
                            dateDifferences.hour = value;
                        case "hour":
                            dateDifferences.minute = value;
                        case "minute":
                            dateDifferences.second = value;
                        case "second":
                            dateDifferences.millisecond = value
                    }
                };
                var correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                    if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                        if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                            differences.millisecond = true;
                            differences.second = false
                        }
                    } else {
                        if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                            if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                differences.second = true;
                                differences.minute = false
                            }
                        } else {
                            if (!maxDate.getMinutes() && maxDate.getHours()) {
                                if (maxDate.getHours() - minDate.getHours() === 1) {
                                    differences.minute = true;
                                    differences.hour = false
                                }
                            } else {
                                if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                    if (maxDate.getDate() - minDate.getDate() === 1) {
                                        differences.hour = true;
                                        differences.day = false
                                    }
                                } else {
                                    if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                        if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                            differences.day = true;
                                            differences.month = false
                                        }
                                    } else {
                                        if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                            if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                differences.month = true;
                                                differences.year = false
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                tickInterval = (0, _type.isString)(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                var dateDifferences = _date.default.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = _date.default.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = _date.default.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                var resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/polyfills/promise.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var promise = (0, _window.hasWindow)() ? (0, _window.getWindow)().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new _deferred.Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new _deferred.Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new _deferred.Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return _deferred.when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        var _default = promise;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/event_registrator.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _event_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./event_registrator_callbacks */ 131));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }(0, _iterator.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            _event_registrator_callbacks.default.fire(name, strategy)
        };
        registerEvent.callbacks = _event_registrator_callbacks.default;
        var _default = registerEvent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/template_base.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.TemplateBase = exports.renderedCallbacks = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../utils/callbacks */ 27));
        var _dom = __webpack_require__( /*! ../utils/dom */ 33);
        var _visibility_change = __webpack_require__( /*! ../../events/visibility_change */ 53);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var renderedCallbacks = (0, _callbacks.default)({
            syncStrategy: true
        });
        exports.renderedCallbacks = renderedCallbacks;
        var TemplateBase = function() {
            function TemplateBase() {
                _classCallCheck(this, TemplateBase)
            }
            _createClass(TemplateBase, [{
                key: "render",
                value: function(options) {
                    options = options || {};
                    var onRendered = options.onRendered;
                    delete options.onRendered;
                    var $result = this._renderCore(options);
                    this._ensureResultInContainer($result, options.container);
                    renderedCallbacks.fire($result, options.container);
                    onRendered && onRendered();
                    return $result
                }
            }, {
                key: "_ensureResultInContainer",
                value: function($result, container) {
                    if (!container) {
                        return
                    }
                    var $container = (0, _renderer.default)(container);
                    var resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                    $container.append($result);
                    if (resultInContainer) {
                        return
                    }
                    var resultInBody = _dom_adapter.default.getBody().contains($container.get(0));
                    if (!resultInBody) {
                        return
                    }(0, _visibility_change.triggerShownEvent)($result)
                }
            }, {
                key: "_renderCore",
                value: function() {
                    throw _errors.default.Error("E0001")
                }
            }]);
            return TemplateBase
        }();
        exports.TemplateBase = TemplateBase
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/events/drag.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        exports.drop = exports.leave = exports.enter = exports.end = exports.start = exports.move = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _element_data = __webpack_require__( /*! ../core/element_data */ 40);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var iteratorUtils = _interopRequireWildcard(__webpack_require__( /*! ../core/utils/iterator */ 3));
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 33);
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 74));
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./gesture/emitter.gesture */ 175));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DRAG_START_EVENT = "dxdragstart";
        exports.start = DRAG_START_EVENT;
        var DRAG_EVENT = "dxdrag";
        exports.move = DRAG_EVENT;
        var DRAG_END_EVENT = "dxdragend";
        exports.end = DRAG_END_EVENT;
        var DRAG_ENTER_EVENT = "dxdragenter";
        exports.enter = DRAG_ENTER_EVENT;
        var DRAG_LEAVE_EVENT = "dxdragleave";
        exports.leave = DRAG_LEAVE_EVENT;
        var DROP_EVENT = "dxdrop";
        exports.drop = DROP_EVENT;
        var DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [];
        var knownDropTargetSelectors = [];
        var knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = (0, _array.inArray)(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = (0, _array.inArray)(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if ((0, _array.inArray)(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = (0, _array.inArray)(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    (0, _element_data.removeData)(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        (0, _event_registrator.default)(DRAG_ENTER_EVENT, dropTargetRegistration);
        (0, _event_registrator.default)(DRAG_LEAVE_EVENT, dropTargetRegistration);
        (0, _event_registrator.default)(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = (0, _array.inArray)($element.get(0), knownDropTargets);
            var dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex].filter(function(selector) {
                return selector
            });
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if ((0, _array.inArray)(void 0, knownDropTargetSelectors[dropTargetIndex]) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = (0, _array.inArray)($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = _emitter.default.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = (0, _array.wrapToArray)(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return (0, _renderer.default)(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = (0, _index.eventData)(e);
                var dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e);
                var sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                (0, _index.fireEvent)(eventData)
            },
            _findDropTarget: function(e) {
                var that = this;
                var result;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = (0, _renderer.default)(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = (0, _renderer.default)(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, (0, _renderer.default)(result), e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || (0, _dom.contains)(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, $prevTarget, e) {
                var isDraggingElement = $target.get(0) === (0, _renderer.default)(e.target).get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                if ($prevTarget.length && $prevTarget.closest($target).length) {
                    return false
                }
                if (config.checkDropTarget && !config.checkDropTarget($target, e)) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = (0, _index.eventData)(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        (0, _emitter_registrator.default)({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/array_store.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));
        var _query = _interopRequireDefault(__webpack_require__( /*! ./query */ 48));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ./abstract_store */ 104));
        var _array_utils = __webpack_require__( /*! ./array_utils */ 91);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ArrayStore = _abstract_store.default.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw _errors.default.errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return (0, _query.default)(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = (0, _array_utils.indexByKey)(this, this._array, key);
                if (index === -1) {
                    return _utils.default.rejectedPromise(_errors.default.errors.Error("E4009"))
                }
                return _utils.default.trivialPromise(this._array[index])
            },
            _insertImpl: function(values) {
                return (0, _array_utils.insert)(this, this._array, values)
            },
            _pushImpl: function(changes) {
                (0, _array_utils.applyBatch)({
                    keyInfo: this,
                    data: this._array,
                    changes: changes
                })
            },
            _updateImpl: function(key, values) {
                return (0, _array_utils.update)(this, this._array, key, values)
            },
            _removeImpl: function(key) {
                return (0, _array_utils.remove)(this, this._array, key)
            },
            clear: function() {
                this._eventsStrategy.fireEvent("modifying");
                this._array = [];
                this._eventsStrategy.fireEvent("modified")
            }
        }, "array");
        var _default = ArrayStore;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/call_once.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        var _default = callOnce;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/ajax.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _deferred = __webpack_require__( /*! ./deferred */ 6);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _http_request = _interopRequireDefault(__webpack_require__( /*! ../../core/http_request */ 504));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../polyfills/promise */ 73));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var SUCCESS = "success";
        var ERROR = "error";
        var TIMEOUT = "timeout";
        var NO_CONTENT = "nocontent";
        var PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = _dom_adapter.default.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return _dom_adapter.default.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new _promise.default(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    _dom_adapter.default.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*";
            var scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript";
            var accepts = {
                "*": "*/*",
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript",
                jsonp: scriptAccept,
                script: scriptAccept
            };
            (0, _extend.extendFromObject)(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!(0, _window.hasWindow)()) {
                return true
            }
            var crossDomain = false;
            var originAnchor = _dom_adapter.default.createElement("a");
            var urlAnchor = _dom_adapter.default.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, "");
                var callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random;
                var callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data;
            var paramsAlreadyString = "string" === typeof params;
            var url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };

        function getMethod(options) {
            return (options.method || "GET").toUpperCase()
        }
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var xhr = _http_request.default.getXhr();
            var d = new _deferred.Deferred;
            var result = d.promise();
            var async = (0, _type.isDefined)(options.async) ? options.async : true;
            var dataType = options.dataType;
            var timeout = options.timeout || 0;
            var timeoutId;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options);
            var headers = getRequestHeaders(options);
            var requestOptions = getRequestOptions(options, headers);
            var url = requestOptions.url;
            var parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                    d.reject(xhr, ERROR)
                };
                var resolve = function() {
                    if ("jsonp" === dataType) {
                        return
                    }
                    d.resolve(null, SUCCESS, xhr)
                };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (Object.prototype.hasOwnProperty.call(headers, name) && (0, _type.isDefined)(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        var _default = (0, _dependency_injector.default)({
            sendRequest: sendRequest
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/view_port.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.originalViewPort = originalViewPort;
        exports.changeCallback = exports.value = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 49));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 27));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ready = _ready_callbacks.default.add;
        var changeCallback = (0, _callbacks.default)();
        exports.changeCallback = changeCallback;
        var $originalViewPort = (0, _renderer.default)();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = (0, _renderer.default)(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : (0, _renderer.default)("body");
                changeCallback.fire(isNewViewportFound ? value() : (0, _renderer.default)(), prevViewPort)
            }
        }();
        exports.value = value;
        ready(function() {
            value(".dx-viewport")
        });

        function originalViewPort() {
            return $originalViewPort
        }
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/position.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _position = __webpack_require__( /*! ../core/utils/position */ 23);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 22));
        var _translator = __webpack_require__( /*! ./translator */ 28);
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var horzRe = /left|right/;
        var vertRe = /top|bottom/;
        var collisionRe = /fit|flip|none/;
        var IS_SAFARI = _browser.default.safari;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = (0, _common.splitPair)(raw);
            if (pair) {
                (0, _iterator.each)(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return (0, _common.pairToObject)(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = (0, _common.splitPair)(raw);
            var h = String(pair && pair[0]).toLowerCase();
            var v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = (0, _extend.extend)({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = (0, _renderer.default)("<div>").css({
                width: 100,
                height: 100,
                overflow: "scroll",
                position: "absolute",
                top: -9999
            }).appendTo((0, _renderer.default)("body"));
            var result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = (0, _renderer.default)(what);
            var currentOffset = $what.offset();
            var result = (0, _extend.extend)(true, {}, defaultPositionResult, {
                h: {
                    location: currentOffset.left
                },
                v: {
                    location: currentOffset.top
                }
            });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my);
            var at = normalizeAlign(options.at);
            var of = (0, _renderer.default)(options.of).length && options.of || window;
            var offset = normalizeOffset(options.offset);
            var collision = normalizeCollision(options.collision);
            var boundary = options.boundary;
            var boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else {
                of = (0, _renderer.default)( of );
                if ((0, _type.isWindow)( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    if ("phone" === _devices.default.real().deviceType && of [0].visualViewport) {
                        h.atLocation = Math.max(h.atLocation, of [0].visualViewport.offsetLeft);
                        v.atLocation = Math.max(v.atLocation, of [0].visualViewport.offsetTop);
                        h.atSize = of [0].visualViewport.width;
                        v.atSize = of [0].visualViewport.height
                    } else {
                        h.atSize = of [0].innerWidth >= of [0].outerWidth ? of [0].innerWidth : of .width();
                        v.atSize = of [0].innerHeight >= of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : of .height()
                    }
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var ofRect = (0, _position.getBoundingRect)( of .get(0));
                        var o = getOffsetWithoutScale( of );
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = Math.max(ofRect.width, of .outerWidth());
                        v.atSize = Math.max(ofRect.height, of .outerHeight())
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = (0, _renderer.default)(window);
                var windowWidth = win.width();
                var windowHeight = win.height();
                var left = win.scrollLeft();
                var top = win.scrollTop();
                var documentElement = _dom_adapter.default.getDocumentElement();
                var hZoomLevel = _support.touch ? documentElement.clientWidth / windowWidth : 1;
                var vZoomLevel = _support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth;
                var boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = (0, _renderer.default)(boundary);
                    var boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            (0, _extend.extend)(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var getOffsetWithoutScale = function getOffsetWithoutScale($startElement) {
            var $currentElement = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : $startElement;
            var currentElement = $currentElement.get(0);
            if (!currentElement || $currentElement.is("body")) {
                return $startElement.offset()
            }
            var transform = $currentElement.get(0).style.transform;
            var scale = (transform.match(/scale(.+)/) || [])[0];
            currentElement.style.transform = transform.replace(scale, "");
            var offset = getOffsetWithoutScale($startElement, $currentElement.parent());
            currentElement.style.transform = transform;
            return offset
        };
        var position = function(what, options) {
            var $what = (0, _renderer.default)(what);
            if (!options) {
                return $what.offset()
            }(0, _translator.resetPosition)($what, true);
            var offset = getOffsetWithoutScale($what);
            var targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            (0, _translator.move)($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = (0, _renderer.default)(element).get(0);
            if ((0, _type.isWindow)(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return (0, _renderer.default)(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        var _default = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/utils.ink_ripple.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.showWave = showWave;
        exports.hideWave = hideWave;
        exports.render = exports.initConfig = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var INKRIPPLE_CLASS = "dx-inkripple";
        var INKRIPPLE_WAVE_CLASS = "dx-inkripple-wave";
        var INKRIPPLE_SHOWING_CLASS = "dx-inkripple-showing";
        var INKRIPPLE_HIDING_CLASS = "dx-inkripple-hiding";
        var DEFAULT_WAVE_SIZE_COEFFICIENT = 2;
        var MAX_WAVE_SIZE = 4e3;
        var ANIMATION_DURATION = 300;
        var HOLD_ANIMATION_DURATION = 1e3;
        var DEFAULT_WAVE_INDEX = 0;
        var initConfig = function() {
            var config = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
            var useHoldAnimation = config.useHoldAnimation,
                waveSizeCoefficient = config.waveSizeCoefficient,
                isCentered = config.isCentered,
                wavesNumber = config.wavesNumber;
            return {
                waveSizeCoefficient: waveSizeCoefficient || DEFAULT_WAVE_SIZE_COEFFICIENT,
                isCentered: isCentered || false,
                wavesNumber: wavesNumber || 1,
                durations: getDurations(null !== useHoldAnimation && void 0 !== useHoldAnimation ? useHoldAnimation : true)
            }
        };
        exports.initConfig = initConfig;
        var render = function(args) {
            var config = initConfig(args);
            return {
                showWave: showWave.bind(this, config),
                hideWave: hideWave.bind(this, config)
            }
        };
        exports.render = render;
        var getInkRipple = function(element) {
            var result = element.children("." + INKRIPPLE_CLASS);
            if (0 === result.length) {
                result = (0, _renderer.default)("<div>").addClass(INKRIPPLE_CLASS).appendTo(element)
            }
            return result
        };
        var getWaves = function(element, wavesNumber) {
            var inkRipple = getInkRipple((0, _renderer.default)(element));
            var result = inkRipple.children("." + INKRIPPLE_WAVE_CLASS).toArray();
            for (var i = result.length; i < wavesNumber; i++) {
                var $currentWave = (0, _renderer.default)("<div>").appendTo(inkRipple).addClass(INKRIPPLE_WAVE_CLASS);
                result.push($currentWave[0])
            }
            return (0, _renderer.default)(result)
        };
        var getWaveStyleConfig = function(args, config) {
            var element = (0, _renderer.default)(config.element);
            var elementWidth = element.outerWidth();
            var elementHeight = element.outerHeight();
            var elementDiagonal = parseInt(Math.sqrt(elementWidth * elementWidth + elementHeight * elementHeight));
            var waveSize = Math.min(MAX_WAVE_SIZE, parseInt(elementDiagonal * args.waveSizeCoefficient));
            var left;
            var top;
            if (args.isCentered) {
                left = (elementWidth - waveSize) / 2;
                top = (elementHeight - waveSize) / 2
            } else {
                var event = config.event;
                var position = element.offset();
                var x = event.pageX - position.left;
                var y = event.pageY - position.top;
                left = x - waveSize / 2;
                top = y - waveSize / 2
            }
            return {
                left: left,
                top: top,
                height: waveSize,
                width: waveSize
            }
        };

        function showWave(args, config) {
            var $wave = getWaves(config.element, args.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            args.hidingTimeout && clearTimeout(args.hidingTimeout);
            hideSelectedWave($wave);
            $wave.css(getWaveStyleConfig(args, config));
            args.showingTimeout = setTimeout(showingWaveHandler.bind(this, args, $wave), 0)
        }

        function showingWaveHandler(args, $wave) {
            var durationCss = args.durations.showingScale + "ms";
            $wave.addClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss)
        }

        function getDurations(useHoldAnimation) {
            return {
                showingScale: useHoldAnimation ? HOLD_ANIMATION_DURATION : ANIMATION_DURATION,
                hidingScale: ANIMATION_DURATION,
                hidingOpacity: ANIMATION_DURATION
            }
        }

        function hideSelectedWave($wave) {
            $wave.removeClass(INKRIPPLE_HIDING_CLASS).css("transitionDuration", "")
        }

        function hideWave(args, config) {
            args.showingTimeout && clearTimeout(args.showingTimeout);
            var $wave = getWaves(config.element, config.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            var durations = args.durations;
            var durationCss = durations.hidingScale + "ms, " + durations.hidingOpacity + "ms";
            $wave.addClass(INKRIPPLE_HIDING_CLASS).removeClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss);
            var animationDuration = Math.max(durations.hidingScale, durations.hidingOpacity);
            args.hidingTimeout = setTimeout(hideSelectedWave.bind(this, $wave), animationDuration)
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/load_indicator.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _themes = __webpack_require__( /*! ./themes */ 34);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 9));
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./widget/ui.widget */ 16));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var navigator = (0, _window.getNavigator)();
        var LOADINDICATOR_CLASS = "dx-loadindicator";
        var LOADINDICATOR_WRAPPER_CLASS = "dx-loadindicator-wrapper";
        var LOADINDICATOR_CONTENT_CLASS = "dx-loadindicator-content";
        var LOADINDICATOR_ICON_CLASS = "dx-loadindicator-icon";
        var LOADINDICATOR_SEGMENT_CLASS = "dx-loadindicator-segment";
        var LOADINDICATOR_SEGMENT_INNER_CLASS = "dx-loadindicator-segment-inner";
        var LOADINDICATOR_IMAGE_CLASS = "dx-loadindicator-image";
        var LoadIndicator = _ui.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    indicatorSrc: "",
                    activeStateEnabled: false,
                    hoverStateEnabled: false,
                    _animatingSegmentCount: 1,
                    _animatingSegmentInner: false
                })
            },
            _defaultOptionsRules: function() {
                var themeName = (0, _themes.current)();
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = _devices.default.real();
                        var obsoleteAndroid = "android" === realDevice.platform && !/chrome/i.test(navigator.userAgent);
                        return obsoleteAndroid
                    },
                    options: {
                        viaImage: true
                    }
                }, {
                    device: function() {
                        return (0, _themes.isMaterial)(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 2,
                        _animatingSegmentInner: true
                    }
                }, {
                    device: function() {
                        return (0, _themes.isGeneric)(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 7
                    }
                }])
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(LOADINDICATOR_CLASS)
            },
            _initMarkup: function() {
                this.callBase();
                this._renderWrapper();
                this._renderIndicatorContent();
                this._renderMarkup()
            },
            _renderWrapper: function() {
                this._$wrapper = (0, _renderer.default)("<div>").addClass(LOADINDICATOR_WRAPPER_CLASS);
                this.$element().append(this._$wrapper)
            },
            _renderIndicatorContent: function() {
                this._$content = (0, _renderer.default)("<div>").addClass(LOADINDICATOR_CONTENT_CLASS);
                this._$wrapper.append(this._$content)
            },
            _renderMarkup: function() {
                if ((0, _support.animation)() && !this.option("viaImage") && !this.option("indicatorSrc")) {
                    this._renderMarkupForAnimation()
                } else {
                    this._renderMarkupForImage()
                }
            },
            _renderMarkupForAnimation: function() {
                var animatingSegmentInner = this.option("_animatingSegmentInner");
                this._$indicator = (0, _renderer.default)("<div>").addClass(LOADINDICATOR_ICON_CLASS);
                this._$content.append(this._$indicator);
                for (var i = this.option("_animatingSegmentCount"); i >= 0; --i) {
                    var $segment = (0, _renderer.default)("<div>").addClass(LOADINDICATOR_SEGMENT_CLASS).addClass(LOADINDICATOR_SEGMENT_CLASS + i);
                    if (animatingSegmentInner) {
                        $segment.append((0, _renderer.default)("<div>").addClass(LOADINDICATOR_SEGMENT_INNER_CLASS))
                    }
                    this._$indicator.append($segment)
                }
            },
            _renderMarkupForImage: function() {
                var indicatorSrc = this.option("indicatorSrc");
                this._$wrapper.addClass(LOADINDICATOR_IMAGE_CLASS);
                if (indicatorSrc) {
                    this._$wrapper.css("backgroundImage", "url(" + indicatorSrc + ")")
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._updateContentSizeForAnimation()
            },
            _updateContentSizeForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                var width = this.option("width");
                var height = this.option("height");
                if (width || height) {
                    width = this.$element().width();
                    height = this.$element().height();
                    var minDimension = Math.min(height, width);
                    this._$wrapper.css({
                        height: minDimension,
                        width: minDimension,
                        fontSize: minDimension
                    })
                }
            },
            _clean: function() {
                this.callBase();
                this._removeMarkupForAnimation();
                this._removeMarkupForImage()
            },
            _removeMarkupForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                this._$indicator.remove();
                delete this._$indicator
            },
            _removeMarkupForImage: function() {
                this._$wrapper.css("backgroundImage", "none")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_animatingSegmentCount":
                    case "_animatingSegmentInner":
                    case "indicatorSrc":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        (0, _component_registrator.default)("dxLoadIndicator", LoadIndicator);
        var _default = LoadIndicator;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***********************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/pivot_grid/ui.pivot_grid.utils.js ***!
      \***********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.sendRequest = sendRequest;
        exports.findField = findField;
        exports.formatValue = formatValue;
        exports.getCompareFunction = getCompareFunction;
        exports.createPath = createPath;
        exports.foreachDataLevel = foreachDataLevel;
        exports.mergeArraysByMaxValue = mergeArraysByMaxValue;
        exports.getExpandedLevel = getExpandedLevel;
        exports.discoverObjectFields = discoverObjectFields;
        exports.getFieldsDataType = getFieldsDataType;
        exports.setDefaultFieldValueFormatting = setDefaultFieldValueFormatting;
        exports.getFiltersByPath = getFiltersByPath;
        exports.capitalizeFirstLetter = capitalizeFirstLetter;
        exports.storeDrillDownMixin = exports.foreachTreeAsync = exports.foreachTree = exports.setFieldProperty = void 0;
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 80));
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _date = _interopRequireDefault(__webpack_require__( /*! ../../localization/date */ 32));
        var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../format_helper */ 72));
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 69);
        var _array_store = _interopRequireDefault(__webpack_require__( /*! ../../data/array_store */ 77));
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var setFieldProperty = function(field, property, value, isInitialization) {
            var initProperties = field._initProperties = field._initProperties || {};
            var initValue = isInitialization ? value : field[property];
            if (!Object.prototype.hasOwnProperty.call(initProperties, property) || isInitialization) {
                initProperties[property] = initValue
            }
            field[property] = value
        };
        exports.setFieldProperty = setFieldProperty;

        function sendRequest(options) {
            return _ajax.default.sendRequest(options)
        }
        var foreachTreeAsyncDate = new Date;

        function createForeachTreeFunc(isAsync) {
            var foreachTreeFunc = function foreachTreeFunc(items, callback, parentAtFirst, members, index, isChildrenProcessing) {
                members = members || [];
                items = items || [];
                var i;
                var deferred;
                index = index || 0;

                function createForeachTreeAsyncHandler(deferred, i, isChildrenProcessing) {
                    (0, _deferred.when)(foreachTreeFunc(items, callback, parentAtFirst, members, i, isChildrenProcessing)).done(deferred.resolve)
                }
                for (i = index; i < items.length; i++) {
                    if (isAsync && i > index && i % 1e4 === 0 && new Date - foreachTreeAsyncDate >= 300) {
                        foreachTreeAsyncDate = new Date;
                        deferred = new _deferred.Deferred;
                        setTimeout(createForeachTreeAsyncHandler(deferred, i, false), 0);
                        return deferred
                    }
                    var item = items[i];
                    if (!isChildrenProcessing) {
                        members.unshift(item);
                        if (parentAtFirst && false === callback(members, i)) {
                            return
                        }
                        if (item.children) {
                            var childrenDeferred = foreachTreeFunc(item.children, callback, parentAtFirst, members);
                            if (isAsync && childrenDeferred) {
                                deferred = new _deferred.Deferred;
                                childrenDeferred.done(createForeachTreeAsyncHandler(deferred, i, true));
                                return deferred
                            }
                        }
                    }
                    isChildrenProcessing = false;
                    if (!parentAtFirst && false === callback(members, i)) {
                        return
                    }
                    members.shift();
                    if (items[i] !== item) {
                        i--
                    }
                }
            };
            return foreachTreeFunc
        }
        var foreachTree = createForeachTreeFunc(false);
        exports.foreachTree = foreachTree;
        var foreachTreeAsync = createForeachTreeFunc(true);
        exports.foreachTreeAsync = foreachTreeAsync;

        function findField(fields, id) {
            if (fields && (0, _type.isDefined)(id)) {
                for (var i = 0; i < fields.length; i++) {
                    var field = fields[i];
                    if (field.name === id || field.caption === id || field.dataField === id || field.index === id) {
                        return i
                    }
                }
            }
            return -1
        }

        function formatValue(value, options) {
            var valueText = value === value && _format_helper.default.format(value, options.format);
            var formatObject = {
                value: value,
                valueText: valueText || ""
            };
            return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
        }

        function getCompareFunction(valueSelector) {
            return function(a, b) {
                var result = 0;
                var valueA = valueSelector(a);
                var valueB = valueSelector(b);
                var aIsDefined = (0, _type.isDefined)(valueA);
                var bIsDefined = (0, _type.isDefined)(valueB);
                if (aIsDefined && bIsDefined) {
                    if (valueA > valueB) {
                        result = 1
                    } else {
                        if (valueA < valueB) {
                            result = -1
                        }
                    }
                }
                if (aIsDefined && !bIsDefined) {
                    result = 1
                }
                if (!aIsDefined && bIsDefined) {
                    result = -1
                }
                return result
            }
        }

        function createPath(items) {
            var result = [];
            for (var i = items.length - 1; i >= 0; i--) {
                result.push(items[i].key || items[i].value)
            }
            return result
        }

        function foreachDataLevel(data, callback, index, childrenField) {
            index = index || 0;
            childrenField = childrenField || "children";
            if (data.length) {
                callback(data, index)
            }
            for (var i = 0; i < data.length; i++) {
                var item = data[i];
                if (item[childrenField] && item[childrenField].length) {
                    foreachDataLevel(item[childrenField], callback, index + 1, childrenField)
                }
            }
        }

        function mergeArraysByMaxValue(values1, values2) {
            var result = [];
            for (var i = 0; i < values1.length; i++) {
                result.push(Math.max(values1[i] || 0, values2[i] || 0))
            }
            return result
        }

        function getExpandedLevel(options, axisName) {
            var dimensions = options[axisName];
            var expandLevel = 0;
            var expandedPaths = ("columns" === axisName ? options.columnExpandedPaths : options.rowExpandedPaths) || [];
            if (options.headerName === axisName) {
                expandLevel = options.path.length
            } else {
                if (options.headerName && options.headerName !== axisName && options.oppositePath) {
                    expandLevel = options.oppositePath.length
                } else {
                    (0, _iterator.each)(expandedPaths, function(_, path) {
                        expandLevel = Math.max(expandLevel, path.length)
                    })
                }
            }
            while (dimensions[expandLevel + 1] && dimensions[expandLevel].expanded) {
                expandLevel++
            }
            return expandLevel
        }

        function createGroupFields(item) {
            return (0, _iterator.map)(["year", "quarter", "month"], function(value, index) {
                return (0, _extend.extend)({}, item, {
                    groupInterval: value,
                    groupIndex: index
                })
            })
        }

        function parseFields(dataSource, fieldsList, path, fieldsDataType) {
            var result = [];
            Object.keys(fieldsList || []).forEach(function(field) {
                if (field && 0 === field.indexOf("__")) {
                    return
                }
                var dataIndex = 1;
                var currentPath = path.length ? path + "." + field : field;
                var dataType = fieldsDataType[currentPath];
                var getter = (0, _data.compileGetter)(currentPath);
                var value = fieldsList[field];
                var items;
                while (!(0, _type.isDefined)(value) && dataSource[dataIndex]) {
                    value = getter(dataSource[dataIndex]);
                    dataIndex++
                }
                if (!dataType && (0, _type.isDefined)(value)) {
                    dataType = (0, _type.type)(value)
                }
                items = [{
                    dataField: currentPath,
                    dataType: dataType,
                    groupName: "date" === dataType ? field : void 0,
                    groupInterval: void 0,
                    displayFolder: path
                }];
                if ("date" === dataType) {
                    items = items.concat(createGroupFields(items[0]))
                } else {
                    if ("object" === dataType) {
                        items = parseFields(dataSource, value, currentPath, fieldsDataType)
                    }
                }
                result.push.apply(result, items)
            });
            return result
        }

        function discoverObjectFields(items, fields) {
            var fieldsDataType = getFieldsDataType(fields);
            return parseFields(items, items[0], "", fieldsDataType)
        }

        function getFieldsDataType(fields) {
            var result = {};
            (0, _iterator.each)(fields, function(_, field) {
                result[field.dataField] = result[field.dataField] || field.dataType
            });
            return result
        }
        var DATE_INTERVAL_FORMATS = {
            month: function(value) {
                return _date.default.getMonthNames()[value - 1]
            },
            quarter: function(value) {
                return _date.default.format(new Date(2e3, 3 * value - 1), "quarter")
            },
            dayOfWeek: function(value) {
                return _date.default.getDayNames()[value]
            }
        };

        function setDefaultFieldValueFormatting(field) {
            if ("date" === field.dataType) {
                if (!field.format) {
                    setFieldProperty(field, "format", DATE_INTERVAL_FORMATS[field.groupInterval])
                }
            } else {
                if ("number" === field.dataType) {
                    var groupInterval = (0, _type.isNumeric)(field.groupInterval) && field.groupInterval > 0 && field.groupInterval;
                    if (groupInterval && !field.customizeText) {
                        setFieldProperty(field, "customizeText", function(formatObject) {
                            var secondValue = formatObject.value + groupInterval;
                            var secondValueText = _format_helper.default.format(secondValue, field.format);
                            return formatObject.valueText && secondValueText ? formatObject.valueText + " - " + secondValueText : ""
                        })
                    }
                }
            }
        }

        function getFiltersByPath(fields, path) {
            var result = [];
            path = path || [];
            for (var i = 0; i < path.length; i++) {
                result.push((0, _extend.extend)({}, fields[i], {
                    groupIndex: null,
                    groupName: null,
                    filterType: "include",
                    filterValues: [path[i]]
                }))
            }
            return result
        }
        var storeDrillDownMixin = {
            createDrillDownDataSource: function(descriptions, params) {
                var items = this.getDrillDownItems(descriptions, params);
                var arrayStore;

                function createCustomStoreMethod(methodName) {
                    return function(options) {
                        var d;
                        if (arrayStore) {
                            d = arrayStore[methodName](options)
                        } else {
                            d = new _deferred.Deferred;
                            (0, _deferred.when)(items).done(function(data) {
                                var arrayStore = new _array_store.default(data);
                                arrayStore[methodName](options).done(d.resolve).fail(d.reject)
                            }).fail(d.reject)
                        }
                        return d
                    }
                }
                var dataSource = new _data_source.DataSource({
                    load: createCustomStoreMethod("load"),
                    totalCount: createCustomStoreMethod("totalCount"),
                    key: this.key()
                });
                return dataSource
            }
        };
        exports.storeDrillDownMixin = storeDrillDownMixin;

        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1)
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/core.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _parent_locales = _interopRequireDefault(__webpack_require__( /*! ./cldr-data/parent_locales */ 493));
        var _parentLocale = _interopRequireDefault(__webpack_require__( /*! ./parentLocale */ 494));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_LOCALE = "en";
        var _default = (0, _dependency_injector.default)({
            locale: function() {
                var currentLocale = DEFAULT_LOCALE;
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }(),
            getValueByClosestLocale: function(getter) {
                var locale = this.locale();
                var value = getter(locale);
                var isRootLocale;
                while (!value && !isRootLocale) {
                    locale = (0, _parentLocale.default)(_parent_locales.default, locale);
                    if (locale) {
                        value = getter(locale)
                    } else {
                        isRootLocale = true
                    }
                }
                if (void 0 === value && locale !== DEFAULT_LOCALE) {
                    return getter(DEFAULT_LOCALE)
                }
                return value
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************************!*\
      !*** ./artifacts/transpiled-npm/exporter/excel/excel.tag_helper.js ***!
      \*********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var tagHelper = {
            toXml: function(tagName, attributes, content) {
                var result = ["<", tagName];
                for (var attributeName in attributes) {
                    var attributeValue = attributes[attributeName];
                    if ((0, _type.isDefined)(attributeValue)) {
                        result.push(" ", attributeName, '="', attributeValue, '"')
                    }
                }
                if ((0, _type.isDefined)(content) && "" !== content) {
                    result.push(">", content, "</", tagName, ">")
                } else {
                    result.push(" />")
                }
                return result.join("")
            }
        };
        var _default = tagHelper;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/integration/jquery/use_jquery.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = _default;
        var _jquery = _interopRequireDefault(__webpack_require__( /*! jquery */ 60));
        var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var useJQuery = (0, _config.default)().useJQuery;
        if (_jquery.default && false !== useJQuery) {
            (0, _config.default)({
                useJQuery: true
            })
        }

        function _default() {
            return _jquery.default && (0, _config.default)().useJQuery
        }
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/empty_template.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.EmptyTemplate = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _template_base = __webpack_require__( /*! ./template_base */ 75);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var EmptyTemplate = function(_TemplateBase) {
            _inherits(EmptyTemplate, _TemplateBase);
            var _super = _createSuper(EmptyTemplate);

            function EmptyTemplate() {
                _classCallCheck(this, EmptyTemplate);
                return _super.apply(this, arguments)
            }
            _createClass(EmptyTemplate, [{
                key: "_renderCore",
                value: function() {
                    return (0, _renderer.default)()
                }
            }]);
            return EmptyTemplate
        }(_template_base.TemplateBase);
        exports.EmptyTemplate = EmptyTemplate
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/data_helper.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _data_source = __webpack_require__( /*! ./data/data_source/data_source */ 69);
        var _extend = __webpack_require__( /*! ./core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ./data/data_source/utils */ 70);
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions";
        var DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler";
        var DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler";
        var DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler";
        var DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode";
        var SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var NORMALIZE_DATA_SOURCE = "_normalizeDataSource";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                var widgetDataSourceOptions;
                var dataSourceType;
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof _data_source.DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : _data_source.DataSource;
                        dataSourceOptions = (0, _utils.normalizeDataSourceOptions)(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType((0, _extend.extend)(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    if (NORMALIZE_DATA_SOURCE in this) {
                        this._dataSource = this[NORMALIZE_DATA_SOURCE](this._dataSource)
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function(e) {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items(), e)
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        var _default = DataHelperMixin;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/array_utils.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.applyBatch = applyBatch;
        exports.createObjectWithChanges = createObjectWithChanges;
        exports.update = update;
        exports.insert = insert;
        exports.remove = remove;
        exports.indexByKey = indexByKey;
        exports.applyChanges = applyChanges;
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 31));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../core/guid */ 36));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _object = __webpack_require__( /*! ../core/utils/object */ 50);
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function hasKey(target, keyOrKeys) {
            var key;
            var keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
            while (keys.length) {
                key = keys.shift();
                if (key in target) {
                    return true
                }
            }
            return false
        }

        function findItems(keyInfo, items, key, groupCount) {
            var childItems;
            var result;
            if (groupCount) {
                for (var i = 0; i < items.length; i++) {
                    childItems = items[i].items || items[i].collapsedItems || [];
                    result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                    if (result) {
                        return result
                    }
                }
            } else {
                if (indexByKey(keyInfo, items, key) >= 0) {
                    return items
                }
            }
        }

        function getItems(keyInfo, items, key, groupCount) {
            if (groupCount) {
                return findItems(keyInfo, items, key, groupCount) || []
            }
            return items
        }

        function generateDataByKeyMap(keyInfo, array) {
            if (keyInfo.key() && (!array._dataByKeyMap || array._dataByKeyMapLength !== array.length)) {
                var dataByKeyMap = {};
                var arrayLength = array.length;
                for (var i = 0; i < arrayLength; i++) {
                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                }
                array._dataByKeyMap = dataByKeyMap;
                array._dataByKeyMapLength = arrayLength
            }
        }

        function getCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
        }

        function getHasKeyCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
            return true
        }

        function setDataByKeyMapValue(array, key, data) {
            if (array._dataByKeyMap) {
                array._dataByKeyMap[JSON.stringify(key)] = data
            }
        }

        function createObjectWithChanges(target, changes) {
            var result = target ? Object.create(Object.getPrototypeOf(target)) : {};
            var targetWithoutPrototype = (0, _extend.extendFromObject)({}, target);
            (0, _object.deepExtendArraySafe)(result, targetWithoutPrototype, true, true);
            return (0, _object.deepExtendArraySafe)(result, changes, true, true)
        }

        function applyBatch(_ref) {
            var keyInfo = _ref.keyInfo,
                data = _ref.data,
                changes = _ref.changes,
                groupCount = _ref.groupCount,
                useInsertIndex = _ref.useInsertIndex,
                immutable = _ref.immutable,
                disableCache = _ref.disableCache,
                logError = _ref.logError;
            var resultItems = true === immutable ? _toConsumableArray(data) : data;
            changes.forEach(function(item) {
                var items = "insert" === item.type ? resultItems : getItems(keyInfo, resultItems, item.key, groupCount);
                !disableCache && generateDataByKeyMap(keyInfo, items);
                switch (item.type) {
                    case "update":
                        update(keyInfo, items, item.key, item.data, true, immutable, logError);
                        break;
                    case "insert":
                        insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true, logError);
                        break;
                    case "remove":
                        remove(keyInfo, items, item.key, true, logError)
                }
            });
            return resultItems
        }

        function getErrorResult(isBatch, logError, errorCode) {
            return !isBatch ? _utils.default.rejectedPromise(_errors.default.errors.Error(errorCode)) : logError && _errors.default.errors.log(errorCode)
        }

        function applyChanges(data, changes) {
            var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
            var _options$keyExpr = options.keyExpr,
                keyExpr = void 0 === _options$keyExpr ? "id" : _options$keyExpr,
                _options$immutable = options.immutable,
                immutable = void 0 === _options$immutable ? true : _options$immutable;
            var keyGetter = (0, _data.compileGetter)(keyExpr);
            var keyInfo = {
                key: function() {
                    return keyExpr
                },
                keyOf: function(obj) {
                    return keyGetter(obj)
                }
            };
            return applyBatch({
                keyInfo: keyInfo,
                data: data,
                changes: changes,
                immutable: immutable,
                disableCache: true,
                logError: true
            })
        }

        function update(keyInfo, array, key, data, isBatch, immutable, logError) {
            var target;
            var extendComplexObject = true;
            var keyExpr = keyInfo.key();
            if (keyExpr) {
                if (hasKey(data, keyExpr) && !_utils.default.keysEqual(keyExpr, key, keyInfo.keyOf(data))) {
                    return getErrorResult(isBatch, logError, "E4017")
                }
                target = getCacheValue(array, key);
                if (!target) {
                    var index = indexByKey(keyInfo, array, key);
                    if (index < 0) {
                        return getErrorResult(isBatch, logError, "E4009")
                    }
                    target = array[index];
                    if (true === immutable && (0, _type.isDefined)(target)) {
                        var newTarget = createObjectWithChanges(target, data);
                        array[index] = newTarget;
                        return !isBatch && _utils.default.trivialPromise(newTarget, key)
                    }
                }
            } else {
                target = key
            }(0, _object.deepExtendArraySafe)(target, data, extendComplexObject);
            if (!isBatch) {
                if ((0, _config.default)().useLegacyStoreResult) {
                    return _utils.default.trivialPromise(key, data)
                } else {
                    return _utils.default.trivialPromise(target, key)
                }
            }
        }

        function insert(keyInfo, array, data, index, isBatch, logError) {
            var keyValue;
            var keyExpr = keyInfo.key();
            var obj = (0, _type.isPlainObject)(data) ? (0, _extend.extend)({}, data) : data;
            if (keyExpr) {
                keyValue = keyInfo.keyOf(obj);
                if (void 0 === keyValue || "object" === _typeof(keyValue) && (0, _type.isEmptyObject)(keyValue)) {
                    if (Array.isArray(keyExpr)) {
                        throw _errors.default.errors.Error("E4007")
                    }
                    keyValue = obj[keyExpr] = String(new _guid.default)
                } else {
                    if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                        return getErrorResult(isBatch, logError, "E4008")
                    }
                }
            } else {
                keyValue = obj
            }
            if (index >= 0) {
                array.splice(index, 0, obj)
            } else {
                array.push(obj)
            }
            setDataByKeyMapValue(array, keyValue, obj);
            if (!isBatch) {
                return _utils.default.trivialPromise((0, _config.default)().useLegacyStoreResult ? data : obj, keyValue)
            }
        }

        function remove(keyInfo, array, key, isBatch, logError) {
            var index = indexByKey(keyInfo, array, key);
            if (index > -1) {
                array.splice(index, 1)
            }
            if (!isBatch) {
                return _utils.default.trivialPromise(key)
            } else {
                if (index < 0) {
                    return getErrorResult(isBatch, logError, "E4009")
                }
            }
        }

        function indexByKey(keyInfo, array, key) {
            var keyExpr = keyInfo.key();
            if (!getHasKeyCacheValue(array, key)) {
                return -1
            }
            for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                if (_utils.default.keysEqual(keyExpr, keyInfo.keyOf(array[i]), key)) {
                    return i
                }
            }
            return -1
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/store_helper.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 167));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return (0, _extend.extend)({}, g, {
                        items: multiLevelGroup((0, _array_query.default)(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            (0, _iterator.each)(groupInfo, function(_, group) {
                var collision = (0, _common.grep)(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter;
            if (filter) {
                query = query.filter(filter)
            }
            if (isCountQuery) {
                return query
            }
            var sort = options.sort;
            var select = options.select;
            var group = options.group;
            var skip = options.skip;
            var take = options.take;
            if (group) {
                group = _utils.default.normalizeSortingInfo(group);
                group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
            }
            if (sort || group) {
                sort = _utils.default.normalizeSortingInfo(sort || []);
                if (group && !group.keepInitialKeyOrder) {
                    sort = arrangeSortingInfo(group, sort)
                }(0, _iterator.each)(sort, function(index) {
                    query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                })
            }
            if (select) {
                query = query.select(select)
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (take || skip) {
                query = query.slice(skip || 0, take)
            }
            return query
        }
        var _default = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled-npm/color.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var v = parseInt(colorString[3], 10);
                var rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var l = parseInt(colorString[3], 10);
                var rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];
        var _round = Math.round;

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var i = 0;
            var ii = standardColorTypes.length;
            var str;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var delta = max - min;
            var H;
            var S;
            var V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var index = Math.floor(h % 360 / 60);
            var vMin = (100 - s) * v / 100;
            var a = (v - vMin) * (h % 60 / 60);
            var vInc = vMin + a;
            var vDec = v - a;
            var r;
            var g;
            var b;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var maxMinSum = max + min;
            var h;
            var s;
            var l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r;
            var g;
            var b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s;
                var p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor);
                var result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color;
                var rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        var _default = Color;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/validation_engine.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 15));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 98);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = _interopRequireDefault(__webpack_require__( /*! ../localization/number */ 47));
        var _message = _interopRequireDefault(__webpack_require__( /*! ../localization/message */ 10));
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../core/polyfills/promise */ 73));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var STATUS = {
            valid: "valid",
            invalid: "invalid",
            pending: "pending"
        };
        var BaseRuleValidator = function() {
            function BaseRuleValidator() {
                _classCallCheck(this, BaseRuleValidator);
                this.NAME = "base"
            }
            _createClass(BaseRuleValidator, [{
                key: "defaultMessage",
                value: function(value) {
                    return _message.default.getFormatter("validation-".concat(this.NAME))(value)
                }
            }, {
                key: "defaultFormattedMessage",
                value: function(value) {
                    return _message.default.getFormatter("validation-".concat(this.NAME, "-formatted"))(value)
                }
            }, {
                key: "_isValueEmpty",
                value: function(value) {
                    return !rulesValidators.required.validate(value, {})
                }
            }, {
                key: "validate",
                value: function(value, rule) {
                    var _this = this;
                    var valueArray = Array.isArray(value) ? value : [value];
                    var result = true;
                    if (valueArray.length) {
                        valueArray.every(function(itemValue) {
                            result = _this._validate(itemValue, rule);
                            return result
                        })
                    } else {
                        result = this._validate(null, rule)
                    }
                    return result
                }
            }]);
            return BaseRuleValidator
        }();
        var RequiredRuleValidator = function(_BaseRuleValidator) {
            _inherits(RequiredRuleValidator, _BaseRuleValidator);
            var _super = _createSuper(RequiredRuleValidator);

            function RequiredRuleValidator() {
                var _this2;
                _classCallCheck(this, RequiredRuleValidator);
                _this2 = _super.call(this);
                _this2.NAME = "required";
                return _this2
            }
            _createClass(RequiredRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!(0, _type.isDefined)(value)) {
                        return false
                    }
                    if (false === value) {
                        return false
                    }
                    value = String(value);
                    if (rule.trim || !(0, _type.isDefined)(rule.trim)) {
                        value = value.trim()
                    }
                    return "" !== value
                }
            }]);
            return RequiredRuleValidator
        }(BaseRuleValidator);
        var NumericRuleValidator = function(_BaseRuleValidator2) {
            _inherits(NumericRuleValidator, _BaseRuleValidator2);
            var _super2 = _createSuper(NumericRuleValidator);

            function NumericRuleValidator() {
                var _this3;
                _classCallCheck(this, NumericRuleValidator);
                _this3 = _super2.call(this);
                _this3.NAME = "numeric";
                return _this3
            }
            _createClass(NumericRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    if (rule.useCultureSettings && (0, _type.isString)(value)) {
                        return !isNaN(_number.default.parse(value))
                    } else {
                        return (0, _type.isNumeric)(value)
                    }
                }
            }]);
            return NumericRuleValidator
        }(BaseRuleValidator);
        var RangeRuleValidator = function(_BaseRuleValidator3) {
            _inherits(RangeRuleValidator, _BaseRuleValidator3);
            var _super3 = _createSuper(RangeRuleValidator);

            function RangeRuleValidator() {
                var _this4;
                _classCallCheck(this, RangeRuleValidator);
                _this4 = _super3.call(this);
                _this4.NAME = "range";
                return _this4
            }
            _createClass(RangeRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validNumber = rulesValidators.numeric.validate(value, rule);
                    var validValue = (0, _type.isDefined)(value) && "" !== value;
                    var number = validNumber ? parseFloat(value) : validValue && value.valueOf();
                    var min = rule.min;
                    var max = rule.max;
                    if (!(validNumber || (0, _type.isDate)(value)) && !validValue) {
                        return false
                    }
                    if ((0, _type.isDefined)(min)) {
                        if ((0, _type.isDefined)(max)) {
                            return number >= min && number <= max
                        }
                        return number >= min
                    } else {
                        if ((0, _type.isDefined)(max)) {
                            return number <= max
                        } else {
                            throw _errors.default.Error("E0101")
                        }
                    }
                }
            }]);
            return RangeRuleValidator
        }(BaseRuleValidator);
        var StringLengthRuleValidator = function(_BaseRuleValidator4) {
            _inherits(StringLengthRuleValidator, _BaseRuleValidator4);
            var _super4 = _createSuper(StringLengthRuleValidator);

            function StringLengthRuleValidator() {
                var _this5;
                _classCallCheck(this, StringLengthRuleValidator);
                _this5 = _super4.call(this);
                _this5.NAME = "stringLength";
                return _this5
            }
            _createClass(StringLengthRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    value = (0, _type.isDefined)(value) ? String(value) : "";
                    if (rule.trim || !(0, _type.isDefined)(rule.trim)) {
                        value = value.trim()
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.range.validate(value.length, (0, _extend.extend)({}, rule))
                }
            }]);
            return StringLengthRuleValidator
        }(BaseRuleValidator);
        var CustomRuleValidator = function(_BaseRuleValidator5) {
            _inherits(CustomRuleValidator, _BaseRuleValidator5);
            var _super5 = _createSuper(CustomRuleValidator);

            function CustomRuleValidator() {
                var _this6;
                _classCallCheck(this, CustomRuleValidator);
                _this6 = _super5.call(this);
                _this6.NAME = "custom";
                return _this6
            }
            _createClass(CustomRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && (0, _type.isFunction)(validator.option) && validator.option("dataGetter");
                    var extraParams = (0, _type.isFunction)(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    return rule.validationCallback(params)
                }
            }]);
            return CustomRuleValidator
        }(BaseRuleValidator);
        var AsyncRuleValidator = function(_CustomRuleValidator) {
            _inherits(AsyncRuleValidator, _CustomRuleValidator);
            var _super6 = _createSuper(AsyncRuleValidator);

            function AsyncRuleValidator() {
                var _this7;
                _classCallCheck(this, AsyncRuleValidator);
                _this7 = _super6.call(this);
                _this7.NAME = "async";
                return _this7
            }
            _createClass(AsyncRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (!(0, _type.isDefined)(rule.reevaluate)) {
                        (0, _extend.extend)(rule, {
                            reevaluate: true
                        })
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && (0, _type.isFunction)(validator.option) && validator.option("dataGetter");
                    var extraParams = (0, _type.isFunction)(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    var callbackResult = rule.validationCallback(params);
                    if (!(0, _type.isPromise)(callbackResult)) {
                        throw _errors.default.Error("E0103")
                    }
                    return this._getWrappedPromise((0, _deferred.fromPromise)(callbackResult).promise())
                }
            }, {
                key: "_getWrappedPromise",
                value: function(promise) {
                    var deferred = new _deferred.Deferred;
                    promise.then(function(res) {
                        deferred.resolve(res)
                    }, function(err) {
                        var res = {
                            isValid: false
                        };
                        if ((0, _type.isDefined)(err)) {
                            if ((0, _type.isString)(err)) {
                                res.message = err
                            } else {
                                if ((0, _type.isObject)(err) && (0, _type.isDefined)(err.message) && (0, _type.isString)(err.message)) {
                                    res.message = err.message
                                }
                            }
                        }
                        deferred.resolve(res)
                    });
                    return deferred.promise()
                }
            }]);
            return AsyncRuleValidator
        }(CustomRuleValidator);
        var CompareRuleValidator = function(_BaseRuleValidator6) {
            _inherits(CompareRuleValidator, _BaseRuleValidator6);
            var _super7 = _createSuper(CompareRuleValidator);

            function CompareRuleValidator() {
                var _this8;
                _classCallCheck(this, CompareRuleValidator);
                _this8 = _super7.call(this);
                _this8.NAME = "compare";
                return _this8
            }
            _createClass(CompareRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!rule.comparisonTarget) {
                        throw _errors.default.Error("E0102")
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }(0, _extend.extend)(rule, {
                        reevaluate: true
                    });
                    var otherValue = rule.comparisonTarget();
                    var type = rule.comparisonType || "==";
                    switch (type) {
                        case "==":
                            return value == otherValue;
                        case "!=":
                            return value != otherValue;
                        case "===":
                            return value === otherValue;
                        case "!==":
                            return value !== otherValue;
                        case ">":
                            return value > otherValue;
                        case ">=":
                            return value >= otherValue;
                        case "<":
                            return value < otherValue;
                        case "<=":
                            return value <= otherValue
                    }
                }
            }]);
            return CompareRuleValidator
        }(BaseRuleValidator);
        var PatternRuleValidator = function(_BaseRuleValidator7) {
            _inherits(PatternRuleValidator, _BaseRuleValidator7);
            var _super8 = _createSuper(PatternRuleValidator);

            function PatternRuleValidator() {
                var _this9;
                _classCallCheck(this, PatternRuleValidator);
                _this9 = _super8.call(this);
                _this9.NAME = "pattern";
                return _this9
            }
            _createClass(PatternRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var pattern = rule.pattern;
                    if ((0, _type.isString)(pattern)) {
                        pattern = new RegExp(pattern)
                    }
                    return pattern.test(value)
                }
            }]);
            return PatternRuleValidator
        }(BaseRuleValidator);
        var EmailRuleValidator = function(_BaseRuleValidator8) {
            _inherits(EmailRuleValidator, _BaseRuleValidator8);
            var _super9 = _createSuper(EmailRuleValidator);

            function EmailRuleValidator() {
                var _this10;
                _classCallCheck(this, EmailRuleValidator);
                _this10 = _super9.call(this);
                _this10.NAME = "email";
                return _this10
            }
            _createClass(EmailRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.pattern.validate(value, (0, _extend.extend)({}, rule, {
                        pattern: /^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i
                    }))
                }
            }]);
            return EmailRuleValidator
        }(BaseRuleValidator);
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            async: new AsyncRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = _class.default.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = [];
                this._pendingValidators = [];
                this._onValidatorStatusChanged = this._onValidatorStatusChanged.bind(this);
                this._resetValidationInfo();
                this._eventsStrategy = new _events_strategy.EventsStrategy(this)
            },
            validate: function() {
                var _this11 = this;
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: [],
                    status: STATUS.valid,
                    complete: null
                };
                this._unsubscribeFromAllChangeEvents();
                this._pendingValidators = [];
                this._resetValidationInfo();
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRules) {
                        result.brokenRules = result.brokenRules.concat(validatorResult.brokenRules)
                    }
                    result.validators.push(validator);
                    if (validatorResult.status === STATUS.pending) {
                        _this11._addPendingValidator(validator)
                    }
                    _this11._subscribeToChangeEvents(validator)
                });
                if (this._pendingValidators.length) {
                    result.status = STATUS.pending
                } else {
                    result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                    this._unsubscribeFromAllChangeEvents();
                    this._raiseValidatedEvent(result)
                }
                this._updateValidationInfo(result);
                return (0, _extend.extend)({}, this._validationInfo.result)
            },
            _subscribeToChangeEvents: function(validator) {
                validator.on("validating", this._onValidatorStatusChanged);
                validator.on("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromChangeEvents: function(validator) {
                validator.off("validating", this._onValidatorStatusChanged);
                validator.off("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromAllChangeEvents: function() {
                var _this12 = this;
                (0, _iterator.each)(this.validators, function(_, validator) {
                    _this12._unsubscribeFromChangeEvents(validator)
                })
            },
            _updateValidationInfo: function(result) {
                this._validationInfo.result = result;
                if (result.status !== STATUS.pending) {
                    return
                }
                if (!this._validationInfo.deferred) {
                    this._validationInfo.deferred = new _deferred.Deferred;
                    this._validationInfo.result.complete = this._validationInfo.deferred.promise()
                }
            },
            _addPendingValidator: function(validator) {
                var foundValidator = (0, _common.grep)(this._pendingValidators, function(val) {
                    return val === validator
                })[0];
                if (!foundValidator) {
                    this._pendingValidators.push(validator)
                }
            },
            _removePendingValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this._pendingValidators);
                if (index >= 0) {
                    this._pendingValidators.splice(index, 1)
                }
            },
            _orderBrokenRules: function(brokenRules) {
                var orderedRules = [];
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var foundRules = (0, _common.grep)(brokenRules, function(rule) {
                        return rule.validator === validator
                    });
                    if (foundRules.length) {
                        orderedRules = orderedRules.concat(foundRules)
                    }
                });
                return orderedRules
            },
            _updateBrokenRules: function(result) {
                if (!this._validationInfo.result) {
                    return
                }
                var brokenRules = this._validationInfo.result.brokenRules;
                var rules = (0, _common.grep)(brokenRules, function(rule) {
                    return rule.validator !== result.validator
                });
                if (result.brokenRules) {
                    brokenRules = rules.concat(result.brokenRules)
                }
                this._validationInfo.result.brokenRules = this._orderBrokenRules(brokenRules)
            },
            _onValidatorStatusChanged: function(result) {
                if (result.status === STATUS.pending) {
                    this._addPendingValidator(result.validator);
                    return
                }
                this._resolveIfComplete(result)
            },
            _resolveIfComplete: function(result) {
                this._removePendingValidator(result.validator);
                this._updateBrokenRules(result);
                if (!this._pendingValidators.length) {
                    this._unsubscribeFromAllChangeEvents();
                    if (!this._validationInfo.result) {
                        return
                    }
                    this._validationInfo.result.status = 0 === this._validationInfo.result.brokenRules.length ? STATUS.valid : STATUS.invalid;
                    this._validationInfo.result.isValid = this._validationInfo.result.status === STATUS.valid;
                    var res = (0, _extend.extend)({}, this._validationInfo.result, {
                        complete: null
                    });
                    var deferred = this._validationInfo.deferred;
                    this._resetValidationInfo();
                    this._raiseValidatedEvent(res);
                    deferred && setTimeout(function() {
                        deferred.resolve(res)
                    })
                }
            },
            _raiseValidatedEvent: function(result) {
                this._eventsStrategy.fireEvent("validated", [result])
            },
            _resetValidationInfo: function() {
                this._validationInfo = {
                    result: null,
                    deferred: null
                }
            },
            _synchronizeValidationInfo: function() {
                if (this._validationInfo.result) {
                    this._validationInfo.result.validators = this.validators
                }
            },
            removeRegisteredValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this.validators);
                if (index > -1) {
                    this.validators.splice(index, 1);
                    this._synchronizeValidationInfo();
                    this._resolveIfComplete({
                        validator: validator
                    })
                }
            },
            registerValidator: function(validator) {
                if ((0, _array.inArray)(validator, this.validators) < 0) {
                    this.validators.push(validator);
                    this._synchronizeValidationInfo()
                }
            },
            reset: function() {
                (0, _iterator.each)(this.validators, function(_, validator) {
                    validator.reset()
                });
                this._pendingValidators = [];
                this._resetValidationInfo()
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = (0, _common.grep)(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            findGroup: function($element, model) {
                var $dxGroup = $element.parents(".dx-validationgroup").first();
                if ($dxGroup.length) {
                    return $dxGroup.dxValidationGroup("instance")
                }
                return model
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group);
                var index = (0, _array.inArray)(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(info) {
                var rule = info.rule,
                    validator = info.validator,
                    name = info.name;
                if (!(0, _type.isDefined)(rule.message)) {
                    if (validator.defaultFormattedMessage && (0, _type.isDefined)(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            _addBrokenRule: function(info) {
                var result = info.result,
                    rule = info.rule;
                if (!result.brokenRule) {
                    result.brokenRule = rule
                }
                if (!result.brokenRules) {
                    result.brokenRules = []
                }
                result.brokenRules.push(rule)
            },
            validate: function(value, rules, name) {
                var _this13 = this;
                var result = {
                    name: name,
                    value: value,
                    brokenRule: null,
                    brokenRules: null,
                    isValid: true,
                    validationRules: rules,
                    pendingRules: null,
                    status: STATUS.valid,
                    complete: null
                };
                var asyncRuleItems = [];
                (0, _iterator.each)(rules || [], function(_, rule) {
                    var ruleValidator = rulesValidators[rule.type];
                    var ruleValidationResult;
                    if (ruleValidator) {
                        if ((0, _type.isDefined)(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                _this13._addBrokenRule({
                                    result: result,
                                    rule: rule
                                });
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        if ("async" === rule.type) {
                            asyncRuleItems.push({
                                rule: rule,
                                ruleValidator: ruleValidator
                            });
                            return true
                        }
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            _this13._setDefaultMessage({
                                rule: rule,
                                validator: ruleValidator,
                                name: name
                            });
                            _this13._addBrokenRule({
                                result: result,
                                rule: rule
                            })
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw _errors.default.Error("E0100")
                    }
                });
                if (result.isValid && !result.brokenRules && asyncRuleItems.length) {
                    result = this._validateAsyncRules({
                        value: value,
                        items: asyncRuleItems,
                        result: result,
                        name: name
                    })
                }
                result.status = result.pendingRules ? STATUS.pending : result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            _validateAsyncRules: function(_ref) {
                var _this14 = this;
                var result = _ref.result,
                    value = _ref.value,
                    items = _ref.items,
                    name = _ref.name;
                var asyncResults = [];
                (0, _iterator.each)(items, function(_, item) {
                    var validateResult = item.ruleValidator.validate(value, item.rule);
                    if (!(0, _type.isPromise)(validateResult)) {
                        _this14._updateRuleConfig({
                            rule: item.rule,
                            ruleResult: _this14._getPatchedRuleResult(validateResult),
                            validator: item.ruleValidator,
                            name: name
                        })
                    } else {
                        if (!result.pendingRules) {
                            result.pendingRules = []
                        }
                        result.pendingRules.push(item.rule);
                        var asyncResult = validateResult.then(function(res) {
                            var ruleResult = _this14._getPatchedRuleResult(res);
                            _this14._updateRuleConfig({
                                rule: item.rule,
                                ruleResult: ruleResult,
                                validator: item.ruleValidator,
                                name: name
                            });
                            return ruleResult
                        });
                        asyncResults.push(asyncResult)
                    }
                });
                if (asyncResults.length) {
                    result.complete = _promise.default.all(asyncResults).then(function(values) {
                        return _this14._getAsyncRulesResult({
                            result: result,
                            values: values
                        })
                    })
                }
                return result
            },
            _updateRuleConfig: function(_ref2) {
                var rule = _ref2.rule,
                    ruleResult = _ref2.ruleResult,
                    validator = _ref2.validator,
                    name = _ref2.name;
                rule.isValid = ruleResult.isValid;
                if (!ruleResult.isValid) {
                    if ((0, _type.isDefined)(ruleResult.message) && (0, _type.isString)(ruleResult.message) && ruleResult.message.length) {
                        rule.message = ruleResult.message
                    } else {
                        this._setDefaultMessage({
                            rule: rule,
                            validator: validator,
                            name: name
                        })
                    }
                }
            },
            _getPatchedRuleResult: function(ruleResult) {
                var result;
                var isValid = true;
                if ((0, _type.isObject)(ruleResult)) {
                    result = (0, _extend.extend)({}, ruleResult);
                    if (!(0, _type.isDefined)(result.isValid)) {
                        result.isValid = isValid
                    }
                } else {
                    result = {
                        isValid: (0, _type.isBoolean)(ruleResult) ? ruleResult : isValid
                    }
                }
                return result
            },
            _getAsyncRulesResult: function(_ref3) {
                var _this15 = this;
                var values = _ref3.values,
                    result = _ref3.result;
                (0, _iterator.each)(values, function(index, val) {
                    if (false === val.isValid) {
                        result.isValid = val.isValid;
                        var rule = result.pendingRules[index];
                        _this15._addBrokenRule({
                            result: result,
                            rule: rule
                        })
                    }
                });
                result.pendingRules = null;
                result.complete = null;
                result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                groupConfig.registerValidator.call(groupConfig, validator)
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group;
                var isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group);
                if (config) {
                    config.removeRegisteredValidator.call(config, validator);
                    var validatorsInGroup = config.validators;
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            initValidationOptions: function(options) {
                var _this16 = this;
                var initedOptions = {};
                if (options) {
                    var syncOptions = ["isValid", "validationStatus", "validationError", "validationErrors"];
                    syncOptions.forEach(function(prop) {
                        if (prop in options) {
                            (0, _extend.extend)(initedOptions, _this16.synchronizeValidationOptions({
                                name: prop,
                                value: options[prop]
                            }, options))
                        }
                    })
                }
                return initedOptions
            },
            synchronizeValidationOptions: function(_ref4, options) {
                var name = _ref4.name,
                    value = _ref4.value;
                switch (name) {
                    case "validationStatus":
                        var isValid = value === STATUS.valid || value === STATUS.pending;
                        return options.isValid !== isValid ? {
                            isValid: isValid
                        } : {};
                    case "isValid":
                        var validationStatus = options.validationStatus;
                        var newStatus = validationStatus;
                        if (value && validationStatus === STATUS.invalid) {
                            newStatus = STATUS.valid
                        } else {
                            if (!value && validationStatus !== STATUS.invalid) {
                                newStatus = STATUS.invalid
                            }
                        }
                        return newStatus !== validationStatus ? {
                            validationStatus: newStatus
                        } : {};
                    case "validationErrors":
                        var validationError = !value || !value.length ? null : value[0];
                        return options.validationError !== validationError ? {
                            validationError: validationError
                        } : {};
                    case "validationError":
                        var validationErrors = options.validationErrors;
                        if (!value && validationErrors) {
                            return {
                                validationErrors: null
                            }
                        } else {
                            if (value && !validationErrors) {
                                return {
                                    validationErrors: [value]
                                }
                            } else {
                                if (value && validationErrors && value !== validationErrors[0]) {
                                    validationErrors[0] = value;
                                    return {
                                        validationErrors: validationErrors.slice()
                                    }
                                }
                            }
                        }
                }
                return {}
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors.default.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors.default.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        var _default = ValidationEngine;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/text_box.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _text_box = _interopRequireDefault(__webpack_require__( /*! ./text_box/text_box */ 579));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _text_box.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/diagram/diagram.importer.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        exports.getDiagram = getDiagram;
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.errors */ 17));
        var Diagram = _interopRequireWildcard(__webpack_require__( /*! devexpress-diagram */ 871));

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function getDiagram() {
            if (!Diagram.default) {
                throw _ui.default.Error("E1041", "devexpress-diagram")
            }
            return Diagram
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/style.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.setHeight = exports.setWidth = exports.normalizeStyleProp = exports.stylePropPrefix = exports.styleProp = void 0;
        var _inflector = __webpack_require__( /*! ./inflector */ 39);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"];
        var cssPrefixes = {
            "": "",
            Webkit: "-webkit-",
            Moz: "-moz-",
            O: "-o-",
            ms: "-ms-"
        };
        var getStyles = (0, _call_once.default)(function() {
            return _dom_adapter.default.createElement("dx").style
        });
        var forEachPrefixes = function(prop, callBack) {
            prop = (0, _inflector.camelize)(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = (0, _inflector.camelize)(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        exports.styleProp = styleProp;
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        exports.stylePropPrefix = stylePropPrefix;
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if ((0, _type.isNumeric)(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        exports.normalizeStyleProp = normalizeStyleProp;
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = (0, _type.isNumeric)(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        exports.setWidth = setWidth;
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.setHeight = setHeight
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/events_strategy.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.EventsStrategy = void 0;
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _type = __webpack_require__( /*! ./utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var EventsStrategy = function() {
            function EventsStrategy(owner) {
                _classCallCheck(this, EventsStrategy);
                this._events = {};
                this._owner = owner
            }
            _createClass(EventsStrategy, [{
                key: "hasEvent",
                value: function(eventName) {
                    var callbacks = this._events[eventName];
                    return callbacks ? callbacks.has() : false
                }
            }, {
                key: "fireEvent",
                value: function(eventName, eventArgs) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        callbacks.fireWith(this._owner, eventArgs)
                    }
                    return this._owner
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    var _this = this;
                    if ((0, _type.isPlainObject)(eventName)) {
                        (0, _iterator.each)(eventName, function(e, h) {
                            _this.on(e, h)
                        })
                    } else {
                        var callbacks = this._events[eventName];
                        if (!callbacks) {
                            callbacks = (0, _callbacks.default)();
                            this._events[eventName] = callbacks
                        }
                        var addFn = callbacks.originalAdd || callbacks.add;
                        addFn.call(callbacks, eventHandler)
                    }
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        if ((0, _type.isFunction)(eventHandler)) {
                            callbacks.remove(eventHandler)
                        } else {
                            callbacks.empty()
                        }
                    }
                }
            }, {
                key: "dispose",
                value: function() {
                    (0, _iterator.each)(this._events, function(eventName, event) {
                        event.empty()
                    })
                }
            }], [{
                key: "create",
                value: function(owner, strategy) {
                    if (strategy) {
                        return (0, _type.isFunction)(strategy) ? strategy(owner) : strategy
                    } else {
                        return new EventsStrategy(owner)
                    }
                }
            }]);
            return EventsStrategy
        }();
        exports.EventsStrategy = EventsStrategy
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/scheduler/utils.timeZone.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _date = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date */ 19));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./timezones/utils.timezones_data */ 324));
        var _dateAdapter = _interopRequireDefault(__webpack_require__( /*! ./dateAdapter */ 325));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _slicedToArray(arr, i) {
            return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest()
        }

        function _nonIterableRest() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function _iterableToArrayLimit(arr, i) {
            if ("undefined" === typeof Symbol || !(Symbol.iterator in Object(arr))) {
                return
            }
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) {
                        break
                    }
                }
            } catch (err) {
                _d = true;
                _e = err
            } finally {
                try {
                    if (!_n && null != _i.return) {
                        _i.return()
                    }
                } finally {
                    if (_d) {
                        throw _e
                    }
                }
            }
            return _arr
        }

        function _arrayWithHoles(arr) {
            if (Array.isArray(arr)) {
                return arr
            }
        }
        var toMs = _date.default.dateToMilliseconds;
        var MINUTES_IN_HOUR = 60;
        var createUTCDateWithLocalOffset = function(date) {
            if (!date) {
                return null
            }
            return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()))
        };
        var createDateFromUTCWithLocalOffset = function(date) {
            var result = (0, _dateAdapter.default)(date);
            var timezoneOffsetBeforeInMin = result.getTimezoneOffset();
            result.addTime(result.getTimezoneOffset("minute"));
            result.subtractMinutes(timezoneOffsetBeforeInMin - result.getTimezoneOffset());
            return result.source
        };
        var getTimeZones = function() {
            var date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
            var dateInUTC = createUTCDate(date);
            return _utils.default.getDisplayedTimeZones(dateInUTC.getTime())
        };
        var createUTCDate = function(date) {
            return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes()))
        };
        var getTimezoneOffsetChangeInMinutes = function(startDate, endDate, updatedStartDate, updatedEndDate) {
            return getDaylightOffset(updatedStartDate, updatedEndDate) - getDaylightOffset(startDate, endDate)
        };
        var getTimezoneOffsetChangeInMs = function(startDate, endDate, updatedStartDate, updatedEndDate) {
            return getTimezoneOffsetChangeInMinutes(startDate, endDate, updatedStartDate, updatedEndDate) * toMs("minute")
        };
        var getDaylightOffset = function(startDate, endDate) {
            return new Date(startDate).getTimezoneOffset() - new Date(endDate).getTimezoneOffset()
        };
        var getDaylightOffsetInMs = function(startDate, endDate) {
            return getDaylightOffset(startDate, endDate) * toMs("minute")
        };
        var calculateTimezoneByValue = function(timezone) {
            var date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
            if ("string" === typeof timezone) {
                var dateUtc = createUTCDate(date);
                return _utils.default.getTimeZoneOffsetById(timezone, dateUtc.getTime())
            }
            return timezone
        };
        var _getDaylightOffsetByTimezone = function(startDate, endDate, timeZone) {
            return calculateTimezoneByValue(timeZone, startDate) - calculateTimezoneByValue(timeZone, endDate)
        };
        var getCorrectedDateByDaylightOffsets = function(convertedOriginalStartDate, convertedDate, date, timeZone, startDateTimezone) {
            var daylightOffsetByCommonTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, timeZone);
            var daylightOffsetByAppointmentTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, startDateTimezone);
            var diff = daylightOffsetByCommonTimezone - daylightOffsetByAppointmentTimezone;
            return new Date(date.getTime() - diff * toMs("hour"))
        };
        var correctRecurrenceExceptionByTimezone = function(exception, exceptionByStartDate, timeZone, startDateTimeZone) {
            var isBackConversion = arguments.length > 4 && void 0 !== arguments[4] ? arguments[4] : false;
            var timezoneOffset = (exception.getTimezoneOffset() - exceptionByStartDate.getTimezoneOffset()) / MINUTES_IN_HOUR;
            if (startDateTimeZone) {
                timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, startDateTimeZone)
            } else {
                if (timeZone) {
                    timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, timeZone)
                }
            }
            return new Date(exception.getTime() + (isBackConversion ? -1 : 1) * timezoneOffset * toMs("hour"))
        };
        var isTimezoneChangeInDate = function(date) {
            var startDayDate = new Date(new Date(date).setHours(0, 0, 0, 0));
            var endDayDate = new Date(new Date(date).setHours(23, 59, 59, 0));
            return startDayDate.getTimezoneOffset() - endDayDate.getTimezoneOffset() !== 0
        };
        var isSameAppointmentDates = function(startDate, endDate) {
            endDate = new Date(endDate.getTime() - 1);
            return _date.default.sameDate(startDate, endDate)
        };
        var getClientTimezoneOffset = function(date) {
            return 6e4 * date.getTimezoneOffset()
        };
        var isEqualLocalTimeZone = function(timeZoneName) {
            if (Intl) {
                var localTimeZoneName = Intl.DateTimeFormat().resolvedOptions().timeZone;
                if (localTimeZoneName) {
                    return localTimeZoneName === timeZoneName
                }
            }
            return isEqualLocalTimeZoneByNativeDate(timeZoneName)
        };
        var hasDSTInLocalTimeZone = function() {
            var _getExtremeDates = getExtremeDates(),
                _getExtremeDates2 = _slicedToArray(_getExtremeDates, 2),
                startDate = _getExtremeDates2[0],
                endDate = _getExtremeDates2[1];
            return startDate.getTimezoneOffset() !== endDate.getTimezoneOffset()
        };
        var isEqualLocalTimeZoneByNativeDate = function(timeZoneName) {
            var _getExtremeDates3 = getExtremeDates(),
                _getExtremeDates4 = _slicedToArray(_getExtremeDates3, 2),
                startDate = _getExtremeDates4[0],
                endDate = _getExtremeDates4[1];
            var startDateLocalOffset = -startDate.getTimezoneOffset() / 60;
            var endDateLocalOffset = -endDate.getTimezoneOffset() / 60;
            var startDateOffset = calculateTimezoneByValue(timeZoneName, startDate);
            var endDateOffset = calculateTimezoneByValue(timeZoneName, endDate);
            if (startDateLocalOffset === startDateOffset && endDateLocalOffset === endDateOffset) {
                return true
            }
            return false
        };
        var getExtremeDates = function() {
            var nowDate = new Date(Date.now());
            var startDate = new Date;
            var endDate = new Date;
            startDate.setFullYear(nowDate.getFullYear(), 0, 1);
            endDate.setFullYear(nowDate.getFullYear(), 6, 1);
            return [startDate, endDate]
        };
        var utils = {
            getDaylightOffset: getDaylightOffset,
            getDaylightOffsetInMs: getDaylightOffsetInMs,
            getTimezoneOffsetChangeInMinutes: getTimezoneOffsetChangeInMinutes,
            getTimezoneOffsetChangeInMs: getTimezoneOffsetChangeInMs,
            calculateTimezoneByValue: calculateTimezoneByValue,
            getCorrectedDateByDaylightOffsets: getCorrectedDateByDaylightOffsets,
            isTimezoneChangeInDate: isTimezoneChangeInDate,
            isSameAppointmentDates: isSameAppointmentDates,
            correctRecurrenceExceptionByTimezone: correctRecurrenceExceptionByTimezone,
            getClientTimezoneOffset: getClientTimezoneOffset,
            createUTCDateWithLocalOffset: createUTCDateWithLocalOffset,
            createDateFromUTCWithLocalOffset: createDateFromUTCWithLocalOffset,
            createUTCDate: createUTCDate,
            hasDSTInLocalTimeZone: hasDSTInLocalTimeZone,
            isEqualLocalTimeZone: isEqualLocalTimeZone,
            getTimeZones: getTimeZones
        };
        var _default = utils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/odata/utils.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.escapeServiceOperationParams = exports.formatFunctionInvocationUrl = exports.generateExpand = exports.generateSelect = exports.convertPrimitiveValue = exports.keyConverters = exports.serializeKey = exports.serializeValue = exports.serializePropName = exports.EdmLiteral = exports.sendRequest = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 80));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 36));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 38));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));
        var _string = __webpack_require__( /*! ../../core/utils/string */ 43);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
        var makeArray = function(value) {
            return "string" === (0, _type.type)(value) ? value.split() : value
        };
        var hasDot = function(x) {
            return /\./.test(x)
        };
        var pad = function(text, length, right) {
            text = String(text);
            while (text.length < length) {
                text = right ? "".concat(text, "0") : "0".concat(text)
            }
            return text
        };
        var formatISO8601 = function(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            var padLeft2 = function(text) {
                return pad(text, 2)
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(padLeft2(date.getMonth() + 1));
            bag.push("-");
            bag.push(padLeft2(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(padLeft2(date.getHours()));
                bag.push(":");
                bag.push(padLeft2(date.getMinutes()));
                bag.push(":");
                bag.push(padLeft2(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(pad(date.getMilliseconds(), 3))
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        };
        var parseISO8601 = function(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3);
            var chunks = isoString.replace("Z", "").split("T");
            var date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]);
            var time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                var fractional = (time[4] || "").slice(0, 3);
                fractional = pad(fractional, 3, true);
                result.setMilliseconds(Number(fractional))
            }
            return result
        };
        var isAbsoluteUrl = function(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        };
        var stripParams = function(url) {
            var index = url.indexOf("?");
            if (index > -1) {
                return url.substr(0, index)
            }
            return url
        };
        var toAbsoluteUrl = function(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        };
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request) {
            var _options$beforeSend;
            var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
            var formatPayload = function(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw _errors.default.errors.Error("E4002")
                    }
                })
            };
            request = (0, _extend.extend)({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            null === (_options$beforeSend = options.beforeSend) || void 0 === _options$beforeSend ? void 0 : _options$beforeSend.call(options, request);
            var _request = request,
                async = _request.async, timeout = _request.timeout, headers = _request.headers;
            var _request2 = request,
                url = _request2.url,
                method = _request2.method;
            var jsonp = options.jsonp,
                withCredentials = options.withCredentials;
            method = (method || "get").toLowerCase();
            var isGet = "get" === method;
            var useJsonp = isGet && jsonp;
            var params = (0, _extend.extend)({}, request.params);
            var ajaxData = isGet ? params : formatPayload(request.payload);
            var qs = !isGet && param(params);
            var contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: async,
                timeout: timeout,
                headers: headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: withCredentials
                }
            }
        };
        var sendRequest = function sendRequest(protocolVersion, request, options) {
            var deserializeDates = options.deserializeDates,
                fieldTypes = options.fieldTypes,
                countOnly = options.countOnly,
                isPaged = options.isPaged;
            var d = new _deferred.Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            _ajax.default.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var transformOptions = {
                    deserializeDates: deserializeDates,
                    fieldTypes: fieldTypes
                };
                var tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions);
                var error = tuple.error,
                    data = tuple.data,
                    count = tuple.count;
                var nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== _utils.default.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (countOnly) {
                        if (isFinite(count)) {
                            d.resolve(count)
                        } else {
                            d.reject(new _errors.default.errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                return d.resolve(data.concat(nextData))
                            })
                        } else {
                            var extra = isFinite(count) ? {
                                totalCount: count
                            } : void 0;
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        exports.sendRequest = sendRequest;
        var formatDotNetError = function(errorObj) {
            var message;
            var currentError = errorObj;
            if ("message" in errorObj) {
                var _errorObj$message;
                message = (null === (_errorObj$message = errorObj.message) || void 0 === _errorObj$message ? void 0 : _errorObj$message.value) || errorObj.message
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus, ajaxOptions) {
            var _response, _response2, _response3, _response4;
            if ("nocontent" === textStatus) {
                return null
            }
            var message = "Unknown error";
            var response = obj;
            var httpStatus = 200;
            var errorData = {
                requestOptions: ajaxOptions
            };
            if ("success" !== textStatus) {
                var status = obj.status,
                    responseText = obj.responseText;
                httpStatus = status;
                message = _utils.default.errorMessageFromXhr(obj, textStatus);
                try {
                    response = JSON.parse(responseText)
                } catch (x) {}
            }
            var errorObj = (null === (_response = response) || void 0 === _response ? void 0 : _response.then) || (null === (_response2 = response) || void 0 === _response2 ? void 0 : _response2.error) || (null === (_response3 = response) || void 0 === _response3 ? void 0 : _response3["odata.error"]) || (null === (_response4 = response) || void 0 === _response4 ? void 0 : _response4["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                errorData.errorDetails = errorObj;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                var customCode = Number(errorObj.code);
                if (isFinite(customCode) && customCode >= 400) {
                    httpStatus = customCode
                }
            }
            if (httpStatus >= 400 || 0 === httpStatus) {
                errorData.httpStatus = httpStatus;
                return (0, _extend.extend)(Error(message), errorData)
            }
            return null
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
            var error = errorFromResponse(obj, textStatus, ajaxOptions);
            if (error) {
                return {
                    error: error
                }
            }
            if (!(0, _type.isPlainObject)(obj)) {
                return {
                    data: obj
                }
            }
            var value = "d" in obj && (Array.isArray(obj.d) || (0, _type.isObject)(obj.d)) ? interpretVerboseJsonFormat(obj, textStatus) : interpretLightJsonFormat(obj, textStatus);
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(_ref) {
            var _data$results;
            var data = _ref.d;
            if (!(0, _type.isDefined)(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            return {
                data: null !== (_data$results = data.results) && void 0 !== _data$results ? _data$results : data,
                nextUrl: data.__next,
                count: parseInt(data.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var _obj$value;
            return {
                data: null !== (_obj$value = obj.value) && void 0 !== _obj$value ? _obj$value : obj,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = _class.default.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        exports.EdmLiteral = EdmLiteral;
        var transformTypes = function transformTypes(obj) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            (0, _iterator.each)(obj, function(key, value) {
                if (null !== value && "object" === _typeof(value)) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            deserializeDates = options.deserializeDates;
                        var canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _guid.default(value)
                        }
                        if (false !== deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'".concat(formatISO8601(date, true, true), "'")
        };
        var serializeString = function(value) {
            return "'".concat(value.replace(/'/g, "''"), "'")
        };
        var serializePropName = function(propName) {
            return propName instanceof EdmLiteral ? propName.valueOf() : propName.replace(/\./g, "/")
        };
        exports.serializePropName = serializePropName;
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _guid.default) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[".concat(value.map(function(item) {
                    return serializeValueV4(item)
                }).join(","), "]")
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _guid.default) {
                return "guid'".concat(value, "'")
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw _errors.default.errors.Error("E4002")
            }
        };
        exports.serializeValue = serializeValue;
        var serializeKey = function(key, protocolVersion) {
            if ((0, _type.isPlainObject)(key)) {
                var parts = [];
                (0, _iterator.each)(key, function(k, v) {
                    return parts.push("".concat(serializePropName(k), "=").concat(serializeValue(v, protocolVersion)))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        exports.serializeKey = serializeKey;
        var keyConverters = {
            String: function(value) {
                return "".concat(value)
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral("".concat(value, "L"))
            },
            Guid: function(value) {
                return value instanceof _guid.default ? value : new _guid.default(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "m")
            }
        };
        exports.keyConverters = keyConverters;
        var convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw _errors.default.errors.Error("E4014", type)
            }
            return converter(value)
        };
        exports.convertPrimitiveValue = convertPrimitiveValue;
        var generateSelect = function(oDataVersion, select) {
            if (!select) {
                return
            }
            return oDataVersion < 4 ? serializePropName(select.join()) : (0, _common.grep)(select, hasDot, true).join()
        };
        exports.generateSelect = generateSelect;
        var formatCore = function formatCore(hash) {
            var result = "";
            var selectValue = [];
            var expandValue = [];
            (0, _iterator.each)(hash, function(key, value) {
                if (Array.isArray(value)) {
                    [].push.apply(selectValue, value)
                }
                if ((0, _type.isPlainObject)(value)) {
                    expandValue.push("".concat(key).concat(formatCore(value)))
                }
            });
            if (selectValue.length || expandValue.length) {
                result += "(";
                if (selectValue.length) {
                    result += "$select=".concat((0, _iterator.map)(selectValue, serializePropName).join())
                }
                if (expandValue.length) {
                    if (selectValue.length) {
                        result += ";"
                    }
                    result += "$expand=".concat((0, _iterator.map)(expandValue, serializePropName).join())
                }
                result += ")"
            }
            return result
        };
        var format = function(hash) {
            var result = [];
            (0, _iterator.each)(hash, function(key, value) {
                return result.push("".concat(key).concat(formatCore(value)))
            });
            return result.join()
        };
        var parseCore = function parseCore(exprParts, root, stepper) {
            var result = stepper(root, exprParts.shift(), exprParts);
            if (false === result) {
                return
            }
            parseCore(exprParts, result, stepper)
        };
        var parseTree = function(exprs, root, stepper) {
            return (0, _iterator.each)(exprs, function(_, x) {
                return parseCore(x.split("."), root, stepper)
            })
        };
        var generatorV2 = function(expand, select) {
            var hash = {};
            if (expand) {
                (0, _iterator.each)(makeArray(expand), function() {
                    hash[serializePropName(this)] = 1
                })
            }
            if (select) {
                (0, _iterator.each)(makeArray(select), function() {
                    var path = this.split(".");
                    if (path.length < 2) {
                        return
                    }
                    path.pop();
                    hash[serializePropName(path.join("."))] = 1
                })
            }
            return (0, _iterator.map)(hash, function(_, v) {
                return v
            }).join()
        };
        var generatorV4 = function(expand, select) {
            var hash = {};
            if (expand || select) {
                if (expand) {
                    parseTree(makeArray(expand), hash, function(node, key, path) {
                        node[key] = node[key] || {};
                        return !path.length ? false : node[key]
                    })
                }
                if (select) {
                    parseTree((0, _common.grep)(makeArray(select), hasDot), hash, function(node, key, path) {
                        if (!path.length) {
                            node[key] = node[key] || [];
                            node[key].push(key);
                            return false
                        }
                        return node[key] = node[key] || {}
                    })
                }
                return format(hash)
            }
        };
        var generateExpand = function(oDataVersion, expand, select) {
            return oDataVersion < 4 ? generatorV2(expand, select) : generatorV4(expand, select)
        };
        exports.generateExpand = generateExpand;
        var formatFunctionInvocationUrl = function(baseUrl, args) {
            return (0, _string.format)("{0}({1})", baseUrl, (0, _iterator.map)(args || {}, function(value, key) {
                return (0, _string.format)("{0}={1}", key, value)
            }).join(","))
        };
        exports.formatFunctionInvocationUrl = formatFunctionInvocationUrl;
        var escapeServiceOperationParams = function(params, version) {
            if (!params) {
                return params
            }
            var result = {};
            (0, _iterator.each)(params, function(k, v) {
                result[k] = serializeValue(v, version)
            });
            return result
        };
        exports.escapeServiceOperationParams = escapeServiceOperationParams
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/variable_wrapper.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _console = __webpack_require__( /*! ./console */ 109);
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _dependency_injector.default)({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                _console.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/emitter_registrator.js ***!
      \*********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 49));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 40);
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./event_registrator */ 74));
        var _index = __webpack_require__( /*! ../utils/index */ 8);
        var _pointer = _interopRequireDefault(__webpack_require__( /*! ../pointer */ 24));
        var _wheel = __webpack_require__( /*! ./wheel */ 146);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var MANAGER_EVENT = "dxEventManager";
        var EMITTER_DATA = "dxEmitter";
        var EventManager = _class.default.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                _ready_callbacks.default.add(function() {
                    var document = _dom_adapter.default.getDocument();
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)([_pointer.default.up, _pointer.default.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_wheel.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if ((0, _index.isMouseEvent)(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                (0, _iterator.each)(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this;
                var result = [];
                var $element = (0, _renderer.default)(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = (0, _element_data.data)($element.get(0), EMITTER_DATA) || [];
                    (0, _iterator.each)(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = (0, _array.inArray)(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e);
                var verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction;
                var prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter;
            var emitterName = emitterConfig.events[0];
            var emitterEvents = emitterConfig.events;
            (0, _iterator.each)(emitterEvents, function(_, eventName) {
                (0, _event_registrator.default)(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA) || {};
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA) || {};
                        var emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        (0, _element_data.data)(element, EMITTER_DATA, emitters);
                        (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        emitter.configure((0, _extend.extend)({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA);
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        (0, _iterator.each)(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        var _default = registerEmitter;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/events/hold.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 132));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold";
        var HOLD_TIMEOUT = 750;
        var TOUCH_BOUNDARY = 5;
        var HoldEmitter = _emitter.default.inherit({
            start: function(e) {
                this._startEventData = (0, _index.eventData)(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        (0, _emitter_registrator.default)({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        var _default = {
            name: HOLD_EVENT_NAME
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/data/abstract_store.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 15));
        var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 98);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _store_helper = _interopRequireDefault(__webpack_require__( /*! ./store_helper */ 92));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _class.default.abstract;
        var queryByOptions = _store_helper.default.queryByOptions;
        var storeImpl = {};
        var Store = _class.default.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = (0, _data.compileGetter)(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw _errors.default.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that._eventsStrategy.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new _deferred.Deferred;
                task.done(function() {
                    var that = this;
                    var args = arguments;
                    _utils.default.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function() {
                    that._eventsStrategy.fireEvent("updated", [key, values]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            push: function(changes) {
                this._pushImpl(changes);
                this._eventsStrategy.fireEvent("push", [changes])
            },
            _pushImpl: _common.noop,
            remove: function(key) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that._eventsStrategy.fireEvent("removed", [callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(_errors.default._errorHandler)
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw _errors.default.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.registerClass = function(type, alias) {
            if (alias) {
                storeImpl[alias] = type
            }
            return type
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                Store.registerClass(type, alias);
                return type
            }
        }(Store.inherit);
        var _default = Store;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/scroll_view/ui.scrollable.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _support = __webpack_require__( /*! ../../core/utils/support */ 45);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/browser */ 22));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _element = __webpack_require__( /*! ../../core/element */ 18);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 14));
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 9));
        var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_component */ 68));
        var _selectors = __webpack_require__( /*! ../widget/selectors */ 71);
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _uiEventsEmitterGesture = _interopRequireDefault(__webpack_require__( /*! ./ui.events.emitter.gesture.scroll */ 273));
        var _uiScrollable = __webpack_require__( /*! ./ui.scrollable.simulated */ 347);
        var _uiScrollable2 = _interopRequireDefault(__webpack_require__( /*! ./ui.scrollable.native */ 272));
        var _uiScrollable3 = __webpack_require__( /*! ./ui.scrollable.device */ 349);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var SCROLLABLE = "dxScrollable";
        var SCROLLABLE_STRATEGY = "dxScrollableStrategy";
        var SCROLLABLE_CLASS = "dx-scrollable";
        var SCROLLABLE_DISABLED_CLASS = "dx-scrollable-disabled";
        var SCROLLABLE_CONTAINER_CLASS = "dx-scrollable-container";
        var SCROLLABLE_WRAPPER_CLASS = "dx-scrollable-wrapper";
        var SCROLLABLE_CONTENT_CLASS = "dx-scrollable-content";
        var VERTICAL = "vertical";
        var HORIZONTAL = "horizontal";
        var BOTH = "both";
        var Scrollable = _dom_component.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    disabled: false,
                    onScroll: null,
                    direction: VERTICAL,
                    showScrollbar: "onScroll",
                    useNative: true,
                    bounceEnabled: true,
                    scrollByContent: true,
                    scrollByThumb: false,
                    onUpdated: null,
                    onStart: null,
                    onEnd: null,
                    onBounce: null,
                    onStop: null,
                    useSimulatedScrollbar: false,
                    useKeyboard: true,
                    inertiaEnabled: true,
                    pushBackValue: 0,
                    updateManually: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat((0, _uiScrollable3.deviceDependentOptions)(), [{
                    device: function() {
                        return _support.nativeScrolling && "android" === _devices.default.real().platform && !_browser.default.mozilla
                    },
                    options: {
                        useSimulatedScrollbar: true
                    }
                }, {
                    device: function() {
                        return "ios" === _devices.default.real().platform
                    },
                    options: {
                        pushBackValue: 1
                    }
                }])
            },
            _initOptions: function(options) {
                this.callBase(options);
                if (!("useSimulatedScrollbar" in options)) {
                    this._setUseSimulatedScrollbar()
                }
            },
            _setUseSimulatedScrollbar: function() {
                if (!this.initialOption("useSimulatedScrollbar")) {
                    this.option("useSimulatedScrollbar", !this.option("useNative"))
                }
            },
            _init: function() {
                this.callBase();
                this._initScrollableMarkup();
                this._locked = false
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    this.update();
                    this._updateRtlPosition();
                    this._savedScrollOffset && this.scrollTo(this._savedScrollOffset);
                    delete this._savedScrollOffset
                } else {
                    this._savedScrollOffset = this.scrollOffset()
                }
            },
            _initScrollableMarkup: function() {
                var $element = this.$element().addClass(SCROLLABLE_CLASS);
                var $container = this._$container = (0, _renderer.default)("<div>").addClass(SCROLLABLE_CONTAINER_CLASS);
                var $wrapper = this._$wrapper = (0, _renderer.default)("<div>").addClass(SCROLLABLE_WRAPPER_CLASS);
                var $content = this._$content = (0, _renderer.default)("<div>").addClass(SCROLLABLE_CONTENT_CLASS);
                if (_dom_adapter.default.hasDocumentProperty("onbeforeactivate") && _browser.default.msie && _browser.default.version < 12) {
                    _events_engine.default.on($element, (0, _index.addNamespace)("beforeactivate", SCROLLABLE), function(e) {
                        if (!(0, _renderer.default)(e.target).is(_selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
                $content.append($element.contents()).appendTo($container);
                $container.appendTo($wrapper);
                $wrapper.appendTo($element)
            },
            _dimensionChanged: function() {
                this.update()
            },
            _initMarkup: function() {
                this.callBase();
                this._renderDirection()
            },
            _render: function() {
                this._renderStrategy();
                this._attachEventHandlers();
                this._renderDisabledState();
                this._createActions();
                this.update();
                this.callBase();
                this._updateRtlPosition()
            },
            _updateRtlPosition: function() {
                var _this = this;
                this._updateBounds();
                if (this.option("rtlEnabled") && this.option("direction") !== VERTICAL) {
                    (0, _common.deferUpdate)(function() {
                        var containerElement = _this._container().get(0);
                        var maxLeftOffset = containerElement.scrollWidth - containerElement.clientWidth;
                        (0, _common.deferRender)(function() {
                            _this.scrollTo({
                                left: maxLeftOffset
                            })
                        })
                    })
                }
            },
            _updateBounds: function() {
                this._strategy.updateBounds()
            },
            _attachEventHandlers: function() {
                var strategy = this._strategy;
                var initEventData = {
                    getDirection: strategy.getDirection.bind(strategy),
                    validate: this._validate.bind(this),
                    isNative: this.option("useNative"),
                    scrollTarget: this._$container
                };
                _events_engine.default.off(this._$wrapper, "." + SCROLLABLE);
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.init, SCROLLABLE), initEventData, this._initHandler.bind(this));
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.start, SCROLLABLE), strategy.handleStart.bind(strategy));
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.move, SCROLLABLE), strategy.handleMove.bind(strategy));
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.end, SCROLLABLE), strategy.handleEnd.bind(strategy));
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.cancel, SCROLLABLE), strategy.handleCancel.bind(strategy));
                _events_engine.default.on(this._$wrapper, (0, _index.addNamespace)(_uiEventsEmitterGesture.default.stop, SCROLLABLE), strategy.handleStop.bind(strategy));
                _events_engine.default.off(this._$container, "." + SCROLLABLE);
                _events_engine.default.on(this._$container, (0, _index.addNamespace)("scroll", SCROLLABLE), strategy.handleScroll.bind(strategy))
            },
            _validate: function(e) {
                if (this._isLocked()) {
                    return false
                }
                this._updateIfNeed();
                return this._strategy.validate(e)
            },
            _initHandler: function() {
                var strategy = this._strategy;
                strategy.handleInit.apply(strategy, arguments)
            },
            _renderDisabledState: function() {
                this.$element().toggleClass(SCROLLABLE_DISABLED_CLASS, this.option("disabled"));
                if (this.option("disabled")) {
                    this._lock()
                } else {
                    this._unlock()
                }
            },
            _renderDirection: function() {
                this.$element().removeClass("dx-scrollable-" + HORIZONTAL).removeClass("dx-scrollable-" + VERTICAL).removeClass("dx-scrollable-" + BOTH).addClass("dx-scrollable-" + this.option("direction"))
            },
            _renderStrategy: function() {
                this._createStrategy();
                this._strategy.render();
                this.$element().data(SCROLLABLE_STRATEGY, this._strategy)
            },
            _createStrategy: function() {
                this._strategy = this.option("useNative") ? new _uiScrollable2.default(this) : new _uiScrollable.SimulatedStrategy(this)
            },
            _createActions: function() {
                this._strategy && this._strategy.createActions()
            },
            _clean: function() {
                this._strategy && this._strategy.dispose()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onStart":
                    case "onEnd":
                    case "onStop":
                    case "onUpdated":
                    case "onScroll":
                    case "onBounce":
                        this._createActions();
                        break;
                    case "direction":
                        this._resetInactiveDirection();
                        this._invalidate();
                        break;
                    case "useNative":
                        this._setUseSimulatedScrollbar();
                        this._invalidate();
                        break;
                    case "inertiaEnabled":
                    case "scrollByContent":
                    case "scrollByThumb":
                    case "bounceEnabled":
                    case "useKeyboard":
                    case "showScrollbar":
                    case "useSimulatedScrollbar":
                    case "pushBackValue":
                        this._invalidate();
                        break;
                    case "disabled":
                        this._renderDisabledState();
                        this._strategy && this._strategy.disabledChanged();
                        break;
                    case "updateManually":
                        break;
                    case "width":
                        this.callBase(args);
                        this._updateRtlPosition();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _resetInactiveDirection: function() {
                var inactiveProp = this._getInactiveProp();
                if (!inactiveProp || !(0, _window.hasWindow)()) {
                    return
                }
                var scrollOffset = this.scrollOffset();
                scrollOffset[inactiveProp] = 0;
                this.scrollTo(scrollOffset)
            },
            _getInactiveProp: function() {
                var direction = this.option("direction");
                if (direction === VERTICAL) {
                    return "left"
                }
                if (direction === HORIZONTAL) {
                    return "top"
                }
            },
            _location: function() {
                return this._strategy.location()
            },
            _normalizeLocation: function(location) {
                if ((0, _type.isPlainObject)(location)) {
                    var left = (0, _common.ensureDefined)(location.left, location.x);
                    var top = (0, _common.ensureDefined)(location.top, location.y);
                    return {
                        left: (0, _type.isDefined)(left) ? -left : void 0,
                        top: (0, _type.isDefined)(top) ? -top : void 0
                    }
                } else {
                    var direction = this.option("direction");
                    return {
                        left: direction !== VERTICAL ? -location : void 0,
                        top: direction !== HORIZONTAL ? -location : void 0
                    }
                }
            },
            _isLocked: function() {
                return this._locked
            },
            _lock: function() {
                this._locked = true
            },
            _unlock: function() {
                if (!this.option("disabled")) {
                    this._locked = false
                }
            },
            _isDirection: function(direction) {
                var current = this.option("direction");
                if (direction === VERTICAL) {
                    return current !== HORIZONTAL
                }
                if (direction === HORIZONTAL) {
                    return current !== VERTICAL
                }
                return current === direction
            },
            _updateAllowedDirection: function() {
                var allowedDirections = this._strategy._allowedDirections();
                if (this._isDirection(BOTH) && allowedDirections.vertical && allowedDirections.horizontal) {
                    this._allowedDirectionValue = BOTH
                } else {
                    if (this._isDirection(HORIZONTAL) && allowedDirections.horizontal) {
                        this._allowedDirectionValue = HORIZONTAL
                    } else {
                        if (this._isDirection(VERTICAL) && allowedDirections.vertical) {
                            this._allowedDirectionValue = VERTICAL
                        } else {
                            this._allowedDirectionValue = null
                        }
                    }
                }
            },
            _allowedDirection: function() {
                return this._allowedDirectionValue
            },
            _container: function() {
                return this._$container
            },
            $content: function() {
                return this._$content
            },
            content: function() {
                return (0, _element.getPublicElement)(this._$content)
            },
            scrollOffset: function() {
                var location = this._location();
                return {
                    top: -location.top,
                    left: -location.left
                }
            },
            scrollTop: function() {
                return this.scrollOffset().top
            },
            scrollLeft: function() {
                return this.scrollOffset().left
            },
            clientHeight: function() {
                return this._$container.height()
            },
            scrollHeight: function() {
                return this.$content().outerHeight() - 2 * this._strategy.verticalOffset()
            },
            clientWidth: function() {
                return this._$container.width()
            },
            scrollWidth: function() {
                return this.$content().outerWidth()
            },
            update: function() {
                if (!this._strategy) {
                    return
                }
                return (0, _deferred.when)(this._strategy.update()).done(function() {
                    this._updateAllowedDirection()
                }.bind(this))
            },
            scrollBy: function(distance) {
                distance = this._normalizeLocation(distance);
                if (!distance.top && !distance.left) {
                    return
                }
                this._updateIfNeed();
                this._strategy.scrollBy(distance)
            },
            scrollTo: function(targetLocation) {
                targetLocation = this._normalizeLocation(targetLocation);
                this._updateIfNeed();
                var location = this._location();
                if (!this.option("useNative")) {
                    targetLocation = this._strategy._applyScaleRatio(targetLocation);
                    location = this._strategy._applyScaleRatio(location)
                }
                var distance = this._normalizeLocation({
                    left: location.left - (0, _common.ensureDefined)(targetLocation.left, location.left),
                    top: location.top - (0, _common.ensureDefined)(targetLocation.top, location.top)
                });
                if (!distance.top && !distance.left) {
                    return
                }
                this._strategy.scrollBy(distance)
            },
            scrollToElement: function(element, offset) {
                var $element = (0, _renderer.default)(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    scrollPosition.left = this.getScrollElementPosition($element, HORIZONTAL, offset)
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this.getScrollElementPosition($element, VERTICAL, offset)
                }
                this.scrollTo(scrollPosition)
            },
            scrollToElementTopLeft: function(element) {
                var $element = (0, _renderer.default)(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    var leftPosition = this._elementPositionRelativeToContent($element, "left");
                    scrollPosition.left = true === this.option("rtlEnabled") ? leftPosition + $element.width() - this.clientWidth() : leftPosition
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this._elementPositionRelativeToContent($element, "top")
                }
                this.scrollTo(scrollPosition)
            },
            getScrollElementPosition: function($element, direction, offset) {
                offset = offset || {};
                var isVertical = direction === VERTICAL;
                var startOffset = (isVertical ? offset.top : offset.left) || 0;
                var endOffset = (isVertical ? offset.bottom : offset.right) || 0;
                var pushBackOffset = isVertical ? this._strategy.verticalOffset() : 0;
                var elementPositionRelativeToContent = this._elementPositionRelativeToContent($element, isVertical ? "top" : "left");
                var elementPosition = elementPositionRelativeToContent - pushBackOffset;
                var elementSize = $element[isVertical ? "outerHeight" : "outerWidth"]();
                var scrollLocation = isVertical ? this.scrollTop() : this.scrollLeft();
                var clientSize = isVertical ? this.clientHeight() : this.clientWidth();
                var startDistance = scrollLocation - elementPosition + startOffset;
                var endDistance = scrollLocation - elementPosition - elementSize + clientSize - endOffset;
                if (startDistance <= 0 && endDistance >= 0) {
                    return scrollLocation
                }
                return scrollLocation - (Math.abs(startDistance) > Math.abs(endDistance) ? endDistance : startDistance)
            },
            _elementPositionRelativeToContent: function($element, prop) {
                var result = 0;
                while (this._hasScrollContent($element)) {
                    result += $element.position()[prop];
                    $element = $element.offsetParent()
                }
                return result
            },
            _hasScrollContent: function($element) {
                var $content = this.$content();
                return $element.closest($content).length && !$element.is($content)
            },
            _updateIfNeed: function() {
                if (!this.option("updateManually")) {
                    this.update()
                }
            },
            _useTemplates: function() {
                return false
            }
        });
        (0, _component_registrator.default)(SCROLLABLE, Scrollable);
        var _default = Scrollable;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/context_menu.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./context_menu/ui.context_menu */ 374));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _ui.default;
        exports.default = _default;
        module.exports = exports.default
    }, , ,
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/console.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.debug = exports.logger = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !(0, _type.isFunction)(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        exports.logger = logger;
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.debug = debug
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/action.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 2));
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var Action = function() {
            function Action(action, config) {
                _classCallCheck(this, Action);
                config = config || {};
                this._action = action;
                this._context = config.context || (0, _window.getWindow)();
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            }
            _createClass(Action, [{
                key: "execute",
                value: function() {
                    var e = {
                        action: this._action,
                        args: Array.prototype.slice.call(arguments),
                        context: this._context,
                        component: this._component,
                        validatingTargetName: this._validatingTargetName,
                        cancel: false,
                        handled: false
                    };
                    var beforeExecute = this._beforeExecute;
                    var afterExecute = this._afterExecute;
                    var argsBag = e.args[0] || {};
                    if (!this._validateAction(e)) {
                        return
                    }
                    null === beforeExecute || void 0 === beforeExecute ? void 0 : beforeExecute.call(this._context, e);
                    if (e.cancel) {
                        return
                    }
                    var result = this._executeAction(e);
                    if (argsBag.cancel) {
                        return
                    }
                    null === afterExecute || void 0 === afterExecute ? void 0 : afterExecute.call(this._context, e);
                    return result
                }
            }, {
                key: "_validateAction",
                value: function(e) {
                    var excludeValidators = this._excludeValidators;
                    var executors = Action.executors;
                    for (var name in executors) {
                        if (!excludeValidators[name]) {
                            var _executor$validate;
                            var executor = executors[name];
                            null === (_executor$validate = executor.validate) || void 0 === _executor$validate ? void 0 : _executor$validate.call(executor, e);
                            if (e.cancel) {
                                return false
                            }
                        }
                    }
                    return true
                }
            }, {
                key: "_executeAction",
                value: function(e) {
                    var result;
                    var executors = Action.executors;
                    for (var name in executors) {
                        var _executor$execute;
                        var executor = executors[name];
                        null === (_executor$execute = executor.execute) || void 0 === _executor$execute ? void 0 : _executor$execute.call(executor, e);
                        if (e.handled) {
                            result = e.result;
                            break
                        }
                    }
                    return result
                }
            }], [{
                key: "registerExecutor",
                value: function(name, executor) {
                    if ((0, _type.isPlainObject)(name)) {
                        (0, _iterator.each)(name, Action.registerExecutor);
                        return
                    }
                    Action.executors[name] = executor
                }
            }, {
                key: "unregisterExecutor",
                value: function() {
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }(0, _iterator.each)(args, function() {
                        delete Action.executors[this]
                    })
                }
            }]);
            return Action
        }();
        exports.default = Action;
        Action.executors = {};
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0];
                var element = args[e.validatingTargetName] || args.element;
                if (element && condition((0, _renderer.default)(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                })
            },
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if ((0, _type.isFunction)(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        module.exports = exports.default
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled-npm/ui/list.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _uiListEdit = _interopRequireDefault(__webpack_require__( /*! ./list/ui.list.edit.search */ 589));
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 9));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }(0, _component_registrator.default)("dxList", _uiListEdit.default);
        var _default = _uiListEdit.default;
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/currency.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _default = {
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    var result = this.format(value, (0, _extend.extend)({}, formatConfig, {
                        type: "fixedpoint"
                    }));
                    var currencyPart = this.getCurrencySymbol().symbol.replace("$", "$$$$");
                    result = result.replace(/^(\D*)(\d.*)/, "$1" + currencyPart + "$2");
                    return result
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/list/ui.list.edit.decorator_registry.js ***!
      \*****************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.register = register;
        exports.registry = void 0;
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var registry = {};
        exports.registry = registry;

        function register(option, type, decoratorClass) {
            var decoratorsRegistry = registry;
            var decoratorConfig = {};
            decoratorConfig[option] = decoratorsRegistry[option] ? decoratorsRegistry[option] : {};
            decoratorConfig[option][type] = decoratorClass;
            decoratorsRegistry = (0, _extend.extend)(decoratorsRegistry, decoratorConfig)
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/scroll_view.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./scroll_view/ui.scroll_view */ 210));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _ui.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/number_box.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _number_box = _interopRequireDefault(__webpack_require__( /*! ./number_box/number_box */ 610));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _number_box.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/select_box.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _utils = __webpack_require__( /*! ./widget/utils.ink_ripple */ 83);
        var _message = _interopRequireDefault(__webpack_require__( /*! ../localization/message */ 10));
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 9));
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./drop_down_editor/ui.drop_down_list */ 270));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DISABLED_STATE_SELECTOR = ".dx-state-disabled";
        var SELECTBOX_CLASS = "dx-selectbox";
        var SELECTBOX_POPUP_CLASS = "dx-selectbox-popup";
        var SELECTBOX_CONTAINER_CLASS = "dx-selectbox-container";
        var SELECTBOX_POPUP_WRAPPER_CLASS = "dx-selectbox-popup-wrapper";
        var SelectBox = _ui.default.inherit({
            _supportedKeys: function() {
                var that = this;
                var parent = this.callBase();
                var clearSelectBox = function(e) {
                    var isEditable = this._isEditable();
                    if (!isEditable) {
                        if (this.option("showClearButton")) {
                            e.preventDefault();
                            this.reset()
                        }
                    } else {
                        if (this._valueSubstituted()) {
                            this._preventFiltering = true
                        }
                    }
                    this._preventSubstitution = true
                };
                var searchIfNeeded = function() {
                    if (that.option("searchEnabled") && that._valueSubstituted()) {
                        that._searchHandler()
                    }
                };
                return (0, _extend.extend)({}, parent, {
                    tab: function() {
                        if (this.option("opened") && "instantly" === this.option("applyValueMode")) {
                            this._cleanInputSelection()
                        }
                        if (this._wasSearch()) {
                            this._clearFilter()
                        }
                        parent.tab && parent.tab.apply(this, arguments)
                    },
                    upArrow: function(e) {
                        if (parent.upArrow && parent.upArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(e)
                            }
                            return true
                        }
                    },
                    downArrow: function(e) {
                        if (parent.downArrow && parent.downArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(e)
                            }
                            return true
                        }
                    },
                    leftArrow: function() {
                        searchIfNeeded();
                        parent.leftArrow && parent.leftArrow.apply(this, arguments)
                    },
                    rightArrow: function() {
                        searchIfNeeded();
                        parent.rightArrow && parent.rightArrow.apply(this, arguments)
                    },
                    home: function() {
                        searchIfNeeded();
                        parent.home && parent.home.apply(this, arguments)
                    },
                    end: function() {
                        searchIfNeeded();
                        parent.end && parent.end.apply(this, arguments)
                    },
                    escape: function() {
                        var result = parent.escape && parent.escape.apply(this, arguments);
                        this._cancelEditing();
                        return (0, _type.isDefined)(result) ? result : true
                    },
                    enter: function(e) {
                        var isOpened = this.option("opened");
                        var inputText = this._input().val().trim();
                        var isCustomText = inputText && this._list && !this._list.option("focusedElement");
                        if (!inputText && (0, _type.isDefined)(this.option("value")) && this.option("allowClearing")) {
                            this.option({
                                selectedItem: null,
                                value: null
                            });
                            this.close()
                        } else {
                            if (this.option("acceptCustomValue")) {
                                e.preventDefault();
                                if (isCustomText) {
                                    this._valueChangeEventHandler(e);
                                    if (isOpened) {
                                        this._toggleOpenState()
                                    }
                                }
                                return isOpened
                            }
                            if (parent.enter && parent.enter.apply(this, arguments)) {
                                return isOpened
                            }
                        }
                    },
                    space: function(e) {
                        var isOpened = this.option("opened");
                        var isSearchEnabled = this.option("searchEnabled");
                        var acceptCustomValue = this.option("acceptCustomValue");
                        if (!isOpened || isSearchEnabled || acceptCustomValue) {
                            return
                        }
                        e.preventDefault();
                        this._valueChangeEventHandler(e);
                        return true
                    },
                    backspace: clearSelectBox,
                    del: clearSelectBox
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    placeholder: _message.default.format("Select"),
                    fieldTemplate: null,
                    valueChangeEvent: "change",
                    acceptCustomValue: false,
                    onCustomItemCreating: function(e) {
                        if (!(0, _type.isDefined)(e.customItem)) {
                            e.customItem = e.text
                        }
                    },
                    showSelectionControls: false,
                    allowClearing: true,
                    tooltipEnabled: false,
                    openOnFieldClick: true,
                    showDropDownButton: true,
                    displayCustomValue: false,
                    useInkRipple: false,
                    useHiddenSubmitElement: true
                })
            },
            _init: function() {
                this.callBase();
                this._initCustomItemCreatingAction()
            },
            _initMarkup: function() {
                this.$element().addClass(SELECTBOX_CLASS);
                this._renderTooltip();
                this.option("useInkRipple") && this._renderInkRipple();
                this.callBase();
                this._$container.addClass(SELECTBOX_CONTAINER_CLASS)
            },
            _renderInkRipple: function() {
                this._inkRipple = (0, _utils.render)()
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple || this._isEditable()) {
                    return
                }
                var config = {
                    element: this._inputWrapper(),
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _createPopup: function() {
                this.callBase();
                this._popup.$element().addClass(SELECTBOX_POPUP_CLASS);
                this._popup.overlayContent().attr("tabindex", -1)
            },
            _popupWrapperClass: function() {
                return this.callBase() + " " + SELECTBOX_POPUP_WRAPPER_CLASS
            },
            _cancelEditing: function() {
                if (!this.option("searchEnabled") && this._list) {
                    this._focusListElement(null);
                    this._updateField(this.option("selectedItem"))
                }
            },
            _renderOpenedState: function() {
                this.callBase();
                if (this.option("opened")) {
                    this._scrollToSelectedItem();
                    this._focusSelectedElement()
                }
            },
            _focusSelectedElement: function() {
                var searchValue = this._searchValue();
                if (!searchValue) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements();
                var index = (0, _array.inArray)(this.option("selectedItem"), this.option("items"));
                var focusedElement = index >= 0 && !this._isCustomItemSelected() ? $listItems.eq(index) : null;
                this._focusListElement(focusedElement)
            },
            _renderFocusedElement: function() {
                if (!this._list) {
                    return
                }
                var searchValue = this._searchValue();
                if (!searchValue || this.option("acceptCustomValue")) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements();
                var focusedElement = $listItems.not(DISABLED_STATE_SELECTOR).eq(0);
                this._focusListElement(focusedElement)
            },
            _focusListElement: function(element) {
                this._preventInputValueRender = true;
                this._list.option("focusedElement", (0, _element.getPublicElement)(element));
                delete this._preventInputValueRender
            },
            _scrollToSelectedItem: function() {
                this._list && this._list.scrollToItem(this._list.option("selectedItem"))
            },
            _listContentReadyHandler: function() {
                this.callBase();
                var isPaginate = this._dataSource && this._dataSource.paginate();
                if (isPaginate && this._needPopupRepaint()) {
                    return
                }
                this._scrollToSelectedItem()
            },
            _renderValue: function() {
                this._renderInputValue();
                this._setSubmitValue();
                return (new _deferred.Deferred).resolve()
            },
            _renderInputValue: function() {
                return this.callBase().always(function() {
                    this._renderInputValueAsync()
                }.bind(this))
            },
            _renderInputValueAsync: function() {
                this._renderTooltip();
                this._renderInputValueImpl().always(function() {
                    this._refreshSelected()
                }.bind(this))
            },
            _renderInputValueImpl: function() {
                this._renderField();
                return (new _deferred.Deferred).resolve()
            },
            _setNextItem: function(step) {
                var item = this._calcNextItem(step);
                var value = this._valueGetter(item);
                this._setValue(value)
            },
            _setNextValue: function(e) {
                var dataSourceIsLoaded = this._dataSource.isLoaded() ? (new _deferred.Deferred).resolve() : this._dataSource.load();
                dataSourceIsLoaded.done(function() {
                    var selectedIndex = this._getSelectedIndex();
                    var hasPages = this._dataSource.pageSize();
                    var isLastPage = this._dataSource.isLastPage();
                    var isLastItem = selectedIndex === this._items().length - 1;
                    this._saveValueChangeEvent(e);
                    var step = "ArrowDown" === e.key ? 1 : -1;
                    if (hasPages && !isLastPage && isLastItem && step > 0) {
                        if (!this._popup) {
                            this._createPopup()
                        }
                        if (!this._dataSource.isLoading()) {
                            this._list._loadNextPage().done(this._setNextItem.bind(this, step))
                        }
                    } else {
                        this._setNextItem(step)
                    }
                }.bind(this))
            },
            _setSelectedItem: function(item) {
                var isUnknownItem = !this._isCustomValueAllowed() && void 0 === item;
                this.callBase(isUnknownItem ? null : item);
                if (!isUnknownItem && (!this._isEditable() || this._isCustomItemSelected())) {
                    this._setListOption("selectedItem", this.option("selectedItem"))
                }
            },
            _isCustomValueAllowed: function() {
                return this.option("acceptCustomValue") || this.callBase()
            },
            _displayValue: function(item) {
                item = !(0, _type.isDefined)(item) && this._isCustomValueAllowed() ? this.option("value") : item;
                return this.callBase(item)
            },
            _listConfig: function() {
                var result = (0, _extend.extend)(this.callBase(), {
                    pageLoadMode: "scrollBottom",
                    onSelectionChanged: this._getSelectionChangeHandler(),
                    selectedItem: this.option("selectedItem"),
                    onFocusedItemChanged: this._listFocusedItemChangeHandler.bind(this)
                });
                if (this.option("showSelectionControls")) {
                    (0, _extend.extend)(result, {
                        showSelectionControls: true,
                        selectionByClick: true
                    })
                }
                return result
            },
            _listFocusedItemChangeHandler: function(e) {
                if (this._preventInputValueRender) {
                    return
                }
                var list = e.component;
                var focusedElement = (0, _renderer.default)(list.option("focusedElement"));
                var focusedItem = list._getItemData(focusedElement);
                this._updateField(focusedItem)
            },
            _updateField: function(item) {
                var fieldTemplate = this._getTemplateByOption("fieldTemplate");
                if (!(fieldTemplate && this.option("fieldTemplate"))) {
                    var text = this._displayGetter(item);
                    this.option("text", text);
                    this._renderDisplayText(text);
                    return
                }
                this._renderField()
            },
            _getSelectionChangeHandler: function() {
                return this.option("showSelectionControls") ? this._selectionChangeHandler.bind(this) : _common.noop
            },
            _selectionChangeHandler: function(e) {
                (0, _iterator.each)(e.addedItems || [], function(_, addedItem) {
                    this._setValue(this._valueGetter(addedItem))
                }.bind(this))
            },
            _getActualSearchValue: function() {
                return this._dataSource.searchValue()
            },
            _toggleOpenState: function(isVisible) {
                if (this.option("disabled")) {
                    return
                }
                isVisible = arguments.length ? isVisible : !this.option("opened");
                if (!isVisible) {
                    this._restoreInputText(true)
                }
                if (this._wasSearch() && isVisible) {
                    this._wasSearch(false);
                    var showDataImmediately = this.option("showDataBeforeSearch") || 0 === this.option("minSearchLength");
                    if (showDataImmediately && this._dataSource) {
                        if (this._searchTimer) {
                            return
                        }
                        var searchValue = this._getActualSearchValue();
                        searchValue && this._wasSearch(true);
                        this._filterDataSource(searchValue || null)
                    } else {
                        this._setListOption("items", [])
                    }
                }
                if (isVisible) {
                    this._scrollToSelectedItem()
                }
                this.callBase(isVisible)
            },
            _renderTooltip: function() {
                if (this.option("tooltipEnabled")) {
                    this.$element().attr("title", this.option("displayValue"))
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._dimensionChanged()
            },
            _isValueEqualInputText: function() {
                var initialSelectedItem = this.option("selectedItem");
                var value = this._displayGetter(initialSelectedItem);
                var displayValue = value ? String(value) : "";
                var inputText = this._searchValue();
                return displayValue === inputText
            },
            _popupHidingHandler: function() {
                if (this._isValueEqualInputText()) {
                    this._cancelEditing()
                }
                this.callBase()
            },
            _restoreInputText: function(saveEditingValue) {
                if (this.option("readOnly")) {
                    return
                }
                this._loadItemDeferred && this._loadItemDeferred.always(function() {
                    var initialSelectedItem = this.option("selectedItem");
                    if (this.option("acceptCustomValue")) {
                        if (!saveEditingValue) {
                            this._updateField(initialSelectedItem);
                            this._clearFilter()
                        }
                        return
                    }
                    if (this.option("searchEnabled")) {
                        if (!this._searchValue() && this.option("allowClearing")) {
                            this._clearTextValue();
                            return
                        }
                    }
                    if (this._isValueEqualInputText()) {
                        return
                    }
                    this._renderInputValue().always(function(selectedItem) {
                        var newSelectedItem = (0, _common.ensureDefined)(selectedItem, initialSelectedItem);
                        this._setSelectedItem(newSelectedItem);
                        this._updateField(newSelectedItem);
                        this._clearFilter()
                    }.bind(this))
                }.bind(this))
            },
            _focusOutHandler: function(e) {
                if (!this._preventNestedFocusEvent(e)) {
                    var isOverlayTarget = this._isOverlayNestedTarget(e.relatedTarget);
                    if (!isOverlayTarget) {
                        this._restoreInputText();
                        this._clearSearchTimer()
                    }
                    var shouldCancelSearch = this._wasSearch() && !this.option("acceptCustomValue") && this.option("searchEnabled") && this.option("opened") && !isOverlayTarget;
                    if (shouldCancelSearch) {
                        this._searchCanceled()
                    }
                }
                this.callBase(e)
            },
            _isOverlayNestedTarget: function(target) {
                return !!(0, _renderer.default)(target).closest(".".concat(SELECTBOX_POPUP_WRAPPER_CLASS)).length
            },
            _clearTextValue: function() {
                if (this.option("selectedItem")) {
                    this.option("value", null)
                }
            },
            _shouldOpenPopup: function() {
                return this._needPassDataSourceToList()
            },
            _isFocused: function() {
                var activeElement = _dom_adapter.default.getActiveElement();
                return this.callBase() && (0, _renderer.default)(activeElement).closest(this._input()).length > 0
            },
            _renderValueChangeEvent: function() {
                if (this._isEditable()) {
                    this.callBase()
                }
            },
            _isEditable: function() {
                return this.option("acceptCustomValue") || this.option("searchEnabled")
            },
            _fieldRenderData: function() {
                var $listFocused = this._list && this.option("opened") && (0, _renderer.default)(this._list.option("focusedElement"));
                if ($listFocused && $listFocused.length) {
                    return this._list._getItemData($listFocused)
                }
                return this.option("selectedItem")
            },
            _readOnlyPropValue: function() {
                return !this._isEditable() || this.option("readOnly")
            },
            _isSelectedValue: function(value) {
                return this._isValueEquals(value, this.option("value"))
            },
            _shouldCloseOnItemClick: function() {
                return !(this.option("showSelectionControls") && "single" !== this.option("selectionMode"))
            },
            _listItemClickHandler: function(e) {
                var previousValue = this._getCurrentValue();
                this._focusListElement((0, _renderer.default)(e.itemElement));
                this._saveValueChangeEvent(e.event);
                if (this._shouldClearFilter()) {
                    this._clearFilter()
                }
                this._completeSelection(this._valueGetter(e.itemData));
                if (this._shouldCloseOnItemClick()) {
                    this.option("opened", false)
                }
                if (this.option("searchEnabled") && previousValue === this._valueGetter(e.itemData)) {
                    this._updateField(e.itemData)
                }
            },
            _shouldClearFilter: function() {
                return this._wasSearch()
            },
            _completeSelection: function(value) {
                this._setValue(value)
            },
            _loadItem: function(value, cache) {
                var that = this;
                var deferred = new _deferred.Deferred;
                this.callBase(value, cache).done(function(item) {
                    deferred.resolve(item)
                }.bind(this)).fail(function() {
                    var selectedItem = that.option("selectedItem");
                    if (that.option("acceptCustomValue") && value === that._valueGetter(selectedItem)) {
                        deferred.resolve(selectedItem)
                    } else {
                        deferred.reject()
                    }
                }.bind(this));
                return deferred.promise()
            },
            _loadInputValue: function(value, callback) {
                this._loadItemDeferred = this._loadItem(value).always(callback);
                return this._loadItemDeferred
            },
            _isCustomItemSelected: function() {
                var selectedItem = this.option("selectedItem");
                var searchValue = this._searchValue();
                var selectedItemText = this._displayGetter(selectedItem);
                return !selectedItemText || searchValue !== selectedItemText.toString()
            },
            _valueChangeEventHandler: function(e) {
                if (this.option("acceptCustomValue") && this._isCustomItemSelected() && !this._isValueChanging) {
                    this._isValueChanging = true;
                    this._customItemAddedHandler(e);
                    this._isValueChanging = false
                }
            },
            _initCustomItemCreatingAction: function() {
                this._customItemCreatingAction = this._createActionByOption("onCustomItemCreating")
            },
            _createCustomItem: function(text) {
                var params = {
                    text: text
                };
                var actionResult = this._customItemCreatingAction(params);
                var item = (0, _common.ensureDefined)(actionResult, params.customItem);
                if ((0, _type.isDefined)(actionResult)) {
                    _errors.default.log("W0015", "onCustomItemCreating", "customItem")
                }
                return item
            },
            _customItemAddedHandler: function(e) {
                var searchValue = this._searchValue();
                var item = this._createCustomItem(searchValue);
                this._saveValueChangeEvent(e);
                if (void 0 === item) {
                    this._renderValue();
                    throw _errors.default.Error("E0121")
                }
                if ((0, _type.isPromise)(item)) {
                    (0, _deferred.fromPromise)(item).done(this._setCustomItem.bind(this)).fail(this._setCustomItem.bind(this, null))
                } else {
                    this._setCustomItem(item)
                }
            },
            _setCustomItem: function(item) {
                if (this._disposed) {
                    return
                }
                item = item || null;
                this.option("selectedItem", item);
                if (this._shouldClearFilter()) {
                    this._filterDataSource(null)
                }
                this._setValue(this._valueGetter(item));
                this._renderDisplayText(this._displayGetter(item))
            },
            _clearValueHandler: function(e) {
                this.callBase(e);
                return false
            },
            _wasSearch: function(value) {
                if (!arguments.length) {
                    return this._wasSearchValue
                }
                this._wasSearchValue = value
            },
            _searchHandler: function(e) {
                if (this._preventFiltering) {
                    delete this._preventFiltering;
                    return
                }
                if (this._needPassDataSourceToList()) {
                    this._wasSearch(true)
                }
                this.callBase(e)
            },
            _dataSourceFiltered: function(searchValue) {
                this.callBase();
                if (null !== searchValue) {
                    this._renderInputSubstitution();
                    this._renderFocusedElement()
                }
            },
            _valueSubstituted: function() {
                var input = this._input().get(0);
                var isAllSelected = 0 === input.selectionStart && input.selectionEnd === this._searchValue().length;
                var inputHasSelection = input.selectionStart !== input.selectionEnd;
                return this._wasSearch() && inputHasSelection && !isAllSelected
            },
            _shouldSubstitutionBeRendered: function() {
                return !this._preventSubstitution && this.option("searchEnabled") && !this.option("acceptCustomValue") && "startswith" === this.option("searchMode")
            },
            _renderInputSubstitution: function() {
                if (!this._shouldSubstitutionBeRendered()) {
                    delete this._preventSubstitution;
                    return
                }
                var item = this._list && this._getPlainItems(this._list.option("items"))[0];
                if (!item) {
                    return
                }
                var $input = this._input();
                var valueLength = $input.val().length;
                if (0 === valueLength) {
                    return
                }
                var inputElement = $input.get(0);
                var displayValue = this._displayGetter(item).toString();
                inputElement.value = displayValue;
                this._caret({
                    start: valueLength,
                    end: displayValue.length
                })
            },
            _cleanInputSelection: function() {
                var inputElement = this._input().get(0);
                var endPosition = inputElement.value.length;
                inputElement.selectionStart = endPosition;
                inputElement.selectionEnd = endPosition
            },
            _dispose: function() {
                this._renderInputValueAsync = _common.noop;
                delete this._loadItemDeferred;
                this.callBase()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onCustomItemCreating":
                        this._initCustomItemCreatingAction();
                        break;
                    case "tooltipEnabled":
                        this._renderTooltip();
                        break;
                    case "displayCustomValue":
                    case "acceptCustomValue":
                    case "showSelectionControls":
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "allowClearing":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                delete this._inkRipple;
                this.callBase()
            }
        });
        (0, _component_registrator.default)("dxSelectBox", SelectBox);
        var _default = SelectBox;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/shared/accessibility.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.subscribeVisibilityChange = subscribeVisibilityChange;
        exports.unsubscribeVisibilityChange = unsubscribeVisibilityChange;
        exports.hiddenFocus = hiddenFocus;
        exports.registerKeyboardAction = registerKeyboardAction;
        exports.restoreFocus = restoreFocus;
        exports.selectView = selectView;
        exports.setTabIndex = setTabIndex;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var FOCUS_STATE_CLASS = "dx-state-focused";
        var FOCUS_DISABLED_CLASS = "dx-cell-focus-disabled";
        var FOCUSED_ROW_SELECTOR = ".dx-row-focused";
        var GRID_ROW_SELECTOR = ".dx-datagrid-rowsview .dx-row";
        var GRID_CELL_SELECTOR = "".concat(GRID_ROW_SELECTOR, " > td");
        var TREELIST_ROW_SELECTOR = ".dx-treelist-rowsview .dx-row";
        var TREELIST_CELL_SELECTOR = "".concat(TREELIST_ROW_SELECTOR, " > td");
        var viewItemSelectorMap = {
            groupPanel: [".dx-datagrid-group-panel .dx-group-panel-item[tabindex]"],
            columnHeaders: [".dx-datagrid-headers .dx-header-row > td.dx-datagrid-action", ".dx-treelist-headers .dx-header-row > td.dx-treelist-action"],
            filterRow: [".dx-datagrid-headers .dx-datagrid-filter-row .dx-editor-cell .dx-texteditor-input", ".dx-treelist-headers .dx-treelist-filter-row .dx-editor-cell .dx-texteditor-input"],
            rowsView: ["".concat(FOCUSED_ROW_SELECTOR), "".concat(GRID_ROW_SELECTOR, "[tabindex]"), "".concat(GRID_CELL_SELECTOR, "[tabindex]"), "".concat(GRID_CELL_SELECTOR), "".concat(TREELIST_ROW_SELECTOR, "[tabindex]"), "".concat(TREELIST_CELL_SELECTOR, "[tabindex]"), "".concat(TREELIST_CELL_SELECTOR)],
            footer: [".dx-datagrid-total-footer .dx-datagrid-summary-item", ".dx-treelist-total-footer .dx-treelist-summary-item"],
            filterPanel: [".dx-datagrid-filter-panel .dx-icon-filter", ".dx-treelist-filter-panel .dx-icon-filter"],
            pager: [".dx-datagrid-pager [tabindex]", ".dx-treelist-pager [tabindex]"]
        };
        var isMouseDown = false;
        var isHiddenFocusing = false;
        var focusedElementInfo = null;

        function processKeyDown(viewName, instance, event, action, $mainElement, executeKeyDown) {
            var isHandled = fireKeyDownEvent(instance, event.originalEvent, executeKeyDown);
            if (isHandled) {
                return
            }
            var keyName = (0, _index.normalizeKeyName)(event);
            if ("enter" === keyName || "space" === keyName) {
                saveFocusedElementInfo(event.target, instance);
                action && action({
                    event: event
                })
            } else {
                if ("tab" === keyName) {
                    $mainElement.addClass(FOCUS_STATE_CLASS)
                } else {
                    selectView(viewName, instance, event)
                }
            }
        }

        function saveFocusedElementInfo(target, instance) {
            var $target = (0, _renderer.default)(target);
            var ariaLabel = $target.attr("aria-label");
            var $activeElements = getActiveAccessibleElements(ariaLabel, instance.element());
            var targetIndex = $activeElements.index($target);
            focusedElementInfo = (0, _extend.extend)({}, {
                ariaLabel: ariaLabel,
                index: targetIndex
            }, {
                viewInstance: instance
            })
        }

        function getActiveAccessibleElements(ariaLabel, viewElement) {
            var $viewElement = (0, _renderer.default)(viewElement);
            var $activeElements;
            if (ariaLabel) {
                $activeElements = $viewElement.find('[aria-label="'.concat(ariaLabel, '"][tabindex]'))
            } else {
                $activeElements = $viewElement.find("[tabindex]")
            }
            return $activeElements
        }

        function findFocusedViewElement(viewSelectors) {
            for (var index in viewSelectors) {
                var selector = viewSelectors[index];
                var $focusViewElement = (0, _renderer.default)(selector).first();
                if ($focusViewElement.length) {
                    return $focusViewElement
                }
            }
        }

        function fireKeyDownEvent(instance, event, executeAction) {
            var args = {
                event: event,
                handled: false
            };
            if (executeAction) {
                executeAction(args)
            } else {
                instance._createActionByOption("onKeyDown")(args)
            }
            return args.handled
        }

        function onDocumentVisibilityChange() {
            isHiddenFocusing = "visible" === _dom_adapter.default.getDocument().visibilityState
        }

        function subscribeVisibilityChange() {
            _events_engine.default.on(_dom_adapter.default.getDocument(), "visibilitychange", onDocumentVisibilityChange)
        }

        function unsubscribeVisibilityChange() {
            _events_engine.default.off(_dom_adapter.default.getDocument(), "visibilitychange", onDocumentVisibilityChange)
        }

        function hiddenFocus(element) {
            isHiddenFocusing = true;
            element.focus();
            isHiddenFocusing = false
        }

        function registerKeyboardAction(viewName, instance, $element, selector, action, executeKeyDown) {
            if (instance.option("useLegacyKeyboardNavigation")) {
                return _common.noop
            }
            var $mainElement = (0, _renderer.default)(instance.element());
            var keyDownHandler = function(e) {
                return processKeyDown(viewName, instance, e, action, $mainElement, executeKeyDown)
            };
            var mouseDownHandler = function() {
                isMouseDown = true;
                $mainElement.removeClass(FOCUS_STATE_CLASS)
            };
            var focusinHandler = function() {
                var needShowOverlay = !isMouseDown && !isHiddenFocusing;
                if (needShowOverlay) {
                    $mainElement.addClass(FOCUS_STATE_CLASS)
                }
                isMouseDown = false
            };
            _events_engine.default.on($element, "keydown", selector, keyDownHandler);
            _events_engine.default.on($element, "mousedown", selector, mouseDownHandler);
            _events_engine.default.on($element, "focusin", selector, focusinHandler);
            return function() {
                _events_engine.default.off($element, "keydown", selector, keyDownHandler);
                _events_engine.default.off($element, "mousedown", selector, mouseDownHandler);
                _events_engine.default.off($element, "focusin", selector, focusinHandler)
            }
        }

        function restoreFocus(instance) {
            if (!instance.option("useLegacyKeyboardNavigation") && focusedElementInfo) {
                var viewInstance = focusedElementInfo.viewInstance;
                if (viewInstance) {
                    var $activeElements = getActiveAccessibleElements(focusedElementInfo.ariaLabel, viewInstance.element());
                    var $targetElement = $activeElements.eq(focusedElementInfo.index);
                    focusedElementInfo = null;
                    _events_engine.default.trigger($targetElement, "focus")
                }
            }
        }

        function selectView(viewName, instance, event) {
            var keyName = (0, _index.normalizeKeyName)(event);
            if (event.ctrlKey && ("upArrow" === keyName || "downArrow" === keyName)) {
                var viewNames = Object.keys(viewItemSelectorMap);
                var viewItemIndex = viewNames.indexOf(viewName);
                while (viewItemIndex >= 0 && viewItemIndex < viewNames.length) {
                    viewItemIndex = "upArrow" === keyName ? --viewItemIndex : ++viewItemIndex;
                    var _viewName = viewNames[viewItemIndex];
                    var viewSelectors = viewItemSelectorMap[_viewName];
                    var $focusViewElement = findFocusedViewElement(viewSelectors);
                    if ($focusViewElement && $focusViewElement.length) {
                        $focusViewElement.attr("tabindex", instance.option("tabindex") || 0);
                        _events_engine.default.trigger($focusViewElement, "focus");
                        $focusViewElement.removeClass(FOCUS_DISABLED_CLASS);
                        break
                    }
                }
            }
        }

        function setTabIndex(instance, $element) {
            if (!instance.option("useLegacyKeyboardnavigation")) {
                $element.attr("tabindex", instance.option("tabindex") || 0)
            }
        }
    },
    /*!**************************************************!*\
      !*** ./node_modules/rrule/dist/esm/src/rrule.js ***!
      \**************************************************/
    /*! exports provided: Days, DEFAULT_OPTIONS, defaultKeys, default */
    /*! exports used: DEFAULT_OPTIONS, Days, default, defaultKeys */
    function(module, __webpack_exports__, __webpack_require__) {
        __webpack_require__.d(__webpack_exports__, "b", function() {
            return Days
        });
        __webpack_require__.d(__webpack_exports__, "a", function() {
            return DEFAULT_OPTIONS
        });
        __webpack_require__.d(__webpack_exports__, "d", function() {
            return defaultKeys
        });
        var __WEBPACK_IMPORTED_MODULE_0__dateutil__ = __webpack_require__( /*! ./dateutil */ 63);
        var __WEBPACK_IMPORTED_MODULE_1__iterresult__ = __webpack_require__( /*! ./iterresult */ 295);
        var __WEBPACK_IMPORTED_MODULE_2__callbackiterresult__ = __webpack_require__( /*! ./callbackiterresult */ 785);
        var __WEBPACK_IMPORTED_MODULE_3__types__ = __webpack_require__( /*! ./types */ 139);
        var __WEBPACK_IMPORTED_MODULE_4__parseoptions__ = __webpack_require__( /*! ./parseoptions */ 427);
        var __WEBPACK_IMPORTED_MODULE_5__parsestring__ = __webpack_require__( /*! ./parsestring */ 428);
        var __WEBPACK_IMPORTED_MODULE_6__optionstostring__ = __webpack_require__( /*! ./optionstostring */ 429);
        var __WEBPACK_IMPORTED_MODULE_7__cache__ = __webpack_require__( /*! ./cache */ 787);
        var __WEBPACK_IMPORTED_MODULE_8__weekday__ = __webpack_require__( /*! ./weekday */ 158);
        var __WEBPACK_IMPORTED_MODULE_9__iter_index__ = __webpack_require__( /*! ./iter/index */ 430);
        var getnlp = function() {
            if (!getnlp._nlp) {
                getnlp._nlp = __webpack_require__( /*! ./nlp */ 794)
            }
            return getnlp._nlp
        };
        var Days = {
            MO: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(0),
            TU: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(1),
            WE: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(2),
            TH: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(3),
            FR: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(4),
            SA: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(5),
            SU: new __WEBPACK_IMPORTED_MODULE_8__weekday__.b(6)
        };
        var DEFAULT_OPTIONS = {
            freq: __WEBPACK_IMPORTED_MODULE_3__types__.a.YEARLY,
            dtstart: null,
            interval: 1,
            wkst: Days.MO,
            count: null,
            until: null,
            tzid: null,
            bysetpos: null,
            bymonth: null,
            bymonthday: null,
            bynmonthday: null,
            byyearday: null,
            byweekno: null,
            byweekday: null,
            bynweekday: null,
            byhour: null,
            byminute: null,
            bysecond: null,
            byeaster: null
        };
        var defaultKeys = Object.keys(DEFAULT_OPTIONS);
        var RRule = function() {
            function RRule(options, noCache) {
                if (void 0 === options) {
                    options = {}
                }
                if (void 0 === noCache) {
                    noCache = false
                }
                this._cache = noCache ? null : new __WEBPACK_IMPORTED_MODULE_7__cache__.a;
                this.origOptions = Object(__WEBPACK_IMPORTED_MODULE_4__parseoptions__.b)(options);
                var parsedOptions = Object(__WEBPACK_IMPORTED_MODULE_4__parseoptions__.c)(options).parsedOptions;
                this.options = parsedOptions
            }
            RRule.parseText = function(text, language) {
                return getnlp().parseText(text, language)
            };
            RRule.fromText = function(text, language) {
                return getnlp().fromText(text, language)
            };
            RRule.fromString = function(str) {
                return new RRule(RRule.parseString(str) || void 0)
            };
            RRule.prototype._iter = function(iterResult) {
                return Object(__WEBPACK_IMPORTED_MODULE_9__iter_index__.a)(iterResult, this.options)
            };
            RRule.prototype._cacheGet = function(what, args) {
                if (!this._cache) {
                    return false
                }
                return this._cache._cacheGet(what, args)
            };
            RRule.prototype._cacheAdd = function(what, value, args) {
                if (!this._cache) {
                    return
                }
                return this._cache._cacheAdd(what, value, args)
            };
            RRule.prototype.all = function(iterator) {
                if (iterator) {
                    return this._iter(new __WEBPACK_IMPORTED_MODULE_2__callbackiterresult__.a("all", {}, iterator))
                }
                var result = this._cacheGet("all");
                if (false === result) {
                    result = this._iter(new __WEBPACK_IMPORTED_MODULE_1__iterresult__.a("all", {}));
                    this._cacheAdd("all", result)
                }
                return result
            };
            RRule.prototype.between = function(after, before, inc, iterator) {
                if (void 0 === inc) {
                    inc = false
                }
                if (!__WEBPACK_IMPORTED_MODULE_0__dateutil__.b.isValidDate(after) || !__WEBPACK_IMPORTED_MODULE_0__dateutil__.b.isValidDate(before)) {
                    throw new Error("Invalid date passed in to RRule.between")
                }
                var args = {
                    before: before,
                    after: after,
                    inc: inc
                };
                if (iterator) {
                    return this._iter(new __WEBPACK_IMPORTED_MODULE_2__callbackiterresult__.a("between", args, iterator))
                }
                var result = this._cacheGet("between", args);
                if (false === result) {
                    result = this._iter(new __WEBPACK_IMPORTED_MODULE_1__iterresult__.a("between", args));
                    this._cacheAdd("between", result, args)
                }
                return result
            };
            RRule.prototype.before = function(dt, inc) {
                if (void 0 === inc) {
                    inc = false
                }
                if (!__WEBPACK_IMPORTED_MODULE_0__dateutil__.b.isValidDate(dt)) {
                    throw new Error("Invalid date passed in to RRule.before")
                }
                var args = {
                    dt: dt,
                    inc: inc
                };
                var result = this._cacheGet("before", args);
                if (false === result) {
                    result = this._iter(new __WEBPACK_IMPORTED_MODULE_1__iterresult__.a("before", args));
                    this._cacheAdd("before", result, args)
                }
                return result
            };
            RRule.prototype.after = function(dt, inc) {
                if (void 0 === inc) {
                    inc = false
                }
                if (!__WEBPACK_IMPORTED_MODULE_0__dateutil__.b.isValidDate(dt)) {
                    throw new Error("Invalid date passed in to RRule.after")
                }
                var args = {
                    dt: dt,
                    inc: inc
                };
                var result = this._cacheGet("after", args);
                if (false === result) {
                    result = this._iter(new __WEBPACK_IMPORTED_MODULE_1__iterresult__.a("after", args));
                    this._cacheAdd("after", result, args)
                }
                return result
            };
            RRule.prototype.count = function() {
                return this.all().length
            };
            RRule.prototype.toString = function() {
                return Object(__WEBPACK_IMPORTED_MODULE_6__optionstostring__.a)(this.origOptions)
            };
            RRule.prototype.toText = function(gettext, language, dateFormatter) {
                return getnlp().toText(this, gettext, language, dateFormatter)
            };
            RRule.prototype.isFullyConvertibleToText = function() {
                return getnlp().isFullyConvertible(this)
            };
            RRule.prototype.clone = function() {
                return new RRule(this.origOptions)
            };
            RRule.FREQUENCIES = ["YEARLY", "MONTHLY", "WEEKLY", "DAILY", "HOURLY", "MINUTELY", "SECONDLY"];
            RRule.YEARLY = __WEBPACK_IMPORTED_MODULE_3__types__.a.YEARLY;
            RRule.MONTHLY = __WEBPACK_IMPORTED_MODULE_3__types__.a.MONTHLY;
            RRule.WEEKLY = __WEBPACK_IMPORTED_MODULE_3__types__.a.WEEKLY;
            RRule.DAILY = __WEBPACK_IMPORTED_MODULE_3__types__.a.DAILY;
            RRule.HOURLY = __WEBPACK_IMPORTED_MODULE_3__types__.a.HOURLY;
            RRule.MINUTELY = __WEBPACK_IMPORTED_MODULE_3__types__.a.MINUTELY;
            RRule.SECONDLY = __WEBPACK_IMPORTED_MODULE_3__types__.a.SECONDLY;
            RRule.MO = Days.MO;
            RRule.TU = Days.TU;
            RRule.WE = Days.WE;
            RRule.TH = Days.TH;
            RRule.FR = Days.FR;
            RRule.SA = Days.SA;
            RRule.SU = Days.SU;
            RRule.parseString = __WEBPACK_IMPORTED_MODULE_5__parsestring__.b;
            RRule.optionsToString = __WEBPACK_IMPORTED_MODULE_6__optionstostring__.a;
            return RRule
        }();
        __webpack_exports__.c = RRule
    },
    /*!************************************************************!*\
      !*** ./node_modules/rrule/node_modules/tslib/tslib.es6.js ***!
      \************************************************************/
    /*! exports provided: __extends, __assign, __rest, __decorate, __param, __metadata, __awaiter, __generator, __createBinding, __exportStar, __values, __read, __spread, __spreadArrays, __await, __asyncGenerator, __asyncDelegator, __asyncValues, __makeTemplateObject, __importStar, __importDefault, __classPrivateFieldGet, __classPrivateFieldSet */
    /*! exports used: __assign, __extends, __spreadArrays */
    function(module, __webpack_exports__, __webpack_require__) {
        __webpack_exports__.b = __extends;
        __webpack_require__.d(__webpack_exports__, "a", function() {
            return __assign
        });
        __webpack_exports__.c = __spreadArrays;
        /*! *****************************************************************************
        Copyright (c) Microsoft Corporation.

        Permission to use, copy, modify, and/or distribute this software for any
        purpose with or without fee is hereby granted.

        THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
        REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
        AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
        INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
        LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
        OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
        PERFORMANCE OF THIS SOFTWARE.
        ***************************************************************************** */
        var extendStatics = function(d, b) {
            extendStatics = Object.setPrototypeOf || {
                __proto__: []
            }
            instanceof Array && function(d, b) {
                d.__proto__ = b
            } || function(d, b) {
                for (var p in b) {
                    if (b.hasOwnProperty(p)) {
                        d[p] = b[p]
                    }
                }
            };
            return extendStatics(d, b)
        };

        function __extends(d, b) {
            extendStatics(d, b);

            function __() {
                this.constructor = d
            }
            d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
        }
        var __assign = function() {
            __assign = Object.assign || function(t) {
                for (var s, i = 1, n = arguments.length; i < n; i++) {
                    s = arguments[i];
                    for (var p in s) {
                        if (Object.prototype.hasOwnProperty.call(s, p)) {
                            t[p] = s[p]
                        }
                    }
                }
                return t
            };
            return __assign.apply(this, arguments)
        };

        function __spreadArrays() {
            for (var s = 0, i = 0, il = arguments.length; i < il; i++) {
                s += arguments[i].length
            }
            for (var r = Array(s), k = 0, i = 0; i < il; i++) {
                for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++) {
                    r[k] = a[j]
                }
            }
            return r
        }
    }, , , , ,
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/resize_callbacks.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _window = __webpack_require__( /*! ./window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 27));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 49));
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var resizeCallbacks = function() {
            var prevSize;
            var callbacks = (0, _callbacks.default)();
            var originalCallbacksAdd = callbacks.add;
            var originalCallbacksRemove = callbacks.remove;
            if (!(0, _window.hasWindow)()) {
                return callbacks
            }
            var formatSize = function() {
                var window = (0, _window.getWindow)();
                return {
                    width: window.innerWidth,
                    height: window.innerHeight
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                callbacks.fire(changedDimension)
            };
            var setPrevSize = (0, _call_once.default)(function() {
                prevSize = formatSize()
            });
            var removeListener;
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                setPrevSize();
                _ready_callbacks.default.add(function() {
                    if (!removeListener && callbacks.has()) {
                        removeListener = _dom_adapter.default.listen((0, _window.getWindow)(), "resize", handleResize)
                    }
                });
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && removeListener) {
                    removeListener();
                    removeListener = void 0
                }
                return result
            };
            return callbacks
        }();
        var _default = resizeCallbacks;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/function_template.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.FunctionTemplate = void 0;
        var _template_base = __webpack_require__( /*! ./template_base */ 75);
        var _dom = __webpack_require__( /*! ../utils/dom */ 33);

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var FunctionTemplate = function(_TemplateBase) {
            _inherits(FunctionTemplate, _TemplateBase);
            var _super = _createSuper(FunctionTemplate);

            function FunctionTemplate(render) {
                var _this;
                _classCallCheck(this, FunctionTemplate);
                _this = _super.call(this);
                _this._render = render;
                return _this
            }
            _createClass(FunctionTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    return (0, _dom.normalizeTemplateElement)(this._render(options))
                }
            }]);
            return FunctionTemplate
        }(_template_base.TemplateBase);
        exports.FunctionTemplate = FunctionTemplate
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _index = __webpack_require__( /*! ./options/index */ 334);
        var _utils = __webpack_require__( /*! ./options/utils */ 200);
        var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 15));
        var _action = _interopRequireDefault(__webpack_require__( /*! ./action */ 110));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _events_strategy = __webpack_require__( /*! ./events_strategy */ 98);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);
        var _postponed_operations = __webpack_require__( /*! ./postponed_operations */ 515);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _common = __webpack_require__( /*! ./utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getEventName = function(actionName) {
            return actionName.charAt(2).toLowerCase() + actionName.substr(3)
        };
        var isInnerOption = function(optionName) {
            return 0 === optionName.indexOf("_", 0)
        };
        var Component = _class.default.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _defaultOptionsRules: function() {
                return []
            },
            _setOptionsByDevice: function(rules) {
                this._options.applyRules(rules)
            },
            _convertRulesToOptions: function(rules) {
                return (0, _utils.convertRulesToOptions)(rules)
            },
            _isInitialOptionValue: function(name) {
                return this._options.isInitial(name)
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function() {
                var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
                var _optionChangedCallbacks = options._optionChangedCallbacks,
                    _disposingCallbacks = options._disposingCallbacks;
                this.NAME = (0, _public_component.name)(this.constructor);
                this._eventsStrategy = _events_strategy.EventsStrategy.create(this, options.eventsStrategy);
                this._updateLockCount = 0;
                this._optionChangedCallbacks = _optionChangedCallbacks || (0, _callbacks.default)();
                this._disposingCallbacks = _disposingCallbacks || (0, _callbacks.default)();
                this.postponedOperations = new _postponed_operations.PostponedOperations;
                this._createOptions(options)
            },
            _createOptions: function(options) {
                var _this = this;
                this.beginUpdate();
                try {
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._options = new _index.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions());
                    this._options.onChanging(function(name, previousValue, value) {
                        return _this._initialized && _this._optionChanging(name, previousValue, value)
                    });
                    this._options.onDeprecated(function(option, info) {
                        return _this._logDeprecatedOptionWarning(option, info)
                    });
                    this._options.onChanged(function(name, value, previousValue) {
                        return _this._notifyOptionChanged(name, value, previousValue)
                    });
                    this._options.onStartChange(function() {
                        return _this.beginUpdate()
                    });
                    this._options.onEndChange(function() {
                        return _this.endUpdate()
                    });
                    this._options.addRules(this._defaultOptionsRules());
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _init: function() {
                var _this2 = this;
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    _this2._disposingCallbacks.fireWith(_this2, [args])
                })
            },
            _logDeprecatedOptionWarning: function(option, info) {
                var message = info.message || "Use the '".concat(info.alias, "' option instead");
                _errors.default.log("W0001", this.NAME, option, info.since, message)
            },
            _logDeprecatedComponentWarning: function(since, alias) {
                _errors.default.log("W0000", this.NAME, since, "Use the '".concat(alias, "' widget instead"))
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._eventsStrategy.dispose();
                this._options.dispose();
                this._disposed = true
            },
            _lockUpdate: function() {
                this._updateLockCount++
            },
            _unlockUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
            },
            _isUpdateAllowed: function() {
                return 0 === this._updateLockCount
            },
            _isInitializingRequired: function() {
                return !this._initializing && !this._initialized
            },
            _commitUpdate: function() {
                this.postponedOperations.callPostponedOperations();
                this._isInitializingRequired() && this._initializeComponent()
            },
            _initializeComponent: function() {
                this._initializing = true;
                try {
                    this._init()
                } finally {
                    this._initializing = false;
                    this._lockUpdate();
                    this._createActionByOption("onInitialized", {
                        excludeValidators: ["disabled", "readOnly"]
                    })();
                    this._unlockUpdate();
                    this._initialized = true
                }
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._lockUpdate()
            },
            endUpdate: function() {
                this._unlockUpdate();
                this._isUpdateAllowed() && this._commitUpdate()
            },
            _optionChanging: _common.noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                if (this._initialized) {
                    var optionNames = [option].concat(this._options.getAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i];
                        var args = {
                            name: name.split(/[.[]/)[0],
                            fullName: name,
                            value: value,
                            previousValue: previousValue
                        };
                        if (!isInnerOption(name)) {
                            this._optionChangedCallbacks.fireWith(this, [(0, _extend.extend)(this._defaultActionArgs(), args)]);
                            this._optionChangedAction((0, _extend.extend)({}, args))
                        }
                        if (!this._disposed && this._cancelOptionChange !== name) {
                            this._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(name) {
                return this._options.initial(name)
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var _this3 = this;
                var action;
                return function(e) {
                    if (!(0, _type.isDefined)(e)) {
                        e = {}
                    }
                    if (!(0, _type.isPlainObject)(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new _action.default(actionSource, (0, _extend.extend)(config, _this3._defaultActionConfig()));
                    return action.execute.call(action, (0, _extend.extend)(e, _this3._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var _this4 = this;
                var action;
                var eventName;
                var actionFunc;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw _errors.default.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = getEventName(optionName)
                        }
                        actionFunc = _this4.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !_this4._eventsStrategy.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function() {
                            for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                props[_key2] = arguments[_key2]
                            }
                            beforeExecute && beforeExecute.apply(_this4, props);
                            _this4._eventsStrategy.fireEvent(eventName, props[0].args)
                        };
                        action = _this4._createAction(actionFunc, config)
                    }
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }
                    if ((0, _config.default)().wrapActionsBeforeExecute) {
                        var beforeActionExecute = _this4.option("beforeActionExecute") || _common.noop;
                        var wrappedAction = beforeActionExecute(_this4, action, config) || action;
                        return wrappedAction.apply(_this4, args)
                    }
                    return action.apply(_this4, args)
                };
                if ((0, _config.default)().wrapActionsBeforeExecute) {
                    return result
                }
                var onActionCreated = this.option("onActionCreated") || _common.noop;
                return onActionCreated(this, result, config) || result
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            hasActionSubscription: function(actionName) {
                return !!this._options.silent(actionName) || this._eventsStrategy.hasEvent(getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                return this._options.isDeprecated(name)
            },
            _setOptionWithoutOptionChange: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            _getOptionValue: function(name, context) {
                var value = this.option(name);
                if ((0, _type.isFunction)(value)) {
                    return value.bind(context)()
                }
                return value
            },
            option: function() {
                var _this$_options;
                return (_this$_options = this._options).option.apply(_this$_options, arguments)
            },
            resetOption: function(name) {
                this.beginUpdate();
                this._options.reset(name);
                this.endUpdate()
            }
        });
        var _default = Component;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/events/short.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.keyboard = exports.click = exports.dxClick = exports.focus = exports.visibility = exports.hover = exports.resize = exports.active = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 5));
        var _keyboard_processor = _interopRequireDefault(__webpack_require__( /*! ./core/keyboard_processor */ 519));
        var _index = __webpack_require__( /*! ./utils/index */ 8);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function addNamespace(event, namespace) {
            return namespace ? (0, _index.addNamespace)(event, namespace) : event
        }

        function executeAction(action, args) {
            return "function" === typeof action ? action(args) : action.execute(args)
        }
        var active = {
            on: function($el, active, inactive, opts) {
                var selector = opts.selector,
                    showTimeout = opts.showTimeout,
                    hideTimeout = opts.hideTimeout,
                    namespace = opts.namespace;
                _events_engine.default.on($el, addNamespace("dxactive", namespace), selector, {
                    timeout: showTimeout
                }, function(event) {
                    return executeAction(active, {
                        event: event,
                        element: event.currentTarget
                    })
                });
                _events_engine.default.on($el, addNamespace("dxinactive", namespace), selector, {
                    timeout: hideTimeout
                }, function(event) {
                    return executeAction(inactive, {
                        event: event,
                        element: event.currentTarget
                    })
                })
            },
            off: function($el, _ref) {
                var namespace = _ref.namespace,
                    selector = _ref.selector;
                _events_engine.default.off($el, addNamespace("dxactive", namespace), selector);
                _events_engine.default.off($el, addNamespace("dxinactive", namespace), selector)
            }
        };
        exports.active = active;
        var resize = {
            on: function($el, resize) {
                var _ref2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                    namespace = _ref2.namespace;
                _events_engine.default.on($el, addNamespace("dxresize", namespace), resize)
            },
            off: function($el) {
                var _ref3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                    namespace = _ref3.namespace;
                _events_engine.default.off($el, addNamespace("dxresize", namespace))
            }
        };
        exports.resize = resize;
        var hover = {
            on: function($el, start, end, _ref4) {
                var selector = _ref4.selector,
                    namespace = _ref4.namespace;
                _events_engine.default.on($el, addNamespace("dxhoverend", namespace), selector, function(event) {
                    return end(event)
                });
                _events_engine.default.on($el, addNamespace("dxhoverstart", namespace), selector, function(event) {
                    return executeAction(start, {
                        element: event.target,
                        event: event
                    })
                })
            },
            off: function($el, _ref5) {
                var selector = _ref5.selector,
                    namespace = _ref5.namespace;
                _events_engine.default.off($el, addNamespace("dxhoverstart", namespace), selector);
                _events_engine.defau