/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 20.2.3
 * Build date: Tue Oct 20 2020
 *
 * Copyright (c) 2012 - 2020 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 1008)
}([
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/extend.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.extend = exports.extendFromObject = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (Object.prototype.hasOwnProperty.call(source, prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        exports.extendFromObject = extendFromObject;
        var extend = function extend(target) {
            target = target || {};
            var i = 1;
            var deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var targetValue = target[key];
                    var sourceValue = source[key];
                    var sourceValueIsArray = false;
                    var clone = void 0;
                    if ("__proto__" === key || target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && ((0, _type.isPlainObject)(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && (0, _type.isPlainObject)(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/type.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.type = exports.isDeferred = exports.isPromise = exports.isRenderer = exports.isWindow = exports.isPrimitive = exports.isPlainObject = exports.isEmptyObject = exports.isObject = exports.isNumeric = exports.isString = exports.isFunction = exports.isDefined = exports.isDate = exports.isExponential = exports.isBoolean = void 0;

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === _typeof(object) ? types[typeOfObject] || "object" : _typeof(object)
        };
        exports.type = type;
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        exports.isBoolean = isBoolean;
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        exports.isExponential = isExponential;
        var isDate = function(object) {
            return "date" === type(object)
        };
        exports.isDate = isDate;
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        exports.isDefined = isDefined;
        var isFunction = function(object) {
            return "function" === typeof object
        };
        exports.isFunction = isFunction;
        var isString = function(object) {
            return "string" === typeof object
        };
        exports.isString = isString;
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        exports.isNumeric = isNumeric;
        var isObject = function(object) {
            return "object" === type(object)
        };
        exports.isObject = isObject;
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        exports.isEmptyObject = isEmptyObject;
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object);
            var ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        exports.isPlainObject = isPlainObject;
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        exports.isPrimitive = isPrimitive;
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        exports.isWindow = isWindow;
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        exports.isRenderer = isRenderer;
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        exports.isPromise = isPromise;
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isDeferred = isDeferred
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/core/renderer.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer_base = _interopRequireDefault(__webpack_require__( /*! ./renderer_base */ 236));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _renderer_base.default.get();
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/iterator.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.reverseEach = exports.each = exports.map = void 0;
        var map = function(values, callback) {
            if (Array.isArray(values)) {
                return values.map(callback)
            }
            var result = [];
            for (var key in values) {
                result.push(callback(values[key], key))
            }
            return result
        };
        exports.map = map;
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        exports.each = each;
        var reverseEach = function(array, callback) {
            if (!array || !("length" in array) || 0 === array.length) {
                return
            }
            for (var i = array.length - 1; i >= 0; i--) {
                if (false === callback.call(array[i], i, array[i])) {
                    break
                }
            }
        };
        exports.reverseEach = reverseEach
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/common.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.equalByValue = exports.grep = exports.asyncNoop = exports.noop = exports.applyServerDecimalSeparator = exports.escapeRegExp = exports.getKeyHash = exports.pairToObject = exports.denormalizeKey = exports.normalizeKey = exports.splitPair = exports.findBestMatches = exports.deferUpdater = exports.deferRenderer = exports.deferUpdate = exports.deferRender = exports.executeAsync = exports.ensureDefined = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../guid */ 36));
        var _deferred = __webpack_require__( /*! ../utils/deferred */ 6);
        var _data = __webpack_require__( /*! ./data */ 20);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _type = __webpack_require__( /*! ./type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ensureDefined = function(value, defaultValue) {
            return (0, _type.isDefined)(value) ? value : defaultValue
        };
        exports.ensureDefined = ensureDefined;
        var executeAsync = function(action, context) {
            var deferred = new _deferred.Deferred;
            var normalizedContext = context || this;
            var task = {
                promise: deferred.promise(),
                abort: function() {
                    clearTimeout(timerId);
                    deferred.rejectWith(normalizedContext)
                }
            };
            var callback = function() {
                var result = action.call(normalizedContext);
                if (result && result.done && (0, _type.isFunction)(result.done)) {
                    result.done(function() {
                        deferred.resolveWith(normalizedContext)
                    })
                } else {
                    deferred.resolveWith(normalizedContext)
                }
            };
            var timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        exports.executeAsync = executeAsync;
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new _deferred.Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName;
                var currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result || (0, _deferred.when)()
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        exports.deferRender = deferRender;
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        exports.deferUpdate = deferUpdate;
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        exports.deferRenderer = deferRenderer;
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        exports.deferUpdater = deferUpdater;
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [];
            var maxMatchCount = 0;
            (0, _iterator.each)(items, function(index, itemSrc) {
                var matchCount = 0;
                var item = mapFn ? mapFn(itemSrc) : itemSrc;
                (0, _iterator.each)(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        exports.findBestMatches = findBestMatches;
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                (0, _iterator.each)(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            var _raw$x, _raw$y;
            switch ((0, _type.type)(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [null !== (_raw$x = raw.x) && void 0 !== _raw$x ? _raw$x : raw.h, null !== (_raw$y = raw.y) && void 0 !== _raw$y ? _raw$y : raw.v];
                case "number":
                    return [raw];
                case "array":
                    return raw;
                default:
                    return null
            }
        };
        exports.splitPair = splitPair;
        var normalizeKey = function(id) {
            var key = (0, _type.isString)(id) ? id : id.toString();
            var arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && (0, _iterator.each)(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        exports.normalizeKey = normalizeKey;
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        exports.denormalizeKey = denormalizeKey;
        var pairToObject = function(raw, preventRound) {
            var pair = splitPair(raw);
            var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
            var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        exports.pairToObject = pairToObject;
        var getKeyHash = function(key) {
            if (key instanceof _guid.default) {
                return key.toString()
            } else {
                if ((0, _type.isObject)(key) || Array.isArray(key)) {
                    try {
                        var keyHash = JSON.stringify(key);
                        return "{}" === keyHash ? key : keyHash
                    } catch (e) {
                        return key
                    }
                }
            }
            return key
        };
        exports.getKeyHash = getKeyHash;
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        exports.escapeRegExp = escapeRegExp;
        var applyServerDecimalSeparator = function(value) {
            var separator = (0, _config.default)().serverDecimalSeparator;
            if ((0, _type.isDefined)(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        var noop = function() {};
        exports.noop = noop;
        var asyncNoop = function() {
            return (new _deferred.Deferred).resolve().promise()
        };
        exports.asyncNoop = asyncNoop;
        var grep = function(elements, checkFunction, invert) {
            var result = [];
            var check;
            var expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        exports.grep = grep;
        var arraysEqualByValue = function(array1, array2, depth) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], depth + 1)) {
                    return false
                }
            }
            return true
        };
        var objectsEqualByValue = function(object1, object2, depth, strict) {
            for (var propertyName in object1) {
                if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], depth + 1, strict)) {
                    return false
                }
            }
            for (var _propertyName in object2) {
                if (!(_propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var maxEqualityDepth = 3;
        var equalByValue = function(object1, object2) {
            var depth = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0;
            var strict = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : true;
            object1 = (0, _data.toComparable)(object1, true);
            object2 = (0, _data.toComparable)(object2, true);
            var comparisonResult = strict ? object1 === object2 : object1 == object2;
            if (comparisonResult || depth >= maxEqualityDepth) {
                return true
            }
            if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                return objectsEqualByValue(object1, object2, depth, strict)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return arraysEqualByValue(object1, object2, depth)
                }
            }
            return false
        };
        exports.equalByValue = equalByValue
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/events_engine.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _event_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./event_registrator_callbacks */ 131));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/dependency_injector */ 59));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 25));
        var _weak_map = _interopRequireDefault(__webpack_require__( /*! ../../core/polyfills/weak_map */ 198));
        var _hook_touch_props = _interopRequireDefault(__webpack_require__( /*! ../../events/core/hook_touch_props */ 237));
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var window = (0, _window.getWindow)();
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focus", "load"];
        var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel", "touchstart"];

        function matchesSafe(target, selector) {
            return !(0, _type.isWindow)(target) && "#document" !== target.nodeName && _dom_adapter.default.elementMatches(target, selector)
        }
        var elementDataMap = new _weak_map.default;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            _event_registrator_callbacks.default.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var eventsEngine = (0, _dependency_injector.default)({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers((0, _extend.extend)(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || (0, _type.isWindow)(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });

        function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (_dom_adapter.default.isNode(element) || (0, _type.isWindow)(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!(0, _type.isString)(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw _errors.default.Error("E0025")
                }
            }
        }

        function getHandler(method) {
            return function() {
                applyForEach(arguments, method)
            }
        }

        function detectPassiveEventHandlersSupport() {
            var isSupported = false;
            try {
                var options = Object.defineProperty({}, "passive", {
                    get: function() {
                        isSupported = true;
                        return true
                    }
                });
                window.addEventListener("test", null, options)
            } catch (e) {}
            return isSupported
        }
        var passiveEventHandlersSupported = (0, _call_once.default)(detectPassiveEventHandlersSupport);
        var contains = function contains(container, element) {
            if ((0, _type.isWindow)(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };

        function getHandlersController(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var handlerArgs = [e];
                        var target = e.currentTarget;
                        var relatedTarget = e.relatedTarget;
                        var secondaryTargetIsInside;
                        var result;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || contains(target, relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            e.currentTarget = e.delegateTarget || e.target;
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = _dom_adapter.default.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        }

        function getNativeHandler(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        }

        function isSubset(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        }

        function normalizeOnArguments(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        }

        function normalizeOffArguments(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        }

        function normalizeTriggerArguments(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        }

        function normalizeEventArguments(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        }

        function iterate(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === _typeof(eventName)) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        }

        function callNativeMethod(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if ((0, _type.isFunction)(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        }

        function calculateWhich(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        }

        function initEvent(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        }
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            (0, _extend.extend)(that, src);
            if (src instanceof eventsEngine.Event || (0, _window.hasWindow)() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                (0, _extend.extend)(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }(0, _extend.extend)(that, config);
            that.guid = ++guid
        }));

        function addProperty(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        }(0, _hook_touch_props.default)(addProperty);
        var beforeSetStrategy = (0, _callbacks.default)();
        var afterSetStrategy = (0, _callbacks.default)();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
        eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
        var _default = eventsEngine;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/deferred.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.fromPromise = fromPromise;
        exports.setStrategy = setStrategy;
        exports.Deferred = Deferred;
        exports.when = when;
        var _type = __webpack_require__( /*! ../utils/type */ 1);
        var _extend = __webpack_require__( /*! ../utils/extend */ 0);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../utils/callbacks */ 27));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _DeferredObj = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new _callbacks.default;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _DeferredObj;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if ((0, _type.isDeferred)(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if ((0, _type.isPromise)(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, (0, _type.isDefined)(callbackResult) ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? (0, _extend.extend)(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _DeferredObj.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });

        function fromPromise(promise, context) {
            if ((0, _type.isDeferred)(promise)) {
                return promise
            } else {
                if ((0, _type.isPromise)(promise)) {
                    var d = new _DeferredObj;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _DeferredObj).resolveWith(context, [promise])
        }
        var whenFunc = function() {
            if (1 === arguments.length) {
                return fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments);
            var contexts = [];
            var resolvedCount = 0;
            var deferred = new _DeferredObj;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if ((0, _type.isDeferred)(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };

        function setStrategy(value) {
            _DeferredObj = value.Deferred;
            whenFunc = value.when
        }

        function Deferred() {
            return new _DeferredObj
        }

        function when() {
            return whenFunc.apply(this, arguments)
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/window.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getNavigator = exports.getCurrentScreenFactor = exports.defaultScreenFactorFunc = exports.hasProperty = exports.getWindow = exports.hasWindow = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var hasWindow = function() {
            return "undefined" !== typeof window
        };
        exports.hasWindow = hasWindow;
        var windowObject = hasWindow() && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        var getWindow = function() {
            return windowObject
        };
        exports.getWindow = getWindow;
        var hasProperty = function(prop) {
            return hasWindow() && prop in windowObject
        };
        exports.hasProperty = hasProperty;
        var defaultScreenFactorFunc = function(width) {
            if (width < 768) {
                return "xs"
            } else {
                if (width < 992) {
                    return "sm"
                } else {
                    if (width < 1200) {
                        return "md"
                    } else {
                        return "lg"
                    }
                }
            }
        };
        exports.defaultScreenFactorFunc = defaultScreenFactorFunc;
        var getCurrentScreenFactor = function(screenFactorCallback) {
            var screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
            var windowWidth = _dom_adapter.default.getDocumentElement().clientWidth;
            return screenFactorFunc(windowWidth)
        };
        exports.getCurrentScreenFactor = getCurrentScreenFactor;
        var getNavigator = function() {
            return hasWindow() ? windowObject.navigator : {
                userAgent: ""
            }
        };
        exports.getNavigator = getNavigator
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/events/utils/index.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.addNamespace = exports.getChar = exports.normalizeKeyName = exports.fireEvent = exports.createEvent = exports.setEventFixMethod = exports.needSkipEvent = exports.stopEventsSkipping = exports.forceSkipEvents = exports.hasTouches = exports.eventDelta = exports.eventData = exports.isFakeClickEvent = exports.isKeyboardEvent = exports.isTouchEvent = exports.isDxMouseWheelEvent = exports.isMouseEvent = exports.isPointerEvent = exports.eventSource = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _add_namespace = _interopRequireDefault(__webpack_require__( /*! ./add_namespace */ 520));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../core/events_engine */ 5));
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ../../ui/widget/selectors */ 71);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var KEY_MAP = {
            backspace: "backspace",
            tab: "tab",
            enter: "enter",
            escape: "escape",
            pageup: "pageUp",
            pagedown: "pageDown",
            end: "end",
            home: "home",
            arrowleft: "leftArrow",
            arrowup: "upArrow",
            arrowright: "rightArrow",
            arrowdown: "downArrow",
            "delete": "del",
            " ": "space",
            f: "F",
            a: "A",
            "*": "asterisk",
            "-": "minus",
            alt: "alt",
            control: "control",
            shift: "shift",
            left: "leftArrow",
            up: "upArrow",
            right: "rightArrow",
            down: "downArrow",
            multiply: "asterisk",
            spacebar: "space",
            del: "del",
            subtract: "minus",
            esc: "escape"
        };
        var LEGACY_KEY_CODES = {
            8: "backspace",
            9: "tab",
            13: "enter",
            27: "escape",
            33: "pageUp",
            34: "pageDown",
            35: "end",
            36: "home",
            37: "leftArrow",
            38: "upArrow",
            39: "rightArrow",
            40: "downArrow",
            46: "del",
            32: "space",
            70: "F",
            65: "A",
            106: "asterisk",
            109: "minus",
            189: "minus",
            173: "minus",
            16: "shift",
            17: "control",
            18: "alt"
        };
        var EVENT_SOURCES_REGEX = {
            dx: /^dx/i,
            mouse: /(mouse|wheel)/i,
            touch: /^touch/i,
            keyboard: /^key/i,
            pointer: /^(ms)?pointer/i
        };
        var fixMethod = function(e) {
            return e
        };
        var copyEvent = function(originalEvent) {
            return fixMethod(_events_engine.default.Event(originalEvent, originalEvent), originalEvent)
        };
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var eventSource = function(_ref) {
            var type = _ref.type;
            var result = "other";
            (0, _iterator.each)(EVENT_SOURCES_REGEX, function(key) {
                if (this.test(type)) {
                    result = key;
                    return false
                }
            });
            return result
        };
        exports.eventSource = eventSource;
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        exports.isPointerEvent = isPointerEvent;
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        exports.isMouseEvent = isMouseEvent;
        var isDxMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        exports.isDxMouseWheelEvent = isDxMouseWheelEvent;
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        exports.isTouchEvent = isTouchEvent;
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        exports.isKeyboardEvent = isKeyboardEvent;
        var isFakeClickEvent = function(_ref2) {
            var screenX = _ref2.screenX,
                offsetX = _ref2.offsetX,
                pageX = _ref2.pageX;
            return 0 === screenX && !offsetX && 0 === pageX
        };
        exports.isFakeClickEvent = isFakeClickEvent;
        var eventData = function(_ref3) {
            var pageX = _ref3.pageX,
                pageY = _ref3.pageY,
                timeStamp = _ref3.timeStamp;
            return {
                x: pageX,
                y: pageY,
                time: timeStamp
            }
        };
        exports.eventData = eventData;
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        exports.eventDelta = eventDelta;
        var hasTouches = function(e) {
            var originalEvent = e.originalEvent,
                pointers = e.pointers;
            if (isNativeTouchEvent(e)) {
                return (originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (pointers || []).length
            }
            return 0
        };
        exports.hasTouches = hasTouches;
        var skipEvents = false;
        var forceSkipEvents = function() {
            return skipEvents = true
        };
        exports.forceSkipEvents = forceSkipEvents;
        var stopEventsSkipping = function() {
            return skipEvents = false
        };
        exports.stopEventsSkipping = stopEventsSkipping;
        var needSkipEvent = function(e) {
            if (skipEvents) {
                return true
            }
            var target = e.target;
            var $target = (0, _renderer.default)(target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if (isDxMouseWheelEvent(e)) {
                var isTextArea = $target.is("textarea") && $target.hasClass("dx-texteditor-input");
                if (isTextArea) {
                    return false
                }
                var isContentEditable = target.isContentEditable || target.hasAttribute("contenteditable");
                if (isContentEditable) {
                    return false
                }
                var isInputFocused = $target.is("input[type='number'], textarea, select") && $target.is(":focus");
                return isInputFocused
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && (0, _selectors.focused)($target)
            }
        };
        exports.needSkipEvent = needSkipEvent;
        var setEventFixMethod = function(func) {
            return fixMethod = func
        };
        exports.setEventFixMethod = setEventFixMethod;
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            args && (0, _extend.extend)(event, args);
            return event
        };
        exports.createEvent = createEvent;
        var fireEvent = function(props) {
            var originalEvent = props.originalEvent,
                delegateTarget = props.delegateTarget;
            var event = createEvent(originalEvent, props);
            _events_engine.default.trigger(delegateTarget || event.target, event);
            return event
        };
        exports.fireEvent = fireEvent;
        var normalizeKeyName = function(_ref4) {
            var key = _ref4.key,
                which = _ref4.which;
            var isKeySupported = !!key;
            key = isKeySupported ? key : which;
            if (key) {
                if (isKeySupported) {
                    key = KEY_MAP[key.toLowerCase()] || key
                } else {
                    key = LEGACY_KEY_CODES[key] || String.fromCharCode(key)
                }
                return key
            }
        };
        exports.normalizeKeyName = normalizeKeyName;
        var getChar = function(_ref5) {
            var key = _ref5.key,
                which = _ref5.which;
            return key || String.fromCharCode(which)
        };
        exports.getChar = getChar;
        var addNamespace = _add_namespace.default;
        exports.addNamespace = addNamespace
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/component_registrator.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 2));
        var _component_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./component_registrator_callbacks */ 166));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }(0, _public_component.name)(componentClass, name);
            _component_registrator_callbacks.default.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            _renderer.default.fn[name] = function(options) {
                var isMemberInvoke = "string" === typeof options;
                var result;
                if (isMemberInvoke) {
                    var memberName = options;
                    var memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw _errors.default.Error("E0009", name)
                        }
                        var member = instance[memberName];
                        var memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        _component_registrator_callbacks.default.add(registerRendererComponent);
        var _default = registerComponent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/message.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _string = __webpack_require__( /*! ../core/utils/string */ 43);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 39);
        var _core = _interopRequireDefault(__webpack_require__( /*! ./core */ 86));
        var _default_messages = _interopRequireDefault(__webpack_require__( /*! ./default_messages */ 508));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var baseDictionary = (0, _extend.extend)(true, {}, _default_messages.default);
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var newMessages = {};
        var messageLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            _dictionary: baseDictionary,
            load: function(messages) {
                (0, _extend.extend)(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this;
                var regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g");
                var escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var defaultResult = that._localizablePrefix + localizationKey;
                    var result;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = (0, _inflector.humanize)(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            localizeNode: function(node) {
                var that = this;
                (0, _renderer.default)(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!(0, _renderer.default)(nodeItem).is("iframe")) {
                            (0, _iterator.each)(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            (0, _renderer.default)(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return (0, _extend.extend)({}, newMessages, this.getMessagesByLocales()[_core.default.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var _this = this;
                var message = _core.default.getValueByClosestLocale(function(locale) {
                    return getDataByLocale(_this._dictionary, locale)[key]
                });
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return _string.format.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        var _default = messageLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/dom_adapter.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./utils/dependency_injector */ 59));
        var _common = __webpack_require__( /*! ./utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var ELEMENT_NODE = 1;
        var TEXT_NODE = 3;
        var DOCUMENT_NODE = 9;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var _this = this;
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = _this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                };
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === _typeof(element) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            getAttribute: function(element, name) {
                return element.getAttribute(name)
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNameSupported = "string" === typeof element.className;
                        var elementClass = classNameSupported ? element.className : this.getAttribute(element, "class") || "";
                        var classNames = elementClass.split(" ");
                        var classIndex = classNames.indexOf(className);
                        var resultClassName;
                        if (isAdd && classIndex < 0) {
                            resultClassName = elementClass ? elementClass + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            resultClassName = classNames.join(" ")
                        }
                        if (void 0 !== resultClassName) {
                            if (classNameSupported) {
                                element.className = resultClassName
                            } else {
                                this.setAttribute(element, "class", resultClassName)
                            }
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return _common.noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        var _default = (0, _dependency_injector.default)(nativeDOMAdapterStrategy);
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/core/utils.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.map = map;
        exports.normalizeEnum = normalizeEnum;
        exports.setCanvasValues = setCanvasValues;
        exports.normalizeBBox = normalizeBBox;
        exports.rotateBBox = rotateBBox;
        exports.checkElementHasPropertyFromStyleSheet = checkElementHasPropertyFromStyleSheet;
        exports.convertPolarToXY = convertPolarToXY;
        exports.normalizePanesHeight = normalizePanesHeight;
        exports.updatePanesCanvases = updatePanesCanvases;
        exports.mergeMarginOptions = mergeMarginOptions;
        exports.getVizRangeObject = getVizRangeObject;
        exports.convertVisualRangeObject = convertVisualRangeObject;
        exports.getAddFunction = getAddFunction;
        exports.adjustVisualRange = adjustVisualRange;
        exports.getLogExt = getLogExt;
        exports.raiseToExt = raiseToExt;
        exports.rangesAreEqual = rangesAreEqual;
        exports.valueOf = valueOf;
        exports.pointInCanvas = pointInCanvas;
        exports.getVerticallyShiftedAngularCoords = exports.unique = exports.getCategoriesInfo = exports.processSeriesTemplate = exports.convertXYToPolar = exports.patchFontOptions = exports.enumParser = exports.parseScalar = exports.decreaseGaps = exports.getPower = exports.roundValue = exports.getAppropriateFormat = exports.getDecimalOrder = exports.getDistance = exports.getCosAndSin = exports.degreesToRadians = exports.convertAngleToRendererSpace = exports.normalizeAngle = exports.raiseTo = exports.getAdjustedLog10 = exports.getLog = exports.PANE_PADDING = void 0;
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _math = __webpack_require__( /*! ../../core/utils/math */ 29);
        var _date = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date */ 19));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _color = _interopRequireDefault(__webpack_require__( /*! ../../color */ 93));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var PI = Math.PI,
            LN10 = Math.LN10,
            abs = Math.abs,
            log = Math.log,
            floor = Math.floor,
            ceil = Math.ceil,
            pow = Math.pow,
            sqrt = Math.sqrt,
            atan2 = Math.atan2;
        var _min = Math.min;
        var _max = Math.max;
        var _cos = Math.cos;
        var _sin = Math.sin;
        var _round = Math.round;
        var dateToMilliseconds = _date.default.dateToMilliseconds;
        var MAX_PIXEL_COUNT = 1e10;
        var PI_DIV_180 = PI / 180;
        var _isNaN = isNaN;
        var _Number = Number;
        var _NaN = NaN;
        var PANE_PADDING = 10;
        exports.PANE_PADDING = PANE_PADDING;
        var getLog = function(value, base) {
            if (!value) {
                return _NaN
            }
            return log(value) / log(base)
        };
        exports.getLog = getLog;
        var getAdjustedLog10 = function(value) {
            return (0, _math.adjust)(getLog(value, 10))
        };
        exports.getAdjustedLog10 = getAdjustedLog10;
        var raiseTo = function(power, base) {
            return pow(base, power)
        };
        exports.raiseTo = raiseTo;
        var normalizeAngle = function(angle) {
            return (angle % 360 + 360) % 360
        };
        exports.normalizeAngle = normalizeAngle;
        var convertAngleToRendererSpace = function(angle) {
            return 90 - angle
        };
        exports.convertAngleToRendererSpace = convertAngleToRendererSpace;
        var degreesToRadians = function(value) {
            return PI * value / 180
        };
        exports.degreesToRadians = degreesToRadians;
        var getCosAndSin = function(angle) {
            var angleInRadians = degreesToRadians(angle);
            return {
                cos: _cos(angleInRadians),
                sin: _sin(angleInRadians)
            }
        };
        exports.getCosAndSin = getCosAndSin;
        var DECIMAL_ORDER_THRESHOLD = 1e-14;
        var getDistance = function(x1, y1, x2, y2) {
            var diffX = x2 - x1;
            var diffY = y2 - y1;
            return sqrt(diffY * diffY + diffX * diffX)
        };
        exports.getDistance = getDistance;
        var getDecimalOrder = function(number) {
            var n = abs(number);
            var cn;
            if (!_isNaN(n)) {
                if (n > 0) {
                    n = log(n) / LN10;
                    cn = ceil(n);
                    return cn - n < DECIMAL_ORDER_THRESHOLD ? cn : floor(n)
                }
                return 0
            }
            return _NaN
        };
        exports.getDecimalOrder = getDecimalOrder;
        var getAppropriateFormat = function(start, end, count) {
            var order = _max(getDecimalOrder(start), getDecimalOrder(end));
            var precision = -getDecimalOrder(abs(end - start) / count);
            var format;
            if (!_isNaN(order) && !_isNaN(precision)) {
                if (abs(order) <= 4) {
                    format = "fixedPoint";
                    precision < 0 && (precision = 0);
                    precision > 4 && (precision = 4)
                } else {
                    format = "exponential";
                    precision += order - 1;
                    precision > 3 && (precision = 3)
                }
                return {
                    type: format,
                    precision: precision
                }
            }
            return null
        };
        exports.getAppropriateFormat = getAppropriateFormat;
        var roundValue = function(value, precision) {
            if (precision > 20) {
                precision = 20
            }
            if ((0, _type.isNumeric)(value)) {
                if ((0, _type.isExponential)(value)) {
                    return _Number(value.toExponential(precision))
                } else {
                    return _Number(value.toFixed(precision))
                }
            }
        };
        exports.roundValue = roundValue;
        var getPower = function(value) {
            return value.toExponential().split("e")[1]
        };
        exports.getPower = getPower;

        function map(array, callback) {
            var i = 0;
            var len = array.length;
            var result = [];
            var value;
            while (i < len) {
                value = callback(array[i], i);
                if (null !== value) {
                    result.push(value)
                }
                i++
            }
            return result
        }

        function selectByKeys(object, keys) {
            return map(keys, function(key) {
                return object[key] ? object[key] : null
            })
        }

        function decreaseFields(object, keys, eachDecrease, decrease) {
            var dec = decrease;
            (0, _iterator.each)(keys, function(_, key) {
                if (object[key]) {
                    object[key] -= eachDecrease;
                    dec -= eachDecrease
                }
            });
            return dec
        }

        function normalizeEnum(value) {
            return String(value).toLowerCase()
        }

        function setCanvasValues(canvas) {
            if (canvas) {
                canvas.originalTop = canvas.top;
                canvas.originalBottom = canvas.bottom;
                canvas.originalLeft = canvas.left;
                canvas.originalRight = canvas.right
            }
            return canvas
        }

        function normalizeBBoxField(value) {
            return -MAX_PIXEL_COUNT < value && value < +MAX_PIXEL_COUNT ? value : 0
        }

        function normalizeBBox(bBox) {
            var xl = normalizeBBoxField(floor(bBox.x));
            var yt = normalizeBBoxField(floor(bBox.y));
            var xr = normalizeBBoxField(ceil(bBox.width + bBox.x));
            var yb = normalizeBBoxField(ceil(bBox.height + bBox.y));
            var result = {
                x: xl,
                y: yt,
                width: xr - xl,
                height: yb - yt
            };
            result.isEmpty = !result.x && !result.y && !result.width && !result.height;
            return result
        }

        function rotateBBox(bBox, center, angle) {
            var cos = _Number(_cos(angle * PI_DIV_180).toFixed(3));
            var sin = _Number(_sin(angle * PI_DIV_180).toFixed(3));
            var w2 = bBox.width / 2;
            var h2 = bBox.height / 2;
            var centerX = bBox.x + w2;
            var centerY = bBox.y + h2;
            var w2_ = abs(w2 * cos) + abs(h2 * sin);
            var h2_ = abs(w2 * sin) + abs(h2 * cos);
            var centerX_ = center[0] + (centerX - center[0]) * cos + (centerY - center[1]) * sin;
            var centerY_ = center[1] - (centerX - center[0]) * sin + (centerY - center[1]) * cos;
            return normalizeBBox({
                x: centerX_ - w2_,
                y: centerY_ - h2_,
                width: 2 * w2_,
                height: 2 * h2_
            })
        }
        var decreaseGaps = function(object, keys, decrease) {
            var arrayGaps;
            do {
                arrayGaps = selectByKeys(object, keys);
                arrayGaps.push(ceil(decrease / arrayGaps.length));
                decrease = decreaseFields(object, keys, _min.apply(null, arrayGaps), decrease)
            } while (decrease > 0 && arrayGaps.length > 1);
            return decrease
        };
        exports.decreaseGaps = decreaseGaps;
        var parseScalar = function(value, defaultValue) {
            return void 0 !== value ? value : defaultValue
        };
        exports.parseScalar = parseScalar;
        var enumParser = function(values) {
            var stored = {};
            var i;
            var ii;
            for (i = 0, ii = values.length; i < ii; ++i) {
                stored[normalizeEnum(values[i])] = 1
            }
            return function(value, defaultValue) {
                var _value = normalizeEnum(value);
                return stored[_value] ? _value : defaultValue
            }
        };
        exports.enumParser = enumParser;
        var patchFontOptions = function(options) {
            var fontOptions = {};
            (0, _iterator.each)(options || {}, function(key, value) {
                if (/^(cursor)$/i.test(key)) {} else {
                    if ("opacity" === key) {
                        value = null
                    } else {
                        if ("color" === key) {
                            key = "fill";
                            if ("opacity" in options) {
                                var color = new _color.default(value);
                                value = "rgba(".concat(color.r, ",").concat(color.g, ",").concat(color.b, ",").concat(options.opacity, ")")
                            }
                        } else {
                            key = "font-" + key
                        }
                    }
                }
                fontOptions[key] = value
            });
            return fontOptions
        };
        exports.patchFontOptions = patchFontOptions;

        function checkElementHasPropertyFromStyleSheet(element, property) {
            var slice = Array.prototype.slice;
            var cssRules = slice.call(_dom_adapter.default.getDocument().styleSheets).reduce(function(rules, styleSheet) {
                return rules.concat(slice.call(styleSheet.cssRules || styleSheet.rules))
            }, []);
            var elementRules = cssRules.filter(function(rule) {
                try {
                    return _dom_adapter.default.elementMatches(element, rule.selectorText)
                } catch (e) {
                    return false
                }
            });
            return elementRules.some(function(rule) {
                return !!rule.style[property]
            })
        }

        function convertPolarToXY(centerCoords, startAngle, angle, radius) {
            var shiftAngle = 90;
            var normalizedRadius = radius > 0 ? radius : 0;
            angle = (0, _type.isDefined)(angle) ? angle + startAngle - shiftAngle : 0;
            var cosSin = getCosAndSin(angle);
            return {
                x: _round(centerCoords.x + normalizedRadius * cosSin.cos),
                y: _round(centerCoords.y + normalizedRadius * cosSin.sin)
            }
        }
        var convertXYToPolar = function(centerCoords, x, y) {
            var radius = getDistance(centerCoords.x, centerCoords.y, x, y);
            var angle = atan2(y - centerCoords.y, x - centerCoords.x);
            return {
                phi: _round(normalizeAngle(180 * angle / PI)),
                r: _round(radius)
            }
        };
        exports.convertXYToPolar = convertXYToPolar;
        var processSeriesTemplate = function(seriesTemplate, items) {
            var customizeSeries = (0, _type.isFunction)(seriesTemplate.customizeSeries) ? seriesTemplate.customizeSeries : _common.noop;
            var nameField = seriesTemplate.nameField;
            var generatedSeries = {};
            var seriesOrder = [];
            var series;
            var i = 0;
            var length;
            var data;
            items = items || [];
            for (length = items.length; i < length; i++) {
                data = items[i];
                if (nameField in data) {
                    series = generatedSeries[data[nameField]];
                    if (!series) {
                        series = generatedSeries[data[nameField]] = {
                            name: data[nameField],
                            nameFieldValue: data[nameField]
                        };
                        seriesOrder.push(series.name)
                    }
                }
            }
            return map(seriesOrder, function(orderedName) {
                var group = generatedSeries[orderedName];
                return (0, _extend.extend)(group, customizeSeries.call(null, group.name))
            })
        };
        exports.processSeriesTemplate = processSeriesTemplate;
        var getCategoriesInfo = function(categories, startValue, endValue) {
            if (0 === categories.length) {
                return {
                    categories: []
                }
            }
            startValue = (0, _type.isDefined)(startValue) ? startValue : categories[0];
            endValue = (0, _type.isDefined)(endValue) ? endValue : categories[categories.length - 1];
            var categoriesValue = map(categories, function(category) {
                return null === category || void 0 === category ? void 0 : category.valueOf()
            });
            var indexStartValue = categoriesValue.indexOf(startValue.valueOf());
            var indexEndValue = categoriesValue.indexOf(endValue.valueOf());
            var swapBuf;
            var inverted = false;
            indexStartValue < 0 && (indexStartValue = 0);
            indexEndValue < 0 && (indexEndValue = categories.length - 1);
            if (indexEndValue < indexStartValue) {
                swapBuf = indexEndValue;
                indexEndValue = indexStartValue;
                indexStartValue = swapBuf;
                inverted = true
            }
            var visibleCategories = categories.slice(indexStartValue, indexEndValue + 1);
            var lastIdx = visibleCategories.length - 1;
            return {
                categories: visibleCategories,
                start: visibleCategories[inverted ? lastIdx : 0],
                end: visibleCategories[inverted ? 0 : lastIdx],
                inverted: inverted
            }
        };
        exports.getCategoriesInfo = getCategoriesInfo;

        function normalizePanesHeight(panes) {
            panes.forEach(function(pane) {
                var height = pane.height;
                var unit = 0;
                var parsedHeight = parseFloat(height) || void 0;
                if ((0, _type.isString)(height) && height.indexOf("px") > -1 || (0, _type.isNumeric)(height) && height > 1) {
                    parsedHeight = _round(parsedHeight);
                    unit = 1
                }
                if (!unit && parsedHeight) {
                    if ((0, _type.isString)(height) && height.indexOf("%") > -1) {
                        parsedHeight /= 100
                    } else {
                        if (parsedHeight < 0) {
                            parsedHeight = parsedHeight < -1 ? 1 : abs(parsedHeight)
                        }
                    }
                }
                pane.height = parsedHeight;
                pane.unit = unit
            });
            var weightSum = panes.filter(function(pane) {
                return !pane.unit
            }).reduce(function(prev, next) {
                return prev + (next.height || 0)
            }, 0);
            var weightHeightCount = panes.filter(function(pane) {
                return !pane.unit
            }).length;
            var emptyHeightCount = panes.filter(function(pane) {
                return !pane.unit && !pane.height
            }).length;
            if (weightSum < 1 && emptyHeightCount) {
                panes.filter(function(pane) {
                    return !pane.unit && !pane.height
                }).forEach(function(pane) {
                    return pane.height = (1 - weightSum) / emptyHeightCount
                })
            } else {
                if (weightSum > 1 || weightSum < 1 && !emptyHeightCount || 1 === weightSum && emptyHeightCount) {
                    if (emptyHeightCount) {
                        var weightForEmpty = weightSum / weightHeightCount;
                        var emptyWeightSum = emptyHeightCount * weightForEmpty;
                        panes.filter(function(pane) {
                            return !pane.unit && pane.height
                        }).forEach(function(pane) {
                            return pane.height *= (weightSum - emptyWeightSum) / weightSum
                        });
                        panes.filter(function(pane) {
                            return !pane.unit && !pane.height
                        }).forEach(function(pane) {
                            return pane.height = weightForEmpty
                        })
                    }
                    panes.forEach(function(pane) {
                        return !pane.unit && (pane.height *= 1 / weightSum)
                    })
                }
            }
        }

        function updatePanesCanvases(panes, canvas, rotated) {
            var distributedSpace = 0;
            var padding = PANE_PADDING;
            var paneSpace = rotated ? canvas.width - canvas.left - canvas.right : canvas.height - canvas.top - canvas.bottom;
            var usefulSpace = paneSpace - padding * (panes.length - 1);
            var startName = rotated ? "left" : "top";
            var endName = rotated ? "right" : "bottom";
            var totalCustomSpace = panes.reduce(function(prev, cur) {
                return prev + (cur.unit ? cur.height : 0)
            }, 0);
            usefulSpace -= totalCustomSpace;
            panes.forEach(function(pane) {
                var calcLength = pane.unit ? pane.height : _round(pane.height * usefulSpace);
                pane.canvas = pane.canvas || {};
                (0, _extend.extend)(pane.canvas, canvas);
                pane.canvas[startName] = canvas[startName] + distributedSpace;
                pane.canvas[endName] = canvas[endName] + (paneSpace - calcLength - distributedSpace);
                distributedSpace = distributedSpace + calcLength + padding;
                setCanvasValues(pane.canvas)
            })
        }
        var unique = function(array) {
            var values = {};
            return map(array, function(item) {
                var result = !values[item] ? item : null;
                values[item] = true;
                return result
            })
        };
        exports.unique = unique;
        var getVerticallyShiftedAngularCoords = function(bBox, dy, center) {
            var isPositive = bBox.x + bBox.width / 2 >= center.x;
            var horizontalOffset1 = (isPositive ? bBox.x : bBox.x + bBox.width) - center.x;
            var verticalOffset1 = bBox.y - center.y;
            var verticalOffset2 = verticalOffset1 + dy;
            var horizontalOffset2 = _round(sqrt(horizontalOffset1 * horizontalOffset1 + verticalOffset1 * verticalOffset1 - verticalOffset2 * verticalOffset2));
            var dx = (isPositive ? +horizontalOffset2 : -horizontalOffset2) || horizontalOffset1;
            return {
                x: center.x + (isPositive ? dx : dx - bBox.width),
                y: bBox.y + dy
            }
        };
        exports.getVerticallyShiftedAngularCoords = getVerticallyShiftedAngularCoords;

        function mergeMarginOptions(opt1, opt2) {
            return {
                checkInterval: opt1.checkInterval || opt2.checkInterval,
                size: _max(opt1.size || 0, opt2.size || 0),
                percentStick: opt1.percentStick || opt2.percentStick,
                sizePointNormalState: _max(opt1.sizePointNormalState || 0, opt2.sizePointNormalState || 0)
            }
        }

        function getVizRangeObject(value) {
            if (Array.isArray(value)) {
                return {
                    startValue: value[0],
                    endValue: value[1]
                }
            } else {
                return value || {}
            }
        }

        function convertVisualRangeObject(visualRange, convertToVisualRange) {
            if (convertToVisualRange) {
                return visualRange
            }
            return [visualRange.startValue, visualRange.endValue]
        }

        function getAddFunction(range, correctZeroLevel) {
            if ("datetime" === range.dataType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    return new Date(rangeValue.getTime() + sign * marginValue)
                }
            }
            if ("logarithmic" === range.axisType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    var log = getLogExt(rangeValue, range.base) + sign * marginValue;
                    return raiseToExt(log, range.base)
                }
            }
            return function(rangeValue, marginValue) {
                var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                var newValue = rangeValue + sign * marginValue;
                return correctZeroLevel && newValue * rangeValue <= 0 ? 0 : newValue
            }
        }

        function adjustVisualRange(options, visualRange, wholeRange, dataRange) {
            var minDefined = (0, _type.isDefined)(visualRange.startValue);
            var maxDefined = (0, _type.isDefined)(visualRange.endValue);
            var nonDiscrete = "discrete" !== options.axisType;
            dataRange = dataRange || wholeRange;
            var add = getAddFunction(options, false);
            var min = minDefined ? visualRange.startValue : dataRange.min;
            var max = maxDefined ? visualRange.endValue : dataRange.max;
            var rangeLength = visualRange.length;
            var categories = dataRange.categories;
            if (nonDiscrete && !(0, _type.isDefined)(min) && !(0, _type.isDefined)(max)) {
                return {
                    startValue: min,
                    endValue: max
                }
            }
            if ((0, _type.isDefined)(rangeLength)) {
                if (nonDiscrete) {
                    if ("datetime" === options.dataType && !(0, _type.isNumeric)(rangeLength)) {
                        rangeLength = dateToMilliseconds(rangeLength)
                    }
                    if (maxDefined && !minDefined || !maxDefined && !minDefined) {
                        (0, _type.isDefined)(wholeRange.max) && (max = max > wholeRange.max ? wholeRange.max : max);
                        min = add(max, rangeLength, -1)
                    } else {
                        if (minDefined && !maxDefined) {
                            (0, _type.isDefined)(wholeRange.min) && (min = min < wholeRange.min ? wholeRange.min : min);
                            max = add(min, rangeLength)
                        }
                    }
                } else {
                    rangeLength = parseInt(rangeLength);
                    if (!isNaN(rangeLength) && isFinite(rangeLength)) {
                        rangeLength--;
                        if (!maxDefined && !minDefined) {
                            max = categories[categories.length - 1];
                            min = categories[categories.length - 1 - rangeLength]
                        } else {
                            if (minDefined && !maxDefined) {
                                var categoriesInfo = getCategoriesInfo(categories, min, void 0);
                                max = categoriesInfo.categories[rangeLength]
                            } else {
                                if (!minDefined && maxDefined) {
                                    var _categoriesInfo = getCategoriesInfo(categories, void 0, max);
                                    min = _categoriesInfo.categories[_categoriesInfo.categories.length - 1 - rangeLength]
                                }
                            }
                        }
                    }
                }
            }
            if (nonDiscrete) {
                if ((0, _type.isDefined)(wholeRange.max) && max > wholeRange.max) {
                    max = wholeRange.max
                }
                if ((0, _type.isDefined)(wholeRange.min) && min < wholeRange.min) {
                    min = wholeRange.min
                }
            }
            return {
                startValue: min,
                endValue: max
            }
        }

        function getLogExt(value, base) {
            var allowNegatives = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : false;
            var linearThreshold = arguments.length > 3 ? arguments[3] : void 0;
            if (!allowNegatives) {
                return getLog(value, base)
            }
            if (0 === value) {
                return 0
            }
            var transformValue = getLog(abs(value), base) - (linearThreshold - 1);
            if (transformValue < 0) {
                return 0
            }
            return (0, _math.adjust)((0, _math.sign)(value) * transformValue, Number(pow(base, linearThreshold - 1).toFixed(abs(linearThreshold))))
        }

        function raiseToExt(value, base) {
            var allowNegatives = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : false;
            var linearThreshold = arguments.length > 3 ? arguments[3] : void 0;
            if (!allowNegatives) {
                return raiseTo(value, base)
            }
            if (0 === value) {
                return 0
            }
            var transformValue = raiseTo(abs(value) + (linearThreshold - 1), base);
            if (transformValue < 0) {
                return 0
            }
            return (0, _math.adjust)((0, _math.sign)(value) * transformValue, Number(pow(base, linearThreshold).toFixed(abs(linearThreshold))))
        }

        function rangesAreEqual(range, rangeFromOptions) {
            if (Array.isArray(rangeFromOptions)) {
                return range.length === rangeFromOptions.length && range.every(function(item, i) {
                    return valueOf(item) === valueOf(rangeFromOptions[i])
                })
            } else {
                return valueOf(range.startValue) === valueOf(rangeFromOptions.startValue) && valueOf(range.endValue) === valueOf(rangeFromOptions.endValue)
            }
        }

        function valueOf(value) {
            return value && value.valueOf()
        }

        function pointInCanvas(canvas, x, y) {
            return x >= canvas.left && x <= canvas.right && y >= canvas.top && y <= canvas.bottom
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/array.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.groupBy = exports.find = exports.merge = exports.normalizeIndexes = exports.removeDuplicates = exports.intersection = exports.inArray = exports.wrapToArray = exports.isEmpty = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _object = __webpack_require__( /*! ./object */ 50);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function ownKeys(object, enumerableOnly) {
            var keys = Object.keys(object);
            if (Object.getOwnPropertySymbols) {
                var symbols = Object.getOwnPropertySymbols(object);
                if (enumerableOnly) {
                    symbols = symbols.filter(function(sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable
                    })
                }
                keys.push.apply(keys, symbols)
            }
            return keys
        }

        function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = null != arguments[i] ? arguments[i] : {};
                if (i % 2) {
                    ownKeys(Object(source), true).forEach(function(key) {
                        _defineProperty(target, key, source[key])
                    })
                } else {
                    if (Object.getOwnPropertyDescriptors) {
                        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                    } else {
                        ownKeys(Object(source)).forEach(function(key) {
                            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key))
                        })
                    }
                }
            }
            return target
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        exports.isEmpty = isEmpty;
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        exports.wrapToArray = wrapToArray;
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        exports.inArray = inArray;
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            (0, _iterator.each)(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        exports.intersection = intersection;
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            (0, _iterator.each)(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        exports.removeDuplicates = removeDuplicates;
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {};
            var parameterIndex = 0;
            var useLegacyVisibleIndex = (0, _config.default)().useLegacyVisibleIndex;
            (0, _iterator.each)(items, function(index, item) {
                index = item[indexParameterName];
                if (index >= 0) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                } else {
                    item[indexParameterName] = void 0
                }
            });
            if (!useLegacyVisibleIndex) {
                (0, _iterator.each)(items, function() {
                    if (!(0, _type.isDefined)(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        while (indexedItems[parameterIndex]) {
                            parameterIndex++
                        }
                        indexedItems[parameterIndex] = [this];
                        parameterIndex++
                    }
                })
            }
            parameterIndex = 0;
            (0, _object.orderEach)(indexedItems, function(index, items) {
                (0, _iterator.each)(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            if (useLegacyVisibleIndex) {
                (0, _iterator.each)(items, function() {
                    if (!(0, _type.isDefined)(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            }
            return parameterIndex
        };
        exports.normalizeIndexes = normalizeIndexes;
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        exports.merge = merge;
        var find = function(array, condition) {
            for (var i = 0; i < array.length; i++) {
                if (condition(array[i])) {
                    return array[i]
                }
            }
        };
        exports.find = find;
        var groupBy = function(array, cb) {
            return array.reduce(function(result, item) {
                return _objectSpread(_objectSpread({}, result), {}, _defineProperty({}, cb(item), [].concat(_toConsumableArray(result[cb(item)] || []), [item])))
            }, {})
        };
        exports.groupBy = groupBy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/core/devices.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/ready_callbacks */ 49));
        var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/resize_callbacks */ 125));
        var _events_strategy = __webpack_require__( /*! ./events_strategy */ 98);
        var _storage = __webpack_require__( /*! ./utils/storage */ 323);
        var _view_port = __webpack_require__( /*! ./utils/view_port */ 81);
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var navigator = (0, _window.getNavigator)();
        var window = (0, _window.getWindow)();
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            generic: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/);
                var isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent);
                var isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                var isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                if (!(isPhone || isTablet || isDesktop || isMac)) {
                    return
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "generic",
                    version: [],
                    grade: "A",
                    mac: isMac
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent);
                var matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [];
                var isIPhone4 = 480 === window.screen.height;
                var grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent);
                var matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [];
                var worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4);
                var grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = function() {
            function Devices(options) {
                _classCallCheck(this, Devices);
                this._window = (null === options || void 0 === options ? void 0 : options.window) || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                this.changed = (0, _callbacks.default)();
                if ((0, _window.hasWindow)()) {
                    _ready_callbacks.default.add(this._recalculateOrientation.bind(this));
                    _resize_callbacks.default.add(this._recalculateOrientation.bind(this))
                }
            }
            _createClass(Devices, [{
                key: "current",
                value: function(deviceOrName) {
                    if (deviceOrName) {
                        this._currentDevice = this._getDevice(deviceOrName);
                        this._forced = true;
                        this.changed.fire();
                        return
                    }
                    if (!this._currentDevice) {
                        deviceOrName = void 0;
                        try {
                            deviceOrName = this._getDeviceOrNameFromWindowScope()
                        } catch (e) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        } finally {
                            if (!deviceOrName) {
                                deviceOrName = this._getDeviceNameFromSessionStorage()
                            }
                            if (deviceOrName) {
                                this._forced = true
                            }
                        }
                        this._currentDevice = this._getDevice(deviceOrName)
                    }
                    return this._currentDevice
                }
            }, {
                key: "real",
                value: function(forceDevice) {
                    return (0, _extend.extend)({}, this._realDevice)
                }
            }, {
                key: "orientation",
                value: function() {
                    return this._currentOrientation
                }
            }, {
                key: "isForced",
                value: function() {
                    return this._forced
                }
            }, {
                key: "isRippleEmulator",
                value: function() {
                    return !!this._window.tinyHippos
                }
            }, {
                key: "_getCssClasses",
                value: function(device) {
                    var result = [];
                    var realDevice = this._realDevice;
                    device = device || this.current();
                    if (device.deviceType) {
                        result.push("dx-device-".concat(device.deviceType));
                        if ("desktop" !== device.deviceType) {
                            result.push("dx-device-mobile")
                        }
                    }
                    result.push("dx-device-".concat(realDevice.platform));
                    if (realDevice.version && realDevice.version.length) {
                        result.push("dx-device-".concat(realDevice.platform, "-").concat(realDevice.version[0]))
                    }
                    if (this.isSimulator()) {
                        result.push("dx-simulator")
                    }
                    if ((0, _config.default)().rtlEnabled) {
                        result.push("dx-rtl")
                    }
                    return result
                }
            }, {
                key: "attachCssClasses",
                value: function(element, device) {
                    this._deviceClasses = this._getCssClasses(device).join(" ");
                    (0, _renderer.default)(element).addClass(this._deviceClasses)
                }
            }, {
                key: "detachCssClasses",
                value: function(element) {
                    (0, _renderer.default)(element).removeClass(this._deviceClasses)
                }
            }, {
                key: "isSimulator",
                value: function() {
                    try {
                        return this._isSimulator || (0, _window.hasWindow)() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                    } catch (e) {
                        return false
                    }
                }
            }, {
                key: "forceSimulator",
                value: function() {
                    this._isSimulator = true
                }
            }, {
                key: "_getDevice",
                value: function(deviceName) {
                    if ("genericPhone" === deviceName) {
                        deviceName = {
                            deviceType: "phone",
                            platform: "generic",
                            generic: true
                        }
                    }
                    if ((0, _type.isPlainObject)(deviceName)) {
                        return this._fromConfig(deviceName)
                    } else {
                        var ua;
                        if (deviceName) {
                            ua = KNOWN_UA_TABLE[deviceName];
                            if (!ua) {
                                throw _errors.default.Error("E0005")
                            }
                        } else {
                            ua = navigator.userAgent
                        }
                        return this._fromUA(ua)
                    }
                }
            }, {
                key: "_getDeviceOrNameFromWindowScope",
                value: function() {
                    var result;
                    if ((0, _window.hasWindow)() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                        result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                    }
                    return result
                }
            }, {
                key: "_getDeviceNameFromSessionStorage",
                value: function() {
                    var sessionStorage = (0, _storage.sessionStorage)();
                    if (!sessionStorage) {
                        return
                    }
                    var deviceOrName = sessionStorage.getItem("dx-force-device");
                    try {
                        return JSON.parse(deviceOrName)
                    } catch (ex) {
                        return deviceOrName
                    }
                }
            }, {
                key: "_fromConfig",
                value: function(config) {
                    var result = (0, _extend.extend)({}, DEFAULT_DEVICE, this._currentDevice, config);
                    var shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        generic: "generic" === result.platform
                    };
                    return (0, _extend.extend)(result, shortcuts)
                }
            }, {
                key: "_fromUA",
                value: function(ua) {
                    var config;
                    (0, _iterator.each)(uaParsers, function(platform, parser) {
                        config = parser(ua);
                        return !config
                    });
                    if (config) {
                        return this._fromConfig(config)
                    }
                    return DEFAULT_DEVICE
                }
            }, {
                key: "_changeOrientation",
                value: function() {
                    var $window = (0, _renderer.default)(this._window);
                    var orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                    if (this._currentOrientation === orientation) {
                        return
                    }
                    this._currentOrientation = orientation;
                    this._eventsStrategy.fireEvent("orientationChanged", [{
                        orientation: orientation
                    }])
                }
            }, {
                key: "_recalculateOrientation",
                value: function() {
                    var windowWidth = (0, _renderer.default)(this._window).width();
                    if (this._currentWidth === windowWidth) {
                        return
                    }
                    this._currentWidth = windowWidth;
                    this._changeOrientation()
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.on(eventName, eventHandler);
                    return this
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.off(eventName, eventHandler);
                    return this
                }
            }]);
            return Devices
        }();
        var devices = new Devices;
        _view_port.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        var _default = devices;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/core/class.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _type = __webpack_require__( /*! ./utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var that = this;
            var overridden;
            var memberName;
            var member;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var classObj = this;
            var argument;
            var name;
            var i;
            var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
            var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
            if (isES6Class) {
                classObj._includedCtors = classObj._includedCtors.slice(0);
                classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
            }
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            var hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
            var isES6Class = !hasParentProperty && this.parent;
            if (isES6Class) {
                var baseClass = Object.getPrototypeOf(this);
                return baseClass === parentClass || baseClass.subclassOf(parentClass)
            } else {
                if (this.parent === parentClass) {
                    return true
                }
                if (!this.parent || !this.parent.subclassOf) {
                    return false
                }
                return this.parent.subclassOf(parentClass)
            }
        };
        var abstract = function() {
            throw _errors.default.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || (0, _type.isWindow)(this) || "function" !== typeof this.constructor) {
                    throw _errors.default.Error("E0003")
                }
                var instance = this;
                var ctor = instance.ctor;
                var includedCtors = instance.constructor._includedCtors;
                var includedPostCtors = instance.constructor._includedPostCtors;
                var i;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        var _default = classImpl;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/ui.widget.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _action = _interopRequireDefault(__webpack_require__( /*! ../../core/action */ 110));
        var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_component */ 68));
        var _short = __webpack_require__( /*! ../../events/short */ 128);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ./selectors */ 71);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        __webpack_require__( /*! ../../events/click */ 21);
        __webpack_require__( /*! ../../events/core/emitter.feedback */ 147);
        __webpack_require__( /*! ../../events/hover */ 153);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }

        function setAttribute(name, value, target) {
            name = "role" === name || "id" === name ? name : "aria-".concat(name);
            value = (0, _type.isDefined)(value) ? value.toString() : null;
            target.attr(name, value)
        }
        var Widget = _dom_component.default.inherit({
            _feedbackHideTimeout: 400,
            _feedbackShowTimeout: 30,
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return (0, _extend2.extend)(this.callBase(), {
                    hoveredElement: null,
                    isActive: false,
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    onKeyboardHandled: null,
                    ignoreParentReadOnly: false
                })
            },
            _init: function() {
                this.callBase();
                this._initContentReadyAction()
            },
            _innerWidgetOptionChanged: function(innerWidget, args) {
                var options = Widget.getOptionsFromContainer(args);
                innerWidget && innerWidget.option(options);
                this._options.cache(args.name, options)
            },
            _bindInnerWidgetOptions: function(innerWidget, optionsContainer) {
                var _this = this;
                var syncOptions = function() {
                    return _this._options.silent(optionsContainer, (0, _extend2.extend)({}, innerWidget.option()))
                };
                syncOptions();
                innerWidget.on("optionChanged", syncOptions)
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                var _this$option = this.option(),
                    disabled = _this$option.disabled,
                    visible = _this$option.visible;
                this.$element().addClass("dx-widget");
                this._toggleDisabledState(disabled);
                this._toggleVisibility(visible);
                this._renderHint();
                this._isFocusable() && this._renderFocusTarget();
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents();
                this._toggleIndependentState()
            },
            _renderHint: function() {
                var _this$option2 = this.option(),
                    hint = _this$option2.hint;
                this.$element().attr("title", hint || null)
            },
            _renderContent: function() {
                var _this2 = this;
                (0, _common.deferRender)(function() {
                    return !_this2._disposed ? _this2._renderContentImpl() : void 0
                }).done(function() {
                    return !_this2._disposed ? _this2._fireContentReadyAction() : void 0
                })
            },
            _renderContentImpl: _common.noop,
            _fireContentReadyAction: (0, _common.deferRenderer)(function() {
                return this._contentReadyAction()
            }),
            _dispose: function() {
                this._contentReadyAction = null;
                this._detachKeyboardEvents();
                this.callBase()
            },
            _resetActiveState: function() {
                this._toggleActiveState(this._eventBindingTarget(), false)
            },
            _clean: function() {
                this._cleanFocusState();
                this._resetActiveState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass("dx-state-invisible", !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (this._isFocusable()) {
                    this._renderFocusTarget();
                    this._attachFocusEvents();
                    this._renderAccessKey()
                }
            },
            _renderAccessKey: function() {
                var _this3 = this;
                var $el = this._focusTarget();
                var _this$option3 = this.option(),
                    accessKey = _this$option3.accessKey;
                var namespace = "UIFeedback";
                $el.attr("accesskey", accessKey);
                _short.dxClick.off($el, {
                    namespace: namespace
                });
                accessKey && _short.dxClick.on($el, function(e) {
                    if ((0, _index.isFakeClickEvent)(e)) {
                        e.stopImmediatePropagation();
                        _this3.focus()
                    }
                }, {
                    namespace: namespace
                })
            },
            _isFocusable: function() {
                var _this$option4 = this.option(),
                    focusStateEnabled = _this$option4.focusStateEnabled,
                    disabled = _this$option4.disabled;
                return focusStateEnabled && !disabled
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    return activeElement.find(this._activeStateUnit).not(".dx-state-disabled")
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                var _this$option5 = this.option(),
                    tabIndex = _this$option5.tabIndex;
                this._focusTarget().attr("tabIndex", tabIndex)
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusEventTarget: function() {
                return this._focusTarget()
            },
            _focusInHandler: function(event) {
                var _this4 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusIn", {
                        beforeExecute: function() {
                            return _this4._updateFocusState(event, true)
                        },
                        excludeValidators: ["readOnly"]
                    })({
                        event: event
                    })
                }
            },
            _focusOutHandler: function(event) {
                var _this5 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusOut", {
                        beforeExecute: function() {
                            return _this5._updateFocusState(event, false)
                        },
                        excludeValidators: ["readOnly", "disabled"]
                    })({
                        event: event
                    })
                }
            },
            _updateFocusState: function(_ref, isFocused) {
                var target = _ref.target;
                if ((0, _array.inArray)(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, (0, _renderer.default)(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass("dx-state-focused", isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = (0, _renderer.default)(element || this._focusTarget());
                return $focusTarget.hasClass("dx-state-focused")
            },
            _isFocused: function() {
                return this._hasFocusClass()
            },
            _getKeyboardListeners: function() {
                return []
            },
            _attachKeyboardEvents: function() {
                var _this6 = this;
                this._detachKeyboardEvents();
                var _this$option6 = this.option(),
                    focusStateEnabled = _this$option6.focusStateEnabled,
                    onKeyboardHandled = _this$option6.onKeyboardHandled;
                var hasChildListeners = this._getKeyboardListeners().length;
                var hasKeyboardEventHandler = !!onKeyboardHandled;
                var shouldAttach = focusStateEnabled || hasChildListeners || hasKeyboardEventHandler;
                if (shouldAttach) {
                    this._keyboardListenerId = _short.keyboard.on(this._keyboardEventBindingTarget(), this._focusTarget(), function(opts) {
                        return _this6._keyboardHandler(opts)
                    })
                }
            },
            _keyboardHandler: function(options, onlyChildProcessing) {
                if (!onlyChildProcessing) {
                    var originalEvent = options.originalEvent,
                        keyName = options.keyName,
                        which = options.which;
                    var keys = this._supportedKeys(originalEvent);
                    var func = keys[keyName] || keys[which];
                    if (void 0 !== func) {
                        var handler = func.bind(this);
                        var result = handler(originalEvent, options);
                        if (!result) {
                            return false
                        }
                    }
                }
                var keyboardListeners = this._getKeyboardListeners();
                var _this$option7 = this.option(),
                    onKeyboardHandled = _this$option7.onKeyboardHandled;
                keyboardListeners.forEach(function(listener) {
                    return listener && listener._keyboardHandler(options)
                });
                onKeyboardHandled && onKeyboardHandled(options);
                return true
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                $element.removeAttr("tabIndex");
                this._toggleFocusClass(false);
                this._detachFocusEvents();
                this._detachKeyboardEvents()
            },
            _detachKeyboardEvents: function() {
                _short.keyboard.off(this._keyboardListenerId);
                this._keyboardListenerId = null
            },
            _attachHoverEvents: function() {
                var _this7 = this;
                var _this$option8 = this.option(),
                    hoverStateEnabled = _this$option8.hoverStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.hover.off($el, {
                    selector: selector,
                    namespace: namespace
                });
                if (hoverStateEnabled) {
                    _short.hover.on($el, new _action.default(function(_ref2) {
                        var event = _ref2.event,
                            element = _ref2.element;
                        _this7._hoverStartHandler(event);
                        _this7.option("hoveredElement", (0, _renderer.default)(element))
                    }, {
                        excludeValidators: ["readOnly"]
                    }), function(event) {
                        _this7.option("hoveredElement", null);
                        _this7._hoverEndHandler(event)
                    }, {
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _attachFeedbackEvents: function() {
                var _this8 = this;
                var _this$option9 = this.option(),
                    activeStateEnabled = _this$option9.activeStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.active.off($el, {
                    namespace: namespace,
                    selector: selector
                });
                if (activeStateEnabled) {
                    _short.active.on($el, new _action.default(function(_ref3) {
                        var event = _ref3.event,
                            element = _ref3.element;
                        return _this8._toggleActiveState((0, _renderer.default)(element), true, event)
                    }), new _action.default(function(_ref4) {
                        var event = _ref4.event,
                            element = _ref4.element;
                        return _this8._toggleActiveState((0, _renderer.default)(element), false, event)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    }), {
                        showTimeout: this._feedbackShowTimeout,
                        hideTimeout: this._feedbackHideTimeout,
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _detachFocusEvents: function() {
                var $el = this._focusEventTarget();
                _short.focus.off($el, {
                    namespace: "".concat(this.NAME, "Focus")
                })
            },
            _attachFocusEvents: function() {
                var _this9 = this;
                var $el = this._focusEventTarget();
                _short.focus.on($el, function(e) {
                    return _this9._focusInHandler(e)
                }, function(e) {
                    return _this9._focusOutHandler(e)
                }, {
                    namespace: "".concat(this.NAME, "Focus"),
                    isFocusable: function(index, el) {
                        return (0, _renderer.default)(el).is(_selectors.focusable)
                    }
                })
            },
            _hoverStartHandler: _common.noop,
            _hoverEndHandler: _common.noop,
            _toggleActiveState: function($element, value) {
                this.option("isActive", value);
                $element.toggleClass("dx-state-active", value)
            },
            _updatedHover: function() {
                var hoveredElement = this._options.silent("hoveredElement");
                this._hover(hoveredElement, hoveredElement)
            },
            _findHoverTarget: function($el) {
                return $el && $el.closest(this._activeStateUnit || this._eventBindingTarget())
            },
            _hover: function($el, $previous) {
                var _this$option10 = this.option(),
                    hoverStateEnabled = _this$option10.hoverStateEnabled,
                    disabled = _this$option10.disabled,
                    isActive = _this$option10.isActive;
                $previous = this._findHoverTarget($previous);
                $previous && $previous.toggleClass("dx-state-hover", false);
                if ($el && hoverStateEnabled && !disabled && !isActive) {
                    var newHoveredElement = this._findHoverTarget($el);
                    newHoveredElement && newHoveredElement.toggleClass("dx-state-hover", true)
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass("dx-state-disabled", Boolean(value));
                this.setAria("disabled", value || void 0)
            },
            _toggleIndependentState: function() {
                this.$element().toggleClass("dx-state-independent", this.option("ignoreParentReadOnly"))
            },
            _setWidgetOption: function(widgetName, args) {
                var _this10 = this;
                if (!this[widgetName]) {
                    return
                }
                if ((0, _type.isPlainObject)(args[0])) {
                    (0, _iterator.each)(args[0], function(option, value) {
                        return _this10._setWidgetOption(widgetName, [option, value])
                    });
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this["".concat(widgetName, "OptionMap")];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                var name = args.name,
                    value = args.value,
                    previousValue = args.previousValue;
                switch (name) {
                    case "disabled":
                        this._toggleDisabledState(value);
                        this._updatedHover();
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "ignoreParentReadOnly":
                        this._toggleIndependentState();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        this._updatedHover();
                        break;
                    case "tabIndex":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "hoveredElement":
                        this._hover(value, previousValue);
                        break;
                    case "isActive":
                        this._updatedHover();
                        break;
                    case "visible":
                        this._toggleVisibility(value);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(value ? "shown" : "hiding")
                        }
                        break;
                    case "onKeyboardHandled":
                        this._attachKeyboardEvents();
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                var _this$option11 = this.option(),
                    visible = _this$option11.visible;
                return this.callBase() && visible
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                if (!(0, _type.isPlainObject)(arguments.length <= 0 ? void 0 : arguments[0])) {
                    setAttribute(arguments.length <= 0 ? void 0 : arguments[0], arguments.length <= 1 ? void 0 : arguments[1], (arguments.length <= 2 ? void 0 : arguments[2]) || this._getAriaTarget())
                } else {
                    var target = (arguments.length <= 1 ? void 0 : arguments[1]) || this._getAriaTarget();
                    (0, _iterator.each)(arguments.length <= 0 ? void 0 : arguments[0], function(name, value) {
                        return setAttribute(name, value, target)
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                _short.focus.trigger(this._focusTarget())
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys();
                this._supportedKeys = function() {
                    return (0, _extend2.extend)(currentKeys, _defineProperty({}, key, handler))
                }
            }
        });
        Widget.getOptionsFromContainer = function(_ref5) {
            var name = _ref5.name,
                fullName = _ref5.fullName,
                value = _ref5.value;
            var options = {};
            if (name === fullName) {
                options = value
            } else {
                var option = fullName.split(".").pop();
                options[option] = value
            }
            return options
        };
        var _default = Widget;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/ui.errors.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/error */ 144));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: "{0} requires the key field to be specified",
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            E1050: "The validationRules option does not apply to third-party editors defined in the editCellTemplate",
            E1051: 'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',
            E1052: '{0} should have the "dataSource" option specified',
            E1053: 'The "buttons" option accepts an array that contains only objects or string values',
            E1054: "All text editor buttons must have names",
            E1055: 'One or several text editor buttons have invalid or non-unique "name" values',
            E1056: 'The {0} widget does not support buttons of the "{1}" type',
            E1058: 'The "startDayHour" must be earlier than the "endDayHour"',
            E1059: "All column names must be different",
            E1060: "All editable columns must have names",
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the following error: '{0}'",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects",
            W1013: 'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',
            W1014: "The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config.",
            W1015: 'The "cellDuration" should divide the range from the "startDayHour" to the "endDayHour" into even intervals'
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/core/element.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getPublicElement = getPublicElement;
        exports.setPublicElementWrapper = setPublicElementWrapper;
        var strategy = function(element) {
            return element && element.get(0)
        };

        function getPublicElement(element) {
            return strategy(element)
        }

        function setPublicElementWrapper(newStrategy) {
            strategy = newStrategy
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/date.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _math = __webpack_require__( /*! ./math */ 29);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _inflector = __webpack_require__( /*! ./inflector */ 39);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ./browser */ 22));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _construct(Parent, args, Class) {
            if (_isNativeReflectConstruct()) {
                _construct = Reflect.construct
            } else {
                _construct = function(Parent, args, Class) {
                    var a = [null];
                    a.push.apply(a, args);
                    var Constructor = Function.bind.apply(Parent, a);
                    var instance = new Constructor;
                    if (Class) {
                        _setPrototypeOf(instance, Class.prototype)
                    }
                    return instance
                }
            }
            return _construct.apply(null, arguments)
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }
        var isIE11 = _browser.default.msie && parseInt(_browser.default.version) <= 11;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime();
            var millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i;
            var dateUnitCount;
            var dateUnitInterval;
            var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"];
            var result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if ((0, _type.isObject)(tickInterval)) {
                (0, _iterator.each)(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if ((0, _type.isString)(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };

        function convertDateUnitToMilliseconds(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        }

        function getDateUnitInterval(tickInterval) {
            var maxInterval = -1;
            var i;
            if ((0, _type.isString)(tickInterval)) {
                return tickInterval
            }
            if ((0, _type.isObject)(tickInterval)) {
                (0, _iterator.each)(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        }
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };

        function correctDateWithUnitBeginning(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var oldDate = new Date(date.getTime());
            var firstQuarterMonth;
            var month;
            var dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    month = date.getMonth();
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0);
                    if (month !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        }

        function trimTime(date) {
            return correctDateWithUnitBeginning(date, "day")
        }
        var setToDayEnd = function(date) {
            var result = trimTime(date);
            result.setDate(result.getDate() + 1);
            return new Date(result.getTime() - 1)
        };
        var getDatesDifferences = function(date1, date2) {
            var counter = 0;
            var differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            (0, _iterator.each)(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime());
            var intervalObject = (0, _type.isString)(interval) ? getDateIntervalByString(interval.toLowerCase()) : (0, _type.isNumeric)(interval) ? convertMillisecondsToDateUnits(interval) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return (0, _type.isDate)(value) ? addDateInterval(value, interval, dir) : (0, _math.adjust)(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var intervals = [];
            var cur;
            intervals.push((0, _type.isDate)(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return createDateWithFullYear(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return createDateWithFullYear(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return createDateWithFullYear(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return createDateWithFullYear(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return createDateWithFullYear(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return createDateWithFullYear(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return createDateWithFullYear(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date);
            resultDate.setDate(getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };

        function getLastMonthDay(date) {
            var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        }
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };

        function getDateIntervalByString(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        }

        function sameDate(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        }

        function sameMonthAndYear(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        }

        function sameYear(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        }
        var sameDecade = function(date1, date2) {
            if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10;
            var startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100;
            var startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };

        function getFirstDecadeInCentury(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        }

        function getFirstYearInDecade(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        }
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!(0, _type.isDefined)(date)) {
                return
            }
            return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
        };
        var getLastMonthDate = function(date) {
            if (!(0, _type.isDefined)(date)) {
                return
            }
            return createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0)
        };

        function getFirstWeekDate(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        }
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day");
            var resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var dateTimeFromDecimal = function(number) {
            var hours = Math.floor(number);
            var minutes = number % 1 * 60;
            return {
                hours: hours,
                minutes: minutes
            }
        };
        var roundDateByStartDayHour = function(date, startDayHour) {
            var startTime = this.dateTimeFromDecimal(startDayHour);
            var result = new Date(date);
            if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                result.setHours(startTime.hours, startTime.minutes, 0, 0)
            }
            return result
        };

        function normalizeDate(date, min, max) {
            var normalizedDate = date;
            if (!(0, _type.isDefined)(date)) {
                return date
            }
            if ((0, _type.isDefined)(min) && date < min) {
                normalizedDate = min
            }
            if ((0, _type.isDefined)(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        }

        function fixTimezoneGap(oldDate, newDate) {
            if (!(0, _type.isDefined)(oldDate)) {
                return
            }
            var diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            var sign = 1 === diff || diff === -23 ? -1 : 1;
            var trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        }
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };

        function getTimezonesDifference(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        }
        var makeDate = function(date) {
            return new Date(date)
        };
        var getDatesOfInterval = function(startDate, endDate, step) {
            var result = [];
            var currentDate = new Date(startDate.getTime());
            while (currentDate < endDate) {
                result.push(new Date(currentDate.getTime()));
                currentDate = this.addInterval(currentDate, step)
            }
            return result
        };
        var createDate = function(date) {
            return new Date(isIE11 && (0, _type.isDate)(date) ? date.getTime() : date)
        };
        var createDateWithFullYear = function(year) {
            var result = _construct(Date, Array.prototype.slice.call(arguments));
            result.setFullYear(year);
            return result
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            setToDayEnd: setToDayEnd,
            roundDateByStartDayHour: roundDateByStartDayHour,
            dateTimeFromDecimal: dateTimeFromDecimal,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval,
            getDatesOfInterval: getDatesOfInterval,
            createDate: createDate,
            createDateWithFullYear: createDateWithFullYear
        };
        dateUtils.sameView = function(view, date1, date2) {
            return dateUtils[(0, _inflector.camelize)("same " + view)](date1, date2)
        };
        var _default = dateUtils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/data.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.toComparable = exports.compileSetter = exports.compileGetter = void 0;
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 25));
        var _class = _interopRequireDefault(__webpack_require__( /*! ../class */ 15));
        var _object = __webpack_require__( /*! ./object */ 50);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ./variable_wrapper */ 101));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var unwrapVariable = _variable_wrapper.default.unwrap;
        var isWrapped = _variable_wrapper.default.isWrapped;
        var assign = _variable_wrapper.default.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new _errors.default.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };

        function unwrap(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        }
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs;
                    var hasDefaultValue = "defaultValue" in options;
                    var current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            if (null == current && hasDefaultValue) {
                                return options.defaultValue
                            }
                            break
                        }
                        var pathPart = path[i];
                        if (hasDefaultValue && (0, _type.isObject)(current) && !(pathPart in current)) {
                            return options.defaultValue
                        }
                        var next = unwrap(current[pathPart], options);
                        if (!functionAsIs && (0, _type.isFunction)(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if ((0, _type.isFunction)(expr)) {
                return expr
            }
        };
        exports.compileGetter = compileGetter;

        function combineGetters(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                (0, _iterator.each)(compiledGetters, function(name) {
                    var value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    var current = result || (result = {});
                    var path = name.split(".");
                    var last = path.length - 1;
                    for (var _i = 0; _i < last; _i++) {
                        var pathItem = path[_i];
                        if (!(pathItem in current)) {
                            current[pathItem] = {}
                        }
                        current = current[pathItem]
                    }
                    current[path[last]] = value
                });
                return result
            }
        }
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if ((0, _type.isDefined)(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options);
                    var isPropertyFunc = !options.functionsAsIs && (0, _type.isFunction)(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && (0, _type.isPlainObject)(value) && (!(0, _type.isDefined)(propertyValue) || (0, _type.isPlainObject)(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            (0, _object.deepExtendArraySafe)(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        exports.compileSetter = compileSetter;
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof _class.default && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.toComparable = toComparable
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/events/click.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.name = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 33);
        var _frame = __webpack_require__( /*! ../animation/frame */ 129);
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _pointer = _interopRequireDefault(__webpack_require__( /*! ./pointer */ 24));
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 132));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));
        var _version = __webpack_require__( /*! ../core/utils/version */ 62);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var CLICK_EVENT_NAME = "dxclick";
        exports.name = CLICK_EVENT_NAME;
        var TOUCH_BOUNDARY = 10;
        var abs = Math.abs;
        var isInput = function(element) {
            return (0, _renderer.default)(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: _frame.requestAnimationFrame,
            cancelAnimationFrame: _frame.cancelAnimationFrame
        };
        var ClickEmitter = _emitter.default.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable((0, _renderer.default)(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = (0, _index.eventData)(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === _pointer.default.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    (0, _dom.resetActiveElement)()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target;
                var targetChanged = !(0, _dom.contains)(element, target) && element !== target;
                var gestureDelta = (0, _index.eventDelta)((0, _index.eventData)(e), this._startEventData);
                var boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: (0, _dom.closestCommonParent)(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        var realDevice = _devices.default.real();
        var useNativeClick = realDevice.generic || realDevice.ios && (0, _version.compare)(realDevice.version, [9, 3]) >= 0 || realDevice.android && (0, _version.compare)(realDevice.version, [5]) >= 0;
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var isNativeClickEvent = function(target) {
                return useNativeClick || (0, _renderer.default)(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null;
            var lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent;
                var eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED;
                var leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && !eventAlreadyFired) {
                    if (originalEvent) {
                        originalEvent.DXCLICK_FIRED = true
                    }
                    lastFiredEvent = originalEvent;
                    (0, _index.fireEvent)({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    _events_engine.default.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    _events_engine.default.off(this.getElement(), "click", clickHandler)
                }
            })
        }();
        ! function() {
            var desktopDevice = _devices.default.real().generic;
            if (!desktopDevice) {
                var startTarget = null;
                var blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = (0, _renderer.default)(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !(0, _renderer.default)(startTarget).is("label") && isInput($target)) {
                        (0, _dom.resetActiveElement)()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER";
                var document = _dom_adapter.default.getDocument();
                _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        (0, _emitter_registrator.default)({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        })
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/browser.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _window = __webpack_require__( /*! ./window */ 7);
        var navigator = (0, _window.getNavigator)();
        var webkitRegExp = /(webkit)[ /]([\w.]+)/;
        var ieRegExp = /(msie) (\d{1,2}\.\d)/;
        var ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/;
        var msEdge = /(edge)\/((\d+)?[\w.]+)/;
        var mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {};
            var matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [];
            var browserName = matches[1];
            var browserVersion = matches[2];
            if ("webkit" === browserName) {
                result.webkit = true;
                if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                    browserName = "chrome";
                    browserVersion = /(?:chrome|crios)\/(\d+\.\d+)/.exec(ua);
                    browserVersion = browserVersion && browserVersion[1]
                } else {
                    if (ua.indexOf("fxios") >= 0) {
                        browserName = "mozilla";
                        browserVersion = /fxios\/(\d+\.\d+)/.exec(ua);
                        browserVersion = browserVersion && browserVersion[1]
                    } else {
                        if (ua.indexOf("safari") >= 0 && /version|phantomjs/.test(ua)) {
                            browserName = "safari";
                            browserVersion = /(?:version|phantomjs)\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else {
                            browserName = "unknown";
                            browserVersion = /applewebkit\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                }
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        var _default = (0, _extend.extend)({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent));
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/position.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getDefaultAlignment = exports.getBoundingRect = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = null !== isRtlEnabled && void 0 !== isRtlEnabled ? isRtlEnabled : (0, _config.default)().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment;
        var getBoundingRect = function(element) {
            if ((0, _type.isWindow)(element)) {
                return {
                    width: element.outerWidth,
                    height: element.outerHeight
                }
            }
            var rect;
            try {
                rect = element.getBoundingClientRect()
            } catch (e) {
                rect = {
                    width: 0,
                    height: 0,
                    bottom: 0,
                    top: 0,
                    left: 0,
                    right: 0
                }
            }
            return rect
        };
        exports.getBoundingRect = getBoundingRect
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/events/pointer.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        exports.default = void 0;
        var support = _interopRequireWildcard(__webpack_require__( /*! ../core/utils/support */ 45));
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 22));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 74));
        var _touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/touch */ 254));
        var _mspointer = _interopRequireDefault(__webpack_require__( /*! ./pointer/mspointer */ 527));
        var _mouse = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse */ 256));
        var _mouse_and_touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse_and_touch */ 528));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }
        var getStrategy = function(support, device, browser) {
            if (support.pointerEvents && browser.msie) {
                return _mspointer.default
            }
            var tablet = device.tablet,
                phone = device.phone;
            if (support.touch && !(tablet || phone)) {
                return _mouse_and_touch.default
            }
            if (support.touch) {
                return _touch.default
            }
            return _mouse.default
        };
        var EventStrategy = getStrategy(support, _devices.default.real(), _browser.default);
        (0, _iterator.each)(EventStrategy.map, function(pointerEvent, originalEvents) {
            (0, _event_registrator.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        var pointer = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        };
        var _default = pointer;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/errors.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ./utils/error */ 144));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _error.default)({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        });
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/callbacks.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes;
            var list = this._list;
            var stopOnFalse = this._options.stopOnFalse;
            var step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list;
            var firingIndexes = this._firingIndexes;
            var index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        var _default = Callbacks;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/translator.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.parseTranslate = exports.resetPosition = exports.move = exports.getTranslate = exports.getTranslateCss = exports.clearCache = exports.locate = void 0;
        var _element_data = __webpack_require__( /*! ../core/element_data */ 40);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var TRANSLATOR_DATA_KEY = "dxTranslator";
        var TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/;
        var TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        exports.locate = locate;

        function isPercentValue(value) {
            return "string" === (0, _type.type)(value) && "%" === value[value.length - 1]
        }

        function cacheTranslate($element, translate) {
            if ($element.length) {
                (0, _element_data.data)($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        }
        var clearCache = function($element) {
            if ($element.length) {
                (0, _element_data.removeData)($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        exports.clearCache = clearCache;
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.getTranslateCss = getTranslateCss;
        var getTranslate = function($element) {
            var result = $element.length ? (0, _element_data.data)($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                    x: 0,
                    y: 0
                });
                var matrix = transformValue.match(TRANSFORM_MATRIX_REGEX);
                var is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        exports.getTranslate = getTranslate;
        var move = function($element, position) {
            var left = position.left;
            var top = position.top;
            var translate;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        exports.move = move;
        var resetPosition = function($element, finishTransition) {
            var originalTransition;
            var stylesConfig = {
                left: 0,
                top: 0,
                transform: "none"
            };
            if (finishTransition) {
                originalTransition = $element.css("transition");
                stylesConfig.transition = "none"
            }
            $element.css(stylesConfig);
            clearCache($element);
            if (finishTransition) {
                $element.get(0).offsetHeight;
                $element.css("transition", originalTransition)
            }
        };
        exports.resetPosition = resetPosition;
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        exports.parseTranslate = parseTranslate
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/math.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent;
        exports.getRoot = getRoot;
        exports.solveCubicEquation = solveCubicEquation;
        exports.trunc = trunc;
        exports.inRange = exports.fitIntoRange = exports.sign = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        exports.sign = sign;
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue;
            var isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        exports.fitIntoRange = fitIntoRange;
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };
        exports.inRange = inRange;

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4;
            var correctValue = "0.000300";
            var precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var precision = getPrecision(interval || 0) + 2;
            var separatedValue = value.toString().split(".");
            var sourceValue = value;
            var absValue = Math.abs(value);
            var separatedAdjustedValue;
            var isExponentValue = (0, _type.isExponential)(value);
            var integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if ((0, _type.isExponential)(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            var mantissa = str.split(".");
            var positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }

        function getRoot(x, n) {
            if (x < 0 && n % 2 !== 1) {
                return NaN
            }
            var y = Math.pow(Math.abs(x), 1 / n);
            return n % 2 === 1 && x < 0 ? -y : y
        }

        function solveCubicEquation(a, b, c, d) {
            var min = 1e-8;
            if (Math.abs(a) < min) {
                a = b;
                b = c;
                c = d;
                if (Math.abs(a) < min) {
                    a = b;
                    b = c;
                    if (Math.abs(a) < min) {
                        return []
                    }
                    return [-b / a]
                }
                var D2 = b * b - 4 * a * c;
                if (Math.abs(D2) < min) {
                    return [-b / (2 * a)]
                } else {
                    if (D2 > 0) {
                        return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                    }
                }
                return []
            }
            var p = (3 * a * c - b * b) / (3 * a * a);
            var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
            var roots;
            var u;
            if (Math.abs(p) < min) {
                roots = [getRoot(-q, 3)]
            } else {
                if (Math.abs(q) < min) {
                    roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                } else {
                    var D3 = q * q / 4 + p * p * p / 27;
                    if (Math.abs(D3) < min) {
                        roots = [-1.5 * q / p, 3 * q / p]
                    } else {
                        if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                }
            }
            for (var i = 0; i < roots.length; i++) {
                roots[i] -= b / (3 * a)
            }
            return roots
        }

        function trunc(value) {
            return Math.trunc ? Math.trunc(value) : value > 0 ? Math.floor(value) : Math.ceil(value)
        }
    }, ,
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/config.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            oDataFilterToLower: true,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useLegacyStoreResult: false,
            useJQuery: void 0,
            editorStylingMode: void 0,
            useLegacyVisibleIndex: false,
            floatingActionButtonConfig: {
                icon: "add",
                closeIcon: "close",
                label: "",
                position: {
                    at: "right bottom",
                    my: "right bottom",
                    offset: {
                        x: -16,
                        y: -16
                    }
                },
                maxSpeedDialActionCount: 5,
                shading: false,
                direction: "auto"
            },
            optionsParser: function(optionsString) {
                if ("{" !== optionsString.trim().charAt(0)) {
                    optionsString = "{" + optionsString + "}"
                }
                try {
                    return new Function("return " + optionsString)()
                } catch (ex) {
                    throw _errors.default.Error("E3018", ex, optionsString)
                }
            }
        };
        var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
            deprecatedFields.forEach(function(deprecatedField) {
                if (newConfig[deprecatedField]) {
                    var message = "Now, the ".concat(deprecatedField, " is selected based on the specified locale.");
                    _errors.default.log("W0003", "config", deprecatedField, "19.2", message)
                }
            });
            (0, _extend.extend)(config, newConfig)
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        var _default = configMethod;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/date.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _date = __webpack_require__( /*! ./ldml/date.formatter */ 242);
        var _date2 = __webpack_require__( /*! ./ldml/date.format */ 173);
        var _date3 = __webpack_require__( /*! ./ldml/date.parser */ 232);
        var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ./default_date_names */ 243));
        var _first_day_of_week_data = _interopRequireDefault(__webpack_require__( /*! ./cldr-data/first_day_of_week_data */ 496));
        var _core = _interopRequireDefault(__webpack_require__( /*! ./core */ 86));
        var _number = _interopRequireDefault(__webpack_require__( /*! ./number */ 47));
        var _date4 = _interopRequireDefault(__webpack_require__( /*! ./intl/date */ 497));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_DAY_OF_WEEK_INDEX = 0;
        var hasIntl = "undefined" !== typeof Intl;
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format;
                var result = [];
                (0, _iterator.each)(pattern.split(/\W+/), function(_, formatPart) {
                    (0, _iterator.each)(possiblePartPatterns, function(partName, possiblePatterns) {
                        if ((0, _array.inArray)(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return _default_date_names.default.getMonthNames(format)
            },
            getDayNames: function(format) {
                return _default_date_names.default.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return _default_date_names.default.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return _default_date_names.default.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0);
                var pmTime = new Date(2017, 0, 20, 23, 0, 0, 0);
                var amTimeFormatted = this.format(amTime, format);
                var pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if ((0, _type.isString)(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return _number.default.convertDigits((0, _date.getFormatter)(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var that = this;
                var ldmlFormat;
                var formatter;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return _number.default.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = (0, _date2.getFormat)(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = _number.default.convertDigits(text, true);
                    return (0, _date3.getParser)(ldmlFormat, this)(text)
                }
                _errors.default.log("W0012");
                var result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                var index = _core.default.getValueByClosestLocale(function(locale) {
                    return _first_day_of_week_data.default[locale]
                });
                return void 0 === index ? DEFAULT_DAY_OF_WEEK_INDEX : index
            }
        });
        if (hasIntl) {
            dateLocalization.inject(_date4.default)
        }
        var _default = dateLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/dom.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.createTextElementHiddenCopy = exports.contains = exports.clipboardText = exports.normalizeTemplateElement = exports.extractTemplateMarkup = exports.closestCommonParent = exports.clearSelection = exports.resetActiveElement = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _window = __webpack_require__( /*! ./window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var resetActiveElement = function() {
            var activeElement = _dom_adapter.default.getActiveElement();
            var body = _dom_adapter.default.getBody();
            if (activeElement && activeElement !== body && activeElement.blur) {
                try {
                    activeElement.blur()
                } catch (e) {
                    body.blur()
                }
            }
        };
        exports.resetActiveElement = resetActiveElement;
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        exports.clearSelection = clearSelection;
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = (0, _renderer.default)(startTarget);
            var $endTarget = (0, _renderer.default)(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents();
            var $endParents = $endTarget.parents();
            var startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        exports.closestCommonParent = closestCommonParent;
        var extractTemplateMarkup = function(element) {
            element = (0, _renderer.default)(element);
            var templateTag = element.length && element.filter(function() {
                var $node = (0, _renderer.default)(this);
                return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
            });
            if (templateTag.length) {
                return templateTag.eq(0).html()
            } else {
                element = (0, _renderer.default)("<div>").append(element);
                return element.html()
            }
        };
        exports.extractTemplateMarkup = extractTemplateMarkup;
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = (0, _type.isDefined)(element) && (element.nodeType || (0, _type.isRenderer)(element)) ? (0, _renderer.default)(element) : (0, _renderer.default)("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        exports.normalizeTemplateElement = normalizeTemplateElement;
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        exports.clipboardText = clipboardText;
        var contains = function contains(container, element) {
            if (!element) {
                return false
            }
            if (_dom_adapter.default.isTextNode(element)) {
                element = element.parentNode
            }
            if (_dom_adapter.default.isDocument(container)) {
                return container.documentElement.contains(element)
            }
            if ((0, _type.isWindow)(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };
        exports.contains = contains;
        var createTextElementHiddenCopy = function(element, text, options) {
            var elementStyles = window.getComputedStyle((0, _renderer.default)(element).get(0));
            var includePaddings = options && options.includePaddings;
            return (0, _renderer.default)("<div>").text(text).css({
                fontStyle: elementStyles.fontStyle,
                fontVariant: elementStyles.fontVariant,
                fontWeight: elementStyles.fontWeight,
                fontSize: elementStyles.fontSize,
                fontFamily: elementStyles.fontFamily,
                letterSpacing: elementStyles.letterSpacing,
                border: elementStyles.border,
                paddingTop: includePaddings ? elementStyles.paddingTop : "",
                paddingRight: includePaddings ? elementStyles.paddingRight : "",
                paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                visibility: "hidden",
                whiteSpace: "pre",
                position: "absolute",
                "float": "left"
            })
        };
        exports.createTextElementHiddenCopy = createTextElementHiddenCopy
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled-npm/ui/themes.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.init = init;
        exports.current = current;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.isMaterial = isMaterial;
        exports.isGeneric = isGeneric;
        exports.isDark = isDark;
        exports.isWebFontLoaded = isWebFontLoaded;
        exports.waitWebFont = waitWebFont;
        exports.ready = themeReady;
        exports.resetTheme = resetTheme;
        exports.initialized = initialized;
        exports.setDefaultTimeout = setDefaultTimeout;
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../core/polyfills/promise */ 73));
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _html_parser = __webpack_require__( /*! ../core/utils/html_parser */ 238);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/ready_callbacks */ 49));
        var _view_port = __webpack_require__( /*! ../core/utils/view_port */ 81);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _themes_callback = __webpack_require__( /*! ./themes_callback */ 258);
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./widget/ui.errors */ 17));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var ready = _ready_callbacks.default.add;
        var viewPort = _view_port.value;
        var viewPortChanged = _view_port.changeCallback;
        var initDeferred = new _deferred.Deferred;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]";
        var THEME_ATTR = "data-theme";
        var ACTIVE_ATTR = "data-active";
        var DX_HAIRLINES_CLASS = "dx-hairlines";
        var ANY_THEME = "any";
        var context;
        var $activeThemeLink;
        var knownThemes;
        var currentThemeName;
        var pendingThemeName;
        var defaultTimeout = 15e3;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!(0, _window.hasWindow)()) {
                return null
            }
            var element = (0, _renderer.default)("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            var result;
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            var timerId;
            var intervalCleared = true;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                clearInterval(timerId);
                intervalCleared = true;
                _themes_callback.themeReadyCallback.fire();
                _themes_callback.themeReadyCallback.empty();
                initDeferred.resolve()
            }
            if (isPendingThemeLoaded() || !defaultTimeout) {
                handleLoaded()
            } else {
                if (!intervalCleared) {
                    if (pendingThemeName) {
                        pendingThemeName = themeName
                    }
                    return
                }
                waitStartTime = Date.now();
                intervalCleared = false;
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded();
                    var isTimeout = !isLoaded && Date.now() - waitStartTime > defaultTimeout;
                    if (isTimeout) {
                        _ui.default.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            if (!pendingThemeName) {
                return true
            }
            var anyThemePending = pendingThemeName === ANY_THEME;
            if ("resolved" === initDeferred.state() && anyThemePending) {
                return true
            }
            var themeMarker = readThemeMarker();
            if (themeMarker && anyThemePending) {
                return true
            }
            return themeMarker === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = (0, _renderer.default)(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = (0, _renderer.default)((0, _html_parser.parseHTML)("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = (0, _renderer.default)(this, context);
                var fullThemeName = link.attr(THEME_ATTR);
                var url = link.attr("href");
                var isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName ? desiredThemeName.split(".") : [];
            var result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }(0, _iterator.each)(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (desiredThemeParts[0] && knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || _dom_adapter.default.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var isAutoInit = options._autoInit;
            var loadCallback = options.loadCallback;
            var currentThemeData;
            currentThemeName = resolveFullThemeName(options.theme || currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                _themes_callback.themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if (_themes_callback.themeReadyCallback.has() || "resolved" !== initDeferred.state() || options._forceTimeout) {
                    waitForThemeLoad(currentThemeName)
                }
            } else {
                if (isAutoInit) {
                    waitForThemeLoad(ANY_THEME);
                    _themes_callback.themeReadyCallback.fire();
                    _themes_callback.themeReadyCallback.empty()
                } else {
                    throw _ui.default.Error("E0021", currentThemeName)
                }
            }
            initDeferred.done(function() {
                return attachCssClasses((0, _view_port.originalViewPort)(), currentThemeName)
            })
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [];
            var themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial(themeName) ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            (0, _renderer.default)(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = (0, _window.hasWindow)() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = (0, _renderer.default)("<div>");
                $tester.css("border", ".5px solid transparent");
                (0, _renderer.default)("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    (0, _renderer.default)(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            (0, _renderer.default)(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            _themes_callback.themeReadyCallback.add(callback)
        }

        function isTheme(themeRegExp, themeName) {
            if (!themeName) {
                themeName = currentThemeName || readThemeMarker()
            }
            return new RegExp(themeRegExp).test(themeName)
        }

        function isMaterial(themeName) {
            return isTheme("material", themeName)
        }

        function isGeneric(themeName) {
            return isTheme("generic", themeName)
        }

        function isDark(themeName) {
            return isTheme("dark", themeName)
        }

        function isWebFontLoaded(text, fontWeight) {
            var testedFont = "Roboto, RobotoFallback, Arial";
            var etalonFont = "Arial";
            var document = _dom_adapter.default.getDocument();
            var testElement = document.createElement("span");
            testElement.style.position = "absolute";
            testElement.style.top = "-9999px";
            testElement.style.left = "-9999px";
            testElement.style.visibility = "hidden";
            testElement.style.fontFamily = etalonFont;
            testElement.style.fontSize = "250px";
            testElement.style.fontWeight = fontWeight;
            testElement.innerHTML = text;
            document.body.appendChild(testElement);
            var etalonFontWidth = testElement.offsetWidth;
            testElement.style.fontFamily = testedFont;
            var testedFontWidth = testElement.offsetWidth;
            testElement.parentNode.removeChild(testElement);
            return etalonFontWidth !== testedFontWidth
        }

        function waitWebFont(text, fontWeight) {
            var interval = 15;
            var timeout = 2e3;
            return new _promise.default(function(resolve) {
                var check = function() {
                    if (isWebFontLoaded(text, fontWeight)) {
                        clear()
                    }
                };
                var clear = function() {
                    clearInterval(intervalId);
                    clearTimeout(timeoutId);
                    resolve()
                };
                var intervalId = setInterval(check, interval);
                var timeoutId = setTimeout(clear, timeout)
            })
        }

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ((0, _renderer.default)(DX_LINK_SELECTOR, context).length) {
                throw _ui.default.Error("E0022")
            }
        }
        if ((0, _window.hasWindow)()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        _devices.default.changed.add(function() {
            init({
                _autoInit: true
            })
        });

        function resetTheme() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null;
            initDeferred = new _deferred.Deferred
        }

        function initialized(callback) {
            initDeferred.done(callback)
        }

        function setDefaultTimeout(timeout) {
            defaultTimeout = timeout
        }
    }, ,
    /*!***********************************************!*\
      !*** ./artifacts/transpiled-npm/core/guid.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 15));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var Guid = _class.default.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        var _default = Guid;
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/data/errors.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _error = _interopRequireDefault(__webpack_require__( /*! ../core/utils/error */ 144));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var handlers = {};
        var errors = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });
        var errorHandler = null;
        var _errorHandler = function(error) {
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        var _default = handlers;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/inflector.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.captionize = exports.titleize = exports.humanize = exports.camelize = exports.underscore = exports.dasherize = void 0;
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return (0, _iterator.map)(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        exports.dasherize = dasherize;
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        exports.underscore = underscore;
        var camelize = function(text, upperFirst) {
            return (0, _iterator.map)(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        exports.camelize = camelize;
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        exports.humanize = humanize;
        var titleize = function(text) {
            return (0, _iterator.map)(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        exports.titleize = titleize;
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var captionList = [];
            var i;
            var char;
            var isPrevCharNewWord = false;
            var isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.captionize = captionize
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/element_data.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getDataStrategy = getDataStrategy;
        exports.data = data;
        exports.beforeCleanData = beforeCleanData;
        exports.afterCleanData = afterCleanData;
        exports.cleanData = cleanData;
        exports.removeData = removeData;
        exports.cleanDataRecursive = cleanDataRecursive;
        exports.setDataStrategy = exports.strategyChanging = void 0;
        var _weak_map = _interopRequireDefault(__webpack_require__( /*! ./polyfills/weak_map */ 198));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ./dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _memorized_callbacks = _interopRequireDefault(__webpack_require__( /*! ./memorized_callbacks */ 199));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var dataMap = new _weak_map.default;
        var strategy;
        var strategyChanging = new _memorized_callbacks.default;
        exports.strategyChanging = strategyChanging;
        var beforeCleanDataFunc = function() {};
        var afterCleanDataFunc = function() {};
        var setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanDataFunc(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanDataFunc(nodes);
                return result
            }
        };
        exports.setDataStrategy = setDataStrategy;
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    _events_engine.default.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });

        function getDataStrategy() {
            return strategy
        }

        function data() {
            return strategy.data.apply(this, arguments)
        }

        function beforeCleanData(callback) {
            beforeCleanDataFunc = callback
        }

        function afterCleanData(callback) {
            afterCleanDataFunc = callback
        }

        function cleanData(nodes) {
            return strategy.cleanData.call(this, nodes)
        }

        function removeData(element, key) {
            return strategy.removeData.call(this, element, key)
        }

        function cleanDataRecursive(element, cleanSelf) {
            if (!_dom_adapter.default.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/data/utils.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/ready_callbacks */ 49));
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var ready = _ready_callbacks.default.add;
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return (0, _iterator.map)(info, function(i) {
                var result = {
                    selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                return result
            };
            var unloading;
            ready(function() {
                var window = (0, _window.getWindow)();
                _dom_adapter.default.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockCount = 0;
            var lockDeferred;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new _deferred.Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|&&|&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var names = (0, _iterator.map)(key1, function(v, k) {
                    return k
                });
                var name;
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if (!(0, _common.equalByValue)(key1[name], key2[name], 0, false)) {
                        return false
                    }
                }
                return true
            }
            return (0, _common.equalByValue)(key1, key2, 0, false)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i];
                var octet2 = input[i + 1];
                var octet3 = input[i + 2];
                result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };

        function stringToByteArray(str) {
            var bytes = [];
            var code;
            var i;
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        }
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var isGroupOperator = function(value) {
            return "and" === value || "or" === value
        };
        var isGroupCriterion = function(crit) {
            var first = crit[0];
            var second = crit[1];
            if (Array.isArray(first)) {
                return true
            }
            if ((0, _type.isFunction)(first)) {
                if (Array.isArray(second) || (0, _type.isFunction)(second) || isGroupOperator(second)) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new _deferred.Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new _deferred.Deferred;
            return d.reject.apply(d, arguments).promise()
        };

        function throttle(func, timeout) {
            var timeoutId;
            var lastArgs;
            return function() {
                var _this = this;
                lastArgs = arguments;
                if (!timeoutId) {
                    timeoutId = setTimeout(function() {
                        timeoutId = void 0;
                        if (lastArgs) {
                            func.call(_this, lastArgs)
                        }
                    }, (0, _type.isFunction)(timeout) ? timeout() : timeout)
                }
                return timeoutId
            }
        }

        function throttleChanges(func, timeout) {
            var cache = [];
            var throttled = throttle(function() {
                func.call(this, cache);
                cache = []
            }, timeout);
            return function(changes) {
                if (Array.isArray(changes)) {
                    var _cache;
                    (_cache = cache).push.apply(_cache, _toConsumableArray(changes))
                }
                return throttled.call(this, cache)
            }
        }
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            throttleChanges: throttleChanges,
            trivialPromise: trivialPromise,
            rejectedPromise: rejectedPromise,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            isGroupCriterion: isGroupCriterion,
            base64_encode: base64_encode
        };
        var _default = utils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/fx.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 5));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _translator = __webpack_require__( /*! ./translator */ 28);
        var _easing = __webpack_require__( /*! ./easing */ 253);
        var _frame = __webpack_require__( /*! ./frame */ 129);
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _position = _interopRequireDefault(__webpack_require__( /*! ./position */ 82));
        var _remove_event = _interopRequireDefault(__webpack_require__( /*! ../core/remove_event */ 150));
        var _index = __webpack_require__( /*! ../events/utils/index */ 8);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var window = (0, _window.getWindow)();
        var removeEventName = (0, _index.addNamespace)(_remove_event.default, "dxFX");
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
        var ANIM_DATA_KEY = "dxAnimData";
        var ANIM_QUEUE_KEY = "dxAnimQueue";
        var TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this;
                var deferred = new _deferred.Deferred;
                var cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            (0, _deferred.when)(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var that = this;
                var startTime = Date.now() + config.delay;
                var deferred = new _deferred.Deferred;
                var transitionEndFired = new _deferred.Deferred;
                var simulatedTransitionEndFired = new _deferred.Deferred;
                var simulatedEndEventTimer;
                var transitionEndEventFullName = (0, _support.transitionEndEventName)() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    _events_engine.default.off($element, transitionEndEventFullName);
                    _events_engine.default.off($element, removeEventName)
                };
                _events_engine.default.one($element, transitionEndEventFullName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                _events_engine.default.off($element, removeEventName);
                _events_engine.default.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                var waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    (0, _deferred.when)(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if ((0, _type.isPlainObject)(config.to)) {
                        (0, _iterator.each)(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new _deferred.Deferred;
                var that = this;
                if (!config) {
                    return deferred.reject().promise()
                }(0, _iterator.each)(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: (0, _easing.convertTransitionTimingFuncToEasing)(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = (0, _extend.extend)({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = (0, _iterator.map)(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return (0, _translator.getTranslateCss)(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                _events_engine.default.off($element, removeEventName);
                _events_engine.default.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                (0, _iterator.each)(transformString.match(/(\w|\d)+\([^)]*\)\s*/g), function(i, part) {
                    var translateData = (0, _translator.parseTranslate)(part);
                    var scaleData = part.match(/scale\((.+?)\)/);
                    var rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }(0, _frame.cancelAnimationFrame)(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = (0, _frame.requestAnimationFrame)(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration;
                        var t = currentDuration;
                        var b = 1 * from[propName];
                        var c = to[propName] - from[propName];
                        var d = frameAnimation.duration;
                        return (0, _easing.getEasing)(frameAnimation.easing)(x, t, b, c, d)
                    };
                    (0, _iterator.each)(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === _typeof(endPropValue) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new _deferred.Deferred).resolve().promise()
            },
            stop: _common.noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: (0, _support.transition)() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !(0, _support.transition)()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            (0, _iterator.each)(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw _errors.default.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return (0, _type.isPlainObject)(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = (0, _translator.locate)($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = (0, _extend.extend)({
                        of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                (0, _translator.clearCache)($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = (0, _translator.getTranslateCss)({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var from = config.from;
                var fromOpacity = (0, _type.isPlainObject)(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                var toOpacity;
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from;
                var to = config.to;
                var fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                var toOpacity = "opacity" in to ? to.opacity : 1;
                var fromScale = "scale" in from ? from.scale : 0;
                var toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = (0, _translator.getTranslate)($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return (0, _translator.getTranslateCss)(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw _errors.default.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
            type: "custom",
            from: {},
            to: {},
            duration: 400,
            start: _common.noop,
            complete: _common.noop,
            easing: "ease",
            delay: 0
        };
        var defaultCssConfig = {
            duration: 400,
            easing: "ease",
            delay: 0
        };

        function setupAnimationOnElement() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = (0, _element.getPublicElement)($element);
                config.start.apply(this, [element, config])
            }
        }
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element;
            var config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = (0, _element.getPublicElement)($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = (0, _index.addNamespace)(_remove_event.default, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            _events_engine.default.off(animation.element, scopedRemoveEvent);
            _events_engine.default.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                _events_engine.default.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
            var config = (0, _extend.extend)(true, {}, defaultConfig, initialConfig);
            var configurator = getAnimationConfigurator(config);
            var strategy = getAnimationStrategy(config);
            var animation = {
                element: (0, _renderer.default)(element),
                config: config,
                configurator: configurator,
                strategy: strategy,
                isSynchronous: strategy.isSynchronous,
                setup: setupAnimationOnElement,
                start: startAnimationOnElement,
                stop: stopAnimationOnElement,
                deferred: new _deferred.Deferred
            };
            if ((0, _type.isFunction)(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = (0, _renderer.default)(element);
            if (!$element.length) {
                return (new _deferred.Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };

        function pushInAnimationQueue($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        }

        function getAnimQueueData($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        }

        function writeAnimQueueData($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        }
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };

        function isAnimating($element) {
            return !!$element.data(ANIM_DATA_KEY)
        }

        function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        }

        function executeAnimation(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        }

        function setupPosition($element, config) {
            if (!config || !config.position) {
                return
            }
            var win = (0, _renderer.default)(window);
            var left = 0;
            var top = 0;
            var position = _position.default.calculate($element, config.position);
            var offset = $element.offset();
            var currentPosition = $element.position();
            if (currentPosition.top > offset.top) {
                top = win.scrollTop()
            }
            if (currentPosition.left > offset.left) {
                left = win.scrollLeft()
            }(0, _extend.extend)(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        }

        function setProps($element, props) {
            (0, _iterator.each)(props, function(key, value) {
                try {
                    $element.css(key, (0, _type.isFunction)(value) ? value() : value)
                } catch (e) {}
            })
        }
        var stop = function(element, jumpToEnd) {
            var $element = (0, _renderer.default)(element);
            var queueData = getAnimQueueData($element);
            (0, _iterator.each)(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        var _default = fx;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/string.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.isEmpty = exports.replaceAll = exports.format = exports.quadToObject = exports.encodeHtml = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        exports.encodeHtml = encodeHtml;
        var splitQuad = function(raw) {
            switch (_typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var quadToObject = function(raw) {
            var quad = splitQuad(raw);
            var left = parseInt(quad && quad[0], 10);
            var top = parseInt(quad && quad[1], 10);
            var right = parseInt(quad && quad[2], 10);
            var bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        exports.quadToObject = quadToObject;
        var format = function() {
            var s = arguments[0];
            var values = [].slice.call(arguments).slice(1);
            var replaceDollarCount;
            var reg;
            var value;
            if ((0, _type.isFunction)(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === (0, _type.type)(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        exports.format = format;
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        exports.replaceAll = replaceAll;
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.isEmpty = isEmpty
    }, ,
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/support.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "stylePropPrefix", {
            enumerable: true,
            get: function() {
                return _style.stylePropPrefix
            }
        });
        Object.defineProperty(exports, "styleProp", {
            enumerable: true,
            get: function() {
                return _style.styleProp
            }
        });
        exports.nativeScrolling = exports.animation = exports.transitionEndEventName = exports.transition = exports.touch = exports.inputType = exports.supportProp = exports.pointerEvents = exports.touchEvents = void 0;
        var _array = __webpack_require__( /*! ./array */ 13);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _common = __webpack_require__( /*! ./common */ 4);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));
        var _window = __webpack_require__( /*! ./window */ 7);
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../devices */ 14));
        var _style = __webpack_require__( /*! ./style */ 97);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _getNavigator = (0, _window.getNavigator)(),
            maxTouchPoints = _getNavigator.maxTouchPoints,
            msMaxTouchPoints = _getNavigator.msMaxTouchPoints,
            pointerEnabled = _getNavigator.pointerEnabled;
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!(0, _style.styleProp)(prop)
        };
        exports.supportProp = supportProp;
        var isNativeScrollingSupported = function() {
            var _devices$real = _devices.default.real(),
                platform = _devices$real.platform,
                version = _devices$real.version,
                isMac = _devices$real.mac;
            var isObsoleteAndroid = version && version[0] < 4 && "android" === platform;
            var isNativeScrollDevice = !isObsoleteAndroid && (0, _array.inArray)(platform, ["ios", "android"]) > -1 || isMac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = _dom_adapter.default.createElement("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        exports.inputType = inputType;
        var detectTouchEvents = function(hasWindowProperty, maxTouchPoints) {
            return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
        };
        var detectPointerEvent = function(hasWindowProperty, pointerEnabled) {
            var isPointerEnabled = (0, _common.ensureDefined)(pointerEnabled, true);
            var canUsePointerEvent = (0, _common.ensureDefined)(pointerEnabled, false);
            return hasWindowProperty("PointerEvent") && isPointerEnabled || canUsePointerEvent
        };
        var touchEvents = detectTouchEvents(_window.hasProperty, maxTouchPoints);
        exports.touchEvents = touchEvents;
        var pointerEvents = detectPointerEvent(_window.hasProperty, pointerEnabled);
        exports.pointerEvents = pointerEvents;
        var touchPointersPresent = !!maxTouchPoints || !!msMaxTouchPoints;
        var touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.touch = touch;
        var transition = (0, _call_once.default)(function() {
            return supportProp("transition")
        });
        exports.transition = transition;
        var transitionEndEventName = (0, _call_once.default)(function() {
            return transitionEndEventNames[(0, _style.styleProp)("transition")]
        });
        exports.transitionEndEventName = transitionEndEventName;
        var animation = (0, _call_once.default)(function() {
            return supportProp("animation")
        });
        exports.animation = animation;
        var nativeScrolling = isNativeScrollingSupported();
        exports.nativeScrolling = nativeScrolling
    }, ,
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/number.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = __webpack_require__( /*! ./ldml/number */ 322);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 31));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _utils = __webpack_require__( /*! ./utils */ 240);
        var _currency = _interopRequireDefault(__webpack_require__( /*! ./currency */ 113));
        var _number2 = _interopRequireDefault(__webpack_require__( /*! ./intl/number */ 492));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _slicedToArray(arr, i) {
            return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest()
        }

        function _nonIterableRest() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function _iterableToArrayLimit(arr, i) {
            if ("undefined" === typeof Symbol || !(Symbol.iterator in Object(arr))) {
                return
            }
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) {
                        break
                    }
                }
            } catch (err) {
                _d = true;
                _e = err
            } finally {
                try {
                    if (!_n && null != _i.return) {
                        _i.return()
                    }
                } finally {
                    if (_d) {
                        throw _e
                    }
                }
            }
            return _arr
        }

        function _arrayWithHoles(arr) {
            if (Array.isArray(arr)) {
                return arr
            }
        }
        var hasIntl = "undefined" !== typeof Intl;
        var MAX_LARGE_NUMBER_POWER = 4;
        var DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = (0, _dependency_injector.default)({
            engine: function() {
                return "base"
            },
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                var formatList = formatType.toLowerCase().split(" ");
                (0, _iterator.each)(formatList, function(index, value) {
                    if ((0, _array.inArray)(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value);
                var power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                var powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                var result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var power = this._calculateNumberPower(value, DECIMAL_BASE);
                var number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                var powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, (0, _config.default)().thousandsSeparator) + (parts[1] ? (0, _config.default)().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : (0, _utils.toFixed)(value, formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", (0, _config.default)().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!(0, _type.isPlainObject)(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e4, "fixedPoint")[2]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0";
                var toFirstDigit = toStandard ? "0" : digits[1];
                var fromLastDigit = toStandard ? digits[0] : "9";
                var regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getNegativeEtalonRegExp: function(format) {
                var separators = this._getSeparators();
                var digitalRegExp = new RegExp("[0-9" + (0, _common.escapeRegExp)(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g");
                var specialCharacters = ["\\", "(", ")", "[", "]", "*", "+", "$", "^", "?", "|", "{", "}"];
                var negativeEtalon = this.format(-1, format).replace(digitalRegExp, "1");
                specialCharacters.forEach(function(char) {
                    negativeEtalon = negativeEtalon.replace(char, "\\".concat(char))
                });
                negativeEtalon = negativeEtalon.replace(" ", "\\s");
                negativeEtalon = negativeEtalon.replace("1", ".+");
                return new RegExp(negativeEtalon, "g")
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var negativeEtalon = this.getNegativeEtalonRegExp(format);
                return text.match(negativeEtalon) ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    var formatterConfig = this._getSeparators();
                    formatterConfig.unlimitedIntegerDigits = _format.unlimitedIntegerDigits;
                    return this.convertDigits((0, _number.getFormatter)(_format.type, formatterConfig)(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    _errors.default.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator();
                var regExp = new RegExp("[^0-9" + (0, _common.escapeRegExp)(decimalSeparator) + "]", "g");
                var cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, "");
                if ("." === cleanedText || "" === cleanedText) {
                    return null
                }
                if (this._calcSignificantDigits(cleanedText) > 15) {
                    return NaN
                }
                var parsed = +cleanedText * this.getSign(text, format);
                format = this._normalizeFormat(format);
                var formatConfig = this._parseNumberFormatString(format.type);
                var power = null === formatConfig || void 0 === formatConfig ? void 0 : formatConfig.power;
                if (power) {
                    if ("auto" === power) {
                        var match = text.match(/\d(K|M|B|T)/);
                        if (match) {
                            power = (0, _array.find)(Object.keys(LargeNumberFormatPostfixes), function(power) {
                                return LargeNumberFormatPostfixes[power] === match[1]
                            })
                        }
                    }
                    parsed *= Math.pow(10, 3 * power)
                }
                if ("percent" === (null === formatConfig || void 0 === formatConfig ? void 0 : formatConfig.formatType)) {
                    parsed /= 100
                }
                return parsed
            },
            _calcSignificantDigits: function(text) {
                var _text$split = text.split("."),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    integer = _text$split2[0],
                    fractional = _text$split2[1];
                var calcDigitsAfterLeadingZeros = function(digits) {
                    var index = -1;
                    for (var i = 0; i < digits.length; i++) {
                        if ("0" !== digits[i]) {
                            index = i;
                            break
                        }
                    }
                    return index > -1 ? digits.length - index : 0
                };
                var result = 0;
                if (integer) {
                    result += calcDigitsAfterLeadingZeros(integer.split(""))
                }
                if (fractional) {
                    result += calcDigitsAfterLeadingZeros(fractional.split("").reverse())
                }
                return result
            }
        });
        numberLocalization.inject(_currency.default);
        if (hasIntl) {
            numberLocalization.inject(_number2.default)
        }
        var _default = numberLocalization;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/data/query.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _query_implementation = __webpack_require__( /*! ./query_implementation */ 251);
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return _query_implementation.queryImpl[impl].apply(this, arguments)
        };
        var _default = query;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/ready_callbacks.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));
        var _window = __webpack_require__( /*! ./window */ 7);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var callbacks = [];
        var isReady = function() {
            return "complete" === _dom_adapter.default.getReadyState() || "loading" !== _dom_adapter.default.getReadyState() && !_dom_adapter.default.getDocumentElement().doScroll
        };
        var subscribeReady = (0, _call_once.default)(function() {
            var removeListener = _dom_adapter.default.listen(_dom_adapter.default.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var windowExists = (0, _window.hasWindow)();
                if (windowExists && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    windowExists && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    return callback()
                });
                callbacks = []
            }
        };
        var _default = (0, _dependency_injector.default)(readyCallbacks);
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/object.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.deepExtendArraySafe = exports.orderEach = exports.clone = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ./variable_wrapper */ 101));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        exports.clone = clone;
        var orderEach = function(map, func) {
            var keys = [];
            var key;
            var i;
            for (key in map) {
                if (Object.prototype.hasOwnProperty.call(map, key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = (0, _type.isNumeric)(x);
                var isNumberY = (0, _type.isNumeric)(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        exports.orderEach = orderEach;
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && _variable_wrapper.default.isWrapped(target[property])) {
                _variable_wrapper.default.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue;
            var newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if ("__proto__" === name || target === newValue) {
                    continue
                }
                if ((0, _type.isPlainObject)(newValue)) {
                    var goDeeper = extendComplexObject ? (0, _type.isObject)(prevValue) : (0, _type.isPlainObject)(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/editor/editor.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 40);
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _index = __webpack_require__( /*! ../../events/utils/index */ 8);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.widget */ 16));
        var _validation_engine = _interopRequireDefault(__webpack_require__( /*! ../validation_engine */ 94));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _validation_message = _interopRequireDefault(__webpack_require__( /*! ../validation_message */ 542));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 36));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var INVALID_MESSAGE_AUTO = "dx-invalid-message-auto";
        var READONLY_STATE_CLASS = "dx-state-readonly";
        var INVALID_CLASS = "dx-invalid";
        var DX_INVALID_BADGE_CLASS = "dx-show-invalid-badge";
        var VALIDATION_TARGET = "dx-validation-target";
        var VALIDATION_STATUS_VALID = "valid";
        var VALIDATION_STATUS_INVALID = "invalid";
        var READONLY_NAMESPACE = "editorReadOnly";
        var VALIDATION_MESSAGE_KEYS_MAP = {
            validationMessageMode: "mode",
            validationMessageOffset: "offset",
            validationBoundary: "boundary"
        };
        var Editor = _ui.default.inherit({
            ctor: function() {
                this.showValidationMessageTimeout = null;
                this.validationRequest = (0, _callbacks.default)();
                this.callBase.apply(this, arguments)
            },
            _createElement: function(element) {
                this.callBase(element);
                var $element = this.$element();
                if ($element) {
                    (0, _element_data.data)($element[0], VALIDATION_TARGET, this)
                }
            },
            _initOptions: function(options) {
                this.callBase.apply(this, arguments);
                this.option(_validation_engine.default.initValidationOptions(options))
            },
            _init: function() {
                this.callBase();
                this._options.cache("validationTooltipOptions", this.option("validationTooltipOptions"));
                var $element = this.$element();
                $element.addClass(DX_INVALID_BADGE_CLASS)
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationErrors: null,
                    validationStatus: VALIDATION_STATUS_VALID,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    },
                    validationTooltipOptions: {}
                })
            },
            _attachKeyboardEvents: function() {
                if (!this.option("readOnly")) {
                    this.callBase()
                }
            },
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _focusInHandler: function(e) {
                var _this = this;
                var isValidationMessageShownOnFocus = "auto" === this.option("validationMessageMode");
                if (this._canValueBeChangedByClick() && isValidationMessageShownOnFocus) {
                    var _this$_$validationMes;
                    null === (_this$_$validationMes = this._$validationMessage) || void 0 === _this$_$validationMes ? void 0 : _this$_$validationMes.removeClass(INVALID_MESSAGE_AUTO);
                    clearTimeout(this.showValidationMessageTimeout);
                    this.showValidationMessageTimeout = setTimeout(function() {
                        var _this$_$validationMes2;
                        return null === (_this$_$validationMes2 = _this._$validationMessage) || void 0 === _this$_$validationMes2 ? void 0 : _this$_$validationMes2.addClass(INVALID_MESSAGE_AUTO)
                    }, 150)
                }
                return this.callBase(e)
            },
            _canValueBeChangedByClick: function() {
                return false
            },
            _getValidationErrors: function() {
                var validationErrors = this.option("validationErrors");
                if (!validationErrors && this.option("validationError")) {
                    validationErrors = [this.option("validationError")]
                }
                return validationErrors
            },
            _disposeValidationMessage: function() {
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this.setAria("describedby", null);
                    this._$validationMessage = null
                }
            },
            _toggleValidationClasses: function(isInvalid) {
                this.$element().toggleClass(INVALID_CLASS, isInvalid);
                this.setAria(VALIDATION_STATUS_INVALID, isInvalid || void 0)
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid") && this.option("validationStatus") !== VALIDATION_STATUS_INVALID;
                var validationErrors = this._getValidationErrors();
                var $element = this.$element();
                this._toggleValidationClasses(!isValid);
                if (!(0, _window.hasWindow)()) {
                    return
                }
                this._disposeValidationMessage();
                if (!isValid && validationErrors) {
                    this._$validationMessage = (0, _renderer.default)("<div>").appendTo($element);
                    this.setAria("describedby", "dx-" + new _guid.default);
                    this._validationMessage = new _validation_message.default(this._$validationMessage, (0, _extend.extend)({
                        validationErrors: validationErrors,
                        target: this._getValidationMessageTarget(),
                        container: $element,
                        mode: this.option("validationMessageMode"),
                        positionRequest: "below",
                        offset: this.option("validationMessageOffset"),
                        boundary: this.option("validationBoundary"),
                        rtlEnabled: this.option("rtlEnabled")
                    }, this._options.cache("validationTooltipOptions")));
                    this._bindInnerWidgetOptions(this._validationMessage, "validationTooltipOptions")
                }
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _toggleReadOnlyState: function() {
                var readOnly = this.option("readOnly");
                this._toggleBackspaceHandler(readOnly);
                this.$element().toggleClass(READONLY_STATE_CLASS, !!readOnly);
                this.setAria("readonly", readOnly || void 0)
            },
            _toggleBackspaceHandler: function(isReadOnly) {
                var $eventTarget = this._keyboardEventBindingTarget();
                var eventName = (0, _index.addNamespace)("keydown", READONLY_NAMESPACE);
                _events_engine.default.off($eventTarget, eventName);
                if (isReadOnly) {
                    _events_engine.default.on($eventTarget, eventName, function(e) {
                        if ("backspace" === (0, _index.normalizeKeyName)(e)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _dispose: function() {
                var element = this.$element()[0];
                (0, _element_data.data)(element, VALIDATION_TARGET, null);
                clearTimeout(this.showValidationMessageTimeout);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _setValidationMessageOption: function(_ref) {
                var _this$_validationMess;
                var name = _ref.name,
                    value = _ref.value;
                var optionKey = VALIDATION_MESSAGE_KEYS_MAP[name] ? VALIDATION_MESSAGE_KEYS_MAP[name] : name;
                null === (_this$_validationMess = this._validationMessage) || void 0 === _this$_validationMess ? void 0 : _this$_validationMess.option(optionKey, value)
            },
            _optionChanged: function(args) {
                var _this$_validationMess2;
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        null === (_this$_validationMess2 = this._validationMessage) || void 0 === _this$_validationMess2 ? void 0 : _this$_validationMess2.updateMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    case "isValid":
                    case "validationError":
                    case "validationErrors":
                    case "validationStatus":
                        this.option(_validation_engine.default.synchronizeValidationOptions(args, this.option()));
                        this._renderValidationState();
                        break;
                    case "validationBoundary":
                    case "validationMessageMode":
                    case "validationMessageOffset":
                        this._setValidationMessageOption(args);
                        break;
                    case "rtlEnabled":
                        this._setValidationMessageOption(args);
                        this.callBase(args);
                        break;
                    case "validationTooltipOptions":
                        this._innerWidgetOptionChanged(this._validationMessage, args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        });
        var _default = Editor;
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/visibility_change.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.triggerResizeEvent = exports.triggerHidingEvent = exports.triggerShownEvent = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 5));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = (0, _renderer.default)(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    _events_engine.default.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerShownEvent = triggerShownEvent;
        var triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerHidingEvent = triggerHidingEvent;
        var triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.triggerResizeEvent = triggerResizeEvent
    },
    /*!*****************************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/collection/ui.collection_widget.edit.js ***!
      \*****************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _uiCollection_widget = _interopRequireDefault(__webpack_require__( /*! ./ui.collection_widget.base */ 544));
        var _ui = _interopRequireDefault(__webpack_require__( /*! ../widget/ui.errors */ 17));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _uiCollection_widgetEditStrategy = _interopRequireDefault(__webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 204));
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 69);
        var _utils = __webpack_require__( /*! ../../data/data_source/utils */ 70);
        var _selection = _interopRequireDefault(__webpack_require__( /*! ../selection/selection */ 234));
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting";
        var NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = _uiCollection_widget.default.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule()
            },
            _initKeyGetter: function() {
                this._keyGetter = (0, _data.compileGetter)(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            key: function() {
                if (this.option("keyExpr")) {
                    return this.option("keyExpr")
                }
                return this._dataSource && this._dataSource.key()
            },
            keyOf: function(item) {
                var key = item;
                var store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _nullValueSelectionSupported: function() {
                return false
            },
            _initSelectionModule: function() {
                var that = this;
                var itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new _selection.default({
                    allowNullValue: this._nullValueSelectionSupported(),
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: that.key.bind(that),
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        if (store) {
                            return store.load(options).done(function(loadResult) {
                                if (that._disposed) {
                                    return
                                }
                                var items = (0, _utils.normalizeLoadResult)(loadResult).data;
                                that._dataSource._applyMapFunction(items)
                            })
                        } else {
                            return (new _deferred.Deferred).resolve(this.plainItems())
                        }
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = _uiCollection_widgetEditStrategy.default;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this;
                var indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                (0, _iterator.each)(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                var _this = this;
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions().done(function() {
                        return _this._normalizeSelectedItems()
                    })
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem;
                var selectedIndex;
                var selectedItemKeys;
                var selectedItems;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedItem", selectedItem);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = selectedItems.length ? this._editStrategy.getIndexByItemData(selectedItems[0]) : NOT_EXISTING_INDEX;
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        this._setOptionWithoutOptionChange("selectedItem", selectedItems[0]);
                        this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                        this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired")) {
                            var selectedItemIndex = this._getIndexByKey(selectedItemKeys[0]);
                            if (!indexExists(selectedItemIndex)) {
                                return this._syncSelectionOptions("selectedIndex")
                            }
                        }
                        return this._selection.setSelection(selectedItemKeys)
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName);
                    var length = (0, _type.isDefined)(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionWithoutOptionChange("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionWithoutOptionChange("selectedItems", [normalizedSelection]);
                            return this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: (0, _renderer.default)(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" !== this.option("selectionMode")) {
                    var $itemElement = (0, _renderer.default)(args.itemElement);
                    var normalizedItemIndex = this._editStrategy.getNormalizedIndex($itemElement);
                    var isItemSelected = this._isItemSelected(normalizedItemIndex);
                    this._processSelectableItem($itemElement, isItemSelected)
                }
            },
            _processSelectableItem: function($itemElement, isSelected) {
                $itemElement.toggleClass(this._selectedItemClass(), isSelected);
                this._setAriaSelected($itemElement, String(isSelected))
            },
            _updateSelectedItems: function(args) {
                var that = this;
                var addedItemKeys = args.addedItemKeys;
                var removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var addedSelection = [];
                        var normalizedIndex;
                        var removedSelection = [];
                        that._editStrategy.beginCache();
                        for (var i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (var _i = 0; _i < removedItemKeys.length; _i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[_i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }(0, _deferred.when)(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: _common.noop,
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, false);
                    _events_engine.default.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, true);
                    _events_engine.default.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                var _this2 = this;
                switch (args.name) {
                    case "selectionMode":
                        this._invalidate();
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name).done(function() {
                            return _this2._normalizeSelectedItems()
                        });
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionWithoutOptionChange("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new _deferred.Deferred;
                var deletingActionArgs = {
                    cancel: false
                };
                var deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                    excludeValidators: ["disabled", "readOnly"]
                });
                (0, _deferred.when)(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise;
                    var deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state();
                    var argumentsSpecified = !!arguments.length;
                    var shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    (0, _deferred.when)((0, _deferred.fromPromise)(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                var deferred = new _deferred.Deferred;
                var disabledState = this.option("disabled");
                var dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw _ui.default.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new _deferred.Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    (0, _renderer.default)(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof _data_source.DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys") || [];
                    this._selection.setSelection([].concat(_toConsumableArray(selectedItemKeys), [key]))
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            _deleteItemElementByIndex: function(index) {
                this._updateSelectionAfterDelete(index);
                this._updateIndicesAfterIndex(index);
                this._editStrategy.deleteItemAtIndex(index)
            },
            _afterItemElementDeleted: function($item, deletedActionArgs) {
                var changingOption = this._dataSource ? "dataSource" : "items";
                this._simulateOptionChange(changingOption);
                this._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                    beforeExecute: function() {
                        $item.remove()
                    },
                    excludeValidators: ["disabled", "readOnly"]
                });
                this._renderEmptyMessage()
            },
            deleteItem: function(itemElement) {
                var that = this;
                var deferred = new _deferred.Deferred;
                var $item = this._editStrategy.getItemElement(itemElement);
                var index = this._editStrategy.getNormalizedIndex(itemElement);
                var itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._deleteItemElementByIndex(index);
                            that._afterItemElementDeleted($item, deletedActionArgs);
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new _deferred.Deferred;
                var that = this;
                var strategy = this._editStrategy;
                var $movingItem = strategy.getItemElement(itemElement);
                var $destinationItem = strategy.getItemElement(toItemElement);
                var movingIndex = strategy.getNormalizedIndex(itemElement);
                var destinationIndex = strategy.getNormalizedIndex(toItemElement);
                var changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        var _default = CollectionWidget;
        exports.default = _default;
        module.exports = exports.default
    }, ,
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/themes.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getTheme = getTheme;
        exports.currentTheme = currentTheme;
        exports.registerTheme = registerTheme;
        exports.registerThemeSchemeAlias = registerThemeSchemeAlias;
        exports.addCacheItem = addCacheItem;
        exports.removeCacheItem = removeCacheItem;
        exports.refreshTheme = refreshTheme;
        var _extend2 = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _utils = __webpack_require__( /*! ./core/utils */ 12);
        var _themes = __webpack_require__( /*! ../ui/themes */ 34);
        var themes = {};
        var themesMapping = {};
        var themesSchemeMapping = {};
        var _extend = _extend2.extend;
        var _each = _iterator.each;
        var currentThemeName = null;
        var defaultTheme;
        var nextCacheUid = 0;
        var widgetsCache = {};

        function getTheme(themeName) {
            var name = (0, _utils.normalizeEnum)(themeName);
            return themes[name] || themes[themesMapping[name] || currentTheme()]
        }

        function findThemeNameByName(name, scheme) {
            return themesMapping[name + "." + scheme] || themesSchemeMapping[name + "." + scheme] || themesMapping[name]
        }

        function findThemeNameByPlatform(platform, version, scheme) {
            return findThemeNameByName(platform + version, scheme) || findThemeNameByName(platform, scheme)
        }

        function currentTheme(themeName, colorScheme) {
            if (!arguments.length) {
                return currentThemeName || findThemeNameByName((0, _themes.current)()) || defaultTheme
            }
            var scheme = (0, _utils.normalizeEnum)(colorScheme);
            currentThemeName = (themeName && themeName.platform ? findThemeNameByPlatform((0, _utils.normalizeEnum)(themeName.platform), themeName.version, scheme) : findThemeNameByName((0, _utils.normalizeEnum)(themeName), scheme)) || currentThemeName;
            return this
        }

        function getThemeInfo(themeName, splitter) {
            var k = themeName.indexOf(splitter);
            return k > 0 ? {
                name: themeName.substring(0, k),
                scheme: themeName.substring(k + 1)
            } : null
        }

        function registerThemeName(themeName, targetThemeName) {
            var themeInfo = getThemeInfo(themeName, ".") || {
                name: themeName
            };
            var name = themeInfo.name;
            var scheme = themeInfo.scheme;
            if (scheme) {
                themesMapping[name] = themesMapping[name] || targetThemeName;
                themesMapping[name + "." + scheme] = targetThemeName
            } else {
                themesMapping[name] = targetThemeName
            }
        }

        function registerTheme(theme, baseThemeName) {
            var themeName = (0, _utils.normalizeEnum)(theme && theme.name);
            if (themeName) {
                theme.isDefault && (defaultTheme = themeName);
                registerThemeName(themeName, themeName);
                themes[themeName] = _extend(true, {}, getTheme(baseThemeName), patchTheme(theme))
            }
        }

        function registerThemeSchemeAlias(from, to) {
            themesSchemeMapping[from] = to
        }

        function mergeScalar(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value && void 0 === target[field]) {
                target[field] = _value
            }
        }

        function mergeObject(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value) {
                target[field] = _extend(true, {}, _value, target[field])
            }
        }

        function patchTheme(theme) {
            theme = _extend(true, {
                loadingIndicator: {
                    font: {}
                },
                "export": {
                    font: {}
                },
                legend: {
                    font: {},
                    border: {}
                },
                title: {
                    font: {}
                },
                tooltip: {
                    font: {}
                },
                "chart:common": {},
                "chart:common:axis": {
                    grid: {},
                    minorGrid: {},
                    tick: {},
                    minorTick: {},
                    title: {
                        font: {}
                    },
                    label: {
                        font: {}
                    }
                },
                "chart:common:annotation": {
                    font: {},
                    border: {}
                },
                chart: {
                    commonSeriesSettings: {
                        candlestick: {}
                    }
                },
                pie: {},
                polar: {},
                gauge: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    }
                },
                barGauge: {},
                funnel: {},
                sankey: {},
                map: {
                    background: {}
                },
                treeMap: {
                    tile: {
                        selectionStyle: {
                            border: {}
                        }
                    },
                    group: {
                        border: {},
                        selectionStyle: {
                            border: {}
                        },
                        label: {
                            font: {}
                        }
                    }
                },
                rangeSelector: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    },
                    chart: {}
                },
                sparkline: {},
                bullet: {}
            }, theme);
            mergeScalar(theme.loadingIndicator, "backgroundColor", theme);
            mergeScalar(theme.chart.commonSeriesSettings.candlestick, "innerColor", null, theme.backgroundColor);
            mergeScalar(theme.map.background, "color", null, theme.backgroundColor);
            mergeScalar(theme.title.font, "color", null, theme.primaryTitleColor);
            mergeObject(theme.title, "subtitle", null, theme.title);
            mergeScalar(theme.legend.font, "color", null, theme.secondaryTitleColor);
            mergeScalar(theme.legend.border, "color", null, theme.gridColor);
            patchAxes(theme);
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sparkline", "bullet", "sankey"], function(_, section) {
                mergeScalar(theme[section], "redrawOnResize", theme);
                mergeScalar(theme[section], "containerBackgroundColor", null, theme.backgroundColor);
                mergeObject(theme[section], "tooltip", theme);
                mergeObject(theme[section], "export", theme)
            });
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sankey"], function(_, section) {
                mergeObject(theme[section], "loadingIndicator", theme);
                mergeObject(theme[section], "legend", theme);
                mergeObject(theme[section], "title", theme)
            });
            _each(["chart", "pie", "polar"], function(_, section) {
                mergeObject(theme, section, null, theme["chart:common"])
            });
            _each(["chart", "polar"], function(_, section) {
                theme[section] = theme[section] || {};
                mergeObject(theme[section], "commonAxisSettings", null, theme["chart:common:axis"])
            });
            _each(["chart", "polar", "map", "pie"], function(_, section) {
                theme[section] = theme[section] || {};
                mergeObject(theme[section], "commonAnnotationSettings", null, theme["chart:common:annotation"])
            });
            mergeObject(theme.rangeSelector.chart, "commonSeriesSettings", theme.chart);
            mergeObject(theme.rangeSelector.chart, "dataPrepareSettings", theme.chart);
            mergeScalar(theme.treeMap.group.border, "color", null, theme.gridColor);
            mergeScalar(theme.treeMap.tile.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.treeMap.group.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.map.legend, "backgroundColor", theme);
            patchMapLayers(theme);
            return theme
        }

        function patchAxes(theme) {
            var commonAxisSettings = theme["chart:common:axis"];
            var colorFieldName = "color";
            _each([commonAxisSettings.grid, commonAxisSettings.minorGrid], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.gridColor)
            });
            _each([commonAxisSettings, commonAxisSettings.tick, commonAxisSettings.minorTick, commonAxisSettings.label.font], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.axisColor)
            });
            mergeScalar(commonAxisSettings.title.font, colorFieldName, null, theme.secondaryTitleColor);
            mergeScalar(theme.gauge.scale.label.font, colorFieldName, null, theme.axisColor);
            mergeScalar(theme.gauge.scale.tick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.gauge.scale.minorTick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.rangeSelector.scale.label.font, colorFieldName, null, theme.axisColor)
        }

        function patchMapLayers(theme) {
            var map = theme.map;
            _each(["area", "line", "marker"], function(_, section) {
                mergeObject(map, "layer:" + section, null, map.layer)
            });
            _each(["dot", "bubble", "pie", "image"], function(_, section) {
                mergeObject(map, "layer:marker:" + section, null, map["layer:marker"])
            })
        }

        function addCacheItem(target) {
            var cacheUid = ++nextCacheUid;
            target._cache = cacheUid;
            widgetsCache[cacheUid] = target
        }

        function removeCacheItem(target) {
            delete widgetsCache[target._cache]
        }

        function refreshTheme() {
            _each(widgetsCache, function() {
                this.refresh()
            });
            return this
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/icon.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.getImageContainer = exports.getImageSourceType = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ICON_CLASS = "dx-icon";
        var SVG_ICON_CLASS = "dx-svg-icon";
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(source)) {
                return "svg"
            }
            if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            if (/^\s?([\w-_]\s?)+$/.test(source)) {
                return "fontIcon"
            }
            return false
        };
        exports.getImageSourceType = getImageSourceType;
        var getImageContainer = function(source) {
            switch (getImageSourceType(source)) {
                case "image":
                    return (0, _renderer.default)("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(source));
                case "dxIcon":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(ICON_CLASS, "-").concat(source));
                case "svg":
                    return (0, _renderer.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(SVG_ICON_CLASS)).append(source);
                default:
                    return null
            }
        };
        exports.getImageContainer = getImageContainer
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/date_serialization.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 31));
        var _date = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 242);
        var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ../../localization/default_date_names */ 243));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ./browser */ 22));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var NUMBER_SERIALIZATION_FORMAT = "number";
        var DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd";
        var DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var DATE_SERIALIZATION_PATTERN = /^(\d{4})\/(\d{2})\/(\d{2})$/;
        var MILLISECOND_LENGHT = 3;
        var isIE11 = _browser.default.msie && parseInt(_browser.default.version) <= 11;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            if ((0, _type.isString)(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            return result || parseDate(text)
        };

        function getTimePart(part) {
            return +part || 0
        }

        function parseDate(text) {
            var isDefaultSerializationFormat = getDateSerializationFormat(text) === DATE_SERIALIZATION_FORMAT;
            var parsedValue = !(0, _type.isDate)(text) && Date.parse(text);
            if ((!parsedValue || isIE11) && isDefaultSerializationFormat) {
                var parts = text.match(DATE_SERIALIZATION_PATTERN);
                if (parts) {
                    var newDate = new Date(getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[3]));
                    newDate.setFullYear(getTimePart(parts[1]));
                    newDate.setMonth(getTimePart(parts[2]) - 1);
                    newDate.setDate(getTimePart(parts[3]));
                    return newDate
                }
            }
            return (0, _type.isNumeric)(parsedValue) ? new Date(parsedValue) : text
        }

        function parseISO8601String(text) {
            var parts = text.match(ISO8601_PATTERN);
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[4]))
                }
                return
            }
            var year = parts[1];
            var month = --parts[3];
            var day = parts[5];
            var timeZoneHour = 0;
            var timeZoneMinute = 0;
            timeZoneHour = getTimePart(parts[14]);
            timeZoneMinute = getTimePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = getTimePart(parts[6]) - timeZoneHour;
            var minute = getTimePart(parts[8]) - timeZoneMinute;
            var second = getTimePart(parts[10]);
            var parseMilliseconds = function(part) {
                part = part || "";
                return getTimePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
            };
            var millisecond = parseMilliseconds(parts[11]);
            if (parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        }
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN);
            var result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !(0, _config.default)().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!(0, _type.isDate)(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return (0, _date.getFormatter)(serializationFormat, _default_date_names.default)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if ((0, _type.isString)(value)) {
                    var format;
                    if ((0, _config.default)().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        var _default = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/dependency_injector.js ***!
      \********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = _default;
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _class = _interopRequireDefault(__webpack_require__( /*! ../class */ 15));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _default(object) {
            var BaseClass = _class.default.inherit(object);
            var InjectedClass = BaseClass;
            var instance = new InjectedClass(object);
            var initialFields = {};
            var injectFields = function(injectionObject, initial) {
                (0, _iterator.each)(injectionObject, function(key) {
                    if ((0, _type.isFunction)(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                (0, _extend.extend)(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
        module.exports = exports.default
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    }, ,
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/version.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = compare;

        function compare(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10);
                var yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    }, , ,
    /*!************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/overlay.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _ui = _interopRequireDefault(__webpack_require__( /*! ./overlay/ui.overlay */ 327));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = _ui.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/bindable_template.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.BindableTemplate = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _template_base = __webpack_require__( /*! ./template_base */ 75);
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _remove_event = _interopRequireDefault(__webpack_require__( /*! ../remove_event */ 150));
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var watchChanges = function() {
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {};
                var missedFields = fields.slice();
                var watchHandlers = fields.map(function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    watchHandlers.forEach(function(dispose) {
                        return dispose()
                    })
                }
            };
            return function(rawData, watchMethod, fields, fieldsMap, callback) {
                var fieldsDispose;
                var globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if ((0, _type.isPrimitive)(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            }
        }();
        var BindableTemplate = function(_TemplateBase) {
            _inherits(BindableTemplate, _TemplateBase);
            var _super = _createSuper(BindableTemplate);

            function BindableTemplate(render, fields, watchMethod, fieldsMap) {
                var _this;
                _classCallCheck(this, BindableTemplate);
                _this = _super.call(this);
                _this._render = render;
                _this._fields = fields;
                _this._fieldsMap = fieldsMap || {};
                _this._watchMethod = watchMethod;
                return _this
            }
            _createClass(BindableTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    var _this2 = this;
                    var $container = (0, _renderer.default)(options.container);
                    var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                        $container.empty();
                        _this2._render($container, data, options.model)
                    });
                    _events_engine.default.on($container, _remove_event.default, dispose);
                    return $container.contents()
                }
            }]);
            return BindableTemplate
        }(_template_base.TemplateBase);
        exports.BindableTemplate = BindableTemplate
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/dom_component.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/resize_callbacks */ 125));
        var _component = _interopRequireDefault(__webpack_require__( /*! ./component */ 127));
        var _template_manager = __webpack_require__( /*! ./template_manager */ 516);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);
        var _element_data = __webpack_require__( /*! ./element_data */ 40);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _element = __webpack_require__( /*! ../core/element */ 18);
        var _common = __webpack_require__( /*! ./utils/common */ 4);
        var _array = __webpack_require__( /*! ./utils/array */ 13);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _short = __webpack_require__( /*! ../events/short */ 128);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _component.default.abstract;
        var DOMComponent = _component.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: (0, _config.default)().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                }, this._useTemplates() ? _template_manager.TemplateManager.createDefaultOptions() : {})
            },
            ctor: function(element, options) {
                this._createElement(element);
                (0, _public_component.attachInstanceToElement)(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _createElement: function(element) {
                this._$element = (0, _renderer.default)(element)
            },
            _getSynchronizableOptionsForCreateComponent: function() {
                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback();
                this._initTemplateManager()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    _resize_callbacks.default.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                (0, _window.hasWindow)() && this._render()
            },
            _initMarkup: function() {
                var _ref = this.option() || {},
                    rtlEnabled = _ref.rtlEnabled;
                this._renderElementAttributes();
                this._toggleRTLDirection(rtlEnabled);
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var _ref2 = this.option() || {},
                    elementAttr = _ref2.elementAttr;
                var attributes = (0, _extend.extend)({}, elementAttr);
                var classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (this._isVisibilityChangeSupported()) {
                    var $element = this.$element();
                    $element.addClass("dx-visibility-change-handler")
                }
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: null === width ? "" : width,
                        height: null === height ? "" : height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!((0, _type.isDefined)(width) || (0, _type.isDefined)(height) || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var _this = this;
                var $el = this.$element();
                var namespace = "".concat(this.NAME, "VisibilityChange");
                _short.resize.off($el, {
                    namespace: namespace
                });
                _short.resize.on($el, function() {
                    return _this._dimensionChanged()
                }, {
                    namespace: namespace
                })
            },
            _attachVisibilityChangeHandlers: function() {
                var _this2 = this;
                if (this._isVisibilityChangeSupported()) {
                    var $el = this.$element();
                    var namespace = "".concat(this.NAME, "VisibilityChange");
                    this._isHidden = !this._isVisible();
                    _short.visibility.off($el, {
                        namespace: namespace
                    });
                    _short.visibility.on($el, function() {
                        return _this2._checkVisibilityChanged("shown")
                    }, function() {
                        return _this2._checkVisibilityChanged("hiding")
                    }, {
                        namespace: namespace
                    })
                }
            },
            _isVisible: function() {
                var $element = this.$element();
                return $element.is(":visible")
            },
            _checkVisibilityChanged: function(action) {
                var isVisible = this._isVisible();
                if (isVisible) {
                    if ("hiding" === action && !this._isHidden) {
                        this._visibilityChanged(false);
                        this._isHidden = true
                    } else {
                        if ("shown" === action && this._isHidden) {
                            this._isHidden = false;
                            this._visibilityChanged(true)
                        }
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && (0, _window.hasWindow)()
            },
            _clean: _common.noop,
            _modelByElement: function() {
                var _this$option = this.option(),
                    modelByElement = _this$option.modelByElement;
                var $element = this.$element();
                return modelByElement ? modelByElement($element) : void 0
            },
            _invalidate: function() {
                if (this._isUpdateAllowed()) {
                    throw _errors.default.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this._templateManager && this._templateManager.dispose();
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    _resize_callbacks.default.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                var $element = this.$element();
                $element.toggleClass("dx-rtl", rtl)
            },
            _createComponent: function(element, component) {
                var _this3 = this;
                var config = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                var synchronizableOptions = (0, _common.grep)(this._getSynchronizableOptionsForCreateComponent(), function(value) {
                    return !(value in config)
                });
                var _this$option2 = this.option(),
                    integrationOptions = _this$option2.integrationOptions;
                var _this$option3 = this.option(),
                    nestedComponentOptions = _this$option3.nestedComponentOptions;
                nestedComponentOptions = nestedComponentOptions || _common.noop;
                var nestedComponentConfig = (0, _extend.extend)({
                    integrationOptions: integrationOptions
                }, nestedComponentOptions(this));
                synchronizableOptions.forEach(function(optionName) {
                    return nestedComponentConfig[optionName] = _this3.option(optionName)
                });
                this._extendConfig(config, nestedComponentConfig);
                var instance = void 0;
                if ((0, _type.isString)(component)) {
                    var $element = (0, _renderer.default)(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(_ref3) {
                        var name = _ref3.name,
                            value = _ref3.value;
                        if ((0, _array.inArray)(name, synchronizableOptions) >= 0) {
                            instance.option(name, value)
                        }
                    };
                    this.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        return _this3.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                (0, _iterator.each)(extendConfig, function(key, value) {
                    !Object.prototype.hasOwnProperty.call(config, key) && (config[key] = value)
                })
            },
            _defaultActionConfig: function() {
                var $element = this.$element();
                var context = this._modelByElement($element);
                return (0, _extend.extend)(this.callBase(), {
                    context: context
                })
            },
            _defaultActionArgs: function() {
                var $element = this.$element();
                var model = this._modelByElement($element);
                var element = this.element();
                return (0, _extend.extend)(this.callBase(), {
                    element: element,
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                        this._invalidate();
                        break;
                    case "elementAttr":
                        this._renderElementAttributes();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var attrs = element.attributes;
                for (var i = attrs.length - 1; i >= 0; i--) {
                    var attr = attrs[i];
                    if (attr) {
                        var name = attr.name;
                        if (!name.indexOf("aria-") || name.indexOf("dx-") !== -1 || "role" === name || "style" === name || "tabindex" === name) {
                            element.removeAttribute(name)
                        }
                    }
                }
            },
            _removeClasses: function(element) {
                element.className = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                }).join(" ")
            },
            _updateDOMComponent: function(renderRequired) {
                if (renderRequired) {
                    this._renderComponent()
                } else {
                    if (this._requireRefresh) {
                        this._requireRefresh = false;
                        this._refresh()
                    }
                }
            },
            endUpdate: function() {
                var renderRequired = this._isInitializingRequired();
                this.callBase();
                this._isUpdateAllowed() && this._updateDOMComponent(renderRequired)
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                var $element = this.$element();
                return (0, _element.getPublicElement)($element)
            },
            dispose: function() {
                var element = this.$element().get(0);
                (0, _element_data.cleanDataRecursive)(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            },
            resetOption: function(optionName) {
                this.callBase(optionName);
                if ("width" === optionName || "height" === optionName) {
                    var initialOption = this.initialOption(optionName);
                    !(0, _type.isDefined)(initialOption) && this.$element().css(optionName, "")
                }
            },
            _getAnonymousTemplateName: function() {
                return
            },
            _initTemplateManager: function() {
                if (this._templateManager || !this._useTemplates()) {
                    return
                }
                var _this$option4 = this.option(),
                    _this$option4$integra = _this$option4.integrationOptions,
                    integrationOptions = void 0 === _this$option4$integra ? {} : _this$option4$integra;
                var createTemplate = integrationOptions.createTemplate;
                this._templateManager = new _template_manager.TemplateManager(createTemplate, this._getAnonymousTemplateName());
                this._initTemplates()
            },
            _initTemplates: function() {
                var _this4 = this;
                var _this$_templateManage = this._templateManager.extractTemplates(this.$element()),
                    templates = _this$_templateManage.templates,
                    anonymousTemplateMeta = _this$_templateManage.anonymousTemplateMeta;
                var anonymousTemplate = this.option("integrationOptions.templates.".concat(anonymousTemplateMeta.name));
                templates.forEach(function(_ref4) {
                    var name = _ref4.name,
                        template = _ref4.template;
                    _this4._options.silent("integrationOptions.templates.".concat(name), template)
                });
                if (anonymousTemplateMeta.name && !anonymousTemplate) {
                    this._options.silent("integrationOptions.templates.".concat(anonymousTemplateMeta.name), anonymousTemplateMeta.template);
                    this._options.silent("_hasAnonymousTemplateContent", true)
                }
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                var templates = this.option("integrationOptions.templates");
                var isAsyncTemplate = this.option("templatesRenderAsynchronously");
                var skipTemplates = this.option("integrationOptions.skipTemplates");
                return this._templateManager.getTemplate(templateSource, templates, {
                    isAsyncTemplate: isAsyncTemplate,
                    skipTemplates: skipTemplates
                }, this)
            },
            _saveTemplate: function(name, template) {
                this._setOptionWithoutOptionChange("integrationOptions.templates." + name, this._templateManager._createTemplate(template))
            },
            _useTemplates: function() {
                return true
            }
        });
        DOMComponent.getInstance = function(element) {
            return (0, _public_component.getInstanceByElement)((0, _renderer.default)(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        var _default = DOMComponent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled-npm/data/data_source/data_source.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.DataSource = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));
        var _array_utils = __webpack_require__( /*! ../array_utils */ 91);
        var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 130));
        var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 98);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 38));
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _queue = __webpack_require__( /*! ../../core/utils/queue */ 252);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _operation_manager = _interopRequireDefault(__webpack_require__( /*! ./operation_manager */ 545));
        var _utils2 = __webpack_require__( /*! ./utils */ 70);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DataSource = _class.default.inherit({
            ctor: function(options) {
                var _options$reshapeOnPus, _this = this;
                options = (0, _utils2.normalizeDataSourceOptions)(options);
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                var onPushHandler = 0 !== options.pushAggregationTimeout ? _utils.default.throttleChanges(this._onPush, function() {
                    return void 0 === options.pushAggregationTimeout ? 5 * _this._changedTime : options.pushAggregationTimeout
                }) : this._onPush;
                this._changedTime = 0;
                this._onPushHandler = function(changes) {
                    _this._aggregationTimeoutId = onPushHandler.call(_this, changes)
                };
                this._store = options.store;
                this._store.on("push", this._onPushHandler);
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                this._reshapeOnPush = null !== (_options$reshapeOnPus = options.reshapeOnPush) && void 0 !== _options$reshapeOnPus ? _options$reshapeOnPus : false;
                (0, _iterator.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        _this.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new _operation_manager.default;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!(0, _type.isDefined)(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                var _this$_delayedLoadTas;
                this._store.off("push", this._onPushHandler);
                this._eventsStrategy.dispose();
                clearTimeout(this._aggregationTimeoutId);
                delete this._store;
                null === (_this$_delayedLoadTas = this._delayedLoadTask) || void 0 === _this$_delayedLoadTas ? void 0 : _this$_delayedLoadTas.abort();
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {};
                var names = ["sort", "filter", "select", "group", "requireTotalCount"];
                var customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }(0, _iterator.each)(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!(0, _type.isNumeric)(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!(0, _type.isNumeric)(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            generateStoreLoadOptionAccessor: function(optionName) {
                var _this2 = this;
                return function(args) {
                    var normalizedArgs = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(args);
                    if (void 0 === normalizedArgs) {
                        return _this2._storeLoadOptions[optionName]
                    }
                    _this2._storeLoadOptions[optionName] = normalizedArgs
                }
            },
            sort: function() {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key]
                }
                return this.generateStoreLoadOptionAccessor("sort")(args)
            },
            filter: function() {
                var newFilter = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: function() {
                for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                    args[_key2] = arguments[_key2]
                }
                return this.generateStoreLoadOptionAccessor("group")(args)
            },
            select: function() {
                for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                    args[_key3] = arguments[_key3]
                }
                return this.generateStoreLoadOptionAccessor("select")(args)
            },
            requireTotalCount: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!(0, _type.isString)(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                var _this$_store;
                return null === (_this$_store = this._store) || void 0 === _this$_store ? void 0 : _this$_store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return (0, _queue.create)()
            },
            _changeLoadingCount: function(increment) {
                var oldLoading = this.isLoading();
                this._loadingCount += increment;
                var newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this._eventsStrategy.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var _this3 = this;
                this.beginLoading();
                deferred.always(function() {
                    _this3.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var _this4 = this;
                deferred.fail(function() {
                    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                        args[_key4] = arguments[_key4]
                    }
                    if (args[0] === _utils2.CANCELED_TOKEN) {
                        return
                    }
                    _this4._eventsStrategy.fireEvent("loadError", args)
                })
            },
            _fireChanged: function(args) {
                var date = new Date;
                this._eventsStrategy.fireEvent("changed", args);
                this._changedTime = new Date - date
            },
            _scheduleChangedCallbacks: function(deferred) {
                var _this5 = this;
                deferred.done(function() {
                    return _this5._fireChanged()
                })
            },
            loadSingle: function(propName, propValue) {
                var _this6 = this;
                var d = new _deferred.Deferred;
                var key = this.key();
                var store = this._store;
                var options = this._createStoreLoadOptions();
                var handleDone = function(data) {
                    if (!(0, _type.isDefined)(data) || (0, _array.isEmpty)(data)) {
                        d.reject(new _errors.default.errors.Error("E4009"))
                    } else {
                        if (!Array.isArray(data)) {
                            data = [data]
                        }
                        d.resolve(_this6._applyMapFunction(data)[0])
                    }
                };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;
                var shouldForceByKey = function() {
                    return store instanceof _custom_store.default && !store._byKeyViaLoad()
                };
                (function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var _this7 = this;
                var d = new _deferred.Deferred;
                var loadTask = function() {
                    if (_this7._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(d)) {
                        return
                    }
                    return _this7._loadFromStore(loadOperation, d)
                };
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                var loadOperation = this._createLoadOperation(d);
                this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        _this7._delayedLoadTask = (0, _common.executeAsync)(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _onPush: function(changes) {
                var _this8 = this;
                if (this._reshapeOnPush) {
                    this.load()
                } else {
                    this._eventsStrategy.fireEvent("changing", [{
                        changes: changes
                    }]);
                    var group = this.group();
                    var items = this.items();
                    var groupLevel = 0;
                    var dataSourceChanges = this.paginate() || group ? changes.filter(function(item) {
                        return "update" === item.type
                    }) : changes;
                    if (group) {
                        groupLevel = Array.isArray(group) ? group.length : 1
                    }
                    if (this._mapFunc) {
                        dataSourceChanges.forEach(function(item) {
                            if ("insert" === item.type) {
                                item.data = _this8._mapFunc(item.data)
                            }
                        })
                    }(0, _array_utils.applyBatch)({
                        keyInfo: this.store(),
                        data: items,
                        changes: dataSourceChanges,
                        groupCount: groupLevel,
                        useInsertIndex: true
                    });
                    this._fireChanged([{
                        changes: changes
                    }])
                }
            },
            _createLoadOperation: function(deferred) {
                var _this9 = this;
                var operationId = this._operationManager.add(deferred);
                var storeLoadOptions = this._createStoreLoadOptions();
                deferred.always(function() {
                    return _this9._operationManager.remove(operationId)
                });
                return {
                    operationId: operationId,
                    storeLoadOptions: storeLoadOptions
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof _custom_store.default) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            cancelAll: function() {
                return this._operationManager.cancelAll()
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = (0, _extend.extend)({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue;
                var op = this._searchOperation;
                var selector = this._searchExpr;
                var searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }(0, _iterator.each)(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var _this10 = this;
                var handleSuccess = function(data, extra) {
                    if (_this10._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(pendingDeferred)) {
                        return
                    }
                    var loadResult = (0, _extend.extend)((0, _utils2.normalizeLoadResult)(data, extra), loadOptions);
                    _this10._eventsStrategy.fireEvent("customizeLoadResult", [loadResult]);
                    (0, _deferred.when)(loadResult.data).done(function(data) {
                        loadResult.data = data;
                        _this10._processStoreLoadResult(loadResult, pendingDeferred)
                    }).fail(pendingDeferred.reject)
                };
                if (loadOptions.data) {
                    return (new _deferred.Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var _this11 = this;
                var data = loadResult.data;
                var extra = loadResult.extra;
                var storeLoadOptions = loadResult.storeLoadOptions;
                var resolvePendingDeferred = function() {
                    _this11._isLoaded = true;
                    _this11._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                };
                var proceedLoadingTotalCount = function() {
                    _this11.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                };
                if (this._disposed) {
                    return
                }
                data = this._applyPostProcessFunction(this._applyMapFunction(data));
                if (!(0, _type.isPlainObject)(extra)) {
                    extra = {}
                }
                this._items = data;
                if (!data.length || !this._paginate || this._pageSize && data.length < this._pageSize) {
                    this._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return (0, _utils2.mapDataRespectingGrouping)(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        exports.DataSource = DataSource
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled-npm/data/data_source/utils.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.normalizeDataSourceOptions = exports.normalizeLoadResult = exports.mapDataRespectingGrouping = exports.normalizeStoreLoadOptionAccessorArguments = exports.isPending = exports.CANCELED_TOKEN = void 0;
        var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 80));
        var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../abstract_store */ 104));
        var _array_store = _interopRequireDefault(__webpack_require__( /*! ../array_store */ 77));
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 130));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function ownKeys(object, enumerableOnly) {
            var keys = Object.keys(object);
            if (Object.getOwnPropertySymbols) {
                var symbols = Object.getOwnPropertySymbols(object);
                if (enumerableOnly) {
                    symbols = symbols.filter(function(sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable
                    })
                }
                keys.push.apply(keys, symbols)
            }
            return keys
        }

        function _objectSpread(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = null != arguments[i] ? arguments[i] : {};
                if (i % 2) {
                    ownKeys(Object(source), true).forEach(function(key) {
                        _defineProperty(target, key, source[key])
                    })
                } else {
                    if (Object.getOwnPropertyDescriptors) {
                        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                    } else {
                        ownKeys(Object(source)).forEach(function(key) {
                            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key))
                        })
                    }
                }
            }
            return target
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }

        function _objectWithoutProperties(source, excluded) {
            if (null == source) {
                return {}
            }
            var target = _objectWithoutPropertiesLoose(source, excluded);
            var key, i;
            if (Object.getOwnPropertySymbols) {
                var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
                for (i = 0; i < sourceSymbolKeys.length; i++) {
                    key = sourceSymbolKeys[i];
                    if (excluded.indexOf(key) >= 0) {
                        continue
                    }
                    if (!Object.prototype.propertyIsEnumerable.call(source, key)) {
                        continue
                    }
                    target[key] = source[key]
                }
            }
            return target
        }

        function _objectWithoutPropertiesLoose(source, excluded) {
            if (null == source) {
                return {}
            }
            var target = {};
            var sourceKeys = Object.keys(source);
            var key, i;
            for (i = 0; i < sourceKeys.length; i++) {
                key = sourceKeys[i];
                if (excluded.indexOf(key) >= 0) {
                    continue
                }
                target[key] = source[key]
            }
            return target
        }
        var CANCELED_TOKEN = "canceled";
        exports.CANCELED_TOKEN = CANCELED_TOKEN;
        var isPending = function(deferred) {
            return "pending" === deferred.state()
        };
        exports.isPending = isPending;
        var normalizeStoreLoadOptionAccessorArguments = function(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        };
        exports.normalizeStoreLoadOptionAccessorArguments = normalizeStoreLoadOptionAccessorArguments;
        var mapGroup = function(group, level, mapper) {
            return (0, _iterator.map)(group, function(item) {
                var restItem = (item.items, _objectWithoutProperties(item, ["items"]));
                return _objectSpread(_objectSpread({}, restItem), {}, {
                    items: mapRecursive(item.items, level - 1, mapper)
                })
            })
        };
        var mapRecursive = function(items, level, mapper) {
            if (!Array.isArray(items)) {
                return items
            }
            return level ? mapGroup(items, level, mapper) : (0, _iterator.map)(items, mapper)
        };
        var mapDataRespectingGrouping = function(items, mapper, groupInfo) {
            var level = groupInfo ? _utils.default.normalizeSortingInfo(groupInfo).length : 0;
            return mapRecursive(items, level, mapper)
        };
        exports.mapDataRespectingGrouping = mapDataRespectingGrouping;
        var normalizeLoadResult = function(data, extra) {
            var _data;
            if (null === (_data = data) || void 0 === _data ? void 0 : _data.data) {
                extra = data;
                data = data.data
            }
            if (!Array.isArray(data)) {
                data = [data]
            }
            return {
                data: data,
                extra: extra
            }
        };
        exports.normalizeLoadResult = normalizeLoadResult;
        var createCustomStoreFromLoadFunc = function(options) {
            var storeConfig = {};
            (0, _iterator.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                storeConfig[this] = options[this];
                delete options[this]
            });
            return new _custom_store.default(storeConfig)
        };
        var createStoreFromConfig = function(storeConfig) {
            var alias = storeConfig.type;
            delete storeConfig.type;
            return _abstract_store.default.create(alias, storeConfig)
        };
        var createCustomStoreFromUrl = function(url, normalizationOptions) {
            return new _custom_store.default({
                load: function() {
                    return _ajax.default.sendRequest({
                        url: url,
                        dataType: "json"
                    })
                },
                loadMode: null === normalizationOptions || void 0 === normalizationOptions ? void 0 : normalizationOptions.fromUrlLoadMode
            })
        };
        var normalizeDataSourceOptions = function(options, normalizationOptions) {
            var store;
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options, normalizationOptions)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof _abstract_store.default) {
                options = {
                    store: options
                }
            } else {
                options = (0, _extend.extend)({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc(options)
            } else {
                if (Array.isArray(store)) {
                    store = new _array_store.default(store)
                } else {
                    if ((0, _type.isPlainObject)(store)) {
                        store = createStoreFromConfig((0, _extend.extend)({}, store))
                    }
                }
            }
            options.store = store;
            return options
        };
        exports.normalizeDataSourceOptions = normalizeDataSourceOptions
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/widget/selectors.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.focused = exports.tabbable = exports.focusable = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var focusableFn = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase();
            var isTabIndexNotNaN = !isNaN(tabIndex);
            var isDisabled = element.disabled;
            var isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName);
            var isHyperlink = "a" === nodeName;
            var isFocusable = true;
            var isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };

        function visible(element) {
            var $element = (0, _renderer.default)(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        }
        var focusable = function(index, element) {
            return focusableFn(element, (0, _renderer.default)(element).attr("tabIndex"))
        };
        exports.focusable = focusable;
        var tabbable = function(index, element) {
            var tabIndex = (0, _renderer.default)(element).attr("tabIndex");
            return (isNaN(tabIndex) || tabIndex >= 0) && focusableFn(element, tabIndex)
        };
        exports.tabbable = tabbable;
        var focused = function($element) {
            var element = (0, _renderer.default)($element).get(0);
            return _dom_adapter.default.getActiveElement() === element
        };
        exports.focused = focused
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled-npm/format_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ./core/utils/type */ 1);
        var _date = _interopRequireDefault(__webpack_require__( /*! ./core/utils/date */ 19));
        var _number = _interopRequireDefault(__webpack_require__( /*! ./localization/number */ 47));
        var _date2 = _interopRequireDefault(__webpack_require__( /*! ./localization/date */ 32));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./core/utils/dependency_injector */ 59));
        __webpack_require__( /*! ./localization/currency */ 113);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _dependency_injector.default)({
            format: function(value, _format) {
                var formatIsValid = (0, _type.isString)(_format) && "" !== _format || (0, _type.isPlainObject)(_format) || (0, _type.isFunction)(_format);
                var valueIsValid = (0, _type.isNumeric)(value) || (0, _type.isDate)(value);
                if (!formatIsValid || !valueIsValid) {
                    return (0, _type.isDefined)(value) ? value.toString() : ""
                }
                if ((0, _type.isFunction)(_format)) {
                    return _format(value)
                }
                if ((0, _type.isString)(_format)) {
                    _format = {
                        type: _format
                    }
                }
                if ((0, _type.isNumeric)(value)) {
                    return _number.default.format(value, _format)
                }
                if ((0, _type.isDate)(value)) {
                    return _date2.default.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return _date2.default.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [];
                var needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return _date2.default.getMonthNames("abbreviated")[date.getMonth()] + " " + _date2.default.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return _date2.default.format(date, "dayofweek") + ", " + _date2.default.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var maxDiff;
                var currentDiff;
                var i;
                if (ticks.length > 1) {
                    maxDiff = _date.default.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = _date.default.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                var resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var dateUnitInterval;
                var dateDifferencesConverter = {
                    week: "day"
                };
                var correctDateDifferences = function(dateDifferences, tickInterval, value) {
                    switch (tickInterval) {
                        case "year":
                        case "quarter":
                            dateDifferences.month = value;
                        case "month":
                            dateDifferences.day = value;
                        case "week":
                        case "day":
                            dateDifferences.hour = value;
                        case "hour":
                            dateDifferences.minute = value;
                        case "minute":
                            dateDifferences.second = value;
                        case "second":
                            dateDifferences.millisecond = value
                    }
                };
                var correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                    if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                        if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                            differences.millisecond = true;
                            differences.second = false
                        }
                    } else {
                        if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                            if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                differences.second = true;
                                differences.minute = false
                            }
                        } else {
                            if (!maxDate.getMinutes() && maxDate.getHours()) {
                                if (maxDate.getHours() - minDate.getHours() === 1) {
                                    differences.minute = true;
                                    differences.hour = false
                                }
                            } else {
                                if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                    if (maxDate.getDate() - minDate.getDate() === 1) {
                                        differences.hour = true;
                                        differences.day = false
                                    }
                                } else {
                                    if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                        if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                            differences.day = true;
                                            differences.month = false
                                        }
                                    } else {
                                        if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                            if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                differences.month = true;
                                                differences.year = false
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                tickInterval = (0, _type.isString)(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                var dateDifferences = _date.default.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = _date.default.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = _date.default.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                var resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/polyfills/promise.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var promise = (0, _window.hasWindow)() ? (0, _window.getWindow)().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new _deferred.Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new _deferred.Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new _deferred.Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return _deferred.when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        var _default = promise;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/event_registrator.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _event_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./event_registrator_callbacks */ 131));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }(0, _iterator.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            _event_registrator_callbacks.default.fire(name, strategy)
        };
        registerEvent.callbacks = _event_registrator_callbacks.default;
        var _default = registerEvent;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/template_base.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.TemplateBase = exports.renderedCallbacks = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../utils/callbacks */ 27));
        var _dom = __webpack_require__( /*! ../utils/dom */ 33);
        var _visibility_change = __webpack_require__( /*! ../../events/visibility_change */ 53);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 25));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var renderedCallbacks = (0, _callbacks.default)({
            syncStrategy: true
        });
        exports.renderedCallbacks = renderedCallbacks;
        var TemplateBase = function() {
            function TemplateBase() {
                _classCallCheck(this, TemplateBase)
            }
            _createClass(TemplateBase, [{
                key: "render",
                value: function(options) {
                    options = options || {};
                    var onRendered = options.onRendered;
                    delete options.onRendered;
                    var $result = this._renderCore(options);
                    this._ensureResultInContainer($result, options.container);
                    renderedCallbacks.fire($result, options.container);
                    onRendered && onRendered();
                    return $result
                }
            }, {
                key: "_ensureResultInContainer",
                value: function($result, container) {
                    if (!container) {
                        return
                    }
                    var $container = (0, _renderer.default)(container);
                    var resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                    $container.append($result);
                    if (resultInContainer) {
                        return
                    }
                    var resultInBody = _dom_adapter.default.getBody().contains($container.get(0));
                    if (!resultInBody) {
                        return
                    }(0, _visibility_change.triggerShownEvent)($result)
                }
            }, {
                key: "_renderCore",
                value: function() {
                    throw _errors.default.Error("E0001")
                }
            }]);
            return TemplateBase
        }();
        exports.TemplateBase = TemplateBase
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/events/drag.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        exports.drop = exports.leave = exports.enter = exports.end = exports.start = exports.move = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _element_data = __webpack_require__( /*! ../core/element_data */ 40);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var iteratorUtils = _interopRequireWildcard(__webpack_require__( /*! ../core/utils/iterator */ 3));
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 33);
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 74));
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./gesture/emitter.gesture */ 175));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DRAG_START_EVENT = "dxdragstart";
        exports.start = DRAG_START_EVENT;
        var DRAG_EVENT = "dxdrag";
        exports.move = DRAG_EVENT;
        var DRAG_END_EVENT = "dxdragend";
        exports.end = DRAG_END_EVENT;
        var DRAG_ENTER_EVENT = "dxdragenter";
        exports.enter = DRAG_ENTER_EVENT;
        var DRAG_LEAVE_EVENT = "dxdragleave";
        exports.leave = DRAG_LEAVE_EVENT;
        var DROP_EVENT = "dxdrop";
        exports.drop = DROP_EVENT;
        var DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [];
        var knownDropTargetSelectors = [];
        var knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = (0, _array.inArray)(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = (0, _array.inArray)(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if ((0, _array.inArray)(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = (0, _element_data.data)(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = (0, _array.inArray)(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    (0, _element_data.removeData)(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        (0, _event_registrator.default)(DRAG_ENTER_EVENT, dropTargetRegistration);
        (0, _event_registrator.default)(DRAG_LEAVE_EVENT, dropTargetRegistration);
        (0, _event_registrator.default)(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = (0, _array.inArray)($element.get(0), knownDropTargets);
            var dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex].filter(function(selector) {
                return selector
            });
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if ((0, _array.inArray)(void 0, knownDropTargetSelectors[dropTargetIndex]) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = (0, _array.inArray)($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = _emitter.default.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = (0, _array.wrapToArray)(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return (0, _renderer.default)(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = (0, _index.eventData)(e);
                var dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e);
                var sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                (0, _index.fireEvent)(eventData)
            },
            _findDropTarget: function(e) {
                var that = this;
                var result;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = (0, _renderer.default)(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = (0, _renderer.default)(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, (0, _renderer.default)(result), e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || (0, _dom.contains)(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, $prevTarget, e) {
                var isDraggingElement = $target.get(0) === (0, _renderer.default)(e.target).get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                if ($prevTarget.length && $prevTarget.closest($target).length) {
                    return false
                }
                if (config.checkDropTarget && !config.checkDropTarget($target, e)) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = (0, _index.eventData)(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        (0, _emitter_registrator.default)({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/array_store.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));
        var _query = _interopRequireDefault(__webpack_require__( /*! ./query */ 48));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ./abstract_store */ 104));
        var _array_utils = __webpack_require__( /*! ./array_utils */ 91);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ArrayStore = _abstract_store.default.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw _errors.default.errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return (0, _query.default)(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = (0, _array_utils.indexByKey)(this, this._array, key);
                if (index === -1) {
                    return _utils.default.rejectedPromise(_errors.default.errors.Error("E4009"))
                }
                return _utils.default.trivialPromise(this._array[index])
            },
            _insertImpl: function(values) {
                return (0, _array_utils.insert)(this, this._array, values)
            },
            _pushImpl: function(changes) {
                (0, _array_utils.applyBatch)({
                    keyInfo: this,
                    data: this._array,
                    changes: changes
                })
            },
            _updateImpl: function(key, values) {
                return (0, _array_utils.update)(this, this._array, key, values)
            },
            _removeImpl: function(key) {
                return (0, _array_utils.remove)(this, this._array, key)
            },
            clear: function() {
                this._eventsStrategy.fireEvent("modifying");
                this._array = [];
                this._eventsStrategy.fireEvent("modified")
            }
        }, "array");
        var _default = ArrayStore;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/call_once.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        var _default = callOnce;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/ajax.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _deferred = __webpack_require__( /*! ./deferred */ 6);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _http_request = _interopRequireDefault(__webpack_require__( /*! ../../core/http_request */ 504));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _extend = __webpack_require__( /*! ./extend */ 0);
        var _type = __webpack_require__( /*! ./type */ 1);
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../polyfills/promise */ 73));
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var SUCCESS = "success";
        var ERROR = "error";
        var TIMEOUT = "timeout";
        var NO_CONTENT = "nocontent";
        var PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = _dom_adapter.default.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return _dom_adapter.default.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new _promise.default(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    _dom_adapter.default.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*";
            var scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript";
            var accepts = {
                "*": "*/*",
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript",
                jsonp: scriptAccept,
                script: scriptAccept
            };
            (0, _extend.extendFromObject)(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!(0, _window.hasWindow)()) {
                return true
            }
            var crossDomain = false;
            var originAnchor = _dom_adapter.default.createElement("a");
            var urlAnchor = _dom_adapter.default.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, "");
                var callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random;
                var callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data;
            var paramsAlreadyString = "string" === typeof params;
            var url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };

        function getMethod(options) {
            return (options.method || "GET").toUpperCase()
        }
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var xhr = _http_request.default.getXhr();
            var d = new _deferred.Deferred;
            var result = d.promise();
            var async = (0, _type.isDefined)(options.async) ? options.async : true;
            var dataType = options.dataType;
            var timeout = options.timeout || 0;
            var timeoutId;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options);
            var headers = getRequestHeaders(options);
            var requestOptions = getRequestOptions(options, headers);
            var url = requestOptions.url;
            var parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                    d.reject(xhr, ERROR)
                };
                var resolve = function() {
                    if ("jsonp" === dataType) {
                        return
                    }
                    d.resolve(null, SUCCESS, xhr)
                };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (Object.prototype.hasOwnProperty.call(headers, name) && (0, _type.isDefined)(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        var _default = (0, _dependency_injector.default)({
            sendRequest: sendRequest
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/view_port.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.originalViewPort = originalViewPort;
        exports.changeCallback = exports.value = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 49));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 27));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ready = _ready_callbacks.default.add;
        var changeCallback = (0, _callbacks.default)();
        exports.changeCallback = changeCallback;
        var $originalViewPort = (0, _renderer.default)();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = (0, _renderer.default)(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : (0, _renderer.default)("body");
                changeCallback.fire(isNewViewportFound ? value() : (0, _renderer.default)(), prevViewPort)
            }
        }();
        exports.value = value;
        ready(function() {
            value(".dx-viewport")
        });

        function originalViewPort() {
            return $originalViewPort
        }
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/position.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _position = __webpack_require__( /*! ../core/utils/position */ 23);
        var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 22));
        var _translator = __webpack_require__( /*! ./translator */ 28);
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 14));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.getWindow)();
        var horzRe = /left|right/;
        var vertRe = /top|bottom/;
        var collisionRe = /fit|flip|none/;
        var IS_SAFARI = _browser.default.safari;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = (0, _common.splitPair)(raw);
            if (pair) {
                (0, _iterator.each)(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return (0, _common.pairToObject)(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = (0, _common.splitPair)(raw);
            var h = String(pair && pair[0]).toLowerCase();
            var v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = (0, _extend.extend)({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = (0, _renderer.default)("<div>").css({
                width: 100,
                height: 100,
                overflow: "scroll",
                position: "absolute",
                top: -9999
            }).appendTo((0, _renderer.default)("body"));
            var result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = (0, _renderer.default)(what);
            var currentOffset = $what.offset();
            var result = (0, _extend.extend)(true, {}, defaultPositionResult, {
                h: {
                    location: currentOffset.left
                },
                v: {
                    location: currentOffset.top
                }
            });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my);
            var at = normalizeAlign(options.at);
            var of = (0, _renderer.default)(options.of).length && options.of || window;
            var offset = normalizeOffset(options.offset);
            var collision = normalizeCollision(options.collision);
            var boundary = options.boundary;
            var boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else {
                of = (0, _renderer.default)( of );
                if ((0, _type.isWindow)( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    if ("phone" === _devices.default.real().deviceType && of [0].visualViewport) {
                        h.atLocation = Math.max(h.atLocation, of [0].visualViewport.offsetLeft);
                        v.atLocation = Math.max(v.atLocation, of [0].visualViewport.offsetTop);
                        h.atSize = of [0].visualViewport.width;
                        v.atSize = of [0].visualViewport.height
                    } else {
                        h.atSize = of [0].innerWidth >= of [0].outerWidth ? of [0].innerWidth : of .width();
                        v.atSize = of [0].innerHeight >= of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : of .height()
                    }
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var ofRect = (0, _position.getBoundingRect)( of .get(0));
                        var o = getOffsetWithoutScale( of );
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = Math.max(ofRect.width, of .outerWidth());
                        v.atSize = Math.max(ofRect.height, of .outerHeight())
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = (0, _renderer.default)(window);
                var windowWidth = win.width();
                var windowHeight = win.height();
                var left = win.scrollLeft();
                var top = win.scrollTop();
                var documentElement = _dom_adapter.default.getDocumentElement();
                var hZoomLevel = _support.touch ? documentElement.clientWidth / windowWidth : 1;
                var vZoomLevel = _support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth;
                var boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = (0, _renderer.default)(boundary);
                    var boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            (0, _extend.extend)(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var getOffsetWithoutScale = function getOffsetWithoutScale($startElement) {
            var $currentElement = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : $startElement;
            var currentElement = $currentElement.get(0);
            if (!currentElement || $currentElement.is("body")) {
                return $startElement.offset()
            }
            var transform = $currentElement.get(0).style.transform;
            var scale = (transform.match(/scale(.+)/) || [])[0];
            currentElement.style.transform = transform.replace(scale, "");
            var offset = getOffsetWithoutScale($startElement, $currentElement.parent());
            currentElement.style.transform = transform;
            return offset
        };
        var position = function(what, options) {
            var $what = (0, _renderer.default)(what);
            if (!options) {
                return $what.offset()
            }(0, _translator.resetPosition)($what, true);
            var offset = getOffsetWithoutScale($what);
            var targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            (0, _translator.move)($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = (0, _renderer.default)(element).get(0);
            if ((0, _type.isWindow)(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return (0, _renderer.default)(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        var _default = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        };
        exports.default = _default;
        module.exports = exports.default
    }, , , ,
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/core.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../core/utils/dependency_injector */ 59));
        var _parent_locales = _interopRequireDefault(__webpack_require__( /*! ./cldr-data/parent_locales */ 493));
        var _parentLocale = _interopRequireDefault(__webpack_require__( /*! ./parentLocale */ 494));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_LOCALE = "en";
        var _default = (0, _dependency_injector.default)({
            locale: function() {
                var currentLocale = DEFAULT_LOCALE;
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }(),
            getValueByClosestLocale: function(getter) {
                var locale = this.locale();
                var value = getter(locale);
                var isRootLocale;
                while (!value && !isRootLocale) {
                    locale = (0, _parentLocale.default)(_parent_locales.default, locale);
                    if (locale) {
                        value = getter(locale)
                    } else {
                        isRootLocale = true
                    }
                }
                if (void 0 === value && locale !== DEFAULT_LOCALE) {
                    return getter(DEFAULT_LOCALE)
                }
                return value
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************************!*\
      !*** ./artifacts/transpiled-npm/exporter/excel/excel.tag_helper.js ***!
      \*********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var tagHelper = {
            toXml: function(tagName, attributes, content) {
                var result = ["<", tagName];
                for (var attributeName in attributes) {
                    var attributeValue = attributes[attributeName];
                    if ((0, _type.isDefined)(attributeValue)) {
                        result.push(" ", attributeName, '="', attributeValue, '"')
                    }
                }
                if ((0, _type.isDefined)(content) && "" !== content) {
                    result.push(">", content, "</", tagName, ">")
                } else {
                    result.push(" />")
                }
                return result.join("")
            }
        };
        var _default = tagHelper;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/integration/jquery/use_jquery.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = _default;
        var _jquery = _interopRequireDefault(__webpack_require__( /*! jquery */ 60));
        var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 31));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var useJQuery = (0, _config.default)().useJQuery;
        if (_jquery.default && false !== useJQuery) {
            (0, _config.default)({
                useJQuery: true
            })
        }

        function _default() {
            return _jquery.default && (0, _config.default)().useJQuery
        }
        module.exports = exports.default
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/empty_template.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.EmptyTemplate = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 2));
        var _template_base = __webpack_require__( /*! ./template_base */ 75);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var EmptyTemplate = function(_TemplateBase) {
            _inherits(EmptyTemplate, _TemplateBase);
            var _super = _createSuper(EmptyTemplate);

            function EmptyTemplate() {
                _classCallCheck(this, EmptyTemplate);
                return _super.apply(this, arguments)
            }
            _createClass(EmptyTemplate, [{
                key: "_renderCore",
                value: function() {
                    return (0, _renderer.default)()
                }
            }]);
            return EmptyTemplate
        }(_template_base.TemplateBase);
        exports.EmptyTemplate = EmptyTemplate
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/data_helper.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _data_source = __webpack_require__( /*! ./data/data_source/data_source */ 69);
        var _extend = __webpack_require__( /*! ./core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ./data/data_source/utils */ 70);
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions";
        var DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler";
        var DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler";
        var DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler";
        var DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode";
        var SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var NORMALIZE_DATA_SOURCE = "_normalizeDataSource";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                var widgetDataSourceOptions;
                var dataSourceType;
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof _data_source.DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : _data_source.DataSource;
                        dataSourceOptions = (0, _utils.normalizeDataSourceOptions)(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType((0, _extend.extend)(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    if (NORMALIZE_DATA_SOURCE in this) {
                        this._dataSource = this[NORMALIZE_DATA_SOURCE](this._dataSource)
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function(e) {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items(), e)
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        var _default = DataHelperMixin;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/array_utils.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.applyBatch = applyBatch;
        exports.createObjectWithChanges = createObjectWithChanges;
        exports.update = update;
        exports.insert = insert;
        exports.remove = remove;
        exports.indexByKey = indexByKey;
        exports.applyChanges = applyChanges;
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 31));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../core/guid */ 36));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _object = __webpack_require__( /*! ../core/utils/object */ 50);
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function hasKey(target, keyOrKeys) {
            var key;
            var keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
            while (keys.length) {
                key = keys.shift();
                if (key in target) {
                    return true
                }
            }
            return false
        }

        function findItems(keyInfo, items, key, groupCount) {
            var childItems;
            var result;
            if (groupCount) {
                for (var i = 0; i < items.length; i++) {
                    childItems = items[i].items || items[i].collapsedItems || [];
                    result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                    if (result) {
                        return result
                    }
                }
            } else {
                if (indexByKey(keyInfo, items, key) >= 0) {
                    return items
                }
            }
        }

        function getItems(keyInfo, items, key, groupCount) {
            if (groupCount) {
                return findItems(keyInfo, items, key, groupCount) || []
            }
            return items
        }

        function generateDataByKeyMap(keyInfo, array) {
            if (keyInfo.key() && (!array._dataByKeyMap || array._dataByKeyMapLength !== array.length)) {
                var dataByKeyMap = {};
                var arrayLength = array.length;
                for (var i = 0; i < arrayLength; i++) {
                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                }
                array._dataByKeyMap = dataByKeyMap;
                array._dataByKeyMapLength = arrayLength
            }
        }

        function getCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
        }

        function getHasKeyCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
            return true
        }

        function setDataByKeyMapValue(array, key, data) {
            if (array._dataByKeyMap) {
                array._dataByKeyMap[JSON.stringify(key)] = data
            }
        }

        function createObjectWithChanges(target, changes) {
            var result = target ? Object.create(Object.getPrototypeOf(target)) : {};
            var targetWithoutPrototype = (0, _extend.extendFromObject)({}, target);
            (0, _object.deepExtendArraySafe)(result, targetWithoutPrototype, true, true);
            return (0, _object.deepExtendArraySafe)(result, changes, true, true)
        }

        function applyBatch(_ref) {
            var keyInfo = _ref.keyInfo,
                data = _ref.data,
                changes = _ref.changes,
                groupCount = _ref.groupCount,
                useInsertIndex = _ref.useInsertIndex,
                immutable = _ref.immutable,
                disableCache = _ref.disableCache,
                logError = _ref.logError;
            var resultItems = true === immutable ? _toConsumableArray(data) : data;
            changes.forEach(function(item) {
                var items = "insert" === item.type ? resultItems : getItems(keyInfo, resultItems, item.key, groupCount);
                !disableCache && generateDataByKeyMap(keyInfo, items);
                switch (item.type) {
                    case "update":
                        update(keyInfo, items, item.key, item.data, true, immutable, logError);
                        break;
                    case "insert":
                        insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true, logError);
                        break;
                    case "remove":
                        remove(keyInfo, items, item.key, true, logError)
                }
            });
            return resultItems
        }

        function getErrorResult(isBatch, logError, errorCode) {
            return !isBatch ? _utils.default.rejectedPromise(_errors.default.errors.Error(errorCode)) : logError && _errors.default.errors.log(errorCode)
        }

        function applyChanges(data, changes) {
            var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
            var _options$keyExpr = options.keyExpr,
                keyExpr = void 0 === _options$keyExpr ? "id" : _options$keyExpr,
                _options$immutable = options.immutable,
                immutable = void 0 === _options$immutable ? true : _options$immutable;
            var keyGetter = (0, _data.compileGetter)(keyExpr);
            var keyInfo = {
                key: function() {
                    return keyExpr
                },
                keyOf: function(obj) {
                    return keyGetter(obj)
                }
            };
            return applyBatch({
                keyInfo: keyInfo,
                data: data,
                changes: changes,
                immutable: immutable,
                disableCache: true,
                logError: true
            })
        }

        function update(keyInfo, array, key, data, isBatch, immutable, logError) {
            var target;
            var extendComplexObject = true;
            var keyExpr = keyInfo.key();
            if (keyExpr) {
                if (hasKey(data, keyExpr) && !_utils.default.keysEqual(keyExpr, key, keyInfo.keyOf(data))) {
                    return getErrorResult(isBatch, logError, "E4017")
                }
                target = getCacheValue(array, key);
                if (!target) {
                    var index = indexByKey(keyInfo, array, key);
                    if (index < 0) {
                        return getErrorResult(isBatch, logError, "E4009")
                    }
                    target = array[index];
                    if (true === immutable && (0, _type.isDefined)(target)) {
                        var newTarget = createObjectWithChanges(target, data);
                        array[index] = newTarget;
                        return !isBatch && _utils.default.trivialPromise(newTarget, key)
                    }
                }
            } else {
                target = key
            }(0, _object.deepExtendArraySafe)(target, data, extendComplexObject);
            if (!isBatch) {
                if ((0, _config.default)().useLegacyStoreResult) {
                    return _utils.default.trivialPromise(key, data)
                } else {
                    return _utils.default.trivialPromise(target, key)
                }
            }
        }

        function insert(keyInfo, array, data, index, isBatch, logError) {
            var keyValue;
            var keyExpr = keyInfo.key();
            var obj = (0, _type.isPlainObject)(data) ? (0, _extend.extend)({}, data) : data;
            if (keyExpr) {
                keyValue = keyInfo.keyOf(obj);
                if (void 0 === keyValue || "object" === _typeof(keyValue) && (0, _type.isEmptyObject)(keyValue)) {
                    if (Array.isArray(keyExpr)) {
                        throw _errors.default.errors.Error("E4007")
                    }
                    keyValue = obj[keyExpr] = String(new _guid.default)
                } else {
                    if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                        return getErrorResult(isBatch, logError, "E4008")
                    }
                }
            } else {
                keyValue = obj
            }
            if (index >= 0) {
                array.splice(index, 0, obj)
            } else {
                array.push(obj)
            }
            setDataByKeyMapValue(array, keyValue, obj);
            if (!isBatch) {
                return _utils.default.trivialPromise((0, _config.default)().useLegacyStoreResult ? data : obj, keyValue)
            }
        }

        function remove(keyInfo, array, key, isBatch, logError) {
            var index = indexByKey(keyInfo, array, key);
            if (index > -1) {
                array.splice(index, 1)
            }
            if (!isBatch) {
                return _utils.default.trivialPromise(key)
            } else {
                if (index < 0) {
                    return getErrorResult(isBatch, logError, "E4009")
                }
            }
        }

        function indexByKey(keyInfo, array, key) {
            var keyExpr = keyInfo.key();
            if (!getHasKeyCacheValue(array, key)) {
                return -1
            }
            for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                if (_utils.default.keysEqual(keyExpr, keyInfo.keyOf(array[i]), key)) {
                    return i
                }
            }
            return -1
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/store_helper.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 167));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return (0, _extend.extend)({}, g, {
                        items: multiLevelGroup((0, _array_query.default)(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            (0, _iterator.each)(groupInfo, function(_, group) {
                var collision = (0, _common.grep)(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter;
            if (filter) {
                query = query.filter(filter)
            }
            if (isCountQuery) {
                return query
            }
            var sort = options.sort;
            var select = options.select;
            var group = options.group;
            var skip = options.skip;
            var take = options.take;
            if (group) {
                group = _utils.default.normalizeSortingInfo(group);
                group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
            }
            if (sort || group) {
                sort = _utils.default.normalizeSortingInfo(sort || []);
                if (group && !group.keepInitialKeyOrder) {
                    sort = arrangeSortingInfo(group, sort)
                }(0, _iterator.each)(sort, function(index) {
                    query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                })
            }
            if (select) {
                query = query.select(select)
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (take || skip) {
                query = query.slice(skip || 0, take)
            }
            return query
        }
        var _default = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled-npm/color.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var v = parseInt(colorString[3], 10);
                var rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var l = parseInt(colorString[3], 10);
                var rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];
        var _round = Math.round;

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var i = 0;
            var ii = standardColorTypes.length;
            var str;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var delta = max - min;
            var H;
            var S;
            var V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var index = Math.floor(h % 360 / 60);
            var vMin = (100 - s) * v / 100;
            var a = (v - vMin) * (h % 60 / 60);
            var vInc = vMin + a;
            var vDec = v - a;
            var r;
            var g;
            var b;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var maxMinSum = max + min;
            var h;
            var s;
            var l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r;
            var g;
            var b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s;
                var p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor);
                var result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color;
                var rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        var _default = Color;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/validation_engine.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 15));
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 98);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 25));
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = _interopRequireDefault(__webpack_require__( /*! ../localization/number */ 47));
        var _message = _interopRequireDefault(__webpack_require__( /*! ../localization/message */ 10));
        var _promise = _interopRequireDefault(__webpack_require__( /*! ../core/polyfills/promise */ 73));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var STATUS = {
            valid: "valid",
            invalid: "invalid",
            pending: "pending"
        };
        var BaseRuleValidator = function() {
            function BaseRuleValidator() {
                _classCallCheck(this, BaseRuleValidator);
                this.NAME = "base"
            }
            _createClass(BaseRuleValidator, [{
                key: "defaultMessage",
                value: function(value) {
                    return _message.default.getFormatter("validation-".concat(this.NAME))(value)
                }
            }, {
                key: "defaultFormattedMessage",
                value: function(value) {
                    return _message.default.getFormatter("validation-".concat(this.NAME, "-formatted"))(value)
                }
            }, {
                key: "_isValueEmpty",
                value: function(value) {
                    return !rulesValidators.required.validate(value, {})
                }
            }, {
                key: "validate",
                value: function(value, rule) {
                    var _this = this;
                    var valueArray = Array.isArray(value) ? value : [value];
                    var result = true;
                    if (valueArray.length) {
                        valueArray.every(function(itemValue) {
                            result = _this._validate(itemValue, rule);
                            return result
                        })
                    } else {
                        result = this._validate(null, rule)
                    }
                    return result
                }
            }]);
            return BaseRuleValidator
        }();
        var RequiredRuleValidator = function(_BaseRuleValidator) {
            _inherits(RequiredRuleValidator, _BaseRuleValidator);
            var _super = _createSuper(RequiredRuleValidator);

            function RequiredRuleValidator() {
                var _this2;
                _classCallCheck(this, RequiredRuleValidator);
                _this2 = _super.call(this);
                _this2.NAME = "required";
                return _this2
            }
            _createClass(RequiredRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!(0, _type.isDefined)(value)) {
                        return false
                    }
                    if (false === value) {
                        return false
                    }
                    value = String(value);
                    if (rule.trim || !(0, _type.isDefined)(rule.trim)) {
                        value = value.trim()
                    }
                    return "" !== value
                }
            }]);
            return RequiredRuleValidator
        }(BaseRuleValidator);
        var NumericRuleValidator = function(_BaseRuleValidator2) {
            _inherits(NumericRuleValidator, _BaseRuleValidator2);
            var _super2 = _createSuper(NumericRuleValidator);

            function NumericRuleValidator() {
                var _this3;
                _classCallCheck(this, NumericRuleValidator);
                _this3 = _super2.call(this);
                _this3.NAME = "numeric";
                return _this3
            }
            _createClass(NumericRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    if (rule.useCultureSettings && (0, _type.isString)(value)) {
                        return !isNaN(_number.default.parse(value))
                    } else {
                        return (0, _type.isNumeric)(value)
                    }
                }
            }]);
            return NumericRuleValidator
        }(BaseRuleValidator);
        var RangeRuleValidator = function(_BaseRuleValidator3) {
            _inherits(RangeRuleValidator, _BaseRuleValidator3);
            var _super3 = _createSuper(RangeRuleValidator);

            function RangeRuleValidator() {
                var _this4;
                _classCallCheck(this, RangeRuleValidator);
                _this4 = _super3.call(this);
                _this4.NAME = "range";
                return _this4
            }
            _createClass(RangeRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validNumber = rulesValidators.numeric.validate(value, rule);
                    var validValue = (0, _type.isDefined)(value) && "" !== value;
                    var number = validNumber ? parseFloat(value) : validValue && value.valueOf();
                    var min = rule.min;
                    var max = rule.max;
                    if (!(validNumber || (0, _type.isDate)(value)) && !validValue) {
                        return false
                    }
                    if ((0, _type.isDefined)(min)) {
                        if ((0, _type.isDefined)(max)) {
                            return number >= min && number <= max
                        }
                        return number >= min
                    } else {
                        if ((0, _type.isDefined)(max)) {
                            return number <= max
                        } else {
                            throw _errors.default.Error("E0101")
                        }
                    }
                }
            }]);
            return RangeRuleValidator
        }(BaseRuleValidator);
        var StringLengthRuleValidator = function(_BaseRuleValidator4) {
            _inherits(StringLengthRuleValidator, _BaseRuleValidator4);
            var _super4 = _createSuper(StringLengthRuleValidator);

            function StringLengthRuleValidator() {
                var _this5;
                _classCallCheck(this, StringLengthRuleValidator);
                _this5 = _super4.call(this);
                _this5.NAME = "stringLength";
                return _this5
            }
            _createClass(StringLengthRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    value = (0, _type.isDefined)(value) ? String(value) : "";
                    if (rule.trim || !(0, _type.isDefined)(rule.trim)) {
                        value = value.trim()
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.range.validate(value.length, (0, _extend.extend)({}, rule))
                }
            }]);
            return StringLengthRuleValidator
        }(BaseRuleValidator);
        var CustomRuleValidator = function(_BaseRuleValidator5) {
            _inherits(CustomRuleValidator, _BaseRuleValidator5);
            var _super5 = _createSuper(CustomRuleValidator);

            function CustomRuleValidator() {
                var _this6;
                _classCallCheck(this, CustomRuleValidator);
                _this6 = _super5.call(this);
                _this6.NAME = "custom";
                return _this6
            }
            _createClass(CustomRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && (0, _type.isFunction)(validator.option) && validator.option("dataGetter");
                    var extraParams = (0, _type.isFunction)(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    return rule.validationCallback(params)
                }
            }]);
            return CustomRuleValidator
        }(BaseRuleValidator);
        var AsyncRuleValidator = function(_CustomRuleValidator) {
            _inherits(AsyncRuleValidator, _CustomRuleValidator);
            var _super6 = _createSuper(AsyncRuleValidator);

            function AsyncRuleValidator() {
                var _this7;
                _classCallCheck(this, AsyncRuleValidator);
                _this7 = _super6.call(this);
                _this7.NAME = "async";
                return _this7
            }
            _createClass(AsyncRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (!(0, _type.isDefined)(rule.reevaluate)) {
                        (0, _extend.extend)(rule, {
                            reevaluate: true
                        })
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && (0, _type.isFunction)(validator.option) && validator.option("dataGetter");
                    var extraParams = (0, _type.isFunction)(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    var callbackResult = rule.validationCallback(params);
                    if (!(0, _type.isPromise)(callbackResult)) {
                        throw _errors.default.Error("E0103")
                    }
                    return this._getWrappedPromise((0, _deferred.fromPromise)(callbackResult).promise())
                }
            }, {
                key: "_getWrappedPromise",
                value: function(promise) {
                    var deferred = new _deferred.Deferred;
                    promise.then(function(res) {
                        deferred.resolve(res)
                    }, function(err) {
                        var res = {
                            isValid: false
                        };
                        if ((0, _type.isDefined)(err)) {
                            if ((0, _type.isString)(err)) {
                                res.message = err
                            } else {
                                if ((0, _type.isObject)(err) && (0, _type.isDefined)(err.message) && (0, _type.isString)(err.message)) {
                                    res.message = err.message
                                }
                            }
                        }
                        deferred.resolve(res)
                    });
                    return deferred.promise()
                }
            }]);
            return AsyncRuleValidator
        }(CustomRuleValidator);
        var CompareRuleValidator = function(_BaseRuleValidator6) {
            _inherits(CompareRuleValidator, _BaseRuleValidator6);
            var _super7 = _createSuper(CompareRuleValidator);

            function CompareRuleValidator() {
                var _this8;
                _classCallCheck(this, CompareRuleValidator);
                _this8 = _super7.call(this);
                _this8.NAME = "compare";
                return _this8
            }
            _createClass(CompareRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!rule.comparisonTarget) {
                        throw _errors.default.Error("E0102")
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }(0, _extend.extend)(rule, {
                        reevaluate: true
                    });
                    var otherValue = rule.comparisonTarget();
                    var type = rule.comparisonType || "==";
                    switch (type) {
                        case "==":
                            return value == otherValue;
                        case "!=":
                            return value != otherValue;
                        case "===":
                            return value === otherValue;
                        case "!==":
                            return value !== otherValue;
                        case ">":
                            return value > otherValue;
                        case ">=":
                            return value >= otherValue;
                        case "<":
                            return value < otherValue;
                        case "<=":
                            return value <= otherValue
                    }
                }
            }]);
            return CompareRuleValidator
        }(BaseRuleValidator);
        var PatternRuleValidator = function(_BaseRuleValidator7) {
            _inherits(PatternRuleValidator, _BaseRuleValidator7);
            var _super8 = _createSuper(PatternRuleValidator);

            function PatternRuleValidator() {
                var _this9;
                _classCallCheck(this, PatternRuleValidator);
                _this9 = _super8.call(this);
                _this9.NAME = "pattern";
                return _this9
            }
            _createClass(PatternRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var pattern = rule.pattern;
                    if ((0, _type.isString)(pattern)) {
                        pattern = new RegExp(pattern)
                    }
                    return pattern.test(value)
                }
            }]);
            return PatternRuleValidator
        }(BaseRuleValidator);
        var EmailRuleValidator = function(_BaseRuleValidator8) {
            _inherits(EmailRuleValidator, _BaseRuleValidator8);
            var _super9 = _createSuper(EmailRuleValidator);

            function EmailRuleValidator() {
                var _this10;
                _classCallCheck(this, EmailRuleValidator);
                _this10 = _super9.call(this);
                _this10.NAME = "email";
                return _this10
            }
            _createClass(EmailRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.pattern.validate(value, (0, _extend.extend)({}, rule, {
                        pattern: /^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i
                    }))
                }
            }]);
            return EmailRuleValidator
        }(BaseRuleValidator);
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            async: new AsyncRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = _class.default.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = [];
                this._pendingValidators = [];
                this._onValidatorStatusChanged = this._onValidatorStatusChanged.bind(this);
                this._resetValidationInfo();
                this._eventsStrategy = new _events_strategy.EventsStrategy(this)
            },
            validate: function() {
                var _this11 = this;
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: [],
                    status: STATUS.valid,
                    complete: null
                };
                this._unsubscribeFromAllChangeEvents();
                this._pendingValidators = [];
                this._resetValidationInfo();
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRules) {
                        result.brokenRules = result.brokenRules.concat(validatorResult.brokenRules)
                    }
                    result.validators.push(validator);
                    if (validatorResult.status === STATUS.pending) {
                        _this11._addPendingValidator(validator)
                    }
                    _this11._subscribeToChangeEvents(validator)
                });
                if (this._pendingValidators.length) {
                    result.status = STATUS.pending
                } else {
                    result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                    this._unsubscribeFromAllChangeEvents();
                    this._raiseValidatedEvent(result)
                }
                this._updateValidationInfo(result);
                return (0, _extend.extend)({}, this._validationInfo.result)
            },
            _subscribeToChangeEvents: function(validator) {
                validator.on("validating", this._onValidatorStatusChanged);
                validator.on("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromChangeEvents: function(validator) {
                validator.off("validating", this._onValidatorStatusChanged);
                validator.off("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromAllChangeEvents: function() {
                var _this12 = this;
                (0, _iterator.each)(this.validators, function(_, validator) {
                    _this12._unsubscribeFromChangeEvents(validator)
                })
            },
            _updateValidationInfo: function(result) {
                this._validationInfo.result = result;
                if (result.status !== STATUS.pending) {
                    return
                }
                if (!this._validationInfo.deferred) {
                    this._validationInfo.deferred = new _deferred.Deferred;
                    this._validationInfo.result.complete = this._validationInfo.deferred.promise()
                }
            },
            _addPendingValidator: function(validator) {
                var foundValidator = (0, _common.grep)(this._pendingValidators, function(val) {
                    return val === validator
                })[0];
                if (!foundValidator) {
                    this._pendingValidators.push(validator)
                }
            },
            _removePendingValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this._pendingValidators);
                if (index >= 0) {
                    this._pendingValidators.splice(index, 1)
                }
            },
            _orderBrokenRules: function(brokenRules) {
                var orderedRules = [];
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var foundRules = (0, _common.grep)(brokenRules, function(rule) {
                        return rule.validator === validator
                    });
                    if (foundRules.length) {
                        orderedRules = orderedRules.concat(foundRules)
                    }
                });
                return orderedRules
            },
            _updateBrokenRules: function(result) {
                if (!this._validationInfo.result) {
                    return
                }
                var brokenRules = this._validationInfo.result.brokenRules;
                var rules = (0, _common.grep)(brokenRules, function(rule) {
                    return rule.validator !== result.validator
                });
                if (result.brokenRules) {
                    brokenRules = rules.concat(result.brokenRules)
                }
                this._validationInfo.result.brokenRules = this._orderBrokenRules(brokenRules)
            },
            _onValidatorStatusChanged: function(result) {
                if (result.status === STATUS.pending) {
                    this._addPendingValidator(result.validator);
                    return
                }
                this._resolveIfComplete(result)
            },
            _resolveIfComplete: function(result) {
                this._removePendingValidator(result.validator);
                this._updateBrokenRules(result);
                if (!this._pendingValidators.length) {
                    this._unsubscribeFromAllChangeEvents();
                    if (!this._validationInfo.result) {
                        return
                    }
                    this._validationInfo.result.status = 0 === this._validationInfo.result.brokenRules.length ? STATUS.valid : STATUS.invalid;
                    this._validationInfo.result.isValid = this._validationInfo.result.status === STATUS.valid;
                    var res = (0, _extend.extend)({}, this._validationInfo.result, {
                        complete: null
                    });
                    var deferred = this._validationInfo.deferred;
                    this._resetValidationInfo();
                    this._raiseValidatedEvent(res);
                    deferred && setTimeout(function() {
                        deferred.resolve(res)
                    })
                }
            },
            _raiseValidatedEvent: function(result) {
                this._eventsStrategy.fireEvent("validated", [result])
            },
            _resetValidationInfo: function() {
                this._validationInfo = {
                    result: null,
                    deferred: null
                }
            },
            _synchronizeValidationInfo: function() {
                if (this._validationInfo.result) {
                    this._validationInfo.result.validators = this.validators
                }
            },
            removeRegisteredValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this.validators);
                if (index > -1) {
                    this.validators.splice(index, 1);
                    this._synchronizeValidationInfo();
                    this._resolveIfComplete({
                        validator: validator
                    })
                }
            },
            registerValidator: function(validator) {
                if ((0, _array.inArray)(validator, this.validators) < 0) {
                    this.validators.push(validator);
                    this._synchronizeValidationInfo()
                }
            },
            reset: function() {
                (0, _iterator.each)(this.validators, function(_, validator) {
                    validator.reset()
                });
                this._pendingValidators = [];
                this._resetValidationInfo()
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = (0, _common.grep)(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            findGroup: function($element, model) {
                var $dxGroup = $element.parents(".dx-validationgroup").first();
                if ($dxGroup.length) {
                    return $dxGroup.dxValidationGroup("instance")
                }
                return model
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group);
                var index = (0, _array.inArray)(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(info) {
                var rule = info.rule,
                    validator = info.validator,
                    name = info.name;
                if (!(0, _type.isDefined)(rule.message)) {
                    if (validator.defaultFormattedMessage && (0, _type.isDefined)(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            _addBrokenRule: function(info) {
                var result = info.result,
                    rule = info.rule;
                if (!result.brokenRule) {
                    result.brokenRule = rule
                }
                if (!result.brokenRules) {
                    result.brokenRules = []
                }
                result.brokenRules.push(rule)
            },
            validate: function(value, rules, name) {
                var _this13 = this;
                var result = {
                    name: name,
                    value: value,
                    brokenRule: null,
                    brokenRules: null,
                    isValid: true,
                    validationRules: rules,
                    pendingRules: null,
                    status: STATUS.valid,
                    complete: null
                };
                var asyncRuleItems = [];
                (0, _iterator.each)(rules || [], function(_, rule) {
                    var ruleValidator = rulesValidators[rule.type];
                    var ruleValidationResult;
                    if (ruleValidator) {
                        if ((0, _type.isDefined)(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                _this13._addBrokenRule({
                                    result: result,
                                    rule: rule
                                });
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        if ("async" === rule.type) {
                            asyncRuleItems.push({
                                rule: rule,
                                ruleValidator: ruleValidator
                            });
                            return true
                        }
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            _this13._setDefaultMessage({
                                rule: rule,
                                validator: ruleValidator,
                                name: name
                            });
                            _this13._addBrokenRule({
                                result: result,
                                rule: rule
                            })
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw _errors.default.Error("E0100")
                    }
                });
                if (result.isValid && !result.brokenRules && asyncRuleItems.length) {
                    result = this._validateAsyncRules({
                        value: value,
                        items: asyncRuleItems,
                        result: result,
                        name: name
                    })
                }
                result.status = result.pendingRules ? STATUS.pending : result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            _validateAsyncRules: function(_ref) {
                var _this14 = this;
                var result = _ref.result,
                    value = _ref.value,
                    items = _ref.items,
                    name = _ref.name;
                var asyncResults = [];
                (0, _iterator.each)(items, function(_, item) {
                    var validateResult = item.ruleValidator.validate(value, item.rule);
                    if (!(0, _type.isPromise)(validateResult)) {
                        _this14._updateRuleConfig({
                            rule: item.rule,
                            ruleResult: _this14._getPatchedRuleResult(validateResult),
                            validator: item.ruleValidator,
                            name: name
                        })
                    } else {
                        if (!result.pendingRules) {
                            result.pendingRules = []
                        }
                        result.pendingRules.push(item.rule);
                        var asyncResult = validateResult.then(function(res) {
                            var ruleResult = _this14._getPatchedRuleResult(res);
                            _this14._updateRuleConfig({
                                rule: item.rule,
                                ruleResult: ruleResult,
                                validator: item.ruleValidator,
                                name: name
                            });
                            return ruleResult
                        });
                        asyncResults.push(asyncResult)
                    }
                });
                if (asyncResults.length) {
                    result.complete = _promise.default.all(asyncResults).then(function(values) {
                        return _this14._getAsyncRulesResult({
                            result: result,
                            values: values
                        })
                    })
                }
                return result
            },
            _updateRuleConfig: function(_ref2) {
                var rule = _ref2.rule,
                    ruleResult = _ref2.ruleResult,
                    validator = _ref2.validator,
                    name = _ref2.name;
                rule.isValid = ruleResult.isValid;
                if (!ruleResult.isValid) {
                    if ((0, _type.isDefined)(ruleResult.message) && (0, _type.isString)(ruleResult.message) && ruleResult.message.length) {
                        rule.message = ruleResult.message
                    } else {
                        this._setDefaultMessage({
                            rule: rule,
                            validator: validator,
                            name: name
                        })
                    }
                }
            },
            _getPatchedRuleResult: function(ruleResult) {
                var result;
                var isValid = true;
                if ((0, _type.isObject)(ruleResult)) {
                    result = (0, _extend.extend)({}, ruleResult);
                    if (!(0, _type.isDefined)(result.isValid)) {
                        result.isValid = isValid
                    }
                } else {
                    result = {
                        isValid: (0, _type.isBoolean)(ruleResult) ? ruleResult : isValid
                    }
                }
                return result
            },
            _getAsyncRulesResult: function(_ref3) {
                var _this15 = this;
                var values = _ref3.values,
                    result = _ref3.result;
                (0, _iterator.each)(values, function(index, val) {
                    if (false === val.isValid) {
                        result.isValid = val.isValid;
                        var rule = result.pendingRules[index];
                        _this15._addBrokenRule({
                            result: result,
                            rule: rule
                        })
                    }
                });
                result.pendingRules = null;
                result.complete = null;
                result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                groupConfig.registerValidator.call(groupConfig, validator)
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group;
                var isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group);
                if (config) {
                    config.removeRegisteredValidator.call(config, validator);
                    var validatorsInGroup = config.validators;
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            initValidationOptions: function(options) {
                var _this16 = this;
                var initedOptions = {};
                if (options) {
                    var syncOptions = ["isValid", "validationStatus", "validationError", "validationErrors"];
                    syncOptions.forEach(function(prop) {
                        if (prop in options) {
                            (0, _extend.extend)(initedOptions, _this16.synchronizeValidationOptions({
                                name: prop,
                                value: options[prop]
                            }, options))
                        }
                    })
                }
                return initedOptions
            },
            synchronizeValidationOptions: function(_ref4, options) {
                var name = _ref4.name,
                    value = _ref4.value;
                switch (name) {
                    case "validationStatus":
                        var isValid = value === STATUS.valid || value === STATUS.pending;
                        return options.isValid !== isValid ? {
                            isValid: isValid
                        } : {};
                    case "isValid":
                        var validationStatus = options.validationStatus;
                        var newStatus = validationStatus;
                        if (value && validationStatus === STATUS.invalid) {
                            newStatus = STATUS.valid
                        } else {
                            if (!value && validationStatus !== STATUS.invalid) {
                                newStatus = STATUS.invalid
                            }
                        }
                        return newStatus !== validationStatus ? {
                            validationStatus: newStatus
                        } : {};
                    case "validationErrors":
                        var validationError = !value || !value.length ? null : value[0];
                        return options.validationError !== validationError ? {
                            validationError: validationError
                        } : {};
                    case "validationError":
                        var validationErrors = options.validationErrors;
                        if (!value && validationErrors) {
                            return {
                                validationErrors: null
                            }
                        } else {
                            if (value && !validationErrors) {
                                return {
                                    validationErrors: [value]
                                }
                            } else {
                                if (value && validationErrors && value !== validationErrors[0]) {
                                    validationErrors[0] = value;
                                    return {
                                        validationErrors: validationErrors.slice()
                                    }
                                }
                            }
                        }
                }
                return {}
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors.default.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors.default.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        var _default = ValidationEngine;
        exports.default = _default;
        module.exports = exports.default
    }, , ,
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/style.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.setHeight = exports.setWidth = exports.normalizeStyleProp = exports.stylePropPrefix = exports.styleProp = void 0;
        var _inflector = __webpack_require__( /*! ./inflector */ 39);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));
        var _type = __webpack_require__( /*! ./type */ 1);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"];
        var cssPrefixes = {
            "": "",
            Webkit: "-webkit-",
            Moz: "-moz-",
            O: "-o-",
            ms: "-ms-"
        };
        var getStyles = (0, _call_once.default)(function() {
            return _dom_adapter.default.createElement("dx").style
        });
        var forEachPrefixes = function(prop, callBack) {
            prop = (0, _inflector.camelize)(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = (0, _inflector.camelize)(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        exports.styleProp = styleProp;
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        exports.stylePropPrefix = stylePropPrefix;
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if ((0, _type.isNumeric)(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        exports.normalizeStyleProp = normalizeStyleProp;
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = (0, _type.isNumeric)(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        exports.setWidth = setWidth;
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.setHeight = setHeight
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/events_strategy.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.EventsStrategy = void 0;
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _type = __webpack_require__( /*! ./utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var EventsStrategy = function() {
            function EventsStrategy(owner) {
                _classCallCheck(this, EventsStrategy);
                this._events = {};
                this._owner = owner
            }
            _createClass(EventsStrategy, [{
                key: "hasEvent",
                value: function(eventName) {
                    var callbacks = this._events[eventName];
                    return callbacks ? callbacks.has() : false
                }
            }, {
                key: "fireEvent",
                value: function(eventName, eventArgs) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        callbacks.fireWith(this._owner, eventArgs)
                    }
                    return this._owner
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    var _this = this;
                    if ((0, _type.isPlainObject)(eventName)) {
                        (0, _iterator.each)(eventName, function(e, h) {
                            _this.on(e, h)
                        })
                    } else {
                        var callbacks = this._events[eventName];
                        if (!callbacks) {
                            callbacks = (0, _callbacks.default)();
                            this._events[eventName] = callbacks
                        }
                        var addFn = callbacks.originalAdd || callbacks.add;
                        addFn.call(callbacks, eventHandler)
                    }
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        if ((0, _type.isFunction)(eventHandler)) {
                            callbacks.remove(eventHandler)
                        } else {
                            callbacks.empty()
                        }
                    }
                }
            }, {
                key: "dispose",
                value: function() {
                    (0, _iterator.each)(this._events, function(eventName, event) {
                        event.empty()
                    })
                }
            }], [{
                key: "create",
                value: function(owner, strategy) {
                    if (strategy) {
                        return (0, _type.isFunction)(strategy) ? strategy(owner) : strategy
                    } else {
                        return new EventsStrategy(owner)
                    }
                }
            }]);
            return EventsStrategy
        }();
        exports.EventsStrategy = EventsStrategy
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/ui/scheduler/utils.timeZone.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _date = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date */ 19));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./timezones/utils.timezones_data */ 324));
        var _dateAdapter = _interopRequireDefault(__webpack_require__( /*! ./dateAdapter */ 325));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _slicedToArray(arr, i) {
            return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest()
        }

        function _nonIterableRest() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function _iterableToArrayLimit(arr, i) {
            if ("undefined" === typeof Symbol || !(Symbol.iterator in Object(arr))) {
                return
            }
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) {
                        break
                    }
                }
            } catch (err) {
                _d = true;
                _e = err
            } finally {
                try {
                    if (!_n && null != _i.return) {
                        _i.return()
                    }
                } finally {
                    if (_d) {
                        throw _e
                    }
                }
            }
            return _arr
        }

        function _arrayWithHoles(arr) {
            if (Array.isArray(arr)) {
                return arr
            }
        }
        var toMs = _date.default.dateToMilliseconds;
        var MINUTES_IN_HOUR = 60;
        var createUTCDateWithLocalOffset = function(date) {
            if (!date) {
                return null
            }
            return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()))
        };
        var createDateFromUTCWithLocalOffset = function(date) {
            var result = (0, _dateAdapter.default)(date);
            var timezoneOffsetBeforeInMin = result.getTimezoneOffset();
            result.addTime(result.getTimezoneOffset("minute"));
            result.subtractMinutes(timezoneOffsetBeforeInMin - result.getTimezoneOffset());
            return result.source
        };
        var getTimeZones = function() {
            var date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
            var dateInUTC = createUTCDate(date);
            return _utils.default.getDisplayedTimeZones(dateInUTC.getTime())
        };
        var createUTCDate = function(date) {
            return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes()))
        };
        var getTimezoneOffsetChangeInMinutes = function(startDate, endDate, updatedStartDate, updatedEndDate) {
            return getDaylightOffset(updatedStartDate, updatedEndDate) - getDaylightOffset(startDate, endDate)
        };
        var getTimezoneOffsetChangeInMs = function(startDate, endDate, updatedStartDate, updatedEndDate) {
            return getTimezoneOffsetChangeInMinutes(startDate, endDate, updatedStartDate, updatedEndDate) * toMs("minute")
        };
        var getDaylightOffset = function(startDate, endDate) {
            return new Date(startDate).getTimezoneOffset() - new Date(endDate).getTimezoneOffset()
        };
        var getDaylightOffsetInMs = function(startDate, endDate) {
            return getDaylightOffset(startDate, endDate) * toMs("minute")
        };
        var calculateTimezoneByValue = function(timezone) {
            var date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
            if ("string" === typeof timezone) {
                var dateUtc = createUTCDate(date);
                return _utils.default.getTimeZoneOffsetById(timezone, dateUtc.getTime())
            }
            return timezone
        };
        var _getDaylightOffsetByTimezone = function(startDate, endDate, timeZone) {
            return calculateTimezoneByValue(timeZone, startDate) - calculateTimezoneByValue(timeZone, endDate)
        };
        var getCorrectedDateByDaylightOffsets = function(convertedOriginalStartDate, convertedDate, date, timeZone, startDateTimezone) {
            var daylightOffsetByCommonTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, timeZone);
            var daylightOffsetByAppointmentTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, startDateTimezone);
            var diff = daylightOffsetByCommonTimezone - daylightOffsetByAppointmentTimezone;
            return new Date(date.getTime() - diff * toMs("hour"))
        };
        var correctRecurrenceExceptionByTimezone = function(exception, exceptionByStartDate, timeZone, startDateTimeZone) {
            var isBackConversion = arguments.length > 4 && void 0 !== arguments[4] ? arguments[4] : false;
            var timezoneOffset = (exception.getTimezoneOffset() - exceptionByStartDate.getTimezoneOffset()) / MINUTES_IN_HOUR;
            if (startDateTimeZone) {
                timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, startDateTimeZone)
            } else {
                if (timeZone) {
                    timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, timeZone)
                }
            }
            return new Date(exception.getTime() + (isBackConversion ? -1 : 1) * timezoneOffset * toMs("hour"))
        };
        var isTimezoneChangeInDate = function(date) {
            var startDayDate = new Date(new Date(date).setHours(0, 0, 0, 0));
            var endDayDate = new Date(new Date(date).setHours(23, 59, 59, 0));
            return startDayDate.getTimezoneOffset() - endDayDate.getTimezoneOffset() !== 0
        };
        var isSameAppointmentDates = function(startDate, endDate) {
            endDate = new Date(endDate.getTime() - 1);
            return _date.default.sameDate(startDate, endDate)
        };
        var getClientTimezoneOffset = function(date) {
            return 6e4 * date.getTimezoneOffset()
        };
        var isEqualLocalTimeZone = function(timeZoneName) {
            if (Intl) {
                var localTimeZoneName = Intl.DateTimeFormat().resolvedOptions().timeZone;
                if (localTimeZoneName) {
                    return localTimeZoneName === timeZoneName
                }
            }
            return isEqualLocalTimeZoneByNativeDate(timeZoneName)
        };
        var hasDSTInLocalTimeZone = function() {
            var _getExtremeDates = getExtremeDates(),
                _getExtremeDates2 = _slicedToArray(_getExtremeDates, 2),
                startDate = _getExtremeDates2[0],
                endDate = _getExtremeDates2[1];
            return startDate.getTimezoneOffset() !== endDate.getTimezoneOffset()
        };
        var isEqualLocalTimeZoneByNativeDate = function(timeZoneName) {
            var _getExtremeDates3 = getExtremeDates(),
                _getExtremeDates4 = _slicedToArray(_getExtremeDates3, 2),
                startDate = _getExtremeDates4[0],
                endDate = _getExtremeDates4[1];
            var startDateLocalOffset = -startDate.getTimezoneOffset() / 60;
            var endDateLocalOffset = -endDate.getTimezoneOffset() / 60;
            var startDateOffset = calculateTimezoneByValue(timeZoneName, startDate);
            var endDateOffset = calculateTimezoneByValue(timeZoneName, endDate);
            if (startDateLocalOffset === startDateOffset && endDateLocalOffset === endDateOffset) {
                return true
            }
            return false
        };
        var getExtremeDates = function() {
            var nowDate = new Date(Date.now());
            var startDate = new Date;
            var endDate = new Date;
            startDate.setFullYear(nowDate.getFullYear(), 0, 1);
            endDate.setFullYear(nowDate.getFullYear(), 6, 1);
            return [startDate, endDate]
        };
        var utils = {
            getDaylightOffset: getDaylightOffset,
            getDaylightOffsetInMs: getDaylightOffsetInMs,
            getTimezoneOffsetChangeInMinutes: getTimezoneOffsetChangeInMinutes,
            getTimezoneOffsetChangeInMs: getTimezoneOffsetChangeInMs,
            calculateTimezoneByValue: calculateTimezoneByValue,
            getCorrectedDateByDaylightOffsets: getCorrectedDateByDaylightOffsets,
            isTimezoneChangeInDate: isTimezoneChangeInDate,
            isSameAppointmentDates: isSameAppointmentDates,
            correctRecurrenceExceptionByTimezone: correctRecurrenceExceptionByTimezone,
            getClientTimezoneOffset: getClientTimezoneOffset,
            createUTCDateWithLocalOffset: createUTCDateWithLocalOffset,
            createDateFromUTCWithLocalOffset: createDateFromUTCWithLocalOffset,
            createUTCDate: createUTCDate,
            hasDSTInLocalTimeZone: hasDSTInLocalTimeZone,
            isEqualLocalTimeZone: isEqualLocalTimeZone,
            getTimeZones: getTimeZones
        };
        var _default = utils;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/odata/utils.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.escapeServiceOperationParams = exports.formatFunctionInvocationUrl = exports.generateExpand = exports.generateSelect = exports.convertPrimitiveValue = exports.keyConverters = exports.serializeKey = exports.serializeValue = exports.serializePropName = exports.EdmLiteral = exports.sendRequest = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 80));
        var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 36));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 38));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ../utils */ 41));
        var _string = __webpack_require__( /*! ../../core/utils/string */ 43);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
        var makeArray = function(value) {
            return "string" === (0, _type.type)(value) ? value.split() : value
        };
        var hasDot = function(x) {
            return /\./.test(x)
        };
        var pad = function(text, length, right) {
            text = String(text);
            while (text.length < length) {
                text = right ? "".concat(text, "0") : "0".concat(text)
            }
            return text
        };
        var formatISO8601 = function(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            var padLeft2 = function(text) {
                return pad(text, 2)
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(padLeft2(date.getMonth() + 1));
            bag.push("-");
            bag.push(padLeft2(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(padLeft2(date.getHours()));
                bag.push(":");
                bag.push(padLeft2(date.getMinutes()));
                bag.push(":");
                bag.push(padLeft2(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(pad(date.getMilliseconds(), 3))
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        };
        var parseISO8601 = function(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3);
            var chunks = isoString.replace("Z", "").split("T");
            var date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]);
            var time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                var fractional = (time[4] || "").slice(0, 3);
                fractional = pad(fractional, 3, true);
                result.setMilliseconds(Number(fractional))
            }
            return result
        };
        var isAbsoluteUrl = function(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        };
        var stripParams = function(url) {
            var index = url.indexOf("?");
            if (index > -1) {
                return url.substr(0, index)
            }
            return url
        };
        var toAbsoluteUrl = function(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        };
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request) {
            var _options$beforeSend;
            var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
            var formatPayload = function(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw _errors.default.errors.Error("E4002")
                    }
                })
            };
            request = (0, _extend.extend)({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            null === (_options$beforeSend = options.beforeSend) || void 0 === _options$beforeSend ? void 0 : _options$beforeSend.call(options, request);
            var _request = request,
                async = _request.async, timeout = _request.timeout, headers = _request.headers;
            var _request2 = request,
                url = _request2.url,
                method = _request2.method;
            var jsonp = options.jsonp,
                withCredentials = options.withCredentials;
            method = (method || "get").toLowerCase();
            var isGet = "get" === method;
            var useJsonp = isGet && jsonp;
            var params = (0, _extend.extend)({}, request.params);
            var ajaxData = isGet ? params : formatPayload(request.payload);
            var qs = !isGet && param(params);
            var contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: async,
                timeout: timeout,
                headers: headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: withCredentials
                }
            }
        };
        var sendRequest = function sendRequest(protocolVersion, request, options) {
            var deserializeDates = options.deserializeDates,
                fieldTypes = options.fieldTypes,
                countOnly = options.countOnly,
                isPaged = options.isPaged;
            var d = new _deferred.Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            _ajax.default.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var transformOptions = {
                    deserializeDates: deserializeDates,
                    fieldTypes: fieldTypes
                };
                var tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions);
                var error = tuple.error,
                    data = tuple.data,
                    count = tuple.count;
                var nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== _utils.default.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (countOnly) {
                        if (isFinite(count)) {
                            d.resolve(count)
                        } else {
                            d.reject(new _errors.default.errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                return d.resolve(data.concat(nextData))
                            })
                        } else {
                            var extra = isFinite(count) ? {
                                totalCount: count
                            } : void 0;
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        exports.sendRequest = sendRequest;
        var formatDotNetError = function(errorObj) {
            var message;
            var currentError = errorObj;
            if ("message" in errorObj) {
                var _errorObj$message;
                message = (null === (_errorObj$message = errorObj.message) || void 0 === _errorObj$message ? void 0 : _errorObj$message.value) || errorObj.message
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus, ajaxOptions) {
            var _response, _response2, _response3, _response4;
            if ("nocontent" === textStatus) {
                return null
            }
            var message = "Unknown error";
            var response = obj;
            var httpStatus = 200;
            var errorData = {
                requestOptions: ajaxOptions
            };
            if ("success" !== textStatus) {
                var status = obj.status,
                    responseText = obj.responseText;
                httpStatus = status;
                message = _utils.default.errorMessageFromXhr(obj, textStatus);
                try {
                    response = JSON.parse(responseText)
                } catch (x) {}
            }
            var errorObj = (null === (_response = response) || void 0 === _response ? void 0 : _response.then) || (null === (_response2 = response) || void 0 === _response2 ? void 0 : _response2.error) || (null === (_response3 = response) || void 0 === _response3 ? void 0 : _response3["odata.error"]) || (null === (_response4 = response) || void 0 === _response4 ? void 0 : _response4["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                errorData.errorDetails = errorObj;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                var customCode = Number(errorObj.code);
                if (isFinite(customCode) && customCode >= 400) {
                    httpStatus = customCode
                }
            }
            if (httpStatus >= 400 || 0 === httpStatus) {
                errorData.httpStatus = httpStatus;
                return (0, _extend.extend)(Error(message), errorData)
            }
            return null
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
            var error = errorFromResponse(obj, textStatus, ajaxOptions);
            if (error) {
                return {
                    error: error
                }
            }
            if (!(0, _type.isPlainObject)(obj)) {
                return {
                    data: obj
                }
            }
            var value = "d" in obj && (Array.isArray(obj.d) || (0, _type.isObject)(obj.d)) ? interpretVerboseJsonFormat(obj, textStatus) : interpretLightJsonFormat(obj, textStatus);
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(_ref) {
            var _data$results;
            var data = _ref.d;
            if (!(0, _type.isDefined)(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            return {
                data: null !== (_data$results = data.results) && void 0 !== _data$results ? _data$results : data,
                nextUrl: data.__next,
                count: parseInt(data.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var _obj$value;
            return {
                data: null !== (_obj$value = obj.value) && void 0 !== _obj$value ? _obj$value : obj,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = _class.default.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        exports.EdmLiteral = EdmLiteral;
        var transformTypes = function transformTypes(obj) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            (0, _iterator.each)(obj, function(key, value) {
                if (null !== value && "object" === _typeof(value)) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            deserializeDates = options.deserializeDates;
                        var canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _guid.default(value)
                        }
                        if (false !== deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'".concat(formatISO8601(date, true, true), "'")
        };
        var serializeString = function(value) {
            return "'".concat(value.replace(/'/g, "''"), "'")
        };
        var serializePropName = function(propName) {
            return propName instanceof EdmLiteral ? propName.valueOf() : propName.replace(/\./g, "/")
        };
        exports.serializePropName = serializePropName;
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _guid.default) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[".concat(value.map(function(item) {
                    return serializeValueV4(item)
                }).join(","), "]")
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _guid.default) {
                return "guid'".concat(value, "'")
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw _errors.default.errors.Error("E4002")
            }
        };
        exports.serializeValue = serializeValue;
        var serializeKey = function(key, protocolVersion) {
            if ((0, _type.isPlainObject)(key)) {
                var parts = [];
                (0, _iterator.each)(key, function(k, v) {
                    return parts.push("".concat(serializePropName(k), "=").concat(serializeValue(v, protocolVersion)))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        exports.serializeKey = serializeKey;
        var keyConverters = {
            String: function(value) {
                return "".concat(value)
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral("".concat(value, "L"))
            },
            Guid: function(value) {
                return value instanceof _guid.default ? value : new _guid.default(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "m")
            }
        };
        exports.keyConverters = keyConverters;
        var convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw _errors.default.errors.Error("E4014", type)
            }
            return converter(value)
        };
        exports.convertPrimitiveValue = convertPrimitiveValue;
        var generateSelect = function(oDataVersion, select) {
            if (!select) {
                return
            }
            return oDataVersion < 4 ? serializePropName(select.join()) : (0, _common.grep)(select, hasDot, true).join()
        };
        exports.generateSelect = generateSelect;
        var formatCore = function formatCore(hash) {
            var result = "";
            var selectValue = [];
            var expandValue = [];
            (0, _iterator.each)(hash, function(key, value) {
                if (Array.isArray(value)) {
                    [].push.apply(selectValue, value)
                }
                if ((0, _type.isPlainObject)(value)) {
                    expandValue.push("".concat(key).concat(formatCore(value)))
                }
            });
            if (selectValue.length || expandValue.length) {
                result += "(";
                if (selectValue.length) {
                    result += "$select=".concat((0, _iterator.map)(selectValue, serializePropName).join())
                }
                if (expandValue.length) {
                    if (selectValue.length) {
                        result += ";"
                    }
                    result += "$expand=".concat((0, _iterator.map)(expandValue, serializePropName).join())
                }
                result += ")"
            }
            return result
        };
        var format = function(hash) {
            var result = [];
            (0, _iterator.each)(hash, function(key, value) {
                return result.push("".concat(key).concat(formatCore(value)))
            });
            return result.join()
        };
        var parseCore = function parseCore(exprParts, root, stepper) {
            var result = stepper(root, exprParts.shift(), exprParts);
            if (false === result) {
                return
            }
            parseCore(exprParts, result, stepper)
        };
        var parseTree = function(exprs, root, stepper) {
            return (0, _iterator.each)(exprs, function(_, x) {
                return parseCore(x.split("."), root, stepper)
            })
        };
        var generatorV2 = function(expand, select) {
            var hash = {};
            if (expand) {
                (0, _iterator.each)(makeArray(expand), function() {
                    hash[serializePropName(this)] = 1
                })
            }
            if (select) {
                (0, _iterator.each)(makeArray(select), function() {
                    var path = this.split(".");
                    if (path.length < 2) {
                        return
                    }
                    path.pop();
                    hash[serializePropName(path.join("."))] = 1
                })
            }
            return (0, _iterator.map)(hash, function(_, v) {
                return v
            }).join()
        };
        var generatorV4 = function(expand, select) {
            var hash = {};
            if (expand || select) {
                if (expand) {
                    parseTree(makeArray(expand), hash, function(node, key, path) {
                        node[key] = node[key] || {};
                        return !path.length ? false : node[key]
                    })
                }
                if (select) {
                    parseTree((0, _common.grep)(makeArray(select), hasDot), hash, function(node, key, path) {
                        if (!path.length) {
                            node[key] = node[key] || [];
                            node[key].push(key);
                            return false
                        }
                        return node[key] = node[key] || {}
                    })
                }
                return format(hash)
            }
        };
        var generateExpand = function(oDataVersion, expand, select) {
            return oDataVersion < 4 ? generatorV2(expand, select) : generatorV4(expand, select)
        };
        exports.generateExpand = generateExpand;
        var formatFunctionInvocationUrl = function(baseUrl, args) {
            return (0, _string.format)("{0}({1})", baseUrl, (0, _iterator.map)(args || {}, function(value, key) {
                return (0, _string.format)("{0}={1}", key, value)
            }).join(","))
        };
        exports.formatFunctionInvocationUrl = formatFunctionInvocationUrl;
        var escapeServiceOperationParams = function(params, version) {
            if (!params) {
                return params
            }
            var result = {};
            (0, _iterator.each)(params, function(k, v) {
                result[k] = serializeValue(v, version)
            });
            return result
        };
        exports.escapeServiceOperationParams = escapeServiceOperationParams
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/variable_wrapper.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _console = __webpack_require__( /*! ./console */ 109);
        var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 59));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = (0, _dependency_injector.default)({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                _console.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        });
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/emitter_registrator.js ***!
      \*********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 49));
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 40);
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./event_registrator */ 74));
        var _index = __webpack_require__( /*! ../utils/index */ 8);
        var _pointer = _interopRequireDefault(__webpack_require__( /*! ../pointer */ 24));
        var _wheel = __webpack_require__( /*! ./wheel */ 146);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var MANAGER_EVENT = "dxEventManager";
        var EMITTER_DATA = "dxEmitter";
        var EventManager = _class.default.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                _ready_callbacks.default.add(function() {
                    var document = _dom_adapter.default.getDocument();
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)([_pointer.default.up, _pointer.default.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_wheel.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if ((0, _index.isMouseEvent)(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                (0, _iterator.each)(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this;
                var result = [];
                var $element = (0, _renderer.default)(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = (0, _element_data.data)($element.get(0), EMITTER_DATA) || [];
                    (0, _iterator.each)(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = (0, _array.inArray)(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e);
                var verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction;
                var prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter;
            var emitterName = emitterConfig.events[0];
            var emitterEvents = emitterConfig.events;
            (0, _iterator.each)(emitterEvents, function(_, eventName) {
                (0, _event_registrator.default)(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA) || {};
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA) || {};
                        var emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        (0, _element_data.data)(element, EMITTER_DATA, emitters);
                        (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        emitter.configure((0, _extend.extend)({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = (0, _element_data.data)(element, EMITTER_SUBSCRIPTION_DATA);
                        var emitters = (0, _element_data.data)(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        (0, _iterator.each)(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        var _default = registerEmitter;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/events/hold.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _index = __webpack_require__( /*! ./utils/index */ 8);
        var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 132));
        var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 102));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold";
        var HOLD_TIMEOUT = 750;
        var TOUCH_BOUNDARY = 5;
        var HoldEmitter = _emitter.default.inherit({
            start: function(e) {
                this._startEventData = (0, _index.eventData)(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        (0, _emitter_registrator.default)({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        var _default = {
            name: HOLD_EVENT_NAME
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/data/abstract_store.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 15));
        var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 98);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _store_helper = _interopRequireDefault(__webpack_require__( /*! ./store_helper */ 92));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _class.default.abstract;
        var queryByOptions = _store_helper.default.queryByOptions;
        var storeImpl = {};
        var Store = _class.default.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = (0, _data.compileGetter)(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw _errors.default.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that._eventsStrategy.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new _deferred.Deferred;
                task.done(function() {
                    var that = this;
                    var args = arguments;
                    _utils.default.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function() {
                    that._eventsStrategy.fireEvent("updated", [key, values]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            push: function(changes) {
                this._pushImpl(changes);
                this._eventsStrategy.fireEvent("push", [changes])
            },
            _pushImpl: _common.noop,
            remove: function(key) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that._eventsStrategy.fireEvent("removed", [callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(_errors.default._errorHandler)
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw _errors.default.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.registerClass = function(type, alias) {
            if (alias) {
                storeImpl[alias] = type
            }
            return type
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                Store.registerClass(type, alias);
                return type
            }
        }(Store.inherit);
        var _default = Store;
        exports.default = _default;
        module.exports = exports.default
    }, , ,
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/core/export.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.plugin = exports.ExportMenu = exports.combineMarkups = exports.exportWidgets = exports.getMarkup = exports.exportFromMarkup = void 0;
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _utils = __webpack_require__( /*! ./utils */ 12);
        var _exporter = __webpack_require__( /*! ../../exporter */ 193);
        var _message = _interopRequireDefault(__webpack_require__( /*! ../../localization/message */ 10));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _themes = __webpack_require__( /*! ../themes */ 56);
        var _hover = __webpack_require__( /*! ../../events/hover */ 153);
        var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../events/pointer */ 24));
        var _console = __webpack_require__( /*! ../../core/utils/console */ 109);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var pointerActions = [_pointer.default.down, _pointer.default.move].join(" ");
        var BUTTON_SIZE = 35;
        var ICON_COORDS = [
            [9, 12, 26, 12, 26, 14, 9, 14],
            [9, 17, 26, 17, 26, 19, 9, 19],
            [9, 22, 26, 22, 26, 24, 9, 24]
        ];
        var LIST_PADDING_TOP = 4;
        var LIST_WIDTH = 120;
        var VERTICAL_TEXT_MARGIN = 8;
        var HORIZONTAL_TEXT_MARGIN = 15;
        var MENU_ITEM_HEIGHT = 30;
        var LIST_STROKE_WIDTH = 1;
        var MARGIN = 10;
        var SHADOW_OFFSET = 2;
        var SHADOW_BLUR = 3;
        var DEFAULT_EXPORT_FORMAT = "PNG";
        var ALLOWED_IMAGE_FORMATS = [DEFAULT_EXPORT_FORMAT, "JPEG", "GIF"];
        var ALLOWED_EXTRA_FORMATS = ["PDF", "SVG"];
        var EXPORT_CSS_CLASS = "dx-export-menu";
        var EXPORT_DATA_KEY = "export-element-type";
        var FORMAT_DATA_KEY = "export-element-format";
        var GET_COLOR_REGEX = /data-backgroundcolor="([^"]*)"/;

        function getValidFormats() {
            var imageFormats = _exporter.image.testFormats(ALLOWED_IMAGE_FORMATS);
            return {
                unsupported: imageFormats.unsupported,
                supported: imageFormats.supported.concat(ALLOWED_EXTRA_FORMATS)
            }
        }

        function validateFormat(format, incidentOccurred, validFormats) {
            validFormats = validFormats || getValidFormats();
            format = String(format).toUpperCase();
            if (validFormats.supported.indexOf(format) !== -1) {
                return format
            }
            if (validFormats.unsupported.indexOf(format) !== -1) {
                incidentOccurred && incidentOccurred("W2108", [format])
            }
        }

        function getCreatorFunc(format) {
            if ("SVG" === format) {
                return _exporter.svg.getData
            } else {
                if ("PDF" === format) {
                    return _exporter.pdf.getData
                } else {
                    return _exporter.image.getData
                }
            }
        }

        function _print(imageSrc, options) {
            var document = (0, _window.getWindow)().document;
            var iFrame = document.createElement("iframe");
            iFrame.onload = setPrint(imageSrc, options);
            iFrame.style.position = "fixed";
            iFrame.style.width = "0";
            iFrame.style.height = "0";
            iFrame.style.right = "0";
            iFrame.style.bottom = "0";
            document.body.appendChild(iFrame)
        }

        function setPrint(imageSrc, options) {
            return function() {
                var _this = this;
                var window = this.contentWindow;
                var img = window.document.createElement("img");
                window.document.body.appendChild(img);
                var removeFrame = function() {
                    _this.parentElement.removeChild(_this)
                };
                img.addEventListener("load", function() {
                    window.focus();
                    window.print()
                });
                img.addEventListener("error", removeFrame);
                window.addEventListener("afterprint", function() {
                    setTimeout(removeFrame, 0)
                });
                img.src = imageSrc
            }
        }

        function getItemAttributes(options, type, itemIndex) {
            var x = BUTTON_SIZE - LIST_WIDTH;
            var y = BUTTON_SIZE + LIST_PADDING_TOP + LIST_STROKE_WIDTH + itemIndex * MENU_ITEM_HEIGHT;
            var attr = {
                rect: {
                    width: LIST_WIDTH - 2 * LIST_STROKE_WIDTH,
                    height: MENU_ITEM_HEIGHT,
                    x: x + LIST_STROKE_WIDTH,
                    y: y
                },
                text: {
                    x: x + (options.rtl ? LIST_WIDTH - HORIZONTAL_TEXT_MARGIN : HORIZONTAL_TEXT_MARGIN),
                    y: y + MENU_ITEM_HEIGHT - VERTICAL_TEXT_MARGIN
                }
            };
            if ("printing" === type) {
                attr.separator = {
                    stroke: options.button.default.borderColor,
                    "stroke-width": LIST_STROKE_WIDTH,
                    cursor: "pointer",
                    sharp: "v",
                    d: "M " + x + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH) + " L " + (x + LIST_WIDTH) + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH)
                }
            }
            return attr
        }

        function createMenuItem(renderer, options, settings) {
            var itemData = {};
            var type = settings.type;
            var format = settings.format;
            var attr = getItemAttributes(options, type, settings.itemIndex);
            var fontStyle = (0, _utils.patchFontOptions)(options.font);
            fontStyle["pointer-events"] = "none";
            var menuItem = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list-item"
            });
            itemData[EXPORT_DATA_KEY] = type;
            if (format) {
                itemData[FORMAT_DATA_KEY] = format
            }
            var rect = renderer.rect();
            rect.attr(attr.rect).css({
                cursor: "pointer",
                "pointer-events": "all"
            }).data(itemData);
            rect.on(_hover.start + ".export", function() {
                return rect.attr({
                    fill: options.button.hover.backgroundColor
                })
            }).on(_hover.end + ".export", function() {
                return rect.attr({
                    fill: null
                })
            });
            rect.append(menuItem);
            var text = renderer.text(settings.text).css(fontStyle).attr(attr.text).append(menuItem);
            if ("printing" === type) {
                renderer.path(null, "line").attr(attr.separator).append(menuItem)
            }
            return {
                g: menuItem,
                rect: rect,
                resetState: function() {
                    return rect.attr({
                        fill: null
                    })
                },
                fixPosition: function() {
                    var textBBox = text.getBBox();
                    text.move(attr.text.x - textBBox.x - (options.rtl ? textBBox.width : 0))
                }
            }
        }

        function createMenuItems(renderer, options) {
            var items = [];
            if (options.printingEnabled) {
                items.push(createMenuItem(renderer, options, {
                    type: "printing",
                    text: _message.default.format("vizExport-printingButtonText"),
                    itemIndex: items.length
                }))
            }
            items = options.formats.reduce(function(r, format) {
                r.push(createMenuItem(renderer, options, {
                    type: "exporting",
                    text: _message.default.getFormatter("vizExport-exportButtonText")(format),
                    format: format,
                    itemIndex: r.length
                }));
                return r
            }, items);
            return items
        }

        function getBackgroundColorFromMarkup(markup) {
            var parsedMarkup = GET_COLOR_REGEX.exec(markup);
            return null === parsedMarkup || void 0 === parsedMarkup ? void 0 : parsedMarkup[1]
        }
        var exportFromMarkup = function(markup, options) {
            options.format = validateFormat(options.format) || DEFAULT_EXPORT_FORMAT;
            options.fileName = options.fileName || "file";
            options.exportingAction = options.onExporting;
            options.exportedAction = options.onExported;
            options.fileSavingAction = options.onFileSaving;
            options.margin = (0, _type.isDefined)(options.margin) ? options.margin : MARGIN;
            options.backgroundColor = (0, _type.isDefined)(options.backgroundColor) ? options.backgroundColor : getBackgroundColorFromMarkup(markup) || (0, _themes.getTheme)().backgroundColor;
            (0, _exporter.export)(markup, options, getCreatorFunc(options.format))
        };
        exports.exportFromMarkup = exportFromMarkup;
        var getMarkup = function(widgets) {
            return combineMarkups(widgets).markup
        };
        exports.getMarkup = getMarkup;
        var exportWidgets = function(widgets, options) {
            options = options || {};
            var markupInfo = combineMarkups(widgets, {
                gridLayout: options.gridLayout,
                verticalAlignment: options.verticalAlignment,
                horizontalAlignment: options.horizontalAlignment
            });
            options.width = markupInfo.width;
            options.height = markupInfo.height;
            exportFromMarkup(markupInfo.markup, options)
        };
        exports.exportWidgets = exportWidgets;
        var combineMarkups = function(widgets) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            if (!Array.isArray(widgets)) {
                widgets = [
                    [widgets]
                ]
            } else {
                if (!Array.isArray(widgets[0])) {
                    widgets = widgets.map(function(item) {
                        return [item]
                    })
                }
            }
            var compactView = !options.gridLayout;
            var exportItems = widgets.reduce(function(r, row, rowIndex) {
                var rowInfo = row.reduce(function(r, item, colIndex) {
                    var size = item.getSize();
                    var backgroundColor = item.option("backgroundColor") || (0, _themes.getTheme)(item.option("theme")).backgroundColor;
                    backgroundColor && r.backgroundColors.indexOf(backgroundColor) === -1 && r.backgroundColors.push(backgroundColor);
                    r.hOffset = r.width;
                    r.width += size.width;
                    r.height = Math.max(r.height, size.height);
                    r.itemWidth = Math.max(r.itemWidth, size.width);
                    r.items.push({
                        markup: item.svg(),
                        width: size.width,
                        height: size.height,
                        c: colIndex,
                        r: rowIndex,
                        hOffset: r.hOffset
                    });
                    return r
                }, {
                    items: [],
                    height: 0,
                    itemWidth: 0,
                    hOffset: 0,
                    width: 0,
                    backgroundColors: r.backgroundColors
                });
                r.rowOffsets.push(r.totalHeight);
                r.rowHeights.push(rowInfo.height);
                r.totalHeight += rowInfo.height;
                r.items = r.items.concat(rowInfo.items);
                r.itemWidth = Math.max(r.itemWidth, rowInfo.itemWidth);
                r.maxItemLen = Math.max(r.maxItemLen, rowInfo.items.length);
                r.totalWidth = compactView ? Math.max(r.totalWidth, rowInfo.width) : r.maxItemLen * r.itemWidth;
                return r
            }, {
                items: [],
                rowOffsets: [],
                rowHeights: [],
                itemWidth: 0,
                totalHeight: 0,
                maxItemLen: 0,
                totalWidth: 0,
                backgroundColors: []
            });
            var backgroundColor = 'data-backgroundcolor="'.concat(1 === exportItems.backgroundColors.length ? exportItems.backgroundColors[0] : "", '" ');
            var getVOffset = function(item) {
                var align = options.verticalAlignment;
                var dy = exportItems.rowHeights[item.r] - item.height;
                return exportItems.rowOffsets[item.r] + ("bottom" === align ? dy : "center" === align ? dy / 2 : 0)
            };
            var getHOffset = function(item) {
                if (compactView) {
                    return item.hOffset
                }
                var align = options.horizontalAlignment;
                var colWidth = exportItems.itemWidth;
                var dx = colWidth - item.width;
                return item.c * colWidth + ("right" === align ? dx : "center" === align ? dx / 2 : 0)
            };
            var totalHeight = exportItems.totalHeight;
            var totalWidth = exportItems.totalWidth;
            return {
                markup: "<svg " + backgroundColor + 'height="' + totalHeight + '" width="' + totalWidth + '" version="1.1" xmlns="http://www.w3.org/2000/svg">' + exportItems.items.map(function(item) {
                    return '<g transform="translate('.concat(getHOffset(item), ",").concat(getVOffset(item), ')">').concat(item.markup, "</g>")
                }).join("") + "</svg>",
                width: totalWidth,
                height: totalHeight
            }
        };
        exports.combineMarkups = combineMarkups;
        var ExportMenu = function(params) {
            var renderer = this._renderer = params.renderer;
            this._incidentOccurred = params.incidentOccurred;
            this._exportTo = params.exportTo;
            this._print = params.print;
            this._shadow = renderer.shadowFilter("-50%", "-50%", "200%", "200%", SHADOW_OFFSET, 6, SHADOW_BLUR);
            this._shadow.attr({
                opacity: .8
            });
            this._group = renderer.g().attr({
                "class": EXPORT_CSS_CLASS,
                "hidden-for-export": true
            }).linkOn(renderer.root, {
                name: "export-menu",
                after: "peripheral"
            });
            this._buttonGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-button"
            }).append(this._group);
            this._listGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list"
            }).append(this._group);
            this._overlay = renderer.rect(-LIST_WIDTH + BUTTON_SIZE, BUTTON_SIZE + LIST_PADDING_TOP, LIST_WIDTH, 0);
            this._overlay.attr({
                "stroke-width": LIST_STROKE_WIDTH,
                cursor: "pointer",
                rx: 4,
                ry: 4,
                filter: this._shadow.id
            });
            this._overlay.data({
                "export-element-type": "list"
            });
            this.validFormats = getValidFormats();
            this._subscribeEvents()
        };
        exports.ExportMenu = ExportMenu;
        (0, _extend.extend)(ExportMenu.prototype, {
            getLayoutOptions: function() {
                if (this._hiddenDueToLayout) {
                    return {
                        width: 0,
                        height: 0,
                        cutSide: "vertical",
                        cutLayoutSide: "top"
                    }
                }
                var bBox = this._buttonGroup.getBBox();
                bBox.cutSide = "vertical";
                bBox.cutLayoutSide = "top";
                bBox.height += MARGIN;
                bBox.position = {
                    vertical: "top",
                    horizontal: "right"
                };
                bBox.verticalAlignment = "top";
                bBox.horizontalAlignment = "right";
                return bBox
            },
            shift: function(_, y) {
                this._group.attr({
                    translateY: this._group.attr("translateY") + y
                })
            },
            draw: function(width, height, canvas) {
                this._group.move(width - BUTTON_SIZE - SHADOW_OFFSET - SHADOW_BLUR + canvas.left, Math.floor(height / 2 - BUTTON_SIZE / 2));
                var layoutOptions = this.getLayoutOptions();
                if (layoutOptions.width > width || layoutOptions.height > height) {
                    this.freeSpace()
                }
                return this
            },
            show: function() {
                this._group.linkAppend()
            },
            hide: function() {
                this._group.linkRemove()
            },
            setOptions: function(options) {
                var _this2 = this;
                this._options = options;
                if (options.formats) {
                    options.formats = options.formats.reduce(function(r, format) {
                        format = validateFormat(format, _this2._incidentOccurred, _this2.validFormats);
                        format && r.push(format);
                        return r
                    }, [])
                } else {
                    options.formats = this.validFormats.supported.slice()
                }
                options.printingEnabled = void 0 === options.printingEnabled ? true : options.printingEnabled;
                if (options.enabled && (options.formats.length || options.printingEnabled)) {
                    this.show();
                    this._updateButton();
                    this._updateList();
                    this._hideList()
                } else {
                    this.hide()
                }
            },
            dispose: function() {
                this._unsubscribeEvents();
                this._group.linkRemove().linkOff();
                this._group.dispose();
                this._shadow.dispose()
            },
            layoutOptions: function() {
                return this._options.enabled && {
                    horizontalAlignment: "right",
                    verticalAlignment: "top",
                    weak: true
                }
            },
            measure: function() {
                this._fillSpace();
                var margin = this._options.button.margin;
                return [BUTTON_SIZE + margin.left + margin.right, BUTTON_SIZE + margin.top + margin.bottom]
            },
            move: function(rect) {
                var margin = this._options.button.margin;
                this._group.attr({
                    translateX: Math.round(rect[0]) + margin.left,
                    translateY: Math.round(rect[1]) + margin.top
                })
            },
            _fillSpace: function() {
                this._hiddenDueToLayout = false;
                this.show()
            },
            freeSpace: function() {
                this._incidentOccurred("W2107");
                this._hiddenDueToLayout = true;
                this.hide()
            },
            _hideList: function() {
                this._listGroup.remove();
                this._listShown = false;
                this._setButtonState("default");
                this._menuItems.forEach(function(item) {
                    return item.resetState()
                })
            },
            _showList: function() {
                this._listGroup.append(this._group);
                this._listShown = true;
                this._menuItems.forEach(function(item) {
                    return item.fixPosition()
                })
            },
            _setButtonState: function(state) {
                var style = this._options.button[state];
                this._button.attr({
                    stroke: style.borderColor,
                    fill: style.backgroundColor
                });
                this._icon.attr({
                    fill: style.color
                })
            },
            _subscribeEvents: function() {
                var _this3 = this;
                this._renderer.root.on(_pointer.default.up + ".export", function(e) {
                    var elementType = e.target[EXPORT_DATA_KEY];
                    if (!elementType) {
                        if (_this3._button) {
                            _this3._hideList()
                        }
                        return
                    }
                    if ("button" === elementType) {
                        if (_this3._listShown) {
                            _this3._setButtonState("default");
                            _this3._hideList()
                        } else {
                            _this3._setButtonState("focus");
                            _this3._showList()
                        }
                    } else {
                        if ("printing" === elementType) {
                            _this3._print();
                            _this3._hideList()
                        } else {
                            if ("exporting" === elementType) {
                                _this3._exportTo(e.target[FORMAT_DATA_KEY]);
                                _this3._hideList()
                            }
                        }
                    }
                });
                this._listGroup.on(pointerActions, function(e) {
                    return e.stopPropagation()
                });
                this._buttonGroup.on(_pointer.default.enter, function() {
                    return _this3._setButtonState("hover")
                });
                this._buttonGroup.on(_pointer.default.leave, function() {
                    return _this3._setButtonState(_this3._listShown ? "focus" : "default")
                });
                this._buttonGroup.on(_pointer.default.down + ".export", function() {
                    return _this3._setButtonState("active")
                })
            },
            _unsubscribeEvents: function() {
                this._renderer.root.off(".export");
                this._listGroup.off();
                this._buttonGroup.off()
            },
            _updateButton: function() {
                var renderer = this._renderer;
                var options = this._options;
                var exportData = {
                    "export-element-type": "button"
                };
                if (!this._button) {
                    this._button = renderer.rect(0, 0, BUTTON_SIZE, BUTTON_SIZE).append(this._buttonGroup);
                    this._button.attr({
                        rx: 4,
                        ry: 4,
                        fill: options.button.default.backgroundColor,
                        stroke: options.button.default.borderColor,
                        "stroke-width": 1,
                        cursor: "pointer"
                    });
                    this._button.data(exportData);
                    this._icon = renderer.path(ICON_COORDS).append(this._buttonGroup);
                    this._icon.attr({
                        fill: options.button.default.color,
                        cursor: "pointer"
                    });
                    this._icon.data(exportData);
                    this._buttonGroup.setTitle(_message.default.format("vizExport-titleMenuText"))
                }
            },
            _updateList: function() {
                var options = this._options;
                var buttonDefault = options.button.default;
                var listGroup = this._listGroup;
                var items = createMenuItems(this._renderer, options);
                this._shadow.attr({
                    color: options.shadowColor
                });
                this._overlay.attr({
                    height: items.length * MENU_ITEM_HEIGHT + 2 * LIST_STROKE_WIDTH,
                    fill: buttonDefault.backgroundColor,
                    stroke: buttonDefault.borderColor
                });
                listGroup.clear();
                this._overlay.append(listGroup);
                items.forEach(function(item) {
                    return item.g.append(listGroup)
                });
                this._menuItems = items
            }
        });

        function getExportOptions(widget, exportOptions, fileName, format) {
            if (format || exportOptions.format) {
                format = validateFormat(format || exportOptions.format, widget._incidentOccurred)
            }
            return {
                format: format || DEFAULT_EXPORT_FORMAT,
                fileName: fileName || exportOptions.fileName || "file",
                proxyUrl: exportOptions.proxyUrl,
                backgroundColor: exportOptions.backgroundColor,
                width: widget._canvas.width,
                height: widget._canvas.height,
                margin: exportOptions.margin,
                svgToCanvas: exportOptions.svgToCanvas,
                forceProxy: exportOptions.forceProxy,
                exportingAction: widget._createActionByOption("onExporting"),
                exportedAction: widget._createActionByOption("onExported"),
                fileSavingAction: widget._createActionByOption("onFileSaving")
            }
        }
        var plugin = {
            name: "export",
            init: function() {
                var _this4 = this;
                this._exportMenu = new ExportMenu({
                    renderer: this._renderer,
                    incidentOccurred: this._incidentOccurred,
                    print: function() {
                        return _this4.print()
                    },
                    exportTo: function(format) {
                        return _this4.exportTo(void 0, format)
                    }
                });
                this._layout.add(this._exportMenu)
            },
            dispose: function() {
                this._exportMenu.dispose()
            },
            members: {
                _getExportMenuOptions: function() {
                    return (0, _extend.extend)({}, this._getOption("export"), {
                        rtl: this._getOption("rtlEnabled", true)
                    })
                },
                _disablePointerEvents: function() {
                    var pointerEventsValue = this._renderer.root.attr("pointer-events");
                    this._renderer.root.attr({
                        "pointer-events": "none"
                    });
                    return pointerEventsValue
                },
                exportTo: function(fileName, format) {
                    var _this5 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {}, fileName, format);
                    menu && menu.hide();
                    var pointerEventsValue = this._disablePointerEvents();
                    var promise = (0, _exporter.export)(this._renderer.root.element, options, getCreatorFunc(options.format)).fail(_console.logger.error).always(function() {
                        _this5._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show();
                    return promise
                },
                print: function() {
                    var _this6 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {});
                    options.exportingAction = null;
                    options.exportedAction = null;
                    options.margin = 0;
                    options.format = "PNG";
                    options.forceProxy = true;
                    options.fileSavingAction = function(eventArgs) {
                        _print("data:image/png;base64,".concat(eventArgs.data), {
                            __test: options.__test
                        });
                        eventArgs.cancel = true
                    };
                    var pointerEventsValue = this._disablePointerEvents();
                    menu && menu.hide();
                    var promise = (0, _exporter.export)(this._renderer.root.element, options, getCreatorFunc(options.format)).fail(_console.logger.error).always(function() {
                        _this6._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show();
                    return promise
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                constructor.addChange({
                    code: "EXPORT",
                    handler: function() {
                        this._exportMenu.setOptions(this._getExportMenuOptions());
                        this._change(["LAYOUT"])
                    },
                    isThemeDependent: true,
                    isOptionChange: true,
                    option: "export"
                });
                proto._optionChangesMap.onExporting = "EXPORT";
                proto._optionChangesMap.onExported = "EXPORT";
                proto._optionChangesMap.onFileSaving = "EXPORT"
            },
            fontFields: ["export.font"]
        };
        exports.plugin = plugin
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/tree_map/tree_map.base.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _common = __webpack_require__( /*! ./common */ 319);
        var _node = _interopRequireDefault(__webpack_require__( /*! ./node */ 192));
        var _tiling = __webpack_require__( /*! ./tiling */ 164);
        var _colorizing = __webpack_require__( /*! ./colorizing */ 231);
        var _utils = __webpack_require__( /*! ../core/utils */ 12);
        var _common2 = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _base_widget = _interopRequireDefault(__webpack_require__( /*! ../core/base_widget */ 112));
        __webpack_require__( /*! ./tiling.squarified */ 481);
        __webpack_require__( /*! ./colorizing.discrete */ 483);
        var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 9));
        var _data_source = __webpack_require__( /*! ../core/data_source */ 163);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _max = Math.max;
        var directions = {
            lefttoprightbottom: [1, 1],
            leftbottomrighttop: [1, -1],
            righttopleftbottom: [-1, 1],
            rightbottomlefttop: [-1, -1]
        };
        (0, _tiling.setDefaultAlgorithm)("squarified");
        (0, _colorizing.setDefaultColorizer)("discrete");

        function pickPositiveInteger(val) {
            return val > 0 ? Math.round(val) : 0
        }
        var dxTreeMap = _base_widget.default.inherit({
            _handlers: {
                beginBuildNodes: _common2.noop,
                buildNode: _common2.noop,
                endBuildNodes: _common2.noop,
                setTrackerData: _common2.noop,
                calculateState: function(options) {
                    return (0, _common.buildRectAppearance)(options)
                }
            },
            _rootClass: "dxtm-tree-map",
            _rootClassPrefix: "dxtm",
            _getDefaultSize: function() {
                return {
                    width: 400,
                    height: 400
                }
            },
            _themeSection: "treeMap",
            _fontFields: ["tile.label.font", "group.label.font"],
            _init: function() {
                var that = this;
                that._rectOffsets = {};
                that._handlers = Object.create(that._handlers);
                that._context = {
                    suspend: function() {
                        if (!that._applyingChanges) {
                            that._suspendChanges()
                        }
                    },
                    resume: function() {
                        if (!that._applyingChanges) {
                            that._resumeChanges()
                        }
                    },
                    change: function(codes) {
                        that._change(codes)
                    },
                    settings: [{}, {}],
                    calculateState: that._handlers.calculateState,
                    calculateLabelState: _common.buildTextAppearance
                };
                that._root = that._topNode = {
                    nodes: []
                };
                that.callBase.apply(that, arguments)
            },
            _initialChanges: ["DATA_SOURCE"],
            _initCore: function() {
                var that = this;
                var renderer = that._renderer;
                that._createProxyType();
                that._tilesGroup = renderer.g().linkOn(renderer.root, "tiles").linkAppend();
                that._labelsGroup = renderer.g().linkOn(renderer.root, "labels").linkAppend()
            },
            _createProxyType: _common2.noop,
            _disposeCore: function() {
                var that = this;
                that._filter && that._filter.dispose();
                that._labelsGroup.linkOff();
                that._tilesGroup.linkOff()
            },
            _applySize: function(rect) {
                this._tilingRect = rect.slice();
                this._change(["TILING"])
            },
            _optionChangesMap: {
                dataSource: "DATA_SOURCE",
                valueField: "NODES_CREATE",
                childrenField: "NODES_CREATE",
                colorField: "TILES",
                colorizer: "TILES",
                labelField: "LABELS",
                tile: "TILE_SETTINGS",
                group: "GROUP_SETTINGS",
                maxDepth: "MAX_DEPTH",
                layoutAlgorithm: "TILING",
                layoutDirection: "TILING"
            },
            _themeDependentChanges: ["TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH"],
            _changeDataSource: function() {
                var that = this;
                that._isDataExpected = that._isSyncData = true;
                that._updateDataSource();
                that._isSyncData = false;
                if (that._isDataExpected) {
                    that._suspendChanges()
                }
            },
            _dataSourceChangedHandler: function() {
                var that = this;
                if (that._isDataExpected) {
                    that._isDataExpected = false;
                    that._change(["NODES_CREATE"]);
                    if (!that._isSyncData) {
                        that._resumeChanges()
                    }
                } else {
                    that._requestChange(["NODES_CREATE"])
                }
            },
            _optionChangesOrder: ["DATA_SOURCE", "TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH"],
            _change_DATA_SOURCE: function() {
                this._changeDataSource()
            },
            _change_TILE_SETTINGS: function() {
                this._changeTileSettings()
            },
            _change_GROUP_SETTINGS: function() {
                this._changeGroupSettings()
            },
            _change_MAX_DEPTH: function() {
                this._changeMaxDepth()
            },
            _customChangesOrder: ["NODES_CREATE", "NODES_RESET", "TILES", "LABELS", "TILING", "LABELS_LAYOUT"],
            _change_NODES_CREATE: function() {
                this._buildNodes()
            },
            _change_NODES_RESET: function() {
                this._resetNodes()
            },
            _change_TILES: function() {
                this._applyTilesAppearance()
            },
            _change_LABELS: function() {
                this._applyLabelsAppearance()
            },
            _change_TILING: function() {
                this._performTiling()
            },
            _change_LABELS_LAYOUT: function() {
                this._performLabelsLayout()
            },
            _applyChanges: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                if (!that._isDataExpected) {
                    that._drawn()
                }
                that._context.forceReset = false
            },
            _buildNodes: function() {
                var that = this;
                var root = that._root = that._topNode = new _node.default;
                root._id = 0;
                root.parent = {};
                root.data = {};
                root.level = root.index = -1;
                root.ctx = that._context;
                root.label = null;
                that._nodes = [root];
                that._handlers.beginBuildNodes();
                var processedData = that._processDataSourceItems(that._dataSourceItems() || []);
                traverseDataItems(root, processedData.items, 0, {
                    itemsField: !processedData.isPlain && that._getOption("childrenField", true) || "items",
                    valueField: that._getOption("valueField", true) || "value",
                    buildNode: that._handlers.buildNode,
                    ctx: that._context,
                    nodes: that._nodes
                });
                that._onNodesCreated();
                that._handlers.endBuildNodes();
                that._change(["NODES_RESET"])
            },
            _onNodesCreated: _common2.noop,
            _processDataSourceItems: function(items) {
                return {
                    items: items,
                    isPlain: false
                }
            },
            _changeTileSettings: function() {
                var that = this;
                var options = that._getOption("tile");
                var offsets = that._rectOffsets;
                var borderWidth = pickPositiveInteger(options.border.width);
                var edgeOffset = borderWidth / 2;
                var innerOffset = 1 & borderWidth ? .5 : 0;
                var labelOptions = options.label;
                var settings = that._context.settings[0];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._filter = that._filter || that._renderer.shadowFilter("-50%", "-50%", "200%", "200%");
                that._filter.attr(labelOptions.shadow);
                that._calculateLabelSettings(settings, labelOptions, that._filter.id);
                if (offsets.tileEdge !== edgeOffset || offsets.tileInner !== innerOffset) {
                    offsets.tileEdge = edgeOffset;
                    offsets.tileInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _changeGroupSettings: function() {
                var that = this;
                var options = that._getOption("group");
                var labelOptions = options.label;
                var offsets = that._rectOffsets;
                var borderWidth = pickPositiveInteger(options.border.width);
                var edgeOffset = borderWidth / 2;
                var innerOffset = 1 & borderWidth ? .5 : 0;
                var headerHeight = 0;
                var groupPadding = pickPositiveInteger(options.padding);
                var settings = that._context.settings[1];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._calculateLabelSettings(settings, labelOptions);
                if (options.headerHeight >= 0) {
                    headerHeight = pickPositiveInteger(options.headerHeight)
                } else {
                    headerHeight = settings.labelParams.height + 2 * pickPositiveInteger(labelOptions.paddingTopBottom)
                }
                if (that._headerHeight !== headerHeight) {
                    that._headerHeight = headerHeight;
                    that._change(["TILING"])
                }
                if (that._groupPadding !== groupPadding) {
                    that._groupPadding = groupPadding;
                    that._change(["TILING"])
                }
                if (offsets.headerEdge !== edgeOffset || offsets.headerInner !== innerOffset) {
                    offsets.headerEdge = edgeOffset;
                    offsets.headerInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _calculateLabelSettings: function(settings, options, filter) {
                var bBox = this._getTextBBox(options.font);
                var paddingLeftRight = pickPositiveInteger(options.paddingLeftRight);
                var paddingTopBottom = pickPositiveInteger(options.paddingTopBottom);
                var tileLabelOptions = this._getOption("tile.label");
                var groupLabelOptions = this._getOption("group.label");
                settings.labelState = (0, _common.buildTextAppearance)(options, filter);
                settings.labelState.visible = !("visible" in options) || !!options.visible;
                settings.labelParams = {
                    height: bBox.height,
                    rtlEnabled: this._getOption("rtlEnabled", true),
                    paddingTopBottom: paddingTopBottom,
                    paddingLeftRight: paddingLeftRight,
                    tileLabelWordWrap: tileLabelOptions.wordWrap,
                    tileLabelOverflow: tileLabelOptions.textOverflow,
                    groupLabelOverflow: groupLabelOptions.textOverflow
                }
            },
            _changeMaxDepth: function() {
                var maxDepth = this._getOption("maxDepth", true);
                maxDepth = maxDepth >= 1 ? Math.round(maxDepth) : 1 / 0;
                if (this._maxDepth !== maxDepth) {
                    this._maxDepth = maxDepth;
                    this._change(["NODES_RESET"])
                }
            },
            _resetNodes: function() {
                var that = this;
                that._tilesGroup.clear();
                that._renderer.initHatching();
                that._context.forceReset = true;
                that._context.minLevel = that._topNode.level + 1;
                that._context.maxLevel = that._context.minLevel + that._maxDepth - 1;
                that._change(["TILES", "LABELS", "TILING"])
            },
            _processNodes: function(context, process) {
                processNodes(context, this._topNode, process)
            },
            _applyTilesAppearance: function() {
                var that = this;
                var colorizer = (0, _colorizing.getColorizer)(that._getOption("colorizer"), that._themeManager, that._topNode);
                that._processNodes({
                    renderer: that._renderer,
                    group: that._tilesGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    colorField: that._getOption("colorField", true) || "color",
                    getColor: colorizer
                }, processTileAppearance)
            },
            _applyLabelsAppearance: function() {
                var that = this;
                that._labelsGroup.clear();
                that._processNodes({
                    renderer: that._renderer,
                    group: that._labelsGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    labelField: that._getOption("labelField", true) || "name"
                }, processLabelAppearance);
                that._change(["LABELS_LAYOUT"])
            },
            _performTiling: function() {
                var that = this;
                var context = {
                    algorithm: (0, _tiling.getAlgorithm)(that._getOption("layoutAlgorithm", true)),
                    directions: directions[String(that._getOption("layoutDirection", true)).toLowerCase()] || directions.lefttoprightbottom,
                    headerHeight: that._headerHeight,
                    groupPadding: that._groupPadding,
                    rectOffsets: that._rectOffsets
                };
                that._topNode.innerRect = that._tilingRect;
                calculateRects(context, that._topNode);
                that._processNodes(context, processTiling);
                that._change(["LABELS_LAYOUT"]);
                that._onTilingPerformed()
            },
            _onTilingPerformed: _common2.noop,
            _performLabelsLayout: function() {
                this._processNodes(null, processLabelsLayout)
            },
            _getTextBBox: function(fontOptions) {
                var renderer = this._renderer;
                var text = this._textForCalculations || renderer.text("0", 0, 0);
                this._textForCalculations = text;
                text.css((0, _utils.patchFontOptions)(fontOptions)).append(renderer.root);
                var bBox = text.getBBox();
                text.remove();
                return bBox
            }
        });

        function traverseDataItems(root, dataItems, level, params) {
            var nodes = [];
            var allNodes = params.nodes;
            var node;
            var i;
            var ii = dataItems.length;
            var dataItem;
            var totalValue = 0;
            var items;
            for (i = 0; i < ii; ++i) {
                var _items;
                dataItem = dataItems[i];
                node = new _node.default;
                node._id = allNodes.length;
                node.ctx = params.ctx;
                node.parent = root;
                node.level = level;
                node.index = nodes.length;
                node.data = dataItem;
                params.buildNode(node);
                allNodes.push(node);
                nodes.push(node);
                items = dataItem[params.itemsField];
                if (null === (_items = items) || void 0 === _items ? void 0 : _items.length) {
                    traverseDataItems(node, items, level + 1, params)
                }
                if (dataItem[params.valueField] > 0) {
                    node.value = Number(dataItem[params.valueField])
                }
                totalValue += node.value
            }
            root.nodes = nodes;
            root.value = totalValue
        }

        function processNodes(context, root, process) {
            var nodes = root.nodes;
            var node;
            var i;
            var ii = nodes.length;
            for (i = 0; i < ii; ++i) {
                node = nodes[i];
                process(context, node);
                if (node.isNode()) {
                    processNodes(context, node, process)
                }
            }
        }
        var createTile = [createLeaf, createGroup];

        function processTileAppearance(context, node) {
            node.color = node.data[context.colorField] || context.getColor(node) || node.parent.color;
            node.updateStyles();
            node.tile = !node.ctx.forceReset && node.tile || createTile[Number(node.isNode())](context, node);
            node.applyState()
        }

        function createLeaf(context, node) {
            var tile = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, tile);
            return tile
        }

        function createGroup(context, node) {
            var outer = context.renderer.simpleRect().append(context.group);
            var inner = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, inner);
            return {
                outer: outer,
                inner: inner
            }
        }

        function processLabelAppearance(context, node) {
            node.updateLabelStyle();
            if (node.labelState.visible) {
                createLabel(context, node, node.labelState, node.labelParams)
            }
        }

        function createLabel(context, currentNode, settings, params) {
            var textData = currentNode.data[context.labelField];
            currentNode.label = textData ? String(textData) : null;
            textData = currentNode.customLabel || currentNode.label;
            if (textData) {
                currentNode.text = context.renderer.text(textData).attr(settings.attr).css(settings.css).append(context.group);
                context.setTrackerData(currentNode, currentNode.text)
            }
        }
        var emptyRect = [0, 0, 0, 0];

        function calculateRects(context, root) {
            var nodes = root.nodes;
            var items = [];
            var rects = [];
            var sum = 0;
            var i;
            var ii = items.length = rects.length = nodes.length;
            for (i = 0; i < ii; ++i) {
                sum += nodes[i].value;
                items[i] = {
                    value: nodes[i].value,
                    i: i
                }
            }
            if (sum > 0) {
                context.algorithm({
                    items: items.slice(),
                    sum: sum,
                    rect: root.innerRect.slice(),
                    isRotated: 1 & nodes[0].level,
                    directions: context.directions
                })
            }
            for (i = 0; i < ii; ++i) {
                rects[i] = items[i].rect || emptyRect
            }
            root.rects = rects
        }

        function processTiling(context, node) {
            var rect = node.parent.rects[node.index];
            var rectOffsets = context.rectOffsets;
            var headerHeight;
            if (node.isNode()) {
                setRectAttrs(node.tile.outer, buildTileRect(rect, node.parent.innerRect, rectOffsets.headerEdge, rectOffsets.headerInner));
                rect = marginateRect(rect, context.groupPadding);
                headerHeight = Math.min(context.headerHeight, rect[3] - rect[1]);
                node.rect = [rect[0], rect[1], rect[2], rect[1] + headerHeight];
                setRectAttrs(node.tile.inner, marginateRect(node.rect, rectOffsets.headerEdge));
                rect[1] += headerHeight;
                node.innerRect = rect;
                calculateRects(context, node)
            } else {
                node.rect = rect;
                setRectAttrs(node.tile, buildTileRect(rect, node.parent.innerRect, rectOffsets.tileEdge, rectOffsets.tileInner))
            }
        }

        function marginateRect(rect, margin) {
            return [rect[0] + margin, rect[1] + margin, rect[2] - margin, rect[3] - margin]
        }

        function buildTileRect(rect, outer, edgeOffset, innerOffset) {
            return [rect[0] + (rect[0] === outer[0] ? edgeOffset : +innerOffset), rect[1] + (rect[1] === outer[1] ? edgeOffset : +innerOffset), rect[2] - (rect[2] === outer[2] ? edgeOffset : -innerOffset), rect[3] - (rect[3] === outer[3] ? edgeOffset : -innerOffset)]
        }

        function setRectAttrs(element, rect) {
            element.attr({
                x: rect[0],
                y: rect[1],
                width: _max(rect[2] - rect[0], 0),
                height: _max(rect[3] - rect[1], 0)
            })
        }

        function processLabelsLayout(context, node) {
            if (node.text && node.labelState.visible) {
                layoutTextNode(node, node.labelParams)
            }
        }

        function layoutTextNode(node, params) {
            var rect = node.rect;
            var text = node.text;
            var bBox = text.getBBox();
            var paddingLeftRight = params.paddingLeftRight;
            var paddingTopBottom = params.paddingTopBottom;
            var effectiveWidth = rect[2] - rect[0] - 2 * paddingLeftRight;
            text.setMaxSize(effectiveWidth, rect[3] - rect[1] - paddingTopBottom, node.isNode() ? {
                textOverflow: params.groupLabelOverflow,
                wordWrap: "none"
            } : {
                textOverflow: params.tileLabelOverflow,
                wordWrap: params.tileLabelWordWrap,
                hideOverflowEllipsis: true
            });
            text.move(params.rtlEnabled ? rect[2] - paddingLeftRight - bBox.x - bBox.width : rect[0] + paddingLeftRight - bBox.x, rect[1] + paddingTopBottom - bBox.y)
        }(0, _component_registrator.default)("dxTreeMap", dxTreeMap);
        var _default = dxTreeMap;
        exports.default = _default;
        dxTreeMap.addPlugin(_data_source.plugin);
        module.exports = exports.default
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/console.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.debug = exports.logger = void 0;
        var _type = __webpack_require__( /*! ./type */ 1);
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !(0, _type.isFunction)(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        exports.logger = logger;
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.debug = debug
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled-npm/core/action.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 2));
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var Action = function() {
            function Action(action, config) {
                _classCallCheck(this, Action);
                config = config || {};
                this._action = action;
                this._context = config.context || (0, _window.getWindow)();
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            }
            _createClass(Action, [{
                key: "execute",
                value: function() {
                    var e = {
                        action: this._action,
                        args: Array.prototype.slice.call(arguments),
                        context: this._context,
                        component: this._component,
                        validatingTargetName: this._validatingTargetName,
                        cancel: false,
                        handled: false
                    };
                    var beforeExecute = this._beforeExecute;
                    var afterExecute = this._afterExecute;
                    var argsBag = e.args[0] || {};
                    if (!this._validateAction(e)) {
                        return
                    }
                    null === beforeExecute || void 0 === beforeExecute ? void 0 : beforeExecute.call(this._context, e);
                    if (e.cancel) {
                        return
                    }
                    var result = this._executeAction(e);
                    if (argsBag.cancel) {
                        return
                    }
                    null === afterExecute || void 0 === afterExecute ? void 0 : afterExecute.call(this._context, e);
                    return result
                }
            }, {
                key: "_validateAction",
                value: function(e) {
                    var excludeValidators = this._excludeValidators;
                    var executors = Action.executors;
                    for (var name in executors) {
                        if (!excludeValidators[name]) {
                            var _executor$validate;
                            var executor = executors[name];
                            null === (_executor$validate = executor.validate) || void 0 === _executor$validate ? void 0 : _executor$validate.call(executor, e);
                            if (e.cancel) {
                                return false
                            }
                        }
                    }
                    return true
                }
            }, {
                key: "_executeAction",
                value: function(e) {
                    var result;
                    var executors = Action.executors;
                    for (var name in executors) {
                        var _executor$execute;
                        var executor = executors[name];
                        null === (_executor$execute = executor.execute) || void 0 === _executor$execute ? void 0 : _executor$execute.call(executor, e);
                        if (e.handled) {
                            result = e.result;
                            break
                        }
                    }
                    return result
                }
            }], [{
                key: "registerExecutor",
                value: function(name, executor) {
                    if ((0, _type.isPlainObject)(name)) {
                        (0, _iterator.each)(name, Action.registerExecutor);
                        return
                    }
                    Action.executors[name] = executor
                }
            }, {
                key: "unregisterExecutor",
                value: function() {
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }(0, _iterator.each)(args, function() {
                        delete Action.executors[this]
                    })
                }
            }]);
            return Action
        }();
        exports.default = Action;
        Action.executors = {};
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0];
                var element = args[e.validatingTargetName] || args.element;
                if (element && condition((0, _renderer.default)(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                })
            },
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if ((0, _type.isFunction)(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        module.exports = exports.default
    }, ,
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/core/base_widget.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/resize_callbacks */ 125));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _base_theme_manager = __webpack_require__( /*! ../core/base_theme_manager */ 310);
        var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_component */ 68));
        var _helpers = __webpack_require__( /*! ./helpers */ 161);
        var _utils = __webpack_require__( /*! ./utils */ 12);
        var _errors_warnings = _interopRequireDefault(__webpack_require__( /*! ./errors_warnings */ 459));
        var _renderer2 = __webpack_require__( /*! ./renderers/renderer */ 176);
        var _layout = _interopRequireDefault(__webpack_require__( /*! ./layout */ 908));
        var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 14));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 5));
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _base_widget = __webpack_require__( /*! ./base_widget.utils */ 909);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _floor = Math.floor;
        var _log = _errors_warnings.default.log;
        var OPTION_RTL_ENABLED = "rtlEnabled";
        var SIZED_ELEMENT_CLASS = "dx-sized-element";
        var _option = _dom_component.default.prototype.option;

        function getTrue() {
            return true
        }

        function getFalse() {
            return false
        }

        function areCanvasesDifferent(canvas1, canvas2) {
            return !(canvas1.width === canvas2.width && canvas1.height === canvas2.height && canvas1.left === canvas2.left && canvas1.top === canvas2.top && canvas1.right === canvas2.right && canvas1.bottom === canvas2.bottom)
        }

        function defaultOnIncidentOccurred(e) {
            if (!e.component._eventsStrategy.hasEvent("incidentOccurred")) {
                _log.apply(null, [e.target.id].concat(e.target.args || []))
            }
        }

        function pickPositiveValue(values) {
            return values.reduce(function(result, value) {
                return value > 0 && !result ? value : result
            }, 0)
        }
        var getEmptyComponent = function() {
            var emptyComponentConfig = {
                _initTemplates: function() {},
                ctor: function(element, options) {
                    this.callBase(element, options);
                    var sizedElement = _dom_adapter.default.createElement("div");
                    var width = options && (0, _type.isNumeric)(options.width) ? options.width + "px" : "100%";
                    var height = options && (0, _type.isNumeric)(options.height) ? options.height + "px" : this._getDefaultSize().height + "px";
                    _dom_adapter.default.setStyle(sizedElement, "width", width);
                    _dom_adapter.default.setStyle(sizedElement, "height", height);
                    _dom_adapter.default.setClass(sizedElement, SIZED_ELEMENT_CLASS);
                    _dom_adapter.default.insertElement(element, sizedElement)
                }
            };
            var EmptyComponent = _dom_component.default.inherit(emptyComponentConfig);
            var originalInherit = EmptyComponent.inherit;
            EmptyComponent.inherit = function(config) {
                for (var field in config) {
                    if ((0, _type.isFunction)(config[field]) && "_" !== field.substr(0, 1) && "option" !== field || "_dispose" === field || "_optionChanged" === field) {
                        config[field] = _common.noop
                    }
                }
                return originalInherit.call(this, config)
            };
            return EmptyComponent
        };

        function callForEach(functions) {
            functions.forEach(function(c) {
                return c()
            })
        }
        var isServerSide = !(0, _window.hasWindow)();

        function sizeIsValid(value) {
            return (0, _type.isDefined)(value) && value > 0
        }
        var baseWidget = isServerSide ? getEmptyComponent() : _dom_component.default.inherit({
            _eventsMap: {
                onIncidentOccurred: {
                    name: "incidentOccurred"
                },
                onDrawn: {
                    name: "drawn"
                }
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    onIncidentOccurred: defaultOnIncidentOccurred
                })
            },
            _useLinks: true,
            _init: function() {
                var that = this;
                that._$element.children("." + SIZED_ELEMENT_CLASS).remove();
                that.callBase.apply(that, arguments);
                that._changesLocker = 0;
                that._optionChangedLocker = 0;
                that._asyncFirstDrawing = true;
                that._changes = (0, _helpers.changes)();
                that._suspendChanges();
                that._themeManager = that._createThemeManager();
                that._themeManager.setCallback(function() {
                    that._requestChange(that._themeDependentChanges)
                });
                that._renderElementAttributes();
                that._initRenderer();
                var linkTarget = that._useLinks && that._renderer.root;
                linkTarget && linkTarget.enableLinks().virtualLink("core").virtualLink("peripheral");
                that._renderVisibilityChange();
                that._attachVisibilityChangeHandlers();
                that._toggleParentsScrollSubscription(this._isVisible());
                that._initEventTrigger();
                that._incidentOccurred = (0, _base_widget.createIncidentOccurred)(that.NAME, that._eventTrigger);
                that._layout = new _layout.default;
                linkTarget && linkTarget.linkAfter("core");
                that._initPlugins();
                that._initCore();
                linkTarget && linkTarget.linkAfter();
                that._change(that._initialChanges)
            },
            _createThemeManager: function() {
                return new _base_theme_manager.BaseThemeManager(this._getThemeManagerOptions())
            },
            _getThemeManagerOptions: function() {
                return {
                    themeSection: this._themeSection,
                    fontFields: this._fontFields
                }
            },
            _initialChanges: ["LAYOUT", "RESIZE_HANDLER", "THEME", "DISABLED"],
            _initPlugins: function() {
                var that = this;
                (0, _iterator.each)(that._plugins, function(_, plugin) {
                    plugin.init.call(that)
                })
            },
            _disposePlugins: function() {
                var that = this;
                (0, _iterator.each)(that._plugins.slice().reverse(), function(_, plugin) {
                    plugin.dispose.call(that)
                })
            },
            _change: function(codes) {
                this._changes.add(codes)
            },
            _suspendChanges: function() {
                ++this._changesLocker
            },
            _resumeChanges: function() {
                var that = this;
                if (0 === --that._changesLocker && that._changes.count() > 0 && !that._applyingChanges) {
                    that._renderer.lock();
                    that._applyingChanges = true;
                    that._applyChanges();
                    that._changes.reset();
                    that._applyingChanges = false;
                    that._renderer.unlock();
                    if (that._optionsQueue) {
                        that._applyQueuedOptions()
                    }
                    that.resolveItemsDeferred(that._legend ? [that._legend] : []);
                    that._optionChangedLocker++;
                    that._notify();
                    that._optionChangedLocker--
                }
            },
            resolveItemsDeferred: function(items) {
                this._resolveDeferred(this._getTemplatesItems(items))
            },
            _collectTemplatesFromItems: function(items) {
                return items.reduce(function(prev, i) {
                    return {
                        items: prev.items.concat(i.getTemplatesDef()),
                        groups: prev.groups.concat(i.getTemplatesGroups())
                    }
                }, {
                    items: [],
                    groups: []
                })
            },
            _getTemplatesItems: function(items) {
                var elements = this._collectTemplatesFromItems(items);
                var extraItems = this._getExtraTemplatesItems();
                return {
                    items: extraItems.items.concat(elements.items),
                    groups: extraItems.groups.concat(elements.groups),
                    launchRequest: [extraItems.launchRequest],
                    doneRequest: [extraItems.doneRequest]
                }
            },
            _getExtraTemplatesItems: function() {
                return {
                    items: [],
                    groups: [],
                    launchRequest: function() {},
                    doneRequest: function() {}
                }
            },
            _resolveDeferred: function(_ref) {
                var items = _ref.items,
                    launchRequest = _ref.launchRequest,
                    doneRequest = _ref.doneRequest,
                    groups = _ref.groups;
                var that = this;
                that._setGroupsVisibility(groups, "hidden");
                if (that._changesApplying) {
                    that._changesApplying = false;
                    callForEach(doneRequest);
                    return
                }
                var syncRendering = true;
                _deferred.when.apply(that, items).done(function() {
                    if (syncRendering) {
                        that._setGroupsVisibility(groups, "visible");
                        return
                    }
                    callForEach(launchRequest);
                    that._changesApplying = true;
                    var changes = ["LAYOUT", "FULL_RENDER"];
                    if (that._asyncFirstDrawing) {
                        changes.push("FORCE_FIRST_DRAWING");
                        that._asyncFirstDrawing = false
                    } else {
                        changes.push("FORCE_DRAWING")
                    }
                    that._requestChange(changes);
                    that._setGroupsVisibility(groups, "visible")
                });
                syncRendering = false
            },
            _setGroupsVisibility: function(groups, visibility) {
                groups.forEach(function(g) {
                    return g.attr({
                        visibility: visibility
                    })
                })
            },
            _applyQueuedOptions: function() {
                var that = this;
                var queue = that._optionsQueue;
                that._optionsQueue = null;
                that.beginUpdate();
                (0, _iterator.each)(queue, function(_, action) {
                    action()
                });
                that.endUpdate()
            },
            _requestChange: function(codes) {
                this._suspendChanges();
                this._change(codes);
                this._resumeChanges()
            },
            _applyChanges: function() {
                var that = this;
                var changes = that._changes;
                var order = that._totalChangesOrder;
                var i;
                var ii = order.length;
                for (i = 0; i < ii; ++i) {
                    if (changes.has(order[i])) {
                        that["_change_" + order[i]]()
                    }
                }
            },
            _optionChangesOrder: ["EVENTS", "THEME", "RENDERER", "RESIZE_HANDLER"],
            _layoutChangesOrder: ["ELEMENT_ATTR", "CONTAINER_SIZE", "LAYOUT"],
            _customChangesOrder: ["DISABLED"],
            _change_EVENTS: function() {
                this._eventTrigger.applyChanges()
            },
            _change_THEME: function() {
                this._setThemeAndRtl()
            },
            _change_RENDERER: function() {
                this._setRendererOptions()
            },
            _change_RESIZE_HANDLER: function() {
                this._setupResizeHandler()
            },
            _change_ELEMENT_ATTR: function() {
                this._renderElementAttributes();
                this._change(["CONTAINER_SIZE"])
            },
            _change_CONTAINER_SIZE: function() {
                this._updateSize()
            },
            _change_LAYOUT: function() {
                this._setContentSize()
            },
            _change_DISABLED: function() {
                var renderer = this._renderer;
                var root = renderer.root;
                if (this.option("disabled")) {
                    this._initDisabledState = root.attr("pointer-events");
                    root.attr({
                        "pointer-events": "none",
                        filter: renderer.getGrayScaleFilter().id
                    })
                } else {
                    if ("none" === root.attr("pointer-events")) {
                        root.attr({
                            "pointer-events": (0, _type.isDefined)(this._initDisabledState) ? this._initDisabledState : null,
                            filter: null
                        })
                    }
                }
            },
            _themeDependentChanges: ["RENDERER"],
            _initRenderer: function() {
                var that = this;
                that._canvas = that._calculateCanvas();
                that._renderer = new _renderer2.Renderer({
                    cssClass: that._rootClassPrefix + " " + that._rootClass,
                    pathModified: that.option("pathModified"),
                    container: that._$element[0]
                });
                that._renderer.resize(that._canvas.width, that._canvas.height)
            },
            _disposeRenderer: function() {
                this._renderer.dispose()
            },
            _getAnimationOptions: _common.noop,
            render: function() {
                this._requestChange(["CONTAINER_SIZE"]);
                var visible = this._isVisible();
                this._toggleParentsScrollSubscription(visible);
                !visible && this._stopCurrentHandling()
            },
            _toggleParentsScrollSubscription: function(subscribe) {
                var $parents = (0, _renderer.default)(this._renderer.root.element).parents();
                var scrollEvents = "scroll.viz_widgets";
                if ("generic" === _devices.default.real().platform) {
                    $parents = $parents.add((0, _window.getWindow)())
                }
                this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function() {
                    this._stopCurrentHandling()
                }.bind(this);
                _events_engine.default.off((0, _renderer.default)().add(this._$prevRootParents), scrollEvents, this._proxiedTargetParentsScrollHandler);
                if (subscribe) {
                    _events_engine.default.on($parents, scrollEvents, this._proxiedTargetParentsScrollHandler);
                    this._$prevRootParents = $parents
                }
            },
            _stopCurrentHandling: _common.noop,
            _dispose: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                that._toggleParentsScrollSubscription(false);
                that._removeResizeHandler();
                that._layout.dispose();
                that._eventTrigger.dispose();
                that._disposeCore();
                that._disposePlugins();
                that._disposeRenderer();
                that._themeManager.dispose();
                that._themeManager = that._renderer = that._eventTrigger = null
            },
            _initEventTrigger: function() {
                var that = this;
                that._eventTrigger = (0, _base_widget.createEventTrigger)(that._eventsMap, function(name) {
                    return that._createActionByOption(name)
                })
            },
            _calculateCanvas: function() {
                var that = this;
                var size = that.option("size") || {};
                var margin = that.option("margin") || {};
                var defaultCanvas = that._getDefaultSize() || {};
                var getSizeOfSide = function(size, side) {
                    if (sizeIsValid(size[side]) || !(0, _window.hasWindow)()) {
                        return 0
                    }
                    var elementSize = that._$element[side]();
                    return elementSize <= 1 ? 0 : elementSize
                };
                var elementWidth = getSizeOfSide(size, "width");
                var elementHeight = getSizeOfSide(size, "height");
                var canvas = {
                    width: size.width <= 0 ? 0 : _floor(pickPositiveValue([size.width, elementWidth, defaultCanvas.width])),
                    height: size.height <= 0 ? 0 : _floor(pickPositiveValue([size.height, elementHeight, defaultCanvas.height])),
                    left: pickPositiveValue([margin.left, defaultCanvas.left]),
                    top: pickPositiveValue([margin.top, defaultCanvas.top]),
                    right: pickPositiveValue([margin.right, defaultCanvas.right]),
                    bottom: pickPositiveValue([margin.bottom, defaultCanvas.bottom])
                };
                if (canvas.width - canvas.left - canvas.right <= 0 || canvas.height - canvas.top - canvas.bottom <= 0) {
                    canvas = {
                        width: 0,
                        height: 0
                    }
                }
                return canvas
            },
            _updateSize: function() {
                var that = this;
                var canvas = that._calculateCanvas();
                that._renderer.fixPlacement();
                if (areCanvasesDifferent(that._canvas, canvas) || that.__forceRender) {
                    that._canvas = canvas;
                    that._recreateSizeDependentObjects(true);
                    that._renderer.resize(canvas.width, canvas.height);
                    that._change(["LAYOUT"])
                }
            },
            _recreateSizeDependentObjects: _common.noop,
            _getMinSize: function() {
                return [0, 0]
            },
            _getAlignmentRect: _common.noop,
            _setContentSize: function() {
                var canvas = this._canvas;
                var layout = this._layout;
                var rect = canvas.width > 0 && canvas.height > 0 ? [canvas.left, canvas.top, canvas.width - canvas.right, canvas.height - canvas.bottom] : [0, 0, 0, 0];
                rect = layout.forward(rect, this._getMinSize());
                var nextRect = this._applySize(rect) || rect;
                layout.backward(nextRect, this._getAlignmentRect() || nextRect)
            },
            _getOption: function(name, isScalar) {
                var theme = this._themeManager.theme(name);
                var option = this.option(name);
                return isScalar ? void 0 !== option ? option : theme : (0, _extend.extend)(true, {}, theme, option)
            },
            _setupResizeHandler: function() {
                var that = this;
                var redrawOnResize = (0, _utils.parseScalar)(this._getOption("redrawOnResize", true), true);
                if (that._resizeHandler) {
                    that._removeResizeHandler()
                }
                that._resizeHandler = (0, _base_widget.createResizeHandler)(function() {
                    if (redrawOnResize) {
                        that._requestChange(["CONTAINER_SIZE"])
                    } else {
                        that._renderer.fixPlacement()
                    }
                });
                _resize_callbacks.default.add(that._resizeHandler)
            },
            _removeResizeHandler: function() {
                if (this._resizeHandler) {
                    _resize_callbacks.default.remove(this._resizeHandler);
                    this._resizeHandler.dispose();
                    this._resizeHandler = null
                }
            },
            _onBeginUpdate: _common.noop,
            beginUpdate: function() {
                var that = this;
                if (that._initialized && that._isUpdateAllowed()) {
                    that._onBeginUpdate();
                    that._suspendChanges()
                }
                that.callBase.apply(that, arguments);
                return that
            },
            endUpdate: function() {
                this.callBase();
                this._isUpdateAllowed() && this._resumeChanges();
                return this
            },
            option: function(name) {
                var that = this;
                if (that._initialized && that._applyingChanges && (arguments.length > 1 || (0, _type.isObject)(name))) {
                    that._optionsQueue = that._optionsQueue || [];
                    that._optionsQueue.push(that._getActionForUpdating(arguments))
                } else {
                    return _option.apply(that, arguments)
                }
            },
            _getActionForUpdating: function(args) {
                var that = this;
                return function() {
                    _option.apply(that, args)
                }
            },
            _clean: _common.noop,
            _render: _common.noop,
            _optionChanged: function(arg) {
                var that = this;
                if (that._optionChangedLocker) {
                    return
                }
                var partialChanges = that.getPartialChangeOptionsName(arg);
                var changes = [];
                if (partialChanges.length > 0) {
                    partialChanges.forEach(function(pc) {
                        return changes.push(that._partialOptionChangesMap[pc])
                    })
                } else {
                    changes.push(that._optionChangesMap[arg.name])
                }
                changes = changes.filter(function(c) {
                    return !!c
                });
                if (that._eventTrigger.change(arg.name)) {
                    that._change(["EVENTS"])
                } else {
                    if (changes.length > 0) {
                        that._change(changes)
                    } else {
                        that.callBase.apply(that, arguments)
                    }
                }
            },
            _notify: _common.noop,
            _optionChangesMap: {
                size: "CONTAINER_SIZE",
                margin: "CONTAINER_SIZE",
                redrawOnResize: "RESIZE_HANDLER",
                theme: "THEME",
                rtlEnabled: "THEME",
                encodeHtml: "THEME",
                elementAttr: "ELEMENT_ATTR",
                disabled: "DISABLED"
            },
            _partialOptionChangesMap: {},
            _partialOptionChangesPath: {},
            getPartialChangeOptionsName: function(changedOption) {
                var that = this;
                var fullName = changedOption.fullName;
                var sections = fullName.split(/[.]/);
                var name = changedOption.name;
                var value = changedOption.value;
                var options = this._partialOptionChangesPath[name];
                var partialChangeOptionsName = [];
                if (options) {
                    if (true === options) {
                        partialChangeOptionsName.push(name)
                    } else {
                        options.forEach(function(op) {
                            fullName.indexOf(op) >= 0 && partialChangeOptionsName.push(op)
                        });
                        if (1 === sections.length) {
                            if ("object" === (0, _type.type)(value)) {
                                that._addOptionsNameForPartialUpdate(value, options, partialChangeOptionsName)
                            } else {
                                if ("array" === (0, _type.type)(value)) {
                                    if (value.length > 0 && value.every(function(item) {
                                            return that._checkOptionsForPartialUpdate(item, options)
                                        })) {
                                        value.forEach(function(item) {
                                            return that._addOptionsNameForPartialUpdate(item, options, partialChangeOptionsName)
                                        })
                                    }
                                }
                            }
                        }
                    }
                }
                return partialChangeOptionsName.filter(function(value, index, self) {
                    return self.indexOf(value) === index
                })
            },
            _checkOptionsForPartialUpdate: function(optionObject, options) {
                return !Object.keys(optionObject).some(function(key) {
                    return options.indexOf(key) === -1
                })
            },
            _addOptionsNameForPartialUpdate: function(optionObject, options, partialChangeOptionsName) {
                var optionKeys = Object.keys(optionObject);
                if (this._checkOptionsForPartialUpdate(optionObject, options)) {
                    optionKeys.forEach(function(key) {
                        return options.indexOf(key) > -1 && partialChangeOptionsName.push(key)
                    })
                }
            },
            _visibilityChanged: function() {
                this.render()
            },
            _setThemeAndRtl: function() {
                this._themeManager.setTheme(this.option("theme"), this.option(OPTION_RTL_ENABLED))
            },
            _getRendererOptions: function() {
                return {
                    rtl: this.option(OPTION_RTL_ENABLED),
                    encodeHtml: this.option("encodeHtml"),
                    animation: this._getAnimationOptions()
                }
            },
            _setRendererOptions: function() {
                this._renderer.setOptions(this._getRendererOptions())
            },
            svg: function() {
                return this._renderer.svg()
            },
            getSize: function() {
                var canvas = this._canvas || {};
                return {
                    width: canvas.width,
                    height: canvas.height
                }
            },
            isReady: getFalse,
            _dataIsReady: getTrue,
            _resetIsReady: function() {
                this.isReady = getFalse
            },
            _drawn: function() {
                var that = this;
                that.isReady = getFalse;
                if (that._dataIsReady()) {
                    that._renderer.onEndAnimation(function() {
                        that.isReady = getTrue
                    })
                }
                that._eventTrigger("drawn", {})
            }
        });
        var _default = baseWidget;
        exports.default = _default;
        (0, _helpers.replaceInherit)(baseWidget);
        module.exports = exports.default
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/currency.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _default = {
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    var result = this.format(value, (0, _extend.extend)({}, formatConfig, {
                        type: "fixedpoint"
                    }));
                    var currencyPart = this.getCurrencySymbol().symbol.replace("$", "$$$$");
                    result = result.replace(/^(\D*)(\d.*)/, "$1" + currencyPart + "$2");
                    return result
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        };
        exports.default = _default;
        module.exports = exports.default
    }, , , , , , , ,
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/core/title.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.plugin = exports.Title = void 0;
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ./utils */ 12);
        var _layout_element = __webpack_require__( /*! ./layout_element */ 311);
        var _Number = Number;
        var parseHorizontalAlignment = (0, _utils.enumParser)(["left", "center", "right"]);
        var parseVerticalAlignment = (0, _utils.enumParser)(["top", "bottom"]);
        var DEFAULT_MARGIN = 10;

        function hasText(text) {
            return !!(text && String(text).length > 0)
        }

        function processTitleLength(elem, text, width, options, placeholderSize) {
            if (elem.attr({
                    text: text
                }).setMaxSize(width, placeholderSize, options).textChanged) {
                elem.setTitle(text)
            }
        }

        function pickMarginValue(value) {
            return value >= 0 ? _Number(value) : DEFAULT_MARGIN
        }

        function validateMargin(margin) {
            var result;
            if (margin >= 0) {
                result = {
                    left: _Number(margin),
                    top: _Number(margin),
                    right: _Number(margin),
                    bottom: _Number(margin)
                }
            } else {
                margin = margin || {};
                result = {
                    left: pickMarginValue(margin.left),
                    top: pickMarginValue(margin.top),
                    right: pickMarginValue(margin.right),
                    bottom: pickMarginValue(margin.bottom)
                }
            }
            return result
        }

        function checkRect(rect, boundingRect) {
            return rect[2] - rect[0] < boundingRect.width || rect[3] - rect[1] < boundingRect.height
        }
        var Title = function(params) {
            this._params = params;
            this._group = params.renderer.g().attr({
                "class": params.cssClass
            }).linkOn(params.root || params.renderer.root, "title");
            this._hasText = false
        };
        exports.Title = Title;
        (0, _extend.extend)(Title.prototype, _layout_element.LayoutElement.prototype, {
            dispose: function() {
                var that = this;
                that._group.linkRemove();
                that._group.linkOff();
                if (that._titleElement) {
                    that._clipRect.dispose();
                    that._titleElement = that._subtitleElement = that._clipRect = null
                }
                that._params = that._group = that._options = null
            },
            _updateOptions: function(options) {
                this._options = options;
                this._options.horizontalAlignment = parseHorizontalAlignment(options.horizontalAlignment, "center");
                this._options.verticalAlignment = parseVerticalAlignment(options.verticalAlignment, "top");
                this._options.margin = validateMargin(options.margin)
            },
            _updateStructure: function() {
                var that = this;
                var renderer = that._params.renderer;
                var group = that._group;
                var options = that._options;
                var align = options.horizontalAlignment;
                if (!that._titleElement) {
                    that._titleElement = renderer.text().append(group);
                    that._subtitleElement = renderer.text();
                    that._clipRect = renderer.clipRect();
                    group.attr({
                        "clip-path": that._clipRect.id
                    })
                }
                that._titleElement.attr({
                    align: align,
                    "class": options.cssClass
                });
                that._subtitleElement.attr({
                    align: align,
                    "class": options.subtitle.cssClass
                });
                group.linkAppend();
                hasText(options.subtitle.text) ? that._subtitleElement.append(group) : that._subtitleElement.remove()
            },
            _updateTexts: function() {
                var that = this;
                var options = that._options;
                var subtitleOptions = options.subtitle;
                var titleElement = that._titleElement;
                var subtitleElement = that._subtitleElement;
                var testText = "A";
                var titleBox;
                titleElement.attr({
                    text: testText,
                    y: 0
                }).css((0, _utils.patchFontOptions)(options.font));
                titleBox = titleElement.getBBox();
                that._baseLineCorrection = titleBox.height + titleBox.y;
                titleElement.attr({
                    text: options.text
                });
                titleBox = titleElement.getBBox();
                var y = -titleBox.y;
                titleElement.attr({
                    y: y
                });
                if (hasText(subtitleOptions.text)) {
                    subtitleElement.attr({
                        text: subtitleOptions.text,
                        y: 0
                    }).css((0, _utils.patchFontOptions)(subtitleOptions.font))
                }
            },
            _shiftSubtitle: function() {
                var that = this;
                var titleBox = that._titleElement.getBBox();
                var element = that._subtitleElement;
                var offset = that._options.subtitle.offset;
                element.move(0, titleBox.y + titleBox.height - element.getBBox().y - offset)
            },
            _updateBoundingRectAlignment: function() {
                var boundingRect = this._boundingRect;
                var options = this._options;
                boundingRect.verticalAlignment = options.verticalAlignment;
                boundingRect.horizontalAlignment = options.horizontalAlignment;
                boundingRect.cutLayoutSide = options.verticalAlignment;
                boundingRect.cutSide = "vertical";
                boundingRect.position = {
                    horizontal: options.horizontalAlignment,
                    vertical: options.verticalAlignment
                }
            },
            hasText: function() {
                return this._hasText
            },
            update: function(themeOptions, userOptions) {
                var that = this;
                var options = (0, _extend.extend)(true, {}, themeOptions, processTitleOptions(userOptions));
                var _hasText = hasText(options.text);
                var isLayoutChanged = _hasText || _hasText !== that._hasText;
                that._baseLineCorrection = 0;
                that._updateOptions(options);
                that._boundingRect = {};
                if (_hasText) {
                    that._updateStructure();
                    that._updateTexts()
                } else {
                    that._group.linkRemove()
                }
                that._updateBoundingRect();
                that._updateBoundingRectAlignment();
                that._hasText = _hasText;
                return isLayoutChanged
            },
            draw: function(width, height) {
                var that = this;
                if (that._hasText) {
                    that._group.linkAppend();
                    that._correctTitleLength(width);
                    if (that._group.getBBox().height > height) {
                        this.freeSpace()
                    }
                }
                return that
            },
            _correctTitleLength: function(width) {
                var that = this;
                var options = that._options;
                var margin = options.margin;
                var maxWidth = width - margin.left - margin.right;
                var placeholderSize = options.placeholderSize;
                processTitleLength(that._titleElement, options.text, maxWidth, options, placeholderSize);
                if (that._subtitleElement) {
                    if (_Number(placeholderSize) > 0) {
                        placeholderSize -= that._titleElement.getBBox().height
                    }
                    processTitleLength(that._subtitleElement, options.subtitle.text, maxWidth, options.subtitle, placeholderSize);
                    that._shiftSubtitle()
                }
                that._updateBoundingRect();
                var _this$getCorrectedLay = this.getCorrectedLayoutOptions(),
                    x = _this$getCorrectedLay.x,
                    y = _this$getCorrectedLay.y,
                    height = _this$getCorrectedLay.height;
                this._clipRect.attr({
                    x: x,
                    y: y,
                    width: width,
                    height: height
                })
            },
            getLayoutOptions: function() {
                return this._boundingRect || null
            },
            shift: function(x, y) {
                var that = this;
                var box = that.getLayoutOptions();
                that._group.move(x - box.x, y - box.y);
                return that
            },
            _updateBoundingRect: function() {
                var that = this;
                var options = that._options;
                var margin = options.margin;
                var boundingRect = that._boundingRect;
                var box = that._hasText ? that._group.getBBox() : {
                    width: 0,
                    height: 0,
                    x: 0,
                    y: 0,
                    isEmpty: true
                };
                if (!box.isEmpty) {
                    box.height += margin.top + margin.bottom - that._baseLineCorrection;
                    box.width += margin.left + margin.right;
                    box.x -= margin.left;
                    box.y += that._baseLineCorrection - margin.top
                }
                if (options.placeholderSize > 0) {
                    box.height = options.placeholderSize
                }
                boundingRect.height = box.height;
                boundingRect.width = box.width;
                boundingRect.x = box.x;
                boundingRect.y = box.y
            },
            getCorrectedLayoutOptions: function() {
                var srcBox = this.getLayoutOptions();
                var correction = this._baseLineCorrection;
                return (0, _extend.extend)({}, srcBox, {
                    y: srcBox.y - correction,
                    height: srcBox.height + correction
                })
            },
            layoutOptions: function() {
                if (!this._hasText) {
                    return null
                }
                return {
                    horizontalAlignment: this._boundingRect.horizontalAlignment,
                    verticalAlignment: this._boundingRect.verticalAlignment,
                    priority: 0
                }
            },
            measure: function(size) {
                this.draw(size[0], size[1]);
                return [this._boundingRect.width, this._boundingRect.height]
            },
            move: function(rect, fitRect) {
                var boundingRect = this._boundingRect;
                if (checkRect(rect, boundingRect)) {
                    this.shift(fitRect[0], fitRect[1])
                } else {
                    this.shift(Math.round(rect[0]), Math.round(rect[1]))
                }
            },
            freeSpace: function() {
                var that = this;
                that._params.incidentOccurred("W2103");
                that._group.linkRemove();
                that._boundingRect.width = that._boundingRect.height = 0
            },
            getOptions: function() {
                return this._options
            },
            changeLink: function(root) {
                this._group.linkRemove();
                this._group.linkOn(root, "title")
            }
        });

        function processTitleOptions(options) {
            var newOptions = (0, _type.isString)(options) ? {
                text: options
            } : options || {};
            newOptions.subtitle = (0, _type.isString)(newOptions.subtitle) ? {
                text: newOptions.subtitle
            } : newOptions.subtitle || {};
            return newOptions
        }
        var plugin = {
            name: "title",
            init: function() {
                var that = this;
                that._title = new Title({
                    renderer: that._renderer,
                    cssClass: that._rootClassPrefix + "-title",
                    incidentOccurred: that._incidentOccurred
                });
                that._layout.add(that._title)
            },
            dispose: function() {
                this._title.dispose();
                this._title = null
            },
            customize: function(constructor) {
                constructor.addChange({
                    code: "TITLE",
                    handler: function() {
                        if (this._title.update(this._themeManager.theme("title"), this.option("title"))) {
                            this._change(["LAYOUT"])
                        }
                    },
                    isThemeDependent: true,
                    option: "title",
                    isOptionChange: true
                })
            },
            fontFields: ["title.font", "title.subtitle.font"]
        };
        exports.plugin = plugin
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/series/scatter_series.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.polar = exports.chart = void 0;
        var _extend3 = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _range_data_calculator = _interopRequireDefault(__webpack_require__( /*! ./helpers/range_data_calculator */ 226));
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = __webpack_require__( /*! ../core/utils */ 12);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }
        var math = Math;
        var _abs = math.abs;
        var _sqrt = math.sqrt;
        var _max = math.max;
        var DEFAULT_TRACKER_WIDTH = 12;
        var DEFAULT_DURATION = 400;
        var HIGH_ERROR = "highError";
        var LOW_ERROR = "lowError";
        var VARIANCE = "variance";
        var STANDARD_DEVIATION = "stddeviation";
        var STANDARD_ERROR = "stderror";
        var PERCENT = "percent";
        var FIXED = "fixed";
        var UNDEFINED = "undefined";
        var DISCRETE = "discrete";
        var LOGARITHMIC = "logarithmic";
        var DATETIME = "datetime";
        var chart = {};
        exports.chart = chart;
        var polar = {};
        exports.polar = polar;

        function sum(array) {
            var result = 0;
            (0, _iterator.each)(array, function(_, value) {
                result += value
            });
            return result
        }

        function isErrorBarTypeCorrect(type) {
            return (0, _array.inArray)(type, [FIXED, PERCENT, VARIANCE, STANDARD_DEVIATION, STANDARD_ERROR]) !== -1
        }

        function variance(array, expectedValue) {
            return sum((0, _utils.map)(array, function(value) {
                return (value - expectedValue) * (value - expectedValue)
            })) / array.length
        }

        function calculateAvgErrorBars(result, data, series) {
            var errorBarsOptions = series.getOptions().valueErrorBar;
            var valueField = series.getValueFields()[0];
            var lowValueField = errorBarsOptions.lowValueField || LOW_ERROR;
            var highValueField = errorBarsOptions.highValueField || HIGH_ERROR;
            if (series.areErrorBarsVisible() && void 0 === errorBarsOptions.type) {
                var fusionData = data.reduce(function(result, item) {
                    if ((0, _type.isDefined)(item[lowValueField])) {
                        result[0] += item[valueField] - item[lowValueField];
                        result[1]++
                    }
                    if ((0, _type.isDefined)(item[highValueField])) {
                        result[2] += item[highValueField] - item[valueField];
                        result[3]++
                    }
                    return result
                }, [0, 0, 0, 0]);
                if (fusionData[1]) {
                    result[lowValueField] = result[valueField] - fusionData[0] / fusionData[1]
                }
                if (fusionData[2]) {
                    result[highValueField] = result[valueField] + fusionData[2] / fusionData[3]
                }
            }
            return result
        }

        function calculateSumErrorBars(result, data, series) {
            var errorBarsOptions = series.getOptions().valueErrorBar;
            var lowValueField = errorBarsOptions.lowValueField || LOW_ERROR;
            var highValueField = errorBarsOptions.highValueField || HIGH_ERROR;
            if (series.areErrorBarsVisible() && void 0 === errorBarsOptions.type) {
                result[lowValueField] = 0;
                result[highValueField] = 0;
                result = data.reduce(function(result, item) {
                    result[lowValueField] += item[lowValueField];
                    result[highValueField] += item[highValueField];
                    return result
                }, result)
            }
            return result
        }

        function getMinMaxAggregator(compare) {
            return function(_ref, series) {
                var intervalStart = _ref.intervalStart,
                    data = _ref.data;
                var valueField = series.getValueFields()[0];
                var targetData = data[0];
                targetData = data.reduce(function(result, item) {
                    var value = item[valueField];
                    if (null === result[valueField]) {
                        result = item
                    }
                    if (null !== value && compare(value, result[valueField])) {
                        return item
                    }
                    return result
                }, targetData);
                return (0, _extend3.extend)({}, targetData, _defineProperty({}, series.getArgumentField(), intervalStart))
            }
        }

        function checkFields(data, fieldsToCheck, skippedFields) {
            var allFieldsIsValid = true;
            for (var field in fieldsToCheck) {
                var isArgument = "argument" === field;
                if (isArgument || "size" === field ? !(0, _type.isDefined)(data[field]) : void 0 === data[field]) {
                    var selector = fieldsToCheck[field];
                    if (!isArgument) {
                        skippedFields[selector] = (skippedFields[selector] || 0) + 1
                    }
                    allFieldsIsValid = false
                }
            }
            return allFieldsIsValid
        }
        var baseScatterMethods = {
            _defaultDuration: DEFAULT_DURATION,
            _defaultTrackerWidth: DEFAULT_TRACKER_WIDTH,
            _applyStyle: _common.noop,
            _updateOptions: _common.noop,
            _parseStyle: _common.noop,
            _prepareSegment: _common.noop,
            _drawSegment: _common.noop,
            _appendInGroup: function() {
                this._group.append(this._extGroups.seriesGroup)
            },
            _createLegendState: function(styleOptions, defaultColor) {
                return {
                    fill: styleOptions.color || defaultColor,
                    hatching: styleOptions.hatching ? (0, _extend3.extend)({}, styleOptions.hatching, {
                        direction: "right"
                    }) : void 0
                }
            },
            _applyElementsClipRect: function(settings) {
                settings["clip-path"] = this._paneClipRectID
            },
            _applyMarkerClipRect: function(settings) {
                settings["clip-path"] = this._forceClipping ? this._paneClipRectID : null
            },
            _createGroup: function(groupName, parent, target, settings) {
                var group = parent[groupName] = parent[groupName] || this._renderer.g();
                target && group.append(target);
                settings && group.attr(settings)
            },
            _applyClearingSettings: function(settings) {
                settings.opacity = null;
                settings.scale = null;
                if (this._options.rotated) {
                    settings.translateX = null
                } else {
                    settings.translateY = null
                }
            },
            _createGroups: function() {
                var that = this;
                that._createGroup("_markersGroup", that, that._group);
                that._createGroup("_labelsGroup", that)
            },
            _setMarkerGroupSettings: function() {
                var that = this;
                var settings = that._createPointStyles(that._getMarkerGroupOptions()).normal;
                settings.class = "dxc-markers";
                settings.opacity = 1;
                that._applyMarkerClipRect(settings);
                that._markersGroup.attr(settings)
            },
            getVisibleArea: function() {
                return this._visibleArea
            },
            areErrorBarsVisible: function() {
                var errorBarOptions = this._options.valueErrorBar;
                return errorBarOptions && this._errorBarsEnabled() && "none" !== errorBarOptions.displayMode && (isErrorBarTypeCorrect((0, _utils.normalizeEnum)(errorBarOptions.type)) || (0, _type.isDefined)(errorBarOptions.lowValueField) || (0, _type.isDefined)(errorBarOptions.highValueField))
            },
            groupPointsByCoords: function(rotated) {
                var cat = [];
                (0, _iterator.each)(this.getVisiblePoints(), function(_, p) {
                    var pointCoord = parseInt(rotated ? p.vy : p.vx);
                    if (!cat[pointCoord]) {
                        cat[pointCoord] = p
                    } else {
                        Array.isArray(cat[pointCoord]) ? cat[pointCoord].push(p) : cat[pointCoord] = [cat[pointCoord], p]
                    }
                });
                return cat
            },
            _createErrorBarGroup: function(animationEnabled) {
                var that = this;
                var errorBarOptions = that._options.valueErrorBar;
                var settings;
                if (that.areErrorBarsVisible()) {
                    settings = {
                        "class": "dxc-error-bars",
                        stroke: errorBarOptions.color,
                        "stroke-width": errorBarOptions.lineWidth,
                        opacity: animationEnabled ? .001 : errorBarOptions.opacity || 1,
                        "stroke-linecap": "square",
                        sharp: true,
                        "clip-path": that._forceClipping ? that._paneClipRectID : that._widePaneClipRectID
                    };
                    that._createGroup("_errorBarGroup", that, that._group, settings)
                }
            },
            _setGroupsSettings: function(animationEnabled) {
                var that = this;
                that._setMarkerGroupSettings();
                that._setLabelGroupSettings(animationEnabled);
                that._createErrorBarGroup(animationEnabled)
            },
            _getCreatingPointOptions: function() {
                var that = this;
                var defaultPointOptions;
                var creatingPointOptions = that._predefinedPointOptions;
                var normalStyle;
                if (!creatingPointOptions) {
                    defaultPointOptions = that._getPointOptions();
                    that._predefinedPointOptions = creatingPointOptions = (0, _extend3.extend)(true, {
                        styles: {}
                    }, defaultPointOptions);
                    normalStyle = defaultPointOptions.styles && defaultPointOptions.styles.normal || {};
                    creatingPointOptions.styles = creatingPointOptions.styles || {};
                    creatingPointOptions.styles.normal = {
                        "stroke-width": normalStyle["stroke-width"],
                        r: normalStyle.r,
                        opacity: normalStyle.opacity
                    }
                }
                return creatingPointOptions
            },
            _getPointOptions: function() {
                return this._parsePointOptions(this._preparePointOptions(), this._options.label)
            },
            _getOptionsForPoint: function() {
                return this._options.point
            },
            _parsePointStyle: function(style, defaultColor, defaultBorderColor, defaultSize) {
                var border = style.border || {};
                var sizeValue = void 0 !== style.size ? style.size : defaultSize;
                return {
                    fill: style.color || defaultColor,
                    stroke: border.color || defaultBorderColor,
                    "stroke-width": border.visible ? border.width : 0,
                    r: sizeValue / 2 + (border.visible && 0 !== sizeValue ? ~~(border.width / 2) || 0 : 0)
                }
            },
            _createPointStyles: function(pointOptions) {
                var that = this;
                var mainPointColor = pointOptions.color || that._options.mainSeriesColor;
                var containerColor = that._options.containerBackgroundColor;
                var normalStyle = that._parsePointStyle(pointOptions, mainPointColor, mainPointColor);
                normalStyle.visibility = pointOptions.visible ? "visible" : "hidden";
                return {
                    normal: normalStyle,
                    hover: that._parsePointStyle(pointOptions.hoverStyle, containerColor, mainPointColor, pointOptions.size),
                    selection: that._parsePointStyle(pointOptions.selectionStyle, containerColor, mainPointColor, pointOptions.size)
                }
            },
            _checkData: function(data, skippedFields, fieldsToCheck) {
                fieldsToCheck = fieldsToCheck || {
                    value: this.getValueFields()[0]
                };
                fieldsToCheck.argument = this.getArgumentField();
                return checkFields(data, fieldsToCheck, skippedFields || {}) && data.value === data.value
            },
            getValueRangeInitialValue: function() {
                return
            },
            _getRangeData: function() {
                return _range_data_calculator.default.getRangeData(this)
            },
            _getPointDataSelector: function() {
                var _this = this;
                var valueField = this.getValueFields()[0];
                var argumentField = this.getArgumentField();
                var tagField = this.getTagField();
                var areErrorBarsVisible = this.areErrorBarsVisible();
                var lowValueField;
                var highValueField;
                if (areErrorBarsVisible) {
                    var errorBarOptions = this._options.valueErrorBar;
                    lowValueField = errorBarOptions.lowValueField || LOW_ERROR;
                    highValueField = errorBarOptions.highValueField || HIGH_ERROR
                }
                return function(data) {
                    var pointData = {
                        value: _this._processEmptyValue(data[valueField]),
                        argument: data[argumentField],
                        tag: data[tagField],
                        data: data
                    };
                    if (areErrorBarsVisible) {
                        pointData.lowError = data[lowValueField];
                        pointData.highError = data[highValueField]
                    }
                    return pointData
                }
            },
            _errorBarsEnabled: function() {
                return this.valueAxisType !== DISCRETE && this.valueAxisType !== LOGARITHMIC && this.valueType !== DATETIME
            },
            _drawPoint: function(options) {
                var point = options.point;
                if (point.isInVisibleArea()) {
                    point.clearVisibility();
                    point.draw(this._renderer, options.groups, options.hasAnimation, options.firstDrawing);
                    this._drawnPoints.push(point)
                } else {
                    point.setInvisibility()
                }
            },
            _animateComplete: function() {
                var that = this;
                var animationSettings = {
                    duration: that._defaultDuration
                };
                that._labelsGroup && that._labelsGroup.animate({
                    opacity: 1
                }, animationSettings);
                that._errorBarGroup && that._errorBarGroup.animate({
                    opacity: that._options.valueErrorBar.opacity || 1
                }, animationSettings)
            },
            _animate: function() {
                var that = this;
                var lastPointIndex = that._drawnPoints.length - 1;
                (0, _iterator.each)(that._drawnPoints || [], function(i, p) {
                    p.animate(i === lastPointIndex ? function() {
                        that._animateComplete()
                    } : void 0, {
                        translateX: p.x,
                        translateY: p.y
                    })
                })
            },
            _defaultAggregator: "avg",
            _aggregators: {
                avg: function(_ref2, series) {
                    var _calculateAvgErrorBar;
                    var data = _ref2.data,
                        intervalStart = _ref2.intervalStart;
                    if (!data.length) {
                        return
                    }
                    var valueField = series.getValueFields()[0];
                    var aggregationResult = data.reduce(function(result, item) {
                        var value = item[valueField];
                        if ((0, _type.isDefined)(value)) {
                            result[0] += value;
                            result[1]++
                        } else {
                            if (null === value) {
                                result[2]++
                            }
                        }
                        return result
                    }, [0, 0, 0]);
                    return calculateAvgErrorBars((_calculateAvgErrorBar = {}, _defineProperty(_calculateAvgErrorBar, valueField, aggregationResult[2] === data.length ? null : aggregationResult[0] / aggregationResult[1]), _defineProperty(_calculateAvgErrorBar, series.getArgumentField(), intervalStart), _calculateAvgErrorBar), data, series)
                },
                sum: function(_ref3, series) {
                    var _calculateSumErrorBar;
                    var intervalStart = _ref3.intervalStart,
                        data = _ref3.data;
                    if (!data.length) {
                        return
                    }
                    var valueField = series.getValueFields()[0];
                    var aggregationResult = data.reduce(function(result, item) {
                        var value = item[valueField];
                        if (void 0 !== value) {
                            result[0] += value
                        }
                        if (null === value) {
                            result[1]++
                        } else {
                            if (void 0 === value) {
                                result[2]++
                            }
                        }
                        return result
                    }, [0, 0, 0]);
                    var value = aggregationResult[0];
                    if (aggregationResult[1] === data.length) {
                        value = null
                    }
                    if (aggregationResult[2] === data.length) {
                        return
                    }
                    return calculateSumErrorBars((_calculateSumErrorBar = {}, _defineProperty(_calculateSumErrorBar, valueField, value), _defineProperty(_calculateSumErrorBar, series.getArgumentField(), intervalStart), _calculateSumErrorBar), data, series)
                },
                count: function(_ref4, series) {
                    var _ref5;
                    var data = _ref4.data,
                        intervalStart = _ref4.intervalStart;
                    var valueField = series.getValueFields()[0];
                    return _ref5 = {}, _defineProperty(_ref5, series.getArgumentField(), intervalStart), _defineProperty(_ref5, valueField, data.filter(function(i) {
                        return void 0 !== i[valueField]
                    }).length), _ref5
                },
                min: getMinMaxAggregator(function(a, b) {
                    return a < b
                }),
                max: getMinMaxAggregator(function(a, b) {
                    return a > b
                })
            },
            _endUpdateData: function() {
                delete this._predefinedPointOptions
            },
            getArgumentField: function() {
                return this._options.argumentField || "arg"
            },
            getValueFields: function() {
                var options = this._options;
                var errorBarsOptions = options.valueErrorBar;
                var valueFields = [options.valueField || "val"];
                var lowValueField;
                var highValueField;
                if (errorBarsOptions) {
                    lowValueField = errorBarsOptions.lowValueField;
                    highValueField = errorBarsOptions.highValueField;
                    (0, _type.isString)(lowValueField) && valueFields.push(lowValueField);
                    (0, _type.isString)(highValueField) && valueFields.push(highValueField)
                }
                return valueFields
            },
            _calculateErrorBars: function(data) {
                if (!this.areErrorBarsVisible()) {
                    return
                }
                var that = this;
                var options = that._options;
                var errorBarsOptions = options.valueErrorBar;
                var errorBarType = (0, _utils.normalizeEnum)(errorBarsOptions.type);
                var floatErrorValue = parseFloat(errorBarsOptions.value);
                var valueField = that.getValueFields()[0];
                var value;
                var lowValueField = errorBarsOptions.lowValueField || LOW_ERROR;
                var highValueField = errorBarsOptions.highValueField || HIGH_ERROR;
                var valueArray;
                var valueArrayLength;
                var meanValue;
                var processDataItem;
                var addSubError = function(_i, item) {
                    value = item.value;
                    item.lowError = value - floatErrorValue;
                    item.highError = value + floatErrorValue
                };
                switch (errorBarType) {
                    case FIXED:
                        processDataItem = addSubError;
                        break;
                    case PERCENT:
                        processDataItem = function(_, item) {
                            value = item.value;
                            var error = value * floatErrorValue / 100;
                            item.lowError = value - error;
                            item.highError = value + error
                        };
                        break;
                    case UNDEFINED:
                        processDataItem = function(_, item) {
                            item.lowError = item.data[lowValueField];
                            item.highError = item.data[highValueField]
                        };
                        break;
                    default:
                        valueArray = (0, _utils.map)(data, function(item) {
                            return (0, _type.isDefined)(item.data[valueField]) ? item.data[valueField] : null
                        });
                        valueArrayLength = valueArray.length;
                        floatErrorValue = floatErrorValue || 1;
                        switch (errorBarType) {
                            case VARIANCE:
                                floatErrorValue = variance(valueArray, sum(valueArray) / valueArrayLength) * floatErrorValue;
                                processDataItem = addSubError;
                                break;
                            case STANDARD_DEVIATION:
                                meanValue = sum(valueArray) / valueArrayLength;
                                floatErrorValue = _sqrt(variance(valueArray, meanValue)) * floatErrorValue;
                                processDataItem = function(_, item) {
                                    item.lowError = meanValue - floatErrorValue;
                                    item.highError = meanValue + floatErrorValue
                                };
                                break;
                            case STANDARD_ERROR:
                                floatErrorValue = _sqrt(variance(valueArray, sum(valueArray) / valueArrayLength) / valueArrayLength) * floatErrorValue;
                                processDataItem = addSubError
                        }
                }
                processDataItem && (0, _iterator.each)(data, processDataItem)
            },
            _patchMarginOptions: function(options) {
                var pointOptions = this._getCreatingPointOptions();
                var styles = pointOptions.styles;
                var maxSize = [styles.normal, styles.hover, styles.selection].reduce(function(max, style) {
                    return _max(max, 2 * style.r + style["stroke-width"])
                }, 0);
                options.size = pointOptions.visible ? maxSize : 0;
                options.sizePointNormalState = pointOptions.visible ? 2 * styles.normal.r + styles.normal["stroke-width"] : 2;
                return options
            },
            usePointsToDefineAutoHiding: function() {
                return true
            }
        };
        exports.chart = chart = (0, _extend3.extend)({}, baseScatterMethods, {
            drawTrackers: function() {
                var that = this;
                var trackers;
                var trackersGroup;
                var segments = that._segments || [];
                var rotated = that._options.rotated;
                if (!that.isVisible()) {
                    return
                }
                if (segments.length) {
                    trackers = that._trackers = that._trackers || [];
                    trackersGroup = that._trackersGroup = (that._trackersGroup || that._renderer.g().attr({
                        fill: "gray",
                        opacity: .001,
                        stroke: "gray",
                        "class": "dxc-trackers"
                    })).attr({
                        "clip-path": this._paneClipRectID || null
                    }).append(that._group);
                    (0, _iterator.each)(segments, function(i, segment) {
                        if (!trackers[i]) {
                            trackers[i] = that._drawTrackerElement(segment).data({
                                "chart-data-series": that
                            }).append(trackersGroup)
                        } else {
                            that._updateTrackerElement(segment, trackers[i])
                        }
                    })
                }
                that._trackersTranslator = that.groupPointsByCoords(rotated)
            },
            _checkAxisVisibleAreaCoord: function(isArgument, coord) {
                var axis = isArgument ? this.getArgumentAxis() : this.getValueAxis();
                var visibleArea = axis.getVisibleArea();
                return (0, _type.isDefined)(coord) && visibleArea[0] <= coord && visibleArea[1] >= coord
            },
            checkSeriesViewportCoord: function(axis, coord) {
                return true
            },
            getSeriesPairCoord: function(coord, isArgument) {
                var oppositeCoord = null;
                var isOpposite = !isArgument && !this._options.rotated || isArgument && this._options.rotated;
                var coordName = !isOpposite ? "vx" : "vy";
                var oppositeCoordName = !isOpposite ? "vy" : "vx";
                var points = this.getVisiblePoints();
                for (var i = 0; i < points.length; i++) {
                    var p = points[i];
                    var tmpCoord = p[coordName] === coord ? p[oppositeCoordName] : void 0;
                    if (this._checkAxisVisibleAreaCoord(!isArgument, tmpCoord)) {
                        oppositeCoord = tmpCoord;
                        break
                    }
                }
                return oppositeCoord
            },
            _getNearestPoints: function(point, nextPoint) {
                return [point, nextPoint]
            },
            _getBezierPoints: function() {
                return []
            },
            _getNearestPointsByCoord: function(coord, isArgument) {
                var that = this;
                var rotated = that.getOptions().rotated;
                var isOpposite = !isArgument && !rotated || isArgument && rotated;
                var coordName = isOpposite ? "vy" : "vx";
                var allPoints = that.getPoints();
                var bezierPoints = that._getBezierPoints();
                var nearestPoints = [];
                if (allPoints.length > 1) {
                    allPoints.forEach(function(point, i) {
                        var nextPoint = allPoints[i + 1];
                        if (nextPoint && (point[coordName] <= coord && nextPoint[coordName] >= coord || point[coordName] >= coord && nextPoint[coordName] <= coord)) {
                            nearestPoints.push(that._getNearestPoints(point, nextPoint, bezierPoints))
                        }
                    })
                } else {
                    nearestPoints.push([allPoints[0], allPoints[0]])
                }
                return nearestPoints
            },
            getNeighborPoint: function(x, y) {
                var pCoord = this._options.rotated ? y : x;
                var nCoord = pCoord;
                var cat = this._trackersTranslator;
                var point = null;
                var minDistance;
                var oppositeCoord = this._options.rotated ? x : y;
                var oppositeCoordName = this._options.rotated ? "vx" : "vy";
                if (this.isVisible() && cat) {
                    point = cat[pCoord];
                    do {
                        point = cat[nCoord] || cat[pCoord];
                        pCoord--;
                        nCoord++
                    } while ((pCoord >= 0 || nCoord < cat.length) && !point);
                    if (Array.isArray(point)) {
                        minDistance = _abs(point[0][oppositeCoordName] - oppositeCoord);
                        (0, _iterator.each)(point, function(i, p) {
                            var distance = _abs(p[oppositeCoordName] - oppositeCoord);
                            if (minDistance >= distance) {
                                minDistance = distance;
                                point = p
                            }
                        })
                    }
                }
                return point
            },
            _applyVisibleArea: function() {
                var that = this;
                var rotated = that._options.rotated;
                var visibleX = (rotated ? that.getValueAxis() : that.getArgumentAxis()).getVisibleArea();
                var visibleY = (rotated ? that.getArgumentAxis() : that.getValueAxis()).getVisibleArea();
                that._visibleArea = {
                    minX: visibleX[0],
                    maxX: visibleX[1],
                    minY: visibleY[0],
                    maxY: visibleY[1]
                }
            },
            getPointCenterByArg: function(arg) {
                var point = this.getPointsByArg(arg)[0];
                return point ? point.getCenterCoord() : void 0
            }
        });
        exports.polar = polar = (0, _extend3.extend)({}, baseScatterMethods, {
            drawTrackers: function() {
                chart.drawTrackers.call(this);
                var cat = this._trackersTranslator;
                var index;
                if (!this.isVisible()) {
                    return
                }(0, _iterator.each)(cat, function(i, category) {
                    if (category) {
                        index = i;
                        return false
                    }
                });
                cat[index + 360] = cat[index]
            },
            getNeighborPoint: function(x, y) {
                var pos = (0, _utils.convertXYToPolar)(this.getValueAxis().getCenter(), x, y);
                return chart.getNeighborPoint.call(this, pos.phi, pos.r)
            },
            _applyVisibleArea: function() {
                var that = this;
                var canvas = that.getValueAxis().getCanvas();
                that._visibleArea = {
                    minX: canvas.left,
                    maxX: canvas.width - canvas.right,
                    minY: canvas.top,
                    maxY: canvas.height - canvas.bottom
                }
            },
            getSeriesPairCoord: function(params, isArgument) {
                var coords = null;
                var paramName = isArgument ? "argument" : "radius";
                var points = this.getVisiblePoints();
                for (var i = 0; i < points.length; i++) {
                    var p = points[i];
                    var tmpPoint = (0, _type.isDefined)(p[paramName]) && (0, _type.isDefined)(params[paramName]) && p[paramName].valueOf() === params[paramName].valueOf() ? {
                        x: p.x,
                        y: p.y
                    } : void 0;
                    if ((0, _type.isDefined)(tmpPoint)) {
                        coords = tmpPoint;
                        break
                    }
                }
                return coords
            }
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/core/tooltip.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.plugin = exports.Tooltip = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 11));
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _inflector = __webpack_require__( /*! ../../core/utils/inflector */ 39);
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _renderer2 = __webpack_require__( /*! ./renderers/renderer */ 176);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ./utils */ 12);
        var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../format_helper */ 72));
        var _plaque = __webpack_require__( /*! ./plaque */ 465);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var format = _format_helper.default.format;
        var mathCeil = Math.ceil;
        var mathMax = Math.max;
        var mathMin = Math.min;
        var window = (0, _window.getWindow)();
        var DEFAULT_HTML_GROUP_WIDTH = 3e3;

        function hideElement($element) {
            $element.css({
                left: "-9999px"
            }).detach()
        }

        function getSpecialFormatOptions(options, specialFormat) {
            var result = options;
            switch (specialFormat) {
                case "argument":
                    result = {
                        format: options.argumentFormat
                    };
                    break;
                case "percent":
                    result = {
                        format: {
                            type: "percent",
                            precision: options.format && options.format.percentPrecision
                        }
                    }
            }
            return result
        }
        var Tooltip = function(params) {
            var that = this;
            var renderer;
            that._eventTrigger = params.eventTrigger;
            that._widgetRoot = params.widgetRoot;
            that._widget = params.widget;
            that._wrapper = (0, _renderer.default)("<div>").css({
                position: "absolute",
                overflow: "hidden",
                pointerEvents: "none"
            }).addClass(params.cssClass);
            that._renderer = renderer = new _renderer2.Renderer({
                pathModified: params.pathModified,
                container: that._wrapper[0]
            });
            var root = renderer.root;
            root.attr({
                "pointer-events": "none"
            });
            that._text = renderer.text(void 0, 0, 0);
            that._textGroupHtml = (0, _renderer.default)("<div>").css({
                position: "absolute",
                padding: 0,
                margin: 0,
                border: "0px solid transparent"
            }).appendTo(that._wrapper);
            that._textHtml = (0, _renderer.default)("<div>").css({
                position: "relative",
                display: "inline-block",
                padding: 0,
                margin: 0,
                border: "0px solid transparent"
            }).appendTo(that._textGroupHtml)
        };
        exports.Tooltip = Tooltip;
        Tooltip.prototype = {
            constructor: Tooltip,
            dispose: function() {
                this._wrapper.remove();
                this._renderer.dispose();
                this._options = this._widgetRoot = null
            },
            _getContainer: function() {
                var options = this._options;
                var container = (0, _renderer.default)(this._widgetRoot).closest(options.container);
                if (0 === container.length) {
                    container = (0, _renderer.default)(options.container)
                }
                return (container.length ? container : (0, _renderer.default)("body")).get(0)
            },
            setTemplate: function(contentTemplate) {
                var that = this;
                that._template = contentTemplate ? that._widget._getTemplate(contentTemplate) : null
            },
            setOptions: function(options) {
                var _this = this;
                options = options || {};
                var that = this;
                that._options = options;
                that._textFontStyles = (0, _utils.patchFontOptions)(options.font);
                that._textFontStyles.color = that._textFontStyles.fill;
                that._wrapper.css({
                    zIndex: options.zIndex
                });
                that._customizeTooltip = options.customizeTooltip;
                var textGroupHtml = that._textGroupHtml;
                var textHtml = that._textHtml;
                if (this.plaque) {
                    this.plaque.clear()
                }
                this.setTemplate(options.contentTemplate);
                var pointerEvents = options.interactive ? "auto" : "none";
                if (options.interactive) {
                    this._renderer.root.css({
                        "-ms-user-select": "auto",
                        "-moz-user-select": "auto",
                        "-webkit-user-select": "auto"
                    })
                }
                var drawTooltip = function(tooltip, group) {
                    var state = tooltip._state;
                    var template = tooltip._template;
                    var useTemplate = template && !state.formatObject.skipTemplate;
                    if (state.html || useTemplate) {
                        if (!state.isRendered) {
                            if (useTemplate) {
                                template.render({
                                    model: state.formatObject,
                                    container: textHtml
                                });
                                state.html = textHtml.html();
                                if (!state.html) {
                                    _this.plaque.clear();
                                    return
                                }
                            } else {
                                that._text.attr({
                                    text: ""
                                });
                                textHtml.html(state.html)
                            }
                            textGroupHtml.css({
                                color: state.textColor,
                                width: DEFAULT_HTML_GROUP_WIDTH,
                                pointerEvents: pointerEvents
                            });
                            state.isRendered = true
                        }
                    } else {
                        that._text.css({
                            fill: state.textColor
                        }).attr({
                            text: state.text,
                            "class": options.cssClass,
                            "pointer-events": pointerEvents
                        }).append(group.attr({
                            align: options.textAlignment
                        }))
                    }
                    tooltip.plaque.customizeCloud({
                        fill: state.color,
                        stroke: state.borderColor,
                        "pointer-events": pointerEvents
                    })
                };
                this.plaque = new _plaque.Plaque({
                    opacity: that._options.opacity,
                    color: that._options.color,
                    border: that._options.border,
                    paddingLeftRight: that._options.paddingLeftRight,
                    paddingTopBottom: that._options.paddingTopBottom,
                    arrowLength: that._options.arrowLength,
                    arrowWidth: 20,
                    shadow: that._options.shadow,
                    cornerRadius: that._options.cornerRadius
                }, that, that._renderer.root, drawTooltip, true, function(tooltip, g) {
                    var state = tooltip._state;
                    if (state.html) {
                        var bBox;
                        var getComputedStyle = window.getComputedStyle;
                        if (getComputedStyle) {
                            bBox = getComputedStyle(textHtml.get(0));
                            bBox = {
                                x: 0,
                                y: 0,
                                width: mathCeil(parseFloat(bBox.width)),
                                height: mathCeil(parseFloat(bBox.height))
                            }
                        } else {
                            bBox = textHtml.get(0).getBoundingClientRect();
                            bBox = {
                                x: 0,
                                y: 0,
                                width: mathCeil(bBox.width ? bBox.width : bBox.right - bBox.left),
                                height: mathCeil(bBox.height ? bBox.height : bBox.bottom - bBox.top)
                            }
                        }
                        return bBox
                    }
                    return g.getBBox()
                }, function(tooltip, g, x, y) {
                    var state = tooltip._state;
                    if (state.html) {
                        that._textGroupHtml.css({
                            left: x,
                            top: y
                        })
                    } else {
                        g.move(x, y)
                    }
                });
                return that
            },
            setRendererOptions: function(options) {
                this._renderer.setOptions(options);
                this._textGroupHtml.css({
                    direction: options.rtl ? "rtl" : "ltr"
                });
                return this
            },
            render: function() {
                var that = this;
                hideElement(that._wrapper);
                var normalizedCSS = {};
                for (var name in that._textFontStyles) {
                    normalizedCSS[(0, _inflector.camelize)(name)] = that._textFontStyles[name]
                }
                that._textGroupHtml.css(normalizedCSS);
                that._text.css(that._textFontStyles);
                that._eventData = null;
                return that
            },
            update: function(options) {
                return this.setOptions(options).render()
            },
            _prepare: function(formatObject, state) {
                var customizeTooltip = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : this._customizeTooltip;
                var options = this._options;
                var customize = {};
                if ((0, _type.isFunction)(customizeTooltip)) {
                    customize = customizeTooltip.call(formatObject, formatObject);
                    customize = (0, _type.isPlainObject)(customize) ? customize : {};
                    if ("text" in customize) {
                        state.text = (0, _type.isDefined)(customize.text) ? String(customize.text) : ""
                    }
                    if ("html" in customize) {
                        state.html = (0, _type.isDefined)(customize.html) ? String(customize.html) : ""
                    }
                }
                if (!("text" in state) && !("html" in state)) {
                    state.text = formatObject.valueText || formatObject.description || ""
                }
                state.color = customize.color || options.color;
                state.borderColor = customize.borderColor || (options.border || {}).color;
                state.textColor = customize.fontColor || (this._textFontStyles || {}).color;
                return !!state.text || !!state.html || !!this._template
            },
            show: function(formatObject, params, eventData, customizeTooltip) {
                var that = this;
                var riseEvents = function() {
                    that._eventData && that._eventTrigger("tooltipHidden", that._eventData);
                    that._eventData = eventData;
                    that._eventTrigger("tooltipShown", that._eventData)
                };
                if (that._options.forceEvents) {
                    eventData.x = params.x;
                    eventData.y = params.y - params.offset;
                    riseEvents();
                    return true
                }
                var state = {
                    formatObject: formatObject
                };
                if (!that._prepare(formatObject, state, customizeTooltip)) {
                    return false
                }
                that._state = state;
                that._wrapper.appendTo(that._getContainer());
                that._clear();
                this.plaque.clear().draw((0, _extend.extend)({}, that._options, {
                    canvas: that._getCanvas()
                }, state, {
                    x: params.x,
                    y: params.y,
                    offset: params.offset
                }));
                that.moveWrapper();
                riseEvents();
                return true
            },
            hide: function() {
                var that = this;
                hideElement(that._wrapper);
                if (that._eventData) {
                    that._eventTrigger("tooltipHidden", that._eventData);
                    that._clear();
                    that._eventData = null
                }
            },
            _clear: function() {
                this._textHtml.empty()
            },
            move: function(x, y, offset) {
                this.plaque.draw({
                    x: x,
                    y: y,
                    offset: offset,
                    canvas: this._getCanvas()
                });
                this.moveWrapper()
            },
            moveWrapper: function() {
                var that = this;
                var plaqueBBox = this.plaque.getBBox();
                that._renderer.resize(plaqueBBox.width, plaqueBBox.height);
                var offset = that._wrapper.css({
                    left: 0,
                    top: 0
                }).offset();
                var left = plaqueBBox.x;
                var top = plaqueBBox.y;
                that._wrapper.css({
                    left: left - offset.left,
                    top: top - offset.top
                });
                this.plaque.moveRoot(-left, -top);
                if (this._state.html) {
                    that._textHtml.css({
                        left: -left,
                        top: -top
                    });
                    that._textGroupHtml.css({
                        width: plaqueBBox.width
                    })
                }
            },
            formatValue: function(value, _specialFormat) {
                var options = _specialFormat ? getSpecialFormatOptions(this._options, _specialFormat) : this._options;
                return format(value, options.format)
            },
            getLocation: function() {
                return (0, _utils.normalizeEnum)(this._options.location)
            },
            isEnabled: function() {
                return !!this._options.enabled || !!this._options.forceEvents
            },
            isShared: function() {
                return !!this._options.shared
            },
            _getCanvas: function() {
                var container = this._getContainer();
                var containerBox = container.getBoundingClientRect();
                var html = _dom_adapter.default.getDocumentElement();
                var document = _dom_adapter.default.getDocument();
                var left = window.pageXOffset || html.scrollLeft || 0;
                var top = window.pageYOffset || html.scrollTop || 0;
                var box = {
                    left: left,
                    top: top,
                    width: html.clientWidth + left || 0,
                    height: mathMax(document.body.scrollHeight, html.scrollHeight, document.body.offsetHeight, html.offsetHeight, document.body.clientHeight, html.clientHeight) || 0,
                    right: 0,
                    bottom: 0
                };
                if (container !== _dom_adapter.default.getBody()) {
                    left = mathMax(box.left, box.left + containerBox.left);
                    top = mathMax(box.top, box.top + containerBox.top);
                    box.width = mathMin(containerBox.width, box.width) + left + box.left;
                    box.height = mathMin(containerBox.height, box.height) + top + box.top;
                    box.left = left;
                    box.top = top
                }
                return box
            }
        };
        var plugin = {
            name: "tooltip",
            init: function() {
                this._initTooltip()
            },
            dispose: function() {
                this._disposeTooltip()
            },
            members: {
                _initTooltip: function() {
                    this._tooltip = new Tooltip({
                        cssClass: this._rootClassPrefix + "-tooltip",
                        eventTrigger: this._eventTrigger,
                        pathModified: this.option("pathModified"),
                        widgetRoot: this.element(),
                        widget: this
                    })
                },
                _disposeTooltip: function() {
                    this._tooltip.dispose();
                    this._tooltip = null
                },
                _setTooltipRendererOptions: function() {
                    this._tooltip.setRendererOptions(this._getRendererOptions())
                },
                _setTooltipOptions: function() {
                    this._tooltip.update(this._getOption("tooltip"))
                }
            },
            extenders: {
                _stopCurrentHandling: function() {
                    this._tooltip && this._tooltip.hide()
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                proto._eventsMap.onTooltipShown = {
                    name: "tooltipShown"
                };
                proto._eventsMap.onTooltipHidden = {
                    name: "tooltipHidden"
                };
                constructor.addChange({
                    code: "TOOLTIP_RENDERER",
                    handler: function() {
                        this._setTooltipRendererOptions()
                    },
                    isThemeDependent: true,
                    isOptionChange: true
                });
                constructor.addChange({
                    code: "TOOLTIP",
                    handler: function() {
                        this._setTooltipOptions()
                    },
                    isThemeDependent: true,
                    isOptionChange: true,
                    option: "tooltip"
                })
            },
            fontFields: ["tooltip.font"]
        };
        exports.plugin = plugin
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/translators/range.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.Range = void 0;
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ../core/utils */ 12);
        var _isDefined = _type.isDefined;
        var _isDate = _type.isDate;
        var _isFunction = _type.isFunction;
        var minSelector = "min";
        var maxSelector = "max";
        var minVisibleSelector = "minVisible";
        var maxVisibleSelector = "maxVisible";
        var baseSelector = "base";
        var axisTypeSelector = "axisType";

        function otherLessThan(thisValue, otherValue) {
            return otherValue < thisValue
        }

        function otherGreaterThan(thisValue, otherValue) {
            return otherValue > thisValue
        }

        function compareAndReplace(thisValue, otherValue, setValue, compare) {
            var otherValueDefined = _isDefined(otherValue);
            if (_isDefined(thisValue)) {
                if (otherValueDefined && compare(thisValue, otherValue)) {
                    setValue(otherValue)
                }
            } else {
                if (otherValueDefined) {
                    setValue(otherValue)
                }
            }
        }
        var Range = function(range) {
            range && (0, _extend.extend)(this, range)
        };
        exports.Range = Range;
        var _Range = Range;
        _Range.prototype = {
            constructor: _Range,
            addRange: function(otherRange) {
                var that = this;
                var categories = that.categories;
                var otherCategories = otherRange.categories;
                var isDiscrete = "discrete" === that[axisTypeSelector];
                var compareAndReplaceByField = function(field, compare) {
                    compareAndReplace(that[field], otherRange[field], function(value) {
                        that[field] = value
                    }, compare)
                };
                var controlValuesByVisibleBounds = function(valueField, visibleValueField, compare) {
                    compareAndReplace(that[valueField], that[visibleValueField], function(value) {
                        _isDefined(that[valueField]) && (that[valueField] = value)
                    }, compare)
                };
                var checkField = function(field) {
                    that[field] = that[field] || otherRange[field]
                };
                checkField("invert");
                checkField(axisTypeSelector);
                checkField("dataType");
                checkField("isSpacedMargin");
                if ("logarithmic" === that[axisTypeSelector]) {
                    checkField(baseSelector)
                } else {
                    that[baseSelector] = void 0
                }
                compareAndReplaceByField(minSelector, otherLessThan);
                compareAndReplaceByField(maxSelector, otherGreaterThan);
                if (isDiscrete) {
                    checkField(minVisibleSelector);
                    checkField(maxVisibleSelector)
                } else {
                    compareAndReplaceByField(minVisibleSelector, otherLessThan);
                    compareAndReplaceByField(maxVisibleSelector, otherGreaterThan)
                }
                compareAndReplaceByField("interval", otherLessThan);
                if (!isDiscrete) {
                    controlValuesByVisibleBounds(minSelector, minVisibleSelector, otherLessThan);
                    controlValuesByVisibleBounds(minSelector, maxVisibleSelector, otherLessThan);
                    controlValuesByVisibleBounds(maxSelector, maxVisibleSelector, otherGreaterThan);
                    controlValuesByVisibleBounds(maxSelector, minVisibleSelector, otherGreaterThan)
                }
                if (void 0 === categories) {
                    that.categories = otherCategories
                } else {
                    that.categories = otherCategories ? (0, _utils.unique)(categories.concat(otherCategories)) : categories
                }
                if ("logarithmic" === that[axisTypeSelector]) {
                    checkField("allowNegatives");
                    compareAndReplaceByField("linearThreshold", otherLessThan)
                }
                return that
            },
            isEmpty: function() {
                return (!_isDefined(this[minSelector]) || !_isDefined(this[maxSelector])) && (!this.categories || 0 === this.categories.length)
            },
            correctValueZeroLevel: function() {
                var that = this;
                if ("logarithmic" === that[axisTypeSelector] || _isDate(that[maxSelector]) || _isDate(that[minSelector])) {
                    return that
                }

                function setZeroLevel(min, max) {
                    that[min] < 0 && that[max] < 0 && (that[max] = 0);
                    that[min] > 0 && that[max] > 0 && (that[min] = 0)
                }
                setZeroLevel(minSelector, maxSelector);
                setZeroLevel(minVisibleSelector, maxVisibleSelector);
                return that
            },
            sortCategories: function(sort) {
                if (false === sort || !this.categories) {
                    return
                }
                if (Array.isArray(sort)) {
                    var sortValues = sort.map(function(item) {
                        return item.valueOf()
                    });
                    var filteredSeriesCategories = this.categories.filter(function(item) {
                        return sortValues.indexOf(item.valueOf()) === -1
                    });
                    this.categories = sort.concat(filteredSeriesCategories)
                } else {
                    var notAFunction = !_isFunction(sort);
                    if (notAFunction && "string" !== this.dataType) {
                        sort = function(a, b) {
                            return a.valueOf() - b.valueOf()
                        }
                    } else {
                        if (notAFunction) {
                            sort = false
                        }
                    }
                    sort && this.categories.sort(sort)
                }
            }
        }
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/utils/resize_callbacks.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _window = __webpack_require__( /*! ./window */ 7);
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 11));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 27));
        var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 49));
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var resizeCallbacks = function() {
            var prevSize;
            var callbacks = (0, _callbacks.default)();
            var originalCallbacksAdd = callbacks.add;
            var originalCallbacksRemove = callbacks.remove;
            if (!(0, _window.hasWindow)()) {
                return callbacks
            }
            var formatSize = function() {
                var window = (0, _window.getWindow)();
                return {
                    width: window.innerWidth,
                    height: window.innerHeight
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                callbacks.fire(changedDimension)
            };
            var setPrevSize = (0, _call_once.default)(function() {
                prevSize = formatSize()
            });
            var removeListener;
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                setPrevSize();
                _ready_callbacks.default.add(function() {
                    if (!removeListener && callbacks.has()) {
                        removeListener = _dom_adapter.default.listen((0, _window.getWindow)(), "resize", handleResize)
                    }
                });
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && removeListener) {
                    removeListener();
                    removeListener = void 0
                }
                return result
            };
            return callbacks
        }();
        var _default = resizeCallbacks;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled-npm/core/templates/function_template.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.FunctionTemplate = void 0;
        var _template_base = __webpack_require__( /*! ./template_base */ 75);
        var _dom = __webpack_require__( /*! ../utils/dom */ 33);

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var FunctionTemplate = function(_TemplateBase) {
            _inherits(FunctionTemplate, _TemplateBase);
            var _super = _createSuper(FunctionTemplate);

            function FunctionTemplate(render) {
                var _this;
                _classCallCheck(this, FunctionTemplate);
                _this = _super.call(this);
                _this._render = render;
                return _this
            }
            _createClass(FunctionTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    return (0, _dom.normalizeTemplateElement)(this._render(options))
                }
            }]);
            return FunctionTemplate
        }(_template_base.TemplateBase);
        exports.FunctionTemplate = FunctionTemplate
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled-npm/core/component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 31));
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _index = __webpack_require__( /*! ./options/index */ 334);
        var _utils = __webpack_require__( /*! ./options/utils */ 200);
        var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 15));
        var _action = _interopRequireDefault(__webpack_require__( /*! ./action */ 110));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 25));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 27));
        var _events_strategy = __webpack_require__( /*! ./events_strategy */ 98);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 145);
        var _postponed_operations = __webpack_require__( /*! ./postponed_operations */ 515);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _common = __webpack_require__( /*! ./utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getEventName = function(actionName) {
            return actionName.charAt(2).toLowerCase() + actionName.substr(3)
        };
        var isInnerOption = function(optionName) {
            return 0 === optionName.indexOf("_", 0)
        };
        var Component = _class.default.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _defaultOptionsRules: function() {
                return []
            },
            _setOptionsByDevice: function(rules) {
                this._options.applyRules(rules)
            },
            _convertRulesToOptions: function(rules) {
                return (0, _utils.convertRulesToOptions)(rules)
            },
            _isInitialOptionValue: function(name) {
                return this._options.isInitial(name)
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function() {
                var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
                var _optionChangedCallbacks = options._optionChangedCallbacks,
                    _disposingCallbacks = options._disposingCallbacks;
                this.NAME = (0, _public_component.name)(this.constructor);
                this._eventsStrategy = _events_strategy.EventsStrategy.create(this, options.eventsStrategy);
                this._updateLockCount = 0;
                this._optionChangedCallbacks = _optionChangedCallbacks || (0, _callbacks.default)();
                this._disposingCallbacks = _disposingCallbacks || (0, _callbacks.default)();
                this.postponedOperations = new _postponed_operations.PostponedOperations;
                this._createOptions(options)
            },
            _createOptions: function(options) {
                var _this = this;
                this.beginUpdate();
                try {
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._options = new _index.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions());
                    this._options.onChanging(function(name, previousValue, value) {
                        return _this._initialized && _this._optionChanging(name, previousValue, value)
                    });
                    this._options.onDeprecated(function(option, info) {
                        return _this._logDeprecatedOptionWarning(option, info)
                    });
                    this._options.onChanged(function(name, value, previousValue) {
                        return _this._notifyOptionChanged(name, value, previousValue)
                    });
                    this._options.onStartChange(function() {
                        return _this.beginUpdate()
                    });
                    this._options.onEndChange(function() {
                        return _this.endUpdate()
                    });
                    this._options.addRules(this._defaultOptionsRules());
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _init: function() {
                var _this2 = this;
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    _this2._disposingCallbacks.fireWith(_this2, [args])
                })
            },
            _logDeprecatedOptionWarning: function(option, info) {
                var message = info.message || "Use the '".concat(info.alias, "' option instead");
                _errors.default.log("W0001", this.NAME, option, info.since, message)
            },
            _logDeprecatedComponentWarning: function(since, alias) {
                _errors.default.log("W0000", this.NAME, since, "Use the '".concat(alias, "' widget instead"))
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._eventsStrategy.dispose();
                this._options.dispose();
                this._disposed = true
            },
            _lockUpdate: function() {
                this._updateLockCount++
            },
            _unlockUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
            },
            _isUpdateAllowed: function() {
                return 0 === this._updateLockCount
            },
            _isInitializingRequired: function() {
                return !this._initializing && !this._initialized
            },
            _commitUpdate: function() {
                this.postponedOperations.callPostponedOperations();
                this._isInitializingRequired() && this._initializeComponent()
            },
            _initializeComponent: function() {
                this._initializing = true;
                try {
                    this._init()
                } finally {
                    this._initializing = false;
                    this._lockUpdate();
                    this._createActionByOption("onInitialized", {
                        excludeValidators: ["disabled", "readOnly"]
                    })();
                    this._unlockUpdate();
                    this._initialized = true
                }
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._lockUpdate()
            },
            endUpdate: function() {
                this._unlockUpdate();
                this._isUpdateAllowed() && this._commitUpdate()
            },
            _optionChanging: _common.noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                if (this._initialized) {
                    var optionNames = [option].concat(this._options.getAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i];
                        var args = {
                            name: name.split(/[.[]/)[0],
                            fullName: name,
                            value: value,
                            previousValue: previousValue
                        };
                        if (!isInnerOption(name)) {
                            this._optionChangedCallbacks.fireWith(this, [(0, _extend.extend)(this._defaultActionArgs(), args)]);
                            this._optionChangedAction((0, _extend.extend)({}, args))
                        }
                        if (!this._disposed && this._cancelOptionChange !== name) {
                            this._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(name) {
                return this._options.initial(name)
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var _this3 = this;
                var action;
                return function(e) {
                    if (!(0, _type.isDefined)(e)) {
                        e = {}
                    }
                    if (!(0, _type.isPlainObject)(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new _action.default(actionSource, (0, _extend.extend)(config, _this3._defaultActionConfig()));
                    return action.execute.call(action, (0, _extend.extend)(e, _this3._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var _this4 = this;
                var action;
                var eventName;
                var actionFunc;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw _errors.default.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = getEventName(optionName)
                        }
                        actionFunc = _this4.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !_this4._eventsStrategy.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function() {
                            for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                props[_key2] = arguments[_key2]
                            }
                            beforeExecute && beforeExecute.apply(_this4, props);
                            _this4._eventsStrategy.fireEvent(eventName, props[0].args)
                        };
                        action = _this4._createAction(actionFunc, config)
                    }
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }
                    if ((0, _config.default)().wrapActionsBeforeExecute) {
                        var beforeActionExecute = _this4.option("beforeActionExecute") || _common.noop;
                        var wrappedAction = beforeActionExecute(_this4, action, config) || action;
                        return wrappedAction.apply(_this4, args)
                    }
                    return action.apply(_this4, args)
                };
                if ((0, _config.default)().wrapActionsBeforeExecute) {
                    return result
                }
                var onActionCreated = this.option("onActionCreated") || _common.noop;
                return onActionCreated(this, result, config) || result
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            hasActionSubscription: function(actionName) {
                return !!this._options.silent(actionName) || this._eventsStrategy.hasEvent(getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                return this._options.isDeprecated(name)
            },
            _setOptionWithoutOptionChange: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            _getOptionValue: function(name, context) {
                var value = this.option(name);
                if ((0, _type.isFunction)(value)) {
                    return value.bind(context)()
                }
                return value
            },
            option: function() {
                var _this$_options;
                return (_this$_options = this._options).option.apply(_this$_options, arguments)
            },
            resetOption: function(name) {
                this.beginUpdate();
                this._options.reset(name);
                this.endUpdate()
            }
        });
        var _default = Component;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled-npm/events/short.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.keyboard = exports.click = exports.dxClick = exports.focus = exports.visibility = exports.hover = exports.resize = exports.active = void 0;
        var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 11));
        var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 5));
        var _keyboard_processor = _interopRequireDefault(__webpack_require__( /*! ./core/keyboard_processor */ 519));
        var _index = __webpack_require__( /*! ./utils/index */ 8);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function addNamespace(event, namespace) {
            return namespace ? (0, _index.addNamespace)(event, namespace) : event
        }

        function executeAction(action, args) {
            return "function" === typeof action ? action(args) : action.execute(args)
        }
        var active = {
            on: function($el, active, inactive, opts) {
                var selector = opts.selector,
                    showTimeout = opts.showTimeout,
                    hideTimeout = opts.hideTimeout,
                    namespace = opts.namespace;
                _events_engine.default.on($el, addNamespace("dxactive", namespace), selector, {
                    timeout: showTimeout
                }, function(event) {
                    return executeAction(active, {
                        event: event,
                        element: event.currentTarget
                    })
                });
                _events_engine.default.on($el, addNamespace("dxinactive", namespace), selector, {
                    timeout: hideTimeout
                }, function(event) {
                    return executeAction(inactive, {
                        event: event,
                        element: event.currentTarget
                    })
                })
            },
            off: function($el, _ref) {
                var namespace = _ref.namespace,
                    selector = _ref.selector;
                _events_engine.default.off($el, addNamespace("dxactive", namespace), selector);
                _events_engine.default.off($el, addNamespace("dxinactive", namespace), selector)
            }
        };
        exports.active = active;
        var resize = {
            on: function($el, resize) {
                var _ref2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                    namespace = _ref2.namespace;
                _events_engine.default.on($el, addNamespace("dxresize", namespace), resize)
            },
            off: function($el) {
                var _ref3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                    namespace = _ref3.namespace;
                _events_engine.default.off($el, addNamespace("dxresize", namespace))
            }
        };
        exports.resize = resize;
        var hover = {
            on: function($el, start, end, _ref4) {
                var selector = _ref4.selector,
                    namespace = _ref4.namespace;
                _events_engine.default.on($el, addNamespace("dxhoverend", namespace), selector, function(event) {
                    return end(event)
                });
                _events_engine.default.on($el, addNamespace("dxhoverstart", namespace), selector, function(event) {
                    return executeAction(start, {
                        element: event.target,
                        event: event
                    })
                })
            },
            off: function($el, _ref5) {
                var selector = _ref5.selector,
                    namespace = _ref5.namespace;
                _events_engine.default.off($el, addNamespace("dxhoverstart", namespace), selector);
                _events_engine.default.off($el, addNamespace("dxhoverend", namespace), selector)
            }
        };
        exports.hover = hover;
        var visibility = {
            on: function($el, shown, hiding, _ref6) {
                var namespace = _ref6.namespace;
                _events_engine.default.on($el, addNamespace("dxhiding", namespace), hiding);
                _events_engine.default.on($el, addNamespace("dxshown", namespace), shown)
            },
            off: function($el, _ref7) {
                var namespace = _ref7.namespace;
                _events_engine.default.off($el, addNamespace("dxhiding", namespace));
                _events_engine.default.off($el, addNamespace("dxshown", namespace))
            }
        };
        exports.visibility = visibility;
        var focus = {
            on: function($el, focusIn, focusOut, _ref8) {
                var namespace = _ref8.namespace,
                    isFocusable = _ref8.isFocusable;
                _events_engine.default.on($el, addNamespace("focusin", namespace), focusIn);
                _events_engine.default.on($el, addNamespace("focusout", namespace), focusOut);
                if (_dom_adapter.default.hasDocumentProperty("onbeforeactivate")) {
                    _events_engine.default.on($el, addNamespace("beforeactivate", namespace), function(e) {
                        return isFocusable(null, e.target) || e.preventDefault()
                    })
                }
            },
            off: function($el, _ref9) {
                var namespace = _ref9.namespace;
                _events_engine.default.off($el, addNamespace("focusin", namespace));
                _events_engine.default.off($el, addNamespace("focusout", namespace));
                if (_dom_adapter.default.hasDocumentProperty("onbeforeactivate")) {
                    _events_engine.default.off($el, addNamespace("beforeactivate", namespace))
                }
            },
            trigger: function($el) {
                return _events_engine.default.trigger($el, "focus")
            }
        };
        exports.focus = focus;
        var dxClick = {
            on: function($el, click) {
                var _ref10 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                    namespace = _ref10.namespace;
                _events_engine.default.on($el, addNamespace("dxclick", namespace), click)
            },
            off: function($el) {
                var _ref11 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                    namespace = _ref11.namespace;
                _events_engine.default.off($el, addNamespace("dxclick", namespace))
            }
        };
        exports.dxClick = dxClick;
        var click = {
            on: function($el, click) {
                var _ref12 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                    namespace = _ref12.namespace;
                _events_engine.default.on($el, addNamespace("click", namespace), click)
            },
            off: function($el) {
                var _ref13 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                    namespace = _ref13.namespace;
                _events_engine.default.off($el, addNamespace("click", namespace))
            }
        };
        exports.click = click;
        var index = 0;
        var keyboardProcessors = {};
        var generateListenerId = function() {
            return "keyboardProcessorId".concat(index++)
        };
        var keyboard = {
            on: function(element, focusTarget, handler) {
                var listenerId = generateListenerId();
                keyboardProcessors[listenerId] = new _keyboard_processor.default({
                    element: element,
                    focusTarget: focusTarget,
                    handler: handler
                });
                return listenerId
            },
            off: function(listenerId) {
                if (listenerId && keyboardProcessors[listenerId]) {
                    keyboardProcessors[listenerId].dispose();
                    delete keyboardProcessors[listenerId]
                }
            },
            _getProcessor: function(listenerId) {
                return keyboardProcessors[listenerId]
            }
        };
        exports.keyboard = keyboard
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled-npm/animation/frame.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.requestAnimationFrame = requestAnimationFrame;
        exports.cancelAnimationFrame = cancelAnimationFrame;
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _call_once = _interopRequireDefault(__webpack_require__( /*! ../core/utils/call_once */ 79));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = (0, _window.hasWindow)() ? (0, _window.getWindow)() : {};
        var FRAME_ANIMATION_STEP_TIME = 1e3 / 60;
        var request = function(callback) {
            return setTimeout(callback, FRAME_ANIMATION_STEP_TIME)
        };
        var cancel = function(requestID) {
            clearTimeout(requestID)
        };
        var setAnimationFrameMethods = (0, _call_once.default)(function() {
            var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame;
            var nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
            if (nativeRequest && nativeCancel) {
                request = nativeRequest;
                cancel = nativeCancel
            }
            if (nativeRequest && !nativeCancel) {
                var canceledRequests = {};
                request = function(callback) {
                    var requestId = nativeRequest.call(window, function() {
                        try {
                            if (requestId in canceledRequests) {
                                return
                            }
                            callback.apply(this, arguments)
                        } finally {
                            delete canceledRequests[requestId]
                        }
                    });
                    return requestId
                };
                cancel = function(requestId) {
                    canceledRequests[requestId] = true
                }
            }
        });

        function requestAnimationFrame() {
            setAnimationFrameMethods();
            return request.apply(window, arguments)
        }

        function cancelAnimationFrame() {
            setAnimationFrameMethods();
            cancel.apply(window, arguments)
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled-npm/data/custom_store.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 2));
        var _utils = _interopRequireDefault(__webpack_require__( /*! ./utils */ 41));
        var _array_utils = __webpack_require__( /*! ./array_utils */ 91);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 31));
        var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 38));
        var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ./abstract_store */ 104));
        var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 167));
        var _store_helper = _interopRequireDefault(__webpack_require__( /*! ./store_helper */ 92));
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var TOTAL_COUNT = "totalCount";
        var LOAD = "load";
        var BY_KEY = "byKey";
        var INSERT = "insert";
        var UPDATE = "update";
        var REMOVE = "remove";

        function isPromise(obj) {
            return obj && (0, _type.isFunction)(obj.then)
        }

        function trivialPromise(value) {
            return (new _deferred.Deferred).resolve(value).promise()
        }

        function ensureRequiredFuncOption(name, obj) {
            if (!(0, _type.isFunction)(obj)) {
                throw _errors.default.errors.Error("E4011", name)
            }
        }

        function throwInvalidUserFuncResult(name) {
            throw _errors.default.errors.Error("E4012", name)
        }

        function createUserFuncFailureHandler(pendingDeferred) {
            function errorMessageFromXhr(promiseArguments) {
                var xhr = promiseArguments[0];
                var textStatus = promiseArguments[1];
                if (!xhr || !xhr.getResponseHeader) {
                    return null
                }
                return _utils.default.errorMessageFromXhr(xhr, textStatus)
            }
            return function(arg) {
                var error;
                if (arg instanceof Error) {
                    error = arg
                } else {
                    error = new Error(errorMessageFromXhr(arguments) || arg && String(arg) || "Unknown error")
                }
                if (error.message !== _utils.default.XHR_ERROR_UNLOAD) {
                    pendingDeferred.reject(error)
                }
            }
        }

        function invokeUserLoad(store, options) {
            var userFunc = store._loadFunc;
            var userResult;
            ensureRequiredFuncOption(LOAD, userFunc);
            userResult = userFunc.apply(store, [options]);
            if (Array.isArray(userResult)) {
                userResult = trivialPromise(userResult)
            } else {
                if (null === userResult || void 0 === userResult) {
                    userResult = trivialPromise([])
                } else {
                    if (!isPromise(userResult)) {
                        throwInvalidUserFuncResult(LOAD)
                    }
                }
            }
            return (0, _deferred.fromPromise)(userResult)
        }

        function invokeUserTotalCountFunc(store, options) {
            var userFunc = store._totalCountFunc;
            var userResult;
            if (!(0, _type.isFunction)(userFunc)) {
                throw _errors.default.errors.Error("E4021")
            }
            userResult = userFunc.apply(store, [options]);
            if (!isPromise(userResult)) {
                userResult = Number(userResult);
                if (!isFinite(userResult)) {
                    throwInvalidUserFuncResult(TOTAL_COUNT)
                }
                userResult = trivialPromise(userResult)
            }
            return (0, _deferred.fromPromise)(userResult)
        }

        function invokeUserByKeyFunc(store, key, extraOptions) {
            var userFunc = store._byKeyFunc;
            var userResult;
            ensureRequiredFuncOption(BY_KEY, userFunc);
            userResult = userFunc.apply(store, [key, extraOptions]);
            if (!isPromise(userResult)) {
                userResult = trivialPromise(userResult)
            }
            return (0, _deferred.fromPromise)(userResult)
        }

        function runRawLoad(pendingDeferred, store, userFuncOptions, continuation) {
            if (store.__rawData) {
                continuation(store.__rawData)
            } else {
                var loadPromise = store.__rawDataPromise || invokeUserLoad(store, userFuncOptions);
                if (store._cacheRawData) {
                    store.__rawDataPromise = loadPromise
                }
                loadPromise.always(function() {
                    delete store.__rawDataPromise
                }).done(function(rawData) {
                    if (store._cacheRawData) {
                        store.__rawData = rawData
                    }
                    continuation(rawData)
                }).fail(createUserFuncFailureHandler(pendingDeferred))
            }
        }

        function runRawLoadWithQuery(pendingDeferred, store, options, countOnly) {
            options = options || {};
            var userFuncOptions = {};
            if ("userData" in options) {
                userFuncOptions.userData = options.userData
            }
            runRawLoad(pendingDeferred, store, userFuncOptions, function(rawData) {
                var rawDataQuery = (0, _array_query.default)(rawData, {
                    errorHandler: store._errorHandler
                });
                var itemsQuery;
                var totalCountQuery;
                var waitList = [];
                var items;
                var totalCount;
                if (!countOnly) {
                    itemsQuery = _store_helper.default.queryByOptions(rawDataQuery, options);
                    if (itemsQuery === rawDataQuery) {
                        items = rawData.slice(0)
                    } else {
                        waitList.push(itemsQuery.enumerate().done(function(asyncResult) {
                            items = asyncResult
                        }))
                    }
                }
                if (options.requireTotalCount || countOnly) {
                    totalCountQuery = _store_helper.default.queryByOptions(rawDataQuery, options, true);
                    if (totalCountQuery === rawDataQuery) {
                        totalCount = rawData.length
                    } else {
                        waitList.push(totalCountQuery.count().done(function(asyncResult) {
                            totalCount = asyncResult
                        }))
                    }
                }
                _deferred.when.apply(_renderer.default, waitList).done(function() {
                    if (countOnly) {
                        pendingDeferred.resolve(totalCount)
                    } else {
                        if (options.requireTotalCount) {
                            pendingDeferred.resolve(items, {
                                totalCount: totalCount
                            })
                        } else {
                            pendingDeferred.resolve(items)
                        }
                    }
                }).fail(function(x) {
                    pendingDeferred.reject(x)
                })
            })
        }

        function runRawLoadWithKey(pendingDeferred, store, key) {
            runRawLoad(pendingDeferred, store, {}, function(rawData) {
                var keyExpr = store.key();
                var item;
                for (var i = 0, len = rawData.length; i < len; i++) {
                    item = rawData[i];
                    if (_utils.default.keysEqual(keyExpr, store.keyOf(rawData[i]), key)) {
                        pendingDeferred.resolve(item);
                        return
                    }
                }
                pendingDeferred.reject(_errors.default.errors.Error("E4009"))
            })
        }
        var CustomStore = _abstract_store.default.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._useDefaultSearch = !!options.useDefaultSearch || "raw" === options.loadMode;
                this._loadMode = options.loadMode;
                this._cacheRawData = false !== options.cacheRawData;
                this._loadFunc = options[LOAD];
                this._totalCountFunc = options[TOTAL_COUNT];
                this._byKeyFunc = options[BY_KEY];
                this._insertFunc = options[INSERT];
                this._updateFunc = options[UPDATE];
                this._removeFunc = options[REMOVE]
            },
            createQuery: function() {
                throw _errors.default.errors.Error("E4010")
            },
            clearRawDataCache: function() {
                delete this.__rawData
            },
            _totalCountImpl: function(options) {
                var d = new _deferred.Deferred;
                if ("raw" === this._loadMode && !this._totalCountFunc) {
                    runRawLoadWithQuery(d, this, options, true)
                } else {
                    invokeUserTotalCountFunc(this, options).done(function(count) {
                        d.resolve(Number(count))
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _pushImpl: function(changes) {
                if (this.__rawData) {
                    (0, _array_utils.applyBatch)({
                        keyInfo: this,
                        data: this.__rawData,
                        changes: changes
                    })
                }
            },
            _loadImpl: function(options) {
                var d = new _deferred.Deferred;
                if ("raw" === this._loadMode) {
                    runRawLoadWithQuery(d, this, options, false)
                } else {
                    invokeUserLoad(this, options).done(function(data, extra) {
                        d.resolve(data, extra)
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _byKeyImpl: function(key, extraOptions) {
                var d = new _deferred.Deferred;
                if (this._byKeyViaLoad()) {
                    this._requireKey();
                    runRawLoadWithKey(d, this, key)
                } else {
                    invokeUserByKeyFunc(this, key, extraOptions).done(function(obj) {
                        d.resolve(obj)
                    }).fail(createUserFuncFailureHandler(d))
                }
                return d.promise()
            },
            _byKeyViaLoad: function() {
                return "raw" === this._loadMode && !this._byKeyFunc
            },
            _insertImpl: function(values) {
                var that = this;
                var userFunc = that._insertFunc;
                var userResult;
                var d = new _deferred.Deferred;
                ensureRequiredFuncOption(INSERT, userFunc);
                userResult = userFunc.apply(that, [values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }(0, _deferred.fromPromise)(userResult).done(function(serverResponse) {
                    if ((0, _config.default)().useLegacyStoreResult) {
                        d.resolve(values, serverResponse)
                    } else {
                        d.resolve(serverResponse || values, that.keyOf(serverResponse))
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _updateImpl: function(key, values) {
                var userFunc = this._updateFunc;
                var userResult;
                var d = new _deferred.Deferred;
                ensureRequiredFuncOption(UPDATE, userFunc);
                userResult = userFunc.apply(this, [key, values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }(0, _deferred.fromPromise)(userResult).done(function(serverResponse) {
                    if ((0, _config.default)().useLegacyStoreResult) {
                        d.resolve(key, values)
                    } else {
                        d.resolve(serverResponse || values, key)
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _removeImpl: function(key) {
                var userFunc = this._removeFunc;
                var userResult;
                var d = new _deferred.Deferred;
                ensureRequiredFuncOption(REMOVE, userFunc);
                userResult = userFunc.apply(this, [key]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise()
                }(0, _deferred.fromPromise)(userResult).done(function() {
                    d.resolve(key)
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            }
        });
        var _default = CustomStore;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*****************************************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/event_registrator_callbacks.js ***!
      \*****************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _memorized_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/memorized_callbacks */ 199));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _default = new _memorized_callbacks.default;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled-npm/events/core/emitter.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 2));
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 15));
        var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 27));
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _index = __webpack_require__( /*! ../utils/index */ 8);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var Emitter = _class.default.inherit({
            ctor: function(element) {
                this._$element = (0, _renderer.default)(element);
                this._cancelCallback = (0, _callbacks.default)();
                this._acceptCallback = (0, _callbacks.default)()
            },
            getElement: function() {
                return this._$element
            },
            validate: function(e) {
                return !(0, _index.isDxMouseWheelEvent)(e)
            },
            validatePointers: function(e) {
                return 1 === (0, _index.hasTouches)(e)
            },
            allowInterruptionByMouseWheel: function() {
                return true
            },
            configure: function(data) {
                (0, _extend.extend)(this, data)
            },
            addCancelCallback: function(callback) {
                this._cancelCallback.add(callback)
            },
            removeCancelCallback: function() {
                this._cancelCallback.empty()
            },
            _cancel: function(e) {
                this._cancelCallback.fire(this, e)
            },
            addAcceptCallback: function(callback) {
                this._acceptCallback.add(callback)
            },
            removeAcceptCallback: function() {
                this._acceptCallback.empty()
            },
            _accept: function(e) {
                this._acceptCallback.fire(this, e)
            },
            _requestAccept: function(e) {
                this._acceptRequestEvent = e
            },
            _forgetAccept: function() {
                this._accept(this._acceptRequestEvent);
                this._acceptRequestEvent = null
            },
            start: _common.noop,
            move: _common.noop,
            end: _common.noop,
            cancel: _common.noop,
            reset: function() {
                if (this._acceptRequestEvent) {
                    this._accept(this._acceptRequestEvent)
                }
            },
            _fireEvent: function(eventName, e, params) {
                var eventData = (0, _extend.extend)({
                    type: eventName,
                    originalEvent: e,
                    target: this._getEmitterTarget(e),
                    delegateTarget: this.getElement().get(0)
                }, params);
                e = (0, _index.fireEvent)(eventData);
                if (e.cancel) {
                    this._cancel(e)
                }
                return e
            },
            _getEmitterTarget: function(e) {
                return (this.delegateSelector ? (0, _renderer.default)(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
            },
            dispose: _common.noop
        });
        var _default = Emitter;
        exports.default = _default;
        module.exports = exports.default
    },
    /*!*********************************!*\
      !*** external "window.angular" ***!
      \*********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.angular
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled-npm/localization/globalize/core.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _globalize = _interopRequireDefault(__webpack_require__( /*! globalize */ 78));
        var _core = _interopRequireDefault(__webpack_require__( /*! ../core */ 86));

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        if (_globalize.default && _globalize.default.load) {
            var likelySubtags = {
                supplemental: {
                    version: {
                        _cldrVersion: "28",
                        _unicodeVersion: "8.0.0",
                        _number: "$Revision: 11965 $"
                    },
                    likelySubtags: {
                        en: "en-Latn-US",
                        de: "de-Latn-DE",
                        ru: "ru-Cyrl-RU",
                        ja: "ja-Jpan-JP"
                    }
                }
            };
            if (!_globalize.default.locale()) {
                _globalize.default.load(likelySubtags);
                _globalize.default.locale("en")
            }
            _core.default.inject({
                locale: function(_locale) {
                    if (!_locale) {
                        return _globalize.default.locale().locale
                    }
                    _globalize.default.locale(_locale)
                }
            })
        }
    }, , , , , , ,
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/components/consts.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _default = {
            events: {
                mouseover: "mouseover",
                mouseout: "mouseout",
                mousemove: "mousemove",
                touchstart: "touchstart",
                touchmove: "touchmove",
                touchend: "touchend",
                mousedown: "mousedown",
                mouseup: "mouseup",
                click: "click",
                selectSeries: "selectseries",
                deselectSeries: "deselectseries",
                selectPoint: "selectpoint",
                deselectPoint: "deselectpoint",
                showPointTooltip: "showpointtooltip",
                hidePointTooltip: "hidepointtooltip"
            },
            states: {
                hover: "hover",
                normal: "normal",
                selection: "selection",
                normalMark: 0,
                hoverMark: 1,
                selectedMark: 2,
                applyHover: "applyHover",
                applySelected: "applySelected",
                resetItem: "resetItem"
            },
            radialLabelIndent: 30,
            pieLabelSpacing: 10,
            pieSeriesSpacing: 4
        };
        exports.default = _default;
        module.exports = exports.default
    },
    /*!********************************************************************!*\
      !*** ./artifacts/transpiled-npm/viz/series/points/symbol_point.js ***!
      \********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.default = void 0;
        var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 3);
        var _common = __webpack_require__( /*! ../../../core/utils/common */ 4);
        var _window = __webpack_require__( /*! ../../../core/utils/window */ 7);
        var _label = __webpack_require__( /*! ./label */ 315);
        var _type = __webpack_require__( /*! ../../../core/utils/type */ 1);
        var _utils = __webpack_require__( /*! ../../core/utils */ 12);
        var window = (0, _window.getWindow)();
        var _extend = _extend2.extend;
        var _math = Math;
        var _round = _math.round;
        var _floor = _math.floor;
        var _ceil = _math.ceil;
        var DEFAULT_IMAGE_WIDTH = 20;
        var DEFAULT_IMAGE_HEIGHT = 20;
        var LABEL_OFFSET = 10;
        var CANVAS_POSITION_DEFAULT = "canvas_position_default";

        function getSquareMarkerCoords(radius) {
            return [-radius, -radius, radius, -radius, radius, radius, -radius, radius, -radius, -radius]
        }

        function getPolygonMarkerCoords(radius) {
            var r = _ceil(radius);
            return [-r, 0, 0, -r, r, 0, 0, r, -r, 0]
        }

        function getCrossMarkerCoords(radius) {
            var r = _ceil(radius);
            var floorHalfRadius = _floor(r / 2);
            var ceilHalfRadius = _ceil(r / 2);
            return [-r, -floorHalfRadius, -floorHalfRadius, -r, 0, -ceilHalfRadius, floorHalfRadius, -r, r, -floorHalfRadius, ceilHalfRadius, 0, r, floorHalfRadius, floorHalfRadius, r, 0, ceilHalfRadius, -floorHalfRadius, r, -r, floorHalfRadius, -ceilHalfRadius, 0]
        }

        function getTriangleDownMarkerCoords(radius) {
            return [-radius, -radius, radius, -radius, 0, radius, -radius, -radius]
        }

        function getTriangleUpMarkerCoords(radius) {
            return [-radius, radius, radius, radius, 0, -radius, -radius, radius]
        }
        var _default = {
            deleteLabel: function() {
                this._label.dispose();
                this._label = null
            },
            _hasGraphic: function() {
                return this.graphic
            },
            clearVisibility: function() {
                var that = this;
                var graphic = that.graphic;
                if (graphic && graphic.attr("visibility")) {
                    graphic.attr({
                        visibility: null
                    })
                }
            },
            isVisible: function() {
                return this.inVisibleArea && this.series.isVisible()
            },
            setInvisibility: function() {
                var that = this;
                var graphic = that.graphic;
                if (graphic && "hidden" !== graphic.attr("visibility")) {
                    graphic.attr({
                        visibility: "hidden"
                    })
                }
                that._errorBar && that._errorBar.attr({
                    visibility: "hidden"
                });
                that._label.draw(false)
            },
            clearMarker: function() {
                var graphic = this.graphic;
                graphic && graphic.attr(this._emptySettings)
            },
            _createLabel: function() {
                this._label = new _label.Label({
                    renderer: this.series._renderer,
                    labelsGroup: this.series._labelsGroup,
                    point: this
                })
            },
            _updateLabelData: function() {
                this._label.setData(this._getLabelFormatObject())
            },
            _updateLabelOptions: function() {
                !this._label && this._createLabel();
                this._label.setOptions(this._options.label)
            },
            _checkImage: function(image) {
                return (0, _type.isDefined)(image) && ("string" === typeof image || (0, _type.isDefined)(image.url))
            },
            _fillStyle: function() {
                this._styles = this._options.styles
            },
            _checkSymbol: function(oldOptions, newOptions) {
                var oldSymbol = oldOptions.symbol;
                var newSymbol = newOptions.symbol;
                var symbolChanged = "circle" === oldSymbol && "circle" !== newSymbol || "circle" !== oldSymbol && "circle" === newSymbol;
                var imageChanged = this._checkImage(oldOptions.image) !== this._checkImage(newOptions.image);
                return !!(symbolChanged || imageChanged)
            },
            _populatePointShape: function(symbol, radius) {
                switch (symbol) {
                    case "square":
                        return getSquareMarkerCoords(radius);
                    case "polygon":
                        return getPolygonMarkerCoords(radius);
                    case "triangle":
                    case "triangleDown":
                        return getTriangleDownMarkerCoords(radius);
                    case "triangleUp":
                        return getTriangleUpMarkerCoords(radius);
                    case "cross":
                        return getCrossMarkerCoords(radius)
                }
            },
            hasCoords: function() {
                return null !== this.x && null !== this.y
            },
            correctValue: function(correction) {
                var that = this;
                var axis = that.series.getValueAxis();
                if (that.hasValue()) {
                    that.value = that.properValue = axis.validateUnit(that.initialValue.valueOf() + correction.valueOf());
                    that.minValue = axis.validateUnit(correction)
                }
            },
            resetCorrection: function() {
                this.value = this.properValue = this.initialValue;
                this.minValue = CANVAS_POSITION_DEFAULT
            },
            resetValue: function() {
                var that = this;
                if (that.hasValue()) {
                    that.value = that.properValue = that.initialValue = 0;
                    that.minValue = 0;
                    that._label.setDataField("value", that.value)
                }
            },
            _getTranslates: function(animationEnabled) {
                var translateX = this.x;
                var translateY = this.y;
                if (animationEnabled) {
                    if (this._options.rotated) {
                        translateX = this.defaultX
                    } else {
                        translateY = this.defaultY
                    }
                }
                return {
                    x: translateX,
                    y: translateY
                }
            },
            _createImageMarker: function(renderer, settings, options) {
                var width = options.width || DEFAULT_IMAGE_WIDTH;
                var height = options.height || DEFAULT_IMAGE_HEIGHT;
                return renderer.image(-_round(.5 * width), -_round(.5 * height), width, height, options.url ? options.url.toString() : options.toString(), "center").attr({
                    translateX: settings.translateX,
                    translateY: settings.translateY,
                    visibility: settings.visibility
                })
            },
            _createSymbolMarker: function(renderer, pointSettings) {
                var marker;
                var symbol = this._options.symbol;
                if ("circle" === symbol) {
                    delete pointSettings.points;
                    marker = renderer.circle().attr(pointSettings)
                } else {
                    if ("square" === symbol || "polygon" === symbol || "triangle" === symbol || "triangleDown" === symbol || "triangleUp" === symbol || "cross" === symbol) {
                        marker = renderer.path([], "area").attr(pointSettings).sharp()
                    }
                }
                return marker
            },
            _createMarker: function(renderer, group, image, settings) {
                var that = this;
                var marker = that._checkImage(image) ? that._createImageMarker(renderer, settings, image) : that._createSymbolMarker(renderer, settings);
                if (marker) {
                    marker.data({
                        "chart-data-point": that
                    }).append(group)
                }
                return marker
            },
            _getSymbolBBox: function(x, y, r) {
                return {
                    x: x - r,
                    y: y - r,
                    width: 2 * r,
                    height: 2 * r
                }
            },
            _getImageBBox: function(x, y) {
                var image = this._options.image;
                var width = image.width || DEFAULT_IMAGE_WIDTH;
                var height = image.height || DEFAULT_IMAGE_HEIGHT;
                return {
                    x: x - _round(width / 2),
                    y: y - _round(height / 2),
                    width: width,
                    height: height
                }
            },
            _getGraphicBBox: function() {
                var that = this;
                var options = that._options;
                var x = that.x;
                var y = that.y;
                var bBox;
                if (options.visible) {
                    bBox = that._checkImage(options.image) ? that._getImageBBox(x, y) : that._getSymbolBBox(x, y, options.styles.normal.r)
                } else {
                    bBox = {
                        x: x,
                        y: y,
                        width: 0,
                        height: 0
                    }
                }
                return bBox
            },
            hideInsideLabel: _common.noop,
            _getShiftLabelCoords: function(label) {
                var coord = this._addLabelAlignmentAndOffset(label, this._getLabelCoords(label));
                return this._checkLabelPosition(label, coord)
            },
            _drawLabel: function() {
                var that = this;
                var customVisibility = that._getCustomLabelVisibility();
                var label = that._label;
                var isVisible = that._showForZeroValues() && that.hasValue() && false !== customVisibility && (that.series.getLabelVisibility() || customVisibility);
                label.draw(!!isVisible)
            },
            correctLabelPosition: function(label) {
                var that = this;
                var coord = that._getShiftLabelCoords(label);
                if (!that.hideInsideLabel(label, coord)) {
                    label.setFigureToDrawConnector(that._getLabelConnector(label.pointPosition));
                    label.shift(_round(coord.x), _round(coord.y))
                }
            },
            _showForZeroValues: function() {
                return true
            },
            _getLabelConnector: function(pointPosition) {
                var bBox = this._getGraphicBBox(pointPosition);
                var w2 = bBox.width / 2;
                var h2 = bBox.height / 2;
                return {
                    x: bBox.x + w2,
                    y: bBox.y + h2,
                    r: this._options.visible ? Math.max(w2, h2) : 0
                }
            },
            _getPositionFromLocation: function() {
                return {
                    x: this.x,
                    y: this.y
                }
            },
            _isPointInVisibleArea: function(visibleArea, graphicBBox) {
                return visibleArea.minX <= graphicBBox.x + graphicBBox.width && visibleArea.maxX >= graphicBBox.x && visibleArea.minY <= graphicBBox.y + graphicBBox.height && visibleArea.maxY >= graphicBBox.y
            },
            _checkLabelPosition: function(label, coord) {
                var that = this;
                var visibleArea = that._getVisibleArea();
                var labelBBox = label.getBoundingRect();
                var graphicBBox = that._getGraphicBBox(label.pointPosition);
                var fullGraphicBBox = that._getGraphicBBox();
                var isInside = "inside" === label.getLayoutOptions().position;
                var offset = LABEL_OFFSET;
                if (that._isPointInVisibleArea(visibleArea, fullGraphicBBox)) {
                    if (!that._options.rotated) {
                        if (visibleArea.minX > coord.x) {
                            coord.x = visibleArea.minX
                        }
                        if (visibleArea.maxX < coord.x + labelBBox.width) {
                            coord.x = visibleArea.maxX - labelBBox.width
                        }
                        if (visibleArea.minY > coord.y) {
                            coord.y = isInside ? visibleArea.minY : graphicBBox.y + graphicBBox.height + offset
                        }
                        if (visibleArea.maxY < coord.y + labelBBox.height) {
                            coord.y = isInside ? visibleArea.maxY - labelBBox.height : graphicBBox.y - labelBBox.height - offset
                        }
                    } else {
                        if (visibleArea.minX > coord.x) {
                            coord.x = isInside ? visibleArea.minX : graphicBBox.x + graphicBBox.width + offset
                        }
                        if (visibleArea.maxX < coord.x + labelBBox.width) {
                            coord.x = isInside ? visibleArea.maxX - labelBBox.width : graphicBBox.x - offset - labelBBox.width
                        }
                        if (visibleArea.minY > coord.y) {
                            coord.y = visibleArea.minY
                        }
                        if (visibleArea.maxY < coord.y + labelBBox.height) {
                            coord.y = visibleArea.maxY - labelBBox.height
                        }
                    }
                }
                return coord
            },
            _addLabelAlignmentAndOffset: function(label, coord) {
                var labelBBox = label.getBoundingRect();
                var labelOptions = label.getLayoutOptions();
                if (!this._options.rotated) {
                    if ("left" === labelOptions.alignment) {
                        coord.x += labelBBox.width / 2
                    } else {
                        if ("right" === labelOptions.alignment) {
                            coord.x -= labelBBox.width / 2
                        }
                    }
                }
                coord.x += labelOptions.horizontalOffset;
                coord.y += labelOptions.verticalOffset;
                return coord
            },
            _getLabelCoords: function(label) {
                return this._getLabelCoordOfPosition(label, this._getLabelPosition(label.pointPosition))
            },
            _getLabelCoordOfPosition: function(label, position) {
                var that = this;
                var labelBBox = label.getBoundingRect();
                var graphicBBox = that._getGraphicBBox(label.pointPosition);
                var offset = LABEL_OFFSET;
                var centerY = graphicBBox.height / 2 - labelBBox.height / 2;
                var centerX = graphicBBox.width / 2 - labelBBox.width / 2;
                var x = graphicBBox.x;
                var y = graphicBBox.y;
                switch (position) {
                    case "left":
                        x -= labelBBox.width + offset;
                        y += centerY;
                        break;
                    case "right":
                        x += graphicBBox.width + offset;
                        y += centerY;
                        break;
                    case "top":
                        x += centerX;
                        y -= labelBBox.height + offset;
                        break;
                    case "bottom":
                        x += centerX;
                        y += graphicBBox.height + offset;
                        break;
                    case "inside":
                        x += centerX;
                        y += centerY
                }
                return {
                    x: x,
                    y: y
                }
            },
            _drawMarker: function(renderer, group, animationEnabled) {
                var that = this;
                var options = that._options;
                var translates = that._getTranslates(animationEnabled);
                var style = that._getStyle();
                that.graphic = that._createMarker(renderer, group, options.image, _extend({
                    translateX: translates.x,
                    translateY: translates.y,
                    points: that._populatePointShape(options.symbol, style.r)
                }, style))
            },
            _getErrorBarSettings: function() {
                return {
                    visibility: "visible"
                }
            },
            _getErrorBarBaseEdgeLength: function() {
                return 2 * this.getPointRadius()
            },
            _drawErrorBar: function(renderer, group) {
                if (!this._options.errorBars) {
                    return
                }
                var that = this;
                var options = that._options;
                var errorBarOptions = options.errorBars;
                var points = [];
                var settings;
                var pos = that._errorBarPos;
                var high = that._highErrorCoord;
                var low = that._lowErrorCoord;
                var displayMode = (0, _utils.normalizeEnum)(errorBarOptions.displayMode);
                var isHighDisplayMode = "high" === displayMode;
                var isLowDisplayMode = "low" === displayMode;
                var highErrorOnly = (isHighDisplayMode || !(0, _type.isDefined)(low)) && (0, _type.isDefined)(high) && !isLowDisplayMode;
                var lowErrorOnly = (isLowDisplayMode || !(0, _type.isDefined)(high)) && (0, _type.isDefined)(low) && !isHighDisplayMode;
                var edgeLength = errorBarOptions.edgeLength;
                if (edgeLength <= 1 && edgeLength > 0) {
                    edgeLength = this._getErrorBarBaseEdgeLength() * errorBarOptions.edgeLength
                }
                edgeLength = _floor(parseInt(edgeLength) / 2);
                highErrorOnly && (low = that._baseErrorBarPos);
                lowErrorOnly && (high = that._baseErrorBarPos);
                if ("none" !== displayMode && (0, _type.isDefined)(high) && (0, _type.isDefined)(low) && (0, _type.isDefined)(pos)) {
                    !lowErrorOnly && points.push([pos - edgeLength, high, pos + edgeLength, high]);
                    points.push([pos, high, pos, low]);
                    !highErrorOnly && points.push([pos + edgeLength, low, pos - edgeLength, low]);
                    options.rotated && (0, _iterator.each)(points, function(_, p) {
                        p.reverse()
                    });
                    settings = that._getErrorBarSettings(errorBarOptions);
                    if (!that._errorBar) {
                        that._errorBar = renderer.path(points, "line").attr(settings).append(group)
                    } else {
                        settings.points = points;
                        that._errorBar.attr(settings)
                    }
                } else {
                    that._errorBar && that._errorBar.attr({
                        visibility: "hidden"
                    })
                }
            },
            getTooltipParams: function() {
                var that = this;
                var graphic = that.graphic;
                return {
                    x: that.x,
                    y: that.y,
                    offset: graphic ? graphic.getBBox().height / 2 : 0
                }
            },
            setPercentValue: function(absTotal, total, leftHoleTotal, rightHoleTotal) {
                var that = this;
                var valuePercent = that.value / absTotal || 0;
                var minValuePercent = that.minValue / absTotal || 0;
                var percent = valuePercent - minValuePercent;
                that._label.setDataField("percent", percent);
                that._label.setDataField("total", total);
                if (that.series.isFullStackedSeries() && that.hasValue()) {
                    if (that.leftHole) {
                        that.leftHole /= absTotal - leftHoleTotal;
                        that.minLeftHole /= absTotal - leftHoleTotal
                    }
                    if (that.rightHole) {
                        that.rightHole /= absTotal - rightHoleTotal;
                        that.minRightHole /= absTotal - rightHoleTotal
                    }
                    that.value = that.properValue = valuePercent;
                    that.minValue = !minValuePercent ? that.minValue : minValuePercent
                }
            },
            _storeTrackerR: function() {
                var that = this;
                var navigator = window.navigator;
                var r = that._options.styles.normal.r;
                var minTrackerSize = (0, _window.hasProperty)("ontouchstart") || navigator.msPointerEnabled && navigator.msMaxTouchPoints || navigator.pointerEnabled && navigator.maxTouchPoints ? 20 : 6;
                that._options.trackerR = r < minTrackerSize ? minTrackerSize : r;
                return that._options.trackerR
            },
            _translateErrorBars: function() {
                var that = this;
                var options = that._options;
                var rotated = options.rotated;
                var errorBars = options.errorBars;
                var translator = that._getValTranslator();
                if (!errorBars) {
                    return
                }(0, _type.isDefined)(that.lowError) && (that._lowErrorCoord = translator.translate(that.lowError));
                (0, _type.isDefined)(that.highError) && (that._highErrorCoord = translator.translate(that.highError));
                that._errorBarPos = _floor(rotated ? that.vy : that.vx);
                that._baseErrorBarPos = "stdDeviation" === errorBars.type ? that._lowErrorCoord + (that._highErrorCoord - that._lowErrorCoord) / 2 : rotated ? that.vx : that.vy
            },
            _translate: function() {
                var that = this;
                var valTranslator = that._getValTranslator();
                var argTranslator = that._getArgTranslator();
                if (that._options.rotated) {
                    that.vx = that.x = valTranslator.translate(that.value);
                    that.vy = that.y = argTranslator.translate(that.argument);
                    that.minX = valTranslator.translate(that.minValue);
                    that.defaultX = valTranslator.translate(CANVAS_POSITION_DEFAULT)
                } else {
                    that.vy = that.y = valTranslator.translate(that.value);
                    that.vx = that.x = argTranslator.translate(that.argument);
                    that.minY = valTranslator.translate(that.minValue);
                    that.defaultY = valTranslator.translate(CANVAS_POSITION_DEFAULT)
                }
                that._translateErrorBars();
                that._calculateVisibility(that.x, that.y)
            },
            _updateData: function(data) {
                var that = this;
                that.value = that.properValue = that.initialValue = that.originalValue = data.value;
                that.minValue = that.initialMinValue = that.originalMinValue = (0, _type.isDefined)(data.minValue) ? data.minValue : CANVAS_POSITION_DEFAULT
            },
            _getImageSettings: function(image) {
                return {
                    href: image.url || image.toString(),
                    width: image.width || DEFAULT_IMAGE_WIDTH,
                    height: image.height || DEFAULT_IMAGE_HEIGHT
                }
            },
            getCrosshairData: function() {
                var that = this;
                var r = that._options.rotated;
                var value = that.properValue;
                var argument = that.argument;
                return {
                    x: that.vx,
                    y: that.vy,
                    xValue: r ? value : argument,
                    yValue: r ? argument : value,
                    axis: that.series.axis
                }
            },
            getPointRadius: function() {
                var style = this._getStyle();
                var options = this._options;
                var r = style.r;
                var extraSpace;
                var symbol = options.symbol;
                var isSquare = "square" === symbol;
                var isTriangle = "triangle" === symbol || "triangleDown" === symbol || "triangleUp" === symbol;
                if (options.visible && !options.image && r) {
                    extraSpace = style["stroke-width"] / 2;
                    return (isSquare || isTriangle ? 1.4 * r : r) + extraSpace
                }
                return 0
            },
            _updateMarker: function(animationEnabled, style) {
                var that = this;
                var options = that._options;
                var settings;
                var image = options.image;
                var visibility = !that.isVisible() ? {
                    visibility: "hidden"
                } : {};
                if (that._checkImage(image)) {
                    settings = _extend({}, {
                        visibility: style.visibility
                    }, visibility, that._getImageSettings(image))
                } else {
                    settings = _extend({}, style, visibility, {
                        points: that._populatePointShape(options.symbol, style.r)
                    })
                }
                if (!animationEnabled) {
                    settings.translateX = that.x;
                    settings.translateY = that.y
                }
                that.graphic.attr(settings).sharp()
            },
            _getLabelFormatObject: function() {
                var that = this;
                return {
                    argument: that.initialArgument,
                    value: that.initialValue,
                    originalArgument: that.originalArgument,
                    originalValue: that.originalValue,
                    seriesName: that.series.name,
                    lowErrorValue: that.lowError,
                    highErrorValue: that.highError,
                    point: that
                }
            },
            _getLabelPosition: function() {
                var rotated = this._options.rotated;
                if (this.initialValue > 0) {
                    return rotated ? "right" : "top"
                } else {
                    return rotated ? "left" : "bottom"
                }
            },
            _getFormatObject: function(tooltip) {
                var that = this;
                var labelFormatObject = that._label.getData();
                return _extend({}, labelFormatObject, {
                    argumentText: tooltip.formatValue(that.initialArgument, "argument"),
                    valueText: tooltip.formatValue(that.initialValue)
                }, (0, _type