/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 19.1.6
 * Build date: Wed Sep 11 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 862)
}([
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/extend.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isPlainObject = __webpack_require__( /*! ./type */ 1).isPlainObject;
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (Object.prototype.hasOwnProperty.call(source, prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        var extend = function extend(target) {
            target = target || {};
            var i = 1,
                deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var clone, targetValue = target[key],
                        sourceValue = source[key],
                        sourceValueIsArray = false;
                    if ("__proto__" === key || target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && (isPlainObject(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && isPlainObject(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend;
        exports.extendFromObject = extendFromObject
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/type.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === ("undefined" === typeof object ? "undefined" : _typeof(object)) ? types[typeOfObject] || "object" : "undefined" === typeof object ? "undefined" : _typeof(object)
        };
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        var isDate = function(object) {
            return "date" === type(object)
        };
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        var isFunction = function(object) {
            return "function" === typeof object
        };
        var isString = function(object) {
            return "string" === typeof object
        };
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        var isObject = function(object) {
            return "object" === type(object)
        };
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object),
                ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isBoolean = isBoolean;
        exports.isExponential = isExponential;
        exports.isDate = isDate;
        exports.isDefined = isDefined;
        exports.isFunction = isFunction;
        exports.isString = isString;
        exports.isNumeric = isNumeric;
        exports.isObject = isObject;
        exports.isEmptyObject = isEmptyObject;
        exports.isPlainObject = isPlainObject;
        exports.isPrimitive = isPrimitive;
        exports.isWindow = isWindow;
        exports.isRenderer = isRenderer;
        exports.isPromise = isPromise;
        exports.isDeferred = isDeferred;
        exports.type = type
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/core/renderer.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var rendererBase = __webpack_require__( /*! ./renderer_base */ 251);
        module.exports = rendererBase.get()
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/iterator.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = function(values, callback) {
            if (Array.isArray(values)) {
                return values.map(callback)
            }
            var result = [];
            for (var key in values) {
                result.push(callback(values[key], key))
            }
            return result
        };
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        var reverseEach = function(array, callback) {
            if (!array || !("length" in array) || 0 === array.length) {
                return
            }
            for (var i = array.length - 1; i >= 0; i--) {
                if (false === callback.call(array[i], i, array[i])) {
                    break
                }
            }
        };
        exports.map = map;
        exports.each = each;
        exports.reverseEach = reverseEach
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/common.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _config = __webpack_require__( /*! ../config */ 31);
        var _config2 = _interopRequireDefault(_config);
        var _guid = __webpack_require__( /*! ../guid */ 43);
        var _guid2 = _interopRequireDefault(_guid);
        var _deferred = __webpack_require__( /*! ../utils/deferred */ 6);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _data = __webpack_require__( /*! ./data */ 20);
        var _type = __webpack_require__( /*! ./type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ensureDefined = function(value, defaultValue) {
            return (0, _type.isDefined)(value) ? value : defaultValue
        };
        var executeAsync = function(action, context) {
            var deferred = new _deferred.Deferred;
            var normalizedContext = context || this;
            var timerId = void 0;
            var task = {
                promise: deferred.promise(),
                abort: function() {
                    clearTimeout(timerId);
                    deferred.rejectWith(normalizedContext)
                }
            };
            var callback = function() {
                var result = action.call(normalizedContext);
                if (result && result.done && (0, _type.isFunction)(result.done)) {
                    result.done(function() {
                        deferred.resolveWith(normalizedContext)
                    })
                } else {
                    deferred.resolveWith(normalizedContext)
                }
            };
            timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName = void 0;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new _deferred.Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName;
                var currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result || (0, _deferred.when)()
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [];
            var maxMatchCount = 0;
            (0, _iterator.each)(items, function(index, itemSrc) {
                var matchCount = 0;
                var item = mapFn ? mapFn(itemSrc) : itemSrc;
                (0, _iterator.each)(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                (0, _iterator.each)(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [raw.x || raw.h, raw.y || raw.v];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var normalizeKey = function(id) {
            var key = (0, _type.isString)(id) ? id : id.toString();
            var arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && (0, _iterator.each)(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        var isArraysEqualByValue = function(array1, array2, deep) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], deep + 1)) {
                    return false
                }
            }
            return true
        };
        var isObjectsEqualByValue = function(object1, object2, deep) {
            for (var propertyName in object1) {
                if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], deep + 1)) {
                    return false
                }
            }
            for (var _propertyName in object2) {
                if (!(_propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var pairToObject = function(raw, preventRound) {
            var pair = splitPair(raw);
            var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
            var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var maxEqualityDeep = 3;
        var equalByValue = function(object1, object2, deep) {
            deep = deep || 0;
            object1 = (0, _data.toComparable)(object1, true);
            object2 = (0, _data.toComparable)(object2, true);
            if (object1 === object2 || deep >= maxEqualityDeep) {
                return true
            }
            if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                return isObjectsEqualByValue(object1, object2, deep)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return isArraysEqualByValue(object1, object2, deep)
                }
            }
            return false
        };
        var getKeyHash = function(key) {
            if (key instanceof _guid2.default) {
                return key.toString()
            } else {
                if ((0, _type.isObject)(key) || Array.isArray(key)) {
                    try {
                        var keyHash = JSON.stringify(key);
                        return "{}" === keyHash ? key : keyHash
                    } catch (e) {
                        return key
                    }
                }
            }
            return key
        };
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        var applyServerDecimalSeparator = function(value) {
            var separator = (0, _config2.default)().serverDecimalSeparator;
            if ((0, _type.isDefined)(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        var noop = function() {};
        var asyncNoop = function() {
            return (new _deferred.Deferred).resolve().promise()
        };
        var grep = function(elements, checkFunction, invert) {
            var result = [];
            var check = void 0;
            var expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        exports.ensureDefined = ensureDefined;
        exports.executeAsync = executeAsync;
        exports.deferRender = deferRender;
        exports.deferRenderer = deferRenderer;
        exports.deferUpdate = deferUpdate;
        exports.deferUpdater = deferUpdater;
        exports.pairToObject = pairToObject;
        exports.splitPair = splitPair;
        exports.findBestMatches = findBestMatches;
        exports.normalizeKey = normalizeKey;
        exports.denormalizeKey = denormalizeKey;
        exports.equalByValue = equalByValue;
        exports.getKeyHash = getKeyHash;
        exports.escapeRegExp = escapeRegExp;
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        exports.noop = noop;
        exports.asyncNoop = asyncNoop;
        exports.grep = grep
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/events/core/events_engine.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var registerEventCallbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 122);
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var injector = __webpack_require__( /*! ../../core/utils/dependency_injector */ 54);
        var typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1);
        var Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 25);
        var isWindow = typeUtils.isWindow;
        var isFunction = typeUtils.isFunction;
        var isString = typeUtils.isString;
        var errors = __webpack_require__( /*! ../../core/errors */ 21);
        var WeakMap = __webpack_require__( /*! ../../core/polyfills/weak_map */ 176);
        var hookTouchProps = __webpack_require__( /*! ../../events/core/hook_touch_props */ 252);
        var callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 63);
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focusout", "focus", "focusin", "load"];
        var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel"];
        var matchesSafe = function(target, selector) {
            return !isWindow(target) && "#document" !== target.nodeName && domAdapter.elementMatches(target, selector)
        };
        var elementDataMap = new WeakMap;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            registerEventCallbacks.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var applyForEach = function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (domAdapter.isNode(element) || isWindow(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!isString(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw errors.Error("E0025")
                }
            }
        };
        var getHandler = function(method) {
            return function() {
                applyForEach(arguments, method)
            }
        };
        var detectPassiveEventHandlersSupport = function() {
            var isSupported = false;
            try {
                var options = Object.defineProperty({}, "passive", {
                    get: function() {
                        isSupported = true;
                        return true
                    }
                });
                window.addEventListener("test", null, options)
            } catch (e) {}
            return isSupported
        };
        var passiveEventHandlersSupported = callOnce(detectPassiveEventHandlersSupport);
        var getHandlersController = function(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var secondaryTargetIsInside, result, handlerArgs = [e],
                            target = e.currentTarget,
                            relatedTarget = e.relatedTarget;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || target.contains(relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            e.currentTarget = e.delegateTarget || e.target;
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = domAdapter.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        };
        var getNativeHandler = function(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        };
        var isSubset = function(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        };
        var normalizeOnArguments = function(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        };
        var normalizeOffArguments = function(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        };
        var normalizeTriggerArguments = function(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        };
        var normalizeEventArguments = function(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        };
        var iterate = function(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === ("undefined" === typeof eventName ? "undefined" : _typeof(eventName))) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        };
        var callNativeMethod = function(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if (isFunction(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        };
        var calculateWhich = function(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        };
        var eventsEngine = injector({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers(extend(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || isWindow(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });
        var initEvent = function(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        };
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            extend(that, src);
            if (src instanceof eventsEngine.Event || windowUtils.hasWindow() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                extend(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }
            extend(that, config);
            that.guid = ++guid
        }));
        var addProperty = function(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        };
        hookTouchProps(addProperty);
        var beforeSetStrategy = Callbacks();
        var afterSetStrategy = Callbacks();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
        eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
        eventsEngine.elementDataMap = elementDataMap;
        eventsEngine.detectPassiveEventHandlersSupport = detectPassiveEventHandlersSupport;
        module.exports = eventsEngine
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/deferred.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../utils/type */ 1);
        var isPromise = typeUtils.isPromise;
        var isDeferred = typeUtils.isDeferred;
        var extend = __webpack_require__( /*! ../utils/extend */ 0).extend;
        var Callbacks = __webpack_require__( /*! ../utils/callbacks */ 25);
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _Deferred = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new Callbacks;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _Deferred;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if (isDeferred(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if (isPromise(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, callbackResult ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? extend(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _Deferred.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });
        exports.fromPromise = function(promise, context) {
            if (isDeferred(promise)) {
                return promise
            } else {
                if (isPromise(promise)) {
                    var d = new _Deferred;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _Deferred).resolveWith(context, [promise])
        };
        var when = function() {
            if (1 === arguments.length) {
                return exports.fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments),
                contexts = [],
                resolvedCount = 0,
                deferred = new _Deferred;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if (isDeferred(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };
        exports.setStrategy = function(value) {
            _Deferred = value.Deferred;
            when = value.when
        };
        exports.Deferred = function() {
            return new _Deferred
        };
        exports.when = function() {
            return when.apply(this, arguments)
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/window.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 11);
        var _hasWindow = "undefined" !== typeof window;
        var windowObject = _hasWindow && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        module.exports = {
            hasWindow: function() {
                return _hasWindow
            },
            getWindow: function() {
                return windowObject
            },
            hasProperty: function(prop) {
                return this.hasWindow() && prop in windowObject
            },
            defaultScreenFactorFunc: function(width) {
                if (width < 768) {
                    return "xs"
                } else {
                    if (width < 992) {
                        return "sm"
                    } else {
                        if (width < 1200) {
                            return "md"
                        } else {
                            return "lg"
                        }
                    }
                }
            },
            getCurrentScreenFactor: function(screenFactorCallback) {
                var screenFactorFunc = screenFactorCallback || this.defaultScreenFactorFunc;
                var windowWidth = domAdapter.getDocumentElement().clientWidth;
                return screenFactorFunc(windowWidth)
            },
            getNavigator: function() {
                return this.hasWindow() ? windowObject.navigator : {
                    userAgent: ""
                }
            }
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var callbacks = __webpack_require__( /*! ./component_registrator_callbacks */ 153);
        var errors = __webpack_require__( /*! ./errors */ 21);
        var publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 131);
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }
            publicComponentUtils.name(componentClass, name);
            callbacks.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            $.fn[name] = function(options) {
                var result, isMemberInvoke = "string" === typeof options;
                if (isMemberInvoke) {
                    var memberName = options,
                        memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw errors.Error("E0009", name)
                        }
                        var member = instance[memberName],
                            memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        callbacks.add(registerRendererComponent);
        module.exports = registerComponent
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/utils.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ./core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _errors = __webpack_require__( /*! ../core/errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _selectors = __webpack_require__( /*! ../ui/widget/selectors */ 66);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var KEY_MAP = {
            backspace: "backspace",
            tab: "tab",
            enter: "enter",
            escape: "escape",
            pageup: "pageUp",
            pagedown: "pageDown",
            end: "end",
            home: "home",
            arrowleft: "leftArrow",
            arrowup: "upArrow",
            arrowright: "rightArrow",
            arrowdown: "downArrow",
            "delete": "del",
            " ": "space",
            f: "F",
            a: "A",
            "*": "asterisk",
            "-": "minus",
            alt: "alt",
            control: "control",
            shift: "shift",
            left: "leftArrow",
            up: "upArrow",
            right: "rightArrow",
            down: "downArrow",
            multiply: "asterisk",
            spacebar: "space",
            del: "del",
            subtract: "minus"
        };
        var LEGACY_KEY_CODES = {
            8: "backspace",
            9: "tab",
            13: "enter",
            27: "escape",
            33: "pageUp",
            34: "pageDown",
            35: "end",
            36: "home",
            37: "leftArrow",
            38: "upArrow",
            39: "rightArrow",
            40: "downArrow",
            46: "del",
            32: "space",
            70: "F",
            65: "A",
            106: "asterisk",
            109: "minus",
            189: "minus",
            173: "minus",
            16: "shift",
            17: "control",
            18: "alt"
        };
        var eventSource = function() {
            var EVENT_SOURCES_REGEX = {
                dx: /^dx/i,
                mouse: /(mouse|wheel)/i,
                touch: /^touch/i,
                keyboard: /^key/i,
                pointer: /^(ms)?pointer/i
            };
            return function(e) {
                var result = "other";
                (0, _iterator.each)(EVENT_SOURCES_REGEX, function(key) {
                    if (this.test(e.type)) {
                        result = key;
                        return false
                    }
                });
                return result
            }
        }();
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        var isDxMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        var isFakeClickEvent = function(e) {
            return 0 === e.screenX && !e.offsetX && 0 === e.pageX
        };
        var eventData = function(e) {
            return {
                x: e.pageX,
                y: e.pageY,
                time: e.timeStamp
            }
        };
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        var hasTouches = function(e) {
            if (isNativeTouchEvent(e)) {
                return (e.originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (e.pointers || []).length
            }
            return 0
        };
        var needSkipEvent = function(e) {
            var target = e.target;
            var $target = (0, _renderer2.default)(target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if (isDxMouseWheelEvent(e)) {
                if ($target.is("textarea") && $target.hasClass("dx-texteditor-input")) {
                    return false
                }
                var isContentEditable = target.isContentEditable || target.hasAttribute("contenteditable");
                var hasContentEditableParent = $target.closest("div[contenteditable='true']").is(":focus");
                var isInputFocused = $target.is("input[type='number'], textarea, select") && $target.is(":focus");
                return isInputFocused || isContentEditable && hasContentEditableParent
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && (0, _selectors.focused)($target)
            }
        };
        var fixMethod = function(e) {
            return e
        };
        var setEventFixMethod = function(func) {
            fixMethod = func
        };
        var copyEvent = function(originalEvent) {
            return fixMethod(_events_engine2.default.Event(originalEvent, originalEvent), originalEvent)
        };
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            if (args) {
                (0, _extend.extend)(event, args)
            }
            return event
        };
        var fireEvent = function(props) {
            var event = createEvent(props.originalEvent, props);
            _events_engine2.default.trigger(props.delegateTarget || event.target, event);
            return event
        };
        var addNamespace = function addNamespace(eventNames, namespace) {
            if (!namespace) {
                throw _errors2.default.Error("E0017")
            }
            if ("string" === typeof eventNames) {
                if (eventNames.indexOf(" ") === -1) {
                    return eventNames + "." + namespace
                }
                return addNamespace(eventNames.split(/\s+/g), namespace)
            }(0, _iterator.each)(eventNames, function(index, eventName) {
                eventNames[index] = eventName + "." + namespace
            });
            return eventNames.join(" ")
        };
        var normalizeKeyName = function(event) {
            var isKeySupported = !!event.key;
            var key = isKeySupported ? event.key : event.which;
            if (!key) {
                return
            }
            if (isKeySupported) {
                key = KEY_MAP[key.toLowerCase()] || key
            } else {
                key = LEGACY_KEY_CODES[key] || String.fromCharCode(key)
            }
            return key
        };
        var getChar = function(event) {
            return event.key || String.fromCharCode(event.which)
        };
        module.exports = {
            eventSource: eventSource,
            isPointerEvent: isPointerEvent,
            isMouseEvent: isMouseEvent,
            isDxMouseWheelEvent: isDxMouseWheelEvent,
            isTouchEvent: isTouchEvent,
            isKeyboardEvent: isKeyboardEvent,
            isFakeClickEvent: isFakeClickEvent,
            hasTouches: hasTouches,
            eventData: eventData,
            eventDelta: eventDelta,
            needSkipEvent: needSkipEvent,
            createEvent: createEvent,
            fireEvent: fireEvent,
            addNamespace: addNamespace,
            setEventFixMethod: setEventFixMethod,
            normalizeKeyName: normalizeKeyName,
            getChar: getChar
        }
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/viz/core/utils.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            adjust = __webpack_require__( /*! ../../core/utils/math */ 28).adjust,
            dateToMilliseconds = __webpack_require__( /*! ../../core/utils/date */ 22).dateToMilliseconds,
            isDefined = typeUtils.isDefined,
            isNumber = typeUtils.isNumeric,
            isExponential = typeUtils.isExponential,
            _math = Math,
            _round = _math.round,
            _sqrt = Math.sqrt;
        var PI = Math.PI,
            MAX_PIXEL_COUNT = 1e10,
            PI_DIV_180 = PI / 180,
            LN10 = Math.LN10;
        var cosFunc = Math.cos,
            sinFunc = Math.sin,
            abs = Math.abs,
            log = Math.log,
            floor = Math.floor,
            ceil = Math.ceil,
            max = Math.max,
            _isNaN = isNaN,
            _Number = Number,
            _NaN = NaN;
        var getLog = function(value, base) {
            if (!value) {
                return _NaN
            }
            return Math.log(value) / Math.log(base)
        };
        var getAdjustedLog10 = function(value) {
            return adjust(getLog(value, 10))
        };
        var raiseTo = function(power, base) {
            return Math.pow(base, power)
        };
        var normalizeAngle = function(angle) {
            return (angle % 360 + 360) % 360
        };
        var convertAngleToRendererSpace = function(angle) {
            return 90 - angle
        };
        var degreesToRadians = function(value) {
            return PI * value / 180
        };
        var getCosAndSin = function(angle) {
            var angleInRadians = degreesToRadians(angle);
            return {
                cos: cosFunc(angleInRadians),
                sin: sinFunc(angleInRadians)
            }
        };
        var DECIMAL_ORDER_THRESHOLD = 1e-14;
        var getDistance = function(x1, y1, x2, y2) {
            var diffX = x2 - x1,
                diffY = y2 - y1;
            return Math.sqrt(diffY * diffY + diffX * diffX)
        };
        var getDecimalOrder = function(number) {
            var cn, n = abs(number);
            if (!_isNaN(n)) {
                if (n > 0) {
                    n = log(n) / LN10;
                    cn = ceil(n);
                    return cn - n < DECIMAL_ORDER_THRESHOLD ? cn : floor(n)
                }
                return 0
            }
            return _NaN
        };
        var getAppropriateFormat = function(start, end, count) {
            var format, order = max(getDecimalOrder(start), getDecimalOrder(end)),
                precision = -getDecimalOrder(abs(end - start) / count);
            if (!_isNaN(order) && !_isNaN(precision)) {
                if (abs(order) <= 4) {
                    format = "fixedPoint";
                    precision < 0 && (precision = 0);
                    precision > 4 && (precision = 4)
                } else {
                    format = "exponential";
                    precision += order - 1;
                    precision > 3 && (precision = 3)
                }
                return {
                    type: format,
                    precision: precision
                }
            }
            return null
        };
        var roundValue = function(value, precision) {
            if (precision > 20) {
                precision = 20
            }
            if (isNumber(value)) {
                if (isExponential(value)) {
                    return _Number(value.toExponential(precision))
                } else {
                    return _Number(value.toFixed(precision))
                }
            }
        };
        var getPower = function(value) {
            return value.toExponential().split("e")[1]
        };

        function map(array, callback) {
            var value, i = 0,
                len = array.length,
                result = [];
            while (i < len) {
                value = callback(array[i], i);
                if (null !== value) {
                    result.push(value)
                }
                i++
            }
            return result
        }

        function selectByKeys(object, keys) {
            return map(keys, function(key) {
                return object[key] ? object[key] : null
            })
        }

        function decreaseFields(object, keys, eachDecrease, decrease) {
            var dec = decrease;
            each(keys, function(_, key) {
                if (object[key]) {
                    object[key] -= eachDecrease;
                    dec -= eachDecrease
                }
            });
            return dec
        }

        function normalizeEnum(value) {
            return String(value).toLowerCase()
        }

        function setCanvasValues(canvas) {
            if (canvas) {
                canvas.originalTop = canvas.top;
                canvas.originalBottom = canvas.bottom;
                canvas.originalLeft = canvas.left;
                canvas.originalRight = canvas.right
            }
            return canvas
        }

        function normalizeBBoxField(value) {
            return -MAX_PIXEL_COUNT < value && value < +MAX_PIXEL_COUNT ? value : 0
        }

        function normalizeBBox(bBox) {
            var xl = normalizeBBoxField(floor(bBox.x)),
                yt = normalizeBBoxField(floor(bBox.y)),
                xr = normalizeBBoxField(ceil(bBox.width + bBox.x)),
                yb = normalizeBBoxField(ceil(bBox.height + bBox.y)),
                result = {
                    x: xl,
                    y: yt,
                    width: xr - xl,
                    height: yb - yt
                };
            result.isEmpty = !result.x && !result.y && !result.width && !result.height;
            return result
        }

        function rotateBBox(bBox, center, angle) {
            var cos = _Number(cosFunc(angle * PI_DIV_180).toFixed(3)),
                sin = _Number(sinFunc(angle * PI_DIV_180).toFixed(3)),
                w2 = bBox.width / 2,
                h2 = bBox.height / 2,
                centerX = bBox.x + w2,
                centerY = bBox.y + h2,
                w2_ = abs(w2 * cos) + abs(h2 * sin),
                h2_ = abs(w2 * sin) + abs(h2 * cos),
                centerX_ = center[0] + (centerX - center[0]) * cos + (centerY - center[1]) * sin,
                centerY_ = center[1] - (centerX - center[0]) * sin + (centerY - center[1]) * cos;
            return normalizeBBox({
                x: centerX_ - w2_,
                y: centerY_ - h2_,
                width: 2 * w2_,
                height: 2 * h2_
            })
        }
        extend(exports, {
            decreaseGaps: function(object, keys, decrease) {
                var arrayGaps;
                do {
                    arrayGaps = selectByKeys(object, keys);
                    arrayGaps.push(_math.ceil(decrease / arrayGaps.length));
                    decrease = decreaseFields(object, keys, _math.min.apply(null, arrayGaps), decrease)
                } while (decrease > 0 && arrayGaps.length > 1);
                return decrease
            },
            normalizeEnum: normalizeEnum,
            parseScalar: function(value, defaultValue) {
                return void 0 !== value ? value : defaultValue
            },
            enumParser: function(values) {
                var i, ii, stored = {};
                for (i = 0, ii = values.length; i < ii; ++i) {
                    stored[normalizeEnum(values[i])] = 1
                }
                return function(value, defaultValue) {
                    var _value = normalizeEnum(value);
                    return stored[_value] ? _value : defaultValue
                }
            },
            patchFontOptions: function(options) {
                var fontOptions = {};
                each(options || {}, function(key, value) {
                    if (/^(cursor|opacity)$/i.test(key)) {} else {
                        if ("color" === key) {
                            key = "fill"
                        } else {
                            key = "font-" + key
                        }
                    }
                    fontOptions[key] = value
                });
                return fontOptions
            },
            convertPolarToXY: function(centerCoords, startAngle, angle, radius) {
                var cosSin, shiftAngle = 90;
                angle = isDefined(angle) ? angle + startAngle - shiftAngle : 0;
                cosSin = getCosAndSin(angle);
                return {
                    x: _round(centerCoords.x + radius * cosSin.cos),
                    y: _round(centerCoords.y + radius * cosSin.sin)
                }
            },
            convertXYToPolar: function(centerCoords, x, y) {
                var radius = getDistance(centerCoords.x, centerCoords.y, x, y),
                    angle = _math.atan2(y - centerCoords.y, x - centerCoords.x);
                return {
                    phi: _round(normalizeAngle(180 * angle / _math.PI)),
                    r: _round(radius)
                }
            },
            processSeriesTemplate: function(seriesTemplate, items) {
                var series, length, data, customizeSeries = typeUtils.isFunction(seriesTemplate.customizeSeries) ? seriesTemplate.customizeSeries : noop,
                    nameField = seriesTemplate.nameField,
                    generatedSeries = {},
                    seriesOrder = [],
                    i = 0;
                items = items || [];
                for (length = items.length; i < length; i++) {
                    data = items[i];
                    if (nameField in data) {
                        series = generatedSeries[data[nameField]];
                        if (!series) {
                            series = generatedSeries[data[nameField]] = {
                                name: data[nameField],
                                nameFieldValue: data[nameField]
                            };
                            seriesOrder.push(series.name)
                        }
                    }
                }
                return map(seriesOrder, function(orderedName) {
                    var group = generatedSeries[orderedName];
                    return extend(group, customizeSeries.call(null, group.name))
                })
            },
            getCategoriesInfo: function(categories, startValue, endValue) {
                if (0 === categories.length) {
                    return {
                        categories: []
                    }
                }
                startValue = isDefined(startValue) ? startValue : categories[0];
                endValue = isDefined(endValue) ? endValue : categories[categories.length - 1];
                var visibleCategories, swapBuf, lastIdx, categoriesValue = map(categories, function(category) {
                        return isDefined(category) ? category.valueOf() : null
                    }),
                    indexStartValue = categoriesValue.indexOf(startValue.valueOf()),
                    indexEndValue = categoriesValue.indexOf(endValue.valueOf()),
                    inverted = false;
                indexStartValue < 0 && (indexStartValue = 0);
                indexEndValue < 0 && (indexEndValue = categories.length - 1);
                if (indexEndValue < indexStartValue) {
                    swapBuf = indexEndValue;
                    indexEndValue = indexStartValue;
                    indexStartValue = swapBuf;
                    inverted = true
                }
                visibleCategories = categories.slice(indexStartValue, indexEndValue + 1);
                lastIdx = visibleCategories.length - 1;
                return {
                    categories: visibleCategories,
                    start: visibleCategories[inverted ? lastIdx : 0],
                    end: visibleCategories[inverted ? 0 : lastIdx],
                    inverted: inverted
                }
            },
            setCanvasValues: setCanvasValues,
            updatePanesCanvases: function(panes, canvas, rotated) {
                var weightSum = 0;
                each(panes, function(_, pane) {
                    pane.weight = pane.weight || 1;
                    weightSum += pane.weight
                });
                var distributedSpace = 0,
                    padding = panes.padding || 10,
                    paneSpace = rotated ? canvas.width - canvas.left - canvas.right : canvas.height - canvas.top - canvas.bottom,
                    oneWeight = (paneSpace - padding * (panes.length - 1)) / weightSum,
                    startName = rotated ? "left" : "top",
                    endName = rotated ? "right" : "bottom";
                each(panes, function(_, pane) {
                    var calcLength = _round(pane.weight * oneWeight);
                    pane.canvas = pane.canvas || {};
                    extend(pane.canvas, canvas);
                    pane.canvas[startName] = canvas[startName] + distributedSpace;
                    pane.canvas[endName] = canvas[endName] + (paneSpace - calcLength - distributedSpace);
                    distributedSpace = distributedSpace + calcLength + padding;
                    setCanvasValues(pane.canvas)
                })
            },
            unique: function(array) {
                var values = {};
                return map(array, function(item) {
                    var result = !values[item] ? item : null;
                    values[item] = true;
                    return result
                })
            },
            map: map,
            getVerticallyShiftedAngularCoords: function(bBox, dy, center) {
                var isPositive = bBox.x + bBox.width / 2 >= center.x,
                    horizontalOffset1 = (isPositive ? bBox.x : bBox.x + bBox.width) - center.x,
                    verticalOffset1 = bBox.y - center.y,
                    verticalOffset2 = verticalOffset1 + dy,
                    horizontalOffset2 = _round(_sqrt(horizontalOffset1 * horizontalOffset1 + verticalOffset1 * verticalOffset1 - verticalOffset2 * verticalOffset2)),
                    dx = (isPositive ? +horizontalOffset2 : -horizontalOffset2) || horizontalOffset1;
                return {
                    x: center.x + (isPositive ? dx : dx - bBox.width),
                    y: bBox.y + dy
                }
            },
            mergeMarginOptions: function(opt1, opt2) {
                return {
                    checkInterval: opt1.checkInterval || opt2.checkInterval,
                    size: Math.max(opt1.size || 0, opt2.size || 0),
                    percentStick: opt1.percentStick || opt2.percentStick,
                    sizePointNormalState: Math.max(opt1.sizePointNormalState || 0, opt2.sizePointNormalState || 0)
                }
            }
        });

        function getVizRangeObject(value) {
            if (Array.isArray(value)) {
                return {
                    startValue: value[0],
                    endValue: value[1]
                }
            } else {
                return value || {}
            }
        }

        function convertVisualRangeObject(visualRange, convertToVisualRange) {
            if (convertToVisualRange) {
                return visualRange
            }
            return [visualRange.startValue, visualRange.endValue]
        }

        function getAddFunction(range, correctZeroLevel) {
            if ("datetime" === range.dataType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    return new Date(rangeValue.getTime() + sign * marginValue)
                }
            }
            if ("logarithmic" === range.axisType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    var log = getLog(rangeValue, range.base) + sign * marginValue;
                    return raiseTo(log, range.base)
                }
            }
            return function(rangeValue, marginValue) {
                var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                var newValue = rangeValue + sign * marginValue;
                return correctZeroLevel && newValue * rangeValue <= 0 ? 0 : newValue
            }
        }

        function adjustVisualRange(options, visualRange, wholeRange, dataRange) {
            var minDefined = typeUtils.isDefined(visualRange.startValue);
            var maxDefined = typeUtils.isDefined(visualRange.endValue);
            var nonDiscrete = "discrete" !== options.axisType;
            dataRange = dataRange || wholeRange;
            var add = getAddFunction(options, false);
            var min = minDefined ? visualRange.startValue : dataRange.min;
            var max = maxDefined ? visualRange.endValue : dataRange.max;
            var rangeLength = visualRange.length;
            var categories = dataRange.categories;
            if (nonDiscrete && !typeUtils.isDefined(min) && !typeUtils.isDefined(max)) {
                return {
                    startValue: min,
                    endValue: max
                }
            }
            if (isDefined(rangeLength)) {
                if (nonDiscrete) {
                    if ("datetime" === options.dataType && !isNumber(rangeLength)) {
                        rangeLength = dateToMilliseconds(rangeLength)
                    }
                    if (maxDefined && !minDefined || !maxDefined && !minDefined) {
                        isDefined(wholeRange.max) && (max = max > wholeRange.max ? wholeRange.max : max);
                        min = add(max, rangeLength, -1)
                    } else {
                        if (minDefined && !maxDefined) {
                            isDefined(wholeRange.min) && (min = min < wholeRange.min ? wholeRange.min : min);
                            max = add(min, rangeLength)
                        }
                    }
                } else {
                    rangeLength = parseInt(rangeLength);
                    if (!isNaN(rangeLength) && isFinite(rangeLength)) {
                        rangeLength--;
                        if (!maxDefined && !minDefined) {
                            max = categories[categories.length - 1];
                            min = categories[categories.length - 1 - rangeLength]
                        } else {
                            if (minDefined && !maxDefined) {
                                var categoriesInfo = exports.getCategoriesInfo(categories, min, void 0);
                                max = categoriesInfo.categories[rangeLength]
                            } else {
                                if (!minDefined && maxDefined) {
                                    var _categoriesInfo = exports.getCategoriesInfo(categories, void 0, max);
                                    min = _categoriesInfo.categories[_categoriesInfo.categories.length - 1 - rangeLength]
                                }
                            }
                        }
                    }
                }
            }
            if (nonDiscrete) {
                if (isDefined(wholeRange.max) && max > wholeRange.max) {
                    max = wholeRange.max
                }
                if (isDefined(wholeRange.min) && min < wholeRange.min) {
                    min = wholeRange.min
                }
            }
            return {
                startValue: min,
                endValue: max
            }
        }
        exports.getVizRangeObject = getVizRangeObject;
        exports.convertVisualRangeObject = convertVisualRangeObject;
        exports.adjustVisualRange = adjustVisualRange;
        exports.getAddFunction = getAddFunction;
        exports.getLog = getLog;
        exports.getAdjustedLog10 = getAdjustedLog10;
        exports.raiseTo = raiseTo;
        exports.normalizeAngle = normalizeAngle;
        exports.convertAngleToRendererSpace = convertAngleToRendererSpace;
        exports.degreesToRadians = degreesToRadians;
        exports.getCosAndSin = getCosAndSin;
        exports.getDecimalOrder = getDecimalOrder;
        exports.getAppropriateFormat = getAppropriateFormat;
        exports.getDistance = getDistance;
        exports.roundValue = roundValue;
        exports.getPower = getPower;
        exports.rotateBBox = rotateBBox;
        exports.normalizeBBox = normalizeBBox
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/dom_adapter.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var injector = __webpack_require__( /*! ./utils/dependency_injector */ 54);
        var noop = __webpack_require__( /*! ./utils/common */ 4).noop;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                }.bind(this);
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === ("undefined" === typeof element ? "undefined" : _typeof(element)) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === Node.ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === Node.TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === Node.DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            getAttribute: function(element, name) {
                return element.getAttribute(name)
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNameSupported = "string" === typeof element.className;
                        var elementClass = classNameSupported ? element.className : this.getAttribute(element, "class") || "";
                        var classNames = elementClass.split(" ");
                        var classIndex = classNames.indexOf(className);
                        var resultClassName;
                        if (isAdd && classIndex < 0) {
                            resultClassName = elementClass ? elementClass + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            resultClassName = classNames.join(" ")
                        }
                        if (void 0 !== resultClassName) {
                            if (classNameSupported) {
                                element.className = resultClassName
                            } else {
                                this.setAttribute(element, "class", resultClassName)
                            }
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        module.exports = injector(nativeDOMAdapterStrategy)
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dom.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var elementStrategy, $ = __webpack_require__( /*! ../../core/renderer */ 2),
            config = __webpack_require__( /*! ../../core/config */ 31),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            windowUtils = __webpack_require__( /*! ./window */ 7),
            window = windowUtils.getWindow(),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            inArray = __webpack_require__( /*! ./array */ 13).inArray,
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isDefined = typeUtils.isDefined,
            isRenderer = typeUtils.isRenderer,
            htmlParser = __webpack_require__( /*! ../../core/utils/html_parser */ 253);
        var resetActiveElement = function() {
            var activeElement = domAdapter.getActiveElement(),
                body = domAdapter.getBody();
            if (activeElement && activeElement !== body && activeElement.blur) {
                try {
                    activeElement.blur()
                } catch (e) {
                    body.blur()
                }
            }
        };
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = $(startTarget),
                $endTarget = $(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents(),
                $endParents = $endTarget.parents(),
                startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = $(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    eventsEngine.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var uniqueId = function() {
            var counter = 0;
            return function(prefix) {
                return (prefix || "") + counter++
            }
        }();
        var dataOptionsAttributeName = "data-options";
        var getElementOptions = function(element) {
            var optionsString = $(element).attr(dataOptionsAttributeName) || "";
            return config().optionsParser(optionsString)
        };
        var createComponents = function(elements, componentTypes) {
            var result = [],
                selector = "[" + dataOptionsAttributeName + "]";
            var $items = elements.find(selector).add(elements.filter(selector));
            $items.each(function(index, element) {
                var $element = $(element),
                    options = getElementOptions(element);
                for (var componentName in options) {
                    if (!componentTypes || inArray(componentName, componentTypes) > -1) {
                        if ($element[componentName]) {
                            $element[componentName](options[componentName]);
                            result.push($element[componentName]("instance"))
                        }
                    }
                }
            });
            return result
        };
        var createMarkupFromString = function(str) {
            if (!window.WinJS) {
                return $(htmlParser.parseHTML(str))
            }
            var tempElement = $("<div>");
            window.WinJS.Utilities.setInnerHTMLUnsafe(tempElement.get(0), str);
            return tempElement.contents()
        };
        var extractTemplateMarkup = function(element) {
            element = $(element);
            var templateTag = element.length && element.filter(function() {
                var $node = $(this);
                return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
            });
            if (templateTag.length) {
                return templateTag.eq(0).html()
            } else {
                element = $("<div>").append(element);
                return element.html()
            }
        };
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = isDefined(element) && (element.nodeType || isRenderer(element)) ? $(element) : $("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        var contains = function(container, element) {
            if (!element) {
                return false
            }
            element = domAdapter.isTextNode(element) ? element.parentNode : element;
            return domAdapter.isDocument(container) ? container.documentElement.contains(element) : container.contains(element)
        };
        var getPublicElement = function($element) {
            return elementStrategy($element)
        };
        var setPublicElementWrapper = function(value) {
            elementStrategy = value
        };
        setPublicElementWrapper(function(element) {
            return element && element.get(0)
        });
        var createTextElementHiddenCopy = function(element, text, options) {
            var elementStyles = window.getComputedStyle($(element).get(0));
            var includePaddings = options && options.includePaddings;
            return $("<div>").text(text).css({
                fontStyle: elementStyles.fontStyle,
                fontVariant: elementStyles.fontVariant,
                fontWeight: elementStyles.fontWeight,
                fontSize: elementStyles.fontSize,
                fontFamily: elementStyles.fontFamily,
                letterSpacing: elementStyles.letterSpacing,
                border: elementStyles.border,
                paddingTop: includePaddings ? elementStyles.paddingTop : "",
                paddingRight: includePaddings ? elementStyles.paddingRight : "",
                paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                visibility: "hidden",
                whiteSpace: "nowrap",
                position: "absolute",
                "float": "left"
            })
        };
        exports.setPublicElementWrapper = setPublicElementWrapper;
        exports.resetActiveElement = resetActiveElement;
        exports.createMarkupFromString = createMarkupFromString;
        exports.triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.getElementOptions = getElementOptions;
        exports.createComponents = createComponents;
        exports.extractTemplateMarkup = extractTemplateMarkup;
        exports.normalizeTemplateElement = normalizeTemplateElement;
        exports.clearSelection = clearSelection;
        exports.uniqueId = uniqueId;
        exports.closestCommonParent = closestCommonParent;
        exports.clipboardText = clipboardText;
        exports.contains = contains;
        exports.getPublicElement = getPublicElement;
        exports.createTextElementHiddenCopy = createTextElementHiddenCopy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/array.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            objectUtils = __webpack_require__( /*! ./object */ 47),
            config = __webpack_require__( /*! ../config */ 31);
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            each(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            each(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {},
                parameterIndex = 0,
                useLegacyVisibleIndex = config().useLegacyVisibleIndex;
            each(items, function(index, item) {
                index = item[indexParameterName];
                if (index >= 0) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                } else {
                    item[indexParameterName] = void 0
                }
            });
            if (!useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        while (indexedItems[parameterIndex]) {
                            parameterIndex++
                        }
                        indexedItems[parameterIndex] = [this];
                        parameterIndex++
                    }
                })
            }
            parameterIndex = 0;
            objectUtils.orderEach(indexedItems, function(index, items) {
                each(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            if (useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            }
            return parameterIndex
        };
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        var find = function(array, condition) {
            for (var i = 0; i < array.length; i++) {
                if (condition(array[i])) {
                    return array[i]
                }
            }
        };
        exports.isEmpty = isEmpty;
        exports.wrapToArray = wrapToArray;
        exports.intersection = intersection;
        exports.removeDuplicates = removeDuplicates;
        exports.normalizeIndexes = normalizeIndexes;
        exports.inArray = inArray;
        exports.merge = merge;
        exports.find = find
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/localization/message.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 54),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            stringFormat = __webpack_require__( /*! ../core/utils/string */ 46).format,
            humanize = __webpack_require__( /*! ../core/utils/inflector */ 32).humanize,
            coreLocalization = __webpack_require__( /*! ./core */ 87);
        __webpack_require__( /*! ./core */ 87);
        var PARENT_LOCALE_SEPARATOR = "-";
        var baseDictionary = extend(true, {}, __webpack_require__( /*! ./default_messages */ 446));
        var parentLocales = __webpack_require__( /*! ./cldr-data/parentLocales */ 447);
        var getParentLocale = function(locale) {
            var parentLocale = parentLocales[locale];
            if (parentLocale) {
                return "root" !== parentLocale && parentLocale
            }
            return locale.substr(0, locale.lastIndexOf(PARENT_LOCALE_SEPARATOR))
        };
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var getValueByClosestLocale = function(localeData, locale, key) {
            var isRootLocale, value = getDataByLocale(localeData, locale)[key];
            while (!value && !isRootLocale) {
                locale = getParentLocale(locale);
                if (locale) {
                    value = getDataByLocale(localeData, locale)[key]
                } else {
                    isRootLocale = true
                }
            }
            return value
        };
        var newMessages = {};
        var messageLocalization = dependencyInjector({
            _dictionary: baseDictionary,
            load: function(messages) {
                extend(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this,
                    regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g"),
                    escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var result, defaultResult = that._localizablePrefix + localizationKey;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = humanize(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            _messageLoaded: function(key, locale) {
                return void 0 !== getValueByClosestLocale(this._dictionary, locale || coreLocalization.locale(), key)
            },
            localizeNode: function(node) {
                var that = this;
                $(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!$(nodeItem).is("iframe")) {
                            each(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            $(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return extend({}, newMessages, this.getMessagesByLocales()[coreLocalization.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var message = getValueByClosestLocale(this._dictionary, locale || coreLocalization.locale(), key);
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return stringFormat.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        module.exports = messageLocalization
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/core/class.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ./errors */ 21),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1);
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var overridden, memberName, member, that = this;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var argument, name, i, classObj = this;
            var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
            var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
            if (isES6Class) {
                classObj._includedCtors = classObj._includedCtors.slice(0);
                classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
            }
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    if (name in classObj.prototype) {
                        throw errors.Error("E0002", name)
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            if (this.parent === parentClass) {
                return true
            }
            if (!this.parent || !this.parent.subclassOf) {
                return false
            }
            return this.parent.subclassOf(parentClass)
        };
        var abstract = function() {
            throw errors.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || typeUtils.isWindow(this) || "function" !== typeof this.constructor) {
                    throw errors.Error("E0003")
                }
                var i, instance = this,
                    ctor = instance.ctor,
                    includedCtors = instance.constructor._includedCtors,
                    includedPostCtors = instance.constructor._includedPostCtors;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        module.exports = classImpl
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/devices.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ./utils/window */ 7),
            navigator = windowUtils.getNavigator(),
            window = windowUtils.getWindow(),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject,
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 15),
            errors = __webpack_require__( /*! ./errors */ 21),
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 25),
            resizeCallbacks = __webpack_require__( /*! ./utils/resize_callbacks */ 130),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 81),
            SessionStorage = __webpack_require__( /*! ./utils/storage */ 279).sessionStorage,
            viewPort = __webpack_require__( /*! ./utils/view_port */ 76),
            Config = __webpack_require__( /*! ./config */ 31);
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            win8: "MSAppHost",
            win8Phone: "Windows Phone 8.0",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop",
            win10Phone: "Windows Phone 10.0",
            win10: "MSAppHost/3.0"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            win: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            win: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/),
                    isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent),
                    isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                if (!(isPhone || isTablet || isDesktop)) {
                    return
                }
                var matches = userAgent.match(/windows phone (\d+).(\d+)/i) || userAgent.match(/windows nt (\d+).(\d+)/i),
                    version = [];
                if (matches) {
                    version.push(parseInt(matches[1], 10), parseInt(matches[2], 10))
                } else {
                    matches = userAgent.match(/msapphost(\/(\d+).(\d+))?/i);
                    matches && version.push(3 === parseInt(matches[2], 10) ? 10 : 8)
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "win",
                    version: version,
                    grade: "A"
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent),
                    matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    isIPhone4 = 480 === window.screen.height,
                    grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent),
                    matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [],
                    worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4),
                    grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = Class.inherit({
            ctor: function(options) {
                this._window = options && options.window || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this.changed = Callbacks();
                if (windowUtils.hasWindow()) {
                    this._recalculateOrientation();
                    resizeCallbacks.add(this._recalculateOrientation.bind(this))
                }
            },
            current: function(deviceOrName) {
                if (deviceOrName) {
                    this._currentDevice = this._getDevice(deviceOrName);
                    this._forced = true;
                    this.changed.fire();
                    return
                }
                if (!this._currentDevice) {
                    deviceOrName = void 0;
                    try {
                        deviceOrName = this._getDeviceOrNameFromWindowScope()
                    } catch (e) {
                        deviceOrName = this._getDeviceNameFromSessionStorage()
                    } finally {
                        if (!deviceOrName) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        }
                        if (deviceOrName) {
                            this._forced = true
                        }
                    }
                    this._currentDevice = this._getDevice(deviceOrName)
                }
                return this._currentDevice
            },
            real: function() {
                var forceDevice = arguments[0];
                if (isPlainObject(forceDevice)) {
                    extend(this._realDevice, forceDevice);
                    return
                }
                return extend({}, this._realDevice)
            },
            orientation: function() {
                return this._currentOrientation
            },
            isForced: function() {
                return this._forced
            },
            isRippleEmulator: function() {
                return !!this._window.tinyHippos
            },
            _getCssClasses: function(device) {
                var result = [];
                var realDevice = this._realDevice;
                device = device || this.current();
                if (device.deviceType) {
                    result.push("dx-device-" + device.deviceType);
                    if ("desktop" !== device.deviceType) {
                        result.push("dx-device-mobile")
                    }
                }
                result.push("dx-device-" + realDevice.platform);
                if (realDevice.version && realDevice.version.length) {
                    result.push("dx-device-" + realDevice.platform + "-" + realDevice.version[0])
                }
                if (devices.isSimulator()) {
                    result.push("dx-simulator")
                }
                if (Config().rtlEnabled) {
                    result.push("dx-rtl")
                }
                return result
            },
            attachCssClasses: function(element, device) {
                this._deviceClasses = this._getCssClasses(device).join(" ");
                $(element).addClass(this._deviceClasses)
            },
            detachCssClasses: function(element) {
                $(element).removeClass(this._deviceClasses)
            },
            isSimulator: function() {
                try {
                    return this._isSimulator || windowUtils.hasWindow() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                } catch (e) {
                    return false
                }
            },
            forceSimulator: function() {
                this._isSimulator = true
            },
            _getDevice: function(deviceName) {
                if ("genericPhone" === deviceName) {
                    deviceName = {
                        deviceType: "phone",
                        platform: "generic",
                        generic: true
                    }
                }
                if (isPlainObject(deviceName)) {
                    return this._fromConfig(deviceName)
                } else {
                    var ua;
                    if (deviceName) {
                        ua = KNOWN_UA_TABLE[deviceName];
                        if (!ua) {
                            throw errors.Error("E0005")
                        }
                    } else {
                        ua = navigator.userAgent
                    }
                    return this._fromUA(ua)
                }
            },
            _getDeviceOrNameFromWindowScope: function() {
                var result;
                if (windowUtils.hasWindow() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                    result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                }
                return result
            },
            _getDeviceNameFromSessionStorage: function() {
                var sessionStorage = SessionStorage();
                if (!sessionStorage) {
                    return
                }
                var deviceOrName = sessionStorage.getItem("dx-force-device");
                try {
                    return JSON.parse(deviceOrName)
                } catch (ex) {
                    return deviceOrName
                }
            },
            _fromConfig: function(config) {
                var result = extend({}, DEFAULT_DEVICE, this._currentDevice, config),
                    shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        win: "win" === result.platform,
                        generic: "generic" === result.platform
                    };
                return extend(result, shortcuts)
            },
            _fromUA: function(ua) {
                var config;
                each(uaParsers, function(platform, parser) {
                    config = parser(ua);
                    return !config
                });
                if (config) {
                    return this._fromConfig(config)
                }
                var isMac = /(mac os)/.test(ua.toLowerCase()),
                    deviceWithOS = DEFAULT_DEVICE;
                deviceWithOS.mac = isMac;
                return deviceWithOS
            },
            _changeOrientation: function() {
                var $window = $(this._window),
                    orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                if (this._currentOrientation === orientation) {
                    return
                }
                this._currentOrientation = orientation;
                this.fireEvent("orientationChanged", [{
                    orientation: orientation
                }])
            },
            _recalculateOrientation: function() {
                var windowWidth = $(this._window).width();
                if (this._currentWidth === windowWidth) {
                    return
                }
                this._currentWidth = windowWidth;
                this._changeOrientation()
            }
        }).include(EventsMixin);
        var devices = new Devices;
        viewPort.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        if (!devices.isForced() && "win" === devices.current().platform) {
            devices.current({
                version: [10]
            })
        }
        module.exports = devices
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.errors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../../core/utils/error */ 129),
            errors = __webpack_require__( /*! ../../core/errors */ 21);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: "{0} requires the key field to be specified",
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            E1050: "The validationRules option does not apply to third-party editors defined in the editCellTemplate",
            E1051: 'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',
            E1052: '{0} should have the "dataSource" option specified',
            E1053: 'The "buttons" option accepts an array that contains only objects or string values',
            E1054: "All text editor buttons must have names",
            E1055: 'One or several text editor buttons have invalid or non-unique "name" values',
            E1056: 'The {0} widget does not support buttons of the "{1}" type',
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the following error: '{0}'",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects",
            W1013: 'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',
            W1014: "The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config."
        })
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.widget.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ./ui.errors */ 17),
            Action = __webpack_require__( /*! ../../core/action */ 111),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 13).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 12),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 67),
            Template = __webpack_require__( /*! ./template */ 460),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 73),
            FunctionTemplate = __webpack_require__( /*! ./function_template */ 83),
            EmptyTemplate = __webpack_require__( /*! ./empty_template */ 109),
            ChildDefaultTemplate = __webpack_require__( /*! ./child_default_template */ 134),
            KeyboardProcessor = __webpack_require__( /*! ./ui.keyboard_processor */ 167),
            selectors = __webpack_require__( /*! ./selectors */ 66),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9),
            hoverEvents = __webpack_require__( /*! ../../events/hover */ 148),
            feedbackEvents = __webpack_require__( /*! ../../events/core/emitter.feedback */ 125),
            clickEvent = __webpack_require__( /*! ../../events/click */ 19),
            inflector = __webpack_require__( /*! ../../core/utils/inflector */ 32);
        var UI_FEEDBACK = "UIFeedback",
            WIDGET_CLASS = "dx-widget",
            ACTIVE_STATE_CLASS = "dx-state-active",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            HOVER_STATE_CLASS = "dx-state-hover",
            FOCUSED_STATE_CLASS = "dx-state-focused",
            FEEDBACK_SHOW_TIMEOUT = 30,
            FEEDBACK_HIDE_TIMEOUT = 400,
            FOCUS_NAMESPACE = "Focus",
            ANONYMOUS_TEMPLATE_NAME = "template",
            TEXT_NODE = 3,
            TEMPLATE_SELECTOR = "[data-options*='dxTemplate']",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper";
        var DX_POLYMORPH_WIDGET_TEMPLATE = new FunctionTemplate(function(options) {
            var widgetName = options.model.widget;
            if (widgetName) {
                var widgetElement = $("<div>"),
                    widgetOptions = options.model.options || {};
                if ("button" === widgetName || "tabs" === widgetName || "dropDownMenu" === widgetName) {
                    var deprecatedName = widgetName;
                    widgetName = inflector.camelize("dx-" + widgetName);
                    errors.log("W0001", "dxToolbar - 'widget' item field", deprecatedName, "16.1", "Use: '" + widgetName + "' instead")
                }
                if (options.parent) {
                    options.parent._createComponent(widgetElement, widgetName, widgetOptions)
                } else {
                    widgetElement[widgetName](widgetOptions)
                }
                return widgetElement
            }
            return $()
        });
        var Widget = DOMComponent.inherit({
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    integrationOptions: {
                        watchMethod: function(fn, callback, options) {
                            options = options || {};
                            if (!options.skipImmediate) {
                                callback(fn())
                            }
                            return commonUtils.noop
                        },
                        templates: {
                            "dx-polymorph-widget": DX_POLYMORPH_WIDGET_TEMPLATE
                        },
                        createTemplate: function(element) {
                            return new Template(element)
                        }
                    },
                    _keyboardProcessor: void 0
                })
            },
            _feedbackShowTimeout: FEEDBACK_SHOW_TIMEOUT,
            _feedbackHideTimeout: FEEDBACK_HIDE_TIMEOUT,
            _init: function() {
                this.callBase();
                this._tempTemplates = [];
                this._defaultTemplates = {};
                this._initTemplates();
                this._initContentReadyAction()
            },
            _initTemplates: function() {
                this._extractTemplates();
                this._extractAnonymousTemplate()
            },
            _clearInnerOptionCache: function(optionContainer) {
                this[optionContainer + "Cache"] = {}
            },
            _cacheInnerOptions: function(optionContainer, optionValue) {
                var cacheName = optionContainer + "Cache";
                this[cacheName] = extend(this[cacheName], optionValue)
            },
            _getOptionsFromContainer: function(_ref) {
                var name = _ref.name,
                    fullName = _ref.fullName,
                    value = _ref.value;
                var options = {};
                if (name === fullName) {
                    options = value
                } else {
                    var option = fullName.split(".").pop();
                    options[option] = value
                }
                return options
            },
            _innerOptionChanged: function(innerWidget, args) {
                var options = this._getOptionsFromContainer(args);
                innerWidget && innerWidget.option(options);
                this._cacheInnerOptions(args.name, options)
            },
            _getInnerOptionsCache: function(optionContainer) {
                return this[optionContainer + "Cache"]
            },
            _initInnerOptionCache: function(optionContainer) {
                this._clearInnerOptionCache(optionContainer);
                this._cacheInnerOptions(optionContainer, this.option(optionContainer))
            },
            _bindInnerWidgetOptions: function(innerWidget, optionsContainer) {
                this._options[optionsContainer] = extend({}, innerWidget.option());
                innerWidget.on("optionChanged", function(e) {
                    this._options[optionsContainer] = extend({}, e.component.option())
                }.bind(this))
            },
            _extractTemplates: function() {
                var templateElements = this.$element().contents().filter(TEMPLATE_SELECTOR);
                var templatesMap = {};
                templateElements.each(function(_, template) {
                    var templateOptions = domUtils.getElementOptions(template).dxTemplate;
                    if (!templateOptions) {
                        return
                    }
                    if (!templateOptions.name) {
                        throw errors.Error("E0023")
                    }
                    $(template).addClass(TEMPLATE_WRAPPER_CLASS).detach();
                    templatesMap[templateOptions.name] = templatesMap[templateOptions.name] || [];
                    templatesMap[templateOptions.name].push(template)
                });
                each(templatesMap, function(templateName, value) {
                    var deviceTemplate = this._findTemplateByDevice(value);
                    if (deviceTemplate) {
                        this._saveTemplate(templateName, deviceTemplate)
                    }
                }.bind(this))
            },
            _saveTemplate: function(name, template) {
                var templates = this.option("integrationOptions.templates");
                templates[name] = this._createTemplate(template)
            },
            _findTemplateByDevice: function(templates) {
                var suitableTemplate = commonUtils.findBestMatches(devices.current(), templates, function(template) {
                    return domUtils.getElementOptions(template).dxTemplate
                })[0];
                each(templates, function(index, template) {
                    if (template !== suitableTemplate) {
                        $(template).remove()
                    }
                });
                return suitableTemplate
            },
            _extractAnonymousTemplate: function() {
                var templates = this.option("integrationOptions.templates"),
                    anonymousTemplateName = this._getAnonymousTemplateName(),
                    $anonymousTemplate = this.$element().contents().detach();
                var $notJunkTemplateContent = $anonymousTemplate.filter(function(_, element) {
                        var isTextNode = element.nodeType === TEXT_NODE,
                            isEmptyText = $(element).text().trim().length < 1;
                        return !(isTextNode && isEmptyText)
                    }),
                    onlyJunkTemplateContent = $notJunkTemplateContent.length < 1;
                if (!templates[anonymousTemplateName] && !onlyJunkTemplateContent) {
                    templates[anonymousTemplateName] = this._createTemplate($anonymousTemplate)
                }
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                if (typeUtils.isFunction(templateSource)) {
                    return new FunctionTemplate(function(options) {
                        var templateSourceResult = templateSource.apply(this, this._getNormalizedTemplateArgs(options));
                        if (!typeUtils.isDefined(templateSourceResult)) {
                            return new EmptyTemplate
                        }
                        var dispose = false;
                        var template = this._acquireTemplate(templateSourceResult, function(templateSource) {
                            if (templateSource.nodeType || typeUtils.isRenderer(templateSource) && !$(templateSource).is("script")) {
                                return new FunctionTemplate(function() {
                                    return templateSource
                                })
                            }
                            dispose = true;
                            return this._createTemplate(templateSource)
                        }.bind(this));
                        var result = template.render(options);
                        dispose && template.dispose && template.dispose();
                        return result
                    }.bind(this))
                }
                return this._acquireTemplate(templateSource, this._createTemplateIfNeeded.bind(this))
            },
            _acquireTemplate: function(templateSource, createTemplate) {
                if (null == templateSource) {
                    return new EmptyTemplate
                }
                if (templateSource instanceof ChildDefaultTemplate) {
                    return this._defaultTemplates[templateSource.name]
                }
                if (templateSource instanceof TemplateBase) {
                    return templateSource
                }
                if (typeUtils.isFunction(templateSource.render) && !typeUtils.isRenderer(templateSource)) {
                    return this._addOneRenderedCall(templateSource)
                }
                if (templateSource.nodeType || typeUtils.isRenderer(templateSource)) {
                    return createTemplate($(templateSource))
                }
                if ("string" === typeof templateSource) {
                    return this._renderIntegrationTemplate(templateSource) || this._defaultTemplates[templateSource] || createTemplate(templateSource)
                }
                return this._acquireTemplate(templateSource.toString(), createTemplate)
            },
            _addOneRenderedCall: function(template) {
                var _render = template.render.bind(template);
                return extend({}, template, {
                    render: function(options) {
                        var templateResult = _render(options);
                        options && options.onRendered && options.onRendered();
                        return templateResult
                    }
                })
            },
            _renderIntegrationTemplate: function(templateSource) {
                var integrationTemplate = this.option("integrationOptions.templates")[templateSource];
                if (integrationTemplate && !(integrationTemplate instanceof TemplateBase)) {
                    var isAsyncTemplate = this.option("templatesRenderAsynchronously");
                    if (!isAsyncTemplate) {
                        return this._addOneRenderedCall(integrationTemplate)
                    }
                }
                return integrationTemplate
            },
            _createTemplateIfNeeded: function(templateSource) {
                var templateKey = function(templateSource) {
                    return typeUtils.isRenderer(templateSource) && templateSource[0] || templateSource
                };
                var cachedTemplate = this._tempTemplates.filter(function(t) {
                    templateSource = templateKey(templateSource);
                    return t.source === templateSource
                })[0];
                if (cachedTemplate) {
                    return cachedTemplate.template
                }
                var template = this._createTemplate(templateSource);
                this._tempTemplates.push({
                    template: template,
                    source: templateKey(templateSource)
                });
                return template
            },
            _createTemplate: function(templateSource) {
                templateSource = "string" === typeof templateSource ? domUtils.normalizeTemplateElement(templateSource) : templateSource;
                return this.option("integrationOptions.createTemplate")(templateSource)
            },
            _getNormalizedTemplateArgs: function(options) {
                var args = [];
                if ("model" in options) {
                    args.push(options.model)
                }
                if ("index" in options) {
                    args.push(options.index)
                }
                args.push(options.container);
                return args
            },
            _cleanTemplates: function() {
                this._tempTemplates.forEach(function(t) {
                    t.template.dispose && t.template.dispose()
                });
                this._tempTemplates = []
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                this.$element().addClass(WIDGET_CLASS);
                this._toggleDisabledState(this.option("disabled"));
                this._toggleVisibility(this.option("visible"));
                this._renderHint();
                if (this._isFocusable()) {
                    this._renderFocusTarget()
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents()
            },
            _renderHint: function() {
                var hint = this.option("hint");
                this.$element().attr("title", hint ? hint : null)
            },
            _renderContent: function() {
                var _this = this;
                commonUtils.deferRender(function() {
                    if (_this._disposed) {
                        return
                    }
                    return _this._renderContentImpl()
                }).done(function() {
                    if (_this._disposed) {
                        return
                    }
                    _this._fireContentReadyAction()
                })
            },
            _renderContentImpl: commonUtils.noop,
            _fireContentReadyAction: commonUtils.deferRenderer(function() {
                this._contentReadyAction()
            }),
            _dispose: function() {
                this._cleanTemplates();
                this._contentReadyAction = null;
                this.callBase()
            },
            _resetActiveState: function() {
                this._toggleActiveState(this._eventBindingTarget(), false)
            },
            _clean: function() {
                this._cleanFocusState();
                this._resetActiveState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (!this._isFocusable()) {
                    return
                }
                this._renderFocusTarget();
                this._attachFocusEvents();
                this._renderAccessKey()
            },
            _renderAccessKey: function() {
                var focusTarget = this._focusTarget();
                focusTarget.attr("accesskey", this.option("accessKey"));
                var clickNamespace = eventUtils.addNamespace(clickEvent.name, UI_FEEDBACK);
                eventsEngine.off(focusTarget, clickNamespace);
                this.option("accessKey") && eventsEngine.on(focusTarget, clickNamespace, function(e) {
                    if (eventUtils.isFakeClickEvent(e)) {
                        e.stopImmediatePropagation();
                        this.focus()
                    }
                }.bind(this))
            },
            _isFocusable: function() {
                return this.option("focusStateEnabled") && !this.option("disabled")
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    activeElement = activeElement.find(this._activeStateUnit).not("." + DISABLED_STATE_CLASS)
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                this._focusTarget().attr("tabIndex", this.option("tabIndex"))
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _detachFocusEvents: function() {
                var $element = this._focusTarget(),
                    namespace = this.NAME + FOCUS_NAMESPACE,
                    focusEvents = eventUtils.addNamespace("focusin", namespace);
                focusEvents = focusEvents + " " + eventUtils.addNamespace("focusout", namespace);
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    focusEvents = focusEvents + " " + eventUtils.addNamespace("beforeactivate", namespace)
                }
                eventsEngine.off($element, focusEvents)
            },
            _attachFocusEvents: function() {
                var namespace = this.NAME + FOCUS_NAMESPACE,
                    focusInEvent = eventUtils.addNamespace("focusin", namespace),
                    focusOutEvent = eventUtils.addNamespace("focusout", namespace);
                var $focusTarget = this._focusTarget();
                eventsEngine.on($focusTarget, focusInEvent, this._focusInHandler.bind(this));
                eventsEngine.on($focusTarget, focusOutEvent, this._focusOutHandler.bind(this));
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    var beforeActivateEvent = eventUtils.addNamespace("beforeactivate", namespace);
                    eventsEngine.on(this._focusTarget(), beforeActivateEvent, function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusInHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusIn", {
                    beforeExecute: function() {
                        that._updateFocusState(e, true)
                    },
                    excludeValidators: ["readOnly"]
                })({
                    event: e
                })
            },
            _focusOutHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusOut", {
                    beforeExecute: function() {
                        that._updateFocusState(e, false)
                    },
                    excludeValidators: ["readOnly", "disabled"]
                })({
                    event: e
                })
            },
            _updateFocusState: function(e, isFocused) {
                var target = e.target;
                if (inArray(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, $(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass(FOCUSED_STATE_CLASS, isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = $(element || this._focusTarget());
                return $focusTarget.hasClass(FOCUSED_STATE_CLASS)
            },
            _isFocused: function() {
                return this._hasFocusClass()
            },
            _attachKeyboardEvents: function() {
                var processor = this.option("_keyboardProcessor");
                if (processor) {
                    this._keyboardProcessor = processor.reinitialize(this._keyboardHandler, this)
                } else {
                    if (this.option("focusStateEnabled")) {
                        this._disposeKeyboardProcessor();
                        this._keyboardProcessor = new KeyboardProcessor({
                            element: this._keyboardEventBindingTarget(),
                            handler: this._keyboardHandler,
                            focusTarget: this._focusTarget(),
                            context: this
                        })
                    }
                }
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent;
                var keyName = options.keyName;
                var keyCode = options.which;
                var keys = this._supportedKeys(e),
                    func = keys[keyName] || keys[keyCode];
                if (void 0 !== func) {
                    var handler = func.bind(this);
                    return handler(e) || false
                } else {
                    return true
                }
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                this._detachFocusEvents();
                this._toggleFocusClass(false);
                $element.removeAttr("tabIndex");
                this._disposeKeyboardProcessor()
            },
            _disposeKeyboardProcessor: function() {
                if (this._keyboardProcessor) {
                    this._keyboardProcessor.dispose();
                    delete this._keyboardProcessor
                }
            },
            _attachHoverEvents: function() {
                var that = this,
                    hoverableSelector = that._activeStateUnit,
                    nameStart = eventUtils.addNamespace(hoverEvents.start, UI_FEEDBACK),
                    nameEnd = eventUtils.addNamespace(hoverEvents.end, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), nameStart, hoverableSelector);
                eventsEngine.off(that._eventBindingTarget(), nameEnd, hoverableSelector);
                if (that.option("hoverStateEnabled")) {
                    var startAction = new Action(function(args) {
                        that._hoverStartHandler(args.event);
                        that._refreshHoveredElement($(args.element))
                    }, {
                        excludeValidators: ["readOnly"]
                    });
                    var $eventBindingTarget = that._eventBindingTarget();
                    eventsEngine.on($eventBindingTarget, nameStart, hoverableSelector, function(e) {
                        startAction.execute({
                            element: $(e.target),
                            event: e
                        })
                    });
                    eventsEngine.on($eventBindingTarget, nameEnd, hoverableSelector, function(e) {
                        that._hoverEndHandler(e);
                        that._forgetHoveredElement()
                    })
                } else {
                    that._toggleHoverClass(false)
                }
            },
            _hoverStartHandler: commonUtils.noop,
            _hoverEndHandler: commonUtils.noop,
            _attachFeedbackEvents: function() {
                var feedbackAction, feedbackActionDisabled, that = this,
                    feedbackSelector = that._activeStateUnit,
                    activeEventName = eventUtils.addNamespace(feedbackEvents.active, UI_FEEDBACK),
                    inactiveEventName = eventUtils.addNamespace(feedbackEvents.inactive, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), activeEventName, feedbackSelector);
                eventsEngine.off(that._eventBindingTarget(), inactiveEventName, feedbackSelector);
                if (that.option("activeStateEnabled")) {
                    var feedbackActionHandler = function(args) {
                        var $element = $(args.element),
                            value = args.value,
                            dxEvent = args.event;
                        that._toggleActiveState($element, value, dxEvent)
                    };
                    eventsEngine.on(that._eventBindingTarget(), activeEventName, feedbackSelector, {
                        timeout: that._feedbackShowTimeout
                    }, function(e) {
                        feedbackAction = feedbackAction || new Action(feedbackActionHandler);
                        feedbackAction.execute({
                            element: $(e.currentTarget),
                            value: true,
                            event: e
                        })
                    });
                    eventsEngine.on(that._eventBindingTarget(), inactiveEventName, feedbackSelector, {
                        timeout: that._feedbackHideTimeout
                    }, function(e) {
                        feedbackActionDisabled = feedbackActionDisabled || new Action(feedbackActionHandler, {
                            excludeValidators: ["disabled", "readOnly"]
                        });
                        feedbackActionDisabled.execute({
                            element: $(e.currentTarget),
                            value: false,
                            event: e
                        })
                    })
                }
            },
            _toggleActiveState: function($element, value) {
                this._toggleHoverClass(!value);
                $element.toggleClass(ACTIVE_STATE_CLASS, value)
            },
            _refreshHoveredElement: function(hoveredElement) {
                var selector = this._activeStateUnit || this._eventBindingTarget();
                this._forgetHoveredElement();
                this._hoveredElement = hoveredElement.closest(selector);
                this._toggleHoverClass(true)
            },
            _forgetHoveredElement: function() {
                this._toggleHoverClass(false);
                delete this._hoveredElement
            },
            _toggleHoverClass: function(value) {
                if (this._hoveredElement) {
                    this._hoveredElement.toggleClass(HOVER_STATE_CLASS, value && this.option("hoverStateEnabled"))
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass(DISABLED_STATE_CLASS, Boolean(value));
                this._toggleHoverClass(!value);
                this.setAria("disabled", value || void 0)
            },
            _setWidgetOption: function(widgetName, args) {
                if (!this[widgetName]) {
                    return
                }
                if (typeUtils.isPlainObject(args[0])) {
                    each(args[0], function(option, value) {
                        this._setWidgetOption(widgetName, [option, value])
                    }.bind(this));
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this[widgetName + "OptionMap"];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                        this._toggleDisabledState(args.value);
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        break;
                    case "tabIndex":
                    case "_keyboardProcessor":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "visible":
                        var visible = args.value;
                        this._toggleVisibility(visible);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(args.value ? "shown" : "hiding")
                        }
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                return this.callBase() && this.option("visible")
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                var setAttribute = function(option) {
                    var attrName = "role" === option.name || "id" === option.name ? option.name : "aria-" + option.name,
                        attrValue = option.value;
                    if (typeUtils.isDefined(attrValue)) {
                        attrValue = attrValue.toString()
                    } else {
                        attrValue = null
                    }
                    option.target.attr(attrName, attrValue)
                };
                if (!typeUtils.isPlainObject(arguments[0])) {
                    setAttribute({
                        name: arguments[0],
                        value: arguments[1],
                        target: arguments[2] || this._getAriaTarget()
                    })
                } else {
                    var $target = arguments[1] || this._getAriaTarget();
                    each(arguments[0], function(key, value) {
                        setAttribute({
                            name: key,
                            value: value,
                            target: $target
                        })
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                eventsEngine.trigger(this._focusTarget(), "focus")
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys(),
                    addingKeys = {};
                addingKeys[key] = handler;
                this._supportedKeys = function() {
                    return extend(currentKeys, addingKeys)
                }
            }
        });
        module.exports = Widget
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/click.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 11),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 12),
            animationFrame = __webpack_require__( /*! ../animation/frame */ 112),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            pointerEvents = __webpack_require__( /*! ./pointer */ 24),
            Emitter = __webpack_require__( /*! ./core/emitter */ 123),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 61).compare;
        var CLICK_EVENT_NAME = "dxclick",
            TOUCH_BOUNDARY = 10,
            abs = Math.abs;
        var isInput = function(element) {
            return $(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: animationFrame.requestAnimationFrame,
            cancelAnimationFrame: animationFrame.cancelAnimationFrame
        };
        var ClickEmitter = Emitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable($(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = eventUtils.eventData(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === pointerEvents.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    domUtils.resetActiveElement()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target,
                    targetChanged = !domUtils.contains(element, target) && element !== target,
                    gestureDelta = eventUtils.eventDelta(eventUtils.eventData(e), this._startEventData),
                    boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: domUtils.closestCommonParent(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var realDevice = devices.real(),
                useNativeClick = realDevice.generic || realDevice.ios && compareVersions(realDevice.version, [9, 3]) >= 0 || realDevice.android && compareVersions(realDevice.version, [5]) >= 0;
            var isNativeClickEvent = function(target) {
                return useNativeClick || $(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null,
                lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent,
                    eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED,
                    leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && !eventAlreadyFired) {
                    if (originalEvent) {
                        originalEvent.DXCLICK_FIRED = true
                    }
                    lastFiredEvent = originalEvent;
                    eventUtils.fireEvent({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    eventsEngine.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    eventsEngine.off(this.getElement(), "click", clickHandler)
                }
            });
            exports.useNativeClick = useNativeClick
        }();
        ! function() {
            var desktopDevice = devices.real().generic;
            if (!desktopDevice) {
                var startTarget = null,
                    blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = $(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !$(startTarget).is("label") && isInput($target)) {
                        domUtils.resetActiveElement()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER",
                    document = domAdapter.getDocument();
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        registerEmitter({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        });
        exports.name = CLICK_EVENT_NAME;
        exports.misc = misc
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/data.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 21),
            Class = __webpack_require__( /*! ../class */ 15),
            objectUtils = __webpack_require__( /*! ./object */ 47),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            each = __webpack_require__( /*! ./iterator */ 3).each,
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 86),
            unwrapVariable = variableWrapper.unwrap,
            isWrapped = variableWrapper.isWrapped,
            assign = variableWrapper.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new errors.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };
        var unwrap = function(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        };
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs,
                        hasDefaultValue = "defaultValue" in options,
                        current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            if (null == current && hasDefaultValue) {
                                return options.defaultValue
                            }
                            break
                        }
                        var pathPart = path[i];
                        if (hasDefaultValue && typeUtils.isObject(current) && !(pathPart in current)) {
                            return options.defaultValue
                        }
                        var next = unwrap(current[pathPart], options);
                        if (!functionAsIs && typeUtils.isFunction(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if (typeUtils.isFunction(expr)) {
                return expr
            }
        };
        var combineGetters = function(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                each(compiledGetters, function(name) {
                    var current, path, pathItem, last, i, value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    current = result || (result = {});
                    path = name.split(".");
                    last = path.length - 1;
                    for (i = 0; i < last; i++) {
                        pathItem = path[i];
                        if (!(pathItem in current)) {
                            current[pathItem] = {}
                        }
                        current = current[pathItem]
                    }
                    current[path[last]] = value
                });
                return result
            }
        };
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if (typeUtils.isDefined(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options),
                        isPropertyFunc = !options.functionsAsIs && typeUtils.isFunction(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && typeUtils.isPlainObject(value) && (!typeUtils.isDefined(propertyValue) || typeUtils.isPlainObject(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            objectUtils.deepExtendArraySafe(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof Class && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.compileGetter = compileGetter;
        exports.compileSetter = compileSetter;
        exports.toComparable = toComparable
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ./utils/error */ 129);
        module.exports = errorUtils({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        })
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            adjust = __webpack_require__( /*! ./math */ 28).adjust,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            camelize = __webpack_require__( /*! ./inflector */ 32).camelize,
            isObject = typeUtils.isObject,
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isDefined = typeUtils.isDefined;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime(),
                millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i, dateUnitCount, dateUnitInterval, dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if (isString(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };
        var convertDateUnitToMilliseconds = function(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        };
        var getDateUnitInterval = function(tickInterval) {
            var i, maxInterval = -1;
            if (isString(tickInterval)) {
                return tickInterval
            }
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        };
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };
        var correctDateWithUnitBeginning = function(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var firstQuarterMonth, month, oldDate = new Date(date.getTime()),
                dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    month = date.getMonth();
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0);
                    if (month !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        };
        var trimTime = function(date) {
            return dateUtils.correctDateWithUnitBeginning(date, "day")
        };
        var setToDayEnd = function(date) {
            var result = dateUtils.trimTime(date);
            result.setDate(result.getDate() + 1);
            return new Date(result.getTime() - 1)
        };
        var getDatesDifferences = function(date1, date2) {
            var differences, counter = 0;
            differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            each(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime()),
                intervalObject = isString(interval) ? getDateIntervalByString(interval.toLowerCase()) : typeUtils.isNumeric(interval) ? convertMillisecondsToDateUnits(interval) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return isDate(value) ? addDateInterval(value, interval, dir) : adjust(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var cur, intervals = [];
            intervals.push(isDate(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date);
            resultDate.setDate(getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };
        var getLastMonthDay = function(date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        };
        var sameView = function(view, date1, date2) {
            return dateUtils[camelize("same " + view)](date1, date2)
        };
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };
        var getDateIntervalByString = function(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        };
        var sameDate = function(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        };
        var sameMonthAndYear = function(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        };
        var sameYear = function(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        };
        var sameDecade = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10,
                startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100,
                startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };
        var getFirstDecadeInCentury = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        };
        var getFirstYearInDecade = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        };
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
            return newDate
        };
        var getLastMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return newDate
        };
        var getFirstWeekDate = function(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        };
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day"),
                resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var dateTimeFromDecimal = function(number) {
            var hours = Math.floor(number),
                minutes = number % 1 * 60;
            return {
                hours: hours,
                minutes: minutes
            }
        };
        var roundDateByStartDayHour = function(date, startDayHour) {
            var startTime = this.dateTimeFromDecimal(startDayHour),
                result = new Date(date);
            if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                result.setHours(startTime.hours, startTime.minutes, 0, 0)
            }
            return result
        };
        var normalizeDate = function(date, min, max) {
            var normalizedDate = date;
            if (!isDefined(date)) {
                return date
            }
            if (isDefined(min) && date < min) {
                normalizedDate = min
            }
            if (isDefined(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        };
        var fixTimezoneGap = function(oldDate, newDate) {
            if (!isDefined(oldDate)) {
                return
            }
            var sign, trial, diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            sign = 1 === diff || diff === -23 ? -1 : 1;
            trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        };
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };
        var getTimezonesDifference = function(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        };
        var makeDate = function(date) {
            return new Date(date)
        };
        var getDatesOfInterval = function(startDate, endDate, step) {
            var currentDate = new Date(startDate.getTime()),
                result = [];
            while (currentDate < endDate) {
                result.push(new Date(currentDate.getTime()));
                currentDate = this.addInterval(currentDate, step)
            }
            return result
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            setToDayEnd: setToDayEnd,
            roundDateByStartDayHour: roundDateByStartDayHour,
            dateTimeFromDecimal: dateTimeFromDecimal,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            sameView: sameView,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval,
            getDatesOfInterval: getDatesOfInterval
        };
        module.exports = dateUtils
    }, ,
    /*!************************************************!*\
      !*** ./artifacts/transpiled/events/pointer.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _support = __webpack_require__( /*! ../core/utils/support */ 42);
        var _support2 = _interopRequireDefault(_support);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _browser = __webpack_require__( /*! ../core/utils/browser */ 27);
        var _browser2 = _interopRequireDefault(_browser);
        var _devices = __webpack_require__( /*! ../core/devices */ 16);
        var _devices2 = _interopRequireDefault(_devices);
        var _event_registrator = __webpack_require__( /*! ./core/event_registrator */ 71);
        var _event_registrator2 = _interopRequireDefault(_event_registrator);
        var _touch = __webpack_require__( /*! ./pointer/touch */ 264);
        var _touch2 = _interopRequireDefault(_touch);
        var _mspointer = __webpack_require__( /*! ./pointer/mspointer */ 443);
        var _mspointer2 = _interopRequireDefault(_mspointer);
        var _mouse = __webpack_require__( /*! ./pointer/mouse */ 266);
        var _mouse2 = _interopRequireDefault(_mouse);
        var _mouse_and_touch = __webpack_require__( /*! ./pointer/mouse_and_touch */ 444);
        var _mouse_and_touch2 = _interopRequireDefault(_mouse_and_touch);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getStrategy = function(support, device, browser) {
            if (support.pointerEvents && browser.msie) {
                return _mspointer2.default
            }
            var tablet = device.tablet,
                phone = device.phone;
            if (support.touch && !(tablet || phone)) {
                return _mouse_and_touch2.default
            }
            if (support.touch) {
                return _touch2.default
            }
            return _mouse2.default
        };
        var EventStrategy = getStrategy(_support2.default, _devices2.default.real(), _browser2.default);
        (0, _iterator.each)(EventStrategy.map, function(pointerEvent, originalEvents) {
            (0, _event_registrator2.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        var pointer = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        };
        pointer.getStrategy = getStrategy;
        module.exports = pointer
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/callbacks.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes,
                list = this._list,
                stopOnFalse = this._options.stopOnFalse,
                step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list,
                firingIndexes = this._firingIndexes,
                index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        module.exports = Callbacks
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/animation/translator.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../core/element_data */ 39),
            type = __webpack_require__( /*! ../core/utils/type */ 1).type;
        var TRANSLATOR_DATA_KEY = "dxTranslator",
            TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/,
            TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        var move = function($element, position) {
            var translate, left = position.left,
                top = position.top;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        var isPercentValue = function(value) {
            return "string" === type(value) && "%" === value[value.length - 1]
        };
        var getTranslate = function($element) {
            var result = $element.length ? dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                        x: 0,
                        y: 0
                    }),
                    matrix = transformValue.match(TRANSFORM_MATRIX_REGEX),
                    is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        var cacheTranslate = function($element, translate) {
            if ($element.length) {
                dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        };
        var clearCache = function($element) {
            if ($element.length) {
                dataUtils.removeData($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        var resetPosition = function($element, finishTransition) {
            var originalTransition, stylesConfig = {
                left: 0,
                top: 0,
                transform: "none"
            };
            if (finishTransition) {
                originalTransition = $element.css("transition");
                stylesConfig.transition = "none"
            }
            $element.css(stylesConfig);
            clearCache($element);
            if (finishTransition) {
                $element.get(0).offsetHeight;
                $element.css("transition", originalTransition)
            }
        };
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.move = move;
        exports.locate = locate;
        exports.clearCache = clearCache;
        exports.parseTranslate = parseTranslate;
        exports.getTranslate = getTranslate;
        exports.getTranslateCss = getTranslateCss;
        exports.resetPosition = resetPosition
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/browser.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            windowUtils = __webpack_require__( /*! ./window */ 7),
            navigator = windowUtils.getNavigator();
        var webkitRegExp = /(webkit)[ \/]([\w.]+)/,
            ieRegExp = /(msie) (\d{1,2}\.\d)/,
            ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/,
            msEdge = /(edge)\/((\d+)?[\w.]+)/,
            safari = /(safari)/i,
            mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {},
                matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [],
                browserName = matches[1],
                browserVersion = matches[2];
            if ("webkit" === browserName) {
                result.webkit = true;
                if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                    browserName = "chrome";
                    browserVersion = /(?:Chrome|CriOS)\/(\d+\.\d+)/i.exec(ua);
                    browserVersion = browserVersion && browserVersion[1]
                } else {
                    if (ua.indexOf("fxios") >= 0) {
                        browserName = "mozilla";
                        browserVersion = /FxiOS\/(\d+\.\d+)/i.exec(ua);
                        browserVersion = browserVersion && browserVersion[1]
                    } else {
                        if (safari.exec(ua)) {
                            browserName = "safari";
                            browserVersion = /Version\/([0-9.]+)/i.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                }
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        module.exports = extend({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent))
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/math.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isExponential = __webpack_require__( /*! ./type */ 1).isExponential;
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue,
                isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4,
                correctValue = "0.000300",
                precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var separatedAdjustedValue, precision = getPrecision(interval || 0) + 2,
                separatedValue = value.toString().split("."),
                sourceValue = value,
                absValue = Math.abs(value),
                isExponentValue = isExponential(value),
                integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if (isExponential(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var mantissa, positionOfDelimiter, str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            mantissa = str.split(".");
            positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }

        function getRoot(x, n) {
            if (x < 0 && n % 2 !== 1) {
                return NaN
            }
            var y = Math.pow(Math.abs(x), 1 / n);
            return n % 2 === 1 && x < 0 ? -y : y
        }

        function solveCubicEquation(a, b, c, d) {
            var min = 1e-8;
            if (Math.abs(a) < min) {
                a = b;
                b = c;
                c = d;
                if (Math.abs(a) < min) {
                    a = b;
                    b = c;
                    if (Math.abs(a) < min) {
                        return []
                    }
                    return [-b / a]
                }
                var D2 = b * b - 4 * a * c;
                if (Math.abs(D2) < min) {
                    return [-b / (2 * a)]
                } else {
                    if (D2 > 0) {
                        return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                    }
                }
                return []
            }
            var p = (3 * a * c - b * b) / (3 * a * a);
            var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
            var roots;
            var u;
            if (Math.abs(p) < min) {
                roots = [getRoot(-q, 3)]
            } else {
                if (Math.abs(q) < min) {
                    roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                } else {
                    var D3 = q * q / 4 + p * p * p / 27;
                    if (Math.abs(D3) < min) {
                        roots = [-1.5 * q / p, 3 * q / p]
                    } else {
                        if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                }
            }
            for (var i = 0; i < roots.length; i++) {
                roots[i] -= b / (3 * a)
            }
            return roots
        }
        exports.sign = sign;
        exports.fitIntoRange = fitIntoRange;
        exports.inRange = inRange;
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent;
        exports.getRoot = getRoot;
        exports.solveCubicEquation = solveCubicEquation
    }, ,
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/themes.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 11),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            errors = __webpack_require__( /*! ./widget/ui.errors */ 17),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 12),
            readyCallbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 48),
            ready = readyCallbacks.add,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 76),
            themeReadyCallback = __webpack_require__( /*! ./themes_callback */ 268),
            viewPort = viewPortUtils.value,
            Promise = __webpack_require__( /*! ../core/polyfills/promise */ 82),
            viewPortChanged = viewPortUtils.changeCallback;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]",
            THEME_ATTR = "data-theme",
            ACTIVE_ATTR = "data-active",
            DX_HAIRLINES_CLASS = "dx-hairlines";
        var context, $activeThemeLink, knownThemes, currentThemeName, pendingThemeName;
        var timerId;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!windowUtils.hasWindow()) {
                return null
            }
            var result, element = $("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                themeReadyCallback.fire();
                themeReadyCallback.empty()
            }
            if (isPendingThemeLoaded()) {
                handleLoaded()
            } else {
                waitStartTime = Date.now();
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded(),
                        isTimeout = !isLoaded && Date.now() - waitStartTime > 15e3;
                    if (isTimeout) {
                        errors.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        clearInterval(timerId);
                        timerId = void 0;
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            return !pendingThemeName || readThemeMarker() === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = $(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = $(domUtils.createMarkupFromString("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = $(this, context),
                    fullThemeName = link.attr(THEME_ATTR),
                    url = link.attr("href"),
                    isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName.split("."),
                result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }
                each(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || domAdapter.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var currentThemeData, isAutoInit = options._autoInit,
                loadCallback = options.loadCallback;
            currentThemeName = options.theme || currentThemeName;
            if (isAutoInit && !currentThemeName) {
                currentThemeName = themeNameFromDevice(devices.current())
            }
            currentThemeName = resolveFullThemeName(currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if ((themeReadyCallback.has() || options._forceTimeout) && !timerId) {
                    waitForThemeLoad(currentThemeName)
                } else {
                    if (pendingThemeName) {
                        pendingThemeName = currentThemeName
                    }
                }
            } else {
                if (isAutoInit) {
                    themeReadyCallback.fire();
                    themeReadyCallback.empty()
                } else {
                    throw errors.Error("E0021", currentThemeName)
                }
            }
            checkThemeDeprecation();
            attachCssClasses(viewPortUtils.originalViewPort(), currentThemeName)
        }

        function themeNameFromDevice(device) {
            var themeName = device.platform;
            switch (themeName) {
                case "ios":
                    return "ios7";
                case "android":
                case "win":
                    return "generic"
            }
            return themeName
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [],
                themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial(themeName) ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            $(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = windowUtils.hasWindow() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = $("<div>");
                $tester.css("border", ".5px solid transparent");
                $("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    $(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            $(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            themeReadyCallback.add(callback)
        }

        function isTheme(themeRegExp, themeName) {
            if (!themeName) {
                themeName = currentThemeName || readThemeMarker()
            }
            return new RegExp(themeRegExp).test(themeName)
        }

        function isMaterial(themeName) {
            return isTheme("material", themeName)
        }

        function isIos7(themeName) {
            return isTheme("ios7", themeName)
        }

        function isGeneric(themeName) {
            return isTheme("generic", themeName)
        }

        function checkThemeDeprecation() {
            if (isIos7()) {
                errors.log("W0010", "The 'ios7' theme", "19.1", "Use the 'generic' theme instead.")
            }
        }

        function isWebFontLoaded(text, fontWeight) {
            var testedFont = "Roboto, RobotoFallback, Arial";
            var etalonFont = "Arial";
            var document = domAdapter.getDocument();
            var testElement = document.createElement("span");
            testElement.style.position = "absolute";
            testElement.style.top = "-9999px";
            testElement.style.left = "-9999px";
            testElement.style.visibility = "hidden";
            testElement.style.fontFamily = etalonFont;
            testElement.style.fontSize = "250px";
            testElement.style.fontWeight = fontWeight;
            testElement.innerHTML = text;
            document.body.appendChild(testElement);
            var etalonFontWidth = testElement.offsetWidth;
            testElement.style.fontFamily = testedFont;
            var testedFontWidth = testElement.offsetWidth;
            testElement.parentNode.removeChild(testElement);
            return etalonFontWidth !== testedFontWidth
        }

        function waitWebFont(text, fontWeight) {
            var interval = 15;
            var timeout = 2e3;
            return new Promise(function(resolve) {
                var check = function() {
                    if (isWebFontLoaded(text, fontWeight)) {
                        clear()
                    }
                };
                var clear = function() {
                    clearInterval(intervalId);
                    clearTimeout(timeoutId);
                    resolve()
                };
                var intervalId = setInterval(check, interval);
                var timeoutId = setTimeout(clear, timeout)
            })
        }
        var initDeferred = new Deferred;

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ($(DX_LINK_SELECTOR, context).length) {
                throw errors.Error("E0022")
            }
            initDeferred.resolve()
        }
        if (windowUtils.hasWindow()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        devices.changed.add(function() {
            init({
                _autoInit: true
            })
        });
        exports.current = current;
        exports.ready = themeReady;
        exports.init = init;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.themeNameFromDevice = themeNameFromDevice;
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.isMaterial = isMaterial;
        exports.isIos7 = isIos7;
        exports.isGeneric = isGeneric;
        exports.isWebFontLoaded = isWebFontLoaded;
        exports.waitWebFont = waitWebFont;
        exports.resetTheme = function() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/config.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _extend2 = _interopRequireDefault(_extend);
        var _errors = __webpack_require__( /*! ./errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            oDataFilterToLower: true,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useLegacyStoreResult: false,
            useJQuery: void 0,
            editorStylingMode: void 0,
            useLegacyVisibleIndex: false,
            floatingActionButtonConfig: {
                icon: "add",
                closeIcon: "close",
                position: {
                    at: "right bottom",
                    my: "right bottom",
                    offset: {
                        x: -16,
                        y: -16
                    }
                },
                maxSpeedDialActionCount: 5
            },
            optionsParser: function(optionsString) {
                if ("{" !== optionsString.trim().charAt(0)) {
                    optionsString = "{" + optionsString + "}"
                }
                try {
                    return new Function("return " + optionsString)()
                } catch (ex) {
                    throw _errors2.default.Error("E3018", ex, optionsString)
                }
            }
        };
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            _extend2.default.extend(config, arguments.length <= 0 ? void 0 : arguments[0])
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        module.exports = configMethod
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/inflector.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = __webpack_require__( /*! ./iterator */ 3).map;
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return map(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        var camelize = function(text, upperFirst) {
            return map(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        var titleize = function(text) {
            return map(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var i, char, captionList = [],
                isPrevCharNewWord = false,
                isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.dasherize = dasherize;
        exports.camelize = camelize;
        exports.humanize = humanize;
        exports.titleize = titleize;
        exports.underscore = underscore;
        exports.captionize = captionize
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/date.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 54),
            isString = __webpack_require__( /*! ../core/utils/type */ 1).isString,
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray,
            getLDMLDateFormatter = __webpack_require__( /*! ./ldml/date.formatter */ 256).getFormatter,
            getLDMLDateFormat = __webpack_require__( /*! ./ldml/date.format */ 207).getFormat,
            getLDMLDateParser = __webpack_require__( /*! ./ldml/date.parser */ 210).getParser,
            defaultDateNames = __webpack_require__( /*! ./default_date_names */ 257),
            numberLocalization = __webpack_require__( /*! ./number */ 51),
            errors = __webpack_require__( /*! ../core/errors */ 21);
        __webpack_require__( /*! ./core */ 87);
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            mediumdatemediumtime: "MMMM d, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = dependencyInjector({
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format,
                    result = [];
                iteratorUtils.each(pattern.split(/\W+/), function(_, formatPart) {
                    iteratorUtils.each(possiblePartPatterns, function(partName, possiblePatterns) {
                        if (inArray(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return defaultDateNames.getMonthNames(format)
            },
            getDayNames: function(format) {
                return defaultDateNames.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return defaultDateNames.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return defaultDateNames.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0),
                    pmTime = new Date(2017, 0, 20, 23, 0, 0, 0),
                    amTimeFormatted = this.format(amTime, format),
                    pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if (isString(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return numberLocalization.convertDigits(getLDMLDateFormatter(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var result, ldmlFormat, formatter, that = this;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return numberLocalization.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = getLDMLDateFormat(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = numberLocalization.convertDigits(text, true);
                    return getLDMLDateParser(ldmlFormat, this)(text)
                }
                errors.log("W0012");
                result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                return 0
            }
        });
        module.exports = dateLocalization
    }, , ,
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 129),
            coreErrors = __webpack_require__( /*! ../core/errors */ 21),
            handlers = {};
        var errors = errorUtils(coreErrors.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with the a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });

        function handleError(error) {
            var id = "E4000";
            if (error && "__id" in error) {
                id = error.__id
            }
            errors.log(id, error)
        }
        var errorHandler = null;
        var _errorHandler = function(error) {
            handleError(error);
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        module.exports = handlers
    }, ,
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/animation/fx.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            window = __webpack_require__( /*! ../core/utils/window */ 7).getWindow(),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ../core/errors */ 21),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 12).getPublicElement,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            translator = __webpack_require__( /*! ./translator */ 26),
            easing = __webpack_require__( /*! ./easing */ 263),
            animationFrame = __webpack_require__( /*! ./frame */ 112),
            support = __webpack_require__( /*! ../core/utils/support */ 42),
            positionUtils = __webpack_require__( /*! ./position */ 75),
            removeEvent = __webpack_require__( /*! ../core/remove_event */ 132),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            removeEventName = eventUtils.addNamespace(removeEvent, "dxFX"),
            isFunction = typeUtils.isFunction,
            isPlainObject = typeUtils.isPlainObject,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop;
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i,
            ANIM_DATA_KEY = "dxAnimData",
            ANIM_QUEUE_KEY = "dxAnimQueue",
            TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this,
                    deferred = new Deferred,
                    cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            when(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var simulatedEndEventTimer, waitForJSCompleteTimer, that = this,
                    startTime = Date.now() + config.delay,
                    deferred = new Deferred,
                    transitionEndFired = new Deferred,
                    simulatedTransitionEndFired = new Deferred,
                    transitionEndEventName = support.transitionEndEventName() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    eventsEngine.off($element, transitionEndEventName);
                    eventsEngine.off($element, removeEventName)
                };
                eventsEngine.one($element, transitionEndEventName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    when(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if (isPlainObject(config.to)) {
                        iteratorUtils.each(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new Deferred,
                    that = this;
                if (!config) {
                    return deferred.reject().promise()
                }
                iteratorUtils.each(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: easing.convertTransitionTimingFuncToEasing(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = extend({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = iteratorUtils.map(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return translator.getTranslateCss(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                iteratorUtils.each(transformString.match(/(\w|\d)+\([^)]*\)\s*/g), function(i, part) {
                    var translateData = translator.parseTranslate(part),
                        scaleData = part.match(/scale\((.+?)\)/),
                        rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                animationFrame.cancelAnimationFrame(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = animationFrame.requestAnimationFrame(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration,
                            t = currentDuration,
                            b = 1 * from[propName],
                            c = to[propName] - from[propName],
                            d = frameAnimation.duration;
                        return easing.getEasing(frameAnimation.easing)(x, t, b, c, d)
                    };
                    iteratorUtils.each(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === ("undefined" === typeof endPropValue ? "undefined" : _typeof(endPropValue)) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new Deferred).resolve().promise()
            },
            stop: noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: support.transition() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !support.transition()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            iteratorUtils.each(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw errors.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return isPlainObject(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = translator.locate($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = extend({
                        of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                translator.clearCache($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = translator.getTranslateCss({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var toOpacity, from = config.from,
                    fromOpacity = isPlainObject(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from,
                    to = config.to,
                    fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity"),
                    toOpacity = "opacity" in to ? to.opacity : 1,
                    fromScale = "scale" in from ? from.scale : 0,
                    toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = translator.getTranslate($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return translator.getTranslateCss(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw errors.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
                type: "custom",
                from: {},
                to: {},
                duration: 400,
                start: noop,
                complete: noop,
                easing: "ease",
                delay: 0
            },
            defaultCssConfig = {
                duration: 400,
                easing: "ease",
                delay: 0
            };
        var setupAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = getPublicElement($element);
                config.start.apply(this, [element, config])
            }
        };
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element,
                config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = getPublicElement($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = eventUtils.addNamespace(removeEvent, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            eventsEngine.off(animation.element, scopedRemoveEvent);
            eventsEngine.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                eventsEngine.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig,
                config = extend(true, {}, defaultConfig, initialConfig),
                configurator = getAnimationConfigurator(config),
                strategy = getAnimationStrategy(config),
                animation = {
                    element: $(element),
                    config: config,
                    configurator: configurator,
                    strategy: strategy,
                    isSynchronous: strategy.isSynchronous,
                    setup: setupAnimationOnElement,
                    start: startAnimationOnElement,
                    stop: stopAnimationOnElement,
                    deferred: new Deferred
                };
            if (isFunction(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = $(element);
            if (!$element.length) {
                return (new Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };
        var pushInAnimationQueue = function($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        };
        var getAnimQueueData = function($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        };
        var writeAnimQueueData = function($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        };
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };
        var isAnimating = function($element) {
            return !!$element.data(ANIM_DATA_KEY)
        };
        var shiftFromAnimationQueue = function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        };
        var executeAnimation = function(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        };
        var setupPosition = function($element, config) {
            if (!config || !config.position) {
                return
            }
            var win = $(window),
                left = 0,
                top = 0,
                position = positionUtils.calculate($element, config.position),
                offset = $element.offset(),
                currentPosition = $element.position();
            if (currentPosition.top > offset.top) {
                top = win.scrollTop()
            }
            if (currentPosition.left > offset.left) {
                left = win.scrollLeft()
            }
            extend(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        };
        var setProps = function($element, props) {
            iteratorUtils.each(props, function(key, value) {
                try {
                    $element.css(key, typeUtils.isFunction(value) ? value() : value)
                } catch (e) {}
            })
        };
        var stop = function(element, jumpToEnd) {
            var $element = $(element),
                queueData = getAnimQueueData($element);
            iteratorUtils.each(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        module.exports = fx
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/element_data.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var WeakMap = __webpack_require__( /*! ./polyfills/weak_map */ 176);
        var domAdapter = __webpack_require__( /*! ./dom_adapter */ 11);
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 177);
        var dataMap = new WeakMap;
        var strategy;
        var strategyChanging = new MemorizedCallbacks;
        var beforeCleanData = function() {};
        var afterCleanData = function() {};
        var setDataStrategy = exports.setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanData(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanData(nodes);
                return result
            }
        };
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    eventsEngine.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });
        exports.setDataStrategy = setDataStrategy;
        exports.getDataStrategy = function() {
            return strategy
        };
        exports.data = function() {
            return strategy.data.apply(this, arguments)
        };
        exports.strategyChanging = strategyChanging;
        exports.beforeCleanData = function(callback) {
            beforeCleanData = callback
        };
        exports.afterCleanData = function(callback) {
            afterCleanData = callback
        };
        exports.cleanData = function(nodes) {
            return strategy.cleanData.call(this, nodes)
        };
        exports.removeData = function(element, key) {
            return strategy.removeData.call(this, element, key)
        };
        exports.cleanDataRecursive = function(element, cleanSelf) {
            if (!domAdapter.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/utils.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _dom_adapter = __webpack_require__( /*! ../core/dom_adapter */ 11);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _ready_callbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 48);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return (0, _iterator.map)(info, function(i) {
                var result = {
                    selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var textStatusDetails = {
                timeout: "possible causes: the remote host is not accessible, overloaded or is not included into the domain white-list when being run in the native container",
                error: "if the remote host is located on another domain, make sure it properly supports cross-origin resource sharing (CORS), or use the JSONP approach instead",
                parsererror: "the remote host did not respond with valid JSON data"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                result += " (" + textStatusDetails[textStatus] + ")";
                return result
            };
            var unloading;
            (0, _ready_callbacks.add)(function() {
                var window = (0, _window.getWindow)();
                _dom_adapter2.default.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockDeferred, lockCount = 0;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new _deferred.Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|&&|&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var name, names = (0, _iterator.map)(key1, function(v, k) {
                    return k
                });
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if ((0, _data.toComparable)(key1[name], true) != (0, _data.toComparable)(key2[name], true)) {
                        return false
                    }
                }
                return true
            }
            return (0, _data.toComparable)(key1, true) == (0, _data.toComparable)(key2, true)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i],
                    octet2 = input[i + 1],
                    octet3 = input[i + 2];
                result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };
        var stringToByteArray = function(str) {
            var code, i, bytes = [];
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        };
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var isGroupOperator = function(value) {
            return "and" === value || "or" === value
        };
        var isGroupCriterion = function(crit) {
            var first = crit[0],
                second = crit[1];
            if (Array.isArray(first)) {
                return true
            }
            if (_type2.default.isFunction(first)) {
                if (Array.isArray(second) || _type2.default.isFunction(second) || isGroupOperator(second)) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new _deferred.Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new _deferred.Deferred;
            return d.reject.apply(d, arguments).promise()
        };

        function throttle(func, timeout) {
            var timeoutId, lastArgs;
            return function() {
                var _this = this;
                lastArgs = arguments;
                if (!timeoutId) {
                    timeoutId = setTimeout(function() {
                        timeoutId = void 0;
                        if (lastArgs) {
                            func.call(_this, lastArgs)
                        }
                    }, (0, _type.isFunction)(timeout) ? timeout() : timeout)
                }
                return timeoutId
            }
        }

        function throttleChanges(func, timeout) {
            var cache = [],
                throttled = throttle(function() {
                    func.call(this, cache);
                    cache = []
                }, timeout);
            return function(changes) {
                if (Array.isArray(changes)) {
                    var _cache;
                    (_cache = cache).push.apply(_cache, _toConsumableArray(changes))
                }
                return throttled.call(this, cache)
            }
        }
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            throttleChanges: throttleChanges,
            trivialPromise: trivialPromise,
            rejectedPromise: rejectedPromise,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            isGroupCriterion: isGroupCriterion,
            base64_encode: base64_encode
        };
        module.exports = utils
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/query.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var arrayQueryImpl = __webpack_require__( /*! ./array_query */ 155),
            remoteQueryImpl = __webpack_require__( /*! ./remote_query */ 466);
        var queryImpl = {
            array: arrayQueryImpl,
            remote: remoteQueryImpl
        };
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return queryImpl[impl].apply(this, arguments)
        };
        module.exports = query;
        module.exports.queryImpl = queryImpl
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/support.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _array = __webpack_require__( /*! ./array */ 13);
        var _dom_adapter = __webpack_require__( /*! ../dom_adapter */ 11);
        var _common = __webpack_require__( /*! ./common */ 4);
        var _call_once = __webpack_require__( /*! ./call_once */ 63);
        var _call_once2 = _interopRequireDefault(_call_once);
        var _window = __webpack_require__( /*! ./window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _devices = __webpack_require__( /*! ../devices */ 16);
        var _devices2 = _interopRequireDefault(_devices);
        var _style = __webpack_require__( /*! ./style */ 85);
        var _style2 = _interopRequireDefault(_style);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _windowUtils$getNavig = _window2.default.getNavigator(),
            maxTouchPoints = _windowUtils$getNavig.maxTouchPoints,
            msMaxTouchPoints = _windowUtils$getNavig.msMaxTouchPoints,
            pointerEnabled = _windowUtils$getNavig.pointerEnabled;
        var hasProperty = _window2.default.hasProperty.bind(_window2.default);
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!_style2.default.styleProp(prop)
        };
        var isNativeScrollingSupported = function() {
            var _devices$real = _devices2.default.real(),
                platform = _devices$real.platform,
                version = _devices$real.version,
                isMac = _devices$real.mac;
            var isObsoleteAndroid = version && version[0] < 4 && "android" === platform;
            var isNativeScrollDevice = !isObsoleteAndroid && (0, _array.inArray)(platform, ["ios", "android", "win"]) > -1 || isMac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = (0, _dom_adapter.createElement)("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        var detectTouchEvents = function(hasWindowProperty, maxTouchPoints) {
            return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
        };
        var detectPointerEvent = function(hasWindowProperty, pointerEnabled) {
            var isPointerEnabled = (0, _common.ensureDefined)(pointerEnabled, true);
            var canUsePointerEvent = (0, _common.ensureDefined)(pointerEnabled, false);
            return hasWindowProperty("PointerEvent") && isPointerEnabled || canUsePointerEvent
        };
        var touchEvents = detectTouchEvents(hasProperty, maxTouchPoints);
        var pointerEvents = detectPointerEvent(hasProperty, pointerEnabled);
        var touchPointersPresent = !!maxTouchPoints || !!msMaxTouchPoints;
        exports.detectTouchEvents = detectTouchEvents;
        exports.detectPointerEvent = detectPointerEvent;
        exports.touchEvents = touchEvents;
        exports.pointerEvents = pointerEvents;
        exports.touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.transition = (0, _call_once2.default)(function() {
            return supportProp("transition")
        });
        exports.transitionEndEventName = (0, _call_once2.default)(function() {
            return transitionEndEventNames[_style2.default.styleProp("transition")]
        });
        exports.animation = (0, _call_once2.default)(function() {
            return supportProp("animation")
        });
        exports.nativeScrolling = isNativeScrollingSupported();
        exports.styleProp = _style2.default.styleProp;
        exports.stylePropPrefix = _style2.default.stylePropPrefix;
        exports.supportProp = supportProp;
        exports.inputType = inputType
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/core/guid.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ./class */ 15);
        var Guid = Class.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        module.exports = Guid
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/data/data_source/data_source.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 58),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            dataUtils = __webpack_require__( /*! ../utils */ 40),
            arrayUtils = __webpack_require__( /*! ../array_utils */ 135),
            Store = __webpack_require__( /*! ../abstract_store */ 98),
            ArrayStore = __webpack_require__( /*! ../array_store */ 68),
            CustomStore = __webpack_require__( /*! ../custom_store */ 149),
            EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 81),
            errors = __webpack_require__( /*! ../errors */ 36).errors,
            array = __webpack_require__( /*! ../../core/utils/array */ 13),
            queue = __webpack_require__( /*! ../../core/utils/queue */ 262),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 6),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            __isString = typeUtils.isString,
            __isNumber = typeUtils.isNumeric,
            __isBoolean = typeUtils.isBoolean,
            __isDefined = typeUtils.isDefined;
        var CANCELED_TOKEN = "canceled";

        function OperationManager() {
            this._counter = -1;
            this._deferreds = {}
        }
        OperationManager.prototype.constructor = OperationManager;
        OperationManager.prototype.add = function(deferred) {
            this._counter += 1;
            this._deferreds[this._counter] = deferred;
            return this._counter
        };
        OperationManager.prototype.remove = function(operationId) {
            return delete this._deferreds[operationId]
        };
        OperationManager.prototype.cancel = function(operationId) {
            if (operationId in this._deferreds) {
                this._deferreds[operationId].reject(CANCELED_TOKEN);
                return true
            }
            return false
        };
        OperationManager.prototype.cancelAll = function() {
            while (this._counter > -1) {
                this.cancel(this._counter);
                this._counter--
            }
        };

        function isPending(deferred) {
            return "pending" === deferred.state()
        }

        function normalizeDataSourceOptions(options, normalizationOptions) {
            var store;

            function createCustomStoreFromLoadFunc() {
                var storeConfig = {};
                iteratorUtils.each(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                    storeConfig[this] = options[this];
                    delete options[this]
                });
                return new CustomStore(storeConfig)
            }

            function createStoreFromConfig(storeConfig) {
                var alias = storeConfig.type;
                delete storeConfig.type;
                return Store.create(alias, storeConfig)
            }

            function createCustomStoreFromUrl(url) {
                return new CustomStore({
                    load: function() {
                        return ajax.sendRequest({
                            url: url,
                            dataType: "json"
                        })
                    },
                    loadMode: normalizationOptions && normalizationOptions.fromUrlLoadMode
                })
            }
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof Store) {
                options = {
                    store: options
                }
            } else {
                options = extend({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc()
            } else {
                if (Array.isArray(store)) {
                    store = new ArrayStore(store)
                } else {
                    if (typeUtils.isPlainObject(store)) {
                        store = createStoreFromConfig(extend({}, store))
                    }
                }
            }
            options.store = store;
            return options
        }

        function normalizeStoreLoadOptionAccessorArguments(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        }

        function generateStoreLoadOptionAccessor(optionName) {
            return function() {
                var args = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === args) {
                    return this._storeLoadOptions[optionName]
                }
                this._storeLoadOptions[optionName] = args
            }
        }

        function mapDataRespectingGrouping(items, mapper, groupInfo) {
            function mapRecursive(items, level) {
                if (!Array.isArray(items)) {
                    return items
                }
                return level ? mapGroup(items, level) : iteratorUtils.map(items, mapper)
            }

            function mapGroup(group, level) {
                return iteratorUtils.map(group, function(item) {
                    var result = {
                        key: item.key,
                        items: mapRecursive(item.items, level - 1)
                    };
                    if ("aggregates" in item) {
                        result.aggregates = item.aggregates
                    }
                    return result
                })
            }
            return mapRecursive(items, groupInfo ? dataUtils.normalizeSortingInfo(groupInfo).length : 0)
        }

        function normalizeLoadResult(data, extra) {
            if (data && !Array.isArray(data) && data.data) {
                extra = data;
                data = data.data
            }
            if (!Array.isArray(data)) {
                data = [data]
            }
            return {
                data: data,
                extra: extra
            }
        }
        var DataSource = Class.inherit({
            ctor: function(options) {
                var _this = this;
                var that = this;
                options = normalizeDataSourceOptions(options);
                var onPushHandler = 0 !== options.pushAggregationTimeout ? dataUtils.throttleChanges(this._onPush, function() {
                    if (void 0 === options.pushAggregationTimeout) {
                        return 5 * that._changedTime
                    }
                    return options.pushAggregationTimeout
                }) : this._onPush;
                this._changedTime = 0;
                this._onPushHandler = function(changes) {
                    _this._aggregationTimeoutId = onPushHandler.call(_this, changes)
                };
                this._store = options.store;
                this._store.on("push", this._onPushHandler);
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                this._reshapeOnPush = __isDefined(options.reshapeOnPush) ? options.reshapeOnPush : false;
                iteratorUtils.each(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new OperationManager;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!__isDefined(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                this._store.off("push", this._onPushHandler);
                this._disposeEvents();
                clearTimeout(this._aggregationTimeoutId);
                delete this._store;
                if (this._delayedLoadTask) {
                    this._delayedLoadTask.abort()
                }
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {},
                    names = ["sort", "filter", "select", "group", "requireTotalCount"],
                    customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }
                iteratorUtils.each(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!__isNumber(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!__isBoolean(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!__isNumber(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            sort: generateStoreLoadOptionAccessor("sort"),
            filter: function() {
                var newFilter = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: generateStoreLoadOptionAccessor("group"),
            select: generateStoreLoadOptionAccessor("select"),
            requireTotalCount: function(value) {
                if (!__isBoolean(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!__isString(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                return this._store && this._store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return queue.create()
            },
            _changeLoadingCount: function(increment) {
                var newLoading, oldLoading = this.isLoading();
                this._loadingCount += increment;
                newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var that = this;
                that.beginLoading();
                deferred.always(function() {
                    that.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var that = this;
                deferred.fail(function() {
                    if (arguments[0] === CANCELED_TOKEN) {
                        return
                    }
                    that.fireEvent("loadError", arguments)
                })
            },
            _fireChanged: function(args) {
                var date = new Date;
                this.fireEvent("changed", args);
                this._changedTime = new Date - date
            },
            _scheduleChangedCallbacks: function(deferred) {
                var _this2 = this;
                deferred.done(function() {
                    _this2._fireChanged()
                })
            },
            loadSingle: function(propName, propValue) {
                var that = this;
                var d = new Deferred,
                    key = this.key(),
                    store = this._store,
                    options = this._createStoreLoadOptions(),
                    handleDone = function(data) {
                        if (!__isDefined(data) || array.isEmpty(data)) {
                            d.reject(new errors.Error("E4009"))
                        } else {
                            if (!Array.isArray(data)) {
                                data = [data]
                            }
                            d.resolve(that._applyMapFunction(data)[0])
                        }
                    };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;

                function shouldForceByKey() {
                    return store instanceof CustomStore && !store._byKeyViaLoad()
                }(function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var loadOperation, that = this,
                    d = new Deferred;

                function loadTask() {
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(d)) {
                        return
                    }
                    return that._loadFromStore(loadOperation, d)
                }
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                loadOperation = this._createLoadOperation(d);
                this.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        that._delayedLoadTask = commonUtils.executeAsync(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _onPush: function(changes) {
                var _this3 = this;
                if (this._reshapeOnPush) {
                    this.load()
                } else {
                    this.fireEvent("changing", [{
                        changes: changes
                    }]);
                    var group = this.group(),
                        items = this.items(),
                        groupLevel = 0,
                        dataSourceChanges = this.paginate() || group ? changes.filter(function(item) {
                            return "update" === item.type
                        }) : changes;
                    if (group) {
                        groupLevel = Array.isArray(group) ? group.length : 1
                    }
                    if (this._mapFunc) {
                        dataSourceChanges.forEach(function(item) {
                            if ("insert" === item.type) {
                                item.data = _this3._mapFunc(item.data)
                            }
                        })
                    }
                    arrayUtils.applyBatch(this.store(), items, dataSourceChanges, groupLevel, true);
                    this._fireChanged([{
                        changes: changes
                    }])
                }
            },
            _createLoadOperation: function(deferred) {
                var id = this._operationManager.add(deferred),
                    options = this._createStoreLoadOptions();
                deferred.always(function() {
                    this._operationManager.remove(id)
                }.bind(this));
                return {
                    operationId: id,
                    storeLoadOptions: options
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof CustomStore) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            cancelAll: function() {
                return this._operationManager.cancelAll()
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = extend({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue,
                    op = this._searchOperation,
                    selector = this._searchExpr,
                    searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }
                iteratorUtils.each(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var that = this;

                function handleSuccess(data, extra) {
                    function processResult() {
                        var loadResult = extend(normalizeLoadResult(data, extra), loadOptions);
                        that.fireEvent("customizeLoadResult", [loadResult]);
                        when(loadResult.data).done(function(data) {
                            loadResult.data = data;
                            that._processStoreLoadResult(loadResult, pendingDeferred)
                        }).fail(pendingDeferred.reject)
                    }
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(pendingDeferred)) {
                        return
                    }
                    processResult()
                }
                if (loadOptions.data) {
                    return (new Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var that = this,
                    data = loadResult.data,
                    extra = loadResult.extra,
                    storeLoadOptions = loadResult.storeLoadOptions;

                function resolvePendingDeferred() {
                    that._isLoaded = true;
                    that._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                }

                function proceedLoadingTotalCount() {
                    that.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                }
                if (that._disposed) {
                    return
                }
                data = that._applyPostProcessFunction(that._applyMapFunction(data));
                if (!typeUtils.isPlainObject(extra)) {
                    extra = {}
                }
                that._items = data;
                if (!data.length || !that._paginate || that._pageSize && data.length < that._pageSize) {
                    that._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return mapDataRespectingGrouping(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            }
        }).include(EventsMixin);
        exports.DataSource = DataSource;
        exports.normalizeDataSourceOptions = normalizeDataSourceOptions;
        exports.normalizeLoadResult = normalizeLoadResult
    }, ,
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/string.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        var splitQuad = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var quadToObject = function(raw) {
            var quad = splitQuad(raw),
                left = parseInt(quad && quad[0], 10),
                top = parseInt(quad && quad[1], 10),
                right = parseInt(quad && quad[2], 10),
                bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        var stringFormat = function() {
            var replaceDollarCount, reg, value, s = arguments[0],
                values = [].slice.call(arguments).slice(1);
            if (typeUtils.isFunction(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === typeUtils.type(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.encodeHtml = encodeHtml;
        exports.quadToObject = quadToObject;
        exports.format = stringFormat;
        exports.replaceAll = replaceAll;
        exports.isEmpty = isEmpty
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/object.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 86);
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        var orderEach = function(map, func) {
            var key, i, keys = [];
            for (key in map) {
                if (Object.prototype.hasOwnProperty.call(map, key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = typeUtils.isNumeric(x),
                    isNumberY = typeUtils.isNumeric(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && variableWrapper.isWrapped(target[property])) {
                variableWrapper.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue, newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if ("__proto__" === name || target === newValue) {
                    continue
                }
                if (typeUtils.isPlainObject(newValue)) {
                    var goDeeper = extendComplexObject ? typeUtils.isObject(prevValue) : typeUtils.isPlainObject(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.clone = clone;
        exports.orderEach = orderEach;
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ready_callbacks.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 11);
        var injector = __webpack_require__( /*! ./dependency_injector */ 54);
        var windowUtils = __webpack_require__( /*! ./window */ 7);
        var callOnce = __webpack_require__( /*! ./call_once */ 63);
        var callbacks = [];
        var isReady = function() {
            return "complete" === domAdapter.getReadyState() || "loading" !== domAdapter.getReadyState() && !domAdapter.getDocumentElement().doScroll
        };
        var subscribeReady = callOnce(function() {
            var removeListener = domAdapter.listen(domAdapter.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var hasWindow = windowUtils.hasWindow();
                if (hasWindow && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    hasWindow && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    return callback()
                });
                callbacks = []
            }
        };
        module.exports = injector(readyCallbacks)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/ui/editor/editor.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ../../core/element_data */ 39),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7),
            getDefaultAlignment = __webpack_require__( /*! ../../core/utils/position */ 97).getDefaultAlignment,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            Widget = __webpack_require__( /*! ../widget/ui.widget */ 18),
            ValidationMixin = __webpack_require__( /*! ../validation/validation_mixin */ 172),
            Overlay = __webpack_require__( /*! ../overlay */ 59);
        var READONLY_STATE_CLASS = "dx-state-readonly",
            INVALID_CLASS = "dx-invalid",
            INVALID_MESSAGE = "dx-invalid-message",
            INVALID_MESSAGE_AUTO = "dx-invalid-message-auto",
            INVALID_MESSAGE_ALWAYS = "dx-invalid-message-always",
            VALIDATION_TARGET = "dx-validation-target",
            VALIDATION_MESSAGE_MIN_WIDTH = 100;
        var Editor = Widget.inherit({
            ctor: function() {
                this.showValidationMessageTimeout = null;
                this.callBase.apply(this, arguments)
            },
            _init: function() {
                this.callBase();
                this.validationRequest = Callbacks();
                this._initInnerOptionCache("validationTooltipOptions");
                var $element = this.$element();
                if ($element) {
                    dataUtils.data($element[0], VALIDATION_TARGET, this)
                }
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    },
                    validationTooltipOptions: {}
                })
            },
            _attachKeyboardEvents: function() {
                if (this.option("readOnly")) {
                    return
                }
                this.callBase();
                if (this._keyboardProcessor) {
                    this._attachChildKeyboardEvents()
                }
            },
            _attachChildKeyboardEvents: commonUtils.noop,
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _focusInHandler: function(e) {
                var _this = this;
                var isValidationMessageShownOnFocus = "auto" === this.option("validationMessageMode");
                if (this._canValueBeChangedByClick() && isValidationMessageShownOnFocus) {
                    this._$validationMessage && this._$validationMessage.removeClass(INVALID_MESSAGE_AUTO);
                    clearTimeout(this.showValidationMessageTimeout);
                    this.showValidationMessageTimeout = setTimeout(function() {
                        return _this._$validationMessage && _this._$validationMessage.addClass(INVALID_MESSAGE_AUTO)
                    }, 150)
                }
                return this.callBase(e)
            },
            _canValueBeChangedByClick: function() {
                return false
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid"),
                    validationError = this.option("validationError"),
                    validationMessageMode = this.option("validationMessageMode"),
                    $element = this.$element();
                $element.toggleClass(INVALID_CLASS, !isValid);
                this.setAria("invalid", !isValid || void 0);
                if (!windowUtils.hasWindow()) {
                    return
                }
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this._$validationMessage = null
                }
                if (!isValid && validationError && validationError.message) {
                    this._$validationMessage = $("<div>").addClass(INVALID_MESSAGE).html(validationError.message).appendTo($element);
                    this._validationMessage = this._createComponent(this._$validationMessage, Overlay, extend({
                        integrationOptions: {},
                        templatesRenderAsynchronously: false,
                        target: this._getValidationMessageTarget(),
                        shading: false,
                        width: "auto",
                        height: "auto",
                        container: $element,
                        position: this._getValidationMessagePosition("below"),
                        closeOnOutsideClick: false,
                        closeOnTargetScroll: false,
                        animation: null,
                        visible: true,
                        propagateOutsideClick: true,
                        _checkParentVisibility: false
                    }, this._getInnerOptionsCache("validationTooltipOptions")));
                    this._$validationMessage.toggleClass(INVALID_MESSAGE_AUTO, "auto" === validationMessageMode).toggleClass(INVALID_MESSAGE_ALWAYS, "always" === validationMessageMode);
                    this._setValidationMessageMaxWidth();
                    this._bindInnerWidgetOptions(this._validationMessage, "validationTooltipOptions")
                }
            },
            _setValidationMessageMaxWidth: function() {
                if (!this._validationMessage) {
                    return
                }
                if (0 === this._getValidationMessageTarget().outerWidth()) {
                    this._validationMessage.option("maxWidth", "100%");
                    return
                }
                var validationMessageMaxWidth = Math.max(VALIDATION_MESSAGE_MIN_WIDTH, this._getValidationMessageTarget().outerWidth());
                this._validationMessage.option("maxWidth", validationMessageMaxWidth)
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _getValidationMessagePosition: function(positionRequest) {
                var rtlEnabled = this.option("rtlEnabled"),
                    messagePositionSide = getDefaultAlignment(rtlEnabled),
                    messageOriginalOffset = this.option("validationMessageOffset"),
                    messageOffset = {
                        h: messageOriginalOffset.h,
                        v: messageOriginalOffset.v
                    },
                    verticalPositions = "below" === positionRequest ? [" top", " bottom"] : [" bottom", " top"];
                if (rtlEnabled) {
                    messageOffset.h = -messageOffset.h
                }
                if ("below" !== positionRequest) {
                    messageOffset.v = -messageOffset.v
                }
                return {
                    offset: messageOffset,
                    boundary: this.option("validationBoundary"),
                    my: messagePositionSide + verticalPositions[0],
                    at: messagePositionSide + verticalPositions[1],
                    collision: "none flip"
                }
            },
            _toggleReadOnlyState: function() {
                this.$element().toggleClass(READONLY_STATE_CLASS, !!this.option("readOnly"));
                this.setAria("readonly", this.option("readOnly") || void 0)
            },
            _dispose: function() {
                var element = this.$element()[0];
                dataUtils.data(element, VALIDATION_TARGET, null);
                clearTimeout(this.showValidationMessageTimeout);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "isValid":
                    case "validationError":
                    case "validationBoundary":
                    case "validationMessageMode":
                        this._renderValidationState();
                        break;
                    case "validationTooltipOptions":
                        this._innerOptionChanged(this._validationMessage, args);
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        this._setValidationMessageMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        }).include(ValidationMixin);
        module.exports = Editor
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/viz/themes.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var defaultTheme, extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            vizUtils = __webpack_require__( /*! ./core/utils */ 10),
            uiThemes = __webpack_require__( /*! ../ui/themes */ 30),
            themes = {},
            themesMapping = {},
            themesSchemeMapping = {},
            _extend = extend,
            _each = each,
            _normalizeEnum = vizUtils.normalizeEnum,
            currentThemeName = null,
            nextCacheUid = 0,
            widgetsCache = {};

        function getTheme(themeName) {
            var name = _normalizeEnum(themeName);
            return themes[name] || themes[themesMapping[name] || currentTheme()]
        }

        function findThemeNameByName(name, scheme) {
            return themesMapping[name + "." + scheme] || themesSchemeMapping[name + "." + scheme] || themesMapping[name]
        }

        function findThemeNameByPlatform(platform, version, scheme) {
            return findThemeNameByName(platform + version, scheme) || findThemeNameByName(platform, scheme)
        }

        function currentTheme(themeName, colorScheme) {
            if (!arguments.length) {
                return currentThemeName || findThemeNameByName(uiThemes.current()) || defaultTheme
            }
            var scheme = _normalizeEnum(colorScheme);
            currentThemeName = (themeName && themeName.platform ? findThemeNameByPlatform(_normalizeEnum(themeName.platform), themeName.version, scheme) : findThemeNameByName(_normalizeEnum(themeName), scheme)) || currentThemeName;
            return this
        }

        function getThemeInfo(themeName, splitter) {
            var k = themeName.indexOf(splitter);
            return k > 0 ? {
                name: themeName.substring(0, k),
                scheme: themeName.substring(k + 1)
            } : null
        }

        function registerThemeName(themeName, targetThemeName) {
            var themeInfo = getThemeInfo(themeName, ".") || {
                    name: themeName
                },
                name = themeInfo.name,
                scheme = themeInfo.scheme;
            if (scheme) {
                themesMapping[name] = themesMapping[name] || targetThemeName;
                themesMapping[name + "." + scheme] = targetThemeName
            } else {
                themesMapping[name] = targetThemeName
            }
        }

        function registerTheme(theme, baseThemeName) {
            var themeName = _normalizeEnum(theme && theme.name);
            if (themeName) {
                theme.isDefault && (defaultTheme = themeName);
                registerThemeName(themeName, themeName);
                themes[themeName] = _extend(true, {}, getTheme(baseThemeName), patchTheme(theme))
            }
        }

        function registerThemeAlias(alias, theme) {
            registerThemeName(_normalizeEnum(alias), _normalizeEnum(theme))
        }

        function registerThemeSchemeAlias(from, to) {
            themesSchemeMapping[from] = to
        }

        function mergeScalar(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value && void 0 === target[field]) {
                target[field] = _value
            }
        }

        function mergeObject(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value) {
                target[field] = _extend(true, {}, _value, target[field])
            }
        }

        function patchTheme(theme) {
            theme = _extend(true, {
                loadingIndicator: {
                    font: {}
                },
                "export": {
                    font: {}
                },
                legend: {
                    font: {},
                    border: {}
                },
                title: {
                    font: {}
                },
                tooltip: {
                    font: {}
                },
                "chart:common": {},
                "chart:common:axis": {
                    grid: {},
                    minorGrid: {},
                    tick: {},
                    minorTick: {},
                    title: {
                        font: {}
                    },
                    label: {
                        font: {}
                    }
                },
                chart: {
                    commonSeriesSettings: {
                        candlestick: {}
                    }
                },
                pie: {},
                polar: {},
                gauge: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    }
                },
                barGauge: {},
                funnel: {},
                sankey: {},
                map: {
                    background: {}
                },
                treeMap: {
                    tile: {
                        selectionStyle: {
                            border: {}
                        }
                    },
                    group: {
                        border: {},
                        selectionStyle: {
                            border: {}
                        },
                        label: {
                            font: {}
                        }
                    }
                },
                rangeSelector: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    },
                    chart: {}
                },
                sparkline: {},
                bullet: {}
            }, theme);
            mergeScalar(theme.loadingIndicator, "backgroundColor", theme);
            mergeScalar(theme.chart.commonSeriesSettings.candlestick, "innerColor", null, theme.backgroundColor);
            mergeScalar(theme.map.background, "color", null, theme.backgroundColor);
            mergeScalar(theme.title.font, "color", null, theme.primaryTitleColor);
            mergeObject(theme.title, "subtitle", null, theme.title);
            mergeScalar(theme.legend.font, "color", null, theme.secondaryTitleColor);
            mergeScalar(theme.legend.border, "color", null, theme.gridColor);
            patchAxes(theme);
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sparkline", "bullet", "sankey"], function(_, section) {
                mergeScalar(theme[section], "redrawOnResize", theme);
                mergeScalar(theme[section], "containerBackgroundColor", null, theme.backgroundColor);
                mergeObject(theme[section], "tooltip", theme);
                mergeObject(theme[section], "export", theme)
            });
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sankey"], function(_, section) {
                mergeObject(theme[section], "loadingIndicator", theme);
                mergeObject(theme[section], "legend", theme);
                mergeObject(theme[section], "title", theme)
            });
            _each(["chart", "pie", "polar"], function(_, section) {
                mergeObject(theme, section, null, theme["chart:common"])
            });
            _each(["chart", "polar"], function(_, section) {
                theme[section] = theme[section] || {};
                mergeObject(theme[section], "commonAxisSettings", null, theme["chart:common:axis"])
            });
            mergeObject(theme.rangeSelector.chart, "commonSeriesSettings", theme.chart);
            mergeObject(theme.rangeSelector.chart, "dataPrepareSettings", theme.chart);
            mergeScalar(theme.treeMap.group.border, "color", null, theme.gridColor);
            mergeScalar(theme.treeMap.tile.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.treeMap.group.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.map.legend, "backgroundColor", theme);
            patchMapLayers(theme);
            return theme
        }

        function patchAxes(theme) {
            var commonAxisSettings = theme["chart:common:axis"],
                colorFieldName = "color";
            _each([commonAxisSettings.grid, commonAxisSettings.minorGrid], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.gridColor)
            });
            _each([commonAxisSettings, commonAxisSettings.tick, commonAxisSettings.minorTick, commonAxisSettings.label.font], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.axisColor)
            });
            mergeScalar(commonAxisSettings.title.font, colorFieldName, null, theme.secondaryTitleColor);
            mergeScalar(theme.gauge.scale.label.font, colorFieldName, null, theme.axisColor);
            mergeScalar(theme.gauge.scale.tick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.gauge.scale.minorTick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.rangeSelector.scale.label.font, colorFieldName, null, theme.axisColor)
        }

        function patchMapLayers(theme) {
            var map = theme.map;
            _each(["area", "line", "marker"], function(_, section) {
                mergeObject(map, "layer:" + section, null, map.layer)
            });
            _each(["dot", "bubble", "pie", "image"], function(_, section) {
                mergeObject(map, "layer:marker:" + section, null, map["layer:marker"])
            })
        }

        function addCacheItem(target) {
            var cacheUid = ++nextCacheUid;
            target._cache = cacheUid;
            widgetsCache[cacheUid] = target
        }

        function removeCacheItem(target) {
            delete widgetsCache[target._cache]
        }

        function refreshTheme() {
            _each(widgetsCache, function() {
                this.refresh()
            });
            return this
        }
        _extend(exports, {
            currentTheme: currentTheme,
            registerTheme: registerTheme,
            getTheme: getTheme,
            registerThemeAlias: registerThemeAlias,
            registerThemeSchemeAlias: registerThemeSchemeAlias,
            refreshTheme: refreshTheme,
            addCacheItem: addCacheItem,
            removeCacheItem: removeCacheItem
        });
        _extend(exports, {
            themes: themes,
            themesMapping: themesMapping,
            themesSchemeMapping: themesSchemeMapping,
            widgetsCache: widgetsCache,
            resetCurrentTheme: function() {
                currentThemeName = null
            }
        })
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/localization/number.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _slicedToArray = function() {
            function sliceIterator(arr, i) {
                var _arr = [];
                var _n = true;
                var _d = false;
                var _e = void 0;
                try {
                    for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                        _arr.push(_s.value);
                        if (i && _arr.length === i) {
                            break
                        }
                    }
                } catch (err) {
                    _d = true;
                    _e = err
                } finally {
                    try {
                        if (!_n && _i.return) {
                            _i.return()
                        }
                    } finally {
                        if (_d) {
                            throw _e
                        }
                    }
                }
                return _arr
            }
            return function(arr, i) {
                if (Array.isArray(arr)) {
                    return arr
                } else {
                    if (Symbol.iterator in Object(arr)) {
                        return sliceIterator(arr, i)
                    } else {
                        throw new TypeError("Invalid attempt to destructure non-iterable instance")
                    }
                }
            }
        }();
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 54),
            inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray,
            escapeRegExp = __webpack_require__( /*! ../core/utils/common */ 4).escapeRegExp,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 1).isPlainObject,
            ldmlNumber = __webpack_require__( /*! ./ldml/number */ 277),
            config = __webpack_require__( /*! ../core/config */ 31),
            errors = __webpack_require__( /*! ../core/errors */ 21),
            toFixed = __webpack_require__( /*! ./utils */ 255).toFixed;
        var MAX_LARGE_NUMBER_POWER = 4,
            DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = dependencyInjector({
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatList, formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                formatList = formatType.toLowerCase().split(" ");
                each(formatList, function(index, value) {
                    if (inArray(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value),
                    power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                var powerPostfix;
                var result;
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var powString, power = this._calculateNumberPower(value, DECIMAL_BASE),
                    number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, config().thousandsSeparator) + (parts[1] ? config().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : toFixed(value, formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", config().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!isPlainObject(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e4, "fixedPoint")[2]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0",
                    toFirstDigit = toStandard ? "0" : digits[1],
                    fromLastDigit = toStandard ? digits[0] : "9",
                    regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var separators = this._getSeparators(),
                    regExp = new RegExp("[0-9" + escapeRegExp(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g"),
                    negativeEtalon = this.format(-1, format).replace(regExp, "1"),
                    cleanedText = text.replace(regExp, "1");
                return cleanedText === negativeEtalon ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    return this.convertDigits(ldmlNumber.getFormatter(_format.type, this._getSeparators())(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    errors.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator(),
                    regExp = new RegExp("[^0-9" + escapeRegExp(decimalSeparator) + "]", "g"),
                    cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, "");
                if ("." === cleanedText || "" === cleanedText) {
                    return null
                }
                if (this._calcSignificantDigits(cleanedText) > 15) {
                    return NaN
                }
                var parsed = +cleanedText;
                return parsed * this.getSign(text, format)
            },
            _calcSignificantDigits: function(text) {
                var _text$split = text.split("."),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    integer = _text$split2[0],
                    fractional = _text$split2[1];
                var calcDigitsAfterLeadingZeros = function(digits) {
                    var index = -1;
                    for (var i = 0; i < digits.length; i++) {
                        if ("0" !== digits[i]) {
                            index = i;
                            break
                        }
                    }
                    return index > -1 ? digits.length - index : 0
                };
                var result = 0;
                if (integer) {
                    result += calcDigitsAfterLeadingZeros(integer.split(""))
                }
                if (fractional) {
                    result += calcDigitsAfterLeadingZeros(fractional.split("").reverse())
                }
                return result
            }
        });
        module.exports = numberLocalization
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/ui.collection_widget.edit.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _uiCollection_widget = __webpack_require__( /*! ./ui.collection_widget.base */ 465);
        var _uiCollection_widget2 = _interopRequireDefault(_uiCollection_widget);
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 17);
        var _ui2 = _interopRequireDefault(_ui);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _uiCollection_widgetEditStrategy = __webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 181);
        var _uiCollection_widgetEditStrategy2 = _interopRequireDefault(_uiCollection_widgetEditStrategy);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 44);
        var _selection = __webpack_require__( /*! ../selection/selection */ 282);
        var _selection2 = _interopRequireDefault(_selection);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting",
            NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = _uiCollection_widget2.default.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule();
                if ("multi" === this.option("selectionMode")) {
                    this._showDeprecatedSelectionMode()
                }
            },
            _initKeyGetter: function() {
                this._keyGetter = (0, _data.compileGetter)(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            key: function() {
                if (this.option("keyExpr")) {
                    return this.option("keyExpr")
                }
                return this._dataSource && this._dataSource.key()
            },
            keyOf: function(item) {
                var key = item,
                    store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _initSelectionModule: function() {
                var that = this,
                    itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new _selection2.default({
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: that.key.bind(that),
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        if (store) {
                            return store.load(options).done(function(loadResult) {
                                if (that._disposed) {
                                    return
                                }
                                var items = (0, _data_source.normalizeLoadResult)(loadResult).data;
                                that._dataSource._applyMapFunction(items)
                            })
                        } else {
                            return (new _deferred.Deferred).resolve(this.plainItems())
                        }
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = _uiCollection_widgetEditStrategy2.default;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this,
                    indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                (0, _iterator.each)(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                var _this = this;
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions().done(function() {
                        return _this._normalizeSelectedItems()
                    })
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem, selectedIndex;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedItem", selectedItem);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        var selectedItems = this.option("selectedItems") || [];
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItems[0]);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        this._setOptionSilent("selectedItem", selectedItems[0]);
                        this._setOptionSilent("selectedIndex", selectedIndex);
                        this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedIndex", selectedIndex);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        var selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired")) {
                            var selectedItemIndex = this._getIndexByKey(selectedItemKeys[0]);
                            if (!indexExists(selectedItemIndex)) {
                                return this._syncSelectionOptions("selectedIndex")
                            }
                        }
                        return this._selection.setSelection(selectedItemKeys)
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName),
                        length = (0, _type.isDefined)(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionSilent("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionSilent("selectedItems", [normalizedSelection]);
                            return this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: (0, _renderer2.default)(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" !== this.option("selectionMode")) {
                    var $itemElement = (0, _renderer2.default)(args.itemElement),
                        normalizedItemIndex = this._editStrategy.getNormalizedIndex($itemElement),
                        isItemSelected = this._isItemSelected(normalizedItemIndex);
                    this._processSelectableItem($itemElement, isItemSelected)
                }
            },
            _processSelectableItem: function($itemElement, isSelected) {
                $itemElement.toggleClass(this._selectedItemClass(), isSelected);
                this._setAriaSelected($itemElement, String(isSelected))
            },
            _updateSelectedItems: function(args) {
                var that = this,
                    addedItemKeys = args.addedItemKeys,
                    removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var normalizedIndex, i, addedSelection = [],
                            removedSelection = [];
                        that._editStrategy.beginCache();
                        for (i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (i = 0; i < removedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }(0, _deferred.when)(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: _common.noop,
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, false);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _showDeprecatedSelectionMode: function() {
                _ui2.default.log("W0001", this.NAME, "selectionMode: 'multi'", "16.1", "Use selectionMode: 'multiple' instead");
                this.option("selectionMode", "multiple")
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, true);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                var _this2 = this;
                switch (args.name) {
                    case "selectionMode":
                        if ("multi" === args.value) {
                            this._showDeprecatedSelectionMode()
                        } else {
                            this._invalidate()
                        }
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name).done(function() {
                            return _this2._normalizeSelectedItems()
                        });
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionSilent("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new _deferred.Deferred,
                    deletingActionArgs = {
                        cancel: false
                    },
                    deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                        excludeValidators: ["disabled", "readOnly"]
                    });
                (0, _deferred.when)(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise,
                        deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state(),
                        argumentsSpecified = !!arguments.length,
                        shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    (0, _deferred.when)((0, _deferred.fromPromise)(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                var deferred = new _deferred.Deferred,
                    disabledState = this.option("disabled"),
                    dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw _ui2.default.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new _deferred.Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    (0, _renderer2.default)(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof _data_source.DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys");
                    selectedItemKeys.push(key);
                    this._selection.setSelection(selectedItemKeys)
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            _deleteItemElementByIndex: function(index) {
                this._updateSelectionAfterDelete(index);
                this._updateIndicesAfterIndex(index);
                this._editStrategy.deleteItemAtIndex(index)
            },
            _afterItemElementDeleted: function($item, deletedActionArgs) {
                var changingOption = this._dataSource ? "dataSource" : "items";
                this._simulateOptionChange(changingOption);
                this._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                    beforeExecute: function() {
                        $item.remove()
                    },
                    excludeValidators: ["disabled", "readOnly"]
                });
                this._renderEmptyMessage()
            },
            deleteItem: function(itemElement) {
                var that = this,
                    deferred = new _deferred.Deferred,
                    $item = this._editStrategy.getItemElement(itemElement),
                    index = this._editStrategy.getNormalizedIndex(itemElement),
                    itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._deleteItemElementByIndex(index);
                            that._afterItemElementDeleted($item, deletedActionArgs);
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new _deferred.Deferred,
                    that = this,
                    strategy = this._editStrategy,
                    $movingItem = strategy.getItemElement(itemElement),
                    $destinationItem = strategy.getItemElement(toItemElement),
                    movingIndex = strategy.getNormalizedIndex(itemElement),
                    destinationIndex = strategy.getNormalizedIndex(toItemElement),
                    changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        module.exports = CollectionWidget
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date_serialization.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 31),
            getLDMLFormatter = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 256).getFormatter,
            defaultDateNames = __webpack_require__( /*! ../../localization/default_date_names */ 257),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isNumber = typeUtils.isNumeric;
        var NUMBER_SERIALIZATION_FORMAT = "number",
            DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd",
            DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var MILLISECOND_LENGHT = 3;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            var parsedValue;
            if (isString(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            if (!result) {
                parsedValue = !isDate(text) && Date.parse(text);
                result = isNumber(parsedValue) ? new Date(parsedValue) : text
            }
            return result
        };
        var parseISO8601String = function(text) {
            var parts = text.match(ISO8601_PATTERN);
            var timePart = function(part) {
                return +part || 0
            };
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, timePart(parts[1]), timePart(parts[2]), timePart(parts[4]))
                }
                return
            }
            var year = parts[1],
                month = --parts[3],
                day = parts[5],
                timeZoneHour = 0,
                timeZoneMinute = 0;
            timeZoneHour = timePart(parts[14]);
            timeZoneMinute = timePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = timePart(parts[6]) - timeZoneHour,
                minute = timePart(parts[8]) - timeZoneMinute,
                second = timePart(parts[10]),
                parseMilliseconds = function(part) {
                    part = part || "";
                    return timePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
                },
                millisecond = parseMilliseconds(parts[11]);
            if (parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        };
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN),
                result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !config().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!isDate(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return getLDMLFormatter(serializationFormat, defaultDateNames)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if (isString(value)) {
                    var format;
                    if (config().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        module.exports = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        }
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dependency_injector.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = function(object) {
            var extend = __webpack_require__( /*! ./extend */ 0).extend,
                isFunction = __webpack_require__( /*! ./type */ 1).isFunction,
                each = __webpack_require__( /*! ./iterator */ 3).each,
                Class = __webpack_require__( /*! ../class */ 15);
            var BaseClass = Class.inherit(object),
                InjectedClass = BaseClass,
                instance = new InjectedClass(object),
                initialFields = {};
            var injectFields = function(injectionObject, initial) {
                each(injectionObject, function(key) {
                    if (isFunction(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                extend(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/drag.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ../core/element_data */ 39),
            wrapToArray = __webpack_require__( /*! ../core/utils/array */ 13).wrapToArray,
            inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray,
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            contains = __webpack_require__( /*! ../core/utils/dom */ 12).contains,
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 158),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95);
        var DRAG_START_EVENT = "dxdragstart",
            DRAG_EVENT = "dxdrag",
            DRAG_END_EVENT = "dxdragend",
            DRAG_ENTER_EVENT = "dxdragenter",
            DRAG_LEAVE_EVENT = "dxdragleave",
            DROP_EVENT = "dxdrop",
            DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [],
            knownDropTargetSelectors = [],
            knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = inArray(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = inArray(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if (inArray(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = inArray(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    dataUtils.removeData(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        registerEvent(DRAG_ENTER_EVENT, dropTargetRegistration);
        registerEvent(DRAG_LEAVE_EVENT, dropTargetRegistration);
        registerEvent(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets),
                dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex];
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if (inArray(void 0, dropTargetSelectors) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = GestureEmitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = wrapToArray(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return $(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = eventUtils.eventData(e),
                    dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e),
                    sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                eventUtils.fireEvent(eventData)
            },
            _findDropTarget: function(e) {
                var result, that = this;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = $(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = $(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || contains(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, e) {
                var isDraggingElement = $target.get(0) === this._$element.get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = eventUtils.eventData(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        registerEmitter({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        });
        exports.dropTargets = knownDropTargets;
        exports.move = DRAG_EVENT;
        exports.start = DRAG_START_EVENT;
        exports.end = DRAG_END_EVENT;
        exports.enter = DRAG_ENTER_EVENT;
        exports.leave = DRAG_LEAVE_EVENT;
        exports.drop = DROP_EVENT
    }, ,
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ajax.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Deferred = __webpack_require__( /*! ./deferred */ 6).Deferred;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11);
        var httpRequest = __webpack_require__( /*! ../../core/http_request */ 437);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var extendFromObject = __webpack_require__( /*! ./extend */ 0).extendFromObject;
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined;
        var Promise = __webpack_require__( /*! ../polyfills/promise */ 82);
        var injector = __webpack_require__( /*! ./dependency_injector */ 54);
        var SUCCESS = "success",
            ERROR = "error",
            TIMEOUT = "timeout",
            NO_CONTENT = "nocontent",
            PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = domAdapter.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return domAdapter.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new Promise(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    domAdapter.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*",
                scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",
                accepts = {
                    "*": "*/*",
                    text: "text/plain",
                    html: "text/html",
                    xml: "application/xml, text/xml",
                    json: "application/json, text/javascript",
                    jsonp: scriptAccept,
                    script: scriptAccept
                };
            extendFromObject(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!windowUtils.hasWindow()) {
                return true
            }
            var crossDomain = false,
                originAnchor = domAdapter.createElement("a"),
                urlAnchor = domAdapter.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, ""),
                    callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random,
                    callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data,
                paramsAlreadyString = "string" === typeof params,
                url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };
        var getMethod = function(options) {
            return (options.method || "GET").toUpperCase()
        };
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var timeoutId, xhr = httpRequest.getXhr(),
                d = new Deferred,
                result = d.promise(),
                async = isDefined(options.async) ? options.async : true, dataType = options.dataType, timeout = options.timeout || 0;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options),
                headers = getRequestHeaders(options),
                requestOptions = getRequestOptions(options, headers),
                url = requestOptions.url,
                parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                        d.reject(xhr, ERROR)
                    },
                    resolve = function() {
                        if ("jsonp" === dataType) {
                            return
                        }
                        d.resolve(null, SUCCESS, xhr)
                    };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (Object.prototype.hasOwnProperty.call(headers, name) && isDefined(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        module.exports = injector({
            sendRequest: sendRequest
        })
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/overlay.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./overlay/ui.overlay */ 462)
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/icon.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ICON_CLASS = "dx-icon";
        var SVG_ICON_CLASS = "dx-svg-icon";
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(source)) {
                return "svg"
            }
            if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            if (/^\s?([\w-_]\s?)+$/.test(source)) {
                return "fontIcon"
            }
            return false
        };
        var getImageContainer = function(source) {
            switch (getImageSourceType(source)) {
                case "image":
                    return (0, _renderer2.default)("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + source);
                case "dxIcon":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + ICON_CLASS + "-" + source);
                case "svg":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + SVG_ICON_CLASS).append(source);
                default:
                    return null
            }
        };
        exports.getImageSourceType = getImageSourceType;
        exports.getImageContainer = getImageContainer
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/version.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = function(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10),
                    yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/call_once.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        module.exports = callOnce
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/format_helper.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./core/utils/type */ 1),
            dateUtils = __webpack_require__( /*! ./core/utils/date */ 22),
            numberLocalization = __webpack_require__( /*! ./localization/number */ 51),
            dateLocalization = __webpack_require__( /*! ./localization/date */ 33),
            dependencyInjector = __webpack_require__( /*! ./core/utils/dependency_injector */ 54);
        __webpack_require__( /*! ./localization/currency */ 152);
        module.exports = dependencyInjector({
            format: function(value, _format) {
                var formatIsValid = typeUtils.isString(_format) && "" !== _format || typeUtils.isPlainObject(_format) || typeUtils.isFunction(_format),
                    valueIsValid = typeUtils.isNumeric(value) || typeUtils.isDate(value);
                if (!formatIsValid || !valueIsValid) {
                    return typeUtils.isDefined(value) ? value.toString() : ""
                }
                if (typeUtils.isFunction(_format)) {
                    return _format(value)
                }
                if (typeUtils.isString(_format)) {
                    _format = {
                        type: _format
                    }
                }
                if (typeUtils.isNumeric(value)) {
                    return numberLocalization.format(value, _format)
                }
                if (typeUtils.isDate(value)) {
                    return dateLocalization.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return dateLocalization.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [],
                    needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return dateLocalization.getMonthNames("abbreviated")[date.getMonth()] + " " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return dateLocalization.format(date, "dayofweek") + ", " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var resultFormat, maxDiff, currentDiff, i;
                if (ticks.length > 1) {
                    maxDiff = dateUtils.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = dateUtils.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var resultFormat, dateDifferences, dateUnitInterval, dateDifferencesConverter = {
                        week: "day"
                    },
                    correctDateDifferences = function(dateDifferences, tickInterval, value) {
                        switch (tickInterval) {
                            case "year":
                            case "quarter":
                                dateDifferences.month = value;
                            case "month":
                                dateDifferences.day = value;
                            case "week":
                            case "day":
                                dateDifferences.hour = value;
                            case "hour":
                                dateDifferences.minute = value;
                            case "minute":
                                dateDifferences.second = value;
                            case "second":
                                dateDifferences.millisecond = value
                        }
                    },
                    correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                        if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                            if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                differences.millisecond = true;
                                differences.second = false
                            }
                        } else {
                            if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                    differences.second = true;
                                    differences.minute = false
                                }
                            } else {
                                if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else {
                                    if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                        if (maxDate.getDate() - minDate.getDate() === 1) {
                                            differences.hour = true;
                                            differences.day = false
                                        }
                                    } else {
                                        if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                            if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                                differences.day = true;
                                                differences.month = false
                                            }
                                        } else {
                                            if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                                if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                    differences.month = true;
                                                    differences.year = false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    };
                tickInterval = typeUtils.isString(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                dateDifferences = dateUtils.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = dateUtils.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = dateUtils.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        })
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/bindable_template.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 73),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            removeEvent = __webpack_require__( /*! ../../core/remove_event */ 132),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            isPrimitive = __webpack_require__( /*! ../../core/utils/type */ 1).isPrimitive;
        var watchChanges = function() {
            var start = function(rawData, watchMethod, fields, fieldsMap, callback) {
                var globalDispose, fieldsDispose;
                globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if (isPrimitive(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, function(data) {
                        callback(data)
                    })
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            };
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {},
                    missedFields = fields.slice();
                var watchHandlers = iteratorUtils.map(fields, function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    iteratorUtils.each(watchHandlers, function(_, dispose) {
                        dispose()
                    })
                }
            };
            return start
        }();
        module.exports = TemplateBase.inherit({
            ctor: function(render, fields, watchMethod, fieldsMap) {
                this._render = render;
                this._fields = fields;
                this._fieldsMap = fieldsMap || {};
                this._watchMethod = watchMethod
            },
            _renderCore: function(options) {
                var $container = $(options.container);
                var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                    $container.empty();
                    this._render($container, data, options.model)
                }.bind(this));
                eventsEngine.on($container, removeEvent, dispose);
                return $container.contents()
            }
        })
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/selectors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11);
        var _focusable = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase(),
                isTabIndexNotNaN = !isNaN(tabIndex),
                isDisabled = element.disabled,
                isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName),
                isHyperlink = "a" === nodeName,
                isFocusable = true,
                isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };
        var visible = function(element) {
            var $element = $(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        };
        module.exports = {
            focusable: function(index, element) {
                return _focusable(element, $(element).attr("tabIndex"))
            },
            tabbable: function(index, element) {
                var tabIndex = $(element).attr("tabIndex");
                return (isNaN(tabIndex) || tabIndex >= 0) && _focusable(element, tabIndex)
            },
            focused: function($element) {
                var element = $($element).get(0);
                return domAdapter.getActiveElement() === element
            }
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/dom_component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            config = __webpack_require__( /*! ./config */ 31),
            errors = __webpack_require__( /*! ./errors */ 21),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 12).getPublicElement,
            windowResizeCallbacks = __webpack_require__( /*! ../core/utils/resize_callbacks */ 130),
            commonUtils = __webpack_require__( /*! ./utils/common */ 4),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            inArray = __webpack_require__( /*! ./utils/array */ 13).inArray,
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 131),
            dataUtils = __webpack_require__( /*! ./element_data */ 39),
            Component = __webpack_require__( /*! ./component */ 133),
            abstract = Component.abstract;
        var RTL_DIRECTION_CLASS = "dx-rtl",
            VISIBILITY_CHANGE_CLASS = "dx-visibility-change-handler",
            VISIBILITY_CHANGE_EVENTNAMESPACE = "VisibilityChange";
        var DOMComponent = Component.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: config().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                })
            },
            ctor: function(element, options) {
                this._$element = $(element);
                publicComponentUtils.attachInstanceToElement(this._$element, this, this._dispose);
                this._synchronizableOptionsForCreateComponent = ["rtlEnabled", "disabled", "templatesRenderAsynchronously"];
                this.callBase(options)
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    windowResizeCallbacks.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                if (windowUtils.hasWindow()) {
                    this._render()
                }
            },
            _initMarkup: function() {
                this._renderElementAttributes();
                this._toggleRTLDirection(this.option("rtlEnabled"));
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var attributes = extend({}, this.option("elementAttr")),
                    classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                this.$element().addClass(VISIBILITY_CHANGE_CLASS)
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: width,
                        height: height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!(width || height || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var that = this;
                var resizeEventName = "dxresize." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                eventsEngine.off(that.$element(), resizeEventName);
                eventsEngine.on(that.$element(), resizeEventName, function() {
                    that._dimensionChanged()
                })
            },
            _attachVisibilityChangeHandlers: function() {
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                var that = this;
                var hidingEventName = "dxhiding." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                var shownEventName = "dxshown." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                that._isHidden = !that._isVisible();
                eventsEngine.off(that.$element(), hidingEventName);
                eventsEngine.on(that.$element(), hidingEventName, function() {
                    that._checkVisibilityChanged("hiding")
                });
                eventsEngine.off(that.$element(), shownEventName);
                eventsEngine.on(that.$element(), shownEventName, function() {
                    that._checkVisibilityChanged("shown")
                })
            },
            _isVisible: function() {
                return this.$element().is(":visible")
            },
            _checkVisibilityChanged: function(event) {
                if ("hiding" === event && this._isVisible() && !this._isHidden) {
                    this._visibilityChanged(false);
                    this._isHidden = true
                } else {
                    if ("shown" === event && this._isVisible() && this._isHidden) {
                        this._isHidden = false;
                        this._visibilityChanged(true)
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && windowUtils.hasWindow()
            },
            _clean: commonUtils.noop,
            _modelByElement: function() {
                var modelByElement = this.option("modelByElement") || commonUtils.noop;
                return modelByElement(this.$element())
            },
            _invalidate: function() {
                if (!this._updateLockCount) {
                    throw errors.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    windowResizeCallbacks.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                this.$element().toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _createComponent: function(element, component, config) {
                var that = this;
                config = config || {};
                var synchronizableOptions = commonUtils.grep(this._synchronizableOptionsForCreateComponent, function(value) {
                    return !(value in config)
                });
                var nestedComponentOptions = that.option("nestedComponentOptions") || commonUtils.noop;
                that._extendConfig(config, extend({
                    integrationOptions: this.option("integrationOptions"),
                    rtlEnabled: this.option("rtlEnabled"),
                    disabled: this.option("disabled"),
                    templatesRenderAsynchronously: this.option("templatesRenderAsynchronously")
                }, nestedComponentOptions(this)));
                var instance;
                if (typeUtils.isString(component)) {
                    var $element = $(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(args) {
                        if (inArray(args.name, synchronizableOptions) >= 0) {
                            instance.option(args.name, args.value)
                        }
                    };
                    that.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        that.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                each(extendConfig, function(key, value) {
                    config[key] = Object.prototype.hasOwnProperty.call(config, key) ? config[key] : value
                })
            },
            _defaultActionConfig: function() {
                return extend(this.callBase(), {
                    context: this._modelByElement(this.$element())
                })
            },
            _defaultActionArgs: function() {
                var model = this._modelByElement(this.$element());
                return extend(this.callBase(), {
                    element: this.element(),
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                        this._invalidate();
                        break;
                    case "elementAttr":
                        this._renderElementAttributes();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var i = element.attributes.length - 1;
                for (; i >= 0; i--) {
                    var attribute = element.attributes[i];
                    if (!attribute) {
                        return
                    }
                    var attributeName = attribute.name;
                    if (0 === attributeName.indexOf("aria-") || attributeName.indexOf("dx-") !== -1 || "role" === attributeName || "style" === attributeName || "tabindex" === attributeName) {
                        element.removeAttribute(attributeName)
                    }
                }
            },
            _removeClasses: function(element) {
                var classes = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                });
                element.className = classes.join(" ")
            },
            endUpdate: function() {
                var requireRender = !this._initializing && !this._initialized;
                this.callBase.apply(this, arguments);
                if (!this._updateLockCount) {
                    if (requireRender) {
                        this._renderComponent()
                    } else {
                        if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    }
                }
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                return getPublicElement(this.$element())
            },
            dispose: function() {
                var element = this.$element().get(0);
                dataUtils.cleanDataRecursive(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            }
        });
        DOMComponent.getInstance = function(element) {
            return publicComponentUtils.getInstanceByElement($(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        module.exports = DOMComponent
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_store.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _utils = __webpack_require__( /*! ./utils */ 40);
        var _query = __webpack_require__( /*! ./query */ 41);
        var _query2 = _interopRequireDefault(_query);
        var _errors = __webpack_require__( /*! ./errors */ 36);
        var _abstract_store = __webpack_require__( /*! ./abstract_store */ 98);
        var _abstract_store2 = _interopRequireDefault(_abstract_store);
        var _array_utils = __webpack_require__( /*! ./array_utils */ 135);
        var _array_utils2 = _interopRequireDefault(_array_utils);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ArrayStore = _abstract_store2.default.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw _errors.errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return (0, _query2.default)(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = _array_utils2.default.indexByKey(this, this._array, key);
                if (index === -1) {
                    return (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                }
                return (0, _utils.trivialPromise)(this._array[index])
            },
            _insertImpl: function(values) {
                return _array_utils2.default.insert(this, this._array, values)
            },
            _pushImpl: function(changes) {
                _array_utils2.default.applyBatch(this, this._array, changes)
            },
            _updateImpl: function(key, values) {
                return _array_utils2.default.update(this, this._array, key, values)
            },
            _removeImpl: function(key) {
                return _array_utils2.default.remove(this, this._array, key)
            },
            clear: function() {
                this.fireEvent("modifying");
                this._array = [];
                this.fireEvent("modified")
            }
        }, "array");
        module.exports = ArrayStore
    }, ,
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/viz/tree_map/tree_map.base.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _common = __webpack_require__( /*! ./common */ 249);
        var _node = __webpack_require__( /*! ./node */ 166);
        var _node2 = _interopRequireDefault(_node);
        var _tiling = __webpack_require__( /*! ./tiling */ 120);
        var _colorizing = __webpack_require__( /*! ./colorizing */ 121);
        var _utils = __webpack_require__( /*! ../core/utils */ 10);
        var _common2 = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 0);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _max = Math.max;
        var directions = {
            lefttoprightbottom: [1, 1],
            leftbottomrighttop: [1, -1],
            righttopleftbottom: [-1, 1],
            rightbottomlefttop: [-1, -1]
        };
        __webpack_require__( /*! ./tiling.squarified */ 417);
        __webpack_require__( /*! ./tiling */ 120).setDefaultAlgorithm("squarified");
        __webpack_require__( /*! ./colorizing.discrete */ 419);
        __webpack_require__( /*! ./colorizing */ 121).setDefaultColorizer("discrete");

        function pickPositiveInteger(val) {
            return val > 0 ? Math.round(val) : 0
        }
        var dxTreeMap = __webpack_require__( /*! ../core/base_widget */ 96).inherit({
            _handlers: {
                beginBuildNodes: _common2.noop,
                buildNode: _common2.noop,
                endBuildNodes: _common2.noop,
                setTrackerData: _common2.noop,
                calculateState: function(options) {
                    return (0, _common.buildRectAppearance)(options)
                }
            },
            _rootClass: "dxtm-tree-map",
            _rootClassPrefix: "dxtm",
            _getDefaultSize: function() {
                return {
                    width: 400,
                    height: 400
                }
            },
            _setDeprecatedOptions: function() {
                this.callBase.apply(this, arguments);
                (0, _extend2.extend)(this._deprecatedOptions, {
                    resolveLabelOverflow: {
                        since: "19.1",
                        message: "Use the 'tile.label.overflow' and 'group.label.textOverflow' option instead"
                    }
                })
            },
            _themeSection: "treeMap",
            _fontFields: ["tile.label.font", "group.label.font"],
            _init: function() {
                var that = this;
                that._rectOffsets = {};
                that._handlers = Object.create(that._handlers);
                that._context = {
                    suspend: function() {
                        if (!that._applyingChanges) {
                            that._suspendChanges()
                        }
                    },
                    resume: function() {
                        if (!that._applyingChanges) {
                            that._resumeChanges()
                        }
                    },
                    change: function(codes) {
                        that._change(codes)
                    },
                    settings: [{}, {}],
                    calculateState: that._handlers.calculateState,
                    calculateLabelState: _common.buildTextAppearance
                };
                that._root = that._topNode = {
                    nodes: []
                };
                that.callBase.apply(that, arguments)
            },
            _initialChanges: ["DATA_SOURCE"],
            _initCore: function() {
                var that = this,
                    renderer = that._renderer;
                that._createProxyType();
                that._tilesGroup = renderer.g().linkOn(renderer.root, "tiles").linkAppend();
                that._labelsGroup = renderer.g().linkOn(renderer.root, "labels").linkAppend()
            },
            _createProxyType: _common2.noop,
            _disposeCore: function() {
                var that = this;
                that._filter && that._filter.dispose();
                that._labelsGroup.linkOff();
                that._tilesGroup.linkOff()
            },
            _applySize: function(rect) {
                this._tilingRect = rect.slice();
                this._change(["TILING"])
            },
            _optionChangesMap: {
                dataSource: "DATA_SOURCE",
                valueField: "NODES_CREATE",
                childrenField: "NODES_CREATE",
                colorField: "TILES",
                colorizer: "TILES",
                labelField: "LABELS",
                tile: "TILE_SETTINGS",
                group: "GROUP_SETTINGS",
                maxDepth: "MAX_DEPTH",
                layoutAlgorithm: "TILING",
                layoutDirection: "TILING",
                resolveLabelOverflow: "LABEL_OVERFLOW"
            },
            _themeDependentChanges: ["TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH"],
            _changeDataSource: function() {
                var that = this;
                that._isDataExpected = that._isSyncData = true;
                that._updateDataSource();
                that._isSyncData = false;
                if (that._isDataExpected) {
                    that._suspendChanges()
                }
            },
            _dataSourceChangedHandler: function() {
                var that = this;
                if (that._isDataExpected) {
                    that._isDataExpected = false;
                    that._change(["NODES_CREATE"]);
                    if (!that._isSyncData) {
                        that._resumeChanges()
                    }
                } else {
                    that._requestChange(["NODES_CREATE"])
                }
            },
            _optionChangesOrder: ["DATA_SOURCE", "TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH", "LABEL_OVERFLOW"],
            _change_DATA_SOURCE: function() {
                this._changeDataSource()
            },
            _change_TILE_SETTINGS: function() {
                this._changeTileSettings()
            },
            _change_GROUP_SETTINGS: function() {
                this._changeGroupSettings()
            },
            _change_LABEL_OVERFLOW: function() {
                this._changeTileSettings();
                this._changeGroupSettings()
            },
            _change_MAX_DEPTH: function() {
                this._changeMaxDepth()
            },
            _customChangesOrder: ["NODES_CREATE", "NODES_RESET", "TILES", "LABELS", "TILING", "LABELS_LAYOUT"],
            _change_NODES_CREATE: function() {
                this._buildNodes()
            },
            _change_NODES_RESET: function() {
                this._resetNodes()
            },
            _change_TILES: function() {
                this._applyTilesAppearance()
            },
            _change_LABELS: function() {
                this._applyLabelsAppearance()
            },
            _change_TILING: function() {
                this._performTiling()
            },
            _change_LABELS_LAYOUT: function() {
                this._performLabelsLayout()
            },
            _applyChanges: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                if (!that._isDataExpected) {
                    that._drawn()
                }
                that._context.forceReset = false
            },
            _buildNodes: function() {
                var processedData, that = this,
                    root = that._root = that._topNode = new _node2.default;
                root._id = 0;
                root.parent = {};
                root.data = {};
                root.level = root.index = -1;
                root.ctx = that._context;
                root.label = null;
                that._nodes = [root];
                that._handlers.beginBuildNodes();
                processedData = that._processDataSourceItems(that._dataSourceItems() || []);
                traverseDataItems(root, processedData.items, 0, {
                    itemsField: !processedData.isPlain && that._getOption("childrenField", true) || "items",
                    valueField: that._getOption("valueField", true) || "value",
                    buildNode: that._handlers.buildNode,
                    ctx: that._context,
                    nodes: that._nodes
                });
                that._onNodesCreated();
                that._handlers.endBuildNodes();
                that._change(["NODES_RESET"])
            },
            _onNodesCreated: _common2.noop,
            _processDataSourceItems: function(items) {
                return {
                    items: items,
                    isPlain: false
                }
            },
            _changeTileSettings: function() {
                var that = this,
                    options = that._getOption("tile"),
                    offsets = that._rectOffsets,
                    borderWidth = pickPositiveInteger(options.border.width),
                    edgeOffset = borderWidth / 2,
                    innerOffset = 1 & borderWidth ? .5 : 0,
                    labelOptions = options.label,
                    settings = that._context.settings[0];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._filter = that._filter || that._renderer.shadowFilter("-50%", "-50%", "200%", "200%");
                that._filter.attr(labelOptions.shadow);
                that._calculateLabelSettings(settings, labelOptions, that._filter.id);
                if (offsets.tileEdge !== edgeOffset || offsets.tileInner !== innerOffset) {
                    offsets.tileEdge = edgeOffset;
                    offsets.tileInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _changeGroupSettings: function() {
                var that = this,
                    options = that._getOption("group"),
                    labelOptions = options.label,
                    offsets = that._rectOffsets,
                    borderWidth = pickPositiveInteger(options.border.width),
                    edgeOffset = borderWidth / 2,
                    innerOffset = 1 & borderWidth ? .5 : 0,
                    headerHeight = 0,
                    groupPadding = pickPositiveInteger(options.padding),
                    settings = that._context.settings[1];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._calculateLabelSettings(settings, labelOptions);
                if (options.headerHeight >= 0) {
                    headerHeight = pickPositiveInteger(options.headerHeight)
                } else {
                    headerHeight = settings.labelParams.height + 2 * pickPositiveInteger(labelOptions.paddingTopBottom)
                }
                if (that._headerHeight !== headerHeight) {
                    that._headerHeight = headerHeight;
                    that._change(["TILING"])
                }
                if (that._groupPadding !== groupPadding) {
                    that._groupPadding = groupPadding;
                    that._change(["TILING"])
                }
                if (offsets.headerEdge !== edgeOffset || offsets.headerInner !== innerOffset) {
                    offsets.headerEdge = edgeOffset;
                    offsets.headerInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _calculateLabelSettings: function(settings, options, filter) {
                var bBox = this._getTextBBox(options.font),
                    paddingLeftRight = pickPositiveInteger(options.paddingLeftRight),
                    paddingTopBottom = pickPositiveInteger(options.paddingTopBottom),
                    tileLabelOptions = this._getOption("tile.label"),
                    groupLabelOptions = this._getOption("group.label");
                settings.labelState = (0, _common.buildTextAppearance)(options, filter);
                settings.labelState.visible = !("visible" in options) || !!options.visible;
                this._suppressDeprecatedWarnings();
                settings.labelParams = {
                    height: bBox.height,
                    rtlEnabled: this._getOption("rtlEnabled", true),
                    paddingTopBottom: paddingTopBottom,
                    paddingLeftRight: paddingLeftRight,
                    resolveLabelOverflow: this._getOption("resolveLabelOverflow", true),
                    tileLabelWordWrap: tileLabelOptions.wordWrap,
                    tileLabelOverflow: tileLabelOptions.textOverflow,
                    groupLabelOverflow: groupLabelOptions.textOverflow
                };
                this._resumeDeprecatedWarnings()
            },
            _changeMaxDepth: function() {
                var maxDepth = this._getOption("maxDepth", true);
                maxDepth = maxDepth >= 1 ? Math.round(maxDepth) : 1 / 0;
                if (this._maxDepth !== maxDepth) {
                    this._maxDepth = maxDepth;
                    this._change(["NODES_RESET"])
                }
            },
            _resetNodes: function() {
                var that = this;
                that._tilesGroup.clear();
                that._renderer.initHatching();
                that._context.forceReset = true;
                that._context.minLevel = that._topNode.level + 1;
                that._context.maxLevel = that._context.minLevel + that._maxDepth - 1;
                that._change(["TILES", "LABELS", "TILING"])
            },
            _processNodes: function(context, process) {
                processNodes(context, this._topNode, process)
            },
            _applyTilesAppearance: function() {
                var that = this,
                    colorizer = (0, _colorizing.getColorizer)(that._getOption("colorizer"), that._themeManager, that._topNode);
                that._processNodes({
                    renderer: that._renderer,
                    group: that._tilesGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    colorField: that._getOption("colorField", true) || "color",
                    getColor: colorizer
                }, processTileAppearance)
            },
            _applyLabelsAppearance: function() {
                var that = this;
                that._labelsGroup.clear();
                that._processNodes({
                    renderer: that._renderer,
                    group: that._labelsGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    labelField: that._getOption("labelField", true) || "name"
                }, processLabelAppearance);
                that._change(["LABELS_LAYOUT"])
            },
            _performTiling: function() {
                var that = this,
                    context = {
                        algorithm: (0, _tiling.getAlgorithm)(that._getOption("layoutAlgorithm", true)),
                        directions: directions[String(that._getOption("layoutDirection", true)).toLowerCase()] || directions.lefttoprightbottom,
                        headerHeight: that._headerHeight,
                        groupPadding: that._groupPadding,
                        rectOffsets: that._rectOffsets
                    };
                that._topNode.innerRect = that._tilingRect;
                calculateRects(context, that._topNode);
                that._processNodes(context, processTiling);
                that._change(["LABELS_LAYOUT"]);
                that._onTilingPerformed()
            },
            _onTilingPerformed: _common2.noop,
            _performLabelsLayout: function() {
                this._processNodes(null, processLabelsLayout)
            },
            _getTextBBox: function(fontOptions) {
                var bBox, renderer = this._renderer,
                    text = this._textForCalculations || renderer.text("0", 0, 0);
                this._textForCalculations = text;
                text.css((0, _utils.patchFontOptions)(fontOptions)).append(renderer.root);
                bBox = text.getBBox();
                text.remove();
                return bBox
            }
        });

        function traverseDataItems(root, dataItems, level, params) {
            var node, i, dataItem, items, nodes = [],
                allNodes = params.nodes,
                ii = dataItems.length,
                totalValue = 0;
            for (i = 0; i < ii; ++i) {
                dataItem = dataItems[i];
                node = new _node2.default;
                node._id = allNodes.length;
                node.ctx = params.ctx;
                node.parent = root;
                node.level = level;
                node.index = nodes.length;
                node.data = dataItem;
                params.buildNode(node);
                allNodes.push(node);
                nodes.push(node);
                items = dataItem[params.itemsField];
                if (items && items.length) {
                    traverseDataItems(node, items, level + 1, params)
                }
                if (dataItem[params.valueField] > 0) {
                    node.value = Number(dataItem[params.valueField])
                }
                totalValue += node.value
            }
            root.nodes = nodes;
            root.value = totalValue
        }

        function processNodes(context, root, process) {
            var node, i, nodes = root.nodes,
                ii = nodes.length;
            for (i = 0; i < ii; ++i) {
                node = nodes[i];
                process(context, node);
                if (node.isNode()) {
                    processNodes(context, node, process)
                }
            }
        }

        function processTileAppearance(context, node) {
            node.color = node.data[context.colorField] || context.getColor(node) || node.parent.color;
            node.updateStyles();
            node.tile = !node.ctx.forceReset && node.tile || createTile[Number(node.isNode())](context, node);
            node.applyState()
        }
        var createTile = [createLeaf, createGroup];

        function createLeaf(context, node) {
            var tile = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, tile);
            return tile
        }

        function createGroup(context, node) {
            var outer = context.renderer.simpleRect().append(context.group),
                inner = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, inner);
            return {
                outer: outer,
                inner: inner
            }
        }

        function processLabelAppearance(context, node) {
            node.updateLabelStyle();
            if (node.labelState.visible) {
                createLabel(context, node, node.labelState, node.labelParams)
            }
        }

        function createLabel(context, currentNode, settings, params) {
            var textData = currentNode.data[context.labelField];
            currentNode.label = textData ? String(textData) : null;
            textData = currentNode.customLabel || currentNode.label;
            if (textData) {
                currentNode.text = context.renderer.text(textData).attr(settings.attr).css(settings.css).append(context.group);
                context.setTrackerData(currentNode, currentNode.text)
            }
        }
        var emptyRect = [0, 0, 0, 0];

        function calculateRects(context, root) {
            var i, nodes = root.nodes,
                items = [],
                rects = [],
                sum = 0,
                ii = items.length = rects.length = nodes.length;
            for (i = 0; i < ii; ++i) {
                sum += nodes[i].value;
                items[i] = {
                    value: nodes[i].value,
                    i: i
                }
            }
            if (sum > 0) {
                context.algorithm({
                    items: items.slice(),
                    sum: sum,
                    rect: root.innerRect.slice(),
                    isRotated: 1 & nodes[0].level,
                    directions: context.directions
                })
            }
            for (i = 0; i < ii; ++i) {
                rects[i] = items[i].rect || emptyRect
            }
            root.rects = rects
        }

        function processTiling(context, node) {
            var headerHeight, rect = node.parent.rects[node.index],
                rectOffsets = context.rectOffsets;
            if (node.isNode()) {
                setRectAttrs(node.tile.outer, buildTileRect(rect, node.parent.innerRect, rectOffsets.headerEdge, rectOffsets.headerInner));
                rect = marginateRect(rect, context.groupPadding);
                headerHeight = Math.min(context.headerHeight, rect[3] - rect[1]);
                node.rect = [rect[0], rect[1], rect[2], rect[1] + headerHeight];
                setRectAttrs(node.tile.inner, marginateRect(node.rect, rectOffsets.headerEdge));
                rect[1] += headerHeight;
                node.innerRect = rect;
                calculateRects(context, node)
            } else {
                node.rect = rect;
                setRectAttrs(node.tile, buildTileRect(rect, node.parent.innerRect, rectOffsets.tileEdge, rectOffsets.tileInner))
            }
        }

        function marginateRect(rect, margin) {
            return [rect[0] + margin, rect[1] + margin, rect[2] - margin, rect[3] - margin]
        }

        function buildTileRect(rect, outer, edgeOffset, innerOffset) {
            return [rect[0] + (rect[0] === outer[0] ? edgeOffset : +innerOffset), rect[1] + (rect[1] === outer[1] ? edgeOffset : +innerOffset), rect[2] - (rect[2] === outer[2] ? edgeOffset : -innerOffset), rect[3] - (rect[3] === outer[3] ? edgeOffset : -innerOffset)]
        }

        function setRectAttrs(element, rect) {
            element.attr({
                x: rect[0],
                y: rect[1],
                width: _max(rect[2] - rect[0], 0),
                height: _max(rect[3] - rect[1], 0)
            })
        }

        function processLabelsLayout(context, node) {
            if (node.text && node.labelState.visible) {
                layoutTextNode(node, node.labelParams)
            }
        }

        function layoutTextNode(node, params) {
            var rect = node.rect,
                text = node.text,
                bBox = text.getBBox(),
                paddingLeftRight = params.paddingLeftRight,
                paddingTopBottom = params.paddingTopBottom,
                effectiveWidth = rect[2] - rect[0] - 2 * paddingLeftRight,
                fitByHeight = bBox.height + paddingTopBottom <= rect[3] - rect[1],
                fitByWidth = bBox.width <= effectiveWidth,
                resolveLabelOverflow = params.resolveLabelOverflow,
                groupLabelOverflow = params.groupLabelOverflow,
                tileLabelOverflow = params.tileLabelOverflow,
                tileLabelWordWrap = params.tileLabelWordWrap;
            if ((0, _type.isDefined)(resolveLabelOverflow)) {
                if ("ellipsis" === resolveLabelOverflow && fitByHeight) {
                    text.setMaxSize(effectiveWidth, void 0, {
                        wordWrap: "none",
                        textOverflow: "ellipsis"
                    });
                    if (!fitByWidth) {
                        bBox = text.getBBox();
                        fitByWidth = bBox.width <= effectiveWidth
                    }
                }
            } else {
                fitByWidth = true;
                fitByHeight = true;
                text.setMaxSize(effectiveWidth, rect[3] - rect[1] - paddingTopBottom, node.isNode() ? {
                    textOverflow: groupLabelOverflow,
                    wordWrap: "none"
                } : {
                    textOverflow: tileLabelOverflow,
                    wordWrap: tileLabelWordWrap,
                    hideOverflowEllipsis: true
                })
            }
            text.attr({
                visibility: fitByHeight && fitByWidth ? "visible" : "hidden"
            });
            if (fitByHeight && fitByWidth) {
                text.move(params.rtlEnabled ? rect[2] - paddingLeftRight - bBox.x - bBox.width : rect[0] + paddingLeftRight - bBox.x, rect[1] + paddingTopBottom - bBox.y)
            }
        }
        __webpack_require__( /*! ../../core/component_registrator */ 8)("dxTreeMap", dxTreeMap);
        module.exports = dxTreeMap;
        dxTreeMap.addPlugin(__webpack_require__( /*! ../core/data_source */ 144).plugin)
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            callbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 122);
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }
            each(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            callbacks.fire(name, strategy)
        };
        registerEvent.callbacks = callbacks;
        module.exports = registerEvent
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.template_base.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 25),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 12),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            abstract = Class.abstract;
        var renderedCallbacks = Callbacks({
            syncStrategy: true
        });
        var TemplateBase = Class.inherit({
            render: function(options) {
                options = options || {};
                var onRendered = options.onRendered;
                delete options.onRendered;
                var $result = this._renderCore(options);
                this._ensureResultInContainer($result, options.container);
                renderedCallbacks.fire($result, options.container);
                onRendered && onRendered();
                return $result
            },
            _ensureResultInContainer: function($result, container) {
                if (!container) {
                    return
                }
                var $container = $(container);
                var resultInContainer = domUtils.contains($container.get(0), $result.get(0));
                $container.append($result);
                if (resultInContainer) {
                    return
                }
                var resultInBody = domAdapter.getBody().contains($container.get(0));
                if (!resultInBody) {
                    return
                }
                domUtils.triggerShownEvent($result)
            },
            _renderCore: abstract
        });
        module.exports = TemplateBase;
        module.exports.renderedCallbacks = renderedCallbacks
    }, ,
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/animation/position.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 11),
            isWindow = __webpack_require__( /*! ../core/utils/type */ 1).isWindow,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            browser = __webpack_require__( /*! ../core/utils/browser */ 27),
            translator = __webpack_require__( /*! ./translator */ 26),
            support = __webpack_require__( /*! ../core/utils/support */ 42);
        var horzRe = /left|right/,
            vertRe = /top|bottom/,
            collisionRe = /fit|flip|none/,
            IS_SAFARI = browser.safari;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = commonUtils.splitPair(raw);
            if (pair) {
                each(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return commonUtils.pairToObject(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = String(pair && pair[0]).toLowerCase(),
                v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = extend({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = $("<div>").css({
                    width: 100,
                    height: 100,
                    overflow: "scroll",
                    position: "absolute",
                    top: -9999
                }).appendTo($("body")),
                result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = $(what),
                currentOffset = $what.offset(),
                result = extend(true, {}, defaultPositionResult, {
                    h: {
                        location: currentOffset.left
                    },
                    v: {
                        location: currentOffset.top
                    }
                });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my),
                at = normalizeAlign(options.at),
                of = $(options.of).length && options.of || window,
                offset = normalizeOffset(options.offset),
                collision = normalizeCollision(options.collision),
                boundary = options.boundary,
                boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else {
                of = $( of );
                if (isWindow( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    h.atSize = of [0].innerWidth >= of [0].outerWidth ? of [0].innerWidth : of .width();
                    v.atSize = of [0].innerHeight >= of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : of .height()
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var o = of .offset();
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = of .outerWidth();
                        v.atSize = of .outerHeight()
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = $(window),
                    windowWidth = win.width(),
                    windowHeight = win.height(),
                    left = win.scrollLeft(),
                    top = win.scrollTop(),
                    documentElement = domAdapter.getDocumentElement(),
                    hZoomLevel = support.touch ? documentElement.clientWidth / windowWidth : 1,
                    vZoomLevel = support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth,
                    boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = $(boundary),
                        boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            extend(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var position = function(what, options) {
            var $what = $(what);
            if (!options) {
                return $what.offset()
            }
            translator.resetPosition($what, true);
            var offset = $what.offset(),
                targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            translator.move($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = $(element).get(0);
            if (isWindow(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return $(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        module.exports = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/view_port.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 48),
            ready = readyCallbacks.add,
            changeCallback = __webpack_require__( /*! ./callbacks */ 25)(),
            $originalViewPort = $();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = $(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : $("body");
                changeCallback.fire(isNewViewportFound ? value() : $(), prevViewPort)
            }
        }();
        ready(function() {
            value(".dx-viewport")
        });
        exports.value = value;
        exports.changeCallback = changeCallback;
        exports.originalViewPort = function() {
            return $originalViewPort
        }
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/exporter/excel/excel.tag_helper.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var tagHelper = {
            toXml: function(tagName, attributes, content) {
                var result = ["<", tagName];
                for (var attributeName in attributes) {
                    var attributeValue = attributes[attributeName];
                    if ((0, _type.isDefined)(attributeValue)) {
                        result.push(" ", attributeName, '="', attributeValue, '"')
                    }
                }
                if ((0, _type.isDefined)(content) && "" !== content) {
                    result.push(">", content, "</", tagName, ">")
                } else {
                    result.push(" />")
                }
                return result.join("")
            }
        };
        exports.default = tagHelper
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/integration/jquery/use_jquery.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var jQuery = __webpack_require__( /*! jquery */ 55);
        var config = __webpack_require__( /*! ../../core/config */ 31);
        var useJQuery = config().useJQuery;
        if (jQuery && false !== useJQuery) {
            config({
                useJQuery: true
            })
        }
        module.exports = function() {
            return jQuery && config().useJQuery
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/store_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var grep = __webpack_require__( /*! ../core/utils/common */ 4).grep,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            arrayQuery = __webpack_require__( /*! ./array_query */ 155),
            normalizeSortingInfo = __webpack_require__( /*! ./utils */ 40).normalizeSortingInfo;

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return extend({}, g, {
                        items: multiLevelGroup(arrayQuery(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            each(groupInfo, function(_, group) {
                var collision = grep(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter;
            if (filter) {
                query = query.filter(filter)
            }
            if (isCountQuery) {
                return query
            }
            var sort = options.sort,
                select = options.select,
                group = options.group,
                skip = options.skip,
                take = options.take;
            if (group) {
                group = normalizeSortingInfo(group);
                group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
            }
            if (sort || group) {
                sort = normalizeSortingInfo(sort || []);
                if (group && !group.keepInitialKeyOrder) {
                    sort = arrangeSortingInfo(group, sort)
                }
                each(sort, function(index) {
                    query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                })
            }
            if (select) {
                query = query.select(select)
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (take || skip) {
                query = query.slice(skip || 0, take)
            }
            return query
        }
        module.exports = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/console.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ./type */ 1).isFunction;
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !isFunction(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.logger = logger;
        exports.debug = debug
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/events_mixin.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DefaultEventsStrategy = __webpack_require__( /*! ./events_strategy */ 441),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject;
        module.exports = {
            ctor: function() {
                this._events = {};
                this.setEventsStrategy(new DefaultEventsStrategy(this))
            },
            setEventsStrategy: function(strategy) {
                if ("function" === typeof strategy) {
                    strategy = strategy(this)
                }
                this._eventsStrategy = strategy
            },
            hasEvent: function(eventName) {
                return this._eventsStrategy.hasEvent(eventName)
            },
            fireEvent: function(eventName, eventArgs) {
                this._eventsStrategy.fireEvent(eventName, eventArgs);
                return this
            },
            on: function(eventName, eventHandler) {
                if (isPlainObject(eventName)) {
                    each(eventName, function(e, h) {
                        this.on(e, h)
                    }.bind(this))
                } else {
                    this._eventsStrategy.on(eventName, eventHandler)
                }
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            _disposeEvents: function() {
                this._eventsStrategy.dispose()
            }
        }
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/core/polyfills/promise.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 6),
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            promise = windowUtils.hasWindow() ? windowUtils.getWindow().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        module.exports = promise
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/function_template.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 73),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 12);
        var FunctionTemplate = TemplateBase.inherit({
            ctor: function(render) {
                this._render = render
            },
            _renderCore: function(options) {
                return domUtils.normalizeTemplateElement(this._render(options))
            }
        });
        module.exports = FunctionTemplate
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data_helper.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DataSource = __webpack_require__( /*! ./data/data_source/data_source */ 44).DataSource,
            extend = __webpack_require__( /*! ./core/utils/extend */ 0).extend,
            normalizeDataSourceOptions = __webpack_require__( /*! ./data/data_source/data_source */ 44).normalizeDataSourceOptions;
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions",
            DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler",
            DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler",
            DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler",
            DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode",
            SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var widgetDataSourceOptions, dataSourceType, dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : DataSource;
                        dataSourceOptions = normalizeDataSourceOptions(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType(extend(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function(e) {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items(), e)
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        module.exports = DataHelperMixin
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/style.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var camelize = __webpack_require__( /*! ./inflector */ 32).camelize,
            callOnce = __webpack_require__( /*! ./call_once */ 63),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 11);
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"],
            cssPrefixes = {
                "": "",
                Webkit: "-webkit-",
                Moz: "-moz-",
                O: "-o-",
                ms: "-ms-"
            },
            getStyles = callOnce(function() {
                return domAdapter.createElement("dx").style
            });
        var forEachPrefixes = function(prop, callBack) {
            prop = camelize(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = camelize(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if (typeUtils.isNumeric(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = typeUtils.isNumeric(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.styleProp = styleProp;
        exports.stylePropPrefix = stylePropPrefix;
        exports.normalizeStyleProp = normalizeStyleProp;
        exports.setWidth = setWidth;
        exports.setHeight = setHeight
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/variable_wrapper.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var logger = __webpack_require__( /*! ./console */ 80).logger,
            dependencyInjector = __webpack_require__( /*! ./dependency_injector */ 54);
        module.exports = dependencyInjector({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        })
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/core.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 54);
        module.exports = dependencyInjector({
            locale: function() {
                var currentLocale = "en";
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }()
        })
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/hold.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventUtils = __webpack_require__( /*! ./utils */ 9),
            Emitter = __webpack_require__( /*! ./core/emitter */ 123),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95),
            abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold",
            HOLD_TIMEOUT = 750,
            TOUCH_BOUNDARY = 5;
        var HoldEmitter = Emitter.inherit({
            start: function(e) {
                this._startEventData = eventUtils.eventData(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        registerEmitter({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        module.exports = {
            name: HOLD_EVENT_NAME
        }
    }, , , , ,
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/viz/core/export.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.plugin = exports.ExportMenu = exports.combineMarkups = exports.exportWidgets = exports.getMarkup = exports.exportFromMarkup = void 0;
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _utils = __webpack_require__( /*! ./utils */ 10);
        var _exporter = __webpack_require__( /*! ../../exporter */ 170);
        var _exporter2 = _interopRequireDefault(_exporter);
        var _message = __webpack_require__( /*! ../../localization/message */ 14);
        var _message2 = _interopRequireDefault(_message);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _themes = __webpack_require__( /*! ../themes */ 50);
        var _themes2 = _interopRequireDefault(_themes);
        var _hover = __webpack_require__( /*! ../../events/hover */ 148);
        var _hover2 = _interopRequireDefault(_hover);
        var _pointer = __webpack_require__( /*! ../../events/pointer */ 24);
        var _pointer2 = _interopRequireDefault(_pointer);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var imageExporter = _exporter2.default.image;
        var svgExporter = _exporter2.default.svg;
        var pdfExporter = _exporter2.default.pdf;
        var pointerActions = [_pointer2.default.down, _pointer2.default.move].join(" ");
        var BUTTON_SIZE = 35;
        var ICON_COORDS = [
            [9, 12, 26, 12, 26, 14, 9, 14],
            [9, 17, 26, 17, 26, 19, 9, 19],
            [9, 22, 26, 22, 26, 24, 9, 24]
        ];
        var LIST_PADDING_TOP = 4;
        var LIST_WIDTH = 120;
        var VERTICAL_TEXT_MARGIN = 8;
        var HORIZONTAL_TEXT_MARGIN = 15;
        var MENU_ITEM_HEIGHT = 30;
        var LIST_STROKE_WIDTH = 1;
        var MARGIN = 10;
        var SHADOW_OFFSET = 2;
        var SHADOW_BLUR = 3;
        var DEFAULT_EXPORT_FORMAT = "PNG";
        var ALLOWED_IMAGE_FORMATS = [DEFAULT_EXPORT_FORMAT, "JPEG", "GIF"];
        var ALLOWED_EXTRA_FORMATS = ["PDF", "SVG"];
        var EXPORT_CSS_CLASS = "dx-export-menu";
        var EXPORT_DATA_KEY = "export-element-type";
        var FORMAT_DATA_KEY = "export-element-format";
        var GET_COLOR_REGEX = /data-backgroundcolor="([^"]*)"/;

        function getValidFormats() {
            var imageFormats = imageExporter.testFormats(ALLOWED_IMAGE_FORMATS);
            return {
                unsupported: imageFormats.unsupported,
                supported: imageFormats.supported.concat(ALLOWED_EXTRA_FORMATS)
            }
        }

        function validateFormat(format, incidentOccurred, validFormats) {
            validFormats = validFormats || getValidFormats();
            format = String(format).toUpperCase();
            if (validFormats.supported.indexOf(format) !== -1) {
                return format
            }
            if (validFormats.unsupported.indexOf(format) !== -1) {
                incidentOccurred && incidentOccurred("W2108", [format])
            }
        }

        function getCreatorFunc(format) {
            if ("SVG" === format) {
                return svgExporter.getData
            } else {
                if ("PDF" === format) {
                    return pdfExporter.getData
                } else {
                    return imageExporter.getData
                }
            }
        }

        function _print(imageSrc, options) {
            var document = (0, _window.getWindow)().document;
            var iFrame = document.createElement("iframe");
            iFrame.onload = setPrint(imageSrc, options);
            iFrame.style.visibility = "hidden";
            iFrame.style.position = "fixed";
            iFrame.style.right = "0";
            iFrame.style.bottom = "0";
            document.body.appendChild(iFrame)
        }

        function setPrint(imageSrc, options) {
            return function() {
                var _this = this;
                var window = this.contentWindow;
                var img = window.document.createElement("img");
                window.document.body.appendChild(img);
                var origImageSrc = imageSrc;
                if (options.__test) {
                    imageSrc = options.__test.imageSrc;
                    window = options.__test.mockWindow
                }
                var removeFrame = function() {
                    options.__test && options.__test.checkAssertions();
                    _this.parentElement.removeChild(_this);
                    options.__test && options.__test.deferred.resolve(origImageSrc)
                };
                img.addEventListener("load", function() {
                    window.focus();
                    window.print();
                    removeFrame()
                });
                img.addEventListener("error", removeFrame);
                img.src = imageSrc
            }
        }

        function getItemAttributes(options, type, itemIndex) {
            var x = BUTTON_SIZE - LIST_WIDTH;
            var y = BUTTON_SIZE + LIST_PADDING_TOP + LIST_STROKE_WIDTH + itemIndex * MENU_ITEM_HEIGHT;
            var attr = {
                rect: {
                    width: LIST_WIDTH - 2 * LIST_STROKE_WIDTH,
                    height: MENU_ITEM_HEIGHT,
                    x: x + LIST_STROKE_WIDTH,
                    y: y
                },
                text: {
                    x: x + (options.rtl ? LIST_WIDTH - HORIZONTAL_TEXT_MARGIN : HORIZONTAL_TEXT_MARGIN),
                    y: y + MENU_ITEM_HEIGHT - VERTICAL_TEXT_MARGIN
                }
            };
            if ("printing" === type) {
                attr.separator = {
                    stroke: options.button.default.borderColor,
                    "stroke-width": LIST_STROKE_WIDTH,
                    cursor: "pointer",
                    sharp: "v",
                    d: "M " + x + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH) + " L " + (x + LIST_WIDTH) + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH)
                }
            }
            return attr
        }

        function createMenuItem(renderer, options, settings) {
            var itemData = {};
            var type = settings.type;
            var format = settings.format;
            var attr = getItemAttributes(options, type, settings.itemIndex);
            var fontStyle = (0, _utils.patchFontOptions)(options.font);
            fontStyle["pointer-events"] = "none";
            var menuItem = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list-item"
            });
            itemData[EXPORT_DATA_KEY] = type;
            if (format) {
                itemData[FORMAT_DATA_KEY] = format
            }
            var rect = renderer.rect();
            rect.attr(attr.rect).css({
                cursor: "pointer",
                "pointer-events": "all"
            }).data(itemData);
            rect.on(_hover2.default.start + ".export", function() {
                return rect.attr({
                    fill: options.button.hover.backgroundColor
                })
            }).on(_hover2.default.end + ".export", function() {
                return rect.attr({
                    fill: null
                })
            });
            rect.append(menuItem);
            var text = renderer.text(settings.text).css(fontStyle).attr(attr.text).append(menuItem);
            if ("printing" === type) {
                renderer.path(null, "line").attr(attr.separator).append(menuItem)
            }
            return {
                g: menuItem,
                rect: rect,
                resetState: function() {
                    return rect.attr({
                        fill: null
                    })
                },
                fixPosition: function() {
                    var textBBox = text.getBBox();
                    text.move(attr.text.x - textBBox.x - (options.rtl ? textBBox.width : 0))
                }
            }
        }

        function createMenuItems(renderer, options) {
            var items = [];
            if (options.printingEnabled) {
                items.push(createMenuItem(renderer, options, {
                    type: "printing",
                    text: _message2.default.format("vizExport-printingButtonText"),
                    itemIndex: items.length
                }))
            }
            items = options.formats.reduce(function(r, format) {
                r.push(createMenuItem(renderer, options, {
                    type: "exporting",
                    text: _message2.default.getFormatter("vizExport-exportButtonText")(format),
                    format: format,
                    itemIndex: r.length
                }));
                return r
            }, items);
            return items
        }

        function getBackgroundColorFromMarkup(markup) {
            var parsedMarkup = GET_COLOR_REGEX.exec(markup);
            return parsedMarkup ? parsedMarkup[1] : void 0
        }
        var exportFromMarkup = exports.exportFromMarkup = function(markup, options) {
            options.format = validateFormat(options.format) || DEFAULT_EXPORT_FORMAT;
            options.fileName = options.fileName || "file";
            options.exportingAction = options.onExporting;
            options.exportedAction = options.onExported;
            options.fileSavingAction = options.onFileSaving;
            options.margin = (0, _type.isDefined)(options.margin) ? options.margin : MARGIN;
            options.backgroundColor = (0, _type.isDefined)(options.backgroundColor) ? options.backgroundColor : getBackgroundColorFromMarkup(markup);
            _exporter2.default.export(markup, options, getCreatorFunc(options.format))
        };
        exports.getMarkup = function(widgets) {
            return combineMarkups(widgets).markup
        };
        exports.exportWidgets = function(widgets, options) {
            options = options || {};
            var markupInfo = exports.combineMarkups(widgets, {
                gridLayout: options.gridLayout,
                verticalAlignment: options.verticalAlignment,
                horizontalAlignment: options.horizontalAlignment
            });
            options.width = markupInfo.width;
            options.height = markupInfo.height;
            exportFromMarkup(markupInfo.markup, options)
        };
        var combineMarkups = exports.combineMarkups = function(widgets) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            if (!Array.isArray(widgets)) {
                widgets = [
                    [widgets]
                ]
            } else {
                if (!Array.isArray(widgets[0])) {
                    widgets = widgets.map(function(item) {
                        return [item]
                    })
                }
            }
            var compactView = !options.gridLayout;
            var exportItems = widgets.reduce(function(r, row, rowIndex) {
                var rowInfo = row.reduce(function(r, item, colIndex) {
                    var size = item.getSize();
                    var backgroundColor = item.option("backgroundColor") || _themes2.default.getTheme(item.option("theme")).backgroundColor;
                    backgroundColor && r.backgroundColors.indexOf(backgroundColor) === -1 && r.backgroundColors.push(backgroundColor);
                    r.hOffset = r.width;
                    r.width += size.width;
                    r.height = Math.max(r.height, size.height);
                    r.itemWidth = Math.max(r.itemWidth, size.width);
                    r.items.push({
                        markup: item.svg(),
                        width: size.width,
                        height: size.height,
                        c: colIndex,
                        r: rowIndex,
                        hOffset: r.hOffset
                    });
                    return r
                }, {
                    items: [],
                    height: 0,
                    itemWidth: 0,
                    hOffset: 0,
                    width: 0,
                    backgroundColors: r.backgroundColors
                });
                r.rowOffsets.push(r.totalHeight);
                r.rowHeights.push(rowInfo.height);
                r.totalHeight += rowInfo.height;
                r.items = r.items.concat(rowInfo.items);
                r.itemWidth = Math.max(r.itemWidth, rowInfo.itemWidth);
                r.maxItemLen = Math.max(r.maxItemLen, rowInfo.items.length);
                r.totalWidth = compactView ? Math.max(r.totalWidth, rowInfo.width) : r.maxItemLen * r.itemWidth;
                return r
            }, {
                items: [],
                rowOffsets: [],
                rowHeights: [],
                itemWidth: 0,
                totalHeight: 0,
                maxItemLen: 0,
                totalWidth: 0,
                backgroundColors: []
            });
            var backgroundColor = 'data-backgroundcolor="' + (1 === exportItems.backgroundColors.length ? exportItems.backgroundColors[0] : "") + '" ';
            var getVOffset = function(item) {
                var align = options.verticalAlignment;
                var dy = exportItems.rowHeights[item.r] - item.height;
                return exportItems.rowOffsets[item.r] + ("bottom" === align ? dy : "center" === align ? dy / 2 : 0)
            };
            var getHOffset = function(item) {
                if (compactView) {
                    return item.hOffset
                }
                var align = options.horizontalAlignment;
                var colWidth = exportItems.itemWidth;
                var dx = colWidth - item.width;
                return item.c * colWidth + ("right" === align ? dx : "center" === align ? dx / 2 : 0)
            };
            var totalHeight = exportItems.totalHeight;
            var totalWidth = exportItems.totalWidth;
            return {
                markup: "<svg " + backgroundColor + 'height="' + totalHeight + '" width="' + totalWidth + '" version="1.1" xmlns="http://www.w3.org/2000/svg">' + exportItems.items.map(function(item) {
                    return '<g transform="translate(' + getHOffset(item) + "," + getVOffset(item) + ')">' + item.markup + "</g>"
                }).join("") + "</svg>",
                width: totalWidth,
                height: totalHeight
            }
        };
        var ExportMenu = exports.ExportMenu = function(params) {
            var renderer = this._renderer = params.renderer;
            this._incidentOccurred = params.incidentOccurred;
            this._exportTo = params.exportTo;
            this._print = params.print;
            this._shadow = renderer.shadowFilter("-50%", "-50%", "200%", "200%", SHADOW_OFFSET, 6, SHADOW_BLUR);
            this._shadow.attr({
                opacity: .8
            });
            this._group = renderer.g().attr({
                "class": EXPORT_CSS_CLASS,
                "hidden-for-export": true
            }).linkOn(renderer.root, {
                name: "export-menu",
                after: "peripheral"
            });
            this._buttonGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-button"
            }).append(this._group);
            this._listGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list"
            }).append(this._group);
            this._overlay = renderer.rect(-LIST_WIDTH + BUTTON_SIZE, BUTTON_SIZE + LIST_PADDING_TOP, LIST_WIDTH, 0);
            this._overlay.attr({
                "stroke-width": LIST_STROKE_WIDTH,
                cursor: "pointer",
                rx: 4,
                ry: 4,
                filter: this._shadow.id
            });
            this._overlay.data({
                "export-element-type": "list"
            });
            this.validFormats = getValidFormats();
            this._subscribeEvents()
        };
        (0, _extend.extend)(ExportMenu.prototype, {
            getLayoutOptions: function() {
                if (this._hiddenDueToLayout) {
                    return {
                        width: 0,
                        height: 0,
                        cutSide: "vertical",
                        cutLayoutSide: "top"
                    }
                }
                var bBox = this._buttonGroup.getBBox();
                bBox.cutSide = "vertical";
                bBox.cutLayoutSide = "top";
                bBox.height += MARGIN;
                bBox.position = {
                    vertical: "top",
                    horizontal: "right"
                };
                bBox.verticalAlignment = "top";
                bBox.horizontalAlignment = "right";
                return bBox
            },
            probeDraw: function() {
                this._fillSpace();
                this.show()
            },
            shift: function(_, y) {
                this._group.attr({
                    translateY: this._group.attr("translateY") + y
                })
            },
            draw: function(width, height, canvas) {
                this._group.move(width - BUTTON_SIZE - SHADOW_OFFSET - SHADOW_BLUR + canvas.left, Math.floor(height / 2 - BUTTON_SIZE / 2));
                var layoutOptions = this.getLayoutOptions();
                if (layoutOptions.width > width || layoutOptions.height > height) {
                    this.freeSpace()
                }
                return this
            },
            show: function() {
                this._group.linkAppend()
            },
            hide: function() {
                this._group.linkRemove()
            },
            setOptions: function(options) {
                var _this2 = this;
                this._options = options;
                if (options.formats) {
                    options.formats = options.formats.reduce(function(r, format) {
                        format = validateFormat(format, _this2._incidentOccurred, _this2.validFormats);
                        format && r.push(format);
                        return r
                    }, [])
                } else {
                    options.formats = this.validFormats.supported.slice()
                }
                options.printingEnabled = void 0 === options.printingEnabled ? true : options.printingEnabled;
                if (options.enabled && (options.formats.length || options.printingEnabled)) {
                    this.show();
                    this._updateButton();
                    this._updateList();
                    this._hideList()
                } else {
                    this.hide()
                }
            },
            dispose: function() {
                this._unsubscribeEvents();
                this._group.linkRemove().linkOff();
                this._group.dispose();
                this._shadow.dispose()
            },
            layoutOptions: function() {
                return this._options.enabled && {
                    horizontalAlignment: "right",
                    verticalAlignment: "top",
                    weak: true
                }
            },
            measure: function() {
                this._fillSpace();
                var margin = this._options.button.margin;
                return [BUTTON_SIZE + margin.left + margin.right, BUTTON_SIZE + margin.top + margin.bottom]
            },
            move: function(rect) {
                var margin = this._options.button.margin;
                this._group.attr({
                    translateX: Math.round(rect[0]) + margin.left,
                    translateY: Math.round(rect[1]) + margin.top
                })
            },
            _fillSpace: function() {
                this._hiddenDueToLayout = false;
                this.show()
            },
            freeSpace: function() {
                this._incidentOccurred("W2107");
                this._hiddenDueToLayout = true;
                this.hide()
            },
            _hideList: function() {
                this._listGroup.remove();
                this._listShown = false;
                this._setButtonState("default");
                this._menuItems.forEach(function(item) {
                    return item.resetState()
                })
            },
            _showList: function() {
                this._listGroup.append(this._group);
                this._listShown = true;
                this._menuItems.forEach(function(item) {
                    return item.fixPosition()
                })
            },
            _setButtonState: function(state) {
                var style = this._options.button[state];
                this._button.attr({
                    stroke: style.borderColor,
                    fill: style.backgroundColor
                });
                this._icon.attr({
                    fill: style.color
                })
            },
            _subscribeEvents: function() {
                var _this3 = this;
                this._renderer.root.on(_pointer2.default.up + ".export", function(e) {
                    var elementType = e.target[EXPORT_DATA_KEY];
                    if (!elementType) {
                        if (_this3._button) {
                            _this3._hideList()
                        }
                        return
                    }
                    if ("button" === elementType) {
                        if (_this3._listShown) {
                            _this3._setButtonState("default");
                            _this3._hideList()
                        } else {
                            _this3._setButtonState("focus");
                            _this3._showList()
                        }
                    } else {
                        if ("printing" === elementType) {
                            _this3._print();
                            _this3._hideList()
                        } else {
                            if ("exporting" === elementType) {
                                _this3._exportTo(e.target[FORMAT_DATA_KEY]);
                                _this3._hideList()
                            }
                        }
                    }
                });
                this._listGroup.on(pointerActions, function(e) {
                    return e.stopPropagation()
                });
                this._buttonGroup.on(_pointer2.default.enter, function() {
                    return _this3._setButtonState("hover")
                });
                this._buttonGroup.on(_pointer2.default.leave, function() {
                    return _this3._setButtonState(_this3._listShown ? "focus" : "default")
                });
                this._buttonGroup.on(_pointer2.default.down + ".export", function() {
                    return _this3._setButtonState("active")
                })
            },
            _unsubscribeEvents: function() {
                this._renderer.root.off(".export");
                this._listGroup.off();
                this._buttonGroup.off()
            },
            _updateButton: function() {
                var renderer = this._renderer;
                var options = this._options;
                var exportData = {
                    "export-element-type": "button"
                };
                if (!this._button) {
                    this._button = renderer.rect(0, 0, BUTTON_SIZE, BUTTON_SIZE).append(this._buttonGroup);
                    this._button.attr({
                        rx: 4,
                        ry: 4,
                        fill: options.button.default.backgroundColor,
                        stroke: options.button.default.borderColor,
                        "stroke-width": 1,
                        cursor: "pointer"
                    });
                    this._button.data(exportData);
                    this._icon = renderer.path(ICON_COORDS).append(this._buttonGroup);
                    this._icon.attr({
                        fill: options.button.default.color,
                        cursor: "pointer"
                    });
                    this._icon.data(exportData);
                    this._buttonGroup.setTitle(_message2.default.format("vizExport-titleMenuText"))
                }
            },
            _updateList: function() {
                var options = this._options;
                var buttonDefault = options.button.default;
                var listGroup = this._listGroup;
                var items = createMenuItems(this._renderer, options);
                this._shadow.attr({
                    color: options.shadowColor
                });
                this._overlay.attr({
                    height: items.length * MENU_ITEM_HEIGHT + 2 * LIST_STROKE_WIDTH,
                    fill: buttonDefault.backgroundColor,
                    stroke: buttonDefault.borderColor
                });
                listGroup.clear();
                this._overlay.append(listGroup);
                items.forEach(function(item) {
                    return item.g.append(listGroup)
                });
                this._menuItems = items
            }
        });

        function getExportOptions(widget, exportOptions, fileName, format) {
            if (format || exportOptions.format) {
                format = validateFormat(format || exportOptions.format, widget._incidentOccurred)
            }
            return {
                format: format || DEFAULT_EXPORT_FORMAT,
                fileName: fileName || exportOptions.fileName || "file",
                proxyUrl: exportOptions.proxyUrl,
                backgroundColor: exportOptions.backgroundColor,
                width: widget._canvas.width,
                height: widget._canvas.height,
                margin: exportOptions.margin,
                forceProxy: exportOptions.forceProxy,
                exportingAction: widget._createActionByOption("onExporting"),
                exportedAction: widget._createActionByOption("onExported"),
                fileSavingAction: widget._createActionByOption("onFileSaving")
            }
        }
        exports.plugin = {
            name: "export",
            init: function() {
                var _this4 = this;
                this._exportMenu = new exports.ExportMenu({
                    renderer: this._renderer,
                    incidentOccurred: this._incidentOccurred,
                    print: function() {
                        return _this4.print()
                    },
                    exportTo: function(format) {
                        return _this4.exportTo(void 0, format)
                    }
                });
                this._layout.add(this._exportMenu)
            },
            dispose: function() {
                this._exportMenu.dispose()
            },
            members: {
                _getExportMenuOptions: function() {
                    return (0, _extend.extend)({}, this._getOption("export"), {
                        rtl: this._getOption("rtlEnabled", true)
                    })
                },
                _disablePointerEvents: function() {
                    var pointerEventsValue = this._renderer.root.attr("pointer-events");
                    this._renderer.root.attr({
                        "pointer-events": "none"
                    });
                    return pointerEventsValue
                },
                exportTo: function(fileName, format) {
                    var _this5 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {}, fileName, format);
                    menu && menu.hide();
                    var pointerEventsValue = this._disablePointerEvents();
                    _exporter2.default.export(this._renderer.root.element, options, getCreatorFunc(options.format)).done(function() {
                        _this5._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show()
                },
                print: function() {
                    var _this6 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {});
                    options.__test = this._getOption("export").__test;
                    options.exportingAction = null;
                    options.exportedAction = null;
                    options.margin = 0;
                    options.format = "PNG";
                    options.forceProxy = true;
                    options.fileSavingAction = function(eventArgs) {
                        _print("data:image/png;base64," + eventArgs.data, {
                            __test: options.__test
                        });
                        eventArgs.cancel = true
                    };
                    var pointerEventsValue = this._disablePointerEvents();
                    menu && menu.hide();
                    _exporter2.default.export(this._renderer.root.element, options, getCreatorFunc(options.format)).done(function() {
                        _this6._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show()
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                constructor.addChange({
                    code: "EXPORT",
                    handler: function() {
                        this._exportMenu.setOptions(this._getExportMenuOptions());
                        this._change(["LAYOUT"])
                    },
                    isThemeDependent: true,
                    isOptionChange: true,
                    option: "export"
                });
                proto._optionChangesMap.onExporting = "EXPORT";
                proto._optionChangesMap.onExported = "EXPORT";
                proto._optionChangesMap.onFileSaving = "EXPORT"
            },
            fontFields: ["export.font"]
        }
    },
    /*!***************************************!*\
      !*** ./artifacts/transpiled/color.js ***!
      \***************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    v = parseInt(colorString[3], 10),
                    rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    l = parseInt(colorString[3], 10),
                    rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var str, i = 0,
                ii = standardColorTypes.length;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var H, S, V, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                delta = max - min;
            V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var vDec, vInc, vMin, index, a, r, g, b;
            index = Math.floor(h % 360 / 60);
            vMin = (100 - s) * v / 100;
            a = (v - vMin) * (h % 60 / 60);
            vInc = vMin + a;
            vDec = v - a;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var h, s, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                maxMinSum = max + min,
                l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r, g, b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s,
                    p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        var _round = Math.round;
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor),
                    result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color,
                    rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        module.exports = Color
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter_registrator.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 48),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            dataUtils = __webpack_require__( /*! ../../core/element_data */ 39),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 13).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            registerEvent = __webpack_require__( /*! ./event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 24),
            wheelEvent = __webpack_require__( /*! ./wheel */ 124);
        var MANAGER_EVENT = "dxEventManager",
            EMITTER_DATA = "dxEmitter";
        var EventManager = Class.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                readyCallbacks.add(function() {
                    var document = domAdapter.getDocument();
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace([pointerEvents.up, pointerEvents.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(wheelEvent.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if (eventUtils.isMouseEvent(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                each(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this,
                    result = [],
                    $element = $(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = dataUtils.data($element.get(0), EMITTER_DATA) || [];
                    each(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = inArray(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e),
                    verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction,
                    prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter,
                emitterName = emitterConfig.events[0],
                emitterEvents = emitterConfig.events;
            each(emitterEvents, function(_, eventName) {
                registerEvent(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA) || {},
                            emitters = dataUtils.data(element, EMITTER_DATA) || {},
                            emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        dataUtils.data(element, EMITTER_DATA, emitters);
                        dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        emitter.configure(extend({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA),
                            emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        each(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        module.exports = registerEmitter
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/viz/core/base_widget.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            version = __webpack_require__( /*! ../../core/version */ 157),
            _windowResizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 130),
            _stringFormat = __webpack_require__( /*! ../../core/utils/string */ 46).format,
            _isObject = __webpack_require__( /*! ../../core/utils/type */ 1).isObject,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            themeManagerModule = __webpack_require__( /*! ../core/base_theme_manager */ 239),
            _floor = Math.floor,
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 67),
            helpers = __webpack_require__( /*! ./helpers */ 142),
            _parseScalar = __webpack_require__( /*! ./utils */ 10).parseScalar,
            errors = __webpack_require__( /*! ./errors_warnings */ 761),
            _log = errors.log,
            rendererModule = __webpack_require__( /*! ./renderers/renderer */ 175),
            _Layout = __webpack_require__( /*! ./layout */ 763),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            OPTION_RTL_ENABLED = "rtlEnabled",
            SIZED_ELEMENT_CLASS = "dx-sized-element",
            _option = DOMComponent.prototype.option;

        function getTrue() {
            return true
        }

        function getFalse() {
            return false
        }

        function areCanvasesDifferent(canvas1, canvas2) {
            return !(canvas1.width === canvas2.width && canvas1.height === canvas2.height && canvas1.left === canvas2.left && canvas1.top === canvas2.top && canvas1.right === canvas2.right && canvas1.bottom === canvas2.bottom)
        }

        function createResizeHandler(callback) {
            var timeout, handler = function() {
                clearTimeout(timeout);
                timeout = setTimeout(callback, 100)
            };
            handler.dispose = function() {
                clearTimeout(timeout);
                return this
            };
            return handler
        }

        function defaultOnIncidentOccurred(e) {
            if (!e.component.hasEvent("incidentOccurred")) {
                _log.apply(null, [e.target.id].concat(e.target.args || []))
            }
        }
        var createIncidentOccurred = function(widgetName, eventTrigger) {
            return function(id, args) {
                eventTrigger("incidentOccurred", {
                    target: {
                        id: id,
                        type: "E" === id[0] ? "error" : "warning",
                        args: args,
                        text: _stringFormat.apply(null, [errors.ERROR_MESSAGES[id]].concat(args || [])),
                        widget: widgetName,
                        version: version
                    }
                })
            }
        };

        function pickPositiveValue(values) {
            return values.reduce(function(result, value) {
                return value > 0 && !result ? value : result
            }, 0)
        }
        var getEmptyComponent = function() {
            var emptyComponentConfig = {};
            emptyComponentConfig.ctor = function(element, options) {
                this.callBase(element, options);
                var sizedElement = domAdapter.createElement("div");
                var width = options && typeUtils.isNumeric(options.width) ? options.width + "px" : "100%";
                var height = options && typeUtils.isNumeric(options.height) ? options.height + "px" : this._getDefaultSize().height + "px";
                domAdapter.setStyle(sizedElement, "width", width);
                domAdapter.setStyle(sizedElement, "height", height);
                domAdapter.setClass(sizedElement, SIZED_ELEMENT_CLASS);
                domAdapter.insertElement(element, sizedElement)
            };
            var EmptyComponent = DOMComponent.inherit(emptyComponentConfig);
            var originalInherit = EmptyComponent.inherit;
            EmptyComponent.inherit = function(config) {
                for (var field in config) {
                    if (typeUtils.isFunction(config[field]) && "_" !== field.substr(0, 1) || "_dispose" === field || "_optionChanged" === field) {
                        config[field] = noop
                    }
                }
                return originalInherit.call(this, config)
            };
            return EmptyComponent
        };
        var isServerSide = !windowUtils.hasWindow();

        function sizeIsValid(value) {
            return typeUtils.isDefined(value) && value > 0
        }
        module.exports = isServerSide ? getEmptyComponent() : DOMComponent.inherit({
            _eventsMap: {
                onIncidentOccurred: {
                    name: "incidentOccurred"
                },
                onDrawn: {
                    name: "drawn"
                }
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    onIncidentOccurred: defaultOnIncidentOccurred
                })
            },
            _useLinks: true,
            _init: function() {
                var linkTarget, that = this;
                that._$element.children("." + SIZED_ELEMENT_CLASS).remove();
                that.callBase.apply(that, arguments);
                that._changesLocker = 0;
                that._optionChangedLocker = 0;
                that._changes = helpers.changes();
                that._suspendChanges();
                that._themeManager = that._createThemeManager();
                that._themeManager.setCallback(function() {
                    that._requestChange(that._themeDependentChanges)
                });
                that._renderElementAttributes();
                that._initRenderer();
                linkTarget = that._useLinks && that._renderer.root;
                linkTarget && linkTarget.enableLinks().virtualLink("core").virtualLink("peripheral");
                that._renderVisibilityChange();
                that._attachVisibilityChangeHandlers();
                that._toggleParentsScrollSubscription(this._isVisible());
                that._initEventTrigger();
                that._incidentOccurred = createIncidentOccurred(that.NAME, that._eventTrigger);
                that._layout = new _Layout;
                linkTarget && linkTarget.linkAfter("core");
                that._initPlugins();
                that._initCore();
                linkTarget && linkTarget.linkAfter();
                that._change(that._initialChanges)
            },
            _createThemeManager: function() {
                return new themeManagerModule.BaseThemeManager(this._getThemeManagerOptions())
            },
            _getThemeManagerOptions: function() {
                return {
                    themeSection: this._themeSection,
                    fontFields: this._fontFields
                }
            },
            _initialChanges: ["LAYOUT", "RESIZE_HANDLER", "THEME", "DISABLED"],
            _initPlugins: function() {
                var that = this;
                each(that._plugins, function(_, plugin) {
                    plugin.init.call(that)
                })
            },
            _disposePlugins: function() {
                var that = this;
                each(that._plugins.slice().reverse(), function(_, plugin) {
                    plugin.dispose.call(that)
                })
            },
            _change: function(codes) {
                this._changes.add(codes)
            },
            _suspendChanges: function() {
                ++this._changesLocker
            },
            _resumeChanges: function() {
                var that = this;
                if (0 === --that._changesLocker && that._changes.count() > 0 && !that._applyingChanges) {
                    that._renderer.lock();
                    that._applyingChanges = true;
                    that._applyChanges();
                    that._changes.reset();
                    that._applyingChanges = false;
                    that._renderer.unlock();
                    if (that._optionsQueue) {
                        that._applyQueuedOptions()
                    }
                    that._optionChangedLocker++;
                    that._notify();
                    that._optionChangedLocker--
                }
            },
            _applyQueuedOptions: function() {
                var that = this,
                    queue = that._optionsQueue;
                that._optionsQueue = null;
                that.beginUpdate();
                each(queue, function(_, action) {
                    action()
                });
                that.endUpdate()
            },
            _requestChange: function(codes) {
                this._suspendChanges();
                this._change(codes);
                this._resumeChanges()
            },
            _applyChanges: function() {
                var i, that = this,
                    changes = that._changes,
                    order = that._totalChangesOrder,
                    ii = order.length;
                for (i = 0; i < ii; ++i) {
                    if (changes.has(order[i])) {
                        that["_change_" + order[i]]()
                    }
                }
            },
            _optionChangesOrder: ["EVENTS", "THEME", "RENDERER", "RESIZE_HANDLER"],
            _layoutChangesOrder: ["ELEMENT_ATTR", "CONTAINER_SIZE", "LAYOUT"],
            _customChangesOrder: ["DISABLED"],
            _change_EVENTS: function() {
                this._eventTrigger.applyChanges()
            },
            _change_THEME: function() {
                this._setThemeAndRtl()
            },
            _change_RENDERER: function() {
                this._setRendererOptions()
            },
            _change_RESIZE_HANDLER: function() {
                this._setupResizeHandler()
            },
            _change_ELEMENT_ATTR: function() {
                this._renderElementAttributes();
                this._change(["CONTAINER_SIZE"])
            },
            _change_CONTAINER_SIZE: function() {
                this._updateSize()
            },
            _change_LAYOUT: function() {
                this._setContentSize()
            },
            _change_DISABLED: function() {
                var renderer = this._renderer,
                    root = renderer.root;
                if (this.option("disabled")) {
                    this._initDisabledState = root.attr("pointer-events");
                    root.attr({
                        "pointer-events": "none",
                        filter: renderer.getGrayScaleFilter().id
                    })
                } else {
                    if ("none" === root.attr("pointer-events")) {
                        root.attr({
                            "pointer-events": typeUtils.isDefined(this._initDisabledState) ? this._initDisabledState : null,
                            filter: null
                        })
                    }
                }
            },
            _themeDependentChanges: ["RENDERER"],
            _initRenderer: function() {
                var that = this;
                that._canvas = that._calculateCanvas();
                that._renderer = new rendererModule.Renderer({
                    cssClass: that._rootClassPrefix + " " + that._rootClass,
                    pathModified: that.option("pathModified"),
                    container: that._$element[0]
                });
                that._renderer.resize(that._canvas.width, that._canvas.height)
            },
            _disposeRenderer: function() {
                this._useLinks && this._renderer.root.checkLinks();
                this._renderer.dispose()
            },
            _getAnimationOptions: noop,
            render: function() {
                this._requestChange(["CONTAINER_SIZE"]);
                var visible = this._isVisible();
                this._toggleParentsScrollSubscription(visible);
                !visible && this._stopCurrentHandling()
            },
            _toggleParentsScrollSubscription: function(subscribe) {
                var $parents = $(this._renderer.root.element).parents(),
                    scrollEvents = "scroll.viz_widgets";
                if ("generic" === devices.real().platform) {
                    $parents = $parents.add(windowUtils.getWindow())
                }
                this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function() {
                    this._stopCurrentHandling()
                }.bind(this);
                eventsEngine.off($().add(this._$prevRootParents), scrollEvents, this._proxiedTargetParentsScrollHandler);
                if (subscribe) {
                    eventsEngine.on($parents, scrollEvents, this._proxiedTargetParentsScrollHandler);
                    this._$prevRootParents = $parents
                }
            },
            _stopCurrentHandling: noop,
            _dispose: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                that._toggleParentsScrollSubscription(false);
                that._removeResizeHandler();
                that._layout.dispose();
                that._eventTrigger.dispose();
                that._disposeCore();
                that._disposePlugins();
                that._disposeRenderer();
                that._themeManager.dispose();
                that._themeManager = that._renderer = that._eventTrigger = null
            },
            _initEventTrigger: function() {
                var that = this;
                that._eventTrigger = createEventTrigger(that._eventsMap, function(name) {
                    return that._createActionByOption(name)
                })
            },
            _calculateCanvas: function() {
                var that = this,
                    size = that.option("size") || {},
                    margin = that.option("margin") || {},
                    defaultCanvas = that._getDefaultSize() || {},
                    elementWidth = !sizeIsValid(size.width) && windowUtils.hasWindow() ? that._$element.width() : 0,
                    elementHeight = !sizeIsValid(size.height) && windowUtils.hasWindow() ? that._$element.height() : 0,
                    canvas = {
                        width: size.width <= 0 ? 0 : _floor(pickPositiveValue([size.width, elementWidth, defaultCanvas.width])),
                        height: size.height <= 0 ? 0 : _floor(pickPositiveValue([size.height, elementHeight, defaultCanvas.height])),
                        left: pickPositiveValue([margin.left, defaultCanvas.left]),
                        top: pickPositiveValue([margin.top, defaultCanvas.top]),
                        right: pickPositiveValue([margin.right, defaultCanvas.right]),
                        bottom: pickPositiveValue([margin.bottom, defaultCanvas.bottom])
                    };
                if (canvas.width - canvas.left - canvas.right <= 0 || canvas.height - canvas.top - canvas.bottom <= 0) {
                    canvas = {
                        width: 0,
                        height: 0
                    }
                }
                return canvas
            },
            _updateSize: function() {
                var that = this,
                    canvas = that._calculateCanvas();
                that._renderer.fixPlacement();
                if (areCanvasesDifferent(that._canvas, canvas) || that.__forceRender) {
                    that._canvas = canvas;
                    that._recreateSizeDependentObjects(true);
                    that._renderer.resize(canvas.width, canvas.height);
                    that._change(["LAYOUT"])
                }
            },
            _recreateSizeDependentObjects: noop,
            _getMinSize: function() {
                return [0, 0]
            },
            _getAlignmentRect: noop,
            _setContentSize: function() {
                var nextRect, canvas = this._canvas,
                    layout = this._layout,
                    rect = canvas.width > 0 && canvas.height > 0 ? [canvas.left, canvas.top, canvas.width - canvas.right, canvas.height - canvas.bottom] : [0, 0, 0, 0];
                rect = layout.forward(rect, this._getMinSize());
                nextRect = this._applySize(rect) || rect;
                layout.backward(nextRect, this._getAlignmentRect() || nextRect)
            },
            DEBUG_getCanvas: function() {
                return this._canvas
            },
            DEBUG_getEventTrigger: function() {
                return this._eventTrigger
            },
            _getOption: function(name, isScalar) {
                var theme = this._themeManager.theme(name),
                    option = this.option(name);
                return isScalar ? void 0 !== option ? option : theme : extend(true, {}, theme, option)
            },
            _setupResizeHandler: function() {
                var that = this,
                    redrawOnResize = _parseScalar(this._getOption("redrawOnResize", true), true);
                if (that._resizeHandler) {
                    that._removeResizeHandler()
                }
                that._resizeHandler = createResizeHandler(function() {
                    if (redrawOnResize) {
                        that._requestChange(["CONTAINER_SIZE"])
                    } else {
                        that._renderer.fixPlacement()
                    }
                });
                _windowResizeCallbacks.add(that._resizeHandler)
            },
            _removeResizeHandler: function() {
                if (this._resizeHandler) {
                    _windowResizeCallbacks.remove(this._resizeHandler);
                    this._resizeHandler.dispose();
                    this._resizeHandler = null
                }
            },
            _onBeginUpdate: noop,
            beginUpdate: function() {
                var that = this;
                if (that._initialized && 0 === that._updateLockCount) {
                    that._onBeginUpdate();
                    that._suspendChanges()
                }
                that.callBase.apply(that, arguments);
                return that
            },
            endUpdate: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                if (0 === that._updateLockCount) {
                    that._resumeChanges()
                }
                return that
            },
            option: function(name) {
                var that = this;
                if (that._initialized && that._applyingChanges && (arguments.length > 1 || _isObject(name))) {
                    that._optionsQueue = that._optionsQueue || [];
                    that._optionsQueue.push(that._getActionForUpdating(arguments))
                } else {
                    return _option.apply(that, arguments)
                }
            },
            _getActionForUpdating: function(args) {
                var that = this;
                return that._deprecatedOptionsSuppressed ? function() {
                    that._suppressDeprecatedWarnings();
                    _option.apply(that, args);
                    that._resumeDeprecatedWarnings()
                } : function() {
                    _option.apply(that, args)
                }
            },
            _clean: noop,
            _render: noop,
            _optionChanged: function(arg) {
                var that = this;
                if (that._optionChangedLocker) {
                    return
                }
                var partialChanges = that.getPartialChangeOptionsName(arg);
                var changes = [];
                if (partialChanges.length > 0) {
                    partialChanges.forEach(function(pc) {
                        return changes.push(that._partialOptionChangesMap[pc])
                    })
                } else {
                    changes.push(that._optionChangesMap[arg.name])
                }
                changes = changes.filter(function(c) {
                    return !!c
                });
                if (that._eventTrigger.change(arg.name)) {
                    that._change(["EVENTS"])
                } else {
                    if (changes.length > 0) {
                        that._change(changes)
                    } else {
                        that.callBase.apply(that, arguments)
                    }
                }
            },
            _notify: noop,
            _optionChangesMap: {
                size: "CONTAINER_SIZE",
                margin: "CONTAINER_SIZE",
                redrawOnResize: "RESIZE_HANDLER",
                theme: "THEME",
                rtlEnabled: "THEME",
                encodeHtml: "THEME",
                elementAttr: "ELEMENT_ATTR",
                disabled: "DISABLED"
            },
            _partialOptionChangesMap: {},
            _partialOptionChangesPath: {},
            getPartialChangeOptionsName: function(changedOption) {
                var that = this;
                var fullName = changedOption.fullName;
                var sections = fullName.split(/[.]/);
                var name = changedOption.name;
                var value = changedOption.value;
                var options = this._partialOptionChangesPath[name];
                var partialChangeOptionsName = [];
                if (options) {
                    if (true === options) {
                        partialChangeOptionsName.push(name)
                    } else {
                        options.forEach(function(op) {
                            fullName.indexOf(op) >= 0 && partialChangeOptionsName.push(op)
                        });
                        if (1 === sections.length) {
                            if ("object" === typeUtils.type(value)) {
                                that._addOptionsNameForPartialUpdate(value, options, partialChangeOptionsName)
                            } else {
                                if ("array" === typeUtils.type(value)) {
                                    if (value.length > 0 && value.every(function(item) {
                                            return that._checkOptionsForPartialUpdate(item, options)
                                        })) {
                                        value.forEach(function(item) {
                                            return that._addOptionsNameForPartialUpdate(item, options, partialChangeOptionsName)
                                        })
                                    }
                                }
                            }
                        }
                    }
                }
                return partialChangeOptionsName.filter(function(value, index, self) {
                    return self.indexOf(value) === index
                })
            },
            _checkOptionsForPartialUpdate: function(optionObject, options) {
                return !Object.keys(optionObject).some(function(key) {
                    return options.indexOf(key) === -1
                })
            },
            _addOptionsNameForPartialUpdate: function(optionObject, options, partialChangeOptionsName) {
                var optionKeys = Object.keys(optionObject);
                if (this._checkOptionsForPartialUpdate(optionObject, options)) {
                    optionKeys.forEach(function(key) {
                        return options.indexOf(key) > -1 && partialChangeOptionsName.push(key)
                    })
                }
            },
            _visibilityChanged: function() {
                this.render()
            },
            _setThemeAndRtl: function() {
                this._themeManager.setTheme(this.option("theme"), this.option(OPTION_RTL_ENABLED))
            },
            _getRendererOptions: function() {
                return {
                    rtl: this.option(OPTION_RTL_ENABLED),
                    encodeHtml: this.option("encodeHtml"),
                    animation: this._getAnimationOptions()
                }
            },
            _setRendererOptions: function() {
                this._renderer.setOptions(this._getRendererOptions())
            },
            svg: function() {
                return this._renderer.svg()
            },
            getSize: function() {
                var canvas = this._canvas || {};
                return {
                    width: canvas.width,
                    height: canvas.height
                }
            },
            isReady: getFalse,
            _dataIsReady: getTrue,
            _resetIsReady: function() {
                this.isReady = getFalse
            },
            _drawn: function() {
                var that = this;
                that.isReady = getFalse;
                if (that._dataIsReady()) {
                    that._renderer.onEndAnimation(function() {
                        that.isReady = getTrue
                    })
                }
                that._eventTrigger("drawn", {})
            }
        });
        helpers.replaceInherit(module.exports);

        function createEventTrigger(eventsMap, callbackGetter) {
            var triggers = {};
            each(eventsMap, function(name, info) {
                if (info.name) {
                    createEvent(name)
                }
            });
            var changes;
            triggerEvent.change = function(name) {
                var eventInfo = eventsMap[name];
                if (eventInfo) {
                    (changes = changes || {})[name] = eventInfo
                }
                return !!eventInfo
            };
            triggerEvent.applyChanges = function() {
                if (changes) {
                    each(changes, function(name, eventInfo) {
                        createEvent(eventInfo.newName || name)
                    });
                    changes = null
                }
            };
            triggerEvent.dispose = function() {
                eventsMap = callbackGetter = triggers = null
            };
            return triggerEvent;

            function createEvent(name) {
                var eventInfo = eventsMap[name];
                triggers[eventInfo.name] = callbackGetter(name)
            }

            function triggerEvent(name, arg, complete) {
                triggers[name](arg);
                complete && complete()
            }
        }
        module.exports.DEBUG_createEventTrigger = createEventTrigger;
        module.exports.DEBUG_createIncidentOccurred = createIncidentOccurred;
        module.exports.DEBUG_stub_createIncidentOccurred = function(stub) {
            createIncidentOccurred = stub
        };
        module.exports.DEBUG_restore_createIncidentOccurred = function() {
            createIncidentOccurred = module.exports.DEBUG_createIncidentOccurred
        };
        module.exports.DEBUG_createResizeHandler = createResizeHandler
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/position.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 31);
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = isRtlEnabled || config().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/data/abstract_store.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 15),
            abstract = Class.abstract,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 81),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            errorsModule = __webpack_require__( /*! ./errors */ 36),
            dataUtils = __webpack_require__( /*! ./utils */ 40),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 20).compileGetter,
            storeHelper = __webpack_require__( /*! ./store_helper */ 79),
            queryByOptions = storeHelper.queryByOptions,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            storeImpl = {};
        var Store = Class.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                each(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = compileGetter(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw errorsModule.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new Deferred;
                task.done(function() {
                    var that = this,
                        args = arguments;
                    dataUtils.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that.fireEvent("inserted", [callbackValues, callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function() {
                    that.fireEvent("updated", [key, values]);
                    that.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            push: function(changes) {
                this._pushImpl(changes);
                this.fireEvent("push", [changes])
            },
            _pushImpl: noop,
            remove: function(key) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that.fireEvent("removed", [callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(errorsModule._errorHandler)
            }
        }).include(EventsMixin);
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw errorsModule.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.registerClass = function(type, alias) {
            if (alias) {
                storeImpl[alias] = type
            }
            return type
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                Store.registerClass(type, alias);
                return type
            }
        }(Store.inherit);
        module.exports = Store
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/ui/validation_engine.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 15),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 81),
            errors = __webpack_require__( /*! ../core/errors */ 21),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            numberLocalization = __webpack_require__( /*! ../localization/number */ 51),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 14);
        var BaseRuleValidator = Class.inherit({
            NAME: "base",
            defaultMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME)(value)
            },
            defaultFormattedMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME + "-formatted")(value)
            },
            _isValueEmpty: function(value) {
                return !rulesValidators.required.validate(value, {})
            },
            validate: function(value, rule) {
                var valueArray = Array.isArray(value) ? value : [value],
                    result = true;
                if (valueArray.length) {
                    valueArray.every(function(itemValue) {
                        result = this._validate(itemValue, rule);
                        return result
                    }, this)
                } else {
                    result = this._validate(null, rule)
                }
                return result
            }
        });
        var RequiredRuleValidator = BaseRuleValidator.inherit({
            NAME: "required",
            _validate: function(value, rule) {
                if (!typeUtils.isDefined(value)) {
                    return false
                }
                if (false === value) {
                    return false
                }
                value = String(value);
                if (rule.trim || !typeUtils.isDefined(rule.trim)) {
                    value = value.trim()
                }
                return "" !== value
            }
        });
        var NumericRuleValidator = BaseRuleValidator.inherit({
            NAME: "numeric",
            _validate: function(value, rule) {
                if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                if (rule.useCultureSettings && typeUtils.isString(value)) {
                    return !isNaN(numberLocalization.parse(value))
                } else {
                    return typeUtils.isNumeric(value)
                }
            }
        });
        var RangeRuleValidator = BaseRuleValidator.inherit({
            NAME: "range",
            _validate: function(value, rule) {
                if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                var validNumber = rulesValidators.numeric.validate(value, rule),
                    validValue = typeUtils.isDefined(value) && "" !== value,
                    number = validNumber ? parseFloat(value) : validValue && value.valueOf(),
                    min = rule.min,
                    max = rule.max;
                if (!(validNumber || typeUtils.isDate(value)) && !validValue) {
                    return false
                }
                if (typeUtils.isDefined(min)) {
                    if (typeUtils.isDefined(max)) {
                        return number >= min && number <= max
                    }
                    return number >= min
                } else {
                    if (typeUtils.isDefined(max)) {
                        return number <= max
                    } else {
                        throw errors.Error("E0101")
                    }
                }
            }
        });
        var StringLengthRuleValidator = BaseRuleValidator.inherit({
            NAME: "stringLength",
            _validate: function(value, rule) {
                value = typeUtils.isDefined(value) ? String(value) : "";
                if (rule.trim || !typeUtils.isDefined(rule.trim)) {
                    value = value.trim()
                }
                if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                return rulesValidators.range.validate(value.length, extend({}, rule))
            }
        });
        var CustomRuleValidator = BaseRuleValidator.inherit({
            NAME: "custom",
            validate: function(value, rule) {
                if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                var validator = rule.validator,
                    dataGetter = validator && typeUtils.isFunction(validator.option) && validator.option("dataGetter"),
                    data = typeUtils.isFunction(dataGetter) && dataGetter(),
                    params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                if (data) {
                    params.data = data
                }
                return rule.validationCallback(params)
            }
        });
        var CompareRuleValidator = BaseRuleValidator.inherit({
            NAME: "compare",
            _validate: function(value, rule) {
                if (!rule.comparisonTarget) {
                    throw errors.Error("E0102")
                }
                if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                extend(rule, {
                    reevaluate: true
                });
                var otherValue = rule.comparisonTarget(),
                    type = rule.comparisonType || "==";
                switch (type) {
                    case "==":
                        return value == otherValue;
                    case "!=":
                        return value != otherValue;
                    case "===":
                        return value === otherValue;
                    case "!==":
                        return value !== otherValue;
                    case ">":
                        return value > otherValue;
                    case ">=":
                        return value >= otherValue;
                    case "<":
                        return value < otherValue;
                    case "<=":
                        return value <= otherValue
                }
            }
        });
        var PatternRuleValidator = BaseRuleValidator.inherit({
            NAME: "pattern",
            _validate: function(value, rule) {
                if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                var pattern = rule.pattern;
                if (typeUtils.isString(pattern)) {
                    pattern = new RegExp(pattern)
                }
                return pattern.test(value)
            }
        });
        var EmailRuleValidator = BaseRuleValidator.inherit({
            NAME: "email",
            _validate: function(value, rule) {
                if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                    return true
                }
                return rulesValidators.pattern.validate(value, extend({}, rule, {
                    pattern: /^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i
                }))
            }
        });
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = Class.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = []
            },
            validate: function() {
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: []
                };
                each(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRule) {
                        result.brokenRules.push(validatorResult.brokenRule)
                    }
                    result.validators.push(validator)
                });
                this.fireEvent("validated", [{
                    validators: result.validators,
                    brokenRules: result.brokenRules,
                    isValid: result.isValid
                }]);
                return result
            },
            reset: function() {
                each(this.validators, function(_, validator) {
                    validator.reset()
                })
            }
        }).include(EventsMixin);
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = commonUtils.grep(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group),
                    index = inArray(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(rule, validator, name) {
                if (!typeUtils.isDefined(rule.message)) {
                    if (validator.defaultFormattedMessage && typeUtils.isDefined(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            validate: function(value, rules, name) {
                var result = {
                        name: name,
                        value: value,
                        brokenRule: null,
                        isValid: true,
                        validationRules: rules
                    },
                    that = this;
                each(rules || [], function(_, rule) {
                    var ruleValidationResult, ruleValidator = rulesValidators[rule.type];
                    if (ruleValidator) {
                        if (typeUtils.isDefined(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                result.brokenRule = rule;
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            that._setDefaultMessage(rule, ruleValidator, name);
                            result.brokenRule = rule
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw errors.Error("E0100")
                    }
                });
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                if (inArray(validator, groupConfig.validators) < 0) {
                    groupConfig.validators.push(validator)
                }
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group,
                    isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group),
                    validatorsInGroup = config && config.validators;
                var index = inArray(validator, validatorsInGroup);
                if (index > -1) {
                    validatorsInGroup.splice(index, 1);
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        module.exports = ValidationEngine
    }, , , , , ,
    /*!************************************************!*\
      !*** ./artifacts/transpiled/viz/core/title.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _Number = Number,
            _isString = __webpack_require__( /*! ../../core/utils/type */ 1).isString,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            _patchFontOptions = __webpack_require__( /*! ./utils */ 10).patchFontOptions,
            parseHorizontalAlignment = __webpack_require__( /*! ./utils */ 10).enumParser(["left", "center", "right"]),
            parseVerticalAlignment = __webpack_require__( /*! ./utils */ 10).enumParser(["top", "bottom"]),
            DEFAULT_MARGIN = 10;

        function hasText(text) {
            return !!(text && String(text).length > 0)
        }

        function processTitleLength(elem, text, width, options, placeholderSize) {
            if (elem.attr({
                    text: text
                }).setMaxSize(width, placeholderSize, options).textChanged) {
                elem.setTitle(text)
            }
        }

        function pickMarginValue(value) {
            return value >= 0 ? _Number(value) : DEFAULT_MARGIN
        }

        function validateMargin(margin) {
            var result;
            if (margin >= 0) {
                result = {
                    left: _Number(margin),
                    top: _Number(margin),
                    right: _Number(margin),
                    bottom: _Number(margin)
                }
            } else {
                margin = margin || {};
                result = {
                    left: pickMarginValue(margin.left),
                    top: pickMarginValue(margin.top),
                    right: pickMarginValue(margin.right),
                    bottom: pickMarginValue(margin.bottom)
                }
            }
            return result
        }

        function checkRect(rect, boundingRect) {
            return rect[2] - rect[0] < boundingRect.width || rect[3] - rect[1] < boundingRect.height
        }

        function Title(params) {
            this._params = params;
            this._group = params.renderer.g().attr({
                "class": params.cssClass
            }).linkOn(params.root || params.renderer.root, "title");
            this._hasText = false
        }
        extend(Title.prototype, __webpack_require__( /*! ./layout_element */ 240).LayoutElement.prototype, {
            dispose: function() {
                var that = this;
                that._group.linkRemove();
                that._group.linkOff();
                if (that._titleElement) {
                    that._clipRect.dispose();
                    that._titleElement = that._subtitleElement = that._clipRect = null
                }
                that._params = that._group = that._options = null
            },
            _updateOptions: function(options) {
                this._options = options;
                this._options.horizontalAlignment = parseHorizontalAlignment(options.horizontalAlignment, "center");
                this._options.verticalAlignment = parseVerticalAlignment(options.verticalAlignment, "top");
                this._options.margin = validateMargin(options.margin)
            },
            _updateStructure: function() {
                var that = this;
                var renderer = that._params.renderer;
                var group = that._group;
                var options = that._options;
                var align = options.horizontalAlignment;
                if (!that._titleElement) {
                    that._titleElement = renderer.text().append(group);
                    that._subtitleElement = renderer.text();
                    that._clipRect = renderer.clipRect();
                    group.attr({
                        "clip-path": that._clipRect.id
                    })
                }
                that._titleElement.attr({
                    align: align,
                    "class": options.cssClass
                });
                that._subtitleElement.attr({
                    align: align,
                    "class": options.subtitle.cssClass
                });
                group.linkAppend();
                hasText(options.subtitle.text) ? that._subtitleElement.append(group) : that._subtitleElement.remove()
            },
            _updateTexts: function() {
                var titleBox, y, that = this,
                    options = that._options,
                    subtitleOptions = options.subtitle,
                    titleElement = that._titleElement,
                    subtitleElement = that._subtitleElement,
                    testText = "A";
                titleElement.attr({
                    text: testText,
                    y: 0
                }).css(_patchFontOptions(options.font));
                titleBox = titleElement.getBBox();
                that._baseLineCorrection = titleBox.height + titleBox.y;
                titleElement.attr({
                    text: options.text
                });
                titleBox = titleElement.getBBox();
                y = -titleBox.y;
                titleElement.attr({
                    y: y
                });
                if (hasText(subtitleOptions.text)) {
                    subtitleElement.attr({
                        text: subtitleOptions.text,
                        y: 0
                    }).css(_patchFontOptions(subtitleOptions.font))
                }
            },
            _shiftSubtitle: function() {
                var that = this;
                var titleBox = that._titleElement.getBBox();
                var element = that._subtitleElement;
                var offset = that._options.subtitle.offset;
                element.move(0, titleBox.y + titleBox.height - element.getBBox().y - offset)
            },
            _updateBoundingRectAlignment: function() {
                var boundingRect = this._boundingRect,
                    options = this._options;
                boundingRect.verticalAlignment = options.verticalAlignment;
                boundingRect.horizontalAlignment = options.horizontalAlignment;
                boundingRect.cutLayoutSide = options.verticalAlignment;
                boundingRect.cutSide = "vertical";
                boundingRect.position = {
                    horizontal: options.horizontalAlignment,
                    vertical: options.verticalAlignment
                }
            },
            hasText: function() {
                return this._hasText
            },
            update: function(themeOptions, userOptions) {
                var that = this,
                    options = extend(true, {}, themeOptions, processTitleOptions(userOptions)),
                    _hasText = hasText(options.text),
                    isLayoutChanged = _hasText || _hasText !== that._hasText;
                that._baseLineCorrection = 0;
                that._updateOptions(options);
                that._boundingRect = {};
                if (_hasText) {
                    that._updateStructure();
                    that._updateTexts()
                } else {
                    that._group.linkRemove()
                }
                that._updateBoundingRect();
                that._updateBoundingRectAlignment();
                that._hasText = _hasText;
                return isLayoutChanged
            },
            draw: function(width, height) {
                var that = this;
                if (that._hasText) {
                    that._group.linkAppend();
                    that._correctTitleLength(width);
                    if (that._group.getBBox().height > height) {
                        this.freeSpace()
                    }
                }
                return that
            },
            probeDraw: function(width, height) {
                this.draw(width, height);
                return this
            },
            _correctTitleLength: function(width) {
                var that = this;
                var options = that._options;
                var margin = options.margin;
                var maxWidth = width - margin.left - margin.right;
                var placeholderSize = options.placeholderSize;
                processTitleLength(that._titleElement, options.text, maxWidth, options, placeholderSize);
                if (that._subtitleElement) {
                    if (_Number(placeholderSize) > 0) {
                        placeholderSize -= that._titleElement.getBBox().height
                    }
                    processTitleLength(that._subtitleElement, options.subtitle.text, maxWidth, options.subtitle, placeholderSize);
                    that._shiftSubtitle()
                }
                that._updateBoundingRect();
                var _getCorrectedLayoutOp = this.getCorrectedLayoutOptions(),
                    x = _getCorrectedLayoutOp.x,
                    y = _getCorrectedLayoutOp.y,
                    height = _getCorrectedLayoutOp.height;
                this._clipRect.attr({
                    x: x,
                    y: y,
                    width: width,
                    height: height
                })
            },
            getLayoutOptions: function() {
                return this._boundingRect || null
            },
            shift: function(x, y) {
                var that = this,
                    box = that.getLayoutOptions();
                that._group.move(x - box.x, y - box.y);
                return that
            },
            _updateBoundingRect: function() {
                var box, that = this,
                    options = that._options,
                    margin = options.margin,
                    boundingRect = that._boundingRect;
                box = that._hasText ? that._group.getBBox() : {
                    width: 0,
                    height: 0,
                    x: 0,
                    y: 0,
                    isEmpty: true
                };
                if (!box.isEmpty) {
                    box.height += margin.top + margin.bottom - that._baseLineCorrection;
                    box.width += margin.left + margin.right;
                    box.x -= margin.left;
                    box.y += that._baseLineCorrection - margin.top
                }
                if (options.placeholderSize > 0) {
                    box.height = options.placeholderSize
                }
                boundingRect.height = box.height;
                boundingRect.width = box.width;
                boundingRect.x = box.x;
                boundingRect.y = box.y
            },
            getCorrectedLayoutOptions: function() {
                var srcBox = this.getLayoutOptions();
                var correction = this._baseLineCorrection;
                return extend({}, srcBox, {
                    y: srcBox.y - correction,
                    height: srcBox.height + correction
                })
            },
            layoutOptions: function() {
                if (!this._hasText) {
                    return null
                }
                return {
                    horizontalAlignment: this._boundingRect.horizontalAlignment,
                    verticalAlignment: this._boundingRect.verticalAlignment,
                    priority: 0
                }
            },
            measure: function(size) {
                this.draw(size[0], size[1]);
                return [this._boundingRect.width, this._boundingRect.height]
            },
            move: function(rect, fitRect) {
                var boundingRect = this._boundingRect;
                if (checkRect(rect, boundingRect)) {
                    this.shift(fitRect[0], fitRect[1])
                } else {
                    this.shift(Math.round(rect[0]), Math.round(rect[1]))
                }
            },
            freeSpace: function() {
                var that = this;
                that._params.incidentOccurred("W2103");
                that._group.linkRemove();
                that._boundingRect.width = that._boundingRect.height = 0
            },
            getOptions: function() {
                return this._options
            },
            changeLink: function(root) {
                this._group.linkRemove();
                this._group.linkOn(root, "title")
            }
        });
        exports.Title = Title;
        Title.prototype.DEBUG_getOptions = function() {
            return this._options
        };

        function processTitleOptions(options) {
            var newOptions = _isString(options) ? {
                text: options
            } : options || {};
            newOptions.subtitle = _isString(newOptions.subtitle) ? {
                text: newOptions.subtitle
            } : newOptions.subtitle || {};
            return newOptions
        }
        exports.plugin = {
            name: "title",
            init: function() {
                var that = this;
                that._title = new exports.Title({
                    renderer: that._renderer,
                    cssClass: that._rootClassPrefix + "-title",
                    incidentOccurred: that._incidentOccurred
                });
                that._layout.add(that._title)
            },
            dispose: function() {
                this._title.dispose();
                this._title = null
            },
            customize: function(constructor) {
                constructor.addChange({
                    code: "TITLE",
                    handler: function() {
                        if (this._title.update(this._themeManager.theme("title"), this.option("title"))) {
                            this._change(["LAYOUT"])
                        }
                    },
                    isThemeDependent: true,
                    option: "title",
                    isOptionChange: true
                })
            },
            fontFields: ["title.font", "title.subtitle.font"]
        }
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/viz/series/scatter_series.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 13).inArray,
            _each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            rangeCalculator = __webpack_require__( /*! ./helpers/range_data_calculator */ 245),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            vizUtils = __webpack_require__( /*! ../core/utils */ 10),
            _noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            _isDefined = typeUtils.isDefined,
            _isString = typeUtils.isString,
            _map = vizUtils.map,
            _normalizeEnum = vizUtils.normalizeEnum,
            math = Math,
            _abs = math.abs,
            _sqrt = math.sqrt,
            _max = math.max,
            DEFAULT_TRACKER_WIDTH = 12,
            DEFAULT_DURATION = 400,
            HIGH_ERROR = "highError",
            LOW_ERROR = "lowError",
            VARIANCE = "variance",
            STANDARD_DEVIATION = "stddeviation",
            STANDARD_ERROR = "stderror",
            PERCENT = "percent",
            FIXED = "fixed",
            UNDEFINED = "undefined",
            DISCRETE = "discrete",
            LOGARITHMIC = "logarithmic",
            DATETIME = "datetime";
        exports.chart = {};
        exports.polar = {};

        function sum(array) {
            var result = 0;
            _each(array, function(_, value) {
                result += value
            });
            return result
        }

        function isErrorBarTypeCorrect(type) {
            return inArray(type, [FIXED, PERCENT, VARIANCE, STANDARD_DEVIATION, STANDARD_ERROR]) !== -1
        }

        function variance(array, expectedValue) {
            return sum(_map(array, function(value) {
                return (value - expectedValue) * (value - expectedValue)
            })) / array.length
        }

        function calculateAvgErrorBars(result, data, series) {
            var errorBarsOptions = series.getOptions().valueErrorBar,
                valueField = series.getValueFields()[0],
                lowValueField = errorBarsOptions.lowValueField || LOW_ERROR,
                highValueField = errorBarsOptions.highValueField || HIGH_ERROR;
            if (series.areErrorBarsVisible() && void 0 === errorBarsOptions.type) {
                var fusionData = data.reduce(function(result, item) {
                    if (_isDefined(item[lowValueField])) {
                        result[0] += item[valueField] - item[lowValueField];
                        result[1]++
                    }
                    if (_isDefined(item[highValueField])) {
                        result[2] += item[highValueField] - item[valueField];
                        result[3]++
                    }
                    return result
                }, [0, 0, 0, 0]);
                if (fusionData[1]) {
                    result[lowValueField] = result[valueField] - fusionData[0] / fusionData[1]
                }
                if (fusionData[2]) {
                    result[highValueField] = result[valueField] + fusionData[2] / fusionData[3]
                }
            }
            return result
        }

        function calculateSumErrorBars(result, data, series) {
            var errorBarsOptions = series.getOptions().valueErrorBar,
                lowValueField = errorBarsOptions.lowValueField || LOW_ERROR,
                highValueField = errorBarsOptions.highValueField || HIGH_ERROR;
            if (series.areErrorBarsVisible() && void 0 === errorBarsOptions.type) {
                result[lowValueField] = 0;
                result[highValueField] = 0;
                result = data.reduce(function(result, item) {
                    result[lowValueField] += item[lowValueField];
                    result[highValueField] += item[highValueField];
                    return result
                }, result)
            }
            return result
        }

        function getMinMaxAggregator(compare) {
            return function(_ref, series) {
                var intervalStart = _ref.intervalStart,
                    data = _ref.data;
                var valueField = series.getValueFields()[0];
                var targetData = data[0];
                targetData = data.reduce(function(result, item) {
                    var value = item[valueField];
                    if (null === result[valueField]) {
                        result = item
                    }
                    if (null !== value && compare(value, result[valueField])) {
                        return item
                    }
                    return result
                }, targetData);
                return _extend({}, targetData, _defineProperty({}, series.getArgumentField(), intervalStart))
            }
        }

        function checkFields(data, fieldsToCheck, skippedFields) {
            var allFieldsIsValid = true;
            for (var field in fieldsToCheck) {
                var isArgument = "argument" === field;
                if (isArgument || "size" === field ? !_isDefined(data[field]) : void 0 === data[field]) {
                    var selector = fieldsToCheck[field];
                    if (!isArgument) {
                        skippedFields[selector] = (skippedFields[selector] || 0) + 1
                    }
                    allFieldsIsValid = false
                }
            }
            return allFieldsIsValid
        }
        var baseScatterMethods = {
            _defaultDuration: DEFAULT_DURATION,
            _defaultTrackerWidth: DEFAULT_TRACKER_WIDTH,
            _applyStyle: _noop,
            _updateOptions: _noop,
            _parseStyle: _noop,
            _prepareSegment: _noop,
            _drawSegment: _noop,
            _appendInGroup: function() {
                this._group.append(this._extGroups.seriesGroup)
            },
            _createLegendState: function(styleOptions, defaultColor) {
                return {
                    fill: styleOptions.color || defaultColor,
                    hatching: styleOptions.hatching ? _extend({}, styleOptions.hatching, {
                        direction: "right"
                    }) : void 0
                }
            },
            _applyElementsClipRect: function(settings) {
                settings["clip-path"] = this._paneClipRectID
            },
            _applyMarkerClipRect: function(settings) {
                settings["clip-path"] = this._forceClipping ? this._paneClipRectID : null
            },
            _createGroup: function(groupName, parent, target, settings) {
                var group = parent[groupName] = parent[groupName] || this._renderer.g();
                target && group.append(target);
                settings && group.attr(settings)
            },
            _applyClearingSettings: function(settings) {
                settings.opacity = null;
                settings.scale = null;
                if (this._options.rotated) {
                    settings.translateX = null
                } else {
                    settings.translateY = null
                }
            },
            _createGroups: function() {
                var that = this;
                that._createGroup("_markersGroup", that, that._group);
                that._createGroup("_labelsGroup", that)
            },
            _setMarkerGroupSettings: function() {
                var that = this,
                    settings = that._createPointStyles(that._getMarkerGroupOptions()).normal;
                settings.class = "dxc-markers";
                settings.opacity = 1;
                that._applyMarkerClipRect(settings);
                that._markersGroup.attr(settings)
            },
            getVisibleArea: function() {
                return this._visibleArea
            },
            areErrorBarsVisible: function() {
                var errorBarOptions = this._options.valueErrorBar;
                return errorBarOptions && this._errorBarsEnabled() && "none" !== errorBarOptions.displayMode && (isErrorBarTypeCorrect(_normalizeEnum(errorBarOptions.type)) || _isDefined(errorBarOptions.lowValueField) || _isDefined(errorBarOptions.highValueField))
            },
            groupPointsByCoords: function(rotated) {
                var cat = [];
                _each(this.getVisiblePoints(), function(_, p) {
                    var pointCoord = parseInt(rotated ? p.vy : p.vx);
                    if (!cat[pointCoord]) {
                        cat[pointCoord] = p
                    } else {
                        Array.isArray(cat[pointCoord]) ? cat[pointCoord].push(p) : cat[pointCoord] = [cat[pointCoord], p]
                    }
                });
                return cat
            },
            _createErrorBarGroup: function(animationEnabled) {
                var settings, that = this,
                    errorBarOptions = that._options.valueErrorBar;
                if (that.areErrorBarsVisible()) {
                    settings = {
                        "class": "dxc-error-bars",
                        stroke: errorBarOptions.color,
                        "stroke-width": errorBarOptions.lineWidth,
                        opacity: animationEnabled ? .001 : errorBarOptions.opacity || 1,
                        "stroke-linecap": "square",
                        sharp: true,
                        "clip-path": that._forceClipping ? that._paneClipRectID : that._widePaneClipRectID
                    };
                    that._createGroup("_errorBarGroup", that, that._group, settings)
                }
            },
            _setGroupsSettings: function(animationEnabled) {
                var that = this;
                that._setMarkerGroupSettings();
                that._setLabelGroupSettings(animationEnabled);
                that._createErrorBarGroup(animationEnabled)
            },
            _getCreatingPointOptions: function() {
                var defaultPointOptions, normalStyle, that = this,
                    creatingPointOptions = that._predefinedPointOptions;
                if (!creatingPointOptions) {
                    defaultPointOptions = that._getPointOptions();
                    that._predefinedPointOptions = creatingPointOptions = _extend(true, {
                        styles: {}
                    }, defaultPointOptions);
                    normalStyle = defaultPointOptions.styles && defaultPointOptions.styles.normal || {};
                    creatingPointOptions.styles = creatingPointOptions.styles || {};
                    creatingPointOptions.styles.normal = {
                        "stroke-width": normalStyle["stroke-width"],
                        r: normalStyle.r,
                        opacity: normalStyle.opacity
                    }
                }
                return creatingPointOptions
            },
            _getPointOptions: function() {
                return this._parsePointOptions(this._preparePointOptions(), this._options.label)
            },
            _getOptionsForPoint: function() {
                return this._options.point
            },
            _parsePointStyle: function(style, defaultColor, defaultBorderColor, defaultSize) {
                var border = style.border || {},
                    sizeValue = void 0 !== style.size ? style.size : defaultSize;
                return {
                    fill: style.color || defaultColor,
                    stroke: border.color || defaultBorderColor,
                    "stroke-width": border.visible ? border.width : 0,
                    r: sizeValue / 2 + (border.visible && 0 !== sizeValue ? ~~(border.width / 2) || 0 : 0)
                }
            },
            _createPointStyles: function(pointOptions) {
                var that = this,
                    mainPointColor = pointOptions.color || that._options.mainSeriesColor,
                    containerColor = that._options.containerBackgroundColor,
                    normalStyle = that._parsePointStyle(pointOptions, mainPointColor, mainPointColor);
                normalStyle.visibility = pointOptions.visible ? "visible" : "hidden";
                return {
                    normal: normalStyle,
                    hover: that._parsePointStyle(pointOptions.hoverStyle, containerColor, mainPointColor, pointOptions.size),
                    selection: that._parsePointStyle(pointOptions.selectionStyle, containerColor, mainPointColor, pointOptions.size)
                }
            },
            _checkData: function(data, skippedFields, fieldsToCheck) {
                fieldsToCheck = fieldsToCheck || {
                    value: this.getValueFields()[0]
                };
                fieldsToCheck.argument = this.getArgumentField();
                return checkFields(data, fieldsToCheck, skippedFields || {}) && data.value === data.value
            },
            getValueRangeInitialValue: function() {
                return
            },
            _getRangeData: function() {
                return rangeCalculator.getRangeData(this)
            },
            _getPointDataSelector: function() {
                var _this = this;
                var valueField = this.getValueFields()[0];
                var argumentField = this.getArgumentField();
                var tagField = this.getTagField();
                var areErrorBarsVisible = this.areErrorBarsVisible();
                var lowValueField = void 0,
                    highValueField = void 0;
                if (areErrorBarsVisible) {
                    var errorBarOptions = this._options.valueErrorBar;
                    lowValueField = errorBarOptions.lowValueField || LOW_ERROR;
                    highValueField = errorBarOptions.highValueField || HIGH_ERROR
                }
                return function(data) {
                    var pointData = {
                        value: _this._processEmptyValue(data[valueField]),
                        argument: data[argumentField],
                        tag: data[tagField],
                        data: data
                    };
                    if (areErrorBarsVisible) {
                        pointData.lowError = data[lowValueField];
                        pointData.highError = data[highValueField]
                    }
                    return pointData
                }
            },
            _errorBarsEnabled: function() {
                return this.valueAxisType !== DISCRETE && this.valueAxisType !== LOGARITHMIC && this.valueType !== DATETIME
            },
            _drawPoint: function(options) {
                var point = options.point;
                if (point.isInVisibleArea()) {
                    point.clearVisibility();
                    point.draw(this._renderer, options.groups, options.hasAnimation, options.firstDrawing);
                    this._drawnPoints.push(point)
                } else {
                    point.setInvisibility()
                }
            },
            _animateComplete: function() {
                var that = this,
                    animationSettings = {
                        duration: that._defaultDuration
                    };
                that._labelsGroup && that._labelsGroup.animate({
                    opacity: 1
                }, animationSettings);
                that._errorBarGroup && that._errorBarGroup.animate({
                    opacity: that._options.valueErrorBar.opacity || 1
                }, animationSettings)
            },
            _animate: function() {
                var that = this,
                    lastPointIndex = that._drawnPoints.length - 1;
                _each(that._drawnPoints || [], function(i, p) {
                    p.animate(i === lastPointIndex ? function() {
                        that._animateComplete()
                    } : void 0, {
                        translateX: p.x,
                        translateY: p.y
                    })
                })
            },
            _defaultAggregator: "avg",
            _aggregators: {
                avg: function(_ref2, series) {
                    var _calculateAvgErrorBar;
                    var data = _ref2.data,
                        intervalStart = _ref2.intervalStart;
                    if (!data.length) {
                        return
                    }
                    var valueField = series.getValueFields()[0];
                    var aggregationResult = data.reduce(function(result, item) {
                        var value = item[valueField];
                        if (_isDefined(value)) {
                            result[0] += value;
                            result[1]++
                        } else {
                            if (null === value) {
                                result[2]++
                            }
                        }
                        return result
                    }, [0, 0, 0]);
                    return calculateAvgErrorBars((_calculateAvgErrorBar = {}, _defineProperty(_calculateAvgErrorBar, valueField, aggregationResult[2] === data.length ? null : aggregationResult[0] / aggregationResult[1]), _defineProperty(_calculateAvgErrorBar, series.getArgumentField(), intervalStart), _calculateAvgErrorBar), data, series)
                },
                sum: function(_ref3, series) {
                    var _calculateSumErrorBar;
                    var intervalStart = _ref3.intervalStart,
                        data = _ref3.data;
                    if (!data.length) {
                        return
                    }
                    var valueField = series.getValueFields()[0];
                    var aggregationResult = data.reduce(function(result, item) {
                        var value = item[valueField];
                        if (void 0 !== value) {
                            result[0] += value
                        }
                        if (null === value) {
                            result[1]++
                        } else {
                            if (void 0 === value) {
                                result[2]++
                            }
                        }
                        return result
                    }, [0, 0, 0]);
                    var value = aggregationResult[0];
                    if (aggregationResult[1] === data.length) {
                        value = null
                    }
                    if (aggregationResult[2] === data.length) {
                        return
                    }
                    return calculateSumErrorBars((_calculateSumErrorBar = {}, _defineProperty(_calculateSumErrorBar, valueField, value), _defineProperty(_calculateSumErrorBar, series.getArgumentField(), intervalStart), _calculateSumErrorBar), data, series)
                },
                count: function(_ref4, series) {
                    var _ref5;
                    var data = _ref4.data,
                        intervalStart = _ref4.intervalStart;
                    var valueField = series.getValueFields()[0];
                    return _ref5 = {}, _defineProperty(_ref5, series.getArgumentField(), intervalStart), _defineProperty(_ref5, valueField, data.filter(function(i) {
                        return void 0 !== i[valueField]
                    }).length), _ref5
                },
                min: getMinMaxAggregator(function(a, b) {
                    return a < b
                }),
                max: getMinMaxAggregator(function(a, b) {
                    return a > b
                })
            },
            _endUpdateData: function() {
                delete this._predefinedPointOptions
            },
            getArgumentField: function() {
                return this._options.argumentField || "arg"
            },
            getValueFields: function() {
                var lowValueField, highValueField, options = this._options,
                    errorBarsOptions = options.valueErrorBar,
                    valueFields = [options.valueField || "val"];
                if (errorBarsOptions) {
                    lowValueField = errorBarsOptions.lowValueField;
                    highValueField = errorBarsOptions.highValueField;
                    _isString(lowValueField) && valueFields.push(lowValueField);
                    _isString(highValueField) && valueFields.push(highValueField)
                }
                return valueFields
            },
            _calculateErrorBars: function(data) {
                if (!this.areErrorBarsVisible()) {
                    return
                }
                var value, valueArray, valueArrayLength, meanValue, processDataItem, that = this,
                    options = that._options,
                    errorBarsOptions = options.valueErrorBar,
                    errorBarType = _normalizeEnum(errorBarsOptions.type),
                    floatErrorValue = parseFloat(errorBarsOptions.value),
                    valueField = that.getValueFields()[0],
                    lowValueField = errorBarsOptions.lowValueField || LOW_ERROR,
                    highValueField = errorBarsOptions.highValueField || HIGH_ERROR,
                    addSubError = function(_i, item) {
                        value = item.value;
                        item.lowError = value - floatErrorValue;
                        item.highError = value + floatErrorValue
                    };
                switch (errorBarType) {
                    case FIXED:
                        processDataItem = addSubError;
                        break;
                    case PERCENT:
                        processDataItem = function(_, item) {
                            value = item.value;
                            var error = value * floatErrorValue / 100;
                            item.lowError = value - error;
                            item.highError = value + error
                        };
                        break;
                    case UNDEFINED:
                        processDataItem = function(_, item) {
                            item.lowError = item.data[lowValueField];
                            item.highError = item.data[highValueField]
                        };
                        break;
                    default:
                        valueArray = _map(data, function(item) {
                            return _isDefined(item.data[valueField]) ? item.data[valueField] : null
                        });
                        valueArrayLength = valueArray.length;
                        floatErrorValue = floatErrorValue || 1;
                        switch (errorBarType) {
                            case VARIANCE:
                                floatErrorValue = variance(valueArray, sum(valueArray) / valueArrayLength) * floatErrorValue;
                                processDataItem = addSubError;
                                break;
                            case STANDARD_DEVIATION:
                                meanValue = sum(valueArray) / valueArrayLength;
                                floatErrorValue = _sqrt(variance(valueArray, meanValue)) * floatErrorValue;
                                processDataItem = function(_, item) {
                                    item.lowError = meanValue - floatErrorValue;
                                    item.highError = meanValue + floatErrorValue
                                };
                                break;
                            case STANDARD_ERROR:
                                floatErrorValue = _sqrt(variance(valueArray, sum(valueArray) / valueArrayLength) / valueArrayLength) * floatErrorValue;
                                processDataItem = addSubError
                        }
                }
                processDataItem && _each(data, processDataItem)
            },
            _patchMarginOptions: function(options) {
                var pointOptions = this._getCreatingPointOptions(),
                    styles = pointOptions.styles,
                    maxSize = [styles.normal, styles.hover, styles.selection].reduce(function(max, style) {
                        return _max(max, 2 * style.r + style["stroke-width"])
                    }, 0);
                options.size = pointOptions.visible ? maxSize : 0;
                options.sizePointNormalState = pointOptions.visible ? 2 * styles.normal.r + styles.normal["stroke-width"] : 2;
                return options
            },
            usePointsToDefineAutoHiding: function() {
                return true
            }
        };
        exports.chart = _extend({}, baseScatterMethods, {
            drawTrackers: function() {
                var trackers, trackersGroup, that = this,
                    segments = that._segments || [],
                    rotated = that._options.rotated;
                if (!that.isVisible()) {
                    return
                }
                if (segments.length) {
                    trackers = that._trackers = that._trackers || [];
                    trackersGroup = that._trackersGroup = (that._trackersGroup || that._renderer.g().attr({
                        fill: "gray",
                        opacity: .001,
                        stroke: "gray",
                        "class": "dxc-trackers"
                    })).attr({
                        "clip-path": this._paneClipRectID || null
                    }).append(that._group);
                    _each(segments, function(i, segment) {
                        if (!trackers[i]) {
                            trackers[i] = that._drawTrackerElement(segment).data({
                                "chart-data-series": that
                            }).append(trackersGroup)
                        } else {
                            that._updateTrackerElement(segment, trackers[i])
                        }
                    })
                }
                that._trackersTranslator = that.groupPointsByCoords(rotated)
            },
            checkAxisVisibleAreaCoord: function(isArgument, coord) {
                var axis = isArgument ? this.getArgumentAxis() : this.getValueAxis();
                var visibleArea = axis.getVisibleArea();
                return _isDefined(coord) && visibleArea[0] <= coord && visibleArea[1] >= coord
            },
            checkSeriesViewportCoord: function(axis, coord) {
                return true
            },
            getSeriesPairCoord: function(coord, isArgument) {
                var oppositeCoord = null;
                var isOpposite = !isArgument && !this._options.rotated || isArgument && this._options.rotated;
                var coordName = !isOpposite ? "vx" : "vy";
                var oppositeCoordName = !isOpposite ? "vy" : "vx";
                var points = this.getVisiblePoints();
                for (var i = 0; i < points.length; i++) {
                    var p = points[i];
                    var tmpCoord = p[coordName] === coord ? p[oppositeCoordName] : void 0;
                    if (this.checkAxisVisibleAreaCoord(!isArgument, tmpCoord)) {
                        oppositeCoord = tmpCoord;
                        break
                    }
                }
                return oppositeCoord
            },
            getNearestPointsByCoord: function(coord, isArgument) {
                var that = this;
                var rotated = that.getOptions().rotated;
                var isOpposite = !isArgument && !rotated || isArgument && rotated;
                var coordName = isOpposite ? "vy" : "vx";
                var points = that.getVisiblePoints();
                var allPoints = that.getPoints();
                var nearestPoints = [];
                if (that.isVisible() && allPoints.length > 0) {
                    if (allPoints.length > 1) {
                        that.findNeighborPointsByCoord(coord, coordName, points.slice(0), allPoints, function(point, nextPoint) {
                            nearestPoints.push([point, nextPoint])
                        })
                    } else {
                        if (allPoints[0][coordName] === coord) {
                            nearestPoints.push([allPoints[0], allPoints[0]])
                        }
                    }
                }
                return nearestPoints
            },
            findNeighborPointsByCoord: function(coord, coordName, points, allPoints, pushNeighborPoints) {
                var searchPoints = allPoints;
                if (points.length > 0) {
                    points.splice(0, 0, allPoints[allPoints.indexOf(points[0]) - 1]);
                    points.splice(points.length, 0, allPoints[allPoints.indexOf(points[points.length - 1]) + 1]);
                    searchPoints = points
                }
                searchPoints.forEach(function(p, i) {
                    var np = searchPoints[i + 1];
                    if (p && np && (p[coordName] <= coord && np[coordName] >= coord || p[coordName] >= coord && np[coordName] <= coord)) {
                        pushNeighborPoints(p, np)
                    }
                })
            },
            getNeighborPoint: function(x, y) {
                var minDistance, pCoord = this._options.rotated ? y : x,
                    nCoord = pCoord,
                    cat = this._trackersTranslator,
                    point = null,
                    oppositeCoord = this._options.rotated ? x : y,
                    oppositeCoordName = this._options.rotated ? "vx" : "vy";
                if (this.isVisible() && cat) {
                    point = cat[pCoord];
                    do {
                        point = cat[nCoord] || cat[pCoord];
                        pCoord--;
                        nCoord++
                    } while ((pCoord >= 0 || nCoord < cat.length) && !point);
                    if (Array.isArray(point)) {
                        minDistance = _abs(point[0][oppositeCoordName] - oppositeCoord);
                        _each(point, function(i, p) {
                            var distance = _abs(p[oppositeCoordName] - oppositeCoord);
                            if (minDistance >= distance) {
                                minDistance = distance;
                                point = p
                            }
                        })
                    }
                }
                return point
            },
            _applyVisibleArea: function() {
                var that = this,
                    rotated = that._options.rotated,
                    visibleX = (rotated ? that.getValueAxis() : that.getArgumentAxis()).getVisibleArea(),
                    visibleY = (rotated ? that.getArgumentAxis() : that.getValueAxis()).getVisibleArea();
                that._visibleArea = {
                    minX: visibleX[0],
                    maxX: visibleX[1],
                    minY: visibleY[0],
                    maxY: visibleY[1]
                }
            },
            getPointCenterByArg: function(arg) {
                var point = this.getPointsByArg(arg)[0];
                return point ? point.getCenterCoord() : void 0
            }
        });
        exports.polar = _extend({}, baseScatterMethods, {
            drawTrackers: function() {
                exports.chart.drawTrackers.call(this);
                var index, cat = this._trackersTranslator;
                if (!this.isVisible()) {
                    return
                }
                _each(cat, function(i, category) {
                    if (category) {
                        index = i;
                        return false
                    }
                });
                cat[index + 360] = cat[index]
            },
            getNeighborPoint: function(x, y) {
                var pos = vizUtils.convertXYToPolar(this.getValueAxis().getCenter(), x, y);
                return exports.chart.getNeighborPoint.call(this, pos.phi, pos.r)
            },
            _applyVisibleArea: function() {
                var that = this,
                    canvas = that.getValueAxis().getCanvas();
                that._visibleArea = {
                    minX: canvas.left,
                    maxX: canvas.width - canvas.right,
                    minY: canvas.top,
                    maxY: canvas.height - canvas.bottom
                }
            }
        })
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/viz/core/tooltip.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 11);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _inflector = __webpack_require__( /*! ../../core/utils/inflector */ 32);
        var _inflector2 = _interopRequireDefault(_inflector);
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _renderer3 = __webpack_require__( /*! ./renderers/renderer */ 175);
        var _renderer4 = _interopRequireDefault(_renderer3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _utils = __webpack_require__( /*! ./utils */ 10);
        var _utils2 = _interopRequireDefault(_utils);
        var _format_helper = __webpack_require__( /*! ../../format_helper */ 64);
        var _plaque = __webpack_require__( /*! ./plaque */ 401);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var mathCeil = Math.ceil;
        var mathMax = Math.max;
        var mathMin = Math.min;
        var window = _window2.default.getWindow();

        function hideElement($element) {
            $element.css({
                left: "-9999px"
            }).detach()
        }

        function getSpecialFormatOptions(options, specialFormat) {
            var result = options;
            switch (specialFormat) {
                case "argument":
                    result = {
                        format: options.argumentFormat
                    };
                    break;
                case "percent":
                    result = {
                        format: {
                            type: "percent",
                            precision: options.format && options.format.percentPrecision
                        }
                    }
            }
            return result
        }

        function Tooltip(params) {
            var renderer, root, that = this;
            that._eventTrigger = params.eventTrigger;
            that._widgetRoot = params.widgetRoot;
            that._wrapper = (0, _renderer2.default)("<div>").css({
                position: "absolute",
                overflow: "hidden",
                pointerEvents: "none"
            }).addClass(params.cssClass);
            that._renderer = renderer = new _renderer4.default.Renderer({
                pathModified: params.pathModified,
                container: that._wrapper[0]
            });
            root = renderer.root;
            root.attr({
                "pointer-events": "none"
            });
            that._text = renderer.text(void 0, 0, 0);
            that._textGroupHtml = (0, _renderer2.default)("<div>").css({
                position: "absolute",
                padding: 0,
                margin: 0,
                border: "0px solid transparent"
            }).appendTo(that._wrapper);
            that._textHtml = (0, _renderer2.default)("<div>").css({
                position: "relative",
                display: "inline-block",
                padding: 0,
                margin: 0,
                border: "0px solid transparent"
            }).appendTo(that._textGroupHtml)
        }
        Tooltip.prototype = {
            constructor: Tooltip,
            dispose: function() {
                this._wrapper.remove();
                this._renderer.dispose();
                this._options = this._widgetRoot = null
            },
            _getContainer: function() {
                var options = this._options,
                    container = (0, _renderer2.default)(this._widgetRoot).closest(options.container);
                if (0 === container.length) {
                    container = (0, _renderer2.default)(options.container)
                }
                return (container.length ? container : (0, _renderer2.default)("body")).get(0)
            },
            setOptions: function(options) {
                var _this = this;
                options = options || {};
                var that = this;
                that._options = options;
                that._textFontStyles = _utils2.default.patchFontOptions(options.font);
                that._textFontStyles.color = options.font.color;
                that._wrapper.css({
                    zIndex: options.zIndex
                });
                that._customizeTooltip = options.customizeTooltip;
                var textGroupHtml = that._textGroupHtml;
                var textHtml = that._textHtml;
                if (this.plaque) {
                    this.plaque.clear()
                }
                this.plaque = new _plaque.Plaque({
                    opacity: that._options.opacity,
                    color: that._options.color,
                    border: that._options.border,
                    paddingLeftRight: that._options.paddingLeftRight,
                    paddingTopBottom: that._options.paddingTopBottom,
                    arrowLength: that._options.arrowLength,
                    arrowWidth: 20,
                    shadow: that._options.shadow,
                    cornerRadius: that._options.cornerRadius
                }, that, that._renderer.root, function(tooltip, group) {
                    var state = tooltip._state;
                    if (state.html) {
                        if (!state.isRendered) {
                            that._text.attr({
                                text: ""
                            });
                            textGroupHtml.css({
                                color: state.textColor,
                                width: null
                            });
                            textHtml.html(state.html);
                            state.isRendered = true
                        }
                    } else {
                        that._text.css({
                            fill: state.textColor
                        }).attr({
                            text: state.text,
                            "class": options.cssClass
                        }).append(group.attr({
                            align: options.textAlignment
                        }))
                    }
                    _this.plaque.customizeCloud({
                        fill: state.color,
                        stroke: state.borderColor
                    })
                }, true, function(tooltip, g) {
                    var state = tooltip._state;
                    if (state.html) {
                        var bBox = void 0;
                        var getComputedStyle = window.getComputedStyle;
                        if (getComputedStyle) {
                            bBox = getComputedStyle(textHtml.get(0));
                            bBox = {
                                x: 0,
                                y: 0,
                                width: mathCeil(parseFloat(bBox.width)),
                                height: mathCeil(parseFloat(bBox.height))
                            }
                        } else {
                            bBox = textHtml.get(0).getBoundingClientRect();
                            bBox = {
                                x: 0,
                                y: 0,
                                width: mathCeil(bBox.width ? bBox.width : bBox.right - bBox.left),
                                height: mathCeil(bBox.height ? bBox.height : bBox.bottom - bBox.top)
                            }
                        }
                        return bBox
                    }
                    return g.getBBox()
                }, function(tooltip, g, x, y) {
                    var state = tooltip._state;
                    if (state.html) {
                        that._textGroupHtml.css({
                            left: x,
                            top: y
                        })
                    } else {
                        g.move(x, y)
                    }
                });
                return that
            },
            setRendererOptions: function(options) {
                this._renderer.setOptions(options);
                this._textGroupHtml.css({
                    direction: options.rtl ? "rtl" : "ltr"
                });
                return this
            },
            render: function() {
                var that = this;
                hideElement(that._wrapper);
                var normalizedCSS = {};
                for (var name in that._textFontStyles) {
                    normalizedCSS[_inflector2.default.camelize(name)] = that._textFontStyles[name]
                }
                that._textGroupHtml.css(normalizedCSS);
                that._text.css(that._textFontStyles);
                that._eventData = null;
                return that
            },
            update: function(options) {
                return this.setOptions(options).render()
            },
            _prepare: function(formatObject, state) {
                var customizeTooltip = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : this._customizeTooltip;
                var options = this._options;
                var customize = {};
                if (_type2.default.isFunction(customizeTooltip)) {
                    customize = customizeTooltip.call(formatObject, formatObject);
                    customize = _type2.default.isPlainObject(customize) ? customize : {};
                    if ("text" in customize) {
                        state.text = _type2.default.isDefined(customize.text) ? String(customize.text) : ""
                    }
                    if ("html" in customize) {
                        state.html = _type2.default.isDefined(customize.html) ? String(customize.html) : ""
                    }
                }
                if (!("text" in state) && !("html" in state)) {
                    state.text = formatObject.valueText || formatObject.description || ""
                }
                state.color = customize.color || options.color;
                state.borderColor = customize.borderColor || (options.border || {}).color;
                state.textColor = customize.fontColor || (options.font || {}).color;
                return !!state.text || !!state.html
            },
            show: function(formatObject, params, eventData, customizeTooltip) {
                var that = this,
                    state = {};
                if (!that._prepare(formatObject, state, customizeTooltip)) {
                    return false
                }
                that._state = state;
                that._wrapper.appendTo(that._getContainer());
                that._textHtml.html("");
                this.plaque.clear().draw((0, _extend.extend)({}, that._options, {
                    canvas: that._getCanvas()
                }, state, {
                    x: params.x,
                    y: params.y,
                    offset: params.offset
                }));
                that.moveWrapper();
                that._eventData && that._eventTrigger("tooltipHidden", that._eventData);
                that._eventData = eventData;
                that._eventTrigger("tooltipShown", that._eventData);
                return true
            },
            hide: function() {
                var that = this;
                hideElement(that._wrapper);
                that._eventData && that._eventTrigger("tooltipHidden", that._eventData);
                that._eventData = null
            },
            move: function(x, y, offset) {
                this.plaque.draw({
                    x: x,
                    y: y,
                    offset: offset,
                    canvas: this._getCanvas()
                });
                this.moveWrapper()
            },
            moveWrapper: function() {
                var that = this;
                var plaqueBBox = this.plaque.getBBox();
                that._renderer.resize(plaqueBBox.width, plaqueBBox.height);
                var offset = that._wrapper.css({
                    left: 0,
                    top: 0
                }).offset();
                var left = plaqueBBox.x;
                var top = plaqueBBox.y;
                that._wrapper.css({
                    left: left - offset.left,
                    top: top - offset.top
                });
                this.plaque.moveRoot(-left, -top);
                if (this._state.html) {
                    that._textHtml.css({
                        left: -left,
                        top: -top
                    });
                    that._textGroupHtml.css({
                        width: plaqueBBox.width
                    })
                }
            },
            formatValue: function(value, _specialFormat) {
                var options = _specialFormat ? getSpecialFormatOptions(this._options, _specialFormat) : this._options;
                return (0, _format_helper.format)(value, options.format)
            },
            getLocation: function() {
                return _utils2.default.normalizeEnum(this._options.location)
            },
            isEnabled: function() {
                return !!this._options.enabled
            },
            isShared: function() {
                return !!this._options.shared
            },
            _getCanvas: function() {
                var container = this._getContainer();
                var containerBox = container.getBoundingClientRect();
                var html = _dom_adapter2.default.getDocumentElement();
                var document = _dom_adapter2.default.getDocument();
                var left = window.pageXOffset || html.scrollLeft || 0;
                var top = window.pageYOffset || html.scrollTop || 0;
                var box = {
                    left: left,
                    top: top,
                    width: html.clientWidth + left || 0,
                    height: mathMax(document.body.scrollHeight, html.scrollHeight, document.body.offsetHeight, html.offsetHeight, document.body.clientHeight, html.clientHeight) || 0,
                    right: 0,
                    bottom: 0
                };
                if (container !== _dom_adapter2.default.getBody()) {
                    left = mathMax(box.left, box.left + containerBox.left);
                    top = mathMax(box.top, box.top + containerBox.top);
                    box.width = mathMin(containerBox.width, box.width) + left + box.left;
                    box.height = mathMin(containerBox.height, box.height) + top + box.top;
                    box.left = left;
                    box.top = top
                }
                return box
            }
        };
        exports.Tooltip = Tooltip;
        exports.plugin = {
            name: "tooltip",
            init: function() {
                this._initTooltip()
            },
            dispose: function() {
                this._disposeTooltip()
            },
            members: {
                _initTooltip: function() {
                    this._tooltip = new exports.Tooltip({
                        cssClass: this._rootClassPrefix + "-tooltip",
                        eventTrigger: this._eventTrigger,
                        pathModified: this.option("pathModified"),
                        widgetRoot: this.element()
                    })
                },
                _disposeTooltip: function() {
                    this._tooltip.dispose();
                    this._tooltip = null
                },
                _setTooltipRendererOptions: function() {
                    this._tooltip.setRendererOptions(this._getRendererOptions())
                },
                _setTooltipOptions: function() {
                    this._tooltip.update(this._getOption("tooltip"))
                }
            },
            extenders: {
                _stopCurrentHandling: function() {
                    this._tooltip && this._tooltip.hide()
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                proto._eventsMap.onTooltipShown = {
                    name: "tooltipShown"
                };
                proto._eventsMap.onTooltipHidden = {
                    name: "tooltipHidden"
                };
                constructor.addChange({
                    code: "TOOLTIP_RENDERER",
                    handler: function() {
                        this._setTooltipRendererOptions()
                    },
                    isThemeDependent: true,
                    isOptionChange: true
                });
                constructor.addChange({
                    code: "TOOLTIP",
                    handler: function() {
                        this._setTooltipOptions()
                    },
                    isThemeDependent: true,
                    isOptionChange: true,
                    option: "tooltip"
                })
            },
            fontFields: ["tooltip.font"]
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/viz/translators/range.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _Range, typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            _isDefined = typeUtils.isDefined,
            _isDate = typeUtils.isDate,
            _isFunction = typeUtils.isFunction,
            unique = __webpack_require__( /*! ../core/utils */ 10).unique,
            minSelector = "min",
            maxSelector = "max",
            minVisibleSelector = "minVisible",
            maxVisibleSelector = "maxVisible",
            baseSelector = "base",
            axisTypeSelector = "axisType";

        function otherLessThan(thisValue, otherValue) {
            return otherValue < thisValue
        }

        function otherGreaterThan(thisValue, otherValue) {
            return otherValue > thisValue
        }

        function compareAndReplace(thisValue, otherValue, setValue, compare) {
            var otherValueDefined = _isDefined(otherValue);
            if (_isDefined(thisValue)) {
                if (otherValueDefined && compare(thisValue, otherValue)) {
                    setValue(otherValue)
                }
            } else {
                if (otherValueDefined) {
                    setValue(otherValue)
                }
            }
        }
        _Range = exports.Range = function(range) {
            range && extend(this, range)
        };
        _Range.prototype = {
            constructor: _Range,
            addRange: function(otherRange) {
                var that = this,
                    categories = that.categories,
                    otherCategories = otherRange.categories;
                var compareAndReplaceByField = function(field, compare) {
                    compareAndReplace(that[field], otherRange[field], function(value) {
                        that[field] = value
                    }, compare)
                };
                var controlValuesByVisibleBounds = function(valueField, visibleValueField, compare) {
                    compareAndReplace(that[valueField], that[visibleValueField], function(value) {
                        _isDefined(that[valueField]) && (that[valueField] = value)
                    }, compare)
                };
                var checkField = function(field) {
                    that[field] = that[field] || otherRange[field]
                };
                checkField("invert");
                checkField(axisTypeSelector);
                checkField("dataType");
                checkField("isSpacedMargin"), checkField("checkMinDataVisibility");
                checkField("checkMaxDataVisibility");
                if ("logarithmic" === that[axisTypeSelector]) {
                    checkField(baseSelector)
                } else {
                    that[baseSelector] = void 0
                }
                compareAndReplaceByField(minSelector, otherLessThan);
                compareAndReplaceByField(maxSelector, otherGreaterThan);
                if ("discrete" === that[axisTypeSelector]) {
                    checkField(minVisibleSelector);
                    checkField(maxVisibleSelector)
                } else {
                    compareAndReplaceByField(minVisibleSelector, otherLessThan);
                    compareAndReplaceByField(maxVisibleSelector, otherGreaterThan)
                }
                compareAndReplaceByField("interval", otherLessThan);
                controlValuesByVisibleBounds(minSelector, minVisibleSelector, otherLessThan);
                controlValuesByVisibleBounds(minSelector, maxVisibleSelector, otherLessThan);
                controlValuesByVisibleBounds(maxSelector, maxVisibleSelector, otherGreaterThan);
                controlValuesByVisibleBounds(maxSelector, minVisibleSelector, otherGreaterThan);
                if (void 0 === categories) {
                    that.categories = otherCategories
                } else {
                    that.categories = otherCategories ? unique(categories.concat(otherCategories)) : categories
                }
                return that
            },
            isEmpty: function() {
                return (!_isDefined(this[minSelector]) || !_isDefined(this[maxSelector])) && (!this.categories || 0 === this.categories.length)
            },
            correctValueZeroLevel: function() {
                var that = this;
                if ("logarithmic" === that[axisTypeSelector] || _isDate(that[maxSelector]) || _isDate(that[minSelector])) {
                    return that
                }

                function setZeroLevel(min, max) {
                    that[min] < 0 && that[max] < 0 && (that[max] = 0);
                    that[min] > 0 && that[max] > 0 && (that[min] = 0)
                }
                setZeroLevel(minSelector, maxSelector);
                setZeroLevel(minVisibleSelector, maxVisibleSelector);
                return that
            },
            sortCategories: function(sort) {
                if (false === sort || !this.categories) {
                    return
                }
                if (Array.isArray(sort)) {
                    this.categories = sort.slice(0).concat(this.categories.filter(function(item) {
                        return item && sort.indexOf(item.valueOf()) === -1
                    }))
                } else {
                    var notAFunction = !_isFunction(sort);
                    if (notAFunction && "string" !== this.dataType) {
                        sort = function(a, b) {
                            return a.valueOf() - b.valueOf()
                        }
                    } else {
                        if (notAFunction) {
                            sort = false
                        }
                    }
                    sort && this.categories.sort(sort)
                }
            }
        }
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/empty_template.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 73);
        var EmptyTemplate = TemplateBase.inherit({
            _renderCore: function() {
                return $()
            }
        });
        module.exports = EmptyTemplate
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/odata/utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 58),
            _Guid = __webpack_require__( /*! ../../core/guid */ 43),
            isDefined = typeUtils.isDefined,
            isPlainObject = typeUtils.isPlainObject,
            grep = __webpack_require__( /*! ../../core/utils/common */ 4).grep,
            Deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6).Deferred,
            errors = __webpack_require__( /*! ../errors */ 36).errors,
            dataUtils = __webpack_require__( /*! ../utils */ 40);
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
        var makeArray = function(value) {
            return "string" === typeUtils.type(value) ? value.split() : value
        };
        var hasDot = function(x) {
            return /\./.test(x)
        };
        var pad = function(text, length, right) {
            text = String(text);
            while (text.length < length) {
                text = right ? text + "0" : "0" + text
            }
            return text
        };

        function formatISO8601(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            var padLeft2 = function(text) {
                return pad(text, 2)
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(padLeft2(date.getMonth() + 1));
            bag.push("-");
            bag.push(padLeft2(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(padLeft2(date.getHours()));
                bag.push(":");
                bag.push(padLeft2(date.getMinutes()));
                bag.push(":");
                bag.push(padLeft2(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(pad(date.getMilliseconds(), 3))
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        }

        function parseISO8601(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3),
                chunks = isoString.replace("Z", "").split("T"),
                date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]),
                time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                var fractional = (time[4] || "").slice(0, 3);
                fractional = pad(fractional, 3, true);
                result.setMilliseconds(Number(fractional))
            }
            return result
        }

        function isAbsoluteUrl(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        }

        function toAbsoluteUrl(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");

            function stripParams(url) {
                var index = url.indexOf("?");
                if (index > -1) {
                    return url.substr(0, index)
                }
                return url
            }
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        }
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request, options) {
            request = extend({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            options = options || {};
            var beforeSend = options.beforeSend;
            if (beforeSend) {
                beforeSend(request)
            }
            var method = (request.method || "get").toLowerCase(),
                isGet = "get" === method,
                useJsonp = isGet && options.jsonp,
                params = extend({}, request.params),
                ajaxData = isGet ? params : formatPayload(request.payload),
                qs = !isGet && param(params),
                url = request.url,
                contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: request.async,
                timeout: request.timeout,
                headers: request.headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: options.withCredentials
                }
            };

            function formatPayload(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw errors.Error("E4002")
                    }
                })
            }
        };
        var sendRequest = function sendRequest(protocolVersion, request, options) {
            var d = new Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            ajax.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var extra, transformOptions = {
                        deserializeDates: options.deserializeDates,
                        fieldTypes: options.fieldTypes
                    },
                    tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions),
                    error = tuple.error,
                    data = tuple.data,
                    nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== dataUtils.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (options.countOnly) {
                        if (isFinite(tuple.count)) {
                            d.resolve(tuple.count)
                        } else {
                            d.reject(new errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !options.isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                d.resolve(data.concat(nextData))
                            })
                        } else {
                            if (isFinite(tuple.count)) {
                                extra = {
                                    totalCount: tuple.count
                                }
                            }
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        var formatDotNetError = function(errorObj) {
            var message, currentError = errorObj;
            if ("message" in errorObj) {
                if (errorObj.message.value) {
                    message = errorObj.message.value
                } else {
                    message = errorObj.message
                }
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus, ajaxOptions) {
            if ("nocontent" === textStatus) {
                return null
            }
            var message = "Unknown error",
                response = obj,
                httpStatus = 200,
                errorData = {
                    requestOptions: ajaxOptions
                };
            if ("success" !== textStatus) {
                httpStatus = obj.status;
                message = dataUtils.errorMessageFromXhr(obj, textStatus);
                try {
                    response = JSON.parse(obj.responseText)
                } catch (x) {}
            }
            var errorObj = response && (response.then && response || response.error || response["odata.error"] || response["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                errorData.errorDetails = errorObj;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                var customCode = Number(errorObj.code);
                if (isFinite(customCode) && customCode >= 400) {
                    httpStatus = customCode
                }
            }
            if (httpStatus >= 400 || 0 === httpStatus) {
                errorData.httpStatus = httpStatus;
                return extend(Error(message), errorData)
            }
            return null
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
            var value, error = errorFromResponse(obj, textStatus, ajaxOptions);
            if (error) {
                return {
                    error: error
                }
            }
            if (!isPlainObject(obj)) {
                return {
                    data: obj
                }
            }
            if ("d" in obj && (Array.isArray(obj.d) || typeUtils.isObject(obj.d))) {
                value = interpretVerboseJsonFormat(obj, textStatus)
            } else {
                value = interpretLightJsonFormat(obj, textStatus)
            }
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(obj) {
            var data = obj.d;
            if (!isDefined(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            if (isDefined(data.results)) {
                data = data.results
            }
            return {
                data: data,
                nextUrl: obj.d.__next,
                count: parseInt(obj.d.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var data = obj;
            if (isDefined(data.value)) {
                data = data.value
            }
            return {
                data: data,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = Class.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        var transformTypes = function transformTypes(obj, options) {
            options = options || {};
            each(obj, function(key, value) {
                if (null !== value && "object" === ("undefined" === typeof value ? "undefined" : _typeof(value))) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _Guid(value)
                        }
                        if (false !== options.deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'" + formatISO8601(date, true, true) + "'"
        };
        var serializeString = function(value) {
            return "'" + value.replace(/'/g, "''") + "'"
        };
        var serializePropName = function(propName) {
            if (propName instanceof EdmLiteral) {
                return propName.valueOf()
            }
            return propName.replace(/\./g, "/")
        };
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _Guid) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[" + value.map(function(item) {
                    return serializeValueV4(item)
                }).join(",") + "]"
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _Guid) {
                return "guid'" + value + "'"
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw errors.Error("E4002")
            }
        };
        var serializeKey = function(key, protocolVersion) {
            if (isPlainObject(key)) {
                var parts = [];
                each(key, function(k, v) {
                    parts.push(serializePropName(k) + "=" + serializeValue(v, protocolVersion))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        var keyConverters = {
            String: function(value) {
                return value + ""
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "L")
            },
            Guid: function(value) {
                if (value instanceof _Guid) {
                    return value
                }
                return new _Guid(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "m")
            }
        };
        var convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw errors.Error("E4014", type)
            }
            return converter(value)
        };
        var generateSelect = function(oDataVersion, select) {
            if (!select) {
                return
            }
            if (oDataVersion < 4) {
                return serializePropName(select.join())
            }
            return grep(select, hasDot, true).join()
        };
        var generateExpand = function(oDataVersion, expand, select) {
            var generatorV2 = function() {
                var hash = {};
                if (expand) {
                    iteratorUtils.each(makeArray(expand), function() {
                        hash[serializePropName(this)] = 1
                    })
                }
                if (select) {
                    iteratorUtils.each(makeArray(select), function() {
                        var path = this.split(".");
                        if (path.length < 2) {
                            return
                        }
                        path.pop();
                        hash[serializePropName(path.join("."))] = 1
                    })
                }
                return iteratorUtils.map(hash, function(k, v) {
                    return v
                }).join()
            };
            var generatorV4 = function() {
                var format = function(hash) {
                    var formatCore = function formatCore(hash) {
                        var result = "",
                            selectValue = [],
                            expandValue = [];
                        iteratorUtils.each(hash, function(key, value) {
                            if (Array.isArray(value)) {
                                [].push.apply(selectValue, value)
                            }
                            if (isPlainObject(value)) {
                                expandValue.push(key + formatCore(value))
                            }
                        });
                        if (selectValue.length || expandValue.length) {
                            result += "(";
                            if (selectValue.length) {
                                result += "$select=" + iteratorUtils.map(selectValue, serializePropName).join()
                            }
                            if (expandValue.length) {
                                if (selectValue.length) {
                                    result += ";"
                                }
                                result += "$expand=" + iteratorUtils.map(expandValue, serializePropName).join()
                            }
                            result += ")"
                        }
                        return result
                    };
                    var result = [];
                    iteratorUtils.each(hash, function(key, value) {
                        result.push(key + formatCore(value))
                    });
                    return result.join()
                };
                var parseTree = function(exprs, root, stepper) {
                    var parseCore = function parseCore(exprParts, root, stepper) {
                        var result = stepper(root, exprParts.shift(), exprParts);
                        if (false === result) {
                            return
                        }
                        parseCore(exprParts, result, stepper)
                    };
                    iteratorUtils.each(exprs, function(_, x) {
                        parseCore(x.split("."), root, stepper)
                    })
                };
                var hash = {};
                if (expand || select) {
                    if (expand) {
                        parseTree(makeArray(expand), hash, function(node, key, path) {
                            node[key] = node[key] || {};
                            if (!path.length) {
                                return false
                            }
                            return node[key]
                        })
                    }
                    if (select) {
                        parseTree(grep(makeArray(select), hasDot), hash, function(node, key, path) {
                            if (!path.length) {
                                node[key] = node[key] || [];
                                node[key].push(key);
                                return false
                            }
                            return node[key] = node[key] || {}
                        })
                    }
                    return format(hash)
                }
            };
            if (oDataVersion < 4) {
                return generatorV2()
            }
            return generatorV4()
        };
        exports.sendRequest = sendRequest;
        exports.serializePropName = serializePropName;
        exports.serializeValue = serializeValue;
        exports.serializeKey = serializeKey;
        exports.keyConverters = keyConverters;
        exports.convertPrimitiveValue = convertPrimitiveValue;
        exports.generateExpand = generateExpand;
        exports.generateSelect = generateSelect;
        exports.EdmLiteral = EdmLiteral;
        exports.OData__internals = {
            interpretJsonFormat: interpretJsonFormat
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/action.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2),
            config = __webpack_require__( /*! ./config */ 31),
            window = __webpack_require__( /*! ./utils/window */ 7).getWindow(),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 15),
            errors = __webpack_require__( /*! ./errors */ 21);
        var Action = Class.inherit({
            ctor: function(action, config) {
                config = config || {};
                this._action = action;
                this._context = config.context || window;
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            },
            execute: function() {
                var e = {
                    action: this._action,
                    args: Array.prototype.slice.call(arguments),
                    context: this._context,
                    component: this._component,
                    validatingTargetName: this._validatingTargetName,
                    cancel: false,
                    handled: false
                };
                var beforeExecute = this._beforeExecute,
                    afterExecute = this._afterExecute;
                var argsBag = e.args[0] || {};
                if ("jQueryEvent" in argsBag && !argsBag.event) {
                    throw "The jQueryEvent field is deprecated. Please, use the `event` field instead"
                }
                if (!("jQueryEvent" in argsBag) && argsBag.event && config().useJQuery) {
                    Object.defineProperty(argsBag, "jQueryEvent", {
                        get: function() {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            return argsBag.event
                        },
                        set: function(value) {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            argsBag.event = value
                        }
                    })
                }
                if (!this._validateAction(e)) {
                    return
                }
                beforeExecute && beforeExecute.call(this._context, e);
                if (e.cancel) {
                    return
                }
                var result = this._executeAction(e);
                if (argsBag.cancel) {
                    return
                }
                afterExecute && afterExecute.call(this._context, e);
                return result
            },
            _validateAction: function(e) {
                var excludeValidators = this._excludeValidators,
                    executors = Action.executors;
                for (var name in executors) {
                    if (!excludeValidators[name]) {
                        var executor = executors[name];
                        if (executor.validate) {
                            executor.validate(e)
                        }
                        if (e.cancel) {
                            return false
                        }
                    }
                }
                return true
            },
            _executeAction: function(e) {
                var result, executors = Action.executors;
                for (var name in executors) {
                    var executor = executors[name];
                    if (executor.execute) {
                        executor.execute(e)
                    }
                    if (e.handled) {
                        result = e.result;
                        break
                    }
                }
                return result
            }
        });
        Action.executors = {};
        Action.registerExecutor = function(name, executor) {
            if (typeUtils.isPlainObject(name)) {
                each(name, Action.registerExecutor);
                return
            }
            Action.executors[name] = executor
        };
        Action.unregisterExecutor = function() {
            var args = [].slice.call(arguments);
            each(args, function() {
                delete Action.executors[this]
            })
        };
        Action.registerExecutor({
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if (typeUtils.isFunction(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0],
                    element = args[e.validatingTargetName] || args.element;
                if (element && condition($(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *")
                })
            }
        });
        module.exports = Action
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/animation/frame.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.hasWindow() ? windowUtils.getWindow() : {},
            callOnce = __webpack_require__( /*! ../core/utils/call_once */ 63);
        var FRAME_ANIMATION_STEP_TIME = 1e3 / 60,
            request = function(callback) {
                return setTimeout(callback, FRAME_ANIMATION_STEP_TIME)
            },
            cancel = function(requestID) {
                clearTimeout(requestID)
            };
        var setAnimationFrameMethods = callOnce(function() {
            var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame,
                nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
            if (nativeRequest && nativeCancel) {
                request = nativeRequest;
                cancel = nativeCancel
            }
            if (nativeRequest && !nativeCancel) {
                var canceledRequests = {};
                request = function(callback) {
                    var requestId = nativeRequest.call(window, function() {
                        try {
                            if (requestId in canceledRequests) {
                                return
                            }
                            callback.apply(this, arguments)
                        } finally {
                            delete canceledRequests[requestId]
                        }
                    });
                    return requestId
                };
                cancel = function(requestId) {
                    canceledRequests[requestId] = true
                }
            }
        });
        exports.requestAnimationFrame = function() {
            setAnimationFrameMethods();
            return request.apply(window, arguments)
        };
        exports.cancelAnimationFrame = function() {
            setAnimationFrameMethods();
            cancel.apply(window, arguments)
        }
    }, , , , ,
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/viz/components/consts.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = {
            events: {
                mouseover: "mouseover",
                mouseout: "mouseout",
                mousemove: "mousemove",
                touchstart: "touchstart",
                touchmove: "touchmove",
                touchend: "touchend",
                mousedown: "mousedown",
                mouseup: "mouseup",
                click: "click",
                selectSeries: "selectseries",
                deselectSeries: "deselectseries",
                selectPoint: "selectpoint",
                deselectPoint: "deselectpoint",
                showPointTooltip: "showpointtooltip",
                hidePointTooltip: "hidepointtooltip"
            },
            states: {
                hover: "hover",
                normal: "normal",
                selection: "selection",
                normalMark: 0,
                hoverMark: 1,
                selectedMark: 2,
                applyHover: "applyHover",
                applySelected: "applySelected",
                resetItem: "resetItem"
            },
            radialLabelIndent: 30,
            pieLabelSpacing: 10,
            pieSeriesSpacing: 4
        }
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/viz/series/points/symbol_point.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../../../core/utils/iterator */ 3).each,
            noop = __webpack_require__( /*! ../../../core/utils/common */ 4).noop,
            windowUtils = __webpack_require__( /*! ../../../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            labelModule = __webpack_require__( /*! ./label */ 244),
            _extend = extend,
            _isDefined = __webpack_require__( /*! ../../../core/utils/type */ 1).isDefined,
            _normalizeEnum = __webpack_require__( /*! ../../core/utils */ 10).normalizeEnum,
            _math = Math,
            _round = _math.round,
            _floor = _math.floor,
            _ceil = _math.ceil,
            DEFAULT_IMAGE_WIDTH = 20,
            DEFAULT_IMAGE_HEIGHT = 20,
            LABEL_OFFSET = 10,
            CANVAS_POSITION_DEFAULT = "canvas_position_default";

        function getSquareMarkerCoords(radius) {
            return [-radius, -radius, radius, -radius, radius, radius, -radius, radius, -radius, -radius]
        }

        function getPolygonMarkerCoords(radius) {
            var r = _ceil(radius);
            return [-r, 0, 0, -r, r, 0, 0, r, -r, 0]
        }

        function getCrossMarkerCoords(radius) {
            var r = _ceil(radius),
                floorHalfRadius = _floor(r / 2),
                ceilHalfRadius = _ceil(r / 2);
            return [-r, -floorHalfRadius, -floorHalfRadius, -r, 0, -ceilHalfRadius, floorHalfRadius, -r, r, -floorHalfRadius, ceilHalfRadius, 0, r, floorHalfRadius, floorHalfRadius, r, 0, ceilHalfRadius, -floorHalfRadius, r, -r, floorHalfRadius, -ceilHalfRadius, 0]
        }

        function getTriangleDownMarkerCoords(radius) {
            return [-radius, -radius, radius, -radius, 0, radius, -radius, -radius]
        }

        function getTriangleUpMarkerCoords(radius) {
            return [-radius, radius, radius, radius, 0, -radius, -radius, radius]
        }
        module.exports = {
            deleteLabel: function() {
                this._label.dispose();
                this._label = null
            },
            _hasGraphic: function() {
                return this.graphic
            },
            clearVisibility: function() {
                var that = this,
                    graphic = that.graphic;
                if (graphic && graphic.attr("visibility")) {
                    graphic.attr({
                        visibility: null
                    })
                }
            },
            isVisible: function() {
                return this.inVisibleArea && this.series.isVisible()
            },
            setInvisibility: function() {
                var that = this,
                    graphic = that.graphic;
                if (graphic && "hidden" !== graphic.attr("visibility")) {
                    graphic.attr({
                        visibility: "hidden"
                    })
                }
                that._errorBar && that._errorBar.attr({
                    visibility: "hidden"
                });
                that._label.draw(false)
            },
            clearMarker: function() {
                var graphic = this.graphic;
                graphic && graphic.attr(this._emptySettings)
            },
            _createLabel: function() {
                this._label = new labelModule.Label({
                    renderer: this.series._renderer,
                    labelsGroup: this.series._labelsGroup,
                    point: this
                })
            },
            _updateLabelData: function() {
                this._label.setData(this._getLabelFormatObject())
            },
            _updateLabelOptions: function() {
                !this._label && this._createLabel();
                this._label.setOptions(this._options.label)
            },
            _checkImage: function(image) {
                return _isDefined(image) && ("string" === typeof image || _isDefined(image.url))
            },
            _fillStyle: function() {
                this._styles = this._options.styles
            },
            _checkSymbol: function(oldOptions, newOptions) {
                var oldSymbol = oldOptions.symbol,
                    newSymbol = newOptions.symbol,
                    symbolChanged = "circle" === oldSymbol && "circle" !== newSymbol || "circle" !== oldSymbol && "circle" === newSymbol,
                    imageChanged = this._checkImage(oldOptions.image) !== this._checkImage(newOptions.image);
                return !!(symbolChanged || imageChanged)
            },
            _populatePointShape: function(symbol, radius) {
                switch (symbol) {
                    case "square":
                        return getSquareMarkerCoords(radius);
                    case "polygon":
                        return getPolygonMarkerCoords(radius);
                    case "triangle":
                    case "triangleDown":
                        return getTriangleDownMarkerCoords(radius);
                    case "triangleUp":
                        return getTriangleUpMarkerCoords(radius);
                    case "cross":
                        return getCrossMarkerCoords(radius)
                }
            },
            hasCoords: function() {
                return null !== this.x && null !== this.y
            },
            correctValue: function(correction) {
                var that = this;
                var axis = that.series.getValueAxis();
                if (that.hasValue()) {
                    that.value = that.properValue = axis.validateUnit(that.initialValue.valueOf() + correction.valueOf());
                    that.minValue = axis.validateUnit(correction)
                }
            },
            resetCorrection: function() {
                this.value = this.properValue = this.initialValue;
                this.minValue = CANVAS_POSITION_DEFAULT
            },
            resetValue: function() {
                var that = this;
                if (that.hasValue()) {
                    that.value = that.properValue = that.initialValue = 0;
                    that.minValue = 0;
                    that._label.setDataField("value", that.value)
                }
            },
            _getTranslates: function(animationEnabled) {
                var translateX = this.x,
                    translateY = this.y;
                if (animationEnabled) {
                    if (this._options.rotated) {
                        translateX = this.defaultX
                    } else {
                        translateY = this.defaultY
                    }
                }
                return {
                    x: translateX,
                    y: translateY
                }
            },
            _createImageMarker: function(renderer, settings, options) {
                var width = options.width || DEFAULT_IMAGE_WIDTH,
                    height = options.height || DEFAULT_IMAGE_HEIGHT;
                return renderer.image(-_round(.5 * width), -_round(.5 * height), width, height, options.url ? options.url.toString() : options.toString(), "center").attr({
                    translateX: settings.translateX,
                    translateY: settings.translateY,
                    visibility: settings.visibility
                })
            },
            _createSymbolMarker: function(renderer, pointSettings) {
                var marker, symbol = this._options.symbol;
                if ("circle" === symbol) {
                    delete pointSettings.points;
                    marker = renderer.circle().attr(pointSettings)
                } else {
                    if ("square" === symbol || "polygon" === symbol || "triangle" === symbol || "triangleDown" === symbol || "triangleUp" === symbol || "cross" === symbol) {
                        marker = renderer.path([], "area").attr(pointSettings).sharp()
                    }
                }
                return marker
            },
            _createMarker: function(renderer, group, image, settings) {
                var that = this,
                    marker = that._checkImage(image) ? that._createImageMarker(renderer, settings, image) : that._createSymbolMarker(renderer, settings);
                if (marker) {
                    marker.data({
                        "chart-data-point": that
                    }).append(group)
                }
                return marker
            },
            _getSymbolBBox: function(x, y, r) {
                return {
                    x: x - r,
                    y: y - r,
                    width: 2 * r,
                    height: 2 * r
                }
            },
            _getImageBBox: function(x, y) {
                var image = this._options.image,
                    width = image.width || DEFAULT_IMAGE_WIDTH,
                    height = image.height || DEFAULT_IMAGE_HEIGHT;
                return {
                    x: x - _round(width / 2),
                    y: y - _round(height / 2),
                    width: width,
                    height: height
                }
            },
            _getGraphicBBox: function() {
                var bBox, that = this,
                    options = that._options,
                    x = that.x,
                    y = that.y;
                if (options.visible) {
                    bBox = that._checkImage(options.image) ? that._getImageBBox(x, y) : that._getSymbolBBox(x, y, options.styles.normal.r)
                } else {
                    bBox = {
                        x: x,
                        y: y,
                        width: 0,
                        height: 0
                    }
                }
                return bBox
            },
            hideInsideLabel: noop,
            _getShiftLabelCoords: function(label) {
                var coord = this._addLabelAlignmentAndOffset(label, this._getLabelCoords(label));
                return this._checkLabelPosition(label, coord)
            },
            _drawLabel: function() {
                var that = this,
                    customVisibility = that._getCustomLabelVisibility(),
                    label = that._label,
                    isVisible = that._showForZeroValues() && that.hasValue() && false !== customVisibility && (that.series.getLabelVisibility() || customVisibility);
                label.draw(!!isVisible)
            },
            correctLabelPosition: function(label) {
                var that = this,
                    coord = that._getShiftLabelCoords(label);
                if (!that.hideInsideLabel(label, coord)) {
                    label.setFigureToDrawConnector(that._getLabelConnector(label.pointPosition));
                    label.shift(_round(coord.x), _round(coord.y))
                }
            },
            _showForZeroValues: function() {
                return true
            },
            _getLabelConnector: function(pointPosition) {
                var bBox = this._getGraphicBBox(pointPosition),
                    w2 = bBox.width / 2,
                    h2 = bBox.height / 2;
                return {
                    x: bBox.x + w2,
                    y: bBox.y + h2,
                    r: this._options.visible ? Math.max(w2, h2) : 0
                }
            },
            _getPositionFromLocation: function() {
                return {
                    x: this.x,
                    y: this.y
                }
            },
            _isPointInVisibleArea: function(visibleArea, graphicBBox) {
                return visibleArea.minX <= graphicBBox.x + graphicBBox.width && visibleArea.maxX >= graphicBBox.x && visibleArea.minY <= graphicBBox.y + graphicBBox.height && visibleArea.maxY >= graphicBBox.y
            },
            _checkLabelPosition: function(label, coord) {
                var that = this,
                    visibleArea = that._getVisibleArea(),
                    labelBBox = label.getBoundingRect(),
                    graphicBBox = that._getGraphicBBox(label.pointPosition),
                    offset = LABEL_OFFSET;
                if (that._isPointInVisibleArea(visibleArea, graphicBBox)) {
                    if (!that._options.rotated) {
                        if (visibleArea.minX > coord.x) {
                            coord.x = visibleArea.minX
                        }
                        if (visibleArea.maxX < coord.x + labelBBox.width) {
                            coord.x = visibleArea.maxX - labelBBox.width
                        }
                        if (visibleArea.minY > coord.y) {
                            coord.y = graphicBBox.y + graphicBBox.height + offset
                        }
                        if (visibleArea.maxY < coord.y + labelBBox.height) {
                            coord.y = graphicBBox.y - labelBBox.height - offset
                        }
                    } else {
                        if (visibleArea.minX > coord.x) {
                            coord.x = graphicBBox.x + graphicBBox.width + offset
                        }
                        if (visibleArea.maxX < coord.x + labelBBox.width) {
                            coord.x = graphicBBox.x - offset - labelBBox.width
                        }
                        if (visibleArea.minY > coord.y) {
                            coord.y = visibleArea.minY
                        }
                        if (visibleArea.maxY < coord.y + labelBBox.height) {
                            coord.y = visibleArea.maxY - labelBBox.height
                        }
                    }
                }
                return coord
            },
            _addLabelAlignmentAndOffset: function(label, coord) {
                var labelBBox = label.getBoundingRect(),
                    labelOptions = label.getLayoutOptions();
                if (!this._options.rotated) {
                    if ("left" === labelOptions.alignment) {
                        coord.x += labelBBox.width / 2
                    } else {
                        if ("right" === labelOptions.alignment) {
                            coord.x -= labelBBox.width / 2
                        }
                    }
                }
                coord.x += labelOptions.horizontalOffset;
                coord.y += labelOptions.verticalOffset;
                return coord
            },
            _getLabelCoords: function(label) {
                return this._getLabelCoordOfPosition(label, this._getLabelPosition(label.pointPosition))
            },
            _getLabelCoordOfPosition: function(label, position) {
                var that = this,
                    labelBBox = label.getBoundingRect(),
                    graphicBBox = that._getGraphicBBox(label.pointPosition),
                    offset = LABEL_OFFSET,
                    centerY = graphicBBox.height / 2 - labelBBox.height / 2,
                    centerX = graphicBBox.width / 2 - labelBBox.width / 2,
                    x = graphicBBox.x,
                    y = graphicBBox.y;
                switch (position) {
                    case "left":
                        x -= labelBBox.width + offset;
                        y += centerY;
                        break;
                    case "right":
                        x += graphicBBox.width + offset;
                        y += centerY;
                        break;
                    case "top":
                        x += centerX;
                        y -= labelBBox.height + offset;
                        break;
                    case "bottom":
                        x += centerX;
                        y += graphicBBox.height + offset;
                        break;
                    case "inside":
                        x += centerX;
                        y += centerY
                }
                return {
                    x: x,
                    y: y
                }
            },
            _drawMarker: function(renderer, group, animationEnabled) {
                var that = this,
                    options = that._options,
                    translates = that._getTranslates(animationEnabled),
                    style = that._getStyle();
                that.graphic = that._createMarker(renderer, group, options.image, _extend({
                    translateX: translates.x,
                    translateY: translates.y,
                    points: that._populatePointShape(options.symbol, style.r)
                }, style))
            },
            _getErrorBarSettings: function() {
                return {
                    visibility: "visible"
                }
            },
            _getErrorBarBaseEdgeLength: function() {
                return 2 * this.getPointRadius()
            },
            _drawErrorBar: function(renderer, group) {
                if (!this._options.errorBars) {
                    return
                }
                var settings, that = this,
                    options = that._options,
                    errorBarOptions = options.errorBars,
                    points = [],
                    pos = that._errorBarPos,
                    high = that._highErrorCoord,
                    low = that._lowErrorCoord,
                    displayMode = _normalizeEnum(errorBarOptions.displayMode),
                    isHighDisplayMode = "high" === displayMode,
                    isLowDisplayMode = "low" === displayMode,
                    highErrorOnly = (isHighDisplayMode || !_isDefined(low)) && _isDefined(high) && !isLowDisplayMode,
                    lowErrorOnly = (isLowDisplayMode || !_isDefined(high)) && _isDefined(low) && !isHighDisplayMode;
                var edgeLength = errorBarOptions.edgeLength;
                if (edgeLength <= 1 && edgeLength > 0) {
                    edgeLength = this._getErrorBarBaseEdgeLength() * errorBarOptions.edgeLength
                }
                edgeLength = _floor(parseInt(edgeLength) / 2);
                highErrorOnly && (low = that._baseErrorBarPos);
                lowErrorOnly && (high = that._baseErrorBarPos);
                if ("none" !== displayMode && _isDefined(high) && _isDefined(low) && _isDefined(pos)) {
                    !lowErrorOnly && points.push([pos - edgeLength, high, pos + edgeLength, high]);
                    points.push([pos, high, pos, low]);
                    !highErrorOnly && points.push([pos + edgeLength, low, pos - edgeLength, low]);
                    options.rotated && each(points, function(_, p) {
                        p.reverse()
                    });
                    settings = that._getErrorBarSettings(errorBarOptions);
                    if (!that._errorBar) {
                        that._errorBar = renderer.path(points, "line").attr(settings).append(group)
                    } else {
                        settings.points = points;
                        that._errorBar.attr(settings)
                    }
                } else {
                    that._errorBar && that._errorBar.attr({
                        visibility: "hidden"
                    })
                }
            },
            getTooltipParams: function() {
                var that = this,
                    graphic = that.graphic;
                return {
                    x: that.x,
                    y: that.y,
                    offset: graphic ? graphic.getBBox().height / 2 : 0
                }
            },
            setPercentValue: function(absTotal, total, leftHoleTotal, rightHoleTotal) {
                var that = this,
                    valuePercent = that.value / absTotal || 0,
                    minValuePercent = that.minValue / absTotal || 0,
                    percent = valuePercent - minValuePercent;
                that._label.setDataField("percent", percent);
                that._label.setDataField("total", total);
                if (that.series.isFullStackedSeries() && that.hasValue()) {
                    if (that.leftHole) {
                        that.leftHole /= absTotal - leftHoleTotal;
                        that.minLeftHole /= absTotal - leftHoleTotal
                    }
                    if (that.rightHole) {
                        that.rightHole /= absTotal - rightHoleTotal;
                        that.minRightHole /= absTotal - rightHoleTotal
                    }
                    that.value = that.properValue = valuePercent;
                    that.minValue = !minValuePercent ? that.minValue : minValuePercent
                }
            },
            _storeTrackerR: function() {
                var minTrackerSize, that = this,
                    navigator = window.navigator,
                    r = that._options.styles.normal.r;
                navigator = that.__debug_navigator || navigator;
                that.__debug_browserNavigator = navigator;
                minTrackerSize = windowUtils.hasProperty("ontouchstart") || navigator.msPointerEnabled && navigator.msMaxTouchPoints || navigator.pointerEnabled && navigator.maxTouchPoints ? 20 : 6;
                that._options.trackerR = r < minTrackerSize ? minTrackerSize : r;
                return that._options.trackerR
            },
            _translateErrorBars: function() {
                var that = this,
                    options = that._options,
                    rotated = options.rotated,
                    errorBars = options.errorBars,
                    translator = that._getValTranslator();
                if (!errorBars) {
                    return
                }
                _isDefined(that.lowError) && (that._lowErrorCoord = translator.translate(that.lowError));
                _isDefined(that.highError) && (that._highErrorCoord = translator.translate(that.highError));
                that._errorBarPos = _floor(rotated ? that.vy : that.vx);
                that._baseErrorBarPos = "stdDeviation" === errorBars.type ? that._lowErrorCoord + (that._highErrorCoord - that._lowErrorCoord) / 2 : rotated ? that.vx : that.vy
            },
            _translate: function() {
                var that = this,
                    valTranslator = that._getValTranslator(),
                    argTranslator = that._getArgTranslator();
                if (that._options.rotated) {
                    that.vx = that.x = valTranslator.translate(that.value);
                    that.vy = that.y = argTranslator.translate(that.argument);
                    that.minX = valTranslator.translate(that.minValue);
                    that.defaultX = valTranslator.translate(CANVAS_POSITION_DEFAULT)
                } else {
                    that.vy = that.y = valTranslator.translate(that.value);
                    that.vx = that.x = argTranslator.translate(that.argument);
                    that.minY = valTranslator.translate(that.minValue);
                    that.defaultY = valTranslator.translate(CANVAS_POSITION_DEFAULT)
                }
                that._translateErrorBars();
                that._calculateVisibility(that.x, that.y)
            },
            _updateData: function(data) {
                var that = this;
                that.value = that.properValue = that.initialValue = that.originalValue = data.value;
                that.minValue = that.initialMinValue = that.originalMinValue = _isDefined(data.minValue) ? data.minValue : CANVAS_POSITION_DEFAULT
            },
            _getImageSettings: function(image) {
                return {
                    href: image.url || image.toString(),
                    width: image.width || DEFAULT_IMAGE_WIDTH,
                    height: image.height || DEFAULT_IMAGE_HEIGHT
                }
            },
            getCrosshairData: function() {
                var that = this,
                    r = that._options.rotated,
                    value = that.properValue,
                    argument = that.argument;
                return {
                    x: that.vx,
                    y: that.vy,
                    xValue: r ? value : argument,
                    yValue: r ? argument : value,
                    axis: that.series.axis
                }
            },
            getPointRadius: function() {
                var extraSpace, style = this._getStyle(),
                    options = this._options,
                    r = style.r,
                    symbol = options.symbol,
                    isSquare = "square" === symbol,
                    isTriangle = "triangle" === symbol || "triangleDown" === symbol || "triangleUp" === symbol;
                if (options.visible && !options.image && r) {
                    extraSpace = style["stroke-width"] / 2;
                    return (isSquare || isTriangle ? 1.4 * r : r) + extraSpace
                }
                return 0
            },
            _updateMarker: function(animationEnabled, style) {
                var settings, that = this,
                    options = that._options,
                    image = options.image,
                    visibility = !that.isVisible() ? {
                        visibility: "hidden"
                    } : {};
                if (that._checkImage(image)) {
                    settings = _extend({}, {
                        visibility: style.visibility
                    }, visibility, that._getImageSettings(image))
                } else {
                    settings = _extend({}, style, visibility, {
                        points: that._populatePointShape(options.symbol, style.r)
                    })
                }
                if (!animationEnabled) {
                    settings.translateX = that.x;
                    settings.translateY = that.y
                }
                that.graphic.attr(settings).sharp()
            },
            _getLabelFormatObject: function() {
                var that = this;
                return {
                    argument: that.initialArgument,
                    value: that.initialValue,
                    originalArgument: that.originalArgument,
                    originalValue: that.originalValue,
                    seriesName: that.series.name,
                    lowErrorValue: that.lowError,
                    highErrorValue: that.highError,
                    point: that
                }
            },
            _getLabelPosition: function() {
                var rotated = this._options.rotated;
                if (this.initialValue > 0) {
                    return rotated ? "right" : "top"
                } else {
                    return rotated ? "left" : "bottom"
                }
            },
            _getFormatObject: function(tooltip) {
                var that = this,
                    labelFormatObject = that._label.getData();
                return _extend({}, labelFormatObject, {
                    argumentText: tooltip.formatValue(that.initialArgument, "argument"),
                    valueText: tooltip.formatValue(that.initialValue)
                }, _isDefined(labelFormatObject.percent) ? {
                    percentText: tooltip.formatValue(labelFormatObject.percent, "percent")
                } : {}, _isDefined(labelFormatObject.total) ? {
                    totalText: tooltip.formatValue(labelFormatObject.total)
                } : {})
            },
            getMarkerVisibility: function() {
                return this._options.visible
            },
            coordsIn: function(x, y) {
                var trackerRadius = this._storeTrackerR();
                return x >= this.x - trackerRadius && x <= this.x + trackerRadius && y >= this.y - trackerRadius && y <= this.y + trackerRadius
            },
            getMinValue: function(noErrorBar) {
                var errorBarOptions = this._options.errorBars;
                if (errorBarOptions && !noErrorBar) {
                    var displayMode = errorBarOptions.displayMode;
                    var lowValue = "high" !== displayMode && _isDefined(this.lowError) ? this.lowError : this.value;
                    var highValue = "low" !== displayMode && _isDefined(this.highError) ? this.highError : this.value;
                    return lowValue < highValue ? lowValue : highValue
                } else {
                    return this.value
                }
            },
            getMaxValue: function(noErrorBar) {
                var errorBarOptions = this._options.errorBars;
                if (errorBarOptions && !noErrorBar) {
                    var displayMode = errorBarOptions.displayMode;
                    var lowValue = "high" !== displayMode && _isDefined(this.lowError) ? this.lowError : this.value;
                    var highValue = "low" !== displayMode && _isDefined(this.highError) ? this.highError : this.value;
                    return lowValue > highValue ? lowValue : highValue
                } else {
                    return this.value
                }
            }
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/viz/core/loading_indicator.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _patchFontOptions = __webpack_require__( /*! ./utils */ 10).patchFontOptions,
            STATE_HIDDEN = 0,
            STATE_SHOWN = 1,
            ANIMATION_EASING = "linear",
            ANIMATION_DURATION = 400,
            LOADING_INDICATOR_READY = "loadingIndicatorReady";

        function LoadingIndicator(parameters) {
            var that = this,
                renderer = parameters.renderer;
            that._group = renderer.g().attr({
                "class": "dx-loading-indicator"
            }).linkOn(renderer.root, {
                name: "loading-indicator",
                after: "peripheral"
            });
            that._rect = renderer.rect().attr({
                opacity: 0
            }).append(that._group);
            that._text = renderer.text().attr({
                align: "center"
            }).append(that._group);
            that._createStates(parameters.eventTrigger, that._group, renderer.root, parameters.notify)
        }
        LoadingIndicator.prototype = {
            constructor: LoadingIndicator,
            _createStates: function(eventTrigger, group, root, notify) {
                var that = this;
                that._states = [{
                    opacity: 0,
                    start: function() {
                        notify(false)
                    },
                    complete: function() {
                        group.linkRemove();
                        root.css({
                            "pointer-events": ""
                        });
                        eventTrigger(LOADING_INDICATOR_READY)
                    }
                }, {
                    opacity: .85,
                    start: function() {
                        group.linkAppend();
                        root.css({
                            "pointer-events": "none"
                        });
                        notify(true)
                    },
                    complete: function() {
                        eventTrigger(LOADING_INDICATOR_READY)
                    }
                }];
                that._state = STATE_HIDDEN
            },
            setSize: function(size) {
                var width = size.width,
                    height = size.height;
                this._rect.attr({
                    width: width,
                    height: height
                });
                this._text.attr({
                    x: width / 2,
                    y: height / 2
                })
            },
            setOptions: function(options) {
                this._rect.attr({
                    fill: options.backgroundColor
                });
                this._text.css(_patchFontOptions(options.font)).attr({
                    text: options.text,
                    "class": options.cssClass
                });
                this[options.show ? "show" : "hide"]()
            },
            dispose: function() {
                var that = this;
                that._group.linkRemove().linkOff();
                that._group = that._rect = that._text = that._states = null
            },
            _transit: function(stateId) {
                var state, that = this;
                if (that._state !== stateId) {
                    that._state = stateId;
                    that._isHiding = false;
                    state = that._states[stateId];
                    that._rect.stopAnimation().animate({
                        opacity: state.opacity
                    }, {
                        complete: state.complete,
                        easing: ANIMATION_EASING,
                        duration: ANIMATION_DURATION,
                        unstoppable: true
                    });
                    that._noHiding = true;
                    state.start();
                    that._noHiding = false
                }
            },
            show: function() {
                this._transit(STATE_SHOWN)
            },
            hide: function() {
                this._transit(STATE_HIDDEN)
            },
            scheduleHiding: function() {
                if (!this._noHiding) {
                    this._isHiding = true
                }
            },
            fulfillHiding: function() {
                if (this._isHiding) {
                    this.hide()
                }
            }
        };
        exports.LoadingIndicator = LoadingIndicator;
        exports.plugin = {
            name: "loading_indicator",
            init: function() {
                var that = this;
                that._loadingIndicator = new exports.LoadingIndicator({
                    eventTrigger: that._eventTrigger,
                    renderer: that._renderer,
                    notify: notify
                });
                that._scheduleLoadingIndicatorHiding();

                function notify(state) {
                    that._skipLoadingIndicatorOptions = true;
                    that.option("loadingIndicator", {
                        show: state
                    });
                    that._skipLoadingIndicatorOptions = false;
                    if (state) {
                        that._stopCurrentHandling()
                    }
                }
            },
            dispose: function() {
                this._loadingIndicator.dispose();
                this._loadingIndicator = null
            },
            members: {
                _scheduleLoadingIndicatorHiding: function() {
                    this._loadingIndicator.scheduleHiding()
                },
                _fulfillLoadingIndicatorHiding: function() {
                    this._loadingIndicator.fulfillHiding()
                },
                showLoadingIndicator: function() {
                    this._loadingIndicator.show()
                },
                hideLoadingIndicator: function() {
                    this._loadingIndicator.hide()
                },
                _onBeginUpdate: function() {
                    if (!this._optionChangedLocker) {
                        this._scheduleLoadingIndicatorHiding()
                    }
                }
            },
            extenders: {
                _dataSourceLoadingChangedHandler: function(isLoading) {
                    if (isLoading && (this._options.loadingIndicator || {}).enabled) {
                        this._loadingIndicator.show()
                    }
                },
                _setContentSize: function() {
                    this._loadingIndicator.setSize(this._canvas)
                },
                endUpdate: function() {
                    if (this._initialized && this._dataIsReady()) {
                        this._fulfillLoadingIndicatorHiding()
                    }
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                if (proto._dataSourceChangedHandler) {
                    var _dataSourceChangedHandler = proto._dataSourceChangedHandler;
                    proto._dataSourceChangedHandler = function() {
                        this._scheduleLoadingIndicatorHiding();
                        _dataSourceChangedHandler.apply(this, arguments)
                    }
                }
                constructor.addChange({
                    code: "LOADING_INDICATOR",
                    handler: function() {
                        if (!this._skipLoadingIndicatorOptions) {
                            this._loadingIndicator.setOptions(this._getOption("loadingIndicator"))
                        }
                        this._scheduleLoadingIndicatorHiding()
                    },
                    isThemeDependent: true,
                    option: "loadingIndicator",
                    isOptionChange: true
                });
                proto._eventsMap.onLoadingIndicatorReady = {
                    name: "loadingIndicatorReady"
                };
                var _drawn = proto._drawn;
                proto._drawn = function() {
                    _drawn.apply(this, arguments);
                    if (this._dataIsReady()) {
                        this._fulfillLoadingIndicatorHiding()
                    }
                }
            },
            fontFields: ["loadingIndicator.font"]
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/viz/tree_map/tiling.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var defaultAlgorithm, _isFunction = __webpack_require__( /*! ../../core/utils/type */ 1).isFunction,
            _normalizeEnum = __webpack_require__( /*! ../core/utils */ 10).normalizeEnum,
            _round = Math.round,
            algorithms = {};
        exports.getAlgorithm = function(value) {
            return algorithms[_normalizeEnum(value)] || _isFunction(value) && value || defaultAlgorithm
        };
        exports.addAlgorithm = function(name, callback) {
            algorithms[name] = callback
        };
        exports.setDefaultAlgorithm = function(name) {
            defaultAlgorithm = algorithms[name]
        };
        var directionToIndexOffsets = {};
        directionToIndexOffsets[-1] = [2, 0];
        directionToIndexOffsets[1] = [0, 2];
        var getStaticSideIndex = function(rect) {
            return rect[2] - rect[0] < rect[3] - rect[1] ? 0 : 1
        };
        exports.getStaticSideIndex = getStaticSideIndex;
        exports.buildSidesData = function(rect, directions, _staticSideIndex) {
            var staticSideIndex = void 0 !== _staticSideIndex ? _staticSideIndex : getStaticSideIndex(rect),
                variedSideIndex = 1 - staticSideIndex,
                staticSideDirection = directions[staticSideIndex],
                variedSideDirection = directions[variedSideIndex],
                staticSideIndexOffsets = directionToIndexOffsets[staticSideDirection],
                variedSideIndexOffsets = directionToIndexOffsets[variedSideDirection];
            return {
                staticSide: rect[2 + staticSideIndex] - rect[staticSideIndex],
                variedSide: rect[2 + variedSideIndex] - rect[variedSideIndex],
                static1: staticSideIndex + staticSideIndexOffsets[0],
                static2: staticSideIndex + staticSideIndexOffsets[1],
                varied1: variedSideIndex + variedSideIndexOffsets[0],
                varied2: variedSideIndex + variedSideIndexOffsets[1],
                staticDir: staticSideDirection,
                variedDir: variedSideDirection
            }
        };
        exports.calculateRectangles = function(nodes, head, totalRect, sidesData, rowData) {
            var i, ii, rect, delta, variedSidePart = [0, 0, 0, 0],
                static1 = sidesData.static1,
                static2 = sidesData.static2,
                position = totalRect[static1],
                dir = sidesData.staticDir,
                side = sidesData.staticSide,
                sum = rowData.sum;
            variedSidePart[sidesData.varied1] = totalRect[sidesData.varied1];
            variedSidePart[sidesData.varied2] = totalRect[sidesData.varied1] + sidesData.variedDir * rowData.side;
            for (i = head, ii = head + rowData.count; i < ii; ++i) {
                rect = variedSidePart.slice();
                rect[static1] = position;
                delta = _round(side * nodes[i].value / sum) || 0;
                sum -= nodes[i].value;
                side -= delta;
                position += dir * delta;
                rect[static2] = position;
                nodes[i].rect = rect
            }
            totalRect[sidesData.varied1] = variedSidePart[sidesData.varied2]
        }
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled/viz/tree_map/colorizing.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var defaultColorizerName, _normalizeEnum = __webpack_require__( /*! ../core/utils */ 10).normalizeEnum,
            _noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            colorizers = {};

        function wrapLeafColorGetter(getter) {
            return function(node) {
                return !node.isNode() ? getter(node) : void 0
            }
        }

        function wrapGroupColorGetter(getter) {
            return function(node) {
                var parent = !node.isNode() && node.parent;
                return parent ? parent._groupColor = parent._groupColor || getter(parent) : void 0
            }
        }
        exports.getColorizer = function(options, themeManager, root) {
            var type = _normalizeEnum(options.type || defaultColorizerName),
                colorizer = colorizers[type] && colorizers[type](options, themeManager, root);
            return colorizer ? (options.colorizeGroups ? wrapGroupColorGetter : wrapLeafColorGetter)(colorizer) : _noop
        };
        exports.addColorizer = function(name, colorizer) {
            colorizers[name] = colorizer
        };
        exports.setDefaultColorizer = function(name) {
            defaultColorizerName = name
        };

        function getValueAsColorCode(node) {
            return node.value
        }

        function createColorCodeGetter(colorCodeField) {
            return function(node) {
                return Number(node.data[colorCodeField])
            }
        }
        exports.createColorCodeGetter = function(options) {
            return options.colorCodeField ? createColorCodeGetter(options.colorCodeField) : getValueAsColorCode
        }
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator_callbacks.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ../../core/memorized_callbacks */ 177);
        module.exports = new MemorizedCallbacks
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            Class = __webpack_require__( /*! ../../core/class */ 15),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var Emitter = Class.inherit({
            ctor: function(element) {
                this._$element = $(element);
                this._cancelCallback = Callbacks();
                this._acceptCallback = Callbacks()
            },
            getElement: function() {
                return this._$element
            },
            validate: function(e) {
                return !eventUtils.isDxMouseWheelEvent(e)
            },
            validatePointers: function(e) {
                return 1 === eventUtils.hasTouches(e)
            },
            allowInterruptionByMouseWheel: function() {
                return true
            },
            configure: function(data) {
                extend(this, data)
            },
            addCancelCallback: function(callback) {
                this._cancelCallback.add(callback)
            },
            removeCancelCallback: function() {
                this._cancelCallback.empty()
            },
            _cancel: function(e) {
                this._cancelCallback.fire(this, e)
            },
            addAcceptCallback: function(callback) {
                this._acceptCallback.add(callback)
            },
            removeAcceptCallback: function() {
                this._acceptCallback.empty()
            },
            _accept: function(e) {
                this._acceptCallback.fire(this, e)
            },
            _requestAccept: function(e) {
                this._acceptRequestEvent = e
            },
            _forgetAccept: function() {
                this._accept(this._acceptRequestEvent);
                this._acceptRequestEvent = null
            },
            start: noop,
            move: noop,
            end: noop,
            cancel: noop,
            reset: function() {
                if (this._acceptRequestEvent) {
                    this._accept(this._acceptRequestEvent)
                }
            },
            _fireEvent: function(eventName, e, params) {
                var eventData = extend({
                    type: eventName,
                    originalEvent: e,
                    target: this._getEmitterTarget(e),
                    delegateTarget: this.getElement().get(0)
                }, params);
                e = eventUtils.fireEvent(eventData);
                if (e.cancel) {
                    this._cancel(e)
                }
                return e
            },
            _getEmitterTarget: function(e) {
                return (this.delegateSelector ? $(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
            },
            dispose: noop
        });
        module.exports = Emitter
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/events/core/wheel.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 63),
            registerEvent = __webpack_require__( /*! ./event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var EVENT_NAME = "dxmousewheel",
            EVENT_NAMESPACE = "dxWheel";
        var getWheelEventName = callOnce(function() {
            return domAdapter.hasDocumentProperty("onwheel") ? "wheel" : "mousewheel"
        });
        var wheel = {
            setup: function(element) {
                var $element = $(element);
                eventsEngine.on($element, eventUtils.addNamespace(getWheelEventName(), EVENT_NAMESPACE), wheel._wheelHandler.bind(wheel))
            },
            teardown: function(element) {
                eventsEngine.off(element, "." + EVENT_NAMESPACE)
            },
            _wheelHandler: function(e) {
                var delta = this._getWheelDelta(e.originalEvent);
                eventUtils.fireEvent({
                    type: EVENT_NAME,
                    originalEvent: e,
                    delta: delta,
                    pointerType: "mouse"
                });
                e.stopPropagation()
            },
            _getWheelDelta: function(event) {
                return event.wheelDelta ? event.wheelDelta : 30 * -event.deltaY
            }
        };
        registerEvent(EVENT_NAME, wheel);
        exports.name = EVENT_NAME
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.feedback.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            contains = __webpack_require__( /*! ../../core/utils/dom */ 12).contains,
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 24),
            Emitter = __webpack_require__( /*! ./emitter */ 123),
            registerEmitter = __webpack_require__( /*! ./emitter_registrator */ 95);
        var ACTIVE_EVENT_NAME = "dxactive",
            INACTIVE_EVENT_NAME = "dxinactive",
            ACTIVE_TIMEOUT = 30,
            INACTIVE_TIMEOUT = 400;
        var FeedbackEvent = Class.inherit({
            ctor: function(timeout, fire) {
                this._timeout = timeout;
                this._fire = fire
            },
            start: function() {
                var that = this;
                this._schedule(function() {
                    that.force()
                })
            },
            _schedule: function(fn) {
                this.stop();
                this._timer = setTimeout(fn, this._timeout)
            },
            stop: function() {
                clearTimeout(this._timer)
            },
            force: function() {
                if (this._fired) {
                    return
                }
                this.stop();
                this._fire();
                this._fired = true
            },
            fired: function() {
                return this._fired
            }
        });
        var activeFeedback;
        var FeedbackEmitter = Emitter.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._active = new FeedbackEvent(0, commonUtils.noop);
                this._inactive = new FeedbackEvent(0, commonUtils.noop)
            },
            configure: function(data, eventName) {
                switch (eventName) {
                    case ACTIVE_EVENT_NAME:
                        data.activeTimeout = data.timeout;
                        break;
                    case INACTIVE_EVENT_NAME:
                        data.inactiveTimeout = data.timeout
                }
                this.callBase(data)
            },
            start: function(e) {
                if (activeFeedback) {
                    var activeChildExists = contains(this.getElement().get(0), activeFeedback.getElement().get(0));
                    var childJustActivated = !activeFeedback._active.fired();
                    if (activeChildExists && childJustActivated) {
                        this._cancel();
                        return
                    }
                    activeFeedback._inactive.force()
                }
                activeFeedback = this;
                this._initEvents(e);
                this._active.start()
            },
            _initEvents: function(e) {
                var that = this,
                    eventTarget = this._getEmitterTarget(e),
                    mouseEvent = eventUtils.isMouseEvent(e),
                    isSimulator = devices.isSimulator(),
                    deferFeedback = isSimulator || !mouseEvent,
                    activeTimeout = commonUtils.ensureDefined(this.activeTimeout, ACTIVE_TIMEOUT),
                    inactiveTimeout = commonUtils.ensureDefined(this.inactiveTimeout, INACTIVE_TIMEOUT);
                this._active = new FeedbackEvent(deferFeedback ? activeTimeout : 0, function() {
                    that._fireEvent(ACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    })
                });
                this._inactive = new FeedbackEvent(deferFeedback ? inactiveTimeout : 0, function() {
                    that._fireEvent(INACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    });
                    activeFeedback = null
                })
            },
            cancel: function(e) {
                this.end(e)
            },
            end: function(e) {
                var skipTimers = e.type !== pointerEvents.up;
                if (skipTimers) {
                    this._active.stop()
                } else {
                    this._active.force()
                }
                this._inactive.start();
                if (skipTimers) {
                    this._inactive.force()
                }
            },
            dispose: function() {
                this._active.stop();
                this._inactive.stop();
                this.callBase()
            },
            lockInactive: function() {
                this._active.force();
                this._inactive.stop();
                activeFeedback = null;
                this._cancel();
                return this._inactive.force.bind(this._inactive)
            }
        });
        FeedbackEmitter.lock = function(deferred) {
            var lockInactive = activeFeedback ? activeFeedback.lockInactive() : commonUtils.noop;
            deferred.done(lockInactive)
        };
        registerEmitter({
            emitter: FeedbackEmitter,
            events: [ACTIVE_EVENT_NAME, INACTIVE_EVENT_NAME]
        });
        exports.lock = FeedbackEmitter.lock;
        exports.active = ACTIVE_EVENT_NAME;
        exports.inactive = INACTIVE_EVENT_NAME
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/item.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            publicComponentUtils = __webpack_require__( /*! ../../core/utils/public_component */ 131);
        var INVISIBLE_STATE_CLASS = "dx-state-invisible",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            ITEM_CONTENT_PLACEHOLDER_CLASS = "dx-item-content-placeholder";
        var forcibleWatcher = function(watchMethod, fn, callback) {
            var filteredCallback = function() {
                var oldValue;
                return function(value) {
                    if (oldValue !== value) {
                        callback(value, oldValue);
                        oldValue = value
                    }
                }
            }();
            return {
                dispose: watchMethod(fn, filteredCallback),
                force: function() {
                    filteredCallback(fn())
                }
            }
        };
        var CollectionItem = Class.inherit({
            ctor: function($element, options, rawData) {
                this._$element = $element;
                this._options = options;
                this._rawData = rawData;
                publicComponentUtils.attachInstanceToElement($element, this, this._dispose);
                this._render()
            },
            _render: function() {
                var $placeholder = $("<div>").addClass(ITEM_CONTENT_PLACEHOLDER_CLASS);
                this._$element.append($placeholder);
                this._watchers = [];
                this._renderWatchers()
            },
            _renderWatchers: function() {
                this._startWatcher("disabled", this._renderDisabled.bind(this));
                this._startWatcher("visible", this._renderVisible.bind(this))
            },
            _startWatcher: function(field, render) {
                var rawData = this._rawData,
                    exprGetter = this._options.fieldGetter(field);
                var watcher = forcibleWatcher(this._options.watchMethod(), function() {
                    return exprGetter(rawData)
                }, function(value, oldValue) {
                    this._dirty = true;
                    render(value, oldValue)
                }.bind(this));
                this._watchers.push(watcher)
            },
            setDataField: function() {
                this._dirty = false;
                each(this._watchers, function(_, watcher) {
                    watcher.force()
                });
                if (this._dirty) {
                    return true
                }
            },
            _renderDisabled: function(value, oldValue) {
                this._$element.toggleClass(DISABLED_STATE_CLASS, !!value)
            },
            _renderVisible: function(value, oldValue) {
                this._$element.toggleClass(INVISIBLE_STATE_CLASS, void 0 !== value && !value)
            },
            _dispose: function() {
                each(this._watchers, function(_, watcher) {
                    watcher.dispose()
                })
            }
        });
        CollectionItem.getInstance = function($element) {
            return publicComponentUtils.getInstanceByElement($element, this)
        };
        module.exports = CollectionItem
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/localization/globalize/core.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Globalize = __webpack_require__( /*! globalize */ 72),
            coreLocalization = __webpack_require__( /*! ../core */ 87);
        if (Globalize && Globalize.load) {
            var likelySubtags = {
                supplemental: {
                    version: {
                        _cldrVersion: "28",
                        _unicodeVersion: "8.0.0",
                        _number: "$Revision: 11965 $"
                    },
                    likelySubtags: {
                        en: "en-Latn-US",
                        de: "de-Latn-DE",
                        ru: "ru-Cyrl-RU",
                        ja: "ja-Jpan-JP"
                    }
                }
            };
            if (!Globalize.locale()) {
                Globalize.load(likelySubtags);
                Globalize.locale("en")
            }
            coreLocalization.inject({
                locale: function(_locale) {
                    if (!_locale) {
                        return Globalize.locale().locale
                    }
                    Globalize.locale(_locale)
                }
            })
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/double_click.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 12),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 11),
            Class = __webpack_require__( /*! ../core/class */ 15),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            clickEvent = __webpack_require__( /*! ./click */ 19),
            eventUtils = __webpack_require__( /*! ./utils */ 9);
        var DBLCLICK_EVENT_NAME = "dxdblclick",
            DBLCLICK_NAMESPACE = "dxDblClick",
            NAMESPACED_CLICK_EVENT = eventUtils.addNamespace(clickEvent.name, DBLCLICK_NAMESPACE),
            DBLCLICK_TIMEOUT = 300;
        var DblClick = Class.inherit({
            ctor: function() {
                this._handlerCount = 0;
                this._forgetLastClick()
            },
            _forgetLastClick: function() {
                this._firstClickTarget = null;
                this._lastClickTimeStamp = -DBLCLICK_TIMEOUT
            },
            add: function() {
                if (this._handlerCount <= 0) {
                    eventsEngine.on(domAdapter.getDocument(), NAMESPACED_CLICK_EVENT, this._clickHandler.bind(this))
                }
                this._handlerCount++
            },
            _clickHandler: function(e) {
                var timeStamp = e.timeStamp || Date.now();
                if (timeStamp - this._lastClickTimeStamp < DBLCLICK_TIMEOUT) {
                    eventUtils.fireEvent({
                        type: DBLCLICK_EVENT_NAME,
                        target: domUtils.closestCommonParent(this._firstClickTarget, e.target),
                        originalEvent: e
                    });
                    this._forgetLastClick()
                } else {
                    this._firstClickTarget = e.target;
                    this._lastClickTimeStamp = timeStamp
                }
            },
            remove: function() {
                this._handlerCount--;
                if (this._handlerCount <= 0) {
                    this._forgetLastClick();
                    eventsEngine.off(domAdapter.getDocument(), NAMESPACED_CLICK_EVENT)
                }
            }
        });
        registerEvent(DBLCLICK_EVENT_NAME, new DblClick);
        exports.name = DBLCLICK_EVENT_NAME
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/error.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            consoleUtils = __webpack_require__( /*! ./console */ 80),
            stringUtils = __webpack_require__( /*! ./string */ 46),
            version = __webpack_require__( /*! ../version */ 157);
        var ERROR_URL = "http://js.devexpress.com/error/" + version.split(".").slice(0, 2).join("_") + "/";
        module.exports = function(baseErrors, errors) {
            var exports = {
                ERROR_MESSAGES: extend(errors, baseErrors),
                Error: function() {
                    return makeError([].slice.call(arguments))
                },
                log: function(id) {
                    var method = "log";
                    if (/^E\d+$/.test(id)) {
                        method = "error"
                    } else {
                        if (/^W\d+$/.test(id)) {
                            method = "warn"
                        }
                    }
                    consoleUtils.logger[method]("log" === method ? id : combineMessage([].slice.call(arguments)))
                }
            };
            var combineMessage = function(args) {
                var id = args[0];
                args = args.slice(1);
                return formatMessage(id, formatDetails(id, args))
            };
            var formatDetails = function(id, args) {
                args = [exports.ERROR_MESSAGES[id]].concat(args);
                return stringUtils.format.apply(this, args).replace(/\.*\s*?$/, "")
            };
            var formatMessage = function(id, details) {
                return stringUtils.format.apply(this, ["{0} - {1}. See:\n{2}", id, details, getErrorUrl(id)])
            };
            var makeError = function(args) {
                var id, details, message, url;
                id = args[0];
                args = args.slice(1);
                details = formatDetails(id, args);
                url = getErrorUrl(id);
                message = formatMessage(id, details);
                return extend(new Error(message), {
                    __id: id,
                    __details: details,
                    url: url
                })
            };
            var getErrorUrl = function(id) {
                return ERROR_URL + id
            };
            return exports
        }
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/resize_callbacks.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ./window */ 7),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 11),
            Callbacks = __webpack_require__( /*! ./callbacks */ 25),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 48),
            callOnce = __webpack_require__( /*! ./call_once */ 63);
        var resizeCallbacks = function() {
            var prevSize, callbacks = Callbacks(),
                originalCallbacksAdd = callbacks.add,
                originalCallbacksRemove = callbacks.remove;
            if (!windowUtils.hasWindow()) {
                return callbacks
            }
            var formatSize = function() {
                var documentElement = domAdapter.getDocumentElement();
                return {
                    width: documentElement.clientWidth,
                    height: documentElement.clientHeight
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                callbacks.fire(changedDimension)
            };
            var setPrevSize = callOnce(function() {
                prevSize = formatSize()
            });
            var removeListener;
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                setPrevSize();
                readyCallbacks.add(function() {
                    if (!removeListener && callbacks.has()) {
                        removeListener = domAdapter.listen(windowUtils.getWindow(), "resize", handleResize)
                    }
                });
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && removeListener) {
                    removeListener();
                    removeListener = void 0
                }
                return result
            };
            return callbacks
        }();
        module.exports = resizeCallbacks
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/public_component.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../../core/element_data */ 39),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            WeakMap = __webpack_require__( /*! ../polyfills/weak_map */ 176),
            isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            removeEvent = __webpack_require__( /*! ../remove_event */ 132);
        var COMPONENT_NAMES_DATA_KEY = "dxComponents",
            ANONYMOUS_COMPONENT_DATA_KEY = "dxPrivateComponent";
        var componentNames = new WeakMap,
            nextAnonymousComponent = 0;
        var getName = exports.name = function(componentClass, newName) {
            if (isDefined(newName)) {
                componentNames.set(componentClass, newName);
                return
            }
            if (!componentNames.has(componentClass)) {
                var generatedName = ANONYMOUS_COMPONENT_DATA_KEY + nextAnonymousComponent++;
                componentNames.set(componentClass, generatedName);
                return generatedName
            }
            return componentNames.get(componentClass)
        };
        exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
            var data = dataUtils.data($element.get(0)),
                name = getName(componentInstance.constructor);
            data[name] = componentInstance;
            if (disposeFn) {
                eventsEngine.one($element, removeEvent, function() {
                    disposeFn.call(componentInstance)
                })
            }
            if (!data[COMPONENT_NAMES_DATA_KEY]) {
                data[COMPONENT_NAMES_DATA_KEY] = []
            }
            data[COMPONENT_NAMES_DATA_KEY].push(name)
        };
        exports.getInstanceByElement = function($element, componentClass) {
            var name = getName(componentClass);
            return dataUtils.data($element.get(0), name)
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/remove_event.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var beforeCleanData = __webpack_require__( /*! ./element_data */ 39).beforeCleanData;
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var registerEvent = __webpack_require__( /*! ../events/core/event_registrator */ 71);
        var eventName = "dxremove";
        var eventPropName = "dxRemoveEvent";
        beforeCleanData(function(elements) {
            elements = [].slice.call(elements);
            for (var i = 0; i < elements.length; i++) {
                var $element = $(elements[i]);
                if ($element.prop(eventPropName)) {
                    $element[0][eventPropName] = null;
                    eventsEngine.triggerHandler($element, eventName)
                }
            }
        });
        registerEvent(eventName, {
            noBubble: true,
            setup: function(element) {
                $(element).prop(eventPropName, true)
            }
        });
        module.exports = eventName
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/component.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var Config = __webpack_require__( /*! ./config */ 31),
            domAdapter = __webpack_require__( /*! ./dom_adapter */ 11),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            Class = __webpack_require__( /*! ./class */ 15),
            Action = __webpack_require__( /*! ./action */ 111),
            errors = __webpack_require__( /*! ./errors */ 21),
            coreDataUtils = __webpack_require__( /*! ./utils/data */ 20),
            commonUtils = __webpack_require__( /*! ./utils/common */ 4),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 25),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 81),
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 131),
            devices = __webpack_require__( /*! ./devices */ 16),
            isFunction = typeUtils.isFunction,
            noop = commonUtils.noop;
        var cachedGetters = {};
        var cachedSetters = {};
        var PostponedOperations = function() {
            function PostponedOperations() {
                _classCallCheck(this, PostponedOperations);
                this._postponedOperations = {}
            }
            _createClass(PostponedOperations, [{
                key: "add",
                value: function(key, fn, postponedPromise) {
                    if (key in this._postponedOperations) {
                        postponedPromise && this._postponedOperations[key].promises.push(postponedPromise)
                    } else {
                        var completePromise = new Deferred;
                        this._postponedOperations[key] = {
                            fn: fn,
                            completePromise: completePromise,
                            promises: postponedPromise ? [postponedPromise] : []
                        }
                    }
                    return this._postponedOperations[key].completePromise.promise()
                }
            }, {
                key: "callPostponedOperations",
                value: function() {
                    for (var key in this._postponedOperations) {
                        var operation = this._postponedOperations[key];
                        if (typeUtils.isDefined(operation)) {
                            if (operation.promises && operation.promises.length) {
                                when.apply(void 0, _toConsumableArray(operation.promises)).done(operation.fn).then(operation.completePromise.resolve)
                            } else {
                                operation.fn().done(operation.completePromise.resolve)
                            }
                        }
                    }
                    this._postponedOperations = {}
                }
            }]);
            return PostponedOperations
        }();
        var Component = Class.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getOptionAliasesByName: function(optionName) {
                var _this = this;
                return Object.keys(this._deprecatedOptions).filter(function(aliasName) {
                    return optionName === _this._deprecatedOptions[aliasName].alias
                })
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _setDefaultOptions: function() {
                this._options = this._getDefaultOptions()
            },
            _defaultOptionsRules: function() {
                return []
            },
            _setOptionsByDevice: function(customRules) {
                var rules = this._defaultOptionsRules();
                if (Array.isArray(customRules)) {
                    rules = rules.concat(customRules)
                }
                var rulesOptions = this._convertRulesToOptions(rules);
                extend(true, this._options, rulesOptions);
                for (var fieldName in this._optionsByReference) {
                    if (Object.prototype.hasOwnProperty.call(rulesOptions, fieldName)) {
                        this._options[fieldName] = rulesOptions[fieldName]
                    }
                }
            },
            _convertRulesToOptions: function(rules) {
                var options = {};
                var currentDevice = devices.current();
                var deviceMatch = function(device, filter) {
                    var filterArray = [];
                    Array.prototype.push.call(filterArray, filter);
                    return 1 === filterArray.length && typeUtils.isEmptyObject(filterArray[0]) || commonUtils.findBestMatches(device, filterArray).length > 0
                };
                for (var i = 0; i < rules.length; i++) {
                    var match, rule = rules[i],
                        deviceFilter = rule.device || {};
                    if (isFunction(deviceFilter)) {
                        match = deviceFilter(currentDevice)
                    } else {
                        match = deviceMatch(currentDevice, deviceFilter)
                    }
                    if (match) {
                        extend(options, rule.options)
                    }
                }
                return options
            },
            _isInitialOptionValue: function(name) {
                var optionValue = this.option(name),
                    initialOptionValue = this.initialOption(name),
                    isInitialOption = isFunction(optionValue) && isFunction(initialOptionValue) ? optionValue.toString() === initialOptionValue.toString() : commonUtils.equalByValue(optionValue, initialOptionValue);
                return isInitialOption
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function(options) {
                this.NAME = publicComponentUtils.name(this.constructor);
                options = options || {};
                if (options.eventsStrategy) {
                    this.setEventsStrategy(options.eventsStrategy)
                }
                this._options = {};
                this._updateLockCount = 0;
                this._optionChangedCallbacks = options._optionChangedCallbacks || Callbacks();
                this._disposingCallbacks = options._disposingCallbacks || Callbacks();
                this.postponedOperations = new PostponedOperations;
                this.beginUpdate();
                try {
                    this._suppressDeprecatedWarnings();
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._setDefaultOptions();
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._resumeDeprecatedWarnings();
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _optionValuesEqual: function(name, oldValue, newValue) {
                oldValue = coreDataUtils.toComparable(oldValue, true);
                newValue = coreDataUtils.toComparable(newValue, true);
                if (oldValue && newValue && typeUtils.isRenderer(oldValue) && typeUtils.isRenderer(newValue)) {
                    return newValue.is(oldValue)
                }
                var oldValueIsNaN = oldValue !== oldValue,
                    newValueIsNaN = newValue !== newValue;
                if (oldValueIsNaN && newValueIsNaN) {
                    return true
                }
                if (null === oldValue || "object" !== ("undefined" === typeof oldValue ? "undefined" : _typeof(oldValue)) || domAdapter.isElementNode(oldValue)) {
                    return oldValue === newValue
                }
                return false
            },
            _init: function() {
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    this._disposingCallbacks.fireWith(this, [args])
                }.bind(this))
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._disposeEvents();
                this._disposed = true
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0);
                if (!this._updateLockCount) {
                    this.postponedOperations.callPostponedOperations();
                    if (!this._initializing && !this._initialized) {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._updateLockCount++;
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly"]
                            })();
                            this._updateLockCount--;
                            this._initialized = true
                        }
                    }
                }
            },
            _logWarningIfDeprecated: function(option) {
                var info = this._deprecatedOptions[option];
                if (info && !this._deprecatedOptionsSuppressed) {
                    this._logDeprecatedWarning(option, info)
                }
            },
            _logDeprecatedWarningCount: 0,
            _logDeprecatedWarning: function(option, info) {
                var message = info.message || "Use the '" + info.alias + "' option instead";
                errors.log("W0001", this.NAME, option, info.since, message);
                ++this._logDeprecatedWarningCount
            },
            _suppressDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = true
            },
            _resumeDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = false
            },
            _optionChanging: noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                var that = this;
                if (this._initialized) {
                    var optionNames = [option].concat(that._getOptionAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i],
                            args = {
                                name: name.split(/[.[]/)[0],
                                fullName: name,
                                value: value,
                                previousValue: previousValue
                            };
                        that._optionChangedCallbacks.fireWith(that, [extend(that._defaultActionArgs(), args)]);
                        that._optionChangedAction(extend({}, args));
                        if (!that._disposed && this._cancelOptionChange !== args.name) {
                            that._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(optionName) {
                var currentOptions, currentInitialized = this._initialized;
                if (!this._initialOptions) {
                    currentOptions = this._options;
                    this._options = {};
                    this._initialized = false;
                    this._setDefaultOptions();
                    this._setOptionsByDevice(currentOptions.defaultOptionsRules);
                    this._initialOptions = this._options;
                    this._options = currentOptions;
                    this._initialized = currentInitialized
                }
                return this._initialOptions[optionName]
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var action, that = this;
                return function(e) {
                    if (!arguments.length) {
                        e = {}
                    }
                    if (!typeUtils.isPlainObject(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new Action(actionSource, extend(config, that._defaultActionConfig()));
                    return action.execute.call(action, extend(e, that._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var action, eventName, actionFunc, that = this;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw errors.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = that._getEventName(optionName)
                        }
                        if (0 !== optionName.indexOf("on")) {
                            throw Error("The '" + optionName + "' option name should start with 'on' prefix")
                        }
                        actionFunc = that.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !that.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function(args) {
                            beforeExecute && beforeExecute.apply(that, arguments);
                            that.fireEvent(eventName, args.args)
                        };
                        that._suppressDeprecatedWarnings();
                        action = that._createAction(actionFunc, config);
                        that._resumeDeprecatedWarnings()
                    }
                    if (Config().wrapActionsBeforeExecute) {
                        var beforeActionExecute = that.option("beforeActionExecute") || noop;
                        var wrappedAction = beforeActionExecute(that, action, config) || action;
                        return wrappedAction.apply(that, arguments)
                    }
                    return action.apply(that, arguments)
                };
                if (!Config().wrapActionsBeforeExecute) {
                    var onActionCreated = that.option("onActionCreated") || noop;
                    result = onActionCreated(that, result, config) || result
                }
                return result
            },
            _getEventName: function(actionName) {
                return actionName.charAt(2).toLowerCase() + actionName.substr(3)
            },
            hasActionSubscription: function(actionName) {
                return !!this.option(actionName) || this.hasEvent(this._getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                var deprecatedOptions = this._getDeprecatedOptions();
                return Object.prototype.hasOwnProperty.call(deprecatedOptions, name)
            },
            _setOptionSilent: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            option: function() {
                var normalizeOptionName = function(that, name) {
                    var deprecate;
                    if (name) {
                        if (!that._cachedDeprecateNames) {
                            that._cachedDeprecateNames = [];
                            for (var optionName in that._deprecatedOptions) {
                                that._cachedDeprecateNames.push(optionName)
                            }
                        }
                        for (var i = 0; i < that._cachedDeprecateNames.length; i++) {
                            if (that._cachedDeprecateNames[i] === name) {
                                deprecate = that._deprecatedOptions[name];
                                break
                            }
                        }
                        if (deprecate) {
                            that._logWarningIfDeprecated(name);
                            var alias = deprecate.alias;
                            if (alias) {
                                name = alias
                            }
                        }
                    }
                    return name
                };
                var getPreviousName = function(fullName) {
                    var splitNames = fullName.split(".");
                    splitNames.pop();
                    return splitNames.join(".")
                };
                var getFieldName = function(fullName) {
                    var splitNames = fullName.split(".");
                    return splitNames[splitNames.length - 1]
                };
                var getOptionValue = function(options, name, unwrapObservables) {
                    var getter = cachedGetters[name];
                    if (!getter) {
                        getter = cachedGetters[name] = coreDataUtils.compileGetter(name)
                    }
                    return getter(options, {
                        functionsAsIs: true,
                        unwrapObservables: unwrapObservables
                    })
                };
                var clearOptionsField = function(options, name) {
                    delete options[name];
                    var previousFieldName = getPreviousName(name),
                        fieldName = getFieldName(name),
                        fieldObject = previousFieldName ? getOptionValue(options, previousFieldName, false) : options;
                    if (fieldObject) {
                        delete fieldObject[fieldName]
                    }
                };
                var setOptionsField = function(options, fullName, value) {
                    var fieldObject, fieldName = "";
                    do {
                        if (fieldName) {
                            fieldName = "." + fieldName
                        }
                        fieldName = getFieldName(fullName) + fieldName;
                        fullName = getPreviousName(fullName);
                        fieldObject = fullName ? getOptionValue(options, fullName, false) : options
                    } while (!fieldObject);
                    fieldObject[fieldName] = value
                };
                var normalizeOptionValue = function(that, options, name, value) {
                    if (name) {
                        var alias = normalizeOptionName(that, name);
                        if (alias && alias !== name) {
                            setOptionsField(options, alias, value);
                            clearOptionsField(options, name)
                        }
                    }
                };
                var prepareOption = function prepareOption(that, options, name, value) {
                    if (typeUtils.isPlainObject(value)) {
                        for (var valueName in value) {
                            prepareOption(that, options, name + "." + valueName, value[valueName])
                        }
                    }
                    normalizeOptionValue(that, options, name, value)
                };
                var setOptionValue = function(that, name, value) {
                    if (!cachedSetters[name]) {
                        cachedSetters[name] = coreDataUtils.compileSetter(name)
                    }
                    var path = name.split(/[.[]/);
                    cachedSetters[name](that._options, value, {
                        functionsAsIs: true,
                        merge: !that._getOptionsByReference()[name],
                        unwrapObservables: path.length > 1 && !!that._getOptionsByReference()[path[0]]
                    })
                };
                var setOption = function(that, name, value) {
                    var previousValue = getOptionValue(that._options, name, false);
                    if (that._optionValuesEqual(name, previousValue, value)) {
                        return
                    }
                    if (that._initialized) {
                        that._optionChanging(name, previousValue, value)
                    }
                    setOptionValue(that, name, value);
                    that._notifyOptionChanged(name, value, previousValue)
                };
                return function(options, value) {
                    var that = this,
                        name = options;
                    if (arguments.length < 2 && "object" !== typeUtils.type(name)) {
                        name = normalizeOptionName(that, name);
                        return getOptionValue(that._options, name)
                    }
                    if ("string" === typeof name) {
                        options = {};
                        options[name] = value
                    }
                    that.beginUpdate();
                    try {
                        var optionName;
                        for (optionName in options) {
                            prepareOption(that, options, optionName, options[optionName])
                        }
                        for (optionName in options) {
                            setOption(that, optionName, options[optionName])
                        }
                    } finally {
                        that.endUpdate()
                    }
                }
            }(),
            _getOptionValue: function(name, context) {
                var value = this.option(name);
                if (isFunction(value)) {
                    return value.bind(context)()
                }
                return value
            }
        }).include(EventsMixin);
        module.exports = Component;
        module.exports.PostponedOperations = PostponedOperations
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/child_default_template.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 73);
        module.exports = TemplateBase.inherit({
            ctor: function(name) {
                this.name = name
            }
        })
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _config = __webpack_require__( /*! ../core/config */ 31);
        var _config2 = _interopRequireDefault(_config);
        var _guid = __webpack_require__( /*! ../core/guid */ 43);
        var _guid2 = _interopRequireDefault(_guid);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _errors = __webpack_require__( /*! ./errors */ 36);
        var _object = __webpack_require__( /*! ../core/utils/object */ 47);
        var _object2 = _interopRequireDefault(_object);
        var _utils = __webpack_require__( /*! ./utils */ 40);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function hasKey(target, keyOrKeys) {
            var key, keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
            while (keys.length) {
                key = keys.shift();
                if (key in target) {
                    return true
                }
            }
            return false
        }

        function findItems(keyInfo, items, key, groupCount) {
            var childItems, result;
            if (groupCount) {
                for (var i = 0; i < items.length; i++) {
                    childItems = items[i].items || items[i].collapsedItems || [];
                    result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                    if (result) {
                        return result
                    }
                }
            } else {
                if (indexByKey(keyInfo, items, key) >= 0) {
                    return items
                }
            }
        }

        function getItems(keyInfo, items, key, groupCount) {
            if (groupCount) {
                return findItems(keyInfo, items, key, groupCount) || []
            }
            return items
        }

        function generateDataByKeyMap(keyInfo, array) {
            if (keyInfo.key() && !array._dataByKeyMap) {
                var dataByKeyMap = {};
                for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                }
                array._dataByKeyMap = dataByKeyMap
            }
        }

        function getCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
        }

        function getHasKeyCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
            return true
        }

        function setDataByKeyMapValue(array, key, data) {
            if (array._dataByKeyMap) {
                array._dataByKeyMap[JSON.stringify(key)] = data
            }
        }

        function applyBatch(keyInfo, array, batchData, groupCount, useInsertIndex) {
            batchData.forEach(function(item) {
                var items = "insert" === item.type ? array : getItems(keyInfo, array, item.key, groupCount);
                generateDataByKeyMap(keyInfo, items);
                switch (item.type) {
                    case "update":
                        update(keyInfo, items, item.key, item.data, true);
                        break;
                    case "insert":
                        insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true);
                        break;
                    case "remove":
                        remove(keyInfo, items, item.key, true)
                }
            })
        }

        function update(keyInfo, array, key, data, isBatch) {
            var target, extendComplexObject = true,
                keyExpr = keyInfo.key();
            if (keyExpr) {
                if (hasKey(data, keyExpr) && !(0, _utils.keysEqual)(keyExpr, key, keyInfo.keyOf(data))) {
                    return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4017"))
                }
                target = getCacheValue(array, key);
                if (!target) {
                    var index = indexByKey(keyInfo, array, key);
                    if (index < 0) {
                        return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                    }
                    target = array[index]
                }
            } else {
                target = key
            }
            _object2.default.deepExtendArraySafe(target, data, extendComplexObject);
            if (!isBatch) {
                if ((0, _config2.default)().useLegacyStoreResult) {
                    return (0, _utils.trivialPromise)(key, data)
                } else {
                    return (0, _utils.trivialPromise)(target, key)
                }
            }
        }

        function insert(keyInfo, array, data, index, isBatch) {
            var keyValue, obj, keyExpr = keyInfo.key();
            obj = (0, _type.isPlainObject)(data) ? (0, _extend.extend)({}, data) : data;
            if (keyExpr) {
                keyValue = keyInfo.keyOf(obj);
                if (void 0 === keyValue || "object" === ("undefined" === typeof keyValue ? "undefined" : _typeof(keyValue)) && (0, _type.isEmptyObject)(keyValue)) {
                    if (Array.isArray(keyExpr)) {
                        throw _errors.errors.Error("E4007")
                    }
                    keyValue = obj[keyExpr] = String(new _guid2.default)
                } else {
                    if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                        return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4008"))
                    }
                }
            } else {
                keyValue = obj
            }
            if (index >= 0) {
                array.splice(index, 0, obj)
            } else {
                array.push(obj)
            }
            setDataByKeyMapValue(array, keyValue, obj);
            if (!isBatch) {
                return (0, _utils.trivialPromise)((0, _config2.default)().useLegacyStoreResult ? data : obj, keyValue)
            }
        }

        function remove(keyInfo, array, key, isBatch) {
            var index = indexByKey(keyInfo, array, key);
            if (index > -1) {
                array.splice(index, 1)
            }
            if (!isBatch) {
                return (0, _utils.trivialPromise)(key)
            }
        }

        function indexByKey(keyInfo, array, key) {
            var keyExpr = keyInfo.key();
            if (!getHasKeyCacheValue(array, key)) {
                return -1
            }
            for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                if ((0, _utils.keysEqual)(keyExpr, keyInfo.keyOf(array[i]), key)) {
                    return i
                }
            }
            return -1
        }
        module.exports.applyBatch = applyBatch;
        module.exports.update = update;
        module.exports.insert = insert;
        module.exports.remove = remove;
        module.exports.indexByKey = indexByKey
    }, , , , , , ,
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/viz/core/helpers.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop;
        var isServerSide = !windowUtils.hasWindow();

        function Flags() {
            this.reset()
        }
        Flags.prototype = {
            constructor: Flags,
            add: function(codes) {
                var i, ii = codes.length,
                    flags = this._flags;
                for (i = 0; i < ii; ++i) {
                    flags[codes[i]] = 1
                }
                this._k += ii
            },
            has: function(code) {
                return this._flags[code] > 0
            },
            count: function() {
                return this._k
            },
            reset: function() {
                this._flags = {};
                this._k = 0
            }
        };

        function combineMaps(baseMap, thisMap) {
            return baseMap !== thisMap ? _extend({}, baseMap, thisMap) : _extend({}, baseMap)
        }

        function combineLists(baseList, thisList) {
            return baseList !== thisList ? baseList.concat(thisList) : baseList.slice()
        }

        function buildTotalChanges(proto) {
            proto._totalChangesOrder = proto._optionChangesOrder.concat(proto._layoutChangesOrder, proto._customChangesOrder)
        }

        function addChange(settings) {
            var proto = this.prototype,
                code = settings.code;
            proto["_change_" + code] = settings.handler;
            if (settings.isThemeDependent) {
                proto._themeDependentChanges.push(code)
            }
            if (settings.option) {
                proto._optionChangesMap[settings.option] = code
            }(settings.isOptionChange ? proto._optionChangesOrder : proto._customChangesOrder).push(code);
            buildTotalChanges(proto)
        }

        function createChainExecutor() {
            var executeChain = function executeChain() {
                var i, result, ii = executeChain._chain.length;
                for (i = 0; i < ii; ++i) {
                    result = executeChain._chain[i].apply(this, arguments)
                }
                return result
            };
            executeChain._chain = [];
            executeChain.add = function(item) {
                executeChain._chain.push(item)
            };
            executeChain.copy = function(executor) {
                executeChain._chain = executor._chain.slice()
            };
            return executeChain
        }

        function expand(target, name, expander) {
            var current = target[name];
            if (!current) {
                current = expander
            } else {
                if (!current.add) {
                    current = createChainExecutor();
                    current.add(target[name]);
                    current.add(expander)
                } else {
                    if (false === Object.prototype.hasOwnProperty.call(target, name)) {
                        current = createChainExecutor();
                        current.copy(target[name])
                    }
                    current.add(expander)
                }
            }
            target[name] = current
        }

        function addPlugin(plugin) {
            var proto = this.prototype;
            proto._plugins.push(plugin);
            plugin.fontFields && proto._fontFields.push.apply(proto._fontFields, plugin.fontFields);
            if (plugin.members) {
                _extend(this.prototype, plugin.members)
            }
            if (plugin.customize) {
                plugin.customize(this)
            }
            if (plugin.extenders) {
                Object.keys(plugin.extenders).forEach(function(key) {
                    var func = plugin.extenders[key];
                    expand(proto, key, func)
                }, this)
            }
        }
        exports.replaceInherit = isServerSide ? function(widget) {
            var _inherit = widget.inherit;
            widget.inherit = function() {
                var result = _inherit.apply(this, arguments);
                var proto = result.prototype;
                ["_plugins", "_eventsMap", "_initialChanges", "_themeDependentChanges", "_optionChangesMap", "_optionChangesOrder", "_layoutChangesOrder", "_customChangesOrder", "_totalChangesOrder"].forEach(function(key) {
                    proto[key] = {}
                });
                result.addPlugin = noop;
                return result
            };
            widget.addChange = noop;
            widget.addPlugin = noop
        } : function(widget) {
            var _inherit = widget.inherit;
            widget.inherit = function() {
                var proto = this.prototype,
                    plugins = proto._plugins,
                    fontFields = proto._fontFields,
                    eventsMap = proto._eventsMap,
                    initialChanges = proto._initialChanges,
                    themeDependentChanges = proto._themeDependentChanges,
                    optionChangesMap = proto._optionChangesMap,
                    partialOptionChangesMap = proto._partialOptionChangesMap,
                    partialOptionChangesPath = proto._partialOptionChangesPath,
                    optionChangesOrder = proto._optionChangesOrder,
                    layoutChangesOrder = proto._layoutChangesOrder,
                    customChangesOrder = proto._customChangesOrder,
                    result = _inherit.apply(this, arguments);
                proto = result.prototype;
                proto._plugins = combineLists(plugins, proto._plugins);
                proto._fontFields = combineLists(fontFields, proto._fontFields);
                proto._eventsMap = combineMaps(eventsMap, proto._eventsMap);
                proto._initialChanges = combineLists(initialChanges, proto._initialChanges);
                proto._themeDependentChanges = combineLists(themeDependentChanges, proto._themeDependentChanges);
                proto._optionChangesMap = combineMaps(optionChangesMap, proto._optionChangesMap);
                proto._partialOptionChangesMap = combineMaps(partialOptionChangesMap, proto._partialOptionChangesMap);
                proto._partialOptionChangesPath = combineMaps(partialOptionChangesPath, proto._partialOptionChangesPath);
                proto._optionChangesOrder = combineLists(optionChangesOrder, proto._optionChangesOrder);
                proto._layoutChangesOrder = combineLists(layoutChangesOrder, proto._layoutChangesOrder);
                proto._customChangesOrder = combineLists(customChangesOrder, proto._customChangesOrder);
                buildTotalChanges(proto);
                result.addPlugin = addPlugin;
                return result
            };
            widget.prototype._plugins = [];
            widget.prototype._fontFields = [];
            widget.addChange = addChange;
            widget.addPlugin = addPlugin
        };
        exports.changes = function() {
            return new Flags
        };
        exports.expand = expand
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/viz/series/bar_series.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            scatterSeries = __webpack_require__( /*! ./scatter_series */ 106),
            areaSeries = __webpack_require__( /*! ./area_series */ 165).chart.area,
            chartSeries = scatterSeries.chart,
            polarSeries = scatterSeries.polar,
            _extend = extend,
            _each = each;
        exports.chart = {};
        exports.polar = {};
        var baseBarSeriesMethods = {
            _createLegendState: function(styleOptions, defaultColor) {
                return {
                    fill: styleOptions.color || defaultColor,
                    hatching: styleOptions.hatching
                }
            },
            _parsePointStyle: function(style, defaultColor, defaultBorderColor) {
                var color = style.color || defaultColor,
                    base = chartSeries._parsePointStyle.call(this, style, color, defaultBorderColor);
                base.fill = color;
                base.hatching = style.hatching;
                base.dashStyle = style.border && style.border.dashStyle || "solid";
                delete base.r;
                return base
            },
            _applyMarkerClipRect: function(settings) {
                settings["clip-path"] = null
            },
            _setGroupsSettings: function(animationEnabled, firstDrawing) {
                var that = this,
                    settings = {};
                chartSeries._setGroupsSettings.apply(that, arguments);
                if (animationEnabled && firstDrawing) {
                    settings = this._getAffineCoordOptions()
                } else {
                    if (!animationEnabled) {
                        settings = {
                            scaleX: 1,
                            scaleY: 1,
                            translateX: 0,
                            translateY: 0
                        }
                    }
                }
                that._markersGroup.attr(settings)
            },
            _drawPoint: function(options) {
                options.hasAnimation = options.hasAnimation && !options.firstDrawing;
                options.firstDrawing = false;
                chartSeries._drawPoint.call(this, options)
            },
            _getMainColor: function() {
                return this._options.mainSeriesColor
            },
            _createPointStyles: function(pointOptions) {
                var that = this,
                    mainColor = pointOptions.color || that._getMainColor();
                return {
                    normal: that._parsePointStyle(pointOptions, mainColor, mainColor),
                    hover: that._parsePointStyle(pointOptions.hoverStyle || {}, mainColor, mainColor),
                    selection: that._parsePointStyle(pointOptions.selectionStyle || {}, mainColor, mainColor)
                }
            },
            _updatePointsVisibility: function() {
                var visibility = this._options.visible;
                each(this._points, function(_, point) {
                    point._options.visible = visibility
                })
            },
            _getOptionsForPoint: function() {
                return this._options
            },
            _animate: function(firstDrawing) {
                var that = this,
                    complete = function() {
                        that._animateComplete()
                    },
                    animateFunc = function(drawnPoints, complete) {
                        var lastPointIndex = drawnPoints.length - 1;
                        _each(drawnPoints || [], function(i, point) {
                            point.animate(i === lastPointIndex ? complete : void 0, point.getMarkerCoords())
                        })
                    };
                that._animatePoints(firstDrawing, complete, animateFunc)
            },
            getValueRangeInitialValue: areaSeries.getValueRangeInitialValue,
            _patchMarginOptions: function(options) {
                options.checkInterval = true;
                return options
            },
            _defaultAggregator: "sum",
            _defineDrawingState: function() {},
            usePointsToDefineAutoHiding: function() {
                return false
            }
        };
        exports.chart.bar = _extend({}, chartSeries, baseBarSeriesMethods, {
            _getAffineCoordOptions: function() {
                var rotated = this._options.rotated,
                    direction = rotated ? "X" : "Y",
                    settings = {
                        scaleX: rotated ? .001 : 1,
                        scaleY: rotated ? 1 : .001
                    };
                settings["translate" + direction] = this.getValueAxis().getTranslator().translate("canvas_position_default");
                return settings
            },
            _animatePoints: function(firstDrawing, complete, animateFunc) {
                var that = this;
                that._markersGroup.animate({
                    scaleX: 1,
                    scaleY: 1,
                    translateY: 0,
                    translateX: 0
                }, void 0, complete);
                if (!firstDrawing) {
                    animateFunc(that._drawnPoints, complete)
                }
            },
            checkSeriesViewportCoord: function(axis, coord) {
                if (0 === this._points.length) {
                    return false
                }
                if (axis.isArgumentAxis) {
                    return true
                }
                var translator = axis.getTranslator();
                var range = this.getViewport();
                var min = translator.translate(range.categories ? range.categories[0] : range.min);
                var max = translator.translate(range.categories ? range.categories[range.categories.length - 1] : range.max);
                var rotated = this.getOptions().rotated;
                var inverted = axis.getOptions().inverted;
                return rotated && !inverted || !rotated && inverted ? coord >= min && coord <= max : coord >= max && coord <= min
            },
            getSeriesPairCoord: function(coord, isArgument) {
                var oppositeCoord = null;
                var rotated = this._options.rotated;
                var isOpposite = !isArgument && !rotated || isArgument && rotated;
                var coordName = isOpposite ? "vy" : "vx";
                var oppositeCoordName = isOpposite ? "vx" : "vy";
                var points = this.getPoints();
                for (var i = 0; i < points.length; i++) {
                    var p = points[i];
                    var tmpCoord = void 0;
                    if (isArgument) {
                        tmpCoord = p.getCenterCoord()[coordName[1]] === coord ? p[oppositeCoordName] : void 0
                    } else {
                        tmpCoord = p[coordName] === coord ? p[oppositeCoordName] : void 0
                    }
                    if (this.checkAxisVisibleAreaCoord(!isArgument, tmpCoord)) {
                        oppositeCoord = tmpCoord;
                        break
                    }
                }
                return oppositeCoord
            }
        });
        exports.polar.bar = _extend({}, polarSeries, baseBarSeriesMethods, {
            _animatePoints: function(firstDrawing, complete, animateFunc) {
                animateFunc(this._drawnPoints, complete)
            },
            _setGroupsSettings: chartSeries._setGroupsSettings,
            _drawPoint: function(point, groups, animationEnabled) {
                chartSeries._drawPoint.call(this, point, groups, animationEnabled)
            },
            _parsePointStyle: function(style) {
                var base = baseBarSeriesMethods._parsePointStyle.apply(this, arguments);
                base.opacity = style.opacity;
                return base
            },
            _createGroups: chartSeries._createGroups,
            _setMarkerGroupSettings: function() {
                var groupSettings, that = this,
                    markersSettings = that._createPointStyles(that._getMarkerGroupOptions()).normal;
                markersSettings.class = "dxc-markers";
                that._applyMarkerClipRect(markersSettings);
                groupSettings = _extend({}, markersSettings);
                delete groupSettings.opacity;
                that._markersGroup.attr(groupSettings)
            },
            _createLegendState: areaSeries._createLegendState
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/viz/core/data_source.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var name, noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            DataHelperMixin = __webpack_require__( /*! ../../data_helper */ 84),
            postCtor = DataHelperMixin.postCtor,
            members = {
                _dataSourceLoadErrorHandler: function() {
                    this._dataSourceChangedHandler()
                },
                _dataSourceOptions: function() {
                    return {
                        paginate: false
                    }
                },
                _updateDataSource: function() {
                    this._refreshDataSource();
                    if (!this.option("dataSource")) {
                        this._dataSourceChangedHandler()
                    }
                },
                _dataIsLoaded: function() {
                    return !this._dataSource || this._dataSource.isLoaded()
                },
                _dataSourceItems: function() {
                    return this._dataSource && this._dataSource.items()
                }
            };
        for (name in DataHelperMixin) {
            if ("postCtor" === name) {
                continue
            }
            members[name] = DataHelperMixin[name]
        }
        exports.plugin = {
            name: "data_source",
            init: function() {
                postCtor.call(this)
            },
            dispose: noop,
            members: members
        }
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/viz/gauges/base_gauge.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _Number = Number,
            _getAppropriateFormat = __webpack_require__( /*! ../core/utils */ 10).getAppropriateFormat,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            translator1DModule = __webpack_require__( /*! ../translators/translator1d */ 410),
            _extend = extend,
            BaseWidget = __webpack_require__( /*! ../core/base_widget */ 96),
            themeManagerModule = __webpack_require__( /*! ./theme_manager */ 791),
            Tracker = __webpack_require__( /*! ./tracker */ 792);
        var dxBaseGauge = BaseWidget.inherit({
            _rootClassPrefix: "dxg",
            _themeSection: "gauge",
            _createThemeManager: function() {
                return new themeManagerModule.ThemeManager(this._getThemeManagerOptions())
            },
            _initCore: function() {
                var that = this,
                    root = that._renderer.root;
                that._valueChangingLocker = 0;
                that._translator = that._factory.createTranslator();
                that._tracker = that._factory.createTracker({
                    renderer: that._renderer,
                    container: root
                });
                that._setTrackerCallbacks()
            },
            _beginValueChanging: function() {
                this._resetIsReady();
                this._onBeginUpdate();
                ++this._valueChangingLocker
            },
            _endValueChanging: function() {
                if (0 === --this._valueChangingLocker) {
                    this._drawn()
                }
            },
            _setTrackerCallbacks: function() {
                var that = this,
                    renderer = that._renderer,
                    tooltip = that._tooltip;
                that._tracker.setCallbacks({
                    "tooltip-show": function(target, info) {
                        var tooltipParameters = target.getTooltipParameters(),
                            offset = renderer.getRootOffset(),
                            formatObject = _extend({
                                value: tooltipParameters.value,
                                valueText: tooltip.formatValue(tooltipParameters.value),
                                color: tooltipParameters.color
                            }, info);
                        return tooltip.show(formatObject, {
                            x: tooltipParameters.x + offset.left,
                            y: tooltipParameters.y + offset.top,
                            offset: tooltipParameters.offset
                        }, {
                            target: info
                        })
                    },
                    "tooltip-hide": function() {
                        return tooltip.hide()
                    }
                })
            },
            _dispose: function() {
                this._cleanCore();
                this.callBase.apply(this, arguments)
            },
            _disposeCore: function() {
                var that = this;
                that._themeManager.dispose();
                that._tracker.dispose();
                that._translator = that._tracker = null
            },
            _cleanCore: function() {
                var that = this;
                that._tracker.deactivate();
                that._cleanContent()
            },
            _renderCore: function() {
                var that = this;
                if (!that._isValidDomain) {
                    return
                }
                that._renderContent();
                that._tracker.setTooltipState(that._tooltip.isEnabled());
                that._tracker.activate();
                that._noAnimation = false;
                that._debug_rendered && that._debug_rendered()
            },
            _applyChanges: function() {
                this.callBase.apply(this, arguments);
                this._resizing = this._noAnimation = false
            },
            _setContentSize: function() {
                var that = this;
                that._resizing = that._noAnimation = 2 === that._changes.count();
                that.callBase.apply(that, arguments)
            },
            _applySize: function(rect) {
                var that = this;
                that._DEBUG_rootRect = rect;
                that._innerRect = {
                    left: rect[0],
                    top: rect[1],
                    right: rect[2],
                    bottom: rect[3]
                };
                var layoutCache = that._layout._cache;
                that._cleanCore();
                that._renderCore();
                that._layout._cache = that._layout._cache || layoutCache;
                return [rect[0], that._innerRect.top, rect[2], that._innerRect.bottom]
            },
            _initialChanges: ["DOMAIN"],
            _themeDependentChanges: ["DOMAIN"],
            _optionChangesMap: {
                subtitle: "MOSTLY_TOTAL",
                indicator: "MOSTLY_TOTAL",
                geometry: "MOSTLY_TOTAL",
                animation: "MOSTLY_TOTAL",
                startValue: "DOMAIN",
                endValue: "DOMAIN"
            },
            _optionChangesOrder: ["DOMAIN", "MOSTLY_TOTAL"],
            _change_DOMAIN: function() {
                this._setupDomain()
            },
            _change_MOSTLY_TOTAL: function() {
                this._applyMostlyTotalChange()
            },
            _setupDomain: function() {
                var that = this;
                that._setupDomainCore();
                that._isValidDomain = isFinite(1 / (that._translator.getDomain()[1] - that._translator.getDomain()[0]));
                if (!that._isValidDomain) {
                    that._incidentOccurred("W2301")
                }
                that._change(["MOSTLY_TOTAL"])
            },
            _applyMostlyTotalChange: function() {
                var that = this;
                that._setupCodomain();
                that._setupAnimationSettings();
                that._setupDefaultFormat();
                that._change(["LAYOUT"])
            },
            _setupAnimationSettings: function() {
                var that = this,
                    option = that.option("animation");
                that._animationSettings = null;
                if (void 0 === option || option) {
                    option = _extend({
                        enabled: true,
                        duration: 1e3,
                        easing: "easeOutCubic"
                    }, option);
                    if (option.enabled && option.duration > 0) {
                        that._animationSettings = {
                            duration: _Number(option.duration),
                            easing: option.easing
                        }
                    }
                }
                that._containerBackgroundColor = that.option("containerBackgroundColor") || that._themeManager.theme().containerBackgroundColor
            },
            _setupDefaultFormat: function() {
                var domain = this._translator.getDomain();
                this._defaultFormatOptions = _getAppropriateFormat(domain[0], domain[1], this._getApproximateScreenRange())
            },
            _setupDomainCore: null,
            _calculateSize: null,
            _cleanContent: null,
            _renderContent: null,
            _setupCodomain: null,
            _getApproximateScreenRange: null,
            _factory: {
                createTranslator: function() {
                    return new translator1DModule.Translator1D
                },
                createTracker: function(parameters) {
                    return new Tracker(parameters)
                }
            }
        });
        exports.dxBaseGauge = dxBaseGauge;
        var _format = __webpack_require__( /*! ../../format_helper */ 64).format;
        var formatValue = function(value, options, extra) {
            options = options || {};
            var formatObject, text = _format(value, options.format);
            if ("function" === typeof options.customizeText) {
                formatObject = _extend({
                    value: value,
                    valueText: text
                }, extra);
                return String(options.customizeText.call(formatObject, formatObject))
            }
            return text
        };
        var getSampleText = function(translator, options) {
            var text1 = formatValue(translator.getDomainStart(), options),
                text2 = formatValue(translator.getDomainEnd(), options);
            return text1.length >= text2.length ? text1 : text2
        };
        exports.formatValue = formatValue;
        exports.getSampleText = getSampleText;
        exports.compareArrays = function(array1, array2) {
            return array1 && array2 && array1.length === array2.length && compareArraysElements(array1, array2)
        };

        function compareArraysElements(array1, array2) {
            var i, array1ValueIsNaN, array2ValueIsNaN, ii = array1.length;
            for (i = 0; i < ii; ++i) {
                array1ValueIsNaN = array1[i] !== array1[i];
                array2ValueIsNaN = array2[i] !== array2[i];
                if (array1ValueIsNaN && array2ValueIsNaN) {
                    continue
                }
                if (array1[i] !== array2[i]) {
                    return false
                }
            }
            return true
        }
        dxBaseGauge.addPlugin(__webpack_require__( /*! ../core/export */ 93).plugin);
        dxBaseGauge.addPlugin(__webpack_require__( /*! ../core/title */ 105).plugin);
        dxBaseGauge.addPlugin(__webpack_require__( /*! ../core/tooltip */ 107).plugin);
        dxBaseGauge.addPlugin(__webpack_require__( /*! ../core/loading_indicator */ 119).plugin);
        var _setTooltipOptions = dxBaseGauge.prototype._setTooltipOptions;
        dxBaseGauge.prototype._setTooltipOptions = function() {
            _setTooltipOptions.apply(this, arguments);
            this._tracker && this._tracker.setTooltipState(this._tooltip.isEnabled())
        }
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/viz/tree_map/api.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var proto = __webpack_require__( /*! ./tree_map.base */ 70).prototype,
            nodeProto = __webpack_require__( /*! ./node */ 166).prototype,
            _extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        proto._eventsMap.onNodesInitialized = {
            name: "nodesInitialized"
        };
        proto._eventsMap.onNodesRendering = {
            name: "nodesRendering"
        };
        proto._createProxyType = function() {
            var nodes, that = this;
            Proxy.prototype = {
                constructor: Proxy,
                getParent: function() {
                    return nodes[this._id].parent.proxy || null
                },
                getChild: function(index) {
                    var _nodes = nodes[this._id].nodes;
                    return _nodes ? _nodes[index].proxy : null
                },
                getChildrenCount: function() {
                    var _nodes = nodes[this._id].nodes;
                    return _nodes ? _nodes.length : 0
                },
                getAllChildren: function() {
                    var i, _nodes = nodes[this._id].nodes,
                        ii = _nodes && _nodes.length,
                        list = [];
                    for (i = 0; i < ii; ++i) {
                        list.push(_nodes[i].proxy)
                    }
                    return list
                },
                getAllNodes: function() {
                    var list = [];
                    collectNodes(nodes[this._id], list);
                    return list
                },
                isLeaf: function() {
                    return !nodes[this._id].isNode()
                },
                isActive: function() {
                    return nodes[this._id].isActive()
                },
                value: function(arg) {
                    var result, node = nodes[this._id];
                    if (void 0 !== arg) {
                        updateValue(node, arg > 0 ? Number(arg) : 0);
                        change(node, ["TILING"]);
                        result = this
                    } else {
                        result = node.value
                    }
                    return result
                },
                label: function(arg) {
                    var result, node = nodes[this._id];
                    if (void 0 !== arg) {
                        node.customLabel = arg ? String(arg) : null;
                        change(node, ["LABELS"]);
                        result = this
                    } else {
                        result = node.customLabel || node.label
                    }
                    return result
                },
                customize: function(settings) {
                    var node = nodes[this._id];
                    if (settings) {
                        node._custom = node._custom || {};
                        _extend(true, node._custom, settings);
                        node._partialState = node._partialLabelState = null
                    }
                    change(node, ["TILES", "LABELS"]);
                    return this
                },
                resetCustomization: function() {
                    var node = nodes[this._id];
                    node._custom = node._partialState = node._partialLabelState = null;
                    change(node, ["TILES", "LABELS"]);
                    return this
                }
            };
            that._extendProxyType(Proxy.prototype);

            function Proxy(node) {
                var that = this;
                node.proxy = that;
                that._id = node._id;
                that.level = node.level;
                that.index = node.index;
                that.data = node.data
            }
            that._handlers.beginBuildNodes = function() {
                nodes = that._nodes;
                new Proxy(that._root)
            };
            that._handlers.buildNode = function(node) {
                new Proxy(node)
            };
            that._handlers.endBuildNodes = function() {
                that._eventTrigger("nodesInitialized", {
                    root: that._root.proxy
                })
            }
        };

        function change(node, codes) {
            var ctx = node.ctx;
            ctx.suspend();
            ctx.change(codes);
            ctx.resume()
        }

        function collectNodes(node, list) {
            var i, nodes = node.nodes,
                ii = nodes && nodes.length;
            for (i = 0; i < ii; ++i) {
                list.push(nodes[i].proxy);
                collectNodes(nodes[i], list)
            }
        }

        function updateValue(node, value) {
            var delta = value - node.value;
            while (node) {
                node.value += delta;
                node = node.parent
            }
        }
        proto._extendProxyType = __webpack_require__( /*! ../../core/utils/common */ 4).noop;
        var _resetNodes = proto._resetNodes;
        proto._resetNodes = function() {
            _resetNodes.call(this);
            this._eventTrigger("nodesRendering", {
                node: this._topNode.proxy
            })
        };
        var _updateStyles = nodeProto.updateStyles;
        nodeProto.updateStyles = function() {
            var that = this;
            _updateStyles.call(that);
            if (that._custom) {
                that._partialState = !that.ctx.forceReset && that._partialState || that.ctx.calculateState(that._custom);
                _extend(true, that.state, that._partialState)
            }
        };
        var _updateLabelStyle = nodeProto.updateLabelStyle;
        nodeProto.updateLabelStyle = function() {
            var that = this,
                custom = that._custom;
            _updateLabelStyle.call(that);
            if (custom && custom.label) {
                that._partialLabelState = !that.ctx.forceReset && that._partialLabelState || calculatePartialLabelState(that, custom.label);
                that.labelState = _extend(true, {}, that.labelState, that._partialLabelState)
            }
        };

        function calculatePartialLabelState(node, settings) {
            var state = node.ctx.calculateLabelState(settings);
            if ("visible" in settings) {
                state.visible = !!settings.visible
            }
            return state
        }
        proto.getRootNode = function() {
            return this._root.proxy
        };
        proto.resetNodes = function() {
            var context = this._context;
            context.suspend();
            context.change(["NODES_CREATE"]);
            context.resume();
            return this
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/bundles/modules/core.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var DevExpress = window.DevExpress = window.DevExpress || {};
        var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 21);
        if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
            throw errors.Error("E0024")
        }
        DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
        DevExpress.clientExporter = __webpack_require__( /*! ../../exporter */ 170);
        DevExpress.excelExporter = __webpack_require__( /*! ../../exporter/exceljs/excelExporter */ 439);
        DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 157);
        DevExpress.Class = __webpack_require__( /*! ../../core/class */ 15);
        DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 67);
        DevExpress.Component = __webpack_require__( /*! ../../core/component */ 133);
        DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8);
        DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 16);
        DevExpress.Color = __webpack_require__( /*! ../../color */ 94);
        var animationFrame = __webpack_require__( /*! ../../animation/frame */ 112);
        DevExpress.EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 81);
        DevExpress.utils = {};
        DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
        DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
        DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 442).initMobileViewport;
        DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 0).extendFromObject;
        DevExpress.utils.createComponents = __webpack_require__( /*! ../../core/utils/dom */ 12).createComponents;
        DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../core/utils/dom */ 12).triggerShownEvent;
        DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../core/utils/dom */ 12).triggerHidingEvent;
        DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 12).resetActiveElement;
        DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 4).findBestMatches;
        DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 262).create;
        DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 12);
        DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 4);
        DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 22);
        DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 27);
        DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 32);
        DevExpress.utils.iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        DevExpress.utils.readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 48);
        DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 130);
        DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 80);
        DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 46);
        DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 42);
        DevExpress.utils.ajax = __webpack_require__( /*! ../../core/utils/ajax */ 58);
        DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 76).value;
        DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 212);
        DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 64);
        DevExpress.config = __webpack_require__( /*! ../../core/config */ 31);
        DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 178).presets;
        DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 38);
        DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 280).TransitionExecutor;
        DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 178).PresetCollection;
        DevExpress.events = __webpack_require__( /*! ../../events */ 281);
        DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 19);
        DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 9);
        DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 158);
        DevExpress.localization = __webpack_require__( /*! ../../localization */ 445);
        module.exports = DevExpress
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/hover.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            dataUtils = __webpack_require__( /*! ../core/element_data */ 39),
            Class = __webpack_require__( /*! ../core/class */ 15),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            pointerEvents = __webpack_require__( /*! ./pointer */ 24);
        var HOVERSTART_NAMESPACE = "dxHoverStart",
            HOVERSTART = "dxhoverstart",
            POINTERENTER_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.enter, HOVERSTART_NAMESPACE),
            HOVEREND_NAMESPACE = "dxHoverEnd",
            HOVEREND = "dxhoverend",
            POINTERLEAVE_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.leave, HOVEREND_NAMESPACE);
        var Hover = Class.inherit({
            noBubble: true,
            ctor: function() {
                this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
            },
            setup: function(element) {
                dataUtils.data(element, this._handlerArrayKeyPath, {})
            },
            add: function(element, handleObj) {
                var that = this,
                    handler = function(e) {
                        that._handler(e)
                    };
                eventsEngine.on(element, this._originalEventName, handleObj.selector, handler);
                dataUtils.data(element, this._handlerArrayKeyPath)[handleObj.guid] = handler
            },
            _handler: function(e) {
                if (eventUtils.isTouchEvent(e) || devices.isSimulator()) {
                    return
                }
                eventUtils.fireEvent({
                    type: this._eventName,
                    originalEvent: e,
                    delegateTarget: e.delegateTarget
                })
            },
            remove: function(element, handleObj) {
                var handler = dataUtils.data(element, this._handlerArrayKeyPath)[handleObj.guid];
                eventsEngine.off(element, this._originalEventName, handleObj.selector, handler)
            },
            teardown: function(element) {
                dataUtils.removeData(element, this._handlerArrayKeyPath)
            }
        });
        var HoverStart = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVERSTART_NAMESPACE;
                this._eventName = HOVERSTART;
                this._originalEventName = POINTERENTER_NAMESPACED_EVENT_NAME;
                this.callBase()
            },
            _handler: function(e) {
                var pointers = e.pointers || [];
                if (!pointers.length) {
                    this.callBase(e)
                }
            }
        });
        var HoverEnd = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVEREND_NAMESPACE;
                this._eventName = HOVEREND;
                this._originalEventName = POINTERLEAVE_NAMESPACED_EVENT_NAME;
                this.callBase()
            }
        });
        registerEvent(HOVERSTART, new HoverStart);
        registerEvent(HOVEREND, new HoverEnd);
        exports.start = HOVERSTART;
        exports.end = HOVEREND
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/custom_store.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ./utils */ 40),
            arrayUtils = __webpack_require__( /*! ./array_utils */ 135),
            isFunction = __webpack_require__( /*! ../core/utils/type */ 1).isFunction,
            config = __webpack_require__( /*! ../core/config */ 31),
            errors = __webpack_require__( /*! ./errors */ 36).errors,
            Store = __webpack_require__( /*! ./abstract_store */ 98),
            arrayQuery = __webpack_require__( /*! ./array_query */ 155),
            queryByOptions = __webpack_require__( /*! ./store_helper */ 79).queryByOptions,
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            fromPromise = deferredUtils.fromPromise;
        var TOTAL_COUNT = "totalCount",
            LOAD = "load",
            BY_KEY = "byKey",
            INSERT = "insert",
            UPDATE = "update",
            REMOVE = "remove";

        function isPromise(obj) {
            return obj && isFunction(obj.then)
        }

        function trivialPromise(value) {
            return (new Deferred).resolve(value).promise()
        }

        function ensureRequiredFuncOption(name, obj) {
            if (!isFunction(obj)) {
                throw errors.Error("E4011", name)
            }
        }

        function throwInvalidUserFuncResult(name) {
            throw errors.Error("E4012", name)
        }

        function createUserFuncFailureHandler(pendingDeferred) {
            function errorMessageFromXhr(promiseArguments) {
                var xhr = promiseArguments[0],
                    textStatus = promiseArguments[1];
                if (!xhr || !xhr.getResponseHeader) {
                    return null
                }
                return dataUtils.errorMessageFromXhr(xhr, textStatus)
            }
            return function(arg) {
                var error;
                if (arg instanceof Error) {
                    error = arg
                } else {
                    error = new Error(errorMessageFromXhr(arguments) || arg && String(arg) || "Unknown error")
                }
                if (error.message !== dataUtils.XHR_ERROR_UNLOAD) {
                    pendingDeferred.reject(error)
                }
            }
        }

        function invokeUserLoad(store, options) {
            var userResult, userFunc = store._loadFunc;
            ensureRequiredFuncOption(LOAD, userFunc);
            userResult = userFunc.apply(store, [options]);
            if (Array.isArray(userResult)) {
                userResult = trivialPromise(userResult)
            } else {
                if (null === userResult || void 0 === userResult) {
                    userResult = trivialPromise([])
                } else {
                    if (!isPromise(userResult)) {
                        throwInvalidUserFuncResult(LOAD)
                    }
                }
            }
            return fromPromise(userResult)
        }

        function invokeUserTotalCountFunc(store, options) {
            var userResult, userFunc = store._totalCountFunc;
            if (!isFunction(userFunc)) {
                throw errors.Error("E4021")
            }
            userResult = userFunc.apply(store, [options]);
            if (!isPromise(userResult)) {
                userResult = Number(userResult);
                if (!isFinite(userResult)) {
                    throwInvalidUserFuncResult(TOTAL_COUNT)
                }
                userResult = trivialPromise(userResult)
            }
            return fromPromise(userResult)
        }

        function invokeUserByKeyFunc(store, key, extraOptions) {
            var userResult, userFunc = store._byKeyFunc;
            ensureRequiredFuncOption(BY_KEY, userFunc);
            userResult = userFunc.apply(store, [key, extraOptions]);
            if (!isPromise(userResult)) {
                userResult = trivialPromise(userResult)
            }
            return fromPromise(userResult)
        }

        function runRawLoad(pendingDeferred, store, userFuncOptions, continuation) {
            if (store.__rawData) {
                continuation(store.__rawData)
            } else {
                var loadPromise = store.__rawDataPromise || invokeUserLoad(store, userFuncOptions);
                if (store._cacheRawData) {
                    store.__rawDataPromise = loadPromise
                }
                loadPromise.always(function() {
                    delete store.__rawDataPromise
                }).done(function(rawData) {
                    if (store._cacheRawData) {
                        store.__rawData = rawData
                    }
                    continuation(rawData)
                }).fail(createUserFuncFailureHandler(pendingDeferred))
            }
        }

        function runRawLoadWithQuery(pendingDeferred, store, options, countOnly) {
            options = options || {};
            var userFuncOptions = {};
            if ("userData" in options) {
                userFuncOptions.userData = options.userData
            }
            runRawLoad(pendingDeferred, store, userFuncOptions, function(rawData) {
                var itemsQuery, totalCountQuery, rawDataQuery = arrayQuery(rawData, {
                        errorHandler: store._errorHandler
                    }),
                    waitList = [];
                var items, totalCount;
                if (!countOnly) {
                    itemsQuery = queryByOptions(rawDataQuery, options);
                    if (itemsQuery === rawDataQuery) {
                        items = rawData.slice(0)
                    } else {
                        waitList.push(itemsQuery.enumerate().done(function(asyncResult) {
                            items = asyncResult
                        }))
                    }
                }
                if (options.requireTotalCount || countOnly) {
                    totalCountQuery = queryByOptions(rawDataQuery, options, true);
                    if (totalCountQuery === rawDataQuery) {
                        totalCount = rawData.length
                    } else {
                        waitList.push(totalCountQuery.count().done(function(asyncResult) {
                            totalCount = asyncResult
                        }))
                    }
                }
                when.apply($, waitList).done(function() {
                    if (countOnly) {
                        pendingDeferred.resolve(totalCount)
                    } else {
                        if (options.requireTotalCount) {
                            pendingDeferred.resolve(items, {
                                totalCount: totalCount
                            })
                        } else {
                            pendingDeferred.resolve(items)
                        }
                    }
                }).fail(function(x) {
                    pendingDeferred.reject(x)
                })
            })
        }

        function runRawLoadWithKey(pendingDeferred, store, key) {
            runRawLoad(pendingDeferred, store, {}, function(rawData) {
                var item, keyExpr = store.key();
                for (var i = 0, len = rawData.length; i < len; i++) {
                    item = rawData[i];
                    if (dataUtils.keysEqual(keyExpr, store.keyOf(rawData[i]), key)) {
                        pendingDeferred.resolve(item);
                        return
                    }
                }
                pendingDeferred.reject(errors.Error("E4009"))
            })
        }
        var CustomStore = Store.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._useDefaultSearch = !!options.useDefaultSearch || "raw" === options.loadMode;
                this._loadMode = options.loadMode;
                this._cacheRawData = false !== options.cacheRawData;
                this._loadFunc = options[LOAD];
                this._totalCountFunc = options[TOTAL_COUNT];
                this._byKeyFunc = options[BY_KEY];
                this._insertFunc = options[INSERT];
                this._updateFunc = options[UPDATE];
                this._removeFunc = options[REMOVE]
            },
            createQuery: function() {
                throw errors.Error("E4010")
            },
            clearRawDataCache: function() {
                delete this.__rawData
            },
            _totalCountImpl: function(options) {
                var d = new Deferred;
                if ("raw" === this._loadMode && !this._totalCountFunc) {
                    runRawLoadWithQuery(d, this, options, true)
                } else {
                    invokeUserTotalCountFunc(this, options).done(function(count) {
                        d.resolve(Number(count))
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _pushImpl: function(changes) {
                if (this.__rawData) {
                    arrayUtils.applyBatch(this, this.__rawData, changes)
                }
            },
            _loadImpl: function(options) {
                var d = new Deferred;
                if ("raw" === this._loadMode) {
                    runRawLoadWithQuery(d, this, options, false)
                } else {
                    invokeUserLoad(this, options).done(function(data, extra) {
                        d.resolve(data, extra)
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _byKeyImpl: function(key, extraOptions) {
                var d = new Deferred;
                if (this._byKeyViaLoad()) {
                    this._requireKey();
                    runRawLoadWithKey(d, this, key)
                } else {
                    invokeUserByKeyFunc(this, key, extraOptions).done(function(obj) {
                        d.resolve(obj)
                    }).fail(createUserFuncFailureHandler(d))
                }
                return d.promise()
            },
            _byKeyViaLoad: function() {
                return "raw" === this._loadMode && !this._byKeyFunc
            },
            _insertImpl: function(values) {
                var userResult, that = this,
                    userFunc = that._insertFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(INSERT, userFunc);
                userResult = userFunc.apply(that, [values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }
                fromPromise(userResult).done(function(serverResponse) {
                    if (config().useLegacyStoreResult) {
                        d.resolve(values, serverResponse)
                    } else {
                        d.resolve(serverResponse || values, that.keyOf(serverResponse))
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _updateImpl: function(key, values) {
                var userResult, userFunc = this._updateFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(UPDATE, userFunc);
                userResult = userFunc.apply(this, [key, values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }
                fromPromise(userResult).done(function(serverResponse) {
                    if (config().useLegacyStoreResult) {
                        d.resolve(key, values)
                    } else {
                        d.resolve(serverResponse || values, key)
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _removeImpl: function(key) {
                var userResult, userFunc = this._removeFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(REMOVE, userFunc);
                userResult = userFunc.apply(this, [key]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise()
                }
                fromPromise(userResult).done(function() {
                    d.resolve(key)
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            }
        });
        module.exports = CustomStore
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/swatch_container.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var viewPortUtils = __webpack_require__( /*! ../../core/utils/view_port */ 76);
        var SWATCH_CONTAINER_CLASS_PREFIX = "dx-swatch-";
        var getSwatchContainer = function(element) {
            var $element = $(element);
            var swatchContainer = $element.closest('[class^="' + SWATCH_CONTAINER_CLASS_PREFIX + '"], [class*=" ' + SWATCH_CONTAINER_CLASS_PREFIX + '"]');
            var viewport = viewPortUtils.value();
            if (!swatchContainer.length) {
                return viewport
            }
            var swatchClassRegex = new RegExp("(\\s|^)(" + SWATCH_CONTAINER_CLASS_PREFIX + ".*?)(\\s|$)");
            var swatchClass = swatchContainer[0].className.match(swatchClassRegex)[2];
            var viewportSwatchContainer = viewport.children("." + swatchClass);
            if (!viewportSwatchContainer.length) {
                viewportSwatchContainer = $("<div>").addClass(swatchClass).appendTo(viewport)
            }
            return viewportSwatchContainer
        };
        module.exports = {
            getSwatchContainer: getSwatchContainer
        }
    }, ,
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/localization/currency.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            numberLocalization = __webpack_require__( /*! ./number */ 51);
        numberLocalization.inject({
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    var result = this.format(value, extend({}, formatConfig, {
                            type: "fixedpoint"
                        })),
                        currencyPart = this.getCurrencySymbol().symbol.replace("$", "$$$$");
                    result = result.replace(/^(\D*)(\d.*)/, "$1" + currencyPart + "$2");
                    return result
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        })
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator_callbacks.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 177);
        module.exports = new MemorizedCallbacks
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/pointer/base.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 27),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 11),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var POINTER_EVENTS_NAMESPACE = "dxPointerEvents";
        var BaseStrategy = Class.inherit({
            ctor: function(eventName, originalEvents) {
                this._eventName = eventName;
                this._originalEvents = eventUtils.addNamespace(originalEvents, POINTER_EVENTS_NAMESPACE);
                this._handlerCount = 0;
                this.noBubble = this._isNoBubble()
            },
            _isNoBubble: function() {
                var eventName = this._eventName;
                return "dxpointerenter" === eventName || "dxpointerleave" === eventName
            },
            _handler: function(e) {
                var delegateTarget = this._getDelegateTarget(e);
                return this._fireEvent({
                    type: this._eventName,
                    pointerType: e.pointerType || eventUtils.eventSource(e),
                    originalEvent: e,
                    delegateTarget: delegateTarget,
                    timeStamp: browser.mozilla ? (new Date).getTime() : e.timeStamp
                })
            },
            _getDelegateTarget: function(e) {
                var delegateTarget;
                if (this.noBubble) {
                    delegateTarget = e.delegateTarget
                }
                return delegateTarget
            },
            _fireEvent: function(args) {
                return eventUtils.fireEvent(args)
            },
            _setSelector: function(handleObj) {
                this._selector = this.noBubble && handleObj ? handleObj.selector : null
            },
            _getSelector: function() {
                return this._selector
            },
            setup: function() {
                return true
            },
            add: function(element, handleObj) {
                if (this._handlerCount <= 0 || this.noBubble) {
                    element = this.noBubble ? element : domAdapter.getDocument();
                    this._setSelector(handleObj);
                    var that = this;
                    eventsEngine.on(element, this._originalEvents, this._getSelector(), function(e) {
                        that._handler(e)
                    })
                }
                if (!this.noBubble) {
                    this._handlerCount++
                }
            },
            remove: function(handleObj) {
                this._setSelector(handleObj);
                if (!this.noBubble) {
                    this._handlerCount--
                }
            },
            teardown: function(element) {
                if (this._handlerCount && !this.noBubble) {
                    return
                }
                element = this.noBubble ? element : domAdapter.getDocument();
                if (this._originalEvents !== "." + POINTER_EVENTS_NAMESPACE) {
                    eventsEngine.off(element, this._originalEvents, this._getSelector())
                }
            },
            dispose: function(element) {
                element = this.noBubble ? element : domAdapter.getDocument();
                eventsEngine.off(element, this._originalEvents)
            }
        });
        module.exports = BaseStrategy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_query.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 15),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 20).compileGetter,
            toComparable = __webpack_require__( /*! ../core/utils/data */ 20).toComparable,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            errorsModule = __webpack_require__( /*! ./errors */ 36),
            dataUtils = __webpack_require__( /*! ./utils */ 40);
        var Iterator = Class.inherit({
            toArray: function() {
                var result = [];
                this.reset();
                while (this.next()) {
                    result.push(this.current())
                }
                return result
            },
            countable: function() {
                return false
            }
        });
        var ArrayIterator = Iterator.inherit({
            ctor: function(array) {
                this.array = array;
                this.index = -1
            },
            next: function() {
                if (this.index + 1 < this.array.length) {
                    this.index++;
                    return true
                }
                return false
            },
            current: function() {
                return this.array[this.index]
            },
            reset: function() {
                this.index = -1
            },
            toArray: function() {
                return this.array.slice(0)
            },
            countable: function() {
                return true
            },
            count: function() {
                return this.array.length
            }
        });
        var WrappedIterator = Iterator.inherit({
            ctor: function(iter) {
                this.iter = iter
            },
            next: function() {
                return this.iter.next()
            },
            current: function() {
                return this.iter.current()
            },
            reset: function() {
                return this.iter.reset()
            }
        });
        var MapIterator = WrappedIterator.inherit({
            ctor: function(iter, mapper) {
                this.callBase(iter);
                this.index = -1;
                this.mapper = mapper
            },
            current: function() {
                return this.mapper(this.callBase(), this.index)
            },
            next: function() {
                var hasNext = this.callBase();
                if (hasNext) {
                    this.index++
                }
                return hasNext
            }
        });
        var defaultCompare = function(xValue, yValue) {
            xValue = toComparable(xValue);
            yValue = toComparable(yValue);
            if (null === xValue && null !== yValue) {
                return -1
            }
            if (null !== xValue && null === yValue) {
                return 1
            }
            if (void 0 === xValue && void 0 !== yValue) {
                return 1
            }
            if (void 0 !== xValue && void 0 === yValue) {
                return -1
            }
            if (xValue < yValue) {
                return -1
            }
            if (xValue > yValue) {
                return 1
            }
            return 0
        };
        var SortIterator = Iterator.inherit({
            ctor: function(iter, getter, desc, compare) {
                if (!(iter instanceof MapIterator)) {
                    iter = new MapIterator(iter, this._wrap)
                }
                this.iter = iter;
                this.rules = [{
                    getter: getter,
                    desc: desc,
                    compare: compare
                }]
            },
            thenBy: function(getter, desc, compare) {
                var result = new SortIterator(this.sortedIter || this.iter, getter, desc, compare);
                if (!this.sortedIter) {
                    result.rules = this.rules.concat(result.rules)
                }
                return result
            },
            next: function() {
                this._ensureSorted();
                return this.sortedIter.next()
            },
            current: function() {
                this._ensureSorted();
                return this.sortedIter.current()
            },
            reset: function() {
                delete this.sortedIter
            },
            countable: function() {
                return this.sortedIter || this.iter.countable()
            },
            count: function() {
                if (this.sortedIter) {
                    return this.sortedIter.count()
                }
                return this.iter.count()
            },
            _ensureSorted: function() {
                var that = this;
                if (that.sortedIter) {
                    return
                }
                iteratorUtils.each(that.rules, function() {
                    this.getter = compileGetter(this.getter)
                });
                that.sortedIter = new MapIterator(new ArrayIterator(this.iter.toArray().sort(function(x, y) {
                    return that._compare(x, y)
                })), that._unwrap)
            },
            _wrap: function(record, index) {
                return {
                    index: index,
                    value: record
                }
            },
            _unwrap: function(wrappedItem) {
                return wrappedItem.value
            },
            _compare: function(x, y) {
                var xIndex = x.index,
                    yIndex = y.index;
                x = x.value;
                y = y.value;
                if (x === y) {
                    return xIndex - yIndex
                }
                for (var i = 0, rulesCount = this.rules.length; i < rulesCount; i++) {
                    var rule = this.rules[i],
                        xValue = rule.getter(x),
                        yValue = rule.getter(y),
                        compare = rule.compare || defaultCompare,
                        compareResult = compare(xValue, yValue);
                    if (compareResult) {
                        return rule.desc ? -compareResult : compareResult
                    }
                }
                return xIndex - yIndex
            }
        });
        var compileCriteria = function() {
            var compileGroup = function(crit) {
                var ops = [];
                var isConjunctiveOperator = false;
                var isConjunctiveNextOperator = false;
                iteratorUtils.each(crit, function() {
                    if (Array.isArray(this) || typeUtils.isFunction(this)) {
                        if (ops.length > 1 && isConjunctiveOperator !== isConjunctiveNextOperator) {
                            throw new errorsModule.errors.Error("E4019")
                        }
                        ops.push(compileCriteria(this));
                        isConjunctiveOperator = isConjunctiveNextOperator;
                        isConjunctiveNextOperator = true
                    } else {
                        isConjunctiveNextOperator = dataUtils.isConjunctiveOperator(this)
                    }
                });
                return function(d) {
                    var result = isConjunctiveOperator;
                    for (var i = 0; i < ops.length; i++) {
                        if (ops[i](d) !== isConjunctiveOperator) {
                            result = !isConjunctiveOperator;
                            break
                        }
                    }
                    return result
                }
            };
            var toString = function(value) {
                return typeUtils.isDefined(value) ? value.toString() : ""
            };
            var compileBinary = function(crit) {
                crit = dataUtils.normalizeBinaryCriterion(crit);
                var getter = compileGetter(crit[0]),
                    op = crit[1],
                    value = crit[2];
                value = toComparable(value);
                switch (op.toLowerCase()) {
                    case "=":
                        return compileEquals(getter, value);
                    case "<>":
                        return compileEquals(getter, value, true);
                    case ">":
                        return function(obj) {
                            return toComparable(getter(obj)) > value
                        };
                    case "<":
                        return function(obj) {
                            return toComparable(getter(obj)) < value
                        };
                    case ">=":
                        return function(obj) {
                            return toComparable(getter(obj)) >= value
                        };
                    case "<=":
                        return function(obj) {
                            return toComparable(getter(obj)) <= value
                        };
                    case "startswith":
                        return function(obj) {
                            return 0 === toComparable(toString(getter(obj))).indexOf(value)
                        };
                    case "endswith":
                        return function(obj) {
                            var getterValue = toComparable(toString(getter(obj))),
                                searchValue = toString(value);
                            if (getterValue.length < searchValue.length) {
                                return false
                            }
                            return getterValue.lastIndexOf(value) === getterValue.length - value.length
                        };
                    case "contains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) > -1
                        };
                    case "notcontains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) === -1
                        }
                }
                throw errorsModule.errors.Error("E4003", op)
            };

            function compileEquals(getter, value, negate) {
                return function(obj) {
                    obj = toComparable(getter(obj));
                    var result = useStrictComparison(value) ? obj === value : obj == value;
                    if (negate) {
                        result = !result
                    }
                    return result
                }
            }

            function useStrictComparison(value) {
                return "" === value || 0 === value || false === value
            }

            function compileUnary(crit) {
                var op = crit[0],
                    criteria = compileCriteria(crit[1]);
                if ("!" === op) {
                    return function(obj) {
                        return !criteria(obj)
                    }
                }
                throw errorsModule.errors.Error("E4003", op)
            }
            return function(crit) {
                if (typeUtils.isFunction(crit)) {
                    return crit
                }
                if (dataUtils.isGroupCriterion(crit)) {
                    return compileGroup(crit)
                }
                if (dataUtils.isUnaryOperation(crit)) {
                    return compileUnary(crit)
                }
                return compileBinary(crit)
            }
        }();
        var FilterIterator = WrappedIterator.inherit({
            ctor: function(iter, criteria) {
                this.callBase(iter);
                this.criteria = compileCriteria(criteria)
            },
            next: function() {
                while (this.iter.next()) {
                    if (this.criteria(this.current())) {
                        return true
                    }
                }
                return false
            }
        });
        var GroupIterator = Iterator.inherit({
            ctor: function(iter, getter) {
                this.iter = iter;
                this.getter = getter
            },
            next: function() {
                this._ensureGrouped();
                return this.groupedIter.next()
            },
            current: function() {
                this._ensureGrouped();
                return this.groupedIter.current()
            },
            reset: function() {
                delete this.groupedIter
            },
            countable: function() {
                return !!this.groupedIter
            },
            count: function() {
                return this.groupedIter.count()
            },
            _ensureGrouped: function() {
                if (this.groupedIter) {
                    return
                }
                var hash = {},
                    keys = [],
                    iter = this.iter,
                    getter = compileGetter(this.getter);
                iter.reset();
                while (iter.next()) {
                    var current = iter.current(),
                        key = getter(current);
                    if (key in hash) {
                        hash[key].push(current)
                    } else {
                        hash[key] = [current];
                        keys.push(key)
                    }
                }
                this.groupedIter = new ArrayIterator(iteratorUtils.map(keys, function(key) {
                    return {
                        key: key,
                        items: hash[key]
                    }
                }))
            }
        });
        var SelectIterator = WrappedIterator.inherit({
            ctor: function(iter, getter) {
                this.callBase(iter);
                this.getter = compileGetter(getter)
            },
            current: function() {
                return this.getter(this.callBase())
            },
            countable: function() {
                return this.iter.countable()
            },
            count: function() {
                return this.iter.count()
            }
        });
        var SliceIterator = WrappedIterator.inherit({
            ctor: function(iter, skip, take) {
                this.callBase(iter);
                this.skip = Math.max(0, skip);
                this.take = Math.max(0, take);
                this.pos = 0
            },
            next: function() {
                if (this.pos >= this.skip + this.take) {
                    return false
                }
                while (this.pos < this.skip && this.iter.next()) {
                    this.pos++
                }
                this.pos++;
                return this.iter.next()
            },
            reset: function() {
                this.callBase();
                this.pos = 0
            },
            countable: function() {
                return this.iter.countable()
            },
            count: function() {
                return Math.min(this.iter.count() - this.skip, this.take)
            }
        });
        var arrayQueryImpl = function arrayQueryImpl(iter, queryOptions) {
            queryOptions = queryOptions || {};
            if (!(iter instanceof Iterator)) {
                iter = new ArrayIterator(iter)
            }
            var handleError = function(error) {
                var handler = queryOptions.errorHandler;
                if (handler) {
                    handler(error)
                }
                errorsModule._errorHandler(error)
            };
            var aggregateCore = function(aggregator) {
                var seed, d = (new Deferred).fail(handleError),
                    step = aggregator.step,
                    finalize = aggregator.finalize;
                try {
                    iter.reset();
                    if ("seed" in aggregator) {
                        seed = aggregator.seed
                    } else {
                        seed = iter.next() ? iter.current() : NaN
                    }
                    var accumulator = seed;
                    while (iter.next()) {
                        accumulator = step(accumulator, iter.current())
                    }
                    d.resolve(finalize ? finalize(accumulator) : accumulator)
                } catch (x) {
                    d.reject(x)
                }
                return d.promise()
            };
            var aggregate = function(seed, step, finalize) {
                if (arguments.length < 2) {
                    return aggregateCore({
                        step: arguments[0]
                    })
                }
                return aggregateCore({
                    seed: seed,
                    step: step,
                    finalize: finalize
                })
            };
            var standardAggregate = function(name) {
                return aggregateCore(dataUtils.aggregators[name])
            };
            var select = function(getter) {
                if (!typeUtils.isFunction(getter) && !Array.isArray(getter)) {
                    getter = [].slice.call(arguments)
                }
                return chainQuery(new SelectIterator(iter, getter))
            };
            var selectProp = function(name) {
                return select(compileGetter(name))
            };
            var chainQuery = function(iter) {
                return arrayQueryImpl(iter, queryOptions)
            };
            return {
                toArray: function() {
                    return iter.toArray()
                },
                enumerate: function() {
                    var d = (new Deferred).fail(handleError);
                    try {
                        d.resolve(iter.toArray())
                    } catch (x) {
                        d.reject(x)
                    }
                    return d.promise()
                },
                sortBy: function(getter, desc, compare) {
                    return chainQuery(new SortIterator(iter, getter, desc, compare))
                },
                thenBy: function(getter, desc, compare) {
                    if (iter instanceof SortIterator) {
                        return chainQuery(iter.thenBy(getter, desc, compare))
                    }
                    throw errorsModule.errors.Error("E4004")
                },
                filter: function(criteria) {
                    if (!Array.isArray(criteria)) {
                        criteria = [].slice.call(arguments)
                    }
                    return chainQuery(new FilterIterator(iter, criteria))
                },
                slice: function(skip, take) {
                    if (void 0 === take) {
                        take = Number.MAX_VALUE
                    }
                    return chainQuery(new SliceIterator(iter, skip, take))
                },
                select: select,
                groupBy: function(getter) {
                    return chainQuery(new GroupIterator(iter, getter))
                },
                aggregate: aggregate,
                count: function() {
                    if (iter.countable()) {
                        var d = (new Deferred).fail(handleError);
                        try {
                            d.resolve(iter.count())
                        } catch (x) {
                            d.reject(x)
                        }
                        return d.promise()
                    }
                    return standardAggregate("count")
                },
                sum: function(getter) {
                    if (getter) {
                        return selectProp(getter).sum()
                    }
                    return standardAggregate("sum")
                },
                min: function(getter) {
                    if (getter) {
                        return selectProp(getter).min()
                    }
                    return standardAggregate("min")
                },
                max: function(getter) {
                    if (getter) {
                        return selectProp(getter).max()
                    }
                    return standardAggregate("max")
                },
                avg: function(getter) {
                    if (getter) {
                        return selectProp(getter).avg()
                    }
                    return standardAggregate("avg")
                }
            }
        };
        module.exports = arrayQueryImpl
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled/data/odata/query_adapter.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            config = __webpack_require__( /*! ../../core/config */ 31),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            queryAdapters = __webpack_require__( /*! ../query_adapters */ 180),
            odataUtils = __webpack_require__( /*! ./utils */ 110),
            serializePropName = odataUtils.serializePropName,
            errors = __webpack_require__( /*! ../errors */ 36).errors,
            dataUtils = __webpack_require__( /*! ../utils */ 40),
            isFunction = typeUtils.isFunction;
        var DEFAULT_PROTOCOL_VERSION = 2;
        var compileCriteria = function() {
            var protocolVersion, forceLowerCase, fieldTypes;
            var createBinaryOperationFormatter = function(op) {
                return function(prop, val) {
                    return prop + " " + op + " " + val
                }
            };
            var createStringFuncFormatter = function(op, reverse) {
                return function(prop, val) {
                    var bag = [op, "("];
                    if (forceLowerCase) {
                        prop = prop.indexOf("tolower(") === -1 ? "tolower(" + prop + ")" : prop;
                        val = val.toLowerCase()
                    }
                    if (reverse) {
                        bag.push(val, ",", prop)
                    } else {
                        bag.push(prop, ",", val)
                    }
                    bag.push(")");
                    return bag.join("")
                }
            };
            var formatters = {
                "=": createBinaryOperationFormatter("eq"),
                "<>": createBinaryOperationFormatter("ne"),
                ">": createBinaryOperationFormatter("gt"),
                ">=": createBinaryOperationFormatter("ge"),
                "<": createBinaryOperationFormatter("lt"),
                "<=": createBinaryOperationFormatter("le"),
                startswith: createStringFuncFormatter("startswith"),
                endswith: createStringFuncFormatter("endswith")
            };
            var formattersV2 = extend({}, formatters, {
                contains: createStringFuncFormatter("substringof", true),
                notcontains: createStringFuncFormatter("not substringof", true)
            });
            var formattersV4 = extend({}, formatters, {
                contains: createStringFuncFormatter("contains"),
                notcontains: createStringFuncFormatter("not contains")
            });
            var compileBinary = function(criteria) {
                criteria = dataUtils.normalizeBinaryCriterion(criteria);
                var op = criteria[1],
                    formatters = 4 === protocolVersion ? formattersV4 : formattersV2,
                    formatter = formatters[op.toLowerCase()];
                if (!formatter) {
                    throw errors.Error("E4003", op)
                }
                var fieldName = criteria[0],
                    value = criteria[2];
                if (fieldTypes && fieldTypes[fieldName]) {
                    value = odataUtils.convertPrimitiveValue(fieldTypes[fieldName], value)
                }
                return formatter(serializePropName(fieldName), odataUtils.serializeValue(value, protocolVersion))
            };
            var compileUnary = function(criteria) {
                var op = criteria[0],
                    crit = compileCore(criteria[1]);
                if ("!" === op) {
                    return "not (" + crit + ")"
                }
                throw errors.Error("E4003", op)
            };
            var compileGroup = function(criteria) {
                var groupOperator, nextGroupOperator, bag = [];
                iteratorUtils.each(criteria, function(index, criterion) {
                    if (Array.isArray(criterion)) {
                        if (bag.length > 1 && groupOperator !== nextGroupOperator) {
                            throw new errors.Error("E4019")
                        }
                        bag.push("(" + compileCore(criterion) + ")");
                        groupOperator = nextGroupOperator;
                        nextGroupOperator = "and"
                    } else {
                        nextGroupOperator = dataUtils.isConjunctiveOperator(this) ? "and" : "or"
                    }
                });
                return bag.join(" " + groupOperator + " ")
            };
            var compileCore = function(criteria) {
                if (Array.isArray(criteria[0])) {
                    return compileGroup(criteria)
                }
                if (dataUtils.isUnaryOperation(criteria)) {
                    return compileUnary(criteria)
                }
                return compileBinary(criteria)
            };
            return function(criteria, version, types, filterToLower) {
                fieldTypes = types;
                forceLowerCase = typeUtils.isDefined(filterToLower) ? filterToLower : config().oDataFilterToLower;
                protocolVersion = version;
                return compileCore(criteria)
            }
        }();
        var createODataQueryAdapter = function(queryOptions) {
            var _select, _skip, _take, _countQuery, _sorting = [],
                _criteria = [],
                _expand = queryOptions.expand,
                _oDataVersion = queryOptions.version || DEFAULT_PROTOCOL_VERSION;
            var hasSlice = function() {
                return _skip || void 0 !== _take
            };
            var hasFunction = function hasFunction(criterion) {
                for (var i = 0; i < criterion.length; i++) {
                    if (isFunction(criterion[i])) {
                        return true
                    }
                    if (Array.isArray(criterion[i]) && hasFunction(criterion[i])) {
                        return true
                    }
                }
                return false
            };
            var requestData = function() {
                var result = {};
                if (!_countQuery) {
                    if (_sorting.length) {
                        result.$orderby = _sorting.join(",")
                    }
                    if (_skip) {
                        result.$skip = _skip
                    }
                    if (void 0 !== _take) {
                        result.$top = _take
                    }
                    result.$select = odataUtils.generateSelect(_oDataVersion, _select) || void 0;
                    result.$expand = odataUtils.generateExpand(_oDataVersion, _expand, _select) || void 0
                }
                if (_criteria.length) {
                    var criteria = _criteria.length < 2 ? _criteria[0] : _criteria,
                        fieldTypes = queryOptions && queryOptions.fieldTypes,
                        filterToLower = queryOptions && queryOptions.filterToLower;
                    result.$filter = compileCriteria(criteria, _oDataVersion, fieldTypes, filterToLower)
                }
                if (_countQuery) {
                    result.$top = 0
                }
                if (queryOptions.requireTotalCount || _countQuery) {
                    if (4 !== _oDataVersion) {
                        result.$inlinecount = "allpages"
                    } else {
                        result.$count = "true"
                    }
                }
                return result
            };

            function tryLiftSelect(tasks) {
                var selectIndex = -1;
                for (var i = 0; i < tasks.length; i++) {
                    if ("select" === tasks[i].name) {
                        selectIndex = i;
                        break
                    }
                }
                if (selectIndex < 0 || !isFunction(tasks[selectIndex].args[0])) {
                    return
                }
                var nextTask = tasks[1 + selectIndex];
                if (!nextTask || "slice" !== nextTask.name) {
                    return
                }
                tasks[1 + selectIndex] = tasks[selectIndex];
                tasks[selectIndex] = nextTask
            }
            return {
                optimize: function(tasks) {
                    tryLiftSelect(tasks)
                },
                exec: function(url) {
                    return odataUtils.sendRequest(_oDataVersion, {
                        url: url,
                        params: extend(requestData(), queryOptions && queryOptions.params)
                    }, {
                        beforeSend: queryOptions.beforeSend,
                        jsonp: queryOptions.jsonp,
                        withCredentials: queryOptions.withCredentials,
                        countOnly: _countQuery,
                        deserializeDates: queryOptions.deserializeDates,
                        fieldTypes: queryOptions.fieldTypes,
                        isPaged: isFinite(_take)
                    })
                },
                multiSort: function(args) {
                    var rules;
                    if (hasSlice()) {
                        return false
                    }
                    for (var i = 0; i < args.length; i++) {
                        var rule, getter = args[i][0],
                            desc = !!args[i][1];
                        if ("string" !== typeof getter) {
                            return false
                        }
                        rule = serializePropName(getter);
                        if (desc) {
                            rule += " desc"
                        }
                        rules = rules || [];
                        rules.push(rule)
                    }
                    _sorting = rules
                },
                slice: function(skipCount, takeCount) {
                    if (hasSlice()) {
                        return false
                    }
                    _skip = skipCount;
                    _take = takeCount
                },
                filter: function(criterion) {
                    if (hasSlice()) {
                        return false
                    }
                    if (!Array.isArray(criterion)) {
                        criterion = [].slice.call(arguments)
                    }
                    if (hasFunction(criterion)) {
                        return false
                    }
                    if (_criteria.length) {
                        _criteria.push("and")
                    }
                    _criteria.push(criterion)
                },
                select: function(expr) {
                    if (_select || isFunction(expr)) {
                        return false
                    }
                    if (!Array.isArray(expr)) {
                        expr = [].slice.call(arguments)
                    }
                    _select = expr
                },
                count: function() {
                    _countQuery = true
                }
            }
        };
        queryAdapters.odata = createODataQueryAdapter;
        exports.odata = createODataQueryAdapter
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/version.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = "19.1.6"
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/events/gesture/emitter.gesture.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            styleUtils = __webpack_require__( /*! ../../core/utils/style */ 85),
            callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 63),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 12),
            readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 48),
            ready = readyCallbacks.add,
            mathUtils = __webpack_require__( /*! ../../core/utils/math */ 28),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            isDefined = __webpack_require__( /*! ../../core/utils/type */ 1).isDefined,
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            Emitter = __webpack_require__( /*! ../core/emitter */ 123),
            sign = mathUtils.sign,
            abs = Math.abs;
        var SLEEP = 0,
            INITED = 1,
            STARTED = 2,
            TOUCH_BOUNDARY = 10,
            IMMEDIATE_TOUCH_BOUNDARY = 0,
            IMMEDIATE_TIMEOUT = 180;
        var supportPointerEvents = function() {
            return styleUtils.styleProp("pointer-events")
        };
        var setGestureCover = callOnce(function() {
            var GESTURE_COVER_CLASS = "dx-gesture-cover";
            var isDesktop = "generic" === devices.real().platform;
            if (!supportPointerEvents() || !isDesktop) {
                return noop
            }
            var $cover = $("<div>").addClass(GESTURE_COVER_CLASS).css("pointerEvents", "none");
            eventsEngine.subscribeGlobal($cover, "dxmousewheel", function(e) {
                e.preventDefault()
            });
            ready(function() {
                $cover.appendTo("body")
            });
            return function(toggle, cursor) {
                $cover.css("pointerEvents", toggle ? "all" : "none");
                toggle && $cover.css("cursor", cursor)
            }
        });
        var gestureCover = function(toggle, cursor) {
            var gestureCoverStrategy = setGestureCover();
            gestureCoverStrategy(toggle, cursor)
        };
        var GestureEmitter = Emitter.inherit({
            gesture: true,
            configure: function(data) {
                this.getElement().css("msTouchAction", data.immediate ? "pinch-zoom" : "");
                this.callBase(data)
            },
            allowInterruptionByMouseWheel: function() {
                return this._stage !== STARTED
            },
            getDirection: function() {
                return this.direction
            },
            _cancel: function() {
                this.callBase.apply(this, arguments);
                this._toggleGestureCover(false);
                this._stage = SLEEP
            },
            start: function(e) {
                if (e._needSkipEvent || eventUtils.needSkipEvent(e)) {
                    this._cancel(e);
                    return
                }
                this._startEvent = eventUtils.createEvent(e);
                this._startEventData = eventUtils.eventData(e);
                this._stage = INITED;
                this._init(e);
                this._setupImmediateTimer()
            },
            _setupImmediateTimer: function() {
                clearTimeout(this._immediateTimer);
                this._immediateAccepted = false;
                if (!this.immediate) {
                    return
                }
                this._immediateTimer = setTimeout(function() {
                    this._immediateAccepted = true
                }.bind(this), IMMEDIATE_TIMEOUT)
            },
            move: function(e) {
                if (this._stage === INITED && this._directionConfirmed(e)) {
                    this._stage = STARTED;
                    this._resetActiveElement();
                    this._toggleGestureCover(true);
                    this._clearSelection(e);
                    this._adjustStartEvent(e);
                    this._start(this._startEvent);
                    if (this._stage === SLEEP) {
                        return
                    }
                    this._requestAccept(e);
                    this._move(e);
                    this._forgetAccept()
                } else {
                    if (this._stage === STARTED) {
                        this._clearSelection(e);
                        this._move(e)
                    }
                }
            },
            _directionConfirmed: function(e) {
                var touchBoundary = this._getTouchBoundary(e),
                    delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e)),
                    deltaX = abs(delta.x),
                    deltaY = abs(delta.y);
                var horizontalMove = this._validateMove(touchBoundary, deltaX, deltaY),
                    verticalMove = this._validateMove(touchBoundary, deltaY, deltaX);
                var direction = this.getDirection(e),
                    bothAccepted = "both" === direction && (horizontalMove || verticalMove),
                    horizontalAccepted = "horizontal" === direction && horizontalMove,
                    verticalAccepted = "vertical" === direction && verticalMove;
                return bothAccepted || horizontalAccepted || verticalAccepted || this._immediateAccepted
            },
            _validateMove: function(touchBoundary, mainAxis, crossAxis) {
                return mainAxis && mainAxis >= touchBoundary && (this.immediate ? mainAxis >= crossAxis : true)
            },
            _getTouchBoundary: function(e) {
                return this.immediate || eventUtils.isDxMouseWheelEvent(e) ? IMMEDIATE_TOUCH_BOUNDARY : TOUCH_BOUNDARY
            },
            _adjustStartEvent: function(e) {
                var touchBoundary = this._getTouchBoundary(e),
                    delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                this._startEvent.pageX += sign(delta.x) * touchBoundary;
                this._startEvent.pageY += sign(delta.y) * touchBoundary
            },
            _resetActiveElement: function() {
                if ("ios" === devices.real().platform && this.getElement().find(":focus").length) {
                    domUtils.resetActiveElement()
                }
            },
            _toggleGestureCover: function(toggle) {
                var isStarted = this._stage === STARTED;
                if (isStarted) {
             