/*!
 * DevExpress Diagram (dx-diagram)
 * Version: 0.0.30
 * Build date: Tue Jul 23 2019
 * 
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExpress licensing here: https://www.devexpress.com/Support/EULAs
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["diagram"] = factory();
	else
		root["DevExpress"] = root["DevExpress"] || {}, root["DevExpress"]["diagram"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 46);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Size = /** @class */ (function () {
    function Size(width, height) {
        this.width = width;
        this.height = height;
    }
    Size.prototype.clone = function () { return new Size(this.width, this.height); };
    Size.prototype.toString = function () { return JSON.stringify(this); };
    Size.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new Size(Math.max(0, this.width + offsetX), Math.max(0, this.height + offsetY));
    };
    Size.prototype.multiply = function (multiplierW, multiplierH) {
        if (multiplierW === void 0) { multiplierW = 1; }
        if (multiplierH === void 0) { multiplierH = multiplierW; }
        return new Size(this.width * multiplierW, this.height * multiplierH);
    };
    Size.prototype.equals = function (size) {
        return size.width === this.width && size.height === this.height;
    };
    return Size;
}());
exports.Size = Size;
var Point = /** @class */ (function () {
    function Point(x, y) {
        this.x = x;
        this.y = y;
    }
    Point.prototype.clone = function () { return new Point(this.x, this.y); };
    Point.prototype.toString = function () { return JSON.stringify(this); };
    Point.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new Point(this.x + offsetX, this.y + offsetY);
    };
    Point.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new Point(this.x * multiplierX, this.y * multiplierY);
    };
    Point.prototype.equals = function (pt) {
        return pt.x === this.x && pt.y === this.y;
    };
    Point.empty = function () {
        return new Point(-1, -1);
    };
    Point.plus = function (a, b) {
        return new Point(a.x + b.x, a.y + b.y);
    };
    Point.minus = function (a, b) {
        return new Point(a.x - b.x, a.y - b.y);
    };
    return Point;
}());
exports.Point = Point;
var Offset = /** @class */ (function () {
    function Offset(left, top, right, bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }
    Offset.prototype.clone = function () { return new Offset(this.left, this.top, this.right, this.bottom); };
    return Offset;
}());
exports.Offset = Offset;
var Rectangle = /** @class */ (function () {
    function Rectangle(position, size) {
        this.position = position;
        this.size = size;
    }
    Object.defineProperty(Rectangle.prototype, "left", {
        get: function () {
            return this.position.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "top", {
        get: function () {
            return this.position.y;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "right", {
        get: function () {
            return this.position.x + this.size.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "bottom", {
        get: function () {
            return this.position.y + this.size.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "center", {
        get: function () {
            return new Point(this.position.x + this.size.width / 2, this.position.y + this.size.height / 2);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "width", {
        get: function () {
            return this.size.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "height", {
        get: function () {
            return this.size.height;
        },
        enumerable: true,
        configurable: true
    });
    Rectangle.prototype.clone = function () { return new Rectangle(this.position.clone(), this.size.clone()); };
    Rectangle.prototype.toString = function () { return JSON.stringify(this); };
    Rectangle.prototype.contains = function (point) {
        return this.left <= point.x && point.x <= this.right &&
            this.top <= point.y && point.y <= this.bottom;
    };
    Rectangle.prototype.intersectX = function (rect) {
        if (this.left > rect.right || rect.left > this.right)
            return false;
        return true;
    };
    Rectangle.prototype.intersectY = function (rect) {
        if (this.top > rect.bottom || rect.top > this.bottom)
            return false;
        return true;
    };
    Rectangle.prototype.intersect = function (rect) {
        return this.intersectX(rect) && this.intersectY(rect);
    };
    Rectangle.prototype.inflate = function (deltaX, deltaY) {
        deltaY = deltaY === undefined ? deltaX : deltaY;
        return new Rectangle(this.position.offset(-deltaX, -deltaY), this.size.offset(2 * deltaX, 2 * deltaY));
    };
    Rectangle.prototype.resize = function (deltaX, deltaY) {
        return new Rectangle(this.position, this.size.offset(deltaX, deltaY));
    };
    Rectangle.prototype.offset = function (offsetX, offsetY) {
        return new Rectangle(this.position.offset(offsetX, offsetY), this.size);
    };
    Rectangle.prototype.multiply = function (multiplier) {
        return new Rectangle(this.position.multiply(multiplier), this.size.multiply(multiplier));
    };
    Rectangle.create = function (x, y, width, height) {
        return new Rectangle(new Point(x, y), new Size(width, height));
    };
    Rectangle.createByPoints = function (point1, point2) {
        return Rectangle.createByPositions(point1.x, point1.y, point2.x, point2.y);
    };
    Rectangle.createByPositions = function (x1, y1, x2, y2) {
        var x = Math.min(x1, x2);
        var y = Math.min(y1, y2);
        var width = Math.abs(x2 - x1);
        var height = Math.abs(y2 - y1);
        return Rectangle.create(x, y, width, height);
    };
    return Rectangle;
}());
exports.Rectangle = Rectangle;
var Segment = /** @class */ (function () {
    function Segment(startPoint, endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }
    Object.defineProperty(Segment.prototype, "distance", {
        get: function () {
            return GeometryUtils.getDistance(this.startPoint, this.endPoint);
        },
        enumerable: true,
        configurable: true
    });
    Segment.prototype.intersect = function (segment) {
        if (this.startPoint.equals(segment.startPoint) || this.endPoint.equals(segment.startPoint) ||
            this.startPoint.equals(segment.endPoint) || this.endPoint.equals(segment.endPoint))
            return true;
        return this.intersectCore(segment) && segment.intersectCore(this);
    };
    Segment.prototype.intersectRect = function (rectangle) {
        var ltPt = rectangle.position, lbPt = new Point(rectangle.left, rectangle.bottom), rtPt = new Point(rectangle.right, rectangle.top), rbPt = new Point(rectangle.right, rectangle.bottom);
        return rectangle.contains(this.startPoint) || rectangle.contains(this.endPoint) ||
            this.intersect(new Segment(ltPt, lbPt)) || this.intersect(new Segment(lbPt, rbPt)) ||
            this.intersect(new Segment(rbPt, rtPt)) || this.intersect(new Segment(rtPt, ltPt));
    };
    Segment.prototype.intersectCore = function (segment) {
        if (this.startPoint.x === this.endPoint.x) {
            if (this.startPoint.x - segment.endPoint.x !== 0)
                return (this.startPoint.x - segment.startPoint.x) / (this.startPoint.x - segment.endPoint.x) <= 0;
            if (segment.endPoint.y - this.endPoint.y !== 0)
                return (segment.endPoint.y - this.startPoint.y) / (segment.endPoint.y - this.endPoint.y) <= 0;
        }
        if (this.startPoint.y === this.endPoint.y) {
            if (this.startPoint.y - segment.endPoint.y !== 0)
                return (this.startPoint.y - segment.startPoint.y) / (this.startPoint.y - segment.endPoint.y) <= 0;
            if (segment.endPoint.x - this.endPoint.x !== 0)
                return (segment.endPoint.x - this.startPoint.x) / (segment.endPoint.x - this.endPoint.x) <= 0;
        }
        var tg = (this.endPoint.y - this.startPoint.y) / (this.endPoint.x - this.startPoint.x);
        var y1 = this.startPoint.y + (segment.startPoint.x - this.startPoint.x) * tg;
        var y2 = this.startPoint.y + (segment.endPoint.x - this.startPoint.x) * tg;
        var dy1 = segment.startPoint.y - y1;
        var dy2 = segment.endPoint.y - y2;
        if (dy1 === 0 && dy2 === 0) {
            return (this.startPoint.y - y1) / (this.endPoint.y - y1) <= 0 ||
                (this.startPoint.y - y2) / (this.endPoint.y - y2) <= 0;
        }
        return dy1 === 0 || dy2 === 0 || dy1 / dy2 < 0;
    };
    Segment.create = function (x1, y1, x2, y2) {
        return new Segment(new Point(x1, y1), new Point(x2, y2));
    };
    Segment.createByPoints = function (point1, point2) {
        return Segment.create(point1.x, point1.y, point2.x, point2.y);
    };
    return Segment;
}());
exports.Segment = Segment;
var EventDispatcher = /** @class */ (function () {
    function EventDispatcher() {
        this.listeners = [];
    }
    EventDispatcher.prototype.add = function (listener) {
        if (!listener)
            throw new Error("Not Implemented");
        if (!this.hasEventListener(listener))
            this.listeners.push(listener);
    };
    EventDispatcher.prototype.remove = function (listener) {
        for (var i = 0, currentListener; currentListener = this.listeners[i]; i++) {
            if (currentListener === listener) {
                this.listeners.splice(i, 1);
                break;
            }
        }
    };
    EventDispatcher.prototype.raise = function (funcName) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        for (var i = 0, listener; listener = this.listeners[i]; i++) {
            listener[funcName].apply(listener, args);
        }
    };
    EventDispatcher.prototype.raise1 = function (action) {
        for (var i = 0, listener; listener = this.listeners[i]; i++) {
            action(listener);
        }
    };
    EventDispatcher.prototype.hasEventListener = function (listener) {
        for (var i = 0, l = this.listeners.length; i < l; i++)
            if (this.listeners[i] === listener)
                return true;
        return false;
    };
    return EventDispatcher;
}());
exports.EventDispatcher = EventDispatcher;
var Utils = /** @class */ (function () {
    function Utils() {
    }
    //http://workservices01/OpenWiki/ow.asp?ASPxRichEdit_BinarySearch#preview
    // BINARY INDEX 
    // Input array [4, 8, 10]
    // find       binaryIndexOf normedBinaryIndexOf
    // (-inf, 3]     -1            -1
    // 4              0             0
    // [5, 7]        -2             0
    // 8              1             1
    // 9             -3             1
    // 10             2             2
    // [11, +inf)    -4             2
    // case array.length == 0, then return -1
    // don't touch default value  = -2! In some case binaryIndexOf call as ([], ()=>.., 0, [].length - 1)
    Utils.binaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var findFromZeroPosition = minIndex == 0;
        if (maxIndex == -2)
            maxIndex = array.length - 1;
        while (minIndex <= maxIndex) {
            var currentIndex = (minIndex + ((maxIndex - minIndex) >> 1));
            var compare = comparer(array[currentIndex]);
            if (compare < 0)
                minIndex = currentIndex + 1;
            else if (compare > 0)
                maxIndex = currentIndex - 1;
            else
                return currentIndex;
        }
        return findFromZeroPosition ? ~minIndex : -1;
    };
    Utils.normedBinaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var index = Utils.binaryIndexOf(array, comparer, minIndex, maxIndex);
        return Utils.binaryIndexNormalizator(index);
    };
    Utils.binaryIndexNormalizator = function (index) {
        return index < 0 ? ~index - 1 : index;
    };
    return Utils;
}());
exports.Utils = Utils;
var GeometryUtils = /** @class */ (function () {
    function GeometryUtils() {
    }
    GeometryUtils.getCommonRectangle = function (rects) {
        if (!rects.length)
            return Rectangle.create(0, 0, 0, 0);
        var minX = Number.MAX_VALUE;
        var maxX = -Number.MAX_VALUE;
        var minY = Number.MAX_VALUE;
        var maxY = -Number.MAX_VALUE;
        rects.forEach(function (rect) {
            minX = Math.min(minX, rect.left);
            maxX = Math.max(maxX, rect.right);
            minY = Math.min(minY, rect.top);
            maxY = Math.max(maxY, rect.bottom);
        });
        return Rectangle.create(minX, minY, maxX - minX, maxY - minY);
    };
    GeometryUtils.findFreeSpace = function (rects, size, exact) {
        var xs = [0], xshash;
        var ys = [0];
        rects.forEach(function (r) {
            xs.push(r.left);
            xs.push(r.right);
            ys.push(r.top);
            ys.push(r.bottom);
        });
        xs = xs.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (xs[index - 1] !== v && acc.push(v) && acc) || acc; }, []); // magic for distinct
        ys = ys.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (ys[index - 1] !== v && acc.push(v) && acc) || acc; }, []);
        var matrix = ys.map(function (y) { return xs.map(function (x, i) { return xs[i + 1] - x; }); });
        var _loop_1 = function (i, rect) {
            var xi0 = Utils.binaryIndexOf(xs, function (a) { return a - rect.left; });
            var xi1 = Utils.binaryIndexOf(xs, function (a) { return a - rect.right; });
            var yi0 = Utils.binaryIndexOf(ys, function (a) { return a - rect.top; });
            var yi1 = Utils.binaryIndexOf(ys, function (a) { return a - rect.bottom; });
            for (var y = yi0; y < yi1; y++)
                for (var x = xi0; x < xi1; x++)
                    matrix[y][x] *= -1;
        };
        for (var i = 0, rect = void 0; rect = rects[i]; i++) {
            _loop_1(i, rect);
        }
        for (var yi = 0; yi < ys.length; yi++) {
            for (var xi = 0; xi < xs.length - 1; xi++) {
                var checkResult = this.checkRect(matrix, ys, xs, yi, xi, size, exact);
                if (checkResult > 0)
                    xi = checkResult;
                else if (checkResult === 0)
                    return new Point(xs[xi], ys[yi]);
            }
        }
        return null;
    };
    GeometryUtils.checkRect = function (matrix, ys, xs, yimin, ximin, size, exact) {
        var height = 0;
        var width = 0;
        var ximax = xs.length - 2;
        for (var yi = yimin; yi < ys.length; yi++) {
            height = ys[yi + 1] - ys[yimin];
            for (var xi = ximin; xi <= ximax; xi++) {
                if (matrix[yi][xi] < 0)
                    return xi === 0 ? -1 : xi; // move left?
                width = xs[xi + 1] - xs[ximin];
                if (size.width <= width || (!exact && xi === xs.length - 2 && size.width / 2 <= width)) {
                    if (size.height <= height || (!exact && yi === ys.length - 2 && size.height / 2 <= height))
                        return 0;
                    ximax = xi;
                }
            }
        }
    };
    GeometryUtils.getArrowPoints = function (point, directionPoint, arrowHeight, arrowWidth) {
        if (point.x === directionPoint.x && point.y === directionPoint.y)
            return { point1: point.clone(), point2: point.clone() };
        var catX = directionPoint.x - point.x;
        var catY = directionPoint.y - point.y;
        var hypotenuse = Math.sqrt(Math.pow(catX, 2) + Math.pow(catY, 2));
        var cos = catX / hypotenuse;
        var sin = catY / hypotenuse;
        var x1 = point.x + arrowHeight * cos + arrowWidth * sin;
        var y1 = point.y + arrowHeight * sin - arrowWidth * cos;
        var x2 = point.x + arrowHeight * cos - arrowWidth * sin;
        var y2 = point.y + arrowHeight * sin + arrowWidth * cos;
        return { point1: new Point(x1, y1), point2: new Point(x2, y2) };
    };
    GeometryUtils.removeUnnecessaryLinePoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        this.removeDuplicatedPoints(points, removeCallback, checkCallback);
        this.removeOneLinePoints(points, removeCallback, checkCallback);
        this.removeBackwardPoints(points, removeCallback, checkCallback);
    };
    GeometryUtils.removeBackwardPoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            var prevPoint = this.getNextPoint(points, index, false, checkCallback);
            if (prevPoint && nextPoint) {
                if (point.x == prevPoint.x && point.x == nextPoint.x) {
                    if ((point.y > prevPoint.y && point.y > nextPoint.y) ||
                        (point.y < prevPoint.y && point.y < nextPoint.y)) {
                        if (removeCallback(points[index], index))
                            continue;
                    }
                }
                if (point.y == prevPoint.y && point.y == nextPoint.y) {
                    if ((point.x > prevPoint.x && point.x > nextPoint.x) ||
                        (point.x < prevPoint.x && point.x < nextPoint.x)) {
                        if (removeCallback(points[index], index))
                            continue;
                    }
                }
            }
            index++;
        }
    };
    GeometryUtils.removeOneLinePoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            var prevPoint = this.getNextPoint(points, index, false, checkCallback);
            if (prevPoint && nextPoint) {
                if ((point.x == prevPoint.x && point.x == nextPoint.x) ||
                    (point.y == prevPoint.y && point.y == nextPoint.y)) {
                    if (removeCallback(points[index], index))
                        continue;
                }
                var tg = (nextPoint.y - prevPoint.y) / (nextPoint.x - prevPoint.x);
                if (nextPoint.y - points[index].y == (nextPoint.x - points[index].x) * tg) {
                    if (removeCallback(points[index], index))
                        continue;
                }
            }
            index++;
        }
    };
    GeometryUtils.removeDuplicatedPoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            if (nextPoint) {
                if (point.x == nextPoint.x && point.y == nextPoint.y) {
                    var indexToRemove = index + 1;
                    if (indexToRemove === points.length - 1)
                        indexToRemove--;
                    if (removeCallback(points[indexToRemove], indexToRemove))
                        continue;
                }
            }
            index++;
        }
    };
    GeometryUtils.getNextPoint = function (points, index, direction, checkCallback) {
        var result;
        var newIndex = index + (direction ? 1 : -1);
        while (result = points[newIndex]) {
            if (checkCallback(result))
                return result;
            newIndex = newIndex + (direction ? 1 : -1);
        }
    };
    GeometryUtils.getDistance = function (a, b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
    };
    GeometryUtils.getPathLength = function (points) {
        var length = 0;
        var prevPt;
        points.forEach(function (pt) {
            if (prevPt !== undefined) {
                var lineLength = GeometryUtils.getDistance(pt, prevPt);
                length += lineLength;
            }
            prevPt = pt;
        });
        return length;
    };
    GeometryUtils.getPathPointByPosition = function (points, relativePosition) {
        if (!points.length)
            throw new Error("Invalid points");
        if (0 > relativePosition || relativePosition > 1)
            throw new Error("Invalid relative position");
        var length = this.getPathLength(points);
        if (points.length <= 2 && length === 0)
            return points[0];
        var targetLength = length * relativePosition;
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var lineLength = GeometryUtils.getDistance(points[i], points[i - 1]);
            if (currentLength + lineLength >= targetLength) {
                var delta = targetLength - currentLength;
                var cos = (points[i].x - points[i - 1].x) / lineLength;
                var sin = (points[i].y - points[i - 1].y) / lineLength;
                return new Point(points[i - 1].x + cos * delta, points[i - 1].y + sin * delta);
            }
            currentLength += lineLength;
        }
        ;
        return points[points.length - 1];
    };
    GeometryUtils.getLineAngle = function (beginPoint, endPoint) {
        return Math.atan2(endPoint.y - beginPoint.y, endPoint.x - beginPoint.x);
    };
    GeometryUtils.getTriangleBeginAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var beginPointAngle = this.getLineAngle(beginPoint, point);
        return Math.abs(beginPointAngle - lineAngle);
    };
    GeometryUtils.getTriangleEndAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var endPointAngle = this.getLineAngle(point, endPoint);
        return Math.abs(lineAngle - endPointAngle);
    };
    GeometryUtils.getPathPointByPoint = function (points, point) {
        if (!points.length)
            throw new Error("Invalid points");
        if (points.length === 1)
            return points[0];
        var distance = Number.MAX_VALUE;
        var result;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            if (point.equals(beginPoint)) {
                result = beginPoint.clone();
                break;
            }
            if (point.equals(endPoint)) {
                result = endPoint.clone();
                break;
            }
            var beginAngle = this.getTriangleBeginAngle(beginPoint, endPoint, point);
            var endAngle = this.getTriangleEndAngle(beginPoint, endPoint, point);
            var beginDistance = GeometryUtils.getDistance(point, beginPoint);
            var endDistance = GeometryUtils.getDistance(point, endPoint);
            var orthOffset = beginDistance * Math.sin(beginAngle);
            var currentDistance = void 0;
            if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                currentDistance = beginDistance;
            else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                currentDistance = endDistance;
            else
                currentDistance = Math.abs(orthOffset);
            if (currentDistance < distance) {
                distance = currentDistance;
                if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                    result = beginPoint.clone();
                else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                    result = endPoint.clone();
                else {
                    var lineAngle = this.getLineAngle(beginPoint, endPoint);
                    var offsetX = Math.fround(Math.abs(orthOffset * Math.sin(lineAngle)));
                    var offsetY = Math.fround(Math.abs(orthOffset * Math.cos(lineAngle)));
                    var isAbove = point.y - beginPoint.y < Math.fround((point.x - beginPoint.x) * Math.tan(lineAngle));
                    if (0 <= lineAngle && lineAngle <= Math.PI / 2) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (Math.PI / 2 <= lineAngle && lineAngle <= Math.PI) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (0 >= lineAngle && lineAngle >= -Math.PI / 2) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (-Math.PI / 2 >= lineAngle && lineAngle >= -Math.PI) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    result = point.offset(offsetX, offsetY);
                }
            }
        }
        ;
        return result;
    };
    GeometryUtils.getPathPositionByPoint = function (points, point, maxPositionCount) {
        if (maxPositionCount === void 0) { maxPositionCount = 100; }
        point = this.getPathPointByPoint(points, point);
        var length = this.getPathLength(points);
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            var lineLength = GeometryUtils.getDistance(endPoint, beginPoint);
            var angle = Math.atan((endPoint.y - beginPoint.y) / (endPoint.x - beginPoint.x));
            if ((point.x === endPoint.x && point.x === beginPoint.x) || (point.y === endPoint.y && point.y === beginPoint.y) ||
                Math.fround(point.y - beginPoint.y) === Math.fround((point.x - beginPoint.x) * Math.tan(angle))) {
                if (Math.sin(angle) !== 0)
                    currentLength += Math.abs((point.y - beginPoint.y) / Math.sin(angle));
                else
                    currentLength += Math.abs(point.x - beginPoint.x);
                return Math.round(currentLength * maxPositionCount / length) / maxPositionCount;
            }
            currentLength += lineLength;
        }
        ;
        return 1;
    };
    GeometryUtils.arePointsEqual = function (points1, points2) {
        var count1 = points1.length;
        var count2 = points2.length;
        if (count1 != count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (!points1[i].equals(points2[i]))
                return false;
        return true;
    };
    return GeometryUtils;
}());
exports.GeometryUtils = GeometryUtils;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeCategory;
(function (ShapeCategory) {
    ShapeCategory[ShapeCategory["Undefined"] = 0] = "Undefined";
    ShapeCategory[ShapeCategory["General"] = 1] = "General";
    ShapeCategory[ShapeCategory["Flowchart"] = 2] = "Flowchart";
    ShapeCategory[ShapeCategory["Custom"] = 3] = "Custom";
})(ShapeCategory = exports.ShapeCategory || (exports.ShapeCategory = {}));
var ShapeType;
(function (ShapeType) {
    // Standard
    ShapeType[ShapeType["Text"] = 0] = "Text";
    ShapeType[ShapeType["Rectangle"] = 1] = "Rectangle";
    ShapeType[ShapeType["Ellipsis"] = 2] = "Ellipsis";
    ShapeType[ShapeType["Cross"] = 3] = "Cross";
    ShapeType[ShapeType["Triangle"] = 4] = "Triangle";
    ShapeType[ShapeType["Diamond"] = 5] = "Diamond";
    ShapeType[ShapeType["Heart"] = 6] = "Heart";
    ShapeType[ShapeType["Pentagon"] = 7] = "Pentagon";
    ShapeType[ShapeType["Hexagon"] = 8] = "Hexagon";
    ShapeType[ShapeType["Octagon"] = 9] = "Octagon";
    ShapeType[ShapeType["Star"] = 10] = "Star";
    ShapeType[ShapeType["ArrowLeft"] = 11] = "ArrowLeft";
    ShapeType[ShapeType["ArrowTop"] = 12] = "ArrowTop";
    ShapeType[ShapeType["ArrowRight"] = 13] = "ArrowRight";
    ShapeType[ShapeType["ArrowBottom"] = 14] = "ArrowBottom";
    ShapeType[ShapeType["ArrowNorthSouth"] = 15] = "ArrowNorthSouth";
    ShapeType[ShapeType["ArrowEastWest"] = 16] = "ArrowEastWest";
    // Flowchart
    ShapeType[ShapeType["Process"] = 17] = "Process";
    ShapeType[ShapeType["Decision"] = 18] = "Decision";
    ShapeType[ShapeType["Terminator"] = 19] = "Terminator";
    ShapeType[ShapeType["PredefinedProcess"] = 20] = "PredefinedProcess";
    ShapeType[ShapeType["Document"] = 21] = "Document";
    ShapeType[ShapeType["MultipleDocuments"] = 22] = "MultipleDocuments";
    ShapeType[ShapeType["ManualInput"] = 23] = "ManualInput";
    ShapeType[ShapeType["Preparation"] = 24] = "Preparation";
    ShapeType[ShapeType["Data"] = 25] = "Data";
    ShapeType[ShapeType["Database"] = 26] = "Database";
    ShapeType[ShapeType["HardDisk"] = 27] = "HardDisk";
    ShapeType[ShapeType["InternalStorage"] = 28] = "InternalStorage";
    ShapeType[ShapeType["PaperTape"] = 29] = "PaperTape";
    ShapeType[ShapeType["ManualOperation"] = 30] = "ManualOperation";
    ShapeType[ShapeType["Delay"] = 31] = "Delay";
    ShapeType[ShapeType["StoredData"] = 32] = "StoredData";
    ShapeType[ShapeType["Display"] = 33] = "Display";
    ShapeType[ShapeType["Merge"] = 34] = "Merge";
    ShapeType[ShapeType["Or"] = 35] = "Or";
    ShapeType[ShapeType["SummingJunction"] = 36] = "SummingJunction";
    // Custom (must be last)
    ShapeType[ShapeType["Custom"] = 37] = "Custom";
})(ShapeType = exports.ShapeType || (exports.ShapeType = {}));


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var PathPrimitive = /** @class */ (function (_super) {
    __extends(PathPrimitive, _super);
    function PathPrimitive(commands, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.commands = commands;
        return _this;
    }
    PathPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "path");
    };
    PathPrimitive.prototype.applyElementProperties = function (element) {
        element.setAttribute("d", this.commands.map(function (c) { return c.toString(); }).join(" "));
        _super.prototype.applyElementProperties.call(this, element);
    };
    return PathPrimitive;
}(Primitive_1.SvgPrimitive));
exports.PathPrimitive = PathPrimitive;
var PathPrimitiveCommand = /** @class */ (function () {
    function PathPrimitiveCommand() {
    }
    PathPrimitiveCommand.prototype.getUnitVaue = function (value) {
        return typeof value === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(value).toString() : value;
    };
    return PathPrimitiveCommand;
}());
exports.PathPrimitiveCommand = PathPrimitiveCommand;
var PathPrimitiveMoveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveMoveToCommand, _super);
    function PathPrimitiveMoveToCommand(x, y) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveMoveToCommand.prototype.toString = function () {
        return "M " + this.getUnitVaue(this.x) + " " + this.getUnitVaue(this.y);
    };
    return PathPrimitiveMoveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveMoveToCommand = PathPrimitiveMoveToCommand;
var PathPrimitiveLineToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveLineToCommand, _super);
    function PathPrimitiveLineToCommand(x, y) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveLineToCommand.prototype.toString = function () {
        return "L " + this.getUnitVaue(this.x) + " " + this.getUnitVaue(this.y);
    };
    return PathPrimitiveLineToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveLineToCommand = PathPrimitiveLineToCommand;
var PathPrimitiveCubicCurveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveCubicCurveToCommand, _super);
    function PathPrimitiveCubicCurveToCommand(x1, y1, x2, y2, x3, y3) {
        var _this = _super.call(this) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        _this.x3 = x3;
        _this.y3 = y3;
        return _this;
    }
    PathPrimitiveCubicCurveToCommand.prototype.toString = function () {
        return "C " + this.getUnitVaue(this.x1) + " " + this.getUnitVaue(this.y1) + "," +
            this.getUnitVaue(this.x2) + " " + this.getUnitVaue(this.y2) + "," +
            this.getUnitVaue(this.x3) + " " + this.getUnitVaue(this.y3);
    };
    return PathPrimitiveCubicCurveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveCubicCurveToCommand = PathPrimitiveCubicCurveToCommand;
var PathPrimitiveQuadraticCurveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveQuadraticCurveToCommand, _super);
    function PathPrimitiveQuadraticCurveToCommand(x1, y1, x2, y2) {
        var _this = _super.call(this) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        return _this;
    }
    PathPrimitiveQuadraticCurveToCommand.prototype.toString = function () {
        return "Q " + this.getUnitVaue(this.x1) + " " + this.getUnitVaue(this.y1) + "," +
            this.getUnitVaue(this.x2) + " " + this.getUnitVaue(this.y2);
    };
    return PathPrimitiveQuadraticCurveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveQuadraticCurveToCommand = PathPrimitiveQuadraticCurveToCommand;
var PathPrimitiveArcToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveArcToCommand, _super);
    function PathPrimitiveArcToCommand(rx, ry, xAxisRotation, largeArcFlag, sweepFag, x, y) {
        var _this = _super.call(this) || this;
        _this.rx = rx;
        _this.ry = ry;
        _this.xAxisRotation = xAxisRotation;
        _this.largeArcFlag = largeArcFlag;
        _this.sweepFag = sweepFag;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveArcToCommand.prototype.toString = function () {
        return "A " + this.getUnitVaue(this.rx) + " " + this.getUnitVaue(this.ry) + " " +
            this.getUnitVaue(this.xAxisRotation) + " " +
            (this.largeArcFlag ? "1" : "0") + " " + (this.sweepFag ? "1" : "0") +
            this.getUnitVaue(this.x) + "," + this.getUnitVaue(this.y);
    };
    return PathPrimitiveArcToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveArcToCommand = PathPrimitiveArcToCommand;
var PathPrimitiveClosePathCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveClosePathCommand, _super);
    function PathPrimitiveClosePathCommand() {
        return _super.call(this) || this;
    }
    PathPrimitiveClosePathCommand.prototype.toString = function () {
        return "z";
    };
    return PathPrimitiveClosePathCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveClosePathCommand = PathPrimitiveClosePathCommand;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Style_1 = __webpack_require__(47);
var ConnectionPointSide;
(function (ConnectionPointSide) {
    ConnectionPointSide[ConnectionPointSide["Undefined"] = -1] = "Undefined";
    ConnectionPointSide[ConnectionPointSide["North"] = 0] = "North";
    ConnectionPointSide[ConnectionPointSide["East"] = 1] = "East";
    ConnectionPointSide[ConnectionPointSide["South"] = 2] = "South";
    ConnectionPointSide[ConnectionPointSide["West"] = 3] = "West";
})(ConnectionPointSide = exports.ConnectionPointSide || (exports.ConnectionPointSide = {}));
;
var DiagramItem = /** @class */ (function () {
    function DiagramItem() {
        this.key = undefined;
        this.dataKey = undefined;
        this.attachedConnectors = [];
        this.zIndex = 0;
        this.locked = false;
        this.style = new Style_1.Style();
        this.styleText = new Style_1.StyleText();
    }
    DiagramItem.prototype.assign = function (item) {
        item.key = this.key;
        item.dataKey = this.dataKey;
        item.locked = this.locked;
        item.attachedConnectors = this.attachedConnectors.slice();
        item.style = this.style.clone();
        item.styleText = this.styleText.clone();
        item.zIndex = this.zIndex;
    };
    DiagramItem.prototype.invalidatePrimitives = function () {
        delete this.primitives;
        delete this.selectorPrimitives;
    };
    DiagramItem.prototype.getPrimitives = function () {
        if (!this.primitives)
            this.primitives = this.createPrimitives();
        return this.primitives;
    };
    DiagramItem.prototype.getSelectorPrimitives = function () {
        if (!this.selectorPrimitives)
            this.selectorPrimitives = this.createSelectorPrimitives();
        return this.selectorPrimitives;
    };
    DiagramItem.prototype.getConnectionPoint = function (index, targetPoint) {
        return this.getConnectionPointCore(index, targetPoint).toPoint();
    };
    DiagramItem.prototype.getConnectionPointCore = function (index, targetPoint) {
        if (index < 0 && targetPoint)
            index = this.getNearestConnectionPoint(targetPoint);
        return this.getConnectionPoints()[index];
    };
    DiagramItem.prototype.getNearestConnectionPoint = function (targetPoint) {
        var distance = Number.MAX_VALUE;
        var result;
        this.getConnectionPoints().forEach(function (pt, index) {
            var ptDistance = Utils_1.GeometryUtils.getDistance(pt, targetPoint);
            if (ptDistance < distance) {
                distance = ptDistance;
                result = index;
            }
        });
        return result;
    };
    DiagramItem.prototype.getConnectionPointIndex = function (side) {
        var points = this.getConnectionPoints();
        return points.reduce(function (prevIndex, pt, index) {
            if (side === ConnectionPointSide.North && pt.y < points[prevIndex].y)
                return index;
            if (side === ConnectionPointSide.South && pt.y > points[prevIndex].y)
                return index;
            if (side === ConnectionPointSide.West && pt.x < points[prevIndex].x)
                return index;
            if (side === ConnectionPointSide.East && pt.x > points[prevIndex].x)
                return index;
            return prevIndex;
        }, 0);
    };
    Object.defineProperty(DiagramItem.prototype, "isVisible", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramItem.prototype, "allowHasText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    DiagramItem.prototype.intersectedByRect = function (rect) {
        return this.rectangle.intersect(rect);
    };
    return DiagramItem;
}());
exports.DiagramItem = DiagramItem;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem = /** @class */ (function () {
    function HistoryItem() {
        this.uniqueId = -1;
    }
    HistoryItem.prototype.changeModified = function () {
        return true;
    };
    HistoryItem.prototype.getName = function () {
        return this.constructor.name;
    };
    return HistoryItem;
}());
exports.HistoryItem = HistoryItem;
var CompositionHistoryItem = /** @class */ (function (_super) {
    __extends(CompositionHistoryItem, _super);
    function CompositionHistoryItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.historyItems = [];
        return _this;
    }
    CompositionHistoryItem.prototype.changeModified = function () {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++) {
            if (item.changeModified())
                return true;
        }
        return false;
    };
    CompositionHistoryItem.prototype.redo = function (manipulator) {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            item.redo(manipulator);
    };
    CompositionHistoryItem.prototype.undo = function (manipulator) {
        var item;
        for (var i = this.historyItems.length - 1; item = this.historyItems[i]; i--)
            item.undo(manipulator);
    };
    CompositionHistoryItem.prototype.add = function (historyItem) {
        if (historyItem == null)
            throw new Error("cannot be null");
        this.historyItems.push(historyItem);
    };
    return CompositionHistoryItem;
}(HistoryItem));
exports.CompositionHistoryItem = CompositionHistoryItem;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var Utils_1 = __webpack_require__(0);
var UnitConverter_1 = __webpack_require__(13);
var LinePrimitive_1 = __webpack_require__(69);
var ConnectorPointsCalculator_1 = __webpack_require__(105);
var ConnectorPointsOrthogonalCalculator_1 = __webpack_require__(106);
var ConnectorProperties_1 = __webpack_require__(28);
var ConnectorTexts_1 = __webpack_require__(112);
var TextPrimitive_1 = __webpack_require__(50);
var TextFilterPrimitive_1 = __webpack_require__(72);
var Event_1 = __webpack_require__(14);
var Utils_2 = __webpack_require__(26);
var ConnectorPosition;
(function (ConnectorPosition) {
    ConnectorPosition[ConnectorPosition["Begin"] = 0] = "Begin";
    ConnectorPosition[ConnectorPosition["End"] = 1] = "End";
})(ConnectorPosition = exports.ConnectorPosition || (exports.ConnectorPosition = {}));
var Connector = /** @class */ (function (_super) {
    __extends(Connector, _super);
    function Connector(points) {
        var _this = _super.call(this) || this;
        _this.beginConnectionPointIndex = -1;
        _this.endConnectionPointIndex = -1;
        _this.properties = new ConnectorProperties_1.ConnectorProperties();
        _this.points = points.map(function (pt) { return pt.clone(); });
        if (points.length < 2)
            throw Error("Points count should be greater than 1");
        _this.texts = new ConnectorTexts_1.ConnectorTexts();
        return _this;
    }
    Connector.prototype.assign = function (item) {
        _super.prototype.assign.call(this, item);
        item.beginItem = this.beginItem;
        item.beginConnectionPointIndex = this.beginConnectionPointIndex;
        item.endItem = this.endItem;
        item.endConnectionPointIndex = this.endConnectionPointIndex;
        item.properties = this.properties.clone();
        item.texts = this.texts.clone();
    };
    Connector.prototype.clone = function () {
        var clone = new Connector(this.points);
        this.assign(clone);
        return clone;
    };
    Connector.prototype.getRenderPoints = function (keepSkipped) {
        if (keepSkipped === void 0) { keepSkipped = false; }
        if (this.renderPoints === undefined) {
            this.renderPoints = this.getCalculator().getPoints();
            this.renderPointsWithoutSkipped = this.renderPoints.filter(function (pt) { return !pt.skipped; });
        }
        return keepSkipped ? this.renderPoints : this.renderPointsWithoutSkipped;
    };
    Connector.prototype.getText = function (position) {
        var textObj = this.texts.get(position);
        return textObj ? textObj.value : "";
    };
    Connector.prototype.setText = function (position, text) {
        if (!text || text === "")
            this.texts.remove(position);
        else
            this.texts.set(position, new ConnectorTexts_1.ConnectorText(position, text));
    };
    Connector.prototype.getTextPoint = function (position) {
        var points = this.getRenderPoints();
        return Utils_1.GeometryUtils.getPathPointByPosition(points, position);
    };
    Connector.prototype.getTextPositionByPoint = function (point) {
        var points = this.getRenderPoints();
        var length = Utils_1.GeometryUtils.getPathLength(points);
        var pos = Utils_1.GeometryUtils.getPathPositionByPoint(points, point);
        var minTextHeight = UnitConverter_1.UnitConverter.pointsToTwips(parseInt(this.styleText["font-size"]));
        if (minTextHeight > pos * length)
            return minTextHeight / length;
        if (minTextHeight > length - pos * length)
            return (length - minTextHeight) / length;
        return pos;
    };
    Connector.prototype.getTextRectangle = function (position) {
        return new Utils_1.Rectangle(this.getTextPoint(position), new Utils_1.Size(0, 0));
    };
    Connector.prototype.getCalculator = function () {
        return (this.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) ?
            new ConnectorPointsCalculator_1.ConnectorPointsCalculator(this) :
            new ConnectorPointsOrthogonalCalculator_1.ConnectorPointsOrthogonalCalculator(this);
    };
    Connector.prototype.invalidateRenderPoints = function () {
        delete this.renderPoints;
        delete this.renderPointsWithoutSkipped;
    };
    Connector.prototype.createPrimitives = function () {
        var _this = this;
        var result = [];
        var points = this.getRenderPoints();
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(_this.createSegmentPrimitive(points[index - 1], pt, _this.style, null));
        });
        if (points.length > 1) {
            if (this.properties.startLineEnding !== ConnectorProperties_1.ConnectorLineEnding.None)
                result = result.concat(this.createLineEndingPrimitives(points[0], points[1]));
            if (this.properties.endLineEnding !== ConnectorProperties_1.ConnectorLineEnding.None)
                result = result.concat(this.createLineEndingPrimitives(points[points.length - 1], points[points.length - 2]));
        }
        return result.concat(this.createTextPrimitives());
    };
    Connector.prototype.createSelectorPrimitives = function () {
        var _this = this;
        var result = [];
        var points = this.getRenderPoints();
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(_this.createSegmentPrimitive(points[index - 1], pt, null, "selector"));
        });
        return result;
    };
    Connector.prototype.createTextPrimitives = function () {
        var _this = this;
        if (!this.allowHasText)
            return [];
        var result = [];
        this.texts.forEach(function (textObj) {
            var text = _this.getText(textObj.position);
            if (text && text !== "") {
                var pt = _this.getTextPoint(textObj.position);
                var filterId = "filter" + _this.key;
                result = result.concat([
                    new TextPrimitive_1.TextPrimitive(pt.x, pt.y, text, undefined, _this.styleText, true, null, filterId, function (el) {
                        Utils_2.RenderUtils.setElementEventData(el, Event_1.MouseEventElementType.ConnectorText, _this.key, textObj.position);
                    }),
                    new TextFilterPrimitive_1.TextFilterPrimitive(filterId)
                ]);
            }
        });
        return result;
    };
    Connector.prototype.createSegmentPrimitive = function (point1, point2, style, className) {
        return new LinePrimitive_1.LinePrimitive(point1.x, point1.y, point2.x, point2.y, style, className);
    };
    Connector.prototype.createLineEndingPrimitives = function (point, directionPoint) {
        var arrowHeight = Connector.arrowHeight;
        if (point.x === directionPoint.x) {
            var distance = Math.abs(point.y - directionPoint.y);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        if (point.y === directionPoint.y) {
            var distance = Math.abs(point.x - directionPoint.x);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        var arrowPoints = Utils_1.GeometryUtils.getArrowPoints(point, directionPoint, arrowHeight, Connector.arrowWidth);
        return [
            new LinePrimitive_1.LinePrimitive(arrowPoints.point1.x, arrowPoints.point1.y, point.x, point.y, this.style),
            new LinePrimitive_1.LinePrimitive(arrowPoints.point2.x, arrowPoints.point2.y, point.x, point.y, this.style)
        ];
    };
    Connector.prototype.getExtremeItem = function (position) {
        if (position === ConnectorPosition.Begin)
            return this.beginItem;
        if (position === ConnectorPosition.End)
            return this.endItem;
        return null;
    };
    Connector.prototype.getExtremeConnectionPointIndex = function (position) {
        if (position === ConnectorPosition.Begin)
            return this.beginConnectionPointIndex;
        if (position === ConnectorPosition.End)
            return this.endConnectionPointIndex;
        return -1;
    };
    Object.defineProperty(Connector.prototype, "rectangle", {
        get: function () {
            var points = this.getRenderPoints();
            var xarr = points.map(function (p) { return p.x; });
            var yarr = points.map(function (p) { return p.y; });
            var minX = xarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
            var maxX = xarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
            var minY = yarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
            var maxY = yarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
            return Utils_1.Rectangle.create(minX, minY, maxX - minX, maxY - minY);
        },
        enumerable: true,
        configurable: true
    });
    Connector.prototype.getConnectionPoints = function () {
        return [];
    };
    Connector.prototype.getConnectionPointsForSelection = function () {
        return [];
    };
    Connector.prototype.getConnectionPointSide = function (index, targetPoint) {
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    Connector.prototype.getConnectionPointForSelectionSide = function (index) {
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    Connector.prototype.getSegments = function () {
        var points = this.getRenderPoints();
        var result = [];
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(Utils_1.Segment.createByPoints(points[index - 1], pt));
        });
        return result;
    };
    Connector.prototype.intersectedByRect = function (rect) {
        var result = false;
        this.getSegments().forEach(function (s) {
            if (s.intersectRect(rect)) {
                result = true;
                return;
            }
        });
        return result;
    };
    Connector.arrowHeight = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    Connector.arrowWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    Connector.minOffset = UnitConverter_1.UnitConverter.pixelsToTwips(18);
    Connector.minTextHeight = UnitConverter_1.UnitConverter.pixelsToTwips(12);
    return Connector;
}(DiagramItem_1.DiagramItem));
exports.Connector = Connector;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandState = /** @class */ (function () {
    function SimpleCommandState(enabled, value, items) {
        this.visible = true;
        this.denyUpdateValue = false;
        this.enabled = enabled;
        this.value = value;
        this.items = items;
    }
    return SimpleCommandState;
}());
exports.SimpleCommandState = SimpleCommandState;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase = /** @class */ (function () {
    function CommandBase(control) {
        this.control = control;
    }
    CommandBase.prototype.execute = function (parameter) {
        var state = this.getState();
        if (!state.enabled)
            return false;
        this.control.beginUpdate();
        var executed = this.executeCore(state, parameter);
        this.control.endUpdate();
        return executed;
    };
    CommandBase.prototype.updateControlState = function () {
        if (!this.lockUIUpdating()) {
            this.control.barManager.updateItemsState();
        }
    };
    CommandBase.prototype.lockUIUpdating = function () {
        return false;
    };
    CommandBase.prototype.isEnabled = function () {
        return true;
    };
    return CommandBase;
}());
exports.CommandBase = CommandBase;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MoveShapeHistoryItem_1 = __webpack_require__(101);
var AddConnectionHistoryItem_1 = __webpack_require__(35);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(36);
var ModelResizeHistoryItem_1 = __webpack_require__(114);
var UpdatePositionsOnPageResizeHistoryItem_1 = __webpack_require__(115);
var Connector_1 = __webpack_require__(5);
var DiagramItem_1 = __webpack_require__(3);
var Utils_1 = __webpack_require__(0);
var DeleteConnectorPointHistoryItem_1 = __webpack_require__(116);
var ResizeShapeHistoryItem_1 = __webpack_require__(117);
var DeleteConnectionHistoryItem_1 = __webpack_require__(73);
var DeleteShapeHistoryItem_1 = __webpack_require__(74);
var DeleteConnectorHistoryItem_1 = __webpack_require__(118);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var Shape_1 = __webpack_require__(9);
var ConnectorProperties_1 = __webpack_require__(28);
var UnitConverter_1 = __webpack_require__(13);
var DataSource_1 = __webpack_require__(37);
var AddShapeHistoryItem_1 = __webpack_require__(51);
var AddConnectorHistoryItem_1 = __webpack_require__(58);
var LayoutUtils_1 = __webpack_require__(59);
var Graph_1 = __webpack_require__(34);
var WideTree_1 = __webpack_require__(61);
var Sugiyama_1 = __webpack_require__(40);
var LayoutSettings_1 = __webpack_require__(18);
var Base_1 = __webpack_require__(19);
var CloneShapeHistoryItem_1 = __webpack_require__(154);
var CloneConnectorHistoryItem_1 = __webpack_require__(155);
var ModelUtils = /** @class */ (function () {
    function ModelUtils() {
    }
    ModelUtils.setShapePosition = function (history, model, shapeKey, newPosition, redoMethod) {
        var shape = model.findShape(shapeKey);
        if (!shape.position.equals(newPosition))
            redoMethod.call(history, new MoveShapeHistoryItem_1.MoveShapeHistoryItem(shapeKey, newPosition));
    };
    ModelUtils.setShapeSize = function (history, model, shapeKey, newPosition, newSize, redoMethod) {
        var shape = model.findShape(shapeKey);
        if (!shape.size.equals(newSize) || !shape.position.equals(newPosition))
            redoMethod.call(history, new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(shapeKey, newPosition, newSize));
    };
    ModelUtils.setConnectorPoint = function (history, model, connectorKey, pointIndex, newPosition, redoMethod) {
        var connector = model.findConnector(connectorKey);
        if (!connector.points[pointIndex].equals(newPosition))
            redoMethod.call(history, new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connectorKey, pointIndex, newPosition));
    };
    ModelUtils.getSymmetricDifference = function (nodeKeyMap, allItems) {
        return allItems.filter(function (i) {
            if (i instanceof Connector_1.Connector)
                return (!i.beginItem || !nodeKeyMap[i.beginItem.key]) && (!i.endItem || !nodeKeyMap[i.endItem.key]);
            return !nodeKeyMap[i.key];
        });
    };
    ModelUtils.offsetLayoutToFreeSpace = function (layout, occupiedRectangles) {
        var graphItemRect = layout.getRectangle(true);
        var freePoint = Utils_1.GeometryUtils.findFreeSpace(occupiedRectangles, graphItemRect.size.offset(this.spacing, this.spacing), false);
        if (freePoint)
            return layout.offsetNodes(freePoint.x + this.spacing, freePoint.y + this.spacing);
        var maxX = occupiedRectangles.reduce(function (max, rect) { return rect.right > max ? rect.right : max; }, -1);
        return layout.offsetNodes(maxX + this.spacing, graphItemRect.top === 0 ? this.spacing : 0);
    };
    ModelUtils.applyLayoutToNodes = function (history, model, layout, connectors) {
        var connectorsSet = connectors.reduce(function (acc, c) { return acc[c.key] =  true && acc; }, {});
        layout.forEachNode(function (nl, nk) {
            var shape = model.findShape(nk);
            var delta = nl.position.offset(-shape.position.x, -shape.position.y);
            ModelUtils.setShapePosition(history, model, nk, nl.position, history.addAndRedo);
            if (delta.x && delta.y) {
                shape.attachedConnectors
                    .filter(function (c) { return !connectorsSet[c.key]; })
                    .forEach(function (connector) {
                    ModelUtils.updateConnectorAttachedPoints(history, connector, history.addOrModifyAndRedo);
                    var beginPointIndex = connector.beginItem ? 1 : 0;
                    var endPointIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
                    for (var i = beginPointIndex; i <= endPointIndex; i++)
                        history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, i, connector.points[i].offset(delta.x, delta.y)));
                });
            }
        });
    };
    ModelUtils.applyLayoutToConnectors = function (history, layout, connectors) {
        var _this = this;
        connectors.filter(function (c) { return c.beginItem && c.endItem; }).forEach(function (connector) {
            var edgeLayout = layout.edgeToPosition[connector.key];
            if (edgeLayout) {
                if (edgeLayout.beginIndex !== connector.beginConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, edgeLayout.beginIndex, Connector_1.ConnectorPosition.Begin));
                if (edgeLayout.endIndex !== connector.endConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, edgeLayout.endIndex, Connector_1.ConnectorPosition.End));
            }
            _this.updateConnectorAttachedPoints(history, connector, history.addAndRedo);
            if (edgeLayout) {
                while (connector.points.length > 2)
                    history.addAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, 1));
            }
        });
    };
    ModelUtils.adjustLayoutToSnapGrid = function (model, layout) {
        var _this = this;
        layout.nodeKeys.forEach(function (key) {
            layout.nodeToLayout[key].position.x = _this.getSnappedPos(model, layout.nodeToLayout[key].position.x);
            layout.nodeToLayout[key].position.y = _this.getSnappedPos(model, layout.nodeToLayout[key].position.y);
        });
    };
    ModelUtils.updateConnectorAttachedPoints = function (history, connector, redoMethod) {
        if (connector.beginItem) {
            var pt = connector.beginItem.getConnectionPoint(connector.beginConnectionPointIndex, connector.points[1]);
            if (!connector.points[0].equals(pt))
                redoMethod.call(history, new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, 0, pt));
        }
        if (connector.endItem) {
            var pt = connector.endItem.getConnectionPoint(connector.endConnectionPointIndex, connector.points[connector.points.length - 2]);
            if (!connector.points[connector.points.length - 1].equals(pt))
                redoMethod.call(history, new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, connector.points.length - 1, pt));
        }
    };
    ModelUtils.removeUnnecessaryConnectorPoints = function (history, connector, exceptPoints, removeCallback) {
        Utils_1.GeometryUtils.removeUnnecessaryLinePoints(connector.points, function (pt, index) {
            var needRemove = true;
            if (exceptPoints) {
                exceptPoints.forEach(function (ept) {
                    if (ept && ept.equals(pt)) {
                        needRemove = false;
                        return;
                    }
                });
            }
            if (needRemove) {
                history.addOrModifyAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, index));
                if (removeCallback !== undefined)
                    removeCallback(index);
                return true;
            }
        });
    };
    ModelUtils.removeConnectorIntermediatePoints = function (history, connector) {
        if (connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal || connector.points.length <= 2)
            return;
        var removePoints = false;
        if (this.isShapeIntersectConnectorPointsLine(connector.beginItem, connector))
            removePoints = true;
        if (this.isShapeIntersectConnectorPointsLine(connector.endItem, connector))
            removePoints = true;
        if (removePoints) {
            while (connector.points.length > 2) {
                history.addOrModifyAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, 1));
            }
        }
    };
    ModelUtils.isShapeIntersectConnectorPointsLine = function (shape, connector) {
        if (shape === undefined)
            return false;
        var offset = Connector_1.Connector.minOffset - UnitConverter_1.UnitConverter.pixelsToTwips(1);
        var rect = shape.rectangle.inflate(offset, offset);
        var prevPt;
        for (var i = 1; i < connector.points.length - 1; i++) {
            if (prevPt !== undefined) {
                if (prevPt.x === connector.points[i].x) {
                    if (rect.left <= prevPt.x && prevPt.x <= rect.right)
                        return true;
                }
                if (prevPt.y === connector.points[i].y) {
                    if (rect.top <= prevPt.y && prevPt.y <= rect.bottom)
                        return true;
                }
            }
            prevPt = connector.points[i];
        }
        return false;
    };
    ModelUtils.getSnappedPos = function (model, pos) {
        return Math.round(pos / model.gridSize) * model.gridSize;
    };
    ModelUtils.tryUpdateModelSize = function (history, model, processPoints) {
        var pageSizeOffset = this.getRequiredPageSizeChanges(model);
        if (pageSizeOffset.bottom || pageSizeOffset.left || pageSizeOffset.right || pageSizeOffset.top) {
            history.addOrModifyAndRedo(new ModelResizeHistoryItem_1.ModelResizeHistoryItem(pageSizeOffset));
            if (pageSizeOffset.left || pageSizeOffset.top) {
                history.addOrModifyAndRedo(new UpdatePositionsOnPageResizeHistoryItem_1.UpdatePositionsOnPageResizeHistoryItem(pageSizeOffset.left, pageSizeOffset.top));
                if (processPoints !== undefined)
                    processPoints(pageSizeOffset.left, pageSizeOffset.top);
            }
        }
    };
    ModelUtils.deleteItems = function (history, model, selection, items) {
        history.beginTransaction();
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                var shape = item;
                while (shape.attachedConnectors.length > 0) {
                    var connector = shape.attachedConnectors[0];
                    history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, connector.beginItem === shape ? Connector_1.ConnectorPosition.Begin : Connector_1.ConnectorPosition.End));
                }
                history.addAndRedo(new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(shape.key));
            }
            if (item instanceof Connector_1.Connector) {
                var connector = item;
                if (connector.beginItem)
                    history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.Begin));
                if (connector.endItem)
                    history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.End));
                history.addAndRedo(new DeleteConnectorHistoryItem_1.DeleteConnectorHistoryItem(connector.key));
            }
        });
        this.tryUpdateModelSize(history, model);
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, []));
        history.endTransaction();
    };
    ModelUtils.deleteAllItems = function (history, model, selection) {
        this.deleteItems(history, model, selection, model.items.slice());
    };
    ModelUtils.deleteSelection = function (history, model, selection) {
        this.deleteItems(history, model, selection, selection.getSelectedItems());
    };
    ModelUtils.cloneSelectionToOffset = function (history, model, selection, dx, dy) {
        history.beginTransaction();
        var shapes = selection.getSelectedShapes();
        var newShapesHash = {};
        var ids = [];
        shapes.forEach(function (shape, index) {
            var newShape = shape.clone();
            newShape.position = newShape.position.offset(dx, dy);
            history.addOrModifyAndRedo(new CloneShapeHistoryItem_1.CloneShapeHistoryItem(newShape));
            newShapesHash[shape.key] = newShape;
            ids.push(newShape.key);
        });
        var connectors = selection.getSelectedConnectors();
        connectors.forEach(function (connector, index) {
            var newConnector = connector.clone();
            newConnector.points.forEach(function (point) {
                point.x += dx;
                point.y += dy;
            });
            history.addOrModifyAndRedo(new CloneConnectorHistoryItem_1.CloneConnectorHistoryItem(newConnector, connector.beginItem ? newShapesHash[connector.beginItem.key] : null, connector.endItem ? newShapesHash[connector.endItem.key] : null));
            ids.push(newConnector.key);
        });
        history.addOrModifyAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, ids));
        ModelUtils.tryUpdateModelSize(history, model);
        history.endTransaction();
    };
    ModelUtils.createItemsByDataSource = function (history, model, selection, dataSource, layoutType, setDataKeys) {
        var DEFAULT_STEP = 2000;
        var rowIndex = 0;
        var colIndex = 0;
        var externalToInnerMap = {};
        var shapes = [];
        var connectors = [];
        history.beginTransaction();
        dataSource.nodes.forEach(function (node) {
            var point = new Utils_1.Point(colIndex++ * DEFAULT_STEP, rowIndex * DEFAULT_STEP);
            var dataKey = setDataKeys ? node.key : undefined;
            var insert = new AddShapeHistoryItem_1.AddShapeHistoryItem(node.type, point, node.text, dataKey);
            history.addAndRedo(insert);
            if (node.key !== undefined)
                externalToInnerMap[node.key] = insert.shapeKey;
            if (colIndex > 4) {
                colIndex = 0;
                rowIndex++;
            }
            shapes.push(model.findShape(insert.shapeKey));
        });
        dataSource.edges.forEach(function (edge) {
            var shape = model.findShape(externalToInnerMap[edge.to]);
            var parentShape = model.findShape(externalToInnerMap[edge.from]);
            if (shape && parentShape !== undefined) {
                var dataKey = setDataKeys ? edge.key : undefined;
                var insert = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([shape.position.clone(), parentShape.position.clone()], dataKey);
                history.addAndRedo(insert);
                var connector = model.findConnector(insert.connectorKey);
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, parentShape, 0, Connector_1.ConnectorPosition.Begin));
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, shape, 0, Connector_1.ConnectorPosition.End));
                connectors.push(model.findConnector(insert.connectorKey));
            }
        });
        var graph = Graph_1.Graph.create(shapes, connectors).cast(LayoutUtils_1.LayoutUtils.shapeToLayout);
        var layout = layoutType === DataSource_1.DataLayoutType.Tree ?
            new WideTree_1.TreeLayoutBuilder(new LayoutSettings_1.TreeLayoutSettings(), graph).build() :
            new Sugiyama_1.SugiyamaLayoutBuilder(new LayoutSettings_1.LayoutSettings(), graph).build();
        var nonGraphItems = ModelUtils.getSymmetricDifference(layout.nodeToLayout, model.items);
        layout = ModelUtils.offsetLayoutToFreeSpace(layout, nonGraphItems.map(function (i) { return i.rectangle; }));
        ModelUtils.applyLayoutToNodes(history, model, layout, connectors);
        ModelUtils.applyLayoutToConnectors(history, layout, connectors);
        var items = connectors.map(function (c) { return c.key; }).concat(shapes.map(function (s) { return s.key; }));
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, items));
        ModelUtils.tryUpdateModelSize(history, model);
        history.endTransaction();
    };
    ModelUtils.getRequiredPageSizeChanges = function (model) {
        var rectangle = model.getRectangle();
        var leftPageOffset = -Math.floor(rectangle.left / model.pageWidth);
        var topPageOffset = -Math.floor(rectangle.top / model.pageHeight);
        var rightPageOffset = -Math.floor((model.size.width - rectangle.right) / model.pageWidth);
        var bottomPageOffset = -Math.floor((model.size.height - rectangle.bottom) / model.pageHeight);
        return new Utils_1.Offset(leftPageOffset * model.pageWidth, topPageOffset * model.pageHeight, rightPageOffset * model.pageWidth, bottomPageOffset * model.pageHeight);
    };
    ModelUtils.getPositionByDirection = function (isStart, hor, vert) {
        vert = vert * (isStart ? 1 : -1);
        hor = hor * (isStart ? 1 : -1);
        if (vert > 0)
            return DiagramItem_1.ConnectionPointSide.South;
        else if (vert < 0)
            return DiagramItem_1.ConnectionPointSide.North;
        else {
            if (hor > 0)
                return DiagramItem_1.ConnectionPointSide.East;
            else if (hor < 0)
                return DiagramItem_1.ConnectionPointSide.West;
        }
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ModelUtils.getNextItemKey = function (keys, checkKey, baseKey) {
        if (!keys.length && baseKey === undefined)
            return "0";
        for (var i = keys.length - 1; i >= 0; i--) {
            baseKey = baseKey || keys[i];
            if (baseKey !== undefined && baseKey !== null)
                break;
        }
        var key = this.generateNextItemKey(baseKey || "0");
        while (!checkKey(key)) {
            key = this.generateNextItemKey(key);
        }
        return key;
    };
    ModelUtils.generateNextItemKey = function (key) {
        for (var i = key.length - 1; i >= 0; i--) {
            if (!this.isDigit(key[i])) {
                if (i === key.length - 1)
                    key = key + "0";
                break;
            }
            var code = key.charCodeAt(i);
            var char = String.fromCharCode(code + 1);
            if (char > "9") {
                char = "0";
                if (i === 0 || !this.isDigit(key[i - 1]))
                    char = "1" + char;
            }
            key = key.substr(0, i) + char + key.substr(i + 1);
            if (char !== "0" && char !== "10")
                break;
            else if (char === "10")
                i--;
        }
        return key;
    };
    ModelUtils.isDigit = function (char) {
        return "0" <= char && char <= "9";
    };
    ModelUtils.getGuidItemKey = function () {
        return Base_1.CreateGuid();
    };
    ModelUtils.spacing = 200;
    return ModelUtils;
}());
exports.ModelUtils = ModelUtils;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(25);
var UnitConverter_1 = __webpack_require__(13);
var DiagramItem_1 = __webpack_require__(3);
var ConnectionPoint_1 = __webpack_require__(32);
var Shape = /** @class */ (function (_super) {
    __extends(Shape, _super);
    function Shape(description, position) {
        var _this = _super.call(this) || this;
        _this.description = description;
        _this.position = position.clone();
        _this.size = description.defaultSize.clone();
        _this.text = description.defualtText;
        _this.parameters = new ShapeParameters_1.ShapeParameters();
        description.createParameters(_this.parameters);
        return _this;
    }
    Shape.prototype.assign = function (item) {
        _super.prototype.assign.call(this, item);
        item.size = this.size.clone();
        item.text = this.text;
        item.parameters = this.parameters.clone();
    };
    Shape.prototype.clone = function () {
        var clone = new Shape(this.description, this.position.clone());
        this.assign(clone);
        return clone;
    };
    Object.defineProperty(Shape.prototype, "allowHasText", {
        get: function () { return this.description.allowHasText; },
        enumerable: true,
        configurable: true
    });
    Shape.prototype.createPrimitives = function () {
        return this.description.createPrimitives(this);
    };
    Shape.prototype.createSelectorPrimitives = function () {
        return this.description.createSelectorPrimitives(this);
    };
    Shape.prototype.normalizeX = function (x) {
        return Math.max(this.position.x, Math.min(x, this.position.x + this.size.width));
    };
    Shape.prototype.normalizeY = function (y) {
        return Math.max(this.position.y, Math.min(y, this.position.y + this.size.height));
    };
    Shape.prototype.getConnectionPoints = function () {
        var _this = this;
        var result = this.description.getConnectionPoints().map(function (pt, index) {
            var point = new ConnectionPoint_1.ConnectionPoint(_this.position.x + pt.x * _this.size.width, _this.position.y + pt.y * _this.size.height, pt.side);
            _this.description.processConnectionPoint(_this, point, index);
            return point;
        });
        return result;
    };
    Shape.prototype.getConnectionPointsForSelection = function () {
        var _this = this;
        var result = this.description.getConnectionPointsForSelection().map(function (pt, index) {
            var point = new ConnectionPoint_1.ConnectionPoint(_this.position.x + pt.x * _this.size.width, _this.position.y + pt.y * _this.size.height, pt.side);
            return point;
        });
        return result;
    };
    Shape.prototype.getConnectionPointSide = function (index, targetPoint) {
        var point = this.getConnectionPointCore(index, targetPoint);
        if (point.side !== DiagramItem_1.ConnectionPointSide.Undefined)
            return point.side;
        return this.getConnectionPointSideByGeometry(point);
    };
    Shape.prototype.getConnectionPointForSelectionSide = function (index) {
        var point = this.getConnectionPointsForSelection()[index];
        if (point.side !== DiagramItem_1.ConnectionPointSide.Undefined)
            return point.side;
        return this.getConnectionPointSideByGeometry(point);
    };
    Shape.prototype.getConnectionPointSideByGeometry = function (point) {
        var pt = point.offset(-this.position.x, -this.position.y).multiply(1 / this.size.width, 1 / this.size.height);
        if (pt.x >= pt.y && (pt.x > 0 || pt.y > 0)) {
            if (pt.x < 0.5 || (1 - pt.x) >= pt.y)
                return DiagramItem_1.ConnectionPointSide.North;
            return DiagramItem_1.ConnectionPointSide.East;
        }
        else {
            if (pt.x > 0.5 || (1 - pt.x) <= pt.y)
                return DiagramItem_1.ConnectionPointSide.South;
            return DiagramItem_1.ConnectionPointSide.West;
        }
    };
    Object.defineProperty(Shape.prototype, "rectangle", {
        get: function () {
            return new Utils_1.Rectangle(this.position, this.size);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "textRectangle", {
        get: function () {
            return this.description.getTextRectangle(this.rectangle);
        },
        enumerable: true,
        configurable: true
    });
    Shape.lineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    return Shape;
}(DiagramItem_1.DiagramItem));
exports.Shape = Shape;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ModelChange_1 = __webpack_require__(48);
var Event_1 = __webpack_require__(14);
var Evt_1 = __webpack_require__(49);
var Utils_1 = __webpack_require__(0);
var Base_1 = __webpack_require__(19);
var UnitConverter_1 = __webpack_require__(13);
var KeyCode_1 = __webpack_require__(16);
var Browser_1 = __webpack_require__(20);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Utils_2 = __webpack_require__(26);
var TouchUIHelper_1 = __webpack_require__(70);
exports.svgNS = "http://www.w3.org/2000/svg";
var RenderManager = /** @class */ (function () {
    function RenderManager(parent, eventManager) {
        this.scrollYVisible = false;
        this.scrollXVisible = false;
        this.scrollTimer = -1;
        this.allowChangeScrolling = false;
        this.zoomLevel = 1;
        this.moveLocked = false;
        this.focusLocked = false;
        this.focused = false;
        this.eventManager = eventManager;
        this.createElements(parent);
        window.addEventListener("resize", this.onWindowResize.bind(this));
    }
    RenderManager.prototype.createElements = function (parent) {
        if (this.mainElement)
            return;
        var element = document.createElement("DIV");
        element.setAttribute("class", "dxdi-control");
        element.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseDownEventName, this.onMouseDown.bind(this));
        document.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseMoveEventName, this.onMouseMove.bind(this));
        element.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseUpEventName, this.onMouseUp.bind(this));
        element.addEventListener("mouseenter", this.onMouseEnter.bind(this));
        element.addEventListener("mouseleave", this.onMouseLeave.bind(this));
        element.addEventListener("dblclick", this.onDblClick.bind(this));
        document.addEventListener("paste", this.onPaste.bind(this));
        parent.appendChild(element);
        this.mainElement = element;
        element = document.createElement("DIV");
        element.setAttribute("class", "dxdi-canvas-container");
        this.mainElement.appendChild(element);
        this.containerElement = element;
        var svgElement = RenderManager.createSvgElement();
        this.containerElement.appendChild(svgElement);
        this.svgElement = svgElement;
        this.updateMainElementSize();
        this.createInputElement(this.mainElement);
        this.createClipboardInputElement(this.mainElement);
        this.setInputElementFocusHandlerMode();
    };
    RenderManager.createSvgElement = function (forExport) {
        if (forExport === void 0) { forExport = false; }
        var svgElement = document.createElementNS(exports.svgNS, "svg");
        svgElement.className.baseVal = "dxdi-canvas" + (forExport ? " export" : "");
        return svgElement;
    };
    RenderManager.prototype.createInputElement = function (parent) {
        this.inputElementContainer = document.createElement("div");
        parent.appendChild(this.inputElementContainer);
        this.inputElement = document.createElement("div");
        this.inputElement.setAttribute("contenteditable", "true");
        this.inputElementContainer.appendChild(this.inputElement);
        this.inputElement.addEventListener("blur", this.onInputBlur.bind(this));
        this.inputElement.addEventListener("focus", this.onInputFocus.bind(this));
        this.inputElement.addEventListener("keydown", this.onKeyDown.bind(this));
    };
    RenderManager.prototype.createClipboardInputElement = function (parent) {
        this.clipboardInputElement = document.createElement("textarea");
        this.clipboardInputElement.setAttribute("class", "dxdi-clipboard-input");
        parent.appendChild(this.clipboardInputElement);
    };
    RenderManager.prototype.setInputElementFocusHandlerMode = function () {
        this.inputElementContainer.setAttribute("class", "dxdi-input focus");
    };
    RenderManager.prototype.setInputElementTextInputMode = function (text, position, size, style, className) {
        this.inputElementContainer.setAttribute("class", "dxdi-input " + className);
        this.inputElement.innerText = text;
        this.setTextInputElementBounds(position, size);
        this.setTextInputElementStyle(style);
        this.captureFocus(true);
    };
    RenderManager.prototype.setTextInputElementBounds = function (position, size) {
        var left = Base_1.GetAbsolutePositionX(this.svgElement) + (UnitConverter_1.UnitConverter.twipsToPixels(position.x) * this.zoomLevel);
        Base_1.SetAbsoluteX(this.inputElementContainer, left);
        var top = Base_1.GetAbsolutePositionY(this.svgElement) + (UnitConverter_1.UnitConverter.twipsToPixels(position.y) * this.zoomLevel);
        Base_1.SetAbsoluteY(this.inputElementContainer, top);
        this.inputElementContainer.style.width = (size !== undefined) ? UnitConverter_1.UnitConverter.twipsToPixels(size.width) + "px" : "0px";
        this.inputElementContainer.style.height = (size !== undefined) ? UnitConverter_1.UnitConverter.twipsToPixels(size.height) + "px" : "0px";
        this.inputElementContainer.style.transform = "scale(" + this.zoomLevel + ")";
        this.inputElement.style.width = (size !== undefined) ? UnitConverter_1.UnitConverter.twipsToPixels(size.width) + "px" : "";
        this.inputElement.style.height = (size !== undefined) ? UnitConverter_1.UnitConverter.twipsToPixels(size.height) + "px" : "auto";
    };
    RenderManager.prototype.setTextInputElementStyle = function (style) {
        Utils_2.RenderUtils.applyStyleToElement(style, this.inputElement);
    };
    RenderManager.prototype.applyPageChange = function (change) {
        var zoomChange = this.zoomLevel !== change.model.zoomLevel;
        this.zoomLevel = change.model.zoomLevel;
        this.updateSvgElementSize(change.model.size);
        this.initializeSvgPositionProperties(change.type === ModelChange_1.PageChangeType.Create || zoomChange);
        if (change.offset !== undefined)
            this.changeSvgPositionProperties(change.offset);
        this.updateSvgElementPosition();
        this.normalizeSvgElementPosition();
    };
    RenderManager.prototype.setClipboardData = function (data) {
        this.clipboardInputElement.value = data;
        this.clipboardInputElement.focus();
        this.clipboardInputElement.select();
        document.execCommand('copy');
        this.captureFocus();
    };
    RenderManager.prototype.getClipboardData = function (callback) {
        var _this = this;
        if (navigator && navigator["clipboard"]) {
            navigator["clipboard"].readText().then(function (clipText) {
                callback(clipText);
                _this.captureFocus();
            }).catch(function () {
                callback("");
                _this.captureFocus();
            });
        }
        else {
            this.clipboardInputElement.value = "";
            this.clipboardInputElement.focus();
            this.clipboardInputElement.select();
            document.execCommand('Paste');
            callback(this.clipboardInputElement.value);
            this.captureFocus();
        }
    };
    RenderManager.prototype.initializeSvgPositionProperties = function (recreate) {
        var svgWidth = parseInt(this.svgElement.style.width);
        var svgHeight = parseInt(this.svgElement.style.height);
        if (recreate || this.svgPositionProperties === undefined) {
            var paddingLeft = Math.max((this.mainElement.clientWidth - svgWidth) / 2, RenderManager.minPadding);
            var paddingTop = Math.max((this.mainElement.clientHeight - svgHeight) / 2, RenderManager.minPadding);
            this.svgPositionProperties = {
                width: svgWidth,
                height: svgHeight,
                containerPaddingLeft: paddingLeft,
                containerPaddingTop: paddingTop,
                containerPaddingRight: paddingLeft,
                containerPaddingBottom: paddingTop,
                containerScrollLeft: this.mainElement.scrollLeft,
                containerScrollTop: this.mainElement.scrollTop
            };
        }
        else {
            this.svgPositionProperties.width = svgWidth;
            this.svgPositionProperties.height = svgHeight;
            this.svgPositionProperties.containerScrollLeft = this.mainElement.scrollLeft;
            this.svgPositionProperties.containerScrollTop = this.mainElement.scrollTop;
        }
    };
    RenderManager.prototype.changeSvgPositionProperties = function (offset) {
        var leftChange = UnitConverter_1.UnitConverter.twipsToPixels(offset.left) * this.zoomLevel;
        if (leftChange < 0) {
            if (this.svgPositionProperties.containerScrollLeft > -leftChange)
                this.svgPositionProperties.containerScrollLeft += leftChange;
            else
                this.svgPositionProperties.containerPaddingLeft -= leftChange;
        }
        else if (leftChange > 0) {
            this.svgPositionProperties.containerScrollLeft += leftChange;
        }
        var rightChange = UnitConverter_1.UnitConverter.twipsToPixels(offset.right) * this.zoomLevel;
        if (rightChange < 0) {
            this.svgPositionProperties.containerPaddingRight -= rightChange;
            if (this.svgPositionProperties.containerScrollLeft > this.svgPositionProperties.containerPaddingRight) {
            }
        }
        else if (rightChange > 0) {
            this.svgPositionProperties.containerPaddingRight = this.svgPositionProperties.containerPaddingLeft;
            if (this.svgPositionProperties.containerScrollLeft > this.svgPositionProperties.containerPaddingLeft) {
                this.svgPositionProperties.containerScrollLeft -= this.svgPositionProperties.containerPaddingLeft - RenderManager.minPadding;
                this.svgPositionProperties.containerPaddingLeft = RenderManager.minPadding;
            }
        }
        var topChange = UnitConverter_1.UnitConverter.twipsToPixels(offset.top) * this.zoomLevel;
        if (offset.top < 0) {
            if (this.svgPositionProperties.containerScrollTop > -topChange)
                this.svgPositionProperties.containerScrollTop += topChange;
            else
                this.svgPositionProperties.containerPaddingTop -= topChange;
        }
        if (topChange > 0) {
            this.svgPositionProperties.containerScrollTop += topChange;
        }
        var bottomChange = UnitConverter_1.UnitConverter.twipsToPixels(offset.bottom) * this.zoomLevel;
        if (bottomChange < 0) {
            this.svgPositionProperties.containerPaddingBottom -= bottomChange;
        }
        else if (bottomChange > 0) {
            this.svgPositionProperties.containerPaddingBottom = this.svgPositionProperties.containerPaddingTop;
            if (this.svgPositionProperties.containerScrollTop > this.svgPositionProperties.containerPaddingTop) {
                this.svgPositionProperties.containerScrollTop -= this.svgPositionProperties.containerPaddingTop - RenderManager.minPadding;
                this.svgPositionProperties.containerPaddingTop = RenderManager.minPadding;
            }
        }
    };
    RenderManager.prototype.updateMainElementSize = function () {
        var parentElement = this.mainElement.parentNode;
        this.mainElement.style.width = "0px";
        this.mainElement.style.width = parentElement.offsetWidth + "px";
        this.mainElement.style.height = "0px";
        this.mainElement.style.height = parentElement.offsetHeight + "px";
    };
    RenderManager.prototype.updateSvgElementSize = function (modelSize) {
        var width = UnitConverter_1.UnitConverter.twipsToPixels(modelSize.width) * this.zoomLevel;
        var height = UnitConverter_1.UnitConverter.twipsToPixels(modelSize.height) * this.zoomLevel;
        Utils_2.RenderUtils.updateSvgElementSize(this.svgElement, width, height);
    };
    RenderManager.prototype.getSvgContainerWidth = function () {
        return this.svgPositionProperties.width +
            this.svgPositionProperties.containerPaddingLeft +
            this.svgPositionProperties.containerPaddingRight;
    };
    RenderManager.prototype.getSvgContainerHeight = function () {
        return this.svgPositionProperties.height +
            this.svgPositionProperties.containerPaddingTop +
            this.svgPositionProperties.containerPaddingBottom;
    };
    RenderManager.prototype.updateSvgElementPosition = function () {
        this.containerElement.style.paddingLeft = this.svgPositionProperties.containerPaddingLeft + "px";
        this.containerElement.style.paddingRight = this.svgPositionProperties.containerPaddingRight + "px";
        this.containerElement.style.paddingTop = this.svgPositionProperties.containerPaddingTop + "px";
        this.containerElement.style.paddingBottom = this.svgPositionProperties.containerPaddingBottom + "px";
        this.containerElement.style.width = this.getSvgContainerWidth() + "px";
        this.containerElement.style.height = this.getSvgContainerHeight() + "px";
        this.mainElement.scrollLeft = this.svgPositionProperties.containerScrollLeft;
        this.mainElement.scrollTop = this.svgPositionProperties.containerScrollTop;
    };
    RenderManager.prototype.normalizeSvgElementPosition = function () {
        var xCorr = this.mainElement.scrollWidth - this.mainElement.offsetWidth - this.mainElement.scrollLeft;
        if (xCorr > 0) {
            var padding = this.svgPositionProperties.containerPaddingRight - xCorr;
            this.svgPositionProperties.containerPaddingRight = Math.max(padding, RenderManager.minPadding);
            this.containerElement.style.paddingRight = this.svgPositionProperties.containerPaddingRight + "px";
            this.containerElement.style.width = this.getSvgContainerWidth() + "px";
        }
        var yCorr = this.mainElement.scrollHeight - this.mainElement.offsetHeight - this.mainElement.scrollTop;
        if (yCorr > 0) {
            var padding = this.svgPositionProperties.containerPaddingBottom - yCorr;
            this.svgPositionProperties.containerPaddingBottom = Math.max(padding, RenderManager.minPadding);
            this.containerElement.style.paddingBottom = this.svgPositionProperties.containerPaddingBottom + "px";
            this.containerElement.style.height = this.getSvgContainerHeight() + "px";
        }
    };
    RenderManager.prototype.changeScrollPosition = function (evt, raiseMouseMove) {
        var x = evt.pageX - Base_1.GetAbsolutePositionX(this.mainElement);
        var y = evt.pageY - Base_1.GetAbsolutePositionY(this.mainElement);
        var width = this.mainElement.offsetWidth;
        if (this.mainElement.offsetWidth < this.mainElement.scrollWidth)
            width -= RenderManager.scrollBarWidth;
        var height = this.mainElement.offsetHeight;
        if (this.mainElement.offsetHeight < this.mainElement.scrollHeight)
            height -= RenderManager.scrollBarWidth;
        var changed = false;
        if (x <= RenderManager.scrollEdge) {
            this.mainElement.scrollLeft -= this.getScrollingOffset(x);
            changed = true;
        }
        else if (width - RenderManager.scrollEdge <= x) {
            this.mainElement.scrollLeft += this.getScrollingOffset(width - x);
            changed = true;
        }
        if (y <= RenderManager.scrollEdge) {
            this.mainElement.scrollTop -= this.getScrollingOffset(y);
            changed = true;
        }
        else if (height - RenderManager.scrollEdge <= y) {
            this.mainElement.scrollTop += this.getScrollingOffset(height - y);
            changed = true;
        }
        if (changed) {
            this.scrollTimer = window.setTimeout(function () { this.changeScrollPosition(evt, true); }.bind(this), RenderManager.scrollDelay);
        }
        if (raiseMouseMove)
            this.onMouseMoveCore(evt);
    };
    RenderManager.prototype.clearScrollTimer = function () {
        if (this.scrollTimer > -1) {
            window.clearTimeout(this.scrollTimer);
            this.scrollTimer = -1;
        }
    };
    RenderManager.prototype.getScrollingOffset = function (edgeOffset) {
        var offset = Math.pow((RenderManager.scrollEdge - edgeOffset) / RenderManager.scrollRatio, 2);
        return Math.min(offset, RenderManager.scrollMaxOffset);
    };
    RenderManager.prototype.captureFocus = function (selectAll) {
        if (selectAll === void 0) { selectAll = false; }
        this.inputElement.focus();
        if (selectAll) {
            var element = this.inputElement;
            window.setTimeout(function () {
                var selection = window.getSelection();
                var range = document.createRange();
                range.selectNodeContents(element);
                selection.removeAllRanges();
                selection.addRange(range);
            }, 100);
        }
    };
    RenderManager.prototype.updateLayout = function () {
        this.updateMainElementSize();
        this.initializeSvgPositionProperties(true);
        this.updateSvgElementPosition();
    };
    RenderManager.prototype.isFocused = function () {
        return this.focused;
    };
    // Notifications
    RenderManager.prototype.NotifyTextInputStart = function (item, text, position, size) {
        var className = "";
        if (item instanceof Shape_1.Shape)
            className = "shape-text";
        else if (item instanceof Connector_1.Connector)
            className = "connector-text";
        this.setInputElementTextInputMode(text, position, size, item.styleText, className);
    };
    RenderManager.prototype.NotifyTextInputEnd = function (item) {
        this.setInputElementFocusHandlerMode();
    };
    RenderManager.prototype.NotifyModelChanged = function (changes) {
        for (var i = 0, change = void 0; change = changes[i]; i++) {
            if (change instanceof ModelChange_1.PageChange)
                this.applyPageChange(change);
        }
    };
    // Window handlers
    RenderManager.prototype.onWindowResize = function (evt) {
        this.updateLayout();
    };
    // Mouse handlers
    RenderManager.prototype.onMouseDown = function (evt) {
        var _this = this;
        this.lockMouseMove();
        this.lockFocus();
        this.allowChangeScrolling = true;
        this.raiseEvent(evt, this.getDiagramMouseEvent(evt), function (e) { return _this.eventManager.onMouseDown(e); });
        this.captureFocus();
    };
    RenderManager.prototype.onMouseMove = function (evt) {
        if (this.moveLocked)
            return;
        this.clearScrollTimer();
        if (!Evt_1.Evt.IsLeftButtonPressed(evt))
            this.allowChangeScrolling = false;
        if (this.allowChangeScrolling)
            this.changeScrollPosition(evt, false);
        this.onMouseMoveCore(evt);
    };
    RenderManager.prototype.onMouseMoveCore = function (evt) {
        var _this = this;
        this.raiseEvent(evt, this.getDiagramMouseEvent(evt), function (e) { return _this.eventManager.onMouseMove(e); });
    };
    RenderManager.prototype.onMouseUp = function (evt) {
        var _this = this;
        this.lockMouseMove();
        this.clearScrollTimer();
        this.raiseEvent(evt, this.getDiagramMouseEvent(evt), function (e) { return _this.eventManager.onMouseUp(e); });
        this.allowChangeScrolling = false;
        this.captureFocus();
    };
    RenderManager.prototype.onMouseEnter = function (evt) {
        var _this = this;
        if (Evt_1.Evt.IsLeftButtonPressed(evt)) {
            setTimeout(function () {
                _this.allowChangeScrolling = true;
            }, 500);
        }
        this.raiseEvent(evt, this.getDiagramEvent(evt), function (e) { return _this.eventManager.onMouseEnter(e); });
    };
    RenderManager.prototype.onMouseLeave = function (evt) {
        var _this = this;
        this.raiseEvent(evt, this.getDiagramEvent(evt), function (e) { return _this.eventManager.onMouseLeave(e); });
    };
    RenderManager.prototype.onDblClick = function (evt) {
        var _this = this;
        this.raiseEvent(evt, this.getDiagramMouseEvent(evt), function (e) { return _this.eventManager.onDblClick(e); });
    };
    RenderManager.prototype.onKeyDown = function (evt) {
        var _this = this;
        this.raiseEvent(evt, this.getDiagramKeyboardEvent(evt), function (e) { return _this.eventManager.onKeyDown(e); });
    };
    RenderManager.prototype.onInputBlur = function (evt) {
        var _this = this;
        if (!this.focusLocked) {
            this.focused = false;
            Base_1.RemoveClassNameFromElement(this.mainElement, "focused");
        }
        this.raiseEvent(evt, this.getDiagramInputEvent(evt), function (e) { return _this.eventManager.onInputBlur(e); });
    };
    RenderManager.prototype.onInputFocus = function (evt) {
        var _this = this;
        this.focused = true;
        this.focusLocked = false;
        Base_1.AddClassNameToElement(this.mainElement, "focused");
        this.raiseEvent(evt, this.getDiagramEvent(evt), function (e) { return _this.eventManager.onInputFocus(e); });
    };
    RenderManager.prototype.onPaste = function (evt) {
        var _this = this;
        this.raiseEvent(evt, this.getDiagramClipboardEvent(evt), function (e) { return _this.eventManager.onPaste(e); });
    };
    RenderManager.prototype.raiseEvent = function (evt, _evt, raiseFunc) {
        raiseFunc(_evt);
        if (_evt.preventDefault)
            evt.preventDefault();
    };
    RenderManager.prototype.getDiagramEvent = function (evt) {
        return new Event_1.DiagramEvent(this.getKeyModifiers(evt));
    };
    RenderManager.prototype.getDiagramInputEvent = function (evt) {
        return new Event_1.DiagramInputEvent(this.getKeyModifiers(evt), evt.srcElement.innerText);
    };
    RenderManager.prototype.getDiagramMouseEvent = function (evt) {
        var modifiers = this.getKeyModifiers(evt);
        var button = this.isLeftButtonPressed(evt) ? Event_1.MouseButton.Left : Event_1.MouseButton.Right;
        return new Event_1.DiagramMouseEvent(modifiers, button, this.getLayoutPoint(evt, true), this.getEventSource(evt));
    };
    RenderManager.prototype.getDiagramKeyboardEvent = function (evt) {
        return new Event_1.DiagramKeyboardEvent(this.getKeyModifiers(evt), Evt_1.Evt.GetKeyCode(evt), evt.srcElement.innerText); // TODO: check it
    };
    RenderManager.prototype.getDiagramClipboardEvent = function (evt) {
        var clipboardData;
        if (evt.clipboardData !== undefined)
            clipboardData = evt.clipboardData.getData('text/plain');
        else
            clipboardData = window["clipboardData"].getData('Text');
        return new Event_1.DiagramClipboardEvent(this.getKeyModifiers(evt), clipboardData);
    };
    RenderManager.prototype.isLeftButtonPressed = function (evt) {
        return !Browser_1.Browser.MSTouchUI ? Evt_1.Evt.IsLeftButtonPressed(evt) : evt.button != 2;
    };
    RenderManager.prototype.getKeyModifiers = function (evt) {
        var result = 0;
        if (evt.altKey)
            result |= KeyCode_1.ModifierKey.Alt;
        if (evt.ctrlKey)
            result |= KeyCode_1.ModifierKey.Ctrl;
        if (evt.shiftKey)
            result |= KeyCode_1.ModifierKey.Shift;
        if (evt.metaKey)
            result |= KeyCode_1.ModifierKey.Meta;
        return result;
    };
    RenderManager.prototype.getEventSource = function (evt) {
        var element = evt.srcElement;
        while (element && !this.isDocumentContainer(element)) {
            var src_1 = Utils_2.RenderUtils.getElementEventData(element);
            if (src_1 !== undefined)
                return src_1;
            element = element.parentNode;
        }
        var src = new Event_1.MouseEventSource();
        if (element && this.isDocumentContainer(element))
            src.type = Event_1.MouseEventElementType.Document;
        return src;
    };
    RenderManager.prototype.isDocumentContainer = function (element) {
        return Base_1.ElementHasCssClass(element, "dxdi-control") || Base_1.ElementHasCssClass(element, "dxdi-canvas");
    };
    RenderManager.prototype.lockMouseMove = function () {
        var _this = this;
        this.moveLocked = true;
        setTimeout(function () { return _this.moveLocked = false; }, 10); // because chrome raises 2 events on click: buttonDown and move.
    };
    RenderManager.prototype.lockFocus = function () {
        var _this = this;
        this.focusLocked = true;
        setTimeout(function () { return _this.focusLocked = false; }, 10);
    };
    RenderManager.prototype.getLayoutPoint = function (evt, checkScroll) {
        var clientX = Evt_1.Evt.GetEventX(evt);
        var clientY = Evt_1.Evt.GetEventY(evt);
        var canvasX = Base_1.GetAbsolutePositionX(this.svgElement);
        var canvasY = Base_1.GetAbsolutePositionY(this.svgElement);
        if (checkScroll) {
            if (this.scrollYVisible && canvasX + this.mainElement.offsetWidth - clientX < 0)
                return Utils_1.Point.empty();
            if (this.scrollXVisible && canvasY + this.mainElement.offsetHeight - clientY < 0)
                return Utils_1.Point.empty();
        }
        return new Utils_1.Point(UnitConverter_1.UnitConverter.pixelsToTwipsF(clientX - canvasX) / this.zoomLevel, UnitConverter_1.UnitConverter.pixelsToTwipsF(clientY - canvasY) / this.zoomLevel);
    };
    RenderManager.minPadding = 8;
    RenderManager.scrollEdge = 40;
    RenderManager.scrollRatio = 5;
    RenderManager.scrollMaxOffset = 60;
    RenderManager.scrollDelay = 100;
    RenderManager.scrollBarWidth = 16;
    return RenderManager;
}());
exports.RenderManager = RenderManager;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var TextPrimitive_1 = __webpack_require__(50);
var ClipPathPrimitive_1 = __webpack_require__(52);
var RectaglePrimitive_1 = __webpack_require__(53);
var DiagramItem_1 = __webpack_require__(3);
var UnitConverter_1 = __webpack_require__(13);
var Utils_2 = __webpack_require__(26);
var ConnectionPoint_1 = __webpack_require__(32);
exports.ShapeDefaultDimension = 1440;
exports.ShapeDefaultSize = new Utils_1.Size(exports.ShapeDefaultDimension, exports.ShapeDefaultDimension);
var ShapeDescription = /** @class */ (function () {
    function ShapeDescription(title, defualtText, defaultSize) {
        if (defaultSize === void 0) { defaultSize = exports.ShapeDefaultSize.clone(); }
        this.title = title;
        this.defualtText = defualtText;
        this.defaultSize = defaultSize;
        this.connectionPoints = this.createConnectionPoints();
        this.connectionPointsWhileSelected = this.createConnectionPointsForSelection();
    }
    Object.defineProperty(ShapeDescription.prototype, "allowHasText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    ShapeDescription.prototype.getConnectionPoints = function () {
        return this.connectionPoints;
    };
    ShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ShapeDescription.prototype.getConnectionPointsForSelection = function () {
        return this.connectionPointsWhileSelected;
    };
    ShapeDescription.prototype.createConnectionPointsForSelection = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
    };
    ShapeDescription.prototype.createParameters = function (parameters) {
    };
    ShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
    };
    ShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        throw Error("Not implemented");
    };
    ShapeDescription.prototype.changeParameterValue = function (parameters, key, change) {
        var p = parameters.get(key);
        p.value = change(p);
    };
    ShapeDescription.prototype.getParameterPoints = function (shape) {
        return [];
    };
    ShapeDescription.prototype.createTextPrimitives = function (shape, preventClipping) {
        if (!this.allowHasText || shape.text === undefined || shape.text === "")
            return [];
        var rect = this.getTextRectangle(shape.rectangle);
        var clipPathId = !preventClipping && Utils_2.RenderUtils.generateSvgElementId("clipText");
        var textPoint = this.getTextPosition(rect, shape.styleText["text-anchor"]);
        return [
            new TextPrimitive_1.TextPrimitive(textPoint.x, textPoint.y, shape.text, rect.width, shape.styleText, false, clipPathId),
            new ClipPathPrimitive_1.ClipPathPrimitive(clipPathId, [new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.width, rect.height)]),
        ];
    };
    ShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect;
    };
    ShapeDescription.prototype.createSelectorPrimitives = function (shape) {
        return [
            new RectaglePrimitive_1.RectanglePrimitive(shape.position.x, shape.position.y, shape.size.width, shape.size.height, null, "selector")
        ];
    };
    ShapeDescription.prototype.getTextPosition = function (rect, textAnchor) {
        var result = new Utils_1.Point(rect.left, rect.top + rect.height / 2);
        if (!textAnchor || textAnchor === "middle")
            result.x = rect.left + rect.width / 2;
        else if (textAnchor === "end")
            result.x = rect.left + rect.width - ShapeDescription.textSpacing;
        else if (textAnchor === "start")
            result.x = rect.left + ShapeDescription.textSpacing;
        return result;
    };
    ShapeDescription.textSpacing = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    return ShapeDescription;
}());
exports.ShapeDescription = ShapeDescription;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var RectaglePrimitive_1 = __webpack_require__(53);
var ShapeType_1 = __webpack_require__(1);
var RectangleShapeDescription = /** @class */ (function (_super) {
    __extends(RectangleShapeDescription, _super);
    function RectangleShapeDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Rectangle"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(RectangleShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Rectangle; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RectangleShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    RectangleShapeDescription.prototype.createPrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
        var primitives = [];
        return primitives.concat([
            new RectaglePrimitive_1.RectanglePrimitive(left, top, width, height, shape.style),
        ])
            .concat(this.createTextPrimitives(shape));
    };
    return RectangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.RectangleShapeDescription = RectangleShapeDescription;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RichEditUnit;
(function (RichEditUnit) {
    RichEditUnit[RichEditUnit["Centimeter"] = 0] = "Centimeter";
    RichEditUnit[RichEditUnit["Inch"] = 1] = "Inch";
})(RichEditUnit = exports.RichEditUnit || (exports.RichEditUnit = {}));
var UnitConverter = /** @class */ (function () {
    function UnitConverter() {
    }
    UnitConverter.getConverter = function (unit) {
        switch (unit) {
            case RichEditUnit.Centimeter: return new UIUnitConverterCentimeter();
            case RichEditUnit.Inch: return new UIUnitConverterInch();
            default: throw new Error();
        }
    };
    // LAYOUT - PIXELS
    // MODEL  - TWIPS
    // FORMS  - CENTIMETERS / INCHES
    // FONT   - POINTS
    // BORDER WIDTH ON UI - POINTS
    // TO TWIPS (round and no round version)
    UnitConverter.pixelsToTwips = function (value) {
        return Math.round(UnitConverter.pixelsToTwipsF(value));
    };
    UnitConverter.inchesToTwips = function (value) {
        return Math.round(UnitConverter.inchesToTwipsF(value));
    };
    UnitConverter.pointsToTwips = function (value) {
        return Math.round(UnitConverter.pointsToTwipsF(value));
    };
    UnitConverter.picasToTwips = function (value) {
        return Math.round(value * 1440 / UnitConverter.PICAS_PER_INCH);
    };
    UnitConverter.centimetersToTwips = function (value) {
        return Math.round(UnitConverter.centimetersToTwipsF(value));
    };
    UnitConverter.pixelsToTwipsF = function (value) {
        return value * 1440 / UnitConverter.DPI;
    };
    UnitConverter.inchesToTwipsF = function (value) {
        return value * 1440;
    };
    UnitConverter.pointsToTwipsF = function (value) {
        return value * 20;
    };
    UnitConverter.centimetersToTwipsF = function (value) {
        return value * 1440 / UnitConverter.CENTIMETERS_PER_INCH;
    };
    UnitConverter.modelUnitsToDegrees = function (value) {
        return value / 60000;
    };
    UnitConverter.modelUnitsToRadians = function (value) {
        return value / 60000 * Math.PI / 180;
    };
    UnitConverter.degreesToModelUnits = function (value) {
        return value * 60000;
    };
    UnitConverter.radiansToModelUnits = function (value) {
        return value * 60000 / Math.PI * 180;
    };
    UnitConverter.radiansToDegrees = function (value) {
        return value / Math.PI * 180;
    };
    UnitConverter.fdToModelUnits = function (value) {
        return Math.round(value * 1875 / 2048);
    };
    UnitConverter.emuToTwips = function (val) {
        return val / 635;
    };
    // TO PIXELS (round)
    UnitConverter.twipsToPixels = function (value) {
        return Math.round(UnitConverter.twipsToPixelsF(value));
    };
    UnitConverter.inchesToPixels = function (value) {
        return Math.round(UnitConverter.DPI * value);
    };
    UnitConverter.centimeterToPixel = function (value) {
        return Math.round(value / (UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI));
    };
    UnitConverter.pointsToPixels = function (value) {
        return Math.round(value * UnitConverter.DPI / 72);
    };
    // TO PIXELS (no round)
    UnitConverter.pointsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 72;
    };
    UnitConverter.twipsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 1440;
    };
    // TO POINTS (round)
    UnitConverter.pixelsToPoints = function (value) {
        return Math.round(value * 72 / UnitConverter.DPI);
    };
    UnitConverter.twipsToPoints = function (value) {
        return Math.round(this.twipsToPointsF(value));
    };
    // TO POINTS (no round)
    UnitConverter.twipsToPointsF = function (value) {
        return value / 20;
    };
    // TO INCHES (no round)
    UnitConverter.twipsToInches = function (value) {
        return value / 1440;
    };
    UnitConverter.pixelsToInches = function (value) {
        return value / UnitConverter.DPI;
    };
    // TO CENTIMETERS (no round)
    UnitConverter.twipsToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / 1440;
    };
    UnitConverter.pixelToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI;
    };
    // ANOTHER
    UnitConverter.hundredthsOfMillimeterToModelUnits = function (value) {
        return 15 * value / 127;
    };
    UnitConverter.twipsToEmu = function (val) {
        return val * 635;
    };
    UnitConverter.twipsToDegree = function (value) {
        return value / 60000;
    };
    UnitConverter.DPI = 96;
    UnitConverter.CENTIMETERS_PER_INCH = 2.54;
    UnitConverter.PICAS_PER_INCH = 6;
    return UnitConverter;
}());
exports.UnitConverter = UnitConverter;
var UIUnitConverterCentimeter = /** @class */ (function (_super) {
    __extends(UIUnitConverterCentimeter, _super);
    function UIUnitConverterCentimeter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIUnitConverterCentimeter.prototype.getUnits = function () {
        return RichEditUnit.Centimeter;
    };
    UIUnitConverterCentimeter.prototype.twipsToUI = function (value) {
        return UnitConverter.twipsToCentimeters(value);
    };
    UIUnitConverterCentimeter.prototype.UIToTwips = function (value) {
        return UnitConverter.centimetersToTwips(value);
    };
    return UIUnitConverterCentimeter;
}(UnitConverter));
exports.UIUnitConverterCentimeter = UIUnitConverterCentimeter;
var UIUnitConverterInch = /** @class */ (function (_super) {
    __extends(UIUnitConverterInch, _super);
    function UIUnitConverterInch() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIUnitConverterInch.prototype.getUnits = function () {
        return RichEditUnit.Inch;
    };
    UIUnitConverterInch.prototype.twipsToUI = function (value) {
        return UnitConverter.twipsToInches(value);
    };
    UIUnitConverterInch.prototype.UIToTwips = function (value) {
        return UnitConverter.inchesToTwips(value);
    };
    return UIUnitConverterInch;
}(UnitConverter));
exports.UIUnitConverterInch = UIUnitConverterInch;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseButton;
(function (MouseButton) {
    MouseButton[MouseButton["None"] = 0] = "None";
    MouseButton[MouseButton["Left"] = 1] = "Left";
    MouseButton[MouseButton["Right"] = 2] = "Right";
    MouseButton[MouseButton["Middle"] = 4] = "Middle";
})(MouseButton = exports.MouseButton || (exports.MouseButton = {}));
var MouseEventElementType;
(function (MouseEventElementType) {
    MouseEventElementType[MouseEventElementType["Undefined"] = 0] = "Undefined";
    MouseEventElementType[MouseEventElementType["Connector"] = 1] = "Connector";
    MouseEventElementType[MouseEventElementType["ConnectorPoint"] = 2] = "ConnectorPoint";
    MouseEventElementType[MouseEventElementType["ConnectorSide"] = 3] = "ConnectorSide";
    MouseEventElementType[MouseEventElementType["ConnectorOrthogonalSide"] = 4] = "ConnectorOrthogonalSide";
    MouseEventElementType[MouseEventElementType["ConnectorText"] = 5] = "ConnectorText";
    MouseEventElementType[MouseEventElementType["Shape"] = 6] = "Shape";
    MouseEventElementType[MouseEventElementType["ShapeResizeBox"] = 7] = "ShapeResizeBox";
    MouseEventElementType[MouseEventElementType["ShapeParameterBox"] = 8] = "ShapeParameterBox";
    MouseEventElementType[MouseEventElementType["SelectionRect"] = 9] = "SelectionRect";
    MouseEventElementType[MouseEventElementType["ShapeConnectionPoint"] = 10] = "ShapeConnectionPoint";
    MouseEventElementType[MouseEventElementType["ShapeConnection"] = 11] = "ShapeConnection";
    MouseEventElementType[MouseEventElementType["Document"] = 12] = "Document";
})(MouseEventElementType = exports.MouseEventElementType || (exports.MouseEventElementType = {}));
var MouseEventSource = /** @class */ (function () {
    function MouseEventSource(type, key, value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }
    return MouseEventSource;
}());
exports.MouseEventSource = MouseEventSource;
var ResizeEventSource;
(function (ResizeEventSource) {
    ResizeEventSource[ResizeEventSource["Undefined"] = 0] = "Undefined";
    ResizeEventSource[ResizeEventSource["ResizeBox_NW"] = 1] = "ResizeBox_NW";
    ResizeEventSource[ResizeEventSource["ResizeBox_NE"] = 2] = "ResizeBox_NE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SE"] = 3] = "ResizeBox_SE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SW"] = 4] = "ResizeBox_SW";
    ResizeEventSource[ResizeEventSource["ResizeBox_N"] = 5] = "ResizeBox_N";
    ResizeEventSource[ResizeEventSource["ResizeBox_E"] = 6] = "ResizeBox_E";
    ResizeEventSource[ResizeEventSource["ResizeBox_S"] = 7] = "ResizeBox_S";
    ResizeEventSource[ResizeEventSource["ResizeBox_W"] = 8] = "ResizeBox_W";
})(ResizeEventSource = exports.ResizeEventSource || (exports.ResizeEventSource = {}));
var DiagramEvent = /** @class */ (function () {
    function DiagramEvent(modifiers) {
        this.modifiers = modifiers;
    }
    return DiagramEvent;
}());
exports.DiagramEvent = DiagramEvent;
var DiagramInputEvent = /** @class */ (function (_super) {
    __extends(DiagramInputEvent, _super);
    function DiagramInputEvent(modifiers, inputText) {
        var _this = _super.call(this, modifiers) || this;
        _this.inputText = inputText;
        return _this;
    }
    return DiagramInputEvent;
}(DiagramEvent));
exports.DiagramInputEvent = DiagramInputEvent;
var DiagramMouseEvent = /** @class */ (function (_super) {
    __extends(DiagramMouseEvent, _super);
    function DiagramMouseEvent(modifiers, button, layoutPoint, source) {
        var _this = _super.call(this, modifiers) || this;
        _this.button = button;
        _this.layoutPoint = layoutPoint;
        _this.source = source;
        _this.scrollX = 0;
        _this.scrollY = 0;
        return _this;
    }
    return DiagramMouseEvent;
}(DiagramEvent));
exports.DiagramMouseEvent = DiagramMouseEvent;
var DiagramKeyboardEvent = /** @class */ (function (_super) {
    __extends(DiagramKeyboardEvent, _super);
    function DiagramKeyboardEvent(modifiers, keyCode, inputText) {
        var _this = _super.call(this, modifiers, inputText) || this;
        _this.keyCode = keyCode;
        return _this;
    }
    DiagramKeyboardEvent.prototype.getShortcutCode = function () {
        return this.modifiers | this.keyCode;
    };
    return DiagramKeyboardEvent;
}(DiagramInputEvent));
exports.DiagramKeyboardEvent = DiagramKeyboardEvent;
var DiagramClipboardEvent = /** @class */ (function (_super) {
    __extends(DiagramClipboardEvent, _super);
    function DiagramClipboardEvent(modifiers, clipboardData) {
        var _this = _super.call(this, modifiers) || this;
        _this.clipboardData = clipboardData;
        return _this;
    }
    return DiagramClipboardEvent;
}(DiagramEvent));
exports.DiagramClipboardEvent = DiagramClipboardEvent;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var Utils_1 = __webpack_require__(26);
var SvgPrimitive = /** @class */ (function () {
    function SvgPrimitive(style, className, clipPathId, onApplyProperties) {
        this.style = style;
        this.className = className;
        this.clipPathId = clipPathId;
        this.onApplyProperties = onApplyProperties;
        this.children = [];
    }
    SvgPrimitive.prototype.createElement = function () {
        var el = this.createMainElement();
        this.createChildElements(el);
        return el;
    };
    SvgPrimitive.prototype.createChildElements = function (parent) {
        for (var i = 0; i < this.children.length; i++)
            parent.appendChild(this.children[i].createElement());
    };
    SvgPrimitive.prototype.applyElementProperties = function (element) {
        this.applyElementStyleProperties(element);
        if (this.className)
            element.setAttribute("class", this.className);
        if (this.clipPathId)
            element.setAttribute("clip-path", "url(#" + this.clipPathId + ")");
        if (this.onApplyProperties)
            this.onApplyProperties(element);
        this.applyChildrenProperties(element);
    };
    SvgPrimitive.prototype.applyChildrenProperties = function (element) {
        for (var i = 0; i < this.children.length; i++)
            this.children[i].applyElementProperties(element.childNodes[i]);
    };
    SvgPrimitive.prototype.applyElementStyleProperties = function (element) {
        this.applyElementStylePropertiesCore(element);
    };
    SvgPrimitive.prototype.applyElementStylePropertiesCore = function (element, reverseTextAnchor) {
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        if (this.style)
            Utils_1.RenderUtils.applyStyleToElement(this.style, element, reverseTextAnchor);
    };
    SvgPrimitive.prototype.setUnitAttribute = function (element, key, value) {
        if (value === undefined || value === null)
            return;
        var valueStr = typeof value === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(value).toString() : value;
        element.setAttribute(key, valueStr);
    };
    return SvgPrimitive;
}());
exports.SvgPrimitive = SvgPrimitive;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ModifierKey;
(function (ModifierKey) {
    ModifierKey[ModifierKey["None"] = 0] = "None";
    ModifierKey[ModifierKey["Ctrl"] = 65536] = "Ctrl";
    ModifierKey[ModifierKey["Shift"] = 262144] = "Shift";
    ModifierKey[ModifierKey["Alt"] = 1048576] = "Alt";
    ModifierKey[ModifierKey["Meta"] = 16777216] = "Meta";
})(ModifierKey = exports.ModifierKey || (exports.ModifierKey = {}));
var KeyCode;
(function (KeyCode) {
    KeyCode[KeyCode["Backspace"] = 8] = "Backspace";
    KeyCode[KeyCode["Tab"] = 9] = "Tab";
    KeyCode[KeyCode["Enter"] = 13] = "Enter";
    KeyCode[KeyCode["Pause"] = 19] = "Pause";
    KeyCode[KeyCode["CapsLock"] = 20] = "CapsLock";
    KeyCode[KeyCode["Esc"] = 27] = "Esc";
    KeyCode[KeyCode["Space"] = 32] = "Space";
    KeyCode[KeyCode["PageUp"] = 33] = "PageUp";
    KeyCode[KeyCode["PageDown"] = 34] = "PageDown";
    KeyCode[KeyCode["End"] = 35] = "End";
    KeyCode[KeyCode["Home"] = 36] = "Home";
    KeyCode[KeyCode["Left"] = 37] = "Left";
    KeyCode[KeyCode["Up"] = 38] = "Up";
    KeyCode[KeyCode["Right"] = 39] = "Right";
    KeyCode[KeyCode["Down"] = 40] = "Down";
    KeyCode[KeyCode["Insert"] = 45] = "Insert";
    KeyCode[KeyCode["Delete"] = 46] = "Delete";
    KeyCode[KeyCode["Key_0"] = 48] = "Key_0";
    KeyCode[KeyCode["Key_1"] = 49] = "Key_1";
    KeyCode[KeyCode["Key_2"] = 50] = "Key_2";
    KeyCode[KeyCode["Key_3"] = 51] = "Key_3";
    KeyCode[KeyCode["Key_4"] = 52] = "Key_4";
    KeyCode[KeyCode["Key_5"] = 53] = "Key_5";
    KeyCode[KeyCode["Key_6"] = 54] = "Key_6";
    KeyCode[KeyCode["Key_7"] = 55] = "Key_7";
    KeyCode[KeyCode["Key_8"] = 56] = "Key_8";
    KeyCode[KeyCode["Key_9"] = 57] = "Key_9";
    KeyCode[KeyCode["Key_a"] = 65] = "Key_a";
    KeyCode[KeyCode["Key_b"] = 66] = "Key_b";
    KeyCode[KeyCode["Key_c"] = 67] = "Key_c";
    KeyCode[KeyCode["Key_d"] = 68] = "Key_d";
    KeyCode[KeyCode["Key_e"] = 69] = "Key_e";
    KeyCode[KeyCode["Key_f"] = 70] = "Key_f";
    KeyCode[KeyCode["Key_g"] = 71] = "Key_g";
    KeyCode[KeyCode["Key_h"] = 72] = "Key_h";
    KeyCode[KeyCode["Key_i"] = 73] = "Key_i";
    KeyCode[KeyCode["Key_j"] = 74] = "Key_j";
    KeyCode[KeyCode["Key_k"] = 75] = "Key_k";
    KeyCode[KeyCode["Key_l"] = 76] = "Key_l";
    KeyCode[KeyCode["Key_m"] = 77] = "Key_m";
    KeyCode[KeyCode["Key_n"] = 78] = "Key_n";
    KeyCode[KeyCode["Key_o"] = 79] = "Key_o";
    KeyCode[KeyCode["Key_p"] = 80] = "Key_p";
    KeyCode[KeyCode["Key_q"] = 81] = "Key_q";
    KeyCode[KeyCode["Key_r"] = 82] = "Key_r";
    KeyCode[KeyCode["Key_s"] = 83] = "Key_s";
    KeyCode[KeyCode["Key_t"] = 84] = "Key_t";
    KeyCode[KeyCode["Key_u"] = 85] = "Key_u";
    KeyCode[KeyCode["Key_v"] = 86] = "Key_v";
    KeyCode[KeyCode["Key_w"] = 87] = "Key_w";
    KeyCode[KeyCode["Key_x"] = 88] = "Key_x";
    KeyCode[KeyCode["Key_y"] = 89] = "Key_y";
    KeyCode[KeyCode["Key_z"] = 90] = "Key_z";
    KeyCode[KeyCode["Windows"] = 91] = "Windows";
    KeyCode[KeyCode["ContextMenu"] = 93] = "ContextMenu";
    KeyCode[KeyCode["Numpad_0"] = 96] = "Numpad_0";
    KeyCode[KeyCode["Numpad_1"] = 97] = "Numpad_1";
    KeyCode[KeyCode["Numpad_2"] = 98] = "Numpad_2";
    KeyCode[KeyCode["Numpad_3"] = 99] = "Numpad_3";
    KeyCode[KeyCode["Numpad_4"] = 100] = "Numpad_4";
    KeyCode[KeyCode["Numpad_5"] = 101] = "Numpad_5";
    KeyCode[KeyCode["Numpad_6"] = 102] = "Numpad_6";
    KeyCode[KeyCode["Numpad_7"] = 103] = "Numpad_7";
    KeyCode[KeyCode["Numpad_8"] = 104] = "Numpad_8";
    KeyCode[KeyCode["Numpad_9"] = 105] = "Numpad_9";
    KeyCode[KeyCode["Multiply"] = 106] = "Multiply";
    KeyCode[KeyCode["Add"] = 107] = "Add";
    KeyCode[KeyCode["Subtract"] = 109] = "Subtract";
    KeyCode[KeyCode["Decimal"] = 110] = "Decimal";
    KeyCode[KeyCode["Divide"] = 111] = "Divide";
    KeyCode[KeyCode["F1"] = 112] = "F1";
    KeyCode[KeyCode["F2"] = 113] = "F2";
    KeyCode[KeyCode["F3"] = 114] = "F3";
    KeyCode[KeyCode["F4"] = 115] = "F4";
    KeyCode[KeyCode["F5"] = 116] = "F5";
    KeyCode[KeyCode["F6"] = 117] = "F6";
    KeyCode[KeyCode["F7"] = 118] = "F7";
    KeyCode[KeyCode["F8"] = 119] = "F8";
    KeyCode[KeyCode["F9"] = 120] = "F9";
    KeyCode[KeyCode["F10"] = 121] = "F10";
    KeyCode[KeyCode["F11"] = 122] = "F11";
    KeyCode[KeyCode["F12"] = 123] = "F12";
    KeyCode[KeyCode["NumLock"] = 144] = "NumLock";
    KeyCode[KeyCode["ScrollLock"] = 145] = "ScrollLock";
    KeyCode[KeyCode["Semicolon"] = 186] = "Semicolon";
    KeyCode[KeyCode["Equals"] = 187] = "Equals";
    KeyCode[KeyCode["Comma"] = 188] = "Comma";
    KeyCode[KeyCode["Dash"] = 189] = "Dash";
    KeyCode[KeyCode["Period"] = 190] = "Period";
    KeyCode[KeyCode["ForwardSlash"] = 191] = "ForwardSlash";
    KeyCode[KeyCode["GraveAccent"] = 192] = "GraveAccent";
    KeyCode[KeyCode["OpenBracket"] = 219] = "OpenBracket";
    KeyCode[KeyCode["BackSlash"] = 220] = "BackSlash";
    KeyCode[KeyCode["CloseBracket"] = 221] = "CloseBracket";
    KeyCode[KeyCode["SingleQuote"] = 222] = "SingleQuote";
})(KeyCode = exports.KeyCode || (exports.KeyCode = {}));


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeParameterPoint = /** @class */ (function () {
    function ShapeParameterPoint(key, point) {
        this.key = key;
        this.point = point;
    }
    return ShapeParameterPoint;
}());
exports.ShapeParameterPoint = ShapeParameterPoint;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var LayoutSettings = /** @class */ (function () {
    function LayoutSettings(gridSize) {
        this.orientation = OrientationKind.Vertical;
        this.direction = LogicalDirectionKind.Forward;
        this.componentSpacing = (gridSize && gridSize * 2 > 800) ? gridSize * 2 : 800;
        var offset = (gridSize && gridSize > Connector_1.Connector.minOffset) ? gridSize : Connector_1.Connector.minOffset;
        this.layerSpacing = offset * 2;
        this.columnSpacing = offset;
    }
    return LayoutSettings;
}());
exports.LayoutSettings = LayoutSettings;
var TreeLayoutSettings = /** @class */ (function (_super) {
    __extends(TreeLayoutSettings, _super);
    function TreeLayoutSettings(gridSize) {
        var _this = _super.call(this, gridSize) || this;
        _this.alignment = Alignment.Center;
        _this.subTreeColumnSpacing = _this.componentSpacing / 2;
        return _this;
    }
    return TreeLayoutSettings;
}(LayoutSettings));
exports.TreeLayoutSettings = TreeLayoutSettings;
var LogicalDirectionKind;
(function (LogicalDirectionKind) {
    LogicalDirectionKind[LogicalDirectionKind["Backward"] = 0] = "Backward";
    LogicalDirectionKind[LogicalDirectionKind["Forward"] = 1] = "Forward";
})(LogicalDirectionKind = exports.LogicalDirectionKind || (exports.LogicalDirectionKind = {}));
var OrientationKind;
(function (OrientationKind) {
    OrientationKind[OrientationKind["Horizontal"] = 0] = "Horizontal";
    OrientationKind[OrientationKind["Vertical"] = 1] = "Vertical";
})(OrientationKind = exports.OrientationKind || (exports.OrientationKind = {}));
var Alignment;
(function (Alignment) {
    Alignment[Alignment["Left"] = 0] = "Left";
    Alignment[Alignment["Center"] = 1] = "Center";
})(Alignment = exports.Alignment || (exports.Alignment = {}));


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(20);
var Data_1 = __webpack_require__(102);
var Str_1 = __webpack_require__(103);
var Attr_1 = __webpack_require__(104);
var KeyCode_1 = __webpack_require__(16);
var Evt_1 = __webpack_require__(49);
function IsExists(obj) {
    return (typeof (obj) != "undefined") && (obj != null);
}
exports.IsExists = IsExists;
function IsNumber(str) {
    return !isNaN(parseFloat(str)) && isFinite(str);
}
exports.IsNumber = IsNumber;
;
function SetStyles(element, styles, makeImportant) {
    if (IsExists(styles.cssText))
        element.style.cssText = styles.cssText;
    if (IsExists(styles.className))
        element.className = styles.className;
    for (var property in styles) {
        if (!styles.hasOwnProperty(property))
            continue;
        var value = styles[property];
        switch (property) {
            case "cssText":
            case "className":
                break;
            case "float":
                SetElementFloat(element, value);
                break;
            case "opacity":
                SetElementOpacity(element, value);
                break;
            case "zIndex":
                SetStylesCore(element, property, value, makeImportant);
                break;
            /*jshint -W086 */
            case "fontWeight":
                if (Browser_1.Browser.IE && Browser_1.Browser.Version < 9 && typeof (styles[property]) == "number")
                    value = styles[property].toString();
            default:
                SetStylesCore(element, property, value + (typeof (value) == "number" ? "px" : ""), makeImportant);
            /*jshint +W086 */
        }
    }
}
exports.SetStyles = SetStyles;
;
function SetStylesCore(element, property, value, makeImportant) {
    if (makeImportant) {
        var index = property.search("[A-Z]");
        if (index != -1)
            property = property.replace(property.charAt(index), "-" + property.charAt(index).toLowerCase());
        if (element.style.setProperty)
            element.style.setProperty(property, value, "important");
        else
            element.style.cssText += ";" + property + ":" + value + "!important";
    }
    else
        element.style[property] = value;
}
exports.SetStylesCore = SetStylesCore;
function GetDocumentScrollTop() {
    var isScrollBodyIE = Browser_1.Browser.IE && GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollTop > 0;
    if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge || isScrollBodyIE) {
        if (Browser_1.Browser.MacOSMobilePlatform) //B157267
            return window.pageYOffset;
        if (Browser_1.Browser.WebKitFamily)
            return document.documentElement.scrollTop || document.body.scrollTop;
        return document.body.scrollTop;
    }
    else
        return document.documentElement.scrollTop;
}
exports.GetDocumentScrollTop = GetDocumentScrollTop;
function CloneObject(srcObject) {
    if (typeof (srcObject) != 'object' || srcObject == null)
        return srcObject;
    var newObject = {};
    /* jshint ignore:start */
    for (var i in srcObject)
        newObject[i] = srcObject[i];
    /* jshint ignore:end */
    return newObject;
}
exports.CloneObject = CloneObject;
function GetCurrentStyle(element) {
    if (element.currentStyle)
        return element.currentStyle;
    else if (document.defaultView && document.defaultView.getComputedStyle) {
        var result = document.defaultView.getComputedStyle(element, null);
        if (!result && Browser_1.Browser.Firefox && window.frameElement) {
            var changes = [];
            var curElement = window.frameElement;
            while (!(result = document.defaultView.getComputedStyle(element, null))) {
                changes.push([curElement, curElement.style.display]);
                SetStylesCore(curElement, "display", "block", true);
                curElement = curElement.tagName == "BODY" ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
            }
            result = CloneObject(result);
            for (var ch, i = 0; ch = changes[i]; i++)
                SetStylesCore(ch[0], "display", ch[1], false);
            document.body.offsetWidth; //T334387
        }
        return result;
    }
    return window.getComputedStyle(element, null);
}
exports.GetCurrentStyle = GetCurrentStyle;
function GetDocumentScrollLeft() {
    var isScrollBodyIE = Browser_1.Browser.IE && GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollLeft > 0;
    if (Browser_1.Browser.Edge || isScrollBodyIE)
        return document.body ? document.body.scrollLeft : document.documentElement.scrollLeft;
    if (Browser_1.Browser.WebKitFamily)
        return document.documentElement.scrollLeft || document.body.scrollLeft;
    return document.documentElement.scrollLeft;
}
exports.GetDocumentScrollLeft = GetDocumentScrollLeft;
exports.focusedElement = null;
function GetFocusedElement() {
    var activeElement = GetActiveElement();
    return activeElement ? activeElement : exports.focusedElement;
}
exports.GetFocusedElement = GetFocusedElement;
function GetActiveElement() {
    try {
        return document.activeElement;
    }
    catch (e) {
        return null;
    }
}
exports.GetActiveElement = GetActiveElement;
;
function focusCore(element, selectAction) {
    try {
        element.focus();
        if (Browser_1.Browser.IE && document.activeElement != element)
            element.focus();
        // Q339238
        if (selectAction) {
            var currentSelection = Selection.GetInfo(element);
            // apply selection only if there is no selection present already
            if (currentSelection.startPos == currentSelection.endPos) {
                switch (selectAction) {
                    case "start":
                        Selection.SetCaretPosition(element, 0);
                        break;
                    case "all":
                        Selection.Set(element);
                        break;
                }
            }
        }
    }
    catch (e) {
    }
}
function SetFocus(element, selectAction) {
    if (Browser_1.Browser.MacOSMobilePlatform) // Q471191
        focusCore(element, selectAction);
    else {
        window.setTimeout(function () {
            focusCore(element, selectAction);
        }, 100);
    }
}
exports.SetFocus = SetFocus;
function GetIsParent(parentElement, element) {
    if (!parentElement || !element)
        return false;
    while (element) {
        if (element === parentElement)
            return true;
        if (element.tagName === "BODY")
            return false;
        element = element.parentNode;
    }
    return false;
}
exports.GetIsParent = GetIsParent;
function ElementContainsCssClass(element, className) {
    //B187659
    try {
        if (!element.className)
            return false;
        return element.className.indexOf(className) != -1;
    }
    catch (e) {
        return false;
    }
}
exports.ElementContainsCssClass = ElementContainsCssClass;
function AddClassNameToElement(element, className) {
    if (!element || typeof (className) !== "string")
        return;
    className = className.trim();
    if (!ElementHasCssClass(element, className) && className !== "")
        element.className = (element.className === "") ? className : element.className + " " + className;
}
exports.AddClassNameToElement = AddClassNameToElement;
function ElementHasCssClass(element, className) {
    //B220674
    try {
        var elementClasses;
        var classList = element.classList;
        if (!classList) {
            if (!element.className)
                return false;
            elementClasses = element.className.split(" ");
        }
        var classNames = className.split(" ");
        for (var i = classNames.length - 1; i >= 0; i--) {
            if (classList) {
                if (!classList.contains(classNames[i]))
                    return false;
                continue;
            }
            if (Data_1.Data.ArrayIndexOf(elementClasses, classNames[i]) < 0)
                return false;
        }
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.ElementHasCssClass = ElementHasCssClass;
function RemoveClassNameFromElement(element, className) {
    if (!element)
        return;
    var updClassName = " " + element.className + " ";
    var newClassName = updClassName.replace(" " + className + " ", " ");
    if (updClassName.length != newClassName.length)
        element.className = Str_1.Str.Trim(newClassName);
}
exports.RemoveClassNameFromElement = RemoveClassNameFromElement;
function GetAbsolutePositionY(element) {
    if (Browser_1.Browser.IE)
        return getAbsolutePositionY_IE(element);
    else if (Browser_1.Browser.Firefox && Browser_1.Browser.Version >= 3)
        return getAbsolutePositionY_FF3(element);
    else if (Browser_1.Browser.Opera)
        return getAbsolutePositionY_Opera(element);
    else if (Browser_1.Browser.NetscapeFamily && (!Browser_1.Browser.Firefox || Browser_1.Browser.Version < 3))
        return getAbsolutePositionY_NS(element);
    else if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge)
        return getAbsolutePositionY_FF3(element);
    else
        return getAbsolutePositionY_Other(element);
}
exports.GetAbsolutePositionY = GetAbsolutePositionY;
function getAbsolutePositionY_Opera(curEl) {
    var isFirstCycle = true;
    if (curEl && curEl.tagName == "TR" && curEl.cells.length > 0)
        curEl = curEl.cells[0];
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle)
            pos -= curEl.scrollTop;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollTop;
    return pos;
}
function getAbsolutePositionY_IE(element) {
    if (element == null || Browser_1.Browser.IE && element.parentNode == null)
        return 0; // B96664
    return element.getBoundingClientRect().top + GetDocumentScrollTop();
}
function getAbsolutePositionY_FF3(element) {
    if (element == null)
        return 0;
    var y = element.getBoundingClientRect().top + GetDocumentScrollTop();
    return Math.round(y);
}
function getAbsolutePositionY_NS(curEl) {
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        if (!isFirstCycle && Browser_1.Browser.Firefox) {
            var style = GetCurrentStyle(curEl);
            if (curEl.tagName == "DIV" && style.overflow != "visible")
                pos += PxToInt(style.borderTopWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsolutePositionY_Other(curEl) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        if (curEl.tagName == "BODY")
            break;
        var style = GetCurrentStyle(curEl);
        if (style.position == "absolute")
            break;
        if (!isFirstCycle && curEl.tagName == "DIV" && (style.position == "" || style.position == "static"))
            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        curEl = curEl.parentNode;
        isFirstCycle = false;
    }
    return pos;
}
function PxToInt(px) {
    return pxToNumber(px, parseInt);
}
exports.PxToInt = PxToInt;
;
function PxToFloat(px) {
    return pxToNumber(px, parseFloat);
}
exports.PxToFloat = PxToFloat;
;
function pxToNumber(px, parseFunction) {
    var result = 0;
    if (px != null && px != "") {
        try {
            var indexOfPx = px.indexOf("px");
            if (indexOfPx > -1)
                result = parseFunction(px.substr(0, indexOfPx));
        }
        catch (e) { }
    }
    return result;
}
//function GetAbsolutePositionX(element: HTMLElement): number;
function GetAbsolutePositionX(element) {
    if (Browser_1.Browser.IE)
        return getAbsolutePositionX_IE(element);
    else if (Browser_1.Browser.Firefox && Browser_1.Browser.Version >= 3)
        return getAbsolutePositionX_FF3(element);
    else if (Browser_1.Browser.Opera)
        return getAbsolutePositionX_Opera(element);
    else if (Browser_1.Browser.NetscapeFamily && (!Browser_1.Browser.Firefox || Browser_1.Browser.Version < 3))
        return getAbsolutePositionX_NS(element);
    else if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge)
        return getAbsolutePositionX_FF3(element);
    else
        return getAbsolutePositionX_Other(element);
}
exports.GetAbsolutePositionX = GetAbsolutePositionX;
function getAbsolutePositionX_Opera(curEl) {
    var isFirstCycle = true;
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle)
            pos -= curEl.scrollLeft;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollLeft;
    return pos;
}
function getAbsolutePositionX_IE(element) {
    if (element == null || Browser_1.Browser.IE && element.parentNode == null)
        return 0; // B96664
    return element.getBoundingClientRect().left + GetDocumentScrollLeft();
}
function getAbsolutePositionX_FF3(element) {
    if (element == null)
        return 0;
    var x = element.getBoundingClientRect().left + GetDocumentScrollLeft();
    return Math.round(x);
}
function getAbsolutePositionX_NS(curEl) {
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        if (!isFirstCycle && Browser_1.Browser.Firefox) {
            var style = GetCurrentStyle(curEl);
            if (curEl.tagName == "DIV" && style.overflow != "visible")
                pos += PxToInt(style.borderLeftWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsolutePositionX_Other(curEl) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function SetAbsoluteX(element, x) {
    element.style.left = prepareClientPosForElement(x, element, true) + "px";
}
exports.SetAbsoluteX = SetAbsoluteX;
;
function SetAbsoluteY(element, y) {
    element.style.top = prepareClientPosForElement(y, element, false) + "px";
}
exports.SetAbsoluteY = SetAbsoluteY;
;
function prepareClientPosForElement(pos, element, isX) {
    pos -= getPositionElementOffset(element, isX);
    return pos;
}
;
function getPositionElementOffset(element, isX) {
    var div = createElementMock(element);
    if (div.style.position == "static")
        div.style.position = "absolute";
    element.parentNode.appendChild(div);
    var realPos = isX ? GetAbsolutePositionX(div) : GetAbsolutePositionY(div);
    element.parentNode.removeChild(div);
    return Math.round(realPos);
}
;
function createElementMock(element) {
    var div = document.createElement('DIV');
    div.style.top = "0px";
    div.style.left = "0px";
    div.style.visibility = "hidden";
    div.style.position = GetCurrentStyle(element).position;
    return div;
}
function IsPercentageSize(size) {
    return size && size.indexOf('%') != -1;
}
exports.IsPercentageSize = IsPercentageSize;
;
function GetChildNodes(parent, predicate) {
    return RetrieveByPredicate(parent.childNodes, predicate);
}
exports.GetChildNodes = GetChildNodes;
;
function GetNodes(parent, predicate) {
    var c = parent.all || parent.getElementsByTagName('*');
    return RetrieveByPredicate(c, predicate);
}
exports.GetNodes = GetNodes;
;
function RetrieveByPredicate(scourceCollection, predicate) {
    var result = [];
    for (var i = 0; i < scourceCollection.length; i++) {
        var element = scourceCollection[i];
        if (!predicate || predicate(element))
            result.push(element);
    }
    return result;
}
exports.RetrieveByPredicate = RetrieveByPredicate;
;
function GetChildNodesByClassName(parent, className) {
    if (!parent)
        return [];
    if (parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);
        return nodeListToArray(children, function (element) {
            return element.parentNode === parent;
        });
    }
    return GetChildNodes(parent, function (elem) { return elem.className && ElementHasCssClass(elem, className); });
}
exports.GetChildNodesByClassName = GetChildNodesByClassName;
function nodeListToArray(nodeList, filter) {
    var result = [];
    for (var i = 0, element; element = nodeList[i]; i++) {
        if (filter && !filter(element))
            continue;
        result.push(element);
    }
    return result;
}
function GetNodesByClassName(parent, className) {
    if (parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);
        return nodeListToArray(children, null);
    }
    return GetNodes(parent, function (elem) { return elem.className && ElementHasCssClass(elem, className); });
}
exports.GetNodesByClassName = GetNodesByClassName;
function GetParentByClassName(element, className) {
    while (element != null) {
        if (element.tagName == "BODY" || element.nodeName == "#document")
            return null;
        if (ElementContainsCssClass(element, className))
            return element;
        element = element.parentNode;
    }
    return null;
}
exports.GetParentByClassName = GetParentByClassName;
function GetParentByTagName(element, tagName) {
    tagName = tagName.toUpperCase();
    while (element) {
        if (element.tagName === "BODY")
            return null;
        if (element.tagName === tagName)
            return element;
        element = element.parentNode;
    }
    return null;
}
exports.GetParentByTagName = GetParentByTagName;
var html2PlainTextFilter = null;
function setInnerHtmlInternal(el, trustedHtmlString) {
    el.innerHTML = trustedHtmlString;
}
exports.setInnerHtmlInternal = setInnerHtmlInternal;
function SetElementDisplay(element, value, checkCurrentStyle, makeInline) {
    if (!element)
        return;
    if (typeof (value) === "string")
        element.style.display = value;
    else if (!value)
        element.style.display = "none";
    else {
        element.style.display = "";
        if (checkCurrentStyle && GetCurrentStyle(element).display === "none") {
            var displayAddon = makeInline ? "inline-" : "";
            switch (element.tagName) {
                case "TABLE": {
                    element.style.display = displayAddon + "table";
                    break;
                }
                default: {
                    element.style.display = displayAddon + "block";
                    break;
                }
            }
        }
    }
}
exports.SetElementDisplay = SetElementDisplay;
function GetInnerText(container) {
    if (Browser_1.Browser.Safari && Browser_1.Browser.MajorVersion <= 5) {
        var filter = getHtml2PlainTextFilter();
        setInnerHtmlInternal(filter, container.innerHTML);
        SetElementDisplay(filter, true, false, false);
        var innerText = filter.innerText;
        SetElementDisplay(filter, false, false, false);
        return innerText;
    }
    else if (Browser_1.Browser.NetscapeFamily || Browser_1.Browser.WebKitFamily || (Browser_1.Browser.IE && Browser_1.Browser.Version >= 9) || Browser_1.Browser.Edge) {
        return container.textContent;
    }
    else
        return container.innerText;
}
exports.GetInnerText = GetInnerText;
function getHtml2PlainTextFilter() {
    if (html2PlainTextFilter == null) {
        html2PlainTextFilter = document.createElement("DIV");
        html2PlainTextFilter.style.width = "0";
        html2PlainTextFilter.style.height = "0";
        html2PlainTextFilter.style.overflow = "visible";
        SetElementDisplay(html2PlainTextFilter, false, false, false);
        document.body.appendChild(html2PlainTextFilter);
    }
    return html2PlainTextFilter;
}
var verticalScrollBarWidth;
function GetVerticalScrollBarWidth() {
    if (typeof (verticalScrollBarWidth) == "undefined") {
        var container = document.createElement("DIV");
        container.style.cssText = "position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box";
        document.body.appendChild(container);
        var child = document.createElement("P");
        container.appendChild(child);
        child.style.cssText = "width: 100%; height: 200px;";
        var widthWithoutScrollBar = child.offsetWidth;
        container.style.overflow = "scroll";
        var widthWithScrollBar = child.offsetWidth;
        if (widthWithoutScrollBar == widthWithScrollBar)
            widthWithScrollBar = container.clientWidth;
        verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
        document.body.removeChild(container);
    }
    return verticalScrollBarWidth;
}
exports.GetVerticalScrollBarWidth = GetVerticalScrollBarWidth;
function GetHorizontalBordersWidth(element, style) {
    if (!IsExists(style))
        style = (Browser_1.Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : GetCurrentStyle(element);
    var res = 0;
    if (style.borderLeftStyle != "none")
        res += PxToFloat(style.borderLeftWidth);
    if (style.borderRightStyle != "none")
        res += PxToFloat(style.borderRightWidth);
    return res;
}
exports.GetHorizontalBordersWidth = GetHorizontalBordersWidth;
function GetVerticalBordersWidth(element, style) {
    if (!IsExists(style))
        style = (Browser_1.Browser.IE && Browser_1.Browser.MajorVersion != 9 && window.getComputedStyle) ? window.getComputedStyle(element) : GetCurrentStyle(element);
    var res = 0;
    if (style.borderTopStyle != "none")
        res += PxToFloat(style.borderTopWidth);
    if (style.borderBottomStyle != "none")
        res += PxToFloat(style.borderBottomWidth);
    return res;
}
exports.GetVerticalBordersWidth = GetVerticalBordersWidth;
function SetElementVisibility(element, value) {
    if (!element)
        return;
    if (typeof (value) === "string")
        element.style.visibility = value;
    else
        element.style.visibility = value ? "visible" : "hidden";
}
exports.SetElementVisibility = SetElementVisibility;
;
function SetElementFloat(element, value) {
    if (IsExists(element.style.cssFloat))
        element.style.cssFloat = value;
    else if (IsExists(element.style.styleFloat))
        element.style.styleFloat = value;
    else
        Attr_1.Attr.SetAttribute(element.style, "float", value);
}
exports.SetElementFloat = SetElementFloat;
;
function SetElementOpacity(element, value) {
    var useOpacityStyle = !Browser_1.Browser.IE || Browser_1.Browser.Version > 8;
    if (useOpacityStyle) {
        element.style.opacity = value;
    }
    else {
        if (typeof (element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"])
            element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity = value * 100;
        else
            element.style.filter = "alpha(opacity=" + (value * 100) + ")";
    }
}
exports.SetElementOpacity = SetElementOpacity;
function CreateGuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0; // trunc fractional part
        var v = c == 'x' ? r : r & 0x3 | 0x8;
        return v.toString(16);
    });
}
exports.CreateGuid = CreateGuid;
function IsUrlContainsClientScript(url) {
    return url.toLowerCase().indexOf("javascript:") !== -1;
}
exports.IsUrlContainsClientScript = IsUrlContainsClientScript;
function IsExistsElement(element) {
    return element && IsValidElement(element);
}
exports.IsExistsElement = IsExistsElement;
function IsValidElement(element) {
    if (!element)
        return false;
    if (!(Browser_1.Browser.Firefox && Browser_1.Browser.Version < 4)) {
        if (element.ownerDocument && element.ownerDocument.body && element.ownerDocument.body.compareDocumentPosition)
            return element.ownerDocument.body.compareDocumentPosition(element) % 2 === 0;
    }
    if (!Browser_1.Browser.Opera && !(Browser_1.Browser.IE && Browser_1.Browser.Version < 9) && element.offsetParent && element.parentNode.tagName)
        return true;
    while (element != null) {
        if (element.tagName == "BODY")
            return true;
        element = element.parentNode;
    }
    return false;
}
exports.IsValidElement = IsValidElement;
function IsInteractiveControl(element) {
    return Data_1.Data.ArrayIndexOf(["A", "INPUT", "SELECT", "OPTION", "TEXTAREA", "BUTTON", "IFRAME"], element.tagName) > -1;
}
exports.IsInteractiveControl = IsInteractiveControl;
function IsActionElement(element) {
    if (!IsExistsElement(element))
        return false;
    var tabIndex = parseInt(Attr_1.Attr.GetAttribute(element, Attr_1.Attr.GetTabIndexAttributeName()));
    var hasTabIndex = !isNaN(tabIndex);
    var hasNonNegativeTabIndex = hasTabIndex && tabIndex > -1;
    var hasNegativeTabIndex = hasTabIndex && tabIndex < 0;
    var tagName = element.tagName;
    var focusableElementTags = ["BUTTON", "SELECT", "TEXTAREA", "OPTION", "IFRAME"];
    var isFocusableCore = IsFocusable(element);
    var isFocusableTag = focusableElementTags.indexOf(tagName) !== -1;
    var isFocusableLink = tagName === "A" && (!!element.href || hasNonNegativeTabIndex);
    var isFocusableInput = tagName === "INPUT" && element.type.toLowerCase() !== "hidden";
    var isFocusableByTabIndex = tagName !== "INPUT" && hasNonNegativeTabIndex;
    var isEditableDiv = tagName == "DIV" && element.contentEditable === "true";
    return isFocusableCore && !hasNegativeTabIndex && (isFocusableTag || isFocusableLink || isFocusableInput || isFocusableByTabIndex || isEditableDiv);
}
exports.IsActionElement = IsActionElement;
function IsFocusable(element, skipContainerVisibilityCheck) {
    if (skipContainerVisibilityCheck === void 0) { skipContainerVisibilityCheck = function () { return false; }; }
    var current = element;
    while (current && current.nodeType == 1) {
        if (current == element || !skipContainerVisibilityCheck(current)) {
            var tagName = current.tagName.toUpperCase();
            if (tagName == "BODY")
                return true;
            var disabledElementTags = ["INPUT", "BUTTON", "TEXTAREA", "SELECT", "OPTION"];
            if (disabledElementTags.indexOf(tagName) !== -1 && current.disabled || !GetElementDisplay(current, false) || !GetElementVisibility(current, false))
                return false;
        }
        current = current.parentNode;
    }
    return true;
}
exports.IsFocusable = IsFocusable;
function GetElementDisplay(element, isCurrentStyle) {
    if (isCurrentStyle)
        return GetCurrentStyle(element).display != "none";
    return element.style.display != "none";
}
exports.GetElementDisplay = GetElementDisplay;
function GetElementVisibility(element, isCurrentStyle) {
    if (isCurrentStyle)
        return GetCurrentStyle(element).visibility != "hidden";
    return element.style.visibility != "hidden";
}
exports.GetElementVisibility = GetElementVisibility;
function GetClearClientHeight(element) {
    return element.offsetHeight - GetTopBottomBordersAndPaddingsSummaryValue(element);
}
exports.GetClearClientHeight = GetClearClientHeight;
function GetTopBottomBordersAndPaddingsSummaryValue(element, currentStyle) {
    return GetTopBottomPaddings(element, currentStyle) + GetVerticalBordersWidth(element, currentStyle);
}
exports.GetTopBottomBordersAndPaddingsSummaryValue = GetTopBottomBordersAndPaddingsSummaryValue;
;
function GetTopBottomPaddings(element, style) {
    var currentStyle = style ? style : GetCurrentStyle(element);
    return PxToInt(currentStyle.paddingTop) + PxToInt(currentStyle.paddingBottom);
}
exports.GetTopBottomPaddings = GetTopBottomPaddings;
;
function ParseShortcutString(shortcutString) {
    if (!shortcutString)
        return 0;
    var isCtrlKey = false;
    var isShiftKey = false;
    var isAltKey = false;
    var isMetaKey = false;
    var keyCode = null;
    var shcKeys = shortcutString.toString().split("+");
    if (shcKeys.length > 0) {
        for (var i = 0; i < shcKeys.length; i++) {
            var key = Str_1.Str.Trim(shcKeys[i].toUpperCase());
            switch (key) {
                case "CONTROL":
                case "CONTROLKEY":
                case "CTRL":
                    isCtrlKey = true;
                    break;
                case "SHIFT":
                case "SHIFTKEY":
                    isShiftKey = true;
                    break;
                case "ALT":
                    isAltKey = true;
                    break;
                case "CMD":
                    isMetaKey = true;
                    break;
                case "F1":
                    keyCode = KeyCode_1.KeyCode.F1;
                    break;
                case "F2":
                    keyCode = KeyCode_1.KeyCode.F2;
                    break;
                case "F3":
                    keyCode = KeyCode_1.KeyCode.F3;
                    break;
                case "F4":
                    keyCode = KeyCode_1.KeyCode.F4;
                    break;
                case "F5":
                    keyCode = KeyCode_1.KeyCode.F5;
                    break;
                case "F6":
                    keyCode = KeyCode_1.KeyCode.F6;
                    break;
                case "F7":
                    keyCode = KeyCode_1.KeyCode.F7;
                    break;
                case "F8":
                    keyCode = KeyCode_1.KeyCode.F8;
                    break;
                case "F9":
                    keyCode = KeyCode_1.KeyCode.F9;
                    break;
                case "F10":
                    keyCode = KeyCode_1.KeyCode.F10;
                    break;
                case "F11":
                    keyCode = KeyCode_1.KeyCode.F11;
                    break;
                case "F12":
                    keyCode = KeyCode_1.KeyCode.F12;
                    break;
                case "RETURN":
                case "ENTER":
                    keyCode = KeyCode_1.KeyCode.Enter;
                    break;
                case "HOME":
                    keyCode = KeyCode_1.KeyCode.Home;
                    break;
                case "END":
                    keyCode = KeyCode_1.KeyCode.End;
                    break;
                case "LEFT":
                    keyCode = KeyCode_1.KeyCode.Left;
                    break;
                case "RIGHT":
                    keyCode = KeyCode_1.KeyCode.Right;
                    break;
                case "UP":
                    keyCode = KeyCode_1.KeyCode.Up;
                    break;
                case "DOWN":
                    keyCode = KeyCode_1.KeyCode.Down;
                    break;
                case "PAGEUP":
                    keyCode = KeyCode_1.KeyCode.PageUp;
                    break;
                case "PAGEDOWN":
                    keyCode = KeyCode_1.KeyCode.PageDown;
                    break;
                case "SPACE":
                    keyCode = KeyCode_1.KeyCode.Space;
                    break;
                case "TAB":
                    keyCode = KeyCode_1.KeyCode.Tab;
                    break;
                case "BACKSPACE":
                case "BACK":
                    keyCode = KeyCode_1.KeyCode.Backspace;
                    break;
                case "CONTEXT":
                    keyCode = KeyCode_1.KeyCode.ContextMenu;
                    break;
                case "ESCAPE":
                case "ESC":
                    keyCode = KeyCode_1.KeyCode.Esc;
                    break;
                case "DELETE":
                case "DEL":
                    keyCode = KeyCode_1.KeyCode.Delete;
                    break;
                case "INSERT":
                case "INS":
                    keyCode = KeyCode_1.KeyCode.Insert;
                    break;
                case "PLUS":
                    keyCode = "+".charCodeAt(0);
                    break;
                default:
                    keyCode = key.charCodeAt(0);
                    break;
            }
        }
    }
    else
        ShowErrorAlert("Invalid shortcut");
    return GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
}
exports.ParseShortcutString = ParseShortcutString;
function ShowErrorAlert(message) {
    message = Str_1.Str.DecodeHtmlViaTextArea(message);
    if (IsExists(message) && message !== "")
        alert(message);
}
exports.ShowErrorAlert = ShowErrorAlert;
;
function GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
    var value = keyCode;
    value |= isCtrlKey ? KeyCode_1.ModifierKey.Ctrl : 0;
    value |= isShiftKey ? KeyCode_1.ModifierKey.Shift : 0;
    value |= isAltKey ? KeyCode_1.ModifierKey.Alt : 0;
    value |= isMetaKey ? KeyCode_1.ModifierKey.Meta : 0;
    return value;
}
exports.GetShortcutCode = GetShortcutCode;
;
function GetShortcutCodeByEvent(evt) {
    return GetShortcutCode(Evt_1.Evt.GetKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, Browser_1.Browser.MacOSPlatform ? evt.metaKey : false);
}
exports.GetShortcutCodeByEvent = GetShortcutCodeByEvent;
;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser = /** @class */ (function () {
    function Browser() {
    }
    Browser.IdentUserAgent = function (userAgent, ignoreDocumentMode) {
        if (ignoreDocumentMode === void 0) { ignoreDocumentMode = false; }
        var browserTypesOrderedList = ["Mozilla", "IE", "Firefox", "Netscape", "Safari", "Chrome", "Opera", "Opera10", "Edge"];
        var defaultBrowserType = "IE";
        var defaultPlatform = "Win";
        var defaultVersions = { Safari: 2, Chrome: 0.1, Mozilla: 1.9, Netscape: 8, Firefox: 2, Opera: 9, IE: 6, Edge: 12 };
        if (!userAgent || userAgent.length == 0) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
            return;
        }
        userAgent = userAgent.toLowerCase();
        Browser.indentPlatformMajorVersion(userAgent);
        try {
            var platformIdentStrings = {
                "Windows": "Win",
                "Macintosh": "Mac",
                "Mac OS": "Mac",
                "Mac_PowerPC": "Mac",
                "cpu os": "MacMobile",
                "cpu iphone os": "MacMobile",
                "Android": "Android",
                "!Windows Phone": "WinPhone",
                "!WPDesktop": "WinPhone",
                "!ZuneWP": "WinPhone"
            };
            var optSlashOrSpace = "(?:/|\\s*)?";
            var versionString = "(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?";
            var optVersion = "(?:" + versionString + ")?";
            var patterns = {
                Safari: "applewebkit(?:.*?(?:version/" + versionString + "[\\.\\w\\d]*?(?:\\s+mobile\/\\S*)?\\s+safari))?",
                Chrome: "(?:chrome|crios)(?!frame)" + optSlashOrSpace + optVersion,
                Mozilla: "mozilla(?:.*rv:" + optVersion + ".*Gecko)?",
                Netscape: "(?:netscape|navigator)\\d*/?\\s*" + optVersion,
                Firefox: "firefox" + optSlashOrSpace + optVersion,
                Opera: "(?:opera|\sopr)" + optSlashOrSpace + optVersion,
                Opera10: "opera.*\\s*version" + optSlashOrSpace + optVersion,
                IE: "msie\\s*" + optVersion,
                Edge: "edge" + optSlashOrSpace + optVersion
            };
            var browserType;
            var version = -1;
            for (var i = 0; i < browserTypesOrderedList.length; i++) {
                var browserTypeCandidate = browserTypesOrderedList[i];
                var regExp = new RegExp(patterns[browserTypeCandidate], "i");
                if (regExp.compile)
                    regExp.compile(patterns[browserTypeCandidate], "i");
                var matches = regExp.exec(userAgent);
                if (matches && matches.index >= 0) {
                    if (browserType == "IE" && version >= 11 && browserTypeCandidate == "Safari") // WinPhone8.1 update
                        continue;
                    browserType = browserTypeCandidate;
                    if (browserType == "Opera10")
                        browserType = "Opera";
                    var tridentPattern = "trident" + optSlashOrSpace + optVersion;
                    version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, Browser.getIECompatibleVersionString());
                    if (browserType == "Mozilla" && version >= 11)
                        browserType = "IE";
                }
            }
            if (!browserType)
                browserType = defaultBrowserType;
            var browserVersionDetected = version != -1;
            if (!browserVersionDetected)
                version = defaultVersions[browserType];
            var platform;
            var minOccurenceIndex = Number.MAX_VALUE;
            for (var identStr in platformIdentStrings) {
                if (!platformIdentStrings.hasOwnProperty(identStr))
                    continue;
                var importantIdent = identStr.substr(0, 1) == "!";
                var occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
                if (occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent)) {
                    minOccurenceIndex = importantIdent ? 0 : occurenceIndex;
                    platform = platformIdentStrings[identStr];
                }
            }
            var samsungPattern = "SM-[A-Z]";
            var m = userAgent.toUpperCase().match(samsungPattern);
            var isSamsungAndroidDevice = m && m.length > 0;
            if (platform == "WinPhone" && version < 9)
                version = Math.floor(Browser.getVersionFromTrident(userAgent, "trident" + optSlashOrSpace + optVersion));
            if (!ignoreDocumentMode && browserType == "IE" && version > 7 && document.documentMode < version)
                version = document.documentMode;
            if (platform == "WinPhone")
                version = Math.max(9, version);
            if (!platform)
                platform = defaultPlatform;
            if (platform == platformIdentStrings["cpu os"] && !browserVersionDetected) // Terra browser
                version = 4;
            Browser.fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
        }
        catch (e) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
        }
    };
    Browser.GetBrowserVersion = function (userAgent, matches, tridentPattern, ieCompatibleVersionString) {
        var version = Browser.getVersionFromMatches(matches);
        if (ieCompatibleVersionString) {
            var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
            if (ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
                return versionFromTrident;
        }
        return version;
    };
    Browser.getIECompatibleVersionString = function () {
        if (document.compatible) {
            for (var i = 0; i < document.compatible.length; i++)
                if (document.compatible[i].userAgent === "IE" && document.compatible[i].version)
                    return document.compatible[i].version.toLowerCase();
        }
        return "";
    };
    Browser.fillUserAgentInfo = function (browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
        if (isSamsungAndroidDevice === void 0) { isSamsungAndroidDevice = false; }
        for (var i = 0; i < browserTypesOrderedList.length; i++) {
            var type = browserTypesOrderedList[i];
            Browser[type] = type == browserType;
        }
        Browser.Version = Math.floor(10.0 * version) / 10.0;
        Browser.MajorVersion = Math.floor(Browser.Version);
        Browser.WindowsPlatform = platform == "Win" || platform == "WinPhone";
        Browser.MacOSPlatform = platform == "Mac";
        Browser.MacOSMobilePlatform = platform == "MacMobile";
        Browser.AndroidMobilePlatform = platform == "Android";
        Browser.WindowsPhonePlatform = platform == "WinPhone";
        Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15;
        Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox;
        Browser.HardwareAcceleration = (Browser.IE && Browser.MajorVersion >= 9) || (Browser.Firefox && Browser.MajorVersion >= 4) ||
            (Browser.AndroidMobilePlatform && Browser.Chrome) || (Browser.Chrome && Browser.MajorVersion >= 37) ||
            (Browser.Safari && !Browser.WindowsPlatform) || Browser.Edge || (Browser.Opera && Browser.MajorVersion >= 46);
        Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
        var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf("touch") >= 0;
        Browser.MSTouchUI = isIETouchUI || (Browser.Edge && !!window.navigator.maxTouchPoints);
        Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI;
        Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform;
        Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome;
        Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome;
        if (isSamsungAndroidDevice)
            Browser.SamsungAndroidDevice = isSamsungAndroidDevice;
        if (Browser.MSTouchUI) {
            var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf("arm;") > -1;
            Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;
        }
        else {
            Browser.VirtualKeyboardSupported = Browser.WebKitTouchUI;
        }
        Browser.fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
    };
    Browser.indentPlatformMajorVersion = function (userAgent) {
        var regex = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/;
        var matches = regex.exec(userAgent);
        if (matches)
            Browser.PlaformMajorVersion = matches[1];
    };
    Browser.prototype.GetBrowserVersion = function (userAgent, matches, tridentPattern, ieCompatibleVersionString) {
        var version = Browser.getVersionFromMatches(matches);
        if (ieCompatibleVersionString) {
            var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
            if (ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
                return versionFromTrident;
        }
        return version;
    };
    Browser.getVersionFromMatches = function (matches) {
        var result = -1;
        var versionStr = "";
        if (matches[1]) {
            versionStr += matches[1];
            if (matches[2])
                versionStr += "." + matches[2];
        }
        if (versionStr != "") {
            result = parseFloat(versionStr);
            if (isNaN(result))
                result = -1;
        }
        return result;
    };
    Browser.getVersionFromTrident = function (userAgent, tridentPattern) {
        var tridentDiffFromVersion = 4;
        var matches = new RegExp(tridentPattern, "i").exec(userAgent);
        return Browser.getVersionFromMatches(matches) + tridentDiffFromVersion;
    };
    Browser.fillDocumentElementBrowserTypeClassNames = function (browserTypesOrderedList) {
        var documentElementClassName = "";
        var browserTypeslist = browserTypesOrderedList.concat(["WindowsPlatform", "MacOSPlatform", "MacOSMobilePlatform", "AndroidMobilePlatform",
            "WindowsPhonePlatform", "WebKitFamily", "WebKitTouchUI", "MSTouchUI", "TouchUI", "AndroidDefaultBrowser"]);
        for (var i = 0; i < browserTypeslist.length; i++) {
            var type = browserTypeslist[i];
            if (Browser[type])
                documentElementClassName += "dx" + type + " ";
        }
        documentElementClassName += "dxBrowserVersion-" + Browser.MajorVersion;
        if (document && document.documentElement) {
            if (document.documentElement.className != "")
                documentElementClassName = " " + documentElementClassName;
            document.documentElement.className += documentElementClassName;
            Browser.Info = documentElementClassName;
        }
    };
    Browser.UserAgent = window.navigator.userAgent.toLowerCase();
    Browser._foo = Browser.IdentUserAgent(Browser.UserAgent); // to init
    return Browser;
}());
exports.Browser = Browser;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Utils_1 = __webpack_require__(0);
var UnitConverter_1 = __webpack_require__(13);
var ModelUtils_1 = __webpack_require__(8);
var DiagramUnit;
(function (DiagramUnit) {
    DiagramUnit[DiagramUnit["In"] = 0] = "In";
    DiagramUnit[DiagramUnit["Cm"] = 1] = "Cm";
    DiagramUnit[DiagramUnit["Px"] = 2] = "Px";
})(DiagramUnit = exports.DiagramUnit || (exports.DiagramUnit = {}));
var DiagramModel = /** @class */ (function () {
    function DiagramModel() {
        this.items = [];
        this.itemIndexByKey = {};
        this.pageSize = new Utils_1.Size(8391, 11906);
        this.pageLandscape = false;
        this.pageColor = DiagramModel.defaultPageColor;
        this.gridSize = 180;
        this.showGrid = true;
        this.snapToGrid = true;
        this.units = DiagramUnit.Cm;
        this.zoomLevel = 1;
        this.size = this.pageSize.clone();
    }
    Object.defineProperty(DiagramModel.prototype, "pageWidth", {
        get: function () {
            return this.pageLandscape ? this.pageSize.height : this.pageSize.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramModel.prototype, "pageHeight", {
        get: function () {
            return this.pageLandscape ? this.pageSize.width : this.pageSize.height;
        },
        enumerable: true,
        configurable: true
    });
    DiagramModel.prototype.getRectangle = function () {
        return DiagramModel.getRectangle(this.items);
    };
    DiagramModel.getRectangle = function (items) {
        return Utils_1.GeometryUtils.getCommonRectangle(items.map(function (i) { return i.rectangle; }));
    };
    DiagramModel.prototype.pushItem = function (item) {
        var index = this.items.push(item);
        this.itemIndexByKey[item.key] = index - 1;
    };
    DiagramModel.prototype.removeItem = function (item) {
        var index = this.getItemIndex(item);
        delete this.itemIndexByKey[item.key];
        this.items.splice(index, 1);
        this.updateIndicesHash(index);
    };
    DiagramModel.prototype.reorderItem = function (item, newIndex) {
        var oldIndex = this.getItemIndex(item);
        this.items.splice(oldIndex, 1);
        this.items.splice(newIndex, 0, item);
        this.updateIndicesHash(Math.min(oldIndex, newIndex));
    };
    DiagramModel.prototype.updateIndicesHash = function (startIndex) {
        for (var i = startIndex; i < this.items.length; i++)
            this.itemIndexByKey[this.items[i].key] = i;
    };
    DiagramModel.prototype.getItemIndex = function (item) {
        return this.itemIndexByKey[item.key];
    };
    DiagramModel.prototype.findShape = function (key) {
        var shape = this.findItem(key);
        return shape instanceof Shape_1.Shape ? shape : undefined;
    };
    DiagramModel.prototype.findShapeCore = function (callback) {
        var shape;
        this.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                if (callback(item)) {
                    shape = item;
                    return;
                }
            }
        });
        return shape;
    };
    DiagramModel.prototype.findShapeAtPosition = function (position) {
        return this.findShapeCore(function (shape) { return shape.position.equals(position); });
    };
    DiagramModel.prototype.findShapeByDataKey = function (key) {
        return this.findShapeCore(function (shape) { return shape.dataKey === key; });
    };
    DiagramModel.prototype.findConnector = function (key) {
        var connector = this.findItem(key);
        return connector instanceof Connector_1.Connector ? connector : undefined;
    };
    DiagramModel.prototype.findConnectorCore = function (callback) {
        var connector;
        this.items.forEach(function (item) {
            if (item instanceof Connector_1.Connector) {
                if (callback(item)) {
                    connector = item;
                    return;
                }
            }
        });
        return connector;
    };
    DiagramModel.prototype.findConnectorAtPoints = function (points) {
        return this.findConnectorCore(function (connector) { return Utils_1.GeometryUtils.arePointsEqual(connector.points, points); });
    };
    DiagramModel.prototype.findConnectorByDataKey = function (key) {
        return this.findConnectorCore(function (connector) { return connector.dataKey === key; });
    };
    DiagramModel.prototype.findItem = function (key) {
        return this.items[this.itemIndexByKey[key]];
    };
    DiagramModel.isIntersectedItems = function (item1, item2) {
        var result = false;
        if (item1 instanceof Shape_1.Shape)
            result = item2.intersectedByRect(item1.rectangle);
        else if (item1 instanceof Connector_1.Connector) {
            item1.getSegments().forEach(function (s1) {
                if (item2 instanceof Shape_1.Shape)
                    result = result || s1.intersectRect(item2.rectangle);
                else if (item2 instanceof Connector_1.Connector) {
                    item2.getSegments().forEach(function (s2) {
                        result = result || s1.intersect(s2);
                    });
                }
            });
        }
        return result;
    };
    DiagramModel.prototype.getIntersectItems = function (item) {
        var result = [];
        this.items.forEach(function (i) {
            if (item !== i && (!(i instanceof Connector_1.Connector) || item.attachedConnectors.indexOf(i) === -1) &&
                DiagramModel.isIntersectedItems(i, item))
                result.push(i);
        });
        return result;
    };
    DiagramModel.prototype.getIntersectItemsMinZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
    };
    DiagramModel.prototype.getIntersectItemsMaxZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
    };
    DiagramModel.prototype.iterateItems = function (callback) {
        this.items.forEach(callback);
    };
    DiagramModel.prototype.invalidateItems = function () {
        this.iterateItems(function (item) {
            item.invalidatePrimitives();
            if (item instanceof Connector_1.Connector)
                item.invalidateRenderPoints();
        });
    };
    DiagramModel.prototype.getNextKey = function (baseKey) {
        var _this = this;
        return ModelUtils_1.ModelUtils.getNextItemKey(this.items.map(function (item) { return item.key; }), function (key) { return _this.itemIndexByKey[key] === undefined; }, baseKey);
    };
    DiagramModel.prototype.getModelUnit = function (twipsValue) {
        switch (this.units) {
            case DiagramUnit.Cm:
                return UnitConverter_1.UnitConverter.twipsToCentimeters(twipsValue);
            case DiagramUnit.In:
                return UnitConverter_1.UnitConverter.twipsToInches(twipsValue);
            case DiagramUnit.Px:
                return UnitConverter_1.UnitConverter.twipsToPixels(twipsValue);
        }
    };
    DiagramModel.prototype.getModelUnitText = function (twipsValue, fractionDigits) {
        if (fractionDigits === void 0) { fractionDigits = 2; }
        switch (this.units) {
            case DiagramUnit.Cm:
                return +this.getModelUnit(twipsValue).toFixed(fractionDigits) + " cm";
            case DiagramUnit.In:
                return +this.getModelUnit(twipsValue).toFixed(fractionDigits) + " in";
            case DiagramUnit.Px:
                return this.getModelUnit(twipsValue).toFixed(0) + " px";
        }
    };
    DiagramModel.prototype.getTwipsUnit = function (value) {
        switch (this.units) {
            case DiagramUnit.Cm:
                return UnitConverter_1.UnitConverter.centimetersToTwips(value);
            case DiagramUnit.In:
                return UnitConverter_1.UnitConverter.inchesToTwips(value);
            case DiagramUnit.Px:
                return UnitConverter_1.UnitConverter.pixelsToTwips(value);
        }
    };
    DiagramModel.defaultPageColor = "white";
    return DiagramModel;
}());
exports.DiagramModel = DiagramModel;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Edge = /** @class */ (function () {
    function Edge(key, from, to, weight) {
        if (weight === void 0) { weight = 1; }
        this.weight = weight;
        this.key = key;
        this.from = from;
        this.to = to;
    }
    Edge.prototype.getHashKey = function () {
        return this.from + "_" + this.to;
    };
    Edge.prototype.reverse = function () {
        return new Edge(this.key, this.to, this.from, this.weight);
    };
    return Edge;
}());
exports.Edge = Edge;
var PositionInfo = /** @class */ (function () {
    function PositionInfo(item, position) {
        this.item = item;
        this.position = position;
    }
    return PositionInfo;
}());
exports.PositionInfo = PositionInfo;
var ConnectionMode;
(function (ConnectionMode) {
    ConnectionMode[ConnectionMode["Outgoing"] = 1] = "Outgoing";
    ConnectionMode[ConnectionMode["Incoming"] = 2] = "Incoming";
    ConnectionMode[ConnectionMode["OutgoingAndIncoming"] = 3] = "OutgoingAndIncoming";
})(ConnectionMode = exports.ConnectionMode || (exports.ConnectionMode = {}));


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ChangePagePropertyHistoryItem_1 = __webpack_require__(175);
var ModelUtils_1 = __webpack_require__(8);
var ChangePagePropertyCommand = /** @class */ (function (_super) {
    __extends(ChangePagePropertyCommand, _super);
    function ChangePagePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePagePropertyCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true, this.control.model[this.getPropertyName()], this.getPropertyOptions());
    };
    ChangePagePropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var propertyName = this.getPropertyName();
        var items = this.createHistoryItems(propertyName, parameter);
        items.forEach(function (item) { _this.control.history.addAndRedo(item); });
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.endTransaction();
        return true;
    };
    ChangePagePropertyCommand.prototype.createHistoryItems = function (propertyName, parameter) {
        return [new ChangePagePropertyHistoryItem_1.ChangePagePropertyHistoryItem(propertyName, parameter)];
    };
    ChangePagePropertyCommand.prototype.getPropertyOptions = function () {
        return null;
    };
    return ChangePagePropertyCommand;
}(CommandBase_1.CommandBase));
exports.ChangePagePropertyCommand = ChangePagePropertyCommand;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerStateBase_1 = __webpack_require__(45);
var Event_1 = __webpack_require__(14);
var MouseHandlerDraggingState = /** @class */ (function (_super) {
    __extends(MouseHandlerDraggingState, _super);
    function MouseHandlerDraggingState(handler, history) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        return _this;
    }
    MouseHandlerDraggingState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
        }
        else {
            this.onApplyChanges(evt);
            if (!this.modified)
                this.handler.raiseDragStart(this.getDraggingElementKeys());
            this.modified = true;
        }
    };
    MouseHandlerDraggingState.prototype.cancelChanges = function () {
        this.history.undoTransaction();
        this.modified = false;
    };
    MouseHandlerDraggingState.prototype.onMouseUp = function (evt) {
        this.handler.switchToDefaultState();
    };
    MouseHandlerDraggingState.prototype.start = function () {
        this.history.beginTransaction();
    };
    MouseHandlerDraggingState.prototype.finish = function () {
        if (this.modified) {
            this.onFinishWithChanges();
            this.modified = false;
            this.history.endTransaction();
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        }
        else
            this.history.endTransaction();
    };
    MouseHandlerDraggingState.prototype.onFinishWithChanges = function () { };
    MouseHandlerDraggingState.prototype.getSnappedPoint = function (evt, point) {
        return this.handler.getSnappedPoint(evt, point);
    };
    return MouseHandlerDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerDraggingState = MouseHandlerDraggingState;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeParameter = /** @class */ (function () {
    function ShapeParameter(key, value) {
        this.key = key;
        this.value = value;
    }
    return ShapeParameter;
}());
exports.ShapeParameter = ShapeParameter;
var ShapeParameters = /** @class */ (function () {
    function ShapeParameters() {
        this.items = {};
    }
    ShapeParameters.prototype.add = function (parameter) {
        this.items[parameter.key] = parameter;
    };
    ShapeParameters.prototype.addRange = function (parameters) {
        for (var i = 0; i < parameters.length; i++)
            this.add(parameters[i]);
    };
    ShapeParameters.prototype.get = function (key) {
        return this.items[key];
    };
    ShapeParameters.prototype.forEach = function (callback) {
        for (var key in this.items)
            if (this.items.hasOwnProperty(key))
                callback(this.items[key]);
    };
    ShapeParameters.prototype.clone = function () {
        var result = new ShapeParameters();
        this.forEach(function (p) { result.add(new ShapeParameter(p.key, p.value)); });
        return result;
    };
    ShapeParameters.prototype.toObject = function () {
        var result = {};
        var modified = false;
        this.forEach(function (p) {
            result[p.key] = { 'value': p.value };
            modified = true;
        });
        return modified ? result : null;
    };
    ShapeParameters.prototype.fromObject = function (obj) {
        this.forEach(function (p) {
            var paramObj = obj[p.key];
            if (paramObj) {
                if (typeof paramObj["value"] === "number")
                    p.value = paramObj["value"];
            }
        });
    };
    return ShapeParameters;
}());
exports.ShapeParameters = ShapeParameters;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Event_1 = __webpack_require__(14);
var __1 = __webpack_require__(46);
var Utils_1 = __webpack_require__(0);
var Base_1 = __webpack_require__(19);
var RenderUtils = /** @class */ (function () {
    function RenderUtils() {
    }
    RenderUtils.updateSvgElementSize = function (svgElement, width, height) {
        svgElement.style.width = width + "px";
        svgElement.style.height = height + "px";
        svgElement.setAttribute("viewBox", "0 0 " + width + " " + height);
    };
    RenderUtils.removeContent = function (element) {
        while (element.firstChild)
            element.removeChild(element.firstChild);
    };
    RenderUtils.setElementEventData = function (element, type, key, value) {
        if (type === Event_1.MouseEventElementType.Undefined)
            return;
        element.setAttribute("data-type", type.toString());
        if (key !== undefined)
            element.setAttribute("data-key", key.toString());
        if (value !== undefined)
            element.setAttribute("data-value", value.toString());
    };
    RenderUtils.getElementEventData = function (element) {
        if (element.getAttribute && element.getAttribute("data-type")) {
            return new Event_1.MouseEventSource(parseInt(element.getAttribute("data-type")), element.getAttribute("data-key"), element.getAttribute("data-value"));
        }
    };
    RenderUtils.getHtmlElementStylePropertyName = function (propertyName) {
        switch (propertyName) {
            case "fill":
                return "color";
            case "text-anchor":
                return "text-align";
        }
        return propertyName;
    };
    RenderUtils.getStylePropertyValue = function (propertyName, propertyValue, reverseTextAnchor) {
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        if (propertyName === "text-anchor" && reverseTextAnchor) {
            if (propertyValue === "start")
                return "end";
            if (propertyValue === "end")
                return "start";
        }
        return propertyValue;
    };
    RenderUtils.applyStyleToElement = function (style, element, reverseTextAnchor) {
        var _this = this;
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        var defaultStyle = style.getDefaultInstance();
        style.forEach(function (propertyName) {
            var propertyValue = style[propertyName];
            var elPropertyName = (element instanceof HTMLElement) ? _this.getHtmlElementStylePropertyName(propertyName) : propertyName;
            if (propertyValue !== undefined && propertyValue !== "" && propertyValue !== defaultStyle[propertyName])
                element.style.setProperty(elPropertyName, _this.getStylePropertyValue(propertyName, propertyValue, reverseTextAnchor));
            else
                element.style.setProperty(elPropertyName, "");
        });
    };
    RenderUtils.generateSvgElementId = function (prefix) {
        return prefix + "_" + Base_1.CreateGuid();
    };
    RenderUtils.getSvgTextRectangle = function (textEl, lineWidth) {
        if (lineWidth === void 0) { lineWidth = 0; }
        var bBox;
        try {
            bBox = textEl.getBBox();
        }
        catch (_a) { } // TODO make measure in another way because of FF error
        if (bBox) {
            var x = __1.UnitConverter.pixelsToTwips(Math.round(bBox.x)) - lineWidth;
            var y = __1.UnitConverter.pixelsToTwips(Math.round(bBox.y)) - lineWidth;
            var width = __1.UnitConverter.pixelsToTwips(Math.round(bBox.width)) + 2 * lineWidth;
            var height = __1.UnitConverter.pixelsToTwips(Math.round(bBox.height)) + 2 * lineWidth;
            return Utils_1.Rectangle.create(x, y, width, height);
        }
    };
    return RenderUtils;
}());
exports.RenderUtils = RenderUtils;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var ConnectorRenderPoint = /** @class */ (function (_super) {
    __extends(ConnectorRenderPoint, _super);
    function ConnectorRenderPoint(x, y, pointIndex, skipped) {
        if (pointIndex === void 0) { pointIndex = -1; }
        if (skipped === void 0) { skipped = false; }
        var _this = _super.call(this, x, y) || this;
        _this.pointIndex = pointIndex;
        _this.skipped = skipped;
        return _this;
    }
    ConnectorRenderPoint.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new ConnectorRenderPoint(this.x + offsetX, this.y + offsetY);
    };
    ConnectorRenderPoint.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new ConnectorRenderPoint(this.x * multiplierX, this.y * multiplierY);
    };
    ConnectorRenderPoint.prototype.clone = function () { return new ConnectorRenderPoint(this.x, this.y, this.pointIndex); };
    return ConnectorRenderPoint;
}(Utils_1.Point));
exports.ConnectorRenderPoint = ConnectorRenderPoint;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorLineOption;
(function (ConnectorLineOption) {
    ConnectorLineOption[ConnectorLineOption["Straight"] = 0] = "Straight";
    ConnectorLineOption[ConnectorLineOption["Orthogonal"] = 1] = "Orthogonal";
})(ConnectorLineOption = exports.ConnectorLineOption || (exports.ConnectorLineOption = {}));
var ConnectorLineEnding;
(function (ConnectorLineEnding) {
    ConnectorLineEnding[ConnectorLineEnding["None"] = 0] = "None";
    ConnectorLineEnding[ConnectorLineEnding["Arrow"] = 1] = "Arrow";
})(ConnectorLineEnding = exports.ConnectorLineEnding || (exports.ConnectorLineEnding = {}));
var ConnectorProperties = /** @class */ (function () {
    function ConnectorProperties() {
        this.lineOption = ConnectorLineOption.Orthogonal;
        this.startLineEnding = ConnectorLineEnding.None;
        this.endLineEnding = ConnectorLineEnding.Arrow;
    }
    ConnectorProperties.prototype.clone = function () {
        var clone = new ConnectorProperties();
        clone.lineOption = this.lineOption;
        clone.startLineEnding = this.startLineEnding;
        clone.endLineEnding = this.endLineEnding;
        return clone;
    };
    ConnectorProperties.prototype.forEach = function (callback) {
        for (var propertyName in this) {
            if (this.hasOwnProperty(propertyName))
                callback(propertyName);
        }
    };
    ConnectorProperties.prototype.toObject = function () {
        var result = {};
        var modified = false;
        if (this.lineOption !== ConnectorLineOption.Orthogonal) {
            result["lineOption"] = this.lineOption;
            modified = true;
        }
        if (this.startLineEnding !== ConnectorLineEnding.None) {
            result["startLineEnding"] = this.startLineEnding;
            modified = true;
        }
        if (this.endLineEnding !== ConnectorLineEnding.Arrow) {
            result["endLineEnding"] = this.endLineEnding;
            modified = true;
        }
        return modified ? result : null;
    };
    ConnectorProperties.prototype.fromObject = function (obj) {
        if (typeof obj["lineOption"] === "number")
            this.lineOption = obj["lineOption"];
        if (typeof obj["startLineEnding"] === "number")
            this.startLineEnding = obj["startLineEnding"];
        if (typeof obj["endLineEnding"] === "number")
            this.endLineEnding = obj["endLineEnding"];
    };
    return ConnectorProperties;
}());
exports.ConnectorProperties = ConnectorProperties;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var SetSelectionHistoryItem = /** @class */ (function (_super) {
    __extends(SetSelectionHistoryItem, _super);
    function SetSelectionHistoryItem(selection, selectedKeys) {
        var _this = _super.call(this) || this;
        _this.selectedKeys = selectedKeys;
        _this.selection = selection;
        return _this;
    }
    SetSelectionHistoryItem.prototype.redo = function () {
        this.oldSelection = this.selection.getKeys().slice(0);
        this.selection.set(this.selectedKeys);
    };
    SetSelectionHistoryItem.prototype.undo = function () {
        this.selection.set(this.oldSelection);
    };
    return SetSelectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetSelectionHistoryItem = SetSelectionHistoryItem;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var ProcessShapeDescription_1 = __webpack_require__(120);
var DecisionShapeDescription_1 = __webpack_require__(121);
var ManualInputShapeDescription_1 = __webpack_require__(122);
var DataShapeDescription_1 = __webpack_require__(123);
var TerminatorShapeDescription_1 = __webpack_require__(124);
var PredefinedProcessShapeDescription_1 = __webpack_require__(125);
var ArrowNorthSouthShapeDescription_1 = __webpack_require__(126);
var ArrowRightShapeDescription_1 = __webpack_require__(127);
var ArrowTopShapeDescription_1 = __webpack_require__(128);
var CrossShapeDescription_1 = __webpack_require__(129);
var DiamondShapeDescription_1 = __webpack_require__(75);
var EllipseShapeDescription_1 = __webpack_require__(56);
var HeartShapeDescription_1 = __webpack_require__(130);
var RectangleShapeDescription_1 = __webpack_require__(12);
var TextShapeDescription_1 = __webpack_require__(76);
var PentagonShapeDescription_1 = __webpack_require__(77);
var HexagonShapeDescription_1 = __webpack_require__(78);
var OctagonShapeDescription_1 = __webpack_require__(131);
var StarShapeDescription_1 = __webpack_require__(132);
var ArrowBottomShapeDescription_1 = __webpack_require__(133);
var ArrowEastWestShapeDescription_1 = __webpack_require__(134);
var ArrowLeftShapeDescription_1 = __webpack_require__(135);
var TriangleShapeDescription_1 = __webpack_require__(79);
var DocumentShapeDescription_1 = __webpack_require__(80);
var MultipleDocumentsShapeDescription_1 = __webpack_require__(136);
var PreparationShapeDescription_1 = __webpack_require__(137);
var HardDiskShapeDescription_1 = __webpack_require__(138);
var DatabaseShapeDescription_1 = __webpack_require__(139);
var InternalStorageShapeDescription_1 = __webpack_require__(140);
var PaperTapeShapeDescription_1 = __webpack_require__(141);
var ManualOperationShapeDescription_1 = __webpack_require__(142);
var DelayShapeDescription_1 = __webpack_require__(143);
var StoredDataShapeDescription_1 = __webpack_require__(144);
var MergeShapeDescription_1 = __webpack_require__(145);
var DisplayShapeDescription_1 = __webpack_require__(146);
var OrShapeDescription_1 = __webpack_require__(147);
var SummingJunctionShapeDescription_1 = __webpack_require__(148);
var CustomShapeDescription_1 = __webpack_require__(149);
var ShapeDescriptionManager = /** @class */ (function () {
    function ShapeDescriptionManager() {
    }
    ShapeDescriptionManager.get = function (type) {
        return this.descriptions[type];
    };
    ShapeDescriptionManager.getTypesByCategory = function (category) {
        var result = [];
        for (var key in this.descriptions) {
            if (ShapeDescriptionManager.descriptions.hasOwnProperty(key)) {
                if (!category || this.descriptions[key].category === category)
                    result.push(parseInt(key));
            }
        }
        return result;
    };
    ShapeDescriptionManager.register = function (description) {
        if (this.descriptions[description.key] !== undefined)
            throw Error("Description key is duplicated");
        this.descriptions[description.key] = description;
    };
    ShapeDescriptionManager.unregister = function (shapeType) {
        delete this.descriptions[shapeType];
    };
    ShapeDescriptionManager.registerCustomShape = function (shape) {
        if (shape.id === undefined)
            throw Error("Custom shape id is not defined");
        if (this.descriptions[ShapeType_1.ShapeType.Custom + shape.id] !== undefined)
            throw Error("Custom shape id is duplicated");
        this.register(new CustomShapeDescription_1.CustomShapeDescription(ShapeType_1.ShapeType.Custom + shape.id, shape.title, shape.svgUrl, shape.svgLeft, shape.svgTop, shape.svgWidth, shape.svgHeight, shape.defaultWidth, shape.defaultHeight, shape.defaultText, shape.allowHasText, shape.textLeft, shape.textTop, shape.textWidth, shape.textHeight, shape.connectionPoints, shape.category));
    };
    ShapeDescriptionManager.unregisterCustomShape = function (id) {
        this.unregister(ShapeType_1.ShapeType.Custom + id);
    };
    ShapeDescriptionManager.descriptions = {};
    return ShapeDescriptionManager;
}());
exports.ShapeDescriptionManager = ShapeDescriptionManager;
ShapeDescriptionManager.register(new ArrowBottomShapeDescription_1.ArrowBottomShapeDescription());
ShapeDescriptionManager.register(new ArrowEastWestShapeDescription_1.ArrowEastWestShapeDescription());
ShapeDescriptionManager.register(new ArrowLeftShapeDescription_1.ArrowLeftShapeDescription());
ShapeDescriptionManager.register(new ArrowNorthSouthShapeDescription_1.ArrowNorthSouthShapeDescription());
ShapeDescriptionManager.register(new ArrowRightShapeDescription_1.ArrowRightShapeDescription());
ShapeDescriptionManager.register(new ArrowTopShapeDescription_1.ArrowTopShapeDescription());
ShapeDescriptionManager.register(new CrossShapeDescription_1.CrossShapeDescription());
ShapeDescriptionManager.register(new DiamondShapeDescription_1.DiamondShapeDescription());
ShapeDescriptionManager.register(new EllipseShapeDescription_1.EllipseShapeDescription());
ShapeDescriptionManager.register(new HeartShapeDescription_1.HeartShapeDescription());
ShapeDescriptionManager.register(new RectangleShapeDescription_1.RectangleShapeDescription());
ShapeDescriptionManager.register(new TriangleShapeDescription_1.TriangleShapeDescription());
ShapeDescriptionManager.register(new TextShapeDescription_1.TextShapeDescription());
ShapeDescriptionManager.register(new PentagonShapeDescription_1.PentagonShapeDescription());
ShapeDescriptionManager.register(new HexagonShapeDescription_1.HexagonShapeDescription());
ShapeDescriptionManager.register(new OctagonShapeDescription_1.OctagonShapeDescription());
ShapeDescriptionManager.register(new StarShapeDescription_1.StarShapeDescription());
ShapeDescriptionManager.register(new ProcessShapeDescription_1.ProcessShapeDescription());
ShapeDescriptionManager.register(new DecisionShapeDescription_1.DecisionShapeDescription());
ShapeDescriptionManager.register(new TerminatorShapeDescription_1.TerminatorShapeDescription());
ShapeDescriptionManager.register(new PredefinedProcessShapeDescription_1.PredefinedProcessShapeDescription());
ShapeDescriptionManager.register(new DocumentShapeDescription_1.DocumentShapeDescription());
ShapeDescriptionManager.register(new MultipleDocumentsShapeDescription_1.MultipleDocumentsShapeDescription());
ShapeDescriptionManager.register(new ManualInputShapeDescription_1.ManualInputShapeDescription());
ShapeDescriptionManager.register(new PreparationShapeDescription_1.PreparationShapeDescription());
ShapeDescriptionManager.register(new DataShapeDescription_1.DataShapeDescription());
ShapeDescriptionManager.register(new DatabaseShapeDescription_1.DatabaseShapeDescription());
ShapeDescriptionManager.register(new HardDiskShapeDescription_1.HardDiskShapeDescription());
ShapeDescriptionManager.register(new InternalStorageShapeDescription_1.InternalStorageShapeDescription());
ShapeDescriptionManager.register(new PaperTapeShapeDescription_1.PaperTapeShapeDescription());
ShapeDescriptionManager.register(new ManualOperationShapeDescription_1.ManualOperationShapeDescription());
ShapeDescriptionManager.register(new DelayShapeDescription_1.DelayShapeDescription());
ShapeDescriptionManager.register(new StoredDataShapeDescription_1.StoredDataShapeDescription());
ShapeDescriptionManager.register(new DisplayShapeDescription_1.DisplayShapeDescription());
ShapeDescriptionManager.register(new MergeShapeDescription_1.MergeShapeDescription());
ShapeDescriptionManager.register(new OrShapeDescription_1.OrShapeDescription());
ShapeDescriptionManager.register(new SummingJunctionShapeDescription_1.SummingJunctionShapeDescription());


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Exporter = /** @class */ (function () {
    function Exporter() {
    }
    Exporter.export = function (model) {
        var obj = {
            page: {},
            connectors: [],
            shapes: []
        };
        obj.page = {
            "width": model.size.width,
            "height": model.size.height,
            "pageColor": model.pageColor,
            "pageWidth": model.pageSize.width,
            "pageHeight": model.pageSize.height,
            "pageLandscape": model.pageLandscape,
            "gridSize": model.gridSize,
            "showGrid": model.showGrid,
            "snapToGrid": model.snapToGrid,
            "units": model.units
        };
        this.exportItemsCore(model.items, obj);
        return JSON.stringify(obj);
    };
    Exporter.exportItems = function (items) {
        var obj = {
            connectors: [],
            shapes: []
        };
        this.exportItemsCore(items, obj);
        return JSON.stringify(obj);
    };
    Exporter.exportItemsCore = function (items, obj) {
        var _this = this;
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                obj.shapes.push(_this.exportShape(item));
            }
            if (item instanceof Connector_1.Connector) {
                var connectorObj = _this.exportConnector(item);
                if (item.beginItem) {
                    connectorObj["beginItemKey"] = item.beginItem.key;
                    connectorObj["beginConnectionPointIndex"] = item.beginConnectionPointIndex;
                }
                if (item.endItem) {
                    connectorObj["endItemKey"] = item.endItem.key;
                    connectorObj["endConnectionPointIndex"] = item.endConnectionPointIndex;
                }
                obj.connectors.push(connectorObj);
            }
        });
    };
    Exporter.exportItem = function (item) {
        return {
            "key": item.key,
            "dataKey": item.dataKey,
            "locked": item.locked,
            "zIndex": item.zIndex
        };
    };
    Exporter.exportShape = function (shape) {
        var result = this.exportItem(shape);
        result["type"] = shape.description.key;
        result["text"] = shape.text;
        result["x"] = shape.position.x;
        result["y"] = shape.position.y;
        result["width"] = shape.size.width;
        result["height"] = shape.size.height;
        var paramsObj = shape.parameters.toObject();
        if (paramsObj)
            result["parameters"] = paramsObj;
        var styleObj = shape.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = shape.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        return result;
    };
    Exporter.exportConnector = function (connector) {
        var result = this.exportItem(connector);
        result["points"] = connector.points.map(function (p) { return { "x": p.x, "y": p.y }; });
        var textObj = connector.texts.toObject();
        if (textObj)
            result["texts"] = textObj;
        var propsObj = connector.properties.toObject();
        if (propsObj)
            result["properties"] = propsObj;
        var styleObj = connector.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = connector.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        return result;
    };
    // Images
    Exporter.exportSvg = function (canvasManager, callback) {
        canvasManager.exportSvgImage(callback);
    };
    Exporter.exportPng = function (canvasManager, callback) {
        canvasManager.exportPngImage(callback);
    };
    Exporter.exportJpg = function (canvasManager, callback) {
        canvasManager.exportJpgImage(callback);
    };
    return Exporter;
}());
exports.Exporter = Exporter;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(3);
var ConnectionPoint = /** @class */ (function (_super) {
    __extends(ConnectionPoint, _super);
    function ConnectionPoint(x, y, side) {
        if (side === void 0) { side = DiagramItem_1.ConnectionPointSide.Undefined; }
        var _this = _super.call(this, x, y) || this;
        _this.side = side;
        return _this;
    }
    ConnectionPoint.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new ConnectionPoint(this.x + offsetX, this.y + offsetY);
    };
    ConnectionPoint.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new ConnectionPoint(this.x * multiplierX, this.y * multiplierY);
    };
    ConnectionPoint.prototype.clone = function () { return new ConnectionPoint(this.x, this.y, this.side); };
    ConnectionPoint.prototype.toPoint = function () { return new Utils_1.Point(this.x, this.y); };
    return ConnectionPoint;
}(Utils_1.Point));
exports.ConnectionPoint = ConnectionPoint;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var Connector_1 = __webpack_require__(5);
var ConnectorPointsOrthogonalSideCalculatorBase = /** @class */ (function () {
    function ConnectorPointsOrthogonalSideCalculatorBase(parent) {
        this.parent = parent;
    }
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "connector", {
        get: function () { return this.parent.connector; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "beginRect", {
        get: function () { return this.parent.beginRect; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "endRect", {
        get: function () { return this.parent.endRect; },
        enumerable: true,
        configurable: true
    });
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getBeginOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(originPoint, targetPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getBeginOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getBeginOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getBeginOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getEndOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(targetPoint, originPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getEndOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getEndOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getEndOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSide = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY) {
            if (targetPoint.x > originPoint.x)
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.West;
        }
        else {
            if (targetPoint.y > originPoint.y)
                return DiagramItem_1.ConnectionPointSide.South;
            else
                return DiagramItem_1.ConnectionPointSide.North;
        }
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSideCalculator = function (originPoint, targetPoint) {
        return this.parent.getSideCalculator(this.getSide(originPoint, targetPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getMinOffset = function () {
        return Connector_1.Connector.minOffset;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndSame = function () {
        return this.connector.beginItem === this.connector.endItem;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlapped = function () {
        return this.beginRect && this.endRect && this.beginRect.intersect(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedX = function () {
        return this.beginRect && this.endRect && this.beginRect.intersectX(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedY = function () {
        return this.beginRect && this.endRect && this.beginRect.intersectY(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedPoints = function (beginPoint, endPoint) {
        return this.beginRect && this.endRect && (this.beginRect.contains(endPoint) || this.endRect.contains(beginPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isOriginRectContainsTargetPoint = function (originRect, targetPoint) {
        return originRect && originRect.contains(targetPoint);
    };
    return ConnectorPointsOrthogonalSideCalculatorBase;
}());
exports.ConnectorPointsOrthogonalSideCalculatorBase = ConnectorPointsOrthogonalSideCalculatorBase;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Structures_1 = __webpack_require__(22);
var Shape_1 = __webpack_require__(9);
var Utils_1 = __webpack_require__(0);
var ListUtils_1 = __webpack_require__(60);
var GraphBase = /** @class */ (function () {
    function GraphBase(nodes, edges) {
        this.nodeMap = {};
        this.edgeMap = {};
        this.nodes = [];
        this.edges = [];
        this.onInit();
        nodes.forEach(this.addNode.bind(this));
        edges.forEach(this.addEdge.bind(this));
    }
    Object.defineProperty(GraphBase.prototype, "items", {
        get: function () {
            return this.nodes.map(this.getNode.bind(this));
        },
        enumerable: true,
        configurable: true
    });
    GraphBase.prototype.onInit = function () { };
    GraphBase.prototype.addEdge = function (edge) {
        this.edgeMap[edge.key] = edge;
        this.edges.push(edge);
    };
    GraphBase.prototype.addNode = function (node) {
        this.nodeMap[node.key] = node;
        this.nodes.push(node.key);
    };
    GraphBase.prototype.getNode = function (key) {
        return this.nodeMap[key];
    };
    GraphBase.prototype.getEdge = function (key) {
        return this.edgeMap[key];
    };
    GraphBase.prototype.isEmpty = function () {
        return !this.nodes.length && !this.edges.length;
    };
    GraphBase.prototype.getAdjacentEdges = function (nodeKey, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        return this.edges.filter(function (e) {
            return connectionMode & Structures_1.ConnectionMode.Incoming && e.to === nodeKey ||
                connectionMode & Structures_1.ConnectionMode.Outgoing && e.from === nodeKey;
        });
    };
    return GraphBase;
}());
var Graph = /** @class */ (function (_super) {
    __extends(Graph, _super);
    function Graph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Graph.prototype.cast = function (castNode, castEdge) {
        var _this = this;
        var newNodes = this.nodes.map(function (nk) { return castNode(_this.getNode(nk)); });
        var newEdges = this.edges.map(function (e) { return castEdge ? castEdge(e) : e; });
        return new Graph(newNodes, newEdges);
    };
    Graph.prototype.getConnectedComponents = function () {
        var iterator = this.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = true;
        var components = [];
        var _loop_1 = function (i) {
            var nodes = [];
            var edges = [];
            iterator.onNode = function (n) { return nodes.push(n); };
            iterator.onEdge = function (e) { return edges.push(e); };
            iterator.iterate(this_1.nodes[i]);
            if (nodes.length)
                components.push(new Graph(nodes, edges));
        };
        var this_1 = this;
        for (var i = 0; i < this.nodes.length; i++) {
            _loop_1(i);
        }
        return components;
    };
    Graph.prototype.createIterator = function (connectionMode) {
        var iterator = new GraphIterator(this, connectionMode);
        iterator.comparer = function (a, b) { return a.weight - b.weight; };
        return iterator;
    };
    Graph.prototype.getSpanningGraph = function (rootKey, connectionMode, edgeWeightFunc) {
        var _this = this;
        if (edgeWeightFunc === void 0) { edgeWeightFunc = undefined; }
        if (!this.nodes.length)
            return new Graph([], []);
        if (!edgeWeightFunc)
            edgeWeightFunc = function (e) { return e.weight; };
        var sortedAdjacentEdges = [];
        var spanningTreeNodesSet = new ListUtils_1.HashSet();
        var spanningTreeEdgesSet = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        this.addNodeToSpanningGraph(rootKey, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
        while (sortedAdjacentEdges.length && spanningTreeNodesSet.length !== this.nodes.length) {
            var minWeighedEdge = sortedAdjacentEdges.shift();
            spanningTreeEdgesSet.tryPush(minWeighedEdge);
            var node = spanningTreeNodesSet.contains(minWeighedEdge.from) ? minWeighedEdge.to : minWeighedEdge.from;
            this.addNodeToSpanningGraph(node, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
            sortedAdjacentEdges = sortedAdjacentEdges.filter(function (e) { return !spanningTreeNodesSet.contains(e.from) || !spanningTreeNodesSet.contains(e.to); });
        }
        return new Graph(spanningTreeNodesSet.list().map(function (nk) { return _this.getNode(nk); }), spanningTreeEdgesSet.list());
    };
    Graph.prototype.addNodeToSpanningGraph = function (nodeKey, connectionMode, adjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc) {
        spanningTreeNodesSet.tryPush(nodeKey);
        this.getAdjacentEdges(nodeKey, connectionMode)
            .filter(function (e) { return !spanningTreeEdgesSet.contains(e); })
            .forEach(function (e) {
            var weight = edgeWeightFunc(e);
            var pos = Utils_1.Utils.binaryIndexOf(adjacentEdges, function (a) { return a.weight - weight; });
            pos = pos < 0 ? ~pos : pos;
            while (pos < adjacentEdges.length && edgeWeightFunc(adjacentEdges[pos]) === weight)
                pos++;
            adjacentEdges.splice(pos, 0, new Structures_1.Edge(e.key, e.from, e.to, weight));
        });
    };
    Graph.create = function (shapes, connectors) {
        var nodes = shapes;
        var edges = connectors
            .filter(function (i) { return i.beginItem && i.endItem instanceof Shape_1.Shape && i.endItem && i.endItem instanceof Shape_1.Shape && i.beginItem !== i.endItem; }) // TBD: ShapeItem?
            .map(function (i) { return new Structures_1.Edge(i.key, i.beginItem && i.beginItem.key, i.endItem && i.endItem.key); });
        return new Graph(nodes, edges);
    };
    return Graph;
}(GraphBase));
exports.Graph = Graph;
var FastGraph = /** @class */ (function (_super) {
    __extends(FastGraph, _super);
    function FastGraph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FastGraph.prototype.onInit = function () {
        this.parentToChildren = {};
        this.childToParents = {};
    };
    FastGraph.prototype.addEdge = function (edge) {
        _super.prototype.addEdge.call(this, edge);
        (this.parentToChildren[edge.from] || (this.parentToChildren[edge.from] = [])).push(edge.to);
        (this.childToParents[edge.to] || (this.childToParents[edge.to] = [])).push(edge.from);
    };
    FastGraph.prototype.getChildren = function (parent) {
        return this.parentToChildren[parent] || [];
    };
    FastGraph.prototype.getParents = function (child) {
        return this.childToParents[child] || [];
    };
    FastGraph.prototype.createIterator = function (connectionMode) {
        return new GraphIterator(this, connectionMode);
    };
    return FastGraph;
}(GraphBase));
exports.FastGraph = FastGraph;
var GraphIterator = /** @class */ (function () {
    function GraphIterator(graph, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        this.graph = graph;
        this.connectionMode = connectionMode;
        this.visitEachEdgeOnce = true;
        this.visitEachNodeOnce = true;
        this.visitedNodes = {};
        this.visitedEdges = {};
    }
    GraphIterator.prototype.iterate = function (nodeKey) {
        if (!this.visitEachNodeOnce && !this.visitEachEdgeOnce && !this.skipNode)
            throw "skipNode or visitEachNodeOnce or visitEachEdgeOnce must be set to avoid SOF";
        this.iterateCore(nodeKey);
    };
    GraphIterator.prototype.iterateCore = function (nodeKey) {
        var _this = this;
        var node = this.graph.getNode(nodeKey);
        if (this.skipNode && this.skipNode(node) || (this.visitEachNodeOnce && this.isNodeVisited(nodeKey)))
            return;
        this.visitedNodes[nodeKey] = true;
        this.onNode && this.onNode(node);
        var edges = this.graph.getAdjacentEdges(nodeKey, this.connectionMode);
        if (this.skipEdge)
            edges = edges.filter(function (e) { return !_this.skipEdge(e); });
        if (this.connectionMode & Structures_1.ConnectionMode.Outgoing) {
            var outgoing = edges.filter(function (e) { return e.from === nodeKey; });
            if (this.comparer)
                outgoing.sort(this.comparer);
            outgoing.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, true);
                _this.iterateCore(e.to);
                _this.onAfterEdge && _this.onAfterEdge(e, true);
            });
        }
        this.onAllEdges && this.onAllEdges(node, true);
        if (this.connectionMode & Structures_1.ConnectionMode.Incoming) {
            var incoming = edges.filter(function (e) { return e.to === nodeKey; });
            if (this.comparer)
                incoming.sort(this.comparer);
            incoming.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, false);
                _this.iterateCore(e.from);
                _this.onAfterEdge && _this.onAfterEdge(e, false);
            });
        }
        this.onAllEdges && this.onAllEdges(node, false);
    };
    GraphIterator.prototype.isNodeVisited = function (nodeKey) {
        return !!this.visitedNodes[nodeKey];
    };
    GraphIterator.prototype.isEdgeVisited = function (edgeKey) {
        return !!this.visitedEdges[edgeKey];
    };
    return GraphIterator;
}());
exports.GraphIterator = GraphIterator;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var Connector_1 = __webpack_require__(5);
var AddConnectionHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectionHistoryItem, _super);
    function AddConnectionHistoryItem(connector, item, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.itemKey = item.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    AddConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.connectionPointIndex, this.position);
    };
    AddConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnection(connector, this.position);
    };
    return AddConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectionHistoryItem = AddConnectionHistoryItem;
var SetConnectionPointIndexHistoryItem = /** @class */ (function (_super) {
    __extends(SetConnectionPointIndexHistoryItem, _super);
    function SetConnectionPointIndexHistoryItem(connector, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    SetConnectionPointIndexHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.setConnectionPointIndex(connector, this.connectionPointIndex, this.position);
    };
    SetConnectionPointIndexHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.setConnectionPointIndex(connector, this.oldConnectionPointIndex, this.position);
    };
    return SetConnectionPointIndexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetConnectionPointIndexHistoryItem = SetConnectionPointIndexHistoryItem;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var MoveConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(MoveConnectorPointHistoryItem, _super);
    function MoveConnectorPointHistoryItem(connectorKey, pointIndex, point) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.point = point;
        return _this;
    }
    MoveConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldPoint = connector.points[this.pointIndex].clone();
        manipulator.moveConnectorPoint(connector, this.pointIndex, this.point);
    };
    MoveConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.moveConnectorPoint(connector, this.pointIndex, this.oldPoint);
    };
    return MoveConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveConnectorPointHistoryItem = MoveConnectorPointHistoryItem;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var ModelUtils_1 = __webpack_require__(8);
var DataImporter_1 = __webpack_require__(119);
var DataLayoutType;
(function (DataLayoutType) {
    DataLayoutType[DataLayoutType["Tree"] = 0] = "Tree";
    DataLayoutType[DataLayoutType["Sugiyama"] = 1] = "Sugiyama";
})(DataLayoutType = exports.DataLayoutType || (exports.DataLayoutType = {}));
var DataSource = /** @class */ (function () {
    function DataSource(key, name, nodeDataSource, edgeDataSource, nodeDataImporter, edgeDataImporter) {
        this.nodes = [];
        this.edges = [];
        this.nodeKeyMap = {};
        this.edgeKeyMap = {};
        this.useNodeParentId = false;
        this.useNodeItems = false;
        if (key === undefined || key === null)
            throw new Error("DataSource key must be specified");
        this.key = key.toString();
        this.name = name;
        this.nodeDataImporter = this.createNodeDataImporter(nodeDataImporter);
        this.edgeDataImporter = this.createEdgeDataImporter(edgeDataImporter);
        this.nodeDataSource = nodeDataSource || [];
        this.edgeDataSource = edgeDataSource || [];
        this.fetchData();
    }
    DataSource.prototype.fetchData = function () {
        var _this = this;
        this.useNodeParentId = false;
        this.useNodeItems = false;
        this.nodeDataSource.forEach(function (nodeDataObj) {
            _this.addNode(nodeDataObj);
        });
        if (this.useEdgesArray()) {
            this.edgeDataSource.forEach(function (edgeDataObj) {
                _this.addEdge(edgeDataObj);
            });
        }
        else {
            this.nodes.forEach(function (node) {
                _this.addNodeEdgesByParentId(node);
            });
        }
    };
    DataSource.prototype.useEdgesArray = function () {
        return Array.isArray(this.edgeDataSource) && this.edgeDataSource.length;
    };
    DataSource.prototype.addNode = function (nodeDataObj, parentNodeDataObj) {
        var _this = this;
        var node = this.addNodeInternal(nodeDataObj, this.nodeDataImporter.getText(nodeDataObj), this.nodeDataImporter.getType(nodeDataObj), parentNodeDataObj);
        if (!this.useNodeParentId && !this.useEdgesArray()) {
            var childNodeDataObjs = this.nodeDataImporter.getItems(nodeDataObj);
            if (Array.isArray(childNodeDataObjs) && childNodeDataObjs.length) {
                childNodeDataObjs.forEach(function (childNodeDataObj) {
                    var childNode = _this.addNode(childNodeDataObj, nodeDataObj);
                    _this.addEdgeInternal(undefined, node.key, childNode.key);
                    _this.useNodeItems = true;
                });
            }
        }
        return node;
    };
    DataSource.prototype.addNodeEdgesByParentId = function (node) {
        if (!this.useNodeItems && !this.useEdgesArray()) {
            var parentKey = this.nodeDataImporter.getParentKey(node.dataObj);
            if (parentKey !== undefined && parentKey !== null) {
                this.addEdgeInternal(undefined, this.getNodeKey(node.dataObj, this.nodeDataImporter.getParentKey), this.getNodeKey(node.dataObj, this.nodeDataImporter.getKey));
                this.useNodeParentId = true;
            }
        }
    };
    DataSource.prototype.addNodeInternal = function (nodeDataObj, text, type, parentNodeDataObj) {
        var externalKey = this.nodeDataImporter.getKey(nodeDataObj);
        var key = (externalKey !== undefined && externalKey !== null) ? externalKey.toString() : ModelUtils_1.ModelUtils.getGuidItemKey();
        var node = new DataSourceNodeItem(this.key, key, nodeDataObj, text, type || ShapeType_1.ShapeType.Rectangle, parentNodeDataObj);
        this.nodes.push(node);
        if (externalKey === undefined || externalKey === null) {
            externalKey = key;
            this.nodeDataImporter.setKey(nodeDataObj, key);
        }
        if (externalKey !== undefined && externalKey !== null)
            this.nodeKeyMap[externalKey] = key;
        return node;
    };
    DataSource.prototype.addEdge = function (edgeDataObj) {
        return this.addEdgeInternal(edgeDataObj, this.getNodeKey(edgeDataObj, this.edgeDataImporter.getFrom), this.getNodeKey(edgeDataObj, this.edgeDataImporter.getTo));
    };
    DataSource.prototype.addEdgeInternal = function (edgeDataObj, from, to) {
        var externalKey = edgeDataObj && this.edgeDataImporter.getKey(edgeDataObj);
        var key = (externalKey !== undefined && externalKey !== null) ? externalKey.toString() : ModelUtils_1.ModelUtils.getGuidItemKey();
        var edge = new DataSourceEdgeItem(this.key, key, edgeDataObj, from, to);
        this.edges.push(edge);
        if (externalKey === undefined || externalKey === null) {
            externalKey = key;
            if (edgeDataObj)
                this.edgeDataImporter.setKey(edgeDataObj, key);
        }
        if (externalKey !== undefined && externalKey !== null)
            this.edgeKeyMap[externalKey] = key;
        return edge;
    };
    DataSource.prototype.findNode = function (key) {
        return this.nodes.filter(function (i) { return key !== undefined && i.key === key; })[0];
    };
    DataSource.prototype.findEdge = function (key) {
        return this.edges.filter(function (i) { return key !== undefined && i.key === key; })[0];
    };
    DataSource.prototype.getNodeKey = function (nodeDataObj, getKey) {
        return this.nodeKeyMap[getKey(nodeDataObj)];
    };
    DataSource.prototype.createModelItems = function (history, model, selection, layoutType) {
        ModelUtils_1.ModelUtils.createItemsByDataSource(history, model, selection, this, layoutType);
    };
    DataSource.prototype.createNodeDataImporter = function (importer) {
        var result = new DataImporter_1.DataSourceNodeDataImporter();
        if (importer) {
            if (importer.getKey)
                result.getKey = importer.getKey;
            if (importer.setKey)
                result.setKey = importer.setKey;
            if (importer.getText)
                result.getText = importer.getText;
            if (importer.setText)
                result.setText = importer.setText;
            if (importer.getType)
                result.getType = importer.getType;
            if (importer.setType)
                result.setType = importer.setType;
            if (importer.getParentKey)
                result.getParentKey = importer.getParentKey;
            if (importer.setParentKey)
                result.setParentKey = importer.setParentKey;
            if (importer.getItems)
                result.getItems = importer.getItems;
            if (importer.setItems)
                result.setItems = importer.setItems;
        }
        return result;
    };
    DataSource.prototype.createEdgeDataImporter = function (importer) {
        var result = new DataImporter_1.DataSourceEdgeDataImporter();
        if (importer) {
            if (importer.getKey)
                result.getKey = importer.getKey;
            if (importer.setKey)
                result.setKey = importer.setKey;
            if (importer.getFrom)
                result.getFrom = importer.getFrom;
            if (importer.setFrom)
                result.setFrom = importer.setFrom;
            if (importer.getTo)
                result.getTo = importer.getTo;
            if (importer.setTo)
                result.setTo = importer.setTo;
        }
        return result;
    };
    return DataSource;
}());
exports.DataSource = DataSource;
var DataSourceItem = /** @class */ (function () {
    function DataSourceItem(sourceKey, key, dataObj) {
        this.sourceKey = sourceKey;
        this.key = key;
        this.dataObj = dataObj;
    }
    return DataSourceItem;
}());
exports.DataSourceItem = DataSourceItem;
var DataSourceNodeItem = /** @class */ (function (_super) {
    __extends(DataSourceNodeItem, _super);
    function DataSourceNodeItem(sourceKey, key, dataObj, text, type, parentDataObj) {
        var _this = _super.call(this, sourceKey, key, dataObj) || this;
        _this.text = text;
        _this.type = type;
        _this.parentDataObj = parentDataObj;
        return _this;
    }
    return DataSourceNodeItem;
}(DataSourceItem));
exports.DataSourceNodeItem = DataSourceNodeItem;
var DataSourceEdgeItem = /** @class */ (function (_super) {
    __extends(DataSourceEdgeItem, _super);
    function DataSourceEdgeItem(sourceKey, key, dataObj, from, to) {
        var _this = _super.call(this, sourceKey, key, dataObj) || this;
        _this.sourceKey = sourceKey;
        _this.from = from;
        _this.to = to;
        return _this;
    }
    return DataSourceEdgeItem;
}(DataSourceItem));
exports.DataSourceEdgeItem = DataSourceEdgeItem;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var EllipsePrimitive = /** @class */ (function (_super) {
    __extends(EllipsePrimitive, _super);
    function EllipsePrimitive(cx, cy, rx, ry, style, className) {
        var _this = _super.call(this, style, className) || this;
        _this.cx = cx;
        _this.cy = cy;
        _this.rx = rx;
        _this.ry = ry;
        return _this;
    }
    EllipsePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "ellipse");
    };
    EllipsePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "cx", this.cx);
        this.setUnitAttribute(element, "cy", this.cy);
        this.setUnitAttribute(element, "rx", this.rx);
        this.setUnitAttribute(element, "ry", this.ry);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return EllipsePrimitive;
}(Primitive_1.SvgPrimitive));
exports.EllipsePrimitive = EllipsePrimitive;


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var NodeInfo = /** @class */ (function () {
    function NodeInfo(key, margin, size, connectionPoints) {
        if (connectionPoints === void 0) { connectionPoints = []; }
        this.key = key;
        this.margin = margin;
        this.size = size;
        this.connectionPoints = connectionPoints;
    }
    return NodeInfo;
}());
exports.NodeInfo = NodeInfo;
var NodeLayout = /** @class */ (function () {
    function NodeLayout(info, position) {
        this.info = info;
        this.position = position;
    }
    Object.defineProperty(NodeLayout.prototype, "key", {
        get: function () { return this.info.key; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NodeLayout.prototype, "rectangle", {
        get: function () {
            return new Utils_1.Rectangle(this.position, this.info.size);
        },
        enumerable: true,
        configurable: true
    });
    return NodeLayout;
}());
exports.NodeLayout = NodeLayout;
var EdgeLayout = /** @class */ (function () {
    function EdgeLayout(key, beginIndex, endIndex) {
        this.key = key;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }
    return EdgeLayout;
}());
exports.EdgeLayout = EdgeLayout;
var Margin = /** @class */ (function () {
    function Margin(top, right, bottom, left) {
        if (right === void 0) { right = top; }
        if (bottom === void 0) { bottom = top; }
        if (left === void 0) { left = top; }
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }
    Margin.empty = function () {
        return new Margin(0);
    };
    return Margin;
}());
exports.Margin = Margin;


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var BaseBuilder_1 = __webpack_require__(82);
var Graph_1 = __webpack_require__(34);
var NodeLayout_1 = __webpack_require__(39);
var Structures_1 = __webpack_require__(22);
var ListUtils_1 = __webpack_require__(60);
var Utils_1 = __webpack_require__(0);
var LayoutSettings_1 = __webpack_require__(18);
var GraphLayout_1 = __webpack_require__(81);
var Connector_1 = __webpack_require__(5);
var CycleRemover_1 = __webpack_require__(153);
var SugiyamaLayoutBuilder = /** @class */ (function (_super) {
    __extends(SugiyamaLayoutBuilder, _super);
    function SugiyamaLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SugiyamaLayoutBuilder.prototype.build = function () {
        var _this = this;
        var offset = 0;
        var layout = new GraphLayout_1.GraphLayout();
        var nodeOrderer = new SugiyamaNodesOrderer();
        this.graph.getConnectedComponents()
            .forEach(function (component) {
            var acyclicGraphInfo = CycleRemover_1.CycleRemover.removeCycles(component);
            var layers = SugiyamaLayerDistributor.getLayers(acyclicGraphInfo.graph);
            var orderedGraph = nodeOrderer.orderNodes(acyclicGraphInfo.graph, layers);
            var removedEdges = Object.keys(acyclicGraphInfo.removedEdges).map(function (ek) { return component.getEdge(ek); });
            var coordinatedGraph = nodeOrderer.assignAbsCoordinates(orderedGraph);
            var componentLayout = _this.createInfoGraphLayout(coordinatedGraph, acyclicGraphInfo.reversedEdges, removedEdges);
            layout.extend(_this.setComponentOffset(componentLayout, offset));
            offset += _this.getComponentOffset(componentLayout);
        });
        return layout;
    };
    // Order Nodes
    SugiyamaLayoutBuilder.prototype.createInfoGraphLayout = function (coordinatedGraph, reversedEdges, removedEdges) {
        var _this = this;
        var currentPosition = new Utils_1.Point(0, 0);
        var items = coordinatedGraph.items;
        var sortedLayers = new ListUtils_1.HashSet(items.map(function (n) { return n.layer; }).sort());
        var absOffsetInfo = this.getAbsOffsetInfo(coordinatedGraph.items);
        var positions = {};
        var totalDepth = 0;
        var leftEdge = Number.MAX_SAFE_INTEGER;
        var rightEdge = Number.MIN_SAFE_INTEGER;
        var _loop_1 = function (i) {
            var layer = sortedLayers.item(i);
            var maxDepthLayer = 0;
            items
                .filter(function (n) { return n.layer === layer; })
                .sort(function (a, b) { return a.position - b.position; })
                .forEach(function (n) {
                var depthNodeSize = _this.getDepthNodeSize(n);
                var directionOffset = _this.chooseDirectionValue(0, depthNodeSize);
                var absPosition = _this.getAbsPosition(n.position, _this.getBreadthNodeSize(n), absOffsetInfo);
                currentPosition = _this.setBreadth(currentPosition, absPosition);
                var nodePosition = _this.setDepthOffset(currentPosition, -directionOffset);
                positions[n.key] = nodePosition;
                if (n.isDummy)
                    return;
                var breadth = _this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal ? nodePosition.y : nodePosition.x;
                leftEdge = Math.min(leftEdge, breadth);
                rightEdge = Math.max(rightEdge, breadth + _this.getBreadthNodeSize(n));
                maxDepthLayer = Math.max(maxDepthLayer, _this.getDepthNodeSize(n));
            });
            totalDepth += maxDepthLayer;
            currentPosition = this_1.setBreadth(currentPosition, 0);
            currentPosition = this_1.setDepthOffset(currentPosition, this_1.getDirectionValue(maxDepthLayer + this_1.settings.layerSpacing));
        };
        var this_1 = this;
        for (var i = 0; i < sortedLayers.length; i++) {
            _loop_1(i);
        }
        totalDepth += (sortedLayers.length - 1) * this.settings.layerSpacing;
        var layout = new GraphLayout_1.GraphLayout();
        this.createNodesLayout(coordinatedGraph, layout, leftEdge, totalDepth, positions);
        this.createEdgesLayout(coordinatedGraph, layout, reversedEdges, removedEdges);
        return layout;
        //this.getDummyEdgesRoutes(infoGraph);
    };
    SugiyamaLayoutBuilder.prototype.createNodesLayout = function (infoGraph, layout, leftEdge, totalDepth, positions) {
        var _this = this;
        var offset = this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical ?
            new Utils_1.Point(-leftEdge, this.chooseDirectionValue(0, totalDepth)) :
            new Utils_1.Point(this.chooseDirectionValue(0, totalDepth), -leftEdge);
        infoGraph.items.forEach(function (n) {
            if (!n.isDummy) {
                var node = _this.graph.getNode(n.key);
                layout.addNode(new NodeLayout_1.NodeLayout(node, positions[n.key].offset(offset.x, offset.y)));
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.createEdgesLayout = function (infoGraph, layout, reversedEdges, removedEdges) {
        var DIRECT = this.getDirectEdgeLayout();
        var TOP_TO_BOTTOM = this.getDiffLevelEdgeLayout(true);
        var BOTTOM_TO_TOP = this.getDiffLevelEdgeLayout(false);
        var TOP_TO_TOP = this.getSameLevelEdgeLayout(true);
        var BOTTOM_TO_BOTTOM = this.getSameLevelEdgeLayout(false);
        var occupied = {};
        infoGraph.edges
            .filter(function (e) { return !e.isDummy; })
            .concat(removedEdges.map(function (e) { return new EdgeOnLayer(e.key, false, e.from, e.to); }))
            .sort(function (a, b) {
            return (infoGraph.getNode(a.originFrom).layer - infoGraph.getNode(b.originFrom).layer) ||
                (infoGraph.getNode(a.to).layer - infoGraph.getNode(b.to).layer);
        })
            .forEach(function (e) {
            var isReversed = reversedEdges[e.key];
            var from = infoGraph.getNode(isReversed ? e.to : e.originFrom);
            var to = infoGraph.getNode(isReversed ? e.originFrom : e.to);
            if (to.layer - from.layer === 1)
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, DIRECT.from, DIRECT.to));
            else {
                var candidates_1 = [];
                if (to.position - from.position >= 1) {
                    candidates_1.push(TOP_TO_BOTTOM);
                    candidates_1.push({ from: DIRECT.from, to: TOP_TO_BOTTOM.to });
                    candidates_1.push({ from: TOP_TO_BOTTOM.from, to: DIRECT.to });
                }
                else if (to.position - from.position <= -1) {
                    candidates_1.push(BOTTOM_TO_TOP);
                    candidates_1.push({ from: DIRECT.from, to: BOTTOM_TO_TOP.to });
                    candidates_1.push({ from: BOTTOM_TO_TOP.from, to: DIRECT.to });
                }
                else {
                    var oneliner = from.position === to.position && to.position === 0 ? [TOP_TO_TOP, BOTTOM_TO_BOTTOM] : [BOTTOM_TO_BOTTOM, TOP_TO_TOP];
                    oneliner.forEach(function (c) { return candidates_1.push(c); });
                    oneliner.forEach(function (c) {
                        candidates_1.push({ from: c.from, to: DIRECT.to });
                        candidates_1.push({ from: DIRECT.from, to: c.to });
                    });
                }
                candidates_1.push(DIRECT);
                for (var i = 0, candidate = void 0; candidate = candidates_1[i]; i++) {
                    var fromKey = from.key + "_" + candidate.from;
                    var toKey = to.key + "_" + candidate.to;
                    if (occupied[fromKey] !== Connector_1.ConnectorPosition.End && occupied[toKey] !== Connector_1.ConnectorPosition.Begin) {
                        layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, candidate.from, candidate.to));
                        occupied[fromKey] = Connector_1.ConnectorPosition.Begin;
                        occupied[toKey] = Connector_1.ConnectorPosition.End;
                        break;
                    }
                }
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.getDirectEdgeLayout = function () {
        if (this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal)
            return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 1, to: 3 } : { from: 3, to: 1 };
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 2, to: 0 } : { from: 0, to: 2 };
    };
    SugiyamaLayoutBuilder.prototype.getDiffLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal)
            return topToBottom ? { from: 2, to: 0 } : { from: 0, to: 2 };
        return topToBottom ? { from: 3, to: 1 } : { from: 1, to: 3 };
    };
    SugiyamaLayoutBuilder.prototype.getSameLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal)
            return topToBottom ? { from: 0, to: 0 } : { from: 2, to: 2 };
        return topToBottom ? { from: 3, to: 3 } : { from: 1, to: 1 };
    };
    // private getDummyEdgesRoutes(infoGraph: FastGraph<NodeOnLayer, EdgeOnLayer>): {[nodeKey: string]: NodeOnLayer[]} {
    //     let resultRoutes: {[nodeKey: string]: NodeOnLayer[]} = {};
    //     let dummyEdgeRoutes: {[edgeHash: string]: NodeOnLayer[]} = {};
    //     infoGraph.edges
    //         .filter(e => !infoGraph.getNode(e.from).isDummy && infoGraph.getNode(e.to).isDummy)
    //         .forEach(rootEdge => {
    //             let edgeHash = rootEdge.getHashCode();
    //             dummyEdgeRoutes[edgeHash] = [];
    //             let iterator = infoGraph.createIterator(ConnectionMode.Outgoing);
    //             iterator.visitEachEdgeOnce = false;
    //             iterator.onNode = (n) => dummyEdgeRoutes[edgeHash].push(n);
    //             iterator.skipNode = (n) => !n.isDummy;
    //             iterator.skipEdge = (e) => false;
    //             iterator.onEdge = (e, out) => {
    //                 if(!infoGraph.getNode(e.to).isDummy)
    //                     resultRoutes[new EdgeOnLayer(e.key, e.isDummy, rootEdge.from, e.to).getHashCode()] = dummyEdgeRoutes[edgeHash];
    //             };
    //             iterator.iterate(rootEdge.to);
    //         });
    //     return resultRoutes;
    // }
    SugiyamaLayoutBuilder.prototype.getAbsOffsetInfo = function (nodesInfos) {
        var _this = this;
        var absOffsetMatrix = {};
        var addCell = function (n, intAbsCoord) {
            if (absOffsetMatrix[intAbsCoord] === undefined)
                absOffsetMatrix[intAbsCoord] = _this.getBreadthNodeSize(n);
            absOffsetMatrix[intAbsCoord] = Math.max(absOffsetMatrix[intAbsCoord], _this.getBreadthNodeSize(n));
        };
        nodesInfos.forEach(function (n) {
            var intAbsCoord = Math.trunc(n.position);
            addCell(n, intAbsCoord);
            if (absOffsetMatrix[intAbsCoord] % 1 !== 0)
                addCell(n, intAbsCoord + 1);
        });
        var absOffsetInfo = {};
        var leftOffset = 0;
        Object.keys(absOffsetMatrix).sort().forEach(function (coord) {
            absOffsetInfo[coord] = { leftOffset: leftOffset, width: absOffsetMatrix[coord] };
            leftOffset += absOffsetMatrix[coord] + _this.settings.columnSpacing;
        });
        return absOffsetInfo;
    };
    SugiyamaLayoutBuilder.prototype.setBreadth = function (position, breadthPosition) {
        if (this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical)
            return new Utils_1.Point(breadthPosition, position.y);
        return new Utils_1.Point(position.x, breadthPosition);
    };
    SugiyamaLayoutBuilder.prototype.setDepthOffset = function (position, offset) {
        if (this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal)
            return new Utils_1.Point(position.x + offset, position.y);
        return new Utils_1.Point(position.x, position.y + offset);
    };
    SugiyamaLayoutBuilder.prototype.getAbsPosition = function (absCoordinate, itemSize, absoluteOffsetInfo) {
        var intAbsCoord = Math.trunc(absCoordinate);
        var absLeftOffset = absoluteOffsetInfo[intAbsCoord].leftOffset;
        var cellWidth = absoluteOffsetInfo[intAbsCoord].width;
        if (absCoordinate % 1 === 0)
            return absLeftOffset + (cellWidth - itemSize) / 2;
        return absLeftOffset + cellWidth - (itemSize - this.settings.columnSpacing) / 2;
    };
    SugiyamaLayoutBuilder.prototype.getBreadthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getBreadthNodeSizeCore(this.graph.getNode(node.key));
    };
    SugiyamaLayoutBuilder.prototype.getDepthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getDepthNodeSizeCore(this.graph.getNode(node.key));
    };
    return SugiyamaLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.SugiyamaLayoutBuilder = SugiyamaLayoutBuilder;
var SugiyamaLayerDistributor = /** @class */ (function () {
    function SugiyamaLayerDistributor() {
    }
    SugiyamaLayerDistributor.getLayers = function (acyclicGraph) {
        var feasibleTree = this.getFeasibleTree(acyclicGraph);
        return this.calcNodesLayers(feasibleTree);
    };
    SugiyamaLayerDistributor.getFeasibleTree = function (graph) {
        var layers = this.initLayerAssignment(graph);
        return graph.getSpanningGraph(graph.nodes[0], Structures_1.ConnectionMode.OutgoingAndIncoming, function (e) { return layers[e.to] - layers[e.from]; });
    };
    SugiyamaLayerDistributor.initLayerAssignment = function (graph) {
        var layers = {};
        var currentLayer = 0;
        var actualAssignedNodes = {};
        var assigningNodes = graph.nodes.filter(function (n) { return !graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).length; });
        var _loop_2 = function () {
            assigningNodes.forEach(function (n) {
                layers[n] = currentLayer;
                actualAssignedNodes[n] = true;
            });
            Object.keys(actualAssignedNodes).forEach(function (n) {
                if (graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing).filter(function (e) { return layers[e.to] === undefined; }).length === 0)
                    delete actualAssignedNodes[n];
            });
            var assigningNodesSet = {};
            Object.keys(actualAssignedNodes).forEach(function (n) {
                graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing)
                    .map(function (e) { return e.to; })
                    .filter(function (n) { return layers[n] === undefined && graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).reduce(function (acc, e) { return acc && layers[e.from] !== undefined; }, true); })
                    .forEach(function (n) { return assigningNodesSet[n] = true; });
            });
            assigningNodes = Object.keys(assigningNodesSet);
            currentLayer++;
        };
        while (assigningNodes.length) {
            _loop_2();
        }
        return layers;
    };
    SugiyamaLayerDistributor.calcNodesLayers = function (graph) {
        var layers = {};
        var minLayer = Number.MAX_SAFE_INTEGER;
        var currentLevel = 0;
        var iterator = graph.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            layers[n.key] = currentLevel;
            minLayer = Math.min(minLayer, currentLevel);
        };
        iterator.skipNode = function (n) { return layers[n.key] !== undefined; };
        iterator.skipEdge = function (e) { return layers[e.from] !== undefined && layers[e.to] !== undefined; };
        iterator.onEdge = function (e, out) {
            if (out)
                currentLevel = layers[e.from] + 1;
            else
                currentLevel = layers[e.to] - 1;
        };
        iterator.iterate(graph.nodes[0]);
        for (var key in layers) {
            if (!layers.hasOwnProperty(key))
                continue;
            layers[key] -= minLayer;
        }
        return layers;
    };
    return SugiyamaLayerDistributor;
}());
exports.SugiyamaLayerDistributor = SugiyamaLayerDistributor;
var SugiyamaNodesOrderer = /** @class */ (function () {
    function SugiyamaNodesOrderer() {
        this.idCounter = -10000;
    }
    SugiyamaNodesOrderer.prototype.orderNodes = function (graph, layers) {
        var maxIteration = 14; //magic number - http://www.graphviz.org/Documentation/TSE93.pdf PAGE (14)
        var currentIteration = 1;
        var graphInfo = this.initGraphInfo(graph, layers);
        var nodeInfos = graphInfo.items;
        var orderInfo = this.initOrder(nodeInfos);
        var bestNodesPositions = this.getNodeToPositionMap(nodeInfos);
        var bestCrossCount = this.getCrossCount(orderInfo, graphInfo);
        var isParentToChildren = true;
        while (currentIteration < maxIteration && bestCrossCount != 0) {
            orderInfo = this.getNodesOrder(orderInfo, graphInfo, isParentToChildren);
            var crossCount = this.getCrossCount(orderInfo, graphInfo);
            if (crossCount < bestCrossCount) {
                bestNodesPositions = this.getNodeToPositionMap(graphInfo.items);
                bestCrossCount = crossCount;
            }
            isParentToChildren = !isParentToChildren;
            currentIteration++;
        }
        //transpose() procedure doesn`t implement.
        //http://www.graphviz.org/Documentation/TSE93.pdf PAGE(16)
        graphInfo.items.forEach(function (n) { return n.position = bestNodesPositions[n.key]; });
        return graphInfo;
    };
    SugiyamaNodesOrderer.prototype.getNodesOrder = function (current, graph, isParentToChildren) {
        var _this = this;
        var order = {};
        var _loop_3 = function (layer) {
            if (!current.hasOwnProperty(layer))
                return "continue";
            var nodePositions = {};
            current[layer].forEach(function (ni) {
                var adjacentNodesPositions = (isParentToChildren ? graph.getChildren(ni.key) : graph.getParents(ni.key))
                    .map(function (nk) { return graph.getNode(nk).position; });
                nodePositions[ni.key] = _this.getNodePosition(adjacentNodesPositions);
            });
            order[layer] = this_2.sortNodes(nodePositions, graph);
        };
        var this_2 = this;
        for (var layer in current) {
            _loop_3(layer);
        }
        return order;
    };
    SugiyamaNodesOrderer.prototype.sortNodes = function (nodePositions, graph) {
        return Object.keys(nodePositions)
            .sort(function (a, b) { return nodePositions[a] - nodePositions[b]; })
            .map(function (nk, index) {
            var node = graph.getNode(nk);
            node.position = index;
            return node;
        });
    };
    SugiyamaNodesOrderer.prototype.getNodePosition = function (adjacentNodesPositions) {
        adjacentNodesPositions = adjacentNodesPositions.sort();
        if (!adjacentNodesPositions.length)
            return 0;
        var medianIndex = Math.floor(adjacentNodesPositions.length / 2);
        if (adjacentNodesPositions.length === 2 || adjacentNodesPositions.length % 2 === 1)
            return adjacentNodesPositions[medianIndex];
        var leftMedianPosition = adjacentNodesPositions[medianIndex - 1] - adjacentNodesPositions[0];
        var rightMedianPosition = adjacentNodesPositions[adjacentNodesPositions.length - 1] - adjacentNodesPositions[medianIndex];
        return Math.floor((adjacentNodesPositions[medianIndex - 1] * rightMedianPosition + adjacentNodesPositions[medianIndex] * leftMedianPosition) /
            (leftMedianPosition + rightMedianPosition));
    };
    SugiyamaNodesOrderer.prototype.initOrder = function (nodeInfos) {
        var result = {};
        nodeInfos.forEach(function (ni) { return (result[ni.layer] || (result[ni.layer] = [])).push(ni); });
        return result;
    };
    SugiyamaNodesOrderer.prototype.getCrossCount = function (orderInfo, graph) {
        var count = 0;
        var _loop_4 = function (layer) {
            if (!orderInfo.hasOwnProperty(layer))
                return "continue";
            var viewedAdjacentNodesPositions = [];
            orderInfo[layer].forEach(function (n) {
                var positions = graph.getChildren(n.key).map(function (c) { return graph.getNode(c).position; });
                positions.forEach(function (p) {
                    count += viewedAdjacentNodesPositions.filter(function (vp) { return p < vp; }).length;
                });
                viewedAdjacentNodesPositions.push.apply(viewedAdjacentNodesPositions, positions);
            });
        };
        for (var layer in orderInfo) {
            _loop_4(layer);
        }
        return count;
    };
    SugiyamaNodesOrderer.prototype.initGraphInfo = function (graph, layers) {
        var _this = this;
        var countNodesOnLayer = {};
        var nodesInfoMap = {};
        var nodeInfos = [];
        var edgeInfos = [];
        graph.nodes.forEach(function (n) {
            var layer = layers[n];
            if (countNodesOnLayer[layer] === undefined)
                countNodesOnLayer[layer] = 0;
            var info = new NodeOnLayer(n, false, layer, countNodesOnLayer[layer]++);
            nodesInfoMap[n] = info;
            nodeInfos.push(info);
        });
        graph.edges.forEach(function (e) {
            var span = layers[e.to] - layers[e.from];
            if (span > 1) {
                var prevNodeInfo = nodesInfoMap[e.from];
                for (var delta = 1; delta < span; delta++) {
                    var dNodeInfo = new NodeOnLayer(_this.createDummyID(), true, layers[e.from] + delta, countNodesOnLayer[layers[e.from] + delta]++);
                    edgeInfos.push(new EdgeOnLayer(_this.createDummyID(), true, prevNodeInfo.key, dNodeInfo.key));
                    nodeInfos.push(dNodeInfo);
                    prevNodeInfo = dNodeInfo;
                }
                edgeInfos.push(new EdgeOnLayer(e.key, false, prevNodeInfo.key, nodesInfoMap[e.to].key, nodesInfoMap[e.from].key));
            }
            else
                edgeInfos.push(new EdgeOnLayer(e.key, false, nodesInfoMap[e.from].key, nodesInfoMap[e.to].key));
        });
        return new Graph_1.FastGraph(nodeInfos, edgeInfos);
    };
    SugiyamaNodesOrderer.prototype.createDummyID = function () {
        return "dummy_" + --this.idCounter;
    };
    SugiyamaNodesOrderer.prototype.getNodeToPositionMap = function (nodeInfos) {
        return nodeInfos.reduce(function (acc, ni) {
            acc[ni.key] = ni.position;
            return acc;
        }, {});
    };
    // absolute positioning
    SugiyamaNodesOrderer.prototype.assignAbsCoordinates = function (graph) {
        var absCoordinates = this.getAbsCoodinate(graph);
        return new Graph_1.FastGraph(graph.items.map(function (n) { return new NodeOnLayer(n.key, n.isDummy, n.layer, absCoordinates[n.key]); }), graph.edges.slice(0));
    };
    SugiyamaNodesOrderer.prototype.getAbsCoodinate = function (graph) {
        var _this = this;
        var orderInfo = graph.items.reduce(function (acc, n) {
            acc[n.layer] = acc[n.layer] || [];
            var pos = Utils_1.Utils.binaryIndexOf(acc[n.layer], function (ni) { return ni.position - n.position; });
            acc[n.layer].splice(pos < 0 ? ~pos : pos, 0, n);
            return acc;
        }, {});
        var medianPositions = [MedianAlignmentMode.TopLeft, MedianAlignmentMode.TopRight, MedianAlignmentMode.BottomLeft, MedianAlignmentMode.BottomRight]
            .map(function (alignment) { return _this.getPositionByMedian(graph, alignment, orderInfo); });
        var nodeToPosition = {};
        graph.items.forEach(function (n) {
            var posList = medianPositions.map(function (positions) { return positions[n.key]; }).sort();
            nodeToPosition[n.key] = (posList[1] + posList[2]) / 2;
        });
        return nodeToPosition;
    };
    SugiyamaNodesOrderer.prototype.getPositionByMedian = function (graph, alignment, orderInfo) {
        var nodeInfos = graph.items;
        var positions = this.getNodeToPositionMap(nodeInfos);
        var medians = this.getMedians(graph, nodeInfos, alignment);
        medians = this.resolveMedianConflicts(graph, orderInfo, medians, alignment);
        this.getSortedBlocks(graph, nodeInfos, medians, alignment)
            .forEach(function (block) {
            var maxPos = block.reduce(function (acc, n) { return positions[n.key] > acc ? positions[n.key] : acc; }, -2);
            block.forEach(function (n) {
                var delta = maxPos - positions[n.key];
                if (delta > 0) {
                    orderInfo[n.layer]
                        .filter(function (ln) { return ln.position > n.position; })
                        .forEach(function (ln) { return positions[ln.key] += delta; });
                }
                positions[n.key] = maxPos;
            });
        });
        return positions;
    };
    SugiyamaNodesOrderer.prototype.getSortedBlocks = function (graph, nodeInfos, medians, alignment) {
        var blocks = [];
        var isBottom = alignment === MedianAlignmentMode.BottomLeft || alignment === MedianAlignmentMode.BottomRight;
        var allNodesInfo = new ListUtils_1.HashSet(nodeInfos.slice(0).sort(function (a, b) { return isBottom ? (a.layer - b.layer) : (b.layer - a.layer); }), function (n) { return n.key; });
        while (allNodesInfo.length) {
            var firstNode = allNodesInfo.item(0);
            var block = this.getBlock(graph, firstNode, medians, alignment);
            blocks.push(block);
            block.forEach(function (n) { return allNodesInfo.remove(n); });
        }
        blocks.sort(function (x, y) {
            var xMinNodeInfo = x.reduce(function (min, n) { return n.position < min.position ? n : min; }, x[0]);
            var yOnMinXLayer = y.filter(function (n) { return n.layer == xMinNodeInfo.layer; })[0];
            if (yOnMinXLayer)
                return xMinNodeInfo.position - yOnMinXLayer.position;
            var yMinNodeInfo = y.reduce(function (min, n) { return n.position < min.position ? n : min; }, y[0]);
            var xOnMinXLayer = x.filter(function (n) { return n.layer == yMinNodeInfo.layer; })[0];
            if (xOnMinXLayer)
                return xOnMinXLayer.position - yMinNodeInfo.position;
            return xMinNodeInfo.layer - yMinNodeInfo.layer;
        });
        return blocks;
    };
    SugiyamaNodesOrderer.prototype.getBlock = function (graph, root, medians, alignment) {
        var block = [];
        var median = null;
        do {
            if (median)
                root = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? graph.getNode(median.from) : graph.getNode(median.to);
            block.push(root);
            median = medians[root.key];
        } while (median);
        return block;
    };
    SugiyamaNodesOrderer.prototype.resolveMedianConflicts = function (graph, layers, medians, alignment) {
        var _this = this;
        var filteredMedians = {};
        var _loop_5 = function (layer) {
            var minPos = undefined, maxPos = undefined;
            if (!layers.hasOwnProperty(layer))
                return "continue";
            var nodeInfos = layers[layer];
            if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
                nodeInfos = nodeInfos.slice(0).sort(function (a, b) { return b.position - a.position; }); // sorted descending
            nodeInfos.forEach(function (n) {
                var median = medians[n.key];
                if (!median)
                    filteredMedians[n.key] = null;
                else {
                    var medianItemKey = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? median.from : median.to;
                    var medianPosition = graph.getNode(medianItemKey).position;
                    if (_this.checkMedianConfict(minPos, maxPos, medianPosition, alignment))
                        filteredMedians[n.key] = null;
                    else {
                        minPos = minPos === undefined ? medianPosition : Math.min(minPos, medianPosition);
                        maxPos = maxPos === undefined ? medianPosition : Math.max(maxPos, medianPosition);
                        filteredMedians[n.key] = median;
                    }
                }
            });
        };
        for (var layer in layers) {
            _loop_5(layer);
        }
        return filteredMedians;
    };
    SugiyamaNodesOrderer.prototype.checkMedianConfict = function (min, max, medianPosition, alignment) {
        if (min === undefined || max === undefined)
            return false;
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return max >= medianPosition;
        return min <= medianPosition;
    };
    SugiyamaNodesOrderer.prototype.getMedians = function (graph, nodeInfos, alignment) {
        var _this = this;
        var medians = {};
        nodeInfos.forEach(function (n) {
            var actualAdjacentEdges = _this.getActualAdjacentEdges(graph, n, alignment);
            var medianPosition = _this.getMedianPosition(actualAdjacentEdges.length, alignment);
            medians[n.key] = actualAdjacentEdges[medianPosition];
        });
        return medians;
    };
    SugiyamaNodesOrderer.prototype.getMedianPosition = function (length, alignment) {
        if (length === 0)
            return -1;
        if (length % 2 !== 0)
            return Math.floor(length / 2);
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return Math.floor(length / 2) - 1;
        if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
            return Math.floor(length / 2);
        throw new Error("Invalid Operation");
    };
    SugiyamaNodesOrderer.prototype.getActualAdjacentEdges = function (graph, node, alignment) {
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight)
            return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Incoming).sort(function (a, b) { return graph.getNode(a.from).position - graph.getNode(b.from).position; });
        return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Outgoing).sort(function (a, b) { return graph.getNode(a.to).position - graph.getNode(b.to).position; });
    };
    return SugiyamaNodesOrderer;
}());
exports.SugiyamaNodesOrderer = SugiyamaNodesOrderer;
var NodeOnLayer = /** @class */ (function () {
    function NodeOnLayer(key, isDummy, layer, position) {
        this.key = key;
        this.isDummy = isDummy;
        this.layer = layer;
        this.position = position;
    }
    NodeOnLayer.prototype.getHashCode = function () {
        return this.key.toString();
    };
    return NodeOnLayer;
}());
exports.NodeOnLayer = NodeOnLayer;
var EdgeOnLayer = /** @class */ (function () {
    function EdgeOnLayer(key, isDummy, from, to, originFrom) {
        this.key = key;
        this.isDummy = isDummy;
        this.from = from;
        this.to = to;
        this._originFrom = originFrom;
    }
    EdgeOnLayer.prototype.getHashCode = function () {
        return this.from + "-" + this.to;
    };
    Object.defineProperty(EdgeOnLayer.prototype, "originFrom", {
        get: function () {
            return this._originFrom !== undefined ? this._originFrom : this.from;
        },
        enumerable: true,
        configurable: true
    });
    return EdgeOnLayer;
}());
exports.EdgeOnLayer = EdgeOnLayer;
var MedianAlignmentMode;
(function (MedianAlignmentMode) {
    MedianAlignmentMode[MedianAlignmentMode["TopLeft"] = 0] = "TopLeft";
    MedianAlignmentMode[MedianAlignmentMode["TopRight"] = 1] = "TopRight";
    MedianAlignmentMode[MedianAlignmentMode["BottomLeft"] = 2] = "BottomLeft";
    MedianAlignmentMode[MedianAlignmentMode["BottomRight"] = 3] = "BottomRight";
})(MedianAlignmentMode || (MedianAlignmentMode = {}));


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StylePropertyCommandBase_1 = __webpack_require__(85);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(42);
var Style_1 = __webpack_require__(47);
var ToggleStyleTextPropertyCommand = /** @class */ (function (_super) {
    __extends(ToggleStyleTextPropertyCommand, _super);
    function ToggleStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleStyleTextPropertyCommand.prototype.getStateValue = function () {
        var value = this.control.selection.inputPosition.getStyleTextPropertyValue(this.getStyleProperty());
        return value === this.getStylePropertyValue();
    };
    ToggleStyleTextPropertyCommand.prototype.executeCore = function (state) {
        var _this = this;
        this.control.history.beginTransaction();
        var styleProperty = this.getStyleProperty();
        var styleValue = state.value ? Style_1.StyleText.defaultInstace[styleProperty] : this.getStylePropertyValue();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            _this.control.history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue));
        });
        this.control.selection.inputPosition.setStyleTextPropertyValue(this.getStyleProperty(), styleValue);
        this.control.history.endTransaction();
        return true;
    };
    ToggleStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    return ToggleStyleTextPropertyCommand;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ToggleStyleTextPropertyCommand = ToggleStyleTextPropertyCommand;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleHistoryItemBase_1 = __webpack_require__(86);
var ChangeStyleTextHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeStyleTextHistoryItem, _super);
    function ChangeStyleTextHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleTextHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.styleText[this.styleProperty];
        manipulator.changeStyleText(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleTextHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyleText(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleTextHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleTextHistoryItem = ChangeStyleTextHistoryItem;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var Graph_1 = __webpack_require__(34);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Structures_1 = __webpack_require__(22);
var ModelUtils_1 = __webpack_require__(8);
var LayoutUtils_1 = __webpack_require__(59);
var LayoutSettings_1 = __webpack_require__(18);
var AutoLayoutCommandBase = /** @class */ (function (_super) {
    __extends(AutoLayoutCommandBase, _super);
    function AutoLayoutCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty());
    };
    AutoLayoutCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var graph = this.getGraphBySelection();
        var layout = this.createLayout(graph);
        var nonGraphItems = ModelUtils_1.ModelUtils.getSymmetricDifference(layout.nodeToLayout, this.control.model.items);
        layout = ModelUtils_1.ModelUtils.offsetLayoutToFreeSpace(layout, nonGraphItems.map(function (i) { return i.rectangle; }));
        if (this.control.model.snapToGrid)
            ModelUtils_1.ModelUtils.adjustLayoutToSnapGrid(this.control.model, layout);
        ModelUtils_1.ModelUtils.applyLayoutToNodes(this.control.history, this.control.model, layout, graph.edges.map(function (e) { return _this.control.model.findConnector(e.key); }));
        ModelUtils_1.ModelUtils.applyLayoutToConnectors(this.control.history, layout, graph.edges.map(function (e) { return _this.control.model.findConnector(e.key); }));
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.endTransaction();
        return true;
    };
    AutoLayoutCommandBase.prototype.getGraphBySelection = function () {
        var _this = this;
        var selectedItems = this.control.selection.getSelectedItems();
        var graph = new Graph_1.Graph([], []);
        var knownIds = {};
        selectedItems.forEach(function (c) { return _this.extendByConnectedComponents(c, graph, knownIds); });
        graph.nodes = graph.nodes.sort(function (a, b) { return _this.control.model.findShape(a).key.localeCompare(_this.control.model.findShape(b).key); });
        return graph;
    };
    AutoLayoutCommandBase.prototype.extendByConnectedComponents = function (item, graph, knownIds) {
        var _this = this;
        if (!item || knownIds[item.key])
            return;
        knownIds[item.key] = true;
        if (item instanceof Connector_1.Connector && item.beginItem && item.endItem && item.beginItem !== item.endItem) {
            graph.addEdge(new Structures_1.Edge(item.key, item.beginItem && item.beginItem.key, item.endItem && item.endItem.key));
            this.extendByConnectedComponents(item.beginItem, graph, knownIds);
            this.extendByConnectedComponents(item.endItem, graph, knownIds);
        }
        else if (item instanceof Shape_1.Shape) {
            graph.addNode(LayoutUtils_1.LayoutUtils.shapeToLayout(item));
            item.attachedConnectors.forEach(function (c) { return _this.extendByConnectedComponents(c, graph, knownIds); });
        }
    };
    AutoLayoutCommandBase.prototype.createLayoutSettings = function () {
        return (this.control.model.snapToGrid) ? new LayoutSettings_1.TreeLayoutSettings(this.control.model.gridSize) : new LayoutSettings_1.TreeLayoutSettings();
    };
    return AutoLayoutCommandBase;
}(CommandBase_1.CommandBase));
exports.AutoLayoutCommandBase = AutoLayoutCommandBase;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ModelChange_1 = __webpack_require__(48);
var Shape_1 = __webpack_require__(9);
var Event_1 = __webpack_require__(14);
var Connector_1 = __webpack_require__(5);
var Utils_1 = __webpack_require__(0);
var UnitConverter_1 = __webpack_require__(13);
var Model_1 = __webpack_require__(21);
var ConnectorProperties_1 = __webpack_require__(28);
var DiagramItem_1 = __webpack_require__(3);
var TextPrimitive_1 = __webpack_require__(50);
var RectaglePrimitive_1 = __webpack_require__(53);
var EllipsePrimitive_1 = __webpack_require__(38);
var ClipPathPrimitive_1 = __webpack_require__(52);
var PatternPrimitive_1 = __webpack_require__(182);
var PathPrimitive_1 = __webpack_require__(2);
var GroupPrimitive_1 = __webpack_require__(183);
var MaskPrimitive_1 = __webpack_require__(184);
var TextFilterPrimitive_1 = __webpack_require__(72);
var RenderManager_1 = __webpack_require__(10);
var Browser_1 = __webpack_require__(20);
var LinePrimitive_1 = __webpack_require__(69);
var ExtensionLinesVisualizer_1 = __webpack_require__(92);
var Utils_2 = __webpack_require__(26);
var Base_1 = __webpack_require__(19);
var CanvasManager = /** @class */ (function () {
    function CanvasManager(svgElement) {
        this.itemSelectorGroupContainers = {};
        this.itemSelectorElements = {};
        this.itemGroupContainers = {};
        this.itemElements = {};
        this.itemSelectionRectElements = {};
        this.connectorSelectionElements = {};
        this.connectorSelectionTextElements = {};
        this.connectorSelectionMaskTextElements = {};
        this.selectionMarkElements = [];
        this.lockedSelectionMarkElements = {};
        this.parameterPointMarkElements = {};
        this.connectionPointElements = [];
        this.connectionTargetElements = [];
        this.connectionMarkElements = [];
        this.extensionLineElements = [];
        this.gridPatternId = Utils_2.RenderUtils.generateSvgElementId("gridPattern");
        this.pagesGridPatternId = Utils_2.RenderUtils.generateSvgElementId("pagesGridPattern");
        this.pagesGridClipId = Utils_2.RenderUtils.generateSvgElementId("pagesGridClip");
        this.initializeContainerElements(svgElement);
    }
    CanvasManager.prototype.initializeContainerElements = function (svgElement) {
        this.svgElement = svgElement;
        this.backgroundContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
        this.itemSelectorsContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
        this.itemsContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
        this.itemSelectionContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
        this.visualizersContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
        this.selectionMarksContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.svgElement);
    };
    CanvasManager.prototype.clear = function () {
        Utils_2.RenderUtils.removeContent(this.itemSelectorsContainer);
        Utils_2.RenderUtils.removeContent(this.itemsContainer);
        Utils_2.RenderUtils.removeContent(this.itemSelectionContainer);
        Utils_2.RenderUtils.removeContent(this.selectionMarksContainer);
        Utils_2.RenderUtils.removeContent(this.visualizersContainer);
        this.itemSelectorGroupContainers = {};
        this.itemSelectorElements = {};
        this.itemGroupContainers = {};
        this.itemElements = {};
        this.itemSelectionRectElements = {};
        this.connectorSelectionElements = {};
        this.connectorSelectionTextElements = {};
        this.connectorSelectionMaskTextElements = {};
        this.selectionMarkElements = [];
        this.lockedSelectionMarkElements = {};
        this.parameterPointMarkElements = {};
        this.selectionRectElement = undefined;
        this.resizeInfoElement = undefined;
        this.connectionPointElements = [];
        this.connectionTargetElements = [];
        this.connectionMarkElements = [];
        this.extensionLineElements = [];
    };
    // Notifications
    CanvasManager.prototype.NotifyModelChanged = function (changes) {
        for (var i = 0, change = void 0; change = changes[i]; i++) {
            if (change instanceof ModelChange_1.ShapeChange)
                this.applyShapeChange(change);
            else if (change instanceof ModelChange_1.ConnectorChange)
                this.applyConnectorChange(change);
            else if (change instanceof ModelChange_1.PageChange)
                this.applyPageChange(change);
        }
    };
    CanvasManager.prototype.NotifyRedrawSelection = function (selection) {
        var _this = this;
        this.hideSelection();
        var items = selection.getSelectedItems(true);
        var shapes = selection.getSelectedShapes(true);
        var connectors = selection.getSelectedConnectors(true);
        if (items.length <= 1) {
            shapes.forEach(function (shape) {
                if (shape.locked)
                    _this.showLockedSelectionMarks(shape);
                else {
                    var shapeRect = _this.correctShapeSelectionRect(shape.rectangle.multiply(_this.zoomLevel), CanvasManager.selectionRectLineWidth);
                    _this.showShapeSelectionRect(shape, shapeRect, Event_1.MouseEventElementType.SelectionRect, "item-selection-rect");
                    _this.showShapeSelectionMarks(shape);
                    _this.showShapeParameterPoints(shape);
                }
            });
            connectors.forEach(function (connector) {
                if (connector.locked)
                    _this.showLockedSelectionMarks(connector);
                else {
                    _this.showConnectorSelection(connector, "connector-selection");
                    _this.showConnectorSelectionMarks(connector);
                }
            });
        }
        else {
            var rect = this.correctShapeSelectionRect(Model_1.DiagramModel.getRectangle(items.filter(function (item) { return !item.locked; })).multiply(this.zoomLevel), CanvasManager.selectionRectLineWidth);
            this.showShapeSelectionRect(null, rect, Event_1.MouseEventElementType.SelectionRect, "items-selection-rect");
            shapes.forEach(function (shape) {
                if (shape.locked)
                    _this.showLockedSelectionMarks(shape);
                else {
                    var shapeRect = _this.correctShapeSelectionRect(shape.rectangle.multiply(_this.zoomLevel), CanvasManager.multiSelectionRectLineWidth);
                    _this.showShapeSelectionRect(shape, shapeRect, Event_1.MouseEventElementType.SelectionRect, "item-multi-selection-rect");
                    _this.showShapeParameterPoints(shape);
                }
            });
            connectors.forEach(function (connector) {
                if (connector.locked)
                    _this.showLockedSelectionMarks(connector);
                else
                    _this.showConnectorSelection(connector, "connector-multi-selection");
            });
            if (shapes.length > 0)
                this.showSelectionMarks(rect, "-1");
        }
    };
    CanvasManager.prototype.NotifySelectionRectShow = function (rect) {
        this.showSelectionRect(rect.multiply(this.zoomLevel));
    };
    CanvasManager.prototype.NotifySelectionRectHide = function () {
        this.hideSelectionRect();
    };
    CanvasManager.prototype.NotifyResizeInfoShow = function (point, text) {
        this.showResizeInfo(point.multiply(this.zoomLevel), text);
    };
    CanvasManager.prototype.NotifyResizeInfoHide = function () {
        this.hideResizeInfo();
    };
    CanvasManager.prototype.NotifyConnectionPointsShow = function (key, points, activePointIndex) {
        var _this = this;
        points.forEach(function (p, index) {
            _this.showConnectionPoint(index, p.point.multiply(_this.zoomLevel), p.side, key, index, index === activePointIndex);
        });
    };
    CanvasManager.prototype.NotifyConnectionPointsHide = function () {
        this.hideConnectionPoints();
    };
    CanvasManager.prototype.NotifyConnectionMarksShow = function (key, points, activePointIndex) {
        var _this = this;
        points.forEach(function (p, index) {
            var point = p.point.multiply(_this.zoomLevel);
            switch (p.side) {
                case DiagramItem_1.ConnectionPointSide.North:
                    point.y -= CanvasManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.South:
                    point.y += CanvasManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.East:
                    point.x += CanvasManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.West:
                    point.x -= CanvasManager.connectionMarkShift;
                    break;
            }
            _this.showConnectionMark(index, point, p.side, key, index, index === activePointIndex);
        });
    };
    CanvasManager.prototype.NotifyConnectionMarksHide = function () {
        this.hideConnectionMarks();
    };
    CanvasManager.prototype.NotifyConnectionTargetShow = function (key, targetRect) {
        var rect = this.correctShapeSelectionRect(targetRect.multiply(this.zoomLevel), CanvasManager.connectionTargetBorderWidth);
        this.showConnectionTarget(0, rect);
    };
    CanvasManager.prototype.NotifyConnectionTargetHide = function () {
        this.hideConnectionTarget();
    };
    CanvasManager.prototype.NotifyExtensionLinesShow = function (lines) {
        var _this = this;
        this.hideExtensionLines();
        lines.forEach(function (line, index) {
            _this.showExtensionLine(index, line.type, line.segment.startPoint.multiply(_this.zoomLevel), line.segment.endPoint.multiply(_this.zoomLevel), line.text);
        });
    };
    CanvasManager.prototype.NotifyExtensionLinesHide = function () {
        this.hideExtensionLines();
    };
    CanvasManager.prototype.NotifyDragStart = function (itemKeys) {
        var _this = this;
        itemKeys.forEach(function (itemKey) {
            if (_this.itemSelectorElements[itemKey])
                _this.itemSelectorElements[itemKey].style.pointerEvents = "none";
            if (_this.itemElements[itemKey])
                _this.itemElements[itemKey].style.pointerEvents = "none";
        });
        this.selectionMarksContainer.style.display = "none";
    };
    CanvasManager.prototype.NotifyDragEnd = function (itemKeys) {
        var _this = this;
        itemKeys.forEach(function (itemKey) {
            if (_this.itemSelectorElements[itemKey])
                _this.itemSelectorElements[itemKey].style.pointerEvents = "";
            if (_this.itemElements[itemKey])
                _this.itemElements[itemKey].style.pointerEvents = "";
        });
        this.selectionMarksContainer.style.display = "";
    };
    CanvasManager.prototype.NotifyTextInputStart = function (item, text, position, size) {
        var element = this.itemElements[item.key];
        var className = element.getAttribute("class");
        element.setAttribute("class", className + " text-input");
        this.visualizersContainer.style.display = "none";
    };
    CanvasManager.prototype.NotifyTextInputEnd = function (item) {
        var element = this.itemElements[item.key];
        var className = element.getAttribute("class");
        element.setAttribute("class", className.replace(" text-input", ""));
        this.visualizersContainer.style.display = "";
    };
    // Drawing
    CanvasManager.prototype.applyShapeChange = function (change) {
        var shape = change.shape;
        var key = shape.key;
        var itemParent = this.getItemGroupContainer(shape.zIndex);
        var itemSelectorParent = this.getItemSelectorGroupContainer(shape.zIndex);
        switch (change.type) {
            case ModelChange_1.ItemChangeType.Create:
                this.itemElements[key] = this.createItemElements(key, shape.getPrimitives(), itemParent, "shape", Event_1.MouseEventElementType.Shape);
                this.itemSelectorElements[key] = this.createItemElements(key, shape.getSelectorPrimitives(), itemSelectorParent, "shape", Event_1.MouseEventElementType.Shape);
                break;
            case ModelChange_1.ItemChangeType.Remove:
                this.removeItemElements(itemParent, this.itemElements[key]);
                delete this.itemElements[key];
                this.removeItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                delete this.itemSelectorElements[key];
                break;
            case ModelChange_1.ItemChangeType.UpdateStructure:
                this.changeItemElements(shape.getPrimitives(), this.itemElements[key], true);
                this.changeItemElements(shape.getSelectorPrimitives(), this.itemSelectorElements[key], true);
                break;
            case ModelChange_1.ItemChangeType.Update:
                this.changeItemElements(shape.getPrimitives(), this.itemElements[key]);
                this.changeItemElements(shape.getSelectorPrimitives(), this.itemSelectorElements[key]);
                break;
            case ModelChange_1.ItemChangeType.UpdateZIndex:
                this.moveItemElements(itemParent, this.itemElements[key]);
                this.moveItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                break;
        }
    };
    CanvasManager.prototype.applyConnectorChange = function (change) {
        var connector = change.connector;
        var key = connector.key;
        var itemParent = this.getItemGroupContainer(connector.zIndex);
        var itemSelectorParent = this.getItemSelectorGroupContainer(connector.zIndex);
        switch (change.type) {
            case ModelChange_1.ItemChangeType.Create:
                this.itemElements[key] = this.createItemElements(key, connector.getPrimitives(), itemParent, "connector", Event_1.MouseEventElementType.Connector);
                this.itemSelectorElements[key] = this.createItemElements(key, connector.getSelectorPrimitives(), itemSelectorParent, "connector", Event_1.MouseEventElementType.Connector);
                break;
            case ModelChange_1.ItemChangeType.Remove:
                this.removeItemElements(itemParent, this.itemElements[key]);
                delete this.itemElements[key];
                this.removeItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                delete this.itemSelectorElements[key];
                this.invalidateConnectorSelectionTextElements(key);
                break;
            case ModelChange_1.ItemChangeType.UpdateStructure:
                this.changeItemElements(connector.getPrimitives(), this.itemElements[key], true);
                this.changeItemElements(connector.getSelectorPrimitives(), this.itemSelectorElements[key], true);
                this.invalidateConnectorSelectionTextElements(key);
                break;
            case ModelChange_1.ItemChangeType.Update:
                this.changeItemElements(connector.getPrimitives(), this.itemElements[key]);
                this.changeItemElements(connector.getSelectorPrimitives(), this.itemSelectorElements[key]);
                break;
            case ModelChange_1.ItemChangeType.UpdateZIndex:
                this.moveItemElements(itemParent, this.itemElements[key]);
                this.moveItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                break;
        }
    };
    CanvasManager.prototype.createItemElements = function (key, primitives, parent, className, type) {
        var gEl = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], className), parent);
        Utils_2.RenderUtils.setElementEventData(gEl, type, key);
        this.createAndChangePrimitivesElements(primitives, gEl);
        return gEl;
    };
    CanvasManager.prototype.changeItemElements = function (primitives, element, updateStructure) {
        if (updateStructure === void 0) { updateStructure = false; }
        if (updateStructure) {
            Utils_2.RenderUtils.removeContent(element);
            this.createAndChangePrimitivesElements(primitives, element);
        }
        else
            this.changePrimitivesElements(primitives, element);
    };
    CanvasManager.prototype.removeItemElements = function (parent, element) {
        if (element)
            parent.removeChild(element);
    };
    CanvasManager.prototype.moveItemElements = function (parent, element, sibling) {
        if (element) {
            if (sibling !== undefined)
                parent.insertBefore(element, sibling);
            else
                parent.appendChild(element);
        }
    };
    CanvasManager.prototype.getItemGroupContainer = function (zIndex) {
        if (this.itemGroupContainers[zIndex] === undefined) {
            this.itemGroupContainers[zIndex] = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.itemsContainer, this.itemGroupContainers[zIndex + 1]);
        }
        return this.itemGroupContainers[zIndex];
    };
    CanvasManager.prototype.getItemSelectorGroupContainer = function (zIndex) {
        if (this.itemSelectorGroupContainers[zIndex] === undefined) {
            this.itemSelectorGroupContainers[zIndex] = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), this.itemSelectorsContainer, this.itemSelectorGroupContainers[zIndex + 1]);
        }
        return this.itemSelectorGroupContainers[zIndex];
    };
    CanvasManager.prototype.applyPageChange = function (change) {
        this.zoomLevel = change.model.zoomLevel;
        this.itemsContainer.style.transform = "scale(" + this.zoomLevel + ")";
        this.itemSelectorsContainer.style.transform = "scale(" + this.zoomLevel + ")";
        this.svgWidth = UnitConverter_1.UnitConverter.twipsToPixels(change.model.size.width) * this.zoomLevel;
        this.svgHeight = UnitConverter_1.UnitConverter.twipsToPixels(change.model.size.height) * this.zoomLevel;
        this.updateGridElements(change.model.showGrid, UnitConverter_1.UnitConverter.twipsToPixels(change.model.gridSize) * this.zoomLevel);
        this.updatePagesGridElements(UnitConverter_1.UnitConverter.twipsToPixels(change.model.pageWidth) * this.zoomLevel, UnitConverter_1.UnitConverter.twipsToPixels(change.model.pageHeight) * this.zoomLevel);
        this.svgElement.style.backgroundColor = change.model.pageColor;
        var filterElements = Base_1.GetNodesByClassName(this.svgElement, "text-filter-flood");
        for (var i = 0; i < filterElements.length; i++) {
            filterElements[i].style.setProperty("flood-color", change.model.pageColor);
        }
    };
    CanvasManager.prototype.getGridRectElement = function (primitive) {
        if (this.gridRectElement === undefined)
            this.gridRectElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridRectElement;
    };
    CanvasManager.prototype.getGridPatternElement = function (primitive) {
        if (this.gridPatternElement === undefined)
            this.gridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridPatternElement;
    };
    CanvasManager.prototype.updateGridElements = function (visible, size) {
        var _this = this;
        var gridRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, null, null, function (element) {
            element.style.setProperty("fill", "url('#" + _this.gridPatternId + "')");
        });
        var rectEl = this.getGridRectElement(gridRectPrimitive);
        if (!visible)
            rectEl.style.display = "none";
        else {
            rectEl.style.display = "";
            this.changePrimitiveElement(gridRectPrimitive, rectEl);
            var sizes = [0, 1, 2, 3, 4].map(function (i) { return Math.round(size * i); });
            var outerPathCommands = [
                new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[4].toString(), "0"),
                new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[4].toString()),
                new PathPrimitive_1.PathPrimitiveLineToCommand("0", sizes[4].toString())
            ];
            var innerPathCommands = [];
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[i].toString(), "0"));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[i].toString(), sizes[4].toString()));
            }
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand("0", sizes[i].toString()));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[i].toString()));
            }
            var gridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.gridPatternId, [
                new PathPrimitive_1.PathPrimitive(outerPathCommands, null, "grid-outer-line"),
                new PathPrimitive_1.PathPrimitive(innerPathCommands, null, "grid-inner-line")
            ], 0, 0, (size * 4 / this.svgWidth).toString(), (size * 4 / this.svgHeight).toString());
            this.changePrimitiveElement(gridPatternPrimitive, this.getGridPatternElement(gridPatternPrimitive));
        }
    };
    CanvasManager.prototype.getPagesGridRectElement = function (primitive) {
        if (this.pagesGridRectElement === undefined)
            this.pagesGridRectElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridRectElement;
    };
    CanvasManager.prototype.getPagesGridClipPathElement = function (primitive) {
        if (this.pagesGridClipPathElement === undefined)
            this.pagesGridClipPathElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridClipPathElement;
    };
    CanvasManager.prototype.getPagesGridPatternElement = function (primitive) {
        if (this.pagesGridPatternElement === undefined)
            this.pagesGridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridPatternElement;
    };
    CanvasManager.prototype.updatePagesGridElements = function (width, height) {
        var _this = this;
        var pagesGridRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, null, this.pagesGridClipId, function (element) {
            element.style.setProperty("fill", "url('#" + _this.pagesGridPatternId + "')");
        });
        this.changePrimitiveElement(pagesGridRectPrimitive, this.getPagesGridRectElement(pagesGridRectPrimitive));
        var horPages = Math.round(this.svgWidth / width);
        var verPages = Math.round(this.svgHeight / height);
        var pageGridPathCommands = [
            new PathPrimitive_1.PathPrimitiveMoveToCommand((width - CanvasManager.pagesGridLineWidth / 2).toString(), "0"),
            new PathPrimitive_1.PathPrimitiveLineToCommand((width - CanvasManager.pagesGridLineWidth / 2).toString(), (height - CanvasManager.pagesGridLineWidth / 2).toString()),
            new PathPrimitive_1.PathPrimitiveLineToCommand("0", (height - CanvasManager.pagesGridLineWidth / 2).toString())
        ];
        var pagesGridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.pagesGridPatternId, [
            new PathPrimitive_1.PathPrimitive(pageGridPathCommands, null, "pages-grid-line")
        ], 0, 0, ((horPages > 1) ? 1 / horPages : 1).toString(), ((verPages > 1) ? 1 / verPages : 1).toString());
        this.changePrimitiveElement(pagesGridPatternPrimitive, this.getPagesGridPatternElement(pagesGridPatternPrimitive));
        var pagesGridClipPathPrimitive = new ClipPathPrimitive_1.ClipPathPrimitive(this.pagesGridClipId, [
            new RectaglePrimitive_1.RectanglePrimitive(0, 0, (this.svgWidth - CanvasManager.pagesGridLineWidth * 2).toString(), (this.svgHeight - CanvasManager.pagesGridLineWidth * 2).toString())
        ]);
        this.changePrimitiveElement(pagesGridClipPathPrimitive, this.getPagesGridClipPathElement(pagesGridClipPathPrimitive));
    };
    // Selection
    CanvasManager.prototype.hideSelection = function () {
        this.hideItemSelectionRects();
        this.hideConnectorSelection();
        this.hideSelectionMarkElements();
        this.hideLockedSelectionMarkElements();
        this.hideParameterPointMarkElements();
    };
    CanvasManager.prototype.showShapeSelectionMarks = function (shape) {
        var rect = new Utils_1.Rectangle(shape.position, shape.size).multiply(this.zoomLevel);
        this.showSelectionMarks(rect, shape.key);
    };
    CanvasManager.prototype.showConnectorSelectionMarks = function (connector) {
        var _this = this;
        connector.points.forEach(function (pt, index) {
            var isEdgePoint = (index === 0 || index === connector.points.length - 1);
            var className = isEdgePoint ? "selection-mark" : "connector-point-mark";
            var markSize = isEdgePoint ? CanvasManager.selectionMarkSize : CanvasManager.connectorPointMarkSize;
            if (isEdgePoint || connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) {
                _this.showSelectionMark(index, pt.multiply(_this.zoomLevel), markSize, Event_1.MouseEventElementType.ConnectorPoint, connector.key, index, className);
            }
            else {
                _this.showSelectionMark(index, pt.multiply(_this.zoomLevel), markSize, Event_1.MouseEventElementType.Undefined, "-1", -1, className + " disabled");
            }
        });
        this.showConnectorSideMarks(connector);
    };
    CanvasManager.prototype.showConnectorSideMarks = function (connector) {
        var _this = this;
        var points = connector.getRenderPoints(true);
        var type = (connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) ?
            Event_1.MouseEventElementType.ConnectorSide : Event_1.MouseEventElementType.ConnectorOrthogonalSide;
        var prevPt, prevPtIndex;
        points.forEach(function (pt, index) {
            if (pt.skipped)
                return;
            if (prevPt !== undefined) {
                if (_this.canShowConnectorSideMark(connector, pt, prevPt)) {
                    var classNameSuffix = connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Orthogonal ?
                        (pt.x - prevPt.x === 0 ? "vertical" : "horizontal") : "";
                    _this.showSelectionMark(connector.points.length + index - 1, new Utils_1.Point(prevPt.x + (pt.x - prevPt.x) / 2, prevPt.y + (pt.y - prevPt.y) / 2).multiply(_this.zoomLevel), CanvasManager.connectorSideMarkSize, type, connector.key, prevPtIndex + "_" + index, "connector-side-mark " + classNameSuffix);
                }
            }
            prevPt = pt;
            prevPtIndex = index;
        });
    };
    CanvasManager.prototype.canShowConnectorSideMark = function (connector, point1, point2) {
        if (connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) {
            var minSize = CanvasManager.selectionMarkSize + CanvasManager.connectorSideMarkSize;
            return Utils_1.GeometryUtils.getDistance(point1, point2) > minSize;
        }
        if (connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Orthogonal) {
            return ((point1.x - point2.x === 0 || Math.abs(point1.x - point2.x) > Connector_1.Connector.minOffset) &&
                (point1.y - point2.y === 0 || Math.abs(point1.y - point2.y) > Connector_1.Connector.minOffset));
        }
        return false;
    };
    CanvasManager.prototype.showSelectionMarks = function (rect, key) {
        this.showSelectionMark(0, new Utils_1.Point(rect.left, rect.top), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_NW, "selection-mark");
        this.showSelectionMark(1, new Utils_1.Point(rect.left + rect.size.width / 2, rect.top), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_N, "selection-mark");
        this.showSelectionMark(2, new Utils_1.Point(rect.right, rect.top), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_NE, "selection-mark");
        this.showSelectionMark(3, new Utils_1.Point(rect.right, rect.top + rect.size.height / 2), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_E, "selection-mark");
        this.showSelectionMark(4, new Utils_1.Point(rect.right, rect.bottom), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_SE, "selection-mark");
        this.showSelectionMark(5, new Utils_1.Point(rect.left + rect.size.width / 2, rect.bottom), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_S, "selection-mark");
        this.showSelectionMark(6, new Utils_1.Point(rect.left, rect.bottom), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_SW, "selection-mark");
        this.showSelectionMark(7, new Utils_1.Point(rect.left, rect.top + rect.size.height / 2), CanvasManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, key, Event_1.ResizeEventSource.ResizeBox_W, "selection-mark");
    };
    CanvasManager.prototype.showSelectionMark = function (index, point, size, type, key, value, className) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(point.x - size / 2, point.y - size / 2, size, size, null, className);
        var rectEl = this.getSelectionMarkElement(primitive, index);
        this.changePrimitiveElement(primitive, rectEl);
        Utils_2.RenderUtils.setElementEventData(rectEl, type, key, value);
    };
    CanvasManager.prototype.hideSelectionMarkElements = function () {
        for (var i = 0; i < this.selectionMarkElements.length; i++) {
            if (this.selectionMarkElements[i])
                this.selectionMarkElements[i].style.display = "none";
        }
    };
    CanvasManager.prototype.getSelectionMarkElement = function (primitive, index) {
        var rectEl = this.selectionMarkElements[index];
        if (rectEl !== undefined)
            rectEl.style.display = "";
        else {
            rectEl = this.createPrimitiveElement(primitive, this.selectionMarksContainer);
            this.selectionMarkElements[index] = rectEl;
        }
        return rectEl;
    };
    CanvasManager.prototype.showLockedSelectionMarks = function (item) {
        var rect = item.rectangle.multiply(this.zoomLevel);
        this.showLockedSelectionMark(item.key, 0, new Utils_1.Point(rect.left, rect.top), CanvasManager.lockedSelectionMarkSize, "locked-selection-mark");
        this.showLockedSelectionMark(item.key, 1, new Utils_1.Point(rect.right, rect.top), CanvasManager.lockedSelectionMarkSize, "locked-selection-mark");
        this.showLockedSelectionMark(item.key, 2, new Utils_1.Point(rect.right, rect.bottom), CanvasManager.lockedSelectionMarkSize, "locked-selection-mark");
        this.showLockedSelectionMark(item.key, 3, new Utils_1.Point(rect.left, rect.bottom), CanvasManager.lockedSelectionMarkSize, "locked-selection-mark");
    };
    CanvasManager.prototype.showLockedSelectionMark = function (key, index, point, size, className) {
        var primitive = new PathPrimitive_1.PathPrimitive([
            new PathPrimitive_1.PathPrimitiveMoveToCommand(point.x - size / 2, point.y - size / 2),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x + size / 2, point.y + size / 2),
            new PathPrimitive_1.PathPrimitiveMoveToCommand(point.x + size / 2, point.y - size / 2),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x - size / 2, point.y + size / 2)
        ], null, className);
        var pathEl = this.getLockedSelectionMarkElement(primitive, key, index);
        this.changePrimitiveElement(primitive, pathEl);
    };
    CanvasManager.prototype.hideLockedSelectionMarkElements = function () {
        for (var key in this.lockedSelectionMarkElements) {
            if (this.lockedSelectionMarkElements.hasOwnProperty(key)) {
                for (var i = 0; i < this.lockedSelectionMarkElements[key].length; i++)
                    this.lockedSelectionMarkElements[key][i].style.display = "none";
            }
        }
    };
    CanvasManager.prototype.getLockedSelectionMarkElement = function (primitive, key, index) {
        var pathEl = this.lockedSelectionMarkElements[key] !== undefined ? this.lockedSelectionMarkElements[key][index] : undefined;
        if (pathEl !== undefined)
            pathEl.style.display = "";
        else {
            if (this.lockedSelectionMarkElements[key] === undefined)
                this.lockedSelectionMarkElements[key] = [];
            pathEl = this.createPrimitiveElement(primitive, this.selectionMarksContainer);
            this.lockedSelectionMarkElements[key][index] = pathEl;
        }
        return pathEl;
    };
    CanvasManager.prototype.showShapeParameterPoints = function (shape) {
        var _this = this;
        shape.description.getParameterPoints(shape).forEach(function (pp, index) {
            var size = CanvasManager.geomertyMarkSize;
            var point = pp.point.multiply(_this.zoomLevel);
            var primitive = new RectaglePrimitive_1.RectanglePrimitive(point.x - size / 2, point.y - size / 2, size, size, null, "geometry-mark");
            var rectEl = _this.getParameterPointMarkElement(primitive, shape.key, index);
            _this.changePrimitiveElement(primitive, rectEl);
            Utils_2.RenderUtils.setElementEventData(rectEl, Event_1.MouseEventElementType.ShapeParameterBox, shape.key, pp.key);
        });
    };
    CanvasManager.prototype.hideParameterPointMarkElements = function () {
        for (var key in this.parameterPointMarkElements) {
            if (this.parameterPointMarkElements.hasOwnProperty(key)) {
                for (var i = 0; i < this.parameterPointMarkElements[key].length; i++)
                    this.parameterPointMarkElements[key][i].style.display = "none";
            }
        }
    };
    CanvasManager.prototype.getParameterPointMarkElement = function (primitive, key, index) {
        var rectEl = this.parameterPointMarkElements[key] !== undefined ? this.parameterPointMarkElements[key][index] : undefined;
        if (rectEl !== undefined)
            rectEl.style.display = "";
        else {
            if (this.parameterPointMarkElements[key] === undefined)
                this.parameterPointMarkElements[key] = [];
            rectEl = this.createPrimitiveElement(primitive, this.selectionMarksContainer);
            this.parameterPointMarkElements[key][index] = rectEl;
        }
        return rectEl;
    };
    CanvasManager.prototype.showShapeSelectionRect = function (shape, rect, type, className) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.width, rect.height, null, className);
        var rectEl = this.getItemSelectionRectElement(primitive, shape ? shape.key : "-1");
        this.changePrimitiveElement(primitive, rectEl);
        Utils_2.RenderUtils.setElementEventData(rectEl, type, "-1", -1);
    };
    CanvasManager.prototype.hideItemSelectionRects = function () {
        for (var key in this.itemSelectionRectElements)
            if (this.itemSelectionRectElements.hasOwnProperty(key))
                this.itemSelectionRectElements[key].style.display = "none";
    };
    CanvasManager.prototype.getItemSelectionRectElement = function (primitive, key) {
        var rectEl = this.itemSelectionRectElements[key];
        if (rectEl !== undefined)
            rectEl.style.display = "";
        else {
            rectEl = this.createPrimitiveElement(primitive, this.itemSelectionContainer);
            this.itemSelectionRectElements[key] = rectEl;
        }
        return rectEl;
    };
    CanvasManager.prototype.showSelectionRect = function (rect) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.size.width, rect.size.height, null, "selection-rect");
        var rectEl = this.getSelectionRectElement(primitive);
        this.changePrimitiveElement(primitive, rectEl);
    };
    CanvasManager.prototype.hideSelectionRect = function () {
        if (this.selectionRectElement !== undefined)
            this.selectionRectElement.style.display = "none";
    };
    CanvasManager.prototype.getSelectionRectElement = function (primitive) {
        if (this.selectionRectElement !== undefined)
            this.selectionRectElement.style.display = "";
        else
            this.selectionRectElement = this.createPrimitiveElement(primitive, this.visualizersContainer);
        return this.selectionRectElement;
    };
    CanvasManager.prototype.showResizeInfo = function (point, text) {
        var rectPrimitive = new RectaglePrimitive_1.RectanglePrimitive(point.x, point.y, 0, 0);
        var primitive = new GroupPrimitive_1.GroupPrimitive([
            rectPrimitive,
            new TextPrimitive_1.TextPrimitive(point.x, point.y, text)
        ], "resize-info");
        var groupEl = this.getResizeInfoElement(primitive);
        this.changePrimitiveElement(primitive, groupEl);
        var textRect = Utils_2.RenderUtils.getSvgTextRectangle(groupEl.childNodes[1], CanvasManager.resizeInfoLineWidth)
            .inflate(CanvasManager.resizeInfoTextOffset, CanvasManager.resizeInfoTextOffset);
        rectPrimitive.x = textRect.left;
        rectPrimitive.y = textRect.top;
        rectPrimitive.width = textRect.width;
        rectPrimitive.height = textRect.height;
        this.changePrimitiveElement(primitive, groupEl);
    };
    CanvasManager.prototype.hideResizeInfo = function () {
        if (this.resizeInfoElement !== undefined)
            this.resizeInfoElement.style.display = "none";
    };
    CanvasManager.prototype.getResizeInfoElement = function (primitive) {
        if (this.resizeInfoElement !== undefined)
            this.resizeInfoElement.style.display = "";
        else
            this.resizeInfoElement = this.createPrimitiveElement(primitive, this.visualizersContainer);
        return this.resizeInfoElement;
    };
    CanvasManager.prototype.showConnectorSelection = function (connector, className) {
        var _this = this;
        var points = connector.getRenderPoints();
        var pathCommands = [];
        var prevPt, firstPt, lastPt;
        var difX = 0, difY = 0;
        points.forEach(function (pt) {
            pt = pt.multiply(_this.zoomLevel);
            if (prevPt === undefined) {
                firstPt = pt;
                pathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand(pt.x, pt.y));
            }
            else {
                pathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(pt.x, pt.y));
                difX = Math.max(difX, Math.abs(prevPt.x - pt.x));
                difY = Math.max(difY, Math.abs(prevPt.y - pt.y));
            }
            prevPt = pt;
        });
        lastPt = prevPt;
        if (difX < CanvasManager.connectorSelectionLineWidth || difY < CanvasManager.connectorSelectionLineWidth) {
            // Increase mask size
            var offsetX = difX < CanvasManager.connectorSelectionLineWidth ? CanvasManager.connectorSelectionLineWidth : 0;
            var offsetY = (difY < CanvasManager.connectorSelectionLineWidth ? CanvasManager.connectorSelectionLineWidth : 0);
            pathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(lastPt.x - offsetX, lastPt.y - offsetY));
        }
        var maskId = Utils_2.RenderUtils.generateSvgElementId("maskSel");
        var cliPathId = Utils_2.RenderUtils.generateSvgElementId("clipSel");
        var primitive = new GroupPrimitive_1.GroupPrimitive([
            new PathPrimitive_1.PathPrimitive(pathCommands, null, className, cliPathId, function (el) {
                el.setAttribute("mask", "url(#" + maskId + ")");
            }),
            new MaskPrimitive_1.MaskPrimitive(maskId, [
                new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "background"),
                new PathPrimitive_1.PathPrimitive(pathCommands),
                new RectaglePrimitive_1.RectanglePrimitive(firstPt.x - CanvasManager.connectorSelectionWidth / 2, firstPt.y - CanvasManager.connectorSelectionWidth / 2, CanvasManager.connectorSelectionWidth, CanvasManager.connectorSelectionWidth),
                new RectaglePrimitive_1.RectanglePrimitive(lastPt.x - CanvasManager.connectorSelectionWidth / 2, lastPt.y - CanvasManager.connectorSelectionWidth / 2, CanvasManager.connectorSelectionWidth, CanvasManager.connectorSelectionWidth),
                new GroupPrimitive_1.GroupPrimitive([])
            ], "connector-selection-mask", "-1000%", "-1000%", "2100%", "2100%")
        ]);
        var gEl = this.getConnectorSelectionElement(primitive, connector.key);
        this.changePrimitiveElement(primitive, gEl);
        this.showConnectorTextsSelection(connector, gEl, gEl.querySelector("g"), className, maskId);
    };
    CanvasManager.prototype.showConnectorTextsSelection = function (connector, parent, maskParent, className, maskId) {
        var _this = this;
        var textRects = [];
        if (maskParent && connector.allowHasText) {
            var index_1 = 0;
            connector.texts.forEach(function (textObj) {
                var text = connector.getText(textObj.position);
                if (text && text !== "") {
                    var position = connector.getTextPoint(textObj.position);
                    var filterId = Utils_2.RenderUtils.generateSvgElementId("filterSel");
                    var textPrimitive = new GroupPrimitive_1.GroupPrimitive([
                        new TextPrimitive_1.TextPrimitive(position.x, position.y, text, undefined, connector.styleText, true, null, filterId),
                        new TextFilterPrimitive_1.TextFilterPrimitive(filterId, false)
                    ]);
                    var gTextEl = _this.getConnectorSelectionMaskTextElement(textPrimitive, maskParent, connector.key, index_1);
                    _this.changePrimitiveElement(textPrimitive, gTextEl);
                    var textEl = gTextEl.querySelector("text");
                    var textRect = Utils_2.RenderUtils.getSvgTextRectangle(textEl, CanvasManager.connectorSelectionLineWidth);
                    if (textRect)
                        textRects.push(textRect.multiply(_this.zoomLevel));
                }
                index_1++;
            });
        }
        for (var i = 0; i < textRects.length; i++) {
            var textRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive(textRects[i].left, textRects[i].top, textRects[i].width, textRects[i].height, null, className + " text", null);
            var rectEl = this.getConnectorSelectionTextElement(textRectPrimitive, parent, connector.key, i);
            this.changePrimitiveElement(textRectPrimitive, rectEl);
        }
    };
    CanvasManager.prototype.hideConnectorSelection = function () {
        for (var key in this.connectorSelectionElements) {
            if (this.connectorSelectionElements.hasOwnProperty(key))
                this.connectorSelectionElements[key].style.display = "none";
        }
        for (var key in this.connectorSelectionMaskTextElements) {
            if (this.connectorSelectionMaskTextElements.hasOwnProperty(key)) {
                for (var i = 0; i < this.connectorSelectionMaskTextElements[key].length; i++)
                    this.connectorSelectionMaskTextElements[key][i].style.display = "none";
            }
        }
        for (var key in this.connectorSelectionTextElements) {
            if (this.connectorSelectionTextElements.hasOwnProperty(key)) {
                for (var i = 0; i < this.connectorSelectionTextElements[key].length; i++)
                    this.connectorSelectionTextElements[key][i].style.display = "none";
            }
        }
    };
    CanvasManager.prototype.getConnectorSelectionElement = function (primitive, key) {
        var gEl = this.connectorSelectionElements[key];
        if (gEl !== undefined)
            gEl.style.display = "";
        else {
            gEl = this.createPrimitiveElement(primitive, this.itemSelectionContainer);
            this.connectorSelectionElements[key] = gEl;
        }
        return gEl;
    };
    CanvasManager.prototype.getConnectorSelectionTextElement = function (primitive, parent, key, index) {
        var textGroupEl = this.connectorSelectionTextElements[key] !== undefined ? this.connectorSelectionTextElements[key][index] : undefined;
        if (textGroupEl !== undefined)
            textGroupEl.style.display = "";
        else {
            if (this.connectorSelectionTextElements[key] === undefined)
                this.connectorSelectionTextElements[key] = [];
            textGroupEl = this.createPrimitiveElement(primitive, parent);
            this.connectorSelectionTextElements[key][index] = textGroupEl;
        }
        return textGroupEl;
    };
    CanvasManager.prototype.getConnectorSelectionMaskTextElement = function (primitive, parent, key, index) {
        var textGroupEl = this.connectorSelectionMaskTextElements[key] !== undefined ? this.connectorSelectionMaskTextElements[key][index] : undefined;
        if (textGroupEl !== undefined)
            textGroupEl.style.display = "";
        else {
            if (this.connectorSelectionMaskTextElements[key] === undefined)
                this.connectorSelectionMaskTextElements[key] = [];
            textGroupEl = this.createPrimitiveElement(primitive, parent);
            this.connectorSelectionMaskTextElements[key][index] = textGroupEl;
        }
        return textGroupEl;
    };
    CanvasManager.prototype.invalidateConnectorSelectionTextElements = function (key) {
        var gEl = this.connectorSelectionElements[key];
        if (gEl) {
            var textContainerEl = gEl.querySelector("g");
            Utils_2.RenderUtils.removeContent(textContainerEl);
            if (this.connectorSelectionMaskTextElements[key])
                delete this.connectorSelectionMaskTextElements[key];
        }
    };
    CanvasManager.prototype.showConnectionPoint = function (index, point, side, key, value, active) {
        var className = "connection-point";
        this.showConnectionPointCore(index * 2, point.x, point.y, CanvasManager.connectionPointLargeSize, CanvasManager.connectionPointLargeSize, Event_1.MouseEventElementType.ShapeConnectionPoint, key, value, className + " selector");
        this.showConnectionPointCore(index * 2 + 1, point.x, point.y, CanvasManager.connectionPointSmallSize, CanvasManager.connectionPointSmallSize, Event_1.MouseEventElementType.ShapeConnectionPoint, key, value, className + (active ? " active" : ""));
    };
    CanvasManager.prototype.showConnectionPointCore = function (index, cx, cy, rx, ry, type, key, value, className) {
        var primitive = new EllipsePrimitive_1.EllipsePrimitive(cx, cy, rx, ry, null, className);
        var ellEl = this.getConnectionPointElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_2.RenderUtils.setElementEventData(ellEl, type, key, value);
    };
    CanvasManager.prototype.hideConnectionPoints = function () {
        for (var i = 0; i < this.connectionPointElements.length; i++)
            this.connectionPointElements[i].style.display = "none";
    };
    CanvasManager.prototype.getConnectionPointElement = function (primitive, index) {
        var ellEl = this.connectionPointElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.connectionPointElements[index] = ellEl;
        }
        return ellEl;
    };
    CanvasManager.prototype.showConnectionTarget = function (index, targetRect) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(targetRect.left, targetRect.top, targetRect.width, targetRect.height, null, "connection-target");
        var rectEl = this.getConnectionTargetElement(primitive, index);
        this.changePrimitiveElement(primitive, rectEl);
    };
    CanvasManager.prototype.hideConnectionTarget = function () {
        for (var i = 0; i < this.connectionTargetElements.length; i++)
            this.connectionTargetElements[i].style.display = "none";
    };
    CanvasManager.prototype.getConnectionTargetElement = function (primitive, index) {
        var ellEl = this.connectionTargetElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.itemSelectionContainer);
            this.connectionTargetElements[index] = ellEl;
        }
        return ellEl;
    };
    CanvasManager.prototype.showConnectionMark = function (index, point, side, key, value, active) {
        var className = "connection-mark";
        this.showConnectionMarkSelector(index * 2, point.x - CanvasManager.connectionMarkLargeSize / 2, point.y - CanvasManager.connectionMarkLargeSize / 2, CanvasManager.connectionMarkLargeSize, CanvasManager.connectionMarkLargeSize, Event_1.MouseEventElementType.ShapeConnection, key, value, className + " selector");
        this.showConnectionMarkArrow(index * 2 + 1, point.x - CanvasManager.connectionMarkSmallSize / 2, point.y - CanvasManager.connectionMarkSmallSize / 2, CanvasManager.connectionMarkSmallSize, CanvasManager.connectionMarkSmallSize, side, Event_1.MouseEventElementType.ShapeConnection, key, value, className + (active ? " active" : ""));
    };
    CanvasManager.prototype.showConnectionMarkArrow = function (index, x, y, width, height, side, type, key, value, className) {
        var pathCommands = [];
        switch (side) {
            case DiagramItem_1.ConnectionPointSide.East:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.South:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width * 2 / 3, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width / 3, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
        }
        var primitive = new PathPrimitive_1.PathPrimitive(pathCommands, null, className);
        var ellEl = this.getConnectionMarkElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_2.RenderUtils.setElementEventData(ellEl, Event_1.MouseEventElementType.ShapeConnection, key, value);
    };
    CanvasManager.prototype.showConnectionMarkSelector = function (index, x, y, width, height, type, key, value, className) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(x, y, width, height, null, className);
        var ellEl = this.getConnectionMarkElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_2.RenderUtils.setElementEventData(ellEl, Event_1.MouseEventElementType.ShapeConnection, key, value);
    };
    CanvasManager.prototype.hideConnectionMarks = function () {
        for (var i = 0; i < this.connectionMarkElements.length; i++)
            this.connectionMarkElements[i].style.display = "none";
    };
    CanvasManager.prototype.getConnectionMarkElement = function (primitive, index) {
        var ellEl = this.connectionMarkElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.connectionMarkElements[index] = ellEl;
        }
        return ellEl;
    };
    CanvasManager.prototype.showExtensionLine = function (index, type, startPoint, endPoint, text) {
        var className = "extension-line";
        if (type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterAfter || type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterBefore ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterAbove || type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterBelow)
            className += " center";
        if (type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterToPageCenter ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.LeftToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.RightToPageCenter ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.TopToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.BottomToPageCenter)
            className += " page";
        var filterId = "filterEL" + index;
        var x1_1 = 0, y1_1 = 0, x1_2 = 0, y1_2 = 0, x2_1 = 0, y2_1 = 0, x2_2 = 0, y2_2 = 0;
        if (startPoint.y === endPoint.y) {
            x1_1 = startPoint.x;
            y1_1 = startPoint.y - CanvasManager.extensionLineEndingSize;
            x1_2 = startPoint.x;
            y1_2 = startPoint.y + CanvasManager.extensionLineEndingSize;
            x2_1 = endPoint.x;
            y2_1 = startPoint.y - CanvasManager.extensionLineEndingSize;
            x2_2 = endPoint.x;
            y2_2 = startPoint.y + CanvasManager.extensionLineEndingSize;
        }
        else if (startPoint.x === endPoint.x) {
            x1_1 = startPoint.x - CanvasManager.extensionLineEndingSize;
            y1_1 = startPoint.y;
            x1_2 = startPoint.x + CanvasManager.extensionLineEndingSize;
            y1_2 = startPoint.y;
            x2_1 = startPoint.x - CanvasManager.extensionLineEndingSize;
            y2_1 = endPoint.y;
            x2_2 = startPoint.x + CanvasManager.extensionLineEndingSize;
            y2_2 = endPoint.y;
        }
        var linePrimitives = [
            new LinePrimitive_1.LinePrimitive(startPoint.x, startPoint.y, endPoint.x, endPoint.y),
            new LinePrimitive_1.LinePrimitive(x1_1, y1_1, x1_2, y1_2),
            new LinePrimitive_1.LinePrimitive(x2_1, y2_1, x2_2, y2_2),
            new TextPrimitive_1.TextPrimitive((endPoint.x + startPoint.x) / 2, (endPoint.y + startPoint.y) / 2, text, undefined, null, false, null, filterId, function (el) {
                el.style.display = text && text !== "" ? "inherit" : "none";
            }),
            new TextFilterPrimitive_1.TextFilterPrimitive(filterId)
        ];
        var primitive = new GroupPrimitive_1.GroupPrimitive(linePrimitives, className);
        var ellEl = this.getExtensionLineElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
    };
    CanvasManager.prototype.hideExtensionLines = function () {
        for (var i = 0; i < this.extensionLineElements.length; i++) {
            if (this.extensionLineElements[i])
                this.extensionLineElements[i].style.display = "none";
        }
    };
    CanvasManager.prototype.getExtensionLineElement = function (primitive, index) {
        var ellEl = this.extensionLineElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.extensionLineElements[index] = (ellEl);
        }
        return ellEl;
    };
    // Export
    CanvasManager.prototype.getSvgImage = function () {
        var svgEl = this.svgElement.cloneNode();
        Utils_2.RenderUtils.updateSvgElementSize(svgEl, this.svgWidth / this.zoomLevel, this.svgHeight / this.zoomLevel);
        var exportCssRules = this.getExportCssRules();
        var useCssRules = exportCssRules && !Browser_1.Browser.IE;
        if (useCssRules) {
            var style = document.createElementNS(RenderManager_1.svgNS, "style");
            style.innerHTML = exportCssRules;
            svgEl.appendChild(style);
        }
        for (var i = 0; i < this.itemsContainer.childNodes.length; i++) {
            var node = this.itemsContainer.childNodes[i].cloneNode(true);
            if (!useCssRules)
                this.inlineStyle(node, this.itemsContainer.childNodes[i]);
            svgEl.appendChild(node);
        }
        return this.getSvgBase64String(svgEl);
    };
    CanvasManager.prototype.getSvgBase64String = function (svgElement) {
        var xml = new XMLSerializer().serializeToString(svgElement);
        return CanvasManager.base64Start + this.getBase64EncodeUnicode(xml);
    };
    CanvasManager.prototype.getBase64EncodeUnicode = function (s) {
        return btoa(encodeURIComponent(s).replace(/%([0-9A-F]{2})/g, function (match, p1) { return String.fromCharCode(parseInt("0x" + p1, 16)); }));
    };
    CanvasManager.prototype.getExportCssRules = function () {
        for (var i = 0; i < document.styleSheets.length; i++) {
            var rules = this.getRules(document.styleSheets[i]);
            if (rules) {
                var cssText = "";
                for (var j = 0; j < rules.length; j++) {
                    var rule = rules[j];
                    var selectorText = this.isCSSStyleRule(rule) ? rule.selectorText : null;
                    if (selectorText && this.checkSelector(selectorText))
                        cssText += rule.cssText + "\n";
                }
                if (cssText.length > 0)
                    return "\n" + cssText;
            }
        }
    };
    CanvasManager.prototype.checkSelector = function (selectorText) {
        for (var i = 0; i < CanvasManager.exportStyleRules.length; i++) {
            if (selectorText.indexOf(CanvasManager.exportStyleRules[i]) === 0)
                return true;
        }
        return false;
    };
    CanvasManager.prototype.getRules = function (styleSheet) {
        try {
            return this.isCSSStyleSheet(styleSheet) ? styleSheet.rules || styleSheet.cssRules : null;
        }
        catch (_a) { } // Catch access dinied exception
    };
    CanvasManager.prototype.isCSSStyleSheet = function (stylesheet) {
        return stylesheet.rules !== undefined;
    };
    CanvasManager.prototype.isCSSStyleRule = function (rule) {
        return rule.selectorText !== undefined;
    };
    CanvasManager.prototype.inlineStyle = function (destNode, srcNode) {
        for (var i = 0; i < destNode.childNodes.length; i++) {
            var child = destNode.childNodes[i];
            if (!child.tagName)
                continue;
            if (child.tagName === "g")
                this.inlineStyle(child, srcNode.childNodes[i]);
            else if (child.style) {
                var style = window.getComputedStyle(srcNode.childNodes[i]);
                if (style !== undefined) {
                    for (var index = 0; index < CanvasManager.exportStyleAttributes.length; index++) {
                        var styleProperty = CanvasManager.exportStyleAttributes[index];
                        child.style.setProperty(styleProperty, style.getPropertyValue(styleProperty));
                    }
                }
            }
        }
    };
    CanvasManager.prototype.exportSvgImage = function (callback) {
        callback(this.getSvgImage());
    };
    CanvasManager.prototype.exportBinaryImage = function (mimeType, width, height, callback) {
        var canvasEl = document.createElement('canvas');
        canvasEl.width = width;
        canvasEl.height = height;
        var imgEl = document.createElement('img');
        imgEl.width = width;
        imgEl.height = height;
        imgEl.setAttribute('crossOrigin', 'anonymous');
        imgEl.onload = function () {
            var ctx = canvasEl.getContext("2d");
            ctx.fillStyle = "white";
            ctx.fillRect(0, 0, width, height);
            ctx.drawImage(imgEl, 0, 0);
            callback(canvasEl.toDataURL(mimeType));
        };
        imgEl.src = this.getSvgImage();
    };
    CanvasManager.prototype.exportPngImage = function (callback) {
        this.exportBinaryImage("image/png", this.svgWidth, this.svgHeight, callback);
    };
    CanvasManager.prototype.exportJpgImage = function (callback) {
        this.exportBinaryImage("image/jpeg", this.svgWidth, this.svgHeight, callback);
    };
    // Utils
    CanvasManager.prototype.createAndChangePrimitivesElements = function (primitives, parent) {
        var _this = this;
        primitives.forEach(function (primitive) {
            _this.createAndChangePrimitiveElement(primitive, parent);
        });
    };
    CanvasManager.prototype.changePrimitivesElements = function (primitives, parent) {
        var _this = this;
        primitives.forEach(function (primitive, index) {
            var element = parent.childNodes[index];
            _this.changePrimitiveElement(primitive, element);
        });
    };
    CanvasManager.prototype.createPrimitiveElement = function (primitive, parent, sibling) {
        var element = primitive.createElement();
        if (sibling !== undefined)
            parent.insertBefore(element, sibling);
        else
            parent.appendChild(element);
        return element;
    };
    CanvasManager.prototype.createAndChangePrimitiveElement = function (primitive, parent, sibling) {
        var element = this.createPrimitiveElement(primitive, parent, sibling);
        this.changePrimitiveElement(primitive, element);
        return element;
    };
    CanvasManager.prototype.changePrimitiveElement = function (primitive, element) {
        primitive.applyElementProperties(element);
    };
    CanvasManager.prototype.correctShapeSelectionRect = function (rect, lineWidth) {
        var corr = Math.ceil(Shape_1.Shape.lineWidth / 2 * this.zoomLevel);
        rect = rect.inflate(corr, corr);
        var lwCorr = Math.floor(lineWidth / 2);
        rect.position.x -= lwCorr;
        rect.position.y -= lwCorr;
        rect.size.width += lineWidth;
        rect.size.height += lineWidth;
        return rect;
    };
    CanvasManager.selectionMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(10);
    CanvasManager.lockedSelectionMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasManager.selectionRectLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.multiSelectionRectLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.connectionPointSmallSize = UnitConverter_1.UnitConverter.pixelsToTwips(5);
    CanvasManager.connectionPointLargeSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasManager.connectionMarkSmallSize = UnitConverter_1.UnitConverter.pixelsToTwips(12);
    CanvasManager.connectionMarkLargeSize = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasManager.connectionMarkShift = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasManager.connectionTargetBorderWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    CanvasManager.connectorSelectionLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.connectorSelectionWidth = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasManager.geomertyMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasManager.connectorPointMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasManager.connectorSideMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasManager.extensionLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.extensionLineOffset = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.extensionLineEndingSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasManager.resizeInfoOffset = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasManager.resizeInfoTextOffset = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    CanvasManager.resizeInfoLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasManager.pagesGridLineWidth = 2;
    CanvasManager.base64Start = 'data:image/svg+xml;base64,';
    CanvasManager.exportStyleRules = [
        ".dxdi-canvas .shape ", ".dxdi-canvas .connector "
    ];
    CanvasManager.exportStyleAttributes = [
        "fill", "stroke", "stroke-width", "shape-rendering",
        "font-family", "font-size", "font-weight", "font-style", "text-decoration", "text-anchor"
    ];
    return CanvasManager;
}());
exports.CanvasManager = CanvasManager;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerStateBase = /** @class */ (function () {
    function MouseHandlerStateBase(handler) {
        this.handler = handler;
    }
    MouseHandlerStateBase.prototype.start = function () { };
    MouseHandlerStateBase.prototype.finish = function () { };
    MouseHandlerStateBase.prototype.onMouseDoubleClick = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseDown = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseUp = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseMove = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseWheel = function (_evt) { };
    MouseHandlerStateBase.prototype.onDragStart = function (_evt) { };
    MouseHandlerStateBase.prototype.onDragEnd = function (_evt) { };
    MouseHandlerStateBase.prototype.onShortcut = function (_shortcutCode) { return false; };
    return MouseHandlerStateBase;
}());
exports.MouseHandlerStateBase = MouseHandlerStateBase;
var MouseHandlerCancellableState = /** @class */ (function (_super) {
    __extends(MouseHandlerCancellableState, _super);
    function MouseHandlerCancellableState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerCancellableState.prototype.onShortcut = function (code) {
        if (code === KeyCode_1.KeyCode.Esc) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
            return true;
        }
        return false;
    };
    return MouseHandlerCancellableState;
}(MouseHandlerStateBase));
exports.MouseHandlerCancellableState = MouseHandlerCancellableState;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CommandManager_1 = __webpack_require__(68);
exports.DiagramCommand = CommandManager_1.DiagramCommand;
var Diagram_1 = __webpack_require__(213);
exports.DiagramControl = Diagram_1.DiagramControl;
var Utils_1 = __webpack_require__(0);
exports.EventDispatcher = Utils_1.EventDispatcher;
var ShapeType_1 = __webpack_require__(1);
exports.ShapeType = ShapeType_1.ShapeType;
exports.ShapeCategory = ShapeType_1.ShapeCategory;
var UnitConverter_1 = __webpack_require__(13);
exports.UnitConverter = UnitConverter_1.UnitConverter;
var Browser_1 = __webpack_require__(20);
exports.Browser = Browser_1.Browser;
var DataSource_1 = __webpack_require__(37);
exports.DataLayoutType = DataSource_1.DataLayoutType;
__webpack_require__(247);


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StyleBase = /** @class */ (function () {
    function StyleBase() {
    }
    StyleBase.prototype.clone = function () {
        var _this = this;
        var style = this.createInstance();
        this.forEach(function (propertyName) { style[propertyName] = _this[propertyName]; });
        return style;
    };
    StyleBase.prototype.forEach = function (callback) {
        for (var propertyName in this) {
            if (this.hasOwnProperty(propertyName))
                callback(propertyName);
        }
    };
    StyleBase.prototype.toObject = function () {
        var _this = this;
        var result = {};
        var modified = false;
        var defaultStyle = this.getDefaultInstance();
        this.forEach(function (key) {
            if (_this[key] !== defaultStyle[key]) {
                result[key] = _this[key];
                modified = true;
            }
        });
        return modified ? result : null;
    };
    StyleBase.prototype.fromObject = function (obj) {
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (this[key] !== undefined)
                    this[key] = obj[key];
            }
        }
    };
    return StyleBase;
}());
exports.StyleBase = StyleBase;
var Style = /** @class */ (function (_super) {
    __extends(Style, _super);
    function Style() {
        var _this = _super.call(this) || this;
        // Default values must be the same with css
        _this["fill"] = "white";
        _this["stroke"] = "black";
        return _this;
    }
    Style.prototype.createInstance = function () {
        return new Style();
    };
    Style.prototype.getDefaultInstance = function () {
        return Style.defaultInstace;
    };
    Style.defaultInstace = new Style();
    return Style;
}(StyleBase));
exports.Style = Style;
var StyleText = /** @class */ (function (_super) {
    __extends(StyleText, _super);
    function StyleText() {
        var _this = _super.call(this) || this;
        // Default values must be the same with css
        _this["fill"] = "black";
        _this["font-family"] = "Arial";
        _this["font-size"] = "10pt";
        _this["font-weight"] = "";
        _this["font-style"] = "";
        _this["text-decoration"] = "";
        _this["text-anchor"] = "middle";
        return _this;
    }
    StyleText.prototype.createInstance = function () {
        return new StyleText();
    };
    StyleText.prototype.getDefaultInstance = function () {
        return StyleText.defaultInstace;
    };
    StyleText.defaultInstace = new StyleText();
    return StyleText;
}(StyleBase));
exports.StyleText = StyleText;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ItemChangeType;
(function (ItemChangeType) {
    ItemChangeType[ItemChangeType["Create"] = 0] = "Create";
    ItemChangeType[ItemChangeType["Update"] = 1] = "Update";
    ItemChangeType[ItemChangeType["UpdateStructure"] = 2] = "UpdateStructure";
    ItemChangeType[ItemChangeType["UpdateZIndex"] = 3] = "UpdateZIndex";
    ItemChangeType[ItemChangeType["Remove"] = 4] = "Remove";
})(ItemChangeType = exports.ItemChangeType || (exports.ItemChangeType = {}));
var PageChangeType;
(function (PageChangeType) {
    PageChangeType[PageChangeType["Create"] = 0] = "Create";
    PageChangeType[PageChangeType["Update"] = 1] = "Update";
    PageChangeType[PageChangeType["Remove"] = 2] = "Remove";
})(PageChangeType = exports.PageChangeType || (exports.PageChangeType = {}));
var ChangeBase = /** @class */ (function () {
    function ChangeBase(key, type) {
        this.key = key;
        this.type = type;
    }
    return ChangeBase;
}());
exports.ChangeBase = ChangeBase;
var ShapeChange = /** @class */ (function (_super) {
    __extends(ShapeChange, _super);
    function ShapeChange(shape, type) {
        var _this = _super.call(this, shape.key, type) || this;
        _this.shape = shape;
        return _this;
    }
    return ShapeChange;
}(ChangeBase));
exports.ShapeChange = ShapeChange;
var ConnectorChange = /** @class */ (function (_super) {
    __extends(ConnectorChange, _super);
    function ConnectorChange(connector, type) {
        var _this = _super.call(this, connector.key, type) || this;
        _this.connector = connector;
        return _this;
    }
    return ConnectorChange;
}(ChangeBase));
exports.ConnectorChange = ConnectorChange;
var PageChange = /** @class */ (function (_super) {
    __extends(PageChange, _super);
    function PageChange(model, type, offset) {
        var _this = _super.call(this, "-1", type) || this;
        _this.model = model;
        _this.offset = offset;
        return _this;
    }
    return PageChange;
}(ChangeBase));
exports.PageChange = PageChange;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(20);
var TouchUIHelper_1 = __webpack_require__(70);
var Base_1 = __webpack_require__(19);
var Evt = /** @class */ (function () {
    function Evt() {
    }
    Evt.GetEvent = function (evt) {
        return (typeof (event) != "undefined" && event != null && Browser_1.Browser.IE) ? event : evt;
    };
    Evt.AttachEventToElement = function (element, eventName, handler, onlyBubbling) {
        if (onlyBubbling === void 0) { onlyBubbling = false; }
        if (element.addEventListener)
            element.addEventListener(eventName, handler, !onlyBubbling);
        else
            element.attachEvent("on" + eventName, handler);
    };
    Evt.AttachEventToDocument = function (eventName, handler) {
        var attachingAllowed = TouchUIHelper_1.TouchUIHelper.onEventAttachingToDocument(eventName, handler);
        if (attachingAllowed)
            Evt.AttachEventToElement(document, eventName, handler);
    };
    Evt.PreventEvent = function (evt) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return false;
    };
    Evt.GetKeyCode = function (evt) {
        return Browser_1.Browser.NetscapeFamily || Browser_1.Browser.Opera ? evt.which : evt.keyCode;
    };
    Evt.GetEventSource = function (evt) {
        if (!Base_1.IsExists(evt))
            return null;
        return evt.srcElement ? evt.srcElement : evt.target;
    };
    Evt.GetMouseWheelEventName = function () {
        if (Browser_1.Browser.Safari)
            return "mousewheel";
        if (Browser_1.Browser.NetscapeFamily && Browser_1.Browser.MajorVersion < 17)
            return "DOMMouseScroll";
        return "wheel";
    };
    Evt.IsLeftButtonPressed = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return true;
        evt = Evt.GetEvent(evt);
        if (!evt)
            return false;
        if (Browser_1.Browser.IE && Browser_1.Browser.Version < 11) {
            if (Browser_1.Browser.MSTouchUI)
                return true;
            return evt.button % 2 == 1; // B213431
        }
        else if (Browser_1.Browser.WebKitFamily) {
            if (evt.type === "pointermove")
                return evt.buttons === 1;
            return evt.which == 1;
        }
        else if (Browser_1.Browser.NetscapeFamily || Browser_1.Browser.Edge || (Browser_1.Browser.IE && Browser_1.Browser.Version >= 11)) {
            if (evt.type === TouchUIHelper_1.TouchUIHelper.touchMouseMoveEventName)
                return evt.buttons === 1;
            return evt.which == 1;
        }
        else if (Browser_1.Browser.Opera)
            return evt.button == 0;
        return true;
    };
    Evt.PreventEventAndBubble = function (evt) {
        Evt.PreventEvent(evt);
        if (evt.stopPropagation)
            evt.stopPropagation();
        evt.cancelBubble = true;
        return false;
    };
    Evt.clientEventRequiresDocScrollCorrection = function () {
        var isSafariVerLess3 = Browser_1.Browser.Safari && Browser_1.Browser.Version < 3, isMacOSMobileVerLess51 = Browser_1.Browser.MacOSMobilePlatform && Browser_1.Browser.Version < 5.1;
        return Browser_1.Browser.AndroidDefaultBrowser || Browser_1.Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
    };
    Evt.GetEventX = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return TouchUIHelper_1.TouchUIHelper.getEventX(evt);
        return evt.clientX + (Evt.clientEventRequiresDocScrollCorrection() ? Base_1.GetDocumentScrollLeft() : 0);
    };
    Evt.GetEventY = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return TouchUIHelper_1.TouchUIHelper.getEventY(evt);
        return evt.clientY + (Evt.clientEventRequiresDocScrollCorrection() ? Base_1.GetDocumentScrollTop() : 0);
    };
    Evt.CancelBubble = function (evt) {
        evt.cancelBubble = true;
        return false;
    };
    return Evt;
}());
exports.Evt = Evt;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var Utils_1 = __webpack_require__(26);
var TextPrimitive = /** @class */ (function (_super) {
    __extends(TextPrimitive, _super);
    function TextPrimitive(x, y, text, width, style, reverseTextAhchor, clipPathId, filterId, onApplyProperties) {
        var _this = _super.call(this, style, "", clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.text = text;
        _this.width = width;
        _this.reverseTextAhchor = reverseTextAhchor;
        _this.filterId = filterId;
        _this.textSegmens = _this.text.split("\n").filter(function (s) { return s; });
        return _this;
    }
    TextPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "text");
    };
    TextPrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        if (this.filterId)
            element.setAttribute("filter", "url(#" + this.filterId + ")");
        _super.prototype.applyElementProperties.call(this, element);
        this.applyElementText(element);
    };
    TextPrimitive.prototype.applyElementText = function (element) {
        var _this = this;
        Utils_1.RenderUtils.removeContent(element);
        var lineCount = 0;
        this.textSegmens.forEach(function (txt, index) {
            var tspan = _this.createTSpanElement(element);
            lineCount++;
            if (_this.width) {
                var words = txt.split(" ");
                var line = "", prevLine = "";
                for (var i = 0; i < words.length; i++) {
                    line += (line.length ? " " : "") + words[i];
                    tspan.textContent = line;
                    var lineWidth = Utils_1.RenderUtils.getSvgTextRectangle(element).width;
                    if (lineWidth >= _this.width && prevLine !== "") {
                        tspan.textContent = prevLine;
                        prevLine = line = words[i];
                        tspan = _this.createTSpanElement(element);
                        tspan.textContent = line;
                        lineCount++;
                    }
                    else {
                        prevLine = line;
                    }
                }
            }
            else {
                tspan.textContent = txt;
            }
        });
        var firstTSpan = element.firstChild;
        if (firstTSpan) {
            var dy = -((lineCount - 1) / 2) + TextPrimitive.baselineCorrection;
            firstTSpan.setAttribute("dy", dy.toFixed(2) + "em");
        }
    };
    TextPrimitive.prototype.createTSpanElement = function (parent) {
        var tspan = document.createElementNS(RenderManager_1.svgNS, "tspan");
        parent.appendChild(tspan);
        this.setUnitAttribute(tspan, "x", this.x);
        tspan.setAttribute("dy", "1.05em");
        return tspan;
    };
    TextPrimitive.prototype.applyElementStyleProperties = function (element) {
        this.applyElementStylePropertiesCore(element, this.reverseTextAhchor);
    };
    TextPrimitive.baselineCorrection = 0.35;
    return TextPrimitive;
}(Primitive_1.SvgPrimitive));
exports.TextPrimitive = TextPrimitive;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ShapeDescriptionManager_1 = __webpack_require__(30);
var Shape_1 = __webpack_require__(9);
var AddShapeHistoryItem = /** @class */ (function (_super) {
    __extends(AddShapeHistoryItem, _super);
    function AddShapeHistoryItem(shapeType, position, text, dataKey) {
        var _this = _super.call(this) || this;
        _this.shapeType = shapeType;
        _this.position = position;
        _this.text = text;
        _this.dataKey = dataKey;
        return _this;
    }
    AddShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = new Shape_1.Shape(ShapeDescriptionManager_1.ShapeDescriptionManager.get(this.shapeType), this.position);
        if (typeof this.text === "string")
            shape.text = this.text;
        if (this.dataKey !== undefined)
            shape.dataKey = this.dataKey;
        manipulator.addShape(shape, this.shapeKey);
        this.shapeKey = shape.key;
    };
    AddShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.deleteShape(manipulator.model.findShape(this.shapeKey));
    };
    return AddShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddShapeHistoryItem = AddShapeHistoryItem;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var ClipPathPrimitive = /** @class */ (function (_super) {
    __extends(ClipPathPrimitive, _super);
    function ClipPathPrimitive(id, children) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.children = children;
        return _this;
    }
    ClipPathPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "clipPath");
    };
    ClipPathPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return ClipPathPrimitive;
}(Primitive_1.SvgPrimitive));
exports.ClipPathPrimitive = ClipPathPrimitive;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var RectanglePrimitive = /** @class */ (function (_super) {
    __extends(RectanglePrimitive, _super);
    function RectanglePrimitive(x, y, width, height, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    RectanglePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "rect");
    };
    RectanglePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return RectanglePrimitive;
}(Primitive_1.SvgPrimitive));
exports.RectanglePrimitive = RectanglePrimitive;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
exports.ArrowVerticalTriangleHeightParameterName = "th";
exports.ArrowVerticalLineWidthParameterName = "lw";
var ArrowVerticalShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowVerticalShapeDescription, _super);
    function ArrowVerticalShapeDescription(title) {
        return _super.call(this, title, "", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.375, ShapeDescription_1.ShapeDefaultDimension)) || this;
    }
    Object.defineProperty(ArrowVerticalShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    ArrowVerticalShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalTriangleHeightParameterName, Math.sqrt(Math.pow(this.defaultSize.width, 2) - Math.pow(this.defaultSize.width / 2, 2))),
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalLineWidthParameterName, this.defaultSize.width / 3)
        ]);
    };
    ArrowVerticalShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.ArrowVerticalTriangleHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
        this.changeParameterValue(parameters, exports.ArrowVerticalLineWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
    };
    ArrowVerticalShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var delta = (shape.size.width - shape.parameters.get(exports.ArrowVerticalLineWidthParameterName).value) / 2;
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= delta;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += delta;
    };
    return ArrowVerticalShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ArrowVerticalShapeDescription = ArrowVerticalShapeDescription;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
exports.ArrowVerticalTriangleWidthParameterName = "tw";
exports.ArrowVerticalLineHeightParameterName = "lh";
var ArrowHorizontalShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowHorizontalShapeDescription, _super);
    function ArrowHorizontalShapeDescription(title) {
        return _super.call(this, title, "", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.375)) || this;
    }
    Object.defineProperty(ArrowHorizontalShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    ArrowHorizontalShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalTriangleWidthParameterName, Math.sqrt(Math.pow(this.defaultSize.height, 2) - Math.pow(this.defaultSize.height / 2, 2))),
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalLineHeightParameterName, this.defaultSize.height / 3)
        ]);
    };
    ArrowHorizontalShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.ArrowVerticalTriangleWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
        this.changeParameterValue(parameters, exports.ArrowVerticalLineHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    ArrowHorizontalShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var delta = (shape.size.height - shape.parameters.get(exports.ArrowVerticalLineHeightParameterName).value) / 2;
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += delta;
        else if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= delta;
    };
    return ArrowHorizontalShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ArrowHorizontalShapeDescription = ArrowHorizontalShapeDescription;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var EllipsePrimitive_1 = __webpack_require__(38);
var ShapeType_1 = __webpack_require__(1);
var EllipseShapeDescription = /** @class */ (function (_super) {
    __extends(EllipseShapeDescription, _super);
    function EllipseShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Ellipse"; }
        if (defaultText === void 0) { defaultText = ""; }
        return _super.call(this, title, defaultText, new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75)) || this;
    }
    Object.defineProperty(EllipseShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Ellipsis; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EllipseShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    EllipseShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var width = rect.width, height = rect.height;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var primitives = [];
        return primitives.concat([
            new EllipsePrimitive_1.EllipsePrimitive(cx, cy, width / 2, height / 2, shape.style),
        ])
            .concat(this.createTextPrimitives(shape));
    };
    return EllipseShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.EllipseShapeDescription = EllipseShapeDescription;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var ShapeType_1 = __webpack_require__(1);
var PolygonShapeDescription = /** @class */ (function (_super) {
    __extends(PolygonShapeDescription, _super);
    function PolygonShapeDescription(title, defaultText) {
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultSize.height = _this.calculateHeight(ShapeDescription_1.ShapeDefaultDimension);
        return _this;
    }
    Object.defineProperty(PolygonShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PolygonShapeDescription.prototype, "angle", {
        get: function () {
            return Math.PI * (this.angleCount - 2) / this.angleCount;
        },
        enumerable: true,
        configurable: true
    });
    return PolygonShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.PolygonShapeDescription = PolygonShapeDescription;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var Connector_1 = __webpack_require__(5);
var AddConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectorHistoryItem, _super);
    function AddConnectorHistoryItem(points, dataKey) {
        var _this = _super.call(this) || this;
        _this.points = points;
        _this.dataKey = dataKey;
        return _this;
    }
    AddConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = new Connector_1.Connector(this.points);
        if (this.dataKey !== undefined)
            connector.dataKey = this.dataKey;
        manipulator.addConnector(connector, this.connectorKey);
        this.connectorKey = connector.key;
    };
    AddConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnector(connector);
    };
    return AddConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorHistoryItem = AddConnectorHistoryItem;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var NodeLayout_1 = __webpack_require__(39);
var ShapeDescriptionManager_1 = __webpack_require__(30);
var LayoutUtils = /** @class */ (function () {
    function LayoutUtils() {
    }
    LayoutUtils.shapeToLayout = function (shape) {
        var margin = new NodeLayout_1.Margin(0);
        var shapeRect = shape.rectangle;
        shape.attachedConnectors.filter(function (c) { return !c.beginItem || !c.endItem; }).forEach(function (c) {
            var connRect = c.rectangle;
            margin.left = Math.max(margin.left, shapeRect.left - connRect.left + Connector_1.Connector.minOffset);
            margin.right = Math.max(margin.right, connRect.right - shapeRect.right + Connector_1.Connector.minOffset);
            margin.top = Math.max(margin.top, shapeRect.top - connRect.top + Connector_1.Connector.minOffset);
            margin.bottom = Math.max(margin.bottom, connRect.bottom - shapeRect.bottom + Connector_1.Connector.minOffset);
        });
        var layout = new NodeLayout_1.NodeInfo(shape.key, margin, shape.size.clone());
        layout.connectionPoints = shape.description.getConnectionPoints();
        return layout;
    };
    LayoutUtils.importNodeToLayout = function (node) {
        var margin = new NodeLayout_1.Margin(0);
        var description = ShapeDescriptionManager_1.ShapeDescriptionManager.get(node.type);
        var layout = new NodeLayout_1.NodeInfo(node.key, margin, description.defaultSize.clone());
        layout.connectionPoints = description.getConnectionPoints();
        return layout;
    };
    return LayoutUtils;
}());
exports.LayoutUtils = LayoutUtils;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var HashSet = /** @class */ (function () {
    function HashSet(list, getHashCode) {
        if (list === void 0) { list = []; }
        if (getHashCode === void 0) { getHashCode = function (item) { return item.toString(); }; }
        var _this = this;
        this.items = [];
        this.map = {};
        this.getHashCode = getHashCode;
        list.forEach(function (i) { return _this.tryPush(i); });
    }
    HashSet.prototype.tryPush = function (item) {
        var code = this.getHashCode(item);
        if (this.map[code] === undefined) {
            this.map[code] = this.items.push(item) - 1;
            return true;
        }
        return false;
    };
    HashSet.prototype.contains = function (item) {
        return this.map[this.getHashCode(item)] !== undefined;
    };
    HashSet.prototype.forEach = function (callback) {
        this.items.forEach(callback);
    };
    HashSet.prototype.filter = function (predicate) {
        return this.items.filter(predicate);
    };
    HashSet.prototype.list = function () {
        return this.items.slice(0);
    };
    HashSet.prototype.item = function (index) {
        return this.items[index];
    };
    HashSet.prototype.first = function () {
        return this.items[0];
    };
    HashSet.prototype.remove = function (item) {
        var code = this.getHashCode(item);
        var index = this.map[code];
        if (typeof index === "number") {
            delete this.map[code];
            this.items.splice(index, 1);
            for (var i = index; i < this.items.length; i++)
                this.map[this.getHashCode(this.items[i])]--;
        }
        else
            throw "Item not found";
    };
    Object.defineProperty(HashSet.prototype, "length", {
        get: function () { return this.items.length; },
        enumerable: true,
        configurable: true
    });
    return HashSet;
}());
exports.HashSet = HashSet;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Forest_1 = __webpack_require__(151);
var GraphLayout_1 = __webpack_require__(81);
var NodeLayout_1 = __webpack_require__(39);
var Utils_1 = __webpack_require__(0);
var BaseBuilder_1 = __webpack_require__(82);
var Structures_1 = __webpack_require__(22);
var DiagramItem_1 = __webpack_require__(3);
var LayoutSettings_1 = __webpack_require__(18);
var TreeLayoutBuilder = /** @class */ (function (_super) {
    __extends(TreeLayoutBuilder, _super);
    function TreeLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TreeLayoutBuilder.prototype.build = function () {
        var forest = Forest_1.Forest.create(this.graph);
        var layouts = [];
        for (var tree = void 0, i = 0; tree = forest.trees[i]; i++) {
            var layout_1 = this.processTree(tree);
            layouts.push(layout_1);
        }
        var offset = 0, layout = new GraphLayout_1.GraphLayout();
        for (var layoutComponent = void 0, i = 0; layoutComponent = layouts[i]; i++) {
            layout.extend(this.setComponentOffset(layoutComponent, offset));
            offset += this.getComponentOffset(layoutComponent);
        }
        return layout;
    };
    TreeLayoutBuilder.prototype.processTree = function (tree) {
        var layout = new GraphLayout_1.GraphLayout();
        var rootLayout = new NodeLayout_1.NodeLayout(tree.root, new Utils_1.Point(tree.root.margin.left, tree.root.margin.top));
        layout.addNode(rootLayout);
        this.processChildren(rootLayout, tree, layout, 0);
        if (this.settings.alignment === LayoutSettings_1.Alignment.Center)
            this.processParents(layout, rootLayout, tree);
        return layout;
    };
    TreeLayoutBuilder.prototype.processChildren = function (parent, tree, layout, nearbyPoint) {
        var _this = this;
        var children = tree.getChildren(parent.info);
        var edges = this.graph.getAdjacentEdges(parent.key, Structures_1.ConnectionMode.Outgoing);
        var distantPoint = nearbyPoint;
        var prevSiblingLayout;
        var _loop_1 = function (child, i) {
            var nearbyMargin = this_1.isVertical() ? child.margin.left : child.margin.top;
            if (prevSiblingLayout) {
                var prevSiblingDistantPoint = this_1.getChangingCoordinateForLayer(prevSiblingLayout.position) + this_1.getSizeMeasurement(prevSiblingLayout.info.size);
                var actualNearbyMargin = distantPoint - prevSiblingDistantPoint;
                nearbyMargin = Math.max(0, nearbyMargin - actualNearbyMargin);
                nearbyMargin += this_1.settings.columnSpacing;
            }
            var layerStartingPoint = this_1.isVertical() ? Math.max(parent.info.margin.bottom, child.margin.top) : Math.max(parent.info.margin.right, child.margin.left);
            var nodePosition = this_1.isVertical() ?
                new Utils_1.Point(distantPoint + nearbyMargin, parent.position.y + parent.info.size.height + layerStartingPoint + this_1.settings.layerSpacing) :
                new Utils_1.Point(parent.position.x + parent.info.size.width + layerStartingPoint + this_1.settings.layerSpacing, distantPoint + nearbyMargin);
            var childLayout = new NodeLayout_1.NodeLayout(child, nodePosition);
            distantPoint = Math.max(this_1.getChangingCoordinateForLayer(childLayout.position) + this_1.getSizeMeasurement(childLayout.info.size), this_1.processChildren(childLayout, tree, layout, distantPoint));
            layout.addNode(childLayout);
            edges.filter(function (e) { return e.to === child.key; }).forEach(function (e) {
                var beginIndex = _this.isVertical() ? DiagramItem_1.ConnectionPointSide.South : DiagramItem_1.ConnectionPointSide.East;
                var endIndex = _this.isVertical() ? DiagramItem_1.ConnectionPointSide.North : DiagramItem_1.ConnectionPointSide.West;
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, beginIndex, endIndex));
            });
            prevSiblingLayout = childLayout;
        };
        var this_1 = this;
        for (var child = void 0, i = 0; child = children[i]; i++) {
            _loop_1(child, i);
        }
        return distantPoint + this.settings.subTreeColumnSpacing;
    };
    TreeLayoutBuilder.prototype.processParents = function (layout, parent, tree, parentNextSibling) {
        var children = tree.getChildren(parent.info);
        for (var child = void 0, i = children.length - 1; child = children[i]; i--)
            this.processParents(layout, layout.nodeToLayout[child.key], tree, children[i + 1]);
        if (children.length) {
            var nearbyPoint = this.getChangingCoordinateForLayer(layout.nodeToLayout[children[0].key].position);
            var distantPoint = this.getRectangleDistantEdge(layout.nodeToLayout[children[children.length - 1].key].rectangle);
            var position = nearbyPoint + (distantPoint - nearbyPoint) / 2 - this.getSizeMeasurement(parent.info.size) / 2;
            position = Math.max(this.getChangingCoordinateForLayer(parent.position), this.correctByMargin(position, parent, parentNextSibling && layout.nodeToLayout[parentNextSibling.key]));
            if (this.isVertical())
                parent.position.x = position;
            else
                parent.position.y = position;
        }
    };
    TreeLayoutBuilder.prototype.getChangingCoordinateForLayer = function (point) {
        return this.isVertical() ? point.x : point.y;
    };
    TreeLayoutBuilder.prototype.getRectangleDistantEdge = function (rectangle) {
        return this.isVertical() ? rectangle.right : rectangle.bottom;
    };
    TreeLayoutBuilder.prototype.getSizeMeasurement = function (size) {
        return this.isVertical() ? size.width : size.height;
    };
    TreeLayoutBuilder.prototype.correctByMargin = function (position, element, distant) {
        if (distant) {
            var distantPoint = this.isVertical() ? Math.max(distant.info.margin.left, element.info.margin.right) : Math.max(distant.info.margin.top, element.info.margin.bottom);
            position = Math.min(position, this.getChangingCoordinateForLayer(distant.position) - distantPoint - this.getSizeMeasurement(element.info.size));
        }
        return position;
    };
    TreeLayoutBuilder.prototype.isVertical = function () {
        return this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical;
    };
    return TreeLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.TreeLayoutBuilder = TreeLayoutBuilder;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommandBase_1 = __webpack_require__(87);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(42);
var ChangeStyleTextPropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeStyleTextPropertyCommand, _super);
    function ChangeStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStyleTextPropertyCommand.prototype.getStateValue = function () {
        return this.control.selection.inputPosition.getStyleTextPropertyValue(this.getStyleProperty());
    };
    ChangeStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    ChangeStyleTextPropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStyleTextPropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setStyleTextPropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStyleTextPropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStyleTextPropertyCommand = ChangeStyleTextPropertyCommand;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleHistoryItemBase_1 = __webpack_require__(86);
var ChangeStyleHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeStyleHistoryItem, _super);
    function ChangeStyleHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleHistoryItem = ChangeStyleHistoryItem;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var CanvasManager_1 = __webpack_require__(44);
var RenderManager_1 = __webpack_require__(10);
var ExportImageCommand = /** @class */ (function (_super) {
    __extends(ExportImageCommand, _super);
    function ExportImageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportImageCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    ExportImageCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        try {
            var canvasManager = this.getCanvasManager();
            var exportFunc = this.getExportFunc();
            exportFunc(canvasManager, function (url) {
                parameter(url);
                _this.tryDisposeCanvasManager();
            });
        }
        catch (e) {
            this.tryDisposeCanvasManager();
            throw e;
        }
        return true;
    };
    ExportImageCommand.prototype.getCanvasManager = function () {
        if (this.control.canvasManager !== undefined)
            return this.control.canvasManager;
        if (this.canvasManager === undefined)
            this.canvasManager = this.createCanvasManager();
        return this.canvasManager;
    };
    ExportImageCommand.prototype.createCanvasManager = function () {
        var svgElement = RenderManager_1.RenderManager.createSvgElement(true);
        document.body.appendChild(svgElement);
        var canvasManager = new CanvasManager_1.CanvasManager(svgElement);
        this.control.modelManipulator.onModelChanged.add(canvasManager);
        this.control.modelManipulator.onLoad();
        return canvasManager;
    };
    ExportImageCommand.prototype.tryDisposeCanvasManager = function () {
        if (this.canvasManager) {
            document.body.removeChild(this.canvasManager.svgElement);
            delete this.canvasManager;
        }
    };
    return ExportImageCommand;
}(CommandBase_1.CommandBase));
exports.ExportImageCommand = ExportImageCommand;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var ClipboardCommand = /** @class */ (function (_super) {
    __extends(ClipboardCommand, _super);
    function ClipboardCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClipboardCommand.prototype.setClipboardData = function (data) {
        if (this.control.renderManager)
            this.control.renderManager.setClipboardData(data);
        else
            ClipboardCommand.clipboardData = data;
    };
    ClipboardCommand.prototype.getClipboardData = function (callback) {
        if (this.control.renderManager)
            this.control.renderManager.getClipboardData(callback);
        else
            callback(ClipboardCommand.clipboardData);
    };
    return ClipboardCommand;
}(CommandBase_1.CommandBase));
exports.ClipboardCommand = ClipboardCommand;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(8);
var MouseHandlerMoveShapeStateBase_1 = __webpack_require__(95);
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerMoveClonedShapeState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveClonedShapeState, _super);
    function MouseHandlerMoveClonedShapeState(handler, history, model, selection, moveStartPoint) {
        var _this = _super.call(this, handler, history, model, selection) || this;
        _this.model = model;
        _this.selection = selection;
        _this.moveStartPoint = moveStartPoint;
        return _this;
    }
    MouseHandlerMoveClonedShapeState.prototype.onMouseDown = function (evt) {
        var dx = this.moveStartPoint ? evt.layoutPoint.x - this.moveStartPoint.x : 0;
        var dy = this.moveStartPoint ? evt.layoutPoint.y - this.moveStartPoint.y : 0;
        ModelUtils_1.ModelUtils.cloneSelectionToOffset(this.history, this.model, this.selection, dx, dy);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveClonedShapeState.isMoveClonedShapeEvent = function (evt) {
        return evt.modifiers & KeyCode_1.ModifierKey.Ctrl && evt.modifiers & KeyCode_1.ModifierKey.Shift;
    };
    return MouseHandlerMoveClonedShapeState;
}(MouseHandlerMoveShapeStateBase_1.MouseHandlerMoveShapeStateBase));
exports.MouseHandlerMoveClonedShapeState = MouseHandlerMoveClonedShapeState;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectionPointInfo = /** @class */ (function () {
    function ConnectionPointInfo(point, side) {
        this.point = point;
        this.side = side;
    }
    return ConnectionPointInfo;
}());
exports.ConnectionPointInfo = ConnectionPointInfo;
var ConnectionPointsVisualizerBase = /** @class */ (function () {
    function ConnectionPointsVisualizerBase(dispatcher) {
        this.dispatcher = dispatcher;
    }
    ConnectionPointsVisualizerBase.prototype.getKey = function () {
        return this.key;
    };
    ConnectionPointsVisualizerBase.prototype.setPoints = function (key, points, pointIndex) {
        if (this.key !== key || this.pointIndex !== pointIndex) {
            this.key = key;
            this.points = points;
            this.pointIndex = pointIndex;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizerBase.prototype.setPointIndex = function (pointIndex) {
        if (0 <= pointIndex && pointIndex < this.points.length && this.pointIndex !== pointIndex) {
            this.pointIndex = pointIndex;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizerBase.prototype.update = function () {
        this.raiseShow();
    };
    ConnectionPointsVisualizerBase.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.points = [];
            this.pointIndex = -1;
            this.raiseHide();
        }
    };
    return ConnectionPointsVisualizerBase;
}());
exports.ConnectionPointsVisualizerBase = ConnectionPointsVisualizerBase;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DeleteCommand_1 = __webpack_require__(100);
var UndoCommand_1 = __webpack_require__(156);
var RedoCommand_1 = __webpack_require__(157);
var ImportCommand_1 = __webpack_require__(158);
var ExportCommand_1 = __webpack_require__(159);
var ToggleFontBoldCommand_1 = __webpack_require__(160);
var ToggleFontItalicCommand_1 = __webpack_require__(161);
var ToggleFontUnderlineCommand_1 = __webpack_require__(162);
var ChangeFontNameCommand_1 = __webpack_require__(163);
var ChangeFontSizeCommand_1 = __webpack_require__(164);
var ChangeFontColorCommand_1 = __webpack_require__(165);
var ChangeFillColorCommand_1 = __webpack_require__(166);
var ChangeStrokeColorCommand_1 = __webpack_require__(167);
var ImportDataSourceCommand_1 = __webpack_require__(168);
var ChangeTextAlignCommand_1 = __webpack_require__(169);
var ChangeConnectorLineEndingCommand_1 = __webpack_require__(170);
var ChangeConnectorLineOptionCommand_1 = __webpack_require__(171);
var SelectAllCommand_1 = __webpack_require__(172);
var KeyCode_1 = __webpack_require__(16);
var AutoLayoutTreeVerticalCommand_1 = __webpack_require__(173);
var ChangeSnapToGridCommand_1 = __webpack_require__(174);
var ChangeGridSizeCommand_1 = __webpack_require__(176);
var ChangePageLandscapeCommand_1 = __webpack_require__(177);
var ChangePageSizeCommand_1 = __webpack_require__(179);
var ExportPngCommand_1 = __webpack_require__(181);
var ExportSvgCommand_1 = __webpack_require__(185);
var ExportJpgCommand_1 = __webpack_require__(186);
var CopySelectionCommand_1 = __webpack_require__(187);
var CutSelectionCommand_1 = __webpack_require__(188);
var PasteSelectionCommand_1 = __webpack_require__(189);
var ImportBPMNCommand_1 = __webpack_require__(192);
var SendToBackCommand_1 = __webpack_require__(194);
var BringToFrontCommand_1 = __webpack_require__(195);
var AutoLayoutLayeredHorizontalCommand_1 = __webpack_require__(196);
var MoveCommands_1 = __webpack_require__(197);
var ChangeZoomLevelCommand_1 = __webpack_require__(198);
var BindDocumentCommand_1 = __webpack_require__(199);
var UnbindDocumentCommand_1 = __webpack_require__(201);
var AutoLayoutTreeHorizontalCommand_1 = __webpack_require__(202);
var AutoLayoutLayeredVerticalCommand_1 = __webpack_require__(203);
var CloseDataSourceCommand_1 = __webpack_require__(204);
var LockCommand_1 = __webpack_require__(205);
var UnlockCommand_1 = __webpack_require__(207);
var CloneCommand_1 = __webpack_require__(208);
var ChangeUnitsCommand_1 = __webpack_require__(209);
var ChangePageColorCommand_1 = __webpack_require__(210);
var ChangeShowGridCommand_1 = __webpack_require__(211);
var ToggleFullscreenCommand_1 = __webpack_require__(212);
var DiagramCommand;
(function (DiagramCommand) {
    DiagramCommand[DiagramCommand["Undo"] = 0] = "Undo";
    DiagramCommand[DiagramCommand["Redo"] = 1] = "Redo";
    DiagramCommand[DiagramCommand["Cut"] = 2] = "Cut";
    DiagramCommand[DiagramCommand["Copy"] = 3] = "Copy";
    DiagramCommand[DiagramCommand["Paste"] = 4] = "Paste";
    DiagramCommand[DiagramCommand["SelectAll"] = 5] = "SelectAll";
    DiagramCommand[DiagramCommand["Delete"] = 6] = "Delete";
    DiagramCommand[DiagramCommand["Import"] = 7] = "Import";
    DiagramCommand[DiagramCommand["ImportBPMN"] = 8] = "ImportBPMN";
    DiagramCommand[DiagramCommand["Export"] = 9] = "Export";
    DiagramCommand[DiagramCommand["ExportSvg"] = 10] = "ExportSvg";
    DiagramCommand[DiagramCommand["ExportPng"] = 11] = "ExportPng";
    DiagramCommand[DiagramCommand["ExportJpg"] = 12] = "ExportJpg";
    DiagramCommand[DiagramCommand["ImportDataSource"] = 13] = "ImportDataSource";
    DiagramCommand[DiagramCommand["CloseDataSource"] = 14] = "CloseDataSource";
    DiagramCommand[DiagramCommand["BindDocument"] = 15] = "BindDocument";
    DiagramCommand[DiagramCommand["UnbindDocument"] = 16] = "UnbindDocument";
    DiagramCommand[DiagramCommand["Bold"] = 17] = "Bold";
    DiagramCommand[DiagramCommand["Italic"] = 18] = "Italic";
    DiagramCommand[DiagramCommand["Underline"] = 19] = "Underline";
    DiagramCommand[DiagramCommand["FontName"] = 20] = "FontName";
    DiagramCommand[DiagramCommand["FontSize"] = 21] = "FontSize";
    DiagramCommand[DiagramCommand["FontColor"] = 22] = "FontColor";
    DiagramCommand[DiagramCommand["FillColor"] = 23] = "FillColor";
    DiagramCommand[DiagramCommand["StrokeColor"] = 24] = "StrokeColor";
    DiagramCommand[DiagramCommand["TextLeftAlign"] = 25] = "TextLeftAlign";
    DiagramCommand[DiagramCommand["TextCenterAlign"] = 26] = "TextCenterAlign";
    DiagramCommand[DiagramCommand["TextRightAlign"] = 27] = "TextRightAlign";
    DiagramCommand[DiagramCommand["ConnectorLineOption"] = 28] = "ConnectorLineOption";
    DiagramCommand[DiagramCommand["ConnectorStartLineEnding"] = 29] = "ConnectorStartLineEnding";
    DiagramCommand[DiagramCommand["ConnectorEndLineEnding"] = 30] = "ConnectorEndLineEnding";
    DiagramCommand[DiagramCommand["BringToFront"] = 31] = "BringToFront";
    DiagramCommand[DiagramCommand["SendToBack"] = 32] = "SendToBack";
    DiagramCommand[DiagramCommand["MoveLeft"] = 33] = "MoveLeft";
    DiagramCommand[DiagramCommand["MoveStepLeft"] = 34] = "MoveStepLeft";
    DiagramCommand[DiagramCommand["MoveRight"] = 35] = "MoveRight";
    DiagramCommand[DiagramCommand["MoveStepRight"] = 36] = "MoveStepRight";
    DiagramCommand[DiagramCommand["MoveUp"] = 37] = "MoveUp";
    DiagramCommand[DiagramCommand["MoveStepUp"] = 38] = "MoveStepUp";
    DiagramCommand[DiagramCommand["MoveDown"] = 39] = "MoveDown";
    DiagramCommand[DiagramCommand["MoveStepDown"] = 40] = "MoveStepDown";
    DiagramCommand[DiagramCommand["CloneLeft"] = 41] = "CloneLeft";
    DiagramCommand[DiagramCommand["CloneRight"] = 42] = "CloneRight";
    DiagramCommand[DiagramCommand["CloneUp"] = 43] = "CloneUp";
    DiagramCommand[DiagramCommand["CloneDown"] = 44] = "CloneDown";
    DiagramCommand[DiagramCommand["AutoLayoutTree"] = 45] = "AutoLayoutTree";
    DiagramCommand[DiagramCommand["AutoLayoutFlow"] = 46] = "AutoLayoutFlow";
    DiagramCommand[DiagramCommand["AutoLayoutTreeVertical"] = 47] = "AutoLayoutTreeVertical";
    DiagramCommand[DiagramCommand["AutoLayoutTreeHorizontal"] = 48] = "AutoLayoutTreeHorizontal";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredVertical"] = 49] = "AutoLayoutLayeredVertical";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredHorizontal"] = 50] = "AutoLayoutLayeredHorizontal";
    DiagramCommand[DiagramCommand["Lock"] = 51] = "Lock";
    DiagramCommand[DiagramCommand["Unlock"] = 52] = "Unlock";
    DiagramCommand[DiagramCommand["Units"] = 53] = "Units";
    DiagramCommand[DiagramCommand["PageSize"] = 54] = "PageSize";
    DiagramCommand[DiagramCommand["PageLandscape"] = 55] = "PageLandscape";
    DiagramCommand[DiagramCommand["PageColor"] = 56] = "PageColor";
    DiagramCommand[DiagramCommand["GridSize"] = 57] = "GridSize";
    DiagramCommand[DiagramCommand["ShowGrid"] = 58] = "ShowGrid";
    DiagramCommand[DiagramCommand["SnapToGrid"] = 59] = "SnapToGrid";
    DiagramCommand[DiagramCommand["ZoomLevel"] = 60] = "ZoomLevel";
    DiagramCommand[DiagramCommand["Fullscreen"] = 61] = "Fullscreen";
})(DiagramCommand = exports.DiagramCommand || (exports.DiagramCommand = {}));
var CommandManager = /** @class */ (function () {
    function CommandManager(control) {
        this.commands = {};
        this.shortcutsToCommand = {};
        this.lastCommandsChain = [];
        this.executingCommandsChain = [];
        this.executingCommandCounter = 0;
        this.isPublicApiCall = false;
        this.createCommand(control, DiagramCommand.Undo, UndoCommand_1.UndoCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_z, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Redo, RedoCommand_1.RedoCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_y, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Key_z, KeyCode_1.ModifierKey.Meta | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Cut, CutSelectionCommand_1.CutSelectionCommand, KeyCode_1.KeyCode.Key_x | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_x | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Copy, CopySelectionCommand_1.CopySelectionCommand, KeyCode_1.KeyCode.Key_c | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_c | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Paste, PasteSelectionCommand_1.PasteSelectionCommand);
        this.createCommand(control, DiagramCommand.SelectAll, SelectAllCommand_1.SelectAllCommand, KeyCode_1.KeyCode.Key_a | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_a | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Delete, DeleteCommand_1.DeleteCommand, KeyCode_1.KeyCode.Delete, KeyCode_1.KeyCode.Backspace);
        this.createCommand(control, DiagramCommand.Import, ImportCommand_1.ImportCommand);
        this.createCommand(control, DiagramCommand.ImportBPMN, ImportBPMNCommand_1.ImportBPMNCommand);
        this.createCommand(control, DiagramCommand.Export, ExportCommand_1.ExportCommand);
        this.createCommand(control, DiagramCommand.ExportSvg, ExportSvgCommand_1.ExportSvgCommand);
        this.createCommand(control, DiagramCommand.ExportPng, ExportPngCommand_1.ExportPngCommand);
        this.createCommand(control, DiagramCommand.ExportJpg, ExportJpgCommand_1.ExportJpgCommand);
        this.createCommand(control, DiagramCommand.ImportDataSource, ImportDataSourceCommand_1.ImportDataSourceCommand);
        this.createCommand(control, DiagramCommand.CloseDataSource, CloseDataSourceCommand_1.CloseDataSourceCommand);
        this.createCommand(control, DiagramCommand.BindDocument, BindDocumentCommand_1.BindDocumentCommand);
        this.createCommand(control, DiagramCommand.UnbindDocument, UnbindDocumentCommand_1.UnbindDocumentCommand);
        this.createCommand(control, DiagramCommand.Bold, ToggleFontBoldCommand_1.ToggleFontBoldCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_b, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_b);
        this.createCommand(control, DiagramCommand.Italic, ToggleFontItalicCommand_1.ToggleFontItalicCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_i, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_i);
        this.createCommand(control, DiagramCommand.Underline, ToggleFontUnderlineCommand_1.ToggleFontUnderlineCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_u, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_u);
        this.createCommand(control, DiagramCommand.FontName, ChangeFontNameCommand_1.ChangeFontNameCommand);
        this.createCommand(control, DiagramCommand.FontSize, ChangeFontSizeCommand_1.ChangeFontSizeCommand);
        this.createCommand(control, DiagramCommand.FontColor, ChangeFontColorCommand_1.ChangeFontColorCommand);
        this.createCommand(control, DiagramCommand.FillColor, ChangeFillColorCommand_1.ChangeFillColorCommand);
        this.createCommand(control, DiagramCommand.StrokeColor, ChangeStrokeColorCommand_1.ChangeStrokeColorCommand);
        this.createCommand(control, DiagramCommand.TextLeftAlign, ChangeTextAlignCommand_1.TextLeftAlignCommand);
        this.createCommand(control, DiagramCommand.TextCenterAlign, ChangeTextAlignCommand_1.TextCenterAlignCommand);
        this.createCommand(control, DiagramCommand.TextRightAlign, ChangeTextAlignCommand_1.TextRightAlignCommand);
        this.createCommand(control, DiagramCommand.ConnectorLineOption, ChangeConnectorLineOptionCommand_1.ChangeConnectorLineOptionCommand);
        this.createCommand(control, DiagramCommand.ConnectorStartLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorStartLineEndingCommand);
        this.createCommand(control, DiagramCommand.ConnectorEndLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorEndLineEndingCommand);
        this.createCommand(control, DiagramCommand.BringToFront, BringToFrontCommand_1.BringToFrontCommand);
        this.createCommand(control, DiagramCommand.SendToBack, SendToBackCommand_1.SendToBackCommand);
        this.createCommand(control, DiagramCommand.MoveLeft, MoveCommands_1.MoveLeftCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveStepLeft, MoveCommands_1.MoveStepLeftCommand, KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveRight, MoveCommands_1.MoveRightCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveStepRight, MoveCommands_1.MoveStepRightCommand, KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveUp, MoveCommands_1.MoveUpCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveStepUp, MoveCommands_1.MoveStepUpCommand, KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveDown, MoveCommands_1.MoveDownCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.MoveStepDown, MoveCommands_1.MoveStepDownCommand, KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.CloneLeft, CloneCommand_1.CloneLeftCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.CloneRight, CloneCommand_1.CloneRightCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.CloneUp, CloneCommand_1.CloneUpCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.CloneDown, CloneCommand_1.CloneDownCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.Lock, LockCommand_1.LockCommand);
        this.createCommand(control, DiagramCommand.Unlock, UnlockCommand_1.UnLockCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTree, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand); // TODO: remove after, need for BC
        this.createCommand(control, DiagramCommand.AutoLayoutFlow, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand); // TODO: remove after, need for BC
        this.createCommand(control, DiagramCommand.Units, ChangeUnitsCommand_1.ChangeUnitsCommand);
        this.createCommand(control, DiagramCommand.PageSize, ChangePageSizeCommand_1.ChangePageSizeCommand);
        this.createCommand(control, DiagramCommand.PageLandscape, ChangePageLandscapeCommand_1.ChangePageLandscapeCommand);
        this.createCommand(control, DiagramCommand.PageColor, ChangePageColorCommand_1.ChangePageColorCommand);
        this.createCommand(control, DiagramCommand.GridSize, ChangeGridSizeCommand_1.ChangeGridSizeCommand);
        this.createCommand(control, DiagramCommand.ShowGrid, ChangeShowGridCommand_1.ChangeShowGridCommand);
        this.createCommand(control, DiagramCommand.SnapToGrid, ChangeSnapToGridCommand_1.ChangeSnapToGridCommand);
        this.createCommand(control, DiagramCommand.ZoomLevel, ChangeZoomLevelCommand_1.ChangeZoomLevelCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeVertical, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeHorizontal, AutoLayoutTreeHorizontalCommand_1.AutoLayoutTreeHorizontalCommand); // Not Implemented
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredVertical, AutoLayoutLayeredVerticalCommand_1.AutoLayoutLayeredVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredHorizontal, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand);
        this.createCommand(control, DiagramCommand.Fullscreen, ToggleFullscreenCommand_1.ToggleFullscreenCommand, KeyCode_1.KeyCode.F11);
    }
    CommandManager.prototype.getCommand = function (key) {
        return this.commands[key];
    };
    CommandManager.prototype.beforeExecuting = function (command) {
        this.executingCommandsChain.push(command);
        this.executingCommandCounter++;
    };
    CommandManager.prototype.afterExecuting = function () {
        this.executingCommandCounter--;
        if (this.executingCommandCounter === 0) {
            this.lastCommandsChain = this.executingCommandsChain;
            this.executingCommandsChain = [];
        }
    };
    CommandManager.prototype.assertLastExecutedCommandsChain = function (checkLength) {
        var types = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            types[_i - 1] = arguments[_i];
        }
        if (checkLength && this.lastCommandsChain.length !== types.length)
            return false;
        for (var i = 0, type; type = types[i]; i++) {
            if (!this.lastCommandsChain[i] || !(this.lastCommandsChain[i] instanceof type))
                return false;
        }
        return true;
    };
    CommandManager.prototype.processShortcut = function (code) {
        var command = this.shortcutsToCommand[code];
        if (command)
            return command.execute();
        return false;
    };
    CommandManager.prototype.processPaste = function (clipboardData) {
        var command = this.getCommand(DiagramCommand.Paste);
        if (command)
            command.performPaste(clipboardData);
        return true;
    };
    // ISelectionChangesListener
    CommandManager.prototype.NotifySelectionChanged = function (_selection) {
        this.lastCommandsChain = [];
    };
    CommandManager.prototype.NotifyScrollPositionChanged = function () { };
    CommandManager.prototype.createCommand = function (control, commandId, commandType) {
        var shortcuts = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            shortcuts[_i - 3] = arguments[_i];
        }
        this.commands[commandId] = new commandType(control);
        for (var i = 0; i < shortcuts.length; i++) {
            var shortcut = shortcuts[i];
            if (typeof shortcut === "number")
                this.shortcutsToCommand[shortcut] = this.commands[commandId];
        }
    };
    return CommandManager;
}());
exports.CommandManager = CommandManager;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var LinePrimitive = /** @class */ (function (_super) {
    __extends(LinePrimitive, _super);
    function LinePrimitive(x1, y1, x2, y2, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        return _this;
    }
    LinePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "line");
    };
    LinePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x1", this.x1);
        this.setUnitAttribute(element, "y1", this.y1);
        this.setUnitAttribute(element, "x2", this.x2);
        this.setUnitAttribute(element, "y2", this.y2);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return LinePrimitive;
}(Primitive_1.SvgPrimitive));
exports.LinePrimitive = LinePrimitive;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(20);
var Base_1 = __webpack_require__(19);
var TouchUIHelper = /** @class */ (function () {
    function TouchUIHelper() {
    }
    TouchUIHelper.onEventAttachingToDocument = function (eventName, func) {
        if (Browser_1.Browser.MacOSMobilePlatform && TouchUIHelper.isTouchEventName(eventName)) {
            if (!TouchUIHelper.documentTouchHandlers[eventName])
                TouchUIHelper.documentTouchHandlers[eventName] = [];
            TouchUIHelper.documentTouchHandlers[eventName].push(func);
            return TouchUIHelper.documentEventAttachingAllowed;
        }
        return true;
    };
    TouchUIHelper.isTouchEventName = function (eventName) {
        return Browser_1.Browser.WebKitTouchUI && (eventName.indexOf("touch") > -1 || eventName.indexOf("gesture") > -1);
    };
    TouchUIHelper.isTouchEvent = function (evt) {
        if (!evt)
            return false;
        return Browser_1.Browser.WebKitTouchUI && Base_1.IsExists(evt.changedTouches);
    };
    TouchUIHelper.getEventX = function (evt) {
        return Browser_1.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
    };
    TouchUIHelper.getEventY = function (evt) {
        return Browser_1.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
    };
    TouchUIHelper.touchMouseDownEventName = Browser_1.Browser.WebKitTouchUI ? "touchstart" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerdown" : "mousedown");
    TouchUIHelper.touchMouseUpEventName = Browser_1.Browser.WebKitTouchUI ? "touchend" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerup" : "mouseup");
    TouchUIHelper.touchMouseMoveEventName = Browser_1.Browser.WebKitTouchUI ? "touchmove" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointermove" : "mousemove");
    TouchUIHelper.msTouchDraggableClassName = "dxMSTouchDraggable";
    TouchUIHelper.documentTouchHandlers = {};
    TouchUIHelper.documentEventAttachingAllowed = true;
    return TouchUIHelper;
}());
exports.TouchUIHelper = TouchUIHelper;
//export class TouchUIHelper {
//    isGesture: false;
//    isMouseEventFromScrolling: false;
//    isNativeScrollingAllowed: true;
//    clickSensetivity: 10;
//    documentTouchHandlers: {};
//    documentEventAttachingAllowed: true;
//    isTouchEvent(evt) {
//        if (!evt)
//            return false;
//        return ASPx.Browser.WebKitTouchUI && ASPx.IsExists(evt.changedTouches);
//    }
//    getEventX(evt) {
//        return ASPx.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
//    }
//    getEventY (evt) {
//        return ASPx.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
//    }
//    getWebkitMajorVersion() {
//        if (!this.webkitMajorVersion) {
//            var regExp = new RegExp("applewebkit/(\\d+)", "i");
//            var matches = regExp.exec(ASPx.Browser.UserAgent);
//            if (matches && matches.index >= 1)
//                this.webkitMajorVersion = matches[1];
//        }
//        return this.webkitMajorVersion;
//    }
//    getIsLandscapeOrientation() {
//        if (ASPx.Browser.MacOSMobilePlatform || ASPx.Browser.AndroidMobilePlatform)
//            return Math.abs(window.orientation) == 90;
//        return ASPx.GetDocumentClientWidth() > ASPx.GetDocumentClientHeight();
//    }
//    nativeScrollingSupported() {
//        var allowedSafariVersion = ASPx.Browser.Version >= 5.1 && ASPx.Browser.Version < 8; //T250059
//        var allowedWebKitVersion = this.getWebkitMajorVersion() > 533 && (ASPx.Browser.Chrome || this.getWebkitMajorVersion() < 600);
//        return (ASPx.Browser.MacOSMobilePlatform && (allowedSafariVersion || allowedWebKitVersion))
//            || (ASPx.Browser.AndroidMobilePlatform && ASPx.Browser.PlaformMajorVersion >= 3) || (ASPx.Browser.MSTouchUI && (!ASPx.Browser.WindowsPhonePlatform || !ASPx.Browser.IE));
//    }
//    makeScrollableIfRequired(element, options) {
//        if (ASPx.Browser.WebKitTouchUI && element) {
//            var overflow = ASPx.GetCurrentStyle(element).overflow;
//            if (element.tagName == "DIV" && overflow != "hidden" && overflow != "visible") {
//                return this.MakeScrollable(element);
//            }
//        }
//    }
//    preventScrollOnEvent(evt) {
//    }
//    handleFastTapIfRequired(evt, action, preventCommonClickEvents) {
//        if (ASPx.Browser.WebKitTouchUI && evt.type == 'touchstart' && action) {
//            this.FastTapHelper.HandleFastTap(evt, action, preventCommonClickEvents);
//            return true;
//        }
//        return false;
//    }
//    ensureDocumentSizesCorrect () {
//        return (document.documentElement.clientWidth - document.documentElement.clientHeight) / (screen.width - screen.height) > 0;
//    }
//    ensureOrientationChanged(onOrientationChangedFunction) {
//        if (ASPxClientUtils.iOSPlatform || this.ensureDocumentSizesCorrect())
//            onOrientationChangedFunction();
//        else {
//            window.setTimeout(function () {
//                this.ensureOrientationChanged(onOrientationChangedFunction);
//            }.aspxBind(this), 100);
//        }
//    }
//    onEventAttachingToDocument(eventName, func) {
//        if (ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
//            if (!this.documentTouchHandlers[eventName])
//                this.documentTouchHandlers[eventName] = [];
//            this.documentTouchHandlers[eventName].push(func);
//            return this.documentEventAttachingAllowed;
//        }
//        return true;
//    }
//    onEventDettachedFromDocument(eventName, func) {
//        if (ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
//            var handlers = this.documentTouchHandlers[eventName];
//            if (handlers)
//                ASPx.Data.ArrayRemove(handlers, func);
//        }
//    }
//    processDocumentTouchEventHandlers(proc) {
//        var touchEventNames = ["touchstart", "touchend", "touchmove", "gesturestart", "gestureend"];
//        for (var i = 0; i < touchEventNames.length; i++) {
//            var eventName = touchEventNames[i];
//            var handlers = this.documentTouchHandlers[eventName];
//            if (handlers) {
//                for (var j = 0; j < handlers.length; j++) {
//                    proc(eventName, handlers[j]);
//                }
//            }
//        }
//    }
//    removeDocumentTouchEventHandlers() {
//        if (ASPx.Browser.MacOSMobilePlatform) {
//            this.documentEventAttachingAllowed = false;
//            this.processDocumentTouchEventHandlers(ASPx.Evt.DetachEventFromDocumentCore);
//        }
//    }
//    restoreDocumentTouchEventHandlers () {
//        if (ASPx.Browser.MacOSMobilePlatform) {
//            this.documentEventAttachingAllowed = true;
//            this.processDocumentTouchEventHandlers(ASPx.Evt.AttachEventToDocumentCore);
//        }
//    }
//    IsNativeScrolling() {
//        return TouchUIHelper.nativeScrollingSupported() && TouchUIHelper.isNativeScrollingAllowed;
//    }
//    pointerEnabled: !!(window.PointerEvent || window.MSPointerEvent);
//    pointerDownEventName: window.PointerEvent ? "pointerdown" : "MSPointerDown",
//            pointerUpEventName: window.PointerEvent ? "pointerup" : "MSPointerUp",
//                pointerCancelEventName: window.PointerEvent ? "pointercancel" : "MSPointerCancel",
//                    pointerMoveEventName: window.PointerEvent ? "pointermove" : "MSPointerMove",
//                        pointerOverEventName: window.PointerEvent ? "pointerover" : "MSPointerOver",
//                            pointerOutEventName: window.PointerEvent ? "pointerout" : "MSPointerOut",
//                                pointerType: {
//        Touch: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 2 : "touch",
//            Pen: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 3 : "pen",
//                Mouse: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 4 : "mouse"
//    }
//    msGestureEnabled: !!(window.PointerEvent || window.MSPointerEvent) && typeof (MSGesture) != "undefined";
//    msTouchCreateGesturesWrapper(element, onTap) {
//        if (!TouchUIHelper.msGestureEnabled)
//            return;
//        var gesture = new MSGesture();
//        gesture.target = element;
//        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerDownEventName, function (evt) {
//            gesture.addPointer(evt.pointerId);
//        });
//        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerUpEventName, function (evt) {
//            gesture.stop();
//        });
//        if (onTap)
//            ASPx.Evt.AttachEventToElement(element, "MSGestureTap", onTap);
//        return gesture;
//    }
//}


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsCalculatorBase = /** @class */ (function () {
    function ConnectorPointsCalculatorBase(connector) {
        this.connector = connector;
    }
    return ConnectorPointsCalculatorBase;
}());
exports.ConnectorPointsCalculatorBase = ConnectorPointsCalculatorBase;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var FilterPrimitive_1 = __webpack_require__(113);
var Model_1 = __webpack_require__(21);
var TextFilterPrimitive = /** @class */ (function (_super) {
    __extends(TextFilterPrimitive, _super);
    function TextFilterPrimitive(id, useFloodColor, x, y, width, height) {
        if (useFloodColor === void 0) { useFloodColor = true; }
        if (x === void 0) { x = "-0.05"; }
        if (y === void 0) { y = "-0.05"; }
        if (width === void 0) { width = "1.1"; }
        if (height === void 0) { height = "1.1"; }
        var _this = _super.call(this, id, x, y, width, height) || this;
        _this.id = id;
        _this.useFloodColor = useFloodColor;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    TextFilterPrimitive.prototype.createChildElements = function (parent) {
        var floodColor = this.getFloodColor(parent.parentElement);
        var feFlood = document.createElementNS(RenderManager_1.svgNS, "feFlood");
        if (this.useFloodColor) {
            feFlood.setAttribute("flood-color", floodColor);
            feFlood.setAttribute("class", "text-filter-flood");
            if (floodColor !== Model_1.DiagramModel.defaultPageColor)
                feFlood.style.setProperty("flood-color", floodColor);
        }
        parent.appendChild(feFlood);
        var feComposite = document.createElementNS(RenderManager_1.svgNS, "feComposite");
        feComposite.setAttribute("in", "SourceGraphic");
        feComposite.setAttribute("operator", "atop");
        parent.appendChild(feComposite);
    };
    TextFilterPrimitive.prototype.getFloodColor = function (element) {
        while (element != null) {
            if (element.tagName == "BODY" || element.nodeName == "#document")
                break;
            if (element.tagName === "svg" && element.style.backgroundColor !== "")
                return element.style.backgroundColor;
            element = element.parentNode;
        }
        return Model_1.DiagramModel.defaultPageColor;
    };
    return TextFilterPrimitive;
}(FilterPrimitive_1.FilterPrimitive));
exports.TextFilterPrimitive = TextFilterPrimitive;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var Connector_1 = __webpack_require__(5);
var DeleteConnectionHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectionHistoryItem, _super);
    function DeleteConnectionHistoryItem(connector, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.position = position;
        _this.itemKey = connector.getExtremeItem(_this.position).key;
        return _this;
    }
    DeleteConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.deleteConnection(connector, this.position);
    };
    DeleteConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.oldConnectionPointIndex, this.position);
    };
    return DeleteConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectionHistoryItem = DeleteConnectionHistoryItem;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var DeleteShapeHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteShapeHistoryItem, _super);
    function DeleteShapeHistoryItem(shapeKey) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        return _this;
    }
    DeleteShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.shape = shape.clone();
        manipulator.deleteShape(shape);
    };
    DeleteShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addShape(this.shape, this.shape.key);
    };
    return DeleteShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteShapeHistoryItem = DeleteShapeHistoryItem;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var DiamondShapeDescription = /** @class */ (function (_super) {
    __extends(DiamondShapeDescription, _super);
    function DiamondShapeDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Diamond"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = ShapeDescription_1.ShapeDefaultSize.clone(); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(DiamondShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Diamond; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiamondShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    DiamondShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    return DiamondShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.DiamondShapeDescription = DiamondShapeDescription;


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var ShapeType_1 = __webpack_require__(1);
var TextShapeDescription = /** @class */ (function (_super) {
    __extends(TextShapeDescription, _super);
    function TextShapeDescription() {
        return _super.call(this, "Text", "Text", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.5)) || this;
    }
    Object.defineProperty(TextShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Text; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TextShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    TextShapeDescription.prototype.createPrimitives = function (shape, forToolbox) {
        return this.createTextPrimitives(shape, forToolbox);
    };
    return TextShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.TextShapeDescription = TextShapeDescription;


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(57);
var DiagramItem_1 = __webpack_require__(3);
var PentagonShapeDescription = /** @class */ (function (_super) {
    __extends(PentagonShapeDescription, _super);
    function PentagonShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Pentagon"; }
        if (defaultText === void 0) { defaultText = ""; }
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultRatio = _this.defaultSize.height / _this.defaultSize.width;
        return _this;
    }
    Object.defineProperty(PentagonShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Pentagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PentagonShapeDescription.prototype, "angleCount", {
        get: function () { return 5; },
        enumerable: true,
        configurable: true
    });
    PentagonShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var ratio = height / width / this.defaultRatio;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var px = (height - py) / Math.tan(angle) / ratio;
        var x1 = left + px;
        var x2 = right - px;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    PentagonShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.East || side === DiagramItem_1.ConnectionPointSide.West) {
            var rect = shape.rectangle;
            var top_1 = rect.top, width = rect.width, height = rect.height;
            var ratio = height / width / this.defaultRatio;
            var angle = Math.PI - this.angle;
            var py = width / 2 * Math.tan(angle / 2) * ratio;
            var y = top_1 + py;
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.y = y;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.y = y;
        }
    };
    PentagonShapeDescription.prototype.calculateHeight = function (width) {
        var angle = Math.PI - this.angle;
        var h1 = width / 2 * Math.tan(angle / 2);
        var side = width / 2 / Math.cos(angle / 2);
        var h2 = side * Math.sin(angle);
        return h1 + h2;
    };
    return PentagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.PentagonShapeDescription = PentagonShapeDescription;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(57);
var HexagonShapeDescription = /** @class */ (function (_super) {
    __extends(HexagonShapeDescription, _super);
    function HexagonShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Hexagon"; }
        if (defaultText === void 0) { defaultText = ""; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(HexagonShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Hexagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(HexagonShapeDescription.prototype, "angleCount", {
        get: function () { return 6; },
        enumerable: true,
        configurable: true
    });
    HexagonShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        var x1 = left + (width - sideX) / 2;
        var x2 = x1 + sideX;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    HexagonShapeDescription.prototype.calculateHeight = function (width) {
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        return 2 * sideX * Math.sin(angle);
    };
    return HexagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.HexagonShapeDescription = HexagonShapeDescription;


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var ConnectionPoint_1 = __webpack_require__(32);
var DiagramItem_1 = __webpack_require__(3);
var TriangleShapeDescription = /** @class */ (function (_super) {
    __extends(TriangleShapeDescription, _super);
    function TriangleShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Triangle"; }
        if (defaultText === void 0) { defaultText = ""; }
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultSize.height = _this.calculateHeight(ShapeDescription_1.ShapeDefaultDimension);
        return _this;
    }
    Object.defineProperty(TriangleShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Triangle; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TriangleShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    TriangleShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(0.75, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0.25, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    TriangleShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.center.x, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    TriangleShapeDescription.prototype.calculateHeight = function (width) {
        return Math.sqrt(Math.pow(width, 2) - Math.pow(width / 2, 2));
    };
    return TriangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.TriangleShapeDescription = TriangleShapeDescription;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(3);
var DocumentShapeDescription = /** @class */ (function (_super) {
    __extends(DocumentShapeDescription, _super);
    function DocumentShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Document"; }
        if (defaultText === void 0) { defaultText = "Document"; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(DocumentShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Document; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocumentShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    DocumentShapeDescription.prototype.createPrimitives = function (shape) {
        var primitives = [];
        return primitives
            .concat(this.createDocumentPrimitives(shape.rectangle, shape.style))
            .concat(this.createTextPrimitives(shape));
    };
    DocumentShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DocumentShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    DocumentShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * DocumentShapeDescription.curveOffsetRatio;
    };
    DocumentShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.resize(0, -rect.height * DocumentShapeDescription.curveOffsetRatio);
    };
    DocumentShapeDescription.curveOffsetRatio = 0.1;
    return DocumentShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DocumentShapeDescription = DocumentShapeDescription;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var NodeLayout_1 = __webpack_require__(39);
var GraphLayout = /** @class */ (function () {
    function GraphLayout() {
        this.nodeKeys = [];
        this.nodeToLayout = {};
        this.edgeToPosition = {};
    }
    GraphLayout.prototype.forEachNode = function (callback) {
        var _this = this;
        this.nodeKeys.forEach(function (nk) { return callback(_this.nodeToLayout[nk], nk); });
    };
    GraphLayout.prototype.addNode = function (nodeLayout) {
        if (this.nodeToLayout[nodeLayout.key])
            throw Error("Node layout is already registered");
        this.nodeKeys.push(nodeLayout.key);
        this.nodeToLayout[nodeLayout.key] = nodeLayout;
    };
    GraphLayout.prototype.addEdge = function (edgeLayout) {
        if (this.edgeToPosition[edgeLayout.key])
            throw Error("Edge layout is already registered");
        this.edgeToPosition[edgeLayout.key] = edgeLayout;
    };
    GraphLayout.prototype.getRectangle = function (includeMargins) {
        var _this = this;
        return Utils_1.GeometryUtils.getCommonRectangle(this.nodeKeys.map(function (nk) { return _this.nodeToLayout[nk].rectangle; }));
    };
    GraphLayout.prototype.offsetNodes = function (deltaX, deltaY) {
        var _this = this;
        if (deltaX === void 0) { deltaX = 0; }
        if (deltaY === void 0) { deltaY = 0; }
        var layout = new GraphLayout();
        this.nodeKeys.forEach(function (nk) {
            var nl = _this.nodeToLayout[nk];
            layout.addNode(new NodeLayout_1.NodeLayout(nl.info, nl.position.offset(deltaX, deltaY)));
        });
        layout.copyEdges(this);
        return layout;
    };
    GraphLayout.prototype.extend = function (layout) {
        var _this = this;
        layout.forEachNode(function (nl) { return _this.addNode(nl); });
        this.copyEdges(layout);
    };
    GraphLayout.prototype.copyEdges = function (source) {
        var _this = this;
        Object.keys(source.edgeToPosition).forEach(function (e) {
            var edge = source.edgeToPosition[e];
            _this.addEdge(new NodeLayout_1.EdgeLayout(edge.key, edge.beginIndex, edge.endIndex));
        });
    };
    return GraphLayout;
}());
exports.GraphLayout = GraphLayout;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var LayoutSettings_1 = __webpack_require__(18);
var LayoutBuilder = /** @class */ (function () {
    function LayoutBuilder(settings, graph) {
        this.settings = settings;
        this.graph = graph;
    }
    LayoutBuilder.prototype.getBreadthNodeSizeCore = function (node) {
        return this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical ?
            (node.size.width + node.margin.left + node.margin.right) :
            (node.size.height + node.margin.top + node.margin.bottom);
    };
    LayoutBuilder.prototype.getDepthNodeSizeCore = function (node) {
        return this.settings.orientation === LayoutSettings_1.OrientationKind.Horizontal ?
            (node.size.width + node.margin.left + node.margin.right) :
            (node.size.height + node.margin.top + node.margin.bottom);
    };
    LayoutBuilder.prototype.chooseDirectionValue = function (near, far) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? near : far;
    };
    LayoutBuilder.prototype.getDirectionValue = function (value) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? value : -value;
    };
    LayoutBuilder.prototype.getComponentOffset = function (graphLayout) {
        var rect = graphLayout.getRectangle(true);
        var offset = this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical ? rect.width : rect.height;
        return offset + this.settings.componentSpacing;
    };
    LayoutBuilder.prototype.setComponentOffset = function (graphLayout, offset) {
        return this.settings.orientation === LayoutSettings_1.OrientationKind.Vertical ?
            graphLayout.offsetNodes(offset) :
            graphLayout.offsetNodes(0, offset);
    };
    return LayoutBuilder;
}());
exports.LayoutBuilder = LayoutBuilder;


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var CloneHistoryItem = /** @class */ (function (_super) {
    __extends(CloneHistoryItem, _super);
    function CloneHistoryItem(item) {
        var _this = _super.call(this) || this;
        _this.item = item;
        return _this;
    }
    CloneHistoryItem.prototype.redo = function (manipulator) {
        this.clearConnections(this.item);
        this.addItem(this.item, manipulator);
    };
    CloneHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.item.key);
        this.clearConnections(item);
        this.deleteItem(item, manipulator);
    };
    return CloneHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.CloneHistoryItem = CloneHistoryItem;


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Model_1 = __webpack_require__(21);
var Shape_1 = __webpack_require__(9);
var Utils_1 = __webpack_require__(0);
var ShapeDescriptionManager_1 = __webpack_require__(30);
var Connector_1 = __webpack_require__(5);
var ShapeType_1 = __webpack_require__(1);
var Importer = /** @class */ (function () {
    function Importer() {
    }
    Importer.import = function (json) {
        var model = new Model_1.DiagramModel();
        var obj = this.parseJSON(json);
        this.importPageSettings(model, obj["page"]);
        var shapes = this.importShapes(obj["shapes"]);
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            if (model.findItem(shape.key))
                throw Error("Item key is duplicated");
            model.pushItem(shape);
        }
        var connectors = this.importConnectors(obj["connectors"]);
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            connector.endItem = model.findItem(connector["endItemKey"]) || undefined;
            delete connector["endItemKey"];
            connector.beginItem = model.findItem(connector["beginItemKey"]) || undefined;
            delete connector["beginItemKey"];
            if (model.findItem(connector.key))
                throw Error("Item key is duplicated");
            model.pushItem(connector);
            this.updateConnections(connector);
        }
        return model;
    };
    Importer.importItems = function (json, model) {
        var result = [];
        var obj = this.parseJSON(json);
        var itemHash = {};
        var shapes = this.importShapes(obj["shapes"]);
        var key;
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            var oldKey = shape.key;
            key = model.getNextKey(key);
            shape.key = key;
            itemHash[oldKey] = shape;
            result.push(shape);
        }
        var connectors = this.importConnectors(obj["connectors"]);
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            var oldKey = connector.key;
            key = model.getNextKey(key);
            connector.key = key;
            itemHash[oldKey] = connector;
            var endItemKey = connector["endItemKey"];
            connector.endItem = itemHash[endItemKey];
            delete connector["endItemKey"];
            var beginItemKey = connector["beginItemKey"];
            connector.beginItem = itemHash[beginItemKey];
            delete connector["beginItemKey"];
            result.push(connector);
            this.updateConnections(connector);
        }
        return result;
    };
    Importer.importItemsData = function (json, model) {
        var obj = this.parseJSON(json);
        var shapes = this.importShapes(obj["shapes"]);
        for (var i = 0; i < shapes.length; i++) {
            var srcShape = shapes[i];
            var destShape = void 0;
            if (srcShape.dataKey !== undefined)
                destShape = model.findShapeByDataKey(srcShape.dataKey);
            if (!destShape)
                destShape = model.findShape(srcShape.key);
            if (destShape) {
                destShape.dataKey = srcShape.dataKey;
                destShape.locked = srcShape.locked;
                destShape.position = srcShape.position.clone();
                destShape.size = srcShape.size.clone();
                destShape.parameters = srcShape.parameters.clone();
                destShape.style = srcShape.style.clone();
                destShape.styleText = srcShape.styleText.clone();
                destShape.zIndex = srcShape.zIndex;
            }
        }
        var connectors = this.importConnectors(obj["connectors"]);
        for (var i = 0; i < connectors.length; i++) {
            var srcConnector = connectors[i];
            var destConnector = void 0;
            if (srcConnector.dataKey !== undefined)
                destConnector = model.findConnectorByDataKey(srcConnector.dataKey);
            if (!destConnector)
                destConnector = model.findConnector(srcConnector.key);
            if (destConnector) {
                destConnector.dataKey = srcConnector.dataKey;
                destConnector.locked = srcConnector.locked;
                destConnector.points = srcConnector.points.slice();
                destConnector.properties = srcConnector.properties.clone();
                destConnector.style = srcConnector.style.clone();
                destConnector.styleText = srcConnector.styleText.clone();
                destConnector.zIndex = srcConnector.zIndex;
            }
        }
    };
    Importer.canImport = function (json) {
        var obj = this.parseJSON(json);
        return Array.isArray(obj["shapes"]) || Array.isArray(obj["connectors"]);
    };
    Importer.importPageSettings = function (model, pageObj) {
        if (!pageObj)
            return;
        this.assert(pageObj["width"], "number");
        this.assert(pageObj["height"], "number");
        if (typeof pageObj["width"] === "number")
            model.size.width = pageObj["width"];
        if (typeof pageObj["height"] === "number")
            model.size.height = pageObj["height"];
        if (typeof pageObj["pageColor"] === "string")
            model.pageColor = pageObj["pageColor"];
        if (typeof pageObj["pageWidth"] === "number")
            model.pageSize.width = pageObj["pageWidth"];
        if (typeof pageObj["pageHeight"] === "number")
            model.pageSize.height = pageObj["pageHeight"];
        if (typeof pageObj["pageLandscape"] === "boolean")
            model.pageLandscape = pageObj["pageLandscape"];
        if (typeof pageObj["gridSize"] === "number")
            model.gridSize = pageObj["gridSize"];
        if (typeof pageObj["showGrid"] === "boolean")
            model.showGrid = pageObj["showGrid"];
        if (typeof pageObj["snapToGrid"] === "boolean")
            model.snapToGrid = pageObj["snapToGrid"];
        if (typeof pageObj["units"] === "number")
            model.units = pageObj["units"];
    };
    Importer.importShapes = function (shapesObj) {
        var result = [];
        if (!shapesObj)
            return result;
        if (!Array.isArray(shapesObj))
            throw Error("Invalid Format");
        for (var i = 0; i < shapesObj.length; i++) {
            var shapeObj = shapesObj[i];
            result.push(this.importShape(shapeObj));
        }
        return result;
    };
    Importer.importShape = function (shapeObj) {
        this.assert(shapeObj["key"], "string");
        this.assert(shapeObj["x"], "number");
        this.assert(shapeObj["y"], "number");
        var position = new Utils_1.Point(shapeObj["x"], shapeObj["y"]);
        this.assert(shapeObj["type"], "number");
        var shapeType = shapeObj["type"];
        var description = ShapeDescriptionManager_1.ShapeDescriptionManager.get(shapeType);
        var shape = new Shape_1.Shape(description || ShapeDescriptionManager_1.ShapeDescriptionManager.get(ShapeType_1.ShapeType.Rectangle), position);
        shape.key = shapeObj["key"];
        if (typeof shapeObj["dataKey"] === "string")
            shape.dataKey = shapeObj["dataKey"];
        if (typeof shapeObj["locked"] === "boolean")
            shape.locked = shapeObj["locked"];
        if (typeof shapeObj["width"] === "number")
            shape.size.width = shapeObj["width"];
        if (typeof shapeObj["height"] === "number")
            shape.size.height = shapeObj["height"];
        if (typeof shapeObj["text"] === "string")
            shape.text = shapeObj["text"];
        if (shapeObj["parameters"]) {
            shape.parameters.fromObject(shapeObj["parameters"]);
            shape.description.normalizeParameters(shape, shape.parameters);
        }
        if (shapeObj["style"])
            shape.style.fromObject(shapeObj["style"]);
        if (shapeObj["styleText"])
            shape.styleText.fromObject(shapeObj["styleText"]);
        if (typeof shapeObj["zIndex"] === "number")
            shape.zIndex = shapeObj["zIndex"];
        return shape;
    };
    Importer.importConnectors = function (connectorsObj) {
        var result = [];
        if (!connectorsObj)
            return result;
        if (!Array.isArray(connectorsObj))
            throw Error("Invalid Format");
        for (var i = 0; i < connectorsObj.length; i++) {
            var shapeObj = connectorsObj[i];
            result.push(this.importConnector(shapeObj));
        }
        return result;
    };
    Importer.importConnector = function (connectorObj) {
        var _this = this;
        this.assert(connectorObj["key"], "string");
        if (!Array.isArray(connectorObj["points"]))
            throw Error("Invalid Format");
        var points = connectorObj["points"].map(function (pt) {
            _this.assert(pt["x"], "number");
            _this.assert(pt["y"], "number");
            return new Utils_1.Point(pt["x"], pt["y"]);
        });
        var connector = new Connector_1.Connector(points);
        connector.key = connectorObj["key"];
        if (typeof connectorObj["dataKey"] === "string")
            connector.dataKey = connectorObj["dataKey"];
        if (typeof connectorObj["locked"] === "boolean")
            connector.locked = connectorObj["locked"];
        connector.endConnectionPointIndex = typeof connectorObj["endConnectionPointIndex"] === "number" ? connectorObj["endConnectionPointIndex"] : -1;
        connector.beginConnectionPointIndex = typeof connectorObj["beginConnectionPointIndex"] === "number" ? connectorObj["beginConnectionPointIndex"] : -1;
        if (connectorObj["endItemKey"] !== undefined)
            this.assert(connectorObj["endItemKey"], "string");
        if (connectorObj["beginItemKey"] !== undefined)
            this.assert(connectorObj["beginItemKey"], "string");
        connector["endItemKey"] = connectorObj["endItemKey"];
        connector["beginItemKey"] = connectorObj["beginItemKey"];
        if (connectorObj["texts"])
            connector.texts.fromObject(connectorObj["texts"]);
        if (connectorObj["properties"])
            connector.properties.fromObject(connectorObj["properties"]);
        if (connectorObj["style"])
            connector.style.fromObject(connectorObj["style"]);
        if (connectorObj["styleText"])
            connector.styleText.fromObject(connectorObj["styleText"]);
        if (typeof connectorObj["zIndex"] === "number")
            connector.zIndex = connectorObj["zIndex"];
        return connector;
    };
    Importer.updateConnections = function (connector) {
        if (connector.endItem) {
            connector.endItem.attachedConnectors.push(connector);
            connector.points[connector.points.length - 1] = connector.endItem.getConnectionPoint(connector.endConnectionPointIndex, connector.points[connector.points.length - 2]);
        }
        if (connector.beginItem) {
            connector.beginItem.attachedConnectors.push(connector);
            connector.points[0] = connector.beginItem.getConnectionPoint(connector.beginConnectionPointIndex, connector.points[1]);
        }
    };
    Importer.parseJSON = function (json) {
        if (!json || json === "")
            return {};
        try {
            return JSON.parse(json);
        }
        catch (_a) {
            return {};
        }
    };
    Importer.assert = function (value, type) {
        if (value === undefined)
            throw Error("Invalid Format");
        if (type !== undefined && typeof value !== type)
            throw Error("Invalid Format");
    };
    return Importer;
}());
exports.Importer = Importer;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var StylePropertyCommandBase = /** @class */ (function (_super) {
    __extends(StylePropertyCommandBase, _super);
    function StylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    StylePropertyCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true, this.getStateValue());
    };
    return StylePropertyCommandBase;
}(CommandBase_1.CommandBase));
exports.StylePropertyCommandBase = StylePropertyCommandBase;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeStyleHistoryItemBase = /** @class */ (function (_super) {
    __extends(ChangeStyleHistoryItemBase, _super);
    function ChangeStyleHistoryItemBase(itemKey, styleProperty, styleValue) {
        var _this = _super.call(this) || this;
        _this.itemKey = itemKey;
        _this.styleProperty = styleProperty;
        _this.styleValue = styleValue;
        return _this;
    }
    ChangeStyleHistoryItemBase.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItemBase.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItemBase;
}(HistoryItem_1.HistoryItem));
exports.ChangeStyleHistoryItemBase = ChangeStyleHistoryItemBase;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StylePropertyCommandBase_1 = __webpack_require__(85);
var ChangeStylePropertyCommandBase = /** @class */ (function (_super) {
    __extends(ChangeStylePropertyCommandBase, _super);
    function ChangeStylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var styleProperty = _this.getStyleProperty();
            _this.control.history.addAndRedo(_this.createHistoryItem(item, styleProperty, parameter));
        });
        this.updateInputPosition(parameter);
        this.control.history.endTransaction();
        return true;
    };
    return ChangeStylePropertyCommandBase;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ChangeStylePropertyCommandBase = ChangeStylePropertyCommandBase;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommandBase_1 = __webpack_require__(87);
var ChangeStyleHistoryItem_1 = __webpack_require__(63);
var ChangeStylePropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeStylePropertyCommand, _super);
    function ChangeStylePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommand.prototype.getStateValue = function () {
        return this.control.selection.inputPosition.getStylePropertyValue(this.getStyleProperty());
    };
    ChangeStylePropertyCommand.prototype.getStyleObj = function (item) {
        return item.style;
    };
    ChangeStylePropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStylePropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setStylePropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStylePropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStylePropertyCommand = ChangeStylePropertyCommand;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ImportDataCommandBase = /** @class */ (function (_super) {
    __extends(ImportDataCommandBase, _super);
    function ImportDataCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportDataCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    ImportDataCommandBase.prototype.executeCore = function (state, parameter) {
        if (!parameter || !Array.isArray(parameter.nodeDataSource))
            throw Error("Format exception");
        this.performImportData(parameter);
        if (this.control.renderManager)
            this.control.renderManager.onWindowResize(null);
        return true;
    };
    ImportDataCommandBase.prototype.createItems = function (dataSource, layoutType) {
        dataSource.createModelItems(this.control.history, this.control.model, this.control.selection, layoutType);
    };
    return ImportDataCommandBase;
}(CommandBase_1.CommandBase));
exports.ImportDataCommandBase = ImportDataCommandBase;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(91);
var ChangeConnectorPropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorPropertyCommand, _super);
    function ChangeConnectorPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorPropertyCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true, this.getStateValue());
    };
    ChangeConnectorPropertyCommand.prototype.getStateValue = function () {
        return this.control.selection.inputPosition.getConnectorPropertyValue(this.getPropertyName());
    };
    ChangeConnectorPropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var connectors = this.control.selection.getSelectedConnectors();
        connectors.forEach(function (connector) {
            var propertyName = _this.getPropertyName();
            _this.control.history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, propertyName, parameter));
        });
        this.control.selection.inputPosition.setConnectorPropertyValue(this.getPropertyName(), parameter);
        this.control.history.endTransaction();
        return true;
    };
    return ChangeConnectorPropertyCommand;
}(CommandBase_1.CommandBase));
exports.ChangeConnectorPropertyCommand = ChangeConnectorPropertyCommand;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeConnectorPropertyHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeConnectorPropertyHistoryItem, _super);
    function ChangeConnectorPropertyHistoryItem(connectorKey, propertyName, value) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.propertyName = propertyName;
        _this.value = value;
        return _this;
    }
    ChangeConnectorPropertyHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldValue = connector.properties[this.propertyName];
        manipulator.changeConnectorProperty(connector, this.propertyName, this.value);
    };
    ChangeConnectorPropertyHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorProperty(connector, this.propertyName, this.oldValue);
    };
    return ChangeConnectorPropertyHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorPropertyHistoryItem = ChangeConnectorPropertyHistoryItem;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ExtensionLineType;
(function (ExtensionLineType) {
    ExtensionLineType[ExtensionLineType["LeftToLeftAbove"] = 0] = "LeftToLeftAbove";
    ExtensionLineType[ExtensionLineType["LeftToLeftBelow"] = 1] = "LeftToLeftBelow";
    ExtensionLineType[ExtensionLineType["RightToRightAbove"] = 2] = "RightToRightAbove";
    ExtensionLineType[ExtensionLineType["RightToRightBelow"] = 3] = "RightToRightBelow";
    ExtensionLineType[ExtensionLineType["LeftToRightAbove"] = 4] = "LeftToRightAbove";
    ExtensionLineType[ExtensionLineType["LeftToRightBelow"] = 5] = "LeftToRightBelow";
    ExtensionLineType[ExtensionLineType["RightToLeftAbove"] = 6] = "RightToLeftAbove";
    ExtensionLineType[ExtensionLineType["RightToLeftBelow"] = 7] = "RightToLeftBelow";
    ExtensionLineType[ExtensionLineType["TopToTopBefore"] = 8] = "TopToTopBefore";
    ExtensionLineType[ExtensionLineType["TopToTopAfter"] = 9] = "TopToTopAfter";
    ExtensionLineType[ExtensionLineType["BottomToBottomBefore"] = 10] = "BottomToBottomBefore";
    ExtensionLineType[ExtensionLineType["BottomToBottomAfter"] = 11] = "BottomToBottomAfter";
    ExtensionLineType[ExtensionLineType["TopToBottomBefore"] = 12] = "TopToBottomBefore";
    ExtensionLineType[ExtensionLineType["TopToBottomAfter"] = 13] = "TopToBottomAfter";
    ExtensionLineType[ExtensionLineType["BottomToTopBefore"] = 14] = "BottomToTopBefore";
    ExtensionLineType[ExtensionLineType["BottomToTopAfter"] = 15] = "BottomToTopAfter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterAbove"] = 16] = "HorizontalCenterAbove";
    ExtensionLineType[ExtensionLineType["HorizontalCenterBelow"] = 17] = "HorizontalCenterBelow";
    ExtensionLineType[ExtensionLineType["VerticalCenterBefore"] = 18] = "VerticalCenterBefore";
    ExtensionLineType[ExtensionLineType["VerticalCenterAfter"] = 19] = "VerticalCenterAfter";
    ExtensionLineType[ExtensionLineType["VerticalCenterToPageCenter"] = 20] = "VerticalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterToPageCenter"] = 21] = "HorizontalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["LeftToPageCenter"] = 22] = "LeftToPageCenter";
    ExtensionLineType[ExtensionLineType["RightToPageCenter"] = 23] = "RightToPageCenter";
    ExtensionLineType[ExtensionLineType["TopToPageCenter"] = 24] = "TopToPageCenter";
    ExtensionLineType[ExtensionLineType["BottomToPageCenter"] = 25] = "BottomToPageCenter";
})(ExtensionLineType = exports.ExtensionLineType || (exports.ExtensionLineType = {}));
var ExtensionLine = /** @class */ (function () {
    function ExtensionLine(type, segment, text) {
        this.type = type;
        this.segment = segment;
        this.text = text;
    }
    return ExtensionLine;
}());
exports.ExtensionLine = ExtensionLine;
var ExtensionLinesVisualizer = /** @class */ (function () {
    function ExtensionLinesVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
        this.lines = [];
        this.lineIndexByType = {};
    }
    ExtensionLinesVisualizer.prototype.addSegment = function (type, segment, text) {
        var curIndex = this.lineIndexByType[type];
        if (curIndex === undefined) {
            var line = new ExtensionLine(type, segment, text);
            var index = this.lines.push(line);
            this.lineIndexByType[line.type] = index - 1;
            this.raiseShow();
        }
        else if (segment.distance < this.lines[curIndex].segment.distance) {
            var line = new ExtensionLine(type, segment, text);
            this.lines.splice(curIndex, 1, line);
            this.raiseShow();
        }
    };
    ExtensionLinesVisualizer.prototype.update = function () {
        this.raiseShow();
    };
    ExtensionLinesVisualizer.prototype.reset = function () {
        if (this.lines.length) {
            this.lines = [];
            this.lineIndexByType = {};
            this.raiseHide();
        }
    };
    ExtensionLinesVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.NotifyExtensionLinesShow(_this.lines); });
    };
    ExtensionLinesVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.NotifyExtensionLinesHide(); });
    };
    return ExtensionLinesVisualizer;
}());
exports.ExtensionLinesVisualizer = ExtensionLinesVisualizer;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeZindexHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeZindexHistoryItem, _super);
    function ChangeZindexHistoryItem(item, zIndex) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.zIndex = zIndex;
        return _this;
    }
    ChangeZindexHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldZIndex = item.zIndex;
        manipulator.changeZIndex(item, this.zIndex);
    };
    ChangeZindexHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeZIndex(item, this.oldZIndex);
    };
    return ChangeZindexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeZindexHistoryItem = ChangeZindexHistoryItem;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ChangeLockedHistoryItem_1 = __webpack_require__(206);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var ChangeLockedCommand = /** @class */ (function (_super) {
    __extends(ChangeLockedCommand, _super);
    function ChangeLockedCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeLockedCommand.prototype.getState = function () {
        var _this = this;
        var items = this.control.selection.getSelectedItems(true);
        var enabled = false;
        items.forEach(function (item) { if (item.locked !== _this.getLockState())
            enabled = true; });
        return new CommandStates_1.SimpleCommandState(enabled);
    };
    ChangeLockedCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems(true);
        items.forEach(function (item) {
            _this.control.history.addAndRedo(new ChangeLockedHistoryItem_1.ChangeLockedHistoryItem(item, _this.getLockState()));
        });
        this.control.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.control.selection, this.control.selection.getKeys())); // Update canvas
        this.control.history.endTransaction();
        return true;
    };
    return ChangeLockedCommand;
}(CommandBase_1.CommandBase));
exports.ChangeLockedCommand = ChangeLockedCommand;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var ModelUtils_1 = __webpack_require__(8);
var MouseHandlerMoveShapeStateBase = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveShapeStateBase, _super);
    function MouseHandlerMoveShapeStateBase(handler, history, model, selection) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        return _this;
    }
    MouseHandlerMoveShapeStateBase.prototype.finish = function () {
        this.handler.resetExtensionLines();
        _super.prototype.finish.call(this);
    };
    MouseHandlerMoveShapeStateBase.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
        this.shapes = this.selection.getSelectedShapes();
        this.connectors = this.selection.getSelectedConnectors();
        if (this.shapes.length === 0) {
            this.handler.switchToDefaultState();
            return;
        }
        this.startShapePositions = this.shapes.map(function (shape) { return shape.position.clone(); });
        this.startConnectorPoints = this.connectors.map(function (c) { return c.points.map(function (p) { return p.clone(); }); });
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveShapeStateBase.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        this.handler.setExtensionLines(this.selection.getSelectedShapes());
    };
    MouseHandlerMoveShapeStateBase.prototype.onApplyChanges = function (evt) {
        var _this = this;
        this.shapes.forEach(function (shape, index) {
            var pos = _this.getPosition(evt, _this.startShapePositions[index]);
            ModelUtils_1.ModelUtils.setShapePosition(_this.history, _this.model, shape.key, pos, _this.history.addOrModifyAndRedo);
            shape.attachedConnectors.forEach(function (connector) {
                ModelUtils_1.ModelUtils.removeConnectorIntermediatePoints(_this.history, connector);
                ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(_this.history, connector, _this.history.addOrModifyAndRedo);
            });
        });
        this.connectors.forEach(function (connector, index) {
            var delta = _this.startShapePositions[0].offset(-_this.shapes[0].position.x, -_this.shapes[0].position.y);
            if (delta.x !== 0 || delta.y !== 0) {
                var startPtIndex = connector.beginItem ? 1 : 0;
                var endPtIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
                for (var i = startPtIndex; i <= endPtIndex; i++)
                    ModelUtils_1.ModelUtils.setConnectorPoint(_this.history, _this.model, connector.key, i, _this.startConnectorPoints[index][i].offset(-delta.x, -delta.y), _this.history.addOrModifyAndRedo);
            }
        });
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveShapeStateBase.prototype.getDraggingElementKeys = function () {
        return this.shapes.map(function (shape) { return shape.key; });
    };
    MouseHandlerMoveShapeStateBase.prototype.getXPosition = function (evt, baseX) {
        return baseX + evt.layoutPoint.x - this.startPoint.x;
    };
    MouseHandlerMoveShapeStateBase.prototype.getYPosition = function (evt, baseY) {
        return baseY + evt.layoutPoint.y - this.startPoint.y;
    };
    MouseHandlerMoveShapeStateBase.prototype.getPosition = function (evt, basePoint) {
        return new Utils_1.Point(this.handler.getSnappedPos(evt, this.getXPosition(evt, basePoint.x)), this.handler.getSnappedPos(evt, this.getYPosition(evt, basePoint.y)));
    };
    return MouseHandlerMoveShapeStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveShapeStateBase = MouseHandlerMoveShapeStateBase;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var Event_1 = __webpack_require__(14);
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var DeleteConnectionHistoryItem_1 = __webpack_require__(73);
var AddConnectionHistoryItem_1 = __webpack_require__(35);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(36);
var ModelUtils_1 = __webpack_require__(8);
var MouseHandlerMoveConnectorPointStateBase = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorPointStateBase, _super);
    function MouseHandlerMoveConnectorPointStateBase(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorPointStateBase.prototype.finish = function () {
        this.handler.resetConnectionTarget();
        this.handler.resetConnectionPoints();
        _super.prototype.finish.call(this);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var item = this.connector.getExtremeItem(this.pointPosition);
        this.handler.setConnectionTarget(item, evt.source.type);
        var pointIndex = this.connector.getExtremeConnectionPointIndex(this.pointPosition);
        if (!item && this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition) !== -1)
            item = this.model.findItem(evt.source.key);
        this.handler.setConnectionPoints(item, evt.source.type, pointIndex);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.layoutPoint);
        if (this.pointPosition !== undefined) {
            var item = this.model.findItem(evt.source.key);
            var connectionPointIndex = -1;
            if (evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint)
                connectionPointIndex = parseInt(evt.source.value);
            if (item && !item.locked && (evt.source.type === Event_1.MouseEventElementType.Shape || evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint) &&
                (this.connector.getExtremeItem(this.oppositePointPosition) !== item ||
                    (connectionPointIndex !== -1 && this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition) !== -1 &&
                        connectionPointIndex !== this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition)))) {
                if (this.connector.getExtremeItem(this.pointPosition) !== item ||
                    this.connector.getExtremeConnectionPointIndex(this.pointPosition) !== connectionPointIndex) {
                    if (this.connector.getExtremeItem(this.pointPosition))
                        this.history.addOrModifyAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
                    this.history.addOrModifyAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, item, connectionPointIndex, this.pointPosition));
                }
                point = item.getConnectionPoint(connectionPointIndex, this.connector.points[this.pointIndex + (this.pointPosition === Connector_1.ConnectorPosition.End ? -1 : 1)]);
                this.handler.setConnectionPointIndex(connectionPointIndex);
            }
            else if (this.connector.getExtremeItem(this.pointPosition)) {
                this.history.addOrModifyAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
            }
        }
        this.history.addOrModifyAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(this.connector.key, this.pointIndex, point));
        ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(this.history, this.connector, this.history.addOrModifyAndRedo);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.connector);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.getDraggingElementKeys = function () {
        return this.connector ? [this.connector.key] : [];
    };
    Object.defineProperty(MouseHandlerMoveConnectorPointStateBase.prototype, "oppositePointPosition", {
        get: function () {
            return this.pointPosition === Connector_1.ConnectorPosition.Begin ? Connector_1.ConnectorPosition.End : Connector_1.ConnectorPosition.Begin;
        },
        enumerable: true,
        configurable: true
    });
    return MouseHandlerMoveConnectorPointStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorPointStateBase = MouseHandlerMoveConnectorPointStateBase;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var AddConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectorPointHistoryItem, _super);
    function AddConnectorPointHistoryItem(connectorKey, pointIndex, point) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.point = point;
        return _this;
    }
    AddConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.addConnectorPoint(connector, this.pointIndex, this.point.clone());
    };
    AddConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnectorPoint(connector, this.pointIndex);
    };
    return AddConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorPointHistoryItem = AddConnectorPointHistoryItem;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeConnectorTextHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeConnectorTextHistoryItem, _super);
    function ChangeConnectorTextHistoryItem(connector, position, text) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.text = text;
        _this.position = position;
        return _this;
    }
    ChangeConnectorTextHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldText = connector.getText(this.position);
        manipulator.changeConnectorText(connector, this.position, this.text);
    };
    ChangeConnectorTextHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorText(connector, this.position, this.oldText);
    };
    return ChangeConnectorTextHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextHistoryItem = ChangeConnectorTextHistoryItem;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Evt_1 = __webpack_require__(49);
var Base_1 = __webpack_require__(19);
var Toolbox = /** @class */ (function () {
    function Toolbox() {
        this.dragStartLimit = 3;
        this.onDragOperation = new Utils_1.EventDispatcher();
    }
    Toolbox.prototype.initialize = function (element, option) {
        element.addEventListener("mousedown", this.onMouseDown.bind(this));
        document.addEventListener("mousemove", this.onMouseMove.bind(this));
        document.addEventListener("mouseup", this.onMouseUp.bind(this));
    };
    Toolbox.prototype.onMouseDown = function (evt) {
        this.mouseDownPoint = new Utils_1.Point(evt.pageX, evt.pageY);
        this.draggingObject = this.createDraggingObject(evt.target);
        if (this.draggingObject) {
            this.draggingObject.evt.onFinishDragging = this.finishDragging.bind(this);
            this.draggingObject.evt.onCaptured = this.capture.bind(this);
            this.onDragStart();
        }
    };
    Toolbox.prototype.onMouseMove = function (evt) {
        if (!Evt_1.Evt.IsLeftButtonPressed(evt))
            this.finishDragging();
        else if (this.draggingObject) {
            if (!this.draggingObject.element &&
                (Math.abs(evt.pageX - this.mouseDownPoint.x) > this.dragStartLimit ||
                    Math.abs(evt.pageY - this.mouseDownPoint.y) > this.dragStartLimit)) {
                this.draggingObject.element = this.createDraggingElement(this.draggingObject);
                if (this.draggingObject.captured !== undefined)
                    this.capture(this.draggingObject.captured, true);
            }
            if (this.draggingObject.element)
                this.updateDraggingElementPosition(evt);
        }
    };
    Toolbox.prototype.onMouseUp = function (evt) {
        this.finishDragging();
    };
    Toolbox.prototype.updateDraggingElementPosition = function (evt) {
        var element = this.draggingObject.element;
        var xPos = (evt.pageX - element.offsetWidth / 2);
        var yPos = (evt.pageY - element.offsetHeight / 2);
        Base_1.SetAbsoluteX(element, xPos);
        Base_1.SetAbsoluteY(element, yPos);
    };
    Toolbox.prototype.finishDragging = function () {
        if (this.draggingObject) {
            this.onDragEnd();
            var element = this.draggingObject.element;
            if (element)
                element.parentNode.removeChild(element);
        }
        delete this.draggingObject;
    };
    Toolbox.prototype.capture = function (captured, forced) {
        if (this.draggingObject && (this.draggingObject.captured !== captured || forced)) {
            this.draggingObject.captured = captured;
            if (this.draggingObject.element)
                this.draggingObject.element.classList.toggle("dxdi-tb-drag-captured", captured);
        }
    };
    Toolbox.prototype.onDragEnd = function () {
        this.onDragOperation.raise("NotifyToolboxDragEnd");
    };
    Toolbox.prototype.onDragStart = function () {
        this.onDragOperation.raise("NotifyToolboxDragStart");
    };
    return Toolbox;
}());
exports.Toolbox = Toolbox;
var ToolboxDraggingObject = /** @class */ (function () {
    function ToolboxDraggingObject(evt) {
        this.evt = evt;
    }
    return ToolboxDraggingObject;
}());
exports.ToolboxDraggingObject = ToolboxDraggingObject;
var DiagramDraggingEvent = /** @class */ (function () {
    function DiagramDraggingEvent() {
    }
    return DiagramDraggingEvent;
}());
exports.DiagramDraggingEvent = DiagramDraggingEvent;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ModelUtils_1 = __webpack_require__(8);
var DeleteCommand = /** @class */ (function (_super) {
    __extends(DeleteCommand, _super);
    function DeleteCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DeleteCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty());
    };
    DeleteCommand.prototype.executeCore = function (state) {
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        return true;
    };
    return DeleteCommand;
}(CommandBase_1.CommandBase));
exports.DeleteCommand = DeleteCommand;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var MoveShapeHistoryItem = /** @class */ (function (_super) {
    __extends(MoveShapeHistoryItem, _super);
    function MoveShapeHistoryItem(shapeKey, position) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        return _this;
    }
    MoveShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        manipulator.moveShape(shape, this.position);
    };
    MoveShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.moveShape(shape, this.oldPosition);
    };
    return MoveShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveShapeHistoryItem = MoveShapeHistoryItem;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base_1 = __webpack_require__(19);
var Data = /** @class */ (function () {
    function Data() {
    }
    Data.ArrayInsert = function (array, element, position) {
        if (0 <= position && position < array.length) {
            for (var i = array.length; i > position; i--)
                array[i] = array[i - 1];
            array[position] = element;
        }
        else
            array.push(element);
    };
    Data.ArrayRemove = function (array, element) {
        var index = Data.ArrayIndexOf(array, element);
        if (index > -1)
            Data.ArrayRemoveAt(array, index);
    };
    Data.ArrayRemoveAt = function (array, index) {
        if (index >= 0 && index < array.length) {
            for (var i = index; i < array.length - 1; i++)
                array[i] = array[i + 1];
            array.pop();
        }
    };
    Data.ArrayClear = function (array) {
        while (array.length > 0)
            array.pop();
    };
    Data.ArrayIndexOf = function (array, element, comparer) {
        if (!comparer) {
            for (var i = 0; i < array.length; i++) {
                if (array[i] == element)
                    return i;
            }
        }
        else {
            for (var i = 0; i < array.length; i++) {
                if (comparer(array[i], element))
                    return i;
            }
        }
        return -1;
    };
    Data.ArrayContains = function (array, element) {
        return Data.ArrayIndexOf(array, element) >= 0;
    };
    Data.ArrayEqual = function (array1, array2) {
        var count1 = array1.length;
        var count2 = array2.length;
        if (count1 != count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (array1[i] != array2[i])
                return false;
        return true;
    };
    Data.ArraySame = function (array1, array2) {
        if (array1.length !== array2.length)
            return false;
        return array1.every(function (elem) { return Data.ArrayContains(array2, elem); });
    };
    Data.ArrayGetIntegerEdgeValues = function (array) {
        var arrayToSort = Data.CollectionToArray(array);
        Data.ArrayIntegerAscendingSort(arrayToSort);
        return {
            start: arrayToSort[0],
            end: arrayToSort[arrayToSort.length - 1]
        };
    };
    Data.ArrayIntegerAscendingSort = function (array) {
        Data.ArrayIntegerSort(array, false);
    };
    Data.ArrayIntegerSort = function (array, desc) {
        array.sort(function (i1, i2) {
            var res = 0;
            if (i1 > i2)
                res = 1;
            else if (i1 < i2)
                res = -1;
            if (desc)
                res *= -1;
            return res;
        });
    };
    Data.CollectionsUnionToArray = function (firstCollection, secondCollection) {
        var result = [];
        var firstCollectionLength = firstCollection.length;
        var secondCollectionLength = secondCollection.length;
        for (var i = 0; i < firstCollectionLength + secondCollectionLength; i++) {
            if (i < firstCollectionLength)
                result.push(firstCollection[i]);
            else
                result.push(secondCollection[i - firstCollectionLength]);
        }
        return result;
    };
    Data.CollectionToArray = function (collection) {
        var array = [];
        for (var i = 0; i < collection.length; i++)
            array.push(collection[i]);
        return array;
    };
    Data.CreateHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = 1;
        return hash;
    };
    Data.CreateIndexHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = i;
        return hash;
    };
    Data.ArrayToHash = function (array, getKeyFunc, getValueFunc) {
        if (!(array instanceof Array))
            return {};
        return array.reduce(function (map, element, index) {
            var key = getKeyFunc(element, index);
            var value = getValueFunc(element, index);
            map[key] = value;
            return map;
        }, {});
    };
    Data.Sum = function (array, getValueFunc) {
        if (!(array instanceof Array))
            return 0;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!Base_1.IsNumber(value))
                value = 0;
            return prevValue + value;
        }, 0);
    };
    Data.Min = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, false); };
    ;
    Data.Max = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, true); };
    ;
    Data.NearestLeftBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        var leftPoint = arrayElement < value;
        var lastLeftPoint = leftPoint && index == array.length - 1;
        var nearestLeftPoint = lastLeftPoint || (leftPoint && array[index + 1] >= value);
        if (nearestLeftPoint)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    Data.ArrayBinarySearch = function (array, value, binarySearchComparer, startIndex, length) {
        if (!binarySearchComparer)
            binarySearchComparer = Data.defaultBinarySearchComparer;
        if (!Base_1.IsExists(startIndex))
            startIndex = 0;
        if (!Base_1.IsExists(length))
            length = array.length - startIndex;
        var endIndex = (startIndex + length) - 1;
        while (startIndex <= endIndex) {
            var middle = (startIndex + ((endIndex - startIndex) >> 1));
            var compareResult = binarySearchComparer(array, middle, value);
            if (compareResult == 0)
                return middle;
            if (compareResult < 0)
                startIndex = middle + 1;
            else
                endIndex = middle - 1;
        }
        return -(startIndex + 1);
    };
    Data.ArrayFlatten = function (arrayOfArrays) {
        return [].concat.apply([], arrayOfArrays);
    };
    Data.GetDistinctArray = function (array) {
        var resultArray = [];
        for (var i = 0; i < array.length; i++) {
            var currentEntry = array[i];
            if (Data.ArrayIndexOf(resultArray, currentEntry) == -1) {
                resultArray.push(currentEntry);
            }
        }
        return resultArray;
    };
    Data.ForEach = function (arr, callback) {
        if (Array.prototype.forEach) {
            Array.prototype.forEach.call(arr, callback);
        }
        else {
            for (var i = 0, len = arr.length; i < len; i++) {
                callback(arr[i], i, arr);
            }
        }
    };
    Data.MergeHashTables = function (target, object) {
        if (!object || typeof (object) == "string")
            return target;
        if (!target)
            target = {};
        for (var key in object)
            if (key && !(key in target))
                target[key] = object[key];
        return target;
    };
    Data.Range = function (count, start) {
        count = parseInt(count) || 0;
        start = parseInt(start) || 0;
        if (count < 0)
            count = 0;
        if (start < 0)
            start = 0;
        return Array.apply(null, Array(count)).map(function (_val, i) { return start + i; });
    };
    Data.CalculateArrayMinMax = function (array, getValueFunc, isMax) {
        if (!(array instanceof Array))
            return 0;
        var startValue = isMax ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!Base_1.IsNumber(value))
                value = startValue;
            var func = isMax ? Math.max : Math.min;
            return func(value, prevValue);
        }, startValue);
    };
    Data.defaultBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        if (arrayElement == value)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    return Data;
}());
exports.Data = Data;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base_1 = __webpack_require__(19);
var Str = /** @class */ (function () {
    function Str() {
    }
    Str.TrimStart = function (str) {
        return Str.trimInternal(str, true, false);
    };
    Str.TrimEnd = function (str) {
        return Str.trimInternal(str, false, true);
    };
    Str.Trim = function (str) {
        return Str.trimInternal(str, true, true);
    };
    Str.EncodeHtml = function (html) {
        return Str.ApplyReplacement(html, [
            [/&amp;/g, '&ampx;'], [/&/g, '&amp;'],
            [/&quot;/g, '&quotx;'], [/"/g, '&quot;'],
            [/&lt;/g, '&ltx;'], [/</g, '&lt;'],
            [/&gt;/g, '&gtx;'], [/>/g, '&gt;']
        ]);
    };
    Str.trimInternal = function (source, trimStart, trimEnd) {
        var len = source.length;
        if (!len)
            return source;
        if (len < 0xBABA1) { // B181394        
            var result = source;
            if (trimStart) {
                result = result.replace(/^\s+/, "");
            }
            if (trimEnd) {
                result = result.replace(/\s+$/, "");
            }
            return result;
        }
        else {
            var start = 0;
            if (trimEnd) {
                while (len > 0 && Str.whiteSpaces[source.charCodeAt(len - 1)]) {
                    len--;
                }
            }
            if (trimStart && len > 0) {
                while (start < len && Str.whiteSpaces[source.charCodeAt(start)]) {
                    start++;
                }
            }
            return source.substring(start, len);
        }
    };
    Str.ApplyReplacement = function (text, replecementTable) {
        //if (typeof (text) != "string")
        //    text = text.toString();
        for (var i = 0; i < replecementTable.length; i++) {
            var replacement = replecementTable[i];
            text = text.replace(replacement[0], replacement[1]);
        }
        return text;
    };
    Str.DecodeHtmlViaTextArea = function (html) {
        var textArea = document.createElement("TEXTAREA");
        Base_1.setInnerHtmlInternal(textArea, html);
        return textArea.value;
    };
    Str.whiteSpaces = {
        0x0009: 1, 0x000a: 1, 0x000b: 1, 0x000c: 1, 0x000d: 1, 0x0020: 1, 0x0085: 1,
        0x00a0: 1, 0x1680: 1, 0x180e: 1, 0x2000: 1, 0x2001: 1, 0x2002: 1, 0x2003: 1,
        0x2004: 1, 0x2005: 1, 0x2006: 1, 0x2007: 1, 0x2008: 1, 0x2009: 1, 0x200a: 1,
        0x200b: 1, 0x2028: 1, 0x2029: 1, 0x202f: 1, 0x205f: 1, 0x3000: 1
    };
    return Str;
}());
exports.Str = Str;


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(20);
var Attr = /** @class */ (function () {
    function Attr() {
    }
    Attr.SetAttribute = function (obj, attrName, value) {
        if (obj.setAttribute) {
            if (Attr.isSourceResetRequired() && attrName.toLowerCase() === "src") // T481593
                obj.setAttribute(attrName, "");
            obj.setAttribute(attrName, value);
        }
        else if (obj.setProperty)
            obj.setProperty(attrName, value, "");
    };
    Attr.GetAttribute = function (obj, attrName) {
        if (obj.getAttribute)
            return obj.getAttribute(attrName);
        else if (obj.getPropertyValue) {
            if (Browser_1.Browser.Firefox) { //T644613
                try {
                    return obj.getPropertyValue(attrName);
                }
                catch (e) {
                    return obj[attrName];
                }
            }
            return obj.getPropertyValue(attrName);
        }
        return null;
    };
    Attr.GetTabIndexAttributeName = function () {
        return Browser_1.Browser.IE ? "tabIndex" : "tabindex";
    };
    Attr.ChangeStyleAttribute = function (obj, attrName, newValue) {
        Attr.ChangeAttributeExtended(obj.style, attrName, obj, "saved" + attrName, newValue);
    };
    Attr.ChangeAttributeExtended = function (obj, attrName, savedObj, savedAttrName, newValue) {
        Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
        Attr.SetAttribute(obj, attrName, newValue);
    };
    Attr.SaveAttribute = function (obj, attrName, savedObj, savedAttrName) {
        if (!Attr.IsExistsAttribute(savedObj, savedAttrName)) {
            var oldValue = Attr.IsExistsAttribute(obj, attrName) ? Attr.GetAttribute(obj, attrName) : Attr.EmptyObject;
            Attr.SetAttribute(savedObj, savedAttrName, oldValue);
        }
    };
    Attr.RestoreAttributeExtended = function (obj, attrName, savedObj, savedAttrName) {
        if (Attr.IsExistsAttribute(savedObj, savedAttrName)) {
            var oldValue = Attr.GetAttribute(savedObj, savedAttrName);
            if (oldValue != Attr.EmptyObject)
                Attr.SetAttribute(obj, attrName, oldValue);
            else
                Attr.RemoveAttribute(obj, attrName);
            Attr.RemoveAttribute(savedObj, savedAttrName);
            return true;
        }
        return false;
    };
    Attr.RemoveAttribute = function (obj, attrName) {
        if (obj.removeAttribute)
            obj.removeAttribute(attrName);
        else if (obj.removeProperty)
            obj.removeProperty(attrName);
    };
    Attr.IsExistsAttribute = function (obj, attrName) {
        var value = Attr.GetAttribute(obj, attrName);
        return (value != null) && (value !== "");
    };
    Attr.isSourceResetRequired = function () {
        return Browser_1.Browser.IE && Browser_1.Browser.MajorVersion >= 11;
    };
    Attr.EmptyObject = {};
    Attr.RestoreStyleAttribute = function (obj, attrName) {
        return Attr.RestoreAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
    };
    return Attr;
}());
exports.Attr = Attr;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsCalculatorBase_1 = __webpack_require__(71);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsCalculator, _super);
    function ConnectorPointsCalculator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorPointsCalculator.prototype.getPoints = function () {
        return this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
    };
    return ConnectorPointsCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsCalculator = ConnectorPointsCalculator;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(3);
var ConnectorPointsCalculatorBase_1 = __webpack_require__(71);
var ConnectorPointsOrthogonalUndefinedSideCalculator_1 = __webpack_require__(107);
var ConnectorPointsOrthogonalSouthSideCalculator_1 = __webpack_require__(108);
var ConnectorPointsOrthogonalNorthSideCalculator_1 = __webpack_require__(109);
var ConnectorPointsOrthogonalEastSideCalculator_1 = __webpack_require__(110);
var ConnectorPointsOrthogonalWestSideCalculator_1 = __webpack_require__(111);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalCalculator, _super);
    function ConnectorPointsOrthogonalCalculator(connector) {
        var _this = _super.call(this, connector) || this;
        _this.sideCalculators = {};
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.Undefined] = new ConnectorPointsOrthogonalUndefinedSideCalculator_1.ConnectorPointsOrthogonalUndefinedSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.South] = new ConnectorPointsOrthogonalSouthSideCalculator_1.ConnectorPointsOrthogonalSouthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.North] = new ConnectorPointsOrthogonalNorthSideCalculator_1.ConnectorPointsOrthogonalNorthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.East] = new ConnectorPointsOrthogonalEastSideCalculator_1.ConnectorPointsOrthogonalEastSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.West] = new ConnectorPointsOrthogonalWestSideCalculator_1.ConnectorPointsOrthogonalWestSideCalculator(_this);
        return _this;
    }
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "beginRect", {
        get: function () { return this.connector.beginItem ? this.connector.beginItem.rectangle : undefined; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "endRect", {
        get: function () { return this.connector.endItem ? this.connector.endItem.rectangle : undefined; },
        enumerable: true,
        configurable: true
    });
    ConnectorPointsOrthogonalCalculator.prototype.getPoints = function () {
        var points = this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
        this.removeUnnecessaryLinePoints(points);
        var beginIndex = 0, endIndex = points.length - 1;
        var beginSide = this.getPointSide(points, 0);
        var beginNextSide = this.getPointSide(points, 1);
        var endSide = this.getPointSide(points, points.length - 1);
        var endPrevSide = this.getPointSide(points, points.length - 1 - 1);
        var beginSideCalculator = this.getSideCalculator(beginSide);
        var endSideCalculator = this.getSideCalculator(endSide);
        var originRect = this.beginRect;
        var originPoint = beginSideCalculator.getCorrectOriginPoint(points[beginIndex], originRect);
        var targetPoint = points[beginIndex + 1];
        if (points.length === 2 && beginSideCalculator.isOnSidePoint(originPoint, targetPoint) &&
            beginSideCalculator.isDirectConnectionAllowed(beginNextSide, originPoint, targetPoint)) {
            var directConnectionPoints = beginSideCalculator.getDirectConnectionPoints(originPoint, targetPoint);
            directConnectionPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
                beginIndex++;
                endIndex++;
            });
        }
        else {
            var bOffsetPoints = beginSideCalculator.getBeginOffsetPoints(beginNextSide, points[beginIndex], points[beginIndex + 1], this.beginRect);
            bOffsetPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
            });
            beginIndex += bOffsetPoints.length;
            endIndex += bOffsetPoints.length;
            var eOffsetPoints = endSideCalculator.getEndOffsetPoints(endPrevSide, points[endIndex], points[endIndex - 1], this.endRect);
            eOffsetPoints.forEach(function (pt, index) {
                points.splice(endIndex + index, 0, pt);
            });
            for (var index = beginIndex; index < endIndex; index++) {
                var nextIndex = index + 1;
                var middlePoint = this.getMiddlePoint(points[index], points[index - 1], index - 1 === 0, points[nextIndex], points[nextIndex + 1], nextIndex + 1 === points.length - 1);
                if (middlePoint !== undefined) {
                    points.splice(index + 1, 0, middlePoint);
                    index++;
                    endIndex++;
                }
            }
        }
        this.removeUnnecessaryLinePoints(points);
        return points;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getSideCalculator = function (side) {
        return this.sideCalculators[side];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getPointSide = function (points, index) {
        if (index === 0 && this.connector.beginItem) {
            var connectionPointIndex = this.connector.beginConnectionPointIndex;
            return this.connector.beginItem.getConnectionPointSide(connectionPointIndex, points[1]);
        }
        if (index === points.length - 1 && this.connector.endItem) {
            var connectionPointIndex = this.connector.endConnectionPointIndex;
            return this.connector.endItem.getConnectionPointSide(connectionPointIndex, points[points.length - 2]);
        }
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoints = function (point1, point2) {
        if (point1.x === point2.x || point1.y === point2.y)
            return [];
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point1.x, point2.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point2.x, point1.y)
        ];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoint = function (point1, directionPoint1, nextToBegin, point2, directionPoint2, nextToEnd) {
        var _this = this;
        var point;
        var points = this.getMiddlePoints(point1, point2);
        points.forEach(function (pt) {
            var rect1 = _this.createPointsRect(point1, pt);
            var rect2 = _this.createPointsRect(pt, point2);
            var itemRect1 = _this.connector.beginItem ? _this.connector.beginItem.rectangle : undefined;
            var itemRect2 = _this.connector.endItem ? _this.connector.endItem.rectangle : undefined;
            if (itemRect1) {
                if (itemRect1.intersect(rect1) || itemRect1.intersect(rect2))
                    return;
            }
            if (itemRect2) {
                if (itemRect2.intersect(rect1) || itemRect2.intersect(rect2))
                    return;
            }
            if ((!_this.isReturnPoint(pt, point1, directionPoint1) || _this.isIntermediatePoints(point1, directionPoint1)) &&
                (!_this.isReturnPoint(pt, point2, directionPoint2) || _this.isIntermediatePoints(point2, directionPoint2))) {
                if (point === undefined)
                    point = pt;
                else if (_this.isPriorMiddlePoint(pt, point1, directionPoint1, point2, directionPoint2))
                    point = pt;
            }
        });
        if (point === undefined && points.length > 0)
            point = points[0];
        return point;
    };
    ConnectorPointsOrthogonalCalculator.prototype.createPointsRect = function (point1, point2) {
        var result = Utils_1.Rectangle.createByPoints(point1, point2);
        if (result.width > 0)
            result = result.inflate(-1, 0);
        if (result.height > 0)
            result = result.inflate(0, -1);
        return result;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isPriorMiddlePoint = function (point, point1, directionPoint1, point2, directionPoint2) {
        if (directionPoint1) {
            if (point.x === directionPoint1.x || point.y === directionPoint1.y)
                return true;
        }
        if (directionPoint2) {
            if (point.x === directionPoint2.x || point.y === directionPoint2.y)
                return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isReturnPoint = function (point, point1, point2) {
        if (point1 !== undefined && point2 !== undefined) {
            if (point.x === point2.x)
                if (point1.y < point.y && point.y < point2.y || point1.y > point.y && point.y > point2.y)
                    return true;
            if (point.y === point2.y)
                if (point1.x < point.x && point.x < point2.x || point1.x > point.x && point.x > point2.x)
                    return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isIntermediatePoints = function (point1, point2) {
        return 0 < point1.pointIndex && point1.pointIndex < this.connector.points.length - 1 &&
            0 < point2.pointIndex && point2.pointIndex < this.connector.points.length - 1;
    };
    ConnectorPointsOrthogonalCalculator.prototype.removeUnnecessaryLinePoints = function (points) {
        Utils_1.GeometryUtils.removeUnnecessaryLinePoints(points, function (pt, index) {
            if (pt.pointIndex === -1) {
                points.splice(index, 1);
                return true;
            }
            else {
                pt.skipped = true;
                return false;
            }
        }, function (pt) {
            return pt !== undefined && !pt.skipped;
        });
    };
    return ConnectorPointsOrthogonalCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsOrthogonalCalculator = ConnectorPointsOrthogonalCalculator;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(33);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalUndefinedSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalUndefinedSideCalculator, _super);
    function ConnectorPointsOrthogonalUndefinedSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        return originPoint;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return true;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        var calculator = this.getSideCalculator(originPoint, targetPoint);
        if (calculator !== undefined)
            return calculator.isDirectConnectionAllowed(targetSide, originPoint, targetPoint);
        return true;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY) {
            var minX = Math.min(originPoint.x, targetPoint.x);
            var cx = minX + diffX / 2;
            return [
                new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
                new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
            ];
        }
        else {
            var minY = Math.min(originPoint.y, targetPoint.y);
            var cy = minY + diffY / 2;
            return [
                new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
                new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
            ];
        }
    };
    return ConnectorPointsOrthogonalUndefinedSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalUndefinedSideCalculator = ConnectorPointsOrthogonalUndefinedSideCalculator;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(33);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalSouthSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalSouthSideCalculator, _super);
    function ConnectorPointsOrthogonalSouthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y < originRect.bottom)
            originPoint = originPoint.offset(0, originRect.bottom - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y < targetPoint.y) {
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, this.getMinOffset())];
                }
                if (originPoint.y > this.endRect.bottom)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y < targetPoint.y) {
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, this.getMinOffset())];
                }
                if (originPoint.y > this.endRect.bottom)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y < originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.offset(0, this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y < originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.offset(0, this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                var offset = this.getMinOffset();
                if (this.beginRect.bottom > originPoint.y)
                    offset += this.beginRect.bottom - originPoint.y;
                return [originPoint.offset(0, offset)];
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.offset(-(originPoint.x - originRect.left + asideOffset), offset));
            else
                points.push(originPoint.offset((originRect.right - originPoint.x + asideOffset), offset));
        }
        points.push(originPoint.offset(0, offset));
        return points;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.left - this.endRect.right;
                else
                    distance = this.endRect.left - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? this.beginRect.top - originPoint.y : this.endRect.top - originPoint.y;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y > originPoint.y;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.North || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = originPoint.y + (targetPoint.y - originPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalSouthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalSouthSideCalculator = ConnectorPointsOrthogonalSouthSideCalculator;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(33);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalNorthSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalNorthSideCalculator, _super);
    function ConnectorPointsOrthogonalNorthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y > originRect.top)
            originPoint = originPoint.offset(0, originRect.top - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y > targetPoint.y) {
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, -this.getMinOffset())];
                }
                if (originPoint.y < this.endRect.top)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y > targetPoint.y) {
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, -this.getMinOffset())];
                }
                if (originPoint.y < this.endRect.top)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                var offset = -this.getMinOffset();
                if (this.beginRect.top < originPoint.y)
                    offset -= originPoint.y - this.beginRect.top;
                return [originPoint.offset(0, offset)];
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.offset(-(originPoint.x - originRect.left + asideOffset), -offset));
            else
                points.push(originPoint.offset((originRect.right - originPoint.x + asideOffset), -offset));
        }
        points.push(originPoint.offset(0, -offset));
        return points;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.left - this.endRect.right;
                else
                    distance = this.endRect.left - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.y - this.beginRect.bottom : originPoint.y - this.endRect.bottom;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y < originPoint.y;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.South || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = targetPoint.y + (originPoint.y - targetPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalNorthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalNorthSideCalculator = ConnectorPointsOrthogonalNorthSideCalculator;


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(33);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalEastSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalEastSideCalculator, _super);
    function ConnectorPointsOrthogonalEastSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x < originRect.right)
            originPoint = originPoint.offset(originRect.right - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x < targetPoint.x) {
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(this.getMinOffset(), 0)];
                }
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x < targetPoint.x) {
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(this.getMinOffset(), 0)];
                }
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                var offset = this.getMinOffset();
                if (this.beginRect.right > originPoint.x)
                    offset += this.beginRect.right - originPoint.x;
                return [originPoint.offset(offset, 0)];
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.offset(this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.offset(this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.offset(offset, -(originPoint.y - originRect.top + asideOffset)));
            else
                points.push(originPoint.offset(offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.offset(offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? this.beginRect.left - originPoint.x : this.endRect.left - originPoint.x;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.top - this.endRect.bottom;
                else
                    distance = this.endRect.top - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x > originPoint.x;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.West || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = originPoint.x + (targetPoint.x - originPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalEastSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalEastSideCalculator = ConnectorPointsOrthogonalEastSideCalculator;


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(3);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(33);
var ConnectorRenderPoint_1 = __webpack_require__(27);
var ConnectorPointsOrthogonalWestSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalWestSideCalculator, _super);
    function ConnectorPointsOrthogonalWestSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x > originRect.left)
            originPoint = originPoint.offset(originRect.left - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x > targetPoint.x) {
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(-this.getMinOffset(), 0)];
                }
                if (originPoint.x < this.endRect.left)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x > targetPoint.x) {
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(-this.getMinOffset(), 0)];
                }
                if (originPoint.x < this.endRect.left)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                var offset = -this.getMinOffset();
                if (this.beginRect.left < originPoint.x)
                    offset -= originPoint.x - this.beginRect.left;
                return [originPoint.offset(offset, 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.offset(-this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.offset(-this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.offset(-offset, -(originPoint.y - originRect.top + asideOffset)));
            else
                points.push(originPoint.offset(-offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.offset(-offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.x - this.beginRect.right : originPoint.x - this.endRect.right;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.top - this.endRect.bottom;
                else
                    distance = this.endRect.top - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x < originPoint.x;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.East || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = targetPoint.x + (originPoint.x - targetPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalWestSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalWestSideCalculator = ConnectorPointsOrthogonalWestSideCalculator;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorText = /** @class */ (function () {
    function ConnectorText(position, value) {
        this.position = position;
        this.value = value;
    }
    return ConnectorText;
}());
exports.ConnectorText = ConnectorText;
var ConnectorTexts = /** @class */ (function () {
    function ConnectorTexts() {
        this.items = {};
    }
    ConnectorTexts.prototype.get = function (position) {
        return this.items[position];
    };
    ConnectorTexts.prototype.set = function (position, text) {
        this.items[position] = text;
    };
    ConnectorTexts.prototype.remove = function (position) {
        delete this.items[position];
    };
    ConnectorTexts.prototype.forEach = function (callback) {
        for (var key in this.items)
            if (this.items.hasOwnProperty(key))
                callback(this.items[key]);
    };
    ConnectorTexts.prototype.clone = function () {
        var result = new ConnectorTexts();
        this.forEach(function (t) { result.set(t.position, new ConnectorText(t.position, t.value)); });
        return result;
    };
    ConnectorTexts.prototype.toObject = function () {
        var result = {};
        var modified = false;
        this.forEach(function (t) {
            result[t.position] = t.value;
            modified = true;
        });
        return modified ? result : null;
    };
    ConnectorTexts.prototype.fromObject = function (obj) {
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                var position = parseFloat(key);
                if (!isNaN(position) && typeof obj[key] === "string") {
                    this.set(position, new ConnectorText(position, obj[key]));
                }
            }
        }
    };
    return ConnectorTexts;
}());
exports.ConnectorTexts = ConnectorTexts;


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var FilterPrimitive = /** @class */ (function (_super) {
    __extends(FilterPrimitive, _super);
    function FilterPrimitive(id, x, y, width, height) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    FilterPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "filter");
    };
    FilterPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return FilterPrimitive;
}(Primitive_1.SvgPrimitive));
exports.FilterPrimitive = FilterPrimitive;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var Utils_1 = __webpack_require__(0);
var ModelResizeHistoryItem = /** @class */ (function (_super) {
    __extends(ModelResizeHistoryItem, _super);
    function ModelResizeHistoryItem(offset) {
        var _this = _super.call(this) || this;
        _this.offset = offset;
        return _this;
    }
    ModelResizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.size.clone();
        this.backOffset = new Utils_1.Offset(-this.offset.left, -this.offset.top, -this.offset.right, -this.offset.bottom);
        var newWidth = Math.max(this.oldSize.width + this.offset.left + this.offset.right, manipulator.model.pageWidth);
        var newHeight = Math.max(this.oldSize.height + this.offset.top + this.offset.bottom, manipulator.model.pageHeight);
        manipulator.changeModelSize(new Utils_1.Size(newWidth, newHeight), this.offset);
    };
    ModelResizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changeModelSize(this.oldSize, this.backOffset);
    };
    return ModelResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ModelResizeHistoryItem = ModelResizeHistoryItem;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var UpdatePositionsOnPageResizeHistoryItem = /** @class */ (function (_super) {
    __extends(UpdatePositionsOnPageResizeHistoryItem, _super);
    function UpdatePositionsOnPageResizeHistoryItem(offsetX, offsetY) {
        var _this = _super.call(this) || this;
        _this.offsetX = offsetX;
        _this.offsetY = offsetY;
        return _this;
    }
    UpdatePositionsOnPageResizeHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, item.position.offset(_this.offsetX, _this.offsetY));
            if (item instanceof Connector_1.Connector)
                item.points.forEach(function (p, index) { return manipulator.moveConnectorPoint(item, index, p.offset(_this.offsetX, _this.offsetY)); });
        });
    };
    UpdatePositionsOnPageResizeHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, item.position.offset(-_this.offsetX, -_this.offsetY));
            if (item instanceof Connector_1.Connector)
                item.points.forEach(function (p, index) { return manipulator.moveConnectorPoint(item, index, p.offset(-_this.offsetX, -_this.offsetY)); });
        });
    };
    return UpdatePositionsOnPageResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.UpdatePositionsOnPageResizeHistoryItem = UpdatePositionsOnPageResizeHistoryItem;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var DeleteConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectorPointHistoryItem, _super);
    function DeleteConnectorPointHistoryItem(connectorKey, pointIndex) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        return _this;
    }
    DeleteConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.point = connector.points[this.pointIndex].clone();
        manipulator.deleteConnectorPoint(connector, this.pointIndex);
    };
    DeleteConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.addConnectorPoint(connector, this.pointIndex, this.point);
    };
    return DeleteConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectorPointHistoryItem = DeleteConnectorPointHistoryItem;


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ResizeShapeHistoryItem = /** @class */ (function (_super) {
    __extends(ResizeShapeHistoryItem, _super);
    function ResizeShapeHistoryItem(shapeKey, position, size) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        _this.size = size;
        return _this;
    }
    ResizeShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        this.oldSize = shape.size.clone();
        manipulator.resizeShape(shape, this.position, this.size);
    };
    ResizeShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.resizeShape(shape, this.oldPosition, this.oldSize);
    };
    return ResizeShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ResizeShapeHistoryItem = ResizeShapeHistoryItem;


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var DeleteConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectorHistoryItem, _super);
    function DeleteConnectorHistoryItem(connectorKey) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        return _this;
    }
    DeleteConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.connector = connector.clone();
        manipulator.deleteConnector(connector);
    };
    DeleteConnectorHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addConnector(this.connector, this.connector.key);
    };
    return DeleteConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectorHistoryItem = DeleteConnectorHistoryItem;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DataSourceNodeDataImporter = /** @class */ (function () {
    function DataSourceNodeDataImporter() {
        this.getKey = function (obj) { return obj["id"]; };
        this.setKey = function (obj, value) { obj["id"] = value; };
        this.getText = function (obj) { return obj["text"]; };
        this.setText = function (obj, value) { obj["text"] = value; };
        this.getType = function (obj) { return obj["type"]; };
        this.setType = function (obj, value) { obj["type"] = value; };
        this.getParentKey = function (obj) { return obj["parentId"]; };
        this.setParentKey = function (obj, value) { obj["parentId"] = value; };
        this.getItems = function (obj) { return obj["items"]; };
        this.setItems = function (obj, value) { obj["items"] = value; };
    }
    return DataSourceNodeDataImporter;
}());
exports.DataSourceNodeDataImporter = DataSourceNodeDataImporter;
var DataSourceEdgeDataImporter = /** @class */ (function () {
    function DataSourceEdgeDataImporter() {
        this.getKey = function (obj) { return obj["id"]; };
        this.setKey = function (obj, value) { obj["id"] = value; };
        this.getFrom = function (obj) { return obj["from"]; };
        this.setFrom = function (obj, value) { obj["from"] = value; };
        this.getTo = function (obj) { return obj["to"]; };
        this.setTo = function (obj, value) { obj["to"] = value; };
    }
    return DataSourceEdgeDataImporter;
}());
exports.DataSourceEdgeDataImporter = DataSourceEdgeDataImporter;


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var ProcessShapeDescription = /** @class */ (function (_super) {
    __extends(ProcessShapeDescription, _super);
    function ProcessShapeDescription() {
        return _super.call(this, "Process", "Process") || this;
    }
    Object.defineProperty(ProcessShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Process; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ProcessShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    return ProcessShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ProcessShapeDescription = ProcessShapeDescription;


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiamondShapeDescription_1 = __webpack_require__(75);
var ShapeType_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(11);
var DecisionShapeDescription = /** @class */ (function (_super) {
    __extends(DecisionShapeDescription, _super);
    function DecisionShapeDescription() {
        return _super.call(this, "Decision", "Decision", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75)) || this;
    }
    Object.defineProperty(DecisionShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Decision; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DecisionShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    return DecisionShapeDescription;
}(DiamondShapeDescription_1.DiamondShapeDescription));
exports.DecisionShapeDescription = DecisionShapeDescription;


/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(3);
var ManualInputShapeDescription = /** @class */ (function (_super) {
    __extends(ManualInputShapeDescription, _super);
    function ManualInputShapeDescription() {
        return _super.call(this, "Manual Input", "Manual Input") || this;
    }
    Object.defineProperty(ManualInputShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ManualInput; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ManualInputShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    ManualInputShapeDescription.prototype.createPrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var y1 = top + height * ManualInputShapeDescription.slopeHeightRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ManualInputShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += ManualInputShapeDescription.slopeHeightRatio / 2 * shape.size.height;
    };
    ManualInputShapeDescription.slopeHeightRatio = 0.1;
    return ManualInputShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ManualInputShapeDescription = ManualInputShapeDescription;


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(3);
var DataShapeDescription = /** @class */ (function (_super) {
    __extends(DataShapeDescription, _super);
    function DataShapeDescription() {
        return _super.call(this, "Data", "Data") || this;
    }
    Object.defineProperty(DataShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Data; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    DataShapeDescription.prototype.createPrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(DataShapeDescription.slopeAngle)), width);
        var x1 = left + px;
        var x2 = right - px;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    DataShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var offset = shape.size.height / Math.tan(DataShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    DataShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return DataShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DataShapeDescription = DataShapeDescription;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(11);
var TerminatorShapeDescription = /** @class */ (function (_super) {
    __extends(TerminatorShapeDescription, _super);
    function TerminatorShapeDescription() {
        return _super.call(this, "Terminator", "Terminator", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.5)) || this;
    }
    Object.defineProperty(TerminatorShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Terminator; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TerminatorShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    TerminatorShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var x1 = left + width * TerminatorShapeDescription.curveWidthRatio;
        var x2 = left + width * (1 - TerminatorShapeDescription.curveWidthRatio);
        var ratio = height / width;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right, top, right, cy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right, bottom, x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left, bottom, left, cy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left, top, x1, top),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    TerminatorShapeDescription.curveWidthRatio = 0.3;
    return TerminatorShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.TerminatorShapeDescription = TerminatorShapeDescription;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var PathPrimitive_1 = __webpack_require__(2);
exports.PredefinedProcessEdgeParameterName = "e";
var PredefinedProcessShapeDescription = /** @class */ (function (_super) {
    __extends(PredefinedProcessShapeDescription, _super);
    function PredefinedProcessShapeDescription() {
        return _super.call(this, "Predefined Process", "Predefined\nProcess") || this;
    }
    Object.defineProperty(PredefinedProcessShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.PredefinedProcess; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PredefinedProcessShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    PredefinedProcessShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var x1 = left + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var x2 = right - shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var primitives = _super.prototype.createPrimitives.call(this, shape);
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom)
            ], shape.style)
        ]);
    };
    PredefinedProcessShapeDescription.prototype.createParameters = function (parameters) {
        parameters.add(new ShapeParameters_1.ShapeParameter(exports.PredefinedProcessEdgeParameterName, this.defaultSize.width * 0.1));
    };
    PredefinedProcessShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return Math.max(PredefinedProcessShapeDescription.minEdge, Math.min(shape.size.width * 0.3, p.value)); });
    };
    PredefinedProcessShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return p.value + deltaX; });
        this.normalizeParameters(shape, parameters);
    };
    PredefinedProcessShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value), shape.position.y))
        ];
    };
    PredefinedProcessShapeDescription.minEdge = 72;
    return PredefinedProcessShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PredefinedProcessShapeDescription = PredefinedProcessShapeDescription;


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(54);
var ShapeType_1 = __webpack_require__(1);
var ArrowNorthSouthShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowNorthSouthShapeDescription, _super);
    function ArrowNorthSouthShapeDescription() {
        return _super.call(this, "North-South Arrow") || this;
    }
    Object.defineProperty(ArrowNorthSouthShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowNorthSouth; },
        enumerable: true,
        configurable: true
    });
    ArrowNorthSouthShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        var p0y2 = shape.normalizeY(bottom - p0dy);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowNorthSouthShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height / 2 - 2 * Shape_1.Shape.lineWidth, p.value)); });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
    };
    ArrowNorthSouthShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value + deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowNorthSouthShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    return ArrowNorthSouthShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowNorthSouthShapeDescription = ArrowNorthSouthShapeDescription;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(55);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
var ArrowRightShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowRightShapeDescription, _super);
    function ArrowRightShapeDescription() {
        return _super.call(this, "Right Arrow") || this;
    }
    Object.defineProperty(ArrowRightShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowRight; },
        enumerable: true,
        configurable: true
    });
    ArrowRightShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowRightShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value - deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowRightShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.size.width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    ArrowRightShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var triangleWidth = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        if (point.x > shape.position.x + shape.size.width - triangleWidth) {
            var tg = shape.size.height / 2 / triangleWidth;
            var delta = (point.x - (shape.position.x + shape.size.width - triangleWidth)) * tg;
            var side = shape.getConnectionPointSide(index);
            if (side === DiagramItem_1.ConnectionPointSide.North)
                point.y += delta;
            else if (side === DiagramItem_1.ConnectionPointSide.South)
                point.y -= delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point, index);
    };
    return ArrowRightShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowRightShapeDescription = ArrowRightShapeDescription;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(54);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
var ArrowTopShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowTopShapeDescription, _super);
    function ArrowTopShapeDescription() {
        return _super.call(this, "Top Arrow") || this;
    }
    Object.defineProperty(ArrowTopShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowTop; },
        enumerable: true,
        configurable: true
    });
    ArrowTopShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowTopShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value + deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowTopShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    ArrowTopShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var triangleHeight = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        if (point.y < shape.position.y + triangleHeight) {
            var tg = shape.size.width / 2 / triangleHeight;
            var delta = (shape.position.y + triangleHeight - point.y) * tg;
            var side = shape.getConnectionPointSide(index);
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.x -= delta;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.x += delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point, index);
    };
    return ArrowTopShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowTopShapeDescription = ArrowTopShapeDescription;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeParameterPoint_1 = __webpack_require__(17);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
exports.CrossHorizontalWidthParameterName = "chw";
exports.CrossVerticalWidthParameterName = "cvw";
var CrossShapeDescription = /** @class */ (function (_super) {
    __extends(CrossShapeDescription, _super);
    function CrossShapeDescription() {
        return _super.call(this, "Cross", "") || this;
    }
    Object.defineProperty(CrossShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Cross; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CrossShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    CrossShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var p0dx = (width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2;
        var p1dy = (height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    CrossShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.CrossHorizontalWidthParameterName, this.defaultSize.width * 0.2),
            new ShapeParameters_1.ShapeParameter(exports.CrossVerticalWidthParameterName, this.defaultSize.height * 0.2)
        ]);
    };
    CrossShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    CrossShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    CrossShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2)))
        ];
    };
    return CrossShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.CrossShapeDescription = CrossShapeDescription;


/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(11);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var ConnectionPoint_1 = __webpack_require__(32);
var DiagramItem_1 = __webpack_require__(3);
var HeartShapeDescription = /** @class */ (function (_super) {
    __extends(HeartShapeDescription, _super);
    function HeartShapeDescription() {
        return _super.call(this, "Heart", "") || this;
    }
    Object.defineProperty(HeartShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Heart; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(HeartShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.General; },
        enumerable: true,
        configurable: true
    });
    HeartShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0.15, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.25, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.25, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    HeartShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right - width * 0.15, top, right, top + height * 0.1, right, top + height * 0.25),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right, top + height * 0.3, right - width * 0.02, top + height * 0.35, right - width * 0.05, top + height * 0.4),
                new PathPrimitive_1.PathPrimitiveLineToCommand(rect.center.x, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + width * 0.05, top + height * 0.4),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left + width * 0.02, top + height * 0.35, left, top + height * 0.3, left, top + height * 0.25),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left, top + height * 0.1, left + width * 0.15, top, left + width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left + width * 0.3, top, left + width * 0.45, top + height * 0.03, left + width * 0.5, top + height * 0.15),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right - width * 0.45, top + height * 0.03, right - width * 0.3, top, right - width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    return HeartShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.HeartShapeDescription = HeartShapeDescription;


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(57);
var OctagonShapeDescription = /** @class */ (function (_super) {
    __extends(OctagonShapeDescription, _super);
    function OctagonShapeDescription() {
        return _super.call(this, "Octagon", "") || this;
    }
    Object.defineProperty(OctagonShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Octagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(OctagonShapeDescription.prototype, "angleCount", {
        get: function () { return 8; },
        enumerable: true,
        configurable: true
    });
    OctagonShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        var sideY = height / (1 + 2 * Math.cos(angle));
        var x1 = left + (width - sideX) / 2;
        var x2 = x1 + sideX;
        var y1 = top + (height - sideY) / 2;
        var y2 = y1 + sideY;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    OctagonShapeDescription.prototype.calculateHeight = function (width) {
        return width;
    };
    return OctagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.OctagonShapeDescription = OctagonShapeDescription;


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeType_1 = __webpack_require__(1);
var PentagonShapeDescription_1 = __webpack_require__(77);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(3);
exports.StarConvexParameterName = "sc";
var StarShapeDescription = /** @class */ (function (_super) {
    __extends(StarShapeDescription, _super);
    function StarShapeDescription() {
        return _super.call(this, "Star", "") || this;
    }
    Object.defineProperty(StarShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Star; },
        enumerable: true,
        configurable: true
    });
    StarShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var px = (height - py) / Math.tan(angle) / ratio;
        var x1 = left + px;
        var x2 = right - px;
        var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, cx, right, pDistance, distance), this.getInnerPointPos(cy, top, y, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, right, x2, pDistance, distance), this.getInnerPointPos(cy, y, bottom, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, x2, x1, pDistance, distance), this.getInnerPointPos(cy, bottom, bottom, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, x1, left, pDistance, distance), this.getInnerPointPos(cy, bottom, y, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, left, cx, pDistance, distance), this.getInnerPointPos(cy, y, top, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    StarShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.StarConvexParameterName, 300)
        ]);
    };
    StarShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        var rect = shape.rectangle;
        var top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        this.changeParameterValue(parameters, exports.StarConvexParameterName, function (p) { return Math.max(0, Math.min(distance, p.value)); });
    };
    StarShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        var distance = Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
        if (deltaX < 0 || deltaY > 0)
            distance = -distance;
        this.changeParameterValue(parameters, exports.StarConvexParameterName, function (p) { return p.value + distance; });
        this.normalizeParameters(shape, parameters);
    };
    StarShapeDescription.prototype.getParameterPoints = function (shape) {
        var rect = shape.rectangle;
        var top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        var innerPointX = this.getInnerPointPos(cx, cx, right, pDistance, distance);
        var innerPointY = this.getInnerPointPos(cy, top, y, pDistance, distance);
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(innerPointX, innerPointY))
        ];
    };
    StarShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        _super.prototype.processConnectionPoint.call(this, shape, point, index);
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.South) {
            var rect = shape.rectangle;
            var top_1 = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
            bottom = this.getActualBottom(top_1, bottom, width, height);
            var cx = rect.center.x;
            var cy = top_1 + (bottom - top_1) / 2;
            var ratio = height / width;
            var angle = Math.PI - this.angle;
            var py = width / 2 * Math.tan(angle / 2) * ratio;
            var y = top_1 + py;
            var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
            var distance = this.getInnerPointDistance(cx, cx, right, cy, top_1, y);
            point.y = this.getInnerPointPos(cy, bottom, bottom, pDistance, distance);
        }
    };
    StarShapeDescription.prototype.getInnerPointDistanceByAxis = function (center, edge1, edge2) {
        var edgeX = Math.min(edge1, edge2) + Math.abs(edge1 - edge2) / 2;
        return edgeX - center;
    };
    StarShapeDescription.prototype.getInnerPointPos = function (center, edge1, edge2, pDistance, distance) {
        var ratio = Math.min(1, pDistance / distance);
        return center + this.getInnerPointDistanceByAxis(center, edge1, edge2) * ratio;
    };
    StarShapeDescription.prototype.getInnerPointDistance = function (centerX, edgeX1, edgeX2, centerY, edgeY1, edgeY2) {
        var disX = this.getInnerPointDistanceByAxis(centerX, edgeX1, edgeX2);
        var disY = this.getInnerPointDistanceByAxis(centerY, edgeY1, edgeY2);
        return Math.sqrt(Math.pow(disX, 2) + Math.pow(disY, 2));
    };
    StarShapeDescription.prototype.getActualBottom = function (top, bottom, width, height) {
        var result = top + _super.prototype.calculateHeight.call(this, width) * height / width;
        return result < bottom ? result : bottom;
    };
    StarShapeDescription.prototype.calculateHeight = function (width) {
        return width;
    };
    return StarShapeDescription;
}(PentagonShapeDescription_1.PentagonShapeDescription));
exports.StarShapeDescription = StarShapeDescription;


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(54);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
var ArrowBottomShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowBottomShapeDescription, _super);
    function ArrowBottomShapeDescription() {
        return _super.call(this, "Bottom Arrow") || this;
    }
    Object.defineProperty(ArrowBottomShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowBottom; },
        enumerable: true,
        configurable: true
    });
    ArrowBottomShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(p1x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowBottomShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value - deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowBottomShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.size.height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    ArrowBottomShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var triangleHeight = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        if (point.y > shape.position.y + shape.size.height - triangleHeight) {
            var tg = shape.size.width / 2 / triangleHeight;
            var delta = (point.y - (shape.position.y + shape.size.height - triangleHeight)) * tg;
            var side = shape.getConnectionPointSide(index);
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.x -= delta;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.x += delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point, index);
    };
    return ArrowBottomShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowBottomShapeDescription = ArrowBottomShapeDescription;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(55);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ShapeType_1 = __webpack_require__(1);
var ArrowEastWestShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowEastWestShapeDescription, _super);
    function ArrowEastWestShapeDescription() {
        return _super.call(this, "East-West Arrow") || this;
    }
    Object.defineProperty(ArrowEastWestShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowEastWest; },
        enumerable: true,
        configurable: true
    });
    ArrowEastWestShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowEastWestShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width / 2 - 2 * Shape_1.Shape.lineWidth, p.value)); });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    ArrowEastWestShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowEastWestShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    return ArrowEastWestShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowEastWestShapeDescription = ArrowEastWestShapeDescription;


/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(55);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var ShapeType_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(3);
var ArrowLeftShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowLeftShapeDescription, _super);
    function ArrowLeftShapeDescription() {
        return _super.call(this, "Left Arrow") || this;
    }
    Object.defineProperty(ArrowLeftShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ArrowLeft; },
        enumerable: true,
        configurable: true
    });
    ArrowLeftShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ArrowLeftShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowLeftShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    ArrowLeftShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var triangleWidth = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        if (point.x < shape.position.x + triangleWidth) {
            var tg = shape.size.height / 2 / triangleWidth;
            var delta = (shape.position.x + triangleWidth - point.x) * tg;
            var side = shape.getConnectionPointSide(index);
            if (side === DiagramItem_1.ConnectionPointSide.North)
                point.y += delta;
            else if (side === DiagramItem_1.ConnectionPointSide.South)
                point.y -= delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point, index);
    };
    return ArrowLeftShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowLeftShapeDescription = ArrowLeftShapeDescription;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var DocumentShapeDescription_1 = __webpack_require__(80);
var ClipPathPrimitive_1 = __webpack_require__(52);
var Utils_1 = __webpack_require__(26);
var MultipleDocumentsShapeDescription = /** @class */ (function (_super) {
    __extends(MultipleDocumentsShapeDescription, _super);
    function MultipleDocumentsShapeDescription() {
        return _super.call(this, "Multiple Documents", "Multiple\nDocuments") || this;
    }
    Object.defineProperty(MultipleDocumentsShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.MultipleDocuments; },
        enumerable: true,
        configurable: true
    });
    MultipleDocumentsShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var documentOffsetX = width * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        var documentOffsetY = height * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        rect = rect.inflate(-documentOffsetX, -documentOffsetY).offset(-documentOffsetX, -documentOffsetY);
        var rect1 = rect.offset(documentOffsetX, documentOffsetY);
        var rect2 = rect.offset(2 * documentOffsetX, 2 * documentOffsetY);
        var clipPathId = Utils_1.RenderUtils.generateSvgElementId("clipRect");
        var primitives = [];
        return primitives
            .concat(this.createDocumentPrimitives(rect, shape.style, clipPathId + "1", rect1))
            .concat(this.createDocumentPrimitives(rect1, shape.style, clipPathId + "2", rect2))
            .concat(this.createDocumentPrimitives(rect2, shape.style))
            .concat(this.createTextPrimitives(shape));
    };
    MultipleDocumentsShapeDescription.prototype.createDocumentPrimitives = function (rect, style, clipPathId, clipRect) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DocumentShapeDescription_1.DocumentShapeDescription.curveOffsetRatio;
        var primitives = [];
        primitives = primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style, undefined, clipRect && clipPathId)
        ]);
        if (clipRect && clipPathId) {
            primitives = primitives.concat([
                new ClipPathPrimitive_1.ClipPathPrimitive(clipPathId, [
                    new PathPrimitive_1.PathPrimitive([
                        new PathPrimitive_1.PathPrimitiveMoveToCommand(left - Shape_1.Shape.lineWidth, top - Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(right + Shape_1.Shape.lineWidth, top - Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(right + Shape_1.Shape.lineWidth, clipRect.top),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(clipRect.left, clipRect.top),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(clipRect.left, bottom + Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(left - Shape_1.Shape.lineWidth, bottom + Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveClosePathCommand()
                    ])
                ])
            ]);
        }
        return primitives;
    };
    MultipleDocumentsShapeDescription.prototype.getTextRectangle = function (rect) {
        var documentOffsetX = rect.width * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        var documentOffsetY = rect.height * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        rect = rect.inflate(-documentOffsetX, -documentOffsetY).offset(-documentOffsetX, -documentOffsetY);
        var innerRect = rect.offset(2 * documentOffsetX, 2 * documentOffsetY);
        return innerRect.resize(0, -rect.height * DocumentShapeDescription_1.DocumentShapeDescription.curveOffsetRatio);
    };
    MultipleDocumentsShapeDescription.documentsOffsetRatio = 0.1;
    return MultipleDocumentsShapeDescription;
}(DocumentShapeDescription_1.DocumentShapeDescription));
exports.MultipleDocumentsShapeDescription = MultipleDocumentsShapeDescription;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(11);
var HexagonShapeDescription_1 = __webpack_require__(78);
var PreparationShapeDescription = /** @class */ (function (_super) {
    __extends(PreparationShapeDescription, _super);
    function PreparationShapeDescription() {
        var _this = _super.call(this, "Preparation", "Preparation") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75);
        return _this;
    }
    Object.defineProperty(PreparationShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Preparation; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PreparationShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    return PreparationShapeDescription;
}(HexagonShapeDescription_1.HexagonShapeDescription));
exports.PreparationShapeDescription = PreparationShapeDescription;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var EllipsePrimitive_1 = __webpack_require__(38);
var HardDiskShapeDescription = /** @class */ (function (_super) {
    __extends(HardDiskShapeDescription, _super);
    function HardDiskShapeDescription() {
        return _super.call(this, "Hard Disk", "Hard Disk") || this;
    }
    Object.defineProperty(HardDiskShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.HardDisk; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(HardDiskShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    HardDiskShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * HardDiskShapeDescription.arcWidthRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right - dx / 2, bottom),
            ], shape.style),
            new EllipsePrimitive_1.EllipsePrimitive(right - dx / 2, cy, dx / 2, (bottom - top) / 2, shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    HardDiskShapeDescription.prototype.getTextRectangle = function (rect) {
        var dx = rect.width * HardDiskShapeDescription.arcWidthRatio;
        return rect.resize(-dx, 0);
    };
    HardDiskShapeDescription.arcWidthRatio = 0.2;
    return HardDiskShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.HardDiskShapeDescription = HardDiskShapeDescription;


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var EllipsePrimitive_1 = __webpack_require__(38);
var DatabaseShapeDescription = /** @class */ (function (_super) {
    __extends(DatabaseShapeDescription, _super);
    function DatabaseShapeDescription() {
        var _this = _super.call(this, "Database", "Database") || this;
        _this.defaultSize.width = _this.defaultSize.height;
        return _this;
    }
    Object.defineProperty(DatabaseShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Database; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DatabaseShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    DatabaseShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DatabaseShapeDescription.arcWidthRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right, top + dy / 2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom - dy / 2),
                new PathPrimitive_1.PathPrimitiveArcToCommand((right - left) / 2, dy / 2, 0, false, true, left, bottom - dy / 2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, top + dy / 2),
            ], shape.style),
            new EllipsePrimitive_1.EllipsePrimitive(cx, top + dy / 2, (right - left) / 2, dy / 2, shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    DatabaseShapeDescription.prototype.getTextRectangle = function (rect) {
        var dy = rect.height * DatabaseShapeDescription.arcWidthRatio;
        return rect.resize(0, -dy).offset(0, dy);
    };
    DatabaseShapeDescription.arcWidthRatio = 0.2;
    return DatabaseShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DatabaseShapeDescription = DatabaseShapeDescription;


/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var ShapeParameters_1 = __webpack_require__(25);
var ShapeParameterPoint_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(0);
var PathPrimitive_1 = __webpack_require__(2);
exports.InternalStorageHorizontalEdgeParameterName = "he";
exports.InternalStorageVerticalEdgeParameterName = "ve";
var InternalStorageShapeDescription = /** @class */ (function (_super) {
    __extends(InternalStorageShapeDescription, _super);
    function InternalStorageShapeDescription() {
        return _super.call(this, "Internal Storage", "Internal\nStorage") || this;
    }
    Object.defineProperty(InternalStorageShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.InternalStorage; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(InternalStorageShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    InternalStorageShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var x = left + shape.parameters.get(exports.InternalStorageHorizontalEdgeParameterName).value;
        var y = top + shape.parameters.get(exports.InternalStorageVerticalEdgeParameterName).value;
        var primitives = _super.prototype.createPrimitives.call(this, shape);
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y)
            ], shape.style)
        ]);
    };
    InternalStorageShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.InternalStorageHorizontalEdgeParameterName, this.defaultSize.width * 0.1),
            new ShapeParameters_1.ShapeParameter(exports.InternalStorageVerticalEdgeParameterName, this.defaultSize.width * 0.1)
        ]);
    };
    InternalStorageShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.InternalStorageHorizontalEdgeParameterName, function (p) { return Math.max(InternalStorageShapeDescription.minEdge, Math.min(shape.size.width * 0.3, p.value)); });
        this.changeParameterValue(parameters, exports.InternalStorageVerticalEdgeParameterName, function (p) { return Math.max(InternalStorageShapeDescription.minEdge, Math.min(shape.size.height * 0.3, p.value)); });
    };
    InternalStorageShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.InternalStorageHorizontalEdgeParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, exports.InternalStorageVerticalEdgeParameterName, function (p) { return p.value + deltaY; });
        this.normalizeParameters(shape, parameters);
    };
    InternalStorageShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(exports.InternalStorageHorizontalEdgeParameterName).value), shape.normalizeY(shape.position.y + shape.parameters.get(exports.InternalStorageVerticalEdgeParameterName).value)))
        ];
    };
    InternalStorageShapeDescription.minEdge = 72;
    return InternalStorageShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.InternalStorageShapeDescription = InternalStorageShapeDescription;


/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(3);
var PaperTapeShapeDescription = /** @class */ (function (_super) {
    __extends(PaperTapeShapeDescription, _super);
    function PaperTapeShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Paper Tape"; }
        if (defaultText === void 0) { defaultText = "Paper Tape"; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(PaperTapeShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.PaperTape; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PaperTapeShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    PaperTapeShapeDescription.prototype.createPrimitives = function (shape) {
        var primitives = [];
        return primitives
            .concat(this.createDocumentPrimitives(shape.rectangle, shape.style))
            .concat(this.createTextPrimitives(shape));
    };
    PaperTapeShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * PaperTapeShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, top + 2 * dy, cx, top + dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, top - dy, right, top + dy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    PaperTapeShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
    };
    PaperTapeShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.inflate(0, -rect.height * PaperTapeShapeDescription.curveOffsetRatio);
    };
    PaperTapeShapeDescription.curveOffsetRatio = 0.1;
    return PaperTapeShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PaperTapeShapeDescription = PaperTapeShapeDescription;


/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(3);
var ManualOperationShapeDescription = /** @class */ (function (_super) {
    __extends(ManualOperationShapeDescription, _super);
    function ManualOperationShapeDescription() {
        return _super.call(this, "Manual Operation", "Manual\nOperation") || this;
    }
    Object.defineProperty(ManualOperationShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.ManualOperation; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ManualOperationShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    ManualOperationShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(ManualOperationShapeDescription.slopeAngle)), width);
        var cx = rect.center.x;
        var x1 = Math.min(left + px, cx);
        var x2 = Math.max(right - px, cx);
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    ManualOperationShapeDescription.prototype.processConnectionPoint = function (shape, point, index) {
        var offset = shape.size.height / Math.tan(ManualOperationShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(index);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    ManualOperationShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return ManualOperationShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ManualOperationShapeDescription = ManualOperationShapeDescription;


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DelayShapeDescription = /** @class */ (function (_super) {
    __extends(DelayShapeDescription, _super);
    function DelayShapeDescription() {
        var _this = _super.call(this, "Delay", "Delay") || this;
        _this.defaultSize.width = _this.defaultSize.height;
        return _this;
    }
    Object.defineProperty(DelayShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Delay; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DelayShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    DelayShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var cx = rect.center.x;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand((right - left) / 2, (bottom - top) / 2, 0, false, true, cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    DelayShapeDescription.arcWidthRatio = 0.2;
    return DelayShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DelayShapeDescription = DelayShapeDescription;


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var StoredDataShapeDescription = /** @class */ (function (_super) {
    __extends(StoredDataShapeDescription, _super);
    function StoredDataShapeDescription() {
        return _super.call(this, "Stored Data", "Stored Data") || this;
    }
    Object.defineProperty(StoredDataShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.StoredData; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(StoredDataShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    StoredDataShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * StoredDataShapeDescription.arcWidthRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, true, right, top)
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    StoredDataShapeDescription.prototype.getTextRectangle = function (rect) {
        var dx = rect.width * StoredDataShapeDescription.arcWidthRatio;
        return rect.resize(-dx, 0);
    };
    StoredDataShapeDescription.arcWidthRatio = 0.2;
    return StoredDataShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.StoredDataShapeDescription = StoredDataShapeDescription;


/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var TriangleShapeDescription_1 = __webpack_require__(79);
var PathPrimitive_1 = __webpack_require__(2);
var MergeShapeDescription = /** @class */ (function (_super) {
    __extends(MergeShapeDescription, _super);
    function MergeShapeDescription() {
        return _super.call(this, "Merge", "Merge") || this;
    }
    Object.defineProperty(MergeShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Merge; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MergeShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    MergeShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(rect.center.x, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ])
            .concat(this.createTextPrimitives(shape));
    };
    MergeShapeDescription.prototype.calculateHeight = function (width) {
        return width * 0.75;
    };
    MergeShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.resize(0, -rect.width * 0.25);
    };
    return MergeShapeDescription;
}(TriangleShapeDescription_1.TriangleShapeDescription));
exports.MergeShapeDescription = MergeShapeDescription;


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(12);
var ShapeType_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DisplayShapeDescription = /** @class */ (function (_super) {
    __extends(DisplayShapeDescription, _super);
    function DisplayShapeDescription() {
        return _super.call(this, "Display", "Display") || this;
    }
    Object.defineProperty(DisplayShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Display; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DisplayShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    DisplayShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * DisplayShapeDescription.arcWidthRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right - dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, right - dx / 2, top)
            ], shape.style),
        ])
            .concat(this.createTextPrimitives(shape));
    };
    DisplayShapeDescription.arcWidthRatio = 0.2;
    return DisplayShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DisplayShapeDescription = DisplayShapeDescription;


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(11);
var EllipseShapeDescription_1 = __webpack_require__(56);
var PathPrimitive_1 = __webpack_require__(2);
var OrShapeDescription = /** @class */ (function (_super) {
    __extends(OrShapeDescription, _super);
    function OrShapeDescription() {
        var _this = _super.call(this, "Or", "") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(OrShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.Or; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(OrShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(OrShapeDescription.prototype, "allowHasText", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    OrShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var primitives = [];
        return primitives
            .concat(_super.prototype.createPrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy)
            ], shape.style)
        ]);
    };
    return OrShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.OrShapeDescription = OrShapeDescription;


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(11);
var EllipseShapeDescription_1 = __webpack_require__(56);
var PathPrimitive_1 = __webpack_require__(2);
var SummingJunctionShapeDescription = /** @class */ (function (_super) {
    __extends(SummingJunctionShapeDescription, _super);
    function SummingJunctionShapeDescription() {
        var _this = _super.call(this, "Summing Junction", "") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "key", {
        get: function () { return ShapeType_1.ShapeType.SummingJunction; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "category", {
        get: function () { return ShapeType_1.ShapeCategory.Flowchart; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "allowHasText", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    SummingJunctionShapeDescription.prototype.createPrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var rx = width / 2;
        var ry = height / 2;
        var angle = Math.atan(ry / rx);
        var ex = 1 / Math.sqrt(1 / Math.pow(rx, 2) + Math.pow(Math.tan(angle), 2) / Math.pow(ry, 2));
        var ey = ex * Math.tan(angle);
        var primitives = [];
        return primitives
            .concat(_super.prototype.createPrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy - ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy - ey)
            ], shape.style)
        ]);
    };
    return SummingJunctionShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.SummingJunctionShapeDescription = SummingJunctionShapeDescription;


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var ShapeDescription_1 = __webpack_require__(11);
var ImagePrimitive_1 = __webpack_require__(150);
var Utils_1 = __webpack_require__(0);
var ConnectionPoint_1 = __webpack_require__(32);
var DiagramItem_1 = __webpack_require__(3);
var CustomShapeDescription = /** @class */ (function (_super) {
    __extends(CustomShapeDescription, _super);
    function CustomShapeDescription(shapeType, title, svgUrl, svgLeft, svgTop, svgWidth, svgHeight, defaultWidth, defaultHeight, defaultText, shapeAllowHasText, textLeft, textTop, textWidth, textHeight, shapeConnectionPoints, shapeCategory) {
        var _this = _super.call(this, title, defaultText, new Utils_1.Size(defaultWidth || 1440, defaultHeight || 1440)) || this;
        _this.shapeType = shapeType;
        _this.svgUrl = svgUrl;
        _this.svgLeft = svgLeft;
        _this.svgTop = svgTop;
        _this.svgWidth = svgWidth;
        _this.svgHeight = svgHeight;
        _this.shapeAllowHasText = shapeAllowHasText;
        _this.textLeft = textLeft;
        _this.textTop = textTop;
        _this.textWidth = textWidth;
        _this.textHeight = textHeight;
        _this.shapeConnectionPoints = shapeConnectionPoints;
        _this.shapeCategory = shapeCategory;
        _this.connectionPoints = _this.createConnectionPoints();
        return _this;
    }
    Object.defineProperty(CustomShapeDescription.prototype, "key", {
        get: function () { return this.shapeType; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "category", {
        get: function () { return this.shapeCategory || ShapeType_1.ShapeCategory.Custom; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "allowHasText", {
        get: function () { return !!this.shapeAllowHasText; },
        enumerable: true,
        configurable: true
    });
    CustomShapeDescription.prototype.createConnectionPoints = function () {
        if (this.shapeConnectionPoints && this.shapeConnectionPoints.length)
            return this.shapeConnectionPoints.map(function (ptObj) {
                if (ptObj && typeof ptObj["x"] === "number" && typeof ptObj["y"] === "number") {
                    var side = typeof ptObj["side"] === "number" ? ptObj["side"] : DiagramItem_1.ConnectionPointSide.Undefined;
                    return new ConnectionPoint_1.ConnectionPoint(ptObj["x"], ptObj["y"], side);
                }
            }).filter(function (pt) { return pt; });
        return _super.prototype.createConnectionPoints.call(this);
    };
    CustomShapeDescription.prototype.createPrimitives = function (shape, forToolbox) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
        var svgUrl = shape.description.svgUrl;
        var primitives = [];
        return primitives.concat([
            new ImagePrimitive_1.ImagePrimitive(left + (this.svgLeft && !forToolbox ? this.svgLeft * width : 0), top + (this.svgTop && !forToolbox ? this.svgTop * height : 0), this.svgWidth && !forToolbox ? this.svgWidth * width : width, this.svgHeight && !forToolbox ? this.svgHeight * height : height, svgUrl),
        ])
            .concat(this.createTextPrimitives(shape, forToolbox));
    };
    CustomShapeDescription.prototype.getTextRectangle = function (rect) {
        var left = rect.left, top = rect.top, width = rect.width, height = rect.height;
        return Utils_1.Rectangle.create(left + (this.textLeft ? this.textLeft * width : 0), top + (this.textTop ? this.textTop * height : 0), this.textWidth ? this.textWidth * width : width, this.textHeight ? this.textHeight * height : height);
    };
    return CustomShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.CustomShapeDescription = CustomShapeDescription;


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var ImagePrimitive = /** @class */ (function (_super) {
    __extends(ImagePrimitive, _super);
    function ImagePrimitive(x, y, width, height, url, preserveAspectRatio, style, className) {
        if (preserveAspectRatio === void 0) { preserveAspectRatio = "none"; }
        var _this = _super.call(this, style, className) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.url = url;
        _this.preserveAspectRatio = preserveAspectRatio;
        return _this;
    }
    ImagePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "image");
    };
    ImagePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        this.setUnitAttribute(element, "href", this.url);
        this.setUnitAttribute(element, "preserveAspectRatio", this.preserveAspectRatio);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return ImagePrimitive;
}(Primitive_1.SvgPrimitive));
exports.ImagePrimitive = ImagePrimitive;


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tree_1 = __webpack_require__(152);
var Forest = /** @class */ (function () {
    function Forest(trees) {
        this.trees = trees;
    }
    Forest.create = function (graph) {
        var components = graph.getConnectedComponents();
        return new Forest(components.map(Tree_1.Tree.createSpanningTree));
    };
    return Forest;
}());
exports.Forest = Forest;


/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Structures_1 = __webpack_require__(22);
var Tree = /** @class */ (function () {
    function Tree(root, parentToChildren) {
        var _this = this;
        this.childToParent = {};
        this.root = root;
        this.parentToChildren = parentToChildren;
        var _loop_1 = function (key) {
            if (!parentToChildren.hasOwnProperty(key))
                return "continue";
            parentToChildren[key].forEach(function (c) { return _this.childToParent[c.key] = key; });
        };
        for (var key in parentToChildren) {
            _loop_1(key);
        }
    }
    Tree.prototype.getChildren = function (node) {
        return node && this.parentToChildren[node.key] ? this.parentToChildren[node.key] : [];
    };
    Tree.prototype.hasChildren = function (node) {
        return this.parentToChildren[node.key] && this.parentToChildren[node.key].length > 0;
    };
    Tree.prototype.iterate = function (callback) {
        this.iterateCore(this.root, 0, callback);
    };
    Tree.createSpanningTree = function (component) {
        var rootKey = Tree.findRoot(component);
        var iterator = component.createIterator(Structures_1.ConnectionMode.Outgoing);
        var parentToChildren = {};
        iterator.skipEdge = (function (e) { return e.to === undefined || iterator.isNodeVisited(e.to); });
        iterator.onNode = function (n) { return parentToChildren[n.key] = []; };
        iterator.onEdge = function (e) { return parentToChildren[e.from].push(component.getNode(e.to)); };
        iterator.iterate(rootKey);
        return new Tree(component.getNode(rootKey), parentToChildren);
    };
    Tree.prototype.iterateCore = function (node, level, callback) {
        var _this = this;
        callback(node, level);
        this.getChildren(node).forEach(function (n) { return _this.iterateCore(n, level + 1, callback); });
    };
    Tree.findRoot = function (component) {
        return component.nodes.reduce(function (aggregator, cur) {
            var edges = component.getAdjacentEdges(cur);
            var inc = edges.filter(function (l) { return l.to === cur; }).length;
            var out = edges.filter(function (l) { return l.from === cur; }).length;
            if (aggregator.candidate === undefined || (inc === 0 && (aggregator.inc > 0 || aggregator.out < out)) || (inc > 0 && aggregator.out - aggregator.inc < out - inc)) {
                aggregator.candidate = cur;
                aggregator.inc = inc;
                aggregator.out = out;
            }
            return aggregator;
        }, { inc: -1, out: -1, candidate: undefined }).candidate;
    };
    return Tree;
}());
exports.Tree = Tree;


/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Graph_1 = __webpack_require__(34);
var Structures_1 = __webpack_require__(22);
var ListUtils_1 = __webpack_require__(60);
var CycleRemover = /** @class */ (function () {
    function CycleRemover() {
    }
    CycleRemover.removeCycles = function (graph) {
        var feedbackSet = this.getFeedbackSet(graph);
        return this.reverseEdges(graph, feedbackSet);
    };
    CycleRemover.getFeedbackSet = function (graph) {
        var _this = this;
        var feedbackSet = {};
        var nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(graph);
        while (nonTrivialStronglyConnectedComponents.length) {
            nonTrivialStronglyConnectedComponents.forEach(function (g) {
                var maxCyclicEdges = _this.getMaxCyclicEdges(g);
                maxCyclicEdges.forEach(function (e) { return delete feedbackSet[e.reverse().getHashKey()]; });
                maxCyclicEdges.forEach(function (e) { return feedbackSet[e.getHashKey()] = true; });
            });
            nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(this.reverseEdges(graph, feedbackSet).graph);
        }
        return feedbackSet;
    };
    CycleRemover.getMaxCyclicEdges = function (graph) {
        var black = {};
        var gray = {};
        var edgeCycleCount = {};
        var visitedEdges = [];
        var cycles = [];
        var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            gray[n.key] = true;
        };
        iterator.skipNode = function (n) {
            if (gray[n.key]) {
                var cycle = [];
                for (var i = 0; i < visitedEdges.length; i++) {
                    var e = visitedEdges[i];
                    if (edgeCycleCount[e.key] === undefined)
                        edgeCycleCount[e.key] = 0;
                    edgeCycleCount[e.key]++;
                    cycle.push(e);
                    if (e.from === n.key)
                        break;
                }
                cycles.push(cycle);
            }
            return gray[n.key] || black[n.key];
        };
        iterator.skipEdge = function (e) { return false; };
        iterator.onEdge = function (e) {
            visitedEdges.splice(0, 0, e);
        };
        iterator.onAfterEdge = function (e) {
            visitedEdges.splice(0, 1);
        };
        iterator.onAllEdges = function (e) {
            black[e.key] = true;
            gray[e.key] = false;
        };
        iterator.iterate(graph.nodes[0]);
        var edgeSet = new ListUtils_1.HashSet([], function (e) { return e.key; });
        cycles.forEach(function (c) {
            edgeSet.tryPush(c.reduce(function (max, curr) { return edgeCycleCount[curr.key] > edgeCycleCount[max.key] ? curr : max; }, c[0]));
        });
        return edgeSet.list();
    };
    CycleRemover.reverseEdges = function (graph, feedbackSet) {
        var edges = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        var reversedEdges = {};
        var removedEdges = {};
        graph.edges.forEach(function (e) {
            if (feedbackSet[e.getHashKey()]) {
                e = e.reverse();
                reversedEdges[e.key] = true;
            }
            if (!edges.tryPush(e)) {
                removedEdges[e.key] = true;
                delete reversedEdges[e.key];
            }
        });
        return {
            graph: new Graph_1.Graph(graph.nodes.map(function (n) { return graph.getNode(n); }), edges.list()),
            reversedEdges: reversedEdges,
            removedEdges: removedEdges
        };
    };
    CycleRemover.getNonTrivialStronglyConnectedComponents = function (graph) {
        return this.getStronglyConnectedComponents(graph).filter(function (g) { return g.edges.length; });
    };
    CycleRemover.getStronglyConnectedComponents = function (graph) {
        var _this = this;
        // Tarjan algorithm
        // https://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm
        var nodesStack = [];
        var index = 0;
        var lowIndex = {};
        var lowLink = {};
        var onStack = {};
        var components = [];
        var visitedNodes = {};
        for (var i = 0; i < graph.nodes.length; i++) {
            var nodeKey = graph.nodes[i];
            var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
            iterator.visitEachEdgeOnce = false;
            iterator.visitEachNodeOnce = false;
            iterator.onNode = function (n) {
                visitedNodes[n.key] = true;
                nodesStack.push(n);
                onStack[n.key] = true;
                lowLink[n.key] = index;
                lowIndex[n.key] = index;
                index++;
            };
            iterator.skipNode = function (n) { return visitedNodes[n.key]; };
            iterator.skipEdge = function (e) {
                var isVisited = visitedNodes[e.to];
                if (isVisited && onStack[e.to])
                    lowLink[e.from] = Math.min(lowLink[e.from], lowIndex[e.to]);
                return isVisited;
            };
            iterator.onAfterEdge = function (e) {
                lowLink[e.from] = Math.min(lowLink[e.from], lowLink[e.to]);
            };
            iterator.onAllEdges = function (n, outgoing) {
                if (outgoing && lowLink[n.key] === lowIndex[n.key])
                    components.push(_this.getStronglyConnectedComponent(graph, n, nodesStack, onStack));
            };
            iterator.iterate(nodeKey);
        }
        return components;
    };
    CycleRemover.getStronglyConnectedComponent = function (graph, root, nodesStack, onStack) {
        var itemsMap = {};
        var nodes = [];
        var edges = [];
        var topStackNode;
        do {
            topStackNode = nodesStack.pop();
            if (!itemsMap[topStackNode.key])
                nodes.push(topStackNode);
            itemsMap[topStackNode.key] = true;
            onStack[topStackNode.key] = false;
        } while (topStackNode !== root);
        nodes.forEach(function (n) {
            var aEdges = graph.getAdjacentEdges(n.key, Structures_1.ConnectionMode.Outgoing);
            edges.push.apply(edges, aEdges.filter(function (e) { return !itemsMap[e.key] && itemsMap[e.to]; }));
            aEdges.forEach(function (e) { return itemsMap[e.key] = true; });
        });
        return new Graph_1.Graph(nodes, edges);
    };
    return CycleRemover;
}());
exports.CycleRemover = CycleRemover;


/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CloneHistoryItem_1 = __webpack_require__(83);
var CloneShapeHistoryItem = /** @class */ (function (_super) {
    __extends(CloneShapeHistoryItem, _super);
    function CloneShapeHistoryItem(shape) {
        return _super.call(this, shape) || this;
    }
    CloneShapeHistoryItem.prototype.clearConnections = function (item) {
        item.attachedConnectors = [];
    };
    CloneShapeHistoryItem.prototype.addItem = function (item, manipulator) {
        manipulator.addShape(item);
    };
    CloneShapeHistoryItem.prototype.deleteItem = function (item, manipulator) {
        manipulator.deleteShape(item);
    };
    return CloneShapeHistoryItem;
}(CloneHistoryItem_1.CloneHistoryItem));
exports.CloneShapeHistoryItem = CloneShapeHistoryItem;


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var CloneHistoryItem_1 = __webpack_require__(83);
var CloneConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(CloneConnectorHistoryItem, _super);
    function CloneConnectorHistoryItem(connector, beginItem, endItem) {
        var _this = _super.call(this, connector) || this;
        _this.beginItem = beginItem;
        _this.endItem = endItem;
        return _this;
    }
    CloneConnectorHistoryItem.prototype.clearConnections = function (connector) {
        connector.beginItem = undefined;
        connector.endItem = undefined;
    };
    CloneConnectorHistoryItem.prototype.addItem = function (item, manipulator) {
        manipulator.addConnector(item);
        if (this.beginItem)
            manipulator.addConnection(item, this.beginItem, item.beginConnectionPointIndex, Connector_1.ConnectorPosition.Begin);
        if (this.endItem)
            manipulator.addConnection(item, this.endItem, item.endConnectionPointIndex, Connector_1.ConnectorPosition.End);
    };
    CloneConnectorHistoryItem.prototype.deleteItem = function (item, manipulator) {
        manipulator.deleteConnector(item);
    };
    return CloneConnectorHistoryItem;
}(CloneHistoryItem_1.CloneHistoryItem));
exports.CloneConnectorHistoryItem = CloneConnectorHistoryItem;


/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var UndoCommand = /** @class */ (function (_super) {
    __extends(UndoCommand, _super);
    function UndoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UndoCommand.prototype.executeCore = function (state) {
        this.control.history.undo();
        return true;
    };
    UndoCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(this.isEnabled() && this.control.history.canUndo());
    };
    return UndoCommand;
}(CommandBase_1.CommandBase));
exports.UndoCommand = UndoCommand;


/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var RedoCommand = /** @class */ (function (_super) {
    __extends(RedoCommand, _super);
    function RedoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RedoCommand.prototype.executeCore = function (state) {
        this.control.history.redo();
        return true;
    };
    RedoCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(this.isEnabled() && this.control.history.canRedo());
    };
    return RedoCommand;
}(CommandBase_1.CommandBase));
exports.RedoCommand = RedoCommand;


/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var Importer_1 = __webpack_require__(84);
var ImportCommand = /** @class */ (function (_super) {
    __extends(ImportCommand, _super);
    function ImportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    ImportCommand.prototype.executeCore = function (state, parameter) {
        var data = parameter["data"] ? parameter["data"] : parameter;
        if (parameter["keepExistingItems"] === true) {
            Importer_1.Importer.importItemsData(data, this.control.model);
            this.control.importItemsData();
        }
        else {
            var model = Importer_1.Importer.import(data);
            this.control.importModel(model);
        }
        return true;
    };
    return ImportCommand;
}(CommandBase_1.CommandBase));
exports.ImportCommand = ImportCommand;


/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var Exporter_1 = __webpack_require__(31);
var ExportCommand = /** @class */ (function (_super) {
    __extends(ExportCommand, _super);
    function ExportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    ExportCommand.prototype.executeCore = function (state, parameter) {
        var data = Exporter_1.Exporter.export(this.control.model);
        parameter(data);
        return true;
    };
    return ExportCommand;
}(CommandBase_1.CommandBase));
exports.ExportCommand = ExportCommand;


/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(41);
var ToggleFontBoldCommand = /** @class */ (function (_super) {
    __extends(ToggleFontBoldCommand, _super);
    function ToggleFontBoldCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontBoldCommand.prototype.getStyleProperty = function () {
        return "font-weight";
    };
    ToggleFontBoldCommand.prototype.getStylePropertyValue = function () {
        return "bold";
    };
    return ToggleFontBoldCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontBoldCommand = ToggleFontBoldCommand;


/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(41);
var ToggleFontItalicCommand = /** @class */ (function (_super) {
    __extends(ToggleFontItalicCommand, _super);
    function ToggleFontItalicCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontItalicCommand.prototype.getStyleProperty = function () {
        return "font-style";
    };
    ToggleFontItalicCommand.prototype.getStylePropertyValue = function () {
        return "italic";
    };
    return ToggleFontItalicCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontItalicCommand = ToggleFontItalicCommand;


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(41);
var ToggleFontUnderlineCommand = /** @class */ (function (_super) {
    __extends(ToggleFontUnderlineCommand, _super);
    function ToggleFontUnderlineCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontUnderlineCommand.prototype.getStyleProperty = function () {
        return "text-decoration";
    };
    ToggleFontUnderlineCommand.prototype.getStylePropertyValue = function () {
        return "underline";
    };
    return ToggleFontUnderlineCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontUnderlineCommand = ToggleFontUnderlineCommand;


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(62);
var ChangeFontNameCommand = /** @class */ (function (_super) {
    __extends(ChangeFontNameCommand, _super);
    function ChangeFontNameCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontNameCommand.prototype.getStyleProperty = function () {
        return "font-family";
    };
    return ChangeFontNameCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontNameCommand = ChangeFontNameCommand;


/***/ }),
/* 164 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(62);
var ChangeFontSizeCommand = /** @class */ (function (_super) {
    __extends(ChangeFontSizeCommand, _super);
    function ChangeFontSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontSizeCommand.prototype.getStyleProperty = function () {
        return "font-size";
    };
    return ChangeFontSizeCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontSizeCommand = ChangeFontSizeCommand;


/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(62);
var ChangeFontColorCommand = /** @class */ (function (_super) {
    __extends(ChangeFontColorCommand, _super);
    function ChangeFontColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFontColorCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontColorCommand = ChangeFontColorCommand;


/***/ }),
/* 166 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommand_1 = __webpack_require__(88);
var ChangeFillColorCommand = /** @class */ (function (_super) {
    __extends(ChangeFillColorCommand, _super);
    function ChangeFillColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFillColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFillColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeFillColorCommand = ChangeFillColorCommand;


/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommand_1 = __webpack_require__(88);
var ChangeStrokeColorCommand = /** @class */ (function (_super) {
    __extends(ChangeStrokeColorCommand, _super);
    function ChangeStrokeColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeColorCommand.prototype.getStyleProperty = function () {
        return "stroke";
    };
    return ChangeStrokeColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeColorCommand = ChangeStrokeColorCommand;


/***/ }),
/* 168 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DataSource_1 = __webpack_require__(37);
var ImportDataCommandBase_1 = __webpack_require__(89);
var ImportDataSourceCommand = /** @class */ (function (_super) {
    __extends(ImportDataSourceCommand, _super);
    function ImportDataSourceCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportDataSourceCommand.prototype.performImportData = function (parameter) {
        var dataSource = new DataSource_1.DataSource(parameter.key || "0", parameter.name, parameter.nodeDataSource, parameter.edgeDataSource, parameter.nodeDataImporter, parameter.edgeDataImporter);
        this.control.registerDataSource(dataSource);
        if (parameter.layoutType !== undefined) {
            this.createItems(dataSource, parameter.layoutType);
        }
    };
    return ImportDataSourceCommand;
}(ImportDataCommandBase_1.ImportDataCommandBase));
exports.ImportDataSourceCommand = ImportDataSourceCommand;


/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(41);
var ChangeTextAlignCommand = /** @class */ (function (_super) {
    __extends(ChangeTextAlignCommand, _super);
    function ChangeTextAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeTextAlignCommand.prototype.getStyleProperty = function () {
        return "text-anchor";
    };
    return ChangeTextAlignCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ChangeTextAlignCommand = ChangeTextAlignCommand;
var TextLeftAlignCommand = /** @class */ (function (_super) {
    __extends(TextLeftAlignCommand, _super);
    function TextLeftAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextLeftAlignCommand.prototype.getStylePropertyValue = function () {
        return "start";
    };
    return TextLeftAlignCommand;
}(ChangeTextAlignCommand));
exports.TextLeftAlignCommand = TextLeftAlignCommand;
var TextCenterAlignCommand = /** @class */ (function (_super) {
    __extends(TextCenterAlignCommand, _super);
    function TextCenterAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextCenterAlignCommand.prototype.getStylePropertyValue = function () {
        return "middle";
    };
    return TextCenterAlignCommand;
}(ChangeTextAlignCommand));
exports.TextCenterAlignCommand = TextCenterAlignCommand;
var TextRightAlignCommand = /** @class */ (function (_super) {
    __extends(TextRightAlignCommand, _super);
    function TextRightAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextRightAlignCommand.prototype.getStylePropertyValue = function () {
        return "end";
    };
    return TextRightAlignCommand;
}(ChangeTextAlignCommand));
exports.TextRightAlignCommand = TextRightAlignCommand;


/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeConnectorPropertyCommand_1 = __webpack_require__(90);
var ConnectorProperties_1 = __webpack_require__(28);
var ChangeConnectorStartLineEndingCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorStartLineEndingCommand, _super);
    function ChangeConnectorStartLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyName = function () {
        return "startLineEnding";
    };
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.None;
    };
    return ChangeConnectorStartLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorStartLineEndingCommand = ChangeConnectorStartLineEndingCommand;
var ChangeConnectorEndLineEndingCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorEndLineEndingCommand, _super);
    function ChangeConnectorEndLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyName = function () {
        return "endLineEnding";
    };
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.Arrow;
    };
    return ChangeConnectorEndLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorEndLineEndingCommand = ChangeConnectorEndLineEndingCommand;


/***/ }),
/* 171 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeConnectorPropertyCommand_1 = __webpack_require__(90);
var ConnectorProperties_1 = __webpack_require__(28);
var ChangeConnectorLineOptionCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorLineOptionCommand, _super);
    function ChangeConnectorLineOptionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorLineOptionCommand.prototype.getPropertyName = function () {
        return "lineOption";
    };
    ChangeConnectorLineOptionCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineOption.Straight;
    };
    return ChangeConnectorLineOptionCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorLineOptionCommand = ChangeConnectorLineOptionCommand;


/***/ }),
/* 172 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var SelectAllCommand = /** @class */ (function (_super) {
    __extends(SelectAllCommand, _super);
    function SelectAllCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SelectAllCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    SelectAllCommand.prototype.executeCore = function (state, parameter) {
        var itemKeys = [];
        this.control.model.iterateItems(function (i) { return itemKeys.push(i.key); });
        this.control.selection.set(itemKeys);
        return true;
    };
    return SelectAllCommand;
}(CommandBase_1.CommandBase));
exports.SelectAllCommand = SelectAllCommand;


/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AutoLayoutCommandBase_1 = __webpack_require__(43);
var WideTree_1 = __webpack_require__(61);
var LayoutSettings_1 = __webpack_require__(18);
var AutoLayoutTreeVerticalCommand = /** @class */ (function (_super) {
    __extends(AutoLayoutTreeVerticalCommand, _super);
    function AutoLayoutTreeVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalCommand.prototype.createLayout = function (graph) {
        var settings = this.createLayoutSettings();
        settings.orientation = LayoutSettings_1.OrientationKind.Vertical;
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeVerticalCommand = AutoLayoutTreeVerticalCommand;


/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var ChangeSnapToGridCommand = /** @class */ (function (_super) {
    __extends(ChangeSnapToGridCommand, _super);
    function ChangeSnapToGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeSnapToGridCommand.prototype.getPropertyName = function () {
        return "snapToGrid";
    };
    return ChangeSnapToGridCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeSnapToGridCommand = ChangeSnapToGridCommand;


/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangePagePropertyHistoryItem = /** @class */ (function (_super) {
    __extends(ChangePagePropertyHistoryItem, _super);
    function ChangePagePropertyHistoryItem(propertyName, value) {
        var _this = _super.call(this) || this;
        _this.propertyName = propertyName;
        _this.value = value;
        return _this;
    }
    ChangePagePropertyHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model[this.propertyName];
        manipulator.changePageProperty(this.propertyName, this.value);
    };
    ChangePagePropertyHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageProperty(this.propertyName, this.oldValue);
    };
    return ChangePagePropertyHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePagePropertyHistoryItem = ChangePagePropertyHistoryItem;


/***/ }),
/* 176 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var ChangeGridSizeCommand = /** @class */ (function (_super) {
    __extends(ChangeGridSizeCommand, _super);
    function ChangeGridSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeGridSizeCommand.prototype.getPropertyName = function () {
        return "gridSize";
    };
    ChangeGridSizeCommand.prototype.getPropertyOptions = function () {
        return [
            { value: 90, text: this.control.model.getModelUnitText(90) },
            { value: 180, text: this.control.model.getModelUnitText(180) },
            { value: 360, text: this.control.model.getModelUnitText(360) },
            { value: 720, text: this.control.model.getModelUnitText(720) }
        ];
    };
    return ChangeGridSizeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeGridSizeCommand = ChangeGridSizeCommand;


/***/ }),
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var ChangePageLandscapeHistoryItem_1 = __webpack_require__(178);
var ChangePageLandscapeCommand = /** @class */ (function (_super) {
    __extends(ChangePageLandscapeCommand, _super);
    function ChangePageLandscapeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageLandscapeCommand.prototype.getPropertyName = function () {
        return "pageLandscape";
    };
    ChangePageLandscapeCommand.prototype.createHistoryItems = function (propertyName, parameter) {
        return [new ChangePageLandscapeHistoryItem_1.ChangePageLandscapeHistoryItem(parameter)];
    };
    return ChangePageLandscapeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageLandscapeCommand = ChangePageLandscapeCommand;


/***/ }),
/* 178 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangePageLandscapeHistoryItem = /** @class */ (function (_super) {
    __extends(ChangePageLandscapeHistoryItem, _super);
    function ChangePageLandscapeHistoryItem(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    ChangePageLandscapeHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model.pageLandscape;
        manipulator.changePageLandscape(this.value);
    };
    ChangePageLandscapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageLandscape(this.oldValue);
    };
    return ChangePageLandscapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageLandscapeHistoryItem = ChangePageLandscapeHistoryItem;


/***/ }),
/* 179 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var Utils_1 = __webpack_require__(0);
var ChangePageSizeHistoryItem_1 = __webpack_require__(180);
var ChangePageSizeCommand = /** @class */ (function (_super) {
    __extends(ChangePageSizeCommand, _super);
    function ChangePageSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageSizeCommand.prototype.getPropertyName = function () {
        return "pageSize";
    };
    ChangePageSizeCommand.prototype.createHistoryItems = function (propertyName, parameter) {
        return [new ChangePageSizeHistoryItem_1.ChangePageSizeHistoryItem(new Utils_1.Size(parameter.width, parameter.height))];
    };
    ChangePageSizeCommand.prototype.getPropertyOptions = function () {
        return [
            { value: new Utils_1.Size(12240, 15840), text: "US-Letter (" + this.control.model.getModelUnitText(12240) + " x " + this.control.model.getModelUnitText(15840) + ")" },
            { value: new Utils_1.Size(12240, 20160), text: "US-Legal (" + this.control.model.getModelUnitText(12240) + " x " + this.control.model.getModelUnitText(20160) + ")" },
            { value: new Utils_1.Size(15817, 24491), text: "US-Tabloid (" + this.control.model.getModelUnitText(15817) + " x " + this.control.model.getModelUnitText(24491) + ")" },
            { value: new Utils_1.Size(47679, 67408), text: "A0 (" + this.control.model.getModelUnitText(47679) + " x " + this.control.model.getModelUnitText(67408) + ")" },
            { value: new Utils_1.Size(33676, 47679), text: "A1 (" + this.control.model.getModelUnitText(33676) + " x " + this.control.model.getModelUnitText(47679) + ")" },
            { value: new Utils_1.Size(23811, 33676), text: "A2 (" + this.control.model.getModelUnitText(23811) + " x " + this.control.model.getModelUnitText(33676) + ")" },
            { value: new Utils_1.Size(16838, 23811), text: "A3 (" + this.control.model.getModelUnitText(16838) + " x " + this.control.model.getModelUnitText(23811) + ")" },
            { value: new Utils_1.Size(11906, 16838), text: "A4 (" + this.control.model.getModelUnitText(11906) + " x " + this.control.model.getModelUnitText(16838) + ")" },
            { value: new Utils_1.Size(8391, 11906), text: "A5 (" + this.control.model.getModelUnitText(8391) + " x " + this.control.model.getModelUnitText(11906) + ")" },
            { value: new Utils_1.Size(5953, 8391), text: "A6 (" + this.control.model.getModelUnitText(5953) + " x " + this.control.model.getModelUnitText(8391) + ")" },
            { value: new Utils_1.Size(4195, 5953), text: "A7 (" + this.control.model.getModelUnitText(4195) + " x " + this.control.model.getModelUnitText(5953) + ")" },
        ];
    };
    return ChangePageSizeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageSizeCommand = ChangePageSizeCommand;


/***/ }),
/* 180 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangePageSizeHistoryItem = /** @class */ (function (_super) {
    __extends(ChangePageSizeHistoryItem, _super);
    function ChangePageSizeHistoryItem(size) {
        var _this = _super.call(this) || this;
        _this.size = size;
        return _this;
    }
    ChangePageSizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.pageSize;
        manipulator.changePageSize(this.size);
    };
    ChangePageSizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageSize(this.oldSize);
    };
    return ChangePageSizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageSizeHistoryItem = ChangePageSizeHistoryItem;


/***/ }),
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Exporter_1 = __webpack_require__(31);
var ExportImageCommand_1 = __webpack_require__(64);
var ExportPngCommand = /** @class */ (function (_super) {
    __extends(ExportPngCommand, _super);
    function ExportPngCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportPngCommand.prototype.getExportFunc = function () {
        return Exporter_1.Exporter.exportPng;
    };
    return ExportPngCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportPngCommand = ExportPngCommand;


/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var PatternPrimitive = /** @class */ (function (_super) {
    __extends(PatternPrimitive, _super);
    function PatternPrimitive(id, children, x, y, width, height) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.children = children;
        return _this;
    }
    PatternPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "pattern");
    };
    PatternPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return PatternPrimitive;
}(Primitive_1.SvgPrimitive));
exports.PatternPrimitive = PatternPrimitive;


/***/ }),
/* 183 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var GroupPrimitive = /** @class */ (function (_super) {
    __extends(GroupPrimitive, _super);
    function GroupPrimitive(children, className, zIndex) {
        var _this = _super.call(this, null, className) || this;
        _this.zIndex = zIndex;
        _this.children = children;
        return _this;
    }
    GroupPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "g");
    };
    GroupPrimitive.prototype.applyElementProperties = function (element) {
        if (this.zIndex)
            element.style.setProperty("z-index", this.zIndex.toString());
        _super.prototype.applyElementProperties.call(this, element);
    };
    return GroupPrimitive;
}(Primitive_1.SvgPrimitive));
exports.GroupPrimitive = GroupPrimitive;


/***/ }),
/* 184 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(10);
var Primitive_1 = __webpack_require__(15);
var MaskPrimitive = /** @class */ (function (_super) {
    __extends(MaskPrimitive, _super);
    function MaskPrimitive(id, children, className, x, y, width, height) {
        var _this = _super.call(this, null, className) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.children = children;
        return _this;
    }
    MaskPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "mask");
    };
    MaskPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return MaskPrimitive;
}(Primitive_1.SvgPrimitive));
exports.MaskPrimitive = MaskPrimitive;


/***/ }),
/* 185 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Exporter_1 = __webpack_require__(31);
var ExportImageCommand_1 = __webpack_require__(64);
var ExportSvgCommand = /** @class */ (function (_super) {
    __extends(ExportSvgCommand, _super);
    function ExportSvgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportSvgCommand.prototype.getExportFunc = function () {
        return Exporter_1.Exporter.exportSvg;
    };
    return ExportSvgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportSvgCommand = ExportSvgCommand;


/***/ }),
/* 186 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Exporter_1 = __webpack_require__(31);
var ExportImageCommand_1 = __webpack_require__(64);
var ExportJpgCommand = /** @class */ (function (_super) {
    __extends(ExportJpgCommand, _super);
    function ExportJpgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportJpgCommand.prototype.getExportFunc = function () {
        return Exporter_1.Exporter.exportJpg;
    };
    return ExportJpgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportJpgCommand = ExportJpgCommand;


/***/ }),
/* 187 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandStates_1 = __webpack_require__(6);
var Exporter_1 = __webpack_require__(31);
var ClipboardCommand_1 = __webpack_require__(65);
var CopySelectionCommand = /** @class */ (function (_super) {
    __extends(CopySelectionCommand, _super);
    function CopySelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CopySelectionCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty(true));
    };
    CopySelectionCommand.prototype.executeCore = function (state) {
        var data = Exporter_1.Exporter.exportItems(this.control.selection.getSelectedItems());
        this.setClipboardData(data);
        return true;
    };
    return CopySelectionCommand;
}(ClipboardCommand_1.ClipboardCommand));
exports.CopySelectionCommand = CopySelectionCommand;


/***/ }),
/* 188 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandStates_1 = __webpack_require__(6);
var Exporter_1 = __webpack_require__(31);
var ModelUtils_1 = __webpack_require__(8);
var ClipboardCommand_1 = __webpack_require__(65);
var CutSelectionCommand = /** @class */ (function (_super) {
    __extends(CutSelectionCommand, _super);
    function CutSelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CutSelectionCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty());
    };
    CutSelectionCommand.prototype.executeCore = function (state) {
        var data = Exporter_1.Exporter.exportItems(this.control.selection.getSelectedItems());
        this.setClipboardData(data);
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        return true;
    };
    return CutSelectionCommand;
}(ClipboardCommand_1.ClipboardCommand));
exports.CutSelectionCommand = CutSelectionCommand;


/***/ }),
/* 189 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandStates_1 = __webpack_require__(6);
var Importer_1 = __webpack_require__(84);
var Shape_1 = __webpack_require__(9);
var ImportShapeHistoryItem_1 = __webpack_require__(190);
var Connector_1 = __webpack_require__(5);
var ImportConnectorHistoryItem_1 = __webpack_require__(191);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var ClipboardCommand_1 = __webpack_require__(65);
var UnitConverter_1 = __webpack_require__(13);
var ModelUtils_1 = __webpack_require__(8);
var Browser_1 = __webpack_require__(20);
var PasteSelectionCommand = /** @class */ (function (_super) {
    __extends(PasteSelectionCommand, _super);
    function PasteSelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(Browser_1.Browser.IE || (Browser_1.Browser.WebKitFamily && navigator && navigator["clipboard"] !== undefined));
    };
    PasteSelectionCommand.prototype.executeCore = function (state) {
        var _this = this;
        this.getClipboardData(function (data) {
            _this.performPaste(data);
        });
        return true;
    };
    PasteSelectionCommand.prototype.performPaste = function (data) {
        this.control.beginUpdate();
        this.control.history.beginTransaction();
        var ids = [];
        var items = Importer_1.Importer.importItems(data, this.control.model);
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item instanceof Shape_1.Shape) {
                while (this.control.model.findShapeAtPosition(item.position)) {
                    item.position.x += PasteSelectionCommand.positionOffset;
                    item.position.y += PasteSelectionCommand.positionOffset;
                }
                this.control.history.addOrModifyAndRedo(new ImportShapeHistoryItem_1.ImportShapeHistoryItem(item));
            }
            else if (item instanceof Connector_1.Connector) {
                while (this.control.model.findConnectorAtPoints(item.points)) {
                    item.points.forEach(function (pt) {
                        pt.x += PasteSelectionCommand.positionOffset;
                        pt.y += PasteSelectionCommand.positionOffset;
                    });
                }
                this.control.history.addOrModifyAndRedo(new ImportConnectorHistoryItem_1.ImportConnectorHistoryItem(item));
            }
            ids.push(item.key);
        }
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.addOrModifyAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.control.selection, ids));
        this.control.history.endTransaction();
        this.control.endUpdate();
    };
    PasteSelectionCommand.positionOffset = UnitConverter_1.UnitConverter.pixelsToTwips(10);
    return PasteSelectionCommand;
}(ClipboardCommand_1.ClipboardCommand));
exports.PasteSelectionCommand = PasteSelectionCommand;


/***/ }),
/* 190 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ImportShapeHistoryItem = /** @class */ (function (_super) {
    __extends(ImportShapeHistoryItem, _super);
    function ImportShapeHistoryItem(shape) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        return _this;
    }
    ImportShapeHistoryItem.prototype.redo = function (manipulator) {
        this.shapeKey = this.shape.key;
        manipulator.insertShape(this.shape);
    };
    ImportShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.removeShape(manipulator.model.findShape(this.shapeKey));
    };
    return ImportShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ImportShapeHistoryItem = ImportShapeHistoryItem;


/***/ }),
/* 191 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ImportConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(ImportConnectorHistoryItem, _super);
    function ImportConnectorHistoryItem(connector) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        return _this;
    }
    ImportConnectorHistoryItem.prototype.redo = function (manipulator) {
        this.connectorKey = this.connector.key;
        manipulator.insertConnector(this.connector);
    };
    ImportConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.removeConnector(connector);
    };
    return ImportConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ImportConnectorHistoryItem = ImportConnectorHistoryItem;


/***/ }),
/* 192 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var BPMNImporter_1 = __webpack_require__(193);
var LayoutUtils_1 = __webpack_require__(59);
var ModelUtils_1 = __webpack_require__(8);
var AddShapeHistoryItem_1 = __webpack_require__(51);
var Utils_1 = __webpack_require__(0);
var Connector_1 = __webpack_require__(5);
var AddConnectorHistoryItem_1 = __webpack_require__(58);
var AddConnectionHistoryItem_1 = __webpack_require__(35);
var Structures_1 = __webpack_require__(22);
var Sugiyama_1 = __webpack_require__(40);
var LayoutSettings_1 = __webpack_require__(18);
var ImportBPMNCommand = /** @class */ (function (_super) {
    __extends(ImportBPMNCommand, _super);
    function ImportBPMNCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportBPMNCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    ImportBPMNCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        var parser = new DOMParser();
        var doc = parser.parseFromString(parameter, "application/xml");
        var importer = new BPMNImporter_1.BPMNImporter(doc);
        var externalKeyToModelKey = {};
        var connectors = [];
        var graph = importer.import()
            .cast(function (node) {
            var insert = new AddShapeHistoryItem_1.AddShapeHistoryItem(node.type, new Utils_1.Point(0, 0), node.text, node.key);
            _this.control.history.addAndRedo(insert);
            externalKeyToModelKey[node.key] = insert.shapeKey;
            return LayoutUtils_1.LayoutUtils.shapeToLayout(_this.control.model.findShape(insert.shapeKey));
        }, function (edge) {
            var from = _this.control.model.findShape(externalKeyToModelKey[edge.from]);
            var to = _this.control.model.findShape(externalKeyToModelKey[edge.to]);
            var insert = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([from.getConnectionPoint(0), to.getConnectionPoint(0)]);
            _this.control.history.addAndRedo(insert);
            var connector = _this.control.model.findConnector(insert.connectorKey);
            connectors.push(connector);
            _this.control.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, from, 0, Connector_1.ConnectorPosition.Begin));
            _this.control.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, to, 0, Connector_1.ConnectorPosition.End));
            return new Structures_1.Edge(connector.key, from.key, to.key);
        });
        var layout = new Sugiyama_1.SugiyamaLayoutBuilder(new LayoutSettings_1.LayoutSettings(), graph).build();
        var nonGraphItems = ModelUtils_1.ModelUtils.getSymmetricDifference(layout.nodeToLayout, this.control.model.items);
        layout = ModelUtils_1.ModelUtils.offsetLayoutToFreeSpace(layout, nonGraphItems.map(function (i) { return i.rectangle; }));
        ModelUtils_1.ModelUtils.applyLayoutToNodes(this.control.history, this.control.model, layout, connectors);
        ModelUtils_1.ModelUtils.applyLayoutToConnectors(this.control.history, layout, connectors);
        // set selection
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        return true;
    };
    return ImportBPMNCommand;
}(CommandBase_1.CommandBase));
exports.ImportBPMNCommand = ImportBPMNCommand;


/***/ }),
/* 193 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Graph_1 = __webpack_require__(34);
var ShapeType_1 = __webpack_require__(1);
var Structures_1 = __webpack_require__(22);
var BPMNImporter = /** @class */ (function () {
    function BPMNImporter(doc) {
        this.doc = doc;
        this.graph = new Graph_1.Graph([], []);
    }
    BPMNImporter.prototype.import = function () {
        for (var child = void 0, i = 0; child = this.doc.children[i]; i++) {
            if (child.nodeName.toUpperCase() === "DEFINITIONS")
                this.onDefinitionsElement(child);
        }
        this.validate();
        return this.graph;
    };
    BPMNImporter.prototype.validate = function () {
        var nodesMap = {};
        this.graph.nodes.forEach(function (n) { return nodesMap[n] = true; });
        for (var i = 0, edge = void 0; edge = this.graph.edges[i]; i++) {
            if (!nodesMap[edge.from] || !nodesMap[edge.to]) {
                this.graph.edges.splice(i, 1);
                i--;
            }
        }
    };
    BPMNImporter.prototype.onDefinitionsElement = function (element) {
        this.dataSourceKey = element.getAttribute("id");
        for (var child = void 0, i = 0; child = element.children[i]; i++) {
            if (child.nodeName.toUpperCase() === "PROCESS")
                this.onProcessElement(child);
        }
    };
    BPMNImporter.prototype.onProcessElement = function (element) {
        for (var child = void 0, i = 0; child = element.children[i]; i++) {
            switch (child.nodeName.toUpperCase()) {
                case "STARTEVENT":
                    this.onStartEventElement(child);
                    break;
                case "SEQUENCEFLOW":
                    this.onSequenceFlowElement(child);
                    break;
                case "SCRIPTTASK":
                    this.onScriptTaskElement(child);
                    break;
                case "USERTASK":
                    this.onUserTaskElement(child);
                    break;
                case "SERVICETASK":
                    this.onServiceTaskElement(child);
                    break;
                case "SENDTASK":
                    this.onSendTaskElement(child);
                    break;
                case "EXCLUSIVEGATEWAY":
                    this.onExclusiveGateway(child);
                    break;
                case "ENDEVENT":
                    this.onEndEventGateway(child);
                    break;
            }
        }
    };
    BPMNImporter.prototype.onStartEventElement = function (element) {
        var node = this.createNode(element);
        node.type = ShapeType_1.ShapeType.Ellipsis;
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onSequenceFlowElement = function (element) {
        var fromKey = element.getAttribute("sourceRef");
        var toKey = element.getAttribute("targetRef");
        var edge = this.createEdge(element, fromKey, toKey);
        if (element.hasAttribute("name"))
            edge.text = element.getAttribute("name");
        this.graph.addEdge(edge);
    };
    BPMNImporter.prototype.onScriptTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onUserTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onServiceTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onSendTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onExclusiveGateway = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        node.type = ShapeType_1.ShapeType.Decision;
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onEndEventGateway = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        node.type = ShapeType_1.ShapeType.Ellipsis;
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.createNode = function (element) {
        return new BPMNNode(this.dataSourceKey, element.getAttribute("id"));
    };
    BPMNImporter.prototype.createEdge = function (element, fromKey, toKey) {
        return new BPMNEdge(this.dataSourceKey, element.getAttribute("id"), fromKey, toKey);
    };
    return BPMNImporter;
}());
exports.BPMNImporter = BPMNImporter;
var BPMNNode = /** @class */ (function () {
    function BPMNNode(sourceKey, key) {
        this.sourceKey = sourceKey;
        this.key = key;
        this.type = ShapeType_1.ShapeType.Rectangle;
    }
    return BPMNNode;
}());
var BPMNEdge = /** @class */ (function (_super) {
    __extends(BPMNEdge, _super);
    function BPMNEdge(sourceKey, key, fromKey, toKey) {
        var _this = _super.call(this, key, fromKey, toKey) || this;
        _this.sourceKey = sourceKey;
        return _this;
    }
    return BPMNEdge;
}(Structures_1.Edge));


/***/ }),
/* 194 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ChangeZindexHistoryItem_1 = __webpack_require__(93);
var SendToBackCommand = /** @class */ (function (_super) {
    __extends(SendToBackCommand, _super);
    function SendToBackCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SendToBackCommand.prototype.getState = function () {
        var items = this.control.selection.getSelectedItems();
        return new CommandStates_1.SimpleCommandState(items.length && this.needSendToBack(items));
    };
    SendToBackCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMinZIndex(item) - 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    SendToBackCommand.prototype.needSendToBack = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMinZIndex(items[i]);
            if (zIndex < items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) < _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return SendToBackCommand;
}(CommandBase_1.CommandBase));
exports.SendToBackCommand = SendToBackCommand;


/***/ }),
/* 195 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ChangeZindexHistoryItem_1 = __webpack_require__(93);
var BringToFrontCommand = /** @class */ (function (_super) {
    __extends(BringToFrontCommand, _super);
    function BringToFrontCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BringToFrontCommand.prototype.getState = function () {
        var items = this.control.selection.getSelectedItems();
        return new CommandStates_1.SimpleCommandState(items.length && this.needBringToFront(items));
    };
    BringToFrontCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMaxZIndex(item) + 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    BringToFrontCommand.prototype.needBringToFront = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMaxZIndex(items[i]);
            if (zIndex > items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) > _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return BringToFrontCommand;
}(CommandBase_1.CommandBase));
exports.BringToFrontCommand = BringToFrontCommand;


/***/ }),
/* 196 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AutoLayoutCommandBase_1 = __webpack_require__(43);
var Sugiyama_1 = __webpack_require__(40);
var LayoutSettings_1 = __webpack_require__(18);
var AutoLayoutLayeredHorizontalCommand = /** @class */ (function (_super) {
    __extends(AutoLayoutLayeredHorizontalCommand, _super);
    function AutoLayoutLayeredHorizontalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredHorizontalCommand.prototype.createLayout = function (graph) {
        var settings = this.createLayoutSettings();
        settings.orientation = LayoutSettings_1.OrientationKind.Horizontal;
        return new Sugiyama_1.SugiyamaLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutLayeredHorizontalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutLayeredHorizontalCommand = AutoLayoutLayeredHorizontalCommand;


/***/ }),
/* 197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var Utils_1 = __webpack_require__(0);
var ModelUtils_1 = __webpack_require__(8);
var UnitConverter_1 = __webpack_require__(13);
var MoveCommand = /** @class */ (function (_super) {
    __extends(MoveCommand, _super);
    function MoveCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty());
    };
    MoveCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var shapes = this.control.selection.getSelectedShapes();
        shapes.forEach(function (shape, index) {
            var pos = _this.getPosition(shape.position);
            ModelUtils_1.ModelUtils.setShapePosition(_this.control.history, _this.control.model, shape.key, pos, _this.control.history.addOrModifyAndRedo);
            shape.attachedConnectors.forEach(function (connector) {
                ModelUtils_1.ModelUtils.removeConnectorIntermediatePoints(_this.control.history, connector);
                ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(_this.control.history, connector, _this.control.history.addOrModifyAndRedo);
            });
        });
        var connectors = this.control.selection.getSelectedConnectors();
        connectors.forEach(function (connector, index) {
            var startPtIndex = connector.beginItem ? 1 : 0;
            var endPtIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
            for (var i = startPtIndex; i <= endPtIndex; i++) {
                var pos = _this.getPosition(connector.points[i]);
                ModelUtils_1.ModelUtils.setConnectorPoint(_this.control.history, _this.control.model, connector.key, i, pos, _this.control.history.addOrModifyAndRedo);
            }
        });
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.endTransaction();
        return true;
    };
    return MoveCommand;
}(CommandBase_1.CommandBase));
exports.MoveCommand = MoveCommand;
var MoveLeftCommand = /** @class */ (function (_super) {
    __extends(MoveLeftCommand, _super);
    function MoveLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveLeftCommand.prototype.getPosition = function (position) {
        return position.offset(-UnitConverter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveLeftCommand;
}(MoveCommand));
exports.MoveLeftCommand = MoveLeftCommand;
var MoveStepLeftCommand = /** @class */ (function (_super) {
    __extends(MoveStepLeftCommand, _super);
    function MoveStepLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepLeftCommand.prototype.getPosition = function (position) {
        if (this.control.model.snapToGrid)
            return new Utils_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, position.x - (this.control.model.gridSize / 2 + 2)), position.y);
        else
            return position.offset(-this.control.model.gridSize, 0);
    };
    return MoveStepLeftCommand;
}(MoveCommand));
exports.MoveStepLeftCommand = MoveStepLeftCommand;
var MoveRightCommand = /** @class */ (function (_super) {
    __extends(MoveRightCommand, _super);
    function MoveRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveRightCommand.prototype.getPosition = function (position) {
        return position.offset(UnitConverter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveRightCommand;
}(MoveCommand));
exports.MoveRightCommand = MoveRightCommand;
var MoveStepRightCommand = /** @class */ (function (_super) {
    __extends(MoveStepRightCommand, _super);
    function MoveStepRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepRightCommand.prototype.getPosition = function (position) {
        if (this.control.model.snapToGrid)
            return new Utils_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, position.x + (this.control.model.gridSize / 2 + 2)), position.y);
        else
            return position.offset(this.control.model.gridSize, 0);
    };
    return MoveStepRightCommand;
}(MoveCommand));
exports.MoveStepRightCommand = MoveStepRightCommand;
var MoveUpCommand = /** @class */ (function (_super) {
    __extends(MoveUpCommand, _super);
    function MoveUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveUpCommand.prototype.getPosition = function (position) {
        return position.offset(0, -UnitConverter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveUpCommand;
}(MoveCommand));
exports.MoveUpCommand = MoveUpCommand;
var MoveStepUpCommand = /** @class */ (function (_super) {
    __extends(MoveStepUpCommand, _super);
    function MoveStepUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepUpCommand.prototype.getPosition = function (position) {
        if (this.control.model.snapToGrid)
            return new Utils_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, position.y - (this.control.model.gridSize / 2 + 2)));
        else
            return position.offset(0, -this.control.model.gridSize);
    };
    return MoveStepUpCommand;
}(MoveCommand));
exports.MoveStepUpCommand = MoveStepUpCommand;
var MoveDownCommand = /** @class */ (function (_super) {
    __extends(MoveDownCommand, _super);
    function MoveDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveDownCommand.prototype.getPosition = function (position) {
        return position.offset(0, UnitConverter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveDownCommand;
}(MoveCommand));
exports.MoveDownCommand = MoveDownCommand;
var MoveStepDownCommand = /** @class */ (function (_super) {
    __extends(MoveStepDownCommand, _super);
    function MoveStepDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepDownCommand.prototype.getPosition = function (position) {
        if (this.control.model.snapToGrid)
            return new Utils_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, position.y + (this.control.model.gridSize / 2 + 2)));
        else
            return position.offset(0, this.control.model.gridSize);
    };
    return MoveStepDownCommand;
}(MoveCommand));
exports.MoveStepDownCommand = MoveStepDownCommand;


/***/ }),
/* 198 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var ChangeZoomLevelCommand = /** @class */ (function (_super) {
    __extends(ChangeZoomLevelCommand, _super);
    function ChangeZoomLevelCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelCommand.prototype.getPropertyName = function () {
        return "zoomLevel";
    };
    ChangeZoomLevelCommand.prototype.createHistoryItems = function (propertyName, parameter) {
        var result = _super.prototype.createHistoryItems.call(this, propertyName, parameter);
        return result.concat([new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.control.selection, [])]);
    };
    ChangeZoomLevelCommand.prototype.getPropertyOptions = function () {
        return [
            { value: 0.5, text: "50%" },
            { value: 0.75, text: "75%" },
            { value: 1, text: "100%" },
            { value: 1.25, text: "125%" },
            { value: 1.5, text: "150%" },
            { value: 2, text: "200%" },
            { value: 3, text: "300%" }
        ];
    };
    return ChangeZoomLevelCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeZoomLevelCommand = ChangeZoomLevelCommand;


/***/ }),
/* 199 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(8);
var ImportDataCommandBase_1 = __webpack_require__(89);
var DocumentDataSource_1 = __webpack_require__(200);
var BindDocumentCommand = /** @class */ (function (_super) {
    __extends(BindDocumentCommand, _super);
    function BindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BindDocumentCommand.prototype.performImportData = function (parameter) {
        var dataSource = new DocumentDataSource_1.DocumentDataSource(parameter.nodeDataSource, parameter.edgeDataSource, parameter.nodeDataImporter, parameter.edgeDataImporter);
        this.control.registerDocumentDataSource(dataSource);
        if (parameter.layoutType !== undefined) {
            this.control.history.beginTransaction();
            ModelUtils_1.ModelUtils.deleteAllItems(this.control.history, this.control.model, this.control.selection);
            this.createItems(dataSource, parameter.layoutType);
            this.control.history.endTransaction();
        }
        this.control.history.clear();
    };
    return BindDocumentCommand;
}(ImportDataCommandBase_1.ImportDataCommandBase));
exports.BindDocumentCommand = BindDocumentCommand;


/***/ }),
/* 200 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeType_1 = __webpack_require__(1);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var ModelUtils_1 = __webpack_require__(8);
var DataSource_1 = __webpack_require__(37);
var DocumentDataSource = /** @class */ (function (_super) {
    __extends(DocumentDataSource, _super);
    function DocumentDataSource(nodeDataSource, edgeDataSource, nodeDataImporter, edgeDataImporter) {
        return _super.call(this, "Document", "Document Data Source", nodeDataSource, edgeDataSource, nodeDataImporter, edgeDataImporter) || this;
    }
    DocumentDataSource.prototype.createModelItems = function (history, model, selection, layoutType) {
        ModelUtils_1.ModelUtils.createItemsByDataSource(history, model, selection, this, layoutType, true);
    };
    DocumentDataSource.prototype.updateItems = function (model, changesListener) {
        var _this = this;
        this.deleteNodes(model, changesListener);
        this.deleteEdges(model, changesListener);
        model.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                _this.updateNode(item, changesListener);
            if (item instanceof Connector_1.Connector)
                _this.updateEdge(item, changesListener);
        });
    };
    DocumentDataSource.prototype.updateNode = function (shape, changesListener) {
        var _this = this;
        var nodeObj = this.findNode(shape.dataKey);
        if (!nodeObj) {
            var dataObj = {};
            nodeObj = this.addNodeInternal(dataObj, shape.text, shape.description.key);
            this.nodeDataSource.push(nodeObj.dataObj);
            this.nodeDataImporter.setKey(dataObj, nodeObj.key);
            this.updateNodeObject(nodeObj, shape);
            this.updateNodeObjectKey(nodeObj, nodeObj.dataObj, shape);
            changesListener.NotifyNodeInserted.call(changesListener, nodeObj.dataObj, function (data) {
                _this.updateNodeObjectKey(nodeObj, data, shape);
            });
        }
        else {
            if (this.isNodeObjectModified(nodeObj, shape)) {
                this.updateNodeObject(nodeObj, shape);
                changesListener.NotifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj || nodeObj.key), nodeObj.dataObj, function (key, data) { });
            }
        }
        if (this.useNodeParentId) {
            var parentKey = this.getParentShapeKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectParentKey(nodeObj, parentItem, changesListener);
        }
        if (this.useNodeItems) {
            var parentKey = this.getParentShapeKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectItems(nodeObj, parentItem, changesListener);
        }
    };
    DocumentDataSource.prototype.isNodeObjectModified = function (nodeObj, shape) {
        return nodeObj.text !== shape.text || (nodeObj.type !== shape.description.key &&
            !(nodeObj.type === undefined && shape.description.key === ShapeType_1.ShapeType.Rectangle));
    };
    DocumentDataSource.prototype.updateNodeObject = function (nodeObj, shape) {
        nodeObj.text = shape.text;
        this.nodeDataImporter.setText(nodeObj.dataObj, shape.text);
        nodeObj.type = shape.description.key;
        this.nodeDataImporter.setType(nodeObj.dataObj, shape.description.key);
    };
    DocumentDataSource.prototype.updateNodeObjectParentKey = function (nodeObj, parentNodeObj, changesListener) {
        var parentKey = this.nodeDataImporter.getParentKey(nodeObj.dataObj);
        var newParentKey = parentNodeObj ? this.nodeDataImporter.getKey(parentNodeObj.dataObj) : undefined;
        if (parentKey !== newParentKey) {
            this.nodeDataImporter.setParentKey(nodeObj.dataObj, newParentKey);
            changesListener.NotifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) { });
        }
    };
    DocumentDataSource.prototype.updateNodeObjectItems = function (nodeObj, parentNodeObj, changesListener) {
        if (parentNodeObj && nodeObj.parentDataObj !== parentNodeObj.dataObj ||
            !parentNodeObj && nodeObj.parentDataObj) {
            if (!parentNodeObj || !this.checkNodeCyrcleItems(nodeObj.dataObj, parentNodeObj.dataObj)) {
                var oldItemsArray = nodeObj.parentDataObj ? this.nodeDataImporter.getItems(nodeObj.parentDataObj) : this.nodeDataSource;
                var index = oldItemsArray.indexOf(nodeObj.dataObj);
                oldItemsArray.splice(index, 1);
                var itemsArray = parentNodeObj ? this.nodeDataImporter.getItems(parentNodeObj.dataObj) : this.nodeDataSource;
                if (!itemsArray)
                    this.nodeDataImporter.setItems(parentNodeObj.dataObj, [nodeObj.dataObj]);
                else
                    itemsArray.push(nodeObj.dataObj);
                nodeObj.parentDataObj = parentNodeObj && parentNodeObj.dataObj;
                changesListener.NotifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) { });
            }
        }
    };
    DocumentDataSource.prototype.checkNodeCyrcleItems = function (nodeDataObj, parentDataObjCandidate) {
        var _this = this;
        var result = false;
        var items = this.nodeDataImporter.getItems(nodeDataObj);
        if (items) {
            items.forEach(function (childDataObj) {
                result = result || childDataObj === parentDataObjCandidate ||
                    _this.checkNodeCyrcleItems(childDataObj, parentDataObjCandidate);
            });
        }
        return result;
    };
    DocumentDataSource.prototype.updateNodeObjectKey = function (nodeObj, dataObj, shape) {
        var key = this.nodeDataImporter.getKey(dataObj);
        if (key !== undefined && key !== null && key !== nodeObj.key) {
            nodeObj.key = key.toString();
            delete this.nodeKeyMap[nodeObj.key];
            this.nodeKeyMap[key] = nodeObj.key;
        }
        shape.dataKey = nodeObj.key;
        nodeObj.dataObj = dataObj;
    };
    DocumentDataSource.prototype.updateEdge = function (connector, changesListener) {
        var _this = this;
        var beginDataKey = connector.beginItem ? connector.beginItem.dataKey : undefined;
        var endDataKey = connector.endItem ? connector.endItem.dataKey : undefined;
        var edgeObj = this.findEdge(connector.dataKey);
        if (!edgeObj) {
            var dataObj = this.useEdgesArray() ? {} : undefined;
            edgeObj = this.addEdgeInternal(dataObj, beginDataKey, endDataKey);
            if (dataObj) {
                this.edgeDataImporter.setKey(dataObj, edgeObj.key);
                this.edgeDataSource.push(edgeObj.dataObj);
            }
            this.updateEdgeObject(edgeObj, connector);
            this.updateEdgeObjectKey(edgeObj, edgeObj.dataObj, connector);
            if (dataObj) {
                changesListener.NotifyEdgeInserted.call(changesListener, edgeObj.dataObj, function (data) {
                    _this.updateEdgeObjectKey(edgeObj, data, connector);
                });
            }
        }
        else {
            if (this.isEdgeObjectModified(edgeObj, connector)) {
                this.updateEdgeObject(edgeObj, connector);
                if (edgeObj.dataObj) {
                    changesListener.NotifyEdgeUpdated.call(changesListener, this.edgeDataImporter.getKey(edgeObj.dataObj) || edgeObj.key, edgeObj.dataObj, function (key, data) { });
                }
            }
        }
    };
    DocumentDataSource.prototype.isEdgeObjectModified = function (edgeObj, connector) {
        return edgeObj.from !== (connector.beginItem ? connector.beginItem.dataKey : undefined) ||
            edgeObj.to !== (connector.endItem ? connector.endItem.dataKey : undefined);
    };
    DocumentDataSource.prototype.updateEdgeObject = function (edgeObj, connector) {
        var fromObj = this.findNode(connector.beginItem && connector.beginItem.dataKey);
        edgeObj.from = fromObj && fromObj.key;
        if (edgeObj.dataObj)
            this.edgeDataImporter.setFrom(edgeObj.dataObj, fromObj && fromObj.dataObj && this.nodeDataImporter.getKey(fromObj.dataObj));
        var toObj = this.findNode(connector.endItem && connector.endItem.dataKey);
        edgeObj.to = toObj && toObj.key;
        if (edgeObj.dataObj)
            this.edgeDataImporter.setTo(edgeObj.dataObj, toObj && toObj.dataObj && this.nodeDataImporter.getKey(toObj.dataObj));
    };
    DocumentDataSource.prototype.updateEdgeObjectKey = function (edgeObj, dataObj, connector) {
        var key = dataObj && this.edgeDataImporter.getKey(dataObj);
        if (key !== undefined && key !== null && key !== edgeObj.key) {
            edgeObj.key = key.toString();
            delete this.edgeKeyMap[edgeObj.key];
            this.edgeKeyMap[key] = edgeObj.key;
        }
        connector.dataKey = edgeObj.key;
        edgeObj.dataObj = dataObj;
    };
    DocumentDataSource.prototype.deleteNodes = function (model, changesListener) {
        var _this = this;
        this.deleteItems(this.nodes, function (key) { return model.findShapeByDataKey(key); }, function (item) { return _this.getNodeParentArray(item); }, function (item, dataModified) {
            var key = (item.dataObj && _this.nodeDataImporter.getKey(item.dataObj)) || item.key;
            var dataKey = _this.nodeKeyMap[key];
            if (dataKey)
                delete _this.nodeKeyMap[key];
            var nodeObj = _this.findNode(dataKey);
            if (nodeObj)
                _this.nodes.splice(_this.nodes.indexOf(nodeObj), 1);
            if (dataModified)
                changesListener.NotifyNodeRemoved.call(changesListener, key, function (key) { });
        });
    };
    DocumentDataSource.prototype.deleteEdges = function (model, changesListener) {
        var _this = this;
        this.deleteItems(this.edges, function (key) { return model.findConnectorByDataKey(key); }, function (item) { return _this.edgeDataSource; }, function (item, dataModified) {
            var key = (item.dataObj && _this.edgeDataImporter.getKey(item.dataObj)) || item.key;
            var dataKey = _this.edgeKeyMap[key];
            if (dataKey)
                delete _this.edgeKeyMap[key];
            var edgeObj = _this.findEdge(dataKey);
            if (edgeObj)
                _this.edges.splice(_this.edges.indexOf(edgeObj), 1);
            if (dataModified)
                changesListener.NotifyEdgeRemoved.call(changesListener, key, function (key) { });
        });
    };
    DocumentDataSource.prototype.deleteItems = function (dataSourceItems, findItem, getParentArray, callback) {
        var items = dataSourceItems.slice();
        items.forEach(function (item) {
            if (item.key && !findItem(item.key)) {
                var parentArray = getParentArray(item);
                var index = parentArray.indexOf(item.dataObj);
                parentArray.splice(index, 1);
                callback(item, index > -1);
            }
        });
    };
    DocumentDataSource.prototype.getParentShapeKey = function (shape) {
        var parentKey;
        for (var i = 0; i < shape.attachedConnectors.length; i++) {
            if (shape.attachedConnectors[i].endItem === shape) {
                var parentShape = shape.attachedConnectors[i].beginItem;
                parentKey = parentShape && parentShape.dataKey;
                break;
            }
        }
        return parentKey;
    };
    DocumentDataSource.prototype.getNodeParentArray = function (item) {
        var items;
        if (this.useNodeItems && item.parentDataObj)
            items = this.nodeDataImporter.getItems(item.parentDataObj);
        return items || this.nodeDataSource;
    };
    return DocumentDataSource;
}(DataSource_1.DataSource));
exports.DocumentDataSource = DocumentDataSource;


/***/ }),
/* 201 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandStates_1 = __webpack_require__(6);
var ModelUtils_1 = __webpack_require__(8);
var CommandBase_1 = __webpack_require__(7);
var UnbindDocumentCommand = /** @class */ (function (_super) {
    __extends(UnbindDocumentCommand, _super);
    function UnbindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnbindDocumentCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    UnbindDocumentCommand.prototype.executeCore = function (state) {
        this.control.unregisterDocumentDataSource();
        ModelUtils_1.ModelUtils.deleteAllItems(this.control.history, this.control.model, this.control.selection);
        this.control.history.clear();
        if (this.control.renderManager)
            this.control.renderManager.onWindowResize(null);
        return true;
    };
    return UnbindDocumentCommand;
}(CommandBase_1.CommandBase));
exports.UnbindDocumentCommand = UnbindDocumentCommand;


/***/ }),
/* 202 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AutoLayoutCommandBase_1 = __webpack_require__(43);
var WideTree_1 = __webpack_require__(61);
var LayoutSettings_1 = __webpack_require__(18);
var AutoLayoutTreeHorizontalCommand = /** @class */ (function (_super) {
    __extends(AutoLayoutTreeHorizontalCommand, _super);
    function AutoLayoutTreeHorizontalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeHorizontalCommand.prototype.createLayout = function (graph) {
        var settings = this.createLayoutSettings();
        settings.orientation = LayoutSettings_1.OrientationKind.Horizontal;
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeHorizontalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeHorizontalCommand = AutoLayoutTreeHorizontalCommand;


/***/ }),
/* 203 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AutoLayoutCommandBase_1 = __webpack_require__(43);
var Sugiyama_1 = __webpack_require__(40);
var LayoutSettings_1 = __webpack_require__(18);
var AutoLayoutLayeredVerticalCommand = /** @class */ (function (_super) {
    __extends(AutoLayoutLayeredVerticalCommand, _super);
    function AutoLayoutLayeredVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredVerticalCommand.prototype.createLayout = function (graph) {
        var settings = this.createLayoutSettings();
        settings.orientation = LayoutSettings_1.OrientationKind.Vertical;
        return new Sugiyama_1.SugiyamaLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutLayeredVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutLayeredVerticalCommand = AutoLayoutLayeredVerticalCommand;


/***/ }),
/* 204 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandStates_1 = __webpack_require__(6);
var CommandBase_1 = __webpack_require__(7);
var CloseDataSourceCommand = /** @class */ (function (_super) {
    __extends(CloseDataSourceCommand, _super);
    function CloseDataSourceCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloseDataSourceCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true);
    };
    CloseDataSourceCommand.prototype.executeCore = function (state, parameter) {
        this.control.unregisterDataSource(parameter);
        return true;
    };
    return CloseDataSourceCommand;
}(CommandBase_1.CommandBase));
exports.CloseDataSourceCommand = CloseDataSourceCommand;


/***/ }),
/* 205 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeLockedCommand_1 = __webpack_require__(94);
var LockCommand = /** @class */ (function (_super) {
    __extends(LockCommand, _super);
    function LockCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LockCommand.prototype.getLockState = function () {
        return true;
    };
    return LockCommand;
}(ChangeLockedCommand_1.ChangeLockedCommand));
exports.LockCommand = LockCommand;


/***/ }),
/* 206 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeLockedHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeLockedHistoryItem, _super);
    function ChangeLockedHistoryItem(item, locked) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.locked = locked;
        return _this;
    }
    ChangeLockedHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldLocked = item.locked;
        manipulator.changeLocked(item, this.locked);
    };
    ChangeLockedHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeLocked(item, this.oldLocked);
    };
    return ChangeLockedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeLockedHistoryItem = ChangeLockedHistoryItem;


/***/ }),
/* 207 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeLockedCommand_1 = __webpack_require__(94);
var UnLockCommand = /** @class */ (function (_super) {
    __extends(UnLockCommand, _super);
    function UnLockCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnLockCommand.prototype.getLockState = function () {
        return false;
    };
    return UnLockCommand;
}(ChangeLockedCommand_1.ChangeLockedCommand));
exports.UnLockCommand = UnLockCommand;


/***/ }),
/* 208 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var Model_1 = __webpack_require__(21);
var ModelUtils_1 = __webpack_require__(8);
var CloneCommand = /** @class */ (function (_super) {
    __extends(CloneCommand, _super);
    function CloneCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(!this.control.selection.isEmpty());
    };
    CloneCommand.prototype.executeCore = function (state, parameter) {
        var selectionRect = Model_1.DiagramModel.getRectangle(this.control.selection.getSelectedItems());
        ModelUtils_1.ModelUtils.cloneSelectionToOffset(this.control.history, this.control.model, this.control.selection, this.getOffsetX(selectionRect), this.getOffsetY(selectionRect));
        return true;
    };
    CloneCommand.prototype.getOffsetX = function (selectionRect) {
        return 0;
    };
    ;
    CloneCommand.prototype.getOffsetY = function (selectionRect) {
        return 0;
    };
    ;
    return CloneCommand;
}(CommandBase_1.CommandBase));
exports.CloneCommand = CloneCommand;
var CloneLeftCommand = /** @class */ (function (_super) {
    __extends(CloneLeftCommand, _super);
    function CloneLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneLeftCommand.prototype.getOffsetX = function (selectionRect) {
        return -selectionRect.width;
    };
    ;
    return CloneLeftCommand;
}(CloneCommand));
exports.CloneLeftCommand = CloneLeftCommand;
var CloneRightCommand = /** @class */ (function (_super) {
    __extends(CloneRightCommand, _super);
    function CloneRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneRightCommand.prototype.getOffsetX = function (selectionRect) {
        return selectionRect.width;
    };
    ;
    return CloneRightCommand;
}(CloneCommand));
exports.CloneRightCommand = CloneRightCommand;
var CloneUpCommand = /** @class */ (function (_super) {
    __extends(CloneUpCommand, _super);
    function CloneUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneUpCommand.prototype.getOffsetY = function (selectionRect) {
        return -selectionRect.height;
    };
    ;
    return CloneUpCommand;
}(CloneCommand));
exports.CloneUpCommand = CloneUpCommand;
var CloneDownCommand = /** @class */ (function (_super) {
    __extends(CloneDownCommand, _super);
    function CloneDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneDownCommand.prototype.getOffsetY = function (selectionRect) {
        return selectionRect.height;
    };
    ;
    return CloneDownCommand;
}(CloneCommand));
exports.CloneDownCommand = CloneDownCommand;


/***/ }),
/* 209 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var Model_1 = __webpack_require__(21);
var ChangeUnitsCommand = /** @class */ (function (_super) {
    __extends(ChangeUnitsCommand, _super);
    function ChangeUnitsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeUnitsCommand.prototype.getPropertyName = function () {
        return "units";
    };
    ChangeUnitsCommand.prototype.getPropertyOptions = function () {
        return [
            { value: Model_1.DiagramUnit.In, text: "in" },
            { value: Model_1.DiagramUnit.Cm, text: "cm" },
            { value: Model_1.DiagramUnit.Px, text: "px" }
        ];
    };
    return ChangeUnitsCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeUnitsCommand = ChangeUnitsCommand;


/***/ }),
/* 210 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var ChangePageColorCommand = /** @class */ (function (_super) {
    __extends(ChangePageColorCommand, _super);
    function ChangePageColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageColorCommand.prototype.getPropertyName = function () {
        return "pageColor";
    };
    return ChangePageColorCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageColorCommand = ChangePageColorCommand;


/***/ }),
/* 211 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(23);
var ChangeShowGridCommand = /** @class */ (function (_super) {
    __extends(ChangeShowGridCommand, _super);
    function ChangeShowGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeShowGridCommand.prototype.getPropertyName = function () {
        return "showGrid";
    };
    return ChangeShowGridCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeShowGridCommand = ChangeShowGridCommand;


/***/ }),
/* 212 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(7);
var CommandStates_1 = __webpack_require__(6);
var ToggleFullscreenCommand = /** @class */ (function (_super) {
    __extends(ToggleFullscreenCommand, _super);
    function ToggleFullscreenCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFullscreenCommand.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(true, this.control.settings.fullscreen);
    };
    ToggleFullscreenCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.fullscreen = !this.control.settings.fullscreen;
        this.control.NotifyToggleFullscreen(this.control.settings.fullscreen);
        return true;
    };
    return ToggleFullscreenCommand;
}(CommandBase_1.CommandBase));
exports.ToggleFullscreenCommand = ToggleFullscreenCommand;


/***/ }),
/* 213 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ModelManipulator_1 = __webpack_require__(214);
var CanvasManager_1 = __webpack_require__(44);
var CommandManager_1 = __webpack_require__(68);
var EventManager_1 = __webpack_require__(215);
var SelectionController_1 = __webpack_require__(238);
var Model_1 = __webpack_require__(21);
var Selection_1 = __webpack_require__(239);
var History_1 = __webpack_require__(241);
var BarManager_1 = __webpack_require__(242);
var RenderManager_1 = __webpack_require__(10);
var ShapeToolbox_1 = __webpack_require__(244);
var DataToolbox_1 = __webpack_require__(245);
var ShapeDescriptionManager_1 = __webpack_require__(30);
var DiagramSettings_1 = __webpack_require__(246);
var DiagramControl = /** @class */ (function () {
    function DiagramControl() {
        this.dataSources = [];
        this.settings = new DiagramSettings_1.DiagramSettings();
        this.model = new Model_1.DiagramModel();
        this.selection = new Selection_1.Selection(this.model);
        this.modelManipulator = new ModelManipulator_1.ModelManipulator(this.model);
        this.modelManipulator.initialize(this.model);
        this.history = new History_1.History(this.modelManipulator);
        this.commandManager = new CommandManager_1.CommandManager(this);
        this.eventManager = new EventManager_1.EventManager(this);
        this.barManager = new BarManager_1.BarManager(this);
        this.selection.onChanged.add(this.barManager);
        this.modelManipulator.onLoad();
        this.history.onChanged.add(this);
    }
    DiagramControl.prototype.createDocument = function (parent) {
        if (this.renderManager) {
            if (this.renderManager.mainElement.parentNode !== parent)
                parent.appendChild(this.renderManager.mainElement);
        }
        else {
            this.renderManager = new RenderManager_1.RenderManager(parent, this.eventManager);
            this.canvasManager = new CanvasManager_1.CanvasManager(this.renderManager.svgElement);
            this.eventManager.onTextInputOperation.add(this.renderManager);
            this.eventManager.onTextInputOperation.add(this.canvasManager);
            this.eventManager.onMouseOperation.add(this.canvasManager);
            this.eventManager.onVisualizersUpdate.add(this.canvasManager);
            this.modelManipulator.onModelChanged.add(this.renderManager);
            this.modelManipulator.onModelChanged.add(this.canvasManager);
            var selectionController = new SelectionController_1.SelectionController(this.selection);
            this.modelManipulator.onModelChanged.add(selectionController);
            selectionController.onSelectionChanged.add(this.canvasManager);
            this.modelManipulator.onLoad();
        }
    };
    DiagramControl.prototype.createToolbox = function (parent, shapeIconSize, shapeIconSpacing, shapeIconAttributes, shapes) {
        var toolbox = new ShapeToolbox_1.ShapeToolboxManager();
        toolbox.initialize(parent, {
            shapeIconSize: shapeIconSize,
            shapeIconSpacing: shapeIconSpacing,
            shapeIconAttributes: shapeIconAttributes,
            shapes: shapes
        });
        toolbox.onDragOperation.add(this);
        this.eventManager.registerToolbox(toolbox);
    };
    DiagramControl.prototype.createDataSourceToolbox = function (key, parent) {
        if (key === undefined || key === null)
            throw new Error("Data source toolbox key must be specified");
        var dataSource = this.getDataSource(key);
        if (!dataSource)
            throw Error("Data source with the specified key cannot be found");
        var toolbox = new DataToolbox_1.DataToolboxManager(key);
        toolbox.initialize(parent, dataSource);
        toolbox.onDragOperation.add(this);
        this.eventManager.registerToolbox(toolbox);
    };
    DiagramControl.prototype.updateLayout = function () {
        if (this.renderManager)
            this.renderManager.updateLayout();
    };
    DiagramControl.prototype.captureFocus = function () {
        if (this.renderManager)
            this.renderManager.captureFocus();
    };
    DiagramControl.prototype.isFocused = function () {
        if (this.renderManager)
            return this.renderManager.isFocused();
        return true;
    };
    DiagramControl.prototype.addCustomShapes = function (shapes) {
        var _this = this;
        shapes.forEach(function (shape) {
            if (shape.defaultWidth)
                shape.defaultWidth = _this.model.getTwipsUnit(shape.defaultWidth);
            if (shape.defaultHeight)
                shape.defaultHeight = _this.model.getTwipsUnit(shape.defaultHeight);
            ShapeDescriptionManager_1.ShapeDescriptionManager.registerCustomShape(shape);
        });
    };
    DiagramControl.prototype.removeCustomShapes = function (shapeIds) {
        shapeIds.forEach(function (id) {
            ShapeDescriptionManager_1.ShapeDescriptionManager.unregisterCustomShape(id);
        });
    };
    DiagramControl.prototype.getUnitText = function (twipsValue, fractionDigits) {
        if (fractionDigits === void 0) { fractionDigits = 2; }
        return this.model.getModelUnitText(twipsValue, fractionDigits);
    };
    DiagramControl.prototype.importModel = function (model) {
        this.model = model;
        this.importData();
    };
    DiagramControl.prototype.importItemsData = function () {
        this.model.invalidateItems();
        this.importData();
    };
    DiagramControl.prototype.importData = function () {
        if (this.canvasManager !== undefined)
            this.canvasManager.clear();
        this.selection.initialize(this.model);
        this.modelManipulator.initialize(this.model);
        this.history.clear();
        this.eventManager.initialize();
        this.modelManipulator.onLoad();
    };
    DiagramControl.prototype.registerDataSource = function (ds) {
        var dataSource = this.getDataSource(ds.key);
        if (dataSource)
            throw Error("Data Source key is duplicated");
        this.dataSources.push(ds);
    };
    DiagramControl.prototype.unregisterDataSource = function (key) {
        var dataSource = this.getDataSource(key);
        if (dataSource) {
            this.dataSources.splice(this.dataSources.indexOf(dataSource), 1);
        }
    };
    DiagramControl.prototype.getDataSource = function (key) {
        return this.dataSources.filter(function (ds) { return ds.key === key; })[0];
    };
    DiagramControl.prototype.registerDocumentDataSource = function (ds) {
        this.documentDataSource = ds;
    };
    DiagramControl.prototype.unregisterDocumentDataSource = function () {
        delete this.documentDataSource;
    };
    DiagramControl.prototype.beginUpdate = function () {
        this.barManager.beginUpdate();
    };
    DiagramControl.prototype.endUpdate = function () {
        this.barManager.endUpdate();
    };
    DiagramControl.prototype.NotifyEdgeInserted = function (data, callback) {
        if (this.onEdgeInserted)
            this.onEdgeInserted(data, callback);
    };
    DiagramControl.prototype.NotifyEdgeUpdated = function (key, data, callback) {
        if (this.onEdgeUpdated)
            this.onEdgeUpdated(key, data, callback);
    };
    DiagramControl.prototype.NotifyEdgeRemoved = function (key, callback) {
        if (this.onEdgeUpdated)
            this.onEdgeRemoved(key, callback);
    };
    DiagramControl.prototype.NotifyNodeInserted = function (data, callback) {
        if (this.onNodeInserted)
            this.onNodeInserted(data, callback);
    };
    DiagramControl.prototype.NotifyNodeUpdated = function (key, data, callback) {
        if (this.onNodeUpdated)
            this.onNodeUpdated(key, data, callback);
    };
    DiagramControl.prototype.NotifyNodeRemoved = function (key, callback) {
        if (this.onNodeRemoved)
            this.onNodeRemoved(key, callback);
    };
    DiagramControl.prototype.NotifyHistoryChanged = function () {
        if (this.documentDataSource)
            this.documentDataSource.updateItems(this.model, this);
        if (this.onChanged)
            this.onChanged();
    };
    DiagramControl.prototype.NotifyToolboxDragStart = function () {
        if (this.onToolboxDragStart)
            this.onToolboxDragStart();
    };
    DiagramControl.prototype.NotifyToolboxDragEnd = function () {
        if (this.onToolboxDragEnd)
            this.onToolboxDragEnd();
    };
    DiagramControl.prototype.NotifyToggleFullscreen = function (value) {
        if (this.onToggleFullscreen)
            this.onToggleFullscreen(value);
    };
    return DiagramControl;
}());
exports.DiagramControl = DiagramControl;


/***/ }),
/* 214 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var ModelChange_1 = __webpack_require__(48);
var Utils_1 = __webpack_require__(0);
var Connector_1 = __webpack_require__(5);
var ModelManipulator = /** @class */ (function () {
    function ModelManipulator(model) {
        this.onModelChanged = new Utils_1.EventDispatcher();
        this.model = model;
    }
    ModelManipulator.prototype.initialize = function (model) {
        this.model = model;
    };
    ModelManipulator.prototype.onLoad = function () {
        var _this = this;
        var changes = [];
        this.model.iterateItems(function (item) {
            changes.push(_this.createItemChange(item, ModelChange_1.ItemChangeType.Create));
        });
        this.raiseModelChanged([new ModelChange_1.PageChange(this.model, ModelChange_1.PageChangeType.Create)]);
        this.raiseModelChanged(changes);
    };
    // Items
    ModelManipulator.prototype.changeStyle = function (item, styleProperty, styleValue) {
        this.changeStyleCore(item, item.style, styleProperty, styleValue);
    };
    ModelManipulator.prototype.changeStyleText = function (item, styleProperty, styleValue) {
        this.changeStyleCore(item, item.styleText, styleProperty, styleValue);
    };
    ModelManipulator.prototype.changeStyleCore = function (item, styleObj, styleProperty, styleValue) {
        if (styleValue !== undefined)
            styleObj[styleProperty] = styleValue;
        else
            delete styleObj[styleProperty];
        item.invalidatePrimitives();
        this.raiseModelChanged([this.createItemChange(item, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.changeZIndex = function (item, zIndex) {
        item.zIndex = zIndex;
        this.raiseModelChanged([this.createItemChange(item, ModelChange_1.ItemChangeType.UpdateZIndex)]);
    };
    ModelManipulator.prototype.changeLocked = function (item, locked) {
        item.locked = locked;
        this.raiseModelChanged([this.createItemChange(item, ModelChange_1.ItemChangeType.Update)]);
    };
    // Shapes
    ModelManipulator.prototype.addShape = function (shape, key) {
        if (shape.attachedConnectors.length)
            throw Error("A creating shape should not contain existing connectors.");
        shape.key = key !== undefined ? key : this.model.getNextKey();
        return this.insertShape(shape);
    };
    ModelManipulator.prototype.insertShape = function (shape) {
        this.model.pushItem(shape);
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.Create)]);
        return shape;
    };
    ModelManipulator.prototype.resizeShape = function (shape, position, size) {
        shape.position = position;
        shape.size = size;
        shape.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.moveShape = function (shape, position) {
        shape.position = position;
        shape.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.changeShapeParameters = function (shape, parameters) {
        shape.parameters.forEach(function (p) {
            var parameter = parameters.get(p.key);
            if (parameter)
                p.value = parameter.value;
        });
        shape.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.changeShapeText = function (shape, text) {
        shape.text = text;
        shape.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.deleteShape = function (shape) {
        if (shape.attachedConnectors.length)
            throw Error("A removing shape should not contain existing connectors.");
        this.removeShape(shape);
    };
    ModelManipulator.prototype.removeShape = function (shape) {
        this.model.removeItem(shape);
        this.raiseModelChanged([new ModelChange_1.ShapeChange(shape, ModelChange_1.ItemChangeType.Remove)]);
    };
    // Connectors
    ModelManipulator.prototype.addConnector = function (connector, key) {
        if (connector.beginItem || connector.endItem)
            throw Error("Creating connector should not contain begin/end items");
        connector.key = key !== undefined ? key : this.model.getNextKey();
        ;
        return this.insertConnector(connector);
    };
    ModelManipulator.prototype.insertConnector = function (connector) {
        this.model.pushItem(connector);
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.Create)]);
        return connector;
    };
    ModelManipulator.prototype.deleteConnector = function (connector) {
        if (connector.beginItem || connector.endItem)
            throw Error("Creating connector should not contain begin/end items");
        this.removeConnector(connector);
    };
    ModelManipulator.prototype.removeConnector = function (connector) {
        this.model.removeItem(connector);
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.Remove)]);
    };
    ModelManipulator.prototype.moveConnectorPoint = function (connector, pointIndex, point) {
        connector.points[pointIndex] = point;
        connector.invalidateRenderPoints();
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.addConnectorPoint = function (connector, pointIndex, point) {
        connector.points.splice(pointIndex, 0, point);
        connector.invalidateRenderPoints();
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.deleteConnectorPoint = function (connector, pointIndex) {
        connector.points.splice(pointIndex, 1);
        connector.invalidateRenderPoints();
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.addConnection = function (connector, item, connectionPointIndex, position) {
        var existingItem = connector.getExtremeItem(position);
        if (existingItem === item)
            return;
        else if (existingItem)
            throw Error("Connector is already connected");
        item.attachedConnectors.push(connector);
        if (position === Connector_1.ConnectorPosition.Begin) {
            connector.beginItem = item;
            connector.beginConnectionPointIndex = connectionPointIndex;
        }
        else {
            connector.endItem = item;
            connector.endConnectionPointIndex = connectionPointIndex;
        }
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.setConnectionPointIndex = function (connector, connectionPointIndex, position) {
        if (!connector.getExtremeItem(position))
            throw Error("Connection should be connected");
        if (position === Connector_1.ConnectorPosition.Begin)
            connector.beginConnectionPointIndex = connectionPointIndex;
        else
            connector.endConnectionPointIndex = connectionPointIndex;
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.deleteConnection = function (connector, position) {
        var item = connector.getExtremeItem(position);
        if (!item)
            return;
        item.attachedConnectors.splice(item.attachedConnectors.indexOf(connector), 1);
        if (position === Connector_1.ConnectorPosition.Begin) {
            connector.beginItem = null;
            connector.beginConnectionPointIndex = -1;
        }
        else {
            connector.endItem = null;
            connector.endConnectionPointIndex = -1;
        }
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.changeConnectorProperty = function (connector, propertyName, value) {
        connector.properties[propertyName] = value;
        connector.invalidateRenderPoints();
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.changeConnectorText = function (connector, position, text) {
        connector.setText(position, text);
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.changeConnectorTextPosition = function (connector, position, newPosition) {
        var text = connector.getText(position);
        connector.setText(position, null);
        connector.setText(newPosition, text);
        connector.invalidatePrimitives();
        this.raiseModelChanged([new ModelChange_1.ConnectorChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    // Model
    ModelManipulator.prototype.changeModelSize = function (size, offset) {
        this.model.size.width = size.width;
        this.model.size.height = size.height;
        this.raiseModelChanged([new ModelChange_1.PageChange(this.model, ModelChange_1.PageChangeType.Update, offset)]);
    };
    ModelManipulator.prototype.changePageSize = function (value) {
        this.model.pageSize = value;
        this.model.size = new Utils_1.Size(this.model.pageWidth, this.model.pageHeight);
        this.raiseModelChanged([new ModelChange_1.PageChange(this.model, ModelChange_1.PageChangeType.Update)]);
    };
    ModelManipulator.prototype.changePageLandscape = function (value) {
        this.model.pageLandscape = value;
        this.model.size = new Utils_1.Size(this.model.pageWidth, this.model.pageHeight);
        this.raiseModelChanged([new ModelChange_1.PageChange(this.model, ModelChange_1.PageChangeType.Update)]);
    };
    ModelManipulator.prototype.changePageProperty = function (propertyName, value) {
        this.model[propertyName] = value;
        this.raiseModelChanged([new ModelChange_1.PageChange(this.model, ModelChange_1.PageChangeType.Update)]);
    };
    ModelManipulator.prototype.createItemChange = function (item, changeType) {
        if (item instanceof Shape_1.Shape)
            return new ModelChange_1.ShapeChange(item, changeType);
        if (item instanceof Connector_1.Connector)
            return new ModelChange_1.ConnectorChange(item, changeType);
    };
    ModelManipulator.prototype.raiseModelChanged = function (changes) {
        this.onModelChanged.raise("NotifyModelChanged", changes);
    };
    return ModelManipulator;
}());
exports.ModelManipulator = ModelManipulator;


/***/ }),
/* 215 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandler_1 = __webpack_require__(216);
var Utils_1 = __webpack_require__(0);
var TextInputHandler_1 = __webpack_require__(236);
var EventManager = /** @class */ (function () {
    function EventManager(control) {
        this.onMouseOperation = new Utils_1.EventDispatcher();
        this.onTextInputOperation = new Utils_1.EventDispatcher();
        this.toolboxes = [];
        this.control = control;
        this.mouseHandler = new MouseHandler_1.MouseHandler(control.history, control.selection, control.model, this);
        this.textInputHandler = new TextInputHandler_1.TextInputHandler(control);
    }
    Object.defineProperty(EventManager.prototype, "onVisualizersUpdate", {
        get: function () {
            return this.mouseHandler.onVisualizersUpdate;
        },
        enumerable: true,
        configurable: true
    });
    EventManager.prototype.registerToolbox = function (toolbox) {
        this.toolboxes.push(toolbox);
    };
    EventManager.prototype.initialize = function () {
        this.mouseHandler.initialize(this.control.model);
    };
    EventManager.prototype.onMouseDown = function (evt) {
        this.mouseHandler.onMouseDown(evt);
    };
    EventManager.prototype.onMouseMove = function (evt) {
        var draggingEvt = this.getDraggingEvent();
        if (draggingEvt && !this.draggingEvent) {
            this.draggingEvent = draggingEvt;
            this.mouseHandler.onDragStart(this.draggingEvent);
            this.control.captureFocus();
        }
        else if (!draggingEvt && this.draggingEvent) {
            delete this.draggingEvent;
            this.mouseHandler.onDragEnd(evt);
        }
        this.mouseHandler.onMouseMove(evt);
    };
    EventManager.prototype.onMouseUp = function (evt) {
        this.mouseHandler.onMouseUp(evt);
    };
    EventManager.prototype.onMouseEnter = function (evt) {
        this.mouseHandler.onMouseEnter(evt);
    };
    EventManager.prototype.onMouseLeave = function (evt) {
        this.mouseHandler.onMouseLeave(evt);
    };
    EventManager.prototype.onDblClick = function (evt) {
        this.mouseHandler.onMouseDoubleClick(evt);
        this.textInputHandler.onMouseDoubleClick(evt);
    };
    EventManager.prototype.onKeyDown = function (evt) {
        if (this.textInputHandler.isTextInputActive())
            this.textInputHandler.onKeyDown(evt);
        else {
            var scCode = evt.getShortcutCode();
            if (this.onShortcut(scCode)) {
                this.mouseHandler.updateConnectionPoints();
                this.mouseHandler.updateConnectionMarks();
                evt.preventDefault = true;
            }
        }
    };
    EventManager.prototype.onInputBlur = function (evt) {
        this.textInputHandler.onInputBlur(evt);
    };
    EventManager.prototype.onInputFocus = function (evt) {
        this.textInputHandler.onInputFocus(evt);
    };
    EventManager.prototype.onShortcut = function (code) {
        if (this.control.commandManager.processShortcut(code))
            return true;
        if (this.mouseHandler.onShortcut(code))
            return true;
    };
    EventManager.prototype.onPaste = function (evt) {
        if (!this.textInputHandler.isTextInputActive() && this.control.commandManager.processPaste(evt.clipboardData)) {
            this.mouseHandler.updateConnectionPoints();
            this.mouseHandler.updateConnectionMarks();
            evt.preventDefault = true;
        }
    };
    EventManager.prototype.isFocused = function () {
        return this.control.isFocused();
    };
    EventManager.prototype.getDraggingEvent = function () {
        return this.toolboxes
            .filter(function (t) { return t.draggingObject; })
            .map(function (t) { return t.draggingObject.evt; })[0];
    };
    EventManager.prototype.onDocumentDragEnd = function (itemKeys) {
        this.onMouseOperation.raise("NotifyDragEnd", itemKeys);
        this.control.endUpdate();
    };
    EventManager.prototype.onDocumentDragStart = function (itemKeys) {
        this.control.beginUpdate();
        this.control.captureFocus();
        this.onMouseOperation.raise("NotifyDragStart", itemKeys);
    };
    EventManager.prototype.raiseTextInputStart = function (item, text, position, size) {
        this.onTextInputOperation.raise("NotifyTextInputStart", item, text, position, size);
    };
    EventManager.prototype.raiseTextInputEnd = function (item) {
        this.onTextInputOperation.raise("NotifyTextInputEnd", item);
    };
    return EventManager;
}());
exports.EventManager = EventManager;


/***/ }),
/* 216 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerDefaultState_1 = __webpack_require__(217);
var Event_1 = __webpack_require__(14);
var Utils_1 = __webpack_require__(0);
var ConnectionPointsVisualizer_1 = __webpack_require__(233);
var KeyCode_1 = __webpack_require__(16);
var ModelUtils_1 = __webpack_require__(8);
var Model_1 = __webpack_require__(21);
var ExtensionLinesVisualizer_1 = __webpack_require__(92);
var Shape_1 = __webpack_require__(9);
var CanvasManager_1 = __webpack_require__(44);
var ConnectionMarksVisualizer_1 = __webpack_require__(234);
var ConnectionTargetVisualizer_1 = __webpack_require__(235);
var ConnectionPointsVisualizerBase_1 = __webpack_require__(67);
var MouseHandlerMoveClonedShapeState_1 = __webpack_require__(66);
var MouseHandler = /** @class */ (function () {
    function MouseHandler(history, selection, model, eventManager) {
        this.history = history;
        this.selection = selection;
        this.model = model;
        this.eventManager = eventManager;
        this.onVisualizersUpdate = new Utils_1.EventDispatcher();
        this.initialize(model);
        this.connectionPointsVisualizer = new ConnectionPointsVisualizer_1.ConnectionPointsVisualizer(this.onVisualizersUpdate);
        this.connectionMarksVisualizer = new ConnectionMarksVisualizer_1.ConnectionMarksVisualizer(this.onVisualizersUpdate);
        this.connectionPointsVisualizer = new ConnectionPointsVisualizer_1.ConnectionPointsVisualizer(this.onVisualizersUpdate);
        this.connectionTargetVisualizer = new ConnectionTargetVisualizer_1.ConnectionTargetVisualizer(this.onVisualizersUpdate);
        this.extensionLinesVisualizer = new ExtensionLinesVisualizer_1.ExtensionLinesVisualizer(this.onVisualizersUpdate);
    }
    ;
    MouseHandler.prototype.initialize = function (model) {
        this.model = model;
        this.defaultState = new MouseHandlerDefaultState_1.MouseHandlerDefaultState(this, this.history, this.selection, this.model);
        this.switchToDefaultState();
    };
    MouseHandler.prototype.onMouseDown = function (evt) {
        this.state.onMouseDown(evt);
    };
    MouseHandler.prototype.onMouseMove = function (evt) {
        this.state.onMouseMove(evt);
    };
    MouseHandler.prototype.onMouseUp = function (evt) {
        this.state.onMouseUp(evt);
    };
    MouseHandler.prototype.onMouseDoubleClick = function (evt) {
        this.state.onMouseDoubleClick(evt);
        this.switchToDefaultState();
    };
    MouseHandler.prototype.onMouseEnter = function (evt) {
    };
    MouseHandler.prototype.onMouseLeave = function (evt) {
        this.resetConnectionPoints();
        this.resetConnectionMarks();
        this.resetConnectionTarget();
        this.resetExtensionLines();
    };
    MouseHandler.prototype.onShortcut = function (code) {
        return this.state.onShortcut(code);
    };
    MouseHandler.prototype.onDragStart = function (evt) {
        this.state.onDragStart(evt);
    };
    MouseHandler.prototype.onDragEnd = function (evt) {
        this.state.onDragEnd(evt);
    };
    // utils
    MouseHandler.prototype.getSnappedPos = function (evt, pos) {
        if (!this.model.snapToGrid || (evt.modifiers & KeyCode_1.ModifierKey.Ctrl))
            return pos;
        return ModelUtils_1.ModelUtils.getSnappedPos(this.model, pos);
    };
    MouseHandler.prototype.getSnappedPoint = function (evt, point, additionalSnappedPoint) {
        var x = this.getSnappedPos(evt, point.x);
        var y = this.getSnappedPos(evt, point.y);
        if (additionalSnappedPoint === undefined)
            return new Utils_1.Point(x, y);
        else {
            if (Math.pow(point.x - x, 2) + Math.pow(point.y - y, 2) < Math.pow(point.x - additionalSnappedPoint.x, 2) + Math.pow(point.y - additionalSnappedPoint.y, 2))
                return new Utils_1.Point(x, y);
            else
                return additionalSnappedPoint;
        }
    };
    MouseHandler.prototype.tryUpdateModelSize = function (processPoints) {
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.history, this.model, processPoints);
    };
    MouseHandler.prototype.setConnectionPoints = function (item, type, pointIndex) {
        if (!this.eventManager.isFocused())
            return;
        if (item && !item.locked && (type === Event_1.MouseEventElementType.Shape ||
            type === Event_1.MouseEventElementType.ShapeConnectionPoint ||
            type === Event_1.MouseEventElementType.ShapeConnection) && item !== undefined) {
            var key = item.key;
            if (!this.selection.hasKey(key)) {
                var points = item.getConnectionPoints();
                this.connectionPointsVisualizer.setPoints(key, points.map(function (pt, index) { return new ConnectionPointsVisualizerBase_1.ConnectionPointInfo(pt, item.getConnectionPointSide(index)); }), pointIndex);
            }
        }
        else
            this.connectionPointsVisualizer.reset();
    };
    MouseHandler.prototype.setConnectionPointIndex = function (index) {
        this.connectionPointsVisualizer.setPointIndex(index);
    };
    MouseHandler.prototype.updateConnectionPoints = function () {
        var item = this.model.findItem(this.connectionPointsVisualizer.getKey());
        if (item !== undefined)
            this.connectionPointsVisualizer.update();
        else
            this.connectionPointsVisualizer.reset();
    };
    MouseHandler.prototype.resetConnectionPoints = function () {
        this.connectionPointsVisualizer.reset();
    };
    MouseHandler.prototype.setConnectionMarks = function (item, type, pointIndex) {
        if (!this.eventManager.isFocused())
            return;
        if (item && !item.locked && (type === Event_1.MouseEventElementType.Shape ||
            type === Event_1.MouseEventElementType.ShapeConnectionPoint ||
            type === Event_1.MouseEventElementType.ShapeConnection) && item !== undefined) {
            var key = item.key;
            var points = item.getConnectionPointsForSelection();
            this.connectionMarksVisualizer.setPoints(key, points.map(function (pt, index) { return new ConnectionPointsVisualizerBase_1.ConnectionPointInfo(pt, item.getConnectionPointForSelectionSide(index)); }), pointIndex);
        }
        else
            this.connectionMarksVisualizer.reset();
    };
    MouseHandler.prototype.updateConnectionMarks = function () {
        var item = this.model.findItem(this.connectionMarksVisualizer.getKey());
        if (item !== undefined)
            this.connectionMarksVisualizer.update();
        else
            this.connectionMarksVisualizer.reset();
    };
    MouseHandler.prototype.resetConnectionMarks = function () {
        this.connectionMarksVisualizer.reset();
    };
    MouseHandler.prototype.setConnectionTarget = function (item, type) {
        if (item && !item.locked && (type === Event_1.MouseEventElementType.Shape ||
            type === Event_1.MouseEventElementType.ShapeConnectionPoint ||
            type === Event_1.MouseEventElementType.ShapeConnection)) {
            this.connectionTargetVisualizer.setTargetRect(item.key, item.rectangle);
        }
        else
            this.connectionTargetVisualizer.reset();
    };
    MouseHandler.prototype.resetConnectionTarget = function () {
        this.connectionTargetVisualizer.reset();
    };
    MouseHandler.prototype.setExtensionLines = function (items) {
        var _this = this;
        if (!this.eventManager.isFocused())
            return;
        this.extensionLinesVisualizer.reset();
        var rect = Model_1.DiagramModel.getRectangle(items.filter(function (item) { return item && !item.locked; }));
        this.addPageExtensionLines(rect);
        this.model.items.forEach(function (item) {
            if (item.locked || items.indexOf(item) > -1)
                return;
            if (item instanceof Shape_1.Shape)
                _this.addShapeExtensionLines(item, rect);
        });
    };
    MouseHandler.prototype.addPageExtensionLines = function (rect) {
        var horPages = Math.round(this.model.size.width / this.model.pageWidth);
        var verPages = Math.round(this.model.size.height / this.model.pageHeight);
        for (var i = 0; i < horPages; i++) {
            for (var j = 0; j < verPages; j++) {
                var center = new Utils_1.Point(i * this.model.pageWidth + this.model.pageWidth / 2, j * this.model.pageHeight + this.model.pageHeight / 2);
                if (Math.abs(rect.center.x - center.x) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(rect.center.x, 0), new Utils_1.Point(rect.center.x, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterToPageCenter, segment, "");
                }
                if (Math.abs(rect.center.y - center.y) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(0, rect.center.y), new Utils_1.Point(this.model.size.width, rect.center.y));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterToPageCenter, segment, "");
                }
                if (Math.abs(rect.left - center.x) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(rect.left, 0), new Utils_1.Point(rect.left, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.LeftToPageCenter, segment, "");
                }
                if (Math.abs(rect.top - center.y) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(0, rect.top), new Utils_1.Point(this.model.size.width, rect.top));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.TopToPageCenter, segment, "");
                }
                if (Math.abs(rect.right - center.x) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(rect.right, 0), new Utils_1.Point(rect.right, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.RightToPageCenter, segment, "");
                }
                if (Math.abs(rect.bottom - center.y) < this.model.gridSize / 2) {
                    var segment = new Utils_1.Segment(new Utils_1.Point(0, rect.bottom), new Utils_1.Point(this.model.size.width, rect.bottom));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.BottomToPageCenter, segment, "");
                }
            }
        }
    };
    MouseHandler.prototype.addShapeExtensionLines = function (shape, rect) {
        var sRect = shape.rectangle;
        var lwCor = Shape_1.Shape.lineWidth - CanvasManager_1.CanvasManager.extensionLineWidth;
        var showDistance = true;
        var x1, y1, x2, y2;
        if (rect.right < sRect.left) {
            x1 = rect.right + lwCor + CanvasManager_1.CanvasManager.extensionLineOffset;
            x2 = sRect.left - CanvasManager_1.CanvasManager.extensionLineOffset;
        }
        else if (rect.left > sRect.right) {
            x1 = rect.left - CanvasManager_1.CanvasManager.extensionLineOffset;
            x2 = sRect.right + lwCor + CanvasManager_1.CanvasManager.extensionLineOffset;
        }
        if (rect.bottom < sRect.top) {
            y1 = rect.bottom + lwCor + CanvasManager_1.CanvasManager.extensionLineOffset;
            y2 = sRect.top - CanvasManager_1.CanvasManager.extensionLineOffset;
        }
        else if (rect.top > sRect.bottom) {
            y1 = rect.top - CanvasManager_1.CanvasManager.extensionLineOffset;
            y2 = sRect.bottom + lwCor + CanvasManager_1.CanvasManager.extensionLineOffset;
        }
        if (x1 != undefined && x2 !== undefined) {
            if (rect.center.y === sRect.center.y) {
                var segment = new Utils_1.Segment(new Utils_1.Point(x1, rect.center.y), new Utils_1.Point(x2, sRect.center.y));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterAfter : ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterBefore, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
                showDistance = false;
            }
            if (rect.top === sRect.top) {
                var segment = new Utils_1.Segment(new Utils_1.Point(x1, rect.top), new Utils_1.Point(x2, sRect.top));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.TopToTopAfter : ExtensionLinesVisualizer_1.ExtensionLineType.TopToTopBefore, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.bottom === sRect.bottom) {
                var segment = new Utils_1.Segment(new Utils_1.Point(x1, rect.bottom + lwCor), new Utils_1.Point(x2, sRect.bottom + lwCor));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.BottomToBottomAfter : ExtensionLinesVisualizer_1.ExtensionLineType.BottomToBottomBefore, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.top === sRect.bottom) {
                var segment = new Utils_1.Segment(new Utils_1.Point(x1, rect.top), new Utils_1.Point(x2, sRect.bottom + lwCor));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.TopToBottomAfter : ExtensionLinesVisualizer_1.ExtensionLineType.TopToBottomBefore, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.bottom === sRect.top) {
                var segment = new Utils_1.Segment(new Utils_1.Point(x1, rect.bottom + lwCor), new Utils_1.Point(x2, sRect.top));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.BottomToTopAfter : ExtensionLinesVisualizer_1.ExtensionLineType.BottomToTopBefore, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
        }
        if (y1 != undefined && y2 !== undefined) {
            if (rect.center.x === sRect.center.x) {
                var segment = new Utils_1.Segment(new Utils_1.Point(rect.center.x, y1), new Utils_1.Point(sRect.center.x, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterBelow : ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterAbove, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
                showDistance = false;
            }
            if (rect.left === sRect.left) {
                var segment = new Utils_1.Segment(new Utils_1.Point(rect.left, y1), new Utils_1.Point(sRect.left, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.LeftToLeftBelow : ExtensionLinesVisualizer_1.ExtensionLineType.LeftToLeftAbove, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.right === sRect.right) {
                var segment = new Utils_1.Segment(new Utils_1.Point(rect.right + lwCor, y1), new Utils_1.Point(sRect.right + lwCor, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.RightToRightBelow : ExtensionLinesVisualizer_1.ExtensionLineType.RightToRightAbove, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.left === sRect.right) {
                var segment = new Utils_1.Segment(new Utils_1.Point(rect.left, y1), new Utils_1.Point(sRect.right + lwCor, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.LeftToRightBelow : ExtensionLinesVisualizer_1.ExtensionLineType.LeftToRightAbove, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
            if (rect.right === sRect.left) {
                var segment = new Utils_1.Segment(new Utils_1.Point(rect.right + lwCor, y1), new Utils_1.Point(sRect.left, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.RightToLeftBelow : ExtensionLinesVisualizer_1.ExtensionLineType.RightToLeftAbove, segment, showDistance ? this.model.getModelUnitText(segment.distance) : "");
            }
        }
    };
    MouseHandler.prototype.resetExtensionLines = function () {
        this.extensionLinesVisualizer.reset();
    };
    MouseHandler.prototype.raiseDragStart = function (keys) {
        this.eventManager.onDocumentDragStart(keys);
    };
    MouseHandler.prototype.raiseDragEnd = function (keys) {
        this.eventManager.onDocumentDragEnd(keys);
    };
    // switch state
    MouseHandler.prototype.switchToDefaultState = function () {
        this.switchState(this.defaultState);
    };
    MouseHandler.prototype.switchToMoveClonedShapeState = function (startPoint) {
        this.switchState(new MouseHandlerMoveClonedShapeState_1.MouseHandlerMoveClonedShapeState(this, this.history, this.model, this.selection, startPoint));
    };
    MouseHandler.prototype.switchState = function (state) {
        if (this.state)
            this.state.finish();
        this.state = state;
        this.state.start();
    };
    return MouseHandler;
}());
exports.MouseHandler = MouseHandler;


/***/ }),
/* 217 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerStateBase_1 = __webpack_require__(45);
var Event_1 = __webpack_require__(14);
var MouseHandlerMoveShapeState_1 = __webpack_require__(218);
var MouseHandlerMoveConnectorPointState_1 = __webpack_require__(220);
var MouseHandlerResizeShapeState_1 = __webpack_require__(221);
var MouseHandlerMoveConnectorSideState_1 = __webpack_require__(223);
var MouseHandlerDragParameterPointState_1 = __webpack_require__(224);
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerSelectionState_1 = __webpack_require__(226);
var MouseHandlerCreateConnectorState_1 = __webpack_require__(228);
var UnitConverter_1 = __webpack_require__(13);
var MouseHandlerMoveConnectorOrthogonalSideState_1 = __webpack_require__(229);
var MouseHandlerToolboxDraggingState_1 = __webpack_require__(230);
var MouseHandlerMoveConnectorTextState_1 = __webpack_require__(231);
var MouseHandlerMoveClonedShapeState_1 = __webpack_require__(66);
var MouseHandlerDefaultState = /** @class */ (function (_super) {
    __extends(MouseHandlerDefaultState, _super);
    function MouseHandlerDefaultState(handler, history, selection, model) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.selection = selection;
        _this.model = model;
        return _this;
    }
    MouseHandlerDefaultState.prototype.finish = function () {
        this.handler.resetConnectionPoints();
        this.handler.resetConnectionMarks();
        _super.prototype.finish.call(this);
    };
    MouseHandlerDefaultState.prototype.onMouseDown = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Shape) {
            var shapeKey = evt.source.key;
            if (MouseHandlerMoveClonedShapeState_1.MouseHandlerMoveClonedShapeState.isMoveClonedShapeEvent(evt)) {
                this.selection.add(shapeKey);
                this.handler.switchToMoveClonedShapeState();
            }
            else {
                this.modifySelection(evt, shapeKey);
                this.handler.switchState(new MouseHandlerMoveShapeState_1.MouseHandlerMoveShapeState(this.handler, this.history, this.model, this.selection));
            }
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.Connector) {
            var connectorKey = evt.source.key;
            this.modifySelection(evt, connectorKey);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorText) {
            var connectorKey = evt.source.key;
            this.modifySelection(evt, connectorKey);
            this.handler.switchState(new MouseHandlerMoveConnectorTextState_1.MouseHandlerMoveConnectorTextState(this.handler, this.history, this.model));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeResizeBox) {
            this.handler.switchState(new MouseHandlerResizeShapeState_1.MouseHandlerResizeShapeState(this.handler, this.history, this.model, this.selection));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeParameterBox) {
            this.handler.switchState(new MouseHandlerDragParameterPointState_1.MouseHandlerDragParameterPointState(this.handler, this.history, this.model));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorPoint) {
            this.handler.switchState(new MouseHandlerMoveConnectorPointState_1.MouseHandlerMoveConnectorPointState(this.handler, this.history, this.model));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorSide) {
            this.handler.switchState(new MouseHandlerMoveConnectorSideState_1.MouseHandlerMoveConnectorSideState(this.handler, this.history, this.model));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorOrthogonalSide) {
            this.handler.switchState(new MouseHandlerMoveConnectorOrthogonalSideState_1.MouseHandlerMoveConnectorOrthogonalSideState(this.handler, this.history, this.model));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint) {
            this.handler.switchState(new MouseHandlerCreateConnectorState_1.MouseHandlerCreateConnectorState(this.handler, this.history, this.model, this.selection));
            this.handler.state.onMouseDown(evt);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeConnection) {
            this.handler.switchState(new MouseHandlerCreateConnectorState_1.MouseHandlerCreateConnectorState(this.handler, this.history, this.model, this.selection, -1));
            this.handler.state.onMouseDown(evt);
        }
        else {
            this.handler.switchState(new MouseHandlerSelectionState_1.MouseHandlerSelectionState(this.handler, this.selection));
            this.handler.state.onMouseDown(evt);
        }
    };
    MouseHandlerDefaultState.prototype.onDragStart = function (evt) {
        this.handler.switchState(new MouseHandlerToolboxDraggingState_1.MouseHandlerBeforeToolboxDraggingState(this.handler, this.history, this.model, this.selection));
        this.handler.state.onDragStart(evt);
    };
    MouseHandlerDefaultState.prototype.onMouseMove = function (evt) {
        var item = this.model.findItem(evt.source.key);
        var pointIndex = -1;
        if (evt.source.value && evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint)
            pointIndex = parseInt(evt.source.value);
        this.handler.setConnectionPoints(item, evt.source.type, pointIndex);
        var connectionIndex = -1;
        if (evt.source.value && evt.source.type === Event_1.MouseEventElementType.ShapeConnection)
            connectionIndex = parseInt(evt.source.value);
        this.handler.setConnectionMarks(item, evt.source.type, connectionIndex);
    };
    MouseHandlerDefaultState.prototype.modifySelection = function (evt, key) {
        if (evt.modifiers & KeyCode_1.ModifierKey.Ctrl || evt.modifiers & KeyCode_1.ModifierKey.Shift) {
            if (this.selection.hasKey(key))
                this.selection.remove(key);
            else
                this.selection.add(key);
        }
        else if (!this.selection.hasKey(key))
            this.selection.set([key]);
    };
    MouseHandlerDefaultState.itemEdge = UnitConverter_1.UnitConverter.pixelsToTwips(10);
    return MouseHandlerDefaultState;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerDefaultState = MouseHandlerDefaultState;


/***/ }),
/* 218 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerMoveClonedShapeState_1 = __webpack_require__(66);
var MouseHandlerMoveShapeOrthogonallyState_1 = __webpack_require__(219);
var MouseHandlerMoveShapeState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveShapeState, _super);
    function MouseHandlerMoveShapeState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerMoveShapeState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        this.switchToMoveClonedShapeState(evt);
    };
    MouseHandlerMoveShapeState.prototype.switchToMoveClonedShapeState = function (evt) {
        if (MouseHandlerMoveClonedShapeState_1.MouseHandlerMoveClonedShapeState.isMoveClonedShapeEvent(evt)) {
            this.cancelChanges();
            this.handler.switchToMoveClonedShapeState(this.startPoint);
            this.handler.onMouseDown(evt);
        }
    };
    return MouseHandlerMoveShapeState;
}(MouseHandlerMoveShapeOrthogonallyState_1.MouseHandlerMoveShapeOrthogonallyState));
exports.MouseHandlerMoveShapeState = MouseHandlerMoveShapeState;


/***/ }),
/* 219 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerMoveShapeStateBase_1 = __webpack_require__(95);
var MouseHandlerMoveShapeOrthogonallyState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveShapeOrthogonallyState, _super);
    function MouseHandlerMoveShapeOrthogonallyState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerMoveShapeOrthogonallyState.prototype.onApplyChanges = function (evt) {
        this.calculateFixedPosition(evt);
        _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerMoveShapeOrthogonallyState.prototype.getXPosition = function (evt, baseX) {
        return this.fixedX ? baseX : _super.prototype.getXPosition.call(this, evt, baseX);
    };
    MouseHandlerMoveShapeOrthogonallyState.prototype.getYPosition = function (evt, baseY) {
        return this.fixedY ? baseY : _super.prototype.getYPosition.call(this, evt, baseY);
    };
    MouseHandlerMoveShapeOrthogonallyState.prototype.calculateFixedPosition = function (evt) {
        this.fixedX = false;
        this.fixedY = false;
        if (evt.modifiers & KeyCode_1.ModifierKey.Shift) {
            var dx = Math.abs(this.startPoint.x - evt.layoutPoint.x);
            var dy = Math.abs(this.startPoint.y - evt.layoutPoint.y);
            if (dx < dy)
                this.fixedX = true;
            else
                this.fixedY = true;
        }
    };
    return MouseHandlerMoveShapeOrthogonallyState;
}(MouseHandlerMoveShapeStateBase_1.MouseHandlerMoveShapeStateBase));
exports.MouseHandlerMoveShapeOrthogonallyState = MouseHandlerMoveShapeOrthogonallyState;


/***/ }),
/* 220 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(96);
var Connector_1 = __webpack_require__(5);
var ModelUtils_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ConnectorProperties_1 = __webpack_require__(28);
var MouseHandlerMoveConnectorPointState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorPointState, _super);
    function MouseHandlerMoveConnectorPointState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerMoveConnectorPointState.prototype.onMouseDown = function (evt) {
        this.connector = this.model.findConnector(evt.source.key);
        this.pointIndex = parseInt(evt.source.value);
        if (this.pointIndex === 0) {
            this.pointPosition = Connector_1.ConnectorPosition.Begin;
        }
        else if (this.pointIndex === this.connector.points.length - 1) {
            this.pointPosition = Connector_1.ConnectorPosition.End;
        }
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onApplyChanges = function (evt) {
        if (this.connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal ||
            this.pointIndex === 0 || this.pointIndex === this.connector.points.length - 1)
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.connector);
    };
    MouseHandlerMoveConnectorPointState.prototype.getSnappedPoint = function (evt, point) {
        var points = this.connector.points;
        var index = this.pointIndex;
        if (0 < index && index < points.length - 1) {
            var tg = (points[index + 1].y - points[index - 1].y) / (points[index + 1].x - points[index - 1].x);
            var x = point.x;
            var y = points[index + 1].y - (points[index + 1].x - x) * tg;
            return this.handler.getSnappedPoint(evt, point, new Utils_1.Point(x, y));
        }
        return this.handler.getSnappedPoint(evt, point);
    };
    return MouseHandlerMoveConnectorPointState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerMoveConnectorPointState = MouseHandlerMoveConnectorPointState;


/***/ }),
/* 221 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Event_1 = __webpack_require__(14);
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var Model_1 = __webpack_require__(21);
var ModelUtils_1 = __webpack_require__(8);
var ResizeInfoVisualizer_1 = __webpack_require__(222);
var CanvasManager_1 = __webpack_require__(44);
var MouseHandlerResizeShapeState = /** @class */ (function (_super) {
    __extends(MouseHandlerResizeShapeState, _super);
    function MouseHandlerResizeShapeState(handler, history, model, selection) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        _this.rotation = 0;
        return _this;
    }
    MouseHandlerResizeShapeState.prototype.start = function () {
        this.resizeInfoVisualizer = new ResizeInfoVisualizer_1.ResizeInfoVisualizer(this.handler.onVisualizersUpdate);
        _super.prototype.start.call(this);
    };
    MouseHandlerResizeShapeState.prototype.finish = function () {
        this.resetResizeInfo();
        this.handler.resetExtensionLines();
        _super.prototype.finish.call(this);
    };
    MouseHandlerResizeShapeState.prototype.onMouseDown = function (evt) {
        var source = parseInt(evt.source.value);
        this.resizeEventSource = source;
        this.startPoint = evt.layoutPoint;
        this.lockH = source == Event_1.ResizeEventSource.ResizeBox_S || source == Event_1.ResizeEventSource.ResizeBox_N;
        this.lockV = source == Event_1.ResizeEventSource.ResizeBox_E || source == Event_1.ResizeEventSource.ResizeBox_W;
        this.sideH = source == Event_1.ResizeEventSource.ResizeBox_E || source == Event_1.ResizeEventSource.ResizeBox_NE || source == Event_1.ResizeEventSource.ResizeBox_SE;
        this.sideV = source == Event_1.ResizeEventSource.ResizeBox_SE || source == Event_1.ResizeEventSource.ResizeBox_S || source == Event_1.ResizeEventSource.ResizeBox_SW;
        this.shapes = this.selection.getSelectedShapes();
        if (this.shapes.length === 0) {
            this.handler.switchToDefaultState();
            return;
        }
        this.connectors = this.selection.getSelectedConnectors();
        this.startRectangle = Model_1.DiagramModel.getRectangle(this.shapes);
        this.startShapeSizes = this.shapes.map(function (shape) { return shape.size.clone(); });
        this.startShapePositions = this.shapes.map(function (shape) { return shape.position.clone(); });
        this.startConnectorPoints = this.connectors.map(function (c) { return c.points.map(function (p) { return p.clone(); }); });
        this.lockAspectRatio = !!(evt.modifiers & KeyCode_1.ModifierKey.Shift);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerResizeShapeState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var items = this.selection.getSelectedItems();
        this.handler.setExtensionLines(this.selection.getSelectedShapes());
    };
    MouseHandlerResizeShapeState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        var rectangle = Model_1.DiagramModel.getRectangle(this.shapes);
        var size = this.getSize(evt, rectangle.position, this.startRectangle.size);
        var pos = this.getPosition(evt, size, this.startRectangle.size, this.startRectangle.position);
        var ratioX = size.width / this.startRectangle.width;
        var ratioY = size.height / this.startRectangle.height;
        this.shapes.forEach(function (shape, index) {
            var shapeSize = new Utils_1.Size(_this.startShapeSizes[index].width * ratioX, _this.startShapeSizes[index].height * ratioY);
            var shapePos = new Utils_1.Point(pos.x + (_this.startShapePositions[index].x - _this.startRectangle.left) * ratioX, pos.y + (_this.startShapePositions[index].y - _this.startRectangle.top) * ratioY);
            ModelUtils_1.ModelUtils.setShapeSize(_this.history, _this.model, shape.key, shapePos, shapeSize, _this.history.addOrModifyAndRedo);
            shape.attachedConnectors.forEach(function (connector) {
                ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(_this.history, connector, _this.history.addOrModifyAndRedo);
            });
        });
        this.connectors.forEach(function (connector, index) {
            var startPtIndex = connector.beginItem ? 1 : 0;
            var endPtIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
            for (var i = startPtIndex; i <= endPtIndex; i++) {
                var connectorPtPos = new Utils_1.Point(pos.x + (_this.startConnectorPoints[index][i].x - _this.startRectangle.left) * ratioX, pos.y + (_this.startConnectorPoints[index][i].y - _this.startRectangle.top) * ratioY);
                ModelUtils_1.ModelUtils.setConnectorPoint(_this.history, _this.model, connector.key, i, connectorPtPos, _this.history.addOrModifyAndRedo);
            }
        });
        this.tryUpdateModelSize();
        this.setResizeInfo();
    };
    MouseHandlerResizeShapeState.prototype.tryUpdateModelSize = function () {
        var _this = this;
        this.handler.tryUpdateModelSize(function (offsetLeft, offsetTop) {
            _this.startShapePositions.forEach(function (pt) {
                pt.x += offsetLeft;
                pt.y += offsetTop;
            });
            _this.startConnectorPoints.forEach(function (connector) {
                connector.forEach(function (pt) {
                    pt.x += offsetLeft;
                    pt.y += offsetTop;
                });
            });
            _this.startRectangle.position.x += offsetLeft;
            _this.startRectangle.position.y += offsetTop;
            _this.startPoint.x += offsetLeft;
            _this.startPoint.y += offsetTop;
        });
    };
    MouseHandlerResizeShapeState.prototype.setResizeInfo = function () {
        var rect = Model_1.DiagramModel.getRectangle(this.shapes);
        var point = new Utils_1.Point(rect.center.x, rect.bottom + CanvasManager_1.CanvasManager.resizeInfoOffset);
        var text = this.model.getModelUnitText(rect.width) + " x " + this.model.getModelUnitText(rect.height);
        this.resizeInfoVisualizer.set(point, text);
    };
    MouseHandlerResizeShapeState.prototype.resetResizeInfo = function () {
        this.resizeInfoVisualizer.reset();
    };
    MouseHandlerResizeShapeState.prototype.getDraggingElementKeys = function () {
        return this.shapes.map(function (shape) { return shape.key; });
    };
    MouseHandlerResizeShapeState.prototype.getSize = function (evt, position, startSize) {
        var absDeltaX = evt.layoutPoint.x - (this.startScrollLeft - evt.scrollX) - this.startPoint.x;
        var absDeltaY = evt.layoutPoint.y - (this.startScrollTop - evt.scrollY) - this.startPoint.y;
        var deltaX = absDeltaX * Math.cos(this.rotation) - (-absDeltaY) * Math.sin(this.rotation);
        var deltaY = -(absDeltaX * Math.sin(this.rotation) + (-absDeltaY) * Math.cos(this.rotation));
        var newWidth, newHeight;
        deltaY = !this.sideV && deltaY > 0 ? Math.min(startSize.height + 1, deltaY) : deltaY;
        deltaX = !this.sideH && deltaX > 0 ? Math.min(startSize.width + 1, deltaX) : deltaX;
        if (!this.lockH && !this.lockV && this.lockAspectRatio) {
            if (Math.abs(deltaX) > Math.abs(deltaY)) {
                newWidth = this.sideH ? Math.max(MouseHandlerResizeShapeState.minSize, startSize.width + deltaX) : (startSize.width - deltaX);
                newHeight = startSize.height * (newWidth / startSize.width);
            }
            else {
                newHeight = this.sideV ? Math.max(MouseHandlerResizeShapeState.minSize, startSize.height + deltaY) : (startSize.height - deltaY);
                newWidth = startSize.width * (newHeight / startSize.height);
            }
        }
        else {
            deltaX = this.lockH ? 0 : deltaX;
            deltaY = this.lockV ? 0 : deltaY;
            newWidth = Math.max(MouseHandlerResizeShapeState.minSize, this.sideH ? (startSize.width + deltaX) : (startSize.width - deltaX));
            newHeight = Math.max(MouseHandlerResizeShapeState.minSize, this.sideV ? (startSize.height + deltaY) : (startSize.height - deltaY));
        }
        if (!this.lockH)
            newWidth = this.handler.getSnappedPos(evt, position.x + newWidth) - position.x;
        if (!this.lockV)
            newHeight = this.handler.getSnappedPos(evt, position.y + newHeight) - position.y;
        return new Utils_1.Size(newWidth, newHeight);
    };
    MouseHandlerResizeShapeState.prototype.getPosition = function (evt, size, startSize, startPosition) {
        var x = startPosition.x;
        var y = startPosition.y;
        if (this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_N ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NE ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NW) {
            y += startSize.height - size.height;
            var snappedY = this.handler.getSnappedPos(evt, y);
            size.height += y - snappedY;
            y = snappedY;
        }
        if (this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_W ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NW ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_SW) {
            x += startSize.width - size.width;
            var snappedX = this.handler.getSnappedPos(evt, x);
            size.width += x - snappedX;
            x = snappedX;
        }
        return new Utils_1.Point(x, y);
    };
    MouseHandlerResizeShapeState.minSize = 360;
    return MouseHandlerResizeShapeState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerResizeShapeState = MouseHandlerResizeShapeState;


/***/ }),
/* 222 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ResizeInfoVisualizer = /** @class */ (function () {
    function ResizeInfoVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
    }
    ResizeInfoVisualizer.prototype.set = function (point, text) {
        this.point = point;
        this.text = text;
        this.raiseShow();
    };
    ResizeInfoVisualizer.prototype.reset = function () {
        if (this.point !== undefined) {
            this.point = undefined;
            this.text = undefined;
            this.raiseHide();
        }
    };
    ResizeInfoVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.NotifyResizeInfoShow(_this.point, _this.text); });
    };
    ResizeInfoVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.NotifyResizeInfoHide(); });
    };
    return ResizeInfoVisualizer;
}());
exports.ResizeInfoVisualizer = ResizeInfoVisualizer;


/***/ }),
/* 223 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var AddConnectorPointHistoryItem_1 = __webpack_require__(97);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(36);
var ModelUtils_1 = __webpack_require__(8);
var MouseHandlerMoveConnectorSideState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorSideState, _super);
    function MouseHandlerMoveConnectorSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
        this.connectorKey = evt.source.key;
        this.pointIndex = parseInt(evt.source.value);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorSideState.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.layoutPoint);
        if (!this.pointCreated) {
            this.history.addOrModifyAndRedo(new AddConnectorPointHistoryItem_1.AddConnectorPointHistoryItem(this.connectorKey, this.pointIndex, point));
            this.pointCreated = true;
        }
        else {
            this.history.addOrModifyAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(this.connectorKey, this.pointIndex, point));
        }
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorSideState.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.model.findConnector(this.connectorKey));
    };
    MouseHandlerMoveConnectorSideState.prototype.getDraggingElementKeys = function () {
        return [this.connectorKey];
    };
    return MouseHandlerMoveConnectorSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorSideState = MouseHandlerMoveConnectorSideState;


/***/ }),
/* 224 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var ChangeShapeParametersHistoryItem_1 = __webpack_require__(225);
var MouseHandlerDragParameterPointState = /** @class */ (function (_super) {
    __extends(MouseHandlerDragParameterPointState, _super);
    function MouseHandlerDragParameterPointState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        return _this;
    }
    MouseHandlerDragParameterPointState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
        this.shape = this.model.findShape(evt.source.key);
        this.parameterPointKey = evt.source.value;
        this.startParameters = this.shape.parameters.clone();
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerDragParameterPointState.prototype.onApplyChanges = function (evt) {
        var offsetX = this.handler.getSnappedPos(evt, evt.layoutPoint.x - this.startPoint.x);
        var offsetY = this.handler.getSnappedPos(evt, evt.layoutPoint.y - this.startPoint.y);
        var parameters = this.startParameters.clone();
        this.shape.description.modifyParameters(this.shape, parameters, offsetX, offsetY);
        this.history.addOrModifyAndRedo(new ChangeShapeParametersHistoryItem_1.ChangeShapeParametersHistoryItem(this.shape.key, parameters));
    };
    MouseHandlerDragParameterPointState.prototype.getDraggingElementKeys = function () {
        return [this.shape.key];
    };
    return MouseHandlerDragParameterPointState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerDragParameterPointState = MouseHandlerDragParameterPointState;


/***/ }),
/* 225 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(4);
var ChangeShapeParametersHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeShapeParametersHistoryItem, _super);
    function ChangeShapeParametersHistoryItem(shapeKey, parameters) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.parameters = parameters;
        return _this;
    }
    ChangeShapeParametersHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldParameters = shape.parameters.clone();
        manipulator.changeShapeParameters(shape, this.parameters);
    };
    ChangeShapeParametersHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeParameters(shape, this.oldParameters);
    };
    return ChangeShapeParametersHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeParametersHistoryItem = ChangeShapeParametersHistoryItem;


/***/ }),
/* 226 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Event_1 = __webpack_require__(14);
var Utils_1 = __webpack_require__(0);
var SelectionRectVisualizer_1 = __webpack_require__(227);
var MouseHandlerStateBase_1 = __webpack_require__(45);
var MouseHandlerSelectionState = /** @class */ (function (_super) {
    __extends(MouseHandlerSelectionState, _super);
    function MouseHandlerSelectionState(handler, selection) {
        var _this = _super.call(this, handler) || this;
        _this.selection = selection;
        return _this;
    }
    MouseHandlerSelectionState.prototype.cancelChanges = function () { };
    MouseHandlerSelectionState.prototype.start = function () {
        this.selectionRectangleVisualizer = new SelectionRectVisualizer_1.SelectionRectVisualizer(this.handler.onVisualizersUpdate);
        _super.prototype.start.call(this);
    };
    MouseHandlerSelectionState.prototype.finish = function () {
        this.selectionRectangleVisualizer.reset();
        _super.prototype.finish.call(this);
    };
    MouseHandlerSelectionState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
    };
    MouseHandlerSelectionState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left) {
            this.handler.switchToDefaultState();
            return;
        }
        var rect = Utils_1.Rectangle.createByPoints(this.startPoint, evt.layoutPoint);
        this.selectionRectangleVisualizer.setRectangle(rect);
    };
    MouseHandlerSelectionState.prototype.onMouseUp = function (evt) {
        var selectionRect = this.selectionRectangleVisualizer.getRectangle();
        if (selectionRect !== undefined)
            this.selection.selectRect(selectionRect);
        else
            this.selection.set([]);
        this.handler.switchToDefaultState();
    };
    return MouseHandlerSelectionState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerSelectionState = MouseHandlerSelectionState;


/***/ }),
/* 227 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var SelectionRectVisualizer = /** @class */ (function () {
    function SelectionRectVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
    }
    SelectionRectVisualizer.prototype.getRectangle = function () {
        return this.rect;
    };
    SelectionRectVisualizer.prototype.setRectangle = function (rect) {
        this.rect = rect;
        this.raiseShow();
    };
    SelectionRectVisualizer.prototype.reset = function () {
        this.rect = undefined;
        this.raiseHide();
    };
    SelectionRectVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.NotifySelectionRectShow(_this.rect); });
    };
    SelectionRectVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.NotifySelectionRectHide(); });
    };
    return SelectionRectVisualizer;
}());
exports.SelectionRectVisualizer = SelectionRectVisualizer;


/***/ }),
/* 228 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var AddConnectionHistoryItem_1 = __webpack_require__(35);
var AddConnectorHistoryItem_1 = __webpack_require__(58);
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(96);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(91);
var ChangeStyleHistoryItem_1 = __webpack_require__(63);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(42);
var MouseHandlerCreateConnectorState = /** @class */ (function (_super) {
    __extends(MouseHandlerCreateConnectorState, _super);
    function MouseHandlerCreateConnectorState(handler, history, model, selection, connectionPointIndex) {
        var _this = _super.call(this, handler, history, model) || this;
        _this.selection = selection;
        _this.connectionPointIndex = connectionPointIndex;
        return _this;
    }
    MouseHandlerCreateConnectorState.prototype.onMouseDown = function (evt) {
        if (this.connectionPointIndex === undefined)
            this.connectionPointIndex = parseInt(evt.source.value);
        this.connectedItem = this.model.findItem(evt.source.key);
        this.pointIndex = 1;
        this.pointPosition = Connector_1.ConnectorPosition.End;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        var point = this.getSnappedPoint(evt, evt.layoutPoint);
        if (!this.connector) {
            var historyItem = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([this.connectedItem.getConnectionPoint(this.connectionPointIndex, point), point]);
            this.history.addOrModifyAndRedo(historyItem);
            this.connector = this.model.findConnector(historyItem.connectorKey);
            this.connector.properties.forEach(function (propertyName) {
                _this.history.addOrModifyAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(_this.connector.key, propertyName, _this.selection.inputPosition.getConnectorPropertyDefaultValue(propertyName)));
            });
            this.connector.style.forEach(function (propertyName) {
                _this.history.addOrModifyAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(_this.connector.key, propertyName, _this.selection.inputPosition.getStylePropertyDefaultValue(propertyName)));
            });
            this.connector.styleText.forEach(function (propertyName) {
                _this.history.addOrModifyAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(_this.connector.key, propertyName, _this.selection.inputPosition.getStyleTextPropertyDefaultValue(propertyName)));
            });
            this.history.addOrModifyAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, this.connectedItem, this.connectionPointIndex, Connector_1.ConnectorPosition.Begin));
        }
        else
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onFinishWithChanges = function () {
        this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.connector.key]));
    };
    return MouseHandlerCreateConnectorState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerCreateConnectorState = MouseHandlerCreateConnectorState;


/***/ }),
/* 229 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Connector_1 = __webpack_require__(5);
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var AddConnectorPointHistoryItem_1 = __webpack_require__(97);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(36);
var ModelUtils_1 = __webpack_require__(8);
var DiagramItem_1 = __webpack_require__(3);
var MouseHandlerMoveConnectorOrthogonalSideState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorOrthogonalSideState, _super);
    function MouseHandlerMoveConnectorOrthogonalSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
        this.connector = this.model.findConnector(evt.source.key);
        var renderPointIndexes = evt.source.value.split("_");
        var renderPointIndex1 = parseInt(renderPointIndexes[0]);
        var renderPointIndex2 = parseInt(renderPointIndexes[1]);
        var points = this.connector.getRenderPoints(true);
        this.renderPoint1 = points[renderPointIndex1].clone();
        this.renderPoint2 = points[renderPointIndex2].clone();
        this.isVerticalOrientation = this.renderPoint1.x === this.renderPoint2.x;
        if (this.renderPoint1.pointIndex !== -1) {
            this.pointIndex1 = this.renderPoint1.pointIndex;
            if (this.pointIndex1 === 0) {
                this.pointIndex1++;
                this.correctEdgePoint(this.renderPoint1, this.renderPoint2, this.connector.beginItem, this.connector.beginConnectionPointIndex);
            }
            else
                this.point1 = this.connector.points[this.pointIndex1];
        }
        else
            this.pointIndex1 = this.findPointIndex(points, renderPointIndex1, false) + 1;
        if (this.renderPoint2.pointIndex !== -1) {
            this.pointIndex2 = this.renderPoint2.pointIndex;
            if (this.pointIndex2 === this.connector.points.length - 1) {
                this.correctEdgePoint(this.renderPoint2, this.renderPoint1, this.connector.endItem, this.connector.endConnectionPointIndex);
            }
            else
                this.point2 = this.connector.points[this.pointIndex2];
        }
        else
            this.pointIndex2 = this.findPointIndex(points, renderPointIndex2, true);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        if (!this.pointCreated) {
            var createdPoint1 = void 0, createdPoint2 = void 0;
            if (this.point1 === undefined) {
                this.point1 = new Utils_1.Point(this.renderPoint1.x, this.renderPoint1.y);
                this.history.addOrModifyAndRedo(new AddConnectorPointHistoryItem_1.AddConnectorPointHistoryItem(this.connector.key, this.pointIndex1, this.point1));
                createdPoint1 = this.point1;
                this.pointIndex2++;
            }
            if (this.point2 === undefined) {
                this.point2 = new Utils_1.Point(this.renderPoint2.x, this.renderPoint2.y);
                this.history.addOrModifyAndRedo(new AddConnectorPointHistoryItem_1.AddConnectorPointHistoryItem(this.connector.key, this.pointIndex2, this.point2));
                createdPoint2 = this.point2;
            }
            ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.connector, [createdPoint1, createdPoint2], function (index) {
                if (index < _this.pointIndex1)
                    _this.pointIndex1--;
                if (index < _this.pointIndex2)
                    _this.pointIndex2--;
            });
            this.pointCreated = true;
        }
        var point = this.getSnappedPoint(evt, evt.layoutPoint);
        if (this.isVerticalOrientation) {
            this.point1.x = point.x;
            this.point2.x = point.x;
        }
        else {
            this.point1.y = point.y;
            this.point2.y = point.y;
        }
        this.history.addOrModifyAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(this.connector.key, this.pointIndex1, this.point1));
        this.history.addOrModifyAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(this.connector.key, this.pointIndex2, this.point2));
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.connector);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.findPointIndex = function (points, index, direction) {
        var point;
        while (point = points[index]) {
            if (point.pointIndex !== -1)
                return point.pointIndex;
            index += direction ? 1 : -1;
        }
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.correctEdgePoint = function (point, directionPoint, item, connectionPointIndex) {
        var offset = 0;
        if (item !== undefined) {
            var side = item.getConnectionPointSide(connectionPointIndex);
            var rect = item.rectangle;
            offset = Connector_1.Connector.minOffset;
            switch (side) {
                case DiagramItem_1.ConnectionPointSide.South:
                    offset += rect.bottom - point.y;
                    break;
                case DiagramItem_1.ConnectionPointSide.North:
                    offset += point.y - rect.top;
                    break;
                case DiagramItem_1.ConnectionPointSide.East:
                    offset += rect.right - point.x;
                    break;
                case DiagramItem_1.ConnectionPointSide.West:
                    offset += point.x - rect.left;
                    break;
            }
        }
        if (this.isVerticalOrientation) {
            if (point.y > directionPoint.y)
                point.y -= Math.min(offset, point.y - directionPoint.y);
            else
                point.y += Math.min(offset, directionPoint.y - point.y);
        }
        else {
            if (point.x > directionPoint.x)
                point.x -= Math.min(offset, point.x - directionPoint.x);
            else
                point.x += Math.min(offset, directionPoint.x - point.x);
        }
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.getDraggingElementKeys = function () {
        return [this.connector.key];
    };
    return MouseHandlerMoveConnectorOrthogonalSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorOrthogonalSideState = MouseHandlerMoveConnectorOrthogonalSideState;


/***/ }),
/* 230 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescriptionManager_1 = __webpack_require__(30);
var Utils_1 = __webpack_require__(0);
var AddShapeHistoryItem_1 = __webpack_require__(51);
var SetSelectionHistoryItem_1 = __webpack_require__(29);
var ChangeStyleHistoryItem_1 = __webpack_require__(63);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(42);
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var DeleteShapeHistoryItem_1 = __webpack_require__(74);
var ModelUtils_1 = __webpack_require__(8);
var MouseHandlerStateBase_1 = __webpack_require__(45);
var NON_DOCUMENT_TIMER = 500;
var LOCK_UPDATEPAGESIZE_TIMER = 300;
var MouseHandlerBeforeToolboxDraggingState = /** @class */ (function (_super) {
    __extends(MouseHandlerBeforeToolboxDraggingState, _super);
    function MouseHandlerBeforeToolboxDraggingState(handler, history, model, selection) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.model = model;
        _this.selection = selection;
        return _this;
    }
    MouseHandlerBeforeToolboxDraggingState.prototype.cancelChanges = function () {
        this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragEnd = function (evt) {
        this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onMouseMove = function (evt) {
        var _this = this;
        if (this.canSwitchToDraggingState(evt)) {
            this.tryRemoveTimer();
            this.switchToDraggingState(evt, false);
        }
        else if (evt.source.type !== undefined) {
            this.savedEvt = evt;
            if (this.nonPageAreaTimer === undefined)
                this.nonPageAreaTimer = setTimeout(function () { return _this.switchToDraggingState(_this.savedEvt, true); }, NON_DOCUMENT_TIMER);
        }
        else if (this.nonPageAreaTimer !== undefined)
            this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.switchToDraggingState = function (evt, skipLockUpdatePageSize) {
        this.handler.switchState(new MouseHandlerToolboxDraggingState(this.handler, this.history, this.model, this.selection, skipLockUpdatePageSize));
        this.handler.state.onDragStart(this.dragging);
        this.handler.state.onMouseMove(evt);
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.canSwitchToDraggingState = function (evt) {
        return evt.source.type !== undefined &&
            evt.layoutPoint.x >= 0 && evt.layoutPoint.x <= this.model.size.width &&
            evt.layoutPoint.y >= 0 && evt.layoutPoint.y <= this.model.size.height;
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.tryRemoveTimer = function () {
        if (this.nonPageAreaTimer !== undefined) {
            clearTimeout(this.nonPageAreaTimer);
            delete this.nonPageAreaTimer;
        }
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.finish = function () {
        this.tryRemoveTimer();
    };
    return MouseHandlerBeforeToolboxDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerBeforeToolboxDraggingState = MouseHandlerBeforeToolboxDraggingState;
var MouseHandlerToolboxDraggingState = /** @class */ (function (_super) {
    __extends(MouseHandlerToolboxDraggingState, _super);
    function MouseHandlerToolboxDraggingState(handler, history, model, selection, skipLockUpdatePageSize) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        if (!skipLockUpdatePageSize) {
            _this.updatePageSizeTimer = setTimeout(function () {
                _this.handler.tryUpdateModelSize();
                delete _this.updatePageSizeTimer;
            }, LOCK_UPDATEPAGESIZE_TIMER);
        }
        return _this;
    }
    MouseHandlerToolboxDraggingState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var shape = this.model.findShape(this.shapeKey);
        if (shape)
            this.handler.setExtensionLines([shape]);
    };
    MouseHandlerToolboxDraggingState.prototype.getDraggingElementKeys = function () {
        return this.shapeKey === undefined ? [] : [this.shapeKey];
    };
    MouseHandlerToolboxDraggingState.prototype.onApplyChanges = function (evt) {
        if (evt.source.type === undefined) {
            this.dragging.onCaptured(false);
            if (this.shapeKey !== undefined && !this.deleteHistoryItem) {
                this.deleteHistoryItem = new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(this.shapeKey);
                this.history.addOrModifyAndRedo(this.deleteHistoryItem);
            }
            return;
        }
        this.dragging.onCaptured(true);
        if (this.shapeKey === undefined) {
            this.startPoint = evt.layoutPoint;
            this.shapeKey = this.insertToolboxItem(evt);
        }
        if (this.deleteHistoryItem) {
            this.history.undoTransactionTo(this.deleteHistoryItem);
            delete this.deleteHistoryItem;
        }
        var pos = this.getPosition(evt, this.startShapePosition);
        ModelUtils_1.ModelUtils.setShapePosition(this.history, this.model, this.shapeKey, pos, this.history.addOrModifyAndRedo);
        if (this.updatePageSizeTimer === undefined)
            this.handler.tryUpdateModelSize();
    };
    MouseHandlerToolboxDraggingState.prototype.onFinishWithChanges = function () {
        this.history.addOrModifyAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.shapeKey]));
    };
    MouseHandlerToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
    };
    MouseHandlerToolboxDraggingState.prototype.onDragEnd = function (evt) {
        if (this.shapeKey !== undefined && evt.source.type === undefined)
            this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerToolboxDraggingState.prototype.finish = function () {
        this.handler.resetExtensionLines();
        this.dragging.onFinishDragging();
        _super.prototype.finish.call(this);
    };
    MouseHandlerToolboxDraggingState.prototype.updateShapeProperties = function (itemKey) {
        var _this = this;
        this.selection.inputPosition.stylePropertiesDefault.forEach(function (propertyName) {
            _this.history.addOrModifyAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(itemKey, propertyName, _this.selection.inputPosition.getStylePropertyDefaultValue(propertyName)));
        });
        this.selection.inputPosition.styleTextPropertiesDefault.forEach(function (propertyName) {
            _this.history.addOrModifyAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(itemKey, propertyName, _this.selection.inputPosition.getStyleTextPropertyValue(propertyName)));
        });
    };
    MouseHandlerToolboxDraggingState.prototype.insertToolboxItem = function (evt) {
        var description = ShapeDescriptionManager_1.ShapeDescriptionManager.get(this.dragging.shapeType);
        this.startShapePosition = this.getSnappedPoint(evt, new Utils_1.Point(evt.layoutPoint.x - description.defaultSize.width / 2, evt.layoutPoint.y - description.defaultSize.height / 2));
        var historyItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(this.dragging.shapeType, this.startShapePosition, this.dragging.item && this.dragging.item.text);
        this.history.addOrModifyAndRedo(historyItem);
        this.updateShapeProperties(historyItem.shapeKey);
        return historyItem.shapeKey;
    };
    MouseHandlerToolboxDraggingState.prototype.getPosition = function (evt, basePoint) {
        return this.getSnappedPoint(evt, new Utils_1.Point(basePoint.x + evt.layoutPoint.x - this.startPoint.x, basePoint.y + evt.layoutPoint.y - this.startPoint.y));
    };
    return MouseHandlerToolboxDraggingState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerToolboxDraggingState = MouseHandlerToolboxDraggingState;


/***/ }),
/* 231 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerDraggingState_1 = __webpack_require__(24);
var ChangeConnectorTextPositionHistoryItem_1 = __webpack_require__(232);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(98);
var MouseHandlerMoveConnectorTextState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorTextState, _super);
    function MouseHandlerMoveConnectorTextState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorTextState.prototype.onMouseDown 