/*!
* DevExtreme (dx.web.de.js)
* Version: 17.2.3
* Build date: Wed Nov 15 2017
*
* Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define(function(require) {
            factory(require("devextreme/localization"), require("devextreme/core/errors"))
        })
    } else {
        factory(DevExpress.localization, DevExpress.errors)
    }
}(this, function(localization, errors) {
    errors.log("W0013", "devextreme/dist/js/localization/dx.web.de.js", "16.2", "Use the 'devextreme/dist/js/localization/dx.messages.de.js' file instead.");
    localization.loadMessages({
        de: {
            Yes: "Ja",
            No: "Nein",
            Cancel: "Abbrechen",
            Clear: "Löschen",
            Done: "Fertig",
            Loading: "Laden...",
            Select: "Auswählen...",
            Search: "Suchen...",
            Back: "Zurück",
            OK: "OK",
            "dxCollectionWidget-noDataText": "Keine Daten verfügbar",
            "validation-required": "Pflichtfeld",
            "validation-required-formatted": "{0} ist ein Pflichtfeld",
            "validation-numeric": "Der Wert muss eine Zahl sein",
            "validation-numeric-formatted": "{0} muss eine Zahl sein",
            "validation-range": "Der Wert ist nicht im gültigen Bereich",
            "validation-range-formatted": "{0} ist nicht im gültigen Bereich",
            "validation-stringLength": "Die Länge des Wertes ist nicht korrekt",
            "validation-stringLength-formatted": "Die Länge von {0} ist nicht korrekt",
            "validation-custom": "Der Wert ist ungültig",
            "validation-custom-formatted": "{0} ist ungültig",
            "validation-compare": "Der Wert ist unpassend",
            "validation-compare-formatted": "{0} ist unpassend",
            "validation-pattern": "Der Wert passt nicht zum Muster",
            "validation-pattern-formatted": "{0} passt nicht zum Muster",
            "validation-email": "Die Email-Adresse ist ungültig",
            "validation-email-formatted": "{0} ist ungültig",
            "validation-mask": "Der Wert ist ungültig",
            "dxLookup-searchPlaceholder": "Minimale Anzahl Zeichen: {0}",
            "dxList-pullingDownText": "Zum Aktualisieren nach unten ziehen",
            "dxList-pulledDownText": "Zum Aktualisieren loslassen",
            "dxList-refreshingText": "Aktualisiere...",
            "dxList-pageLoadingText": "Laden...",
            "dxList-nextButtonText": "Mehr",
            "dxList-selectAll": "Alles auswählen",
            "dxListEditDecorator-delete": "Entfernen",
            "dxListEditDecorator-more": "Mehr",
            "dxScrollView-pullingDownText": "Zum Aktualisieren nach unten ziehen",
            "dxScrollView-pulledDownText": "Zum Aktualisieren loslassen",
            "dxScrollView-refreshingText": "Aktualisiere...",
            "dxScrollView-reachBottomText": "Laden...",
            "dxDateBox-simulatedDataPickerTitleTime": "Zeit auswählen",
            "dxDateBox-simulatedDataPickerTitleDate": "Datum auswählen",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Datum und Zeit auswählen",
            "dxDateBox-validation-datetime": "Der Wert muss ein Datum oder eine Uhrzeit sein",
            "dxFileUploader-selectFile": "Datei auswählen",
            "dxFileUploader-dropFile": "oder hierher ziehen",
            "dxFileUploader-bytes": "Bytes",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "Hochladen",
            "dxFileUploader-uploaded": "Hochgeladen",
            "dxFileUploader-readyToUpload": "Bereit zum hochladen",
            "dxFileUploader-uploadFailedMessage": "Fehler beim hochladen",
            "dxRangeSlider-ariaFrom": "Von",
            "dxRangeSlider-ariaTill": "Bis",
            "dxSwitch-onText": "EIN",
            "dxSwitch-offText": "AUS",
            "dxForm-optionalMark": "optional",
            "dxForm-requiredMessage": "{0} ist ein Pflichtfeld",
            "dxNumberBox-invalidValueMessage": "Der Wert muss eine Zahl sein",
            "dxDataGrid-columnChooserTitle": "Spaltenauswahl",
            "dxDataGrid-columnChooserEmptyText": "Ziehen Sie Spalten hierhin, um sie zu verstecken",
            "dxDataGrid-groupContinuesMessage": "Weiter auf der nächsten Seite",
            "dxDataGrid-groupContinuedMessage": "Weiter von der vorherigen Seite",
            "dxDataGrid-groupHeaderText": "Nach dieser Spalte gruppieren",
            "dxDataGrid-ungroupHeaderText": "Gruppierung entfernen",
            "dxDataGrid-ungroupAllText": "Alle Gruppierungen entfernen",
            "dxDataGrid-editingEditRow": "Bearbeiten",
            "dxDataGrid-editingSaveRowChanges": "Speichern",
            "dxDataGrid-editingCancelRowChanges": "Abbrechen",
            "dxDataGrid-editingDeleteRow": "Entfernen",
            "dxDataGrid-editingUndeleteRow": "Wiederherstellen",
            "dxDataGrid-editingConfirmDeleteMessage": "Sind Sie sicher, dass Sie diesen Datensatz löschen wollen?",
            "dxDataGrid-validationCancelChanges": "Änderungen verwerfen",
            "dxDataGrid-groupPanelEmptyText": "Ziehen Sie eine Spalte hierhin, um danach zu gruppieren",
            "dxDataGrid-noDataText": "Keine Daten",
            "dxDataGrid-searchPanelPlaceholder": "Suchen...",
            "dxDataGrid-filterRowShowAllText": "(Alle)",
            "dxDataGrid-filterRowResetOperationText": "Zurücksetzen",
            "dxDataGrid-filterRowOperationEquals": "Ist gleich",
            "dxDataGrid-filterRowOperationNotEquals": "Ist nicht gleich",
            "dxDataGrid-filterRowOperationLess": "Kleiner als",
            "dxDataGrid-filterRowOperationLessOrEquals": "Kleiner oder gleich",
            "dxDataGrid-filterRowOperationGreater": "Größer als",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Größer oder gleich",
            "dxDataGrid-filterRowOperationStartsWith": "Beginnt mit",
            "dxDataGrid-filterRowOperationContains": "Enthält",
            "dxDataGrid-filterRowOperationNotContains": "Enthält nicht",
            "dxDataGrid-filterRowOperationEndsWith": "Endet mit",
            "dxDataGrid-filterRowOperationBetween": "Zwischen",
            "dxDataGrid-filterRowOperationBetweenStartText": "Anfang",
            "dxDataGrid-filterRowOperationBetweenEndText": "Ende",
            "dxDataGrid-applyFilterText": "Filter anwenden",
            "dxDataGrid-trueText": "wahr",
            "dxDataGrid-falseText": "falsch",
            "dxDataGrid-sortingAscendingText": "Aufsteigend sortieren",
            "dxDataGrid-sortingDescendingText": "Absteigend sortieren",
            "dxDataGrid-sortingClearText": "Sortierung aufheben",
            "dxDataGrid-editingSaveAllChanges": "Änderungen speichern",
            "dxDataGrid-editingCancelAllChanges": "Änderungen verwerfen",
            "dxDataGrid-editingAddRow": "Neue Zeile",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Minimum von {1} ist {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maximum von {1} ist {0}",
            "dxDataGrid-summaryAvg": "Ø: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Durchschnitt von {1} ist {0}",
            "dxDataGrid-summarySum": "Summe: {0}",
            "dxDataGrid-summarySumOtherColumn": "Summe von {1} ist {0}",
            "dxDataGrid-summaryCount": "Anzahl: {0}",
            "dxDataGrid-columnFixingFix": "Fixieren",
            "dxDataGrid-columnFixingUnfix": "Lösen",
            "dxDataGrid-columnFixingLeftPosition": "Nach links",
            "dxDataGrid-columnFixingRightPosition": "Nach rechts",
            "dxDataGrid-exportTo": "Exportieren",
            "dxDataGrid-exportToExcel": "Exportieren als Excel-Datei",
            "dxDataGrid-excelFormat": "Excel-Datei",
            "dxDataGrid-selectedRows": "Ausgewählte Zeilen",
            "dxDataGrid-exportAll": "Alle Daten exportieren",
            "dxDataGrid-exportSelectedRows": "Ausgewählte Zeilen exportieren",
            "dxDataGrid-headerFilterEmptyValue": "(Leerwerte)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Abbrechen",
            "dxDataGrid-ariaColumn": "Spalte",
            "dxDataGrid-ariaValue": "Wert",
            "dxDataGrid-ariaFilterCell": "Filterzelle",
            "dxDataGrid-ariaCollapse": "Zusammenklappen",
            "dxDataGrid-ariaExpand": "Aufklappen",
            "dxDataGrid-ariaDataGrid": "Datentabelle",
            "dxDataGrid-ariaSearchInGrid": "Suchen in der Datentabelle",
            "dxDataGrid-ariaSelectAll": "Alle auswählen",
            "dxDataGrid-ariaSelectRow": "Zeile auswählen",
            "dxTreeList-ariaTreeList": "Strukturliste",
            "dxTreeList-editingAddRowToNode": "Hinzufügen",
            "dxPager-infoText": "Seite {0} von {1} ({2} Elemente)",
            "dxPager-pagesCountText": "von",
            "dxPivotGrid-grandTotal": "Gesamt",
            "dxPivotGrid-total": "{0} Gesamt",
            "dxPivotGrid-fieldChooserTitle": "Feldauswahl",
            "dxPivotGrid-showFieldChooser": "Feldauswahl anzeigen",
            "dxPivotGrid-expandAll": "Alle aufklappen",
            "dxPivotGrid-collapseAll": "Alle zusammenklappen",
            "dxPivotGrid-sortColumnBySummary": '"{0}" nach dieser Spalte sortieren',
            "dxPivotGrid-sortRowBySummary": '"{0}" nach dieser Zeile sortieren',
            "dxPivotGrid-removeAllSorting": "Sortierungen entfernen",
            "dxPivotGrid-dataNotAvailable": "Entf.",
            "dxPivotGrid-rowFields": "Zeilenfelder",
            "dxPivotGrid-columnFields": "Spaltenfelder",
            "dxPivotGrid-dataFields": "Datenfelder",
            "dxPivotGrid-filterFields": "Filterfelder",
            "dxPivotGrid-allFields": "Alle Felder",
            "dxPivotGrid-columnFieldArea": "Spaltenfelder hierher ziehen",
            "dxPivotGrid-dataFieldArea": "Datenfelder hierher ziehen",
            "dxPivotGrid-rowFieldArea": "Zeilenfelder hierher ziehen",
            "dxPivotGrid-filterFieldArea": "Filterfelder hierher ziehen",
            "dxScheduler-editorLabelTitle": "Betreff",
            "dxScheduler-editorLabelStartDate": "Anfangszeit",
            "dxScheduler-editorLabelEndDate": "Endzeit",
            "dxScheduler-editorLabelDescription": "Beschreibung",
            "dxScheduler-editorLabelRecurrence": "Wiederholung",
            "dxScheduler-openAppointment": "Termin öffnen",
            "dxScheduler-recurrenceNever": "Nie",
            "dxScheduler-recurrenceDaily": "Täglich",
            "dxScheduler-recurrenceWeekly": "Wöchentlich",
            "dxScheduler-recurrenceMonthly": "Monatlich",
            "dxScheduler-recurrenceYearly": "Jährlich",
            "dxScheduler-recurrenceEvery": "Alle",
            "dxScheduler-recurrenceEnd": "Wiederholungsende",
            "dxScheduler-recurrenceAfter": "Nach",
            "dxScheduler-recurrenceOn": "Am",
            "dxScheduler-recurrenceRepeatDaily": "Tag(e)",
            "dxScheduler-recurrenceRepeatWeekly": "Woche(n)",
            "dxScheduler-recurrenceRepeatMonthly": "Monat(e)",
            "dxScheduler-recurrenceRepeatYearly": "Jahr(e)",
            "dxScheduler-switcherDay": "Tag",
            "dxScheduler-switcherWeek": "Woche",
            "dxScheduler-switcherWorkWeek": "Arbeitswoche",
            "dxScheduler-switcherMonth": "Monat",
            "dxScheduler-switcherTimelineDay": "Zeitstrahl Tag",
            "dxScheduler-switcherTimelineWeek": "Zeitstrahl Woche",
            "dxScheduler-switcherTimelineWorkWeek": "Zeitstrahl Arbeitswoche",
            "dxScheduler-switcherTimelineMonth": "Zeitstrahl Monat",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-recurrenceRepeatOnDate": "am Datum",
            "dxScheduler-recurrenceRepeatCount": "Ereignisse",
            "dxScheduler-allDay": "Ganztägig",
            "dxScheduler-confirmRecurrenceEditMessage": "Möchten Sie nur diesen Termin bearbeiten, oder die gesamte Serie?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Möchten Sie nur diesen Termin löschen, oder die gesamte Serie?",
            "dxScheduler-confirmRecurrenceEditSeries": "Serie bearbeiten",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Serie löschen",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Termin bearbeiten",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Termin löschen",
            "dxScheduler-noTimezoneTitle": "Keine Zeitzone",
            "dxScheduler-moreAppointments": "{0} weitere",
            "dxCalendar-todayButtonText": "Heute",
            "dxCalendar-ariaWidgetName": "Kalendar",
            "dxColorView-ariaRed": "Rot",
            "dxColorView-ariaGreen": "Grün",
            "dxColorView-ariaBlue": "Blau",
            "dxColorView-ariaAlpha": "Transparenz",
            "dxColorView-ariaHex": "Farbwert",
            "dxTagBox-selected": "{0} ausgewählt",
            "dxTagBox-allSelected": "Alle ausgewählt ({0})",
            "dxTagBox-moreSelected": "{0} weitere",
            "vizExport-printingButtonText": "Drucken",
            "vizExport-titleMenuText": "Export/Druck",
            "vizExport-exportButtonText": "{0}-Datei",
            "dxFilterBuilder-and": "Und",
            "dxFilterBuilder-or": "Oder",
            "dxFilterBuilder-notAnd": "Nicht Und",
            "dxFilterBuilder-notOr": "Nicht Oder",
            "dxFilterBuilder-addCondition": "Bedingung hinzufügen",
            "dxFilterBuilder-addGroup": "Gruppe hinzufügen",
            "dxFilterBuilder-enterValueText": "<Wert eingeben>",
            "dxFilterBuilder-filterOperationEquals": "Ist gleich",
            "dxFilterBuilder-filterOperationNotEquals": "Ist nicht gleich",
            "dxFilterBuilder-filterOperationLess": "Kleiner als",
            "dxFilterBuilder-filterOperationLessOrEquals": "Kleiner oder gleich",
            "dxFilterBuilder-filterOperationGreater": "Größer als",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Größer oder gleich",
            "dxFilterBuilder-filterOperationStartsWith": "Beginnt mit",
            "dxFilterBuilder-filterOperationContains": "Enthält",
            "dxFilterBuilder-filterOperationNotContains": "Enthält nicht",
            "dxFilterBuilder-filterOperationEndsWith": "Endet mit",
            "dxFilterBuilder-filterOperationIsBlank": "Ist leer",
            "dxFilterBuilder-filterOperationIsNotBlank": "Ist nicht leer"
        }
    })
});
