/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 20.1.6
 * Build date: Fri Jul 17 2020
 *
 * Copyright (c) 2012 - 2020 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 919)
}([
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/extend.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isPlainObject = __webpack_require__( /*! ./type */ 1).isPlainObject;
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (Object.prototype.hasOwnProperty.call(source, prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        var extend = function extend(target) {
            target = target || {};
            var i = 1;
            var deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var targetValue = target[key];
                    var sourceValue = source[key];
                    var sourceValueIsArray = false;
                    var clone = void 0;
                    if ("__proto__" === key || target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && (isPlainObject(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && isPlainObject(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend;
        exports.extendFromObject = extendFromObject
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/type.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === _typeof(object) ? types[typeOfObject] || "object" : _typeof(object)
        };
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        var isDate = function(object) {
            return "date" === type(object)
        };
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        var isFunction = function(object) {
            return "function" === typeof object
        };
        var isString = function(object) {
            return "string" === typeof object
        };
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        var isObject = function(object) {
            return "object" === type(object)
        };
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object);
            var ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isBoolean = isBoolean;
        exports.isExponential = isExponential;
        exports.isDate = isDate;
        exports.isDefined = isDefined;
        exports.isFunction = isFunction;
        exports.isString = isString;
        exports.isNumeric = isNumeric;
        exports.isObject = isObject;
        exports.isEmptyObject = isEmptyObject;
        exports.isPlainObject = isPlainObject;
        exports.isPrimitive = isPrimitive;
        exports.isWindow = isWindow;
        exports.isRenderer = isRenderer;
        exports.isPromise = isPromise;
        exports.isDeferred = isDeferred;
        exports.type = type
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/core/renderer.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var rendererBase = __webpack_require__( /*! ./renderer_base */ 268);
        module.exports = rendererBase.get()
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/common.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _config = __webpack_require__( /*! ../config */ 32);
        var _config2 = _interopRequireDefault(_config);
        var _guid = __webpack_require__( /*! ../guid */ 37);
        var _guid2 = _interopRequireDefault(_guid);
        var _deferred = __webpack_require__( /*! ../utils/deferred */ 6);
        var _data = __webpack_require__( /*! ./data */ 21);
        var _iterator = __webpack_require__( /*! ./iterator */ 4);
        var _type = __webpack_require__( /*! ./type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var ensureDefined = function(value, defaultValue) {
            return (0, _type.isDefined)(value) ? value : defaultValue
        };
        var executeAsync = function(action, context) {
            var deferred = new _deferred.Deferred;
            var normalizedContext = context || this;
            var task = {
                promise: deferred.promise(),
                abort: function() {
                    clearTimeout(timerId);
                    deferred.rejectWith(normalizedContext)
                }
            };
            var callback = function() {
                var result = action.call(normalizedContext);
                if (result && result.done && (0, _type.isFunction)(result.done)) {
                    result.done(function() {
                        deferred.resolveWith(normalizedContext)
                    })
                } else {
                    deferred.resolveWith(normalizedContext)
                }
            };
            var timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new _deferred.Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName;
                var currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result || (0, _deferred.when)()
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [];
            var maxMatchCount = 0;
            (0, _iterator.each)(items, function(index, itemSrc) {
                var matchCount = 0;
                var item = mapFn ? mapFn(itemSrc) : itemSrc;
                (0, _iterator.each)(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                (0, _iterator.each)(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            switch (_typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [raw.x || raw.h, raw.y || raw.v];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var normalizeKey = function(id) {
            var key = (0, _type.isString)(id) ? id : id.toString();
            var arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && (0, _iterator.each)(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        var pairToObject = function(raw, preventRound) {
            var pair = splitPair(raw);
            var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
            var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getKeyHash = function(key) {
            if (key instanceof _guid2.default) {
                return key.toString()
            } else {
                if ((0, _type.isObject)(key) || Array.isArray(key)) {
                    try {
                        var keyHash = JSON.stringify(key);
                        return "{}" === keyHash ? key : keyHash
                    } catch (e) {
                        return key
                    }
                }
            }
            return key
        };
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        var applyServerDecimalSeparator = function(value) {
            var separator = (0, _config2.default)().serverDecimalSeparator;
            if ((0, _type.isDefined)(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        var noop = function() {};
        var asyncNoop = function() {
            return (new _deferred.Deferred).resolve().promise()
        };
        var grep = function(elements, checkFunction, invert) {
            var result = [];
            var check;
            var expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        var arraysEqualByValue = function(array1, array2, depth) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], depth + 1)) {
                    return false
                }
            }
            return true
        };
        var objectsEqualByValue = function(object1, object2, depth, strict) {
            for (var propertyName in object1) {
                if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], depth + 1, strict)) {
                    return false
                }
            }
            for (var _propertyName in object2) {
                if (!(_propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var maxEqualityDepth = 3;
        var equalByValue = function(object1, object2) {
            var depth = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0;
            var strict = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : true;
            object1 = (0, _data.toComparable)(object1, true);
            object2 = (0, _data.toComparable)(object2, true);
            var comparisonResult = strict ? object1 === object2 : object1 == object2;
            if (comparisonResult || depth >= maxEqualityDepth) {
                return true
            }
            if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                return objectsEqualByValue(object1, object2, depth, strict)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return arraysEqualByValue(object1, object2, depth)
                }
            }
            return false
        };
        exports.ensureDefined = ensureDefined;
        exports.executeAsync = executeAsync;
        exports.deferRender = deferRender;
        exports.deferRenderer = deferRenderer;
        exports.deferUpdate = deferUpdate;
        exports.deferUpdater = deferUpdater;
        exports.pairToObject = pairToObject;
        exports.splitPair = splitPair;
        exports.findBestMatches = findBestMatches;
        exports.normalizeKey = normalizeKey;
        exports.denormalizeKey = denormalizeKey;
        exports.getKeyHash = getKeyHash;
        exports.escapeRegExp = escapeRegExp;
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        exports.noop = noop;
        exports.asyncNoop = asyncNoop;
        exports.grep = grep;
        exports.equalByValue = equalByValue
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/iterator.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = function(values, callback) {
            if (Array.isArray(values)) {
                return values.map(callback)
            }
            var result = [];
            for (var key in values) {
                result.push(callback(values[key], key))
            }
            return result
        };
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        var reverseEach = function(array, callback) {
            if (!array || !("length" in array) || 0 === array.length) {
                return
            }
            for (var i = array.length - 1; i >= 0; i--) {
                if (false === callback.call(array[i], i, array[i])) {
                    break
                }
            }
        };
        exports.map = map;
        exports.each = each;
        exports.reverseEach = reverseEach
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/events/core/events_engine.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _event_registrator_callbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 139);
        var _event_registrator_callbacks2 = _interopRequireDefault(_event_registrator_callbacks);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _dependency_injector = __webpack_require__( /*! ../../core/utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _errors = __webpack_require__( /*! ../../core/errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _weak_map = __webpack_require__( /*! ../../core/polyfills/weak_map */ 196);
        var _weak_map2 = _interopRequireDefault(_weak_map);
        var _hook_touch_props = __webpack_require__( /*! ../../events/core/hook_touch_props */ 269);
        var _hook_touch_props2 = _interopRequireDefault(_hook_touch_props);
        var _call_once = __webpack_require__( /*! ../../core/utils/call_once */ 82);
        var _call_once2 = _interopRequireDefault(_call_once);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var window = _window2.default.getWindow();
        var isWindow = _type2.default.isWindow;
        var isFunction = _type2.default.isFunction;
        var isString = _type2.default.isString;
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focus", "load"];
        var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel", "touchstart"];

        function matchesSafe(target, selector) {
            return !isWindow(target) && "#document" !== target.nodeName && _dom_adapter2.default.elementMatches(target, selector)
        }
        var elementDataMap = new _weak_map2.default;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            _event_registrator_callbacks2.default.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var eventsEngine = (0, _dependency_injector2.default)({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers((0, _extend.extend)(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || isWindow(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });

        function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (_dom_adapter2.default.isNode(element) || isWindow(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!isString(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw _errors2.default.Error("E0025")
                }
            }
        }

        function getHandler(method) {
            return function() {
                applyForEach(arguments, method)
            }
        }

        function detectPassiveEventHandlersSupport() {
            var isSupported = false;
            try {
                var options = Object.defineProperty({}, "passive", {
                    get: function() {
                        isSupported = true;
                        return true
                    }
                });
                window.addEventListener("test", null, options)
            } catch (e) {}
            return isSupported
        }
        var passiveEventHandlersSupported = (0, _call_once2.default)(detectPassiveEventHandlersSupport);
        var contains = function contains(container, element) {
            if (isWindow(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };

        function getHandlersController(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var handlerArgs = [e];
                        var target = e.currentTarget;
                        var relatedTarget = e.relatedTarget;
                        var secondaryTargetIsInside;
                        var result;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || contains(target, relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            e.currentTarget = e.delegateTarget || e.target;
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = _dom_adapter2.default.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        }

        function getNativeHandler(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        }

        function isSubset(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        }

        function normalizeOnArguments(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        }

        function normalizeOffArguments(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        }

        function normalizeTriggerArguments(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        }

        function normalizeEventArguments(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        }

        function iterate(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === _typeof(eventName)) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        }

        function callNativeMethod(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if (isFunction(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        }

        function calculateWhich(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        }

        function initEvent(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        }
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            (0, _extend.extend)(that, src);
            if (src instanceof eventsEngine.Event || _window2.default.hasWindow() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                (0, _extend.extend)(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }(0, _extend.extend)(that, config);
            that.guid = ++guid
        }));

        function addProperty(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        }(0, _hook_touch_props2.default)(addProperty);
        var beforeSetStrategy = (0, _callbacks2.default)();
        var afterSetStrategy = (0, _callbacks2.default)();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
        eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
        eventsEngine.elementDataMap = elementDataMap;
        eventsEngine.detectPassiveEventHandlersSupport = detectPassiveEventHandlersSupport;
        module.exports = eventsEngine
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/deferred.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../utils/type */ 1);
        var isPromise = typeUtils.isPromise;
        var isDeferred = typeUtils.isDeferred;
        var extend = __webpack_require__( /*! ../utils/extend */ 0).extend;
        var Callbacks = __webpack_require__( /*! ../utils/callbacks */ 27);
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _Deferred = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new Callbacks;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _Deferred;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if (isDeferred(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if (isPromise(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, typeUtils.isDefined(callbackResult) ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? extend(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _Deferred.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });
        exports.fromPromise = function(promise, context) {
            if (isDeferred(promise)) {
                return promise
            } else {
                if (isPromise(promise)) {
                    var d = new _Deferred;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _Deferred).resolveWith(context, [promise])
        };
        var when = function() {
            if (1 === arguments.length) {
                return exports.fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments);
            var contexts = [];
            var resolvedCount = 0;
            var deferred = new _Deferred;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if (isDeferred(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };
        exports.setStrategy = function(value) {
            _Deferred = value.Deferred;
            when = value.when
        };
        exports.Deferred = function() {
            return new _Deferred
        };
        exports.when = function() {
            return when.apply(this, arguments)
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/window.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var hasWindow = function() {
            return "undefined" !== typeof window
        };
        var windowObject = hasWindow() && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        var getWindow = function() {
            return windowObject
        };
        var hasProperty = function(prop) {
            return hasWindow() && prop in windowObject
        };
        var defaultScreenFactorFunc = function(width) {
            if (width < 768) {
                return "xs"
            } else {
                if (width < 992) {
                    return "sm"
                } else {
                    if (width < 1200) {
                        return "md"
                    } else {
                        return "lg"
                    }
                }
            }
        };
        var getCurrentScreenFactor = function(screenFactorCallback) {
            var screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
            var windowWidth = domAdapter.getDocumentElement().clientWidth;
            return screenFactorFunc(windowWidth)
        };
        var getNavigator = function() {
            return hasWindow() ? windowObject.navigator : {
                userAgent: ""
            }
        };
        module.exports = {
            hasWindow: hasWindow,
            getWindow: getWindow,
            hasProperty: hasProperty,
            defaultScreenFactorFunc: defaultScreenFactorFunc,
            getCurrentScreenFactor: getCurrentScreenFactor,
            getNavigator: getNavigator
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/events/utils/index.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.addNamespace = exports.getChar = exports.normalizeKeyName = exports.fireEvent = exports.createEvent = exports.setEventFixMethod = exports.needSkipEvent = exports.stopEventsSkipping = exports.forceSkipEvents = exports.hasTouches = exports.eventDelta = exports.eventData = exports.isFakeClickEvent = exports.isKeyboardEvent = exports.isTouchEvent = exports.isDxMouseWheelEvent = exports.isMouseEvent = exports.isPointerEvent = exports.eventSource = void 0;
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _add_namespace = __webpack_require__( /*! ./add_namespace */ 482);
        var _add_namespace2 = _interopRequireDefault(_add_namespace);
        var _events_engine = __webpack_require__( /*! ../core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ../../ui/widget/selectors */ 65);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var KEY_MAP = {
            backspace: "backspace",
            tab: "tab",
            enter: "enter",
            escape: "escape",
            pageup: "pageUp",
            pagedown: "pageDown",
            end: "end",
            home: "home",
            arrowleft: "leftArrow",
            arrowup: "upArrow",
            arrowright: "rightArrow",
            arrowdown: "downArrow",
            "delete": "del",
            " ": "space",
            f: "F",
            a: "A",
            "*": "asterisk",
            "-": "minus",
            alt: "alt",
            control: "control",
            shift: "shift",
            left: "leftArrow",
            up: "upArrow",
            right: "rightArrow",
            down: "downArrow",
            multiply: "asterisk",
            spacebar: "space",
            del: "del",
            subtract: "minus",
            esc: "escape"
        };
        var LEGACY_KEY_CODES = {
            8: "backspace",
            9: "tab",
            13: "enter",
            27: "escape",
            33: "pageUp",
            34: "pageDown",
            35: "end",
            36: "home",
            37: "leftArrow",
            38: "upArrow",
            39: "rightArrow",
            40: "downArrow",
            46: "del",
            32: "space",
            70: "F",
            65: "A",
            106: "asterisk",
            109: "minus",
            189: "minus",
            173: "minus",
            16: "shift",
            17: "control",
            18: "alt"
        };
        var EVENT_SOURCES_REGEX = {
            dx: /^dx/i,
            mouse: /(mouse|wheel)/i,
            touch: /^touch/i,
            keyboard: /^key/i,
            pointer: /^(ms)?pointer/i
        };
        var fixMethod = function(e) {
            return e
        };
        var copyEvent = function(originalEvent) {
            return fixMethod((0, _events_engine.Event)(originalEvent, originalEvent), originalEvent)
        };
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var eventSource = exports.eventSource = function(_ref) {
            var type = _ref.type;
            var result = "other";
            (0, _iterator.each)(EVENT_SOURCES_REGEX, function(key) {
                if (this.test(type)) {
                    result = key;
                    return false
                }
            });
            return result
        };
        var isPointerEvent = exports.isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        var isMouseEvent = exports.isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        var isDxMouseWheelEvent = exports.isDxMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        var isTouchEvent = exports.isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        exports.isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        exports.isFakeClickEvent = function(_ref2) {
            var screenX = _ref2.screenX,
                offsetX = _ref2.offsetX,
                pageX = _ref2.pageX;
            return 0 === screenX && !offsetX && 0 === pageX
        };
        exports.eventData = function(_ref3) {
            var pageX = _ref3.pageX,
                pageY = _ref3.pageY,
                timeStamp = _ref3.timeStamp;
            return {
                x: pageX,
                y: pageY,
                time: timeStamp
            }
        };
        exports.eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        exports.hasTouches = function(e) {
            var originalEvent = e.originalEvent,
                pointers = e.pointers;
            if (isNativeTouchEvent(e)) {
                return (originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (pointers || []).length
            }
            return 0
        };
        var skipEvents = false;
        exports.forceSkipEvents = function() {
            return skipEvents = true
        };
        exports.stopEventsSkipping = function() {
            return skipEvents = false
        };
        exports.needSkipEvent = function(e) {
            if (skipEvents) {
                return true
            }
            var target = e.target;
            var $target = (0, _renderer2.default)(target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if (isDxMouseWheelEvent(e)) {
                var isTextArea = $target.is("textarea") && $target.hasClass("dx-texteditor-input");
                if (isTextArea) {
                    return false
                }
                var isContentEditable = target.isContentEditable || target.hasAttribute("contenteditable");
                if (isContentEditable) {
                    return false
                }
                var isInputFocused = $target.is("input[type='number'], textarea, select") && $target.is(":focus");
                return isInputFocused
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && (0, _selectors.focused)($target)
            }
        };
        exports.setEventFixMethod = function(func) {
            return fixMethod = func
        };
        var createEvent = exports.createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            args && (0, _extend.extend)(event, args);
            return event
        };
        exports.fireEvent = function(props) {
            var originalEvent = props.originalEvent,
                delegateTarget = props.delegateTarget;
            var event = createEvent(originalEvent, props);
            _events_engine2.default.trigger(delegateTarget || event.target, event);
            return event
        };
        exports.normalizeKeyName = function(_ref4) {
            var key = _ref4.key,
                which = _ref4.which;
            var isKeySupported = !!key;
            key = isKeySupported ? key : which;
            if (key) {
                if (isKeySupported) {
                    key = KEY_MAP[key.toLowerCase()] || key
                } else {
                    key = LEGACY_KEY_CODES[key] || String.fromCharCode(key)
                }
                return key
            }
        };
        exports.getChar = function(_ref5) {
            var key = _ref5.key,
                which = _ref5.which;
            return key || String.fromCharCode(which)
        };
        exports.addNamespace = _add_namespace2.default
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ./renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _component_registrator_callbacks = __webpack_require__( /*! ./component_registrator_callbacks */ 165);
        var _component_registrator_callbacks2 = _interopRequireDefault(_component_registrator_callbacks);
        var _errors = __webpack_require__( /*! ./errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 140);
        var _public_component2 = _interopRequireDefault(_public_component);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }
            _public_component2.default.name(componentClass, name);
            _component_registrator_callbacks2.default.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            _renderer2.default.fn[name] = function(options) {
                var isMemberInvoke = "string" === typeof options;
                var result;
                if (isMemberInvoke) {
                    var memberName = options;
                    var memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw _errors2.default.Error("E0009", name)
                        }
                        var member = instance[memberName];
                        var memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        _component_registrator_callbacks2.default.add(registerRendererComponent);
        module.exports = registerComponent
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/localization/message.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _string = __webpack_require__( /*! ../core/utils/string */ 41);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 38);
        var _core = __webpack_require__( /*! ./core */ 91);
        var _core2 = _interopRequireDefault(_core);
        var _default_messages = __webpack_require__( /*! ./default_messages */ 471);
        var _default_messages2 = _interopRequireDefault(_default_messages);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var baseDictionary = (0, _extend.extend)(true, {}, _default_messages2.default);
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var newMessages = {};
        var messageLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            _dictionary: baseDictionary,
            load: function(messages) {
                (0, _extend.extend)(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this;
                var regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g");
                var escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var defaultResult = that._localizablePrefix + localizationKey;
                    var result;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = (0, _inflector.humanize)(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            localizeNode: function(node) {
                var that = this;
                (0, _renderer2.default)(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!(0, _renderer2.default)(nodeItem).is("iframe")) {
                            (0, _iterator.each)(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            (0, _renderer2.default)(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return (0, _extend.extend)({}, newMessages, this.getMessagesByLocales()[_core2.default.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var _this = this;
                var message = _core2.default.getValueByClosestLocale(function(locale) {
                    return getDataByLocale(_this._dictionary, locale)[key]
                });
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return _string.format.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        module.exports = messageLocalization
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dom.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var config = __webpack_require__( /*! ../../core/config */ 32);
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var windowUtils = __webpack_require__( /*! ./window */ 7);
        var window = windowUtils.getWindow();
        var eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var inArray = __webpack_require__( /*! ./array */ 13).inArray;
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var isDefined = typeUtils.isDefined;
        var isRenderer = typeUtils.isRenderer;
        var isWindow = typeUtils.isWindow;
        var htmlParser = __webpack_require__( /*! ../../core/utils/html_parser */ 270);
        var elementStrategy;
        var resetActiveElement = function() {
            var activeElement = domAdapter.getActiveElement();
            var body = domAdapter.getBody();
            if (activeElement && activeElement !== body && activeElement.blur) {
                try {
                    activeElement.blur()
                } catch (e) {
                    body.blur()
                }
            }
        };
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = $(startTarget);
            var $endTarget = $(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents();
            var $endParents = $endTarget.parents();
            var startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = $(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    eventsEngine.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var uniqueId = function() {
            var counter = 0;
            return function(prefix) {
                return (prefix || "") + counter++
            }
        }();
        var dataOptionsAttributeName = "data-options";
        var getElementOptions = function(element) {
            var optionsString = $(element).attr(dataOptionsAttributeName) || "";
            return config().optionsParser(optionsString)
        };
        var createComponents = function(elements, componentTypes) {
            var result = [];
            var selector = "[" + dataOptionsAttributeName + "]";
            var $items = elements.find(selector).add(elements.filter(selector));
            $items.each(function(index, element) {
                var $element = $(element);
                var options = getElementOptions(element);
                for (var componentName in options) {
                    if (!componentTypes || inArray(componentName, componentTypes) > -1) {
                        if ($element[componentName]) {
                            $element[componentName](options[componentName]);
                            result.push($element[componentName]("instance"))
                        }
                    }
                }
            });
            return result
        };
        var createMarkupFromString = function(str) {
            if (!window.WinJS) {
                return $(htmlParser.parseHTML(str))
            }
            var tempElement = $("<div>");
            window.WinJS.Utilities.setInnerHTMLUnsafe(tempElement.get(0), str);
            return tempElement.contents()
        };
        var extractTemplateMarkup = function(element) {
            element = $(element);
            var templateTag = element.length && element.filter(function() {
                var $node = $(this);
                return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
            });
            if (templateTag.length) {
                return templateTag.eq(0).html()
            } else {
                element = $("<div>").append(element);
                return element.html()
            }
        };
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = isDefined(element) && (element.nodeType || isRenderer(element)) ? $(element) : $("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        var contains = function contains(container, element) {
            if (!element) {
                return false
            }
            if (domAdapter.isTextNode(element)) {
                element = element.parentNode
            }
            if (domAdapter.isDocument(container)) {
                return container.documentElement.contains(element)
            }
            if (isWindow(container)) {
                return contains(container.document, element)
            }
            return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
        };
        var getPublicElement = function($element) {
            return elementStrategy($element)
        };
        var setPublicElementWrapper = function(value) {
            elementStrategy = value
        };
        setPublicElementWrapper(function(element) {
            return element && element.get(0)
        });
        var createTextElementHiddenCopy = function(element, text, options) {
            var elementStyles = window.getComputedStyle($(element).get(0));
            var includePaddings = options && options.includePaddings;
            return $("<div>").text(text).css({
                fontStyle: elementStyles.fontStyle,
                fontVariant: elementStyles.fontVariant,
                fontWeight: elementStyles.fontWeight,
                fontSize: elementStyles.fontSize,
                fontFamily: elementStyles.fontFamily,
                letterSpacing: elementStyles.letterSpacing,
                border: elementStyles.border,
                paddingTop: includePaddings ? elementStyles.paddingTop : "",
                paddingRight: includePaddings ? elementStyles.paddingRight : "",
                paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                visibility: "hidden",
                whiteSpace: "nowrap",
                position: "absolute",
                "float": "left"
            })
        };
        exports.setPublicElementWrapper = setPublicElementWrapper;
        exports.resetActiveElement = resetActiveElement;
        exports.createMarkupFromString = createMarkupFromString;
        exports.triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.getElementOptions = getElementOptions;
        exports.createComponents = createComponents;
        exports.extractTemplateMarkup = extractTemplateMarkup;
        exports.normalizeTemplateElement = normalizeTemplateElement;
        exports.clearSelection = clearSelection;
        exports.uniqueId = uniqueId;
        exports.closestCommonParent = closestCommonParent;
        exports.clipboardText = clipboardText;
        exports.contains = contains;
        exports.getPublicElement = getPublicElement;
        exports.createTextElementHiddenCopy = createTextElementHiddenCopy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/dom_adapter.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ./utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _common = __webpack_require__( /*! ./utils/common */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var ELEMENT_NODE = 1;
        var TEXT_NODE = 3;
        var DOCUMENT_NODE = 9;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var _this = this;
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = _this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                };
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === _typeof(element) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            getAttribute: function(element, name) {
                return element.getAttribute(name)
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNameSupported = "string" === typeof element.className;
                        var elementClass = classNameSupported ? element.className : this.getAttribute(element, "class") || "";
                        var classNames = elementClass.split(" ");
                        var classIndex = classNames.indexOf(className);
                        var resultClassName;
                        if (isAdd && classIndex < 0) {
                            resultClassName = elementClass ? elementClass + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            resultClassName = classNames.join(" ")
                        }
                        if (void 0 !== resultClassName) {
                            if (classNameSupported) {
                                element.className = resultClassName
                            } else {
                                this.setAttribute(element, "class", resultClassName)
                            }
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return _common.noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        module.exports = (0, _dependency_injector2.default)(nativeDOMAdapterStrategy)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/array.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined;
        var each = __webpack_require__( /*! ./iterator */ 4).each;
        var objectUtils = __webpack_require__( /*! ./object */ 49);
        var config = __webpack_require__( /*! ../config */ 32);
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            each(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            each(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {};
            var parameterIndex = 0;
            var useLegacyVisibleIndex = config().useLegacyVisibleIndex;
            each(items, function(index, item) {
                index = item[indexParameterName];
                if (index >= 0) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                } else {
                    item[indexParameterName] = void 0
                }
            });
            if (!useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        while (indexedItems[parameterIndex]) {
                            parameterIndex++
                        }
                        indexedItems[parameterIndex] = [this];
                        parameterIndex++
                    }
                })
            }
            parameterIndex = 0;
            objectUtils.orderEach(indexedItems, function(index, items) {
                each(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            if (useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            }
            return parameterIndex
        };
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        var find = function(array, condition) {
            for (var i = 0; i < array.length; i++) {
                if (condition(array[i])) {
                    return array[i]
                }
            }
        };
        exports.isEmpty = isEmpty;
        exports.wrapToArray = wrapToArray;
        exports.intersection = intersection;
        exports.removeDuplicates = removeDuplicates;
        exports.normalizeIndexes = normalizeIndexes;
        exports.inArray = inArray;
        exports.merge = merge;
        exports.find = find
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/devices.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 4);
        var _errors = __webpack_require__( /*! ./errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _callbacks = __webpack_require__( /*! ./utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _resize_callbacks = __webpack_require__( /*! ./utils/resize_callbacks */ 125);
        var _resize_callbacks2 = _interopRequireDefault(_resize_callbacks);
        var _events_strategy = __webpack_require__( /*! ./events_strategy */ 101);
        var _storage = __webpack_require__( /*! ./utils/storage */ 283);
        var _view_port = __webpack_require__( /*! ./utils/view_port */ 75);
        var _view_port2 = _interopRequireDefault(_view_port);
        var _config = __webpack_require__( /*! ./config */ 32);
        var _config2 = _interopRequireDefault(_config);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var navigator = _window2.default.getNavigator();
        var window = _window2.default.getWindow();
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            generic: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/);
                var isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent);
                var isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                var isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                if (!(isPhone || isTablet || isDesktop || isMac)) {
                    return
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "generic",
                    version: [],
                    grade: "A",
                    mac: isMac
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent);
                var matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [];
                var isIPhone4 = 480 === window.screen.height;
                var grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent);
                var matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i);
                var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [];
                var worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4);
                var grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = function() {
            function Devices(options) {
                _classCallCheck(this, Devices);
                this._window = (null === options || void 0 === options ? void 0 : options.window) || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                this.changed = (0, _callbacks2.default)();
                if (_window2.default.hasWindow()) {
                    this._recalculateOrientation();
                    _resize_callbacks2.default.add(this._recalculateOrientation.bind(this))
                }
            }
            _createClass(Devices, [{
                key: "current",
                value: function(deviceOrName) {
                    if (deviceOrName) {
                        this._currentDevice = this._getDevice(deviceOrName);
                        this._forced = true;
                        this.changed.fire();
                        return
                    }
                    if (!this._currentDevice) {
                        deviceOrName = void 0;
                        try {
                            deviceOrName = this._getDeviceOrNameFromWindowScope()
                        } catch (e) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        } finally {
                            if (!deviceOrName) {
                                deviceOrName = this._getDeviceNameFromSessionStorage()
                            }
                            if (deviceOrName) {
                                this._forced = true
                            }
                        }
                        this._currentDevice = this._getDevice(deviceOrName)
                    }
                    return this._currentDevice
                }
            }, {
                key: "real",
                value: function(forceDevice) {
                    if ((0, _type.isPlainObject)(forceDevice)) {
                        (0, _extend.extend)(this._realDevice, forceDevice);
                        return
                    }
                    return (0, _extend.extend)({}, this._realDevice)
                }
            }, {
                key: "orientation",
                value: function() {
                    return this._currentOrientation
                }
            }, {
                key: "isForced",
                value: function() {
                    return this._forced
                }
            }, {
                key: "isRippleEmulator",
                value: function() {
                    return !!this._window.tinyHippos
                }
            }, {
                key: "_getCssClasses",
                value: function(device) {
                    var result = [];
                    var realDevice = this._realDevice;
                    device = device || this.current();
                    if (device.deviceType) {
                        result.push("dx-device-".concat(device.deviceType));
                        if ("desktop" !== device.deviceType) {
                            result.push("dx-device-mobile")
                        }
                    }
                    result.push("dx-device-".concat(realDevice.platform));
                    if (realDevice.version && realDevice.version.length) {
                        result.push("dx-device-".concat(realDevice.platform, "-").concat(realDevice.version[0]))
                    }
                    if (this.isSimulator()) {
                        result.push("dx-simulator")
                    }
                    if ((0, _config2.default)().rtlEnabled) {
                        result.push("dx-rtl")
                    }
                    return result
                }
            }, {
                key: "attachCssClasses",
                value: function(element, device) {
                    this._deviceClasses = this._getCssClasses(device).join(" ");
                    (0, _renderer2.default)(element).addClass(this._deviceClasses)
                }
            }, {
                key: "detachCssClasses",
                value: function(element) {
                    (0, _renderer2.default)(element).removeClass(this._deviceClasses)
                }
            }, {
                key: "isSimulator",
                value: function() {
                    try {
                        return this._isSimulator || _window2.default.hasWindow() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                    } catch (e) {
                        return false
                    }
                }
            }, {
                key: "forceSimulator",
                value: function() {
                    this._isSimulator = true
                }
            }, {
                key: "_getDevice",
                value: function(deviceName) {
                    if ("genericPhone" === deviceName) {
                        deviceName = {
                            deviceType: "phone",
                            platform: "generic",
                            generic: true
                        }
                    }
                    if ((0, _type.isPlainObject)(deviceName)) {
                        return this._fromConfig(deviceName)
                    } else {
                        var ua;
                        if (deviceName) {
                            ua = KNOWN_UA_TABLE[deviceName];
                            if (!ua) {
                                throw _errors2.default.Error("E0005")
                            }
                        } else {
                            ua = navigator.userAgent
                        }
                        return this._fromUA(ua)
                    }
                }
            }, {
                key: "_getDeviceOrNameFromWindowScope",
                value: function() {
                    var result;
                    if (_window2.default.hasWindow() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                        result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                    }
                    return result
                }
            }, {
                key: "_getDeviceNameFromSessionStorage",
                value: function() {
                    var sessionStorage = (0, _storage.sessionStorage)();
                    if (!sessionStorage) {
                        return
                    }
                    var deviceOrName = sessionStorage.getItem("dx-force-device");
                    try {
                        return JSON.parse(deviceOrName)
                    } catch (ex) {
                        return deviceOrName
                    }
                }
            }, {
                key: "_fromConfig",
                value: function(config) {
                    var result = (0, _extend.extend)({}, DEFAULT_DEVICE, this._currentDevice, config);
                    var shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        generic: "generic" === result.platform
                    };
                    return (0, _extend.extend)(result, shortcuts)
                }
            }, {
                key: "_fromUA",
                value: function(ua) {
                    var config;
                    (0, _iterator.each)(uaParsers, function(platform, parser) {
                        config = parser(ua);
                        return !config
                    });
                    if (config) {
                        return this._fromConfig(config)
                    }
                    return DEFAULT_DEVICE
                }
            }, {
                key: "_changeOrientation",
                value: function() {
                    var $window = (0, _renderer2.default)(this._window);
                    var orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                    if (this._currentOrientation === orientation) {
                        return
                    }
                    this._currentOrientation = orientation;
                    this._eventsStrategy.fireEvent("orientationChanged", [{
                        orientation: orientation
                    }])
                }
            }, {
                key: "_recalculateOrientation",
                value: function() {
                    var windowWidth = (0, _renderer2.default)(this._window).width();
                    if (this._currentWidth === windowWidth) {
                        return
                    }
                    this._currentWidth = windowWidth;
                    this._changeOrientation()
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.on(eventName, eventHandler);
                    return this
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    this._eventsStrategy.off(eventName, eventHandler);
                    return this
                }
            }]);
            return Devices
        }();
        var devices = new Devices;
        _view_port2.default.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        module.exports = devices
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/viz/core/utils.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _math = __webpack_require__( /*! ../../core/utils/math */ 31);
        var _date = __webpack_require__( /*! ../../core/utils/date */ 26);
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _color = __webpack_require__( /*! ../../color */ 100);
        var _color2 = _interopRequireDefault(_color);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var PI = Math.PI,
            LN10 = Math.LN10,
            abs = Math.abs,
            log = Math.log,
            floor = Math.floor,
            ceil = Math.ceil,
            pow = Math.pow,
            sqrt = Math.sqrt,
            atan2 = Math.atan2;
        var _min = Math.min;
        var _max = Math.max;
        var _cos = Math.cos;
        var _sin = Math.sin;
        var _round = Math.round;
        var MAX_PIXEL_COUNT = 1e10;
        var PI_DIV_180 = PI / 180;
        var _isNaN = isNaN;
        var _Number = Number;
        var _NaN = NaN;
        var PANE_PADDING = 10;
        var getLog = function(value, base) {
            if (!value) {
                return _NaN
            }
            return log(value) / log(base)
        };
        var getAdjustedLog10 = function(value) {
            return (0, _math.adjust)(getLog(value, 10))
        };
        var raiseTo = function(power, base) {
            return pow(base, power)
        };
        var normalizeAngle = function(angle) {
            return (angle % 360 + 360) % 360
        };
        var convertAngleToRendererSpace = function(angle) {
            return 90 - angle
        };
        var degreesToRadians = function(value) {
            return PI * value / 180
        };
        var getCosAndSin = function(angle) {
            var angleInRadians = degreesToRadians(angle);
            return {
                cos: _cos(angleInRadians),
                sin: _sin(angleInRadians)
            }
        };
        var DECIMAL_ORDER_THRESHOLD = 1e-14;
        var getDistance = function(x1, y1, x2, y2) {
            var diffX = x2 - x1;
            var diffY = y2 - y1;
            return sqrt(diffY * diffY + diffX * diffX)
        };
        var getDecimalOrder = function(number) {
            var n = abs(number);
            var cn;
            if (!_isNaN(n)) {
                if (n > 0) {
                    n = log(n) / LN10;
                    cn = ceil(n);
                    return cn - n < DECIMAL_ORDER_THRESHOLD ? cn : floor(n)
                }
                return 0
            }
            return _NaN
        };
        var getAppropriateFormat = function(start, end, count) {
            var order = _max(getDecimalOrder(start), getDecimalOrder(end));
            var precision = -getDecimalOrder(abs(end - start) / count);
            var format;
            if (!_isNaN(order) && !_isNaN(precision)) {
                if (abs(order) <= 4) {
                    format = "fixedPoint";
                    precision < 0 && (precision = 0);
                    precision > 4 && (precision = 4)
                } else {
                    format = "exponential";
                    precision += order - 1;
                    precision > 3 && (precision = 3)
                }
                return {
                    type: format,
                    precision: precision
                }
            }
            return null
        };
        var roundValue = function(value, precision) {
            if (precision > 20) {
                precision = 20
            }
            if ((0, _type.isNumeric)(value)) {
                if ((0, _type.isExponential)(value)) {
                    return _Number(value.toExponential(precision))
                } else {
                    return _Number(value.toFixed(precision))
                }
            }
        };
        var getPower = function(value) {
            return value.toExponential().split("e")[1]
        };

        function map(array, callback) {
            var i = 0;
            var len = array.length;
            var result = [];
            var value;
            while (i < len) {
                value = callback(array[i], i);
                if (null !== value) {
                    result.push(value)
                }
                i++
            }
            return result
        }

        function selectByKeys(object, keys) {
            return map(keys, function(key) {
                return object[key] ? object[key] : null
            })
        }

        function decreaseFields(object, keys, eachDecrease, decrease) {
            var dec = decrease;
            (0, _iterator.each)(keys, function(_, key) {
                if (object[key]) {
                    object[key] -= eachDecrease;
                    dec -= eachDecrease
                }
            });
            return dec
        }

        function normalizeEnum(value) {
            return String(value).toLowerCase()
        }

        function setCanvasValues(canvas) {
            if (canvas) {
                canvas.originalTop = canvas.top;
                canvas.originalBottom = canvas.bottom;
                canvas.originalLeft = canvas.left;
                canvas.originalRight = canvas.right
            }
            return canvas
        }

        function normalizeBBoxField(value) {
            return -MAX_PIXEL_COUNT < value && value < +MAX_PIXEL_COUNT ? value : 0
        }

        function normalizeBBox(bBox) {
            var xl = normalizeBBoxField(floor(bBox.x));
            var yt = normalizeBBoxField(floor(bBox.y));
            var xr = normalizeBBoxField(ceil(bBox.width + bBox.x));
            var yb = normalizeBBoxField(ceil(bBox.height + bBox.y));
            var result = {
                x: xl,
                y: yt,
                width: xr - xl,
                height: yb - yt
            };
            result.isEmpty = !result.x && !result.y && !result.width && !result.height;
            return result
        }

        function rotateBBox(bBox, center, angle) {
            var cos = _Number(_cos(angle * PI_DIV_180).toFixed(3));
            var sin = _Number(_sin(angle * PI_DIV_180).toFixed(3));
            var w2 = bBox.width / 2;
            var h2 = bBox.height / 2;
            var centerX = bBox.x + w2;
            var centerY = bBox.y + h2;
            var w2_ = abs(w2 * cos) + abs(h2 * sin);
            var h2_ = abs(w2 * sin) + abs(h2 * cos);
            var centerX_ = center[0] + (centerX - center[0]) * cos + (centerY - center[1]) * sin;
            var centerY_ = center[1] - (centerX - center[0]) * sin + (centerY - center[1]) * cos;
            return normalizeBBox({
                x: centerX_ - w2_,
                y: centerY_ - h2_,
                width: 2 * w2_,
                height: 2 * h2_
            })
        }(0, _extend.extend)(exports, {
            decreaseGaps: function(object, keys, decrease) {
                var arrayGaps;
                do {
                    arrayGaps = selectByKeys(object, keys);
                    arrayGaps.push(ceil(decrease / arrayGaps.length));
                    decrease = decreaseFields(object, keys, _min.apply(null, arrayGaps), decrease)
                } while (decrease > 0 && arrayGaps.length > 1);
                return decrease
            },
            normalizeEnum: normalizeEnum,
            parseScalar: function(value, defaultValue) {
                return void 0 !== value ? value : defaultValue
            },
            enumParser: function(values) {
                var stored = {};
                var i;
                var ii;
                for (i = 0, ii = values.length; i < ii; ++i) {
                    stored[normalizeEnum(values[i])] = 1
                }
                return function(value, defaultValue) {
                    var _value = normalizeEnum(value);
                    return stored[_value] ? _value : defaultValue
                }
            },
            patchFontOptions: function(options) {
                var fontOptions = {};
                (0, _iterator.each)(options || {}, function(key, value) {
                    if (/^(cursor)$/i.test(key)) {} else {
                        if ("opacity" === key) {
                            value = null
                        } else {
                            if ("color" === key) {
                                key = "fill";
                                if ("opacity" in options) {
                                    var color = new _color2.default(value);
                                    value = "rgba(".concat(color.r, ",").concat(color.g, ",").concat(color.b, ",").concat(options.opacity, ")")
                                }
                            } else {
                                key = "font-" + key
                            }
                        }
                    }
                    fontOptions[key] = value
                });
                return fontOptions
            },
            checkElementHasPropertyFromStyleSheet: function(element, property) {
                var slice = Array.prototype.slice;
                var cssRules = slice.call(_dom_adapter2.default.getDocument().styleSheets).reduce(function(rules, styleSheet) {
                    return rules.concat(slice.call(styleSheet.cssRules || styleSheet.rules))
                }, []);
                var elementRules = cssRules.filter(function(rule) {
                    try {
                        return _dom_adapter2.default.elementMatches(element, rule.selectorText)
                    } catch (e) {
                        return false
                    }
                });
                return elementRules.some(function(rule) {
                    return !!rule.style[property]
                })
            },
            convertPolarToXY: function(centerCoords, startAngle, angle, radius) {
                var shiftAngle = 90;
                var normalizedRadius = radius > 0 ? radius : 0;
                angle = (0, _type.isDefined)(angle) ? angle + startAngle - shiftAngle : 0;
                var cosSin = getCosAndSin(angle);
                return {
                    x: _round(centerCoords.x + normalizedRadius * cosSin.cos),
                    y: _round(centerCoords.y + normalizedRadius * cosSin.sin)
                }
            },
            convertXYToPolar: function(centerCoords, x, y) {
                var radius = getDistance(centerCoords.x, centerCoords.y, x, y);
                var angle = atan2(y - centerCoords.y, x - centerCoords.x);
                return {
                    phi: _round(normalizeAngle(180 * angle / PI)),
                    r: _round(radius)
                }
            },
            processSeriesTemplate: function(seriesTemplate, items) {
                var customizeSeries = (0, _type.isFunction)(seriesTemplate.customizeSeries) ? seriesTemplate.customizeSeries : _common.noop;
                var nameField = seriesTemplate.nameField;
                var generatedSeries = {};
                var seriesOrder = [];
                var series;
                var i = 0;
                var length;
                var data;
                items = items || [];
                for (length = items.length; i < length; i++) {
                    data = items[i];
                    if (nameField in data) {
                        series = generatedSeries[data[nameField]];
                        if (!series) {
                            series = generatedSeries[data[nameField]] = {
                                name: data[nameField],
                                nameFieldValue: data[nameField]
                            };
                            seriesOrder.push(series.name)
                        }
                    }
                }
                return map(seriesOrder, function(orderedName) {
                    var group = generatedSeries[orderedName];
                    return (0, _extend.extend)(group, customizeSeries.call(null, group.name))
                })
            },
            getCategoriesInfo: function(categories, startValue, endValue) {
                if (0 === categories.length) {
                    return {
                        categories: []
                    }
                }
                startValue = (0, _type.isDefined)(startValue) ? startValue : categories[0];
                endValue = (0, _type.isDefined)(endValue) ? endValue : categories[categories.length - 1];
                var categoriesValue = map(categories, function(category) {
                    return null === category || void 0 === category ? void 0 : category.valueOf()
                });
                var indexStartValue = categoriesValue.indexOf(startValue.valueOf());
                var indexEndValue = categoriesValue.indexOf(endValue.valueOf());
                var swapBuf;
                var inverted = false;
                indexStartValue < 0 && (indexStartValue = 0);
                indexEndValue < 0 && (indexEndValue = categories.length - 1);
                if (indexEndValue < indexStartValue) {
                    swapBuf = indexEndValue;
                    indexEndValue = indexStartValue;
                    indexStartValue = swapBuf;
                    inverted = true
                }
                var visibleCategories = categories.slice(indexStartValue, indexEndValue + 1);
                var lastIdx = visibleCategories.length - 1;
                return {
                    categories: visibleCategories,
                    start: visibleCategories[inverted ? lastIdx : 0],
                    end: visibleCategories[inverted ? 0 : lastIdx],
                    inverted: inverted
                }
            },
            setCanvasValues: setCanvasValues,
            normalizePanesHeight: function(panes) {
                panes.forEach(function(pane) {
                    var height = pane.height;
                    var unit = 0;
                    var parsedHeight = parseFloat(height) || void 0;
                    if ((0, _type.isString)(height) && height.indexOf("px") > -1 || (0, _type.isNumeric)(height) && height > 1) {
                        parsedHeight = _round(parsedHeight);
                        unit = 1
                    }
                    if (!unit && parsedHeight) {
                        if ((0, _type.isString)(height) && height.indexOf("%") > -1) {
                            parsedHeight /= 100
                        } else {
                            if (parsedHeight < 0) {
                                parsedHeight = parsedHeight < -1 ? 1 : abs(parsedHeight)
                            }
                        }
                    }
                    pane.height = parsedHeight;
                    pane.unit = unit
                });
                var weightSum = panes.filter(function(pane) {
                    return !pane.unit
                }).reduce(function(prev, next) {
                    return prev + (next.height || 0)
                }, 0);
                var weightHeightCount = panes.filter(function(pane) {
                    return !pane.unit
                }).length;
                var emptyHeightCount = panes.filter(function(pane) {
                    return !pane.unit && !pane.height
                }).length;
                if (weightSum < 1 && emptyHeightCount) {
                    panes.filter(function(pane) {
                        return !pane.unit && !pane.height
                    }).forEach(function(pane) {
                        return pane.height = (1 - weightSum) / emptyHeightCount
                    })
                } else {
                    if (weightSum > 1 || weightSum < 1 && !emptyHeightCount || 1 === weightSum && emptyHeightCount) {
                        if (emptyHeightCount) {
                            var weightForEmpty = weightSum / weightHeightCount;
                            var emptyWeightSum = emptyHeightCount * weightForEmpty;
                            panes.filter(function(pane) {
                                return !pane.unit && pane.height
                            }).forEach(function(pane) {
                                return pane.height *= (weightSum - emptyWeightSum) / weightSum
                            });
                            panes.filter(function(pane) {
                                return !pane.unit && !pane.height
                            }).forEach(function(pane) {
                                return pane.height = weightForEmpty
                            })
                        }
                        panes.forEach(function(pane) {
                            return !pane.unit && (pane.height *= 1 / weightSum)
                        })
                    }
                }
            },
            updatePanesCanvases: function(panes, canvas, rotated) {
                var distributedSpace = 0;
                var padding = PANE_PADDING;
                var paneSpace = rotated ? canvas.width - canvas.left - canvas.right : canvas.height - canvas.top - canvas.bottom;
                var usefulSpace = paneSpace - padding * (panes.length - 1);
                var startName = rotated ? "left" : "top";
                var endName = rotated ? "right" : "bottom";
                var totalCustomSpace = panes.reduce(function(prev, cur) {
                    return prev + (cur.unit ? cur.height : 0)
                }, 0);
                usefulSpace -= totalCustomSpace;
                panes.forEach(function(pane) {
                    var calcLength = pane.unit ? pane.height : _round(pane.height * usefulSpace);
                    pane.canvas = pane.canvas || {};
                    (0, _extend.extend)(pane.canvas, canvas);
                    pane.canvas[startName] = canvas[startName] + distributedSpace;
                    pane.canvas[endName] = canvas[endName] + (paneSpace - calcLength - distributedSpace);
                    distributedSpace = distributedSpace + calcLength + padding;
                    setCanvasValues(pane.canvas)
                })
            },
            unique: function(array) {
                var values = {};
                return map(array, function(item) {
                    var result = !values[item] ? item : null;
                    values[item] = true;
                    return result
                })
            },
            map: map,
            getVerticallyShiftedAngularCoords: function(bBox, dy, center) {
                var isPositive = bBox.x + bBox.width / 2 >= center.x;
                var horizontalOffset1 = (isPositive ? bBox.x : bBox.x + bBox.width) - center.x;
                var verticalOffset1 = bBox.y - center.y;
                var verticalOffset2 = verticalOffset1 + dy;
                var horizontalOffset2 = _round(sqrt(horizontalOffset1 * horizontalOffset1 + verticalOffset1 * verticalOffset1 - verticalOffset2 * verticalOffset2));
                var dx = (isPositive ? +horizontalOffset2 : -horizontalOffset2) || horizontalOffset1;
                return {
                    x: center.x + (isPositive ? dx : dx - bBox.width),
                    y: bBox.y + dy
                }
            },
            mergeMarginOptions: function(opt1, opt2) {
                return {
                    checkInterval: opt1.checkInterval || opt2.checkInterval,
                    size: _max(opt1.size || 0, opt2.size || 0),
                    percentStick: opt1.percentStick || opt2.percentStick,
                    sizePointNormalState: _max(opt1.sizePointNormalState || 0, opt2.sizePointNormalState || 0)
                }
            }
        });

        function getVizRangeObject(value) {
            if (Array.isArray(value)) {
                return {
                    startValue: value[0],
                    endValue: value[1]
                }
            } else {
                return value || {}
            }
        }

        function convertVisualRangeObject(visualRange, convertToVisualRange) {
            if (convertToVisualRange) {
                return visualRange
            }
            return [visualRange.startValue, visualRange.endValue]
        }

        function getAddFunction(range, correctZeroLevel) {
            if ("datetime" === range.dataType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    return new Date(rangeValue.getTime() + sign * marginValue)
                }
            }
            if ("logarithmic" === range.axisType) {
                return function(rangeValue, marginValue) {
                    var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                    var log = getLogExt(rangeValue, range.base) + sign * marginValue;
                    return raiseToExt(log, range.base)
                }
            }
            return function(rangeValue, marginValue) {
                var sign = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
                var newValue = rangeValue + sign * marginValue;
                return correctZeroLevel && newValue * rangeValue <= 0 ? 0 : newValue
            }
        }

        function adjustVisualRange(options, visualRange, wholeRange, dataRange) {
            var minDefined = (0, _type.isDefined)(visualRange.startValue);
            var maxDefined = (0, _type.isDefined)(visualRange.endValue);
            var nonDiscrete = "discrete" !== options.axisType;
            dataRange = dataRange || wholeRange;
            var add = getAddFunction(options, false);
            var min = minDefined ? visualRange.startValue : dataRange.min;
            var max = maxDefined ? visualRange.endValue : dataRange.max;
            var rangeLength = visualRange.length;
            var categories = dataRange.categories;
            if (nonDiscrete && !(0, _type.isDefined)(min) && !(0, _type.isDefined)(max)) {
                return {
                    startValue: min,
                    endValue: max
                }
            }
            if ((0, _type.isDefined)(rangeLength)) {
                if (nonDiscrete) {
                    if ("datetime" === options.dataType && !(0, _type.isNumeric)(rangeLength)) {
                        rangeLength = (0, _date.dateToMilliseconds)(rangeLength)
                    }
                    if (maxDefined && !minDefined || !maxDefined && !minDefined) {
                        (0, _type.isDefined)(wholeRange.max) && (max = max > wholeRange.max ? wholeRange.max : max);
                        min = add(max, rangeLength, -1)
                    } else {
                        if (minDefined && !maxDefined) {
                            (0, _type.isDefined)(wholeRange.min) && (min = min < wholeRange.min ? wholeRange.min : min);
                            max = add(min, rangeLength)
                        }
                    }
                } else {
                    rangeLength = parseInt(rangeLength);
                    if (!isNaN(rangeLength) && isFinite(rangeLength)) {
                        rangeLength--;
                        if (!maxDefined && !minDefined) {
                            max = categories[categories.length - 1];
                            min = categories[categories.length - 1 - rangeLength]
                        } else {
                            if (minDefined && !maxDefined) {
                                var categoriesInfo = exports.getCategoriesInfo(categories, min, void 0);
                                max = categoriesInfo.categories[rangeLength]
                            } else {
                                if (!minDefined && maxDefined) {
                                    var _categoriesInfo = exports.getCategoriesInfo(categories, void 0, max);
                                    min = _categoriesInfo.categories[_categoriesInfo.categories.length - 1 - rangeLength]
                                }
                            }
                        }
                    }
                }
            }
            if (nonDiscrete) {
                if ((0, _type.isDefined)(wholeRange.max) && max > wholeRange.max) {
                    max = wholeRange.max
                }
                if ((0, _type.isDefined)(wholeRange.min) && min < wholeRange.min) {
                    min = wholeRange.min
                }
            }
            return {
                startValue: min,
                endValue: max
            }
        }

        function getLogExt(value, base) {
            var allowNegatives = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : false;
            var linearThreshold = arguments.length > 3 ? arguments[3] : void 0;
            if (!allowNegatives) {
                return getLog(value, base)
            }
            if (0 === value) {
                return 0
            }
            var transformValue = getLog(abs(value), base) - (linearThreshold - 1);
            if (transformValue < 0) {
                return 0
            }
            return (0, _math.adjust)((0, _math.sign)(value) * transformValue, Number(pow(base, linearThreshold - 1).toFixed(abs(linearThreshold))))
        }

        function raiseToExt(value, base) {
            var allowNegatives = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : false;
            var linearThreshold = arguments.length > 3 ? arguments[3] : void 0;
            if (!allowNegatives) {
                return raiseTo(value, base)
            }
            if (0 === value) {
                return 0
            }
            var transformValue = raiseTo(abs(value) + (linearThreshold - 1), base);
            if (transformValue < 0) {
                return 0
            }
            return (0, _math.adjust)((0, _math.sign)(value) * transformValue, Number(pow(base, linearThreshold).toFixed(abs(linearThreshold))))
        }

        function rangesAreEqual(range, rangeFromOptions) {
            if (Array.isArray(rangeFromOptions)) {
                return range.length === rangeFromOptions.length && range.every(function(item, i) {
                    return valueOf(item) === valueOf(rangeFromOptions[i])
                })
            } else {
                return valueOf(range.startValue) === valueOf(rangeFromOptions.startValue) && valueOf(range.endValue) === valueOf(rangeFromOptions.endValue)
            }
        }

        function valueOf(value) {
            return value && value.valueOf()
        }

        function pointInCanvas(canvas, x, y) {
            return x >= canvas.left && x <= canvas.right && y >= canvas.top && y <= canvas.bottom
        }
        exports.getVizRangeObject = getVizRangeObject;
        exports.convertVisualRangeObject = convertVisualRangeObject;
        exports.adjustVisualRange = adjustVisualRange;
        exports.getAddFunction = getAddFunction;
        exports.getLog = getLog;
        exports.getLogExt = getLogExt;
        exports.getAdjustedLog10 = getAdjustedLog10;
        exports.raiseTo = raiseTo;
        exports.raiseToExt = raiseToExt;
        exports.normalizeAngle = normalizeAngle;
        exports.convertAngleToRendererSpace = convertAngleToRendererSpace;
        exports.degreesToRadians = degreesToRadians;
        exports.getCosAndSin = getCosAndSin;
        exports.getDecimalOrder = getDecimalOrder;
        exports.getAppropriateFormat = getAppropriateFormat;
        exports.getDistance = getDistance;
        exports.roundValue = roundValue;
        exports.getPower = getPower;
        exports.valueOf = valueOf;
        exports.rotateBBox = rotateBBox;
        exports.normalizeBBox = normalizeBBox;
        exports.PANE_PADDING = PANE_PADDING;
        exports.rangesAreEqual = rangesAreEqual;
        exports.pointInCanvas = pointInCanvas
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/core/class.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ./errors */ 23);
        var typeUtils = __webpack_require__( /*! ./utils/type */ 1);
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var that = this;
            var overridden;
            var memberName;
            var member;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var classObj = this;
            var argument;
            var name;
            var i;
            var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
            var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
            if (isES6Class) {
                classObj._includedCtors = classObj._includedCtors.slice(0);
                classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
            }
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    if (name in classObj.prototype) {
                        throw errors.Error("E0002", name)
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            var hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
            var isES6Class = !hasParentProperty && this.parent;
            if (isES6Class) {
                var baseClass = Object.getPrototypeOf(this);
                return baseClass === parentClass || baseClass.subclassOf(parentClass)
            } else {
                if (this.parent === parentClass) {
                    return true
                }
                if (!this.parent || !this.parent.subclassOf) {
                    return false
                }
                return this.parent.subclassOf(parentClass)
            }
        };
        var abstract = function() {
            throw errors.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || typeUtils.isWindow(this) || "function" !== typeof this.constructor) {
                    throw errors.Error("E0003")
                }
                var instance = this;
                var ctor = instance.ctor;
                var includedCtors = instance.constructor._includedCtors;
                var includedPostCtors = instance.constructor._includedPostCtors;
                var i;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        module.exports = classImpl
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.widget.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _action = __webpack_require__( /*! ../../core/action */ 107);
        var _action2 = _interopRequireDefault(_action);
        var _dom_component = __webpack_require__( /*! ../../core/dom_component */ 66);
        var _dom_component2 = _interopRequireDefault(_dom_component);
        var _short = __webpack_require__( /*! ../../events/short */ 121);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _selectors = __webpack_require__( /*! ./selectors */ 65);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _utils = __webpack_require__( /*! ../../events/utils */ 8);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        __webpack_require__( /*! ../../events/click */ 19);
        __webpack_require__( /*! ../../events/core/emitter.feedback */ 127);
        __webpack_require__( /*! ../../events/hover */ 149);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                })
            } else {
                obj[key] = value
            }
            return obj
        }

        function setAttribute(name, value, target) {
            name = "role" === name || "id" === name ? name : "aria-".concat(name);
            value = (0, _type.isDefined)(value) ? value.toString() : null;
            target.attr(name, value)
        }
        var Widget = _dom_component2.default.inherit({
            _feedbackHideTimeout: 400,
            _feedbackShowTimeout: 30,
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return (0, _extend2.extend)(this.callBase(), {
                    hoveredElement: null,
                    isActive: false,
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    onKeyboardHandled: null
                })
            },
            _init: function() {
                this.callBase();
                this._initContentReadyAction()
            },
            _innerWidgetOptionChanged: function(innerWidget, args) {
                var options = Widget.getOptionsFromContainer(args);
                innerWidget && innerWidget.option(options);
                this._options.cache(args.name, options)
            },
            _bindInnerWidgetOptions: function(innerWidget, optionsContainer) {
                var _this = this;
                var syncOptions = function() {
                    return _this._options.silent(optionsContainer, (0, _extend2.extend)({}, innerWidget.option()))
                };
                syncOptions();
                innerWidget.on("optionChanged", syncOptions)
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                var _this$option = this.option(),
                    disabled = _this$option.disabled,
                    visible = _this$option.visible;
                this.$element().addClass("dx-widget");
                this._toggleDisabledState(disabled);
                this._toggleVisibility(visible);
                this._renderHint();
                this._isFocusable() && this._renderFocusTarget();
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents()
            },
            _renderHint: function() {
                var _this$option2 = this.option(),
                    hint = _this$option2.hint;
                this.$element().attr("title", hint || null)
            },
            _renderContent: function() {
                var _this2 = this;
                (0, _common.deferRender)(function() {
                    return !_this2._disposed ? _this2._renderContentImpl() : void 0
                }).done(function() {
                    return !_this2._disposed ? _this2._fireContentReadyAction() : void 0
                })
            },
            _renderContentImpl: _common.noop,
            _fireContentReadyAction: (0, _common.deferRenderer)(function() {
                return this._contentReadyAction()
            }),
            _dispose: function() {
                this._contentReadyAction = null;
                this._detachKeyboardEvents();
                this.callBase()
            },
            _resetActiveState: function() {
                this._toggleActiveState(this._eventBindingTarget(), false)
            },
            _clean: function() {
                this._cleanFocusState();
                this._resetActiveState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass("dx-state-invisible", !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (this._isFocusable()) {
                    this._renderFocusTarget();
                    this._attachFocusEvents();
                    this._renderAccessKey()
                }
            },
            _renderAccessKey: function() {
                var _this3 = this;
                var $el = this._focusTarget();
                var _this$option3 = this.option(),
                    accessKey = _this$option3.accessKey;
                var namespace = "UIFeedback";
                $el.attr("accesskey", accessKey);
                _short.dxClick.off($el, {
                    namespace: namespace
                });
                accessKey && _short.dxClick.on($el, function(e) {
                    if ((0, _utils.isFakeClickEvent)(e)) {
                        e.stopImmediatePropagation();
                        _this3.focus()
                    }
                }, {
                    namespace: namespace
                })
            },
            _isFocusable: function() {
                var _this$option4 = this.option(),
                    focusStateEnabled = _this$option4.focusStateEnabled,
                    disabled = _this$option4.disabled;
                return focusStateEnabled && !disabled
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    return activeElement.find(this._activeStateUnit).not(".dx-state-disabled")
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                var _this$option5 = this.option(),
                    tabIndex = _this$option5.tabIndex;
                this._focusTarget().attr("tabIndex", tabIndex)
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusEventTarget: function() {
                return this._focusTarget()
            },
            _focusInHandler: function(event) {
                var _this4 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusIn", {
                        beforeExecute: function() {
                            return _this4._updateFocusState(event, true)
                        },
                        excludeValidators: ["readOnly"]
                    })({
                        event: event
                    })
                }
            },
            _focusOutHandler: function(event) {
                var _this5 = this;
                if (!event.isDefaultPrevented()) {
                    this._createActionByOption("onFocusOut", {
                        beforeExecute: function() {
                            return _this5._updateFocusState(event, false)
                        },
                        excludeValidators: ["readOnly", "disabled"]
                    })({
                        event: event
                    })
                }
            },
            _updateFocusState: function(_ref, isFocused) {
                var target = _ref.target;
                if ((0, _array.inArray)(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, (0, _renderer2.default)(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass("dx-state-focused", isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = (0, _renderer2.default)(element || this._focusTarget());
                return $focusTarget.hasClass("dx-state-focused")
            },
            _isFocused: function() {
                return this._hasFocusClass()
            },
            _getKeyboardListeners: function() {
                return []
            },
            _attachKeyboardEvents: function() {
                var _this6 = this;
                this._detachKeyboardEvents();
                var _this$option6 = this.option(),
                    focusStateEnabled = _this$option6.focusStateEnabled,
                    onKeyboardHandled = _this$option6.onKeyboardHandled;
                var hasChildListeners = this._getKeyboardListeners().length;
                var hasKeyboardEventHandler = !!onKeyboardHandled;
                var shouldAttach = focusStateEnabled || hasChildListeners || hasKeyboardEventHandler;
                if (shouldAttach) {
                    this._keyboardListenerId = _short.keyboard.on(this._keyboardEventBindingTarget(), this._focusTarget(), function(opts) {
                        return _this6._keyboardHandler(opts)
                    })
                }
            },
            _keyboardHandler: function(options, onlyChildProcessing) {
                if (!onlyChildProcessing) {
                    var originalEvent = options.originalEvent,
                        keyName = options.keyName,
                        which = options.which;
                    var keys = this._supportedKeys(originalEvent);
                    var func = keys[keyName] || keys[which];
                    if (void 0 !== func) {
                        var handler = func.bind(this);
                        var result = handler(originalEvent, options);
                        if (!result) {
                            return false
                        }
                    }
                }
                var keyboardListeners = this._getKeyboardListeners();
                var _this$option7 = this.option(),
                    onKeyboardHandled = _this$option7.onKeyboardHandled;
                keyboardListeners.forEach(function(listener) {
                    return listener && listener._keyboardHandler(options)
                });
                onKeyboardHandled && onKeyboardHandled(options);
                return true
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                $element.removeAttr("tabIndex");
                this._toggleFocusClass(false);
                this._detachFocusEvents();
                this._detachKeyboardEvents()
            },
            _detachKeyboardEvents: function() {
                _short.keyboard.off(this._keyboardListenerId);
                this._keyboardListenerId = null
            },
            _attachHoverEvents: function() {
                var _this7 = this;
                var _this$option8 = this.option(),
                    hoverStateEnabled = _this$option8.hoverStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.hover.off($el, {
                    selector: selector,
                    namespace: namespace
                });
                if (hoverStateEnabled) {
                    _short.hover.on($el, new _action2.default(function(_ref2) {
                        var event = _ref2.event,
                            element = _ref2.element;
                        _this7._hoverStartHandler(event);
                        _this7.option("hoveredElement", (0, _renderer2.default)(element))
                    }, {
                        excludeValidators: ["readOnly"]
                    }), function(event) {
                        _this7.option("hoveredElement", null);
                        _this7._hoverEndHandler(event)
                    }, {
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _attachFeedbackEvents: function() {
                var _this8 = this;
                var _this$option9 = this.option(),
                    activeStateEnabled = _this$option9.activeStateEnabled;
                var selector = this._activeStateUnit;
                var namespace = "UIFeedback";
                var $el = this._eventBindingTarget();
                _short.active.off($el, {
                    namespace: namespace,
                    selector: selector
                });
                if (activeStateEnabled) {
                    _short.active.on($el, new _action2.default(function(_ref3) {
                        var event = _ref3.event,
                            element = _ref3.element;
                        return _this8._toggleActiveState((0, _renderer2.default)(element), true, event)
                    }), new _action2.default(function(_ref4) {
                        var event = _ref4.event,
                            element = _ref4.element;
                        return _this8._toggleActiveState((0, _renderer2.default)(element), false, event)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    }), {
                        showTimeout: this._feedbackShowTimeout,
                        hideTimeout: this._feedbackHideTimeout,
                        selector: selector,
                        namespace: namespace
                    })
                }
            },
            _detachFocusEvents: function() {
                var $el = this._focusEventTarget();
                _short.focus.off($el, {
                    namespace: "".concat(this.NAME, "Focus")
                })
            },
            _attachFocusEvents: function() {
                var _this9 = this;
                var $el = this._focusEventTarget();
                _short.focus.on($el, function(e) {
                    return _this9._focusInHandler(e)
                }, function(e) {
                    return _this9._focusOutHandler(e)
                }, {
                    namespace: "".concat(this.NAME, "Focus"),
                    isFocusable: function(el) {
                        return (0, _renderer2.default)(el).is(_selectors.focusable)
                    }
                })
            },
            _hoverStartHandler: _common.noop,
            _hoverEndHandler: _common.noop,
            _toggleActiveState: function($element, value) {
                this.option("isActive", value);
                $element.toggleClass("dx-state-active", value)
            },
            _updatedHover: function() {
                var hoveredElement = this._options.silent("hoveredElement");
                this._hover(hoveredElement, hoveredElement)
            },
            _findHoverTarget: function($el) {
                return $el && $el.closest(this._activeStateUnit || this._eventBindingTarget())
            },
            _hover: function($el, $previous) {
                var _this$option10 = this.option(),
                    hoverStateEnabled = _this$option10.hoverStateEnabled,
                    disabled = _this$option10.disabled,
                    isActive = _this$option10.isActive;
                $previous = this._findHoverTarget($previous);
                $previous && $previous.toggleClass("dx-state-hover", false);
                if ($el && hoverStateEnabled && !disabled && !isActive) {
                    var newHoveredElement = this._findHoverTarget($el);
                    newHoveredElement && newHoveredElement.toggleClass("dx-state-hover", true)
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass("dx-state-disabled", Boolean(value));
                this.setAria("disabled", value || void 0)
            },
            _setWidgetOption: function(widgetName, args) {
                var _this10 = this;
                if (!this[widgetName]) {
                    return
                }
                if ((0, _type.isPlainObject)(args[0])) {
                    (0, _iterator.each)(args[0], function(option, value) {
                        return _this10._setWidgetOption(widgetName, [option, value])
                    });
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this["".concat(widgetName, "OptionMap")];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                var name = args.name,
                    value = args.value,
                    previousValue = args.previousValue;
                switch (name) {
                    case "disabled":
                        this._toggleDisabledState(value);
                        this._updatedHover();
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        this._updatedHover();
                        break;
                    case "tabIndex":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "hoveredElement":
                        this._hover(value, previousValue);
                        break;
                    case "isActive":
                        this._updatedHover();
                        break;
                    case "visible":
                        this._toggleVisibility(value);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(value ? "shown" : "hiding")
                        }
                        break;
                    case "onKeyboardHandled":
                        this._attachKeyboardEvents();
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                var _this$option11 = this.option(),
                    visible = _this$option11.visible;
                return this.callBase() && visible
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                if (!(0, _type.isPlainObject)(arguments.length <= 0 ? void 0 : arguments[0])) {
                    setAttribute(arguments.length <= 0 ? void 0 : arguments[0], arguments.length <= 1 ? void 0 : arguments[1], (arguments.length <= 2 ? void 0 : arguments[2]) || this._getAriaTarget())
                } else {
                    var target = (arguments.length <= 1 ? void 0 : arguments[1]) || this._getAriaTarget();
                    (0, _iterator.each)(arguments.length <= 0 ? void 0 : arguments[0], function(name, value) {
                        return setAttribute(name, value, target)
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                _short.focus.trigger(this._focusTarget())
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys();
                this._supportedKeys = function() {
                    return (0, _extend2.extend)(currentKeys, _defineProperty({}, key, handler))
                }
            }
        });
        Widget.getOptionsFromContainer = function(_ref5) {
            var name = _ref5.name,
                fullName = _ref5.fullName,
                value = _ref5.value;
            var options = {};
            if (name === fullName) {
                options = value
            } else {
                var option = fullName.split(".").pop();
                options[option] = value
            }
            return options
        };
        module.exports = Widget
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.errors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../../core/utils/error */ 148);
        var errors = __webpack_require__( /*! ../../core/errors */ 23);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: "{0} requires the key field to be specified",
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            E1050: "The validationRules option does not apply to third-party editors defined in the editCellTemplate",
            E1051: 'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',
            E1052: '{0} should have the "dataSource" option specified',
            E1053: 'The "buttons" option accepts an array that contains only objects or string values',
            E1054: "All text editor buttons must have names",
            E1055: 'One or several text editor buttons have invalid or non-unique "name" values',
            E1056: 'The {0} widget does not support buttons of the "{1}" type',
            E1058: 'The "startDayHour" must be earlier than the "endDayHour"',
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the following error: '{0}'",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects",
            W1013: 'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',
            W1014: "The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config.",
            W1015: 'The "cellDuration" should divide the range from the "startDayHour" to the "endDayHour" into even intervals'
        })
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/click.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var devices = __webpack_require__( /*! ../core/devices */ 14);
        var domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12);
        var domUtils = __webpack_require__( /*! ../core/utils/dom */ 11);
        var animationFrame = __webpack_require__( /*! ../animation/frame */ 122);
        var eventUtils = __webpack_require__( /*! ./utils */ 8);
        var pointerEvents = __webpack_require__( /*! ./pointer */ 24);
        var Emitter = __webpack_require__( /*! ./core/emitter */ 142);
        var registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 102);
        var compareVersions = __webpack_require__( /*! ../core/utils/version */ 61).compare;
        var CLICK_EVENT_NAME = "dxclick";
        var TOUCH_BOUNDARY = 10;
        var abs = Math.abs;
        var isInput = function(element) {
            return $(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: animationFrame.requestAnimationFrame,
            cancelAnimationFrame: animationFrame.cancelAnimationFrame
        };
        var ClickEmitter = Emitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable($(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = eventUtils.eventData(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === pointerEvents.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    domUtils.resetActiveElement()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target;
                var targetChanged = !domUtils.contains(element, target) && element !== target;
                var gestureDelta = eventUtils.eventDelta(eventUtils.eventData(e), this._startEventData);
                var boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: domUtils.closestCommonParent(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var realDevice = devices.real();
            var useNativeClick = realDevice.generic || realDevice.ios && compareVersions(realDevice.version, [9, 3]) >= 0 || realDevice.android && compareVersions(realDevice.version, [5]) >= 0;
            var isNativeClickEvent = function(target) {
                return useNativeClick || $(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null;
            var lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent;
                var eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED;
                var leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && !eventAlreadyFired) {
                    if (originalEvent) {
                        originalEvent.DXCLICK_FIRED = true
                    }
                    lastFiredEvent = originalEvent;
                    eventUtils.fireEvent({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    eventsEngine.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    eventsEngine.off(this.getElement(), "click", clickHandler)
                }
            });
            exports.useNativeClick = useNativeClick
        }();
        ! function() {
            var desktopDevice = devices.real().generic;
            if (!desktopDevice) {
                var startTarget = null;
                var blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = $(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !$(startTarget).is("label") && isInput($target)) {
                        domUtils.resetActiveElement()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER";
                var document = domAdapter.getDocument();
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        registerEmitter({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        });
        exports.name = CLICK_EVENT_NAME;
        exports.misc = misc
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/data_grid/ui.data_grid.core.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _uiGrid_core = __webpack_require__( /*! ../grid_core/ui.grid_core.utils */ 30);
        var _uiGrid_core2 = _interopRequireDefault(_uiGrid_core);
        var _uiGrid_core3 = __webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 36);
        var _uiGrid_core4 = _interopRequireDefault(_uiGrid_core3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }(0, _extend.extend)(exports, _uiGrid_core4.default, _uiGrid_core2.default, {
            modules: []
        })
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/data.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 23);
        var Class = __webpack_require__( /*! ../class */ 16);
        var objectUtils = __webpack_require__( /*! ./object */ 49);
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var each = __webpack_require__( /*! ./iterator */ 4).each;
        var variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 89);
        var unwrapVariable = variableWrapper.unwrap;
        var isWrapped = variableWrapper.isWrapped;
        var assign = variableWrapper.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new errors.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };

        function unwrap(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        }
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs;
                    var hasDefaultValue = "defaultValue" in options;
                    var current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            if (null == current && hasDefaultValue) {
                                return options.defaultValue
                            }
                            break
                        }
                        var pathPart = path[i];
                        if (hasDefaultValue && typeUtils.isObject(current) && !(pathPart in current)) {
                            return options.defaultValue
                        }
                        var next = unwrap(current[pathPart], options);
                        if (!functionAsIs && typeUtils.isFunction(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if (typeUtils.isFunction(expr)) {
                return expr
            }
        };

        function combineGetters(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                each(compiledGetters, function(name) {
                    var value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    var current = result || (result = {});
                    var path = name.split(".");
                    var last = path.length - 1;
                    for (var _i = 0; _i < last; _i++) {
                        var pathItem = path[_i];
                        if (!(pathItem in current)) {
                            current[pathItem] = {}
                        }
                        current = current[pathItem]
                    }
                    current[path[last]] = value
                });
                return result
            }
        }
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if (typeUtils.isDefined(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options);
                    var isPropertyFunc = !options.functionsAsIs && typeUtils.isFunction(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && typeUtils.isPlainObject(value) && (!typeUtils.isDefined(propertyValue) || typeUtils.isPlainObject(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            objectUtils.deepExtendArraySafe(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof Class && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.compileGetter = compileGetter;
        exports.compileSetter = compileSetter;
        exports.toComparable = toComparable
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/position.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _config = __webpack_require__( /*! ../config */ 32);
        var _config2 = _interopRequireDefault(_config);
        var _type = __webpack_require__( /*! ../utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = null !== isRtlEnabled && void 0 !== isRtlEnabled ? isRtlEnabled : (0, _config2.default)().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        var getBoundingRect = function(element) {
            if (_type2.default.isWindow(element)) {
                return {
                    width: element.outerWidth,
                    height: element.outerHeight
                }
            }
            var rect;
            try {
                rect = element.getBoundingClientRect()
            } catch (e) {
                rect = {
                    width: 0,
                    height: 0,
                    bottom: 0,
                    top: 0,
                    left: 0,
                    right: 0
                }
            }
            return rect
        };
        exports.getDefaultAlignment = getDefaultAlignment;
        exports.getBoundingRect = getBoundingRect
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ./utils/error */ 148);
        module.exports = errorUtils({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        })
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/events/pointer.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _support = __webpack_require__( /*! ../core/utils/support */ 45);
        var _support2 = _interopRequireDefault(_support);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _browser = __webpack_require__( /*! ../core/utils/browser */ 25);
        var _browser2 = _interopRequireDefault(_browser);
        var _devices = __webpack_require__( /*! ../core/devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _event_registrator = __webpack_require__( /*! ./core/event_registrator */ 79);
        var _event_registrator2 = _interopRequireDefault(_event_registrator);
        var _touch = __webpack_require__( /*! ./pointer/touch */ 284);
        var _touch2 = _interopRequireDefault(_touch);
        var _mspointer = __webpack_require__( /*! ./pointer/mspointer */ 483);
        var _mspointer2 = _interopRequireDefault(_mspointer);
        var _mouse = __webpack_require__( /*! ./pointer/mouse */ 286);
        var _mouse2 = _interopRequireDefault(_mouse);
        var _mouse_and_touch = __webpack_require__( /*! ./pointer/mouse_and_touch */ 484);
        var _mouse_and_touch2 = _interopRequireDefault(_mouse_and_touch);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getStrategy = function(support, device, browser) {
            if (support.pointerEvents && browser.msie) {
                return _mspointer2.default
            }
            var tablet = device.tablet,
                phone = device.phone;
            if (support.touch && !(tablet || phone)) {
                return _mouse_and_touch2.default
            }
            if (support.touch) {
                return _touch2.default
            }
            return _mouse2.default
        };
        var EventStrategy = getStrategy(_support2.default, _devices2.default.real(), _browser2.default);
        (0, _iterator.each)(EventStrategy.map, function(pointerEvent, originalEvents) {
            (0, _event_registrator2.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        var pointer = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        };
        pointer.getStrategy = getStrategy;
        module.exports = pointer
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/browser.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend;
        var windowUtils = __webpack_require__( /*! ./window */ 7);
        var navigator = windowUtils.getNavigator();
        var webkitRegExp = /(webkit)[ \/]([\w.]+)/;
        var ieRegExp = /(msie) (\d{1,2}\.\d)/;
        var ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/;
        var msEdge = /(edge)\/((\d+)?[\w.]+)/;
        var mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {};
            var matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [];
            var browserName = matches[1];
            var browserVersion = matches[2];
            if ("webkit" === browserName) {
                result.webkit = true;
                if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                    browserName = "chrome";
                    browserVersion = /(?:chrome|crios)\/(\d+\.\d+)/.exec(ua);
                    browserVersion = browserVersion && browserVersion[1]
                } else {
                    if (ua.indexOf("fxios") >= 0) {
                        browserName = "mozilla";
                        browserVersion = /fxios\/(\d+\.\d+)/.exec(ua);
                        browserVersion = browserVersion && browserVersion[1]
                    } else {
                        if (ua.indexOf("safari") >= 0 && /version|phantomjs/.test(ua)) {
                            browserName = "safari";
                            browserVersion = /(?:version|phantomjs)\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else {
                            browserName = "unknown";
                            browserVersion = /applewebkit\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                }
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        module.exports = extend({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent))
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var adjust = __webpack_require__( /*! ./math */ 31).adjust;
        var each = __webpack_require__( /*! ./iterator */ 4).each;
        var camelize = __webpack_require__( /*! ./inflector */ 38).camelize;
        var isObject = typeUtils.isObject;
        var isString = typeUtils.isString;
        var isDate = typeUtils.isDate;
        var isDefined = typeUtils.isDefined;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime();
            var millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i;
            var dateUnitCount;
            var dateUnitInterval;
            var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"];
            var result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if (isString(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };

        function convertDateUnitToMilliseconds(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        }

        function getDateUnitInterval(tickInterval) {
            var maxInterval = -1;
            var i;
            if (isString(tickInterval)) {
                return tickInterval
            }
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        }
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };

        function correctDateWithUnitBeginning(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var oldDate = new Date(date.getTime());
            var firstQuarterMonth;
            var month;
            var dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    month = date.getMonth();
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0);
                    if (month !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        }

        function trimTime(date) {
            return correctDateWithUnitBeginning(date, "day")
        }
        var setToDayEnd = function(date) {
            var result = trimTime(date);
            result.setDate(result.getDate() + 1);
            return new Date(result.getTime() - 1)
        };
        var getDatesDifferences = function(date1, date2) {
            var counter = 0;
            var differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            each(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime());
            var intervalObject = isString(interval) ? getDateIntervalByString(interval.toLowerCase()) : typeUtils.isNumeric(interval) ? convertMillisecondsToDateUnits(interval) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return isDate(value) ? addDateInterval(value, interval, dir) : adjust(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var intervals = [];
            var cur;
            intervals.push(isDate(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date);
            resultDate.setDate(getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };

        function getLastMonthDay(date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        }
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };

        function getDateIntervalByString(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        }

        function sameDate(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        }

        function sameMonthAndYear(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        }

        function sameYear(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        }
        var sameDecade = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10;
            var startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100;
            var startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };

        function getFirstDecadeInCentury(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        }

        function getFirstYearInDecade(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        }
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
            return newDate
        };
        var getLastMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return newDate
        };

        function getFirstWeekDate(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        }
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day");
            var resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var dateTimeFromDecimal = function(number) {
            var hours = Math.floor(number);
            var minutes = number % 1 * 60;
            return {
                hours: hours,
                minutes: minutes
            }
        };
        var roundDateByStartDayHour = function(date, startDayHour) {
            var startTime = this.dateTimeFromDecimal(startDayHour);
            var result = new Date(date);
            if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                result.setHours(startTime.hours, startTime.minutes, 0, 0)
            }
            return result
        };

        function normalizeDate(date, min, max) {
            var normalizedDate = date;
            if (!isDefined(date)) {
                return date
            }
            if (isDefined(min) && date < min) {
                normalizedDate = min
            }
            if (isDefined(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        }

        function fixTimezoneGap(oldDate, newDate) {
            if (!isDefined(oldDate)) {
                return
            }
            var diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            var sign = 1 === diff || diff === -23 ? -1 : 1;
            var trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        }
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };

        function getTimezonesDifference(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        }
        var makeDate = function(date) {
            return new Date(date)
        };
        var getDatesOfInterval = function(startDate, endDate, step) {
            var result = [];
            var currentDate = new Date(startDate.getTime());
            if (startDate.getTime() === endDate.getTime()) {
                result.push(new Date(startDate.getTime()))
            }
            while (currentDate < endDate) {
                result.push(new Date(currentDate.getTime()));
                currentDate = this.addInterval(currentDate, step)
            }
            return result
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            setToDayEnd: setToDayEnd,
            roundDateByStartDayHour: roundDateByStartDayHour,
            dateTimeFromDecimal: dateTimeFromDecimal,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval,
            getDatesOfInterval: getDatesOfInterval
        };
        dateUtils.sameView = function(view, date1, date2) {
            return dateUtils[camelize("same " + view)](date1, date2)
        };
        module.exports = dateUtils
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/callbacks.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes;
            var list = this._list;
            var stopOnFalse = this._options.stopOnFalse;
            var step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list;
            var firingIndexes = this._firingIndexes;
            var index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        module.exports = Callbacks
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/animation/translator.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../core/element_data */ 44);
        var type = __webpack_require__( /*! ../core/utils/type */ 1).type;
        var TRANSLATOR_DATA_KEY = "dxTranslator";
        var TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/;
        var TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };

        function isPercentValue(value) {
            return "string" === type(value) && "%" === value[value.length - 1]
        }

        function cacheTranslate($element, translate) {
            if ($element.length) {
                dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        }
        var clearCache = function($element) {
            if ($element.length) {
                dataUtils.removeData($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        var getTranslate = function($element) {
            var result = $element.length ? dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                    x: 0,
                    y: 0
                });
                var matrix = transformValue.match(TRANSFORM_MATRIX_REGEX);
                var is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        var move = function($element, position) {
            var left = position.left;
            var top = position.top;
            var translate;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        var resetPosition = function($element, finishTransition) {
            var originalTransition;
            var stylesConfig = {
                left: 0,
                top: 0,
                transform: "none"
            };
            if (finishTransition) {
                originalTransition = $element.css("transition");
                stylesConfig.transition = "none"
            }
            $element.css(stylesConfig);
            clearCache($element);
            if (finishTransition) {
                $element.get(0).offsetHeight;
                $element.css("transition", originalTransition)
            }
        };
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        exports.move = move;
        exports.locate = locate;
        exports.clearCache = clearCache;
        exports.parseTranslate = parseTranslate;
        exports.getTranslate = getTranslate;
        exports.getTranslateCss = getTranslateCss;
        exports.resetPosition = resetPosition
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/themes.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12);
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred;
        var errors = __webpack_require__( /*! ./widget/ui.errors */ 18);
        var domUtils = __webpack_require__( /*! ../core/utils/dom */ 11);
        var readyCallbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 54);
        var ready = readyCallbacks.add;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var devices = __webpack_require__( /*! ../core/devices */ 14);
        var viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 75);
        var themeReadyCallback = __webpack_require__( /*! ./themes_callback */ 287);
        var viewPort = viewPortUtils.value;
        var Promise = __webpack_require__( /*! ../core/polyfills/promise */ 74);
        var viewPortChanged = viewPortUtils.changeCallback;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]";
        var THEME_ATTR = "data-theme";
        var ACTIVE_ATTR = "data-active";
        var DX_HAIRLINES_CLASS = "dx-hairlines";
        var context;
        var $activeThemeLink;
        var knownThemes;
        var currentThemeName;
        var pendingThemeName;
        var timerId;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!windowUtils.hasWindow()) {
                return null
            }
            var element = $("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            var result;
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                themeReadyCallback.fire();
                themeReadyCallback.empty()
            }
            if (isPendingThemeLoaded()) {
                handleLoaded()
            } else {
                waitStartTime = Date.now();
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded();
                    var isTimeout = !isLoaded && Date.now() - waitStartTime > 15e3;
                    if (isTimeout) {
                        errors.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        clearInterval(timerId);
                        timerId = void 0;
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            return !pendingThemeName || readThemeMarker() === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = $(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = $(domUtils.createMarkupFromString("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = $(this, context);
                var fullThemeName = link.attr(THEME_ATTR);
                var url = link.attr("href");
                var isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName ? desiredThemeName.split(".") : [];
            var result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }
                each(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (desiredThemeParts[0] && knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || domAdapter.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var isAutoInit = options._autoInit;
            var loadCallback = options.loadCallback;
            var currentThemeData;
            currentThemeName = resolveFullThemeName(options.theme || currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if ((themeReadyCallback.has() || options._forceTimeout) && !timerId) {
                    waitForThemeLoad(currentThemeName)
                } else {
                    if (pendingThemeName) {
                        pendingThemeName = currentThemeName
                    }
                }
            } else {
                if (isAutoInit) {
                    themeReadyCallback.fire();
                    themeReadyCallback.empty()
                } else {
                    throw errors.Error("E0021", currentThemeName)
                }
            }
            checkThemeDeprecation();
            attachCssClasses(viewPortUtils.originalViewPort(), currentThemeName)
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [];
            var themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial(themeName) ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            $(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = windowUtils.hasWindow() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = $("<div>");
                $tester.css("border", ".5px solid transparent");
                $("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    $(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            $(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            themeReadyCallback.add(callback)
        }

        function isTheme(themeRegExp, themeName) {
            if (!themeName) {
                themeName = currentThemeName || readThemeMarker()
            }
            return new RegExp(themeRegExp).test(themeName)
        }

        function isMaterial(themeName) {
            return isTheme("material", themeName)
        }

        function isIos7(themeName) {
            return isTheme("ios7", themeName)
        }

        function isGeneric(themeName) {
            return isTheme("generic", themeName)
        }

        function isDark(themeName) {
            return isTheme("dark", themeName)
        }

        function checkThemeDeprecation() {
            if (isIos7()) {
                errors.log("W0010", "The 'ios7' theme", "19.1", "Use the 'generic' theme instead.")
            }
        }

        function isWebFontLoaded(text, fontWeight) {
            var testedFont = "Roboto, RobotoFallback, Arial";
            var etalonFont = "Arial";
            var document = domAdapter.getDocument();
            var testElement = document.createElement("span");
            testElement.style.position = "absolute";
            testElement.style.top = "-9999px";
            testElement.style.left = "-9999px";
            testElement.style.visibility = "hidden";
            testElement.style.fontFamily = etalonFont;
            testElement.style.fontSize = "250px";
            testElement.style.fontWeight = fontWeight;
            testElement.innerHTML = text;
            document.body.appendChild(testElement);
            var etalonFontWidth = testElement.offsetWidth;
            testElement.style.fontFamily = testedFont;
            var testedFontWidth = testElement.offsetWidth;
            testElement.parentNode.removeChild(testElement);
            return etalonFontWidth !== testedFontWidth
        }

        function waitWebFont(text, fontWeight) {
            var interval = 15;
            var timeout = 2e3;
            return new Promise(function(resolve) {
                var check = function() {
                    if (isWebFontLoaded(text, fontWeight)) {
                        clear()
                    }
                };
                var clear = function() {
                    clearInterval(intervalId);
                    clearTimeout(timeoutId);
                    resolve()
                };
                var intervalId = setInterval(check, interval);
                var timeoutId = setTimeout(clear, timeout)
            })
        }
        var initDeferred = new Deferred;

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ($(DX_LINK_SELECTOR, context).length) {
                throw errors.Error("E0022")
            }
            initDeferred.resolve()
        }
        if (windowUtils.hasWindow()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        devices.changed.add(function() {
            init({
                _autoInit: true
            })
        });
        exports.current = current;
        exports.ready = themeReady;
        exports.init = init;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.isMaterial = isMaterial;
        exports.isIos7 = isIos7;
        exports.isGeneric = isGeneric;
        exports.isDark = isDark;
        exports.isWebFontLoaded = isWebFontLoaded;
        exports.waitWebFont = waitWebFont;
        exports.resetTheme = function() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null
        }
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.utils.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _filtering = __webpack_require__( /*! ../shared/filtering */ 143);
        var _string = __webpack_require__( /*! ../../core/utils/string */ 41);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _position = __webpack_require__( /*! ../../core/utils/position */ 22);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 21);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _load_panel = __webpack_require__( /*! ../load_panel */ 161);
        var _load_panel2 = _interopRequireDefault(_load_panel);
        var _utils = __webpack_require__( /*! ../../data/utils */ 42);
        var _format_helper = __webpack_require__( /*! ../../format_helper */ 68);
        var _format_helper2 = _interopRequireDefault(_format_helper);
        var _object = __webpack_require__( /*! ../../core/utils/object */ 49);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DATAGRID_SELECTION_DISABLED_CLASS = "dx-selection-disabled";
        var DATAGRID_GROUP_OPENED_CLASS = "dx-datagrid-group-opened";
        var DATAGRID_GROUP_CLOSED_CLASS = "dx-datagrid-group-closed";
        var DATAGRID_EXPAND_CLASS = "dx-datagrid-expand";
        var NO_DATA_CLASS = "nodata";
        var DATE_INTERVAL_SELECTORS = {
            year: function(value) {
                return value && value.getFullYear()
            },
            month: function(value) {
                return value && value.getMonth() + 1
            },
            day: function(value) {
                return value && value.getDate()
            },
            quarter: function(value) {
                return value && Math.floor(value.getMonth() / 3) + 1
            },
            hour: function(value) {
                return value && value.getHours()
            },
            minute: function(value) {
                return value && value.getMinutes()
            },
            second: function(value) {
                return value && value.getSeconds()
            }
        };
        module.exports = function() {
            var getIntervalSelector = function() {
                var data = arguments[1];
                var value = this.calculateCellValue(data);
                if (!(0, _type.isDefined)(value)) {
                    return null
                } else {
                    if (isDateType(this.dataType)) {
                        var nameIntervalSelector = arguments[0];
                        return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                    } else {
                        if ("number" === this.dataType) {
                            var groupInterval = arguments[0];
                            return Math.floor(Number(value) / groupInterval) * groupInterval
                        }
                    }
                }
            };
            var equalSelectors = function(selector1, selector2) {
                if ((0, _type.isFunction)(selector1) && (0, _type.isFunction)(selector2)) {
                    if (selector1.originalCallback && selector2.originalCallback) {
                        return selector1.originalCallback === selector2.originalCallback && selector1.columnIndex === selector2.columnIndex
                    }
                }
                return selector1 === selector2
            };

            function isDateType(dataType) {
                return "date" === dataType || "datetime" === dataType
            }
            var setEmptyText = function($container) {
                $container.get(0).textContent = "\xa0"
            };
            var getWidgetInstance = function($element) {
                var editorData = $element.data && $element.data();
                var dxComponents = editorData && editorData.dxComponents;
                var widgetName = dxComponents && dxComponents[0];
                return widgetName && editorData[widgetName]
            };
            return {
                renderNoDataText: function($element) {
                    var that = this;
                    $element = $element || this.element();
                    if (!$element) {
                        return
                    }
                    var noDataClass = that.addWidgetPrefix(NO_DATA_CLASS);
                    var noDataElement = $element.find("." + noDataClass).last();
                    var isVisible = this._dataController.isEmpty();
                    var isLoading = this._dataController.isLoading();
                    if (!noDataElement.length) {
                        noDataElement = (0, _renderer2.default)("<span>").addClass(noDataClass).appendTo($element)
                    }
                    if (isVisible && !isLoading) {
                        noDataElement.removeClass("dx-hidden").text(that._getNoDataText())
                    } else {
                        noDataElement.addClass("dx-hidden")
                    }
                },
                renderLoadPanel: function($element, $container, isLocalStore) {
                    var that = this;
                    var loadPanelOptions;
                    that._loadPanel && that._loadPanel.$element().remove();
                    loadPanelOptions = that.option("loadPanel");
                    if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                        loadPanelOptions = (0, _extend.extend)({
                            shading: false,
                            message: loadPanelOptions.text,
                            position: function() {
                                var $window = (0, _renderer2.default)((0, _window.getWindow)());
                                if ($element.height() > $window.height()) {
                                    return {
                                        of: $window,
                                        boundary: $element,
                                        collision: "fit"
                                    }
                                }
                                return {
                                    of: $element
                                }
                            },
                            container: $container
                        }, loadPanelOptions);
                        that._loadPanel = that._createComponent((0, _renderer2.default)("<div>").appendTo($container), _load_panel2.default, loadPanelOptions)
                    } else {
                        that._loadPanel = null
                    }
                },
                getIndexByKey: function(key, items, keyName) {
                    var index = -1;
                    if (void 0 !== key && Array.isArray(items)) {
                        keyName = arguments.length <= 2 ? "key" : keyName;
                        for (var i = 0; i < items.length; i++) {
                            var item = (0, _type.isDefined)(keyName) ? items[i][keyName] : items[i];
                            if ((0, _common.equalByValue)(key, item)) {
                                index = i;
                                break
                            }
                        }
                    }
                    return index
                },
                combineFilters: function(filters, operation) {
                    var resultFilter = [];
                    operation = operation || "and";
                    for (var i = 0; i < filters.length; i++) {
                        if (!filters[i]) {
                            continue
                        }
                        if (resultFilter.length) {
                            resultFilter.push(operation)
                        }
                        resultFilter.push(filters[i])
                    }
                    if (1 === resultFilter.length) {
                        resultFilter = resultFilter[0]
                    }
                    if (resultFilter.length) {
                        return resultFilter
                    }
                },
                checkChanges: function(changes, changeNames) {
                    var changesWithChangeNamesCount = 0;
                    for (var i = 0; i < changeNames.length; i++) {
                        if (changes[changeNames[i]]) {
                            changesWithChangeNamesCount++
                        }
                    }
                    return changes.length && changes.length === changesWithChangeNamesCount
                },
                equalFilterParameters: function(filter1, filter2) {
                    if (Array.isArray(filter1) && Array.isArray(filter2)) {
                        if (filter1.length !== filter2.length) {
                            return false
                        } else {
                            for (var i = 0; i < filter1.length; i++) {
                                if (!module.exports.equalFilterParameters(filter1[i], filter2[i])) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        if ((0, _type.isFunction)(filter1) && filter1.columnIndex >= 0 && (0, _type.isFunction)(filter2) && filter2.columnIndex >= 0) {
                            return filter1.columnIndex === filter2.columnIndex && (0, _data.toComparable)(filter1.filterValue) === (0, _data.toComparable)(filter2.filterValue)
                        } else {
                            return (0, _data.toComparable)(filter1) == (0, _data.toComparable)(filter2)
                        }
                    }
                },
                proxyMethod: function(instance, methodName, defaultResult) {
                    if (!instance[methodName]) {
                        instance[methodName] = function() {
                            var dataSource = this._dataSource;
                            return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                        }
                    }
                },
                formatValue: function(value, options) {
                    var valueText = _format_helper2.default.format(value, options.format) || value && value.toString() || "";
                    var formatObject = {
                        value: value,
                        valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                        target: options.target || "row",
                        groupInterval: options.groupInterval
                    };
                    return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
                },
                getFormatOptionsByColumn: function(column, target) {
                    return {
                        format: column.format,
                        getDisplayFormat: column.getDisplayFormat,
                        customizeText: column.customizeText,
                        target: target,
                        trueText: column.trueText,
                        falseText: column.falseText
                    }
                },
                getDisplayValue: function(column, value, data, rowType) {
                    if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                        return column.displayValueMap[value]
                    } else {
                        if (column.calculateDisplayValue && data && "group" !== rowType) {
                            return column.calculateDisplayValue(data)
                        } else {
                            if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                                return column.lookup.calculateCellValue(value)
                            }
                        }
                    }
                    return value
                },
                getGroupRowSummaryText: function(summaryItems, summaryTexts) {
                    var result = "(";
                    for (var i = 0; i < summaryItems.length; i++) {
                        var summaryItem = summaryItems[i];
                        result += (i > 0 ? ", " : "") + module.exports.getSummaryText(summaryItem, summaryTexts)
                    }
                    return result += ")"
                },
                getSummaryText: function(summaryItem, summaryTexts) {
                    var displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts[summaryItem.summaryType + "OtherColumn"] || summaryTexts[summaryItem.summaryType];
                    return this.formatValue(summaryItem.value, {
                        format: summaryItem.valueFormat,
                        getDisplayFormat: function(valueText) {
                            return displayFormat ? (0, _string.format)(displayFormat, valueText, summaryItem.columnCaption) : valueText
                        },
                        customizeText: summaryItem.customizeText
                    })
                },
                normalizeSortingInfo: function(sort) {
                    sort = sort || [];
                    var result = (0, _utils.normalizeSortingInfo)(sort);
                    for (var i = 0; i < sort.length; i++) {
                        if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                            result[i].isExpanded = sort[i].isExpanded
                        }
                        if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                            result[i].groupInterval = sort[i].groupInterval
                        }
                    }
                    return result
                },
                getFormatByDataType: function(dataType) {
                    switch (dataType) {
                        case "date":
                            return "shortDate";
                        case "datetime":
                            return "shortDateShortTime"
                    }
                },
                getHeaderFilterGroupParameters: function(column, remoteGrouping) {
                    var result = [];
                    var dataField = column.dataField || column.name;
                    var groupInterval = (0, _filtering.getGroupInterval)(column);
                    if (groupInterval) {
                        (0, _iterator.each)(groupInterval, function(index, interval) {
                            result.push(remoteGrouping ? {
                                selector: dataField,
                                groupInterval: interval,
                                isExpanded: index < groupInterval.length - 1
                            } : getIntervalSelector.bind(column, interval))
                        });
                        return result
                    }
                    if (remoteGrouping) {
                        result = [{
                            selector: dataField,
                            isExpanded: false
                        }]
                    } else {
                        result = function result(data) {
                            var result = column.calculateCellValue(data);
                            if (void 0 === result || "" === result) {
                                result = null
                            }
                            return result
                        };
                        if (column.sortingMethod) {
                            result = [{
                                selector: result,
                                compare: column.sortingMethod.bind(column)
                            }]
                        }
                    }
                    return result
                },
                equalSortParameters: function(sortParameters1, sortParameters2, ignoreIsExpanded) {
                    sortParameters1 = module.exports.normalizeSortingInfo(sortParameters1);
                    sortParameters2 = module.exports.normalizeSortingInfo(sortParameters2);
                    if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                        if (sortParameters1.length !== sortParameters2.length) {
                            return false
                        } else {
                            for (var i = 0; i < sortParameters1.length; i++) {
                                if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                    }
                },
                getPointsByColumns: function(items, pointCreated, isVertical, startColumnIndex) {
                    var cellsLength = items.length;
                    var notCreatePoint = false;
                    var item;
                    var offset;
                    var columnIndex = startColumnIndex || 0;
                    var result = [];
                    var rtlEnabled;
                    for (var i = 0; i <= cellsLength; i++) {
                        if (i < cellsLength) {
                            item = items.eq(i);
                            offset = item.offset();
                            rtlEnabled = "rtl" === item.css("direction")
                        }
                        var point = {
                            index: columnIndex,
                            x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? (0, _position.getBoundingRect)(item[0]).width : 0) : 0,
                            y: offset ? offset.top + (isVertical && i === cellsLength ? (0, _position.getBoundingRect)(item[0]).height : 0) : 0,
                            columnIndex: columnIndex
                        };
                        if (!isVertical && i > 0) {
                            var prevItemOffset = items.eq(i - 1).offset();
                            if (prevItemOffset.top < point.y) {
                                point.y = prevItemOffset.top
                            }
                        }
                        if (pointCreated) {
                            notCreatePoint = pointCreated(point)
                        }
                        if (!notCreatePoint) {
                            result.push(point)
                        }
                        columnIndex++
                    }
                    return result
                },
                createObjectWithChanges: function(target, changes) {
                    var result = target ? Object.create(Object.getPrototypeOf(target)) : {};
                    var targetWithoutPrototype = (0, _extend.extendFromObject)({}, target);
                    (0, _object.deepExtendArraySafe)(result, targetWithoutPrototype, true, true);
                    return (0, _object.deepExtendArraySafe)(result, changes, true, true)
                },
                getExpandCellTemplate: function() {
                    return {
                        allowRenderToDetachedContainer: true,
                        render: function(container, options) {
                            var $container = (0, _renderer2.default)(container);
                            if ((0, _type.isDefined)(options.value) && !(options.data && options.data.isContinuation) && !options.row.isNewRow) {
                                var rowsView = options.component.getView("rowsView");
                                $container.addClass(DATAGRID_EXPAND_CLASS).addClass(DATAGRID_SELECTION_DISABLED_CLASS);
                                (0, _renderer2.default)("<div>").addClass(options.value ? DATAGRID_GROUP_OPENED_CLASS : DATAGRID_GROUP_CLOSED_CLASS).appendTo($container);
                                rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                            } else {
                                setEmptyText($container)
                            }
                        }
                    }
                },
                setEmptyText: setEmptyText,
                isDateType: isDateType,
                getSelectionRange: function(focusedElement) {
                    try {
                        if (focusedElement) {
                            return {
                                selectionStart: focusedElement.selectionStart,
                                selectionEnd: focusedElement.selectionEnd
                            }
                        }
                    } catch (e) {}
                    return {}
                },
                setSelectionRange: function(focusedElement, selectionRange) {
                    try {
                        if (focusedElement && focusedElement.setSelectionRange) {
                            focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                        }
                    } catch (e) {}
                },
                focusAndSelectElement: function(component, $element) {
                    _events_engine2.default.trigger($element, "focus");
                    var isSelectTextOnEditingStart = component.option("editing.selectTextOnEditStart");
                    var keyboardController = component.getController("keyboardNavigation");
                    var isEditingNavigationMode = keyboardController && keyboardController._isFastEditingStarted();
                    if (isSelectTextOnEditingStart && !isEditingNavigationMode && $element.is(".dx-texteditor-input")) {
                        var editor = getWidgetInstance($element.closest(".dx-texteditor"));
                        (0, _deferred.when)(editor && editor._loadItemDeferred).done(function() {
                            $element.get(0).select()
                        })
                    }
                },
                getWidgetInstance: getWidgetInstance,
                getLastResizableColumnIndex: function(columns, resultWidths) {
                    var hasResizableColumns = columns.some(function(column) {
                        return column && !column.command && !column.fixed && false !== column.allowResizing
                    });
                    var lastColumnIndex;
                    for (lastColumnIndex = columns.length - 1; columns[lastColumnIndex]; lastColumnIndex--) {
                        var column = columns[lastColumnIndex];
                        var width = resultWidths && resultWidths[lastColumnIndex];
                        var allowResizing = !hasResizableColumns || false !== column.allowResizing;
                        if (!column.command && !column.fixed && "adaptiveHidden" !== width && allowResizing) {
                            break
                        }
                    }
                    return lastColumnIndex
                },
                isElementInCurrentGrid: function(controller, $element) {
                    if ($element && $element.length) {
                        var $grid = $element.closest("." + controller.getWidgetContainerClass()).parent();
                        return $grid.is(controller.component.$element())
                    }
                    return false
                }
            }
        }()
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/math.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isExponential = __webpack_require__( /*! ./type */ 1).isExponential;
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue;
            var isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4;
            var correctValue = "0.000300";
            var precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var precision = getPrecision(interval || 0) + 2;
            var separatedValue = value.toString().split(".");
            var sourceValue = value;
            var absValue = Math.abs(value);
            var separatedAdjustedValue;
            var isExponentValue = isExponential(value);
            var integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if (isExponential(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            var mantissa = str.split(".");
            var positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }

        function getRoot(x, n) {
            if (x < 0 && n % 2 !== 1) {
                return NaN
            }
            var y = Math.pow(Math.abs(x), 1 / n);
            return n % 2 === 1 && x < 0 ? -y : y
        }

        function solveCubicEquation(a, b, c, d) {
            var min = 1e-8;
            if (Math.abs(a) < min) {
                a = b;
                b = c;
                c = d;
                if (Math.abs(a) < min) {
                    a = b;
                    b = c;
                    if (Math.abs(a) < min) {
                        return []
                    }
                    return [-b / a]
                }
                var D2 = b * b - 4 * a * c;
                if (Math.abs(D2) < min) {
                    return [-b / (2 * a)]
                } else {
                    if (D2 > 0) {
                        return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                    }
                }
                return []
            }
            var p = (3 * a * c - b * b) / (3 * a * a);
            var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
            var roots;
            var u;
            if (Math.abs(p) < min) {
                roots = [getRoot(-q, 3)]
            } else {
                if (Math.abs(q) < min) {
                    roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                } else {
                    var D3 = q * q / 4 + p * p * p / 27;
                    if (Math.abs(D3) < min) {
                        roots = [-1.5 * q / p, 3 * q / p]
                    } else {
                        if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                }
            }
            for (var i = 0; i < roots.length; i++) {
                roots[i] -= b / (3 * a)
            }
            return roots
        }

        function trunc(value) {
            return Math.trunc ? Math.trunc(value) : value > 0 ? Math.floor(value) : Math.ceil(value)
        }
        exports.sign = sign;
        exports.fitIntoRange = fitIntoRange;
        exports.inRange = inRange;
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent;
        exports.getRoot = getRoot;
        exports.solveCubicEquation = solveCubicEquation;
        exports.trunc = trunc
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/config.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _extend2 = _interopRequireDefault(_extend);
        var _errors = __webpack_require__( /*! ./errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            oDataFilterToLower: true,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useLegacyStoreResult: false,
            useJQuery: void 0,
            editorStylingMode: void 0,
            useLegacyVisibleIndex: false,
            floatingActionButtonConfig: {
                icon: "add",
                closeIcon: "close",
                label: "",
                position: {
                    at: "right bottom",
                    my: "right bottom",
                    offset: {
                        x: -16,
                        y: -16
                    }
                },
                maxSpeedDialActionCount: 5,
                shading: false,
                direction: "auto"
            },
            optionsParser: function(optionsString) {
                if ("{" !== optionsString.trim().charAt(0)) {
                    optionsString = "{" + optionsString + "}"
                }
                try {
                    return new Function("return " + optionsString)()
                } catch (ex) {
                    throw _errors2.default.Error("E3018", ex, optionsString)
                }
            }
        };
        var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
            deprecatedFields.forEach(function(deprecatedField) {
                if (newConfig[deprecatedField]) {
                    var message = "Now, the ".concat(deprecatedField, " is selected based on the specified locale.");
                    _errors2.default.log("W0003", "config", deprecatedField, "19.2", message)
                }
            });
            _extend2.default.extend(config, newConfig)
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        module.exports = configMethod
    }, ,
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/button.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _devices = __webpack_require__( /*! ../core/devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _utils = __webpack_require__( /*! ./widget/utils.ink_ripple */ 62);
        var _utils2 = _interopRequireDefault(_utils);
        var _component_registrator = __webpack_require__( /*! ../core/component_registrator */ 9);
        var _component_registrator2 = _interopRequireDefault(_component_registrator);
        var _themes = __webpack_require__( /*! ./themes */ 29);
        var _themes2 = _interopRequireDefault(_themes);
        var _action = __webpack_require__( /*! ../core/action */ 107);
        var _action2 = _interopRequireDefault(_action);
        var _validation_engine = __webpack_require__( /*! ./validation_engine */ 86);
        var _validation_engine2 = _interopRequireDefault(_validation_engine);
        var _ui = __webpack_require__( /*! ./widget/ui.widget */ 17);
        var _ui2 = _interopRequireDefault(_ui);
        var _short = __webpack_require__( /*! ../events/short */ 121);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _function_template = __webpack_require__( /*! ../core/templates/function_template */ 111);
        var _icon = __webpack_require__( /*! ../core/utils/icon */ 52);
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 11);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _get(target, property, receiver) {
            if ("undefined" !== typeof Reflect && Reflect.get) {
                _get = Reflect.get
            } else {
                _get = function(target, property, receiver) {
                    var base = _superPropBase(target, property);
                    if (!base) {
                        return
                    }
                    var desc = Object.getOwnPropertyDescriptor(base, property);
                    if (desc.get) {
                        return desc.get.call(receiver)
                    }
                    return desc.value
                }
            }
            return _get(target, property, receiver || target)
        }

        function _superPropBase(object, property) {
            while (!Object.prototype.hasOwnProperty.call(object, property)) {
                object = _getPrototypeOf(object);
                if (null === object) {
                    break
                }
            }
            return object
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var ANONYMOUS_TEMPLATE_NAME = "content";
        var Button = function(_Widget) {
            _inherits(Button, _Widget);
            var _super = _createSuper(Button);

            function Button() {
                var _this;
                _classCallCheck(this, Button);
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key]
                }
                _this = _super.call.apply(_super, [this].concat(args));
                _this._feedbackHideTimeout = 100;
                return _this
            }
            _createClass(Button, [{
                key: "_$content",
                value: function() {
                    return this.$element().find(".dx-button-content")
                }
            }, {
                key: "_$submitInput",
                value: function() {
                    return this.$element().find(".dx-button-submit-input")
                }
            }, {
                key: "_attachActiveEvents",
                value: function(active, inactive) {
                    var $el = this._eventBindingTarget();
                    var namespace = "inkRipple";
                    var selector = this._activeStateUnit;
                    _short.active.off($el, {
                        namespace: namespace,
                        selector: selector
                    });
                    _short.active.on($el, new _action2.default(active), new _action2.default(inactive, {
                        excludeValidators: ["disabled", "readOnly"]
                    }), {
                        showTimeout: this._feedbackShowTimeout,
                        hideTimeout: this._feedbackHideTimeout,
                        selector: selector,
                        namespace: namespace
                    })
                }
            }, {
                key: "_defaultOptionsRules",
                value: function() {
                    return _get(_getPrototypeOf(Button.prototype), "_defaultOptionsRules", this).call(this).concat([{
                        device: function() {
                            return "desktop" === _devices2.default.real().deviceType && !_devices2.default.isSimulator()
                        },
                        options: {
                            focusStateEnabled: true
                        }
                    }, {
                        device: function() {
                            return _themes2.default.isMaterial(_themes2.default.current())
                        },
                        options: {
                            useInkRipple: true
                        }
                    }])
                }
            }, {
                key: "_executeClickAction",
                value: function(event) {
                    this._clickAction({
                        validationGroup: this._validationGroupConfig,
                        event: event
                    })
                }
            }, {
                key: "_findGroup",
                value: function() {
                    var $element = this.$element();
                    var model = this._modelByElement($element);
                    var _this$option = this.option(),
                        validationGroup = _this$option.validationGroup;
                    return validationGroup || _validation_engine2.default.findGroup($element, model)
                }
            }, {
                key: "_getContentData",
                value: function() {
                    var _this$option2 = this.option(),
                        icon = _this$option2.icon,
                        text = _this$option2.text,
                        type = _this$option2.type,
                        _templateData = _this$option2._templateData;
                    return (0, _extend.extend)({
                        icon: "back" === type && !icon ? "back" : icon,
                        text: text
                    }, _templateData)
                }
            }, {
                key: "_getDefaultOptions",
                value: function() {
                    return (0, _extend.extend)(_get(_getPrototypeOf(Button.prototype), "_getDefaultOptions", this).call(this), {
                        hoverStateEnabled: true,
                        onClick: null,
                        type: "normal",
                        text: "",
                        icon: "",
                        iconPosition: "left",
                        validationGroup: void 0,
                        activeStateEnabled: true,
                        template: "content",
                        useSubmitBehavior: false,
                        useInkRipple: false,
                        _templateData: {},
                        stylingMode: "contained"
                    })
                }
            }, {
                key: "_getSubmitAction",
                value: function() {
                    var _this2 = this;
                    var needValidate = true;
                    var validationStatus = "valid";
                    return this._createAction(function(_ref) {
                        var event = _ref.event;
                        if (needValidate) {
                            var validationGroup = _this2._validationGroupConfig;
                            if (validationGroup) {
                                var _validationGroup$vali = validationGroup.validate(),
                                    status = _validationGroup$vali.status,
                                    complete = _validationGroup$vali.complete;
                                validationStatus = status;
                                if ("pending" === status) {
                                    needValidate = false;
                                    _this2.option("disabled", true);
                                    complete.then(function(_ref2) {
                                        var status = _ref2.status;
                                        _this2.option("disabled", false);
                                        validationStatus = status;
                                        "valid" === validationStatus && _this2._submitInput().click();
                                        needValidate = true
                                    })
                                }
                            }
                        }
                        "valid" !== validationStatus && event.preventDefault();
                        event.stopPropagation()
                    })
                }
            }, {
                key: "_initMarkup",
                value: function() {
                    this.$element().addClass("dx-button");
                    this._renderType();
                    this._renderStylingMode();
                    this._renderInkRipple();
                    this._renderClick();
                    this._updateAriaLabel();
                    _get(_getPrototypeOf(Button.prototype), "_initMarkup", this).call(this);
                    this._updateContent();
                    this.setAria("role", "button")
                }
            }, {
                key: "_getAnonymousTemplateName",
                value: function() {
                    return ANONYMOUS_TEMPLATE_NAME
                }
            }, {
                key: "_initTemplates",
                value: function() {
                    var _this3 = this;
                    this._templateManager.addDefaultTemplates({
                        content: new _function_template.FunctionTemplate(function(_ref3) {
                            var _ref3$model = _ref3.model,
                                model = void 0 === _ref3$model ? {} : _ref3$model,
                                container = _ref3.container;
                            var text = model.text,
                                icon = model.icon;
                            var _this3$option = _this3.option(),
                                iconPosition = _this3$option.iconPosition;
                            var $icon = (0, _icon.getImageContainer)(icon);
                            var $textContainer = text && (0, _renderer2.default)("<span>").text(text).addClass("dx-button-text");
                            var $container = (0, _renderer2.default)(container);
                            $container.append($textContainer);
                            if ("left" === iconPosition) {
                                $container.prepend($icon)
                            } else {
                                $icon.addClass("dx-icon-right");
                                $container.append($icon)
                            }
                        })
                    });
                    _get(_getPrototypeOf(Button.prototype), "_initTemplates", this).call(this)
                }
            }, {
                key: "_optionChanged",
                value: function(args) {
                    var name = args.name,
                        previousValue = args.previousValue;
                    switch (name) {
                        case "onClick":
                            this._updateClick();
                            break;
                        case "icon":
                        case "text":
                            this._updateContent();
                            this._updateAriaLabel();
                            break;
                        case "type":
                            this._updateType(previousValue);
                            this._updateContent();
                            break;
                        case "_templateData":
                            break;
                        case "template":
                        case "iconPosition":
                            this._updateContent();
                            break;
                        case "stylingMode":
                            this._updateStylingMode();
                            break;
                        case "useSubmitBehavior":
                            this._updateSubmitInput();
                            break;
                        case "useInkRipple":
                            this._invalidate();
                            break;
                        default:
                            _get(_getPrototypeOf(Button.prototype), "_optionChanged", this).call(this, args)
                    }
                }
            }, {
                key: "_renderClick",
                value: function() {
                    var _this4 = this;
                    var $el = this.$element();
                    _short.dxClick.off($el, {
                        namespace: this.NAME
                    });
                    _short.dxClick.on($el, function(event) {
                        return _this4._executeClickAction(event)
                    }, {
                        namespace: this.NAME
                    });
                    this._updateClick()
                }
            }, {
                key: "_renderInkRipple",
                value: function() {
                    var _this5 = this;
                    var _this$option3 = this.option(),
                        text = _this$option3.text,
                        icon = _this$option3.icon,
                        type = _this$option3.type,
                        useInkRipple = _this$option3.useInkRipple;
                    if (useInkRipple) {
                        var isOnlyIconButton = !text && icon || "back" === type;
                        var _inkRipple = _utils2.default.render(isOnlyIconButton ? {
                            waveSizeCoefficient: 1,
                            useHoldAnimation: false,
                            isCentered: true
                        } : {});
                        var changeWaveVisibility = function(event, visible) {
                            var _this5$option = _this5.option(),
                                activeStateEnabled = _this5$option.activeStateEnabled,
                                useInkRipple = _this5$option.useInkRipple;
                            if (useInkRipple && activeStateEnabled && !_this5._disposed) {
                                var config = {
                                    element: _this5._$content(),
                                    event: event
                                };
                                visible ? _inkRipple.showWave(config) : _inkRipple.hideWave(config)
                            }
                        };
                        this._attachActiveEvents(function(_ref4) {
                            var event = _ref4.event;
                            return changeWaveVisibility(event, true)
                        }, function(_ref5) {
                            var event = _ref5.event;
                            return changeWaveVisibility(event)
                        })
                    }
                }
            }, {
                key: "_renderStylingMode",
                value: function() {
                    var $element = this.$element();
                    var _this$option4 = this.option(),
                        stylingMode = _this$option4.stylingMode;
                    if (["contained", "text", "outlined"].indexOf(stylingMode) === -1) {
                        stylingMode = this._getDefaultOptions().stylingMode
                    }
                    $element.addClass("dx-button-mode-".concat(stylingMode))
                }
            }, {
                key: "_renderSubmitInput",
                value: function() {
                    var _this$option5 = this.option(),
                        useSubmitBehavior = _this$option5.useSubmitBehavior;
                    if (useSubmitBehavior) {
                        var submitAction = this._getSubmitAction();
                        var $content = this._$content();
                        (0, _renderer2.default)("<input>").attr("type", "submit").attr("tabindex", -1).addClass("dx-button-submit-input").appendTo($content);
                        _short.click.on(this._$submitInput(), function(event) {
                            return submitAction({
                                event: event
                            })
                        })
                    }
                }
            }, {
                key: "_renderType",
                value: function() {
                    var _this$option6 = this.option(),
                        type = _this$option6.type;
                    var $element = this.$element();
                    type && $element.addClass("dx-button-".concat(type))
                }
            }, {
                key: "_submitInput",
                value: function() {
                    return this._$submitInput().get(0)
                }
            }, {
                key: "_supportedKeys",
                value: function() {
                    var _this6 = this;
                    var click = function(e) {
                        e.preventDefault();
                        _this6._executeClickAction(e)
                    };
                    return (0, _extend.extend)(_get(_getPrototypeOf(Button.prototype), "_supportedKeys", this).call(this), {
                        space: click,
                        enter: click
                    })
                }
            }, {
                key: "_updateAriaLabel",
                value: function() {
                    var ariaTarget = this._getAriaTarget();
                    var _this$option7 = this.option(),
                        icon = _this$option7.icon,
                        text = _this$option7.text;
                    if (!text) {
                        if ("image" === (0, _icon.getImageSourceType)(icon)) {
                            icon = icon.indexOf("base64") === -1 ? icon.replace(/.+\/([^.]+)\..+$/, "$1") : "Base64"
                        }
                        text = icon || ""
                    }
                    ariaTarget.attr("aria-label", text || null)
                }
            }, {
                key: "_updateClick",
                value: function() {
                    var _this7 = this;
                    this._clickAction = this._createActionByOption("onClick", {
                        excludeValidators: ["readOnly"],
                        afterExecute: function() {
                            var _this7$option = _this7.option(),
                                useSubmitBehavior = _this7$option.useSubmitBehavior;
                            useSubmitBehavior && setTimeout(function() {
                                return _this7._submitInput().click()
                            })
                        }
                    })
                }
            }, {
                key: "_updateContent",
                value: function() {
                    var $element = this.$element();
                    var $content = this._$content();
                    var data = this._getContentData();
                    var _this$option8 = this.option(),
                        template = _this$option8.template,
                        iconPosition = _this$option8.iconPosition;
                    var icon = data.icon,
                        text = data.text;
                    $content.length ? $content.empty() : $content = (0, _renderer2.default)("<div>").addClass("dx-button-content").appendTo($element);
                    $element.toggleClass("dx-button-has-icon", !!icon).toggleClass("dx-button-icon-right", !!icon && "left" !== iconPosition).toggleClass("dx-button-has-text", !!text);
                    var $template = (0, _renderer2.default)(this._getTemplateByOption("template").render({
                        model: data,
                        container: (0, _dom.getPublicElement)($content),
                        transclude: this._templateManager.anonymousTemplateName === template
                    }));
                    if ($template.hasClass("dx-template-wrapper")) {
                        $template.addClass("dx-button-content");
                        $content.replaceWith($template)
                    }
                    this._updateSubmitInput()
                }
            }, {
                key: "_updateSubmitInput",
                value: function() {
                    var _this$option9 = this.option(),
                        useSubmitBehavior = _this$option9.useSubmitBehavior;
                    var $submitInput = this._$submitInput();
                    if (!useSubmitBehavior && $submitInput.length) {
                        $submitInput.remove()
                    } else {
                        if (useSubmitBehavior && !$submitInput.length) {
                            this._renderSubmitInput()
                        }
                    }
                }
            }, {
                key: "_updateStylingMode",
                value: function() {
                    var $element = this.$element();
                    ["contained", "text", "outlined"].map(function(mode) {
                        return "dx-button-mode-".concat(mode)
                    }).forEach($element.removeClass.bind($element));
                    this._renderStylingMode()
                }
            }, {
                key: "_updateType",
                value: function(previous) {
                    var $element = this.$element();
                    [previous, "back", "danger", "default", "normal", "success"].map(function(type) {
                        return "dx-button-".concat(type)
                    }).forEach($element.removeClass.bind($element));
                    this._renderType()
                }
            }, {
                key: "_validationGroupConfig",
                get: function() {
                    return _validation_engine2.default.getGroupConfig(this._findGroup())
                }
            }]);
            return Button
        }(_ui2.default);
        (0, _component_registrator2.default)("dxButton", Button);
        module.exports = Button
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/date.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _iterator2 = _interopRequireDefault(_iterator);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _errors = __webpack_require__( /*! ../core/errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _date = __webpack_require__( /*! ./ldml/date.formatter */ 275);
        var _date2 = __webpack_require__( /*! ./ldml/date.format */ 164);
        var _date3 = __webpack_require__( /*! ./ldml/date.parser */ 198);
        var _default_date_names = __webpack_require__( /*! ./default_date_names */ 276);
        var _default_date_names2 = _interopRequireDefault(_default_date_names);
        var _first_day_of_week_data = __webpack_require__( /*! ./cldr-data/first_day_of_week_data */ 459);
        var _first_day_of_week_data2 = _interopRequireDefault(_first_day_of_week_data);
        var _core = __webpack_require__( /*! ./core */ 91);
        var _number = __webpack_require__( /*! ./number */ 47);
        var _number2 = _interopRequireDefault(_number);
        var _date4 = __webpack_require__( /*! ./intl/date */ 460);
        var _date5 = _interopRequireDefault(_date4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_DAY_OF_WEEK_INDEX = 0;
        var hasIntl = "undefined" !== typeof Intl;
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format;
                var result = [];
                _iterator2.default.each(pattern.split(/\W+/), function(_, formatPart) {
                    _iterator2.default.each(possiblePartPatterns, function(partName, possiblePatterns) {
                        if ((0, _array.inArray)(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return _default_date_names2.default.getMonthNames(format)
            },
            getDayNames: function(format) {
                return _default_date_names2.default.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return _default_date_names2.default.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return _default_date_names2.default.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0);
                var pmTime = new Date(2017, 0, 20, 23, 0, 0, 0);
                var amTimeFormatted = this.format(amTime, format);
                var pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if ((0, _type.isString)(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return _number2.default.convertDigits((0, _date.getFormatter)(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var that = this;
                var ldmlFormat;
                var formatter;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return _number2.default.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = (0, _date2.getFormat)(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = _number2.default.convertDigits(text, true);
                    return (0, _date3.getParser)(ldmlFormat, this)(text)
                }
                _errors2.default.log("W0012");
                var result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                var index = (0, _core.getValueByClosestLocale)(function(locale) {
                    return _first_day_of_week_data2.default[locale]
                });
                return void 0 === index ? DEFAULT_DAY_OF_WEEK_INDEX : index
            }
        });
        if (hasIntl) {
            dateLocalization.inject(_date5.default)
        }
        module.exports = dateLocalization
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.modules.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _class = __webpack_require__( /*! ../../core/class */ 16);
        var _class2 = _interopRequireDefault(_class);
        var _callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 18);
        var _ui2 = _interopRequireDefault(_ui);
        var _message = __webpack_require__( /*! ../../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var WIDGET_WITH_LEGACY_CONTAINER_NAME = "dxDataGrid";
        var ModuleItem = _class2.default.inherit({
            _endUpdateCore: function() {},
            ctor: function(component) {
                var that = this;
                that._updateLockCount = 0;
                that.component = component;
                that._actions = {};
                that._actionConfigs = {};
                (0, _iterator.each)(this.callbackNames() || [], function(index, name) {
                    var flags = that.callbackFlags(name) || {};
                    flags.unique = true, flags.syncStrategy = true;
                    that[this] = (0, _callbacks2.default)(flags)
                })
            },
            init: function() {},
            callbackNames: function() {},
            callbackFlags: function() {},
            publicMethods: function() {},
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                if (this._updateLockCount > 0) {
                    this._updateLockCount--;
                    if (!this._updateLockCount) {
                        this._endUpdateCore()
                    }
                }
            },
            option: function(name) {
                var component = this.component;
                var optionCache = component._optionCache;
                if (1 === arguments.length && optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = component.option(name)
                    }
                    return optionCache[name]
                }
                return component.option.apply(component, arguments)
            },
            localize: function(name) {
                var optionCache = this.component._optionCache;
                if (optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = _message2.default.format(name)
                    }
                    return optionCache[name]
                }
                return _message2.default.format(name)
            },
            on: function() {
                return this.component.on.apply(this.component, arguments)
            },
            off: function() {
                return this.component.off.apply(this.component, arguments)
            },
            optionChanged: function(args) {
                if (args.name in this._actions) {
                    this.createAction(args.name, this._actionConfigs[args.name]);
                    args.handled = true
                }
            },
            getAction: function(actionName) {
                return this._actions[actionName]
            },
            setAria: function(name, value, $target) {
                var target = $target.get(0);
                var prefix = "role" !== name && "id" !== name ? "aria-" : "";
                if (target.setAttribute) {
                    target.setAttribute(prefix + name, value)
                } else {
                    $target.attr(prefix + name, value)
                }
            },
            _createComponent: function() {
                return this.component._createComponent.apply(this.component, arguments)
            },
            getController: function(name) {
                return this.component._controllers[name]
            },
            createAction: function(actionName, config) {
                if ((0, _type.isFunction)(actionName)) {
                    var action = this.component._createAction(actionName.bind(this), config);
                    return function(e) {
                        action({
                            event: e
                        })
                    }
                } else {
                    this._actions[actionName] = this.component._createActionByOption(actionName, config);
                    this._actionConfigs[actionName] = config
                }
            },
            executeAction: function(actionName, options) {
                var action = this._actions[actionName];
                return action && action(options)
            },
            dispose: function() {
                var that = this;
                (0, _iterator.each)(that.callbackNames() || [], function() {
                    that[this].empty()
                })
            },
            addWidgetPrefix: function(className) {
                var componentName = this.component.NAME;
                return "dx-" + componentName.slice(2).toLowerCase() + (className ? "-" + className : "")
            },
            getWidgetContainerClass: function() {
                var containerName = this.component.NAME === WIDGET_WITH_LEGACY_CONTAINER_NAME ? null : "container";
                return this.addWidgetPrefix(containerName)
            }
        });
        var Controller = ModuleItem;
        var ViewController = Controller.inherit({
            getView: function(name) {
                return this.component._views[name]
            },
            getViews: function() {
                return this.component._views
            }
        });
        var View = ModuleItem.inherit({
            _isReady: function() {
                return this.component.isReady()
            },
            _endUpdateCore: function() {
                this.callBase();
                if (!this._isReady() && this._requireReady) {
                    this._requireRender = false;
                    this.component._requireResize = false
                }
                if (this._requireRender) {
                    this._requireRender = false;
                    this.render(this._$parent)
                }
            },
            _invalidate: function(requireResize, requireReady) {
                this._requireRender = true;
                this.component._requireResize = (0, _window.hasWindow)() && (this.component._requireResize || requireResize);
                this._requireReady = this._requireReady || requireReady
            },
            _renderCore: function() {},
            _resizeCore: function() {},
            _afterRender: function() {},
            _parentElement: function() {
                return this._$parent
            },
            ctor: function(component) {
                this.callBase(component);
                this.renderCompleted = (0, _callbacks2.default)();
                this.resizeCompleted = (0, _callbacks2.default)()
            },
            element: function() {
                return this._$element
            },
            getElementHeight: function() {
                var $element = this.element();
                if (!$element) {
                    return 0
                }
                var marginTop = parseFloat($element.css("marginTop")) || 0;
                var marginBottom = parseFloat($element.css("marginBottom")) || 0;
                var offsetHeight = $element.get(0).offsetHeight;
                return offsetHeight + marginTop + marginBottom
            },
            isVisible: function() {
                return true
            },
            getTemplate: function(name) {
                return this.component._getTemplate(name)
            },
            render: function($parent, options) {
                var $element = this._$element;
                var isVisible = this.isVisible();
                if (!$element && !$parent) {
                    return
                }
                this._requireReady = false;
                if (!$element) {
                    $element = this._$element = (0, _renderer2.default)("<div>").appendTo($parent);
                    this._$parent = $parent
                }
                $element.toggleClass("dx-hidden", !isVisible);
                if (isVisible) {
                    this.component._optionCache = {};
                    this._renderCore(options);
                    this.component._optionCache = void 0;
                    this._afterRender($parent);
                    this.renderCompleted.fire(options)
                }
            },
            resize: function() {
                this.isResizing = true;
                this._resizeCore();
                this.resizeCompleted.fire();
                this.isResizing = false
            },
            focus: function() {
                _events_engine2.default.trigger(this.element(), "focus")
            }
        });
        var MODULES_ORDER_MAX_INDEX = 1e6;
        var processModules = function(that, componentClass) {
            var modules = componentClass.modules;
            var modulesOrder = componentClass.modulesOrder;
            var controllerTypes = componentClass.controllerTypes || {};
            var viewTypes = componentClass.viewTypes || {};
            if (!componentClass.controllerTypes) {
                if (modulesOrder) {
                    modules.sort(function(module1, module2) {
                        var orderIndex1 = (0, _array.inArray)(module1.name, modulesOrder);
                        var orderIndex2 = (0, _array.inArray)(module2.name, modulesOrder);
                        if (orderIndex1 < 0) {
                            orderIndex1 = MODULES_ORDER_MAX_INDEX
                        }
                        if (orderIndex2 < 0) {
                            orderIndex2 = MODULES_ORDER_MAX_INDEX
                        }
                        return orderIndex1 - orderIndex2
                    })
                }(0, _iterator.each)(modules, function() {
                    var controllers = this.controllers;
                    var moduleName = this.name;
                    var views = this.views;
                    controllers && (0, _iterator.each)(controllers, function(name, type) {
                        if (controllerTypes[name]) {
                            throw _ui2.default.Error("E1001", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(Controller))) {
                                type.subclassOf(Controller);
                                throw _ui2.default.Error("E1002", moduleName, name)
                            }
                        }
                        controllerTypes[name] = type
                    });
                    views && (0, _iterator.each)(views, function(name, type) {
                        if (viewTypes[name]) {
                            throw _ui2.default.Error("E1003", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(View))) {
                                throw _ui2.default.Error("E1004", moduleName, name)
                            }
                        }
                        viewTypes[name] = type
                    })
                });
                (0, _iterator.each)(modules, function() {
                    var extenders = this.extenders;
                    if (extenders) {
                        extenders.controllers && (0, _iterator.each)(extenders.controllers, function(name, extender) {
                            if (controllerTypes[name]) {
                                controllerTypes[name] = controllerTypes[name].inherit(extender)
                            }
                        });
                        extenders.views && (0, _iterator.each)(extenders.views, function(name, extender) {
                            if (viewTypes[name]) {
                                viewTypes[name] = viewTypes[name].inherit(extender)
                            }
                        })
                    }
                });
                componentClass.controllerTypes = controllerTypes;
                componentClass.viewTypes = viewTypes
            }
            var registerPublicMethods = function(that, name, moduleItem) {
                var publicMethods = moduleItem.publicMethods();
                if (publicMethods) {
                    (0, _iterator.each)(publicMethods, function(index, methodName) {
                        if (moduleItem[methodName]) {
                            if (!that[methodName]) {
                                that[methodName] = function() {
                                    return moduleItem[methodName].apply(moduleItem, arguments)
                                }
                            } else {
                                throw _ui2.default.Error("E1005", methodName)
                            }
                        } else {
                            throw _ui2.default.Error("E1006", name, methodName)
                        }
                    })
                }
            };
            var createModuleItems = function(moduleTypes) {
                var moduleItems = {};
                (0, _iterator.each)(moduleTypes, function(name, moduleType) {
                    var moduleItem = new moduleType(that);
                    moduleItem.name = name;
                    registerPublicMethods(that, name, moduleItem);
                    moduleItems[name] = moduleItem
                });
                return moduleItems
            };
            that._controllers = createModuleItems(controllerTypes);
            that._views = createModuleItems(viewTypes)
        };
        var callModuleItemsMethod = function(that, methodName, args) {
            args = args || [];
            if (that._controllers) {
                (0, _iterator.each)(that._controllers, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
            if (that._views) {
                (0, _iterator.each)(that._views, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
        };
        module.exports = {
            modules: [],
            View: View,
            ViewController: ViewController,
            Controller: Controller,
            registerModule: function(name, module) {
                var modules = this.modules;
                for (var i = 0; i < modules.length; i++) {
                    if (modules[i].name === name) {
                        return
                    }
                }
                module.name = name;
                modules.push(module);
                delete this.controllerTypes;
                delete this.viewTypes
            },
            registerModulesOrder: function(moduleNames) {
                this.modulesOrder = moduleNames
            },
            unregisterModule: function(name) {
                this.modules = (0, _common.grep)(this.modules, function(module) {
                    return module.name !== name
                });
                delete this.controllerTypes;
                delete this.viewTypes
            },
            processModules: processModules,
            callModuleItemsMethod: callModuleItemsMethod
        }
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/core/guid.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ./class */ 16);
        var Guid = Class.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        module.exports = Guid
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/inflector.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = __webpack_require__( /*! ./iterator */ 4).map;
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return map(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        var camelize = function(text, upperFirst) {
            return map(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        var titleize = function(text) {
            return map(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var captionList = [];
            var i;
            var char;
            var isPrevCharNewWord = false;
            var isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.dasherize = dasherize;
        exports.camelize = camelize;
        exports.humanize = humanize;
        exports.titleize = titleize;
        exports.underscore = underscore;
        exports.captionize = captionize
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/animation/fx.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var window = __webpack_require__( /*! ../core/utils/window */ 7).getWindow();
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var errors = __webpack_require__( /*! ../core/errors */ 23);
        var getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement;
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var typeUtils = __webpack_require__( /*! ../core/utils/type */ 1);
        var iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var translator = __webpack_require__( /*! ./translator */ 28);
        var easing = __webpack_require__( /*! ./easing */ 288);
        var animationFrame = __webpack_require__( /*! ./frame */ 122);
        var support = __webpack_require__( /*! ../core/utils/support */ 45);
        var positionUtils = __webpack_require__( /*! ./position */ 67);
        var removeEvent = __webpack_require__( /*! ../core/remove_event */ 141);
        var eventUtils = __webpack_require__( /*! ../events/utils */ 8);
        var deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var when = deferredUtils.when;
        var Deferred = deferredUtils.Deferred;
        var removeEventName = eventUtils.addNamespace(removeEvent, "dxFX");
        var isFunction = typeUtils.isFunction;
        var isPlainObject = typeUtils.isPlainObject;
        var noop = __webpack_require__( /*! ../core/utils/common */ 3).noop;
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
        var ANIM_DATA_KEY = "dxAnimData";
        var ANIM_QUEUE_KEY = "dxAnimQueue";
        var TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this;
                var deferred = new Deferred;
                var cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            when(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var that = this;
                var startTime = Date.now() + config.delay;
                var deferred = new Deferred;
                var transitionEndFired = new Deferred;
                var simulatedTransitionEndFired = new Deferred;
                var simulatedEndEventTimer;
                var transitionEndEventName = support.transitionEndEventName() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    eventsEngine.off($element, transitionEndEventName);
                    eventsEngine.off($element, removeEventName)
                };
                eventsEngine.one($element, transitionEndEventName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                var waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    when(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if (isPlainObject(config.to)) {
                        iteratorUtils.each(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new Deferred;
                var that = this;
                if (!config) {
                    return deferred.reject().promise()
                }
                iteratorUtils.each(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: easing.convertTransitionTimingFuncToEasing(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = extend({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = iteratorUtils.map(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return translator.getTranslateCss(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                iteratorUtils.each(transformString.match(/(\w|\d)+\([^)]*\)\s*/g), function(i, part) {
                    var translateData = translator.parseTranslate(part);
                    var scaleData = part.match(/scale\((.+?)\)/);
                    var rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                animationFrame.cancelAnimationFrame(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = animationFrame.requestAnimationFrame(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration;
                        var t = currentDuration;
                        var b = 1 * from[propName];
                        var c = to[propName] - from[propName];
                        var d = frameAnimation.duration;
                        return easing.getEasing(frameAnimation.easing)(x, t, b, c, d)
                    };
                    iteratorUtils.each(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === _typeof(endPropValue) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new Deferred).resolve().promise()
            },
            stop: noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: support.transition() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !support.transition()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            iteratorUtils.each(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw errors.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return isPlainObject(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = translator.locate($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = extend({
                        of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                translator.clearCache($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = translator.getTranslateCss({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var from = config.from;
                var fromOpacity = isPlainObject(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                var toOpacity;
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from;
                var to = config.to;
                var fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                var toOpacity = "opacity" in to ? to.opacity : 1;
                var fromScale = "scale" in from ? from.scale : 0;
                var toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = translator.getTranslate($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return translator.getTranslateCss(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw errors.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
            type: "custom",
            from: {},
            to: {},
            duration: 400,
            start: noop,
            complete: noop,
            easing: "ease",
            delay: 0
        };
        var defaultCssConfig = {
            duration: 400,
            easing: "ease",
            delay: 0
        };

        function setupAnimationOnElement() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = getPublicElement($element);
                config.start.apply(this, [element, config])
            }
        }
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element;
            var config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = getPublicElement($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this;
            var $element = animation.element;
            var config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = eventUtils.addNamespace(removeEvent, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            eventsEngine.off(animation.element, scopedRemoveEvent);
            eventsEngine.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                eventsEngine.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
            var config = extend(true, {}, defaultConfig, initialConfig);
            var configurator = getAnimationConfigurator(config);
            var strategy = getAnimationStrategy(config);
            var animation = {
                element: $(element),
                config: config,
                configurator: configurator,
                strategy: strategy,
                isSynchronous: strategy.isSynchronous,
                setup: setupAnimationOnElement,
                start: startAnimationOnElement,
                stop: stopAnimationOnElement,
                deferred: new Deferred
            };
            if (isFunction(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = $(element);
            if (!$element.length) {
                return (new Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };

        function pushInAnimationQueue($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        }

        function getAnimQueueData($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        }

        function writeAnimQueueData($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        }
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };

        function isAnimating($element) {
            return !!$element.data(ANIM_DATA_KEY)
        }

        function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        }

        function executeAnimation(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        }

        function setupPosition($element, config) {
            if (!config || !config.position) {
                return
            }
            var win = $(window);
            var left = 0;
            var top = 0;
            var position = positionUtils.calculate($element, config.position);
            var offset = $element.offset();
            var currentPosition = $element.position();
            if (currentPosition.top > offset.top) {
                top = win.scrollTop()
            }
            if (currentPosition.left > offset.left) {
                left = win.scrollLeft()
            }
            extend(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        }

        function setProps($element, props) {
            iteratorUtils.each(props, function(key, value) {
                try {
                    $element.css(key, typeUtils.isFunction(value) ? value() : value)
                } catch (e) {}
            })
        }
        var stop = function(element, jumpToEnd) {
            var $element = $(element);
            var queueData = getAnimQueueData($element);
            iteratorUtils.each(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        module.exports = fx
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 148);
        var coreErrors = __webpack_require__( /*! ../core/errors */ 23);
        var handlers = {};
        var errors = errorUtils(coreErrors.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with the a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });

        function handleError(error) {
            var id = "E4000";
            if (error && "__id" in error) {
                id = error.__id
            }
            errors.log(id, error)
        }
        var errorHandler = null;
        var _errorHandler = function(error) {
            handleError(error);
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        module.exports = handlers
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/string.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        var splitQuad = function(raw) {
            switch (_typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var quadToObject = function(raw) {
            var quad = splitQuad(raw);
            var left = parseInt(quad && quad[0], 10);
            var top = parseInt(quad && quad[1], 10);
            var right = parseInt(quad && quad[2], 10);
            var bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        var stringFormat = function() {
            var s = arguments[0];
            var values = [].slice.call(arguments).slice(1);
            var replaceDollarCount;
            var reg;
            var value;
            if (typeUtils.isFunction(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === typeUtils.type(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.encodeHtml = encodeHtml;
        exports.quadToObject = quadToObject;
        exports.format = stringFormat;
        exports.replaceAll = replaceAll;
        exports.isEmpty = isEmpty
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/utils.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _dom_adapter = __webpack_require__( /*! ../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _ready_callbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 54);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var _common = __webpack_require__( /*! ../core/utils/common */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return (0, _iterator.map)(info, function(i) {
                var result = {
                    selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var textStatusDetails = {
                timeout: "possible causes: the remote host is not accessible, overloaded or is not included into the domain white-list when being run in the native container",
                error: "if the remote host is located on another domain, make sure it properly supports cross-origin resource sharing (CORS), or use the JSONP approach instead",
                parsererror: "the remote host did not respond with valid JSON data"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                result += " (" + textStatusDetails[textStatus] + ")";
                return result
            };
            var unloading;
            (0, _ready_callbacks.add)(function() {
                var window = (0, _window.getWindow)();
                _dom_adapter2.default.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockCount = 0;
            var lockDeferred;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new _deferred.Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|&&|&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var names = (0, _iterator.map)(key1, function(v, k) {
                    return k
                });
                var name;
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if (!(0, _common.equalByValue)(key1[name], key2[name], 0, false)) {
                        return false
                    }
                }
                return true
            }
            return (0, _common.equalByValue)(key1, key2, 0, false)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i];
                var octet2 = input[i + 1];
                var octet3 = input[i + 2];
                result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };

        function stringToByteArray(str) {
            var bytes = [];
            var code;
            var i;
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        }
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var isGroupOperator = function(value) {
            return "and" === value || "or" === value
        };
        var isGroupCriterion = function(crit) {
            var first = crit[0];
            var second = crit[1];
            if (Array.isArray(first)) {
                return true
            }
            if (_type2.default.isFunction(first)) {
                if (Array.isArray(second) || _type2.default.isFunction(second) || isGroupOperator(second)) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new _deferred.Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new _deferred.Deferred;
            return d.reject.apply(d, arguments).promise()
        };

        function throttle(func, timeout) {
            var timeoutId;
            var lastArgs;
            return function() {
                var _this = this;
                lastArgs = arguments;
                if (!timeoutId) {
                    timeoutId = setTimeout(function() {
                        timeoutId = void 0;
                        if (lastArgs) {
                            func.call(_this, lastArgs)
                        }
                    }, (0, _type.isFunction)(timeout) ? timeout() : timeout)
                }
                return timeoutId
            }
        }

        function throttleChanges(func, timeout) {
            var cache = [];
            var throttled = throttle(function() {
                func.call(this, cache);
                cache = []
            }, timeout);
            return function(changes) {
                if (Array.isArray(changes)) {
                    var _cache;
                    (_cache = cache).push.apply(_cache, _toConsumableArray(changes))
                }
                return throttled.call(this, cache)
            }
        }
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            throttleChanges: throttleChanges,
            trivialPromise: trivialPromise,
            rejectedPromise: rejectedPromise,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            isGroupCriterion: isGroupCriterion,
            base64_encode: base64_encode
        };
        module.exports = utils
    },
    /*!******************************************!*\
      !*** ./artifacts/transpiled/ui/popup.js ***!
      \******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _translator = __webpack_require__( /*! ../animation/translator */ 28);
        var _translator2 = _interopRequireDefault(_translator);
        var _component_registrator = __webpack_require__( /*! ../core/component_registrator */ 9);
        var _component_registrator2 = _interopRequireDefault(_component_registrator);
        var _devices = __webpack_require__( /*! ../core/devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 11);
        var _dom2 = _interopRequireDefault(_dom);
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _empty_template = __webpack_require__( /*! ../core/templates/empty_template */ 87);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _browser = __webpack_require__( /*! ../core/utils/browser */ 25);
        var _browser2 = _interopRequireDefault(_browser);
        var _common = __webpack_require__( /*! ../core/utils/common */ 3);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 38);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _size = __webpack_require__( /*! ../core/utils/size */ 178);
        var _size2 = _interopRequireDefault(_size);
        var _position = __webpack_require__( /*! ../core/utils/position */ 22);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _version = __webpack_require__( /*! ../core/utils/version */ 61);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _message = __webpack_require__( /*! ../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _button = __webpack_require__( /*! ./button */ 34);
        var _button2 = _interopRequireDefault(_button);
        var _overlay = __webpack_require__( /*! ./overlay */ 55);
        var _overlay2 = _interopRequireDefault(_overlay);
        var _themes = __webpack_require__( /*! ./themes */ 29);
        var _themes2 = _interopRequireDefault(_themes);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var window = _window2.default.getWindow();
        __webpack_require__( /*! ./toolbar/ui.toolbar.base */ 302);
        var POPUP_CLASS = "dx-popup";
        var POPUP_WRAPPER_CLASS = "dx-popup-wrapper";
        var POPUP_FULL_SCREEN_CLASS = "dx-popup-fullscreen";
        var POPUP_FULL_SCREEN_WIDTH_CLASS = "dx-popup-fullscreen-width";
        var POPUP_NORMAL_CLASS = "dx-popup-normal";
        var POPUP_CONTENT_CLASS = "dx-popup-content";
        var POPUP_DRAGGABLE_CLASS = "dx-popup-draggable";
        var POPUP_TITLE_CLASS = "dx-popup-title";
        var POPUP_TITLE_CLOSEBUTTON_CLASS = "dx-closebutton";
        var POPUP_BOTTOM_CLASS = "dx-popup-bottom";
        var TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper";
        var POPUP_CONTENT_FLEX_HEIGHT_CLASS = "dx-popup-flex-height";
        var POPUP_CONTENT_INHERIT_HEIGHT_CLASS = "dx-popup-inherit-height";
        var ALLOWED_TOOLBAR_ITEM_ALIASES = ["cancel", "clear", "done"];
        var BUTTON_DEFAULT_TYPE = "default";
        var BUTTON_NORMAL_TYPE = "normal";
        var BUTTON_TEXT_MODE = "text";
        var BUTTON_CONTAINED_MODE = "contained";
        var IS_IE11 = _browser2.default.msie && 11 === parseInt(_browser2.default.version);
        var IS_OLD_SAFARI = _browser2.default.safari && (0, _version.compare)(_browser2.default.version, [11]) < 0;
        var HEIGHT_STRATEGIES = {
            "static": "",
            inherit: POPUP_CONTENT_INHERIT_HEIGHT_CLASS,
            flex: POPUP_CONTENT_FLEX_HEIGHT_CLASS
        };
        var getButtonPlace = function(name) {
            var device = _devices2.default.current();
            var platform = device.platform;
            var toolbar = "bottom";
            var location = "before";
            if ("ios" === platform) {
                switch (name) {
                    case "cancel":
                        toolbar = "top";
                        break;
                    case "clear":
                        toolbar = "top";
                        location = "after";
                        break;
                    case "done":
                        location = "after"
                }
            } else {
                if ("android" === platform && device.version && parseInt(device.version[0]) > 4) {
                    switch (name) {
                        case "cancel":
                            location = "after";
                            break;
                        case "done":
                            location = "after"
                    }
                } else {
                    if ("android" === platform) {
                        location = "center"
                    }
                }
            }
            return {
                toolbar: toolbar,
                location: location
            }
        };
        var Popup = _overlay2.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    fullScreen: false,
                    title: "",
                    showTitle: true,
                    titleTemplate: "title",
                    onTitleRendered: null,
                    dragEnabled: false,
                    toolbarItems: [],
                    showCloseButton: false,
                    bottomTemplate: "bottom",
                    useDefaultToolbarButtons: false,
                    useFlatToolbarButtons: false,
                    autoResizeEnabled: true
                })
            },
            _defaultOptionsRules: function() {
                var themeName = _themes2.default.current();
                return this.callBase().concat([{
                    device: {
                        platform: "ios"
                    },
                    options: {
                        animation: this._iosAnimation
                    }
                }, {
                    device: {
                        platform: "android"
                    },
                    options: {
                        animation: this._androidAnimation
                    }
                }, {
                    device: {
                        platform: "generic"
                    },
                    options: {
                        showCloseButton: true
                    }
                }, {
                    device: function(_device) {
                        return "desktop" === _devices2.default.real().deviceType && "generic" === _device.platform
                    },
                    options: {
                        dragEnabled: true
                    }
                }, {
                    device: function() {
                        return "desktop" === _devices2.default.real().deviceType && !_devices2.default.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return _themes2.default.isMaterial(themeName)
                    },
                    options: {
                        useDefaultToolbarButtons: true,
                        useFlatToolbarButtons: true
                    }
                }])
            },
            _iosAnimation: {
                show: {
                    type: "slide",
                    duration: 400,
                    from: {
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    },
                    to: {
                        position: {
                            my: "center",
                            at: "center"
                        }
                    }
                },
                hide: {
                    type: "slide",
                    duration: 400,
                    from: {
                        opacity: 1,
                        position: {
                            my: "center",
                            at: "center"
                        }
                    },
                    to: {
                        opacity: 1,
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    }
                }
            },
            _androidAnimation: function() {
                var fullScreenConfig = {
                    show: {
                        type: "slide",
                        duration: 300,
                        from: {
                            top: "30%",
                            opacity: 0
                        },
                        to: {
                            top: 0,
                            opacity: 1
                        }
                    },
                    hide: {
                        type: "slide",
                        duration: 300,
                        from: {
                            top: 0,
                            opacity: 1
                        },
                        to: {
                            top: "30%",
                            opacity: 0
                        }
                    }
                };
                var defaultConfig = {
                    show: {
                        type: "fade",
                        duration: 400,
                        from: 0,
                        to: 1
                    },
                    hide: {
                        type: "fade",
                        duration: 400,
                        from: 1,
                        to: 0
                    }
                };
                return this.option("fullScreen") ? fullScreenConfig : defaultConfig
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(POPUP_CLASS);
                this._wrapper().addClass(POPUP_WRAPPER_CLASS);
                this._$popupContent = this._$content.wrapInner((0, _renderer2.default)("<div>").addClass(POPUP_CONTENT_CLASS)).children().eq(0)
            },
            _render: function() {
                var isFullscreen = this.option("fullScreen");
                this._toggleFullScreenClass(isFullscreen);
                this.callBase()
            },
            _toggleFullScreenClass: function(value) {
                this._$content.toggleClass(POPUP_FULL_SCREEN_CLASS, value).toggleClass(POPUP_NORMAL_CLASS, !value)
            },
            _initTemplates: function() {
                this.callBase();
                this._templateManager.addDefaultTemplates({
                    title: new _empty_template.EmptyTemplate,
                    bottom: new _empty_template.EmptyTemplate
                })
            },
            _renderContentImpl: function() {
                this._renderTitle();
                this.callBase();
                this._renderBottom()
            },
            _renderTitle: function() {
                var items = this._getToolbarItems("top");
                var titleText = this.option("title");
                var showTitle = this.option("showTitle");
                if (showTitle && !!titleText) {
                    items.unshift({
                        location: _devices2.default.current().ios ? "center" : "before",
                        text: titleText
                    })
                }
                if (showTitle || items.length > 0) {
                    this._$title && this._$title.remove();
                    var $title = (0, _renderer2.default)("<div>").addClass(POPUP_TITLE_CLASS).insertBefore(this.$content());
                    this._$title = this._renderTemplateByType("titleTemplate", items, $title).addClass(POPUP_TITLE_CLASS);
                    this._renderDrag();
                    this._executeTitleRenderAction(this._$title)
                } else {
                    if (this._$title) {
                        this._$title.detach()
                    }
                }
            },
            _renderTemplateByType: function(optionName, data, $container, additionalToolbarOptions) {
                var template = this._getTemplateByOption(optionName);
                var toolbarTemplate = template instanceof _empty_template.EmptyTemplate;
                if (toolbarTemplate) {
                    var integrationOptions = (0, _extend.extend)({}, this.option("integrationOptions"), {
                        skipTemplates: ["content", "title"]
                    });
                    var toolbarOptions = (0, _extend.extend)(additionalToolbarOptions, {
                        items: data,
                        rtlEnabled: this.option("rtlEnabled"),
                        useDefaultButtons: this.option("useDefaultToolbarButtons"),
                        useFlatButtons: this.option("useFlatToolbarButtons"),
                        integrationOptions: integrationOptions
                    });
                    this._getTemplate("dx-polymorph-widget").render({
                        container: $container,
                        model: {
                            widget: "dxToolbarBase",
                            options: toolbarOptions
                        }
                    });
                    var $toolbar = $container.children("div");
                    $container.replaceWith($toolbar);
                    return $toolbar
                } else {
                    var $result = (0, _renderer2.default)(template.render({
                        container: (0, _dom.getPublicElement)($container)
                    }));
                    if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                        $container.replaceWith($result);
                        $container = $result
                    }
                    return $container
                }
            },
            _executeTitleRenderAction: function($titleElement) {
                this._getTitleRenderAction()({
                    titleElement: (0, _dom.getPublicElement)($titleElement)
                })
            },
            _getTitleRenderAction: function() {
                return this._titleRenderAction || this._createTitleRenderAction()
            },
            _createTitleRenderAction: function() {
                return this._titleRenderAction = this._createActionByOption("onTitleRendered", {
                    element: this.element(),
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _getCloseButton: function() {
                return {
                    toolbar: "top",
                    location: "after",
                    template: this._getCloseButtonRenderer()
                }
            },
            _getCloseButtonRenderer: function() {
                return function(_, __, container) {
                    var $button = (0, _renderer2.default)("<div>").addClass(POPUP_TITLE_CLOSEBUTTON_CLASS);
                    this._createComponent($button, _button2.default, {
                        icon: "close",
                        onClick: this._createToolbarItemAction(void 0),
                        integrationOptions: {}
                    });
                    (0, _renderer2.default)(container).append($button)
                }.bind(this)
            },
            _getToolbarItems: function(toolbar) {
                var toolbarItems = this.option("toolbarItems");
                var toolbarsItems = [];
                this._toolbarItemClasses = [];
                var currentPlatform = _devices2.default.current().platform;
                var index = 0;
                (0, _iterator.each)(toolbarItems, function(_, data) {
                    var isShortcut = (0, _type.isDefined)(data.shortcut);
                    var item = isShortcut ? getButtonPlace(data.shortcut) : data;
                    if (isShortcut && "ios" === currentPlatform && index < 2) {
                        item.toolbar = "top";
                        index++
                    }
                    item.toolbar = data.toolbar || item.toolbar || "top";
                    if (item && item.toolbar === toolbar) {
                        if (isShortcut) {
                            (0, _extend.extend)(item, {
                                location: data.location
                            }, this._getToolbarItemByAlias(data))
                        }
                        var isLTROrder = "generic" === currentPlatform;
                        if ("done" === data.shortcut && isLTROrder || "cancel" === data.shortcut && !isLTROrder) {
                            toolbarsItems.unshift(item)
                        } else {
                            toolbarsItems.push(item)
                        }
                    }
                }.bind(this));
                if ("top" === toolbar && this.option("showCloseButton") && this.option("showTitle")) {
                    toolbarsItems.push(this._getCloseButton())
                }
                return toolbarsItems
            },
            _getLocalizationKey: function(itemType) {
                return "done" === itemType.toLowerCase() ? "OK" : (0, _inflector.camelize)(itemType, true)
            },
            _getToolbarItemByAlias: function(data) {
                var that = this;
                var itemType = data.shortcut;
                if ((0, _array.inArray)(itemType, ALLOWED_TOOLBAR_ITEM_ALIASES) < 0) {
                    return false
                }
                var itemConfig = (0, _extend.extend)({
                    text: _message2.default.format(this._getLocalizationKey(itemType)),
                    onClick: this._createToolbarItemAction(data.onClick),
                    integrationOptions: {},
                    type: that.option("useDefaultToolbarButtons") ? BUTTON_DEFAULT_TYPE : BUTTON_NORMAL_TYPE,
                    stylingMode: that.option("useFlatToolbarButtons") ? BUTTON_TEXT_MODE : BUTTON_CONTAINED_MODE
                }, data.options || {});
                var itemClass = POPUP_CLASS + "-" + itemType;
                this._toolbarItemClasses.push(itemClass);
                return {
                    template: function(_, __, container) {
                        var $toolbarItem = (0, _renderer2.default)("<div>").addClass(itemClass).appendTo(container);
                        that._createComponent($toolbarItem, _button2.default, itemConfig)
                    }
                }
            },
            _createToolbarItemAction: function(clickAction) {
                return this._createAction(clickAction, {
                    afterExecute: function(e) {
                        e.component.hide()
                    }
                })
            },
            _renderBottom: function() {
                var items = this._getToolbarItems("bottom");
                if (items.length) {
                    this._$bottom && this._$bottom.remove();
                    var $bottom = (0, _renderer2.default)("<div>").addClass(POPUP_BOTTOM_CLASS).insertAfter(this.$content());
                    this._$bottom = this._renderTemplateByType("bottomTemplate", items, $bottom, {
                        compactMode: true
                    }).addClass(POPUP_BOTTOM_CLASS);
                    this._toggleClasses()
                } else {
                    this._$bottom && this._$bottom.detach()
                }
            },
            _toggleClasses: function() {
                var aliases = ALLOWED_TOOLBAR_ITEM_ALIASES;
                (0, _iterator.each)(aliases, function(_, alias) {
                    var className = POPUP_CLASS + "-" + alias;
                    if ((0, _array.inArray)(className, this._toolbarItemClasses) >= 0) {
                        this._wrapper().addClass(className + "-visible");
                        this._$bottom.addClass(className)
                    } else {
                        this._wrapper().removeClass(className + "-visible");
                        this._$bottom.removeClass(className)
                    }
                }.bind(this))
            },
            _getContainer: function() {
                if (this.option("fullScreen")) {
                    return (0, _renderer2.default)(window)
                }
                return this.callBase()
            },
            _getDragTarget: function() {
                return this.topToolbar()
            },
            _renderGeometryImpl: function(isDimensionChanged) {
                if (!isDimensionChanged) {
                    this._resetContentHeight()
                }
                this.callBase.apply(this, arguments);
                this._setContentHeight()
            },
            _resetContentHeight: function() {
                this._$popupContent.css({
                    height: "auto",
                    maxHeight: "none"
                })
            },
            _renderDrag: function() {
                this.callBase();
                this._$content.toggleClass(POPUP_DRAGGABLE_CLASS, this.option("dragEnabled"))
            },
            _renderResize: function() {
                this.callBase();
                this._resizable.option("onResize", function() {
                    this._setContentHeight();
                    this._actions.onResize(arguments)
                }.bind(this))
            },
            _setContentHeight: function() {
                (this.option("forceApplyBindings") || _common.noop)();
                var overlayContent = this.overlayContent().get(0);
                var currentHeightStrategyClass = this._chooseHeightStrategy(overlayContent);
                this.$content().css(this._getHeightCssStyles(currentHeightStrategyClass, overlayContent));
                this._setHeightClasses(this.overlayContent(), currentHeightStrategyClass)
            },
            _heightStrategyChangeOffset: function(currentHeightStrategyClass, popupVerticalPaddings) {
                return currentHeightStrategyClass === HEIGHT_STRATEGIES.flex ? -popupVerticalPaddings : 0
            },
            _chooseHeightStrategy: function(overlayContent) {
                var isAutoWidth = "auto" === overlayContent.style.width || "" === overlayContent.style.width;
                var currentHeightStrategyClass = HEIGHT_STRATEGIES.static;
                if (this._isAutoHeight() && this.option("autoResizeEnabled")) {
                    if (isAutoWidth || IS_OLD_SAFARI) {
                        if (!IS_IE11) {
                            currentHeightStrategyClass = HEIGHT_STRATEGIES.inherit
                        }
                    } else {
                        currentHeightStrategyClass = HEIGHT_STRATEGIES.flex
                    }
                }
                return currentHeightStrategyClass
            },
            _getHeightCssStyles: function(currentHeightStrategyClass, overlayContent) {
                var cssStyles = {};
                var contentMaxHeight = this._getOptionValue("maxHeight", overlayContent);
                var contentMinHeight = this._getOptionValue("minHeight", overlayContent);
                var popupHeightParts = this._splitPopupHeight();
                var toolbarsAndVerticalOffsetsHeight = popupHeightParts.header + popupHeightParts.footer + popupHeightParts.contentVerticalOffsets + popupHeightParts.popupVerticalOffsets + this._heightStrategyChangeOffset(currentHeightStrategyClass, popupHeightParts.popupVerticalPaddings);
                if (currentHeightStrategyClass === HEIGHT_STRATEGIES.static) {
                    if (!this._isAutoHeight() || contentMaxHeight || contentMinHeight) {
                        var overlayHeight = this.option("fullScreen") ? Math.min((0, _position.getBoundingRect)(overlayContent).height, _window2.default.getWindow().innerHeight) : (0, _position.getBoundingRect)(overlayContent).height;
                        var contentHeight = overlayHeight - toolbarsAndVerticalOffsetsHeight;
                        cssStyles = {
                            height: Math.max(0, contentHeight),
                            minHeight: "auto",
                            maxHeight: "auto"
                        }
                    }
                } else {
                    var container = (0, _renderer2.default)(this._getContainer()).get(0);
                    var maxHeightValue = _size2.default.addOffsetToMaxHeight(contentMaxHeight, -toolbarsAndVerticalOffsetsHeight, container);
                    var minHeightValue = _size2.default.addOffsetToMinHeight(contentMinHeight, -toolbarsAndVerticalOffsetsHeight, container);
                    cssStyles = {
                        height: "auto",
                        minHeight: minHeightValue,
                        maxHeight: maxHeightValue
                    }
                }
                return cssStyles
            },
            _setHeightClasses: function($container, currentClass) {
                var excessClasses = "";
                for (var name in HEIGHT_STRATEGIES) {
                    if (HEIGHT_STRATEGIES[name] !== currentClass) {
                        excessClasses += " " + HEIGHT_STRATEGIES[name]
                    }
                }
                $container.removeClass(excessClasses).addClass(currentClass)
            },
            _isAutoHeight: function() {
                return "auto" === this.overlayContent().get(0).style.height
            },
            _splitPopupHeight: function() {
                var topToolbar = this.topToolbar();
                var bottomToolbar = this.bottomToolbar();
                return {
                    header: _size2.default.getVisibleHeight(topToolbar && topToolbar.get(0)),
                    footer: _size2.default.getVisibleHeight(bottomToolbar && bottomToolbar.get(0)),
                    contentVerticalOffsets: _size2.default.getVerticalOffsets(this.overlayContent().get(0), true),
                    popupVerticalOffsets: _size2.default.getVerticalOffsets(this.$content().get(0), true),
                    popupVerticalPaddings: _size2.default.getVerticalOffsets(this.$content().get(0), false)
                }
            },
            _useFixedPosition: function() {
                return this.callBase() || this.option("fullScreen")
            },
            _toggleSafariFullScreen: function(value) {
                var toggleFullScreenBeforeShown = this._useFixedPosition() && value && !this._isShown;
                if (toggleFullScreenBeforeShown) {
                    this._bodyScrollTop = value ? window.pageYOffset : void 0
                } else {
                    this._toggleSafariScrolling(!value)
                }
            },
            _renderDimensions: function() {
                if (this.option("fullScreen")) {
                    this._$content.css({
                        width: "100%",
                        height: "100%"
                    })
                } else {
                    this.callBase.apply(this, arguments)
                }
                if (_window2.default.hasWindow()) {
                    this._renderFullscreenWidthClass()
                }
            },
            _renderFullscreenWidthClass: function() {
                this.overlayContent().toggleClass(POPUP_FULL_SCREEN_WIDTH_CLASS, this.overlayContent().outerWidth() === (0, _renderer2.default)(window).width())
            },
            refreshPosition: function() {
                this._renderPosition()
            },
            _renderPosition: function() {
                if (this.option("fullScreen")) {
                    _translator2.default.move(this._$content, {
                        top: 0,
                        left: 0
                    })
                } else {
                    (this.option("forceApplyBindings") || _common.noop)();
                    return this.callBase.apply(this, arguments)
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "showTitle":
                    case "title":
                    case "titleTemplate":
                        this._renderTitle();
                        this._renderGeometry();
                        break;
                    case "bottomTemplate":
                        this._renderBottom();
                        this._renderGeometry();
                        break;
                    case "onTitleRendered":
                        this._createTitleRenderAction(args.value);
                        break;
                    case "toolbarItems":
                    case "useDefaultToolbarButtons":
                    case "useFlatToolbarButtons":
                        var shouldRenderGeometry = !args.fullName.match(/^toolbarItems((\[\d+\])(\.(options|visible).*)?)?$/);
                        this._renderTitle();
                        this._renderBottom();
                        if (shouldRenderGeometry) {
                            this._renderGeometry()
                        }
                        break;
                    case "dragEnabled":
                        this._renderDrag();
                        break;
                    case "autoResizeEnabled":
                        this._renderGeometry();
                        _dom2.default.triggerResizeEvent(this._$content);
                        break;
                    case "fullScreen":
                        this._toggleFullScreenClass(args.value);
                        this._toggleSafariFullScreen(args.value);
                        this._renderGeometry();
                        _dom2.default.triggerResizeEvent(this._$content);
                        break;
                    case "showCloseButton":
                        this._renderTitle();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            bottomToolbar: function() {
                return this._$bottom
            },
            topToolbar: function() {
                return this._$title
            },
            $content: function() {
                return this._$popupContent
            },
            content: function() {
                return (0, _dom.getPublicElement)(this._$popupContent)
            },
            overlayContent: function() {
                return this._$content
            }
        });
        (0, _component_registrator2.default)("dxPopup", Popup);
        module.exports = Popup
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/element_data.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _weak_map = __webpack_require__( /*! ./polyfills/weak_map */ 196);
        var _weak_map2 = _interopRequireDefault(_weak_map);
        var _dom_adapter = __webpack_require__( /*! ./dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _events_engine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _memorized_callbacks = __webpack_require__( /*! ./memorized_callbacks */ 197);
        var _memorized_callbacks2 = _interopRequireDefault(_memorized_callbacks);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var dataMap = new _weak_map2.default;
        var strategy;
        var strategyChanging = new _memorized_callbacks2.default;
        var beforeCleanData = function() {};
        var afterCleanData = function() {};
        var setDataStrategy = exports.setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanData(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanData(nodes);
                return result
            }
        };
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    _events_engine2.default.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });
        exports.setDataStrategy = setDataStrategy;
        exports.getDataStrategy = function() {
            return strategy
        };
        exports.data = function() {
            return strategy.data.apply(this, arguments)
        };
        exports.strategyChanging = strategyChanging;
        exports.beforeCleanData = function(callback) {
            beforeCleanData = callback
        };
        exports.afterCleanData = function(callback) {
            afterCleanData = callback
        };
        exports.cleanData = function(nodes) {
            return strategy.cleanData.call(this, nodes)
        };
        exports.removeData = function(element, key) {
            return strategy.removeData.call(this, element, key)
        };
        exports.cleanDataRecursive = function(element, cleanSelf) {
            if (!_dom_adapter2.default.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/support.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _array = __webpack_require__( /*! ./array */ 13);
        var _dom_adapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var _common = __webpack_require__( /*! ./common */ 3);
        var _call_once = __webpack_require__( /*! ./call_once */ 82);
        var _call_once2 = _interopRequireDefault(_call_once);
        var _window = __webpack_require__( /*! ./window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _devices = __webpack_require__( /*! ../devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _style = __webpack_require__( /*! ./style */ 90);
        var _style2 = _interopRequireDefault(_style);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _windowUtils$getNavig = _window2.default.getNavigator(),
            maxTouchPoints = _windowUtils$getNavig.maxTouchPoints,
            msMaxTouchPoints = _windowUtils$getNavig.msMaxTouchPoints,
            pointerEnabled = _windowUtils$getNavig.pointerEnabled;
        var hasProperty = _window2.default.hasProperty.bind(_window2.default);
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!_style2.default.styleProp(prop)
        };
        var isNativeScrollingSupported = function() {
            var _devices$real = _devices2.default.real(),
                platform = _devices$real.platform,
                version = _devices$real.version,
                isMac = _devices$real.mac;
            var isObsoleteAndroid = version && version[0] < 4 && "android" === platform;
            var isNativeScrollDevice = !isObsoleteAndroid && (0, _array.inArray)(platform, ["ios", "android"]) > -1 || isMac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = (0, _dom_adapter.createElement)("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        var detectTouchEvents = function(hasWindowProperty, maxTouchPoints) {
            return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
        };
        var detectPointerEvent = function(hasWindowProperty, pointerEnabled) {
            var isPointerEnabled = (0, _common.ensureDefined)(pointerEnabled, true);
            var canUsePointerEvent = (0, _common.ensureDefined)(pointerEnabled, false);
            return hasWindowProperty("PointerEvent") && isPointerEnabled || canUsePointerEvent
        };
        var touchEvents = detectTouchEvents(hasProperty, maxTouchPoints);
        var pointerEvents = detectPointerEvent(hasProperty, pointerEnabled);
        var touchPointersPresent = !!maxTouchPoints || !!msMaxTouchPoints;
        exports.detectTouchEvents = detectTouchEvents;
        exports.detectPointerEvent = detectPointerEvent;
        exports.touchEvents = touchEvents;
        exports.pointerEvents = pointerEvents;
        exports.touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.transition = (0, _call_once2.default)(function() {
            return supportProp("transition")
        });
        exports.transitionEndEventName = (0, _call_once2.default)(function() {
            return transitionEndEventNames[_style2.default.styleProp("transition")]
        });
        exports.animation = (0, _call_once2.default)(function() {
            return supportProp("animation")
        });
        exports.nativeScrolling = isNativeScrollingSupported();
        exports.styleProp = _style2.default.styleProp;
        exports.stylePropPrefix = _style2.default.stylePropPrefix;
        exports.supportProp = supportProp;
        exports.inputType = inputType
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/query.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var arrayQueryImpl = __webpack_require__( /*! ./array_query */ 168);
        var remoteQueryImpl = __webpack_require__( /*! ./remote_query */ 488);
        var queryImpl = {
            array: arrayQueryImpl,
            remote: remoteQueryImpl
        };
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return queryImpl[impl].apply(this, arguments)
        };
        module.exports = query;
        module.exports.queryImpl = queryImpl
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/localization/number.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _common = __webpack_require__( /*! ../core/utils/common */ 3);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = __webpack_require__( /*! ./ldml/number */ 272);
        var _number2 = _interopRequireDefault(_number);
        var _config = __webpack_require__( /*! ../core/config */ 32);
        var _config2 = _interopRequireDefault(_config);
        var _errors = __webpack_require__( /*! ../core/errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _utils = __webpack_require__( /*! ./utils */ 273);
        var _currency = __webpack_require__( /*! ./currency */ 118);
        var _currency2 = _interopRequireDefault(_currency);
        var _number3 = __webpack_require__( /*! ./intl/number */ 455);
        var _number4 = _interopRequireDefault(_number3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _slicedToArray(arr, i) {
            return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest()
        }

        function _nonIterableRest() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }

        function _iterableToArrayLimit(arr, i) {
            if ("undefined" === typeof Symbol || !(Symbol.iterator in Object(arr))) {
                return
            }
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) {
                        break
                    }
                }
            } catch (err) {
                _d = true;
                _e = err
            } finally {
                try {
                    if (!_n && null != _i.return) {
                        _i.return()
                    }
                } finally {
                    if (_d) {
                        throw _e
                    }
                }
            }
            return _arr
        }

        function _arrayWithHoles(arr) {
            if (Array.isArray(arr)) {
                return arr
            }
        }
        var hasIntl = "undefined" !== typeof Intl;
        var MAX_LARGE_NUMBER_POWER = 4;
        var DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                var formatList = formatType.toLowerCase().split(" ");
                (0, _iterator.each)(formatList, function(index, value) {
                    if ((0, _array.inArray)(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value);
                var power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                var powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                var result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var power = this._calculateNumberPower(value, DECIMAL_BASE);
                var number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                var powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, (0, _config2.default)().thousandsSeparator) + (parts[1] ? (0, _config2.default)().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : (0, _utils.toFixed)(value, formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", (0, _config2.default)().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!(0, _type.isPlainObject)(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e4, "fixedPoint")[2]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0";
                var toFirstDigit = toStandard ? "0" : digits[1];
                var fromLastDigit = toStandard ? digits[0] : "9";
                var regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var separators = this._getSeparators();
                var regExp = new RegExp("[0-9" + (0, _common.escapeRegExp)(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g");
                var negativeEtalon = this.format(-1, format).replace(regExp, "1");
                var cleanedText = text.replace(regExp, "1");
                return cleanedText === negativeEtalon ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    var formatterConfig = this._getSeparators();
                    formatterConfig.unlimitedIntegerDigits = _format.unlimitedIntegerDigits;
                    return this.convertDigits(_number2.default.getFormatter(_format.type, formatterConfig)(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    _errors2.default.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator();
                var regExp = new RegExp("[^0-9" + (0, _common.escapeRegExp)(decimalSeparator) + "]", "g");
                var cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, "");
                if ("." === cleanedText || "" === cleanedText) {
                    return null
                }
                if (this._calcSignificantDigits(cleanedText) > 15) {
                    return NaN
                }
                var parsed = +cleanedText;
                return parsed * this.getSign(text, format)
            },
            _calcSignificantDigits: function(text) {
                var _text$split = text.split("."),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    integer = _text$split2[0],
                    fractional = _text$split2[1];
                var calcDigitsAfterLeadingZeros = function(digits) {
                    var index = -1;
                    for (var i = 0; i < digits.length; i++) {
                        if ("0" !== digits[i]) {
                            index = i;
                            break
                        }
                    }
                    return index > -1 ? digits.length - index : 0
                };
                var result = 0;
                if (integer) {
                    result += calcDigitsAfterLeadingZeros(integer.split(""))
                }
                if (fractional) {
                    result += calcDigitsAfterLeadingZeros(fractional.split("").reverse())
                }
                return result
            }
        });
        numberLocalization.inject(_currency2.default);
        if (hasIntl) {
            numberLocalization.inject(_number4.default)
        }
        module.exports = numberLocalization
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/ui/editor/editor.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 44);
        var _element_data2 = _interopRequireDefault(_element_data);
        var _callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _utils = __webpack_require__( /*! ../../events/utils */ 8);
        var _position = __webpack_require__( /*! ../../core/utils/position */ 22);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _guid = __webpack_require__( /*! ../../core/guid */ 37);
        var _guid2 = _interopRequireDefault(_guid);
        var _ui = __webpack_require__( /*! ../widget/ui.widget */ 17);
        var _ui2 = _interopRequireDefault(_ui);
        var _overlay = __webpack_require__( /*! ../overlay */ 55);
        var _overlay2 = _interopRequireDefault(_overlay);
        var _validation_engine = __webpack_require__( /*! ../validation_engine */ 86);
        var _validation_engine2 = _interopRequireDefault(_validation_engine);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _string = __webpack_require__( /*! ../../core/utils/string */ 41);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var READONLY_STATE_CLASS = "dx-state-readonly";
        var INVALID_CLASS = "dx-invalid";
        var INVALID_MESSAGE = "dx-invalid-message";
        var INVALID_MESSAGE_CONTENT = "dx-invalid-message-content";
        var INVALID_MESSAGE_AUTO = "dx-invalid-message-auto";
        var INVALID_MESSAGE_ALWAYS = "dx-invalid-message-always";
        var DX_INVALID_BADGE_CLASS = "dx-show-invalid-badge";
        var VALIDATION_TARGET = "dx-validation-target";
        var VALIDATION_MESSAGE_MIN_WIDTH = 100;
        var VALIDATION_STATUS_VALID = "valid";
        var VALIDATION_STATUS_INVALID = "invalid";
        var READONLY_NAMESPACE = "editorReadOnly";
        var getValidationErrorMessage = function(validationErrors) {
            var validationErrorMessage = "";
            if (validationErrors) {
                validationErrors.forEach(function(err) {
                    if (err.message) {
                        validationErrorMessage += (validationErrorMessage ? "<br />" : "") + (0, _string.encodeHtml)(err.message)
                    }
                })
            }
            return validationErrorMessage
        };
        var Editor = _ui2.default.inherit({
            ctor: function() {
                this.showValidationMessageTimeout = null;
                this.validationRequest = (0, _callbacks2.default)();
                this.callBase.apply(this, arguments)
            },
            _createElement: function(element) {
                this.callBase(element);
                var $element = this.$element();
                if ($element) {
                    _element_data2.default.data($element[0], VALIDATION_TARGET, this)
                }
            },
            _initOptions: function(options) {
                this.callBase.apply(this, arguments);
                this.option(_validation_engine2.default.initValidationOptions(options))
            },
            _init: function() {
                this.callBase();
                this._options.cache("validationTooltipOptions", this.option("validationTooltipOptions"));
                var $element = this.$element();
                $element.addClass(DX_INVALID_BADGE_CLASS)
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationErrors: null,
                    validationStatus: VALIDATION_STATUS_VALID,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    },
                    validationTooltipOptions: {}
                })
            },
            _attachKeyboardEvents: function() {
                if (!this.option("readOnly")) {
                    this.callBase()
                }
            },
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _focusInHandler: function(e) {
                var _this = this;
                var isValidationMessageShownOnFocus = "auto" === this.option("validationMessageMode");
                if (this._canValueBeChangedByClick() && isValidationMessageShownOnFocus) {
                    this._$validationMessage && this._$validationMessage.removeClass(INVALID_MESSAGE_AUTO);
                    clearTimeout(this.showValidationMessageTimeout);
                    this.showValidationMessageTimeout = setTimeout(function() {
                        return _this._$validationMessage && _this._$validationMessage.addClass(INVALID_MESSAGE_AUTO)
                    }, 150)
                }
                return this.callBase(e)
            },
            _canValueBeChangedByClick: function() {
                return false
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid") && this.option("validationStatus") !== VALIDATION_STATUS_INVALID;
                var validationMessageMode = this.option("validationMessageMode");
                var $element = this.$element();
                var validationErrors = this.option("validationErrors");
                if (!validationErrors && this.option("validationError")) {
                    validationErrors = [this.option("validationError")]
                }
                $element.toggleClass(INVALID_CLASS, !isValid);
                this.setAria(VALIDATION_STATUS_INVALID, !isValid || void 0);
                if (!_window2.default.hasWindow()) {
                    return
                }
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this.setAria("describedby", null);
                    this._$validationMessage = null
                }
                var validationErrorMessage = getValidationErrorMessage(validationErrors);
                if (!isValid && validationErrorMessage) {
                    this._$validationMessage = (0, _renderer2.default)("<div>").addClass(INVALID_MESSAGE).html(validationErrorMessage).appendTo($element);
                    var validationTarget = this._getValidationMessageTarget();
                    this._validationMessage = this._createComponent(this._$validationMessage, _overlay2.default, (0, _extend.extend)({
                        integrationOptions: {},
                        templatesRenderAsynchronously: false,
                        target: validationTarget,
                        shading: false,
                        width: "auto",
                        height: "auto",
                        container: $element,
                        position: this._getValidationMessagePosition("below"),
                        closeOnOutsideClick: false,
                        closeOnTargetScroll: false,
                        animation: null,
                        visible: true,
                        propagateOutsideClick: true,
                        _checkParentVisibility: false
                    }, this._options.cache("validationTooltipOptions")));
                    this._$validationMessage.toggleClass(INVALID_MESSAGE_AUTO, "auto" === validationMessageMode).toggleClass(INVALID_MESSAGE_ALWAYS, "always" === validationMessageMode);
                    var messageId = "dx-" + new _guid2.default;
                    this._validationMessage.$content().addClass(INVALID_MESSAGE_CONTENT).attr("id", messageId);
                    this.setAria("describedby", messageId);
                    this._setValidationMessageMaxWidth();
                    this._bindInnerWidgetOptions(this._validationMessage, "validationTooltipOptions")
                }
            },
            _setValidationMessageMaxWidth: function() {
                if (!this._validationMessage) {
                    return
                }
                if (0 === this._getValidationMessageTarget().outerWidth()) {
                    this._validationMessage.option("maxWidth", "100%");
                    return
                }
                var validationMessageMaxWidth = Math.max(VALIDATION_MESSAGE_MIN_WIDTH, this._getValidationMessageTarget().outerWidth());
                this._validationMessage.option("maxWidth", validationMessageMaxWidth)
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _getValidationMessagePosition: function(positionRequest) {
                var rtlEnabled = this.option("rtlEnabled");
                var messagePositionSide = (0, _position.getDefaultAlignment)(rtlEnabled);
                var messageOriginalOffset = this.option("validationMessageOffset");
                var messageOffset = {
                    h: messageOriginalOffset.h,
                    v: messageOriginalOffset.v
                };
                var verticalPositions = "below" === positionRequest ? [" top", " bottom"] : [" bottom", " top"];
                if (rtlEnabled) {
                    messageOffset.h = -messageOffset.h
                }
                if ("below" !== positionRequest) {
                    messageOffset.v = -messageOffset.v
                }
                return {
                    offset: messageOffset,
                    boundary: this.option("validationBoundary"),
                    my: messagePositionSide + verticalPositions[0],
                    at: messagePositionSide + verticalPositions[1],
                    collision: "none flip"
                }
            },
            _toggleReadOnlyState: function() {
                var readOnly = this.option("readOnly");
                this._toggleBackspaceHandler(readOnly);
                this.$element().toggleClass(READONLY_STATE_CLASS, !!readOnly);
                this.setAria("readonly", readOnly || void 0)
            },
            _toggleBackspaceHandler: function(isReadOnly) {
                var $eventTarget = this._keyboardEventBindingTarget();
                var eventName = (0, _utils.addNamespace)("keydown", READONLY_NAMESPACE);
                _events_engine2.default.off($eventTarget, eventName);
                if (isReadOnly) {
                    _events_engine2.default.on($eventTarget, eventName, function(e) {
                        if ("backspace" === (0, _utils.normalizeKeyName)(e)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _dispose: function() {
                var element = this.$element()[0];
                _element_data2.default.data(element, VALIDATION_TARGET, null);
                clearTimeout(this.showValidationMessageTimeout);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "isValid":
                    case "validationError":
                        this.option(_validation_engine2.default.synchronizeValidationOptions(args, this.option()));
                        break;
                    case "validationErrors":
                    case "validationStatus":
                        this.option(_validation_engine2.default.synchronizeValidationOptions(args, this.option()));
                        this._renderValidationState();
                        break;
                    case "validationBoundary":
                    case "validationMessageMode":
                        this._renderValidationState();
                        break;
                    case "validationTooltipOptions":
                        this._innerWidgetOptionChanged(this._validationMessage, args);
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        this._setValidationMessageMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        });
        module.exports = Editor
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/object.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 89);
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        var orderEach = function(map, func) {
            var keys = [];
            var key;
            var i;
            for (key in map) {
                if (Object.prototype.hasOwnProperty.call(map, key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = typeUtils.isNumeric(x);
                var isNumberY = typeUtils.isNumeric(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && variableWrapper.isWrapped(target[property])) {
                variableWrapper.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue;
            var newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if ("__proto__" === name || target === newValue) {
                    continue
                }
                if (typeUtils.isPlainObject(newValue)) {
                    var goDeeper = extendComplexObject ? typeUtils.isObject(prevValue) : typeUtils.isPlainObject(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.clone = clone;
        exports.orderEach = orderEach;
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date_serialization.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 32);
        var getLDMLFormatter = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 275).getFormatter;
        var defaultDateNames = __webpack_require__( /*! ../../localization/default_date_names */ 276);
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var isString = typeUtils.isString;
        var isDate = typeUtils.isDate;
        var isNumber = typeUtils.isNumeric;
        var NUMBER_SERIALIZATION_FORMAT = "number";
        var DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd";
        var DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var MILLISECOND_LENGHT = 3;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            var parsedValue;
            if (isString(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            if (!result) {
                parsedValue = !isDate(text) && Date.parse(text);
                result = isNumber(parsedValue) ? new Date(parsedValue) : text
            }
            return result
        };

        function parseISO8601String(text) {
            var parts = text.match(ISO8601_PATTERN);
            var timePart = function(part) {
                return +part || 0
            };
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, timePart(parts[1]), timePart(parts[2]), timePart(parts[4]))
                }
                return
            }
            var year = parts[1];
            var month = --parts[3];
            var day = parts[5];
            var timeZoneHour = 0;
            var timeZoneMinute = 0;
            timeZoneHour = timePart(parts[14]);
            timeZoneMinute = timePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = timePart(parts[6]) - timeZoneHour;
            var minute = timePart(parts[8]) - timeZoneMinute;
            var second = timePart(parts[10]);
            var parseMilliseconds = function(part) {
                part = part || "";
                return timePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
            };
            var millisecond = parseMilliseconds(parts[11]);
            if (parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        }
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN);
            var result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !config().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!isDate(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return getLDMLFormatter(serializationFormat, defaultDateNames)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if (isString(value)) {
                    var format;
                    if (config().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        module.exports = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        }
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/ui.collection_widget.edit.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _uiCollection_widget = __webpack_require__( /*! ./ui.collection_widget.base */ 504);
        var _uiCollection_widget2 = _interopRequireDefault(_uiCollection_widget);
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 18);
        var _ui2 = _interopRequireDefault(_ui);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _uiCollection_widgetEditStrategy = __webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 193);
        var _uiCollection_widgetEditStrategy2 = _interopRequireDefault(_uiCollection_widgetEditStrategy);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 21);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 58);
        var _utils = __webpack_require__( /*! ../../data/data_source/utils */ 69);
        var _selection = __webpack_require__( /*! ../selection/selection */ 223);
        var _selection2 = _interopRequireDefault(_selection);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread()
        }

        function _nonIterableSpread() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }

        function _unsupportedIterableToArray(o, minLen) {
            if (!o) {
                return
            }
            if ("string" === typeof o) {
                return _arrayLikeToArray(o, minLen)
            }
            var n = Object.prototype.toString.call(o).slice(8, -1);
            if ("Object" === n && o.constructor) {
                n = o.constructor.name
            }
            if ("Map" === n || "Set" === n) {
                return Array.from(o)
            }
            if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                return _arrayLikeToArray(o, minLen)
            }
        }

        function _iterableToArray(iter) {
            if ("undefined" !== typeof Symbol && Symbol.iterator in Object(iter)) {
                return Array.from(iter)
            }
        }

        function _arrayWithoutHoles(arr) {
            if (Array.isArray(arr)) {
                return _arrayLikeToArray(arr)
            }
        }

        function _arrayLikeToArray(arr, len) {
            if (null == len || len > arr.length) {
                len = arr.length
            }
            for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i]
            }
            return arr2
        }
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting";
        var NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = _uiCollection_widget2.default.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule();
                if ("multi" === this.option("selectionMode")) {
                    this._showDeprecatedSelectionMode()
                }
            },
            _initKeyGetter: function() {
                this._keyGetter = (0, _data.compileGetter)(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            key: function() {
                if (this.option("keyExpr")) {
                    return this.option("keyExpr")
                }
                return this._dataSource && this._dataSource.key()
            },
            keyOf: function(item) {
                var key = item;
                var store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _nullValueSelectionSupported: function() {
                return false
            },
            _initSelectionModule: function() {
                var that = this;
                var itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new _selection2.default({
                    allowNullValue: this._nullValueSelectionSupported(),
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: that.key.bind(that),
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        if (store) {
                            return store.load(options).done(function(loadResult) {
                                if (that._disposed) {
                                    return
                                }
                                var items = (0, _utils.normalizeLoadResult)(loadResult).data;
                                that._dataSource._applyMapFunction(items)
                            })
                        } else {
                            return (new _deferred.Deferred).resolve(this.plainItems())
                        }
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = _uiCollection_widgetEditStrategy2.default;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this;
                var indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                (0, _iterator.each)(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                var _this = this;
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions().done(function() {
                        return _this._normalizeSelectedItems()
                    })
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem;
                var selectedIndex;
                var selectedItemKeys;
                var selectedItems;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedItem", selectedItem);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItems[0]);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        this._setOptionWithoutOptionChange("selectedItem", selectedItems[0]);
                        this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                        this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionWithoutOptionChange("selectedItems", [selectedItem]);
                            this._setOptionWithoutOptionChange("selectedIndex", selectedIndex);
                            this._setOptionWithoutOptionChange("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionWithoutOptionChange("selectedItems", []);
                            this._setOptionWithoutOptionChange("selectedItemKeys", []);
                            this._setOptionWithoutOptionChange("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired")) {
                            var selectedItemIndex = this._getIndexByKey(selectedItemKeys[0]);
                            if (!indexExists(selectedItemIndex)) {
                                return this._syncSelectionOptions("selectedIndex")
                            }
                        }
                        return this._selection.setSelection(selectedItemKeys)
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName);
                    var length = (0, _type.isDefined)(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionWithoutOptionChange("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionWithoutOptionChange("selectedItems", [normalizedSelection]);
                            return this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: (0, _renderer2.default)(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" !== this.option("selectionMode")) {
                    var $itemElement = (0, _renderer2.default)(args.itemElement);
                    var normalizedItemIndex = this._editStrategy.getNormalizedIndex($itemElement);
                    var isItemSelected = this._isItemSelected(normalizedItemIndex);
                    this._processSelectableItem($itemElement, isItemSelected)
                }
            },
            _processSelectableItem: function($itemElement, isSelected) {
                $itemElement.toggleClass(this._selectedItemClass(), isSelected);
                this._setAriaSelected($itemElement, String(isSelected))
            },
            _updateSelectedItems: function(args) {
                var that = this;
                var addedItemKeys = args.addedItemKeys;
                var removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var addedSelection = [];
                        var normalizedIndex;
                        var removedSelection = [];
                        that._editStrategy.beginCache();
                        for (var i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (var _i = 0; _i < removedItemKeys.length; _i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[_i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }(0, _deferred.when)(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: _common.noop,
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, false);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _showDeprecatedSelectionMode: function() {
                _ui2.default.log("W0001", this.NAME, "selectionMode: 'multi'", "16.1", "Use selectionMode: 'multiple' instead");
                this.option("selectionMode", "multiple")
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, true);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                var _this2 = this;
                switch (args.name) {
                    case "selectionMode":
                        if ("multi" === args.value) {
                            this._showDeprecatedSelectionMode()
                        } else {
                            this._invalidate()
                        }
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name).done(function() {
                            return _this2._normalizeSelectedItems()
                        });
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionWithoutOptionChange("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new _deferred.Deferred;
                var deletingActionArgs = {
                    cancel: false
                };
                var deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                    excludeValidators: ["disabled", "readOnly"]
                });
                (0, _deferred.when)(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise;
                    var deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state();
                    var argumentsSpecified = !!arguments.length;
                    var shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    (0, _deferred.when)((0, _deferred.fromPromise)(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                var deferred = new _deferred.Deferred;
                var disabledState = this.option("disabled");
                var dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw _ui2.default.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new _deferred.Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    (0, _renderer2.default)(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof _data_source.DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys") || [];
                    this._selection.setSelection([].concat(_toConsumableArray(selectedItemKeys), [key]))
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            _deleteItemElementByIndex: function(index) {
                this._updateSelectionAfterDelete(index);
                this._updateIndicesAfterIndex(index);
                this._editStrategy.deleteItemAtIndex(index)
            },
            _afterItemElementDeleted: function($item, deletedActionArgs) {
                var changingOption = this._dataSource ? "dataSource" : "items";
                this._simulateOptionChange(changingOption);
                this._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                    beforeExecute: function() {
                        $item.remove()
                    },
                    excludeValidators: ["disabled", "readOnly"]
                });
                this._renderEmptyMessage()
            },
            deleteItem: function(itemElement) {
                var that = this;
                var deferred = new _deferred.Deferred;
                var $item = this._editStrategy.getItemElement(itemElement);
                var index = this._editStrategy.getNormalizedIndex(itemElement);
                var itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._deleteItemElementByIndex(index);
                            that._afterItemElementDeleted($item, deletedActionArgs);
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new _deferred.Deferred;
                var that = this;
                var strategy = this._editStrategy;
                var $movingItem = strategy.getItemElement(itemElement);
                var $destinationItem = strategy.getItemElement(toItemElement);
                var movingIndex = strategy.getNormalizedIndex(itemElement);
                var destinationIndex = strategy.getNormalizedIndex(toItemElement);
                var changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        module.exports = CollectionWidget
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/icon.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ICON_CLASS = "dx-icon";
        var SVG_ICON_CLASS = "dx-svg-icon";
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(source)) {
                return "svg"
            }
            if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            if (/^\s?([\w-_]\s?)+$/.test(source)) {
                return "fontIcon"
            }
            return false
        };
        var getImageContainer = function(source) {
            switch (getImageSourceType(source)) {
                case "image":
                    return (0, _renderer2.default)("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return (0, _renderer2.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(source));
                case "dxIcon":
                    return (0, _renderer2.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(ICON_CLASS, "-").concat(source));
                case "svg":
                    return (0, _renderer2.default)("<i>").addClass("".concat(ICON_CLASS, " ").concat(SVG_ICON_CLASS)).append(source);
                default:
                    return null
            }
        };
        exports.getImageSourceType = getImageSourceType;
        exports.getImageContainer = getImageContainer
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/viz/themes.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var vizUtils = __webpack_require__( /*! ./core/utils */ 15);
        var uiThemes = __webpack_require__( /*! ../ui/themes */ 29);
        var themes = {};
        var themesMapping = {};
        var themesSchemeMapping = {};
        var _extend = extend;
        var _each = each;
        var _normalizeEnum = vizUtils.normalizeEnum;
        var currentThemeName = null;
        var defaultTheme;
        var nextCacheUid = 0;
        var widgetsCache = {};

        function getTheme(themeName) {
            var name = _normalizeEnum(themeName);
            return themes[name] || themes[themesMapping[name] || currentTheme()]
        }

        function findThemeNameByName(name, scheme) {
            return themesMapping[name + "." + scheme] || themesSchemeMapping[name + "." + scheme] || themesMapping[name]
        }

        function findThemeNameByPlatform(platform, version, scheme) {
            return findThemeNameByName(platform + version, scheme) || findThemeNameByName(platform, scheme)
        }

        function currentTheme(themeName, colorScheme) {
            if (!arguments.length) {
                return currentThemeName || findThemeNameByName(uiThemes.current()) || defaultTheme
            }
            var scheme = _normalizeEnum(colorScheme);
            currentThemeName = (themeName && themeName.platform ? findThemeNameByPlatform(_normalizeEnum(themeName.platform), themeName.version, scheme) : findThemeNameByName(_normalizeEnum(themeName), scheme)) || currentThemeName;
            return this
        }

        function getThemeInfo(themeName, splitter) {
            var k = themeName.indexOf(splitter);
            return k > 0 ? {
                name: themeName.substring(0, k),
                scheme: themeName.substring(k + 1)
            } : null
        }

        function registerThemeName(themeName, targetThemeName) {
            var themeInfo = getThemeInfo(themeName, ".") || {
                name: themeName
            };
            var name = themeInfo.name;
            var scheme = themeInfo.scheme;
            if (scheme) {
                themesMapping[name] = themesMapping[name] || targetThemeName;
                themesMapping[name + "." + scheme] = targetThemeName
            } else {
                themesMapping[name] = targetThemeName
            }
        }

        function registerTheme(theme, baseThemeName) {
            var themeName = _normalizeEnum(theme && theme.name);
            if (themeName) {
                theme.isDefault && (defaultTheme = themeName);
                registerThemeName(themeName, themeName);
                themes[themeName] = _extend(true, {}, getTheme(baseThemeName), patchTheme(theme))
            }
        }

        function registerThemeAlias(alias, theme) {
            registerThemeName(_normalizeEnum(alias), _normalizeEnum(theme))
        }

        function registerThemeSchemeAlias(from, to) {
            themesSchemeMapping[from] = to
        }

        function mergeScalar(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value && void 0 === target[field]) {
                target[field] = _value
            }
        }

        function mergeObject(target, field, source, sourceValue) {
            var _value = source ? source[field] : sourceValue;
            if (void 0 !== _value) {
                target[field] = _extend(true, {}, _value, target[field])
            }
        }

        function patchTheme(theme) {
            theme = _extend(true, {
                loadingIndicator: {
                    font: {}
                },
                "export": {
                    font: {}
                },
                legend: {
                    font: {},
                    border: {}
                },
                title: {
                    font: {}
                },
                tooltip: {
                    font: {}
                },
                "chart:common": {},
                "chart:common:axis": {
                    grid: {},
                    minorGrid: {},
                    tick: {},
                    minorTick: {},
                    title: {
                        font: {}
                    },
                    label: {
                        font: {}
                    }
                },
                "chart:common:annotation": {
                    font: {},
                    border: {}
                },
                chart: {
                    commonSeriesSettings: {
                        candlestick: {}
                    }
                },
                pie: {},
                polar: {},
                gauge: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    }
                },
                barGauge: {},
                funnel: {},
                sankey: {},
                map: {
                    background: {}
                },
                treeMap: {
                    tile: {
                        selectionStyle: {
                            border: {}
                        }
                    },
                    group: {
                        border: {},
                        selectionStyle: {
                            border: {}
                        },
                        label: {
                            font: {}
                        }
                    }
                },
                rangeSelector: {
                    scale: {
                        tick: {},
                        minorTick: {},
                        label: {
                            font: {}
                        }
                    },
                    chart: {}
                },
                sparkline: {},
                bullet: {}
            }, theme);
            mergeScalar(theme.loadingIndicator, "backgroundColor", theme);
            mergeScalar(theme.chart.commonSeriesSettings.candlestick, "innerColor", null, theme.backgroundColor);
            mergeScalar(theme.map.background, "color", null, theme.backgroundColor);
            mergeScalar(theme.title.font, "color", null, theme.primaryTitleColor);
            mergeObject(theme.title, "subtitle", null, theme.title);
            mergeScalar(theme.legend.font, "color", null, theme.secondaryTitleColor);
            mergeScalar(theme.legend.border, "color", null, theme.gridColor);
            patchAxes(theme);
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sparkline", "bullet", "sankey"], function(_, section) {
                mergeScalar(theme[section], "redrawOnResize", theme);
                mergeScalar(theme[section], "containerBackgroundColor", null, theme.backgroundColor);
                mergeObject(theme[section], "tooltip", theme);
                mergeObject(theme[section], "export", theme)
            });
            _each(["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sankey"], function(_, section) {
                mergeObject(theme[section], "loadingIndicator", theme);
                mergeObject(theme[section], "legend", theme);
                mergeObject(theme[section], "title", theme)
            });
            _each(["chart", "pie", "polar"], function(_, section) {
                mergeObject(theme, section, null, theme["chart:common"])
            });
            _each(["chart", "polar"], function(_, section) {
                theme[section] = theme[section] || {};
                mergeObject(theme[section], "commonAxisSettings", null, theme["chart:common:axis"]);
                mergeObject(theme[section], "commonAnnotationSettings", null, theme["chart:common:annotation"])
            });
            mergeObject(theme.rangeSelector.chart, "commonSeriesSettings", theme.chart);
            mergeObject(theme.rangeSelector.chart, "dataPrepareSettings", theme.chart);
            mergeScalar(theme.treeMap.group.border, "color", null, theme.gridColor);
            mergeScalar(theme.treeMap.tile.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.treeMap.group.selectionStyle.border, "color", null, theme.primaryTitleColor);
            mergeScalar(theme.map.legend, "backgroundColor", theme);
            patchMapLayers(theme);
            return theme
        }

        function patchAxes(theme) {
            var commonAxisSettings = theme["chart:common:axis"];
            var colorFieldName = "color";
            _each([commonAxisSettings.grid, commonAxisSettings.minorGrid], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.gridColor)
            });
            _each([commonAxisSettings, commonAxisSettings.tick, commonAxisSettings.minorTick, commonAxisSettings.label.font], function(_, obj) {
                mergeScalar(obj, colorFieldName, null, theme.axisColor)
            });
            mergeScalar(commonAxisSettings.title.font, colorFieldName, null, theme.secondaryTitleColor);
            mergeScalar(theme.gauge.scale.label.font, colorFieldName, null, theme.axisColor);
            mergeScalar(theme.gauge.scale.tick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.gauge.scale.minorTick, colorFieldName, null, theme.backgroundColor);
            mergeScalar(theme.rangeSelector.scale.label.font, colorFieldName, null, theme.axisColor)
        }

        function patchMapLayers(theme) {
            var map = theme.map;
            _each(["area", "line", "marker"], function(_, section) {
                mergeObject(map, "layer:" + section, null, map.layer)
            });
            _each(["dot", "bubble", "pie", "image"], function(_, section) {
                mergeObject(map, "layer:marker:" + section, null, map["layer:marker"])
            })
        }

        function addCacheItem(target) {
            var cacheUid = ++nextCacheUid;
            target._cache = cacheUid;
            widgetsCache[cacheUid] = target
        }

        function removeCacheItem(target) {
            delete widgetsCache[target._cache]
        }

        function refreshTheme() {
            _each(widgetsCache, function() {
                this.refresh()
            });
            return this
        }
        _extend(exports, {
            currentTheme: currentTheme,
            registerTheme: registerTheme,
            getTheme: getTheme,
            registerThemeAlias: registerThemeAlias,
            registerThemeSchemeAlias: registerThemeSchemeAlias,
            refreshTheme: refreshTheme,
            addCacheItem: addCacheItem,
            removeCacheItem: removeCacheItem
        });
        _extend(exports, {
            themes: themes,
            themesMapping: themesMapping,
            themesSchemeMapping: themesSchemeMapping,
            widgetsCache: widgetsCache,
            resetCurrentTheme: function() {
                currentThemeName = null
            }
        })
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ready_callbacks.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var injector = __webpack_require__( /*! ./dependency_injector */ 60);
        var windowUtils = __webpack_require__( /*! ./window */ 7);
        var callOnce = __webpack_require__( /*! ./call_once */ 82);
        var callbacks = [];
        var isReady = function() {
            return "complete" === domAdapter.getReadyState() || "loading" !== domAdapter.getReadyState() && !domAdapter.getDocumentElement().doScroll
        };
        var subscribeReady = callOnce(function() {
            var removeListener = domAdapter.listen(domAdapter.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var hasWindow = windowUtils.hasWindow();
                if (hasWindow && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    hasWindow && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    return callback()
                });
                callbacks = []
            }
        };
        module.exports = injector(readyCallbacks)
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/overlay.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./overlay/ui.overlay */ 329)
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/bindable_template.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.BindableTemplate = void 0;
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _template_base = __webpack_require__( /*! ./template_base */ 80);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _remove_event = __webpack_require__( /*! ../remove_event */ 141);
        var _remove_event2 = _interopRequireDefault(_remove_event);
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        var watchChanges = function() {
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {};
                var missedFields = fields.slice();
                var watchHandlers = fields.map(function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    watchHandlers.forEach(function(dispose) {
                        return dispose()
                    })
                }
            };
            return function(rawData, watchMethod, fields, fieldsMap, callback) {
                var fieldsDispose;
                var globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if ((0, _type.isPrimitive)(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            }
        }();
        exports.BindableTemplate = function(_TemplateBase) {
            _inherits(BindableTemplate, _TemplateBase);
            var _super = _createSuper(BindableTemplate);

            function BindableTemplate(render, fields, watchMethod, fieldsMap) {
                var _this;
                _classCallCheck(this, BindableTemplate);
                _this = _super.call(this);
                _this._render = render;
                _this._fields = fields;
                _this._fieldsMap = fieldsMap || {};
                _this._watchMethod = watchMethod;
                return _this
            }
            _createClass(BindableTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    var _this2 = this;
                    var $container = (0, _renderer2.default)(options.container);
                    var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                        $container.empty();
                        _this2._render($container, data, options.model)
                    });
                    (0, _events_engine.on)($container, _remove_event2.default, dispose);
                    return $container.contents()
                }
            }]);
            return BindableTemplate
        }(_template_base.TemplateBase)
    }, ,
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/data/data_source/data_source.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.DataSource = void 0;
        var _class = __webpack_require__( /*! ../../core/class */ 16);
        var _class2 = _interopRequireDefault(_class);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _common2 = _interopRequireDefault(_common);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = __webpack_require__( /*! ../utils */ 42);
        var _array_utils = __webpack_require__( /*! ../array_utils */ 145);
        var _array_utils2 = _interopRequireDefault(_array_utils);
        var _custom_store = __webpack_require__( /*! ../custom_store */ 123);
        var _custom_store2 = _interopRequireDefault(_custom_store);
        var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 101);
        var _errors = __webpack_require__( /*! ../errors */ 40);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 13);
        var _array2 = _interopRequireDefault(_array);
        var _queue = __webpack_require__( /*! ../../core/utils/queue */ 290);
        var _queue2 = _interopRequireDefault(_queue);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _operation_manager = __webpack_require__( /*! ./operation_manager */ 487);
        var _operation_manager2 = _interopRequireDefault(_operation_manager);
        var _utils2 = __webpack_require__( /*! ./utils */ 69);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        exports.DataSource = _class2.default.inherit({
            ctor: function(options) {
                var _options$reshapeOnPus, _this = this;
                options = (0, _utils2.normalizeDataSourceOptions)(options);
                this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                var onPushHandler = 0 !== options.pushAggregationTimeout ? (0, _utils.throttleChanges)(this._onPush, function() {
                    return void 0 === options.pushAggregationTimeout ? 5 * _this._changedTime : options.pushAggregationTimeout
                }) : this._onPush;
                this._changedTime = 0;
                this._onPushHandler = function(changes) {
                    _this._aggregationTimeoutId = onPushHandler.call(_this, changes)
                };
                this._store = options.store;
                this._store.on("push", this._onPushHandler);
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                this._reshapeOnPush = null !== (_options$reshapeOnPus = options.reshapeOnPush) && void 0 !== _options$reshapeOnPus ? _options$reshapeOnPus : false;
                (0, _iterator.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        _this.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new _operation_manager2.default;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!(0, _type.isDefined)(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                var _this$_delayedLoadTas;
                this._store.off("push", this._onPushHandler);
                this._eventsStrategy.dispose();
                clearTimeout(this._aggregationTimeoutId);
                delete this._store;
                null === (_this$_delayedLoadTas = this._delayedLoadTask) || void 0 === _this$_delayedLoadTas ? void 0 : _this$_delayedLoadTas.abort();
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {};
                var names = ["sort", "filter", "select", "group", "requireTotalCount"];
                var customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }(0, _iterator.each)(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!(0, _type.isNumeric)(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!(0, _type.isNumeric)(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            generateStoreLoadOptionAccessor: function(optionName) {
                var _this2 = this;
                return function(args) {
                    var normalizedArgs = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(args);
                    if (void 0 === normalizedArgs) {
                        return _this2._storeLoadOptions[optionName]
                    }
                    _this2._storeLoadOptions[optionName] = normalizedArgs
                }
            },
            sort: function() {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key]
                }
                return this.generateStoreLoadOptionAccessor("sort")(args)
            },
            filter: function() {
                var newFilter = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: function() {
                for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                    args[_key2] = arguments[_key2]
                }
                return this.generateStoreLoadOptionAccessor("group")(args)
            },
            select: function() {
                for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                    args[_key3] = arguments[_key3]
                }
                return this.generateStoreLoadOptionAccessor("select")(args)
            },
            requireTotalCount: function(value) {
                if (!(0, _type.isBoolean)(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!(0, _type.isString)(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                var _this$_store;
                return null === (_this$_store = this._store) || void 0 === _this$_store ? void 0 : _this$_store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return _queue2.default.create()
            },
            _changeLoadingCount: function(increment) {
                var oldLoading = this.isLoading();
                this._loadingCount += increment;
                var newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this._eventsStrategy.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var _this3 = this;
                this.beginLoading();
                deferred.always(function() {
                    _this3.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var _this4 = this;
                deferred.fail(function() {
                    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                        args[_key4] = arguments[_key4]
                    }
                    if (args[0] === _utils2.CANCELED_TOKEN) {
                        return
                    }
                    _this4._eventsStrategy.fireEvent("loadError", args)
                })
            },
            _fireChanged: function(args) {
                var date = new Date;
                this._eventsStrategy.fireEvent("changed", args);
                this._changedTime = new Date - date
            },
            _scheduleChangedCallbacks: function(deferred) {
                var _this5 = this;
                deferred.done(function() {
                    return _this5._fireChanged()
                })
            },
            loadSingle: function(propName, propValue) {
                var _this6 = this;
                var d = new _deferred.Deferred;
                var key = this.key();
                var store = this._store;
                var options = this._createStoreLoadOptions();
                var handleDone = function(data) {
                    if (!(0, _type.isDefined)(data) || _array2.default.isEmpty(data)) {
                        d.reject(new _errors.errors.Error("E4009"))
                    } else {
                        if (!Array.isArray(data)) {
                            data = [data]
                        }
                        d.resolve(_this6._applyMapFunction(data)[0])
                    }
                };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;
                var shouldForceByKey = function() {
                    return store instanceof _custom_store2.default && !store._byKeyViaLoad()
                };
                (function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var _this7 = this;
                var d = new _deferred.Deferred;
                var loadTask = function() {
                    if (_this7._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(d)) {
                        return
                    }
                    return _this7._loadFromStore(loadOperation, d)
                };
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                var loadOperation = this._createLoadOperation(d);
                this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        _this7._delayedLoadTask = _common2.default.executeAsync(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _onPush: function(changes) {
                var _this8 = this;
                if (this._reshapeOnPush) {
                    this.load()
                } else {
                    this._eventsStrategy.fireEvent("changing", [{
                        changes: changes
                    }]);
                    var group = this.group();
                    var items = this.items();
                    var groupLevel = 0;
                    var dataSourceChanges = this.paginate() || group ? changes.filter(function(item) {
                        return "update" === item.type
                    }) : changes;
                    if (group) {
                        groupLevel = Array.isArray(group) ? group.length : 1
                    }
                    if (this._mapFunc) {
                        dataSourceChanges.forEach(function(item) {
                            if ("insert" === item.type) {
                                item.data = _this8._mapFunc(item.data)
                            }
                        })
                    }
                    _array_utils2.default.applyBatch(this.store(), items, dataSourceChanges, groupLevel, true);
                    this._fireChanged([{
                        changes: changes
                    }])
                }
            },
            _createLoadOperation: function(deferred) {
                var _this9 = this;
                var operationId = this._operationManager.add(deferred);
                var storeLoadOptions = this._createStoreLoadOptions();
                deferred.always(function() {
                    return _this9._operationManager.remove(operationId)
                });
                return {
                    operationId: operationId,
                    storeLoadOptions: storeLoadOptions
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof _custom_store2.default) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            cancelAll: function() {
                return this._operationManager.cancelAll()
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = (0, _extend.extend)({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue;
                var op = this._searchOperation;
                var selector = this._searchExpr;
                var searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }(0, _iterator.each)(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var _this10 = this;
                var handleSuccess = function(data, extra) {
                    if (_this10._disposed) {
                        return
                    }
                    if (!(0, _utils2.isPending)(pendingDeferred)) {
                        return
                    }
                    var loadResult = (0, _extend.extend)((0, _utils2.normalizeLoadResult)(data, extra), loadOptions);
                    _this10._eventsStrategy.fireEvent("customizeLoadResult", [loadResult]);
                    (0, _deferred.when)(loadResult.data).done(function(data) {
                        loadResult.data = data;
                        _this10._processStoreLoadResult(loadResult, pendingDeferred)
                    }).fail(pendingDeferred.reject)
                };
                if (loadOptions.data) {
                    return (new _deferred.Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var _this11 = this;
                var data = loadResult.data;
                var extra = loadResult.extra;
                var storeLoadOptions = loadResult.storeLoadOptions;
                var resolvePendingDeferred = function() {
                    _this11._isLoaded = true;
                    _this11._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                };
                var proceedLoadingTotalCount = function() {
                    _this11.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                };
                if (this._disposed) {
                    return
                }
                data = this._applyPostProcessFunction(this._applyMapFunction(data));
                if (!(0, _type.isPlainObject)(extra)) {
                    extra = {}
                }
                this._items = data;
                if (!data.length || !this._paginate || this._pageSize && data.length < this._pageSize) {
                    this._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return (0, _utils2.mapDataRespectingGrouping)(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        })
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/ui/load_indicator.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 7);
        var navigator = windowUtils.getNavigator();
        var support = __webpack_require__( /*! ../core/utils/support */ 45);
        var themes = __webpack_require__( /*! ./themes */ 29);
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var devices = __webpack_require__( /*! ../core/devices */ 14);
        var registerComponent = __webpack_require__( /*! ../core/component_registrator */ 9);
        var Widget = __webpack_require__( /*! ./widget/ui.widget */ 17);
        var LOADINDICATOR_CLASS = "dx-loadindicator";
        var LOADINDICATOR_WRAPPER_CLASS = "dx-loadindicator-wrapper";
        var LOADINDICATOR_CONTENT_CLASS = "dx-loadindicator-content";
        var LOADINDICATOR_ICON_CLASS = "dx-loadindicator-icon";
        var LOADINDICATOR_SEGMENT_CLASS = "dx-loadindicator-segment";
        var LOADINDICATOR_SEGMENT_INNER_CLASS = "dx-loadindicator-segment-inner";
        var LOADINDICATOR_IMAGE_CLASS = "dx-loadindicator-image";
        var LoadIndicator = Widget.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    indicatorSrc: "",
                    activeStateEnabled: false,
                    hoverStateEnabled: false,
                    _animatingSegmentCount: 1,
                    _animatingSegmentInner: false
                })
            },
            _defaultOptionsRules: function() {
                var themeName = themes.current();
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = devices.real();
                        var obsoleteAndroid = "android" === realDevice.platform && !/chrome/i.test(navigator.userAgent);
                        return obsoleteAndroid
                    },
                    options: {
                        viaImage: true
                    }
                }, {
                    device: function() {
                        return themes.isIos7(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 11
                    }
                }, {
                    device: function() {
                        return themes.isMaterial(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 2,
                        _animatingSegmentInner: true
                    }
                }, {
                    device: function() {
                        return themes.isGeneric(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 7
                    }
                }])
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(LOADINDICATOR_CLASS)
            },
            _initMarkup: function() {
                this.callBase();
                this._renderWrapper();
                this._renderIndicatorContent();
                this._renderMarkup()
            },
            _renderWrapper: function() {
                this._$wrapper = $("<div>").addClass(LOADINDICATOR_WRAPPER_CLASS);
                this.$element().append(this._$wrapper)
            },
            _renderIndicatorContent: function() {
                this._$content = $("<div>").addClass(LOADINDICATOR_CONTENT_CLASS);
                this._$wrapper.append(this._$content)
            },
            _renderMarkup: function() {
                if (support.animation() && !this.option("viaImage") && !this.option("indicatorSrc")) {
                    this._renderMarkupForAnimation()
                } else {
                    this._renderMarkupForImage()
                }
            },
            _renderMarkupForAnimation: function() {
                var animatingSegmentInner = this.option("_animatingSegmentInner");
                this._$indicator = $("<div>").addClass(LOADINDICATOR_ICON_CLASS);
                this._$content.append(this._$indicator);
                for (var i = this.option("_animatingSegmentCount"); i >= 0; --i) {
                    var $segment = $("<div>").addClass(LOADINDICATOR_SEGMENT_CLASS).addClass(LOADINDICATOR_SEGMENT_CLASS + i);
                    if (animatingSegmentInner) {
                        $segment.append($("<div>").addClass(LOADINDICATOR_SEGMENT_INNER_CLASS))
                    }
                    this._$indicator.append($segment)
                }
            },
            _renderMarkupForImage: function() {
                var indicatorSrc = this.option("indicatorSrc");
                this._$wrapper.addClass(LOADINDICATOR_IMAGE_CLASS);
                if (indicatorSrc) {
                    this._$wrapper.css("backgroundImage", "url(" + indicatorSrc + ")")
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._updateContentSizeForAnimation()
            },
            _updateContentSizeForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                var width = this.option("width");
                var height = this.option("height");
                if (width || height) {
                    width = this.$element().width();
                    height = this.$element().height();
                    var minDimension = Math.min(height, width);
                    this._$wrapper.css({
                        height: minDimension,
                        width: minDimension,
                        fontSize: minDimension
                    })
                }
            },
            _clean: function() {
                this.callBase();
                this._removeMarkupForAnimation();
                this._removeMarkupForImage()
            },
            _removeMarkupForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                this._$indicator.remove();
                delete this._$indicator
            },
            _removeMarkupForImage: function() {
                this._$wrapper.css("backgroundImage", "none")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_animatingSegmentCount":
                    case "_animatingSegmentInner":
                    case "indicatorSrc":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        registerComponent("dxLoadIndicator", LoadIndicator);
        module.exports = LoadIndicator
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dependency_injector.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = function(object) {
            var extend = __webpack_require__( /*! ./extend */ 0).extend;
            var isFunction = __webpack_require__( /*! ./type */ 1).isFunction;
            var each = __webpack_require__( /*! ./iterator */ 4).each;
            var Class = __webpack_require__( /*! ../class */ 16);
            var BaseClass = Class.inherit(object);
            var InjectedClass = BaseClass;
            var instance = new InjectedClass(object);
            var initialFields = {};
            var injectFields = function(injectionObject, initial) {
                each(injectionObject, function(key) {
                    if (isFunction(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                extend(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/version.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = function(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10);
                var yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/utils.ink_ripple.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var INKRIPPLE_CLASS = "dx-inkripple";
        var INKRIPPLE_WAVE_CLASS = "dx-inkripple-wave";
        var INKRIPPLE_SHOWING_CLASS = "dx-inkripple-showing";
        var INKRIPPLE_HIDING_CLASS = "dx-inkripple-hiding";
        var DEFAULT_WAVE_SIZE_COEFFICIENT = 2;
        var MAX_WAVE_SIZE = 4e3;
        var ANIMATION_DURATION = 300;
        var HOLD_ANIMATION_DURATION = 1e3;
        var DEFAULT_WAVE_INDEX = 0;
        var render = function(args) {
            args = args || {};
            if (void 0 === args.useHoldAnimation) {
                args.useHoldAnimation = true
            }
            var config = {
                waveSizeCoefficient: args.waveSizeCoefficient || DEFAULT_WAVE_SIZE_COEFFICIENT,
                isCentered: args.isCentered || false,
                wavesNumber: args.wavesNumber || 1,
                durations: getDurations(args.useHoldAnimation)
            };
            return {
                showWave: showWave.bind(this, config),
                hideWave: hideWave.bind(this, config)
            }
        };
        var getInkRipple = function(element) {
            var result = element.children("." + INKRIPPLE_CLASS);
            if (0 === result.length) {
                result = $("<div>").addClass(INKRIPPLE_CLASS).appendTo(element)
            }
            return result
        };
        var getWaves = function(element, wavesNumber) {
            var inkRipple = getInkRipple(element);
            var result = inkRipple.children("." + INKRIPPLE_WAVE_CLASS).toArray();
            for (var i = result.length; i < wavesNumber; i++) {
                var $currentWave = $("<div>").appendTo(inkRipple).addClass(INKRIPPLE_WAVE_CLASS);
                result.push($currentWave[0])
            }
            return $(result)
        };
        var getWaveStyleConfig = function(args, config) {
            var element = config.element;
            var elementWidth = element.outerWidth();
            var elementHeight = element.outerHeight();
            var elementDiagonal = parseInt(Math.sqrt(elementWidth * elementWidth + elementHeight * elementHeight));
            var waveSize = Math.min(MAX_WAVE_SIZE, parseInt(elementDiagonal * args.waveSizeCoefficient));
            var left;
            var top;
            if (args.isCentered) {
                left = (elementWidth - waveSize) / 2;
                top = (elementHeight - waveSize) / 2
            } else {
                var event = config.event;
                var position = config.element.offset();
                var x = event.pageX - position.left;
                var y = event.pageY - position.top;
                left = x - waveSize / 2;
                top = y - waveSize / 2
            }
            return {
                left: left,
                top: top,
                height: waveSize,
                width: waveSize
            }
        };

        function showWave(args, config) {
            var $wave = getWaves(config.element, args.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            args.hidingTimeout && clearTimeout(args.hidingTimeout);
            hideSelectedWave($wave);
            $wave.css(getWaveStyleConfig(args, config));
            args.showingTimeout = setTimeout(showingWaveHandler.bind(this, args, $wave), 0)
        }

        function showingWaveHandler(args, $wave) {
            var durationCss = args.durations.showingScale + "ms";
            $wave.addClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss)
        }

        function getDurations(useHoldAnimation) {
            return {
                showingScale: useHoldAnimation ? HOLD_ANIMATION_DURATION : ANIMATION_DURATION,
                hidingScale: ANIMATION_DURATION,
                hidingOpacity: ANIMATION_DURATION
            }
        }

        function hideSelectedWave($wave) {
            $wave.removeClass(INKRIPPLE_HIDING_CLASS).css("transitionDuration", "")
        }

        function hideWave(args, config) {
            args.showingTimeout && clearTimeout(args.showingTimeout);
            var $wave = getWaves(config.element, config.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            var durations = args.durations;
            var durationCss = durations.hidingScale + "ms, " + durations.hidingOpacity + "ms";
            $wave.addClass(INKRIPPLE_HIDING_CLASS).removeClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss);
            var animationDuration = Math.max(durations.hidingScale, durations.hidingOpacity);
            args.hidingTimeout = setTimeout(hideSelectedWave.bind(this, $wave), animationDuration)
        }
        module.exports = {
            render: render
        }
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/pivot_grid/ui.pivot_grid.utils.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _ajax = __webpack_require__( /*! ../../core/utils/ajax */ 78);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 21);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _date = __webpack_require__( /*! ../../localization/date */ 35);
        var _format_helper = __webpack_require__( /*! ../../format_helper */ 68);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 58);
        var _array_store = __webpack_require__( /*! ../../data/array_store */ 70);
        var _array_store2 = _interopRequireDefault(_array_store);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var setFieldProperty = exports.setFieldProperty = function(field, property, value, isInitialization) {
            var initProperties = field._initProperties = field._initProperties || {};
            var initValue = isInitialization ? value : field[property];
            if (!Object.prototype.hasOwnProperty.call(initProperties, property) || isInitialization) {
                initProperties[property] = initValue
            }
            field[property] = value
        };
        exports.sendRequest = function(options) {
            return (0, _ajax.sendRequest)(options)
        };
        var foreachTreeAsyncDate = new Date;

        function createForeachTreeFunc(isAsync) {
            var foreachTreeFunc = function foreachTreeFunc(items, callback, parentAtFirst, members, index, isChildrenProcessing) {
                members = members || [];
                items = items || [];
                var i;
                var deferred;
                index = index || 0;

                function createForeachTreeAsyncHandler(deferred, i, isChildrenProcessing) {
                    (0, _deferred.when)(foreachTreeFunc(items, callback, parentAtFirst, members, i, isChildrenProcessing)).done(deferred.resolve)
                }
                for (i = index; i < items.length; i++) {
                    if (isAsync && i > index && i % 1e4 === 0 && new Date - foreachTreeAsyncDate >= 300) {
                        foreachTreeAsyncDate = new Date;
                        deferred = new _deferred.Deferred;
                        setTimeout(createForeachTreeAsyncHandler(deferred, i, false), 0);
                        return deferred
                    }
                    var item = items[i];
                    if (!isChildrenProcessing) {
                        members.unshift(item);
                        if (parentAtFirst && false === callback(members, i)) {
                            return
                        }
                        if (item.children) {
                            var childrenDeferred = foreachTreeFunc(item.children, callback, parentAtFirst, members);
                            if (isAsync && childrenDeferred) {
                                deferred = new _deferred.Deferred;
                                childrenDeferred.done(createForeachTreeAsyncHandler(deferred, i, true));
                                return deferred
                            }
                        }
                    }
                    isChildrenProcessing = false;
                    if (!parentAtFirst && false === callback(members, i)) {
                        return
                    }
                    members.shift();
                    if (items[i] !== item) {
                        i--
                    }
                }
            };
            return foreachTreeFunc
        }
        exports.foreachTree = createForeachTreeFunc(false);
        exports.foreachTreeAsync = createForeachTreeFunc(true);
        exports.findField = function(fields, id) {
            if (fields && (0, _type.isDefined)(id)) {
                for (var i = 0; i < fields.length; i++) {
                    var field = fields[i];
                    if (field.name === id || field.caption === id || field.dataField === id || field.index === id) {
                        return i
                    }
                }
            }
            return -1
        };
        exports.formatValue = function(value, options) {
            var valueText = value === value && (0, _format_helper.format)(value, options.format);
            var formatObject = {
                value: value,
                valueText: valueText || ""
            };
            return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
        };
        exports.getCompareFunction = function(valueSelector) {
            return function(a, b) {
                var result = 0;
                var valueA = valueSelector(a);
                var valueB = valueSelector(b);
                var aIsDefined = (0, _type.isDefined)(valueA);
                var bIsDefined = (0, _type.isDefined)(valueB);
                if (aIsDefined && bIsDefined) {
                    if (valueA > valueB) {
                        result = 1
                    } else {
                        if (valueA < valueB) {
                            result = -1
                        }
                    }
                }
                if (aIsDefined && !bIsDefined) {
                    result = 1
                }
                if (!aIsDefined && bIsDefined) {
                    result = -1
                }
                return result
            }
        };
        exports.createPath = function(items) {
            var result = [];
            for (var i = items.length - 1; i >= 0; i--) {
                result.push(items[i].key || items[i].value)
            }
            return result
        };
        exports.foreachDataLevel = function foreachDataLevel(data, callback, index, childrenField) {
            index = index || 0;
            childrenField = childrenField || "children";
            if (data.length) {
                callback(data, index)
            }
            for (var i = 0; i < data.length; i++) {
                var item = data[i];
                if (item[childrenField] && item[childrenField].length) {
                    foreachDataLevel(item[childrenField], callback, index + 1, childrenField)
                }
            }
        };
        exports.mergeArraysByMaxValue = function(values1, values2) {
            var result = [];
            for (var i = 0; i < values1.length; i++) {
                result.push(Math.max(values1[i] || 0, values2[i] || 0))
            }
            return result
        };
        exports.getExpandedLevel = function(options, axisName) {
            var dimensions = options[axisName];
            var expandLevel = 0;
            var expandedPaths = ("columns" === axisName ? options.columnExpandedPaths : options.rowExpandedPaths) || [];
            if (options.headerName === axisName) {
                expandLevel = options.path.length
            } else {
                if (options.headerName && options.headerName !== axisName && options.oppositePath) {
                    expandLevel = options.oppositePath.length
                } else {
                    (0, _iterator.each)(expandedPaths, function(_, path) {
                        expandLevel = Math.max(expandLevel, path.length)
                    })
                }
            }
            while (dimensions[expandLevel + 1] && dimensions[expandLevel].expanded) {
                expandLevel++
            }
            return expandLevel
        };

        function createGroupFields(item) {
            return (0, _iterator.map)(["year", "quarter", "month"], function(value, index) {
                return (0, _extend.extend)({}, item, {
                    groupInterval: value,
                    groupIndex: index
                })
            })
        }

        function parseFields(dataSource, fieldsList, path, fieldsDataType) {
            var result = [];
            Object.keys(fieldsList || []).forEach(function(field) {
                if (field && 0 === field.indexOf("__")) {
                    return
                }
                var dataIndex = 1;
                var currentPath = path.length ? path + "." + field : field;
                var dataType = fieldsDataType[currentPath];
                var getter = (0, _data.compileGetter)(currentPath);
                var value = fieldsList[field];
                var items;
                while (!(0, _type.isDefined)(value) && dataSource[dataIndex]) {
                    value = getter(dataSource[dataIndex]);
                    dataIndex++
                }
                if (!dataType && (0, _type.isDefined)(value)) {
                    dataType = (0, _type.type)(value)
                }
                items = [{
                    dataField: currentPath,
                    dataType: dataType,
                    groupName: "date" === dataType ? field : void 0,
                    groupInterval: void 0,
                    displayFolder: path
                }];
                if ("date" === dataType) {
                    items = items.concat(createGroupFields(items[0]))
                } else {
                    if ("object" === dataType) {
                        items = parseFields(dataSource, value, currentPath, fieldsDataType)
                    }
                }
                result.push.apply(result, items)
            });
            return result
        }
        exports.discoverObjectFields = function(items, fields) {
            var fieldsDataType = exports.getFieldsDataType(fields);
            return parseFields(items, items[0], "", fieldsDataType)
        };
        exports.getFieldsDataType = function(fields) {
            var result = {};
            (0, _iterator.each)(fields, function(_, field) {
                result[field.dataField] = result[field.dataField] || field.dataType
            });
            return result
        };
        var DATE_INTERVAL_FORMATS = {
            month: function(value) {
                return (0, _date.getMonthNames)()[value - 1]
            },
            quarter: function(value) {
                return (0, _date.format)(new Date(2e3, 3 * value - 1), "quarter")
            },
            dayOfWeek: function(value) {
                return (0, _date.getDayNames)()[value]
            }
        };
        exports.setDefaultFieldValueFormatting = function(field) {
            if ("date" === field.dataType) {
                if (!field.format) {
                    setFieldProperty(field, "format", DATE_INTERVAL_FORMATS[field.groupInterval])
                }
            } else {
                if ("number" === field.dataType) {
                    var groupInterval = (0, _type.isNumeric)(field.groupInterval) && field.groupInterval > 0 && field.groupInterval;
                    if (groupInterval && !field.customizeText) {
                        setFieldProperty(field, "customizeText", function(formatObject) {
                            var secondValue = formatObject.value + groupInterval;
                            var secondValueText = (0, _format_helper.format)(secondValue, field.format);
                            return formatObject.valueText && secondValueText ? formatObject.valueText + " - " + secondValueText : ""
                        })
                    }
                }
            }
        };
        exports.getFiltersByPath = function(fields, path) {
            var result = [];
            path = path || [];
            for (var i = 0; i < path.length; i++) {
                result.push((0, _extend.extend)({}, fields[i], {
                    groupIndex: null,
                    groupName: null,
                    filterType: "include",
                    filterValues: [path[i]]
                }))
            }
            return result
        };
        exports.storeDrillDownMixin = {
            createDrillDownDataSource: function(descriptions, params) {
                var items = this.getDrillDownItems(descriptions, params);
                var arrayStore;

                function createCustomStoreMethod(methodName) {
                    return function(options) {
                        var d;
                        if (arrayStore) {
                            d = arrayStore[methodName](options)
                        } else {
                            d = new _deferred.Deferred;
                            (0, _deferred.when)(items).done(function(data) {
                                var arrayStore = new _array_store2.default(data);
                                arrayStore[methodName](options).done(d.resolve).fail(d.reject)
                            }).fail(d.reject)
                        }
                        return d
                    }
                }
                var dataSource = new _data_source.DataSource({
                    load: createCustomStoreMethod("load"),
                    totalCount: createCustomStoreMethod("totalCount"),
                    key: this.key()
                });
                return dataSource
            }
        };
        exports.capitalizeFirstLetter = function(string) {
            return string.charAt(0).toUpperCase() + string.slice(1)
        }
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/selectors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _focusable = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase();
            var isTabIndexNotNaN = !isNaN(tabIndex);
            var isDisabled = element.disabled;
            var isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName);
            var isHyperlink = "a" === nodeName;
            var isFocusable = true;
            var isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };

        function visible(element) {
            var $element = $(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        }
        module.exports = {
            focusable: function(index, element) {
                return _focusable(element, $(element).attr("tabIndex"))
            },
            tabbable: function(index, element) {
                var tabIndex = $(element).attr("tabIndex");
                return (isNaN(tabIndex) || tabIndex >= 0) && _focusable(element, tabIndex)
            },
            focused: function($element) {
                var element = $($element).get(0);
                return domAdapter.getActiveElement() === element
            }
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/dom_component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _config = __webpack_require__( /*! ./config */ 32);
        var _config2 = _interopRequireDefault(_config);
        var _errors = __webpack_require__( /*! ./errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _resize_callbacks = __webpack_require__( /*! ../core/utils/resize_callbacks */ 125);
        var _resize_callbacks2 = _interopRequireDefault(_resize_callbacks);
        var _component = __webpack_require__( /*! ./component */ 126);
        var _component2 = _interopRequireDefault(_component);
        var _template_manager = __webpack_require__( /*! ./template_manager */ 477);
        var _template_manager2 = _interopRequireDefault(_template_manager);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 140);
        var _element_data = __webpack_require__( /*! ./element_data */ 44);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 4);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 11);
        var _common = __webpack_require__( /*! ./utils/common */ 3);
        var _array = __webpack_require__( /*! ./utils/array */ 13);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _short = __webpack_require__( /*! ../events/short */ 121);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _component2.default.abstract;
        var DOMComponent = _component2.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: (0, _config2.default)().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                }, this._useTemplates() ? _template_manager2.default.createDefaultOptions() : {})
            },
            ctor: function(element, options) {
                this._createElement(element);
                (0, _public_component.attachInstanceToElement)(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _createElement: function(element) {
                this._$element = (0, _renderer2.default)(element)
            },
            _getSynchronizableOptionsForCreateComponent: function() {
                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback();
                this._initTemplateManager()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    _resize_callbacks2.default.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                (0, _window.hasWindow)() && this._render()
            },
            _initMarkup: function() {
                var _ref = this.option() || {},
                    rtlEnabled = _ref.rtlEnabled;
                this._renderElementAttributes();
                this._toggleRTLDirection(rtlEnabled);
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var _ref2 = this.option() || {},
                    elementAttr = _ref2.elementAttr;
                var attributes = (0, _extend.extend)({}, elementAttr);
                var classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (this._isVisibilityChangeSupported()) {
                    var $element = this.$element();
                    $element.addClass("dx-visibility-change-handler")
                }
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: null === width ? "" : width,
                        height: null === height ? "" : height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!((0, _type.isDefined)(width) || (0, _type.isDefined)(height) || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var _this = this;
                var $el = this.$element();
                var namespace = "".concat(this.NAME, "VisibilityChange");
                _short.resize.off($el, {
                    namespace: namespace
                });
                _short.resize.on($el, function() {
                    return _this._dimensionChanged()
                }, {
                    namespace: namespace
                })
            },
            _attachVisibilityChangeHandlers: function() {
                var _this2 = this;
                if (this._isVisibilityChangeSupported()) {
                    var $el = this.$element();
                    var namespace = "".concat(this.NAME, "VisibilityChange");
                    this._isHidden = !this._isVisible();
                    _short.visibility.off($el, {
                        namespace: namespace
                    });
                    _short.visibility.on($el, function() {
                        return _this2._checkVisibilityChanged("shown")
                    }, function() {
                        return _this2._checkVisibilityChanged("hiding")
                    }, {
                        namespace: namespace
                    })
                }
            },
            _isVisible: function() {
                var $element = this.$element();
                return $element.is(":visible")
            },
            _checkVisibilityChanged: function(action) {
                var isVisible = this._isVisible();
                if (isVisible) {
                    if ("hiding" === action && !this._isHidden) {
                        this._visibilityChanged(false);
                        this._isHidden = true
                    } else {
                        if ("shown" === action && this._isHidden) {
                            this._isHidden = false;
                            this._visibilityChanged(true)
                        }
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && (0, _window.hasWindow)()
            },
            _clean: _common.noop,
            _modelByElement: function() {
                var _this$option = this.option(),
                    modelByElement = _this$option.modelByElement;
                var $element = this.$element();
                return modelByElement ? modelByElement($element) : void 0
            },
            _invalidate: function() {
                if (this._isUpdateAllowed()) {
                    throw _errors2.default.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this._templateManager && this._templateManager.dispose();
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    _resize_callbacks2.default.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                var $element = this.$element();
                $element.toggleClass("dx-rtl", rtl)
            },
            _createComponent: function(element, component) {
                var _this3 = this;
                var config = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                var synchronizableOptions = (0, _common.grep)(this._getSynchronizableOptionsForCreateComponent(), function(value) {
                    return !(value in config)
                });
                var _this$option2 = this.option(),
                    integrationOptions = _this$option2.integrationOptions;
                var _this$option3 = this.option(),
                    nestedComponentOptions = _this$option3.nestedComponentOptions;
                nestedComponentOptions = nestedComponentOptions || _common.noop;
                var nestedComponentConfig = (0, _extend.extend)({
                    integrationOptions: integrationOptions
                }, nestedComponentOptions(this));
                synchronizableOptions.forEach(function(optionName) {
                    return nestedComponentConfig[optionName] = _this3.option(optionName)
                });
                this._extendConfig(config, nestedComponentConfig);
                var instance = void 0;
                if ((0, _type.isString)(component)) {
                    var $element = (0, _renderer2.default)(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(_ref3) {
                        var name = _ref3.name,
                            value = _ref3.value;
                        if ((0, _array.inArray)(name, synchronizableOptions) >= 0) {
                            instance.option(name, value)
                        }
                    };
                    this.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        return _this3.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                (0, _iterator.each)(extendConfig, function(key, value) {
                    !Object.prototype.hasOwnProperty.call(config, key) && (config[key] = value)
                })
            },
            _defaultActionConfig: function() {
                var $element = this.$element();
                var context = this._modelByElement($element);
                return (0, _extend.extend)(this.callBase(), {
                    context: context
                })
            },
            _defaultActionArgs: function() {
                var $element = this.$element();
                var model = this._modelByElement($element);
                var element = this.element();
                return (0, _extend.extend)(this.callBase(), {
                    element: element,
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                        this._invalidate();
                        break;
                    case "elementAttr":
                        this._renderElementAttributes();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var attrs = element.attributes;
                for (var i = attrs.length - 1; i >= 0; i--) {
                    var attr = attrs[i];
                    if (attr) {
                        var name = attr.name;
                        if (!name.indexOf("aria-") || name.indexOf("dx-") !== -1 || "role" === name || "style" === name || "tabindex" === name) {
                            element.removeAttribute(name)
                        }
                    }
                }
            },
            _removeClasses: function(element) {
                element.className = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                }).join(" ")
            },
            _updateDOMComponent: function(renderRequired) {
                if (renderRequired) {
                    this._renderComponent()
                } else {
                    if (this._requireRefresh) {
                        this._requireRefresh = false;
                        this._refresh()
                    }
                }
            },
            endUpdate: function() {
                var renderRequired = this._isInitializingRequired();
                this.callBase();
                this._isUpdateAllowed() && this._updateDOMComponent(renderRequired)
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                var $element = this.$element();
                return (0, _dom.getPublicElement)($element)
            },
            dispose: function() {
                var element = this.$element().get(0);
                (0, _element_data.cleanDataRecursive)(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            },
            resetOption: function(optionName) {
                this.callBase(optionName);
                if ("width" === optionName || "height" === optionName) {
                    var initialOption = this.initialOption(optionName);
                    !(0, _type.isDefined)(initialOption) && this.$element().css(optionName, "")
                }
            },
            _getAnonymousTemplateName: function() {
                return
            },
            _initTemplateManager: function() {
                if (this._templateManager || !this._useTemplates()) {
                    return
                }
                var _this$option4 = this.option(),
                    _this$option4$integra = _this$option4.integrationOptions,
                    integrationOptions = void 0 === _this$option4$integra ? {} : _this$option4$integra;
                var createTemplate = integrationOptions.createTemplate;
                this._templateManager = new _template_manager2.default(createTemplate, this._getAnonymousTemplateName());
                this._initTemplates()
            },
            _initTemplates: function() {
                var _this4 = this;
                var _this$_templateManage = this._templateManager.extractTemplates(this.$element()),
                    templates = _this$_templateManage.templates,
                    anonymousTemplateMeta = _this$_templateManage.anonymousTemplateMeta;
                var anonymousTemplate = this.option("integrationOptions.templates.".concat(anonymousTemplateMeta.name));
                templates.forEach(function(_ref4) {
                    var name = _ref4.name,
                        template = _ref4.template;
                    _this4._options.silent("integrationOptions.templates.".concat(name), template)
                });
                if (anonymousTemplateMeta.name && !anonymousTemplate) {
                    this._options.silent("integrationOptions.templates.".concat(anonymousTemplateMeta.name), anonymousTemplateMeta.template)
                }
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                var templates = this.option("integrationOptions.templates");
                var isAsyncTemplate = this.option("templatesRenderAsynchronously");
                var skipTemplates = this.option("integrationOptions.skipTemplates");
                return this._templateManager.getTemplate(templateSource, templates, {
                    isAsyncTemplate: isAsyncTemplate,
                    skipTemplates: skipTemplates
                }, this)
            },
            _saveTemplate: function(name, template) {
                this._setOptionWithoutOptionChange("integrationOptions.templates." + name, this._templateManager._createTemplate(template))
            },
            _useTemplates: function() {
                return true
            }
        });
        DOMComponent.getInstance = function(element) {
            return (0, _public_component.getInstanceByElement)((0, _renderer2.default)(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        module.exports = DOMComponent
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/animation/position.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var commonUtils = __webpack_require__( /*! ../core/utils/common */ 3);
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12);
        var isWindow = __webpack_require__( /*! ../core/utils/type */ 1).isWindow;
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var getBoundingRect = __webpack_require__( /*! ../core/utils/position */ 22).getBoundingRect;
        var browser = __webpack_require__( /*! ../core/utils/browser */ 25);
        var translator = __webpack_require__( /*! ./translator */ 28);
        var support = __webpack_require__( /*! ../core/utils/support */ 45);
        var horzRe = /left|right/;
        var vertRe = /top|bottom/;
        var collisionRe = /fit|flip|none/;
        var IS_SAFARI = browser.safari;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = commonUtils.splitPair(raw);
            if (pair) {
                each(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return commonUtils.pairToObject(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = commonUtils.splitPair(raw);
            var h = String(pair && pair[0]).toLowerCase();
            var v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = extend({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = $("<div>").css({
                width: 100,
                height: 100,
                overflow: "scroll",
                position: "absolute",
                top: -9999
            }).appendTo($("body"));
            var result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = $(what);
            var currentOffset = $what.offset();
            var result = extend(true, {}, defaultPositionResult, {
                h: {
                    location: currentOffset.left
                },
                v: {
                    location: currentOffset.top
                }
            });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my);
            var at = normalizeAlign(options.at);
            var of = $(options.of).length && options.of || window;
            var offset = normalizeOffset(options.offset);
            var collision = normalizeCollision(options.collision);
            var boundary = options.boundary;
            var boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else {
                of = $( of );
                if (isWindow( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    h.atSize = of [0].innerWidth >= of [0].outerWidth ? of [0].innerWidth : of .width();
                    v.atSize = of [0].innerHeight >= of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : of .height()
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var ofRect = getBoundingRect( of .get(0));
                        var o = of .offset();
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = ofRect.width;
                        v.atSize = ofRect.height
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = $(window);
                var windowWidth = win.width();
                var windowHeight = win.height();
                var left = win.scrollLeft();
                var top = win.scrollTop();
                var documentElement = domAdapter.getDocumentElement();
                var hZoomLevel = support.touch ? documentElement.clientWidth / windowWidth : 1;
                var vZoomLevel = support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth;
                var boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = $(boundary);
                    var boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            extend(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var position = function(what, options) {
            var $what = $(what);
            if (!options) {
                return $what.offset()
            }
            translator.resetPosition($what, true);
            var offset = $what.offset();
            var targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            translator.move($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = $(element).get(0);
            if (isWindow(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return $(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        module.exports = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        }
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/format_helper.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./core/utils/type */ 1);
        var dateUtils = __webpack_require__( /*! ./core/utils/date */ 26);
        var numberLocalization = __webpack_require__( /*! ./localization/number */ 47);
        var dateLocalization = __webpack_require__( /*! ./localization/date */ 35);
        var dependencyInjector = __webpack_require__( /*! ./core/utils/dependency_injector */ 60);
        __webpack_require__( /*! ./localization/currency */ 118);
        module.exports = dependencyInjector({
            format: function(value, _format) {
                var formatIsValid = typeUtils.isString(_format) && "" !== _format || typeUtils.isPlainObject(_format) || typeUtils.isFunction(_format);
                var valueIsValid = typeUtils.isNumeric(value) || typeUtils.isDate(value);
                if (!formatIsValid || !valueIsValid) {
                    return typeUtils.isDefined(value) ? value.toString() : ""
                }
                if (typeUtils.isFunction(_format)) {
                    return _format(value)
                }
                if (typeUtils.isString(_format)) {
                    _format = {
                        type: _format
                    }
                }
                if (typeUtils.isNumeric(value)) {
                    return numberLocalization.format(value, _format)
                }
                if (typeUtils.isDate(value)) {
                    return dateLocalization.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return dateLocalization.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [];
                var needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return dateLocalization.getMonthNames("abbreviated")[date.getMonth()] + " " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return dateLocalization.format(date, "dayofweek") + ", " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var maxDiff;
                var currentDiff;
                var i;
                if (ticks.length > 1) {
                    maxDiff = dateUtils.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = dateUtils.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                var resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var dateUnitInterval;
                var dateDifferencesConverter = {
                    week: "day"
                };
                var correctDateDifferences = function(dateDifferences, tickInterval, value) {
                    switch (tickInterval) {
                        case "year":
                        case "quarter":
                            dateDifferences.month = value;
                        case "month":
                            dateDifferences.day = value;
                        case "week":
                        case "day":
                            dateDifferences.hour = value;
                        case "hour":
                            dateDifferences.minute = value;
                        case "minute":
                            dateDifferences.second = value;
                        case "second":
                            dateDifferences.millisecond = value
                    }
                };
                var correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                    if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                        if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                            differences.millisecond = true;
                            differences.second = false
                        }
                    } else {
                        if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                            if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                differences.second = true;
                                differences.minute = false
                            }
                        } else {
                            if (!maxDate.getMinutes() && maxDate.getHours()) {
                                if (maxDate.getHours() - minDate.getHours() === 1) {
                                    differences.minute = true;
                                    differences.hour = false
                                }
                            } else {
                                if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                    if (maxDate.getDate() - minDate.getDate() === 1) {
                                        differences.hour = true;
                                        differences.day = false
                                    }
                                } else {
                                    if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                        if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                            differences.day = true;
                                            differences.month = false
                                        }
                                    } else {
                                        if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                            if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                differences.month = true;
                                                differences.year = false
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                tickInterval = typeUtils.isString(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                var dateDifferences = dateUtils.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = dateUtils.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = dateUtils.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                var resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        })
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/data/data_source/utils.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.normalizeDataSourceOptions = exports.normalizeLoadResult = exports.mapDataRespectingGrouping = exports.normalizeStoreLoadOptionAccessorArguments = exports.isPending = exports.CANCELED_TOKEN = void 0;
        var _ajax = __webpack_require__( /*! ../../core/utils/ajax */ 78);
        var _abstract_store = __webpack_require__( /*! ../abstract_store */ 103);
        var _abstract_store2 = _interopRequireDefault(_abstract_store);
        var _array_store = __webpack_require__( /*! ../array_store */ 70);
        var _array_store2 = _interopRequireDefault(_array_store);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _custom_store = __webpack_require__( /*! ../custom_store */ 123);
        var _custom_store2 = _interopRequireDefault(_custom_store);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _utils = __webpack_require__( /*! ../utils */ 42);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        exports.CANCELED_TOKEN = "canceled";
        exports.isPending = function(deferred) {
            return "pending" === deferred.state()
        };
        exports.normalizeStoreLoadOptionAccessorArguments = function(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        };
        var mapGroup = function(group, level, mapper) {
            return (0, _iterator.map)(group, function(item) {
                var result = {
                    key: item.key,
                    items: mapRecursive(item.items, level - 1, mapper)
                };
                if ("aggregates" in item) {
                    result.aggregates = item.aggregates
                }
                return result
            })
        };
        var mapRecursive = function(items, level, mapper) {
            if (!Array.isArray(items)) {
                return items
            }
            return level ? mapGroup(items, level, mapper) : (0, _iterator.map)(items, mapper)
        };
        exports.mapDataRespectingGrouping = function(items, mapper, groupInfo) {
            var level = groupInfo ? (0, _utils.normalizeSortingInfo)(groupInfo).length : 0;
            return mapRecursive(items, level, mapper)
        };
        exports.normalizeLoadResult = function(data, extra) {
            var _data;
            if (null === (_data = data) || void 0 === _data ? void 0 : _data.data) {
                extra = data;
                data = data.data
            }
            if (!Array.isArray(data)) {
                data = [data]
            }
            return {
                data: data,
                extra: extra
            }
        };
        var createCustomStoreFromLoadFunc = function(options) {
            var storeConfig = {};
            (0, _iterator.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                storeConfig[this] = options[this];
                delete options[this]
            });
            return new _custom_store2.default(storeConfig)
        };
        var createStoreFromConfig = function(storeConfig) {
            var alias = storeConfig.type;
            delete storeConfig.type;
            return _abstract_store2.default.create(alias, storeConfig)
        };
        var createCustomStoreFromUrl = function(url, normalizationOptions) {
            return new _custom_store2.default({
                load: function() {
                    return (0, _ajax.sendRequest)({
                        url: url,
                        dataType: "json"
                    })
                },
                loadMode: null === normalizationOptions || void 0 === normalizationOptions ? void 0 : normalizationOptions.fromUrlLoadMode
            })
        };
        exports.normalizeDataSourceOptions = function(options, normalizationOptions) {
            var store;
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options, normalizationOptions)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof _abstract_store2.default) {
                options = {
                    store: options
                }
            } else {
                options = (0, _extend.extend)({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc(options)
            } else {
                if (Array.isArray(store)) {
                    store = new _array_store2.default(store)
                } else {
                    if ((0, _type.isPlainObject)(store)) {
                        store = createStoreFromConfig((0, _extend.extend)({}, store))
                    }
                }
            }
            options.store = store;
            return options
        }
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_store.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _utils = __webpack_require__( /*! ./utils */ 42);
        var _query = __webpack_require__( /*! ./query */ 46);
        var _query2 = _interopRequireDefault(_query);
        var _errors = __webpack_require__( /*! ./errors */ 40);
        var _abstract_store = __webpack_require__( /*! ./abstract_store */ 103);
        var _abstract_store2 = _interopRequireDefault(_abstract_store);
        var _array_utils = __webpack_require__( /*! ./array_utils */ 145);
        var _array_utils2 = _interopRequireDefault(_array_utils);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ArrayStore = _abstract_store2.default.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw _errors.errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return (0, _query2.default)(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = _array_utils2.default.indexByKey(this, this._array, key);
                if (index === -1) {
                    return (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                }
                return (0, _utils.trivialPromise)(this._array[index])
            },
            _insertImpl: function(values) {
                return _array_utils2.default.insert(this, this._array, values)
            },
            _pushImpl: function(changes) {
                _array_utils2.default.applyBatch(this, this._array, changes)
            },
            _updateImpl: function(key, values) {
                return _array_utils2.default.update(this, this._array, key, values)
            },
            _removeImpl: function(key) {
                return _array_utils2.default.remove(this, this._array, key)
            },
            clear: function() {
                this._eventsStrategy.fireEvent("modifying");
                this._array = [];
                this._eventsStrategy.fireEvent("modified")
            }
        }, "array");
        module.exports = ArrayStore
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/drag.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var dataUtils = __webpack_require__( /*! ../core/element_data */ 44);
        var wrapToArray = __webpack_require__( /*! ../core/utils/array */ 13).wrapToArray;
        var inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray;
        var iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var contains = __webpack_require__( /*! ../core/utils/dom */ 11).contains;
        var registerEvent = __webpack_require__( /*! ./core/event_registrator */ 79);
        var eventUtils = __webpack_require__( /*! ./utils */ 8);
        var GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 167);
        var registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 102);
        var DRAG_START_EVENT = "dxdragstart";
        var DRAG_EVENT = "dxdrag";
        var DRAG_END_EVENT = "dxdragend";
        var DRAG_ENTER_EVENT = "dxdragenter";
        var DRAG_LEAVE_EVENT = "dxdragleave";
        var DROP_EVENT = "dxdrop";
        var DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [];
        var knownDropTargetSelectors = [];
        var knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = inArray(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = inArray(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if (inArray(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = inArray(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    dataUtils.removeData(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        registerEvent(DRAG_ENTER_EVENT, dropTargetRegistration);
        registerEvent(DRAG_LEAVE_EVENT, dropTargetRegistration);
        registerEvent(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            var dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex].filter(function(selector) {
                return selector
            });
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if (inArray(void 0, knownDropTargetSelectors[dropTargetIndex]) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = GestureEmitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = wrapToArray(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return $(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = eventUtils.eventData(e);
                var dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e);
                var sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                eventUtils.fireEvent(eventData)
            },
            _findDropTarget: function(e) {
                var that = this;
                var result;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = $(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = $(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || contains(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, e) {
                var isDraggingElement = $target.get(0) === $(e.target).get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                if (config.checkDropTarget && !config.checkDropTarget($target, e)) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = eventUtils.eventData(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        registerEmitter({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        });
        exports.dropTargets = knownDropTargets;
        exports.move = DRAG_EVENT;
        exports.start = DRAG_START_EVENT;
        exports.end = DRAG_END_EVENT;
        exports.enter = DRAG_ENTER_EVENT;
        exports.leave = DRAG_LEAVE_EVENT;
        exports.drop = DROP_EVENT
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/console.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ./type */ 1).isFunction;
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !isFunction(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.logger = logger;
        exports.debug = debug
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/core/polyfills/promise.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var Deferred = deferredUtils.Deferred;
        var when = deferredUtils.when;
        var promise = windowUtils.hasWindow() ? windowUtils.getWindow().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        module.exports = promise
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/view_port.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../renderer */ 2);
        var readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 54);
        var ready = readyCallbacks.add;
        var changeCallback = __webpack_require__( /*! ./callbacks */ 27)();
        var $originalViewPort = $();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = $(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : $("body");
                changeCallback.fire(isNewViewportFound ? value() : $(), prevViewPort)
            }
        }();
        ready(function() {
            value(".dx-viewport")
        });
        exports.value = value;
        exports.changeCallback = changeCallback;
        exports.originalViewPort = function() {
            return $originalViewPort
        }
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/ui/scroll_view/ui.scrollable.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _support = __webpack_require__( /*! ../../core/utils/support */ 45);
        var _support2 = _interopRequireDefault(_support);
        var _browser = __webpack_require__( /*! ../../core/utils/browser */ 25);
        var _browser2 = _interopRequireDefault(_browser);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _common2 = _interopRequireDefault(_common);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom = __webpack_require__( /*! ../../core/utils/dom */ 11);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _devices = __webpack_require__( /*! ../../core/devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _component_registrator = __webpack_require__( /*! ../../core/component_registrator */ 9);
        var _component_registrator2 = _interopRequireDefault(_component_registrator);
        var _dom_component = __webpack_require__( /*! ../../core/dom_component */ 66);
        var _dom_component2 = _interopRequireDefault(_dom_component);
        var _selectors = __webpack_require__( /*! ../widget/selectors */ 65);
        var _selectors2 = _interopRequireDefault(_selectors);
        var _utils = __webpack_require__( /*! ../../events/utils */ 8);
        var eventUtils = _interopRequireWildcard(_utils);
        var _uiEventsEmitterGesture = __webpack_require__( /*! ./ui.events.emitter.gesture.scroll */ 230);
        var _uiEventsEmitterGesture2 = _interopRequireDefault(_uiEventsEmitterGesture);
        var _uiScrollable = __webpack_require__( /*! ./ui.scrollable.simulated */ 293);
        var _uiScrollable2 = _interopRequireDefault(_uiScrollable);
        var _uiScrollable3 = __webpack_require__( /*! ./ui.scrollable.native */ 203);
        var _uiScrollable4 = _interopRequireDefault(_uiScrollable3);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var SCROLLABLE = "dxScrollable";
        var SCROLLABLE_STRATEGY = "dxScrollableStrategy";
        var SCROLLABLE_CLASS = "dx-scrollable";
        var SCROLLABLE_DISABLED_CLASS = "dx-scrollable-disabled";
        var SCROLLABLE_CONTAINER_CLASS = "dx-scrollable-container";
        var SCROLLABLE_WRAPPER_CLASS = "dx-scrollable-wrapper";
        var SCROLLABLE_CONTENT_CLASS = "dx-scrollable-content";
        var VERTICAL = "vertical";
        var HORIZONTAL = "horizontal";
        var BOTH = "both";
        var deviceDependentOptions = function() {
            return [{
                device: function() {
                    return !_support2.default.nativeScrolling
                },
                options: {
                    useNative: false
                }
            }, {
                device: function(_device) {
                    return !_devices2.default.isSimulator() && "desktop" === _devices2.default.real().deviceType && "generic" === _device.platform
                },
                options: {
                    bounceEnabled: false,
                    scrollByThumb: true,
                    scrollByContent: _support2.default.touch,
                    showScrollbar: "onHover"
                }
            }]
        };
        var Scrollable = _dom_component2.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    disabled: false,
                    onScroll: null,
                    direction: VERTICAL,
                    showScrollbar: "onScroll",
                    useNative: true,
                    bounceEnabled: true,
                    scrollByContent: true,
                    scrollByThumb: false,
                    onUpdated: null,
                    onStart: null,
                    onEnd: null,
                    onBounce: null,
                    onStop: null,
                    useSimulatedScrollbar: false,
                    useKeyboard: true,
                    inertiaEnabled: true,
                    pushBackValue: 0,
                    updateManually: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat(deviceDependentOptions(), [{
                    device: function() {
                        return _support2.default.nativeScrolling && "android" === _devices2.default.real().platform && !_browser2.default.mozilla
                    },
                    options: {
                        useSimulatedScrollbar: true
                    }
                }, {
                    device: function() {
                        return "ios" === _devices2.default.real().platform
                    },
                    options: {
                        pushBackValue: 1
                    }
                }])
            },
            _initOptions: function(options) {
                this.callBase(options);
                if (!("useSimulatedScrollbar" in options)) {
                    this._setUseSimulatedScrollbar()
                }
            },
            _setUseSimulatedScrollbar: function() {
                if (!this.initialOption("useSimulatedScrollbar")) {
                    this.option("useSimulatedScrollbar", !this.option("useNative"))
                }
            },
            _init: function() {
                this.callBase();
                this._initScrollableMarkup();
                this._locked = false
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    this.update();
                    this._updateRtlPosition();
                    this._savedScrollOffset && this.scrollTo(this._savedScrollOffset);
                    delete this._savedScrollOffset
                } else {
                    this._savedScrollOffset = this.scrollOffset()
                }
            },
            _initScrollableMarkup: function() {
                var $element = this.$element().addClass(SCROLLABLE_CLASS);
                var $container = this._$container = (0, _renderer2.default)("<div>").addClass(SCROLLABLE_CONTAINER_CLASS);
                var $wrapper = this._$wrapper = (0, _renderer2.default)("<div>").addClass(SCROLLABLE_WRAPPER_CLASS);
                var $content = this._$content = (0, _renderer2.default)("<div>").addClass(SCROLLABLE_CONTENT_CLASS);
                if (_dom_adapter2.default.hasDocumentProperty("onbeforeactivate") && _browser2.default.msie && _browser2.default.version < 12) {
                    _events_engine2.default.on($element, eventUtils.addNamespace("beforeactivate", SCROLLABLE), function(e) {
                        if (!(0, _renderer2.default)(e.target).is(_selectors2.default.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
                $content.append($element.contents()).appendTo($container);
                $container.appendTo($wrapper);
                $wrapper.appendTo($element)
            },
            _dimensionChanged: function() {
                this.update()
            },
            _initMarkup: function() {
                this.callBase();
                this._renderDirection()
            },
            _render: function() {
                this._renderStrategy();
                this._attachEventHandlers();
                this._renderDisabledState();
                this._createActions();
                this.update();
                this.callBase();
                this._updateRtlPosition()
            },
            _updateRtlPosition: function() {
                var _this = this;
                this._updateBounds();
                if (this.option("rtlEnabled") && this.option("direction") !== VERTICAL) {
                    _common2.default.deferUpdate(function() {
                        var containerElement = _this._container().get(0);
                        var maxLeftOffset = containerElement.scrollWidth - containerElement.clientWidth;
                        _common2.default.deferRender(function() {
                            _this.scrollTo({
                                left: maxLeftOffset
                            })
                        })
                    })
                }
            },
            _updateBounds: function() {
                this._strategy.updateBounds()
            },
            _attachEventHandlers: function() {
                var strategy = this._strategy;
                var initEventData = {
                    getDirection: strategy.getDirection.bind(strategy),
                    validate: this._validate.bind(this),
                    isNative: this.option("useNative"),
                    scrollTarget: this._$container
                };
                _events_engine2.default.off(this._$wrapper, "." + SCROLLABLE);
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.init, SCROLLABLE), initEventData, this._initHandler.bind(this));
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.start, SCROLLABLE), strategy.handleStart.bind(strategy));
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.move, SCROLLABLE), strategy.handleMove.bind(strategy));
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.end, SCROLLABLE), strategy.handleEnd.bind(strategy));
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.cancel, SCROLLABLE), strategy.handleCancel.bind(strategy));
                _events_engine2.default.on(this._$wrapper, eventUtils.addNamespace(_uiEventsEmitterGesture2.default.stop, SCROLLABLE), strategy.handleStop.bind(strategy));
                _events_engine2.default.off(this._$container, "." + SCROLLABLE);
                _events_engine2.default.on(this._$container, eventUtils.addNamespace("scroll", SCROLLABLE), strategy.handleScroll.bind(strategy))
            },
            _validate: function(e) {
                if (this._isLocked()) {
                    return false
                }
                this._updateIfNeed();
                return this._strategy.validate(e)
            },
            _initHandler: function() {
                var strategy = this._strategy;
                strategy.handleInit.apply(strategy, arguments)
            },
            _renderDisabledState: function() {
                this.$element().toggleClass(SCROLLABLE_DISABLED_CLASS, this.option("disabled"));
                if (this.option("disabled")) {
                    this._lock()
                } else {
                    this._unlock()
                }
            },
            _renderDirection: function() {
                this.$element().removeClass("dx-scrollable-" + HORIZONTAL).removeClass("dx-scrollable-" + VERTICAL).removeClass("dx-scrollable-" + BOTH).addClass("dx-scrollable-" + this.option("direction"))
            },
            _renderStrategy: function() {
                this._createStrategy();
                this._strategy.render();
                this.$element().data(SCROLLABLE_STRATEGY, this._strategy)
            },
            _createStrategy: function() {
                this._strategy = this.option("useNative") ? new _uiScrollable4.default(this) : new _uiScrollable2.default.SimulatedStrategy(this)
            },
            _createActions: function() {
                this._strategy && this._strategy.createActions()
            },
            _clean: function() {
                this._strategy && this._strategy.dispose()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onStart":
                    case "onEnd":
                    case "onStop":
                    case "onUpdated":
                    case "onScroll":
                    case "onBounce":
                        this._createActions();
                        break;
                    case "direction":
                        this._resetInactiveDirection();
                        this._invalidate();
                        break;
                    case "useNative":
                        this._setUseSimulatedScrollbar();
                        this._invalidate();
                        break;
                    case "inertiaEnabled":
                    case "scrollByContent":
                    case "scrollByThumb":
                    case "bounceEnabled":
                    case "useKeyboard":
                    case "showScrollbar":
                    case "useSimulatedScrollbar":
                    case "pushBackValue":
                        this._invalidate();
                        break;
                    case "disabled":
                        this._renderDisabledState();
                        this._strategy && this._strategy.disabledChanged();
                        break;
                    case "updateManually":
                        break;
                    case "width":
                        this.callBase(args);
                        this._updateRtlPosition();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _resetInactiveDirection: function() {
                var inactiveProp = this._getInactiveProp();
                if (!inactiveProp || !_window2.default.hasWindow()) {
                    return
                }
                var scrollOffset = this.scrollOffset();
                scrollOffset[inactiveProp] = 0;
                this.scrollTo(scrollOffset)
            },
            _getInactiveProp: function() {
                var direction = this.option("direction");
                if (direction === VERTICAL) {
                    return "left"
                }
                if (direction === HORIZONTAL) {
                    return "top"
                }
            },
            _location: function() {
                return this._strategy.location()
            },
            _normalizeLocation: function(location) {
                if (_type2.default.isPlainObject(location)) {
                    var left = _common2.default.ensureDefined(location.left, location.x);
                    var top = _common2.default.ensureDefined(location.top, location.y);
                    return {
                        left: _type2.default.isDefined(left) ? -left : void 0,
                        top: _type2.default.isDefined(top) ? -top : void 0
                    }
                } else {
                    var direction = this.option("direction");
                    return {
                        left: direction !== VERTICAL ? -location : void 0,
                        top: direction !== HORIZONTAL ? -location : void 0
                    }
                }
            },
            _isLocked: function() {
                return this._locked
            },
            _lock: function() {
                this._locked = true
            },
            _unlock: function() {
                if (!this.option("disabled")) {
                    this._locked = false
                }
            },
            _isDirection: function(direction) {
                var current = this.option("direction");
                if (direction === VERTICAL) {
                    return current !== HORIZONTAL
                }
                if (direction === HORIZONTAL) {
                    return current !== VERTICAL
                }
                return current === direction
            },
            _updateAllowedDirection: function() {
                var allowedDirections = this._strategy._allowedDirections();
                if (this._isDirection(BOTH) && allowedDirections.vertical && allowedDirections.horizontal) {
                    this._allowedDirectionValue = BOTH
                } else {
                    if (this._isDirection(HORIZONTAL) && allowedDirections.horizontal) {
                        this._allowedDirectionValue = HORIZONTAL
                    } else {
                        if (this._isDirection(VERTICAL) && allowedDirections.vertical) {
                            this._allowedDirectionValue = VERTICAL
                        } else {
                            this._allowedDirectionValue = null
                        }
                    }
                }
            },
            _allowedDirection: function() {
                return this._allowedDirectionValue
            },
            _container: function() {
                return this._$container
            },
            $content: function() {
                return this._$content
            },
            content: function() {
                return (0, _dom.getPublicElement)(this._$content)
            },
            scrollOffset: function() {
                var location = this._location();
                return {
                    top: -location.top,
                    left: -location.left
                }
            },
            scrollTop: function() {
                return this.scrollOffset().top
            },
            scrollLeft: function() {
                return this.scrollOffset().left
            },
            clientHeight: function() {
                return this._$container.height()
            },
            scrollHeight: function() {
                return this.$content().outerHeight() - 2 * this._strategy.verticalOffset()
            },
            clientWidth: function() {
                return this._$container.width()
            },
            scrollWidth: function() {
                return this.$content().outerWidth()
            },
            update: function() {
                if (!this._strategy) {
                    return
                }
                return (0, _deferred.when)(this._strategy.update()).done(function() {
                    this._updateAllowedDirection()
                }.bind(this))
            },
            scrollBy: function(distance) {
                distance = this._normalizeLocation(distance);
                if (!distance.top && !distance.left) {
                    return
                }
                this._updateIfNeed();
                this._strategy.scrollBy(distance)
            },
            scrollTo: function(targetLocation) {
                targetLocation = this._normalizeLocation(targetLocation);
                this._updateIfNeed();
                var location = this._location();
                if (!this.option("useNative")) {
                    targetLocation = this._strategy._applyScaleRatio(targetLocation);
                    location = this._strategy._applyScaleRatio(location)
                }
                var distance = this._normalizeLocation({
                    left: location.left - _common2.default.ensureDefined(targetLocation.left, location.left),
                    top: location.top - _common2.default.ensureDefined(targetLocation.top, location.top)
                });
                if (!distance.top && !distance.left) {
                    return
                }
                this._strategy.scrollBy(distance)
            },
            scrollToElement: function(element, offset) {
                var $element = (0, _renderer2.default)(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    scrollPosition.left = this.getScrollElementPosition($element, HORIZONTAL, offset)
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this.getScrollElementPosition($element, VERTICAL, offset)
                }
                this.scrollTo(scrollPosition)
            },
            scrollToElementTopLeft: function(element) {
                var $element = (0, _renderer2.default)(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    var leftPosition = this._elementPositionRelativeToContent($element, "left");
                    scrollPosition.left = true === this.option("rtlEnabled") ? leftPosition + $element.width() - this.clientWidth() : leftPosition
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this._elementPositionRelativeToContent($element, "top")
                }
                this.scrollTo(scrollPosition)
            },
            getScrollElementPosition: function($element, direction, offset) {
                offset = offset || {};
                var isVertical = direction === VERTICAL;
                var startOffset = (isVertical ? offset.top : offset.left) || 0;
                var endOffset = (isVertical ? offset.bottom : offset.right) || 0;
                var pushBackOffset = isVertical ? this._strategy.verticalOffset() : 0;
                var elementPositionRelativeToContent = this._elementPositionRelativeToContent($element, isVertical ? "top" : "left");
                var elementPosition = elementPositionRelativeToContent - pushBackOffset;
                var elementSize = $element[isVertical ? "outerHeight" : "outerWidth"]();
                var scrollLocation = isVertical ? this.scrollTop() : this.scrollLeft();
                var clientSize = isVertical ? this.clientHeight() : this.clientWidth();
                var startDistance = scrollLocation - elementPosition + startOffset;
                var endDistance = scrollLocation - elementPosition - elementSize + clientSize - endOffset;
                if (startDistance <= 0 && endDistance >= 0) {
                    return scrollLocation
                }
                return scrollLocation - (Math.abs(startDistance) > Math.abs(endDistance) ? endDistance : startDistance)
            },
            _elementPositionRelativeToContent: function($element, prop) {
                var result = 0;
                while (this._hasScrollContent($element)) {
                    result += $element.position()[prop];
                    $element = $element.offsetParent()
                }
                return result
            },
            _hasScrollContent: function($element) {
                var $content = this.$content();
                return $element.closest($content).length && !$element.is($content)
            },
            _updateIfNeed: function() {
                if (!this.option("updateManually")) {
                    this.update()
                }
            },
            _useTemplates: function() {
                return false
            }
        });
        (0, _component_registrator2.default)(SCROLLABLE, Scrollable);
        module.exports = Scrollable;
        module.exports.deviceDependentOptions = deviceDependentOptions
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/viz/tree_map/tree_map.base.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _common = __webpack_require__( /*! ./common */ 266);
        var _node = __webpack_require__( /*! ./node */ 187);
        var _node2 = _interopRequireDefault(_node);
        var _tiling = __webpack_require__( /*! ./tiling */ 135);
        var _colorizing = __webpack_require__( /*! ./colorizing */ 136);
        var _utils = __webpack_require__( /*! ../core/utils */ 15);
        var _common2 = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 0);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _max = Math.max;
        var directions = {
            lefttoprightbottom: [1, 1],
            leftbottomrighttop: [1, -1],
            righttopleftbottom: [-1, 1],
            rightbottomlefttop: [-1, -1]
        };
        __webpack_require__( /*! ./tiling.squarified */ 441);
        __webpack_require__( /*! ./tiling */ 135).setDefaultAlgorithm("squarified");
        __webpack_require__( /*! ./colorizing.discrete */ 443);
        __webpack_require__( /*! ./colorizing */ 136).setDefaultColorizer("discrete");

        function pickPositiveInteger(val) {
            return val > 0 ? Math.round(val) : 0
        }
        var dxTreeMap = __webpack_require__( /*! ../core/base_widget */ 109).inherit({
            _handlers: {
                beginBuildNodes: _common2.noop,
                buildNode: _common2.noop,
                endBuildNodes: _common2.noop,
                setTrackerData: _common2.noop,
                calculateState: function(options) {
                    return (0, _common.buildRectAppearance)(options)
                }
            },
            _rootClass: "dxtm-tree-map",
            _rootClassPrefix: "dxtm",
            _getDefaultSize: function() {
                return {
                    width: 400,
                    height: 400
                }
            },
            _setDeprecatedOptions: function() {
                this.callBase.apply(this, arguments);
                (0, _extend2.extend)(this._deprecatedOptions, {
                    resolveLabelOverflow: {
                        since: "19.1",
                        message: "Use the 'tile.label.overflow' and 'group.label.textOverflow' option instead"
                    }
                })
            },
            _themeSection: "treeMap",
            _fontFields: ["tile.label.font", "group.label.font"],
            _init: function() {
                var that = this;
                that._rectOffsets = {};
                that._handlers = Object.create(that._handlers);
                that._context = {
                    suspend: function() {
                        if (!that._applyingChanges) {
                            that._suspendChanges()
                        }
                    },
                    resume: function() {
                        if (!that._applyingChanges) {
                            that._resumeChanges()
                        }
                    },
                    change: function(codes) {
                        that._change(codes)
                    },
                    settings: [{}, {}],
                    calculateState: that._handlers.calculateState,
                    calculateLabelState: _common.buildTextAppearance
                };
                that._root = that._topNode = {
                    nodes: []
                };
                that.callBase.apply(that, arguments)
            },
            _initialChanges: ["DATA_SOURCE"],
            _initCore: function() {
                var that = this;
                var renderer = that._renderer;
                that._createProxyType();
                that._tilesGroup = renderer.g().linkOn(renderer.root, "tiles").linkAppend();
                that._labelsGroup = renderer.g().linkOn(renderer.root, "labels").linkAppend()
            },
            _createProxyType: _common2.noop,
            _disposeCore: function() {
                var that = this;
                that._filter && that._filter.dispose();
                that._labelsGroup.linkOff();
                that._tilesGroup.linkOff()
            },
            _applySize: function(rect) {
                this._tilingRect = rect.slice();
                this._change(["TILING"])
            },
            _optionChangesMap: {
                dataSource: "DATA_SOURCE",
                valueField: "NODES_CREATE",
                childrenField: "NODES_CREATE",
                colorField: "TILES",
                colorizer: "TILES",
                labelField: "LABELS",
                tile: "TILE_SETTINGS",
                group: "GROUP_SETTINGS",
                maxDepth: "MAX_DEPTH",
                layoutAlgorithm: "TILING",
                layoutDirection: "TILING",
                resolveLabelOverflow: "LABEL_OVERFLOW"
            },
            _themeDependentChanges: ["TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH"],
            _changeDataSource: function() {
                var that = this;
                that._isDataExpected = that._isSyncData = true;
                that._updateDataSource();
                that._isSyncData = false;
                if (that._isDataExpected) {
                    that._suspendChanges()
                }
            },
            _dataSourceChangedHandler: function() {
                var that = this;
                if (that._isDataExpected) {
                    that._isDataExpected = false;
                    that._change(["NODES_CREATE"]);
                    if (!that._isSyncData) {
                        that._resumeChanges()
                    }
                } else {
                    that._requestChange(["NODES_CREATE"])
                }
            },
            _optionChangesOrder: ["DATA_SOURCE", "TILE_SETTINGS", "GROUP_SETTINGS", "MAX_DEPTH", "LABEL_OVERFLOW"],
            _change_DATA_SOURCE: function() {
                this._changeDataSource()
            },
            _change_TILE_SETTINGS: function() {
                this._changeTileSettings()
            },
            _change_GROUP_SETTINGS: function() {
                this._changeGroupSettings()
            },
            _change_LABEL_OVERFLOW: function() {
                this._changeTileSettings();
                this._changeGroupSettings()
            },
            _change_MAX_DEPTH: function() {
                this._changeMaxDepth()
            },
            _customChangesOrder: ["NODES_CREATE", "NODES_RESET", "TILES", "LABELS", "TILING", "LABELS_LAYOUT"],
            _change_NODES_CREATE: function() {
                this._buildNodes()
            },
            _change_NODES_RESET: function() {
                this._resetNodes()
            },
            _change_TILES: function() {
                this._applyTilesAppearance()
            },
            _change_LABELS: function() {
                this._applyLabelsAppearance()
            },
            _change_TILING: function() {
                this._performTiling()
            },
            _change_LABELS_LAYOUT: function() {
                this._performLabelsLayout()
            },
            _applyChanges: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                if (!that._isDataExpected) {
                    that._drawn()
                }
                that._context.forceReset = false
            },
            _buildNodes: function() {
                var that = this;
                var root = that._root = that._topNode = new _node2.default;
                root._id = 0;
                root.parent = {};
                root.data = {};
                root.level = root.index = -1;
                root.ctx = that._context;
                root.label = null;
                that._nodes = [root];
                that._handlers.beginBuildNodes();
                var processedData = that._processDataSourceItems(that._dataSourceItems() || []);
                traverseDataItems(root, processedData.items, 0, {
                    itemsField: !processedData.isPlain && that._getOption("childrenField", true) || "items",
                    valueField: that._getOption("valueField", true) || "value",
                    buildNode: that._handlers.buildNode,
                    ctx: that._context,
                    nodes: that._nodes
                });
                that._onNodesCreated();
                that._handlers.endBuildNodes();
                that._change(["NODES_RESET"])
            },
            _onNodesCreated: _common2.noop,
            _processDataSourceItems: function(items) {
                return {
                    items: items,
                    isPlain: false
                }
            },
            _changeTileSettings: function() {
                var that = this;
                var options = that._getOption("tile");
                var offsets = that._rectOffsets;
                var borderWidth = pickPositiveInteger(options.border.width);
                var edgeOffset = borderWidth / 2;
                var innerOffset = 1 & borderWidth ? .5 : 0;
                var labelOptions = options.label;
                var settings = that._context.settings[0];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._filter = that._filter || that._renderer.shadowFilter("-50%", "-50%", "200%", "200%");
                that._filter.attr(labelOptions.shadow);
                that._calculateLabelSettings(settings, labelOptions, that._filter.id);
                if (offsets.tileEdge !== edgeOffset || offsets.tileInner !== innerOffset) {
                    offsets.tileEdge = edgeOffset;
                    offsets.tileInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _changeGroupSettings: function() {
                var that = this;
                var options = that._getOption("group");
                var labelOptions = options.label;
                var offsets = that._rectOffsets;
                var borderWidth = pickPositiveInteger(options.border.width);
                var edgeOffset = borderWidth / 2;
                var innerOffset = 1 & borderWidth ? .5 : 0;
                var headerHeight = 0;
                var groupPadding = pickPositiveInteger(options.padding);
                var settings = that._context.settings[1];
                that._change(["TILES", "LABELS"]);
                settings.state = that._handlers.calculateState(options);
                that._calculateLabelSettings(settings, labelOptions);
                if (options.headerHeight >= 0) {
                    headerHeight = pickPositiveInteger(options.headerHeight)
                } else {
                    headerHeight = settings.labelParams.height + 2 * pickPositiveInteger(labelOptions.paddingTopBottom)
                }
                if (that._headerHeight !== headerHeight) {
                    that._headerHeight = headerHeight;
                    that._change(["TILING"])
                }
                if (that._groupPadding !== groupPadding) {
                    that._groupPadding = groupPadding;
                    that._change(["TILING"])
                }
                if (offsets.headerEdge !== edgeOffset || offsets.headerInner !== innerOffset) {
                    offsets.headerEdge = edgeOffset;
                    offsets.headerInner = innerOffset;
                    that._change(["TILING"])
                }
            },
            _calculateLabelSettings: function(settings, options, filter) {
                var bBox = this._getTextBBox(options.font);
                var paddingLeftRight = pickPositiveInteger(options.paddingLeftRight);
                var paddingTopBottom = pickPositiveInteger(options.paddingTopBottom);
                var tileLabelOptions = this._getOption("tile.label");
                var groupLabelOptions = this._getOption("group.label");
                settings.labelState = (0, _common.buildTextAppearance)(options, filter);
                settings.labelState.visible = !("visible" in options) || !!options.visible;
                settings.labelParams = {
                    height: bBox.height,
                    rtlEnabled: this._getOption("rtlEnabled", true),
                    paddingTopBottom: paddingTopBottom,
                    paddingLeftRight: paddingLeftRight,
                    resolveLabelOverflow: this._options.silent("resolveLabelOverflow"),
                    tileLabelWordWrap: tileLabelOptions.wordWrap,
                    tileLabelOverflow: tileLabelOptions.textOverflow,
                    groupLabelOverflow: groupLabelOptions.textOverflow
                }
            },
            _changeMaxDepth: function() {
                var maxDepth = this._getOption("maxDepth", true);
                maxDepth = maxDepth >= 1 ? Math.round(maxDepth) : 1 / 0;
                if (this._maxDepth !== maxDepth) {
                    this._maxDepth = maxDepth;
                    this._change(["NODES_RESET"])
                }
            },
            _resetNodes: function() {
                var that = this;
                that._tilesGroup.clear();
                that._renderer.initHatching();
                that._context.forceReset = true;
                that._context.minLevel = that._topNode.level + 1;
                that._context.maxLevel = that._context.minLevel + that._maxDepth - 1;
                that._change(["TILES", "LABELS", "TILING"])
            },
            _processNodes: function(context, process) {
                processNodes(context, this._topNode, process)
            },
            _applyTilesAppearance: function() {
                var that = this;
                var colorizer = (0, _colorizing.getColorizer)(that._getOption("colorizer"), that._themeManager, that._topNode);
                that._processNodes({
                    renderer: that._renderer,
                    group: that._tilesGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    colorField: that._getOption("colorField", true) || "color",
                    getColor: colorizer
                }, processTileAppearance)
            },
            _applyLabelsAppearance: function() {
                var that = this;
                that._labelsGroup.clear();
                that._processNodes({
                    renderer: that._renderer,
                    group: that._labelsGroup,
                    setTrackerData: that._handlers.setTrackerData,
                    labelField: that._getOption("labelField", true) || "name"
                }, processLabelAppearance);
                that._change(["LABELS_LAYOUT"])
            },
            _performTiling: function() {
                var that = this;
                var context = {
                    algorithm: (0, _tiling.getAlgorithm)(that._getOption("layoutAlgorithm", true)),
                    directions: directions[String(that._getOption("layoutDirection", true)).toLowerCase()] || directions.lefttoprightbottom,
                    headerHeight: that._headerHeight,
                    groupPadding: that._groupPadding,
                    rectOffsets: that._rectOffsets
                };
                that._topNode.innerRect = that._tilingRect;
                calculateRects(context, that._topNode);
                that._processNodes(context, processTiling);
                that._change(["LABELS_LAYOUT"]);
                that._onTilingPerformed()
            },
            _onTilingPerformed: _common2.noop,
            _performLabelsLayout: function() {
                this._processNodes(null, processLabelsLayout)
            },
            _getTextBBox: function(fontOptions) {
                var renderer = this._renderer;
                var text = this._textForCalculations || renderer.text("0", 0, 0);
                this._textForCalculations = text;
                text.css((0, _utils.patchFontOptions)(fontOptions)).append(renderer.root);
                var bBox = text.getBBox();
                text.remove();
                return bBox
            }
        });

        function traverseDataItems(root, dataItems, level, params) {
            var nodes = [];
            var allNodes = params.nodes;
            var node;
            var i;
            var ii = dataItems.length;
            var dataItem;
            var totalValue = 0;
            var items;
            for (i = 0; i < ii; ++i) {
                var _items;
                dataItem = dataItems[i];
                node = new _node2.default;
                node._id = allNodes.length;
                node.ctx = params.ctx;
                node.parent = root;
                node.level = level;
                node.index = nodes.length;
                node.data = dataItem;
                params.buildNode(node);
                allNodes.push(node);
                nodes.push(node);
                items = dataItem[params.itemsField];
                if (null === (_items = items) || void 0 === _items ? void 0 : _items.length) {
                    traverseDataItems(node, items, level + 1, params)
                }
                if (dataItem[params.valueField] > 0) {
                    node.value = Number(dataItem[params.valueField])
                }
                totalValue += node.value
            }
            root.nodes = nodes;
            root.value = totalValue
        }

        function processNodes(context, root, process) {
            var nodes = root.nodes;
            var node;
            var i;
            var ii = nodes.length;
            for (i = 0; i < ii; ++i) {
                node = nodes[i];
                process(context, node);
                if (node.isNode()) {
                    processNodes(context, node, process)
                }
            }
        }
        var createTile = [createLeaf, createGroup];

        function processTileAppearance(context, node) {
            node.color = node.data[context.colorField] || context.getColor(node) || node.parent.color;
            node.updateStyles();
            node.tile = !node.ctx.forceReset && node.tile || createTile[Number(node.isNode())](context, node);
            node.applyState()
        }

        function createLeaf(context, node) {
            var tile = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, tile);
            return tile
        }

        function createGroup(context, node) {
            var outer = context.renderer.simpleRect().append(context.group);
            var inner = context.renderer.simpleRect().append(context.group);
            context.setTrackerData(node, inner);
            return {
                outer: outer,
                inner: inner
            }
        }

        function processLabelAppearance(context, node) {
            node.updateLabelStyle();
            if (node.labelState.visible) {
                createLabel(context, node, node.labelState, node.labelParams)
            }
        }

        function createLabel(context, currentNode, settings, params) {
            var textData = currentNode.data[context.labelField];
            currentNode.label = textData ? String(textData) : null;
            textData = currentNode.customLabel || currentNode.label;
            if (textData) {
                currentNode.text = context.renderer.text(textData).attr(settings.attr).css(settings.css).append(context.group);
                context.setTrackerData(currentNode, currentNode.text)
            }
        }
        var emptyRect = [0, 0, 0, 0];

        function calculateRects(context, root) {
            var nodes = root.nodes;
            var items = [];
            var rects = [];
            var sum = 0;
            var i;
            var ii = items.length = rects.length = nodes.length;
            for (i = 0; i < ii; ++i) {
                sum += nodes[i].value;
                items[i] = {
                    value: nodes[i].value,
                    i: i
                }
            }
            if (sum > 0) {
                context.algorithm({
                    items: items.slice(),
                    sum: sum,
                    rect: root.innerRect.slice(),
                    isRotated: 1 & nodes[0].level,
                    directions: context.directions
                })
            }
            for (i = 0; i < ii; ++i) {
                rects[i] = items[i].rect || emptyRect
            }
            root.rects = rects
        }

        function processTiling(context, node) {
            var rect = node.parent.rects[node.index];
            var rectOffsets = context.rectOffsets;
            var headerHeight;
            if (node.isNode()) {
                setRectAttrs(node.tile.outer, buildTileRect(rect, node.parent.innerRect, rectOffsets.headerEdge, rectOffsets.headerInner));
                rect = marginateRect(rect, context.groupPadding);
                headerHeight = Math.min(context.headerHeight, rect[3] - rect[1]);
                node.rect = [rect[0], rect[1], rect[2], rect[1] + headerHeight];
                setRectAttrs(node.tile.inner, marginateRect(node.rect, rectOffsets.headerEdge));
                rect[1] += headerHeight;
                node.innerRect = rect;
                calculateRects(context, node)
            } else {
                node.rect = rect;
                setRectAttrs(node.tile, buildTileRect(rect, node.parent.innerRect, rectOffsets.tileEdge, rectOffsets.tileInner))
            }
        }

        function marginateRect(rect, margin) {
            return [rect[0] + margin, rect[1] + margin, rect[2] - margin, rect[3] - margin]
        }

        function buildTileRect(rect, outer, edgeOffset, innerOffset) {
            return [rect[0] + (rect[0] === outer[0] ? edgeOffset : +innerOffset), rect[1] + (rect[1] === outer[1] ? edgeOffset : +innerOffset), rect[2] - (rect[2] === outer[2] ? edgeOffset : -innerOffset), rect[3] - (rect[3] === outer[3] ? edgeOffset : -innerOffset)]
        }

        function setRectAttrs(element, rect) {
            element.attr({
                x: rect[0],
                y: rect[1],
                width: _max(rect[2] - rect[0], 0),
                height: _max(rect[3] - rect[1], 0)
            })
        }

        function processLabelsLayout(context, node) {
            if (node.text && node.labelState.visible) {
                layoutTextNode(node, node.labelParams)
            }
        }

        function layoutTextNode(node, params) {
            var rect = node.rect;
            var text = node.text;
            var bBox = text.getBBox();
            var paddingLeftRight = params.paddingLeftRight;
            var paddingTopBottom = params.paddingTopBottom;
            var effectiveWidth = rect[2] - rect[0] - 2 * paddingLeftRight;
            var fitByHeight = bBox.height + paddingTopBottom <= rect[3] - rect[1];
            var fitByWidth = bBox.width <= effectiveWidth;
            var resolveLabelOverflow = params.resolveLabelOverflow;
            var groupLabelOverflow = params.groupLabelOverflow;
            var tileLabelOverflow = params.tileLabelOverflow;
            var tileLabelWordWrap = params.tileLabelWordWrap;
            if ((0, _type.isDefined)(resolveLabelOverflow)) {
                if ("ellipsis" === resolveLabelOverflow && fitByHeight) {
                    text.setMaxSize(effectiveWidth, void 0, {
                        wordWrap: "none",
                        textOverflow: "ellipsis"
                    });
                    if (!fitByWidth) {
                        bBox = text.getBBox();
                        fitByWidth = bBox.width <= effectiveWidth
                    }
                }
            } else {
                fitByWidth = true;
                fitByHeight = true;
                text.setMaxSize(effectiveWidth, rect[3] - rect[1] - paddingTopBottom, node.isNode() ? {
                    textOverflow: groupLabelOverflow,
                    wordWrap: "none"
                } : {
                    textOverflow: tileLabelOverflow,
                    wordWrap: tileLabelWordWrap,
                    hideOverflowEllipsis: true
                })
            }
            text.attr({
                visibility: fitByHeight && fitByWidth ? "visible" : "hidden"
            });
            if (fitByHeight && fitByWidth) {
                text.move(params.rtlEnabled ? rect[2] - paddingLeftRight - bBox.x - bBox.width : rect[0] + paddingLeftRight - bBox.x, rect[1] + paddingTopBottom - bBox.y)
            }
        }
        __webpack_require__( /*! ../../core/component_registrator */ 9)("dxTreeMap", dxTreeMap);
        module.exports = dxTreeMap;
        dxTreeMap.addPlugin(__webpack_require__( /*! ../core/data_source */ 157).plugin)
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ajax.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Deferred = __webpack_require__( /*! ./deferred */ 6).Deferred;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var httpRequest = __webpack_require__( /*! ../../core/http_request */ 467);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var extendFromObject = __webpack_require__( /*! ./extend */ 0).extendFromObject;
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined;
        var Promise = __webpack_require__( /*! ../polyfills/promise */ 74);
        var injector = __webpack_require__( /*! ./dependency_injector */ 60);
        var SUCCESS = "success";
        var ERROR = "error";
        var TIMEOUT = "timeout";
        var NO_CONTENT = "nocontent";
        var PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = domAdapter.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return domAdapter.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new Promise(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    domAdapter.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*";
            var scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript";
            var accepts = {
                "*": "*/*",
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript",
                jsonp: scriptAccept,
                script: scriptAccept
            };
            extendFromObject(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!windowUtils.hasWindow()) {
                return true
            }
            var crossDomain = false;
            var originAnchor = domAdapter.createElement("a");
            var urlAnchor = domAdapter.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, "");
                var callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random;
                var callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data;
            var paramsAlreadyString = "string" === typeof params;
            var url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };

        function getMethod(options) {
            return (options.method || "GET").toUpperCase()
        }
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var xhr = httpRequest.getXhr();
            var d = new Deferred;
            var result = d.promise();
            var async = isDefined(options.async) ? options.async : true;
            var dataType = options.dataType;
            var timeout = options.timeout || 0;
            var timeoutId;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options);
            var headers = getRequestHeaders(options);
            var requestOptions = getRequestOptions(options, headers);
            var url = requestOptions.url;
            var parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                    d.reject(xhr, ERROR)
                };
                var resolve = function() {
                    if ("jsonp" === dataType) {
                        return
                    }
                    d.resolve(null, SUCCESS, xhr)
                };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (Object.prototype.hasOwnProperty.call(headers, name) && isDefined(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        module.exports = injector({
            sendRequest: sendRequest
        })
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _event_registrator_callbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 139);
        var _event_registrator_callbacks2 = _interopRequireDefault(_event_registrator_callbacks);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }(0, _iterator.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            _event_registrator_callbacks2.default.fire(name, strategy)
        };
        registerEvent.callbacks = _event_registrator_callbacks2.default;
        module.exports = registerEvent
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/template_base.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.TemplateBase = exports.renderedCallbacks = void 0;
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _dom_adapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var _callbacks = __webpack_require__( /*! ../utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _dom = __webpack_require__( /*! ../utils/dom */ 11);
        var _errors = __webpack_require__( /*! ../errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var renderedCallbacks = exports.renderedCallbacks = (0, _callbacks2.default)({
            syncStrategy: true
        });
        exports.TemplateBase = function() {
            function TemplateBase() {
                _classCallCheck(this, TemplateBase)
            }
            _createClass(TemplateBase, [{
                key: "render",
                value: function(options) {
                    options = options || {};
                    var onRendered = options.onRendered;
                    delete options.onRendered;
                    var $result = this._renderCore(options);
                    this._ensureResultInContainer($result, options.container);
                    renderedCallbacks.fire($result, options.container);
                    onRendered && onRendered();
                    return $result
                }
            }, {
                key: "_ensureResultInContainer",
                value: function($result, container) {
                    if (!container) {
                        return
                    }
                    var $container = (0, _renderer2.default)(container);
                    var resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                    $container.append($result);
                    if (resultInContainer) {
                        return
                    }
                    var resultInBody = (0, _dom_adapter.getBody)().contains($container.get(0));
                    if (!resultInBody) {
                        return
                    }(0, _dom.triggerShownEvent)($result)
                }
            }, {
                key: "_renderCore",
                value: function() {
                    throw _errors2.default.Error("E0001")
                }
            }]);
            return TemplateBase
        }()
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/call_once.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        module.exports = callOnce
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/store_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var grep = __webpack_require__( /*! ../core/utils/common */ 3).grep;
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var arrayQuery = __webpack_require__( /*! ./array_query */ 168);
        var normalizeSortingInfo = __webpack_require__( /*! ./utils */ 42).normalizeSortingInfo;

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return extend({}, g, {
                        items: multiLevelGroup(arrayQuery(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            each(groupInfo, function(_, group) {
                var collision = grep(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter;
            if (filter) {
                query = query.filter(filter)
            }
            if (isCountQuery) {
                return query
            }
            var sort = options.sort;
            var select = options.select;
            var group = options.group;
            var skip = options.skip;
            var take = options.take;
            if (group) {
                group = normalizeSortingInfo(group);
                group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
            }
            if (sort || group) {
                sort = normalizeSortingInfo(sort || []);
                if (group && !group.keepInitialKeyOrder) {
                    sort = arrangeSortingInfo(group, sort)
                }
                each(sort, function(index) {
                    query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                })
            }
            if (select) {
                query = query.select(select)
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (take || skip) {
                query = query.slice(skip || 0, take)
            }
            return query
        }
        module.exports = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data_helper.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DataSource = __webpack_require__( /*! ./data/data_source/data_source */ 58).DataSource;
        var extend = __webpack_require__( /*! ./core/utils/extend */ 0).extend;
        var normalizeDataSourceOptions = __webpack_require__( /*! ./data/data_source/utils */ 69).normalizeDataSourceOptions;
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions";
        var DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler";
        var DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler";
        var DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler";
        var DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode";
        var SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var NORMALIZE_DATA_SOURCE = "_normalizeDataSource";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                var widgetDataSourceOptions;
                var dataSourceType;
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : DataSource;
                        dataSourceOptions = normalizeDataSourceOptions(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType(extend(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    if (NORMALIZE_DATA_SOURCE in this) {
                        this._dataSource = this[NORMALIZE_DATA_SOURCE](this._dataSource)
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function(e) {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items(), e)
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        module.exports = DataHelperMixin
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/ui/text_box.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./text_box/text_box */ 494)
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/ui/validation_engine.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _class = __webpack_require__( /*! ../core/class */ 16);
        var _class2 = _interopRequireDefault(_class);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../core/utils/array */ 13);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 4);
        var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 101);
        var _errors = __webpack_require__( /*! ../core/errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);
        var _common = __webpack_require__( /*! ../core/utils/common */ 3);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _number = __webpack_require__( /*! ../localization/number */ 47);
        var _number2 = _interopRequireDefault(_number);
        var _message = __webpack_require__( /*! ../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _promise = __webpack_require__( /*! ../core/polyfills/promise */ 74);
        var _promise2 = _interopRequireDefault(_promise);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var STATUS = {
            valid: "valid",
            invalid: "invalid",
            pending: "pending"
        };
        var BaseRuleValidator = function() {
            function BaseRuleValidator() {
                _classCallCheck(this, BaseRuleValidator);
                this.NAME = "base"
            }
            _createClass(BaseRuleValidator, [{
                key: "defaultMessage",
                value: function(value) {
                    return _message2.default.getFormatter("validation-".concat(this.NAME))(value)
                }
            }, {
                key: "defaultFormattedMessage",
                value: function(value) {
                    return _message2.default.getFormatter("validation-".concat(this.NAME, "-formatted"))(value)
                }
            }, {
                key: "_isValueEmpty",
                value: function(value) {
                    return !rulesValidators.required.validate(value, {})
                }
            }, {
                key: "validate",
                value: function(value, rule) {
                    var _this = this;
                    var valueArray = Array.isArray(value) ? value : [value];
                    var result = true;
                    if (valueArray.length) {
                        valueArray.every(function(itemValue) {
                            result = _this._validate(itemValue, rule);
                            return result
                        })
                    } else {
                        result = this._validate(null, rule)
                    }
                    return result
                }
            }]);
            return BaseRuleValidator
        }();
        var RequiredRuleValidator = function(_BaseRuleValidator) {
            _inherits(RequiredRuleValidator, _BaseRuleValidator);
            var _super = _createSuper(RequiredRuleValidator);

            function RequiredRuleValidator() {
                var _this2;
                _classCallCheck(this, RequiredRuleValidator);
                _this2 = _super.call(this);
                _this2.NAME = "required";
                return _this2
            }
            _createClass(RequiredRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!_type2.default.isDefined(value)) {
                        return false
                    }
                    if (false === value) {
                        return false
                    }
                    value = String(value);
                    if (rule.trim || !_type2.default.isDefined(rule.trim)) {
                        value = value.trim()
                    }
                    return "" !== value
                }
            }]);
            return RequiredRuleValidator
        }(BaseRuleValidator);
        var NumericRuleValidator = function(_BaseRuleValidator2) {
            _inherits(NumericRuleValidator, _BaseRuleValidator2);
            var _super2 = _createSuper(NumericRuleValidator);

            function NumericRuleValidator() {
                var _this3;
                _classCallCheck(this, NumericRuleValidator);
                _this3 = _super2.call(this);
                _this3.NAME = "numeric";
                return _this3
            }
            _createClass(NumericRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    if (rule.useCultureSettings && _type2.default.isString(value)) {
                        return !isNaN(_number2.default.parse(value))
                    } else {
                        return _type2.default.isNumeric(value)
                    }
                }
            }]);
            return NumericRuleValidator
        }(BaseRuleValidator);
        var RangeRuleValidator = function(_BaseRuleValidator3) {
            _inherits(RangeRuleValidator, _BaseRuleValidator3);
            var _super3 = _createSuper(RangeRuleValidator);

            function RangeRuleValidator() {
                var _this4;
                _classCallCheck(this, RangeRuleValidator);
                _this4 = _super3.call(this);
                _this4.NAME = "range";
                return _this4
            }
            _createClass(RangeRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validNumber = rulesValidators.numeric.validate(value, rule);
                    var validValue = _type2.default.isDefined(value) && "" !== value;
                    var number = validNumber ? parseFloat(value) : validValue && value.valueOf();
                    var min = rule.min;
                    var max = rule.max;
                    if (!(validNumber || _type2.default.isDate(value)) && !validValue) {
                        return false
                    }
                    if (_type2.default.isDefined(min)) {
                        if (_type2.default.isDefined(max)) {
                            return number >= min && number <= max
                        }
                        return number >= min
                    } else {
                        if (_type2.default.isDefined(max)) {
                            return number <= max
                        } else {
                            throw _errors2.default.Error("E0101")
                        }
                    }
                }
            }]);
            return RangeRuleValidator
        }(BaseRuleValidator);
        var StringLengthRuleValidator = function(_BaseRuleValidator4) {
            _inherits(StringLengthRuleValidator, _BaseRuleValidator4);
            var _super4 = _createSuper(StringLengthRuleValidator);

            function StringLengthRuleValidator() {
                var _this5;
                _classCallCheck(this, StringLengthRuleValidator);
                _this5 = _super4.call(this);
                _this5.NAME = "stringLength";
                return _this5
            }
            _createClass(StringLengthRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    value = _type2.default.isDefined(value) ? String(value) : "";
                    if (rule.trim || !_type2.default.isDefined(rule.trim)) {
                        value = value.trim()
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.range.validate(value.length, (0, _extend.extend)({}, rule))
                }
            }]);
            return StringLengthRuleValidator
        }(BaseRuleValidator);
        var CustomRuleValidator = function(_BaseRuleValidator5) {
            _inherits(CustomRuleValidator, _BaseRuleValidator5);
            var _super5 = _createSuper(CustomRuleValidator);

            function CustomRuleValidator() {
                var _this6;
                _classCallCheck(this, CustomRuleValidator);
                _this6 = _super5.call(this);
                _this6.NAME = "custom";
                return _this6
            }
            _createClass(CustomRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && _type2.default.isFunction(validator.option) && validator.option("dataGetter");
                    var extraParams = _type2.default.isFunction(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    return rule.validationCallback(params)
                }
            }]);
            return CustomRuleValidator
        }(BaseRuleValidator);
        var AsyncRuleValidator = function(_CustomRuleValidator) {
            _inherits(AsyncRuleValidator, _CustomRuleValidator);
            var _super6 = _createSuper(AsyncRuleValidator);

            function AsyncRuleValidator() {
                var _this7;
                _classCallCheck(this, AsyncRuleValidator);
                _this7 = _super6.call(this);
                _this7.NAME = "async";
                return _this7
            }
            _createClass(AsyncRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (!_type2.default.isDefined(rule.reevaluate)) {
                        (0, _extend.extend)(rule, {
                            reevaluate: true
                        })
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator;
                    var dataGetter = validator && _type2.default.isFunction(validator.option) && validator.option("dataGetter");
                    var extraParams = _type2.default.isFunction(dataGetter) && dataGetter();
                    var params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    var callbackResult = rule.validationCallback(params);
                    if (!_type2.default.isPromise(callbackResult)) {
                        throw _errors2.default.Error("E0103")
                    }
                    return this._getWrappedPromise((0, _deferred.fromPromise)(callbackResult).promise())
                }
            }, {
                key: "_getWrappedPromise",
                value: function(promise) {
                    var deferred = new _deferred.Deferred;
                    promise.then(function(res) {
                        deferred.resolve(res)
                    }, function(err) {
                        var res = {
                            isValid: false
                        };
                        if (_type2.default.isDefined(err)) {
                            if (_type2.default.isString(err)) {
                                res.message = err
                            } else {
                                if (_type2.default.isObject(err) && _type2.default.isDefined(err.message) && _type2.default.isString(err.message)) {
                                    res.message = err.message
                                }
                            }
                        }
                        deferred.resolve(res)
                    });
                    return deferred.promise()
                }
            }]);
            return AsyncRuleValidator
        }(CustomRuleValidator);
        var CompareRuleValidator = function(_BaseRuleValidator6) {
            _inherits(CompareRuleValidator, _BaseRuleValidator6);
            var _super7 = _createSuper(CompareRuleValidator);

            function CompareRuleValidator() {
                var _this8;
                _classCallCheck(this, CompareRuleValidator);
                _this8 = _super7.call(this);
                _this8.NAME = "compare";
                return _this8
            }
            _createClass(CompareRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!rule.comparisonTarget) {
                        throw _errors2.default.Error("E0102")
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }(0, _extend.extend)(rule, {
                        reevaluate: true
                    });
                    var otherValue = rule.comparisonTarget();
                    var type = rule.comparisonType || "==";
                    switch (type) {
                        case "==":
                            return value == otherValue;
                        case "!=":
                            return value != otherValue;
                        case "===":
                            return value === otherValue;
                        case "!==":
                            return value !== otherValue;
                        case ">":
                            return value > otherValue;
                        case ">=":
                            return value >= otherValue;
                        case "<":
                            return value < otherValue;
                        case "<=":
                            return value <= otherValue
                    }
                }
            }]);
            return CompareRuleValidator
        }(BaseRuleValidator);
        var PatternRuleValidator = function(_BaseRuleValidator7) {
            _inherits(PatternRuleValidator, _BaseRuleValidator7);
            var _super8 = _createSuper(PatternRuleValidator);

            function PatternRuleValidator() {
                var _this9;
                _classCallCheck(this, PatternRuleValidator);
                _this9 = _super8.call(this);
                _this9.NAME = "pattern";
                return _this9
            }
            _createClass(PatternRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var pattern = rule.pattern;
                    if (_type2.default.isString(pattern)) {
                        pattern = new RegExp(pattern)
                    }
                    return pattern.test(value)
                }
            }]);
            return PatternRuleValidator
        }(BaseRuleValidator);
        var EmailRuleValidator = function(_BaseRuleValidator8) {
            _inherits(EmailRuleValidator, _BaseRuleValidator8);
            var _super9 = _createSuper(EmailRuleValidator);

            function EmailRuleValidator() {
                var _this10;
                _classCallCheck(this, EmailRuleValidator);
                _this10 = _super9.call(this);
                _this10.NAME = "email";
                return _this10
            }
            _createClass(EmailRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.pattern.validate(value, (0, _extend.extend)({}, rule, {
                        pattern: /^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i
                    }))
                }
            }]);
            return EmailRuleValidator
        }(BaseRuleValidator);
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            async: new AsyncRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = _class2.default.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = [];
                this._pendingValidators = [];
                this._onValidatorStatusChanged = this._onValidatorStatusChanged.bind(this);
                this._resetValidationInfo();
                this._eventsStrategy = new _events_strategy.EventsStrategy(this)
            },
            validate: function() {
                var _this11 = this;
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: [],
                    status: STATUS.valid,
                    complete: null
                };
                this._unsubscribeFromAllChangeEvents();
                this._pendingValidators = [];
                this._resetValidationInfo();
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRules) {
                        result.brokenRules = result.brokenRules.concat(validatorResult.brokenRules)
                    }
                    result.validators.push(validator);
                    if (validatorResult.status === STATUS.pending) {
                        _this11._addPendingValidator(validator)
                    }
                    _this11._subscribeToChangeEvents(validator)
                });
                if (this._pendingValidators.length) {
                    result.status = STATUS.pending
                } else {
                    result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                    this._unsubscribeFromAllChangeEvents();
                    this._raiseValidatedEvent(result)
                }
                this._updateValidationInfo(result);
                return (0, _extend.extend)({}, this._validationInfo.result)
            },
            _subscribeToChangeEvents: function(validator) {
                validator.on("validating", this._onValidatorStatusChanged);
                validator.on("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromChangeEvents: function(validator) {
                validator.off("validating", this._onValidatorStatusChanged);
                validator.off("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromAllChangeEvents: function() {
                var _this12 = this;
                (0, _iterator.each)(this.validators, function(_, validator) {
                    _this12._unsubscribeFromChangeEvents(validator)
                })
            },
            _updateValidationInfo: function(result) {
                this._validationInfo.result = result;
                if (result.status !== STATUS.pending) {
                    return
                }
                if (!this._validationInfo.deferred) {
                    this._validationInfo.deferred = new _deferred.Deferred;
                    this._validationInfo.result.complete = this._validationInfo.deferred.promise()
                }
            },
            _addPendingValidator: function(validator) {
                var foundValidator = (0, _common.grep)(this._pendingValidators, function(val) {
                    return val === validator
                })[0];
                if (!foundValidator) {
                    this._pendingValidators.push(validator)
                }
            },
            _removePendingValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this._pendingValidators);
                if (index >= 0) {
                    this._pendingValidators.splice(index, 1)
                }
            },
            _orderBrokenRules: function(brokenRules) {
                var orderedRules = [];
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var foundRules = (0, _common.grep)(brokenRules, function(rule) {
                        return rule.validator === validator
                    });
                    if (foundRules.length) {
                        orderedRules = orderedRules.concat(foundRules)
                    }
                });
                return orderedRules
            },
            _updateBrokenRules: function(result) {
                if (!this._validationInfo.result) {
                    return
                }
                var brokenRules = this._validationInfo.result.brokenRules;
                var rules = (0, _common.grep)(brokenRules, function(rule) {
                    return rule.validator !== result.validator
                });
                if (result.brokenRules) {
                    brokenRules = rules.concat(result.brokenRules)
                }
                this._validationInfo.result.brokenRules = this._orderBrokenRules(brokenRules)
            },
            _onValidatorStatusChanged: function(result) {
                if (result.status === STATUS.pending) {
                    this._addPendingValidator(result.validator);
                    return
                }
                this._resolveIfComplete(result)
            },
            _resolveIfComplete: function(result) {
                this._removePendingValidator(result.validator);
                this._updateBrokenRules(result);
                if (!this._pendingValidators.length) {
                    this._unsubscribeFromAllChangeEvents();
                    if (!this._validationInfo.result) {
                        return
                    }
                    this._validationInfo.result.status = 0 === this._validationInfo.result.brokenRules.length ? STATUS.valid : STATUS.invalid;
                    this._validationInfo.result.isValid = this._validationInfo.result.status === STATUS.valid;
                    var res = (0, _extend.extend)({}, this._validationInfo.result, {
                        complete: null
                    });
                    var deferred = this._validationInfo.deferred;
                    this._resetValidationInfo();
                    this._raiseValidatedEvent(res);
                    deferred && setTimeout(function() {
                        deferred.resolve(res)
                    })
                }
            },
            _raiseValidatedEvent: function(result) {
                this._eventsStrategy.fireEvent("validated", [result])
            },
            _resetValidationInfo: function() {
                this._validationInfo = {
                    result: null,
                    deferred: null
                }
            },
            _synchronizeValidationInfo: function() {
                if (this._validationInfo.result) {
                    this._validationInfo.result.validators = this.validators
                }
            },
            removeRegisteredValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this.validators);
                if (index > -1) {
                    this.validators.splice(index, 1);
                    this._synchronizeValidationInfo();
                    this._resolveIfComplete({
                        validator: validator
                    })
                }
            },
            registerValidator: function(validator) {
                if ((0, _array.inArray)(validator, this.validators) < 0) {
                    this.validators.push(validator);
                    this._synchronizeValidationInfo()
                }
            },
            reset: function() {
                (0, _iterator.each)(this.validators, function(_, validator) {
                    validator.reset()
                });
                this._pendingValidators = [];
                this._resetValidationInfo()
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = (0, _common.grep)(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            findGroup: function($element, model) {
                var $dxGroup = $element.parents(".dx-validationgroup").first();
                if ($dxGroup.length) {
                    return $dxGroup.dxValidationGroup("instance")
                }
                return model
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group);
                var index = (0, _array.inArray)(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(info) {
                var rule = info.rule,
                    validator = info.validator,
                    name = info.name;
                if (!_type2.default.isDefined(rule.message)) {
                    if (validator.defaultFormattedMessage && _type2.default.isDefined(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            _addBrokenRule: function(info) {
                var result = info.result,
                    rule = info.rule;
                if (!result.brokenRule) {
                    result.brokenRule = rule
                }
                if (!result.brokenRules) {
                    result.brokenRules = []
                }
                result.brokenRules.push(rule)
            },
            validate: function(value, rules, name) {
                var _this13 = this;
                var result = {
                    name: name,
                    value: value,
                    brokenRule: null,
                    brokenRules: null,
                    isValid: true,
                    validationRules: rules,
                    pendingRules: null,
                    status: STATUS.valid,
                    complete: null
                };
                var asyncRuleItems = [];
                (0, _iterator.each)(rules || [], function(_, rule) {
                    var ruleValidator = rulesValidators[rule.type];
                    var ruleValidationResult;
                    if (ruleValidator) {
                        if (_type2.default.isDefined(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                _this13._addBrokenRule({
                                    result: result,
                                    rule: rule
                                });
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        if ("async" === rule.type) {
                            asyncRuleItems.push({
                                rule: rule,
                                ruleValidator: ruleValidator
                            });
                            return true
                        }
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            _this13._setDefaultMessage({
                                rule: rule,
                                validator: ruleValidator,
                                name: name
                            });
                            _this13._addBrokenRule({
                                result: result,
                                rule: rule
                            })
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw _errors2.default.Error("E0100")
                    }
                });
                if (result.isValid && !result.brokenRules && asyncRuleItems.length) {
                    result = this._validateAsyncRules({
                        value: value,
                        items: asyncRuleItems,
                        result: result,
                        name: name
                    })
                }
                result.status = result.pendingRules ? STATUS.pending : result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            _validateAsyncRules: function(_ref) {
                var _this14 = this;
                var result = _ref.result,
                    value = _ref.value,
                    items = _ref.items,
                    name = _ref.name;
                var asyncResults = [];
                (0, _iterator.each)(items, function(_, item) {
                    var validateResult = item.ruleValidator.validate(value, item.rule);
                    if (!_type2.default.isPromise(validateResult)) {
                        _this14._updateRuleConfig({
                            rule: item.rule,
                            ruleResult: _this14._getPatchedRuleResult(validateResult),
                            validator: item.ruleValidator,
                            name: name
                        })
                    } else {
                        if (!result.pendingRules) {
                            result.pendingRules = []
                        }
                        result.pendingRules.push(item.rule);
                        var asyncResult = validateResult.then(function(res) {
                            var ruleResult = _this14._getPatchedRuleResult(res);
                            _this14._updateRuleConfig({
                                rule: item.rule,
                                ruleResult: ruleResult,
                                validator: item.ruleValidator,
                                name: name
                            });
                            return ruleResult
                        });
                        asyncResults.push(asyncResult)
                    }
                });
                if (asyncResults.length) {
                    result.complete = _promise2.default.all(asyncResults).then(function(values) {
                        return _this14._getAsyncRulesResult({
                            result: result,
                            values: values
                        })
                    })
                }
                return result
            },
            _updateRuleConfig: function(_ref2) {
                var rule = _ref2.rule,
                    ruleResult = _ref2.ruleResult,
                    validator = _ref2.validator,
                    name = _ref2.name;
                rule.isValid = ruleResult.isValid;
                if (!ruleResult.isValid) {
                    if (_type2.default.isDefined(ruleResult.message) && _type2.default.isString(ruleResult.message) && ruleResult.message.length) {
                        rule.message = ruleResult.message
                    } else {
                        this._setDefaultMessage({
                            rule: rule,
                            validator: validator,
                            name: name
                        })
                    }
                }
            },
            _getPatchedRuleResult: function(ruleResult) {
                var result;
                var isValid = true;
                if (_type2.default.isObject(ruleResult)) {
                    result = (0, _extend.extend)({}, ruleResult);
                    if (!_type2.default.isDefined(result.isValid)) {
                        result.isValid = isValid
                    }
                } else {
                    result = {
                        isValid: _type2.default.isBoolean(ruleResult) ? ruleResult : isValid
                    }
                }
                return result
            },
            _getAsyncRulesResult: function(_ref3) {
                var _this15 = this;
                var values = _ref3.values,
                    result = _ref3.result;
                (0, _iterator.each)(values, function(index, val) {
                    if (false === val.isValid) {
                        result.isValid = val.isValid;
                        var rule = result.pendingRules[index];
                        _this15._addBrokenRule({
                            result: result,
                            rule: rule
                        })
                    }
                });
                result.pendingRules = null;
                result.complete = null;
                result.status = result.isValid ? STATUS.valid : STATUS.invalid;
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                groupConfig.registerValidator.call(groupConfig, validator)
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group;
                var isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group);
                if (config) {
                    config.removeRegisteredValidator.call(config, validator);
                    var validatorsInGroup = config.validators;
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            initValidationOptions: function(options) {
                var _this16 = this;
                var initedOptions = {};
                if (options) {
                    var syncOptions = ["isValid", "validationStatus", "validationError", "validationErrors"];
                    syncOptions.forEach(function(prop) {
                        if (prop in options) {
                            (0, _extend.extend)(initedOptions, _this16.synchronizeValidationOptions({
                                name: prop,
                                value: options[prop]
                            }, options))
                        }
                    })
                }
                return initedOptions
            },
            synchronizeValidationOptions: function(_ref4, options) {
                var name = _ref4.name,
                    value = _ref4.value;
                switch (name) {
                    case "validationStatus":
                        var isValid = value === STATUS.valid || value === STATUS.pending;
                        return options.isValid !== isValid ? {
                            isValid: isValid
                        } : {};
                    case "isValid":
                        var validationStatus = options.validationStatus;
                        var newStatus = validationStatus;
                        if (value && validationStatus === STATUS.invalid) {
                            newStatus = STATUS.valid
                        } else {
                            if (!value && validationStatus !== STATUS.invalid) {
                                newStatus = STATUS.invalid
                            }
                        }
                        return newStatus !== validationStatus ? {
                            validationStatus: newStatus
                        } : {};
                    case "validationErrors":
                        var validationError = !value || !value.length ? null : value[0];
                        return options.validationError !== validationError ? {
                            validationError: validationError
                        } : {};
                    case "validationError":
                        var validationErrors = options.validationErrors;
                        if (!value && validationErrors) {
                            return {
                                validationErrors: null
                            }
                        } else {
                            if (value && !validationErrors) {
                                return {
                                    validationErrors: [value]
                                }
                            } else {
                                if (value && validationErrors && value !== validationErrors[0]) {
                                    validationErrors[0] = value;
                                    return {
                                        validationErrors: validationErrors.slice()
                                    }
                                }
                            }
                        }
                }
                return {}
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors2.default.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors2.default.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        module.exports = ValidationEngine
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/empty_template.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.EmptyTemplate = void 0;
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _template_base = __webpack_require__( /*! ./template_base */ 80);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function")
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                _setPrototypeOf(subClass, superClass)
            }
        }

        function _setPrototypeOf(o, p) {
            _setPrototypeOf = Object.setPrototypeOf || function(o, p) {
                o.__proto__ = p;
                return o
            };
            return _setPrototypeOf(o, p)
        }

        function _createSuper(Derived) {
            var hasNativeReflectConstruct = _isNativeReflectConstruct();
            return function() {
                var result, Super = _getPrototypeOf(Derived);
                if (hasNativeReflectConstruct) {
                    var NewTarget = _getPrototypeOf(this).constructor;
                    result = Reflect.construct(Super, arguments, NewTarget)
                } else {
                    result = Super.apply(this, arguments)
                }
                return _possibleConstructorReturn(this, result)
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (call && ("object" === _typeof(call) || "function" === typeof call)) {
                return call
            }
            return _assertThisInitialized(self)
        }

        function _assertThisInitialized(self) {
            if (void 0 === self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return self
        }

        function _isNativeReflectConstruct() {
            if ("undefined" === typeof Reflect || !Reflect.construct) {
                return false
            }
            if (Reflect.construct.sham) {
                return false
            }
            if ("function" === typeof Proxy) {
                return true
            }
            try {
                Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
                return true
            } catch (e) {
                return false
            }
        }

        function _getPrototypeOf(o) {
            _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(o) {
                return o.__proto__ || Object.getPrototypeOf(o)
            };
            return _getPrototypeOf(o)
        }
        exports.EmptyTemplate = function(_TemplateBase) {
            _inherits(EmptyTemplate, _TemplateBase);
            var _super = _createSuper(EmptyTemplate);

            function EmptyTemplate() {
                _classCallCheck(this, EmptyTemplate);
                return _super.apply(this, arguments)
            }
            _createClass(EmptyTemplate, [{
                key: "_renderCore",
                value: function() {
                    return (0, _renderer2.default)()
                }
            }]);
            return EmptyTemplate
        }(_template_base.TemplateBase)
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/ui/context_menu.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _ui = __webpack_require__( /*! ./context_menu/ui.context_menu */ 338);
        var _ui2 = _interopRequireDefault(_ui);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        module.exports = _ui2.default
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/variable_wrapper.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var logger = __webpack_require__( /*! ./console */ 73).logger;
        var dependencyInjector = __webpack_require__( /*! ./dependency_injector */ 60);
        module.exports = dependencyInjector({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        })
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/style.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var camelize = __webpack_require__( /*! ./inflector */ 38).camelize;
        var callOnce = __webpack_require__( /*! ./call_once */ 82);
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"];
        var cssPrefixes = {
            "": "",
            Webkit: "-webkit-",
            Moz: "-moz-",
            O: "-o-",
            ms: "-ms-"
        };
        var getStyles = callOnce(function() {
            return domAdapter.createElement("dx").style
        });
        var forEachPrefixes = function(prop, callBack) {
            prop = camelize(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = camelize(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if (typeUtils.isNumeric(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = typeUtils.isNumeric(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.styleProp = styleProp;
        exports.stylePropPrefix = stylePropPrefix;
        exports.normalizeStyleProp = normalizeStyleProp;
        exports.setWidth = setWidth;
        exports.setHeight = setHeight
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/core.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 60);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _parent_locales = __webpack_require__( /*! ./cldr-data/parent_locales */ 456);
        var _parent_locales2 = _interopRequireDefault(_parent_locales);
        var _parentLocale = __webpack_require__( /*! ./parentLocale */ 457);
        var _parentLocale2 = _interopRequireDefault(_parentLocale);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_LOCALE = "en";
        module.exports = (0, _dependency_injector2.default)({
            locale: function() {
                var currentLocale = DEFAULT_LOCALE;
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }(),
            getValueByClosestLocale: function(getter) {
                var locale = this.locale();
                var value = getter(locale);
                var isRootLocale;
                while (!value && !isRootLocale) {
                    locale = (0, _parentLocale2.default)(_parent_locales2.default, locale);
                    if (locale) {
                        value = getter(locale)
                    } else {
                        isRootLocale = true
                    }
                }
                if (void 0 === value && locale !== DEFAULT_LOCALE) {
                    return getter(DEFAULT_LOCALE)
                }
                return value
            }
        })
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/exporter/excel/excel.tag_helper.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var tagHelper = {
            toXml: function(tagName, attributes, content) {
                var result = ["<", tagName];
                for (var attributeName in attributes) {
                    var attributeValue = attributes[attributeName];
                    if ((0, _type.isDefined)(attributeValue)) {
                        result.push(" ", attributeName, '="', attributeValue, '"')
                    }
                }
                if ((0, _type.isDefined)(content) && "" !== content) {
                    result.push(">", content, "</", tagName, ">")
                } else {
                    result.push(" />")
                }
                return result.join("")
            }
        };
        exports.default = tagHelper
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled/ui/shared/accessibility.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _utils = __webpack_require__( /*! ../../events/utils */ 8);
        var eventUtils = _interopRequireWildcard(_utils);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);

        function _getRequireWildcardCache() {
            if ("function" !== typeof WeakMap) {
                return null
            }
            var cache = new WeakMap;
            _getRequireWildcardCache = function() {
                return cache
            };
            return cache
        }

        function _interopRequireWildcard(obj) {
            if (obj && obj.__esModule) {
                return obj
            }
            if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                return {
                    "default": obj
                }
            }
            var cache = _getRequireWildcardCache();
            if (cache && cache.has(obj)) {
                return cache.get(obj)
            }
            var newObj = {};
            var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
            for (var key in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                    if (desc && (desc.get || desc.set)) {
                        Object.defineProperty(newObj, key, desc)
                    } else {
                        newObj[key] = obj[key]
                    }
                }
            }
            newObj.default = obj;
            if (cache) {
                cache.set(obj, newObj)
            }
            return newObj
        }

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var FOCUS_STATE_CLASS = "dx-state-focused";
        var FOCUS_DISABLED_CLASS = "dx-cell-focus-disabled";
        var FOCUSED_ROW_SELECTOR = ".dx-row-focused";
        var GRID_ROW_SELECTOR = ".dx-datagrid-rowsview .dx-row";
        var GRID_CELL_SELECTOR = "".concat(GRID_ROW_SELECTOR, " > td");
        var TREELIST_ROW_SELECTOR = ".dx-treelist-rowsview .dx-row";
        var TREELIST_CELL_SELECTOR = "".concat(TREELIST_ROW_SELECTOR, " > td");
        var viewItemSelectorMap = {
            groupPanel: [".dx-datagrid-group-panel .dx-group-panel-item[tabindex]"],
            columnHeaders: [".dx-datagrid-headers .dx-header-row > td.dx-datagrid-action", ".dx-treelist-headers .dx-header-row > td.dx-treelist-action"],
            filterRow: [".dx-datagrid-headers .dx-datagrid-filter-row .dx-editor-cell .dx-texteditor-input", ".dx-treelist-headers .dx-treelist-filter-row .dx-editor-cell .dx-texteditor-input"],
            rowsView: ["".concat(FOCUSED_ROW_SELECTOR), "".concat(GRID_ROW_SELECTOR, "[tabindex]"), "".concat(GRID_CELL_SELECTOR, "[tabindex]"), "".concat(GRID_CELL_SELECTOR), "".concat(TREELIST_ROW_SELECTOR, "[tabindex]"), "".concat(TREELIST_CELL_SELECTOR, "[tabindex]"), "".concat(TREELIST_CELL_SELECTOR)],
            footer: [".dx-datagrid-total-footer .dx-datagrid-summary-item", ".dx-treelist-total-footer .dx-treelist-summary-item"],
            filterPanel: [".dx-datagrid-filter-panel .dx-icon-filter", ".dx-treelist-filter-panel .dx-icon-filter"],
            pager: [".dx-datagrid-pager [tabindex]", ".dx-treelist-pager [tabindex]"]
        };
        var isMouseDown = false;
        var isHiddenFocusing = false;
        var focusedElementInfo = null;

        function processKeyDown(viewName, instance, event, action, $mainElement, executeKeyDown) {
            var isHandled = fireKeyDownEvent(instance, event.originalEvent, executeKeyDown);
            if (isHandled) {
                return
            }
            var keyName = eventUtils.normalizeKeyName(event);
            if ("enter" === keyName || "space" === keyName) {
                saveFocusedElementInfo(event.target, instance);
                action && action({
                    event: event
                })
            } else {
                if ("tab" === keyName) {
                    $mainElement.addClass(FOCUS_STATE_CLASS)
                } else {
                    module.exports.selectView(viewName, instance, event)
                }
            }
        }

        function saveFocusedElementInfo(target, instance) {
            var $target = (0, _renderer2.default)(target);
            var ariaLabel = $target.attr("aria-label");
            var $activeElements = getActiveAccessibleElements(ariaLabel, instance.element());
            var targetIndex = $activeElements.index($target);
            focusedElementInfo = (0, _extend.extend)({}, {
                ariaLabel: ariaLabel,
                index: targetIndex
            }, {
                viewInstance: instance
            })
        }

        function getActiveAccessibleElements(ariaLabel, viewElement) {
            var $viewElement = (0, _renderer2.default)(viewElement);
            var $activeElements;
            if (ariaLabel) {
                $activeElements = $viewElement.find('[aria-label="'.concat(ariaLabel, '"][tabindex]'))
            } else {
                $activeElements = $viewElement.find("[tabindex]")
            }
            return $activeElements
        }

        function findFocusedViewElement(viewSelectors) {
            for (var index in viewSelectors) {
                var selector = viewSelectors[index];
                var $focusViewElement = (0, _renderer2.default)(selector).first();
                if ($focusViewElement.length) {
                    return $focusViewElement
                }
            }
        }

        function fireKeyDownEvent(instance, event, executeAction) {
            var args = {
                event: event,
                handled: false
            };
            if (executeAction) {
                executeAction(args)
            } else {
                instance._createActionByOption("onKeyDown")(args)
            }
            return args.handled
        }

        function onDocumentVisibilityChange() {
            isHiddenFocusing = "visible" === _dom_adapter2.default.getDocument().visibilityState
        }
        module.exports = {
            subscribeVisibilityChange: function() {
                _events_engine2.default.on(_dom_adapter2.default.getDocument(), "visibilitychange", onDocumentVisibilityChange)
            },
            unsubscribeVisibilityChange: function() {
                _events_engine2.default.off(_dom_adapter2.default.getDocument(), "visibilitychange", onDocumentVisibilityChange)
            },
            hiddenFocus: function(element) {
                isHiddenFocusing = true;
                element.focus();
                isHiddenFocusing = false
            },
            registerKeyboardAction: function(viewName, instance, $element, selector, action, executeKeyDown) {
                if (instance.option("useLegacyKeyboardNavigation")) {
                    return
                }
                var $mainElement = (0, _renderer2.default)(instance.element());
                _events_engine2.default.on($element, "keydown", selector, function(e) {
                    return processKeyDown(viewName, instance, e, action, $mainElement, executeKeyDown)
                });
                _events_engine2.default.on($element, "mousedown", selector, function() {
                    isMouseDown = true;
                    $mainElement.removeClass(FOCUS_STATE_CLASS)
                });
                _events_engine2.default.on($element, "focusin", selector, function() {
                    var needShowOverlay = !isMouseDown && !isHiddenFocusing;
                    if (needShowOverlay) {
                        $mainElement.addClass(FOCUS_STATE_CLASS)
                    }
                    isMouseDown = false
                })
            },
            restoreFocus: function(instance) {
                if (!instance.option("useLegacyKeyboardNavigation") && focusedElementInfo) {
                    var viewInstance = focusedElementInfo.viewInstance;
                    if (viewInstance) {
                        var $activeElements = getActiveAccessibleElements(focusedElementInfo.ariaLabel, viewInstance.element());
                        var $targetElement = $activeElements.eq(focusedElementInfo.index);
                        focusedElementInfo = null;
                        _events_engine2.default.trigger($targetElement, "focus")
                    }
                }
            },
            selectView: function(viewName, instance, event) {
                var keyName = eventUtils.normalizeKeyName(event);
                if (event.ctrlKey && ("upArrow" === keyName || "downArrow" === keyName)) {
                    var viewNames = Object.keys(viewItemSelectorMap);
                    var viewItemIndex = viewNames.indexOf(viewName);
                    while (viewItemIndex >= 0 && viewItemIndex < viewNames.length) {
                        viewItemIndex = "upArrow" === keyName ? --viewItemIndex : ++viewItemIndex;
                        var _viewName = viewNames[viewItemIndex];
                        var viewSelectors = viewItemSelectorMap[_viewName];
                        var $focusViewElement = findFocusedViewElement(viewSelectors);
                        if ($focusViewElement && $focusViewElement.length) {
                            $focusViewElement.attr("tabindex", instance.option("tabindex") || 0);
                            _events_engine2.default.trigger($focusViewElement, "focus");
                            $focusViewElement.removeClass(FOCUS_DISABLED_CLASS);
                            break
                        }
                    }
                }
            },
            setTabIndex: function(instance, $element) {
                if (!instance.option("useLegacyKeyboardnavigation")) {
                    $element.attr("tabindex", instance.option("tabindex") || 0)
                }
            }
        }
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/list/ui.list.edit.decorator_registry.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        exports.registry = {};
        exports.register = function(option, type, decoratorClass) {
            var decoratorsRegistry = exports.registry;
            var decoratorConfig = {};
            decoratorConfig[option] = decoratorsRegistry[option] ? decoratorsRegistry[option] : {};
            decoratorConfig[option][type] = decoratorClass;
            decoratorsRegistry = extend(decoratorsRegistry, decoratorConfig)
        }
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/integration/jquery/use_jquery.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var jQuery = __webpack_require__( /*! jquery */ 64);
        var config = __webpack_require__( /*! ../../core/config */ 32);
        var useJQuery = config().useJQuery;
        if (jQuery && false !== useJQuery) {
            config({
                useJQuery: true
            })
        }
        module.exports = function() {
            return jQuery && config().useJQuery
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/hold.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventUtils = __webpack_require__( /*! ./utils */ 8);
        var Emitter = __webpack_require__( /*! ./core/emitter */ 142);
        var registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 102);
        var abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold";
        var HOLD_TIMEOUT = 750;
        var TOUCH_BOUNDARY = 5;
        var HoldEmitter = Emitter.inherit({
            start: function(e) {
                this._startEventData = eventUtils.eventData(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        registerEmitter({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        module.exports = {
            name: HOLD_EVENT_NAME
        }
    },
    /*!*****************************************!*\
      !*** ./artifacts/transpiled/ui/list.js ***!
      \*****************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var ListEdit = __webpack_require__( /*! ./list/ui.list.edit.search */ 520);
        var registerComponent = __webpack_require__( /*! ../core/component_registrator */ 9);
        registerComponent("dxList", ListEdit);
        module.exports = ListEdit
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/ui/select_box.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var commonUtils = __webpack_require__( /*! ../core/utils/common */ 3);
        var typeUtils = __webpack_require__( /*! ../core/utils/type */ 1);
        var isDefined = typeUtils.isDefined;
        var isPromise = typeUtils.isPromise;
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var inArray = __webpack_require__( /*! ../core/utils/array */ 13).inArray;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6);
        var getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement;
        var Deferred = deferredUtils.Deferred;
        var errors = __webpack_require__( /*! ../core/errors */ 23);
        var domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12);
        var inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 62);
        var messageLocalization = __webpack_require__( /*! ../localization/message */ 10);
        var registerComponent = __webpack_require__( /*! ../core/component_registrator */ 9);
        var DropDownList = __webpack_require__( /*! ./drop_down_editor/ui.drop_down_list */ 232);
        var DISABLED_STATE_SELECTOR = ".dx-state-disabled";
        var SELECTBOX_CLASS = "dx-selectbox";
        var SELECTBOX_POPUP_CLASS = "dx-selectbox-popup";
        var SELECTBOX_CONTAINER_CLASS = "dx-selectbox-container";
        var SELECTBOX_POPUP_WRAPPER_CLASS = "dx-selectbox-popup-wrapper";
        var SelectBox = DropDownList.inherit({
            _supportedKeys: function() {
                var that = this;
                var parent = this.callBase();
                var clearSelectBox = function(e) {
                    var isEditable = this._isEditable();
                    if (!isEditable) {
                        if (this.option("showClearButton")) {
                            e.preventDefault();
                            this.reset()
                        }
                    } else {
                        if (this._valueSubstituted()) {
                            this._preventFiltering = true
                        }
                    }
                    this._preventSubstitution = true
                };
                var searchIfNeeded = function() {
                    if (that.option("searchEnabled") && that._valueSubstituted()) {
                        that._searchHandler()
                    }
                };
                return extend({}, parent, {
                    tab: function() {
                        if (this.option("opened") && "instantly" === this.option("applyValueMode")) {
                            this._cleanInputSelection()
                        }
                        if (this._wasSearch()) {
                            this._clearFilter()
                        }
                        parent.tab && parent.tab.apply(this, arguments)
                    },
                    upArrow: function(e) {
                        if (parent.upArrow && parent.upArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(e)
                            }
                            return true
                        }
                    },
                    downArrow: function(e) {
                        if (parent.downArrow && parent.downArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(e)
                            }
                            return true
                        }
                    },
                    leftArrow: function() {
                        searchIfNeeded();
                        parent.leftArrow && parent.leftArrow.apply(this, arguments)
                    },
                    rightArrow: function() {
                        searchIfNeeded();
                        parent.rightArrow && parent.rightArrow.apply(this, arguments)
                    },
                    home: function() {
                        searchIfNeeded();
                        parent.home && parent.home.apply(this, arguments)
                    },
                    end: function() {
                        searchIfNeeded();
                        parent.end && parent.end.apply(this, arguments)
                    },
                    escape: function() {
                        var result = parent.escape && parent.escape.apply(this, arguments);
                        this._cancelEditing();
                        return isDefined(result) ? result : true
                    },
                    enter: function(e) {
                        var isOpened = this.option("opened");
                        var inputText = this._input().val().trim();
                        var isCustomText = inputText && this._list && !this._list.option("focusedElement");
                        if (!inputText && this.option("value") && this.option("allowClearing")) {
                            this.option({
                                selectedItem: null,
                                value: null
                            });
                            this.close()
                        } else {
                            if (this.option("acceptCustomValue")) {
                                e.preventDefault();
                                if (isCustomText) {
                                    this._valueChangeEventHandler(e);
                                    if (isOpened) {
                                        this._toggleOpenState()
                                    }
                                }
                                return isOpened
                            }
                            if (parent.enter && parent.enter.apply(this, arguments)) {
                                return isOpened
                            }
                        }
                    },
                    space: function(e) {
                        var isOpened = this.option("opened");
                        var isSearchEnabled = this.option("searchEnabled");
                        var acceptCustomValue = this.option("acceptCustomValue");
                        if (!isOpened || isSearchEnabled || acceptCustomValue) {
                            return
                        }
                        e.preventDefault();
                        this._valueChangeEventHandler(e);
                        return true
                    },
                    backspace: clearSelectBox,
                    del: clearSelectBox
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    placeholder: messageLocalization.format("Select"),
                    fieldTemplate: null,
                    valueChangeEvent: "change",
                    acceptCustomValue: false,
                    onCustomItemCreating: function(e) {
                        if (!isDefined(e.customItem)) {
                            e.customItem = e.text
                        }
                    },
                    showSelectionControls: false,
                    autocompletionEnabled: true,
                    allowClearing: true,
                    tooltipEnabled: false,
                    openOnFieldClick: true,
                    showDropDownButton: true,
                    displayCustomValue: false,
                    _isAdaptablePopupPosition: false,
                    useInkRipple: false,
                    useHiddenSubmitElement: true
                })
            },
            _init: function() {
                this.callBase();
                this._initCustomItemCreatingAction()
            },
            _initMarkup: function() {
                this.$element().addClass(SELECTBOX_CLASS);
                this._renderTooltip();
                this.option("useInkRipple") && this._renderInkRipple();
                this.callBase();
                this._$container.addClass(SELECTBOX_CONTAINER_CLASS)
            },
            _renderInkRipple: function() {
                this._inkRipple = inkRipple.render()
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple || this._isEditable()) {
                    return
                }
                var config = {
                    element: this._inputWrapper(),
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _createPopup: function() {
                this.callBase();
                this._popup.$element().addClass(SELECTBOX_POPUP_CLASS);
                this._popup.overlayContent().attr("tabindex", -1)
            },
            _popupWrapperClass: function() {
                return this.callBase() + " " + SELECTBOX_POPUP_WRAPPER_CLASS
            },
            _cancelEditing: function() {
                if (!this.option("searchEnabled") && this._list) {
                    this._focusListElement(null);
                    this._updateField(this.option("selectedItem"))
                }
            },
            _renderOpenedState: function() {
                this.callBase();
                if (this.option("opened")) {
                    this._scrollToSelectedItem();
                    this._focusSelectedElement()
                }
            },
            _focusSelectedElement: function() {
                var searchValue = this._searchValue();
                if (!searchValue) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements();
                var index = inArray(this.option("selectedItem"), this.option("items"));
                var focusedElement = index >= 0 && !this._isCustomItemSelected() ? $listItems.eq(index) : null;
                this._focusListElement(focusedElement)
            },
            _renderFocusedElement: function() {
                if (!this._list) {
                    return
                }
                var searchValue = this._searchValue();
                if (!searchValue || this.option("acceptCustomValue")) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements();
                var focusedElement = $listItems.not(DISABLED_STATE_SELECTOR).eq(0);
                this._focusListElement(focusedElement)
            },
            _focusListElement: function(element) {
                this._preventInputValueRender = true;
                this._list.option("focusedElement", getPublicElement(element));
                delete this._preventInputValueRender
            },
            _scrollToSelectedItem: function() {
                this._list && this._list.scrollToItem(this._list.option("selectedItem"))
            },
            _listContentReadyHandler: function() {
                this.callBase();
                var isPaginate = this._dataSource && this._dataSource.paginate();
                if (isPaginate && this._needPopupRepaint()) {
                    return
                }
                this._scrollToSelectedItem()
            },
            _renderValue: function() {
                this._renderInputValue();
                this._setSubmitValue();
                return (new Deferred).resolve()
            },
            _renderInputValue: function() {
                return this.callBase().always(function() {
                    this._renderInputValueAsync()
                }.bind(this))
            },
            _renderInputValueAsync: function() {
                this._renderTooltip();
                this._renderInputValueImpl().always(function() {
                    this._refreshSelected()
                }.bind(this))
            },
            _renderInputValueImpl: function() {
                this._renderField();
                return (new Deferred).resolve()
            },
            _setNextItem: function(step) {
                var item = this._calcNextItem(step);
                var value = this._valueGetter(item);
                this._setValue(value)
            },
            _setNextValue: function(e) {
                var dataSourceIsLoaded = this._dataSource.isLoaded() ? (new Deferred).resolve() : this._dataSource.load();
                dataSourceIsLoaded.done(function() {
                    var selectedIndex = this._getSelectedIndex();
                    var hasPages = this._dataSource.pageSize();
                    var isLastPage = this._dataSource.isLastPage();
                    var isLastItem = selectedIndex === this._items().length - 1;
                    this._saveValueChangeEvent(e);
                    var step = "ArrowDown" === e.key ? 1 : -1;
                    if (hasPages && !isLastPage && isLastItem && step > 0) {
                        if (!this._popup) {
                            this._createPopup()
                        }
                        if (!this._dataSource.isLoading()) {
                            this._list._loadNextPage().done(this._setNextItem.bind(this, step))
                        }
                    } else {
                        this._setNextItem(step)
                    }
                }.bind(this))
            },
            _setSelectedItem: function(item) {
                var isUnknownItem = !this._isCustomValueAllowed() && void 0 === item;
                this.callBase(isUnknownItem ? null : item);
                if (!isUnknownItem && (!this._isEditable() || this._isCustomItemSelected())) {
                    this._setListOption("selectedItem", this.option("selectedItem"))
                }
            },
            _isCustomValueAllowed: function() {
                return this.option("acceptCustomValue") || this.callBase()
            },
            _displayValue: function(item) {
                item = !isDefined(item) && this._isCustomValueAllowed() ? this.option("value") : item;
                return this.callBase(item)
            },
            _listConfig: function() {
                var result = extend(this.callBase(), {
                    pageLoadMode: "scrollBottom",
                    onSelectionChanged: this._getSelectionChangeHandler(),
                    selectedItem: this.option("selectedItem"),
                    onFocusedItemChanged: this._listFocusedItemChangeHandler.bind(this)
                });
                if (this.option("showSelectionControls")) {
                    extend(result, {
                        showSelectionControls: true,
                        selectionByClick: true
                    })
                }
                return result
            },
            _listFocusedItemChangeHandler: function(e) {
                if (this._preventInputValueRender) {
                    return
                }
                var list = e.component;
                var focusedElement = $(list.option("focusedElement"));
                var focusedItem = list._getItemData(focusedElement);
                this._updateField(focusedItem)
            },
            _updateField: function(item) {
                var fieldTemplate = this._getTemplateByOption("fieldTemplate");
                if (!(fieldTemplate && this.option("fieldTemplate"))) {
                    this._renderDisplayText(this._displayGetter(item));
                    return
                }
                this._renderField()
            },
            _getSelectionChangeHandler: function() {
                return this.option("showSelectionControls") ? this._selectionChangeHandler.bind(this) : commonUtils.noop
            },
            _selectionChangeHandler: function(e) {
                each(e.addedItems || [], function(_, addedItem) {
                    this._setValue(this._valueGetter(addedItem))
                }.bind(this))
            },
            _getActualSearchValue: function() {
                return this._dataSource.searchValue()
            },
            _toggleOpenState: function(isVisible) {
                if (this.option("disabled")) {
                    return
                }
                isVisible = arguments.length ? isVisible : !this.option("opened");
                if (!isVisible) {
                    this._restoreInputText(true)
                }
                if (this._wasSearch() && isVisible) {
                    this._wasSearch(false);
                    var showDataImmediately = this.option("showDataBeforeSearch") || 0 === this.option("minSearchLength");
                    if (showDataImmediately && this._dataSource) {
                        if (this._searchTimer) {
                            return
                        }
                        var searchValue = this._getActualSearchValue();
                        searchValue && this._wasSearch(true);
                        this._filterDataSource(searchValue || null)
                    } else {
                        this._setListOption("items", [])
                    }
                }
                if (isVisible) {
                    this._scrollToSelectedItem()
                }
                this.callBase(isVisible)
            },
            _renderTooltip: function() {
                if (this.option("tooltipEnabled")) {
                    this.$element().attr("title", this.option("displayValue"))
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._dimensionChanged()
            },
            _isValueEqualInputText: function() {
                var initialSelectedItem = this.option("selectedItem");
                var value = this._displayGetter(initialSelectedItem);
                var displayValue = value ? String(value) : "";
                var inputText = this._searchValue();
                return displayValue === inputText
            },
            _popupHidingHandler: function() {
                if (this._isValueEqualInputText()) {
                    this._cancelEditing()
                }
                this.callBase()
            },
            _restoreInputText: function(saveEditingValue) {
                if (this.option("readOnly")) {
                    return
                }
                this._loadItemDeferred && this._loadItemDeferred.always(function() {
                    var initialSelectedItem = this.option("selectedItem");
                    if (this.option("acceptCustomValue")) {
                        if (!saveEditingValue) {
                            this._updateField(initialSelectedItem);
                            this._clearFilter()
                        }
                        return
                    }
                    if (this.option("searchEnabled")) {
                        if (!this._searchValue() && this.option("allowClearing")) {
                            this._clearTextValue();
                            return
                        }
                    }
                    if (this._isValueEqualInputText()) {
                        return
                    }
                    this._renderInputValue().always(function(selectedItem) {
                        var newSelectedItem = commonUtils.ensureDefined(selectedItem, initialSelectedItem);
                        this._setSelectedItem(newSelectedItem);
                        this._updateField(newSelectedItem);
                        this._clearFilter()
                    }.bind(this))
                }.bind(this))
            },
            _focusOutHandler: function(e) {
                if (!this._preventNestedFocusEvent(e)) {
                    var isOverlayTarget = this._isOverlayNestedTarget(e.relatedTarget);
                    if (!isOverlayTarget) {
                        this._restoreInputText();
                        this._clearSearchTimer()
                    }
                    var shouldCancelSearch = this._wasSearch() && !this.option("acceptCustomValue") && this.option("searchEnabled") && this.option("opened") && !isOverlayTarget;
                    if (shouldCancelSearch) {
                        this._searchCanceled()
                    }
                }
                this.callBase(e)
            },
            _isOverlayNestedTarget: function(target) {
                return !!$(target).closest(".".concat(SELECTBOX_POPUP_WRAPPER_CLASS)).length
            },
            _clearTextValue: function() {
                if (this.option("selectedItem")) {
                    this.option("value", null)
                }
            },
            _shouldOpenPopup: function() {
                return this._needPassDataSourceToList()
            },
            _isFocused: function() {
                var activeElement = domAdapter.getActiveElement();
                return this.callBase() && $(activeElement).closest(this._input()).length > 0
            },
            _renderValueChangeEvent: function() {
                if (this._isEditable()) {
                    this.callBase()
                }
            },
            _isEditable: function() {
                return this.option("acceptCustomValue") || this.option("searchEnabled")
            },
            _fieldRenderData: function() {
                var $listFocused = this._list && this.option("opened") && $(this._list.option("focusedElement"));
                if ($listFocused && $listFocused.length) {
                    return this._list._getItemData($listFocused)
                }
                return this.option("selectedItem")
            },
            _readOnlyPropValue: function() {
                return !this._isEditable() || this.option("readOnly")
            },
            _isSelectedValue: function(value) {
                return this._isValueEquals(value, this.option("value"))
            },
            _shouldCloseOnItemClick: function() {
                return !(this.option("showSelectionControls") && "single" !== this.option("selectionMode"))
            },
            _listItemClickHandler: function(e) {
                var previousValue = this._getCurrentValue();
                this._focusListElement($(e.itemElement));
                this._saveValueChangeEvent(e.event);
                if (this._shouldClearFilter()) {
                    this._clearFilter()
                }
                this._completeSelection(this._valueGetter(e.itemData));
                if (this._shouldCloseOnItemClick()) {
                    this.option("opened", false)
                }
                if (this.option("searchEnabled") && previousValue === this._valueGetter(e.itemData)) {
                    this._updateField(e.itemData)
                }
            },
            _shouldClearFilter: function() {
                return this._wasSearch()
            },
            _completeSelection: function(value) {
                this._setValue(value)
            },
            _loadItem: function(value, cache) {
                var that = this;
                var deferred = new Deferred;
                this.callBase(value, cache).done(function(item) {
                    deferred.resolve(item)
                }.bind(this)).fail(function() {
                    var selectedItem = that.option("selectedItem");
                    if (that.option("acceptCustomValue") && value === that._valueGetter(selectedItem)) {
                        deferred.resolve(selectedItem)
                    } else {
                        deferred.reject()
                    }
                }.bind(this));
                return deferred.promise()
            },
            _loadInputValue: function(value, callback) {
                this._loadItemDeferred = this._loadItem(value).always(callback);
                return this._loadItemDeferred
            },
            _isCustomItemSelected: function() {
                var selectedItem = this.option("selectedItem");
                var searchValue = this._searchValue();
                var selectedItemText = this._displayGetter(selectedItem);
                return !selectedItemText || searchValue !== selectedItemText.toString()
            },
            _valueChangeEventHandler: function(e) {
                if (this.option("acceptCustomValue") && this._isCustomItemSelected() && !this._isValueChanging) {
                    this._isValueChanging = true;
                    this._customItemAddedHandler(e);
                    this._isValueChanging = false
                }
            },
            _initCustomItemCreatingAction: function() {
                this._customItemCreatingAction = this._createActionByOption("onCustomItemCreating")
            },
            _createCustomItem: function(text) {
                var params = {
                    text: text
                };
                var actionResult = this._customItemCreatingAction(params);
                var item = commonUtils.ensureDefined(actionResult, params.customItem);
                if (isDefined(actionResult)) {
                    errors.log("W0015", "onCustomItemCreating", "customItem")
                }
                return item
            },
            _customItemAddedHandler: function(e) {
                var searchValue = this._searchValue();
                var item = this._createCustomItem(searchValue);
                this._saveValueChangeEvent(e);
                if (void 0 === item) {
                    this._renderValue();
                    throw errors.Error("E0121")
                }
                if (isPromise(item)) {
                    deferredUtils.fromPromise(item).done(this._setCustomItem.bind(this)).fail(this._setCustomItem.bind(this, null))
                } else {
                    this._setCustomItem(item)
                }
            },
            _setCustomItem: function(item) {
                if (this._disposed) {
                    return
                }
                item = item || null;
                this.option("selectedItem", item);
                if (this._shouldClearFilter()) {
                    this._filterDataSource(null)
                }
                this._setValue(this._valueGetter(item));
                this._renderDisplayText(this._displayGetter(item))
            },
            _clearValueHandler: function(e) {
                this.callBase(e);
                return false
            },
            _wasSearch: function(value) {
                if (!arguments.length) {
                    return this._wasSearchValue
                }
                this._wasSearchValue = value
            },
            _searchHandler: function(e) {
                if (this._preventFiltering) {
                    delete this._preventFiltering;
                    return
                }
                if (this._needPassDataSourceToList()) {
                    this._wasSearch(true)
                }
                this.callBase(e)
            },
            _dataSourceFiltered: function(searchValue) {
                this.callBase();
                if (null !== searchValue) {
                    this._renderInputSubstitution();
                    this._renderFocusedElement()
                }
            },
            _valueSubstituted: function() {
                var input = this._input().get(0);
                var isAllSelected = 0 === input.selectionStart && input.selectionEnd === this._searchValue().length;
                var inputHasSelection = input.selectionStart !== input.selectionEnd;
                return this._wasSearch() && inputHasSelection && !isAllSelected
            },
            _shouldSubstitutionBeRendered: function() {
                return this.option("autocompletionEnabled") && !this._preventSubstitution && this.option("searchEnabled") && !this.option("acceptCustomValue") && "startswith" === this.option("searchMode")
            },
            _renderInputSubstitution: function() {
                if (!this._shouldSubstitutionBeRendered()) {
                    delete this._preventSubstitution;
                    return
                }
                var item = this._list && this._getPlainItems(this._list.option("items"))[0];
                if (!item) {
                    return
                }
                var $input = this._input();
                var valueLength = $input.val().length;
                if (0 === valueLength) {
                    return
                }
                var inputElement = $input.get(0);
                var displayValue = this._displayGetter(item).toString();
                inputElement.value = displayValue;
                this._caret({
                    start: valueLength,
                    end: displayValue.length
                })
            },
            _cleanInputSelection: function() {
                var inputElement = this._input().get(0);
                var endPosition = inputElement.value.length;
                inputElement.selectionStart = endPosition;
                inputElement.selectionEnd = endPosition
            },
            _dispose: function() {
                this._renderInputValueAsync = commonUtils.noop;
                delete this._loadItemDeferred;
                this.callBase()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_isAdaptablePopupPosition":
                    case "autocompletionEnabled":
                        break;
                    case "onCustomItemCreating":
                        this._initCustomItemCreatingAction();
                        break;
                    case "tooltipEnabled":
                        this._renderTooltip();
                        break;
                    case "displayCustomValue":
                    case "acceptCustomValue":
                    case "showSelectionControls":
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "allowClearing":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                delete this._inkRipple;
                this.callBase()
            }
        });
        registerComponent("dxSelectBox", SelectBox);
        module.exports = SelectBox
    }, ,
    /*!***************************************!*\
      !*** ./artifacts/transpiled/color.js ***!
      \***************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var v = parseInt(colorString[3], 10);
                var rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10);
                var s = parseInt(colorString[2], 10);
                var l = parseInt(colorString[3], 10);
                var rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];
        var _round = Math.round;

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var i = 0;
            var ii = standardColorTypes.length;
            var str;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var delta = max - min;
            var H;
            var S;
            var V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var index = Math.floor(h % 360 / 60);
            var vMin = (100 - s) * v / 100;
            var a = (v - vMin) * (h % 60 / 60);
            var vInc = vMin + a;
            var vDec = v - a;
            var r;
            var g;
            var b;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var maxMinSum = max + min;
            var h;
            var s;
            var l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r;
            var g;
            var b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s;
                var p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor);
                var result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color;
                var rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        module.exports = Color
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/events_strategy.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.EventsStrategy = void 0;
        var _callbacks = __webpack_require__( /*! ./utils/callbacks */ 27);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 4);
        var _type = __webpack_require__( /*! ./utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        exports.EventsStrategy = function() {
            function EventsStrategy(owner) {
                _classCallCheck(this, EventsStrategy);
                this._events = {};
                this._owner = owner
            }
            _createClass(EventsStrategy, [{
                key: "hasEvent",
                value: function(eventName) {
                    var callbacks = this._events[eventName];
                    return callbacks ? callbacks.has() : false
                }
            }, {
                key: "fireEvent",
                value: function(eventName, eventArgs) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        callbacks.fireWith(this._owner, eventArgs)
                    }
                    return this._owner
                }
            }, {
                key: "on",
                value: function(eventName, eventHandler) {
                    var _this = this;
                    if ((0, _type.isPlainObject)(eventName)) {
                        (0, _iterator.each)(eventName, function(e, h) {
                            _this.on(e, h)
                        })
                    } else {
                        var callbacks = this._events[eventName];
                        if (!callbacks) {
                            callbacks = (0, _callbacks2.default)();
                            this._events[eventName] = callbacks
                        }
                        var addFn = callbacks.originalAdd || callbacks.add;
                        addFn.call(callbacks, eventHandler)
                    }
                }
            }, {
                key: "off",
                value: function(eventName, eventHandler) {
                    var callbacks = this._events[eventName];
                    if (callbacks) {
                        if ((0, _type.isFunction)(eventHandler)) {
                            callbacks.remove(eventHandler)
                        } else {
                            callbacks.empty()
                        }
                    }
                }
            }, {
                key: "dispose",
                value: function() {
                    (0, _iterator.each)(this._events, function(eventName, event) {
                        event.empty()
                    })
                }
            }], [{
                key: "create",
                value: function(owner, strategy) {
                    if (strategy) {
                        return (0, _type.isFunction)(strategy) ? strategy(owner) : strategy
                    } else {
                        return new EventsStrategy(owner)
                    }
                }
            }]);
            return EventsStrategy
        }()
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter_registrator.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 54);
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var dataUtils = __webpack_require__( /*! ../../core/element_data */ 44);
        var Class = __webpack_require__( /*! ../../core/class */ 16);
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        var inArray = __webpack_require__( /*! ../../core/utils/array */ 13).inArray;
        var each = __webpack_require__( /*! ../../core/utils/iterator */ 4).each;
        var registerEvent = __webpack_require__( /*! ./event_registrator */ 79);
        var eventUtils = __webpack_require__( /*! ../utils */ 8);
        var pointerEvents = __webpack_require__( /*! ../pointer */ 24);
        var wheelEvent = __webpack_require__( /*! ./wheel */ 129);
        var MANAGER_EVENT = "dxEventManager";
        var EMITTER_DATA = "dxEmitter";
        var EventManager = Class.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                readyCallbacks.add(function() {
                    var document = domAdapter.getDocument();
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace([pointerEvents.up, pointerEvents.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(wheelEvent.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if (eventUtils.isMouseEvent(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                each(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this;
                var result = [];
                var $element = $(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = dataUtils.data($element.get(0), EMITTER_DATA) || [];
                    each(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = inArray(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e);
                var verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction;
                var prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter;
            var emitterName = emitterConfig.events[0];
            var emitterEvents = emitterConfig.events;
            each(emitterEvents, function(_, eventName) {
                registerEvent(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA) || {};
                        var emitters = dataUtils.data(element, EMITTER_DATA) || {};
                        var emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        dataUtils.data(element, EMITTER_DATA, emitters);
                        dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = dataUtils.data(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        emitter.configure(extend({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA);
                        var emitters = dataUtils.data(element, EMITTER_DATA);
                        var emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        each(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        module.exports = registerEmitter
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/data/abstract_store.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 16);
        var abstract = Class.abstract;
        var EventsStrategy = __webpack_require__( /*! ../core/events_strategy */ 101).EventsStrategy;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 4).each;
        var errorsModule = __webpack_require__( /*! ./errors */ 40);
        var dataUtils = __webpack_require__( /*! ./utils */ 42);
        var compileGetter = __webpack_require__( /*! ../core/utils/data */ 21).compileGetter;
        var storeHelper = __webpack_require__( /*! ./store_helper */ 83);
        var queryByOptions = storeHelper.queryByOptions;
        var Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred;
        var noop = __webpack_require__( /*! ../core/utils/common */ 3).noop;
        var storeImpl = {};
        var Store = Class.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy = new EventsStrategy(this);
                each(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = compileGetter(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw errorsModule.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this._eventsStrategy.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that._eventsStrategy.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new Deferred;
                task.done(function() {
                    var that = this;
                    var args = arguments;
                    dataUtils.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function() {
                    that._eventsStrategy.fireEvent("updated", [key, values]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            push: function(changes) {
                this._pushImpl(changes);
                this._eventsStrategy.fireEvent("push", [changes])
            },
            _pushImpl: noop,
            remove: function(key) {
                var that = this;
                that._eventsStrategy.fireEvent("modifying");
                that._eventsStrategy.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that._eventsStrategy.fireEvent("removed", [callbackKey]);
                    that._eventsStrategy.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(errorsModule._errorHandler)
            },
            on: function(eventName, eventHandler) {
                this._eventsStrategy.on(eventName, eventHandler);
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            }
        });
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw errorsModule.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.registerClass = function(type, alias) {
            if (alias) {
                storeImpl[alias] = type
            }
            return type
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                Store.registerClass(type, alias);
                return type
            }
        }(Store.inherit);
        module.exports = Store
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/ui/date_box/ui.date_utils.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var dateSerialization = __webpack_require__( /*! ../../core/utils/date_serialization */ 50);
        var isDate = __webpack_require__( /*! ../../core/utils/type */ 1).isDate;
        var each = __webpack_require__( /*! ../../core/utils/iterator */ 4).each;
        var dateLocalization = __webpack_require__( /*! ../../localization/date */ 35);
        var dateComponents = function() {
            return ["year", "day", "month", "day"]
        };
        var ONE_MINUTE = 6e4;
        var ONE_DAY = 60 * ONE_MINUTE * 24;
        var ONE_YEAR = 365 * ONE_DAY;
        var getStringFormat = function(format) {
            var formatType = _typeof(format);
            if ("string" === formatType) {
                return "format"
            }
            if ("object" === formatType && void 0 !== format.type) {
                return format.type
            }
            return null
        };
        var dateUtils = {
            SUPPORTED_FORMATS: ["date", "time", "datetime"],
            DATE_COMPONENT_TEXT_FORMATTER: function(value, name) {
                var $container = $("<div>").addClass("dx-dateview-formatter-container");
                $("<span>").text(value).addClass("dx-dateview-value-formatter").appendTo($container);
                $("<span>").text(name).addClass("dx-dateview-name-formatter").appendTo($container);
                return $container
            },
            ONE_MINUTE: ONE_MINUTE,
            ONE_DAY: ONE_DAY,
            ONE_YEAR: ONE_YEAR,
            MIN_DATEVIEW_DEFAULT_DATE: new Date(1900, 0, 1),
            MAX_DATEVIEW_DEFAULT_DATE: function() {
                var newDate = new Date;
                return new Date(newDate.getFullYear() + 50, newDate.getMonth(), newDate.getDate(), 23, 59, 59)
            }(),
            FORMATS_INFO: {
                date: {
                    getStandardPattern: function() {
                        return "yyyy-MM-dd"
                    },
                    components: dateComponents()
                },
                time: {
                    getStandardPattern: function() {
                        return "HH:mm"
                    },
                    components: ["hours", "minutes", "seconds", "milliseconds"]
                },
                datetime: {
                    getStandardPattern: function() {
                        var standardPattern;
                        ! function() {
                            var androidFormatPattern = "yyyy-MM-ddTHH:mmZ";
                            var testDateString = "2000-01-01T01:01Z";
                            var $input = $("<input>").attr("type", "datetime");
                            $input.val(testDateString);
                            if ($input.val()) {
                                standardPattern = androidFormatPattern
                            }
                        }();
                        if (!standardPattern) {
                            standardPattern = "yyyy-MM-ddTHH:mm:ssZ"
                        }
                        dateUtils.FORMATS_INFO.datetime.getStandardPattern = function() {
                            return standardPattern
                        };
                        return standardPattern
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds", "milliseconds"])
                },
                "datetime-local": {
                    getStandardPattern: function() {
                        return "yyyy-MM-ddTHH:mm:ss"
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds"])
                }
            },
            FORMATS_MAP: {
                date: "shortdate",
                time: "shorttime",
                datetime: "shortdateshorttime"
            },
            SUBMIT_FORMATS_MAP: {
                date: "date",
                time: "time",
                datetime: "datetime-local"
            },
            toStandardDateFormat: function(date, type) {
                var pattern = dateUtils.FORMATS_INFO[type].getStandardPattern();
                return dateSerialization.serializeDate(date, pattern)
            },
            fromStandardDateFormat: function(text) {
                var date = dateSerialization.dateParser(text);
                return isDate(date) ? date : void 0
            },
            getMaxMonthDay: function(year, month) {
                return new Date(year, month + 1, 0).getDate()
            },
            mergeDates: function(oldValue, newValue, format) {
                if (!newValue) {
                    return newValue || null
                }
                if (!oldValue || isNaN(oldValue.getTime())) {
                    var now = new Date(null);
                    oldValue = new Date(now.getFullYear(), now.getMonth(), now.getDate())
                }
                var result = new Date(oldValue.valueOf());
                var formatInfo = dateUtils.FORMATS_INFO[format];
                each(formatInfo.components, function() {
                    var componentInfo = dateUtils.DATE_COMPONENTS_INFO[this];
                    result[componentInfo.setter](newValue[componentInfo.getter]())
                });
                return result
            },
            getLongestCaptionIndex: function(captionArray) {
                var longestIndex = 0;
                var longestCaptionLength = 0;
                var i;
                for (i = 0; i < captionArray.length; ++i) {
                    if (captionArray[i].length > longestCaptionLength) {
                        longestIndex = i;
                        longestCaptionLength = captionArray[i].length
                    }
                }
                return longestIndex
            },
            formatUsesMonthName: function(format) {
                return dateLocalization.formatUsesMonthName(format)
            },
            formatUsesDayName: function(format) {
                return dateLocalization.formatUsesDayName(format)
            },
            getLongestDate: function(format, monthNames, dayNames) {
                var stringFormat = getStringFormat(format);
                var month = 9;
                if (!stringFormat || dateUtils.formatUsesMonthName(stringFormat)) {
                    month = dateUtils.getLongestCaptionIndex(monthNames)
                }
                var longestDate = new Date(1888, month, 21, 23, 59, 59, 999);
                if (!stringFormat || dateUtils.formatUsesDayName(stringFormat)) {
                    var date = longestDate.getDate() - longestDate.getDay() + dateUtils.getLongestCaptionIndex(dayNames);
                    longestDate.setDate(date)
                }
                return longestDate
            },
            normalizeTime: function(date) {
                date.setSeconds(0);
                date.setMilliseconds(0)
            }
        };
        dateUtils.DATE_COMPONENTS_INFO = {
            year: {
                getter: "getFullYear",
                setter: "setFullYear",
                formatter: function(value, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setFullYear(value);
                    return dateLocalization.format(formatDate, "yyyy")
                },
                startValue: void 0,
                endValue: void 0
            },
            day: {
                getter: "getDate",
                setter: "setDate",
                formatter: function(value, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setDate(value);
                    return dateLocalization.format(formatDate, "d")
                },
                startValue: 1,
                endValue: void 0
            },
            month: {
                getter: "getMonth",
                setter: "setMonth",
                formatter: function(value) {
                    return dateLocalization.getMonthNames()[value]
                },
                startValue: 0,
                endValue: 11
            },
            hours: {
                getter: "getHours",
                setter: "setHours",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, value), "hour")
                },
                startValue: 0,
                endValue: 23
            },
            minutes: {
                getter: "getMinutes",
                setter: "setMinutes",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, value), "minute")
                },
                startValue: 0,
                endValue: 59
            },
            seconds: {
                getter: "getSeconds",
                setter: "setSeconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, value), "second")
                },
                startValue: 0,
                endValue: 59
            },
            milliseconds: {
                getter: "getMilliseconds",
                setter: "setMilliseconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, 0, value), "millisecond")
                },
                startValue: 0,
                endValue: 999
            }
        };
        module.exports = dateUtils
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/odata/utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.OData__internals = exports.escapeServiceOperationParams = exports.formatFunctionInvocationUrl = exports.generateExpand = exports.generateSelect = exports.convertPrimitiveValue = exports.keyConverters = exports.serializeKey = exports.serializeValue = exports.serializePropName = exports.EdmLiteral = exports.sendRequest = void 0;
        var _class = __webpack_require__( /*! ../../core/class */ 16);
        var _class2 = _interopRequireDefault(_class);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _ajax = __webpack_require__( /*! ../../core/utils/ajax */ 78);
        var _ajax2 = _interopRequireDefault(_ajax);
        var _guid = __webpack_require__( /*! ../../core/guid */ 37);
        var _guid2 = _interopRequireDefault(_guid);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _errors = __webpack_require__( /*! ../errors */ 40);
        var _utils = __webpack_require__( /*! ../utils */ 42);
        var _string = __webpack_require__( /*! ../../core/utils/string */ 41);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _typeof(obj) {
            "@babel/helpers - typeof";
            if ("function" === typeof Symbol && "symbol" === typeof Symbol.iterator) {
                _typeof = function(obj) {
                    return typeof obj
                }
            } else {
                _typeof = function(obj) {
                    return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                }
            }
            return _typeof(obj)
        }
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
        var makeArray = function(value) {
            return "string" === (0, _type.type)(value) ? value.split() : value
        };
        var hasDot = function(x) {
            return /\./.test(x)
        };
        var pad = function(text, length, right) {
            text = String(text);
            while (text.length < length) {
                text = right ? "".concat(text, "0") : "0".concat(text)
            }
            return text
        };
        var formatISO8601 = function(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            var padLeft2 = function(text) {
                return pad(text, 2)
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(padLeft2(date.getMonth() + 1));
            bag.push("-");
            bag.push(padLeft2(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(padLeft2(date.getHours()));
                bag.push(":");
                bag.push(padLeft2(date.getMinutes()));
                bag.push(":");
                bag.push(padLeft2(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(pad(date.getMilliseconds(), 3))
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        };
        var parseISO8601 = function(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3);
            var chunks = isoString.replace("Z", "").split("T");
            var date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]);
            var time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                var fractional = (time[4] || "").slice(0, 3);
                fractional = pad(fractional, 3, true);
                result.setMilliseconds(Number(fractional))
            }
            return result
        };
        var isAbsoluteUrl = function(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        };
        var stripParams = function(url) {
            var index = url.indexOf("?");
            if (index > -1) {
                return url.substr(0, index)
            }
            return url
        };
        var toAbsoluteUrl = function(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        };
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request) {
            var _options$beforeSend;
            var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
            var formatPayload = function(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw _errors.errors.Error("E4002")
                    }
                })
            };
            request = (0, _extend.extend)({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            null === (_options$beforeSend = options.beforeSend) || void 0 === _options$beforeSend ? void 0 : _options$beforeSend.call(options, request);
            var _request = request,
                async = _request.async, timeout = _request.timeout, headers = _request.headers;
            var _request2 = request,
                url = _request2.url,
                method = _request2.method;
            var jsonp = options.jsonp,
                withCredentials = options.withCredentials;
            method = (method || "get").toLowerCase();
            var isGet = "get" === method;
            var useJsonp = isGet && jsonp;
            var params = (0, _extend.extend)({}, request.params);
            var ajaxData = isGet ? params : formatPayload(request.payload);
            var qs = !isGet && param(params);
            var contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: async,
                timeout: timeout,
                headers: headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: withCredentials
                }
            }
        };
        exports.sendRequest = function sendRequest(protocolVersion, request, options) {
            var deserializeDates = options.deserializeDates,
                fieldTypes = options.fieldTypes,
                countOnly = options.countOnly,
                isPaged = options.isPaged;
            var d = new _deferred.Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            _ajax2.default.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var transformOptions = {
                    deserializeDates: deserializeDates,
                    fieldTypes: fieldTypes
                };
                var tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions);
                var error = tuple.error,
                    data = tuple.data,
                    count = tuple.count;
                var nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== _utils.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (countOnly) {
                        if (isFinite(count)) {
                            d.resolve(count)
                        } else {
                            d.reject(new _errors.errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                return d.resolve(data.concat(nextData))
                            })
                        } else {
                            var extra = isFinite(count) ? {
                                totalCount: count
                            } : void 0;
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        var formatDotNetError = function(errorObj) {
            var message;
            var currentError = errorObj;
            if ("message" in errorObj) {
                var _errorObj$message;
                message = (null === (_errorObj$message = errorObj.message) || void 0 === _errorObj$message ? void 0 : _errorObj$message.value) || errorObj.message
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus, ajaxOptions) {
            var _response, _response2, _response3, _response4;
            if ("nocontent" === textStatus) {
                return null
            }
            var message = "Unknown error";
            var response = obj;
            var httpStatus = 200;
            var errorData = {
                requestOptions: ajaxOptions
            };
            if ("success" !== textStatus) {
                var status = obj.status,
                    responseText = obj.responseText;
                httpStatus = status;
                message = (0, _utils.errorMessageFromXhr)(obj, textStatus);
                try {
                    response = JSON.parse(responseText)
                } catch (x) {}
            }
            var errorObj = (null === (_response = response) || void 0 === _response ? void 0 : _response.then) || (null === (_response2 = response) || void 0 === _response2 ? void 0 : _response2.error) || (null === (_response3 = response) || void 0 === _response3 ? void 0 : _response3["odata.error"]) || (null === (_response4 = response) || void 0 === _response4 ? void 0 : _response4["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                errorData.errorDetails = errorObj;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                var customCode = Number(errorObj.code);
                if (isFinite(customCode) && customCode >= 400) {
                    httpStatus = customCode
                }
            }
            if (httpStatus >= 400 || 0 === httpStatus) {
                errorData.httpStatus = httpStatus;
                return (0, _extend.extend)(Error(message), errorData)
            }
            return null
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
            var error = errorFromResponse(obj, textStatus, ajaxOptions);
            if (error) {
                return {
                    error: error
                }
            }
            if (!(0, _type.isPlainObject)(obj)) {
                return {
                    data: obj
                }
            }
            var value = "d" in obj && (Array.isArray(obj.d) || (0, _type.isObject)(obj.d)) ? interpretVerboseJsonFormat(obj, textStatus) : interpretLightJsonFormat(obj, textStatus);
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(_ref) {
            var _data$results;
            var data = _ref.d;
            if (!(0, _type.isDefined)(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            return {
                data: null !== (_data$results = data.results) && void 0 !== _data$results ? _data$results : data,
                nextUrl: data.__next,
                count: parseInt(data.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var _obj$value;
            return {
                data: null !== (_obj$value = obj.value) && void 0 !== _obj$value ? _obj$value : obj,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = exports.EdmLiteral = _class2.default.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        var transformTypes = function transformTypes(obj) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            (0, _iterator.each)(obj, function(key, value) {
                if (null !== value && "object" === _typeof(value)) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            deserializeDates = options.deserializeDates;
                        var canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _guid2.default(value)
                        }
                        if (false !== deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'".concat(formatISO8601(date, true, true), "'")
        };
        var serializeString = function(value) {
            return "'".concat(value.replace(/'/g, "''"), "'")
        };
        var serializePropName = exports.serializePropName = function(propName) {
            return propName instanceof EdmLiteral ? propName.valueOf() : propName.replace(/\./g, "/")
        };
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _guid2.default) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[".concat(value.map(function(item) {
                    return serializeValueV4(item)
                }).join(","), "]")
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _guid2.default) {
                return "guid'".concat(value, "'")
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = exports.serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw _errors.errors.Error("E4002")
            }
        };
        exports.serializeKey = function(key, protocolVersion) {
            if ((0, _type.isPlainObject)(key)) {
                var parts = [];
                (0, _iterator.each)(key, function(k, v) {
                    return parts.push("".concat(serializePropName(k), "=").concat(serializeValue(v, protocolVersion)))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        var keyConverters = exports.keyConverters = {
            String: function(value) {
                return "".concat(value)
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral("".concat(value, "L"))
            },
            Guid: function(value) {
                return value instanceof _guid2.default ? value : new _guid2.default(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                return value instanceof EdmLiteral ? value : new EdmLiteral(value + "m")
            }
        };
        exports.convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw _errors.errors.Error("E4014", type)
            }
            return converter(value)
        };
        exports.generateSelect = function(oDataVersion, select) {
            if (!select) {
                return
            }
            return oDataVersion < 4 ? serializePropName(select.join()) : (0, _common.grep)(select, hasDot, true).join()
        };
        var formatCore = function formatCore(hash) {
            var result = "";
            var selectValue = [];
            var expandValue = [];
            (0, _iterator.each)(hash, function(key, value) {
                if (Array.isArray(value)) {
                    [].push.apply(selectValue, value)
                }
                if ((0, _type.isPlainObject)(value)) {
                    expandValue.push("".concat(key).concat(formatCore(value)))
                }
            });
            if (selectValue.length || expandValue.length) {
                result += "(";
                if (selectValue.length) {
                    result += "$select=".concat((0, _iterator.map)(selectValue, serializePropName).join())
                }
                if (expandValue.length) {
                    if (selectValue.length) {
                        result += ";"
                    }
                    result += "$expand=".concat((0, _iterator.map)(expandValue, serializePropName).join())
                }
                result += ")"
            }
            return result
        };
        var format = function(hash) {
            var result = [];
            (0, _iterator.each)(hash, function(key, value) {
                return result.push("".concat(key).concat(formatCore(value)))
            });
            return result.join()
        };
        var parseCore = function parseCore(exprParts, root, stepper) {
            var result = stepper(root, exprParts.shift(), exprParts);
            if (false === result) {
                return
            }
            parseCore(exprParts, result, stepper)
        };
        var parseTree = function(exprs, root, stepper) {
            return (0, _iterator.each)(exprs, function(_, x) {
                return parseCore(x.split("."), root, stepper)
            })
        };
        var generatorV2 = function(expand, select) {
            var hash = {};
            if (expand) {
                (0, _iterator.each)(makeArray(expand), function() {
                    hash[serializePropName(this)] = 1
                })
            }
            if (select) {
                (0, _iterator.each)(makeArray(select), function() {
                    var path = this.split(".");
                    if (path.length < 2) {
                        return
                    }
                    path.pop();
                    hash[serializePropName(path.join("."))] = 1
                })
            }
            return (0, _iterator.map)(hash, function(_, v) {
                return v
            }).join()
        };
        var generatorV4 = function(expand, select) {
            var hash = {};
            if (expand || select) {
                if (expand) {
                    parseTree(makeArray(expand), hash, function(node, key, path) {
                        node[key] = node[key] || {};
                        return !path.length ? false : node[key]
                    })
                }
                if (select) {
                    parseTree((0, _common.grep)(makeArray(select), hasDot), hash, function(node, key, path) {
                        if (!path.length) {
                            node[key] = node[key] || [];
                            node[key].push(key);
                            return false
                        }
                        return node[key] = node[key] || {}
                    })
                }
                return format(hash)
            }
        };
        exports.generateExpand = function(oDataVersion, expand, select) {
            return oDataVersion < 4 ? generatorV2(expand, select) : generatorV4(expand, select)
        };
        exports.formatFunctionInvocationUrl = function(baseUrl, args) {
            return (0, _string.format)("{0}({1})", baseUrl, (0, _iterator.map)(args || {}, function(value, key) {
                return (0, _string.format)("{0}={1}", key, value)
            }).join(","))
        };
        exports.escapeServiceOperationParams = function(params, version) {
            if (!params) {
                return params
            }
            var result = {};
            (0, _iterator.each)(params, function(k, v) {
                result[k] = serializeValue(v, version)
            });
            return result
        };
        exports.OData__internals = {
            interpretJsonFormat: interpretJsonFormat
        }
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/viz/core/export.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.plugin = exports.ExportMenu = exports.combineMarkups = exports.exportWidgets = exports.getMarkup = exports.exportFromMarkup = void 0;
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _utils = __webpack_require__( /*! ./utils */ 15);
        var _exporter = __webpack_require__( /*! ../../exporter */ 177);
        var _exporter2 = _interopRequireDefault(_exporter);
        var _message = __webpack_require__( /*! ../../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _themes = __webpack_require__( /*! ../themes */ 53);
        var _themes2 = _interopRequireDefault(_themes);
        var _hover = __webpack_require__( /*! ../../events/hover */ 149);
        var _hover2 = _interopRequireDefault(_hover);
        var _pointer = __webpack_require__( /*! ../../events/pointer */ 24);
        var _pointer2 = _interopRequireDefault(_pointer);
        var _console = __webpack_require__( /*! ../../core/utils/console */ 73);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var imageExporter = _exporter2.default.image;
        var svgExporter = _exporter2.default.svg;
        var pdfExporter = _exporter2.default.pdf;
        var pointerActions = [_pointer2.default.down, _pointer2.default.move].join(" ");
        var BUTTON_SIZE = 35;
        var ICON_COORDS = [
            [9, 12, 26, 12, 26, 14, 9, 14],
            [9, 17, 26, 17, 26, 19, 9, 19],
            [9, 22, 26, 22, 26, 24, 9, 24]
        ];
        var LIST_PADDING_TOP = 4;
        var LIST_WIDTH = 120;
        var VERTICAL_TEXT_MARGIN = 8;
        var HORIZONTAL_TEXT_MARGIN = 15;
        var MENU_ITEM_HEIGHT = 30;
        var LIST_STROKE_WIDTH = 1;
        var MARGIN = 10;
        var SHADOW_OFFSET = 2;
        var SHADOW_BLUR = 3;
        var DEFAULT_EXPORT_FORMAT = "PNG";
        var ALLOWED_IMAGE_FORMATS = [DEFAULT_EXPORT_FORMAT, "JPEG", "GIF"];
        var ALLOWED_EXTRA_FORMATS = ["PDF", "SVG"];
        var EXPORT_CSS_CLASS = "dx-export-menu";
        var EXPORT_DATA_KEY = "export-element-type";
        var FORMAT_DATA_KEY = "export-element-format";
        var GET_COLOR_REGEX = /data-backgroundcolor="([^"]*)"/;

        function getValidFormats() {
            var imageFormats = imageExporter.testFormats(ALLOWED_IMAGE_FORMATS);
            return {
                unsupported: imageFormats.unsupported,
                supported: imageFormats.supported.concat(ALLOWED_EXTRA_FORMATS)
            }
        }

        function validateFormat(format, incidentOccurred, validFormats) {
            validFormats = validFormats || getValidFormats();
            format = String(format).toUpperCase();
            if (validFormats.supported.indexOf(format) !== -1) {
                return format
            }
            if (validFormats.unsupported.indexOf(format) !== -1) {
                incidentOccurred && incidentOccurred("W2108", [format])
            }
        }

        function getCreatorFunc(format) {
            if ("SVG" === format) {
                return svgExporter.getData
            } else {
                if ("PDF" === format) {
                    return pdfExporter.getData
                } else {
                    return imageExporter.getData
                }
            }
        }

        function _print(imageSrc, options) {
            var document = (0, _window.getWindow)().document;
            var iFrame = document.createElement("iframe");
            iFrame.onload = setPrint(imageSrc, options);
            iFrame.style.visibility = "hidden";
            iFrame.style.position = "fixed";
            iFrame.style.right = "0";
            iFrame.style.bottom = "0";
            document.body.appendChild(iFrame)
        }

        function setPrint(imageSrc, options) {
            return function() {
                var _this = this;
                var window = this.contentWindow;
                var img = window.document.createElement("img");
                window.document.body.appendChild(img);
                var origImageSrc = imageSrc;
                if (options.__test) {
                    imageSrc = options.__test.imageSrc;
                    window = options.__test.mockWindow
                }
                var removeFrame = function() {
                    options.__test && options.__test.checkAssertions();
                    _this.parentElement.removeChild(_this);
                    options.__test && options.__test.deferred.resolve(origImageSrc)
                };
                img.addEventListener("load", function() {
                    window.focus();
                    window.print();
                    removeFrame()
                });
                img.addEventListener("error", removeFrame);
                img.src = imageSrc
            }
        }

        function getItemAttributes(options, type, itemIndex) {
            var x = BUTTON_SIZE - LIST_WIDTH;
            var y = BUTTON_SIZE + LIST_PADDING_TOP + LIST_STROKE_WIDTH + itemIndex * MENU_ITEM_HEIGHT;
            var attr = {
                rect: {
                    width: LIST_WIDTH - 2 * LIST_STROKE_WIDTH,
                    height: MENU_ITEM_HEIGHT,
                    x: x + LIST_STROKE_WIDTH,
                    y: y
                },
                text: {
                    x: x + (options.rtl ? LIST_WIDTH - HORIZONTAL_TEXT_MARGIN : HORIZONTAL_TEXT_MARGIN),
                    y: y + MENU_ITEM_HEIGHT - VERTICAL_TEXT_MARGIN
                }
            };
            if ("printing" === type) {
                attr.separator = {
                    stroke: options.button.default.borderColor,
                    "stroke-width": LIST_STROKE_WIDTH,
                    cursor: "pointer",
                    sharp: "v",
                    d: "M " + x + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH) + " L " + (x + LIST_WIDTH) + " " + (y + MENU_ITEM_HEIGHT - LIST_STROKE_WIDTH)
                }
            }
            return attr
        }

        function createMenuItem(renderer, options, settings) {
            var itemData = {};
            var type = settings.type;
            var format = settings.format;
            var attr = getItemAttributes(options, type, settings.itemIndex);
            var fontStyle = (0, _utils.patchFontOptions)(options.font);
            fontStyle["pointer-events"] = "none";
            var menuItem = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list-item"
            });
            itemData[EXPORT_DATA_KEY] = type;
            if (format) {
                itemData[FORMAT_DATA_KEY] = format
            }
            var rect = renderer.rect();
            rect.attr(attr.rect).css({
                cursor: "pointer",
                "pointer-events": "all"
            }).data(itemData);
            rect.on(_hover2.default.start + ".export", function() {
                return rect.attr({
                    fill: options.button.hover.backgroundColor
                })
            }).on(_hover2.default.end + ".export", function() {
                return rect.attr({
                    fill: null
                })
            });
            rect.append(menuItem);
            var text = renderer.text(settings.text).css(fontStyle).attr(attr.text).append(menuItem);
            if ("printing" === type) {
                renderer.path(null, "line").attr(attr.separator).append(menuItem)
            }
            return {
                g: menuItem,
                rect: rect,
                resetState: function() {
                    return rect.attr({
                        fill: null
                    })
                },
                fixPosition: function() {
                    var textBBox = text.getBBox();
                    text.move(attr.text.x - textBBox.x - (options.rtl ? textBBox.width : 0))
                }
            }
        }

        function createMenuItems(renderer, options) {
            var items = [];
            if (options.printingEnabled) {
                items.push(createMenuItem(renderer, options, {
                    type: "printing",
                    text: _message2.default.format("vizExport-printingButtonText"),
                    itemIndex: items.length
                }))
            }
            items = options.formats.reduce(function(r, format) {
                r.push(createMenuItem(renderer, options, {
                    type: "exporting",
                    text: _message2.default.getFormatter("vizExport-exportButtonText")(format),
                    format: format,
                    itemIndex: r.length
                }));
                return r
            }, items);
            return items
        }

        function getBackgroundColorFromMarkup(markup) {
            var parsedMarkup = GET_COLOR_REGEX.exec(markup);
            return null === parsedMarkup || void 0 === parsedMarkup ? void 0 : parsedMarkup[1]
        }
        var exportFromMarkup = exports.exportFromMarkup = function(markup, options) {
            options.format = validateFormat(options.format) || DEFAULT_EXPORT_FORMAT;
            options.fileName = options.fileName || "file";
            options.exportingAction = options.onExporting;
            options.exportedAction = options.onExported;
            options.fileSavingAction = options.onFileSaving;
            options.margin = (0, _type.isDefined)(options.margin) ? options.margin : MARGIN;
            options.backgroundColor = (0, _type.isDefined)(options.backgroundColor) ? options.backgroundColor : getBackgroundColorFromMarkup(markup) || _themes2.default.getTheme().backgroundColor;
            _exporter2.default.export(markup, options, getCreatorFunc(options.format))
        };
        exports.getMarkup = function(widgets) {
            return combineMarkups(widgets).markup
        };
        exports.exportWidgets = function(widgets, options) {
            options = options || {};
            var markupInfo = exports.combineMarkups(widgets, {
                gridLayout: options.gridLayout,
                verticalAlignment: options.verticalAlignment,
                horizontalAlignment: options.horizontalAlignment
            });
            options.width = markupInfo.width;
            options.height = markupInfo.height;
            exportFromMarkup(markupInfo.markup, options)
        };
        var combineMarkups = exports.combineMarkups = function(widgets) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            if (!Array.isArray(widgets)) {
                widgets = [
                    [widgets]
                ]
            } else {
                if (!Array.isArray(widgets[0])) {
                    widgets = widgets.map(function(item) {
                        return [item]
                    })
                }
            }
            var compactView = !options.gridLayout;
            var exportItems = widgets.reduce(function(r, row, rowIndex) {
                var rowInfo = row.reduce(function(r, item, colIndex) {
                    var size = item.getSize();
                    var backgroundColor = item.option("backgroundColor") || _themes2.default.getTheme(item.option("theme")).backgroundColor;
                    backgroundColor && r.backgroundColors.indexOf(backgroundColor) === -1 && r.backgroundColors.push(backgroundColor);
                    r.hOffset = r.width;
                    r.width += size.width;
                    r.height = Math.max(r.height, size.height);
                    r.itemWidth = Math.max(r.itemWidth, size.width);
                    r.items.push({
                        markup: item.svg(),
                        width: size.width,
                        height: size.height,
                        c: colIndex,
                        r: rowIndex,
                        hOffset: r.hOffset
                    });
                    return r
                }, {
                    items: [],
                    height: 0,
                    itemWidth: 0,
                    hOffset: 0,
                    width: 0,
                    backgroundColors: r.backgroundColors
                });
                r.rowOffsets.push(r.totalHeight);
                r.rowHeights.push(rowInfo.height);
                r.totalHeight += rowInfo.height;
                r.items = r.items.concat(rowInfo.items);
                r.itemWidth = Math.max(r.itemWidth, rowInfo.itemWidth);
                r.maxItemLen = Math.max(r.maxItemLen, rowInfo.items.length);
                r.totalWidth = compactView ? Math.max(r.totalWidth, rowInfo.width) : r.maxItemLen * r.itemWidth;
                return r
            }, {
                items: [],
                rowOffsets: [],
                rowHeights: [],
                itemWidth: 0,
                totalHeight: 0,
                maxItemLen: 0,
                totalWidth: 0,
                backgroundColors: []
            });
            var backgroundColor = 'data-backgroundcolor="'.concat(1 === exportItems.backgroundColors.length ? exportItems.backgroundColors[0] : "", '" ');
            var getVOffset = function(item) {
                var align = options.verticalAlignment;
                var dy = exportItems.rowHeights[item.r] - item.height;
                return exportItems.rowOffsets[item.r] + ("bottom" === align ? dy : "center" === align ? dy / 2 : 0)
            };
            var getHOffset = function(item) {
                if (compactView) {
                    return item.hOffset
                }
                var align = options.horizontalAlignment;
                var colWidth = exportItems.itemWidth;
                var dx = colWidth - item.width;
                return item.c * colWidth + ("right" === align ? dx : "center" === align ? dx / 2 : 0)
            };
            var totalHeight = exportItems.totalHeight;
            var totalWidth = exportItems.totalWidth;
            return {
                markup: "<svg " + backgroundColor + 'height="' + totalHeight + '" width="' + totalWidth + '" version="1.1" xmlns="http://www.w3.org/2000/svg">' + exportItems.items.map(function(item) {
                    return '<g transform="translate('.concat(getHOffset(item), ",").concat(getVOffset(item), ')">').concat(item.markup, "</g>")
                }).join("") + "</svg>",
                width: totalWidth,
                height: totalHeight
            }
        };
        var ExportMenu = exports.ExportMenu = function(params) {
            var renderer = this._renderer = params.renderer;
            this._incidentOccurred = params.incidentOccurred;
            this._exportTo = params.exportTo;
            this._print = params.print;
            this._shadow = renderer.shadowFilter("-50%", "-50%", "200%", "200%", SHADOW_OFFSET, 6, SHADOW_BLUR);
            this._shadow.attr({
                opacity: .8
            });
            this._group = renderer.g().attr({
                "class": EXPORT_CSS_CLASS,
                "hidden-for-export": true
            }).linkOn(renderer.root, {
                name: "export-menu",
                after: "peripheral"
            });
            this._buttonGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-button"
            }).append(this._group);
            this._listGroup = renderer.g().attr({
                "class": EXPORT_CSS_CLASS + "-list"
            }).append(this._group);
            this._overlay = renderer.rect(-LIST_WIDTH + BUTTON_SIZE, BUTTON_SIZE + LIST_PADDING_TOP, LIST_WIDTH, 0);
            this._overlay.attr({
                "stroke-width": LIST_STROKE_WIDTH,
                cursor: "pointer",
                rx: 4,
                ry: 4,
                filter: this._shadow.id
            });
            this._overlay.data({
                "export-element-type": "list"
            });
            this.validFormats = getValidFormats();
            this._subscribeEvents()
        };
        (0, _extend.extend)(ExportMenu.prototype, {
            getLayoutOptions: function() {
                if (this._hiddenDueToLayout) {
                    return {
                        width: 0,
                        height: 0,
                        cutSide: "vertical",
                        cutLayoutSide: "top"
                    }
                }
                var bBox = this._buttonGroup.getBBox();
                bBox.cutSide = "vertical";
                bBox.cutLayoutSide = "top";
                bBox.height += MARGIN;
                bBox.position = {
                    vertical: "top",
                    horizontal: "right"
                };
                bBox.verticalAlignment = "top";
                bBox.horizontalAlignment = "right";
                return bBox
            },
            probeDraw: function() {
                this._fillSpace();
                this.show()
            },
            shift: function(_, y) {
                this._group.attr({
                    translateY: this._group.attr("translateY") + y
                })
            },
            draw: function(width, height, canvas) {
                this._group.move(width - BUTTON_SIZE - SHADOW_OFFSET - SHADOW_BLUR + canvas.left, Math.floor(height / 2 - BUTTON_SIZE / 2));
                var layoutOptions = this.getLayoutOptions();
                if (layoutOptions.width > width || layoutOptions.height > height) {
                    this.freeSpace()
                }
                return this
            },
            show: function() {
                this._group.linkAppend()
            },
            hide: function() {
                this._group.linkRemove()
            },
            setOptions: function(options) {
                var _this2 = this;
                this._options = options;
                if (options.formats) {
                    options.formats = options.formats.reduce(function(r, format) {
                        format = validateFormat(format, _this2._incidentOccurred, _this2.validFormats);
                        format && r.push(format);
                        return r
                    }, [])
                } else {
                    options.formats = this.validFormats.supported.slice()
                }
                options.printingEnabled = void 0 === options.printingEnabled ? true : options.printingEnabled;
                if (options.enabled && (options.formats.length || options.printingEnabled)) {
                    this.show();
                    this._updateButton();
                    this._updateList();
                    this._hideList()
                } else {
                    this.hide()
                }
            },
            dispose: function() {
                this._unsubscribeEvents();
                this._group.linkRemove().linkOff();
                this._group.dispose();
                this._shadow.dispose()
            },
            layoutOptions: function() {
                return this._options.enabled && {
                    horizontalAlignment: "right",
                    verticalAlignment: "top",
                    weak: true
                }
            },
            measure: function() {
                this._fillSpace();
                var margin = this._options.button.margin;
                return [BUTTON_SIZE + margin.left + margin.right, BUTTON_SIZE + margin.top + margin.bottom]
            },
            move: function(rect) {
                var margin = this._options.button.margin;
                this._group.attr({
                    translateX: Math.round(rect[0]) + margin.left,
                    translateY: Math.round(rect[1]) + margin.top
                })
            },
            _fillSpace: function() {
                this._hiddenDueToLayout = false;
                this.show()
            },
            freeSpace: function() {
                this._incidentOccurred("W2107");
                this._hiddenDueToLayout = true;
                this.hide()
            },
            _hideList: function() {
                this._listGroup.remove();
                this._listShown = false;
                this._setButtonState("default");
                this._menuItems.forEach(function(item) {
                    return item.resetState()
                })
            },
            _showList: function() {
                this._listGroup.append(this._group);
                this._listShown = true;
                this._menuItems.forEach(function(item) {
                    return item.fixPosition()
                })
            },
            _setButtonState: function(state) {
                var style = this._options.button[state];
                this._button.attr({
                    stroke: style.borderColor,
                    fill: style.backgroundColor
                });
                this._icon.attr({
                    fill: style.color
                })
            },
            _subscribeEvents: function() {
                var _this3 = this;
                this._renderer.root.on(_pointer2.default.up + ".export", function(e) {
                    var elementType = e.target[EXPORT_DATA_KEY];
                    if (!elementType) {
                        if (_this3._button) {
                            _this3._hideList()
                        }
                        return
                    }
                    if ("button" === elementType) {
                        if (_this3._listShown) {
                            _this3._setButtonState("default");
                            _this3._hideList()
                        } else {
                            _this3._setButtonState("focus");
                            _this3._showList()
                        }
                    } else {
                        if ("printing" === elementType) {
                            _this3._print();
                            _this3._hideList()
                        } else {
                            if ("exporting" === elementType) {
                                _this3._exportTo(e.target[FORMAT_DATA_KEY]);
                                _this3._hideList()
                            }
                        }
                    }
                });
                this._listGroup.on(pointerActions, function(e) {
                    return e.stopPropagation()
                });
                this._buttonGroup.on(_pointer2.default.enter, function() {
                    return _this3._setButtonState("hover")
                });
                this._buttonGroup.on(_pointer2.default.leave, function() {
                    return _this3._setButtonState(_this3._listShown ? "focus" : "default")
                });
                this._buttonGroup.on(_pointer2.default.down + ".export", function() {
                    return _this3._setButtonState("active")
                })
            },
            _unsubscribeEvents: function() {
                this._renderer.root.off(".export");
                this._listGroup.off();
                this._buttonGroup.off()
            },
            _updateButton: function() {
                var renderer = this._renderer;
                var options = this._options;
                var exportData = {
                    "export-element-type": "button"
                };
                if (!this._button) {
                    this._button = renderer.rect(0, 0, BUTTON_SIZE, BUTTON_SIZE).append(this._buttonGroup);
                    this._button.attr({
                        rx: 4,
                        ry: 4,
                        fill: options.button.default.backgroundColor,
                        stroke: options.button.default.borderColor,
                        "stroke-width": 1,
                        cursor: "pointer"
                    });
                    this._button.data(exportData);
                    this._icon = renderer.path(ICON_COORDS).append(this._buttonGroup);
                    this._icon.attr({
                        fill: options.button.default.color,
                        cursor: "pointer"
                    });
                    this._icon.data(exportData);
                    this._buttonGroup.setTitle(_message2.default.format("vizExport-titleMenuText"))
                }
            },
            _updateList: function() {
                var options = this._options;
                var buttonDefault = options.button.default;
                var listGroup = this._listGroup;
                var items = createMenuItems(this._renderer, options);
                this._shadow.attr({
                    color: options.shadowColor
                });
                this._overlay.attr({
                    height: items.length * MENU_ITEM_HEIGHT + 2 * LIST_STROKE_WIDTH,
                    fill: buttonDefault.backgroundColor,
                    stroke: buttonDefault.borderColor
                });
                listGroup.clear();
                this._overlay.append(listGroup);
                items.forEach(function(item) {
                    return item.g.append(listGroup)
                });
                this._menuItems = items
            }
        });

        function getExportOptions(widget, exportOptions, fileName, format) {
            if (format || exportOptions.format) {
                format = validateFormat(format || exportOptions.format, widget._incidentOccurred)
            }
            return {
                format: format || DEFAULT_EXPORT_FORMAT,
                fileName: fileName || exportOptions.fileName || "file",
                proxyUrl: exportOptions.proxyUrl,
                backgroundColor: exportOptions.backgroundColor,
                width: widget._canvas.width,
                height: widget._canvas.height,
                margin: exportOptions.margin,
                svgToCanvas: exportOptions.svgToCanvas,
                forceProxy: exportOptions.forceProxy,
                exportingAction: widget._createActionByOption("onExporting"),
                exportedAction: widget._createActionByOption("onExported"),
                fileSavingAction: widget._createActionByOption("onFileSaving")
            }
        }
        exports.plugin = {
            name: "export",
            init: function() {
                var _this4 = this;
                this._exportMenu = new exports.ExportMenu({
                    renderer: this._renderer,
                    incidentOccurred: this._incidentOccurred,
                    print: function() {
                        return _this4.print()
                    },
                    exportTo: function(format) {
                        return _this4.exportTo(void 0, format)
                    }
                });
                this._layout.add(this._exportMenu)
            },
            dispose: function() {
                this._exportMenu.dispose()
            },
            members: {
                _getExportMenuOptions: function() {
                    return (0, _extend.extend)({}, this._getOption("export"), {
                        rtl: this._getOption("rtlEnabled", true)
                    })
                },
                _disablePointerEvents: function() {
                    var pointerEventsValue = this._renderer.root.attr("pointer-events");
                    this._renderer.root.attr({
                        "pointer-events": "none"
                    });
                    return pointerEventsValue
                },
                exportTo: function(fileName, format) {
                    var _this5 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {}, fileName, format);
                    menu && menu.hide();
                    var pointerEventsValue = this._disablePointerEvents();
                    var promise = _exporter2.default.export(this._renderer.root.element, options, getCreatorFunc(options.format)).fail(_console.logger.error).always(function() {
                        _this5._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show();
                    return promise
                },
                print: function() {
                    var _this6 = this;
                    var menu = this._exportMenu;
                    var options = getExportOptions(this, this._getOption("export") || {});
                    options.__test = this._getOption("export").__test;
                    options.exportingAction = null;
                    options.exportedAction = null;
                    options.margin = 0;
                    options.format = "PNG";
                    options.forceProxy = true;
                    options.fileSavingAction = function(eventArgs) {
                        _print("data:image/png;base64,".concat(eventArgs.data), {
                            __test: options.__test
                        });
                        eventArgs.cancel = true
                    };
                    var pointerEventsValue = this._disablePointerEvents();
                    menu && menu.hide();
                    var promise = _exporter2.default.export(this._renderer.root.element, options, getCreatorFunc(options.format)).fail(_console.logger.error).always(function() {
                        _this6._renderer.root.attr({
                            "pointer-events": pointerEventsValue
                        })
                    });
                    menu && menu.show();
                    return promise
                }
            },
            customize: function(constructor) {
                var proto = constructor.prototype;
                constructor.addChange({
                    code: "EXPORT",
                    handler: function() {
                        this._exportMenu.setOptions(this._getExportMenuOptions());
                        this._change(["LAYOUT"])
                    },
                    isThemeDependent: true,
                    isOptionChange: true,
                    option: "export"
                });
                proto._optionChangesMap.onExporting = "EXPORT";
                proto._optionChangesMap.onExported = "EXPORT";
                proto._optionChangesMap.onFileSaving = "EXPORT"
            },
            fontFields: ["export.font"]
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/action.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.default = void 0;
        var _renderer = __webpack_require__( /*! ./renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _config = __webpack_require__( /*! ./config */ 32);
        var _config2 = _interopRequireDefault(_config);
        var _window = __webpack_require__( /*! ./utils/window */ 7);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 4);
        var _errors = __webpack_require__( /*! ./errors */ 23);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) {
                    descriptor.writable = true
                }
                Object.defineProperty(target, descriptor.key, descriptor)
            }
        }

        function _createClass(Constructor, protoProps, staticProps) {
            if (protoProps) {
                _defineProperties(Constructor.prototype, protoProps)
            }
            if (staticProps) {
                _defineProperties(Constructor, staticProps)
            }
            return Constructor
        }
        var Action = function() {
            function Action(action, config) {
                _classCallCheck(this, Action);
                config = config || {};
                this._action = action;
                this._context = config.context || (0, _window.getWindow)();
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            }
            _createClass(Action, [{
                key: "execute",
                value: function() {
                    var e = {
                        action: this._action,
                        args: Array.prototype.slice.call(arguments),
                        context: this._context,
                        component: this._component,
                        validatingTargetName: this._validatingTargetName,
                        cancel: false,
                        handled: false
                    };
                    var beforeExecute = this._beforeExecute;
                    var afterExecute = this._afterExecute;
                    var argsBag = e.args[0] || {};
                    if ("jQueryEvent" in argsBag && !argsBag.event) {
                        throw "The jQueryEvent field is deprecated. Please, use the `event` field instead"
                    }
                    if (!("jQueryEvent" in argsBag) && argsBag.event && (0, _config2.default)().useJQuery) {
                        Object.defineProperty(argsBag, "jQueryEvent", {
                            get: function() {
                                _errors2.default.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                                return argsBag.event
                            },
                            set: function(value) {
                                _errors2.default.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                                argsBag.event = value
                            }
                        })
                    }
                    if (!this._validateAction(e)) {
                        return
                    }
                    null === beforeExecute || void 0 === beforeExecute ? void 0 : beforeExecute.call(this._context, e);
                    if (e.cancel) {
                        return
                    }
                    var result = this._executeAction(e);
                    if (argsBag.cancel) {
                        return
                    }
                    null === afterExecute || void 0 === afterExecute ? void 0 : afterExecute.call(this._context, e);
                    return result
                }
            }, {
                key: "_validateAction",
                value: function(e) {
                    var excludeValidators = this._excludeValidators;
                    var executors = Action.executors;
                    for (var name in executors) {
                        if (!excludeValidators[name]) {
                            var _executor$validate;
                            var executor = executors[name];
                            null === (_executor$validate = executor.validate) || void 0 === _executor$validate ? void 0 : _executor$validate.call(executor, e);
                            if (e.cancel) {
                                return false
                            }
                        }
                    }
                    return true
                }
            }, {
                key: "_executeAction",
                value: function(e) {
                    var result;
                    var executors = Action.executors;
                    for (var name in executors) {
                        var _executor$execute;
                        var executor = executors[name];
                        null === (_executor$execute = executor.execute) || void 0 === _executor$execute ? void 0 : _executor$execute.call(executor, e);
                        if (e.handled) {
                            result = e.result;
                            break
                        }
                    }
                    return result
                }
            }], [{
                key: "registerExecutor",
                value: function(name, executor) {
                    if ((0, _type.isPlainObject)(name)) {
                        (0, _iterator.each)(name, Action.registerExecutor);
                        return
                    }
                    Action.executors[name] = executor
                }
            }, {
                key: "unregisterExecutor",
                value: function() {
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }(0, _iterator.each)(args, function() {
                        delete Action.executors[this]
                    })
                }
            }]);
            return Action
        }();
        exports.default = Action;
        Action.executors = {};
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0];
                var element = args[e.validatingTargetName] || args.element;
                if (element && condition((0, _renderer2.default)(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *")
                })
            },
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if ((0, _type.isFunction)(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        })
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/ui/scroll_view.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./scroll_view/ui.scroll_view */ 231)
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/viz/core/base_widget.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 3);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _dom_adapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 4);
        var _version = __webpack_require__( /*! ../../core/version */ 176);
        var _version2 = _interopRequireDefault(_version);
        var _resize_callbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 125);
        var _resize_callbacks2 = _interopRequireDefault(_resize_callbacks);
        var _string = __webpack_require__( /*! ../../core/utils/string */ 41);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _base_theme_manager = __webpack_require__( /*! ../core/base_theme_manager */ 257);
        var _base_theme_manager2 = _interopRequireDefault(_base_theme_manager);
        var _dom_component = __webpack_require__( /*! ../../core/dom_component */ 66);
        var _dom_component2 = _interopRequireDefault(_dom_component);
        var _helpers = __webpack_require__( /*! ./helpers */ 155);
        var _helpers2 = _interopRequireDefault(_helpers);
        var _utils = __webpack_require__( /*! ./utils */ 15);
        var _errors_warnings = __webpack_require__( /*! ./errors_warnings */ 818);
        var _renderer3 = __webpack_require__( /*! ./renderers/renderer */ 175);
        var _renderer4 = _interopRequireDefault(_renderer3);
        var _layout = __webpack_require__( /*! ./layout */ 820);
        var _layout2 = _interopRequireDefault(_layout);
        var _devices = __webpack_require__( /*! ../../core/devices */ 14);
        var _devices2 = _interopRequireDefault(_devices);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _floor = Math.floor;
        var OPTION_RTL_ENABLED = "rtlEnabled";
        var SIZED_ELEMENT_CLASS = "dx-sized-element";
        var _option = _dom_component2.default.prototype.option;

        function getTrue() {
            return true
        }

        function getFalse() {
            return false
        }

        function areCanvasesDifferent(canvas1, canvas2) {
            return !(canvas1.width === canvas2.width && canvas1.height === canvas2.height && canvas1.left === canvas2.left && canvas1.top === canvas2.top && canvas1.right === canvas2.right && canvas1.bottom === canvas2.bottom)
        }

        function createResizeHandler(callback) {
            var timeout;
            var handler = function() {
                clearTimeout(timeout);
                timeout = setTimeout(callback, 100)
            };
            handler.dispose = function() {
                clearTimeout(timeout);
                return this
            };
            return handler
        }

        function defaultOnIncidentOccurred(e) {
            if (!e.component._eventsStrategy.hasEvent("incidentOccurred")) {
                _errors_warnings.log.apply(null, [e.target.id].concat(e.target.args || []))
            }
        }
        var createIncidentOccurred = function(widgetName, eventTrigger) {
            return function(id, args) {
                eventTrigger("incidentOccurred", {
                    target: {
                        id: id,
                        type: "E" === id[0] ? "error" : "warning",
                        args: args,
                        text: _string.format.apply(null, [_errors_warnings.ERROR_MESSAGES[id]].concat(args || [])),
                        widget: widgetName,
                        version: _version2.default
                    }
                })
            }
        };

        function pickPositiveValue(values) {
            return values.reduce(function(result, value) {
                return value > 0 && !result ? value : result
            }, 0)
        }
        var getEmptyComponent = function() {
            var emptyComponentConfig = {
                _initTemplates: function() {},
                ctor: function(element, options) {
                    this.callBase(element, options);
                    var sizedElement = _dom_adapter2.default.createElement("div");
                    var width = options && (0, _type.isNumeric)(options.width) ? options.width + "px" : "100%";
                    var height = options && (0, _type.isNumeric)(options.height) ? options.height + "px" : this._getDefaultSize().height + "px";
                    _dom_adapter2.default.setStyle(sizedElement, "width", width);
                    _dom_adapter2.default.setStyle(sizedElement, "height", height);
                    _dom_adapter2.default.setClass(sizedElement, SIZED_ELEMENT_CLASS);
                    _dom_adapter2.default.insertElement(element, sizedElement)
                }
            };
            var EmptyComponent = _dom_component2.default.inherit(emptyComponentConfig);
            var originalInherit = EmptyComponent.inherit;
            EmptyComponent.inherit = function(config) {
                for (var field in config) {
                    if ((0, _type.isFunction)(config[field]) && "_" !== field.substr(0, 1) && "option" !== field || "_dispose" === field || "_optionChanged" === field) {
                        config[field] = _common.noop
                    }
                }
                return originalInherit.call(this, config)
            };
            return EmptyComponent
        };
        var isServerSide = !(0, _window.hasWindow)();

        function sizeIsValid(value) {
            return (0, _type.isDefined)(value) && value > 0
        }
        module.exports = isServerSide ? getEmptyComponent() : _dom_component2.default.inherit({
            _eventsMap: {
                onIncidentOccurred: {
                    name: "incidentOccurred"
                },
                onDrawn: {
                    name: "drawn"
                }
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    onIncidentOccurred: defaultOnIncidentOccurred
                })
            },
            _useLinks: true,
            _init: function() {
                var that = this;
                that._$element.children("." + SIZED_ELEMENT_CLASS).remove();
                that.callBase.apply(that, arguments);
                that._changesLocker = 0;
                that._optionChangedLocker = 0;
                that._changes = _helpers2.default.changes();
                that._suspendChanges();
                that._themeManager = that._createThemeManager();
                that._themeManager.setCallback(function() {
                    that._requestChange(that._themeDependentChanges)
                });
                that._renderElementAttributes();
                that._initRenderer();
                var linkTarget = that._useLinks && that._renderer.root;
                linkTarget && linkTarget.enableLinks().virtualLink("core").virtualLink("peripheral");
                that._renderVisibilityChange();
                that._attachVisibilityChangeHandlers();
                that._toggleParentsScrollSubscription(this._isVisible());
                that._initEventTrigger();
                that._incidentOccurred = createIncidentOccurred(that.NAME, that._eventTrigger);
                that._layout = new _layout2.default;
                linkTarget && linkTarget.linkAfter("core");
                that._initPlugins();
                that._initCore();
                linkTarget && linkTarget.linkAfter();
                that._change(that._initialChanges)
            },
            _createThemeManager: function() {
                return new _base_theme_manager2.default.BaseThemeManager(this._getThemeManagerOptions())
            },
            _getThemeManagerOptions: function() {
                return {
                    themeSection: this._themeSection,
                    fontFields: this._fontFields
                }
            },
            _initialChanges: ["LAYOUT", "RESIZE_HANDLER", "THEME", "DISABLED"],
            _initPlugins: function() {
                var that = this;
                (0, _iterator.each)(that._plugins, function(_, plugin) {
                    plugin.init.call(that)
                })
            },
            _disposePlugins: function() {
                var that = this;
                (0, _iterator.each)(that._plugins.slice().reverse(), function(_, plugin) {
                    plugin.dispose.call(that)
                })
            },
            _change: function(codes) {
                this._changes.add(codes)
            },
            _suspendChanges: function() {
                ++this._changesLocker
            },
            _resumeChanges: function() {
                var that = this;
                if (0 === --that._changesLocker && that._changes.count() > 0 && !that._applyingChanges) {
                    that._renderer.lock();
                    that._applyingChanges = true;
                    that._applyChanges();
                    that._changes.reset();
                    that._applyingChanges = false;
                    that._renderer.unlock();
                    if (that._optionsQueue) {
                        that._applyQueuedOptions()
                    }
                    that._optionChangedLocker++;
                    that._notify();
                    that._optionChangedLocker--
                }
            },
            _applyQueuedOptions: function() {
                var that = this;
                var queue = that._optionsQueue;
                that._optionsQueue = null;
                that.beginUpdate();
                (0, _iterator.each)(queue, function(_, action) {
                    action()
                });
                that.endUpdate()
            },
            _requestChange: function(codes) {
                this._suspendChanges();
                this._change(codes);
                this._resumeChanges()
            },
            _applyChanges: function() {
                var that = this;
                var changes = that._changes;
                var order = that._totalChangesOrder;
                var i;
                var ii = order.length;
                for (i = 0; i < ii; ++i) {
                    if (changes.has(order[i])) {
                        that["_change_" + order[i]]()
                    }
                }
            },
            _optionChangesOrder: ["EVENTS", "THEME", "RENDERER", "RESIZE_HANDLER"],
            _layoutChangesOrder: ["ELEMENT_ATTR", "CONTAINER_SIZE", "LAYOUT"],
            _customChangesOrder: ["DISABLED"],
            _change_EVENTS: function() {
                this._eventTrigger.applyChanges()
            },
            _change_THEME: function() {
                this._setThemeAndRtl()
            },
            _change_RENDERER: function() {
                this._setRendererOptions()
            },
            _change_RESIZE_HANDLER: function() {
                this._setupResizeHandler()
            },
            _change_ELEMENT_ATTR: function() {
                this._renderElementAttributes();
                this._change(["CONTAINER_SIZE"])
            },
            _change_CONTAINER_SIZE: function() {
                this._updateSize()
            },
            _change_LAYOUT: function() {
                this._setContentSize()
            },
            _change_DISABLED: function() {
                var renderer = this._renderer;
                var root = renderer.root;
                if (this.option("disabled")) {
                    this._initDisabledState = root.attr("pointer-events");
                    root.attr({
                        "pointer-events": "none",
                        filter: renderer.getGrayScaleFilter().id
                    })
                } else {
                    if ("none" === root.attr("pointer-events")) {
                        root.attr({
                            "pointer-events": (0, _type.isDefined)(this._initDisabledState) ? this._initDisabledState : null,
                            filter: null
                        })
                    }
                }
            },
            _themeDependentChanges: ["RENDERER"],
            _initRenderer: function() {
                var that = this;
                that._canvas = that._calculateCanvas();
                that._renderer = new _renderer4.default.Renderer({
                    cssClass: that._rootClassPrefix + " " + that._rootClass,
                    pathModified: that.option("pathModified"),
                    container: that._$element[0]
                });
                that._renderer.resize(that._canvas.width, that._canvas.height)
            },
            _disposeRenderer: function() {
                this._useLinks && this._renderer.root.checkLinks();
                this._renderer.dispose()
            },
            _getAnimationOptions: _common.noop,
            render: function() {
                this._requestChange(["CONTAINER_SIZE"]);
                var visible = this._isVisible();
                this._toggleParentsScrollSubscription(visible);
                !visible && this._stopCurrentHandling()
            },
            _toggleParentsScrollSubscription: function(subscribe) {
                var $parents = (0, _renderer2.default)(this._renderer.root.element).parents();
                var scrollEvents = "scroll.viz_widgets";
                if ("generic" === _devices2.default.real().platform) {
                    $parents = $parents.add((0, _window.getWindow)())
                }
                this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function() {
                    this._stopCurrentHandling()
                }.bind(this);
                _events_engine2.default.off((0, _renderer2.default)().add(this._$prevRootParents), scrollEvents, this._proxiedTargetParentsScrollHandler);
                if (subscribe) {
                    _events_engine2.default.on($parents, scrollEvents, this._proxiedTargetParentsScrollHandler);
                    this._$prevRootParents = $parents
                }
            },
            _stopCurrentHandling: _common.noop,
            _dispose: function() {
                var that = this;
                that.callBase.apply(that, arguments);
                that._toggleParentsScrollSubscription(false);
                that._removeResizeHandler();
                that._layout.dispose();
                that._eventTrigger.dispose();
                that._disposeCore();
                that._disposePlugins();
                that._disposeRenderer();
                that._themeManager.dispose();
                that._themeManager = that._renderer = that._eventTrigger = null
            },
            _initEventTrigger: function() {
                var that = this;
                that._eventTrigger = createEventTrigger(that._eventsMap, function(name) {
                    return that._createActionByOption(name)
                })
            },
            _calculateCanvas: function() {
                var that = this;
                var size = that.option("size") || {};
                var margin = that.option("margin") || {};
                var defaultCanvas = that._getDefaultSize() || {};
                var elementWidth = !sizeIsValid(size.width) && (0, _window.hasWindow)() ? that._$element.width() : 0;
                var elementHeight = !sizeIsValid(size.height) && (0, _window.hasWindow)() ? that._$element.height() : 0;
                var canvas = {
                    width: size.width <= 0 ? 0 : _floor(pickPositiveValue([size.width, elementWidth, defaultCanvas.width])),
                    height: size.height <= 0 ? 0 : _floor(pickPositiveValue([size.height, elementHeight, defaultCanvas.height])),
                    left: pickPositiveValue([margin.left, defaultCanvas.left]),
                    top: pickPositiveValue([margin.top, defaultCanvas.top]),
                    right: pickPositiveValue([margin.right, defaultCanvas.right]),
                    bottom: pickPositiveValue([margin.bottom, defaultCanvas.bottom])
                };
                if (canvas.width - canvas.left - canvas.right <= 0 || canvas.height - canvas.top - canvas.bottom <= 0) {
                    canvas = {
                        width: 0,
                        height: 0
                    }
                }
                return canvas
            },
            _updateSize: function() {
                var that = this;
                var canvas = that._calculateCanvas();
                that._renderer.fixPlacement();
                if (areCanvasesDifferent(that._canvas, canvas) || that.__forceRender) {
                    that._canvas = canvas;
                    that._recreateSizeDependentObjects(true);
                    that._renderer.resize(canvas.width, canvas.height);
                    that._change(["LAYOUT"])
                }
            },
            _recreateSizeDependentObjects: _common.noop,
            _getMinSize: function() {
                return [0, 0]
            },
            _getAlignmentRect: _common.noop,
            _setContentSize: function() {
                var canvas = this._canvas;
                var layout = this._layout;
                var rect = canvas.width > 0 && canvas.height > 0 ? [canvas.left, canvas.top, canvas.width - canvas.right, canvas.height - canvas.bottom] : [0, 0, 0, 0];
                rect = layout.forward(rect, this._getMinSize());
                var nextRect = this._applySize(rect) || rect;
                layout.backward(nextRect, this._getAlignmentRect() || nextRect)
            },
            DEBUG_getCanvas: function() {
                return this._canvas
            },
            DEBUG_getEventTrigger: function() {
                return this._eventTrigger
            },
            _getOption: function(name, isScalar) {
                var theme = this._themeManager.theme(name);
                var option = this.option(name);
                return isScalar ? void 0 !== option ? option : theme : (0, _extend.extend)(true, {}, theme, option)
            },
            _setupResizeHandler: function() {
                var that = this;
                var redrawOnResize = (0, _utils.parseScalar)(this._getOption("redrawOnResize", true), true);
                if (that._resizeHandler) {
                    that._removeResizeHandler()
                }
                that._resizeHandler = createResizeHandler(function() {
                    if (redrawOnResize) {
                        that._requestChange(["CONTAINER_SIZE"])
                    } else {
                        that._renderer.fixPlacement()
                    }
                });
                _resize_callbacks2.default.add(that._resizeHandler)
            },
            _removeResizeHandler: function() {
                if (this._resizeHandler) {
                    _resize_callbacks2.default.remove(this._resizeHandler);
                    this._resizeHandler.dispose();
                    this._resizeHandler = null
                }
            },
            _onBeginUpdate: _common.noop,
            beginUpdate: function() {
                var that = this;
                if (that._initialized && that._isUpdateAllowed()) {
                    that._onBeginUpdate();
                    that._suspendChanges()
                }
                that.callBase.apply(that, arguments);
                return that
            },
            endUpdate: function() {
                this.callBase();
                this._isUpdateAllowed() && this._resumeChanges();
                return this
            },
            option: function(name) {
                var that = this;
                if (that._initialized && that._applyingChanges && (arguments.length > 1 || (0, _type.isObject)(name))) {
                    that._optionsQueue = that._optionsQueue || [];
                    that._optionsQueue.push(that._getActionForUpdating(arguments))
                } else {
                    return _option.apply(that, arguments)
                }
            },
            _getActionForUpdating: function(args) {
                var that = this;
                return function() {
                    _option.apply(that, args)
                }
            },
            _clean: _common.noop,
            _render: _common.noop,
            _optionChanged: function(arg) {
                var that = this;
                if (that._optionChangedLocker) {
                    return
                }
                var partialChanges = that.getPartialChangeOptionsName(arg);
                var changes = [];
                if (partialChanges.length > 0) {
                    partialChanges.forEach(function(pc) {
                        return changes.push(that._partialOptionChangesMap[pc])
                    })
                } else {
                    changes.push(that._optionChangesMap[arg.name])
                }
                changes = changes.filter(function(c) {
                    return !!c
                });
                if (that._eventTrigger.change(arg.name)) {
                    that._change(["EVENTS"])
                } else {
                    if (changes.length > 0) {
                        that._change(changes)
                    } else {
                        that.callBase.apply(that, arguments)
                    }
                }
            },
            _notify: _common.noop,
            _optionChangesMap: {
                size: "CONTAINER_SIZE",
                margin: "CONTAINER_SIZE",
                redrawOnResize: "RESIZE_HANDLER",
                theme: "THEME",
                rtlEnabled: "THEME",
                encodeHtml: "THEME",
                elementAttr: "ELEMENT_ATTR",
                disabled: "DISABLED"
            },
            _partialOptionChangesMap: {},
            _partialOptionChangesPath: {},
            getPartialChangeOptionsName: function(changedOption) {
                var that = this;
                var fullName = changedOption.fullName;
                var sections = fullName.split(/[.]/);
                var name = changedOption.name;
                var value = changedOption.value;
                var options = this._partialOptionChangesPath[name];
                var partialChangeOptionsName = [];
                if (options) {
                    if (true === options) {
                        partialChangeOptionsName.push(name)
                    } else {
                        options.forEach(function(op) {
                            fullName.indexOf(op) >= 0 && partialChangeOptionsName.push(op)
                        });
                        if (1 === sections.length) {
                            if ("object" === (0, _type.type)(value)) {
                                that._addOptionsNameForPartialUpdate(value, options, partialChangeOptionsName)
                            } else {
                                if ("array" === (0, _type.type)(value)) {
                                    if (value.length > 0 && value.every(function(item) {
                                            return that._checkOptionsForPartialUpdate(item, options)
                                        })) {
                                        value.forEach(function(item) {
                                            return that._addOptionsNameForPartialUpdate(item, options, partialChangeOptionsName)
                                        })
                                    }
                                }
                            }
                        }
                    }
                }
                return partialChangeOptionsName.filter(function(value, index, self) {
                    return self.indexOf(value) === index
                })
            },
            _checkOptionsForPartialUpdate: function(optionObject, options) {
                return !Object.keys(optionObject).some(function(key) {
                    return options.indexOf(key) === -1
                })
            },
            _addOptionsNameForPartialUpdate: function(optionObject, options, partialChangeOptionsName) {
                var optionKeys = Object.keys(optionObject);
                if (this._checkOptionsForPartialUpdate(optionObject, options)) {
                    optionKeys.forEach(function(key) {
                        return options.indexOf(key) > -1 && partialChangeOptionsName.push(key)
                    })
                }
            },
            _visibilityChanged: function() {
                this.render()
            },
            _setThemeAndRtl: function() {
                this._themeManager.setTheme(this.option("theme"), this.option(OPTION_RTL_ENABLED))
            },
            _getRendererOptions: function() {
                return {
                    rtl: this.option(OPTION_RTL_ENABLED),
                    encodeHtml: this.option("encodeHtml"),
                    animation: this._getAnimationOptions()
                }
            },
            _setRendererOptions: function() {
                this._renderer.setOptions(this._getRendererOptions())
            },
            svg: function() {
                return this._renderer.svg()
            },
            getSize: function() {
                var canvas = this._canvas || {};
                return {
                    width: canvas.width,
                    height: canvas.height
                }
            },
            isReady: getFalse,
            _dataIsReady: getTrue,
            _resetIsReady: function() {
                this.isReady = getFalse
            },
            _drawn: function() {
                var that = this;
                that.isReady = getFalse;
                if (that._dataIsReady()) {
                    that._renderer.onEndAnimation(function() {
                        that.isReady = getTrue
                    })
                }
                that._eventTrigger("drawn", {})
            }
        });
        _helpers2.default.replaceInherit(module.exports);

        function createEventTrigger(eventsMap, callbackGetter) {
            var triggers = {};
            (0, _iterator.each)(eventsMap, function(name, info) {
                if (info.name) {
                    createEvent(name)
                }
            });
            var changes;
            triggerEvent.change = function(name) {
                var eventInfo = eventsMap[name];
                if (eventInfo) {
                    (changes = changes || {})[name] = eventInfo
                }
                return !!eventInfo
            };
            triggerEvent.applyChanges = function() {
                if (changes) {
                    (0, _iterator.each)(changes, function(name, eventInfo) {
                        createEvent(eventInfo.newName || name)
                    });
                    changes = null
                }
            };
            triggerEvent.dispose = function() {
                eventsMap = callbackGetter = triggers = null
            };
            return triggerEvent;

            function createEvent(name) {
                var eventInfo = eventsMap[name];
                triggers[eventInfo.name] = callbackGetter(name)
            }

            function triggerEvent(name, arg, complete) {
                triggers[name](arg);
                complete && complete()
            }
        }
        module.exports.DEBUG_createEventTrigger = createEventTrigger;
        module.exports.DEBUG_createIncidentOccurred = createIncidentOccurred;
        module.exports.DEBUG_stub_createIncidentOccurred = function(stub) {
            createIncidentOccurred = stub
        };
        module.exports.DEBUG_restore_createIncidentOccurred = function() {
            createIncidentOccurred = module.exports.DEBUG_createIncidentOccurred
        };
        module.exports.DEBUG_createResizeHandler = createResizeHandler
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/ui/check_box.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_