<script type="text/javascript">
    let paneL = $("#loadPanel").dxLoadPanel({
        shadingColor: "rgba(255,255,255,0.2)",
        visible: false,
        showIndicator: true,
        message: "Cargando...",
        showPane: true,
        shading: false,
        closeOnOutsideClick: false
    }).dxLoadPanel("instance");
    //  TICKETS DIRECTO
    function TicketMyj() {
        $("#popupContainer").remove();
        $("#boxHeader").append('<div id="popupContainer"></div>');
        $("#popupContainer").dxPopup({
            contentTemplate: function(contentElement){
                contentElement.attr("style", "padding:0px;");
                contentElement.append('<div class="col-md-12" id="datosj" style="padding: 10px;"></div>');
                $('#datosj').append('<div class="son"><div class="col-md-12 p-0" id="toolbarTicketj"></div><div class="col-md-12 p-0" style="padding: 5px 0px 0px 0px;" id="datagridTicketj"></div></div>');
                let dataGridTicketj = $("#datagridTicketj").dxDataGrid({
                    noDataText:"Sin Tickets Asignados",
                    paging: {
                        pageSize: 10
                    },
                    pager: {
                        allowedPageSizes: [5, 10, 15, 30],
                        infoText:"Pagina {0} de {1} | {2} Registros",
                        showInfo: true,
                        showNavigationButtons: true,
                        showPageSizeSelector: true,
                        visible: true
                    },
                    headerFilter: {
                        visible: true
                    },
                    searchPanel: {
                        visible: true,
                        highlightCaseSensitive: true,
                        placeholder: "Buscar..." 
                    },
                    filterRow:{
                        visible: true,
                        applyFilter: "auto",
                        apllyFilterText: "Aplicar Filtro",
                        showAllText: "(TODOS)",
                        betweenEndText: "Hasta",
                        betweenStartText: "Desde",
                        operationDescriptions:{
                            between: "Entre",
                            contains: "Contiene",
                            endsWith: "Termina con",
                            equal: "Igual a",
                            greaterThan: "Mayor que",
                            greaterThanOrEqual: "Mayor o Igual que",
                            lessThan: "Menor que",
                            lessThanOrEqual: "Menor o Igual que",
                            notContains: "No contiene",
                            notEqual: "No es igual que",
                            startsWith: "Comienza con"
                        },
                        resetOperationText: "Reiniciar",
                        showOperationChooser: true
                    },
                    columnChooser: {
                        enabled: true,
                        mode: "select",
                        title:"Seleccionar Columna"
                    },
                    export: {
                        enabled: true,
                        fileName: "Registros",
                    },
                    rowAlternationEnabled: true,
                    showBorders: true,
                    columns: [
                        // pdf
                        {
                            dataField: "pdf",
                            caption: "",
                            width: '5%',
                            alignment: "center",
                            allowHeaderFiltering: false,
                            cellTemplate: function(cellElement, cellInfo){
                                cellElement.css('cursor', 'pointer');
                                cellElement.css('padding', '15px 0px 15px 0px');
                                cellElement.append('<i class="dx-icon-exportpdf" style="font-size: 35px;"></i>');
                            }
                        },
                        //prioridad
                        {
                            dataField: "prioridad",
                            caption: "Prioridad",
                            alignment: "center",
                            width: '11%',
                        },
                        //dias
                        {
                            dataField: "dias",
                            caption: "Dias",
                            dataType: "string",
                            alignment: "center",
                            width: '10%',
                        },
                        //numero
                        {
                            dataField: "numero",
                            caption: "Número",
                            dataType: "number",
                            alignment: "center",
                            width: '11%',
                        },
                        //Detalle
                        {
                            dataField: "detalle",
                            caption: "Detalle",
                            alignment: "left",
                            cellTemplate: function (container, options) {
                                texto = '<div>' + options.data.lin1 + '</div>';
                                texto += '<div>' + options.data.lin2 + '</div>';
                                texto += '<div>' + options.data.lin3 + '</div>';
                                $("<div>").append(texto).appendTo(container);
                            }
                        },
                    ],
                    height: 400,
                    onCellClick: function(e){
                        if(e.rowType=="data"){
                            if (e.column.dataField == 'pdf') {
                                dir = "<?=base_url()?>gerencia/TicketReporte/" + e.data.idticket;
                        	    window.open(dir,'_blank');
                            } else {
                                paneL.show();
                                let hola = $.ajax({
                                    type: "POST",
                                    url: "<?=base_url()?>gerencia/getDataCET",
                                    data: {},
                                    dataType: "json",
                                    success:function (respuesta) {
                                        e.data.Clientes = respuesta[0].clientes;
                                        e.data.Empleados = respuesta[0].empleados;
                                        $("#popupContainer").dxPopup("instance").hide();
                                        DetalleMyTicketj(e.data);
                                        paneL.hide();
                                    },
                                    error: function (params){
                                        DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                                        paneL.hide();
                                    }
                                });
                            }
                        }
                    }
                }).dxDataGrid("instance");
                $("#toolbarTicketj").dxToolbar({
                    items: [
                        //  TEXTO
                        {
                            location: 'after',
                            locateInMenu: 'auto',
                            text: 'Gestor',
                        },
                        //  SELECT
                        {
                            location: 'after',
                            widget: 'dxSelectBox',
                            locateInMenu: 'auto',
                            options: {
                                elementAttr: {id: 'ticketSelectj'},
                                displayExpr: "Name",
                                valueExpr: "ID",
                                searchEnabled: false,
                                placeholder: "Seleccionar...",
                                width: 256,
                                onSelectionChanged: function (e) {
                                    let hola = $.ajax({
                                        type: "POST",
                                        url: "<?=base_url()?>gerencia/getRegistrosT",
                                        data: { "ID" :  e.selectedItem.ID },
                                        dataType: "json",
                                        success:function (respuesta) {
                                            dataGridTicketj.option("dataSource", respuesta);
                                        },
                                        error: function (params){
                                            DevExpress.ui.notify("Error, contactar Soporte Tecnico","warning" ,6000);
                                        }
                                    });//*/
                                }
                            }
                        },
                    ]
                }).dxToolbar("instance");
                
                paneL.show();
                let hola = $.ajax({
                    type: "POST",
                    url: "<?=base_url()?>gerencia/getGestoresT",
                    data: {},
                    dataType: "json",
                    success:function (respuesta) {
                        $("#ticketSelectj").dxSelectBox("instance").option("dataSource", respuesta[0].datos);
                        if (respuesta[0].datos.length > 0) {
                            $("#ticketSelectj").dxSelectBox("instance").option("value", "<?=$this->session->userdata('idEmpleadoUser')?>");
                        }
                        paneL.hide();
                    },
                    error: function (params){
                        // DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                        // paneL.hide();
                        console.log(params);
                        paneL.hide();
                        switch (params.status) {
                            case 0:
                                DevExpress.ui.notify("Error, fallo la conexión a Internet", "error", 4000);
                            break;
                            case 500:
                                DevExpress.ui.notify("Error, Contactar Soporte Técnico", "error", 4000);
                            break;
                            default:
                                DevExpress.ui.notify("Error, vuelva a intentar, si el incidente persiste contacte a Soporte Técnico", "error", 4000);
                            break;
                        }
                    }
                });
            },
            showTitle: true,
            title: "Mis Tickets Asignados",
            visible: false,
            dragEnabled: true,
            width: 1000,
            height: 'auto'
        });
        $("#popupContainer").dxPopup("instance").show();
    }
    function DetalleMyTicketj(Data) {
        $("#popupAdicionar").remove();
        $("#popupContainer").remove();
        $("#boxHeader").append('<div id="popupContainer"></div>');
        $("#popupContainer").dxPopup({
            title: 'MODIFICAR SOLICITUD: ' + Data.gestion,
            visible: false,
            shading: true,
            width: 1000,
            height: "auto",
            showCloseButton: true,
            contentTemplate: function(contentElement){
                contentElement.attr('style','padding:0px;');
                contentElement.append('<div class="col-xs-12 col-sm-6 col-md-6" style="padding-top:0px; padding-right:0px;" id="contentBox1"></div>');
                contentElement.append('<div class="col-xs-12 col-sm-6 col-md-6" style="padding-top:0px;" id="contentBox2"></div>');
                contentElement.append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:0px;" id="contentBox3"></div>');
                contentElement.append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:10px; padding-bottom:10px;"><div id="btnCancelarService" style="float:right;"></div><div id="btnAnularService" style="float:right; margin-right:5px;"></div><div id="btnCompleteService" style="float:right; margin-right:5px;"></div><div id="btnGuardarService" style="float:right; margin-right:5px;"></div></div>');
                contentElement.append('<div class="toolHidden" hidden="hidden" id="toolTipContacto">Adicionar Contacto</div>');
                contentElement.append('<div class="toolHidden" hidden="hidden" id="toolTipSave">Guardar Cambios</div>');
                contentElement.append('<div class="toolHidden" hidden="hidden" id="toolTipComp">Completar Ticket</div>');
                contentElement.append('<div class="toolHidden" hidden="hidden" id="toolTipAnul">Anular Ticket</div>');
                contentElement.append('<input type="hidden" id="idCliente">');
                
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Fecha:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="inputFecha"></div></div></div>');
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Gestión:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="inputGestion"></div></div></div>');
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Sistema:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="inputSistema"></div></div></div>');
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Cliente:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="inputCliente"></div></div></div>');
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Contacto:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="btnContacto" style="float:left;"></div><div id="inputContacto" style="float:left; margin-left:5px;"></div></div></div>');
                $("#contentBox1").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-3 col-md-3" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Asignado a:</h5></div><div class="col-xs-12 col-sm-9 col-md-9" style="padding-left:0px; padding-right:0px;"><div id="inputAsignado"></div></div></div>');
                $("#contentBox2").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:5px; margin-right:10px;">Información Gestión:</h5><div class="col-xs-12 col-sm-12 col-md-12" id="itemsLinks" style="padding:0px; height:175px;"></div></div>');
                $("#contentBox3").append('<div class="col-xs-8 col-sm-8 col-md-8" style="padding-top:5px; padding-left:0px; padding-right:10px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:5px; margin-right:10px;">Detalle Solicitud:</h5><div id="inputDetalle"></div></div>');
                $("#contentBox3").append('<div class="col-xs-4 col-sm-4 col-md-4" style="padding-top:5px; padding-left:0px; padding-right:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:5px; margin-right:10px;">Notas Solución ó Motivo Anulación:</h5><div id="inputNotas"></div></div>');
                
                var validationGroupName = "validateTickets";

                $("#inputFecha").dxDateBox({
                    name: "inputFecha",
                    width: 150,
                    displayFormat: "dd/MM/yyyy",
                    stylingMode: "filled",
                    readOnly: true,
                    value: Data.fecha
                });

                $("#inputGestion").dxSelectBox({
                    name: "inputGestion",
                    displayExpr: "descrip",
                    valueExpr: "id",
                    searchEnabled: true,
                    stylingMode: "filled",
                    noDataText: "No se han encontrado datos",
                    placeholder: "Seleccionar Gestión",
                    onValueChanged: function(e){
                        var dataGestion = $("#inputGestion").dxSelectBox("instance").option("dataSource");

                        for(var idx in dataGestion){
                            var reg = dataGestion[idx];

                            if(reg['id'] == e.value){
                                $("#itemsLinks").empty();
                                $("#itemsLinks").append(reg['links']);
                                //$("#ticketPrint").val(reg['printable']);
                            }
                        }
                    }
                }).dxValidator({
                    validationRules: [{
                        type: "required",
                        message: "Gestión es requerida"
                    }],
                    validationGroup: validationGroupName
                });

                var infoGestion = {idgestion: Data.id_gestion}
                $.ajax({
                    type: "POST",
                    url: "<?=base_url()?>gerencia/getSubsTiposServicios",
                    dataType: "json",
                    data: infoGestion,
                    success: function(data){
                        $("#inputGestion").dxSelectBox("instance").option('dataSource', data);
                        $("#inputGestion").dxSelectBox("instance").option('value', Data.idgestion);
                    }
                });

                $.ajax({
                    type: "POST",
                    url: "<?=base_url()?>gerencia/getTiposSistema",
                    dataType: "json",
                    data: infoGestion,
                    success: function(dataSimple){
                        var sistemDataSource = new DevExpress.data.DataSource({
                            store: {
                                data: dataSimple,
                                type: "array",
                                key: "id"
                            }
                        });

                        $("#inputSistema").dxSelectBox({
                            name: "inputSistema",
                            displayExpr: "descrip",
                            valueExpr: "id",
                            searchEnabled: true,
                            stylingMode: "filled",
                            acceptCustomValue: true,
                            noDataText: "No se han encontrado datos",
                            placeholder: "Seleccionar o Digitar Sistema",
                            dataSource: sistemDataSource,
                            value: Data.sistema,
                            onCustomItemCreating: function(data) {
                                if( !data.text ) {
                                    data.customItem = null;
                                    return;
                                }
                                
                                var newItem = {
                                    descrip: data.text,
                                    id: data.text
                                };

                                sistemDataSource.store().insert(newItem);
                                sistemDataSource.load();

                                data.customItem = newItem;
                            }
                        });
                    }
                });

                $("#inputCliente").dxAutocomplete({
                    dataSource: Data.Clientes,
                    placeholder: "Seleccionar Cliente",
                    stylingMode: "filled",
                    searchExpr: "descrip",
                    valueExpr: "descrip",
                    value: Data.user_name,
                    itemTemplate: function(itemData, itemIndex, itemTemplate){
                        itemTemplate.append(itemData.descrip);
                    },
                    onSelectionChanged: function(e){
                        if(e.selectedItem.id != undefined){
                            $("#idCliente").val(e.selectedItem.id);
                            
                            var infoData = {idcliente: e.selectedItem.id}
                            $.ajax({
                                type: "POST",
                                url: "<?=base_url()?>cliente/getContactosCliente",
                                dataType: "json",
                                data: infoData,
                                success: function(data){
                                    $("#inputContacto").dxSelectBox("instance").option('dataSource', data);
                                }
                            });
                        }else{
                            $("#idCliente").val("");
                        }
                    }
                }).dxValidator({
                    validationRules: [{
                        type: "required",
                        message: "Cliente es requerido"
                    }],
                    validationGroup: validationGroupName
                });
                
                $("#idCliente").val(Data.idaccount);
                
                var infoData = {idcliente: Data.idaccount}
                $.ajax({
                    type: "POST",
                    url: "<?=base_url()?>cliente/getContactosCliente",
                    dataType: "json",
                    data: infoData,
                    success: function(data){
                        $("#inputContacto").dxSelectBox("instance").option('dataSource', data);
                        $("#inputContacto").dxSelectBox("instance").option('value', Data.idcontacto);
                    }
                });

                $("#btnContacto").dxButton({
                    stylingMode: "outlined",
                    type: "default",
                    icon: "group",
                    onClick: function(e){
                        if($("#idCliente").val() == ""){
                            DevExpress.ui.notify("Se debe seleccionar un cliente valido.", "error", 2500);
                        }else{
                            adicionarContactoMyTicketj();
                        }
                    }
                });

                $("#inputContacto").dxSelectBox({
                    name: "inputContacto",
                    displayExpr: "descrip",
                    valueExpr: "id",
                    searchEnabled: true,
                    stylingMode: "filled",
                    width: "88.5%",
                    noDataText: "No se han encontrado datos",
                    placeholder: "Seleccionar Contacto"
                }).dxValidator({
                    validationRules: [{
                        type: "required",
                        message: "Contacto es requerido"
                    }],
                    validationGroup: validationGroupName
                });

                $("#inputAsignado").dxSelectBox({
                    name: "inputAsignado",
                    dataSource: Data.Empleados,
                    displayExpr: "descrip",
                    valueExpr: "id",
                    searchEnabled: true,
                    stylingMode: "filled",
                    noDataText: "No se han encontrado datos",
                    placeholder: "Asignar la Solicitud",
                    value: Data.idworker
                }).dxValidator({
                    validationRules: [{
                        type: "required",
                        message: "Asignación es requerida"
                    }],
                    validationGroup: validationGroupName
                });
                
                $("#inputDetalle").dxTextArea({
                    name: "inputDetalle",
                    value: "",
                    height: 200,
                    stylingMode: "filled",
                    value: Data.descrip
                }).dxValidator({
                    validationRules: [{
                        type: 'required',
                        message: 'La información de su solicitud es requerida'
                    }],
                    validationGroup: validationGroupName
                });
                
                $("#inputNotas").dxTextArea({
                    name: "inputNotas",
                    value: "",
                    height: 200,
                    stylingMode: "filled",
                    value: Data.notas
                });
                //  BOTONES
                $("#btnGuardarService").dxButton({
                    icon: "save",
                    type: "default",
                    useSubmitBehavior: true,
                    onClick: function(e){
                        var result = e.validationGroup.validate();
                        if(result.isValid){
                            paneL.show();
                            
                            var infoSource = {
                                idticket: Data.idticket, 
                                gestion: $("input[name=inputGestion]").val(), //-
                                sistema:$("input[name=inputSistema]").val(),//-
                                cliente:$("#idCliente").val(), //-
                                contacto:$("input[name=inputContacto]").val(), //-
                                asignado:$("input[name=inputAsignado]").val(), //-
                                solicitud:$("textarea[name=inputDetalle]").val(),//-
                                fechaini: '2020-09-15',//-
                                fechafin: '2020-08-15',//-
                            };
                            $.ajax({
                                type: "POST",
                                url: "<?=base_url()?>gerencia/modificarTicket",
                                dataType: "json",
                                data: infoSource,
                                success: function(data){
                                    paneL.hide();
                                    $("#popupContainer").dxPopup("instance").hide();
                                    //$("#dataGridTickets").dxDataGrid("instance").option("dataSource", data.sourceTickets);

                                    //if($("#ticketPrint").val() == 1) ejecutarPrintTicket(data.sourceTickets[data.position]);
                                }
                            });
                        }
                    },
                    validationGroup: validationGroupName
                });
                $("#btnCompleteService").dxButton({
                    icon: "check",
                    type: "success",
                    onClick: function(e){
                        paneL.show();
                            
                        var infoSource = {
                            idticket: Data.idticket, 
                            estado: 2, 
                            notas: $("textarea[name=inputNotas]").val(), 
                            fechaini: '2020-09-15',
                            fechafin: '2020-08-15',
                        };
                        $.ajax({
                            type: "POST",
                            url: "<?=base_url()?>gerencia/updateEstadoTicket",
                            dataType: "json",
                            data: infoSource,
                            success: function(data){
                                paneL.hide();
                                $("#popupContainer").dxPopup("instance").hide();
                                //$("#dataGridTickets").dxDataGrid("instance").option("dataSource", data.sourceTickets);
                            }
                        });
                    }
                });
                $("#btnAnularService").dxButton({
                    icon: "trash",
                    type: "normal",
                    onClick: function(e){
                        var infoSource = {
                            idticket: Data.idticket, 
                            estado: 9, 
                            notas: $("textarea[name=inputNotas]").val(), 
                            fechaini: '2020-09-15',
                            fechafin: '2020-08-15',
                        };
                        $.ajax({
                            type: "POST",
                            url: "<?=base_url()?>gerencia/updateEstadoTicket",
                            dataType: "json",
                            data: infoSource,
                            success: function(data){
                                paneL.hide();
                                $("#popupContainer").dxPopup("instance").hide();
                                //$("#dataGridTickets").dxDataGrid("instance").option("dataSource", data.sourceTickets);
                            }
                        });
                    }
                });
                $("#btnCancelarService").dxButton({
                    icon: "close",
                    type: "danger",
                    onClick: function(e){
                        $("#popupContainer").dxPopup("instance").hide();
                    }
                });
                //- TOOLTIPS
                $("#toolTipContacto").dxTooltip({
                    target: "#btnContacto",
                    showEvent: "mouseenter",
                    hideEvent: "mouseleave",
                    position: "right"
                });
                $("#toolTipSave").dxTooltip({
                    target: "#btnGuardarService",
                    showEvent: "mouseenter",
                    hideEvent: "mouseleave",
                    position: "top"
                });
                $("#toolTipComp").dxTooltip({
                    target: "#btnCompleteService",
                    showEvent: "mouseenter",
                    hideEvent: "mouseleave",
                    position: "top"
                });
                $("#toolTipAnul").dxTooltip({
                    target: "#btnAnularService",
                    showEvent: "mouseenter",
                    hideEvent: "mouseleave",
                    position: "top"
                });
            }
        });
        $("#popupContainer").dxPopup("instance").show();
    }
    function adicionarContactoMyTicketj(){
        $("#popupContacto").remove();
        $("#boxHeader").append('<div id="popupContacto"></div>');

        $("#popupContacto").dxPopup({
            title: 'Adicionar Contacto',
            visible: false,
            shading: true,
            width: 500,
            height: "auto",
            showCloseButton: true,
            contentTemplate: function(contentElement){
                contentElement.attr('style','padding:0px;');
                contentElement.append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:0px;" id="contactoBox"></div>');
                contentElement.append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:10px; padding-bottom:10px;"><div id="btnCancelContacto" style="float:right;"></div><div id="btnGuardarContacto" style="float:right; margin-right:5px;"></div></div>');
                                    
                $("#contactoBox").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-2 col-md-2" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Nombre:</h5></div><div class="col-xs-12 col-sm-10 col-md-10" style="padding-left:0px; padding-right:0px;"><div id="inputNombre"></div></div></div>');
                $("#contactoBox").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-2 col-md-2" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Ubicación:</h5></div><div class="col-xs-12 col-sm-10 col-md-10" style="padding-left:0px; padding-right:0px;"><div id="inputUbicacion"></div></div></div>');
                $("#contactoBox").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-2 col-md-2" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Teléfono:</h5></div><div class="col-xs-12 col-sm-10 col-md-10" style="padding-left:0px; padding-right:0px;"><div id="inputTelefono"></div></div></div>');
                $("#contactoBox").append('<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:5px; padding-left:0px; padding-right:0px;"><div class="col-xs-12 col-sm-2 col-md-2" style="padding:0px;"><h5 style="font-size:14px; font-weight:bold; color:#000; margin-bottom:0px; margin-top:8px; margin-right:10px; text-align:right;">Correo:</h5></div><div class="col-xs-12 col-sm-10 col-md-10" style="padding-left:0px; padding-right:0px;"><div id="inputCorreo"></div></div></div>');
                
                var validationName = "validateContacto";

                $("#inputNombre").dxTextBox({
                    name: "inputNombre",
                    stylingMode: "filled",
                    value: ""
                }).dxValidator({
                    validationRules: [{
                        type: 'required',
                        message: 'Nombre es requerido'
                    }],
                    validationGroup: validationName
                });

                $("#inputUbicacion").dxTextBox({
                    name: "inputUbicacion",
                    stylingMode: "filled",
                    value: ""
                });

                $("#inputTelefono").dxTextBox({
                    name: "inputTelefono",
                    stylingMode: "filled",
                    value: ""
                });

                $("#inputCorreo").dxTextBox({
                    name: "inputCorreo",
                    stylingMode: "filled",
                    value: ""
                });
                
                $("#btnGuardarContacto").dxButton({
                    icon: "check",
                    type: "success",
                    useSubmitBehavior: true,
                    onClick: function(e){
                        var result = e.validationGroup.validate();
                        if(result.isValid){
                            paneL.show();
                            $("#btnGuardarContacto").dxButton("instance").option("disabled", true);

                            var infoSource = {
                                idauxi:$("#idCliente").val(), 
                                ubicacion:$("input[name=inputUbicacion]").val(), 
                                descrip:$("input[name=inputNombre]").val(), 
                                telefono:$("input[name=inputTelefono]").val(), 
                                correo:$("input[name=inputCorreo]").val()
                            }
                            $.ajax({
                                type: "POST",
                                url: "<?=base_url()?>cliente/adicionarContactoCliente",
                                dataType: "json",
                                data: infoSource,
                                success: function(data){
                                    paneL.hide();
                                    $("#popupContacto").dxPopup("instance").hide();

                                    $("#inputContacto").dxSelectBox("instance").option('dataSource', data.informacion);
                                    $("#inputContacto").dxSelectBox("instance").option('value', data.idcontacto);
                                }
                            });
                        }
                    },
                    validationGroup: validationName
                });
                
                $("#btnCancelContacto").dxButton({
                    icon: "close",
                    type: "danger",
                    onClick: function(e){
                        $("#popupContacto").dxPopup("instance").hide();
                    }
                });
            },
            onShown: function(e){
                $("#inputNombre").dxTextBox("instance").focus();
            }
        });

        $("#popupContacto").dxPopup("instance").show();
    }
    //  BUSQ. CONTACTOS DIRECTO
    function BContactosjr(EmpresasBCDj) {
        $("#popupContainer").remove();
        $("#boxHeader").append('<div id="popupContainer"></div>');
        $("#popupContainer").dxPopup({
            contentTemplate: function(contentElement){
                contentElement.attr("style", "padding:0px;");
                contentElement.append('<div class="col-md-12" id="datosj" style="padding: 10px;"></div>');
                $('#datosj').append('<div class="son"><div class="col-md-12 p-0" id="toolbarBCDj" style="margin-bottom: 2px;"></div><div class="col-md-12 p-0" id="datagridBCDj"></div></div>');
                let dataGridBCDj = $("#datagridBCDj").dxDataGrid({
                    dataSource: [],
                    noDataText:"Sin Datos",
                    headerFilter: {
                        visible: true
                    },
                    filterRow:{
                        visible: true,
                        applyFilter: "auto",
                        apllyFilterText: "Aplicar Filtro",
                        showAllText: "(TODOS)",
                        betweenEndText: "Hasta",
                        betweenStartText: "Desde",
                        operationDescriptions:{
                            between: "Entre",
                            contains: "Contiene",
                            endsWith: "Termina con",
                            equal: "Igual a",
                            greaterThan: "Mayor que",
                            greaterThanOrEqual: "Mayor o Igual que",
                            lessThan: "Menor que",
                            lessThanOrEqual: "Menor o Igual que",
                            notContains: "No contiene",
                            notEqual: "No es igual que",
                            startsWith: "Comienza con"
                        },
                        resetOperationText: "Reiniciar",
                        showOperationChooser: true
                    },
                    editing: {
                        allowUpdating: true,
                        allowDeleting: true,
                        mode: 'form',//'form', //'row',//popup',//
                        texts:{
                            addRow: "Agregar",
                            cancelRowChanges: "Cancelar",
                            deleteRow: "Eliminar",
                            editRow: "Modificar",
                            saveRowChanges: "Guardar",
                            cancelAllChanges: "Descartar cambios",
                            confirmDeleteMessage: "¿Estás seguro de eliminar el registro?",
                            saveAllChanges: "Guardar"
                        },
                        useIcons:true,
                        form: { 
                            labelLocation: "top",
                        }
                    },
                    rowAlternationEnabled: true,
                    showBorders: true,
                    columns: [
                        //nombre contacto
                        {
                            dataField: "nombre",
                            caption: "Nombre",
                            alignment: "left",
                            dataType: "string",
                            validationRules: [{ type: "required", message: "Nombre es requerido" }],
                        },
                        //empresa
                        {
                            dataField: "idempresa",
                            caption: "Empresa",
                            dataType: "string",
                            alignment: "left",
                            formItem: {
                                editorType: "dxSelectBox",
                                editorOptions: {
                                    dataSource: EmpresasBCDj,
                                    elementAttr: {id: 'SEBCDirectj'},
                                    placeholder: "Seleccionar",
                                    displayExpr: "Name",
                                    valueExpr: "ID",
                                    searchEnabled: true,
                                },
                                validationRules: [{ type: "required", message: "Empresa es requerida" }],
                            },
                            cellTemplate: function(cellElement, cellInfo) {cellElement.append(cellInfo.data.empresa);}
                        },
                        //telefono
                        {
                            allowFiltering: false,
                            dataField: "telefono",
                            caption: "Telefono",
                            dataType: "string",
                            alignment: "center",
                            width: '11%',
                        },
                        //correo
                        {
                            allowFiltering: false,
                            dataField: "correo",
                            caption: "Correo",
                            dataType: "number",
                            alignment: "left",
                            width: '20%',
                            formItem: {
                                editorType: "dxTextBox",
                                editorOptions: {
                                },
                                validationRules: [{ type: "email", message: "Correo es inválido"}]
                            },
                        },
                        //cargo
                        {
                            allowFiltering: false,
                            dataField: "cargo",
                            caption: "Cargo",
                            alignment: "left",
                            width: '20%',
                        },
                        // BORRAR
                        /*{
                            dataField: "borrar",
                            caption: "",
                            width: '5%',
                            alignment: "center",
                            allowHeaderFiltering: false,
                            cellTemplate: function(cellElement, cellInfo){
                                cellElement.css('cursor', 'pointer');
                                cellElement.css('padding', '2px');
                                cellElement.css('vertical-align', 'middle');
                                cellElement.append('<i class="dx-icon-trash" style="font-size: 20px; color: red;"></i>');
                            }
                        }//*/
                    ],
                    onRowInserting: function(e) {
                        //console.log(e)
                        let idempresa = e.data.idempresa;
                        let Datos = {
                            ID: null,
                            nombre: e.data.nombre,
                            idempresa: idempresa,
                            empresa: EmpresasBCDj.find(e => e.ID == idempresa).Name,
                            tipo: EmpresasBCDj.find(e => e.ID == idempresa).tipo,
                            telefono: (e.data.telefono !=  undefined) ? e.data.telefono : '',
                            correo: (e.data.correo != undefined) ? e.data.correo : '',
                            cargo: (e.data.cargo != undefined) ? e.data.cargo : '',
                        }; 
                        e.data = Datos;
                        //console.log(Datos)
                        paneL.show();
                        let hola = $.ajax({
                            type: "POST",
                            url: "<?=base_url()?>gerencia/setBContactosD",
                            data: Datos,
                            dataType: "json",
                            success:function (respuesta) {
                                if (respuesta[0].valido) {
                                    //console.log(dataGridBCDj.option("dataSource"))
                                    dataGridBCDj.option("dataSource").forEach(element => {
                                        if (element.ID == null) element.ID = respuesta[0].id
                                    });
                                    //console.log(dataGridBCDj.option("dataSource"))
                                }
                                else DevExpress.ui.notify("Error al guardar, contactar Soporte Tecnico","error" ,6000);
                                paneL.hide(); 
                            },
                            error: function (params){
                                DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                                paneL.hide();
                            }
                        });//*/
                    },
                    onRowUpdating: function(e){
                        //console.log(e);
                        let idempresa = (e.newData.idempresa == undefined) ? e.oldData.idempresa : e.newData.idempresa;
                        let Datos = {
                            ID: e.oldData.ID,
                            idempresa: idempresa,
                            empresa: EmpresasBCDj.find(e => e.ID == idempresa).Name,
                            tipo: EmpresasBCDj.find(e => e.ID == idempresa).tipo,
                            nombre: (e.newData.nombre == undefined) ? e.oldData.nombre : e.newData.nombre,
                            telefono: (e.newData.telefono == undefined) ? e.oldData.telefono : e.newData.telefono,
                            correo: (e.newData.correo == undefined) ? e.oldData.correo : e.newData.correo,
                            cargo: (e.newData.cargo == undefined) ? e.oldData.cargo : e.newData.cargo,
                        };
                        //console.log(Datos);
                        e.newData = Datos;
                        paneL.show();
                        let hola = $.ajax({
                            type: "POST",
                            url: "<?=base_url()?>gerencia/updateBContactosD",
                            data: Datos,
                            dataType: "json",
                            success:function (respuesta) { 
                                if (!respuesta[0].valido) DevExpress.ui.notify("Error al actuaizar, contactar Soporte Tecnico","error" ,6000);
                                paneL.hide(); 
                            },
                            error: function (params){
                                DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                                paneL.hide();
                            }
                        });//*/
                    },
                    onRowRemoving: function(e){
                        let Datos = {ID: e.data.ID};
                        let hola = $.ajax({
                            type: "POST",
                            url: "<?=base_url()?>gerencia/deleteBContactosD",
                            data: Datos,
                            dataType: "json",
                            success:function (respuesta) { paneL.hide(); },
                            error: function (params){
                                DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                                paneL.hide();
                            }
                        });
                    },
                    height: 400,
                }).dxDataGrid("instance");
                $("#toolbarBCDj").dxToolbar({
                    items: [
                        //  TEXTBOX
                        {
                            location: 'after',
                            widget: 'dxTextBox',
                            locateInMenu: 'auto',
                            options: {
                                elementAttr: {id: 'TBCDirectj'},
                                placeholder: "Nombre / Cargo / Empresa...",
                                valueChangeEvent: "keyup",
                                width: 256,
                                showClearButton: true,
                                stylingMode: "filled",
                                onKeyUp: function (data) {
                                    if (data.event.key == "Enter") {
                                        let valor = data.component._options._optionManager._options.value;
                                        if (valor.trim().length > 0) {
                                            paneL.show();
                                            let hola = $.ajax({
                                                type: "POST",
                                                url: "<?=base_url()?>gerencia/getBContactosD",
                                                data: {nombre: valor},
                                                dataType: "json",
                                                success:function (respuesta) {
                                                    dataGridBCDj.option("dataSource", respuesta);
                                                    paneL.hide();
                                                },
                                                error: function (params){
                                                    DevExpress.ui.notify("Error, contactar Soporte Tecnico","error" ,6000);
                                                    paneL.hide();
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        },
                        // BOTON
                        {
                            location: 'after',
                            widget: 'dxButton',
                            locateInMenu: 'auto',
                            options: {
                                elementAttr: {id: 'BBCDirectj'},
                                icon: "plus",
                                onClick: function (e) {$("#datagridBCDj").dxDataGrid("instance").addRow();}
                            }
                        },
                    ]
                }).dxToolbar("instance");
            },
            onShown: function (data) {
                $("#TBCDirectj").dxTextBox("instance").focus();
            },
            showTitle: true,
            title: "Búsqueda de Contactos",
            visible: false,
            dragEnabled: true,
            width: 1000,
            height: 'auto'
        });
        $("#popupContainer").dxPopup("instance").show();
    }
</script>