<!DOCTYPE html>
<?php $this->load->helper('url');
setlocale(LC_TIME, 'es_SV');
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if ($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado') || !isset($_SESSION['menuSite']) || !isset($_SESSION['appsSite']) || !isset($_SESSION['userPerm']) || $this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
    redirect('login/cerrar_sesion');
}
?>
<html>
<? $this->load->view('headerFilesQuill_U'); ?>
<style>
    .boxPanel {
        background-color: <?= $this->session->userdata('FHBackground') ?>;
        color: <?= $this->session->userdata('FHFontColor') ?>;
    }

    .tabla_suc-container {
        padding: 0 0 5px 10px;
        font-size: 12px;
        font-weight: bold;
    }

    .tabla_suc-container>div:first-child {
        padding: 0 0 5px 10px;
        font-size: 12px;
        font-weight: bold;
    }

    .dx-dropdowneditor-overlay>.dx-overlay-content>.dx-popup-content {
        padding-left: 5px !important;
        padding-right: 5px !important;
        padding-top: 8px !important;
        padding-bottom: 8px !important;
    }
</style>

<body>
    <div id="wrapper">
        <div id="main">
            <div class="inner">
                <? $this->load->view('tituloPaginas'); ?>
                <!-- Dentro de este section, van los formularios ya creados anteriormente --> 
                <section style="padding-top:10px;">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <div class="panel panel-primary" style="border-color:#FFF;">
                                <div class="panel-body" style="padding:0px; background-color:<?= $this->session->userdata('FrBackground') ?>;">
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:10px; padding-bottom:10px;">
                                        <div style="float:right;" id="toolbar"></div>
                                        <input type="hidden" id="contraReport" readonly><input type="hidden" id="reportUrl">
                                        <input type="hidden" id="needParam" readonly><input type="hidden" id="paramVal"><input type="hidden" id="idSucursales">
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:10px; padding-bottom:10px;">
                                        <div id="gridRepedido"></div>
                                        <div id="popupPassword"></div>
                                        <div id="loadPanel"></div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:10px; padding-bottom:10px;">
                                        <? foreach ($formatos as $form) { ?>
                                            <div class="toolHidden" hidden="hidden" id="toolTip<?= $form->idform ?>"><?= trim($form->descrip) ?></div>
                                        <? } ?>
                                        <div class="toolHidden" hidden="hidden" id="toolTipSalir">Salir</div>
                                        <div class="toolHidden" hidden="hidden" id="toolTipAdicionar">Adicionar</div>
                                        <div class="toolHidden" hidden="hidden" id="toolTipReporteComision">Reporte de Liquidación por Emprendedor</div>

                                    </div>
                                    <div id="caja_pop">
                                        <div id="popDetalle"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <? $this->load->view('menu_navside'); ?>
    </div>
    <div id="popupContainer"></div>
</body>

</html>
<script src="https://momentjs.com/downloads/moment.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".btn_icon").tooltip();
        let arrayInfo;
        let arrayProvee;
        var loadPanel = $("#loadPanel").dxLoadPanel({
            shadingColor: "rgba(255,255,255,0.2)",
            visible: false,
            showIndicator: true,
            message: "Cargando...",
            showPane: true,
            shading: false,
            closeOnOutsideClick: false
        }).dxLoadPanel("instance");

        var sucursales = [
            <? foreach ($sucursales as $suc) { ?> {
                    "id": "<?= $suc->idcentro ?>",
                    "descrip": "<?= $suc->descrip ?>"
                },
            <? } ?>
        ];

        var date = new Date();
        var primerDia = new Date(date.getFullYear(), date.getMonth(), 1);
        var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0);

        var mainToolbar = $("#toolbar").dxToolbar({
            items: [{
                    location: 'before',
                    locateInMenu: 'auto',
                    template: function() {
                        return $('<h4 class="txtEstado"style="margin-top:15px;color:#999999; font-weight:400;">Sucursal: </h4>');
                    }
                }, {
                    location: 'before',
                    locateInMenu: 'auto',
                    widget: 'dxDropDownBox',
                    options: {
                        elementAttr: {
                            id: "inputSucursal"
                        },
                        name: "sucursal",
                        displayExpr: "descrip",
                        valueExpr: "id",
                        placeholder: "Seleccionar Sucursales",
                        dataSource: new DevExpress.data.ArrayStore({
                            data: sucursales,
                            key: "id"
                        }),
                        width: 310,
                        contentTemplate: function(e) {
                            var value = e.component.option("value"),
                                $treeView = $("<div>").dxTreeView({
                                    dataSource: e.component.option("dataSource"),
                                    keyExpr: "id",
                                    selectionMode: "multiple",
                                    displayExpr: "descrip",
                                    showCheckBoxesMode: "normal",
                                    onItemSelectionChanged: function(args) {
                                        var value = args.component.getSelectedNodesKeys();

                                        $("#idSucursales").val(value);
                                        e.component.option("value", value);
                                    }
                                });

                            treeView = $treeView.dxTreeView("instance");

                            return $treeView;
                        }
                    }
                }, {
                    location: 'before',
                    locateInMenu: 'auto',
                    template: function() {
                        return $('<h4 class="txtEstado"style="margin-top:15px;color:#999999; font-weight:400;">Desde: </h4>');
                    }
                }, {
                    location: 'before',
                    locateInMenu: 'auto',
                    widget: 'dxDateBox',
                    options: {
                        name: "fechaini",
                        value: primerDia,
                        displayFormat: 'dd/MM/yyyy'
                    }
                }, {
                    location: 'before',
                    locateInMenu: 'auto',
                    template: function() {
                        return $('<h4 class="txtEstado"style="margin-top:15px;color:#999999; font-weight:400;">Hasta: </h4>');
                    }
                }, {
                    location: 'before',
                    locateInMenu: 'auto',
                    widget: 'dxDateBox',
                    options: {
                        name: "fechafin",
                        value: ultimoDia,
                        displayFormat: 'dd/MM/yyyy'
                    }
                }, {
                    location: 'before',
                    widget: 'dxButton',
                    locateInMenu: 'auto',
                    options: {
                        icon: "check",
                        type: "success",
                        text: '',
                        elementAttr: {
                            "id": "btnRun"
                        },
                        onClick: function(e) {
                            if ($("#idSucursales").val() == "") {
                                DevExpress.ui.notify("¡Error! Se debe seleccionar al menos una sucursal para generar el analisis.", "error", 2500);
                                $("#inputSucursal").dxDropDownBox("instance").open();
                            } else {
                                loadPanel.show();
                                var fechaini = $("input[name=fechaini]").val();
                                var fechafin = $("input[name=fechafin]").val();
                                var sucursal = $("#idSucursales").val();
                                
                                // var date1 = moment(fechaini);
                                // var date2 = moment(fechafin);
                                // var diasInventario = date2.diff(date1, 'days');

                                let date1 = new Date(fechaini);
                                let date2 = new Date(fechafin);

                                date2.setDate(date2.getDate() + 1);

                                let differenceInTime = date2.getTime() - date1.getTime();
                                let diasInventario = Math.round(differenceInTime / (1000 * 3600 * 24));

                                if (diasInventario > 1) {
                                    $("#gridRepedido").dxDataGrid('instance').columnOption('Total', 'caption', 'Unidades Vendidas en ' + diasInventario + ' dias');
                                } else {
                                    $("#gridRepedido").dxDataGrid('instance').columnOption('Total', 'caption', 'Unidades Vendidas en ' + diasInventario + ' dia');
                                }

                                $.ajax({
                                    type: "POST",
                                    url: "<?= base_url() ?>invtran/get_repedido_list", 
                                    dataType: "json",
                                    data: {
                                        "fechaini": fechaini,
                                        "fechafin": fechafin,
                                        "sucursal": sucursal
                                    },
                                    success: function(data) {
                                        loadPanel.hide();
                                        var grid = $("#gridRepedido").dxDataGrid("instance");
                                        grid.option("dataSource", data[0]);
                                        arrayInfo = data[0];
                                        arrayProvee = data[1];
                                    }
                                });
                            }
                        }
                    }
                },
                <? foreach ($formatos as $form) { ?> {
                        location: 'after',
                        widget: 'dxButton',
                        locateInMenu: 'auto',
                        options: {
                            icon: "<? if ($form->imagen == "" || $form->imagen == null) { ?>fa fa-print<? } else { ?><?= $form->imagen ?><? } ?>",
                            text: "",
                            elementAttr: {
                                "id": "inputPrint<?= $form->idform ?>",
                                "askpwd": "<?= $form->askpwd ?>",
                                "gvarpwd": "<?= $form->gvarpwd ?>",
                                "url": "<?= $form->formname ?>",
                                "appoptions": "<?= $form->appoptions ?>",
                                "notas": "<?= $form->notas ?>"

                            },
                            onClick: function() {
                                var askpwd = $("#inputPrint<?= $form->idform ?>").attr('askpwd');
                                var gvarpwd = $("#inputPrint<?= $form->idform ?>").attr('gvarpwd');
                                var url = $("#inputPrint<?= $form->idform ?>").attr('url');
                                var param = $("#inputPrint<?= $form->idform ?>").attr('appoptions');
                                var notas = $("#inputPrint<?= $form->idform ?>").attr('notas');
                                $("#contraReport").val(gvarpwd);
                                $("#reportUrl").val(url);
                                $("#needParam").val(param);
                                $("#paramVal").val(param);

                                if (notas == "ask_proveedor") {
                                    if ($("#idSucursales").val() == "") {
                                        DevExpress.ui.notify("¡Error! Debe seleccionar al menos una sucursal para generar el reporte.", "error", 2500);
                                        $("#inputSucursal").dxDropDownBox("instance").open();
                                        return null;
                                    }

                                    if ($("input[name=fechaini]").val() == "" || $("input[name=fechafin]").val() == "") {
                                        DevExpress.ui.notify("¡Error! Debe seleccionar un rango de fechas para generar el reporte.", "error", 2500);
                                        return null;
                                    }

                                    if (arrayInfo == undefined || arrayInfo == "" || arrayInfo == null) {
                                        DevExpress.ui.notify("¡Error! Datos de la tabla vacíos.", "error", 2500);
                                        return null;
                                    }

                                    if (arrayProvee == undefined || arrayProvee == "" || arrayProvee == null) {
                                        DevExpress.ui.notify("¡Error! No existen emprendedores con ventas registradas.", "error", 2500);
                                        return null;
                                    }

                                    popupReporteComision();
                                } else if(notas == "reporteComprobanteLiquidacion"){
                                    if ($("#idSucursales").val() == "") {
                                        DevExpress.ui.notify("¡Error! Debe seleccionar al menos una sucursal para generar el reporte.", "error", 2500);
                                        $("#inputSucursal").dxDropDownBox("instance").open();
                                        return null;
                                    }

                                    if ($("input[name=fechaini]").val() == "" || $("input[name=fechafin]").val() == "") {
                                        DevExpress.ui.notify("¡Error! Debe seleccionar un rango de fechas para generar el reporte.", "error", 2500);
                                        return null;
                                    }

                                    if (arrayInfo == undefined || arrayInfo == "" || arrayInfo == null) {
                                        DevExpress.ui.notify("¡Error! Datos de la tabla vacíos.", "error", 2500);
                                        return null;
                                    }

                                    if (arrayProvee == undefined || arrayProvee == "" || arrayProvee == null) {
                                        DevExpress.ui.notify("¡Error! No existen emprendedores con ventas registradas.", "error", 2500);
                                        return null;
                                    }

                                    popupComprobanteLiquidacion();

                                }
                                 else {
                                    if (askpwd == 1) {
                                        var popPass = $("#popupPassword").dxPopup("instance");
                                        popPass.show();
                                    } else {
                                        var needParam = $("#needParam").val();
                                        var url = $("#reportUrl").val();
                                        if (needParam != "") {
                                            var param = $("#paramVal").val().split(",");
                                            if (param.length == 1) {
                                                var valor = $("input[name=" + param[0] + "]").val();
                                            } else {
                                                var cadena = "";
                                                for (var i = 0; i < param.length; i++) {
                                                    cadena += $("input[name=" + param[i] + "]").val() + "/";
                                                }
                                                var cant = cadena.length;
                                                cant = cant - 1;
                                                valor = cadena.substring(0, cant);
                                            }
                                            dir = "<?= base_url() ?><?= $this->session->userdata('dirReports') ?>/reports/" + url + "/" + valor;
                                            window.open(dir, '_blank');
                                        } else {
                                            dir = "<?= base_url() ?><?= $this->session->userdata('dirReports') ?>/reports/" + url;
                                            window.open(dir, '_blank');
                                        }
                                    }
                                }

                            }
                        }
                    },
                <? } ?> {
                    location: 'after',
                    widget: 'dxButton',
                    locateInMenu: 'auto',
                    options: {
                        icon: "runner",
                        elementAttr: {
                            "id": "inputSalir"
                        },
                        text: '',
                        onClick: function() {
                            window.location.href = "<?= base_url() ?>login/backMenu";
                        }
                    }
                }
            ]
        }).dxToolbar("instance");

        <? foreach ($formatos as $form) { ?>
            $("#toolTip<?= $form->idform ?>").dxTooltip({
                target: "#inputPrint<?= $form->idform ?>",
                showEvent: "mouseenter",
                hideEvent: "mouseleave",
                position: "top"
            });
        <? } ?>

        $("#toolTipReporteComision").dxTooltip({
            target: "#btnReporteComision",
            showEvent: "mouseenter",
            hideEvent: "mouseleave",
            position: "top"
        });

        $("#gridRepedido").dxDataGrid({
            allowColumnResizing: true,
            allowColumnReordering: true,
            columnAutoWidth: true,
            showColumnLines: true,
            showRowLines: true,
            hoverStateEnabled: true,
            rowAlternationEnabled: true,
            noDataText: "No se han encontrado datos",
            wordWrapEnabled: true,
            showBorders: true,
            selection: {
                mode: "single"
            },
            searchPanel: {
                visible: true,
                width: 240,
                placeholder: "Buscar..."
            },
            columnChooser: {
                enabled: true,
                mode: "select",
                title: "Seleccionar Columnas",
                height: 400,
            },
            width: "100%",
            loadPanel: {
                enabled: true,
                text: "Procesando"
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                apllyFilterText: "Aplicar Filtro",
                showAllText: "(TODOS)",
                betweenEndText: "Hasta",
                betweenStartText: "Desde",
                operationDescriptions: {
                    between: "Entre",
                    contains: "Contiene",
                    endsWith: "Termina con",
                    equal: "Igual a",
                    greaterThan: "Mayor que",
                    greaterThanOrEqual: "Mayor o Igual que",
                    lessThan: "Menor que",
                    lessThanOrEqual: "Menor o Igual que",
                    notContains: "No contiene",
                    notEqual: "No es igual que",
                    startsWith: "Comienza con"
                },
                resetOperationText: "Reiniciar",
                showOperationChooser: true
            },
            headerFilter: {
                visible: true
            },
            pager: {
                allowedPageSizes: [10, 15, 20, 30],
                infoText: "Pagina {0} de {1} | {2} Registros",
                showInfo: true,
                showNavigationButtons: true,
                showPageSizeSelector: true,
                visible: true
            },
            paging: {
                pageSize: 15
            },
            groupPanel: {
                visible: true,
                emptyPanelText: "",
            },
            grouping: {
                contextMenuEnabled: true,
                expandMode: "rowClick",
            },
            export: {
                enabled: true,
                fileName: "Repedidos",
                texts: {
                    exportAll: "Exportar Datos"
                }
            },
            columns: [
                {
                    //1
                    caption: "Código",
                    dataField: "idproducto",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    width: 100
                }, {
                    //2
                    caption: "Modelo",
                    dataField: "modelo",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    visible: true,
                    width: 100

                }, {
                    //2
                    caption: "Codigo de Barra",
                    dataField: "barcode",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    visible: true,
                    width: 100

                }, {
                    //3
                    caption: "Xpos",
                    dataField: "xpos",
                    alignment: "center",
                    visible: false,
                    allowHeaderFiltering: true,
                    width: 100
                }, {
                    //4
                    caption: "Marca",
                    dataField: "marca",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    width: 100
                }, {
                    //5
                    caption: "Departamento",
                    dataField: "departamento",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    visible: false,
                    width: 200
                }, {
                    //5
                    caption: "Línea",
                    dataField: "linea",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    width: 200
                }, {
                    //6
                    caption: "Proveedor",
                    dataField: "nameproveedor",
                    visible: false,
                    allowHeaderFiltering: true,
                    width: 200
                }, {
                    //7
                    caption: "Descripción",
                    dataField: "descrip",
                    alignment: "left",
                    allowHeaderFiltering: true,
                    width: 300
                }, {
                    //8
                    caption: "Unidades Vendidas",
                    dataField: "Total",
                    alignment: "center",
                    dataType: "number",
                    allowHeaderFiltering: true,
                    width: 140
                }, {
                    //9
                    caption: "Precio Regular",
                    dataField: "precioreg",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    width: 100
                }, {
                    //10
                    caption: "Subtotal Venta sin IVA",
                    dataField: "ventatotal",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    width: 100
                },  {
                    //11
                    caption: "IVA",
                    dataField: "totaliva",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    width: 100
                }, 
                <? if ($this->session->userdata('idaccount') == 2902805) { ?>
                {
                    //12
                    caption: "% Descuento",
                    dataField: "descuento",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: " #,##0.00",
                        precision: 2
                    },
                    width: 100
                }, 
                <? } ?>
                {
                    //13
                    caption: "Total Venta",
                    dataField: "totalvn",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    width: 100
                }, {
                    //14
                    caption: "% Comisión Proveedor",
                    dataField: "comisionproveedor",
                    alignment: "center",
                    visible: false,
                    allowHeaderFiltering: true
                }, {
                    //15
                    caption: "Clasificación",
                    dataField: "categoria",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    visible: false
                }, {
                    //16
                    caption: "Inventario Actual",
                    dataField: "inv_actual",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    visible: false
                }, {
                    //17
                    caption: "Clientes",
                    dataField: "hits",
                    alignment: "center",
                    dataType: "number",
                    allowHeaderFiltering: true,
                    visible: false
                },  {
                    //18
                    caption: "Días de Inventario",
                    dataField: "stock",
                    alignment: "center",
                    visible: false,
                    allowHeaderFiltering: true
                }, {
                    //19
                    caption: "Promedio Diario",
                    dataField: "avg",
                    alignment: "center",
                    allowHeaderFiltering: true,
                    visible: false
                }, {
                    //20
                    caption: "Sucursal",
                    dataField: "nameSucursal",
                    allowHeaderFiltering: true,
                    visible: false,
                    width: 200
                }, {
                    caption: "Precio Promedio",
                    dataField: "precioprom",
                    alignment: "right",
                    allowHeaderFiltering: true,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    visible: false,
                    width: 100
                }, {
                    caption: "Costo Unitario",
                    dataField: "costo_unitario",
                    alignment: "right",
                    allowHeaderFiltering: false,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.0000",
                        precision: 4
                    },
                    visible: false,
                    width: 90
                }, {
                    caption: "Costo Total",
                    dataField: "costo_total",
                    alignment: "right",
                    allowHeaderFiltering: false,
                    dataType: "number",
                    format: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    },
                    visible: false,
                    width: 100
                },
                <? if ($this->session->userdata('idaccount') == 256264) { ?> {
                        caption: "Proyección",
                        dataField: "proyeccion",
                        alignment: "center",
                        allowHeaderFiltering: true,
                        visible: false
                    }, {
                        caption: "Ingresos Periodo",
                        dataField: "ingresosPeriodo",
                        alignment: "center",
                        allowHeaderFiltering: true,
                        visible: false,
                        dataType: "number",
                        format: {
                            type: "#,##0.00",
                            precision: 2
                        },
                    },
                <? } ?> 
            ],
            summary: {
                texts: {
                    sum: "{0}"
                },
                totalItems: [{
                    column: 'precioprom',
                    summaryType: 'sum',
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'ventatotal',
                    summaryType: 'sum',
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'totaliva',
                    summaryType: 'sum',
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'totalvn',
                    summaryType: 'sum',
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'hits',
                    summaryType: 'sum',
                }, {
                    column: 'Total',
                    summaryType: 'sum',
                }, {
                    column: 'Costo Total',
                    summaryType: 'sum',
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }],
                groupItems: [{
                    column: 'precioprom',
                    summaryType: 'sum',
                    showInGroupFooter: true,
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'ventatotal',
                    summaryType: 'sum',
                    showInGroupFooter: true,
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'totaliva',
                    summaryType: 'sum',
                    showInGroupFooter: true,
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'totalvn',
                    summaryType: 'sum',
                    showInGroupFooter: true,
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }, {
                    column: 'hits',
                    summaryType: 'sum',
                    showInGroupFooter: true
                }, {
                    column: 'Total',
                    summaryType: 'sum',
                    showInGroupFooter: true
                }, {
                    column: 'Costo Total',
                    summaryType: 'sum',
                    showInGroupFooter: true,
                    valueFormat: {
                        type: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
                        precision: 2
                    }
                }]
            },
            onRowClick: function(e) {
                $("#popDetalle").remove();
                var datos = e.data;
                $("#caja_pop").append("<div id='popDetalle'></div>");
                $("#popDetalle").dxPopup({
                    fullScreen: false,
                    title: datos.descrip,
                    width: "80%",
                    height: "80%",
                    contentTemplate: function(contentElement) {
                        var caja = $('<div class="col-xs-12 col-sm-12 col-md-12"></div>');
                        var info_pro = $('<div class="col-xs-12 col-sm-12 col-md-4" style="float:left;"></div>');
                        var sucursales = $('<div class="col-xs-12 col-sm-12 col-md-8" style="float:right;"></div>');

                        $('<div class="col-xs-12 col-sm-12 col-md-12"><div class="col-xs-12 col-sm-12 col-md-12"><center><img id="imgDetalle" src="" style="width:180px; height:180px; border:none;"></center></div><div class="col-xs-12 col-sm-12 col-md-12" style="padding:5px;"><h5 style="font-size:18px; margin-top:-5px;">Posición:<strong id="pos_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Código: <strong id="cod_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Precio Promedio: <strong id="precio_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Clientes: <strong id="clientes_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Unidades Vendidas: <strong id="uv_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Unidades promedio por Cliente <strong id="uppc"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Días de Inventario: <strong id="dias_pro"></strong></h5><h5 style="font-size:18px; margin-top:-5px;">Promedio Diario: <strong id="pro_pro"></strong></h5></div></div>').appendTo(info_pro);
                        $('<div id="inv_sucusales"></div>').appendTo(sucursales);

                        info_pro.appendTo(caja);
                        sucursales.appendTo(caja);
                        contentElement.append(caja);

                        $("#pos_pro").text(datos.position);
                        $("#cod_pro").text(datos.idproducto);
                        $("#precio_pro").text("<?= $this->session->userdata('simboloMoneda') ?>" + parseFloat(datos.precioprom).toFixed(2));
                        $("#clientes_pro").text(datos.hits);
                        $("#uv_pro").text(datos.Total);
                        $("#uppc").text(parseFloat(datos.Total / datos.hits).toFixed(2));
                        $("#dias_pro").text(datos.stock);
                        $("#pro_pro").text(datos.avg);
                        var img = "";
                        if (datos.imagen == "" || datos.imagen == null) {
                            img = "sinImagen.png";
                            $("#imgDetalle").attr("src", "<?= base_url() ?>assets/img/" + img);
                        } else {
                            img = datos.imagen;
                            $("#imgDetalle").attr("src", "<?= base_url() ?>img_cuentas/<?= $this->session->userdata('diraccount') ?>/" + img);
                        }

                        $("#inv_sucusales").dxDataGrid({
                            allowColumnResizing: true,
                            allowColumnReordering: true,
                            columnResizingMode: "nextColumn",
                            columnAutoWidth: true,
                            rowAlternationEnabled: false,
                            wordWrapEnabled: true,
                            showColumnLines: false,
                            showRowLines: false,
                            hoverStateEnabled: true,
                            width: "100%",
                            height: "400px",
                            loadPanel: {
                                enabled: false,
                            },
                            sorting: {
                                ascendingText: "Ascendente",
                                clearText: "Reiniciar",
                                descendingText: "Descendente"
                            },
                            searchPanel: {
                                visible: false,
                            },
                            filterRow: false,
                            scrolling: {
                                mode: 'virtual'
                            },
                            paging: {
                                enabled: false,
                            },
                            noDataText: "No se han encontrado datos",
                            elementAttr: {
                                "class": "tabla_suc"
                            },
                            columns: [{
                                    dataField: "idcentro",
                                    visible: false,
                                },
                                {
                                    caption: "Sucursal",
                                    dataField: "centerName",
                                    alignment: "left",
                                    allowHeaderFiltering: false,
                                }, {
                                    caption: "Inventario Actual",
                                    dataField: "inventario",
                                    alignment: "center",
                                    allowHeaderFiltering: false,
                                    dataType: "number",
                                    sortOrder: "desc"
                                },
                                {
                                    caption: "Unidades Vendidas",
                                    dataField: "ventas",
                                    alignment: "center",
                                    dataType: "number",
                                    allowHeaderFiltering: false
                                }
                            ],
                            summary: {
                                texts: {
                                    sum: "{0}"
                                },
                                totalItems: [{
                                    column: 'inventario',
                                    summaryType: 'sum',
                                }, {
                                    column: 'ventas',
                                    summaryType: 'sum',
                                }]
                            },

                        });

                        var fechaini = $("input[name=fechaini]").val();
                        var fechafin = $("input[name=fechafin]").val();
                        var sucursal = $("input[name=sucursal]").val();
                        var idproducto = datos.idproducto;
                        var postData = {
                            "fechaini": fechaini,
                            "fechafin": fechafin,
                            "sucursal": sucursal,
                            "idproducto": idproducto
                        };
                        $.ajax({
                            type: "POST",
                            url: "<?= base_url() ?>invtran/get_repedido_sucursales",
                            dataType: "json",
                            data: postData,
                            success: function(data) {
                                var grid = $("#inv_sucusales").dxDataGrid("instance");
                                grid.option("dataSource", data);
                            }
                        });
                    }
                });

                $("#popDetalle").dxPopup("instance").show();
            }
        });

        function popupReporteComision() {
            const entries = Object.values(arrayProvee);
            $("#popupReporteComision").remove();
            $("#popupContainer").append('<div id="popupReporteComision"></div>');
            $("#popupReporteComision").dxPopup({
                contentTemplate: function(contentElement) {
                    contentElement.addClass("p-0 p-5");
                    contentElement.append('<div id="datos"></div>');
                    $("#datos").append('<div id="inputEmprendedor" />');

                    texto = '<div style="float: right; margin: 5px 0px 0px 0px;" id="BtnNel"></div>';
                    texto += '<div style="float: right; margin: 5px 5px 0px 0px;" id="BtnAdd"></div>';
                    $("#datos").append(texto);


                    $("#inputEmprendedor").dxTagBox({
                        dataSource: entries,
                        height: 90,
                        valueExpr: "idproveedor",
                        placeholder: "Seleccionar...",
                        searchEnabled: true,
                        showClearButton: true,
                        stylingMode: "filled",
                        label: "Emprendedores",
                        labelMode: "floating",
                        displayExpr: "nameproveedor",
                        noDataText: "No se han encontrado emprendedores.",
                        showSelectionControls: true,
                        //applyValueMode: 'useButtons',
                        selectAllText:'Seleccionar Todos',
                        applyButtonText: 'Aceptar',
                        cancelButtonText: 'Cancelar',
                        dropDownOptions: {      
                            height: 180,
                            //maxHeight: 300, // specify this to override the fit-content behavior 
                        },
                        fieldTemplate: function(data, $container) {
                            $("<div>")
                                .append($('<div>').dxTextBox())
                                .dxScrollView({
                                width: '100%',
                                height: '100%'
                                })
                                .appendTo($container);
                        },
                        onSelectionChanged: function(e) {
                            if (e.addedItems.length > 0) {
                                if (e.addedItems[0].comisionproveedor == 0) {
                                    DevExpress.ui.notify("¡Alerta! El emprendedor seleccionado no posee un porcentaje de comisión definido.", "warning", 2500);
                                }
                            }
                            /*
                            
                            */
                            //perfil = (e.selectedItem != null) ? parseInt(e.selectedItem.ID) : 0;
                        }
                    }).dxValidator({
                        validationRules: [{
                            type: "required",
                            message: "Seleccione al menos un emprendedor."
                        }],
                    });

                    $("#BtnAdd").dxButton({
                        disabled: false,
                        icon: "check",
                        type: "success",
                        onClick: function(e) {
                            var resultado = e.validationGroup.validate();
                            if (resultado.isValid) {
                                const sucursal = $("#idSucursales").val();
                                let sucursalstr = sucursal.split(',');
                                sucursalstr = sucursalstr.join('-');
                                const fechaini = $("input[name=fechaini]").val();
                                const fechafin = $("input[name=fechafin]").val();

                                let emprendedores = $("#inputEmprendedor").dxTagBox('instance').option("value");
                                emprendedoresstr = emprendedores.join("-");

                                window.open("<?= base_url() ?><?= $this->session->userdata('dirReports') ?>/reports/reporteLiquidacionComision/" + fechaini + "/" + fechafin + "/" + sucursalstr + "/" + emprendedoresstr, '_blank');


                            } //else console.log(result);
                        },
                    });
                    $("#BtnNel").dxButton({
                        icon: "close",
                        type: "danger",
                        onClick: function(e) {
                            $("#popupReporteComision").dxPopup("instance").hide();
                        }
                    });
                },

                height: 'auto',
                width: 700,
                title: "Liquidación por Emprendedor",
                visible: false,
            });
            $("#popupReporteComision").dxPopup("instance").show();
        }

        function popupComprobanteLiquidacion() {
            const entries = Object.values(arrayProvee);
            $("#popupReporteComision").remove();
            $("#popupContainer").append('<div id="popupReporteComision"></div>');
            $("#popupReporteComision").dxPopup({
                contentTemplate: function(contentElement) {
                    contentElement.addClass("p-0 p-5");
                    contentElement.append('<div id="datos"></div>');
                    $("#datos").append('<div id="inputEmprendedor" />');

                    texto = '<div style="float: right; margin: 5px 0px 0px 0px;" id="BtnNel"></div>';
                    texto += '<div style="float: right; margin: 5px 5px 0px 0px;" id="BtnAdd"></div>';
                    $("#datos").append(texto);


                    $("#inputEmprendedor").dxSelectBox({
                        dataSource: entries,
                        valueExpr: "idproveedor",
                        placeholder: "Seleccionar...",
                        searchEnabled: true,
                        showClearButton: true,
                        stylingMode: "filled",
                        label: "Emprendedores",
                        labelMode: "floating",
                        displayExpr: "nameproveedor",
                        noDataText: "No se han encontrado emprendedores.",
                        
                        onSelectionChanged: function(e) {
                            if (e.selectedItem.length > 0) {
                                if (e.selectedItem.comisionproveedor*1 == 0) {
                                    DevExpress.ui.notify("¡Alerta! El emprendedor seleccionado no posee un porcentaje de comisión definido.", "warning", 2500);
                                }
                            }
                        }
                    }).dxValidator({
                        validationRules: [{
                            type: "required",
                            message: "Seleccione al menos un emprendedor."
                        }],
                    });

                    $("#BtnAdd").dxButton({
                        disabled: false,
                        icon: "check",
                        type: "success",
                        onClick: function(e) {
                            var resultado = e.validationGroup.validate();
                            if (resultado.isValid) {
                                const sucursal = $("#idSucursales").val();
                                let sucursalstr = sucursal.split(',');
                                sucursalstr = sucursalstr.join('-');
                                const fechaini = $("input[name=fechaini]").val();
                                const fechafin = $("input[name=fechafin]").val();

                                let emprendedor = $("#inputEmprendedor").dxSelectBox('instance').option("value");

                                window.open("<?= base_url() ?><?= $this->session->userdata('dirReports') ?>/reports/reporteComprobanteLiquidacion/" + fechaini + "/" + fechafin + "/" + sucursalstr + "/" + emprendedor, '_blank');


                            } //else console.log(result);
                        },
                    });
                    $("#BtnNel").dxButton({
                        icon: "close",
                        type: "danger",
                        onClick: function(e) {
                            $("#popupReporteComision").dxPopup("instance").hide();
                        }
                    });
                },

                height: 'auto',
                width: 400,
                title: "Comprobante de Liquidación",
                visible: false,
            });
            $("#popupReporteComision").dxPopup("instance").show();
        }

    });
</script>