<!DOCTYPE html>
<?php $this->load->helper('url');
setlocale(LC_TIME, 'es_SV');
if (session_status() == PHP_SESSION_NONE) {
	session_start();
}
if ($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado') || !isset($_SESSION['menuSite']) || !isset($_SESSION['appsSite']) || !isset($_SESSION['userPerm']) || $this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
	redirect('login/cerrar_sesion');
}
?>
<html>
<? $this->load->view('headerFilesQuill_U'); ?>
<style>
	.p-0 {
		padding: 0px;
	}

	.p-10 {
		padding: 10px;
	}

	.p-t-15 {
		padding-top: 15px;
	}

	/* M */
	.m-t-6 {
		margin-top: 6px;
	}

	.m-t-2 {
		margin-top: 2px;
	}

	.m-b-2 {
		margin-bottom: 2px;
	}

	.m-b-10 {
		margin-bottom: 10px;
	}

	.ml-95-8p {
		margin-left: 95.8%;
	}

	.m-l-4 {
		margin-left: 4px;
	}

	.m-l-5 {
		margin-left: 5px;
	}

	/* W */
	.w-90p {
		width: 90%;
	}

	.w-98p {
		width: 98%;
	}

	.w-28p {
		width: 28%;
	}

	.w-33p {
		width: 33%;
	}

	.w-58p {
		width: 58%;
	}

	/* TEXT */
	.fw-600 {
		font-weight: 600;
	}
</style>

<body>
	<div id="wrapper">
		<div id="main">
			<div class="inner">
				<? $this->load->view('tituloPaginas'); ?>
				<!-- Dentro de este section, van los formularios ya creados anteriormente -->
				<section style="padding-top:10px;">
					<div class="row">
						<div class="col-xs-12 col-sm-12 col-md-12" style="padding-left:0px; padding-right:0px;">
							<div class="panel panel-primary" style="border-color:#FFF;">
								<div class="panel-body" style="padding:0px; background-color:<?= $this->session->userdata('FrBackground') ?>;">
									<div class="col-xs-12 col-sm-12 col-md-12" style="padding-top:0px; padding-bottom:10px;">
										<input type="hidden" id="contraReport" readonly><input type="hidden" id="reportUrl"><input type="hidden" id="needParam" readonly><input type="hidden" id="paramVal">
										<div id="menuOpciones"></div>
										<div id="tabs" class="m-t-10"></div>
									</div>
									<div class="col-xs-12 col-sm-12 col-md-12 p-t-0 p-b-10" id="container">
										<div id="dataGridMovs"></div>
										<div id="popupPassword"></div>
										<div id="subirX"></div>
										<div id="Vmayoriza"></div>
										<div id="Reporte"></div>
										<div id="btnAdicionarCuenta"></div>
										<div class="toolHidden" hidden="hidden" id="toolTipSalir">Salir</div>
										<div class="toolHidden" hidden="hidden" id="toolTipAdicionar">Adicionar</div>
										<div class="toolHidden" hidden="hidden" id="toolTipAdicionarSub">Adicionar subcuenta</div>

									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
			</div>
		</div>
		<? $this->load->view('menu_navside'); ?>
	</div>
</body>
<div id="popupContainer"></div>

</html>
<script type="text/javascript">
	$(document).ready(function() {
		const ctcuentas = <?= json_encode(($ctcuentas)) ?>;
		const now = new Date();
		let cuentaActual = null;
		let filasSeleccionadas = null;

		let loadPanel = $("#loadPanel").dxLoadPanel({
			shadingColor: "rgba(255,255,255,0.2)",
			visible: false,
			showIndicator: true,
			message: "Cargando...",
			showPane: true,
			shading: false,
			closeOnOutsideClick: false
		}).dxLoadPanel("instance");

		$("#menuOpciones").dxToolbar({
			width: "100%",

			items: [{
				location: 'before',
				locateInMenu: 'auto',
				template: function() {
					return $('<h4 class="txtEstado" style="margin-top:2px; margin-bottom:0px;  color:#999999; font-weight:400;">Cuenta: </h4>');
				}
			}, {
				location: 'before',
				widget: 'dxSelectBox',
				locateInMenu: 'auto',
				options: {
					elementAttr: {
						id: "inputCuenta"
					},
					dataSource: ctcuentas,
					noDataText: "Sin Cuentas",
					displayExpr: function(item) {
						return item && item.idctcuenta + ' - ' + item.descrip;
					},
					valueExpr: "idctcuenta",
					searchEnabled: true,
					searchMode: "startswith",
					searchExpr: ["idctcuenta", "descrip"],
					stylingMode: "filled",
					placeholder: "Seleccionar...",
					width: 300,
					itemTemplate: function(data) {
						return '<div class="b-b-gris"><div>' + data.idctcuenta + '</div><div>' + data.descrip + '</div></div>';
					},
				}
			}, {
				location: 'before',
				locateInMenu: 'auto',
				template: function() {
					return $('<h4 class="txtEstado"  style="margin-left: 5px;margin-top:2px; margin-bottom:0px; color:#999999; font-weight:400;">Desde: </h4>');
				}
			}, {
				location: 'before',
				widget: 'dxDateBox',
				locateInMenu: 'auto',
				options: {
					elementAttr: {
						"id": "desde"
					},
					name: "desde",
					displayFormat: "dd/MM/yyyy",
					value: now,
					stylingMode: "filled",
					width: 120
				}
			}, {
				location: 'before',
				locateInMenu: 'auto',
				template: function() {
					return $('<h4 class="txtEstado"  style="margin-left: 5px;margin-top:2px; margin-bottom:0px; color:#999999; font-weight:400;">Hasta: </h4>');
				}
			}, {
				location: 'before',
				widget: 'dxDateBox',
				locateInMenu: 'auto',
				options: {
					elementAttr: {
						"id": "hasta"
					},
					name: "hasta",
					displayFormat: "dd/MM/yyyy",
					value: now,
					stylingMode: "filled",
					width: 120
				}
			}, {
				location: 'before',
				widget: 'dxButton',
				locateInMenu: 'auto',
				options: {
					icon: 'check',
					type: 'success',
					onClick: function(e) {
						getMovimientosCuenta();
					}
				}
			}, {
				location: 'after',
				widget: 'dxDropDownButton',
				locateInMenu: 'auto',
				options: {
					items: <?= json_encode(($AModulos)) ?>,
					elementAttr: {
						"id": "inputSalir"
					},
					displayExpr: "Name",
					keyExpr: "ID",
					icon: 'runner',
					dropDownOptions: {
						width: 200
					},

					itemTemplate: function(data, index, element) {
						textotemplate = '<div class="points3-special" title="' + data.Name + '">' + data.Name + '</div>';
						element.addClass('p-y-5i');
						element.append(textotemplate);
					},
					onItemClick: function(e) {
						dir = "<?= base_url() ?>" + e.itemData.appname + ((!e.itemData.fin) ? ("/" + e.itemData.ID) : '');
						window.open(dir, '_self'); //*/
					}
				}
			}]
		}).dxToolbar("instance");

		$("#dataGridMovs").dxDataGrid({
			noDataText: "Sin Datos",
			keyExpr: "idrec",
			loadPanel: {
				shadingColor: "rgba(255,255,255,0.2)",
				visible: false,
				showIndicator: true,
				text: "Cargando...",
				showPane: true,
				shading: false,
				closeOnOutsideClick: false
			},
			paging: {
				pageSize: 100
			},
			pager: {
				allowedPageSizes: [10, 25, 50, 100],
				infoText: "Pagina {0} de {1} | {2} Registros",
				showInfo: true,
				showNavigationButtons: true,
				showPageSizeSelector: true,
				visible: true
			},
			searchPanel: {
				visible: true,
				highlightCaseSensitive: true,
				placeholder: "Buscar..."
			},
			headerFilter: {
				visible: true
			},
			filterRow: {
				visible: true,
				applyFilter: "auto",
				apllyFilterText: "Aplicar Filtro",
				showAllText: "(TODOS)",
				betweenEndText: "Hasta",
				betweenStartText: "Desde",
				operationDescriptions: {
					between: "Entre",
					contains: "Contiene",
					endsWith: "Termina con",
					equal: "Igual a",
					greaterThan: "Mayor que",
					greaterThanOrEqual: "Mayor o Igual que",
					lessThan: "Menor que",
					lessThanOrEqual: "Menor o Igual que",
					notContains: "No contiene",
					notEqual: "No es igual que",
					startsWith: "Comienza con"
				},
				resetOperationText: "Reiniciar",
				showOperationChooser: true
			},
			columnChooser: {
				enabled: true,
				mode: "select",
				title: "Seleccionar Columna",
				height: 400
			},
			export: {
				enabled: true,
				fileName: "Registro",
			},
			remoteOperations: false,
			allowColumnReordering: true,
			allowColumnResizing: true,
			rowAlternationEnabled: true,
			showBorders: true,
			groupPanel: {
				visible: true,
				emptyPanelText: "",
				//allowColumnDragging: false
			},
			columns: [
				//idrec
				{
					visible: false,
					dataField: "idrec",
					caption: "Id",
					dataType: "numeric",
					alignment: "center",
					width: 100,
				},
				//fecha
				{
					dataField: "fecha",
					caption: "Fecha",
					dataType: "date",
					format: 'dd/MM/yyyy',
					alignment: "center",
					width: 100,
				},
				//tipo de partida
				{
					visible: false,
					dataField: "TPartida",
					caption: "Tipo de Partida",
					alignment: "left",
				},
				//numero
				{
					visible: false,
					dataField: "numero",
					caption: "Número",
					dataType: "number",
					alignment: "center",
					width: '10%'
				},
				// cuenta
				{
					dataField: "idctcuenta",
					caption: "Cuenta",
					alignment: "left",
					width: '10%',
					filterOperations: ["startswith", "contains", "notcontains", "endswith", "=", "<>"],
				},
				//titulo cuenta
				{
					dataField: "cuentaD",
					caption: "Titulo de la cuenta",
					dataType: "string",
					alignment: "left",
				},
				//id auxi
				{
					dataField: "idauxi",
					caption: "Auxiliar",
					dataType: "number",
					alignment: "center",
					width: '10%',
				},
				//auxiliar
				{
					dataField: "auxiliar",
					caption: "Titulo del Auxiliar",
					alignment: "left",
				},
				//descripcion
				{
					dataField: "titulo",
					caption: "Descripción del movimiento",
					dataType: "string",
				},
				//id centro
				{
					visible: false,
					dataField: "idcentro",
					caption: "Código Centro",
					dataType: "number",
					alignment: "center",
					width: '10%',
				},
				//centro
				{
					visible: false,
					dataField: "centro",
					caption: "Centro de costos",
					alignment: "left",
				},
				//proyecto
				{
					visible: false,
					dataField: "proyecto",
					caption: "Proyecto",
					alignment: "left",
				},
				{
					visible: false,
					dataField: "doc_type",
					caption: "Tipo de Documento",
					alignment: "left",
				},
				// serie numero
				{
					visible: false,
					dataField: "serien",
					caption: "Número de Documento",
					alignment: "left",
					width: 130,
				},
				//debe
				{
					dataField: "debe",
					caption: "Debe",
					dataType: "number",
					alignment: "right",
					format: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
					width: 120,
				},
				//haber
				{
					dataField: "haber",
					caption: "Haber",
					dataType: "number",
					alignment: "right",
					format: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
					width: 120,
				},
			],
			summary: {
				groupItems: [{
						column: "debe",
						summaryType: "sum",
						displayFormat: "{0}",
						valueFormat: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
						alignByColumn: true
					},
					{
						column: "haber",
						summaryType: "sum",
						displayFormat: "{0}",
						valueFormat: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
						alignByColumn: true
					},
				],
				totalItems: [{
						showInColumn: "titulo",
						displayFormat: "Totales",
						alignment: "right",
					},
					{
						column: "debe",
						showInColumn: "debe",
						displayFormat: "{0}",
						//valueFormat: "currency",
						valueFormat: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
						summaryType: "sum",
					},
					{
						column: "haber",
						showInColumn: "haber",
						displayFormat: "{0}",
						//valueFormat: "currency",
						valueFormat: "<?= $this->session->userdata('simboloMoneda') ?> #,##0.00",
						summaryType: "sum",
					}
				]
			},
			selection: {
				allowSelectAll: false,
				mode: 'multiple',
				showCheckBoxesMode: "always"
			},
			loadPanel: {
				shadingColor: "rgba(255,255,255,0.2)",
				visible: false,
				showIndicator: true,
				message: "Cargando...",
				showPane: true,
				shading: false,
				closeOnOutsideClick: false
			},
			onRowClick: function(e) {
				if (e.rowType === "data") {
					var select = !$("#dataGridMovs").dxDataGrid('instance').isRowSelected(e.key);
					if (select)
						$("#dataGridMovs").dxDataGrid('instance').selectRows([e.key], true)
					else
						$("#dataGridMovs").dxDataGrid('instance').deselectRows([e.key]);
				}
			},
			onContextMenuPreparing: function(e) {
				if (e.row.rowType === "data") {
					e.items = [{
						visible: false,
						onItemClick: function() {

						}
					}, ];

					filasSeleccionadas = $("#dataGridMovs").dxDataGrid('instance').getSelectedRowsData();
					if (filasSeleccionadas.length == 0) {
						DevExpress.ui.notify("¡Error! No ha seleccionado ningún movimiento.", "error", 2000);
					} else {
						popupReclasificar();
					}
				}
			},
		});

		function getMovimientosCuenta() {
			const idctcuenta = $("#inputCuenta").dxSelectBox("instance").option('value');
			const desde = $("input[name=desde]").val();
			const hasta = $("input[name=hasta]").val();
			if (idctcuenta == null || idctcuenta == "") {
				DevExpress.ui.notify("¡Error! Seleccione una cuenta primero.", "error", 2000);
				return false;
			}

			if (Date.parse(desde) > Date.parse(hasta)) {
				DevExpress.ui.notify("¡Error! Seleccione un rango de fechas válido.", "error", 2000);
				return false;
			}

			$.ajax({
				type: "POST",
				url: "<?= base_url() ?>contabilidad/getMovimientosCuenta",
				data: {
					idctcuenta: idctcuenta,
					fechaini: desde,
					fechafin: hasta
				},
				dataType: "json",
				success: function(respuesta) {
					$("#dataGridMovs").dxDataGrid('instance').option('dataSource', respuesta);
					cuentaActual = $("#inputCuenta").dxSelectBox("instance").option('selectedItem');
				},
				error: function(params) {
					console.log(params);
					loadPanel.hide();
					switch (params.status) {
						case 0:
							DevExpress.ui.notify("Error, fallo la conexión a Internet", "error", 4000);
							break;
						case 500:
							DevExpress.ui.notify("Error, Contactar Soporte Técnico", "error", 4000);
							break;
						default:
							DevExpress.ui.notify("Error, vuelva a intentar, si el incidente persiste contacte a Soporte Técnico", "error", 4000);
							break;
					}
				}
			});
		}

		function getDatosCuenta(cuenta) {
			loadPanel.show();
			$("#btnAceptar").dxButton('instance').option('disabled', true);
			$("#btnCancelar").dxButton('instance').option('disabled', true);

			$.ajax({
				type: "POST",
				url: "<?= base_url() ?>contabilidad/getDatosReclasificacionCuenta",
				data: {
					askidcentro: cuenta.askidcentro,
					askidproyecto: cuenta.askidproyecto,
					useauxi: cuenta.useauxi
				},
				dataType: "json",
				success: function(respuesta) {
					$("#btnAceptar").dxButton('instance').option('disabled', false);
					$("#btnCancelar").dxButton('instance').option('disabled', false);

					$("#inputauxi").dxSelectBox('instance').reset();
					$("#inputcentrocosto").dxSelectBox('instance').reset();
					$("#inputproyecto").dxSelectBox('instance').reset();

					$("#inputauxi").dxSelectBox('instance').option('dataSource', respuesta.auxis);
					$("#inputcentrocosto").dxSelectBox('instance').option('dataSource', respuesta.centros);
					$("#inputproyecto").dxSelectBox('instance').option('dataSource', respuesta.proyectos);
				},
				error: function(params) {
					console.log(params);
					loadPanel.hide();
					switch (params.status) {
						case 0:
							DevExpress.ui.notify("Error, fallo la conexión a Internet", "error", 4000);
							break;
						case 500:
							DevExpress.ui.notify("Error, Contactar Soporte Técnico", "error", 4000);
							break;
						default:
							DevExpress.ui.notify("Error, vuelva a intentar, si el incidente persiste contacte a Soporte Técnico", "error", 4000);
							break;
					}
				}
			}).then(function() {
				loadPanel.hide();
			});
		}

		function reclasificarMovimientos() {
			loadPanel.show();
			$("#btnAceptar").dxButton('instance').option('disabled', true);
			$("#btnCancelar").dxButton('instance').option('disabled', true);
			$.ajax({
				type: "POST",
				url: "<?= base_url() ?>contabilidad/reclasificarMovimientos",
				data: {
					ctcuenta: $("#inputctcuenta").dxSelectBox('instance').option('value'),
					idauxi: $("#inputauxi").dxSelectBox('instance').option('value'),
					centrocosto: $("#inputcentrocosto").dxSelectBox('instance').option('value'),
					proyecto: $("#inputproyecto").dxSelectBox('instance').option('value'),
					filasSeleccionadas: filasSeleccionadas,
				},
				dataType: "json",
				success: function(respuesta) {
					if (respuesta) {
						DevExpress.ui.notify("Se han reclasificado los movimientos", "success", 2000);
						$("#inputauxi").dxValidator("instance").reset();
						$("#inputcentrocosto").dxValidator("instance").reset();
						$("#inputproyecto").dxValidator("instance").reset();

						$("#inputauxi").dxSelectBox('instance').option('disabled', false);
						$("#inputcentrocosto").dxSelectBox('instance').option('disabled', false);
						$("#inputproyecto").dxSelectBox('instance').option('disabled', false);
						getMovimientosCuenta();
					}
					$("#popupReclasificar").dxPopup("instance").hide();

				},
				error: function(params) {
					console.log(params);
					loadPanel.hide();
					switch (params.status) {
						case 0:
							DevExpress.ui.notify("Error, fallo la conexión a Internet", "error", 4000);
							break;
						case 500:
							DevExpress.ui.notify("Error, Contactar Soporte Técnico", "error", 4000);
							break;
						default:
							DevExpress.ui.notify("Error, vuelva a intentar, si el incidente persiste contacte a Soporte Técnico", "error", 4000);
							break;
					}
				}
			}).then(function() {
				loadPanel.hide();
			});
		}

		function popupReclasificar() {
			const numMovs = filasSeleccionadas.length;
			console.log(cuentaActual);
			$("#popupReclasificar").remove();
			$("#popupContainer").append('<div id="popupReclasificar"></div>');
			$("#popupReclasificar").dxPopup({
				height: 'auto',
				width: 500,
				title: "Reclasificación de Cuentas",
				visible: false,
				contentTemplate: function(contentElement) {
					let validationGroup = 'mov';

					contentElement.append('<div id="datos"></div>');
					texto = '<div class="col-md-12" style="padding: 0; margin: 0;"><div style="float: right; margin: 5px 0px 0px 0px;" id="btnCancelar"></div>';
					texto += '<div style="float: right; margin: 5px 5px 0px 0px;" id="btnAceptar"></div></div>';
					contentElement.append(texto);

					texto = '<div class="col-md-12" id="inputctcuenta" style="margin-bottom: 6px"/>';
					texto += '<div class="col-md-12" id="inputauxi" style="margin-bottom: 6px"/>';
					texto += '<div class="col-md-12" id="inputcentrocosto" style="margin-bottom: 6px"/>';
					texto += '<div class="col-md-12" id="inputproyecto" style="margin-bottom: 6px"/>';
					texto += '<div class="col-md-12" id="inputmovimientos" style="margin-bottom: 6px"/>';
					$("#datos").append(texto);

					$("#inputctcuenta").dxSelectBox({
						dataSource: ctcuentas,
						noDataText: "Sin Cuentas",
						displayExpr: function(item) {
							return item && item.idctcuenta + ' - ' + item.descrip;
						},
						valueExpr: "idctcuenta",
						searchEnabled: true,
						searchMode: "startswith",
						searchExpr: ["idctcuenta", "descrip"],
						width: "100%",
						value: cuentaActual.idctcuenta,
						label: "Cuenta ",
						labelMode: "floating",
						stylingMode: "filled",
						itemTemplate: function(data) {
							return '<div class="b-b-gris"><div>' + data.idctcuenta + '</div><div>' + data.descrip + '</div></div>';
						},
						onValueChanged: function(e) {

							const cuenta = $("#inputctcuenta").dxSelectBox("instance").option('selectedItem');
							console.log(cuenta)

							$("#inputauxi").dxValidator("instance").reset();
							$("#inputcentrocosto").dxValidator("instance").reset();
							$("#inputproyecto").dxValidator("instance").reset();

							$("#inputauxi").dxSelectBox('instance').option('disabled', false);
							$("#inputcentrocosto").dxSelectBox('instance').option('disabled', false);
							$("#inputproyecto").dxSelectBox('instance').option('disabled', false);

							if (cuenta.useauxi != "" && cuenta.useauxi != null) {
								$("#inputauxi").dxSelectBox('instance').option('disabled', false);
							} else {
								$("#inputauxi").dxSelectBox('instance').option('disabled', true);
							}

							if (cuenta.askidcentro != "" && cuenta.askidcentro != 0) {
								$("#inputcentrocosto").dxSelectBox('instance').option('disabled', false);
							} else {
								$("#inputcentrocosto").dxSelectBox('instance').option('disabled', true);
							}

							if (cuenta.askidproyecto != "" && cuenta.askidproyecto != 0) {
								$("#inputproyecto").dxSelectBox('instance').option('disabled', false);
							} else {
								$("#inputproyecto").dxSelectBox('instance').option('disabled', true);
							}

							getDatosCuenta(cuenta);
						}
					}).dxValidator({
						validationRules: [{
							type: "required",
							message: "La cuenta es requerida"
						}],
						validationGroup: validationGroup,
					});

					$("#inputauxi").dxSelectBox({
						valueExpr: "idauxi",
						displayExpr: "descrip",
						noDataText: "Sin Auxiliares",
						width: "100%",
						disabled: (cuentaActual.useauxi != "" && cuentaActual.useauxi != 0) ? false : true,
						label: "Auxiliar ",
						labelMode: "floating",
						stylingMode: "filled",
					}).dxValidator({
						validationRules: [{
							type: "required",
							message: "El auxiliar de la cuenta es requerido"
						}],
						validationGroup: validationGroup,
					});

					$("#inputcentrocosto").dxSelectBox({
						valueExpr: "idcentro",
						displayExpr: "descrip",
						noDataText: "Sin Centros de Costo",
						width: "100%",
						disabled: (cuentaActual.askidcentro != "" && cuentaActual.askidcentro != 0) ? false : true,
						label: "Centro de Costo ",
						labelMode: "floating",
						stylingMode: "filled",
					}).dxValidator({
						validationRules: [{
							type: "required",
							message: "El centro de costos es requerido"
						}],
						validationGroup: validationGroup,
					});

					$("#inputproyecto").dxSelectBox({
						valueExpr: "id",
						displayExpr: "titulo",
						noDataText: "Sin Proyectos",
						width: "100%",
						disabled: (cuentaActual.askidproyecto != "" && cuentaActual.askidproyecto != 0) ? false : true,
						label: "Proyecto ",
						labelMode: "floating",
						stylingMode: "filled",
					}).dxValidator({
						validationRules: [{
							type: "required",
							message: "El proyecto es requerido"
						}],
						validationGroup: validationGroup,
					});

					$("#inputmovimientos").dxNumberBox({
						width: "40%",
						readOnly: true,
						value: numMovs,
						label: "Movientos a Reclasificar ",
						labelMode: "floating",
						stylingMode: "filled",
					});

					$("#btnAceptar").dxButton({
						disabled: false,
						icon: "check",
						type: "success",
						onClick: function(e) {
							var resultado = e.validationGroup.validate();
							if (resultado.isValid) {
								reclasificarMovimientos();
							}
						},
						validationGroup: validationGroup,
					});

					$("#btnCancelar").dxButton({
						icon: "close",
						type: "danger",
						onClick: function(e) {
							$("#popupReclasificar").dxPopup("instance").hide();
						}
					});
				},
			});

			loadPanel.show();
			$.ajax({
				type: "POST",
				url: "<?= base_url() ?>contabilidad/getDatosReclasificacionCuenta",
				data: {
					askidcentro: cuentaActual.askidcentro,
					askidproyecto: cuentaActual.askidproyecto,
					useauxi: cuentaActual.useauxi
				},
				dataType: "json",
				success: function(respuesta) {
					$("#popupReclasificar").dxPopup("instance").show();

					$("#inputauxi").dxSelectBox('instance').option('dataSource', respuesta.auxis);
					$("#inputcentrocosto").dxSelectBox('instance').option('dataSource', respuesta.centros);
					$("#inputproyecto").dxSelectBox('instance').option('dataSource', respuesta.proyectos);

				},
				error: function(params) {
					console.log(params);
					loadPanel.hide();
					switch (params.status) {
						case 0:
							DevExpress.ui.notify("Error, fallo la conexión a Internet", "error", 4000);
							break;
						case 500:
							DevExpress.ui.notify("Error, Contactar Soporte Técnico", "error", 4000);
							break;
						default:
							DevExpress.ui.notify("Error, vuelva a intentar, si el incidente persiste contacte a Soporte Técnico", "error", 4000);
							break;
					}
				}
			}).then(function() {
				loadPanel.hide();
			});
		}
	});
</script>