<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Xordenes_model extends CI_Model{

		#private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

		function getListadoOrdenesGeneradas($agrupa, $idcentro, $idvendedor, $fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, t100.numero, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND fecha = '$fecha' AND t100.idworker = $idvendedor ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getFormasDePagoTransaccion($idclase){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQLInfo = "SELECT pagos FROM inv_def WHERE invclase = $idclase";
                $QueryInfo = $this->db_b->query($SQLInfo);
                $infoResultado = $QueryInfo->row_array();
                $infoCodigos = $infoResultado['pagos'];
                
                if($infoCodigos != ""){
                	$array = explode(',', $infoCodigos);
	                $total = count($array);
	                $WhereCodes = "";
	                
	                for($i=0; $i<$total; $i++){
	                    $WhereCodes .= "cajclase = $array[$i] OR ";
	                }
	                
	                $WhereCodes = substr($WhereCodes, 0, -4);
	                
	                $SQLPagos = "SELECT * FROM caj_def WHERE ".$WhereCodes;
	                $QueryPagos = $this->db_b->query($SQLPagos);
	                $informacion = $QueryPagos->result();
                }else{
                	$informacion = false;
                }

                return $informacion;
            }
        }

        function insertarFacturacion($fecha, $notas, $idclase, $vendedor, $cliente, $idcentro, $idcentrod, $pago, $referencia = ''){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('numy', $pago);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('ovnumero', $referencia);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                
                $trannum = $this->db_b->insert_id();
                return $trannum;
            }
        }
        
        function insertarFacturacionPedido($fecha, $notas, $idclase, $vendedor, $cliente, $idcentro, $idcaja, $numx, $numz, $idcentrod, $pago, $trannumPedido){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('numy', $pago);
                $this->db_b->set('numx', $numx);
                $this->db_b->set('numz', $numz);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('tranref', $trannumPedido);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                
                $trannum = $this->db_b->insert_id();
                return $trannum;
            }
        }

        function enviarFacturacionCaja($trannum, $numcompra){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('referencia', $numcompra);
                $this->db_b->set('estatus', 8);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }

        function modificarFacturacionCaja($trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }

        function getListadoOrdenesEnviadas($agrupa, $idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.idcentro, t100.fecha, t100.estatus, t100.numero, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1, caj_def.descrip AS formapago FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN caj_def ON t100.numy = caj_def.cajclase WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.estatus = $estado ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function regresarFacturacionDocumento($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idcaja', 0);
                $this->db_b->set('numx', 0);
                $this->db_b->set('numz', 0);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }

        function eliminarDocumentoFacturacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idcaja', 0);
                $this->db_b->set('numx', 0);
                $this->db_b->set('numz', 0);
                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                $SQLDelete = "DELETE FROM tran_100k WHERE trannum = $trannum";
                $QueryDelete = $this->db_b->query($SQLDelete);
                
                return $QueryDelete;
            }
        }

        function anularDocumentoFacturacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQLDelete = "DELETE FROM tran_100 WHERE trannum = $trannum";
                $QueryDelete = $this->db_b->query($SQLDelete);

                $SQLDelete = "DELETE FROM tran_100k WHERE trannum = $trannum";
                $QueryDelete = $this->db_b->query($SQLDelete);
                
                return $QueryDelete;
            }
        }

        function confirmarFacturacionDocumento($trannum, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLNum = "SELECT numx, numz, cajafecha FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
                $infoNum = $Querynum->row_array();
                
                $numero_x = $infoNum['numx'];
                $numero_z = $infoNum['numz'];
                $cajafecha = $infoNum['cajafecha'];

                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('numx', $numero_x);
                $this->db_b->set('numz', $numero_z);
                $this->db_b->set('fecha', $cajafecha);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }

        function getDetalleExistenciasProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha= date("Y-m-d"); 
                
                $consulta ="SELECT invsites.descrip AS centro, ROUND(SUM(tran_100k.cantidad * tran_100k.uniconv), 2) AS cantidad, invproducts.tipo, invproducts.upp FROM invproducts INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro WHERE invproducts.idproducto = $idproducto GROUP BY tran_100k.idproducto, tran_100k.idcentro, tran_100k.idbatch";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getDetalleMultiplesPrecios($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha= date("Y-m-d"); 
                
                $consulta ="SELECT descrip, precioventa FROM invpromulti WHERE idgvar = 1 AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getDetalleInformacionCliente($idusuario){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT * FROM ctauxi WHERE idauxi = $idusuario";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado;
            }
        }

        function totalLineasDocumento($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT maxlines FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $totLineas = $resultado['maxlines'];
                
                return $totLineas;
            }
        }
        
        function insertNuevoClienteVN($descrip, $nrc, $nit, $tipoContribuyente, $giro, $direccion, $idzip, $correo = '', $dteGiro = '', $telefono = ''){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                if ($correo != "") {
                    $this->db_b->set('correo', $correo);
                }
                $this->db_b->set('giro', $giro);
                if ($dteGiro != "") {
                    $this->db_b->set('dte_giro', $dteGiro);
                }
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('idtipo', $tipoContribuyente);
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
                return $idcliente;
            }
        }

        function insertNuevoClienteVNCF($descrip, $dui, $telefono, $correo, $direccion, $idzip) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('dui', $dui);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
                return $idcliente;
            }
        }

        function updateClienteVN($idauxi, $descrip, $nrc, $nit, $tipoContribuyente, $giro, $direccion, $idzip, $correo = '', $dteGiro = '', $telefono = ''){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                if ($correo != "") {
                    $this->db_b->set('correo', $correo);
                }
                $this->db_b->set('giro', $giro);
                if ($dteGiro != "") {
                    $this->db_b->set('dte_giro', $dteGiro);
                }
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('idtipo', $tipoContribuyente);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idauxi);
                $query = $this->db_b->update('ctauxi');
                
                return $query;
            }
        }
        
        function updateClienteVNCF($idauxi, $descrip, $dui, $telefono, $correo, $direccion, $idzip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('dui', $dui);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idauxi);
                $query = $this->db_b->update('ctauxi');
                
                return $query;
            }
        }

        function updateEstadoCotizacion($trannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $estatus = explode(",", $estado);
                
                $this->db_b->set('estatus', $estatus[1]);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function getListadoDeCotizaciones($idcliente, $idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT trannum AS id, CONCAT('Cotizacion N°', trannum) AS descrip FROM orders_100 WHERE agrupa = 'VN' AND idcps = $idcliente AND idworker = $idvendedor AND estatus = 2";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoDeCotizacionesVendedor($idvendedor, $estados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoEstatus = explode(",", $estados);
                
                $consulta ="SELECT trannum AS id, CONCAT('Cotizacion N°', trannum) AS descrip, DATE_FORMAT(orders_100.fecha, '%d/%m/%Y') AS fecha, orders_100.idcentro, orders_100.fecha AS fecha_insert, orders_100.val_pro, orders_100.dev_contact, orders_100.idcps, orders_100.cli_notify, orders_100.cajclase, orders_100.idworker, ctauxi.descrip AS nameCliente, ctauxi2.descrip AS nameVendedor, inv_def.descrip AS nameDocumento, caj_def.descrip AS namePago FROM orders_100 INNER JOIN ctauxi ON orders_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS ctauxi2 ON orders_100.idworker = ctauxi2.idauxi INNER JOIN inv_def ON orders_100.cli_notify = inv_def.invclase INNER JOIN caj_def ON orders_100.cajclase = caj_def.cajclase WHERE orders_100.agrupa = 'VN' AND orders_100.idworker = $idvendedor AND orders_100.estatus = " . $infoEstatus[0]. " ORDER BY orders_100.fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoDeCotizacionesFacturacion($estados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoEstatus = explode(",", $estados);
                
                $consulta = "SELECT trannum AS id, CONCAT('Cotizacion N°', trannum) AS descrip, DATE_FORMAT(orders_100.fecha, '%d/%m/%Y') AS fecha, orders_100.idcentro, orders_100.fecha AS fecha_insert, orders_100.val_pro, orders_100.dev_contact, orders_100.idcps, orders_100.cli_notify, orders_100.cajclase, orders_100.idworker, orders_100.dev_place, ctauxi.descrip AS nameCliente, ctauxi2.descrip AS nameVendedor, inv_def.descrip AS nameDocumento, caj_def.descrip AS namePago FROM orders_100 INNER JOIN ctauxi ON orders_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS ctauxi2 ON orders_100.idworker = ctauxi2.idauxi INNER JOIN inv_def ON orders_100.cli_notify = inv_def.invclase INNER JOIN caj_def ON orders_100.cajclase = caj_def.cajclase WHERE orders_100.agrupa = 'VN' AND orders_100.estatus = " . $infoEstatus[0]. " ORDER BY orders_100.fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoProductosDeCotizaciones($trannum, $idcliente, $idvendedor, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($trannum == 0){
                    $consulta ="SELECT invproducts.idproducto, invproducts.descrip, invproducts.barcode, invproducts.modelo, invproducts.marca, orders_100k.cantrp, orders_100k.cantidad AS cantidadord, orders_100k.precioneto, invproducts.um, invproducts.tipotax, inv_batch.idbatch, invlocations.idbin, invcatalog.descrip AS linea, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro) AS saldo FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE orders_100.agrupa = 'VN' AND orders_100.idcps = $idcliente AND orders_100.idworker = $idvendedor AND orders_100.estatus = 2";
                }else{
                    $consulta ="SELECT invproducts.idproducto, invproducts.descrip, invproducts.barcode, invproducts.modelo, invproducts.marca, orders_100k.cantrp,
                        orders_100k.cantidad AS cantidadord, orders_100k.precioneto, invproducts.um, invproducts.tipotax,
                        IFNULL(inv_batch.idbatch, 9999) AS idbatch, invlocations.idbin, invcatalog.descrip AS linea,
                        IF(invproducts.tipo != 4, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro), 0), 9999) AS saldo
                    FROM orders_100k
                    INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum
                    INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                    LEFT JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    WHERE orders_100.agrupa = 'VN' AND orders_100.trannum = $trannum AND orders_100.idcps = $idcliente AND orders_100.idworker = $idvendedor";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getListadoDePedidosVentas($idcentro, $estados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoEstatus = explode(",", $estados);
                
                $consulta = "SELECT trannum AS id, CONCAT('Pedido N°', trannum) AS descrip, DATE_FORMAT(pedidos_100.fecha, '%d/%m/%Y') AS fecha, pedidos_100.idcentro, pedidos_100.fecha AS fecha_insert, pedidos_100.val_pro, pedidos_100.val_otros, pedidos_100.dev_contact, pedidos_100.idcps, pedidos_100.idclase, pedidos_100.cajclase, pedidos_100.idworker, IFNULL(ctauxi.descrip, pedidos_100.descrip) AS nameCliente, ctauxi2.descrip AS nameVendedor, inv_def.descrip AS nameDocumento, caj_def.descrip AS namePago FROM pedidos_100 LEFT JOIN ctauxi ON pedidos_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS ctauxi2 ON pedidos_100.idworker = ctauxi2.idauxi INNER JOIN inv_def ON pedidos_100.idclase = inv_def.invclase INNER JOIN caj_def ON pedidos_100.cajclase = caj_def.cajclase WHERE pedidos_100.idcentro = $idcentro AND pedidos_100.estatus = " . $infoEstatus[0];
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getListadoProductosDePedido($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($trannum == 0){
                    $consulta ="SELECT invproducts.idproducto, invproducts.descrip, invproducts.modelo, invproducts.marca, invproducts.barcode, orders_100k.cantrp, orders_100k.cantidad AS cantidadord, orders_100k.precioneto, invproducts.um, invproducts.tipotax, inv_batch.idbatch, invlocations.idbin, invcatalog.descrip AS linea, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro) AS saldo FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE orders_100.agrupa = 'VN' AND orders_100.idcps = $idcliente AND orders_100.idworker = $idvendedor AND orders_100.estatus = 2";
                }else{
                    $consulta =" SELECT invproducts.idproducto, invproducts.descrip, invproducts.modelo, invproducts.marca, invproducts.barcode, pedidos_100k.descuento, pedidos_100k.o_qty AS cantidadord, pedidos_100k.precio, invproducts.um, invproducts.tipotax,
                        IFNULL(inv_batch.idbatch, 9999) AS idbatch, invlocations.idbin, invcatalog.descrip AS linea,
                        IF(invproducts.tipo != 4, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = pedidos_100k.idproducto AND tran_100k.idcentro = $idcentro), 0), 9999) AS saldo
                    FROM pedidos_100k
                    INNER JOIN pedidos_100 ON pedidos_100k.trannum = pedidos_100.trannum
                    INNER JOIN invproducts ON pedidos_100k.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                    LEFT JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    WHERE pedidos_100.trannum = $trannum";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function validateDocumentoExentoPedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$SQLQuery = "SELECT inv_def.exento FROM pedidos_100 INNER JOIN inv_def ON pedidos_100.idclase = inv_def.invclase WHERE pedidos_100.trannum = $trannum";
				$Query = $this->db_b->query($SQLQuery);
				$Result = $Query->row_array();
				$exento = $Result['exento'];
                
                return $exento;
			}
        }

        function updateEstadoPedido($trannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $estatus = explode(",", $estado);
                
                $this->db_b->set('estatus', $estatus[1]);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('pedidos_100');
                
                return $query;
            }
        }

        function getCostounitarioProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta    = "SELECT costounitario FROM invproducts WHERE idproducto = $idproducto";
                $Query       = $this->db_b->query($Consulta);
                $informacion = $Query->row_array();

                return number_format($informacion['costounitario'], 4, '.', '');
            }
        }

        function validateOrdenVenta($trannum, $idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.trannum, DATE_FORMAT(a.fecha, "%d/%m/%Y") AS fecha, b.descrip');
                $this->db_b->select('IFNULL(ROUND(ABS((SELECT SUM(x.cantidad * (x.precioneto + (x.precioneto * (x.tax1/100)))) FROM tran_100k x WHERE x.trannum = a.trannum)), 2), 0) AS total');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('ctauxi b', 'a.idcps = b.idauxi');
                $this->db_b->where('(a.estatus = 0 OR a.estatus = 8)');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('a.idcaja', 0);
                $this->db_b->where('a.trannum',  $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;

            }
        }

        function modificarOrdenVenta($trannum, $referencia) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->select('ovnumero');
                $this->db_b->from('tran_100');
                $this->db_b->where('trannum', $trannum);
                $datos = $this->db_b->get();
                $ovnumero = $datos->row()->ovnumero;

                $nReferencia = ( $ovnumero == '' ) ? $referencia : $ovnumero.'-'.$referencia;
                
                $this->db_b->set('estatus', 0);
                $this->db_b->set('ovnumero', $nReferencia);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }
	}
?>
