<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Versacrm_model extends CI_Model{
		
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('default', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        function getCuentas(){
			$consulta = "SELECT *, 
            (CASE 
                WHEN estado = 1 THEN 'Activo'
                WHEN estado = 0 THEN 'Inactivo'
            END) as estadoT
            FROM wpos_cuentas 
            ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
			
            if($query->num_rows() > 0){
                return $query->result();
            }else{
                return false;
            }
		}
        function getServidores(){
			$consulta = "SELECT distinct(dbp1) as server FROM wpos_cuentas ";
            $query = $this->db_b->query($consulta);
			
            if($query->num_rows() > 0){
                return $query->result();
            }else{
                return false;
            }
		}

        function getNamesServers()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select('a.server_name');
                $this->db_b->from('wpos_cuentas a');
                $this->db_b->where('a.estado', 1);
                $this->db_b->not_like('a.server_name', 'master');
                $this->db_b->group_by('a.server_name');
                $this->db_b->order_by('a.server_name', "ASC");
                $query = $this->db_b->get();
                
                $array = [];
                if ($query->num_rows() > 0) {
                    return $query->result();
                } else return false;
            }
        }
        
        function getListadoServidores($nameserver)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select('a.dbp1');
                $this->db_b->from('wpos_cuentas a');
                $this->db_b->where('a.estado', 1);
                $this->db_b->where('a.server_name', $nameserver);
                $this->db_b->group_by('a.dbp1');
                $this->db_b->order_by('a.dbp1', "ASC");
                $query = $this->db_b->get();
                
                $array = [];
                if ($query->num_rows() > 0) {
                    return $query->result();
                } else return false;
            }
        }
        
        function getListadoContratos($idcps)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                
                $this->db_b->select('a.trannum, a.descrip');
                $this->db_b->from('ris_100 a');
                $this->db_b->where('a.idcps', $idcps);
                $this->db_b->where('a.estatus !=', 9);
                $this->db_b->order_by('a.trannum', "ASC");
                $query = $this->db_b->get();
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                $array = [];
                if ($query->num_rows() > 0) {
                    return $query->result();
                } else return false;
            }
        }
        
        function getInformacionContrato($idcontrato)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                
                $this->db_b->select('a.trannum, a.descrip');
                $this->db_b->from('ris_100 a');
                $this->db_b->where('a.trannum', $idcontrato);
                $query = $this->db_b->get();
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                if ($query->num_rows() > 0) {
                    return 'Nº ' . $query->row()->trannum . ' | ' . $query->row()->descrip;
                } else return 'Sin Asignar';
            }
        }
        
        function infoCuenta($idrnum){
			$consulta = "SELECT * FROM wpos_cuentas where idrnum = $idrnum";
            $query = $this->db_b->query($consulta);
			
            if($query->num_rows() > 0){
                return $query->result();
            }else{
                return false;
            }
        }

        function getCuentasCSV() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.descrip, a.ncomercial, a.nrc, a.direccion, a.telefono');
                $this->db_b->select('REPLACE(REPLACE(REPLACE(a.server_name, "www.", ""), "/versanet", ""), "/master", "") AS servidor');
                $this->db_b->from("wpos_cuentas a");
                $this->db_b->where("a.estado", 1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } return false;
            }
        }
        
        function insertCuenta($num_cuenta, $name_empresa, $name_comercial, $num_registro, $direccion, $departament, $fec_ingresa, $fec_vence, $telefono, $correo, $name_server, $num_servidor, $name_bdd, $usuario, $contrasena, $notas, $estado, $inputEcommerce, $nameImagen){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $estado = ($estado == "true") ? 1 : 0;

                $inputEcommerce = ($inputEcommerce == "true") ? 1 : 0;

                $this->db_b->set('idrnum', 0);
                $this->db_b->set('idaccount', $num_cuenta);
                $this->db_b->set('descrip', $name_empresa);
                $this->db_b->set('ncomercial', $name_comercial);
                $this->db_b->set('nrc', $num_registro);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $departament);
                $this->db_b->set('telefono', $telefono); 
                $this->db_b->set('correo', $correo);
                $this->db_b->set('e_commerce', $inputEcommerce);
                $this->db_b->set('e_logo', $nameImagen);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('fechain', $fec_ingresa);
                $this->db_b->set('fechavence', $fec_vence);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('server_name', $name_server);
                $this->db_b->set('dbp1', $num_servidor);
                $this->db_b->set('dbp2', $name_bdd);
                $this->db_b->set('dbp3', $usuario);
                $this->db_b->set('dbp4', $contrasena);
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $query = $this->db_b->insert('wpos_cuentas');
                return $query;
            }
        }
        function updateCuenta($idrnum, $num_cuenta, $name_empresa, $name_comercial, $num_registro, $direccion, $departament, $fec_ingresa, $fec_vence, $telefono, $correo, $name_server, $num_servidor, $name_bdd, $usuario, $contrasena, $notas, $estado, $inputEcommerce, $nameImagen, $idcps, $maxsuc, $maxcajas, $maxusuarios, $idcontrato, $moneda){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $estado = ($estado == "true") ? 1 : 0;

                $inputEcommerce = ($inputEcommerce == "true") ? 1 : 0;

                $this->db_b->set('idaccount', $num_cuenta);
                $this->db_b->set('descrip', $name_empresa);
                $this->db_b->set('ncomercial', $name_comercial);
                $this->db_b->set('nrc', $num_registro);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $departament);
                $this->db_b->set('telefono', $telefono); 
                $this->db_b->set('correo', $correo);
                $this->db_b->set('e_commerce', $inputEcommerce);
                $this->db_b->set('e_logo', $nameImagen);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('fechain', $fec_ingresa);
                $this->db_b->set('fechavence', $fec_vence);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('server_name', $name_server);
                $this->db_b->set('dbp1', $num_servidor);
                $this->db_b->set('dbp2', $name_bdd);
                $this->db_b->set('dbp3', $usuario);
                $this->db_b->set('dbp4', $contrasena);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('maxsuc', $maxsuc);
                $this->db_b->set('maxcajas', $maxcajas);
                $this->db_b->set('maxusuarios', $maxusuarios);
                $this->db_b->set('idcontrato', $idcontrato);
                $this->db_b->set('moneda', $moneda);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrnum',$idrnum);
                $query = $this->db_b->update('wpos_cuentas');
                return $query;
            }
        }
    
        function getMenuHeaders(){
			$consulta = "SELECT * FROM g_vars WHERE nombre='g_menumain' ORDER BY valor_num ASC";
            $query = $this->db_b->query($consulta);
			
            if($query->num_rows() > 0){
                return $query->result();
            }else{
                return false;
            }
		}
        
        function viewApps(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM wpos_apps ORDER BY menuorder";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        

        function viewMenu(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM g_vars WHERE nombre = 'g_menumain' ORDER BY valor_num ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function menuAppName($id){
           if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT id_var, descripcion FROM g_vars WHERE valor_num = $id AND nombre = 'g_menumain'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            } 
        }
        
        function menuHeadAppName($id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idapp, descrip FROM wpos_apps WHERE idapp = $id";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            } 
        }
        
        function insertApp($idMenu, $descrip, $appname, $menuname, $opciones, $menuorder, $img, $notas, $estado, $option, $whodidit, $raya, $tipoM, $idAppH,$saveNext){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('idapp', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('menutype', $tipoM);
                $this->db_b->set('idapphd', $idAppH);
                $this->db_b->set('appname', $appname);
                $this->db_b->set('menuname', $menuname);
                $this->db_b->set('appoptions', $opciones);
                $this->db_b->set('menuorder', $menuorder);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                if($raya=="true"){
                    $this->db_b->set('raya', 1);
                }else{
                    $this->db_b->set('raya', 0);
                }
                $query = $this->db_b->insert('wpos_apps');
                $idapp= $this->db_b->insert_id();
                
                if($img == "" || $img == null){
                    if($saveNext=="true"){
                        redirect('Adicionar_Aplicacion/'.$idMenu.'/'.$tipoM);
                    }else{
                        redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                    }
                }else{
                    $imgSplit = explode(".", $img);
                    $nameImg = "imgApp_".$idapp.".".$imgSplit[1];
                    $this->db_b->set('imagen', $nameImg);
                    $this->db_b->where('idapp', $idapp);
                    $this->db_b->update('wpos_apps');
                    return $nameImg;
                }
            }
        }
        
        
        function callRegistro($id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM wpos_apps WHERE idapp = $id";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function updateApp($idapp, $descrip, $appname, $menuname, $opciones, $menuorder, $img, $notas, $estado, $whodidit, $raya, $tipoM, $idAppH){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s");
                if($tipoM != 1){
                    $this->db_b->set('appname', $appname);
                }
                if($estado=="true"){
                    $estado=1;
                }else{
                    $estado=0;
                }
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('menutype', $tipoM);
                $this->db_b->set('idapphd', $idAppH);
                $this->db_b->set('menuname', $menuname);
                $this->db_b->set('appoptions', $opciones);
                $this->db_b->set('menuorder', $menuorder);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_mod);
                if($raya=="true"){
                    $this->db_b->set('raya', 1);
                }else{
                    $this->db_b->set('raya', 0);
                }
                $this->db_b->where('idapp', $idapp);
                $this->db_b->update('wpos_apps');
                if($img == "" || $img == null){
                    redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                }else{
                    if($img != "" ){
                        $imgSplit = explode(".", $img);
                        $nameImg = "imgApp_".$idapp."_".rand(0, 99999).".".$imgSplit[1];
                        $this->db_b->set('imagen', $nameImg);
                        $this->db_b->where('idapp', $idapp);
                        $this->db_b->update('wpos_apps');
                        return $nameImg;
                    }else{
                        redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                    }
                }
            }
        }
        
        function deleteApp($idapp){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
				$SQLApps = "DELETE FROM wpos_apps WHERE idapp = $idapp";
                $this->db_b->query($SQLApps);
				return $query;
            }
        }
        
        function insertCaso($app, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso, $priority,$time_caso){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idapp', $app);
                $this->db_b->set('fecha', $fecha_caso);
                $this->db_b->set('detalle', $detalle_caso);
                $this->db_b->set('idworker', $worker_caso);
                $this->db_b->set('fasigna', $asignado_caso);
                $this->db_b->set('fdeliver', $cierre_caso);
                $this->db_b->set('ndeliver', $notas_caso);
                $this->db_b->set('estado', $estado_caso);
                $this->db_b->set('prioridad', $priority);
                $this->db_b->set('horas', $time_caso);
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $query = $this->db_b->insert('wpos_appslog');
                return $query;
            }
        }
       
        function getCasosApp($app){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM wpos_appslog WHERE idapp = $app";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }
        function getCasosUser($iduser){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM wpos_appslog WHERE idworker = $iduser AND estado>0";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }

        function getAllCasosUser(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM wpos_appslog WHERE estado>0";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }

        function updateCaso($idrec, $app, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso, $prioridad, $time_caso){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('idapp', $app);
                $this->db_b->set('fecha', $fecha_caso);
                $this->db_b->set('detalle', $detalle_caso);
                $this->db_b->set('idworker', $worker_caso);
                $this->db_b->set('fasigna', $asignado_caso);
                $this->db_b->set('fdeliver', $cierre_caso);
                $this->db_b->set('ndeliver', $notas_caso);
                $this->db_b->set('estado', $estado_caso);
                $this->db_b->set('prioridad', $prioridad);
                $this->db_b->set('horas', $time_caso);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('wpos_appslog');
                return $query;
            }
        }
        
        function deleteCaso($id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM wpos_appslog WHERE idrec = $id";
                $query = $this->db_b->query($consulta);
                return $query;
            }   
        }
        
        function getColaboradoresTask(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT distinct idworker FROM wpos_appslog";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function updateCasoUser($idrec, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso, $prioridad, $time_caso){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('fecha', $fecha_caso);
                $this->db_b->set('detalle', $detalle_caso);
                $this->db_b->set('idworker', $worker_caso);
                $this->db_b->set('fasigna', $asignado_caso);
                $this->db_b->set('fdeliver', $cierre_caso);
                $this->db_b->set('ndeliver', $notas_caso);
                $this->db_b->set('estado', $estado_caso);
                $this->db_b->set('prioridad', $prioridad);
                $this->db_b->set('horas', $time_caso);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('wpos_appslog');
                return $query;
            }
        }
        
        function update_datecuenta($idcuentas,$date){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $count = explode(",", $idcuentas);
                $totalItems = count($count);
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                for($i=0; $i<$totalItems; $i++){
                    $this->db_b->set('fechavence', $date);
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('idaccount', trim($count[$i]));
                    $query = $this->db_b->update('wpos_cuentas');
                }
                return $query;
            }
        }
        #------------------------------------   CONTROL ANALISIS DE ACCESOS --------------------------------------------------------------
        public function getHCuentas($fi, $ff)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select('a.*, b.descrip as cuenta');
                $this->db_b->from("wpos_cuentas_log a");
                $this->db_b->join("wpos_cuentas b", "a.idaccount = b.idaccount");
                $this->db_b->where("a.fecha >=", $fi);
                $this->db_b->where("a.fecha <=", $ff);
                $this->db_b->order_by('b.descrip', "ASC");
                $data = $this->db_b->get();
                return $data;
            }
        }
        #------------------------------------   FIN CONTROL ANALISIS DE ACCESOS ----------------------------------------------------------
        function getServidoresCRM()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select('a.server_name');
                $this->db_b->from('wpos_cuentas a');
                $this->db_b->where('a.estado', 1);
                $this->db_b->not_like('a.server_name', 'master');
                $this->db_b->group_by('a.server_name');
                $this->db_b->order_by('a.server_name', "ASC");
                $query = $this->db_b->get();
                
                $array = [];
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $info) {
                        $array[] = array(
                            'id'   => $info->server_name,
                            'text' =>  str_replace("/versanet", "", str_replace("www.", "", $info->server_name))
                        );
                    }
                }

                return $array;
            }
        }

        function getAnalisisDatos($nameServer, $fi, $ff)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $nServers = str_replace(",", " OR a.server_name = ", $nameServer);
                $this->db_b->select('a.idaccount, a.descrip, a.ncomercial, a.server_name, a.dbp1, a.dbp2, a.dbp3, a.dbp4');
                $this->db_b->from("wpos_cuentas a");
                $this->db_b->where("a.estado ", 1);
                $this->db_b->where("(a.server_name = " . $nServers .")");
                $this->db_b->order_by('a.server_name', "ASC");
                $this->db_b->order_by('a.descrip', "ASC");
                $query = $this->db_b->get();
                
                $array = [];
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $info) {
                        $array[] = array(
                            'idaccount'   => $info->idaccount,
                            'descrip'     => $info->descrip,
                            'ncomercial'  => $info->ncomercial,
                            'server_name' => $info->server_name,
                            'total'       => (int) $this->getCountRegistos($info->dbp1, $info->dbp2, $info->dbp3, $info->dbp4, $fi, $ff)
                        );
                    }
                }

                return $array;
            }
        }

        function getCountRegistos($dbp1, $dbp2, $dbp3, $dbp4, $fi, $ff)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                //echo $dbp3."<br><br>";
                $dbbArray = array(
                    'server_DB' => $dbp1,
                    'name_DB'   => $dbp2,
                    'user_DB'   => $dbp3,
                    'pass_DB'   => $dbp4
                );
                $this->session->set_userdata($dbbArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('qa_db', TRUE);

                $this->db_b->select('a.table_name');
                $this->db_b->from("INFORMATION_SCHEMA.TABLES a");
                $this->db_b->where("a.table_schema", $dbp2);
                $this->db_b->where("a.table_comment !=", "VIEW");
                //$this->db_b->where("a.table_name NOT LIKE", "g%");
                $this->db_b->like("a.table_name", "tran_100");
                $this->db_b->order_by('a.table_comment', "ASC");
                $query = $this->db_b->get();

                //print_r($query->result());
                //echo "<br><br><br>";
                $numRows = 0;
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $info) {
                        $fields = $this->db_b->field_data($info->table_name);
                        foreach ($fields as $field)
                        {
                            if ( $field->name  == 'ingresa')
                            {
                                $query = $this->db_b->query('SELECT IFNULL(COUNT(*), 0) AS num_rows FROM '.$info->table_name.' WHERE ingresa BETWEEN "'.$fi.' 00:00:00" AND "'.$ff.' 23:59:59"');
                                if ($query->num_rows() > 0) {
                                    $numRows =  $numRows + $query->row()->num_rows;
                                }
                            }
                        }
                    }
                }
                
                return $numRows;
            }
        }
    }
?>