<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Ventas_model extends CI_Model{

		#private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){ 
                echo 'Incorrect database information provided';
            }
        }

		public function getAnios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT DISTINCT date_format(fecha, '%Y') as anio FROM daily_sales ORDER BY anio DESC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
        
		public function getEstadisticasAnio($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$consulta="SET lc_time_names = 'es_SV' ";
				$query = $this->db_b->query($consulta);
				$consulta = "SELECT date_format(daily_sales.fecha, '%m') as mes, UCASE(date_format(daily_sales.fecha, '%M')) as mesName,  SUM(valventan) AS Total, gvars.descripcion,";

				$consulta1 = "SELECT descripcion, idrnum FROM gvars WHERE nombre = 'gv_tipo'";
				$query1 = $this->db_b->query($consulta1);
				$resultado1 = $query1->result();

				foreach($resultado1 as $key){
					$tipo = $key->descripcion;
					$idrnum = $key->idrnum;
					$consulta.="(SELECT SUM(valventan) FROM daily_sales INNER JOIN invsites ON (invsites.idcentro= daily_sales.idcentro) WHERE invsites.tipo=$idrnum AND date_format(daily_sales.fecha, '%m')= mes AND date_format(daily_sales.fecha, '%Y')  = '$anio') as '$idrnum', ";
				}

				$consulta.=" gvars.descripcion  FROM daily_sales INNER JOIN invsites ON (invsites.idcentro= daily_sales.idcentro) INNER JOIN gvars ON(invsites.tipo=gvars.idrnum) WHERE date_format(daily_sales.fecha, '%Y')  = '$anio' GROUP BY mes ORDER BY mes ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getEstadisticasAnio2($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$consulta="SET lc_time_names = 'es_SV' ";
				$query = $this->db_b->query($consulta);
				$consulta = "SELECT date_format(daily_sales.fecha, '%m') as mes, UCASE(date_format(daily_sales.fecha, '%M')) as mesName,  CAST(SUM(valventan) AS DECIMAL(10,2)) AS Total, gvars.descripcion,";

				$consulta1 = "SELECT descripcion, idrnum FROM gvars WHERE nombre = 'gv_tipo'";
				$query1 = $this->db_b->query($consulta1);
				$resultado1 = $query1->result();

				foreach($resultado1 as $key){
					$tipo = $key->descripcion;
					$idrnum = $key->idrnum;
					$consulta.="(SELECT CAST(SUM(valventan) AS DECIMAL(10,2)) FROM daily_sales INNER JOIN invsites ON (invsites.idcentro= daily_sales.idcentro) WHERE invsites.tipo=$idrnum AND date_format(daily_sales.fecha, '%m')= mes AND date_format(daily_sales.fecha, '%Y')  = '$anio') as '$idrnum', ";
				}

				$consulta.=" gvars.descripcion  FROM daily_sales INNER JOIN invsites ON (invsites.idcentro= daily_sales.idcentro) INNER JOIN gvars ON(invsites.tipo=gvars.idrnum) WHERE date_format(daily_sales.fecha, '%Y')  = '$anio' GROUP BY mes ORDER BY mes ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		public function getEstadisticasSucursal($centros, $anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$subquery="";
				$centrosids = explode(", ", $centros);
				$totCenters = count($centrosids);
				$realCenters = $totCenters - 1;
				$where_centros="";

				for($i=0; $i<=$realCenters; $i++){
					$where_centros .= " (daily_sales.idcentro=$centrosids[$i]) OR";
				}
				$where_centros = substr($where_centros, 0, -2);

				$consulta="SET lc_time_names = 'es_SV' ";
				$query = $this->db_b->query($consulta);
				$consulta = "SELECT date_format(daily_sales.fecha, '%m') as mes, UCASE(date_format(daily_sales.fecha, '%M')) as month,  CAST(SUM(valventan) AS DECIMAL (10 , 2 )) AS Total, daily_sales.idcentro, ";

				for($i=0; $i<=$realCenters; $i++){
					$subquery .= " (SELECT  CAST(SUM(valventan) AS DECIMAL (10 , 2 ))  FROM daily_sales  WHERE daily_sales.idcentro=$centrosids[$i]  AND date_format(daily_sales.fecha, '%m')= mes AND date_format(daily_sales.fecha, '%Y')  = $anio) as 'C$centrosids[$i]',";
				}
				$subquery = substr($subquery, 0, -1);

				$consulta .= "$subquery FROM daily_sales 
				INNER JOIN invsites ON (invsites.idcentro= daily_sales.idcentro) 
				WHERE date_format(daily_sales.fecha, '%Y')  = '$anio' AND ($where_centros)
				GROUP BY mes
				ORDER BY mes ASC, Total ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getEstadisticasSeries($centros, $anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$where_centros="";
				$centrosids = explode(", ", $centros);
				$totCenters = count($centrosids);
				$realCenters = $totCenters - 1;

				for($i=0; $i<=$realCenters; $i++){
					$where_centros .= " idcentro=$centrosids[$i] OR";
				}
				$where_centros = substr($where_centros, 0, -2);

				$consulta = "SELECT CONCAT('C',idcentro) as valueField, descrip as name  FROM invsites WHERE ($where_centros)";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		public function getEstadisticasCategorias($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}

				$consulta="SELECT invcatalog.idnivel1 as ID, invcatalog2.descrip as name FROM inv_prostats INNER JOIN	invproducts ON invproducts.idproducto= inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo= invproducts.idcatalogo INNER JOIN invcatalog  as invcatalog2 on invcatalog2.idcatalogo=invcatalog.idnivel1 WHERE inv_prostats.idano= $anio AND agrupa='VN' GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
				$query = $this->db_b->query($consulta);
				$categorias = $query->result();

				$subconsulta ='';
				foreach($categorias as $cat){
					$subconsulta.=" (SELECT 
						SUM(ABS(venta))
						FROM
						inv_prostats AS inv_prostatsSUB
						INNER JOIN
						invproducts AS invproductsSUB ON invproductsSUB.idproducto = inv_prostatsSUB.idproducto
						INNER JOIN
						invcatalog AS invcatalogSUB ON invcatalogSUB.idcatalogo = invproductsSUB.idcatalogo
						INNER JOIN
						invcatalog AS catalog2SUB ON catalog2SUB.idcatalogo = invcatalogSUB.idnivel1
						WHERE
						catalog2SUB.idcatalogo =$cat->ID AND inv_prostatsSUB.idmes = mes AND inv_prostatsSUB.idano=$anio) AS C$cat->ID, ";
				}

				$consulta = "SELECT 
				inv_prostats.idmes AS mes,
				inv_prostats.idano AS anio,
				SUM(ABS(venta)) AS total,";
				$consulta.= $subconsulta;

				$consulta .= " catalog2.idcatalogo
				FROM
				inv_prostats
				INNER JOIN
				invproducts ON invproducts.idproducto = inv_prostats.idproducto
				INNER JOIN
				invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
				INNER JOIN
				invcatalog AS catalog2 ON catalog2.idcatalogo = invcatalog.idnivel1
				WHERE
				inv_prostats.idano = $anio
				AND agrupa = 'VN'
				GROUP BY inv_prostats.idmes
				ORDER BY inv_prostats.idmes";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getSeriesCategorias_array($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$consulta="SELECT  invcatalog.idnivel1 as ID, CONCAT('C',invcatalog.idnivel1) as valueField, invcatalog2.descrip as name FROM inv_prostats INNER JOIN	invproducts ON invproducts.idproducto= inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo= invproducts.idcatalogo INNER JOIN invcatalog  as invcatalog2 on invcatalog2.idcatalogo=invcatalog.idnivel1 WHERE inv_prostats.idano= $anio AND agrupa='VN' GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getSeriesCategorias($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$consulta="SELECT  invcatalog.idnivel1 as ID, CONCAT('C',invcatalog.idnivel1) as valueField, invcatalog2.descrip as name FROM inv_prostats INNER JOIN	invproducts ON invproducts.idproducto= inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo= invproducts.idcatalogo INNER JOIN invcatalog  as invcatalog2 on invcatalog2.idcatalogo=invcatalog.idnivel1 WHERE inv_prostats.idano= $anio AND agrupa='VN' GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		public function getEstadisticasVendedor($vendedores, $anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$where_vend="";
				$vendedoresids = explode(", ", $vendedores);
				$totV = count($vendedoresids);
				$realV = $totV - 1;

				for($i=0; $i<=$realV; $i++){
					$where_vend .= " (SELECT 
					IFNULL(SUM(t1.valventan),0)
					FROM
					tran_100 AS t1
					WHERE
					DATE_FORMAT(t1.fecha, '%m') = mes
					AND t1.idworker = $vendedoresids[$i]
					AND t1.estatus = 1
					AND DATE_FORMAT(t1.fecha, '%Y')=$anio
					) AS V$vendedoresids[$i],";
				}
				$where_vend = substr($where_vend, 0, -1);

				$consulta="SET lc_time_names = 'es_SV' ";
				$query = $this->db_b->query($consulta);
				$consulta = "SELECT 
				DATE_FORMAT(tran_100.fecha, '%m') AS mes,
				UCASE(DATE_FORMAT(tran_100.fecha, '%M')) AS mesName,
				tran_100.trannum, ";

				$consulta .="$where_vend,  IFNULL(SUM(tran_100.valventan),0) as Total FROM
				tran_100
				WHERE
				tran_100.estatus = 1 AND DATE_FORMAT(tran_100.fecha, '%Y')=$anio
				GROUP BY mes";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getVendedoresSeries($vendedores, $anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$where_vend="";
				$vendedoresids = explode(", ", $vendedores);
				$totV = count($vendedoresids);
				$realV = $totV - 1;

				for($i=0; $i<=$realV; $i++){
					$where_vend .= " idauxi=$vendedoresids[$i] OR";
				}
				$where_vend = substr($where_vend, 0, -2);

				$consulta = "SELECT CONCAT('V',idauxi) as valueField, descrip as name  FROM ctauxi WHERE ($where_vend)";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		public function getEstadisticasAgrupacion($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($anio==0){
					$anio = date("Y"); 
				}
				$consulta="SELECT distinct grupo as valueField, grupo as name FROM ctauxi WHERE idauxidef=2 ORDER BY grupo ASC";
				$query = $this->db_b->query($consulta);
				$grupos = $query->result();

				$subconsulta ='';
				$l=1;

				foreach($grupos as $gp){
					$val = trim($gp->valueField);
					$val = str_replace(' ', '', $val);
					$bus="";
					if($val!="" || $val!=null){
						$val = trim($gp->valueField);
						$val = str_replace(' ', '', $val);
						$bus= $gp->valueField;
						$subconsulta.=" (SELECT IFNULL(SUM(t1.valventan),0) 
						FROM tran_100 AS t1 
						INNER JOIN  ctauxi AS cliente_int ON cliente_int.idauxi = t1.idcps 
						WHERE DATE_FORMAT(t1.fecha, '%m') = mes AND grupo LIKE '$bus') AS G_$val, ";
					}
				}

				$subconsulta.=" (SELECT IFNULL(SUM(t1.valventan),0) 
				FROM tran_100 AS t1 
				INNER JOIN  ctauxi AS cliente_int ON cliente_int.idauxi = t1.idcps 
				WHERE DATE_FORMAT(t1.fecha, '%m') = mes AND (grupo = '' OR grupo=null)) AS G_singrupo, ";

				$consulta = "SELECT 
				DATE_FORMAT(tran_100.fecha, '%m') AS mes,
				UCASE(DATE_FORMAT(tran_100.fecha, '%M')) AS mesName,
				cliente.grupo,
				";
				$consulta .= $subconsulta;

				$consulta .= " IFNULL(SUM(tran_100.valventan), 0) AS Total FROM
				tran_100
				INNER JOIN
				ctauxi AS cliente ON cliente.idauxi = tran_100.idcps
				INNER JOIN
				inv_def ON inv_def.invclase = tran_100.idclase
				AND inv_def.agrupa = 'VN'
				WHERE
				tran_100.estatus = 1 AND DATE_FORMAT(tran_100.fecha, '%Y') = $anio
				GROUP BY mes";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result_array();
				return $resultado;
			}
		}

		public function getSeriesAgrupacion($anio){
			$consulta = "SELECT distinct CONCAT('G_',TRIM(grupo)) as valueField, IFNULL(grupo, 'Sin Grupo') as name FROM ctauxi WHERE idauxidef=2 ORDER BY grupo ASC";
			$query = $this->db_b->query($consulta);
			$resultado = $query->result();
			return $resultado;
		} 

		public function getSeriesAgrupacionResult($anio){
			$consulta = "SELECT distinct grupo as valueField, grupo as name FROM ctauxi WHERE idauxidef=2 ORDER BY grupo ASC";
			$query = $this->db_b->query($consulta);
			$resultado = $query->result_array();
			return $resultado;
		}

		public function getAllVentas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT   daily_sales.fecha, date_format(daily_sales.fecha,'%d/%m/%Y')  as fechaFormat,  daily_sales.hora,  SUM(daily_sales.valcosto) AS valcosto,  SUM(daily_sales.valventan) AS valventan,  SUM(daily_sales.hits) AS hits FROM  daily_sales  WHERE agrupa='VN' GROUP BY daily_sales.fecha ORDER BY daily_sales.fecha ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		public function getTotalVentas_Pie(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT   SUM(daily_sales.valcosto) AS valcosto,  SUM(daily_sales.valventan) AS valventan,  SUM(daily_sales.hits) AS hits FROM  daily_sales  WHERE agrupa='VN'";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
        function getOrdenes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100.estatus, gvars.descripcion as estado, orders_100.trannum, DATE_FORMAT(orders_100.fecha, '%Y/%m/%d') AS fecha, DATE_FORMAT(orders_100.fecact, '%Y/%m/%d') AS fecact, ctauxi.descrip AS workername, clients.descrip as clientName, orders_100.val_tot, SUM(orders_100.val_pro + orders_100.val_envio + orders_100.val_otros) AS val_total, IF(orders_100.dev_place='999999',clients.direccion, (SELECT descrip FROM ctauximulti WHERE idrec=orders_100.dev_place)) as lugar_entrega FROM orders_100 INNER JOIN ctauxi ON orders_100.idworker = ctauxi.idauxi INNER JOIN ctauxi as clients ON orders_100.idcps = clients.idauxi INNER JOIN gvars ON orders_100.estatus = gvars.valor_num AND  nombre LIKE 'so_stat' WHERE agrupa = 'VN' GROUP BY orders_100.trannum ORDER BY orders_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getListadoDetalleCotizaciones($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100.estatus, gvars.descripcion as estado, orders_100.trannum, DATE_FORMAT(orders_100.fecha, '%Y/%m/%d') AS fecha, DATE_FORMAT(orders_100.fecact, '%Y/%m/%d') AS fecact, ctauxi.descrip AS workername, clients.descrip as clientName, clients.telefono, orders_100.val_tot, SUM(orders_100.val_pro + orders_100.val_envio + orders_100.val_otros) AS val_total, IF(orders_100.dev_place='999999',clients.direccion, (SELECT descrip FROM ctauximulti WHERE idrec=orders_100.dev_place)) as lugar_entrega, orders_100.dev_contact, orders_100.referencia FROM orders_100 INNER JOIN ctauxi ON orders_100.idworker = ctauxi.idauxi INNER JOIN ctauxi as clients ON orders_100.idcps = clients.idauxi INNER JOIN gvars ON orders_100.estatus = gvars.valor_num AND  nombre LIKE 'so_stat' WHERE agrupa = 'VN' AND orders_100.idcentro = $idcentro GROUP BY orders_100.trannum ORDER BY orders_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function generarCopiasCotizacion($trannum, $copias) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->select('a.*');
                $this->db_b->from('orders_100 a');
                $this->db_b->where('a.trannum', $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    for ($i=0; $i < $copias; $i++) {
                        foreach ($datos->result() as $dato) {
                            $this->db_b->set('trannum', 0);
                            $this->db_b->set('idcentro', $dato->idcentro);
                            $this->db_b->set('procentro', $dato->procentro);
                            $this->db_b->set('agrupa', $dato->agrupa);
                            $this->db_b->set('cajclase', $dato->cajclase);
                            $this->db_b->set('descrip', $dato->descrip);
                            $this->db_b->set('fecha', $date->format('Y-m-d'));
                            $this->db_b->set('fecact', $date->format('Y-m-d'));
                            $this->db_b->set('fecvence', $dato->fecvence);
                            $this->db_b->set('cli_phone', $dato->cli_phone);
                            $this->db_b->set('cli_email', $dato->cli_email);
                            $this->db_b->set('cli_notify', $dato->cli_notify);
                            $this->db_b->set('dev_place', $dato->dev_place);
                            $this->db_b->set('dev_direc', $dato->dev_direc);
                            $this->db_b->set('dev_date', $dato->dev_date);
                            $this->db_b->set('dev_time', $dato->dev_time);
                            $this->db_b->set('dev_idcentro', $dato->dev_idcentro);
                            $this->db_b->set('dev_phone', $dato->dev_phone);
                            $this->db_b->set('dev_contact', $dato->dev_contact);
                            $this->db_b->set('idcps', $dato->idcps);
                            $this->db_b->set('idworker', $dato->idworker);
                            $this->db_b->set('nrc', $dato->nrc);
                            $this->db_b->set('referencia', $dato->referencia);
                            $this->db_b->set('estatus', 1); // 20240405 cambiado por EMGG
                            $this->db_b->set('lines100k', $dato->lines100k);
                            $this->db_b->set('val_tot', $dato->val_tot);
                            $this->db_b->set('val_pro', $dato->val_pro);
                            $this->db_b->set('val_anti', $dato->val_anti);
                            $this->db_b->set('val_envio', $dato->val_envio);
                            $this->db_b->set('val_otros', $dato->val_otros);
                            $this->db_b->set('notas', $dato->notas);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $this->db_b->insert('orders_100');

                            $ordernum = $this->db_b->insert_id();

                            $this->db_b->select('a.*');
                            $this->db_b->from('orders_100k a');
                            $this->db_b->where('a.trannum', $trannum);
                            $informacion = $this->db_b->get();

                            if ($informacion->num_rows() > 0) {
                                foreach ($informacion->result() as $info) {
                                    $this->db_b->set('idrec', 0);
                                    $this->db_b->set('trannum', $ordernum);
                                    $this->db_b->set('itemline', $info->itemline);
                                    $this->db_b->set('idproducto', $info->idproducto);
                                    $this->db_b->set('idbatch', $info->idbatch);
                                    $this->db_b->set('idbin', $info->idbin);
                                    $this->db_b->set('descrip', $info->descrip);
                                    $this->db_b->set('cantidad', $info->cantidad);
                                    $this->db_b->set('cantrp', $info->cantrp);
                                    $this->db_b->set('um', $info->um);
                                    $this->db_b->set('uniconv', $info->uniconv);
                                    $this->db_b->set('precioneto', $info->precioneto);
                                    $this->db_b->set('notas', $info->notas);
                                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                                    $this->db_b->insert('orders_100k');
                                }
                            }                            
                        }
                    }

                    return true;
                } else return false;
            }
        }

		function verificar_producto($search, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta1 = "SELECT idproducto FROM invproducts WHERE (idproducto='$search' || modelo='$search'  || barcode='$search')";
				$query1 = $this->db_b->query($consulta1);
				$result = $query1->row_array();

				if($result!=null){
					$idproduct = $result['idproducto'];
					if($idproduct>0){
						$consulta = "SELECT count(idproducto) as cant from orders_100k where trannum=$trannum and idproducto='$idproduct'";
						$query = $this->db_b->query($consulta);
						$resultado = $query->row_array();
						return $resultado['cant'];
					}else{
						return 0;
					}
				}else{
					return 0;
				}
			}
		}

		function get_Pro($search,$trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta1 = "SELECT idproducto FROM invproducts WHERE (idproducto='$search' || modelo='$search'  || barcode='$search')";
				$query1 = $this->db_b->query($consulta1);
				$result = $query1->row_array();
				$idproduct = $result['idproducto'];

				$consulta = "SELECT idrec, cantidad, precioneto, notas from orders_100k where trannum=$trannum and idproducto='$idproduct'";
				$query = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				return $resultado;
			}
		}

		function validateDocumentoExento($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$SQLQuery = "SELECT inv_def.exento FROM orders_100 INNER JOIN inv_def ON orders_100.cli_notify = inv_def.invclase WHERE orders_100.trannum = $trannum";
				$Query = $this->db_b->query($SQLQuery);
				$Result = $Query->row_array();
				$exento = $Result['exento'];
                
                return $exento;
			}
        }
        
        function validateDocumentoExentoTran100($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$SQLQuery = "SELECT inv_def.exento FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE tran_100.trannum = $trannum";
				$Query = $this->db_b->query($SQLQuery);
				$Result = $Query->row_array();
				$exento = $Result['exento'];
                
                return $exento;
			}
		}

		function getVendedores(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT tran_100.idworker AS empleado, ctauxi.descrip AS vendedor, tran_100.fecha, invcatalog.idcatalogo AS catalago, invcatalog.descrip AS categoria, tran_100k.precioneto, SUM(tran_100k.cantidad), ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
				FROM ctauxi
				INNER JOIN tran_100k ON ctauxi.idauxi = tran_100k.idworker
				INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN'
				GROUP BY vendedor, categoria, tran_100k.precioneto,  MONTH(tran_100.fecha), YEAR(tran_100.fecha)
				ORDER BY vendedor, valorventa DESC";

				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getValorVentaC($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT tran_100.idworker AS id, ctauxi.descrip AS vendedor, MONTH(tran_100.fecha) AS mes, invcatalog.descrip AS categoria, ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY vendedor, categoria, tran_100k.precioneto, MONTH(tran_100.fecha)
				ORDER BY vendedor, valorventa DESC";

				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getValorVentaCL($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT tran_100.idworker AS idv, tran_100.idcps AS idc , tran_100.trannum AS id,  MONTH(tran_100.fecha) AS mes,  ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY idv, idc, tran_100k.precioneto, MONTH(tran_100.fecha)
				ORDER BY valorventa DESC";

				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getValorVentaCLL($anio, $idv, $idc, $mes){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT IFNULL(SUM(tran_100k.precioneto*tran_100k.cantidad)*-1,0) AS total, MONTH(tran_100.fecha) AS mes
				FROM tran_100k
				INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
				WHERE tran_100.idworker = $idv AND tran_100.idcps = $idc AND YEAR(tran_100.fecha) = $anio AND MONTH(tran_100.fecha) = $mes
				GROUP BY tran_100.idworker, tran_100.idcps, MONTH(tran_100.fecha)";

				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$resultado = $query->result();
					return $resultado;    
				}else{
					return false;     
				}
			}
		}

		function getVendedoresDetalleV($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT DISTINCT(ctauxi.descrip) AS vendedor, tran_100.idworker AS id
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				WHERE ctauxi.idauxidef = 3 AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY vendedor
				ORDER BY tran_100.fecha DESC LIMIT 9";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getVendedoresDetalleVende($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT DISTINCT(ctauxi.descrip) AS vendedor, tran_100.idworker AS id
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				WHERE ctauxi.idauxidef = 3 AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY vendedor
				ORDER BY tran_100.fecha DESC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getVendedoresDetalleD(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT DISTINCT(ctauxi.descrip) AS vendedor, tran_100.idworker AS id
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN'
				GROUP BY vendedor
				ORDER BY vendedor ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getMesesDetalleV($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT DISTINCT(MONTH(tran_100.fecha)) AS mes
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getVendedoresDetalleVC($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT ctauxi.descrip AS vendedor, invcatalog.descrip AS categoria
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY vendedor, categoria
				ORDER BY vendedor, categoria ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

		function getVendedoresDetalleVCM($anio){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta ="SELECT ctauxi.descrip AS vendedor, invcatalog.descrip AS categoria, MONTH(tran_100.fecha) AS mes
				FROM ctauxi
				INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
				INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
				INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
				INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
				INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
				WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
				GROUP BY vendedor, categoria, mes
				ORDER BY vendedor, categoria, mes ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
        
        function getVendedoresDetalleVCMV($anio){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT ctauxi.descrip AS vendedor, invcatalog.descrip AS categoria, MONTH(tran_100.fecha) AS mes, ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
                            GROUP BY vendedor, categoria, mes, tran_100k.precioneto
                            ORDER BY vendedor, categoria, mes ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getVendedoresClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT tran_100.trannum AS id, tran_100.idworker AS empleado, ctauxi.descrip AS vendedor, tran_100.fecha, tran_100.idcps AS cliente, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi WHERE id = tran_100.trannum) AS categoria, tran_100k.precioneto, SUM(tran_100k.cantidad), ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
                            WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN'
                            GROUP BY vendedor, categoria, tran_100k.precioneto, MONTH(tran_100.fecha), YEAR(tran_100.fecha)
                            ORDER BY vendedor, valorventa DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getVendedoresDetalleC($anio){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT tran_100.trannum AS id, tran_100.idworker AS idv, tran_100.idcps AS cliente, (
                            SELECT ctauxi.descrip
                            FROM ctauxi
                            INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi
                            WHERE id = tran_100.trannum) AS categoria
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
                            WHERE ctauxi.idauxidef = 3 AND inv_def.agrupa = 'VN' AND (YEAR(tran_100.fecha) = $anio)
                            GROUP BY idv, categoria
                            ORDER BY idv ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getVendedoresDetalleCL($anio, $id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT tran_100.trannum AS id, tran_100.idworker AS idv, tran_100.idcps AS cliente, (
                            SELECT ctauxi.descrip
                            FROM ctauxi
                            INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi
                            WHERE id = tran_100.trannum) AS categoria
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            WHERE ctauxi.idauxidef = 3 AND (YEAR(tran_100.fecha) = $anio) AND tran_100.idworker = $id
                            GROUP BY idv, categoria
                            ORDER BY idv ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleVendedorAnio($anio, $emplea, $catalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.idworker,ctauxi.descrip AS vendedor, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto AS codigo, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ABS(SUM(tran_100k.precioneto * tran_100k.cantidad)) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                             FROM ctauxi
                             INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                             INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                             INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                             INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                             INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                             WHERE ((ctauxi.descrip LIKE('$emplea')) AND (invcatalog.descrip LIKE('$catalogo')) AND (YEAR(tran_100.fecha) = $anio))  AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                             GROUP BY vendedor, detalle"; 	
                            
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleVendedor($anio, $mes, $emplea, $catalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.idworker,ctauxi.descrip AS vendedor, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto AS codigo, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ((SUM(tran_100k.precioneto * tran_100k.cantidad)) * -1) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE ((ctauxi.descrip LIKE('$emplea')) AND (invcatalog.descrip LIKE('$catalogo')) AND (MONTH(tran_100.fecha)= $mes)  AND (YEAR(tran_100.fecha) = $anio))  AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY vendedor, detalle";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleVendedorAnioCliente($anio, $emplea, $catalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum AS id, tran_100.idworker,ctauxi.descrip AS vendedor, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi WHERE id = tran_100.trannum) AS cliente, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto AS codigo, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ABS(SUM(tran_100k.precioneto * tran_100k.cantidad)) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE ((ctauxi.descrip LIKE('$emplea')) AND (ctauxi2.descrip LIKE('$catalogo')) AND (YEAR(tran_100.fecha) = $anio)) AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY vendedor, detalle"; 	
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleVendedorCliente($anio, $mes, $emplea, $catalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum AS id, tran_100.idworker,ctauxi.descrip AS vendedor, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi WHERE id = tran_100.trannum) AS cliente, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto AS codigo, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ((SUM(tran_100k.precioneto * tran_100k.cantidad)) * -1) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE ((ctauxi.descrip LIKE('$emplea')) AND (ctauxi2.descrip LIKE('$catalogo')) AND (MONTH(tran_100.fecha)= $mes) AND (YEAR(tran_100.fecha) = $anio)) AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY vendedor, detalle";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewCat(){
            $consulta = "SELECT idcatalogo, descrip AS categoria FROM invcatalog WHERE nivel = 1 ORDER BY descrip";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function viewSubcat(){
            $consulta = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS subcategoria, invcatalog.idnivel1, tran_100.fecha, tran_100k.precioneto, SUM(tran_100k.cantidad), ((tran_100k.precioneto * ((SUM(tran_100k.cantidad)))) * -1) valorventa
                        FROM invcatalog
                        INNER JOIN invproducts ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto
                        INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
                        INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                        WHERE invcatalog.nivel = 2 AND inv_def.agrupa = 'VN'
                        GROUP BY subcategoria, tran_100k.precioneto,  DAY(tran_100.fecha), MONTH(tran_100.fecha), YEAR(tran_100.fecha)";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function getDetalleProductoAnio($anio, $subcategoria){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.idworker,ctauxi.descrip AS vendedor, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ABS(SUM(tran_100k.precioneto * tran_100k.cantidad)) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE (invcatalog.descrip LIKE('$subcategoria')) AND (YEAR(tran_100.fecha) = $anio) AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY detalle"; 	
                            
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleProductoDia($anio, $mes, $dia, $subcategoria){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.idworker,ctauxi.descrip AS vendedor, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ((SUM(tran_100k.precioneto * tran_100k.cantidad)) * -1) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE (invcatalog.descrip LIKE('$subcategoria')) AND (MONTH(tran_100.fecha)= $mes)  AND (YEAR(tran_100.fecha) = $anio) AND (DAY(tran_100.fecha) = $dia) AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY detalle ";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getDetalleProducto($anio, $mes, $subcategoria){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.idworker,ctauxi.descrip AS vendedor, invcatalog.idcatalogo AS numcatalago, invproducts.idproducto, invproducts.descrip AS detalle, invproducts.marca AS marca, tran_100.fecha, tran_100k.precioneto, ABS(SUM(tran_100k.cantidad)) AS cantidad, ((SUM(tran_100k.precioneto * tran_100k.cantidad)) * -1) AS venta, ABS(SUM((tran_100k.precioneto * tran_100k.cantidad)) / SUM(tran_100k.cantidad)) AS promedio
                            FROM ctauxi
                            INNER JOIN tran_100 ON ctauxi.idauxi = tran_100.idworker
                            INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE (invcatalog.descrip LIKE('$subcategoria')) AND (MONTH(tran_100.fecha)= $mes)  AND (YEAR(tran_100.fecha) = $anio) AND inv_def.agrupa = 'VN' AND tran_100k.cantidad != 0 AND tran_100k.precioneto != 0
                            GROUP BY detalle ";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function formasPago(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT cajclase,descrip FROM caj_def WHERE agrupa='VN' AND estatus=1  ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function tipoDoc(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invclase, descrip FROM inv_def WHERE agrupa='VN' AND estatus = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function tipoDocSumaCaja(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                // $consulta = "SELECT invclase, descrip, askregiva, facturakey FROM inv_def WHERE agrupa='VN' AND estatus = 1 AND caopera = 1 ORDER BY descrip ASC";
                $consulta = "SELECT invclase, descrip, askregiva, facturakey, caopera, iddte FROM inv_def WHERE agrupa='VN' AND estatus = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado; 
            }
        }
        
        function getVendedoresActivos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT idauxi, descrip FROM ctauxi WHERE idauxidef = 3 AND estado = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getVendedoresActivosxSucursal($grupo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT DISTINCT a.idauxi, a.descrip FROM ctauxi a 
                WHERE a.idauxidef = 3 AND a.estado = 1 AND a.grupo LIKE '%Tecnico%'
                ORDER BY a.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;

                //INNER JOIN gusers b ON a.idauxi = b.idcps 
                //b.idcentro = $idcentro OR (b.derechos LIKE '%multiSucursal%') 
            }
        }
        
        function insertOrden($idcentrouser, $idcliente, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit, $inputDirigido, $inputCorreo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentrouser);
                $this->db_b->set('agrupa', 'VN');
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('fecha', $fechaingreso);
                $this->db_b->set('cli_notify', $tipoDocumento);
                $this->db_b->set('dev_contact', $inputDirigido);
                $this->db_b->set('cli_email', $inputCorreo);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('idcps', $idcliente);
                $this->db_b->set('dev_date', $fechaentrega);
                $this->db_b->set('dev_place', $lugar_entrega);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', '1');
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('orders_100');
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
        
        function getVendedorCliente($idcliente){
             if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                 $consulta="SELECT idcps FROM ctauxi WHERE idauxi=$idcliente";
                 $query = $this->db_b->query($consulta);
                 $result = $query->row_array();
                 return $result['idcps'];
             }
            
        }
        
        function detalleOrdenVenta($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT orders_100.trannum, orders_100.cli_notify, orders_100.cli_email, orders_100.cajclase, orders_100.fecha, orders_100.fecvence, orders_100.dev_place, CONCAT(orders_100.dev_date, ',', orders_100.dev_time) AS dev_date, orders_100.dev_contact, orders_100.idcps, orders_100.idworker, orders_100.referencia, orders_100.estatus, orders_100.val_tot, orders_100.notas, worker.descrip AS workername, cliente.descrip AS cliente, gvars.descripcion AS estado, inv_def.descrip AS tipodoc, caj_def.descrip AS formaPago, gvars.valor_memo AS siguientesEstados, gvars.descripcion AS nameEstado,IF(orders_100.dev_place='999999',cliente.direccion, (SELECT descrip FROM ctauximulti WHERE idrec=orders_100.dev_place)) as lugar_entrega, cliente.correo AS correocliente, worker.correo AS correoWorker FROM orders_100 INNER JOIN ctauxi AS worker ON worker.idauxi = orders_100.idworker INNER JOIN ctauxi AS cliente ON cliente.idauxi = orders_100.idcps INNER JOIN caj_def ON caj_def.cajclase = orders_100.cajclase INNER JOIN gvars ON gvars.valor_num = orders_100.estatus AND gvars.nombre = 'so_stat' INNER JOIN inv_def ON inv_def.invclase = orders_100.cli_notify AND inv_def.agrupa = 'VN' WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }   
        }

        function detalleOrdenVenta2($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT 
                    orders_100.trannum, 
                    orders_100.cli_notify, 
                    orders_100.cajclase, 
                    orders_100.fecha,
                    orders_100.fecvence,
                    orders_100.dev_direc,
                    orders_100.dev_contact,
                    orders_100.cli_email,
                    orders_100.dev_date,
                    orders_100.idcps,
                    orders_100.idworker,
                    orders_100.referencia,
                    orders_100.estatus,
                    orders_100.val_tot,
                    orders_100.notas,
                    orders_100.idcentro,
                    worker.descrip AS workername,
                    cliente.descrip AS clientename,
                    cliente.direccion AS direccion,
                    cliente.correo,
                    cliente.telefono,
                    cliente.nrc AS NRC,
                    cliente.nit AS NIT,
                    cliente.idtipo,
                    gvars.descripcion AS estado,
                    inv_def.descrip AS tipodoc,
                    caj_def.descrip AS formaPago,
                    gvars.valor_memo AS siguientesEstados,
                    IF(orders_100.dev_place = '999999',
                        cliente.direccion,
                        (SELECT 
                                descrip
                            FROM
                                ctauximulti
                            WHERE
                                idrec = orders_100.dev_place)) AS lugar_entrega
                FROM
                    orders_100
                        INNER JOIN
                    ctauxi AS worker ON worker.idauxi = orders_100.idworker
                        INNER JOIN
                    ctauxi AS cliente ON cliente.idauxi = orders_100.idcps
                        INNER JOIN
                    caj_def ON caj_def.cajclase = orders_100.cajclase
                        INNER JOIN
                    gvars ON gvars.valor_num = orders_100.estatus
                        AND gvars.nombre = 'so_stat'
                        INNER JOIN
                    inv_def ON inv_def.invclase = orders_100.cli_notify
                        AND inv_def.agrupa = 'VN'
                WHERE
                    trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                return $result;
            }   
        }
        
        function updateDatosOrden_Venta($trannum, $fechaingreso, $vendedor, $tipodocumento, $formapago, $fechaentrega, $lugarentrega, $referencia,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('fecha', $fechaingreso);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('cli_notify', $tipodocumento);
                $this->db_b->set('cajclase', $formapago);
                $this->db_b->set('dev_date', $fechaentrega);
                $this->db_b->set('dev_direc', $lugarentrega);
                $this->db_b->set('referencia', $referencia);    
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
		
        function getOrdenDetails($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.idrec, orders_100k.idproducto, orders_100k.trannum, orders_100k.itemline, orders_100k.notas, orders_100k.cantidad, orders_100k.precioneto,CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', invproducts.modelo, '</strong>', ' MARCA: ', '<strong>', invproducts.marca, '</strong>') AS descripcion, invproducts.um, invproducts.imagen FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE  orders_100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }
		
        function getCantLotes($search){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = 1) AS ExistenciasLocales, (SELECT SUM(inv_stock2.cantidad) FROM inv_stock AS inv_stock2 WHERE invproducts.idproducto = inv_stock2.idproducto) AS ExistenciasTotales, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa, IFNULL(invproducts.costounitario, 0) as costounitario, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado FROM invproducts WHERE invproducts.estado = 1 AND invproducts.idproducto = '$search' OR invproducts.modelo = '$search'  OR invproducts.barcode = '$search' GROUP BY invproducts.idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->num_rows();
                return $resultado;
            }
        }
		
        function getLotesProductosSearchAll($search){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.tipo, (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = 1) AS ExistenciasLocales, (SELECT SUM(inv_stock2.cantidad) FROM inv_stock AS inv_stock2 WHERE invproducts.idproducto = inv_stock2.idproducto) AS ExistenciasTotales, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa, IFNULL(invproducts.costounitario, 0) as costounitario, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado FROM invproducts WHERE invproducts.estado = 1 AND invproducts.idproducto = '$search' OR invproducts.modelo = '$search' OR invproducts.barcode = '$search' GROUP BY invproducts.idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function createOrderProduct($trannum, $cantidad, $precio, $idproducto, $descrip, $um, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $consulta1 = "SELECT lines100k FROM orders_100 WHERE trannum = '$trannum'";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->row_array();
                $line = $resultado1['lines100k'];
                $line =$line+1;
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $line);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('orders_100k');
                if($query==1){
                    $SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $trannum";
                    $SQLDQuery = $this->db_b->query($SQLDatos);
                    $SQLResult = $SQLDQuery->row_array();
                    $this->db_b->set('lines100k', $line);
                    $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->where('trannum', $trannum);
                    $query2 = $this->db_b->update('orders_100');
                }
                return $query;
            }
        }
        
		function createOrderProducts($trannum, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $codes = explode(',', $productos);
                $total = count($codes);
                
                for($i=0; $i<$total; $i++){
                    $consulta = "SELECT lines100k FROM orders_100 WHERE trannum = $trannum";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $itemLine = $resultado['lines100k'] + 1;
                    }else{
                        $itemLine = 1;
                    }
                    
                    $consulta = "SELECT * FROM orders_100k WHERE idproducto = $codes[$i] AND trannum = $trannum";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() == 0){
                     
                        $consulta = "SELECT * FROM invproducts WHERE idproducto = $codes[$i]";
                        $query = $this->db_b->query($consulta);
                        $datos = $query->row_array();

                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('itemline', $itemLine);
                        $this->db_b->set('idproducto', $codes[$i]);
                        $this->db_b->set('descrip', $datos['descrip']);
                        $this->db_b->set('cantidad', 0);
                        $this->db_b->set('um', $datos['um']);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('precioneto', $datos['precioventa']);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $query = $this->db_b->insert('orders_100k');

                        if($query==1){
                            $this->db_b->set('lines100k', $itemLine);
                            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                            $this->db_b->set('modifica', $fecha_actual);
                            $this->db_b->where('trannum', $trannum);
                            $query2 = $this->db_b->update('orders_100');
                        }
                    }else{
                    }
                }
                return $query;
            }
        }
        
        function updateCantidadorders_100k($idrec, $cantidad, $precioneto, $trannum, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');
                
                $SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $trannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query2 = $this->db_b->update('orders_100');
                return $query;
            }
        }
        
        function deleteProductoTemporal($idrec, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "DELETE FROM orders_100k WHERE trannum = $trannum AND idrec = $idrec";
                $query = $this->db_b->query($consulta);
                
                $SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $trannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query2 = $this->db_b->update('orders_100');
                return $query;
            }
        }
        
        function cambiarEstado($trannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
            }
        }
        
        function uploadProductosText($trannum, $lista, $tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                switch($tipo){
                    case "0":
                        $eval = "idproducto";
                        break;
                    case "1":
                        $eval = "modelo";
                        break;
                    case "2":
                        $eval = "xpos";
                        break;
                    case "3":
                        $eval = "barcode";
                        break;
                    default:
                        $eval="";
                        break;
                }
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $order   = array("\r\n", "\n", "\r");
                $replace = ',';

                // Procesa primero \r\n así no es convertido dos veces.
                $newstr = str_replace($order, $replace, $lista);
                
                $productos = explode(',', $newstr);
                $total = count($productos);
                $num=0;
                $id="";
                $cant="";
                $precio="";
                for($i=0; $i<$total; $i++){
                    if($num==2){
                        $precio = trim($productos[$i]);
                        
                        $consulta = "SELECT lines100k FROM orders_100 WHERE trannum = $trannum";
                        $query = $this->db_b->query($consulta);

                        if($query->num_rows() > 0){
                            $resultado = $query->row_array();
                            $itemLine = $resultado['lines100k'] + 1;
                        }else{
                            $itemLine = 1;
                        }
                        
                        $consulta = "SELECT idproducto FROM invproducts WHERE $eval = '$id'";
                        $query = $this->db_b->query($consulta);
                        $datos = $query->row_array();
                        $idproduct=$datos['idproducto'];
                        
                        $consulta = "SELECT * FROM orders_100k WHERE idproducto = $idproduct AND trannum = $trannum";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() == 0){
                     
                            $consulta = "SELECT * FROM invproducts WHERE idproducto = $idproduct";
                            $query = $this->db_b->query($consulta);
                            $datos = $query->row_array();

                            $this->db_b->set('idrec', 0);
                            $this->db_b->set('trannum', $trannum);
                            $this->db_b->set('idproducto', $idproduct);
                            $this->db_b->set('descrip', $datos['descrip']);
                            $this->db_b->set('itemline', $itemLine);
                            $this->db_b->set('cantidad', $cant);
                            $this->db_b->set('um', $datos['um']);
                            $this->db_b->set('uniconv', 1);
                            $this->db_b->set('precioneto', $precio);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $query = $this->db_b->insert('orders_100k');
                            
                            if($query==1){
                                $this->db_b->set('lines100k', $itemLine);
                                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                $this->db_b->where('trannum', $trannum);
                                $query2 = $this->db_b->update('orders_100');
                            }
                            $id=0;
                            $cant=0;
                            $precio=0;
                            $num=0;
                        }else{
                        }
                        
                    }else{
                        if($num==0){
                            $id = trim($productos[$i]);  
                        }
                        if($num==1){
                            $cant = trim($productos[$i]);    
                        }
                        if($num==2){
                            $precio = trim($productos[$i]);
                        }
                        $num++;
                    }
                   
                }
                $SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $trannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query2 = $this->db_b->update('orders_100');
                return $query;
             }
            
        }
        
        function getOrdenesPreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100.estatus, gvars.descripcion as estado, orders_100.trannum, DATE_FORMAT(orders_100.fecha, '%Y/%m/%d') AS fecha, DATE_FORMAT(orders_100.fecact, '%Y/%m/%d') AS fecact, ctauxi.descrip AS workername, clients.descrip as clientName, orders_100.val_tot, SUM(orders_100.val_pro + orders_100.val_envio + orders_100.val_otros) AS val_total FROM orders_100 INNER JOIN ctauxi ON orders_100.idworker = ctauxi.idauxi INNER JOIN ctauxi as clients ON orders_100.idcps = clients.idauxi INNER JOIN gvars ON orders_100.estatus = gvars.valor_num AND  nombre LIKE 'so_stat' WHERE agrupa = 'VN' AND orders_100.estatus=4 GROUP BY orders_100.trannum ORDER BY orders_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function verifica_Orden($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT COUNT(trannum) as cant FROM orders_100k WHERE trannum=$trannum AND( cantidad=0 OR precioneto=0)";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }        
        
        function ventas_diarias($empleado, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro,
                                tran_100.idclase,
                                tran_100.numero,
                                tran_100.fecha,
                                ctauxi.descrip AS cliente,
                                SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS saldo,
                                inv_def.invclase,
                                inv_def.descrip AS tipoDoc
                            FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                ctauxi ON ctauxi.idauxi = tran_100.idcps
                            WHERE
                                idworker = '$empleado'
                                    AND fecha BETWEEN '$fechai' AND '$fechaf'
                            GROUP BY tran_100.trannum ORDER BY tran_100.fecha ASC ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function abonos_diarios($empleado, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.numero,
                                tran_100c.descrip as referencia,
                                tran_100.fecha,
                                ctauxi.descrip AS cliente,
                                tran_100c.valor AS saldo
                            FROM
                                tran_100
                                    INNER JOIN
                                ctauxi ON ctauxi.idauxi = tran_100.idcps
                                    INNER JOIN
                                tran_100c ON tran_100c.trannum = tran_100.trannum
                            WHERE
                                tran_100.idworker = '$empleado'
                                    AND tran_100c.fecha BETWEEN '$fechai' AND '$fechaf'
                            GROUP BY tran_100c.idrec
                            ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function tipos_doc($empleado, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                inv_def.invclase,
                                inv_def.descrip AS tipoDoc
                            FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                            WHERE
                                idworker = $empleado
                                    AND fecha BETWEEN '$fechai' AND '$fechaf'
                            GROUP BY inv_def.invclase
                            ORDER BY inv_def.invclase ASC ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function tipos_doc_ventas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase,tran_100.serie
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}

        function tipos_doc_ventas_gt($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function tipoDocumentosVentas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                GROUP BY inv_def.invclase
                ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
		}
		
		function tipos_doc_ventas_facturas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase,tran_100.serie
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function tipos_doc_ventas_cortez($agrupa, $idcentro, $idcaja, $fechaactual){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha = '$fechaactual' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase,tran_100.serie
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}

        function getNumeroZCorteMensual($idcentro, $idcaja, $idanio, $idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT a.numz, DATE_FORMAT(a.fecha, '%d') AS dia FROM tran_100 a INNER JOIN inv_def b ON a.idclase = b.invclase 
                        WHERE b.agrupa = 'VN' AND a.idcentro = $idcentro AND a.idcaja = $idcaja AND (DATE_FORMAT(a.fecha, '%Y%m') = '".$idanio."".$idmes."') AND ( a.estatus = 1 OR a.estatus = 9 ) AND a.serie != '' AND a.numero != 0 
                        GROUP BY a.numz ORDER BY a.numz ASC";
                $Query = $this->db_b->query($SQL);
                $resultado = $Query->result();
                return $resultado;
            }
        }

        function getDocumentosVentasCorteZMensual($idcentro, $idcaja, $numz){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT a.trannum, b.exento FROM tran_100 a INNER JOIN inv_def b ON a.idclase = b.invclase 
                        WHERE b.agrupa = 'VN' AND a.idcentro = $idcentro AND a.idcaja = $idcaja AND a.numz = $numz AND ( a.estatus = 1 OR a.estatus = 9 ) AND a.serie != '' AND a.numero != 0 
                        ORDER BY a.trannum ASC";
                $Query = $this->db_b->query($SQL);
                $resultado = $Query->result();
                return $resultado;
            }
        }
		
		function tipos_doc_ventas_cortez2($agrupa, $idcentro, $idcaja, $fechaactual, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, inv_def.inopera, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.numz = '$numero_z' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase,tran_100.serie
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
        function tipos_doc_ventas_cortez_mensual($idcentro, $idcaja, $idanio, $idmes){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat( inv_def.descrip, ' - ', tran_100.serie ) AS descrip 
                            FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                            WHERE inv_def.agrupa = 'VN'  AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND ( tran_100.estatus = 1 OR tran_100.estatus = 9 ) AND tran_100.serie != '' AND tran_100.numero != 0 AND DATE_FORMAT(tran_100.fecha, '%Y%m') = '".$idanio."".$idmes."'
                            GROUP BY inv_def.invclase, tran_100.serie 
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getUltimaHoraCorte($idcentro, $idcaja, $fechaactual){
			$SQLUno = "SELECT fechahora FROM tran_100z WHERE idcentro = $idcentro AND idcaja = $idcaja AND fechahora > '$fechaactual 00:00:00' ORDER BY idrec DESC LIMIT 1;";
			$QueryU = $this->db_b->query($SQLUno);
			
			if($QueryU->num_rows()>0){
				$ResultU = $QueryU->row_array();
				$ultimaHora = $ResultU['fechahora'];
			}else{
				$ultimaHora = "";
			}
			
			return $ultimaHora;
		}
		
		function getTiposDocumentosVentasX($agrupa, $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
				AND tran_100.numx = '$numero_x' AND tran_100.numz = '$numero_z'
				GROUP BY inv_def.invclase,tran_100.serie
				ORDER BY inv_def.invclase ASC";
				
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
            }
		}
		
        function tipos_doc_ventas2($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_def.invclase, inv_def.descrip AS tipoDoc, tran_100.serie, concat(inv_def.descrip, ' - ',tran_100.serie) AS descrip FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0 
                            GROUP BY inv_def.invclase
                            ORDER BY inv_def.invclase ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getProductosDispo($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta1="SELECT idproducto FROM orders_100k where trannum=$trannum";
                $query1 = $this->db_b->query($consulta1);
                $result = $query1->result();
                
                $where=""; 
                foreach($result as $dat){
                    $idproducto = $dat->idproducto;
                    $where .=" invproducts.idproducto!= $idproducto AND ";
                }
                $where = substr($where, 0, -4);
                
                if($where!=""){
                    $consulta = "SELECT invproducts.idproducto, ifnull(invproducts.costounitario, 0) as costounitario , invproducts.descrip, invproducts.modelo, invproducts.marca, invcatalog.descrip AS linea FROM invproducts INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) ";
                }else{
                    $consulta = "SELECT invproducts.idproducto, ifnull(invproducts.costounitario, 0) as costounitario , invproducts.descrip, invproducts.modelo, invproducts.marca, invcatalog.descrip AS linea FROM invproducts INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado=1";
                }
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                if($query->num_rows()>0){
                    return $result;
                }else{
                    return false; 
                }
            }
        }
        
        function getDatosFacturaciones($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
        function getDatosFacturacionesDia($agrupa, $idcentro, $idcaja, $fechaini, $numx, $numz){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, DATE_FORMAT(t100.ingresa, '%h:%i:%s %p') AS hora, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.exento, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1, t100.referencia FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha = '$fechaini' AND t100.numx = '$numx' AND t100.numz = '$numz' AND (t100.estatus = 0 OR t100.estatus = 8) ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            } 
        }

        function getDatosFacturasVentasCajaDia($agrupa, $idcentro, $idcaja, $fechaini, $numx, $numz){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, DATE_FORMAT(t100.ingresa, '%h:%i:%s %p') AS hora, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.exento, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1, t100.referencia FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha = '$fechaini' AND t100.numx = '$numx' AND t100.numz = '$numz' ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            } 
        }
        
        function getDatosFacturasVentasCerradasDia($agrupa, $idcentro, $idcaja, $fechaini, $numx, $numz){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, DATE_FORMAT(t100.ingresa, '%h:%i:%s %p') AS hora, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.exento, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1, t100.referencia FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha = '$fechaini' AND t100.numx = '$numx' AND t100.numz = '$numz' AND (t100.estatus = 1 OR t100.estatus = 9) ORDER BY fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            } 
        }
		
		function getDatosPagosVentas($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cajclase, valor, vuelto FROM tran_100c WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
		}
		
        function getDatosPagosVentasPago($trannum, $cajclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100c.*, caj_def.descrip as formaPag FROM tran_100c INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  WHERE trannum = $trannum AND tran_100c.cajclase=$cajclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
		}
		
        function getDatosPagosVentasTrannum($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.descrip, tran_100c.notas AS notasPago FROM tran_100c INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
                
                return $resultado;
            } 
		}
		
		function getDatosFacturacionesCerradas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, t100.referencia, t100.origen, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente, IFNULL(ctaucli.descrip, '' ) AS namecliente, IFNULL(ctauemp.descrip, '' ) AS namevendedor, t100.valventan, t100.valtax1,invdef.inopera,TIME(t100.ingresa) AS hora, DATE_FORMAT(t100.ingresa, '%h:%i %p') AS hora2 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getDatosFacturacionesCerradasCalzaModas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, t100.referencia, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente, IFNULL(ctaucli.descrip, '' ) AS namecliente, IFNULL(ctauemp.descrip, '' ) AS namevendedor, t100.valventan, t100.valtax1,invdef.inopera,TIME(t100.ingresa) AS hora, DATE_FORMAT(t100.ingresa, '%h:%i %p') AS hora2 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
		function getDatosFacturacionesCerradasCorteZ($agrupa, $idcentro, $idcaja, $fechaactual){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha = '$fechaactual' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		/*
		function getDatosFacturacionesCerradasCorteZ2($agrupa, $idcentro, $idcaja, $fechaactual, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.numz = '$numero_z' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		*/
		function getDatosFacturacionesCerradasCorteZ2($agrupa, $idcentro, $idcaja, $fechaactual, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.caopera, invdef.exento, invdef.descrip AS tipodoc, t100.valventan, t100.valtax1, t100.valtax5, ctaucli.idtipo FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.numz = '$numero_z' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 ORDER BY t100.fecha, t100.serie, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
        function getDatosFacturacionesCerradasCorteZMensual($idcentro, $idcaja, $idanio, $idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT( t100.serie, t100.numero ) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, t100.valventan, t100.valtax1 
                            FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                            WHERE invdef.agrupa = 'VN' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND ( t100.estatus = 1 OR t100.estatus = 9 ) AND t100.serie != ''  AND t100.numero != 0 AND DATE_FORMAT(t100.fecha, '%Y%m') = '".$idanio.$idmes."'
                            ORDER BY t100.fecha, t100.serie, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getDataTran100kCorteZMensual($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $query = $this->db_b->query("SELECT a.precioneto, a.cantidad, a.tax1 AS tipotax FROM tran_100k a WHERE a.trannum = $trannum ORDER BY a.itemline ASC");
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getDatosFacturacionesCerradasCorteX($agrupa, $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 AND t100.numx = '$numero_x' AND t100.numz = '$numero_z' ORDER BY t100.fecha, t100.numero";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
            } 
        }
		
		function getDatosFacturacionesCerradasCorteX2($agrupa, $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.caopera, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 AND t100.numx = '$numero_x' AND t100.numz = '$numero_z' ORDER BY t100.fecha, t100.numero";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
            } 
        }
		
		function getTiposDocsFacturasCerradas($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                            SELECT 
                    caj_def.cajclase,
                    caj_def.descrip,
                    caj_def.xpos
                FROM
                    tran_100 AS t100
                        INNER JOIN
                        tran_100c ON tran_100c.trannum= t100.trannum
                        INNER JOIN
                    inv_def AS invdef ON t100.idclase = invdef.invclase
                    INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase AND caj_def.agrupa=invdef.agrupa
                WHERE
                    invdef.agrupa = '$agrupa'
                        AND t100.idcentro = $idcentro
                        AND t100.idcaja = $idcaja
                        AND t100.fecha BETWEEN '$fechaini' AND '$fechafin'
                    AND (t100.estatus = 1 OR t100.estatus = 9)
                    AND t100.serie != ''
                    AND t100.numero != 0
                    GROUP BY tran_100c.cajclase
                    ";
                $query = $this->db_b->query($consulta);
                
                    $resultado = $query->result();
                
                return $resultado;
            } 
        }
	    
        function getTiposDocsFacturasCerradasCorteZ($agrupa, $idcentro, $idcaja, $fechaactual){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                    caj_def.cajclase,
                    caj_def.descrip
                FROM
                    tran_100 AS t100
                        INNER JOIN
                        tran_100c ON tran_100c.trannum= t100.trannum
                        INNER JOIN
                    inv_def AS invdef ON t100.idclase = invdef.invclase
                    INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase AND caj_def.agrupa=invdef.agrupa
                WHERE
                    invdef.agrupa = '$agrupa'
                        #AND invdef.caopera = 1
                        AND t100.idcentro = $idcentro
                        AND t100.idcaja = $idcaja
                        AND t100.fecha = '$fechaactual'
                    AND (t100.estatus = 1 OR t100.estatus = 9)
                    AND t100.serie != ''
                    AND t100.numero != 0
                    GROUP BY tran_100c.cajclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
		}
		
		function getTiposDocsFacturasCerradasCorteZ2($agrupa, $idcentro, $idcaja, $fechaactual, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip FROM tran_100 AS t100
                INNER JOIN tran_100c ON tran_100c.trannum= t100.trannum
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase AND caj_def.agrupa=invdef.agrupa
                WHERE invdef.agrupa = '$agrupa'
                    AND invdef.caopera = 1
                    AND t100.idcentro = $idcentro
                    AND t100.idcaja = $idcaja
                    AND t100.numz = '$numero_z'
                    AND (t100.estatus = 1 OR t100.estatus = 9)
                    AND t100.serie != ''
                    AND t100.numero != 0
                    GROUP BY tran_100c.cajclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
		}
		
        function getTiposDocsFacturasCerradasCorteZ2Credito($agrupa, $idcentro, $idcaja, $fechaactual, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN caj_def ON caj_def.cajclase=t100.numy AND caj_def.agrupa=invdef.agrupa
                WHERE invdef.agrupa = '$agrupa'
                    AND invdef.caopera = 1
                    AND t100.idcentro = $idcentro
                    AND t100.idcaja = $idcaja
                    AND t100.numz = '$numero_z'
                    AND (t100.estatus = 1 OR t100.estatus = 9)
                    AND t100.serie != ''
                    AND t100.numero != 0
                    AND caj_def.creditchk = 1 
                    GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
		}
		
		function getTiposDocsFacturasCerradasCorteX($agrupa, $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT caj_def.cajclase, caj_def.descrip FROM tran_100 AS t100
				INNER JOIN tran_100c ON tran_100c.trannum= t100.trannum
				INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
				INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase AND caj_def.agrupa=invdef.agrupa
				WHERE invdef.agrupa = '$agrupa'
					AND invdef.caopera = 1
					AND t100.idcentro = $idcentro
					AND t100.idcaja = $idcaja
					AND (t100.estatus = 1 OR t100.estatus = 9)
					AND t100.serie != ''
					AND t100.numero != 0
					AND t100.numx = '$numero_x'
					AND t100.numz = '$numero_z'
				GROUP BY tran_100c.cajclase";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
            } 
		}
		
        function getTiposDocsFacturasCerradasCorteXCredito($agrupa, $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT caj_def.cajclase, caj_def.descrip FROM tran_100 AS t100
				INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
				INNER JOIN caj_def ON caj_def.cajclase=t100.numy AND caj_def.agrupa=invdef.agrupa
				WHERE invdef.agrupa = '$agrupa'
					AND invdef.caopera = 1
					AND t100.idcentro = $idcentro
					AND t100.idcaja = $idcaja
					AND (t100.estatus = 1 OR t100.estatus = 9)
					AND t100.serie != ''
					AND t100.numero != 0
					AND t100.numx = '$numero_x'
					AND t100.numz = '$numero_z'
                    AND caj_def.creditchk = 1 
				GROUP BY caj_def.cajclase";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
            } 
		}
		
		function getDatosFacturacionesPendientesPrint($agrupa, $idcentro, $idcaja, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum AND tran_100p.estatus = $estado WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja ORDER BY trannum DESC";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
                return $resultado;
            } 
		}
		
		function getDatosFacturacionesPendientesPrintByTipo($agrupa, $idcentro, $idcaja, $tipodoc, $fechaini, $fechafin, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($tipodoc == 0){
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum AND tran_100p.estatus = 0 WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja ORDER BY trannum DESC";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else if($tipodoc == 999999){
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY trannum DESC";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else{
					//$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idclase = $tipodoc AND t100.fecha >= '$fecmin' ORDER BY trannum DESC";
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.idclase = $tipodoc AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY trannum DESC"; 
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}
            }
		}
		
		function getPendientesPrintByTipo($agrupa, $idcentro, $idcaja, $tipodoc, $fechaini, $fechafin, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($tipodoc == 0){
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum AND tran_100p.estatus = 0 WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja ORDER BY trannum DESC";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else if($tipodoc == 999999){
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY trannum DESC";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else{
					//$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idclase = $tipodoc AND t100.fecha >= '$fecmin' ORDER BY trannum DESC";
					$consulta = "SELECT t100.trannum, t100.fecha, tran_100p.estatus, tran_100p.prncount, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.idclase = $tipodoc AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY trannum DESC";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}
            }
		}
		
		function getDocumentosFacturacionesPendientesPrint($agrupa, $idcentro, $idcaja, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT DISTINCT invdef.invclase, invdef.descrip AS tipodoc FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja ORDER BY t100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getDetalleFacturas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100k.itemline, t100k.idproducto, inv.descrip, location.descrip AS ubicacion, batch.descrip AS lote, t100k.cantidad, t100k.um, t100k.precioneto, t100k.tax1 FROM tran_100k AS t100k INNER JOIN invproducts AS inv ON t100k.idproducto = inv.idproducto LEFT JOIN invlocations AS location ON t100k.idbin = location.idbin LEFT JOIN inv_batch AS batch ON t100k.idbatch = batch.idbatch WHERE t100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.estado = 1  AND invproducts.$search = '$dato' HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1  AND invpromulti.descrip = '$dato' HAVING cantidad > 0";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1 HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else if($prosearch == 2){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.modelo LIKE '%$dato%' AND invproducts.estado = 1 HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else if($prosearch == 4){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.xpos LIKE '%$dato%' AND invproducts.estado = 1 HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "SELECT invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = $idcentro AND tran_100k.idproducto = invproducts.idproducto) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.$search = '$dato' AND invproducts.estado = 1 HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
		
		function getSearchProductoGrupo($nGrupo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idrec');
                $this->db_b->from('invpromulti');
                $this->db_b->where('idgvar', 99);
                $this->db_b->where('grupo', $nGrupo);
                $this->db_b->where('estatus', 1);
                $query = $this->db_b->get();

                if($query->num_rows() > 0){
                    return 1;
                } else return 0;
            }
        }

        function getPrecioGrupo($nGrupo, $nCantidad) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('precioventa');
                $this->db_b->from('invpromulti');
                $this->db_b->where('idgvar', 99);
                $this->db_b->where('grupo', $nGrupo);
                $this->db_b->where('estatus', 1);
                $this->db_b->where('lowrange <=', $nCantidad);
                $this->db_b->where('highrange >=', $nCantidad);
                $query = $this->db_b->get();

                if($query->num_rows() > 0){
                    return floatval($query->row()->precioventa);
                } else return 0;
            }
        }

        function getProductosGrupo($nMarca, $nPresenta, $idcentro, $trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('invproducts.idcatalogo, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto');
                $this->db_b->select('invproducts.descrip, invproducts.marca, invproducts.presenta, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode');
                $this->db_b->select('invproducts.precioventa, invproducts.notas, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT(0) AS despachado');
                $this->db_b->select('(SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = '.$idcentro.' AND tran_100k.idproducto = invproducts.idproducto) AS cantidad');
                $this->db_b->select('(SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = '.$trannum.'), 1, 0)) AS existe');
                $this->db_b->from('invproducts');
                $this->db_b->join('inv_batch', 'inv_batch.idproducto = invproducts.idproducto');
                $this->db_b->join('invcatalog', 'invproducts.idcatalogo = invcatalog.idcatalogo');
                $this->db_b->join('invlocations', 'invlocations.idcentro = '.$idcentro);
                $this->db_b->where('invproducts.estado', 1);
                $this->db_b->where('invproducts.marca', $nMarca);
                $this->db_b->where('invproducts.presenta', $nPresenta);
                $this->db_b->group_by('invproducts.idproducto');
                $this->db_b->having('cantidad > 0');
                $query = $this->db_b->get();

                if($query->num_rows() > 0){
                    return $query->result();
                } else return false;
            }
        }
		
		function getDatosProductoSearchFacturaz($prosearch, $dato, $idcentro, $trannum, $sMateriaP = 0, $inopera = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }

                $fProductos = ($sMateriaP == 1) ? 'AND (invproducts.tipo = 1 OR invproducts.tipo = 2)' : 'AND (invproducts.tipo = 1)';

                $cSaldo = ($inopera == 1) ? 999 : 'SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idcentro = '.$idcentro.' AND tran_100k.idproducto = invproducts.idproducto';
                
                if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, ($cSaldo) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.estado = 1 $fProductos AND invproducts.$search = '$dato' HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, ($cSaldo) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1 $fProductos  AND invpromulti.descrip = '$dato' HAVING cantidad > 0";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, ($cSaldo) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1 $fProductos HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else if($prosearch == 2){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, ($cSaldo) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.modelo LIKE '$dato%' AND invproducts.estado = 1 $fProductos HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, ($cSaldo) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE invproducts.$search = '$dato' AND invproducts.estado = 1 $fProductos HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
		
        function getDatosServicioSearchFacturaz($prosearch, $dato, $idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum ), 1, 0)) AS existe 
                    FROM invproducts
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    WHERE invproducts.$search = '$dato' AND invproducts.estado = 1 AND invproducts.tipo = 4";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                            invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                            (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch,
                            (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum ), 1, 0)) AS existe 
                        FROM invproducts
                        INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                        INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        WHERE invproducts.estado = 1  AND invpromulti.descrip = '$dato' AND invproducts.tipo = 4";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum ), 1, 0)) AS existe 
                    FROM invproducts
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1 AND invproducts.tipo = 4";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else if($prosearch == 2){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum ), 1, 0)) AS existe 
                    FROM invproducts
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    WHERE invproducts.modelo LIKE '$dato%' AND invproducts.estado = 1 AND invproducts.tipo = 4";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "SELECT invproducts.idcatalogo, invproducts.xpos, invproducts.presenta, invproducts.upp, invproducts.tipo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum ), 1, 0)) AS existe 
                    FROM invproducts
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    WHERE invproducts.$search = '$dato' AND invproducts.estado = 1 AND invproducts.tipo = 4";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }

        function getDatosProductoSearchFast($prosearch, $dato, $idcentro, $trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.barcode, invproducts.precioventa,
					    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) AS cantidad,
					    inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT(0) AS nItems, 
					    (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
					FROM invproducts INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
					WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'
                    HAVING (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) >= 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.barcode, invproducts.precioventa,
						    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) AS cantidad,
						    inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT(0) AS nItems, 
						    (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
						FROM invproducts INNER JOIN  invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
						WHERE invproducts.estado = 1 AND invpromulti.descrip = '$dato'
                        HAVING (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) >= 1";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            $cDato  = substr($dato, 0, 7).'*';
                            $cValor = number_format(substr($dato, 7, 2).'.'.substr($dato, 9, 2), 2, '.', '');

                            $consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.barcode, invproducts.precioventa,
                                (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) AS cantidad,
                                inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT($cValor) AS nItems, 
                                (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                            FROM invproducts INNER JOIN  invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                            INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                            INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                            LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
                            WHERE invproducts.estado = 1 AND invpromulti.descrip = '$cDato'
                            HAVING (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) >= 1";
                            $query = $this->db_b->query($consulta);
                            if($query->num_rows() > 0){
                                $resultado = $query->result();
                                return $resultado;
                            }else{
                                return 0;
                            }
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.barcode, invproducts.precioventa,
					    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) AS cantidad,
					    inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT(0) AS nItems,
					    (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
					FROM invproducts INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
					WHERE invproducts.estado = 1 AND invproducts.descrip LIKE '%$dato%'
                    HAVING (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) >= 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.barcode, invproducts.precioventa,
					    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) AS cantidad,
					    inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, CONCAT(0) AS nItems,
					    (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
					FROM invproducts INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
					WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'
                    HAVING (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE invproducts.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro) >= 1";

                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }

        function getDatosSearchFastService($idproducto, $idcentro, $trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.idrec, tran_100k.cantidad AS ingresado, invproducts.tipotax, invproducts.idproducto, invproducts.descrip, invproducts.um, invproducts.precioventa,
                (9999) AS cantidad, invproducts.costounitario, invlocations.idbin, (9999) AS idbatch, invproducts.barcode,
                (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                FROM invproducts  INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                LEFT JOIN tran_100k ON invproducts.idproducto = tran_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum
                WHERE invproducts.estado = 1 AND invproducts.idproducto = '$idproducto'";

                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return 0;
                }
            }
        }
		
		function getDatosProductoSearchPrueba($prosearch, $dato, $idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, IFNULL(inv_stock.idbin, (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1)) AS idbin, IFNULL(inv_stock.idbatch, 9999) AS idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1  AND (invproducts.$search = '$dato' OR invpromulti.descrip = '$dato')";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, IFNULL(inv_stock.idbin, (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1)) AS idbin, IFNULL(inv_stock.idbatch, 9999) AS idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, IFNULL(inv_stock.idbin, (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1)) AS idbin, IFNULL(inv_stock.idbatch, 9999) AS idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.$search = '$dato' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
        
        function insertarFacturacion($fecha, $notas, $idclase, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, $referencia, $numCoti = 0, $origen = ''){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$SQLNum = "SELECT numx, numz, cajafecha FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				$cajafecha = $infoNum['cajafecha'];
				
				if($fecha == "" || $fecha == "0000-00-00"){
					$fecha = $cajafecha;
                }
                
                if($referencia != ""){
                    $referencia = str_pad($idcentro, 2, '0', STR_PAD_LEFT)."-".$referencia;
                }
				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('numx', $numero_x);
                $this->db_b->set('numz', $numero_z);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('origen', $origen);
                $this->db_b->set('tranref', $numCoti);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
        
        function insertarFacturacionNC($fecha, $notas, $idclase, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, $referencia, $tranref, $devDate, $devSerie, $devNumero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$SQLNum = "SELECT numx, numz, cajafecha FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				$cajafecha = $infoNum['cajafecha'];
				
				if($fecha == "" || $fecha == "0000-00-00"){
					$fecha = $cajafecha;
                }
                
                if($referencia != ""){
                    $referencia = str_pad($idcentro, 2, '0', STR_PAD_LEFT)."-".$referencia;
                }
				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('numx', $numero_x);
                $this->db_b->set('numz', $numero_z);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('tranref', $tranref);
                $this->db_b->set('notas', ($devDate == '') ? '' : '1|'.$devDate.'|'.$devSerie.$devNumero);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
		
		function setAnulacionVenta($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLItems = "SELECT * FROM tran_100k WHERE trannum = $trannum";
                $Query = $this->db_b->query($SQLItems);
                $SQLResult = $Query->result();
                
                $findCuota = 0;
                foreach($SQLResult as $info){
                    if($info->invcontrol != 0){
                        $findCuota = 1;
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', 0);
                        $this->db_b->set('idclase', $info->idclase);
                        $this->db_b->set('itemline', $info->itemline);
                        $this->db_b->set('idcentro', $info->idcentro);
                        $this->db_b->set('invcontrol', $info->invcontrol);
                        $this->db_b->set('idproducto', $info->idproducto);
                        $this->db_b->set('idbatch', 0);
                        $this->db_b->set('idbin', 0);
                        $this->db_b->set('barcode', 0);
                        $this->db_b->set('cantidad', 0);
                        $this->db_b->set('um', $info->um);
                        $this->db_b->set('uniconv', 0);
                        $this->db_b->set('idworker', 0);
                        $this->db_b->set('costounitario', 0);
                        $this->db_b->set('preciotran', $info->preciotran);
                        $this->db_b->set('descuento', 0);
                        $this->db_b->set('precioneto', $info->precioneto);
                        $this->db_b->set('tax1', $info->tax1);
                        $this->db_b->set('tax2', 0);
                        $this->db_b->set('tax3', 0);
                        $this->db_b->set('tax4', 0);
                        $this->db_b->set('tax5', 0);
                        $this->db_b->set('notas', $info->notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }
                }
                
                if($findCuota == 1){
                    $this->db_b->set('barcode', 9);
                }
                $this->db_b->set('cantidad', 0);
				$this->db_b->set('precioneto', 0);
				$this->db_b->set('costounitario', 0);
				$this->db_b->set('preciotran', 0);
				$this->db_b->set('descuento', 0);
				$this->db_b->set('tax1', 0);
				$this->db_b->set('tax2', 0);
				$this->db_b->set('tax3', 0);
				$this->db_b->set('tax4', 0);
				$this->db_b->set('tax5', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100k');
                
				$this->db_b->set('valor', 0);
				$this->db_b->set('vuelto', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100c');
				
                $this->db_b->set('valcosto', 0);
                $this->db_b->set('valventan', 0);
                $this->db_b->set('valtax1', 0);
                $this->db_b->set('valtax2', 0);
                $this->db_b->set('valtax3', 0);
                $this->db_b->set('valtax4', 0);
                $this->db_b->set('valtax5', 0);
                $this->db_b->set('valdh', 0);
                $this->db_b->set('estatus', 9);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
				return $query;
            }
		}
		
		function setanulacionVentaMotivo($trannum, $motivo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLItems = "SELECT * FROM tran_100k WHERE trannum = $trannum";
                $Query = $this->db_b->query($SQLItems);
                $SQLResult = $Query->result();
                
                $findCuota = 0;
                foreach($SQLResult as $info){
                    if($info->invcontrol != 0){
                        $findCuota = 1;
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', 0);
                        $this->db_b->set('idclase', $info->idclase);
                        $this->db_b->set('itemline', $info->itemline);
                        $this->db_b->set('idcentro', $info->idcentro);
                        $this->db_b->set('invcontrol', $info->invcontrol);
                        $this->db_b->set('idproducto', $info->idproducto);
                        $this->db_b->set('idbatch', 0);
                        $this->db_b->set('idbin', 0);
                        $this->db_b->set('barcode', 0);
                        $this->db_b->set('cantidad', 0);
                        $this->db_b->set('um', $info->um);
                        $this->db_b->set('uniconv', 0);
                        $this->db_b->set('idworker', 0);
                        $this->db_b->set('costounitario', 0);
                        $this->db_b->set('preciotran', $info->preciotran);
                        $this->db_b->set('descuento', 0);
                        $this->db_b->set('precioneto', $info->precioneto);
                        $this->db_b->set('tax1', $info->tax1);
                        $this->db_b->set('tax2', 0);
                        $this->db_b->set('tax3', 0);
                        $this->db_b->set('tax4', 0);
                        $this->db_b->set('tax5', 0);
                        $this->db_b->set('notas', $info->notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }
                }
                
                if($findCuota == 1){
                    $this->db_b->set('barcode', 9);
                }
                
                $this->db_b->set('cantidad', 0);
				$this->db_b->set('precioneto', 0);
				$this->db_b->set('costounitario', 0);
				$this->db_b->set('preciotran', 0);
				$this->db_b->set('descuento', 0);
				$this->db_b->set('tax1', 0);
				$this->db_b->set('tax2', 0);
				$this->db_b->set('tax3', 0);
				$this->db_b->set('tax4', 0);
				$this->db_b->set('tax5', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100k');
                
				$this->db_b->set('valor', 0);
				$this->db_b->set('vuelto', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100c');
				
                $this->db_b->set('valcosto', 0);
                $this->db_b->set('valventan', 0);
                $this->db_b->set('valtax1', 0);
                $this->db_b->set('valtax2', 0);
                $this->db_b->set('valtax3', 0);
                $this->db_b->set('valtax4', 0);
                $this->db_b->set('valtax5', 0);
                $this->db_b->set('valdh', 0);
                $this->db_b->set('estatus', 9);
                $this->db_b->set('notas', $motivo);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
				return $query;
            }
		}
		
		function setRenumeracionDocumento($trannum, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('numero', $numero);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
				return $query;
            }
		}
        
		function updateCCEstatus($idtrannum, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $this->db_b->set('ccestatus', $estado);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                
				return $query;
            }
		}

		function insertarRegistroElectronico($trannum, $claveNumerica){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				                
                $this->db_b->set('trannum', $trannum);
				$this->db_b->set('tipo', 4);
				$this->db_b->set('clave', $claveNumerica);
				$this->db_b->set('fecha_envio', $date->format('Y-m-d H:i:s'));
				$this->db_b->set('irespuesta', 1);
				$this->db_b->set('doc_status', 202);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100e');

				return $query;
            }
		}
		
        function getDatosFactura($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->db_b->field_exists('dte_giro', 'ctauxi')){
                    $consulta = "SELECT tran_100.*, ctauxi.idauxi AS idcliente, ctauxi.correo, ctauxi.idtipo, ctauxi.dui as dui, ctauxi.dte_giro as cli_giroDte, inv_def.iddte, 
                    IFNULL(ctauxi.descrip, 'Nuevo Cliente') AS nameCliente, IFNULL(ctauxi.telefono, '') AS telefono, IFNULL(ctauxi.dias, '0') AS dias, IFNULL(ctauxi.notas, '') AS notasPagoCliente,
                    ctauxi2.idauxi AS idvendedor, ctauxi2.descrip AS nameVendedor, ctauxi2.nrc AS duivendedor, ctauxi.nrc, ctauxi.direccion, ctauxi.correo, ctauxi.grupo, IFNULL(ctauximulti.notas, '') AS direccion_c,
                    IFNULL(ctauximulti.otro, '') AS nombre_c, IFNULL(ctauximulti.idzip, ctauxi.idzip) AS idzip_c, IFNULL(ctauximulti.correo, '') AS correo_c,
                    ctauxi.nit, ctauxi.giro,ctauxi.idzip, inv_def.exento, inv_def.askregiva, inv_def.inopera, inv_def.descrip, gusers.descrip as facturadopor, invsites.notas AS direccioncentro, invsites.descrip AS nameSucursal, invsites.idzip AS idzip_sucursal
                    FROM tran_100 
                    INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                    INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                    LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi 
                    LEFT JOIN ctauxi AS ctauxi2 ON tran_100.idworker = ctauxi2.idauxi 
                    LEFT JOIN gusers ON tran_100.whodidit = gusers.iduser
                    LEFT JOIN ctauximulti ON ctauximulti.idrec = tran_100.idcentrod AND ctauximulti.idgvar = 2 AND ctauximulti.idauxi = tran_100.idcps
                    WHERE trannum = $trannum";
                } else {
                    $consulta = "SELECT tran_100.*, ctauxi.idauxi AS idcliente, ctauxi.correo, ctauxi.idtipo, ctauxi.dui as dui, inv_def.iddte, 
                    IFNULL(ctauxi.descrip, 'Nuevo Cliente') AS nameCliente, IFNULL(ctauxi.telefono, '') AS telefono, IFNULL(ctauxi.dias, '0') AS dias, IFNULL(ctauxi.notas, '') AS notasPagoCliente,
                    ctauxi2.idauxi AS idvendedor, ctauxi2.descrip AS nameVendedor, ctauxi2.nrc AS duivendedor, ctauxi.nrc, ctauxi.direccion, ctauxi.correo, ctauxi.grupo, IFNULL(ctauximulti.notas, '') AS direccion_c,
                    IFNULL(ctauximulti.otro, '') AS nombre_c, IFNULL(ctauximulti.idzip, ctauxi.idzip) AS idzip_c, IFNULL(ctauximulti.correo, '') AS correo_c,
                    ctauxi.nit, ctauxi.giro,ctauxi.idzip, inv_def.exento, inv_def.askregiva, inv_def.inopera, inv_def.descrip, gusers.descrip as facturadopor, invsites.notas AS direccioncentro, invsites.descrip AS nameSucursal, invsites.idzip AS idzip_sucursal
                    FROM tran_100 
                    INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                    INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                    LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi 
                    LEFT JOIN ctauxi AS ctauxi2 ON tran_100.idworker = ctauxi2.idauxi 
                    LEFT JOIN gusers ON tran_100.whodidit = gusers.iduser
                    LEFT JOIN ctauximulti ON ctauximulti.idrec = tran_100.idcentrod AND ctauximulti.idgvar = 2 AND ctauximulti.idauxi = tran_100.idcps
                    WHERE trannum = $trannum";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDatosFacturacionJSON($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.*, ctauxi.idauxi AS idcliente, ctauxi.correo, ctauxi.idtipo, ctauxi.dui as dui,
                IFNULL(ctauxi.descrip, 'Nuevo Cliente') AS nameCliente, IFNULL(ctauxi.telefono, '') AS telefono, IFNULL(ctauxi.dias, '0') AS dias, 
                ctauxi2.idauxi AS idvendedor, ctauxi2.descrip AS nameVendedor, ctauxi2.nrc AS duivendedor, ctauxi.nrc, ctauxi.direccion, ctauxi.correo, ctauxi.grupo, 
                ctauxi.nit, ctauxi.giro,ctauxi.idzip, inv_def.exento, inv_def.askregiva, inv_def.descrip, gusers.descrip as facturadopor, invsites.notas AS direccioncentro 
                FROM tran_100 
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi 
                LEFT JOIN ctauxi AS ctauxi2 ON tran_100.idworker = ctauxi2.idauxi 
                LEFT JOIN gusers ON tran_100.whodidit = gusers.iduser 
                WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    return $query->row();
                } else return false;
            }
        }

        function getDatosNotaRemision($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.*, clientecentro.descrip AS nombrecentro, clientecentro.notas AS direccioncentro, 
                            inv_def.exento, inv_def.askregiva, inv_def.descrip, 
                            gusers.descrip as facturadopor,
                            (SELECT valor_memo FROM gvars WHERE nombre = 'g_empdatos' AND valor_num = 3) AS nrc,
                            (SELECT valor_memo FROM gvars WHERE nombre = 'g_empdatos' AND valor_num = 4) AS nit,
                            (SELECT valor_memo FROM gvars WHERE nombre = 'g_empdatos' AND valor_num = 5) AS giro
                FROM tran_100 
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro  
                INNER JOIN invsites clientecentro ON tran_100.idcentrod = clientecentro.idcentro  
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                LEFT JOIN gusers ON tran_100.whodidit = gusers.iduser 

                WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        #   PARA GRUPO C Y M  GET INFO CONTACTO ADICIONAL
        public function getDataCMulti($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else return $this->db_b->where("idrec", $ID)->get("ctauximulti")->row();
        }
        public function getDataDireccion($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else return $this->db_b->where("idzip", $ID)->get("gzips")->row();
        }
        #-
        
        function getDatosEncabezadoFactura($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                    tran_100.*,
                                    ctauxi.idauxi AS idcliente,
                                    ctauxi3.descrip AS vendeasin,
                                    IFNULL(ctauxi.descrip, 'Nuevo Cliente') AS nameCliente,
                                    IFNULL(ctauxi.telefono, '') AS telefono,
                                    IFNULL(ctauxi.dias, '0') AS dias,
                                    ctauxi.nrc,
                                    ctauxi.direccion,
                                    ctauxi.correo,
                                    ctauxi.nit,
                                    ctauxi.giro,
                                    ctauximulti.descrip as lugarEntrega
                                FROM
                                    tran_100
                                        LEFT JOIN
                                    ctauxi ON tran_100.idcps = ctauxi.idauxi
                                        LEFT JOIN
                                    ctauxi AS ctauxi3 ON ctauxi.idcps = ctauxi3.idauxi
                                        LEFT JOIN
									ctauximulti ON tran_100.idcps_branch = ctauximulti.idrec
                                WHERE
                                    trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getDetailPagosFactura($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100c.*, caj_def.descrip AS namePago FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getCantidadesCatalogo($idtrannum, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 1))) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND invproducts.estado = 1 AND inv_stock.cantidad > 0 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getCantidadesCatalogoServices($idtrannum, $tipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 1))) AS cantidad FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto WHERE invproducts.tipo = $tipo AND invproducts.estado = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
		function getPrecioPromocion($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
				$fechaactual = $fecha->format('Y-m-d H:i:s');
				
                $consulta = "SELECT precioventa FROM invpromulti WHERE idproducto = $idproducto AND idgvar = 3 AND (profecini <= '$fechaactual' AND profecfin >= '$fechaactual') AND estatus = 1";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['precioventa'] == "" || $result['precioventa'] == "0.000000" || $result['precioventa'] == null){
                        return false;
                    }else{
                        $precioventa = $result['precioventa'];
                        return $precioventa;
                    }
                }else{
                    return false;
                }
            }
		}
		
        function getUniconvPrecioPromocion($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
				$fechaactual = $fecha->format('Y-m-d H:i:s');
				
                $consulta = "SELECT uniconv FROM invpromulti WHERE idproducto = $idproducto AND idgvar = 3 AND (profecini <= '$fechaactual' AND profecfin >= '$fechaactual') AND estatus = 1";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['uniconv'] == "" || $result['uniconv'] == "0.000000" || $result['uniconv'] == null){
                        return 0;
                    }else{
                        $uniconv = $result['uniconv'];
                        return $uniconv;
                    }
                }else{
                    return 1;
                }
            }
		}
        
		function getInformacionRetencionDef(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT cajclase FROM caj_def WHERE xpos = '0.01' AND estatus = 1";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $informacion = 1;
                }else{
                    $informacion = 0;
                }
				
				return $informacion;
            }
		}
        
		function getVerificacionCff($idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT askregiva FROM inv_def WHERE invclase = $idclase";
                $SQLQuery = $this->db_b->query($consulta);
                
				$result = $SQLQuery->row_array();
				$askregiva = $result['askregiva'];
				
				return $askregiva;
            }
		}
        
		function updateRegistroContribuyenteCliente($trannum, $idcliente, $inputContribuyente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $this->db_b->set('idtipo', $inputContribuyente);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idcliente);
               	$this->db_b->update('ctauxi');
                
				$SQLDelete = "DELETE FROM tran_100c WHERE trannum = $trannum";
                $query = $this->db_b->query($SQLDelete);
				
				return $query;
            }
		}
        
		function updateAndInsertRetencion($idcliente, $trannum, $totalGravado, $inputContribuyente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $this->db_b->set('idtipo', $inputContribuyente);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idcliente);
                $query = $this->db_b->update('ctauxi');
                
				$consulta = "SELECT cajclase, xpos FROM caj_def WHERE xpos = '0.01' AND estatus = 1";
                $SQLQuery = $this->db_b->query($consulta);
                $informacion = $SQLQuery->row_array();
				
				$cajclase = $informacion['cajclase'];
				$valretencion = $informacion['xpos'];
				
				$SQLFactura = "SELECT idclase, fecha, idworker FROM tran_100 WHERE trannum = $trannum";
                $SQLFacturaQuery = $this->db_b->query($SQLFactura);
                $infoFactura = $SQLFacturaQuery->row_array();
				
				$idclase = $infoFactura['idclase'];
				$fechaVn = $infoFactura['fecha'];
				$idworker = $infoFactura['idworker'];
				$notas = 'Retención del 1%';
				
				$SQLDelete = "DELETE FROM tran_100c WHERE trannum = $trannum";
                $this->db_b->query($SQLDelete);
				
				$consulta = "SELECT itemline FROM tran_100c WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultadoitemLine = $query->row_array();
                    $itemLine = $resultadoitemLine['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
				
				$nuevoValor = $totalGravado * $valretencion;
				$nuevoValor = $nuevoValor * -1;
				
				$this->db_b->set('idrec', 0);
				$this->db_b->set('trannum', $trannum);
				$this->db_b->set('idclase', $idclase);
				$this->db_b->set('descrip', 'P_RT');
				$this->db_b->set('fecha', $fechaVn);
				$this->db_b->set('itemline', $itemLine);
				$this->db_b->set('cajclase', $cajclase);
				$this->db_b->set('idworker', $idworker);
				$this->db_b->set('valor', $nuevoValor);
				$this->db_b->set('vuelto', 0);
				$this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('tran_100c');
				
				return $query;
            }
		}
		
		function getPrecioInvPromulti($idproducto, $idgvar, $idcps){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT precioventa FROM invpromulti WHERE idgvar = $idgvar AND idcps = $idcps AND idproducto = $idproducto AND estatus = 1";
				$SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['precioventa'] == "" || $result['precioventa'] == "0.000000" || $result['precioventa'] == null){
                        return false;
                    }else{
                        $precioventa = $result['precioventa'];
                        return $precioventa;
                    }
                }else{
                    return false;
                }
			}
		}
		
		function getUniconvInvProMulti($idproducto, $idgvar, $idcps){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT uniconv FROM invpromulti WHERE idgvar = $idgvar AND idcps = $idcps AND idproducto = $idproducto AND estatus = 1";
				$SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['uniconv'] == "" || $result['uniconv'] == "0.000000" || $result['uniconv'] == null){
                        return false;
                    }else{
                        $uniconv = $result['uniconv'];
                        return $uniconv;
                    }
                }else{
                    return 1;
                }
			}
		}
		
		function getDescuentoFichaProducto($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT descuento FROM invproducts WHERE idproducto = $idproducto";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['descuento'] == "" || $result['descuento'] == "0.00" || $result['descuento'] == null){
                        return false;
                    }else{
						$descuento = number_format($result['descuento'])."%";
						
						$array[0] = array(
							"id" => "0%",
							"valor" => "0%"
						);
						
						$array[1] = array(
							"id" => $descuento,
							"valor" => $descuento
						);
						return $array;
                    }
                }else{
                    return false;
                }
			}
		}

		function getDescuentoFichaProductoVariable($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT descuento FROM invproducts WHERE idproducto = $idproducto";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    if($result['descuento'] == "" || $result['descuento'] == "0.00" || $result['descuento'] == null){
                        return false;
                    }else{
						$descuento = number_format($result['descuento']);
						
						$array[0] = "0";
						
						$array[1] = $descuento;
						return $array;
                    }
                }else{
                    return false;
                }
			}
		}

		function getDescuentoMaximoProducto($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT descuento FROM invproducts WHERE idproducto = $idproducto";
                $SQLQuery = $this->db_b->query($consulta);
                
				if($SQLQuery->num_rows() > 0){
                    $result = $SQLQuery->row_array();
                    $descuento = number_format($result['descuento']);
                    return $descuento;
                }else{
                    return false;
                }
			}
		}

		function getTipoProducto($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tipo FROM invproducts WHERE idproducto = $idproducto";
                $SQLQuery = $this->db_b->query($consulta);
                $result = $SQLQuery->row_array();
                $tipoProducto = $result['tipo'];
                
                return $tipoProducto;
			}
		}

		function getDescuentoMaximoProductosVariable($nameGvar){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQLineas = "SELECT valor_txt FROM gvars WHERE nombre = '$nameGvar'";
                $QueryLin = $this->db_b->query($SQLineas);
                if($QueryLin->num_rows() > 0){
                    $tipoBusqueda = $QueryLin->row_array();
                    if($tipoBusqueda['valor_txt'] == ""){
                        return 0;
                    }else{
                        $listDesc = explode(",", $tipoBusqueda['valor_txt']);
						$ultimoDes = count($listDesc) - 1;
						
                        $descuento = $listDesc[$ultimoDes];
                        
                        return $descuento;
                    }
                }else{
                    return 0;
                }
			}
		}
        
        function getDescuentosProductosByVariable($nameGvar){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_txt FROM gvars WHERE nombre = '$nameGvar'";
                $SQLQuery = $this->db_b->query($consulta);
                if($SQLQuery->num_rows() > 0){
                    $tipoBusqueda = $SQLQuery->row_array();
                    if($tipoBusqueda['valor_txt'] == ""){
                        return false;
                    }else{
                        $lista = explode(",", $tipoBusqueda['valor_txt']);
						$total = count($lista);
						$array = array();
						for($i=0; $i<$total; $i++){
							$array[$i] = array(
								"id" => $lista[$i],
								"valor" => $lista[$i]."%"
							);
						}
                        return $array;
                    }
                }else{
                    return false;
                }
                
            }
        }
        
        function getDescuentosProductos($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT notas FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $SQLQuery = $this->db_b->query($consulta);
                if($SQLQuery->num_rows() > 0){
                    $tipoBusqueda = $SQLQuery->row_array();
                    if($tipoBusqueda['notas'] == ""){
                        return false;
                    }else{
                        $lista = explode(",", $tipoBusqueda['notas']);
						$total = count($lista);
						$array = array();
						for($i=0; $i<$total; $i++){
							$array[$i] = array(
								"id" => $lista[$i],
								"valor" => $lista[$i]
							);
						}
                        return $array;
                    }
                }else{
                    return false;
                }
                
            }
        }

        function getDescuentosProductosVariable($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT notas FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $SQLQuery = $this->db_b->query($consulta);
                if($SQLQuery->num_rows() > 0){
                    $tipoBusqueda = $SQLQuery->row_array();
                    if($tipoBusqueda['notas'] == ""){
                        return false;
                    }else{
                        $lista = explode(",", $tipoBusqueda['notas']);
						$total = count($lista);
						$array = array();
						for($i=0; $i<$total; $i++){
							$array[$i] = $lista[$i];
						}
                        return $array;
                    }
                }else{
                    return false;
                }
                
            }
        }
        
        function getPerDescuento($name){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name'";
                $SQLQuery = $this->db_b->query($consulta);
                if($SQLQuery->num_rows() > 0){
                    $tipoBusqueda = $SQLQuery->row_array();
                    $valor = $tipoBusqueda['valor_num'];
                    return $valor;
                }else{
                    return 0;
                }
            }
        }
        
        function insertarProductoVenta($idproducto,$cantidad,$idtrannum,$descuento,$preciotran,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $idtrannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }

                $ConSQL = "SELECT costounitario FROM inv_batch WHERE idproducto = '$idproducto'";
                $SQuery = $this->db_b->query($ConSQL);
				if($SQuery->num_rows() > 0){
					$SQResult = $SQuery->row_array();
					$costounit = $SQResult['costounitario'];
				}else{
					$ConSQLCosto = "SELECT costounitario FROM invproducts WHERE idproducto = $idproducto";
					$SQueryCosto = $this->db_b->query($ConSQLCosto);
					$SQResultCosto = $SQueryCosto->row_array();
					$costounit = $SQResultCosto['costounitario'];
				}

                $nedescuento = str_replace("%", "", $descuento);
                $precioneto = (1 - ($nedescuento / 100)) * $preciotran;
                
                if($tipotax != 0){
                    $taxdes = ($tipotax / 100) + 1;
                    $precioneto = $precioneto / $taxdes;
                }
                    
                $ConSQL = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $QSQL = $this->db_b->query($ConSQL);
                $Res = $QSQL->row_array();
                $idclase = $Res['idclase'];

                $ConSQL2 = "SELECT inopera FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];

                $newCant = $cantidad * $inopera;
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('cantidad', $newCant);
				$this->db_b->set('idworker', $pro_vende);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', 1);
				$this->db_b->set('costounitario', $costounit);
                $this->db_b->set('preciotran', $preciotran);
                $this->db_b->set('descuento', $nedescuento);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('tax1', $tipotax);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100k');
				
                return $query;
            }
        }
        
		function insertarProductoVentaPrueba($idproducto,$cantidad,$idtrannum,$descuento,$preciotran,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $idtrannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }

                $ConSQL = "SELECT costounitario FROM inv_batch WHERE idproducto = '$idproducto'";
                $SQuery = $this->db_b->query($ConSQL);
				if($SQuery->num_rows() > 0){
					$SQResult = $SQuery->row_array();
					$costounit = $SQResult['costounitario'];
				}else{
					$ConSQLCosto = "SELECT IFNULL(costounitario, 0) AS costounitario FROM invproducts WHERE idproducto = $idproducto";
					$SQueryCosto = $this->db_b->query($ConSQLCosto);
					$SQResultCosto = $SQueryCosto->row_array();
					$costounit = $SQResultCosto['costounitario'];
				}
				
				$nedescuento = str_replace("%", "", $descuento);
                $precioneto = (1 - ($nedescuento / 100)) * $preciotran;
                
                if($tipotax != 0){
                    $taxdes = ($tipotax / 100) + 1;
                    $precioneto = $precioneto / $taxdes;
                }
                    
                $ConSQL = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $QSQL = $this->db_b->query($ConSQL);
                $Res = $QSQL->row_array();
                $idclase = $Res['idclase'];

                $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
                $exento = $Res2['exento'];

                $newCant = $cantidad * $inopera;
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
				if($exento == 1){
					$tipotax = 0;
				}
				
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('cantidad', $newCant);
				$this->db_b->set('idworker', $pro_vende);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', 1);
				$this->db_b->set('costounitario', $costounit);
                $this->db_b->set('preciotran', $preciotran);
                $this->db_b->set('descuento', $nedescuento);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('tax1', $tipotax);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100k');
				
				return $query;
            }
        }

        function insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$idtrannum,$descuento,$preciotran,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn,$barcodePro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $this->load->model('global_model');
                $pos_prenoiva = $this->global_model->getValorNumVariable('pos_prenoiva');

                $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $idtrannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }

                $ConSQL = "SELECT costounitario FROM inv_batch WHERE idproducto = '$idproducto'";
                $SQuery = $this->db_b->query($ConSQL);
				if($SQuery->num_rows() > 0){
					$SQResult = $SQuery->row_array();
					$costounit = $SQResult['costounitario'];
				}else{
					$ConSQLCosto = "SELECT IFNULL(costounitario, 0) AS costounitario FROM invproducts WHERE idproducto = $idproducto";
					$SQueryCosto = $this->db_b->query($ConSQLCosto);
					$SQResultCosto = $SQueryCosto->row_array();
					$costounit = $SQResultCosto['costounitario'];
				}

                if ( $pos_prenoiva == 1 ) {
                    if($tipotax != 0){
                        $taxdes = ($tipotax / 100) + 1;
                        $preciotran = $preciotran * $taxdes;
                    }
                }
				
				$nedescuento = str_replace("%", "", $descuento);
                $precioneto  = (1 - ($nedescuento / 100)) * $preciotran;
                
                if($tipotax != 0){
                    $taxdes = ($tipotax / 100) + 1;
                    $precioneto = $precioneto / $taxdes;
                }
                
                $ConSQL = "SELECT idclase, estatus FROM tran_100 WHERE trannum = $idtrannum";
                $QSQL = $this->db_b->query($ConSQL);
                $Res = $QSQL->row_array();
                $idclase    = $Res['idclase'];
                $estatusDoc = $Res['estatus'];

                $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
                $exento = $Res2['exento'];

                $newCant = $cantidad * $inopera;
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
				if($exento == 1){
					$tipotax = 0;
				}
				
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('barcode', $barcodePro);
                $this->db_b->set('cantidad', $newCant);
				$this->db_b->set('idworker', $pro_vende);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
				$this->db_b->set('costounitario', $costounit);
                $this->db_b->set('preciotran', $preciotran);
                $this->db_b->set('descuento', $nedescuento);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('tax1', $tipotax);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                
                if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                    $query = $this->db_b->insert('tran_100k');
                } else return false;
				
				return $query;
            }
        }

        function actualizarVentaUM($idrec, $um, $uniconv, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax,$pro_vende,$modevn){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('global_model');
                $pos_prenoiva = $this->global_model->getValorNumVariable('pos_prenoiva');
                
                if ( $pos_prenoiva == 1 ) {
                    if($tipotax != 0){
                        $taxdes = ($tipotax / 100) + 1;
                        $precio = $precio * $taxdes;
                    }
                }

                $nedescuento = str_replace("%", "", $descuento);
                $precioneto = (1 - ($nedescuento / 100)) * $precio;
                
				if($tipotax != 0){
                    $taxdes = ($tipotax / 100) + 1;
                    $precioneto = $precioneto / $taxdes;
                }
				
                $ConSQL = "SELECT idclase, estatus FROM tran_100 WHERE trannum = $trannum";
                $QSQL = $this->db_b->query($ConSQL);
                $Res = $QSQL->row_array();
                $idclase    = $Res['idclase'];
                $estatusDoc = $Res['estatus'];

                $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
                
                $newCant = $cantidad * $inopera;
                
				$this->db_b->set('cantidad', $newCant);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('preciotran', $precio);
                $this->db_b->set('descuento', $nedescuento);
				$this->db_b->set('idworker', $pro_vende);
				$this->db_b->set('um', $um);
				$this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                
                if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                    $query = $this->db_b->update('tran_100k');
                } else return false;

                return $query;
            }
        }

        function generarDescuentoGlobal($trannum, $descuento, $max_pro){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $SQLProductos = "SELECT tran_100k.idrec, tran_100k.idproducto, tran_100k.preciotran, invproducts.tipotax FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
				$QueryProductos = $this->db_b->query($SQLProductos);
                $infoResultProductos = $QueryProductos->result();

                foreach($infoResultProductos as $info){
                    if($max_pro == "true"){
                        $SQLPro = "SELECT descuento FROM invproducts WHERE idproducto = ".$info->idproducto;
                        $QueryPro = $this->db_b->query($SQLPro);
                        $dataPro = $QueryPro->row_array();
                        $descuentoMax = $dataPro['descuento'];
                        
                        if($descuento > $descuentoMax){
                            $descuentoPro = $descuentoMax;
                        }else{
                            $descuentoPro = $descuento;
                        }
                    }else{
                        $descuentoPro = $descuento;
                    }
                    
                	$nedescuento = $descuentoPro;	
                	$precioneto = (1 - ($nedescuento / 100)) * $info->preciotran;
                	
	                if($info->tipotax != 0){
	                    $taxdes = ($info->tipotax / 100) + 1;
	                    $precioneto = $precioneto / $taxdes;
	                }

	                $this->db_b->set('descuento', $nedescuento);
	                $this->db_b->set('precioneto', $precioneto);
	                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
	                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
	                $this->db_b->where('idrec', $info->idrec);
	             	$query = $this->db_b->update('tran_100k');
                }

                return $query;
            }
        }

        function generarComisionGlobal($trannum, $comision){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $SQLProductos   = "SELECT tran_100k.idrec, tran_100k.idproducto, tran_100k.preciotran, invproducts.tipotax FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
				$QueryProductos = $this->db_b->query($SQLProductos);
                $infoResultProductos = $QueryProductos->result();

                foreach($infoResultProductos as $info){
                    $nComision = $comision / 100;
                    $nFactor   = 1 - $nComision;
                    
                	$vComision  = ($info->preciotran / $nFactor) - $info->preciotran;
                    $preciotran = ($info->preciotran / $nFactor);
                    
                    if($info->tipotax != 0){
	                    $taxdes = ($info->tipotax / 100) + 1;
	                    $precioneto = $preciotran / $taxdes;
	                }

	                $this->db_b->set('tax3', $vComision);
	                $this->db_b->set('preciotran', $preciotran);
	                $this->db_b->set('precioneto', $precioneto);
	                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
	                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
	                $this->db_b->where('idrec', $info->idrec);
	             	$query = $this->db_b->update('tran_100k');
                }

                return $query;
            }
        }

        function revertirComisionGlobal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $SQLProductos   = "SELECT tran_100k.idrec, tran_100k.idproducto, tran_100k.preciotran, tran_100k.tax3, invproducts.tipotax FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
				$QueryProductos = $this->db_b->query($SQLProductos);
                $infoResultProductos = $QueryProductos->result();

                foreach($infoResultProductos as $info){
                    $preciotran = number_format($info->preciotran - $info->tax3, 2, '.', '');
                    
                    if($info->tipotax != 0){
	                    $taxdes = ($info->tipotax / 100) + 1;
	                    $precioneto = $preciotran / $taxdes;
	                }

	                $this->db_b->set('tax3', 0);
	                $this->db_b->set('preciotran', $preciotran);
	                $this->db_b->set('precioneto', $precioneto);
	                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
	                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
	                $this->db_b->where('idrec', $info->idrec);
	             	$query = $this->db_b->update('tran_100k');
                }

                return $query;
            }
        }

        function aplicarCuponDescuento($trannum, $descuento, $totalVenta){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $SQLProductos = "SELECT idrec, idproducto, preciotran, tax1 FROM tran_100k WHERE trannum = $trannum";
				$QueryProductos = $this->db_b->query($SQLProductos);
                $infoResultProductos = $QueryProductos->result();

                $nDescuento = $descuento / $totalVenta;
                foreach($infoResultProductos as $info){
                    $precioneto = (1 - ($nDescuento)) * $info->preciotran;
                	
	                if($info->tax1 != 0){
	                    $taxdes = ($info->tax1 / 100) + 1;
	                    $precioneto = $precioneto / $taxdes;
	                }

	                $this->db_b->set('descuento', ($nDescuento * 100));
	                $this->db_b->set('precioneto', $precioneto);
	                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
	                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
	                $this->db_b->where('idrec', $info->idrec);
	             	$this->db_b->update('tran_100k');
                }

                $SQLVenta = "SELECT idclase, idcps FROM tran_100 WHERE trannum = $trannum";
				$QueryVenta = $this->db_b->query($SQLVenta);
                $infoVenta = $QueryVenta->row_array();

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idclase', $infoVenta['idclase']);
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('idcps', $infoVenta['idcps']);
                $this->db_b->set('descrip', 'Cupón de Descuento '.$this->session->userdata('simboloMoneda').''.$descuento);
                $this->db_b->set('valor', $totalVenta);
                $this->db_b->set('descuento', $descuento);
                $this->db_b->set('notas', 'Aplicación de Cupón de Descuento');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100cv');

                return $query;
            }
        }

        function actualizarClaveDescuentos($clavedescuento){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('valor_memo', $clavedescuento);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'pos_maxglodiscount');
             	$query = $this->db_b->update('gvars');

             	return $query;
            }
        }

        function actualizarDocumentoVentas($idtrannum, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100');
                
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100c');
                
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100k');
                
                return $query;
            }
        }
        
        function actualizarVendedorVentas($idtrannum, $idworker){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100');
                
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100c');
                
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100k');
                
                return $query;
            }
        }
		
		function updateEstadoTran100p($idtrannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$consulta = "SELECT prncount, estatus FROM tran_100p WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $total = $resultado['prncount'];
                $estatus = $resultado['estatus'];
				
				if($estatus == 1){
					if($total == 0){
						$total = $total + 2;
					}else{
						$total = $total + 1;
					}
				}else{
					$total = 1;
				}
								
				$this->db_b->set('useridprn', $this->session->userdata('iduser'));
				$this->db_b->set('fechaprn', $date->format('Y-m-d H:i:s'));
                $this->db_b->set('estatus', 1);
                $this->db_b->set('prncount', $total);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100p');
                
                return $query;
            }
		}
		
		function updateEstadoMotivoTran100p($idtrannum, $motivoPrint){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$consulta = "SELECT prncount, notas, estatus FROM tran_100p WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $total = $resultado['prncount'];
                $estatus = $resultado['estatus'];
                $notas = $resultado['notas'];
				
				if($notas != ""){
					$notas = trim($notas).", ".$motivoPrint;
				}else{
					$notas = $motivoPrint;
				}
				
				if($estatus == 1){
					if($total == 0){
						$total = $total + 2;
					}else{
						$total = $total + 1;
					}
				}else{
					$total = 1;
				}
								
				$this->db_b->set('useridprn', $this->session->userdata('iduser'));
				$this->db_b->set('fechaprn', $date->format('Y-m-d H:i:s'));
                $this->db_b->set('estatus', 1);
                $this->db_b->set('prncount', $total);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100p');
                
                return $query;
            }
		}
        
        function getFormasdePago($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT pagos FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $ids = $resultado['pagos'];
                
                $array = explode(',', $ids);
                $total = count($array);
                $where = "";
                
                for($i=0; $i<$total; $i++){
                    $where .= "cajclase = $array[$i] OR ";
                }
                
                $where = substr($where, 0, -4);
                
                $consulta = "SELECT * FROM caj_def WHERE ".$where;
                $query = $this->db_b->query($consulta);
                $res = $query->result();

                return $res;
            }
        }
		
		function getFormasPagoVN($agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM caj_def WHERE agrupa = '$agrupa' AND estatus = 1";
                $query = $this->db_b->query($consulta);
                $res = $query->result();

                return $res;
            }
        }
        
        function getTotalCanceladoVentas($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ifnull(SUM(valor), 0) AS total FROM tran_100c WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $total = $resultado['total'];
                
                return $total;
            }
        }
		
		function getValidatePassword($password){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = 'pos_clave'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $contra = $resultado['valor_num'];
               
				if($password == $contra){
					return 1;
				}else{
					return 0;
				}
            }
		}
        
        function insertPagoVenta($idtrannum, $valor, $idclase, $cajclase, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM tran_100c WHERE trannum = $idtrannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $ConSQL2 = "SELECT inopera FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
				$nuevoValor = $valor * $inopera;
                
				$ConSQL3 = "SELECT tran_100k.precioneto, invproducts.tipotax, tran_100k.cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $idtrannum";
				$QSQL3 = $this->db_b->query($ConSQL3);
                $datos_prod = $QSQL3->result();
				
				$total = 0;
                foreach($datos_prod as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tipotax / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
				
				$SQLConsulta4 = "SELECT ifnull(SUM(ABS(valor)), 0) AS total FROM tran_100c WHERE trannum = $idtrannum";
                $query4 = $this->db_b->query($SQLConsulta4);
                $resultado4 = $query4->row_array();
                $totalpagado = $resultado4['total'];
				
				$SQLFecha = "SELECT fecha FROM tran_100 WHERE trannum = $idtrannum";
                $QueryFec = $this->db_b->query($SQLFecha);
                $ResFecha = $QueryFec->row_array();
                $FechaTran100 = $ResFecha['fecha'];
				
				$total = $total - $totalpagado;
				$vuelto = 0;
				if($valor > $total){
					$vuelto = $total - $valor;
					$vuelto = number_format($vuelto, 2, '.', '');
				}

				$SQLValidate = "SELECT idrec FROM tran_100c WHERE trannum = '$idtrannum' AND idclase = '$idclase' AND fecha = '".$date->format('Y-m-d')."' AND cajclase = '$cajclase' AND idworker = '$idworker' AND valor = '$nuevoValor' AND vuelto = '$vuelto'";
                $QueryValidate = $this->db_b->query($SQLValidate);
				
				if($QueryValidate->num_rows() == 0){
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $idtrannum);
					$this->db_b->set('idclase', $idclase);
					$this->db_b->set('fecha', $FechaTran100);
					$this->db_b->set('itemline', $itemLine);
					$this->db_b->set('cajclase', $cajclase);
					$this->db_b->set('idworker', $idworker);
					$this->db_b->set('valor', $nuevoValor);
					$this->db_b->set('vuelto', $vuelto);
					$this->db_b->set('notas', $notas);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100c');
				}else{
					$query = true;
				}
                
                return $query;
            }
        }
        
        function insertPagoVentaUpdate($trannum, $valor, $idclase, $cajclase, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM tran_100c WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $ConSQL2 = "SELECT inopera FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
				$nuevoValor = $valor * $inopera;
                
				$ConSQL3 = "SELECT tran_100k.precioneto, tran_100k.tax1, tran_100k.cantidad FROM tran_100k WHERE tran_100k.trannum = $trannum";
				$QSQL3 = $this->db_b->query($ConSQL3);
                $datos_prod = $QSQL3->result();
				
				$total = 0;
                foreach($datos_prod as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tax1 / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
				
                $SQLEfectivo = "SELECT tran_100c.idrec, caj_def.alcuadre, tran_100c.valor FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum AND tran_100c.cajclase = $cajclase AND caj_def.alcuadre = 1";
                $QueryEfectivo = $this->db_b->query($SQLEfectivo);
				
                $SQLConsulta4 = "SELECT IFNULL(SUM(ABS(valor)), 0) AS total FROM tran_100c WHERE trannum = $trannum";
                $query4 = $this->db_b->query($SQLConsulta4);
                $resultado4 = $query4->row_array();
                $totalpagado = $resultado4['total'];

                $SQLFecha = "SELECT fecha, estatus FROM tran_100 WHERE trannum = $trannum";
                $QueryFec = $this->db_b->query($SQLFecha);
                $ResFecha = $QueryFec->row_array();
                $FechaTran100 = $ResFecha['fecha'];
                $estatusDoc   = $ResFecha['estatus'];

                $vuelto = 0;
                $total = $total - $totalpagado;
                if($valor > $total){
                    $vuelto = number_format($total, 2, '.', '') - number_format($valor, 2, '.', '');
                    $vuelto = number_format($vuelto, 2, '.', '');
                }
                
				if($QueryEfectivo->num_rows() == 0){
                    $SQLValidate = "SELECT idrec FROM tran_100c WHERE trannum = '$trannum' AND idclase = '$idclase' AND fecha = '".$date->format('Y-m-d')."' AND cajclase = '$cajclase' AND idworker = '$idworker' AND valor = '$nuevoValor' AND vuelto = '$vuelto'";
                    $QueryValidate = $this->db_b->query($SQLValidate);

                    if($QueryValidate->num_rows() == 0){
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('fecha', $FechaTran100);
                        $this->db_b->set('itemline', $itemLine);
                        $this->db_b->set('cajclase', $cajclase);
                        $this->db_b->set('idworker', $idworker);
                        $this->db_b->set('valor', $nuevoValor);
                        $this->db_b->set('vuelto', $vuelto);
                        $this->db_b->set('notas', $notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        
                        if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                            $query = $this->db_b->insert('tran_100c');
                        } else $query = false;
                    }else{
                        $query = true;
                    }
                }else{
                    $infoEfectivo = $QueryEfectivo->row_array();
                    $nuevoValor = $infoEfectivo['valor'] + $nuevoValor;
                    
                    $this->db_b->set('valor', $nuevoValor);
                    $this->db_b->set('vuelto', $vuelto);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $infoEfectivo['idrec']);
                    
                    if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                        $query = $this->db_b->update('tran_100c');
                    } else $query = false;
                }
                
                return $query;
            }
        }
        
        function insertCreditoPagoVenta($idtrannum, $valor, $idclase, $cajclase, $idworker, $notas, $idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLDoc   = "SELECT estatus FROM tran_100 WHERE trannum = $idtrannum";
                $QueryDoc = $this->db_b->query($SQLDoc);
                $ResDoc   = $QueryDoc->row_array();
                $estatusDoc = $ResDoc['estatus'];
                
                $consulta = "SELECT itemline FROM tran_100c WHERE trannum = $idtrannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $ConSQL2 = "SELECT inopera FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];

                $nuevoValor = $valor * $inopera;
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('valor', $nuevoValor);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));

                if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                    $query = $this->db_b->insert('tran_100c');
                } else $query = false;
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                if ( $estatusDoc == 0 || $estatusDoc == 8) {
                    $this->db_b->update('tran_100');
                }
                
                return $query;
            }
        }
        
        function getDetallePagosVentas($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tpago.descrip, tpago.imagen, t100c.valor, t100c.idrec, t100c.notas, t100c.descrip AS t100descrip FROM tran_100c AS t100c INNER JOIN caj_def AS tpago ON t100c.cajclase = tpago.cajclase WHERE t100c.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function deleteRegistroPago($idrec, $trannum = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if ( $trannum != 0 ) {
                    $SQLDoc   = "SELECT estatus FROM tran_100 WHERE trannum = $trannum";
                    $QueryDoc = $this->db_b->query($SQLDoc);
                    $ResDoc   = $QueryDoc->row_array();
                    $estatusDoc = $ResDoc['estatus'];
                } else $estatusDoc = 0;

                if ( $estatusDoc == 0 || $estatusDoc == 8 ) {
                    $consulta = "DELETE FROM tran_100c WHERE idrec = $idrec";
                    $query = $this->db_b->query($consulta);
                } else $query = false;
                
                return $query;
            }
        }
        
        function getListadoClientes($idcps, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $consulta = "SELECT idauxi, descrip, limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi WHERE idauxidef = 2 AND idcps = $idcps AND estado = $estado ORDER BY descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }else{
                    $consulta = "SELECT idauxi, descrip, limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi WHERE idauxidef = 2 AND estado = $estado ORDER BY descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }
				return $resultado;
            }
        }
        
        function getListadoClientesGrupo($grupoCliente, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $subconsulta = "";
                $arregloGrupos = explode(",", $grupoCliente);
                
                for($i=0; $i<count($arregloGrupos); $i++){
                    $subconsulta .= "grupo = '".$arregloGrupos[$i]."' OR ";
                }
                $subconsulta = substr($subconsulta, 0, -4);
                
                $consulta = "SELECT idauxi, descrip, limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi WHERE idauxidef = 2 AND (".$subconsulta.") AND estado = $estado ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return "";
                }
				
                return $resultado;
            }
        }
		
		function getValidateNumSerie($numserie, $numdocu, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT trannum, fecact FROM tran_100 WHERE idcentro = $idcentro AND idcaja = $idcaja AND serie = '$numserie' AND numero = '$numdocu'";
                $query = $this->db_b->query($consulta);
                
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
                	return $resultado['fecact'];
				}else{
					return "";
				}
            }
		}
		
		function getNumTipoTransaccion($idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT numtipo FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
                	return $resultado['numtipo'];
				}else{
					return false;
				}
            }
		}
		
		function getMaxLinesDoc($idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT maxlines FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
                	return $resultado['maxlines'];
				}else{
					return false;
				}
            }
		}
        
        function getSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcentro AS id, descrip, gv.descripcion AS grupo FROM invsites INNER JOIN gvars AS gv ON tipo = gv.valor_num AND gv.nombre = 'gv_tipo' WHERE estatus = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoCajas($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcaja AS id, descrip FROM ctcajas WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getEncargadoCentro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcps FROM invsites WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['idcps'];
            }
        }
        
        function getEncargadoCentroFacturacion($idusuario){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcps FROM gusers WHERE iduser = $idusuario";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['idcps'];
            }
        }
        
        function verificarCreditoCliente($idcps, $total){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT IFNULL(limite, 0) AS limite FROM ctauxi WHERE idauxi = $idcps";
                $sqlqu = $this->db_b->query($sqlcon);
                if($sqlqu->num_rows()> 0){
                    $lim = $sqlqu->row_array();
                    if($lim['limite'] == 0){
                        return 0;
                    }
                }else{
                    return 0;
                }
                
                $consulta = "SELECT IFNULL(cargos, 0) AS cargos, IFNULL(Abonos, 0) AS abonos FROM ar_balance WHERE idcps = $idcps";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()> 0){
                    $resultado = $query->row_array();
                    $total1 = $resultado['cargos'] + $resultado['abonos'];
                    $disponible = $lim['limite'] - $total1;
                }else{
                    $total1 = 0;
                    $disponible = $lim['limite'] - $total1;
                }
                
                if($disponible >= $total){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
        
        function verificarCreditoFiscal($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT askregiva FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $askregiva = $res['askregiva'];
                
                return $askregiva;
            }
        }
        
        function getDatosToCFCliente($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT descrip, telefono, direccion, dui, nrc, idzip, giro, nit, correo, idtipo FROM ctauxi WHERE idauxi = $idcps";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getSerieDocumento($idclase, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $serie = $resSQl['serie'];
                    return $serie;
                }else{
                    return "";    
                }
            }
        }
		
		function getSerieDocumentoEmpresa($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $serie = $resSQl['serie'];
                    return $serie;
                }else{
                    return "";    
                }
            }
        }

        function getSerieDocumentoSucursal($idclase, $idcentro){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $serie = $resSQl['serie'];
                    return $serie;
                }else{
                    return "";    
                }
            }
        }
		
		function getDatosResolucion($idclase, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT * FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
				$resultado = $sqlQuery->result();
                return $resultado;
            }
        }
        
        function getNumerosDocumento($idclase, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $actual = $resSQl['actual'];
                    $hasta = $resSQl['hasta'];
                    
                    $dif = $hasta - $actual;
                    
                    if($dif >= 10){
                        for($i=0; $i<10; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }else if($dif == 0){
						return "0";
					}else{
                        for($i=0; $i<$dif; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }
                    
                    return $numeros;
                }else{
                    return "";    
                }
            }
        }
        
        function getInformacionNumerosDocumento($idclase, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    
                    return $resSQl;
                }else{
                    return false;    
                }
            }
        }
		
		function getNumerosDocumentoEmpresa($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $actual = $resSQl['actual'];
                    $hasta = $resSQl['hasta'];
                    
                    $dif = $hasta - $actual;
                    
                    if($dif >= 10){
                        for($i=0; $i<10; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }else if($dif == 0){
						return "0";
					}else{
                        for($i=0; $i<$dif; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }
                    
                    return $numeros;
                }else{
                    return "";    
                }
            }
		}
		
		function getInformacionNumerosDocumentoEmpresa($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    
                    return $resSQl;
                }else{
                    return false;    
                }
            }
		}

		function getNumerosDocumentoSucursal($idclase, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $actual = $resSQl['actual'];
                    $hasta = $resSQl['hasta'];
                    
                    $dif = $hasta - $actual;
                    
                    if($dif >= 10){
                        for($i=0; $i<10; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }else if($dif == 0){
						return "0";
					}else{
                        for($i=0; $i<$dif; $i++){
                            $num = $actual + 1;
                            $numeros[$i] = "$num"; 
                            $actual = $actual + 1;
                        }
                    }
                    
                    return $numeros;
                }else{
                    return "";    
                }
            }
		}

		function getInformacionNumerosDocumentoSucursal($idclase, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    
                    return $resSQl;
                }else{
                    return false;    
                }
            }
		}

        //////

        function getNumerosRestantesDocumento($idclase, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta, reserva FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $restante = $resSQl['hasta']-$resSQl['actual'];
                    return ["restante"=>$restante, "reserva"=>(int)$resSQl['reserva']];
                }else{
                    return "";    
                }
            }
        }

        function getNumerosRestantesDocumentoEmpresa($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta, reserva FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $restante = $resSQl['hasta']-$resSQl['actual'];
                    return ["restante"=>$restante, "reserva"=>(int)$resSQl['reserva']];
                }else{
                    return "";    
                }
            }
		}

        function getNumerosRestantesDocumentoSucursal($idclase, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT actual, hasta, reserva FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                if($sqlQuery->num_rows()> 0){
                    $resSQl = $sqlQuery->row_array();
                    $restante = $resSQl['hasta']-$resSQl['actual'];
                    return ["restante"=>$restante, "reserva"=>(int)$resSQl['reserva']];
                }else{
                    return "";    
                }
            }
		}


        ///
        
        function anulacionDeOrden($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT descrip FROM gusers WHERE iduser = ".$this->session->userdata('iduser');
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $descrip = $res['descrip'];
                $notas = "Orden anulada por ".trim($descrip)." la fecha de : ".$date->format('Y-m-d H:i:s');
                 
                $this->db_b->set('estatus', 9);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100');
                
                $this->db_b->set('cantidad', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $this->db_b->update('tran_100k');
                
                $consulta = "DELETE FROM tran_100c WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                
                return $query;
            }
        }
        
        function cierreDeVentaCF($idtrannum, $numserie, $numdocu, $notas, $referencia, $nrc, $idcps, $contactoAdicional){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                                
                $consulta = "SELECT cajclase FROM tran_100c WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                $modfecvence = 0;
                foreach($result as $info){
                    $SQLconsulta = "SELECT creditchk FROM caj_def WHERE cajclase = ".$info->cajclase;
                    $SQLquery = $this->db_b->query($SQLconsulta);
                    $SQLres = $SQLquery->row_array();
                    
                    if($SQLres['creditchk'] == 1){
						$this->db_b->set('numy', $info->cajclase);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
						$this->db_b->where('trannum', $idtrannum);
						$this->db_b->update('tran_100');
                        $modfecvence = 1;
                    }
                }
                
                if($modfecvence == 1){
                    $SQLauxi = "SELECT dias FROM ctauxi WHERE idauxi = ".$idcps;
                    $SQLQauxi = $this->db_b->query($SQLauxi);
                    $SQLresauxi = $SQLQauxi->row_array();
                    $dias = trim($SQLresauxi['dias']);
                    
                    $fecha = date('Y-m-d');
                    $fecvence = strtotime ( '+'.$dias.' day' , strtotime ($fecha)) ;
                    $fecvence = date ('Y-m-d' , $fecvence);
                    
                    $consu = "DELETE FROM tran_100c WHERE trannum = $idtrannum AND descrip != 'P_RT'";
                    $sql_query = $this->db_b->query($consu);
                }
                
                $this->db_b->set('serie', $numserie);
                $this->db_b->set('numero', $numdocu);
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                if($modfecvence == 1){
                    $this->db_b->set('fecvence', $fecvence);
                }
                $this->db_b->set('nrc', $nrc);
                //$this->db_b->set('idcps', $idcps);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('idcentrod', $contactoAdicional);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }
        
        function cierreDeVenta($idtrannum, $numserie, $numdocu, $notas, $referencia, $idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                                
                $consulta = "SELECT cajclase FROM tran_100c WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                $modfecvence = 0;
                foreach($result as $info){
                    $SQLconsulta = "SELECT creditchk FROM caj_def WHERE cajclase = ".$info->cajclase;
                    $SQLquery = $this->db_b->query($SQLconsulta);
                    $SQLres = $SQLquery->row_array();
                    
                    if($SQLres['creditchk'] == 1){
						$this->db_b->set('numy', $info->cajclase);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
						$this->db_b->where('trannum', $idtrannum);
						$this->db_b->update('tran_100');
                        $modfecvence = 1;
                    }
                }
                
                if($modfecvence == 1){
                    $SQLauxi = "SELECT dias FROM ctauxi WHERE idauxi = ".$idcps;
                    $SQLQauxi = $this->db_b->query($SQLauxi);
                    $SQLresauxi = $SQLQauxi->row_array();
                    $dias = trim($SQLresauxi['dias']);
                    
                    $fecha = date('Y-m-d');
                    $fecvence = strtotime ( '+'.$dias.' day' , strtotime ($fecha)) ;
                    $fecvence = date ('Y-m-d' , $fecvence);
                    
                    $consu = "DELETE FROM tran_100c WHERE trannum = $idtrannum AND descrip != 'P_RT'";
                    $sql_query = $this->db_b->query($consu);
                }
                
                $this->db_b->set('serie', $numserie);
                $this->db_b->set('numero', $numdocu);
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                if($modfecvence == 1){
                    $this->db_b->set('fecvence', $fecvence);
                }
                //$this->db_b->set('idcps', $idcps);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }
        
        function updateDatosClienteCF($idcps, $dui, $nrc, $nit, $tipocont, $giro, $direccion, $telefono, $idzip, $correo, $descrip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('dui', $dui);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('giro', $giro);
                $this->db_b->set('idtipo', $tipocont);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idcps);
                $query = $this->db_b->update('ctauxi');
                
                return $query;
            }
        }
        
        function updateDatosClienteFF($idcps, $dui, $nrc, $nit, $email, $direccion, $telefono, $idzip, $descrip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('dui', $dui);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $email);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idcps);
                $query = $this->db_b->update('ctauxi');
                
                return $query;
            }
        }
        
        function insertDatosClienteCF($idtrannum, $dui, $nrc, $nit, $tipocont, $giro, $direccion, $telefono, $idzip, $correo, $descrip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
                $this->db_b->set('dui', $dui);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('giro', $giro);
                $this->db_b->set('idtipo', $tipocont);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
                
                $this->db_b->set('idcps', $idcliente);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
		
		function insertNuevoClienteVN($descrip){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
				$this->db_b->set('descrip', $descrip);
                $this->db_b->set('idzip', 0);
                $this->db_b->set('idcps', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
				return $idcliente;
			}
		}
		
		function insertNuevoClienteVNGrupo($descrip, $grupoCliente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $arregloGrupos = explode(",", $grupoCliente);
                
				$this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
				$this->db_b->set('descrip', $descrip);
				$this->db_b->set('grupo', $arregloGrupos[0]);
                $this->db_b->set('idzip', 0);
                $this->db_b->set('idcps', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
				return $idcliente;
			}
		}
		
        function insertNuevoClienteFrecuenteVN($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte = '', $cli_tipo, $cli_nit = ''){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
				$this->db_b->set('descrip', $cli_name);
				$this->db_b->set('telefono', $cli_phone);
				$this->db_b->set('correo', $cli_email);
				$this->db_b->set('dui', $cli_dui);
				$this->db_b->set('nrc', $cli_nrc);
                $this->db_b->set('nit', $cli_nit);
				$this->db_b->set('direccion', $cli_direc);
                $this->db_b->set('idzip', $cli_idzip);
				$this->db_b->set('giro', $cli_giro);
                if($this->db_b->field_exists('dte_giro', 'ctauxi')){
                    $this->db_b->set('dte_giro', $cli_gdte);
                }
				$this->db_b->set('idtipo', $cli_tipo);
                $this->db_b->set('idcps', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente Frecuente ingresado desde Sistema de Facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
				return $idcliente;
			}
		}
		
		function insertNuevoClienteFrecuenteVNGrupo($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte = '', $cli_tipo, $grupoCliente, $cli_nit = ''){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $arregloGrupos = explode(",", $grupoCliente);
                
				$this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
				$this->db_b->set('grupo', $arregloGrupos[0]);
				$this->db_b->set('descrip', $cli_name);
				$this->db_b->set('telefono', $cli_phone);
				$this->db_b->set('correo', $cli_email);
				$this->db_b->set('dui', $cli_dui);
				$this->db_b->set('nrc', $cli_nrc);
                $this->db_b->set('nit', $cli_nit);
				$this->db_b->set('direccion', $cli_direc);
                $this->db_b->set('idzip', $cli_idzip);
				$this->db_b->set('giro', $cli_giro);
                if($this->db_b->field_exists('dte_giro', 'ctauxi')){
                    $this->db_b->set('dte_giro', $cli_gdte);
                }
				$this->db_b->set('idtipo', $cli_tipo);
                $this->db_b->set('idcps', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente Frecuente ingresado desde Sistema de Facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
				return $idcliente;
			}
		}

        function updateRegistroClienteFrecuente($cliente, $cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte = '', $cli_tipo, $cli_nit = ''){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				                
                $this->db_b->set('descrip', $cli_name);
				$this->db_b->set('telefono', $cli_phone);
				$this->db_b->set('correo', $cli_email);
				$this->db_b->set('dui', $cli_dui);
				$this->db_b->set('nrc', $cli_nrc);
				$this->db_b->set('nit', $cli_nit);
				$this->db_b->set('direccion', $cli_direc);
                $this->db_b->set('idzip', $cli_idzip);
				$this->db_b->set('giro', $cli_giro);
                if($this->db_b->field_exists('dte_giro', 'ctauxi')){
                    $this->db_b->set('dte_giro', $cli_gdte);
                }
				$this->db_b->set('idtipo', $cli_tipo);
                $this->db_b->set('estado', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idauxi', $cliente);
                return $this->db_b->update('ctauxi');
			}
		}
        
        function insertDatosClienteFF($idtrannum, $dui, $nrc, $nit, $email, $direccion, $telefono, $idzip, $descrip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('idauxidef', 2);
                $this->db_b->set('dui', $dui);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $email);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('estado', 1);
                $this->db_b->set('fechain', $date->format('Y-m-d'));
                $this->db_b->set('notas', 'Cliente ingresado desde el sistema de facturación');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('ctauxi');
                
                $idcliente = $this->db_b->insert_id();
                
                $this->db_b->set('idcps', $idcliente);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
        
        function updateDatosTran100k($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                                
                $consulta = "SELECT idrec, precioneto, tax1 FROM tran_100k WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                foreach($result as $info){
                    $tax = ($info->tax1 / 100) + 1;
                    $precioneto = $info->precioneto / $tax;
                    
                    $this->db_b->set('precioneto', $precioneto);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('trannum', $idtrannum);
                    $this->db_b->where('idrec', $info->idrec);
                    $query = $this->db_b->update('tran_100k');                     
                }
                
                return $query;
            }
        }
        
        function updateNumerosFacturas($idtrannum, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $sqlqu = $this->db_b->query($sqlcon);
                $resclase = $sqlqu->row_array();
                
                $idclase = $resclase['idclase'];
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
        }
        
		function updateNumerosFacturasEmpresa($idtrannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $sqlqu = $this->db_b->query($sqlcon);
                $resclase = $sqlqu->row_array();
                
                $idclase = $resclase['idclase'];
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
		}
		

		function updateNumerosFacturasSucursal($idtrannum, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $sqlqu = $this->db_b->query($sqlcon);
                $resclase = $sqlqu->row_array();
                
                $idclase = $resclase['idclase'];
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
		}

        function getInformacionCtauxi($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
                $sqlcon = "SELECT * FROM ctauxi WHERE idauxi = ".$idcps;
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->result();
                
                return $res;
            }
        }
        
        function callTotaliza100($idtrannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "CALL totaliza100($idtrannum, $estado)";
                $query = $this->db_b->query($consulta);
                
                return $query;
            }
        }
        
        function imprimirTicketVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
              try {
                  /* Open file */
                $tmpdir = sys_get_temp_dir();
                $file =  tempnam($tmpdir, 'ctk');

                /* Do some printing */
                $connector = new FilePrintConnector($file);
                $printer = new Printer($connector);
                $printer -> text("Hello World!\n");
                $printer -> cut();

                $printer -> close();
                unlink($file);
                } catch(Exception $e) {
                    echo "Couldn't print to this printer: " . $e -> getMessage() . "\n";
                }
            }
        }
        
        function getTipos($idsucursal){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT(tran_100.idclase) AS id, inv_def.descrip AS text, inv_def.agrupa AS tipo  FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE idcentro = $idsucursal ORDER BY inv_def.agrupa ASC ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        function getTransaccionesCenterFechas($idsucursal, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT(tran_100.idclase) AS id, inv_def.descrip AS text, inv_def.agrupa AS tipo,COUNT(tran_100.trannum) as cant  FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE idcentro = $idsucursal AND tran_100.fecha BETWEEN '$fechaini' and '$fechafin' AND tran_100.estatus!=0 GROUP BY tran_100.idclase ORDER BY inv_def.descrip ASC ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function verTipo($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            
                $consulta = "SELECT agrupa FROM inv_def WHERE invclase = $tipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cadena = $resultado['agrupa'];
                return $cadena;
            
            }
        
        }
		
        function listaTran100CO($idcentro, $idsucursal, $fecha1, $fecha2){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum AS id, tran_100.notas,  tran_100.fecha AS fecha, CONCAT(tran_100.serie , tran_100.numero) AS numero, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi WHERE id = tran_100.trannum ) AS cliente, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idworker = ctauxi.idauxi WHERE id = tran_100.trannum) AS vendedor,  (tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS valor FROM tran_100 WHERE tran_100.idclase = $idcentro AND tran_100.idcentro = $idsucursal AND (tran_100.fecha >= '$fecha1' AND tran_100.fecha <= '$fecha2') AND tran_100.estatus!=0 ORDER BY tran_100.fecha DESC";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function listaTran100VN($idcentro, $idsucursal, $fecha1, $fecha2){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$consulta = "SELECT tran_100.trannum AS id, tran_100.notas,  tran_100.fecha AS fecha, CONCAT(tran_100.serie , tran_100.numero) AS numero, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi WHERE id = tran_100.trannum ) AS cliente, (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idworker = ctauxi.idauxi WHERE id = tran_100.trannum) AS vendedor,  (tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS valor FROM tran_100 WHERE tran_100.idclase = $idcentro AND tran_100.idcentro = $idsucursal AND (tran_100.fecha >= '$fecha1' AND tran_100.fecha <= '$fecha2')  AND tran_100.estatus!=0  ORDER BY tran_100.fecha DESC";
                $consulta = "SELECT tran_100.trannum AS id, tran_100.notas, tran_100.fecha AS fecha, CONCAT(tran_100.serie, tran_100.numero) AS numero,
                ctauxi.descrip AS cliente, ctauxi2.descrip AS vendedor, (tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS valor
                FROM tran_100 INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                INNER JOIN ctauxi AS ctauxi2 ON tran_100.idworker = ctauxi2.idauxi
                WHERE tran_100.idclase = $idcentro AND tran_100.idcentro = $idsucursal AND (tran_100.fecha >= '$fecha1' AND tran_100.fecha <= '$fecha2')
                AND tran_100.estatus != 0 ORDER BY tran_100.fecha DESC";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function listaTran100IN($idcentro, $idsucursal, $fecha1, $fecha2){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum AS id, tran_100.notas,  tran_100.fecha AS fecha, (tran_100.referencia) AS numero, (SELECT invsites.descrip FROM invsites INNER JOIN tran_100 ON tran_100.idcentrod = invsites.idcentro WHERE id = tran_100.trannum ) AS cliente,  (SELECT ctauxi.descrip FROM ctauxi INNER JOIN tran_100 ON tran_100.idworker = ctauxi.idauxi WHERE id = tran_100.trannum) AS vendedor,   (tran_100.valcosto ) AS valor FROM tran_100 WHERE tran_100.idclase = $idcentro AND tran_100.idcentro = $idsucursal AND (tran_100.fecha >= '$fecha1' AND tran_100.fecha <= '$fecha2') AND tran_100.estatus!=0  ORDER BY tran_100.fecha DESC";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function listaTran100kCO($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.itemline AS id, invproducts.idproducto AS codigo, invproducts.modelo AS modelo, invproducts.descrip AS descrip, tran_100k.um AS unidad, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad AS cantidad, tran_100k.preciotran AS precio, (tran_100k.cantidad * tran_100k.preciotran) AS total, tran_100k.notas, tran_100.idworker, IFNULL(ctauxi.descrip,'') as vendedor,  tran_100.idclase, IFNULL(caj_def.descrip,'') AS formaPago, IFNULL(caj_def.imagen,'') as imagenPago
                FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum= tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                INNER JOIN invlocations ON invlocations.idbin = tran_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                LEFT JOIN caj_def ON caj_def.cajclase=tran_100.idclase LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idworker
                WHERE tran_100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
		function listaTran100kVN($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.itemline AS id, invproducts.idproducto AS codigo, invproducts.modelo AS modelo, invproducts.descrip AS descrip, tran_100k.um AS unidad, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad AS cantidad, tran_100k.precioneto AS precio, (tran_100k.cantidad * tran_100k.precioneto) AS total, tran_100k.notas, tran_100k.idworker, IFNULL(ctauxi.descrip,'') as vendedor, tran_100.idclase, IFNULL(caj_def.descrip,'') AS formaPago, IFNULL(caj_def.imagen,'') as imagenPago
                FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum= tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                INNER JOIN invlocations ON invlocations.idbin = tran_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                LEFT JOIN caj_def ON caj_def.cajclase=tran_100.idclase LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker
                WHERE tran_100k.trannum =$trannum";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
		function listaTran100kIN($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.itemline AS id, invproducts.idproducto AS codigo, invproducts.modelo AS modelo, invproducts.descrip AS descrip, tran_100k.um AS unidad, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad AS cantidad, tran_100k.costounitario AS precio, (tran_100k.cantidad * tran_100k.costounitario) AS total, tran_100k.notas, tran_100.idworker, IFNULL(ctauxi.descrip,'') as vendedor, tran_100.idclase, IFNULL(caj_def.descrip,'') AS formaPago, IFNULL(caj_def.imagen,'') as imagenPago
                FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum= tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                INNER JOIN invlocations ON invlocations.idbin = tran_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                LEFT JOIN caj_def ON caj_def.cajclase=tran_100.idclase LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idworker
                WHERE tran_100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
		
		function getDataProductoVentaTran100k($idtrannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, invproducts.tipotax, invproducts.tipo, invproducts.upp, tran_100k.idrec, tran_100k.idworker, tran_100k.itemline, invproducts.idcatalogo, invproducts.descrip,
                    invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas AS notasProducto, invlocations.descrip AS ubicacion,
                    inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.descuento,
                    tran_100k.notas,
                    IFNULL((SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k.idproducto = tran_100k2.idproducto AND tran_100k.idcentro = tran_100k2.idcentro), 999999) AS disponible,
                    CONCAT(invproducts.descrip,'<br>','CODIGO:','<strong>',invproducts.idproducto,'</strong>','<br>','MODELO: ','<strong>',invproducts.modelo,'</strong>',' MARCA: ','<strong>',invproducts.marca,'</strong>') AS descripcion
                FROM
                    tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                WHERE tran_100k.trannum = $idtrannum AND tran_100k.idproducto = $idproducto
                ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getFormatoPrintDef($idclase, $url){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT askpwd, gvarpwd, formname, appoptions FROM gforms WHERE appname = '$url' AND notas = '$idclase'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
					return $resultado;
				}else{
					return false;
				}
            }
		}
		
		function getListadoClientesFilter($auxidef, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idauxi, descrip FROM ctauxi WHERE idauxidef = $auxidef AND estado = $estado";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
            }
		}
		
		function getMesesVentasCerradas($agrupa, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta ="SET lc_time_names = 'es_SV'";
                $this->db_b->query($consulta);
				
				$SQLMeses = "SELECT valor_num FROM gvars WHERE nombre = 'pos_devmeses'";
                $QueryMeses = $this->db_b->query($SQLMeses);
				if($QueryMeses->num_rows() > 0){
					$resultado = $QueryMeses->row_array();
					$numMeses = number_format($resultado['valor_num']);
				}else{
					$numMeses = 3;
				}
				
				$consulta = "SELECT DISTINCT MONTH(t100.fecha) AS numMes, MONTHNAME(t100.fecha) AS Mes, YEAR(t100.fecha) AS Anio FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.estatus = 1 ORDER BY t100.fecha DESC LIMIT $numMeses";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
			}
		}
		
		function getDatosFacturacionesCerradasDev($agrupa, $idcentro, $idcaja, $fechaini, $fechafin, $tipodoc){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($tipodoc != ""){
					if($fechaini != "" && $fechafin != ""){
						$consulta = "SELECT t100.trannum, t100.idclase, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente,ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.estatus = 1 AND t100.idclase = $tipodoc AND fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecha, t100.numero";
					}else{
						$consulta = "SELECT t100.trannum, t100.idclase, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente,ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.estatus = 1 AND t100.idclase = $tipodoc ORDER BY t100.fecha, t100.numero";
					}
				}else{
					if($fechaini != "" && $fechafin != ""){
						$consulta = "SELECT t100.trannum, t100.idclase, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente,ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.estatus = 1 AND fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecha, t100.numero";
					}else{
						$consulta = "SELECT t100.trannum, t100.idclase, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente,ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.estatus = 1 ORDER BY t100.fecha, t100.numero";
					}
				}
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
		function getDatosCreditosCerradasDev($agrupa, $idcentro, $idcaja, $idauxi) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT t100.trannum, t100.idclase, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.idtipo as tipoCliente,ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1 FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND invdef.askregiva = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.idcps = $idauxi AND t100.estatus = 1 ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
		function getListadoProductosDevolucion($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.imagen, invproducts.descrip, tran_100k.* FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
			}
		}
		
		function getLstadoSumaProductosDev($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT itemline, SUM(cantidad) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum WHERE tranref = $trannum GROUP BY itemline";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
			}
		}
		
		function getTipoPagoRealiVenta($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ConsultaSql = "SELECT numy FROM tran_100 WHERE trannum = $trannum";
				$QuerySql = $this->db_b->query($ConsultaSql);
                $resultado = $QuerySql->row_array();
				$idclase = number_format($resultado['numy']);
				
				if($idclase != 0){
                    // $consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";

					$consulta = "SELECT caj_def.cajclase, caj_def.descrip, '' AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else{
					$consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}
			}
		}
		
        function getTipoPagoRealVentaOrdenes($trannum) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum";
                $query = $this->db_b->query($consulta);

                if ( $query->num_rows() > 0 ) {
                    $resultado = $query->result();
                    return $resultado;
                } else {
                    $consulta = "SELECT caj_def.cajclase, caj_def.descrip, '' AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
                    
					return $resultado;
                }
			}
		}

        function getTipoPagoRealiVentaCredito($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ConsultaSql = "SELECT numy FROM tran_100 WHERE trannum = $trannum";
				$QuerySql = $this->db_b->query($ConsultaSql);
                $resultado = $QuerySql->row_array();
				$idclase = number_format($resultado['numy']);
				
				if($idclase != 0){
                    //$consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";

					$consulta = "SELECT caj_def.cajclase, caj_def.descrip FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else{
					$consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}
			}
		}
		
		function getIdClaseVenta($idtrannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT idclase FROM tran_100 WHERE trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
				$idclase = $resultado['idclase'];
                return $idclase;
			}
		}
		
		function getIdClaseDevolucion($idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT xpos FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
				$idclase = $resultado['xpos'];
                return $idclase;
			}
		}
		
		function verificaPagoEfectivo($idtrannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT caj_def.vueltos FROM caj_def INNER JOIN tran_100c ON caj_def.cajclase = tran_100c.cajclase WHERE tran_100c.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
				
				$efectivo = 0;
				foreach($resultado as $pagos){
					if($pagos->vueltos == 1){
						$efectivo = 1;
					}
				}
				return $efectivo;
			}
		}
		
		function getDatosPrinter($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT IFNULL(notas,'') AS notas FROM ctcajas WHERE idcaja = $idcaja";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
				$datos = $resultado['notas'];
                return $datos;
			}
		}
        
        function getDatosPrinterReferencia($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT IFNULL(xpos,'') AS xpos FROM ctcajas WHERE idcaja = $idcaja";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
			}
		}
		
		function updateTran100pPrint($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$consulta = "SELECT prncount FROM tran_100p WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $total = $resultado['prncount'];
				
				if($total == 0){
					$total = $total + 2;
				}else{
					$total = $total + 1;
				}
				
				$this->db_b->set('useridprn', $this->session->userdata('iduser'));
				$this->db_b->set('estatus', 1);
                $this->db_b->set('prncount', $total);
				$this->db_b->set('fechaprn', $date->format('Y-m-d H:i:s'));
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('tran_100p');
				
				return $query;				
			}
		}
		
		function verificaTicket($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sqlcon = "SELECT esticket FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                $esticket = $res['esticket'];
				return $esticket;
            }
        }
		
		function insertDevolucionVenta($idtrannum,$registros,$idpago,$serie,$numero,$notas,$idcentro,$idcaja,$idclasedev,$cantidades,$valor,$fecha_dev){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT inopera, caopera FROM inv_def WHERE invclase = $idclasedev";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
				$inopera = $resultado['inopera'];
				$caopera = $resultado['caopera'];
				
				$SQL100 = "SELECT idcps, idworker, nrc FROM tran_100 WHERE trannum = $idtrannum";
                $Quer = $this->db_b->query($SQL100);
                $res100 = $Quer->row_array();
				$idcps = $res100['idcps'];
				$idworker = $res100['idworker'];
				$nrc = $res100['nrc'];
				
                $creditchkr = 0;
                if($idpago != 0){
                    $SQLPa = "SELECT creditchk FROM caj_def WHERE cajclase = $idpago";
                    $QuePa = $this->db_b->query($SQLPa);
                    $ResPa = $QuePa->row_array();
                    $creditchkr = $ResPa['creditchk'];
                }else{
                    $creditchkr = 1;
                }
				
				$SQLNum = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
				$idrec = explode(',', $registros);
				$contador = count($idrec);
				$contador = $contador - 1;
				
				$infCant = explode(',', $cantidades);
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$fecha_dev = date_format(date_create($fecha_dev), 'Y-m-d H:i:s');
				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('idclase', $idclasedev);
                $this->db_b->set('serie', $serie);
                $this->db_b->set('numero', $numero);
                $this->db_b->set('nrc', $nrc);
                $this->db_b->set('fecha', $fecha_dev);
                $this->db_b->set('fecact', $fecha_dev);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('numx', $numero_x);
                $this->db_b->set('numz', $numero_z);
                $this->db_b->set('estatus', 1);
				if($creditchkr == 0){
					$this->db_b->set('ccestatus', 1);
				}else if($creditchkr == 1){
					$this->db_b->set('ccestatus', 0);
				}
                $this->db_b->set('tranref', $idtrannum);
				$this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
                
                $iddevolucion = $this->db_b->insert_id();
				for($i=0; $i<$contador; $i++){
					$SQL = "SELECT * FROM tran_100k WHERE idrec = $idrec[$i]";
					$QueryProd = $this->db_b->query($SQL);
					$infoPro = $QueryProd->row_array();
					
					$nuevaCantidad = $infCant[$i] * $inopera;
					
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $iddevolucion);
					$this->db_b->set('idclase', $idclasedev);
					$this->db_b->set('itemline', $infoPro['itemline']);
					$this->db_b->set('idcentro', $idcentro);
					$this->db_b->set('idproducto', $infoPro['idproducto']);
					$this->db_b->set('idbatch', $infoPro['idbatch']);
					$this->db_b->set('idbin', $infoPro['idbin']);
					$this->db_b->set('idworker', $infoPro['idworker']);
					$this->db_b->set('cantidad', $nuevaCantidad);
					$this->db_b->set('um', $infoPro['um']);
					$this->db_b->set('uniconv', $infoPro['uniconv']);
					$this->db_b->set('costounitario', $infoPro['costounitario']);
					$this->db_b->set('preciotran', $infoPro['preciotran']);
					$this->db_b->set('descuento', $infoPro['descuento']);
					$this->db_b->set('precioneto', $infoPro['precioneto']);
					$this->db_b->set('tax1', $infoPro['tax1']);
					$this->db_b->set('tax2', $infoPro['tax2']);
					$this->db_b->set('tax3', $infoPro['tax3']);
					$this->db_b->set('tax4', $infoPro['tax4']);
					$this->db_b->set('tax5', $infoPro['tax5']);
					$this->db_b->set('notas', $infoPro['notas']);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$this->db_b->insert('tran_100k');
				}
				
				$valor = $inopera * $valor;
				
                if($idpago != 0){
                    if($creditchkr != 1){
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $iddevolucion);
                        $this->db_b->set('idclase', $idclasedev);
                        $this->db_b->set('fecha', $fecha_dev);
                        $this->db_b->set('itemline', 1);
                        $this->db_b->set('cajclase', $idpago);
                        $this->db_b->set('idworker', $idworker);
                        $this->db_b->set('descrip', 'DEVOLUCION DE PRODUCTO');
                        $this->db_b->set('valor', $valor);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $query = $this->db_b->insert('tran_100c');
                    }
                }
				
				return $iddevolucion;
			}
		}
		
		function getDatosClienteFrecuente($idcliente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT idauxi, descrip FROM ctauxi WHERE idauxi = $idcliente";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
			}
		}

		function getDatosClienteFrecuenteUpdate($tipo, $idcliente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                if($tipo == '0'){
                    $tipo = "xpos";
                }

				$consulta = "SELECT idauxi, descrip FROM ctauxi WHERE $tipo = '$idcliente' AND idauxidef = 2";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
			}
		}
		
		function getVerificaTipoDevolucion($tipodoc){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT xpos FROM inv_def WHERE invclase = $tipodoc";
                $query = $this->db_b->query($consulta);
				$result = $query->row_array();
				if($result['xpos'] == "" || $result['xpos'] == null){
					return false;
				}else{
					$SQLCon = "SELECT descrip FROM inv_def WHERE invclase = ".$result['xpos'];
					$SQLQuery = $this->db_b->query($SQLCon);
					if($SQLQuery->num_rows() > 0){
						$resultado = $SQLQuery->result();
					}else{
						$resultado = false;
					}
					return $resultado;
				}
			}
		}
		
		function getVendedoresFrecuentesSuc($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.imagen FROM ctauxi INNER JOIN tran_100 ON tran_100.idworker = ctauxi.idauxi INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE ctauxi.idauxidef = 3 AND tran_100.idcentro = $idcentro AND inv_def.agrupa = 'VN' GROUP BY ctauxi.idauxi ORDER BY tran_100.fecact DESC LIMIT 16";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function getVendedoresFrecuentes100kSuc($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
                
                $fechafin = $date->format('Y-m-d');
                $fechaini = date("Y-m-d", strtotime($fechafin."- 7 days"));

                $consulta = "SELECT DISTINCT ctauxi.idauxi, ctauxi.descrip, ctauxi.imagen, SUM(ABS(tran_100k.cantidad)) AS cantidad 
                FROM tran_100k 
                INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi AND ctauxi.estado = 1 
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                WHERE ctauxi.idauxidef = 3 AND tran_100.idcentro = $idcentro AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN  '$fechaini' AND '$fechafin'
                GROUP BY tran_100k.idworker 
                ORDER BY cantidad DESC LIMIT 16";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}	
		}        
        
        public function getSeriesCategorias_chart(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta="SELECT  invcatalog.idnivel1 as ID, CONCAT('C',invcatalog.idnivel1) as valueField, invcatalog2.descrip as name FROM inv_prostats INNER JOIN	invproducts ON invproducts.idproducto= inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo= invproducts.idcatalogo INNER JOIN invcatalog  as invcatalog2 on invcatalog2.idcatalogo=invcatalog.idnivel1 WHERE agrupa='VN' GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
             }
        }
        
        public function getSeriesLineas_chart($busqueda){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT idcatalogo from invcatalog where descrip LIKE '$busqueda'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $id_dep = $resultado['idcatalogo'];
                
                $consulta="SELECT 
                            invcatalog.idcatalogo AS ID,
                            CONCAT('C', invcatalog.idcatalogo) AS valueField,
                            invcatalog.descrip AS name
                        FROM
                            invcatalog 
                        WHERE
                            idnivel1=$id_dep
                            ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
             }
        }
        
        public function getLinesChartFechas_Cat($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta="SELECT 
                            catalogo2.descrip, catalogo2.idcatalogo
                        FROM
                            tran_100k
                                INNER JOIN
                            invproducts ON invproducts.idproducto = tran_100k.idproducto
                                INNER JOIN
                            invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                INNER JOIN 
                                invcatalog AS catalogo2 ON catalogo2.idcatalogo= invcatalog.idnivel1
                            GROUP BY catalogo2.idcatalogo";
                $query = $this->db_b->query($consulta);
                $categorias = $query->result();
                
                $subconsulta ='';
                foreach($categorias as $cat){
                    $subconsulta.=" (SELECT 
                                        SUM(tran_100k.cantidad * tran_100k.precioneto)
                                    FROM
                                        tran_100k
                                            INNER JOIN
                                        tran_100 AS t100 ON t100.trannum = tran_100k.trannum
                                            INNER JOIN
                                        inv_def ON t100.idclase = inv_def.invclase
                                            INNER JOIN
                                        invproducts ON invproducts.idproducto = tran_100k.idproducto
                                            INNER JOIN
                                        invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                            INNER JOIN
                                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                                    WHERE
                                        invcatalog2.idcatalogo = $cat->idcatalogo
                                            AND tran_100k.trannum = t100.trannum
                                            AND t100.fecha = fecha_select
                                            AND inv_def.agrupa = 'VN') AS C$cat->idcatalogo, ";
                }
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro AS idcentro,
                                tran_100.fecha AS fecha_select,
                                tran_100.fecha,
                                 ";
                $consulta.=$subconsulta;
                $consulta .=" inv_def.agrupa AS agrupa  FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                tran_100k ON tran_100.trannum = tran_100k.trannum
                            WHERE
                                (inv_def.agrupa = 'VN')  AND tran_100.fecha between '$fechaini' and '$fechafin' 
                            GROUP BY tran_100.fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            }
        }
        
        public function getTotales_Cat(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $consulta="SELECT 
                            catalogo2.descrip, catalogo2.idcatalogo
                        FROM
                            tran_100k
                                INNER JOIN
                            invproducts ON invproducts.idproducto = tran_100k.idproducto
                                INNER JOIN
                            invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                INNER JOIN 
                                invcatalog AS catalogo2 ON catalogo2.idcatalogo= invcatalog.idnivel1
                            GROUP BY catalogo2.idcatalogo";
                $query = $this->db_b->query($consulta);
                $categorias = $query->result();
                
                $subconsulta ='';
                foreach($categorias as $cat){
                    $subconsulta.=" (SELECT 
                                        SUM(tran_100k.cantidad * tran_100k.precioneto)
                                    FROM
                                        tran_100k
                                            INNER JOIN
                                        tran_100 AS t100 ON t100.trannum = tran_100k.trannum
                                            INNER JOIN
                                        inv_def ON t100.idclase = inv_def.invclase
                                            INNER JOIN
                                        invproducts ON invproducts.idproducto = tran_100k.idproducto
                                            INNER JOIN
                                        invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                            INNER JOIN
                                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                                    WHERE
                                        invcatalog2.idcatalogo = $cat->idcatalogo
                                            AND tran_100k.trannum = t100.trannum
                                            AND t100.fecha = fecha_select
                                            AND inv_def.agrupa = 'VN') AS C$cat->idcatalogo, ";
                }
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro AS idcentro,
                                tran_100.fecha AS fecha_select,
                                tran_100.fecha,
                                 ";
                $consulta.=$subconsulta;
                $consulta .=" inv_def.agrupa AS agrupa  FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                tran_100k ON tran_100.trannum = tran_100k.trannum
                            WHERE
                                (inv_def.agrupa = 'VN')
                            GROUP BY tran_100.fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            }
            
        }
        
        public function getTotalesCategorias_chart($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $consulta="SELECT 
                            catalogo2.descrip, catalogo2.idcatalogo
                        FROM
                            tran_100k
                                INNER JOIN
                            invproducts ON invproducts.idproducto = tran_100k.idproducto
                                INNER JOIN
                            invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                INNER JOIN 
                                invcatalog AS catalogo2 ON catalogo2.idcatalogo= invcatalog.idnivel1
                            GROUP BY catalogo2.idcatalogo";
                $query = $this->db_b->query($consulta);
                $categorias = $query->result();
                
                $subconsulta ='';
                foreach($categorias as $cat){
                    $subconsulta.=" (SELECT 
                                        SUM(tran_100k.cantidad * tran_100k.precioneto)
                                    FROM
                                        tran_100k
                                            INNER JOIN
                                        tran_100 AS t100 ON t100.trannum = tran_100k.trannum
                                            INNER JOIN
                                        inv_def ON t100.idclase = inv_def.invclase
                                            INNER JOIN
                                        invproducts ON invproducts.idproducto = tran_100k.idproducto
                                            INNER JOIN
                                        invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                            INNER JOIN
                                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                                    WHERE
                                        invcatalog2.idcatalogo = $cat->idcatalogo
                                            AND tran_100k.trannum = t100.trannum
                                            AND inv_def.agrupa = 'VN' AND (t100.fecha between '$fechaini' AND '$fechafin')
                                    GROUP BY inv_def.agrupa) AS C$cat->idcatalogo, ";
                }
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro AS idcentro,
                                 ";
                $consulta.=$subconsulta;
                $consulta .=" inv_def.agrupa AS agrupa  FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                tran_100k ON tran_100.trannum = tran_100k.trannum
                                    INNER JOIN
                                invproducts ON invproducts.idproducto = tran_100k.idproducto
                                    INNER JOIN
                                invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                    INNER JOIN
                                invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                            WHERE
                                (inv_def.agrupa = 'VN') AND tran_100.fecha between '$fechaini' AND '$fechafin'
                            GROUP BY inv_def.agrupa";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            }
            
        }
        
		function getListadoProductosServicios($trannum, $idcentro, $idcatalogo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				#$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.idproducto, invproducts.tipo, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL(inv_stock.cantidad, 999999) AS cantidad, IFNULL(invproducts.costounitario, 0) AS costounitario, (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1) AS idbin, IFNULL(inv_stock.idbatch, 9999) AS idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro WHERE idcatalogo = $idcatalogo AND invproducts.estado = 1 AND invproducts.tipo = 4";
				$consulta = "
				SELECT 
				    invproducts.idcatalogo,
				    invproducts.tipotax,
				    invproducts.upp,
                    invproducts.xpos, 
				    invproducts.idproducto,
				    invproducts.tipo,
				    invproducts.tipotax,
				    invproducts.descrip,
				    invproducts.marca,
				    invproducts.imagen,
				    invproducts.um,
				    invproducts.modelo,
				    invproducts.precioventa,
				    invproducts.presenta,
				    invproducts.barcode,
				    invproducts.notas,
				    (999999) AS cantidad,
				    (0) AS costounitario,
				    (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1) AS idbin,
				    (9999) AS idbatch,
				    (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
				FROM
					invproducts
				WHERE
				    invproducts.idcatalogo = $idcatalogo
				        AND invproducts.estado = 1
				        AND invproducts.tipo = 4";
                
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoProductosServiciosMasVendidos($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.idproducto, invproducts.tipo, invproducts.descrip, invproducts.marca,
                    invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.presenta, invproducts.xpos, 
                    IFNULL((SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = $idcentro), 999999 ) AS cantidad,
                    IFNULL( invproducts.costounitario, 0 ) AS costounitario,
                    invlocations.idbin,
                    IFNULL( inv_batch.idbatch, 9999 ) AS idbatch,
                    COUNT( tran_100k.idrec ) AS totalvendidos 
                FROM invproducts 
                INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro 
                LEFT JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto 
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase  AND inv_def.agrupa = 'VN' 
                WHERE invproducts.estado = 1  AND (invproducts.tipo = 4 OR invproducts.tipo = 1) 
                GROUP BY invproducts.idproducto 
                HAVING cantidad > 0 
                ORDER BY totalvendidos DESC LIMIT 25";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoProductosMasVendidos($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.idproducto, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen,
                    invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.presenta, invproducts.xpos, 
                    IFNULL((SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = $idcentro), 999999 ) AS cantidad,
                    IFNULL( invproducts.costounitario, 0 ) AS costounitario,
                    invlocations.idbin,
                    IFNULL( inv_batch.idbatch, 9999 ) AS idbatch,
                    COUNT( tran_100k.idrec ) AS totalvendidos 
                FROM invproducts
                INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro
                LEFT JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase  AND inv_def.agrupa = 'VN' 
                WHERE invproducts.estado = 1  AND (invproducts.tipo = 4 OR invproducts.tipo = 1) 
                GROUP BY invproducts.idproducto 
                HAVING cantidad > 0
                ORDER BY totalvendidos DESC LIMIT 25";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoResumenVentas($fecha, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100k.idproducto, invproducts.descrip, invproducts.idcatalogo, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, tran_100k.precioneto, SUM((ABS(tran_100k.cantidad) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha = '$fecha' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoResumenVentasZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100k.idproducto, invproducts.descrip, invproducts.idcatalogo, ROUND(SUM(tran_100k.cantidad * -1)) AS total, tran_100k.precioneto, SUM(((tran_100k.cantidad * -1) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idproducto HAVING total > 0";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoLineasResumenVentas($fecha, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha = '$fecha' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
        function getListadoLineasResumenVentasZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}

        function getListadoResumenVentasTelefoniaZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100k.idproducto, invproducts.descrip, invcatalog.idnivel1 AS idcatalogo, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, tran_100k.precioneto, SUM((ABS(tran_100k.cantidad) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND ( invproducts.idproducto = 488 OR invproducts.idproducto = 1105 ) GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
                if ( $query->num_rows() > 0 ) {
                    $resultado = $query->result();
                } else $resultado = false;
                
                return $resultado;
			}
		}
		
		function getListadoTelefoniaZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invcatalog2.idcatalogo, invcatalog2.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND ( invproducts.idproducto = 488 OR invproducts.idproducto = 1105 ) GROUP BY invcatalog2.idcatalogo";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
        function getListadoProductosVendedores($fecha, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100k.idproducto, invproducts.descrip, tran_100k.idworker, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, tran_100k.precioneto, SUM((ABS(tran_100k.cantidad) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha = '$fecha' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idproducto, tran_100k.idworker ORDER BY idworker";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
        function getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100k.idproducto, invproducts.descrip, tran_100k.idworker, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, tran_100k.precioneto, SUM((ABS(tran_100k.cantidad) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idproducto, tran_100k.idworker ORDER BY idworker";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoVendedoresVentas($fecha, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi WHERE tran_100.fecha = '$fecha' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idworker ORDER BY descrip";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi WHERE tran_100.numz = '$numero_z' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja GROUP BY tran_100k.idworker ORDER BY descrip";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
        
		function getCategoriasVentas($fechaini,$fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT  tran_100.idcentro, tran_100.fecha, invproducts.idcatalogo, invcatalog.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha between '$fechaini'  and '$fechafin' GROUP BY invproducts.idcatalogo ORDER BY Promedio DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getVentasCat_Det($fechaini,$fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT  tran_100.idcentro, tran_100.fecha, invproducts.idcatalogo, invcatalog.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha between '$fechaini'  and '$fechafin' GROUP BY invproducts.idcatalogo, tran_100.idcentro,tran_100.fecha";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
		function getVentasCat_Con($fechaini,$fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT  tran_100.idcentro, tran_100.fecha, invproducts.idcatalogo, invcatalog.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE tran_100.fecha between '$fechaini'  and '$fechafin' GROUP BY invproducts.idcatalogo, tran_100.idcentro";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
		}
		
        function getHorasVentas($fechaini, $fechafin, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta="SELECT 
                        tran_100.idcentro,
                        SUM(if(HOUR(tran_100.ingresa) < 7, 1, 0)) AS per_6_30,
                        SUM(if(HOUR(tran_100.ingresa) = 7 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_7_00,
                        SUM(if(HOUR(tran_100.ingresa) = 7 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_7_30,
                        SUM(if(HOUR(tran_100.ingresa) = 8 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_8_00,
                        SUM(if(HOUR(tran_100.ingresa) = 8 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_8_30,
                        SUM(if(HOUR(tran_100.ingresa) = 9 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_9_00,
                        SUM(if(HOUR(tran_100.ingresa) = 9 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_9_30,
                        SUM(if(HOUR(tran_100.ingresa) = 10 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_10_00,
                        SUM(if(HOUR(tran_100.ingresa) = 10 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_10_30,
                        SUM(if(HOUR(tran_100.ingresa) = 11 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_11_00,
                        SUM(if(HOUR(tran_100.ingresa) = 11 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_11_30,
                        SUM(if(HOUR(tran_100.ingresa) = 12 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_12_00,
                        SUM(if(HOUR(tran_100.ingresa) = 12 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_12_30,
                        SUM(if(HOUR(tran_100.ingresa) = 13 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_13_00,
                        SUM(if(HOUR(tran_100.ingresa) = 13 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_13_30,
                        SUM(if(HOUR(tran_100.ingresa) = 14 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_14_00,
                        SUM(if(HOUR(tran_100.ingresa) = 14 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_14_30,
                        SUM(if(HOUR(tran_100.ingresa) = 15 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_15_00,
                        SUM(if(HOUR(tran_100.ingresa) = 15 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_15_30,
                        SUM(if(HOUR(tran_100.ingresa) = 16 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_16_00,
                        SUM(if(HOUR(tran_100.ingresa) = 16 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_16_30,
                        SUM(if(HOUR(tran_100.ingresa) = 17 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_17_00,
                        SUM(if(HOUR(tran_100.ingresa) = 17 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_17_30,
                        SUM(if(HOUR(tran_100.ingresa) = 18 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_18_00,
                        SUM(if(HOUR(tran_100.ingresa) = 18 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_18_30,
                        SUM(if(HOUR(tran_100.ingresa) = 19 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_19_00,
                        SUM(if(HOUR(tran_100.ingresa) = 19 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_19_30,
                        SUM(if(HOUR(tran_100.ingresa) = 20 and MINUTE(tran_100.ingresa) >= 0 and MINUTE(tran_100.ingresa) <= 30, 1, 0)) AS per_20_00,
                        SUM(if(HOUR(tran_100.ingresa) >= 20 and MINUTE(tran_100.ingresa) > 30 and MINUTE(tran_100.ingresa) <= 59, 1, 0)) AS per_20_30,
                        SUM(if(HOUR(tran_100.ingresa) >= 21, 1, 0)) AS per_21_00,
                        (SELECT COUNT(tran_100.ingresa)  FROM tran_100  as t100 WHERE t100.trannum=tran_100.trannum) as suma
                        FROM tran_100 
                        INNER JOIN
                            inv_def AS invdef ON tran_100.idclase = invdef.invclase
                            INNER JOIN tran_100k ON tran_100k.trannum= tran_100.trannum
                            INNER JOIN invproducts ON tran_100k.idproducto= invproducts.idproducto
                            WHERE
                            invdef.agrupa = 'VN'
                            AND invproducts.idcatalogo = $idcatalogo
                            AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                            GROUP BY tran_100.idcentro";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
			}
        }
		
        function ventasConsolidadoFechas($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia,  idcentro, fecha, SUM(hits) as totalHits  FROM daily_sales where fecha between '$fechaini' and '$fechafin' AND agrupa='VN' GROUP BY fecha";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function ventasConsolidado($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia, idcentro, fecha, SUM(hits) as totalHits  FROM daily_sales where fecha between '$fechaini' and '$fechafin' AND agrupa='VN' GROUP BY fecha, idcentro";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function ventasConsolidadoFechasHoras($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia, idcentro, fecha, SUM(hits) as totalHits, hora  FROM daily_sales where fecha between '$fechaini' and '$fechafin' AND agrupa='VN' GROUP BY fecha, hora ORDER BY fecha, hora ASC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function ventasConsolidadoFechasHoras_Detalle($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia, idcentro, fecha, SUM(hits) as totalHits, hora  FROM daily_sales where fecha between '$fechaini' and '$fechafin' AND agrupa='VN' GROUP BY fecha, idcentro, hora ORDER BY fecha, hora ASC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        } 
		
        function ventasConsolidado_Totales($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia, idcentro, fecha, SUM(hits) as totalHits, hora  FROM daily_sales where fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' GROUP BY idcentro";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function ventasConsolidado_Horas($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia, idcentro, fecha, SUM(hits) as totalHits, hora  FROM daily_sales where fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' GROUP BY hora ORDER BY  hora ASC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function ventasConsolidado_HorasDetalle($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(valventan) as totalVentas, SUM(valcosto) as totalCostos, date_format(daily_sales.fecha,'%w')  as dia,  idcentro, fecha, SUM(hits) as totalHits, hora  FROM daily_sales where fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' GROUP BY hora, idcentro ORDER BY  hora ASC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function ventasxvendedor($fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, tran_100.idcentro, tran_100k.idworker, ctauxi.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio  FROM   tran_100k  INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON ctauxi.idauxi= tran_100k.idworker WHERE tran_100.fecha = '$fecha' GROUP BY tran_100.idcentro , tran_100k.idworker ORDER BY Promedio DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function ventasVendedores($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, tran_100.idcentro, tran_100k.idworker, ctauxi.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio  FROM   tran_100k  INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON ctauxi.idauxi= tran_100k.idworker WHERE tran_100.fecha between '$fechaini' and '$fechafin' GROUP BY tran_100k.idworker ORDER BY Promedio DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function ventasxvendedores($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, tran_100.idcentro, tran_100k.idworker, ctauxi.descrip, ROUND(SUM(ABS(tran_100k.cantidad))) AS total, SUM((ABS(tran_100k.cantidad) * tran_100k.precioneto)) AS Promedio  FROM   tran_100k  INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON ctauxi.idauxi= tran_100k.idworker WHERE tran_100.fecha between '$fechaini' and '$fechafin' GROUP BY tran_100.idcentro , tran_100k.idworker ORDER BY Promedio DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function getTotalesIngresos($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, date_format(tran_100.fecha,'%w')  as dia, tran_100.idcentro,ROUND(SUM((tran_100k.cantidad*-1))) AS total, SUM(((tran_100k.cantidad*-1) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS totalVentas  FROM   tran_100k  INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase  WHERE tran_100.fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' AND tran_100.estatus = 1 GROUP BY tran_100.fecha ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function getTotalesIngresosDetalle($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, date_format(tran_100.fecha,'%w')  as dia, tran_100.idcentro, ROUND(SUM((tran_100k.cantidad*-1))) AS total, SUM(((tran_100k.cantidad*-1) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS totalVentas  FROM   tran_100  INNER JOIN tran_100k ON tran_100k.trannum = tran_100.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase  WHERE tran_100.fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' AND tran_100.estatus = 1 GROUP BY tran_100.idcentro, tran_100.fecha ORDER BY totalVentas DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
        function getIngresos($fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.fecha, date_format(tran_100.fecha,'%w')  as dia, tran_100.idcentro, caj_def.cajclase, caj_def.descrip AS formaPago, COUNT(tran_100c.itemline) AS cantidad, SUM((tran_100c.valor*-1) - ABS(tran_100c.vuelto)) AS Promedio FROM  tran_100  INNER JOIN tran_100c ON tran_100.trannum= tran_100c.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  AND caj_def.agrupa = invdef.agrupa WHERE tran_100.fecha = '$fecha' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function getIngresosInfo($fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.fecha, tran_100.idcentro, caj_def.cajclase, caj_def.descrip AS formaPago, COUNT(tran_100c.itemline) AS cantidad, SUM((tran_100c.valor*-1) - ABS(tran_100c.vuelto)) AS Promedio FROM tran_100 INNER JOIN tran_100c ON tran_100.trannum= tran_100c.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  WHERE tran_100.fecha = '$fecha' GROUP BY tran_100.idcentro, caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function getSumasIngresos($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  tran_100.fecha, date_format(tran_100.fecha,'%w')  as dia, tran_100.idcentro,ROUND(SUM((tran_100k.cantidad*-1))) AS total, SUM(((tran_100k.cantidad*-1) * (tran_100k.precioneto + (tran_100k.precioneto * (tran_100k.tax1 / 100))))) AS totalVentas  FROM   tran_100k  INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase  WHERE tran_100.fecha between '$fechaini' and '$fechafin'  AND agrupa='VN' AND tran_100.estatus = 1 GROUP BY tran_100.idcentro ORDER BY totalVentas DESC";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function getIngresosT($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.fecha, date_format(tran_100.fecha,'%w')  as dia, tran_100.idcentro, caj_def.cajclase, caj_def.descrip AS formaPago, COUNT(tran_100c.itemline) AS cantidad, SUM((tran_100c.valor*-1) - ABS(tran_100c.vuelto)) AS Promedio FROM  tran_100  INNER JOIN tran_100c ON tran_100.trannum= tran_100c.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  AND caj_def.agrupa = invdef.agrupa WHERE tran_100.fecha between '$fechaini' and '$fechafin'  AND invdef.agrupa='VN'  GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
		function getIngresosInfoT($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.fecha, tran_100.idcentro, caj_def.cajclase, caj_def.descrip AS formaPago, COUNT(tran_100c.itemline) AS cantidad, SUM((tran_100c.valor*-1) - ABS(tran_100c.vuelto)) AS Promedio FROM tran_100 INNER JOIN tran_100c ON tran_100.trannum= tran_100c.trannum INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  WHERE tran_100.fecha  between '$fechaini' and '$fechafin'   AND invdef.agrupa='VN'  GROUP BY tran_100.idcentro, caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
		
        function getCate_ventas($fechaini, $fechafin, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($idcentro==99999){
                    $consulta = "SELECT invcatalog.idnivel1 AS ID, CONCAT('C', invcatalog.idnivel1) AS valueField, invcatalog2.descrip AS name FROM inv_prostats INNER JOIN invproducts ON invproducts.idproducto = inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1 INNER JOIN tran_100k ON tran_100k.idproducto= invproducts.idproducto INNER JOIN tran_100 ON tran_100.trannum= tran_100k.trannum WHERE agrupa = 'VN' and tran_100.fecha  between '$fechaini' and '$fechafin' GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
                }else{
                    $consulta = "SELECT invcatalog.idnivel1 AS ID, CONCAT('C', invcatalog.idnivel1) AS valueField, invcatalog2.descrip AS name FROM inv_prostats INNER JOIN invproducts ON invproducts.idproducto = inv_prostats.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1 INNER JOIN tran_100k ON tran_100k.idproducto= invproducts.idproducto INNER JOIN tran_100 ON tran_100.trannum= tran_100k.trannum WHERE agrupa = 'VN' and tran_100.fecha  between '$fechaini' and '$fechafin' AND tran_100.idcentro = $idcentro GROUP BY invcatalog.idnivel1 ORDER BY invcatalog.idnivel1";
                }
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        
		public function getCategoriasLineas($fechaini, $fechafin, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta="SELECT 
                            catalogo2.descrip, catalogo2.idcatalogo
                        FROM
                            tran_100k
                                INNER JOIN
                            invproducts ON invproducts.idproducto = tran_100k.idproducto
                                INNER JOIN
                            invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                INNER JOIN 
                                invcatalog AS catalogo2 ON catalogo2.idcatalogo= invcatalog.idnivel1
                            GROUP BY catalogo2.idcatalogo";
                $query = $this->db_b->query($consulta);
                $categorias = $query->result();
                
                $subconsulta ='';
                foreach($categorias as $cat){
                    $subconsulta.=" (SELECT 
                        SUM(tran_100k.cantidad * tran_100k.precioneto)
                    FROM
                    tran_100k
                    INNER JOIN
                    tran_100 AS t100 ON t100.trannum = tran_100k.trannum
                    INNER JOIN
                    inv_def ON t100.idclase = inv_def.invclase
                    INNER JOIN
                    invproducts ON invproducts.idproducto = tran_100k.idproducto
                    INNER JOIN
                    invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                    INNER JOIN
                    invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                    WHERE
                    invcatalog2.idcatalogo = $cat->idcatalogo
                    AND tran_100k.trannum = t100.trannum ";
                    if($idcentro!=99999){
                        $subconsulta.=" AND t100.idcentro = $idcentro ";
                    }
                    $subconsulta.=" AND t100.fecha = fecha_select
                    AND inv_def.agrupa = 'VN') AS C$cat->idcatalogo, ";
                }
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro AS idcentro,
                                tran_100.fecha AS fecha_select,
                                tran_100.fecha,
                                 ";
                $consulta.=$subconsulta;
                $consulta .=" inv_def.agrupa AS agrupa  FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                tran_100k ON tran_100.trannum = tran_100k.trannum
                            WHERE
                                (inv_def.agrupa = 'VN')  AND tran_100.fecha between '$fechaini' and '$fechafin' ";
                
                if($idcentro!=99999){
                    $consulta.=" AND tran_100.idcentro = $idcentro ";
                }
                $consulta .="  GROUP BY tran_100.fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            }
        }
		
		public function getTotalesCategorias_consolidado($fechaini, $fechafin,$idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $consulta="SELECT 
                            catalogo2.descrip, catalogo2.idcatalogo
                        FROM
                            tran_100k
                                INNER JOIN
                            invproducts ON invproducts.idproducto = tran_100k.idproducto
                                INNER JOIN
                            invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                INNER JOIN 
                                invcatalog AS catalogo2 ON catalogo2.idcatalogo= invcatalog.idnivel1
                            GROUP BY catalogo2.idcatalogo";
                $query = $this->db_b->query($consulta);
                $categorias = $query->result();
                
                $subconsulta ='';
                foreach($categorias as $cat){
                    $subconsulta.=" (SELECT 
                                        SUM(tran_100k.cantidad * tran_100k.precioneto)
                                    FROM
                                        tran_100k
                                            INNER JOIN
                                        tran_100 AS t100 ON t100.trannum = tran_100k.trannum
                                            INNER JOIN
                                        inv_def ON t100.idclase = inv_def.invclase
                                            INNER JOIN
                                        invproducts ON invproducts.idproducto = tran_100k.idproducto
                                            INNER JOIN
                                        invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                            INNER JOIN
                                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                                    WHERE
                                        invcatalog2.idcatalogo = $cat->idcatalogo
                                            AND tran_100k.trannum = t100.trannum";
                    if($idcentro!=99999){
                        $subconsulta.=" AND t100.idcentro = $idcentro ";
                    }
                    $subconsulta.=" AND inv_def.agrupa = 'VN' AND (t100.fecha between '$fechaini' AND '$fechafin')  
                                    GROUP BY inv_def.agrupa) AS C$cat->idcatalogo, ";
                }
                $consulta = "SELECT 
                                tran_100.trannum,
                                tran_100.idcentro AS idcentro,
                                 ";
                $consulta.=$subconsulta;
                $consulta .=" inv_def.agrupa AS agrupa  FROM
                                tran_100
                                    INNER JOIN
                                inv_def ON tran_100.idclase = inv_def.invclase
                                    INNER JOIN
                                tran_100k ON tran_100.trannum = tran_100k.trannum
                                    INNER JOIN
                                invproducts ON invproducts.idproducto = tran_100k.idproducto
                                    INNER JOIN
                                invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                    INNER JOIN
                                invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                            WHERE
                                (inv_def.agrupa = 'VN') AND tran_100.fecha between '$fechaini' AND '$fechafin' ";
                if($idcentro!=99999){
                    $consulta.=" AND tran_100.idcentro = $idcentro ";
                }
                
                $consulta .=" GROUP BY inv_def.agrupa";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            }
        }
		
		function getFormatoPrintTransaccion($idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT formname FROM gforms WHERE notas = '$idclase'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
					$appname = $resultado['formname'];
				}else{
					$appname = '';
				}
				return $appname;
            }
		}
		
		function getFormaDePagoTrannum($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.descrip AS descrip FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum LIMIT 1";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
					$descrip = $resultado['descrip'];
				}else{
					$descrip = '';
				}
				return $descrip;
            }
		}
		
		function getFormaDePagoCreditoTrannum($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.descrip AS descrip FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase AND caj_def.creditchk = 1 WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
					$descrip = $resultado['descrip'];
				}else{
					$descrip = '';
				}
				return $descrip;
            }
		}
		
        function getFormaDePagoOrdenes($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.descrip AS descrip FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
					$descrip = $resultado['descrip'];
				}else{
					$descrip = '';
				}
				return $descrip;
            }
		}
	
		function getFormaDePagoCreditoPeriodo($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor  FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase WHERE caj_def.creditchk = 1 AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}
		
        function getDetalleIngresoReporteDeVentasDiarias($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor  FROM tran_100 INNER JOIN tran_100c ON tran_100.trannum = tran_100c.trannum INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}

        function getDetalleIngresoReporteDeVentasDiariasNew($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(ABS(tran_100c.valor)-ABS(tran_100c.vuelto)) as valor  FROM tran_100 INNER JOIN tran_100c ON tran_100.trannum = tran_100c.trannum INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}
	
		function getFormaDePagoCreditoPeriodo_Retencion($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor  FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase AND caj_def.creditchk = 1 WHERE tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}
		
	
		function getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor  FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase WHERE caj_def.creditchk = 1 AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.numx = $numero_x AND tran_100.numz = $numero_z AND tran_100.fecha = '$fechaactual' GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}
		
        function getFormaDePagoCreditoCorteZ($idcentro, $idcaja, $numero_z, $fechaactual){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip AS descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor  FROM tran_100 INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase WHERE  tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.numz = $numero_z AND tran_100.fecha = '$fechaactual' AND caj_def.creditchk = 1 GROUP BY caj_def.cajclase";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				return $resultado;
            }
		}
		
        
		function insertarRegistrosCorteX($fechaactual, $idcentro, $idcaja, $datosPagos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$cont = count($datosPagos);
				
				$SQLNum   = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum  = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
				$fecha_actual = $fechaactual . ' 00:00:00';
				$QueryInsert=0;
				for($i=0; $i<$cont; $i++){
					$cajclase = $datosPagos[$i]['cajclase'];
					$totalmov = $datosPagos[$i]['totalmov'];
					$total    = $datosPagos[$i]['total'];
					
					$SQLCajclase    = "SELECT creditchk, alcuadre FROM caj_def WHERE cajclase = $cajclase";
					$QueryCajclase  = $this->db_b->query($SQLCajclase);
					$QueryClase     = $QueryCajclase->row_array();
                    
                    $valor      = 0;
                    $vuelto     = 0;
                    $creditchk  = (int) $QueryClase['creditchk'];
                    $alcuadre   = (int) $QueryClase['alcuadre'];
                    
                    if($creditchk == 0){
				        $SQL3   = "SELECT COUNT(tran_100c.cajclase) AS totalsys, SUM(valor) AS valor, SUM(vuelto) AS vuelto, caj_def.alcuadre FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100.fecha = '$fechaactual' AND tran_100.idcentro = '$idcentro' AND tran_100.idcaja = '$idcaja' AND tran_100c.cajclase = '$cajclase' AND tran_100.numx = '$numero_x' AND tran_100.numz = '$numero_z'";
                        $Query3 = $this->db_b->query($SQL3);

                        if($Query3->num_rows() > 0){
                            $QueryPago = $Query3->row_array();
                            $valor     = $QueryPago['valor'];
                            $vuelto    = $QueryPago['vuelto'];
                        
                            $totalsys = ($alcuadre == 1) ? 1 : $QueryPago['totalsys'];
                        }else{
                            $totalsys = ($alcuadre == 1) ? 1 : 0;
                        }
                    }else{
                        $SQL3 = "SELECT COUNT(tran_100.trannum) AS totalsys, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) * -1) AS valor FROM tran_100 WHERE tran_100.fecha = '$fechaactual' AND tran_100.idcentro = '$idcentro' AND tran_100.idcaja = '$idcaja' AND tran_100.numy = '$cajclase' AND tran_100.numx = '$numero_x' AND tran_100.numz = '$numero_z'";
                        $Query3 = $this->db_b->query($SQL3);
                        
                        if($Query3->num_rows() > 0){
                            $QueryPago = $Query3->row_array();
                            $valor     = $QueryPago['valor'];
                            $vuelto    = 0;
                            $totalsys  = $QueryPago['totalsys'];
                        }
                    }
					
					$valor    = number_format(round($valor, 2), 2, '.', '') * -1;
					$vuelto   = number_format(round($vuelto, 2), 2, '.', '') * -1;
					$valorSys = $valor - $vuelto;
					
					$valorSys = number_format($valorSys, 2, '.', '');
					$totalsys = number_format($totalsys, 2, '.', '');
					
					//Validación Corte X
					if($total != 0 || $totalsys != 0){
						$this->db_b->set('idrec', 0);
						$this->db_b->set('numx', $numero_x);
						$this->db_b->set('numz', $numero_z);
						$this->db_b->set('descrip', 'Corte X');
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('idcaja', $idcaja);
						$this->db_b->set('fechahora', $fecha_actual);
						$this->db_b->set('cajclase', $cajclase);
						$this->db_b->set('tipo', 1);
						$this->db_b->set('valorusr', $total);
						$this->db_b->set('countuser', $totalmov);
						$this->db_b->set('valorsys', $valorSys);
						$this->db_b->set('countsys', $totalsys);
						$this->db_b->set('estatus', 1);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
						$QueryInsert = $this->db_b->insert('tran_100z');
					}
				}
							
				return $QueryInsert;
			}
		}
		
		function getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100z.*, caj_def.descrip AS formapago FROM tran_100z INNER JOIN caj_def ON tran_100z.cajclase = caj_def.cajclase WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numx = '$numero_x' AND tran_100z.numz = '$numero_z' AND tran_100z.tipo = 1";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
            }
		}
		
        function getInformacionCorteXZOI($idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100z.*, caj_def.descrip AS formapago FROM tran_100z INNER JOIN caj_def ON tran_100z.cajclase = caj_def.cajclase WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numx = '$numero_x' AND tran_100z.numz = '$numero_z' AND (tran_100z.tipo = 1 OR tran_100z.tipo = 11 OR tran_100z.tipo = 12)";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
            }
		}

        /*
        
        function updateNumeroCorteX($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
                $consulta  = "SELECT numx FROM ctcajas WHERE idcaja = $idcaja";
                $query     = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				$numx = $resultado['numx'] + 1;
				
				$this->db_b->set('numx', $numx);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idcaja', $idcaja);
				$query = $this->db_b->update('ctcajas');
				
				return $numx;
                
            }
		}

        */

		function updateNumeroCorteX($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
                $consulta  = "SELECT * FROM tran_100z WHERE idcaja = $idcaja AND descrip = 'Corte X' ORDER BY ingresa desc LIMIT 1";
                $query     = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				$idrec = $resultado['idrec'];
				
                //INDICA SI YA SE HA IMPRESO EL CORTE X
				$this->db_b->set('notas', 1);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				$query = $this->db_b->update('tran_100z');
				
				return $query;
                
            }
		}

        function verificarImpresionCorteX($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
                $consulta  = "SELECT notas FROM tran_100z WHERE idcaja = $idcaja AND descrip = 'Corte X' ORDER BY ingresa desc LIMIT 1";
                $query     = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				$notas = $resultado['notas'];
				
                if($notas == 1){
                    return true;
                }else{
                    return false;
                }
            }
		}

        //PARA MODIFICAR EL NUM X DESDE EL MODULO DE FACTURACION EN LUGAR DE DESDE FORMATO DE CORTES
        function actualizarNumeroCorteX($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
                $consulta  = "SELECT numx FROM ctcajas WHERE idcaja = $idcaja";
                $query     = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				$numx = $resultado['numx'] + 1;
				
				$this->db_b->set('numx', $numx);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idcaja', $idcaja);
				$query = $this->db_b->update('ctcajas');
				
				return $numx;
            }
		}
		
		function getInformacionCajaFac($idcaja, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT ucajera, bfecha, efecha, cajaopen, cajafondo, cajafecha, numx, numz, notas FROM ctcajas WHERE idcaja = $idcaja AND idcentro = $idcentro";
				$query = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				return $resultado;
            }
		}
		
        function insertAperturaDeCaja($idcentro, $idcaja, $fechaopen, $observaciones, $fondocaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$consulta = "SELECT idrec FROM tran_100z WHERE idcaja = $idcaja AND idcentro = $idcentro AND tipo = 2 AND fechahora LIKE '%$fechaopen%' LIMIT 1";
				$query = $this->db_b->query($consulta);
				
				if($query->num_rows()== 0){
					$SQLCaja = "SELECT numz FROM ctcajas WHERE idcaja = $idcaja AND idcentro = $idcentro";
					$QueryCaja = $this->db_b->query($SQLCaja);
					$ResultCaja = $QueryCaja->row_array();

					$num_Z = $ResultCaja['numz'] + 1;

					$this->db_b->set('numx', 1);
					$this->db_b->set('numz', $num_Z);
					$this->db_b->set('cajafecha', $fechaopen);
					$this->db_b->set('cajaopen', 1);
					$this->db_b->set('cajafondo', $fondocaja);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('idcentro', $idcentro);
					$this->db_b->where('idcaja', $idcaja);
					$this->db_b->update('ctcajas');
                    
                    $fecha_actual = $fechaopen . ' 00:00:00';
                    
					$this->db_b->set('idrec', 0);
					$this->db_b->set('numx', 1);
					$this->db_b->set('numz', $num_Z);
					$this->db_b->set('idcentro', $idcentro);
					$this->db_b->set('idcaja', $idcaja);
					$this->db_b->set('valorusr', $fondocaja);
					$this->db_b->set('fechahora', $fecha_actual);
					$this->db_b->set('tipo', 0);
					$this->db_b->set('descrip', 'Apertura de Caja');
					$this->db_b->set('notas', $observaciones);
					$this->db_b->set('estatus', 1);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$this->db_b->insert('tran_100z');

					$consulta = "SELECT ucajera, bfecha, efecha, cajaopen, cajafondo, cajafecha, numx, numz FROM ctcajas WHERE idcaja = $idcaja AND idcentro = $idcentro";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
				}else{
					$resultado = FALSE;
				}
				
				return $resultado;
			}
		}
		
		function getInformacionTotalCorteZ($idcentro, $idcaja, $numz){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT tran_100z.cajclase, tran_100z.numx, caj_def.descrip, valorusr AS total FROM tran_100z INNER JOIN caj_def ON tran_100z.cajclase = caj_def.cajclase WHERE tran_100z.idcaja = $idcaja AND tran_100z.idcentro = $idcentro AND tran_100z.numz = $numz AND tipo = 1";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}

        function getRangoFechasCaja($idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT bfecha, efecha FROM ctcajas WHERE idcaja = $idcaja";
				$query = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				return $resultado;
			}
		}
		
		function insertarRegistrosCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$SQLNum   = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum  = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
				$SQL3 = "SELECT cajclase, SUM(valorusr) AS totaluser, SUM(countuser) AS totalcontuser, SUM(valorsys) AS totalsys, SUM(countsys) AS totalcontsys FROM tran_100z WHERE idcaja = $idcaja AND idcentro = $idcentro AND numz = $numero_z AND tipo = 1 GROUP BY cajclase";
				$Query3 = $this->db_b->query($SQL3);
				$informacion = $Query3->result();
				
				$fecha_actual = $fechaactual . ' 00:00:00';
				
				foreach($informacion as $info){
					$this->db_b->set('idrec', 0);
					$this->db_b->set('numx', $numero_x);
					$this->db_b->set('numz', $numero_z);
					$this->db_b->set('idcentro', $idcentro);
					$this->db_b->set('idcaja', $idcaja);
					$this->db_b->set('descrip', 'Corte Z');
					$this->db_b->set('fechahora', $fecha_actual);
					$this->db_b->set('cajclase', $info->cajclase);
					$this->db_b->set('tipo', 2);
					$this->db_b->set('valorusr', $info->totaluser);
					$this->db_b->set('countuser', $info->totalcontuser);
					$this->db_b->set('valorsys', $info->totalsys);
					$this->db_b->set('countsys', $info->totalcontsys);
					$this->db_b->set('estatus', 1);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100z');
				}
							
				return $query;
			}
		}
		
		function getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100z.*, caj_def.descrip AS formapago FROM tran_100z INNER JOIN caj_def ON tran_100z.cajclase = caj_def.cajclase WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numz = '$numero_z' AND tran_100z.tipo = 2";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}

        function getInformacionCorteFinalZOI($idcentro, $idcaja, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100z.*, caj_def.descrip AS formapago FROM tran_100z INNER JOIN caj_def ON tran_100z.cajclase = caj_def.cajclase WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numz = '$numero_z' AND (tran_100z.tipo = 2 OR tran_100z.tipo = 11 OR tran_100z.tipo = 12)"; 
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}
		
		function updateCierreDeCaja($idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                /*
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('cajaopen', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idcentro', $idcentro);
				$this->db_b->where('idcaja', $idcaja);
				$this->db_b->update('ctcajas');
                */
			}
		}

        function actualizarCierreDeCaja($idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('cajaopen', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idcentro', $idcentro);
				$this->db_b->where('idcaja', $idcaja);
				$this->db_b->update('ctcajas');
			}
		}
		
		function validateInsertCorteX($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$SQLNum = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
				$consulta = "SELECT trannum FROM tran_100 WHERE idcentro = $idcentro AND idcaja = $idcaja AND fecha = '$fechaactual' AND estatus = 0 AND numx = '$numero_x' AND numz = '$numero_z'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows()== 0){
					$resultado = true;
				}else{
					$resultado = false;
				}
				
				return $resultado;
			}
		}

        function validateIngresoCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$SQLNum   = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum  = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
                $consulta = "SELECT trannum FROM tran_100 WHERE idcentro = $idcentro AND idcaja = $idcaja AND fecha = '$fechaactual' AND estatus = 1 AND numx = '$numero_x' AND numz = '$numero_z'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
                    $consulta = "SELECT idrec FROM tran_100z WHERE idcentro = $idcentro AND idcaja = $idcaja AND numx = '$numero_x' AND numz = '$numero_z' AND fechahora = '$fechaactual 00:00:00' AND tipo = 1";
                    $query    = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        return true;
                    }else{
                        return false;
                    }
                }else return true;
			}
		}
		
		function insertAperturaGaveta($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$SQLNum = "SELECT numx, numz FROM ctcajas WHERE idcaja = $idcaja";
                $Querynum = $this->db_b->query($SQLNum);
				$infoNum = $Querynum->row_array();
				
				$numero_x = $infoNum['numx'];
				$numero_z = $infoNum['numz'];
				
                $fecha_actual = $fechaactual . ' 00:00:00';
                
				$this->db_b->set('idrec', 0);
				$this->db_b->set('numx', $numero_x);
				$this->db_b->set('numz', $numero_z);
				$this->db_b->set('idcentro', $idcentro);
				$this->db_b->set('idcaja', $idcaja);
				$this->db_b->set('fechahora', $fecha_actual);
				$this->db_b->set('tipo', 9);
				$this->db_b->set('descrip', 'Apertura de Gaveta');
				$this->db_b->set('estatus', 1);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('tran_100z');
				
				return $query;
			}
		}
		
		function getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100z.*, DATE_FORMAT(tran_100z.ingresa, '%h:%i:%s %p') AS horaActividad, gusers.descrip AS nameuser FROM tran_100z INNER JOIN gusers ON tran_100z.whodidit = gusers.iduser WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numx = '$numero_x' AND tran_100z.numz = '$numero_z' AND tran_100z.tipo = 9";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}
		
        function getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100z.*, gusers.descrip AS nameuser FROM tran_100z INNER JOIN gusers ON tran_100z.whodidit = gusers.iduser WHERE tran_100z.idcentro = $idcentro AND tran_100z.idcaja = $idcaja AND tran_100z.numz = '$numero_z' AND tran_100z.tipo = 9";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}
		
		function getListadoClientesPorSucursal($idcps, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $consulta = "SELECT ctauxi.idauxi, IFNULL((SELECT invdef.invclase FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase WHERE invdef.agrupa = 'VN' AND invdef.caopera = 1 AND t100.estatus = 1 AND t100.idcps = ctauxi.idauxi ORDER BY t100.fecha DESC LIMIT 1), '') AS invclase, IFNULL(ctauximulti.idrec, '0') AS idrec, ctauxi.descrip, IFNULL(ctauxi.grupo, '') AS grupo, IFNULL(ctauximulti.descrip, '') AS sucursal, CONCAT(ctauxi.descrip,' ',IFNULL(ctauxi.grupo, ''),' ',IFNULL(ctauximulti.descrip, '')) AS descripsearch, ctauxi.limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi LEFT JOIN ctauximulti ON ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.idgvar = 2 WHERE ctauxi.idauxidef = 2 AND ctauxi.idcps = $idcps AND ctauxi.estado = $estado ORDER BY ctauxi.descrip, ctauximulti.descrip;";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }else{
                    $consulta = "SELECT ctauxi.idauxi, IFNULL((SELECT invdef.invclase FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase WHERE invdef.agrupa = 'VN' AND invdef.caopera = 1 AND t100.estatus = 1 AND t100.idcps = ctauxi.idauxi ORDER BY t100.fecha DESC LIMIT 1), '') AS invclase, IFNULL(ctauximulti.idrec, '0') AS idrec, ctauxi.descrip, IFNULL(ctauxi.grupo, '') AS grupo, IFNULL(ctauximulti.descrip, '') AS sucursal, CONCAT(ctauxi.descrip,' ',IFNULL(ctauxi.grupo, ''),' ',IFNULL(ctauximulti.descrip, '')) AS descripsearch, ctauxi.limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi LEFT JOIN ctauximulti ON ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.idgvar = 2 WHERE ctauxi.idauxidef = 2 AND ctauxi.estado = $estado ORDER BY ctauxi.descrip, ctauximulti.descrip;";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
		function getListadoClientesPorSucursalUpdate($idcps, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $consulta = "SELECT ctauxi.idauxi, IFNULL(ctauximulti.idrec, '0') AS idrec, ctauxi.descrip, IFNULL(ctauxi.grupo, '') AS grupo, IFNULL(ctauximulti.descrip, '') AS sucursal, CONCAT(ctauxi.descrip,' ',IFNULL(ctauxi.grupo, ''),' ',IFNULL(ctauximulti.descrip, '')) AS descripsearch, ctauxi.limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi LEFT JOIN ctauximulti ON ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.idgvar = 2 WHERE ctauxi.idauxidef = 2 AND ctauxi.idcps = $idcps AND ctauxi.estado = $estado ORDER BY ctauxi.descrip, ctauximulti.descrip;";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }else{
                    $consulta = "SELECT ctauxi.idauxi, IFNULL(ctauximulti.idrec, '0') AS idrec, ctauxi.descrip, IFNULL(ctauxi.grupo, '') AS grupo, IFNULL(ctauximulti.descrip, '') AS sucursal, CONCAT(ctauxi.descrip,' ',IFNULL(ctauxi.grupo, ''),' ',IFNULL(ctauximulti.descrip, '')) AS descripsearch, ctauxi.limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi LEFT JOIN ctauximulti ON ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.idgvar = 2 WHERE ctauxi.idauxidef = 2 AND ctauxi.estado = $estado ORDER BY ctauxi.descrip, ctauximulti.descrip;";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
		function getClientesFacturacionUpdate($idcps, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.nrc, ctauxi.nit, ctauxi.dui, IFNULL(ctauxi.grupo, '') AS grupo FROM ctauxi WHERE ctauxi.idauxidef = 2 AND ctauxi.idcps = $idcps AND ctauxi.estado = $estado ORDER BY ctauxi.descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }else{
                    $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.nrc, ctauxi.nit, ctauxi.dui, IFNULL(ctauxi.grupo, '') AS grupo FROM ctauxi WHERE ctauxi.idauxidef = 2 AND ctauxi.estado = $estado ORDER BY ctauxi.descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
		function getClientesBusquedaFacturacion($idcps, $valor, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $consulta = "SELECT 
                        a.idauxi, a.descrip, a.nrc, IFNULL(b.idrec, '') AS idrec, a.direccion, IFNULL(b.notas, '') AS direccion_c, IFNULL(a.grupo, '') AS grupo 
                    FROM ctauxi a
                    LEFT JOIN ctauximulti b ON a.idauxi = b.idauxi AND b.notas != '' AND b.estatus = 1 AND b.idgvar = 2 
                    WHERE a.idauxidef = 2 AND a.estado = 1 AND a.idcps = $idcps 
                    AND (a.descrip LIKE '%$valor%' OR a.nrc LIKE '%$valor%' OR a.dui LIKE '%$valor%' OR a.telefono LIKE '%$valor%' OR b.notas LIKE '%$valor%') 
                    ORDER BY a.descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }else{
                    //$consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.nrc, ctauxi.direccion, IFNULL(ctauxi.grupo, '') AS grupo FROM ctauxi WHERE ctauxi.idauxidef = 2 AND ctauxi.descrip LIKE '%$valor%' AND ctauxi.estado = $estado ORDER BY ctauxi.descrip";
                    $consulta = "SELECT 
                        a.idauxi, a.descrip, a.nrc, IFNULL(b.idrec, '') AS idrec, a.direccion, IFNULL(b.notas, '') AS direccion_c, IFNULL(a.grupo, '') AS grupo 
                    FROM ctauxi a
                    LEFT JOIN ctauximulti b ON a.idauxi = b.idauxi AND b.notas != '' AND b.estatus = 1 AND b.idgvar = 2 
                    WHERE a.idauxidef = 2 AND a.estado = $estado 
                    AND (a.descrip LIKE '%$valor%' OR a.nrc LIKE '%$valor%' OR a.dui LIKE '%$valor%' OR a.telefono LIKE '%$valor%' OR b.notas LIKE '%$valor%') 
                    ORDER BY a.descrip";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
        function getClientesBusquedaCreacion($idcps, $valor, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->session->userdata('opcionmenu') == 1){
                    $this->db_b->select('a.idauxi, a.descrip, a.nit, a.dui, a.telefono, a.correo, a.idtipo, a.giro');
                    $this->db_b->select('a.idzip, a.nrc, IFNULL(b.idrec, "") AS idrec, a.direccion, IFNULL(b.notas, "") AS direccion_c, IFNULL(a.grupo, "") AS grupo');
                    if ($this->db_b->field_exists('dte_giro', 'ctauxi')){
                        $this->db_b->select('a.dte_giro');
                    } else $this->db_b->select("'' AS dte_giro");
                    $this->db_b->from('ctauxi a');
                    $this->db_b->join('ctauximulti b', 'a.idauxi = b.idauxi AND b.idgvar = 2 AND b.notas != "" AND b.estatus = 1', 'LEFT');
                    $this->db_b->where("a.idauxidef", 2);
                    $this->db_b->where("a.idcps", $idcps);
                    $this->db_b->where("a.estado", $estado);
                    $this->db_b->where("(a.descrip LIKE '%$valor%' OR a.nrc LIKE '%$valor%' OR a.dui LIKE '%$valor%' OR a.telefono LIKE '%$valor%' OR b.notas LIKE '%$valor%')");
                    $this->db_b->order_by('a.descrip');
                    $query = $this->db_b->get();
                    $resultado = $query->result();
                }else{
                    $this->db_b->select('a.idauxi, a.descrip, a.nit, a.dui, a.telefono, a.correo, a.idtipo, a.giro');
                    $this->db_b->select('a.idzip, a.nrc, IFNULL(b.idrec, "") AS idrec, a.direccion, IFNULL(b.notas, "") AS direccion_c, IFNULL(a.grupo, "") AS grupo');
                    if ($this->db_b->field_exists('dte_giro', 'ctauxi')){
                        $this->db_b->select('a.dte_giro');
                    } else $this->db_b->select("'' AS dte_giro");
                    $this->db_b->from('ctauxi a');
                    $this->db_b->join('ctauximulti b', 'a.idauxi = b.idauxi AND b.idgvar = 2 AND b.notas != "" AND b.estatus = 1', 'LEFT');
                    $this->db_b->where("a.idauxidef", 2);
                    $this->db_b->where("a.estado", $estado);
                    $this->db_b->where("(a.descrip LIKE '%$valor%' OR a.nrc LIKE '%$valor%' OR a.dui LIKE '%$valor%' OR a.telefono LIKE '%$valor%' OR b.notas LIKE '%$valor%')");
                    $this->db_b->order_by('a.descrip');
                    $query = $this->db_b->get();
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
        function getClientePredeterminado($idcps, $idcentro, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('a.valor_num');
                $this->db_b->from("gvars a");
                $this->db_b->where("a.nombre", 'pos_cliente0'.$idcentro);
                $this->db_b->limit(1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() == 0) {
                    $idauxi = 0;                    
                } else {
                    $info = $datos->row_array();
                    $idauxi = $info['valor_num'];
                }

                if($this->session->userdata('opcionmenu') == 1){
                    // $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.nit, ctauxi.dui, ctauxi.telefono, ctauxi.correo, ctauxi.idtipo, ctauxi.giro, ctauxi.idzip, ctauxi.nrc, IFNULL(ctauximulti.idrec, '') AS idrec, ctauxi.direccion, IFNULL(ctauximulti.notas, '') AS direccion_c, IFNULL(ctauxi.grupo, '') AS grupo FROM ctauxi
                    // LEFT JOIN ctauximulti ON idgvar = 2 AND ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.notas != '' AND ctauximulti.estatus = 1 
                    // WHERE ctauxi.idauxidef = 2 AND ctauxi.idcps = $idcps AND ctauxi.estado = $estado AND (ctauxi.idauxi = '$idauxi') ORDER BY ctauxi.descrip";
                    // $query = $this->db_b->query($consulta);
                    // $resultado = $query->result();

                    $this->db_b->select('a.idauxi, a.descrip, a.nit, a.dui, a.telefono, a.correo, a.idtipo, a.giro');
                    $this->db_b->select('a.idzip, a.nrc, IFNULL(b.idrec, "") AS idrec, a.direccion, IFNULL(b.notas, "") AS direccion_c, IFNULL(a.grupo, "") AS grupo');
                    if ($this->db_b->field_exists('dte_giro', 'ctauxi')){
                        $this->db_b->select('a.dte_giro');
                    } else $this->db_b->select("'' AS dte_giro");
                    $this->db_b->from('ctauxi a');
                    $this->db_b->join('ctauximulti b', 'a.idauxi = b.idauxi AND b.idgvar = 2 AND b.notas != "" AND b.estatus = 1', 'LEFT');
                    $this->db_b->where("a.idauxidef", 2);
                    $this->db_b->where("a.idcps", $idcps);
                    $this->db_b->where("a.estado", $estado);
                    $this->db_b->where("a.idauxi", $idauxi);
                    $this->db_b->order_by('a.descrip');
                    $query = $this->db_b->get();
                    $resultado = $query->result();
                }else{
                    // $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.nit, ctauxi.dui, ctauxi.telefono, ctauxi.correo, ctauxi.idtipo, ctauxi.giro, ctauxi.idzip, ctauxi.nrc, IFNULL(ctauximulti.idrec, '') AS idrec, ctauxi.direccion, IFNULL(ctauximulti.notas, '') AS direccion_c, IFNULL(ctauxi.grupo, '') AS grupo FROM ctauxi
                    //              LEFT JOIN ctauximulti ON idgvar = 2 AND ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.notas != '' AND ctauximulti.estatus = 1 
                    //              WHERE ctauxi.idauxidef = 2 AND ctauxi.estado = $estado AND (ctauxi.idauxi = '$idauxi') ORDER BY ctauxi.descrip";
                    // $query = $this->db_b->query($consulta);
                    // $resultado = $query->result();

                    $this->db_b->select('a.idauxi, a.descrip, a.nit, a.dui, a.telefono, a.correo, a.idtipo, a.giro');
                    $this->db_b->select('a.idzip, a.nrc, IFNULL(b.idrec, "") AS idrec, a.direccion, IFNULL(b.notas, "") AS direccion_c, IFNULL(a.grupo, "") AS grupo');
                    if ($this->db_b->field_exists('dte_giro', 'ctauxi')){
                        $this->db_b->select('a.dte_giro');
                    } else $this->db_b->select("'' AS dte_giro");
                    $this->db_b->from('ctauxi a');
                    $this->db_b->join('ctauximulti b', 'a.idauxi = b.idauxi AND b.idgvar = 2 AND b.notas != "" AND b.estatus = 1', 'LEFT');
                    $this->db_b->where("a.idauxidef", 2);
                    $this->db_b->where("a.estado", $estado);
                    $this->db_b->where("a.idauxi", $idauxi);
                    $this->db_b->order_by('a.descrip');
                    $query = $this->db_b->get();
                    $resultado = $query->result();
                }
				return $resultado;
            }
		}
		
		function getListadoClientesPorSucursalUpdateGrupo($grupoCliente, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $subconsulta = "";
                $arregloGrupos = explode(",", $grupoCliente);
                
                for($i=0; $i<count($arregloGrupos); $i++){
                    $subconsulta .= "ctauxi.grupo = '".$arregloGrupos[$i]."' OR ";
                }
                $subconsulta = substr($subconsulta, 0, -4);
                
                $consulta = "SELECT ctauxi.idauxi, IFNULL(ctauximulti.idrec, '0') AS idrec, ctauxi.descrip, IFNULL(ctauxi.grupo, '') AS grupo, IFNULL(ctauximulti.descrip, '') AS sucursal, CONCAT(ctauxi.descrip,' ',IFNULL(ctauxi.grupo, ''),' ',IFNULL(ctauximulti.descrip, '')) AS descripsearch, ctauxi.limite, IFNULL((SELECT SUM(ar_balance.cargos) + SUM(ar_balance.Abonos) FROM ar_balance WHERE ar_balance.idcps = ctauxi.idauxi GROUP BY ar_balance.idcps), 0) AS saldo FROM ctauxi LEFT JOIN ctauximulti ON ctauxi.idauxi = ctauximulti.idauxi AND ctauximulti.idgvar = 2 WHERE ctauxi.idauxidef = 2 AND (".$subconsulta.") AND ctauxi.estado = $estado ORDER BY ctauxi.descrip, ctauximulti.descrip;";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()> 0){
                    $resultado = $query->result();
                }else{
                    $resultado = "";
                }
                
                return $resultado;
            }
		}
        
        function getInvclaseByCliente($idcliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT IFNULL(invdef.invclase, 0) AS invclase FROM tran_100 AS t100
                 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase AND invdef.estatus = 1
                 WHERE invdef.agrupa = 'VN' AND invdef.caopera = 1 AND t100.estatus = 1 AND t100.idcps = $idcliente ORDER BY t100.fecha DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()== 0){
					$resultado = "";
				}else{
                    $infoClase = $query->row_array();
					$resultado = $infoClase['invclase'];
				}
                
                return $resultado;
            }
        }

        function getDocumentoVendedorByCliente($idauxi) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('IFNULL(b.invclase, 0) AS invclase, a.idworker');
                $this->db_b->from("tran_100 a");
                $this->db_b->join("inv_def  b", "a.idclase = b.invclase AND b.estatus = 1");
                $this->db_b->where("b.agrupa", 'VN');
                $this->db_b->where("b.caopera", 1);
                $this->db_b->where("a.estatus", 1);
                $this->db_b->where("a.idcps", $idauxi);
                $this->db_b->order_by("a.fecha", 'DESC');
                $this->db_b->limit(1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() == 0) {
                    $this->db_b->select('a.idcps');
                    $this->db_b->from("ctauxi a");
                    $this->db_b->where("a.idauxi", $idauxi);
                    $datos = $this->db_b->get();
                    $info = $datos->row_array();
                    return '0,'.$info['idcps'];
                    
                } else {
                    $info = $datos->row_array();
                    return $info['invclase'].','.$info['idworker'];
                }
            }
        }
		
		function getListadoCortesImpresiones($idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT DISTINCT numz, numx, tipo, idcentro, idcaja, descrip, DATE_FORMAT(fechahora, '%Y-%m-%d') AS fecha, DATE_FORMAT(ingresa, '%r') AS hora FROM tran_100z WHERE idcentro = $idcentro AND idcaja = $idcaja AND tipo != 11 AND tipo != 12";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
			}
		}
        
        function getDireccionMultiple($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT notas from ctauximulti where idrec=$idrec";
                $query = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				return $resultado['notas'];
			}
		}
        
        function updateDatosO_Venta($trannum, $fechaingreso, $vendedor, $tipodocumento, $formapago, $fechaentrega, $lugarentrega, $referencia, $notas, $estado, $valorTotal, $retencionTotal, $valordescuento){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$codes = explode('T', $fechaentrega);
                $total = count($codes);
                $fecha="";
                $hora="";
                for($i=0; $i<$total; $i++){
                    if($i==0){
                        $fecha=$codes[$i];
                    }else{
                        $hora=$codes[$i];
                    }  
                }
                
                $this->db_b->set('fecha', $fechaingreso);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('cli_notify', $tipodocumento);
                $this->db_b->set('cajclase', $formapago);
                $this->db_b->set('dev_date', $fecha);
                $this->db_b->set('dev_time', $hora);
                $this->db_b->set('dev_place', $lugarentrega);
                $this->db_b->set('referencia', $referencia);    
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('val_pro', $valorTotal);
                $this->db_b->set('val_otros', $valordescuento);
				if(round($estado)==2 || round($estado)==3){
                    $this->db_b->set('fecact', $date->format('Y-m-d'));
                }
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function updateInformacionCotizacion($trannum, $dirigido, $correo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('cli_email', $correo);
                $this->db_b->set('dev_contact', $dirigido);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        #------------------------------   UPDATE ENCABEZADO
        function updateCotizacion($trannum, $data){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('trannum', $trannum);
                if ($this->db_b->update('orders_100', $data)) return true;
                else return false;
            }
        }
        
        function getDatosOrden100k($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, orders_100k.*, orders_100k.cantrp AS descuento, orders_100k.precioneto AS preciotran, orders_100k.notas AS modNotas,
                    orders_100k.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.tipotax, invproducts.tipo, orders_100k.um AS umorders,
                    orders_100k.uniconv, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro), 0) AS disponible
                FROM
                    orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                WHERE orders_100k.trannum = $trannum
                ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getLastItemLine($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $idtrannum ORDER BY itemline DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $item = $query->row_array();
                    $itemline = $item['itemline'] + 1;
                }else{
                    $itemline = 1;
                }
                return $itemline;
            }
        }
        
        function insertProOrders100($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas, $itemline, $descuento){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $consulta2 = "SELECT descrip FROM invproducts WHERE idproducto = $idproducto";
                $query2 = $this->db_b->query($consulta2);
                $result = $query2->row_array();
				$descrip = $result['descrip'];
				
				$this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('cantrp', $descuento);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
				
				$SQLDatos = "SELECT SUM(orders_100k.cantidad * (orders_100k.precioneto - (orders_100k.precioneto * (orders_100k.cantrp/100)))) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $idtrannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query2 = $this->db_b->update('orders_100');
				return  $query;
            }
        }

        function insertProOrders100kDescrip($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas, $itemline, $descuento, $descrip){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('cantrp', $descuento);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
				
				$SQLDatos = "SELECT SUM(orders_100k.cantidad * (orders_100k.precioneto - (orders_100k.precioneto * (orders_100k.cantrp/100)))) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $idtrannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query2 = $this->db_b->update('orders_100');
				return  $query;
            }
        }
        #-------------------------------------------------- MODIFICAR DESCRIPCION ---------------------------------
        public function MDescripOrder100k($ID, $itemline, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('trannum = '.$ID.' AND itemline = '.$itemline);
                if ($this->db_b->update('orders_100k', $data)) return true;
                else return false;
            }
        }
        public function UMDescripOrder100k($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idrec', $ID);
                if ($this->db_b->update('orders_100k', $data)) return true;
                else return false;
            }
        }
        #-------------------------------------------------- FIN MODIFICAR DESCRIPCION -----------------------------
        
		function updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv, $itemline, $descuento, $olditemline){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('cantrp', $descuento);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');

                $updateItemline = "UPDATE orders_100k SET itemline = 
                CASE 
                    WHEN itemline = $olditemline THEN
                       $itemline
                    WHEN $itemline < $olditemline AND itemline < $olditemline THEN
                       itemline + 1
                    WHEN $itemline > $olditemline AND itemline > $olditemline THEN
                       itemline - 1
                    END
                WHERE itemline BETWEEN LEAST($itemline, $olditemline) AND GREATEST($itemline, $olditemline) AND trannum = $idtrannum";
                $query = $this->db_b->query($updateItemline);
				
				$SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $idtrannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query2 = $this->db_b->update('orders_100');
				return  $query;
			}
		}
        
        function getDatosProductoSearchOrdenes($prosearch, $dato, $idcentro, $trannum, $tipopro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
				
                $whereTipo = "(";
                $infoTipos = explode(",", $tipopro);
                
                for($i=0; $i<count($infoTipos); $i++){
                    $whereTipo .= "invproducts.tipo = ".$infoTipos[$i]." OR ";
                }
                
                $whereTipo = substr($whereTipo, 0, -4);
                $whereTipo .= ")";
                
				if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, orders_100k.um as umorders, orders_100k.uniconv, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe, (SELECT IFNULL(COUNT(orders_100k.idproducto),0) FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum) AS cantidadItems FROM invproducts LEFT JOIN orders_100k ON orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1 AND ".$whereTipo." AND (invproducts.$search = '$dato' OR invpromulti.descrip = '$dato') GROUP BY invproducts.idproducto";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else if($prosearch == 5){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, orders_100k.um as umorders, orders_100k.uniconv, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe, (SELECT IFNULL(COUNT(orders_100k.idproducto),0) FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum) AS cantidadItems FROM invproducts LEFT JOIN orders_100k ON orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND ".$whereTipo." AND invproducts.descrip LIKE '%$dato%' GROUP BY invproducts.idproducto";
					$query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else if($prosearch == 2 || $prosearch == 4){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, orders_100k.um as umorders, orders_100k.uniconv, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe, (SELECT IFNULL(COUNT(orders_100k.idproducto),0) FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum) AS cantidadItems FROM invproducts LEFT JOIN orders_100k ON orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND ".$whereTipo." AND invproducts.$search LIKE '%$dato%' GROUP BY invproducts.idproducto";
					$query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.tipo, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, orders_100k.um as umorders, orders_100k.uniconv, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe, (SELECT IFNULL(COUNT(orders_100k.idproducto),0) FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum) AS cantidadItems FROM invproducts LEFT JOIN orders_100k ON orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND ".$whereTipo." AND invproducts.$search = '$dato' GROUP BY invproducts.idproducto";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }    
            }
		}
        
		function getAnexosPadres(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  orders_100a.idrec, orders_100a.descrip,orders_100a.tipo,orders_100a.notas, (SELECT CONCAT(ROUND(gvars.valor_num), ' - ',  descripcion) from gvars WHERE gvars.nombre='so_anexos' and round(gvars.valor_num)=round(orders_100a.tipo)) as grupo FROM orders_100a WHERE trannum = 0 ORDER BY tipo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return  $resultado;
            }
        }
        
        function getAnexosHijos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM orders_100a WHERE trannum = $trannum ORDER BY valor ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return  $resultado;
                }else{
                    return false;     
                }
                
            }
        }
        
        function getAnexosHijosTipo($tipo = 1){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM orders_100a WHERE trannum = 0 AND tipo=$tipo ORDER BY idrec ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return  $resultado;
            }
        }
        
        function insertAnexo($trannum,$tipo,$descrip,$posicion,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('agrupa', "VN");
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('valor', $posicion);
                $this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100a');
                return  $query;
            }
        }
        
		function updateAnexo($trannum,$idrec,$tipo,$descrip,$posicion,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('valor', $posicion);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100a');
                return  $query;
            }
        }
        
        function deleteAnexo($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $consulta = "DELETE FROM orders_100a WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function getTiposAnexos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT descrip,IFNULL(COUNT(idrec),0) as cantidad, tipo FROM orders_100a WHERE trannum = 0 GROUP BY tipo ORDER BY tipo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return  $resultado;
            }
        }
        
        function getCantAnexos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT COUNT(idrec) as cantidad FROM orders_100a WHERE trannum=$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return  $resultado['cantidad'];
            }
        }
        
        function getLastVenta($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cajclase,referencia,idworker,cajclase,cli_notify,notas,dev_place FROM orders_100 WHERE agrupa = 'VN' AND idcps=$idcps ORDER BY trannum DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return  $resultado;  
				}else{
					return false;     
				}
               
            }
        }
        
		function getListaCanjesProductos($idcentro, $agrupa){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLCanjes = "SELECT orders_100.trannum, orders_100.fecha, orders_100.estatus, ctauxi.descrip, orders_100.val_tot, orders_100.val_pro, orders_100.val_anti FROM orders_100 INNER JOIN ctauxi ON orders_100.idcps = ctauxi.idauxi WHERE orders_100.agrupa = '$agrupa' AND orders_100.idcentro = $idcentro";
                $QueryCanjes = $this->db_b->query($SQLCanjes);
                
				if($QueryCanjes->num_rows() > 0){
					$ResultCanjes = $QueryCanjes->result();
                }else{
					$ResultCanjes = false;
				}
               	
				return  $ResultCanjes;
            }
		}
		
		function insertarNuevoCanje($idcentro, $idauxi, $fecha, $observaciones, $agrupa){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('trannum', 0);
				$this->db_b->set('idcentro', $idcentro);
				$this->db_b->set('agrupa', $agrupa);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $observaciones);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');
				
				$idtrannum = $this->db_b->insert_id();
                return $idtrannum;
			}
		}
        
        function getInformacionDetalleCanje($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLCanjes = "SELECT orders_100.*, ctauxi.descrip AS nameCliente, ctauxi.grupo AS zonaCliente FROM orders_100 INNER JOIN ctauxi ON orders_100.idcps = ctauxi.idauxi WHERE orders_100.trannum = '$trannum'";
                $QueryCanjes = $this->db_b->query($SQLCanjes);
                
				if($QueryCanjes->num_rows() > 0){
					$ResultCanjes = $QueryCanjes->result();
                }else{
					$ResultCanjes = false;
				}
               	
				return  $ResultCanjes;
            }
        }
		
		function getListadoProductosCanjeados($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLCanjes = "SELECT orders_100k.*, invproducts.imagen FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100k.trannum = '$trannum' AND orders_100k.cantidad > 0";
                $QueryCanjes = $this->db_b->query($SQLCanjes);
                
				if($QueryCanjes->num_rows() > 0){
					$ResultCanjes = $QueryCanjes->result();
                }else{
					$ResultCanjes = false;
				}
               	
				return  $ResultCanjes;
            }
		}
		
		function getListadoProductosEntregados($trannum, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLCanjes = "SELECT orders_100k.*, invproducts.imagen, invproducts.marca, invproducts.modelo, invproducts.barcode, inv_stock.cantidad AS saldo FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN inv_stock ON invproducts.idproducto = inv_stock.idproducto AND inv_stock.idcentro = $idcentro WHERE orders_100k.trannum = '$trannum' AND orders_100k.cantidad < 0";
                $QueryCanjes = $this->db_b->query($SQLCanjes);
                
				if($QueryCanjes->num_rows() > 0){
					$ResultCanjes = $QueryCanjes->result();
                }else{
					$ResultCanjes = false;
				}
               	
				return  $ResultCanjes;
            }
		}
		
		function getInventarioProductosVendidos($idcliente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLCanjes = "SELECT tran_100k.idproducto, tran_100k.idbatch, tran_100k.idbin, tran_100k.barcode, SUM(ABS(tran_100k.cantidad)) AS cantidad, tran_100k.um, tran_100k.uniconv, tran_100k.costounitario, tran_100k.preciotran, tran_100k.descuento, tran_100k.precioneto, tran_100k.tax1, invproducts.imagen, invproducts.modelo, invproducts.descrip AS nameproducto, CONCAT(invproducts.descrip, ' ', invproducts.modelo) AS namemodelo FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' AND inv_def.inopera = -1 WHERE tran_100.estatus = 1 AND tran_100.idcps = $idcliente GROUP BY tran_100k.idproducto";
                $QueryCanjes = $this->db_b->query($SQLCanjes);
                
				if($QueryCanjes->num_rows() > 0){
					$ResultCanjes = $QueryCanjes->result();
                }else{
					$ResultCanjes = false;
				}
               	
				return  $ResultCanjes;
            }
		}
        
        function insertarProductoToCanje($trannum, $descrip, $idproducto, $precioneto, $cantidad, $uniconv, $idbin, $idbatch, $um, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLValidate = "SELECT idrec, precioneto, cantidad FROM orders_100k WHERE precioneto = '$precioneto' AND idproducto = $idproducto AND trannum = $trannum";
                $QueryValidate = $this->db_b->query($SQLValidate);

                if($QueryValidate->num_rows() > 0){
                    $ResValidate = $QueryValidate->row_array();
                    $cantidad = $ResValidate['cantidad'] + 1;
                    $idrec = $ResValidate['idrec'];
                    
                    $this->db_b->set('cantidad', $cantidad);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $idrec);
                    
                    $QueryInsert = $this->db_b->update('orders_100k');
                }else{
                    $SQLItemline = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                    $QueryItemline = $this->db_b->query($SQLItemline);

                    if($QueryItemline->num_rows() > 0){
                        $resultado = $QueryItemline->row_array();
                        $itemLine = $resultado['itemline'] + 1;
                    }else{
                        $itemLine = 1;
                    }

                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('descrip', $descrip);
                    $this->db_b->set('cantidad', $cantidad);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('uniconv', $uniconv);
                    $this->db_b->set('precioneto', $precioneto);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    
                    $QueryInsert = $this->db_b->insert('orders_100k');
                }
				
                return  $QueryInsert;
            }
        }
        
        function deleteProductoToCanje($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLValidate = "SELECT cantidad FROM orders_100k WHERE idrec = '$idrec'";
                $QueryValidate = $this->db_b->query($SQLValidate);
                $ResValidate = $QueryValidate->row_array();
                $cantidad = $ResValidate['cantidad'];
                
                if($cantidad > 1){
                    $cantidad = $cantidad - 1;
                    $this->db_b->set('cantidad', $cantidad);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $idrec);
                    
                    $QueryDelete = $this->db_b->update('orders_100k');
                }elseif($cantidad == 1){
                    $SQLDelete = "DELETE FROM orders_100k WHERE idrec = $idrec";
                    $QueryDelete = $this->db_b->query($SQLDelete);
                }
                
                return  $QueryDelete;
            }
        }
		
		function getInventarioTotalToCanje($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.tipo, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, IFNULL((SELECT SUM(ABS(orders_100k.cantidad)) FROM orders_100k WHERE orders_100k.idproducto = inv_stock.idproducto AND orders_100k.trannum = $idtrannum GROUP BY orders_100k.idproducto), 0) AS totalAgregados FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.estado = 1 ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function insertarProductoToEntrega($trannum, $descrip, $idproducto, $precioneto, $cantidad, $uniconv, $idbin, $idbatch, $um, $notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLItemline = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
				$QueryItemline = $this->db_b->query($SQLItemline);
				
				if($QueryItemline->num_rows() > 0){
					$resultado = $QueryItemline->row_array();
					$itemLine = $resultado['itemline'] + 1;
				}else{
					$itemLine = 1;
				}
				
				$cantidad = $cantidad * -1;
				
				$this->db_b->set('idrec', 0);
				$this->db_b->set('trannum', $trannum);
				$this->db_b->set('itemline', $itemLine);
				$this->db_b->set('idproducto', $idproducto);
				$this->db_b->set('idbatch', $idbatch);
				$this->db_b->set('idbin', $idbin);
				$this->db_b->set('descrip', $descrip);
				$this->db_b->set('cantidad', $cantidad);
				$this->db_b->set('um', $um);
				$this->db_b->set('uniconv', $uniconv);
				$this->db_b->set('precioneto', $precioneto);
				$this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$QueryInsert = $this->db_b->insert('orders_100k');
                
                return  $QueryInsert;
			}
		}
		
		function updateProductoToEntrega($idrec, $precioneto, $cantidad, $notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$cantidad = $cantidad * -1;
				
				$this->db_b->set('cantidad', $cantidad);
				$this->db_b->set('precioneto', $precioneto);
				$this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				$QueryInsert = $this->db_b->update('orders_100k');
                
                return  $QueryInsert;
			}
		}
		
		function deleteProductoToEntrega($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$SQLDelete = "DELETE FROM orders_100k WHERE idrec = $idrec";
				$QueryDelete = $this->db_b->query($SQLDelete);
                
                return  $QueryDelete;
			}
		}
		
		function getListadoFacturasClienteToAbono($idcliente){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$SQLConsulta = "SELECT tran_100.*, inv_def.descrip AS namedocumento, inv_def.imagen FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.idcps = $idcliente AND (tran_100.ccestatus = 0 OR tran_100.ccestatus = 1 OR tran_100.ccestatus = 2) AND tran_100.estatus = 1 AND inv_def.inopera = -1 ORDER BY tran_100.fecha DESC";
				$QueryConsulta = $this->db_b->query($SQLConsulta);
                $resultado = $QueryConsulta->result();
                
				return  $resultado;
			}
		}
		
		function updateCierreCanje($trannum, $valorRecibido, $valorEntregado, $valorDiferencia, $idCargo, $idAbono, $idFavor, $idContra){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$idCargoAbono = "";
				$idAjustes = $idFavor.",".$idContra;
				
				if($idCargo != ""){
					$idCargoAbono = $idCargo;
				}
				
				if($idAbono != ""){
					if($idCargoAbono != ""){
						$idCargoAbono = $idCargoAbono.",".$idAbono;
					}else{
						$idCargoAbono = $idAbono;
					}
				}
				
				$this->db_b->set('cli_phone', $idAjustes);
				$this->db_b->set('cli_email', $idCargoAbono);
				$this->db_b->set('val_pro', $valorRecibido);
				$this->db_b->set('val_tot', $valorEntregado);
                $this->db_b->set('val_anti', $valorDiferencia);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
				
                return  $query;
			}
		}
		
		function setAnulacionCanjeProductos($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$SQLDelete = "DELETE FROM orders_100k WHERE trannum = $trannum";
				$QueryDelete = $this->db_b->query($SQLDelete);
                
				$this->db_b->set('cli_phone', '');
				$this->db_b->set('cli_email', '');
				$this->db_b->set('val_pro', 0);
				$this->db_b->set('val_tot', 0);
                $this->db_b->set('val_anti', 0);
                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
				
				return $query;
			}
		}
        
		function insertarCargoAbonoFacturaCanje($trannum, $trannum_ac, $formaPago, $valorPago, $notasPago, $descrip){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLTransaccion = "SELECT idclase, idworker, fecha FROM tran_100 WHERE trannum = $trannum_ac";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				
				if($QueryTransaccion->num_rows() > 0){
					$ResultTransaccion = $QueryTransaccion->row_array();
					$idclase = $ResultTransaccion['idclase'];
					$idworker = $ResultTransaccion['idworker'];
					$fechaCanje = $ResultTransaccion['fecha'];
				}
				
                $SQLCanje = "SELECT fecha FROM orders_100 WHERE trannum = $trannum";
				$QueryCanje = $this->db_b->query($SQLCanje);
				
				if($QueryCanje->num_rows() > 0){
					$ResultCanje = $QueryCanje->row_array();
					$fechaCanje = $ResultCanje['fecha'];
				}
				
                $SQLCajdef= "SELECT alcuadre FROM caj_def WHERE cajclase = $formaPago";
				$QueryCajdef = $this->db_b->query($SQLCajdef);
				
				if($QueryCajdef->num_rows() > 0){
					$resultado = $QueryCajdef->row_array();
					$alcuadre = $resultado['alcuadre'];
				}
				
				$SQLItemline = "SELECT itemline FROM tran_100c WHERE trannum = $trannum_ac ORDER BY itemline DESC Limit 1";
				$QueryItemline = $this->db_b->query($SQLItemline);
				
				if($QueryItemline->num_rows() > 0){
					$ResultItem = $QueryItemline->row_array();
					$itemLine = $ResultItem['itemline'] + 1;
				}else{
					$itemLine = 1;
				}
				
				$valorPago = $valorPago * $alcuadre;
				
				$this->db_b->set('idrec', 0);
				$this->db_b->set('trannum', $trannum_ac);
				$this->db_b->set('descrip', $descrip);
				$this->db_b->set('idworker', $idworker);
				$this->db_b->set('idclase', $idclase);
				$this->db_b->set('fecha', $fechaCanje);
				$this->db_b->set('itemline', $itemLine);
				$this->db_b->set('cajclase', $formaPago);
				$this->db_b->set('valor', $valorPago);
				$this->db_b->set('notas', $notasPago);
				$this->db_b->set('referencia', $trannum);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$QueryInsert = $this->db_b->insert('tran_100c');
                
				$idCargoAbono = $this->db_b->insert_id();
                return $idCargoAbono;
			}
		}
        
		function insertAjusteFavorContraCanje($trannum, $idclase, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLTransaccion = "SELECT idcentro, fecha FROM orders_100 WHERE trannum = $trannum";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				
				if($QueryTransaccion->num_rows() > 0){
					$ResultTransaccion = $QueryTransaccion->row_array();
					$idcentro = $ResultTransaccion['idcentro'];
					$fechaCanje = $ResultTransaccion['fecha'];
				}
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('tranref', $trannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fechaCanje);
                $this->db_b->set('fecact', $fechaCanje);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
				
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
		
		function insertDetalleAjusteFavorCanje($trannum, $idajuste, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$SQLTransaccion = "SELECT idcentro, fecha FROM orders_100 WHERE trannum = $trannum";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				
				$ResultTransaccion = $QueryTransaccion->row_array();
				$idcentro = $ResultTransaccion['idcentro'];
				
                $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $res = $query->row_array();
				$inopera = $res['inopera'];
                
				$SQLTransaccion = "SELECT * FROM orders_100k WHERE trannum = $trannum AND cantidad > 0";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				$dataSource = $QueryTransaccion->result();
				
				foreach($dataSource as $info){
					$nuevacantidad = $inopera * abs($info->cantidad);
					
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $idajuste);
					$this->db_b->set('idclase', $idclase);
					$this->db_b->set('itemline', $info->itemline);
					$this->db_b->set('idcentro', $idcentro);
					$this->db_b->set('idproducto', $info->idproducto);
					$this->db_b->set('idbatch', $info->idbatch);
					$this->db_b->set('idbin', $info->idbin);
					$this->db_b->set('cantidad', $nuevacantidad);
					$this->db_b->set('um', $info->um);
					$this->db_b->set('uniconv', $info->uniconv);
					$this->db_b->set('costounitario', $info->precioneto);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100k');
				}
                
                return $query;
            }
        }
		
		function insertDetalleAjusteContraCanje($trannum, $idajuste, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$SQLTransaccion = "SELECT idcentro, fecha FROM orders_100 WHERE trannum = $trannum";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				$ResultTransaccion = $QueryTransaccion->row_array();
				$idcentro = $ResultTransaccion['idcentro'];
				
                $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $res = $query->row_array();
				$inopera = $res['inopera'];
                
				$SQLTransaccion = "SELECT * FROM orders_100k WHERE trannum = $trannum AND cantidad < 0";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				$dataSource = $QueryTransaccion->result();
				
				foreach($dataSource as $info){
					$nuevacantidad = $inopera * abs($info->cantidad);
					
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $idajuste);
					$this->db_b->set('idclase', $idclase);
					$this->db_b->set('itemline', $info->itemline);
					$this->db_b->set('idcentro', $idcentro);
					$this->db_b->set('idproducto', $info->idproducto);
					$this->db_b->set('idbatch', $info->idbatch);
					$this->db_b->set('idbin', $info->idbin);
					$this->db_b->set('cantidad', $nuevacantidad);
					$this->db_b->set('um', $info->um);
					$this->db_b->set('uniconv', $info->uniconv);
					$this->db_b->set('costounitario', $info->precioneto);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100k');
				}
                
                return $query;
            }
        }
		
		function validateValDHTransaccion($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$SQLTransaccion = "SELECT * FROM tran_100 WHERE trannum = $trannum";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				$ResultTransaccion = $QueryTransaccion->row_array();
				
				$valor_venta = $ResultTransaccion['valventan'] + $ResultTransaccion['valtax1'];
				$saldo_factura = $valor_venta + $ResultTransaccion['valdh'];
				
				if(number_format($saldo_factura, 2, '.', ',') == 0){
					$this->db_b->set('ccestatus', 1);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('trannum', $trannum);
					
					$query = $this->db_b->update('tran_100');
				}elseif(number_format($saldo_factura, 2, '.', ',') < 0){
					$this->db_b->set('ccestatus', 2);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('trannum', $trannum);
					
					$query = $this->db_b->update('tran_100');
				}elseif(number_format($saldo_factura, 2, '.', ',') > 0){
					$this->db_b->set('ccestatus', 0);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('trannum', $trannum);
					
					$query = $this->db_b->update('tran_100');
				}
			}
		}
		
		function getVentasxVendedores(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT count(tran_100.trannum) as Facturas, date_format(tran_100.fecha,'%Y/%m/%d') as Fecha, tran_100.fecha, ctauxi2.descrip AS Cliente, ctauxi.descrip AS Vendedor, invcatalog.descrip as Categoria, SUM(tran_100k.cantidad * tran_100k.precioneto *  inv_def.inopera)  as Ventas, invsites.descrip AS Sucursal FROM tran_100 INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum INNER JOIN ctauxi ON tran_100.idworker = ctauxi.idauxi INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invsites ON invsites.idcentro=tran_100.idcentro INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps WHERE tran_100.estatus = 1 AND inv_def.agrupa = 'VN' GROUP BY tran_100.idworker, invcatalog.idcatalogo, MONTH(tran_100.fecha), YEAR(tran_100.fecha) ORDER BY ctauxi.descrip, invcatalog.descrip ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

        function getVentasxProveedor($fecha_ini, $fecha_fin, $idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS Fecha, DATE_FORMAT(tran_100.ingresa, '%H') AS Hora, tran_100.fecha AS Dia, IFNULL(ctauxi3.descrip, 'SIN PROVEEDOR') AS Proveedor, ctauxi2.descrip AS Cliente, ctauxi.descrip AS Vendedor,
                    invcatalog.descrip AS Línea, invcatalog2.descrip AS Departamento,
                    ((tran_100k.cantidad * tran_100k.precioneto) *- 1 ) AS Ventas,
                    (((tran_100k.cantidad * tran_100k.uniconv) * tran_100k.costounitario) * - 1) AS Costos,
                    ((tran_100k.cantidad * tran_100k.uniconv) * inv_def.inopera) AS Unidades,
                    tran_100k.idproducto AS Hits,
                    inv_def.descrip AS Transaccion, IFNULL(ctauximulti.descrip, ctauxi2.descrip) AS Suc_Cliente,
                    invsites.descrip AS Sucursal, invproducts.descrip AS Producto, invproducts.xpos, invproducts.marca AS Marca, invproducts.modelo AS Modelo, invproducts.idproducto, ctauxi2.grupo AS Grupo
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro
                INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                INNER JOIN ctauxi AS ctauxi3 ON ctauxi3.idauxi = invproducts.idprovee AND ctauxi3.idauxi = $idcps AND ctauxi3.idauxi != 0
                LEFT JOIN  ctauximulti ON tran_100.idcentrod = ctauximulti.idrec 
                WHERE tran_100.estatus = 1 AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN '$fecha_ini' AND '$fecha_fin'";

                #GROUP BY tran_100.fecha, tran_100.idcentro, tran_100.idcps, tran_100k.idworker, invcatalog.idcatalogo, invproducts.idproducto
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getExistenciasPorProveedor($idprovee){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT invproducts.idproducto AS id, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS proveedor, invproducts.imagen, invproducts.upp, invproducts.tipo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca, invproducts.barcode, invproducts.presenta, invproducts.modelo, invproducts.um, invproducts.precioventa, inv_batch.costounitario, invproducts.xpos, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi AND invproducts.idprovee = $idprovee INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog as invdep ON invcatalog.idnivel1 = invdep.idcatalogo WHERE invproducts.tipo = 1 AND invproducts.estado = 1 GROUP BY tran_100k.idproducto";
                $Query = $this->db_b->query($SQL);
                return $Query->result();
            }
        }
		
		function getInformacionTrannumCargoAbono($idrec_cargo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT trannum FROM tran_100c WHERE idrec = $idrec_cargo";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
				$trannum = $result['trannum'];
                
				$SQLTransaccion = "SELECT * FROM tran_100 WHERE trannum = $trannum";
				$QueryTransaccion = $this->db_b->query($SQLTransaccion);
				$dataSource = $QueryTransaccion->row_array();
				
				return $dataSource;
			}
		}
		
		function getInformacionCargoCanje($idrec_cargo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT tran_100c.*, caj_def.descrip AS forma_pago FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.idrec = $idrec_cargo";
                $query = $this->db_b->query($consulta);
                $dataSource = $query->row_array();
				
				return $dataSource;
			}
		}
		
		function getInformacionAbonoCanje($idrec_abono){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT tran_100c.*, caj_def.descrip AS forma_pago FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.idrec = $idrec_abono";
                $query = $this->db_b->query($consulta);
                $dataSource = $query->row_array();
				
				return $dataSource;
			}
		}
        function getFacturasCerradasReport($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.exento, ctaucli.descrip AS namecliente, t100.valventan, t100.valtax1,invdef.inopera FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 ORDER BY t100.fecha, t100.numero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getlistfacturas_report($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta1 = "SELECT tran_100c.cajclase FROM tran_100 AS t100 INNER JOIN tran_100c ON tran_100c.trannum= t100.trannum INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase AND caj_def.agrupa=invdef.agrupa WHERE invdef.agrupa = '$agrupa' AND invdef.caopera = 1 AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 GROUP BY tran_100c.cajclase ";
                $query1 = $this->db_b->query($consulta1);
                
                $subconsulta = "";
                if($query1->num_rows()>0){
                    $formas_pago = $query1->result_array();
                    foreach($formas_pago as $formas){
                        $cajclase=$formas['cajclase'];
                        $subconsulta .= "(SELECT IFNULL(ABS(SUM(tran_100c.valor - tran_100c.vuelto)),0) FROM tran_100c where tran_100c.trannum=tran_100.trannum AND tran_100c.cajclase=".$cajclase.") AS tipo".$cajclase.",";
                    }
				}
                
                $consulta = "SELECT 
                    tran_100.idclase,
                    concat(tran_100.serie, tran_100.numero) AS correlativo,
                    tran_100.fecha,
                    ctauxi.descrip as cliente,
                    inv_def.inopera,
                    IF( invproducts.tipotax!=0 AND inv_def.exento=0, SUM((tran_100k.precioneto + (tran_100k.precioneto * (invproducts.tipotax / 100))) * abs(tran_100k.cantidad)),0) AS gravado ,
                    IF( invproducts.tipotax!=0 AND inv_def.exento=1, SUM(((tran_100k.precioneto * (invproducts.tipotax / 100))) * abs(tran_100k.cantidad)),0) AS iva , ";
                
                $consulta.=$subconsulta;
                $consulta.=" IF( invproducts.tipotax=0 AND inv_def.exento=0, SUM(tran_100k.precioneto  * abs(tran_100k.cantidad)),0) AS exento 
                    FROM
                    tran_100k
                    INNER JOIN tran_100 ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                    INNER JOIN inv_def  ON tran_100.idclase = inv_def.invclase
                    INNER JOIN ctauxi  ON tran_100.idcps = ctauxi.idauxi
                    WHERE inv_def.agrupa = '$agrupa' AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.serie != '' AND tran_100.numero != 0  GROUP BY tran_100.trannum ORDER BY tran_100.idclase ASC, tran_100.numero ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            } 
        }
        
		function getListadoTiposContratos($gvar_name){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM gvars WHERE nombre = '$gvar_name'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getListadoServiciosContratos($tipoProducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idproducto, descrip, precioventa FROM invproducts WHERE tipo = $tipoProducto";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
                return $resultado;
            }
		}
		
		function getListadoComprobantesContratos($agrupa){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invclase, descrip FROM inv_def WHERE agrupa = '$agrupa' AND inopera = -1";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
                return $resultado;
            }
		}
		
		function getListadoPagosContratos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cajclase, descrip FROM caj_def";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
                return $resultado;
            }
		}
		
		function getListadoContratosServicios($idcentro, $estado, $ristipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($estado == 'TODOS'){
                    $consulta = "SELECT ris_100.*, ctauxi.descrip AS nameCliente, ctauxi.nrc, (SELECT SUM(tran_100k.preciotran) FROM tran_100k WHERE tran_100k.invcontrol = ris_100.trannum AND tran_100k.barcode = 0) AS valorPendiente FROM ris_100 INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi WHERE ris_100.idcentro = $idcentro AND ris_100.ris_tipo = $ristipo";
                }else{
                    $consulta = "SELECT ris_100.*, ctauxi.descrip AS nameCliente, ctauxi.nrc, (SELECT SUM(tran_100k.preciotran) FROM tran_100k WHERE tran_100k.invcontrol = ris_100.trannum AND tran_100k.barcode = 0) AS valorPendiente FROM ris_100 INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi WHERE ris_100.idcentro = $idcentro AND ris_100.ris_tipo = $ristipo AND ris_100.estatus = $estado";
                }
                
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
                return $resultado;
			}
		}

        function updateEstadoProyecto($trannum, $qstatus) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('qstatus', $qstatus);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('ris_100');
                
				return $query;
			}
        }
		
		function insertarNuevoContratoDeServicio($idcentro, $idcaja, $ristipo, $referencia, $fechaini, $fechafin, $idproducto, $idcps, $idworker, $descrip, $valor, $numpagos, $idclase, $cajclase, $notas, $primareserva){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('trannum', 0);
				$this->db_b->set('idcentro', $idcentro);
				$this->db_b->set('idcaja', $idcaja);
				$this->db_b->set('ris_tipo', $ristipo);
				$this->db_b->set('referencia', $referencia);
				$this->db_b->set('fecha', $date->format('Y-m-d H:i:s'));
				$this->db_b->set('fechaini', $fechaini);
				$this->db_b->set('fechafin', $fechafin);
				$this->db_b->set('idproducto', $idproducto);
				$this->db_b->set('idcps', $idcps);
				$this->db_b->set('idworker', $idworker);
				$this->db_b->set('descrip', $descrip);
				$this->db_b->set('valor', $valor);
				$this->db_b->set('numpagos', $numpagos);
				$this->db_b->set('idclase', $idclase);
				$this->db_b->set('cajclase', $cajclase);
				$this->db_b->set('notas', $notas);
				$this->db_b->set('estatus', 1);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('ris_100');
				
				$ristrannum = $this->db_b->insert_id();
				
				if($primareserva > 0){
					
					$consulta = "SELECT tipotax FROM invproducts WHERE idproducto = $idproducto";
					$query = $this->db_b->query($consulta);
					$informacion = $query->row_array();
					
					$precioNeto = $primareserva;
					if($informacion['tipotax'] != 0){
						$precioNeto = $primareserva / (($informacion['tipotax'] / 100) + 1);
					}
					
					$this->db_b->set('idrec', 0);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', 1);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('barcode', 0);
                    $this->db_b->set('invcontrol', $ristrannum);
                    $this->db_b->set('um', $fechaini);
                    $this->db_b->set('preciotran', $primareserva);
                    $this->db_b->set('precioneto', $precioNeto);
                    $this->db_b->set('tax1', $informacion['tipotax']);
                    $this->db_b->set('notas', 'Pago inicial');
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					
                    $query = $this->db_b->insert('tran_100k');
				}
				
				return $query;
				
			}
		}
    	
		function updateInfoContratoDeServicio($trannum, $fechaini, $fechafin, $idworker, $descrip, $idclase, $cajclase, $valor, $notas, $referencia){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('fechaini', $fechaini);
				$this->db_b->set('fechafin', $fechafin);
				$this->db_b->set('idworker', $idworker);
				$this->db_b->set('descrip', $descrip);
				$this->db_b->set('idclase', $idclase);
				$this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('valor', $valor);
				$this->db_b->set('notas', $notas);
				$this->db_b->set('referencia', $referencia);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('ris_100');
                
                $this->db_b->set('idclase', $idclase);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', 0);
				$this->db_b->where('invcontrol', $trannum);
				$this->db_b->update('tran_100k');
                
				return $query;
			}
		}
		
		function anulacionContratoDeServicio($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('estatus', 9);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('ris_100');
				
				
				$this->db_b->set('barcode', 9);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('invcontrol', $trannum);
				$this->db_b->where('barcode', 0);
				$query = $this->db_b->update('tran_100k');
				
				return $query;
			}
		}
		
		function getInformacionDatosContrato($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ris_100.*, ctauxi.descrip AS nameCliente, ctauxi2.descrip AS nameEncargado, inv_def.descrip AS nameComprobante, caj_def.descrip AS namePago, invproducts.descrip AS nameProducto FROM ris_100 INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS ctauxi2 ON ris_100.idworker = ctauxi2.idauxi INNER JOIN inv_def ON ris_100.idclase = inv_def.invclase INNER JOIN caj_def ON ris_100.cajclase = caj_def.cajclase INNER JOIN invproducts ON ris_100.idproducto = invproducts.idproducto WHERE ris_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function getListadoCuotasIngresadas($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT * FROM tran_100k WHERE invcontrol = $trannum AND (barcode = 0 OR barcode = 1 OR barcode = 2 OR barcode = 9)";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
                return $resultado;
			}
		}
		
		function getPrecioVentaProducto($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT precioventa FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$info = $query->row_array();
					$precioVenta = $info['precioventa'];
				}else{
					$precioVenta = false;
				}
				
                return $precioVenta;
			}
		}
		
		function getPrecioContrato($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT valor FROM ris_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$info = $query->row_array();
					$precioVenta = $info['valor'];
				}else{
					$precioVenta = false;
				}
				
                return $precioVenta;
			}
		}
		
		function insertarCuotasToContrato($trannum,$idproducto,$idcentro,$idclase,$dataSource){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$consulta = "SELECT tipotax FROM invproducts WHERE idproducto = $idproducto";
				$query = $this->db_b->query($consulta);
				$informacion = $query->row_array();
				
				$SQLExento = "SELECT exento FROM inv_def WHERE invclase = $idclase";
				$QueryExento = $this->db_b->query($SQLExento);
				$infoExento = $QueryExento->row_array();
				
				$total = count($dataSource);
				for($i=0; $i<$total; $i++){
					
					$SQLItemline = "SELECT itemline FROM tran_100k WHERE invcontrol = $trannum AND (barcode = 0 OR barcode = 1 OR barcode = 2 OR barcode = 9) ORDER BY itemline DESC Limit 1";
					$QueryItemline = $this->db_b->query($SQLItemline);
					if($QueryItemline->num_rows() > 0){
						$infoItem = $QueryItemline->row_array();
						$itemLine = $infoItem['itemline'] + 1;
					}else{
						$itemLine = 1;
					}
					
					
					$precioNeto = $dataSource[$i]['valor'];
                    $tipoTax = $informacion['tipotax'];
                    
                    if($infoExento['exento'] == 0){
                        if($informacion['tipotax'] != 0){
                            $precioNeto = $dataSource[$i]['valor'] / (($informacion['tipotax'] / 100) + 1);
                        }
                    }else{
                        $tipoTax = 0;
                    }
					
					$this->db_b->set('idrec', 0);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('barcode', 0);
                    $this->db_b->set('invcontrol', $trannum);
                    $this->db_b->set('um', $dataSource[$i]['fecha']);
                    $this->db_b->set('preciotran', $dataSource[$i]['valor']);
                    $this->db_b->set('precioneto', $precioNeto);
                    $this->db_b->set('tax1', $tipoTax);
                    $this->db_b->set('notas', $dataSource[$i]['descrip']);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					
                    $query = $this->db_b->insert('tran_100k');
				}
				
				return $query;
			}
		}
		
		function updateRegistroCuotaIngresada($idrec, $fecha, $descrip, $valor, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$consulta = "SELECT tax1 FROM tran_100k WHERE idrec = $idrec";
				$query = $this->db_b->query($consulta);
				$informacion = $query->row_array();
				
				$precioNeto = $valor;
				if($informacion['tax1'] != 0){
					$precioNeto = $valor / (($informacion['tax1'] / 100) + 1);
				}
				
				$this->db_b->set('idproducto', $idproducto);
				$this->db_b->set('um', $fecha);
				$this->db_b->set('preciotran', $valor);
				$this->db_b->set('precioneto', $precioNeto);
				$this->db_b->set('notas', $descrip);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				
				$query = $this->db_b->update('tran_100k');
			}
		}
		
		function getListadoCuotasACobro($idcentro, $fecha){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ctauxi.descrip AS namecliente, ris_100.descrip AS nameContrato, invproducts.descrip AS producto, tran_100k.* FROM tran_100k INNER JOIN ris_100 ON tran_100k.invcontrol = ris_100.trannum INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi INNER JOIN invproducts ON ris_100.idproducto = invproducts.idproducto WHERE ris_100.idcentro = $idcentro AND tran_100k.um <= '$fecha' AND tran_100k.barcode = 0 AND tran_100k.precioneto >0" ;
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
				
				return $informacion;
			}
		}
        
        function getListadoCuotasAFacturar($idcentro, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT ctauxi.descrip AS namecliente, inv_def.descrip AS documento, ris_100.cajclase AS formapago, ris_100.idcps AS idcliente, ris_100.idworker AS idvendedor, ris_100.descrip AS nameContrato, invproducts.descrip AS producto, tran_100k.* FROM tran_100k INNER JOIN ris_100 ON tran_100k.invcontrol = ris_100.trannum INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi INNER JOIN invproducts ON ris_100.idproducto = invproducts.idproducto INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase WHERE ris_100.idcentro = $idcentro AND tran_100k.idclase = $idclase AND tran_100k.barcode = 1 ORDER BY ctauxi.descrip";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
				
				return $informacion;
			}
        }
        
        function getListadoDocumentosCuotasAFacturar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT DISTINCT inv_def.invclase AS id, inv_def.descrip FROM tran_100k INNER JOIN ris_100 ON tran_100k.invcontrol = ris_100.trannum INNER JOIN ctauxi ON ris_100.idcps = ctauxi.idauxi INNER JOIN invproducts ON ris_100.idproducto = invproducts.idproducto INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase WHERE tran_100k.barcode = 1";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
				
				return $informacion;
			}
        }
		
		function deleteCuotaContrato($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ConsultaDelete = "DELETE FROM tran_100k WHERE idrec = $idrec";
                $QueryDelete = $this->db_b->query($ConsultaDelete);
				
				return $QueryDelete;
			}
		}
		
		function updateEstadoCuotasToCobro($idcuotas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$informacion = explode(",", $idcuotas);
				$total = count($informacion);
				
				for($i=0; $i<$total; $i++){
					$this->db_b->set('barcode', 1);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('idrec', $informacion[$i]);
					$query = $this->db_b->update('tran_100k');
				}
				
				return $query;
			}
		}
		
		function cambiarEstadoAnteriorCuota($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('barcode', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				$query = $this->db_b->update('tran_100k');
				
				return $query;
			}
		}
		
		function insertDocumentosTran100($fecha, $idcentro, $idcaja, $idclase, $serieDocumento, $numeroInicial, $numeroFinal, $informacionGrid){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
                $numeroDeVentas = 0;
				$numRegistro = 0;
				$totalPago = 0;
				$cont = count($informacionGrid);
				
				$serieAnt_a = "";
				$idCliente_a = "";
				
				$SqlIdBin = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
				$QueryBin = $this->db_b->query($SqlIdBin);
				$infoBin = $QueryBin->row_array();
				$idbin = $infoBin['idbin'];
				
				for($j=0; $j<$cont; $j++){
					if($informacionGrid[$j]['idcliente'] == $idCliente_a){
						if($informacionGrid[$j]['optionNumber'] == $serieAnt_a){
							
							$serieAnt_a = $informacionGrid[$j]['optionNumber'];
							$idCliente_a = $informacionGrid[$j]['idcliente'];
							
							$SQLTipo = "SELECT tipo FROM invproducts WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
							$QueryTipo = $this->db_b->query($SQLTipo);
							$informacion = $QueryTipo->row_array();
							
							if($informacion['tipo'] == 4){
								$idbatch = 9999;
							}else{
								$SQLIdbatch = "SELECT idbatch FROM inv_batch WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
								$QueryBatch = $this->db_b->query($SQLIdbatch);
								$infoBatch = $QueryBatch->row_array();
								$idbatch = $infoBatch['idbatch'];
							}
							
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('idbatch', $idbatch);
							$this->db_b->set('idbin', $idbin);
							$this->db_b->set('idworker', $informacionGrid[$j]['idvendedor']);
							$this->db_b->set('barcode', 2);
							$this->db_b->set('cantidad', -1);
							$this->db_b->set('uniconv', 1);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
							$this->db_b->where('idrec', $informacionGrid[$j]['idrec']);
							$query = $this->db_b->update('tran_100k');
						
						}else{
							/*
							$totalPago = $totalPago * -1;
							
							$this->db_b->set('idrec', 0);
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('idclase', $idclase);
							$this->db_b->set('fecha', $fecha);
							$this->db_b->set('itemline', 1);
							$this->db_b->set('cajclase', $cajclase);
							$this->db_b->set('idworker', $idvendedor);
							$this->db_b->set('valor', $totalPago);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('tran_100c');
							*/
							$this->db_b->set('idrec', 0);
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('useridprn', $this->session->userdata('iduser'));
							$this->db_b->set('fechaprn', $fecha);
							$this->db_b->set('estatus', 0);
							$this->db_b->set('prncount', 0);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('tran_100p');
							
							$ConsultaTotaliza = "CALL totaliza100($idtrannum, 1)";
							$QueryTotaliza = $this->db_b->query($ConsultaTotaliza);
							
                            $numeroDeVentas++;
							$ventaCerrada = 0;
							
							$totalPago = 0;
							$serieAnt_a = $informacionGrid[$j]['optionNumber'];
							$idCliente_a = $informacionGrid[$j]['idcliente'];
							
							$this->db_b->set('trannum', 0);
							$this->db_b->set('idclase', $idclase);
							$this->db_b->set('idcentro', $idcentro);
							$this->db_b->set('idcentrod', 0);
							$this->db_b->set('serie', $serieDocumento);
							$this->db_b->set('numero', $numeroInicial);
							$this->db_b->set('idcaja', $idcaja);
							$this->db_b->set('idworker', $informacionGrid[$j]['idvendedor']);
							$this->db_b->set('idcps', $informacionGrid[$j]['idcliente']);
							$this->db_b->set('fecha', $fecha);
							$this->db_b->set('fecact', $fecha);
							$this->db_b->set('numy', $informacionGrid[$j]['formapago']);
							$this->db_b->set('estatus', 1);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('tran_100');
							
							$idtrannum = $this->db_b->insert_id();
							$cajclase = $informacionGrid[$j]['formapago'];
							$idvendedor = $informacionGrid[$j]['idvendedor'];
							$ventaCerrada = 1;
							
							$SQLTipo = "SELECT tipo FROM invproducts WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
							$QueryTipo = $this->db_b->query($SQLTipo);
							$informacion = $QueryTipo->row_array();
							
							if($informacion['tipo'] == 4){
								$idbatch = 9999;
							}else{
								$SQLIdbatch = "SELECT idbatch FROM inv_batch WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
								$QueryBatch = $this->db_b->query($SQLIdbatch);
								$infoBatch = $QueryBatch->row_array();
								$idbatch = $infoBatch['idbatch'];
							}
							
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('idbatch', $idbatch);
							$this->db_b->set('idbin', $idbin);
							$this->db_b->set('idworker', $informacionGrid[$j]['idvendedor']);
							$this->db_b->set('barcode', 2);
							$this->db_b->set('cantidad', -1);
							$this->db_b->set('uniconv', 1);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
							$this->db_b->where('idrec', $informacionGrid[$j]['idrec']);
							$query = $this->db_b->update('tran_100k');
							
							$numeroInicial = $numeroInicial + 1;
						}
					}else{
						if($numRegistro != 0){
							/*
							$totalPago = $totalPago * -1;
							
							$this->db_b->set('idrec', 0);
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('idclase', $idclase);
							$this->db_b->set('fecha', $fecha);
							$this->db_b->set('itemline', 1);
							$this->db_b->set('cajclase', $cajclase);
							$this->db_b->set('idworker', $idvendedor);
							$this->db_b->set('valor', $totalPago);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('tran_100c');
							*/
							$this->db_b->set('idrec', 0);
							$this->db_b->set('trannum', $idtrannum);
							$this->db_b->set('useridprn', $this->session->userdata('iduser'));
							$this->db_b->set('fechaprn', $fecha);
							$this->db_b->set('estatus', 0);
							$this->db_b->set('prncount', 0);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('tran_100p');
							
							$ConsultaTotaliza = "CALL totaliza100($idtrannum, 1)";
							$QueryTotaliza = $this->db_b->query($ConsultaTotaliza);
                            
                            $numeroDeVentas++;
							$ventaCerrada = 0;
						}
						
						$totalPago = 0;
						$serieAnt_a = $informacionGrid[$j]['optionNumber'];
						$idCliente_a = $informacionGrid[$j]['idcliente'];
						
						$this->db_b->set('trannum', 0);
						$this->db_b->set('idclase', $idclase);
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('idcentrod', 0);
						$this->db_b->set('serie', $serieDocumento);
						$this->db_b->set('numero', $numeroInicial);
						$this->db_b->set('idcaja', $idcaja);
						$this->db_b->set('idworker', $informacionGrid[$j]['idvendedor']);
						$this->db_b->set('idcps', $informacionGrid[$j]['idcliente']);
						$this->db_b->set('fecha', $fecha);
						$this->db_b->set('fecact', $fecha);
						$this->db_b->set('numy', $informacionGrid[$j]['formapago']);
						$this->db_b->set('estatus', 1);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
						$query = $this->db_b->insert('tran_100');

						$idtrannum = $this->db_b->insert_id();
						$cajclase = $informacionGrid[$j]['formapago'];
						$idvendedor = $informacionGrid[$j]['idvendedor'];
						$ventaCerrada = 1;
						
						$SQLTipo = "SELECT tipo FROM invproducts WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
						$QueryTipo = $this->db_b->query($SQLTipo);
						$informacion = $QueryTipo->row_array();

						if($informacion['tipo'] == 4){
							$idbatch = 9999;
						}else{
							$SQLIdbatch = "SELECT idbatch FROM inv_batch WHERE idproducto = " . $informacionGrid[$j]['idproducto'];
							$QueryBatch = $this->db_b->query($SQLIdbatch);
							$infoBatch = $QueryBatch->row_array();
							$idbatch = $infoBatch['idbatch'];
						}

						$this->db_b->set('trannum', $idtrannum);
						$this->db_b->set('idbatch', $idbatch);
						$this->db_b->set('idbin', $idbin);
						$this->db_b->set('idworker', $informacionGrid[$j]['idvendedor']);
						$this->db_b->set('barcode', 2);
						$this->db_b->set('cantidad', -1);
						$this->db_b->set('uniconv', 1);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
						$this->db_b->where('idrec', $informacionGrid[$j]['idrec']);
						$query = $this->db_b->update('tran_100k');
						
						$totalPago = $totalPago + $informacionGrid[$j]['valor'];
						
						$numeroInicial = $numeroInicial + 1;
						$numRegistro++;
					}
				}
				
				if($ventaCerrada == 1){
					/*
					$totalPago = $totalPago * -1;
					
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $idtrannum);
					$this->db_b->set('idclase', $idclase);
					$this->db_b->set('fecha', $fecha);
					$this->db_b->set('itemline', 1);
					$this->db_b->set('cajclase', $cajclase);
					$this->db_b->set('idworker', $idvendedor);
					$this->db_b->set('valor', $totalPago);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100c');
					*/
					$this->db_b->set('idrec', 0);
					$this->db_b->set('trannum', $idtrannum);
					$this->db_b->set('useridprn', $this->session->userdata('iduser'));
					$this->db_b->set('fechaprn', $fecha);
					$this->db_b->set('estatus', 0);
					$this->db_b->set('prncount', 0);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$query = $this->db_b->insert('tran_100p');
					
					$ConsultaTotaliza = "CALL totaliza100($idtrannum, 1)";
					$QueryTotaliza = $this->db_b->query($ConsultaTotaliza);
                    
                    $numeroDeVentas++;
				}
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + $numeroDeVentas;

                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $QueryUpdate = $this->db_b->update('gnums');
				
				return $QueryUpdate;
			}
		}
        
        function reporteExportacionVentas($idcentros, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$datosCentros = explode(",", $idcentros);
				$totalCentros = count($datosCentros);
				
				$ConsultaWhere = "(";
				
				for($i=0; $i<$totalCentros; $i++){
					$ConsultaWhere .= "tran_100.idcentro = ".$datosCentros[$i]." OR ";
				}
				
				$ConsultaWhere = substr($ConsultaWhere, 0, -3);
				$ConsultaWhere = $ConsultaWhere . ")";
				
                $ConsultaVN = "
                SELECT tran_100k.idrec, invsites.descrip AS nameSucursal, ctauxi3.descrip as nameProveedor, ctcajas.descrip AS nameCaja, tran_100.estatus, tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.notas, inv_def.descrip AS nameDocumento, tran_100k.itemline, tran_100k.um, invproducts.marca, invproducts.modelo, invproducts.tipo, invcatalog.descrip AS nameLinea, invcatalog2.descrip AS nameDepartamento, invproducts.idproducto, invproducts.comision, invproducts.descrip AS nameProducto, ctauxi.descrip AS nameCliente, ctauxi.nrc, ctauxi.dui, ctauxi.nit, ctauxi.telefono AS telefonoCliente, ctauxi.correo AS correoCliente, ctauxi2.descrip AS nameVendedor, tran_100k.costounitario, tran_100k.uniconv, tran_100k.precioneto, tran_100k.tax1, tran_100k.cantidad, tran_100k.descuento,
                IF(invproducts.tipo = 4, 9999, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS cantidadstock,
                tran_100k.notas AS nameServicio 
                FROM tran_100k 
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja 
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                LEFT JOIN ctauxi AS ctauxi2 ON tran_100k.idworker = ctauxi2.idauxi
				LEFT JOIN ctauxi AS ctauxi3 ON ctauxi3.idauxi = invproducts.idprovee
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                WHERE " . $ConsultaWhere . " AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND fecha BETWEEN '$fechaini' AND '$fechafin'  GROUP BY tran_100k.idrec";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }
        
        function getListadoClientesProductosVentas($idcentro, $idcaja, $fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.descrip AS nameCliente, invproducts.descrip AS nameProducto, invproducts.imagen, tran_100.trannum, tran_100.numero, tran_100.serie, tran_100k.preciotran, tran_100k.cantidad, tran_100k.idrec FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha = '$fecha' ORDER BY tran_100.numero DESC";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
				
				return $informacion;
            }
        }
        
        function getInformacionProductoTicket($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.descrip AS nameProducto, invproducts.idproducto FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $informacion = $query->result();
				
				return $informacion;
            }
        }
        
        function getSerieNumeroDocumento($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT fecha, serie, numero FROM tran_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $informacion = $query->row_array();
				return $informacion;
            }
        }
        
        function deleteVenta100c($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM tran_100c WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function getListadoMultiplesPrecios($idproducto, $estado, $prodmulti){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um, invpromulti.uniconv FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto";
                $QueryMulti = $this->db_b->query($ConsultaMulti);
				
				if($QueryMulti->num_rows() > 0){
					$infoMulti = $QueryMulti->result();
				}else{
					$infoMulti = false;
				}
				
				return $infoMulti;
            }
        }
        
        function getListadoMultiplesPreciosLP($idproducto, $estado, $prodmulti, $pos_lprecio, $nlPrecios){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                if ($pos_lprecio == 0) {
                    $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um, invpromulti.uniconv, invpromulti.askpwd FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto";
                } else {
                    if ($nlPrecios == '') {
                        $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um, invpromulti.uniconv, invpromulti.askpwd FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto";
                    } else {
                        $wherePrecio = "(";
                        $infoPrecio = explode("|", $nlPrecios);
                        
                        for($i=0; $i<count($infoPrecio); $i++){
                            $wherePrecio .= "invpromulti.descrip = '".$infoPrecio[$i]."' OR ";
                        }
                        
                        $wherePrecio = substr($wherePrecio, 0, -4);
                        $wherePrecio .= ")";

                        $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um, invpromulti.uniconv, invpromulti.askpwd FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto AND $wherePrecio";
                    }
                }
                
                $QueryMulti = $this->db_b->query($ConsultaMulti);
				
				if($QueryMulti->num_rows() > 0){
					$infoMulti = $QueryMulti->result();
				}else{
					$infoMulti = false;
				}
				
				return $infoMulti;
            }
        }

        function getListadoMultiplesPreciosCount($idproducto, $estado, $prodmulti){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um, invpromulti.uniconv FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto";
                $QueryMulti = $this->db_b->query($ConsultaMulti);
				
				if($QueryMulti->num_rows() > 0){
					$infoMulti = 1;
				}else{
					$infoMulti = 0;
				}
				
				return $infoMulti;
            }
        }
        
        function getMultiplePrecio($idproducto, $estado, $prodmulti){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ConsultaMulti = "SELECT invpromulti.descrip, invpromulti.precioventa, invpromulti.highrange, invpromulti.lowrange, invproducts.um FROM invpromulti INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = $prodmulti AND invpromulti.estatus = $estado AND invpromulti.idproducto = $idproducto LIMIT 1";
                $QueryMulti = $this->db_b->query($ConsultaMulti);
				
				if($QueryMulti->num_rows() > 0){
					$infoMulti = $QueryMulti->row_array();
				}else{
					$infoMulti = false;
				}
				
				return $infoMulti;
            }
        }
        
        function getPagosDoc($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.cajclase, caj_def.descrip from tran_100c INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase where tran_100c.trannum=$trannum AND caj_def.agrupa='VN'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$info = $query->result();
				}else{
					$info = false;
				}
				return $info;
            }
        }
        
        function getGruposInventarioMarcas($idcentro, $sMateriaP = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fProducto = ($sMateriaP == 1) ? '(invproducts.tipo = 1 OR invproducts.tipo = 2)' : '(invproducts.tipo = 1)';

                $consulta = "SELECT DISTINCT invproducts.marca AS descrip FROM invproducts INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND $fProducto ORDER BY invproducts.marca";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventarioModelos($idcentro, $sMateriaP = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fProducto = ($sMateriaP == 1) ? '(invproducts.tipo = 1 OR invproducts.tipo = 2)' : '(invproducts.tipo = 1)';

                $consulta = "SELECT DISTINCT invproducts.modelo AS descrip FROM invproducts INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND $fProducto ORDER BY invproducts.modelo";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getInventarioByMarcas($idtrannum, $descrip, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.tipo, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.marca = '$descrip' AND invproducts.estado = 1";
                $consulta = "
                SELECT 
				    invproducts.idcatalogo,
				    invproducts.tipotax,
				    invproducts.upp,
				    invproducts.tipo,
				    invproducts.xpos,
				    invproducts.idproducto,
				    invproducts.tipotax,
				    invproducts.descrip,
				    invproducts.presenta,
				    invproducts.marca,
				    invproducts.imagen,
				    invproducts.um,
				    invproducts.modelo,
				    invproducts.precioventa,
				    invproducts.barcode,
				    invproducts.notas,
				    SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
				    inv_batch.costounitario,
				    invlocations.idbin,
				    inv_batch.idbatch,
				    (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe
				FROM
				    tran_100k
				    INNER JOIN
				    invproducts ON tran_100k.idproducto = invproducts.idproducto
				    INNER JOIN
				    inv_batch ON invproducts.idproducto = inv_batch.idproducto
				    INNER JOIN
				    invlocations ON invlocations.idcentro = tran_100k.idcentro
				WHERE
				    tran_100k.idcentro = $idcentro
				        AND invproducts.marca = '$descrip'
				        AND invproducts.estado = 1
				GROUP BY tran_100k.idproducto
				HAVING SUM(tran_100k.cantidad * tran_100k.uniconv) > 0";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioByModelos($idtrannum, $descrip, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.tipo, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.modelo = '$descrip' AND invproducts.estado = 1";
                $consulta = "
                SELECT 
				    invproducts.idcatalogo,
				    invproducts.tipotax,
				    invproducts.upp,
				    invproducts.tipo,
				    invproducts.xpos,
				    invproducts.idproducto,
				    invproducts.tipotax,
				    invproducts.descrip,
				    invproducts.presenta,
				    invproducts.marca,
				    invproducts.imagen,
				    invproducts.um,
				    invproducts.modelo,
				    invproducts.precioventa,
				    invproducts.barcode,
				    invproducts.notas,
				    SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
				    inv_batch.costounitario,
				    invlocations.idbin,
				    inv_batch.idbatch,
				    (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe
				FROM
				    tran_100k
				    INNER JOIN
				    invproducts ON tran_100k.idproducto = invproducts.idproducto
				    INNER JOIN
				    inv_batch ON invproducts.idproducto = inv_batch.idproducto
				    INNER JOIN
				    invlocations ON invlocations.idcentro = tran_100k.idcentro
				WHERE
				    tran_100k.idcentro = $idcentro
				        AND invproducts.modelo = '$descrip'
				        AND invproducts.estado = 1
				GROUP BY tran_100k.idproducto
				HAVING SUM(tran_100k.cantidad * tran_100k.uniconv) > 0";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioByServicios($trannum, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				#$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.idproducto, invproducts.tipo, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, IFNULL(inv_stock.cantidad, 999999) AS cantidad, IFNULL(invproducts.costounitario, 0) AS costounitario, (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1) AS idbin, IFNULL(inv_stock.idbatch, 9999) AS idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_stock ON inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro WHERE invproducts.estado = 1 AND invproducts.tipo = 4 ORDER BY invproducts.descrip";
				$consulta = "SELECT  invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.idproducto, invproducts.tipo, invproducts.presenta,
				    invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.xpos, 
				    invproducts.precioventa, invproducts.barcode, invproducts.notas, (999999) AS cantidad, (0) AS costounitario,
				    (SELECT invlocations.idbin FROM invlocations WHERE invlocations.idcentro = $idcentro AND invlocations.estatus = 1 LIMIT 1) AS idbin,
				    (9999) AS idbatch,
				    (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
				FROM invproducts
				WHERE invproducts.estado = 1 AND invproducts.tipo = 4 ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                
                return $resultado;
			}
		}

		function getCantidadInventarioByServicios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT idproducto FROM invproducts WHERE estado = 1 AND tipo = 4";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$cantidad = 1;
				}else{
					$cantidad = 0;
				}
                
                return $cantidad;
			}
		}

		function getDataProductosVenta($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.copartida, invproducts.marca, invproducts.modelo, invproducts.um, invproducts.tipo, invproducts.tipotax, invproducts.barcode, invproducts.xpos, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um, tran_100k.uniconv, tran_100k.idworker, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataProductosVentaDescuento($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.modelo, invproducts.um, invproducts.tipo, invproducts.tipotax, invproducts.precioventa as proPrecioVenta, invproducts.barcode, invproducts.xpos, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um, tran_100k.uniconv, tran_100k.idworker, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, IF(tran_100.ovnumero = '', 0, tran_100.ovnumero) AS ovnumero FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataProductosVentaAlterDescrip($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.modelo, invproducts.um, invproducts.tipo, invproducts.tipotax, invproducts.barcode, invproducts.xpos, invproducts.codescrip, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um, tran_100k.uniconv, tran_100k.idworker, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

		function getListadoTransaccionesDisponibles($agrupa, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invclase, descrip, numgrupo, numtipo FROM inv_def WHERE agrupa = '$agrupa' AND estatus = '$estado' AND inopera = -1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function verificacionKeyUsuario($textoKey){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT iduser, derechos FROM gusers WHERE estado = 1 AND derechos != ''";
                $Query = $this->db_b->query($Consulta);
                $informacion = $Query->result();

                $idusuario = 0;
                foreach($informacion as $info){
               		$array = explode(",", $info->derechos);
               		for($i=0; $i<count($array); $i++){
               			$cantLetras = strlen($array[$i]);
               			if($cantLetras > 3){
               				if(substr($array[$i], 0, 3) == "pos"){
               					if(substr($array[$i], 3) == $textoKey){
               						$idusuario = $info->iduser;
               					}
               				}
               			}
               		}
                }
                
                return $idusuario;
            }	
        }

        function verificacionCodeUsuario($idusuario, $textoKey){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT password FROM gusers WHERE iduser = $idusuario";
                $Query = $this->db_b->query($Consulta);
                $informacion = $Query->row_array();

                $validate = 0;
                $cifrado = '$EgGa8466-2$/';
                $contrasena = md5($cifrado.$textoKey);

                if($contrasena == $informacion['password']){
                	$validate = 1;
                }

                return $validate;
            }
        }

        function getListadoVariablesFacturacion($idusario){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	$idcentro = $this->session->userdata('idcentroTemp');
            	$idcaja = $this->session->userdata('idcajaTemp');

            	if($idusario != 1){
                	$Consulta = "SELECT idrnum, nombre, descripcion, valor_num FROM gvars WHERE nombre LIKE 'pos_rprint0".$idcentro."' OR nombre LIKE 'pos_cliente0".$idcentro."' OR nombre LIKE 'pos_cajafast0".$idcaja."' OR nombre LIKE 'pos_sendprint0".$idcaja."' OR nombre LIKE 'pos_easy0".$idcaja."'";
            	}else{
            		$Consulta = "SELECT idrnum, nombre, descripcion, valor_num FROM gvars WHERE nombre LIKE 'pos_%'";
            	}
                $Query = $this->db_b->query($Consulta);
                $informacion = $Query->result();

                return $informacion;
            }
        }

        function updateRegistroVariableSecurity($idrnum, $valor, $whodidit){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
				
				$this->db_b->set('valor_num', $valor);
				$this->db_b->set('whodidit', $whodidit);
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('idrnum', $idrnum);
				$query = $this->db_b->update('gvars');
				
				return $query;
            }	
        }
                
        function validacionFormularioUnico($idcaja, $idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT valor_num, filtro FROM gvars WHERE nombre = 'pos_fu0".$idcaja."'";
                $sqlqu = $this->db_b->query($sqlcon);
                if($sqlqu->num_rows() > 0){
                    $datos = $sqlqu->row_array();
                    $codigosClases = explode(",", $datos['filtro']);
                    
                    $validate=0;
                    for($i=0; $i<count($codigosClases); $i++){
                        if($codigosClases[$i] == $idclase){
                            $validate=1;
                        }
                    }
                    
                    $idrnum = $datos['valor_num'];
                    if($validate == 1){
                        $consulta = "SELECT actual FROM gnums WHERE idrnum = $idrnum";
                        $sqlQuery = $this->db_b->query($consulta);
                        $resSQl = $sqlQuery->row_array();
                        $actual = $resSQl['actual'];
                        
                        $actual = $actual + 1;
                        
                        $this->db_b->set('actual', $actual);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrnum', $idrnum);
                        $query = $this->db_b->update('gnums');
                        
                        return $actual;
                    }else{
                        $numero = 0;
                    }                    
                }else{
                    $numero = 0;
                }
                
                return $numero;
            }
		}
        
        function updateRegistroFormUnico($trannum, $numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('ovnumero', $numero);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }

        function getResumenVentasPorVendedor($fecha, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.descrip AS namevendedor, SUM(IF(caj_def.descrip LIKE '%efectivo%', (tran_100c.valor - tran_100c.vuelto), 0)) AS efectivo,
                    SUM(IF(caj_def.descrip LIKE '%tarjeta%', (tran_100c.valor - tran_100c.vuelto), 0)) AS tarjeta, SUM(tran_100c.valor - tran_100c.vuelto) AS total,
                    COUNT(DISTINCT tran_100.trannum) AS numventas, SUM(tran_100.lines100k) AS undfacturadas
                FROM tran_100c
                INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum
                INNER JOIN ctauxi ON ctauxi.idauxi = tran_100c.idworker
                INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase
                WHERE tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha = '$fecha' AND tran_100.estatus = 1
                GROUP BY tran_100c.idworker";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
                
                return $informacion;
            }
        }

        function getResumenVentasPorProducto($fecha, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.descrip AS namevendedor, invcatalog.descrip AS namelinea, invproducts.descrip, invproducts.marca, invproducts.modelo, invproducts.idproducto,
                    SUM(tran_100k.cantidad * tran_100k.uniconv) AS unidades,
                    SUM(tran_100k.precioneto * (tran_100k.cantidad * tran_100k.uniconv)) AS valsiniva,
                    SUM(((tran_100k.precioneto) * (1 + (tran_100k.tax1 / 100))) * (tran_100k.cantidad * tran_100k.uniconv)) AS valconiva,
                    (SELECT SUM(tk2.cantidad * tk2.uniconv) FROM tran_100k AS tk2 WHERE tk2.idproducto = tran_100k.idproducto AND tk2.idcentro = $idcentro) AS existencias
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN ctauxi ON ctauxi.idauxi = tran_100.idworker
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase AND inv_def.agrupa = 'VN'
                WHERE tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha = '$fecha' AND tran_100.estatus = 1
                GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$informacion = $query->result();
				}else{
					$informacion = false;
				}
                
                return $informacion;
            }
        }

        function updateDatosFEL($uuid, $serie, $numero, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('referencia', $uuid.';'.$serie.';'.$numero);
                $this->db_b->set('serie', $serie);
                $this->db_b->set('numero', $numero);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$query = $this->db_b->update('tran_100');
                
                return $query;
            }
        }
        
        function getDatosFelFactura($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT fecha, referencia FROM tran_100 WHERE trannum = $trannum";
                $Query = $this->db_b->query($Consulta);
				$informacion = $Query->row_array();
				
                return $informacion;
            }
        }
        #------------------------------------------------------ VENTAS POR CLIENTE ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #   GET CLIENTES
        public function getClientes()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", 2);
                $this->db_b->where("estado", 1);
                $this->db_b->order_by("descrip", "ASC");
                $dato = $this->db_b->get();
                return $dato;
            }
        }
        #   GET REGISTROS
        public function getVentasxCliente($ID, $fechai, $fechaf)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("a.trannum, c.descrip as sucursal, b.fecha, d.descrip as ttransaccion, a.itemline, a.idproducto, e.descrip as producto, f.descrip as linea, a.costounitario, a.preciotran, a.precioneto, a.tax1, (a.cantidad*a.uniconv)*-1 as cantidad, (a.cantidad*a.uniconv*a.preciotran)*-1 as preciototal, b.serie, b.numero, g.descrip as vendedor");
                $this->db_b->from("tran_100k a");
                $this->db_b->join("tran_100 b", "a.trannum = b.trannum");
                $this->db_b->join("invsites c", "b.idcentro = c.idcentro");
                $this->db_b->join("inv_def d", "b.idclase = d.invclase");
                $this->db_b->join("invproducts e", "a.idproducto = e.idproducto");
                $this->db_b->join("invcatalog f", "e.idcatalogo = f.idcatalogo");
                $this->db_b->join("ctauxi g", "g.idauxi = b.idworker");
                $this->db_b->where("b.fecha >=", $fechai);
                $this->db_b->where("b.fecha <=", $fechaf);
                $this->db_b->where("b.idcps", $ID);
                $this->db_b->where("b.estatus", 1);
                $this->db_b->where("a.cantidad !=", 0);
                $this->db_b->order_by("a.trannum", "ASC");
                $dato = $this->db_b->get();
                return $dato;
            }
        }
        #------------------------------------------------------ FIN VENTAS POR CLIENTE ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

        function getInformacionCobros($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $Consulta = "SELECT CONCAT(descrip, ' (', notas, ')') AS infoCobros FROM ctauximulti WHERE idauxi = $idcps AND idgvar = 3";
                $Query = $this->db_b->query($Consulta);

                if($Query->num_rows() > 0){
                    $informacion = $Query->row_array();
                    $infoCobros = $informacion['infoCobros'];
                }else{
                    $infoCobros = '';
                }
				
                return $infoCobros;
            }
        }

        #------------------ EMGG 20210323
        function getmCuotas($fecha_ini, $fecha_fin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
                $consulta = "SELECT DATE_FORMAT(tran_100k.um,'%m-%b/%Y') AS Fecha,ctauxi.descrip AS Cliente,tran_100k.precioneto AS Valor,gvars.descripcion AS Tipo, invproducts.descrip AS Descrip
                FROM tran_100k
                INNER JOIN ris_100 ON tran_100k.invcontrol=ris_100.trannum
                INNER JOIN ctauxi on ris_100.idcps=ctauxi.idauxi 
                INNER JOIN gvars ON ris_100.ris_tipo = gvars.valor_num AND gvars.nombre = 'ris_tipo'
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.barcode='0' and tran_100k.precioneto >0 AND tran_100k.um BETWEEN '$fecha_ini' AND '$fecha_fin' AND tran_100k.precioneto > 0 ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function buscarCodigoImei($codeIMEI, $trannum, $provende, $modevn, $idworker, $idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.idproducto, a.descrip AS imei, b.descrip AS producto, b.um, b.modelo, b.pro_color, b.precioventa, b.tipotax, c.idbatch, d.idbin');
                $this->db_b->from("invpromulti a");
                $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
                $this->db_b->join("inv_batch c", "a.idproducto = c.idproducto");
                $this->db_b->join("invlocations d", "d.idcentro = $idcentro");
                $this->db_b->like("a.descrip", $codeIMEI);
                $this->db_b->where("a.estatus", 1);
                $this->db_b->where("b.estado", 1);
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    $inf = $result->row();
                    
                    $this->insertarProductoVentaUM($inf->idproducto, 1, 1, $trannum, 0, $inf->precioventa, $inf->idbin, $inf->idbatch, $inf->um, $idworker, 'Agregado desde imp_imei', $inf->tipotax, $provende, $modevn, $codeIMEI);
                    $this->db_b->query('call imeictl(2, 0, "'.$codeIMEI.'", 0, 0)');

                    return 1;
                } else return 0;
            }
        }
        
        function getDataVentaTran100kIMEI($trannum, $idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.idrec, a.idproducto, b.descrip, b.modelo, a.barcode, ABS(a.cantidad) AS cantidad FROM tran_100k a
                INNER JOIN invproducts b ON b.idproducto = a.idproducto
                WHERE a.trannum = $trannum AND a.notas LIKE '%imei%' ORDER BY a.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function deleteCodigoIMEI($idrec, $codeIMEI) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->query('DELETE FROM tran_100k WHERE idrec = '.$idrec);
                $this->db_b->query('call imeictl(3, 0, "'.$codeIMEI.'", 0, 0)');
                
                return true;
            }
        }

        function setCommandsPrint($trannum, $cmds, $tipo = 1) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                switch ($tipo) {
                    case 1:
                        $this->db_b->set('notas', $cmds);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('trannum', $trannum);
                        $query = $this->db_b->update('tran_100p');
                        break;
                    case 2:
                        $this->db_b->select('a.idrec');
                        $this->db_b->from("tran_100p a");
                        $this->db_b->where("a.imagen", $trannum);
                        $result = $this->db_b->get();

                        if ($result->num_rows() == 0) {
                            $this->db_b->set('notas', $cmds);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $this->db_b->set('imagen', $trannum);
                            $query = $this->db_b->insert('tran_100p');
                        } else {
                            $info = $result->row();
                            $this->db_b->set('notas', $cmds);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->where('idrec', $info->idrec);
                            $query = $this->db_b->update('tran_100p');
                        }
                        break;
                    default:
                        break;
                }

                return $query;
            }
        }

        function getTiposIG($optIG) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.cajclase AS id, a.descrip');
                $this->db_b->from("caj_def a");
                $this->db_b->where("a.agrupa", (($optIG == 0) ? 'OI' : 'OE'));
                $this->db_b->where("a.estatus", 1);
                $result = $this->db_b->get()->result();
                return $result;
            }
        }

        function getFormasPagoOI($optIG) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.cajclase AS id, a.descrip');
                $this->db_b->from("caj_def a");
                $this->db_b->where("a.agrupa", 'VN');
                if ($optIG == 1) {
                    $this->db_b->where("a.alcuadre", 1);
                }
                $this->db_b->where("a.estatus", 1);
                $result = $this->db_b->get()->result();
                return $result;
            }
        }

        function getDetalleCorteOI($optIG, $idcentro, $idcaja, $numx, $numz) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.descrip, a.referencia, a.notas AS concepto, b.cajclase, ABS(a.valorusr) AS valorusr, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.numz", $numz);
                $this->db_b->where("a.numx", $numx);
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.tipo", (($optIG == 0) ? 11 : 12));
                $result = $this->db_b->get()->result();
                return $result;
            }
        }

        function getDetalleCorteOICorteZ($optIG, $idcentro, $idcaja, $numz) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.descrip, a.referencia, a.notas AS concepto, b.cajclase, ABS(a.valorusr) AS valorusr, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.numz", $numz);
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.tipo", (($optIG == 0) ? 11 : 12));
                $result = $this->db_b->get()->result();
                
                return $result;
            }
        }

        function getFormasPagoCorteXOI($idcentro, $idcaja, $numx, $numz) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT b.cajclase, b.descrip FROM tran_100z a
                            INNER JOIN caj_def b ON b.cajclase = a.cajclase
                            WHERE a.numz = $numz AND a.numx = $numx AND a.idcentro = $idcentro AND a.idcaja = $idcaja AND ( a.tipo = 12 OR a.tipo = 11)
                            GROUP BY b.cajclase";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
				return $resultado;
            }
        }

        function getFormasPagoCorteZOI($idcentro, $idcaja, $numz) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT b.cajclase, b.descrip FROM tran_100z a
                INNER JOIN caj_def b ON b.cajclase = a.cajclase
                WHERE a.numz = $numz AND a.idcentro = $idcentro AND a.idcaja = $idcaja AND ( a.tipo = 12 OR a.tipo = 11)
                GROUP BY b.cajclase";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }


        function insertComprobanteIG($optIG, $fecha, $numx, $numz, $idcaja, $idcentro, $valor, $tipoIG, $cajclase, $concepto) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set("idrec", 0);
                $this->db_b->set("fechahora", $fecha.' 00:00:00');
                $this->db_b->set("numz", $numz);
                $this->db_b->set("numx", $numx);
                $this->db_b->set("idcentro", $idcentro);
                $this->db_b->set("idcaja", $idcaja);
                $this->db_b->set("descrip", (($optIG == 0) ? 'OTROS INGRESOS' : 'OTROS EGRESOS'));
                $this->db_b->set("cajclase", $cajclase);
                $this->db_b->set("tipo", (($optIG == 0) ? 11 : 12));
                $this->db_b->set("referencia", $tipoIG);
                $this->db_b->set("valorusr", (($optIG == 0) ? $valor : ($valor * -1)));
                $this->db_b->set("estatus", 1);
                $this->db_b->set("notas", $concepto);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100z');
                $idrec = $this->db_b->insert_id();

                return $idrec;
            }
        }

        function validatePasswordAnulacionIG($idrec, $password) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $validate = $this->getValidatePassword($password);

                if ($validate == 1) {
                    $this->db_b->set('valorusr', 0);
                    $this->db_b->set('estatus', 9);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $idrec);
                    $this->db_b->update('tran_100z');

                    return 1;
                } else return 0;
            }
        }

        function getDetalleOI($idrec) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.descrip, a.referencia, a.notas AS concepto, ABS(a.valorusr) AS valor, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus, a.numz, a.numx, a.idcaja');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.idrec", $idrec);
                $result = $this->db_b->get()->row_array();
                return $result;
            }
        }

        function getDetalleAniosCortesZ($idcentro, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('DATE_FORMAT(a.fechahora, "%Y") AS id, DATE_FORMAT(a.fechahora, "%Y") AS namefecha');
                $this->db_b->from("tran_100z a");
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->group_by("namefecha");
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }
        
        function getDetalleMesesCortesZ($idcentro, $idcaja, $idanio) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #Dates in Spanish.--
                $this->db_b->query('SET lc_time_names = "es_ES"');

                $this->db_b->select('DATE_FORMAT(a.fechahora, "%m") AS id, UPPER(DATE_FORMAT(a.fechahora, "%M")) AS nameMes');
                $this->db_b->from("tran_100z a");
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("DATE_FORMAT(a.fechahora, '%Y') =", $idanio);
                $this->db_b->group_by("nameMes");
                $this->db_b->order_by("id", "ASC");
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }

        function getDetalleIngresosReporte($fechaini, $fechafin, $tipo) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.fecha, c.idcaja, c.descrip AS nameCaja, d.descrip AS formaPago, ABS(SUM(a.valor - a.vuelto)) AS valorTotal');
                $this->db_b->from("tran_100c a");
                $this->db_b->join("tran_100 b", 'a.trannum = b.trannum');
                $this->db_b->join("ctcajas c", 'b.idcaja = c.idcaja');
                $this->db_b->join("caj_def d", 'a.cajclase = d.cajclase');
                $this->db_b->join("invsites e", 'b.idcentro = e.idcentro');
                $this->db_b->where("b.fecha BETWEEN '$fechaini' AND '$fechafin'");
                $this->db_b->where("e.tipo", $tipo);
                $this->db_b->group_by("b.fecha, b.idcaja, a.cajclase");
                $this->db_b->order_by("b.idcaja", "ASC");
                $this->db_b->order_by("b.fecha", "ASC");
                $this->db_b->order_by("a.cajclase", "ASC");
                $result = $this->db_b->get();
                
                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }

        ## ANEXOS COTIZACION
        function getAnexosCotizacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("orders_100a a");
                $this->db_b->where("trannum", $trannum);
                
                $result = $this->db_b->get()->result_array();
                return $result;
            }
        }

        function getDistincFormasPago($fechaini, $fechafin, $tipocentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('d.cajclase, d.descrip');
                $this->db_b->from("tran_100c a");
                $this->db_b->join("tran_100 b", 'a.trannum = b.trannum');
                $this->db_b->join("caj_def d", 'a.cajclase = d.cajclase');
                $this->db_b->join("invsites e", 'b.idcentro = e.idcentro');
                $this->db_b->where("b.fecha BETWEEN '$fechaini' AND '$fechafin'");
                $this->db_b->where("e.tipo", $tipocentro);
                $this->db_b->group_by("d.cajclase");
                $this->db_b->order_by("d.descrip", "ASC");;
                $result = $this->db_b->get();
                
                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }

        function getDetalleFechaCajasReporte($fechaini, $fechafin, $tipocentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('DATE_FORMAT(b.fecha, "%d/%m/%Y") AS fechap, b.fecha, c.idcaja, c.descrip AS nameCaja');
                $this->db_b->from("tran_100c a");
                $this->db_b->join("tran_100 b", 'a.trannum = b.trannum');
                $this->db_b->join("ctcajas c", 'b.idcaja = c.idcaja');
                $this->db_b->join("invsites e", 'b.idcentro = e.idcentro');
                $this->db_b->where("b.fecha BETWEEN '$fechaini' AND '$fechafin'");
                $this->db_b->where("e.tipo", $tipocentro);
                $this->db_b->group_by("b.fecha, b.idcaja");
                $this->db_b->order_by("b.fecha", "ASC");
                $this->db_b->order_by("b.idcaja", "ASC");
                $result = $this->db_b->get();
                
                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }

        function getDetalleIngresosReporteN($fecha, $cajclase, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->select('ABS(SUM(a.valor - a.vuelto)) AS total');
                $this->db_b->select('SUM(a.valor - a.vuelto)*-1 AS total');
                $this->db_b->from("tran_100c a");
                $this->db_b->join("tran_100 b", 'a.trannum = b.trannum');
                $this->db_b->join("ctcajas c", 'b.idcaja = c.idcaja');
                $this->db_b->join("caj_def d", 'a.cajclase = d.cajclase');
                $this->db_b->join("invsites e", 'b.idcentro = e.idcentro');
                $this->db_b->where("b.fecha", $fecha);
                $this->db_b->where("b.idcaja", $idcaja);
                $this->db_b->where("d.cajclase", $cajclase);
                $this->db_b->group_by("d.cajclase");
                $result = $this->db_b->get();
                
                if ($result->num_rows() > 0) {
                    return $result->row_array();
                } else return false;
            }
        }

        function getDetalleFechaCortesZ($idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #Dates in Spanish.--
                $this->db_b->select('numz');
                $this->db_b->from("tran_100z a");
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.fechahora >=", $fechaini);
                $this->db_b->where("a.fechahora <=", $fechafin);
                $this->db->distinct();
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->row_array();
                } else return false;
            }
        }

        function getDetalleFechaCortesX($idcentro, $idcaja, $fechaini, $fechafin, $numz){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #Dates in Spanish.--
                $this->db_b->select('numx');
                $this->db_b->from("tran_100z");
                $this->db_b->where("idcentro", $idcentro);
                $this->db_b->where("idcaja", $idcaja);
                $this->db_b->where("fechahora >=", $fechaini);
                $this->db_b->where("fechahora <=", $fechafin);
                $this->db_b->where("tipo", 1);
                $this->db_b->where("numz", $numz);
                $this->db_b->group_by('numx');

                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->result_array();
                } else return false;
            }
        }
        
        function getCodigoImpresion($trannum, $tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                #Dates in Spanish.--
                switch($tipo){
                    case 1: //ticket
                        $this->db->distinct();
                        $this->db_b->select('*');
                        $this->db_b->from("tran_100p a");
                        $this->db_b->where("a.trannum", $trannum);
                        break;
                    case 2: //corte
                        $this->db->distinct();
                        $this->db_b->select('*');
                        $this->db_b->from("tran_100p a");
                        $this->db_b->where("a.imagen", $trannum);
                        break;
                }
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->row_array();
                } else return false;
            }
        }

        function getDatosFacturacionesNumXZ($agrupa, $idcentro, $idcaja, $fechaini, $fechafin, $numz, $numx){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                $consulta = "SELECT t100.trannum
                FROM tran_100 AS t100 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND invdef.esticket = 1
                                        AND t100.fecha = '$fechaini' AND t100.numz = $numz AND t100.numx = $numx AND t100.numero != 0";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result_array();
                return $resultado;
            } 
        }

        function getUcajera($idcaja, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT ucajera FROM ctcajas WHERE idcaja = $idcaja AND idcentro = $idcentro";
				$query = $this->db_b->query($consulta);
				$resultado = $query->row_array();
				
				return $resultado['ucajera'];
            }
		}

        function validacionClienteDocumento($field, $registro, $idcliente) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                switch ($field) {
                    case 1:
                        $campo = "descrip";
                        break;
                    case 2:
                        $campo = "telefono";
                        break;
                    case 3:
                        $campo = "correo";
                        break;
                    case 4:
                        $campo = "dui";
                        break;
                    case 5:
                        $campo = "nrc";
                        break;                    
                    default:
                        $campo = "dui";
                        break;
                }

				$this->db_b->select('idauxi, descrip');
                $this->db_b->from("ctauxi");
                $this->db_b->where($campo, $registro);
                $this->db_b->where("idauxidef", 2);
                $this->db_b->where("estado", 1);
                if ($idcliente != 999999) $this->db_b->where("idauxi !=", $idcliente);
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return false;
                } else return true;
            }
        }

        function getValidacionCamposVenta($idclase) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('reqflds');
                $this->db_b->from("inv_def");
                $this->db_b->where("invclase", $idclase);
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->row()->reqflds;
                } else return false;
            }
        }
        
        function validacionAperturaDeCaja($idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('cajaopen');
                $this->db_b->from("ctcajas");
                $this->db_b->where("idcaja", $idcaja);
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    if($result->row()->cajaopen == 1){
                        return false;
                    } else return true;
                } else return false;
            }
        }

        function getVentasProveeA($fecha_ini, $fecha_fin, $idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS Fecha, DATE_FORMAT(tran_100.ingresa, '%H') AS Hora, tran_100.fecha AS Dia, IFNULL(ctauxi3.descrip, 'SIN PROVEEDOR') AS Proveedor, ctauxi2.descrip AS Cliente, ctauxi.descrip AS Vendedor,
                    invcatalog.descrip AS Línea, invcatalog2.descrip AS Departamento,
                    ((tran_100k.cantidad * tran_100k.precioneto) *- 1 ) AS Ventas,
                    (((tran_100k.cantidad * tran_100k.uniconv) * tran_100k.costounitario) * - 1) AS Costos,
                    ((tran_100k.cantidad * tran_100k.uniconv) * inv_def.inopera) AS Unidades,
                    tran_100k.idproducto AS Hits,
                    inv_def.descrip AS Transaccion, IFNULL(ctauximulti.descrip, ctauxi2.descrip) AS Suc_Cliente,
                    invsites.descrip AS Sucursal, invproducts.descrip AS Producto, invproducts.xpos, invproducts.marca AS Marca, invproducts.modelo AS Modelo, invproducts.idproducto, ctauxi2.grupo AS Grupo
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro
                INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                INNER JOIN ctauxi AS ctauxi3 ON ctauxi3.idauxi = invproducts.idprovee AND ctauxi3.idauxi = $idcps AND ctauxi3.idauxi != 0
                LEFT JOIN  ctauximulti ON tran_100.idcentrod = ctauximulti.idrec 
                WHERE tran_100.estatus = 1 AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN '$fecha_ini' AND '$fecha_fin'";

                #GROUP BY tran_100.fecha, tran_100.idcentro, tran_100.idcps, tran_100k.idworker, invcatalog.idcatalogo, invproducts.idproducto
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        //  CREDITOS DE VENTAS

        function getCreditosVentasCliente($idauxi){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                
                $consulta ="SELECT
                                ctauxi.idauxi,
                                ctauxi.descrip,
                                ctauxi.grupo,
                                ctauxi.dias,
                                ctauxi.limite,
                                tran_100.trannum,
                                tran_100.fecha,
                                DATEDIFF(NOW(), tran_100.fecha) AS dias,
                                inv_def.descrip AS tipoDoc,
                                tran_100.fecha,
                                tran_100.serie, 
                                tran_100.numero,
                                tran_100.ccestatus,
                                tran_100.valventan,
                                tran_100.valcosto,
                                tran_100.valtax1,
                                tran_100.valtax2,
                                tran_100.valtax3,
                                tran_100.valtax4,
                                tran_100.valtax5,
                                tran_100.valdh,
                                tran_100.idclase
                            FROM
                                ctauxi
                            INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE
                                ctauxi.idauxi = $idauxi
                                AND inv_def.agrupa = 'VN'
                                AND tran_100.estatus = 1
                                AND tran_100.ccestatus = 0
                                AND ctauxi.limite > 0

                            GROUP BY tran_100.trannum
                            ORDER BY
                                tran_100.fecha,
                                tran_100.trannum ASC";
                            
                                
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();

                }else{
                    $resultado = false;

                }
                return $resultado;
            }
        }

        function cancelarCreditosVentas($montoabono, $formapago,$notas,$docs, $tipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $valido = true;
                $this->db_b->trans_begin();   //INICIO DE TRANSACCION
                
                if($tipo == 0){
                    foreach($docs as $doc){
                        $this->db_b->set('trannum', $doc["trannum"]);
                        $this->db_b->set('idclase', $doc["idclase"]);
                        $this->db_b->set('fecha',  $date->format('Y-m-d'));
                        $this->db_b->set('itemline',  $this->getLastItemLineTran100c($doc["trannum"]));
                        $this->db_b->set('cajclase',  $formapago);
                        $this->db_b->set('valor',  abs($doc["saldoPendiente"])*-1);
                        $this->db_b->set('notas',  $notas);
                        $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100c');
                    }
                }elseif($tipo == 1){
                    $this->db_b->set('trannum', $docs["trannum"]);
                    $this->db_b->set('idclase', $docs["idclase"]);
                    $this->db_b->set('fecha',  $date->format('Y-m-d'));
                    $this->db_b->set('itemline',  $this->getLastItemLineTran100c($docs["trannum"]));
                    $this->db_b->set('cajclase',  $formapago);
                    $this->db_b->set('valor',  abs($montoabono)*-1);
                    $this->db_b->set('notas',  $notas);
                    $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $this->db_b->insert('tran_100c');
                }else{
                    $valido = false;
                }
				
                if ($this->db_b->trans_status() === FALSE){
                    $this->db_b->trans_rollback();
                    $valido = false;
                }else{
                    $this->db_b->trans_commit();
                    $valido = true;
                }

				return $valido;
            }
		}

        function getLastItemLineTran100c($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT itemline FROM tran_100c WHERE trannum = $trannum ORDER BY itemline DESC LIMIT 1";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    $item = $query->row_array();
                    $itemline = $item['itemline'] + 1;
                }else{
                    $itemline = 1;
                }
                return $itemline;
            }
        }

        //  BITACORA VENTAS
        function getListadoCajasBitacora($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $where = implode(" OR idcentro = ", $idcentro);
                
                
                $consulta = "SELECT idcaja AS id, descrip FROM ctcajas WHERE idcentro = $where";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
                
            }
        }

        function getDatosFacturacionesBitacora($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja = str_replace("_", " OR t100.idcaja = ", $idcaja);
                $idcentro = implode(" OR t100.idcentro = ", $idcentro);
                $consulta = "SELECT t100.trannum, t100.ingresa, t100.notas, t100.fecha, t100.numx, t100.numz, t100.fecact, t100.estatus, t100.serie, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.nit, ctaucli.descrip AS namecliente, t100.idcps as idclienteauxi, IFNULL(ctauximulti.descrip, ctaucli.descrip) AS namesucursal, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valcosto, t100.valtax1,invdef.caopera,invdef.exento, t100.referencia, 
                d.serie AS dev_serie, d.numero AS dev_numero, ctcajas.descrip AS namecaja, invsites.descrip AS namecentro  
                FROM tran_100 AS t100 
                INNER JOIN ctcajas ON t100.idcaja = ctcajas.idcaja 
                INNER JOIN invsites ON ctcajas.idcentro = invsites.idcentro 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi 
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi 
                LEFT JOIN ctauximulti ON t100.idcentrod = ctauximulti.idrec 
                LEFT JOIN tran_100 d ON t100.tranref = d.trannum 
                WHERE invdef.agrupa = '$agrupa' AND (t100.idcentro = $idcentro) AND (t100.idcaja = $idcaja) AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecact, t100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getDatosReporteDetalleCxC($fechafin, $displayZeroBalance = 0){

            $zeroHaving = "";
            if($displayZeroBalance == 0){
                $zeroHaving = "HAVING ROUND(valVenta + saldoActual, 2) != 0";
            }
            $consulta = "SELECT
                ctauxi.idauxi,
                ctauxi.descrip,
                ctauxi.grupo,
                ctauxi.dias,
                ctauxi.limite,
                tran_100.trannum,
                tran_100.fecha,
                DATEDIFF(NOW(), tran_100.fecha) AS dias,
                inv_def.descrip AS tipoDoc,
                tran_100.fecha,
                tran_100.serie,
                tran_100.numero,
                tran_100.ccestatus,
                ROUND(tran_100.valventan + tran_100.valtax1, 4) + ROUND(tran_100.valtax2, 2) + ROUND(tran_100.valtax3, 2) + ROUND(tran_100.valtax4, 2) + ROUND(tran_100.valtax5, 2) AS valVenta,
                tran_100.idclase,
                IFNULL((SELECT SUM(tran_100c.valor) from tran_100c WHERE tran_100c.trannum = tran_100.trannum AND tran_100c.fecha <= '$fechafin'), 0) AS saldoActual
            FROM
                ctauxi
                INNER JOIN tran_100 ON tran_100.idcps = ctauxi.idauxi
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                INNER JOIN caj_def ON tran_100.numy = caj_def.cajclase
            WHERE
                inv_def.agrupa = 'VN'
                AND tran_100.fecha <= '$fechafin'
                AND tran_100.estatus = 1
                AND caj_def.creditchk = 1
            GROUP BY
                tran_100.trannum
                $zeroHaving
            ORDER BY
                tran_100.fecha,
                tran_100.trannum ASC";

            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        

        function getVentasDiarias($fecha_ini, $fecha_fin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS Fecha, DATE_FORMAT(tran_100.ingresa, '%H') AS Hora, tran_100.fecha AS Dia, IFNULL(ctauxi3.descrip, 'SIN PROVEEDOR') AS Proveedor, ctauxi2.descrip AS Cliente, ctauxi.descrip AS Vendedor,
                                invcatalog.descrip AS Línea, invcatalog2.descrip AS Departamento,
                                ((tran_100k.cantidad * tran_100k.precioneto) *- 1 ) AS Ventas,
                                (((tran_100k.cantidad * tran_100k.uniconv) * tran_100k.costounitario) * - 1) AS Costos,
                                ((tran_100k.cantidad * tran_100k.uniconv) * -1) AS Unidades,
                                tran_100k.idproducto AS Hits,
                                inv_def.descrip AS Transaccion, IFNULL(ctauximulti.descrip, ctauxi2.descrip) AS Suc_Cliente, ctcajas.descrip AS NameCaja, 
                                invsites.descrip AS Sucursal, invproducts.descrip AS Producto, invproducts.xpos, invproducts.marca AS Marca, invproducts.modelo AS Modelo, invproducts.idproducto, ctauxi2.grupo AS Grupo
                            FROM tran_100k
                            INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi
                            INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                            INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro
                            INNER JOIN ctcajas ON ctcajas.idcaja = tran_100.idcaja 
                            INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                            LEFT JOIN  ctauxi AS ctauxi3 ON ctauxi3.idauxi = invproducts.idprovee
                            LEFT JOIN  ctauximulti ON tran_100.idcentrod = ctauximulti.idrec 
                            WHERE tran_100.estatus = 1 AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN '$fecha_ini' AND '$fecha_fin'";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}

        function validateEstadoOrden($trannum, $estado) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('estatus');
                $this->db_b->from("tran_100");
                $this->db_b->where("trannum", $trannum);
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    if($result->row()->estatus == $estado){
                        return true;
                    } else return false;
                } else return true;
                
            }
        }

        function getReporteVendedorVentasPagos($agrupa, $idcentro, $idpagos, $fechaini, $fechafin, $idcliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               if ($idcliente == "4618") $idpagos  = implode(" OR f.cajclase = ", $idpagos);
                $idcentro = implode(" OR a.idcentro = ", $idcentro);

                $this->db_b->select('g.descrip, g.xpos, g.idauxi, SUM(a.costounitario * (ABS(a.cantidad) * a.uniconv)) AS costo, ABS(SUM((a.cantidad * a.uniconv) * (a.precioneto))) AS venta');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum');
                $this->db_b->join('invsites  c', 'a.idcentro = c.idcentro');
                $this->db_b->join('inv_def   d', 'a.idclase = d.invclase');
                if ($idcliente == "4618") $this->db_b->join('tran_100c f', 'a.trannum = f.trannum');
                if ($idcliente == "4618") $this->db_b->join('caj_def   e', 'f.cajclase = e.cajclase');
                $this->db_b->join('ctauxi    g', 'a.idworker = g.idauxi');
                $this->db_b->where("d.agrupa", $agrupa);
                $this->db_b->where("b.estatus", 1);
                $this->db_b->where('(a.idcentro = '.$idcentro.')');
                if ($idcliente == "4618") $this->db_b->where('(f.cajclase = '.$idpagos.')');
                $this->db_b->where('(b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->group_by('a.idworker');
                $this->db_b->order_by('g.descrip');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            } 
        }

        function getReporteVendedorVentasPagosCredito($agrupa, $idcentro, $idpagos, $fechaini, $fechafin, $idcliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if ($idcliente == "4618") $idpagos  = implode(" OR b.numy = ", $idpagos);
                $idcentro = implode(" OR a.idcentro = ", $idcentro);

                $this->db_b->select('g.descrip, g.xpos, g.idauxi, SUM(a.costounitario * (ABS(a.cantidad) * a.uniconv)) AS costo, ABS(SUM((a.cantidad * a.uniconv) * (a.precioneto))) AS venta');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum');
                $this->db_b->join('invsites  c', 'a.idcentro = c.idcentro');
                $this->db_b->join('inv_def   d', 'a.idclase = d.invclase');
                $this->db_b->join('caj_def   e', 'b.numy = e.cajclase AND e.creditchk = 1');
                $this->db_b->join('ctauxi    g', 'a.idworker = g.idauxi');
                $this->db_b->where("d.agrupa", $agrupa);
                $this->db_b->where("b.estatus", 1);
                $this->db_b->where('(a.idcentro = '.$idcentro.')');
                if ($idcliente == "4618") $this->db_b->where('(b.numy = '.$idpagos.')');
                $this->db_b->where('(b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->group_by('a.idworker');
                $this->db_b->order_by('g.descrip');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            } 
        }

        function getListaPrecioCliente($idcliente) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('lprecio');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxi', $idcliente);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row()->lprecio;
                } else return false;
            }
        }

        function getOrigenesDeVenta($nameVar) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descripcion, valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', $nameVar);
                $this->db_b->order_by('descripcion', 'ASC');
                $result = $this->db_b->get();

                if ($result->num_rows() > 0) {
                    return $result->result();
                } else return false;
            }
        }
	}
?>