<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
    
    class Tpedido_model extends CI_Model{
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        //Creado por Oscar Avelar 23/01/2019-----Obtiene el detalle de los productos en el modulo de Monitoreo de produccion
        function getDetalleProductosEntradaxCompra($sucursal,$fechaini,$fechafin,$idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "
                SELECT 
                    DATE_FORMAT(tran_100k.ingresa, '%h:%i %p') AS horaingreso,
                    DATE_FORMAT(tran_100k.ingresa, '%Y-%m-%d') AS fechaingreso,	
                    gusers.descrip AS nameingresado,
                    tran_100.fecha AS fecha,
                    invproducts.um,
                    invproducts.descrip,
                    invproducts.modelo, 
                    tran_100k.idrec,
                    tran_100k.trannum,
                    tran_100k.idproducto,
                    tran_100k.cantidad,
                    tran_100k.barcode,                    
                    invcatalog.descrip AS departamento,
                    invlineas.descrip AS linea
                FROM
                    tran_100k
                        INNER JOIN
                    tran_100 ON tran_100k.trannum = tran_100.trannum
                        INNER JOIN
                    invproducts ON tran_100k.idproducto = invproducts.idproducto
                        INNER JOIN
                    invcatalog AS invlineas ON invproducts.idcatalogo = invlineas.idcatalogo
                        INNER JOIN
                    invcatalog ON invlineas.idnivel1 = invcatalog.idcatalogo
                        INNER JOIN
                    gusers ON tran_100k.whodidit = gusers.iduser
                WHERE
                    tran_100.idclase = $idclase AND
                    tran_100.idcentro = $sucursal AND
                    tran_100.fecha between '$fechaini' AND '$fechafin'";
                $SQLQuery = $this->db_b->query($SQLConsulta);

                if($SQLQuery->num_rows() > 0){
                    $informacion = $SQLQuery->result();
                }else{
                    $informacion = false;
                }

                return $informacion;
            }
        }
        
        function getListLineas($idprocentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT C.idcatalogo, C.descrip, C.idnivel1, (SELECT COUNT(*) FROM invproducts P WHERE P.idcatalogo = C.idcatalogo AND P.estado = 1 AND P.tipo = 1 AND P.precioventa <> 0 GROUP BY idcatalogo) AS Total, C.estado FROM invcatalog C WHERE C.nivel = 2 AND C.procentro = $idprocentro ORDER BY C.descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else{
                    return false;
                }
            }
        }
        
        function getTiposProcentros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.*, gvars.descripcion as tipo_gvars, gvars.valor_num FROM invsites INNER JOIN gvars ON invsites.tipo = gvars.valor_num WHERE gvars.nombre = 'gv_tipo' AND (gvars.valor_num = 2 OR gvars.valor_num = 3) ORDER BY descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventario($procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.imagen FROM invcatalog INNER JOIN invproducts ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invcatalog.procentro = $procentro";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
		
		function getGruposInventarioByLista($nameLista, $procentro, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.imagen FROM invcatalog INNER JOIN invproducts ON invcatalog.idcatalogo = invproducts.idcatalogo INNER JOIN invplistas ON invproducts.idproducto = invplistas.idproducto AND invproducts.estado = 1 WHERE invplistas.invplista = '$nameLista' AND invplistas.procentro = $procentro AND invplistas.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
		}
        
        function getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro,$procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                //$consulta = "SELECT invproducts.idcatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND idcatalogo = $idcatalogo AND invproducts.estado = 1 AND invproducts.tipo = 1";
                $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro), 0) AS disponible, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $procentro), 0) AS disprocentro, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getInventarioByLista($idtrannum, $idcentro, $procentro, $nameLista){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                if($nameLista != ""){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts INNER JOIN invplistas ON invproducts.idproducto = invplistas.idproducto WHERE invproducts.estado = 1 AND invplistas.invplista = '$nameLista' AND (invplistas.idcentro = $idcentro OR invplistas.tipo LIKE '%$idcentro,%') AND invplistas.procentro = $procentro ORDER BY invproducts.descrip";
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.estado = 1 ORDER BY invproducts.descrip";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoLineasPedidoBodega(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip FROM invcatalog INNER JOIN invproducts ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado = 1 ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }

        function getInventarioSinLista($trannum, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.estado = 1 AND invproducts.idcatalogo = $idcatalogo ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($Consulta);
                $resultado = $Query->result();
                return $resultado;
            }
        }
        
        function getCantidadesCatalogo($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM invproducts WHERE invproducts.estado = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getCantidadesByLista($idtrannum, $nameLista, $procentro, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM invproducts INNER JOIN invplistas ON invproducts.idproducto = invplistas.idproducto WHERE invproducts.estado = 1 AND invplistas.invplista = '$nameLista' AND invplistas.procentro = $procentro AND invplistas.idcentro = $idcentro GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getDataOrder100k($idtrannum, $idcentro, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, orders_100k.idrec, orders_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, orders_100k.cantidad, orders_100k.precioneto, orders_100k.notas FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getExistenciasCentroPB($idcentro, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT IFNULL(SUM(tran_100k.cantidad), 0) AS disponible FROM tran_100k WHERE tran_100k.idproducto = $idproducto AND tran_100k.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $disponible = $resultado['disponible'];
                return $disponible;
            }
        }
        
        function getExistenciasProcentroPB($procentro, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT IFNULL(SUM(tran_100k.cantidad), 0) AS disprocentro FROM tran_100k WHERE tran_100k.idproducto = $idproducto AND tran_100k.idcentro = $procentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $disprocentro = $resultado['disprocentro'];
                return $disprocentro;
            }
        }
		
		function getDataOrders100kProducto($idtrannum, $idcentro, $procentro, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, orders_100k.idrec, orders_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, orders_100k.cantidad, orders_100k.precioneto, orders_100k.notas, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro), 0) AS disponible, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $procentro), 0) AS disprocentro FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND orders_100k.idproducto = $idproducto ORDER BY orders_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertOrders100k($cantidad, $idproducto, $descrip, $um, $idcentro, $trannum, $precio, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('um', $um);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
                
                return $query;
            }
        }

        function insertarProductosAnalisiGrid($idcentro, $trannum, $infosource){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $infosource_filter = array_filter($infosource, function($e){
                    return $e['ordenar'] != 0;
                });

                for($i=0; $i<count($infosource); $i++){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('descrip', $infosource[$i]['nameproducto']);
                    $this->db_b->set('idproducto', $infosource[$i]['idproducto']);
                    $this->db_b->set('cantidad', $infosource[$i]['ordenar']);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('um', $infosource[$i]['um']);
                    $this->db_b->set('notas', '');
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('orders_100k');

                    $itemLine++;
                }
                
                return $query;
            }
        }
        
        function actualizarOrders100k($idrec, $cantidad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');
                return $query;
            }
        }
        
        function deleteDataOrder100k($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "DELETE FROM orders_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function getEstadisticasProducto($idproducto, $idcentro, $fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DATE_FORMAT(orders_100.fecha, '%d/%m/%Y') AS fecha, ABS(orders_100k.cantidad) AS cantidad FROM orders_100 INNER JOIN orders_100k ON orders_100k.trannum = orders_100.trannum WHERE orders_100.idcentro = $idcentro AND orders_100.agrupa = 'IN' AND orders_100k.idproducto = $idproducto AND orders_100.fecha = '$fecha' AND (orders_100.estatus != 0 OR orders_100.estatus != 9) GROUP BY orders_100.fecha";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    return $resultado;
                }else{
                    return false;    
                }
            }
        }
        
        function getDiasEstadisticas($nombre){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = '$nombre'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    return $resultado['valor_num'];
                }else{
                    return 15;
                }
            }
        }
        
        function getDatosProductoSearch($prosearch, $dato, $idcentro, $idcatalogo, $idtrannum, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch != 5){
                    //$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND invproducts.$search = '$dato' AND invproducts.estado = 1 AND invproducts.tipo = 1";
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro), 0) AS disponible, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $procentro), 0) AS disprocentro, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.$search = '$dato' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    //$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1 AND invproducts.tipo = 1";
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro), 0) AS disponible, IFNULL((SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $procentro), 0) AS disprocentro, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
        
        function closeOrden100($trannum, $fecha, $fechaEntrega, $notas, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT COUNT(idrec) AS total FROM orders_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $lines100k =  $resultado['total'];
                
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('dev_date', $fechaEntrega);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('lines100k', $lines100k);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function getCatalogProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcatalogo, descrip, procentro, imagen FROM invcatalog WHERE nivel = 1 AND procentro != 0";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else{
                    return false;
                }
            }
        }
        
        function getListPedidos($idcentro, $estado, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT ord.trannum, ord.dev_date, inv.descrip FROM orders_100 AS ord INNER JOIN invsites AS inv ON inv.idcentro = ord.idcentro WHERE (ord.idcentro = '$idcentro') AND (ord.estatus = '$estado') AND (ord.agrupa = '$agrupa') ORDER BY ord.dev_date ASC";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0) {
                    return $query->result();
                }else{
                    return false;
                }   
            }
        }
        
        function getListProductos($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invproducts WHERE idcatalogo = $idcatalogo AND estado = 1 AND tipo = 1 AND precioventa <> 0 ORDER BY descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else{
                    return false;
                }
            }
        }
        
        function getAllTheProducts($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invproducts WHERE idcatalogo = $idcatalogo AND estado = 1 AND tipo = 1 AND precioventa <> 0 ORDER BY descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else{
                    return false;
                }
            }
        }
        
        function getListPageProductos($idcatalogo, $pagina){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $per_page = 12; //la cantidad de registros que desea mostrar
                $offset = ($pagina - 1) * $per_page;
                //Cuenta el número total de filas de la tabla*/
                $consulta = "SELECT count(*) AS numrows FROM invproducts WHERE idcatalogo = $idcatalogo AND estado = 1 AND tipo = 1 AND precioventa <> 0";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $numrows = $resultado['numrows'];
                $total_pages = ceil($numrows/$per_page);

                //consulta principal para recuperar los datos
                $consulta = "SELECT * FROM invproducts WHERE idcatalogo = $idcatalogo AND estado = 1 AND tipo = 1 AND precioventa <> 0 ORDER BY descrip LIMIT $offset,$per_page";
                $query = $this->db_b->query($consulta);
                $resultado2 = $query->result();

                return $resultado2;
            }
        }
        
        function count_pedidos($idcentro, $estado, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT count(*) AS num_pedidos FROM orders_100 WHERE idcentro = $idcentro AND agrupa = '$agrupa' AND estatus = $estado";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $numrows = $resultado['num_pedidos'];
                
                return $numrows;
            }
        }
        
        function getCantidad100k($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT COUNT(idrec) AS total FROM orders_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cantidad = $resultado['total'];
                
                return $cantidad;
            }
        }
        
        function getUnidad100k($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT IFNULL(SUM(cantidad), 0) AS total FROM orders_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cantidad = number_format($resultado['total']);
                
                return $cantidad;
            }
        }
        
        function insertPedido($procentro, $notas, $fechapedido, $idcentro, $idLista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', 'IN');
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('fecha', $fecha->format('Y-m-d'));
                $this->db_b->set('dev_idcentro', $idcentro);
                $this->db_b->set('dev_date', $fechapedido);
                $this->db_b->set('dev_direc', $idLista);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');
                
                if($query==1){
                    $numero = $this->db_b->insert_id();
                }else{
                    $numero = 0;
                }
                return $numero;
            }
        }
        
        function updatePedido($idtrannum, $cliphone, $cliname, $cliemail, $notas, $fechaPedido, $time, $idsucursal, $devcontact, $devphone, $devdirec, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('descrip', $cliname);
                $this->db_b->set('cli_phone', $cliphone);
                $this->db_b->set('cli_email', $cliemail);
                $this->db_b->set('dev_idcentro', $idsucursal);
                $this->db_b->set('dev_place', 1);
                $this->db_b->set('dev_direc', $devdirec);
                $this->db_b->set('dev_phone', $devphone);
                $this->db_b->set('dev_contact', $devcontact);
                $this->db_b->set('dev_date', $fechaPedido);
                $this->db_b->set('dev_time', $time);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function getDataPedido($numero, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consultaNueva = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($consultaNueva);
                
                $consulta = "SELECT ord.*, date_format(ord.dev_date,'%W, %d %M, %Y') as dev_date2, date_format(ord.fecha,'%W, %d %M, %Y') as fecha2, inv.descrip as nameSucursal, inv2.descrip AS nameProcentro FROM orders_100 as ord LEFT JOIN invsites AS inv2 ON ord.procentro = inv2.idcentro LEFT JOIN invsites as inv ON ord.dev_idcentro = inv.idcentro WHERE ord.trannum = $numero AND ord.estatus = $estado";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getDataDtPedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM orders_100k WHERE trannum = $trannum ORDER BY itemline";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;    
            }
        }
        
        function validateUnaSucursal($iduser){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcentro FROM gusers WHERE iduser = $iduser";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                
                $array = explode(",",$result['idcentro']);
                $total = count($array);
                
                if($total == 2){
                    return true;
                }else{
                    return false;
                }
            }
        }
        
        function getCountPedidos($fechac, $idcentro, $estado, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT COUNT(*) as cnt FROM orders_100 AS ord WHERE (ord.idcentro = '$idcentro') AND (ord.estatus = '$estado') AND (ord.agrupa = '$agrupa') AND (ord.dev_date = '$fechac')";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                  
                $array = $result['cnt'];
                return $array;
            }
        }
        
        function getPedidosByDate($fechac, $idcentro, $estado, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT ord.*, inv.descrip AS nameSuc FROM orders_100 AS ord INNER JOIN invsites AS inv ON inv.idcentro = ord.dev_idcentro WHERE (ord.idcentro = '$idcentro') AND (ord.estatus = '$estado') AND (ord.agrupa = '$agrupa') AND (ord.dev_date = '$fechac')";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                  
                return $result;
            }
        }
        
        function getInformacionProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invproducts WHERE idproducto = '$idproducto'";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;    
            }
        }
        
        function getNameProduct($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip FROM invproducts WHERE idproducto = '$idproducto'";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                
                $descrip = trim($result['descrip']);
                return $descrip;    
            }
        }
        
        function getLst_Producto($procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT inv_pro.idproducto, inv_pro.descrip, inv_pro.precioventa, inv_pro.imagen FROM invproducts AS inv_pro INNER JOIN invcatalog AS inv_cat ON inv_pro.idcatalogo = inv_cat.idcatalogo WHERE inv_cat.procentro = $procentro AND inv_pro.estado = 1 AND inv_pro.tipo = 1 AND inv_pro.precioventa <> 0 ORDER BY inv_pro.descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;    
            }
        }
        
        function get_productos_x_linea($idLinea){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT inv_pro.idproducto, inv_pro.descrip, inv_pro.precioventa, inv_pro.imagen FROM invproducts AS inv_pro WHERE inv_pro.idcatalogo = $idLinea AND inv_pro.estado = 1 AND inv_pro.tipo = 1 AND inv_pro.precioventa <> 0 ORDER BY inv_pro.descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;    
            }
        }
        
        function insertDataPedido($archive, $trannum, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                $file = fopen($archive, "r");
                $texto = "";
                $i = 0;
                $total_venta = 0;
                while(!feof($file)){
                    $linea = fgets($file);
                    $txt_explode = explode('|', $linea);
                    if($txt_explode[0] != "" && $txt_explode[0] != "null"){
                        $cantidad = str_replace(";\n", "", $txt_explode[1]);
                        $consulta = "SELECT idproducto, descrip FROM invproducts WHERE idproducto = '$txt_explode[0]'";
                        $query = $this->db_b->query($consulta);
                        $result = $query->row_array();
                        if($query->num_rows() >= 0){
                            $num = $i + 1;
                            $this->db_b->set('idrec', 0);
                            $this->db_b->set('trannum', $trannum);
                            $this->db_b->set('itemline', $num);
                            $this->db_b->set('idproducto', $result['idproducto']);
                            $this->db_b->set('descrip', $result['descrip']);
                            $this->db_b->set('cantidad', $cantidad);
                            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                            $query = $this->db_b->insert('orders_100k');
                            $i++;
                        }
                    }
                }
                
                fclose($file);
                
                $this->db_b->set('estatus', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('lines100k', $i);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                return true;
            }
        }
        
        function getPedidosByProcentro($procentro, $idcenter, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consultaNueva = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($consultaNueva);
                
                $consulta = "SELECT ord.trannum, ord.fecha, ord.dev_date, ord.notas, inv.descrip FROM orders_100 AS ord INNER JOIN invsites AS inv ON inv.idcentro = ord.idcentro WHERE (ord.idcentro = '$idcenter') AND (ord.procentro = '$procentro') AND (ord.agrupa = '$agrupa') AND (ord.estatus = 0) ORDER BY ord.dev_date ASC";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getCountPedidosByEstatus($procentro, $idcenter, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT estatus, COUNT(*) AS num FROM orders_100 WHERE agrupa = '$agrupa' AND procentro = $procentro AND idcentro = $idcenter GROUP BY estatus";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getPedidosByEstatus($procentro, $estatus, $idcenter, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consultaNueva = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($consultaNueva);
                
                $consulta = "SELECT ord.trannum, ord.fecha, ord.dev_date, ord.notas, ord.lines100k, inv.descrip FROM orders_100 AS ord INNER JOIN invsites AS inv ON inv.idcentro = ord.idcentro WHERE (ord.idcentro = '$idcenter') AND (ord.procentro = '$procentro') AND (ord.agrupa = '$agrupa') AND (ord.estatus = $estatus) ORDER BY ord.dev_date ASC";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getPedidosEstatus($procentro, $idcenter, $agrupa, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consultaNueva = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($consultaNueva);
                
                $consulta = "SELECT ord.trannum, ord.fecha, ord.dev_date, ord.dev_direc, ord.notas, ord.estatus, ord.lines100k, IFNULL((SELECT SUM(cantidad) FROM orders_100k WHERE orders_100k.trannum = ord.trannum), 0) AS unidades, inv.descrip FROM orders_100 AS ord INNER JOIN invsites AS inv ON inv.idcentro = ord.idcentro WHERE (ord.idcentro = '$idcenter') AND (ord.procentro = '$procentro') AND (ord.agrupa = '$agrupa') AND ord.estatus = $estado ORDER BY ord.dev_date ASC";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getDetalleOrden100k($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT orders_100k.*, invproducts.marca, invproducts.modelo FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE trannum = $trannum ORDER BY itemline ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $result = $query->result();
                } else $result = false;
                
                return $result;
            }
        }
        
        function getProductosProcentro($procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT COUNT(invproducts.idproducto) AS total FROM invcatalog INNER JOIN invproducts ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invcatalog.procentro = $procentro";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                
                if($result['total'] > 0){
                    return true;
                }else{
                    return false;
                }
            }
        }
        
        function anulacionDeOrden($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $consulta = "DELETE FROM orders_100k WHERE trannum = $trannum";
                $this->db_b->query($consulta);
                
                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function regresarEstadoPedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function getCountPedidosByCentro($procentro, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT dev_date, COUNT(*) AS total FROM orders_100 WHERE agrupa = '$agrupa' AND procentro = $procentro AND estatus = 1 GROUP BY dev_date";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getLineasProcentro($procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcatalogo, descrip, procentro, imagen FROM invcatalog WHERE nivel = 2 AND procentro = $procentro";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getCountProductosSolicitados($procentro, $date_pedido){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT orders_100k.trannum, invproducts.idcatalogo, orders_100k.idproducto, orders_100k.descrip, SUM(orders_100k.cantidad) AS Cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND orders_100.dev_date = '$date_pedido' GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getPedidosByLineOrder100k($idcatalogo, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT orders_100k.trannum, invproducts.idcatalogo, invproducts.imagen, orders_100k.idproducto, orders_100k.descrip, SUM(orders_100k.cantidad) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND invproducts.idcatalogo = $idcatalogo GROUP BY orders_100k.idproducto ORDER BY orders_100k.descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getCountIndividualProductos($procentro, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT orders_100k.idproducto, SUM(orders_100k.cantidad) AS Total FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND invproducts.idcatalogo = $idcatalogo GROUP BY orders_100k.idproducto";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getNameSucursalesByProducto($idproducto, $fecha, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.descrip, orders_100k.idproducto, SUM(orders_100k.cantidad) as cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invsites ON invsites.idcentro = orders_100.idcentro WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND orders_100.dev_date = '$fecha' AND orders_100k.idproducto = $idproducto GROUP BY orders_100.idcentro";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getNameSalasdeVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcentro, descrip FROM invsites WHERE estatus = 1 AND tipo = 1";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getNameProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                $name = $result['descrip'];
                return $name;
            }
        }
        
        function getCantProducto($idproducto, $date, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->session->userdata('idprocentro');
                
                $consulta = "SELECT SUM(orders_100k.cantidad) as cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invsites ON invsites.idcentro = orders_100.idcentro WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND orders_100.dev_date = '$date' AND orders_100k.idproducto = $idproducto AND orders_100.dev_idcentro = $idcentro GROUP BY orders_100.idcentro";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $result = $query->row_array();
                    $cantidad = $result['cantidad'];
                }else{
                    $cantidad = '';
                }
                return $cantidad;
            }
        }
        
        function getTotalProducto($idproducto, $date){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->session->userdata('idprocentro');
                
                $consulta = "SELECT orders_100k.idproducto, SUM(orders_100k.cantidad) AS Total FROM orders_100k INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100.agrupa = 'IN' AND orders_100.estatus = '1' AND orders_100.procentro = $procentro AND invproducts.idproducto = $idproducto AND orders_100.dev_date = '$date' GROUP BY orders_100k.idproducto";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $result = $query->row_array();
                    $cantidad = $result['Total'];
                }else{
                    $cantidad = '';
                }
                return $cantidad;
            }
        }
		
		function getListadoNombresListas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'gv_invplistas'";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
					$result = $query->row_array();
                    $nombres = $result['valor_memo'];
					
					if($nombres != ""){
						
						$datos = explode(",", $nombres);
						$total = count($datos);
						$listas = array();
						
						for($i=0; $i<$total; $i++){
							$listas[$i] = array(
								"nameLista" => $datos[$i]
							);
						}
						$datos = $listas;
						
					}else{
						$datos = false;
					}
                }else{
                    $datos = false;
                }
				
                return $datos;
			}
		}
		
		function insertNombresListas($nombreLista){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
				
				$consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'gv_invplistas'";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
					$result = $query->row_array();
                    $nombres = $result['valor_memo'];
					
					if($nombres != ""){
						$nombres = $result['valor_memo'].','.$nombreLista;
						
						$this->db_b->set('valor_memo', $nombres);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
						$this->db_b->where('nombre', 'gv_invplistas');
						$query = $this->db_b->update('gvars');
					}else{
						$nombres = $nombreLista;
						
						$this->db_b->set('valor_memo', $nombres);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
						$this->db_b->where('nombre', 'gv_invplistas');
						$query = $this->db_b->update('gvars');
					}
                }else{
                    $query = false;
				}
				
                return $query;
			}
		}
		
		function updateNombresListas($nombreLista, $nombreanterior){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
				
				$consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'gv_invplistas'";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
					$result = $query->row_array();
                    $nombres = $result['valor_memo'];
					
					if($nombres != ""){
						
						$datos = explode(",", $nombres);
						$total = count($datos);
						
						for($i=0; $i<$total; $i++){
							if($datos[$i] == $nombreanterior){
								$datos[$i] = $nombreLista;
							}
						}
						
						$nombres = implode(',', $datos);
						
						$this->db_b->set('valor_memo', $nombres);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
						$this->db_b->where('nombre', 'gv_invplistas');
						$query = $this->db_b->update('gvars');
						
					}else{
						$nombres = $nombreLista;
						
						$this->db_b->set('valor_memo', $nombres);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
						$this->db_b->where('nombre', 'gv_invplistas');
						$query = $this->db_b->update('gvars');
					}
				}else{
					$query = false;
                }
				
				$this->db_b->set('nombrelista', $nombreLista);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
				$this->db_b->where('nombrelista', $nombreanterior);
				$query = $this->db_b->update('invplistas');
				
                return $query;
			}
		}
		
		function deleteNombresListas($nombreanterior){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
				
				$consulta = "SELECT * FROM invplistas WHERE nombrelista = '$nombreanterior'";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					return 1;
				}else{
					$consulta2 = "SELECT valor_memo FROM gvars WHERE nombre = 'gv_invplistas'";
					$query2 = $this->db_b->query($consulta2);

					if($query2->num_rows() > 0){
						
						$result = $query2->row_array();
						$nombres = $result['valor_memo'];
						
						if($nombres != ""){
							
							$datos = explode(",", $nombres);
							$total = count($datos);

							for($i=0; $i<$total; $i++){
								if($datos[$i] == $nombreanterior){
									unset($datos[$i]);
								}
							}
							
							$nombres = implode(',', $datos);
							$this->db_b->set('valor_memo', $nombres);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
							$this->db_b->where('nombre', 'gv_invplistas');
							$query = $this->db_b->update('gvars');
						}
					}
					
					return 0;
				}
			}
		}
        
		function getCantidadProductoByListaCentro($nameLista, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
				
				$consulta = "SELECT COUNT(*) AS total FROM invplistas WHERE nombrelista = '$nameLista' AND procentro = $idcentro";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					$datos = $query->row_array();
					$total = $datos['total'];
					
					return $total;
				}else{
					return 0;
				}
			}
		}
		
		function getProductoDisponibleCentro($idproducto, $idcentro, $nameLista, $procentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT allowedcentros FROM invplistas WHERE invplista = '$nameLista' AND procentro = $procentro AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					$datos = $query->row_array();
					
					$validate = 0;
					$centros = explode(",", $datos['allowedcentros']);
					$total = count($centros);	
						
					for($i=0; $i<$total; $i++){
						if($centros[$i] == $idcentro){
							$validate = 1;
						}	
					}
					
					return $validate;
				}else{
					return 0;
				}
			}
		}
		
        function insertProductoLista($procentro,$nombrelista,$idproducto,$cantmin,$cantmax,$dias,$centros,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
				$this->db_b->set('idlista', 0);
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('nombrelista', $nombrelista);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('cantmin', $cantmin);
                $this->db_b->set('cantmax', $cantmax);
                $this->db_b->set('dias', $dias);
                $this->db_b->set('allowedcentros', $centros);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
				$this->db_b->set('idcps', $this->session->userdata('iduser'));
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('invplistas');
				
                return $query;
            }
        }
		
		function updateProductoLista($idlista,$procentro,$nombrelista,$idproducto,$cantmin,$cantmax,$dias,$centros,$notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('nombrelista', $nombrelista);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('cantmin', $cantmin);
                $this->db_b->set('cantmax', $cantmax);
                $this->db_b->set('dias', $dias);
                $this->db_b->set('allowedcentros', $centros);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
				$this->db_b->set('idcps', $this->session->userdata('iduser'));
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
				$this->db_b->where('idlista', $idlista);
				$query = $this->db_b->update('invplistas');
				
                return $query;
            }
		}
		
		function deleteProductoLista($idlista){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "DELETE FROM invplistas WHERE idlista = $idlista";
                $query = $this->db_b->query($consulta);
				
                return $query;
            }
		}
        
        function getListadoProductosByLista($idcentro,$nombrelista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invplistas.*, invproducts.descrip AS nameProducto FROM invplistas INNER JOIN invproducts ON invplistas.idproducto = invproducts.idproducto WHERE procentro = $idcentro AND nombrelista = '$nombrelista'";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
        
        function getInformacionProductoLista($idlista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invplistas WHERE idlista = $idlista";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
        }
		
		function getListasDisponiblesCentro($idcentro, $procentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DISTINCT invplistas.invplista, invplistas.invplista AS nombrelista FROM invplistas WHERE (invplistas.idcentro = $idcentro AND invplistas.procentro = $procentro) OR (invplistas.procentro = $procentro AND invplistas.tipo LIKE '$idcentro,%') OR (invplistas.procentro = $procentro AND invplistas.tipo LIKE '%,$idcentro,%')";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $result = $query->result();
                }else{
                    $result = false;
                }
                
                return $result;
            }
		}
		
		function getSucursalesByTipoCentro($tipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcentro FROM invsites WHERE tipo = $tipo";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                
                return $result;
            }
		}
		
		function validateProductoToLista($procentro,$nombrelista,$idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT idlista FROM invplistas WHERE nombrelista = '$nombrelista' AND procentro = $procentro AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					$validate = false;
				}else{
					$validate = true;
				}
				
				return $validate;
			}
		}
        
        function insert_ListaDef($descrip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                $valor_num = 0;
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = 'gv_invplistas' ORDER BY valor_num DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					$result = $query->row_array();
                    $valor_num = $result['valor_num'] + 1;
				}else{
					$valor_num = 1;
				}
                
				$this->db_b->set('idrnum', 0);
                $this->db_b->set('nombre', "gv_invplistas");
                $this->db_b->set('descripcion', $descrip);
                $this->db_b->set('tipo_valor', 1);
                $this->db_b->set('valor_num', $valor_num);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
                return $query;
            }
        }
        
        function update_ListaDef($idrnum,$descripcion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                $this->db_b->set('descripcion', $descripcion);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $this->db_b->where('nombre', "gv_invplistas");
				$query = $this->db_b->update('gvars');
                return $query;
            }
        }
        
		function getListasDefinidas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT * FROM gvars WHERE nombre = 'gv_invplistas' ORDER BY valor_num ASC";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows()>0){
					$result = $query->result();
				}else{
					$result = false;
				}
				return $result;
			}
		}
        
        function insertNewLista($name,$clave,$procentro,$dias,$listCentros){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
				$this->db_b->set('idrec', 0);
                $this->db_b->set('idcentro', $this->session->userdata('idcentrouser'));
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('invplista', $name);
                $this->db_b->set('clave', $clave);
                $this->db_b->set('dias', $dias);
                $this->db_b->set('tipo', $listCentros);
                $this->db_b->set('idproducto', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('invplistas');
                return $query;
            }
        }
        
		function getListasDefinidasCentro($idcentro,$procentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT  invplistas.*, IFNULL((SELECT IFNULL(COUNT(idrec), 0) FROM invplistas AS ilistas WHERE ilistas.procentro = invplistas.procentro AND ilistas.idcentro = invplistas.idcentro AND ilistas.invplista = invplistas.invplista AND ilistas.idproducto != 0), 0) AS cantidad_products FROM invplistas WHERE invplistas.procentro = $procentro AND invplistas.idcentro = $idcentro AND invplistas.idproducto = 0 GROUP BY invplistas.idrec ORDER BY invplistas.idrec DESC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
					$result = $query->result();
				}else{
					$result = false;
				}
				return $result;
			}
		}
        
		function getRegistroInfo($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "SELECT invplistas.*,  IFNULL((SELECT IFNULL(COUNT(idrec), 0) FROM invplistas AS ilistas  WHERE ilistas.procentro = invplistas.procentro AND ilistas.idcentro = invplistas.idcentro AND ilistas.invplista = invplistas.invplista  AND ilistas.idproducto != 0),  0) AS cantidad_products, invsites.descrip AS lugar_despacho, invsites2.descrip AS sucursal FROM invplistas INNER JOIN  invsites ON invplistas.procentro = invsites.idcentro INNER JOIN invsites AS invsites2 ON invplistas.idcentro = invsites2.idcentro WHERE invplistas.idrec = $idrec";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
					$result = $query->result();
				}else{
					$result = false;
				}
				return $result;
			}
		}
        
        function getListasDefinidasDistinct($procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $where = "";
                $consulta = "SELECT invplistas.*, gvars.descripcion as name_lista, IFNULL((SELECT IFNULL(COUNT(idrec),0) FROM invplistas as ilistas where ilistas.procentro=invplistas.procentro AND ilistas.invplista=invplistas.invplista AND ilistas.idproducto!=0),0) as cantidad_products  FROM invplistas INNER JOIN gvars on invplistas.invplista = gvars.valor_num AND gvars.nombre = 'gv_invplistas'  WHERE invplistas.procentro = $procentro and invplistas.idproducto=0 GROUP BY invplistas.idrec ORDER BY invplistas.idrec DESC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
					$result = $query->result();
                    foreach($result as $res){
                        $valor_num = $res->invplista;
                        $where.= " AND gvars.valor_num!= $valor_num ";
                    }
				}
				$consulta = "SELECT * FROM gvars WHERE nombre = 'gv_invplistas' ".$where." ORDER BY valor_num ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
					$result = $query->result();
				}else{
					$result = false;
				}
				return $result;
			}
        }
        
        function getListadoProductos($idcentro,$procentro,$invplista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.um, IFNULL(ctauxi.descrip, '') AS nameproveedor, invproducts.marca, invproducts.precioventa, invproducts.tipotax, invproducts.descrip, invproducts.costounitario, invproducts.idcatalogo, invcatalog.descrip as linea, invproducts.modelo, (SELECT IF(EXISTS( SELECT invplistas.idrec FROM invplistas WHERE invplistas.idproducto = invproducts.idproducto AND invplistas.procentro = $procentro AND invplistas.idcentro = $idcentro AND invplistas.invplista LIKE '$invplista'), 1, 0)) AS existe FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi WHERE invproducts.estado = 1 ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function insertarProductosByGrid($idcentro,$procentro,$invplista, $idproductos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $idProducts = explode(",", $idproductos);
                $totalItems = count($idProducts);
                
                $consulta = "SELECT tipo FROM invplistas WHERE idcentro = $idcentro AND procentro = $procentro AND invplista = '$invplista' AND idproducto = 0";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                $tipo = $result['tipo'];
                
                for($i=0; $i<$totalItems; $i++){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('procentro', $procentro);
                    $this->db_b->set('invplista', $invplista);
                    $this->db_b->set('tipo', $tipo);
                    $this->db_b->set('idproducto', $idProducts[$i]);
                    $this->db_b->set('estatus', 1);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('invplistas');
                }
                return $query;
            }
        }
        
        function getListadoProductosLista($idcentro,$procentro,$invplista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.um, IFNULL(ctauxi.descrip, '') AS nameproveedor, invproducts.marca, invproducts.precioventa, invproducts.tipotax, invproducts.descrip, invproducts.costounitario, invproducts.idcatalogo, invcatalog.descrip as linea, invproducts.modelo,invplistas.idrec, invplistas.dias,invplistas.cantmin,invplistas.cantmax,invplistas.notas FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi INNER JOIN invplistas ON invplistas.invplista LIKE '$invplista' AND invplistas.procentro = $procentro AND invplistas.idproducto=invproducts.idproducto AND invplistas.idcentro = $idcentro WHERE invproducts.estado = 1 ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function eliminarListaDePedido($idcentro,$procentro,$invplista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "DELETE FROM invplistas WHERE invplista LIKE '$invplista' AND procentro = $procentro AND idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                
                return $query;
            }
        }
        
        function updateProductLista($idrec,$idproducto,$cantmin,$cantmax,$notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $consulta = "SELECT tipo FROM invplistas WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                $tipo = $result['tipo'];
                
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('cantmin', $cantmin);
                $this->db_b->set('cantmax', $cantmax);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				$query = $this->db_b->update('invplistas');
                
                return $query;
            }
		}
        
        function updateLista($idrec,$descrip,$clave,$dias,$idcentro,$procentro,$listCentros){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                $consulta = "SELECT invplista FROM invplistas WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                $last_invplista = $result['invplista'];
                
                 
                $this->db_b->set('invplista', $descrip);
                $this->db_b->set('tipo', $listCentros);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
				$this->db_b->where('invplista', $last_invplista);
				$this->db_b->where('idcentro', $idcentro);
				$this->db_b->where('procentro', $procentro);
				$query = $this->db_b->update('invplistas');
                
                $this->db_b->set('invplista', $descrip);
                $this->db_b->set('tipo', $listCentros);
                $this->db_b->set('dias', $dias);
                $this->db_b->set('clave', $clave);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
				$this->db_b->where('idrec', $idrec);
				$query = $this->db_b->update('invplistas');
                return $query;
            }
		}
        
        function getInformacionProductoList($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invplistas WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }
        
        function verificaExiste($name, $idcentro, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invplistas WHERE invplista LIKE '$name' AND idcentro = $idcentro AND procentro = $procentro";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
        
        function verificaExisteSame($name, $idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invplistas WHERE invplista LIKE '$name' AND idrec = $idrec";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
        
        function deleteProductLista($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "DELETE FROM invplistas WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
		}
		
        /* Por cualquier cosa....
        function getListadoSucursalesListas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLCentros = "SELECT allowedcentros FROM invplistas WHERE allowedcentros != '' OR allowedcentros != null";
                $Query_Centros = $this->db_b->query($SQLCentros);

                if($Query_Centros->num_rows()>0){
                    $informacion = $Query_Centros->result();
                    
                    $j=0;
                    $arrayCodigos = array();
                    
                    foreach($informacion as $info){
                        $infoArray = explode(',', $info->allowedcentros);
                        $totItems = count($infoArray);
                        
                        for($i=1; $i<$totItems; $i++){
                            $arrayCodigos[$j] = $infoArray[$i];
                            $j++;
                        }
                    }
                    
                    $arrayCodigos = array_unique($arrayCodigos);
                    $arrayString = implode(",", $arrayCodigos);
                    
                    $nuevoArray = explode(',', $arrayString);
                    $totalCodigos = count($nuevoArray);
                    
                    $SQLSucursales = "SELECT idcentro, descrip FROM invsites WHERE ";
                    for($i=0; $i<$totalCodigos; $i++){
                        $SQLSucursales .= "idcentro = " . $nuevoArray[$i] . " OR ";
                    }
                    
                    $SQLSucursales = substr($SQLSucursales, 0, -4);
                    $Query_Sucursales = $this->db_b->query($SQLSucursales);
                    $infoSucursales = $Query_Sucursales->result();
                    
                    $idCentros = $infoSucursales;
                }else{
                    $idCentros = false;
                }
                
                return $idCentros;
            }
        }
        */
        
        function getListadoSucursalesListas($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLCentros = "SELECT DISTINCT invsites.idcentro, invsites.descrip, gvars.descripcion as tipo_gvars FROM invplistas INNER JOIN invsites ON invplistas.procentro = invsites.idcentro INNER JOIN gvars ON invsites.tipo = gvars.valor_num AND gvars.nombre = 'gv_tipo' WHERE invplistas.idproducto = 0 AND (invplistas.idcentro = $idcentro OR invplistas.tipo LIKE '$idcentro,%' OR invplistas.tipo LIKE '%,$idcentro,%')";
                $Query_Sucursales = $this->db_b->query($SQLCentros);

                if($Query_Sucursales->num_rows()>0){
                    $infoSucursales = $Query_Sucursales->result();
                    $idCentros = $infoSucursales;
                }else{
                    $idCentros = false;
                }
                
                return $idCentros;
            }
        }
        
        function getValidatePasswordLista($idcentro, $procentro, $nameLista){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPassword = "SELECT clave FROM invplistas WHERE idproducto = 0 AND procentro = $procentro AND invplista = '$nameLista' AND (idcentro = $idcentro OR tipo LIKE '$idcentro,%' OR tipo LIKE '%,$idcentro,%')";
                $SQLQuery = $this->db_b->query($SQLPassword);
                $infoQuery = $SQLQuery->row_array();
                
                return $infoQuery['clave'];
            }
        }
        
        function getListadoLotesPedidos($idcentro, $agrupa, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100A.trannum, orders_100A.estatus, orders_100A.fecha, orders_100A.fecact, orders_100A.notas, (SELECT COUNT(orders_100B.trannum) FROM orders_100 AS orders_100B WHERE orders_100B.referencia = orders_100A.trannum) AS totalPedidos FROM orders_100 AS orders_100A WHERE orders_100A.idcentro = $idcentro AND orders_100A.agrupa = '$agrupa' AND orders_100A.fecha BETWEEN '$fechaini' AND '$fechafin'";
                $query = $this->db_b->query($SQLPedidos);
                
                if($query->num_rows()>0){
                    $informacion = $query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getCountListadoLotesPedidos($idcentro, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum FROM orders_100 WHERE orders_100.idcentro = $idcentro AND orders_100.agrupa = '$agrupa' AND orders_100.estatus = 0";
                $query = $this->db_b->query($SQLPedidos);
                
                if($query->num_rows()>0){
                    $informacion = false;
                }else{
                    $informacion = true;
                }
                
                return $informacion;
            }
        }
        
        function getInformacionListadoLotesPedidos($idcentro, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum, orders_100.fecha FROM orders_100 WHERE orders_100.idcentro = $idcentro AND orders_100.agrupa = '$agrupa' AND orders_100.estatus = 0";
                $query = $this->db_b->query($SQLPedidos);
                
                if($query->num_rows()>0){
                    $informacion = $query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getPedidosPorFechaToCalendar($idcentro, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLTimezone = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($SQLTimezone);
                
                $SQLPedidos = "SELECT COUNT(trannum) AS totalPedidos, dev_date FROM orders_100 WHERE procentro = '$idcentro' AND agrupa = '$agrupa' AND referencia = '' AND estatus = 1  GROUP BY dev_date ORDER BY dev_date ASC";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows()>0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getPedidosPorFechaToGrid($idcentro, $fecha, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum, invsites.descrip AS nameSucursal, orders_100.notas, (SELECT SUM(ABS(orders_100k.cantidad)) FROM orders_100k WHERE orders_100k.trannum = orders_100.trannum) AS totalProductos FROM orders_100 INNER JOIN invsites ON orders_100.idcentro = invsites.idcentro WHERE orders_100.procentro = '$idcentro' AND orders_100.dev_date = '$fecha' AND orders_100.agrupa = '$agrupa' AND orders_100.referencia = '' AND orders_100.estatus = 1 ORDER BY orders_100.trannum ASC";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function insertarLoteDePreparacionPedidos($idcentro, $idordenes, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $itemOrdenes = explode(",", $idordenes);
                $totalItems = count($itemOrdenes);
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', 'PP');
                $this->db_b->set('fecha', $fecha->format('Y-m-d'));
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->insert('orders_100');
                $trannum = $this->db_b->insert_id();
                
                for($i=0; $i<$totalItems; $i++){
                    $this->db_b->set('estatus', 2);
                    $this->db_b->set('referencia', $trannum);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                    $this->db_b->where('trannum', $itemOrdenes[$i]);
                    $query = $this->db_b->update('orders_100');
                }
                
                return $trannum;
            }
        }
        
        function getInformacionLoteDePedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLInformacion = "SELECT orders_100A.*, (SELECT COUNT(orders_100B.trannum) FROM orders_100 AS orders_100B WHERE orders_100B.referencia = orders_100A.trannum) AS totalPedidos FROM orders_100 AS orders_100A WHERE orders_100A.trannum = $trannum";
                $Query = $this->db_b->query($SQLInformacion);
                $informacion = $Query->result();
                
                return $informacion;
            }
        }
        
        function getPedidosDetalleToGrid($trannum, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum, orders_100.nrc, orders_100.idcentro, orders_100.estatus, invsites.descrip AS nameSucursal, (SELECT SUM(ABS(orders_100k.cantidad)) FROM orders_100k WHERE orders_100k.trannum = orders_100.trannum) AS totalProductos, IFNULL((SELECT SUM(ABS(IFNULL(tran_100k.cantidad, 0))) FROM tran_100k LEFT JOIN orders_100k ON tran_100k.idrec = orders_100k.cantrp WHERE orders_100k.trannum = orders_100.trannum), 0) AS totalDespachados FROM orders_100 INNER JOIN invsites ON orders_100.idcentro = invsites.idcentro WHERE orders_100.agrupa = '$agrupa' AND orders_100.referencia = '$trannum' AND orders_100.estatus = 2 ORDER BY orders_100.trannum ASC";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getPedidosProcesadosByTrannum($trannum, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum, orders_100.nrc, orders_100.idcentro, orders_100.estatus, invsites.descrip AS nameSucursal, (SELECT SUM(ABS(orders_100k.cantidad)) FROM orders_100k WHERE orders_100k.trannum = orders_100.trannum) AS totalProductos, IFNULL((SELECT SUM(ABS(IFNULL(tran_100k.cantidad, 0))) FROM tran_100k LEFT JOIN orders_100k ON tran_100k.idrec = orders_100k.cantrp WHERE orders_100k.trannum = orders_100.trannum), 0) AS totalDespachados FROM orders_100 INNER JOIN invsites ON orders_100.idcentro = invsites.idcentro WHERE orders_100.agrupa = '$agrupa' AND orders_100.referencia = '$trannum' AND orders_100.estatus = 4 ORDER BY orders_100.trannum ASC";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getProductosDetalleToGrid($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                //$SQLPedidos = "SELECT orders_100k.idproducto, orders_100k.idrec, invproducts.descrip, orders_100.estatus, invproducts.imagen, invproducts.marca, invproducts.modelo, invproducts.barcode, invproducts.um, ABS(orders_100k.cantidad) AS cantidad, IFNULL(inv_stock.cantidad, 0) AS disponible, IFNULL(ABS(tran_100k.cantidad), 0) AS despachado, inv_stock.idbin, inv_stock.idbatch, inv_stock.costounitario FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto LEFT JOIN tran_100k ON orders_100k.cantrp = tran_100k.idrec LEFT JOIN inv_stock ON orders_100k.idproducto = inv_stock.idproducto AND inv_stock.idcentro = $idcentro WHERE orders_100k.trannum = '$trannum' ORDER BY invproducts.descrip";
                $SQLPedidos = "
                SELECT orders_100k.idproducto, orders_100k.idrec, invproducts.descrip, orders_100.estatus, invproducts.imagen,
                    invproducts.marca, invproducts.modelo, invproducts.barcode, invproducts.um, ABS(orders_100k.cantidad) AS cantidad,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro), 0) AS disponible,
                    IFNULL(ABS(tran_100k.cantidad), 0) AS despachado, invlocations.idbin, inv_batch.idbatch, inv_batch.costounitario
                FROM orders_100k
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto
                INNER JOIN invlocations ON invlocations.idcentro = orders_100.procentro
                INNER JOIN inv_batch ON inv_batch.idproducto = orders_100k.idproducto
                LEFT JOIN tran_100k ON orders_100k.cantrp = tran_100k.idrec
                WHERE orders_100k.trannum = '$trannum' ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getCantProductsLista($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT  orders_100.idcentro, SUM(ABS(orders_100k.cantidad)) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100.referencia = '$trannum' GROUP BY invproducts.idproducto ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->num_rows();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getCantProductsListaPDF($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.idcentro FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum WHERE orders_100.referencia = '$trannum' GROUP BY orders_100k.idproducto";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->num_rows();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getListadoProductosAgrupados($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad
                FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100.referencia = '$trannum' GROUP BY invproducts.idproducto ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getListadoProductosReportePreparacion($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad,
                (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro) AS saldo 
                FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum 
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE orders_100.referencia = '$trannum' GROUP BY invproducts.idproducto 
                ORDER BY invcatalog.descrip, invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }

        function getListadoProductosReporteAgrupadoPreparacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Codigos = explode("_", $trannum);

                $infoWhere = '';
                for($i=0; $i<count($Codigos); $i++){
                    $infoWhere .= 'orders_100.trannum = '.$Codigos[$i].' OR ';
                }

                $infoWhere = substr($infoWhere, 0, -4);

                $SQLPedidos = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad
                FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum 
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE $infoWhere GROUP BY invproducts.idproducto 
                ORDER BY invcatalog.descrip, invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getListadoProductosReportePreparacionOrden($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad,
                (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro) AS saldo 
                FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum 
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE orders_100.trannum = $trannum GROUP BY invproducts.idproducto 
                ORDER BY invcatalog.descrip, invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getListadoProductosReportePreparacionOrdenSinSaldo($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad
                FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum 
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE orders_100.trannum = $trannum GROUP BY invproducts.idproducto 
                ORDER BY invcatalog.descrip, invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }

        function getListadoProductosAgrupadosSucursal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT  orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100k.trannum = '$trannum' GROUP BY invproducts.idproducto ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        function getCantProductosAgrupadosSucursal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT  orders_100.idcentro, orders_100k.idproducto, invproducts.descrip, invproducts.um, SUM(ABS(orders_100k.cantidad)) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100k.trannum = '$trannum' GROUP BY invproducts.idproducto ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                if($Query->num_rows() > 0){
                    $informacion = $Query->num_rows();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getInformacionProductoSucursales($trannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT invsites.descrip, ABS(orders_100k.cantidad) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invsites ON orders_100.idcentro = invsites.idcentro WHERE orders_100.referencia = '$trannum' AND orders_100k.idproducto = '$idproducto'";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        function getSucursalesPedidos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT invsites.idcentro, invsites.descrip, ABS(orders_100k.cantidad) AS cantidad FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invsites ON orders_100.idcentro = invsites.idcentro WHERE orders_100.referencia = '$trannum' group by invsites.idcentro order by invsites.descrip asc";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        function getListasPedidos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLPedidos = "SELECT orders_100.trannum, orders_100.idcentro, orders_100.dev_direc FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum WHERE orders_100.referencia = '$trannum' GROUP BY orders_100.dev_direc ORDER BY dev_direc ASC";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function getProductosProcesadosDetalleToGrid($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                #$SQLPedidos = "SELECT orders_100k.idproducto, orders_100k.idrec, invproducts.descrip, orders_100.estatus, invproducts.imagen, invproducts.marca, invproducts.modelo, invproducts.barcode, orders_100k.um, ABS(orders_100k.cantidad) AS cantidad, IFNULL(inv_stock.cantidad, 0) AS disponible, IFNULL(ABS(tran_100k.cantidad), 0) AS despachado, inv_stock.idbin, inv_stock.idbatch, inv_stock.costounitario FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN tran_100k ON tran_100k.idrec = orders_100k.cantrp LEFT JOIN inv_stock ON orders_100k.idproducto = inv_stock.idproducto AND inv_stock.idcentro = $idcentro WHERE orders_100k.trannum = '$trannum' ORDER BY invproducts.descrip";
                $SQLPedidos = "SELECT orders_100k.idproducto, orders_100k.idrec, invproducts.descrip, orders_100.estatus, invproducts.imagen, invproducts.marca, invproducts.modelo,
                    invproducts.barcode, orders_100k.um, ABS(orders_100k.cantidad) AS cantidad,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro), 0) AS disponible,
                    IFNULL(ABS(tran_100k.cantidad), 0) AS despachado, invlocations.idbin, inv_batch.idbatch, inv_batch.costounitario
                FROM orders_100k
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto
                INNER JOIN tran_100k ON tran_100k.idrec = orders_100k.cantrp
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                LEFT JOIN inv_batch ON orders_100k.idproducto = inv_batch.idproducto
                WHERE orders_100k.trannum = '$trannum'
                ORDER BY invproducts.descrip";
                $Query = $this->db_b->query($SQLPedidos);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function updateRegistroDespachado($idrec, $cantidad, $idcentro, $idbatch, $idbin, $barcode, $um, $costounitario){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $SQLPedidos = "SELECT idproducto, cantrp FROM orders_100k WHERE idrec = $idrec";
                $Query = $this->db_b->query($SQLPedidos);
                $informacion = $Query->row_array();
                
                $idTran100k = $informacion['cantrp'];
                $idproducto = $informacion['idproducto'];
                
                if($idTran100k == 0 || $idTran100k == ''){
                    if($cantidad != 0){
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('idcentro', $idcentro);
                        $this->db_b->set('idproducto', $idproducto);
                        $this->db_b->set('idbatch', $idbatch);
                        $this->db_b->set('idbin', $idbin);
                        $this->db_b->set('barcode', $barcode);
                        $this->db_b->set('cantidad', $cantidad * -1);
                        $this->db_b->set('um', $um);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('costounitario', $costounitario);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');

                        $idTran100k = $this->db_b->insert_id();

                        $this->db_b->set('cantrp', $idTran100k);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec', $idrec);
                        $query = $this->db_b->update('orders_100k');
                    }else{
                        $this->db_b->set('cantrp', 0);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec', $idrec);
                        $query = $this->db_b->update('orders_100k');
                    }
                }else{
                    if($cantidad == 0){
                        $SQLDelete = "DELETE FROM tran_100k WHERE idrec = $idTran100k";
                        $Query = $this->db_b->query($SQLDelete);
                        
                        $this->db_b->set('cantrp', 0);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec', $idrec);
                        $query = $this->db_b->update('orders_100k');
                    }else{
                        $this->db_b->set('cantidad', $cantidad * -1);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec', $idTran100k);
                        $query = $this->db_b->update('tran_100k');
                    }
                }
                
                return $query;
            }
        }
        
        function cerrarPedidoToTraslado($trannum, $fecha, $notas, $idclase, $idcentro_despacho, $idcentro_entrega){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
                
                $SQLSucursal = "SELECT IFNULL(idcps, 0) AS idcps FROM invsites WHERE idcentro = $idcentro_entrega";
                $QuerySucursal = $this->db_b->query($SQLSucursal);
                $infoCentro = $QuerySucursal->row_array();
                
                $partesFechaPedido = explode("-", $fecha);
                $notas = $notas." Pedido: ".$trannum." ".$partesFechaPedido[2]."/".$partesFechaPedido[1]."/".$partesFechaPedido[0];
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro_despacho);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('fecact', $fecha);
                $this->db_b->set('idcps', $infoCentro['idcps']);
                $this->db_b->set('idcentrod', $idcentro_entrega);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
                
                $trannumTraslado = $this->db_b->insert_id();
                
                $SQLProductos = "SELECT cantrp FROM orders_100k WHERE trannum = $trannum AND cantrp != 0";
                $Query = $this->db_b->query($SQLProductos);
                $informacion = $Query->result();
                
                $itemLine = 1;
                foreach($informacion as $info){
                    $idrec = $info->cantrp * 1;
                    
                    $this->db_b->set('trannum', $trannumTraslado);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $idrec);
                    $this->db_b->update('tran_100k');
                    
                    $itemLine++;
                }
                
                $this->db_b->set('nrc', $trannumTraslado);
                $this->db_b->set('estatus', 4);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('orders_100');
                
                return $trannumTraslado;
            }
        }
        
        function cerrarPreparacionDePedidos($trannum, $fecha, $fechaCierre, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();
                
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('fecact', $fechaCierre);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }
        
        function adicionarPedidoToLoteDePreparacion($trannum, $idordenes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $itemOrdenes = explode(",", $idordenes);
                $totalItems = count($itemOrdenes);
                
                for($i=0; $i<$totalItems; $i++){
                    $this->db_b->set('estatus', 2);
                    $this->db_b->set('referencia', $trannum);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                    $this->db_b->where('trannum', $itemOrdenes[$i]);
                    $query = $this->db_b->update('orders_100');
                }
                
                return $query;
            }
        }
        
        function eliminarPedidoToLoteDePreparacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
				$fecha = new DateTime();
                
                $this->db_b->set('estatus', 1);
                $this->db_b->set('referencia', '');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }

        function getDatosSearchPedidosBodega($prosearch, $dato, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
				
				if($prosearch == 3){
                    //$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.xpos, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT tran_100kt.trannum FROM tran_100kt WHERE tran_100kt.idproducto = invproducts.idproducto AND tran_100kt.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = $tipopro AND invproducts.$search = '$dato'";
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.estado = 1 AND invproducts.$search = '$dato' ORDER BY invproducts.descrip";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        //$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.xpos, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT tran_100kt.trannum FROM tran_100kt WHERE tran_100kt.idproducto = invproducts.idproducto AND tran_100kt.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1 AND invproducts.tipo = $tipopro AND invpromulti.descrip = '$dato'";
                        $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1  WHERE invproducts.estado = 1 AND invpromulti.descrip = '$dato' ORDER BY invproducts.descrip";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    //$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.xpos, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT tran_100kt.trannum FROM tran_100kt WHERE tran_100kt.idproducto = invproducts.idproducto AND tran_100kt.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = $tipopro AND invproducts.descrip LIKE '%$dato%'";
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.estado = 1 AND invproducts.descrip LIKE '%$dato%' ORDER BY invproducts.descrip";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else{
                    //$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.xpos, invproducts.notas, IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad, IFNULL(inv_batch.costounitario, 0) AS costounitario, (SELECT IF(EXISTS( SELECT tran_100kt.trannum FROM tran_100kt WHERE tran_100kt.idproducto = invproducts.idproducto AND tran_100kt.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = $tipopro AND invproducts.$search = '$dato'";
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.estado = 1 AND invproducts.$search = '$dato' ORDER BY invproducts.descrip";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }

        function getInfoProductoPedidoBodega($trannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, orders_100k.idrec, orders_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, orders_100k.cantidad, orders_100k.precioneto, orders_100k.notas FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $trannum AND orders_100k.idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataProductoPedidoBodega($trannum, $idcentro, $procentro, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$consulta = "
                SELECT
                    invproducts.idcatalogo, invproducts.tipotax, invcatalog.descrip AS linea, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca,
                    invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas, invproducts.costounitario,
                    (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe,
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = $idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS cantidad,
                    SUM(ABS(tran_100k.cantidad) * tran_100k.uniconv) AS uvendidas,
                    (SELECT SUM(tran_100k3.cantidad * tran_100k3.uniconv) FROM tran_100k AS tran_100k3 WHERE tran_100k3.idcentro = $procentro AND tran_100k3.idproducto = tran_100k.idproducto) AS saldob
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND tran_100k.idcentro = $idcentro AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                GROUP BY tran_100k.idproducto 
                ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
			}
		}
    }
?>