<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Sucursal_model extends CI_Model {
            
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        function viewSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invsites";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
             }
        }
        
        function viewSucursales_activas_asc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invsites where estatus=1 ORDER BY descrip asc";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
             }
        }
        
        function viewSucursalActiva(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.*, gvars.descripcion as grupo FROM invsites INNER JOIN gvars WHERE nombre = 'gv_tipo' AND invsites.tipo=gvars.valor_num AND estatus = 1 ORDER BY grupo, descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function viewSucursalById($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip as text, descrip, idcentro as id,idcentro FROM invsites WHERE estatus=1 AND idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getSucursalesInOutGroup($tipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.idcentro, invsites.descrip, gvars.descripcion AS grupo FROM invsites INNER JOIN gvars WHERE nombre = 'gv_tipo' AND invsites.tipo = gvars.valor_num AND invsites.estatus = 1 AND invsites.tipo = $tipo ORDER BY grupo, descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getUbicacionesBySucursal($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idbin, descrip FROM invlocations WHERE idcentro = $idcentro ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getTiposSucursalesActivas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DISTINCT gvars.descripcion as grupo, invsites.tipo FROM invsites INNER JOIN gvars WHERE nombre = 'gv_tipo' AND invsites.tipo=gvars.valor_num AND estatus=1 ORDER BY tipo, descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function viewSucursalActiva_Tipo($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip as text, descrip, idcentro as id,idcentro FROM invsites WHERE estatus=1 AND tipo= $tipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function viewSucursalesActivas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip as text, descrip, idcentro as id,idcentro FROM invsites WHERE estatus=1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getDataSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.idcentro, invsites.descrip, invsites.tipo, invsites.xpos, ctauxi.descrip AS encargado, 
                IFNULL((SELECT invlocations.descrip FROM invlocations WHERE invlocations.idcentro = invsites.idcentro ORDER BY invlocations.idbin LIMIT 1), '') AS nameUbicacion, 
                IFNULL((SELECT ctcajas.descrip FROM ctcajas WHERE ctcajas.idcentro = invsites.idcentro ORDER BY ctcajas.idcaja LIMIT 1), '') AS nameCaja, invsites.estatus AS estatus 
                FROM invsites 
                LEFT JOIN ctauxi ON ctauxi.idauxi = invsites.idcps ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
             }
        }
        
		function getDireccionCentro($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT notas FROM invsites WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['notas'];
            }
		}

        function getNameCentro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip FROM invsites WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['descrip'];
            }
        }
		
        function insertSucursal($descrip, $tipo, $idauxi, $xpos, $estado, $notas, $whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 

                $this->db_b->set('idcentro', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invsites');
                
                $idcentro = $this->db_b->insert_id();
                
                $this->db_b->set('idbin', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('descrip', "UBICACIÓN PREDETERMINADO");
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->insert('invlocations');
                
                return $query;
            }
        }
         
        function getTipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $consulta = "SELECT descripcion, valor_num, idrnum FROM gvars WHERE nombre = 'gv_tipo'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getTipoById($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $consulta = "SELECT descripcion, valor_num, idrnum FROM gvars WHERE nombre = 'gv_tipo' AND valor_num = $tipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }
        
        function getListEncargados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, gvars.descripcion AS tipoauxi FROM ctauxi INNER JOIN gvars ON ctauxi.idauxidef = gvars.valor_num WHERE gvars.nombre = 'auxi_def'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getListEncargadosSuc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, gvars.descripcion AS tipoauxi 
                FROM ctauxi 
                INNER JOIN gvars ON ctauxi.idauxidef = gvars.valor_num 
                WHERE gvars.nombre = 'auxi_def' AND ctauxi.idauxidef=3";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function callRegistro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT invsites.*, ctauxi.descrip as name_encargado, ctauxi.idauxidef FROM invsites LEFT JOIN ctauxi ON ctauxi.idauxi = invsites.idcps WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function updateSucursal($idcentro, $descrip, $tipo, $idauxi, $xpos, $estado, $notas, $whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s"); 

                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_mod);
                $this->db_b->where('idcentro', $idcentro);
                $query = $this->db_b->update('invsites');
                
                return $query;
            }
        }
         
        function deleteSucursal($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT trannum FROM tran_100 WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >= 1){
                    return "1";
                }else{
                    $consulta = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() >= 1){
                        return "2";
                    }else{
                        $consulta = "SELECT idcaja FROM ctcajas WHERE idcentro = $idcentro";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() >= 1){
                            return "3";
                        }else{
                            $this->db_b->where('idcentro', $idcentro);
                            $this->db_b->delete('invsites');
                            return "4";
                        }
                    }
                }
            }
        }
       
        function getListNamesByAuxi($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idauxi, descrip, telefono FROM ctauxi WHERE idauxidef = $idauxi";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getNameSucursal($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descripcion FROM gvars WHERE nombre = 'gv_tipo' and idrnum= $idrnum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['descripcion'];
            }
        }
        
        
        function get_Existencias_Kardex_Suc($tipo, $categoria, $sucursales){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if(trim($sucursales)!=""){
                    $arraySuc = explode(",", $sucursales);
                    $totRig = count($arraySuc);
                    $where = "";
                    $totReal = $totRig;
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            $where .=" tran_100k.idcentro=$arraySuc[$i] OR ";
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            //$where .=" invsites.tipo=$id OR ";
                        }
                    }
                    $where =  substr($where, 0, -3);
                    
                    if($categoria==0){
                        $consulta = "SELECT invproducts.idproducto AS id, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS proveedor, invproducts.imagen, invproducts.upp, invproducts.tipo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca, invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.precioventa, inv_batch.costounitario, invproducts.xpos, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog as invdep ON invcatalog.idnivel1 = invdep.idcatalogo WHERE ($where) AND invproducts.tipo = $tipo AND invproducts.estado=1 GROUP BY tran_100k.idproducto";
                    }else{
                        $consulta = "SELECT invproducts.idproducto AS id, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS proveedor, invproducts.imagen, invproducts.upp, invproducts.tipo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca, invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.precioventa, inv_batch.costounitario, invproducts.xpos, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog as invdep ON invcatalog.idnivel1 = invdep.idcatalogo WHERE ($where) AND invcatalog.idnivel1=$categoria AND invproducts.tipo = $tipo AND invproducts.estado=1 GROUP BY tran_100k.idproducto";
                    }
                }else{
                    if($categoria==0){
                        $consulta = "SELECT invproducts.idproducto AS id, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS proveedor, invproducts.imagen, invproducts.upp, invproducts.tipo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca, invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.precioventa, inv_batch.costounitario, invproducts.xpos, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog as invdep ON invcatalog.idnivel1 = invdep.idcatalogo WHERE invproducts.tipo = $tipo AND invproducts.estado=1 GROUP BY tran_100k.idproducto";
                    }else{
                        $consulta = "SELECT invproducts.idproducto AS id, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS proveedor, invproducts.imagen, invproducts.upp, invproducts.tipo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca, invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.precioventa, inv_batch.costounitario, invproducts.xpos, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog as invdep ON invcatalog.idnivel1 = invdep.idcatalogo WHERE invcatalog.idnivel1 = $categoria  AND invproducts.tipo = $tipo AND invproducts.estado=1 GROUP BY tran_100k.idproducto";
                    }
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDetalleExistenciaFacturacion($tipoproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idproducto AS id, invproducts.imagen, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.idcatalogo, invcatalog.descrip AS linea, invdep.descrip AS departamento, invproducts.marca,
                    invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.tipo, invproducts.upp, invproducts.precioventa, invproducts.xpos, ROUND(SUM(tran_100k.cantidad * tran_100k.uniconv), 2) AS cantidad
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invdep ON invcatalog.idnivel1 = invdep.idcatalogo
                WHERE invproducts.tipo = $tipoproducto AND tran_100k.idcentro = $idcentro AND invproducts.estado = 1
                GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }

                return $resultado;
            }
        }
        
        function get_Detalle_Existencias_Suc($tipo,$categoria,$sucursales){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha= date("Y-m-d"); 
                
                if($sucursales!=""){
                     
                    $arraySuc = explode(",", $sucursales);
                    $totRig = count($arraySuc);
                    $totReal = $totRig;
                    $where = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            $where .=" tran_100k.idcentro=$arraySuc[$i] OR ";
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            //$where .=" invsites.tipo=$id OR ";
                        }
                    }
                    $where =  substr($where, 0, -3);
                    $consulta ="SELECT invproducts.idproducto, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch WHERE ($where) GROUP BY tran_100k.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }else{
                    $consulta ="SELECT invproducts.idproducto, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch GROUP BY tran_100k.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleExistenciasUbicacionesProducto($tipo, $categoria, $sucursales, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha= date("Y-m-d"); 
                
                if($sucursales!=""){
                     
                    $arraySuc = explode(",", $sucursales);
                    $totRig = count($arraySuc);
                    $totReal = $totRig;
                    $where = "(";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            $where .=" tran_100k.idcentro=$arraySuc[$i] OR ";
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                        }
                    }
                    $where =  substr($where, 0, -3);
                    $where .= ")";
                    $consulta ="SELECT invproducts.idproducto, invproducts.descrip AS producto, invproducts.marca, invproducts.modelo, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.xpos, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch WHERE tran_100k.idproducto = $idproducto AND ($where) GROUP BY tran_100k.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }else{
                    $consulta ="SELECT invproducts.idproducto, invproducts.descrip AS producto, invproducts.marca, invproducts.modelo, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.xpos, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch WHERE tran_100k.idproducto = $idproducto GROUP BY tran_100k.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_Detalle_Existencias_Suc_product($tipo,$categoria,$sucursales, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha= date("Y-m-d"); 
                
                if($sucursales!=""){
                     
                    $arraySuc = explode(",", $sucursales);
                    $totRig = count($arraySuc);
                    $totReal = $totRig;
                    $where = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            $where .=" invsites.idcentro=$arraySuc[$i] OR ";
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            //$where .=" invsites.tipo=$id OR ";
                        }
                    }
                    $where =  substr($where, 0, -3);
                    $consulta ="SELECT  invproducts.idproducto, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM invproducts INNER JOIN tran_100k ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch WHERE invproducts.idproducto = $idproducto AND ($where) GROUP BY invproducts.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }else{
                    $consulta ="SELECT  invproducts.idproducto, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, DATE_FORMAT(inv_batch.fcompra, '%d/%m/%Y') AS fcompra, DATEDIFF('$fecha', inv_batch.fcompra) AS dias_lote, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad FROM invproducts INNER JOIN tran_100k ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch WHERE invproducts.idproducto = $idproducto GROUP BY invproducts.idproducto , tran_100k.idcentro , inv_batch.idbatch";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
        function get_lineas_kardex($depto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT invcatalog.idnivel1 AS cat, invcatalog.descrip AS linea, invcatalog.idcatalogo FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invcatalog.idnivel1=$depto GROUP BY invcatalog.idcatalogo ORDER BY linea";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function get_Existencias_report($depto, $sucursales){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                
                if($sucursales=="0"){
                    $where="";
                }else{
                    $eval = substr($sucursales, -1);
                    if($eval=="-"){
                        $sucursales = substr($sucursales,0,-1);
                    }
                            
                    $arraySuc = explode("-", $sucursales);
                    $totRig = count($arraySuc);
                    $totReal = $totRig;
                    $where = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            $where .=" invsites.idcentro=$arraySuc[$i] OR ";
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            $where .=" invsites.tipo=$id OR ";
                        }
                    }
                    $where =  substr($where, 0, -3);
                }
                
                if($where==""){
                    $consulta ="SELECT invproducts.idproducto AS id, invproducts.idcatalogo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.descrip AS linea, invproducts.marca AS marca, invproducts.modelo AS modelo, invproducts.um AS um, inv_stock.costounitario AS costounitario, SUM(inv_stock.cantidad) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invsites ON invsites.idcentro=inv_stock.idcentro where invcatalog.idnivel1=$depto AND cantidad!=0 AND inv_stock.costounitario!=0  GROUP BY inv_stock.idproducto ORDER BY invproducts.descrip ASC";
                }else{
                    $consulta ="SELECT invproducts.idproducto AS id, invproducts.idcatalogo, invcatalog.idnivel1, invproducts.descrip AS producto, invcatalog.descrip AS linea, invproducts.marca AS marca, invproducts.modelo AS modelo, invproducts.um AS um, inv_stock.costounitario AS costounitario, SUM(inv_stock.cantidad) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invsites ON invsites.idcentro=inv_stock.idcentro WHERE ($where) AND invcatalog.idnivel1=$depto AND cantidad!=0 AND inv_stock.costounitario!=0   GROUP BY inv_stock.idproducto ORDER BY invproducts.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        //------------------------------------------------------------------------  SUCURSALES Y CENTROS --------------------------------------------------------------------------------------
        #   GET TIPOS DE SUCURSALES
        public function getTiposSucursales()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("valor_num, descripcion");
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'gv_tipo');
                $this->db_b->order_by("valor_num", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->valor_num,
                            'Name' => $dato->descripcion
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET SUCURSALES UBICACIONES Y CAJAS
        public function getSucursalesCajasUbicaciones($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("idcentro, descrip, codigomh, direccion, telefono, estatus, tipo");
                $this->db_b->from("invsites");
                //if($Tipo > 0) $this->db_b->where("tipo", $Tipo);
                $this->db_b->where("tipo", $Tipo);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        #   UBICACIONES
                        $conteo = 0;
                        $this->db_b->select("idbin, descrip, estatus");
                        $this->db_b->from("invlocations");
                        $this->db_b->where("idcentro", $dato->idcentro);
                        $this->db_b->order_by("descrip", "ASC");
                        $data2 = $this->db_b->get();//*/
                        if ($data2->num_rows() > 0) {
                            foreach ($data2->result() as $dato2) {
                                $Datos[] = array (
                                    'idtipo' => (int)$dato2->idbin,
                                    'tipoTxt' => $dato2->descrip,
                                    'idsucursal' => (int)$dato->idcentro,
                                    'sucursal' => $dato->descrip,
                                    'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tiposucursal' => (int)$dato->tipo,
                                    'estado' => '',//($dato2->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tipoDato' => 'Ubicación',
                                    'tipo' => 2,
                                    'fi' => '',
                                    'ff' => '',
                                    'direccion' => '',
                                    'departamento' => '', // RM 
                                    'telefono' => '',
                                    'nohas' => 0,
                                    'codEstablecimientoMh' => '',
                                    'codPuntoVentaMh' => '',
                                );
                            }
                        } else $conteo++;
                        #   CAJAS
                        $this->db_b->select("idcaja, descrip, codigomh, estatus, bfecha, efecha, ucajera, cajaopen");
                        $this->db_b->from("ctcajas");
                        $this->db_b->where("idcentro", $dato->idcentro);
                        $this->db_b->order_by("descrip", "ASC");
                        $data3 = $this->db_b->get();
                        if ($data3->num_rows() > 0) {
                            foreach ($data3->result() as $dato3) {
                                $estadocaja = '';
                                if ($dato3->ucajera == 1) {
                                    $estadocaja = ($dato3->cajaopen == 1) ? 'Abierta' : 'Cerrada';
                                }
                                $Datos[] = array(
                                    'idtipo' => (int)$dato3->idcaja,
                                    'tipoTxt' => $dato3->descrip,
                                    'idsucursal' => (int)$dato->idcentro,
                                    'sucursal' => $dato->descrip,
                                    'codEstablecimientoMh' => $dato->codigomh,
                                    'codPuntoVentaMh' => $dato3->codigomh,
                                    'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tiposucursal' => (int)$dato->tipo,
                                    'estado' => $estadocaja,//($dato3->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tipoDato' => 'Caja',
                                    'tipo' => 3,
                                    'fi' => $dato3->bfecha,
                                    'ff' => $dato3->efecha,
                                    'direccion' => '',
                                    'departamento' => '', // RM
                                    'telefono' => '',
                                    'nohas' => 0
                                );
                            }
                        } else $conteo++;
                        
                        if ($conteo == 2) {
                            $Datos[] = array(
                                'idtipo' => null,
                                'tipoTxt' => null,
                                'idsucursal' => (int)$dato->idcentro,
                                'sucursal' => $dato->descrip,
                                'codEstablecimientoMh' => $dato->codigomh,
                                'codPuntoVentaMh' => '',
                                'tiposucursal' => (int)$dato->tipo,
                                'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                'estado' => null,
                                'tipoDato' => null,
                                'tipo' => 0,
                                'fi' => '',
                                'ff' => '',
                                'direccion' => $dato->direccion,
                                'departamento' => $dato->idzip, //RM
                                'telefono' => $dato->telefono,
                                'nohas' => 1
                            );
                        }
                    }
                }
                return $Datos;
            }
        }

        public function getSucursalesCajasUbicacionesNew($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("idcentro, descrip, direccion, telefono, estatus, tipo, imagen"); //rm agrege imagen
                $this->db_b->from("invsites");
                //if($Tipo > 0) $this->db_b->where("tipo", $Tipo);
                $this->db_b->where("tipo", $Tipo);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        #   UBICACIONES
                        $conteo = 0;
                        $this->db_b->select("idbin, descrip, estatus");
                        $this->db_b->from("invlocations");
                        $this->db_b->where("idcentro", $dato->idcentro);
                        $this->db_b->order_by("descrip", "ASC");
                        $data2 = $this->db_b->get();//*/
                        if ($data2->num_rows() > 0) {
                            foreach ($data2->result() as $dato2) {
                                $Datos[] = array (
                                    'idtipo' => (int)$dato2->idbin,
                                    'tipoTxt' => $dato2->descrip,
                                    'idsucursal' => (int)$dato->idcentro,
                                    'sucursal' => $dato->descrip,
                                    'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tiposucursal' => (int)$dato->tipo,
                                    'estado' => '',//($dato2->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tipoDato' => 'Ubicación',
                                    'tipo' => 2,
                                    'fi' => '',
                                    'ff' => '',
                                    'direccion' => '',
                                    'telefono' => '',
                                    'nohas' => 0,
                                    'imagen' => $dato->imagen  //RM
                                );
                            }
                        } else $conteo++;
                        #   CAJAS
                        $this->db_b->select("idcaja, descrip, estatus, bfecha, efecha, ucajera, cajaopen");
                        $this->db_b->from("ctcajas");
                        $this->db_b->where("idcentro", $dato->idcentro);
                        $this->db_b->order_by("descrip", "ASC");
                        $data3 = $this->db_b->get();
                        if ($data3->num_rows() > 0) {
                            foreach ($data3->result() as $dato3) {
                                $estadocaja = '';
                                if ($dato3->ucajera == 1) {
                                    $estadocaja = ($dato3->cajaopen == 1) ? 'Abierta' : 'Cerrada';
                                }
                                $Datos[] = array(
                                    'idtipo' => (int)$dato3->idcaja,
                                    'tipoTxt' => $dato3->descrip,
                                    'idsucursal' => (int)$dato->idcentro,
                                    'sucursal' => $dato->descrip,
                                    'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tiposucursal' => (int)$dato->tipo,
                                    'estado' => $estadocaja,//($dato3->estatus == 1) ? 'Activo' : 'Inactivo',
                                    'tipoDato' => 'Caja',
                                    'tipo' => 3,
                                    'fi' => $dato3->bfecha,
                                    'ff' => $dato3->efecha,
                                    'direccion' => '',
                                    'telefono' => '',
                                    'nohas' => 0,
                                    'imagen' => $dato->imagen  //RM
                                );
                            }
                        } else $conteo++;
                        
                        if ($conteo == 2) {
                            $Datos[] = array(
                                'idtipo' => null,
                                'tipoTxt' => null,
                                'idsucursal' => (int)$dato->idcentro,
                                'sucursal' => $dato->descrip,
                                'tiposucursal' => (int)$dato->tipo,
                                'stasucursal' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                                'estado' => null,
                                'tipoDato' => null,
                                'tipo' => 0,
                                'fi' => '',
                                'ff' => '',
                                'direccion' => $dato->direccion,
                                'telefono' => $dato->telefono,
                                'nohas' => 1,
                                'imagen' => $dato->imagen  //RM
                            );
                        }
                    }
                }
                return $Datos;
            }
        }
        #   GET INFORMACION DATA
        public function getData($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                switch ($Tipo) {
                    #   GET ENCARGADOS
                    case 1:
                        $this->db_b->select("a.idauxi as id, a.descrip, b.descripcion as tipo");
                        $this->db_b->from("ctauxi a");
                        $this->db_b->join("gvars b", "a.idauxidef = b.valor_num");
                        $this->db_b->where('b.nombre', 'auxi_def');
                        $this->db_b->where('a.idauxidef', 3);
                        $this->db_b->where('a.estado', 1);
                        $this->db_b->order_by("a.descrip", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #  GET TIPOS
                    case 2:
                        $this->db_b->select("idrnum as id, descripcion as descrip");
                        $this->db_b->from("gvars");
                        $this->db_b->where('nombre', 'gv_location');
                        $this->db_b->order_by("descripcion", "ASC");
                        $data = $this->db_b->get();
                    break;
                    default:
                        $data = false;
                    break;
                }
                return $data;
            }
        }
        #   SET SUCURSAL
        public function setSucursal($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('invsites', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   GET SUCURSAL
        public function getSucursal($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else return $this->db_b->where("idcentro", $ID)->get("invsites")->row();
        }
        #   UPDATE SUCURSAL
        public function updateSucursalN($data, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idcentro', $ID);
                if ($this->db_b->update('invsites', $data)) return true;
                else return false;
            }
        }
        #   CONT IMAGENES PRODUCTO
        public function getContImage($tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->db_b->select("*");
                $this->db_b->from("invsites");
                $this->db_b->where("tipo", $tipo);
                $this->db_b->order_by("idcentro", "ASC");
                $data = $this->db_b->get();
                /*if ($data->num_rows() > 0) $dato = ($data->last_row()->idproducto + 1);
                else $dato = 1;//*/
                $dato = ($data->num_rows() > 0) ? ($data->last_row()->idproducto + 1) : 1;
                return $dato;
            }
        }
        #   VALIDAR NOMBRE IMAGEN PRODUCTO
        public function validateNameImage($nombre, $tipo)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invsites");
                $this->db_b->where("tipo", $tipo);
                $this->db_b->where("imagen", $nombre);
                $data = $this->db_b->get();
                /*if ($data->num_rows() > 0) $dato = false;
                else $dato = true;//*/
                $dato = ($data->num_rows() > 0) ? false : true;
                return $dato;
            }
        }
        #   SET UBICACION
        public function setLocation($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('invlocations', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   GET UBICACION
        public function getLocation($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else return $this->db_b->where("idbin", $ID)->get("invlocations")->row();
        }
        #   UPDATE UBICACION
        public function updateLocation($data, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idbin', $ID);
                if ($this->db_b->update('invlocations', $data)) return true;
                else return false;
            }
        }
        #   SET CAJA
        public function setCaja($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('ctcajas', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   GET CAJA
        public function getCaja($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else return $this->db_b->where("idcaja", $ID)->get("ctcajas")->row();
        }
        #   UPDATE CAJA
        public function updateCaja($data, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idcaja', $ID);
                if ($this->db_b->update('ctcajas', $data)) return true;
                else return false;
            }
        }
        #   TIENE TRANSACCIONES SUCURSAL LOCATION CAJA
        public function hasTransaccion($Tipo, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $valor = 0;
                switch ($Tipo) {
                    case 1:
                        $valor = ($this->db_b->where("idcentro", $ID)->get("tran_100")->num_rows() > 0) ? 1 : -1;
                        if($valor == -1) $valor = ($this->db_b->where("idcentro", $ID)->get("invlocations")->num_rows() > 0) ? 2 : -2;
                        if($valor == -2) $valor = ($this->db_b->where("idcentro", $ID)->get("ctcajas")->num_rows() > 0) ? 3 : -3;
                        $valor = ($valor > 0) ? $valor : 0;
                    break;
                    case 2:
                        $valor = ($this->db_b->where("idbin", $ID)->get("tran_100k")->num_rows() > 0) ? 1 : 0;
                    break;
                    case 3:
                        $valor = ($this->db_b->where("idcaja", $ID)->get("tran_100")->num_rows() > 0) ? 1 : 0;
                    break;
                }
                return $valor;
            }
        }
        #   ELIMINAR SUCURSAL LOCATION CAJA
        public function byeRegistro($Tipo, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                switch ($Tipo) {
                    case 1:
                        $this->db_b->where('idcentro', $ID);
                        $this->db_b->delete('invsites');//*/
                    break;
                    case 2:
                        $this->db_b->where('idbin', $ID);
                        $this->db_b->delete('invlocations');//*/
                    break;
                    case 3:
                        $this->db_b->where('idcaja', $ID);
                        $this->db_b->delete('ctcajas');//*/
                    break;
                }
                return true;
            }
        }

        public function getCentrosCosto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("idcentro, descrip, xpos, estatus, tipo, notas");
                $this->db_b->from("invsites");
                
                //if($Tipo > 0) $this->db_b->where("tipo", $Tipo);
                $this->db_b->order_by("idcentro", "ASC");
                $data = $this->db_b->get();

                if($data->num_rows() > 0){
                    $resultado = $data->result_array();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }

        public function verificarDescripCentrosCosto($descrip, $idcentro = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("1");
                $this->db_b->from("invsites");
                $this->db_b->where('descrip', $descrip);
                if($idcentro != 0){
                    $this->db_b->where('idcentro !=', $idcentro);
                }
                $data = $this->db_b->get();

                if($data->num_rows() > 0){
                    $resultado = true;
                }else{
                    $resultado = false;
                }

                return $resultado;
            }
        }

        public function verificarTransaccionesCentrosCosto($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("1");
                $this->db_b->from("ct_100d");
                $this->db_b->where('idcentro', $idcentro);
                
                $data = $this->db_b->get();

                if($data->num_rows() > 0){
                    $resultado = true;
                }else{
                    $resultado = false;
                }

                return $resultado;
            }
        }

        function setCentroCosto($descrip, $tipo, $xpos, $notas, $estado ){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');

                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invsites');
                
                return $query;
            }
        }

        function updateCentroCosto($idcentro, $descrip, $tipo, $xpos, $notas, $estado ){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 

                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idcentro', $idcentro);

                $query = $this->db_b->update('invsites');
                
                return $query;
            }
        }

        function deleteCentroCosto($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->db_b->where('idcentro', $idcentro);
                $this->db_b->delete('invsites');//*/
                
                return true;
            }
        }
        //------------------------------------------------------------------------  FIN SUCURSALES Y CENTROS ----------------------------------------------------------------------------------

        #Obtiene el inventario hasta una fecha especifica
        function getProductInvetarioDate($fechafin, $idcentro, $tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select("invproducts.idproducto AS id, invproducts.upp, invproducts.descrip AS producto,invproducts.um, invproducts.costounitario, ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad");
                $this->db_b->from('tran_100k');
                $this->db_b->join('invproducts','tran_100k.idproducto = invproducts.idproducto');
                $this->db_b->join('tran_100','tran_100k.trannum = tran_100.trannum');
                $this->db_b->where('invproducts.tipo', $tipo);
                $this->db_b->where('invproducts.estado', 1);
                //$this->db_b->where('tran_100k.idcentro', $idcentro);
                $this->db_b->where('tran_100.fecha <=', $fechafin);
                $this->db_b->group_by('tran_100k.idproducto');

                $query = $this->db_b->get();
                $resultado = $query->result();
                return $resultado;
            }
        }
    }
?>