<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Scan_model extends CI_Model{
        #private $db_b;
            
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
            date_default_timezone_set('America/El_Salvador');
        }
        private function validatePermiso() {
            $permiso = true;
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }

        #   MULIT OPCIONES
        public function multiOpciones($opc, $extra = null)
        {
            if ($this->validatePermiso()) {
                switch ($opc) {
                    #   SCAN JOB
                    case 1:#    GET SCAN'S
                        $where = implode(' AND ', [
                            '(a.agrupa = "SJ")',
                            '(length(a.nrc) > 0)',
                        ]);
                        $wherej = implode(' AND ', ['(a.idcentro = b.idcentro)', '(b.estatus = 1)']);
                        $this->db_b->select('a.*, IFNULL(b.descrip, "") as sucursal');
                        $this->db_b->from('orders_100 a');
                        $this->db_b->join('invsites b', $wherej, 'left');
                        $this->db_b->where($where);
                        $this->db_b->where('b.idcentro', $extra);
                        $this->db_b->order_by('a.fecha DESC');
                        $datos = $this->db_b->get();
                    break;
                    case 2:#   GET SUCURSALES
                        $where = implode(' AND ', ['(estatus = 1)']);
                        $this->db_b->select('idcentro, descrip');
                        $this->db_b->from('invsites');
                        $this->db_b->where($where);
                        $this->db_b->order_by('descrip ASC');
                        $datos = $this->db_b->get();
                    break;
                    case 3:#    SET
                        if ($this->db_b->insert($extra['tbl'], $extra['data'])) $datos = $this->db_b->insert_id();
                        else $datos = false;
                    break;
                    case 4:#    GET
                        $datos = $this->db_b->where($extra['campo'], $extra['ID'])->get($extra['tbl'])->row();
                    break;
                    case 4.5:#    GET SCAN
                        $where = implode(' AND ', [
                            '(a.trannum = '.$extra.')'
                        ]);
                        $this->db_b->select('a.*, b.descrip as sucursal');
                        $this->db_b->from('orders_100 a');
                        $this->db_b->join('invsites b', 'a.idcentro = b.idcentro');
                        $this->db_b->where($where);
                        $datos = $this->db_b->get()->row();
                    break;
                    case 5:#    UPDATE
                        $this->db_b->where($extra['campo'], $extra['ID']);
                        if ($this->db_b->update($extra['tbl'], $extra['data'])) $datos = true;
                        else $datos = false;
                    break;
                    #   DETALLE
                    case 6:#    GET REGISTROS SCAN
                        $where = implode(' AND ', [
                            '((a.tipo = 1) OR (a.tipo = 2))',
                            '(b.trannum = '.$extra.')'
                        ]);
                        //$this->db_b->select('a.*, b.cantidad, IFNULL(c.descrip, "") as proveedor, IFNULL(d.descripcion, "") as impuesto');
                        $this->db_b->select('a.*, b.cantidad, b.notas as logs');
                        $this->db_b->from('invproducts a');
                        $this->db_b->join('orders_100k b', 'a.idproducto = b.idproducto');
                        //$this->db_b->join('ctauxi c', 'a.idprovee = c.idauxi', 'left');
                        //$this->db_b->join('gvars d', 'a.tipotax = d.valor_num AND (d.nombre = "gv_tipotax")', 'left');
                        $this->db_b->where($where);
                        $this->db_b->order_by('b.ingresa DESC');
                        $datos = $this->db_b->get();
                    break;
                    case 7:#    SEARCH PRODUCTO Multi
                        $this->db_b->select('a.*');
                        $this->db_b->from('invproducts a');
                        $this->db_b->join('invpromulti b', 'a.idproducto = b.idproducto');
                        $this->db_b->where($extra);
                        $datos = $this->db_b->get()->row();
                    break;
                    case 8:#    GET - SPECIAL 1
                        $datos = $this->db_b->where($extra['w'])->get($extra['tbl'])->row();
                    break;
                    case 9:#    GET ITEMLINE
                        $this->db_b->select('itemline');
                        $this->db_b->from('orders_100k');
                        $this->db_b->where('trannum', $extra);
                        $this->db_b->order_by('itemline ASC');
                        $datos = $this->db_b->get();
                        $datos = ($datos->num_rows() > 0) ? ($datos->last_row()->itemline + 1) : 1;
                    break;
                    case 10:#   PERMISO DE INVENTARIO
                        $where = implode(' AND ', [
                            '(idcentro = '.$extra['idc'].')',
                            '(idproducto = '.$extra['idp'].')'
                        ]);
                        $this->db_b->select('SUM(cantidad * uniconv) as cantidad');
                        $this->db_b->from('tran_100k');
                        $this->db_b->where($where);
                        $datos = $this->db_b->get()->row();
                        $datos = ($datos->cantidad != null) ? $datos->cantidad : false;
                    break;
                    case 11:#   GET MULTI INFORMACION
                        $this->db_b->select('idrec, descrip, precioventa');
                        $this->db_b->from('invpromulti');
                        $this->db_b->where($extra);
                        $datos = $this->db_b->get();
                    break;
                    case 12:#   ELIMINAR SCAN
                        $this->db_b->where($extra);
                        $this->db_b->delete('orders_100k');
                        $datos = true;
                    break;
                    case 13:#    SEARCH MULTIS - W INVENTARIO
                        $this->db_b->select('a.*, SUM(b.cantidad * b.uniconv) as pinv');
                        $this->db_b->from('invproducts a');
                        $this->db_b->join('tran_100k b', 'a.idproducto = b.idproducto');
                        $this->db_b->where($extra);
                        $this->db_b->group_by('a.idproducto');
                        $datos = $this->db_b->get();
                    break;
                    case 14:#    SEARCH MULTIS
                        $this->db_b->select('*');
                        $this->db_b->from('invproducts');
                        $this->db_b->where($extra);
                        $this->db_b->order_by('descrip ASC');
                        $datos = $this->db_b->get();
                    break;
                    default:$datos = false;break;
                }
                return $datos;
            }
        }
        #-
        
        public function newTran($tipoT, $notas, $referencia){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime(); 
                $centro = $this->session->userdata('idcentrouser');

                $this->db_b->set('trannum', 0);
                $this->db_b->set('cli_email', $tipoT);
                $this->db_b->set('idcentro', $centro);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('agrupa', "SJ");
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
                    
        }
        
        public function listScaners(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT 
                            trannum,
                            trannum as o100trannum,
                            fecha,
                            cli_email,
                            dev_direc,
                            referencia,
                            lines100k,
                            notas,
                            (SELECT ifnull(COUNT(idrec),0) FROM orders_100k WHERE orders_100k.trannum=o100trannum) as lineas,
                            (SELECT ifnull(SUM(cantidad),0) FROM orders_100k WHERE orders_100k.trannum=o100trannum) as unidades
                        FROM
                            orders_100
                        WHERE
                            referencia = 'SJ'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        public function getDatosProductoSearch($prosearch, $dato){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch != 5){
                    //$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND invproducts.$search = '$dato' AND invproducts.estado = 1 AND invproducts.tipo = 1";
                    $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.precioventa, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.notas, invproducts.barcode FROM invproducts WHERE invproducts.$search = '$dato' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    //$consulta = "SELECT invproducts.idcatalogo, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1 AND invproducts.tipo = 1";
                    $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.precioventa, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.descrip LIKE '%$dato%' AND invproducts.estado = 1";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
        
        public function getProducts($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT orders_100k.* FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto=orders_100k.idproducto WHERE trannum = $trannum order by invproducts.modelo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        public function getProductsTN($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT dev_direc FROM orders_100 WHERE trannum = $trannum ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['dev_direc'];
            }
        }
            
        public function save_productsT($trannum, $tempo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime(); 
                $this->db_b->set('dev_direc', $tempo);
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                return $query;
            }
        }
            
        public function updateProducts($trannum,$lista_pro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime(); 
                $this->db_b->set('dev_direc', $lista_pro);
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                $centro = $this->session->userdata('idcentrouser');
                $consulta = "DELETE FROM orders_100k WHERE trannum=$trannum";
                $query = $this->db_b->query($consulta);
                
                $this->db_b->set('lines100k', 0);
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query_up = $this->db_b->update('orders_100');
                
                $list_productos = explode('_', $lista_pro);
                $total = count($list_productos)-1;
                        
                for($i=0; $i<$total; $i++){
                    $product = $list_productos[$i];
                    $det = explode(",", $product);
                    $cant = count($det);
                    $idproducto = $det[0];
                    $cantidad = $det[1];
                    $precio="";
                    if($cant>2){
                        $precio = $det[2];
                    }else{
                        $precio=0;
                    }
                    
                    if($cantidad==""){
                        $cantidad=1;
                    }
                    
                    $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                    $query = $this->db_b->query($consulta);
                
                    if($query->num_rows() > 0){
                        $consulta3 = "SELECT idrec, cantidad, precioneto FROM orders_100k where idproducto = $idproducto AND trannum = $trannum";
                        $query3 = $this->db_b->query($consulta3);
                    
                        if($query3->num_rows()==1){
                            
                            $resultado3 = $query3->row_array();
                            $idrec_anterior = $resultado3['idrec'];
                            $cantidad_anterior = $resultado3['cantidad'];
                            $precio_anterior = $resultado3['precioneto'];

                            $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                            $query_pro = $this->db_b->query($consulta_pro);
                            $resultado_pro = $query_pro->row_array();
                            if($precio==0){
                                $precio = $resultado_pro['precioventa'];
                            }
                            
                            if($precio_anterior==$precio){
                                $cantidad_save = $cantidad+$cantidad_anterior;
                                $this->db_b->set('cantidad', $cantidad_save);
                                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                $this->db_b->where('idrec', $idrec_anterior);
                                $query2 = $this->db_b->update('orders_100k');
                            }else{
                                if($query->num_rows() > 0){
                                    $resultado = $query->row_array();
                                    $itemLine = $resultado['itemline'] + 1;
                                }else{
                                    $itemLine = 1;
                                }
                                $consulta = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                                $query = $this->db_b->query($consulta);
                                $resultado = $query->row_array();
                                $this->db_b->set('idrec', 0);
                                $this->db_b->set('trannum', $trannum);
                                $this->db_b->set('itemline', $itemLine);
                                $this->db_b->set('idproducto', $idproducto);
                                $this->db_b->set('cantidad', $cantidad);
                                $this->db_b->set('cantidad', $cantidad);
                                $this->db_b->set('descrip', $resultado['descrip']);
                                $this->db_b->set('um', $resultado['um']);
                                $this->db_b->set('precioneto', $precio);
                                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                                $query = $this->db_b->insert('orders_100k');
                                /******* FIN INSERTAR PRODUCTO NO EXISTENTE  *******/

                                $this->db_b->set('lines100k', $itemLine);
                                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                $this->db_b->where('trannum', $trannum);
                                $query2 = $this->db_b->update('orders_100');

                            }
                            
                            $resultado3 = $query3->result();
                            foreach($resultado3 as $for3){
                                $idrec_anterior = $for3->idrec;
                                $cantidad_anterior = $for3->cantidad;
                                $precio_anterior = $for3->precioneto;
                                $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                                $query_pro = $this->db_b->query($consulta_pro);
                                $resultado_pro = $query_pro->row_array();
                                if($precio==0){
                                    $precio = $resultado_pro['precioventa'];
                                }
                                
                                if($precio_anterior==$precio){
                                    $cantidad_save = $cantidad+$cantidad_anterior;
                                    $this->db_b->set('cantidad', $cantidad_save);
                                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                    $this->db_b->where('idrec', $idrec_anterior);
                                    $query2 = $this->db_b->update('orders_100k');
                                    break;
                                }
                            }
                        }else if($query3->num_rows()>1){
                            $resultado3 = $query3->result();
                            $encontrado=false;
                            if($precio==0){
                                $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                                $query_pro = $this->db_b->query($consulta_pro);
                                $resultado_pro = $query_pro->row_array();
                                $precio = $resultado_pro['precioventa'];
                            }
                            foreach($resultado3 as $res_3){
                                $idrec_anterior = $res_3->idrec;
                                $cantidad_anterior = $res_3->cantidad;
                                $precio_anterior = $res_3->precioneto;
                                if($precio_anterior==$precio){
                                    $cantidad_save = $cantidad+$cantidad_anterior;
                                    $this->db_b->set('cantidad', $cantidad_save);
                                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                    $this->db_b->where('idrec', $idrec_anterior);
                                    $query2 = $this->db_b->update('orders_100k');
                                    $encontrado=true;
                                    break;
                                }
                            }
                            
                            if($encontrado==false){
                                if($query->num_rows() > 0){
                                    $resultado = $query->row_array();
                                    $itemLine = $resultado['itemline'] + 1;
                                }else{
                                    $itemLine = 1;
                                }
                                $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                                $query_pro = $this->db_b->query($consulta_pro);
                                $resultado_pro = $query_pro->row_array();

                                if($precio==0){
                                    $precio = $resultado_pro['precioventa'];
                                }

                                $this->db_b->set('idrec', 0);
                                $this->db_b->set('trannum', $trannum);
                                $this->db_b->set('itemline', $itemLine);
                                $this->db_b->set('idproducto', $idproducto);
                                $this->db_b->set('cantidad', $cantidad);
                                $this->db_b->set('descrip', $resultado_pro['descrip']);
                                $this->db_b->set('um', $resultado_pro['um']);
                                $this->db_b->set('precioneto', $precio);
                                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                                $query = $this->db_b->insert('orders_100k');
                                /******* FIN INSERTAR PRODUCTO NO EXISTENTE  *******/
                                /******* ACTUALIZAR LINES100K  *******/
                                $this->db_b->set('lines100k', $itemLine);
                                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                                $this->db_b->where('trannum', $trannum);
                                $query2 = $this->db_b->update('orders_100');
                                /******* ACTUALIZAR LINES100K  *******/
                            }
                            

                        }else{
                            /******* INICIO INSERTAR PRODUCTO NO EXISTENTE  *******/
                            if($query->num_rows() > 0){
                                $resultado = $query->row_array();
                                $itemLine = $resultado['itemline'] + 1;
                            }else{
                                $itemLine = 1;
                            }
                            $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                            $query_pro = $this->db_b->query($consulta_pro);
                            $resultado_pro = $query_pro->row_array();

                            if($precio==0){
                                $precio = $resultado_pro['precioventa'];
                            }

                            $this->db_b->set('idrec', 0);
                            $this->db_b->set('trannum', $trannum);
                            $this->db_b->set('itemline', $itemLine);
                            $this->db_b->set('idproducto', $idproducto);
                            $this->db_b->set('cantidad', $cantidad);
                            $this->db_b->set('descrip', $resultado_pro['descrip']);
                            $this->db_b->set('um', $resultado_pro['um']);
                            $this->db_b->set('precioneto', $precio);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $query = $this->db_b->insert('orders_100k');
                            /******* FIN INSERTAR PRODUCTO NO EXISTENTE  *******/
                            /******* ACTUALIZAR LINES100K  *******/
                            $this->db_b->set('lines100k', $itemLine);
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->where('trannum', $trannum);
                            $query2 = $this->db_b->update('orders_100');
                            /******* ACTUALIZAR LINES100K  *******/
                        }
                        
                    }else{
                        
                        /******* INICIO INSERTAR PRODUCTO NO EXISTENTE  *******/
                        if($query->num_rows() > 0){
                            $resultado = $query->row_array();
                            $itemLine = $resultado['itemline'] + 1;
                        }else{
                            $itemLine = 1;
                        }
                        $consulta_pro = "SELECT descrip, um, precioventa FROM invproducts where idproducto = $idproducto";
                        $query_pro = $this->db_b->query($consulta_pro);
                        $resultado_pro = $query_pro->row_array();
                        
                        if($precio==0){
                            $precio = $resultado_pro['precioventa'];
                        }
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('itemline', $itemLine);
                        $this->db_b->set('idproducto', $idproducto);
                        $this->db_b->set('cantidad', $cantidad);
                        $this->db_b->set('descrip', $resultado_pro['descrip']);
                        $this->db_b->set('um', $resultado_pro['um']);
                        $this->db_b->set('precioneto', $precio);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $query = $this->db_b->insert('orders_100k');
                        /******* FIN INSERTAR PRODUCTO NO EXISTENTE  *******/
                        /******* ACTUALIZAR LINES100K  *******/
                        $this->db_b->set('lines100k', $itemLine);
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('trannum', $trannum);
                        $query2 = $this->db_b->update('orders_100');
                        /******* ACTUALIZAR LINES100K  *******/
                    }
                }
                return $query;
            }
        }
        
        
        public function getInfoOrden($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT 
                            orders_100.*,
                            (SELECT COUNT(idrec) FROM orders_100k WHERE orders_100k.trannum=orders_100.trannum) as lineas,
                            (SELECT SUM(cantidad) FROM orders_100k WHERE orders_100k.trannum=orders_100.trannum) as unidades
                        FROM
                            orders_100
                        WHERE
                            trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detalleScan($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT gvars.descripcion as tipoScan, orders_100.trannum, orders_100.cli_notify,  orders_100.cajclase, orders_100.fecha, orders_100.fecvence,  orders_100.dev_place, concat(orders_100.dev_date,',',orders_100.dev_time) as dev_date, orders_100.idcps, orders_100.idworker, orders_100.referencia, orders_100.estatus, orders_100.val_tot, orders_100.notas
                FROM orders_100 
                INNER JOIN gvars ON gvars.nombre = 'scan_job' AND gvars.valor_num=orders_100.cli_email
                where trannum=$trannum";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }   
        }
        
        function getVentasxVendedores($fecha_ini,$fecha_fin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS Fecha, DATE_FORMAT(tran_100.ingresa, '%H') AS Hora, tran_100.fecha AS Dia, IFNULL(ctauxi3.descrip, 'SIN PROVEEDOR') AS Proveedor, ctauxi2.descrip AS Cliente, ctauxi.descrip AS Vendedor,
                    invcatalog.descrip AS Línea, invcatalog2.descrip AS Departamento, 
                    ((tran_100k.cantidad * tran_100k.precioneto) *- 1 ) AS Ventas,
                    (((tran_100k.cantidad * tran_100k.uniconv) * tran_100k.costounitario) * - 1) AS Costos,
                    ((tran_100k.cantidad * tran_100k.uniconv) * -1) AS Unidades,
                    -- IFNULL(caj_def.descrip, '') AS formaPago,
                    tran_100k.idproducto AS Hits, tran_100.numx, tran_100.numz,
                    inv_def.descrip AS Transaccion, IFNULL(ctauximulti.descrip, ctauxi2.descrip) AS Suc_Cliente, ctcajas.descrip AS NameCaja, 
                    invsites.descrip AS Sucursal, invproducts.descrip AS Producto, invproducts.xpos, invproducts.marca AS Marca, invproducts.modelo AS Modelo, invproducts.idproducto, ctauxi2.grupo AS Grupo, ctauxi3.grupo AS GrupoProvee, ctauxi3.idauxi AS CodigoProveedor 
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                -- LEFT JOIN tran_100c ON tran_100.trannum = tran_100c.trannum
                -- LEFT JOIN caj_def ON tran_100c.cajclase = caj_def.cajclase
                INNER JOIN ctauxi ON tran_100k.idworker = ctauxi.idauxi
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog.idnivel1
                INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro
                INNER JOIN ctcajas ON ctcajas.idcaja = tran_100.idcaja 
                INNER JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idcps
                LEFT JOIN  ctauxi AS ctauxi3 ON ctauxi3.idauxi = invproducts.idprovee
                LEFT JOIN  ctauximulti ON tran_100.idcentrod = ctauximulti.idrec 
                WHERE tran_100.estatus = 1 AND inv_def.agrupa = 'VN' AND tran_100.fecha BETWEEN '$fecha_ini' AND '$fecha_fin'";

                #GROUP BY tran_100.fecha, tran_100.idcentro, tran_100.idcps, tran_100k.idworker, invcatalog.idcatalogo, invproducts.idproducto
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getFirstTran(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){    
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT tran_100.fecha FROM tran_100  WHERE tran_100.estatus=1  AND fecha> '0000-00-00'  ORDER BY tran_100.fecha ASC LIMIT 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                if(isset($resultado['fecha'])){
                    return $resultado['fecha'];
                }else{
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    $date2 = date_format($date, 'd/m/Y');

                    return $date2;
                }
            }
        }
        
        function saveArray($descrip, $array, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $whodidit = $this->session->userdata('iduser');
                
                $consulta = "SELECT descrip FROM gusers WHERE iduser = $whodidit";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $nameuser = $resultado['descrip'];
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime(); 
                $this->db_b->set('idrec', 0);
                $this->db_b->set('appname', $this->session->userdata('controller_app'));
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('fechaini', $fechaini);
                $this->db_b->set('fechafin', $fechafin);
                $this->db_b->set('arreglo',  serialize($array));
                $this->db_b->set('estado', 1);
                $this->db_b->set('creadopor', $nameuser.' '.$date->format('d/m/Y h:i a'));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('gpivots');
                $idrec = $this->db_b->insert_id();
                return $idrec;
            }
        }
        
        function editArray($idrec, $descrip, $array, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $whodidit = $this->session->userdata('iduser');
                
                $consulta = "SELECT descrip FROM gusers WHERE iduser = $whodidit";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $nameuser = $resultado['descrip'];
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('fechaini', $fechaini);
                $this->db_b->set('fechafin', $fechafin);
                $this->db_b->set('arreglo',  serialize($array));
                $this->db_b->set('creadopor', $nameuser.' '.$date->format('d/m/Y h:i a'));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('gpivots');
                return $idrec;
            }
        }
        
        function getArrays(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $appname=$this->session->userdata('controller_app');
                $consulta = "SELECT * FROM gpivots WHERE appname='$appname'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getArreglo_Config($id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $appname=$this->session->userdata('controller_app');
                $consulta = "SELECT arreglo FROM gpivots WHERE idrec=$id";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['arreglo'];
            }
        }
        
        function getCantConfig(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $appname=$this->session->userdata('controller_app');
                $consulta = "SELECT count(idrec) as cantidad FROM gpivots WHERE appname='$appname'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    return $resultado['cantidad'];
                }else{
                    return 0;
                }
                
            }
        }
        
        function deleteArray($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "DELETE FROM gpivots WHERE idrec=$idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function getDatosProduct($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT 
                                idproducto,
                                barcode,
                                invproducts.descrip,
                                modelo,
                                precioventa,
                                marca,
                                invproducts.xpos AS xpos,
                                invcatalog2.descrip AS departamento
                            FROM
                                invproducts
                                    INNER JOIN
                                invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                                    INNER JOIN 
                                invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                            WHERE
                                idproducto = '$idproducto'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }

        function importComprasScan($lista, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $array = explode(",", $lista);
                $tot = count($array);
                $subconsulta = "";
                if($tot==0 && trim($lista)!=""){
                    $subconsulta .= " tran_100k.trannum = $lista ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " tran_100k.trannum  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                if($subconsulta!=""){
                    $consulta = "SELECT idproducto,cantidad FROM tran_100k WHERE ($subconsulta) ORDER BY trannum ASC";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
		
		function getDatosOrden100k($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, invproducts.modelo, 
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS disponible,
                    invproducts.um, orders_100k.um AS umorders, invproducts.costounitario, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, SUM(orders_100k.cantidad * orders_100k.precioneto * orders_100k.uniconv) AS subtotal
                FROM orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                WHERE orders_100k.trannum = $idtrannum
                GROUP BY orders_100k.idrec
                ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
	
		function insertProOrders100($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $idtrannum ORDER BY itemline DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $item = $query->row_array();
                    $itemline = $item['itemline'] + 1;
                }else{
                    $itemline = 1;
                }
				
				$consulta2 = "SELECT descrip FROM invproducts WHERE idproducto = $idproducto";
                $query2 = $this->db_b->query($consulta2);
                $result = $query2->row_array();
				$descrip = $result['descrip'];
				
				$this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idtrannum);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
				
				return  $query;
            }
		}
	
		function getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro,$tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.costounitario AS costouni, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca,
                    invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                    IFNULL(inv_batch.costounitario, 0) AS costounitario,
                    (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe
                FROM invproducts
                LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                WHERE invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1 AND invproducts.tipo = $tipopro
                ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
		
		function updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');
				
				return  $query;
			}
		}
	
		function deleteDataOrders100($idtrannum, $idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $consulta = "DELETE FROM orders_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
				return $query;
            }
		}
    
		function importComprasScanUpdate($lista, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $item = $query->row_array();
                    $itemline = $item['itemline'] + 1;
                }else{
                    $itemline = 1;
                }
				
				$array = explode(",", $lista);
				$tot = count($array);
				$subconsulta = "";
				if($tot==0 && trim($lista)!=""){
					$subconsulta .= " tran_100k.trannum = $lista ";
				}else{
					for($i=0; $i<$tot; $i++){
						$subconsulta .= " tran_100k.trannum  = $array[$i]  OR "; 
					}
					$subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
				}
				if($subconsulta!=""){
					$consulta = "SELECT idproducto, cantidad FROM tran_100k WHERE ($subconsulta) ORDER BY trannum ASC";
					$query = $this->db_b->query($consulta);
					if($query->num_rows()>0){
						$resultado = $query->result();
						foreach($resultado as $res){
							$idproducto = $res->idproducto;
							$cantidad = $res->cantidad;
							$consulta2 = "SELECT descrip,um, precioventa FROM invproducts WHERE idproducto = $idproducto";
							$query2 = $this->db_b->query($consulta2);
							$result = $query2->row_array();
							$descrip = $result['descrip'];
							$um = $result['um'];
							$precioventa = $result['precioventa'];

							$this->db_b->set('idrec', 0);
							$this->db_b->set('trannum', $trannum);
							$this->db_b->set('itemline', $itemline);
							$this->db_b->set('idproducto', $idproducto);
							$this->db_b->set('descrip', $descrip);
							$this->db_b->set('cantidad', $cantidad);
							$this->db_b->set('um', $um);
							$this->db_b->set('uniconv', 1);
							$this->db_b->set('precioneto', $precioventa);
							$this->db_b->set('whodidit', $this->session->userdata('iduser'));
							$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
							$query = $this->db_b->insert('orders_100k');
							$itemline++;
						}
						

						$SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $trannum";
						$SQLDQuery = $this->db_b->query($SQLDatos);
						$SQLResult = $SQLDQuery->row_array();

						$this->db_b->set('val_pro', $SQLResult['TotalSum']);
						$this->db_b->set('whodidit',$this->session->userdata('iduser'));
						$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
						$this->db_b->where('trannum', $trannum);
						$query2 = $this->db_b->update('orders_100');
						return  $query;

					}else{
						return false;	
					} 
				}else{
					return false;
				}
			}
		}
	
		function getProductsOrder($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				$consulta = "SELECT * FROM orders_100k WHERE orders_100k.trannum = $trannum ORDER BY idrec ASC";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$result = $query->result();
					return  $result;	
				}else{
					return false;
				}
			}
        }
        
        function getProductsOrderEspecifico($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				$consulta = "SELECT orders_100k.idproducto, orders_100k.cantidad,  IF(invproducts.modelo = '', '-', invproducts.modelo) as modelo ,  TRIM(invproducts.marca) AS marca, invproducts.idproducto, invproducts.precioventa, invproducts.pro_color, invproducts.presenta, invproducts.descrip FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto  WHERE orders_100k.trannum = $trannum ORDER BY invproducts.marca,invproducts.modelo ASC";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$result = $query->result();
					return  $result;	
				}else{
					return false;
				}
			}
        }
        
        function getProductsOrderEspecificoOrderByItemLine($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				$consulta = "SELECT orders_100k.idproducto, orders_100k.cantidad,  IF(invproducts.modelo = '', '-', invproducts.modelo) as modelo ,  TRIM(invproducts.marca) AS marca, invproducts.idproducto, invproducts.precioventa, invproducts.pro_color, invproducts.presenta, invproducts.descrip, invproducts.um, invproducts.upp, invproducts.barcode, invproducts.idprovee AS codProveedor, invcatalog.descrip AS lineaProducto FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo  WHERE orders_100k.trannum = $trannum ORDER BY orders_100k.itemline ASC";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$result = $query->result();
					return  $result;	
				}else{
					return false;
				}
			}
	    }
        
        function getProductsOrderEspecificoRecepcion($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				$consulta = "SELECT tran_100km.*,  IF(tran_100km.modelo = '', '-', tran_100km.modelo) as modelo ,  TRIM(tran_100km.marca) AS marca, invproducts.idproducto, tran_100km.precioventa, tran_100km.color AS pro_color, invproducts.presenta, invproducts.descrip FROM tran_100km LEFT JOIN invproducts ON tran_100km.idproducto = invproducts.idproducto WHERE tran_100km.trannum = $trannum  ORDER BY invproducts.marca, invproducts.modelo ASC";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$result = $query->result();
					return  $result;	
				}else{
					return false;
				}
			}
        }
        
        function getDatoPreciosMultiplesByDescrip($descrip, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta ="SELECT precioventa FROM invpromulti WHERE descrip = '$descrip' AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->row_array();
                    $valorPrecio = $resultado['precioventa'];
                }else{
                    $valorPrecio = 0;
                }

                return $valorPrecio;
            }
        }
        function getDatosProductLineas($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idproducto, invproducts.descrip, precioventa, invcatalog.descrip AS linea
                            FROM invproducts INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                            WHERE idproducto = '$idproducto'
                            ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }

        //Recuentos 
        function getRecuentosFinalizados($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{

                $this->db_b->select('a.*, IFNULL(b.descrip, "") as sucursal');
                $this->db_b->from('orders_100 a');
                $this->db_b->join('invsites b', '(a.idcentro = b.idcentro) AND (b.estatus = 1)', 'left');
                $this->db_b->where('a.agrupa', "SJ");
                $this->db_b->where('length(a.nrc) >', 0);
                $this->db_b->where('a.idcentro', $idcentro);

                $this->db_b->order_by('a.fecha DESC');
                $datos = $this->db_b->get();
                
                if($datos->num_rows() > 0){
                    $resultado = $datos->result_array();
                }else{
                    $resultado = false;
                }

                return $resultado;
            }
        }

        function getProductosRecuentosConsolidados($trannums){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{

                $this->db_b->select('a.idproducto, c.descrip, c.modelo, c.barcode, SUM(a.cantidad) as cant');
                $this->db_b->from('orders_100k a');
                $this->db_b->join('orders_100 b', 'b.trannum = a.trannum', 'inner');
                $this->db_b->join('invproducts c', 'c.idproducto = a.idproducto', 'inner');
                $this->db_b->where('a.trannum ='.$trannums);

                $this->db_b->group_by('a.idproducto');
                $datos = $this->db_b->get();
                
                if($datos->num_rows() > 0){
                    $resultado = $datos->result_array();
                }else{
                    $resultado = false; 
                }
                
                return $resultado;
            }
        }

        //generador de tokes
        function getTokensGenerados($estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{

                $this->db_b->select('a.idrec, a.fecha_emision, a.fecha_expiracion. a.token, a.trannum, a.tipo_proceso');
                $this->db_b->select('b.idcentro, b.descrip as descripSucursal, c.iduser, c.descrip as descripUser');
                $this->db_b->from('g_tokens a');
                $this->db_b->join('invsites b', '(b.idcentro = a.idcentro)', 'inner');
                $this->db_b->join('gusers c', '(c.iduser = a.iduser)', 'inner');
                //$this->db_b->join('orders_100 d', '(d.trannum = a.idrecuento)', 'inner');

                $this->db_b->where('a.estado', $estado);
                $this->db_b->order_by('a.ingresa DESC');
                
                $datos = $this->db_b->get();
                
                if($datos->num_rows() > 0){
                    $resultado = $datos->result_array();
                }else{
                    $resultado = false;
                }

                return $resultado;
            }
        }
	}
?>