<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Sadmin_model extends CI_Model {
             
		public function __construct(){
            $CI =& get_instance();
            $this->db_b = $CI->load->database('default', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                //echo 'Incorrect database information provided';
            }
        }
        
        function getListadoCuentas(){
            $this->db->select('idaccount, descrip, telefono, correo, server_name, ncomercial');
            $this->db->from('wpos_cuentas');
            $this->db->where('estado', 1);
            $this->db->order_by('descrip', 'ASC');
            
            $query = $this->db->get();
                
            $data = [];
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $info) {
                    $data[] = array(
                        'idaccount'   => $info->idaccount,
                        'descrip'     => $info->descrip,
                        'telefono'    => $info->telefono,
                        'correo'      => $info->correo,
                        'server_name' => $info->server_name,
                        'ncomercial'  => ($info->ncomercial == '') ? '' : '('.$info->ncomercial.')',
                        'busqueda'    => $info->idaccount.' '.$info->descrip.' '.$info->ncomercial.' '.$info->server_name
                    );
                }
            }

            return $data;
        }

        function validateUserLogin($username, $password){

            $crf = '$EgGa8466-2$/';
            $password = md5($crf . $password);

            $this->db->select('iduser');
            $this->db->from('g_users');
            $this->db->where('username', $username);
            $this->db->where('password', $password);
            $this->db->where('estado',   1);
            
            $result = ($this->db->get()->num_rows() > 0) ? true : false;

            return $result;
        }

        function getAllDayConnections(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d");

                $this->db->select('SUM(login00 + login01 + login02 + login03 + login04 + login05 + login06 + login07 + login08 + login09 + login10 + login11 + login12 + login13 + login14 + login15 + login16 + login17 + login18 + login19 + login20 + login21 + login22 + login23) AS totalDay', FALSE);
                $this->db->from('wpos_cuentas_log');
                $this->db->where('fecha',     $fecha);
                $query = $this->db->get();
                
                $data = ($query->row()->totalDay != null) ? $query->row()->totalDay : 0;

                return $data;
            }
        }
        
        function getTotalAccounts(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $this->db->select('COUNT(idrnum) AS totalAcc', FALSE);
                $this->db->from('wpos_cuentas');
                $this->db->where('estado', 1);
                $query = $this->db->get();
                
                $data = ($query->row()->totalAcc != null) ? $query->row()->totalAcc : 0;

                return $data;
            }
        }

        function getTotalAccountsConnect(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d");

                $this->db->select('idaccount');
                $this->db->from('wpos_cuentas_log');
                $this->db->where('fecha', $fecha);
                $this->db->group_by('idaccount');
                $query = $this->db->get();
                
                $data = ($query->num_rows() > 0) ? $query->num_rows() : 0;

                return $data;
            }
        }

        function getDayConnections($idaccount){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d");

                $this->db->select('SUM(login00 + login01 + login02 + login03 + login04 + login05 + login06 + login07 + login08 + login09 + login10 + login11 + login12 + login13 + login14 + login15 + login16 + login17 + login18 + login19 + login20 + login21 + login22 + login23) AS totalDay', FALSE);
                $this->db->from('wpos_cuentas_log');
                $this->db->where('fecha',     $fecha);
                $this->db->where('idaccount', $idaccount);
                $query = $this->db->get();
                
                $data = ($query->row()->totalDay != null) ? $query->row()->totalDay : 0;

                return $data;
            }
        }

        function getGlobalConnections($idaccount){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $this->db->select('SUM(login00 + login01 + login02 + login03 + login04 + login05 + login06 + login07 + login08 + login09 + login10 + login11 + login12 + login13 + login14 + login15 + login16 + login17 + login18 + login19 + login20 + login21 + login22 + login23) AS totalGlob', FALSE);
                $this->db->from('wpos_cuentas_log');
                $this->db->where('idaccount', $idaccount);
                $query = $this->db->get();
                
                $data = ($query->row()->totalGlob != null) ? $query->row()->totalGlob : 0;

                return $data;
            }
        }

        function getDetalleConnections($idaccount){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $this->db->select("g_users.descrip, g_users.correo1, g_users_log.date, g_users_log.time, g_users_log.notas");
                $this->db->from('g_users_log');
                $this->db->join('g_users', 'g_users.iduser = g_users_log.iduser', 'inner');
                $this->db->where('g_users_log.idaccount', $idaccount);
                $this->db->order_by('g_users_log.ingresa', 'DESC');
                $query = $this->db->get();
                
                $data = [];
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $info) {
                        $data[] = array(
                            'descrip'   => $info->descrip,
                            'correo1'   => $info->correo1,
                            'date'      => date_format(date_create($info->date), "d/m/Y"),
                            'time'      => date_format(date_create($info->time), "g:i A"),
                            'notas'     => $info->notas
                        );
                    }
                }

                return $data;
            }
        }

        function getDetailHours(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d");

                $this->db->select_sum('login00');
                $this->db->select_sum('login01');
                $this->db->select_sum('login02');
                $this->db->select_sum('login03');
                $this->db->select_sum('login04');
                $this->db->select_sum('login05');
                $this->db->select_sum('login06');
                $this->db->select_sum('login07');
                $this->db->select_sum('login08');
                $this->db->select_sum('login09');
                $this->db->select_sum('login10');
                $this->db->select_sum('login11');
                $this->db->select_sum('login12');
                $this->db->select_sum('login13');
                $this->db->select_sum('login14');
                $this->db->select_sum('login15');
                $this->db->select_sum('login16');
                $this->db->select_sum('login17');
                $this->db->select_sum('login18');
                $this->db->select_sum('login19');
                $this->db->select_sum('login20');
                $this->db->select_sum('login21');
                $this->db->select_sum('login22');
                $this->db->select_sum('login23');
                $this->db->from('wpos_cuentas_log');
                $this->db->where('fecha', $fecha);
                $query = $this->db->get();
                
                $data = [];
                $info = ($query->num_rows() > 0) ? $query->row() : false;
                
                if($info != false){
                    $totConnects = $info->login00 + $info->login01 + $info->login02 + $info->login03 + $info->login04 + $info->login05 + $info->login06 + $info->login07 + $info->login08 + $info->login09 + $info->login10 + $info->login11 + $info->login12 + $info->login13 + $info->login14 + $info->login15 + $info->login16 + $info->login17 + $info->login18 + $info->login19 + $info->login20 + $info->login21 + $info->login22 + $info->login23;

                    $data[] = array('hora' =>  0, 'conexiones' => (int) $info->login00, 'porcentaje' => ($totConnects == 0) ? $info->login00 : number_format((($info->login00 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  1, 'conexiones' => (int) $info->login01, 'porcentaje' => ($totConnects == 0) ? $info->login01 : number_format((($info->login01 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  2, 'conexiones' => (int) $info->login02, 'porcentaje' => ($totConnects == 0) ? $info->login02 : number_format((($info->login02 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  3, 'conexiones' => (int) $info->login03, 'porcentaje' => ($totConnects == 0) ? $info->login03 : number_format((($info->login03 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  4, 'conexiones' => (int) $info->login04, 'porcentaje' => ($totConnects == 0) ? $info->login04 : number_format((($info->login04 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  5, 'conexiones' => (int) $info->login05, 'porcentaje' => ($totConnects == 0) ? $info->login05 : number_format((($info->login05 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  6, 'conexiones' => (int) $info->login06, 'porcentaje' => ($totConnects == 0) ? $info->login06 : number_format((($info->login06 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  7, 'conexiones' => (int) $info->login07, 'porcentaje' => ($totConnects == 0) ? $info->login07 : number_format((($info->login07 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  8, 'conexiones' => (int) $info->login08, 'porcentaje' => ($totConnects == 0) ? $info->login08 : number_format((($info->login08 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' =>  9, 'conexiones' => (int) $info->login09, 'porcentaje' => ($totConnects == 0) ? $info->login09 : number_format((($info->login09 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 10, 'conexiones' => (int) $info->login10, 'porcentaje' => ($totConnects == 0) ? $info->login10 : number_format((($info->login10 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 11, 'conexiones' => (int) $info->login11, 'porcentaje' => ($totConnects == 0) ? $info->login11 : number_format((($info->login11 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 12, 'conexiones' => (int) $info->login12, 'porcentaje' => ($totConnects == 0) ? $info->login12 : number_format((($info->login12 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 13, 'conexiones' => (int) $info->login13, 'porcentaje' => ($totConnects == 0) ? $info->login13 : number_format((($info->login13 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 14, 'conexiones' => (int) $info->login14, 'porcentaje' => ($totConnects == 0) ? $info->login14 : number_format((($info->login14 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 15, 'conexiones' => (int) $info->login15, 'porcentaje' => ($totConnects == 0) ? $info->login15 : number_format((($info->login15 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 16, 'conexiones' => (int) $info->login16, 'porcentaje' => ($totConnects == 0) ? $info->login16 : number_format((($info->login16 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 17, 'conexiones' => (int) $info->login17, 'porcentaje' => ($totConnects == 0) ? $info->login17 : number_format((($info->login17 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 18, 'conexiones' => (int) $info->login18, 'porcentaje' => ($totConnects == 0) ? $info->login18 : number_format((($info->login18 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 19, 'conexiones' => (int) $info->login19, 'porcentaje' => ($totConnects == 0) ? $info->login19 : number_format((($info->login19 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 20, 'conexiones' => (int) $info->login20, 'porcentaje' => ($totConnects == 0) ? $info->login20 : number_format((($info->login20 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 21, 'conexiones' => (int) $info->login21, 'porcentaje' => ($totConnects == 0) ? $info->login21 : number_format((($info->login21 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 22, 'conexiones' => (int) $info->login22, 'porcentaje' => ($totConnects == 0) ? $info->login22 : number_format((($info->login22 / $totConnects) * 100), 2, '.', '') . ' %');
                    $data[] = array('hora' => 23, 'conexiones' => (int) $info->login23, 'porcentaje' => ($totConnects == 0) ? $info->login23 : number_format((($info->login23 / $totConnects) * 100), 2, '.', '') . ' %');
                }
                    
                return $data;
            }
        }

        function loginSadmin($cuenta, $username, $password, $motivocon){
            // if($this->session->userdata('log_sadmin') != TRUE){
            //     redirect('sadmin/');
            // }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $fecha_actual    = $date->format('Y-m-d H:i:s');
                $fechaactual     = $date->format('Y-m-d');
                $hora_login      = $date->format('H:i');
                $numb_login      = $date->format('H');
                $numberDay       = $date->format('w');
                $numberDay       = $numberDay + 1;
                
                $validate_cuenta = "estado = '1' AND idaccount = '".$cuenta."' AND fechavence >= '".$fechaactual."'";
                
                $this->db->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, moneda, fechavence');
                $this->db->from('wpos_cuentas');
                $this->db->where($validate_cuenta);
                $this->db->limit(1);
                $QueryCuenta = $this->db->get();
                
                if($QueryCuenta->num_rows() == 1){
                    $infoCuenta = $QueryCuenta->row_array();
                        
                    $CuentaArray = array(
                        'idaccount' => $infoCuenta['idaccount'],
                        'descrip'   => $infoCuenta['descrip'],
                        'serverDB'  => $infoCuenta['dbp1'],
                        'nameDB'    => $infoCuenta['dbp2'],
                        'userDB'    => $infoCuenta['dbp3'],
                        'passDB'    => $infoCuenta['dbp4'],
                        'simboloMoneda' => $infoCuenta['moneda']
                    );
                    $this->session->set_userdata($CuentaArray);

                    $idaccount = $infoCuenta['idaccount'];
                    $nameempre = $infoCuenta['descrip'];

                    // $consonants  = array(",", " ", ".", "b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "ñ", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z",
                    //                     ",", " ", ".", "B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "Ñ", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z");
                    // $infoEmpresa = str_replace($consonants, "", $nameempre);

                    // $infoKey   = 'Egga8466-2';
                    // $infoToken = "'" . md5($idaccount.$infoEmpresa.$infoKey) . "'";
                
                    $keyCifrado     = '$EgGa8466-2$/';
                    $nuevaContra    = md5($keyCifrado . $password);                
                    $validate_user  = "password = '".$nuevaContra."' AND username = '".$username."' AND  estado = '1' AND duedate >= '".$fechaactual."'";
                    
                    $this->db->select('iduser, descrip, username, derechos, profile');
                    $this->db->from('g_users');
                    $this->db->where($validate_user);
                    $this->db->limit(1);
                    $QueryUser = $this->db->get();
                    
                    $infoUser     = $QueryUser->row_array();
                    $profile      = $infoUser['profile'];
                    $infoDerechos = $infoUser['derechos'];
                    
                    $UserData = array(
                        'iduser'    => $infoUser['iduser'],
                        'adminUser' => 1,
                        'userLog'   => $infoUser['descrip'],
                        'profile'   => $infoUser['profile'],
                        'horaini'   => '00:00',
                        'horafin'   => '00:00',
                        'logueado'  => 'TRUE',
                        'logueado2' => TRUE
                    );
                    $this->session->set_userdata($UserData);

                    $this->db->set('lastlogin', $fecha_actual);
                    $this->db->where('iduser', $infoUser['iduser']);
                    $QueryUpdate = $this->db->update('g_users');

                    $this->db->set('idrec', 0);
                    $this->db->set('iduser', $infoUser['iduser']);
                    $this->db->set('idaccount', $idaccount);
                    $this->db->set('date', $fechaactual);
                    $this->db->set('time', $hora_login);
                    $this->db->set('notas', $motivocon);
                    $this->db->set('estado', 1);
                    $this->db->set('whodidit', $infoUser['iduser']);
                    $this->db->set('ingresa', $fecha_actual);
                    $this->db->insert('g_users_log');

                    $this->updateDatosCuenta($fechaactual, $numb_login, $idaccount);

                    return TRUE;
                }else{
                    $LoginFail = array(
                        'Cuenta' => 1
                    );
                    $this->session->set_userdata($LoginFail);
                    return false;
                }
            // }
        }

        function updateDatosCuenta($fecha, $numb_login, $idaccount){
            $nameField = 'login'.$numb_login;

            $this->db->select('idrec, '.$nameField);
            $this->db->from('wpos_cuentas_log');
            $this->db->where('fecha',     $fecha);
            $this->db->where('idaccount', $idaccount);
            $query = $this->db->get();
                    
            if($query->num_rows() == 1){
                $data    = $query->row_array();
                $numLogs = $data[$nameField] + 1;
            
                $this->db->set($nameField, $numLogs);
                $this->db->where('idrec',  $data['idrec']);
                $result = $this->db->update('wpos_cuentas_log');
            }else{
                $this->db->set('fecha',     $fecha);
                $this->db->set('idaccount', $idaccount);
                $this->db->set($nameField,  1);
                $result = $this->db->insert('wpos_cuentas_log');
            }

            return $result;
        }
	}
?>