<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Project_Manager_model extends CI_Model {
        
        private $TIProductos = 'invproducts';
        private $TIMProductos = 'invpromulti';//
        
        public function __construct() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                //echo 'Incorrect database information provided';
            }
        }

        private function validatePermiso() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) redirect('CerrarSesion');
            else return true;
        }

        #Project Manager
        function getInfoClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip, telefono, correo, direccion, idzip, nrc, dui, nit, grupo');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 2);
                $this->db_b->where('estado', 1);
                $this->db_b->order_by('descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => intval($info->idauxi),
                            'descripcion' => $info->descrip,
                            'telefono' => $info->telefono,
                            'correo' => $info->correo,
                            'direccion' => $info->direccion,
                            'zip' => $info->idzip,
                            'nrc' => $info->nrc,
                            'dui' => $info->dui,
                            'nit' => $info->nit,
                            'grupo' => $info->grupo
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getInfoEmp($cliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcontacto, idcps, nombre, cargo, telefono, email, notas');
                $this->db_b->from('pm_100c');
                $this->db_b->where('idcps', $cliente);
                //$this->db_b->where('estado', 1);
                $this->db_b->order_by('nombre', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idcontacto,
                            'codCliente' => intval($info->idcps),
                            'descripcion' => $info->nombre,
                            'cargo' => $info->cargo,
                            'telefono' => $info->telefono,
                            'email' => $info->email,
                            'notas' => $info->notas
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getInfoEmpInterno(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 3);
                $this->db_b->where('estado', 1);
                $this->db_b->order_by('descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idauxi,
                            'descripcion' => $info->descrip
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getPmClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps, ctauxi.descrip, ctauxi.nrc');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                //$this->db_b->where('idauxidef', 2);
                //$this->db_b->where('estado', 1);
                $this->db_b->group_by('pm_100.idcps');
                $this->db_b->order_by('ctauxi.descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                $completedState = (object)[];
                $pendingState = (object)[];
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $infoProjectCliente = $this->getSystemsOrServicesByClients($info->idcps);
                        $estado = '';
                        $totalState = 0;
                        $cantProyectos = 0;
                        foreach($infoProjectCliente as $projectInfo) {
                            $totalState += $projectInfo->estado;
                            $cantProyectos += 1;
                        }

                        $estado = (($cantProyectos * 2) == $totalState) ? '2. Completado' : '1. En proceso';

                        $arrayResp[] = array(
                            'codigo' => $info->idcps,
                            'descripcion' => $info->descrip,
                            'nrc' => $info->nrc,
                            'estado' => $estado
                        );
                    }
                }

                return $arrayResp;
            }
        }

        function getProjectsByService($idService, $idAuxi/*, $status*/){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                $this->db_b->where('pm_100.idcps', $idAuxi);
                //$this->db_b->where('pm_100.estado', $status);
                $this->db_b->order_by('pm_100.fase', 'ASC');
                $this->db_b->order_by('pm_100.actividad', 'ASC');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getPhasesActivitiesByService($idService, $idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                //$this->db_b->where('pm_100.idcps', $idAuxi);
                $this->db_b->where('pm_100.idcps', 323);
                $this->db_b->group_by('pm_100.actividad');
                $this->db_b->group_by('pm_100.fase');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getAssignedToProject($assigned){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $assignedArray = explode(',', $assigned);
                $contacts = '';

                foreach($assignedArray as $assign){
                    $this->db_b->select('nombre');
                    $this->db_b->from('pm_100c');
                    $this->db_b->where('idcontacto', $assign);
    
                    $query = $this->db_b->get();
                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $contacts .= trim($info->nombre).', ';
                        }
                    }
                }

                $contacts = rtrim($contacts,", ");

                return $contacts;
            }
        }

        function getWorkerAssignedToProject($worker){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $workerArray = explode(',', $worker);
                $contacts = '';

                foreach($workerArray as $idworker){
                    $this->db_b->select('descrip');
                    $this->db_b->from('ctauxi');
                    //$this->db_b->where('idauxidef', 3);
                    //$this->db_b->where('estado', 1);
                    $this->db_b->where('idauxi', $idworker);
    
                    $query = $this->db_b->get();
                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $contacts .= trim($info->descrip).', ';
                        }
                    }
                }

                $contacts = rtrim($contacts,", ");

                return $contacts;
            }
        }

        function setNewProject($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    $this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function setMultiProjects($idcps, $idservicio){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                //$alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                //if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                //}else {
                    //$result = false;
                //}
            
            return $result;
            }
        }

        function verifyIfProjectExists($idcps, $idservicio, $actividad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcps, idservicio, actividad');
                $this->db_b->from('pm_100');
                $this->db_b->where('idcps', $idcps);
                $this->db_b->where('idservicio', $idservicio);
                $this->db_b->where('actividad', $actividad);

                $query = $this->db_b->get();
                //$arrayResp = array();
                if($query->num_rows() > 0){
                    //$infoQuery = $query->result();
                    return true;
                }
                return false;
            }
        }

        function updateProject($idrec, $idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idservicio', $idservicio);
                $this->db_b->set('fase', $fase);
                $this->db_b->set('actividad', $actividad);
                $this->db_b->set('asignadoa', $asignado);
                $this->db_b->set('idworker', $worker);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('fechaini', $fechaIni);
                $this->db_b->set('fechafin', $fechaFin);
                if($estado == 2 ) {
                    $this->db_b->set('fechadone', $fecha_actual);
                } else {
                    $this->db_b->set('fechadone', '');
                }
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $idrec);
                $result = $this->db_b->update('pm_100');
            
            return $result;
            }
        }

        function setNewActivity($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    $this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function setNewActivities($idcps, $idservicio, $fase, $actividad, $worker, $estado, $fechaIni, $fechaFin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    //$this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    //$this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function addContact($idcps, $nombre, $cargo, $telefono, $email, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('nombre', $nombre);
                $this->db_b->set('cargo', $cargo);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('email', $email);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('pm_100c');
            
            return $result;
            }
        }

        function updateContact($idContacto, $idcps, $nombre, $cargo, $telefono, $email, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcontacto', $idContacto);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('nombre', $nombre);
                $this->db_b->set('cargo', $cargo);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('email', $email);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idcontacto', $idContacto);
                $result = $this->db_b->update('pm_100c');
            
            return $result;
            }
        }

        function deleteContact($idContacto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idcontacto', $idContacto);
                
                $resultado = $this->db_b->delete('pm_100c');
                return $resultado;
            }
        }

        function deleteProject($recNumber){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idrec', $recNumber);
                
                $resultado = $this->db_b->delete('pm_100');
                return $resultado;
            }
        }

        function getSystemsOrServicesByClients($idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('idrec, idservicio, fechaini, fechafin, estado, notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('idcps', $idAuxi);
                $this->db_b->where('fase', '');
                $this->db_b->where('actividad', '');
                $this->db_b->group_by('idservicio');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getFilesByClient($idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('idrec, idrecpm100, idcps, descrip, archivo');
                $this->db_b->from('pm_100m');
                $this->db_b->where('idcps', $idAuxi);
                //$this->db_b->group_by('idservicio');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function insertFilesByClients($file_data){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->insert('pm_100m', $file_data);
            }
        }

        function deleteFilesByClient($file_data, $cliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('archivo', $file_data);
                $this->db_b->where('idcps', $cliente);
                return $this->db_b->delete('pm_100m');
            }
        }

        function insertAnexosFilesByClients($file_data){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->insert('pm_100n', $file_data);
            }
        }

        function deleteAnexosFilesByClient($file_data, $project){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('archivo', $file_data);
                $this->db_b->where('descrip', $project);
                return $this->db_b->delete('pm_100n');
            }
        }

        function getNameClienteReport($idCliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descrip');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 2);
                $this->db_b->where('estado', 1);
                $this->db_b->where('idauxi', $idCliente);

                $dato = $this->db_b->get();
                if($dato->num_rows() > 0){
                    return $dato->row()->descrip;
                }else return false;
            }
        }

        function getClientsReport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps');
                $this->db_b->from('pm_100');
                $this->db_b->group_by('pm_100.idcps');
                //$this->db_b->where('pm_100.idservicio', $idService);
                //$this->db_b->where('pm_100.idcps', $idAuxi);

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getPendingActivitiesByWorker($idWorker, $fechaInicial, $fechaFin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.notas, ctauxi.descrip AS nCliente, gvars.descripcion AS nProyecto');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                $this->db_b->join('gvars', 'gvars.valor_num = pm_100.idservicio AND gvars.nombre = "pm_tipos"');
                $this->db_b->where('fechaini >=', $fechaInicial);
                $this->db_b->where('fechaini <=', $fechaFin);
                $this->db_b->where('pm_100.estado', 0);
                $this->db_b->like('CONCAT(",",idworker,",")', ','.$idWorker.',');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getProjectsByServiceReports($idService, $idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                $this->db_b->where('pm_100.idcps', $idAuxi);
                $this->db_b->where('pm_100.fase !=', '');
                $this->db_b->where('pm_100.actividad !=', '');
                $this->db_b->order_by('pm_100.fase', 'ASC');
                $this->db_b->order_by('pm_100.actividad', 'ASC');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getNotesByClinet($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idrec, idcps, fecha, descrip, asignadoa, notas');
                $this->db_b->from('pm_100notes');
                $this->db_b->where('idcps', $idcps);
                $this->db_b->order_by('idrec', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => intval($info->idrec),
                            'cliente' => $info->idcps,
                            'fechaIngreso' => $info->fecha,
                            'tituloNota' => $info->descrip,
                            'asignadoa' => explode(',', $info->asignadoa),
                            'detalleNota' => $info->notas,
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function addClientNotes($idcps, $titulo, $detalle, $fecha, $asignados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $titulo);
                $this->db_b->set('asignadoa', $asignados);
                $this->db_b->set('notas', $detalle);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('pm_100notes');
            
            return $result;
            }
        }

        function updateClientNotes($notaCode, $idcps, $titulo, $detalle, $fecha, $asignados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                //$this->db_b->set('idrec', $notaCode);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $titulo);
                $this->db_b->set('asignadoa', $asignados);
                $this->db_b->set('notas', $detalle);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $notaCode);
                $result = $this->db_b->update('pm_100notes');
            
                return $result;
            }
        }

        function deleteClientNotes($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idrec', $idrec);
                
                $resultado = $this->db_b->delete('pm_100notes');
                return $resultado;
            }
        }

        function checkGiroDteField(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultado = $this->db_b->field_exists('dte_giro25', 'ctauxi');
                return $resultado;
            }
        }

        function updateProjectDateAndStatus($idrec, $fechaIni, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                //$this->db_b->set('idrec', $notaCode);
                $this->db_b->set('fechaini', $fechaIni);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $idrec);
                $result = $this->db_b->update('pm_100');
            
                return $result;
            }
        }

        //Tasks Control
        function getTasks($idWorker) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.notas, ctauxi.descrip AS nCliente, gvars.descripcion AS nProyecto');
                $this->db_b->select('pm_100.fechaini, pm_100.fechafin, pm_100.estado, pm_100.asignadoa, pm_100.idworker');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                $this->db_b->join('gvars', 'gvars.valor_num = pm_100.idservicio AND gvars.nombre = "pm_tipos"');
                //$this->db_b->where('pm_100.estado', 0);
                $this->db_b->like('CONCAT(",",idworker,",")', ','.$idWorker.',');
                $this->db_b->order_by('fechaini', 'DESC');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function editTaskNotesAndStatus($idrec, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('estado', $estado);
                if($estado == 2 ) {
                    $this->db_b->set('fechadone', $fecha_actual);
                } else {
                    $this->db_b->set('fechadone', '');
                }
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $idrec);
                $result = $this->db_b->update('pm_100');
            
            return $result;
            }
        }
    }
?>