<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Producto_model extends CI_Model{
		
        private $iconosMenu = array(
            'square' => 0,
            'money' => 1,
            'fas fa-barcode' => 2,
            'fas fa-shopping-basket' => 3,//stopwatch-20
            'image' => 4,
            'fas fa-list-alt' => 5,
            'fas fa-truck' => 6,//people-carry
            'fas fa-exchange-alt' => 7,
            'card' => 9,
            'link' => 10,
            'fas fa-boxes' => 99
        );
        //private $TIProductos = 'productos';
        private $TIProductos = 'invproducts';
        //private $TIMProductos = 'productos_multi';
        private $TIMProductos = 'invpromulti';
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
		function viewProducto($id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT * FROM invproducts WHERE idcatalogo = $id";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto , invcatalog.descrip AS linea, invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, invproducts.precioventa AS precioventa,invproducts.costounitario  FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getListadoProductosTxt(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT idproducto, descrip, modelo, marca, precioventa, xpos FROM invproducts WHERE estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getListadoModelosProductos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT DISTINCT IF(modelo = '', 'SIN MODELO', modelo) AS modelo, idcatalogo FROM invproducts";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function validateInventarioProducto($idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT FORMAT(SUM(tran_100k.cantidad * tran_100k.uniconv),2) AS cantidad FROM tran_100k WHERE idproducto = $idproducto HAVING cantidad > 0";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $inventario = 1;
                }else{
                    $inventario = 0;
                }
                
                return $inventario;
            }
        }
                
        function getFactorProducto($idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT mur, sst, imagen FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $informacion = $query->row_array();

                $valorFactor = 0;
                if($informacion['mur'] != 0){
                    $valorFactor = $informacion['mur'];
                }else{
                    if($informacion['sst'] != 0){
                        $valorFactor = $informacion['sst'];
                    }
                }
                
                return $valorFactor;
            }
        }
                
        function modificarFactorConversion($idproducto, $factor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fechaupdate = date("Y-m-d H:i:s");

                $this->db_b->set('mur', $factor);
                $this->db_b->set('sst', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fechaupdate);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');
            }
        }
        
        function verifyCodiBarra($idgvar,$idproducto,$descrip){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(count(idrec),0) AS cant FROM invpromulti WHERE idgvar=$idgvar AND idproducto=$idproducto AND descrip='$descrip'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }
        
        function verifyCodiBarraTodos($idgvar,$idproducto,$descrip){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(count(idrec),0) AS cant FROM invpromulti WHERE idgvar=$idgvar AND descrip='$descrip'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }
        
        function viewProductos_Linea($linea){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.idcatalogo=$linea";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos_Marca($marca){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                if($marca!="TODAS"){
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.marca  LIKE '".$marca."'";
                }else{
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts LIMIT 2000";
                }
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }
        
        function getCant_pro_marca($marca){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                if($marca!="TODAS"){
                    $consulta = "SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.marca  LIKE '".$marca."'";
                }else{
                    $consulta = "SELECT count(invproducts.idproducto) AS cantidad FROM invproducts";
                }
                
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->row_array();
                    $return = $resultado['cantidad'];
                }else{
                    $return = 0;
                }
                return $return;
            }
        }
        
        function getLineasByMarca($marca){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                if($marca!="TODAS"){
                    $consulta = "SELECT  DISTINCT(invproducts.idcatalogo) as id, invcatalog.descrip as text FROM invproducts inner join invcatalog ON invcatalog.idcatalogo=invproducts.idcatalogo WHERE invproducts.marca   LIKE '".$marca."' ORDER BY invcatalog.descrip ASC";
                }else{
                    $consulta = "SELECT  DISTINCT(invproducts.idcatalogo) as id, invcatalog.descrip as text FROM invproducts inner join invcatalog ON invcatalog.idcatalogo=invproducts.idcatalogo ORDER BY invcatalog.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }
        
        function viewProductos_Linea_Marcas($linea, $marcas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                
                $subconsulta="";
                $array = explode(",", $marcas);
                $tot = count($array);
                if($tot==0 && trim($marcas)!=""){
                    $subconsulta .= " invproducts.marca  LIKE '".$marcas."' ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.marca  LIKE '".$array[$i]."'  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                
                if($subconsulta!=""){
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.idcatalogo=$linea AND ( $subconsulta)";
                }else{
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.idcatalogo=$linea";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos_Marcas_Lineas($marca,$lineas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                
                $subconsulta="";
                $array = explode(",", $lineas);
                $tot = count($array);
                if($tot==0 && trim($lineas)!=""){
                    $subconsulta .= " invproducts.idcatalogo  = '".$lineas."' ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.idcatalogo  = '".$array[$i]."'  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                
                if($subconsulta!=""){
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.marca LIKE '$marca'  AND ( $subconsulta)";
                }else{
                    $consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto,invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, ifnull(invproducts.precioventa,0) AS precioventa,  invproducts.costounitario, invproducts.notas, invproducts.barcode  FROM invproducts WHERE invproducts.marca LIKE '$marca' ";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCant_pro_linea($linea){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.idcatalogo=$linea";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cantidad'];
            }
        }
        
        function getCant_pro_linea_Marca($linea, $marcas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $subconsulta="";
                $array = explode(",", $marcas);
                $tot = count($array);
                if($tot==0 && trim($marcas)!=""){
                    $subconsulta .= " invproducts.marca  LIKE '".$marcas."' ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.marca  LIKE '".$array[$i]."'  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                if($subconsulta!=""){
                    $consulta = " SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.idcatalogo=$linea AND ( $subconsulta)";

                }else{
                    $consulta = "SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.idcatalogo=$linea";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cantidad'];
            }
        }
        
        function getCant_pro_Marca_Lineas($marca, $lineas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $subconsulta="";
                $array = explode(",", $lineas);
                $tot = count($array);
                if($tot==0 && trim($lineas)!=""){
                    $subconsulta .= " invproducts.idcatalogo = ".$lineas." ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.idcatalogo = ".$array[$i]." OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                if($subconsulta!=""){
                    $consulta = " SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.marca LIKE '$marca' AND ( $subconsulta)";

                }else{
                    $consulta = "SELECT count(invproducts.idproducto) AS cantidad FROM invproducts WHERE invproducts.marca LIKE '$marca'";
                }
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cantidad'];
            }
        }
        
        function viewProductos_Marcas($linea){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT distinct invproducts.marca as id, IFNULL(invproducts.marca, 'SIN MARCA') as text FROM invproducts WHERE invproducts.idcatalogo=$linea ORDER BY text ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewFicha(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = 'fab_ficha'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewIDproveedor($pro){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT idcps FROM invpromulti WHERE idrec = $pro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getviewProductos($id,$estado, $fieldsExists = false){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit','2048M');

                $fieldsExists = false;
                $fieldsArray = ['pro_color', 'pro_formato', 'pro_uso', 'pro_borde', 'pro_pasta', 'pro_acabado', 'pro_caras', 'pro_espesor', 'pro_aspecto', 'pro_talla', 'pro_m2caja', 'pro_m2peso', 'pro_cajapeso', 'pro_pei', 'pro_formageo'];
                foreach($fieldsArray as $field){
                    if($this->verifyIfFieldExists($field, 'invproducts') == true){
                        $fieldsExists = true;
                    }else{
                        $fieldsExists = false;
                        break;
                    }
                }

                if($id!=0){
                    $cant = substr_count($id, '_');
                    if($cant==0){
                        if($fieldsExists == true){
                            $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit,
                            invproducts.pro_color as color, invproducts.pro_formato as formato, invproducts.pro_uso as uso, invproducts.pro_borde as borde, invproducts.pro_pasta as pasta, invproducts.pro_acabado as acabado, invproducts.pro_caras as caras, invproducts.pro_espesor as espesor, invproducts.pro_aspecto as aspecto, invproducts.pro_talla as talla, invproducts.pro_m2caja as 'm² x Caja', invproducts.pro_m2peso as 'Peso x m²', invproducts.pro_cajapeso as 'Peso x Caja', invproducts.pro_pei as PEI, invproducts.pro_formageo as 'Forma Geométrica', invproducts.nosujeta
                            FROM invproducts 
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                            INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo 
                            LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi 
                            LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser

                            WHERE invproducts.idcatalogo = $id AND invproducts.estado = $estado 
                            ORDER BY invproducts.idproducto ASC";
                        }else{
                            $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit, invproducts.nosujeta
                            FROM invproducts 
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                            INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo 
                            LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi 
                            LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser

                            WHERE invproducts.idcatalogo = $id AND invproducts.estado = $estado 
                            ORDER BY invproducts.idproducto ASC";
                        }
                    }else{
                        $array = explode("_", $id);
                        $idtipo = $array[1];
                        if($fieldsExists == true){
                            $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit,
                            invproducts.pro_color as color, invproducts.pro_formato as formato, invproducts.pro_uso as uso, invproducts.pro_borde as borde, invproducts.pro_pasta as pasta, invproducts.pro_acabado as acabado, invproducts.pro_caras as caras, invproducts.pro_espesor as espesor, invproducts.pro_aspecto as aspecto, invproducts.pro_talla as talla, invproducts.pro_m2caja as 'm² x Caja', invproducts.pro_m2peso as 'Peso x m²', invproducts.pro_cajapeso as 'Peso x Caja', invproducts.pro_pei as PEI, invproducts.pro_formageo as 'Forma Geométrica', invproducts.nosujeta
                            FROM invproducts
                            INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                            INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo
                            LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi
                            LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser
                            WHERE  invcatalog.tipo = $idtipo AND invproducts.estado = $estado
                            ORDER BY invproducts.idproducto ASC";
                        }else{
                            $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit, invproducts.nosujeta FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser WHERE  invcatalog.tipo = $idtipo AND invproducts.estado = $estado ORDER BY invproducts.idproducto ASC";
                        }
                    }
                }else{
                    if($fieldsExists == true){
                        $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit,
                        invproducts.pro_color as color, invproducts.pro_formato as formato, invproducts.pro_uso as uso, invproducts.pro_borde as borde, invproducts.pro_pasta as pasta, invproducts.pro_acabado as acabado, invproducts.pro_caras as caras, invproducts.pro_espesor as espesor, invproducts.pro_aspecto as aspecto, invproducts.pro_talla as talla, invproducts.pro_m2caja as 'm² x Caja', invproducts.pro_m2peso as 'Peso x m²', invproducts.pro_cajapeso as 'Peso x Caja', invproducts.pro_pei as PEI, invproducts.pro_formageo as 'Forma Geométrica', invproducts.nosujeta
                        FROM invproducts
                        INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo
                        LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi
                        LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser
                        ORDER BY invproducts.idproducto ASC";
                    }else{
                        $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.tipo, invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, b.descrip AS departamento, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit, invproducts.nosujeta FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog b ON invcatalog.idnivel1 = b.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser ORDER BY invproducts.idproducto ASC";
                    }
                }

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }
        function getviewProductosGastos($id,$estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($id!=0){
                    $cant = substr_count($id, '_');
                    if($cant==0){
                        $consulta = 
                        "SELECT invproducts.idproducto AS id, invproducts.descrip AS descrip, ctcuenta.descrip AS cuenta, IFNULL(ctauxi.descrip, 'SIN AUXILIAR') AS auxiliar, invcatalog.descrip AS linea, invproducts.um AS um, invproducts.notas AS notas, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit  
                        FROM invproducts 
                        INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                        INNER JOIN ctcuenta ON ctcuenta.idctcuenta  = invproducts.xpos
                        LEFT JOIN ctauxi ON ctauxi.idauxi  = invproducts.idprovee
                        LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser
                        WHERE invproducts.idcatalogo = $id AND invproducts.estado = $estado AND invproducts.tipo = 9
                        ORDER BY invproducts.idproducto ASC";
                    }else{
                        $array = explode("_", $id);
                        $idtipo = $array[1];
                        $consulta = 
                        "SELECT invproducts.idproducto AS id, invproducts.descrip AS descrip, ctcuenta.descrip AS cuenta, IFNULL(ctauxi.descrip, 'SIN AUXILIAR') AS auxiliar, invcatalog.descrip AS linea, invproducts.um AS um, invproducts.notas AS notas, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit 
                        FROM invproducts 
                        INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                        INNER JOIN ctcuenta ON ctcuenta.idctcuenta  = invproducts.xpos
                        LEFT JOIN ctauxi ON ctauxi.idauxi  = invproducts.idprovee
                        LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser
                        WHERE  invcatalog.tipo = $idtipo AND invproducts.estado = $estado  AND invproducts.tipo = 9
                        ORDER BY invproducts.idproducto ASC";
                    }
                }else{
                    $consulta = "SELECT invcatalog.gvars AS gconfig, IFNULL(ctauxi.descrip, 'SIN PROVEEDOR') AS proveedor, invproducts.idproducto AS id , invproducts.descrip AS producto , invproducts.imagen, invproducts.presenta, invcatalog.descrip AS linea, invproducts.modelo, invproducts.marca, invproducts.xpos AS xpos, invproducts.um AS um,invproducts.barcode, invproducts.precioventa AS precioventa, invproducts.costounitario, invcatalog.idcatalogo, invproducts.ingresa, invproducts.modifica, whodidit.descrip as whodidit  FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi LEFT JOIN gusers whodidit ON invproducts.whodidit = whodidit.iduser
                    ORDER BY invproducts.idproducto ASC";
                }

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------------------------ MANTENIMIENTO PRODUCTOS --------------------- J ---------------------------------------------------------------------------------------------------------------------------
        #   GET DATA
        public function getData($tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                switch ($tipo) {
                    #   UM - MEDIDA
                    case 0:
                        $this->db_b->select("um");
                        $this->db_b->from("invproducts");
                        $this->db_b->group_by("um");
                        $this->db_b->order_by("um", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #   TIPO TAX
                    case 1:
                        $this->db_b->select("valor_num, descripcion");
                        $this->db_b->from("gvars");
                        $this->db_b->where("nombre", 'gv_tipotax');
                        $this->db_b->order_by("descripcion", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #   MARCA
                    case 2:
                        $this->db_b->select("marca");
                        $this->db_b->from("invproducts");
                        $this->db_b->group_by("marca");
                        $this->db_b->order_by("marca", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #   PRESENTA
                    case 3:
                        $this->db_b->select("presenta");
                        $this->db_b->from("invproducts");
                        $this->db_b->group_by("presenta");
                        $this->db_b->order_by("presenta", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #   PROVEEDORES
                    case 4:
                        $this->db_b->select("idauxi, descrip");
                        $this->db_b->from("ctauxi");
                        $this->db_b->where("idauxidef", 1);
                        $this->db_b->where("estado", 1);
                        $this->db_b->order_by("descrip", "ASC");
                        $data = $this->db_b->get();
                    break;
                    #   GASTOS
                    case 9:
                        $this->db_b->select("idauxi, descrip");
                        $this->db_b->from("ctauxi");
                        $this->db_b->where("idauxidef", 1);
                        $this->db_b->where("estado", 1);
                        $this->db_b->order_by("descrip", "ASC");
                        $data = $this->db_b->get();
                    break;
                    default:
                        $data = false;
                    break;
                }
                return $data;
            }
        }
        public function getDataUM($tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->db_b->select("um");
                $this->db_b->from("invproducts");
                $this->db_b->where("tipo", $tipo);
                $this->db_b->group_by("um");
                $this->db_b->order_by("um", "ASC");
                $data = $this->db_b->get()->result_array();
                return $data;
            }
        }
        #   CONT IMAGENES PRODUCTO
        public function getContImage($tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->db_b->select("*");
                $this->db_b->from("invproducts");
                $this->db_b->where("tipo", $tipo);
                $this->db_b->order_by("idproducto", "ASC");
                $data = $this->db_b->get();
                /*if ($data->num_rows() > 0) $dato = ($data->last_row()->idproducto + 1);
                else $dato = 1;//*/
                $dato = ($data->num_rows() > 0) ? ($data->last_row()->idproducto + 1) : 1;
                return $dato;
            }
        }
        #   VALIDAR NOMBRE IMAGEN PRODUCTO
        public function validateNameImage($nombre, $tipo)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invproducts");
                $this->db_b->where("tipo", $tipo);
                $this->db_b->where("imagen", $nombre);
                $data = $this->db_b->get();
                /*if ($data->num_rows() > 0) $dato = false;
                else $dato = true;//*/
                $dato = ($data->num_rows() > 0) ? false : true;
                return $dato;
            }
        }
        #   VER SI UNA LINEA ESTA ACTIVA
        public function LineaActiva($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $linea = $this->db_b->where("idcatalogo", $ID)->get("invcatalog")->row();
                return ($linea->estado == 1) ? true : false;
            }
        }
        #   VERIFICAR SI HAY INVENTARIO
        public function existeInventario($IDP)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("SUM(cantidad * uniconv) AS cantidad");
                $this->db_b->from("tran_100k");
                $this->db_b->where("idproducto", $IDP);
                $dato = $this->db_b->get()->row();
                return ($dato->cantidad > 0) ? true : false;
            }
        }
        #   VERIFICAR SI FUE FACTURADO
        public function validateFacturacion($IDP)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("idproducto");
                $this->db_b->from("tran_100k");
                $this->db_b->where("idproducto", $IDP);
                $dato = $this->db_b->get()->num_rows();
                return ($dato > 0) ? true : false;
            }
        }
        #   SET PRODUCTO
        public function setProducto($data)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->db_b->insert('invproducts', $data)) return true;
                else return false;
            }
        }

        public function adicionarMultiplesGastos($datos)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                foreach($datos['auxiliares'] as $auxi){
                    $this->db_b->set('idcatalogo', $datos['idcatalogo']);
                    $this->db_b->set('descrip', $auxi['descrip']);
                    $this->db_b->set('xpos', $datos['idcuenta']);
                    $this->db_b->set('idprovee', $auxi['idauxi']);
                    $this->db_b->set('tipotax', $datos['tipotax']);
                    $this->db_b->set('um', $datos['um']);
                    $this->db_b->set('tipo',$datos['tipo']);

                    $this->db_b->set('estado', 1);
                    $this->db_b->set('whodidit', $datos['whodidit']);
                    $this->db_b->set('ingresa', $datos['ingresa']);
                    $query = $this->db_b->insert('invproducts');

                }
            }

            return true;
        }

        #   GET REGISTRO
        public function getProducto($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->get("invproducts")->row();
        }
        #   UPDATE PRODUCTO
        public function updateProductoL($data, $ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idproducto', $ID);
                if ($this->db_b->update('invproducts', $data)) return true;
                else return false;
            }
        }
        #   DELETE PRODUCTO
        public function deleteProductoL($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idproducto', $ID);
                $this->db_b->delete('invproducts');
            }
        }
        #------------------------------------------------------------------------------------ FIN MANTENIMIENTO PRODUCTOS -----------------------------------------------------------------------------------------------------------------------------------------------
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        //------------------------------------------------------------------------  IMPORTAR PRODUCTOS ----------------------------------------------------------------------------------
        #   GET ESTRUCTURA TABLA
        public function getsheets()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else return $this->db_b->field_data($this->TIProductos);
        }
        #   HAY REGISTROS PRODUCTOS
        public function hasDataProductos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $cantidad = $this->db_b->get($this->TIProductos)->num_rows();
                return ($cantidad > 0) ? true : false;
            }
        }
        #   EXISTE PRODUCTO ID
        public function existeProductoID($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                /*$this->db_b->where('idproducto', 746);
                $this->db_b->delete('productos');//*/

                $dato = $this->db_b->where("idproducto", $ID)->get($this->TIProductos)->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
         #   EXISTE PRODUCTO DESCRIP
         public function existeProductoDescrip($ID)
         {
             if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                 redirect('CerrarSesion');
             } else {
                 $dato = $this->db_b->where("descrip", $ID)->get($this->TIProductos)->row();
                 return (count((array)$dato) > 0) ? $dato : false;
             }
         }
        #   EXISTE PRODUCTO MODELO
        public function existeProductoModelo($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("modelo", $ID)->get($this->TIProductos)->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
        #   EXISTE PRODUCTO XPOS
        public function existeProductoXpos($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("xpos", $ID)->get($this->TIProductos)->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
        #   EXISTE PRODUCTO BARCODE
        public function existeProductoBarcode($Barcode)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                if ($this->db_b->where('descrip', $Barcode)->where('idgvar', 2)->get($this->TIMProductos)->num_rows() > 0) return true;
                else {
                    if ($this->db_b->where('barcode', $Barcode)->get($this->TIProductos)->num_rows() > 0) return true;
                    else return false;
                }
            }
        }
        #   EXISTE PROVEEDOR
        public function existeProveedorID($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("idauxidef", 1)->where("idauxi", $ID)->get("ctauxi")->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
        #   EXISTE LINEA
        public function existeLineaID($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("nivel", 2)->where("idcatalogo", $ID)->get("invcatalog")->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
        #   EXISTE TIPO DE PRODUCTO
        public function existeTProducto($IDTipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("nombre", 'gv_protipo')->where("valor_num", $IDTipo)->get("gvars")->row();
                return ((array)count($dato) > 0) ? $dato : false;
            }
        }
        #   EXISTE TIPO TAX (IMPUESTO)
        public function existeTTax($IDTTax)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where("nombre", 'gv_tipotax')->where("valor_num", $IDTTax)->get("gvars")->row();
                return (count((array)$dato) > 0) ? $dato : false;
            }
        }
        #   SI YA EXISTE MULTI PRECIO
        public function getMultiPrecio($ID, $Descrip)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->where("descrip", $Descrip)->where("idgvar", 1)->get($this->TIMProductos)->row();
        }
        #   SET IMPORT LLAVE PRODUCTO
        public function setIProducto($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                //if ($this->db_b->insert('invproducts', $data)) return $this->db_b->insert_id();
                if ($this->db_b->insert($this->TIProductos, $data)) return $this->db_b->insert_id();
                else return false;//*/
            }
        }
        #   UPDATE IMPORT LLAVE PRODUCTO
        public function updateIProducto($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idproducto', $ID);
                if ($this->db_b->update($this->TIProductos, $data)) return true;
                else return false;//*/
                //return true;
            }
        }
        #   SET OPCION MULTI
        public function setOpcionMultiIP($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                if ($this->db_b->insert($this->TIMProductos, $data)) return true;
                else return false;
            }
        }
        #   ESTA CREADO MULTI PRECIO ?
        public function conteoMultiPrecio($ID, $Descrip)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->where("descrip", $Descrip)->where('idgvar', 1)->get($this->TIMProductos)->num_rows();
        }
        #   UPDATE MULTI
        public function updateOpcionMultiIP($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idrec', $ID);
                if ($this->db_b->update($this->TIMProductos, $data)) return true;
                else return false;
            }
        }
        //------------------------------------------------------------------------  FIN IMPORTAR PRODUCTOS ------------------------------------------------------------------------------
        #------------------------------------------------------------------------------------ CONFIGURACION DE OPERACIONES --------------------- J ----------------------------------------------------------------------------------------------------------------------
        #   GET GVARS
        public function getOpciones($valores, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idrnum, descripcion, valor_num, valor_memo");
                $this->db_b->from("gvars");
                $this->db_b->where('nombre', 'prod_multi');
                $this->db_b->order_by("valor_num", "ASC");
                $datos = $this->db_b->get();
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        foreach (explode(",", $valores) as $valorID) {
                            if ($valorID == $dato->idrnum) {
                                $Datos[] = array(
                                    'ID' => $dato->idrnum,
                                    'Name' => $dato->descripcion,
                                    'cantidad' => $this->getCountMulti($ID, $dato->valor_num),
                                    'valor' => (int)$dato->valor_num,
                                    'valom' => $dato->valor_memo,
                                    'icon' => array_search($dato->valor_num, $this->iconosMenu),
                                    'class' => ''
                                );
                            }
                        }
                    }
                }
                return $Datos;
            }
        }
        public function getCountMulti($ID, $valor)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->where('idgvar', $valor)->get("invpromulti")->num_rows();
        }
        #   GET REGISTROS
        public function getRegistrosMulti($ID, $valor)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if ($valor == 99) {
                    $infoPro = $this->db_b->where("idproducto", $ID)->get("invproducts")->row();
                    $nGrupo  = $infoPro->marca.'-'.$infoPro->presenta;
                }

                $this->db_b->select("idrec, idproducto, idgvar, descrip, idcps, precioventa, uniconv, askpwd, lowrange, highrange, profecini, profecfin, estatus, imagen, notas, ingresa");
                $this->db_b->from("invpromulti");
                if ($valor != 99) {
                    $this->db_b->where('idproducto', $ID);
                    $this->db_b->where('idgvar', $valor);
                } else {
                    $this->db_b->where('idgvar', $valor);
                    $this->db_b->where('grupo', $nGrupo);
                }
                $this->db_b->order_by("descrip", "ASC");
                $datos = $this->db_b->get();
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => $dato->idrec,
                            'descripcion' => $dato->descrip,
                            'IDvalor' => (int)$dato->idgvar,
                            'IDCliente' => $dato->idcps,
                            'precio' => number_format($dato->precioventa, 4, '.', ''),
                            'unidad' => $dato->uniconv,
                            'min' => $dato->lowrange,
                            'max' => $dato->highrange,
                            'fechai' => $dato->profecini,
                            'fechaf' => $dato->profecfin,
                            'estatus' => ($dato->estatus == 1) ? true : false,
                            'askpwd' => ($dato->askpwd == 1) ? true : false,
                            'estadoTx' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                            'imagen' => $dato->imagen,
                            'notas' => $dato->notas,
                            'fecha' => date_format(date_create($dato->ingresa), "d/m/Y"),
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET REGISTROS - GO Barras
        public function getRegistrosMultiGoB($ID, $valor)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idrec, idproducto, idgvar, descrip, idcps, precioventa, uniconv, lowrange, highrange, profecini, profecfin, estatus, imagen, notas, ingresa");
                $this->db_b->from("invpromulti");
                $this->db_b->where('idproducto', $ID);
                $this->db_b->where('idgvar', $valor);
                $this->db_b->where('estatus', 1);
                $this->db_b->order_by("descrip", "ASC");
                $datos = $this->db_b->get();
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => $dato->idrec,
                            'descripcion' => $dato->descrip,
                            'IDvalor' => (int)$dato->idgvar,
                            'IDCliente' => $dato->idcps,
                            'precio' => $dato->precioventa,
                            'unidad' => $dato->uniconv,
                            'min' => $dato->lowrange,
                            'max' => $dato->highrange,
                            'fechai' => $dato->profecini,
                            'fechaf' => $dato->profecfin,
                            'estatus' => ($dato->estatus == 1) ? true : false,
                            'estadoTx' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo',
                            'imagen' => $dato->imagen,
                            'notas' => $dato->notas,
                            'fecha' => date_format(date_create($dato->ingresa), "d/m/Y"),
                        );
                    }
                }
                return $Datos;
            }
        }//*/
        public function getAuxiliaresMulti($auxi)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("idauxi, descrip");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", $auxi);
                $this->db_b->where("estado", 1);
                $this->db_b->order_by("descrip", "ASC");
                $datos = $this->db_b->get();
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => $dato->idauxi,
                            'Name' => $dato->descrip
                        );
                    }
                }
                return $Datos;
            }   
        }

        public function getProductosGrupo($idproducto)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $inPro = $this->db_b->select("marca, presenta")->where("idproducto", $idproducto)->get("invproducts")->row();
                
                $this->db_b->select("idproducto, descrip, um, precioventa, presenta, marca");
                $this->db_b->from("invproducts");
                $this->db_b->where("presenta", $inPro->presenta);
                $this->db_b->where("marca", $inPro->marca);
                $this->db_b->order_by("descrip", "ASC");
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return $data = [];
            }   
        }

        #   SET MULTI
        public function setOpcionMulti($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                if ($this->db_b->insert('invpromulti', $data)) return true;
                else return false;
            }
        }
        public function getContOpcionMulti($ID, $valor) 
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where('idproducto', $ID)->where("idgvar", $valor)->get('invpromulti')->num_rows();
        }
        #   VALIDATE BARCODE
        public function validateBarcode($codigo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                //echo $this->db_b->where('descrip', $codigo)->get('invpromulti')->num_rows();
                //echo "-".$this->db_b->where('barcode', $codigo)->get('invproducts')->num_rows();
                //die();
                if ($this->db_b->where('descrip', $codigo)->where('idgvar', 2)->get('invpromulti')->num_rows() > 0) return false;
                else {
                    if ($this->db_b->where('barcode', $codigo)->get('invproducts')->num_rows() > 0) return false;
                    else return true;
                }
            }
        }
        #   UPDATE MULTI
        public function updateOpcionMulti($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idrec', $ID);
                if ($this->db_b->update('invpromulti', $data)) return true;
                else return false;
            }
        }
        #   DELETE MULTI
        public function deleteOpcionMulti($IDV)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idrec', $IDV);
                $this->db_b->delete('invpromulti');
                return true;
            }
        }
        public function getRegistroMultiIDV($IDV)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idrec", $IDV)->get("invpromulti")->row();
        }
        #   IMPORTAR MULTIPLES PRECIOS
        public function getProductoTPMulti($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where('idproducto', $ID)->where('tipo', 1)->get('invproducts')->row();
        }
        public function getRegistroMultiIDDescrip($ID, $Descrip)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->where("descrip", $Descrip)->where("idgvar", 1)->get("invpromulti")->row();
        }
        public function getCountMultiDesIMP($ID, $Descrip)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idproducto", $ID)->where("descrip", $Descrip)->where('idgvar', 1)->get("invpromulti")->num_rows();
        }
        #   IMPORTAR DESCUENTOS ARTICULO
        #   IMPORTAR AD VALOREM
        public function updateIPDescuentos($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idproducto', $ID);
                if ($this->db_b->update('invproducts', $data)) return true;
                else return false;
            }
        }
        #   IMPORTAR DESCUENTOS MARCA
        public function getIPDMarca()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("marca, count(*) as cantidad, descuento");
                $this->db_b->from("invproducts");
                $this->db_b->where('tipo', 1);
                //$this->db_b->where('marca = BINARY "Epson"');
                //$this->db_b->group_by('marca, CAST(marca as BINARY)');
                $this->db_b->group_by('marca');
                $this->db_b->order_by("marca", "ASC");
                $datos = $this->db_b->get();
                return $datos;
            }
        }
        public function updateIPDMarca($marca, $data) 
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('marca', $marca);
                if ($this->db_b->update('invproducts', $data)) return true;
                else return false;
            }
        }
        #   IMPORTAR MULTIPLES CODIGOS DE BARRAS
        public function getProductobyBarcode($barcode)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $dato = $this->db_b->where('barcode', $barcode)->get('invproducts')->row();
                if (count((array)$dato) > 0) return $dato;
                else {
                    $dato = $this->db_b->where('descrip', $barcode)->where('idgvar', 2)->get('invpromulti')->row();
                    $dato = $this->db_b->where('idproducto', $dato->idproducto)->get('invproducts')->row();
                    return $dato;
                }
                
            }
        }
        #------------------------------------------------------------------------------------ FIN CONFIGURACIONN DE OPERACIONES -----------------------------------------------------------------------------------------------------------------------------------------
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        
        function viewDepartamentos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.descrip AS departamento, invcatalog.idcatalogo, invcatalog.tipo FROM invcatalog WHERE nivel = 1 ORDER BY invcatalog.descrip asc";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewDepartamentosTipo($tipo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.descrip AS departamento, invcatalog.idcatalogo FROM invcatalog WHERE nivel = 1 AND tipo = $tipo ORDER BY invcatalog.descrip asc";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewsubDepartamentos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.descrip AS subdepartamento, invcatalog.idcatalogo, invcatalog.idnivel1 FROM invcatalog WHERE nivel = 2 ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewsubDepartamentosTipo($tipo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.descrip AS subdepartamento, invcatalog.idcatalogo, invcatalog.idnivel1, invcatalog.multiaux FROM invcatalog  WHERE nivel = 2 AND  tipo = $tipo ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewDepartamentos_products(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS departamento, IFNULL(count(invproducts.idproducto),0) as cant FROM invcatalog LEFT JOIN invproducts ON invproducts.tipo= invcatalog.idcatalogo WHERE nivel = 1 GROUP BY invcatalog.idcatalogo ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewLineas(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invcatalog.idcatalogo, (SELECT interna.descrip from invcatalog as interna where interna.idcatalogo=invcatalog.idnivel1) as padre, invcatalog.descrip AS subdepartamento, invcatalog.idnivel1 FROM invcatalog  WHERE invcatalog.nivel = 2 ORDER BY subdepartamento ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewGvar(){
            $consulta = "SELECT gvars FROM ctauxidef WHERE idauxidef = 1";
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            $array = explode(",", $resultado['gvars']);
            $cant = count($array);
            return $cant;
        }
        
        function viewCat(){
            $consulta = "SELECT idcatalogo, descrip FROM invcatalog WHERE nivel = 1 ORDER BY descrip";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $resultado = $query->result();
                return $resultado;    
            }else{
                return false;     
            }
        }
        
        function viewSubcat(){
            $consulta = "SELECT C.idcatalogo, C.descrip, C.idnivel1, (SELECT COUNT(*) FROM invproducts P WHERE P.idcatalogo = C.idcatalogo GROUP BY idcatalogo) AS Total, C.estado FROM invcatalog C WHERE C.nivel = 2 ORDER BY C.descrip";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function viewDatsub($id){
            $consulta = "SELECT t1.idcatalogo, t1.descrip, t1.estado, t2.descrip AS padre FROM invcatalog as t1 INNER JOIN invcatalog as t2 ON t1.idnivel1 = t2.idcatalogo WHERE t1.idcatalogo = $id";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            
            $dat = $query->row_array();
            
            if($dat['estado'] == 0){
                $est_sub = array(
                                'linea' => $dat['descrip'],
                                'sub_est' => 0
                            );
                
                $this->session->set_userdata($est_sub);
            }
            
            return $resultado;
        }
        
        function viewArray($id){
            $consulta = "SELECT gvars FROM invcatalog WHERE idcatalogo = $id";
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            $array = explode(",", $resultado['gvars']);
            return $array;
        }
        
        function viewGvarDef(){
            $consulta = "SELECT idrnum, nombre, descripcion, valor_num, valor_memo FROM gvars WHERE filtro = 'invpromulti'";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function insertProducto($descrip, $modelo, $marca, $barcode, $idcatalog, $idprovee, $idprov, $preUn, $preVe, $tipo, $tipTax, $estado, $xpos, $notas, $option, $whodidit, $img, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran){
           
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                
                $consulta = "SELECT estado FROM invcatalog WHERE idcatalogo = $idcatalog";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                if($resultado['estado'] == 1){
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");

                    $this->db_b->set('idproducto', 0);
                    $this->db_b->set('descrip', $descrip);
                    $this->db_b->set('modelo', $modelo);
                    $this->db_b->set('marca', $marca);
                    $this->db_b->set('barcode', $barcode);
                    $this->db_b->set('idcatalogo', $idcatalog);
                    $this->db_b->set('idprovee', $idprovee);
                    $this->db_b->set('costounitario', $preUn);
                    $this->db_b->set('precioventa', $preVe);
                    $this->db_b->set('tipo', $tipo);
                    $this->db_b->set('tipotax', $tipTax);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('xpos', $xpos);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('imagen', $img);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('upp', $upp);
                    $this->db_b->set('presenta', $presenta);
                    $this->db_b->set('coarancel', $tasaaran);
                    $this->db_b->set('copartida', $numaran);
                    $this->db_b->set('codescrip', $codescrip);
                    $this->db_b->set('comision', $comision);
                    $this->db_b->set('descuento', $descuento);
                    $this->db_b->set('whodidit', $whodidit);
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('invproducts');

                    if($option == '1'){
                        redirect('Adicionar_Productos/'.$idcatalog);
                        $producto_data = array(
                                'descrip_pro' => "",
                                'modelo' => "",
                                'marca' => "",
                                'barcode' => "",
                                'costounitario' => "",
                                'precioventa' => "",
                                'xpos' => "",
                                'tipo' => "",
                                'tipotax' => "",
                                'notas' => "",
                                'opt' => "0",
                                'um' => "",
                                'upp' => "",
                                'presenta' => "",
                                'tasaaran' => "",
                                'numaran' => "",
                                'codescrip' => "",
                                'comision' => "",
                                'descuento' => ""
                            );
                        $this->session->set_userdata($producto_data);
                    }else if($option == '2'){
                        $producto_data = array(
                                'descrip_pro' => $descrip,
                                'modelo' => $modelo,
                                'marca' => $marca,
                                'barcode' => $barcode,
                                'costounitario' => $preUn,
                                'precioventa' => $preVe,
                                'xpos' => $xpos,
                                'tipo' => $tipo,
                                'tipotax' => $tipTax,
                                'notas' => $notas,
                                'opt' => "1",
                                'um' => $um,
                                'upp' => $upp,
                                'presenta' => $presenta,
                                'tasaaran' => $tasaaran,
                                'numaran' => $numaran,
                                'codescrip' => $codescrip,
                                'comision' => $comision,
                                'descuento' => $descuento
                            );
                        $this->session->set_userdata($producto_data);
                        redirect('producto/newProducto/'.$idcatalog);
                    }else{
                        $producto_data = array(
                                'descrip_pro' => "",
                                'modelo' => "",
                                'marca' => "",
                                'barcode' => "",
                                'costounitario' => "",
                                'precioventa' => "",
                                'xpos' => "",
                                'tipo' => "",
                                'tipotax' => "",
                                'notas' => "",
                                'opt' => "0",
                                'um' => "",
                                'upp' => "",
                                'presenta' => "",
                                'tasaaran' => "",
                                'numaran' => "",
                                'codescrip' => "",
                                'comision' => "",
                                'descuento' => ""
                            );
                        $this->session->set_userdata($producto_data);
                        redirect('Productos/'.$idcatalog);
                    }         
                }else{
                    
                    $producto_data = array(
                                'opt' => "2"
                            );
                        $this->session->set_userdata($producto_data);
                        redirect('Adicionar_Productos/'.$idcatalog);
                }
                   
           }
        }
        
        function insertProducto2($descrip, $modelo, $marca, $barcode, $idcatalog, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $xpos, $notas, $whodidit, $img, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran){
           
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                
                $consulta = "SELECT estado FROM invcatalog WHERE idcatalogo = $idcatalog";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                if($resultado['estado'] == 1){
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");

                    $this->db_b->set('idproducto', 0);
                    $this->db_b->set('descrip', $descrip);
                    $this->db_b->set('modelo', $modelo);
                    $this->db_b->set('marca', $marca);
                    $this->db_b->set('barcode', $barcode);
                    $this->db_b->set('idcatalogo', $idcatalog);
                    $this->db_b->set('idprovee', $idprovee);
                    $this->db_b->set('costounitario', $preUn);
                    $this->db_b->set('precioventa', $preVe);
                    $this->db_b->set('tipo', $tipo);
                    $this->db_b->set('tipotax', $tipTax);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('xpos', $xpos);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('upp', $upp);
                    $this->db_b->set('presenta', $presenta);
                    $this->db_b->set('coarancel', $tasaaran);
                    $this->db_b->set('copartida', $numaran);
                    $this->db_b->set('codescrip', $codescrip);
                    $this->db_b->set('comision', $comision);
                    $this->db_b->set('descuento', $descuento);
                    $this->db_b->set('whodidit', $whodidit);
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('invproducts');
                 
                    if($img == "" || $img == null){
                       redirect('Productos/'.$this->session->userdata('iddApp'));
                    }else{
                        $idproducto = $this->db_b->insert_id();
                        $imgSplit = explode(".", $img);
                        $nameImg = "imgProduct_".$idproducto.".".$imgSplit[1];
                        $this->db_b->set('imagen', $nameImg);
                        $this->db_b->where('idproducto', $idproducto);
                        $this->db_b->update('invproducts');
                        return $nameImg;
                    }
                }
           }
        }
        
        function insertUnidad($idproducto,$idgvar,$unidadcon,$unidadconver,$estadoun,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $unidadcon);
                $this->db_b->set('uniconv', $unidadconver);
                $this->db_b->set('estatus', $estadoun);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function updateUnidad($idrec,$idproducto,$idgvar,$unidadcon,$unidadconver,$estadoun,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $unidadcon);
                $this->db_b->set('uniconv', $unidadconver);
                $this->db_b->set('estatus', $estadoun);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function insertBarra($idproducto,$idgvar,$barcodeb,$estadob,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $barcodeb);
                $this->db_b->set('estatus', $estadob);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function updateBarra($idproducto,$idgvar,$barcodeb,$estadob,$whodidit, $id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $barcodeb);
                $this->db_b->set('estatus', $estadob);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $id);
                $query = $this->db_b->update('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function insertProveedor($idproductopro,$idgvarpro,$proveedoral,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $consulta = "SELECT descrip FROM ctauxi WHERE idauxi = $proveedoral";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproductopro);
                $this->db_b->set('idgvar', $idgvarpro);
                $this->db_b->set('descrip', $resultado['descrip']);
                $this->db_b->set('idcps', $proveedoral);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function updateProveedor($idproductoprou,$idgvarprou,$proveedoru,$whodidit, $idpro){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $consulta = "SELECT descrip FROM ctauxi WHERE idauxi = $proveedoru";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                
                $this->db_b->set('idproducto', $idproductoprou);
                $this->db_b->set('idgvar', $idgvarprou);
                $this->db_b->set('descrip', $resultado['descrip']);
                $this->db_b->set('idcps', $proveedoru);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idpro);
                $query = $this->db_b->update('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
       
        function insertPrecio($idgvar, $idproducto, $descrip, $precio, $uc,$pass,$notas,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                 
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('askpwd', $pass);
                $this->db_b->set('precioventa', $precio);
                $this->db_b->set('uniconv', $uc);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                return  $this->db_b->insert_id();
            }
        }
        
        function updateImgPrecio($idproductoprou,$img,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('imagen', $img);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idproductoprou);
                $query = $this->db_b->update('invpromulti');
            }
        }
			
		function insertPrecioPromocion($idproducto, $idgvar, $fechaini, $fechafin, $precio, $estado){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
				if($estado == "true"){
					$estado = 1;
				}else{
					$estado = 0;
				}
				
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', 'Promocion '.$precio);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('profecini', $fechaini);
                $this->db_b->set('profecfin', $fechafin);
                $this->db_b->set('precioventa', $precio);
				$this->db_b->set('estatus', $estado);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                
				return $query;                
            }
        }
		
		function updatePrecioPromocion($idpreciopromo, $idproducto, $fechaini, $fechafin, $precio, $estado){
			if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
				if($estado == "true"){
					$estado = 1;
				}else{
					$estado = 0;
				}
				
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', 'Promocion '.$precio);
				$this->db_b->set('profecini', $fechaini);
                $this->db_b->set('profecfin', $fechafin);
                $this->db_b->set('precioventa', $precio);
				$this->db_b->set('estatus', $estado);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idpreciopromo);
                $query = $this->db_b->update('invpromulti');
                
				return $query;                
            }
		}
        
        function updatePrecio($id,$idgvar,$idproducto,$descrip,$precio,$uc,$pass,$notas,$estado,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                 
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('askpwd', $pass);
                $this->db_b->set('precioventa', $precio);
                $this->db_b->set('uniconv', $uc);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $id);
                $query = $this->db_b->update('invpromulti');
            }
        }
        
        function insertImagen($idproducto,$idgvar,$nameimagen,$nombreimagn,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $nameimagen);
                //$this->db_b->set('imagen', $nombreimagn);
                $this->db_b->set('whodidit', $whodidit );
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                return  $this->db_b->insert_id();
            }
        }
        
        function update_img($id, $nameimg){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                 
                $this->db_b->set('imagen', $nameimg);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $id);
                $query = $this->db_b->update('invpromulti');
            }
        }
        
        function updateImagen($idproducto,$idgvar,$nameimagen,$nombreimag,$whodidit,$id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
              
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $nameimagen);
                $this->db_b->set('imagen', $nombreimag);
                $this->db_b->set('whodidit', $whodidit );
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $id);
                $query = $this->db_b->update('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function updateDatos($idproducto,$idgvar,$namearchivo,$archivoguarda,$notas,$whodidit,$id){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
              
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $namearchivo);
                $this->db_b->set('imagen', $archivoguarda);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $id);
                $query = $this->db_b->update('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function insertDatos($idproducto,$idgvar,$namearchivo,$nombrearchiv,$notas,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('descrip', $namearchivo);
                $this->db_b->set('imagen', $nombrearchiv);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit );
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                
              //  redirect('producto/modificarProducto2/'.$idproducto);
                
            }
        }
        
        function updateProducto($idprod, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos, $ingresa, $whodidit, $img, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran){
            
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_update = date("Y-m-d H:i:s");

                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('modelo', $modelo);
                $this->db_b->set('marca', $marca);
                $this->db_b->set('barcode', $barcode);
                $this->db_b->set('idcatalogo', $idcatalog);
                $this->db_b->set('idprovee', $idprovee);
                $this->db_b->set('costounitario', $preUn);
                $this->db_b->set('precioventa', $preVe);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('tipotax', $tipTax);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('imagen', $img);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $ingresa);
                $this->db_b->set('modifica', $fecha_update);
                $this->db_b->set('um', $um);
                $this->db_b->set('upp', $upp);
                $this->db_b->set('presenta', $presenta);
                $this->db_b->set('coarancel', $tasaaran);
                $this->db_b->set('copartida', $numaran);
                $this->db_b->set('codescrip', $codescrip);
                $this->db_b->set('comision', $comision);
                $this->db_b->set('descuento', $descuento);
                $this->db_b->where('idproducto', $idprod);
                $query = $this->db_b->update('invproducts');

                redirect('Productos/'.$idcatalog);
            }
        }
        
        function updateProducto2($idproducto, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos,  $whodidit, $img, $imagen, $imga, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_update = date("Y-m-d H:i:s");

                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('modelo', $modelo);
                $this->db_b->set('marca', $marca);
                $this->db_b->set('barcode', $barcode);
                $this->db_b->set('idcatalogo', $idcatalog);
                $this->db_b->set('idprovee', $idprovee);
                $this->db_b->set('costounitario', $preUn);
                $this->db_b->set('precioventa', $preVe);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('tipotax', $tipTax);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('um', $um);
                $this->db_b->set('upp', $upp);
                $this->db_b->set('presenta', $presenta);
                $this->db_b->set('coarancel', $tasaaran);
                $this->db_b->set('copartida', $numaran);
                $this->db_b->set('codescrip', $codescrip);
                $this->db_b->set('comision', $comision);
                $this->db_b->set('descuento', $descuento);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_update);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');

                if($img == "" || $img == null){
                    redirect('Productos/'.$this->session->userdata('iddApp'));
                }else{
                    
                    if($imga != "" ){
                        $imgSplit = explode(".", $img);
                    
                        $nameImg = "imgProduct_".$idproducto."_".rand(0, 99999).".".$imgSplit[1];
                        $this->db_b->set('imagen', $nameImg);
                        $this->db_b->where('idproducto', $idproducto);
                        $this->db_b->update('invproducts');
                        
                        return $nameImg;
                        
                    }else{
                        $this->db_b->set('imagen', $img);
                        $this->db_b->where('idproducto', $idproducto);
                        $this->db_b->update('invproducts');
                        
                        return $img;
                    }
                }
            }
         }
        
        function deleteProducto($idprod, $idcatalog){
            
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM invproducts WHERE idproducto = $idprod";
                $query = $this->db_b->query($consulta);
                redirect('Productos/'.$idcatalog); 
            }
        }
        
        function copiarProducto($descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran){
            
            $producto_data = array(
                'descrip_pro' => $descrip,
                'modelo' => $modelo,
                'marca' => $marca,
                'barcode' => $barcode,
                'costounitario' => $preUn,
                'precioventa' => $preVe,
                'xpos' => $xpos,
                'tipo' => $tipo,
                'tipotax' => $tipTax,
                'notas' => $notas,
                'opt' => "0",
                'um' => $um,
                'upp' => $upp,
                'presenta' => $presenta,
                'tasaaran' => $tasaaran,
                'numaran' => $numaran,
                'codescrip' => $codescrip,
                'comision' => $comision,
                'descuento' => $descuento
            );
            
            $this->session->set_userdata($producto_data);
            redirect('producto/newProducto/'.$idcatalog);
            
        }
        
        function getTipoProd(){
            $consulta = "SELECT descripcion, idrnum, valor_num FROM gvars WHERE nombre = 'gv_protipo' ORDER BY valor_num";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        function getDescripTipo($tipo){
            $consulta = "SELECT descripcion FROM gvars WHERE nombre = 'gv_protipo'  AND valor_num=$tipo ORDER BY valor_num";
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            return $resultado['descripcion'];
        }
        
        function getTipoTax(){
            $consulta = "SELECT descripcion, idrnum, valor_num FROM gvars WHERE nombre = 'gv_tipotax'";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function getProvee(){
            $consulta = "SELECT idauxi AS ID , descrip AS Name FROM ctauxi WHERE idauxidef = 1 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function getCatalog(){
            $consulta = "SELECT idcatalogo, descrip FROM invcatalog";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verMarca(){
            $consulta = "SELECT DISTINCT marca AS Name FROM invproducts ORDER BY marca";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verMarcasLinea($idcatalogo){
            $consulta = "SELECT DISTINCT marca AS Name FROM invproducts WHERE idcatalogo = $idcatalogo ORDER BY marca";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verVars(){
            $consulta = "SELECT descripcion, valor_num, idrnum,(SELECT count(idrec) FROM invpromulti WHERE round(invpromulti.idgvar)=round(gvars.valor_num)) as cant FROM gvars WHERE nombre = 'prod_multi' ORDER BY valor_num";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        #-
        function verVarsPro($idproducto){
            $consulta = "SELECT descripcion,valor_memo, valor_num, idrnum,(SELECT count(idrec) FROM invpromulti WHERE round(invpromulti.idgvar)=round(gvars.valor_num) AND invpromulti.idproducto=$idproducto) as cant FROM gvars WHERE nombre = 'prod_multi' ORDER BY valor_num";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verMulti($idprod){
            $consulta = "SELECT idrec, idproducto, descrip, idgvar, precioventa, uniconv, askpwd, estatus, idcps, imagen, notas, profecini, profecfin, lowrange, highrange, gvars.descripcion as tipoMulti FROM invpromulti LEFT JOIN gvars ON gvars.valor_num = invpromulti.idgvar and gvars.nombre='prod_multi' WHERE invpromulti.idproducto = $idprod ORDER BY idrec";
            $query = $this->db_b->query($consulta);
			if($query->num_rows()>0){
                $resultado = $query->result();
                return $resultado;    
            }else{
                return false;     
            }
        }
        
        function verPresenta(){
            $consulta = "SELECT DISTINCT presenta FROM invproducts ORDER BY presenta";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verUM(){
            $consulta = "SELECT DISTINCT um FROM invproducts ORDER BY um";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function verUnidades(){
            $consulta = "SELECT DISTINCT descrip FROM invpromulti WHERE idgvar = 7 ORDER BY descrip";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
        
        function callRegistro($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT * FROM invproducts WHERE idproducto = $idprod";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function infoProduct($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.*, IFNULL(ctauxi.descrip,'') AS proveedor FROM invproducts LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee AND ctauxi.idauxidef = 1 WHERE invproducts.idproducto =$idprod";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function callLinea($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT idcatalogo FROM invproducts WHERE idproducto = $idprod";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cadena = $resultado['idcatalogo'];
                return $cadena;
            }
        }
        
        function viewPermisos($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT gvars FROM invcatalog WHERE idcatalogo = $idprod";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['gvars'];
            }
        }
        
        function getMultiProductData($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT multiaux FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cadena = $resultado['multiaux'];
                return $cadena;
            }
        }
        
        function saveMultiproductData($cadena, $idcatalogo){
              if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('multiaux', $cadena);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idcatalogo', $idcatalogo);
                $query = $this->db_b->update('invcatalog');
                
                return $query;
            }
        }
        
        function getListaCamposProductsMulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SHOW COLUMNS FROM invpromulti";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getMultiPro($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT multiaux FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cadena = $resultado['multiaux'];
                    
                if($cadena != "" || $cadena != null){
                    $array = explode(";", $cadena);
                    $tot = count($array);
                    $tot_r = $tot-1;
                    $txt = "";
                    for($i=0; $i<$tot_r; $i++){
                        $array_2 = explode("|", $array[$i]);
                        $txt .= $array_2[0].":".$array_2[1]." |";
                    }
                    $ne_array = explode(" |", $txt);
                }else{
                    $ne_array = "";
                }
                
                return $ne_array;
            }
        }
        
        function updateProductImagen($idproducto,$nombreimagen,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
              
                $this->db_b->set('imagen', $nombreimagen);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');
                return $query;
            }
        }
        
        function deleteProductImagen($idproducto,$whodidit){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $consulta ="SELECT imagen  FROM invproducts WHERE idproducto =$idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
               
                if($resultado['imagen']!=""){
                    if (file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$resultado['imagen'])) {
                        unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$resultado['imagen']);
                    }
                }
                
                $this->db_b->set('imagen', "");
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');
                return $query;
            }
        }
        
        function getProductos_Tipo($tipo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT invproducts.*, invcatalog.descrip as linea, invcatalog2.descrip AS departamento, gvars.descripcion AS tipoproducto FROM invproducts  
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                INNER JOIN gvars ON gvars.valor_num = invproducts.tipo AND gvars.nombre = 'gv_protipo' WHERE invproducts.tipo = $tipo AND invproducts.estado = 1 ORDER BY idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getProductosByEstatus($estatus){
			if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT idproducto, descrip FROM invproducts WHERE estado = $estatus ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getProductosByEstatusCatalogo(){
			if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT invproducts.idproducto, invproducts.descrip, invcatalog.descrip AS catalogo FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 ORDER BY invcatalog.descrip, invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getInfoMulti($idvar,$idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT * FROM invpromulti WHERE idgvar = $idvar AND idproducto=$idproducto ORDER BY idrec ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInfoMultiAndPrimary($idvar,$idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT idproducto, IFNULL(imagen, '') as imagen FROM invproducts WHERE idproducto=$idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                $consulta1 ="SELECT idproducto, imagen FROM invpromulti WHERE idgvar = $idvar AND idproducto=$idproducto ORDER BY idrec ASC";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->result();
                
                $final = array_merge($resultado,$resultado1);
                
                return $final;
            }
        }
        
        function insertProMulti($idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                if($fechaini==''){
                    $fechaini =  date("Y-m-d H:i:s");
                }
                
                if($fechafin==''){
                    $fechafin =  date("Y-m-d H:i:s");
                }
                
                if($descrip=='undefined' ||$descrip=="" ||$descrip==null){
                    $descrip="";
                }
                if($notas=="0"){
                    $notas="";
                }
                $this->db_b->set('idrec', 0);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('precioventa', $precioventa);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('estatus', $estatus);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('lowrange', $lowrange);
                $this->db_b->set('highrange', $highrange);
                $this->db_b->set('profecini', $fechaini);
                $this->db_b->set('profecfin', $fechafin);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');
                return  $this->db_b->insert_id();
            }
        }
       
		function insertProMulti_extras($idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                if($fechaini==''){
                    $fechaini =  date("Y-m-d H:i:s");
                }
                
                if($fechafin==''){
                    $fechafin =  date("Y-m-d H:i:s");
                }
                
                if($descrip=='undefined' ||$descrip=="" ||$descrip==null){
                    $descrip="";
                }
				
                if($notas=="0"){
                    $notas="";
                }
				
                $array = explode(",", $descrip);
				$tot = count($array);
				
				for($i=0; $i<$tot; $i++){
					$this->db_b->set('idrec', 0);
					$this->db_b->set('idproducto', $idproducto);
					$this->db_b->set('idgvar', $idgvar);
					$this->db_b->set('idcps', $idcps);
					$this->db_b->set('descrip', $array[$i]);
					$this->db_b->set('precioventa', $precioventa);
					$this->db_b->set('uniconv', $uniconv);
					$this->db_b->set('estatus', $estatus);
					$this->db_b->set('notas', $notas);
					$this->db_b->set('lowrange', $lowrange);
					$this->db_b->set('highrange', $highrange);
					$this->db_b->set('profecini', $fechaini);
					$this->db_b->set('profecfin', $fechafin);
					$this->db_b->set('whodidit', $whodidit);
					$this->db_b->set('ingresa', $fecha_actual);
					$query = $this->db_b->insert('invpromulti');
				}
				return  $this->db_b->insert_id();
            }
        }
        
        function updatePromulti($idrec,$idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                 
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', $idgvar);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('precioventa', $precioventa);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('estatus', $estatus);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('lowrange', $lowrange);
                $this->db_b->set('highrange', $highrange);
                $this->db_b->set('profecini', $fechaini);
                $this->db_b->set('profecfin', $fechafin);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('invpromulti');
            }
        }
        
        function deletePromulti($idrec){
            
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM invpromulti WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return 1;
            }
        }
        
		function verUmPromulti($idgvar){
			if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT DISTINCT(descrip) as id, descrip FROM invpromulti WHERE idgvar = $idgvar ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getInfoTile($idgvar,$idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT * FROM invpromulti WHERE idgvar = $idgvar AND idproducto=$idproducto ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosCodBarra($codigo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT idproducto, descrip,modelo,marca,barcode,idcatalogo,imagen FROM invproducts WHERE barcode='$codigo'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                $consulta1 ="SELECT invproducts.idproducto,invproducts.descrip,invproducts.modelo,invproducts.marca,invproducts.barcode,invproducts.idcatalogo,invproducts.imagen FROM invpromulti INNER JOIN invproducts ON invproducts.idproducto=invpromulti.idproducto AND idgvar=2 WHERE invpromulti.descrip='$codigo'";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->result();
                $result = array_merge($resultado, $resultado1);
                return $result;
            }
        }
        
        function getProductosCodBarraTipo($codigo, $tipo){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT idproducto, descrip,modelo,marca,barcode,idcatalogo,imagen FROM invproducts WHERE barcode='$codigo' AND invproducts.tipo=$tipo ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                $consulta1 ="SELECT invproducts.idproducto,invproducts.descrip,invproducts.modelo,invproducts.marca,invpromulti.descrip AS barcode,invproducts.idcatalogo,invproducts.imagen FROM invpromulti INNER JOIN invproducts ON invproducts.idproducto=invpromulti.idproducto AND idgvar=2 WHERE invpromulti.descrip='$codigo' AND invproducts.tipo=$tipo";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->result();
                $result = array_merge($resultado, $resultado1);
                return $result;
            }
        }
        
        function insertCopiaProduct($datasource){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                for($i=1; $i<count($datasource); $i++){
                    $idproducto =  $datasource[$i]['idproducto'];
                    $descripcion = $datasource[$i]['descripcion'];
                    $modelo = $datasource[$i]['modelo'];
                    $barcode = $datasource[$i]['barcode'];
                    $idcatalogo = $datasource[$i]['idcatalogo'];
                    $copia = $datasource[$i]['copyimage'];
                    
                    $consulta = "SELECT * FROM invproducts WHERE idproducto = $idproducto";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->row_array();

                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");   

                    $this->db_b->set('idproducto', 0);
                    $this->db_b->set('descrip', $descripcion);
                    $this->db_b->set('modelo', $modelo);
                    $this->db_b->set('marca', $resultado['marca']);
                    $this->db_b->set('barcode', $barcode);
                    $this->db_b->set('idcatalogo', $resultado['idcatalogo']);
                    $this->db_b->set('idprovee', $resultado['idprovee']);
                    $this->db_b->set('costounitario', $resultado['costounitario']);
                    $this->db_b->set('precioventa', $resultado['precioventa']);
                    $this->db_b->set('tipo', $resultado['tipo']);
                    $this->db_b->set('tipotax', $resultado['tipotax']);
                    $this->db_b->set('estado', $resultado['estado']);
                    $this->db_b->set('xpos', $resultado['xpos']);
                    $this->db_b->set('notas', $resultado['notas']);
                    $this->db_b->set('imagen', $resultado['imagen']);
                    $this->db_b->set('um', $resultado['um']);
                    $this->db_b->set('upp', $resultado['upp']);
                    $this->db_b->set('presenta', $resultado['presenta']);
                    $this->db_b->set('coarancel', $resultado['coarancel']);
                    $this->db_b->set('copartida', $resultado['copartida']);
                    $this->db_b->set('codescrip', $resultado['codescrip']);
                    $this->db_b->set('comision', $resultado['comision']);
                    $this->db_b->set('descuento', $resultado['descuento']);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('invproducts');
                    $id_nuevo_producto = $this->db_b->insert_id();
                    
                    $consulta = "SELECT * FROM invpromulti WHERE idproducto = $idproducto";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows()>0){
                        $resultado_multi = $query->result();
                        foreach($resultado_multi as $result){
                            $this->db_b->set('idrec', 0);
                            $this->db_b->set('idproducto', $id_nuevo_producto);
                            $this->db_b->set('idgvar', $result->idgvar);
                            $this->db_b->set('descrip', $result->descrip);
                            $this->db_b->set('idcps', $result->idcps);
                            $this->db_b->set('precioventa', $result->precioventa);
                            $this->db_b->set('uniconv', $result->uniconv);
                            $this->db_b->set('lowrange', $result->lowrange);
                            $this->db_b->set('highrange', $result->highrange);
                            $this->db_b->set('askpwd', $result->askpwd);
                            $this->db_b->set('profecini', $result->profecini);
                            $this->db_b->set('profecfin', $result->profecfin);
                            $this->db_b->set('estatus', $result->estatus);
                            $this->db_b->set('imagen', $result->imagen);
                            $this->db_b->set('notas', $result->notas);
                            $this->db_b->set('fecha', $result->fecha);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $fecha_actual);
                            $query = $this->db_b->insert('invpromulti');
                            $idrec_multi = $this->db_b->insert_id();
                            if($copia=="true"){
                                if($result->imagen!=""){
                                    $imgSplit_multi = explode(".", $result->imagen);
                                    $name_img = "Img_promulti_".$idrec_multi.".".$imgSplit_multi[1];
                                    copy("img_cuentas/".$this->session->userdata('diraccount')."/".$result->imagen,"img_cuentas/".$this->session->userdata('diraccount')."/".$name_img);
                                    $this->db_b->set('imagen', $name_img);
                                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                    $this->db_b->set('modifica', $fecha_actual);
                                    $this->db_b->where('idrec', $idrec_multi);
                                    $query = $this->db_b->update('invpromulti');
                                }
                            }
                        }
                    }
                    
                    if($copia=="true"){
                        if($resultado['imagen']!=""){
                            $imgSplit = explode(".", $resultado['imagen']);
                            $name_img = "imgProduct_".$id_nuevo_producto.".".$imgSplit[1];
                            copy("img_cuentas/".$this->session->userdata('diraccount')."/".$resultado['imagen'],"img_cuentas/".$this->session->userdata('diraccount')."/".$name_img);    
                            $this->db_b->set('imagen', $name_img);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('modifica', $fecha_actual);
                            $this->db_b->where('idproducto', $id_nuevo_producto);
                            $query = $this->db_b->update('invproducts');
                        }
                    }
                }
                return $idcatalogo;
            }
        }
        
        function importacionListadoDeProductos($archivoProductos){
			ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M');
            
            $whodidit = $this->session->userdata('iduser');
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");
            
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            
            $cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
            $cacheSettings = array( 'memoryCacheSize' => '2048MB');
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
            
            $objPHPExcel = PHPExcel_IOFactory::load($archivoProductos);
            $objPHPExcel->setActiveSheetIndex(0);
            $numRows = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
            
            for($i = 1; $i <= $numRows; $i++){
                if($i != 1){
					$Dep = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
					$Lin = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
					$Pro = $objPHPExcel->getActiveSheet()->getCell('O'.$i)->getCalculatedValue();
					$this->load->database();
					$this->db->reconnect();
					
					$consulta = "SELECT idcatalogo FROM invcatalog WHERE descrip LIKE '%$Dep%' AND nivel = 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->row_array();
					$total = $query->num_rows();
					
					if($total == 1){
						$this->load->database();
						$this->db_b->reconnect();
						$idPadre = $resultado['idcatalogo'];
						$consulta = "SELECT idcatalogo FROM invcatalog WHERE descrip LIKE '%$Lin%' AND idnivel1 = $idPadre";
						$query = $this->db_b->query($consulta);
						$resultado2 = $query->row_array();
						$total2 = $query->num_rows();
						
						if($total2 == 1){
							$this->load->database();
							$this->db_b->reconnect();
							$idcatalog = $resultado2['idcatalogo'];
							$consulta = "SELECT idauxi FROM ctauxi WHERE descrip LIKE '%$Pro%' AND idauxidef = 1 ";
							$query = $this->db_b->query($consulta);
							$resultado3 = $query->row_array();
							$total3 = $query->num_rows();
							
							if($total3 == 1){
								$idprovee = $resultado3['idauxi'];
								$this->load->database();
								$this->db_b->reconnect();
								$this->db_b->set('idproducto', 0);
								$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
								$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('marca', 'N/A');
								}else{
									$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('idcatalogo', $idcatalog);
								$this->db_b->set('idprovee', $idprovee);
								$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
								$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
								$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
								$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
								$this->db_b->set('estado', 1);
								$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
								$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('um', 'N/A');
								}else{
									$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
								$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('invproducts');
								
							}else{
								$this->load->database();
								$this->db_b->reconnect();
								$this->db_b->set('idauxi', 0);
								$this->db_b->set('descrip', $Pro);
								$this->db_b->set('idauxidef', 1);
								$this->db_b->set('estado', 1);
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('ctauxi');
								$idprovee = $this->db_b->insert_id();
								
								$this->db_b->set('idproducto', 0);
								$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
								$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('marca', 'N/A');
								}else{
									$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('idcatalogo', $idcatalog);
								$this->db_b->set('idprovee', $idprovee);
								$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
								$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
								$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
								$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
								$this->db_b->set('estado', 1);
								$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
								$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('um', 'N/A');
								}else{
									$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
								$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('invproducts');
							}
						}else{
							$this->load->database();
							$this->db_b->reconnect();
							$idPadre = $resultado['idcatalogo'];
							$this->db_b->set('idcatalogo', 0);
							$this->db_b->set('descrip', $Lin);
							$this->db_b->set('nivel', 2);
							$this->db_b->set('idnivel1', $idPadre);
							$this->db_b->set('estado', 1);
							$this->db_b->set('whodidit', $whodidit);
							$this->db_b->set('ingresa', $fecha_actual);
							$query = $this->db_b->insert('invcatalog');
							
							$idcatalog = $this->db_b->insert_id();
							
							$consulta = "SELECT idauxi FROM ctauxi WHERE descrip LIKE '%$Pro%' AND idauxidef = 1 ";
							$query = $this->db_b->query($consulta);
							$resultado3 = $query->row_array();
							$total3 = $query->num_rows();
							
							if($total3 == 1){
								$this->load->database();
								$this->db_b->reconnect();
								$idprovee = $resultado3['idauxi'];
								$this->db_b->set('idproducto', 0);
								$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
								$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('marca', 'N/A');
								}else{
									$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('idcatalogo', $idcatalog);
								$this->db_b->set('idprovee', $idprovee);
								$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
								$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
								$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
								$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
								$this->db_b->set('estado', 1);
								$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
								$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('um', 'N/A');
								}else{
									$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
								$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('invproducts');
								
							}else{
								$this->load->database();
								$this->db->reconnect();
								$this->db_b->set('idauxi', 0);
								$this->db_b->set('descrip', $Pro);
								$this->db_b->set('idauxidef', 1);
								$this->db_b->set('estado', 1);
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('ctauxi');
								
								$idprovee = $this->db_b->insert_id();
								
								$this->db_b->set('idproducto', 0);
								$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
								$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('marca', 'N/A');
								}else{
									$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('idcatalogo', $idcatalog);
								$this->db_b->set('idprovee', $idprovee);
								$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
								$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
								$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
								$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
								$this->db_b->set('estado', 1);
								$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
								$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
								if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
									$this->db_b->set('um', 'N/A');
								}else{
									$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
								}
								$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
								$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
								$this->db_b->set('whodidit', $whodidit);
								$this->db_b->set('ingresa', $fecha_actual);
								$query = $this->db_b->insert('invproducts');
							}
						}
						
					}else{
						$this->load->database();
						$this->db_b->reconnect();
						$this->db_b->set('idcatalogo', 0);
						$this->db_b->set('descrip', $Dep);
						$this->db_b->set('nivel', 1);
						$this->db_b->set('estado', 1);
						$this->db_b->set('whodidit', $whodidit);
						$this->db_b->set('ingresa', $fecha_actual);
						$query = $this->db_b->insert('invcatalog');
						
						$id = $this->db_b->insert_id();
						
						$this->db_b->set('idcatalogo', 0);
						$this->db_b->set('descrip', $Lin);
						$this->db_b->set('nivel', 2);
						$this->db_b->set('idnivel1', $id);
						$this->db_b->set('estado', 1);
						$this->db_b->set('whodidit', $whodidit);
						$this->db_b->set('ingresa', $fecha_actual);
						$query = $this->db_b->insert('invcatalog');
						
						$idcatalog = $this->db_b->insert_id();
						
						$consulta = "SELECT idauxi FROM ctauxi WHERE descrip LIKE '%$Pro%' AND idauxidef = 1 ";
						$query = $this->db_b->query($consulta);
						$resultado3 = $query->row_array();
						$total3 = $query->num_rows();
						
						if($total3 == 1){
							$idprovee = $resultado3['idauxi'];
							$this->load->database();
							$this->db_b->reconnect();
							$this->db_b->set('idproducto', 0);
							$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
							$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
							if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
								$this->db_b->set('marca', 'N/A');
							}else{
								$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
							}
							$this->db_b->set('idcatalogo', $idcatalog);
							$this->db_b->set('idprovee', $idprovee);
							$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
							$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
							$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
							$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
							$this->db_b->set('estado', 1);
							$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
							$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
							if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
								$this->db_b->set('um', 'N/A');
							}else{
								$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
							}
							$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
							$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
							$this->db_b->set('whodidit', $whodidit);
							$this->db_b->set('ingresa', $fecha_actual);
							$query = $this->db_b->insert('invproducts');
							
						}else{
							$this->load->database();
							$this->db_b->reconnect();
							$this->db_b->set('idauxi', 0);
							$this->db_b->set('descrip', $Pro);
							$this->db_b->set('idauxidef', 1);
							$this->db_b->set('estado', 1);
							$this->db_b->set('whodidit', $whodidit);
							$this->db_b->set('ingresa', $fecha_actual);
							$query = $this->db_b->insert('ctauxi');
							
							$idprovee = $this->db_b->insert_id();
							
							$this->db_b->set('idproducto', 0);
							$this->db_b->set('descrip', $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
							$this->db_b->set('modelo', $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
							if(trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()) == ""){
								$this->db_b->set('marca', 'N/A');
							}else{
								$this->db_b->set('marca', trim($objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue()));
							}
							$this->db_b->set('idcatalogo', $idcatalog);
							$this->db_b->set('idprovee', $idprovee);
							$this->db_b->set('costounitario', $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue());
							$this->db_b->set('precioventa', $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue());
							$this->db_b->set('tipotax', $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue());
							$this->db_b->set('tipo', $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue());
							$this->db_b->set('estado', 1);
							$this->db_b->set('xpos', $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue());
							$this->db_b->set('notas', $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue());
							if(trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()) == ""){
								$this->db_b->set('um', 'N/A');
							}else{
								$this->db_b->set('um', trim($objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue()));
							}
							$this->db_b->set('comision', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
							$this->db_b->set('descuento', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
							$this->db_b->set('whodidit', $whodidit);
							$this->db_b->set('ingresa', $fecha_actual);
							$query = $this->db_b->insert('invproducts');
							
						}
					}
				}
            }
        }
        
        function existeCodBarra($descrip){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(count(idrec),0) AS cant FROM invpromulti WHERE idgvar=2 AND descrip='$descrip'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cant_multi = $resultado['cant'];
                
                $consulta = "SELECT IFNULL(count(idproducto),0) AS cant  from invproducts where barcode='$descrip'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $cant_invproducts = $resultado['cant'];
                
                if(($cant_multi+$cant_invproducts) == 0){
                    return true;
                }else{
                    return false;
                }
            }
        }
        
        function insertProductCompra($descrip, $costo_unitario, $modelo, $barcode, $marca, $idcatalog, $proveedor, $tipopro, $tipTax, $um, $precioventa,$img){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");    
                $this->db_b->set('idproducto', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('modelo', $modelo);
                $this->db_b->set('marca', $marca);
                $this->db_b->set('barcode', $barcode);
                $this->db_b->set('idcatalogo', $idcatalog);
                $this->db_b->set('idprovee', $proveedor);
                $this->db_b->set('costounitario', $costo_unitario);
                $this->db_b->set('precioventa', $precioventa);
                $this->db_b->set('tipo', $tipopro);
                $this->db_b->set('tipotax', $tipTax);
                $this->db_b->set('estado', 1);
                $this->db_b->set('um', $um);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invproducts');
                $idproducto = $this->db_b->insert_id();
                return $idproducto;
            }
        }
        
        function getDepartamentosTipoProducto(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $SQLConsulta = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, invcatalog2.descrip AS departamento, IFNULL(gvars.descripcion, '') AS tipoProducto, IFNULL(gvars.valor_num, '') AS codigoTipo FROM invcatalog INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo LEFT JOIN gvars ON gvars.valor_num = invcatalog.tipo AND gvars.nombre = 'gv_protipo'";
                $SQLQuery = $this->db_b->query($SQLConsulta);
                $Result = $SQLQuery->result();
                
                return $Result;
            }
        }
        
        function reclasificarProductoCatalogo($idproducto, $idcatalogo, $tipoproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");    
                
                $this->db_b->set('idcatalogo', $idcatalogo);
                $this->db_b->set('tipo', $tipoproducto);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');
                
                return $query;
            }
        }
        
        function verificaExisteProveedor($idgvar, $idproducto, $idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM invpromulti where idgvar=$idgvar AND idproducto=$idproducto AND idcps=$idcps";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    return 1;
                }else{
                    return 0;            
                }
            }
        }
        
        function getMaestroCategorias($lineas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SET SQL_BIG_SELECTS = 1";
                $query = $this->db_b->query($consulta);
				
				ini_set('memory_limit','2500M');
				ini_set('max_allowed_packet', '2500M');
				$subconsulta="";
                $array = explode(",", $lineas);
                $tot = count($array);
                if($tot==0 && trim($lineas)!=""){
                    $subconsulta .= " invproducts.idcatalogo  = '".$lineas."' ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.idcatalogo  = '".$array[$i]."'  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                $consulta = "SELECT invcatalog2.descrip AS nameDepartamento, 
				invcatalog.descrip AS nameLinea, 
				ctauxi.descrip as nameProveedor, 
				invproducts.* 
				FROM invproducts 
				INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo 
				INNER JOIN invcatalog as invcatalog2  ON invcatalog2.idcatalogo = invcatalog.idnivel1 
				LEFT JOIN ctauxi ON invproducts.idprovee=ctauxi.idauxi WHERE ($subconsulta) GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getMaestroCategoriasMultiples($lineas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
				$consulta = "SET SQL_BIG_SELECTS = 1";
                $query = $this->db_b->query($consulta);
				
				ini_set('memory_limit','2500M');
				ini_set('max_allowed_packet', '2500M');
				$subconsulta="";
                $array = explode(",", $lineas);
                $tot = count($array);
                if($tot==0 && trim($lineas)!=""){
                    $subconsulta .= " invproducts.idcatalogo  = '".$lineas."' ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invproducts.idcatalogo  = '".$array[$i]."'  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }
                $consulta = "SELECT 
					invpromulti.idrec,
					invpromulti.descrip as mdescrip,
					invpromulti.idgvar,
					invpromulti.precioventa as precioventamulti,
					uniconv,
					askpwd,
					estatus,
					invpromulti.idcps,
					invpromulti.notas,
					profecini,
					profecfin,
					lowrange,
					highrange,
					gvars.descripcion as tipoMulti,
					invproducts.*,
					invcatalog2.descrip AS nameDepartamento, invcatalog.descrip AS nameLinea, ctauxi.descrip as nameProveedor

				FROM
					invproducts
					INNER JOIN invpromulti  ON invproducts.idproducto=invpromulti.idproducto
					
					INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo 
					INNER JOIN invcatalog as invcatalog2  ON invcatalog2.idcatalogo = invcatalog.idnivel1 
					LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee
					INNER JOIN gvars ON gvars.valor_num = invpromulti.idgvar and gvars.nombre='prod_multi'
					WHERE ($subconsulta) ORDER BY idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		
        function viewProductos_Lineas($linea){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.idproducto AS id ,
				invproducts.imagen, invproducts.descrip AS producto,
				invproducts.modelo AS modelo,
				invproducts.marca AS marca,
				invproducts.xpos AS xpos,
				invproducts.um AS um,
				ifnull(invproducts.precioventa,0) AS precioventa,
				invproducts.costounitario,
				invcatalog.descrip as linea,
				invcatalog2.descrip as departamento,
				SUM(inv_stock.cantidad) AS saldo
				FROM invproducts 
				INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo 
				INNER JOIN invcatalog as invcatalog2  ON invcatalog2.idcatalogo = invcatalog.idnivel1
				INNER JOIN inv_stock ON invproducts.idproducto = inv_stock.idproducto 
				WHERE invproducts.idcatalogo=$linea
				GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
		
        function viewProductos_Depto($depto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.idproducto AS id ,
				invproducts.imagen, invproducts.descrip AS producto,
				invproducts.modelo AS modelo,
				invproducts.marca AS marca,
				invproducts.xpos AS xpos,
				invproducts.um AS um,
				ifnull(invproducts.precioventa,0) AS precioventa,
				invproducts.costounitario,
				invcatalog.descrip as linea,
				invcatalog2.descrip as departamento,
				SUM(inv_stock.cantidad) AS saldo
				FROM invproducts 
				INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo 
				INNER JOIN invcatalog as invcatalog2  ON invcatalog2.idcatalogo = invcatalog.idnivel1
				INNER JOIN inv_stock ON invproducts.idproducto = inv_stock.idproducto 
				WHERE invcatalog2.idcatalogo=$depto
				GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function viewProductos_all(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invproducts.idproducto AS id ,
				invproducts.imagen, invproducts.descrip AS producto,
				invproducts.modelo AS modelo,
				invproducts.marca AS marca,
				invproducts.xpos AS xpos,
				invproducts.um AS um,
				ifnull(invproducts.precioventa,0) AS precioventa,
				invproducts.costounitario,
				invcatalog.descrip as linea,
				invcatalog2.descrip as departamento,
				SUM(inv_stock.cantidad) AS saldo
				FROM invproducts 
				INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo 
				INNER JOIN invcatalog as invcatalog2  ON invcatalog2.idcatalogo = invcatalog.idnivel1
				INNER JOIN inv_stock ON invproducts.idproducto = inv_stock.idproducto 
				GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getConsultaLibros($lineas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
				$subconsulta="";

				if($lineas!=""){
					$array = explode(",", $lineas);
					$tot = count($array);
					if($tot==0 && trim($lineas)!=""){
						$subconsulta .= " invproducts.idcatalogo  = ".$lineas." ";
					}else{
						for($i=0; $i<$tot; $i++){
							$subconsulta .= " invproducts.idcatalogo  = ".$array[$i]." OR "; 
						}
						$subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
						$subconsulta = " WHERE ( $subconsulta)";
					}
				}
                $consulta = "
				SELECT invproducts.idproducto, invproducts.xpos, invproducts.descrip,SUM(tran_100k.cantidad*tran_100k.uniconv) as saldo
				FROM invproducts 
				INNER JOIN tran_100k ON tran_100k.idproducto=invproducts.idproducto
				$subconsulta 
				GROUP BY invproducts.idproducto
				ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getAutor($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(notas,'') as notas FROM invpromulti WHERE invpromulti.idproducto=$idprod AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Autor'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
                    $resultado = $query->row_array();
					return $resultado['notas'];
                }else{
                    return "";            
                }
                
            }
        }
        function getEdicion($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(notas,'') as notas FROM invpromulti WHERE invpromulti.idproducto=$idprod AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Edición'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
                    $resultado = $query->row_array();
					return $resultado['notas'];
                }else{
                    return "";            
                }
                
            }
        }
        function getEditorial($idprod){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT IFNULL(notas,'') as notas FROM invpromulti WHERE invpromulti.idproducto=$idprod AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Editorial'";
                $query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
                    $resultado = $query->row_array();
					return $resultado['notas'];
                }else{
                    return "";            
                }
                
            }
        }
		
        function getInventarioProducto($idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta ="SELECT
				ABS(ROUND(SUM(tran_100k.cantidad * tran_100k.uniconv),2)) as Cant,
				invsites.descrip as Sucursal
				FROM invproducts 
				INNER JOIN tran_100k ON invproducts.idproducto=tran_100k.idproducto 
				INNER JOIN tran_100 ON tran_100.trannum=tran_100k.trannum 
				INNER JOIN invsites ON invsites.idcentro=tran_100.idcentro
				WHERE invproducts.idproducto=$idproducto
				GROUP BY tran_100.idcentro";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$resultado = $query->result();
				}else{
					$resultado = false;		
				}
                return $resultado;
                
            }
        }
		
		function updateDatosLibros($idproducto,$autor,$edicion,$editorial){
			if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
				redirect('CerrarSesion');
            }else{ 
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
				
				$consulta = "SELECT idrec FROM invpromulti WHERE invpromulti.idproducto=$idproducto AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Autor'";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
				$resultado = $query->row_array();
					$idrec =  $resultado['idrec'];
					$this->db_b->set('notas', $autor);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $fecha_actual);
					$this->db_b->where('idrec', $idrec);
					$this->db_b->where('idproducto', $idproducto);
					$query = $this->db_b->update('invpromulti');
				}else{
					if($autor!=""){
						$this->db_b->set('descrip', "Autor");
						$this->db_b->set('notas', $autor);
						$this->db_b->set('idgvar', 5);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$query = $this->db_b->insert('invpromulti');
					}
				}
				
				$consulta = "SELECT idrec FROM invpromulti WHERE invpromulti.idproducto=$idproducto AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Edición'";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$resultado = $query->row_array();
					$idrec =  $resultado['idrec'];
					$this->db_b->set('notas', $edicion);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $fecha_actual);
					$this->db_b->where('idrec', $idrec);
					$this->db_b->where('idproducto', $idproducto);
					$query = $this->db_b->update('invpromulti');
				}else{
					if($edicion!=""){
						$this->db_b->set('descrip', "Edición");
						$this->db_b->set('notas', $edicion);
						$this->db_b->set('idgvar', 5);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$query = $this->db_b->insert('invpromulti');
					}
				}
				
				

				$consulta = "SELECT idrec FROM invpromulti WHERE invpromulti.idproducto=$idproducto AND invpromulti.idgvar = 5 AND invpromulti.descrip = 'Editorial'";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$resultado = $query->row_array();
					$idrec =  $resultado['idrec'];
					$this->db_b->set('notas', $edicion);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $fecha_actual);
					$this->db_b->where('idrec', $idrec);
					$this->db_b->where('idproducto', $idproducto);
					$query = $this->db_b->update('invpromulti');
				}else{
					if($editorial!=""){
						$this->db_b->set('descrip', "Editorial");
						$this->db_b->set('notas', $editorial);
						$this->db_b->set('idgvar', 5);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$query = $this->db_b->insert('invpromulti');
					}
				}
			}
        }
        
        function getInformacionBusquedaProducto($dataBusqueda, $filtroBusqueda){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
				redirect('CerrarSesion');
            }else{
                $Consulta ="SELECT invproducts.idproducto, invproducts.descrip, invcatalog2.descrip AS departamento, invcatalog.descrip AS linea,
                invproducts.marca, invproducts.barcode, invproducts.modelo, invproducts.um, invproducts.costounitario
                FROM invproducts 
                INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                WHERE invproducts.$filtroBusqueda = '$dataBusqueda'";
                $Query = $this->db_b->query($Consulta);
                
                if($Query->num_rows()>0){
					$informacion = $Query->row_array();
				}else{
					$informacion = false;		
                }
                
                return $informacion;
            }
        }

        function getListadoBarrasProducto($idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT CONCAT(0) AS idrec, barcode AS descrip, ingresa FROM invproducts WHERE idproducto = $idproducto AND barcode != ''";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                $consulta1 = "SELECT idrec, descrip, ingresa FROM invpromulti WHERE idgvar = 2 AND estatus = 1 AND idproducto = $idproducto ORDER BY idrec ASC";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->result();
                
                $final = array_merge($resultado,$resultado1);
                
                return $final;
            }
        }

        function validateBarcodeEnProductos($barcode){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $Consulta1 = "SELECT idproducto, descrip, barcode FROM invproducts WHERE barcode = '$barcode'";
                $Query1 = $this->db_b->query($Consulta1);
                $infoSource1 = $Query1->result();
                
                $Consulta2 = "SELECT invpromulti.idproducto, invproducts.descrip, invpromulti.descrip AS barcode FROM invpromulti
                INNER JOIN invproducts ON invpromulti.idproducto = invproducts.idproducto WHERE invpromulti.idgvar = 2 AND invpromulti.descrip = '$barcode' AND invpromulti.estatus = 1";
                $Query2 = $this->db_b->query($Consulta2);
                $infoSource2 = $Query2->result();
                
                $infoArray = array_merge($infoSource1, $infoSource2);
                
                return $infoArray;
            }
        }

        function insertBarcodeProducto($idgvar, $barcode, $idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('descrip', $barcode);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idgvar', 2);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invpromulti');

                return $query;
            }
        }

        function deleteBarcodeProducto($idrec){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                $Consulta = "DELETE FROM invpromulti WHERE idrec = $idrec";
                $Query = $this->db_b->query($Consulta);

                return $Query;
            }
        }

        function getMultiplesPreciosToInventory($idproduct){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT descrip, precioventa FROM invpromulti WHERE idproducto = $idproduct AND idgvar IN (1,3,9) AND estatus = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getInformacionWebStore($idproducto){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $Consulta = "SELECT medidas, tamano, piezas, peso, color, forma, notas FROM invproducts WHERE idproducto = $idproducto";
                $Query = $this->db_b->query($Consulta);
                $resultado = $Query->row_array();

                return $resultado;
            }
        }

        function modificarInformacionWebStore($idproducto, $medidas, $tamano, $piezas, $color, $forma, $notas, $peso){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d H:i:s");

                $this->db_b->set('medidas', $medidas);
                $this->db_b->set('tamano', $tamano);
                $this->db_b->set('piezas', $piezas);
                $this->db_b->set('color', $color);
                $this->db_b->set('forma', $forma);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('peso', $peso);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha);
                $this->db_b->where('idproducto', $idproducto);
                $query = $this->db_b->update('invproducts');

                return $query;
            }
        }

        function viewProductosOrdenados(){ 
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                //$consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto , invcatalog.descrip AS linea, invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, invproducts.precioventa AS precioventa,invproducts.costounitario  FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo";
                //$query = $this->db_b->query($consulta);
                
                $this->db_b->select("invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip, invcatalog.descrip AS linea, invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, invproducts.precioventa AS precioventa,invproducts.costounitario");
                $this->db_b->from("invproducts");
                $this->db_b->join('invcatalog', 'invcatalog.idcatalogo = invproducts.idcatalogo');
                $this->db_b->order_by("invproducts.descrip", "ASC");

                $resultado = $this->db_b->get()->result_array();
                return $resultado;
            }
        }

        function viewProductosByLinea($linea){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                //$consulta = "SELECT invproducts.idproducto AS id , invproducts.imagen, invproducts.descrip AS producto , invcatalog.descrip AS linea, invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, invproducts.precioventa AS precioventa,invproducts.costounitario  FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo";
                //$query = $this->db_b->query($consulta);
                
                $this->db_b->select("invproducts.idproducto AS id,  invproducts.descrip,  invproducts.modelo AS modelo, invproducts.marca AS marca, invproducts.xpos AS xpos, invproducts.um AS um, invproducts.precioventa AS precioventa,invproducts.costounitario");
                $this->db_b->from("invproducts");
                $this->db_b->where('invproducts.idcatalogo', $linea);
                $this->db_b->order_by("invproducts.descrip", "ASC");

                $resultado = $this->db_b->get()->result_array();
                return $resultado;
            }
        }

        /*  IMPORTACION ARRAY DE MOVIMIENTOS   */
        public function importarArrayProductos($arrayProductos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $esValido = true;
                date_default_timezone_set('America/El_Salvador');
                $now = date("Y-m-d H:i:s");

                //inicio de transaccion manual
                $this->db_b->trans_begin();

                //insercion/modificacion de datos
                //si se registro el id del producto este se modifica con los datos ingresados
                //si no se ingresa al sistema
                foreach($arrayProductos as $pro){
                    $idpro = 0;

                    //si se ingreso el codigo del producto
                    //lo obtiene del array y lo elimina de este
                    //se hace esto para no modificar por error el id del producto al hacer el update
                    if( array_key_exists("idproducto",$pro) ){
                        $idpro = $pro['idproducto'];
                        unset($pro['idproducto']);
                    }
                    
                    //insercion
                    if($idpro == 0){
                        $pro['whodidit'] = $this->session->userdata('iduser');
                        $pro['ingresa'] = $now;
                        $pro['estado'] = 1;


                        if(!$this->db_b->insert('invproducts', $pro)){
                            //se sale del foreach en el primer producto que de error
                            $esValido = false;
                            break;
                        }
                    //modificacion    
                    }else{
                        $pro['modifica'] = $now;

                        $this->db_b->where('idproducto', $idpro);
                        if (!$this->db_b->update('invproducts', $pro)){
                            //se sale del foreach en el primer producto que de error
                            $esValido = false;
                            break;
                        }
                    }
                }

                //tras finalizar los movimentos se verifica el estado de la transaccion
                //si todo esta bien, se insertan los datos, si no se revierten
                if ($this->db_b->trans_status() === FALSE){
                    $esValido = false;
                    $this->db_b->trans_rollback();
                }
                else{
                    $this->db_b->trans_commit();
                }
                
                return ["esValido"=>$esValido];
            }
        }

        public function updateProductPrice($data, $id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                //$this->db_b->where('idproducto', $id);
                if ($this->db_b->update('invproducts', $data, array('idproducto'=> $id))) return true;
                else return false;
            }
        }

        /* Reporte_F142 */
        function viewProductosOrdenadosReporte_F142($tipoprod = 0){ 
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{ 
                $this->db_b->select("a.idproducto AS id, a.descrip, b.descrip AS linea");
                $this->db_b->from("invproducts a");
                $this->db_b->join('invcatalog b', 'b.idcatalogo = a.idcatalogo');
                if ($tipoprod != 0) {
                    $this->db_b->where('a.tipo', $tipoprod);
                }
                $this->db_b->order_by("a.descrip", "ASC");

                $resultado = $this->db_b->get()->result_array();
                return $resultado;
            }
        }

        //Verifica si un campo existe en la tabla
        function verifyIfFieldExists($field, $table){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->field_exists($field, $table);
            }
        }

        //Actualizar piezas por fardo
        public function getProductUpdateUpp($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where('idproducto', $ID)->get('invproducts')->row();
        }

        public function updateProductUpp($ID, $data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->db_b->where('idproducto', $ID);
                if ($this->db_b->update('invproducts', $data)) return true;
                else return false;
            }
        }

        public function updatePrecioLote($IDV, $valor, $precioAntiguo, $nuevoPrecio)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || 
                $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || 
                !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || 
                !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                // Obtener idproducto desde idrec (IDV)
                $query = $this->db_b->get_where('invpromulti', ['idrec' => $IDV]);
                if ($query->num_rows() == 0) return false;
            

                // Actualizar todos los que tienen ese idproducto, valor y precio anterior
                
                $this->db_b->where('idgvar', $valor);
                $this->db_b->where('idrec', $IDV);
                $this->db_b->update('invpromulti', [
                    'precioventa' => $nuevoPrecio,
                    'modifica' => date('Y-m-d H:i:s')
                ]);

                
                //var_dump($this->db_b->affected_rows());
                
                return ($this->db_b->affected_rows() > 0);
            }
        }

	}
?>