<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

    class Ppasteles_model extends CI_Model{
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

        function getDocumentosDeVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('invclase AS id, descrip');
                $this->db_b->from("inv_def");
                $this->db_b->where('agrupa', 'VN');
                $this->db_b->where('inopera', -1);
                $this->db_b->where('estatus', 1);
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getFormasDePago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('cajclase AS id, descrip, imagen');
                $this->db_b->from("caj_def");
                $this->db_b->where('agrupa', 'VN');
                $this->db_b->where('estatus', 1);
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }
        
        function getFormasDePagoDisponibles($idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pagos');
                $this->db_b->from("inv_def");
                $this->db_b->where('invclase', $idclase);
                $infoPagos = $this->db_b->get()->row()->pagos;
                
                $wPagos = str_replace(',', ' OR cajclase = ', $infoPagos);

                $this->db_b->select('cajclase AS id, descrip, imagen');
                $this->db_b->from("caj_def");
                $this->db_b->where('agrupa', 'VN');
                $this->db_b->where('(cajclase = '.$wPagos.')');
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => $dato->id,
                            'descrip' => $dato->descrip,
                            'imagen'  => $dato->imagen
                        );

                    }                    
                    return $array;
                } else return false;
            }
        }

        function getListadoPedidosPorEstado($idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "SELECT pro_hd.*, IFNULL(pro_log.date, '') AS fechachg, IFNULL(pro_log.time, '') AS timechg FROM pro_hd LEFT JOIN pro_log ON pro_log.numero = pro_hd.numero AND pro_log.estado = pro_hd.estado WHERE pro_hd.estado = $estado ORDER BY pro_hd.numero DESC";
                $SQLQuery = $this->db_b->query($SQLConsulta);

                if($SQLQuery->num_rows() > 0){
                    $SQLResult = $SQLQuery->result();
                }else{
                    $SQLResult = false;
                }

                return $SQLResult;
            }
        }

        function getListadoPedidosTodos($idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "SELECT pro_hd.*, IFNULL(pro_log.date, '') AS fechachg, IFNULL(pro_log.time, '') AS timechg FROM pro_hd LEFT JOIN pro_log ON pro_log.numero = pro_hd.numero AND pro_log.estado = pro_hd.estado WHERE pro_hd.estado != $estado AND pro_hd.estado != 9 ORDER BY pro_hd.numero DESC";
                $SQLQuery = $this->db_b->query($SQLConsulta);
                
                if($SQLQuery->num_rows() > 0){
                    $SQLResult = $SQLQuery->result();
                }else{
                    $SQLResult = false;
                }
                
                return $SQLResult;
            }
        }

        function cambiarEstadoPedidosPasteles($idPedidos, $nextEstado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $fecha_act = date("Y-m-d");
                $hora_act = date("H:i:s");

                $codigosPedidos = explode(",", $idPedidos);
                $total = count($codigosPedidos);

                for($i=0; $i<$total; $i++){
                    $this->db_b->set('estado', $nextEstado);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->where('numero', $codigosPedidos[$i]);
                    $query = $this->db_b->update('pro_hd');
                    
                    $SQLConsulta = "SELECT idrec FROM pro_log WHERE numero = ".$codigosPedidos[$i]." AND estado = $nextEstado";
                    $SQLQuery = $this->db_b->query($SQLConsulta);

                    if($SQLQuery->num_rows() > 0){
                        $SQLResult = $SQLQuery->row_array();
                        $idRec = $SQLResult['idrec'];
                        
                        $this->db_b->set('date', $fecha_act);
                        $this->db_b->set('time', $hora_act);
                        $this->db_b->set('notes', 'Cambio de estado Pedido');
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $fecha_actual);
                        $this->db_b->where('idrec', $idRec);
                        $query = $this->db_b->update('pro_log');
                    }else{
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('numero', $codigosPedidos[$i]);
                        $this->db_b->set('logtype', 2);
                        $this->db_b->set('date', $fecha_act);
                        $this->db_b->set('time', $hora_act);
                        $this->db_b->set('notes', 'Cambio de estado Pedido');
                        $this->db_b->set('estado', $nextEstado);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $query = $this->db_b->insert('pro_log');
                    }
                }

                return $query;
            }
        }

        function getPedidosConfirmadosGrid($idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT dev_time, numero, cli_name, cli_phone, date, dev_date, val_venta, val_anti FROM pro_hd WHERE idcentro = $idcentro AND estado = $estado ORDER BY numero DESC";
                $query = $this->db_b->query($consulta);
                $SQLResult = $query->result();
                
                return $SQLResult;
            }
        }
        
        function getListadoPedidosConfirmadosFecha($idcentro, $estado, $fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT dev_time, numero, cli_name, cli_phone, date, dev_date, val_venta, val_anti FROM pro_hd WHERE idcentro = $idcentro AND estado = $estado AND dev_date = '$fecha' ORDER BY numero DESC";
                $query = $this->db_b->query($consulta);
                $SQLResult = $query->result();
                
                return $SQLResult;
            }
        }

        function getListadoPedidosPasteles($idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLTimezone = "SET lc_time_names = 'es_VE';";
                $this->db_b->query($SQLTimezone);
                
                $SQLPedidos = "SELECT pro_hd.numero, pro_hd.cli_name, pro_hd.cli_phone, pro_hd.date, DATE_FORMAT(pro_hd.dev_date,'%W, %d %M, %Y') AS dev_date2, pro_hd.dev_date, pro_hd.dev_time, pro_hd.val_venta
                FROM pro_hd INNER JOIN invsites ON pro_hd.idcentro = invsites.idcentro
                WHERE (pro_hd.idcentro = '$idcentro') AND (pro_hd.estado = '$estado')
                ORDER BY pro_hd.numero DESC";
                $query = $this->db_b->query($SQLPedidos);
                
                if($query->num_rows() > 0){
                    $informacion = $query->result();
                }else{
                    $informacion = false;
                }

                return $informacion;
            }
        }

        function eliminarPedido($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $this->db_b->set('estado', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');
                
                return $query;
            }
        }

        function getListadoSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT idcentro, descrip FROM invsites WHERE tipo = 1 ORDER BY descrip";
                $query = $this->db_b->query($Consulta);

                if($query->num_rows() > 0){
                    $informacion = $query->result();
                }else {
                    $informacion = false;
                }

                return $informacion;
            }
        }

        function getGruposOpcionesPasteles($idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT DISTINCT IF(grupo = '', 'SIN GRUPO', grupo) AS grupo FROM pro_cmpt WHERE idtipo = $idtipo AND estatus = 1 ORDER BY grupo ASC";
                $Query = $this->db_b->query($Consulta);

                if($Query->num_rows()>0){
                    return $Query->result();
                }else {
                    return false;
                }
            }
        }

        function getListadoOpcionesPasteles($idtipo, $grupo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $grupo = ($grupo == "SIN GRUPO") ? "" : $grupo;

                $consulta = "SELECT idcmpt, descrip, imagen FROM pro_cmpt WHERE idtipo = $idtipo AND grupo = '$grupo' AND estatus = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);

                if($query->num_rows()>0){
                    return $query->result();
                }else {
                    return false;
                }
            }
        }

        function adicionarEncabezadoPastel($origen, $vendedor, $telefono, $nombre, $email, $telefono2, $documento, $porciones, $tortas, $idcentro, $lugar, $direccion, $telefonodev, $contacto, $idcentrodev){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('numero', 0);
                $this->db_b->set('protype', 1);
                $this->db_b->set('date', $fecha->format('Y-m-d'));
                $this->db_b->set('ordstat', 1);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('itemcount', 1);
                $this->db_b->set('idworker', $vendedor);
                $this->db_b->set('estado', 0);
                $this->db_b->set('cli_phone', $telefono);
                $this->db_b->set('cli_notify', $origen);
                $this->db_b->set('cli_name', strtoupper($nombre));
                $this->db_b->set('cli_phone1', $telefono2);
                $this->db_b->set('cli_email', $email);
                $this->db_b->set('dev_notes', $documento);
                $this->db_b->set('ck_tortas', $tortas);
                $this->db_b->set('ck_slices', $porciones);
                $this->db_b->set('dev_place', $lugar);
                $this->db_b->set('dev_direc', $direccion);
                $this->db_b->set('dev_phone', $telefonodev);
                $this->db_b->set('dev_contact', $contacto);
                $this->db_b->set('dev_idcentro', $idcentrodev);
                $this->db_b->set('pastel_fotos', ',,,');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('pro_hd');

                if($query == 1){
                    $numero = $this->db_b->insert_id();
                }else{
                    $numero = 0;
                }

                return $numero;
            }
        }

        function getNumeroItemsByTipo($numero, $tipo){
            $Consulta = "SELECT IFNULL(MAX(itemline), '0') AS numero FROM pro_dt WHERE numero = '$numero' AND tipopro = '$tipo'";
            $Query = $this->db_b->query($Consulta);

            if($Query->num_rows() > 0){
                $informacion = $Query->row_array();
                return $informacion['numero'];
            }else {
                return 0;
            }
        }

        function adicionarNuevaTortaPastel($numero, $tortas){
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            $itemline = $this->getNumeroItemsByTipo($numero, 1);

            for($i=0; $i<$tortas; $i++){ 
                $itemline++;

                $this->db_b->set('numero', $numero);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('procentro', '9904');
                $this->db_b->set('tipopro', 1);
                $this->db_b->set('estado', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('pro_dt');
            }

            return $query;
        }

        function getInformacionPedido($numero){
            $SQLDate = "SET lc_time_names = 'es_VE';";
            $this->db_b->query($SQLDate);

            $Consulta = "SELECT pro_hd.*, IFNULL(cmpt_cat.imagen, '') AS imgCatalogo, IFNULL(cmpt_cat.descrip, '') AS nameCatalogo, DATE_FORMAT(pro_hd.dev_date,'%W, %d %M, %Y') AS devdate2, pro_cmpt.descrip AS porciones FROM pro_hd 
            INNER JOIN pro_cmpt ON pro_cmpt.idcmpt = pro_hd.ck_slices 
            LEFT JOIN pro_cmpt AS cmpt_cat ON pro_hd.catreference = cmpt_cat.idcmpt AND cmpt_cat.idtipo = 40
            WHERE pro_hd.numero = $numero";
            $query = $this->db_b->query($Consulta);

            if($query->num_rows()>0){
                return $query->row_array();
            }else {
                return false;
            }
        }

        function modificarInfoCliente($numero, $vendedor, $origen, $cliphone, $cliname, $cliemail, $cliphone2, $documento, $numtortas, $porciones){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('idworker',   $vendedor);
                $this->db_b->set('cli_phone',  $cliphone);
                $this->db_b->set('cli_name',   strtoupper($cliname));
                $this->db_b->set('cli_notify', $origen);
                $this->db_b->set('cli_phone1', $cliphone2);
                $this->db_b->set('cli_email',  $cliemail);
                $this->db_b->set('dev_notes',  $documento);
                $this->db_b->set('ck_tortas',  $numtortas);
                $this->db_b->set('ck_slices',  $porciones);
                $this->db_b->set('whodidit',   $this->session->userdata('iduser'));
                $this->db_b->set('modifica',   $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('numero',   $numero);
                $query = $this->db_b->update('pro_hd');

                return $query;
            }
        }

        function modificarEntregaPedido($numero, $fecha, $hora, $lugar, $sucursal, $idcentro, $preguntar, $telefono, $direccion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLStep = "SELECT ordstat FROM pro_hd WHERE numero = $numero";
                $Query = $this->db_b->query($SQLStep);
                $informacion = $Query->row_array();

                $num_stat = $informacion['ordstat'];
                $num_stat >= 2 ? $num_stat = $num_stat : $num_stat = 2;

                if($lugar == 1){
                    $this->db_b->set('dev_direc', $sucursal);
                    $this->db_b->set('dev_idcentro', $idcentro);
                    $this->db_b->set('dev_phone', '');
                    $this->db_b->set('dev_contact', '');
                }else{
                    $this->db_b->set('dev_direc', $direccion);
                    $this->db_b->set('dev_idcentro', '');
                    $this->db_b->set('dev_phone', $telefono);
                    $this->db_b->set('dev_contact', $preguntar);
                }

                $this->db_b->set('ordstat',   $num_stat);
                $this->db_b->set('dev_place', $lugar);
                $this->db_b->set('dev_date',  $fecha);
                $this->db_b->set('dev_time',  $hora);
                $this->db_b->set('modifica',  $date->format('Y-m-d H:i:s'));
                $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                $this->db_b->where('numero',  $numero);
                $this->db_b->update('pro_hd');

                return $num_stat;
            }
        }

        function getDatosTortas($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT pro_dt.itemline, pro_dt.procentro, pro_dt.tipopro, pro_dt.notas, pro_dt.ck_position, pro_dt.ck_slices, pro_dt.ck_layers, pro_dt.ck_shape, pro_dt.ck_flavor, pro_dt.ck_bath, pro_dt.ck_filling, pro_dt.ck_covering, pro_dt.ck_color, 
                pro_dt.tx_position, pro_dt.tx_slices, pro_dt.tx_shape, pro_dt.tx_flavor, pro_dt.tx_bath, pro_dt.tx_filling, pro_dt.tx_covering, pro_dt.tx_color, IFNULL(cmpt_shape.imagen, '') AS img_shape, IFNULL(cmpt_position.imagen, '') AS img_position, 
                IFNULL(cmpt_flavor.imagen, '') AS img_flavor, IFNULL(cmpt_bath.imagen, '') AS img_bath, IFNULL(cmpt_filling.imagen, '') AS img_filling, IFNULL(cmpt_covering.imagen, '') AS img_covering, IFNULL(cmpt_color.imagen, '') AS img_color
                FROM pro_dt 
                LEFT JOIN pro_cmpt AS cmpt_position ON pro_dt.ck_position = cmpt_position.idcmpt AND cmpt_position.idtipo = 9
                LEFT JOIN pro_cmpt AS cmpt_shape ON pro_dt.ck_shape = cmpt_shape.idcmpt AND cmpt_shape.idtipo = 10
                LEFT JOIN pro_cmpt AS cmpt_flavor ON pro_dt.ck_flavor = cmpt_flavor.idcmpt AND cmpt_flavor.idtipo = 11
                LEFT JOIN pro_cmpt AS cmpt_bath ON pro_dt.ck_bath = cmpt_bath.idcmpt AND cmpt_bath.idtipo = 12
                LEFT JOIN pro_cmpt AS cmpt_filling ON pro_dt.ck_filling = cmpt_filling.idcmpt AND cmpt_filling.idtipo = 13
                LEFT JOIN pro_cmpt AS cmpt_covering ON pro_dt.ck_covering = cmpt_covering.idcmpt AND cmpt_covering.idtipo = 14
                LEFT JOIN pro_cmpt AS cmpt_color ON pro_dt.ck_color = cmpt_color.idcmpt AND cmpt_color.idtipo = 15
                WHERE pro_dt.numero = $numero AND pro_dt.procentro = '9904' AND pro_dt.tipopro = 1
                ORDER BY pro_dt.itemline ASC";
                $Query = $this->db_b->query($Consulta);

                if($Query->num_rows() > 0){
                    foreach($Query->result() AS $info) {
                        $array[] = array(
                            "id" => $info->itemline,
                            'text' => 'Torta #' . $info->itemline,
                            'icon' => 'fa fa-database',
                            'notas' => $info->notas,
                            'tx_bath' => $info->tx_bath,
                            'ck_bath' => $info->ck_bath,
                            'img_bath' => $info->img_bath,
                            'tx_shape' => $info->tx_shape,
                            'ck_shape' => $info->ck_shape,
                            'img_shape' => $info->img_shape,
                            'tx_color' => $info->tx_color,
                            'ck_color' => $info->ck_color,
                            'img_color' => $info->img_color,
                            'tx_flavor' => $info->tx_flavor,
                            'ck_flavor' => $info->ck_flavor,
                            'img_flavor' => $info->img_flavor,
                            'tx_filling' => $info->tx_filling,
                            'ck_filling' => $info->ck_filling,
                            'img_filling' => $info->img_filling,
                            'tx_covering' => $info->tx_covering,
                            'ck_covering' => $info->ck_covering,
                            'img_covering' => $info->img_covering,
                            'tx_position' => $info->tx_position,
                            'ck_position' => $info->ck_position,
                            'img_position' => $info->img_position
                        );
                    }

                    return $array;
                }else {
                    return false;
                }
            }
        }

        function getGruposComponentes($idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT DISTINCT IF(grupo = '', 'SIN-GRUPO', grupo) AS grupo FROM pro_cmpt WHERE idtipo = $idtipo AND estatus = 1 ORDER BY grupo ASC";
                $Query = $this->db_b->query($Consulta);

                if($Query->num_rows()>0){
                    return $Query->result();
                }else {
                    return false;
                }
            }
        }

        function getOpcionesComponentes($grupo, $idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $grupo = ($grupo == "SIN-GRUPO") ? "" : $grupo;

                $Consulta = "SELECT idcmpt, descrip, imagen, price FROM pro_cmpt WHERE idtipo = $idtipo AND grupo = '$grupo' AND estatus = 1 ORDER BY descrip ASC";
                $Query = $this->db_b->query($Consulta);

                if($Query->num_rows()>0){
                    return $Query->result();
                }else {
                    return false;
                }
            }
        }

        function modificarInfoTorta($numero, $itemline, $forma, $sabor, $bano, $color, $notas, $montaje, $relleno, $cobertura){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('ck_shape', $forma[0]['id']);
                $this->db_b->set('ck_flavor', $sabor[0]['id']);
                $this->db_b->set('ck_bath', $bano[0]['id']);
                $this->db_b->set('ck_filling', $relleno[0]['id']);
                $this->db_b->set('ck_covering', $cobertura[0]['id']);
                $this->db_b->set('ck_position', $montaje[0]['id']);
                $this->db_b->set('ck_color', $color[0]['id']);
                $this->db_b->set('tx_shape', $forma[0]['descrip']);
                $this->db_b->set('tx_flavor', $sabor[0]['descrip']);
                $this->db_b->set('tx_bath', $bano[0]['descrip']);
                $this->db_b->set('tx_filling', $relleno[0]['descrip']);
                $this->db_b->set('tx_covering', $cobertura[0]['descrip']);
                $this->db_b->set('tx_position', $montaje[0]['descrip']);
                $this->db_b->set('tx_color', $color[0]['descrip']);
                $this->db_b->set('estado', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('numero', $numero);
                $this->db_b->where('tipopro', 1);
                $this->db_b->where('itemline', $itemline);
                $Query = $this->db_b->update('pro_dt');

                //echo $color[0]['id'] . '           ' . $color[0]['descrip'];

                return $Query;
            }
        }

        function validateTortasCompletas($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                $tipopro = 1;

                $Consulta = "SELECT estado FROM pro_dt WHERE numero = $numero AND tipopro = $tipopro";
                $Query = $this->db_b->query($Consulta);
                $infoTortas = $Query->result();

                $i=0;
                foreach($infoTortas as $info){
                    if($info->estado ==  1){
                        $i++;
                    }
                }

                if($i == count($infoTortas)){
                    $Consulta = "SELECT ordstat FROM pro_hd WHERE numero = $numero";
                    $Query = $this->db_b->query($Consulta);
                    $informacion = $Query->row_array();

                    $ordstat = $informacion['ordstat'];

                    if($ordstat < 3){
                        $ordstat = 3;
                        $this->db_b->set('ordstat', $ordstat);
                    }
                    $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('numero', $numero);
                    $this->db_b->update('pro_hd');

                    return $ordstat;
                }else{
                    return false;
                }
            }
        }

        function getInformacionDedicatoria($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT IF(pro_hd.catreference = 0, '', pro_hd.catreference) AS catreference, pro_hd.dedicamsg, pro_hd.notas, IFNULL(pro_cmpt.imagen, '') AS imagen, IFNULL(pro_cmpt.descrip, '') AS nameCatalogo FROM pro_hd 
                LEFT JOIN pro_cmpt ON pro_hd.catreference = pro_cmpt.idcmpt AND pro_cmpt.idtipo = 40
                WHERE pro_hd.numero = $numero";
                $Query = $this->db_b->query($Consulta);

                $informacion = false;
                if($Query->num_rows() > 0){
                    $informacion = $Query->row_array();
                }

                return $informacion;
            }
        }

        function getOpcionesMensajesDedicatoria($idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descrip');
                $this->db_b->from("pro_cmpt");
                $this->db_b->where('idtipo', $idtipo);
                $this->db_b->where('estatus', 1);
                $this->db_b->where('grupo LIKE "%MENSAJE%"');
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
            
        }
        
        function getOpcionesPosicionDedicatoria($idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descrip');
                $this->db_b->from("pro_cmpt");
                $this->db_b->where('idtipo', $idtipo);
                $this->db_b->where('estatus', 1);
                $this->db_b->where('grupo LIKE "%POSICION%"');
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getInformacionFotos($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT itemline, notas, imagen, idproducto FROM pro_dt WHERE numero = $numero AND tipopro = 4";
                $Query = $this->db_b->query($Consulta);

                $informacion = false;
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }

                return $informacion;
            }
        }

        function modificarInformacionDedicatoria($numero, $imgCatalogo, $txtCatalogo, $txtDedicato){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLStep = "SELECT ordstat FROM pro_hd WHERE numero = $numero";
                $Query = $this->db_b->query($SQLStep);
                $informacion = $Query->row_array();

                $num_stat = $informacion['ordstat'];
                $num_stat >= 4 ? $num_stat = $num_stat : $num_stat = 4;

                $this->db_b->set('ordstat', $num_stat);
                $this->db_b->set('notas', $txtCatalogo);
                $this->db_b->set('catreference', $imgCatalogo);
                $this->db_b->set('dedicamsg', $txtDedicato);
                $this->db_b->set('modifica',  $date->format('Y-m-d H:i:s'));
                $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                $this->db_b->where('numero',  $numero);
                $this->db_b->update('pro_hd');

                return $num_stat;
            }
        }

        function updateImagenPastel($numero, $nameImagen, $notasImagen, $item){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

				$Consulta = "SELECT itemline FROM pro_dt WHERE numero = $numero AND tipopro = 4 AND idproducto = 'picde$item'";
				$query = $this->db_b->query($Consulta);

				if($query->num_rows()>0){
					$informacion = $query->row_array();
					$itemLine = $informacion['itemline'];

					$this->db_b->set('imagen', $nameImagen);
					$this->db_b->set('notas', $notasImagen);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('numero', $numero);
					$this->db_b->where('tipopro', 4);
					$this->db_b->where('itemline', $itemLine);
					$this->db_b->update('pro_dt');
				}else{
					$this->db_b->set('numero', $numero);
					$this->db_b->set('idproducto', 'picde'.$item);
					$this->db_b->set('procentro', 9904);
					$this->db_b->set('tipopro', 4);
					$this->db_b->set('estado', 1);
					$this->db_b->set('itemline', $item);
					$this->db_b->set('imagen', $nameImagen);
					$this->db_b->set('notas', $notasImagen);
					$this->db_b->set('whodidit', $this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$this->db_b->insert('pro_dt');
				}

                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');

                return $query;
			}
        }
        
        function getInformacionAccesorioBase($numero, $item, $tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $Consulta = "SELECT pro_dt.itemline, pro_cmpt.descrip, pro_cmpt.imagen, pro_dt.qty, pro_dt.price FROM pro_dt INNER JOIN pro_cmpt ON pro_dt.idproducto = pro_cmpt.idcmpt
                WHERE pro_dt.numero = '$numero' AND pro_dt.tipopro = $tipo AND pro_dt.itemline = $item";
                $query = $this->db_b->query($Consulta);

                $informacion = false;
                if($query->num_rows() > 0){
                    $informacion = $query->row_array();
                }
                
                return $informacion;
            }
        }

        function insertarAccBasPastel($numero, $tipo, $idcmpt, $cantidad, $precio, $notas, $item){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                    
                $this->db_b->set('numero', $numero);
                $this->db_b->set('itemline', $item);
                $this->db_b->set('idproducto', $idcmpt);
                $this->db_b->set('procentro', '9904');
                $this->db_b->set('tipopro', $tipo);
                $this->db_b->set('estado', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('qty', $cantidad);
                $this->db_b->set('price', $precio);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('pro_dt');

                return $query;
            }
        }

        function regresarPedidoEnProceso($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $this->db_b->set('estado', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');
                
                return $query;
            }
        }

        function getInformacionGeneral($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select("pro_hd.cli_notify, pro_hd.idworker, pro_hd.cli_phone, pro_hd.cli_name, pro_hd.cli_email, pro_hd.cli_phone1, pro_hd.dev_notes, pro_hd.ck_slices AS porciones, pro_cmpt.descrip as porcionesStr, pro_hd.ck_tortas");
                $this->db_b->from("pro_hd");
                $this->db_b->join('pro_cmpt', 'pro_cmpt.idcmpt = pro_hd.ck_slices', 'inner');
                $this->db_b->where('numero', $numero);
                $datos = $this->db_b->get();
                if ($datos->num_rows() > 0) {
                    return $datos->row_array();
                } else return false;
            }
        }

        function getInformacionEntrega($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select("dev_date, dev_time, dev_idcentro, dev_contact, dev_phone, dev_place, dev_direc");
                $this->db_b->from("pro_hd");
                $this->db_b->where('numero', $numero);
                $datos = $this->db_b->get();
                if ($datos->num_rows() > 0) {
                    return $datos->row_array();
                } else return false;
            }
        }

        function eliminarFotoPastel($numero, $numfoto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select("imagen");
                $this->db_b->from("pro_dt");
                $this->db_b->where('numero', $numero);
                $this->db_b->where('idproducto', 'picde'.$numfoto);
                $datos = $this->db_b->get();
                if ($datos->num_rows() > 0) {
                    $SQL = "DELETE FROM pro_dt WHERE numero = $numero AND idproducto = 'picde$numfoto'";
                    return $this->db_b->query($SQL);
                } else return false;
            }
        }

        function elminarTortaPedido($numero, $numTorta) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQL = "DELETE FROM pro_dt WHERE numero = $numero AND tipopro = 1 AND itemline = $numTorta";
                $this->db_b->query($SQL);

                $this->db_b->select("itemline, tipopro");
                $this->db_b->from("pro_dt");
                $this->db_b->where('numero', $numero);
                $this->db_b->where('tipopro', 1);
                $this->db_b->order_by('itemline', 'ASC');
                $datos = $this->db_b->get();

                $i=1;
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $this->db_b->set("itemline", $i);
                        $this->db_b->where('numero', $numero);
                        $this->db_b->where('tipopro', 1);
                        $this->db_b->where('itemline', $dato->itemline);
                        $result = $this->db_b->update("pro_dt");
                        $i++;
                    }
                }

                return $result;
            }
        }

        function adicionarTortaPedido($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->select("itemline, tipopro");
                $this->db_b->from("pro_dt");
                $this->db_b->where('numero', $numero);
                $this->db_b->where('tipopro', 1);
                $this->db_b->order_by('itemline', 'DESC');
                $this->db_b->limit(1);
                $dato = $this->db_b->get()->row();
                
                $data = array(
                    'numero' => $numero,
                    'itemline' => ((int) $dato->itemline + 1),
                    'procentro' => 9904,
                    'tipopro' => 1,
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s')
                );

                return $this->db_b->insert('pro_dt', $data);
            }
        }

        function eliminarComponenteAB($numero, $itemline, $tipoAB) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQL = "DELETE FROM pro_dt WHERE numero = $numero AND tipopro = $tipoAB AND itemline = $itemline";
                return $this->db_b->query($SQL);
            }
        }

        function getSumaTotalesAcceBases($numero, $tipopro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $query = $this->db_b->query('SELECT IFNULL(SUM(qty * price), 0) AS val_total FROM pro_dt WHERE tipopro = ' . $tipopro . ' AND numero = ' . $numero . ' AND refundable = 0');
                
                if ($query->num_rows() > 0) {
                    $data = $query->row_array();
                    return $data['val_total'];
                } else return 0;
            }
        }

        function getSumaTotalesAcceBasesRefund($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $query = $this->db_b->query('SELECT IFNULL(SUM(qty * price), 0) AS val_total FROM pro_dt WHERE numero = ' . $numero . ' AND refundable = 1 AND (tipopro = 2 OR tipopro = 3)');
                
                if ($query->num_rows() > 0) {
                    $data = $query->row_array();
                    return $data['val_total'];
                } else return 0;
            }
        }

        function getInformacionTotales($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('val_pastel, val_envio, val_refund');
                $this->db_b->from("pro_hd");
                $this->db_b->where('numero', $numero);
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array = array(
                            'val_pastel'  => number_format($dato->val_pastel, 2, '.', ''),
                            'val_envio'  => number_format($dato->val_envio, 2, '.', ''),
                            'val_refund' => number_format($dato->val_refund, 2, '.', ''),
                            'val_acces'  => number_format($this->getSumaTotalesAcceBases($numero, 2), 2, '.', ''),
                            'val_bases'  => number_format($this->getSumaTotalesAcceBases($numero, 3), 2, '.', ''),
                            'val_depos'  => number_format($this->getSumaTotalesAcceBasesRefund($numero), 2, '.', ''),
                        );

                        return $array;
                    }
                } else return false;
            }
        }
        
        function confirmarOrdenPedido($numero, $valPastel, $valEnvio, $valAcces, $valBases, $valRefund){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $fecha_act = date("Y-m-d");
                $hora_act = date("H:i:s");
                
                $valVenta = $valPastel + $valEnvio + $valAcces + $valBases + $valRefund;

                $this->db_b->set('val_venta', $valVenta);
                $this->db_b->set('val_envio', $valEnvio);
                $this->db_b->set('val_pastel', $valPastel);
                $this->db_b->set('val_acc', $valAcces);
                $this->db_b->set('val_bases', $valBases);
                $this->db_b->set('val_refund', $valRefund);
                $this->db_b->set('estado', 1);
                $this->db_b->set('ordstat', 6);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');
                
                $SQLConsulta = "SELECT idrec FROM pro_log WHERE numero = ".$numero." AND estado = 1";
                $SQLQuery = $this->db_b->query($SQLConsulta);

                if($SQLQuery->num_rows() > 0){
                    $SQLResult = $SQLQuery->row_array();
                    $idRec = $SQLResult['idrec'];

                    $this->db_b->set('date', $fecha_act);
                    $this->db_b->set('time', $hora_act);
                    $this->db_b->set('notes', 'Cambio de estado Pedido');
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->where('idrec', $idRec);
                    $query = $this->db_b->update('pro_log');
                }else{
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('numero', $numero);
                    $this->db_b->set('logtype', 2);
                    $this->db_b->set('date', $fecha_act);
                    $this->db_b->set('time', $hora_act);
                    $this->db_b->set('notes', 'Cambio de estado Pedido');
                    $this->db_b->set('estado', 1);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('pro_log');
                }
                
                return $query;
            }
        }

        function getDetallePedidoComp($numero) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('cli_name, cli_phone, DATE_FORMAT(dev_date, "%d/%m/%Y") AS dev_date, DATE_FORMAT(dev_time, "%r") AS dev_time, dev_place, dev_direc, val_venta, val_anti');
                $this->db_b->from("pro_hd");
                $this->db_b->where('numero', $numero);
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->row_array();
                } else return false;
            }
        }

        function getListadoComprobantesPago($numero, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{                
                $this->db_b->select('numero, itemline, price, notas, imagen, DATE_FORMAT(ingresa, "%Y-%m-%d") AS fecha, DATE_FORMAT(ingresa, "%d/%m/%Y") AS fecha_f');
                $this->db_b->from("pro_dt");
                $this->db_b->where('numero', $numero);
                $this->db_b->where('tipopro', $tipopro);
                $this->db_b->order_by('ingresa, itemline', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'numero'   => $dato->numero,
                            'itemline' => $dato->itemline,
                            'valor'    => $dato->price * 1,
                            'descrip'  => $dato->notas,
                            'imagen'   => $dato->imagen,
                            'fecha'    => $dato->fecha,
                            'fecha_f'    => $dato->fecha_f
                        );
                    }
                    return $array;
                } else return false;
            }
        }
        
        function getInformacionCalendarioPedidos($idcentro, $estado) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->select('dev_date, count(*) AS TotalConfirmados');
                $this->db_b->from("pro_hd");
                $this->db_b->where('(idcentro = '.$idcentro.' OR dev_idcentro = '.$idcentro.')');
                $this->db_b->where('estado', $estado);
                $this->db_b->group_by('dev_date');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'text'      => $dato->TotalConfirmados,
                            'startDate' => date("Y-m-d H:i:s", strtotime($dato->dev_date.' 00:00:00')),
                            'endDate'   => date("Y-m-d H:i:s", strtotime($dato->dev_date.' 23:59:59'))
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function insertComprobantePago($numero, $formapago, $valor, $img) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
				$consulta = "SELECT itemline FROM pro_dt WHERE numero = $numero AND tipopro = 6 ORDER BY itemline DESC LIMIT 1";
				$query = $this->db_b->query($consulta);
                        
				if ($query->num_rows() > 0) {
					$data = $query->row_array();
					$itemLine = $data['itemline'] + 1;
                } else $itemLine = 1;

                $this->db_b->set('numero', $numero);
                $this->db_b->set('idproducto', 'compAbono'.$itemLine);
                $this->db_b->set('procentro', 9904);
                $this->db_b->set('tipopro', 6);
                $this->db_b->set('estado', 1);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('notas', $formapago);
                $this->db_b->set('price', $valor);
                $this->db_b->set('imagen', $img);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->insert('pro_dt');

                $SQL    = "SELECT val_anti FROM pro_hd WHERE numero = $numero";
				$Query  = $this->db_b->query($SQL);
                $info   = $Query->row_array();
                $valTot = $info['val_anti'] + $valor;
									 
                $this->db_b->set('val_anti', number_format($valTot, 2 , '.', ''));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');

                return $query;
			}
		}

        function eliminarComprobantePago($numero, $itemline, $tipopro, $valor) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $consulta = "DELETE FROM pro_dt WHERE numero = $numero AND tipopro = $tipopro AND itemline = $itemline";
                $this->db_b->query($consulta);

                $SQL    = "SELECT val_anti FROM pro_hd WHERE numero = $numero";
				$Query  = $this->db_b->query($SQL);
                $info   = $Query->row_array();
                $valTot = $info['val_anti'] - $valor;
									 
                $this->db_b->set('val_anti', number_format($valTot, 2 , '.', ''));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');

                return $query;
            }
        }

        function generarCopiaPedido($numero, $cantidad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $fecha_date = date("Y-m-d");
                
                $SQLHD = "SELECT * FROM pro_hd WHERE numero = $numero";
                $SQLQueryHD = $this->db_b->query($SQLHD);
                $SQLResultHD = $SQLQueryHD->result();
                
                $SQLDT = "SELECT * FROM pro_dt WHERE numero = $numero";
                $SQLQueryDT = $this->db_b->query($SQLDT);
                $SQLResultDT = $SQLQueryDT->result();
                
                for($i=0; $i<$cantidad; $i++){
                    
                    foreach($SQLResultHD as $SQLDataHD){
                        $this->db_b->set('protype', $SQLDataHD->protype);
                        $this->db_b->set('date', $fecha_date);
                        $this->db_b->set('idcentro', $SQLDataHD->idcentro);
                        $this->db_b->set('itemcount', $SQLDataHD->itemcount);
                        $this->db_b->set('idworker', $SQLDataHD->idworker);
                        $this->db_b->set('estado', $SQLDataHD->estado);
                        $this->db_b->set('ordstat', $SQLDataHD->ordstat);
                        $this->db_b->set('cli_phone', $SQLDataHD->cli_phone);
                        $this->db_b->set('cli_name', $SQLDataHD->cli_name);
                        $this->db_b->set('cli_phone1', $SQLDataHD->cli_phone1);
                        $this->db_b->set('cli_email', $SQLDataHD->cli_email);
                        $this->db_b->set('cli_notify', $SQLDataHD->cli_notify);
                        $this->db_b->set('dev_place', $SQLDataHD->dev_place);
                        $this->db_b->set('dev_direc', $SQLDataHD->dev_direc);
                        $this->db_b->set('dev_idcentro', $SQLDataHD->dev_idcentro);
                        $this->db_b->set('dev_phone', $SQLDataHD->dev_phone);
                        $this->db_b->set('dev_contact', $SQLDataHD->dev_contact);
                        $this->db_b->set('dev_notes', $SQLDataHD->dev_notes);
                        $this->db_b->set('dev_date', $SQLDataHD->dev_date);
                        $this->db_b->set('dev_time', $SQLDataHD->dev_time);
                        $this->db_b->set('val_venta', $SQLDataHD->val_venta);
                        $this->db_b->set('val_anti', $SQLDataHD->val_anti);
                        $this->db_b->set('val_envio', $SQLDataHD->val_envio);
                        $this->db_b->set('val_refund', $SQLDataHD->val_refund);
                        $this->db_b->set('notas', $SQLDataHD->notas);
                        $this->db_b->set('pro_date', $SQLDataHD->pro_date);
                        $this->db_b->set('catreference', $SQLDataHD->catreference);
                        $this->db_b->set('ck_tortas', $SQLDataHD->ck_tortas);
                        $this->db_b->set('ck_slices', $SQLDataHD->ck_slices);
                        $this->db_b->set('dedicamsg', $SQLDataHD->dedicamsg);
                        $this->db_b->set('pastel_fotos', $SQLDataHD->pastel_fotos);
                        $this->db_b->set('val_pastel', $SQLDataHD->val_pastel);
                        $this->db_b->set('val_acc', $SQLDataHD->val_acc);
                        $this->db_b->set('val_bases', $SQLDataHD->val_bases);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $this->db_b->insert('pro_hd');
                        $SQLInsertID = $this->db_b->insert_id();
                    }
                    
                    foreach($SQLResultDT as $SQLDataDT){
                        $this->db_b->set('numero', $SQLInsertID);
                        $this->db_b->set('itemline', $SQLDataDT->itemline);
                        $this->db_b->set('procentro', $SQLDataDT->procentro);
                        $this->db_b->set('tipopro', $SQLDataDT->tipopro);
                        $this->db_b->set('estado', $SQLDataDT->estado);
                        $this->db_b->set('idproducto', $SQLDataDT->idproducto);
                        $this->db_b->set('qty', $SQLDataDT->qty);
                        $this->db_b->set('price', $SQLDataDT->price);
                        $this->db_b->set('refundable', $SQLDataDT->refundable);
                        $this->db_b->set('notas', $SQLDataDT->notas);
                        $this->db_b->set('imagen', $SQLDataDT->imagen);
                        $this->db_b->set('ck_position', $SQLDataDT->ck_position);
                        $this->db_b->set('ck_slices', $SQLDataDT->ck_slices);
                        $this->db_b->set('ck_layers', $SQLDataDT->ck_layers);
                        $this->db_b->set('ck_shape', $SQLDataDT->ck_shape);
                        $this->db_b->set('ck_flavor', $SQLDataDT->ck_flavor);
                        $this->db_b->set('ck_bath', $SQLDataDT->ck_bath);
                        $this->db_b->set('ck_filling', $SQLDataDT->ck_filling);
                        $this->db_b->set('ck_covering', $SQLDataDT->ck_covering);
                        $this->db_b->set('ck_color', $SQLDataDT->ck_color);
                        $this->db_b->set('tx_position', $SQLDataDT->tx_position);
                        $this->db_b->set('tx_slices', $SQLDataDT->tx_slices);
                        $this->db_b->set('tx_shape', $SQLDataDT->tx_shape);
                        $this->db_b->set('tx_flavor', $SQLDataDT->tx_flavor);
                        $this->db_b->set('tx_bath', $SQLDataDT->tx_bath);
                        $this->db_b->set('tx_filling', $SQLDataDT->tx_filling);
                        $this->db_b->set('tx_covering', $SQLDataDT->tx_covering);
                        $this->db_b->set('tx_color', $SQLDataDT->tx_color);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $SQLInsertDTQuery = $this->db_b->insert('pro_dt');
                    }
                    
                }
                
                return $SQLInsertDTQuery;
            }
        }

        function actualizarValorPastel($numero, $valPas, $valEnv){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();
                
                $total = $valPas + $valEnv;
                $this->db_b->set('val_pastel', $valPas);
                $this->db_b->set('val_envio', $valEnv);
                $this->db_b->set('val_venta', $total);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('numero', $numero);
                $query = $this->db_b->update('pro_hd');
                
                return $query;
            }
        }

        function verificarOrdenExiste($idOrden){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
				$consulta = "SELECT * FROM pro_hd WHERE numero = $idOrden LIMIT 1";
				$query = $this->db_b->query($consulta);
                        
				if ($query->num_rows() > 0) {
					return true;
                }
                return false;
            }
        }
    }
?>