<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Otrabajo_model extends CI_Model {

		public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

        public function getTiposOrdenes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("wo_def");
                $resultado = $this->db_b->get()->result_array();
                $arrayTipos = array();

                foreach($resultado as $key => $value){
                    //obteniendo los tipos de productos
                    if($value['pro_tipos'] != "" && $value['pro_tipos'] != null){
                        $arrayPros = explode(",", $value['pro_tipos']);
                        $nombresPro = "";

                        foreach($arrayPros as $pro){
                            $this->db_b->select('descripcion');
                            $this->db_b->from("gvars");
                            $this->db_b->where('nombre','gv_protipo');
                            $this->db_b->where('valor_num', (double)$pro);
                            $producto = $this->db_b->get()->row_array();
                            $nombresPro .= $producto['descripcion'].', ';
                        }

                        $resultado[$key]['tipospro'] = substr($nombresPro, 0, -2);
                    }
                }
                return $resultado;
            }
        }

        public function adicionarTipoOrden($datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('allowed_users', $datos['allowed_users']);
                $this->db_b->set('pro_tipos', $datos['pro_tipos']);
                $this->db_b->set('notas', $datos['notas']);
                $this->db_b->set('headername', $datos['header']);
                $this->db_b->set('footername', $datos['footer']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $resultado = $this->db_b->insert('wo_def');
                return $resultado;
            }
        }

        public function modificarTipoOrden($wotype, $datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('allowed_users', $datos['allowed_users']);
                $this->db_b->set('pro_tipos', $datos['pro_tipos']);
                $this->db_b->set('notas', $datos['notas']);
                $this->db_b->set('headername', $datos['header']);
                $this->db_b->set('footername', $datos['footer']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('wotype', $wotype);

                $resultado = $this->db_b->update('wo_def');
                return $resultado;
            }
        }

        function getProductosCotizados($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->distinct();
				$this->db_b->select('b.descrip');
                $this->db_b->from("wo_100d a");
                $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = strtoupper($dato->descrip);
                    }
                    return join(', ', $array);
                } else return '';
            }
        }

        function getDetalleCotizaciones($type, $idworker, $estados, $fechaini, $fechafin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $whereEstados = str_replace('_', ' OR a.estatus = ', $estados);

				$this->db_b->select('a.trannum, a.estatus, a.idorigen, d.descripcion AS nameorigen, a.wonum, a.fecha, a.notas, a.valventa, b.descrip AS nCliente, c.descrip AS nVendedor');
                $this->db_b->from("wo_100 a");
                $this->db_b->join("ctauxi b", "a.idcps = b.idauxi");
                $this->db_b->join("ctauxi c", "a.idworker = c.idauxi");
                $this->db_b->join("gvars d", "a.idorigen = d.valor_num AND d.nombre = 'wo_origen'");
                $this->db_b->where("(a.estatus = ". $whereEstados .")");
                $this->db_b->where("a.wotype",  $type);
                if ($idworker != 0) $this->db_b->where("a.idworker",  $idworker);
                $this->db_b->where("a.fecha >=", $fechaini);
                $this->db_b->where("a.fecha <=", $fechafin);
                $this->db_b->order_by('a.trannum', 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'trannum'      => (int) $dato->trannum,
                            'wonum'        => (int) $dato->wonum,
                            'fecha'        => $dato->fecha,
                            'namecliente'  => $dato->nCliente,
                            'namevendedor' => $dato->nVendedor,
                            'notas'        => $dato->notas,
                            'estatus'      => (int) $dato->estatus,
                            'origen'       => $dato->nameorigen,
                            'productos'    => $this->getProductosCotizados((int) $dato->trannum),
                            'valor'        => $dato->valventa
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getTiposOrdenesTrabajo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('wotype, descrip, allowed_users');
                $this->db_b->from("wo_def");
                $this->db_b->where("estatus", 1);
                $datos = $this->db_b->get();

                $array = array();
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $infoUsers = explode(",", $dato->allowed_users);
                        
                        if (in_array($this->session->userdata('iduser'), $infoUsers)) {
                            $array[] = array(
                                'wotype'  => (int) $dato->wotype,
                                'descrip' => $dato->descrip
                            );
                        }
                    }
                    return $array;
                } else return false;
            }
        }

        function getInformacionClientes() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('idauxi, descrip');
                $this->db_b->from("ctauxi");
                $this->db_b->where("estado", 1);
                $this->db_b->where("idauxidef", 2);
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id' => (int) $dato->idauxi,
                            'descrip' => $dato->descrip
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getListadoVendedores() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('idauxi, descrip');
                $this->db_b->from("ctauxi");
                $this->db_b->where("estado", 1);
                $this->db_b->where("idauxidef", 3);
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();

                $array[] = array(
                    'id'      => 0,
                    'descrip' => 'TODOS'
                );

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->idauxi,
                            'descrip' => $dato->descrip
                        );
                    }
                    return $array;
                } else return false;
            }
        }
        
        function getInformacionVendedores() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('idauxi, descrip');
                $this->db_b->from("ctauxi");
                $this->db_b->where("estado", 1);
                $this->db_b->where("idauxidef", 3);
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->idauxi,
                            'descrip' => $dato->descrip
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getInformacionOrigen() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('valor_num, descripcion');
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'wo_origen');
                $this->db_b->order_by("descripcion", 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->valor_num,
                            'descrip' => $dato->descripcion
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getInformacionDocumentosVN() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('invclase, descrip');
                $this->db_b->from("inv_def");
                $this->db_b->where("agrupa", 'VN');
                $this->db_b->where("inopera", -1);
                $this->db_b->where("estatus", 1);
                $this->db_b->order_by("descrip", 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->invclase,
                            'descrip' => $dato->descrip
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getInformacionFormasPago($idclase) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('pagos');
                $this->db_b->from("inv_def");
                $this->db_b->where('invclase', $idclase);
                $infoPagos = $this->db_b->get()->row()->pagos;
                
                $wPagos = str_replace(',', ' OR cajclase = ', $infoPagos);

                $this->db_b->select('cajclase, descrip');
                $this->db_b->from("caj_def");
                $this->db_b->where('agrupa', 'VN');
                $this->db_b->where('(cajclase = '.$wPagos.')');
                $this->db_b->order_by('descrip', 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->cajclase,
                            'descrip' => $dato->descrip
                        );
                    }                    
                    return $array;
                } else return false;
            }
        }

        function getInfoCotizacionCliente($idauxi) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('contacto, idworker, idorigen, idclase, idpago');
                $this->db_b->from("wo_100");
                $this->db_b->where("idcps", $idauxi);
                $this->db_b->order_by("trannum", 'DESC');
                $this->db_b->limit(1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array = array(
                            'contacto' => $dato->contacto,
                            'idworker' => (int) $dato->idworker,
                            'idorigen' => (int) $dato->idorigen,
                            'idclase'  => (int) $dato->idclase,
                            'idpago'   => (int) $dato->idpago
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function insertOrdenDeTrabajo($type, $idcps, $fecha, $contacto, $idworker, $idorigen, $idclase, $idpago, $descrip, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $b = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $r = array("", "", "", "");

                $this->db_b->set('trannum', 0);
                $this->db_b->set('wotype', $type);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('contacto', $contacto);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idpago', $idpago);
                $this->db_b->set('idorigen', $idorigen);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idanexos', 0);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', str_replace($b, $r, $notas));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('wo_100');
                
                $trannum = $this->db_b->insert_id();

                return $trannum;
            }
        }
        
        function updateOrdenDeTrabajo($trannum, $fecha, $contacto, $idworker, $idorigen, $idclase, $idpago, $ponum, $podata, $descrip, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $b = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $r = array("", "", "", "");

                $this->db_b->set('contacto', $contacto);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idpago', $idpago);
                $this->db_b->set('idorigen', $idorigen);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('ponum', $ponum);
                $this->db_b->set('podata', $podata);
                $this->db_b->set('notas', str_replace($b, $r, $notas));
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }

        function getDetalleInformacion($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('a.trannum, a.wonum, a.fecha, a.contacto, a.notas, a.valventa, b.idauxi, b.descrip AS nCliente, c.descrip AS nVendedor, a.descrip, a.faprobado, a.estatus, a.wotype, a.idcps, a.idworker, a.idpago, a.idclase, a.idorigen, a.ponum, a.podata, b.telefono, b.direccion, b.giro, b.correo');
                $this->db_b->from("wo_100 a");
                $this->db_b->join("ctauxi b", "a.idcps = b.idauxi");
                $this->db_b->join("ctauxi c", "a.idworker = c.idauxi");
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }
        
        function getDetalleDocumentosFacturados($idcliente) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('a.trannum, a.fecha, CONCAT(a.serie, a.numero) AS numerodocumento, a.notas, a.estatus, b.descrip AS namedocumento, (a.valventan + a.valtax1) AS valor');
                $this->db_b->from("tran_100 a");
                $this->db_b->join("inv_def b", "a.idclase = b.invclase");
                $this->db_b->where("a.idcps", $idcliente);
                $this->db_b->where("a.estatus", 1);
                $this->db_b->where("b.agrupa", 'VN');
                $this->db_b->where("b.inopera", -1);
                $this->db_b->order_by("a.fecha", 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getDatosFacturaciones($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('podata');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $podata = $this->db_b->get()->row()->podata;

                $podata = str_replace(",", " OR a.trannum = ", $podata);

                $this->db_b->select('a.trannum, a.notas, a.fecha, a.estatus, a.serie, a.numero, CONCAT(a.serie,a.numero) AS numeroserie, b.invclase, d.idtipo');
                $this->db_b->select('b.descrip AS tipodoc, c.descrip AS namevendedor, a.valventan, a.valcosto, a.valtax1, b.caopera, b.exento, a.referencia');
                $this->db_b->from("tran_100 a");
                $this->db_b->join('inv_def b', 'a.idclase = b.invclase');
                $this->db_b->join('ctauxi  c', 'a.idworker = c.idauxi');
                $this->db_b->join('ctauxi  d', 'a.idcps = d.idauxi');
                $this->db_b->where("a.trannum = " . $podata);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;                
            }
        }

        function getSubtotalOrden($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('cantidad, precioventa');
                $this->db_b->from("wo_100d");
                $this->db_b->where("trannum", $trannum);
                $datos = $this->db_b->get();

                $vSubtotal = 0;
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $vSubtotal = $vSubtotal + ($dato->cantidad * $dato->precioventa);
                    }
                    return $vSubtotal;
                } else return false;
            }
        }
        
        function getDescuentoOrden($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$this->db_b->select('cantidad, precioventa, descuento');
                $this->db_b->from("wo_100d");
                $this->db_b->where("trannum", $trannum);
                $datos = $this->db_b->get();

                $vDescuento = 0;
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $vDescuento = $vDescuento + ($dato->cantidad * ($dato->precioventa * ($dato->descuento / 100)));
                    }
                    return $vDescuento;
                } else return false;
            }
        }

        function getGruposLineasOrdenes($type) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pro_tipos');
                $this->db_b->from('wo_def');
                $this->db_b->where('wotype', $type);
                
                $tProductos = $this->db_b->get()->row()->pro_tipos;
                $wTipos = str_replace(',', ' OR a.tipo = ', $tProductos);

                $this->db_b->distinct();
                $this->db_b->select('b.idcatalogo, b.descrip, IFNULL(b.imagen, "") AS imagen');
                $this->db_b->from('invproducts a');
                $this->db_b->join('invcatalog b', 'a.idcatalogo = b.idcatalogo');
                $this->db_b->where('a.estado', 1);
                $this->db_b->where('(a.tipo = ' . $wTipos . ')');
                $this->db_b->order_by('b.descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
		}

        function getCantidadesLineaCatalogo($trannum, $type) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pro_tipos');
                $this->db_b->from('wo_def');
                $this->db_b->where('wotype', $type);
                
                $tProductos = $this->db_b->get()->row()->pro_tipos;
                $wTipos = str_replace(',', ' OR a.tipo = ', $tProductos);

                $this->db_b->select('a.idcatalogo, (SELECT SUM(IF(EXISTS(SELECT c.trannum FROM orders_100k c WHERE c.idproducto = a.idproducto AND c.trannum = ' . $trannum . '), 0, 1))) AS cantidad');
                $this->db_b->from('invproducts a');
                $this->db_b->join('invcatalog b', 'a.idcatalogo = b.idcatalogo');
                $this->db_b->where('a.estado', 1);
                $this->db_b->where('(a.tipo = ' . $wTipos . ')');
                $this->db_b->group_by('a.idcatalogo');
                $this->db_b->order_by('b.descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
		}

        function getInventarioByCatalogo($trannum, $idcatalogo, $idcentro, $type) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pro_tipos');
                $this->db_b->from('wo_def');
                $this->db_b->where('wotype', $type);
                
                $tProductos = $this->db_b->get()->row()->pro_tipos;
                $wTipos = str_replace(',', ' OR a.tipo = ', $tProductos);
                
                $this->db_b->select('a.idcatalogo, a.tipo, a.costounitario, a.idproducto, a.tipotax, a.xpos, a.descrip, a.marca, a.imagen, a.um, a.modelo, a.precioventa, a.barcode, a.notas');
                $this->db_b->select('IFNULL((SELECT SUM(b.cantidad * b.uniconv) FROM tran_100k b WHERE b.idproducto = a.idproducto AND b.idcentro = '. $idcentro .'), 0) AS cantidad');
                $this->db_b->select('(SELECT IF(EXISTS(SELECT c.trannum FROM orders_100k c WHERE c.idproducto = a.idproducto AND c.trannum = '. $trannum .'), 1, 0)) AS existe');
                $this->db_b->from('invproducts a');
                $this->db_b->where('a.estado', 1);
                $this->db_b->where('a.idcatalogo', $idcatalogo);
                $this->db_b->where('(a.tipo = ' . $wTipos . ')');
                $this->db_b->order_by('a.descrip', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getDetalleProductosOrden($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.xpos, a.*, a.imagen AS imgProducto, a.descuento, (a.cantidad * a.precioventa) AS subtotal, a.precioventa AS preciotran, a.notas AS modNotas, a.descrip, a.ldescrip, b.imagen, b.modelo, b.um, b.tipotax, b.tipo, a.um AS umorders');
                $this->db_b->select('(1) AS uniconv, b.marca, b.idproducto, b.barcode, b.notas');
                $this->db_b->select('IFNULL((SELECT SUM(c.cantidad * c.uniconv) FROM tran_100k c WHERE c.idproducto = a.idproducto AND c.idcentro = ' .$idcentro. '), 0) AS disponible');
                $this->db_b->from('wo_100d a');
                $this->db_b->join('invproducts b', 'a.idproducto = b.idproducto');
                $this->db_b->where('a.trannum', $trannum);
                $this->db_b->order_by('a.itemline', 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getListadoGrupos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->distinct();
				$this->db_b->select('agrupa');
                $this->db_b->from("wo_100d");
                $this->db_b->where("trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'descrip' => $dato->agrupa
                        );
                    }
                    return $array;
                } else return false;
            }
        }
        
        function getListadoLugares($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->distinct();
				$this->db_b->select('a.delivery');
                $this->db_b->from('wo_100d a');
                $this->db_b->join('wo_100 b', 'a.trannum = b.trannum');
                $this->db_b->where("b.idcps", $idcps);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'descrip' => $dato->delivery
                        );
                    }
                    return $array;
                } else return false;
            }
        }
        
        function getListadoIVA(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('descripcion, valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where("nombre", 'gv_tipotax');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id' => (int) $dato->valor_num,
                            'descrip' => $dato->descripcion
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function adicionarProducto($trannum, $idproducto, $um, $descrip, $cantidad, $precioventa, $descuento, $tax1, $agrupa, $fecha, $delivery, $ldescrip, $notas, $pdf, $movimiento, $nameImagen) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->select('itemline');
                $this->db_b->from('wo_100d');
                $this->db_b->where("trannum", $trannum);
                $this->db_b->order_by('itemline', 'DESC');
                $this->db_b->limit(1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    $itemline = $datos->row()->itemline + 1;
                } else $itemline = 1;

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('ldescrip', $ldescrip);
                $this->db_b->set('um', $um);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('precioventa', $precioventa);
                $this->db_b->set('descuento', $descuento);
                $this->db_b->set('tax1', $tax1);
                $this->db_b->set('imagen', $nameImagen);
                $this->db_b->set('agrupa', $agrupa);
                $this->db_b->set('duedate', $fecha);
                $this->db_b->set('delivery', $delivery);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('show_onquote', $pdf);
                $this->db_b->set('allow_mov', $movimiento);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                return $this->db_b->insert('wo_100d');
            }
        }
        
        function modificarProducto($idrec, $descrip, $itemline, $cantidad, $precioventa, $descuento, $tax1, $agrupa, $fecha, $delivery, $ldescrip, $notas, $pdf, $movimiento, $nameImagen) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('ldescrip', $ldescrip);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('precioventa', $precioventa);
                $this->db_b->set('descuento', $descuento);
                $this->db_b->set('tax1', $tax1);
                if ($nameImagen != '') $this->db_b->set('imagen', $nameImagen);
                $this->db_b->set('agrupa', $agrupa);
                $this->db_b->set('duedate', $fecha);
                $this->db_b->set('delivery', $delivery);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('show_onquote', $pdf);
                $this->db_b->set('allow_mov', $movimiento);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('idrec', $idrec);
                return $this->db_b->update('wo_100d');
            }
        }

        function eliminarProducto($idrec) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                return $this->db_b->delete('wo_100d', array('idrec' => $idrec));
            }
        }

        public function getListadoAnexos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("wo_anexos");
                $resultado = $this->db_b->get()->result_array();

                return $resultado;
            }
        }
        
        function getInfoListadoAnexos($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $infoAnexos = explode(',', $this->db_b->get()->row()->idanexos);

                $this->db_b->select('idanexo, descrip');
                $this->db_b->from("wo_anexos");
                $this->db_b->where("estatus", 1);
                $datos = $this->db_b->get();

                $array = array();

                if (!in_array('0', $infoAnexos)) {
                    $array[] = array(
                        'id' => 0,
                        'descrip' => 'COTIZACIÓN ACTUAL'
                    );
                }

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        if (!in_array($dato->idanexo, $infoAnexos)) {
                            $array[] = array(
                                'id' => (int) $dato->idanexo,
                                'descrip' => strtoupper($dato->descrip)
                            );
                        }
                    }
                    return $array;
                } else return false;
            }
        }

        function getDetalleAnexos($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $dataAnexos = $this->db_b->get()->row()->idanexos;
                $infoAnexos = explode(',', $dataAnexos);
                
                if ($dataAnexos != '') {
                    for ($i=0; $i<count($infoAnexos); $i++) {
                        if ((int) $infoAnexos[$i] === 0) {
                            $array[$i] = array(
                                'idorden' => ($i + 1),
                                'id' => (int) $infoAnexos[$i],
                                'descrip' => 'COTIZACIÓN ACTUAL'
                            );
                        } else {
                            $this->db_b->select('descrip');
                            $this->db_b->from("wo_anexos");
                            $this->db_b->where("estatus", 1);
                            $this->db_b->where("idanexo", $infoAnexos[$i]);
                            $datos = $this->db_b->get()->row();

                            $array[$i] = array(
                                'idorden' => ($i + 1),
                                'id' => (int) $infoAnexos[$i],
                                'descrip' => strtoupper($datos->descrip)
                            );
                        }
                    }

                    return $array;
                } else return false;
            }
        }
        
        function adicionarAnexoCoti($trannum, $idanexo) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $dataAnexos = $this->db_b->get()->row()->idanexos;
                $dataAnexos = ($dataAnexos == '') ? $idanexo : $dataAnexos . ',' . $idanexo;
                
                $this->db_b->set('idanexos', $dataAnexos);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }
        
        function eliminarAnexoCoti($trannum, $idorden) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $dataAnexos = explode(',', $this->db_b->get()->row()->idanexos);
                
                unset($dataAnexos[((int) $idorden - 1)]);
                
                $this->db_b->set('idanexos', implode(',', $dataAnexos));
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }
        
        function modificaAnexoCoti($trannum, $idanexos) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->set('idanexos', $idanexos);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }

        function getListadoMotivosMov($estado) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->distinct();
				$this->db_b->select('motivo');
                $this->db_b->from('wo_100l');
                $this->db_b->where("estatus_n", $estado);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'descrip' => $dato->motivo
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function totalizarCotizacion($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->select('SUM(cantidad * precioventa) AS valventa');
                $this->db_b->from('wo_100d');
                $this->db_b->where("trannum", $trannum);
                $valventa = $this->db_b->get()->row()->valventa;

                $this->db_b->set('valventa', $valventa);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }
        
        function anularCotizacion($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->delete('wo_100d', array('trannum' => $trannum));

                $this->db_b->set('valventa', 0);
                $this->db_b->set('wonum', 0);
                $this->db_b->set('woestatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }
        
        function generarNumeracionOT($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->select('wonum, whodidit');
                $this->db_b->from('wo_100');
                $this->db_b->where("trannum", $trannum);
                $resultado = $this->db_b->get()->row_array();
                $wonum = $resultado['wonum'];
                $whodidit = $resultado['whodidit'];

                if ($wonum == 0) {
                    $this->db_b->select('valor_num');
                    $this->db_b->from('gvars');
                    $this->db_b->where("nombre", 'wo_num');
                    $wonum = (int) $this->db_b->get()->row()->valor_num + 1;

                    $this->db_b->set('valor_num', $wonum);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                    $this->db_b->where('nombre', 'wo_num');
                    $this->db_b->update('gvars');
                }

                $this->load->model('mensajes_model');
                $this->mensajes_model->adicionarMensaje('La cotización #'.$trannum.' ha sido aprobada.', $whodidit, $this->session->userdata('iduser'), '');

                $this->db_b->set('wonum', $wonum);
                $this->db_b->set('woestatus', 2);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('wo_100');
            }
        }

        function updateEstadoCotizacion($trannum, $estado_a, $estado_n, $motivo, $ponum, $podata, $formapago, $infopago) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

                if ($estado_n == 1) {
                    $this->totalizarCotizacion($trannum);
                } else if ($estado_n == 2) {
                    $this->generarNumeracionOT($trannum);
                } else if ($estado_n == 9) {
                    //$this->anularCotizacion($trannum);
                }

                $this->db_b->set('estatus', $estado_n);
                $this->db_b->set('ponum', $ponum);
                $this->db_b->set('podata', $podata);
                if ($estado_n < 2 || $estado_n == 8) $this->db_b->set('woestatus', 0);
                if ($estado_n == 9) $this->db_b->set('woestatus', 9);
                if ($estado_n == 2) $this->db_b->set('idpago', $formapago);
                if ($estado_n == 2) $this->db_b->set('ponotas', $infopago);
                if ($estado_n == 2) $this->db_b->set('faprobado', date("Y-m-d"));
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100');
                
                $this->db_b->set('estatus', $estado_n);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100d');

                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('motivo', $motivo);
                $this->db_b->set('estatus_a', $estado_a);
                $this->db_b->set('estatus_n', $estado_n);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                return $this->db_b->insert('wo_100l');
            }
        }
        
        function updateEstadoCotizacionFacturada($trannum, $estado_a, $estado_n, $documentos) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

                if ($estado_n == 1) {
                    $this->totalizarCotizacion($trannum);
                } else if ($estado_n == 2) {
                    $this->generarNumeracionOT($trannum);
                } else if ($estado_n == 9) {
                    //$this->anularCotizacion($trannum);
                }

                //$this->db_b->set('faprobado', ($estado_n == 2) ? date("Y-m-d") : '0000-00-00');
                $this->db_b->set('estatus', $estado_n);
                //$this->db_b->set('ponum', $ponum);
                $this->db_b->set('podata', $documentos);
                if ($estado_n < 2 || $estado_n == 8) $this->db_b->set('woestatus', 0);
                if ($estado_n == 9) $this->db_b->set('woestatus', 9);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100');
                
                $this->db_b->set('estatus', $estado_n);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100d');

                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('motivo', 'Orden de Trabajo Facturada');
                $this->db_b->set('estatus_a', $estado_a);
                $this->db_b->set('estatus_n', $estado_n);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                return $this->db_b->insert('wo_100l');
            }
        }

        function getFecheEntregaOT($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('duedate');
                $this->db_b->from("wo_100d");
                $this->db_b->where("trannum", $trannum);
                $this->db_b->limit(1);
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->row()->duedate;
                } else return '';
            }
        }

        function getDetalleControl() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

				$this->db_b->select('DATE_FORMAT(a.fecha, "%d/%m/%Y") AS fecha, a.fecha AS ofecha, a.faprobado, a.idworker, a.estatus, a.trannum, a.wonum, a.descrip, c.descrip AS nCliente, IFNULL(d.descrip, "SIN ASIGNAR") AS nVendedor');
                $this->db_b->from("wo_100 a");
                $this->db_b->join("ctauxi c", "a.idcps = c.idauxi");
                $this->db_b->join("ctauxi d", "a.idworker = d.idauxi", "left");
                $this->db_b->where("a.woestatus >=", 2);
                $this->db_b->where("a.estatus !=", 9);
                $this->db_b->order_by('a.fecha', 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'idworker'     => (int) $dato->idworker,
                            'trannum'      => (int) $dato->trannum,
                            'wonum'        => (int) $dato->wonum,
                            'productos'    => $this->getProductosCotizados((int) $dato->trannum),
                            'descrip'      => $dato->descrip,
                            'descripcion'  => 'OT#: '.$dato->wonum.' / COT#: '.$dato->trannum.' | '.$dato->nCliente,
                            'fecha'        => $dato->fecha,
                            'ofecha'       => $dato->ofecha,
                            'faprobado'    => ($dato->faprobado == '0000-00-00') ? '' : $dato->faprobado,
                            'duedate'      => $this->getFecheEntregaOT($dato->trannum),
                            'namecliente'  => $dato->nCliente,
                            'namevendedor' => $dato->nVendedor,
                            'estatus'      => $dato->estatus
                        );
                    }
                    return $array;
                } else return array();
            }
        }

        function getDetalleOT($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

				$this->db_b->select('a.*, DATE_FORMAT(a.duedate, "%d/%m/%Y") AS fechaEntrega, b.imagen AS imagenProducto');
                $this->db_b->from("wo_100d a");
                $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->order_by('a.itemline', 'ASC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    // foreach ($datos->result() as $dato) {
                    //     $array[] = array(
                    //         'idworker'     => (int) $dato->idworker,
                    //         'trannum'      => (int) $dato->trannum,
                    //         'wonum'        => (int) $dato->wonum,
                    //         'descrip'      => $dato->descrip,
                    //         'fecha'        => $dato->fecha,
                    //         'namecliente'  => $dato->nCliente,
                    //         'namevendedor' => $dato->nVendedor,
                    //         'estatus'      => $dato->estatus
                    //     );
                    // }
                    // return $array;
                    return $datos->result();
                } else return array();
            }
        }

        function getInformacionConsumos($estado, $fechaini, $fechafin, $idConsumo, $idReintegro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

				$this->db_b->select('a.trannum, a.fecha, a.fecact, a.referencia, a.estatus, b.descrip AS nametransaccion, c.descrip AS namecliente');
                $this->db_b->from("tran_100 a");
                $this->db_b->join("inv_def b", "a.idclase = b.invclase");
                $this->db_b->join("ctauxi c", "a.idcps = c.idauxi");
                $this->db_b->where("(a.idclase = ". $idConsumo ." OR a.idclase = ". $idReintegro .")");
                ($estado == 0) ? $this->db_b->where("a.estatus", 0) : $this->db_b->where("(a.estatus = 1 OR a.estatus = 9)");
                if ($estado == 1) $this->db_b->where("(a.fecha BETWEEN '". $fechaini ."' AND '". $fechafin."')");
                $this->db_b->order_by('a.trannum', 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    // foreach ($datos->result() as $dato) {
                    //     $array[] = array(
                    //         'idworker'     => (int) $dato->idworker,
                    //         'trannum'      => (int) $dato->trannum,
                    //         'wonum'        => (int) $dato->wonum,
                    //         'descrip'      => $dato->descrip,
                    //         'fecha'        => $dato->fecha,
                    //         'namecliente'  => $dato->nCliente,
                    //         'namevendedor' => $dato->nVendedor,
                    //         'estatus'      => $dato->estatus
                    //     );
                    // }
                    // return $array;
                    return $datos->result();
                } else return array();
            }
        }

        function getTransaccionesConsumos($optCodigo) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');

                $whereCodigos = str_replace(',', ' OR a.invclase =', $optCodigo);

				$this->db_b->select('a.invclase, a.descrip');
                $this->db_b->from("inv_def a");
                $this->db_b->where("(a.invclase = ".$whereCodigos.")");
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return array();
            }
        }

        function insertNuevoConsumo($fecha, $wonum, $notas, $idclase) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->select('idcps');
                $this->db_b->from('wo_100');
                $this->db_b->where("wonum", $wonum);
                $this->db_b->limit(1);
                $datos = $this->db_b->get();
                
                $idcps = $datos->row()->idcps;
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $this->session->userdata('idcentrouser'));
                $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('referencia', $wonum);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                $this->db_b->insert('tran_100');

                $trannum = $this->db_b->insert_id();

                return $trannum;
            }
        }

        function getDetalleConsumo($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.trannum, a.idcps, a.idclase, a.tranref, a.referencia, d.wonum, a.idcentro, a.notas, a.fecha, a.fecact, DATE_FORMAT(a.fecact, "%d/%m/%Y") AS fecha2, a.estatus, a.lines100k, b.descrip as transaccion');
                $this->db_b->select('c.descrip AS nameCliente, b.inopera');
                $this->db_b->select('(SELECT SUM(ABS(x.cantidad)) FROM tran_100k x WHERE x.trannum= a.trannum) AS cantidad');
                $this->db_b->select('CONCAT("OT#: ", d.wonum, " / COT#: ", d.trannum) AS descripcion');
                $this->db_b->from('tran_100 a');
                $this->db_b->join("inv_def b", "a.idclase = b.invclase");
                $this->db_b->join("ctauxi c", "a.idcps = c.idauxi");
                $this->db_b->join("wo_100 d", "a.referencia = d.wonum");
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();
                return $datos->result();
            }
        }

        function getDetalleProductosEnviados($wonum, $trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('c.descrip, c.marca, c.modelo, c.barcode, c.upp, c.notas, c.idproducto, c.um, c.imagen, c.costounitario, a.idbin, a.idbatch');
                $this->db_b->select('c.xpos, c.precioventa, (SUM(a.cantidad * a.uniconv) * -1) AS cantidad');
                $this->db_b->select('(SELECT IF(EXISTS( SELECT d.trannum FROM tran_100k d WHERE d.idproducto = c.idproducto AND d.trannum = '.$trannum.'), 1, 0)) AS existe');
                $this->db_b->from('tran_100k a');
                $this->db_b->join("tran_100 b", "a.trannum = b.trannum");
                $this->db_b->join("invproducts c", "a.idproducto = c.idproducto");
                $this->db_b->where("b.referencia", $wonum);
                $this->db_b->where("b.estatus", 1);
                $this->db_b->group_by("a.idproducto");
                $datos = $this->db_b->get();
                return $datos->result();
            }
        }

        function getDetalleProductosConsumo($trannum, $wonum, $inopera, $idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.xpos, b.tipotax, b.upp, b.tipo, a.idrec, a.barcode, a.itemline, a.uniconv, a.idworker, b.idcatalogo, b.descrip, b.imagen, b.modelo, b.um');
                $this->db_b->select('b.marca, b.idproducto, b.notas, ABS(a.cantidad) AS cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, a.notas, a.notas AS modNotas');
                if ($inopera == -1) {
                    $this->db_b->select('(SELECT SUM(c.cantidad * c.uniconv) FROM tran_100k c WHERE c.idproducto = a.idproducto AND c.idcentro = '.$idcentro.' GROUP BY c.idproducto) AS disponible');
                } else {
                    $this->db_b->select('(SELECT (SUM(c.cantidad * c.uniconv) * -1) FROM tran_100k c INNER JOIN tran_100 e ON c.trannum = e.trannum WHERE c.idproducto = a.idproducto AND e.referencia = '.$wonum.' AND e.estatus = 1 GROUP BY c.idproducto) AS disponible');
                }
                
                $this->db_b->from('tran_100k a');
                $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->order_by("a.itemline", 'DESC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function adicionarRegistroConsumo($trannum, $idclase, $idcentro, $inopera, $idproducto, $cantidad, $um, $costounitario, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->select('itemline');
                $this->db_b->from('tran_100k');
                $this->db_b->where("trannum", $trannum);
                $this->db_b->order_by('itemline', 'DESC');
                $this->db_b->limit(1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    $itemline = $datos->row()->itemline + 1;
                } else $itemline = 1;
                
                $this->db_b->select('idbatch');
                $this->db_b->from('inv_batch');
                $this->db_b->where("idproducto", $idproducto);
                $this->db_b->limit(1);
                $idbatch = $this->db_b->get()->row()->idbatch;
                
                $this->db_b->select('idbin');
                $this->db_b->from('invlocations');
                $this->db_b->where("idcentro", $idcentro);
                $this->db_b->limit(1);
                $idbin = $this->db_b->get()->row()->idbin;
                
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('cantidad', $cantidad * $inopera);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('costounitario', $costounitario);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                return $this->db_b->insert('tran_100k');
            }
        }

        function modificarRegistroConsumo($idrec, $cantidad, $inopera, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->db_b->set('cantidad', $cantidad * $inopera);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('idrec', $idrec);
                return $this->db_b->update('tran_100k');
            }
        }
        
        function eliminarRegistroConsumo($idrec) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('idrec', $idrec);
                return $this->db_b->delete('tran_100k');
            }
        }

        function setAnulacionConsumo($trannum, $estado) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->where('trannum', $trannum);
                $this->db_b->delete('tran_100k');
                        
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('tran_100');
            }
        }

        function cerrarConsumo($trannum, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('notas', $notas);
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                return $this->db_b->update('tran_100');
            }
        }

        function updateControlOT($idrec, $notas, $idworker) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->set('notas', $notas);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('idrec', $idrec);
                return $this->db_b->update('wo_100d');
            }
        }
        
        function moveItemControl($trannum, $estado_a, $estado_n, $motivo, $fecha = '') {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->set('estatus', $estado_n);
                if ($estado_n == 4) {
                    $this->db_b->set('duedate', $fecha);
                }
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100d');
                
                $this->db_b->set('estatus', $estado_n);
                $this->db_b->set('woestatus', $estado_n);
                //$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('wo_100');

                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('motivo', $motivo);
                $this->db_b->set('estatus_a', $estado_a);
                $this->db_b->set('estatus_n', $estado_n);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                return $this->db_b->insert('wo_100l');
            }
        }

        function updateRegistroControl($idrec, $idworker, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('idrec', $idrec);
                return $this->db_b->update('wo_100d');
            }
        }

        function getDatosAnalisisConsumos($fechaIni, $fechaFin, $idConsumo, $idReintegro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.fecha AS Fecha, e.descrip AS Cliente, CONCAT("Orden de Trabajo #: ", b.referencia) AS Numero_OT, g.descrip AS Departamento, f.descrip AS Linea');
                $this->db_b->select('c.descrip AS Tipo_de_Transaccion, CONCAT("[", d.idproducto, "] ", d.descrip) AS Producto, ((a.cantidad * a.uniconv) * -1) AS Unidades, (((a.cantidad * a.uniconv) * a.costounitario) * -1) AS Costo_Total');
                $this->db_b->from('tran_100k a');
                $this->db_b->join("tran_100 b", "a.trannum = b.trannum");
                $this->db_b->join("inv_def c", "b.idclase = c.invclase");
                $this->db_b->join("invproducts d", "a.idproducto = d.idproducto");
                $this->db_b->join("ctauxi e", "b.idcps = e.idauxi");
                $this->db_b->join("invcatalog f", "d.idcatalogo = f.idcatalogo");
                $this->db_b->join("invcatalog g", "f.idnivel1 = g.idcatalogo");
                $this->db_b->where('(b.fecha BETWEEN "'.$fechaIni.'" AND "'.$fechaFin.'")');
                $this->db_b->where('(c.invclase = '.$idConsumo.' OR c.invclase = '.$idReintegro.')');
                $this->db_b->order_by("d.descrip", 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        //ANEXOS DE COTIZACIONES
   
        function adicionarAnexo($datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('contenido', $datos['contenido']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('headername', $datos['header']);
                $this->db_b->set('footername', $datos['footer']);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);

                $resultado = $this->db_b->insert('wo_anexos');
                return $resultado;
            }
        }

        function modificarAnexo($idanexo, $datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('contenido', $datos['contenido']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('headername', $datos['header']);
                $this->db_b->set('footername', $datos['footer']);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idanexo', $idanexo);
 
                $resultado = $this->db_b->update('wo_anexos');
                return $resultado;
            }
        }

        function getAnexosCotizacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $resultado = $this->db_b->get()->row_array();
                
                if($resultado['idanexos'] != ""){
                    $anexos = explode(",", $resultado['idanexos']);
                    $arrayAnexos = [];
                    $i=0;

                    foreach($anexos as $anexo){
                        if($anexo == "0"){
                            $arrayAnexos[] = array(
                                "idanexo" => "0",
                                "descrip" => "",
                                "contenido" =>"",
                                "headername" =>"",
                                "footername" => "",
                                "posicion" => $i+1,
                            );
                            $i++;
                            continue;
                        }

                        $info = $this->getInfoAnexo($anexo);
                        if($info != false){
                            $arrayAnexos[] = array(
                                "idanexo" => $info['idanexo'],
                                "descrip" => $info['descrip'],
                                "contenido" =>$info['contenido'],
                                "headername" =>$info['headername'],
                                "footername" => $info['footername'],
                                "posicion" => $i+1,
                            );
                            $i++;
                        }
                    }
                }else{
                    return false;
                }
                
                return $arrayAnexos;
            }
        }

        function getInfoAnexo($idanexo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idanexo, descrip, contenido, headername, footername');
                $this->db_b->from("wo_anexos");
                $this->db_b->where("idanexo", $idanexo);
                $resultado = $this->db_b->get();
                
                if($resultado->num_rows() != 0){
                    $resultado = $resultado->row_array();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }

        function getHeaderCotizacion($wotype){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('headername, footername');
                $this->db_b->from("wo_def");
                $this->db_b->where("wotype", $wotype);
                $resultado = $this->db_b->get();
                
                if($resultado->num_rows() != 0){
                    $resultado = $resultado->row_array();
                }else{
                    $resultado = false;
                }
                return $resultado;
            }
        }

        //  REPORTE CONSUMO DE MATERIALES
        function getDatosReporteConsumoMateriales($fechaIni, $fechaFin, $idConsumo, $idReintegro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.fecha AS fecha, e.descrip AS nombreCliente, b.referencia as numOT, d.descrip AS nombreProducto, d.um,d.idproducto as idProducto, SUM(((a.cantidad * a.uniconv) * -1)) AS unidades, a.costounitario');
                $this->db_b->from('tran_100k a');
                $this->db_b->join("tran_100 b", "a.trannum = b.trannum");
                $this->db_b->join("inv_def c", "b.idclase = c.invclase");
                $this->db_b->join("invproducts d", "a.idproducto = d.idproducto");
                $this->db_b->join("ctauxi e", "b.idcps = e.idauxi");
                $this->db_b->where('(b.fecha BETWEEN "'.$fechaIni.'" AND "'.$fechaFin.'")');
                $this->db_b->where('(c.invclase = '.$idConsumo.' OR c.invclase = '.$idReintegro.')');
                $this->db_b->group_by(array("numOT", "nombreProducto"));

                //$this->db_b->order_by("d.descrip", 'ASC');
                $datos = $this->db_b->get();
                
                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getDeliveryOrden($trannum){
            $this->db_b->select('delivery');
            $this->db_b->from('wo_100d');
            $this->db_b->where('trannum', $trannum);
            $this->db_b->limit(1);
            //$this->db_b->order_by("d.descrip", 'ASC');
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() > 0) {
                return $datos->row_array()['delivery'];
            } else return "";

        }

        function getDiferentesCambiosEstados() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $arrayEstados[0] = 'Digitación';
                $arrayEstados[1] = 'Presentada';
                $arrayEstados[2] = 'Aprobadas';
                $arrayEstados[3] = 'En Proceso';
                $arrayEstados[4] = 'Terminada';
                $arrayEstados[5] = 'Facturada';
                $arrayEstados[8] = 'No Aceptada';
                $arrayEstados[9] = 'Anulada';

                $this->db_b->distinct();
				$this->db_b->select('a.estatus_a, a.estatus_n');
                $this->db_b->from("wo_100l a");
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    $i=0;
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'        => $i,
                            'estatus_a' => $dato->estatus_a,
                            'estatus_n' => $dato->estatus_n,
                            'descrip'   => $arrayEstados[$dato->estatus_a].' ➜ '.$arrayEstados[$dato->estatus_n]
                        );
                        $i++;
                    }
                    return $array;
                } else return false;
            }
        }

        function getDetalleCotizacionesEstados($type, $idworker, $estado_a, $estado_n, $fechaini, $fechafin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                // $whereEstados = str_replace('_', ' OR a.estatus = ', $estados);

				$this->db_b->select('a.trannum, a.estatus, a.wonum, a.fecha, a.faprobado, a.notas, a.valventa, b.descrip AS nCliente, c.descrip AS nVendedor');
                $this->db_b->from("wo_100  a");
                $this->db_b->join("ctauxi  b", "a.idcps = b.idauxi");
                $this->db_b->join("wo_100l d", "a.trannum = d.trannum");
                $this->db_b->join("ctauxi  c", "c.idauxi = a.idworker");
                $this->db_b->join("gusers  e", "e.iduser = d.whodidit");
                $this->db_b->where("d.estatus_a", $estado_a);
                $this->db_b->where("d.estatus_n", $estado_n);
                $this->db_b->where("a.wotype",  $type);
                if ($idworker != 0) $this->db_b->where("a.idworker",  $idworker);
                $this->db_b->where("d.ingresa >=", $fechaini);
                $this->db_b->where("d.ingresa <=", $fechafin);
                $this->db_b->order_by('a.trannum', 'DESC');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'trannum'      => (int) $dato->trannum,
                            'wonum'        => (int) $dato->wonum,
                            'fecha'        => $dato->fecha,
                            'faprobado'    => ($dato->faprobado == '0000-00-00') ? '' : $dato->faprobado,
                            'namecliente'  => $dato->nCliente,
                            'namevendedor' => $dato->nVendedor,
                            'notas'        => $dato->notas,
                            'estatus'      => (int) $dato->estatus,
                            'productos'    => $this->getProductosCotizados((int) $dato->trannum),
                            'valor'        => $dato->valventa
                        );
                    }
                    return $array;
                } else return false;
            }
        }
	}
?>