<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Iva_model extends CI_Model{

		public function __construct() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            date_default_timezone_set('America/El_Salvador');

            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

		public function getVentas($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);

                $tot   = count($array);
                if($tot==0 && trim($formatos) != ""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr($subconsulta, 0, strlen($subconsulta)-3);
                }

				$SQLQuery = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.exento,
                invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.nrc, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND t100.serie != '' AND t100.numero != 0 AND ($subconsulta)
                ORDER BY t100.fecha, t100.numero";
				
                $Query = $this->db_b->query($SQLQuery);
				$resultado = $Query->result();

				return $resultado;
			}
		}
        
		public function getVentasC($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot   = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr($subconsulta, 0, strlen($subconsulta)-3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);

				$SQLQuery = "SELECT invsites.xpos AS idcentro, ctcajas.xpos AS idcaja, invdef.xpos AS clase, t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie,
                    t100.serie, t100.numero, t100.numz, invdef.invclase, invdef.exento, invdef.ivabook, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.nrc, ctauemp.descrip AS namevendedor,
                    t100.valventan, t100.valtax1, t100.valtax5, ctaucli.nit, ctaucli.giro, ctaucli.direccion, IFNULL(gzips.municipio, '') AS municipio, IFNULL(gzips.depto, '') AS departamento,
                    invsites.xpos AS idcenxpos, invdef.notas AS idclaxpos, ctcajas.xpos AS idcajxpos, ctcajas.equipo, t100.referencia, gnums.resolucion 
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN gnums ON invdef.numgrupo = gnums.numgrupo AND gnums.serie = t100.serie AND t100.idcentro = gnums.idcentro
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                LEFT JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                LEFT JOIN gzips ON ctaucli.idzip = gzips.idzip
                INNER JOIN invsites ON invsites.idcentro = t100.idcentro
                INNER JOIN ctcajas ON ctcajas.idcaja = t100.idcaja
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                AND ($subconsulta) AND (t100.serie != '') AND (t100.numero != 0)
                GROUP BY t100.trannum
                ORDER BY t100.fecha, t100.numero ASC";
				$Query = $this->db_b->query($SQLQuery);
				$resultado = $Query->result();

				return $resultado;
			}
		}

        public function getVentasConsumidorExcel($fechaini,$fechafin,$idcentro,$idcaja,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot   = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr($subconsulta, 0, strlen($subconsulta)-3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);
                $whereCaja = str_replace('_', ' OR t100.idcaja = ', $idcaja);

				$SQLQuery = "SELECT t100.trannum, t100.numero, DATE_FORMAT(t100.fecha, '%d') AS dfecha, (t100.valventan + t100.valtax1) AS ventatotal, tran_100dte.cgeneracion, tran_100dte.srecepcion
                FROM tran_100 AS t100
                INNER JOIN tran_100dte ON t100.trannum = tran_100dte.trannum 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) ". (($idcaja != '') ? "AND (t100.idcaja = $whereCaja)" : "" ) ." AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                AND ($subconsulta) AND (t100.serie != '') AND (t100.numero != 0)
                GROUP BY t100.trannum
                ORDER BY t100.fecha, t100.numero ASC";
				$Query = $this->db_b->query($SQLQuery);
				$resultado = $Query->result();

				return $resultado;
			}
		}

        public function getVentasCreditoFiscalExcel($fechaini,$fechafin,$idcentro,$idcaja,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot   = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr($subconsulta, 0, strlen($subconsulta)-3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);
                $whereCaja = str_replace('_', ' OR t100.idcaja = ', $idcaja);

				$SQLQuery = "SELECT t100.trannum, t100.numero, DATE_FORMAT(t100.fecha, '%d') AS dfecha, (t100.valventan + t100.valtax1) AS ventatotal, t100.valventan AS subtotal, t100.valtax1 AS iva, 
                tran_100dte.cgeneracion, tran_100dte.srecepcion, ctauxi.descrip, ctauxi.nrc
                FROM tran_100 AS t100
                INNER JOIN tran_100dte ON t100.trannum = tran_100dte.trannum 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN ctauxi ON ctauxi.idauxi = t100.idcps
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) ". (($idcaja != '') ? "AND (t100.idcaja = $whereCaja)" : "" ) ." AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                AND ($subconsulta) AND (t100.serie != '') AND (t100.numero != 0)
                ORDER BY t100.fecha, t100.numero ASC";
				$Query = $this->db_b->query($SQLQuery);
				$resultado = $Query->result();

				return $resultado;
			}
		}
		
        public function getVentasCGoIva($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot   = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr($subconsulta, 0, strlen($subconsulta)-3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);

				$SQLQuery = "SELECT t100.trannum, invdef.exento, invsites.xpos AS idcenxpos, invdef.notas AS idclaxpos, ctcajas.xpos AS idcajxpos, t100.serie, t100.numero, ctaucli.nrc, ctaucli.descrip AS namecliente,
                    t100.fecha, t100.numz, ctaucli.nit,  ctaucli.direccion, IFNULL(gzips.municipio, '') AS municipio, IFNULL(gzips.depto, '') AS departamento, ctaucli.giro
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                LEFT JOIN gzips ON ctaucli.idzip = gzips.idzip
                INNER JOIN invsites ON invsites.idcentro = t100.idcentro
                INNER JOIN ctcajas ON ctcajas.idcaja = t100.idcaja
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                AND ($subconsulta) AND (t100.serie != '') AND (t100.numero != 0)
                GROUP BY t100.trannum
                ORDER BY t100.fecha, t100.numero ASC";
				$Query = $this->db_b->query($SQLQuery);
				$resultado = $Query->result();

				return $resultado;
			}
		}
        
		public function getVentasContribuyentes($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta="";
                
                $array = explode(",", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);
                
                $consulta = "SELECT invsites.xpos AS idcentro, ctcajas.xpos AS idcaja, invdef.xpos AS clase, t100.numz, t100.trannum, t100.fecha, t100.estatus,
                CONCAT(t100.serie, t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, invdef.caopera, invdef.ivabook, invdef.exento, invdef.descrip AS tipodoc,
                ctaucli.descrip AS namecliente, ctaucli.nrc, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, ctaucli.dui,
                t100.valtax1, t100.valtax5, ctaucli.nit, ctaucli.giro, ctaucli.direccion, IFNULL(gzips.municipio, '') AS municipio, IFNULL(gzips.depto, '') AS departamento,
                invsites.xpos AS idcenxpos, invdef.notas AS idclaxpos, ctcajas.xpos AS idcajxpos, ctcajas.equipo, t100.referencia, gnums.resolucion 
                FROM tran_100 AS t100 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                INNER JOIN gnums ON invdef.numgrupo = gnums.numgrupo AND gnums.serie = t100.serie AND t100.idcentro = gnums.idcentro
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                INNER JOIN invsites ON invsites.idcentro = t100.idcentro
                INNER JOIN ctcajas ON ctcajas.idcaja = t100.idcaja
                LEFT JOIN gzips ON ctaucli.idzip = gzips.idzip
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                AND (numero > 0) AND ($subconsulta)
                ORDER BY t100.fecha , t100.numero";
                
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
        
        public function getVentasReporte($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);
				
                $consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie, CONCAT(t100.serie, t100.numero) AS primero, CONCAT(t100.serie, t100.numero) AS ultimo, t100.serie, t100.numero, t100.idclase, invdef.invclase, 
                invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.nrc, ctaucli.idtipo, ctauemp.descrip AS namevendedor, SUM(t100.valventan) AS valventan, SUM(t100.valtax1) AS valtax1, SUM(t100.valtax5) AS retencion, invdef.invclase as iddoc
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus=9) AND (numero > 0) AND ($subconsulta)
                GROUP BY numeroserie, t100.idclase, t100.estatus
                ORDER BY t100.fecha,t100.numero ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
        }
        
        public function getVentasReporteLulaMena($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

                $listSucursales="";
                if(is_array($idcentro)){
                    $totidS=count($idcentro);
                    for($j=0; $j<$totidS; $j++){
                        $listSucursales .= " t100.idcentro  = $idcentro[$j]  OR "; 
                    }
                    $listSucursales = substr ($listSucursales, 0, strlen($listSucursales) - 3);
                }else{
                    $listSucursales.= " t100.idcentro = $idcentro ";
                }

				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie, CONCAT(t100.serie, t100.numero) AS primero, CONCAT(t100.serie, t100.numero) AS ultimo, t100.serie, t100.numero, t100.idclase, invdef.invclase, invdef.exento, 
                invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.nrc, ctaucli.idtipo, ctauemp.descrip AS namevendedor, SUM(t100.valventan) AS valventan, SUM(t100.valtax1) AS valtax1, SUM(t100.valtax5) AS retencion, invdef.invclase as iddoc 
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND ($listSucursales) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus=9) AND (numero > 0) AND ($subconsulta)
                GROUP BY numeroserie, t100.idclase, t100.estatus
                ORDER BY t100.fecha,t100.numero ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
			}
		}
        
        public function getVentasReporteT($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

                $whereCentro = str_replace('_', ' OR t100.idcentro = ', $idcentro);
				
                $consulta = "SELECT  t100.trannum, t100.fecha, t100.estatus, t100.idclase, invdef.invclase as iddoc, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente,
                ctaucli.nrc, ctaucli.idtipo, ctauemp.descrip AS namevendedor, SUM(t100.valventan) AS valventan, SUM(t100.valtax1)  AS valtax1, invdef.inopera
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND (t100.idcentro = $whereCentro) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND ($subconsulta)
                GROUP BY invdef.exento,invdef.inopera,invdef.invclase,t100.trannum";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
			}
        }
        
        public function getVentasReporteTLulaMena($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

                $listSucursales="";
                if(is_array($idcentro)){
                    $totidS=count($idcentro);
                    for($j=0; $j<$totidS; $j++){
                        $listSucursales .= " t100.idcentro  = $idcentro[$j]  OR "; 
                    }
                    $listSucursales = substr ($listSucursales, 0, strlen($listSucursales) - 3);
                }else{
                    $listSucursales.= " t100.idcentro = $idcentro ";
                }

				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, t100.idclase, invdef.invclase as iddoc, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, 
                ctaucli.descrip AS namecliente, ctaucli.nrc, ctaucli.idtipo, ctauemp.descrip AS namevendedor, SUM(t100.valventan) AS valventan, SUM(t100.valtax1)  AS valtax1, invdef.inopera
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND ($listSucursales) AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND ($subconsulta)
                GROUP BY invdef.exento,invdef.inopera,invdef.invclase,t100.trannum";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
			}
		}
        
        public function getVentasReporteCT($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, invdef.invclase as iddoc, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente,
                ctaucli.nrc, ctaucli.idtipo, invdef.ivabook, ctauemp.descrip AS namevendedor, SUM(t100.valventan)AS valventan, SUM(t100.valtax1) AS valtax1, invdef.inopera
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND ($subconsulta)
                GROUP BY invdef.exento, invdef.ivabook, invdef.inopera,invdef.invclase";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
			}
		}
        
        public function getVentasReporteCT2($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode("_", $formatos);
                $tot = count($array);
                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

				$consulta = "SELECT  t100.trannum, t100.fecha, t100.estatus, invdef.invclase as iddoc, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente,
                ctaucli.nrc, ctaucli.idtipo, invdef.ivabook, ctauemp.descrip AS namevendedor, SUM(t100.valventan)AS valventan, SUM(t100.valtax1) AS valtax1, invdef.inopera
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9) AND ($subconsulta)
                GROUP BY t100.trannum";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();

				return $resultado;
			}
		}
        
        public function getVentasReporteAll($fechaini,$fechafin,$idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                
				$consulta = "SELECT t100.trannum, t100.fecha, t100.estatus, invdef.invclase as iddoc, t100.serie, t100.numero, invdef.invclase, invdef.exento, invdef.numtipo, invdef.ivaopera, invdef.descrip AS tipodoc, 
                ctaucli.descrip AS namecliente, ctaucli.nrc, ctaucli.idtipo, invdef.ivabook, ctauemp.descrip AS namevendedor, SUM(t100.valventan)AS valventan, SUM(t100.valtax1) AS valtax1, invdef.inopera
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN  ctauxi  AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi  AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE invdef.agrupa = 'VN' AND t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 OR t100.estatus = 9)
                GROUP BY t100.trannum";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
                return $resultado;
			}
		}
        
        public function getComprasContribuyentes($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

				$SQL = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase, t100.referencia, t100.ovnumero,
                    invdef.exento, invdef.descrip AS tipodoc, ctaucli.descrip AS namecliente, ctaucli.nrc, ctauemp.descrip AS namevendedor, SUM(t100.valcosto) AS valcosto, ctaucli.dui, 
                    SUM(t100.valtax1) AS valtax1, SUM(t100.valtax5) AS valtax5, ctaucli.nit, ctaucli.giro, ctaucli.direccion, IFNULL(gzips.municipio, '') AS municipio, IFNULL(gzips.depto, '') AS departamento,
                    invsites.xpos AS idcenxpos, invdef.notas AS idclaxpos, invdef.ivabook 
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                LEFT JOIN gzips ON ctaucli.idzip = gzips.idzip
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                INNER JOIN invsites ON t100.idcentro = invsites.idcentro
                WHERE t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 ) AND ($subconsulta)
                GROUP BY t100.serie, t100.numero, t100.idcps
                ORDER BY t100.fecha, t100.numero";
                
                $query = $this->db_b->query($SQL);
                $resultado = $query->result();
                
				return $resultado;
			}
		}

        public function getComprasContribuyentesIva($fechaini,$fechafin,$idcentro,$formatos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $subconsulta = "";
                $array = explode(",", $formatos);
                $tot = count($array);

                if($tot==0 && trim($formatos)!=""){
                    $subconsulta .= " invdef.invclase = $formatos ";
                }else{
                    for($i=0; $i<$tot; $i++){
                        $subconsulta .= " invdef.invclase  = $array[$i]  OR "; 
                    }
                    $subconsulta = substr ($subconsulta, 0, strlen($subconsulta) - 3);
                }

				$SQL = "SELECT t100.trannum, t100.fecha, t100.estatus, CONCAT(t100.serie, t100.numero) AS numeroserie, t100.serie, t100.numero, invdef.invclase,  
                    invdef.exento, SUM(t100.valcosto) AS valcosto, SUM(t100.valtax1) AS valtax1, ctaucli.nrc, invdef.descrip AS tipodoc,
                    ctaucli.descrip AS namecliente, ctauemp.descrip AS namevendedor
                FROM tran_100 AS t100
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                WHERE t100.idcentro = $idcentro AND fecha BETWEEN '$fechaini' AND '$fechafin' AND (t100.estatus = 1 ) AND ($subconsulta)
                GROUP BY t100.serie, t100.numero, t100.idcps
                ORDER BY t100.fecha, t100.numero";
                
                $query = $this->db_b->query($SQL);
                $resultado = $query->result();
                
				return $resultado;
			}
		}

        public function getPeriodosIVA(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select("ivperiodo, idano, idmes, cofechaini, cofechafin, notas");
                $this->db_b->from("ivperiodos");
                //$this->db_b->where('estado', 1);
                //$this->db_b->group_by("idano");
                $this->db_b->order_by("idano DESC, idmes ASC");
                $informacion = $this->db_b->get();
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'idano'      => $info->idano,
                            'idmes'      => $info->idmes,
                            'namemes'    => $this->getNameMesIVA($info->idmes),
                            'descrip'    => $info->idano,
                            'notas'      => $info->notas,
                            'cofechaini' => $info->cofechaini,
                            'cofechafin' => $info->cofechafin,
                            'ivperiodo'  => $info->ivperiodo,
                        );
                    }
                }
                return $array;
            }
        }

        public function getNameMesIVA($i){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                switch ($i) {
                    case  1:
                        return "Enero";
                        break;
                    case  2:
                        return "Febrero";
                        break;
                    case  3:
                        return "Marzo";
                        break;
                    case  4:
                        return "Abril";
                        break;
                    case  5:
                        return "Mayo";
                        break;
                    case  6:
                        return "Junio";
                        break;
                    case  7:
                        return "Julio";
                        break;
                    case  8:
                        return "Agosto";
                        break;
                    case  9:
                        return "Septiembre";
                        break;
                    case 10:
                        return "Octubre";
                        break;
                    case 11:
                        return "Noviembre";
                        break;
                    case 12:
                        return "Diciembre";
                        break;
                }
            }
        }

        public function insertPeriodo($namePeriodo, $notaPeriodo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                if($this->db_b->where("idano", $namePeriodo)->get("ivperiodos")->num_rows() == 0){

                    for($i=0; $i<12; $i++){
                        $day = date("d", mktime(0,0,0, $i+2, 0, $namePeriodo));

                        $fechaini = date('Y-m-d', mktime(0,0,0, $i+1,    1, $namePeriodo));
                        $fechafin = date('Y-m-d', mktime(0,0,0, $i+1, $day, $namePeriodo));

                        $this->db_b->set('idano',   $namePeriodo);
                        $this->db_b->set('idmes',   $i + 1);
                        $this->db_b->set('cofechaini', $fechaini);
                        $this->db_b->set('cofechafin', $fechafin);
                        $this->db_b->set('estado',  1);
                        $this->db_b->set('notas',   $notaPeriodo);
                        $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                        $this->db_b->insert('ivperiodos');
                    }

                    $SQLTable = "CREATE TABLE IF NOT EXISTS iva_$namePeriodo LIKE iva_table";
                    $this->db_b->query($SQLTable);

                    return true;

                } else return false;
            }
        }
        
        public function updatePeriodo($ivPeriodo, $namePeriodo, $notaPeriodo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->set('idano',    $namePeriodo);
                $this->db_b->set('notas',    $notaPeriodo);
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('ivperiodo', $ivPeriodo);
                $this->db_b->update('ivperiodos');

                return true;
            }
        }
        
        public function deletePeriodo($ivPeriodo, $namePeriodo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->set('idano',    $namePeriodo);
                $this->db_b->set('notas',    $notaPeriodo);
                $this->db_b->set('modifica', date("Y-m-d H:i:s"));
                $this->db_b->where('ivperiodo', $ivPeriodo);
                $this->db_b->update('ivperiodos');

                return true;
            }
        }

        public function getDatosDocumentosOld($idano, $idanomes, $idlibro, $dteDoc = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{

                $filedExist = $this->checkIfDocClaseFieldExists($idano);

                $this->db_b->select('a.idrec, a.fecha, a.doc_fecha, a.ivclase, a.idcentro, a.idcaja, a.doc_res, a.doc_serie, a.doc_numero, a.doc_funico, a.doc_clase, a.referencia, a.idcps, a.estatus, a.notas');
                $this->db_b->select('a.valor0, a.valor1, a.valor2, a.valor3, a.valor4, a.valor5, a.valor6, a.valor7, a.valor8, a.valor9, a.valor10, a.valor11, a.valor12, a.valor13, a.valor14, a.valor15, a.valor16, a.valor17, a.valor18, a.valor19, a.valor20');
                $this->db_b->select('b.doc_tipo, b.descrip AS nameDocumento, c.descrip AS nameSucursal, d.descrip AS nameCaja, CONCAT(a.doc_serie, a.doc_numero) AS numeroSerie, e.descrip AS nameContribuyente, e.correo AS emailCliente, e.dui as duiContribuyente, e.nrc as nrcContribuyente, e.nit as nitContribuyente');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT idrec FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "DOC" AND estatus = 1), "") AS idDTE');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT ncontrol FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "DOC" AND estatus = 1), "") AS ncontrol');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT cgeneracion FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "DOC"), "") AS cgeneracion');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT srecepcion FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "DOC" AND estatus = 1), "") AS srecepcion');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT estatus FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "DOC"), "") AS estadoDte');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT idrec FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "ANULA" AND estatus = 1), "") AS idDTEA');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT ncontrol FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "ANULA" AND estatus = 1), "") AS ncontrolA');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT cgeneracion FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "ANULA" AND estatus = 1), "") AS cgeneracionA');
                if ( $dteDoc == 1 || $filedExist == true ) $this->db_b->select('IFNULL((SELECT srecepcion FROM tran_100dte f WHERE IF(a.tranref = 0, (f.trannum=a.idrec AND f.o_table="iva_'.$idano.'"), (f.trannum = a.tranref AND f.o_table = "tran_100")) AND type = "ANULA" AND estatus = 1), "") AS srecepcionA');
                if ( $filedExist == true ) $this->db_b->select('a.doc_tipo AS docTipo');
                $this->db_b->select('SUM(a.valor0 + a.valor1 + a.valor2 + a.valor3 + a.valor4 + a.valor5 + a.valor6 + a.valor7 + a.valor8 + a.valor9 + a.valor10 + a.valor11 + a.valor12 + a.valor13 + a.valor14 + valor15 + valor16 + valor17 + valor18 + valor19 + valor20) AS valorTotal, g.esticket');
                //$this->db_b->select('SUM(a.valor0 + a.valor1 + a.valor2 + a.valor3 + a.valor4 + a.valor5 + a.valor6 + a.valor7 + a.valor8 + a.valor9 + a.valor10 + a.valor11 + a.valor12 + a.valor13 + a.valor14 + valor15 + valor16 + valor17 + valor18 + valor19 + valor20) AS valorTotal');
                $this->db_b->from('iva_'.$idano.' a');
                $this->db_b->join('iva_def  b', 'a.ivclase = b.ivclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi');
                $this->db_b->join('inv_def  g', 'b.invclase = g.invclase', 'left');
                $this->db_b->where('a.idanomes', $idanomes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.estatus',  1);
                if ( $dteDoc == 1 && $idlibro == 3 ) $this->db_b->where('(b.doc_tipo = 7 OR b.doc_tipo = 14 OR b.doc_tipo = 13)');
                $this->db_b->group_by("a.idrec");
                $this->db_b->order_by("a.idrec", "DESC");
                $informacion = $this->db_b->get();
            
                $docsDontHaveDocClase = [];

                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $tipoDocumento = 'Documento Físico';
                        $tipoOperacion = ''; $tipoClasificacion = '';
                        $tipoSector = ''; $tipoCosto = ''; $tipoOperacionRenta = ''; $tipoIngresoRenta = '';
                        $esTicket = (int) $info->esticket;

                        if($filedExist == true ){
                            if($info->docTipo == 1){
                                $tipoDocumento = 'Documento Electrónico';
                            }
                        }

                        if(isset($info->doc_clase)){
                            if($info->doc_clase != '' && $info->doc_clase != 'false'){
                                $items = explode(",", $info->doc_clase);
                                if ($idlibro == 3) {
                                    $tipoOperacion      = $this->getDescripVariableByValue('iva_tipoo', $items[0]);
                                    $tipoClasificacion  = $this->getDescripVariableByValue('iva_clas',  $items[1]);
                                    $tipoSector         = $this->getDescripVariableByValue('iva_sect',  $items[2]);
                                    $tipoCosto          = $this->getDescripVariableByValue('iva_tipoc', $items[3]);
                                } elseif ($idlibro == 1 || $idlibro == 2){
                                    $tipoOperacionRenta = $this->getDescripVariableByValue('iva_tipoo_renta',  $items[0]);
                                    $tipoIngresoRenta   = $this->getDescripVariableByValue('iva_tipoi_renta', $items[1]);
                                }
                            } else {
                                if ($idlibro == 1 || $idlibro == 2 && $tipoDocumento == 'Documento Electrónico') {
                                    if ($esTicket != 1) {
                                        array_push($docsDontHaveDocClase, (int) $info->idrec);
                                    }
                                }
                            }
                        }

                        if($filedExist == true ){
                            if ($info->docTipo == 1) {
                                $numeroDocumento = ( $dteDoc == 1 || $filedExist == true ) ? $info->cgeneracion : '';
                            } else {
                                $numeroDocumento = $info->numeroSerie;
                            }
                        } else {
                            $numeroDocumento = $info->numeroSerie;
                        }

                        $array[] = array(
                            'idrec'              => (int) $info->idrec,
                            'fecha'              => $info->fecha,
                            'doc_fecha'          => $info->doc_fecha,
                            'ivclase'            => (int) $info->ivclase,
                            'doc_tipo'           => (int) $info->doc_tipo,
                            'idcentro'           => (int) $info->idcentro,
                            'idcaja'             => (int) $info->idcaja,
                            'doc_res'            => $info->doc_res,
                            'doc_serie'          => $info->doc_serie,
                            'doc_numero'         => $info->doc_numero,
                            'doc_funico'         => $info->doc_funico,
                            'doc_clase'          => (isset($info->doc_clase)) ? $info->doc_clase : '',
                            'referencia'         => $info->referencia,
                            'idcps'              => (int) $info->idcps,
                            'valor0'             => $info->valor0,
                            'valor1'             => $info->valor1,
                            'valor2'             => $info->valor2,
                            'valor3'             => $info->valor3,
                            'valor4'             => $info->valor4,
                            'valor5'             => $info->valor5,
                            'valor6'             => $info->valor6,
                            'valor7'             => $info->valor7,
                            'valor8'             => $info->valor8,
                            'valor9'             => $info->valor9,
                            'valor10'            => $info->valor10,
                            'valor11'            => $info->valor11,
                            'valor12'            => $info->valor12,
                            'valor13'            => $info->valor13,
                            'valor14'            => $info->valor14,
                            'valor15'            => $info->valor15,
                            'valor16'            => $info->valor16,
                            'valor17'            => $info->valor17,
                            'valor18'            => $info->valor18,
                            'valor19'            => $info->valor19,
                            'valor20'            => $info->valor20,
                            'estatus'            => $info->estatus,
                            'notas'              => $info->notas,
                            'nameDocumento'      => $info->nameDocumento,
                            'nameSucursal'       => $info->nameSucursal,
                            'nameCaja'           => $info->nameCaja,
                            'numeroSerie'        => $numeroDocumento,
                            'nameContribuyente'  => $info->nameContribuyente,
                            'duiContribuyente'   => $info->duiContribuyente,
                            'nrcContribuyente'   => $info->nrcContribuyente,
                            'nitContribuyente'   => $info->nitContribuyente,
                            'valorTotal'         => $info->valorTotal,
                            'estatusDte'         => ( $dteDoc == 1 || $filedExist == true ) ? ($info->cgeneracion != '' && $info->estadoDte == 9) ? 'ANULADO' : ($info->cgeneracion != '' ? 'PROCESADO' : 'PENDIENTE') : 0,
                            'estadoDte'          => ( $dteDoc == 1 || $filedExist == true ) ? $info->estadoDte : 0,
                            'idDTE'              => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->idDTEA : $info->idDTE) : 0,
                            'ncontrol'           => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->ncontrolA : $info->ncontrol) : '',
                            'cgeneracion'        => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->cgeneracionA : $info->cgeneracion) : '',
                            'srecepcion'         => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->srecepcionA : $info->srecepcion)  : '',
                            'docTipo'            => ($filedExist == true ) ? $info->docTipo  : '',
                            'emailCliente'       => $info->emailCliente,
                            'tipoOperacion'      => $tipoOperacion,
                            'tipoClasificacion'   => $tipoClasificacion,
                            'tipoSector'         => $tipoSector,
                            'tipoCosto'          => $tipoCosto,
                            'tipoDeDocumento'    => $tipoDocumento,
                            'tipoOperacionRenta' => $tipoOperacionRenta,
                            'tipoIngresoRenta'   => $tipoIngresoRenta,
                            'esTicket'           => $esTicket
                        );
                    }

                    array_push($array, array('docsWithNoDocClase' => $docsDontHaveDocClase));

                    return $array;
                } return false;
            }
        }

        public function getDatosDocumentos($idano, $idanomes, $idlibro, $dteDoc = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{

                $filedExist = $this->checkIfDocClaseFieldExists($idano);//

                // Selección principal
                $this->db_b->select('
                a.idrec, a.fecha, a.doc_fecha, a.ivclase, a.idcentro, a.idcaja, a.doc_res, 
                a.doc_serie, a.doc_numero, a.doc_funico, a.doc_clase, a.referencia, a.idcps, 
                a.estatus, a.notas,
                a.valor0, a.valor1, a.valor2, a.valor3, a.valor4, a.valor5, a.valor6, a.valor7, a.valor8, a.valor9,
                a.valor10, a.valor11, a.valor12, a.valor13, a.valor14, a.valor15, a.valor16, a.valor17, a.valor18, a.valor19, a.valor20,
                b.doc_tipo, b.descrip AS nameDocumento,
                c.descrip AS nameSucursal,
                d.descrip AS nameCaja,
                CONCAT(a.doc_serie, a.doc_numero) AS numeroSerie,
                e.descrip AS nameContribuyente, e.correo AS emailCliente, e.dui as duiContribuyente, 
                e.nrc as nrcContribuyente, e.nit as nitContribuyente,
                COALESCE(f_doc_0.idrec, f_doc_ref.idrec, "") AS idDTE,
                COALESCE(f_doc_0.ncontrol, f_doc_ref.ncontrol, "") AS ncontrol,
                COALESCE(f_doc_0.cgeneracion, f_doc_ref.cgeneracion, "") AS cgeneracion,
                COALESCE(f_doc_0.srecepcion, f_doc_ref.srecepcion, "") AS srecepcion,
                COALESCE(f_doc_0.estatus, f_doc_ref.estatus, "") AS estadoDte,
                COALESCE(f_anula_0.idrec, f_anula_ref.idrec, "") AS idDTEA,
                COALESCE(f_anula_0.ncontrol, f_anula_ref.ncontrol, "") AS ncontrolA,
                COALESCE(f_anula_0.cgeneracion, f_anula_ref.cgeneracion, "") AS cgeneracionA,
                COALESCE(f_anula_0.srecepcion, f_anula_ref.srecepcion, "") AS srecepcionA,
                (a.valor0 + a.valor1 + a.valor2 + a.valor3 + a.valor4 + a.valor5 + a.valor6 + a.valor7 + a.valor8 + a.valor9 +
                a.valor10 + a.valor11 + a.valor12 + a.valor13 + a.valor14 + a.valor15 + a.valor16 + a.valor17 + a.valor18 + a.valor19 + a.valor20) AS valorTotal,
                g.esticket
                ');

                // Agregar docTipo si $filedExist
                if ($filedExist == true) {
                $this->db_b->select('a.doc_tipo AS docTipo');
                }

                // Tablas principales
                $this->db_b->from("iva_{$idano} a");
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('ctauxi e', 'a.idcps = e.idauxi');
                $this->db_b->join('inv_def g', 'b.invclase = g.invclase', 'left');

                // JOIN para DTE tipo DOC (sin OR)
                if ($dteDoc == 1 || $filedExist == true) {
                $this->db_b->join("tran_100dte f_doc_0", "f_doc_0.trannum = a.idrec AND f_doc_0.o_table = 'iva_{$idano}' AND f_doc_0.type = 'DOC'", 'left');
                $this->db_b->join("tran_100dte f_doc_ref", "f_doc_ref.trannum = a.tranref AND f_doc_ref.o_table = 'tran_100' AND f_doc_ref.type = 'DOC'", 'left');

                // JOIN para DTE tipo ANULA (sin OR)
                $this->db_b->join("tran_100dte f_anula_0", "f_anula_0.trannum = a.idrec AND f_anula_0.o_table = 'iva_{$idano}' AND f_anula_0.type = 'ANULA' AND f_anula_0.estatus = 1", 'left');
                $this->db_b->join("tran_100dte f_anula_ref", "f_anula_ref.trannum = a.tranref AND f_anula_ref.o_table = 'tran_100' AND f_anula_ref.type = 'ANULA' AND f_anula_ref.estatus = 1", 'left');
                }

                // Filtros principales
                $this->db_b->where('a.idanomes', $idanomes);
                $this->db_b->where('a.idlibro', $idlibro);
                $this->db_b->where('a.estatus', 1);

                // Condición especial para libro 3 y DTE
                if ($dteDoc == 1 && $idlibro == 3) {
                $this->db_b->where('(b.doc_tipo = 7 OR b.doc_tipo = 14 OR b.doc_tipo = 13)');
                }

                // Agrupación y orden
                $this->db_b->group_by('a.idrec');
                $this->db_b->order_by('a.idrec', 'DESC');

                // Ejecutar consulta
                $informacion = $this->db_b->get();
            
                $docsDontHaveDocClase = [];

                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $tipoDocumento = 'Documento Físico';
                        $tipoOperacion = ''; $tipoClasificacion = '';
                        $tipoSector = ''; $tipoCosto = ''; $tipoOperacionRenta = ''; $tipoIngresoRenta = '';
                        $esTicket = (int) $info->esticket;

                        if($filedExist == true ){
                            if($info->docTipo == 1){
                                $tipoDocumento = 'Documento Electrónico';
                            }
                        }

                        if(isset($info->doc_clase)){
                            if($info->doc_clase != '' && $info->doc_clase != 'false'){
                                $items = explode(",", $info->doc_clase);
                                if ($idlibro == 3) {
                                    $tipoOperacion      = $this->getDescripVariableByValue('iva_tipoo', $items[0]);
                                    $tipoClasificacion  = $this->getDescripVariableByValue('iva_clas',  $items[1]);
                                    $tipoSector         = $this->getDescripVariableByValue('iva_sect',  $items[2]);
                                    $tipoCosto          = $this->getDescripVariableByValue('iva_tipoc', $items[3]);
                                } elseif ($idlibro == 1 || $idlibro == 2){
                                    $tipoOperacionRenta = $this->getDescripVariableByValue('iva_tipoo_renta',  $items[0]);
                                    $tipoIngresoRenta   = $this->getDescripVariableByValue('iva_tipoi_renta', $items[1]);
                                }
                            } else {
                                if ($idlibro == 1 || $idlibro == 2 && $tipoDocumento == 'Documento Electrónico') {
                                    if ($esTicket != 1) {
                                        array_push($docsDontHaveDocClase, (int) $info->idrec);
                                    }
                                }
                            }
                        }

                        if($filedExist == true ){
                            if ($info->docTipo == 1) {
                                $numeroDocumento = ( $dteDoc == 1 || $filedExist == true ) ? $info->cgeneracion : '';
                            } else {
                                $numeroDocumento = $info->numeroSerie;
                            }
                        } else {
                            $numeroDocumento = $info->numeroSerie;
                        }

                        $array[] = array(
                            'idrec'              => (int) $info->idrec,
                            'fecha'              => $info->fecha,
                            'doc_fecha'          => $info->doc_fecha,
                            'ivclase'            => (int) $info->ivclase,
                            'doc_tipo'           => (int) $info->doc_tipo,
                            'idcentro'           => (int) $info->idcentro,
                            'idcaja'             => (int) $info->idcaja,
                            'doc_res'            => $info->doc_res,
                            'doc_serie'          => $info->doc_serie,
                            'doc_numero'         => $info->doc_numero,
                            'doc_funico'         => $info->doc_funico,
                            'doc_clase'          => (isset($info->doc_clase)) ? $info->doc_clase : '',
                            'referencia'         => $info->referencia,
                            'idcps'              => (int) $info->idcps,
                            'valor0'             => $info->valor0,
                            'valor1'             => $info->valor1,
                            'valor2'             => $info->valor2,
                            'valor3'             => $info->valor3,
                            'valor4'             => $info->valor4,
                            'valor5'             => $info->valor5,
                            'valor6'             => $info->valor6,
                            'valor7'             => $info->valor7,
                            'valor8'             => $info->valor8,
                            'valor9'             => $info->valor9,
                            'valor10'            => $info->valor10,
                            'valor11'            => $info->valor11,
                            'valor12'            => $info->valor12,
                            'valor13'            => $info->valor13,
                            'valor14'            => $info->valor14,
                            'valor15'            => $info->valor15,
                            'valor16'            => $info->valor16,
                            'valor17'            => $info->valor17,
                            'valor18'            => $info->valor18,
                            'valor19'            => $info->valor19,
                            'valor20'            => $info->valor20,
                            'estatus'            => $info->estatus,
                            'notas'              => $info->notas,
                            'nameDocumento'      => $info->nameDocumento,
                            'nameSucursal'       => $info->nameSucursal,
                            'nameCaja'           => $info->nameCaja,
                            'numeroSerie'        => $numeroDocumento,
                            'nameContribuyente'  => $info->nameContribuyente,
                            'duiContribuyente'   => $info->duiContribuyente,
                            'nrcContribuyente'   => $info->nrcContribuyente,
                            'nitContribuyente'   => $info->nitContribuyente,
                            'valorTotal'         => $info->valorTotal,
                            'estatusDte'         => ( $dteDoc == 1 || $filedExist == true ) ? ($info->cgeneracion != '' && $info->estadoDte == 9) ? 'ANULADO' : ($info->cgeneracion != '' ? 'PROCESADO' : 'PENDIENTE') : 0,
                            'estadoDte'          => ( $dteDoc == 1 || $filedExist == true ) ? $info->estadoDte : 0,
                            'idDTE'              => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->idDTEA : $info->idDTE) : 0,
                            'ncontrol'           => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->ncontrolA : $info->ncontrol) : '',
                            'cgeneracion'        => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->cgeneracionA : $info->cgeneracion) : '',
                            'srecepcion'         => ( $dteDoc == 1 || $filedExist == true ) ? (($info->estadoDte == 9) ? $info->srecepcionA : $info->srecepcion)  : '',
                            'docTipo'            => ($filedExist == true ) ? $info->docTipo  : '',
                            'emailCliente'       => $info->emailCliente,
                            'tipoOperacion'      => $tipoOperacion,
                            'tipoClasificacion'   => $tipoClasificacion,
                            'tipoSector'         => $tipoSector,
                            'tipoCosto'          => $tipoCosto,
                            'tipoDeDocumento'    => $tipoDocumento,
                            'tipoOperacionRenta' => $tipoOperacionRenta,
                            'tipoIngresoRenta'   => $tipoIngresoRenta,
                            'esTicket'           => $esTicket
                        );
                    }

                    array_push($array, array('docsWithNoDocClase' => $docsDontHaveDocClase));

                    return $array;
                } return false;
            }
        }

        public function getDocumentosLibro($idLibro, $dteDocumen = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select("*");
                $this->db_b->from("iva_def");
                $this->db_b->where('idlibro', $idLibro);
                if ($dteDocumen == 1 && $idLibro == 3) $this->db_b->where('(doc_tipo = 7 OR doc_tipo = 14 OR doc_tipo = 13)');
                $this->db_b->where('estatus', 1);
                $this->db_b->order_by("descrip", "ASC");
                $informacion = $this->db_b->get();
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'id'        => (int) $info->ivclase,
                            'descrip'   => $info->descrip,
                            'idlibro'   => (int) $info->idlibro,
                            'doc_clase' => (int) $info->doc_clase,
                            'doc_tipo'  => (int) $info->doc_tipo,
                            'ivopera'   => (int) $info->ivopera,
                            'asknit'    => (int) $info->asknit,
                            'askres'    => (int) $info->askres,
                            'askserie'  => (int) $info->askserie,
                            'askcentro' => (int) $info->askcentro,
                            'askcaja'   => (int) $info->askcaja,
                            'askfunico' => (int) $info->askfunico,
                            'askref'    => (int) $info->askref,
                            'tasaiva'   => (int) $info->tasaiva,
                            'tasarp'    => (int) $info->tasarp,
                            'invclase'  => (int) $info->invclase,
                            'idauxidef' => $info->idauxidef,
                            'adays'     => $info->adays,
                            'ausers'    => $info->ausers,
                            'xpos'      => $info->xpos
                        );
                    }
                }
                return $array;
            }
        }
        
        public function getDocumentosLibroImport($idLibro, $isTicket){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('a.*');
                $this->db_b->from('iva_def a');
                $this->db_b->join('inv_def b', 'a.invclase = b.invclase');
                $this->db_b->where('a.idlibro', $idLibro);
                $this->db_b->where('a.estatus', 1);
                $this->db_b->where('a.invclase !=', 0);
                if ($isTicket != 2) {
                    $this->db_b->where('b.esticket', $isTicket);
                    ($idLibro == 3) ? $this->db_b->where('b.agrupa', 'CO') : $this->db_b->where('b.agrupa', 'VN');
                } else {
                    $this->db_b->where('b.agrupa', 'GA');
                }
                $this->db_b->order_by('descrip', 'ASC');
                $informacion = $this->db_b->get();
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'id'        => (int) $info->ivclase,
                            'descrip'   => $info->descrip,
                            'idlibro'   => (int) $info->idlibro,
                            'doc_clase' => (int) $info->doc_clase,
                            'doc_tipo'  => (int) $info->doc_tipo,
                            'ivopera'   => (int) $info->ivopera,
                            'asknit'    => (int) $info->asknit,
                            'askres'    => (int) $info->askres,
                            'askserie'  => (int) $info->askserie,
                            'askcentro' => (int) $info->askcentro,
                            'askcaja'   => (int) $info->askcaja,
                            'askfunico' => (int) $info->askfunico,
                            'askref'    => (int) $info->askref,
                            'tasaiva'   => (int) $info->tasaiva,
                            'tasarp'    => (int) $info->tasarp,
                            'invclase'  => (int) $info->invclase,
                            'idauxidef' => $info->idauxidef,
                            'adays'     => $info->adays,
                            'ausers'    => $info->ausers,
                            'xpos'      => $info->xpos
                        );
                    }
                }
                return $array;
            }
        }
        
        public function getDocumentosLibroCSV($idLibro, $dteDocumen = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('a.*');
                $this->db_b->from('iva_def a');
                $this->db_b->where('a.idlibro', $idLibro);
                $this->db_b->where('a.estatus', 1);
                if ($dteDocumen == 1 && $idLibro == 3) $this->db_b->where('(a.doc_tipo = 7 OR a.doc_tipo = 14 OR a.doc_tipo = 13)');
                $this->db_b->order_by('a.descrip', 'ASC');
                $informacion = $this->db_b->get();
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'id'        => (int) $info->ivclase,
                            'descrip'   => $info->descrip,
                            'idlibro'   => (int) $info->idlibro,
                            'doc_clase' => (int) $info->doc_clase,
                            'doc_tipo'  => (int) $info->doc_tipo,
                            'ivopera'   => (int) $info->ivopera,
                            'asknit'    => (int) $info->asknit,
                            'askres'    => (int) $info->askres,
                            'askserie'  => (int) $info->askserie,
                            'askcentro' => (int) $info->askcentro,
                            'askcaja'   => (int) $info->askcaja,
                            'askfunico' => (int) $info->askfunico,
                            'askref'    => (int) $info->askref,
                            'tasaiva'   => (int) $info->tasaiva,
                            'tasarp'    => (int) $info->tasarp,
                            'invclase'  => (int) $info->invclase,
                            'idauxidef' => $info->idauxidef,
                            'adays'     => $info->adays,
                            'ausers'    => $info->ausers,
                            'xpos'      => $info->xpos
                        );
                    }
                }
                return $array;
            }
        }

        public function getClientesProveedoresDocumentos($idauxidef){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $arrayCodigos = explode(",", $idauxidef);
                $textoFiltro  = 'idauxidef = '.implode(" OR idauxidef = ", $arrayCodigos);

                $this->db_b->select("idauxi, descrip, dui, nit, nrc, idtipo, idzip, giro, idauxidef, direccion");
                $this->db_b->from("ctauxi");
                $this->db_b->where("estado", 1);
                //$this->db_b->where("(nrc != '' OR nit != '')");
                $this->db_b->where('('.$textoFiltro.')');
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'        => (int)$info->idauxi,
                            'descrip'   => $info->descrip,
                            'dui'       => $info->dui,
                            'nit'       => $info->nit,
                            'nrc'       => $info->nrc,
                            'idtipo'    => (int)$info->idtipo,
                            'idzip'     => (int)$info->idzip,
                            'giro'      => $info->giro,
                            'idauxidef' => (int)$info->idauxidef,
                            'direccion' => $info->direccion
                        );
                    }
                }

                return $array;
            }
        }
        
        public function getGirosContribuyentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
                $this->db_b->select("TRIM(giro) AS giro");
                $this->db_b->from("ctauxi");
                $this->db_b->where("estado", 1);
                $this->db_b->group_by("giro");
                $this->db_b->order_by("giro", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = $info->giro;
                    }
                }

                return $array;
            }
        }

        public function getSucursalByCaja($idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idcentro");
                $this->db_b->from("ctcajas");
                $this->db_b->where("idcaja", $idcaja);
                $data = $this->db_b->get();
                
                if ($data->num_rows() > 0) {
                    return $data->row()->idcentro;
                } else return 0;
            }
        }

        public function getSucursalesDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idcentro, descrip");
                $this->db_b->from("invsites");
                $this->db_b->where("estatus", 1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'      => (int)$info->idcentro,
                            'descrip' => strtoupper($info->descrip)
                        );
                    }
                }

                return $array;
            }
        }
        
        public function getSucursalesDocumentoImport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("a.idcentro, a.idcaja, a.descrip AS nameCaja, b.descrip AS nameCentro");
                $this->db_b->from("ctcajas a");
                $this->db_b->join("invsites b", "a.idcentro = b.idcentro");
                $this->db_b->where("a.estatus", 1);
                $this->db_b->order_by("b.descrip", "ASC");
                $this->db_b->order_by("a.descrip", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'       => (int)$info->idcaja,
                            'idcentro' => (int)$info->idcentro,
                            'descrip'  => strtoupper($info->nameCentro).' / '.strtoupper($info->nameCaja)
                        );
                    }
                }

                return $array;
            }
        }

        public function getCajaSucursal($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idcaja, descrip");
                $this->db_b->from("ctcajas");
                $this->db_b->where("idcentro", $idcentro);
                $this->db_b->where("estatus",  1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'      => (int)$info->idcaja,
                            'descrip' => $info->descrip
                        );
                    }
                }

                return $array;
            }
        }

        public function getCamposFormulario($ivclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("*");
                $this->db_b->from("iva_forms");
                $this->db_b->where("ivclase", $ivclase);
                $this->db_b->where("estatus",  1);
                $this->db_b->order_by("orden", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'          => (int)$info->idrec,
                            'ivclase'     => (int)$info->ivclase,
                            'titulo'      => $info->titulo,
                            'askvalor'    => (int)$info->askvalor,
                            'requerido'   => (int)$info->requerido,
                            'valopera'    => (int)$info->valopera,
                            'minval'      => (int)$info->minval,
                            'maxval'      => (int)$info->maxval,
                            'controltype' => (int)$info->controltype,
                            'notas'       => $info->notas
                        );
                    }
                }

                return $array;
            }
        }

        public function getInfoResolucionSerie($idano, $idlibro, $ivclase, $idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("doc_res, doc_serie");
                $this->db_b->from("iva_".$idano);
                $this->db_b->where("idlibro", $idlibro);
                $this->db_b->where("ivclase", $ivclase);
                $this->db_b->where("idcps",   $idauxi);
                $this->db_b->order_by("doc_fecha", "DESC");
                $this->db_b->limit(1);
                $data = $this->db_b->get();
                
                if ($data->num_rows() > 0) {
                    $array = $data->row_array();
                } else $array = false;

                return $array;
            }
        }

        public function checkIfDocClaseFieldExists($tableYear){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->field_exists('doc_clase', 'iva_'.$tableYear);
            }
        }

        public function saveDatosDocumento($infoSource, $idano){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if($this->db_b->where("ivclase", $infoSource['ivclase'])->where("idcps", $infoSource['idcps'])->where("idlibro", $infoSource['idlibro'])->where("doc_serie", $infoSource['doc_serie'])->where("doc_numero", $infoSource['doc_numero'])->get("iva_".$idano)->num_rows() == 0){
                    if ($this->db_b->insert('iva_'.$idano, $infoSource)) return $this->db_b->insert_id();
                    else return false;
                } else return false;
            }
        }
        
        public function updateDatosDocumento($infoSource, $idano, $idrec, $doc_tipo = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if ($doc_tipo == 0) {
                    if($this->db_b->where("idrec !=", $idrec)->where("ivclase", $infoSource['ivclase'])->where("idcps", $infoSource['idcps'])->where("idlibro", $infoSource['idlibro'])->where("doc_serie", $infoSource['doc_serie'])->where("doc_numero", $infoSource['doc_numero'])->get("iva_".$idano)->num_rows() == 0){
                        $this->db_b->where('idrec', $idrec);
                        if ($this->db_b->update('iva_'.$idano, $infoSource)) return true;
                        else return false;
                    } else return false;
                } else {
                    $this->db_b->where('idrec', $idrec);
                    if ($this->db_b->update('iva_'.$idano, $infoSource)) return true;
                    else return false;
                }
            }
        }

        public function deleteDocumento($idrec, $idano){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('idrec', $idrec);
                if ( $this->db_b->delete('iva_'.$idano) ) return true;
                else return false;
            }
        }

        public function getTiposAuxiliar($idauxidef){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $arrayCodigos = explode(",", $idauxidef);
                $textoFiltro  = 'valor_num = '.implode(" OR valor_num = ", $arrayCodigos);

                $this->db_b->select('descripcion, valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', 'auxi_def');
                $this->db_b->where('('.$textoFiltro.')');
                $this->db_b->order_by('descripcion', 'ASC');
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'          => (int)$info->valor_num,
                            'descrip'     => $info->descripcion
                        );
                    }
                }

                return $array;
            }
        }

        public function getDepartamentosMunicipio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idzip, depto, municipio");
                $this->db_b->from("gzips");
                $this->db_b->where("zipcode", 1);
                $this->db_b->order_by("depto", "ASC");
                $this->db_b->order_by("municipio", "ASC");
                $data = $this->db_b->get();
                
                $array = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $array[] = array(
                            'id'          => (int)$info->idzip,
                            'descrip'     => trim($info->municipio),
                            'departament' => trim($info->depto)
                        );
                    }
                }

                return $array;
            }
        }

        public function saveDatosAuxiliar($infoSource){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if ($this->db_b->insert('ctauxi', $infoSource)) {
                    return $this->db_b->insert_id();
                }
                return false;
            }
        }

        public function updateDatosAuxiliar($infoSource, $idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('idauxi', $idauxi);
                if ($this->db_b->update('ctauxi', $infoSource)) return true;
                else return false;
            }
        }

        public function getImpuestoIVAProductos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("valor_num");
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'gv_tipotax');
                $this->db_b->where("valor_num !=", 0);
                $data = $this->db_b->get();
                
                if ($data->num_rows() > 0) {
                    return ($data->row()->valor_num / 100);
                } else return 13;
            }
        }

        public function getDatosGoXposImportTickets($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtran_model');
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

                $this->db_b->select('a.trannum, a.idcentro, a.idcaja, a.numz, a.fecha, a.serie, a.numero, a.idcps, c.descrip AS nameSucursal, d.descrip AS nameCaja, b.esticket, b.exento, b.descrip AS nameDocumento, e.idtipo, e.descrip AS nameContribuyente, f.ivclase, SUM(a.valventan) AS valventan, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
                $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
                $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
                $this->db_b->where('b.agrupa', 'VN');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->where('a.serie !=', '');
                $this->db_b->where('a.numero !=', 0);
                $this->db_b->group_by(array('a.serie', 'a.idcentro', 'a.idcaja', 'a.numz', 'a.fecha'));
                $this->db_b->order_by("a.fecha", "ASC");
                $this->db_b->order_by("a.numero", "ASC");
                $this->db_b->order_by("a.idclase", "ASC");
                $data = $this->db_b->get();
                
                $array = []; $error = 0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        $inf = $this->db_b->where('numz', $info->numz)->where('idcaja', $info->idcaja)->where('idcentro', $info->idcentro)->order_by('numero', 'DESC')->limit(1)->get('tran_100')->row();

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero.'|'.$inf->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $docResult = 0;
                        } else {
                            $docResult = 1;
                            $error++;
                        }

                        $totalExento = 0; $totalGravado = 0;
                        $totalIVA = $info->valtax1; /*$retencion = 0;*/

                        if ( $info->exento == 1 ) {
                            $totalExento = $info->valventan;
                            $total = $totalGravado + $totalExento + $totalIVA;
                        } else {
                            $taxIVA = $this->getImpuestoIVAProductos();

                            $valTax = number_format($info->valventan * $taxIVA, 6, '.', '');

                            if ($valTax != $info->valtax1) {
                                $totalGravado = number_format((($info->valventan * $info->valtax1) / $valTax), 6, '.', ''); // (X)
                                $totalExento  = $info->valventan - $totalGravado;

                                $total = $totalGravado + $totalExento + $totalIVA;
                            } else {
                                $totalGravado = $info->valventan;
                                $total = $totalGravado + $totalExento + $totalIVA;
                            }
                        }

                        /*if(($info->idtipo == 3) && ($totalGravado >= 100)){
                            $reten = $totalGravado * 0.01;
                            $retencion = number_format(round($reten, 4), 2);
                            $total = $total - $reten;
                        }*/
                        
                        $array[] = array(
                            'trannum'            => (int) $info->trannum,
                            'nameSucursal'       => $info->nameSucursal,
                            'nameCaja'           => $info->nameCaja,
                            'doc_fecha'          => $info->fecha,
                            'nameDocumento'      => $info->nameDocumento,
                            'numeroSerie'        => $info->serie.$info->numero.'|'.$inf->numero,
                            'nameContribuyente'  => $info->nameContribuyente,
                            'valorRet'           => 0,
                            'totalIVA'           => $totalIVA,
                            'totalExento'        => $totalExento,
                            'totalGravado'       => $totalGravado,
                            'valorTotal'         => $total,
                            'documentV'          => $docResult
                        );
                    }
                }

                return $data_s = array('data' => $array, 'error' => $error);
            }
        }

        //OLD FUNCTION, NOT USED
        // public function getDatosGoXposImportVentasCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin){
        //     if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
        //         redirect('CerrarSesion');
        //     }else{
        //         $this->load->model('invtran_model');
        //         $invclases = explode(",", $idclases);
        //         $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

        //         $this->db_b->select('a.trannum, a.fecha, a.idcaja, a.serie, a.numero, a.idcps, c.descrip AS nameSucursal, d.descrip AS nameCaja, b.esticket, b.exento, b.descrip AS nameDocumento, e.idtipo, e.descrip AS nameContribuyente, f.ivclase');
        //         $this->db_b->from('tran_100 a');
        //         $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
        //         $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
        //         $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
        //         $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
        //         $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
        //         $this->db_b->where('b.agrupa', 'VN');
        //         $this->db_b->where('a.idcentro', $idcentro);
        //         $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
        //         $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
        //         $this->db_b->where('('.$txtFiltro.')');
        //         $this->db_b->where('a.serie !=', '');
        //         $this->db_b->where('a.numero !=', 0);
        //         $this->db_b->order_by("a.fecha", "ASC");
        //         $this->db_b->order_by("a.numero", "ASC");
        //         $this->db_b->order_by("a.idclase", "ASC");
        //         $data = $this->db_b->get();
                
        //         $array = []; $error = 0;
        //         if ($data->num_rows() > 0) {
        //             foreach ($data->result() as $info) {
        //                 if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcaja", $info->idcaja)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
        //                     $docResult = 0;
        //                 } else {
        //                     $docResult = 1;
        //                     $error++;
        //                 }

        //                 $total = 0; $totalGravado = 0; $totalExento = 0; $totalNoSujeta = 0;
        //                 $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                        
        //                 $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);
                        
        //                 foreach($productos as $pro){
        //                     if($pro->tipotax != 0 && $invexento == 0){
        //                         $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
        //                         $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
        //                         $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
        //                     }else if ($pro->tipotax == 0 && $pro->nosujeta == 1) {
        //                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                         $totalNoSujeta = $totalNoSujeta + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax != 0 && $invexento == 1){
        //                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax== 0 && $invexento == 0){
        //                         $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax == 0 && $invexento == 1){
        //                         $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }
        //                 }

        //                 /*
        //                 if(($info->idtipo == 3) && ($totalGravado >= 100)){
        //                     $reten = $totalGravado * 0.01;
        //                     $retencion = number_format(round($reten, 4), 2);
        //                     $total = $total - $reten;
        //                 }
        //                 */
        //                 $array[] = array(
        //                     'trannum'            => (int) $info->trannum,
        //                     'nameSucursal'       => $info->nameSucursal,
        //                     'nameCaja'           => $info->nameCaja,
        //                     'doc_fecha'          => $info->fecha,
        //                     'nameDocumento'      => $info->nameDocumento,
        //                     'numeroSerie'        => $info->serie.$info->numero,
        //                     'nameContribuyente'  => $info->nameContribuyente,
        //                     'valorRet'           => 0,
        //                     'totalIVA'           => $totalIVA,
        //                     'totalExento'        => $totalExento,
        //                     'totalGravado'       => $totalGravado,
        //                     'totalNoSujeta'      => $totalNoSujeta,
        //                     'valorTotal'         => $total,
        //                     'documentV'          => $docResult
        //                 );
        //             }
        //         }

        //         return $data_s = array('data' => $array, 'error' => $error);
        //     }
        // }

        public function getDatosGoXposImportVentasCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin) {
            // Verificar sesión válida
            $requiredSessionKeys = ['userDB', 'passDB', 'serverDB', 'nameDB'];
            foreach ($requiredSessionKeys as $key) {
                if (empty($this->session->userdata($key))) {
                    redirect('CerrarSesion');
                    return;
                }
            }

            $this->load->model('invtran_model');

            // Convertir clases en array
            $invclases = explode(',', $idclases);

            // Obtener todos los documentos ya existentes para validarlos en memoria
            $this->db_b->select("ivclase, idcaja, doc_serie, doc_numero");
            $this->db_b->where("idlibro", $idlibro);
            $docsExistentes = $this->db_b->get("iva_$idano")->result();

            $existentes = [];
            foreach ($docsExistentes as $doc) {
                $clave = "{$doc->ivclase}_{$doc->idcaja}_{$doc->doc_serie}_{$doc->doc_numero}";
                $existentes[$clave] = true;
            }

            // Consulta principal de ventas
            $this->db_b->select('
                a.trannum, a.fecha, a.idcaja, a.serie, a.numero, a.idcps,
                c.descrip AS nameSucursal,
                d.descrip AS nameCaja,
                b.esticket, b.exento, b.descrip AS nameDocumento,
                e.idtipo, e.descrip AS nameContribuyente,
                f.ivclase
            ');
            $this->db_b->from('tran_100 a');
            $this->db_b->join('inv_def b', 'a.idclase = b.invclase');
            $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
            $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja');
            $this->db_b->join('ctauxi e', 'a.idcps = e.idauxi', 'left');
            $this->db_b->join('iva_def f', 'a.idclase = f.invclase');
            $this->db_b->where('b.agrupa', 'VN');
            $this->db_b->where('a.idcentro', $idcentro);
            $this->db_b->where('a.fecha >=', $fechaini);
            $this->db_b->where('a.fecha <=', $fechafin);
            $this->db_b->where_in('a.idclase', $invclases);
            $this->db_b->where_in('a.estatus', [1, 9]);
            $this->db_b->where('a.serie !=', '');
            $this->db_b->where('a.numero !=', 0);
            $this->db_b->order_by('a.fecha ASC, a.numero ASC, a.idclase ASC');

            $query = $this->db_b->get();

            $resultado = [];
            $error = 0;

            foreach ($query->result() as $info) {
                // Verificar si el documento ya fue procesado
                $claveDoc = "{$info->ivclase}_{$info->idcaja}_{$info->serie}_{$info->numero}";
                $documentoExiste = isset($existentes[$claveDoc]);

                if ($documentoExiste) $error++;

                // Obtener productos del documento
                $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);

                // Inicializar totales
                $total = 0;
                $totalIVA = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalNoSujeta = 0;

                foreach ($productos as $pro) {
                    $cantidad = abs($pro->cantidad);
                    $precio = $pro->precioneto;

                    if ($info->exento == 0 && $pro->tipotax > 0) {
                        $iva = $precio * ($pro->tipotax / 100);
                        $total += ($precio + $iva) * $cantidad;
                        $totalIVA += $iva * $cantidad;
                        $totalGravado += $precio * $cantidad;
                    } elseif ($pro->nosujeta == 1) {
                        $total += $precio * $cantidad;
                        $totalNoSujeta += $precio * $cantidad;
                    } else {
                        $total += $precio * $cantidad;
                        $totalExento += $precio * $cantidad;
                    }
                }

                $resultado[] = [
                    'trannum'           => (int) $info->trannum,
                    'nameSucursal'      => $info->nameSucursal,
                    'nameCaja'          => $info->nameCaja,
                    'doc_fecha'         => $info->fecha,
                    'nameDocumento'     => $info->nameDocumento,
                    'numeroSerie'       => $info->serie . $info->numero,
                    'nameContribuyente' => $info->nameContribuyente,
                    'valorRet'          => 0,
                    'totalIVA'          => $totalIVA,
                    'totalExento'       => $totalExento,
                    'totalGravado'      => $totalGravado,
                    'totalNoSujeta'     => $totalNoSujeta,
                    'valorTotal'        => $total,
                    'documentV'         => $documentoExiste ? 1 : 0
                ];
            }

            return ['data' => $resultado, 'error' => $error];
        }

        //OLD FUNCTION, NOT USED
        // public function getDatosGoXposImportVentasCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin){
        //     if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
        //         redirect('CerrarSesion');
        //     }else{
        //         $this->load->model('invtran_model');
        //         $invclases = explode(",", $idclases);
        //         $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

        //         $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, c.descrip AS nameSucursal, a.idcaja, d.descrip AS nameCaja, b.exento, b.descrip AS nameDocumento, e.idtipo, a.idcps, e.descrip AS nameContribuyente, f.ivclase');
        //         $this->db_b->from('tran_100 a');
        //         $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
        //         $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
        //         $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
        //         $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
        //         $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
        //         $this->db_b->where('b.agrupa', 'VN');
        //         $this->db_b->where('a.idcentro', $idcentro);
        //         $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
        //         $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
        //         $this->db_b->where('('.$txtFiltro.')');
        //         $this->db_b->where('a.serie !=', '');
        //         $this->db_b->where('a.numero !=', 0);
        //         $this->db_b->order_by("a.fecha", "ASC");
        //         $this->db_b->order_by("a.numero", "ASC");
        //         $data = $this->db_b->get();
                
        //         $array = []; $error = 0;
        //         if ($data->num_rows() > 0) {
        //             foreach ($data->result() as $info) {

        //                 if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcaja", $info->idcaja)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
        //                     $docResult = 0;
        //                 } else { 
        //                     $docResult = 1;
        //                     $error++;
        //                 }

        //                 $total = 0; $totalGravado = 0; $totalExento = 0; $totalNoSujeta = 0;
        //                 $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                        
        //                 $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);
                        
        //                 foreach($productos as $pro){
        //                     if($pro->tipotax != 0 && $invexento == 0){
        //                         $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
        //                         $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
        //                         $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
        //                     }else if ($pro->tipotax == 0 && $pro->nosujeta == 1) {
        //                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                         $totalNoSujeta = $totalNoSujeta + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax != 0 && $invexento == 1){
        //                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax== 0 && $invexento == 0){
        //                         $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }else if($pro->tipotax == 0 && $invexento == 1){
        //                         $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                         $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                     }
        //                 }
        //                 /*
        //                 if(($info->idtipo == 3) && ($totalGravado >= 100)){
        //                     $reten = $totalGravado * 0.01;
        //                     $retencion = number_format(round($reten, 4), 2);
        //                     $total = $total - $reten;
        //                 }
        //                 */
        //                 $array[] = array(
        //                     'trannum'            => (int) $info->trannum,
        //                     'nameSucursal'       => $info->nameSucursal,
        //                     'nameCaja'           => $info->nameCaja,
        //                     'doc_fecha'          => $info->fecha,
        //                     'nameDocumento'      => $info->nameDocumento,
        //                     'numeroSerie'        => $info->serie.$info->numero,
        //                     'nameContribuyente'  => $info->nameContribuyente,
        //                     'valorRet'           => $retencion,
        //                     'totalIVA'           => $totalIVA,
        //                     'totalExento'        => $totalExento,
        //                     'totalGravado'       => $totalGravado,
        //                     'totalNoSujeta'      => $totalNoSujeta,
        //                     'valorTotal'         => $total,
        //                     'documentV'          => $docResult
        //                 );
        //             }
        //         }

        //         return $data_s = array('data' => $array, 'error' => $error);
        //     }
        // }

        public function getDatosGoXposImportVentasCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin) {
            // Validación de sesión
            $requiredSessionKeys = ['userDB', 'passDB', 'serverDB', 'nameDB'];
            foreach ($requiredSessionKeys as $key) {
                if (empty($this->session->userdata($key))) {
                    redirect('CerrarSesion');
                    return;
                }
            }

            $this->load->model('invtran_model');

            $invclases = explode(",", $idclases);

            // Obtener documentos ya existentes para evitar insert duplicado
            $this->db_b->select("ivclase, idcaja, idcps, doc_serie, doc_numero");
            $this->db_b->where("idlibro", $idlibro);
            $docsExistentes = $this->db_b->get("iva_$idano")->result();

            $existentes = [];
            foreach ($docsExistentes as $doc) {
                $clave = "{$doc->ivclase}_{$doc->idcaja}_{$doc->idcps}_{$doc->doc_serie}_{$doc->doc_numero}";
                $existentes[$clave] = true;
            }

            // Consulta principal de documentos a importar
            $this->db_b->select('
                a.trannum, a.fecha, a.serie, a.numero, a.idcaja, a.idcps,
                c.descrip AS nameSucursal,
                d.descrip AS nameCaja,
                b.exento, b.descrip AS nameDocumento,
                e.idtipo, e.descrip AS nameContribuyente,
                f.ivclase
            ');
            $this->db_b->from('tran_100 a');
            $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
            $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
            $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
            $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
            $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
            $this->db_b->where('b.agrupa', 'VN');
            $this->db_b->where('a.idcentro', $idcentro);
            $this->db_b->where('a.fecha >=', $fechaini);
            $this->db_b->where('a.fecha <=', $fechafin);
            $this->db_b->where_in('a.idclase', $invclases);
            $this->db_b->where_in('a.estatus', [1, 9]);
            $this->db_b->where('a.serie !=', '');
            $this->db_b->where('a.numero !=', 0);
            $this->db_b->order_by("a.fecha ASC, a.numero ASC");

            $data = $this->db_b->get();

            $array = [];
            $error = 0;

            foreach ($data->result() as $info) {
                $claveDoc = "{$info->ivclase}_{$info->idcaja}_{$info->idcps}_{$info->serie}_{$info->numero}";
                $documentoExiste = isset($existentes[$claveDoc]);

                if ($documentoExiste) $error++;

                $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);

                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalNoSujeta = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
                $retencion = 0;

                foreach ($productos as $pro) {
                    $cantidad = abs($pro->cantidad);
                    $precio = $pro->precioneto;

                    if ($pro->tipotax != 0 && $invexento == 0) {
                        $iva = $precio * ($pro->tipotax / 100);
                        $total += ($precio + $iva) * $cantidad;
                        $totalIVA += $iva * $cantidad;
                        $totalGravado += $precio * $cantidad;
                    } elseif ($pro->tipotax == 0 && $pro->nosujeta == 1) {
                        $total += $precio * $cantidad;
                        $totalNoSujeta += $precio * $cantidad;
                    } else {
                        $total += $precio * $cantidad;
                        $totalExento += $precio * $cantidad;
                    }
                }

                /*
                if(($info->idtipo == 3) && ($totalGravado >= 100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = number_format(round($reten, 4), 2);
                    $total = $total - $reten;
                }
                */

                $array[] = [
                    'trannum'           => (int) $info->trannum,
                    'nameSucursal'      => $info->nameSucursal,
                    'nameCaja'          => $info->nameCaja,
                    'doc_fecha'         => $info->fecha,
                    'nameDocumento'     => $info->nameDocumento,
                    'numeroSerie'       => $info->serie . $info->numero,
                    'nameContribuyente' => $info->nameContribuyente,
                    'valorRet'          => $retencion,
                    'totalIVA'          => $totalIVA,
                    'totalExento'       => $totalExento,
                    'totalGravado'      => $totalGravado,
                    'totalNoSujeta'     => $totalNoSujeta,
                    'valorTotal'        => $total,
                    'documentV'         => $documentoExiste ? 1 : 0
                ];
            }

            return ['data' => $array, 'error' => $error];
        }

        public function getDatosGoXposImportComprasCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);
                
                $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, c.descrip AS nameSucursal, b.exento, b.descrip AS nameDocumento, d.idtipo, a.idcps, d.descrip AS nameContribuyente, SUM(a.valcosto) AS valcosto, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5, e.ivclase');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('iva_def  e', 'a.idclase = e.invclase');
                $this->db_b->where('b.agrupa', 'CO');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1)');
                $this->db_b->where('(a.serie != "PENDIENTE")');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->group_by(array('a.serie', 'a.numero', 'a.idcps'));
                $this->db_b->order_by('a.fecha', 'ASC');
                $this->db_b->order_by('a.numero', 'ASC');
                $data = $this->db_b->get();
                
                $array = []; $error = 0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_fecha", $info->fecha)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $docResult = 0;
                        } else {
                            $docResult = 1;
                            $error++;
                        }

                        $totalExento = 0; $totalGravado = 0;
                        $totalIVA = $info->valtax1;

                        ( $info->exento == 1 ) ? $totalExento = $info->valcosto : $totalGravado = $info->valcosto;
                        $total = $totalGravado + $totalExento + $totalIVA;

                        $array[] = array(
                            'trannum'            => (int) $info->trannum,
                            'nameSucursal'       => $info->nameSucursal,
                            'nameCaja'           => '',
                            'doc_fecha'          => $info->fecha,
                            'nameDocumento'      => $info->nameDocumento,
                            'numeroSerie'        => $info->serie.$info->numero,
                            'nameContribuyente'  => $info->nameContribuyente,
                            'totalIVA'           => $totalIVA,
                            'totalExento'        => $totalExento,
                            'totalGravado'       => $totalGravado,
                            'valorTotal'         => $total,
                            'documentV'          => $docResult
                        );
                    }
                }

                return $data_s = array('data' => $array, 'error' => $error);
            }
        }
        
        public function getDatosGoXposImportGastosCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);
                
                $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, c.descrip AS nameSucursal, b.exento, b.descrip AS nameDocumento, d.idtipo, a.idcps, d.descrip AS nameContribuyente, SUM(a.valcosto) AS valcosto, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5, e.ivclase');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('iva_def  e', 'a.idclase = e.invclase');
                $this->db_b->where('b.agrupa', 'GA');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1)');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->group_by(array('a.serie', 'a.numero', 'a.idcps'));
                $this->db_b->order_by('a.fecha', 'ASC');
                $this->db_b->order_by('a.numero', 'ASC');
                $data = $this->db_b->get();
                
                $array = []; $error = 0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_fecha", $info->fecha)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $docResult = 0;
                        } else {
                            $docResult = 1;
                            $error++;
                        }

                        $totalExento = 0; $totalGravado = 0;
                        $totalIVA = $info->valtax1;

                        ( $info->exento == 1 ) ? $totalExento = $info->valcosto : $totalGravado = $info->valcosto;
                        $total = $totalGravado + $totalExento + $totalIVA;

                        $array[] = array(
                            'trannum'            => (int) $info->trannum,
                            'nameSucursal'       => $info->nameSucursal,
                            'nameCaja'           => '',
                            'doc_fecha'          => $info->fecha,
                            'nameDocumento'      => $info->nameDocumento,
                            'numeroSerie'        => $info->serie.$info->numero,
                            'nameContribuyente'  => $info->nameContribuyente,
                            'totalIVA'           => $totalIVA,
                            'totalExento'        => $totalExento,
                            'totalGravado'       => $totalGravado,
                            'valorTotal'         => $total,
                            'documentV'          => $docResult
                        );
                    }
                }

                return $data_s = array('data' => $array, 'error' => $error);
            }
        }

        public function isCorrelativoEmpresa(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.valor_num');
                $this->db_b->from('gvars a');
                $this->db_b->where('a.nombre', 'ivac_gnumemp');
                $info = $this->db_b->get();
                
                if ($info->num_rows() > 0) {
                    return $info->row()->valor_num;
                } else return 0;
            }
        }

        public function goXposImportTickets($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $gnumEmp = $this->isCorrelativoEmpresa();

                $this->load->model('invtran_model');
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

                $this->db_b->select('a.trannum, a.idcentro, a.idcaja, a.numz, a.fecha, a.serie, a.numero, a.idcps, b.esticket, b.exento, e.idtipo, f.ivclase, SUM(a.valventan) AS valventan, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5, g.resolucion');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
                $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
                $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
                if ($gnumEmp == 0) {
                    $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie AND a.idcentro = g.idcentro');
                } else {
                    $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie');
                }
                $this->db_b->where('b.agrupa', 'VN');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->where('a.serie !=', '');
                $this->db_b->where('a.numero !=', 0);
                $this->db_b->group_by(array('a.serie', 'a.idcentro', 'a.idcaja', 'a.numz', 'a.fecha'));
                $this->db_b->order_by("a.fecha", "ASC");
                $this->db_b->order_by("a.numero", "ASC");
                $this->db_b->order_by("a.idclase", "ASC");
                $data = $this->db_b->get();
                
                $insert = 0; $error = 0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        $inf = $this->db_b->where('numz', $info->numz)->where('idcaja', $info->idcaja)->where('idcentro', $info->idcentro)->order_by('numero', 'DESC')->limit(1)->get('tran_100')->row();

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero.'|'.$inf->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $totalExento = 0; $totalGravado = 0;
                            $totalIVA = $info->valtax1; /*$retencion = 0;*/

                            if ( $info->exento == 1 ) {
                                $totalExento = $info->valventan;
                                $total = $totalGravado + $totalExento + $totalIVA;
                            } else {
                                $taxIVA = $this->getImpuestoIVAProductos();

                                $valTax = number_format($info->valventan * $taxIVA, 6, '.', '');

                                if ($valTax != $info->valtax1) {
                                    $totalGravado = number_format((($info->valventan * $info->valtax1) / $valTax), 6, '.', ''); // (X)
                                    $totalExento  = $info->valventan - $totalGravado;

                                    $total = $totalGravado + $totalExento + $totalIVA;
                                } else {
                                    $totalGravado = $info->valventan;
                                    $total = $totalGravado + $totalExento + $totalIVA;
                                }
                            }

                            /*if(($info->idtipo == 3) && ($totalGravado >= 100)){
                                $reten = $totalGravado * 0.01;
                                $retencion = number_format(round($reten, 4), 2);
                                $total = $total - $reten;
                            }*/
                            
                            $infoSource = array(
                                'idanomes'   => $codemes,
                                'idlibro'    => (int) $idlibro,
                                'ivclase'    => (int) $info->ivclase,
                                'idcentro'   => (int) $info->idcentro,
                                'idcaja'     => (int) $info->idcaja,
                                'fecha'      => date_create()->format('Y-m-d'),
                                'doc_fecha'  => $info->fecha,
                                'doc_res'    => $info->resolucion,
                                'doc_serie'  => $info->serie,
                                'doc_numero' => $info->numero.'|'.$inf->numero,
                                'idcps'      => $info->idcps,
                                'valor0'     => $totalIVA,
                                'valor1'     => $totalGravado,
                                'valor2'     => $totalExento,
                                'valor3'     => 0,
                                'valor4'     => 0,
                                'valor5'     => 0,
                                'referencia' => (int) $info->numz,
                                'estatus'    => 1,
                                'origen'     => 'Iva_Central.ImportGoXpos',
                                'whodidit'   => $this->session->userdata('iduser'),
                                'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                            );

                            if ( $this->db_b->insert('iva_'.$idano, $infoSource) ){
                                $insert++;
                            }
                        } else $error++;
                    }
                }

                return $array = array('insert' => $insert, 'error' => $error);
            }
        }

        //OLD FUNCTION, NOT USED
        // public function goXposImportVentasCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion = '', $idingreso = ''){
        //     if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
        //         redirect('CerrarSesion');
        //     }else{
        //         $gnumEmp = $this->isCorrelativoEmpresa();
                
        //         $this->load->model('invtran_model');
        //         $invclases = explode(",", $idclases);
        //         $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

        //         $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcps, a.idcentro, a.idcaja, b.exento, f.ivclase, g.resolucion, f.defaultfld');
        //         $this->db_b->from('tran_100 a');
        //         $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
        //         $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
        //         $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
        //         $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
        //         $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
        //         if ($gnumEmp == 0) {
        //             $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie AND a.idcentro = g.idcentro');
        //         } else {
        //             $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie');
        //         }
        //         $this->db_b->where('b.agrupa', 'VN');
        //         $this->db_b->where('a.idcentro', $idcentro);
        //         $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
        //         $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
        //         $this->db_b->where('('.$txtFiltro.')');
        //         $this->db_b->where('a.serie !=', '');
        //         $this->db_b->where('a.numero !=', 0);
        //         $this->db_b->group_by('a.trannum');
        //         $this->db_b->order_by('a.fecha', 'ASC');
        //         $this->db_b->order_by('a.numero', 'ASC');
        //         $data = $this->db_b->get();
                
        //         $insert=0; $error=0;
        //         if ($data->num_rows() > 0) {
        //             foreach ($data->result() as $info) {

        //                 if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcaja", $info->idcaja)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
        //                     $total = 0; $totalGravado = 0; $totalExento = 0; $totalNoSujeta = 0;
        //                     $totalIVA = 0; $invexento = $info->exento;
                            
        //                     $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);
                            
        //                     foreach($productos as $pro){
        //                         if($pro->tipotax != 0 && $invexento == 0){
        //                             $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
        //                             $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
        //                             $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
        //                         }else if ($pro->tipotax == 0 && $pro->nosujeta == 1) {
        //                             $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                             $totalNoSujeta = $totalNoSujeta + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax != 0 && $invexento == 1){
        //                             $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax== 0 && $invexento == 0){
        //                             $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax == 0 && $invexento == 1){
        //                             $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }
        //                     }
                            
        //                     if ($idoperacion == 0) {
        //                         if ($totalNoSujeta != 0) {
        //                             $tipoOperacion = 3;
        //                         }else {
        //                             if ($totalGravado != 0 && $totalExento == 0) {
        //                                 $tipoOperacion = 1;
        //                             } else if ($totalGravado != 0 && $totalExento != 0) {
        //                                 $tipoOperacion = 4;
        //                             } else if ($totalGravado == 0 && $totalExento != 0) {
        //                                 $tipoOperacion = 2;
        //                             }
        //                         }
        //                     } else {
        //                         $tipoOperacion = 1;
        //                     }

        //                     $infoSource = array(
        //                         'idanomes'   => $codemes,
        //                         'idlibro'    => (int) $idlibro,
        //                         'ivclase'    => (int) $info->ivclase,
        //                         'idcentro'   => (int) $info->idcentro,
        //                         'idcaja'     => (int) $info->idcaja,
        //                         'fecha'      => date_create()->format('Y-m-d'),
        //                         'doc_fecha'  => $info->fecha,
        //                         'doc_res'    => $info->resolucion,
        //                         'doc_serie'  => $info->serie,
        //                         'doc_numero' => $info->numero,
        //                         'doc_clase'  => $tipoOperacion.','.$idingreso,
        //                         'idcps'      => $info->idcps,
        //                         'valor0'     => $totalIVA,
        //                         'valor1'     => $totalGravado,
        //                         'valor2'     => ($info->defaultfld == '') ? $totalExento : 0,
        //                         'valor3'     => ($info->defaultfld == 3) ? $totalExento : $totalNoSujeta,
        //                         'valor4'     => 0,
        //                         'valor5'     => 0,
        //                         'valor13'    => ($info->defaultfld == 13) ? $totalExento : 0,
        //                         'valor10'    => ($info->defaultfld == 10) ? $totalExento : 0,
        //                         'tranref'    => $info->trannum,
        //                         'estatus'    => 1,
        //                         'origen'     => 'Iva_Central.ImportGoXpos',
        //                         'whodidit'   => $this->session->userdata('iduser'),
        //                         'ingresa'    => date_create()->format('Y-m-d H:i:s'),
        //                     );

        //                     if ( $this->db_b->insert('iva_'.$idano, $infoSource) ){
        //                         $insert++;
        //                     }
        //                 } else $error++;
        //             }
        //         }

        //         return $array = array('insert' => $insert, 'error' => $error);
        //     }
        // }

        public function goXposImportVentasCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion = '', $idingreso = ''){
            if (
                !$this->session->userdata('userDB') ||
                !$this->session->userdata('passDB') ||
                !$this->session->userdata('serverDB') ||
                !$this->session->userdata('nameDB')
            ) {
                redirect('CerrarSesion');
            }

            $gnumEmp = $this->isCorrelativoEmpresa();
            $this->load->model('invtran_model');
            
            // Cargar todas las combinaciones ya registradas en una sola consulta
            $existentes = $this->db_b->select('ivclase, idcaja, doc_serie, doc_numero')
                ->where('idlibro', $idlibro)
                ->get("iva_$idano")
                ->result();

            $exist_map = [];
            foreach ($existentes as $e) {
                $key = "{$e->ivclase}_{$e->idcaja}_{$e->doc_serie}_{$e->doc_numero}";
                $exist_map[$key] = true;
            }

            $invclases = explode(",", $idclases);
            $txtFiltro = 'a.idclase = ' . implode(' OR a.idclase = ', $invclases);

            $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcps, a.idcentro, a.idcaja, b.exento, f.ivclase, g.resolucion, f.defaultfld');
            $this->db_b->from('tran_100 a');
            $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
            $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
            $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
            $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
            $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
            if ($gnumEmp == 0) {
                $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie AND a.idcentro = g.idcentro');
            } else {
                $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie');
            }
            $this->db_b->where('b.agrupa', 'VN');
            $this->db_b->where('a.idcentro', $idcentro);
            $this->db_b->where("a.fecha BETWEEN '$fechaini' AND '$fechafin'");
            $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
            $this->db_b->where("($txtFiltro)");
            $this->db_b->where('a.serie !=', '');
            $this->db_b->where('a.numero !=', 0);
            $this->db_b->group_by('a.trannum');
            $this->db_b->order_by('a.fecha', 'ASC');
            $this->db_b->order_by('a.numero', 'ASC');
            $data = $this->db_b->get();

            $insert = 0;
            $error = 0;

            if ($data->num_rows() > 0) {
                foreach ($data->result() as $info) {
                    $key = "{$info->ivclase}_{$info->idcaja}_{$info->serie}_{$info->numero}";

                    if (isset($exist_map[$key])) {
                        $error++;
                        continue;
                    }

                    $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);

                    $total = $totalGravado = $totalExento = $totalNoSujeta = $totalIVA = 0;

                    foreach ($productos as $pro) {
                        $cantidad = abs($pro->cantidad);
                        $precio = $pro->precioneto;

                        if ($pro->tipotax != 0 && !$info->exento) {
                            $iva = $precio * ($pro->tipotax / 100);
                            $totalIVA += $iva * $cantidad;
                            $totalGravado += $precio * $cantidad;
                            $total += ($precio + $iva) * $cantidad;
                        } elseif ($pro->tipotax == 0 && $pro->nosujeta == 1) {
                            $totalNoSujeta += $precio * $cantidad;
                            $total += $precio * $cantidad;
                        } else {
                            $totalExento += $precio * $cantidad;
                            $total += $precio * $cantidad;
                        }
                    }

                    if ($idoperacion == 0) {
                        if ($totalNoSujeta != 0) {
                            $tipoOperacion = 3;
                        } elseif ($totalGravado != 0 && $totalExento == 0) {
                            $tipoOperacion = 1;
                        } elseif ($totalGravado != 0 && $totalExento != 0) {
                            $tipoOperacion = 4;
                        } elseif ($totalGravado == 0 && $totalExento != 0) {
                            $tipoOperacion = 2;
                        } else {
                            $tipoOperacion = 1;
                        }
                    } else {
                        $tipoOperacion = 1;
                    }

                    $infoSource = [
                        'idanomes'   => $codemes,
                        'idlibro'    => (int) $idlibro,
                        'ivclase'    => (int) $info->ivclase,
                        'idcentro'   => (int) $info->idcentro,
                        'idcaja'     => (int) $info->idcaja,
                        'fecha'      => date('Y-m-d'),
                        'doc_fecha'  => $info->fecha,
                        'doc_res'    => $info->resolucion,
                        'doc_serie'  => $info->serie,
                        'doc_numero' => $info->numero,
                        'doc_clase'  => $tipoOperacion.','.$idingreso,
                        'idcps'      => $info->idcps,
                        'valor0'     => $totalIVA,
                        'valor1'     => $totalGravado,
                        'valor2'     => ($info->defaultfld == '') ? $totalExento : 0,
                        'valor3'     => ($info->defaultfld == 3) ? $totalExento : $totalNoSujeta,
                        'valor4'     => 0,
                        'valor5'     => 0,
                        'valor13'    => ($info->defaultfld == 13) ? $totalExento : 0,
                        'valor10'    => ($info->defaultfld == 10) ? $totalExento : 0,
                        'tranref'    => $info->trannum,
                        'estatus'    => 1,
                        'origen'     => 'Iva_Central.ImportGoXpos',
                        'whodidit'   => $this->session->userdata('iduser'),
                        'ingresa'    => date('Y-m-d H:i:s'),
                    ];

                    if ($this->db_b->insert('iva_'.$idano, $infoSource)) {
                        $insert++;
                    } else {
                        $error++;
                    }
                }
            }

            return ['insert' => $insert, 'error' => $error];
        }

        //OLD FUNCTION, NOT USED
        // public function goXposImportVentasCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion = '', $idingreso = ''){
        //     if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
        //         redirect('CerrarSesion');
        //     }else{
        //         $gnumEmp = $this->isCorrelativoEmpresa();

        //         $this->load->model('invtran_model');
        //         $invclases = explode(",", $idclases);
        //         $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);

        //         $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcps, a.idcentro, a.idcaja, b.exento, e.idtipo, f.ivclase, g.resolucion, f.doc_tipo');
        //         $this->db_b->from('tran_100 a');
        //         $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
        //         $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
        //         $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
        //         $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
        //         $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
        //         if ($gnumEmp == 0) {
        //             $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie AND a.idcentro = g.idcentro');
        //         } else {
        //             $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie');
        //         }
        //         $this->db_b->where('b.agrupa', 'VN');
        //         $this->db_b->where('a.idcentro', $idcentro);
        //         $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
        //         $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
        //         $this->db_b->where('('.$txtFiltro.')');
        //         $this->db_b->where('a.serie !=', '');
        //         $this->db_b->where('a.numero !=', 0);
        //         $this->db_b->order_by("a.fecha", "ASC");
        //         $this->db_b->order_by("a.numero", "ASC");
        //         $data = $this->db_b->get();
                
        //         $insert=0; $error=0;
        //         if ($data->num_rows() > 0) {
        //             foreach ($data->result() as $info) {

        //                 if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
        //                     $total = 0; $totalGravado = 0; $totalExento = 0; $totalNoSujeta = 0;
        //                     $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                            
        //                     $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);
                            
        //                     foreach($productos as $pro){
        //                         if($pro->tipotax != 0 && $invexento == 0){
        //                             $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
        //                             $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
        //                             $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
        //                         }else if ($pro->tipotax == 0 && $pro->nosujeta == 1) {
        //                             $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                             $totalNoSujeta = $totalNoSujeta + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax != 0 && $invexento == 1){
        //                             $total = $total + (($pro->precioneto * abs($pro->cantidad)));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax== 0 && $invexento == 0){
        //                             $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }else if($pro->tipotax == 0 && $invexento == 1){
        //                             $total = $total + (($pro->precioneto) * abs($pro->cantidad));
        //                             $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        //                         }
        //                     }
        //                     /*
        //                     if(($info->idtipo == 3) && ($totalGravado >= 100)){
        //                         $reten = $totalGravado * 0.01;
        //                         $retencion = number_format(round($reten, 4), 2);
        //                         $total = $total - $reten;
        //                     }
        //                     */

        //                     if ($idoperacion == 0) {
        //                         if ($totalNoSujeta != 0) {
        //                             $tipoOperacion = 3;
        //                         }else {
        //                             if ($totalGravado != 0 && $totalExento == 0) {
        //                                 $tipoOperacion = 1;
        //                             } else if ($totalGravado != 0 && $totalExento != 0) {
        //                                 $tipoOperacion = 4;
        //                             } else if ($totalGravado == 0 && $totalExento != 0) {
        //                                 $tipoOperacion = 2;
        //                             }
        //                         }
        //                     } else {
        //                         $tipoOperacion = 1;
        //                     }

        //                     $infoSource = array(
        //                         'idanomes'   => $codemes,
        //                         'idlibro'    => (int) $idlibro,
        //                         'ivclase'    => (int) $info->ivclase,
        //                         'idcentro'   => (int) $info->idcentro,
        //                         'idcaja'     => (int) $info->idcaja,
        //                         'fecha'      => date_create()->format('Y-m-d'),
        //                         'doc_fecha'  => $info->fecha,
        //                         'doc_res'    => $info->resolucion,
        //                         'doc_serie'  => $info->serie,
        //                         'doc_numero' => $info->numero,
        //                         'doc_clase'  => $tipoOperacion.','.$idingreso,
        //                         'idcps'      => $info->idcps,
        //                         'valor0'     => ($info->doc_tipo == 5) ? ($totalIVA * -1) : $totalIVA,
        //                         'valor1'     => ($info->doc_tipo == 5) ? ($totalGravado * -1) : $totalGravado,
        //                         'valor2'     => ($info->doc_tipo == 5) ? ($totalExento * -1) : $totalExento,
        //                         'valor3'     => ($info->doc_tipo == 5) ? ($totalNoSujeta * -1) : $totalNoSujeta,
        //                         'valor4'     => 0,
        //                         'valor5'     => 0,
        //                         'tranref'    => $info->trannum,
        //                         'estatus'    => 1,
        //                         'origen'     => 'Iva_Central.ImportGoXpos',
        //                         'whodidit'   => $this->session->userdata('iduser'),
        //                         'ingresa'    => date_create()->format('Y-m-d H:i:s'),
        //                     );

        //                     if ( $this->db_b->insert('iva_'.$idano, $infoSource) ){
        //                         $insert++;
        //                     }
        //                 } else $error++;
        //             }
        //         }

        //         return array('insert' => $insert, 'error' => $error);
        //     }
        // }

        public function goXposImportVentasCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion = '', $idingreso = '') {
            if (
                !$this->session->userdata('userDB') ||
                !$this->session->userdata('passDB') ||
                !$this->session->userdata('serverDB') ||
                !$this->session->userdata('nameDB')
            ) {
                redirect('CerrarSesion');
            }

            $gnumEmp = $this->isCorrelativoEmpresa();
            $this->load->model('invtran_model');
            $invclases = explode(",", $idclases);
            $txtFiltro = 'a.idclase = ' . implode(" OR a.idclase = ", $invclases);

            // Cargar todos los registros ya insertados para evitar consultas repetidas
            $existentes = $this->db_b->select('ivclase, idcps, idlibro, doc_serie, doc_numero')
                ->where('idlibro', $idlibro)
                ->get("iva_$idano")
                ->result();

            $exist_map = [];
            foreach ($existentes as $e) {
                $key = "{$e->ivclase}_{$e->idcps}_{$e->doc_serie}_{$e->doc_numero}";
                $exist_map[$key] = true;
            }

            $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcps, a.idcentro, a.idcaja, b.exento, e.idtipo, f.ivclase, g.resolucion, f.doc_tipo');
            $this->db_b->from('tran_100 a');
            $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
            $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
            $this->db_b->join('ctcajas  d', 'a.idcaja = d.idcaja');
            $this->db_b->join('ctauxi   e', 'a.idcps = e.idauxi', 'left');
            $this->db_b->join('iva_def  f', 'a.idclase = f.invclase');
            if ($gnumEmp == 0) {
                $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie AND a.idcentro = g.idcentro');
            } else {
                $this->db_b->join('gnums g', 'b.numgrupo = g.numgrupo AND g.serie = a.serie');
            }
            $this->db_b->where('b.agrupa', 'VN');
            $this->db_b->where('a.idcentro', $idcentro);
            $this->db_b->where('(a.fecha BETWEEN "' . $fechaini . '" AND "' . $fechafin . '")');
            $this->db_b->where('(a.estatus = 1 OR a.estatus = 9)');
            $this->db_b->where('(' . $txtFiltro . ')');
            $this->db_b->where('a.serie !=', '');
            $this->db_b->where('a.numero !=', 0);
            $this->db_b->order_by("a.fecha", "ASC");
            $this->db_b->order_by("a.numero", "ASC");
            $data = $this->db_b->get();

            $insert = 0;
            $error = 0;

            if ($data->num_rows() > 0) {
                foreach ($data->result() as $info) {
                    $key = "{$info->ivclase}_{$info->idcps}_{$info->serie}_{$info->numero}";

                    if (isset($exist_map[$key])) {
                        $error++;
                        continue;
                    }

                    $total = $totalGravado = $totalExento = $totalNoSujeta = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $retencion = 0;

                    $productos = $this->invtran_model->getDataTran100kIVAC($info->trannum);

                    foreach ($productos as $pro) {
                        if ($pro->tipotax != 0 && $invexento == 0) {
                            $total += ($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad);
                            $totalIVA += ($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad);
                            $totalGravado += $pro->precioneto * abs($pro->cantidad);
                        } elseif ($pro->tipotax == 0 && $pro->nosujeta == 1) {
                            $total += $pro->precioneto * abs($pro->cantidad);
                            $totalNoSujeta += $pro->precioneto * abs($pro->cantidad);
                        } elseif ($pro->tipotax != 0 && $invexento == 1) {
                            $total += $pro->precioneto * abs($pro->cantidad);
                            $totalExento += $pro->precioneto * abs($pro->cantidad);
                        } elseif ($pro->tipotax == 0 && $invexento == 0) {
                            $total += $pro->precioneto * abs($pro->cantidad);
                            $totalExento += $pro->precioneto * abs($pro->cantidad);
                        } elseif ($pro->tipotax == 0 && $invexento == 1) {
                            $total += $pro->precioneto * abs($pro->cantidad);
                            $totalExento += $pro->precioneto * abs($pro->cantidad);
                        }
                    }

                    /*
                    if(($info->idtipo == 3) && ($totalGravado >= 100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = number_format(round($reten, 4), 2);
                        $total = $total - $reten;
                    }
                    */

                    if ($idoperacion == 0) {
                        if ($totalNoSujeta != 0) {
                            $tipoOperacion = 3;
                        } else {
                            if ($totalGravado != 0 && $totalExento == 0) {
                                $tipoOperacion = 1;
                            } else if ($totalGravado != 0 && $totalExento != 0) {
                                $tipoOperacion = 4;
                            } else if ($totalGravado == 0 && $totalExento != 0) {
                                $tipoOperacion = 2;
                            }
                        }
                    } else {
                        $tipoOperacion = 1;
                    }

                    $infoSource = [
                        'idanomes'   => $codemes,
                        'idlibro'    => (int)$idlibro,
                        'ivclase'    => (int)$info->ivclase,
                        'idcentro'   => (int)$info->idcentro,
                        'idcaja'     => (int)$info->idcaja,
                        'fecha'      => date('Y-m-d'),
                        'doc_fecha'  => $info->fecha,
                        'doc_res'    => $info->resolucion,
                        'doc_serie'  => $info->serie,
                        'doc_numero' => $info->numero,
                        'doc_clase'  => $tipoOperacion . ',' . $idingreso,
                        'idcps'      => $info->idcps,
                        'valor0'     => ($info->doc_tipo == 5) ? ($totalIVA * -1) : $totalIVA,
                        'valor1'     => ($info->doc_tipo == 5) ? ($totalGravado * -1) : $totalGravado,
                        'valor2'     => ($info->doc_tipo == 5) ? ($totalExento * -1) : $totalExento,
                        'valor3'     => ($info->doc_tipo == 5) ? ($totalNoSujeta * -1) : $totalNoSujeta,
                        'valor4'     => 0,
                        'valor5'     => 0,
                        'tranref'    => $info->trannum,
                        'estatus'    => 1,
                        'origen'     => 'Iva_Central.ImportGoXpos',
                        'whodidit'   => $this->session->userdata('iduser'),
                        'ingresa'    => date('Y-m-d H:i:s'),
                    ];

                    if ($this->db_b->insert('iva_' . $idano, $infoSource)) {
                        $insert++;
                    } else {
                        $error++;
                    }
                }
            }

            return ['insert' => $insert, 'error' => $error];
        }

        public function goXposImportGastosCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtran_model');

                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);
                
                $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcentro, a.idcps, a.ovnumero AS resolucion, b.exento, d.idtipo, SUM(a.valcosto) AS valcosto, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5, e.ivclase, e.doc_tipo');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('iva_def  e', 'a.idclase = e.invclase');
                $this->db_b->where('b.agrupa', 'GA');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1)');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->group_by(array('a.serie', 'a.numero', 'a.idcps'));
                $this->db_b->order_by('a.fecha', 'ASC');
                $this->db_b->order_by('a.numero', 'ASC');
                $data = $this->db_b->get();
                
                $insert=0; $error=0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                            
                            $productos = $this->invtran_model->getDataTran100k($info->trannum);
                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->costounitario + ($pro->costounitario * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->costounitario * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->costounitario * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->costounitario * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->costounitario * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->costounitario) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->costounitario * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->costounitario) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->costounitario * abs($pro->cantidad);
                                }
                            }
                            
                            if(($info->idtipo == 3) && ($totalGravado >= 100)){
                                $retencion = $totalGravado * 0.01;
                                $retencion = number_format(round($retencion, 4), 2, '.', '');
                            }

                            $infoSource = array(
                                'idanomes'   => $codemes,
                                'idlibro'    => (int) $idlibro,
                                'ivclase'    => (int) $info->ivclase,
                                'idcentro'   => (int) $info->idcentro,
                                'idcaja'     => 0,
                                'fecha'      => date_create()->format('Y-m-d'),
                                'doc_fecha'  => $info->fecha,
                                'doc_res'    => $info->resolucion,
                                'doc_serie'  => $info->serie,
                                'doc_numero' => $info->numero,
                                'idcps'      => $info->idcps,
                                'valor0'     => ($info->doc_tipo == 5) ? ($totalIVA * -1) : $totalIVA,
                                'valor1'     => ($info->doc_tipo == 5) ? ($totalGravado * -1) : $totalGravado,
                                'valor2'     => ($info->doc_tipo == 5) ? ($totalExento * -1) : $totalExento,
                                'valor3'     => 0,
                                'valor4'     => $retencion,
                                'valor5'     => 0,
                                'tranref'    => $info->trannum,
                                'estatus'    => 1,
                                'origen'     => 'Iva_Central.ImportGoXpos',
                                'whodidit'   => $this->session->userdata('iduser'),
                                'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                            );
                            
                            if ( $this->db_b->insert('iva_'.$idano, $infoSource) ){
                                $insert++;
                            }
                        } else $error++;
                    }
                }

                return $array = array('insert' => $insert, 'error' => $error);
            }
        }

        public function goXposImportComprasCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.idclase = '.implode(" OR a.idclase = ", $invclases);
                
                $this->db_b->select('a.trannum, a.fecha, a.serie, a.numero, a.idcentro, a.idcps, a.ovnumero AS resolucion, b.exento, d.idtipo, SUM(a.valcosto) AS valcosto, SUM(a.valtax1) AS valtax1, SUM(a.valtax5) AS valtax5, e.ivclase, e.doc_tipo');
                $this->db_b->select('IFNULL(f.idrec, 0) AS dte_idrec, f.estatus AS dte_estatus, f.ncontrol, f.cgeneracion, f.srecepcion, f.firma_json, f.json_doc, f.resp_mh, f.email_send, f.type');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase');
                $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('iva_def  e', 'a.idclase = e.invclase');
                $this->db_b->join('tran_100dte f', 'a.trannum = f.trannum AND f.type = "DOC"', 'left');
                $this->db_b->where('b.agrupa', 'CO');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('(a.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'")');
                $this->db_b->where('(a.estatus = 1)');
                $this->db_b->where('(a.serie != "PENDIENTE")');
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->group_by(array('a.serie', 'a.numero', 'a.idcps'));
                $this->db_b->order_by('a.fecha', 'ASC');
                $this->db_b->order_by('a.numero', 'ASC');
                $data = $this->db_b->get();
                
                $insert=0; $error=0;
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        if ( $this->db_b->where("ivclase", $info->ivclase)->where("idcps", $info->idcps)->where("idlibro", $idlibro)->where("doc_serie", $info->serie)->where("doc_numero", $info->numero)->get("iva_".$idano)->num_rows() == 0 ) {
                            $totalExento = 0; $totalGravado = 0; $retencion = 0;

                            ( $info->exento == 1 ) ? $totalIVA = 0 : $totalIVA = $info->valtax1;
                            ( $info->exento == 1 ) ? $totalExento = $info->valcosto : $totalGravado = $info->valcosto;
                            $total = $totalGravado + $totalExento + $totalIVA;
                            /*
                            if(($info->idtipo == 3) && ($totalGravado >= 100)){
                                $reten = $totalGravado * 0.01;
                                $retencion = number_format(round($reten, 4), 2);
                                $total = $total - $reten;
                            }
                            */
                            $infoSource = array(
                                'idanomes'   => $codemes,
                                'idlibro'    => (int) $idlibro,
                                'ivclase'    => (int) $info->ivclase,
                                'idcentro'   => (int) $info->idcentro,
                                'idcaja'     => 0,
                                'fecha'      => date_create()->format('Y-m-d'),
                                'doc_fecha'  => $info->fecha,
                                'doc_res'    => $info->resolucion,
                                'doc_serie'  => $info->serie,
                                'doc_numero' => $info->numero,
                                'doc_tipo'   => ($info->dte_idrec == 0) ? 0 : 1,
                                'idcps'      => $info->idcps,
                                'valor0'     => ($info->doc_tipo == 5) ? ($totalIVA * -1) : $totalIVA,
                                'valor1'     => ($info->doc_tipo == 5) ? ($totalGravado * -1) : $totalGravado,
                                'valor2'     => ($info->doc_tipo == 5) ? ($totalExento * -1) : $totalExento,
                                'valor3'     => 0,
                                'valor4'     => $info->valtax5,
                                'valor5'     => 0,
                                'tranref'    => $info->trannum,
                                'estatus'    => 1,
                                'origen'     => 'Iva_Central.ImportGoXpos',
                                'whodidit'   => $this->session->userdata('iduser'),
                                'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                            );

                            if ( $this->db_b->insert('iva_'.$idano, $infoSource) ) {
                                if ($info->dte_idrec != 0) {
                                    $idrec_iva = $this->db_b->insert_id();

                                    $infoSourceDTE = array(
                                        'trannum'     => $idrec_iva,
                                        'fechahora'   => date_create()->format('Y-m-d H:i:s'),
                                        'ncontrol'    => $info->ncontrol,
                                        'cgeneracion' => $info->cgeneracion,
                                        'srecepcion'  => $info->srecepcion,
                                        'firma_json'  => $info->firma_json,
                                        'json_doc'    => $info->json_doc,
                                        'resp_mh'     => $info->resp_mh,
                                        'email_send'  => $info->email_send,
                                        'type'        => $info->type,
                                        'firma_json'  => $info->firma_json,
                                        'o_table'     => 'iva_'.$idano,
                                        'estatus'     => $info->dte_estatus,
                                        'whodidit'   => $this->session->userdata('iduser'),
                                        'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                                    );

                                    $this->db_b->insert('tran_100dte', $infoSourceDTE);
                                }
                                $insert++;
                            }
                        } else $error++;
                    }
                }

                return $array = array('insert' => $insert, 'error' => $error);
            }
        }

        public function getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc, e.esticket');
                //$this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('inv_def  e', 'b.invclase = e.invclase', 'left');
                // $this->db_b->where('a.estatus', 1);
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('CAST(a.doc_numero AS SIGNED)', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }

        public function getdocumentosToCSVbyBatchGeneral($idlibro, $idyear, $idmes, $idclases, $limit, $offset){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc, e.esticket');
                //$this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('inv_def  e', 'b.invclase = e.invclase', 'left');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                $this->db_b->limit($limit, $offset);
                return $this->db_b->get();
            }
        }

        public function getdocumentosToCSVbyBatch($idlibro, $idyear, $idmes, $idclases, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc, e.esticket');
                //$this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('inv_def  e', 'b.invclase = e.invclase', 'left');
                // $this->db_b->where('a.idcaja',  $idcaja);
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.doc_fecha >=',  $fechaini);
                $this->db_b->where('a.doc_fecha <=',  $fechafin);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('CAST(a.doc_numero AS SIGNED)', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }

        public function getdocumentosToCSV1($idlibro, $idyear, $idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$invclases = explode(",", $idclases);
               //$txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi c', 'a.idcps = c.idauxi');
                $this->db_b->join('tran_100dte f', 'a.idrec = f.trannum', 'left');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);               
                //$this->db_b->where('f.o_table',  'iva_"'.$idyear.'"');               
                //$this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }
        
        public function getdocumentosToTxt($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nrc, c.nit, c.direccion, c.giro, d.xpos, c.dui, c.nrc, e.xpos AS idclaxpos, f.xpos AS idcenxpos, g.municipio, g.depto AS departamento');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->join('inv_def e', 'b.invclase = e.invclase');
                $this->db_b->join('invsites f', 'f.idcentro = a.idcentro');
                $this->db_b->join('gzips g', 'g.idzip = c.idzip');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }
        
        public function getdocumentosToCSVPercepcion($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, b.doc_clase, b.doc_tipo, c.descrip AS namecliente, c.nit, d.xpos, c.dui, c.nrc');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.valor4 !=',  0);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }
        
        public function getdocumentosDCLToCSV($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $invclases = explode(",", $idclases);
                $txtFiltro = 'a.ivclase = '.implode(" OR a.ivclase = ", $invclases);
                
                $this->db_b->select('a.*, c.descrip AS namecliente, c.nit, d.xpos, c.dui');
                $this->db_b->select('a.doc_tipo AS docTipo, a.doc_clase AS docClase');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('('.$txtFiltro.')');
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }

        public function getdocumentosDCL($idlibro, $idyear, $idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{                
                $this->db_b->select('a.*, c.descrip AS namecliente, c.nit, d.xpos, c.dui');
                $this->db_b->from('iva_'.$idyear.' a');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->join('ctcajas d', 'a.idcaja = d.idcaja', 'left');
                $this->db_b->where('a.idanomes', $idmes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->order_by('a.doc_fecha', 'ASC');
                $this->db_b->order_by('a.doc_numero', 'ASC');
                $this->db_b->order_by('a.ivclase', 'ASC');
                return $this->db_b->get();
            }
        }

        function inicializarLibro($password, $idano, $idanomes, $idlibro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', 'ivac_password');
                (int) $vPassword = $this->db_b->get()->row()->valor_num;

                if ($password == $vPassword) {
                    $this->db_b->where('idanomes', $idanomes);
                    $this->db_b->where('idlibro',  $idlibro);
                    $this->db_b->delete('iva_'.$idano);

                    return true;
                } else return false;
            }
        }

        //  IMPRESION DOCUMENTO IVA CENTRAL
        public function verificarFormatoImpresion($ivclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ivclase = "IVA".$ivclase;
                $consulta = "SELECT askpwd, gvarpwd, formname, appoptions FROM gforms WHERE FIND_IN_SET('$ivclase',notas)>0";
                $query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result_array();
					return $resultado;
				}else{
					return false;
				}
            }
		}

        public function getDatosDocumento($idrec,$idano, $idanomes, $idlibro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('a.*, b.descrip AS nameDocumento');
                $this->db_b->select('e.descrip AS nameCli, e.telefono AS telCli, e.giro AS giroCli, e.direccion AS direccionCli, e.nrc AS nrcCli, e.dui AS duiCli, e.nit AS nitCli ,CONCAT(TRIM(g.municipio),", ",TRIM(g.depto)) as munidepar');
                $this->db_b->select('SUM(a.valor0 + a.valor1 + a.valor2 + a.valor3 + a.valor4 + a.valor5 + a.valor6 + a.valor7 + a.valor8 + a.valor9 + a.valor10 + a.valor11 + a.valor12 + a.valor13 + a.valor14 + valor15 + valor16 + valor17 + valor18 + valor19 + valor20) AS valorTotal');
                $this->db_b->from('iva_'.$idano.' a');
                $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                $this->db_b->join('ctauxi e', 'a.idcps = e.idauxi');
                $this->db_b->join('gzips  g', 'g.idzip = e.idzip');
                $this->db_b->where('a.idanomes', $idanomes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.estatus',  1);
                $this->db_b->where('a.idrec',  $idrec);

                $this->db_b->group_by("a.idrec");
                $this->db_b->order_by("a.idrec", "DESC");
                $informacion = $this->db_b->get();
                
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'idrec'             => (int) $info->idrec,
                            'fecha'             => $info->fecha,
                            'notas'             => $info->notas,
                            'doc_fecha'         => $info->doc_fecha,
                            'ivclase'           => (int) $info->ivclase,
                            'idcentro'          => (int) $info->idcentro,
                            'idcaja'            => (int) $info->idcaja,
                            'doc_res'           => $info->doc_res,
                            'doc_serie'         => $info->doc_serie,
                            'doc_numero'        => $info->doc_numero,
                            'doc_funico'        => $info->doc_funico,
                            'referencia'        => $info->referencia,
                            'idcps'             => (int) $info->idcps,
                            'valor0'            => $info->valor0,
                            'valor1'            => $info->valor1,
                            'valor2'            => $info->valor2,
                            'valor3'            => $info->valor3,
                            'valor4'            => $info->valor4,
                            'valor5'            => $info->valor5,
                            'valor6'            => $info->valor6,
                            'valor7'            => $info->valor7,
                            'valor8'            => $info->valor8,
                            'valor9'            => $info->valor9,
                            'valor10'           => $info->valor10,
                            'valor11'           => $info->valor11,
                            'valor12'           => $info->valor12,
                            'valor13'           => $info->valor13,
                            'valor14'           => $info->valor14,
                            'valor15'           => $info->valor15,
                            'valor16'           => $info->valor16,
                            'valor17'           => $info->valor17,
                            'valor18'           => $info->valor18,
                            'valor19'           => $info->valor19,
                            'valor20'           => $info->valor20,
                            'estatus'           => $info->estatus,
                            'notas'             => $info->notas,
                            'nameDocumento'     => $info->nameDocumento,
                            'nameCli'           => $info->nameCli,
                            'telCli'            => $info->telCli,
                            'giroCli'           => $info->giroCli,
                            'direccionCli'      => $info->direccionCli,
                            'nrcCli'            => $info->nrcCli,
                            'duiCli'            => $info->duiCli,
                            'nitCli'            => $info->nitCli,
                            'munidepar'         => $info->munidepar,
                            'valorTotal'        => $info->valorTotal
                        );
                    }

                    return $array;
                } return false;
            }
        }

        //  VERIFICAR EXISTE AUXILIAR
        public function verificaExisteAuxiliar($nit, $nrc, $idauxi = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->db_b->select('1');
                $this->db_b->from('ctauxi');
                $this->db_b->where("(nit = '$nit' or nrc = '$nrc')");
                if($idauxi != 0){
                    $this->db_b->where('idauxi != ',  $idauxi);
                }

                $resultado = $this->db_b->get();
                
                if ($resultado->num_rows() > 0) {
                    return true;
                } 
                
                return false;
            }
        }

        public function insertarDatosArchivoImportacion($idano, $infoInsert) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->insert('iva_'.$idano, $infoInsert);
            }
        }

        public function getNumTipoTransaccion($idclase) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT numtipo FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($SQL);
                
				if ( $query->num_rows() > 0 ) {
					$resultado = $query->row_array();
                	return $resultado['numtipo'];
				} else {
					return false;
				}
            }
		}

        function updateNumerosFacturasEmpresa($idclase) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
		}

        function updateNumerosFacturasSucursal($idclase, $idcentro) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu = $this->db_b->query($sqlcon);
                $res = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1 LIMIT 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl = $sqlQuery->row_array();
                $actual = $resSQl['actual'];
                $idrnum = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
		}

        function updateNumerosFacturas($idclase, $idcentro, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
                $sqlqu  = $this->db_b->query($sqlcon);
                $res    = $sqlqu->row_array();
                
                $numgrupo = $res['numgrupo'];
                
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                $sqlQuery = $this->db_b->query($consulta);
                $resSQl   = $sqlQuery->row_array();
                $actual   = $resSQl['actual'];
                $idrnum   = $resSQl['idrnum'];
                
                $actual = $actual + 1;
                
                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gnums');
                
                return $query;
            }
        }

        function getAuxiliaresPendientes($idano, $idanomes, $idlibro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec');
                $this->db_b->from('iva_'.$idano.' a');
                $this->db_b->where('a.idanomes', $idanomes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.idcps',  0);
                $informacion = $this->db_b->get();

                return $informacion->num_rows();
            }
        }

        function generarAuxiliares($idano, $idanomes, $idlibro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->select('a.idrec, a.notas');
                $this->db_b->from('iva_'.$idano.' a');
                $this->db_b->where('a.idanomes', $idanomes);
                $this->db_b->where('a.idlibro',  $idlibro);
                $this->db_b->where('a.idcps',  0);
                $informacion = $this->db_b->get();

                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $infoAuxiliar = explode('|', $info->notas);
                        
                        $numDocumento = $infoAuxiliar[0];
                        $nameAuxiliar = $infoAuxiliar[1];

                        $this->db_b->select('a.idauxi');
                        $this->db_b->from('ctauxi a');
                        $this->db_b->where('a.nrc', $numDocumento);
                        $info_auxi = $this->db_b->get();

                        if ($info_auxi->num_rows() > 0) {
                            $idcps = $info_auxi->row()->idauxi;

                            $this->db_b->set('idcps', $idcps);
                            $this->db_b->set('notas', '');
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->where('idrec', $info->idrec);
                            $this->db_b->update('iva_'.$idano);
                        } else {
                            $this->db_b->set('idauxi', 0);
                            $this->db_b->set('descrip', $nameAuxiliar);
                            $this->db_b->set('nrc', $numDocumento);
                            $this->db_b->set('idauxidef', ($idlibro == 3) ? 1 : 2);
                            $this->db_b->set('estado', 1);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $this->db_b->insert('ctauxi');

                            $idcps = $this->db_b->insert_id();

                            $this->db_b->set('idcps', $idcps);
                            $this->db_b->set('notas', '');
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->where('idrec', $info->idrec);
                            $this->db_b->update('iva_'.$idano);
                        }
                    }
                }

                return true;
            }
        }

        function getAuxiliarPorDocumento($auxiliarNRC, $auxiliarNIT, $auxiliarDUI) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi');
                $this->db_b->from('ctauxi');
                if ($auxiliarNRC != '') {
                    $this->db_b->where('nrc', $auxiliarNRC);
                }
                if ($auxiliarNIT != '') {
                    $this->db_b->where('nit', $auxiliarNIT);
                }
                if ($auxiliarDUI != '') {
                    $this->db_b->where('dui', $auxiliarDUI);
                }

                $informacion = $this->db_b->get();

                if ($informacion->num_rows() > 0) {
                    return (int) $informacion->row()->idauxi;
                } else return 0;
            }
        }
        
        function getDescripVariableByValue($nameGvar, $valorNum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descripcion');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', $nameGvar);
                $this->db_b->where('valor_num', $valorNum);
                $informacion = $this->db_b->get();

                if ($informacion->num_rows() > 0) {
                    return $informacion->row()->descripcion;
                } else return '';
            }
        }

        function getValorGvarDefault($nameGvar) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', $nameGvar);
                $this->db_b->where('filtro', 1);
                $informacion = $this->db_b->get();

                if ($informacion->num_rows() > 0) {
                    return (int) $informacion->row()->valor_num;
                } else return 0;
            }
        }

        function getTrannumDocumentImport($doc_serie, $doc_numero, $idcentro, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('trannum');
                $this->db_b->from('tran_100');
                $this->db_b->where('serie', $doc_serie);
                $this->db_b->where('numero', $doc_numero);
                $this->db_b->where('idcentro', $idcentro);
                $this->db_b->where('idcaja', $idcaja);
                $informacion = $this->db_b->get();

                if ($informacion->num_rows() > 0) {
                    return (int) $informacion->row()->trannum;
                } else return 0;
            }
        }

        #   GET TIPO OPERACION  RENTA IVA
        public function getTipoDeOperacionRentaIVA(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("nombre, descripcion, FORMAT(valor_num, 0) as valor_num, filtro");
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'iva_tipoo_renta');
                $this->db_b->order_by("valor_num", "ASC");
                $datos = $this->db_b->get()->result();

                return $datos;
            }
        }

        #   GET TIPO DE INGRESO RENTA IVA
        public function getTipoDeIngresoRentaIVA(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("nombre, descripcion, FORMAT(valor_num, 0) as valor_num, filtro");
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'iva_tipoi_renta');
                $this->db_b->order_by("valor_num", "ASC");
                $datos = $this->db_b->get()->result();

                return $datos;
            }
        }
   } 
?>