<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Invtran_model extends CI_Model{
        
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){ 
                echo 'Incorrect database information provided';
            }
        }
                
        function getModeloProductos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT distinct if(invproducts.modelo='','SIN MODELO', invproducts.modelo) as modelo FROM tran_100k 
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                WHERE trannum = $trannum
                ORDER BY invproducts.modelo ASC";
                $query = $this->db_b->query($consulta); 
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getModeloProductosPedidos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
	                               distinct if(invproducts.modelo='','SIN MODELO', invproducts.modelo) as modelo
                                FROM 
                                orders_100k
                                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto
                                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                                WHERE
                                trannum = $trannum
                                ORDER BY invproducts.modelo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductoPorModelo($trannum,$modelo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                    tran_100k.idproducto, invproducts.descrip, invproducts.barcode, abs(tran_100k.cantidad) as cantidad
                                FROM
                                    tran_100k
                                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                                WHERE
                                    trannum = $trannum and invproducts.modelo = '$modelo'
                                    ORDER BY invproducts.descrip ASC;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductoPorModeloPedidos($trannum,$modelo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                    orders_100k.idproducto, invproducts.descrip, abs(orders_100k.cantidad) as cantidad
                                FROM
                                    orders_100k
                                INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto
                                WHERE
                                    trannum = $trannum and invproducts.modelo = '$modelo'
                                    ORDER BY invproducts.descrip ASC;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosTraslados($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                    invproducts.xpos, invproducts.descrip, invproducts.um, invproducts.precioventa, abs(tran_100k.cantidad) as cantidad
                                FROM
                                    tran_100k
                                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                                WHERE
                                    trannum = $trannum
                                    ORDER BY invproducts.xpos;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosTrasladosOrderByItemLine($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.xpos, invproducts.descrip, invproducts.um, invproducts.precioventa, abs(tran_100k.cantidad) as cantidad, tran_100k.notas FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE trannum = $trannum ORDER BY tran_100k.itemline ASC;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCentrosDistribucion($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcentro, descrip FROM invsites WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataListaCentros($idtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcentro, descrip, idcps FROM invsites WHERE tipo = $idtipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }    
        }
		
        function getAllCentros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM invsites";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }    
        }
		
        function getAllCentrosActivos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invsites.*, invlocations.descrip AS ubicacion, gvars.descripcion FROM invsites INNER JOIN invlocations ON invsites.idcentro=invlocations.idcentro INNER JOIN gvars ON invsites.tipo = gvars.valor_num AND gvars.nombre = 'gv_tipo' WHERE invsites.estatus = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }    
        }
        
        function getSucursalesDestino($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invsites.idcentro, invsites.descrip, gvars.descripcion AS grupo FROM invsites INNER JOIN gvars ON invsites.tipo = gvars.valor_num AND gvars.nombre = 'gv_tipo' WHERE invsites.estatus = 1 AND invsites.idcentro != $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getUbicacionesSucursal($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idbin AS id, descrip FROM invlocations WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getEncargadoSucursal($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.idauxi AS id, ctauxi.descrip FROM ctauxi INNER JOIN invsites ON ctauxi.idauxi = invsites.idcps WHERE invsites.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
		
        function getCantidad100k($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idrec FROM tran_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->num_rows();
                return $resultado;
            } 
        }
        
        function getNotasTrann100($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT notas FROM tran_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['notas'];
            }
        }
        
        function getReferenciaTrann100($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT referencia FROM tran_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['referencia'];
            }
        }
        
        function getUnidades100k($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cantidad FROM tran_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                $total = 0;
                foreach($resultado as $key){
                    $total = $total + abs($key->cantidad);
                }
                return $total;
            } 
        }
        
        function getDataTran100($idclass){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum,tran_100.tranref, tran_100.idcentro, tran_100.fecha,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha1, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha2, tran_100.fecact, tran_100.estatus, invsites.descrip AS idcentrod, tran_100.referencia, tran_100.lines100k FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod WHERE tran_100.idclase = $idclass ORDER BY tran_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInformacionTraslados($idcentro, $idclase, $fechaini, $fechafin, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereSQL = ($estado == 0) ? "AND tran_100.estatus = 0" : "AND tran_100.estatus != 0 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'";

                $consulta = "SELECT tran_100.trannum, tran_100.tranref, tran_100.idcentro, tran_100.fecha,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha1, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha2, tran_100.fecact, tran_100.estatus, invsites.descrip AS idcentrod, tran_100.referencia, tran_100.lines100k, gusers.descrip AS elaboradopor FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod INNER JOIN gusers ON tran_100.whodidit = gusers.iduser 
                WHERE tran_100.idclase = $idclase AND tran_100.idcentro = $idcentro ".$whereSQL." ORDER BY tran_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getDataTran100Impresion($estado, $idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.tranref, tran_100.fecha, invsites.descrip AS idcentrod FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod INNER JOIN tran_100p ON tran_100.trannum = tran_100p.trannum AND tran_100p.estatus = $estado WHERE tran_100.idclase = $idclase ORDER BY tran_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
        function getDataTran100_center($idclass, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.idcentro, tran_100.fecha,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha1, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha2, tran_100.fecact, tran_100.estatus, invsites.descrip AS idcentrod, tran_100.referencia, tran_100.lines100k FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod WHERE tran_100.idclase = $idclass AND tran_100.idcentro = $idcentro ORDER BY tran_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
		
        function getDetallePedido($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.idcps, tran_100.tranref, tran_100.referencia, tran_100.idcentro, tran_100.idcentrod AS idcd, tran_100.notas, invsites2.descrip AS centrocd, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, invsites.descrip AS idcentrod, invsites.idzip AS idzip, tran_100.lines100k, (SELECT SUM(ABS(cantidad)) FROM tran_100k where trannum= tran_100.trannum) as cantidad, ctauxi.descrip AS encargadod, gusers.descrip AS encargadoinv,  inv_def.descrip as tipoTran FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod INNER JOIN invsites AS invsites2 ON invsites2.idcentro = tran_100.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idworker INNER JOIN gusers ON gusers.iduser = tran_100.whodidit INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE tran_100.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getDatosGzips($idzip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT municipio, depto 
                             FROM gzips 
                             where gzips.idzip = $idzip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getEncabezadoOrder100($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                                orders_100.trannum,
                                orders_100.idcps,
                                orders_100.referencia,
                                orders_100.idcentro,
                                orders_100.procentro,
                                orders_100.notas,
                                invsites2.descrip AS centrocd,
                                orders_100.fecha,
                                orders_100.fecact,
                                DATE_FORMAT(orders_100.fecact, '%d/%m/%Y') AS fecha2,
                                orders_100.estatus,
                                invsites.descrip AS idcentrod,
                                orders_100.lines100k,
                                ctauxi.descrip AS encargadod,
                                gusers.descrip AS encargadoinv
                            FROM
                                orders_100
                                    INNER JOIN
                                invsites ON invsites.idcentro = orders_100.procentro
                                    INNER JOIN
                                invsites AS invsites2 ON invsites2.idcentro = orders_100.idcentro
                                    LEFT JOIN
                                ctauxi ON ctauxi.idauxi = orders_100.idworker
                                    INNER JOIN
                                gusers ON gusers.iduser = orders_100.whodidit
                            WHERE
                                orders_100.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
                
        function getDetallePedido_Salida($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.tranref, tran_100.idcentro, tran_100.notas, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, tran_100.lines100k, (SELECT SUM(ABS(cantidad)) FROM tran_100k WHERE trannum = tran_100.trannum) AS cantidad, ctauxi.descrip AS encargadod, gusers.descrip AS encargadoinv FROM tran_100 LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps INNER JOIN gusers ON gusers.iduser = tran_100.whodidit WHERE tran_100.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getDataTran100k($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.barcode as code_product, invproducts.codescrip, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, 
                ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, 
                invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, 
                invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, 
                tran_100k.notas, tran_100k.notas AS modNotas, invcatalog.descrip AS catDescrip, tran_100k.lote AS lote100k, tran_100k.fechacp,
                IF(invproducts.tipo = 4, 999999, 
                (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) 
                FROM tran_100k AS tran_100k2 
                WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS disponible,
                CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion 
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin 
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch 
                LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker
                LEFT JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataTran100kModelo($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.barcode as code_product, invproducts.codescrip, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, 
                ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, 
                invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, 
                invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, 
                tran_100k.notas, tran_100k.notas AS modNotas, invcatalog.descrip AS catDescrip, tran_100k.lote AS lote100k, tran_100k.fechacp,
                IF(invproducts.tipo = 4, 999999, 
                (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) 
                FROM tran_100k AS tran_100k2 
                WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS disponible,
                CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion 
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin 
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch 
                LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker
                LEFT JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.trannum = $idtrannum ORDER BY invproducts.modelo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataTran100kIVAC($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.precioneto, a.cantidad, a.preciotran, b.tipotax, b.nosujeta FROM tran_100k a INNER JOIN invproducts b ON b.idproducto = a.idproducto
                WHERE a.trannum = $trannum ORDER BY a.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataTran100kGoIva($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.precioneto, a.cantidad, a.preciotran, b.tipotax FROM tran_100k a INNER JOIN invproducts b ON b.idproducto = a.idproducto
                WHERE a.trannum = $trannum ORDER BY a.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataTran100kColor($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.barcode as code_product, invproducts.codescrip, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, 
                ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, 
                invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, invproducts.pro_color, 
                invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, 
                tran_100k.notas, tran_100k.notas AS modNotas,
                IF(invproducts.tipo = 4, 999999, 
                (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) 
                FROM tran_100k AS tran_100k2 
                WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS disponible,
                CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion 
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin 
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch 
                LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker 
                WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDataTran100kGroup($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.barcode as code_product, invproducts.codescrip, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, 
                ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, 
                invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, 
                invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, SUM(tran_100k.cantidad) as cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, 
                tran_100k.notas, tran_100k.notas AS modNotas,
                IF(invproducts.tipo = 4, 999999, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 
                WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS disponible,
                CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion 
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin 
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch 
                LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker 
                WHERE tran_100k.trannum = $idtrannum 
                GROUP BY tran_100k.idproducto ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        #   PARA GRUPO C Y M PRODUCTOS AGRUPADOS XPOS
        function getDataTran100kO($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $consulta = "SELECT invproducts.xpos, invproducts.barcode as code_product, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, 
                ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, 
                invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, 
                invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad as cantidadT, SUM(tran_100k.cantidad) as cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, 
                tran_100k.notas, tran_100k.notas AS modNotas,
                IF(invproducts.tipo = 4, 999999, 
                (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) 
                FROM tran_100k AS tran_100k2 
                WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro)) AS disponible,
                CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion 
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin 
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch 
                LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker 
                WHERE tran_100k.trannum = $idtrannum 
                GROUP BY invproducts.xpos, tran_100k.preciotran
                ORDER BY tran_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleTraslado($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, invproducts.tipotax, invproducts.upp, invproducts.tipo, tran_100k.idrec, tran_100k.barcode, tran_100k.itemline, tran_100k.uniconv,
                    tran_100k.idworker, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.barcode as barcodeFicha, invproducts.precioventa,
                    invproducts.marca, invproducts.idproducto, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, ABS(tran_100k.cantidad) AS cantidad, invcatalog.multiaux,
                    tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas, tran_100k.lote AS lote100k, tran_100k.fechacp AS fechaCad,
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = $idcentro GROUP BY tran_100k2.idproducto) AS disponible
                FROM
                    tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                INNER JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE
                    tran_100k.trannum = $trannum
                ORDER BY
                    tran_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDatosSalida($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp,
                    tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta,
                    tran_100k.uniconv, tran_100k.idworker, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invcatalog.multiaux,
                    invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invlocations.descrip AS ubicacion, tran_100k.lote AS lote100k, tran_100k.fechacp AS fechaCad,
                    inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas,
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.idcentro = tran_100k.idcentro) AS disponible
                FROM tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE
                    tran_100k.trannum = $idtrannum
                GROUP BY invproducts.idproducto
                ORDER BY tran_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataVentaTran100k($trannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT 
                    invproducts.xpos, invproducts.barcode AS code_product, invproducts.precioventa, invproducts.tipotax, invproducts.tipo, invproducts.upp, ctauxi.descrip AS vendename,
                    tran_100k.idrec, tran_100k.tax1, tran_100k.barcode, tran_100k.itemline, tran_100k.um AS umVenta, tran_100k.uniconv, tran_100k.idworker, invproducts.idcatalogo, invproducts.descrip,
                    invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.notas AS notasProducto, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas, IF(invproducts.tipo = 4, 999999,
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k.idproducto = tran_100k2.idproducto AND tran_100k2.idcentro = $idcentro)) AS disponible
                FROM tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                INNER JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker
                WHERE tran_100k.trannum = $trannum ORDER BY tran_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getDataTran100kCorteZ($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT
                                tran_100k.tax1,
                                tran_100k.cantidad,
                                tran_100k.precioneto,
                                tran_100k.preciotran,
                                tran_100k.costounitario,
                                tran_100k.descuento
                            FROM
                                tran_100k
                            WHERE
                                tran_100k.trannum = $idtrannum
                            ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getNombreClienteConsigna($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT
                                descrip, direccion
                            FROM
                                ctauxi
                            WHERE
                                idauxi = $idcps";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }
        
        function getDetalleAjuste100k($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.tipo, tran_100k.idrec, IFNULL(tran_100k.barcode,0) AS barcode, tran_100k.itemline, invproducts.descrip, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, ABS(tran_100k.cantidad) as cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataTran100k_modelo($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, invproducts.codescrip, invproducts.tipo, ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.itemline, tran_100k.idworker, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, invproducts.precioventa, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas, IFNULL(inv_stock.cantidad, 999999) AS disponible, CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch LEFT JOIN inv_stock ON tran_100k.idproducto = inv_stock.idproducto AND tran_100k.idcentro = inv_stock.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker WHERE tran_100k.trannum = $idtrannum ORDER BY modelo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getDataTran100k_Itemline($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, invproducts.tipo, ctauxi.descrip AS vendename, tran_100k.idrec, tran_100k.tax1, tran_100k.itemline, tran_100k.idworker, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,invproducts.precioventa, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas, IFNULL(inv_stock.cantidad, 999999) AS disponible, CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', ifnull(invproducts.modelo, ''), '</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch LEFT JOIN inv_stock ON tran_100k.idproducto = inv_stock.idproducto AND tran_100k.idcentro = inv_stock.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getDataProductoVentaTran100k($trannum, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, invproducts.tipo, invproducts.upp, invproducts.tipotax, tran_100k.idrec, tran_100k.itemline, invproducts.idcatalogo,
                    invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode,
                    invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran,
                    tran_100k.costounitario, tran_100k.descuento, tran_100k.notas,
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = tran_100k.idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS disponible,
                    CONCAT(invproducts.descrip,'<br>','CODIGO:','<strong>',invproducts.idproducto,'</strong>','<br>','MODELO: ','<strong>',invproducts.modelo,'</strong>',' MARCA: ','<strong>',invproducts.marca,'</strong>') AS descripcion
                FROM
                    tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                WHERE tran_100k.trannum = $trannum AND tran_100k.idproducto = $idproducto
                ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getDataProductoVentaTran100kPrueba($trannum, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, invproducts.tipotax, tran_100k.idrec, tran_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, inv_stock.cantidad as disponible, CONCAT(invproducts.descrip, '<br>', 'CODIGO:', '<strong>', invproducts.idproducto, '</strong>', '<br>', 'MODELO: ', '<strong>', invproducts.modelo,'</strong>', ' MARCA: ', '<strong>',invproducts.marca, '</strong>') AS descripcion FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch LEFT JOIN inv_stock ON tran_100k.idproducto = inv_stock.idproducto WHERE tran_100k.trannum = $trannum AND tran_100k.idproducto = $idproducto ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getItemlineProducto($idtrannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.itemline FROM tran_100k WHERE tran_100k.trannum = $idtrannum AND tran_100k.idproducto = $idproducto ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['itemline'];
            }
        }
        
        function getIdrecProducto($trannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT tran_100k.idrec
                FROM tran_100k
                WHERE tran_100k.trannum = $trannum AND tran_100k.idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['idrec'];
            }
        }
        
        function getCantidadProducto($trannum, $idproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT ABS(tran_100k.cantidad) AS cantidad
                FROM tran_100k
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch
                WHERE tran_100k.trannum = $trannum AND tran_100k.idproducto = $idproducto AND tran_100k.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cantidad'];
            }
        }

        function getPreciotranProducto($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT preciotran FROM tran_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['preciotran'];
            }
        }
        
        function getDataTran100k2($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.itemline,  tran_100k.notas, invproducts.idproducto, invproducts.descrip, invproducts.modelo, invproducts.tipotax, tran_100k.cantidad, invproducts.tipo, tran_100k.precioneto,tran_100k.preciotran  FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getDataTran100k_envios($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos,tran_100k.idrec, tran_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.modelo, invproducts.marca, invproducts.idproducto, invproducts.barcode, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, ABS(tran_100k.cantidad) as cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
		function getidps_centro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcps FROM invsites where idcentro=$idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['idcps'];
            }
        }
        
        function getubicaciones_centro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT COUNT(invlocations.idbin) as cant FROM invlocations INNER JOIN invsites ON invsites.idcentro= invlocations.idcentro  WHERE invsites.idcentro=$idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }
        
        function getencargado_centro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.descrip as encargado  FROM invsites INNER JOIN ctauxi ON ctauxi.idauxi= invsites.idcps WHERE invsites.idcentro=$idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['encargado'];
            }
        }
        
        function getubicacion_centro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT  invlocations.descrip AS ubica FROM invlocations INNER JOIN invsites ON invsites.idcentro= invlocations.idcentro  WHERE invsites.idcentro=$idcentro LIMIT 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['ubica'];
            }
        }
        
        function getbodega_centro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, tran_100k.idrec, tran_100k.itemline, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, tran_100k.cantidad, tran_100k.precioneto FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto INNER JOIN invlocations ON invlocations.idbin = tran_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function deleteDataTran100k($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM tran_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function deleteDataOrders100k($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM orders_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function deleteVenta100c($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM tran_100c WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function insertTenvio($idcentro, $fecha, $idclase, $idcps, $idcentrod, $observaciones){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $observaciones);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                return $query;
            }  
        }
        
		function insertTenvioAjax($idcentro, $fecha, $idclase, $notas, $idcentrod, $referencia){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT idcps FROM invsites WHERE idcentro = $idcentrod";
                $query = $this->db_b->query($consulta);
                $data = $query->row_array();
                $idcps = $data['idcps'];
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');
                return $query;
            }  
        }
        
		function insertNuevoTraslado($idcentro, $fecha, $idclase, $notas, $idcentrod, $referencia, $idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idworker', $idcps);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
                
                $query = $this->db_b->insert_id();
                
                return $query;
            }  
        }
        
		function insertNuevoTrasladoDespacho($idcentro, $idclase, $notas, $idcentrod, $referencia, $dataProductos, $inopera, $invcontrol){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT idcps FROM invsites WHERE idcentro = $idcentrod";
                $query = $this->db_b->query($consulta);
                $data = $query->row_array();
                $idcps = $data['idcps'];
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
				
				$trannumTraslado = $this->db_b->insert_id();
				
				$totalProductos = count($dataProductos);
				for($i=0; $i<$totalProductos; $i++){
					if(round($dataProductos[$i]['cant_envio']) > 0){
						$idproducto = round($dataProductos[$i]['idproducto']);
						$cantidad = round($dataProductos[$i]['cant_envio']);
						$um = $dataProductos[$i]['um'];
						
						$SQLProducto = "SELECT costounitario, idbin, idbatch FROM inv_stock WHERE idcentro = $idcentro AND idproducto = $idproducto";
						$QueryProducto = $this->db_b->query($SQLProducto);
						$ResultProducto = $QueryProducto->row_array();
						
						$precio = $ResultProducto['costounitario'];
						$idbin = $ResultProducto['idbin'];
						$idbatch = $ResultProducto['idbatch'];
						
						$consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannumTraslado ORDER BY itemline DESC Limit 1";
						$query = $this->db_b->query($consulta);
						
						if($query->num_rows() > 0){
							$resultado = $query->row_array();
							$itemLine = $resultado['itemline'] + 1;
						}else{
							$itemLine = 1;
						}
						$cant_inopera = $cantidad * $inopera;
						
						$this->db_b->set('idrec', 0);
						$this->db_b->set('trannum', $trannumTraslado);
						$this->db_b->set('itemline', $itemLine);
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('idclase', $idclase);
						$this->db_b->set('invcontrol', $invcontrol);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('idbatch', $idbatch);
						$this->db_b->set('idbin', $idbin);
						$this->db_b->set('cantidad', $cant_inopera);
						$this->db_b->set('costounitario', $precio);
						$this->db_b->set('uniconv', 1);
						$this->db_b->set('um', $um);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
						
						$query = $this->db_b->insert('tran_100k');
					}
				}
				
				return $query;
			}
        }
		
		function setAnulacionEnvio($idtrannum, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "DELETE FROM tran_100k WHERE trannum = $idtrannum";
				$query = $this->db_b->query($consulta);
        		        
				$this->db_b->set('estatus', $estado);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }  
		}
		
        function insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio, $notas = '', $fechaCaducidad = '0000-00-00', $loteProduccion = ''){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }

                $cant_inopera = $cantidad * $inopera;
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('invcontrol', $invcontrol);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('lote', $loteProduccion);
                $this->db_b->set('fechacp', $fechaCaducidad);
                $this->db_b->set('cantidad', $cant_inopera);
                $this->db_b->set('costounitario', $precio);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('um', $um);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100k');
                return $query;
            }
        }

        function insertarProductoTrasladoImportado($datoproducto, $cantidad, $busqueda, $trannum, $idcentro, $idclase, $inopera, $invcontrol){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($busqueda != 'barcode'){
                    $SQLExiste = "SELECT tran_100k.idrec, tran_100k.cantidad, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = $idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS saldo FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum AND invproducts.$busqueda = '$datoproducto'";
                }else{
                    $SQLExiste = "SELECT tran_100k.idrec, tran_100k.cantidad, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = $idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS saldo FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE tran_100k.trannum = $trannum AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                }
                $QueryEx = $this->db_b->query($SQLExiste);

                if($QueryEx->num_rows() > 0){
                    $infoRegistro = $QueryEx->row_array();

                    if($busqueda != 'barcode'){
                        $SQLInformacion = "SELECT tran_100k.idrec, tran_100k.cantidad, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = $idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS saldo
                        FROM tran_100k 
                        INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND invproducts.$busqueda = '$datoproducto'";
                    }else{
                        $SQLInformacion = "SELECT tran_100k.idrec, tran_100k.cantidad, (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idcentro = $idcentro AND tran_100k2.idproducto = tran_100k.idproducto) AS saldo
                        FROM tran_100k 
                        INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                    }

                    $QueryInformacion = $this->db_b->query($SQLInformacion);
                    $infoProducto = $QueryInformacion->row_array();
                    
                    $idrec          = $infoRegistro['idrec'];
                    $cantidadactual = $infoProducto['cantidad'];
                    $saldo          = $infoProducto['saldo'];
                    $notas          = "Producto modificado desde la importación de datos.";
                    $cantidad       = $cantidadactual + $cantidad;
                    
                    if($cantidad <= $saldo){
                        $this->db_b->set('cantidad', $cantidad);
                        $this->db_b->set('notas',    $notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec',  $idrec);
                        $query = $this->db_b->update('tran_100k');
                        
                        return $query;
                    }

                    return $QueryEx;
                }else{
                    if($busqueda != 'barcode'){
                        $SQLInformacion = "SELECT invproducts.idproducto, invproducts.costounitario, invproducts.um, invlocations.idbin, inv_batch.idbatch, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                        FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND invproducts.$busqueda = '$datoproducto'";
                    }else{
                        $SQLInformacion = "SELECT invproducts.idproducto, invproducts.costounitario, invproducts.um, invlocations.idbin, inv_batch.idbatch, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                        FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                    }
                    
                    $QueryInformacion = $this->db_b->query($SQLInformacion);
                    $infoProducto = $QueryInformacion->row_array();
                    
                    $sistema    = $infoProducto['cantidad'];
                    $idbatch    = $infoProducto['idbatch'];
                    $idbin      = $infoProducto['idbin'];
                    $idproducto = $infoProducto['idproducto'];
                    $um         = $infoProducto['um'];
                    $precio     = $infoProducto['costounitario'];
                    $notas      = "Producto agregado desde la importación de datos.";
                    
                    $Consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                    $query = $this->db_b->query($Consulta);
                    
                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $itemLine = $resultado['itemline'] + 1;
                    }else{
                        $itemLine = 1;
                    }
                    
                    $cantidadT = $cantidad * $inopera;
                    
                    $this->db_b->set('idrec',         0);
                    $this->db_b->set('trannum',       $trannum);
                    $this->db_b->set('itemline',      $itemLine);
                    $this->db_b->set('idcentro',      $idcentro);
                    $this->db_b->set('idclase',       $idclase);
                    $this->db_b->set('invcontrol',    $invcontrol);
                    $this->db_b->set('idproducto',    $idproducto);
                    $this->db_b->set('idbatch',       $idbatch);
                    $this->db_b->set('idbin',         $idbin);
                    $this->db_b->set('cantidad',      $cantidadT);
                    $this->db_b->set('costounitario', $precio);
                    $this->db_b->set('uniconv',       1);
                    $this->db_b->set('um',            $um);
                    $this->db_b->set('whodidit',      $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa',       $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('tran_100k');
                    
                    return $query;
                }
            }
        }
		
		function updateTraslado100k($idrec, $cantidad, $notas = '', $fechaCaducidad = '0000-00-00', $loteProduccion = ''){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$cantidad = $cantidad * -1;
				
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('lote', $loteProduccion);
                $this->db_b->set('fechacp', $fechaCaducidad);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100k');
                return $query;
            }
        }

        //---------------------------------
        function getLotes100kProducts($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->distinct();
                $this->db_b->select('lote');
                $this->db_b->from('tran_100k');
                $this->db_b->where('lote !=', '');
                $this->db_b->where('tran_100k.idproducto', $idproducto);

                $result = $this->db_b->get();

                if($result->num_rows() > 0) {
                    return $result->result_array();
                } else  return false;
            }
        }

        function getSaldoProductoByLote($idtrannum, $idcatalogo, $idcentro, $idproducto, $lote100k){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                FROM tran_100k
                WHERE tran_100k.idcentro = '$idcentro' AND tran_100k.lote = '$lote100k' AND tran_100k.idproducto = '$idproducto'
                GROUP BY tran_100k.idproducto";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        //---------------------------------
        
        function updateRegistroSalida($idrec, $cantidad, $inopera, $fechaCaducidad, $loteProduccion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$cantidad = $cantidad * $inopera;
				
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('lote', $loteProduccion);
                $this->db_b->set('fechacp', $fechaCaducidad);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100k');
                return $query;
            }
        }
        
        function cambiarEstadoTraslado($trannum, $notas, $referencia, $idcentrod, $fecha){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $partesFecha = explode("-", $fecha);
                
                $consultaSQL = "SELECT ctauxi.idauxi FROM ctauxi INNER JOIN invsites ON ctauxi.idauxi = invsites.idcps WHERE invsites.idcentro = $idcentrod";
                $resultQuery = $this->db_b->query($consultaSQL);
                $informacion = $resultQuery->row_array();
                $idcps = $informacion['idauxi'];
                
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('idcentrod', $idcentrod);
                $this->db_b->set('idworker', $idcps);
                if($partesFecha[1] != $date->format('m')){
                    $this->db_b->set('fecha', $date->format('Y-m-d'));
                }
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
        
        function cerrarSalidaInventario($trannum, $notas, $referencia){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
        
        function cerrarConsignacion($trannum, $notas, $referencia){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('notas', $notas);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
		
        function getDataStockProducto($idproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM inv_stock WHERE idcentro = $idcentro AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
		}
		
        function getCantidadStockProducto($idproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cantidad FROM inv_stock WHERE idcentro = $idcentro AND idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                
				if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    return $resultado['cantidad'];
                }else{
                    return false;
                }
            }
        }
        
        function getTrasladosPendientes($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.notas, tran_100.tranref, tran_100.fecact,tran_100.estatus, invsites.descrip AS centrocd, tran_100.lines100k, (SELECT SUM(tran_100k.cantidad) FROM tran_100k WHERE tran_100k.trannum = tran_100.trannum) AS cantidad FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'IN' WHERE tran_100.idcentrod = $idcentro AND tran_100.estatus = 1 AND tran_100.fecact BETWEEN '$fechaini' AND '$fechafin'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getTrasladosRecibidos($idcentro, $idclase, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum, tran_100.notas, tran_100.tranref, tran_100.idcentro, tran_100.fecha, tran_100.fecact,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha1, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha2,tran_100.estatus, invsites.descrip AS idcentrod, tran_100.lines100k, gusers.descrip AS recibidopor FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod INNER JOIN gusers ON tran_100.whodidit = gusers.iduser WHERE tran_100.idcentro = $idcentro AND tran_100.idclase = $idclase AND tran_100.estatus!=0 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY tran_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function callTotaliza100($trannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db->trans_begin();

                $consulta = "CALL totaliza100($trannum, $estado)";
                $query = $this->db_b->query($consulta);
                
                if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                } else {
                    $this->db->trans_commit();
                }

                return $query;
            }
        }
        
        function setRecepcionHD($trannum, $idclase,  $calificacion, $notas_calificacion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $SQL = 'SELECT a.trannum, a.idcentro, a.fecact, a.idcentrod, a.lines100k, b.idcps, IFNULL(d.invclase, 0) AS invclase FROM tran_100 a 
                INNER JOIN invsites b ON a.idcentro = b.idcentro 
                INNER JOIN inv_def  c ON a.idclase  = c.invclase 
                LEFT JOIN inv_def   d ON d.invclase = c.xpos AND d.inopera = 1 AND d.descrip LIKE "%traslado%" 
                WHERE a.trannum = ' . $trannum;
                $Query = $this->db_b->query($SQL);
                $info  = $Query->row_array();

                $invclase = ( $info['invclase'] == 0 ) ? $idclase : $info['invclase'];
                
                $this->db_b->set('trannum',    0);
                $this->db_b->set('idcentro',   $info['idcentrod']);
                $this->db_b->set('idclase',    $invclase);
                $this->db_b->set('fecha',      $info['fecact']);
                $this->db_b->set('fecact',     $date->format('Y-m-d H:i:s'));
                $this->db_b->set('idworker',   $info['idcps']);
                $this->db_b->set('idcentrod',  $info['idcentro']);
                $this->db_b->set('tranref',    $info['trannum']);
                $this->db_b->set('referencia', $calificacion);
                $this->db_b->set('notas',      $notas_calificacion);
                $this->db_b->set('lines100k',  $info['lines100k']);
                $this->db_b->set('estatus',    2);
                $this->db_b->set('whodidit',   $this->session->userdata('iduser'));
                $this->db_b->set('ingresa',    $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
                $idrecepcion = $this->db_b->insert_id();
                
                $this->db_b->set('estatus',    2);
                $this->db_b->set('tranref',    $idrecepcion);
                $this->db_b->set('modifica',   $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum',  $trannum);
                $this->db_b->update('tran_100');
                
                return $idrecepcion;
            }
        }

        function setRecepcionDT($trannum, $idrecepcion, $idclase, $idbin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT a.idcentro, IFNULL(b.invclase, 0) AS invclase, IFNULL(b.inopera, 0) AS inopera FROM tran_100 a LEFT JOIN inv_def b ON a.idclase = b.invclase AND b.inopera = 1 AND b.descrip LIKE '%traslado%' WHERE a.trannum = $idrecepcion";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();
                
                $this->load->model('global_model');
                $invcontrol = $this->global_model->getInvControlSite($info['idcentro']);
                
                $SQL   = "SELECT * FROM tran_100k WHERE trannum = $trannum ORDER BY itemline ASC";
                $Query = $this->db_b->query($SQL);
                $datos = $Query->result();
                
                $invclase = ( $info['invclase'] == 0 ) ? $idclase : $info['invclase'];
                $inopera  = ( $info['inopera'] == 0 ) ? 1 : $info['inopera'];

                foreach($datos as $data){
                    $cantidad = abs($data->cantidad) * $inopera;
                    
                    $this->db_b->set('idrec',    0);
                    $this->db_b->set('trannum',  $idrecepcion);
                    $this->db_b->set('itemline', $data->itemline);
                    $this->db_b->set('idcentro', $info['idcentro']);
                    $this->db_b->set('idclase',  $invclase);
                    $this->db_b->set('invcontrol', $invcontrol);
                    $this->db_b->set('idproducto', $data->idproducto);
                    $this->db_b->set('idbatch', $data->idbatch);
                    $this->db_b->set('barcode', $data->barcode);
                    $this->db_b->set('idbin',    $idbin);
                    $this->db_b->set('lote',    $data->lote);
                    $this->db_b->set('fechacp',    $data->fechacp);
                    $this->db_b->set('cantidad', $cantidad);
                    $this->db_b->set('costounitario', $data->costounitario);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('um', $data->um);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('tran_100k');    
                }        
                
                return $query;
            }
        }
        
        function getIdBin($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();
                if($query->num_rows() > 0){
                    return $info['idbin'];
                }else{
                    return "";
                }
            }
        }
        
        function getidcentroRecepcion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcentrod FROM tran_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();
                if($query->num_rows() > 0){
                    return $info['idcentrod'];
                }else{
                    return "";
                }
            }
        }
		
        function getInventarioProductos($idcatalogo, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS ExistenciasLocales,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto) AS ExistenciasTotales,
                    inv_batch.costounitario, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado
                FROM invproducts
                INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                WHERE invproducts.estado = 1 AND invproducts.idcatalogo = $idcatalogo
                GROUP BY invproducts.idproducto";

                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getInventarioProductosTodos($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto) AS ExistenciasLocales,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto) AS ExistenciasTotales,
                    inv_batch.costounitario, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado
                FROM invproducts
                INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                WHERE invproducts.estado = 1 AND invproducts.idcatalogo = $idcatalogo
                GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getLotesProductos($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_stock.idproducto, inv_stock.cantidad, invsites.descrip AS sucursal, inv_batch.descrip AS batch, invlocations.descrip AS location FROM inv_stock INNER JOIN inv_batch ON inv_stock.idbatch = inv_batch.idbatch INNER JOIN invlocations ON invlocations.idbin = inv_stock.idbin INNER JOIN invsites ON invsites.idcentro = inv_stock.idcentro WHERE inv_stock.idproducto = $idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return null;
                }
                
            }
        }
        
        function getLotesProductosSearch($search, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = 1) AS ExistenciasLocales, (SELECT SUM(inv_stock2.cantidad) FROM inv_stock AS inv_stock2 WHERE invproducts.idproducto = inv_stock2.idproducto) AS ExistenciasTotales, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado FROM invproducts WHERE invproducts.estado = 1 AND invproducts.idcatalogo = $idcatalogo AND (invproducts.idproducto = '$search' OR invproducts.descrip LIKE '%$search%' OR invproducts.modelo = '$search%' OR invproducts.marca = '$search' OR invproducts.barcode = '$search' OR invproducts.um = '$search' OR invproducts.xpos = '$search') GROUP BY invproducts.idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getLotesProductosSearchAll($search){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = 1) AS ExistenciasLocales, (SELECT SUM(inv_stock2.cantidad) FROM inv_stock AS inv_stock2 WHERE invproducts.idproducto = inv_stock2.idproducto) AS ExistenciasTotales, invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado FROM invproducts WHERE invproducts.estado = 1 AND invproducts.idproducto = '$search' OR invproducts.descrip LIKE '%$search%' OR invproducts.modelo = '$search' OR invproducts.marca = '$search' OR invproducts.barcode = '$search' OR invproducts.um = '$search' OR invproducts.xpos = '$search' GROUP BY invproducts.idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getValidateLocationByCentro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
        
        function getInventarioSucursales($idsucursales){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $array = explode(",", $idsucursales);
                $cant = count($array);
                $total = $cant - 1;
                $consulta = "SELECT invproducts.idproducto, ";
                $centros_total = "";
                for($i=0; $i<=$total; $i++){
                    $idcentro = $array[$i];
                    $consulta .= " (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE inv_stock.idproducto = invproducts.idproducto AND inv_stock.idcentro = $idcentro) AS Sucursal$idcentro, ";
                    $centros_total .= " inv_stock.idcentro = $idcentro OR ";
                }
                
                $centros_total =  substr($centros_total, 0, -3);
                $consulta.= " (SELECT SUM(inv_stock.cantidad) FROM inv_stock WHERE ( $centros_total ) AND invproducts.idproducto = inv_stock.idproducto) AS ExistenciasTotales,
                invproducts.descrip, invproducts.marca, invproducts.barcode, invproducts.um, invproducts.imagen, invproducts.precioventa, invproducts.modelo, invproducts.upp, invproducts.notas, invproducts.estado, invlocations.descrip as location, inv_batch.descrip as batch 
                FROM inv_stock 
                INNER JOIN invproducts ON (invproducts.idproducto= inv_stock.idproducto) 
                INNER JOIN invlocations ON (invlocations.idbin= inv_stock.idbin) 
                INNER JOIN inv_batch ON (inv_batch.idbatch= inv_stock.idbatch)
                WHERE ($centros_total)
                GROUP BY inv_stock.idproducto, inv_stock.idbatch
                ORDER BY inv_stock.idproducto, inv_stock.idbatch";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getGruposInventario($idcentro, $sMateriaP = 0, $vnLinea = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                $fProducto = ($sMateriaP == 1) ? '(invproducts.tipo = 1 OR invproducts.tipo = 2)' : '(invproducts.tipo = 1)';

                $fLineaCen = ($vnLinea == 0) ? '' : "AND invcatalog.procentro = $idcentro";

                $consulta = "SELECT DISTINCT
                    invcatalog.idcatalogo, invcatalog.descrip, invcatalog2.descrip AS departamento,
                    invcatalog.posicion, invcatalog.imagen
                FROM invproducts
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                INNER JOIN tran_100k ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND $fProducto $fLineaCen
                ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventarioEnvio($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen, (SELECT SUM(IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.estado = 1 GROUP BY invproducts.idcatalogo ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventarioProductoTerminado($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.estado = 1 AND invproducts.tipo = 1 GROUP BY invproducts.idcatalogo ORDER BY invcatalog.descrip";
                $consulta = "
                SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 1
                GROUP BY invproducts.idcatalogo ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventarioMateriaPrima($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 2
                GROUP BY invproducts.idcatalogo ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getGruposInventarioInsumos($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 3
                GROUP BY invproducts.idcatalogo ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }

        function getSumaInventarioProductoTerminado($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }

        function getSumaInventarioMateriaPrima($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 2";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }

        function getSumaInventarioInsumos($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.tipo = 3";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getListadoLineasSalidas($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT DISTINCT
                    invcatalog.idcatalogo, invcatalog.descrip, invcatalog.posicion, invcatalog.imagen
                FROM
                    tran_100k
                INNER JOIN
                    invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN
                    invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE
                    tran_100k.idcentro = $idcentro
                    AND invproducts.estado = 1
                GROUP BY tran_100k.idproducto
                ORDER BY invcatalog.descrip";
                //Verificar Optimización
                //HAVING SUM(tran_100k.cantidad * tran_100k.uniconv) > 0
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
		
		function getGruposServicios($tipo, $idcentro = 0, $vnLinea = 0){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                $fLineaCen = ($vnLinea == 0) ? '' : "AND invcatalog.procentro = $idcentro";

                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, invcatalog.descrip, invcatalog2.descrip AS departamento, invcatalog.posicion, invcatalog.imagen FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo WHERE invproducts.tipo = $tipo $fLineaCen ORDER BY invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
		}
        
        function getGruposAjuste($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT
                    invcatalog.idcatalogo,
                    invcatalog.descrip,
                    invcatalog.imagen
                FROM
                    tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE
                    tran_100k.idcentro = $idcentro
                    AND invproducts.estado = 1
                    AND invproducts.tipo != 4
                ORDER BY
                    invcatalog.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioByCatalog($trannum,$idcatalogo,$idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $info  = $this->db_b->get_where('tran_100', array('trannum' => $trannum))->row_array();
                $idcps = $info['idcps'];

                if ($idcatalogo == 9999) {
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.tipo, invproducts.xpos, invproducts.idproducto, invproducts.tipotax, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.presenta, invproducts.um, invproducts.modelo, invpromulti.precioventa, 
                        invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                        (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe, tran_100k.lote AS lote100k, tran_100k.fechacp
                    FROM tran_100k
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                    INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idcps = $idcps AND invpromulti.idgvar = 9
                    INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1
                    GROUP BY tran_100k.idproducto
                    HAVING SUM(tran_100k.cantidad * tran_100k.uniconv) > 0";
                } else {
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.tipo, invproducts.xpos, invproducts.idproducto, invproducts.tipotax, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.presenta, invproducts.um, invproducts.modelo, invproducts.precioventa, 
                        invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                        (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe, tran_100k.lote AS lote100k, tran_100k.fechacp
                    FROM tran_100k
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                    INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    WHERE tran_100k.idcentro = $idcentro AND invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1
                    GROUP BY tran_100k.idproducto
                    HAVING SUM(tran_100k.cantidad * tran_100k.uniconv) > 0";
                }

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioMasVendido($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.tipo, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND idcatalogo = $idcatalogo AND invproducts.estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getInventarioByProductoVN($idtrannum,$idcentro,$idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.tipo, invproducts.upp, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND inv_stock.cantidad > 0 AND invproducts.idproducto = $idproducto AND invproducts.estado = 1";
                $consulta = "
                SELECT
                    invproducts.idcatalogo, invproducts.tipotax, invproducts.tipo, invproducts.upp, invproducts.idproducto, invproducts.tipotax, invproducts.descrip,
                    invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS cantidad,
                    inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch,
                    (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $idtrannum), 1, 0)) AS existe
                FROM
                    invproducts
                INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                WHERE invproducts.idproducto = $idproducto AND invproducts.estado = 1
                HAVING cantidad > 0";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function getCantidadesCatalogo($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = inv_stock.idproducto AND tran_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND invproducts.estado = 1 AND inv_stock.cantidad > 0 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getFechaIngresaRF($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ingresa FROM orders_100 WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $fechaIngresa = $resultado['ingresa'];

                return $fechaIngresa;
            }
        }
        
        function getInventarioByCatalogAjuste($idtrannum,$idcatalogo,$idcentro,$fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.idcatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen,
                    invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
                    invproducts.costounitario, tran_100k.idbin, tran_100k.idbatch,
                    (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = tran_100k.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe
                FROM
                    tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1 AND tran_100k.ingresa <= '$fechaIngresaRF'
                GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getProductosPendientesAjuste($trannum,$idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.modelo, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
                (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = tran_100k.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe,
                invcatalog.descrip AS nameLinea
                FROM tran_100k
                #INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto AND invproducts.tipo != 4 AND invproducts.tipo != 9
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1
                GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
		
		function getFechaDeUltimoMovimiento($idproducto, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT fecact FROM tran_100 INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum WHERE tran_100k.idproducto = $idproducto AND tran_100.idcentro = $idcentro ORDER BY tran_100.fecact DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
					$fecha = $resultado['fecact'];
                }else{
                    $fecha = "";
                }
				
				return $fecha;
            }
		}
        
        function getCantidadesCatalogoAjuste($idtrannum, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = inv_stock.idproducto AND orders_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND invproducts.estado = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioPro($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro AND invproducts.estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInventarioProDiferentesOld($sucursal, $distintos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCentros = "(";
                $idcentros = explode(",", $sucursal);
                for($i=0; $i<count($idcentros); $i++){
                    $whereCentros .= "tran_100k.idcentro = ".$idcentros[$i]." OR ";
                }
                $whereCentros = substr($whereCentros, 0, -4);
                $whereCentros .= ")";

                if($distintos!=""){
                    $consulta = "SELECT invproducts.idcatalogo, invsites.descrip AS nameSucursal, invcatalog.descrip as linea, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, 
                    invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario,
                    tran_100k.idbin, tran_100k.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro
                    INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch
                    WHERE ".$whereCentros." AND invproducts.estado = 1 AND ($distintos)
                    GROUP BY tran_100k.idproducto";
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invsites.descrip AS nameSucursal, invcatalog.descrip as linea, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, 
                    invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario,
                    tran_100k.idbin, tran_100k.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro
                    INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch
                    WHERE ".$whereCentros." AND invproducts.estado = 1
                    GROUP BY tran_100k.idproducto";
                }
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }

        function getInventarioProDiferentes($sucursal, $distintos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCentros = "(";
                $idcentros = explode(",", $sucursal);
                for($i=0; $i<count($idcentros); $i++){
                    $whereCentros .= "tran_100k.idcentro = ".$idcentros[$i]." OR ";
                }
                $whereCentros = substr($whereCentros, 0, -4);
                $whereCentros .= ")";

                if($distintos!=""){
                    $consulta = "SELECT invproducts.idcatalogo, invsites.descrip AS nameSucursal, invcatalog.descrip as linea, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, 
                    invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, x.descrip AS departamento, 
                    tran_100k.idbin, tran_100k.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invcatalog x ON invcatalog.idnivel1 = x.idcatalogo
                    INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro
                    INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch
                    WHERE ".$whereCentros." AND invproducts.estado = 1 AND invproducts.tipo != 4 AND ($distintos)
                    GROUP BY tran_100k.idproducto";
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invsites.descrip AS nameSucursal, invcatalog.descrip as linea, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, 
                    invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, x.descrip AS departamento, 
                    tran_100k.idbin, tran_100k.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    INNER JOIN invcatalog x ON invcatalog.idnivel1 = x.idcatalogo
                    INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro
                    INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch
                    WHERE ".$whereCentros." AND invproducts.estado = 1 AND invproducts.tipo != 4
                    GROUP BY tran_100k.idproducto";
                }
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
        
        function getBatchLoteProducto($idproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invlocations.idbin, inv_batch.idbatch, CONCAT(inv_batch.descrip,' / ',invlocations.descrip) AS 'batch/lote' FROM inv_batch INNER JOIN invlocations ON invlocations.idcentro = $idcentro WHERE inv_batch.idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getFiltroBuscaProd($name){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $valor = $resultado['valor_num'];
                return $valor;
            }
        }
        
        function getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS cantidad,
                        (SELECT tran_100k.lote FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS lote100k,
                        (SELECT tran_100k.fechacp FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS fechacp,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'
                    HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "
                        SELECT
                            invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                            invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                            (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS cantidad,
                            (SELECT tran_100k.lote FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS lote100k,
                            (SELECT tran_100k.fechacp FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS fechacp,
                            invproducts.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                            (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                        FROM
                            invproducts
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                        INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        WHERE invproducts.estado = 1 AND invpromulti.descrip = '$dato'
                        HAVING cantidad > 0";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS cantidad,
                        (SELECT tran_100k.lote FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS lote100k,
                        (SELECT tran_100k.fechacp FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS fechacp,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.descrip LIKE '%$dato%'
                    HAVING cantidad > 0";
					$query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
					$consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.upp, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip,
                        invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro) AS cantidad,
                        (SELECT tran_100k.lote FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS lote100k,
                        (SELECT tran_100k.fechacp FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.trannum = $trannum) AS fechacp,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch, invcatalog.multiaux,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'
                    HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
		
		function getListadoGeneralesProductos($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invcatalog.descrip AS nameLinea, invproducts.idproducto, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE inv_stock.idcentro = $idcentro AND invproducts.estado = 1 ORDER BY invproducts.descrip";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				
				return $resultado;
            }
		}
		
		function getDatosProductoSearchAjuste($prosearch, $dato, $idcentro, $trannum, $fechaIngresaRF){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
					$consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca,
                        invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS cantidad,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch,
                        (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "
                        SELECT
                            invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca,
                            invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                            (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS cantidad,
                            invproducts.costounitario, invlocations.idbin, inv_batch.idbatch,
                            (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe
                        FROM
                            invproducts
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                        INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        WHERE invproducts.estado = 1 AND invpromulti.descrip = '$dato'";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
				}else if($prosearch == 5){
                    $consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca,
                        invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS cantidad,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch,
                        (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.descrip LIKE '%$dato%'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    $consulta = "
                    SELECT
                        invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, invproducts.descrip, invproducts.marca,
                        invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, invproducts.notas,
                        (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS cantidad,
                        invproducts.costounitario, invlocations.idbin, inv_batch.idbatch,
                        (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM
                        invproducts
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                    INNER JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
		}
		
		function getProductoTrasladoScan($prosearch, $dato, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
				if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, 
                        invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, 
                        invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto 
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                    LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto  AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 
                    WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND (invproducts.$search = '$dato' OR invpromulti.descrip = '$dato')
                    HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, 
                        invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, 
                        invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto 
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                    WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND  invproducts.descrip LIKE '%$dato%'
                    HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.xpos, invcatalog.descrip AS namecatalogo, invproducts.idproducto, 
                        invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.barcode, invproducts.precioventa, 
                        invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch 
                    FROM tran_100k 
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                    INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto 
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo 
                    WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.$search = '$dato'
                    HAVING cantidad > 0";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
		}
		
		function getInformacionProductoToTraslado($idproducto, $idcentro, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idproducto, invproducts.um, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch,
                    (SELECT IF(EXISTS ( SELECT tran_100k2.trannum FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND tran_100k2.trannum = $trannum), 1, 0)) AS existe 
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                WHERE tran_100k.idcentro = $idcentro  AND invproducts.estado = 1  AND invproducts.idproducto = '$idproducto'";
                $query = $this->db_b->query($consulta);
                
				if($query->num_rows() > 0){
					$resultado = $query->result();
					return $resultado;
				}else{
					return 0;
				}
			}
		}
		/*
		function getInformacionProductoToAjuste($idproducto, $idcentro, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idproducto, invproducts.um, inv_stock.cantidad, inv_stock.costounitario, inv_stock.idbin, inv_stock.idbatch, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = inv_stock.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto WHERE inv_stock.idcentro = $idcentro  AND invproducts.estado = 1 AND invproducts.idproducto = '$idproducto'";
				$query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
					return $resultado;
				}else{
					return 0;
				}
			}
		}
		*/
		function getInformacionProductoToAjuste($idproducto, $idcentro, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idproducto, invproducts.um, SUM((tran_100k.cantidad * tran_100k.uniconv)) AS cantidad, inv_batch.costounitario, invlocations.idbin, inv_batch.idbatch,
                            (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = tran_100k.idproducto AND orders_100k.trannum = $trannum), 1,0)) AS existe
                            FROM tran_100k
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro
                            INNER JOIN invlocations ON invsites.idcentro = invlocations.idcentro
                            INNER JOIN inv_batch ON inv_batch.idproducto = tran_100k.idproducto
                            WHERE tran_100k.idcentro = $idcentro AND tran_100k.idbatch != 0
                            AND invproducts.estado = 1
                            AND invproducts.idproducto = '$idproducto'
                            GROUP BY tran_100k.idcentro";
				$query = $this->db_b->query($consulta);
				if($query->num_rows() > 0){
					$resultado = $query->result();
					return $resultado;
				}else{
					return 0;
				}
			}
		}
        
        function validateInsertAjuste($idcentro, $idclase, $estatus){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT trannum FROM orders_100 WHERE idcentro = $idcentro AND cajclase = $idclase AND estatus = $estatus AND agrupa = 'RF'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return false;
                }else{
                    return true;
                }
            }
        }

        function validateInsertVirtualizacion($idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ccontrol FROM virtualsuc_hd WHERE idcentro = $idcentro AND estatus = $estado";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return false;
                }else{
                    return true;
                }
            }
        }
		
        function validateInsertAjusteTransacciones($idcentro, $estatus){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT trannum, inv_def.agrupa, IF(tran_100.idcentro = $idcentro, inv_def.descrip, 'Recepción de Traslado') AS descrip,  tran_100.fecha FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE (tran_100.idcentro = $idcentro AND (inv_def.agrupa = 'VN' OR inv_def.agrupa = 'CO' OR inv_def.agrupa = 'IN') AND tran_100.estatus = $estatus) OR (tran_100.idcentrod = $idcentro AND inv_def.agrupa = 'IN' AND tran_100.estatus = 1)";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return false;
                }else{
                    return true;
                }
            }
        }
		
        function getDatosTransaccionesPendientes($idcentro, $estatus){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT trannum, inv_def.agrupa, IF(tran_100.idcentro = $idcentro, inv_def.descrip, 'Recepción de Traslado') AS descrip,  tran_100.fecha FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase WHERE (tran_100.idcentro = $idcentro AND (inv_def.agrupa = 'VN' OR inv_def.agrupa = 'CO' OR inv_def.agrupa = 'IN') AND tran_100.estatus = $estatus) OR (tran_100.idcentrod = $idcentro AND inv_def.agrupa = 'IN' AND tran_100.estatus = 1)";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
					$resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getDetailAjusteMaster($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100k.trannum, t100k.idproducto, t100k.itemline, inv_batch.costounitario, t100k.cantidad, tp.descrip AS nameproducto, ti.descrip AS tipoajuste, t100.tranref, orders_100k.cantidad AS sistema, orders_100k.cantrp AS fisico FROM tran_100k AS t100k INNER JOIN inv_batch ON t100k.idproducto = inv_batch.idproducto INNER JOIN tran_100 AS t100 ON t100.trannum = t100k.trannum INNER JOIN invproducts AS tp ON t100k.idproducto = tp.idproducto INNER JOIN inv_def AS ti ON t100.idclase = ti.invclase INNER JOIN orders_100 AS o100 ON t100.tranref = o100.trannum INNER JOIN orders_100k ON orders_100k.trannum = o100.trannum AND orders_100k.idproducto = t100k.idproducto WHERE t100.tranref = $trannum AND t100.idcentrod = 0";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }
		
		function getPendientesImpresionAjustes($class1, $class2, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, ti.descrip AS tipoajuste, t100.tranref FROM tran_100 AS t100 INNER JOIN inv_def AS ti ON t100.idclase = ti.invclase INNER JOIN tran_100p ON t100.trannum = tran_100p.trannum AND tran_100p.estatus = $estado WHERE t100.idclase = $class1 OR t100.idclase = $class2";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
		}
        
        function insertarAjusteInv($fecha, $notas, $idcentro, $idclase, $referencia, $recuento, $id_favor, $id_contra){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                $notas = str_replace($buscar, $reemplazar, $notas);
                //$date->format('Y-m-d H:i:s')
                $this->db_b->set('trannum', 0);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', 'RF');
                $this->db_b->set('cajclase', $idclase);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('cli_phone', $id_favor.','.$id_contra);
                $this->db_b->set('cli_notify', $recuento);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha);
				$this->db_b->insert('orders_100');
                
                $idajuste = $this->db_b->insert_id();
                
                if($recuento == 1){
                    $this->db_b->set('invcontrol', 1);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idcentro', $idcentro);
                    $this->db_b->update('invsites');
                }
                
                return $idajuste;
            }
        }
        
        function getInformacionRecuentoFisico($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100.idcentro, orders_100.cli_phone AS id_clases, invlocations.idbin FROM orders_100 INNER JOIN invlocations ON orders_100.idcentro = invlocations.idcentro WHERE orders_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $informacion = $query->row_array();
                
                return $informacion;
            }
        }
        
        function getDatosAjustesInv($idcentro, $cajclase, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT trannum, fecha, orders_100.notas, referencia, estatus, cli_notify, cli_email, lines100k, users.descrip AS user FROM orders_100 INNER JOIN gusers AS users ON orders_100.whodidit = users.iduser WHERE orders_100.idcentro = $idcentro AND cajclase = $cajclase AND fecha BETWEEN '$fechaini' AND '$fechafin'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInformacionAjuste($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100.*, invsites.descrip as centerName FROM orders_100 INNER JOIN invsites ON invsites.idcentro=orders_100.idcentro WHERE trannum = $idtrannum AND cajclase = 99 AND agrupa = 'RF'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        /*
        function getDataAjuste100k($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, inv_stock.cantidad AS saldoproducto, (orders_100k.cantrp - orders_100k.cantidad) AS ajustado FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum INNER JOIN inv_stock ON orders_100k.idproducto = inv_stock.idproducto AND inv_stock.idcentro = orders_100.idcentro WHERE orders_100k.trannum = $idtrannum ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }*/
        
        function getDataAjuste100k($idtrannum, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, invproducts.modelo, gvars.descripcion AS tipoproducto, 
                    invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = orders_100.idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS saldoproducto,
                    (orders_100k.cantrp - orders_100k.cantidad) AS ajustado
                FROM
                    orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                WHERE orders_100k.trannum = $idtrannum
                ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
		
        function getDataAjuste100kreporte($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.precioventa,inv_batch.costounitario,invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch WHERE orders_100k.trannum = $idtrannum ORDER BY invproducts.modelo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataAjuste100kreporteOrdDescrip($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.precioventa,inv_batch.costounitario,orders_100k.trannum,orders_100k.cantidad,orders_100k.cantrp,orders_100k.uniconv,orders_100k.precioneto,orders_100k.notas AS modNotas, invproducts.descrip, invproducts.idproducto,  invproducts.notas,   invproducts.modelo, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch WHERE orders_100k.trannum = $idtrannum ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataAjuste100kreporteOrdDescrip2($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.precioventa,inv_batch.costounitario,orders_100k.cantidad,orders_100k.cantrp,SUM(orders_100k.cantrp-orders_100k.cantidad) as tipo, orders_100k.precioneto,orders_100k.notas AS modNotas, invproducts.descrip, invproducts.idproducto,  invproducts.modelo FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch WHERE orders_100k.trannum = $idtrannum GROUP BY orders_100k.idrec ORDER BY invproducts.descrip ASC LIMIT 501, 1000";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataAjusteFavor($trannum, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, gvars.descripcion AS tipoproducto,
                    invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,
                    invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = orders_100.idcentro  AND tran_100k.ingresa <= '$fechaIngresaRF') AS saldoproducto,
                    (orders_100k.cantrp - orders_100k.cantidad) AS ajustado
                FROM
                    orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                WHERE
                    orders_100k.trannum = $trannum
                AND orders_100k.cantidad < orders_100k.cantrp
                ORDER BY
                    orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataAjusteContra($trannum, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, gvars.descripcion AS tipoproducto,
                    invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,
                    invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = orders_100.idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS saldoproducto,
                    (orders_100k.cantrp - orders_100k.cantidad) AS ajustado
                FROM
                    orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo' 
                LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                WHERE
                    orders_100k.trannum = $trannum
                AND orders_100k.cantidad > orders_100k.cantrp
                ORDER BY
                    orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getDataAjusteSinAjuste($trannum, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT
                    invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen, gvars.descripcion AS tipoproducto, 
                    invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,
                    invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = orders_100.idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS saldoproducto,
                    (orders_100k.cantrp - orders_100k.cantidad) AS ajustado
                FROM
                    orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                WHERE
                    orders_100k.trannum = $trannum
                AND orders_100k.cantidad = orders_100k.cantrp
                ORDER BY
                    orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
		function getDataAjusteProducto100k($trannum, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.xpos, orders_100k.*, orders_100k.notas AS modNotas, invproducts.descrip, invproducts.imagen,
                    invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas,
                    invlocations.descrip AS ubicacion, inv_batch.descrip AS lote,
                    (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = orders_100.idcentro) AS saldoproducto
                FROM orders_100k
                INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto
                LEFT JOIN invlocations ON invlocations.idbin = orders_100k.idbin
                INNER JOIN inv_batch ON inv_batch.idbatch = orders_100k.idbatch
                INNER JOIN orders_100 ON orders_100.trannum = orders_100k.trannum
                WHERE orders_100k.trannum = $trannum AND orders_100k.idproducto = $idproducto
                ORDER BY orders_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
		}
        
        function insertAjuste100k($sistema, $cantidad, $idbatch, $idbin, $idproducto, $um, $trannum, $precio, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idbatch', $idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('cantidad', $sistema);
                $this->db_b->set('cantrp', $cantidad);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('um', $um);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
                return $query;
            }
        }
        
        function insertarProductoAjusteImportado($datoproducto, $cantidad, $busqueda, $trannum, $idcentro, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($busqueda != 'barcode'){
                    $SQLExiste = "SELECT orders_100k.idrec, orders_100k.cantidad, orders_100k.cantrp FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto WHERE orders_100k.trannum = $trannum AND invproducts.$busqueda = '$datoproducto'";
                }else{
                    $SQLExiste = "SELECT orders_100k.idrec, orders_100k.cantidad, orders_100k.cantrp FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE orders_100k.trannum = $trannum AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                }
                
                $QueryEx = $this->db_b->query($SQLExiste);
                if($QueryEx->num_rows() > 0){
                    $infoRegistro = $QueryEx->row_array();
                    
                    if($busqueda != 'barcode'){
                        $SQLInformacion = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        WHERE tran_100k.idcentro = $idcentro AND invproducts.$busqueda = '$datoproducto' AND tran_100k.ingresa <= '$fechaIngresaRF'";
                    }else{
                        $SQLInformacion = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1  WHERE tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF' AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                    }
                    $QueryInformacion = $this->db_b->query($SQLInformacion);
                    $infoProducto = $QueryInformacion->row_array();
                    
                    $idrec = $infoRegistro['idrec'];
                    $cantidadactual = $infoRegistro['cantrp'];
                    $sistema = $infoProducto['cantidad'];
                    $notas = "Producto modificado desde la importación de datos.";
                    $cantidad = $cantidadactual + $cantidad;
                    
                    $this->db_b->set('cantidad', $sistema);
                    $this->db_b->set('cantrp', $cantidad);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $idrec);
                    $query = $this->db_b->update('orders_100k');
                    
                    return $query;
                }else{
                    if($busqueda != 'barcode'){
                        $SQLInformacion = "SELECT invproducts.idproducto, invproducts.costounitario, invproducts.um, invlocations.idbin, inv_batch.idbatch, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                        FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND invproducts.$busqueda = '$datoproducto' AND tran_100k.ingresa <= '$fechaIngresaRF'";
                    }else{
                        $SQLInformacion = "SELECT invproducts.idproducto, invproducts.costounitario, invproducts.um, invlocations.idbin, inv_batch.idbatch, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                        FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                        LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                        INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                        WHERE tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF' AND (invproducts.barcode = '$datoproducto' OR invpromulti.descrip = '$datoproducto')";
                    }
                    
                    $QueryInformacion = $this->db_b->query($SQLInformacion);
                    $infoProducto = $QueryInformacion->row_array();
                    
                    $sistema = $infoProducto['cantidad'];
                    $idbatch = $infoProducto['idbatch'];
                    $idbin = $infoProducto['idbin'];
                    $idproducto = $infoProducto['idproducto'];
                    $um = $infoProducto['um'];
                    $precio = $infoProducto['costounitario'];
                    $notas = "Producto agregado desde la importación de datos.";
                    
                    $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                    $query = $this->db_b->query($consulta);
                    
                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $itemLine = $resultado['itemline'] + 1;
                    }else{
                        $itemLine = 1;
                    }
                    
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('cantidad', $sistema);
                    $this->db_b->set('cantrp', $cantidad);
                    $this->db_b->set('precioneto', $precio);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('orders_100k');
                    
                    return $query;
                }
            }
        }
        
        function getInformacionIngresadaArchivo($documentTemp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $archivoTxt = fopen($documentTemp, "r") or exit("Unable to open file!");
                
                $cadenaTxt = "";
                while(!feof($archivoTxt)){
                    $cadenaTxt .= fgets($archivoTxt);
                }
                
                fclose($archivoTxt);
                
                return $cadenaTxt;
            }
        }
        
        function updateAjuste100k($idrec, $cantidad, $sistema, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('cantidad', $sistema);
                $this->db_b->set('cantrp', $cantidad);
				$this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');
                return $query;
            }
        }
        
        function generarRecalculadoRecuento($trannum, $idcentro, $fechaIngresaRF){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT orders_100k.idrec, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = orders_100k.idproducto AND tran_100k.idcentro = $idcentro AND tran_100k.ingresa <= '$fechaIngresaRF') AS cantidad FROM orders_100k WHERE orders_100k.trannum = $trannum ORDER BY orders_100k.itemline DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                foreach($resultado as $info){
                    $this->db_b->set('cantidad', $info->cantidad);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idrec', $info->idrec);
                    $query = $this->db_b->update('orders_100k');
                }
                
                return $query;
            }
        }
        
        function actualizarVenta100k($idrec, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax,$pro_vende,$modevn){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $nedescuento = str_replace("%", "", $descuento);
                $precioneto = (1 - ($nedescuento / 100)) * $precio;
                
				if($tipotax != 0){
                    $taxdes = ($tipotax / 100) + 1;
                    $precioneto = $precioneto / $taxdes;
                }
				
                $ConSQL = "SELECT idclase FROM tran_100 WHERE trannum = $trannum";
                $QSQL = $this->db_b->query($ConSQL);
                $Res = $QSQL->row_array();
                $idclase = $Res['idclase'];

                $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $inopera = $Res2['inopera'];
                
                $newCant = $cantidad * $inopera;
                
				$this->db_b->set('cantidad', $newCant);
                $this->db_b->set('precioneto', $precioneto);
                $this->db_b->set('preciotran', $precio);
                $this->db_b->set('descuento', $nedescuento);
				$this->db_b->set('idworker', $pro_vende);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100k');
                return $query;
            }
        }
        
        function insertAjusteFavorContra($trannum, $idcentro, $idclase, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
				$ConSQL2 = "SELECT fecha, ingresa FROM orders_100 WHERE trannum = ".$trannum;
                $QSQL2 = $this->db_b->query($ConSQL2);
                $Res2 = $QSQL2->row_array();
                $fecha_aj = $Res2['fecha'];
                $fechai_aj = $Res2['ingresa'];
				
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('tranref', $trannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha_aj);
                $this->db_b->set('fecact', $fecha_aj);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fechai_aj);
                $query = $this->db_b->insert('tran_100');
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
        
        function insertDetalleAjusteFavor($trannum, $datos, $idcentro, $idclase, $idbin, $fechaIngresaRF = ''){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $res = $query->row_array();
                $agrupa = $res['agrupa'];
                $inopera = $res['inopera'];
                
                foreach($datos as $info){
                    $cantAjuste = $info->cantrp - $info->cantidad;
                    if($cantAjuste > 0){
                        $nuevacantidad = $inopera * abs($cantAjuste);
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $info->itemline);
                        $this->db_b->set('idcentro', $idcentro);
                        $this->db_b->set('idproducto', $info->idproducto);
                        $this->db_b->set('idbatch', $info->idbatch);
                        $this->db_b->set('idbin', $idbin);
                        $this->db_b->set('cantidad', $nuevacantidad);
                        $this->db_b->set('um', $info->um);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('costounitario', $info->precioneto);
                        $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', ($$fechaIngresaRF = '') ? $date->format('Y-m-d H:i:s') : $fechaIngresaRF);
                        $query = $this->db_b->insert('tran_100k');
                    }
                }
                
                return $query;
            }
        }
        
        function insertDetalleAjusteContra($trannum, $datos, $idcentro, $idclase, $idbin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
                $query = $this->db_b->query($consulta);
                $res = $query->row_array();
                $agrupa = $res['agrupa'];
                $inopera = $res['inopera'];
                
                foreach($datos as $info){
                    $cantAjuste = $info->cantrp - $info->cantidad;
                    if($cantAjuste < 0){
                        $nuevacantidad = $inopera * abs($cantAjuste);
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $info->itemline);
                        $this->db_b->set('idcentro', $idcentro);
                        $this->db_b->set('idproducto', $info->idproducto);
                        $this->db_b->set('idbatch', $info->idbatch);
                        $this->db_b->set('idbin', $idbin);
                        $this->db_b->set('cantidad', $nuevacantidad);
                        $this->db_b->set('um', $info->um);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('costounitario', $info->precioneto);
                        $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $query = $this->db_b->insert('tran_100k');
                    }
                }
                
                return $query;
            }
        }
        
        function updateEstatusOrder_100($trannum, $idcentro, $idsorder, $notas, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT COUNT(idrec) AS total FROM orders_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $res = $query->row_array();
                $total = $res['total'];
                
                $this->db_b->set('cli_email', $idsorder);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('fecact',  $date->format('Y-m-d'));
                $this->db_b->set('lines100k', $total);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                $this->db_b->set('invcontrol', 0);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idcentro', $idcentro);
				$this->db_b->update('invsites');
                
                return $query;
            }
        }
        
        function verificarExistenciaProductoCodigo($idproducto, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.idproducto = '$idproducto'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return 0;
                }else{
                    return 1;
                }
            }
        }
        
        function verificarExistenciaProductoBarras($barcode, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND (invproducts.barcode = '$barcode' OR invpromulti.descrip = '$barcode')";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return 0;
                }else{
                    return 1;
                }
            }
        }
        
        function verificarExistenciaProductoModelo($modelo, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.modelo = '$modelo'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return 0;
                }else{
                    return 1;
                }
            }
        }
        
        function verificarExistenciaProductoXpos($xpos, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                WHERE tran_100k.idcentro = $idcentro AND invproducts.estado = 1 AND invproducts.xpos = '$xpos'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    return 0;
                }else{
                    return 1;
                }
            }
        }
        
        function get_Existencias_Kardex(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT invproducts.idproducto AS id, invproducts.idcatalogo, invcatalog.idnivel1, invproducts.descrip AS producto, invproducts.marca AS marca, invproducts.modelo AS modelo, invproducts.um AS um, invproducts.precioventa AS precioventa, SUM(inv_stock.cantidad) AS cantidad, invcatalog.descrip as linea FROM inv_stock INNER JOIN invproducts ON inv_stock.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo GROUP BY inv_stock.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_Existencias_Kardex_Departamento($depto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT invproducts.idproducto AS id, invproducts.idcatalogo, invcatalog.idnivel1, invproducts.descrip AS producto, invproducts.marca AS marca, invproducts.modelo AS modelo, invproducts.um AS um, invproducts.precioventa AS precioventa, SUM(tran_100k.cantidad*tran_100k.uniconv) AS cantidad, invcatalog.descrip AS linea FROM invproducts INNER JOIN tran_100k  ON tran_100k.idproducto=invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invcatalog.idnivel1 = $depto GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_Detalle_Existencias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT  invproducts.idproducto, invsites.descrip AS centro, invlocations.idbin, inv_batch.idbatch, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, SUM(tran_100k.cantidad*tran_100k.uniconv) AS cantidad FROM invproducts INNER JOIN  tran_100k ON invproducts.idproducto=tran_100k.idproducto INNER JOIN invsites ON tran_100k.idcentro = invsites.idcentro INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin INNER JOIN inv_batch ON tran_100k.idbatch = inv_batch.idbatch GROUP BY invproducts.idproducto , tran_100k.idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
        function getMovProduct($idbin,$idbatch){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT (SELECT IFNULL(SUM(cantidad),0) FROM tran_100k where trannum=0 AND idbatch=$idbatch AND idbin=$idbin) AS suma_salidas, tran_100.fecha,  tran_100.fecact,  tran_100.notas AS notas_doc,tran_100.referencia AS referencia_doc, tran_100k.um,invproducts.marca, tran_100.trannum, tran_100.idcentro, tran_100.idcentrod, invsites.descrip as o_d, inv_def.invclase, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as num,tran_100k.itemline,  tran_100k.cantidad, tran_100k.idrec, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario, tran_100k.precioneto, tran_100k.notas, ctauxi.descrip as cliente_proveedor, ctauxi2.descrip AS nameidworker, inv_def.agrupa, gusers.descrip as usuario, tran_100.ingresa, tran_100.modifica FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum  INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto LEFT JOIN invsites ON invsites.idcentro= tran_100.idcentrod LEFT JOIN ctauxi AS ctauxi ON ctauxi.idauxi = tran_100.idcps LEFT JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idworker INNER JOIN gusers ON gusers.iduser=tran_100.whodidit where tran_100k.idbin='$idbin' and tran_100k.idbatch='$idbatch' ORDER BY tran_100.fecact,tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getSimpleMovProduct($idbin,$idbatch){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT (SELECT IFNULL(SUM(cantidad), 0) FROM tran_100k WHERE trannum=0 AND idbatch=$idbatch AND idbin=$idbin) AS suma_salidas, 
                tran_100.fecha, tran_100k.ingresa, tran_100k.idrec, tran_100k.um, tran_100.trannum, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as num, tran_100k.cantidad, tran_100k.uniconv, IF(inv_def.agrupa = 'CO', tran_100k.preciotran, 0) AS preciotran, tran_100k.costounitario, tran_100k.precioneto,ctauxi.descrip AS nombreAuxi, tran_100k.notas as notasM, tran_100.notas as notasHD,
                tran_100.estatus, invsites.descrip AS o_d, inv_def.agrupa 
                FROM tran_100k 
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase 
                LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                LEFT JOIN invsites ON invsites.idcentro= tran_100.idcentrod
                WHERE tran_100k.idbin='$idbin' and tran_100k.idbatch='$idbatch' 
                ORDER BY tran_100k.ingresa ASC";
                #ORDER BY tran_100.fecha, tran_100.trannum ASC";
                #ORDER BY tran_100.fecact, tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getMoreDetailKardex( $idrec ){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.fecha,  tran_100.fecact,  tran_100.notas AS notas_doc, tran_100.referencia AS referencia_doc, tran_100k.um,invproducts.marca, tran_100.trannum, tran_100.idcentro, tran_100.idcentrod, invsites.descrip as o_d, inv_def.invclase, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as num,tran_100k.itemline,  tran_100k.cantidad, tran_100k.idrec, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario, tran_100k.precioneto, tran_100k.notas, ctauxi.descrip as cliente_proveedor, ctauxi2.descrip AS nameidworker, inv_def.agrupa, gusers.descrip as usuario, tran_100.ingresa, tran_100.modifica FROM tran_100k 
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                LEFT JOIN invsites ON invsites.idcentro = tran_100.idcentrod 
                LEFT JOIN ctauxi AS ctauxi ON ctauxi.idauxi = tran_100.idcps 
                LEFT JOIN ctauxi AS ctauxi2 ON ctauxi2.idauxi = tran_100.idworker 
                INNER JOIN gusers ON gusers.iduser = tran_100.whodidit 
                WHERE tran_100k.idrec = $idrec 
                ORDER BY tran_100.fecact, tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }
        
        function getDistictMov($idbin,$idbatch){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT inv_def.invclase, inv_def.descrip FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase WHERE tran_100k.idbin = '$idbin' AND tran_100k.idbatch = '$idbatch' GROUP BY inv_def.invclase";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos_Linea($lineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $lineas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $lin = $array[$i];
                        $where .= " invcatalog.idcatalogo = $lin OR";
                    }
                    $where =  substr($where, 0, -3);
                }else{
                    $where .= " invcatalog.idcatalogo = $lineas ";
                }
                
                if($where==""){
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }else{
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE ($where) AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctMarcas_lineas($lineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $lineas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $lin = $array[$i];
                        $where .= " invcatalog.idcatalogo = $lin OR";
                    }
                    $where =  substr($where, 0, -3);
                }else{
                    $where .= " invcatalog.idcatalogo = $lineas ";
                }
                if($where==""){
                    $consulta = "SELECT CONCAT(invproducts.marca, ' (', COUNT(invproducts.idproducto),')') as text, invproducts.marca as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE  invproducts.estado = 1 GROUP BY  invproducts.marca ORDER BY  invproducts.marca ASC";
                }else{
                    $consulta = "SELECT CONCAT(invproducts.marca, ' (', COUNT(invproducts.idproducto),')') as text, invproducts.marca as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) AND invproducts.estado = 1 GROUP BY  invproducts.marca ORDER BY  invproducts.marca ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctProvee_lineas($lineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $lineas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $lin = $array[$i];
                        $where .= " invcatalog.idcatalogo = $lin OR";
                    }
                    $where =  substr($where, 0, -3);
                }else{
                    $where .= " invcatalog.idcatalogo = $lineas ";
                }
                if($where==""){
                    $consulta = "SELECT CONCAT(ctauxi.descrip, ' (', COUNT(invproducts.idprovee), ') ') AS text, ctauxi.idauxi AS id FROM invproducts INNER JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE invproducts.estado = 1 GROUP BY ctauxi.idauxi ORDER BY ctauxi.descrip ASC";
                }else{
                    $consulta = "SELECT CONCAT(ctauxi.descrip, ' (', COUNT(invproducts.idprovee), ') ') AS text, ctauxi.idauxi AS id FROM invproducts INNER JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee  INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) AND invproducts.estado = 1 GROUP BY ctauxi.idauxi ORDER BY ctauxi.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos_Provee($provee){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $provee);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                for($i=0; $i<=$total; $i++){
                    $pr = $array[$i];
                    $where .= " invproducts.idprovee = $pr OR";
                }
                $where =  substr($where, 0, -3);
                if($where==""){
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }else{
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE ($where) AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctMarcas_provee($provee){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $provee);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                for($i=0; $i<=$total; $i++){
                    $pr = $array[$i];
                    $where .= " invproducts.idprovee = $pr OR";
                }
                $where =  substr($where, 0, -3);
                if($where==""){
                    $consulta = "SELECT CONCAT(invproducts.marca, ' (', COUNT(invproducts.idproducto),')') as text, invproducts.marca as id FROM invproducts  WHERE  invproducts.estado = 1 GROUP BY  invproducts.marca ORDER BY  invproducts.marca ASC";
                }else{
                    $consulta = "SELECT CONCAT(invproducts.marca, ' (', COUNT(invproducts.idproducto),')') as text, invproducts.marca as id FROM invproducts  WHERE ($where) AND invproducts.estado = 1 GROUP BY  invproducts.marca ORDER BY  invproducts.marca ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctLineas_provee($provee){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $provee);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                for($i=0; $i<=$total; $i++){
                    $pr = $array[$i];
                    $where .= " invproducts.idprovee = $pr OR";
                }
                $where =  substr($where, 0, -3);
                if($where==""){
                    $consulta = "SELECT CONCAT(invcatalog.descrip, ' (', COUNT(invcatalog.idcatalogo),')') as text, invcatalog.idcatalogo as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE  invproducts.estado = 1 GROUP BY  invcatalog.idcatalogo ORDER BY  invcatalog.descrip ASC";
                }else{
                    $consulta = "SELECT CONCAT(invcatalog.descrip, ' (', COUNT(invcatalog.idcatalogo),')') as text, invcatalog.idcatalogo as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) AND invproducts.estado = 1 GROUP BY  invcatalog.idcatalogo ORDER BY  invcatalog.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProductos_Marcas($marcas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $marcas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $mar = trim($array[$i]);
                        $where .= " invproducts.marca LIKE '$mar' OR";
                    }
                    $where =  substr($where, 0, -3);
                }else{
                    $where .= " invproducts.marca LIKE '$marcas'";
                }
               
                if($where==""){
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }else{
                    $consulta = "SELECT ctauxi.descrip as proveedor, invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee WHERE ($where) AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctLineas_marcas($marcas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $marcas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $mar = trim($array[$i]);
                        $where .= " invproducts.marca LIKE '$mar' OR";
                    }
                    $where =  substr($where, 0, -3);
                }else{
                    $where .= " invproducts.marca LIKE '$marcas'";
                }
                if($where==""){
                    $consulta = "SELECT CONCAT(invcatalog.descrip, ' (', COUNT(invcatalog.idcatalogo),')') as text, invcatalog.idcatalogo as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE  invproducts.estado = 1 GROUP BY  invcatalog.idcatalogo ORDER BY  invcatalog.descrip ASC";
                }else{
                    $consulta = "SELECT CONCAT(invcatalog.descrip, ' (', COUNT(invcatalog.idcatalogo),')') as text, invcatalog.idcatalogo as id FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) AND invproducts.estado = 1 GROUP BY  invcatalog.idcatalogo ORDER BY  invcatalog.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDistinctProvee_marcas($marcas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = explode(",", $marcas);
                $cant = count($array);
                $total = $cant - 1;
                $where = "";
                if($total>0){
                    for($i=0; $i<=$total; $i++){
                        $mar = trim($array[$i]);
                        $where .= " invproducts.marca LIKE '$mar' OR";
                    }
                    $where =  substr($where, 0, -3);    
                }else{
                    $where .= " invproducts.marca LIKE '$marcas' ";
                }
                
                if($where==""){
                    $consulta = "SELECT CONCAT(ctauxi.descrip, ' (', COUNT(invproducts.idprovee), ') ') AS text, ctauxi.idauxi AS id FROM invproducts LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE invproducts.estado = 1 GROUP BY ctauxi.idauxi ORDER BY ctauxi.descrip ASC";
                }else{
                    $consulta = "SELECT CONCAT(ctauxi.descrip, ' (', COUNT(invproducts.idprovee), ') ') AS text, ctauxi.idauxi AS id FROM invproducts LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee  LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE ($where) AND invproducts.estado = 1 GROUP BY ctauxi.idauxi ORDER BY ctauxi.descrip ASC";
                }
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getLotesProducto_selected($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT inv_stock.idproducto, inv_stock.idbin, inv_stock.idbatch, inv_stock.cantidad, invsites.descrip AS sucursal, inv_batch.descrip AS batch, invlocations.descrip AS location FROM inv_stock INNER JOIN inv_batch ON inv_stock.idbatch = inv_batch.idbatch INNER JOIN invlocations ON invlocations.idbin = inv_stock.idbin INNER JOIN invsites ON invsites.idcentro = inv_stock.idcentro WHERE inv_stock.idproducto = $idproducto  AND invsites.estatus=1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                 if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return null;
                }
                
            }
        }
    
        function getProducts_filter($primer_filtro_linea, $primer_filtro_provee, $primer_filtro_marca, $filter_mar_selected, $filter_pro_selected, $filter_lines_selected){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            
                if($primer_filtro_linea!=""){
                    $array = explode(",", $primer_filtro_linea);
                    $cant = count($array);
                    $total = $cant - 1;
                    $where = "";
                    if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $lin = $array[$i];
                            $where .= " invcatalog.idcatalogo = $lin OR ";
                        }
                        $where =  substr($where, 0, -3);
                    }else{
                        $where .= " invcatalog.idcatalogo = $primer_filtro_linea ";
                    }
                    $whereinterno="";
                    if($filter_mar_selected!=""){
                        $whereinterno=" AND (";
                        $array = explode(",", $filter_mar_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $mar = trim($array[$i]);
                                $whereinterno .= " invproducts.marca LIKE '$mar' OR";
                            }   
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $filter_mar_selected = trim($filter_mar_selected);
                            $whereinterno .= " invproducts.marca LIKE '$filter_mar_selected' ";
                        }
                        $whereinterno.=")";
                    }
                    if($filter_pro_selected!=""){
                        if( $whereinterno==""){
                            $whereinterno=" AND (";
                        }else{
                            $whereinterno.= " AND ( ";
                        }
                        $array = explode(",", $filter_pro_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $pr = $array[$i];
                                $whereinterno .= " invproducts.idprovee = $pr OR";
                            }
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $whereinterno .= " invproducts.idprovee = $filter_pro_selected ";
                        }
                        $whereinterno.=")";
                    }
                    if($where==""){
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }else{
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE ($where) $whereinterno AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                    return $resultado;
                }
                else if($primer_filtro_provee!=""){
                    $array = explode(",", $primer_filtro_provee);
                    $cant = count($array);
                    $total = $cant - 1;
                    $where = "";
                    if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $pr = $array[$i];
                            $where .= " invproducts.idprovee = $pr OR ";
                        }
                        $where =  substr($where, 0, -3);
                    }else{
                        $where .= " invproducts.idprovee = $primer_filtro_provee ";
                    }
                    $whereinterno="";
                    if($filter_mar_selected!=""){
                        $whereinterno=" AND (";
                        $array = explode(",", $filter_mar_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $mar = trim($array[$i]);
                                $whereinterno .= " invproducts.marca LIKE '$mar' OR";
                            }   
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $filter_mar_selected = trim($filter_mar_selected);
                            $whereinterno .= " invproducts.marca LIKE '$filter_mar_selected' ";
                        }
                        $whereinterno.=")";
                    }
                    if($filter_lines_selected!=""){
                        if( $whereinterno==""){
                            $whereinterno=" AND (";
                        }else{
                            $whereinterno.= " AND ( ";
                        }
                        $array = explode(",", $filter_lines_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $lin = $array[$i];
                                $whereinterno .= " invcatalog.idcatalogo = $lin OR ";
                            }
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $whereinterno .= " invcatalog.idcatalogo =  $filter_lines_selected ";
                        }
                        $whereinterno.=")";
                    }
                    if($where==""){
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }else{
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE ($where) $whereinterno AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                    return $resultado;
                }
                else if($primer_filtro_marca!=""){
                    $array = explode(",", $primer_filtro_marca);
                    $cant = count($array);
                    $total = $cant - 1;
                    $where = "";
                    if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $mar = trim($array[$i]);
                            $where .= " invproducts.marca LIKE '$mar' OR ";
                        }
                        $where =  substr($where, 0, -3);
                    }else{
                        $primer_filtro_marca = trim($primer_filtro_marca);
                        $where .= " invproducts.marca LIKE = '$primer_filtro_marca'' ";
                    }
                    $whereinterno="";
                    if($filter_pro_selected!=""){
                       $whereinterno=" AND (";
                        $array = explode(",", $filter_pro_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $pr = $array[$i];
                                $whereinterno .= " invproducts.idprovee = $pr OR";
                            }   
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $whereinterno .= " invproducts.idprovee = $filter_pro_selected ";
                        }
                        $whereinterno.=")";
                    }
                    if($filter_lines_selected!=""){
                        if( $whereinterno==""){
                            $whereinterno=" AND (";
                        }else{
                            $whereinterno.= " AND ( ";
                        }
                        $array = explode(",", $filter_lines_selected);
                        $cant = count($array);
                        $total = $cant - 1;
                        if($total>0){
                            for($i=0; $i<=$total; $i++){
                                $lin = $array[$i];
                                $whereinterno .= " invcatalog.idcatalogo = $lin OR ";
                            }
                            $whereinterno =  substr($whereinterno, 0, -3);
                        }else{
                            $whereinterno .= " invcatalog.idcatalogo = $filter_lines_selected ";
                        }
                        $whereinterno.=")";
                    }
                    if($where==""){
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE  invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }else{
                        $consulta = "SELECT ctauxi.descrip as proveedor,invproducts.xpos, invcatalog.descrip as linea, invproducts.idproducto as idproduct, invproducts.marca, invproducts.modelo, invproducts.barcode,  invproducts.descrip AS producto_name,  invproducts.imagen FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON ctauxi.idauxi= invproducts.idprovee WHERE ($where) $whereinterno AND invproducts.estado = 1 GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
                    }
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->result();
                    return $resultado;
                    
                }
                else{
                    return false;
                }
            }
        }

        function getInvValorizado_Dept($idsucursal,$tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invcatalog2.idcatalogo, invcatalog2.descrip, COUNT(DISTINCT tran_100k.idproducto) as unidades, SUM(tran_100k.cantidad * tran_100k.uniconv) as saldo,
                    SUM((tran_100k.cantidad * tran_100k.uniconv) * inv_batch.costounitario) AS costo,  
                    SUM((tran_100k.cantidad * tran_100k.uniconv) * (invproducts.precioventa/(1+(invproducts.tipotax/100)))) AS venta, invcatalog.tipo
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                WHERE tran_100k.idcentro = $idsucursal AND invcatalog.tipo = $tipopro
                GROUP BY invcatalog2.idcatalogo
                HAVING saldo != 0 ORDER BY invcatalog2.descrip ASC";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                 if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
		
        function getInvValorizado_Dept_AllSucursales($tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invcatalog2.idcatalogo, invcatalog2.descrip, 
                                    SUM(tran_100k.cantidad * tran_100k.uniconv) as saldo,
                                    COUNT(tran_100k.idproducto) as unidades,
                                    SUM((tran_100k.cantidad * tran_100k.uniconv) * inv_batch.costounitario) AS costo,  
                                    SUM((tran_100k.cantidad * tran_100k.uniconv) * (invproducts.precioventa/(1+(invproducts.tipotax/100)))) AS venta, invcatalog.tipo
                            FROM tran_100k
                            INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                            INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                            INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                            INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                            WHERE invcatalog.tipo = $tipopro
                            GROUP BY invcatalog2.idcatalogo 
                            HAVING saldo != 0 ORDER BY invcatalog2.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                 if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
		
        function getInvValorizado_Lineas($idsucursal){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //SUM(inv_stock.cantidad * (invproducts.precioventa-(invproducts.tipotax/100))) AS venta,
                $consulta = "SELECT invcatalog.idcatalogo, invcatalog.descrip AS linea, COUNT(DISTINCT tran_100k.idproducto) as unidades, SUM(tran_100k.cantidad * tran_100k.uniconv) as saldo,
                    SUM((tran_100k.cantidad * tran_100k.uniconv) * inv_batch.costounitario) AS costo, 
                    SUM((tran_100k.cantidad * tran_100k.uniconv) * (invproducts.precioventa/(1+(invproducts.tipotax/100)))) AS venta, invcatalog.idnivel1
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo
                WHERE tran_100k.idcentro = $idsucursal
                GROUP BY invcatalog.idcatalogo
                HAVING saldo != 0 
                ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                 if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
        
        function getInvValorizado_Lineas_AllSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //SUM(inv_stock.cantidad * (invproducts.precioventa-(invproducts.tipotax/100))) AS venta,
                $consulta = "SELECT
                invcatalog.idcatalogo, invcatalog.descrip AS linea,(SELECT IFNULL(count(ivp.idproducto), 0) FROM invproducts AS ivp WHERE ivp.idcatalogo = invcatalog.idcatalogo AND ivp.estado = 1) AS cant,
                COUNT(tran_100k.idproducto) as unidades,
                SUM(tran_100k.cantidad * tran_100k.uniconv) as saldo,
                SUM((tran_100k.cantidad * tran_100k.uniconv) * inv_batch.costounitario) AS costo,
                SUM((tran_100k.cantidad * tran_100k.uniconv) * (invproducts.precioventa/(1+(invproducts.tipotax/100)))) AS venta,
                invcatalog.idnivel1
                FROM tran_100k
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                WHERE invproducts.estado = 1 GROUP BY invcatalog.idcatalogo 
                HAVING saldo != 0 ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                 if($query->num_rows() > 0){
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
		
		function insertarProductoTrasladoScanJob($trannum, $idproducto, $cantidad){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$SQLTran100kt = "SELECT idrec, notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJ000'";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
				
				if($QueryTran100kt->num_rows()>0){
					$informacion = $QueryTran100kt->row_array();
					$idproductos = $informacion['notas'];

					$info = explode(";", $idproductos);
					$total = count($info);
					$search = 0;
					
					for($i=0; $i<$total; $i++){
						$infoProd = explode(",", $info[$i]);
						if($infoProd[0] == $idproducto){
							$total_datos = $infoProd[1] + 1;
							$info[$i] = $infoProd[0].",".$total_datos;
							$search = 1;
						}
					}

					if($search == 1){
						$idproductos = implode(";", $info);
					}else{
						if($idproductos == ""){
							$idproductos = $idproducto.",".$cantidad;
						}else{
							$idproductos = $idproductos.";".$idproducto.",".$cantidad;
						}
					}

					$this->db_b->set('notas', $idproductos);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('trannum', $trannum);
					$this->db_b->where('um', 'SCJ000');
					$Query_updt = $this->db_b->update('tran_100kt');
				}else{
					$idproductos = $idproducto.",".$cantidad;
					
					$this->db_b->set('trannum', $trannum);
					$this->db_b->set('um', 'SCJ000');
					$this->db_b->set('notas', $idproductos);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$Query_updt = $this->db_b->insert('tran_100kt');
				}
				
				return $Query_updt;
			}
		}
		
		function insertarProductoAjusteScanJob($trannum, $idproducto, $cantidad, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$SQLTran100kt = "SELECT idrec, notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJA00".$numero."' AND uniconv = 0";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
				
				if($QueryTran100kt->num_rows()>0){
					$informacion = $QueryTran100kt->row_array();
					$idproductos = $informacion['notas'];

					$info = explode(";", $idproductos);
					$total = count($info);
					$search = 0;
					
					for($i=0; $i<$total; $i++){
						$infoProd = explode(",", $info[$i]);
						if($infoProd[0] == $idproducto){
							$total_datos = $infoProd[1] + $cantidad;
							$info[$i] = $infoProd[0].",".$total_datos;
							$search = 1;
						}
					}

					if($search == 1){
						$idproductos = implode(";", $info);
					}else{
						if($idproductos == ""){
							$idproductos = $idproducto.",".$cantidad;
						}else{
							$idproductos = $idproductos.";".$idproducto.",".$cantidad;
						}
					}

					$this->db_b->set('notas', $idproductos);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
					$this->db_b->where('trannum', $trannum);
					$this->db_b->where('um', 'SCJA00'.$numero);
					$this->db_b->where('uniconv', '0');
					$Query_updt = $this->db_b->update('tran_100kt');
				}else{
					$idproductos = $idproducto.",".$cantidad;
					
					$this->db_b->set('trannum', $trannum);
					$this->db_b->set('uniconv', '0');
					$this->db_b->set('um', 'SCJA00'.$numero);
					$this->db_b->set('notas', $idproductos);
					$this->db_b->set('whodidit',$this->session->userdata('iduser'));
					$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					$Query_updt = $this->db_b->insert('tran_100kt');
				}
			}
		}
				
		function deleteProductoAjusteScanJob($trannum, $idproducto, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$SQLTran100kt = "SELECT idrec, notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJA00".$numero."' AND uniconv = 0";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
				$informacion = $QueryTran100kt->row_array();
				$idproductos = $informacion['notas'];
				
				$info = explode(";", $idproductos);
				$total = count($info);
				$search = 0;
				
				for($i=0; $i<$total; $i++){
					$infoProd = explode(",", $info[$i]);
					if($infoProd[0] == $idproducto){
						unset($info[$i]);
					}
				}
				
				$idproductos = implode(";", $info);
				
				$this->db_b->set('notas', $idproductos);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
				$this->db_b->where('trannum', $trannum);
				$this->db_b->where('um', 'SCJA00'.$numero);
				$this->db_b->where('uniconv', '0');
				$Query_updt = $this->db_b->update('tran_100kt');
				
				return $Query_updt;
			}
		}
		
		function clearDatosScanTraslado($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLTran100kt = "DELETE FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJ000'";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
				return $QueryTran100kt;
			}
		}
		
		function clearDatosScan($trannum, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLTran100kt = "DELETE FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJA00".$numero."' AND uniconv = 0";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
				
				return $QueryTran100kt;
			}
		}
		
		function closeLoteScanTraslado($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('um', 'SCJ999');
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('um', 'SCJ000');
                $query = $this->db_b->update('tran_100kt');
                return $query;
			}
		}
		
		function closeLoteScanAjuste($trannum, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $this->db_b->set('uniconv', '9');
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
				$this->db_b->where('um', 'SCJA00'.$numero);
                $query = $this->db_b->update('tran_100kt');
                return $query;
			}
		}
		
		function getInformacionScanGridTraslado($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLTran100kt = "SELECT notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJ000'";
                $QueryTran100kt = $this->db_b->query($SQLTran100kt);
                
				if($QueryTran100kt->num_rows()>0){
					$informacion = $QueryTran100kt->row_array();
                    $codigos = $informacion['notas'];
                }else{
                    $codigos = "";
                }
				
                return $codigos;
			}
		}
		
		function getInformacionScanGrid($trannum, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJA00".$numero."' AND uniconv = 0";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
                if($query->num_rows()>0){
                    $codigos = $datos['notas'];
                }else{
                    $codigos = "";
                }
                return $codigos;

			}
		}
		
		function getNameProductoByCodigo($idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT descrip FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$descrip = $datos['descrip'];
				return $descrip;
			}
		}
		/* Modificado 20180703 
		function getSaldoProductoByCodigo($idproducto, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT cantidad FROM inv_stock WHERE idproducto = $idproducto AND idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$cantidad = $datos['cantidad'];
				return $cantidad;
			}
		}
		*/
		function getSaldoProductoByCodigo($idproducto, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad FROM tran_100k WHERE tran_100k.idproducto = $idproducto AND tran_100k.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$cantidad = $datos['cantidad'];
				return $cantidad;
			}
		}
        
        function getSaldoProducto($valor, $ingresar, $busqueda, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idproducto, invproducts.descrip, CONCAT('$valor', ',',  $ingresar) AS info_txt, $ingresar AS cantidad, SUM(tran_100k.cantidad * tran_100k.uniconv) AS saldo FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE invproducts.$busqueda = '$valor' AND tran_100k.idcentro = $idcentro";
                $query = $this->db_b->query($consulta);
                $infoSource = $query->row_array();
				
				return $infoSource;
			}
		}
		
		function getCodigoRegistro100k($idproducto, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT idrec, cantrp FROM orders_100k WHERE idproducto = $idproducto AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();

                return $datos;
			}
		}
		
		function getCodigoRegistroTran_100k($idproducto, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT idrec FROM tran_100k WHERE idproducto = $idproducto AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$idrec = $datos['idrec'];
				return $idrec;
			}
		}
		
		function getCantidadRegistroTran100k($idproducto, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT cantidad FROM tran_100k WHERE idproducto = $idproducto AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$cantidad = abs($datos['cantidad']);
				return $cantidad;
			}
		}
		
		function getCantidadRegistro100k($idproducto, $trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT cantrp FROM orders_100k WHERE idproducto = $idproducto AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$cantidad = $datos['cantrp'];
				return $cantidad;
			}
		}
		
		function setNuevaCantidadScanTraslado($trannum, $cantidad, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$consulta = "SELECT notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJ000'";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$codes = $datos['notas'];
				
				$info = explode(";", $codes);
				$count = count($info);
				
				for($i=0; $i<$count; $i++){
					$infoProd = explode(",", $info[$i]);
					if($infoProd[0] == $idproducto){
						$total = $cantidad;
						$info[$i] = $infoProd[0].",".$total;
					}
				}
				
				$codes = implode(";", $info);
				
				$this->db_b->set('notas', $codes);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('um', 'SCJ000');
                $query = $this->db_b->update('tran_100kt');
				
				return $query;
			}
		}
		
		function setNuevaCantidadScan($trannum, $cantidad, $idproducto, $numero){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$consulta = "SELECT notas FROM tran_100kt WHERE trannum = $trannum AND um = 'SCJA00".$numero."' AND uniconv = 0";
                $query = $this->db_b->query($consulta);
				$datos = $query->row_array();
				$codes = $datos['notas'];
				
				$info = explode(";", $codes);
				$count = count($info);
				
				for($i=0; $i<$count; $i++){
					$infoProd = explode(",", $info[$i]);
					if($infoProd[0] == $idproducto){
						$total = $cantidad;
						$info[$i] = $infoProd[0].",".$total;
					}
				}
				
				$codes = implode(";", $info);
				
				$this->db_b->set('notas', $codes);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('um', 'SCJA00'.$numero);
                $this->db_b->where('uniconv', '0');
                $query = $this->db_b->update('tran_100kt');
				
				return $query;
			}
		}
		
		function getScanJobsUtilizados($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT um, uniconv FROM tran_100kt WHERE um LIKE '%SCJA00%' AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
				
				if($query->num_rows()>0){
                    $result = $query->result();
                }else{
                    $result = "";
                }
                return $result;
			}
		}
		
		function eliminarRegistrosOption($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "DELETE FROM orders_100k WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
				return $query;
			}
		}
		
		function anularRecuentoFisico($trannum, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
				$this->db_b->update('orders_100');
                
                $this->db_b->set('invcontrol', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idcentro', $idcentro);
				$this->db_b->update('invsites');
                
				$SQLDelete = "DELETE FROM orders_100k WHERE trannum = $trannum";
                $QueryDelete = $this->db_b->query($SQLDelete);
				
                return $QueryDelete;
			}
		}
		
        function get_repedido_list($fechaini,$fechafin,$sucursal){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCentros = "("; $whereSaldos = "(";
                $idcentros = explode(",", $sucursal);
                for($i=0; $i<count($idcentros); $i++){
                    $whereCentros .= "tran_100.idcentro = ".$idcentros[$i]." OR ";
                    $whereSaldos  .= "tran_100k2.idcentro = ".$idcentros[$i]." OR ";
                }
                $whereCentros = substr($whereCentros, 0, -4) . ")"; $whereSaldos = substr($whereSaldos, 0, -4) . ")";
                //SUM(tran_100k.precioneto*tran_100k.cantidad) as precioprom,
                $consulta = "SELECT tran_100k.descuento as descuento, invproducts.descrip, invsites.descrip AS nameSucursal, invproducts.modelo, invproducts.marca, invproducts.xpos, invproducts.barcode, invcatalog.descrip as linea, invproducts.imagen, tran_100k.idproducto, tran_100k.tax1 as tax, invproducts.upp,IFNULL(ctauxi.idauxi, 'NO ASIGNADO') as idproveedor, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, IFNULL(ctauxi.limite, 'NO ASIGNADO') as comisionproveedor, IFNULL(ctauxi.grupo, 'NO ASIGNADO') as grupoProveedor, 
                    SUM(tran_100k.cantidad * tran_100k.uniconv) AS Total, SUM(if(inv_def.inopera=-1,1,0)) AS hits, SUM(tran_100k.precioneto*tran_100k.cantidad) as precioprom, SUM(IF(tran_100k.tax1 = 0, (tran_100k.precioneto * tran_100k.cantidad) , (tran_100k.precioneto * (1 + (tran_100k.tax1 / 100))) * tran_100k.cantidad)) as totalvn, invproducts.precioventa as precioreg,
                    SUM((IF(tran_100k.tax1 = 0, 0, (tran_100k.precioneto * (tran_100k.tax1/100)))) * tran_100k.cantidad) AS totalIVA, tran_100k.costounitario, x.descrip AS departamento, 
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND $whereSaldos) as inv_actual, 
                    (SELECT SUM(tran_100k3.cantidad * tran_100k3.uniconv) FROM tran_100k AS tran_100k3 
                    INNER JOIN tran_100 AS tran_1002 ON tran_100k3.trannum = tran_1002.trannum
                    INNER JOIN inv_def ON tran_100k3.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' AND inv_def.inopera = 1 
                    WHERE tran_100k3.idproducto = tran_100k.idproducto AND tran_1002.fecha BETWEEN '$fechaini' AND '$fechafin') AS ingresosPeriodo
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo  
                INNER JOIN invcatalog x ON invcatalog.idnivel1 = x.idcatalogo  
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND inv_def.agrupa = 'VN' AND tran_100.estatus = 1 AND invproducts.tipo = 1 AND " . $whereCentros . "
                GROUP BY tran_100k.idproducto " .(($this->session->userdata('idaccount') == 2902805) ? ", descuento" : ""). "
                ORDER BY hits DESC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
                
			}
        }

        function get_repedido_list_limit($fechaini,$fechafin,$sucursal, $limit, $ofset){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCentros = "("; $whereSaldos = "(";
                $idcentros = explode(",", $sucursal);
                for($i=0; $i<count($idcentros); $i++){
                    $whereCentros .= "tran_100.idcentro = ".$idcentros[$i]." OR ";
                    $whereSaldos  .= "tran_100k2.idcentro = ".$idcentros[$i]." OR ";
                }
                $whereCentros = substr($whereCentros, 0, -4) . ")"; $whereSaldos = substr($whereSaldos, 0, -4) . ")";
                //SUM(tran_100k.precioneto*tran_100k.cantidad) as precioprom,
                $consulta = "SELECT tran_100k.descuento as descuento, invproducts.descrip, invsites.descrip AS nameSucursal, invproducts.modelo, invproducts.marca, invproducts.xpos, invproducts.barcode, invcatalog.descrip as linea, invproducts.imagen, tran_100k.idproducto, tran_100k.tax1 as tax, invproducts.upp,IFNULL(ctauxi.idauxi, 'NO ASIGNADO') as idproveedor, IFNULL(ctauxi.descrip, 'NO ASIGNADO') AS nameproveedor, IFNULL(ctauxi.limite, 'NO ASIGNADO') as comisionproveedor, 
                    SUM(tran_100k.cantidad) AS Total, SUM(if(inv_def.inopera=-1,1,0)) AS hits, SUM(tran_100k.precioneto*tran_100k.cantidad) as precioprom, SUM(IF(tran_100k.tax1 = 0, (tran_100k.precioneto * tran_100k.cantidad) , (tran_100k.precioneto * (1 + (tran_100k.tax1 / 100))) * tran_100k.cantidad)) as totalvn, tran_100k.preciotran as precioreg,
                    SUM((IF(tran_100k.tax1 = 0, 0, (tran_100k.precioneto * (tran_100k.tax1/100)))) * tran_100k.cantidad) AS totalIVA, 
                    (SELECT SUM(tran_100k2.cantidad * tran_100k2.uniconv) FROM tran_100k AS tran_100k2 WHERE tran_100k2.idproducto = tran_100k.idproducto AND $whereSaldos) as inv_actual, 
                    (SELECT SUM(tran_100k3.cantidad * tran_100k3.uniconv) FROM tran_100k AS tran_100k3 
                    INNER JOIN tran_100 AS tran_1002 ON tran_100k3.trannum = tran_1002.trannum
                    INNER JOIN inv_def ON tran_100k3.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' AND inv_def.inopera = 1 
                    WHERE tran_100k3.idproducto = tran_100k.idproducto AND tran_1002.fecha BETWEEN '$fechaini' AND '$fechafin') AS ingresosPeriodo
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                LEFT JOIN ctauxi ON ctauxi.idauxi = invproducts.idprovee 
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo  
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND inv_def.agrupa = 'VN' AND tran_100.estatus = 1 AND invproducts.tipo = 1 AND " . $whereCentros . "
                GROUP BY tran_100k.idproducto " .(($this->session->userdata('idaccount') == 2902805) ? ", descuento" : ""). "
                ORDER BY hits DESC
                LIMIT $limit, $ofset";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
                
			}
        }
        
        function getNameProveedorCompra($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLProvee = "SELECT ctauxi.descrip 
                FROM tran_100 
                INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' AND inv_def.inopera = 1
                INNER JOIN ctauxi  ON tran_100.idcps   = ctauxi.idauxi
                WHERE tran_100k.idproducto = $idproducto ORDER BY tran_100.fecha DESC LIMIT 1";
                $Query = $this->db_b->query($SQLProvee);

                if($Query->num_rows() > 0){
                    $info = $Query->row_array();
                    $nameProveedor = trim($info['descrip']);
                }else{
                    $nameProveedor = '';
                }
                
                return $nameProveedor;
			}
        }
        
        function get_stock_suc($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT
                    invsites.idcentro, invsites.descrip,
                    SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad
                FROM
                    tran_100k
                INNER JOIN invsites ON invsites.idcentro = tran_100k.idcentro
                WHERE
                    idproducto = $idproducto
                GROUP BY tran_100k.idcentro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
			}
        }
        
        function get_repedido_sucursales($fechaini,$fechafin,$idsucursal, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) AS Total
                    FROM
                        tran_100
                            INNER JOIN
                        tran_100k ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            AND inv_def.agrupa = 'VN'
                    WHERE
                        tran_100k.idproducto = $idproducto
                            AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                            AND inv_def.agrupa = 'VN'
                            AND tran_100.estatus = 1
                            AND tran_100.idcentro=$idsucursal";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['Total'];
			}
		}
		
		function getInvdefInOut($idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ids = explode(',', $idclases);
				
				$consulta = "SELECT invclase, descrip FROM inv_def WHERE invclase = ".$ids[1]." OR invclase = ".$ids[2];
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function getInformacionInOut($idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ids = explode(',', $idclases);
				
				$consulta = "SELECT tran_100.*, invsites.descrip AS idcentrod_des FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase INNER JOIN invsites ON tran_100.idcentrod = invsites.idcentro WHERE tran_100.idclase = ".$ids[1]." OR tran_100.idclase = ".$ids[2];
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function getRegistroInOut($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT tran_100.*, invsites.descrip AS idcentrod, invsites2.descrip AS centrocd, inv_def.descrip AS descripcion, invlocations.descrip AS descriplocation FROM tran_100 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase INNER JOIN invsites ON tran_100.idcentrod = invsites.idcentro INNER JOIN invsites AS invsites2 ON tran_100.idcentro = invsites2.idcentro INNER JOIN invlocations ON tran_100.tranref = invlocations.idbin WHERE tran_100.trannum = $trannum";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function insertRegistroInOut($fecha, $referencia, $idcentro, $idbin, $idclase, $notas){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$this->db_b->set('trannum', 0);
				$this->db_b->set('idcentro', $this->session->userdata('idcentrouser'));
				$this->db_b->set('idcentrod', $idcentro);
				$this->db_b->set('fecha', $fecha);
				$this->db_b->set('referencia', $referencia);
				$this->db_b->set('tranref', $idbin);
				$this->db_b->set('idclase', $idclase);
				$this->db_b->set('notas', trim($notas));
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$this->db_b->insert('tran_100');
				
				$idtrannum = $this->db_b->insert_id();
                return $idtrannum;
			}
		}
		
		function getSucursalByTrannum($trannum, $tipocentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invsites.idcentro, invsites.descrip FROM invsites INNER JOIN orders_100 ON orders_100.idcentro = invsites.idcentro WHERE invsites.tipo = $tipocentro AND orders_100.trannum = $trannum AND orders_100.estatus = 1";
				$query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
				
				return $resultado;
			}
		}
		
		function getValorContrasena($var_name){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT valor_num FROM gvars WHERE nombre = '$var_name'";	
				$query = $this->db_b->query($consulta);
				
				if($query->num_rows() > 0){
					$resultado = $query->row_array();
					$informacion = $resultado['valor_num'];
				}else{
					$informacion = false;
				}
				
				return $informacion;
			}
		}
        
        function getDatosFacturaciones($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja = str_replace("_", " OR t100.idcaja = ", $idcaja);

                $consulta = "SELECT t100.trannum, t100.notas, t100.fecha, t100.numx, t100.numz, t100.fecact, t100.estatus, t100.serie, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.nit, ctaucli.descrip AS namecliente, IFNULL(ctauximulti.descrip, ctaucli.descrip) AS namesucursal, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valcosto, t100.valtax1,invdef.caopera,invdef.exento, t100.referencia, 
                d.serie AS dev_serie, d.numero AS dev_numero, ctcajas.descrip AS namecaja  
                FROM tran_100 AS t100 
                INNER JOIN ctcajas ON t100.idcaja = ctcajas.idcaja 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi 
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi 
                LEFT JOIN ctauximulti ON t100.idcentrod = ctauximulti.idrec 
                LEFT JOIN tran_100 d ON t100.tranref = d.trannum 
                WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND (t100.idcaja = $idcaja) AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecact, t100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getDatosFacturacionesCESC($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100.trannum, t100.notas, t100.fecha,t100.fecact, t100.estatus, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.descrip AS namecliente, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valtax1,invdef.caopera,invdef.exento FROM tran_100 AS t100 INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi WHERE invdef.agrupa = '$agrupa' AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.idcentro = $idcentro AND t100.idcaja = $idcaja AND fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY fecact,fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }
        
        function getDetalleFacturas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT t100k.itemline, t100k.idproducto, inv.descrip, location.descrip AS ubicacion, batch.descrip AS lote, t100k.cantidad, t100k.um, t100k.precioneto, t100k.preciotran, t100k.descuento, t100k.notas, t100k.tax1, t100k.tax3, inv.comision, inv.modelo, t100k.barcode FROM tran_100k AS t100k INNER JOIN invproducts AS inv ON t100k.idproducto = inv.idproducto INNER JOIN invlocations AS location ON t100k.idbin = location.idbin LEFT JOIN inv_batch AS batch ON t100k.idbatch = batch.idbatch WHERE t100k.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
		function getTiposinout($idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ids = explode(',', $idclases);
                $total = count($ids);
                $where = "";
                if($total > 0){
                    for($i=0; $i<$total; $i++){
                        $where .= "invclase = ".$ids[$i]." OR ";
                    }
                    
                    $where =  substr($where, 0, -4);
                    $consulta = "SELECT invclase, descrip FROM inv_def WHERE ".$where;
                }else{
                    $consulta = "SELECT invclase, descrip FROM inv_def";
                }
				
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
        
        function insertSalida($idcentro, $fecha, $idclase, $notas,$idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');

                $trannum = $this->db_b->insert_id();
                return $trannum;
            }  
        }
        
        function getDataTran100_($idclases, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ids = explode(',', $idclases);
                $total = count($ids);
                $where = "(";
                            
                for($i=0; $i<$total; $i++){
                    $where .= "tran_100.idclase = ".$ids[$i]." OR ";
                }
                
                $where = substr($where, 0, -4);
                $where .= ")";
                
                $consulta = "SELECT tran_100.trannum, tran_100.idcentro, tran_100.fecha,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha1, tran_100.fecact, tran_100.estatus, tran_100.referencia, tran_100.lines100k, tran_100.notas,inv_def.descrip as tipo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase=tran_100.idclase WHERE tran_100.idcentro = $idcentro AND ".$where." ORDER BY tran_100.trannum DESC";    
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            } 
        }

        function getListadoOtrasSalidas($idclases, $idcentro, $fechaini, $fechafin, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereSQL = ($estado == 0) ? "AND tran_100.estatus = 0" : "AND tran_100.estatus != 0 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'";

                $ids = explode(',', $idclases);
                $total = count($ids);
                $where = "(";
                            
                for($i=0; $i<$total; $i++){
                    $where .= "tran_100.idclase = ".$ids[$i]." OR ";
                }
                
                $where = substr($where, 0, -4);
                $where .= ")";
                
                $consulta = "SELECT tran_100.trannum, tran_100.idcentro, tran_100.fecha, DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha1, tran_100.fecact, tran_100.estatus, tran_100.referencia, tran_100.lines100k, tran_100.notas,inv_def.descrip as tipo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase=tran_100.idclase 
                WHERE tran_100.idcentro = $idcentro ".$whereSQL." AND ".$where." ORDER BY tran_100.trannum DESC";    
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getDetalleSalida($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum,tran_100.idclase, tran_100.tranref, tran_100.idcentro, tran_100.notas, invsites2.descrip AS centrocd, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, tran_100.lines100k, (SELECT SUM(ABS(cantidad)) FROM tran_100k where trannum= tran_100.trannum) as cantidad, ctauxi.descrip AS encargadod, gusers.descrip AS encargadoinv,inv_def.descrip as tipoSalida, inv_def.inopera FROM tran_100 INNER JOIN invsites AS invsites2 ON invsites2.idcentro = tran_100.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps INNER JOIN gusers ON gusers.iduser = tran_100.whodidit INNER JOIN  inv_def ON inv_def.invclase=tran_100.idclase WHERE tran_100.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetalleSalida2($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100.trannum,tran_100.idclase, tran_100.tranref, tran_100.idcentro, tran_100.notas, invsites2.descrip AS centrocd, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, tran_100.lines100k, (SELECT SUM(ABS(cantidad)) FROM tran_100k where trannum= tran_100.trannum) as cantidad, ctauxi.descrip AS encargadod, gusers.descrip AS encargadoinv,inv_def.descrip as tipoSalida FROM tran_100 INNER JOIN invsites AS invsites2 ON invsites2.idcentro = tran_100.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps INNER JOIN gusers ON gusers.iduser = tran_100.whodidit INNER JOIN  inv_def ON inv_def.invclase=tran_100.idclase WHERE tran_100.trannum = $idtrannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }
        
        function getComInvDate($tipoPro,$idcentro,$desde,$hasta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit','480M');
				ini_set('max_allowed_packet', '480M'); 
     
                $consulta = "WITH stats AS (
                    SELECT 
                        invp.idproducto,
                        invp.agrupa,
                        invp.dia,
                        invp.cantidad,
                        invp.costoco,
                        invp.costoajvn
                    FROM inv_prostats invp
                    INNER JOIN invproducts invpro ON invp.idproducto = invpro.idproducto
                    WHERE invp.idcentro = $idcentro AND invpro.tipo = $tipoPro
                ),
                saldos AS (
                    SELECT 
                        idproducto,
                        SUM(CASE WHEN dia < '$desde' THEN cantidad ELSE 0 END) AS saldoinicial,
                        SUM(CASE WHEN dia < '$desde' AND agrupa='CO' THEN costoco ELSE 0 END) AS ini_costoco,
                        SUM(CASE WHEN dia < '$desde' AND agrupa IN ('VN','IN') THEN costoajvn ELSE 0 END) AS ini_costoajvn,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='CO' THEN cantidad ELSE 0 END) AS compras,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='CO' THEN costoco ELSE 0 END) AS costocompras,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='IN' THEN cantidad ELSE 0 END) AS ajustes,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='IN' THEN costoajvn ELSE 0 END) AS costoajustes,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='VN' THEN cantidad ELSE 0 END) AS ventas,
                        SUM(CASE WHEN dia BETWEEN '$desde' AND '$hasta' AND agrupa='VN' THEN costoajvn ELSE 0 END) AS costoventas,
                        SUM(CASE WHEN dia <= '$hasta' THEN costoco ELSE 0 END) AS costototal
                    FROM stats
                    GROUP BY idproducto
                )
                SELECT 
                    ps.idproducto,
                    ps.agrupa,
                    ps.cantidad,
                    ps.venta,
                    p.descrip AS producto,
                    p.um,
                    p.marca,
                    p.modelo,
                    c1.idcatalogo AS idlinea,
                    c1.descrip AS linea,
                    c2.idcatalogo AS iddepartamento,
                    c2.descrip AS departamento,
                    p.costounitario AS costo_ficha,
                    s.*
                FROM inv_prostats ps
                INNER JOIN invproducts p ON p.idproducto = ps.idproducto
                INNER JOIN invcatalog c1 ON c1.idcatalogo = p.idcatalogo
                INNER JOIN invcatalog c2 ON c2.idcatalogo = c1.idnivel1
                LEFT JOIN saldos s ON s.idproducto = ps.idproducto
                WHERE ps.dia <= '$hasta' AND ps.idcentro = $idcentro AND p.tipo = $tipoPro
                GROUP BY p.idproducto
                ORDER BY p.idproducto;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCategoriasInv($tipoPro,$idcentro,$idano,$idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                        invcatalog2.idcatalogo AS iddepartamento,
                        invcatalog2.descrip AS departamento
                    FROM
                        inv_prostats
                            INNER JOIN
                        invproducts ON invproducts.idproducto = inv_prostats.idproducto
                            INNER JOIN
                        invcatalog AS invcatalog1 ON invcatalog1.idcatalogo = invproducts.idcatalogo
                            INNER JOIN
                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog1.idnivel1
                    WHERE
                        inv_prostats.idano = $idano
                            AND inv_prostats.idmes = $idmes
                            AND inv_prostats.idcentro = $idcentro
                            AND invproducts.tipo = $tipoPro
                    GROUP BY invcatalog2.idcatalogo
                    ORDER BY invcatalog2.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getLineasInv($tipoPro,$idcentro,$idano,$idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                        invcatalog1.idcatalogo AS idlinea,
                        invcatalog2.idcatalogo AS iddepartamento,
                        invcatalog1.descrip AS linea,
                        invcatalog2.descrip AS departamento
                    FROM
                        inv_prostats
                            INNER JOIN
                        invproducts ON invproducts.idproducto = inv_prostats.idproducto
                            INNER JOIN
                        invcatalog AS invcatalog1 ON invcatalog1.idcatalogo = invproducts.idcatalogo
                            INNER JOIN
                        invcatalog AS invcatalog2 ON invcatalog2.idcatalogo = invcatalog1.idnivel1
                    WHERE
                        inv_prostats.idano = $idano
                            AND inv_prostats.idmes = $idmes
                            AND inv_prostats.idcentro = $idcentro
                            AND invproducts.tipo = $tipoPro
                    GROUP BY invcatalog1.idcatalogo , invcatalog2.idcatalogo
                    ORDER BY invcatalog2.descrip ASC , invcatalog1.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
        function getBatchProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT costounitario FROM inv_batch where idproducto=$idproducto";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $costoUnitario = $resultado['costounitario'];
                }else{
                    $costoUnitario = 0;
                }
                return $costoUnitario;
            }
        }
		
        function getDetalleKardexByProducto($idproducto, $fechaini, $fechafin, $idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$SQLKardex = "SELECT tran_100.fecha, tran_100.trannum, inv_def.invclase, inv_def.inopera, inv_def.agrupa, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as numerodoc,  tran_100k.cantidad, tran_100k.uniconv, tran_100k.costounitario, ctauxi.descrip AS proveedorcliente FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto WHERE tran_100k.idproducto = $idproducto AND tran_100.idcentro = $idcentro AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY tran_100.fecha, tran_100.trannum ASC";
                $QueryKardex = $this->db_b->query($SQLKardex);
				$ResultKardex = $QueryKardex->result();
				
				return $ResultKardex;
			}
		}
		
        function getInventarioInicialProductoKardex($idproducto, $idcentro, $idano, $idmes){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$mes_ant = 0; $anio_ant = 0;
                if($idmes==1){
                    $mes_ant = 12; $anio_ant = $idano-1;
                }else{
                    $mes_ant = $idmes - 1;
                    $anio_ant = $idano;
                }
				
				$SQLKardex = "SELECT IFNULL(SUM(cantidad), 0) AS cantidad, IFNULL(SUM(costo), 0) AS costo FROM inv_prostats WHERE idcentro = $idcentro AND idproducto = $idproducto AND idano <= $anio_ant AND idmes <= $mes_ant";
                $QueryKardex = $this->db_b->query($SQLKardex);
				$ResultKardex = $QueryKardex->result();
				
				return $ResultKardex;
			}
		}
        
        function getVendedorProducto($trannum, $idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $sql = "SELECT tran_100k.idworker, ctauxi.descrip as vendedor FROM tran_100k INNER JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker WHERE tran_100k.idrec =$idrec AND tran_100k.trannum = $trannum";
                $query = $this->db_b->query($sql);
                if($query->num_rows() > 0){
                    $result = $query->row_array();
                    return $result['vendedor'];
                }else{
                    return "";
                }
			}
        }
        
        function getListadoFolderDePrecios($agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ConsultaFolders = "SELECT * FROM orders_100 WHERE agrupa = 'VP'";
                $QueryFolders = $this->db_b->query($ConsultaFolders);
                
                if($QueryFolders->num_rows() > 0){
                    $ResultFolders = $QueryFolders->result();
                }else{
                    $ResultFolders = false;
                }
                
				return $ResultFolders;
			}
        }
        
        function insertNuevoFolderPrecios($fecha, $descrip, $tipo, $notas, $idcentro, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', $agrupa);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('cajclase', $tipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('referencia', $tipo);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('orders_100');
                
                $idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }
        
        function getInformacionOrdenFolder($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ConsultaFolders = "SELECT * FROM orders_100 WHERE trannum = $trannum";
                $QueryFolders = $this->db_b->query($ConsultaFolders);
                $ResultFolders = $QueryFolders->result();
                
                return $ResultFolders;
            }
        }
        
        function getGroupsProductosFolders(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, IFNULL(invcatalog.imagen, '') AS imagen, invcatalog.descrip FROM invcatalog INNER JOIN invproducts ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado = 1  AND invproducts.tipo = 1 ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }
        
        function getSumProductosFolders($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$consulta = "SELECT invproducts.idcatalogo, SUM(IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 0, 1)) AS total FROM invproducts WHERE invproducts.estado = 1  AND invproducts.tipo = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
		}
        
        function getInventarioByCatalogFolders($idtrannum, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, invproducts.tipotax, invproducts.costounitario, invproducts.descuento, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, (SELECT IF(EXISTS(SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 1, 0)) AS existe FROM invproducts WHERE invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1 AND invproducts.tipo = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getCantidadesCatalogoFolders($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT invproducts.idcatalogo, (SELECT SUM(IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $idtrannum), 0, 1))) AS cantidad FROM invproducts WHERE invproducts.estado = 1 AND invproducts.tipo = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoPorcentajes($nombre_variable){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLDescuentos = "SELECT valor_txt FROM gvars WHERE nombre = '$nombre_variable'";
                $QueryDescuento = $this->db_b->query($SQLDescuentos);
                $infoResultado = $QueryDescuento->row_array();
                
                return $infoResultado['valor_txt'];
            }
        }
        
        function insertarProductoToFolderPrecios($trannum, $idproducto, $precio, $descuento, $um, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $query = $this->db_b->query($consulta);
				
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('descrip', $descuento);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100k');
                
                return $query;
            }
        }
        
        function updateProductoToFolderPrecios($idrec, $precio, $descuento, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('descrip', $descuento);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');
                
                return $query;
            }
        }
        
        function getDatosFolderDePrecios($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLDatos = "SELECT invproducts.xpos, invproducts.costounitario, invproducts.precioventa, invproducts.tipotax, orders_100k.idrec, orders_100k.uniconv, orders_100k.um, orders_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.descuento AS descuentoactual, invproducts.imagen, invproducts.modelo, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, orders_100k.descrip AS descuento, orders_100k.precioneto, orders_100k.notas FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $trannum ORDER BY orders_100k.itemline DESC";
				$QueryDatos = $this->db_b->query($SQLDatos);
                $resultado = $QueryDatos->result();
                
                return $resultado;
            }
        }
        
        function eliminarProductoToFolderPrecios($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLDatos = "DELETE FROM orders_100k WHERE idrec = $idrec";
				$QueryDatos = $this->db_b->query($SQLDatos);
                
                return $QueryDatos;
            }
        }
        
        function getSearchProductoFolderPrecios($prosearch, $dato, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
				
				if($prosearch == 3){
					$consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario, invproducts.descuento, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo LEFT JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1 WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND (invproducts.$search = '$dato' OR invpromulti.descrip = '$dato')";
                    $query = $this->db_b->query($consulta);
                    
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario, invproducts.descuento, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND invproducts.descrip LIKE '%$dato%'";
                    $query = $this->db_b->query($consulta);
                    
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
				}else{
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.costounitario, invproducts.descuento, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto, invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo,  invproducts.precioventa, invproducts.barcode, invproducts.notas, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND invproducts.$search = '$dato'";
                    $query = $this->db_b->query($consulta);
                    
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }
            }
        }
        
        function getInformacionProductoOrders100k($trannum, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLDatos = "SELECT invproducts.xpos, invproducts.costounitario, invproducts.precioventa, invproducts.tipotax, orders_100k.idrec, orders_100k.uniconv, orders_100k.um, orders_100k.itemline, invproducts.idcatalogo, invproducts.descrip, invproducts.descuento AS descuentoactual, invproducts.imagen, invproducts.modelo, invproducts.marca, invproducts.idproducto, invproducts.barcode, invproducts.notas, orders_100k.descrip AS descuento, orders_100k.precioneto, orders_100k.notas FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $trannum AND orders_100k.idproducto = $idproducto";
				$QueryDatos = $this->db_b->query($SQLDatos);
                $resultado = $QueryDatos->result();
                
                return $resultado;
            }
        }
        
        function getProductosPorMarca($marca, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.um, invproducts.precioventa, invproducts.tipotax, invproducts.descrip, invproducts.costounitario, invproducts.idcatalogo, invcatalog.descrip as linea, invproducts.modelo, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND invproducts.marca='$marca' GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoProductosToFolder($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.um, IFNULL(ctauxi.descrip, '') AS nameproveedor, invproducts.marca, invproducts.precioventa, invproducts.tipotax, invproducts.descrip, invproducts.costounitario, invproducts.idcatalogo, invcatalog.descrip as linea, invproducts.modelo, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo LEFT JOIN ctauxi ON invproducts.idprovee = ctauxi.idauxi WHERE invproducts.estado = 1 AND invproducts.tipo = 1 ORDER BY invproducts.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosPorDepartamento($idcatalogo, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idproducto, invproducts.um, invproducts.marca, invproducts.precioventa, invproducts.tipotax, invproducts.descrip, invproducts.costounitario, invproducts.idcatalogo, invcatalog.descrip as linea, invproducts.modelo, (SELECT IF(EXISTS( SELECT orders_100k.trannum FROM orders_100k WHERE orders_100k.idproducto = invproducts.idproducto AND orders_100k.trannum = $trannum), 1, 0)) AS existe FROM invproducts LEFT JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado = 1 AND invproducts.tipo = 1 AND invcatalog.idnivel1 = $idcatalogo GROUP BY invproducts.idproducto";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertarProductoToFolderPreciosByGrid($trannum, $idproductos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $idProducts = explode(",", $idproductos);
                $totalItems = count($idProducts);
                
                for($i=0; $i<$totalItems; $i++){
                    $SQLItemLine = "SELECT itemline FROM orders_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                    $QueryItemLine = $this->db_b->query($SQLItemLine);

                    if($QueryItemLine->num_rows() > 0){
                        $resultado = $QueryItemLine->row_array();
                        $itemLine = $resultado['itemline'] + 1;
                    }else{
                        $itemLine = 1;
                    }
                    
                    $SQLProducto = "SELECT idproducto, um FROM invproducts WHERE idproducto = " . $idProducts[$i];
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $infoProducto = $QueryProducto->row_array();
                    
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idproducto', $infoProducto['idproducto']);
                    $this->db_b->set('descrip', "");
                    $this->db_b->set('um', $infoProducto['um']);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('precioneto', 0);
                    $this->db_b->set('notas', "");
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    
                    $query = $this->db_b->insert('orders_100k');
                }
                
                return $query;
            }
        }
                
        function getComprasDepto($idsucursal, $tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $where = "";
                if($idsucursal!="999999"){
                    $where = " AND tran_100.idcentro = $idsucursal ";
                }
                
                $consulta = "SELECT 
                    inv_def.descrip tipomov,
                    invcatalog2.idcatalogo as iddepartamento,
                    invcatalog2.descrip AS departamento,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,2)) as costoTotal
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo=invcatalog.idcatalogo
                    INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1=invcatalog2.idcatalogo
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ".$where." AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro
                        GROUP BY invcatalog2.idcatalogo ORDER BY invcatalog2.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getComprasLineas($idsucursal, $iddepartamento, $tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $where = "";
                if($idsucursal!="999999"){
                    $where = " AND tran_100.idcentro = $idsucursal ";
                }
                
                $consulta = "SELECT 
                    invcatalog.idcatalogo as idlinea,
                    invcatalog.descrip AS linea,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,2)) as costoTotal
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo=invcatalog.idcatalogo
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ".$where." AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro AND invcatalog.idnivel1=$iddepartamento 
                        GROUP BY invcatalog.idcatalogo ORDER BY invcatalog.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductsLineaCO($idsucursal, $tipopro, $fechaini, $fechafin,$idlinea){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $where = "";
                if($idsucursal!="999999"){
                    $where = " AND tran_100.idcentro = $idsucursal ";
                }
                
                $consulta = "SELECT 
                    DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                    invproducts.descrip, 
                    invproducts.idproducto, 
                    invproducts.modelo, 
                    invproducts.um, 
                    invsites.descrip as bodega_compra,
                    tran_100k.preciotran AS costounitario,
                    tran_100k.cantidad AS cantidad, 
                    SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,2)) AS subtotal
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo=invcatalog.idcatalogo
                    INNER JOIN invsites ON invsites.idcentro=tran_100.idcentro
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ".$where." AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro AND invcatalog.idcatalogo=$idlinea
                        GROUP BY tran_100k.idrec ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getComprasProveedor($tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                    inv_def.descrip transaccion,
                    tran_100.fecha,
                    tran_100.trannum,
                    tran_100.serie,
                    tran_100.numero,
                    tran_100.idcps as idproveedor,
                    ctauxi.descrip as proveedor,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,6)) as costoTotal,
                    (SELECT SUM(ROUND(t100k.preciotran,6)*t100k.cantidad*t100k.uniconv) FROM tran_100 as  t100 INNER JOIN tran_100k as t100k ON t100.trannum=t100k.trannum INNER JOIN inv_def as invd ON invd.invclase= t100.idclase INNER JOIN  invproducts AS invp ON invp.idproducto=t100k.idproducto WHERE t100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND t100.estatus = 1 AND invd.agrupa='CO'  AND invp.tipo=$tipopro AND t100.idcps=tran_100.idcps) AS costoProveedor
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN ctauxi ON tran_100.idcps=ctauxi.idauxi
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro
                        GROUP BY tran_100.trannum ORDER BY ctauxi.descrip,tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getComprasProveedorUpdate($tipopro, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$where = "";
                if($idcentro!="999999"){
                    $where = " AND tran_100.idcentro = $idcentro ";
                }
				
                $consulta = "SELECT 
                    inv_def.descrip transaccion,
                    tran_100.fecha,
                    tran_100.trannum,
                    tran_100.serie,
                    tran_100.numero,
                    tran_100.idcps as idproveedor,
                    ctauxi.descrip as proveedor,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,6)) as costoTotal,
                    (SELECT SUM(ROUND(t100k.preciotran,6) * ROUND(t100k.cantidad,6) *t100k.uniconv) FROM tran_100 as  t100 INNER JOIN tran_100k as t100k ON t100.trannum=t100k.trannum INNER JOIN inv_def as invd ON invd.invclase= t100.idclase INNER JOIN  invproducts AS invp ON invp.idproducto=t100k.idproducto WHERE t100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND t100.estatus = 1 AND invd.agrupa='CO'  AND invp.tipo=$tipopro AND t100.idcps=tran_100.idcps) AS costoProveedor
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN ctauxi ON tran_100.idcps=ctauxi.idauxi
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  ".$where."   AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro
                        GROUP BY tran_100.trannum ORDER BY ctauxi.descrip,tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosCOProvee($proveedor, $tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT 
                    tran_100.trannum,
                    tran_100.numero,
                    tran_100.serie,
                    DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                    invproducts.descrip, 
                    invproducts.idproducto, 
                    invproducts.modelo, 
                    invproducts.um, 
                    tran_100k.preciotran AS costounitario,
                    tran_100k.cantidad AS cantidad, 
                    SUM(ROUND(tran_100k.preciotran,2)  * ROUND(tran_100k.cantidad,2)) AS subtotal
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN ctauxi ON tran_100.idcps=ctauxi.idauxi
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro AND ctauxi.descrip LIKE '$proveedor'
                        GROUP BY tran_100k.idrec ORDER BY tran_100.fecha ASC";
                    
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProductosCOTran($trannum, $tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "
                SELECT 
                    tran_100.trannum, tran_100.numero, tran_100.serie, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha, invproducts.descrip, 
                    invproducts.idproducto, invproducts.modelo, invproducts.um, tran_100k.preciotran AS costounitario, 
                    tran_100k.cantidad AS cantidad, SUM(ROUND(tran_100k.preciotran,6)  * ROUND(tran_100k.cantidad,6)) AS subtotal
                FROM tran_100
                INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                INNER JOIN ctauxi ON tran_100.idcps=ctauxi.idauxi
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro AND tran_100.trannum=$trannum
                GROUP BY tran_100k.idrec ORDER BY tran_100.fecha ASC";
                    
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getComprasProveedorDistinct($tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                    tran_100.idcps as idproveedor,
                    ctauxi.descrip as proveedor,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    SUM(ROUND(tran_100k.preciotran,2)  * ROUND(tran_100k.cantidad,2)) as costoTotal
                FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    INNER JOIN ctauxi ON tran_100.idcps=ctauxi.idauxi
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro
                        GROUP BY tran_100.idcps ORDER BY ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getComprasProvee($idproveedor, $tipopro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                    inv_def.descrip transaccion,
                    DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                    tran_100.trannum,
                    tran_100.serie,
                    tran_100.numero,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    SUM(ROUND(tran_100k.preciotran,2)  * ROUND(tran_100k.cantidad,2)) as costoTotal
                    FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO'  AND invproducts.tipo=$tipopro AND tran_100.idcps=$idproveedor
                        GROUP BY tran_100.trannum ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
                
		function updateCantidadRecibidaProduct($trannum, $idrec, $cantidad){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('barcode', $cantidad);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100k');
                return $query;
            }
		}
        
        function getCantPendiente($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT COUNT(idrec) as cantidad FROM tran_100k where trannum=$trannum AND (barcode IS NULL OR barcode='')";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cantidad'];
            }
        }
        
        function getNotasRecepcion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tran_100k.idproducto, invproducts.descrip, tran_100k.cantidad, tran_100k.barcode  FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto WHERE tran_100k.trannum = $trannum AND tran_100k.barcode!=''";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return "";
                }
            }
        }
        
        function getProductosEnviados($idcentro, $idcentrod, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->session->userdata('idclass');
                $consulta = "SELECT tran_100.idcentrod, tran_100k.idproducto, invproducts.descrip, invproducts.um, ABS(SUM(tran_100k.cantidad * tran_100k.uniconv)) as unidades,  ABS(SUM(tran_100k.cantidad * tran_100k.uniconv * tran_100k.costounitario)) as costototal, COUNT(tran_100.trannum) AS num_envios FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto WHERE tran_100.idcentro = $idcentro AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND tran_100.idclase = $idclase AND tran_100.idcentrod = $idcentrod GROUP BY invproducts.idproducto, tran_100.idcentrod ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return "";
                }
            }
        }
        
        function getProductosEnviados2($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->session->userdata('idclass');
                $consulta = "SELECT tran_100.idcentrod, tran_100k.idproducto, invproducts.descrip, invproducts.um, invproducts.modelo, ABS(SUM(tran_100k.cantidad * tran_100k.uniconv)) as unidades,   tran_100k.costounitario, ABS(SUM(tran_100k.cantidad * tran_100k.uniconv * tran_100k.costounitario)) as costototal, COUNT(tran_100.trannum) AS num_envios FROM tran_100 INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto WHERE tran_100.idcentro = $idcentro AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND tran_100.idclase = $idclase GROUP BY invproducts.idproducto, tran_100.idcentrod ORDER BY tran_100.idcentrod, invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return "";
                }
            }
        }
        
        function getCentrosEnviados($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->session->userdata('idclass');
                $consulta = "SELECT tran_100.idcentrod, invsites.descrip FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod WHERE tran_100.idcentro = $idcentro  AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND tran_100.idclase = $idclase AND tran_100.estatus!=9 GROUP BY tran_100.idcentrod ORDER BY invsites.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return "";
                }
            }
        }
                
        function getInvSinAjuste($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.cantidad, orders_100k.cantrp, orders_100k.uniconv, orders_100k.precioneto as costounitario,invproducts.descrip, invproducts.idproducto, invproducts.modelo, (orders_100k.cantrp-orders_100k.cantidad) as tipoAjuste, (orders_100k.precioneto * (orders_100k.cantrp-orders_100k.cantidad)) as subtotal FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND (orders_100k.cantrp-orders_100k.cantidad) =0 AND orders_100k.notas!=999999 ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
                
        function getInvAjusteAFavor($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.cantidad, orders_100k.cantrp, orders_100k.uniconv, orders_100k.precioneto as costounitario,invproducts.descrip, invproducts.idproducto, invproducts.modelo, (orders_100k.cantrp-orders_100k.cantidad) as tipoAjuste, (orders_100k.precioneto * (orders_100k.cantrp-orders_100k.cantidad)) as subtotal FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND (orders_100k.cantrp-orders_100k.cantidad)>0 AND orders_100k.notas!=999999 ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
                
        function getInvAjusteContra($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.cantidad, orders_100k.cantrp, orders_100k.uniconv, orders_100k.precioneto as costounitario,invproducts.descrip, invproducts.idproducto, invproducts.modelo, (orders_100k.cantrp-orders_100k.cantidad) as tipoAjuste, (orders_100k.precioneto * (orders_100k.cantrp-orders_100k.cantidad)) as subtotal FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND (orders_100k.cantrp-orders_100k.cantidad)<0 AND orders_100k.notas!=999999 ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
                
        function getNoInvSinAjuste($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.cantidad, orders_100k.cantrp, orders_100k.uniconv, orders_100k.precioneto as costounitario,invproducts.descrip, invproducts.idproducto, invproducts.modelo, (orders_100k.cantrp-orders_100k.cantidad) as tipoAjuste, (orders_100k.precioneto * (orders_100k.cantrp-orders_100k.cantidad)) as subtotal FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND (orders_100k.cantrp-orders_100k.cantidad)=0 AND orders_100k.notas=999999 ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
                
        function getNoInvAjusteContra($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT orders_100k.cantidad, orders_100k.cantrp, orders_100k.uniconv, orders_100k.precioneto as costounitario,invproducts.descrip, invproducts.idproducto, invproducts.modelo, (orders_100k.cantrp-orders_100k.cantidad) as tipoAjuste, (orders_100k.precioneto * (orders_100k.cantrp-orders_100k.cantidad)) as subtotal FROM orders_100k INNER JOIN invproducts ON invproducts.idproducto = orders_100k.idproducto WHERE orders_100k.trannum = $idtrannum AND (orders_100k.cantrp-orders_100k.cantidad)<0 AND orders_100k.notas=999999 ORDER BY invproducts.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
                
        function getMovProductInicial($idproducto,$idcentro, $desde, $hasta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT (SELECT IFNULL(SUM(cantidad * uniconv),0) FROM tran_100k where trannum=0 AND tran_100k.idproducto=$idproducto AND tran_100.idcentro=$idcentro AND tran_100.fecha < '$desde') AS suma_salidas, tran_100.fecha,  tran_100.fecact,  tran_100.notas AS notas_doc,tran_100.referencia AS referencia_doc, invproducts.um,invproducts.marca, tran_100.trannum, tran_100.idcentro, tran_100.idcentrod, invsites.descrip as o_d, inv_def.invclase, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as num,tran_100k.itemline,  sum(tran_100k.cantidad*tran_100k.uniconv) as subtotal, tran_100k.idrec, tran_100k.preciotran, tran_100k.precioneto, tran_100k.notas, ctauxi.descrip as cliente_proveedor, inv_def.agrupa, gusers.descrip as usuario, tran_100.ingresa, tran_100.modifica FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum  INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto LEFT JOIN invsites ON invsites.idcentro= tran_100.idcentrod LEFT JOIN ctauxi as ctauxi ON ctauxi.idauxi= tran_100.idcps INNER JOIN gusers ON gusers.iduser=tran_100.whodidit where tran_100k.idproducto=$idproducto AND tran_100.idcentro=$idcentro AND tran_100.fecha < '$desde' GROUP BY tran_100k.idproducto ORDER BY tran_100.fecact,tran_100.trannum desc ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
                
        function getMovProductPeriodo($idproducto,$idcentro, $desde, $hasta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta ="SELECT (SELECT IFNULL(SUM(cantidad * uniconv),0) FROM tran_100k where trannum=0 AND tran_100k.idproducto=$idproducto AND tran_100.idcentro=$idcentro AND tran_100.fecha BETWEEN '$desde' AND '$hasta') AS suma_salidas, tran_100.fecha,  tran_100.fecact,  tran_100.notas AS notas_doc,tran_100.referencia AS referencia_doc, tran_100k.um,invproducts.marca, tran_100.trannum, tran_100.idcentro, tran_100.idcentrod, invsites.descrip as o_d, inv_def.invclase, inv_def.descrip, CONCAT(tran_100.serie, tran_100.numero) as num,tran_100k.itemline,  tran_100k.cantidad, tran_100k.idrec, tran_100k.uniconv, tran_100k.preciotran, tran_100k.precioneto, tran_100k.notas, ctauxi.descrip as cliente_proveedor, inv_def.agrupa, gusers.descrip as usuario, tran_100.ingresa, tran_100.modifica FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum  INNER JOIN inv_def ON inv_def.invclase = tran_100k.idclase INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto LEFT JOIN invsites ON invsites.idcentro= tran_100.idcentrod LEFT JOIN ctauxi as ctauxi ON ctauxi.idauxi= tran_100.idcps INNER JOIN gusers ON gusers.iduser=tran_100.whodidit where tran_100k.idproducto=$idproducto AND tran_100.idcentro=$idcentro AND tran_100.fecha BETWEEN '$desde' AND '$hasta' ORDER BY tran_100.fecact,tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertarConversionProducto($idcentro, $fecha, $idcps, $idclase, $notas){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');
				
				$idtrannum = $this->db_b->insert_id();
                return $idtrannum;
            }
        }

        function getConversionesDeProducto($idcentro, $idclase){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	$Consulta = "SELECT tran_100.trannum, tran_100.idcentro, tran_100.notas, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, tran_100.lines100k, ctauxi.descrip AS nombreCliente FROM tran_100 LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps WHERE tran_100.idcentro = $idcentro AND tran_100.idclase = $idclase";
                $query = $this->db_b->query($Consulta);
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function getInformacionConversion($trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	$Consulta = "SELECT tran_100.trannum, tran_100.idcps, tran_100.idcentro, tran_100.notas, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, ctauxi.descrip AS nombreCliente FROM tran_100 LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($Consulta);
                $informacion = $query->result();
                
                return $informacion;
            }
        }

        function getDatosConversionProductos($trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	$Consulta = "SELECT invproducts.descrip, invproducts.precioventa, tran_100k.*, invproducts.um as umProduct, invproducts.mur as murPro, invproducts.barcode as barcodePro, invproducts.sst as sstPro FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
                $query = $this->db_b->query($Consulta);
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function getGroupsProductosConversiones($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT invcatalog.idcatalogo, IFNULL(invcatalog.imagen, '') AS imagen, invcatalog.descrip FROM invcatalog INNER JOIN invproducts ON invcatalog.idcatalogo = invproducts.idcatalogo WHERE invproducts.estado = 1 AND invproducts.barcode LIKE '%A' ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }

        function getSumProductosConversiones($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.idcatalogo, SUM(IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 1)) AS total FROM invproducts WHERE invproducts.estado = 1 GROUP BY invproducts.idcatalogo";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }

        function getListadoTransaccionesAgrupadas($agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invclase, descrip FROM inv_def WHERE agrupa = '".$agrupa."'";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }

        function getInventarioByCatalogConversion($trannum, $idcatalogo, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT (SELECT COUNT(inv2.idproducto) FROM invproducts AS inv2 WHERE inv2.estado = 1 AND REPLACE (inv2.barcode, 'A', '') = invproducts.barcode AND inv2.idproducto != invproducts.idproducto) AS totalProductos,
                    IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0 ) AS existe,
                    invproducts.idcatalogo, invproducts.mur, invproducts.sst, invproducts.tipotax, invproducts.costounitario AS costouni, invproducts.idproducto, invproducts.tipotax, invproducts.descrip,
                    invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                    IFNULL(inv_batch.costounitario, 0) AS costounitario
                FROM invproducts
                LEFT JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                WHERE invproducts.idcatalogo = $idcatalogo AND invproducts.estado = 1 AND invproducts.barcode NOT LIKE '%A'
                HAVING cantidad > 0";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getBarcodeProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT barcode FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();
                
                $barcode = $info['barcode'];
                return $barcode;
            }
        }

        function getProductosToConversion($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT barcode FROM invproducts WHERE idproducto = $idproducto";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();

                $barcode = $info['barcode'];

                $Consulta = "SELECT idproducto, descrip, um, mur, sst, barcode, costounitario FROM invproducts WHERE estado = 1 AND idproducto != $idproducto AND (barcode = '".$barcode."A' OR barcode = '".$barcode."B' OR barcode = '".$barcode."C')";
                $Query = $this->db_b->query($Consulta);
                $resultado = $Query->result();

                return $resultado;
            }
        }

        function insertarProductoConversion($trannum,$um,$precio,$idcatalogo,$uniconv,$tipotax,$cantidad,$idproducto,$cantidadA,$factorA,$idproductoA,$idcentro,$idclase){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLItemLine = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
                $QueryItemLine = $this->db_b->query($SQLItemLine);

                if($QueryItemLine->num_rows() > 0){
                    $resultado = $QueryItemLine->row_array();
                    $itemLine = $resultado['itemline'] + 1;
                }else{
                    $itemLine = 1;
                }

                $SQLBatch = "SELECT idbatch FROM inv_batch WHERE idproducto = $idproducto";
                $QueryBatch = $this->db_b->query($SQLBatch);
				$infoBatch = $QueryBatch->row_array();

				$SQLBin = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
                $QueryBin = $this->db_b->query($SQLBin);
				$infoBin = $QueryBin->row_array();

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproducto', $idproducto);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idbatch', $infoBatch['idbatch']);
                $this->db_b->set('idbin', $infoBin['idbin']);
                $this->db_b->set('cantidad', $cantidad * -1);
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('costounitario', $precio);
                $this->db_b->set('tax1', $tipotax);
                $this->db_b->set('notas', $idproductoA.','.$cantidadA);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100k');

                return $query;
            }
        }

        function eliminarProductoConvertido($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM tran_100k WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);

                return $query;
            }
        }

        function getDatosProductoSearchConversion($prosearch, $dato, $idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($prosearch == 1){
                    $search = 'idproducto';
                }elseif($prosearch == 2){
                    $search = 'modelo';
                }elseif($prosearch == 3){
                    $search = 'barcode';
                }elseif($prosearch == 4){
                    $search = 'xpos';
                }elseif($prosearch == 5){
                    $search = 'descrip';
                }
                
                if($prosearch == 3){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.mur, invproducts.sst, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto,
                        invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                        IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                        IFNULL(inv_batch.costounitario, 0) AS costounitario,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM invproducts
                    LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        $consulta = "SELECT invproducts.idcatalogo, invproducts.mur, invproducts.sst, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto,
                            invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                            IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                            IFNULL(inv_batch.costounitario, 0) AS costounitario,
                            (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                        FROM invproducts
                        LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                        INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                        INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 2 AND invpromulti.estatus = 1
                        WHERE invproducts.estado = 1 AND invpromulti.descrip = '$dato'";
                        $query = $this->db_b->query($consulta);
                        if($query->num_rows() > 0){
                            $resultado = $query->result();
                            return $resultado;
                        }else{
                            return 0;
                        }
                    }
                }else if($prosearch == 5){
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.mur, invproducts.sst, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto,
                        invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                        IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                        IFNULL(inv_batch.costounitario, 0) AS costounitario,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM invproducts
                    LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.descrip LIKE '%$dato%'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }else{
                    $consulta = "SELECT invproducts.idcatalogo, invproducts.mur, invproducts.sst, invproducts.costounitario AS costouni, invcatalog.descrip AS namecatalogo, invproducts.tipotax, invproducts.idproducto,
                        invproducts.tipotax, invproducts.descrip, invproducts.marca, invproducts.imagen, invproducts.um, invproducts.modelo, invproducts.precioventa, invproducts.barcode, invproducts.notas,
                        IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                        IFNULL(inv_batch.costounitario, 0) AS costounitario,
                        (SELECT IF(EXISTS(SELECT tran_100k.trannum FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.trannum = $trannum), 1, 0)) AS existe
                    FROM invproducts
                    LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                    INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                    WHERE invproducts.estado = 1 AND invproducts.$search = '$dato'";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() > 0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return 0;
                    }
                }    
            }
        }

        function updateCierreConversion($trannum, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');

                $SQLDatos = "CALL totaliza100($trannum, 1);";
                $QueryDatos = $this->db_b->query($SQLDatos);

                return $query;
            }
        }

        function insertarRegistroCierreConversion($idclase, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('fecact', $date->format('Y-m-d'));
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');

                $trannumcierre = $this->db_b->insert_id();

                return $trannumcierre;
            }
        }

        function updateBinBatchConversion($trannumCierre, $trannum, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $date = new DateTime();
                $idcentro = $this->session->userdata('idcentrouser');
                
                $SQLDatos = "SELECT tran_100k.idproducto, tran_100k.costounitario, tran_100k.notas, invproducts.mur, invproducts.sst FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE tran_100k.trannum = $trannum";
                $QueryDatos = $this->db_b->query($SQLDatos);
                $SQLResultado = $QueryDatos->result();
                
                $SQLLocation = "SELECT idbin FROM invlocations WHERE idcentro = $idcentro";
                $QueryLocation = $this->db_b->query($SQLLocation);
                $infoLocation = $QueryLocation->row_array();
                $idBin = $infoLocation['idbin'];
                
                $itemLine=1;
                foreach($SQLResultado as $info){
                    $infoProducto = explode(",", $info->notas);
                    $idproducto = $infoProducto[0];
                    $cantidad = $infoProducto[1];
                    
                    if($info->mur != 0){
                        $factor = $info->mur;
                    }else{
                        if($info->sst != 0){
                            $factor = $info->sst;
                        }
                    }

                    $costoXunidad = $info->costounitario / $factor;

                    $SQLProducto = "SELECT tipotax, um, mur, sst FROM invproducts WHERE idproducto = ".trim($idproducto);
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $infoPro = $QueryProducto->row_array();

                    if($infoPro['mur'] != 0){
                        $factorHijo = $infoPro['mur'];
                    }else{
                        if($infoPro['sst'] != 0){
                            $factorHijo = $infoPro['sst'];
                        }
                    }

                    $SQLBatch = "SELECT IFNULL(inv_batch.idbatch, 0) AS idbatch, IFNULL(inv_batch.costounitario, 0) AS costounitario, IFNULL(SUM((tran_100k.cantidad * tran_100k.uniconv)), 0) AS Cantidad FROM tran_100k INNER JOIN inv_batch ON tran_100k.idproducto = inv_batch.idproducto INNER JOIN invlocations ON tran_100k.idbin = invlocations.idbin WHERE tran_100k.idproducto = ".trim($idproducto);
                    $QueryBatch = $this->db_b->query($SQLBatch);
                    $ResultBatch = $QueryBatch->row_array();
                    $idBatch = $ResultBatch['idbatch'];
                    
                    if($idBatch != 0){
                        $costoUni = $ResultBatch['costounitario'];
                        $batchCantidad = $ResultBatch['Cantidad'];
                        
                        if($batchCantidad != 0){
                            $pValor = $costoUni * $batchCantidad;
                            $nCantidad = 1 * $cantidad;
                            $nCosto = $costoXunidad * $factorHijo;
                            $sValor = $nCantidad * $nCosto;
                            $sumCantidad = $batchCantidad + $nCantidad;
                            $nuevoCosto = ($pValor + $sValor) / $sumCantidad;
                        }else{
                            $nuevoCosto = $costoXunidad * $factorHijo;
                        }
                        
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idbatch', $idBatch);
                        $queryInsertBatch = $this->db_b->update('inv_batch');
                        
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idproducto', $idproducto);
                        $this->db_b->update('invproducts');
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannumCierre);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $itemLine);
                        $this->db_b->set('idcentro', $idcentro);
                        $this->db_b->set('idproducto', $idproducto);
                        $this->db_b->set('idbatch', $idBatch);
                        $this->db_b->set('idbin', $idBin);
                        $this->db_b->set('cantidad', $cantidad);
                        $this->db_b->set('um', $infoPro['um']);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('preciotran', $nuevoCosto);
                        $this->db_b->set('precioneto', $nuevoCosto);
                        $this->db_b->set('tax1', $infoPro['tipotax']);
                        $this->db_b->set('notas', 'Registro ingresado por Conversion');
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }else{
                        $dateCompra = $date->format('Y-m-d');
                        $exDate = explode("-", $dateCompra);
                        $nameBatch = "B".$exDate[0].$exDate[1].$exDate[2];
                        
                        $nCosto = $costoXunidad * $factorHijo;
                        $nuevoCantidad = 1 * $cantidad;
                        
                        $this->db_b->set('idbatch', 0);
                        $this->db_b->set('idproducto', $idproducto);
                        $this->db_b->set('descrip', $nameBatch);
                        $this->db_b->set('costounitario', $nCosto);
                        $this->db_b->set('ccompra', $nuevoCantidad);
                        $this->db_b->set('fcompra', $date->format('Y-m-d'));
                        $this->db_b->set('estado', 1);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $queryInsertBatch = $this->db_b->insert('inv_batch');
                        $idBat = $this->db_b->insert_id();
                        
                        $this->db_b->set('costounitario', $nCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idproducto', $idproducto);
                        $this->db_b->update('invproducts');
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannumCierre);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $itemLine);
                        $this->db_b->set('idcentro', $idcentro);
                        $this->db_b->set('idproducto', $idproducto);
                        $this->db_b->set('idbatch', $idBat);
                        $this->db_b->set('idbin', $idBin);
                        $this->db_b->set('cantidad', $cantidad);
                        $this->db_b->set('um', $infoPro['um']);
                        $this->db_b->set('uniconv', 1);
                        $this->db_b->set('costounitario', $nCosto);
                        $this->db_b->set('preciotran', $nCosto);
                        $this->db_b->set('tax1', $infoPro['tipotax']);
                        $this->db_b->set('notas', 'Registro ingresado por Conversion');
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }

                    $itemLine++;
                }
                
                return true;
            }
        }

        function getCantidadStock($idproducto, $idcentros){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT IFNULL(SUM(tran_100k.cantidad * tran_100k.uniconv), 0) AS cantidad FROM tran_100k WHERE tran_100k.idproducto = $idproducto AND tran_100k.idcentro IN ($idcentros)";
                $query = $this->db_b->query($consulta);
                $info = $query->row_array();
                
                return $info['cantidad'];
            }
        }
        
        function reporteExportacionDeMovimientos($idrec, $idcentros, $idtransacciones, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$ConsultaVN = "SELECT tran_100k.idrec, tran_100k.idcentro, invsites.descrip AS nameSucursal, invsites2.descrip AS origen_destino, ctauxi3.descrip AS nameProveedor, ctauxi4.descrip AS nameGestor, ctcajas.descrip AS nameCaja, tran_100.estatus,
                    tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.notas, tran_100.fecha, inv_def.descrip AS nameDocumento, inv_def.xpos AS xposVenta, tran_100k.itemline, COALESCE(NULLIF(tran_100k.um, ''), invproducts.um) AS um,
                    invproducts.marca, invproducts.modelo, invcatalog.descrip AS nameLinea, invcatalog2.descrip AS nameDepartamento, invproducts.idproducto, invproducts.descrip AS nameProducto, ctauxi.descrip AS nameCliente,
                    ctauxi2.descrip AS nameVendedor, gvars.descripcion AS tipoProducto, invproducts.comision, tran_100k.uniconv, tran_100k.tax1, tran_100k.cantidad, tran_100k.notas AS notasProducto, invproducts.tipo, inv_def.inopera, 
                    CASE WHEN inv_def.agrupa = 'CO' THEN tran_100k.preciotran ELSE tran_100k.costounitario END AS costounitario,
                    CASE WHEN inv_def.agrupa = 'IN' THEN invproducts.precioventa ELSE tran_100k.precioneto END AS precioneto
                FROM tran_100k
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro
                LEFT JOIN invsites AS invsites2 ON tran_100.idcentrod = invsites2.idcentro
                LEFT JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                LEFT JOIN ctauxi AS ctauxi2 ON tran_100k.idworker = ctauxi2.idauxi
                LEFT JOIN ctauxi AS ctauxi3 ON invproducts.idprovee = ctauxi3.idauxi
                LEFT JOIN ctauxi AS ctauxi4 ON tran_100.idworker = ctauxi4.idauxi
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
                INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo
                INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                WHERE tran_100.idcentro IN ($idcentros)
                AND tran_100.idclase IN ($idtransacciones)
                AND tran_100.estatus IN (1, 2)
                AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                AND tran_100k.idrec > $idrec 
                GROUP BY tran_100k.idrec
                ORDER BY tran_100k.idrec
                LIMIT 1000;
";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }

        function reporteExportacionDeMovimientosCSV($idcentros, $idtransacciones, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$datosCentros = explode("_", $idcentros);
				$totalCentros = count($datosCentros);
				$ConsultaWhere = "(";
				for($i=0; $i<$totalCentros; $i++){
					$ConsultaWhere .= "tran_100.idcentro = ".$datosCentros[$i]." OR ";
				}
                
                $ConsultaWhere = substr($ConsultaWhere, 0, -3);
				$ConsultaWhere = $ConsultaWhere.")";
                
				$datosTran = explode("_", $idtransacciones);
				$totalTran = count($datosTran);
				$ConsultaWhere2 = "(";
				for($i=0; $i<$totalTran; $i++){
					$ConsultaWhere2 .= "tran_100.idclase = ".$datosTran[$i]." OR ";
				}
				
				$ConsultaWhere2 = substr($ConsultaWhere2, 0, -3);
				$ConsultaWhere2 = $ConsultaWhere2.")";
				
                $ConsultaVN = "SELECT ctauxi.nrc, tran_100.trannum, tran_100.serie, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fechaFormat,
                inv_def.notas AS xposVenta, invproducts.barcode, invproducts.descrip AS nameProducto, invproducts.modelo, tran_100k.uniconv, tran_100k.precioneto, invproducts.idproducto,
                tran_100k.tax1, tran_100k.cantidad, tran_100k.notas AS notasProducto, invproducts.tipo, caj_def.xpos AS xposPago, ctcajas.resolucion, tran_100k.idworker,
                ctcajas.xpos AS codigoCaja
                FROM tran_100k 
                INNER JOIN tran_100    ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN ctauxi      ON tran_100.idcps = ctauxi.idauxi 
                LEFT  JOIN tran_100c   ON tran_100k.trannum = tran_100c.trannum
                LEFT  JOIN caj_def     ON tran_100c.cajclase = caj_def.cajclase
                LEFT  JOIN ctcajas     ON tran_100.idcaja = ctcajas.idcaja 
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                INNER JOIN inv_def     ON tran_100.idclase = inv_def.invclase
                WHERE " . $ConsultaWhere . " AND ".$ConsultaWhere2." AND (tran_100.estatus = 1 OR tran_100.estatus = 9) AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' 
                GROUP BY tran_100k.idrec";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }

        function reporteExportacionDeMovimientosVNExcel($fechaini, $fechafin, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$ConsultaVN = "SELECT tran_100.trannum, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha, inv_def.descrip AS tipoDocumento, invproducts.descrip AS nameProducto, invproducts.tipo, ctauxi.descrip AS nameCliente, tran_100k.uniconv, tran_100k.precioneto, tran_100k.tax1, tran_100k.cantidad, tran_100k.notas AS notasProducto 
                FROM tran_100k 
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum 
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                LEFT JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi 
                WHERE tran_100.idcentro = $idcentro AND tran_100.estatus = 1 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY tran_100k.idrec";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }

        function getListadoDescargaMP($idclase, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT tran_100.trannum, tran_100.fecha, tran_100.fecvence, tran_100.idcentro, tran_100.estatus, tran_100.lines100k, invsites.descrip AS nameSucursal, inv_def.descrip AS transaccion FROM tran_100
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                WHERE tran_100.idclase = $idclase AND tran_100.idcentro = $idcentro AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                ORDER BY tran_100.fecha DESC";
                $query = $this->db_b->query($Consulta);
                
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function validateDescargaMP($fechaini, $fechafin, $idclase, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT trannum FROM tran_100 WHERE idclase = $idclase AND idcentro = $idcentro AND fecha >= '$fechaini' AND fecvence <= '$fechafin' AND estatus != 9";
                $query = $this->db_b->query($Consulta);
                
                if($query->num_rows() > 0){
                	$infoValidate = 1;
                }else{
                	$infoValidate = 0;
                }
                
                return $infoValidate;
            }
        }

        function insertarDescargaMP($fechaini, $fechafin, $idclase, $idcentro, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('fecha', $fechaini);
                $this->db_b->set('fecvence', $fechafin);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');

                $trannum = $this->db_b->insert_id();
                
                return $trannum;
            }
        }
        
        function getInformacionDescargaMP($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT tran_100.trannum, tran_100.fecha, tran_100.fecvence, tran_100.idcentro, tran_100.idclase, tran_100.idworker, tran_100.estatus, tran_100.notas, invsites.descrip AS nameCentro, ctauxi.descrip AS solicita FROM tran_100
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                INNER JOIN ctauxi ON tran_100.idworker = ctauxi.idauxi WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($Consulta);
                
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function getDetalleCombosDescarga($fechaini, $fechafin, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT tran_100k.idproducto, invproducts.descrip, invproducts.modelo, invproducts.um, ABS(SUM(tran_100k.cantidad * tran_100k.uniconv)) AS cantidad FROM tran_100k
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto AND invproducts.tipo = 4
                WHERE tran_100.idcentro = $idcentro AND tran_100k.cantidad != 0 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                GROUP BY tran_100k.idproducto";
                $query = $this->db_b->query($Consulta);
                
                #INNER JOIN invpromulti ON invproducts.idproducto = invpromulti.idproducto AND invpromulti.idgvar = 30

                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function getDetalleComponentesCombosDescarga($trannum, $fechaini, $fechafin, $idcentro, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($estado == 0){
                    $Consulta = "SELECT invproducts.idproducto, gvars.descripcion AS tipoproducto, invproducts.descrip, invproducts.modelo, invproducts.um, SUM(ABS((invpromulti.uniconv * tran_100k.cantidad))) AS cantidad,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invpromulti.descrip AND tran_100k.idcentro = $idcentro), 0) AS saldo 
                    FROM invpromulti
                    INNER JOIN tran_100k ON tran_100k.idproducto = invpromulti.idproducto AND tran_100k.cantidad != 0
                    INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum
                    INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                    INNER JOIN invproducts ON invpromulti.descrip = invproducts.idproducto AND invproducts.tipo != 4
                    INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                    WHERE tran_100.idcentro = $idcentro AND (invpromulti.idgvar = 30 OR invpromulti.idgvar = 31) AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                    GROUP BY invpromulti.descrip ORDER BY invproducts.descrip";
                }else if($estado == 1){
                    $Consulta = "SELECT invproducts.idproducto, gvars.descripcion AS tipoproducto, invproducts.descrip, invproducts.modelo, invproducts.um, ABS(tran_100k.cantidad) AS cantidad, (0) AS saldo FROM tran_100k
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                    INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                    WHERE tran_100k.trannum = $trannum
                    ORDER BY invproducts.descrip";
                }
                
                $query = $this->db_b->query($Consulta);
                
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        function validateCajasFacturacion($fecha, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT ctcajas.idcaja, ctcajas.descrip, IFNULL(tran_100z.idrec, 0) AS idrec FROM ctcajas
                LEFT JOIN tran_100z ON tran_100z.idcentro = ctcajas.idcentro AND tran_100z.idcaja = ctcajas.idcaja AND tran_100z.tipo = 2 AND tran_100z.fechahora = '$fecha 00:00:00'
                WHERE ctcajas.idcentro = $idcentro AND ctcajas.ucajera = 1
                GROUP BY ctcajas.idcaja";
                $query = $this->db_b->query($Consulta);

                if($query->num_rows() > 0){
                    $informacion = $query->result();
                }else{
                	$informacion = false;
                }

                return $informacion;
            }
        }

        function validateAperturaCajaFacturacion($fecha, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT ctcajas.descrip, IFNULL(tran_100z.idrec, 0) AS idrec FROM ctcajas
                LEFT JOIN tran_100z ON tran_100z.idcentro = ctcajas.idcentro AND tran_100z.idcaja = ctcajas.idcaja AND tran_100z.tipo = 0 AND tran_100z.fechahora = '$fecha 00:00:00'
                WHERE ctcajas.idcentro = $idcentro AND ctcajas.idcaja = $idcaja AND ctcajas.ucajera = 1
                GROUP BY ctcajas.idcaja";
                $query = $this->db_b->query($Consulta);

                if($query->num_rows() > 0){
                    $info = $query->row_array();
                    $informacion = $info['idrec'];
                }else{
                	$informacion = false;
                }

                return $informacion;
            }
        }

        function cerrarDescargaMP($trannum, $fechaini, $fechafin, $idcentro, $idclase, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $Consulta = "SELECT invproducts.idproducto, invproducts.tipotax, inv_batch.idbatch, inv_batch.costounitario, invlocations.idbin, invproducts.um, SUM(invpromulti.uniconv * tran_100k.cantidad) AS cantidad
                FROM invpromulti INNER JOIN tran_100k ON tran_100k.idproducto = invpromulti.idproducto AND tran_100k.cantidad != 0
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                INNER JOIN invproducts ON invpromulti.descrip = invproducts.idproducto
                INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto
                INNER JOIN invlocations ON invlocations.idcentro = $idcentro
                WHERE tran_100.idcentro = $idcentro AND (invpromulti.idgvar = 30 OR invpromulti.idgvar = 31) AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                GROUP BY invpromulti.descrip";
                $query = $this->db_b->query($Consulta);
                $informacion = $query->result();
                
                $itemLine=1;
                foreach($informacion as $info){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $info->idproducto);
                    $this->db_b->set('idbatch', $info->idbatch);
                    $this->db_b->set('idbin', $info->idbin);
                    $this->db_b->set('cantidad', $info->cantidad);
                    $this->db_b->set('um', $info->um);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('idworker', $idworker);
                    $this->db_b->set('costounitario', $info->costounitario);
                    $this->db_b->set('tax1', $info->tipotax);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $this->db_b->insert('tran_100k');

                    $itemLine++;
                }

                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100');
                
                $this->updateCostoCombos($idcentro, $fechaini, $fechafin);

                $ConsultaTotaliza = "CALL totaliza100($trannum, 1)";
                $infoUpdate = $this->db_b->query($ConsultaTotaliza);

                return $infoUpdate;
            }
        }

        function updateCostoCombos($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQLCombos = "SELECT tran_100k.idrec, tran_100k.trannum, tran_100k.idproducto, tran_100.estatus FROM tran_100k 
                INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum 
                INNER JOIN inv_def ON tran_100k.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto AND invproducts.tipo = 4
                WHERE tran_100k.costounitario = 0 AND tran_100.idcentro = $idcentro AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'";
                $Query = $this->db_b->query($SQLCombos);
                
                if($Query->num_rows() > 0){
                    $infoResult = $Query->result();

                    foreach($infoResult as $info){
                        $costo_combo = $this->getTotalCostoCombo($info->idproducto);
                        
                        $this->db_b->set('costounitario', $costo_combo);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idrec', $info->idrec);
                        $this->db_b->update('tran_100k');

                        $SQLTot = "CALL totaliza100(".$info->trannum.",".$info->estatus.");";
                        $query  = $this->db_b->query($SQLTot);
                    }
                }
                
                return $query;
            }
        }
        
        function getTotalCostoCombo($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLCosto = "SELECT SUM(inv_batch.costounitario * invpromulti.uniconv) AS costo_combo FROM invpromulti 
                INNER JOIN invproducts ON invpromulti.descrip = invproducts.idproducto
                INNER JOIN inv_batch   ON invproducts.idproducto = inv_batch.idproducto
                WHERE invpromulti.idproducto = $idproducto AND invpromulti.idgvar = 30";
                $Query = $this->db_b->query($SQLCosto);
                
                $costo_combo = 0;
                if($Query->num_rows() > 0){
                    $infoQuery = $Query->row_array();
                    $costo_combo = $infoQuery['costo_combo'];
                }

                return $costo_combo;
            }
        }

        function anularDescargaComponentes($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $infoUpdate = $this->db_b->update('tran_100');
                
                return $infoUpdate;
            }
        }

        function getDepartamentosByID($idDepartamentos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $arreglo = explode(",", $idDepartamentos);

                $whereSQL = "";
                for($i=0; $i<count($arreglo); $i++){
                    $whereSQL .= "idcatalogo = " . $arreglo[$i] . " OR ";
                }
                $whereSQL = substr($whereSQL, 0, -4);

                $Consulta = "SELECT idcatalogo AS id, descrip FROM invcatalog WHERE " . $whereSQL;
                $query = $this->db_b->query($Consulta);

                if($query->num_rows() > 0){
                    $informacion = $query->result();
                }else{
                	$informacion = false;
                }

                return $informacion;
            }
        }

        function generarReporteADValorem($idcentro, $idcatalogo, $fechaini, $fechafin, $idautoconsumo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $Consulta = "SELECT invproducts.idproducto, invproducts.descrip, invcatalog.descrip AS linea, invproducts.tipotax, invproducts.um, invproducts.modelo, invproducts.coarancel, invproducts.copartida, 
                (SELECT SUM(t100k_2.cantidad * t100k_2.uniconv) FROM tran_100k AS t100k_2 INNER JOIN tran_100 AS t100_2 ON t100_2.trannum = t100k_2.trannum AND t100_2.fecha < '$fechaini' AND t100_2.estatus = 1 WHERE t100k_2.idproducto = invproducts.idproducto AND t100k_2.idcentro = $idcentro) AS inicial, 
                (SELECT SUM(t100k_3.cantidad * t100k_3.uniconv) FROM tran_100k AS t100k_3 INNER JOIN tran_100 AS t100_3 ON t100_3.trannum = t100k_3.trannum INNER JOIN inv_def AS inv_def_3 ON t100k_3.idclase = inv_def_3.invclase AND inv_def_3.agrupa = 'CO' WHERE t100k_3.idproducto = invproducts.idproducto AND t100k_3.idcentro = $idcentro AND t100_3.estatus = 1 AND t100_3.fecha BETWEEN '$fechaini' AND '$fechafin') AS compras, 
                (SELECT SUM(t100k_4.cantidad * t100k_4.uniconv) FROM tran_100k AS t100k_4 INNER JOIN tran_100 AS t100_4 ON t100_4.trannum = t100k_4.trannum INNER JOIN inv_def AS inv_def_4 ON t100k_4.idclase = inv_def_4.invclase AND inv_def_4.agrupa = 'VN' AND inv_def_4.inopera = 1 WHERE t100k_4.idproducto = invproducts.idproducto AND t100k_4.idcentro = $idcentro AND t100_4.estatus = 1 AND t100_4.fecha BETWEEN '$fechaini' AND '$fechafin') AS devoluciones, 
                (SELECT SUM(t100k_5.cantidad * t100k_5.uniconv) FROM tran_100k AS t100k_5 INNER JOIN tran_100 AS t100_5 ON t100_5.trannum = t100k_5.trannum WHERE t100k_5.idproducto = invproducts.idproducto AND t100_5.idclase = $idautoconsumo AND t100k_5.idcentro = $idcentro AND t100_5.estatus = 1 AND t100_5.fecvence BETWEEN '$fechaini' AND '$fechafin') AS autoconsumo, 
                (SELECT SUM(t100k_6.cantidad * t100k_6.uniconv) FROM tran_100k AS t100k_6 INNER JOIN tran_100 AS t100_6 ON t100_6.trannum = t100k_6.trannum INNER JOIN inv_def AS inv_def_6 ON t100k_6.idclase = inv_def_6.invclase AND inv_def_6.agrupa = 'VN' AND inv_def_6.inopera = -1 WHERE t100k_6.idproducto = invproducts.idproducto AND t100k_6.idcentro = $idcentro AND t100_6.estatus = 1 AND t100_6.fecha BETWEEN '$fechaini' AND '$fechafin') AS ventas, 
                (SELECT SUM(t100k_7.precioneto * ABS(t100k_7.cantidad)) FROM tran_100k AS t100k_7 INNER JOIN tran_100 AS t100_7 ON t100_7.trannum = t100k_7.trannum INNER JOIN inv_def AS inv_def_7 ON t100k_7.idclase = inv_def_7.invclase AND inv_def_7.agrupa = 'VN' AND inv_def_7.inopera = -1 WHERE t100k_7.idproducto = invproducts.idproducto AND t100k_7.idcentro = $idcentro AND t100_7.estatus = 1 AND t100_7.fecha BETWEEN '$fechaini' AND '$fechafin') AS vprecioneto 
                FROM invproducts
                INNER JOIN invcatalog   ON invcatalog.idcatalogo = invproducts.idcatalogo
                WHERE invcatalog.idnivel1 = $idcatalogo AND invproducts.copartida != ''";
                $query = $this->db_b->query($Consulta);

                if($query->num_rows() > 0){
                    $informacion = $query->result();
                }else{
                	$informacion = false;
                }

                return $informacion;
            }
        }

        #GoXpos
        function insertarDescargaOC($fecha, $idclase, $idcentro, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $this->db_b->insert('tran_100');

                $trannum = $this->db_b->insert_id();
                
                return $trannum;
            }
        }

        #GoXpos
        function getListadoOrdenesToDescarga($trannum, $idcentro, $estado) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT gvars.descripcion as estado, orders_100.trannum, DATE_FORMAT(orders_100.fecha, '%Y/%m/%d') AS fecha, 
                DATE_FORMAT(orders_100.fecact, '%Y/%m/%d') AS fecact, DATE_FORMAT(orders_100.dev_date, '%Y/%m/%d') AS dev_date, ctauxi.descrip AS workername, clients.descrip as nameProveedor, 
                orders_100.val_tot, SUM(orders_100.val_pro) AS val_total, invsites.descrip as sucur, gusers.descrip as username
                FROM orders_100 
                INNER JOIN ctauxi ON orders_100.idworker = ctauxi.idauxi 
                INNER JOIN ctauxi as clients ON orders_100.idcps = clients.idauxi 
                INNER JOIN gvars ON orders_100.estatus = gvars.valor_num AND  nombre LIKE 'po_stat' 
                INNER JOIN invsites ON invsites.idcentro=orders_100.dev_place 
                INNER JOIN gusers ON orders_100.whodidit = gusers.iduser
                WHERE agrupa = 'CO' AND orders_100.dev_contact = 1 AND orders_100.referencia != '$trannum' AND orders_100.dev_place = $idcentro AND orders_100.estatus = $estado 
                GROUP BY orders_100.trannum ORDER BY orders_100.trannum DESC";
                $Query = $this->db_b->query($SQL);

                if($Query->num_rows() > 0){
                    return $Query->result();
                }else{
                	return false;
                }
            }
        }
        
        #GoXpos
        function getListadoOrdenesInDescarga($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQL = "SELECT gvars.descripcion as estado, orders_100.trannum, DATE_FORMAT(orders_100.fecha, '%Y/%m/%d') AS fecha, 
                DATE_FORMAT(orders_100.fecact, '%Y/%m/%d') AS fecact, DATE_FORMAT(orders_100.dev_date, '%Y/%m/%d') AS dev_date, ctauxi.descrip AS workername, clients.descrip as nameProveedor, 
                orders_100.val_tot, SUM(orders_100.val_pro) AS val_total, invsites.descrip as sucur, gusers.descrip as username
                FROM orders_100 
                INNER JOIN ctauxi ON orders_100.idworker = ctauxi.idauxi 
                INNER JOIN ctauxi as clients ON orders_100.idcps = clients.idauxi 
                INNER JOIN gvars ON orders_100.estatus = gvars.valor_num AND  nombre LIKE 'po_stat' 
                INNER JOIN invsites ON invsites.idcentro=orders_100.dev_place 
                INNER JOIN gusers ON orders_100.whodidit = gusers.iduser
                WHERE agrupa = 'CO' AND orders_100.dev_contact = 1 AND orders_100.referencia = '$trannum'  
                GROUP BY orders_100.trannum ORDER BY orders_100.trannum DESC";
                $Query = $this->db_b->query($SQL);

                if($Query->num_rows() > 0){
                    return $Query->result();
                }else{
                	return false;
                }
            }
        }

        #GoXpos
        function getDetalleComponentesProductosDescarga($trannum, $estado, $idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($estado == 0){
                    $SQL = "SELECT invproducts.idproducto, gvars.descripcion AS tipoproducto, invproducts.descrip, invproducts.modelo, invproducts.um, ABS(SUM(invpromulti.lowrange * orders_100k.cantidad)) AS cantidad,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invpromulti.idcps AND tran_100k.idcentro = $idcentro), 0) AS saldo 
                    FROM invpromulti
                    INNER JOIN orders_100k ON orders_100k.idproducto = invpromulti.idproducto AND orders_100k.cantidad != 0
                    INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum
                    INNER JOIN invproducts ON invpromulti.idcps = invproducts.idproducto
                    INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                    WHERE orders_100.referencia = $trannum AND invpromulti.idgvar = 31 
                    GROUP BY invpromulti.idcps ORDER BY invproducts.descrip";
                }else if($estado == 1){
                    $SQL = "SELECT invproducts.idproducto, gvars.descripcion AS tipoproducto, invproducts.descrip, invproducts.modelo, invproducts.um, ABS(tran_100k.cantidad) AS cantidad, (0) AS saldo FROM tran_100k
                    INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                    INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                    WHERE tran_100k.trannum = $trannum
                    ORDER BY invproducts.descrip";
                }
                
                $query = $this->db_b->query($SQL);
                
                if($query->num_rows() > 0){
                	$informacion = $query->result();
                }else{
                	$informacion = false;
                }
                
                return $informacion;
            }
        }

        #GoXpos
        function setOrdenesDescargaOC($trannum, $ids_oc) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $trannums = implode(',', $ids_oc);
                $whereSQL = str_replace(',', ' OR trannum =', $trannums);

                $this->db_b->set('referencia', $trannum);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum = ' . $whereSQL);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }

        #GoXpos
        function cancelarOrdenDescarga($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('referencia', '');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');
                
                return $query;
            }
        }

        #GoXpos
        function cerrarDescargaOC($trannum, $idcentro, $idclase, $idworker, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $SQL = "SELECT invproducts.idproducto, gvars.descripcion AS tipoproducto, invproducts.descrip, invproducts.tipotax, invproducts.modelo, invproducts.um, ABS(SUM(invpromulti.lowrange * orders_100k.cantidad)) AS cantidad,
                    IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invpromulti.idcps AND tran_100k.idcentro = $idcentro), 0) AS saldo,
                    inv_batch.idbatch, inv_batch.costounitario, invlocations.idbin  
                    FROM invpromulti
                    INNER JOIN orders_100k ON orders_100k.idproducto = invpromulti.idproducto AND orders_100k.cantidad != 0
                    INNER JOIN orders_100 ON orders_100k.trannum = orders_100.trannum
                    INNER JOIN invproducts ON invpromulti.idcps = invproducts.idproducto
                    INNER JOIN inv_batch ON invproducts.idproducto = inv_batch.idproducto 
                    INNER JOIN invlocations ON invlocations.idcentro = $idcentro 
                    INNER JOIN gvars ON invproducts.tipo = gvars.valor_num AND gvars.nombre = 'gv_protipo'
                    WHERE orders_100.referencia = $trannum AND invpromulti.idgvar = 31 
                    GROUP BY invpromulti.idcps ORDER BY invproducts.descrip";
                $query = $this->db_b->query($SQL);
                $informacion = $query->result();
                
                $itemLine=1;
                foreach($informacion as $info){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $info->idproducto);
                    $this->db_b->set('idbatch', $info->idbatch);
                    $this->db_b->set('idbin', $info->idbin);
                    $this->db_b->set('cantidad', $info->cantidad);
                    $this->db_b->set('um', $info->um);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('idworker', $idworker);
                    $this->db_b->set('costounitario', $info->costounitario);
                    $this->db_b->set('tax1', $info->tipotax);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $this->db_b->insert('tran_100k');

                    $itemLine++;
                }

                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100');
                
                $ConsultaTotaliza = "CALL totaliza100($trannum, 1)";
                $infoUpdate = $this->db_b->query($ConsultaTotaliza);

                return $infoUpdate;
            }
        }

        #GoXpos
        function anularDescargaOC($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('referencia', '');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('referencia', $trannum);
                $this->db_b->update('orders_100');

                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $infoUpdate = $this->db_b->update('tran_100');
                
                return $infoUpdate;
            }
        }

        function getComprasXProveedor($fechaini, $fechafin, $idproveedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT 
                    inv_def.descrip transaccion,
                    DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                    tran_100.trannum,
                    tran_100.serie,
                    tran_100.numero,
                    COUNT(tran_100k.idrec) as cantidadTotal,
                    SUM(tran_100k.cantidad) as unidadesTotal,
                    SUM(ROUND(tran_100k.preciotran,2)  * ROUND(tran_100k.cantidad,2)) as costoTotal
                    FROM
                    tran_100
                    INNER JOIN tran_100k ON tran_100.trannum=tran_100k.trannum
                    INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                    INNER JOIN invproducts ON invproducts.idproducto=tran_100k.idproducto
                    WHERE tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'  AND tran_100.estatus = 1 AND inv_def.agrupa='CO' AND tran_100.idcps=$idproveedor
                    GROUP BY tran_100.trannum ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        //REPORTE OTRAS SALIDAS
        function getListadoOtrasSalidasReporte($idclases, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $whereSQL = explode('-', $idclases);
                $whereSQL = implode(' OR tran_100.idclase = ', $whereSQL);
             
                //var_dump($whereSQL);
                $consulta = "SELECT
                tran_100.trannum,
                tran_100.fecha,
                tran_100.fecact,
                tran_100.notas,
                invproducts.idproducto,
                invproducts.descrip AS nameProducto,
                tran_100.estatus,
                tran_100k.um,
                invcatalog.descrip AS nameLinea,
                IF(
                  inv_def.agrupa = 'CO',
                  tran_100k.preciotran,
                  tran_100k.costounitario
                ) AS costounitario,
                tran_100k.cantidad,
                inv_def.descrip AS nameDocumento,
                SUM(tran_100k.cantidad) AS sumCantidad
              FROM
                tran_100k
                INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase
                INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo
              WHERE
                fecha BETWEEN '$fechaini' AND '$fechafin' AND (tran_100.idclase = $whereSQL) AND tran_100.idcentro = $idcentro AND tran_100.estatus = 1
              GROUP BY
                tran_100.trannum, tran_100k.idproducto,nameDocumento
                order by tran_100.trannum";    
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        #   LISTADO DE TRANSACCIONES DE UN COMPONENTE
        function getTransaccionesPorComponente($idcomponente, $fechaini, $fechafin, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT
                                tran_100.trannum,
                                invproducts.descrip,
                                tran_100.serie,
                                tran_100.numero,
                                tran_100k.cantidad,
                                invpromulti.uniconv,
                                tran_100.idworker
                            FROM tran_100k
                            INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto
                            INNER JOIN invpromulti ON invpromulti.idproducto = invproducts.idproducto
                            INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
                            INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN'
                            WHERE (tran_100.fecha BETWEEN '$fechaini' AND '$fechafin') AND invpromulti.descrip = $idcomponente AND tran_100.idcentro = $idcentro AND tran_100k.cantidad != 0
                            GROUP BY tran_100.trannum, invproducts.descrip";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        #   DATOS REPORTE IVA
        function getDataTran100kIva($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invproducts.tipotax, tran_100k.tax1,tran_100k.uniconv, tran_100k.cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario
                FROM tran_100k 
                INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
                WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        #   DATOS REPORTE 142
        function getDatosPreviosF142($idcentro, $idproduct, $fechaini){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select("tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.idcps, tran_100k.idproducto, tran_100k.cantidad, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario,invproducts.precioventa as precioVentaFicha, inv_def.inopera, inv_def.agrupa");
                $this->db_b->from("tran_100k");
                $this->db_b->join('tran_100', 'tran_100.trannum = tran_100k.trannum', 'inner');
                $this->db_b->join('invproducts', 'invproducts.idproducto  = tran_100k.idproducto', 'inner');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
                $this->db_b->where('tran_100.idcentro', $idcentro);
                $this->db_b->where('tran_100k.idproducto', $idproduct);
                $this->db_b->where('tran_100.fecha <', $fechaini);
                $this->db_b->where('(tran_100.estatus = 1 OR tran_100.estatus = 2)');

                $this->db_b->order_by("tran_100.fecha", "ASC");

                $resultado = $this->db_b->get()->result_array();
                return $resultado;
            }
        }
        
        function getDatosF142($idcentro, $idproduct, $fechaini, $fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select("tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.idcps, tran_100k.idproducto, inv_def.descrip as descripDoc, invproducts.descrip as descripPro");
                $this->db_b->select("invproducts.precioventa as precioVentaFicha, tran_100k.cantidad, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario, inv_def.inopera, inv_def.agrupa");
                $this->db_b->select("gvars.descripcion as tipoprod");
                $this->db_b->from("tran_100k");
                $this->db_b->join('tran_100', 'tran_100.trannum = tran_100k.trannum', 'inner');
                $this->db_b->join('invproducts', 'invproducts.idproducto  = tran_100k.idproducto', 'inner');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
                $this->db_b->join('gvars', 'invproducts.tipo = gvars.valor_num AND gvars.nombre = "gv_protipo"', 'inner');
                $this->db_b->where('tran_100.idcentro', $idcentro);
                $this->db_b->where('tran_100k.idproducto', $idproduct);
                $this->db_b->where('tran_100.fecha >=', $fechaini);
                $this->db_b->where('tran_100.fecha <=', $fechafin);
                $this->db_b->where('(tran_100.estatus = 1 OR tran_100.estatus = 2)');

                $this->db_b->order_by("tran_100.fecha", "ASC");

                $resultado = $this->db_b->get();
                
                if($resultado->num_rows() > 0) {
                    return $resultado->result_array();
                } else  return false;
            }
        }

        function getDatosF142New($idcentro, $idproduct, $fechaini, $fechafin, $offset){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select("tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.idcps, tran_100k.idproducto, inv_def.descrip as descripDoc, invproducts.descrip as descripPro, invproducts.precioventa as precioVentaFicha, tran_100k.cantidad, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario, inv_def.inopera, inv_def.agrupa");
                $this->db_b->from("tran_100k");
                $this->db_b->join('tran_100', 'tran_100.trannum = tran_100k.trannum', 'inner');
                $this->db_b->join('invproducts', 'invproducts.idproducto  = tran_100k.idproducto', 'inner');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
                $this->db_b->where('tran_100.idcentro', $idcentro);
                $this->db_b->where('tran_100k.idproducto', $idproduct);
                $this->db_b->where('tran_100.fecha >=', $fechaini);
                $this->db_b->where('tran_100.fecha <=', $fechafin);
                $this->db_b->where('tran_100.estatus', 1);

                $this->db_b->order_by("tran_100.fecha", "ASC");

                if($offset == 0){
                    $this->db_b->limit(500);
                }else{
                    $this->db_b->limit(500, $offset);
                }

                $resultado = $this->db_b->get();
                
                if($resultado->num_rows() > 0) {
                    return $resultado->result_array();
                } else  return false;
            }
        }

        #   DATOS REPORTE 142 ALL
        function getDatosPreviosAllF142($idcentro, $fechaini){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select("tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.idcps, tran_100k.idproducto, tran_100k.cantidad, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario,invproducts.precioventa as precioVentaFicha, inv_def.inopera, inv_def.agrupa");
                $this->db_b->from("tran_100k");
                $this->db_b->join('tran_100', 'tran_100.trannum = tran_100k.trannum', 'inner');
                $this->db_b->join('invproducts', 'invproducts.idproducto  = tran_100k.idproducto', 'inner');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
                $this->db_b->where('tran_100.idcentro', $idcentro);
                $this->db_b->where('tran_100.fecha <', $fechaini);
                $this->db_b->where('tran_100.estatus', 1);

                $this->db_b->order_by("tran_100.fecha", "ASC");

                $resultado = $this->db_b->get()->result_array();
                return $resultado;
            }
        }
        function getDatosAllF142($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select("tran_100.trannum, tran_100.serie, tran_100.numero, tran_100.fecha, tran_100.idcps, tran_100k.idproducto, inv_def.descrip as descripDoc, invproducts.descrip as descripPro, invproducts.precioventa as precioVentaFicha, tran_100k.cantidad, tran_100k.uniconv, tran_100k.preciotran, tran_100k.costounitario, inv_def.inopera, inv_def.agrupa");
                $this->db_b->from("tran_100k");
                $this->db_b->join('tran_100', 'tran_100.trannum = tran_100k.trannum', 'inner');
                $this->db_b->join('invproducts', 'invproducts.idproducto  = tran_100k.idproducto', 'inner');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
                $this->db_b->where('tran_100.idcentro', $idcentro);
                $this->db_b->where('tran_100.fecha >=', $fechaini);
                $this->db_b->where('tran_100.fecha <=', $fechafin);
                $this->db_b->where('tran_100.estatus', 1);

                $this->db_b->order_by("tran_100.fecha", "ASC");

                $resultado = $this->db_b->get();
                
                if($resultado->num_rows() > 0) {
                    return $resultado->result_array();
                } else  return false;
            }
        }

        //existencias producto especifico
        function getExistenciasProducto($idproducto, $idcentro, $trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('ROUND(SUM(tran_100k.cantidad*tran_100k.uniconv),2) AS cantidad');
                $this->db_b->from("tran_100k");
                $this->db_b->join('invproducts', 'invproducts.idproducto = tran_100k.idproducto', 'inner');
                $this->db_b->where('tran_100k.idproducto', $idproducto);
                $this->db_b->where('tran_100k.idcentro', $idcentro);
                if($trannum != null){
                    $this->db_b->where('tran_100k.trannum !=', $trannum);
                }
                
                $resultado = $this->db_b->get()->row_array();
                return $resultado;
            }           
        }
        
        function getDatosReporteInformeInventario($offset = 0, $limit = 0, $tipo = 0) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('d.descrip AS departamento, c.descrip AS linea, a.idproducto, a.marca, a.modelo, a.descrip, a.um, e.descripcion AS tipo');
                $this->db_b->select('f.idauxi AS codigoProveedor, f.descrip AS proveedor, f.grupo AS grupoProvee, a.precioventa');
                $this->db_b->from('invproducts a');
                $this->db_b->join('inv_batch  b', 'a.idproducto = b.idproducto', 'inner');
                $this->db_b->join('invcatalog c', 'a.idcatalogo = c.idcatalogo', 'inner');
                $this->db_b->join('invcatalog d', 'c.idnivel1   = d.idcatalogo', 'inner');
                $this->db_b->join('ctauxi f', 'a.idprovee = f.idauxi', 'left');
                if ($tipo != 0) {
                    $this->db_b->where('a.tipo', $tipo);
                }
                $this->db_b->join('gvars e', 'a.tipo   = e.valor_num AND e.nombre = "gv_protipo"', 'inner');
                $this->db_b->where('a.estado', 1);
                $this->db_b->order_by('c.descrip', 'ASC');
                $this->db_b->order_by('a.descrip', 'ASC');
                if ($limit != 0) {
                	$this->db_b->limit($limit, $offset);
                }
                
                $resultado = $this->db_b->get()->result();
                return $resultado;
            }
        }
        
        function getDatosReporteInformeInventarioConsigna($idcentro) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('b.idcps, f.descrip AS namesucursal, e.descrip AS namedepartamento, d.descrip AS namelinea, c.idproducto, c.modelo, c.descrip AS nameproducto, g.descrip AS namecliente, b.idcps_branch');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('tran_100 b', 'b.trannum = a.trannum', 'inner');
                $this->db_b->join('invproducts c', 'a.idproducto = c.idproducto', 'inner');
                $this->db_b->join('invcatalog d', 'c.idcatalogo = d.idcatalogo', 'inner');
                $this->db_b->join('invcatalog e', 'd.idnivel1   = e.idcatalogo', 'inner');
                $this->db_b->join('invsites f', 'f.idcentro = b.idcentro', 'inner');
                $this->db_b->join('ctauxi g', 'b.idcps = g.idauxi', 'inner');
                $this->db_b->where('c.tipo', 1);
                $this->db_b->where('g.idauxidef', 2);
                $this->db_b->where('f.idcentro', $idcentro);
                $this->db_b->group_by(array('a.idproducto', 'g.descrip'));
                $this->db_b->order_by('c.descrip', 'ASC');

                $resultado = $this->db_b->get()->result();
                return $resultado;
            }
        }
        
        function getTotalRegistrosInformeInventario($tipo = 0) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('a.idproducto');
                $this->db_b->from('invproducts a');
                $this->db_b->join('inv_batch  b', 'a.idproducto = b.idproducto', 'inner');
                $this->db_b->join('invcatalog c', 'a.idcatalogo = c.idcatalogo', 'inner');
                $this->db_b->join('invcatalog d', 'c.idnivel1   = d.idcatalogo', 'inner');
                $this->db_b->join('gvars e', 'a.tipo = e.valor_num AND e.nombre = "gv_protipo"', 'inner');
                if ($tipo != 0) {
                    $this->db_b->where('a.tipo', $tipo);
                }
                $this->db_b->where('a.estado', 1);
                
                $resultado = $this->db_b->get()->num_rows();
                return $resultado;
            }
        }

        function getSaldoInicialInformeIN($idproducto, $idcentro, $fechaini) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS saldo_inicial');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha <', $fechaini);
                $this->db_b->where_in('b.estatus', array(1, 2, 3));
                
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->saldo_inicial;
                }
            }
        }

        function getEntradasInformeIN($idproducto, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND (c.inopera = 1)', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }
        
        function getSalidasInformeIN($idproducto, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                // $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "VN"', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND (c.inopera = -1)', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }

        function getEntradasCOInformeIN($idproducto, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "CO"', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where_in('b.estatus', array(1, 2, 3));
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }
        
        function getEntraSalINInformeIN($idproducto, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS cantidad');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "IN"', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where_in('b.estatus', array(1, 2, 3));
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->cantidad;
                }
            }
        }

        function getSalidasVNInformeIN($idproducto, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "VN"', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where_in('b.estatus', array(1, 2, 3));
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }

        function getCostoUnitarioInformeIN($idproducto, $idcentro, $fecha_fin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0) , 0, IFNULL((SUM( IF(b.agrupa = "CO" AND b.inopera = 1, a.preciotran, a.costounitario) * (a.cantidad * a.uniconv)) / SUM(a.cantidad * a.uniconv)), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha <=', $fecha_fin);
                $this->db_b->where_in('c.estatus', array(1, 2, 3));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }
        
        function getCostoUnitarioCOInformeIN($idproducto, $idcentro, $fecha_ini, $fecha_fin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0), 0, IFNULL((SUM(a.preciotran * (a.cantidad * a.uniconv))), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase AND b.agrupa = "CO"', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha BETWEEN "'.$fecha_ini.'" AND "'.$fecha_fin.'"');
                $this->db_b->where_in('c.estatus', array(1));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }

        function getCostoUnitarioINInformeIN($idproducto, $idcentro, $fecha_ini, $fecha_fin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0) , 0, IFNULL((SUM(a.costounitario * (a.cantidad * a.uniconv))), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase AND b.agrupa = "IN"', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha BETWEEN "'.$fecha_ini.'" AND "'.$fecha_fin.'"');
                $this->db_b->where_in('c.estatus', array(1, 2, 3));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }
        
        function getCostoUnitarioVNInformeIN($idproducto, $idcentro, $fecha_ini, $fecha_fin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0) , 0, IFNULL((SUM(a.costounitario * (a.cantidad * a.uniconv))), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase AND b.agrupa = "VN"', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha BETWEEN "'.$fecha_ini.'" AND "'.$fecha_fin.'"');
                $this->db_b->where_in('c.estatus', array(1));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }
        
        function getCostoUnitarioIniInformeIN($idproducto, $idcentro, $fecha_fin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0) , 0, IFNULL((SUM( IF(b.agrupa = "CO" AND b.inopera = 1, a.preciotran, a.costounitario) * (a.cantidad * a.uniconv))), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha <', $fecha_fin);
                $this->db_b->where_in('c.estatus', array(1, 2, 3));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }

        function getSaldoFinalInformeIN($idproducto, $idcentro, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS saldo_final');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha <=', $fechafin);
                $this->db_b->where_in('b.estatus', array(1, 2, 3));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->saldo_final;
                }
            }
        }

        function getValorTotalInformeIN($idproducto, $idcentro, $fechafin) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0), 0, IFNULL(SUM((a.cantidad * a.uniconv) *  IF(b.agrupa = "CO" AND b.inopera = 1, a.preciotran, a.costounitario)), 0)) AS valor');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                if ($idcentro != 0 ) $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha <=', $fechafin);
                $this->db_b->where_in('c.estatus', array(1, 2, 3));

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->valor;
                }
            }
        }

        // Consignaciones
        function getSaldoInicialInformeINCon($idproducto, $idcps, $idcentro, $fechaini, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS saldo_inicial');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.idcps', $idcps);
                $this->db_b->where('b.idcps_branch', $idcps_branch);
                $this->db_b->where('b.fecha <', $fechaini);
                
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->saldo_inicial;
                }
            }
        }

        function getEntradasInformeINCon($idproducto, $idcps, $idcentro, $fechaini, $fechafin, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                // $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "CO"', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND (c.inopera = 1)', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcps', $idcps);
                $this->db_b->where('b.idcps_branch', $idcps_branch);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');
                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }

        function getSalidasInformeINCon($idproducto, $idcps, $idcentro, $fechaini, $fechafin, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS entradas');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                // $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND c.agrupa = "VN"', 'inner');
                $this->db_b->join('inv_def   c', 'b.idclase = c.invclase AND (c.inopera = -1)', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcps', $idcps);
                $this->db_b->where('b.idcps_branch', $idcps_branch);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha BETWEEN "'.$fechaini.'" AND "'.$fechafin.'"');

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->entradas;
                }
            }
        }

        function getCostoUnitarioInformeINCon($idproducto, $idcps, $idcentro, $fecha_fin, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0) , 0, IFNULL((SUM( IF(b.agrupa = "CO" AND b.inopera = 1, a.preciotran, a.costounitario) * (a.cantidad * a.uniconv)) / SUM(a.cantidad * a.uniconv)), 0)) AS costo');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('c.idcps', $idcps);
                $this->db_b->where('c.idcps_branch', $idcps_branch);
                $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha <=', $fecha_fin);

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->costo;
                }
            }
        }

        function getSaldoFinalInformeINCon($idproducto, $idcps, $idcentro, $fechafin, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IFNULL(SUM(a.cantidad * a.uniconv), 0) AS saldo_final');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.idcps', $idcps);
                $this->db_b->where('b.idcps_branch', $idcps_branch);
                $this->db_b->where('b.idcentro', $idcentro);
                $this->db_b->where('b.fecha <=', $fechafin);

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->saldo_final;
                }
            }
        }

        function getValorTotalInformeINCon($idproducto, $idcps, $idcentro, $fechafin, $idcps_branch) {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('IF((SUM(a.cantidad * a.uniconv) = 0), 0, IFNULL(SUM((a.cantidad * a.uniconv) *  IF(b.agrupa = "CO" AND b.inopera = 1, a.preciotran, a.costounitario)), 0)) AS valor');
                $this->db_b->from("tran_100k a");
                $this->db_b->join('inv_def  b', 'a.idclase = b.invclase', 'inner');
                $this->db_b->join('tran_100 c', 'a.trannum = c.trannum', 'inner');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('c.idcps', $idcps);
                $this->db_b->where('c.idcps_branch', $idcps_branch);
                $this->db_b->where('c.idcentro', $idcentro);
                $this->db_b->where('c.fecha <=', $fechafin);

                $info = $this->db_b->get();

                if($info->num_rows() == 0){
                    return 0;
                } else {
                    return $info->row()->valor;
                }
            }
        }
    }
?>