<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');	
    require 'vendor/autoload.php';
            
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    class Gerencia_model extends CI_Model{
    	
        #private $db_b;//
       
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
            date_default_timezone_set('America/El_Salvador');
        }
        #   MULIT OPCIONES
        public function multiOpciones($opc, $extra = null)
        {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            } else {
                switch ($opc) {
                    case -1:#	GET USUARIOS
                        $where = [
                            '(a.estado = '.$extra.')',
                            '(a.iduser != 1)',
                            '(a.username != "soporte.goxpos")'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('a.iduser, a.descrip, a.issuedate as fi, a.duedate as ff, a.lastlogin as last');
                        $this->db_b->select('a.username, a.idcps, a.derechos, a.correo1, a.notas, a.imagen, a.profile');
                        $this->db_b->select('a.estado, a.idcentro, a.idcaja, b.descrip as caja, c.descrip as sucursal');
                        $this->db_b->from('gusers a');
                        $this->db_b->join('ctcajas b', 'a.idcaja = b.idcaja', 'left');
                        $this->db_b->join('invsites c', 'a.idcentro = c.idcentro');
                        $this->db_b->where($where);
                        $this->db_b->order_by('descrip', 'ASC');
                        $datos = $this->db_b->get();
                    break;
                    case 1:#   GET PERFILES
                        $where = [
                            '(nombre = "gv_profile")'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('valor_num, descripcion');
                        $this->db_b->from('gvars');
                        $this->db_b->where($where);
                        $this->db_b->order_by('descripcion', 'ASC');
                        $datos = $this->db_b->get();
                    break;
                    case 2:#   GET EMPLEADOS
                        $where = [
                            '(idauxidef = 3)',
                            '(estado = 1)'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('idauxi, descrip, correo');
                        $this->db_b->from('ctauxi');
                        $this->db_b->where($where);
                        $this->db_b->order_by('descrip', 'ASC');
                        $datos = $this->db_b->get();
                    break;
                    case 3:#   GET SUCURSALES / CAJAS
                        /*$this->db_b->select('a.idcaja, a.descrip, a.idcentro, b.descrip as sucursal');
                        $this->db_b->from('ctcajas a');
                        $this->db_b->join('invsites b', 'a.idcentro = b.idcentro');
                        $this->db_b->order_by('b.descrip', 'ASC');
                        $this->db_b->order_by('a.descrip', 'ASC');
                        $datos = $this->db_b->get();//*/
                        $where = implode(' AND ', ['(a.estatus = 1)']);
                        $wherej = implode(' AND ', [
                            '(a.idcentro = b.idcentro)', '(b.estatus = 1)'
                        ]);
                        $order = implode(', ', [
                            'a.descrip ASC', 'b.descrip ASC'
                        ]);
                        $this->db_b->select('b.idcaja, IFNULL(b.descrip, "--Sin Caja--") as descrip, a.idcentro, a.descrip as sucursal');
                        $this->db_b->from('invsites a');
                        $this->db_b->join('ctcajas b', $wherej, 'left');
                        $this->db_b->where($where);
                        $this->db_b->order_by($order);
                        $datos = $this->db_b->get();
                    break;
                    case 4:#   GET APLICACIONES
                        $order = [
                            'b.valor_num ASC',
                            'a.menuname ASC',
                            'a.menuorder ASC',
                        ];
                        $order = implode(', ', $order);
                        $where = [
                            '(a.estado = 1)',
                            '(b.nombre = "g_menumain")'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('a.idapp, a.descrip, b.descripcion as menu');
                        $this->db_b->from('gapps a');
                        $this->db_b->join('gvars b', 'a.menuname = b.descripcion');
                        $this->db_b->where($where);
                        $this->db_b->order_by($order);
                        $datos = $this->db_b->get();
                    break;
                    case 5:#   GET CONTEO DE USUARIOS
                        $this->db_b->select('iduser');
                        $this->db_b->from('gusers');
                        $datos = $this->db_b->get()->num_rows();
                    break;
                    case 6:#   VALIDACION DE NOMBRE DE IMAGEN
                        $where = [
                            '(imagen = "'.$extra.'")'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('iduser');
                        $this->db_b->from('gusers');
                        $this->db_b->where($where);
                        $data = $this->db_b->get();
                        if ($data->num_rows() > 0) $datos = false;
                        else $datos = true;
                    break;
                    case 7:#   SET USUARIO
                        if ($this->db_b->insert('gusers', $extra)) $datos = $this->db_b->insert_id();
                        else $datos = false;
                    break;
                    case 8:#   GET USUARIO
                        $datos = $this->db_b->where("iduser", $extra)->get("gusers")->row();
                    break;
                    case 9:#   UPDATE USUARIO
                        $this->db_b->where('iduser', $extra['ID']);
                        if ($this->db_b->update('gusers', $extra['data'])) $datos = true;
                        else $datos = false;
                    break;
                    case 10:#   SET PERMISO
                        if ($this->db_b->insert('grights', $extra)) $datos = $this->db_b->insert_id();
                        else $datos = false;
                    break;
                    case 11:#   DELETE PERMISO
                        $this->db_b->where('iduser', $extra);
                        $this->db_b->delete('grights');
                        $datos = true;
                    break;
                    case 12:#   GET APPS DE USER
                        $where = [
                            '(idapp != 0)',
                            '(iduser = '.$extra.')'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('*');
                        $this->db_b->from('grights');
                        $this->db_b->where($where);
                        $datos = $this->db_b->get();
                    break;
                    case 12.5:#   EXISTE COLUMNA PERMISO
                        $datos = $this->db_b->field_exists('permisos', 'grights');
                    break;
                    #   HORARIOS
                    case 13:#   VERIFICAR PERFIELS
                        $where = implode(' AND ', ['(a.nombre = "gv_profile")']);
                        $this->db_b->select('a.valor_num, b.idrec');
                        $this->db_b->from('gvars a');
                        $this->db_b->join('gschedules b', 'a.valor_num = b.profile', 'left');
                        $this->db_b->where($where);
                        $datos = $this->db_b->get();
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                if ($dato->idrec == null) {
                                    $data = array(
                                        'dow1' => '00:00 00:00',
                                        'dow2' => '00:00 00:00',
                                        'dow3' => '00:00 00:00',
                                        'dow4' => '00:00 00:00',
                                        'dow5' => '00:00 00:00',
                                        'dow6' => '00:00 00:00',
                                        'dow7' => '00:00 00:00',
                                        'profile' => (int)$dato->valor_num,
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                    $this->multiOpciones(15, $data);
                                }
                            }
                        }
                        $where = implode(' AND ', ['(b.nombre = "gv_profile")']);
                        $this->db_b->select('a.*, b.descripcion as perfil, b.valor_memo as memo, b.filtro');
                        $this->db_b->from('gschedules a');
                        $this->db_b->join('gvars b', 'a.profile = b.valor_num');
                        $this->db_b->where($where);
                        $datos = $this->db_b->get();
                    break;
                    case 14:#   GET SUCURSALES
                        $where = implode(' AND ', ['(estatus = 1)']);
                        $this->db_b->select('idcentro, descrip');
                        $this->db_b->from('invsites');
                        $this->db_b->where($where);
                        $this->db_b->order_by('descrip ASC');
                        $datos = $this->db_b->get();
                    break;
                    case 15:#   SET    HORARIO
                        if ($this->db_b->insert('gschedules', $extra)) $datos = $this->db_b->insert_id();
                        else $datos = false;
                    break;
                    case 16:#   UPDATE    HORARIO
                        $this->db_b->where('idrec', $extra['ID']);
                        if ($this->db_b->update('gschedules', $extra['data'])) $datos = true;
                        else $datos = false;
                    break;
                    case 17:#   GET VARIABLE
                        $datos = $this->db_b->where($extra['where'])->get("gvars")->row();
                    break;
                    case 18:#   UPDATE    VARIABLE
                        $this->db_b->where($extra['where']);
                        if ($this->db_b->update('gvars', $extra['data'])) $datos = true;
                        else $datos = false;
                    break;
                    default:$datos = false;break;
                }
                return $datos;
            }
        }
		
		function getUsuariosFiltrados($estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT gusers.iduser, gusers.profile, gusers.descrip, gusers.issuedate, gusers.duedate, gusers.lastlogin, invsites.descrip AS nameSucursal, ctcajas.descrip AS nameCaja FROM gusers LEFT JOIN invsites ON gusers.idcentro = invsites.idcentro LEFT JOIN ctcajas ON gusers.idcaja = ctcajas.idcaja WHERE gusers.estado = $estado AND gusers.iduser != 1 ORDER BY gusers.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getUsuariosServicios($estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT gusers.iduser, gusers.descrip, gusers.issuedate, gusers.duedate, gusers.lastlogin, invsites.descrip AS nameSucursal, ctcajas.descrip AS nameCaja FROM gusers LEFT JOIN invsites ON gusers.idcentro = invsites.idcentro LEFT JOIN ctcajas ON gusers.idcaja = ctcajas.idcaja WHERE gusers.estado = $estado";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
		
		function getListEmpleados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$consulta = "SELECT idauxi, descrip FROM ctauxi WHERE idauxidef = 3 AND estado = 1 ORDER BY descrip ASC";
				$query = $this->db_b->query($consulta);
				$resultado = $query->result();
				return $resultado;
			}
		}
		
		function insertUser($empleado,$menug,$perfil,$descrip,$sucursal,$cajas,$derecho,$usuario,$contra,$correo,$alterno,$telefonos,$estado,$notas,$img,$idaccount,$issuedate,$duedate){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $crfPass = $contra;
                $crf = '$EgGa8466-2$/';
                $newPass = md5($crf . $crfPass);
                
                $this->db_b->set('iduser',0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('username', $usuario);
                $this->db_b->set('password', $newPass);
                $this->db_b->set('menug', $menug);
                $this->db_b->set('idaccount', $idaccount);
                $this->db_b->set('idcps', $empleado);
                $this->db_b->set('issuedate', $issuedate);
                $this->db_b->set('duedate', $duedate);
                $this->db_b->set('profile', $perfil);
                $this->db_b->set('derechos', $derecho);
                $this->db_b->set('idcentro', $sucursal);
                $this->db_b->set('idcaja', $cajas);
                $this->db_b->set('telefonos', $telefonos);
                $this->db_b->set('correo1', $correo);
                $this->db_b->set('correo2', $alterno);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('gusers');
                
				if($img == "" || $img == null){
					redirect('Usuarios/'.$this->session->userdata('iddApp'));
                }else{
					$iduser = $this->db_b->insert_id();
                    $imgSplit = explode(".", $img);
                    $nameImg = "imgUser_".$iduser.".".$imgSplit[1];
                    $this->db_b->set('imagen', $nameImg);
                    $this->db_b->where('iduser', $iduser);
                    $this->db_b->update('gusers');
                    return $nameImg;
                }
			}
		}
		
		function updateUser($id,$menug,$perfil,$descrip,$sucursal,$cajas,$derecho,$usuario,$correo,$alterno,$telefonos,$estado,$notas,$img, $imagen, $imga,$idaccount,$issuedate,$duedate,$empleado,$listapermisos){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('username', $usuario);
                $this->db_b->set('menug', $menug);
                $this->db_b->set('idaccount', $idaccount);
                $this->db_b->set('issuedate', $issuedate);
                $this->db_b->set('duedate', $duedate);
                $this->db_b->set('profile', $perfil);
                $this->db_b->set('derechos', $derecho);
                $this->db_b->set('idcps', $empleado);
                $this->db_b->set('idcentro', $sucursal);
                $this->db_b->set('idcaja', $cajas);
                $this->db_b->set('telefonos', $telefonos);
                $this->db_b->set('correo1', $correo);
                $this->db_b->set('correo2', $alterno);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->where('iduser', $id);
                $query = $this->db_b->update('gusers');
                
				$arrayApps = explode(",", $listapermisos);
                $totRig = count($arrayApps);
                $totReal = $totRig-1;
                $consulta3 = "DELETE FROM grights WHERE iduser = $id";
                $query3 = $this->db_b->query($consulta3);
                
				for($i=0; $i<$totReal; $i++){
                    if($arrayApps[$i]!=""){
                        $this->db_b->set('idrnum', 0);
                        $this->db_b->set('iduser', $id);
                        $this->db_b->set('idapp', $arrayApps[$i]);
                        $this->db_b->set('issuedate', $fecha_actual);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('estado', 1);
                        $this->db_b->set('ingresa', $fecha_actual);
                        $this->db_b->insert('grights');
                    } 
                }
				
                if($img == "" || $img == null){
                    redirect('Usuarios/'.$this->session->userdata('iddApp'));
                }else{
                    if($imga != "" ){
                        $imgSplit = explode(".", $img);
                        $nameImg = "imgUser_".$id."_".rand(0, 99999).".".$imgSplit[1];
                        $this->db_b->set('imagen', $nameImg);
                        $this->db_b->where('iduser', $id);
                        $this->db_b->update('gusers');
						return $nameImg;
                    }else{
                        $this->db_b->set('imagen', $img);
                        $this->db_b->where('iduser', $id);
                        $this->db_b->update('gusers');
                        return $img;
                    }
                }
            }
		}
        
        function getSchedules(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $consulta = "SELECT ROUND(valor_num) AS valor_num, descripcion, idrnum FROM gvars WHERE nombre = 'gv_profile'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                foreach($resultado as $perf){
                    $valor = $perf->valor_num;
                    $consulta = "SELECT idrec FROM gschedules WHERE gschedules.profile = $valor";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() == 0){
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('dow1', '00:00 00:00');
                        $this->db_b->set('dow2', '00:00 00:00');
                        $this->db_b->set('dow3', '00:00 00:00');
                        $this->db_b->set('dow4', '00:00 00:00');
                        $this->db_b->set('dow5', '00:00 00:00');
                        $this->db_b->set('dow6', '00:00 00:00');
                        $this->db_b->set('dow7', '00:00 00:00');
                        $this->db_b->set('profile', $valor);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $this->db_b->insert('gschedules');
                    }
                }
                $consulta = "SELECT gschedules.*, gvars.descripcion as tipoPerfil FROM gschedules INNER JOIN gvars ON ROUND(gvars.valor_num)= ROUND(gschedules.profile) AND  gvars.nombre='gv_profile'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getSchedulesInfo($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $consulta = "SELECT gschedules.*, gvars.descripcion as tipoPerfil, gvars.valor_memo, gvars.filtro FROM gschedules INNER JOIN gvars ON ROUND(gvars.valor_num) = ROUND(gschedules.profile) AND gvars.nombre='gv_profile' WHERE gschedules.idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getTipoPerfilSchedule($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $consulta = "SELECT gvars.descripcion as tipoPerfil FROM gschedules INNER JOIN gvars ON ROUND(gvars.valor_num)= ROUND(gschedules.profile) AND  gvars.nombre='gv_profile' WHERE gschedules.idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['tipoPerfil'];
            }
        }
        
        function saveSchedule($idrec,$domingo,$lunes,$martes,$miercoles,$jueves,$viernes,$sabado,$sucursales,$permisoVentas,$permisoResumen){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('dow1', $domingo);
                $this->db_b->set('dow2', $lunes);
                $this->db_b->set('dow3', $martes);
                $this->db_b->set('dow4', $miercoles);
                $this->db_b->set('dow5', $jueves);
                $this->db_b->set('dow6', $viernes);
                $this->db_b->set('dow7', $sabado);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrec', $idrec);
                $this->db_b->update('gschedules');

                $consulta = "SELECT gschedules.profile, gvars.filtro FROM gschedules INNER JOIN gvars ON gvars.valor_num = gschedules.profile AND gvars.nombre = 'gv_profile' WHERE gschedules.idrec = $idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();

                $cadenaPermisos = $resultado['filtro'];
                $txtPermiso   = 'no_mostrar_totales';
                $txtResumen   = 'mostrar_resumen';
                
                $findPermiso1 = strpos($cadenaPermisos, $txtPermiso);
                if($findPermiso1 === false){
                    if($cadenaPermisos == ""){
                        $cadenaPermisos = "(no_mostrar_totales:$permisoVentas)";
                    }else{
                        $cadenaPermisos = $cadenaPermisos.","."(no_mostrar_totales:$permisoVentas)";
                    }
                }else{
                    $valorCadenas = array("(no_mostrar_totales:0)", "(no_mostrar_totales:1)");
                    $cadenaPermisos = str_replace($valorCadenas, "(no_mostrar_totales:$permisoVentas)", $cadenaPermisos);
                }

                $findResumen = strpos($cadenaPermisos, $txtResumen);
                if($findResumen === false){
                    if($cadenaPermisos == ""){
                        $cadenaPermisos = "(mostrar_resumen:$permisoResumen)";
                    }else{
                        $cadenaPermisos = $cadenaPermisos.","."(mostrar_resumen:$permisoResumen)";
                    }
                }else{
                    $valorCadenas = array("(mostrar_resumen:0)", "(mostrar_resumen:1)");
                    $cadenaPermisos = str_replace($valorCadenas, "(mostrar_resumen:$permisoResumen)", $cadenaPermisos);
                }

                $this->db_b->set('filtro', $cadenaPermisos);
                $this->db_b->set('valor_memo', $sucursales);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('nombre', 'gv_profile');
                $this->db_b->where('valor_num', $resultado['profile']);
                $this->db_b->update('gvars');

                return $idrec;
            }
        }
        
        function validateIngresoDeFacturas($documentTemp, $nameDocument){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                //require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                //require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				//$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				//$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				//PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                //$objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
                $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load($documentTemp);
                $objPHPExcel->setActiveSheetIndex(0);
                $numRows = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                
                $j=0;
                $totalErrores = 0;
                $dataSource = array();
                
                $idcen_ant = ''; $idcaj_ant = ''; $idcla_ant = ''; $serie_ant = ''; $numer_ant = ''; $header = 0; $ventaTotal = 0;
				
                for($i=2; $i<=$numRows; $i++){
					$idcentro = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $idcaja = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $idclase = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $cajclase = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $serie = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $numero = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    
					$cellFecha = $objPHPExcel->getActiveSheet()->getCell('G'.$i);
					$fecha_vn = $cellFecha->getValue();
					$format = 'Y-m-d';
                    
					if(\PhpOffice\PhpSpreadsheet\Shared\Date::isDateTime($cellFecha)){
						$fecha_vn = date($format, \PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($fecha_vn));
						$fecha_vn = strtotime ('+1 day', strtotime($fecha_vn));
						$fecha_vn = date('Y-m-j', $fecha_vn);
					}
                    
					$idproducto = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $nameProducto = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $idworker = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $idcps = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $preciotran = str_replace(',', '', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
                    $cantidad =   str_replace(',', '', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());


                    $uniconv = $objPHPExcel->getActiveSheet()->getCell('O'.$i)->getCalculatedValue();
                    $tax1 = $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue();
                    
                    $SQLValidateT100 = "SELECT trannum FROM tran_100 WHERE idcentro = $idcentro AND idcaja = $idcaja AND serie = '$serie' AND numero = '$numero'";
                    $QueryValidateT100 = $this->db_b->query($SQLValidateT100);
                    
                    if($QueryValidateT100->num_rows() > 0){
                        $infoTran = $QueryValidateT100->row_array();
                        $id_trannum = $infoTran['trannum'];
                        $validateTran = 1;
                        $totalErrores++;
                    }else{
                        $id_trannum = '';
                        $validateTran = 0;
                    }
                    
                    $SQLProducto = "SELECT idproducto, um, tipo, costounitario FROM invproducts WHERE idproducto = $idproducto";
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    
                    if($QueryProducto->num_rows() > 0){
						$infoProducto = $QueryProducto->row_array();
                        $umProducto = $infoProducto['um'];
                        $tipoProducto = $infoProducto['tipo'];
                        $costounitario = $infoProducto['costounitario'];
						$validateProducto = 1;
                    }else{
                        $totalErrores++;
                        $umProducto = '';
                        $tipoProducto = '';
                        $validateProducto = 0;
                    }
                    
                    if($tipoProducto != 4){
                        $SQLValidateBatch = "SELECT idbatch, descrip, costounitario FROM inv_batch WHERE idproducto = $idproducto";
                        $QueryValidateBatch = $this->db_b->query($SQLValidateBatch);
                        
                        if($QueryValidateBatch->num_rows() > 0){
                            $infoBatch = $QueryValidateBatch->row_array();
                            $idbatch = $infoBatch['idbatch'];
                            $nameLote = $infoBatch['descrip'];
                            $costounitario = $infoBatch['costounitario'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            
                            $idbatch = '';
                            $costounitario = '';
                            $nameLote = '';
                            $validateBatch = 0;
                        }
                        
                        $SQLValidateBin = "SELECT idbin, descrip FROM invlocations WHERE idcentro = $idcentro";
                        $QueryValidateBin = $this->db_b->query($SQLValidateBin);
                        
                        if($QueryValidateBin->num_rows() > 0){
                            $infoBin = $QueryValidateBin->row_array();
                            $idbin = $infoBin['idbin'];
                            $nameUbicacion = $infoBin['descrip'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            $idbin = '';
                            $nameUbicacion = '';
                            $validateBatch = 0;
                        }
                    }else{
                        $SQLValidateBatch = "SELECT idbin, descrip FROM invlocations WHERE idcentro = $idcentro";
                        $QueryValidateBatch = $this->db_b->query($SQLValidateBatch);
                        
                        if($QueryValidateBatch->num_rows() > 0){
                            $infoBatch = $QueryValidateBatch->row_array();
                            $idbatch = 9999;
                            $idbin = $infoBatch['idbin'];
                            $nameLote = '';
                            $nameUbicacion = $infoBatch['descrip'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            
                            $idbatch = '';
                            $idbin = '';
                            $costounitario = '';
                            $nameLote = '';
                            $nameUbicacion = '';
                            $validateBatch = 0;
                        }
                    }
                    
                    $SQLValidateCliente = "SELECT descrip, nrc, dias FROM ctauxi WHERE idauxi = $idcps";
                    $QueryValidateCliente = $this->db_b->query($SQLValidateCliente);
                    
                    if($QueryValidateCliente->num_rows() > 0){
                        $infoCliente = $QueryValidateCliente->row_array();
                        $nameCliente = $infoCliente['descrip'];
                        $dias = $infoCliente['dias'];
                        $nrc = $infoCliente['nrc'];
                        $validateCliente = 1;
                    }else{
                        $totalErrores++;
                        
                        $nameCliente = '';
						$dias = '';
						$nrc = '';
                        $validateCliente = 0;
                    }
                    
                    $SQLValidateVendedor = "SELECT descrip FROM ctauxi WHERE idauxi = $idworker";
                    $QueryValidateVendedor = $this->db_b->query($SQLValidateVendedor);
                    
                    if($QueryValidateVendedor->num_rows() > 0){
                        $infoVendedor = $QueryValidateVendedor->row_array();
                        $nameVendedor = $infoVendedor['descrip'];
                        $validateVendedor = 1;
                    }else{
                        $totalErrores++;
                        
                        $nameVendedor = '';
                        $validateVendedor = 0;
                    }
                    
                    $SQLValidateClase = "SELECT descrip FROM inv_def WHERE invclase = $idclase";
                    $QueryValidateClase = $this->db_b->query($SQLValidateClase);
                    
                    if($QueryValidateClase->num_rows() > 0){
                        $infoVendedor = $QueryValidateClase->row_array();
                        $tipoDocumento = $infoVendedor['descrip'];
                        $validateClase = 1;
                    }else{
                        $totalErrores++;
                        
						$tipoDocumento = '';
                        $validateClase = 0;
                    }
                    
                    if($idcen_ant == $idcentro && $idcaj_ant == $idcaja && $idcla_ant == $idclase && $serie_ant == $serie && $numer_ant == $numero){
						$totalPro = $cantidad * $preciotran;
						$preciotran = $preciotran * 1;
						
						$detailProducto[$k] = array(
							"itemline" => $k + 1,
							"idproducto" => $idproducto,
							"idbin" => $idbin,
							"idbatch" => $idbatch,
							"descrip" => $nameProducto,
							"um" => $umProducto,
							"uniconv" => $uniconv,
							"idworker" => $idworker,
							"ubicacion" => $nameUbicacion,
							"lote" => $nameLote,
							"cantidad" => $cantidad,
							"precio" => $preciotran,
							"costounitario" => $costounitario,
							"tax1" => $tax1,
							"total" => $totalPro,
							"lineaxls" => $i,
							"validateProducto" => $validateProducto,
							"validateBatch" => $validateBatch
						);
						$k++;
						
						$ventaTotal = $ventaTotal + ($cantidad * $preciotran);
						
						$id_trannum_ant = $id_trannum;
						$serie_ant = $serie;
						$numero_ant = $numero;
						$fecha_vn_ant = $fecha_vn;
						$tipoDocumento_ant = $tipoDocumento;
						$nameCliente_ant = $nameCliente;
						$idcps_ant = $idcps;
						$idworker_ant = $idworker;
						$dias_ant = $dias;
						$nrc_ant = $nrc;
						$nameVendedor_ant = $nameVendedor;
						$validateTran_ant = $validateTran;
						$validateCliente_ant = $validateCliente;
						$validateVendedor_ant = $validateVendedor;
						$validateClase_ant = $validateClase;
						
					}else{
						if($header == 1){
							$dataSource[$j] = array(
								"trannum" => $id_trannum_ant,
								"serie_numero" => $serie_ant.''.$numero_ant,
								"fecha" => $fecha_vn_ant,
								"idcentro" => $idcen_ant,
								"idcaja" => $idcaj_ant,
								"idclase" => $idcla_ant,
								"cajclase" => $cajcl_ant,
								"serie" => $serie_ant,
								"numero" => $numer_ant,
								"idcps" => $idcps_ant,
								"idworker" => $idworker_ant,
								"tipodocumento" => $tipoDocumento_ant,
								"namecliente" => $nameCliente_ant,
								"dias" => $dias_ant,
								"nrc" => $nrc_ant,
								"namevendedor" => $nameVendedor_ant,
								"estatus" => 1,
								"total" => $ventaTotal,
								"notas" => $nameDocument,
								"validateTran" => $validateTran_ant,
								"validateCliente" => $validateCliente_ant,
								"validateVendedor" => $validateVendedor_ant,
								"validateClase" => $validateClase_ant,
								"detailFacturas" => $detailProducto
							);
							
							$j++;
							$header = 0;
							$ventaTotal = 0;
						}
						
						$k=0;
						$detailProducto = array();
						
                        $totalPro = $cantidad * $preciotran;
						$preciotran = $preciotran * 1;
						
						$detailProducto[$k] = array(
							"itemline" => $k + 1,
							"idproducto" => $idproducto,
							"idbin" => $idbin,
							"idbatch" => $idbatch,
							"descrip" => $nameProducto,
							"um" => $umProducto,
							"uniconv" => $uniconv,
							"idworker" => $idworker,
							"ubicacion" => $nameUbicacion,
							"lote" => $nameLote,
							"cantidad" => $cantidad,
							"precio" => $preciotran,
							"costounitario" => $costounitario,
							"tax1" => $tax1,
							"total" => $totalPro,
							"lineaxls" => $i,
							"validateProducto" => $validateProducto,
							"validateBatch" => $validateBatch
						);
						$k++;
						
						$ventaTotal = $ventaTotal + ($cantidad * $preciotran);
						$header = 1;
						
						$id_trannum_ant = $id_trannum;
						$serie_ant = $serie;
						$numero_ant = $numero;
						$fecha_vn_ant = $fecha_vn;
						$tipoDocumento_ant = $tipoDocumento;
						$nameCliente_ant = $nameCliente;
						$idcps_ant = $idcps;
						$idworker_ant = $idworker;
						$dias_ant = $dias;
						$nrc_ant = $nrc;
						$nameVendedor_ant = $nameVendedor;
						$validateTran_ant = $validateTran;
						$validateCliente_ant = $validateCliente;
						$validateVendedor_ant = $validateVendedor;
						$validateClase_ant = $validateClase;
						
						$idcen_ant = $idcentro;
						$idcaj_ant = $idcaja;
						$idcla_ant = $idclase;
						$cajcl_ant = $cajclase;
						$serie_ant = $serie;
						$numer_ant = $numero;
					}
                }
				
				if($header == 1){
					$dataSource[$j] = array(
						"trannum" => $id_trannum_ant,
						"serie_numero" => $serie_ant.''.$numero_ant,
						"fecha" => $fecha_vn_ant,
						"idcentro" => $idcen_ant,
						"idcaja" => $idcaj_ant,
						"idclase" => $idcla_ant,
						"cajclase" => $cajcl_ant,
						"serie" => $serie_ant,
						"numero" => $numer_ant,
						"idcps" => $idcps_ant,
						"idworker" => $idworker_ant,
						"tipodocumento" => $tipoDocumento_ant,
						"namecliente" => $nameCliente_ant,
						"dias" => $dias_ant,
						"nrc" => $nrc_ant,
						"namevendedor" => $nameVendedor_ant,
						"estatus" => 1,
						"total" => $ventaTotal,
						"notas" => $nameDocument,
						"validateTran" => $validateTran_ant,
						"validateCliente" => $validateCliente_ant,
						"validateVendedor" => $validateVendedor_ant,
						"validateClase" => $validateClase_ant,
						"detailFacturas" => $detailProducto
					);
				}
				
				return $dataSource;
            }
        }
		
		function insertRegistrosDeFacturas($documentTemp, $nameDocument){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                //require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                //require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				//$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				//$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				//PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                //$objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
                $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load($documentTemp);
                $objPHPExcel->setActiveSheetIndex(0);
                $numRows = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                
                $j=0;
                $dataSource = array();
                
                $idcen_ant = ''; $idcaj_ant = ''; $idcla_ant = ''; $serie_ant = ''; $numer_ant = ''; $ventaTotal = 0; $ivaTotal = 0; $header = 0;
				$totalErrores = 0;
                for($i=2; $i<=$numRows; $i++){
					$idcentro = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $idcaja = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $idclase = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $cajclase = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $serie = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $numero = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    
					$cellFecha = $objPHPExcel->getActiveSheet()->getCell('G'.$i);
					$fecha_vn = $cellFecha->getValue();
					$format = 'Y-m-d';
					
                    /*
					if(PHPExcel_Shared_Date::isDateTime($cellFecha)){
						$fecha_vn = date($format, PHPExcel_Shared_Date::ExcelToPHP($fecha_vn));
						$fecha_vn = strtotime ('+1 day', strtotime($fecha_vn));
						$fecha_vn = date('Y-m-j', $fecha_vn);
					}
                    */
                    if(\PhpOffice\PhpSpreadsheet\Shared\Date::isDateTime($cellFecha)){
						$fecha_vn = date($format, \PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($fecha_vn));
						$fecha_vn = strtotime ('+1 day', strtotime($fecha_vn));
						$fecha_vn = date('Y-m-j', $fecha_vn);
					}
                    
					$idproducto = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $nameProducto = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $idworker = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $idcps = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $preciotran = str_replace(',', '', $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue());
                    $cantidad =   str_replace(',', '', $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue());
                    $uniconv = $objPHPExcel->getActiveSheet()->getCell('O'.$i)->getCalculatedValue();
                    $tax1 = $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue();
                    $numx = $objPHPExcel->getActiveSheet()->getCell('Q'.$i)->getCalculatedValue();
                    $numz = $objPHPExcel->getActiveSheet()->getCell('S'.$i)->getCalculatedValue();
                     
                    $SQLValidateT100 = "SELECT trannum FROM tran_100 WHERE idcentro = $idcentro AND idcaja = $idcaja AND serie = '$serie' AND numero = $numero";
                    $QueryValidateT100 = $this->db_b->query($SQLValidateT100);
                    
                    if($QueryValidateT100->num_rows() > 0){
                        $infoTran = $QueryValidateT100->row_array();
                        $id_trannum = $infoTran['trannum'];
                        $validateTran = 1;
                    }else{
                        $id_trannum = '';
                        $validateTran = 0;
                    }
                    
                    $SQLProducto = "SELECT idproducto, um, tipo, costounitario FROM invproducts WHERE idproducto = $idproducto";
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    
                    if($QueryProducto->num_rows() > 0){
						$infoProducto = $QueryProducto->row_array();
                        $umProducto = $infoProducto['um'];
                        $tipoProducto = $infoProducto['tipo'];
                        $costounitario = $infoProducto['costounitario'];
						$validateProducto = 1;
                    }else{
                        $totalErrores++;
                        $umProducto = '';
                        $tipoProducto = '';
                        $validateProducto = 0;
                    }
                    
                    if($tipoProducto != 4){
                        $SQLValidateBatch = "SELECT idbatch, descrip, costounitario FROM inv_batch WHERE idproducto = $idproducto";
                        $QueryValidateBatch = $this->db_b->query($SQLValidateBatch);
                        
                        if($QueryValidateBatch->num_rows() > 0){
                            $infoBatch = $QueryValidateBatch->row_array();
                            $idbatch = $infoBatch['idbatch'];
                            $nameLote = $infoBatch['descrip'];
                            $costounitario = $infoBatch['costounitario'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            
                            $idbatch = '';
                            $costounitario = '';
                            $nameLote = '';
                            $validateBatch = 0;
                        }
                        
                        $SQLValidateBin = "SELECT idbin, descrip FROM invlocations WHERE idcentro = $idcentro";
                        $QueryValidateBin = $this->db_b->query($SQLValidateBin);
                        
                        if($QueryValidateBin->num_rows() > 0){
                            $infoBin = $QueryValidateBin->row_array();
                            $idbin = $infoBin['idbin'];
                            $nameUbicacion = $infoBin['descrip'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            $idbin = '';
                            $nameUbicacion = '';
                            $validateBatch = 0;
                        }
                    }else{
                        $SQLValidateBatch = "SELECT idbin, descrip FROM invlocations WHERE idcentro = $idcentro";
                        $QueryValidateBatch = $this->db_b->query($SQLValidateBatch);
                        
                        if($QueryValidateBatch->num_rows() > 0){
                            $infoBatch = $QueryValidateBatch->row_array();
                            $idbatch = 9999;
                            $idbin = $infoBatch['idbin'];
                            $nameLote = '';
                            $nameUbicacion = $infoBatch['descrip'];
                            $validateBatch = 1;
                        }else{
                            $totalErrores++;
                            
                            $idbatch = '';
                            $idbin = '';
                            $costounitario = '';
                            $nameLote = '';
                            $nameUbicacion = '';
                            $validateBatch = 0;
                        }
                    }
                    
                    $SQLValidateCliente = "SELECT descrip, nrc, dias FROM ctauxi WHERE idauxi = $idcps";
                    $QueryValidateCliente = $this->db_b->query($SQLValidateCliente);
                    
                    if($QueryValidateCliente->num_rows() > 0){
                        $infoCliente = $QueryValidateCliente->row_array();
                        $nameCliente = $infoCliente['descrip'];
                        $dias = $infoCliente['dias'];
                        $nrc = $infoCliente['nrc'];
                        $validateCliente = 1;
                    }else{
                        $nameCliente = '';
						$dias = '';
						$nrc = '';
                        $validateCliente = 0;
                    }
                    
                    $SQLValidateVendedor = "SELECT descrip FROM ctauxi WHERE idauxi = $idworker";
                    $QueryValidateVendedor = $this->db_b->query($SQLValidateVendedor);
                    
                    if($QueryValidateVendedor->num_rows() > 0){
                        $infoVendedor = $QueryValidateVendedor->row_array();
                        $nameVendedor = $infoVendedor['descrip'];
                        $validateVendedor = 1;
                    }else{
                        $nameVendedor = '';
                        $validateVendedor = 0;
                    }
                    
                    $SQLValidateClase = "SELECT descrip, inopera FROM inv_def WHERE invclase = $idclase";
                    $QueryValidateClase = $this->db_b->query($SQLValidateClase);
                    
                    if($QueryValidateClase->num_rows() > 0){
                        $infoVendedor = $QueryValidateClase->row_array();
                        $tipoDocumento = $infoVendedor['descrip'];
                        $inopera = $infoVendedor['inopera'];
                        $validateClase = 1;
                    }else{
						$tipoDocumento = '';
						$inopera = '';
                        $validateClase = 0;
                    }
                    
                    $SQLInvcontrol = "SELECT invcontrol FROM invsites WHERE idcentro = $idcentro";
                    $QueryInvcontrol = $this->db_b->query($SQLInvcontrol);
                    
                    if($QueryInvcontrol->num_rows() > 0){
                        $infoCentro = $QueryInvcontrol->row_array();
                        $invcontrol = $infoCentro['invcontrol'];
                    }else{
                        $invcontrol = '';
                    }
                    
                    $SQLCajClase = "SELECT creditchk FROM caj_def WHERE cajclase = $cajclase";
                    $QueryCajClase = $this->db_b->query($SQLCajClase);
                    
                    if($QueryCajClase->num_rows() > 0){
                        $infoCajclase = $QueryCajClase->row_array();
                        $creditoPago = $infoCajclase['creditchk'];
                        $numeroY = $cajclase;
                    }else{
                        $creditoPago = 0;
                        $numeroY = 0;
                    }
                    
                    if($idcen_ant == $idcentro && $idcaj_ant == $idcaja && $idcla_ant == $idclase && $serie_ant == $serie && $numer_ant == $numero){
						$valItemline++;
						
						$precio_iva = $preciotran * 1.13;
						$cantidad_registro = $cantidad * $inopera;
						
						$this->db_b->set('idrec', 0);
						$this->db_b->set('trannum', $idTrannum);
						$this->db_b->set('idclase', $idclase);
						$this->db_b->set('itemline', $valItemline);
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('invcontrol', $invcontrol);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('idbatch', $idbatch);
						$this->db_b->set('idbin', $idbin);
						$this->db_b->set('cantidad', $cantidad_registro);
						$this->db_b->set('um', $umProducto);
						$this->db_b->set('uniconv', $uniconv);
						$this->db_b->set('idworker', $idworker);
						$this->db_b->set('costounitario', $costounitario);
						$this->db_b->set('preciotran', $precio_iva);
						$this->db_b->set('precioneto', $preciotran);
						$this->db_b->set('tax1', $tax1);
						$this->db_b->set('notas', $i);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$QueryInsert = $this->db_b->insert('tran_100k');
						
						$ventaTotal = $ventaTotal + ($cantidad * $preciotran);
						
						if($tax1 != 0){
                            $ivaTotal = $ivaTotal + (($cantidad * $preciotran) * ($tax1 / 100));
						}
						
						$fecha_vn_ant = $fecha_vn;
						$idworker_ant = $idworker;
					}else{
						$valItemline = 0;
						
						if($i != 2){
                            $valorPago = $ventaTotal + $ivaTotal;
                            
                            if($creditoPago == 0){
                                $this->db_b->set('idrec', 0);
                                $this->db_b->set('trannum', $idTrannum);
                                $this->db_b->set('idclase', $idcla_ant);
                                $this->db_b->set('fecha', $fecha_vn_ant);
                                $this->db_b->set('itemline', 1);
                                $this->db_b->set('cajclase', $cajcl_ant);
                                $this->db_b->set('idworker', $idworker_ant);
                                $this->db_b->set('valor', $valorPago);
                                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                $this->db_b->set('ingresa', $fecha_actual);
                                $this->db_b->insert('tran_100c');
                            }
							
							$SQLTotaliza = "CALL totaliza100($idTrannum, 1)";
							$this->db_b->query($SQLTotaliza);
							
							$ventaTotal = 0;
							$ivaTotal = 0;
							$header = 0;
						}
						
						$fecha_vence = strtotime ('+'.$dias.' day', strtotime($fecha_vn));
						$fecha_vence = date('Y-m-j', $fecha_vence);
						
						$this->db_b->set('trannum', 0);
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('idcaja', $idcaja);
						$this->db_b->set('idclase', $idclase);
						$this->db_b->set('serie', $serie);
						$this->db_b->set('numero', $numero);
						$this->db_b->set('fecha', $fecha_vn);
						$this->db_b->set('fecact', $fecha_actual);
						$this->db_b->set('fecvence', $fecha_vence);
						$this->db_b->set('idcps', $idcps);
                        $this->db_b->set('idworker', $idworker);
                        $this->db_b->set('numx', $numx);
						$this->db_b->set('numz', $numz);
						$this->db_b->set('nrc', $nrc);
						$this->db_b->set('estatus', 1);
						$this->db_b->set('notas', $nameDocument);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$QueryInsert = $this->db_b->insert('tran_100');

						$idTrannum = $this->db_b->insert_id();
						
						$valItemline++;
						
						$precio_iva = $preciotran * 1.13;
						$cantidad_registro = $cantidad * $inopera;
						
						$this->db_b->set('idrec', 0);
						$this->db_b->set('trannum', $idTrannum);
						$this->db_b->set('idclase', $idclase);
						$this->db_b->set('itemline', $valItemline);
						$this->db_b->set('idcentro', $idcentro);
						$this->db_b->set('invcontrol', $invcontrol);
						$this->db_b->set('idproducto', $idproducto);
						$this->db_b->set('idbatch', $idbatch);
						$this->db_b->set('idbin', $idbin);
						$this->db_b->set('cantidad', $cantidad_registro);
						$this->db_b->set('um', $umProducto);
						$this->db_b->set('uniconv', $uniconv);
						$this->db_b->set('idworker', $idworker);
						$this->db_b->set('costounitario', $costounitario);
						$this->db_b->set('preciotran', $precio_iva);
						$this->db_b->set('precioneto', $preciotran);
						$this->db_b->set('tax1', $tax1);
						$this->db_b->set('notas', $i);
						$this->db_b->set('whodidit', $this->session->userdata('iduser'));
						$this->db_b->set('ingresa', $fecha_actual);
						$QueryInsert = $this->db_b->insert('tran_100k');
						
						$header = 1;
						$ventaTotal = $ventaTotal + ($cantidad * $preciotran);
						
						if($tax1 != 0){
							$ivaTotal = $ivaTotal + (($cantidad * $preciotran) * ($tax1 / 100));
						}
						
						$fecha_vn_ant = $fecha_vn;
						$idworker_ant = $idworker;
						
						$idcen_ant = $idcentro;
						$idcaj_ant = $idcaja;
						$idcla_ant = $idclase;
						$cajcl_ant = $cajclase;
						$serie_ant = $serie;
						$numer_ant = $numero;
					}
                }
				
				if($header == 1){
					$valorPago = $ventaTotal + $ivaTotal;
					if($creditoPago == 0){
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $idTrannum);
                        $this->db_b->set('idclase', $idcla_ant);
                        $this->db_b->set('fecha', $fecha_vn_ant);
                        $this->db_b->set('itemline', 1);
                        $this->db_b->set('cajclase', $cajcl_ant);
                        $this->db_b->set('idworker', $idworker_ant);
                        $this->db_b->set('valor', $valorPago);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $fecha_actual);
                        $this->db_b->insert('tran_100c');
                    }
					$SQLTotaliza = "CALL totaliza100($idTrannum, 1)";
					$this->db_b->query($SQLTotaliza);
				}
				
				return $QueryInsert;
			}
		}
		
		function getListadoHojasArchivo($documentTemp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                $objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
                $dataSource = $objPHPExcel->getSheetNames();
				
				return $dataSource;
            }
		}
		
		function getListadoTablasSystem(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT table_comment, table_name, table_rows FROM INFORMATION_SCHEMA.TABLES WHERE table_schema =  '".$this->session->userdata('nameDB')."' AND table_comment != 'VIEW' AND table_name NOT LIKE 'g%' ORDER BY table_comment";
				$Query = $this->db_b->query($SQLConsulta);
				$Result = $Query->result();
				return $Result;
			}
		}
		
		function getEstructuraExcelTable($name_table){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				require_once APPPATH . 'libraries/Classes/PHPExcel.php';
				require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
				
				ini_set('memory_limit', '800M');
                ini_set('max_allowed_packet', '500M'); 
                
                $objPHPExcel = new PHPExcel();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas")
					->setLastModifiedBy("Versanet Sistemas")
                    ->setTitle("Estructura Tabla")
                    ->setSubject("Estructura Tabla")
                    ->setDescription("Estructura Tabla")
                    ->setKeywords("Estructura Tabla")
                    ->setCategory("Estructura Tabla");
                
				$SQLColumnas = "SHOW COLUMNS FROM $name_table";
				$QueryColumnas = $this->db_b->query($SQLColumnas);
				$ResultColumnas = $QueryColumnas->result_array();
				$indexColumna = 'A';
				
				foreach($ResultColumnas as $informacion){
					$objPHPExcel->setActiveSheetIndex(0)->setCellValue($indexColumna . '1', $informacion['Field']);
					$indexColumna++;
				}
				
				$objPHPExcel->getActiveSheet()->setTitle('Estructura ' . $name_table);
				$objPHPExcel->setActiveSheetIndex(0);
				
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Estructura de '.$name_table.'.xlsx"');
				header('Cache-Control: max-age=0');
                
				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
				$objWriter->save('php://output');
				
				exit;
			}
		}
		
		function getListadoMatchColumnasTablaHoja($documentTemp, $indexSheet, $nameTable){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                $objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
				
				$objPHPExcel->setActiveSheetIndex($indexSheet);
                
				$i=0;
                $indexColumna = 'A';
                $dataSourceField = array();
                
				do{
					$valor_campo = $objPHPExcel->getActiveSheet()->getCell($indexColumna.'1')->getCalculatedValue();
					$dataSourceField[$i] = array(
						"nameCampo" => $valor_campo
					);
					$i++;
					$indexColumna++;
				}while($valor_campo != "");
				
				$SQLColumnas = "SHOW COLUMNS FROM $nameTable";
				$QueryColumnas = $this->db_b->query($SQLColumnas);
				$ResultColumnas = $QueryColumnas->result_array();
				
				$j=0;
				$dataSourceTabla = array();
				foreach($ResultColumnas as $informacion){
					
					$valor_campo = "";
						
					foreach($dataSourceField as $info => $value){
						if(strtolower(trim($informacion['Field'])) == strtolower(trim($value['nameCampo']))){
							$valor_campo = $value['nameCampo'];
						}
					}
					
					$dataSourceTabla[$j] = array(
						"field_target" => $informacion['Field'],
						"field_source" => $valor_campo,
						"llave_primaria" => "",
						"rowIndex" => $j
					);
					$j++;
				}
				
				return $dataSourceTabla;
			}
		}
		
		function insertarDatosImportacionExcel($documentTemp, $indexSheet, $nameTable){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                $objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
				$objPHPExcel->setActiveSheetIndex($indexSheet);
                $numRows = $objPHPExcel->setActiveSheetIndex($indexSheet)->getHighestRow();
                
				$i=0;
                $totalInsertados = 0;
                $indexColumna = 'A';
                $dataSourceField = array();
                
				do{
					$valor_campo = $objPHPExcel->getActiveSheet()->getCell($indexColumna.'1')->getCalculatedValue();
					$dataSourceField[$i] = array(
						"nameCampo" => $valor_campo,
						"indexColumna" => $indexColumna
					);
					$i++;
					$indexColumna++;
				}while($valor_campo != "");
				
				$SQLColumnas = "SHOW COLUMNS FROM $nameTable";
				$QueryColumnas = $this->db_b->query($SQLColumnas);
				$ResultColumnas = $QueryColumnas->result_array();
				
				$j=0;
				$dataSourceColumnas = array();
				$SQLInsert = "INSERT INTO $nameTable (";
				
				foreach($ResultColumnas as $informacion){
					$valor_campo = "";
					foreach($dataSourceField as $info => $value){
						if(strtolower(trim($informacion['Field'])) == strtolower(trim($value['nameCampo']))){
							$valor_campo = strtolower(trim($value['nameCampo']));
                            $index_columna = $value['indexColumna'];
						}
					}
					if($valor_campo != ""){
						$dataSourceColumnas[$j] = array(
							"indexColumna" => $index_columna,
						);
						$j++;
						$SQLInsert .= $valor_campo.",";
					}
				}
				
				$SQLInsert = substr($SQLInsert, 0, -1);
				$SQLInsert .= ") VALUES ";
				
				for($k=2; $k<=$numRows; $k++){
					$SQLInsert .= "(";
					foreach($dataSourceColumnas as $int => $datos){
						
						$valor_insert = $objPHPExcel->getActiveSheet()->getCell($datos['indexColumna'].$k)->getCalculatedValue();
						$SQLInsert .= "'".trim($valor_insert)."',";
					}
					$SQLInsert = substr($SQLInsert, 0, -1);
					$SQLInsert .= "),";
                    $totalInsertados++;
				}
				
				$SQLInsert = substr($SQLInsert, 0, -1);
				$QueryInsertInto = $this->db_b->query($SQLInsert);
				
				$ResultadoInsert = $numRows."/".$totalInsertados;
                
				return $ResultadoInsert;
			}
		}
        
        function insertarDatosImportacionExcelPrimaryKey($documentTemp, $indexSheet, $nameTable, $primaryKey){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit', '800M');
				ini_set('max_allowed_packet', '500M'); 
				
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                
				$cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
				$cacheSettings = array( 'memoryCacheSize' => '2048MB');
				PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
				
                $objPHPExcel = PHPExcel_IOFactory::load($documentTemp);
				$objPHPExcel->setActiveSheetIndex($indexSheet);
                $numRows = $objPHPExcel->setActiveSheetIndex($indexSheet)->getHighestRow();
                
				$i=0;
                $indexColumna = 'A';
                $indexColumnaValidate = '';
                $totalInsertados = 0;
                $dataSourceField = array();
                
				do{
					$valor_campo = $objPHPExcel->getActiveSheet()->getCell($indexColumna.'1')->getCalculatedValue();
					$dataSourceField[$i] = array(
						"nameCampo" => $valor_campo,
						"indexColumna" => $indexColumna
					);
                    
                    if($primaryKey == $valor_campo){
                        $indexColumnaValidate = $indexColumna;
                    }
                    
					$i++;
					$indexColumna++;
				}while($valor_campo != "");
				
				$SQLColumnas = "SHOW COLUMNS FROM $nameTable";
				$QueryColumnas = $this->db_b->query($SQLColumnas);
				$ResultColumnas = $QueryColumnas->result_array();
				
				$j=0;
				$dataSourceColumnas = array();
				$SQLInsertP = "INSERT INTO $nameTable (";
				
				foreach($ResultColumnas as $informacion){
					$valor_campo = "";
					foreach($dataSourceField as $info => $value){
						if(strtolower(trim($informacion['Field'])) == strtolower(trim($value['nameCampo']))){
							$valor_campo = strtolower(trim($value['nameCampo']));
                            $index_columna = $value['indexColumna'];
						}
					}
					if($valor_campo != ""){
						$dataSourceColumnas[$j] = array(
							"indexColumna" => $index_columna,
						);
						$j++;
						$SQLInsertP .= $valor_campo.",";
					}
				}
				
				$SQLInsertP = substr($SQLInsertP, 0, -1);
				$SQLInsertP .= ") VALUES ";
				
				for($k=2; $k<=$numRows; $k++){
					$SQLInsert = "(";
					foreach($dataSourceColumnas as $int => $datos){
						
						$valor_insert = $objPHPExcel->getActiveSheet()->getCell($datos['indexColumna'].$k)->getCalculatedValue();
						$SQLInsert .= "'".trim($valor_insert)."',";
					}
					$SQLInsert = substr($SQLInsert, 0, -1);
					$SQLInsert .= ")";
                    
                    $SQLInsertFinal = $SQLInsertP . $SQLInsert;
                    
                    $val_validate = $objPHPExcel->getActiveSheet()->getCell($indexColumnaValidate.$k)->getCalculatedValue();
                    
                    if($val_validate != ""){
                        $SQLValidate = "SELECT * FROM $nameTable WHERE $primaryKey = '$val_validate'";
                        $QueryValidate = $this->db_b->query($SQLValidate);
                        
                        if($QueryValidate->num_rows()== 0){
                            $this->db_b->query($SQLInsertFinal);
                            $totalInsertados++;
                        }
                    }
				}
				
                $ResultadoInsert = $numRows."/".$totalInsertados;
                
				return $ResultadoInsert;
			}
        }
        
        function getTransVentasXPeriodo($fechaini, $fechafin, $idcentro, $idcaja){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT IFNULL(COUNT(tran_100.trannum), 0) AS cant FROM tran_100 INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase WHERE invdef.agrupa = 'VN' AND tran_100.estatus = 1 AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha between '$fechaini' AND '$fechafin' ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }
        
        function corre_totaliza100($fechaini, $fechafin, $idcentro, $idcaja){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT tran_100.trannum FROM tran_100 INNER JOIN inv_def AS invdef ON tran_100.idclase = invdef.invclase WHERE invdef.agrupa = 'VN' AND tran_100.estatus = 1 AND tran_100.idcentro = $idcentro AND tran_100.idcaja = $idcaja AND tran_100.fecha between '$fechaini' AND '$fechafin' ";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->result();
                    foreach($resultado as $res){
                        $idtrannum = $res->trannum;
                        $SQLTotaliza = "CALL totaliza100($idtrannum, 1)";
                        $this->db_b->query($SQLTotaliza);
                    }
                }
                return true;
            }
        }
        
		function registrosTablas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT table_comment, table_name, table_rows,data_length FROM INFORMATION_SCHEMA.TABLES WHERE table_schema =  '".$this->session->userdata('nameDB')."' AND table_comment != 'VIEW' AND table_name NOT LIKE 'g%' ORDER BY table_comment";
				$Query = $this->db_b->query($SQLConsulta);
				$Result = $Query->result();
				return $Result;
			}
		}
        
		function num_rows_mes($table_name,$fecha_ini,$fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT ifnull(COUNT(*),0)  AS num_rows FROM $table_name WHERE ingresa BETWEEN '$fecha_ini 00:00:00' AND '$fechafin 23:59:59'";
				$Query = $this->db_b->query($SQLConsulta);
				if($Query->num_rows()>0){
                    $Result = $Query->row_array();
                    return $Result['num_rows'];
                }else{
                    return 0;
                }
			}
        }

        function getListadoProductos($estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT idproducto AS id, descrip FROM invproducts WHERE estado = $estado ORDER BY descrip";
				$Query = $this->db_b->query($SQLConsulta);
				if($Query->num_rows()>0){
                    $informacion = $Query->result();
                    return $informacion;
                }else{
                    return false;
                }
			}
        }

        function getInformacionBrochureProducto($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT * FROM invpromulti WHERE idproducto = $idproducto AND idgvar = 200 ORDER BY idcps";
				$Query = $this->db_b->query($SQLConsulta);
				if($Query->num_rows()> 0){
                    $informacion = $Query->result();
                    return $informacion;
                }else{
                    return false;
                }
			}
        }

        function getListadoItemsBrochure($nameGvar){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$SQLConsulta = "SELECT valor_num AS id, descripcion AS descrip, filtro AS tipo FROM gvars WHERE nombre = '$nameGvar' ORDER BY valor_num";
                $Query = $this->db_b->query($SQLConsulta);
                
				if($Query->num_rows()> 0){
                    $informacion = $Query->result();
                    return $informacion;
                }else{
                    return false;
                }
			}
        }

        function insertInformacionBrochure($items, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d H:i:s");

                for($i=0; $i<count($items); $i++){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('idgvar', 200);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('descrip', $items[$i]['descrip']);
                    $this->db_b->set('idcps', $items[$i]['id']);
                    $this->db_b->set('uniconv', $items[$i]['tipo']);
                    $this->db_b->set('estatus', 1);
                    $this->db_b->set('ingresa', $fecha);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $query = $this->db_b->insert('invpromulti');
                }

                return $query;
			}
        }

        function updateInformacionBrochure($idrec, $texto, $nombre, $posicion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d H:i:s");

                $this->db_b->set('descrip', $nombre);
                $this->db_b->set('idcps', $posicion);
                $this->db_b->set('notas', $texto);
                $this->db_b->set('modifica', $fecha);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('invpromulti');
            }
        }

        function updateImagenBrochure($idrec, $nameImagen){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d H:i:s");

                $this->db_b->set('notas', $nameImagen);
                $this->db_b->set('modifica', $fecha);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('invpromulti');

                return $query;
            }
        }

        function getInformacionValorBrochure($idproducto, $posicion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "SELECT notas FROM invpromulti WHERE idproducto = $idproducto AND idgvar = 200 AND idcps = $posicion LIMIT 1";
				$Query = $this->db_b->query($SQLConsulta);
                
                if($Query->num_rows()> 0){
                    $informacion = $Query->row_array();
                    return $informacion['notas'];
                }else{
                    return false;
                }
            }
        }

        function getInformacionDatosBrochure($idproducto, $posicion){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "SELECT notas FROM invpromulti WHERE idproducto = $idproducto AND idgvar = 200 AND idcps = $posicion";
				$Query = $this->db_b->query($SQLConsulta);
                
                if($Query->num_rows()> 0){
                    $informacion = $Query->result();
                    return $informacion;
                }else{
                    return false;
                }
            }
        }

        function eliminarElementoBrochure($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLConsulta = "DELETE FROM invpromulti WHERE idrec = $idrec";
                $query = $this->db_b->query($SQLConsulta);
                
                return $query;
            }
        }

        function getInfoCortes($fechaInicial,$fechaFinal,$idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{ 
                $consulta = "SELECT invsites.descrip as centro, ctcajas.descrip as caja, tran_100z.idcentro as id_centro, tran_100z.idcaja as id_caja, tran_100z.numz, tran_100z.numx, tran_100z.tipo, DATE_FORMAT( tran_100z.fechahora, '%Y-%m-%d' ) as fecha,
                tran_100z.descrip as corte, caj_def.descrip as formaPago, tran_100z.valorsys, tran_100z.valorusr, gusers.descrip as usuario, tran_100z.ingresa as fechaHora
                FROM tran_100z
                INNER JOIN invsites on tran_100z.idcentro = invsites.idcentro
                INNER JOIN ctcajas on tran_100z.idcaja = ctcajas.idcaja
                INNER JOIN caj_def on tran_100z.cajclase = caj_def.cajclase
                INNER JOIN gusers on tran_100z.whodidit = gusers.iduser
                WHERE tran_100z.idcentro = $idcentro AND tran_100z.fechahora BETWEEN '$fechaInicial' AND '$fechaFinal'";
                
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }

        function getInfoPagos($numz,$numx,$tipo,$caja,$sucursal){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{ 
                if($tipo==1){
                    $consulta = "SELECT tran_100c.trannum, inv_def.inopera, tran_100c.notas, ABS( tran_100c.valor ) as valor, ABS( tran_100c.vuelto ) as vuelto, 
                                ( ABS( tran_100c.valor ) - ABS( tran_100c.vuelto ) ) as total, tran_100c.ingresa	
                                FROM tran_100c
                                INNER JOIN tran_100 on tran_100.trannum = tran_100c.trannum
                                INNER JOIN inv_def on tran_100.idclase = inv_def.invclase
                                WHERE tran_100.idcentro = $sucursal AND tran_100.idcaja = $caja AND tran_100.numx = $numx AND tran_100.numz = $numz";
                }else{
                    $consulta = "SELECT tran_100c.trannum, inv_def.inopera, tran_100c.notas, ABS( tran_100c.valor ) as valor, ABS( tran_100c.vuelto ) as vuelto, 
                                ( ABS( tran_100c.valor ) - ABS( tran_100c.vuelto ) ) as total, tran_100c.ingresa	
                                FROM tran_100c
                                INNER JOIN tran_100 on tran_100.trannum = tran_100c.trannum
                                INNER JOIN inv_def on tran_100.idclase = inv_def.invclase
                                WHERE tran_100.idcentro = $sucursal AND tran_100.idcaja = $caja AND tran_100.numz = $numz";
                }
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }

        function insertarAdjunto($nameDocument, $id_cobro, $comentarios){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $nameDocument = str_replace(" ", "_", $nameDocument);

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $id_cobro);
                $this->db_b->set('imagen', $nameDocument);
                $this->db_b->set('estatus', 3);
                $this->db_b->set('notas', $comentarios);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('tran_100p');
                return $query;
            }
        }

        function insertarOnlyComment($id_cobro, $comentarios){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $id_cobro);
                $this->db_b->set('estatus', 3);
                $this->db_b->set('notas', $comentarios);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('tran_100p');
                return $query;
            }
        }

        function getInformacionHistorialAjunto($id_cobro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLTickets = "SELECT idrec, trannum, ingresa as fecha, imagen as descrip, notas as comentario, whodidit FROM tran_100p WHERE trannum = $id_cobro AND estatus = 3 ORDER BY ingresa DESC";
                $Query = $this->db_b->query($SQLTickets);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }

        function setRestriccionUsuario($iduser){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $idaccount = $this->session->userdata('idaccount');
                $nameempre = $this->session->userdata('descrip');

                $consonants  = array(",", " ", ".", "b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "ñ", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z",
                                     ",", " ", ".", "B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "Ñ", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z");
                $infoEmpresa = str_replace($consonants, "", $nameempre);

                $infoKey   = 'Egga8466-2';
                $infoToken = md5($idaccount.$infoEmpresa.$infoKey);

                $SQLUser = "SELECT derechos FROM gusers WHERE iduser = $iduser";
                $Query   = $this->db_b->query($SQLUser);
                $informacion = $Query->row_array();

                $infoDerechos = $informacion['derechos'] == '' ? 'restricted' : $informacion['derechos'] . ',restricted';

                $this->db_b->set('derechos', $infoDerechos);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('iduser', $iduser);
                $this->db_b->update('gusers');

                return $infoToken;
            }
        }
    }
?>