<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class External_model extends CI_Model {
        
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        function getDatosVendedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("idauxi, descrip");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", 3);
                $this->db_b->where("estado",    1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                
                $informacion = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $informacion[] = array(
                            'id'      => (int)$dato->idauxi,
                            'descrip' => $dato->descrip
                        );
                    }
                }
                return $informacion;
            }
        }

        function getDatosProcedimientosMedicos($idworker, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select("a.trannum, a.idcentro, b.fecha, b.serie, b.numero, c.descrip AS servicio, d.descrip AS cliente, a.cantidad, a.preciotran, e.descrip AS sucursal, a.notas AS infoextra, f.inopera");
                $this->db_b->from("tran_100k a");
                $this->db_b->join("tran_100 b",    "a.trannum = b.trannum");
                $this->db_b->join("invproducts c", "a.idproducto = c.idproducto");
                $this->db_b->join("ctauxi d",      "b.idcps = d.idauxi");
                $this->db_b->join("invsites e",    "a.idcentro = e.idcentro");
                $this->db_b->join("inv_def f",     "b.idclase = f.invclase AND f.agrupa = 'VN'");
                $this->db_b->where("a.idworker",   $idworker);
                $this->db_b->where("b.estatus",    1);
                $this->db_b->where("b.fecha BETWEEN '".$fechaini."' AND '".$fechafin."'");
                $this->db_b->order_by("b.fecha", "ASC");
                $data = $this->db_b->get();
                
                $informacion = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        $informacion[] = array(
                            'trannum'      => (int)$info->trannum,
                            'idcentro'     => (int)$info->idcentro,
                            'fecha'        => $info->fecha,
                            'numeroserie'  => $info->serie.$info->numero,
                            'service_name' => $info->servicio,
                            'namecliente'  => $info->cliente,
                            'notas'        => $info->infoextra,
                            'namesucursal' => $info->sucursal,
                            'laboratorio'  => (($info->cantidad * $info->inopera) * $info->preciotran) * 0.5143,
                            'honorario'    => (($info->cantidad * $info->inopera) * $info->preciotran) * 0.34,
                            'valventan'    => (($info->cantidad * $info->inopera) * $info->preciotran),
                        );
                    }
                }

                return $informacion;
            }
        }

        function getNameMedico($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else return $this->db_b->where("idauxi", $idauxi)->get("ctauxi")->row();
        }
    }
?>