<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Dte_model extends CI_Model {

		public function __construct() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

        function getTotalRegistrosDTE() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec');
                $this->db_b->from('tran_100dte a');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->num_rows();
                } else return 0;
            }
        }
        
        function getTotalEnviosCorreo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec');
                $this->db_b->from('tran_100dte a');
                $this->db_b->where('a.email_send', 1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->num_rows();
                } else return 0;
            }
        }

        function validateExistDocumentDte($trannum, $idtable = 0, $idYear = 0, $anula = 0) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*');
                $this->db_b->from('tran_100dte a');
                $this->db_b->where("a.trannum", $trannum);
                if ($anula == 0) {
                    $this->db_b->where("a.estatus", 1);
                } else {
                    $this->db_b->where("(a.estatus = 1 OR a.estatus = 9)");
                }
                $this->db_b->where("a.type", 'DOC');
                $this->db_b->where("a.o_table", ( $idtable == 0 ) ? 'tran_100' : 'iva_'.$idYear);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function validateExistDocumentDteCSV($trannum, $idtable = 0, $idYear = 0, $anula = 0) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.cgeneracion');
                $this->db_b->from('tran_100dte a');
                $this->db_b->where("a.trannum", $trannum);
                if ($anula == 0) {
                    $this->db_b->where("a.estatus", 1);
                } else {
                    $this->db_b->where("(a.estatus = 1 OR a.estatus = 9)");
                }
                $this->db_b->where("a.type", 'DOC');
                $this->db_b->where("a.o_table", ( $idtable == 0 ) ? 'tran_100' : 'iva_'.$idYear);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }
        
        function validateInvalidDocumentDte($trannum, $idtable = 0, $idYear = 0) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*');
                $this->db_b->from('tran_100dte a');
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->where("a.estatus", 1);
                $this->db_b->where("a.type", 'ANULA');
                $this->db_b->where("a.o_table", ( $idtable == 0 ) ? 'tran_100' : 'iva_'.$idYear);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getDatosIvaCentralJSON($idrec, $idYear){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*, d.idauxi AS idcliente, d.correo, d.idtipo, d.dui as dui, IFNULL(d.descrip, "Nuevo Cliente") AS nameCliente, IFNULL(d.telefono, "") AS telefono');
                $this->db_b->select('IFNULL(d.dias, "0") AS dias, d.nrc, d.direccion, d.correo, d.grupo');
                $this->db_b->select('d.nit, d.giro, d.dte_giro, IFNULL(h.descrip, "") AS dte_giro_des, d.idzip, g.iddeptodte, g.idmunidte, f.descrip as facturadopor, b.notas AS direccioncentro');
                $this->db_b->select('IF(b.codigomh = "", LPAD(b.idcentro, 4, 0), b.codigomh) AS centromh, IF(j.codigomh = "", LPAD(j.idcaja, 4, 0), j.codigomh) AS cajamh');
                $this->db_b->from('iva_'.$idYear.' a');
                $this->db_b->join('invsites b', 'a.idcentro = b.idcentro');
                //$this->db_b->join('inv_def  c', 'a.idclase  = c.invclase');
                $this->db_b->join('ctauxi   d', 'a.idcps    = d.idauxi', 'left');
                $this->db_b->join('gusers   f', 'a.whodidit = f.iduser', 'left');
                $this->db_b->join('gzips    g', 'd.idzip = g.idzip');
                $this->db_b->join('ctcajas  j', 'a.idcaja = j.idcaja');
                $this->db_b->join('dte_catalog h', '(d.dte_giro = h.codigo AND h.idcatalogo = "CAT-019")', 'left');
                $this->db_b->where("a.idrec", $idrec);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getInfoDocRelacionado($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('CONCAT(a.serie, a.numero) AS numeroDocumento, a.fecha');
                $this->db_b->from('tran_100 a');
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getDatosFacturacionJSON($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*, d.idauxi AS idcliente, d.correo, d.idtipo, d.dui as dui, IFNULL(d.descrip, "Nuevo Cliente") AS nameCliente, IFNULL(d.telefono, "") AS telefono');
                $this->db_b->select('IFNULL(d.dias, "0") AS dias, e.idauxi AS idvendedor, e.descrip AS nameVendedor, e.nrc AS duivendedor, d.nrc, d.direccion, d.correo, d.grupo');
                $this->db_b->select('d.nit, d.giro, d.dte_giro, IFNULL(h.descrip, "") AS dte_giro_des, c.exento, c.askregiva, c.descrip, f.descrip as facturadopor, b.notas AS direccioncentro');
                $this->db_b->select('d.idzip, g.iddeptodte, g.idmunidte, g.pais, g.idpaisdte, b.direccion AS direccionsucursal, IFNULL(i.iddeptodte, 0) AS iddeptodtesuc, IFNULL(i.idmunidte, 0) AS idmunidtesuc');
                $this->db_b->select('IF(b.codigomh = "", LPAD(b.idcentro, 4, 0), b.codigomh) AS centromh, IF(j.codigomh = "", LPAD(j.idcaja, 4, 0), j.codigomh) AS cajamh');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('invsites b', 'a.idcentro = b.idcentro');
                $this->db_b->join('inv_def  c', 'a.idclase = c.invclase');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('ctauxi   e', 'a.idworker = e.idauxi', 'left');
                $this->db_b->join('gusers   f', 'a.whodidit = f.iduser', 'left');
                $this->db_b->join('gzips    g', 'd.idzip = g.idzip');
                $this->db_b->join('gzips    i', 'b.idzip = i.idzip', 'left');
                $this->db_b->join('ctcajas  j', 'a.idcaja = j.idcaja');
                $this->db_b->join('dte_catalog h', '(d.dte_giro = h.codigo AND h.idcatalogo = "CAT-019")', 'left');
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getDatosFacturacionJSONRemi($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*, d.idauxi AS idcliente, d.correo, d.idtipo, d.dui as dui, IFNULL(d.descrip, "Nuevo Cliente") AS nameCliente, IFNULL(d.telefono, "") AS telefono');
                $this->db_b->select('IFNULL(d.dias, "0") AS dias, e.idauxi AS idvendedor, e.descrip AS nameVendedor, e.nrc AS duivendedor, d.nrc, d.direccion, d.correo, d.grupo');
                $this->db_b->select('d.nit, d.giro, d.dte_giro, IFNULL(h.descrip, "") AS dte_giro_des, c.exento, c.askregiva, c.descrip, f.descrip as facturadopor, b.notas AS direccioncentro');
                $this->db_b->select('d.idzip, g.iddeptodte, g.idmunidte, g.pais, g.idpaisdte, i.notas AS direcciondestino, b.direccion AS direccionsucursal, IFNULL(j.iddeptodte, 0) AS iddeptodtesuc, IFNULL(j.idmunidte, 0) AS idmunidtesuc');
                $this->db_b->select('IF(b.codigomh = "", LPAD(b.idcentro, 4, 0), b.codigomh) AS centromh, IF(k.idcaja IS NULL, "P001", IF(k.codigomh = "", LPAD(k.idcaja, 4, 0), k.codigomh)) AS cajamh');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('invsites b', 'a.idcentro = b.idcentro');
                $this->db_b->join('inv_def  c', 'a.idclase = c.invclase');
                $this->db_b->join('ctauxi   d', 'a.idcps = d.idauxi', 'left');
                $this->db_b->join('ctauxi   e', 'a.idworker = e.idauxi', 'left');
                $this->db_b->join('gusers   f', 'a.whodidit = f.iduser', 'left');
                $this->db_b->join('gzips    g', 'd.idzip = g.idzip', 'left');
                $this->db_b->join('dte_catalog h', '(d.dte_giro = h.codigo AND h.idcatalogo = "CAT-019")', 'left');
                $this->db_b->join('invsites i', 'a.idcentrod = i.idcentro', 'left');
                $this->db_b->join('gzips    j', 'b.idzip = j.idzip', 'left');
                $this->db_b->join('ctcajas  k', 'a.idcaja = k.idcaja', 'left');
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getDetalleProductosJSON($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $eField = 0;
                $infoRes = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invproducts'  AND table_schema = '".$this->session->userdata('nameDB')."'");
                
                if ($infoRes->num_rows() > 0) {
                    $fieldExist = $this->db_b->field_exists('nosujeta', 'invproducts');
                    if ($fieldExist) {
                        $eField = 1; 
                    }
                }
                
                $this->db_b->select('b.xpos, b.barcode, b.codescrip, b.precioventa, b.tipotax, b.tipo, b.upp, a.notas AS vnNotas, a.um AS umVenta');
                $this->db_b->select('c.descrip AS vendename, a.idrec, a.tax1, a.barcode AS codeventa, a.itemline, a.uniconv, a.idworker');
                $this->db_b->select('b.idcatalogo, b.descrip, b.imagen, b.modelo, b.um, b.marca, b.idproducto, b.notas');
                
                if ($eField == 1) {
                    $this->db_b->select('b.nosujeta');
                } else $this->db_b->select('CONCAT(0) AS nosujeta');

                $this->db_b->select('a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('invproducts b', 'a.idproducto = b.idproducto');
                $this->db_b->join('ctauxi c', 'a.idworker = c.idauxi', 'left');
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->order_by("a.itemline", "ASC");
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getDetalleProductosJSONDonacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*');
                $this->db_b->from('tran_100k a');
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->order_by("a.itemline", "ASC");
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getDetalleProductosJSONTicket($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.xpos, b.barcode, b.codescrip, b.precioventa, b.tipotax, b.tipo, b.upp, a.notas AS vnNotas, a.um AS umVenta');
                $this->db_b->select('c.descrip AS vendename, a.idrec, a.tax1, a.barcode AS codeventa, a.itemline, a.uniconv, a.idworker');
                $this->db_b->select('b.idcatalogo, b.descrip, b.imagen, b.modelo, b.um, b.marca, b.idproducto, b.notas');
                $this->db_b->select('a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, d.descrip AS categoria_pro');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('invproducts b', 'a.idproducto = b.idproducto');
                $this->db_b->join('ctauxi c', 'a.idworker = c.idauxi', 'left');
                $this->db_b->join('invcatalog d', 'b.idcatalogo = d.idcatalogo');
                $this->db_b->where("a.trannum", $trannum);
                $this->db_b->order_by("a.itemline", "ASC");
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function updateDatosDTE($trannum, $numControl, $cGeneracion, $sRecepcion, $jsonDoc, $jsonFirmado, $respMH, $estatus = 1, $tabla = 0, $idYear = 0, $type = 0){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $fecha = new DateTime();

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('fechahora', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->set('ncontrol', $numControl);
                $this->db_b->set('cgeneracion', $cGeneracion);
                $this->db_b->set('srecepcion', $sRecepcion);
                $this->db_b->set('firma_json', $jsonFirmado);
                $this->db_b->set('json_doc', $jsonDoc);
                $this->db_b->set('resp_mh', $respMH);
                $this->db_b->set('o_table', ( $tabla == 0 ) ? 'tran_100' : 'iva_'.$idYear );
                $this->db_b->set('type', ( $type == 0 ) ? 'DOC' : 'ANULA' );
                $this->db_b->set('notas', '');
                $this->db_b->set('estatus', $estatus);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
                $infoResult = $this->db_b->insert('tran_100dte');

                return $infoResult;
            }
        }
        
        function modificarInformacionDTE($numControl, $cGeneracion, $sRecepcion, $idrec){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $fecha = new DateTime();

                $this->db_b->set('ncontrol', $numControl);
                $this->db_b->set('cgeneracion', $cGeneracion);
                $this->db_b->set('srecepcion', $sRecepcion);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $infoResult = $this->db_b->update('tran_100dte');

                return $infoResult;
            }
        }

        function anulacionDTE($trannum, $numControl) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $fecha = new DateTime();

                $this->db_b->set('estatus', 9);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('ncontrol', $numControl);
                $infoResult = $this->db_b->update('tran_100dte');

                return $infoResult;
            }
        }

        function getDescripCodigoDTE($codigo, $catalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.descrip');
                $this->db_b->from('dte_catalog a');
                $this->db_b->where("a.codigo", $codigo);
                $this->db_b->where("a.idcatalogo", $catalogo);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row_array();
                } else return false;
            }
        }

        function getFormaDePagoDocumento($trannum, $idtable = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                if ($idtable == 0) {
                    $this->db_b->select('b.idpagodte');
                    $this->db_b->from('tran_100c a');
                    $this->db_b->join('caj_def b', 'a.cajclase = b.cajclase');
                    $this->db_b->where("a.trannum", $trannum);
                    $datos = $this->db_b->get();

                    if ($datos->num_rows() > 0) {
                        return $datos->row()->idpagodte;
                    } else {
                        $this->db_b->select('b.idpagodte');
                        $this->db_b->from('tran_100 a');
                        $this->db_b->join('caj_def b', 'a.numy = b.cajclase');
                        $this->db_b->where("a.trannum", $trannum);
                        $datos = $this->db_b->get();

                        if ($datos->num_rows() > 0) {
                            return $datos->row()->idpagodte;
                        } else return '01';
                    }
                } else return '13';
            }
        }

        function getDescripFormaDePagoDocumento($trannum, $idtable = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                if ($idtable == 0) {
                    $this->db_b->select('b.descrip');
                    $this->db_b->from('tran_100c a');
                    $this->db_b->join('caj_def b', 'a.cajclase = b.cajclase');
                    $this->db_b->where("a.trannum", $trannum);
                    $datos = $this->db_b->get();

                    if ($datos->num_rows() > 0) {
                        return $datos->row()->descrip;
                    } else {
                        $this->db_b->select('b.descrip');
                        $this->db_b->from('tran_100 a');
                        $this->db_b->join('caj_def b', 'a.numy = b.cajclase');
                        $this->db_b->where("a.trannum", $trannum);
                        $datos = $this->db_b->get();

                        if ($datos->num_rows() > 0) {
                            return $datos->row()->descrip;
                        } else return 'CREDITO';
                    }
                } else return 'CONTADO';
            }
        }

        function getDatosFacturacionesBitacora($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja = str_replace("_", " OR t100.idcaja = ", $idcaja);
                $idcentro = implode(" OR t100.idcentro = ", $idcentro);
                $consulta = "SELECT t100.trannum, t100.ingresa, t100.notas, t100.fecha, t100.numx, t100.numz, t100.fecact, t100.estatus, t100.serie, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, 
                invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.nit, ctaucli.dui, ctaucli.descrip AS namecliente, ctaucli.correo AS emailCliente, dte_catalog.descrip AS giroDTE, t100.idcps as idclienteauxi, IFNULL(ctauximulti.descrip, ctaucli.descrip) AS namesucursal, ctaucli.idtipo, 
                ctauemp.descrip AS namevendedor, t100.valventan, t100.valcosto, t100.valtax1,invdef.caopera,invdef.exento, t100.referencia, d.serie AS dev_serie, d.numero AS dev_numero, ctcajas.descrip AS namecaja, invsites.descrip AS namecentro, 
                invdef.iddte, IFNULL(dte.cgeneracion, '') AS cgeneracion, IFNULL(dte.srecepcion, '') AS srecepcion, IFNULL(dte.ncontrol, '') AS ncontrol, IFNULL(dte.email_send, 0) AS email_send 
                FROM tran_100 AS t100 
                INNER JOIN ctcajas ON t100.idcaja = ctcajas.idcaja 
                INNER JOIN invsites ON ctcajas.idcentro = invsites.idcentro 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase AND invdef.iddte != ''
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi 
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi
                LEFT JOIN dte_catalog ON ctaucli.dte_giro = dte_catalog.codigo AND dte_catalog.idcatalogo = 'CAT-019'  
                LEFT JOIN ctauximulti ON t100.idcentrod = ctauximulti.idrec 
                LEFT JOIN tran_100 d ON t100.tranref = d.trannum 
                LEFT JOIN tran_100dte dte ON t100.trannum = dte.trannum AND dte.type = 'DOC' AND dte.o_table = 'tran_100'  
                WHERE (invdef.agrupa = '$agrupa' OR invdef.descrip LIKE '%DONACION%') AND (invdef.esticket = 0) AND (t100.idcentro = $idcentro) AND (t100.idcaja = $idcaja) AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecact, t100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }        

        function setAnulacionVenta($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
                $SQLItems = "SELECT * FROM tran_100k WHERE trannum = $trannum";
                $Query = $this->db_b->query($SQLItems);
                $SQLResult = $Query->result();
                
                $findCuota = 0;
                foreach($SQLResult as $info){
                    if($info->invcontrol != 0){
                        $findCuota = 1;
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', 0);
                        $this->db_b->set('idclase', $info->idclase);
                        $this->db_b->set('itemline', $info->itemline);
                        $this->db_b->set('idcentro', $info->idcentro);
                        $this->db_b->set('invcontrol', $info->invcontrol);
                        $this->db_b->set('idproducto', $info->idproducto);
                        $this->db_b->set('idbatch', 0);
                        $this->db_b->set('idbin', 0);
                        $this->db_b->set('barcode', 0);
                        $this->db_b->set('cantidad', 0);
                        $this->db_b->set('um', $info->um);
                        $this->db_b->set('uniconv', 0);
                        $this->db_b->set('idworker', 0);
                        $this->db_b->set('costounitario', 0);
                        $this->db_b->set('preciotran', $info->preciotran);
                        $this->db_b->set('descuento', 0);
                        $this->db_b->set('precioneto', $info->precioneto);
                        $this->db_b->set('tax1', $info->tax1);
                        $this->db_b->set('tax2', 0);
                        $this->db_b->set('tax3', 0);
                        $this->db_b->set('tax4', 0);
                        $this->db_b->set('tax5', 0);
                        $this->db_b->set('notas', $info->notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }
                }
                
                if($findCuota == 1){
                    $this->db_b->set('barcode', 9);
                }
                $this->db_b->set('cantidad', 0);
				$this->db_b->set('precioneto', 0);
				$this->db_b->set('costounitario', 0);
				$this->db_b->set('preciotran', 0);
				$this->db_b->set('descuento', 0);
				$this->db_b->set('tax1', 0);
				$this->db_b->set('tax2', 0);
				$this->db_b->set('tax3', 0);
				$this->db_b->set('tax4', 0);
				$this->db_b->set('tax5', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100k');
                
				$this->db_b->set('valor', 0);
				$this->db_b->set('vuelto', 0);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $this->db_b->update('tran_100c');
				
                $this->db_b->set('valcosto', 0);
                $this->db_b->set('valventan', 0);
                $this->db_b->set('valtax1', 0);
                $this->db_b->set('valtax2', 0);
                $this->db_b->set('valtax3', 0);
                $this->db_b->set('valtax4', 0);
                $this->db_b->set('valtax5', 0);
                $this->db_b->set('valdh', 0);
                $this->db_b->set('estatus', 9);
				$this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                
				return $query;
            }
		}

        function getInfoExtraProducto($idproducto) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.modelo, a.xpos, a.notas, a.barcode');
                $this->db_b->from('invproducts a');
                $this->db_b->where("a.idproducto", $idproducto);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getInfoExtraProductoTran100k($trannum, $idproducto) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.notas, a.um');
                $this->db_b->from('tran_100k a');
                $this->db_b->where("a.idproducto", $idproducto);
                $this->db_b->where("a.trannum", $trannum);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }
	}
?>