<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Dev_model extends CI_Model {
        
        private $TIProductos = 'invproducts';
        private $TIMProductos = 'invpromulti';
        
        public function __construct() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                //echo 'Incorrect database information provided';
            }
        }

        private function validatePermiso() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) redirect('CerrarSesion');
            else return true;
        }
        #---------- REPORTES IVA CENTRAL
        public function multiIvaCentral($opc, $extra = null)
        {
            if($this->validatePermiso()) {
                switch ($opc) {
                    case 1:
                        $datos = $this->db_b->table_exists('iva_'.$extra);
                    break;
                    #   REPORTE LIBRO 1
                        case 2:
                            $where = implode(' AND ', [
                                '(a.idlibro = '.$extra['idlibro'].')',
                                '(a.idanomes = '.$extra['idam'].')'
                            ]);
                            $group = implode(', ', [
                                'a.doc_fecha', 'a.doc_serie', 'a.idcentro'
                            ]);
                            $order = implode(', ', [
                                'a.doc_fecha ASC', 'a.doc_serie ASC', 'a.doc_numero DESC',
                            ]);
                            $select = implode(', ', [
                                'SUM(valor0) as valor0',
                                'SUM(valor1) as valor1',
                                'SUM(valor2) as valor2',
                                'SUM(valor3) as valor3',
                                'SUM(valor4) as valor4',
                                'SUM(valor5) as valor5',
                                'SUM(valor6) as valor6',
                                'SUM(valor7) as valor7',
                                'SUM(valor8) as valor8',
                                'SUM(valor9) as valor9',
                                'SUM(valor10) as valor10',
                                'SUM(valor11) as valor11',
                                'SUM(valor12) as valor12',
                                'SUM(valor13) as valor13',
                                'SUM(valor14) as valor14',
                                'SUM(valor15) as valor15',
                                'SUM(valor16) as valor16',
                                'SUM(valor17) as valor17',
                                'SUM(valor18) as valor18',
                                'SUM(valor19) as valor19',
                                'SUM(valor20) as valor20',
                                'SUM(IF(valor4 != 0, valor1, 0)) AS monto_sujeto_retencion',
                            ]);
                            $this->db_b->select('a.*, b.descrip as tipodoc');
                            $this->db_b->select($select);
                            $this->db_b->from('iva_'.$extra['tabla'].' a');
                            $this->db_b->join('iva_def b', 'a.ivclase = b.ivclase');
                            $this->db_b->where($where);
                            $this->db_b->group_by($group);
                            $this->db_b->order_by($order);
                            $datos = $this->db_b->get();
                        break;
                        #   GET CONTEO NUMERO
                        case 2.5:
                            $where = implode(' AND ', [
                                '(idlibro = '.$extra['idlibro'].')',
                                '(idanomes = '.$extra['idam'].')',
                                '(doc_fecha = "'.$extra['fecha'].'")',
                                '(doc_serie = "'.$extra['serie'].'")',
                            ]);
                            $order = implode(', ', [
                                'CAST(doc_numero AS UNSIGNED) ASC',
                            ]);
                            $this->db_b->select('doc_numero');
                            $this->db_b->from('iva_'.$extra['tabla']);
                            $this->db_b->where($where);
                            $this->db_b->order_by($order);
                            $datos = $this->db_b->get();
                            $datos = $datos->first_row()->doc_numero.'|'.$datos->last_row()->doc_numero;
                            //print_r($datos);
                        break;
                        #   GET CONTEO NUMERO
                        case 2.2:
                            $where = implode(' AND ', [
                                '(idlibro = '.$extra['idlibro'].')',
                                '(idanomes = '.$extra['idam'].')',
                                '(doc_fecha = "'.$extra['fecha'].'")',
                                '(doc_serie = "'.$extra['serie'].'")',
                            ]);
                            $order = implode(', ', [
                                'CAST(doc_numero AS UNSIGNED) ASC',
                            ]);
                            $this->db_b->select('CONCAT(idrec, ":", doc_numero) AS doc_numero');
                            $this->db_b->from('iva_'.$extra['tabla']);
                            $this->db_b->where($where);
                            $this->db_b->order_by($order);
                            $datos = $this->db_b->get();
                            $datos = $datos->first_row()->doc_numero.'|'.$datos->last_row()->doc_numero;
                            //print_r($datos);
                        break;
                    #-
                    #   CONSOLIDADO
                    case 3:
                        $group = implode(', ', [
                            'idlibro'
                        ]);
                        $where = implode(' AND ', [
                            '(idlibro = '.$extra['idlibro'].')',
                            '(idanomes = '.$extra['idam'].')'
                        ]);
                        $select = implode(', ', [
                            'SUM(valor0) as valor0',
                            'SUM(valor1) as valor1',
                            'SUM(valor2) as valor2',
                            'SUM(valor3) as valor3',
                            'SUM(valor4) as valor4',
                            'SUM(valor5) as valor5',
                            'SUM(valor6) as valor6',
                            'SUM(valor7) as valor7',
                            'SUM(valor8) as valor8',
                            'SUM(valor9) as valor9',
                            'SUM(valor10) as valor10',
                            'SUM(valor11) as valor11',
                            'SUM(valor12) as valor12',
                            'SUM(valor13) as valor13',
                            'SUM(valor14) as valor14',
                            'SUM(valor15) as valor15',
                            'SUM(valor16) as valor16',
                            'SUM(valor17) as valor17',
                            'SUM(valor18) as valor18',
                            'SUM(valor19) as valor19',
                            'SUM(valor20) as valor20',
                        ]);
                        $this->db_b->select($select);
                        $this->db_b->from('iva_'.$extra['tabla']);
                        $this->db_b->where($where);
                        $this->db_b->group_by($group);
                        $datos = $this->db_b->get()->row();
                    break;
                    #   REPORTE LIBRO 2-3
                        case 4:
                            $where = implode(' AND ', [
                                '(a.idlibro = '.$extra['idlibro'].')',
                                '(a.idanomes = '.$extra['idam'].')'
                            ]);
                            if ($extra['idlibro'] == 2) {
                                $group = implode(', ', [
                                    'a.idcentro', 'a.idrec'
                                ]);
                            }
                            $order = implode(', ', [
                                //'a.doc_fecha ASC'
                                'a.idrec ASC'
                            ]);
                            $this->db_b->select('a.*, CONCAT(a.doc_serie, a.doc_numero) AS numDocumento, b.descrip as cliente, b.nrc, c.doc_clase, c.doc_tipo');
                            $this->db_b->from('iva_'.$extra['tabla'].' a');
                            $this->db_b->join('ctauxi b', 'a.idcps = b.idauxi');
                            $this->db_b->join('iva_def c', 'c.ivclase = a.ivclase');

                            $this->db_b->where($where);
                            if ($extra['idlibro'] == 2) {
                                $this->db_b->group_by($group);
                            }
                            $this->db_b->order_by($order);
                            $datos = $this->db_b->get();
                        break;
                    #-
                    default:
                        $datos = false;
                    break;
                }
                return $datos;
            }
        }

        #------------
        public function test()
        {
            /*$this->db_b->where('pnumero', 34);
            $this->db_b->delete('ct_100');
            $this->db_b->where('pnumero', 34);
            $this->db_b->delete('ct_100d');
            $this->db_b->where('pnumero', 35);
            $this->db_b->delete('ct_100');
            $this->db_b->where('pnumero', 35);
            $this->db_b->delete('ct_100d');
            $this->db_b->where('pnumero', 33);
            $this->db_b->delete('ct_100');
            $this->db_b->where('pnumero', 33);
            $this->db_b->delete('ct_100d');//*/
            /*$this->db_b->where('idmenu = 13 OR idmenu = 14');
                    $this->db_b->delete('posm_100');
            /*$this->db_b->where('idmenu', 5);
                    $this->db_b->delete('posm_100');//*/
        }
        public function multiOpciones($opc, $extra = null)
        {
            if($this->validatePermiso()) {
                switch ($opc) {
                    case 1:#    CONSULTA RAPIDA
                        //$this->db_b->db_debug = true;
                        //$datos = $this->db_b->query($extra);
    
                        $datos = $this->db_b->simple_query($extra);
                        if ($datos) {
                            $datos = $this->db_b->query($extra);
                        } else {
                            if ($this->db_b->error()['code'] == 1146) {#    TABLE DOESN'T EXISTS
                                #   BUSCAR EN CRM
                                $CI =& get_instance();
                                $this->db_b = $CI->load->database('default', TRUE);
                        
                                $this->load->dbutil($this->db_b);
                                if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                                    echo 'Incorrect database information provided';
                                }
                                $datos = $this->db_b->query($extra);
                            } else $datos = $this->db_b->query($extra);
                        }//*/
                        if ($datos->num_rows() > 0) $datos = $datos->result();
                        else $datos = [];
                    break;
                    case 2:#    GET ALL TABLES
                        $datos = $this->db_b->list_tables();
                    break;
                    case 3:#    GET ESTRUCTURA DE TABLA
                        $datos = $this->db_b->field_data($extra);
                    break;
                    default:$datos = false;break;
                }
                return $datos;
            }
        }

        function getDetalleOI($idrec) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.descrip, a.referencia, a.notas AS concepto, ABS(a.valorusr) AS valor, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus, a.numz, a.numx, a.idcaja');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.idrec", $idrec);
                $result = $this->db_b->get()->row_array();
                return $result;
            }
        }
        
        ##REPORTES VENTAS DIARIAS

        function getIngresosOI($idcaja, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.fechahora, a.descrip, a.referencia, a.notas AS concepto, ABS(a.valorusr) AS valor, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.tipo", 11);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.fechahora >=", $fechaini);
                $this->db_b->where("a.fechahora <=", $fechafin);
                
                $result = $this->db_b->get()->result_array();
                return $result;
            }
        }

        function getEgresosOI($idcaja, $idcentro, $fechaini, $fechafin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idrec, a.ingresa, a.fechahora, a.descrip, a.referencia, a.notas AS concepto, ABS(a.valorusr) AS valor, b.descrip AS namePago, c.descrip AS nameIngreso, a.estatus');
                $this->db_b->from("tran_100z a");
                $this->db_b->join("caj_def b", 'b.cajclase = a.cajclase');
                $this->db_b->join("caj_def c", 'c.cajclase = a.referencia');
                $this->db_b->where("a.tipo", 12);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.fechahora >=", $fechaini);
                $this->db_b->where("a.fechahora <=", $fechafin);
                
                $result = $this->db_b->get()->result_array();
                return $result;
            }
        }

        function getTiposOI($idcaja, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.tipo, c.descrip AS nameIngreso FROM tran_100z a INNER JOIN caj_def c ON c.cajclase = a.referencia WHERE a.idcaja = $idcaja AND a.idcentro = $idcentro AND a.fechahora >= '$fechaini' AND a.fechahora <= '$fechafin' GROUP BY c.descrip";                
                $query = $this->db_b->query($consulta);
                $result = $query->result_array();

                return $result;
            }
        }

        ## ANEXOS COTIZACION
        function getAnexosCotizacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("orders_100a a");
                $this->db_b->where("trannum", $trannum);
                
                $result = $this->db_b->get()->result_array();
                return $result;
            }
        }

        // 31/1/22
        // rep ventas diarias
        // modelo: ventas_model
        public function peticionesVentasDiarias($tipo, $datos,$trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($tipo == "modifica"){
                    $infoQuery = "UPDATE tran_100 INNER JOIN tran_100c ON tran_100c.trannum = tran_100.trannum  SET ";
                    $ultimo = array_key_last($datos); //ultimo dato de la lista
                    foreach($datos as $key=>$dato){
                        if ($key === $ultimo) {
                            $infoQuery .= $dato["key"]."='".$dato["value"]."'";
                        } else{
                            $infoQuery .= $dato["key"]."='".$dato["value"]."', ";
                        }
                    }

                    $infoQuery .= " WHERE tran_100.trannum=" . $trannum;

                }elseif($tipo == "genera"){
                    $infoQuery = "UPDATE tran_100c SET ";
                    $ultimo = array_key_last($datos); //ultimo dato de la lista
                    foreach($datos as $key=>$dato){
                        if ($key === $ultimo) {
                            $infoQuery .= $dato["key"]."='".$dato["value"]."'";
                        } else{
                            $infoQuery .= $dato["key"]."='".$dato["value"]."', ";
                        }
                    }

                    $infoQuery .= " WHERE trannum=" . $trannum;
                }
                
				var_dump($infoQuery);
				
				//echo $resultado;
			}
        }
        function getDatosFacturaciones($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja = str_replace("_", " OR t100.idcaja = ", $idcaja);

                $consulta = "SELECT t100.trannum, t100.ingresa, t100.notas, t100.fecha, t100.numx, t100.numz, t100.fecact, t100.estatus, t100.serie, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.nit, ctaucli.descrip AS namecliente, t100.idcps as idclienteauxi, IFNULL(ctauximulti.descrip, ctaucli.descrip) AS namesucursal, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valcosto, t100.valtax1,invdef.caopera,invdef.exento, t100.referencia, 
                d.serie AS dev_serie, d.numero AS dev_numero, ctcajas.descrip AS namecaja, users.descrip AS user, t100.origen
                FROM tran_100 AS t100 
                INNER JOIN ctcajas ON t100.idcaja = ctcajas.idcaja 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi
                INNER JOIN gusers AS users ON t100.whodidit = users.iduser 
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi 
                LEFT JOIN ctauximulti ON t100.idcentrod = ctauximulti.idrec 
                LEFT JOIN tran_100 d ON t100.tranref = d.trannum 
                WHERE invdef.agrupa = '$agrupa' AND t100.idcentro = $idcentro AND (t100.idcaja = $idcaja) AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecact, t100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        // 3/2/22
        // compras locales
        // modelo: compras_model
        function getListadoOrdenes($agrupa, $tipopro, $idcentro, $fechaini, $fechafin, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereSQL = ($estado == 0) ? "AND tran_100.estatus = 0" : "AND tran_100.estatus != 0 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'";

                $consulta = "SELECT tran_100.*, date_format(tran_100.fecha,'%d/%m/%Y') as fecha1, date_format(tran_100.fecact,'%d/%m/%Y') as fecha2, tran_100.fecha as fecha3 , tran_100.fecact as fecha4,  
                            ctauxi.descrip, ctauxi.idauxi as idproveedor , gusers.descrip as username, inv_def.descrip AS documento
                            FROM tran_100 
                            INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase 
                            INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN gusers ON tran_100.whodidit = gusers.iduser
                            WHERE inv_def.agrupa = '$agrupa' 
                            AND inv_def.inopera = 1 
                            AND tran_100.tranref = 0 
                            AND tran_100.referencia = '$tipopro' 
                            AND tran_100.idcentro = $idcentro ".$whereSQL." ";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }

        // 4/2/22
        // cambios agrupacion tickets
        // modelo: media_model
        function insertService($idnivel1,$descrip,$grupo,$detalle,$facturable,$imprimible,$visible,$prioridad,$valor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('idgestion',0);
                $this->db_b->set('nivel',2);
                $this->db_b->set('idnivel1',$idnivel1);
                $this->db_b->set('descrip',$descrip);
                $this->db_b->set('links',$detalle);
                $this->db_b->set('prioridad',$prioridad);
                $this->db_b->set('facturable',$facturable);
                $this->db_b->set('valor', $valor);
                $this->db_b->set('printable',$imprimible);
                $this->db_b->set('closeon',0);
                $this->db_b->set('grupo',$grupo);
                $this->db_b->set('visibletoclient',$visible);
                $this->db_b->set('report',1);
                $this->db_b->set('estado',1);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('service_types');
            }    

        }
        
        function updateService($idgestion,$descrip,$grupo,$detalle,$facturable,$imprimible,$visible,$prioridad,$valor,$estado,$nivel1){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('descrip',$descrip);
                $this->db_b->set('links',$detalle);
                $this->db_b->set('facturable',$facturable);
                $this->db_b->set('printable',$imprimible);
                $this->db_b->set('prioridad',$prioridad);
                $this->db_b->set('valor',$valor);
                $this->db_b->set('grupo',$grupo);
                $this->db_b->set('estado',$estado);
                $this->db_b->set('visibletoclient',$visible);
                $this->db_b->set('idnivel1',$nivel1);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idgestion',$idgestion);
                $query = $this->db_b->update('service_types');

                return $query;
            }    

        }

        // 5/2/2
        // cambiar itemline
        // model: ventas_model
        function updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv, $itemline, $descuento, $olditemline){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('um', $um);
                $this->db_b->set('uniconv', $uniconv);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('cantrp', $descuento);
                $this->db_b->set('precioneto', $precio);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('orders_100k');

                $updateItemline = "UPDATE orders_100k SET itemline = 
                CASE 
                    WHEN itemline = $olditemline THEN
                       $itemline
                    WHEN $itemline < $olditemline AND itemline < $olditemline THEN
                       itemline + 1
                    WHEN $itemline > $olditemline AND itemline > $olditemline THEN
                       itemline - 1
                    END
                WHERE itemline BETWEEN LEAST($itemline, $olditemline) AND GREATEST($itemline, $olditemline) AND trannum = $idtrannum";
                $query = $this->db_b->query($updateItemline);
				
				$SQLDatos = "SELECT SUM(orders_100k.cantidad * orders_100k.precioneto) AS TotalSum FROM orders_100k WHERE orders_100k.trannum = $idtrannum";
                $SQLDQuery = $this->db_b->query($SQLDatos);
                $SQLResult = $SQLDQuery->row_array();
                
                $this->db_b->set('val_pro', $SQLResult['TotalSum']);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $idtrannum);
                $query2 = $this->db_b->update('orders_100');
				return  $query;
			}
		}

        // 10/2/22
        // mantenimiento gastos

        function getAuxiByUseAuxi($useaxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db->select('idauxi, descrip');
                $this->db->where('find_in_set(idaxui, "'.$useaxi.'") <> ""');
                $this->db->from('ctauxi');
                $query = $this->db->get()->result_array();

                return $query;
            }       
        }

        // 04/04/22
        // anexos cotizacion ordenes
        public function getListadoAnexos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("wo_anexos");
                $resultado = $this->db_b->get()->result_array();

                return $resultado;
            }
        }

        public function adicionarAnexo($datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('contenido', $datos['contenido']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);

                $resultado = $this->db_b->insert('wo_anexos');
                return $resultado;
            }
        }

        public function modificarAnexo($idanexo, $datos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($datos['estatus']=='true'){
                    $datos['estatus'] = 1;
                }else{
                    $datos['estatus'] = 0;
                }

                $this->db_b->set('descrip', $datos['descrip']);
                $this->db_b->set('contenido', $datos['contenido']);
                $this->db_b->set('estatus', $datos['estatus']);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idanexo', $idanexo);
 
                $resultado = $this->db_b->update('wo_anexos');
                return $resultado;
            }
        }

        public function getCotizacionAnexos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idanexos');
                $this->db_b->from("wo_100");
                $this->db_b->where("trannum", $trannum);
                $resultado = $this->db_b->get()->row_array();
                $anexos = explode(",", $resultado['idanexos']);
                $arrayAnexos = [];
                $i=0;

                if($anexos){
                    foreach($anexos as $anexo){
                        $this->db_b->select('idanexo, descrip, contenido');
                        $this->db_b->from("wo_anexos");
                        $this->db_b->where("idanexo", $anexo);
                        $resultado = $this->db_b->get()->row_array();

                        $arrayAnexos[$i] = array(
                            "idanexo" => $resultado['idanexo'],
                            "descrip" => $resultado['descrip'],
                            "contenido" =>$resultado['contenido'],
                            "posicion" => $i+1,
                        );
                        $i++;
                    }
                    
                }else{
                    return false;
                }
                return $arrayAnexos;
            }
        }

        public function getProductList($limite){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('*');
                $this->db_b->from("invproducts");
                $this->db_b->limit($limite);
                $resultado = $this->db_b->get()->result_array();

                return $resultado;
            }
        }
        
        // 18/02/2023
        // Valorizacion de inventario
        function getSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $consultaSQL = "SELECT idcentro AS id, descrip, gv.descripcion AS grupo FROM invsites INNER JOIN gvars AS gv ON tipo = gv.valor_num AND gv.nombre = 'gv_tipo' WHERE estatus = 1";
                $infoQuery   = $this->db_b->query($consultaSQL);
                
                $infoCentros = $infoQuery->result_array();
                
                array_unshift($infoCentros, ['id' => "0", 'descrip' => '--TODOS--', 'grupo' => '--TODOS--']);
                
                return $infoCentros;
            }
        }

        public function getInventarioValorizadoProducto($fechafin, $sucursal, $offset){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('d.descrip AS departamento, c.descrip AS linea, a.idproducto, a.descrip AS nameProducto, a.marca, a.modelo');
                $this->db_b->select('a.barcode, a.xpos, a.um, a.costounitario, a.precioventa');
                $this->db_b->from('invproducts a');
                // $this->db_b->join('inv_batch   b', 'b.idproducto = a.idproducto');
                $this->db_b->join('invcatalog  c', 'c.idcatalogo = a.idcatalogo');
                $this->db_b->join('invcatalog  d', 'd.idcatalogo = c.idnivel1');
                $this->db_b->where('a.estado', '1');
                $this->db_b->where('a.tipo',   '1');
                $this->db_b->order_by('a.descrip', 'ASC');
                if($offset == 0){
                    $this->db_b->limit(500);
                }else{
                    $this->db_b->limit(500, $offset);
                }
                $query = $this->db_b->get();

                $arrayResp = array();
                if ($query->num_rows() > 0 ){
                    $infoCentros = $query->result();
                    // echo 'Tamaño del json '.$jsonLength;
                
                    foreach($infoCentros as $info) {
                        $arrayResp[] = array(
                            'departamento'  => $info->departamento,
                            'linea'         => $info->linea,
                            'idproducto'    => $info->idproducto,
                            'nameProducto'  => $info->nameProducto,
                            'marca'         => $info->marca,
                            'modelo'        => $info->modelo,
                            'barcode'       => $info->barcode,
                            'xpos'          => $info->xpos,
                            'um'            => $info->um,
                            'costounitario' => $info->costounitario,
                            'precioventa'   => $info->precioventa,
                            'inventario'    => $this->getInventarioValorizadoProductoSumas($info->idproducto, $fechafin, $sucursal)
                        );
                    }
                }
                
                return $arrayResp;
            }
        }
        
        public function getCantidadItemsProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('d.descrip AS departamento, c.descrip AS linea, a.idproducto, a.descrip AS nameProducto, a.marca, a.modelo');
                $this->db_b->select('a.barcode, a.xpos, a.um, a.costounitario, a.precioventa');
                $this->db_b->from('invproducts a');
                $this->db_b->join('invcatalog  c', 'c.idcatalogo = a.idcatalogo');
                $this->db_b->join('invcatalog  d', 'd.idcatalogo = c.idnivel1');
                $this->db_b->where('a.estado', '1');
                $this->db_b->where('a.tipo',   '1');
                $this->db_b->order_by('a.descrip', 'ASC');
                $query = $this->db_b->get();

                if ($query->num_rows() > 0 ){
                    return $query->num_rows();
                }
            }
        }

        public function getInventarioValorizadoProductoSumas($idproducto, $fechafin, $sucursal){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('SUM(a.cantidad * a.uniconv) AS inventario');
                $this->db_b->from('tran_100k a');
                $this->db_b->join('tran_100  b', 'a.trannum = b.trannum');
                $this->db_b->where('a.idproducto', $idproducto);
                $this->db_b->where('b.fecha <=', $fechafin);              
                
                if ($sucursal != 0) $this->db_b->where('b.idcentro', $sucursal);
                
                $this->db_b->group_by('a.idproducto');
                $query = $this->db_b->get();

                $infoSumProductos = 0;
                if($query->num_rows() > 0){
                    $infoSumProductos = $query->row()->inventario * 1;
                }
                
                return $infoSumProductos;
            }

        }

        // Mantenimiento dte_catalogo
        public function getDetCatalogo($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idrec, idcatalogo, codigo, descrip, tipo, estado, notas');
                $this->db_b->from('dte_catalog');
                $this->db_b->where('idcatalogo', $idcatalogo);

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoCatalogo = $query->result();
                    foreach($infoCatalogo as $info){
                        $arrayResp[] = array(
                            'idRec' => $info->idrec,
                            'idCatalogo' => $info->idcatalogo,
                            'codigo' => $info->codigo,
                            'descripcion' => $info->descrip,
                            'tipo' => $info->tipo,
                            'estado' => $info->estado,
                            'notas' => $info->notas
                        );
                    }
                }

                return $arrayResp;
            }
        }

        function getIdCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->distinct();
                $this->db_b->select('idcatalogo, tipo');
                $this->db_b->from('dte_catalog');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idcatalogo' => $info->idcatalogo,
                            'descrip' => trim($info->tipo) .' ('.$info->idcatalogo.')'
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function updateDetCatalogo($idrec, $idcatalogo, $descripcion, $codigo, $tipo, $notas, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($estado == 'true'){
                    $estadoUpdate = 1;
                }else{
                    $estadoUpdate = 0;
                }

                $this->db_b->set('idcatalogo', $idcatalogo);
                $this->db_b->set('codigo', $codigo);
                $this->db_b->set('descrip', $descripcion);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('estado', $estadoUpdate);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
 
                $resultado = $this->db_b->update('dte_catalog');
                return $resultado;
            }
        }

        function setDetCatalogo($idcatalogo, $descripcion, $codigo, $tipo, $notas, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                if($estado == 'true'){
                    $estadoUpdate = 1;
                }else{
                    $estadoUpdate = 0;
                }

                $this->db_b->set('idcatalogo', $idcatalogo);
                $this->db_b->set('codigo', $codigo);
                $this->db_b->set('descrip', $descripcion);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('estado', $estadoUpdate);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
 
                return $this->db_b->insert('dte_catalog');
            }
        }

        function deleteDetCatalogo($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->where('idrec', $idrec);
                $this->db_b->delete('dte_catalog');
            }
        }

        function getTipoById($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->distinct();
                $this->db_b->select('tipo');
                $this->db_b->from('dte_catalog');
                $this->db_b->where('idcatalogo', $idcatalogo);

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'tipo' => trim($info->tipo)
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        //Alter Table Function
        public function alterTable(){
            //CodeIgniter
            $fields = array(
                'nombreColumna' => array(
                    'name' => 'nombreColumna',
                    'type' => 'DOUBLE',
                ),
                'nombreColumna2' => array(
                    'name' => 'nombreColumna2',
                    'type' => 'DOUBLE',
                ),
                'nombreColumna3' => array(
                    'name' => 'nombreColumna3',
                    'type' => 'DOUBLE',
                ),
            );

            $this->db_b->modify_column('tran100k', $fields);

            //SQL Syntax
            $sqlQuery = 'ALTER TABLE tran100k MODIFY COLUMN nombreColumna DOUBLE';
            $this->db_b->query($sqlQuery);
        }

        //Mantenimiento generador pruebas
        function getDatosFacturacionesBitacora($agrupa, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja = str_replace("_", " OR t100.idcaja = ", $idcaja);
                $idcentro = implode(" OR t100.idcentro = ", $idcentro);
                $consulta = "SELECT t100.trannum, t100.ingresa, t100.notas, t100.fecha, t100.numx, t100.numz, t100.fecact, t100.estatus, t100.serie, t100.numero, CONCAT(t100.serie,t100.numero) AS numeroserie, invdef.invclase, invdef.descrip AS tipodoc, ctaucli.nrc AS registro, ctaucli.nit, ctaucli.descrip AS namecliente, t100.idcps as idclienteauxi, IFNULL(ctauximulti.descrip, ctaucli.descrip) AS namesucursal, ctaucli.idtipo, ctauemp.descrip AS namevendedor, t100.valventan, t100.valcosto, t100.valtax1,invdef.caopera,invdef.exento, t100.referencia, 
                d.serie AS dev_serie, d.numero AS dev_numero, ctcajas.descrip AS namecaja, invsites.descrip AS namecentro  
                FROM tran_100 AS t100 
                INNER JOIN ctcajas ON t100.idcaja = ctcajas.idcaja 
                INNER JOIN invsites ON ctcajas.idcentro = invsites.idcentro 
                INNER JOIN inv_def AS invdef ON t100.idclase = invdef.invclase 
                INNER JOIN ctauxi AS ctauemp ON t100.idworker = ctauemp.idauxi 
                LEFT JOIN ctauxi AS ctaucli ON t100.idcps = ctaucli.idauxi 
                LEFT JOIN ctauximulti ON t100.idcentrod = ctauximulti.idrec 
                LEFT JOIN tran_100 d ON t100.tranref = d.trannum 
                WHERE invdef.agrupa = '$agrupa' AND (t100.idcentro = $idcentro) AND (t100.idcaja = $idcaja) AND (invdef.caopera = 1 OR invdef.caopera = -1) AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY t100.fecact, t100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            } 
        }

        function getDatosPagosVentasTrannum($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT caj_def.descrip, tran_100c.notas AS notasPago FROM tran_100c INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase  WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
					$resultado = $query->result();
				}else{
					$resultado = false;
				}
                
                return $resultado;
            } 
		}

        function getTipoPagoRealiVenta($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ConsultaSql = "SELECT numy FROM tran_100 WHERE trannum = $trannum";
				$QuerySql = $this->db_b->query($ConsultaSql);
                $resultado = $QuerySql->row_array();
				$idclase = number_format($resultado['numy']);
				
				if($idclase != 0){
                    // $consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";

					$consulta = "SELECT caj_def.cajclase, caj_def.descrip, '' AS notasPago FROM caj_def INNER JOIN tran_100 ON tran_100.numy = caj_def.cajclase WHERE tran_100.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}else{
					$consulta = "SELECT caj_def.cajclase, caj_def.descrip, tran_100c.notas AS notasPago FROM caj_def INNER JOIN tran_100c ON tran_100c.cajclase = caj_def.cajclase WHERE tran_100c.trannum = $trannum LIMIT 1";
					$query = $this->db_b->query($consulta);
					$resultado = $query->result();
					return $resultado;
				}
			}
		}

        //Mantenimeinto ordenes de Ingreso
        function getCountOfContainers($startDate, $finishDate){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('agrupa','OI');
                $this->db_b->where('fecha >=', $startDate);
                $this->db_b->where('fecha <=', $finishDate);
                //$this->db_b->where('idcentro',$idcentro);
                $query = $this->db_b->get('orders_100');
                $resultado = $query->num_rows();
				return $resultado;
			}
        }

        function setOrdenIngreso($idcentro ,$containerNumber, $fecha, $packageQty, $totalWgt, $shippingInfo, $notas, $estado, $agrupa){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                //if($estado == 'true'){
                    //$estadoUpdate = 1;
                //}else{
                   //$estadoUpdate = 0;
                //}
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', $agrupa);
                $this->db_b->set('descrip', $notas);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('dev_direc', $shippingInfo);
                $this->db_b->set('referencia', $containerNumber);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('val_envio', $totalWgt);
                $this->db_b->set('val_otros', $packageQty);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('orders_100');

                $arrayResp = array();
                if($result){
                    $this->db_b->select('trannum, idcentro, agrupa, descrip, fecha ,dev_direc, referencia, estatus, val_envio, val_otros');
                    $this->db_b->from('orders_100');
                    $this->db_b->where('referencia', $containerNumber);

                    $query = $this->db_b->get();

                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $arrayResp[] = array(
                                'trannum' => $info->trannum,
                                'idcentro' => $info->idcentro,
                                'agrupa' => $info->agrupa,
                                'descrip' => $info->descrip,
                                'fecha' => $info->fecha,
                                'dev_direc' => $info->dev_direc,
                                'referencia' => $info->referencia,
                                'estatus' => $estado,
                                'val_envio' => $info->val_envio,
                                'val_otros' => $info->val_otros,
                            );
                        }
                    }
                }
            
            return $arrayResp;
            }
        }

        function getOrdenIngreso($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('trannum, idcentro, agrupa, descrip, fecha ,dev_direc, referencia, estatus, val_envio, val_otros');
                $this->db_b->from('orders_100');
                $this->db_b->where('agrupa', 'OI');
                $this->db_b->where('idcentro', $idcentro);
                $this->db_b->order_by('trannum','DESC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        if($info->estatus == 0){
                            $estado = 'Recibido';
                        }elseif($info->estatus == 1){
                            $estado = 'Revisado';
                        }else{
                            $estado = 'Completado';
                        }
                        $arrayResp[] = array(
                            'trannum' => $info->trannum,
                            'idcentro' => $info->idcentro,
                            'agrupa' => $info->agrupa,
                            'descrip' => $info->descrip,
                            'fecha' => $info->fecha,
                            'dev_direc' => $info->dev_direc,
                            'referencia' => $info->referencia,
                            'estatus' => $estado,
                            'val_envio' => $info->val_envio,
                            'val_otros' => $info->val_otros,
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function setRegistroPorBulto($trannum, $itemLine, $peso, $tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('trannum', $trannum);
                //$this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('tasa', $peso);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('orders_100ka');
            
            return $result;
            }
        }

        function getRegistrosPorBulto($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('a.idrec, a.trannum, a.itemline, a.tasa, a.ingresa, b.referencia, a.tipo');
                $this->db_b->from('orders_100ka a');
                $this->db_b->join('orders_100   b', 'b.trannum = a.trannum');
                $this->db_b->where('a.trannum', $trannum);
                $this->db_b->order_by('a.itemline','ASC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        //$arrayDate = explode(" ",$info->ingresa);
                        $arrayResp[] = array(
                            'idrec' => $info->idrec,
                            'trannum' => $info->trannum,
                            'itemline' => $info->itemline,
                            'tasa' => $info->tasa,
                            'fecha' => $info->ingresa,
                            'referencia' => $info->referencia,
                            'estatus' => $info->tipo
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function updatePackageWgt($idrec, $peso){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('tasa', $peso);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
 
                $resultado = $this->db_b->update('orders_100ka');
                return $resultado;
            }
        }

        function getRegistrosPorBultoLabels($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('orders_100ka.idrec as idrec, orders_100ka.trannum as trannum, orders_100ka.itemline as itemline, orders_100ka.tasa as tasa, orders_100ka.ingresa as ingresa, orders_100.referencia as referencia, gusers.descrip as whodidit');
                $this->db_b->from('orders_100ka');
                $this->db_b->join('orders_100', 'orders_100.trannum = orders_100ka.trannum');
                $this->db_b->join('gusers', 'gusers.iduser = orders_100.whodidit');
                $this->db_b->where('orders_100ka.trannum', $trannum);
                $this->db_b->order_by('orders_100ka.itemline','ASC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                
                return $infoQuery;
            }
        }

        function getIndividualRegistroPorBultoLabels($trannum, $itemline){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('orders_100ka.idrec as idrec, orders_100ka.trannum as trannum, orders_100ka.itemline as itemline, orders_100ka.tasa as tasa, orders_100ka.ingresa as ingresa, orders_100.referencia as referencia, gusers.descrip as whodidit');
                $this->db_b->from('orders_100ka');
                $this->db_b->join('orders_100', 'orders_100.trannum = orders_100ka.trannum');
                $this->db_b->join('gusers', 'gusers.iduser = orders_100.whodidit');
                $this->db_b->where('orders_100ka.trannum', $trannum);
                $this->db_b->where('orders_100ka.itemline', $itemline);
                //$this->db_b->order_by('orders_100ka.itemline','ASC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                
                return $infoQuery;
            }
        }

        //Mantenimiento ordenes de revisión
        function getInfoContainer($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('trannum, idcentro, agrupa, descrip, fecha ,dev_direc, referencia, estatus, val_envio, val_otros');
                $this->db_b->from('orders_100');
                $this->db_b->where('agrupa', 'OI');
                $this->db_b->where('idcentro', $idcentro);
                $this->db_b->where('estatus', 0);
                $this->db_b->order_by('trannum','DESC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'trannum' => $info->trannum,
                            'idcentro' => $info->idcentro,
                            'agrupa' => $info->agrupa,
                            'descrip' => $info->descrip,
                            'fecha' => $info->fecha,
                            'dev_direc' => $info->dev_direc,
                            'referencia' => $info->referencia,
                            'estatus' => $info->estatus,
                            'val_envio' => $info->val_envio,
                            'val_otros' => $info->val_otros,
                            //'items' => $this->getRegistrosPorBulto($info->trannum),
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function getProductGroups($idcentro, $idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                //$this->db_b->select('invcatalog.idcatalogo as idCat, invcatalog.descrip as catDescrip');
                //$this->db_b->from('invcatalog');
                //$this->db_b->join('invproducts','invcatalog.idcatalogo = invproducts.idcatalogo');
                //$this->db_b->where('invproducts.tipo', 1);
                //$this->db_b->where("idnivel1", $idcatalogo);
                //$this->db_b->order_by('invcatalog.descrip','ASC');

                $this->db_b->select("idcatalogo, descrip, procentro");
                $this->db_b->from("invcatalog");
                $this->db_b->where("idnivel1", $idcatalogo);
                $this->db_b->order_by("descrip", "ASC");

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idCatalogoPro' => $info->idcatalogo,
                            'descripcionPro' => $info->descrip,
                            //'items' => $this->getProducts($idcentro, $info->idCat),
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function getProducts($idcentro, $idcatalogo, $itemLine, $transNumber){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $sql = "SELECT
                invproducts.idcatalogo AS catalogID, invproducts.xpos, invproducts.tipotax, invproducts.costounitario AS costouni,
                invproducts.idproducto AS productID, invproducts.tipotax, invproducts.descrip AS productDesc , invproducts.marca, invproducts.presenta, 
                invproducts.imagen, invproducts.um as UM, invproducts.xpos, invproducts.modelo, invproducts.precioventa AS precioVenta,
                invproducts.barcode, invproducts.notas,
                IFNULL((SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.idproducto = invproducts.idproducto AND tran_100k.idcentro = $idcentro), 0) AS cantidad,
                IFNULL(inv_batch.costounitario, 0) AS costounitario
                FROM invproducts
                LEFT JOIN inv_batch ON inv_batch.idproducto = invproducts.idproducto
                WHERE invproducts.idcatalogo = $idcatalogo AND invproducts.tipo = 1";

                $query = $this->db_b->query($sql);

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'costoUnitario' => number_format(round($info->costouni, 2), 2,".","," ),
                            'idCatalog' => $info->catalogID,
                            'idProduct' => $info->productID,
                            'descrip' => $info->productDesc,
                            'precioVenta' => number_format(round($info->precioVenta, 2), 2,".","," ),
                            'cantidad' => $this->getProductQuantity($itemLine, $transNumber, $info->productID),
                            'um' => $info->UM,
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function getDepartments($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcatalogo, descrip, procentro, posicion');
                $this->db_b->from('invcatalog');
                $this->db_b->where('tipo', 1);
                $this->db_b->where('nivel', 1);
                $this->db_b->order_by('posicion', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idCatalogo' => $info->idcatalogo,
                            'descrip' => strtoupper($info->descrip),
                            'proCentro' => $info->procentro,
                            'items' => $this->getProductGroups($idcentro, $info->idcatalogo),
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function setPackageProducts($trannum, $itemLine, $idProduct, $descrip, $cantidad, $um, $precioNeto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('itemline', $itemLine);
                $this->db_b->set('idproducto', $idProduct);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('um', $um);
                $this->db_b->set('precioneto', $precioNeto);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('orders_100k');
            
            return $result;
            }
        }

        function getProductQuantity($itemLine, $transNumber, $productId){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('cantidad');
                $this->db_b->from('orders_100k');
                $this->db_b->where('itemline', $itemLine);
                $this->db_b->where('trannum', $transNumber);
                $this->db_b->where('idproducto', $productId);

                $query = $this->db_b->get();

                $result = 0;
                if($query->num_rows() > 0){
                    $infoQuery = $query->row();
                    if(isset($infoQuery)){
                        $result = $infoQuery->cantidad;
                    }
                }
                
                return $result;
            }
        }

        function updatePackageProductsOnDetails($trannum, $itemLine, $idProduct, $cantidad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('itemline', $itemLine);
                $this->db_b->where('idproducto', $idProduct);
                
                $resultado = $this->db_b->update('orders_100k');
                return $resultado;
            }
        }

        function deleteProductQtyOnDetails($trannum, $itemLine, $idProduct){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('itemline', $itemLine);
                $this->db_b->where('idproducto', $idProduct);
                
                $resultado = $this->db_b->delete('orders_100k');
                return $resultado;
            }
        }

        function getPackageInformation($trannum, $itemLine){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('a.idrec, a.trannum, a.itemline, a.idproducto, a.descrip, a.cantidad, a.um, a.precioneto, b.referencia, b.estatus');
                $this->db_b->from('orders_100k a');
                $this->db_b->join('orders_100  b', 'b.trannum = a.trannum');
                $this->db_b->where('a.itemline', $itemLine);
                $this->db_b->where('a.trannum', $trannum);

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idrec' => $info->idrec,
                            'trannum' => $info->trannum,
                            'itemline' =>$info->itemline,
                            'idproducto' => $info->idproducto,
                            'descrip' => $info->descrip,
                            'cantidad' => (int)$info->cantidad,
                            'um' => $info->um,
                            'referencia' => $info->referencia
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function updateProductQuantity($recNumber, $cantidad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('cantidad', $cantidad);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $recNumber);
                
                $resultado = $this->db_b->update('orders_100k');
                return $resultado;
            }
        }

        function deleteProducts($recNumber){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idrec', $recNumber);
                
                $resultado = $this->db_b->delete('orders_100k');
                return $resultado;
            }
        }

        function verifyIfProductsCanBeUpdated($idcentro, $trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('trannum, idcentro, agrupa, descrip, fecha ,dev_direc, referencia, estatus, val_envio, val_otros');
                $this->db_b->from('orders_100');
                $this->db_b->where('agrupa', 'OI');
                $this->db_b->where('idcentro', $idcentro);
                $this->db_b->where('trannum', $trannum);
                $this->db_b->order_by('trannum','DESC');

                $query = $this->db_b->get();

                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        if($info->estatus == 0){
                            $estado = 'Recibido';
                        }elseif($info->estatus == 1){
                            $estado = 'Revisado';
                        }else{
                            $estado = 'Completado';
                        }
                        $arrayResp[] = array(
                            'trannum' => $info->trannum,
                            'idcentro' => $info->idcentro,
                            'agrupa' => $info->agrupa,
                            'descrip' => $info->descrip,
                            'fecha' => $info->fecha,
                            'dev_direc' => $info->dev_direc,
                            'referencia' => $info->referencia,
                            'estatus' => $estado,
                            'val_envio' => $info->val_envio,
                            'val_otros' => $info->val_otros,
                        );
                    }
                }
                
                return $arrayResp;
            }
        }

        function updateContainerStatus($transNumber, $status){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('estatus', $status);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $transNumber);
                
                $resultado = $this->db_b->update('orders_100');
                return $resultado;
            }
        }

        function getPackageInformationLabels($trannum, $itemLine){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('orders_100k.idrec as idrec, orders_100k.trannum as trannum, orders_100k.itemline as itemline, orders_100k.idproducto as idproducto, orders_100k.descrip as descrip, orders_100k.cantidad as cantidad, orders_100k.um as um, orders_100k.ingresa as ingresa, orders_100k.whodidit as whodidit, orders_100.referencia as referencia, orders_100.estatus as estatus, invproducts.precioventa as precioventa, invproducts.marca as marca, invproducts.modelo as modelo');
                $this->db_b->from('orders_100k');
                $this->db_b->join('orders_100', 'orders_100.trannum = orders_100k.trannum');
                $this->db_b->join('invproducts', 'invproducts.idproducto = orders_100k.idproducto');
                $this->db_b->where('orders_100k.itemline', $itemLine);
                $this->db_b->where('orders_100k.trannum', $trannum);
                $this->db_b->where('orders_100k.cantidad >', 0);

                $query = $this->db_b->get();
                $arrayResp = array();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getProductPackageInformationLabels($trannum, $itemLine, $idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$this->db_b->distinct();
                $this->db_b->select('orders_100k.idrec as idrec, orders_100k.trannum as trannum, orders_100k.itemline as itemline, orders_100k.idproducto as idproducto, orders_100k.descrip as descrip, orders_100k.cantidad as cantidad, orders_100k.um as um, orders_100k.ingresa as ingresa, orders_100k.whodidit as whodidit, orders_100.referencia as referencia, orders_100.estatus as estatus, invproducts.precioventa as precioventa, invproducts.marca as marca, invproducts.modelo as modelo');
                $this->db_b->from('orders_100k');
                $this->db_b->join('orders_100', 'orders_100.trannum = orders_100k.trannum');
                $this->db_b->join('invproducts', 'invproducts.idproducto = orders_100k.idproducto');
                $this->db_b->where('orders_100k.itemline', $itemLine);
                $this->db_b->where('orders_100k.trannum', $trannum);
                $this->db_b->where('orders_100k.idproducto', $idproducto);
                $this->db_b->where('orders_100k.cantidad >', 0);

                $query = $this->db_b->get();
                $arrayResp = array();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function generarCompraPacas($trannum, $itemline, $nameContainer, $fecha, $proveedor, $idclase, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $centro = $this->session->userdata('idcentrouser');

                $this->db_b->trans_begin();
                
                $this->db_b->select('a.idproducto, a.cantidad, b.descrip, IF(a.precioneto = 0, CONVERT("0.01", DECIMAL(12,2)), a.precioneto) AS preciotran, b.um, (1) AS uniconv, b.tipotax AS tax1, a.notas');
                $this->db_b->from('orders_100k a');
                $this->db_b->join('invproducts b', 'a.idproducto = b.idproducto');
                $this->db_b->where('a.itemline', $itemline);
                $this->db_b->where('a.trannum', $trannum);
                $this->db_b->where('a.cantidad !=', 0);
                $infoQuery = $this->db_b->get();

                if ( $infoQuery->num_rows() > 0 ) {
                    $SQLResult = $infoQuery->result();
                }

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $centro);
                $this->db_b->set('idcps', $proveedor);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('serie', $nameContainer.str_pad('', (3 - strlen($itemline)), '0', STR_PAD_LEFT));
                $this->db_b->set('numero', $itemline);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('referencia', 1);
                $this->db_b->set('ivperiodo', 0);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100');

                $cTrannum = $this->db_b->insert_id();
                
                $this->db_b->select('idbin');
                $this->db_b->from('invlocations');
                $this->db_b->where('idcentro', $centro);
                $infoQueryBin = $this->db_b->get();
                
                $resultBin = $infoQueryBin->row_array();
                $idBin     = $resultBin['idbin'];
                
                $numItemline = 1;
                foreach ( $SQLResult as $datosTemp ) {
                    $SQLBatch = "SELECT IFNULL(inv_batch.idbatch, 0) AS idbatch, IFNULL(inv_batch.costounitario, 0) AS costounitario, 
                    FORMAT(IFNULL((SELECT SUM((tran_100k.cantidad * tran_100k.uniconv)) FROM tran_100k WHERE tran_100k.idproducto = inv_batch.idproducto),0), 4) AS Cantidad
                    FROM inv_batch WHERE inv_batch.idproducto = ".trim($datosTemp->idproducto);
                    $QueryBatch = $this->db_b->query($SQLBatch);

                    if($QueryBatch->num_rows() > 0){
                        $ResultBatch = $QueryBatch->row_array();
                        
                        $idBatch = $ResultBatch['idbatch'];
                        $costoUni = $ResultBatch['costounitario'];
                        $ResultBatch['Cantidad'] = str_replace(",", "", $ResultBatch['Cantidad']);
                        $batchCantidad = $ResultBatch['Cantidad']*1; //Convierte dato string a float

                        //CASO ESPECIAL: VERIFICA QUE LA CANTIDAD NO SEA -0 (CERO NEGATIVO)
                        if($this->is_negative_zero($batchCantidad)){
                            //EN CASO QUE SEA -0, IGUALA LA CANTIDAD A CERO
                            $batchCantidad = 0;
                        }

                        //COMPROBACION DE SALDO NEGATIVO
                        if($batchCantidad < 0){  
                            $this->db_b->trans_rollback();
                            return [false, "¡Error! El item con código de producto ". $datosTemp->idproducto ." posee un saldo negativo."];
                        }
                        
                        if($batchCantidad != 0){
                            $pValor = $costoUni * $batchCantidad;
                            $nCantidad = $datosTemp->uniconv * $datosTemp->cantidad;
                            $nCosto = $datosTemp->preciotran / $datosTemp->uniconv;
                            $sValor = $nCantidad * $nCosto;
                            $sumCantidad = $batchCantidad + $nCantidad;
                            $nuevoCosto = ($pValor + $sValor) / $sumCantidad;
                        }else{
                            $nuevoCosto = $datosTemp->preciotran / $datosTemp->uniconv;
                        }
                        
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idbatch', $idBatch);
                        $this->db_b->update('inv_batch');
                        
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idproducto', $datosTemp->idproducto);
                        $this->db_b->update('invproducts');                        

                        $valorUniconv = $datosTemp->uniconv;
                        if ( $valorUniconv == 0 ) {
                            $valorUniconv = 1;
                        }
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $cTrannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $numItemline);
                        $this->db_b->set('idcentro', $centro);
                        $this->db_b->set('idproducto', $datosTemp->idproducto);
                        $this->db_b->set('idbatch', $idBatch);
                        $this->db_b->set('idbin', $idBin);
                        $this->db_b->set('cantidad', $datosTemp->cantidad);
                        $this->db_b->set('um', $datosTemp->um);
                        $this->db_b->set('uniconv', $valorUniconv);
                        $this->db_b->set('costounitario', $nuevoCosto);
                        $this->db_b->set('preciotran', $datosTemp->preciotran);
                        $this->db_b->set('tax1', $datosTemp->tax1);
                        $this->db_b->set('notas', $datosTemp->notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }else{
                        $dateCompra = $date->format('Y-m-d');
                        $exDate = explode("-", $dateCompra);
                        $nameBatch = "B".$exDate[0].$exDate[1].$exDate[2];
                        
                        $nCosto = $datosTemp->preciotran / $datosTemp->uniconv;
                        $nuevoCantidad = $datosTemp->uniconv * $datosTemp->cantidad;
                        
                        $this->db_b->set('idbatch', 0);
                        $this->db_b->set('idproducto', $datosTemp->idproducto);
                        $this->db_b->set('descrip', $nameBatch);
                        $this->db_b->set('costounitario', $nCosto);
                        $this->db_b->set('ccompra', $nuevoCantidad);
                        $this->db_b->set('fcompra', $date->format('Y-m-d'));
                        $this->db_b->set('estado', 1);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('inv_batch');
                        $idBat = $this->db_b->insert_id();
                        
                        $this->db_b->set('costounitario', $nCosto);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('idproducto', $datosTemp->idproducto);
                        $this->db_b->update('invproducts');
                        
                        $valorUniconv = $datosTemp->uniconv;
                        if($valorUniconv == 0){
                            $valorUniconv = 1;
                        }
                        
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $cTrannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('itemline', $numItemline);
                        $this->db_b->set('idcentro', $centro);
                        $this->db_b->set('idproducto', $datosTemp->idproducto);
                        $this->db_b->set('idbatch', $idBat);
                        $this->db_b->set('idbin', $idBin);
                        $this->db_b->set('cantidad', $datosTemp->cantidad);
                        $this->db_b->set('um', $datosTemp->um);
                        $this->db_b->set('uniconv', $valorUniconv);
                        $this->db_b->set('costounitario', $datosTemp->preciotran);
                        $this->db_b->set('preciotran', $datosTemp->preciotran);
                        $this->db_b->set('tax1', $datosTemp->tax1);
                        $this->db_b->set('notas', $datosTemp->notas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('tran_100k');
                    }

                    $numItemline++;
                }

                $infoSQL   = "CALL totaliza100($cTrannum, 1)";
                $infoQuery = $this->db_b->query($infoSQL);

                if ($this->db_b->trans_status() === FALSE) {
                    $this->db_b->trans_rollback();
                    return [false, "¡Error! No se pudo cerrar la compra."];
                } else {
                    $this->db_b->set('tipo', 1);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('trannum', $trannum);
                    $this->db_b->where('itemline', $itemline);
                    $query = $this->db_b->update('orders_100ka');
                    
                    $this->db_b->trans_commit();
                    return [true, "Compra N°".$cTrannum." cerrada exitosamente."];
                }
            }
        }

        function is_negative_zero($x) {
            return $x ** -1 === -INF;
        }

        //La kachada etiquetas scan_job
        function getProductsOrderEspecificoOrderByItemLine($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('login/cerrar_sesion');
			}else{
				$consulta = "SELECT orders_100k.idproducto, orders_100k.cantidad, orders_100k.ingresa as ingresa, orders_100k.whodidit as whodidit,  IF(invproducts.modelo = '', '-', invproducts.modelo) as modelo ,  TRIM(invproducts.marca) AS marca, invproducts.idproducto, invproducts.precioventa, invproducts.pro_color, invproducts.presenta, invproducts.descrip, invproducts.um, invproducts.upp, invcatalog.descrip AS lineaProducto FROM orders_100k INNER JOIN invproducts ON orders_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invcatalog.idcatalogo = invproducts.idcatalogo  WHERE orders_100k.trannum = $trannum ORDER BY orders_100k.itemline ASC";
				$query = $this->db_b->query($consulta);
				if($query->num_rows()>0){
					$result = $query->result();
					return  $result;	
				}else{
					return false;
				}
			}
	    }

        //PDF Facturacion Electronica
        function electronicBills($trannum, $idYear = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $statusArr = array(1,9);
                //$this->db_b->limit(1);
                $this->db_b->select('json_doc, srecepcion, resp_mh, firma_json, estatus');
                $this->db_b->from('tran_100dte');
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where_in('estatus', $statusArr);
                $this->db_b->where('type', 'DOC');
                if ( $idYear != 0 ) {
                    $this->db_b->where('o_table', 'iva_'.$idYear);
                } else {
                    $this->db_b->where('o_table', 'tran_100');
                }
                
                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'jsonDoc' => json_decode($info->json_doc, true),
                            'sRecepcion' => $info->srecepcion,
                            'respHacienda' => json_decode($info->resp_mh, true),
                            'firmaJson' => $info->firma_json,
                            'status' => $info->estatus
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getMunicipioDTE($municipio, $departamento){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idzip, municipio');
                $this->db_b->from('gzips');
                $this->db_b->where('idmunidte', $municipio);
                $this->db_b->where('iddeptodte', $departamento);

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idzip' => $info->idzip,
                            'municipio' => $info->municipio
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getDepartamentoDTE($departamento){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idzip, depto');
                $this->db_b->from('gzips');
                $this->db_b->where('iddeptodte', $departamento);

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'idzip' => $info->idzip,
                            'depto' => $info->depto
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getCorreoFacturacionJSON($trannum, $idYear = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                if ($idYear == 0) {
                    $this->db_b->select('b.idauxi AS idcliente, b.correo, b.idtipo, b.dui as dui, IFNULL(b.descrip, "Nuevo Cliente") AS nameCliente, IFNULL(b.telefono, "") AS telefono');
                    $this->db_b->from('tran_100 a');
                    $this->db_b->join('ctauxi   b', 'a.idcps = b.idauxi', 'left');
                    $this->db_b->where("a.trannum", $trannum);
                } else {
                    $this->db_b->select('b.idauxi AS idcliente, b.correo, b.idtipo, b.dui as dui, IFNULL(b.descrip, "Nuevo Cliente") AS nameCliente, IFNULL(b.telefono, "") AS telefono');
                    $this->db_b->from('iva_'.$idYear.' a');
                    $this->db_b->join('ctauxi b', 'a.idcps = b.idauxi', 'left');
                    $this->db_b->where("a.idrec", $trannum);
                }
                
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->row();
                } else return false;
            }
        }

        function getTipoDocumentoTablaIVA($trannum, $idYear = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('b.doc_tipo, b.invclase, a.idcaja, a.idcentro, a.idcps');
                $this->db_b->from('iva_'.$idYear.' a');
                $this->db_b->join('iva_def b', 'b.ivclase = a.ivclase');
                $this->db_b->where('a.idrec', $trannum);

                $dato = $this->db_b->get();
                if($dato->num_rows() > 0){
                    return $dato->row();
                }else return false;
            }
        }

        function getCodeProductCliente($idProducto, $idCliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descrip');
                $this->db_b->from('invpromulti');
                $this->db_b->where('idproducto', $idProducto);
                $this->db_b->where('idgvar', 9);
                $this->db_b->where('idcps', $idCliente);

                $dato = $this->db_b->get();
                if($dato->num_rows() > 0){
                    return $dato->row()->descrip;
                }else return $idProducto;
            }
        }

        function getDeptoMuniDistritoDTE($idzip){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('municipio, depto, distrito');
                $this->db_b->from('gzips');
                $this->db_b->where('idzip', $idzip);
                $query = $this->db_b->get();

                $infoQuery = $query->result();

                return $infoQuery;
            }
        }

        function getGiroDTECliente($codActEconomica){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcatalogo, codigo, descrip');
                $this->db_b->from('dte_catalog');
                $this->db_b->where('idcatalogo', 'CAT-019');
                $this->db_b->where('codigo', $codActEconomica);
                $query = $this->db_b->get();

                $infoQuery = $query->result();
                
                return $infoQuery;
            }
        }

        //Confirma si se envio el correo elctronico
        function confirmMailIsSent($trannum, $idYear){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->set('email_send', 1);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $trannum);
                $this->db_b->where('estatus', 1);
                $this->db_b->where('type', 'DOC');
                if ( $idYear != 0 ) $this->db_b->where('o_table', 'iva_'.$idYear);
                
                $resultado = $this->db_b->update('tran_100dte');
                return $resultado;
            }
        }

        //Estado de Cuenta por Fechas
        function getEstadoCuentaSaldo($idcps, $fechaInicial){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                //$this->db_b->select_sum('((tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh)', 'saldo');
                $this->db_b->select_sum('(tran_100.valventan + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 ) + tran_100.valdh', 'saldo');
                $this->db_b->from('tran_100');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase');
                $this->db_b->join('ctauxi', 'tran_100.idcps = ctauxi.idauxi');
                $this->db_b->where('inv_def.agrupa', 'VN');
                $this->db_b->where('tran_100.estatus !=', 9);
                $this->db_b->where('tran_100.idcps', $idcps);
                $this->db_b->where('tran_100.ccestatus !=', 1);
                $this->db_b->where('tran_100.fecha <', $fechaInicial);

                $query = $this->db_b->get();
                $resultado = 0;
                
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $resultado = $info->saldo;
                    }
                }

                return $resultado;
            }
        }

        function getAbonosCargosClienteTotal($idcps, $fechaInicial){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);

                $data = $this->db_b->get();

                $resultado = 0;

                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;

                    $this->db_b->select_sum('(tran_100c.valor - tran_100c.vuelto)', 'valor');
                    $this->db_b->from('tran_100c');
                    $this->db_b->join('tran_100', 'tran_100c.trannum = tran_100.trannum');
                    $this->db_b->join('caj_def', 'tran_100c.cajclase= caj_def.cajclase');
                    $this->db_b->where('tran_100.estatus !=', 9);
                    $this->db_b->where('tran_100.idcps', $idcps);
                    $this->db_b->where('tran_100.numy', $cajclase );
                    $this->db_b->where('tran_100.ccestatus !=', 1);
                    $this->db_b->where('tran_100.fecha <', $fechaInicial);

                    $query = $query = $this->db_b->get();
                
                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $resultado = $info->valor;
                        }
                    }
                }
                return $resultado;
            }
        }

        function getEstadoCuenta($idcps, $fechaInicial, $fechaFinal){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                //$this->db_b->select('tran_100.trannum, tran_100.numero, tran_100.serie, DATE_FORMAT(tran_100.fecha, "%d/%m/%Y") AS fecha, DATEDIFF(NOW(), tran_100.fecha) AS dias, inv_def.descrip AS tipoDoc, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo');
                $this->db_b->select('tran_100.trannum, tran_100.numero, tran_100.serie, DATE_FORMAT(tran_100.fecha, "%d/%m/%Y") AS fecha, DATEDIFF(NOW(), tran_100.fecha) AS dias, inv_def.descrip AS tipoDoc, (SUM(tran_100.valventan + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 )) AS saldo');
                $this->db_b->from('tran_100');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase');
                $this->db_b->join('ctauxi', 'tran_100.idcps = ctauxi.idauxi');
                $this->db_b->where('inv_def.agrupa', 'VN');
                $this->db_b->where('tran_100.estatus !=', 9);
                $this->db_b->where('tran_100.idcps', $idcps);
                $this->db_b->where('tran_100.ccestatus !=', 1);
                $this->db_b->where('tran_100.fecha >=', $fechaInicial);
                $this->db_b->where('tran_100.fecha <=', $fechaFinal);
                $this->db_b->group_by('tran_100.trannum');
                $this->db_b->order_by('tran_100.fecha', 'ASC');

                $query = $this->db_b->get();
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getAbonosCargosCliente($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);
                $data = $this->db_b->get();
                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;
                    $consulta = "
                    SELECT  CONCAT(tran_100.serie,tran_100.numero) AS numeroserie, tran_100c.ingresa,  tran_100c.trannum, SUM(tran_100c.valor - tran_100c.vuelto) AS valor, tran_100c.descrip, tran_100c.fecha, caj_def.descrip as pagoDescrip FROM tran_100c
                    INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum
                    INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase 
                    WHERE tran_100.estatus != 9 AND tran_100.idcps = $idcps AND tran_100.numy = $cajclase 
                    GROUP BY tran_100c.idrec ORDER BY tran_100c.fecha,tran_100c.ingresa ASC";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return false;
                    }
                } else return false;
            }
        }

        #Formulario de Permisos por Ausencias
        function getInfoEmpleados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip, telefono, correo, direccion, idzip, nrc, dui, nit, grupo');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 3);
                $this->db_b->where('estado', 1);

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idauxi,
                            'descripcion' => $info->descrip,
                            'telefono' => $info->telefono,
                            'correo' => $info->correo,
                            'direccion' => $info->direccion,
                            'zip' => $info->idzip,
                            'nrc' => $info->nrc,
                            'dui' => $info->dui,
                            'nit' => $info->nit,
                            'grupo' => $info->grupo
                        );
                    }
                }
                return $arrayResp;
            }
        }

        #Project Manager
        function getInfoClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip, telefono, correo, direccion, idzip, nrc, dui, nit, grupo');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 2);
                $this->db_b->where('estado', 1);
                $this->db_b->order_by('descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => intval($info->idauxi),
                            'descripcion' => $info->descrip,
                            'telefono' => $info->telefono,
                            'correo' => $info->correo,
                            'direccion' => $info->direccion,
                            'zip' => $info->idzip,
                            'nrc' => $info->nrc,
                            'dui' => $info->dui,
                            'nit' => $info->nit,
                            'grupo' => $info->grupo
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getInfoEmp($cliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcontacto, idcps, nombre, cargo, telefono, email, notas');
                $this->db_b->from('pm_100c');
                $this->db_b->where('idcps', $cliente);
                //$this->db_b->where('estado', 1);
                $this->db_b->order_by('nombre', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idcontacto,
                            'codCliente' => intval($info->idcps),
                            'descripcion' => $info->nombre,
                            'cargo' => $info->cargo,
                            'telefono' => $info->telefono,
                            'email' => $info->email,
                            'notas' => $info->notas
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getInfoEmpInterno(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 3);
                $this->db_b->where('estado', 1);
                $this->db_b->order_by('descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idauxi,
                            'descripcion' => $info->descrip
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getPmClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps, ctauxi.descrip, ctauxi.nrc');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                //$this->db_b->where('idauxidef', 2);
                //$this->db_b->where('estado', 1);
                $this->db_b->group_by('pm_100.idcps');
                $this->db_b->order_by('ctauxi.descrip', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => $info->idcps,
                            'descripcion' => $info->descrip,
                            'nrc' => $info->nrc
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function getProjectsByService($idService, $idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                $this->db_b->where('pm_100.idcps', $idAuxi);
                $this->db_b->order_by('pm_100.fase', 'ASC');
                $this->db_b->order_by('pm_100.actividad', 'ASC');
                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getPhasesActivitiesByService($idService, $idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                //$this->db_b->where('pm_100.idcps', $idAuxi);
                $this->db_b->where('pm_100.idcps', 323);
                $this->db_b->group_by('pm_100.actividad');
                $this->db_b->group_by('pm_100.fase');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getAssignedToProject($assigned){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $assignedArray = explode(',', $assigned);
                $contacts = '';

                foreach($assignedArray as $assign){
                    $this->db_b->select('nombre');
                    $this->db_b->from('pm_100c');
                    $this->db_b->where('idcontacto', $assign);
    
                    $query = $this->db_b->get();
                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $contacts .= trim($info->nombre).', ';
                        }
                    }
                }

                $contacts = rtrim($contacts,", ");

                return $contacts;
            }
        }

        function getWorkerAssignedToProject($worker){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $workerArray = explode(',', $worker);
                $contacts = '';

                foreach($workerArray as $idworker){
                    $this->db_b->select('descrip');
                    $this->db_b->from('ctauxi');
                    //$this->db_b->where('idauxidef', 3);
                    //$this->db_b->where('estado', 1);
                    $this->db_b->where('idauxi', $idworker);
    
                    $query = $this->db_b->get();
                    if($query->num_rows() > 0){
                        $infoQuery = $query->result();
                        foreach($infoQuery as $info){
                            $contacts .= trim($info->descrip).', ';
                        }
                    }
                }

                $contacts = rtrim($contacts,", ");

                return $contacts;
            }
        }

        function setNewProject($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    $this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function setMultiProjects($idcps, $idservicio){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                //$alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                //if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                //}else {
                    //$result = false;
                //}
            
            return $result;
            }
        }

        function verifyIfProjectExists($idcps, $idservicio, $actividad){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idcps, idservicio, actividad');
                $this->db_b->from('pm_100');
                $this->db_b->where('idcps', $idcps);
                $this->db_b->where('idservicio', $idservicio);
                $this->db_b->where('actividad', $actividad);

                $query = $this->db_b->get();
                //$arrayResp = array();
                if($query->num_rows() > 0){
                    //$infoQuery = $query->result();
                    return true;
                }
                return false;
            }
        }

        function updateProject($idrec, $idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('idservicio', $idservicio);
                $this->db_b->set('fase', $fase);
                $this->db_b->set('actividad', $actividad);
                $this->db_b->set('asignadoa', $asignado);
                $this->db_b->set('idworker', $worker);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('fechaini', $fechaIni);
                $this->db_b->set('fechafin', $fechaFin);
                if($estado == 2 ) {
                    $this->db_b->set('fechadone', $fecha_actual);
                }
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $idrec);
                $result = $this->db_b->update('pm_100');
            
            return $result;
            }
        }

        function setNewActivity($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    $this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function setNewActivities($idcps, $idservicio, $fase, $actividad, $worker, $estado, $fechaIni, $fechaFin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $alreadyExists = $this->verifyIfProjectExists($idcps, $idservicio, $actividad);

                if($alreadyExists == false) {
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    
                    $this->db_b->set('idcps', $idcps);
                    $this->db_b->set('idservicio', $idservicio);
                    $this->db_b->set('fase', $fase);
                    $this->db_b->set('actividad', $actividad);
                    //$this->db_b->set('asignadoa', $asignado);
                    $this->db_b->set('idworker', $worker);
                    $this->db_b->set('estado', $estado);
                    $this->db_b->set('fechaini', $fechaIni);
                    $this->db_b->set('fechafin', $fechaFin);
                    //$this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    
                    $result = $this->db_b->insert('pm_100');
                }else {
                    $result = false;
                }
            
            return $result;
            }
        }

        function addContact($idcps, $nombre, $cargo, $telefono, $email, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('nombre', $nombre);
                $this->db_b->set('cargo', $cargo);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('email', $email);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('pm_100c');
            
            return $result;
            }
        }

        function updateContact($idContacto, $idcps, $nombre, $cargo, $telefono, $email, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcontacto', $idContacto);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('nombre', $nombre);
                $this->db_b->set('cargo', $cargo);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('email', $email);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idcontacto', $idContacto);
                $result = $this->db_b->update('pm_100c');
            
            return $result;
            }
        }

        function deleteContact($idContacto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idcontacto', $idContacto);
                
                $resultado = $this->db_b->delete('pm_100c');
                return $resultado;
            }
        }

        function deleteProject($recNumber){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idrec', $recNumber);
                
                $resultado = $this->db_b->delete('pm_100');
                return $resultado;
            }
        }

        function getSystemsOrServicesByClients($idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('idservicio, fechaini, fechafin');
                $this->db_b->from('pm_100');
                $this->db_b->where('idcps', $idAuxi);
                $this->db_b->where('estado', '!= 2');
                $this->db_b->group_by('idservicio');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getFilesByClient($idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('idrec, idrecpm100, idcps, descrip, archivo');
                $this->db_b->from('pm_100m');
                $this->db_b->where('idcps', $idAuxi);
                //$this->db_b->group_by('idservicio');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function insertFilesByClients($file_data){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->insert('pm_100m', $file_data);
            }
        }

        function deleteFilesByClient($file_data, $cliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('archivo', $file_data);
                $this->db_b->where('idcps', $cliente);
                return $this->db_b->delete('pm_100m');
            }
        }

        function insertAnexosFilesByClients($file_data){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->insert('pm_100n', $file_data);
            }
        }

        function deleteAnexosFilesByClient($file_data, $project){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->where('archivo', $file_data);
                $this->db_b->where('descrip', $project);
                return $this->db_b->delete('pm_100n');
            }
        }

        function getNameClienteReport($idCliente){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('descrip');
                $this->db_b->from('ctauxi');
                $this->db_b->where('idauxidef', 2);
                $this->db_b->where('estado', 1);
                $this->db_b->where('idauxi', $idCliente);

                $dato = $this->db_b->get();
                if($dato->num_rows() > 0){
                    return $dato->row()->descrip;
                }else return false;
            }
        }

        function getClientsReport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                $this->db_b->group_by('pm_100.idcps');
                $this->db_b->order_by('ctauxi.descrip', 'ASC');
                //$this->db_b->where('pm_100.idservicio', $idService);
                //$this->db_b->where('pm_100.idcps', $idAuxi);

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getPendingActivitiesByWorker($idWorker, $fechaInicial, $fechaFin) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.notas, ctauxi.descrip AS nCliente, gvars.descripcion AS nProyecto');
                $this->db_b->from('pm_100');
                $this->db_b->join('ctauxi', 'ctauxi.idauxi = pm_100.idcps');
                $this->db_b->join('gvars', 'gvars.valor_num = pm_100.idservicio AND gvars.nombre = "pm_tipos"');
                $this->db_b->where('fechaini >=', $fechaInicial);
                $this->db_b->where('fechaini <=', $fechaFin);
                $this->db_b->where('pm_100.estado', 0);
                $this->db_b->like('CONCAT(",",idworker,",")', ','.$idWorker.',');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getProjectsByServiceReports($idService, $idAuxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('pm_100.idrec, pm_100.idcps, pm_100.idservicio, pm_100.fase, pm_100.actividad, pm_100.asignadoa, pm_100.idworker, pm_100.estado, DATE_FORMAT(pm_100.fechaini, "%d/%m/%Y") as fechaini, DATE_FORMAT(pm_100.fechafin, "%d/%m/%Y") as fechafin, DATE_FORMAT(pm_100.fechadone, "%d/%m/%Y") as fechaCompletado, pm_100.notas');
                $this->db_b->from('pm_100');
                $this->db_b->where('pm_100.idservicio', $idService);
                $this->db_b->where('pm_100.idcps', $idAuxi);
                $this->db_b->where('pm_100.fase !=', '');
                $this->db_b->where('pm_100.actividad !=', '');
                $this->db_b->order_by('pm_100.fase', 'ASC');
                $this->db_b->order_by('pm_100.actividad', 'ASC');

                $query = $this->db_b->get();
                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                }
                return $infoQuery;
            }
        }

        function getNotesByClinet($idcps){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idrec, idcps, fecha, descrip, asignadoa, notas');
                $this->db_b->from('pm_100notes');
                $this->db_b->where('idcps', $idcps);
                $this->db_b->order_by('idrec', 'ASC');

                $query = $this->db_b->get();
                $arrayResp = array();
                if($query->num_rows() > 0){
                    $infoQuery = $query->result();
                    foreach($infoQuery as $info){
                        $arrayResp[] = array(
                            'codigo' => intval($info->idrec),
                            'cliente' => $info->idcps,
                            'fechaIngreso' => $info->fecha,
                            'tituloNota' => $info->descrip,
                            'asignadoa' => explode(',', $info->asignadoa),
                            'detalleNota' => $info->notas,
                        );
                    }
                }
                return $arrayResp;
            }
        }

        function addClientNotes($idcps, $titulo, $detalle, $fecha, $asignados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $titulo);
                $this->db_b->set('asignadoa', $asignados);
                $this->db_b->set('notas', $detalle);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                
                $result = $this->db_b->insert('pm_100notes');
            
            return $result;
            }
        }

        function updateClientNotes($notaCode, $idcps, $titulo, $detalle, $fecha, $asignados){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                //$this->db_b->set('idrec', $notaCode);
                $this->db_b->set('idcps', $idcps);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $titulo);
                $this->db_b->set('asignadoa', $asignados);
                $this->db_b->set('notas', $detalle);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                
                $this->db_b->where('idrec', $notaCode);
                $result = $this->db_b->update('pm_100notes');
            
            return $result;
            }
        }

        function deleteClientNotes($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->where('idrec', $idrec);
                
                $resultado = $this->db_b->delete('pm_100notes');
                return $resultado;
            }
        }

        function checkGiroDteField(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultado = $this->db_b->field_exists('dte_giro25', 'ctauxi');
                return $resultado;
            }
        }

        function getprojectdata(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $this->db_b->select('b.descrip AS nombre, a.notas AS Tipo, a.idcps as idcliente, a.fechaini');
                $this->db_b->from('pm_100 a');
                $this->db_b->join('ctauxi b', 'b.idauxi = a.idcps');
                $this->db_b->where('a.fase', '');
                $this->db_b->where('a.idservicio', 1);
                $this->db_b->where('a.estado <=', 1);
                $query = $this->db_b->get();

                $infoQuery = array();
                if($query->num_rows() > 0){
                    $infoResult = $query->result();
                    
                    foreach ($infoResult as $info) {
                        $infoQuery[] = array(
                            'cliente'  => $info->nombre,
                            'proyecto' => $info->Tipo,
                            'id_cliente'  => (int) $info->idcliente,
                            'fecha_ini'   => $info->fechaini,
                        );
                    }
                }
                return $infoQuery;
            }
        }

        function getListadoClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.*');
                $this->db_b->from('ctauxi a');
                $this->db_b->where("a.idauxidef", 2);
                $this->db_b->where("a.grupo", 'DONANTES');
                $this->db_b->order_by("a.descrip", "ASC");
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    return $datos->result();
                } else return false;
            }
        }

        function getCorrelativoComprobante(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select('a.serie, a.actual');
                $this->db_b->from('gnums a');
                $this->db_b->where("a.idrnum", 20);
                $datos = $this->db_b->get();
                return $datos->row()->serie.' '.(intval($datos->row()->actual) + 1);
            }
        }

        function insertarComprobanteDonacion($idcentro, $idcaja, $idauxi, $fecha, $numdoc, $tipodonacion, $concepto, $valorDonacion) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $numComp = explode(' ', $numdoc);
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idclase', 23);
                $this->db_b->set('idcentro', $idcentro[0]);
                $this->db_b->set('idcaja', $idcaja);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('serie', $numComp[0]);
                $this->db_b->set('numero', $numComp[1]);
                $this->db_b->set('notas', $tipodonacion);
                $this->db_b->set('valventan', $valorDonacion);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->insert('tran_100');
                $trannum = $this->db_b->insert_id();

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idclase', 23);
                $this->db_b->set('idcentro', $idcentro[0]);
                $this->db_b->set('idworker', $this->session->userdata('idEmpleadoUser'));
                $this->db_b->set('itemline', 1);
                $this->db_b->set('cantidad', 1);
                $this->db_b->set('um', 'UNIDAD');
                $this->db_b->set('notas', $concepto);
                $this->db_b->set('preciotran', $valorDonacion);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('tran_100k');
                
                return $trannum;
            }
        }

        function updateCorrelativoComprobante(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->db_b->select('a.serie, a.actual');
                $this->db_b->from('gnums a');
                $this->db_b->where("a.idrnum", 20);
                $datos = $this->db_b->get();
                $actual = (intval($datos->row()->actual) + 1);

                $this->db_b->set('actual', $actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrnum', 20);
                $result = $this->db_b->update('gnums');

                return $result;
            }
        }
    }
?>