<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Dev_api_model extends CI_Model{
		

        function __construct(){
            header('Access-Control-Allow-Origin: *'); 
            header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method"); 
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE"); 
            parent::__construct();
        }
        
        ################     USUARIOS     #################################
        function login($username, $password){
            $keyCifrado = '$EgGa8466-2$/';
            $nuevaContra = md5($keyCifrado . $password);  
            
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s"); 
            $date_exp = date("Y-m-d H:i:s", strtotime('+2 hours', strtotime($date_now)));  

            $this->db->select('iduser, idaccount, descrip, username, cargo');
            $this->db->from('sc_users');
            $this->db->where('password', $nuevaContra);
            $this->db->where('username', $username);
            $this->db->where('estado', 1);
            $this->db->limit(1);
            $QueryUser = $this->db->get();

            if($QueryUser->num_rows() > 0){
                $usuario = $QueryUser->row_array();
                $token = $this->generarToken($usuario, $keyCifrado, $date_now, $date_exp);

                $this->db->set('lastlogin', $date_now);
                $this->db->set('token', $token);
                $this->db->set('token_exp', $date_exp);
                $this->db->where('iduser', $usuario['iduser']);
                $this->db->update('sc_users');

                $poseeCuenta = $poseeSucursal = $poseeCaja = false;
                $poseeCuenta = $this->usuarioPoseeCuenta($usuario);
                if($poseeCuenta){
                    $poseeSucursal = $this->usuarioPoseeSucursal($usuario);

                    if($poseeSucursal){
                        $poseeCaja = $this->usuarioPoseeCaja($usuario);
                    }
                }
                header("HTTP/1.1 200 OK");
                return ['token'=>$token, 'poseeCuenta' => $poseeCuenta, 'poseeSucursal' => $poseeSucursal, 'poseeCaja' => $poseeCaja, 'usuario'=>$usuario];
            }else{
                header("HTTP/1.1 401 Unauthorized");
                return false;
            }
        }

        function registrarse($nombre, $email, $username, $password){
            $keyCifrado     = '$EgGa8466-2$/';
            $nuevaContra    = md5($keyCifrado . $password);

            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");        

            if($this->verificarDatosUnicosUsuario($username, $email)){
                $this->db->set('descrip', $nombre);
                $this->db->set('correo1', $email);
                $this->db->set('username', $username);
                $this->db->set('password', $nuevaContra);
                $this->db->set('estado', 1);
                $this->db->set('issuedate', $date_now);
                $this->db->set('ingresa', $date_now);
    
                $result = $this->db->insert('sc_users');
                if($result){
                    header("HTTP/1.1 200 OK");
                    $result = "registrado";
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
            }
            return $result;
        }

        function verificarDatosUnicosUsuario($username, $email){
            $this->db->select('1');
            $this->db->from('sc_users');
            $this->db->where('username', $username);
            $this->db->or_where('correo1', $email);
            $this->db->or_where('correo2', $email);
            $this->db->limit(1);
            $Query = $this->db->get();

            if($Query->num_rows() == 0){
                return true;
            }else{
                return false;
            }
        }

        function enviarCorreoValidacion($correo){

        }

        function usuarioPoseeCuenta($usuario){
            $this->db->select('1 as result');
            $this->db->from('sc_users');
            $this->db->where('iduser',  $usuario['iduser']);
            $this->db->where('idaccount !=',  '');
            $Query = $this->db->get()->row_array();
            if($Query['result'] === '1'){
                return true;
            }
            return false;
        }
        function usuarioPoseeSucursal($usuario){
            $this->db->select('1 as result');
            $this->db->from('sc_sucs');
            $this->db->where('idaccount',  $usuario['idaccount']);
            $Query = $this->db->get()->row_array();
            if($Query['result'] === '1'){
                return true;
            }
            return false;
        }
        function usuarioPoseeCaja($usuario){
            $this->db->select('1 as result');
            $this->db->from('sc_cajas');
            $this->db->where('idaccount',  $usuario['idaccount']);
            $Query = $this->db->get()->row_array();
            if($Query['result'] === '1'){
                return true;
            }
            return false;
        }

        ################     TOKENS     #################################
        function generarToken($usuario, $keyCifrado, $date_now, $date_exp){
            $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
            $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));

            $payload = json_encode(['iduser'=>$usuario['iduser'], 'idaccount' => $usuario['idaccount'], 'descrip'=>$usuario['descrip'], 'username'=>$usuario['username'], 'cargo'=>$usuario['cargo'], 'fecha_login'=>$date_now, 'fecha_exp'=>$date_exp]);
            $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

            $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $keyCifrado, true);
            $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

            $token = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
            return $token;
        }

        function decodificarToken($token){
            return json_decode(base64_decode(str_replace('_', '/', str_replace('-','+',explode('.', $token)[1]))));
        }

        function validarToken($token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s"); 

            $tokenDec = $this->decodificarToken($token);
            if($date_now < $tokenDec->fecha_exp){
                return true;
            }
            return false;
        }

        ################     CUENTAS     #################################
        function listarZip($token){

            $this->db->select('idzip AS value, CONCAT(TRIM(municipio), "/", TRIM(depto)) AS label');
            $this->db->from('gzips');

            $result = $this->db->get();

            header("HTTP/1.1 200 OK");
            return $result->result_array();
        }
        function listarCuentas($iduser, $token){
            $tokenDec = $this->decodificarToken($token);
            $consulta = "SELECT sc.idaccount, sc.tipocliente, sc.descrip, sc.ncomercial, sc.correo, sc.moneda, sc.nit, sc.nrc, sc.giro, sc.telefono, sc.direccion, CONCAT(TRIM(zips.municipio), '/', TRIM(zips.depto)) AS ubicacion, sc.idzip 
                        FROM sc_cuentas sc
                        INNER JOIN gzips zips ON zips.idzip = sc.idzip 
                        INNER JOIN sc_users u ON u.idaccount = sc.idaccount 
                        WHERE u.iduser = $iduser
                        LIMIT 1
                        "; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->row_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }
        
        function crearCuenta($datosCuenta, $token){
            $duplicado = $this->verificarDatosUnicosCuenta($datosCuenta, $token);
            if($duplicado === ""){
                $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
                $date_now = $date_now->format("Y-m-d h:i:s");  
                $tokenDec = $this->decodificarToken($token);
                
                $this->db->set('idaccount', $datosCuenta['idaccount']);
                $this->db->set('tipocliente', $datosCuenta['tipocliente']);
                $this->db->set('descrip', $datosCuenta['descrip']);
                $this->db->set('ncomercial', $datosCuenta['ncomercial']);
                $this->db->set('correo', $datosCuenta['correo']);
                $this->db->set('moneda', $datosCuenta['moneda']);
                $this->db->set('nit', $datosCuenta['nit']);
                $this->db->set('nrc', $datosCuenta['nrc']);
                $this->db->set('giro', $datosCuenta['giro']);
                $this->db->set('telefono', $datosCuenta['telefono']);
                $this->db->set('direccion', $datosCuenta['direccion']);
                $this->db->set('idzip', $datosCuenta['idzip']);
                //$this->db->set('e_logo', $datosCuenta['e_logo']);
                $this->db->set('estado', 1);
                $this->db->set('whodidit', $tokenDec->iduser);
                $this->db->set('ingresa', $date_now);
    
                $result = $this->db->insert('sc_cuentas');
                if($result){
                    header("HTTP/1.1 200 OK");
                    $this->db->set('idaccount', $datosCuenta['idaccount']);
                    $this->db->where('iduser', $tokenDec->iduser);
                    $this->db->update('sc_users');

                    $result = "agregado";
                    $mensaje = "La cuenta se ha agregado exitosamente.";
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al agregar la cuenta.";
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $duplicado;
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje]);
        }

        function editarCuenta($datosCuenta, $token){
            $duplicado = $this->verificarDatosUnicosCuenta($datosCuenta, $token, "update");
            if($duplicado === ""){
                $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
                $date_now = $date_now->format("Y-m-d h:i:s");  
                $tokenDec = $this->decodificarToken($token);
                
                $this->db->set('tipocliente', $datosCuenta['tipocliente']);
                $this->db->set('descrip', $datosCuenta['descrip']);
                $this->db->set('ncomercial', $datosCuenta['ncomercial']);
                $this->db->set('correo', $datosCuenta['correo']);
                $this->db->set('moneda', $datosCuenta['moneda']);
                $this->db->set('nit', $datosCuenta['nit']);
                //$this->db->set('nrc', $datosCuenta['nrc']);
                $this->db->set('giro', $datosCuenta['giro']);
                $this->db->set('telefono', $datosCuenta['telefono']);
                $this->db->set('direccion', $datosCuenta['direccion']);
                $this->db->set('idzip', $datosCuenta['idzip']);
                //$this->db->set('e_logo', $datosCuenta['e_logo']);
                $this->db->set('modifica', $date_now);
                $this->db->where('idaccount', $datosCuenta['idaccount']);
    
                $result = $this->db->update('sc_cuentas');
                if($result){
                    header("HTTP/1.1 200 OK");
                    $result = "editado";
                    $mensaje = "La cuenta se ha editado exitosamente.";
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al editar la cuenta.";
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $duplicado;
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje]);
        }

        function verificarDatosUnicosCuenta($datosCuenta, $tipo = "create"){
            $mensaje = "";

            if($tipo === "create"){
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('descrip', $datosCuenta['descrip']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "La razón social ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('ncomercial', $datosCuenta['ncomercial']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre comercial ya está en uso. \n";
                }
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('correo', $datosCuenta['correo']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El correo electrónico ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('telefono', $datosCuenta['telefono']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El número de teléfono ya está en uso. \n";
                }

                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('nrc', $datosCuenta['nrc']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El número de registro ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('nit', $datosCuenta['nit']);
                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El NIT ya está en uso. \n";
                }

            }else if($tipo === "update"){
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('descrip', $datosCuenta['descrip']);
                $this->db->where('idaccount !=', $datosCuenta['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "La razón social ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('ncomercial', $datosCuenta['ncomercial']);
                $this->db->where('idaccount !=', $datosCuenta['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre comercial ya está en uso. \n";
                }
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('correo', $datosCuenta['correo']);
                $this->db->where('idaccount !=', $datosCuenta['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El correo electrónico ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('telefono', $datosCuenta['telefono']);
                $this->db->where('idaccount !=', $datosCuenta['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El número de teléfono ya está en uso. \n";
                }
    
                $this->db->select('1');
                $this->db->from('sc_cuentas');
                $this->db->where('nit', $datosCuenta['nit']);
                $this->db->where('idaccount !=', $datosCuenta['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El NIT ya está en uso. \n";
                }
            }
            return $mensaje;
        }

        ##################################       SUCURSALES      ##################################

        function listarSucursales($datosUsuario, $token){
            $idaccount = $datosUsuario['idaccount'];
            $consulta = "SELECT suc.idrnum, suc.idcentro, suc.descrip, suc.tipo, suc.notas, count(caja.idaccount) as countcaja, case suc.tipo
                                                                                                                                when 1 then 'Sala de Ventas'
                                                                                                                                when 2 then 'Oficina'
                                                                                                                                when 3 then 'Centro de Distribución'
                                                                                                                            end as tiponombre 
                        FROM sc_sucs AS suc
                        LEFT JOIN sc_cajas as caja ON caja.idcentro = suc.idcentro AND suc.idaccount = $idaccount AND caja.idaccount = $idaccount AND caja.estado = 1
                        WHERE suc.idaccount = $idaccount AND suc.estado = 1
                        GROUP BY  suc.idcentro
                        ORDER BY suc.idcentro"; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->result_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function listarSucursalesAll($datosUsuario, $token){
            $idaccount = $datosUsuario['idaccount'];
            $consulta = "SELECT idrnum, idcentro, descrip, tipo, notas, case tipo
                                                                            when 1 then 'Sala de Ventas'
                                                                            when 2 then 'Oficina'
                                                                            when 3 then 'Centro de Distribución'
                                                                        end as tiponombre 
                        FROM sc_sucs
                        WHERE idaccount = $idaccount
                        ORDER BY idcentro"; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->result_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function listarSucursalesSelect($datosUsuario){
            $idaccount = $datosUsuario['idaccount'];
            $consulta = "SELECT idcentro AS value, descrip AS label 
                        FROM sc_sucs
                        WHERE idaccount = $idaccount AND estado = 1
                        ORDER BY idcentro"; 
                        
            $query = $this->db->query($consulta);

            header("HTTP/1.1 200 OK");
            return $query->result_array();
        }
        
        function crearSucursal($datosUsuario, $datosSucursal, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  
            $tokenDec = $this->decodificarToken($token);
            
            $datosUnicos = $this->verificarDatosUnicosSucursal($datosUsuario, $datosSucursal, "create");
            if($datosUnicos['valido']){
                $this->db->set('idaccount', $datosSucursal['idaccount']);
                $this->db->set('descrip', $datosSucursal['descrip']);
                $this->db->set('notas', $datosSucursal['notas']);
                $this->db->set('tipo', $datosSucursal['tipo']);
                $this->db->set('idcps', $datosSucursal['idcps']);
                $this->db->set('whodidit', $datosUsuario['iduser']);
                $this->db->set('ingresa', $date_now);
                $this->db->set('estado', 1);

                $result = $this->db->insert('sc_sucs');
                $id = $this->db->insert_id();
                
                if($result){
                    $this->db->select('COUNT(idaccount) as idcentro');
                    $this->db->from('sc_sucs');
                    $this->db->where('idaccount', $datosSucursal['idaccount']);

                    $this->db->limit(1);
                    $query = $this->db->get()->row_array();

                    $this->db->set('idcentro', (int)$query['idcentro']);
                    $this->db->from('sc_sucs');
                    $this->db->where('idrnum', $id);
                    $this->db->update('sc_sucs');

                    header("HTTP/1.1 200 OK");
                    $result = "agregado";
                    $mensaje = "La sucursal se ha agregado exitosamente.";
                    $datos = true;
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al agregar la sucursal.";
                    $datos = false;
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $datosUnicos['mensaje'];
                $datos = false; 
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }

        function editarSucursal($datosUsuario, $datosSucursal, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  
            $tokenDec = $this->decodificarToken($token);
            
            $datosUnicos = $this->verificarDatosUnicosSucursal($datosUsuario, $datosSucursal, "update");
            if($datosUnicos['valido']){
                $this->db->set('descrip', $datosSucursal['descrip']);
                $this->db->set('tipo', $datosSucursal['tipo']);
                $this->db->set('notas', $datosSucursal['notas']);
                $this->db->set('modifica', $date_now);
                $this->db->where('idrnum', $datosSucursal['idrnum']);
                $result = $this->db->update('sc_sucs');
                
                if($result){
                    header("HTTP/1.1 200 OK");
                    $result = "editado";
                    $mensaje = "La sucursal se ha editado exitosamente.";
                    $datos = true;
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al agregar la sucursal.";
                    $datos = false;
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $datosUnicos['mensaje'];
                $datos = false; 
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }

        function eliminarSucursal($datosSucursal, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  

            if($this->sucursalPoseeCaja($datosSucursal)){
                header("HTTP/1.1 401 Unauthorized");
                $result = "poseecaja";
                $mensaje ="La sucursal posee cajas activas.";
                $datos = false;
            }else{
                $this->db->where('idrnum', $datosSucursal['idrnum']);
                $result = $this->db->delete('sc_sucs');

                if($result){
                    header("HTTP/1.1 200 OK");
                    $result = "eliminado";
                    $mensaje = "La sucursal se ha eliminado exitosamente.";
                    $datos = true;
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al eliminar la sucursal.";
                    $datos = false;
                }
            }
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }

        function verSucursal($datosSucursal, $token){
            $idrnum = $datosSucursal['idrnum'];
            $consulta = "SELECT idrnum, idcentro, idaccount, descrip, tipo, notas, case tipo
                                                                                        when 1 then 'Sala de Ventas'
                                                                                        when 2 then 'Oficina'
                                                                                        when 3 then 'Centro de Distribución'
                                                                                    end as tiponombre 
                        FROM sc_sucs
                        WHERE idrnum = $idrnum
                        LIMIT 1";

            $query = $this->db->query($consulta);
            $datos = $query->row_array();
         
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }

            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function verificarDatosUnicosSucursal($datosUsuario, $datosSucursal, $tipo){
            $mensaje = "";
            $valido = true;

            if($tipo === "create"){
                $this->db->select('1');
                $this->db->from('sc_sucs');
                $this->db->where('descrip', $datosSucursal['descrip']);
                $this->db->where('idaccount', $datosSucursal['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre de la sucursal ya está en uso. \n";
                    $valido = false;
                }

            }else if($tipo === "update"){
                $this->db->select('1');
                $this->db->from('sc_sucs');
                $this->db->where('descrip', $datosSucursal['descrip']);
                $this->db->where('idaccount', $datosSucursal['idaccount']);
                $this->db->where('idrnum !=', $datosSucursal['idrnum']);


                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre de la sucursal ya está en uso. \n";
                    $valido = false;
                }
            }
            return ['mensaje' => $mensaje, 'valido' => $valido];
        }

        function sucursalPoseeCaja($datosSucursal){
            $this->db->select('1 as result');
            $this->db->from('sc_cajas');
            $this->db->where('idcentro',  $datosSucursal['idcentro']);
            $this->db->where('idaccount',  $datosSucursal['idaccount']);

            $Query = $this->db->get()->row_array();
            if($Query['result'] === '1'){
                return true;
            }
            return false;
        }

        ##################################       CAJAS      ##################################

        function listarCajas($datosUsuario, $token){
            $idaccount = $datosUsuario['idaccount'];
            $consulta = "SELECT caja.idrnum, caja.idcentro, caja.idcaja, caja.idaccount, caja.descrip, caja.ucajera, caja.cajafondo, caja.resolucion, caja.fresolucion, caja.equipo,
                                suc.descrip AS sucdescrip, caja.estado
                        FROM sc_cajas caja
                        INNER JOIN sc_sucs as suc
                        ON suc.idcentro = caja.idcentro AND suc.idaccount = caja.idaccount
                        WHERE caja.idaccount = $idaccount AND caja.estado = 1
                        
                        ORDER BY idcentro"; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->result_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function listarCajasBySucursal($datosSucursal){
            $idaccount = $datosSucursal['idaccount'];
            $idcentro = $datosSucursal['idcentro'];

            $consulta = "SELECT caja.idrnum, caja.idcentro, caja.idcaja, caja.idaccount, caja.descrip, caja.ucajera, caja.cajafondo, caja.resolucion, caja.fresolucion, caja.equipo
                        FROM sc_cajas caja
                        WHERE caja.idaccount = $idaccount AND caja.estado = 1 AND caja.idcentro = $idcentro
                        
                        ORDER BY idcentro"; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->result_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function listarCajasAll($datosUsuario, $token){
            $idaccount = $datosUsuario['idaccount'];
            
            $consulta = "SELECT caja.idrnum, caja.idcentro, caja.idcaja, caja.idaccount, caja.descrip, caja.ucajera, caja.cajafondo, caja.resolucion, caja.fresolucion, caja.equipo,
                                suc.descrip AS sucdescrip, caja.estado, case caja.estado when 1 then 'Activa' when 0 then 'Inactiva' end as estadodescrip
                        FROM sc_cajas caja
                        INNER JOIN sc_sucs as suc
                        ON suc.idcentro = caja.idcentro AND suc.idaccount = caja.idaccount
                        WHERE caja.idaccount = $idaccount
                        
                        ORDER BY idcentro"; 
                        
            $query = $this->db->query($consulta);
            $datos = $query->result_array();
            $mensaje = "";

            if($datos != "" && $datos != null){
                header("HTTP/1.1 200 OK");
                $resultado = "ok";
                $mensaje = "";

            }else{
                header("HTTP/1.1 200 OK");
                $datos = false;
                $resultado = "vacio";
                $mensaje = "";

            }
            return json_encode(['resultado'=> $resultado, 'mensaje' => $mensaje,'datos' => $datos]);
        }

        function crearCaja($datosCaja, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  
            
            $datosUnicos = $this->verificarDatosUnicosCaja($datosCaja, "create");
            if($datosUnicos['valido']){
                $this->db->set('idaccount', $datosCaja['idaccount']);
                $this->db->set('idcentro', $datosCaja['idcentro']);
                $this->db->set('descrip', $datosCaja['descrip']);
                $this->db->set('cajafondo', $datosCaja['cajafondo']);
                $this->db->set('ucajera', $datosCaja['ucajera']);
                $this->db->set('resolucion', $datosCaja['resolucion']);
                $this->db->set('fresolucion', $datosCaja['fresolucion']);
                $this->db->set('equipo', $datosCaja['equipo']);
                $this->db->set('whodidit', $datosCaja['whodidit']);
                $this->db->set('ingresa', $date_now);
                $this->db->set('estado', 1);


                $result = $this->db->insert('sc_cajas');
                $id = $this->db->insert_id();
                
                if($result){
                    $this->db->select('COUNT(idaccount) as idcaja');
                    $this->db->from('sc_cajas');
                    $this->db->where('idaccount', $datosCaja['idaccount']);

                    $this->db->limit(1);
                    $query = $this->db->get()->row_array();

                    $this->db->set('idcaja', (int)$query['idcaja']);
                    $this->db->from('sc_cajas');
                    $this->db->where('idrnum', $id);
                    $this->db->update('sc_cajas');

                    header("HTTP/1.1 200 OK");
                    $result = "agregado";
                    $mensaje = "La caja se ha agregado exitosamente.";
                    $datos = true;
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al agregar la caja.";
                    $datos = false;
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $datosUnicos['mensaje'];
                $datos = false; 
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }

        function editarCaja($datosCaja, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  
            
            $datosUnicos = $this->verificarDatosUnicosCaja($datosCaja, "update");
            if($datosUnicos['valido']){
                $this->db->set('idcentro', $datosCaja['idcentro']);
                $this->db->set('descrip', $datosCaja['descrip']);
                $this->db->set('cajafondo', $datosCaja['cajafondo']);
                $this->db->set('ucajera', $datosCaja['ucajera']);
                $this->db->set('resolucion', $datosCaja['resolucion']);
                $this->db->set('fresolucion', $datosCaja['fresolucion']);
                $this->db->set('equipo', $datosCaja['equipo']);
                $this->db->set('modifica', $date_now);
                $this->db->where('idrnum', $datosCaja['idrnum']);

                $result = $this->db->update('sc_cajas');
                
                if($result){
                    

                    header("HTTP/1.1 200 OK");
                    $result = "editado";
                    $mensaje = "La caja se ha editado exitosamente.";
                    $datos = true;
                }else{
                    header("HTTP/1.1 401 Unauthorized");
                    $result = "error";
                    $mensaje ="Hubo un error al agregar la caja.";
                    $datos = false;
                }
            }else{
                header("HTTP/1.1 422 Unprocessable Entity");
                $result = "duplicado";
                $mensaje = $datosUnicos['mensaje'];
                $datos = false; 
            }
            
            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }
   
        function eliminarCaja($datosCaja, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  

            $this->db->where('idrnum', $datosCaja['idrnum']);

            $result = $this->db->delete('sc_cajas');
            if($result){
                header("HTTP/1.1 200 OK");
                $result = "eliminado";
                $mensaje = "La caja se ha eliminado exitosamente.";
                $datos = true;
            }else{
                header("HTTP/1.1 401 Unauthorized");
                $result = "error";
                $mensaje ="Hubo un error al eliminar la caja.";
                $datos = false;
            }

            return json_encode(['resultado'=> $result, 'mensaje' => $mensaje, 'datos' => $datos]);
        }

        function verCaja($verCaja, $token){
            $date_now = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_now = $date_now->format("Y-m-d h:i:s");  

            $sucursal = $this->obtenerSucursal($verCaja, $token);
            $caja = $this->listarCajasSucursal($verCaja, $token);

            return json_encode(['sucursal'=> $sucursal, 'caja' => $caja]);
        }
        
        function verificarDatosUnicosCaja($datosCaja, $tipo){
            $mensaje = "";
            $valido = true;

            if($tipo === "create"){
                $this->db->select('1');
                $this->db->from('sc_cajas');
                $this->db->where('descrip', $datosCaja['descrip']);
                $this->db->where('idaccount', $datosCaja['idaccount']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre de la caja ya está en uso. \n";
                    $valido = false;
                }

                $this->db->select('1');
                $this->db->from('sc_cajas');
                $this->db->where('resolucion', $datosCaja['resolucion']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "La resolucion ya está en uso. \n";
                    $valido = false;
                }

            }else if($tipo === "update"){
                $this->db->select('1');
                $this->db->from('sc_cajas');
                $this->db->where('descrip', $datosCaja['descrip']);
                $this->db->where('idaccount', $datosCaja['idaccount']);
                $this->db->where('idrnum !=', $datosCaja['idrnum']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "El nombre de la caja ya está en uso. \n";
                    $valido = false;
                }

                $this->db->select('1');
                $this->db->from('sc_cajas');
                $this->db->where('resolucion', $datosCaja['resolucion']);
                $this->db->where('idrnum !=', $datosCaja['idrnum']);

                $this->db->limit(1);
                $Query = $this->db->get();
                if($Query->num_rows() != 0){
                    $mensaje .= "La resolucion ya está en uso. \n";
                    $valido = false;
                }
            }
            return ['mensaje' => $mensaje, 'valido' => $valido];
        }

    }
?>